// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub fn parse_http_generic_error(
    response: &http::Response<bytes::Bytes>,
) -> Result<aws_smithy_types::Error, aws_smithy_xml::decode::XmlError> {
    if response.body().is_empty() {
        let mut err = aws_smithy_types::Error::builder();
        if response.status().as_u16() == 404 {
            err.code("NotFound");
        }
        Ok(err.build())
    } else {
        let base_err =
            crate::rest_xml_unwrapped_errors::parse_generic_error(response.body().as_ref())?;
        Ok(crate::s3_errors::parse_extended_error(
            base_err,
            response.headers(),
        ))
    }
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_no_such_upload_xml_err(
    inp: &[u8],
    mut builder: crate::error::no_such_upload::Builder,
) -> Result<crate::error::no_such_upload::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_unwrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.s3#NoSuchUpload$message */ =>  {
                let var_1 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_1);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_complete_multipart_upload(
    inp: &[u8],
    mut builder: crate::output::complete_multipart_upload_output::Builder,
) -> Result<
    crate::output::complete_multipart_upload_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CompleteMultipartUploadResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CompleteMultipartUploadResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Bucket") /* Bucket com.amazonaws.s3.synthetic#CompleteMultipartUploadOutput$Bucket */ =>  {
                let var_2 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_bucket(var_2);
            }
            ,
            s if s.matches("ETag") /* ETag com.amazonaws.s3.synthetic#CompleteMultipartUploadOutput$ETag */ =>  {
                let var_3 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_e_tag(var_3);
            }
            ,
            s if s.matches("Key") /* Key com.amazonaws.s3.synthetic#CompleteMultipartUploadOutput$Key */ =>  {
                let var_4 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_key(var_4);
            }
            ,
            s if s.matches("Location") /* Location com.amazonaws.s3.synthetic#CompleteMultipartUploadOutput$Location */ =>  {
                let var_5 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_location(var_5);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_object_not_in_active_tier_error_xml_err(
    inp: &[u8],
    mut builder: crate::error::object_not_in_active_tier_error::Builder,
) -> Result<crate::error::object_not_in_active_tier_error::Builder, aws_smithy_xml::decode::XmlError>
{
    if inp.is_empty() {
        return Ok(builder);
    }
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_unwrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.s3#ObjectNotInActiveTierError$message */ =>  {
                let var_6 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_6);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_bucket_already_exists_xml_err(
    inp: &[u8],
    mut builder: crate::error::bucket_already_exists::Builder,
) -> Result<crate::error::bucket_already_exists::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_unwrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.s3#BucketAlreadyExists$message */ =>  {
                let var_7 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_7);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_bucket_already_owned_by_you_xml_err(
    inp: &[u8],
    mut builder: crate::error::bucket_already_owned_by_you::Builder,
) -> Result<crate::error::bucket_already_owned_by_you::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_unwrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.s3#BucketAlreadyOwnedByYou$message */ =>  {
                let var_8 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_8);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_multipart_upload(
    inp: &[u8],
    mut builder: crate::output::create_multipart_upload_output::Builder,
) -> Result<crate::output::create_multipart_upload_output::Builder, aws_smithy_xml::decode::XmlError>
{
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("InitiateMultipartUploadResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected InitiateMultipartUploadResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Bucket") /* Bucket com.amazonaws.s3.synthetic#CreateMultipartUploadOutput$Bucket */ =>  {
                let var_9 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_bucket(var_9);
            }
            ,
            s if s.matches("Key") /* Key com.amazonaws.s3.synthetic#CreateMultipartUploadOutput$Key */ =>  {
                let var_10 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_key(var_10);
            }
            ,
            s if s.matches("UploadId") /* UploadId com.amazonaws.s3.synthetic#CreateMultipartUploadOutput$UploadId */ =>  {
                let var_11 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_upload_id(var_11);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_objects(
    inp: &[u8],
    mut builder: crate::output::delete_objects_output::Builder,
) -> Result<crate::output::delete_objects_output::Builder, aws_smithy_xml::decode::XmlError> {
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Error") /* Errors com.amazonaws.s3.synthetic#DeleteObjectsOutput$Errors */ =>  {
                let var_12 =
                    Some(
                        Result::<std::vec::Vec<crate::model::Error>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_13 = builder.errors.take().unwrap_or_default();
                            list_13.push(
                                crate::xml_deser::deser_structure_crate_model_error(&mut tag)
                                ?
                            );
                            list_13
                        })
                        ?
                    )
                ;
                builder = builder.set_errors(var_12);
            }
            ,
            s if s.matches("Deleted") /* Deleted com.amazonaws.s3.synthetic#DeleteObjectsOutput$Deleted */ =>  {
                let var_14 =
                    Some(
                        Result::<std::vec::Vec<crate::model::DeletedObject>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_15 = builder.deleted.take().unwrap_or_default();
                            list_15.push(
                                crate::xml_deser::deser_structure_crate_model_deleted_object(&mut tag)
                                ?
                            );
                            list_15
                        })
                        ?
                    )
                ;
                builder = builder.set_deleted(var_14);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_bucket_accelerate_configuration(
    inp: &[u8],
    mut builder: crate::output::get_bucket_accelerate_configuration_output::Builder,
) -> Result<
    crate::output::get_bucket_accelerate_configuration_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("AccelerateConfiguration")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected AccelerateConfiguration got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Status") /* Status com.amazonaws.s3.synthetic#GetBucketAccelerateConfigurationOutput$Status */ =>  {
                let var_16 =
                    Some(
                        Result::<crate::model::BucketAccelerateStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::BucketAccelerateStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_16);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_bucket_acl(
    inp: &[u8],
    mut builder: crate::output::get_bucket_acl_output::Builder,
) -> Result<crate::output::get_bucket_acl_output::Builder, aws_smithy_xml::decode::XmlError> {
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("AccessControlPolicy")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected AccessControlPolicy got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Owner") /* Owner com.amazonaws.s3.synthetic#GetBucketAclOutput$Owner */ =>  {
                let var_17 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_owner(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_owner(var_17);
            }
            ,
            s if s.matches("AccessControlList") /* Grants com.amazonaws.s3.synthetic#GetBucketAclOutput$Grants */ =>  {
                let var_18 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_s3_grants(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_grants(var_18);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_bucket_cors(
    inp: &[u8],
    mut builder: crate::output::get_bucket_cors_output::Builder,
) -> Result<crate::output::get_bucket_cors_output::Builder, aws_smithy_xml::decode::XmlError> {
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CORSConfiguration")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CORSConfiguration got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("CORSRule") /* CORSRules com.amazonaws.s3.synthetic#GetBucketCorsOutput$CORSRules */ =>  {
                let var_19 =
                    Some(
                        Result::<std::vec::Vec<crate::model::CorsRule>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_20 = builder.cors_rules.take().unwrap_or_default();
                            list_20.push(
                                crate::xml_deser::deser_structure_crate_model_cors_rule(&mut tag)
                                ?
                            );
                            list_20
                        })
                        ?
                    )
                ;
                builder = builder.set_cors_rules(var_19);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_bucket_lifecycle_configuration(
    inp: &[u8],
    mut builder: crate::output::get_bucket_lifecycle_configuration_output::Builder,
) -> Result<
    crate::output::get_bucket_lifecycle_configuration_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("LifecycleConfiguration")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected LifecycleConfiguration got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Rule") /* Rules com.amazonaws.s3.synthetic#GetBucketLifecycleConfigurationOutput$Rules */ =>  {
                let var_21 =
                    Some(
                        Result::<std::vec::Vec<crate::model::LifecycleRule>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_22 = builder.rules.take().unwrap_or_default();
                            list_22.push(
                                crate::xml_deser::deser_structure_crate_model_lifecycle_rule(&mut tag)
                                ?
                            );
                            list_22
                        })
                        ?
                    )
                ;
                builder = builder.set_rules(var_21);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_bucket_location(
    inp: &[u8],
    mut builder: crate::output::get_bucket_location_output::Builder,
) -> Result<crate::output::get_bucket_location_output::Builder, aws_smithy_xml::decode::XmlError> {
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    match start_el {
        s if s.matches("LocationConstraint") /* LocationConstraint com.amazonaws.s3.synthetic#GetBucketLocationOutput$LocationConstraint */ =>  {
            let var_23 =
                Some(
                    Result::<crate::model::BucketLocationConstraint, aws_smithy_xml::decode::XmlError>::Ok(
                        crate::model::BucketLocationConstraint::from(
                            aws_smithy_xml::decode::try_data(&mut decoder)?.as_ref()
                        )
                    )
                    ?
                )
            ;
            builder = builder.set_location_constraint(var_23);
        }
        ,
        _ => return Err(aws_smithy_xml::decode::XmlError::custom("expected LocationConstraint tag"))
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_bucket_logging(
    inp: &[u8],
    mut builder: crate::output::get_bucket_logging_output::Builder,
) -> Result<crate::output::get_bucket_logging_output::Builder, aws_smithy_xml::decode::XmlError> {
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("BucketLoggingStatus")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected BucketLoggingStatus got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("LoggingEnabled") /* LoggingEnabled com.amazonaws.s3.synthetic#GetBucketLoggingOutput$LoggingEnabled */ =>  {
                let var_24 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_logging_enabled(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_logging_enabled(var_24);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_bucket_notification_configuration(
    inp: &[u8],
    mut builder: crate::output::get_bucket_notification_configuration_output::Builder,
) -> Result<
    crate::output::get_bucket_notification_configuration_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("NotificationConfiguration")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected NotificationConfiguration got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("CloudFunctionConfiguration") /* LambdaFunctionConfigurations com.amazonaws.s3.synthetic#GetBucketNotificationConfigurationOutput$LambdaFunctionConfigurations */ =>  {
                let var_25 =
                    Some(
                        Result::<std::vec::Vec<crate::model::LambdaFunctionConfiguration>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_26 = builder.lambda_function_configurations.take().unwrap_or_default();
                            list_26.push(
                                crate::xml_deser::deser_structure_crate_model_lambda_function_configuration(&mut tag)
                                ?
                            );
                            list_26
                        })
                        ?
                    )
                ;
                builder = builder.set_lambda_function_configurations(var_25);
            }
            ,
            s if s.matches("TopicConfiguration") /* TopicConfigurations com.amazonaws.s3.synthetic#GetBucketNotificationConfigurationOutput$TopicConfigurations */ =>  {
                let var_27 =
                    Some(
                        Result::<std::vec::Vec<crate::model::TopicConfiguration>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_28 = builder.topic_configurations.take().unwrap_or_default();
                            list_28.push(
                                crate::xml_deser::deser_structure_crate_model_topic_configuration(&mut tag)
                                ?
                            );
                            list_28
                        })
                        ?
                    )
                ;
                builder = builder.set_topic_configurations(var_27);
            }
            ,
            s if s.matches("QueueConfiguration") /* QueueConfigurations com.amazonaws.s3.synthetic#GetBucketNotificationConfigurationOutput$QueueConfigurations */ =>  {
                let var_29 =
                    Some(
                        Result::<std::vec::Vec<crate::model::QueueConfiguration>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_30 = builder.queue_configurations.take().unwrap_or_default();
                            list_30.push(
                                crate::xml_deser::deser_structure_crate_model_queue_configuration(&mut tag)
                                ?
                            );
                            list_30
                        })
                        ?
                    )
                ;
                builder = builder.set_queue_configurations(var_29);
            }
            ,
            s if s.matches("EventBridgeConfiguration") /* EventBridgeConfiguration com.amazonaws.s3.synthetic#GetBucketNotificationConfigurationOutput$EventBridgeConfiguration */ =>  {
                let var_31 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_event_bridge_configuration(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_event_bridge_configuration(var_31);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_bucket_request_payment(
    inp: &[u8],
    mut builder: crate::output::get_bucket_request_payment_output::Builder,
) -> Result<
    crate::output::get_bucket_request_payment_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("RequestPaymentConfiguration")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected RequestPaymentConfiguration got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Payer") /* Payer com.amazonaws.s3.synthetic#GetBucketRequestPaymentOutput$Payer */ =>  {
                let var_32 =
                    Some(
                        Result::<crate::model::Payer, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::Payer::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_payer(var_32);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_bucket_tagging(
    inp: &[u8],
    mut builder: crate::output::get_bucket_tagging_output::Builder,
) -> Result<crate::output::get_bucket_tagging_output::Builder, aws_smithy_xml::decode::XmlError> {
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("Tagging")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected Tagging got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("TagSet") /* TagSet com.amazonaws.s3.synthetic#GetBucketTaggingOutput$TagSet */ =>  {
                let var_33 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_s3_tag_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tag_set(var_33);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_bucket_versioning(
    inp: &[u8],
    mut builder: crate::output::get_bucket_versioning_output::Builder,
) -> Result<crate::output::get_bucket_versioning_output::Builder, aws_smithy_xml::decode::XmlError>
{
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("VersioningConfiguration")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected VersioningConfiguration got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Status") /* Status com.amazonaws.s3.synthetic#GetBucketVersioningOutput$Status */ =>  {
                let var_34 =
                    Some(
                        Result::<crate::model::BucketVersioningStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::BucketVersioningStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_34);
            }
            ,
            s if s.matches("MfaDelete") /* MFADelete com.amazonaws.s3.synthetic#GetBucketVersioningOutput$MFADelete */ =>  {
                let var_35 =
                    Some(
                        Result::<crate::model::MfaDeleteStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::MfaDeleteStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_mfa_delete(var_35);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_bucket_website(
    inp: &[u8],
    mut builder: crate::output::get_bucket_website_output::Builder,
) -> Result<crate::output::get_bucket_website_output::Builder, aws_smithy_xml::decode::XmlError> {
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("WebsiteConfiguration")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected WebsiteConfiguration got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("IndexDocument") /* IndexDocument com.amazonaws.s3.synthetic#GetBucketWebsiteOutput$IndexDocument */ =>  {
                let var_36 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_index_document(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_index_document(var_36);
            }
            ,
            s if s.matches("RedirectAllRequestsTo") /* RedirectAllRequestsTo com.amazonaws.s3.synthetic#GetBucketWebsiteOutput$RedirectAllRequestsTo */ =>  {
                let var_37 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_redirect_all_requests_to(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_redirect_all_requests_to(var_37);
            }
            ,
            s if s.matches("RoutingRules") /* RoutingRules com.amazonaws.s3.synthetic#GetBucketWebsiteOutput$RoutingRules */ =>  {
                let var_38 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_s3_routing_rules(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_routing_rules(var_38);
            }
            ,
            s if s.matches("ErrorDocument") /* ErrorDocument com.amazonaws.s3.synthetic#GetBucketWebsiteOutput$ErrorDocument */ =>  {
                let var_39 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_error_document(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_error_document(var_39);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_object_state_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_object_state::Builder,
) -> Result<crate::error::invalid_object_state::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_unwrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("StorageClass") /* StorageClass com.amazonaws.s3#InvalidObjectState$StorageClass */ =>  {
                let var_40 =
                    Some(
                        Result::<crate::model::StorageClass, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::StorageClass::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_storage_class(var_40);
            }
            ,
            s if s.matches("AccessTier") /* AccessTier com.amazonaws.s3#InvalidObjectState$AccessTier */ =>  {
                let var_41 =
                    Some(
                        Result::<crate::model::IntelligentTieringAccessTier, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::IntelligentTieringAccessTier::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_access_tier(var_41);
            }
            ,
            s if s.matches("message") /* message com.amazonaws.s3#InvalidObjectState$message */ =>  {
                let var_42 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_42);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_no_such_key_xml_err(
    inp: &[u8],
    mut builder: crate::error::no_such_key::Builder,
) -> Result<crate::error::no_such_key::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_unwrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.s3#NoSuchKey$message */ =>  {
                let var_43 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_43);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_object_acl(
    inp: &[u8],
    mut builder: crate::output::get_object_acl_output::Builder,
) -> Result<crate::output::get_object_acl_output::Builder, aws_smithy_xml::decode::XmlError> {
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("AccessControlPolicy")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected AccessControlPolicy got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Owner") /* Owner com.amazonaws.s3.synthetic#GetObjectAclOutput$Owner */ =>  {
                let var_44 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_owner(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_owner(var_44);
            }
            ,
            s if s.matches("AccessControlList") /* Grants com.amazonaws.s3.synthetic#GetObjectAclOutput$Grants */ =>  {
                let var_45 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_s3_grants(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_grants(var_45);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_object_tagging(
    inp: &[u8],
    mut builder: crate::output::get_object_tagging_output::Builder,
) -> Result<crate::output::get_object_tagging_output::Builder, aws_smithy_xml::decode::XmlError> {
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("Tagging")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected Tagging got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("TagSet") /* TagSet com.amazonaws.s3.synthetic#GetObjectTaggingOutput$TagSet */ =>  {
                let var_46 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_s3_tag_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tag_set(var_46);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_not_found_xml_err(
    inp: &[u8],
    mut builder: crate::error::not_found::Builder,
) -> Result<crate::error::not_found::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_unwrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.s3#NotFound$message */ =>  {
                let var_47 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_47);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_bucket_analytics_configurations(
    inp: &[u8],
    mut builder: crate::output::list_bucket_analytics_configurations_output::Builder,
) -> Result<
    crate::output::list_bucket_analytics_configurations_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListBucketAnalyticsConfigurationResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListBucketAnalyticsConfigurationResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("NextContinuationToken") /* NextContinuationToken com.amazonaws.s3.synthetic#ListBucketAnalyticsConfigurationsOutput$NextContinuationToken */ =>  {
                let var_48 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_continuation_token(var_48);
            }
            ,
            s if s.matches("ContinuationToken") /* ContinuationToken com.amazonaws.s3.synthetic#ListBucketAnalyticsConfigurationsOutput$ContinuationToken */ =>  {
                let var_49 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_continuation_token(var_49);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.s3.synthetic#ListBucketAnalyticsConfigurationsOutput$IsTruncated */ =>  {
                let var_50 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.s3#IsTruncated`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_50);
            }
            ,
            s if s.matches("AnalyticsConfiguration") /* AnalyticsConfigurationList com.amazonaws.s3.synthetic#ListBucketAnalyticsConfigurationsOutput$AnalyticsConfigurationList */ =>  {
                let var_51 =
                    Some(
                        Result::<std::vec::Vec<crate::model::AnalyticsConfiguration>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_52 = builder.analytics_configuration_list.take().unwrap_or_default();
                            list_52.push(
                                crate::xml_deser::deser_structure_crate_model_analytics_configuration(&mut tag)
                                ?
                            );
                            list_52
                        })
                        ?
                    )
                ;
                builder = builder.set_analytics_configuration_list(var_51);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_bucket_intelligent_tiering_configurations(
    inp: &[u8],
    mut builder: crate::output::list_bucket_intelligent_tiering_configurations_output::Builder,
) -> Result<
    crate::output::list_bucket_intelligent_tiering_configurations_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListBucketIntelligentTieringConfigurationsOutput")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListBucketIntelligentTieringConfigurationsOutput got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("IntelligentTieringConfiguration") /* IntelligentTieringConfigurationList com.amazonaws.s3.synthetic#ListBucketIntelligentTieringConfigurationsOutput$IntelligentTieringConfigurationList */ =>  {
                let var_53 =
                    Some(
                        Result::<std::vec::Vec<crate::model::IntelligentTieringConfiguration>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_54 = builder.intelligent_tiering_configuration_list.take().unwrap_or_default();
                            list_54.push(
                                crate::xml_deser::deser_structure_crate_model_intelligent_tiering_configuration(&mut tag)
                                ?
                            );
                            list_54
                        })
                        ?
                    )
                ;
                builder = builder.set_intelligent_tiering_configuration_list(var_53);
            }
            ,
            s if s.matches("NextContinuationToken") /* NextContinuationToken com.amazonaws.s3.synthetic#ListBucketIntelligentTieringConfigurationsOutput$NextContinuationToken */ =>  {
                let var_55 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_continuation_token(var_55);
            }
            ,
            s if s.matches("ContinuationToken") /* ContinuationToken com.amazonaws.s3.synthetic#ListBucketIntelligentTieringConfigurationsOutput$ContinuationToken */ =>  {
                let var_56 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_continuation_token(var_56);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.s3.synthetic#ListBucketIntelligentTieringConfigurationsOutput$IsTruncated */ =>  {
                let var_57 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.s3#IsTruncated`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_57);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_bucket_inventory_configurations(
    inp: &[u8],
    mut builder: crate::output::list_bucket_inventory_configurations_output::Builder,
) -> Result<
    crate::output::list_bucket_inventory_configurations_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListInventoryConfigurationsResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListInventoryConfigurationsResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("NextContinuationToken") /* NextContinuationToken com.amazonaws.s3.synthetic#ListBucketInventoryConfigurationsOutput$NextContinuationToken */ =>  {
                let var_58 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_continuation_token(var_58);
            }
            ,
            s if s.matches("ContinuationToken") /* ContinuationToken com.amazonaws.s3.synthetic#ListBucketInventoryConfigurationsOutput$ContinuationToken */ =>  {
                let var_59 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_continuation_token(var_59);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.s3.synthetic#ListBucketInventoryConfigurationsOutput$IsTruncated */ =>  {
                let var_60 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.s3#IsTruncated`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_60);
            }
            ,
            s if s.matches("InventoryConfiguration") /* InventoryConfigurationList com.amazonaws.s3.synthetic#ListBucketInventoryConfigurationsOutput$InventoryConfigurationList */ =>  {
                let var_61 =
                    Some(
                        Result::<std::vec::Vec<crate::model::InventoryConfiguration>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_62 = builder.inventory_configuration_list.take().unwrap_or_default();
                            list_62.push(
                                crate::xml_deser::deser_structure_crate_model_inventory_configuration(&mut tag)
                                ?
                            );
                            list_62
                        })
                        ?
                    )
                ;
                builder = builder.set_inventory_configuration_list(var_61);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_bucket_metrics_configurations(
    inp: &[u8],
    mut builder: crate::output::list_bucket_metrics_configurations_output::Builder,
) -> Result<
    crate::output::list_bucket_metrics_configurations_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListMetricsConfigurationsResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListMetricsConfigurationsResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("NextContinuationToken") /* NextContinuationToken com.amazonaws.s3.synthetic#ListBucketMetricsConfigurationsOutput$NextContinuationToken */ =>  {
                let var_63 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_continuation_token(var_63);
            }
            ,
            s if s.matches("ContinuationToken") /* ContinuationToken com.amazonaws.s3.synthetic#ListBucketMetricsConfigurationsOutput$ContinuationToken */ =>  {
                let var_64 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_continuation_token(var_64);
            }
            ,
            s if s.matches("MetricsConfiguration") /* MetricsConfigurationList com.amazonaws.s3.synthetic#ListBucketMetricsConfigurationsOutput$MetricsConfigurationList */ =>  {
                let var_65 =
                    Some(
                        Result::<std::vec::Vec<crate::model::MetricsConfiguration>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_66 = builder.metrics_configuration_list.take().unwrap_or_default();
                            list_66.push(
                                crate::xml_deser::deser_structure_crate_model_metrics_configuration(&mut tag)
                                ?
                            );
                            list_66
                        })
                        ?
                    )
                ;
                builder = builder.set_metrics_configuration_list(var_65);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.s3.synthetic#ListBucketMetricsConfigurationsOutput$IsTruncated */ =>  {
                let var_67 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.s3#IsTruncated`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_67);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_buckets(
    inp: &[u8],
    mut builder: crate::output::list_buckets_output::Builder,
) -> Result<crate::output::list_buckets_output::Builder, aws_smithy_xml::decode::XmlError> {
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListAllMyBucketsResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListAllMyBucketsResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Owner") /* Owner com.amazonaws.s3.synthetic#ListBucketsOutput$Owner */ =>  {
                let var_68 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_owner(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_owner(var_68);
            }
            ,
            s if s.matches("Buckets") /* Buckets com.amazonaws.s3.synthetic#ListBucketsOutput$Buckets */ =>  {
                let var_69 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_s3_buckets(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_buckets(var_69);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_multipart_uploads(
    inp: &[u8],
    mut builder: crate::output::list_multipart_uploads_output::Builder,
) -> Result<crate::output::list_multipart_uploads_output::Builder, aws_smithy_xml::decode::XmlError>
{
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListMultipartUploadsResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListMultipartUploadsResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("CommonPrefixes") /* CommonPrefixes com.amazonaws.s3.synthetic#ListMultipartUploadsOutput$CommonPrefixes */ =>  {
                let var_70 =
                    Some(
                        Result::<std::vec::Vec<crate::model::CommonPrefix>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_71 = builder.common_prefixes.take().unwrap_or_default();
                            list_71.push(
                                crate::xml_deser::deser_structure_crate_model_common_prefix(&mut tag)
                                ?
                            );
                            list_71
                        })
                        ?
                    )
                ;
                builder = builder.set_common_prefixes(var_70);
            }
            ,
            s if s.matches("UploadIdMarker") /* UploadIdMarker com.amazonaws.s3.synthetic#ListMultipartUploadsOutput$UploadIdMarker */ =>  {
                let var_72 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_upload_id_marker(var_72);
            }
            ,
            s if s.matches("NextKeyMarker") /* NextKeyMarker com.amazonaws.s3.synthetic#ListMultipartUploadsOutput$NextKeyMarker */ =>  {
                let var_73 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_key_marker(var_73);
            }
            ,
            s if s.matches("NextUploadIdMarker") /* NextUploadIdMarker com.amazonaws.s3.synthetic#ListMultipartUploadsOutput$NextUploadIdMarker */ =>  {
                let var_74 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_upload_id_marker(var_74);
            }
            ,
            s if s.matches("Delimiter") /* Delimiter com.amazonaws.s3.synthetic#ListMultipartUploadsOutput$Delimiter */ =>  {
                let var_75 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_delimiter(var_75);
            }
            ,
            s if s.matches("Upload") /* Uploads com.amazonaws.s3.synthetic#ListMultipartUploadsOutput$Uploads */ =>  {
                let var_76 =
                    Some(
                        Result::<std::vec::Vec<crate::model::MultipartUpload>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_77 = builder.uploads.take().unwrap_or_default();
                            list_77.push(
                                crate::xml_deser::deser_structure_crate_model_multipart_upload(&mut tag)
                                ?
                            );
                            list_77
                        })
                        ?
                    )
                ;
                builder = builder.set_uploads(var_76);
            }
            ,
            s if s.matches("Bucket") /* Bucket com.amazonaws.s3.synthetic#ListMultipartUploadsOutput$Bucket */ =>  {
                let var_78 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_bucket(var_78);
            }
            ,
            s if s.matches("MaxUploads") /* MaxUploads com.amazonaws.s3.synthetic#ListMultipartUploadsOutput$MaxUploads */ =>  {
                let var_79 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.s3#MaxUploads`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_max_uploads(var_79);
            }
            ,
            s if s.matches("EncodingType") /* EncodingType com.amazonaws.s3.synthetic#ListMultipartUploadsOutput$EncodingType */ =>  {
                let var_80 =
                    Some(
                        Result::<crate::model::EncodingType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::EncodingType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_encoding_type(var_80);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.s3.synthetic#ListMultipartUploadsOutput$IsTruncated */ =>  {
                let var_81 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.s3#IsTruncated`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_81);
            }
            ,
            s if s.matches("Prefix") /* Prefix com.amazonaws.s3.synthetic#ListMultipartUploadsOutput$Prefix */ =>  {
                let var_82 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_prefix(var_82);
            }
            ,
            s if s.matches("KeyMarker") /* KeyMarker com.amazonaws.s3.synthetic#ListMultipartUploadsOutput$KeyMarker */ =>  {
                let var_83 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_key_marker(var_83);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_no_such_bucket_xml_err(
    inp: &[u8],
    mut builder: crate::error::no_such_bucket::Builder,
) -> Result<crate::error::no_such_bucket::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_unwrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.s3#NoSuchBucket$message */ =>  {
                let var_84 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_84);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_objects(
    inp: &[u8],
    mut builder: crate::output::list_objects_output::Builder,
) -> Result<crate::output::list_objects_output::Builder, aws_smithy_xml::decode::XmlError> {
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListBucketResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListBucketResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("CommonPrefixes") /* CommonPrefixes com.amazonaws.s3.synthetic#ListObjectsOutput$CommonPrefixes */ =>  {
                let var_85 =
                    Some(
                        Result::<std::vec::Vec<crate::model::CommonPrefix>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_86 = builder.common_prefixes.take().unwrap_or_default();
                            list_86.push(
                                crate::xml_deser::deser_structure_crate_model_common_prefix(&mut tag)
                                ?
                            );
                            list_86
                        })
                        ?
                    )
                ;
                builder = builder.set_common_prefixes(var_85);
            }
            ,
            s if s.matches("Contents") /* Contents com.amazonaws.s3.synthetic#ListObjectsOutput$Contents */ =>  {
                let var_87 =
                    Some(
                        Result::<std::vec::Vec<crate::model::Object>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_88 = builder.contents.take().unwrap_or_default();
                            list_88.push(
                                crate::xml_deser::deser_structure_crate_model_object(&mut tag)
                                ?
                            );
                            list_88
                        })
                        ?
                    )
                ;
                builder = builder.set_contents(var_87);
            }
            ,
            s if s.matches("Delimiter") /* Delimiter com.amazonaws.s3.synthetic#ListObjectsOutput$Delimiter */ =>  {
                let var_89 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_delimiter(var_89);
            }
            ,
            s if s.matches("EncodingType") /* EncodingType com.amazonaws.s3.synthetic#ListObjectsOutput$EncodingType */ =>  {
                let var_90 =
                    Some(
                        Result::<crate::model::EncodingType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::EncodingType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_encoding_type(var_90);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.s3.synthetic#ListObjectsOutput$IsTruncated */ =>  {
                let var_91 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.s3#IsTruncated`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_91);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.s3.synthetic#ListObjectsOutput$Marker */ =>  {
                let var_92 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_92);
            }
            ,
            s if s.matches("Prefix") /* Prefix com.amazonaws.s3.synthetic#ListObjectsOutput$Prefix */ =>  {
                let var_93 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_prefix(var_93);
            }
            ,
            s if s.matches("NextMarker") /* NextMarker com.amazonaws.s3.synthetic#ListObjectsOutput$NextMarker */ =>  {
                let var_94 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_marker(var_94);
            }
            ,
            s if s.matches("MaxKeys") /* MaxKeys com.amazonaws.s3.synthetic#ListObjectsOutput$MaxKeys */ =>  {
                let var_95 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.s3#MaxKeys`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_max_keys(var_95);
            }
            ,
            s if s.matches("Name") /* Name com.amazonaws.s3.synthetic#ListObjectsOutput$Name */ =>  {
                let var_96 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_name(var_96);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_objects_v2(
    inp: &[u8],
    mut builder: crate::output::list_objects_v2_output::Builder,
) -> Result<crate::output::list_objects_v2_output::Builder, aws_smithy_xml::decode::XmlError> {
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListBucketResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListBucketResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("CommonPrefixes") /* CommonPrefixes com.amazonaws.s3.synthetic#ListObjectsV2Output$CommonPrefixes */ =>  {
                let var_97 =
                    Some(
                        Result::<std::vec::Vec<crate::model::CommonPrefix>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_98 = builder.common_prefixes.take().unwrap_or_default();
                            list_98.push(
                                crate::xml_deser::deser_structure_crate_model_common_prefix(&mut tag)
                                ?
                            );
                            list_98
                        })
                        ?
                    )
                ;
                builder = builder.set_common_prefixes(var_97);
            }
            ,
            s if s.matches("NextContinuationToken") /* NextContinuationToken com.amazonaws.s3.synthetic#ListObjectsV2Output$NextContinuationToken */ =>  {
                let var_99 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_continuation_token(var_99);
            }
            ,
            s if s.matches("Contents") /* Contents com.amazonaws.s3.synthetic#ListObjectsV2Output$Contents */ =>  {
                let var_100 =
                    Some(
                        Result::<std::vec::Vec<crate::model::Object>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_101 = builder.contents.take().unwrap_or_default();
                            list_101.push(
                                crate::xml_deser::deser_structure_crate_model_object(&mut tag)
                                ?
                            );
                            list_101
                        })
                        ?
                    )
                ;
                builder = builder.set_contents(var_100);
            }
            ,
            s if s.matches("ContinuationToken") /* ContinuationToken com.amazonaws.s3.synthetic#ListObjectsV2Output$ContinuationToken */ =>  {
                let var_102 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_continuation_token(var_102);
            }
            ,
            s if s.matches("Delimiter") /* Delimiter com.amazonaws.s3.synthetic#ListObjectsV2Output$Delimiter */ =>  {
                let var_103 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_delimiter(var_103);
            }
            ,
            s if s.matches("EncodingType") /* EncodingType com.amazonaws.s3.synthetic#ListObjectsV2Output$EncodingType */ =>  {
                let var_104 =
                    Some(
                        Result::<crate::model::EncodingType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::EncodingType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_encoding_type(var_104);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.s3.synthetic#ListObjectsV2Output$IsTruncated */ =>  {
                let var_105 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.s3#IsTruncated`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_105);
            }
            ,
            s if s.matches("StartAfter") /* StartAfter com.amazonaws.s3.synthetic#ListObjectsV2Output$StartAfter */ =>  {
                let var_106 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_start_after(var_106);
            }
            ,
            s if s.matches("Prefix") /* Prefix com.amazonaws.s3.synthetic#ListObjectsV2Output$Prefix */ =>  {
                let var_107 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_prefix(var_107);
            }
            ,
            s if s.matches("MaxKeys") /* MaxKeys com.amazonaws.s3.synthetic#ListObjectsV2Output$MaxKeys */ =>  {
                let var_108 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.s3#MaxKeys`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_max_keys(var_108);
            }
            ,
            s if s.matches("KeyCount") /* KeyCount com.amazonaws.s3.synthetic#ListObjectsV2Output$KeyCount */ =>  {
                let var_109 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.s3#KeyCount`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_key_count(var_109);
            }
            ,
            s if s.matches("Name") /* Name com.amazonaws.s3.synthetic#ListObjectsV2Output$Name */ =>  {
                let var_110 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_name(var_110);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_object_versions(
    inp: &[u8],
    mut builder: crate::output::list_object_versions_output::Builder,
) -> Result<crate::output::list_object_versions_output::Builder, aws_smithy_xml::decode::XmlError> {
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListVersionsResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListVersionsResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("CommonPrefixes") /* CommonPrefixes com.amazonaws.s3.synthetic#ListObjectVersionsOutput$CommonPrefixes */ =>  {
                let var_111 =
                    Some(
                        Result::<std::vec::Vec<crate::model::CommonPrefix>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_112 = builder.common_prefixes.take().unwrap_or_default();
                            list_112.push(
                                crate::xml_deser::deser_structure_crate_model_common_prefix(&mut tag)
                                ?
                            );
                            list_112
                        })
                        ?
                    )
                ;
                builder = builder.set_common_prefixes(var_111);
            }
            ,
            s if s.matches("NextKeyMarker") /* NextKeyMarker com.amazonaws.s3.synthetic#ListObjectVersionsOutput$NextKeyMarker */ =>  {
                let var_113 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_key_marker(var_113);
            }
            ,
            s if s.matches("Delimiter") /* Delimiter com.amazonaws.s3.synthetic#ListObjectVersionsOutput$Delimiter */ =>  {
                let var_114 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_delimiter(var_114);
            }
            ,
            s if s.matches("EncodingType") /* EncodingType com.amazonaws.s3.synthetic#ListObjectVersionsOutput$EncodingType */ =>  {
                let var_115 =
                    Some(
                        Result::<crate::model::EncodingType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::EncodingType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_encoding_type(var_115);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.s3.synthetic#ListObjectVersionsOutput$IsTruncated */ =>  {
                let var_116 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.s3#IsTruncated`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_116);
            }
            ,
            s if s.matches("NextVersionIdMarker") /* NextVersionIdMarker com.amazonaws.s3.synthetic#ListObjectVersionsOutput$NextVersionIdMarker */ =>  {
                let var_117 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_version_id_marker(var_117);
            }
            ,
            s if s.matches("Prefix") /* Prefix com.amazonaws.s3.synthetic#ListObjectVersionsOutput$Prefix */ =>  {
                let var_118 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_prefix(var_118);
            }
            ,
            s if s.matches("Name") /* Name com.amazonaws.s3.synthetic#ListObjectVersionsOutput$Name */ =>  {
                let var_119 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_name(var_119);
            }
            ,
            s if s.matches("VersionIdMarker") /* VersionIdMarker com.amazonaws.s3.synthetic#ListObjectVersionsOutput$VersionIdMarker */ =>  {
                let var_120 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_version_id_marker(var_120);
            }
            ,
            s if s.matches("Version") /* Versions com.amazonaws.s3.synthetic#ListObjectVersionsOutput$Versions */ =>  {
                let var_121 =
                    Some(
                        Result::<std::vec::Vec<crate::model::ObjectVersion>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_122 = builder.versions.take().unwrap_or_default();
                            list_122.push(
                                crate::xml_deser::deser_structure_crate_model_object_version(&mut tag)
                                ?
                            );
                            list_122
                        })
                        ?
                    )
                ;
                builder = builder.set_versions(var_121);
            }
            ,
            s if s.matches("MaxKeys") /* MaxKeys com.amazonaws.s3.synthetic#ListObjectVersionsOutput$MaxKeys */ =>  {
                let var_123 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.s3#MaxKeys`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_max_keys(var_123);
            }
            ,
            s if s.matches("DeleteMarker") /* DeleteMarkers com.amazonaws.s3.synthetic#ListObjectVersionsOutput$DeleteMarkers */ =>  {
                let var_124 =
                    Some(
                        Result::<std::vec::Vec<crate::model::DeleteMarkerEntry>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_125 = builder.delete_markers.take().unwrap_or_default();
                            list_125.push(
                                crate::xml_deser::deser_structure_crate_model_delete_marker_entry(&mut tag)
                                ?
                            );
                            list_125
                        })
                        ?
                    )
                ;
                builder = builder.set_delete_markers(var_124);
            }
            ,
            s if s.matches("KeyMarker") /* KeyMarker com.amazonaws.s3.synthetic#ListObjectVersionsOutput$KeyMarker */ =>  {
                let var_126 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_key_marker(var_126);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_parts(
    inp: &[u8],
    mut builder: crate::output::list_parts_output::Builder,
) -> Result<crate::output::list_parts_output::Builder, aws_smithy_xml::decode::XmlError> {
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListPartsResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListPartsResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Owner") /* Owner com.amazonaws.s3.synthetic#ListPartsOutput$Owner */ =>  {
                let var_127 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_owner(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_owner(var_127);
            }
            ,
            s if s.matches("NextPartNumberMarker") /* NextPartNumberMarker com.amazonaws.s3.synthetic#ListPartsOutput$NextPartNumberMarker */ =>  {
                let var_128 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_part_number_marker(var_128);
            }
            ,
            s if s.matches("StorageClass") /* StorageClass com.amazonaws.s3.synthetic#ListPartsOutput$StorageClass */ =>  {
                let var_129 =
                    Some(
                        Result::<crate::model::StorageClass, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::StorageClass::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_storage_class(var_129);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.s3.synthetic#ListPartsOutput$IsTruncated */ =>  {
                let var_130 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.s3#IsTruncated`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_130);
            }
            ,
            s if s.matches("MaxParts") /* MaxParts com.amazonaws.s3.synthetic#ListPartsOutput$MaxParts */ =>  {
                let var_131 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.s3#MaxParts`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_max_parts(var_131);
            }
            ,
            s if s.matches("UploadId") /* UploadId com.amazonaws.s3.synthetic#ListPartsOutput$UploadId */ =>  {
                let var_132 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_upload_id(var_132);
            }
            ,
            s if s.matches("PartNumberMarker") /* PartNumberMarker com.amazonaws.s3.synthetic#ListPartsOutput$PartNumberMarker */ =>  {
                let var_133 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_part_number_marker(var_133);
            }
            ,
            s if s.matches("Bucket") /* Bucket com.amazonaws.s3.synthetic#ListPartsOutput$Bucket */ =>  {
                let var_134 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_bucket(var_134);
            }
            ,
            s if s.matches("Part") /* Parts com.amazonaws.s3.synthetic#ListPartsOutput$Parts */ =>  {
                let var_135 =
                    Some(
                        Result::<std::vec::Vec<crate::model::Part>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_136 = builder.parts.take().unwrap_or_default();
                            list_136.push(
                                crate::xml_deser::deser_structure_crate_model_part(&mut tag)
                                ?
                            );
                            list_136
                        })
                        ?
                    )
                ;
                builder = builder.set_parts(var_135);
            }
            ,
            s if s.matches("Initiator") /* Initiator com.amazonaws.s3.synthetic#ListPartsOutput$Initiator */ =>  {
                let var_137 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_initiator(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_initiator(var_137);
            }
            ,
            s if s.matches("Key") /* Key com.amazonaws.s3.synthetic#ListPartsOutput$Key */ =>  {
                let var_138 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_key(var_138);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_object_already_in_active_tier_error_xml_err(
    inp: &[u8],
    mut builder: crate::error::object_already_in_active_tier_error::Builder,
) -> Result<
    crate::error::object_already_in_active_tier_error::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_unwrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.s3#ObjectAlreadyInActiveTierError$message */ =>  {
                let var_139 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_139);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

pub fn deser_member_com_amazonaws_s3_synthetic_copy_object_output_copy_object_result(
    inp: &[u8],
) -> Result<crate::model::CopyObjectResult, aws_smithy_xml::decode::XmlError> {
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CopyObjectResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CopyObjectResult got {:?}",
            start_el
        )));
    }
    crate::xml_deser::deser_structure_crate_model_copy_object_result(&mut decoder)
}

pub fn deser_member_com_amazonaws_s3_synthetic_get_bucket_analytics_configuration_output_analytics_configuration(
    inp: &[u8],
) -> Result<crate::model::AnalyticsConfiguration, aws_smithy_xml::decode::XmlError> {
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("AnalyticsConfiguration")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected AnalyticsConfiguration got {:?}",
            start_el
        )));
    }
    crate::xml_deser::deser_structure_crate_model_analytics_configuration(&mut decoder)
}

pub fn deser_member_com_amazonaws_s3_synthetic_get_bucket_encryption_output_server_side_encryption_configuration(
    inp: &[u8],
) -> Result<crate::model::ServerSideEncryptionConfiguration, aws_smithy_xml::decode::XmlError> {
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ServerSideEncryptionConfiguration")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ServerSideEncryptionConfiguration got {:?}",
            start_el
        )));
    }
    crate::xml_deser::deser_structure_crate_model_server_side_encryption_configuration(&mut decoder)
}

pub fn deser_member_com_amazonaws_s3_synthetic_get_bucket_intelligent_tiering_configuration_output_intelligent_tiering_configuration(
    inp: &[u8],
) -> Result<crate::model::IntelligentTieringConfiguration, aws_smithy_xml::decode::XmlError> {
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("IntelligentTieringConfiguration")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected IntelligentTieringConfiguration got {:?}",
            start_el
        )));
    }
    crate::xml_deser::deser_structure_crate_model_intelligent_tiering_configuration(&mut decoder)
}

pub fn deser_member_com_amazonaws_s3_synthetic_get_bucket_inventory_configuration_output_inventory_configuration(
    inp: &[u8],
) -> Result<crate::model::InventoryConfiguration, aws_smithy_xml::decode::XmlError> {
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("InventoryConfiguration")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected InventoryConfiguration got {:?}",
            start_el
        )));
    }
    crate::xml_deser::deser_structure_crate_model_inventory_configuration(&mut decoder)
}

pub fn deser_member_com_amazonaws_s3_synthetic_get_bucket_metrics_configuration_output_metrics_configuration(
    inp: &[u8],
) -> Result<crate::model::MetricsConfiguration, aws_smithy_xml::decode::XmlError> {
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("MetricsConfiguration")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected MetricsConfiguration got {:?}",
            start_el
        )));
    }
    crate::xml_deser::deser_structure_crate_model_metrics_configuration(&mut decoder)
}

pub fn deser_member_com_amazonaws_s3_synthetic_get_bucket_ownership_controls_output_ownership_controls(
    inp: &[u8],
) -> Result<crate::model::OwnershipControls, aws_smithy_xml::decode::XmlError> {
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("OwnershipControls")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected OwnershipControls got {:?}",
            start_el
        )));
    }
    crate::xml_deser::deser_structure_crate_model_ownership_controls(&mut decoder)
}

pub fn deser_member_com_amazonaws_s3_synthetic_get_bucket_policy_status_output_policy_status(
    inp: &[u8],
) -> Result<crate::model::PolicyStatus, aws_smithy_xml::decode::XmlError> {
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("PolicyStatus")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected PolicyStatus got {:?}",
            start_el
        )));
    }
    crate::xml_deser::deser_structure_crate_model_policy_status(&mut decoder)
}

pub fn deser_member_com_amazonaws_s3_synthetic_get_bucket_replication_output_replication_configuration(
    inp: &[u8],
) -> Result<crate::model::ReplicationConfiguration, aws_smithy_xml::decode::XmlError> {
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ReplicationConfiguration")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ReplicationConfiguration got {:?}",
            start_el
        )));
    }
    crate::xml_deser::deser_structure_crate_model_replication_configuration(&mut decoder)
}

pub fn deser_member_com_amazonaws_s3_synthetic_get_object_legal_hold_output_legal_hold(
    inp: &[u8],
) -> Result<crate::model::ObjectLockLegalHold, aws_smithy_xml::decode::XmlError> {
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ObjectLockLegalHold")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ObjectLockLegalHold got {:?}",
            start_el
        )));
    }
    crate::xml_deser::deser_structure_crate_model_object_lock_legal_hold(&mut decoder)
}

pub fn deser_member_com_amazonaws_s3_synthetic_get_object_lock_configuration_output_object_lock_configuration(
    inp: &[u8],
) -> Result<crate::model::ObjectLockConfiguration, aws_smithy_xml::decode::XmlError> {
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ObjectLockConfiguration")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ObjectLockConfiguration got {:?}",
            start_el
        )));
    }
    crate::xml_deser::deser_structure_crate_model_object_lock_configuration(&mut decoder)
}

pub fn deser_member_com_amazonaws_s3_synthetic_get_object_retention_output_retention(
    inp: &[u8],
) -> Result<crate::model::ObjectLockRetention, aws_smithy_xml::decode::XmlError> {
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ObjectLockRetention")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ObjectLockRetention got {:?}",
            start_el
        )));
    }
    crate::xml_deser::deser_structure_crate_model_object_lock_retention(&mut decoder)
}

pub fn deser_member_com_amazonaws_s3_synthetic_get_public_access_block_output_public_access_block_configuration(
    inp: &[u8],
) -> Result<crate::model::PublicAccessBlockConfiguration, aws_smithy_xml::decode::XmlError> {
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("PublicAccessBlockConfiguration")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected PublicAccessBlockConfiguration got {:?}",
            start_el
        )));
    }
    crate::xml_deser::deser_structure_crate_model_public_access_block_configuration(&mut decoder)
}

pub fn deser_member_com_amazonaws_s3_synthetic_upload_part_copy_output_copy_part_result(
    inp: &[u8],
) -> Result<crate::model::CopyPartResult, aws_smithy_xml::decode::XmlError> {
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CopyPartResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CopyPartResult got {:?}",
            start_el
        )));
    }
    crate::xml_deser::deser_structure_crate_model_copy_part_result(&mut decoder)
}

pub fn deser_structure_crate_model_error(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Error, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Error::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Key") /* Key com.amazonaws.s3#Error$Key */ =>  {
                let var_140 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_key(var_140);
            }
            ,
            s if s.matches("VersionId") /* VersionId com.amazonaws.s3#Error$VersionId */ =>  {
                let var_141 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_version_id(var_141);
            }
            ,
            s if s.matches("Code") /* Code com.amazonaws.s3#Error$Code */ =>  {
                let var_142 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_code(var_142);
            }
            ,
            s if s.matches("Message") /* Message com.amazonaws.s3#Error$Message */ =>  {
                let var_143 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_143);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_deleted_object(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::DeletedObject, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::DeletedObject::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Key") /* Key com.amazonaws.s3#DeletedObject$Key */ =>  {
                let var_144 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_key(var_144);
            }
            ,
            s if s.matches("VersionId") /* VersionId com.amazonaws.s3#DeletedObject$VersionId */ =>  {
                let var_145 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_version_id(var_145);
            }
            ,
            s if s.matches("DeleteMarker") /* DeleteMarker com.amazonaws.s3#DeletedObject$DeleteMarker */ =>  {
                let var_146 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.s3#DeleteMarker`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_delete_marker(var_146);
            }
            ,
            s if s.matches("DeleteMarkerVersionId") /* DeleteMarkerVersionId com.amazonaws.s3#DeletedObject$DeleteMarkerVersionId */ =>  {
                let var_147 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_delete_marker_version_id(var_147);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_owner(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Owner, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Owner::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("DisplayName") /* DisplayName com.amazonaws.s3#Owner$DisplayName */ =>  {
                let var_148 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_display_name(var_148);
            }
            ,
            s if s.matches("ID") /* ID com.amazonaws.s3#Owner$ID */ =>  {
                let var_149 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_id(var_149);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_s3_grants(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::Grant>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Grant") /* member com.amazonaws.s3#Grants$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_grant(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_cors_rule(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::CorsRule, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::CorsRule::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ID") /* ID com.amazonaws.s3#CORSRule$ID */ =>  {
                let var_150 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_id(var_150);
            }
            ,
            s if s.matches("AllowedHeader") /* AllowedHeaders com.amazonaws.s3#CORSRule$AllowedHeaders */ =>  {
                let var_151 =
                    Some(
                        Result::<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_152 = builder.allowed_headers.take().unwrap_or_default();
                            list_152.push(
                                Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                                    aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                                    .into()
                                )
                                ?
                            );
                            list_152
                        })
                        ?
                    )
                ;
                builder = builder.set_allowed_headers(var_151);
            }
            ,
            s if s.matches("AllowedMethod") /* AllowedMethods com.amazonaws.s3#CORSRule$AllowedMethods */ =>  {
                let var_153 =
                    Some(
                        Result::<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_154 = builder.allowed_methods.take().unwrap_or_default();
                            list_154.push(
                                Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                                    aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                                    .into()
                                )
                                ?
                            );
                            list_154
                        })
                        ?
                    )
                ;
                builder = builder.set_allowed_methods(var_153);
            }
            ,
            s if s.matches("AllowedOrigin") /* AllowedOrigins com.amazonaws.s3#CORSRule$AllowedOrigins */ =>  {
                let var_155 =
                    Some(
                        Result::<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_156 = builder.allowed_origins.take().unwrap_or_default();
                            list_156.push(
                                Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                                    aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                                    .into()
                                )
                                ?
                            );
                            list_156
                        })
                        ?
                    )
                ;
                builder = builder.set_allowed_origins(var_155);
            }
            ,
            s if s.matches("ExposeHeader") /* ExposeHeaders com.amazonaws.s3#CORSRule$ExposeHeaders */ =>  {
                let var_157 =
                    Some(
                        Result::<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_158 = builder.expose_headers.take().unwrap_or_default();
                            list_158.push(
                                Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                                    aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                                    .into()
                                )
                                ?
                            );
                            list_158
                        })
                        ?
                    )
                ;
                builder = builder.set_expose_headers(var_157);
            }
            ,
            s if s.matches("MaxAgeSeconds") /* MaxAgeSeconds com.amazonaws.s3#CORSRule$MaxAgeSeconds */ =>  {
                let var_159 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.s3#MaxAgeSeconds`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_max_age_seconds(var_159);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_lifecycle_rule(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::LifecycleRule, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::LifecycleRule::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Expiration") /* Expiration com.amazonaws.s3#LifecycleRule$Expiration */ =>  {
                let var_160 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_lifecycle_expiration(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_expiration(var_160);
            }
            ,
            s if s.matches("ID") /* ID com.amazonaws.s3#LifecycleRule$ID */ =>  {
                let var_161 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_id(var_161);
            }
            ,
            s if s.matches("Prefix") /* Prefix com.amazonaws.s3#LifecycleRule$Prefix */ =>  {
                let var_162 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_prefix(var_162);
            }
            ,
            s if s.matches("Filter") /* Filter com.amazonaws.s3#LifecycleRule$Filter */ =>  {
                let var_163 =
                    Some(
                        crate::xml_deser::deser_union_crate_model_lifecycle_rule_filter(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_filter(var_163);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.s3#LifecycleRule$Status */ =>  {
                let var_164 =
                    Some(
                        Result::<crate::model::ExpirationStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::ExpirationStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_164);
            }
            ,
            s if s.matches("Transition") /* Transitions com.amazonaws.s3#LifecycleRule$Transitions */ =>  {
                let var_165 =
                    Some(
                        Result::<std::vec::Vec<crate::model::Transition>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_166 = builder.transitions.take().unwrap_or_default();
                            list_166.push(
                                crate::xml_deser::deser_structure_crate_model_transition(&mut tag)
                                ?
                            );
                            list_166
                        })
                        ?
                    )
                ;
                builder = builder.set_transitions(var_165);
            }
            ,
            s if s.matches("NoncurrentVersionTransition") /* NoncurrentVersionTransitions com.amazonaws.s3#LifecycleRule$NoncurrentVersionTransitions */ =>  {
                let var_167 =
                    Some(
                        Result::<std::vec::Vec<crate::model::NoncurrentVersionTransition>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_168 = builder.noncurrent_version_transitions.take().unwrap_or_default();
                            list_168.push(
                                crate::xml_deser::deser_structure_crate_model_noncurrent_version_transition(&mut tag)
                                ?
                            );
                            list_168
                        })
                        ?
                    )
                ;
                builder = builder.set_noncurrent_version_transitions(var_167);
            }
            ,
            s if s.matches("NoncurrentVersionExpiration") /* NoncurrentVersionExpiration com.amazonaws.s3#LifecycleRule$NoncurrentVersionExpiration */ =>  {
                let var_169 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_noncurrent_version_expiration(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_noncurrent_version_expiration(var_169);
            }
            ,
            s if s.matches("AbortIncompleteMultipartUpload") /* AbortIncompleteMultipartUpload com.amazonaws.s3#LifecycleRule$AbortIncompleteMultipartUpload */ =>  {
                let var_170 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_abort_incomplete_multipart_upload(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_abort_incomplete_multipart_upload(var_170);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_logging_enabled(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::LoggingEnabled, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::LoggingEnabled::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("TargetBucket") /* TargetBucket com.amazonaws.s3#LoggingEnabled$TargetBucket */ =>  {
                let var_171 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_target_bucket(var_171);
            }
            ,
            s if s.matches("TargetGrants") /* TargetGrants com.amazonaws.s3#LoggingEnabled$TargetGrants */ =>  {
                let var_172 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_s3_target_grants(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_target_grants(var_172);
            }
            ,
            s if s.matches("TargetPrefix") /* TargetPrefix com.amazonaws.s3#LoggingEnabled$TargetPrefix */ =>  {
                let var_173 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_target_prefix(var_173);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_lambda_function_configuration(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::LambdaFunctionConfiguration, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::LambdaFunctionConfiguration::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Id") /* Id com.amazonaws.s3#LambdaFunctionConfiguration$Id */ =>  {
                let var_174 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_id(var_174);
            }
            ,
            s if s.matches("CloudFunction") /* LambdaFunctionArn com.amazonaws.s3#LambdaFunctionConfiguration$LambdaFunctionArn */ =>  {
                let var_175 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_lambda_function_arn(var_175);
            }
            ,
            s if s.matches("Event") /* Events com.amazonaws.s3#LambdaFunctionConfiguration$Events */ =>  {
                let var_176 =
                    Some(
                        Result::<std::vec::Vec<crate::model::Event>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_177 = builder.events.take().unwrap_or_default();
                            list_177.push(
                                Result::<crate::model::Event, aws_smithy_xml::decode::XmlError>::Ok(
                                    crate::model::Event::from(
                                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                                    )
                                )
                                ?
                            );
                            list_177
                        })
                        ?
                    )
                ;
                builder = builder.set_events(var_176);
            }
            ,
            s if s.matches("Filter") /* Filter com.amazonaws.s3#LambdaFunctionConfiguration$Filter */ =>  {
                let var_178 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_notification_configuration_filter(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_filter(var_178);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_topic_configuration(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::TopicConfiguration, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::TopicConfiguration::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Id") /* Id com.amazonaws.s3#TopicConfiguration$Id */ =>  {
                let var_179 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_id(var_179);
            }
            ,
            s if s.matches("Topic") /* TopicArn com.amazonaws.s3#TopicConfiguration$TopicArn */ =>  {
                let var_180 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_topic_arn(var_180);
            }
            ,
            s if s.matches("Event") /* Events com.amazonaws.s3#TopicConfiguration$Events */ =>  {
                let var_181 =
                    Some(
                        Result::<std::vec::Vec<crate::model::Event>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_182 = builder.events.take().unwrap_or_default();
                            list_182.push(
                                Result::<crate::model::Event, aws_smithy_xml::decode::XmlError>::Ok(
                                    crate::model::Event::from(
                                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                                    )
                                )
                                ?
                            );
                            list_182
                        })
                        ?
                    )
                ;
                builder = builder.set_events(var_181);
            }
            ,
            s if s.matches("Filter") /* Filter com.amazonaws.s3#TopicConfiguration$Filter */ =>  {
                let var_183 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_notification_configuration_filter(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_filter(var_183);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_queue_configuration(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::QueueConfiguration, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::QueueConfiguration::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Id") /* Id com.amazonaws.s3#QueueConfiguration$Id */ =>  {
                let var_184 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_id(var_184);
            }
            ,
            s if s.matches("Queue") /* QueueArn com.amazonaws.s3#QueueConfiguration$QueueArn */ =>  {
                let var_185 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_queue_arn(var_185);
            }
            ,
            s if s.matches("Event") /* Events com.amazonaws.s3#QueueConfiguration$Events */ =>  {
                let var_186 =
                    Some(
                        Result::<std::vec::Vec<crate::model::Event>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_187 = builder.events.take().unwrap_or_default();
                            list_187.push(
                                Result::<crate::model::Event, aws_smithy_xml::decode::XmlError>::Ok(
                                    crate::model::Event::from(
                                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                                    )
                                )
                                ?
                            );
                            list_187
                        })
                        ?
                    )
                ;
                builder = builder.set_events(var_186);
            }
            ,
            s if s.matches("Filter") /* Filter com.amazonaws.s3#QueueConfiguration$Filter */ =>  {
                let var_188 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_notification_configuration_filter(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_filter(var_188);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_event_bridge_configuration(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::EventBridgeConfiguration, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::EventBridgeConfiguration::builder();
    let _ = decoder;
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_s3_tag_set(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::Tag>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Tag") /* member com.amazonaws.s3#TagSet$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_tag(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_index_document(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::IndexDocument, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::IndexDocument::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Suffix") /* Suffix com.amazonaws.s3#IndexDocument$Suffix */ =>  {
                let var_189 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_suffix(var_189);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_redirect_all_requests_to(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::RedirectAllRequestsTo, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::RedirectAllRequestsTo::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("HostName") /* HostName com.amazonaws.s3#RedirectAllRequestsTo$HostName */ =>  {
                let var_190 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_host_name(var_190);
            }
            ,
            s if s.matches("Protocol") /* Protocol com.amazonaws.s3#RedirectAllRequestsTo$Protocol */ =>  {
                let var_191 =
                    Some(
                        Result::<crate::model::Protocol, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::Protocol::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_protocol(var_191);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_s3_routing_rules(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::RoutingRule>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("RoutingRule") /* member com.amazonaws.s3#RoutingRules$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_routing_rule(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_error_document(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ErrorDocument, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ErrorDocument::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Key") /* Key com.amazonaws.s3#ErrorDocument$Key */ =>  {
                let var_192 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_key(var_192);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_analytics_configuration(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::AnalyticsConfiguration, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::AnalyticsConfiguration::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Id") /* Id com.amazonaws.s3#AnalyticsConfiguration$Id */ =>  {
                let var_193 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_id(var_193);
            }
            ,
            s if s.matches("Filter") /* Filter com.amazonaws.s3#AnalyticsConfiguration$Filter */ =>  {
                let var_194 =
                    Some(
                        crate::xml_deser::deser_union_crate_model_analytics_filter(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_filter(var_194);
            }
            ,
            s if s.matches("StorageClassAnalysis") /* StorageClassAnalysis com.amazonaws.s3#AnalyticsConfiguration$StorageClassAnalysis */ =>  {
                let var_195 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_storage_class_analysis(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_storage_class_analysis(var_195);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_intelligent_tiering_configuration(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::IntelligentTieringConfiguration, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::IntelligentTieringConfiguration::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Id") /* Id com.amazonaws.s3#IntelligentTieringConfiguration$Id */ =>  {
                let var_196 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_id(var_196);
            }
            ,
            s if s.matches("Filter") /* Filter com.amazonaws.s3#IntelligentTieringConfiguration$Filter */ =>  {
                let var_197 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_intelligent_tiering_filter(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_filter(var_197);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.s3#IntelligentTieringConfiguration$Status */ =>  {
                let var_198 =
                    Some(
                        Result::<crate::model::IntelligentTieringStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::IntelligentTieringStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_198);
            }
            ,
            s if s.matches("Tiering") /* Tierings com.amazonaws.s3#IntelligentTieringConfiguration$Tierings */ =>  {
                let var_199 =
                    Some(
                        Result::<std::vec::Vec<crate::model::Tiering>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_200 = builder.tierings.take().unwrap_or_default();
                            list_200.push(
                                crate::xml_deser::deser_structure_crate_model_tiering(&mut tag)
                                ?
                            );
                            list_200
                        })
                        ?
                    )
                ;
                builder = builder.set_tierings(var_199);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_inventory_configuration(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::InventoryConfiguration, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::InventoryConfiguration::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Destination") /* Destination com.amazonaws.s3#InventoryConfiguration$Destination */ =>  {
                let var_201 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_inventory_destination(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_destination(var_201);
            }
            ,
            s if s.matches("IsEnabled") /* IsEnabled com.amazonaws.s3#InventoryConfiguration$IsEnabled */ =>  {
                let var_202 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.s3#IsEnabled`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_enabled(var_202);
            }
            ,
            s if s.matches("Filter") /* Filter com.amazonaws.s3#InventoryConfiguration$Filter */ =>  {
                let var_203 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_inventory_filter(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_filter(var_203);
            }
            ,
            s if s.matches("Id") /* Id com.amazonaws.s3#InventoryConfiguration$Id */ =>  {
                let var_204 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_id(var_204);
            }
            ,
            s if s.matches("IncludedObjectVersions") /* IncludedObjectVersions com.amazonaws.s3#InventoryConfiguration$IncludedObjectVersions */ =>  {
                let var_205 =
                    Some(
                        Result::<crate::model::InventoryIncludedObjectVersions, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::InventoryIncludedObjectVersions::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_included_object_versions(var_205);
            }
            ,
            s if s.matches("OptionalFields") /* OptionalFields com.amazonaws.s3#InventoryConfiguration$OptionalFields */ =>  {
                let var_206 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_s3_inventory_optional_fields(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_optional_fields(var_206);
            }
            ,
            s if s.matches("Schedule") /* Schedule com.amazonaws.s3#InventoryConfiguration$Schedule */ =>  {
                let var_207 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_inventory_schedule(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_schedule(var_207);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_metrics_configuration(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::MetricsConfiguration, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::MetricsConfiguration::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Id") /* Id com.amazonaws.s3#MetricsConfiguration$Id */ =>  {
                let var_208 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_id(var_208);
            }
            ,
            s if s.matches("Filter") /* Filter com.amazonaws.s3#MetricsConfiguration$Filter */ =>  {
                let var_209 =
                    Some(
                        crate::xml_deser::deser_union_crate_model_metrics_filter(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_filter(var_209);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_s3_buckets(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::Bucket>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Bucket") /* member com.amazonaws.s3#Buckets$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_bucket(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_common_prefix(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::CommonPrefix, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::CommonPrefix::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Prefix") /* Prefix com.amazonaws.s3#CommonPrefix$Prefix */ =>  {
                let var_210 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_prefix(var_210);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_multipart_upload(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::MultipartUpload, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::MultipartUpload::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("UploadId") /* UploadId com.amazonaws.s3#MultipartUpload$UploadId */ =>  {
                let var_211 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_upload_id(var_211);
            }
            ,
            s if s.matches("Key") /* Key com.amazonaws.s3#MultipartUpload$Key */ =>  {
                let var_212 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_key(var_212);
            }
            ,
            s if s.matches("Initiated") /* Initiated com.amazonaws.s3#MultipartUpload$Initiated */ =>  {
                let var_213 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.s3#Initiated`)"))
                        ?
                    )
                ;
                builder = builder.set_initiated(var_213);
            }
            ,
            s if s.matches("StorageClass") /* StorageClass com.amazonaws.s3#MultipartUpload$StorageClass */ =>  {
                let var_214 =
                    Some(
                        Result::<crate::model::StorageClass, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::StorageClass::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_storage_class(var_214);
            }
            ,
            s if s.matches("Owner") /* Owner com.amazonaws.s3#MultipartUpload$Owner */ =>  {
                let var_215 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_owner(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_owner(var_215);
            }
            ,
            s if s.matches("Initiator") /* Initiator com.amazonaws.s3#MultipartUpload$Initiator */ =>  {
                let var_216 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_initiator(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_initiator(var_216);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_object(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Object, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Object::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Key") /* Key com.amazonaws.s3#Object$Key */ =>  {
                let var_217 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_key(var_217);
            }
            ,
            s if s.matches("LastModified") /* LastModified com.amazonaws.s3#Object$LastModified */ =>  {
                let var_218 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.s3#LastModified`)"))
                        ?
                    )
                ;
                builder = builder.set_last_modified(var_218);
            }
            ,
            s if s.matches("ETag") /* ETag com.amazonaws.s3#Object$ETag */ =>  {
                let var_219 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_e_tag(var_219);
            }
            ,
            s if s.matches("Size") /* Size com.amazonaws.s3#Object$Size */ =>  {
                let var_220 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.s3#Size`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_size(var_220);
            }
            ,
            s if s.matches("StorageClass") /* StorageClass com.amazonaws.s3#Object$StorageClass */ =>  {
                let var_221 =
                    Some(
                        Result::<crate::model::ObjectStorageClass, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::ObjectStorageClass::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_storage_class(var_221);
            }
            ,
            s if s.matches("Owner") /* Owner com.amazonaws.s3#Object$Owner */ =>  {
                let var_222 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_owner(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_owner(var_222);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_object_version(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ObjectVersion, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ObjectVersion::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ETag") /* ETag com.amazonaws.s3#ObjectVersion$ETag */ =>  {
                let var_223 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_e_tag(var_223);
            }
            ,
            s if s.matches("Size") /* Size com.amazonaws.s3#ObjectVersion$Size */ =>  {
                let var_224 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.s3#Size`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_size(var_224);
            }
            ,
            s if s.matches("StorageClass") /* StorageClass com.amazonaws.s3#ObjectVersion$StorageClass */ =>  {
                let var_225 =
                    Some(
                        Result::<crate::model::ObjectVersionStorageClass, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::ObjectVersionStorageClass::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_storage_class(var_225);
            }
            ,
            s if s.matches("Key") /* Key com.amazonaws.s3#ObjectVersion$Key */ =>  {
                let var_226 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_key(var_226);
            }
            ,
            s if s.matches("VersionId") /* VersionId com.amazonaws.s3#ObjectVersion$VersionId */ =>  {
                let var_227 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_version_id(var_227);
            }
            ,
            s if s.matches("IsLatest") /* IsLatest com.amazonaws.s3#ObjectVersion$IsLatest */ =>  {
                let var_228 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.s3#IsLatest`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_latest(var_228);
            }
            ,
            s if s.matches("LastModified") /* LastModified com.amazonaws.s3#ObjectVersion$LastModified */ =>  {
                let var_229 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.s3#LastModified`)"))
                        ?
                    )
                ;
                builder = builder.set_last_modified(var_229);
            }
            ,
            s if s.matches("Owner") /* Owner com.amazonaws.s3#ObjectVersion$Owner */ =>  {
                let var_230 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_owner(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_owner(var_230);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_delete_marker_entry(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::DeleteMarkerEntry, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::DeleteMarkerEntry::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Owner") /* Owner com.amazonaws.s3#DeleteMarkerEntry$Owner */ =>  {
                let var_231 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_owner(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_owner(var_231);
            }
            ,
            s if s.matches("Key") /* Key com.amazonaws.s3#DeleteMarkerEntry$Key */ =>  {
                let var_232 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_key(var_232);
            }
            ,
            s if s.matches("VersionId") /* VersionId com.amazonaws.s3#DeleteMarkerEntry$VersionId */ =>  {
                let var_233 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_version_id(var_233);
            }
            ,
            s if s.matches("IsLatest") /* IsLatest com.amazonaws.s3#DeleteMarkerEntry$IsLatest */ =>  {
                let var_234 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.s3#IsLatest`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_latest(var_234);
            }
            ,
            s if s.matches("LastModified") /* LastModified com.amazonaws.s3#DeleteMarkerEntry$LastModified */ =>  {
                let var_235 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.s3#LastModified`)"))
                        ?
                    )
                ;
                builder = builder.set_last_modified(var_235);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_part(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Part, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Part::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("PartNumber") /* PartNumber com.amazonaws.s3#Part$PartNumber */ =>  {
                let var_236 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.s3#PartNumber`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_part_number(var_236);
            }
            ,
            s if s.matches("LastModified") /* LastModified com.amazonaws.s3#Part$LastModified */ =>  {
                let var_237 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.s3#LastModified`)"))
                        ?
                    )
                ;
                builder = builder.set_last_modified(var_237);
            }
            ,
            s if s.matches("ETag") /* ETag com.amazonaws.s3#Part$ETag */ =>  {
                let var_238 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_e_tag(var_238);
            }
            ,
            s if s.matches("Size") /* Size com.amazonaws.s3#Part$Size */ =>  {
                let var_239 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.s3#Size`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_size(var_239);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_initiator(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Initiator, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Initiator::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ID") /* ID com.amazonaws.s3#Initiator$ID */ =>  {
                let var_240 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_id(var_240);
            }
            ,
            s if s.matches("DisplayName") /* DisplayName com.amazonaws.s3#Initiator$DisplayName */ =>  {
                let var_241 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_display_name(var_241);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_member_com_amazonaws_s3_stats_event_details(
    inp: &[u8],
) -> Result<crate::model::Stats, aws_smithy_xml::decode::XmlError> {
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("Stats")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected Stats got {:?}",
            start_el
        )));
    }
    crate::xml_deser::deser_structure_crate_model_stats(&mut decoder)
}

pub fn deser_member_com_amazonaws_s3_progress_event_details(
    inp: &[u8],
) -> Result<crate::model::Progress, aws_smithy_xml::decode::XmlError> {
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("Progress")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected Progress got {:?}",
            start_el
        )));
    }
    crate::xml_deser::deser_structure_crate_model_progress(&mut decoder)
}

pub fn parse_event_stream_generic_error(
    payload: &bytes::Bytes,
) -> Result<aws_smithy_types::Error, aws_smithy_xml::decode::XmlError> {
    crate::rest_xml_unwrapped_errors::parse_generic_error(payload.as_ref())
}

pub fn deser_structure_crate_model_copy_object_result(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::CopyObjectResult, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::CopyObjectResult::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ETag") /* ETag com.amazonaws.s3#CopyObjectResult$ETag */ =>  {
                let var_242 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_e_tag(var_242);
            }
            ,
            s if s.matches("LastModified") /* LastModified com.amazonaws.s3#CopyObjectResult$LastModified */ =>  {
                let var_243 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.s3#LastModified`)"))
                        ?
                    )
                ;
                builder = builder.set_last_modified(var_243);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_server_side_encryption_configuration(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ServerSideEncryptionConfiguration, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ServerSideEncryptionConfiguration::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Rule") /* Rules com.amazonaws.s3#ServerSideEncryptionConfiguration$Rules */ =>  {
                let var_244 =
                    Some(
                        Result::<std::vec::Vec<crate::model::ServerSideEncryptionRule>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_245 = builder.rules.take().unwrap_or_default();
                            list_245.push(
                                crate::xml_deser::deser_structure_crate_model_server_side_encryption_rule(&mut tag)
                                ?
                            );
                            list_245
                        })
                        ?
                    )
                ;
                builder = builder.set_rules(var_244);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_ownership_controls(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::OwnershipControls, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::OwnershipControls::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Rule") /* Rules com.amazonaws.s3#OwnershipControls$Rules */ =>  {
                let var_246 =
                    Some(
                        Result::<std::vec::Vec<crate::model::OwnershipControlsRule>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_247 = builder.rules.take().unwrap_or_default();
                            list_247.push(
                                crate::xml_deser::deser_structure_crate_model_ownership_controls_rule(&mut tag)
                                ?
                            );
                            list_247
                        })
                        ?
                    )
                ;
                builder = builder.set_rules(var_246);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_policy_status(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::PolicyStatus, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::PolicyStatus::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("IsPublic") /* IsPublic com.amazonaws.s3#PolicyStatus$IsPublic */ =>  {
                let var_248 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.s3#IsPublic`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_public(var_248);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_replication_configuration(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ReplicationConfiguration, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ReplicationConfiguration::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Role") /* Role com.amazonaws.s3#ReplicationConfiguration$Role */ =>  {
                let var_249 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_role(var_249);
            }
            ,
            s if s.matches("Rule") /* Rules com.amazonaws.s3#ReplicationConfiguration$Rules */ =>  {
                let var_250 =
                    Some(
                        Result::<std::vec::Vec<crate::model::ReplicationRule>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_251 = builder.rules.take().unwrap_or_default();
                            list_251.push(
                                crate::xml_deser::deser_structure_crate_model_replication_rule(&mut tag)
                                ?
                            );
                            list_251
                        })
                        ?
                    )
                ;
                builder = builder.set_rules(var_250);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_object_lock_legal_hold(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ObjectLockLegalHold, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ObjectLockLegalHold::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Status") /* Status com.amazonaws.s3#ObjectLockLegalHold$Status */ =>  {
                let var_252 =
                    Some(
                        Result::<crate::model::ObjectLockLegalHoldStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::ObjectLockLegalHoldStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_252);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_object_lock_configuration(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ObjectLockConfiguration, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ObjectLockConfiguration::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ObjectLockEnabled") /* ObjectLockEnabled com.amazonaws.s3#ObjectLockConfiguration$ObjectLockEnabled */ =>  {
                let var_253 =
                    Some(
                        Result::<crate::model::ObjectLockEnabled, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::ObjectLockEnabled::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_object_lock_enabled(var_253);
            }
            ,
            s if s.matches("Rule") /* Rule com.amazonaws.s3#ObjectLockConfiguration$Rule */ =>  {
                let var_254 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_object_lock_rule(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_rule(var_254);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_object_lock_retention(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ObjectLockRetention, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ObjectLockRetention::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Mode") /* Mode com.amazonaws.s3#ObjectLockRetention$Mode */ =>  {
                let var_255 =
                    Some(
                        Result::<crate::model::ObjectLockRetentionMode, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::ObjectLockRetentionMode::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_mode(var_255);
            }
            ,
            s if s.matches("RetainUntilDate") /* RetainUntilDate com.amazonaws.s3#ObjectLockRetention$RetainUntilDate */ =>  {
                let var_256 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.s3#Date`)"))
                        ?
                    )
                ;
                builder = builder.set_retain_until_date(var_256);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_public_access_block_configuration(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::PublicAccessBlockConfiguration, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::PublicAccessBlockConfiguration::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("BlockPublicAcls") /* BlockPublicAcls com.amazonaws.s3#PublicAccessBlockConfiguration$BlockPublicAcls */ =>  {
                let var_257 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.s3#Setting`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_block_public_acls(var_257);
            }
            ,
            s if s.matches("IgnorePublicAcls") /* IgnorePublicAcls com.amazonaws.s3#PublicAccessBlockConfiguration$IgnorePublicAcls */ =>  {
                let var_258 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.s3#Setting`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_ignore_public_acls(var_258);
            }
            ,
            s if s.matches("BlockPublicPolicy") /* BlockPublicPolicy com.amazonaws.s3#PublicAccessBlockConfiguration$BlockPublicPolicy */ =>  {
                let var_259 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.s3#Setting`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_block_public_policy(var_259);
            }
            ,
            s if s.matches("RestrictPublicBuckets") /* RestrictPublicBuckets com.amazonaws.s3#PublicAccessBlockConfiguration$RestrictPublicBuckets */ =>  {
                let var_260 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.s3#Setting`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_restrict_public_buckets(var_260);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_copy_part_result(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::CopyPartResult, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::CopyPartResult::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ETag") /* ETag com.amazonaws.s3#CopyPartResult$ETag */ =>  {
                let var_261 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_e_tag(var_261);
            }
            ,
            s if s.matches("LastModified") /* LastModified com.amazonaws.s3#CopyPartResult$LastModified */ =>  {
                let var_262 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.s3#LastModified`)"))
                        ?
                    )
                ;
                builder = builder.set_last_modified(var_262);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_grant(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Grant, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Grant::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Grantee") /* Grantee com.amazonaws.s3#Grant$Grantee */ =>  {
                let var_263 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_grantee(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_grantee(var_263);
            }
            ,
            s if s.matches("Permission") /* Permission com.amazonaws.s3#Grant$Permission */ =>  {
                let var_264 =
                    Some(
                        Result::<crate::model::Permission, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::Permission::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_permission(var_264);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_lifecycle_expiration(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::LifecycleExpiration, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::LifecycleExpiration::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Date") /* Date com.amazonaws.s3#LifecycleExpiration$Date */ =>  {
                let var_265 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.s3#Date`)"))
                        ?
                    )
                ;
                builder = builder.set_date(var_265);
            }
            ,
            s if s.matches("Days") /* Days com.amazonaws.s3#LifecycleExpiration$Days */ =>  {
                let var_266 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.s3#Days`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_days(var_266);
            }
            ,
            s if s.matches("ExpiredObjectDeleteMarker") /* ExpiredObjectDeleteMarker com.amazonaws.s3#LifecycleExpiration$ExpiredObjectDeleteMarker */ =>  {
                let var_267 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.s3#ExpiredObjectDeleteMarker`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_expired_object_delete_marker(var_267);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_union_crate_model_lifecycle_rule_filter(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::LifecycleRuleFilter, aws_smithy_xml::decode::XmlError> {
    let mut base: Option<crate::model::LifecycleRuleFilter> = None;
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Prefix") /* Prefix com.amazonaws.s3#LifecycleRuleFilter$Prefix */ =>  {
                let tmp =
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                ;
                base = Some(crate::model::LifecycleRuleFilter::Prefix(tmp));
            }
            ,
            s if s.matches("Tag") /* Tag com.amazonaws.s3#LifecycleRuleFilter$Tag */ =>  {
                let tmp =
                    crate::xml_deser::deser_structure_crate_model_tag(&mut tag)
                    ?
                ;
                base = Some(crate::model::LifecycleRuleFilter::Tag(tmp));
            }
            ,
            s if s.matches("ObjectSizeGreaterThan") /* ObjectSizeGreaterThan com.amazonaws.s3#LifecycleRuleFilter$ObjectSizeGreaterThan */ =>  {
                let tmp =
                     {
                        <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.s3#ObjectSizeGreaterThanBytes`)"))
                    }
                    ?
                ;
                base = Some(crate::model::LifecycleRuleFilter::ObjectSizeGreaterThan(tmp));
            }
            ,
            s if s.matches("ObjectSizeLessThan") /* ObjectSizeLessThan com.amazonaws.s3#LifecycleRuleFilter$ObjectSizeLessThan */ =>  {
                let tmp =
                     {
                        <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.s3#ObjectSizeLessThanBytes`)"))
                    }
                    ?
                ;
                base = Some(crate::model::LifecycleRuleFilter::ObjectSizeLessThan(tmp));
            }
            ,
            s if s.matches("And") /* And com.amazonaws.s3#LifecycleRuleFilter$And */ =>  {
                let tmp =
                    crate::xml_deser::deser_structure_crate_model_lifecycle_rule_and_operator(&mut tag)
                    ?
                ;
                base = Some(crate::model::LifecycleRuleFilter::And(tmp));
            }
            ,
            _unknown => base = Some(crate::model::LifecycleRuleFilter::Unknown),
        }
    }
    base.ok_or_else(|| aws_smithy_xml::decode::XmlError::custom("expected union, got nothing"))
}

pub fn deser_structure_crate_model_transition(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Transition, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Transition::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Date") /* Date com.amazonaws.s3#Transition$Date */ =>  {
                let var_268 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.s3#Date`)"))
                        ?
                    )
                ;
                builder = builder.set_date(var_268);
            }
            ,
            s if s.matches("Days") /* Days com.amazonaws.s3#Transition$Days */ =>  {
                let var_269 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.s3#Days`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_days(var_269);
            }
            ,
            s if s.matches("StorageClass") /* StorageClass com.amazonaws.s3#Transition$StorageClass */ =>  {
                let var_270 =
                    Some(
                        Result::<crate::model::TransitionStorageClass, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::TransitionStorageClass::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_storage_class(var_270);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_noncurrent_version_transition(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::NoncurrentVersionTransition, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::NoncurrentVersionTransition::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("NoncurrentDays") /* NoncurrentDays com.amazonaws.s3#NoncurrentVersionTransition$NoncurrentDays */ =>  {
                let var_271 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.s3#Days`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_noncurrent_days(var_271);
            }
            ,
            s if s.matches("StorageClass") /* StorageClass com.amazonaws.s3#NoncurrentVersionTransition$StorageClass */ =>  {
                let var_272 =
                    Some(
                        Result::<crate::model::TransitionStorageClass, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::TransitionStorageClass::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_storage_class(var_272);
            }
            ,
            s if s.matches("NewerNoncurrentVersions") /* NewerNoncurrentVersions com.amazonaws.s3#NoncurrentVersionTransition$NewerNoncurrentVersions */ =>  {
                let var_273 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.s3#VersionCount`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_newer_noncurrent_versions(var_273);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_noncurrent_version_expiration(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::NoncurrentVersionExpiration, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::NoncurrentVersionExpiration::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("NoncurrentDays") /* NoncurrentDays com.amazonaws.s3#NoncurrentVersionExpiration$NoncurrentDays */ =>  {
                let var_274 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.s3#Days`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_noncurrent_days(var_274);
            }
            ,
            s if s.matches("NewerNoncurrentVersions") /* NewerNoncurrentVersions com.amazonaws.s3#NoncurrentVersionExpiration$NewerNoncurrentVersions */ =>  {
                let var_275 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.s3#VersionCount`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_newer_noncurrent_versions(var_275);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_abort_incomplete_multipart_upload(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::AbortIncompleteMultipartUpload, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::AbortIncompleteMultipartUpload::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("DaysAfterInitiation") /* DaysAfterInitiation com.amazonaws.s3#AbortIncompleteMultipartUpload$DaysAfterInitiation */ =>  {
                let var_276 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.s3#DaysAfterInitiation`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_days_after_initiation(var_276);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_s3_target_grants(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::TargetGrant>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Grant") /* member com.amazonaws.s3#TargetGrants$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_target_grant(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_notification_configuration_filter(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::NotificationConfigurationFilter, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::NotificationConfigurationFilter::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("S3Key") /* Key com.amazonaws.s3#NotificationConfigurationFilter$Key */ =>  {
                let var_277 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_s3_key_filter(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_key(var_277);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_tag(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Tag, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Tag::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Key") /* Key com.amazonaws.s3#Tag$Key */ =>  {
                let var_278 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_key(var_278);
            }
            ,
            s if s.matches("Value") /* Value com.amazonaws.s3#Tag$Value */ =>  {
                let var_279 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_value(var_279);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_routing_rule(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::RoutingRule, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::RoutingRule::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Condition") /* Condition com.amazonaws.s3#RoutingRule$Condition */ =>  {
                let var_280 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_condition(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_condition(var_280);
            }
            ,
            s if s.matches("Redirect") /* Redirect com.amazonaws.s3#RoutingRule$Redirect */ =>  {
                let var_281 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_redirect(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_redirect(var_281);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_union_crate_model_analytics_filter(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::AnalyticsFilter, aws_smithy_xml::decode::XmlError> {
    let mut base: Option<crate::model::AnalyticsFilter> = None;
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Prefix") /* Prefix com.amazonaws.s3#AnalyticsFilter$Prefix */ =>  {
                let tmp =
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                ;
                base = Some(crate::model::AnalyticsFilter::Prefix(tmp));
            }
            ,
            s if s.matches("Tag") /* Tag com.amazonaws.s3#AnalyticsFilter$Tag */ =>  {
                let tmp =
                    crate::xml_deser::deser_structure_crate_model_tag(&mut tag)
                    ?
                ;
                base = Some(crate::model::AnalyticsFilter::Tag(tmp));
            }
            ,
            s if s.matches("And") /* And com.amazonaws.s3#AnalyticsFilter$And */ =>  {
                let tmp =
                    crate::xml_deser::deser_structure_crate_model_analytics_and_operator(&mut tag)
                    ?
                ;
                base = Some(crate::model::AnalyticsFilter::And(tmp));
            }
            ,
            _unknown => base = Some(crate::model::AnalyticsFilter::Unknown),
        }
    }
    base.ok_or_else(|| aws_smithy_xml::decode::XmlError::custom("expected union, got nothing"))
}

pub fn deser_structure_crate_model_storage_class_analysis(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::StorageClassAnalysis, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::StorageClassAnalysis::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("DataExport") /* DataExport com.amazonaws.s3#StorageClassAnalysis$DataExport */ =>  {
                let var_282 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_storage_class_analysis_data_export(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_data_export(var_282);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_intelligent_tiering_filter(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::IntelligentTieringFilter, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::IntelligentTieringFilter::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Prefix") /* Prefix com.amazonaws.s3#IntelligentTieringFilter$Prefix */ =>  {
                let var_283 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_prefix(var_283);
            }
            ,
            s if s.matches("Tag") /* Tag com.amazonaws.s3#IntelligentTieringFilter$Tag */ =>  {
                let var_284 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_tag(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tag(var_284);
            }
            ,
            s if s.matches("And") /* And com.amazonaws.s3#IntelligentTieringFilter$And */ =>  {
                let var_285 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_intelligent_tiering_and_operator(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_and(var_285);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_tiering(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Tiering, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Tiering::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Days") /* Days com.amazonaws.s3#Tiering$Days */ =>  {
                let var_286 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.s3#IntelligentTieringDays`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_days(var_286);
            }
            ,
            s if s.matches("AccessTier") /* AccessTier com.amazonaws.s3#Tiering$AccessTier */ =>  {
                let var_287 =
                    Some(
                        Result::<crate::model::IntelligentTieringAccessTier, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::IntelligentTieringAccessTier::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_access_tier(var_287);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_inventory_destination(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::InventoryDestination, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::InventoryDestination::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("S3BucketDestination") /* S3BucketDestination com.amazonaws.s3#InventoryDestination$S3BucketDestination */ =>  {
                let var_288 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_inventory_s3_bucket_destination(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_s3_bucket_destination(var_288);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_inventory_filter(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::InventoryFilter, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::InventoryFilter::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Prefix") /* Prefix com.amazonaws.s3#InventoryFilter$Prefix */ =>  {
                let var_289 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_prefix(var_289);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_s3_inventory_optional_fields(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::InventoryOptionalField>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Field") /* member com.amazonaws.s3#InventoryOptionalFields$member */ =>  {
                out.push(
                    Result::<crate::model::InventoryOptionalField, aws_smithy_xml::decode::XmlError>::Ok(
                        crate::model::InventoryOptionalField::from(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        )
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_inventory_schedule(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::InventorySchedule, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::InventorySchedule::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Frequency") /* Frequency com.amazonaws.s3#InventorySchedule$Frequency */ =>  {
                let var_290 =
                    Some(
                        Result::<crate::model::InventoryFrequency, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::InventoryFrequency::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_frequency(var_290);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_union_crate_model_metrics_filter(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::MetricsFilter, aws_smithy_xml::decode::XmlError> {
    let mut base: Option<crate::model::MetricsFilter> = None;
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Prefix") /* Prefix com.amazonaws.s3#MetricsFilter$Prefix */ =>  {
                let tmp =
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                ;
                base = Some(crate::model::MetricsFilter::Prefix(tmp));
            }
            ,
            s if s.matches("Tag") /* Tag com.amazonaws.s3#MetricsFilter$Tag */ =>  {
                let tmp =
                    crate::xml_deser::deser_structure_crate_model_tag(&mut tag)
                    ?
                ;
                base = Some(crate::model::MetricsFilter::Tag(tmp));
            }
            ,
            s if s.matches("AccessPointArn") /* AccessPointArn com.amazonaws.s3#MetricsFilter$AccessPointArn */ =>  {
                let tmp =
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                ;
                base = Some(crate::model::MetricsFilter::AccessPointArn(tmp));
            }
            ,
            s if s.matches("And") /* And com.amazonaws.s3#MetricsFilter$And */ =>  {
                let tmp =
                    crate::xml_deser::deser_structure_crate_model_metrics_and_operator(&mut tag)
                    ?
                ;
                base = Some(crate::model::MetricsFilter::And(tmp));
            }
            ,
            _unknown => base = Some(crate::model::MetricsFilter::Unknown),
        }
    }
    base.ok_or_else(|| aws_smithy_xml::decode::XmlError::custom("expected union, got nothing"))
}

pub fn deser_structure_crate_model_bucket(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Bucket, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Bucket::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Name") /* Name com.amazonaws.s3#Bucket$Name */ =>  {
                let var_291 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_name(var_291);
            }
            ,
            s if s.matches("CreationDate") /* CreationDate com.amazonaws.s3#Bucket$CreationDate */ =>  {
                let var_292 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.s3#CreationDate`)"))
                        ?
                    )
                ;
                builder = builder.set_creation_date(var_292);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_stats(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Stats, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Stats::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("BytesScanned") /* BytesScanned com.amazonaws.s3#Stats$BytesScanned */ =>  {
                let var_293 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.s3#BytesScanned`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_bytes_scanned(var_293);
            }
            ,
            s if s.matches("BytesProcessed") /* BytesProcessed com.amazonaws.s3#Stats$BytesProcessed */ =>  {
                let var_294 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.s3#BytesProcessed`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_bytes_processed(var_294);
            }
            ,
            s if s.matches("BytesReturned") /* BytesReturned com.amazonaws.s3#Stats$BytesReturned */ =>  {
                let var_295 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.s3#BytesReturned`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_bytes_returned(var_295);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_progress(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Progress, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Progress::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("BytesScanned") /* BytesScanned com.amazonaws.s3#Progress$BytesScanned */ =>  {
                let var_296 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.s3#BytesScanned`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_bytes_scanned(var_296);
            }
            ,
            s if s.matches("BytesProcessed") /* BytesProcessed com.amazonaws.s3#Progress$BytesProcessed */ =>  {
                let var_297 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.s3#BytesProcessed`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_bytes_processed(var_297);
            }
            ,
            s if s.matches("BytesReturned") /* BytesReturned com.amazonaws.s3#Progress$BytesReturned */ =>  {
                let var_298 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.s3#BytesReturned`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_bytes_returned(var_298);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_server_side_encryption_rule(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ServerSideEncryptionRule, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ServerSideEncryptionRule::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ApplyServerSideEncryptionByDefault") /* ApplyServerSideEncryptionByDefault com.amazonaws.s3#ServerSideEncryptionRule$ApplyServerSideEncryptionByDefault */ =>  {
                let var_299 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_server_side_encryption_by_default(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_apply_server_side_encryption_by_default(var_299);
            }
            ,
            s if s.matches("BucketKeyEnabled") /* BucketKeyEnabled com.amazonaws.s3#ServerSideEncryptionRule$BucketKeyEnabled */ =>  {
                let var_300 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.s3#BucketKeyEnabled`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_bucket_key_enabled(var_300);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_ownership_controls_rule(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::OwnershipControlsRule, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::OwnershipControlsRule::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ObjectOwnership") /* ObjectOwnership com.amazonaws.s3#OwnershipControlsRule$ObjectOwnership */ =>  {
                let var_301 =
                    Some(
                        Result::<crate::model::ObjectOwnership, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::ObjectOwnership::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_object_ownership(var_301);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_replication_rule(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ReplicationRule, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ReplicationRule::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ID") /* ID com.amazonaws.s3#ReplicationRule$ID */ =>  {
                let var_302 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_id(var_302);
            }
            ,
            s if s.matches("Priority") /* Priority com.amazonaws.s3#ReplicationRule$Priority */ =>  {
                let var_303 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.s3#Priority`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_priority(var_303);
            }
            ,
            s if s.matches("Prefix") /* Prefix com.amazonaws.s3#ReplicationRule$Prefix */ =>  {
                let var_304 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_prefix(var_304);
            }
            ,
            s if s.matches("Filter") /* Filter com.amazonaws.s3#ReplicationRule$Filter */ =>  {
                let var_305 =
                    Some(
                        crate::xml_deser::deser_union_crate_model_replication_rule_filter(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_filter(var_305);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.s3#ReplicationRule$Status */ =>  {
                let var_306 =
                    Some(
                        Result::<crate::model::ReplicationRuleStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::ReplicationRuleStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_306);
            }
            ,
            s if s.matches("SourceSelectionCriteria") /* SourceSelectionCriteria com.amazonaws.s3#ReplicationRule$SourceSelectionCriteria */ =>  {
                let var_307 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_source_selection_criteria(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_source_selection_criteria(var_307);
            }
            ,
            s if s.matches("ExistingObjectReplication") /* ExistingObjectReplication com.amazonaws.s3#ReplicationRule$ExistingObjectReplication */ =>  {
                let var_308 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_existing_object_replication(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_existing_object_replication(var_308);
            }
            ,
            s if s.matches("Destination") /* Destination com.amazonaws.s3#ReplicationRule$Destination */ =>  {
                let var_309 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_destination(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_destination(var_309);
            }
            ,
            s if s.matches("DeleteMarkerReplication") /* DeleteMarkerReplication com.amazonaws.s3#ReplicationRule$DeleteMarkerReplication */ =>  {
                let var_310 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_delete_marker_replication(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_delete_marker_replication(var_310);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_object_lock_rule(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ObjectLockRule, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ObjectLockRule::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("DefaultRetention") /* DefaultRetention com.amazonaws.s3#ObjectLockRule$DefaultRetention */ =>  {
                let var_311 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_default_retention(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_default_retention(var_311);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_grantee(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Grantee, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Grantee::builder();
    let attrib_312 = {
        let s = decoder.start_el().attr("xsi:type");
        match s {
            None => None,
            Some(s) => Some(Result::<
                crate::model::Type,
                aws_smithy_xml::decode::XmlError,
            >::Ok(crate::model::Type::from(s))?),
        }
    };
    builder.r#type = attrib_312;
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("DisplayName") /* DisplayName com.amazonaws.s3#Grantee$DisplayName */ =>  {
                let var_313 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_display_name(var_313);
            }
            ,
            s if s.matches("EmailAddress") /* EmailAddress com.amazonaws.s3#Grantee$EmailAddress */ =>  {
                let var_314 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_email_address(var_314);
            }
            ,
            s if s.matches("ID") /* ID com.amazonaws.s3#Grantee$ID */ =>  {
                let var_315 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_id(var_315);
            }
            ,
            s if s.matches("URI") /* URI com.amazonaws.s3#Grantee$URI */ =>  {
                let var_316 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_uri(var_316);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_lifecycle_rule_and_operator(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::LifecycleRuleAndOperator, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::LifecycleRuleAndOperator::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Prefix") /* Prefix com.amazonaws.s3#LifecycleRuleAndOperator$Prefix */ =>  {
                let var_317 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_prefix(var_317);
            }
            ,
            s if s.matches("Tag") /* Tags com.amazonaws.s3#LifecycleRuleAndOperator$Tags */ =>  {
                let var_318 =
                    Some(
                        Result::<std::vec::Vec<crate::model::Tag>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_319 = builder.tags.take().unwrap_or_default();
                            list_319.push(
                                crate::xml_deser::deser_structure_crate_model_tag(&mut tag)
                                ?
                            );
                            list_319
                        })
                        ?
                    )
                ;
                builder = builder.set_tags(var_318);
            }
            ,
            s if s.matches("ObjectSizeGreaterThan") /* ObjectSizeGreaterThan com.amazonaws.s3#LifecycleRuleAndOperator$ObjectSizeGreaterThan */ =>  {
                let var_320 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.s3#ObjectSizeGreaterThanBytes`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_object_size_greater_than(var_320);
            }
            ,
            s if s.matches("ObjectSizeLessThan") /* ObjectSizeLessThan com.amazonaws.s3#LifecycleRuleAndOperator$ObjectSizeLessThan */ =>  {
                let var_321 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.s3#ObjectSizeLessThanBytes`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_object_size_less_than(var_321);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_target_grant(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::TargetGrant, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::TargetGrant::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Grantee") /* Grantee com.amazonaws.s3#TargetGrant$Grantee */ =>  {
                let var_322 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_grantee(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_grantee(var_322);
            }
            ,
            s if s.matches("Permission") /* Permission com.amazonaws.s3#TargetGrant$Permission */ =>  {
                let var_323 =
                    Some(
                        Result::<crate::model::BucketLogsPermission, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::BucketLogsPermission::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_permission(var_323);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_s3_key_filter(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::S3KeyFilter, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::S3KeyFilter::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("FilterRule") /* FilterRules com.amazonaws.s3#S3KeyFilter$FilterRules */ =>  {
                let var_324 =
                    Some(
                        Result::<std::vec::Vec<crate::model::FilterRule>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_325 = builder.filter_rules.take().unwrap_or_default();
                            list_325.push(
                                crate::xml_deser::deser_structure_crate_model_filter_rule(&mut tag)
                                ?
                            );
                            list_325
                        })
                        ?
                    )
                ;
                builder = builder.set_filter_rules(var_324);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_condition(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Condition, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Condition::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("HttpErrorCodeReturnedEquals") /* HttpErrorCodeReturnedEquals com.amazonaws.s3#Condition$HttpErrorCodeReturnedEquals */ =>  {
                let var_326 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_http_error_code_returned_equals(var_326);
            }
            ,
            s if s.matches("KeyPrefixEquals") /* KeyPrefixEquals com.amazonaws.s3#Condition$KeyPrefixEquals */ =>  {
                let var_327 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_key_prefix_equals(var_327);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_redirect(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Redirect, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Redirect::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("HostName") /* HostName com.amazonaws.s3#Redirect$HostName */ =>  {
                let var_328 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_host_name(var_328);
            }
            ,
            s if s.matches("HttpRedirectCode") /* HttpRedirectCode com.amazonaws.s3#Redirect$HttpRedirectCode */ =>  {
                let var_329 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_http_redirect_code(var_329);
            }
            ,
            s if s.matches("Protocol") /* Protocol com.amazonaws.s3#Redirect$Protocol */ =>  {
                let var_330 =
                    Some(
                        Result::<crate::model::Protocol, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::Protocol::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_protocol(var_330);
            }
            ,
            s if s.matches("ReplaceKeyPrefixWith") /* ReplaceKeyPrefixWith com.amazonaws.s3#Redirect$ReplaceKeyPrefixWith */ =>  {
                let var_331 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_replace_key_prefix_with(var_331);
            }
            ,
            s if s.matches("ReplaceKeyWith") /* ReplaceKeyWith com.amazonaws.s3#Redirect$ReplaceKeyWith */ =>  {
                let var_332 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_replace_key_with(var_332);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_analytics_and_operator(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::AnalyticsAndOperator, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::AnalyticsAndOperator::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Prefix") /* Prefix com.amazonaws.s3#AnalyticsAndOperator$Prefix */ =>  {
                let var_333 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_prefix(var_333);
            }
            ,
            s if s.matches("Tag") /* Tags com.amazonaws.s3#AnalyticsAndOperator$Tags */ =>  {
                let var_334 =
                    Some(
                        Result::<std::vec::Vec<crate::model::Tag>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_335 = builder.tags.take().unwrap_or_default();
                            list_335.push(
                                crate::xml_deser::deser_structure_crate_model_tag(&mut tag)
                                ?
                            );
                            list_335
                        })
                        ?
                    )
                ;
                builder = builder.set_tags(var_334);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_storage_class_analysis_data_export(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::StorageClassAnalysisDataExport, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::StorageClassAnalysisDataExport::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("OutputSchemaVersion") /* OutputSchemaVersion com.amazonaws.s3#StorageClassAnalysisDataExport$OutputSchemaVersion */ =>  {
                let var_336 =
                    Some(
                        Result::<crate::model::StorageClassAnalysisSchemaVersion, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::StorageClassAnalysisSchemaVersion::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_output_schema_version(var_336);
            }
            ,
            s if s.matches("Destination") /* Destination com.amazonaws.s3#StorageClassAnalysisDataExport$Destination */ =>  {
                let var_337 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_analytics_export_destination(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_destination(var_337);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_intelligent_tiering_and_operator(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::IntelligentTieringAndOperator, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::IntelligentTieringAndOperator::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Prefix") /* Prefix com.amazonaws.s3#IntelligentTieringAndOperator$Prefix */ =>  {
                let var_338 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_prefix(var_338);
            }
            ,
            s if s.matches("Tag") /* Tags com.amazonaws.s3#IntelligentTieringAndOperator$Tags */ =>  {
                let var_339 =
                    Some(
                        Result::<std::vec::Vec<crate::model::Tag>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_340 = builder.tags.take().unwrap_or_default();
                            list_340.push(
                                crate::xml_deser::deser_structure_crate_model_tag(&mut tag)
                                ?
                            );
                            list_340
                        })
                        ?
                    )
                ;
                builder = builder.set_tags(var_339);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_inventory_s3_bucket_destination(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::InventoryS3BucketDestination, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::InventoryS3BucketDestination::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("AccountId") /* AccountId com.amazonaws.s3#InventoryS3BucketDestination$AccountId */ =>  {
                let var_341 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_account_id(var_341);
            }
            ,
            s if s.matches("Bucket") /* Bucket com.amazonaws.s3#InventoryS3BucketDestination$Bucket */ =>  {
                let var_342 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_bucket(var_342);
            }
            ,
            s if s.matches("Format") /* Format com.amazonaws.s3#InventoryS3BucketDestination$Format */ =>  {
                let var_343 =
                    Some(
                        Result::<crate::model::InventoryFormat, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::InventoryFormat::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_format(var_343);
            }
            ,
            s if s.matches("Prefix") /* Prefix com.amazonaws.s3#InventoryS3BucketDestination$Prefix */ =>  {
                let var_344 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_prefix(var_344);
            }
            ,
            s if s.matches("Encryption") /* Encryption com.amazonaws.s3#InventoryS3BucketDestination$Encryption */ =>  {
                let var_345 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_inventory_encryption(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_encryption(var_345);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_metrics_and_operator(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::MetricsAndOperator, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::MetricsAndOperator::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Prefix") /* Prefix com.amazonaws.s3#MetricsAndOperator$Prefix */ =>  {
                let var_346 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_prefix(var_346);
            }
            ,
            s if s.matches("Tag") /* Tags com.amazonaws.s3#MetricsAndOperator$Tags */ =>  {
                let var_347 =
                    Some(
                        Result::<std::vec::Vec<crate::model::Tag>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_348 = builder.tags.take().unwrap_or_default();
                            list_348.push(
                                crate::xml_deser::deser_structure_crate_model_tag(&mut tag)
                                ?
                            );
                            list_348
                        })
                        ?
                    )
                ;
                builder = builder.set_tags(var_347);
            }
            ,
            s if s.matches("AccessPointArn") /* AccessPointArn com.amazonaws.s3#MetricsAndOperator$AccessPointArn */ =>  {
                let var_349 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_access_point_arn(var_349);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_server_side_encryption_by_default(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ServerSideEncryptionByDefault, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ServerSideEncryptionByDefault::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("SSEAlgorithm") /* SSEAlgorithm com.amazonaws.s3#ServerSideEncryptionByDefault$SSEAlgorithm */ =>  {
                let var_350 =
                    Some(
                        Result::<crate::model::ServerSideEncryption, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::ServerSideEncryption::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_sse_algorithm(var_350);
            }
            ,
            s if s.matches("KMSMasterKeyID") /* KMSMasterKeyID com.amazonaws.s3#ServerSideEncryptionByDefault$KMSMasterKeyID */ =>  {
                let var_351 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_kms_master_key_id(var_351);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_union_crate_model_replication_rule_filter(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ReplicationRuleFilter, aws_smithy_xml::decode::XmlError> {
    let mut base: Option<crate::model::ReplicationRuleFilter> = None;
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Prefix") /* Prefix com.amazonaws.s3#ReplicationRuleFilter$Prefix */ =>  {
                let tmp =
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                ;
                base = Some(crate::model::ReplicationRuleFilter::Prefix(tmp));
            }
            ,
            s if s.matches("Tag") /* Tag com.amazonaws.s3#ReplicationRuleFilter$Tag */ =>  {
                let tmp =
                    crate::xml_deser::deser_structure_crate_model_tag(&mut tag)
                    ?
                ;
                base = Some(crate::model::ReplicationRuleFilter::Tag(tmp));
            }
            ,
            s if s.matches("And") /* And com.amazonaws.s3#ReplicationRuleFilter$And */ =>  {
                let tmp =
                    crate::xml_deser::deser_structure_crate_model_replication_rule_and_operator(&mut tag)
                    ?
                ;
                base = Some(crate::model::ReplicationRuleFilter::And(tmp));
            }
            ,
            _unknown => base = Some(crate::model::ReplicationRuleFilter::Unknown),
        }
    }
    base.ok_or_else(|| aws_smithy_xml::decode::XmlError::custom("expected union, got nothing"))
}

pub fn deser_structure_crate_model_source_selection_criteria(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::SourceSelectionCriteria, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::SourceSelectionCriteria::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("SseKmsEncryptedObjects") /* SseKmsEncryptedObjects com.amazonaws.s3#SourceSelectionCriteria$SseKmsEncryptedObjects */ =>  {
                let var_352 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_sse_kms_encrypted_objects(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_sse_kms_encrypted_objects(var_352);
            }
            ,
            s if s.matches("ReplicaModifications") /* ReplicaModifications com.amazonaws.s3#SourceSelectionCriteria$ReplicaModifications */ =>  {
                let var_353 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_replica_modifications(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_replica_modifications(var_353);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_existing_object_replication(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ExistingObjectReplication, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ExistingObjectReplication::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Status") /* Status com.amazonaws.s3#ExistingObjectReplication$Status */ =>  {
                let var_354 =
                    Some(
                        Result::<crate::model::ExistingObjectReplicationStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::ExistingObjectReplicationStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_354);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_destination(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Destination, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Destination::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Bucket") /* Bucket com.amazonaws.s3#Destination$Bucket */ =>  {
                let var_355 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_bucket(var_355);
            }
            ,
            s if s.matches("Account") /* Account com.amazonaws.s3#Destination$Account */ =>  {
                let var_356 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_account(var_356);
            }
            ,
            s if s.matches("StorageClass") /* StorageClass com.amazonaws.s3#Destination$StorageClass */ =>  {
                let var_357 =
                    Some(
                        Result::<crate::model::StorageClass, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::StorageClass::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_storage_class(var_357);
            }
            ,
            s if s.matches("AccessControlTranslation") /* AccessControlTranslation com.amazonaws.s3#Destination$AccessControlTranslation */ =>  {
                let var_358 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_access_control_translation(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_access_control_translation(var_358);
            }
            ,
            s if s.matches("EncryptionConfiguration") /* EncryptionConfiguration com.amazonaws.s3#Destination$EncryptionConfiguration */ =>  {
                let var_359 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_encryption_configuration(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_encryption_configuration(var_359);
            }
            ,
            s if s.matches("ReplicationTime") /* ReplicationTime com.amazonaws.s3#Destination$ReplicationTime */ =>  {
                let var_360 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_replication_time(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_replication_time(var_360);
            }
            ,
            s if s.matches("Metrics") /* Metrics com.amazonaws.s3#Destination$Metrics */ =>  {
                let var_361 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_metrics(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_metrics(var_361);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_delete_marker_replication(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::DeleteMarkerReplication, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::DeleteMarkerReplication::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Status") /* Status com.amazonaws.s3#DeleteMarkerReplication$Status */ =>  {
                let var_362 =
                    Some(
                        Result::<crate::model::DeleteMarkerReplicationStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::DeleteMarkerReplicationStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_362);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_default_retention(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::DefaultRetention, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::DefaultRetention::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Mode") /* Mode com.amazonaws.s3#DefaultRetention$Mode */ =>  {
                let var_363 =
                    Some(
                        Result::<crate::model::ObjectLockRetentionMode, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::ObjectLockRetentionMode::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_mode(var_363);
            }
            ,
            s if s.matches("Days") /* Days com.amazonaws.s3#DefaultRetention$Days */ =>  {
                let var_364 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.s3#Days`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_days(var_364);
            }
            ,
            s if s.matches("Years") /* Years com.amazonaws.s3#DefaultRetention$Years */ =>  {
                let var_365 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.s3#Years`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_years(var_365);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_filter_rule(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::FilterRule, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::FilterRule::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Name") /* Name com.amazonaws.s3#FilterRule$Name */ =>  {
                let var_366 =
                    Some(
                        Result::<crate::model::FilterRuleName, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::FilterRuleName::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_name(var_366);
            }
            ,
            s if s.matches("Value") /* Value com.amazonaws.s3#FilterRule$Value */ =>  {
                let var_367 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_value(var_367);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_analytics_export_destination(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::AnalyticsExportDestination, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::AnalyticsExportDestination::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("S3BucketDestination") /* S3BucketDestination com.amazonaws.s3#AnalyticsExportDestination$S3BucketDestination */ =>  {
                let var_368 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_analytics_s3_bucket_destination(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_s3_bucket_destination(var_368);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_inventory_encryption(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::InventoryEncryption, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::InventoryEncryption::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("SSE-S3") /* SSES3 com.amazonaws.s3#InventoryEncryption$SSES3 */ =>  {
                let var_369 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_sses3(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_sses3(var_369);
            }
            ,
            s if s.matches("SSE-KMS") /* SSEKMS com.amazonaws.s3#InventoryEncryption$SSEKMS */ =>  {
                let var_370 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_ssekms(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ssekms(var_370);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_replication_rule_and_operator(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ReplicationRuleAndOperator, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ReplicationRuleAndOperator::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Prefix") /* Prefix com.amazonaws.s3#ReplicationRuleAndOperator$Prefix */ =>  {
                let var_371 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_prefix(var_371);
            }
            ,
            s if s.matches("Tag") /* Tags com.amazonaws.s3#ReplicationRuleAndOperator$Tags */ =>  {
                let var_372 =
                    Some(
                        Result::<std::vec::Vec<crate::model::Tag>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_373 = builder.tags.take().unwrap_or_default();
                            list_373.push(
                                crate::xml_deser::deser_structure_crate_model_tag(&mut tag)
                                ?
                            );
                            list_373
                        })
                        ?
                    )
                ;
                builder = builder.set_tags(var_372);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_sse_kms_encrypted_objects(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::SseKmsEncryptedObjects, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::SseKmsEncryptedObjects::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Status") /* Status com.amazonaws.s3#SseKmsEncryptedObjects$Status */ =>  {
                let var_374 =
                    Some(
                        Result::<crate::model::SseKmsEncryptedObjectsStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::SseKmsEncryptedObjectsStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_374);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_replica_modifications(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ReplicaModifications, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ReplicaModifications::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Status") /* Status com.amazonaws.s3#ReplicaModifications$Status */ =>  {
                let var_375 =
                    Some(
                        Result::<crate::model::ReplicaModificationsStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::ReplicaModificationsStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_375);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_access_control_translation(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::AccessControlTranslation, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::AccessControlTranslation::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Owner") /* Owner com.amazonaws.s3#AccessControlTranslation$Owner */ =>  {
                let var_376 =
                    Some(
                        Result::<crate::model::OwnerOverride, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::OwnerOverride::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_owner(var_376);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_encryption_configuration(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::EncryptionConfiguration, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::EncryptionConfiguration::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ReplicaKmsKeyID") /* ReplicaKmsKeyID com.amazonaws.s3#EncryptionConfiguration$ReplicaKmsKeyID */ =>  {
                let var_377 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_replica_kms_key_id(var_377);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_replication_time(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ReplicationTime, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ReplicationTime::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Status") /* Status com.amazonaws.s3#ReplicationTime$Status */ =>  {
                let var_378 =
                    Some(
                        Result::<crate::model::ReplicationTimeStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::ReplicationTimeStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_378);
            }
            ,
            s if s.matches("Time") /* Time com.amazonaws.s3#ReplicationTime$Time */ =>  {
                let var_379 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_replication_time_value(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_time(var_379);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_metrics(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Metrics, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Metrics::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Status") /* Status com.amazonaws.s3#Metrics$Status */ =>  {
                let var_380 =
                    Some(
                        Result::<crate::model::MetricsStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::MetricsStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_380);
            }
            ,
            s if s.matches("EventThreshold") /* EventThreshold com.amazonaws.s3#Metrics$EventThreshold */ =>  {
                let var_381 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_replication_time_value(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_event_threshold(var_381);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_analytics_s3_bucket_destination(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::AnalyticsS3BucketDestination, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::AnalyticsS3BucketDestination::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Format") /* Format com.amazonaws.s3#AnalyticsS3BucketDestination$Format */ =>  {
                let var_382 =
                    Some(
                        Result::<crate::model::AnalyticsS3ExportFileFormat, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::AnalyticsS3ExportFileFormat::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_format(var_382);
            }
            ,
            s if s.matches("BucketAccountId") /* BucketAccountId com.amazonaws.s3#AnalyticsS3BucketDestination$BucketAccountId */ =>  {
                let var_383 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_bucket_account_id(var_383);
            }
            ,
            s if s.matches("Bucket") /* Bucket com.amazonaws.s3#AnalyticsS3BucketDestination$Bucket */ =>  {
                let var_384 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_bucket(var_384);
            }
            ,
            s if s.matches("Prefix") /* Prefix com.amazonaws.s3#AnalyticsS3BucketDestination$Prefix */ =>  {
                let var_385 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_prefix(var_385);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_sses3(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Sses3, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Sses3::builder();
    let _ = decoder;
    Ok(builder.build())
}

pub fn deser_structure_crate_model_ssekms(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Ssekms, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Ssekms::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("KeyId") /* KeyId com.amazonaws.s3#SSEKMS$KeyId */ =>  {
                let var_386 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_key_id(var_386);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_replication_time_value(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ReplicationTimeValue, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ReplicationTimeValue::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Minutes") /* Minutes com.amazonaws.s3#ReplicationTimeValue$Minutes */ =>  {
                let var_387 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.s3#Minutes`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_minutes(var_387);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}
