// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AbortMultipartUploadInput`](crate::input::AbortMultipartUploadInput)
pub mod abort_multipart_upload_input {
    /// A builder for [`AbortMultipartUploadInput`](crate::input::AbortMultipartUploadInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) upload_id: std::option::Option<std::string::String>,
        pub(crate) request_payer: std::option::Option<crate::model::RequestPayer>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket name to which the upload was taking place. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name to which the upload was taking place. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Key of the object for which the multipart upload was initiated.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>Key of the object for which the multipart upload was initiated.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>Upload ID that identifies the multipart upload.</p>
        pub fn upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.upload_id = Some(input.into());
            self
        }
        /// <p>Upload ID that identifies the multipart upload.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.upload_id = input;
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.request_payer = Some(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.request_payer = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`AbortMultipartUploadInput`](crate::input::AbortMultipartUploadInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AbortMultipartUploadInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AbortMultipartUploadInput {
                bucket: self.bucket,
                key: self.key,
                upload_id: self.upload_id,
                request_payer: self.request_payer,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type AbortMultipartUploadInputOperationOutputAlias = crate::operation::AbortMultipartUpload;
#[doc(hidden)]
pub type AbortMultipartUploadInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AbortMultipartUploadInput {
    /// Consumes the builder and constructs an Operation<[`AbortMultipartUpload`](crate::operation::AbortMultipartUpload)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AbortMultipartUpload,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AbortMultipartUploadInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_1 = &_input.bucket;
                let input_1 = input_1.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_1, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                let input_2 = &_input.key;
                let input_2 = input_2.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    },
                )?;
                let key = aws_smithy_http::label::fmt_string(input_2, true);
                if key.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}/{Key}", Bucket = bucket, Key = key)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::AbortMultipartUploadInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_kv("x-id", "AbortMultipartUpload");
                if let Some(inner_3) = &_input.upload_id {
                    query.push_kv("uploadId", &aws_smithy_http::query::fmt_string(&inner_3));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AbortMultipartUploadInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_abort_multipart_upload(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AbortMultipartUpload::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AbortMultipartUpload",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AbortMultipartUploadInput`](crate::input::AbortMultipartUploadInput)
    pub fn builder() -> crate::input::abort_multipart_upload_input::Builder {
        crate::input::abort_multipart_upload_input::Builder::default()
    }
}

/// See [`CompleteMultipartUploadInput`](crate::input::CompleteMultipartUploadInput)
pub mod complete_multipart_upload_input {
    /// A builder for [`CompleteMultipartUploadInput`](crate::input::CompleteMultipartUploadInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) multipart_upload: std::option::Option<crate::model::CompletedMultipartUpload>,
        pub(crate) upload_id: std::option::Option<std::string::String>,
        pub(crate) request_payer: std::option::Option<crate::model::RequestPayer>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Name of the bucket to which the multipart upload was initiated.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>Name of the bucket to which the multipart upload was initiated.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Object key for which the multipart upload was initiated.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>Object key for which the multipart upload was initiated.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The container for the multipart upload request information.</p>
        pub fn multipart_upload(mut self, input: crate::model::CompletedMultipartUpload) -> Self {
            self.multipart_upload = Some(input);
            self
        }
        /// <p>The container for the multipart upload request information.</p>
        pub fn set_multipart_upload(
            mut self,
            input: std::option::Option<crate::model::CompletedMultipartUpload>,
        ) -> Self {
            self.multipart_upload = input;
            self
        }
        /// <p>ID for the initiated multipart upload.</p>
        pub fn upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.upload_id = Some(input.into());
            self
        }
        /// <p>ID for the initiated multipart upload.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.upload_id = input;
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.request_payer = Some(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.request_payer = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`CompleteMultipartUploadInput`](crate::input::CompleteMultipartUploadInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CompleteMultipartUploadInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CompleteMultipartUploadInput {
                bucket: self.bucket,
                key: self.key,
                multipart_upload: self.multipart_upload,
                upload_id: self.upload_id,
                request_payer: self.request_payer,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type CompleteMultipartUploadInputOperationOutputAlias =
    crate::operation::CompleteMultipartUpload;
#[doc(hidden)]
pub type CompleteMultipartUploadInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CompleteMultipartUploadInput {
    /// Consumes the builder and constructs an Operation<[`CompleteMultipartUpload`](crate::operation::CompleteMultipartUpload)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CompleteMultipartUpload,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CompleteMultipartUploadInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_4 = &_input.bucket;
                let input_4 = input_4.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_4, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                let input_5 = &_input.key;
                let input_5 = input_5.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    },
                )?;
                let key = aws_smithy_http::label::fmt_string(input_5, true);
                if key.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}/{Key}", Bucket = bucket, Key = key)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::CompleteMultipartUploadInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_kv("x-id", "CompleteMultipartUpload");
                if let Some(inner_6) = &_input.upload_id {
                    query.push_kv("uploadId", &aws_smithy_http::query::fmt_string(&inner_6));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CompleteMultipartUploadInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_complete_multipart_upload(input, builder)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_complete_multipart_upload_input(
                &self.multipart_upload,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CompleteMultipartUpload::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CompleteMultipartUpload",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CompleteMultipartUploadInput`](crate::input::CompleteMultipartUploadInput)
    pub fn builder() -> crate::input::complete_multipart_upload_input::Builder {
        crate::input::complete_multipart_upload_input::Builder::default()
    }
}

/// See [`CopyObjectInput`](crate::input::CopyObjectInput)
pub mod copy_object_input {
    /// A builder for [`CopyObjectInput`](crate::input::CopyObjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) acl: std::option::Option<crate::model::ObjectCannedAcl>,
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) cache_control: std::option::Option<std::string::String>,
        pub(crate) content_disposition: std::option::Option<std::string::String>,
        pub(crate) content_encoding: std::option::Option<std::string::String>,
        pub(crate) content_language: std::option::Option<std::string::String>,
        pub(crate) content_type: std::option::Option<std::string::String>,
        pub(crate) copy_source: std::option::Option<std::string::String>,
        pub(crate) copy_source_if_match: std::option::Option<std::string::String>,
        pub(crate) copy_source_if_modified_since: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) copy_source_if_none_match: std::option::Option<std::string::String>,
        pub(crate) copy_source_if_unmodified_since: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) expires: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) grant_full_control: std::option::Option<std::string::String>,
        pub(crate) grant_read: std::option::Option<std::string::String>,
        pub(crate) grant_read_acp: std::option::Option<std::string::String>,
        pub(crate) grant_write_acp: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) metadata: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) metadata_directive: std::option::Option<crate::model::MetadataDirective>,
        pub(crate) tagging_directive: std::option::Option<crate::model::TaggingDirective>,
        pub(crate) server_side_encryption: std::option::Option<crate::model::ServerSideEncryption>,
        pub(crate) storage_class: std::option::Option<crate::model::StorageClass>,
        pub(crate) website_redirect_location: std::option::Option<std::string::String>,
        pub(crate) sse_customer_algorithm: std::option::Option<std::string::String>,
        pub(crate) sse_customer_key: std::option::Option<std::string::String>,
        pub(crate) sse_customer_key_md5: std::option::Option<std::string::String>,
        pub(crate) ssekms_key_id: std::option::Option<std::string::String>,
        pub(crate) ssekms_encryption_context: std::option::Option<std::string::String>,
        pub(crate) bucket_key_enabled: std::option::Option<bool>,
        pub(crate) copy_source_sse_customer_algorithm: std::option::Option<std::string::String>,
        pub(crate) copy_source_sse_customer_key: std::option::Option<std::string::String>,
        pub(crate) copy_source_sse_customer_key_md5: std::option::Option<std::string::String>,
        pub(crate) request_payer: std::option::Option<crate::model::RequestPayer>,
        pub(crate) tagging: std::option::Option<std::string::String>,
        pub(crate) object_lock_mode: std::option::Option<crate::model::ObjectLockMode>,
        pub(crate) object_lock_retain_until_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) object_lock_legal_hold_status:
            std::option::Option<crate::model::ObjectLockLegalHoldStatus>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
        pub(crate) expected_source_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The canned ACL to apply to the object.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn acl(mut self, input: crate::model::ObjectCannedAcl) -> Self {
            self.acl = Some(input);
            self
        }
        /// <p>The canned ACL to apply to the object.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn set_acl(
            mut self,
            input: std::option::Option<crate::model::ObjectCannedAcl>,
        ) -> Self {
            self.acl = input;
            self
        }
        /// <p>The name of the destination bucket.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the destination bucket.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Specifies caching behavior along the request/reply chain.</p>
        pub fn cache_control(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_control = Some(input.into());
            self
        }
        /// <p>Specifies caching behavior along the request/reply chain.</p>
        pub fn set_cache_control(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_control = input;
            self
        }
        /// <p>Specifies presentational information for the object.</p>
        pub fn content_disposition(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_disposition = Some(input.into());
            self
        }
        /// <p>Specifies presentational information for the object.</p>
        pub fn set_content_disposition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.content_disposition = input;
            self
        }
        /// <p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.</p>
        pub fn content_encoding(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_encoding = Some(input.into());
            self
        }
        /// <p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.</p>
        pub fn set_content_encoding(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.content_encoding = input;
            self
        }
        /// <p>The language the content is in.</p>
        pub fn content_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_language = Some(input.into());
            self
        }
        /// <p>The language the content is in.</p>
        pub fn set_content_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.content_language = input;
            self
        }
        /// <p>A standard MIME type describing the format of the object data.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>A standard MIME type describing the format of the object data.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// <p>Specifies the source object for the copy operation. You specify the value in one of two formats, depending on whether you want to access the source object through an <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html">access point</a>:</p>
        /// <ul>
        /// <li> <p>For objects not accessed through an access point, specify the name of the source bucket and the key of the source object, separated by a slash (/). For example, to copy the object <code>reports/january.pdf</code> from the bucket <code>awsexamplebucket</code>, use <code>awsexamplebucket/reports/january.pdf</code>. The value must be URL encoded.</p> </li>
        /// <li> <p>For objects accessed through access points, specify the Amazon Resource Name (ARN) of the object as accessed through the access point, in the format <code>arn:aws:s3:
        /// <region>
        /// :
        /// <account-id>
        /// :accesspoint/
        /// <access-point-name>
        /// /object/
        /// <key></key>
        /// </access-point-name>
        /// </account-id>
        /// </region></code>. For example, to copy the object <code>reports/january.pdf</code> through access point <code>my-access-point</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3:us-west-2:123456789012:accesspoint/my-access-point/object/reports/january.pdf</code>. The value must be URL encoded.</p> <note>
        /// <p>Amazon S3 supports copy operations using access points only when the source and destination buckets are in the same Amazon Web Services Region.</p>
        /// </note> <p>Alternatively, for objects accessed through Amazon S3 on Outposts, specify the ARN of the object as accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /object/
        /// <key></key>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to copy the object <code>reports/january.pdf</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/object/reports/january.pdf</code>. The value must be URL encoded. </p> </li>
        /// </ul>
        /// <p>To copy a specific version of an object, append <code>?versionId=
        /// <version-id></version-id></code> to the value (for example, <code>awsexamplebucket/reports/january.pdf?versionId=QUpfdndhfd8438MNFDN93jdnJFkdmqnh893</code>). If you don't specify a version ID, Amazon S3 copies the latest version of the source object.</p>
        pub fn copy_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.copy_source = Some(input.into());
            self
        }
        /// <p>Specifies the source object for the copy operation. You specify the value in one of two formats, depending on whether you want to access the source object through an <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html">access point</a>:</p>
        /// <ul>
        /// <li> <p>For objects not accessed through an access point, specify the name of the source bucket and the key of the source object, separated by a slash (/). For example, to copy the object <code>reports/january.pdf</code> from the bucket <code>awsexamplebucket</code>, use <code>awsexamplebucket/reports/january.pdf</code>. The value must be URL encoded.</p> </li>
        /// <li> <p>For objects accessed through access points, specify the Amazon Resource Name (ARN) of the object as accessed through the access point, in the format <code>arn:aws:s3:
        /// <region>
        /// :
        /// <account-id>
        /// :accesspoint/
        /// <access-point-name>
        /// /object/
        /// <key></key>
        /// </access-point-name>
        /// </account-id>
        /// </region></code>. For example, to copy the object <code>reports/january.pdf</code> through access point <code>my-access-point</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3:us-west-2:123456789012:accesspoint/my-access-point/object/reports/january.pdf</code>. The value must be URL encoded.</p> <note>
        /// <p>Amazon S3 supports copy operations using access points only when the source and destination buckets are in the same Amazon Web Services Region.</p>
        /// </note> <p>Alternatively, for objects accessed through Amazon S3 on Outposts, specify the ARN of the object as accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /object/
        /// <key></key>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to copy the object <code>reports/january.pdf</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/object/reports/january.pdf</code>. The value must be URL encoded. </p> </li>
        /// </ul>
        /// <p>To copy a specific version of an object, append <code>?versionId=
        /// <version-id></version-id></code> to the value (for example, <code>awsexamplebucket/reports/january.pdf?versionId=QUpfdndhfd8438MNFDN93jdnJFkdmqnh893</code>). If you don't specify a version ID, Amazon S3 copies the latest version of the source object.</p>
        pub fn set_copy_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.copy_source = input;
            self
        }
        /// <p>Copies the object if its entity tag (ETag) matches the specified tag.</p>
        pub fn copy_source_if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.copy_source_if_match = Some(input.into());
            self
        }
        /// <p>Copies the object if its entity tag (ETag) matches the specified tag.</p>
        pub fn set_copy_source_if_match(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.copy_source_if_match = input;
            self
        }
        /// <p>Copies the object if it has been modified since the specified time.</p>
        pub fn copy_source_if_modified_since(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.copy_source_if_modified_since = Some(input);
            self
        }
        /// <p>Copies the object if it has been modified since the specified time.</p>
        pub fn set_copy_source_if_modified_since(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.copy_source_if_modified_since = input;
            self
        }
        /// <p>Copies the object if its entity tag (ETag) is different than the specified ETag.</p>
        pub fn copy_source_if_none_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.copy_source_if_none_match = Some(input.into());
            self
        }
        /// <p>Copies the object if its entity tag (ETag) is different than the specified ETag.</p>
        pub fn set_copy_source_if_none_match(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.copy_source_if_none_match = input;
            self
        }
        /// <p>Copies the object if it hasn't been modified since the specified time.</p>
        pub fn copy_source_if_unmodified_since(
            mut self,
            input: aws_smithy_types::DateTime,
        ) -> Self {
            self.copy_source_if_unmodified_since = Some(input);
            self
        }
        /// <p>Copies the object if it hasn't been modified since the specified time.</p>
        pub fn set_copy_source_if_unmodified_since(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.copy_source_if_unmodified_since = input;
            self
        }
        /// <p>The date and time at which the object is no longer cacheable.</p>
        pub fn expires(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.expires = Some(input);
            self
        }
        /// <p>The date and time at which the object is no longer cacheable.</p>
        pub fn set_expires(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.expires = input;
            self
        }
        /// <p>Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn grant_full_control(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_full_control = Some(input.into());
            self
        }
        /// <p>Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn set_grant_full_control(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.grant_full_control = input;
            self
        }
        /// <p>Allows grantee to read the object data and its metadata.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn grant_read(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_read = Some(input.into());
            self
        }
        /// <p>Allows grantee to read the object data and its metadata.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn set_grant_read(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.grant_read = input;
            self
        }
        /// <p>Allows grantee to read the object ACL.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn grant_read_acp(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_read_acp = Some(input.into());
            self
        }
        /// <p>Allows grantee to read the object ACL.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn set_grant_read_acp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.grant_read_acp = input;
            self
        }
        /// <p>Allows grantee to write the ACL for the applicable object.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn grant_write_acp(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_write_acp = Some(input.into());
            self
        }
        /// <p>Allows grantee to write the ACL for the applicable object.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn set_grant_write_acp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.grant_write_acp = input;
            self
        }
        /// <p>The key of the destination object.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key of the destination object.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// Adds a key-value pair to `metadata`.
        ///
        /// To override the contents of this collection use [`set_metadata`](Self::set_metadata).
        ///
        /// <p>A map of metadata to store with the object in S3.</p>
        pub fn metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.metadata = Some(hash_map);
            self
        }
        /// <p>A map of metadata to store with the object in S3.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// <p>Specifies whether the metadata is copied from the source object or replaced with metadata provided in the request.</p>
        pub fn metadata_directive(mut self, input: crate::model::MetadataDirective) -> Self {
            self.metadata_directive = Some(input);
            self
        }
        /// <p>Specifies whether the metadata is copied from the source object or replaced with metadata provided in the request.</p>
        pub fn set_metadata_directive(
            mut self,
            input: std::option::Option<crate::model::MetadataDirective>,
        ) -> Self {
            self.metadata_directive = input;
            self
        }
        /// <p>Specifies whether the object tag-set are copied from the source object or replaced with tag-set provided in the request.</p>
        pub fn tagging_directive(mut self, input: crate::model::TaggingDirective) -> Self {
            self.tagging_directive = Some(input);
            self
        }
        /// <p>Specifies whether the object tag-set are copied from the source object or replaced with tag-set provided in the request.</p>
        pub fn set_tagging_directive(
            mut self,
            input: std::option::Option<crate::model::TaggingDirective>,
        ) -> Self {
            self.tagging_directive = input;
            self
        }
        /// <p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example, AES256, aws:kms).</p>
        pub fn server_side_encryption(mut self, input: crate::model::ServerSideEncryption) -> Self {
            self.server_side_encryption = Some(input);
            self
        }
        /// <p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example, AES256, aws:kms).</p>
        pub fn set_server_side_encryption(
            mut self,
            input: std::option::Option<crate::model::ServerSideEncryption>,
        ) -> Self {
            self.server_side_encryption = input;
            self
        }
        /// <p>By default, Amazon S3 uses the STANDARD Storage Class to store newly created objects. The STANDARD storage class provides high durability and high availability. Depending on performance needs, you can specify a different Storage Class. Amazon S3 on Outposts only uses the OUTPOSTS Storage Class. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn storage_class(mut self, input: crate::model::StorageClass) -> Self {
            self.storage_class = Some(input);
            self
        }
        /// <p>By default, Amazon S3 uses the STANDARD Storage Class to store newly created objects. The STANDARD storage class provides high durability and high availability. Depending on performance needs, you can specify a different Storage Class. Amazon S3 on Outposts only uses the OUTPOSTS Storage Class. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_storage_class(
            mut self,
            input: std::option::Option<crate::model::StorageClass>,
        ) -> Self {
            self.storage_class = input;
            self
        }
        /// <p>If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata.</p>
        pub fn website_redirect_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.website_redirect_location = Some(input.into());
            self
        }
        /// <p>If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata.</p>
        pub fn set_website_redirect_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.website_redirect_location = input;
            self
        }
        /// <p>Specifies the algorithm to use to when encrypting the object (for example, AES256).</p>
        pub fn sse_customer_algorithm(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_customer_algorithm = Some(input.into());
            self
        }
        /// <p>Specifies the algorithm to use to when encrypting the object (for example, AES256).</p>
        pub fn set_sse_customer_algorithm(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_customer_algorithm = input;
            self
        }
        /// <p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p>
        pub fn sse_customer_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_customer_key = Some(input.into());
            self
        }
        /// <p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p>
        pub fn set_sse_customer_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_customer_key = input;
            self
        }
        /// <p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>
        pub fn sse_customer_key_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_customer_key_md5 = Some(input.into());
            self
        }
        /// <p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>
        pub fn set_sse_customer_key_md5(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_customer_key_md5 = input;
            self
        }
        /// <p>Specifies the Amazon Web Services KMS key ID to use for object encryption. All GET and PUT requests for an object protected by Amazon Web Services KMS will fail if not made via SSL or using SigV4. For information about configuring using any of the officially supported Amazon Web Services SDKs and Amazon Web Services CLI, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html#specify-signature-version">Specifying the Signature Version in Request Authentication</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn ssekms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssekms_key_id = Some(input.into());
            self
        }
        /// <p>Specifies the Amazon Web Services KMS key ID to use for object encryption. All GET and PUT requests for an object protected by Amazon Web Services KMS will fail if not made via SSL or using SigV4. For information about configuring using any of the officially supported Amazon Web Services SDKs and Amazon Web Services CLI, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html#specify-signature-version">Specifying the Signature Version in Request Authentication</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_ssekms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssekms_key_id = input;
            self
        }
        /// <p>Specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.</p>
        pub fn ssekms_encryption_context(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssekms_encryption_context = Some(input.into());
            self
        }
        /// <p>Specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.</p>
        pub fn set_ssekms_encryption_context(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssekms_encryption_context = input;
            self
        }
        /// <p>Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption with server-side encryption using AWS KMS (SSE-KMS). Setting this header to <code>true</code> causes Amazon S3 to use an S3 Bucket Key for object encryption with SSE-KMS. </p>
        /// <p>Specifying this header with a COPY action doesn’t affect bucket-level settings for S3 Bucket Key.</p>
        pub fn bucket_key_enabled(mut self, input: bool) -> Self {
            self.bucket_key_enabled = Some(input);
            self
        }
        /// <p>Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption with server-side encryption using AWS KMS (SSE-KMS). Setting this header to <code>true</code> causes Amazon S3 to use an S3 Bucket Key for object encryption with SSE-KMS. </p>
        /// <p>Specifying this header with a COPY action doesn’t affect bucket-level settings for S3 Bucket Key.</p>
        pub fn set_bucket_key_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.bucket_key_enabled = input;
            self
        }
        /// <p>Specifies the algorithm to use when decrypting the source object (for example, AES256).</p>
        pub fn copy_source_sse_customer_algorithm(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.copy_source_sse_customer_algorithm = Some(input.into());
            self
        }
        /// <p>Specifies the algorithm to use when decrypting the source object (for example, AES256).</p>
        pub fn set_copy_source_sse_customer_algorithm(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.copy_source_sse_customer_algorithm = input;
            self
        }
        /// <p>Specifies the customer-provided encryption key for Amazon S3 to use to decrypt the source object. The encryption key provided in this header must be one that was used when the source object was created.</p>
        pub fn copy_source_sse_customer_key(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.copy_source_sse_customer_key = Some(input.into());
            self
        }
        /// <p>Specifies the customer-provided encryption key for Amazon S3 to use to decrypt the source object. The encryption key provided in this header must be one that was used when the source object was created.</p>
        pub fn set_copy_source_sse_customer_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.copy_source_sse_customer_key = input;
            self
        }
        /// <p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>
        pub fn copy_source_sse_customer_key_md5(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.copy_source_sse_customer_key_md5 = Some(input.into());
            self
        }
        /// <p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>
        pub fn set_copy_source_sse_customer_key_md5(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.copy_source_sse_customer_key_md5 = input;
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.request_payer = Some(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.request_payer = input;
            self
        }
        /// <p>The tag-set for the object destination object this value must be used in conjunction with the <code>TaggingDirective</code>. The tag-set must be encoded as URL Query parameters.</p>
        pub fn tagging(mut self, input: impl Into<std::string::String>) -> Self {
            self.tagging = Some(input.into());
            self
        }
        /// <p>The tag-set for the object destination object this value must be used in conjunction with the <code>TaggingDirective</code>. The tag-set must be encoded as URL Query parameters.</p>
        pub fn set_tagging(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tagging = input;
            self
        }
        /// <p>The Object Lock mode that you want to apply to the copied object.</p>
        pub fn object_lock_mode(mut self, input: crate::model::ObjectLockMode) -> Self {
            self.object_lock_mode = Some(input);
            self
        }
        /// <p>The Object Lock mode that you want to apply to the copied object.</p>
        pub fn set_object_lock_mode(
            mut self,
            input: std::option::Option<crate::model::ObjectLockMode>,
        ) -> Self {
            self.object_lock_mode = input;
            self
        }
        /// <p>The date and time when you want the copied object's Object Lock to expire.</p>
        pub fn object_lock_retain_until_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.object_lock_retain_until_date = Some(input);
            self
        }
        /// <p>The date and time when you want the copied object's Object Lock to expire.</p>
        pub fn set_object_lock_retain_until_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.object_lock_retain_until_date = input;
            self
        }
        /// <p>Specifies whether you want to apply a Legal Hold to the copied object.</p>
        pub fn object_lock_legal_hold_status(
            mut self,
            input: crate::model::ObjectLockLegalHoldStatus,
        ) -> Self {
            self.object_lock_legal_hold_status = Some(input);
            self
        }
        /// <p>Specifies whether you want to apply a Legal Hold to the copied object.</p>
        pub fn set_object_lock_legal_hold_status(
            mut self,
            input: std::option::Option<crate::model::ObjectLockLegalHoldStatus>,
        ) -> Self {
            self.object_lock_legal_hold_status = input;
            self
        }
        /// <p>The account ID of the expected destination bucket owner. If the destination bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected destination bucket owner. If the destination bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// <p>The account ID of the expected source bucket owner. If the source bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_source_bucket_owner(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.expected_source_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected source bucket owner. If the source bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_source_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_source_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`CopyObjectInput`](crate::input::CopyObjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CopyObjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CopyObjectInput {
                acl: self.acl,
                bucket: self.bucket,
                cache_control: self.cache_control,
                content_disposition: self.content_disposition,
                content_encoding: self.content_encoding,
                content_language: self.content_language,
                content_type: self.content_type,
                copy_source: self.copy_source,
                copy_source_if_match: self.copy_source_if_match,
                copy_source_if_modified_since: self.copy_source_if_modified_since,
                copy_source_if_none_match: self.copy_source_if_none_match,
                copy_source_if_unmodified_since: self.copy_source_if_unmodified_since,
                expires: self.expires,
                grant_full_control: self.grant_full_control,
                grant_read: self.grant_read,
                grant_read_acp: self.grant_read_acp,
                grant_write_acp: self.grant_write_acp,
                key: self.key,
                metadata: self.metadata,
                metadata_directive: self.metadata_directive,
                tagging_directive: self.tagging_directive,
                server_side_encryption: self.server_side_encryption,
                storage_class: self.storage_class,
                website_redirect_location: self.website_redirect_location,
                sse_customer_algorithm: self.sse_customer_algorithm,
                sse_customer_key: self.sse_customer_key,
                sse_customer_key_md5: self.sse_customer_key_md5,
                ssekms_key_id: self.ssekms_key_id,
                ssekms_encryption_context: self.ssekms_encryption_context,
                bucket_key_enabled: self.bucket_key_enabled.unwrap_or_default(),
                copy_source_sse_customer_algorithm: self.copy_source_sse_customer_algorithm,
                copy_source_sse_customer_key: self.copy_source_sse_customer_key,
                copy_source_sse_customer_key_md5: self.copy_source_sse_customer_key_md5,
                request_payer: self.request_payer,
                tagging: self.tagging,
                object_lock_mode: self.object_lock_mode,
                object_lock_retain_until_date: self.object_lock_retain_until_date,
                object_lock_legal_hold_status: self.object_lock_legal_hold_status,
                expected_bucket_owner: self.expected_bucket_owner,
                expected_source_bucket_owner: self.expected_source_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type CopyObjectInputOperationOutputAlias = crate::operation::CopyObject;
#[doc(hidden)]
pub type CopyObjectInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CopyObjectInput {
    /// Consumes the builder and constructs an Operation<[`CopyObject`](crate::operation::CopyObject)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CopyObject,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CopyObjectInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_7 = &_input.bucket;
                let input_7 = input_7.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_7, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                let input_8 = &_input.key;
                let input_8 = input_8.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    },
                )?;
                let key = aws_smithy_http::label::fmt_string(input_8, true);
                if key.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}/{Key}", Bucket = bucket, Key = key)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::CopyObjectInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_kv("x-id", "CopyObject");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CopyObjectInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_copy_object(input, builder)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CopyObject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CopyObject",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CopyObjectInput`](crate::input::CopyObjectInput)
    pub fn builder() -> crate::input::copy_object_input::Builder {
        crate::input::copy_object_input::Builder::default()
    }
}

/// See [`CreateBucketInput`](crate::input::CreateBucketInput)
pub mod create_bucket_input {
    /// A builder for [`CreateBucketInput`](crate::input::CreateBucketInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) acl: std::option::Option<crate::model::BucketCannedAcl>,
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) create_bucket_configuration:
            std::option::Option<crate::model::CreateBucketConfiguration>,
        pub(crate) grant_full_control: std::option::Option<std::string::String>,
        pub(crate) grant_read: std::option::Option<std::string::String>,
        pub(crate) grant_read_acp: std::option::Option<std::string::String>,
        pub(crate) grant_write: std::option::Option<std::string::String>,
        pub(crate) grant_write_acp: std::option::Option<std::string::String>,
        pub(crate) object_lock_enabled_for_bucket: std::option::Option<bool>,
        pub(crate) object_ownership: std::option::Option<crate::model::ObjectOwnership>,
    }
    impl Builder {
        /// <p>The canned ACL to apply to the bucket.</p>
        pub fn acl(mut self, input: crate::model::BucketCannedAcl) -> Self {
            self.acl = Some(input);
            self
        }
        /// <p>The canned ACL to apply to the bucket.</p>
        pub fn set_acl(
            mut self,
            input: std::option::Option<crate::model::BucketCannedAcl>,
        ) -> Self {
            self.acl = input;
            self
        }
        /// <p>The name of the bucket to create.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket to create.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The configuration information for the bucket.</p>
        pub fn create_bucket_configuration(
            mut self,
            input: crate::model::CreateBucketConfiguration,
        ) -> Self {
            self.create_bucket_configuration = Some(input);
            self
        }
        /// <p>The configuration information for the bucket.</p>
        pub fn set_create_bucket_configuration(
            mut self,
            input: std::option::Option<crate::model::CreateBucketConfiguration>,
        ) -> Self {
            self.create_bucket_configuration = input;
            self
        }
        /// <p>Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.</p>
        pub fn grant_full_control(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_full_control = Some(input.into());
            self
        }
        /// <p>Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.</p>
        pub fn set_grant_full_control(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.grant_full_control = input;
            self
        }
        /// <p>Allows grantee to list the objects in the bucket.</p>
        pub fn grant_read(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_read = Some(input.into());
            self
        }
        /// <p>Allows grantee to list the objects in the bucket.</p>
        pub fn set_grant_read(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.grant_read = input;
            self
        }
        /// <p>Allows grantee to read the bucket ACL.</p>
        pub fn grant_read_acp(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_read_acp = Some(input.into());
            self
        }
        /// <p>Allows grantee to read the bucket ACL.</p>
        pub fn set_grant_read_acp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.grant_read_acp = input;
            self
        }
        /// <p>Allows grantee to create new objects in the bucket.</p>
        /// <p>For the bucket and object owners of existing objects, also allows deletions and overwrites of those objects.</p>
        pub fn grant_write(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_write = Some(input.into());
            self
        }
        /// <p>Allows grantee to create new objects in the bucket.</p>
        /// <p>For the bucket and object owners of existing objects, also allows deletions and overwrites of those objects.</p>
        pub fn set_grant_write(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.grant_write = input;
            self
        }
        /// <p>Allows grantee to write the ACL for the applicable bucket.</p>
        pub fn grant_write_acp(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_write_acp = Some(input.into());
            self
        }
        /// <p>Allows grantee to write the ACL for the applicable bucket.</p>
        pub fn set_grant_write_acp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.grant_write_acp = input;
            self
        }
        /// <p>Specifies whether you want S3 Object Lock to be enabled for the new bucket.</p>
        pub fn object_lock_enabled_for_bucket(mut self, input: bool) -> Self {
            self.object_lock_enabled_for_bucket = Some(input);
            self
        }
        /// <p>Specifies whether you want S3 Object Lock to be enabled for the new bucket.</p>
        pub fn set_object_lock_enabled_for_bucket(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.object_lock_enabled_for_bucket = input;
            self
        }
        /// <p>The container element for object ownership for a bucket's ownership controls.</p>
        /// <p>BucketOwnerPreferred - Objects uploaded to the bucket change ownership to the bucket owner if the objects are uploaded with the <code>bucket-owner-full-control</code> canned ACL.</p>
        /// <p>ObjectWriter - The uploading account will own the object if the object is uploaded with the <code>bucket-owner-full-control</code> canned ACL.</p>
        /// <p>BucketOwnerEnforced - Access control lists (ACLs) are disabled and no longer affect permissions. The bucket owner automatically owns and has full control over every object in the bucket. The bucket only accepts PUT requests that don't specify an ACL or bucket owner full control ACLs, such as the <code>bucket-owner-full-control</code> canned ACL or an equivalent form of this ACL expressed in the XML format.</p>
        pub fn object_ownership(mut self, input: crate::model::ObjectOwnership) -> Self {
            self.object_ownership = Some(input);
            self
        }
        /// <p>The container element for object ownership for a bucket's ownership controls.</p>
        /// <p>BucketOwnerPreferred - Objects uploaded to the bucket change ownership to the bucket owner if the objects are uploaded with the <code>bucket-owner-full-control</code> canned ACL.</p>
        /// <p>ObjectWriter - The uploading account will own the object if the object is uploaded with the <code>bucket-owner-full-control</code> canned ACL.</p>
        /// <p>BucketOwnerEnforced - Access control lists (ACLs) are disabled and no longer affect permissions. The bucket owner automatically owns and has full control over every object in the bucket. The bucket only accepts PUT requests that don't specify an ACL or bucket owner full control ACLs, such as the <code>bucket-owner-full-control</code> canned ACL or an equivalent form of this ACL expressed in the XML format.</p>
        pub fn set_object_ownership(
            mut self,
            input: std::option::Option<crate::model::ObjectOwnership>,
        ) -> Self {
            self.object_ownership = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBucketInput`](crate::input::CreateBucketInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateBucketInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateBucketInput {
                acl: self.acl,
                bucket: self.bucket,
                create_bucket_configuration: self.create_bucket_configuration,
                grant_full_control: self.grant_full_control,
                grant_read: self.grant_read,
                grant_read_acp: self.grant_read_acp,
                grant_write: self.grant_write,
                grant_write_acp: self.grant_write_acp,
                object_lock_enabled_for_bucket: self
                    .object_lock_enabled_for_bucket
                    .unwrap_or_default(),
                object_ownership: self.object_ownership,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateBucketInputOperationOutputAlias = crate::operation::CreateBucket;
#[doc(hidden)]
pub type CreateBucketInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateBucketInput {
    /// Consumes the builder and constructs an Operation<[`CreateBucket`](crate::operation::CreateBucket)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateBucket,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateBucketInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_9 = &_input.bucket;
                let input_9 = input_9.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_9, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateBucketInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_create_bucket(input, builder)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_create_bucket_input(
                &self.create_bucket_configuration,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateBucket::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateBucket",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateBucketInput`](crate::input::CreateBucketInput)
    pub fn builder() -> crate::input::create_bucket_input::Builder {
        crate::input::create_bucket_input::Builder::default()
    }
}

/// See [`CreateMultipartUploadInput`](crate::input::CreateMultipartUploadInput)
pub mod create_multipart_upload_input {
    /// A builder for [`CreateMultipartUploadInput`](crate::input::CreateMultipartUploadInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) acl: std::option::Option<crate::model::ObjectCannedAcl>,
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) cache_control: std::option::Option<std::string::String>,
        pub(crate) content_disposition: std::option::Option<std::string::String>,
        pub(crate) content_encoding: std::option::Option<std::string::String>,
        pub(crate) content_language: std::option::Option<std::string::String>,
        pub(crate) content_type: std::option::Option<std::string::String>,
        pub(crate) expires: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) grant_full_control: std::option::Option<std::string::String>,
        pub(crate) grant_read: std::option::Option<std::string::String>,
        pub(crate) grant_read_acp: std::option::Option<std::string::String>,
        pub(crate) grant_write_acp: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) metadata: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) server_side_encryption: std::option::Option<crate::model::ServerSideEncryption>,
        pub(crate) storage_class: std::option::Option<crate::model::StorageClass>,
        pub(crate) website_redirect_location: std::option::Option<std::string::String>,
        pub(crate) sse_customer_algorithm: std::option::Option<std::string::String>,
        pub(crate) sse_customer_key: std::option::Option<std::string::String>,
        pub(crate) sse_customer_key_md5: std::option::Option<std::string::String>,
        pub(crate) ssekms_key_id: std::option::Option<std::string::String>,
        pub(crate) ssekms_encryption_context: std::option::Option<std::string::String>,
        pub(crate) bucket_key_enabled: std::option::Option<bool>,
        pub(crate) request_payer: std::option::Option<crate::model::RequestPayer>,
        pub(crate) tagging: std::option::Option<std::string::String>,
        pub(crate) object_lock_mode: std::option::Option<crate::model::ObjectLockMode>,
        pub(crate) object_lock_retain_until_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) object_lock_legal_hold_status:
            std::option::Option<crate::model::ObjectLockLegalHoldStatus>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The canned ACL to apply to the object.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn acl(mut self, input: crate::model::ObjectCannedAcl) -> Self {
            self.acl = Some(input);
            self
        }
        /// <p>The canned ACL to apply to the object.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn set_acl(
            mut self,
            input: std::option::Option<crate::model::ObjectCannedAcl>,
        ) -> Self {
            self.acl = input;
            self
        }
        /// <p>The name of the bucket to which to initiate the upload</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket to which to initiate the upload</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Specifies caching behavior along the request/reply chain.</p>
        pub fn cache_control(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_control = Some(input.into());
            self
        }
        /// <p>Specifies caching behavior along the request/reply chain.</p>
        pub fn set_cache_control(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_control = input;
            self
        }
        /// <p>Specifies presentational information for the object.</p>
        pub fn content_disposition(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_disposition = Some(input.into());
            self
        }
        /// <p>Specifies presentational information for the object.</p>
        pub fn set_content_disposition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.content_disposition = input;
            self
        }
        /// <p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.</p>
        pub fn content_encoding(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_encoding = Some(input.into());
            self
        }
        /// <p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.</p>
        pub fn set_content_encoding(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.content_encoding = input;
            self
        }
        /// <p>The language the content is in.</p>
        pub fn content_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_language = Some(input.into());
            self
        }
        /// <p>The language the content is in.</p>
        pub fn set_content_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.content_language = input;
            self
        }
        /// <p>A standard MIME type describing the format of the object data.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>A standard MIME type describing the format of the object data.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// <p>The date and time at which the object is no longer cacheable.</p>
        pub fn expires(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.expires = Some(input);
            self
        }
        /// <p>The date and time at which the object is no longer cacheable.</p>
        pub fn set_expires(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.expires = input;
            self
        }
        /// <p>Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn grant_full_control(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_full_control = Some(input.into());
            self
        }
        /// <p>Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn set_grant_full_control(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.grant_full_control = input;
            self
        }
        /// <p>Allows grantee to read the object data and its metadata.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn grant_read(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_read = Some(input.into());
            self
        }
        /// <p>Allows grantee to read the object data and its metadata.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn set_grant_read(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.grant_read = input;
            self
        }
        /// <p>Allows grantee to read the object ACL.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn grant_read_acp(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_read_acp = Some(input.into());
            self
        }
        /// <p>Allows grantee to read the object ACL.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn set_grant_read_acp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.grant_read_acp = input;
            self
        }
        /// <p>Allows grantee to write the ACL for the applicable object.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn grant_write_acp(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_write_acp = Some(input.into());
            self
        }
        /// <p>Allows grantee to write the ACL for the applicable object.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn set_grant_write_acp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.grant_write_acp = input;
            self
        }
        /// <p>Object key for which the multipart upload is to be initiated.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>Object key for which the multipart upload is to be initiated.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// Adds a key-value pair to `metadata`.
        ///
        /// To override the contents of this collection use [`set_metadata`](Self::set_metadata).
        ///
        /// <p>A map of metadata to store with the object in S3.</p>
        pub fn metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.metadata = Some(hash_map);
            self
        }
        /// <p>A map of metadata to store with the object in S3.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// <p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example, AES256, aws:kms).</p>
        pub fn server_side_encryption(mut self, input: crate::model::ServerSideEncryption) -> Self {
            self.server_side_encryption = Some(input);
            self
        }
        /// <p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example, AES256, aws:kms).</p>
        pub fn set_server_side_encryption(
            mut self,
            input: std::option::Option<crate::model::ServerSideEncryption>,
        ) -> Self {
            self.server_side_encryption = input;
            self
        }
        /// <p>By default, Amazon S3 uses the STANDARD Storage Class to store newly created objects. The STANDARD storage class provides high durability and high availability. Depending on performance needs, you can specify a different Storage Class. Amazon S3 on Outposts only uses the OUTPOSTS Storage Class. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn storage_class(mut self, input: crate::model::StorageClass) -> Self {
            self.storage_class = Some(input);
            self
        }
        /// <p>By default, Amazon S3 uses the STANDARD Storage Class to store newly created objects. The STANDARD storage class provides high durability and high availability. Depending on performance needs, you can specify a different Storage Class. Amazon S3 on Outposts only uses the OUTPOSTS Storage Class. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_storage_class(
            mut self,
            input: std::option::Option<crate::model::StorageClass>,
        ) -> Self {
            self.storage_class = input;
            self
        }
        /// <p>If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata.</p>
        pub fn website_redirect_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.website_redirect_location = Some(input.into());
            self
        }
        /// <p>If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata.</p>
        pub fn set_website_redirect_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.website_redirect_location = input;
            self
        }
        /// <p>Specifies the algorithm to use to when encrypting the object (for example, AES256).</p>
        pub fn sse_customer_algorithm(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_customer_algorithm = Some(input.into());
            self
        }
        /// <p>Specifies the algorithm to use to when encrypting the object (for example, AES256).</p>
        pub fn set_sse_customer_algorithm(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_customer_algorithm = input;
            self
        }
        /// <p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p>
        pub fn sse_customer_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_customer_key = Some(input.into());
            self
        }
        /// <p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p>
        pub fn set_sse_customer_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_customer_key = input;
            self
        }
        /// <p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>
        pub fn sse_customer_key_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_customer_key_md5 = Some(input.into());
            self
        }
        /// <p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>
        pub fn set_sse_customer_key_md5(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_customer_key_md5 = input;
            self
        }
        /// <p>Specifies the ID of the symmetric customer managed key to use for object encryption. All GET and PUT requests for an object protected by Amazon Web Services KMS will fail if not made via SSL or using SigV4. For information about configuring using any of the officially supported Amazon Web Services SDKs and Amazon Web Services CLI, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html#specify-signature-version">Specifying the Signature Version in Request Authentication</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn ssekms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssekms_key_id = Some(input.into());
            self
        }
        /// <p>Specifies the ID of the symmetric customer managed key to use for object encryption. All GET and PUT requests for an object protected by Amazon Web Services KMS will fail if not made via SSL or using SigV4. For information about configuring using any of the officially supported Amazon Web Services SDKs and Amazon Web Services CLI, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html#specify-signature-version">Specifying the Signature Version in Request Authentication</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_ssekms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssekms_key_id = input;
            self
        }
        /// <p>Specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.</p>
        pub fn ssekms_encryption_context(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssekms_encryption_context = Some(input.into());
            self
        }
        /// <p>Specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.</p>
        pub fn set_ssekms_encryption_context(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssekms_encryption_context = input;
            self
        }
        /// <p>Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption with server-side encryption using AWS KMS (SSE-KMS). Setting this header to <code>true</code> causes Amazon S3 to use an S3 Bucket Key for object encryption with SSE-KMS.</p>
        /// <p>Specifying this header with an object action doesn’t affect bucket-level settings for S3 Bucket Key.</p>
        pub fn bucket_key_enabled(mut self, input: bool) -> Self {
            self.bucket_key_enabled = Some(input);
            self
        }
        /// <p>Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption with server-side encryption using AWS KMS (SSE-KMS). Setting this header to <code>true</code> causes Amazon S3 to use an S3 Bucket Key for object encryption with SSE-KMS.</p>
        /// <p>Specifying this header with an object action doesn’t affect bucket-level settings for S3 Bucket Key.</p>
        pub fn set_bucket_key_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.bucket_key_enabled = input;
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.request_payer = Some(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.request_payer = input;
            self
        }
        /// <p>The tag-set for the object. The tag-set must be encoded as URL Query parameters.</p>
        pub fn tagging(mut self, input: impl Into<std::string::String>) -> Self {
            self.tagging = Some(input.into());
            self
        }
        /// <p>The tag-set for the object. The tag-set must be encoded as URL Query parameters.</p>
        pub fn set_tagging(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tagging = input;
            self
        }
        /// <p>Specifies the Object Lock mode that you want to apply to the uploaded object.</p>
        pub fn object_lock_mode(mut self, input: crate::model::ObjectLockMode) -> Self {
            self.object_lock_mode = Some(input);
            self
        }
        /// <p>Specifies the Object Lock mode that you want to apply to the uploaded object.</p>
        pub fn set_object_lock_mode(
            mut self,
            input: std::option::Option<crate::model::ObjectLockMode>,
        ) -> Self {
            self.object_lock_mode = input;
            self
        }
        /// <p>Specifies the date and time when you want the Object Lock to expire.</p>
        pub fn object_lock_retain_until_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.object_lock_retain_until_date = Some(input);
            self
        }
        /// <p>Specifies the date and time when you want the Object Lock to expire.</p>
        pub fn set_object_lock_retain_until_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.object_lock_retain_until_date = input;
            self
        }
        /// <p>Specifies whether you want to apply a Legal Hold to the uploaded object.</p>
        pub fn object_lock_legal_hold_status(
            mut self,
            input: crate::model::ObjectLockLegalHoldStatus,
        ) -> Self {
            self.object_lock_legal_hold_status = Some(input);
            self
        }
        /// <p>Specifies whether you want to apply a Legal Hold to the uploaded object.</p>
        pub fn set_object_lock_legal_hold_status(
            mut self,
            input: std::option::Option<crate::model::ObjectLockLegalHoldStatus>,
        ) -> Self {
            self.object_lock_legal_hold_status = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMultipartUploadInput`](crate::input::CreateMultipartUploadInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateMultipartUploadInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateMultipartUploadInput {
                acl: self.acl,
                bucket: self.bucket,
                cache_control: self.cache_control,
                content_disposition: self.content_disposition,
                content_encoding: self.content_encoding,
                content_language: self.content_language,
                content_type: self.content_type,
                expires: self.expires,
                grant_full_control: self.grant_full_control,
                grant_read: self.grant_read,
                grant_read_acp: self.grant_read_acp,
                grant_write_acp: self.grant_write_acp,
                key: self.key,
                metadata: self.metadata,
                server_side_encryption: self.server_side_encryption,
                storage_class: self.storage_class,
                website_redirect_location: self.website_redirect_location,
                sse_customer_algorithm: self.sse_customer_algorithm,
                sse_customer_key: self.sse_customer_key,
                sse_customer_key_md5: self.sse_customer_key_md5,
                ssekms_key_id: self.ssekms_key_id,
                ssekms_encryption_context: self.ssekms_encryption_context,
                bucket_key_enabled: self.bucket_key_enabled.unwrap_or_default(),
                request_payer: self.request_payer,
                tagging: self.tagging,
                object_lock_mode: self.object_lock_mode,
                object_lock_retain_until_date: self.object_lock_retain_until_date,
                object_lock_legal_hold_status: self.object_lock_legal_hold_status,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateMultipartUploadInputOperationOutputAlias = crate::operation::CreateMultipartUpload;
#[doc(hidden)]
pub type CreateMultipartUploadInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateMultipartUploadInput {
    /// Consumes the builder and constructs an Operation<[`CreateMultipartUpload`](crate::operation::CreateMultipartUpload)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateMultipartUpload,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateMultipartUploadInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_10 = &_input.bucket;
                let input_10 = input_10.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_10, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                let input_11 = &_input.key;
                let input_11 = input_11.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    },
                )?;
                let key = aws_smithy_http::label::fmt_string(input_11, true);
                if key.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}/{Key}", Bucket = bucket, Key = key)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::CreateMultipartUploadInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("uploads");
                query.push_kv("x-id", "CreateMultipartUpload");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateMultipartUploadInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_create_multipart_upload(input, builder)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateMultipartUpload::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateMultipartUpload",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateMultipartUploadInput`](crate::input::CreateMultipartUploadInput)
    pub fn builder() -> crate::input::create_multipart_upload_input::Builder {
        crate::input::create_multipart_upload_input::Builder::default()
    }
}

/// See [`DeleteBucketInput`](crate::input::DeleteBucketInput)
pub mod delete_bucket_input {
    /// A builder for [`DeleteBucketInput`](crate::input::DeleteBucketInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the bucket being deleted.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>Specifies the bucket being deleted.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBucketInput`](crate::input::DeleteBucketInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBucketInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBucketInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBucketInputOperationOutputAlias = crate::operation::DeleteBucket;
#[doc(hidden)]
pub type DeleteBucketInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBucketInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBucket`](crate::operation::DeleteBucket)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBucket,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteBucketInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_12 = &_input.bucket;
                let input_12 = input_12.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_12, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteBucketInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_delete_bucket(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBucket::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBucket",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteBucketInput`](crate::input::DeleteBucketInput)
    pub fn builder() -> crate::input::delete_bucket_input::Builder {
        crate::input::delete_bucket_input::Builder::default()
    }
}

/// See [`DeleteBucketAnalyticsConfigurationInput`](crate::input::DeleteBucketAnalyticsConfigurationInput)
pub mod delete_bucket_analytics_configuration_input {
    /// A builder for [`DeleteBucketAnalyticsConfigurationInput`](crate::input::DeleteBucketAnalyticsConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket from which an analytics configuration is deleted.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket from which an analytics configuration is deleted.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The ID that identifies the analytics configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID that identifies the analytics configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBucketAnalyticsConfigurationInput`](crate::input::DeleteBucketAnalyticsConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBucketAnalyticsConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBucketAnalyticsConfigurationInput {
                bucket: self.bucket,
                id: self.id,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBucketAnalyticsConfigurationInputOperationOutputAlias =
    crate::operation::DeleteBucketAnalyticsConfiguration;
#[doc(hidden)]
pub type DeleteBucketAnalyticsConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBucketAnalyticsConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBucketAnalyticsConfiguration`](crate::operation::DeleteBucketAnalyticsConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBucketAnalyticsConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteBucketAnalyticsConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_13 = &_input.bucket;
                let input_13 = input_13.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_13, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteBucketAnalyticsConfigurationInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("analytics");
                if let Some(inner_14) = &_input.id {
                    query.push_kv("id", &aws_smithy_http::query::fmt_string(&inner_14));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteBucketAnalyticsConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_delete_bucket_analytics_configuration(
                    input, builder,
                )?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBucketAnalyticsConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBucketAnalyticsConfiguration",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteBucketAnalyticsConfigurationInput`](crate::input::DeleteBucketAnalyticsConfigurationInput)
    pub fn builder() -> crate::input::delete_bucket_analytics_configuration_input::Builder {
        crate::input::delete_bucket_analytics_configuration_input::Builder::default()
    }
}

/// See [`DeleteBucketCorsInput`](crate::input::DeleteBucketCorsInput)
pub mod delete_bucket_cors_input {
    /// A builder for [`DeleteBucketCorsInput`](crate::input::DeleteBucketCorsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the bucket whose <code>cors</code> configuration is being deleted.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>Specifies the bucket whose <code>cors</code> configuration is being deleted.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBucketCorsInput`](crate::input::DeleteBucketCorsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBucketCorsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBucketCorsInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBucketCorsInputOperationOutputAlias = crate::operation::DeleteBucketCors;
#[doc(hidden)]
pub type DeleteBucketCorsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBucketCorsInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBucketCors`](crate::operation::DeleteBucketCors)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBucketCors,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteBucketCorsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_15 = &_input.bucket;
                let input_15 = input_15.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_15, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteBucketCorsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("cors");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteBucketCorsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_delete_bucket_cors(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBucketCors::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBucketCors",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteBucketCorsInput`](crate::input::DeleteBucketCorsInput)
    pub fn builder() -> crate::input::delete_bucket_cors_input::Builder {
        crate::input::delete_bucket_cors_input::Builder::default()
    }
}

/// See [`DeleteBucketEncryptionInput`](crate::input::DeleteBucketEncryptionInput)
pub mod delete_bucket_encryption_input {
    /// A builder for [`DeleteBucketEncryptionInput`](crate::input::DeleteBucketEncryptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket containing the server-side encryption configuration to delete.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket containing the server-side encryption configuration to delete.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBucketEncryptionInput`](crate::input::DeleteBucketEncryptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBucketEncryptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBucketEncryptionInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBucketEncryptionInputOperationOutputAlias = crate::operation::DeleteBucketEncryption;
#[doc(hidden)]
pub type DeleteBucketEncryptionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBucketEncryptionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBucketEncryption`](crate::operation::DeleteBucketEncryption)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBucketEncryption,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteBucketEncryptionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_16 = &_input.bucket;
                let input_16 = input_16.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_16, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteBucketEncryptionInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("encryption");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteBucketEncryptionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_delete_bucket_encryption(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBucketEncryption::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBucketEncryption",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteBucketEncryptionInput`](crate::input::DeleteBucketEncryptionInput)
    pub fn builder() -> crate::input::delete_bucket_encryption_input::Builder {
        crate::input::delete_bucket_encryption_input::Builder::default()
    }
}

/// See [`DeleteBucketIntelligentTieringConfigurationInput`](crate::input::DeleteBucketIntelligentTieringConfigurationInput)
pub mod delete_bucket_intelligent_tiering_configuration_input {
    /// A builder for [`DeleteBucketIntelligentTieringConfigurationInput`](crate::input::DeleteBucketIntelligentTieringConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Amazon S3 bucket whose configuration you want to modify or retrieve.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket whose configuration you want to modify or retrieve.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The ID used to identify the S3 Intelligent-Tiering configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID used to identify the S3 Intelligent-Tiering configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBucketIntelligentTieringConfigurationInput`](crate::input::DeleteBucketIntelligentTieringConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBucketIntelligentTieringConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DeleteBucketIntelligentTieringConfigurationInput {
                    bucket: self.bucket,
                    id: self.id,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DeleteBucketIntelligentTieringConfigurationInputOperationOutputAlias =
    crate::operation::DeleteBucketIntelligentTieringConfiguration;
#[doc(hidden)]
pub type DeleteBucketIntelligentTieringConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBucketIntelligentTieringConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBucketIntelligentTieringConfiguration`](crate::operation::DeleteBucketIntelligentTieringConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBucketIntelligentTieringConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteBucketIntelligentTieringConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_17 = &_input.bucket;
                let input_17 = input_17.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_17, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteBucketIntelligentTieringConfigurationInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("intelligent-tiering");
                if let Some(inner_18) = &_input.id {
                    query.push_kv("id", &aws_smithy_http::query::fmt_string(&inner_18));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteBucketIntelligentTieringConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBucketIntelligentTieringConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBucketIntelligentTieringConfiguration",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteBucketIntelligentTieringConfigurationInput`](crate::input::DeleteBucketIntelligentTieringConfigurationInput)
    pub fn builder() -> crate::input::delete_bucket_intelligent_tiering_configuration_input::Builder
    {
        crate::input::delete_bucket_intelligent_tiering_configuration_input::Builder::default()
    }
}

/// See [`DeleteBucketInventoryConfigurationInput`](crate::input::DeleteBucketInventoryConfigurationInput)
pub mod delete_bucket_inventory_configuration_input {
    /// A builder for [`DeleteBucketInventoryConfigurationInput`](crate::input::DeleteBucketInventoryConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket containing the inventory configuration to delete.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket containing the inventory configuration to delete.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The ID used to identify the inventory configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID used to identify the inventory configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBucketInventoryConfigurationInput`](crate::input::DeleteBucketInventoryConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBucketInventoryConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBucketInventoryConfigurationInput {
                bucket: self.bucket,
                id: self.id,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBucketInventoryConfigurationInputOperationOutputAlias =
    crate::operation::DeleteBucketInventoryConfiguration;
#[doc(hidden)]
pub type DeleteBucketInventoryConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBucketInventoryConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBucketInventoryConfiguration`](crate::operation::DeleteBucketInventoryConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBucketInventoryConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteBucketInventoryConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_19 = &_input.bucket;
                let input_19 = input_19.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_19, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteBucketInventoryConfigurationInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("inventory");
                if let Some(inner_20) = &_input.id {
                    query.push_kv("id", &aws_smithy_http::query::fmt_string(&inner_20));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteBucketInventoryConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_delete_bucket_inventory_configuration(
                    input, builder,
                )?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBucketInventoryConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBucketInventoryConfiguration",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteBucketInventoryConfigurationInput`](crate::input::DeleteBucketInventoryConfigurationInput)
    pub fn builder() -> crate::input::delete_bucket_inventory_configuration_input::Builder {
        crate::input::delete_bucket_inventory_configuration_input::Builder::default()
    }
}

/// See [`DeleteBucketLifecycleInput`](crate::input::DeleteBucketLifecycleInput)
pub mod delete_bucket_lifecycle_input {
    /// A builder for [`DeleteBucketLifecycleInput`](crate::input::DeleteBucketLifecycleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket name of the lifecycle to delete.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name of the lifecycle to delete.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBucketLifecycleInput`](crate::input::DeleteBucketLifecycleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBucketLifecycleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBucketLifecycleInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBucketLifecycleInputOperationOutputAlias = crate::operation::DeleteBucketLifecycle;
#[doc(hidden)]
pub type DeleteBucketLifecycleInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBucketLifecycleInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBucketLifecycle`](crate::operation::DeleteBucketLifecycle)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBucketLifecycle,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteBucketLifecycleInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_21 = &_input.bucket;
                let input_21 = input_21.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_21, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteBucketLifecycleInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("lifecycle");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteBucketLifecycleInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_delete_bucket_lifecycle(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBucketLifecycle::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBucketLifecycle",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteBucketLifecycleInput`](crate::input::DeleteBucketLifecycleInput)
    pub fn builder() -> crate::input::delete_bucket_lifecycle_input::Builder {
        crate::input::delete_bucket_lifecycle_input::Builder::default()
    }
}

/// See [`DeleteBucketMetricsConfigurationInput`](crate::input::DeleteBucketMetricsConfigurationInput)
pub mod delete_bucket_metrics_configuration_input {
    /// A builder for [`DeleteBucketMetricsConfigurationInput`](crate::input::DeleteBucketMetricsConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket containing the metrics configuration to delete.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket containing the metrics configuration to delete.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The ID used to identify the metrics configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID used to identify the metrics configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBucketMetricsConfigurationInput`](crate::input::DeleteBucketMetricsConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBucketMetricsConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBucketMetricsConfigurationInput {
                bucket: self.bucket,
                id: self.id,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBucketMetricsConfigurationInputOperationOutputAlias =
    crate::operation::DeleteBucketMetricsConfiguration;
#[doc(hidden)]
pub type DeleteBucketMetricsConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBucketMetricsConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBucketMetricsConfiguration`](crate::operation::DeleteBucketMetricsConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBucketMetricsConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteBucketMetricsConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_22 = &_input.bucket;
                let input_22 = input_22.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_22, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteBucketMetricsConfigurationInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("metrics");
                if let Some(inner_23) = &_input.id {
                    query.push_kv("id", &aws_smithy_http::query::fmt_string(&inner_23));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteBucketMetricsConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_delete_bucket_metrics_configuration(
                    input, builder,
                )?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBucketMetricsConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBucketMetricsConfiguration",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteBucketMetricsConfigurationInput`](crate::input::DeleteBucketMetricsConfigurationInput)
    pub fn builder() -> crate::input::delete_bucket_metrics_configuration_input::Builder {
        crate::input::delete_bucket_metrics_configuration_input::Builder::default()
    }
}

/// See [`DeleteBucketOwnershipControlsInput`](crate::input::DeleteBucketOwnershipControlsInput)
pub mod delete_bucket_ownership_controls_input {
    /// A builder for [`DeleteBucketOwnershipControlsInput`](crate::input::DeleteBucketOwnershipControlsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon S3 bucket whose <code>OwnershipControls</code> you want to delete. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The Amazon S3 bucket whose <code>OwnershipControls</code> you want to delete. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBucketOwnershipControlsInput`](crate::input::DeleteBucketOwnershipControlsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBucketOwnershipControlsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBucketOwnershipControlsInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBucketOwnershipControlsInputOperationOutputAlias =
    crate::operation::DeleteBucketOwnershipControls;
#[doc(hidden)]
pub type DeleteBucketOwnershipControlsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBucketOwnershipControlsInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBucketOwnershipControls`](crate::operation::DeleteBucketOwnershipControls)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBucketOwnershipControls,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteBucketOwnershipControlsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_24 = &_input.bucket;
                let input_24 = input_24.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_24, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteBucketOwnershipControlsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("ownershipControls");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteBucketOwnershipControlsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_delete_bucket_ownership_controls(
                    input, builder,
                )?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBucketOwnershipControls::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBucketOwnershipControls",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteBucketOwnershipControlsInput`](crate::input::DeleteBucketOwnershipControlsInput)
    pub fn builder() -> crate::input::delete_bucket_ownership_controls_input::Builder {
        crate::input::delete_bucket_ownership_controls_input::Builder::default()
    }
}

/// See [`DeleteBucketPolicyInput`](crate::input::DeleteBucketPolicyInput)
pub mod delete_bucket_policy_input {
    /// A builder for [`DeleteBucketPolicyInput`](crate::input::DeleteBucketPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket name.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBucketPolicyInput`](crate::input::DeleteBucketPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBucketPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBucketPolicyInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBucketPolicyInputOperationOutputAlias = crate::operation::DeleteBucketPolicy;
#[doc(hidden)]
pub type DeleteBucketPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBucketPolicyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBucketPolicy`](crate::operation::DeleteBucketPolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBucketPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteBucketPolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_25 = &_input.bucket;
                let input_25 = input_25.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_25, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteBucketPolicyInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("policy");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteBucketPolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_delete_bucket_policy(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBucketPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBucketPolicy",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteBucketPolicyInput`](crate::input::DeleteBucketPolicyInput)
    pub fn builder() -> crate::input::delete_bucket_policy_input::Builder {
        crate::input::delete_bucket_policy_input::Builder::default()
    }
}

/// See [`DeleteBucketReplicationInput`](crate::input::DeleteBucketReplicationInput)
pub mod delete_bucket_replication_input {
    /// A builder for [`DeleteBucketReplicationInput`](crate::input::DeleteBucketReplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The bucket name. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p> The bucket name. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBucketReplicationInput`](crate::input::DeleteBucketReplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBucketReplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBucketReplicationInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBucketReplicationInputOperationOutputAlias =
    crate::operation::DeleteBucketReplication;
#[doc(hidden)]
pub type DeleteBucketReplicationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBucketReplicationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBucketReplication`](crate::operation::DeleteBucketReplication)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBucketReplication,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteBucketReplicationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_26 = &_input.bucket;
                let input_26 = input_26.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_26, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteBucketReplicationInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("replication");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteBucketReplicationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_delete_bucket_replication(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBucketReplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBucketReplication",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteBucketReplicationInput`](crate::input::DeleteBucketReplicationInput)
    pub fn builder() -> crate::input::delete_bucket_replication_input::Builder {
        crate::input::delete_bucket_replication_input::Builder::default()
    }
}

/// See [`DeleteBucketTaggingInput`](crate::input::DeleteBucketTaggingInput)
pub mod delete_bucket_tagging_input {
    /// A builder for [`DeleteBucketTaggingInput`](crate::input::DeleteBucketTaggingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket that has the tag set to be removed.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket that has the tag set to be removed.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBucketTaggingInput`](crate::input::DeleteBucketTaggingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBucketTaggingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBucketTaggingInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBucketTaggingInputOperationOutputAlias = crate::operation::DeleteBucketTagging;
#[doc(hidden)]
pub type DeleteBucketTaggingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBucketTaggingInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBucketTagging`](crate::operation::DeleteBucketTagging)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBucketTagging,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteBucketTaggingInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_27 = &_input.bucket;
                let input_27 = input_27.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_27, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteBucketTaggingInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("tagging");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteBucketTaggingInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_delete_bucket_tagging(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBucketTagging::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBucketTagging",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteBucketTaggingInput`](crate::input::DeleteBucketTaggingInput)
    pub fn builder() -> crate::input::delete_bucket_tagging_input::Builder {
        crate::input::delete_bucket_tagging_input::Builder::default()
    }
}

/// See [`DeleteBucketWebsiteInput`](crate::input::DeleteBucketWebsiteInput)
pub mod delete_bucket_website_input {
    /// A builder for [`DeleteBucketWebsiteInput`](crate::input::DeleteBucketWebsiteInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket name for which you want to remove the website configuration. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name for which you want to remove the website configuration. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBucketWebsiteInput`](crate::input::DeleteBucketWebsiteInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBucketWebsiteInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBucketWebsiteInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBucketWebsiteInputOperationOutputAlias = crate::operation::DeleteBucketWebsite;
#[doc(hidden)]
pub type DeleteBucketWebsiteInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBucketWebsiteInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBucketWebsite`](crate::operation::DeleteBucketWebsite)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBucketWebsite,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteBucketWebsiteInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_28 = &_input.bucket;
                let input_28 = input_28.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_28, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteBucketWebsiteInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("website");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteBucketWebsiteInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_delete_bucket_website(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBucketWebsite::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBucketWebsite",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteBucketWebsiteInput`](crate::input::DeleteBucketWebsiteInput)
    pub fn builder() -> crate::input::delete_bucket_website_input::Builder {
        crate::input::delete_bucket_website_input::Builder::default()
    }
}

/// See [`DeleteObjectInput`](crate::input::DeleteObjectInput)
pub mod delete_object_input {
    /// A builder for [`DeleteObjectInput`](crate::input::DeleteObjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) mfa: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) request_payer: std::option::Option<crate::model::RequestPayer>,
        pub(crate) bypass_governance_retention: std::option::Option<bool>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket name of the bucket containing the object. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name of the bucket containing the object. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Key name of the object to delete.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>Key name of the object to delete.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The concatenation of the authentication device's serial number, a space, and the value that is displayed on your authentication device. Required to permanently delete a versioned object if versioning is configured with MFA delete enabled.</p>
        pub fn mfa(mut self, input: impl Into<std::string::String>) -> Self {
            self.mfa = Some(input.into());
            self
        }
        /// <p>The concatenation of the authentication device's serial number, a space, and the value that is displayed on your authentication device. Required to permanently delete a versioned object if versioning is configured with MFA delete enabled.</p>
        pub fn set_mfa(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mfa = input;
            self
        }
        /// <p>VersionId used to reference a specific version of the object.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>VersionId used to reference a specific version of the object.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.request_payer = Some(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.request_payer = input;
            self
        }
        /// <p>Indicates whether S3 Object Lock should bypass Governance-mode restrictions to process this operation. To use this header, you must have the <code>s3:PutBucketPublicAccessBlock</code> permission.</p>
        pub fn bypass_governance_retention(mut self, input: bool) -> Self {
            self.bypass_governance_retention = Some(input);
            self
        }
        /// <p>Indicates whether S3 Object Lock should bypass Governance-mode restrictions to process this operation. To use this header, you must have the <code>s3:PutBucketPublicAccessBlock</code> permission.</p>
        pub fn set_bypass_governance_retention(mut self, input: std::option::Option<bool>) -> Self {
            self.bypass_governance_retention = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteObjectInput`](crate::input::DeleteObjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteObjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteObjectInput {
                bucket: self.bucket,
                key: self.key,
                mfa: self.mfa,
                version_id: self.version_id,
                request_payer: self.request_payer,
                bypass_governance_retention: self.bypass_governance_retention.unwrap_or_default(),
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteObjectInputOperationOutputAlias = crate::operation::DeleteObject;
#[doc(hidden)]
pub type DeleteObjectInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteObjectInput {
    /// Consumes the builder and constructs an Operation<[`DeleteObject`](crate::operation::DeleteObject)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    async fn _make_presigned_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteObject,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteObjectInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_29 = &_input.bucket;
                let input_29 = input_29.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_29, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                let input_30 = &_input.key;
                let input_30 = input_30.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    },
                )?;
                let key = aws_smithy_http::label::fmt_string(input_30, true);
                if key.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}/{Key}", Bucket = bucket, Key = key)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteObjectInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_kv("x-id", "DeleteObject");
                if let Some(inner_31) = &_input.version_id {
                    query.push_kv("versionId", &aws_smithy_http::query::fmt_string(&inner_31));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteObjectInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_delete_object(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteObject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteObject",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    ///
    /// Creates a presigned request for this operation.
    ///
    /// The credentials provider from the `config` will be used to generate the request's signature.
    /// The `presigning_config` provides additional presigning-specific config values, such as the
    /// amount of time the request should be valid for after creation.
    ///
    /// Presigned requests can be given to other users or applications to access a resource or perform
    /// an operation without having access to the AWS security credentials.
    ///
    pub async fn presigned(
        self,
        config: &crate::config::Config,
        presigning_config: crate::presigning::config::PresigningConfig,
    ) -> Result<
        crate::presigning::request::PresignedRequest,
        aws_smithy_http::result::SdkError<crate::error::DeleteObjectError>,
    > {
        let (mut request, _) = self
            ._make_presigned_operation(config)
            .await
            .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
            .into_request_response();
        {
            // Change signature type to query params and wire up presigning config
            let mut props = request.properties_mut();
            props.insert(presigning_config.start_time());
            props.insert(aws_sigv4::http_request::SignableBody::UnsignedPayload);
            let mut config = props
                .get_mut::<aws_sig_auth::signer::OperationSigningConfig>()
                .expect("signing config added by make_operation()");
            config.signature_type = aws_sig_auth::signer::HttpSignatureType::HttpRequestQueryParams;
            config.expires_in = Some(presigning_config.expires());
        }
        let middleware = crate::middleware::DefaultMiddleware::default();
        let mut svc = tower::builder::ServiceBuilder::new()
            .layer(&middleware)
            .service(crate::presigning::service::PresignedRequestService::new());

        use tower::{Service, ServiceExt};
        Ok(svc.ready().await?.call(request).await?)
    }
    /// Consumes the builder and constructs an Operation<[`DeleteObject`](crate::operation::DeleteObject)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteObject,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteObjectInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_32 = &_input.bucket;
                let input_32 = input_32.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_32, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                let input_33 = &_input.key;
                let input_33 = input_33.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    },
                )?;
                let key = aws_smithy_http::label::fmt_string(input_33, true);
                if key.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}/{Key}", Bucket = bucket, Key = key)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteObjectInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_kv("x-id", "DeleteObject");
                if let Some(inner_34) = &_input.version_id {
                    query.push_kv("versionId", &aws_smithy_http::query::fmt_string(&inner_34));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteObjectInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_delete_object(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteObject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteObject",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteObjectInput`](crate::input::DeleteObjectInput)
    pub fn builder() -> crate::input::delete_object_input::Builder {
        crate::input::delete_object_input::Builder::default()
    }
}

/// See [`DeleteObjectsInput`](crate::input::DeleteObjectsInput)
pub mod delete_objects_input {
    /// A builder for [`DeleteObjectsInput`](crate::input::DeleteObjectsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) delete: std::option::Option<crate::model::Delete>,
        pub(crate) mfa: std::option::Option<std::string::String>,
        pub(crate) request_payer: std::option::Option<crate::model::RequestPayer>,
        pub(crate) bypass_governance_retention: std::option::Option<bool>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket name containing the objects to delete. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name containing the objects to delete. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Container for the request.</p>
        pub fn delete(mut self, input: crate::model::Delete) -> Self {
            self.delete = Some(input);
            self
        }
        /// <p>Container for the request.</p>
        pub fn set_delete(mut self, input: std::option::Option<crate::model::Delete>) -> Self {
            self.delete = input;
            self
        }
        /// <p>The concatenation of the authentication device's serial number, a space, and the value that is displayed on your authentication device. Required to permanently delete a versioned object if versioning is configured with MFA delete enabled.</p>
        pub fn mfa(mut self, input: impl Into<std::string::String>) -> Self {
            self.mfa = Some(input.into());
            self
        }
        /// <p>The concatenation of the authentication device's serial number, a space, and the value that is displayed on your authentication device. Required to permanently delete a versioned object if versioning is configured with MFA delete enabled.</p>
        pub fn set_mfa(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mfa = input;
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.request_payer = Some(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.request_payer = input;
            self
        }
        /// <p>Specifies whether you want to delete this object even if it has a Governance-type Object Lock in place. To use this header, you must have the <code>s3:PutBucketPublicAccessBlock</code> permission.</p>
        pub fn bypass_governance_retention(mut self, input: bool) -> Self {
            self.bypass_governance_retention = Some(input);
            self
        }
        /// <p>Specifies whether you want to delete this object even if it has a Governance-type Object Lock in place. To use this header, you must have the <code>s3:PutBucketPublicAccessBlock</code> permission.</p>
        pub fn set_bypass_governance_retention(mut self, input: std::option::Option<bool>) -> Self {
            self.bypass_governance_retention = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteObjectsInput`](crate::input::DeleteObjectsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteObjectsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteObjectsInput {
                bucket: self.bucket,
                delete: self.delete,
                mfa: self.mfa,
                request_payer: self.request_payer,
                bypass_governance_retention: self.bypass_governance_retention.unwrap_or_default(),
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteObjectsInputOperationOutputAlias = crate::operation::DeleteObjects;
#[doc(hidden)]
pub type DeleteObjectsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteObjectsInput {
    /// Consumes the builder and constructs an Operation<[`DeleteObjects`](crate::operation::DeleteObjects)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteObjects,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteObjectsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_35 = &_input.bucket;
                let input_35 = input_35.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_35, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteObjectsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("delete");
                query.push_kv("x-id", "DeleteObjects");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteObjectsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_delete_objects(input, builder)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_delete_objects_input(&self.delete)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request = request.augment(|mut req, _| {
            let data = req
                .body()
                .bytes()
                .expect("checksum can only be computed for non-streaming operations");
            let checksum = md5::compute(data);
            req.headers_mut().insert(
                http::header::HeaderName::from_static("content-md5"),
                aws_smithy_types::base64::encode(&checksum[..])
                    .parse()
                    .expect("checksum is valid header value"),
            );
            Result::<_, aws_smithy_http::operation::BuildError>::Ok(req)
        })?;
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteObjects::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteObjects",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteObjectsInput`](crate::input::DeleteObjectsInput)
    pub fn builder() -> crate::input::delete_objects_input::Builder {
        crate::input::delete_objects_input::Builder::default()
    }
}

/// See [`DeleteObjectTaggingInput`](crate::input::DeleteObjectTaggingInput)
pub mod delete_object_tagging_input {
    /// A builder for [`DeleteObjectTaggingInput`](crate::input::DeleteObjectTaggingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket name containing the objects from which to remove the tags. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name containing the objects from which to remove the tags. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The key that identifies the object in the bucket from which to remove all tags.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key that identifies the object in the bucket from which to remove all tags.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The versionId of the object that the tag-set will be removed from.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The versionId of the object that the tag-set will be removed from.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteObjectTaggingInput`](crate::input::DeleteObjectTaggingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteObjectTaggingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteObjectTaggingInput {
                bucket: self.bucket,
                key: self.key,
                version_id: self.version_id,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteObjectTaggingInputOperationOutputAlias = crate::operation::DeleteObjectTagging;
#[doc(hidden)]
pub type DeleteObjectTaggingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteObjectTaggingInput {
    /// Consumes the builder and constructs an Operation<[`DeleteObjectTagging`](crate::operation::DeleteObjectTagging)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteObjectTagging,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteObjectTaggingInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_36 = &_input.bucket;
                let input_36 = input_36.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_36, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                let input_37 = &_input.key;
                let input_37 = input_37.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    },
                )?;
                let key = aws_smithy_http::label::fmt_string(input_37, true);
                if key.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}/{Key}", Bucket = bucket, Key = key)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteObjectTaggingInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("tagging");
                if let Some(inner_38) = &_input.version_id {
                    query.push_kv("versionId", &aws_smithy_http::query::fmt_string(&inner_38));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteObjectTaggingInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_delete_object_tagging(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteObjectTagging::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteObjectTagging",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteObjectTaggingInput`](crate::input::DeleteObjectTaggingInput)
    pub fn builder() -> crate::input::delete_object_tagging_input::Builder {
        crate::input::delete_object_tagging_input::Builder::default()
    }
}

/// See [`DeletePublicAccessBlockInput`](crate::input::DeletePublicAccessBlockInput)
pub mod delete_public_access_block_input {
    /// A builder for [`DeletePublicAccessBlockInput`](crate::input::DeletePublicAccessBlockInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon S3 bucket whose <code>PublicAccessBlock</code> configuration you want to delete. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The Amazon S3 bucket whose <code>PublicAccessBlock</code> configuration you want to delete. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePublicAccessBlockInput`](crate::input::DeletePublicAccessBlockInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePublicAccessBlockInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePublicAccessBlockInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DeletePublicAccessBlockInputOperationOutputAlias =
    crate::operation::DeletePublicAccessBlock;
#[doc(hidden)]
pub type DeletePublicAccessBlockInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeletePublicAccessBlockInput {
    /// Consumes the builder and constructs an Operation<[`DeletePublicAccessBlock`](crate::operation::DeletePublicAccessBlock)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePublicAccessBlock,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeletePublicAccessBlockInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_39 = &_input.bucket;
                let input_39 = input_39.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_39, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeletePublicAccessBlockInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("publicAccessBlock");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeletePublicAccessBlockInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_delete_public_access_block(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePublicAccessBlock::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePublicAccessBlock",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeletePublicAccessBlockInput`](crate::input::DeletePublicAccessBlockInput)
    pub fn builder() -> crate::input::delete_public_access_block_input::Builder {
        crate::input::delete_public_access_block_input::Builder::default()
    }
}

/// See [`GetBucketAccelerateConfigurationInput`](crate::input::GetBucketAccelerateConfigurationInput)
pub mod get_bucket_accelerate_configuration_input {
    /// A builder for [`GetBucketAccelerateConfigurationInput`](crate::input::GetBucketAccelerateConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket for which the accelerate configuration is retrieved.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket for which the accelerate configuration is retrieved.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketAccelerateConfigurationInput`](crate::input::GetBucketAccelerateConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketAccelerateConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketAccelerateConfigurationInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketAccelerateConfigurationInputOperationOutputAlias =
    crate::operation::GetBucketAccelerateConfiguration;
#[doc(hidden)]
pub type GetBucketAccelerateConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketAccelerateConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketAccelerateConfiguration`](crate::operation::GetBucketAccelerateConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketAccelerateConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetBucketAccelerateConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_40 = &_input.bucket;
                let input_40 = input_40.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_40, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetBucketAccelerateConfigurationInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("accelerate");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetBucketAccelerateConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_get_bucket_accelerate_configuration(
                    input, builder,
                )?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketAccelerateConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketAccelerateConfiguration",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetBucketAccelerateConfigurationInput`](crate::input::GetBucketAccelerateConfigurationInput)
    pub fn builder() -> crate::input::get_bucket_accelerate_configuration_input::Builder {
        crate::input::get_bucket_accelerate_configuration_input::Builder::default()
    }
}

/// See [`GetBucketAclInput`](crate::input::GetBucketAclInput)
pub mod get_bucket_acl_input {
    /// A builder for [`GetBucketAclInput`](crate::input::GetBucketAclInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the S3 bucket whose ACL is being requested.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>Specifies the S3 bucket whose ACL is being requested.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketAclInput`](crate::input::GetBucketAclInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketAclInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketAclInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketAclInputOperationOutputAlias = crate::operation::GetBucketAcl;
#[doc(hidden)]
pub type GetBucketAclInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketAclInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketAcl`](crate::operation::GetBucketAcl)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketAcl,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetBucketAclInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_41 = &_input.bucket;
                let input_41 = input_41.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_41, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetBucketAclInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("acl");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetBucketAclInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_get_bucket_acl(input, builder)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketAcl::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketAcl",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetBucketAclInput`](crate::input::GetBucketAclInput)
    pub fn builder() -> crate::input::get_bucket_acl_input::Builder {
        crate::input::get_bucket_acl_input::Builder::default()
    }
}

/// See [`GetBucketAnalyticsConfigurationInput`](crate::input::GetBucketAnalyticsConfigurationInput)
pub mod get_bucket_analytics_configuration_input {
    /// A builder for [`GetBucketAnalyticsConfigurationInput`](crate::input::GetBucketAnalyticsConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket from which an analytics configuration is retrieved.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket from which an analytics configuration is retrieved.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The ID that identifies the analytics configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID that identifies the analytics configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketAnalyticsConfigurationInput`](crate::input::GetBucketAnalyticsConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketAnalyticsConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketAnalyticsConfigurationInput {
                bucket: self.bucket,
                id: self.id,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketAnalyticsConfigurationInputOperationOutputAlias =
    crate::operation::GetBucketAnalyticsConfiguration;
#[doc(hidden)]
pub type GetBucketAnalyticsConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketAnalyticsConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketAnalyticsConfiguration`](crate::operation::GetBucketAnalyticsConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketAnalyticsConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetBucketAnalyticsConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_42 = &_input.bucket;
                let input_42 = input_42.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_42, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetBucketAnalyticsConfigurationInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("analytics");
                query.push_kv("x-id", "GetBucketAnalyticsConfiguration");
                if let Some(inner_43) = &_input.id {
                    query.push_kv("id", &aws_smithy_http::query::fmt_string(&inner_43));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetBucketAnalyticsConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_get_bucket_analytics_configuration(
                    input, builder,
                )?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketAnalyticsConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketAnalyticsConfiguration",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetBucketAnalyticsConfigurationInput`](crate::input::GetBucketAnalyticsConfigurationInput)
    pub fn builder() -> crate::input::get_bucket_analytics_configuration_input::Builder {
        crate::input::get_bucket_analytics_configuration_input::Builder::default()
    }
}

/// See [`GetBucketCorsInput`](crate::input::GetBucketCorsInput)
pub mod get_bucket_cors_input {
    /// A builder for [`GetBucketCorsInput`](crate::input::GetBucketCorsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket name for which to get the cors configuration.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name for which to get the cors configuration.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketCorsInput`](crate::input::GetBucketCorsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketCorsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketCorsInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketCorsInputOperationOutputAlias = crate::operation::GetBucketCors;
#[doc(hidden)]
pub type GetBucketCorsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketCorsInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketCors`](crate::operation::GetBucketCors)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketCors,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetBucketCorsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_44 = &_input.bucket;
                let input_44 = input_44.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_44, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetBucketCorsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("cors");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetBucketCorsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_get_bucket_cors(input, builder)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketCors::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketCors",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetBucketCorsInput`](crate::input::GetBucketCorsInput)
    pub fn builder() -> crate::input::get_bucket_cors_input::Builder {
        crate::input::get_bucket_cors_input::Builder::default()
    }
}

/// See [`GetBucketEncryptionInput`](crate::input::GetBucketEncryptionInput)
pub mod get_bucket_encryption_input {
    /// A builder for [`GetBucketEncryptionInput`](crate::input::GetBucketEncryptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket from which the server-side encryption configuration is retrieved.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket from which the server-side encryption configuration is retrieved.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketEncryptionInput`](crate::input::GetBucketEncryptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketEncryptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketEncryptionInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketEncryptionInputOperationOutputAlias = crate::operation::GetBucketEncryption;
#[doc(hidden)]
pub type GetBucketEncryptionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketEncryptionInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketEncryption`](crate::operation::GetBucketEncryption)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketEncryption,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetBucketEncryptionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_45 = &_input.bucket;
                let input_45 = input_45.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_45, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetBucketEncryptionInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("encryption");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetBucketEncryptionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_get_bucket_encryption(input, builder)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketEncryption::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketEncryption",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetBucketEncryptionInput`](crate::input::GetBucketEncryptionInput)
    pub fn builder() -> crate::input::get_bucket_encryption_input::Builder {
        crate::input::get_bucket_encryption_input::Builder::default()
    }
}

/// See [`GetBucketIntelligentTieringConfigurationInput`](crate::input::GetBucketIntelligentTieringConfigurationInput)
pub mod get_bucket_intelligent_tiering_configuration_input {
    /// A builder for [`GetBucketIntelligentTieringConfigurationInput`](crate::input::GetBucketIntelligentTieringConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Amazon S3 bucket whose configuration you want to modify or retrieve.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket whose configuration you want to modify or retrieve.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The ID used to identify the S3 Intelligent-Tiering configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID used to identify the S3 Intelligent-Tiering configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketIntelligentTieringConfigurationInput`](crate::input::GetBucketIntelligentTieringConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketIntelligentTieringConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::GetBucketIntelligentTieringConfigurationInput {
                    bucket: self.bucket,
                    id: self.id,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type GetBucketIntelligentTieringConfigurationInputOperationOutputAlias =
    crate::operation::GetBucketIntelligentTieringConfiguration;
#[doc(hidden)]
pub type GetBucketIntelligentTieringConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketIntelligentTieringConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketIntelligentTieringConfiguration`](crate::operation::GetBucketIntelligentTieringConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketIntelligentTieringConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetBucketIntelligentTieringConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_46 = &_input.bucket;
                let input_46 = input_46.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_46, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetBucketIntelligentTieringConfigurationInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("intelligent-tiering");
                query.push_kv("x-id", "GetBucketIntelligentTieringConfiguration");
                if let Some(inner_47) = &_input.id {
                    query.push_kv("id", &aws_smithy_http::query::fmt_string(&inner_47));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetBucketIntelligentTieringConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketIntelligentTieringConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketIntelligentTieringConfiguration",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetBucketIntelligentTieringConfigurationInput`](crate::input::GetBucketIntelligentTieringConfigurationInput)
    pub fn builder() -> crate::input::get_bucket_intelligent_tiering_configuration_input::Builder {
        crate::input::get_bucket_intelligent_tiering_configuration_input::Builder::default()
    }
}

/// See [`GetBucketInventoryConfigurationInput`](crate::input::GetBucketInventoryConfigurationInput)
pub mod get_bucket_inventory_configuration_input {
    /// A builder for [`GetBucketInventoryConfigurationInput`](crate::input::GetBucketInventoryConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket containing the inventory configuration to retrieve.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket containing the inventory configuration to retrieve.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The ID used to identify the inventory configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID used to identify the inventory configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketInventoryConfigurationInput`](crate::input::GetBucketInventoryConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketInventoryConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketInventoryConfigurationInput {
                bucket: self.bucket,
                id: self.id,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketInventoryConfigurationInputOperationOutputAlias =
    crate::operation::GetBucketInventoryConfiguration;
#[doc(hidden)]
pub type GetBucketInventoryConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketInventoryConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketInventoryConfiguration`](crate::operation::GetBucketInventoryConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketInventoryConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetBucketInventoryConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_48 = &_input.bucket;
                let input_48 = input_48.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_48, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetBucketInventoryConfigurationInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("inventory");
                query.push_kv("x-id", "GetBucketInventoryConfiguration");
                if let Some(inner_49) = &_input.id {
                    query.push_kv("id", &aws_smithy_http::query::fmt_string(&inner_49));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetBucketInventoryConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_get_bucket_inventory_configuration(
                    input, builder,
                )?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketInventoryConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketInventoryConfiguration",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetBucketInventoryConfigurationInput`](crate::input::GetBucketInventoryConfigurationInput)
    pub fn builder() -> crate::input::get_bucket_inventory_configuration_input::Builder {
        crate::input::get_bucket_inventory_configuration_input::Builder::default()
    }
}

/// See [`GetBucketLifecycleConfigurationInput`](crate::input::GetBucketLifecycleConfigurationInput)
pub mod get_bucket_lifecycle_configuration_input {
    /// A builder for [`GetBucketLifecycleConfigurationInput`](crate::input::GetBucketLifecycleConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket for which to get the lifecycle information.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket for which to get the lifecycle information.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketLifecycleConfigurationInput`](crate::input::GetBucketLifecycleConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketLifecycleConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketLifecycleConfigurationInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketLifecycleConfigurationInputOperationOutputAlias =
    crate::operation::GetBucketLifecycleConfiguration;
#[doc(hidden)]
pub type GetBucketLifecycleConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketLifecycleConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketLifecycleConfiguration`](crate::operation::GetBucketLifecycleConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketLifecycleConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetBucketLifecycleConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_50 = &_input.bucket;
                let input_50 = input_50.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_50, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetBucketLifecycleConfigurationInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("lifecycle");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetBucketLifecycleConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_get_bucket_lifecycle_configuration(
                    input, builder,
                )?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketLifecycleConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketLifecycleConfiguration",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetBucketLifecycleConfigurationInput`](crate::input::GetBucketLifecycleConfigurationInput)
    pub fn builder() -> crate::input::get_bucket_lifecycle_configuration_input::Builder {
        crate::input::get_bucket_lifecycle_configuration_input::Builder::default()
    }
}

/// See [`GetBucketLocationInput`](crate::input::GetBucketLocationInput)
pub mod get_bucket_location_input {
    /// A builder for [`GetBucketLocationInput`](crate::input::GetBucketLocationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket for which to get the location.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket for which to get the location.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketLocationInput`](crate::input::GetBucketLocationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketLocationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketLocationInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketLocationInputOperationOutputAlias = crate::operation::GetBucketLocation;
#[doc(hidden)]
pub type GetBucketLocationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketLocationInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketLocation`](crate::operation::GetBucketLocation)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketLocation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetBucketLocationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_51 = &_input.bucket;
                let input_51 = input_51.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_51, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetBucketLocationInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("location");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetBucketLocationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_get_bucket_location(input, builder)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketLocation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketLocation",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetBucketLocationInput`](crate::input::GetBucketLocationInput)
    pub fn builder() -> crate::input::get_bucket_location_input::Builder {
        crate::input::get_bucket_location_input::Builder::default()
    }
}

/// See [`GetBucketLoggingInput`](crate::input::GetBucketLoggingInput)
pub mod get_bucket_logging_input {
    /// A builder for [`GetBucketLoggingInput`](crate::input::GetBucketLoggingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket name for which to get the logging information.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name for which to get the logging information.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketLoggingInput`](crate::input::GetBucketLoggingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketLoggingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketLoggingInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketLoggingInputOperationOutputAlias = crate::operation::GetBucketLogging;
#[doc(hidden)]
pub type GetBucketLoggingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketLoggingInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketLogging`](crate::operation::GetBucketLogging)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketLogging,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetBucketLoggingInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_52 = &_input.bucket;
                let input_52 = input_52.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_52, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetBucketLoggingInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("logging");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetBucketLoggingInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_get_bucket_logging(input, builder)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketLogging::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketLogging",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetBucketLoggingInput`](crate::input::GetBucketLoggingInput)
    pub fn builder() -> crate::input::get_bucket_logging_input::Builder {
        crate::input::get_bucket_logging_input::Builder::default()
    }
}

/// See [`GetBucketMetricsConfigurationInput`](crate::input::GetBucketMetricsConfigurationInput)
pub mod get_bucket_metrics_configuration_input {
    /// A builder for [`GetBucketMetricsConfigurationInput`](crate::input::GetBucketMetricsConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket containing the metrics configuration to retrieve.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket containing the metrics configuration to retrieve.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The ID used to identify the metrics configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID used to identify the metrics configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketMetricsConfigurationInput`](crate::input::GetBucketMetricsConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketMetricsConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketMetricsConfigurationInput {
                bucket: self.bucket,
                id: self.id,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketMetricsConfigurationInputOperationOutputAlias =
    crate::operation::GetBucketMetricsConfiguration;
#[doc(hidden)]
pub type GetBucketMetricsConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketMetricsConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketMetricsConfiguration`](crate::operation::GetBucketMetricsConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketMetricsConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetBucketMetricsConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_53 = &_input.bucket;
                let input_53 = input_53.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_53, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetBucketMetricsConfigurationInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("metrics");
                query.push_kv("x-id", "GetBucketMetricsConfiguration");
                if let Some(inner_54) = &_input.id {
                    query.push_kv("id", &aws_smithy_http::query::fmt_string(&inner_54));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetBucketMetricsConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_get_bucket_metrics_configuration(
                    input, builder,
                )?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketMetricsConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketMetricsConfiguration",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetBucketMetricsConfigurationInput`](crate::input::GetBucketMetricsConfigurationInput)
    pub fn builder() -> crate::input::get_bucket_metrics_configuration_input::Builder {
        crate::input::get_bucket_metrics_configuration_input::Builder::default()
    }
}

/// See [`GetBucketNotificationConfigurationInput`](crate::input::GetBucketNotificationConfigurationInput)
pub mod get_bucket_notification_configuration_input {
    /// A builder for [`GetBucketNotificationConfigurationInput`](crate::input::GetBucketNotificationConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket for which to get the notification configuration.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket for which to get the notification configuration.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketNotificationConfigurationInput`](crate::input::GetBucketNotificationConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketNotificationConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketNotificationConfigurationInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketNotificationConfigurationInputOperationOutputAlias =
    crate::operation::GetBucketNotificationConfiguration;
#[doc(hidden)]
pub type GetBucketNotificationConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketNotificationConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketNotificationConfiguration`](crate::operation::GetBucketNotificationConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketNotificationConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetBucketNotificationConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_55 = &_input.bucket;
                let input_55 = input_55.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_55, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetBucketNotificationConfigurationInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("notification");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetBucketNotificationConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_get_bucket_notification_configuration(
                    input, builder,
                )?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketNotificationConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketNotificationConfiguration",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetBucketNotificationConfigurationInput`](crate::input::GetBucketNotificationConfigurationInput)
    pub fn builder() -> crate::input::get_bucket_notification_configuration_input::Builder {
        crate::input::get_bucket_notification_configuration_input::Builder::default()
    }
}

/// See [`GetBucketOwnershipControlsInput`](crate::input::GetBucketOwnershipControlsInput)
pub mod get_bucket_ownership_controls_input {
    /// A builder for [`GetBucketOwnershipControlsInput`](crate::input::GetBucketOwnershipControlsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Amazon S3 bucket whose <code>OwnershipControls</code> you want to retrieve. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket whose <code>OwnershipControls</code> you want to retrieve. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketOwnershipControlsInput`](crate::input::GetBucketOwnershipControlsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketOwnershipControlsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketOwnershipControlsInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketOwnershipControlsInputOperationOutputAlias =
    crate::operation::GetBucketOwnershipControls;
#[doc(hidden)]
pub type GetBucketOwnershipControlsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketOwnershipControlsInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketOwnershipControls`](crate::operation::GetBucketOwnershipControls)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketOwnershipControls,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetBucketOwnershipControlsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_56 = &_input.bucket;
                let input_56 = input_56.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_56, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetBucketOwnershipControlsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("ownershipControls");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetBucketOwnershipControlsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_get_bucket_ownership_controls(input, builder)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketOwnershipControls::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketOwnershipControls",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetBucketOwnershipControlsInput`](crate::input::GetBucketOwnershipControlsInput)
    pub fn builder() -> crate::input::get_bucket_ownership_controls_input::Builder {
        crate::input::get_bucket_ownership_controls_input::Builder::default()
    }
}

/// See [`GetBucketPolicyInput`](crate::input::GetBucketPolicyInput)
pub mod get_bucket_policy_input {
    /// A builder for [`GetBucketPolicyInput`](crate::input::GetBucketPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket name for which to get the bucket policy.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name for which to get the bucket policy.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketPolicyInput`](crate::input::GetBucketPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketPolicyInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketPolicyInputOperationOutputAlias = crate::operation::GetBucketPolicy;
#[doc(hidden)]
pub type GetBucketPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketPolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketPolicy`](crate::operation::GetBucketPolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetBucketPolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_57 = &_input.bucket;
                let input_57 = input_57.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_57, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetBucketPolicyInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("policy");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetBucketPolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_get_bucket_policy(input, builder)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketPolicy",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetBucketPolicyInput`](crate::input::GetBucketPolicyInput)
    pub fn builder() -> crate::input::get_bucket_policy_input::Builder {
        crate::input::get_bucket_policy_input::Builder::default()
    }
}

/// See [`GetBucketPolicyStatusInput`](crate::input::GetBucketPolicyStatusInput)
pub mod get_bucket_policy_status_input {
    /// A builder for [`GetBucketPolicyStatusInput`](crate::input::GetBucketPolicyStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Amazon S3 bucket whose policy status you want to retrieve.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket whose policy status you want to retrieve.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketPolicyStatusInput`](crate::input::GetBucketPolicyStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketPolicyStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketPolicyStatusInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketPolicyStatusInputOperationOutputAlias = crate::operation::GetBucketPolicyStatus;
#[doc(hidden)]
pub type GetBucketPolicyStatusInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketPolicyStatusInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketPolicyStatus`](crate::operation::GetBucketPolicyStatus)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketPolicyStatus,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetBucketPolicyStatusInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_58 = &_input.bucket;
                let input_58 = input_58.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_58, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetBucketPolicyStatusInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("policyStatus");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetBucketPolicyStatusInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_get_bucket_policy_status(input, builder)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketPolicyStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketPolicyStatus",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetBucketPolicyStatusInput`](crate::input::GetBucketPolicyStatusInput)
    pub fn builder() -> crate::input::get_bucket_policy_status_input::Builder {
        crate::input::get_bucket_policy_status_input::Builder::default()
    }
}

/// See [`GetBucketReplicationInput`](crate::input::GetBucketReplicationInput)
pub mod get_bucket_replication_input {
    /// A builder for [`GetBucketReplicationInput`](crate::input::GetBucketReplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket name for which to get the replication information.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name for which to get the replication information.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketReplicationInput`](crate::input::GetBucketReplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketReplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketReplicationInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketReplicationInputOperationOutputAlias = crate::operation::GetBucketReplication;
#[doc(hidden)]
pub type GetBucketReplicationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketReplicationInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketReplication`](crate::operation::GetBucketReplication)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketReplication,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetBucketReplicationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_59 = &_input.bucket;
                let input_59 = input_59.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_59, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetBucketReplicationInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("replication");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetBucketReplicationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_get_bucket_replication(input, builder)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketReplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketReplication",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetBucketReplicationInput`](crate::input::GetBucketReplicationInput)
    pub fn builder() -> crate::input::get_bucket_replication_input::Builder {
        crate::input::get_bucket_replication_input::Builder::default()
    }
}

/// See [`GetBucketRequestPaymentInput`](crate::input::GetBucketRequestPaymentInput)
pub mod get_bucket_request_payment_input {
    /// A builder for [`GetBucketRequestPaymentInput`](crate::input::GetBucketRequestPaymentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket for which to get the payment request configuration</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket for which to get the payment request configuration</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketRequestPaymentInput`](crate::input::GetBucketRequestPaymentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketRequestPaymentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketRequestPaymentInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketRequestPaymentInputOperationOutputAlias =
    crate::operation::GetBucketRequestPayment;
#[doc(hidden)]
pub type GetBucketRequestPaymentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketRequestPaymentInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketRequestPayment`](crate::operation::GetBucketRequestPayment)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketRequestPayment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetBucketRequestPaymentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_60 = &_input.bucket;
                let input_60 = input_60.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_60, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetBucketRequestPaymentInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("requestPayment");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetBucketRequestPaymentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_get_bucket_request_payment(input, builder)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketRequestPayment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketRequestPayment",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetBucketRequestPaymentInput`](crate::input::GetBucketRequestPaymentInput)
    pub fn builder() -> crate::input::get_bucket_request_payment_input::Builder {
        crate::input::get_bucket_request_payment_input::Builder::default()
    }
}

/// See [`GetBucketTaggingInput`](crate::input::GetBucketTaggingInput)
pub mod get_bucket_tagging_input {
    /// A builder for [`GetBucketTaggingInput`](crate::input::GetBucketTaggingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket for which to get the tagging information.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket for which to get the tagging information.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketTaggingInput`](crate::input::GetBucketTaggingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketTaggingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketTaggingInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketTaggingInputOperationOutputAlias = crate::operation::GetBucketTagging;
#[doc(hidden)]
pub type GetBucketTaggingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketTaggingInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketTagging`](crate::operation::GetBucketTagging)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketTagging,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetBucketTaggingInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_61 = &_input.bucket;
                let input_61 = input_61.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_61, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetBucketTaggingInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("tagging");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetBucketTaggingInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_get_bucket_tagging(input, builder)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketTagging::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketTagging",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetBucketTaggingInput`](crate::input::GetBucketTaggingInput)
    pub fn builder() -> crate::input::get_bucket_tagging_input::Builder {
        crate::input::get_bucket_tagging_input::Builder::default()
    }
}

/// See [`GetBucketVersioningInput`](crate::input::GetBucketVersioningInput)
pub mod get_bucket_versioning_input {
    /// A builder for [`GetBucketVersioningInput`](crate::input::GetBucketVersioningInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket for which to get the versioning information.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket for which to get the versioning information.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketVersioningInput`](crate::input::GetBucketVersioningInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketVersioningInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketVersioningInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketVersioningInputOperationOutputAlias = crate::operation::GetBucketVersioning;
#[doc(hidden)]
pub type GetBucketVersioningInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketVersioningInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketVersioning`](crate::operation::GetBucketVersioning)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketVersioning,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetBucketVersioningInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_62 = &_input.bucket;
                let input_62 = input_62.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_62, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetBucketVersioningInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("versioning");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetBucketVersioningInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_get_bucket_versioning(input, builder)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketVersioning::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketVersioning",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetBucketVersioningInput`](crate::input::GetBucketVersioningInput)
    pub fn builder() -> crate::input::get_bucket_versioning_input::Builder {
        crate::input::get_bucket_versioning_input::Builder::default()
    }
}

/// See [`GetBucketWebsiteInput`](crate::input::GetBucketWebsiteInput)
pub mod get_bucket_website_input {
    /// A builder for [`GetBucketWebsiteInput`](crate::input::GetBucketWebsiteInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket name for which to get the website configuration.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name for which to get the website configuration.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketWebsiteInput`](crate::input::GetBucketWebsiteInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketWebsiteInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketWebsiteInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketWebsiteInputOperationOutputAlias = crate::operation::GetBucketWebsite;
#[doc(hidden)]
pub type GetBucketWebsiteInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketWebsiteInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketWebsite`](crate::operation::GetBucketWebsite)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketWebsite,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetBucketWebsiteInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_63 = &_input.bucket;
                let input_63 = input_63.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_63, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetBucketWebsiteInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("website");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetBucketWebsiteInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_get_bucket_website(input, builder)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketWebsite::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketWebsite",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetBucketWebsiteInput`](crate::input::GetBucketWebsiteInput)
    pub fn builder() -> crate::input::get_bucket_website_input::Builder {
        crate::input::get_bucket_website_input::Builder::default()
    }
}

/// See [`GetObjectInput`](crate::input::GetObjectInput)
pub mod get_object_input {
    /// A builder for [`GetObjectInput`](crate::input::GetObjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) if_match: std::option::Option<std::string::String>,
        pub(crate) if_modified_since: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) if_none_match: std::option::Option<std::string::String>,
        pub(crate) if_unmodified_since: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) range: std::option::Option<std::string::String>,
        pub(crate) response_cache_control: std::option::Option<std::string::String>,
        pub(crate) response_content_disposition: std::option::Option<std::string::String>,
        pub(crate) response_content_encoding: std::option::Option<std::string::String>,
        pub(crate) response_content_language: std::option::Option<std::string::String>,
        pub(crate) response_content_type: std::option::Option<std::string::String>,
        pub(crate) response_expires: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) sse_customer_algorithm: std::option::Option<std::string::String>,
        pub(crate) sse_customer_key: std::option::Option<std::string::String>,
        pub(crate) sse_customer_key_md5: std::option::Option<std::string::String>,
        pub(crate) request_payer: std::option::Option<crate::model::RequestPayer>,
        pub(crate) part_number: std::option::Option<i32>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket name containing the object. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using an Object Lambda access point the hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-object-lambda.<i>Region</i>.amazonaws.com.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name containing the object. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using an Object Lambda access point the hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-object-lambda.<i>Region</i>.amazonaws.com.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Return the object only if its entity tag (ETag) is the same as the one specified, otherwise return a 412 (precondition failed).</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.if_match = Some(input.into());
            self
        }
        /// <p>Return the object only if its entity tag (ETag) is the same as the one specified, otherwise return a 412 (precondition failed).</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.if_match = input;
            self
        }
        /// <p>Return the object only if it has been modified since the specified time, otherwise return a 304 (not modified).</p>
        pub fn if_modified_since(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.if_modified_since = Some(input);
            self
        }
        /// <p>Return the object only if it has been modified since the specified time, otherwise return a 304 (not modified).</p>
        pub fn set_if_modified_since(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.if_modified_since = input;
            self
        }
        /// <p>Return the object only if its entity tag (ETag) is different from the one specified, otherwise return a 304 (not modified).</p>
        pub fn if_none_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.if_none_match = Some(input.into());
            self
        }
        /// <p>Return the object only if its entity tag (ETag) is different from the one specified, otherwise return a 304 (not modified).</p>
        pub fn set_if_none_match(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.if_none_match = input;
            self
        }
        /// <p>Return the object only if it has not been modified since the specified time, otherwise return a 412 (precondition failed).</p>
        pub fn if_unmodified_since(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.if_unmodified_since = Some(input);
            self
        }
        /// <p>Return the object only if it has not been modified since the specified time, otherwise return a 412 (precondition failed).</p>
        pub fn set_if_unmodified_since(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.if_unmodified_since = input;
            self
        }
        /// <p>Key of the object to get.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>Key of the object to get.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>Downloads the specified range bytes of an object. For more information about the HTTP Range header, see <a href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35">https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35</a>.</p> <note>
        /// <p>Amazon S3 doesn't support retrieving multiple ranges of data per <code>GET</code> request.</p>
        /// </note>
        pub fn range(mut self, input: impl Into<std::string::String>) -> Self {
            self.range = Some(input.into());
            self
        }
        /// <p>Downloads the specified range bytes of an object. For more information about the HTTP Range header, see <a href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35">https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35</a>.</p> <note>
        /// <p>Amazon S3 doesn't support retrieving multiple ranges of data per <code>GET</code> request.</p>
        /// </note>
        pub fn set_range(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.range = input;
            self
        }
        /// <p>Sets the <code>Cache-Control</code> header of the response.</p>
        pub fn response_cache_control(mut self, input: impl Into<std::string::String>) -> Self {
            self.response_cache_control = Some(input.into());
            self
        }
        /// <p>Sets the <code>Cache-Control</code> header of the response.</p>
        pub fn set_response_cache_control(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.response_cache_control = input;
            self
        }
        /// <p>Sets the <code>Content-Disposition</code> header of the response</p>
        pub fn response_content_disposition(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.response_content_disposition = Some(input.into());
            self
        }
        /// <p>Sets the <code>Content-Disposition</code> header of the response</p>
        pub fn set_response_content_disposition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.response_content_disposition = input;
            self
        }
        /// <p>Sets the <code>Content-Encoding</code> header of the response.</p>
        pub fn response_content_encoding(mut self, input: impl Into<std::string::String>) -> Self {
            self.response_content_encoding = Some(input.into());
            self
        }
        /// <p>Sets the <code>Content-Encoding</code> header of the response.</p>
        pub fn set_response_content_encoding(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.response_content_encoding = input;
            self
        }
        /// <p>Sets the <code>Content-Language</code> header of the response.</p>
        pub fn response_content_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.response_content_language = Some(input.into());
            self
        }
        /// <p>Sets the <code>Content-Language</code> header of the response.</p>
        pub fn set_response_content_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.response_content_language = input;
            self
        }
        /// <p>Sets the <code>Content-Type</code> header of the response.</p>
        pub fn response_content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.response_content_type = Some(input.into());
            self
        }
        /// <p>Sets the <code>Content-Type</code> header of the response.</p>
        pub fn set_response_content_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.response_content_type = input;
            self
        }
        /// <p>Sets the <code>Expires</code> header of the response.</p>
        pub fn response_expires(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.response_expires = Some(input);
            self
        }
        /// <p>Sets the <code>Expires</code> header of the response.</p>
        pub fn set_response_expires(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.response_expires = input;
            self
        }
        /// <p>VersionId used to reference a specific version of the object.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>VersionId used to reference a specific version of the object.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>Specifies the algorithm to use to when decrypting the object (for example, AES256).</p>
        pub fn sse_customer_algorithm(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_customer_algorithm = Some(input.into());
            self
        }
        /// <p>Specifies the algorithm to use to when decrypting the object (for example, AES256).</p>
        pub fn set_sse_customer_algorithm(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_customer_algorithm = input;
            self
        }
        /// <p>Specifies the customer-provided encryption key for Amazon S3 used to encrypt the data. This value is used to decrypt the object when recovering it and must match the one used when storing the data. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p>
        pub fn sse_customer_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_customer_key = Some(input.into());
            self
        }
        /// <p>Specifies the customer-provided encryption key for Amazon S3 used to encrypt the data. This value is used to decrypt the object when recovering it and must match the one used when storing the data. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p>
        pub fn set_sse_customer_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_customer_key = input;
            self
        }
        /// <p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>
        pub fn sse_customer_key_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_customer_key_md5 = Some(input.into());
            self
        }
        /// <p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>
        pub fn set_sse_customer_key_md5(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_customer_key_md5 = input;
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.request_payer = Some(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.request_payer = input;
            self
        }
        /// <p>Part number of the object being read. This is a positive integer between 1 and 10,000. Effectively performs a 'ranged' GET request for the part specified. Useful for downloading just a part of an object.</p>
        pub fn part_number(mut self, input: i32) -> Self {
            self.part_number = Some(input);
            self
        }
        /// <p>Part number of the object being read. This is a positive integer between 1 and 10,000. Effectively performs a 'ranged' GET request for the part specified. Useful for downloading just a part of an object.</p>
        pub fn set_part_number(mut self, input: std::option::Option<i32>) -> Self {
            self.part_number = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetObjectInput`](crate::input::GetObjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetObjectInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetObjectInput {
                bucket: self.bucket,
                if_match: self.if_match,
                if_modified_since: self.if_modified_since,
                if_none_match: self.if_none_match,
                if_unmodified_since: self.if_unmodified_since,
                key: self.key,
                range: self.range,
                response_cache_control: self.response_cache_control,
                response_content_disposition: self.response_content_disposition,
                response_content_encoding: self.response_content_encoding,
                response_content_language: self.response_content_language,
                response_content_type: self.response_content_type,
                response_expires: self.response_expires,
                version_id: self.version_id,
                sse_customer_algorithm: self.sse_customer_algorithm,
                sse_customer_key: self.sse_customer_key,
                sse_customer_key_md5: self.sse_customer_key_md5,
                request_payer: self.request_payer,
                part_number: self.part_number.unwrap_or_default(),
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetObjectInputOperationOutputAlias = crate::operation::GetObject;
#[doc(hidden)]
pub type GetObjectInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetObjectInput {
    /// Consumes the builder and constructs an Operation<[`GetObject`](crate::operation::GetObject)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    async fn _make_presigned_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetObject,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetObjectInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_64 = &_input.bucket;
                let input_64 = input_64.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_64, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                let input_65 = &_input.key;
                let input_65 = input_65.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    },
                )?;
                let key = aws_smithy_http::label::fmt_string(input_65, true);
                if key.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}/{Key}", Bucket = bucket, Key = key)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetObjectInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_kv("x-id", "GetObject");
                if let Some(inner_66) = &_input.response_cache_control {
                    query.push_kv(
                        "response-cache-control",
                        &aws_smithy_http::query::fmt_string(&inner_66),
                    );
                }
                if let Some(inner_67) = &_input.response_content_disposition {
                    query.push_kv(
                        "response-content-disposition",
                        &aws_smithy_http::query::fmt_string(&inner_67),
                    );
                }
                if let Some(inner_68) = &_input.response_content_encoding {
                    query.push_kv(
                        "response-content-encoding",
                        &aws_smithy_http::query::fmt_string(&inner_68),
                    );
                }
                if let Some(inner_69) = &_input.response_content_language {
                    query.push_kv(
                        "response-content-language",
                        &aws_smithy_http::query::fmt_string(&inner_69),
                    );
                }
                if let Some(inner_70) = &_input.response_content_type {
                    query.push_kv(
                        "response-content-type",
                        &aws_smithy_http::query::fmt_string(&inner_70),
                    );
                }
                if let Some(inner_71) = &_input.response_expires {
                    query.push_kv(
                        "response-expires",
                        &aws_smithy_http::query::fmt_timestamp(
                            inner_71,
                            aws_smithy_types::date_time::Format::HttpDate,
                        )?,
                    );
                }
                if let Some(inner_72) = &_input.version_id {
                    query.push_kv("versionId", &aws_smithy_http::query::fmt_string(&inner_72));
                }
                if _input.part_number != 0 {
                    query.push_kv(
                        "partNumber",
                        aws_smithy_types::primitive::Encoder::from(_input.part_number).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetObjectInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_get_object(input, builder)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetObject::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new("GetObject", "s3"));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    ///
    /// Creates a presigned request for this operation.
    ///
    /// The credentials provider from the `config` will be used to generate the request's signature.
    /// The `presigning_config` provides additional presigning-specific config values, such as the
    /// amount of time the request should be valid for after creation.
    ///
    /// Presigned requests can be given to other users or applications to access a resource or perform
    /// an operation without having access to the AWS security credentials.
    ///
    pub async fn presigned(
        self,
        config: &crate::config::Config,
        presigning_config: crate::presigning::config::PresigningConfig,
    ) -> Result<
        crate::presigning::request::PresignedRequest,
        aws_smithy_http::result::SdkError<crate::error::GetObjectError>,
    > {
        let (mut request, _) = self
            ._make_presigned_operation(config)
            .await
            .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
            .into_request_response();
        {
            // Change signature type to query params and wire up presigning config
            let mut props = request.properties_mut();
            props.insert(presigning_config.start_time());
            props.insert(aws_sigv4::http_request::SignableBody::UnsignedPayload);
            let mut config = props
                .get_mut::<aws_sig_auth::signer::OperationSigningConfig>()
                .expect("signing config added by make_operation()");
            config.signature_type = aws_sig_auth::signer::HttpSignatureType::HttpRequestQueryParams;
            config.expires_in = Some(presigning_config.expires());
        }
        let middleware = crate::middleware::DefaultMiddleware::default();
        let mut svc = tower::builder::ServiceBuilder::new()
            .layer(&middleware)
            .service(crate::presigning::service::PresignedRequestService::new());

        use tower::{Service, ServiceExt};
        Ok(svc.ready().await?.call(request).await?)
    }
    /// Consumes the builder and constructs an Operation<[`GetObject`](crate::operation::GetObject)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetObject,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetObjectInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_73 = &_input.bucket;
                let input_73 = input_73.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_73, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                let input_74 = &_input.key;
                let input_74 = input_74.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    },
                )?;
                let key = aws_smithy_http::label::fmt_string(input_74, true);
                if key.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}/{Key}", Bucket = bucket, Key = key)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetObjectInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_kv("x-id", "GetObject");
                if let Some(inner_75) = &_input.response_cache_control {
                    query.push_kv(
                        "response-cache-control",
                        &aws_smithy_http::query::fmt_string(&inner_75),
                    );
                }
                if let Some(inner_76) = &_input.response_content_disposition {
                    query.push_kv(
                        "response-content-disposition",
                        &aws_smithy_http::query::fmt_string(&inner_76),
                    );
                }
                if let Some(inner_77) = &_input.response_content_encoding {
                    query.push_kv(
                        "response-content-encoding",
                        &aws_smithy_http::query::fmt_string(&inner_77),
                    );
                }
                if let Some(inner_78) = &_input.response_content_language {
                    query.push_kv(
                        "response-content-language",
                        &aws_smithy_http::query::fmt_string(&inner_78),
                    );
                }
                if let Some(inner_79) = &_input.response_content_type {
                    query.push_kv(
                        "response-content-type",
                        &aws_smithy_http::query::fmt_string(&inner_79),
                    );
                }
                if let Some(inner_80) = &_input.response_expires {
                    query.push_kv(
                        "response-expires",
                        &aws_smithy_http::query::fmt_timestamp(
                            inner_80,
                            aws_smithy_types::date_time::Format::HttpDate,
                        )?,
                    );
                }
                if let Some(inner_81) = &_input.version_id {
                    query.push_kv("versionId", &aws_smithy_http::query::fmt_string(&inner_81));
                }
                if _input.part_number != 0 {
                    query.push_kv(
                        "partNumber",
                        aws_smithy_types::primitive::Encoder::from(_input.part_number).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetObjectInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_get_object(input, builder)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetObject::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new("GetObject", "s3"));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetObjectInput`](crate::input::GetObjectInput)
    pub fn builder() -> crate::input::get_object_input::Builder {
        crate::input::get_object_input::Builder::default()
    }
}

/// See [`GetObjectAclInput`](crate::input::GetObjectAclInput)
pub mod get_object_acl_input {
    /// A builder for [`GetObjectAclInput`](crate::input::GetObjectAclInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) request_payer: std::option::Option<crate::model::RequestPayer>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket name that contains the object for which to get the ACL information. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name that contains the object for which to get the ACL information. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The key of the object for which to get the ACL information.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key of the object for which to get the ACL information.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>VersionId used to reference a specific version of the object.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>VersionId used to reference a specific version of the object.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.request_payer = Some(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.request_payer = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetObjectAclInput`](crate::input::GetObjectAclInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetObjectAclInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetObjectAclInput {
                bucket: self.bucket,
                key: self.key,
                version_id: self.version_id,
                request_payer: self.request_payer,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetObjectAclInputOperationOutputAlias = crate::operation::GetObjectAcl;
#[doc(hidden)]
pub type GetObjectAclInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetObjectAclInput {
    /// Consumes the builder and constructs an Operation<[`GetObjectAcl`](crate::operation::GetObjectAcl)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetObjectAcl,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetObjectAclInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_82 = &_input.bucket;
                let input_82 = input_82.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_82, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                let input_83 = &_input.key;
                let input_83 = input_83.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    },
                )?;
                let key = aws_smithy_http::label::fmt_string(input_83, true);
                if key.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}/{Key}", Bucket = bucket, Key = key)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetObjectAclInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("acl");
                if let Some(inner_84) = &_input.version_id {
                    query.push_kv("versionId", &aws_smithy_http::query::fmt_string(&inner_84));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetObjectAclInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_get_object_acl(input, builder)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetObjectAcl::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetObjectAcl",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetObjectAclInput`](crate::input::GetObjectAclInput)
    pub fn builder() -> crate::input::get_object_acl_input::Builder {
        crate::input::get_object_acl_input::Builder::default()
    }
}

/// See [`GetObjectLegalHoldInput`](crate::input::GetObjectLegalHoldInput)
pub mod get_object_legal_hold_input {
    /// A builder for [`GetObjectLegalHoldInput`](crate::input::GetObjectLegalHoldInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) request_payer: std::option::Option<crate::model::RequestPayer>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket name containing the object whose Legal Hold status you want to retrieve. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name containing the object whose Legal Hold status you want to retrieve. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The key name for the object whose Legal Hold status you want to retrieve.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key name for the object whose Legal Hold status you want to retrieve.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The version ID of the object whose Legal Hold status you want to retrieve.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The version ID of the object whose Legal Hold status you want to retrieve.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.request_payer = Some(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.request_payer = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetObjectLegalHoldInput`](crate::input::GetObjectLegalHoldInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetObjectLegalHoldInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetObjectLegalHoldInput {
                bucket: self.bucket,
                key: self.key,
                version_id: self.version_id,
                request_payer: self.request_payer,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetObjectLegalHoldInputOperationOutputAlias = crate::operation::GetObjectLegalHold;
#[doc(hidden)]
pub type GetObjectLegalHoldInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetObjectLegalHoldInput {
    /// Consumes the builder and constructs an Operation<[`GetObjectLegalHold`](crate::operation::GetObjectLegalHold)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetObjectLegalHold,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetObjectLegalHoldInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_85 = &_input.bucket;
                let input_85 = input_85.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_85, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                let input_86 = &_input.key;
                let input_86 = input_86.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    },
                )?;
                let key = aws_smithy_http::label::fmt_string(input_86, true);
                if key.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}/{Key}", Bucket = bucket, Key = key)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetObjectLegalHoldInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("legal-hold");
                if let Some(inner_87) = &_input.version_id {
                    query.push_kv("versionId", &aws_smithy_http::query::fmt_string(&inner_87));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetObjectLegalHoldInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_get_object_legal_hold(input, builder)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetObjectLegalHold::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetObjectLegalHold",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetObjectLegalHoldInput`](crate::input::GetObjectLegalHoldInput)
    pub fn builder() -> crate::input::get_object_legal_hold_input::Builder {
        crate::input::get_object_legal_hold_input::Builder::default()
    }
}

/// See [`GetObjectLockConfigurationInput`](crate::input::GetObjectLockConfigurationInput)
pub mod get_object_lock_configuration_input {
    /// A builder for [`GetObjectLockConfigurationInput`](crate::input::GetObjectLockConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket whose Object Lock configuration you want to retrieve.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket whose Object Lock configuration you want to retrieve.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetObjectLockConfigurationInput`](crate::input::GetObjectLockConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetObjectLockConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetObjectLockConfigurationInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetObjectLockConfigurationInputOperationOutputAlias =
    crate::operation::GetObjectLockConfiguration;
#[doc(hidden)]
pub type GetObjectLockConfigurationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetObjectLockConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetObjectLockConfiguration`](crate::operation::GetObjectLockConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetObjectLockConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetObjectLockConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_88 = &_input.bucket;
                let input_88 = input_88.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_88, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetObjectLockConfigurationInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("object-lock");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetObjectLockConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_get_object_lock_configuration(input, builder)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetObjectLockConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetObjectLockConfiguration",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetObjectLockConfigurationInput`](crate::input::GetObjectLockConfigurationInput)
    pub fn builder() -> crate::input::get_object_lock_configuration_input::Builder {
        crate::input::get_object_lock_configuration_input::Builder::default()
    }
}

/// See [`GetObjectRetentionInput`](crate::input::GetObjectRetentionInput)
pub mod get_object_retention_input {
    /// A builder for [`GetObjectRetentionInput`](crate::input::GetObjectRetentionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) request_payer: std::option::Option<crate::model::RequestPayer>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket name containing the object whose retention settings you want to retrieve. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name containing the object whose retention settings you want to retrieve. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The key name for the object whose retention settings you want to retrieve.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key name for the object whose retention settings you want to retrieve.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The version ID for the object whose retention settings you want to retrieve.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The version ID for the object whose retention settings you want to retrieve.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.request_payer = Some(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.request_payer = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetObjectRetentionInput`](crate::input::GetObjectRetentionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetObjectRetentionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetObjectRetentionInput {
                bucket: self.bucket,
                key: self.key,
                version_id: self.version_id,
                request_payer: self.request_payer,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetObjectRetentionInputOperationOutputAlias = crate::operation::GetObjectRetention;
#[doc(hidden)]
pub type GetObjectRetentionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetObjectRetentionInput {
    /// Consumes the builder and constructs an Operation<[`GetObjectRetention`](crate::operation::GetObjectRetention)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetObjectRetention,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetObjectRetentionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_89 = &_input.bucket;
                let input_89 = input_89.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_89, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                let input_90 = &_input.key;
                let input_90 = input_90.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    },
                )?;
                let key = aws_smithy_http::label::fmt_string(input_90, true);
                if key.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}/{Key}", Bucket = bucket, Key = key)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetObjectRetentionInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("retention");
                if let Some(inner_91) = &_input.version_id {
                    query.push_kv("versionId", &aws_smithy_http::query::fmt_string(&inner_91));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetObjectRetentionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_get_object_retention(input, builder)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetObjectRetention::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetObjectRetention",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetObjectRetentionInput`](crate::input::GetObjectRetentionInput)
    pub fn builder() -> crate::input::get_object_retention_input::Builder {
        crate::input::get_object_retention_input::Builder::default()
    }
}

/// See [`GetObjectTaggingInput`](crate::input::GetObjectTaggingInput)
pub mod get_object_tagging_input {
    /// A builder for [`GetObjectTaggingInput`](crate::input::GetObjectTaggingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
        pub(crate) request_payer: std::option::Option<crate::model::RequestPayer>,
    }
    impl Builder {
        /// <p>The bucket name containing the object for which to get the tagging information. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name containing the object for which to get the tagging information. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Object key for which to get the tagging information.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>Object key for which to get the tagging information.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The versionId of the object for which to get the tagging information.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The versionId of the object for which to get the tagging information.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.request_payer = Some(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.request_payer = input;
            self
        }
        /// Consumes the builder and constructs a [`GetObjectTaggingInput`](crate::input::GetObjectTaggingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetObjectTaggingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetObjectTaggingInput {
                bucket: self.bucket,
                key: self.key,
                version_id: self.version_id,
                expected_bucket_owner: self.expected_bucket_owner,
                request_payer: self.request_payer,
            })
        }
    }
}
#[doc(hidden)]
pub type GetObjectTaggingInputOperationOutputAlias = crate::operation::GetObjectTagging;
#[doc(hidden)]
pub type GetObjectTaggingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetObjectTaggingInput {
    /// Consumes the builder and constructs an Operation<[`GetObjectTagging`](crate::operation::GetObjectTagging)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetObjectTagging,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetObjectTaggingInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_92 = &_input.bucket;
                let input_92 = input_92.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_92, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                let input_93 = &_input.key;
                let input_93 = input_93.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    },
                )?;
                let key = aws_smithy_http::label::fmt_string(input_93, true);
                if key.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}/{Key}", Bucket = bucket, Key = key)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetObjectTaggingInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("tagging");
                if let Some(inner_94) = &_input.version_id {
                    query.push_kv("versionId", &aws_smithy_http::query::fmt_string(&inner_94));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetObjectTaggingInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_get_object_tagging(input, builder)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetObjectTagging::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetObjectTagging",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetObjectTaggingInput`](crate::input::GetObjectTaggingInput)
    pub fn builder() -> crate::input::get_object_tagging_input::Builder {
        crate::input::get_object_tagging_input::Builder::default()
    }
}

/// See [`GetObjectTorrentInput`](crate::input::GetObjectTorrentInput)
pub mod get_object_torrent_input {
    /// A builder for [`GetObjectTorrentInput`](crate::input::GetObjectTorrentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) request_payer: std::option::Option<crate::model::RequestPayer>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket containing the object for which to get the torrent files.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket containing the object for which to get the torrent files.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The object key for which to get the information.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The object key for which to get the information.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.request_payer = Some(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.request_payer = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetObjectTorrentInput`](crate::input::GetObjectTorrentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetObjectTorrentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetObjectTorrentInput {
                bucket: self.bucket,
                key: self.key,
                request_payer: self.request_payer,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetObjectTorrentInputOperationOutputAlias = crate::operation::GetObjectTorrent;
#[doc(hidden)]
pub type GetObjectTorrentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetObjectTorrentInput {
    /// Consumes the builder and constructs an Operation<[`GetObjectTorrent`](crate::operation::GetObjectTorrent)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetObjectTorrent,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetObjectTorrentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_95 = &_input.bucket;
                let input_95 = input_95.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_95, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                let input_96 = &_input.key;
                let input_96 = input_96.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    },
                )?;
                let key = aws_smithy_http::label::fmt_string(input_96, true);
                if key.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}/{Key}", Bucket = bucket, Key = key)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetObjectTorrentInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("torrent");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetObjectTorrentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_get_object_torrent(input, builder)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetObjectTorrent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetObjectTorrent",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetObjectTorrentInput`](crate::input::GetObjectTorrentInput)
    pub fn builder() -> crate::input::get_object_torrent_input::Builder {
        crate::input::get_object_torrent_input::Builder::default()
    }
}

/// See [`GetPublicAccessBlockInput`](crate::input::GetPublicAccessBlockInput)
pub mod get_public_access_block_input {
    /// A builder for [`GetPublicAccessBlockInput`](crate::input::GetPublicAccessBlockInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Amazon S3 bucket whose <code>PublicAccessBlock</code> configuration you want to retrieve. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket whose <code>PublicAccessBlock</code> configuration you want to retrieve. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPublicAccessBlockInput`](crate::input::GetPublicAccessBlockInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetPublicAccessBlockInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetPublicAccessBlockInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetPublicAccessBlockInputOperationOutputAlias = crate::operation::GetPublicAccessBlock;
#[doc(hidden)]
pub type GetPublicAccessBlockInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetPublicAccessBlockInput {
    /// Consumes the builder and constructs an Operation<[`GetPublicAccessBlock`](crate::operation::GetPublicAccessBlock)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetPublicAccessBlock,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetPublicAccessBlockInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_97 = &_input.bucket;
                let input_97 = input_97.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_97, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetPublicAccessBlockInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("publicAccessBlock");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetPublicAccessBlockInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_get_public_access_block(input, builder)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetPublicAccessBlock::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetPublicAccessBlock",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetPublicAccessBlockInput`](crate::input::GetPublicAccessBlockInput)
    pub fn builder() -> crate::input::get_public_access_block_input::Builder {
        crate::input::get_public_access_block_input::Builder::default()
    }
}

/// See [`HeadBucketInput`](crate::input::HeadBucketInput)
pub mod head_bucket_input {
    /// A builder for [`HeadBucketInput`](crate::input::HeadBucketInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket name.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`HeadBucketInput`](crate::input::HeadBucketInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::HeadBucketInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::HeadBucketInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type HeadBucketInputOperationOutputAlias = crate::operation::HeadBucket;
#[doc(hidden)]
pub type HeadBucketInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl HeadBucketInput {
    /// Consumes the builder and constructs an Operation<[`HeadBucket`](crate::operation::HeadBucket)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::HeadBucket,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::HeadBucketInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_98 = &_input.bucket;
                let input_98 = input_98.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_98, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::HeadBucketInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_head_bucket(input, builder)?;
                Ok(builder.method("HEAD").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::HeadBucket::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "HeadBucket",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`HeadBucketInput`](crate::input::HeadBucketInput)
    pub fn builder() -> crate::input::head_bucket_input::Builder {
        crate::input::head_bucket_input::Builder::default()
    }
}

/// See [`HeadObjectInput`](crate::input::HeadObjectInput)
pub mod head_object_input {
    /// A builder for [`HeadObjectInput`](crate::input::HeadObjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) if_match: std::option::Option<std::string::String>,
        pub(crate) if_modified_since: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) if_none_match: std::option::Option<std::string::String>,
        pub(crate) if_unmodified_since: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) range: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) sse_customer_algorithm: std::option::Option<std::string::String>,
        pub(crate) sse_customer_key: std::option::Option<std::string::String>,
        pub(crate) sse_customer_key_md5: std::option::Option<std::string::String>,
        pub(crate) request_payer: std::option::Option<crate::model::RequestPayer>,
        pub(crate) part_number: std::option::Option<i32>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket containing the object.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket containing the object.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Return the object only if its entity tag (ETag) is the same as the one specified, otherwise return a 412 (precondition failed).</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.if_match = Some(input.into());
            self
        }
        /// <p>Return the object only if its entity tag (ETag) is the same as the one specified, otherwise return a 412 (precondition failed).</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.if_match = input;
            self
        }
        /// <p>Return the object only if it has been modified since the specified time, otherwise return a 304 (not modified).</p>
        pub fn if_modified_since(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.if_modified_since = Some(input);
            self
        }
        /// <p>Return the object only if it has been modified since the specified time, otherwise return a 304 (not modified).</p>
        pub fn set_if_modified_since(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.if_modified_since = input;
            self
        }
        /// <p>Return the object only if its entity tag (ETag) is different from the one specified, otherwise return a 304 (not modified).</p>
        pub fn if_none_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.if_none_match = Some(input.into());
            self
        }
        /// <p>Return the object only if its entity tag (ETag) is different from the one specified, otherwise return a 304 (not modified).</p>
        pub fn set_if_none_match(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.if_none_match = input;
            self
        }
        /// <p>Return the object only if it has not been modified since the specified time, otherwise return a 412 (precondition failed).</p>
        pub fn if_unmodified_since(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.if_unmodified_since = Some(input);
            self
        }
        /// <p>Return the object only if it has not been modified since the specified time, otherwise return a 412 (precondition failed).</p>
        pub fn set_if_unmodified_since(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.if_unmodified_since = input;
            self
        }
        /// <p>The object key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The object key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>Because <code>HeadObject</code> returns only the metadata for an object, this parameter has no effect.</p>
        pub fn range(mut self, input: impl Into<std::string::String>) -> Self {
            self.range = Some(input.into());
            self
        }
        /// <p>Because <code>HeadObject</code> returns only the metadata for an object, this parameter has no effect.</p>
        pub fn set_range(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.range = input;
            self
        }
        /// <p>VersionId used to reference a specific version of the object.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>VersionId used to reference a specific version of the object.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>Specifies the algorithm to use to when encrypting the object (for example, AES256).</p>
        pub fn sse_customer_algorithm(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_customer_algorithm = Some(input.into());
            self
        }
        /// <p>Specifies the algorithm to use to when encrypting the object (for example, AES256).</p>
        pub fn set_sse_customer_algorithm(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_customer_algorithm = input;
            self
        }
        /// <p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p>
        pub fn sse_customer_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_customer_key = Some(input.into());
            self
        }
        /// <p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p>
        pub fn set_sse_customer_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_customer_key = input;
            self
        }
        /// <p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>
        pub fn sse_customer_key_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_customer_key_md5 = Some(input.into());
            self
        }
        /// <p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>
        pub fn set_sse_customer_key_md5(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_customer_key_md5 = input;
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.request_payer = Some(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.request_payer = input;
            self
        }
        /// <p>Part number of the object being read. This is a positive integer between 1 and 10,000. Effectively performs a 'ranged' HEAD request for the part specified. Useful querying about the size of the part and the number of parts in this object.</p>
        pub fn part_number(mut self, input: i32) -> Self {
            self.part_number = Some(input);
            self
        }
        /// <p>Part number of the object being read. This is a positive integer between 1 and 10,000. Effectively performs a 'ranged' HEAD request for the part specified. Useful querying about the size of the part and the number of parts in this object.</p>
        pub fn set_part_number(mut self, input: std::option::Option<i32>) -> Self {
            self.part_number = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`HeadObjectInput`](crate::input::HeadObjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::HeadObjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::HeadObjectInput {
                bucket: self.bucket,
                if_match: self.if_match,
                if_modified_since: self.if_modified_since,
                if_none_match: self.if_none_match,
                if_unmodified_since: self.if_unmodified_since,
                key: self.key,
                range: self.range,
                version_id: self.version_id,
                sse_customer_algorithm: self.sse_customer_algorithm,
                sse_customer_key: self.sse_customer_key,
                sse_customer_key_md5: self.sse_customer_key_md5,
                request_payer: self.request_payer,
                part_number: self.part_number.unwrap_or_default(),
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type HeadObjectInputOperationOutputAlias = crate::operation::HeadObject;
#[doc(hidden)]
pub type HeadObjectInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl HeadObjectInput {
    /// Consumes the builder and constructs an Operation<[`HeadObject`](crate::operation::HeadObject)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::HeadObject,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::HeadObjectInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_99 = &_input.bucket;
                let input_99 = input_99.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_99, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                let input_100 = &_input.key;
                let input_100 = input_100.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    },
                )?;
                let key = aws_smithy_http::label::fmt_string(input_100, true);
                if key.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}/{Key}", Bucket = bucket, Key = key)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::HeadObjectInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_101) = &_input.version_id {
                    query.push_kv("versionId", &aws_smithy_http::query::fmt_string(&inner_101));
                }
                if _input.part_number != 0 {
                    query.push_kv(
                        "partNumber",
                        aws_smithy_types::primitive::Encoder::from(_input.part_number).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::HeadObjectInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_head_object(input, builder)?;
                Ok(builder.method("HEAD").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::HeadObject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "HeadObject",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`HeadObjectInput`](crate::input::HeadObjectInput)
    pub fn builder() -> crate::input::head_object_input::Builder {
        crate::input::head_object_input::Builder::default()
    }
}

/// See [`ListBucketAnalyticsConfigurationsInput`](crate::input::ListBucketAnalyticsConfigurationsInput)
pub mod list_bucket_analytics_configurations_input {
    /// A builder for [`ListBucketAnalyticsConfigurationsInput`](crate::input::ListBucketAnalyticsConfigurationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) continuation_token: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket from which analytics configurations are retrieved.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket from which analytics configurations are retrieved.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The ContinuationToken that represents a placeholder from where this request should begin.</p>
        pub fn continuation_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.continuation_token = Some(input.into());
            self
        }
        /// <p>The ContinuationToken that represents a placeholder from where this request should begin.</p>
        pub fn set_continuation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.continuation_token = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBucketAnalyticsConfigurationsInput`](crate::input::ListBucketAnalyticsConfigurationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListBucketAnalyticsConfigurationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListBucketAnalyticsConfigurationsInput {
                bucket: self.bucket,
                continuation_token: self.continuation_token,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type ListBucketAnalyticsConfigurationsInputOperationOutputAlias =
    crate::operation::ListBucketAnalyticsConfigurations;
#[doc(hidden)]
pub type ListBucketAnalyticsConfigurationsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListBucketAnalyticsConfigurationsInput {
    /// Consumes the builder and constructs an Operation<[`ListBucketAnalyticsConfigurations`](crate::operation::ListBucketAnalyticsConfigurations)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBucketAnalyticsConfigurations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListBucketAnalyticsConfigurationsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_102 = &_input.bucket;
                let input_102 = input_102.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_102, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListBucketAnalyticsConfigurationsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("analytics");
                query.push_kv("x-id", "ListBucketAnalyticsConfigurations");
                if let Some(inner_103) = &_input.continuation_token {
                    query.push_kv(
                        "continuation-token",
                        &aws_smithy_http::query::fmt_string(&inner_103),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListBucketAnalyticsConfigurationsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_list_bucket_analytics_configurations(
                    input, builder,
                )?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListBucketAnalyticsConfigurations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListBucketAnalyticsConfigurations",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListBucketAnalyticsConfigurationsInput`](crate::input::ListBucketAnalyticsConfigurationsInput)
    pub fn builder() -> crate::input::list_bucket_analytics_configurations_input::Builder {
        crate::input::list_bucket_analytics_configurations_input::Builder::default()
    }
}

/// See [`ListBucketIntelligentTieringConfigurationsInput`](crate::input::ListBucketIntelligentTieringConfigurationsInput)
pub mod list_bucket_intelligent_tiering_configurations_input {
    /// A builder for [`ListBucketIntelligentTieringConfigurationsInput`](crate::input::ListBucketIntelligentTieringConfigurationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) continuation_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Amazon S3 bucket whose configuration you want to modify or retrieve.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket whose configuration you want to modify or retrieve.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The ContinuationToken that represents a placeholder from where this request should begin.</p>
        pub fn continuation_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.continuation_token = Some(input.into());
            self
        }
        /// <p>The ContinuationToken that represents a placeholder from where this request should begin.</p>
        pub fn set_continuation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.continuation_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBucketIntelligentTieringConfigurationsInput`](crate::input::ListBucketIntelligentTieringConfigurationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListBucketIntelligentTieringConfigurationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::ListBucketIntelligentTieringConfigurationsInput {
                    bucket: self.bucket,
                    continuation_token: self.continuation_token,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type ListBucketIntelligentTieringConfigurationsInputOperationOutputAlias =
    crate::operation::ListBucketIntelligentTieringConfigurations;
#[doc(hidden)]
pub type ListBucketIntelligentTieringConfigurationsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListBucketIntelligentTieringConfigurationsInput {
    /// Consumes the builder and constructs an Operation<[`ListBucketIntelligentTieringConfigurations`](crate::operation::ListBucketIntelligentTieringConfigurations)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBucketIntelligentTieringConfigurations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListBucketIntelligentTieringConfigurationsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_104 = &_input.bucket;
                let input_104 = input_104.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_104, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListBucketIntelligentTieringConfigurationsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("intelligent-tiering");
                query.push_kv("x-id", "ListBucketIntelligentTieringConfigurations");
                if let Some(inner_105) = &_input.continuation_token {
                    query.push_kv(
                        "continuation-token",
                        &aws_smithy_http::query::fmt_string(&inner_105),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListBucketIntelligentTieringConfigurationsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListBucketIntelligentTieringConfigurations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListBucketIntelligentTieringConfigurations",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListBucketIntelligentTieringConfigurationsInput`](crate::input::ListBucketIntelligentTieringConfigurationsInput)
    pub fn builder() -> crate::input::list_bucket_intelligent_tiering_configurations_input::Builder
    {
        crate::input::list_bucket_intelligent_tiering_configurations_input::Builder::default()
    }
}

/// See [`ListBucketInventoryConfigurationsInput`](crate::input::ListBucketInventoryConfigurationsInput)
pub mod list_bucket_inventory_configurations_input {
    /// A builder for [`ListBucketInventoryConfigurationsInput`](crate::input::ListBucketInventoryConfigurationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) continuation_token: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket containing the inventory configurations to retrieve.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket containing the inventory configurations to retrieve.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The marker used to continue an inventory configuration listing that has been truncated. Use the NextContinuationToken from a previously truncated list response to continue the listing. The continuation token is an opaque value that Amazon S3 understands.</p>
        pub fn continuation_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.continuation_token = Some(input.into());
            self
        }
        /// <p>The marker used to continue an inventory configuration listing that has been truncated. Use the NextContinuationToken from a previously truncated list response to continue the listing. The continuation token is an opaque value that Amazon S3 understands.</p>
        pub fn set_continuation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.continuation_token = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBucketInventoryConfigurationsInput`](crate::input::ListBucketInventoryConfigurationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListBucketInventoryConfigurationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListBucketInventoryConfigurationsInput {
                bucket: self.bucket,
                continuation_token: self.continuation_token,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type ListBucketInventoryConfigurationsInputOperationOutputAlias =
    crate::operation::ListBucketInventoryConfigurations;
#[doc(hidden)]
pub type ListBucketInventoryConfigurationsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListBucketInventoryConfigurationsInput {
    /// Consumes the builder and constructs an Operation<[`ListBucketInventoryConfigurations`](crate::operation::ListBucketInventoryConfigurations)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBucketInventoryConfigurations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListBucketInventoryConfigurationsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_106 = &_input.bucket;
                let input_106 = input_106.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_106, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListBucketInventoryConfigurationsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("inventory");
                query.push_kv("x-id", "ListBucketInventoryConfigurations");
                if let Some(inner_107) = &_input.continuation_token {
                    query.push_kv(
                        "continuation-token",
                        &aws_smithy_http::query::fmt_string(&inner_107),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListBucketInventoryConfigurationsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_list_bucket_inventory_configurations(
                    input, builder,
                )?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListBucketInventoryConfigurations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListBucketInventoryConfigurations",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListBucketInventoryConfigurationsInput`](crate::input::ListBucketInventoryConfigurationsInput)
    pub fn builder() -> crate::input::list_bucket_inventory_configurations_input::Builder {
        crate::input::list_bucket_inventory_configurations_input::Builder::default()
    }
}

/// See [`ListBucketMetricsConfigurationsInput`](crate::input::ListBucketMetricsConfigurationsInput)
pub mod list_bucket_metrics_configurations_input {
    /// A builder for [`ListBucketMetricsConfigurationsInput`](crate::input::ListBucketMetricsConfigurationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) continuation_token: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket containing the metrics configurations to retrieve.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket containing the metrics configurations to retrieve.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The marker that is used to continue a metrics configuration listing that has been truncated. Use the NextContinuationToken from a previously truncated list response to continue the listing. The continuation token is an opaque value that Amazon S3 understands.</p>
        pub fn continuation_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.continuation_token = Some(input.into());
            self
        }
        /// <p>The marker that is used to continue a metrics configuration listing that has been truncated. Use the NextContinuationToken from a previously truncated list response to continue the listing. The continuation token is an opaque value that Amazon S3 understands.</p>
        pub fn set_continuation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.continuation_token = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBucketMetricsConfigurationsInput`](crate::input::ListBucketMetricsConfigurationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListBucketMetricsConfigurationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListBucketMetricsConfigurationsInput {
                bucket: self.bucket,
                continuation_token: self.continuation_token,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type ListBucketMetricsConfigurationsInputOperationOutputAlias =
    crate::operation::ListBucketMetricsConfigurations;
#[doc(hidden)]
pub type ListBucketMetricsConfigurationsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListBucketMetricsConfigurationsInput {
    /// Consumes the builder and constructs an Operation<[`ListBucketMetricsConfigurations`](crate::operation::ListBucketMetricsConfigurations)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBucketMetricsConfigurations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListBucketMetricsConfigurationsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_108 = &_input.bucket;
                let input_108 = input_108.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_108, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListBucketMetricsConfigurationsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("metrics");
                query.push_kv("x-id", "ListBucketMetricsConfigurations");
                if let Some(inner_109) = &_input.continuation_token {
                    query.push_kv(
                        "continuation-token",
                        &aws_smithy_http::query::fmt_string(&inner_109),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListBucketMetricsConfigurationsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_list_bucket_metrics_configurations(
                    input, builder,
                )?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListBucketMetricsConfigurations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListBucketMetricsConfigurations",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListBucketMetricsConfigurationsInput`](crate::input::ListBucketMetricsConfigurationsInput)
    pub fn builder() -> crate::input::list_bucket_metrics_configurations_input::Builder {
        crate::input::list_bucket_metrics_configurations_input::Builder::default()
    }
}

/// See [`ListBucketsInput`](crate::input::ListBucketsInput)
pub mod list_buckets_input {
    /// A builder for [`ListBucketsInput`](crate::input::ListBucketsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ListBucketsInput`](crate::input::ListBucketsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListBucketsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListBucketsInput {})
        }
    }
}
#[doc(hidden)]
pub type ListBucketsInputOperationOutputAlias = crate::operation::ListBuckets;
#[doc(hidden)]
pub type ListBucketsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListBucketsInput {
    /// Consumes the builder and constructs an Operation<[`ListBuckets`](crate::operation::ListBuckets)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBuckets,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListBucketsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListBucketsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListBuckets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListBuckets",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListBucketsInput`](crate::input::ListBucketsInput)
    pub fn builder() -> crate::input::list_buckets_input::Builder {
        crate::input::list_buckets_input::Builder::default()
    }
}

/// See [`ListMultipartUploadsInput`](crate::input::ListMultipartUploadsInput)
pub mod list_multipart_uploads_input {
    /// A builder for [`ListMultipartUploadsInput`](crate::input::ListMultipartUploadsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) delimiter: std::option::Option<std::string::String>,
        pub(crate) encoding_type: std::option::Option<crate::model::EncodingType>,
        pub(crate) key_marker: std::option::Option<std::string::String>,
        pub(crate) max_uploads: std::option::Option<i32>,
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) upload_id_marker: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket to which the multipart upload was initiated. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket to which the multipart upload was initiated. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Character you use to group keys.</p>
        /// <p>All keys that contain the same string between the prefix, if specified, and the first occurrence of the delimiter after the prefix are grouped under a single result element, <code>CommonPrefixes</code>. If you don't specify the prefix parameter, then the substring starts at the beginning of the key. The keys that are grouped under <code>CommonPrefixes</code> result element are not returned elsewhere in the response.</p>
        pub fn delimiter(mut self, input: impl Into<std::string::String>) -> Self {
            self.delimiter = Some(input.into());
            self
        }
        /// <p>Character you use to group keys.</p>
        /// <p>All keys that contain the same string between the prefix, if specified, and the first occurrence of the delimiter after the prefix are grouped under a single result element, <code>CommonPrefixes</code>. If you don't specify the prefix parameter, then the substring starts at the beginning of the key. The keys that are grouped under <code>CommonPrefixes</code> result element are not returned elsewhere in the response.</p>
        pub fn set_delimiter(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.delimiter = input;
            self
        }
        /// <p>Requests Amazon S3 to encode the object keys in the response and specifies the encoding method to use. An object key may contain any Unicode character; however, XML 1.0 parser cannot parse some characters, such as characters with an ASCII value from 0 to 10. For characters that are not supported in XML 1.0, you can add this parameter to request that Amazon S3 encode the keys in the response.</p>
        pub fn encoding_type(mut self, input: crate::model::EncodingType) -> Self {
            self.encoding_type = Some(input);
            self
        }
        /// <p>Requests Amazon S3 to encode the object keys in the response and specifies the encoding method to use. An object key may contain any Unicode character; however, XML 1.0 parser cannot parse some characters, such as characters with an ASCII value from 0 to 10. For characters that are not supported in XML 1.0, you can add this parameter to request that Amazon S3 encode the keys in the response.</p>
        pub fn set_encoding_type(
            mut self,
            input: std::option::Option<crate::model::EncodingType>,
        ) -> Self {
            self.encoding_type = input;
            self
        }
        /// <p>Together with upload-id-marker, this parameter specifies the multipart upload after which listing should begin.</p>
        /// <p>If <code>upload-id-marker</code> is not specified, only the keys lexicographically greater than the specified <code>key-marker</code> will be included in the list.</p>
        /// <p>If <code>upload-id-marker</code> is specified, any multipart uploads for a key equal to the <code>key-marker</code> might also be included, provided those multipart uploads have upload IDs lexicographically greater than the specified <code>upload-id-marker</code>.</p>
        pub fn key_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_marker = Some(input.into());
            self
        }
        /// <p>Together with upload-id-marker, this parameter specifies the multipart upload after which listing should begin.</p>
        /// <p>If <code>upload-id-marker</code> is not specified, only the keys lexicographically greater than the specified <code>key-marker</code> will be included in the list.</p>
        /// <p>If <code>upload-id-marker</code> is specified, any multipart uploads for a key equal to the <code>key-marker</code> might also be included, provided those multipart uploads have upload IDs lexicographically greater than the specified <code>upload-id-marker</code>.</p>
        pub fn set_key_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_marker = input;
            self
        }
        /// <p>Sets the maximum number of multipart uploads, from 1 to 1,000, to return in the response body. 1,000 is the maximum number of uploads that can be returned in a response.</p>
        pub fn max_uploads(mut self, input: i32) -> Self {
            self.max_uploads = Some(input);
            self
        }
        /// <p>Sets the maximum number of multipart uploads, from 1 to 1,000, to return in the response body. 1,000 is the maximum number of uploads that can be returned in a response.</p>
        pub fn set_max_uploads(mut self, input: std::option::Option<i32>) -> Self {
            self.max_uploads = input;
            self
        }
        /// <p>Lists in-progress uploads only for those keys that begin with the specified prefix. You can use prefixes to separate a bucket into different grouping of keys. (You can think of using prefix to make groups in the same way you'd use a folder in a file system.)</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>Lists in-progress uploads only for those keys that begin with the specified prefix. You can use prefixes to separate a bucket into different grouping of keys. (You can think of using prefix to make groups in the same way you'd use a folder in a file system.)</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// <p>Together with key-marker, specifies the multipart upload after which listing should begin. If key-marker is not specified, the upload-id-marker parameter is ignored. Otherwise, any multipart uploads for a key equal to the key-marker might be included in the list only if they have an upload ID lexicographically greater than the specified <code>upload-id-marker</code>.</p>
        pub fn upload_id_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.upload_id_marker = Some(input.into());
            self
        }
        /// <p>Together with key-marker, specifies the multipart upload after which listing should begin. If key-marker is not specified, the upload-id-marker parameter is ignored. Otherwise, any multipart uploads for a key equal to the key-marker might be included in the list only if they have an upload ID lexicographically greater than the specified <code>upload-id-marker</code>.</p>
        pub fn set_upload_id_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.upload_id_marker = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMultipartUploadsInput`](crate::input::ListMultipartUploadsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListMultipartUploadsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListMultipartUploadsInput {
                bucket: self.bucket,
                delimiter: self.delimiter,
                encoding_type: self.encoding_type,
                key_marker: self.key_marker,
                max_uploads: self.max_uploads.unwrap_or_default(),
                prefix: self.prefix,
                upload_id_marker: self.upload_id_marker,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type ListMultipartUploadsInputOperationOutputAlias = crate::operation::ListMultipartUploads;
#[doc(hidden)]
pub type ListMultipartUploadsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListMultipartUploadsInput {
    /// Consumes the builder and constructs an Operation<[`ListMultipartUploads`](crate::operation::ListMultipartUploads)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListMultipartUploads,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListMultipartUploadsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_110 = &_input.bucket;
                let input_110 = input_110.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_110, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListMultipartUploadsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("uploads");
                if let Some(inner_111) = &_input.delimiter {
                    query.push_kv("delimiter", &aws_smithy_http::query::fmt_string(&inner_111));
                }
                if let Some(inner_112) = &_input.encoding_type {
                    query.push_kv(
                        "encoding-type",
                        &aws_smithy_http::query::fmt_string(&inner_112),
                    );
                }
                if let Some(inner_113) = &_input.key_marker {
                    query.push_kv(
                        "key-marker",
                        &aws_smithy_http::query::fmt_string(&inner_113),
                    );
                }
                if _input.max_uploads != 0 {
                    query.push_kv(
                        "max-uploads",
                        aws_smithy_types::primitive::Encoder::from(_input.max_uploads).encode(),
                    );
                }
                if let Some(inner_114) = &_input.prefix {
                    query.push_kv("prefix", &aws_smithy_http::query::fmt_string(&inner_114));
                }
                if let Some(inner_115) = &_input.upload_id_marker {
                    query.push_kv(
                        "upload-id-marker",
                        &aws_smithy_http::query::fmt_string(&inner_115),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListMultipartUploadsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_list_multipart_uploads(input, builder)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListMultipartUploads::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListMultipartUploads",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListMultipartUploadsInput`](crate::input::ListMultipartUploadsInput)
    pub fn builder() -> crate::input::list_multipart_uploads_input::Builder {
        crate::input::list_multipart_uploads_input::Builder::default()
    }
}

/// See [`ListObjectsInput`](crate::input::ListObjectsInput)
pub mod list_objects_input {
    /// A builder for [`ListObjectsInput`](crate::input::ListObjectsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) delimiter: std::option::Option<std::string::String>,
        pub(crate) encoding_type: std::option::Option<crate::model::EncodingType>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_keys: std::option::Option<i32>,
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) request_payer: std::option::Option<crate::model::RequestPayer>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket containing the objects.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket containing the objects.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>A delimiter is a character you use to group keys.</p>
        pub fn delimiter(mut self, input: impl Into<std::string::String>) -> Self {
            self.delimiter = Some(input.into());
            self
        }
        /// <p>A delimiter is a character you use to group keys.</p>
        pub fn set_delimiter(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.delimiter = input;
            self
        }
        /// <p>Requests Amazon S3 to encode the object keys in the response and specifies the encoding method to use. An object key may contain any Unicode character; however, XML 1.0 parser cannot parse some characters, such as characters with an ASCII value from 0 to 10. For characters that are not supported in XML 1.0, you can add this parameter to request that Amazon S3 encode the keys in the response.</p>
        pub fn encoding_type(mut self, input: crate::model::EncodingType) -> Self {
            self.encoding_type = Some(input);
            self
        }
        /// <p>Requests Amazon S3 to encode the object keys in the response and specifies the encoding method to use. An object key may contain any Unicode character; however, XML 1.0 parser cannot parse some characters, such as characters with an ASCII value from 0 to 10. For characters that are not supported in XML 1.0, you can add this parameter to request that Amazon S3 encode the keys in the response.</p>
        pub fn set_encoding_type(
            mut self,
            input: std::option::Option<crate::model::EncodingType>,
        ) -> Self {
            self.encoding_type = input;
            self
        }
        /// <p>Marker is where you want Amazon S3 to start listing from. Amazon S3 starts listing after this specified key. Marker can be any key in the bucket.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Marker is where you want Amazon S3 to start listing from. Amazon S3 starts listing after this specified key. Marker can be any key in the bucket.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Sets the maximum number of keys returned in the response. By default the action returns up to 1,000 key names. The response might contain fewer keys but will never contain more. </p>
        pub fn max_keys(mut self, input: i32) -> Self {
            self.max_keys = Some(input);
            self
        }
        /// <p>Sets the maximum number of keys returned in the response. By default the action returns up to 1,000 key names. The response might contain fewer keys but will never contain more. </p>
        pub fn set_max_keys(mut self, input: std::option::Option<i32>) -> Self {
            self.max_keys = input;
            self
        }
        /// <p>Limits the response to keys that begin with the specified prefix.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>Limits the response to keys that begin with the specified prefix.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// <p>Confirms that the requester knows that she or he will be charged for the list objects request. Bucket owners need not specify this parameter in their requests.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.request_payer = Some(input);
            self
        }
        /// <p>Confirms that the requester knows that she or he will be charged for the list objects request. Bucket owners need not specify this parameter in their requests.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.request_payer = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`ListObjectsInput`](crate::input::ListObjectsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListObjectsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListObjectsInput {
                bucket: self.bucket,
                delimiter: self.delimiter,
                encoding_type: self.encoding_type,
                marker: self.marker,
                max_keys: self.max_keys.unwrap_or_default(),
                prefix: self.prefix,
                request_payer: self.request_payer,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type ListObjectsInputOperationOutputAlias = crate::operation::ListObjects;
#[doc(hidden)]
pub type ListObjectsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListObjectsInput {
    /// Consumes the builder and constructs an Operation<[`ListObjects`](crate::operation::ListObjects)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListObjects,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListObjectsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_116 = &_input.bucket;
                let input_116 = input_116.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_116, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListObjectsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_117) = &_input.delimiter {
                    query.push_kv("delimiter", &aws_smithy_http::query::fmt_string(&inner_117));
                }
                if let Some(inner_118) = &_input.encoding_type {
                    query.push_kv(
                        "encoding-type",
                        &aws_smithy_http::query::fmt_string(&inner_118),
                    );
                }
                if let Some(inner_119) = &_input.marker {
                    query.push_kv("marker", &aws_smithy_http::query::fmt_string(&inner_119));
                }
                if _input.max_keys != 0 {
                    query.push_kv(
                        "max-keys",
                        aws_smithy_types::primitive::Encoder::from(_input.max_keys).encode(),
                    );
                }
                if let Some(inner_120) = &_input.prefix {
                    query.push_kv("prefix", &aws_smithy_http::query::fmt_string(&inner_120));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListObjectsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_list_objects(input, builder)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListObjects::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListObjects",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListObjectsInput`](crate::input::ListObjectsInput)
    pub fn builder() -> crate::input::list_objects_input::Builder {
        crate::input::list_objects_input::Builder::default()
    }
}

/// See [`ListObjectsV2Input`](crate::input::ListObjectsV2Input)
pub mod list_objects_v2_input {
    /// A builder for [`ListObjectsV2Input`](crate::input::ListObjectsV2Input)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) delimiter: std::option::Option<std::string::String>,
        pub(crate) encoding_type: std::option::Option<crate::model::EncodingType>,
        pub(crate) max_keys: std::option::Option<i32>,
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) continuation_token: std::option::Option<std::string::String>,
        pub(crate) fetch_owner: std::option::Option<bool>,
        pub(crate) start_after: std::option::Option<std::string::String>,
        pub(crate) request_payer: std::option::Option<crate::model::RequestPayer>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Bucket name to list. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>Bucket name to list. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>A delimiter is a character you use to group keys.</p>
        pub fn delimiter(mut self, input: impl Into<std::string::String>) -> Self {
            self.delimiter = Some(input.into());
            self
        }
        /// <p>A delimiter is a character you use to group keys.</p>
        pub fn set_delimiter(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.delimiter = input;
            self
        }
        /// <p>Encoding type used by Amazon S3 to encode object keys in the response.</p>
        pub fn encoding_type(mut self, input: crate::model::EncodingType) -> Self {
            self.encoding_type = Some(input);
            self
        }
        /// <p>Encoding type used by Amazon S3 to encode object keys in the response.</p>
        pub fn set_encoding_type(
            mut self,
            input: std::option::Option<crate::model::EncodingType>,
        ) -> Self {
            self.encoding_type = input;
            self
        }
        /// <p>Sets the maximum number of keys returned in the response. By default the action returns up to 1,000 key names. The response might contain fewer keys but will never contain more.</p>
        pub fn max_keys(mut self, input: i32) -> Self {
            self.max_keys = Some(input);
            self
        }
        /// <p>Sets the maximum number of keys returned in the response. By default the action returns up to 1,000 key names. The response might contain fewer keys but will never contain more.</p>
        pub fn set_max_keys(mut self, input: std::option::Option<i32>) -> Self {
            self.max_keys = input;
            self
        }
        /// <p>Limits the response to keys that begin with the specified prefix.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>Limits the response to keys that begin with the specified prefix.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// <p>ContinuationToken indicates Amazon S3 that the list is being continued on this bucket with a token. ContinuationToken is obfuscated and is not a real key.</p>
        pub fn continuation_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.continuation_token = Some(input.into());
            self
        }
        /// <p>ContinuationToken indicates Amazon S3 that the list is being continued on this bucket with a token. ContinuationToken is obfuscated and is not a real key.</p>
        pub fn set_continuation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.continuation_token = input;
            self
        }
        /// <p>The owner field is not present in listV2 by default, if you want to return owner field with each key in the result then set the fetch owner field to true.</p>
        pub fn fetch_owner(mut self, input: bool) -> Self {
            self.fetch_owner = Some(input);
            self
        }
        /// <p>The owner field is not present in listV2 by default, if you want to return owner field with each key in the result then set the fetch owner field to true.</p>
        pub fn set_fetch_owner(mut self, input: std::option::Option<bool>) -> Self {
            self.fetch_owner = input;
            self
        }
        /// <p>StartAfter is where you want Amazon S3 to start listing from. Amazon S3 starts listing after this specified key. StartAfter can be any key in the bucket.</p>
        pub fn start_after(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_after = Some(input.into());
            self
        }
        /// <p>StartAfter is where you want Amazon S3 to start listing from. Amazon S3 starts listing after this specified key. StartAfter can be any key in the bucket.</p>
        pub fn set_start_after(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.start_after = input;
            self
        }
        /// <p>Confirms that the requester knows that she or he will be charged for the list objects request in V2 style. Bucket owners need not specify this parameter in their requests.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.request_payer = Some(input);
            self
        }
        /// <p>Confirms that the requester knows that she or he will be charged for the list objects request in V2 style. Bucket owners need not specify this parameter in their requests.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.request_payer = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`ListObjectsV2Input`](crate::input::ListObjectsV2Input)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListObjectsV2Input,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListObjectsV2Input {
                bucket: self.bucket,
                delimiter: self.delimiter,
                encoding_type: self.encoding_type,
                max_keys: self.max_keys.unwrap_or_default(),
                prefix: self.prefix,
                continuation_token: self.continuation_token,
                fetch_owner: self.fetch_owner.unwrap_or_default(),
                start_after: self.start_after,
                request_payer: self.request_payer,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type ListObjectsV2InputOperationOutputAlias = crate::operation::ListObjectsV2;
#[doc(hidden)]
pub type ListObjectsV2InputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListObjectsV2Input {
    /// Consumes the builder and constructs an Operation<[`ListObjectsV2`](crate::operation::ListObjectsV2)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListObjectsV2,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListObjectsV2Input,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_121 = &_input.bucket;
                let input_121 = input_121.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_121, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListObjectsV2Input,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_kv("list-type", "2");
                if let Some(inner_122) = &_input.delimiter {
                    query.push_kv("delimiter", &aws_smithy_http::query::fmt_string(&inner_122));
                }
                if let Some(inner_123) = &_input.encoding_type {
                    query.push_kv(
                        "encoding-type",
                        &aws_smithy_http::query::fmt_string(&inner_123),
                    );
                }
                if _input.max_keys != 0 {
                    query.push_kv(
                        "max-keys",
                        aws_smithy_types::primitive::Encoder::from(_input.max_keys).encode(),
                    );
                }
                if let Some(inner_124) = &_input.prefix {
                    query.push_kv("prefix", &aws_smithy_http::query::fmt_string(&inner_124));
                }
                if let Some(inner_125) = &_input.continuation_token {
                    query.push_kv(
                        "continuation-token",
                        &aws_smithy_http::query::fmt_string(&inner_125),
                    );
                }
                if _input.fetch_owner {
                    query.push_kv(
                        "fetch-owner",
                        aws_smithy_types::primitive::Encoder::from(_input.fetch_owner).encode(),
                    );
                }
                if let Some(inner_126) = &_input.start_after {
                    query.push_kv(
                        "start-after",
                        &aws_smithy_http::query::fmt_string(&inner_126),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListObjectsV2Input,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_list_objects_v2(input, builder)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListObjectsV2::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListObjectsV2",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListObjectsV2Input`](crate::input::ListObjectsV2Input)
    pub fn builder() -> crate::input::list_objects_v2_input::Builder {
        crate::input::list_objects_v2_input::Builder::default()
    }
}

/// See [`ListObjectVersionsInput`](crate::input::ListObjectVersionsInput)
pub mod list_object_versions_input {
    /// A builder for [`ListObjectVersionsInput`](crate::input::ListObjectVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) delimiter: std::option::Option<std::string::String>,
        pub(crate) encoding_type: std::option::Option<crate::model::EncodingType>,
        pub(crate) key_marker: std::option::Option<std::string::String>,
        pub(crate) max_keys: std::option::Option<i32>,
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) version_id_marker: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket name that contains the objects. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name that contains the objects. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>A delimiter is a character that you specify to group keys. All keys that contain the same string between the <code>prefix</code> and the first occurrence of the delimiter are grouped under a single result element in CommonPrefixes. These groups are counted as one result against the max-keys limitation. These keys are not returned elsewhere in the response.</p>
        pub fn delimiter(mut self, input: impl Into<std::string::String>) -> Self {
            self.delimiter = Some(input.into());
            self
        }
        /// <p>A delimiter is a character that you specify to group keys. All keys that contain the same string between the <code>prefix</code> and the first occurrence of the delimiter are grouped under a single result element in CommonPrefixes. These groups are counted as one result against the max-keys limitation. These keys are not returned elsewhere in the response.</p>
        pub fn set_delimiter(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.delimiter = input;
            self
        }
        /// <p>Requests Amazon S3 to encode the object keys in the response and specifies the encoding method to use. An object key may contain any Unicode character; however, XML 1.0 parser cannot parse some characters, such as characters with an ASCII value from 0 to 10. For characters that are not supported in XML 1.0, you can add this parameter to request that Amazon S3 encode the keys in the response.</p>
        pub fn encoding_type(mut self, input: crate::model::EncodingType) -> Self {
            self.encoding_type = Some(input);
            self
        }
        /// <p>Requests Amazon S3 to encode the object keys in the response and specifies the encoding method to use. An object key may contain any Unicode character; however, XML 1.0 parser cannot parse some characters, such as characters with an ASCII value from 0 to 10. For characters that are not supported in XML 1.0, you can add this parameter to request that Amazon S3 encode the keys in the response.</p>
        pub fn set_encoding_type(
            mut self,
            input: std::option::Option<crate::model::EncodingType>,
        ) -> Self {
            self.encoding_type = input;
            self
        }
        /// <p>Specifies the key to start with when listing objects in a bucket.</p>
        pub fn key_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_marker = Some(input.into());
            self
        }
        /// <p>Specifies the key to start with when listing objects in a bucket.</p>
        pub fn set_key_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_marker = input;
            self
        }
        /// <p>Sets the maximum number of keys returned in the response. By default the action returns up to 1,000 key names. The response might contain fewer keys but will never contain more. If additional keys satisfy the search criteria, but were not returned because max-keys was exceeded, the response contains <istruncated>
        /// true
        /// </istruncated>. To return the additional keys, see key-marker and version-id-marker.</p>
        pub fn max_keys(mut self, input: i32) -> Self {
            self.max_keys = Some(input);
            self
        }
        /// <p>Sets the maximum number of keys returned in the response. By default the action returns up to 1,000 key names. The response might contain fewer keys but will never contain more. If additional keys satisfy the search criteria, but were not returned because max-keys was exceeded, the response contains <istruncated>
        /// true
        /// </istruncated>. To return the additional keys, see key-marker and version-id-marker.</p>
        pub fn set_max_keys(mut self, input: std::option::Option<i32>) -> Self {
            self.max_keys = input;
            self
        }
        /// <p>Use this parameter to select only those keys that begin with the specified prefix. You can use prefixes to separate a bucket into different groupings of keys. (You can think of using prefix to make groups in the same way you'd use a folder in a file system.) You can use prefix with delimiter to roll up numerous objects into a single result under CommonPrefixes. </p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>Use this parameter to select only those keys that begin with the specified prefix. You can use prefixes to separate a bucket into different groupings of keys. (You can think of using prefix to make groups in the same way you'd use a folder in a file system.) You can use prefix with delimiter to roll up numerous objects into a single result under CommonPrefixes. </p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// <p>Specifies the object version you want to start listing from.</p>
        pub fn version_id_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id_marker = Some(input.into());
            self
        }
        /// <p>Specifies the object version you want to start listing from.</p>
        pub fn set_version_id_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.version_id_marker = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`ListObjectVersionsInput`](crate::input::ListObjectVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListObjectVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListObjectVersionsInput {
                bucket: self.bucket,
                delimiter: self.delimiter,
                encoding_type: self.encoding_type,
                key_marker: self.key_marker,
                max_keys: self.max_keys.unwrap_or_default(),
                prefix: self.prefix,
                version_id_marker: self.version_id_marker,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type ListObjectVersionsInputOperationOutputAlias = crate::operation::ListObjectVersions;
#[doc(hidden)]
pub type ListObjectVersionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListObjectVersionsInput {
    /// Consumes the builder and constructs an Operation<[`ListObjectVersions`](crate::operation::ListObjectVersions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListObjectVersions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListObjectVersionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_127 = &_input.bucket;
                let input_127 = input_127.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_127, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListObjectVersionsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("versions");
                if let Some(inner_128) = &_input.delimiter {
                    query.push_kv("delimiter", &aws_smithy_http::query::fmt_string(&inner_128));
                }
                if let Some(inner_129) = &_input.encoding_type {
                    query.push_kv(
                        "encoding-type",
                        &aws_smithy_http::query::fmt_string(&inner_129),
                    );
                }
                if let Some(inner_130) = &_input.key_marker {
                    query.push_kv(
                        "key-marker",
                        &aws_smithy_http::query::fmt_string(&inner_130),
                    );
                }
                if _input.max_keys != 0 {
                    query.push_kv(
                        "max-keys",
                        aws_smithy_types::primitive::Encoder::from(_input.max_keys).encode(),
                    );
                }
                if let Some(inner_131) = &_input.prefix {
                    query.push_kv("prefix", &aws_smithy_http::query::fmt_string(&inner_131));
                }
                if let Some(inner_132) = &_input.version_id_marker {
                    query.push_kv(
                        "version-id-marker",
                        &aws_smithy_http::query::fmt_string(&inner_132),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListObjectVersionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_list_object_versions(input, builder)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListObjectVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListObjectVersions",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListObjectVersionsInput`](crate::input::ListObjectVersionsInput)
    pub fn builder() -> crate::input::list_object_versions_input::Builder {
        crate::input::list_object_versions_input::Builder::default()
    }
}

/// See [`ListPartsInput`](crate::input::ListPartsInput)
pub mod list_parts_input {
    /// A builder for [`ListPartsInput`](crate::input::ListPartsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) max_parts: std::option::Option<i32>,
        pub(crate) part_number_marker: std::option::Option<std::string::String>,
        pub(crate) upload_id: std::option::Option<std::string::String>,
        pub(crate) request_payer: std::option::Option<crate::model::RequestPayer>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket to which the parts are being uploaded. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket to which the parts are being uploaded. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Object key for which the multipart upload was initiated.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>Object key for which the multipart upload was initiated.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>Sets the maximum number of parts to return.</p>
        pub fn max_parts(mut self, input: i32) -> Self {
            self.max_parts = Some(input);
            self
        }
        /// <p>Sets the maximum number of parts to return.</p>
        pub fn set_max_parts(mut self, input: std::option::Option<i32>) -> Self {
            self.max_parts = input;
            self
        }
        /// <p>Specifies the part after which listing should begin. Only parts with higher part numbers will be listed.</p>
        pub fn part_number_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.part_number_marker = Some(input.into());
            self
        }
        /// <p>Specifies the part after which listing should begin. Only parts with higher part numbers will be listed.</p>
        pub fn set_part_number_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.part_number_marker = input;
            self
        }
        /// <p>Upload ID identifying the multipart upload whose parts are being listed.</p>
        pub fn upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.upload_id = Some(input.into());
            self
        }
        /// <p>Upload ID identifying the multipart upload whose parts are being listed.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.upload_id = input;
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.request_payer = Some(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.request_payer = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPartsInput`](crate::input::ListPartsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListPartsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListPartsInput {
                bucket: self.bucket,
                key: self.key,
                max_parts: self.max_parts.unwrap_or_default(),
                part_number_marker: self.part_number_marker,
                upload_id: self.upload_id,
                request_payer: self.request_payer,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPartsInputOperationOutputAlias = crate::operation::ListParts;
#[doc(hidden)]
pub type ListPartsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListPartsInput {
    /// Consumes the builder and constructs an Operation<[`ListParts`](crate::operation::ListParts)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListParts,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListPartsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_133 = &_input.bucket;
                let input_133 = input_133.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_133, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                let input_134 = &_input.key;
                let input_134 = input_134.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    },
                )?;
                let key = aws_smithy_http::label::fmt_string(input_134, true);
                if key.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}/{Key}", Bucket = bucket, Key = key)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListPartsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_kv("x-id", "ListParts");
                if _input.max_parts != 0 {
                    query.push_kv(
                        "max-parts",
                        aws_smithy_types::primitive::Encoder::from(_input.max_parts).encode(),
                    );
                }
                if let Some(inner_135) = &_input.part_number_marker {
                    query.push_kv(
                        "part-number-marker",
                        &aws_smithy_http::query::fmt_string(&inner_135),
                    );
                }
                if let Some(inner_136) = &_input.upload_id {
                    query.push_kv("uploadId", &aws_smithy_http::query::fmt_string(&inner_136));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListPartsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_list_parts(input, builder)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListParts::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new("ListParts", "s3"));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListPartsInput`](crate::input::ListPartsInput)
    pub fn builder() -> crate::input::list_parts_input::Builder {
        crate::input::list_parts_input::Builder::default()
    }
}

/// See [`PutBucketAccelerateConfigurationInput`](crate::input::PutBucketAccelerateConfigurationInput)
pub mod put_bucket_accelerate_configuration_input {
    /// A builder for [`PutBucketAccelerateConfigurationInput`](crate::input::PutBucketAccelerateConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) accelerate_configuration:
            std::option::Option<crate::model::AccelerateConfiguration>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket for which the accelerate configuration is set.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket for which the accelerate configuration is set.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Container for setting the transfer acceleration state.</p>
        pub fn accelerate_configuration(
            mut self,
            input: crate::model::AccelerateConfiguration,
        ) -> Self {
            self.accelerate_configuration = Some(input);
            self
        }
        /// <p>Container for setting the transfer acceleration state.</p>
        pub fn set_accelerate_configuration(
            mut self,
            input: std::option::Option<crate::model::AccelerateConfiguration>,
        ) -> Self {
            self.accelerate_configuration = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`PutBucketAccelerateConfigurationInput`](crate::input::PutBucketAccelerateConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutBucketAccelerateConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutBucketAccelerateConfigurationInput {
                bucket: self.bucket,
                accelerate_configuration: self.accelerate_configuration,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type PutBucketAccelerateConfigurationInputOperationOutputAlias =
    crate::operation::PutBucketAccelerateConfiguration;
#[doc(hidden)]
pub type PutBucketAccelerateConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutBucketAccelerateConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`PutBucketAccelerateConfiguration`](crate::operation::PutBucketAccelerateConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutBucketAccelerateConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutBucketAccelerateConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_137 = &_input.bucket;
                let input_137 = input_137.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_137, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::PutBucketAccelerateConfigurationInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("accelerate");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutBucketAccelerateConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_put_bucket_accelerate_configuration(
                    input, builder,
                )?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_put_bucket_accelerate_configuration_input(
                &self.accelerate_configuration,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutBucketAccelerateConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutBucketAccelerateConfiguration",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutBucketAccelerateConfigurationInput`](crate::input::PutBucketAccelerateConfigurationInput)
    pub fn builder() -> crate::input::put_bucket_accelerate_configuration_input::Builder {
        crate::input::put_bucket_accelerate_configuration_input::Builder::default()
    }
}

/// See [`PutBucketAclInput`](crate::input::PutBucketAclInput)
pub mod put_bucket_acl_input {
    /// A builder for [`PutBucketAclInput`](crate::input::PutBucketAclInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) acl: std::option::Option<crate::model::BucketCannedAcl>,
        pub(crate) access_control_policy: std::option::Option<crate::model::AccessControlPolicy>,
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) content_md5: std::option::Option<std::string::String>,
        pub(crate) grant_full_control: std::option::Option<std::string::String>,
        pub(crate) grant_read: std::option::Option<std::string::String>,
        pub(crate) grant_read_acp: std::option::Option<std::string::String>,
        pub(crate) grant_write: std::option::Option<std::string::String>,
        pub(crate) grant_write_acp: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The canned ACL to apply to the bucket.</p>
        pub fn acl(mut self, input: crate::model::BucketCannedAcl) -> Self {
            self.acl = Some(input);
            self
        }
        /// <p>The canned ACL to apply to the bucket.</p>
        pub fn set_acl(
            mut self,
            input: std::option::Option<crate::model::BucketCannedAcl>,
        ) -> Self {
            self.acl = input;
            self
        }
        /// <p>Contains the elements that set the ACL permissions for an object per grantee.</p>
        pub fn access_control_policy(mut self, input: crate::model::AccessControlPolicy) -> Self {
            self.access_control_policy = Some(input);
            self
        }
        /// <p>Contains the elements that set the ACL permissions for an object per grantee.</p>
        pub fn set_access_control_policy(
            mut self,
            input: std::option::Option<crate::model::AccessControlPolicy>,
        ) -> Self {
            self.access_control_policy = input;
            self
        }
        /// <p>The bucket to which to apply the ACL.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket to which to apply the ACL.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The base64-encoded 128-bit MD5 digest of the data. This header must be used as a message integrity check to verify that the request body was not corrupted in transit. For more information, go to <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864.</a> </p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn content_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_md5 = Some(input.into());
            self
        }
        /// <p>The base64-encoded 128-bit MD5 digest of the data. This header must be used as a message integrity check to verify that the request body was not corrupted in transit. For more information, go to <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864.</a> </p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn set_content_md5(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_md5 = input;
            self
        }
        /// <p>Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.</p>
        pub fn grant_full_control(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_full_control = Some(input.into());
            self
        }
        /// <p>Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.</p>
        pub fn set_grant_full_control(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.grant_full_control = input;
            self
        }
        /// <p>Allows grantee to list the objects in the bucket.</p>
        pub fn grant_read(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_read = Some(input.into());
            self
        }
        /// <p>Allows grantee to list the objects in the bucket.</p>
        pub fn set_grant_read(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.grant_read = input;
            self
        }
        /// <p>Allows grantee to read the bucket ACL.</p>
        pub fn grant_read_acp(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_read_acp = Some(input.into());
            self
        }
        /// <p>Allows grantee to read the bucket ACL.</p>
        pub fn set_grant_read_acp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.grant_read_acp = input;
            self
        }
        /// <p>Allows grantee to create new objects in the bucket.</p>
        /// <p>For the bucket and object owners of existing objects, also allows deletions and overwrites of those objects.</p>
        pub fn grant_write(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_write = Some(input.into());
            self
        }
        /// <p>Allows grantee to create new objects in the bucket.</p>
        /// <p>For the bucket and object owners of existing objects, also allows deletions and overwrites of those objects.</p>
        pub fn set_grant_write(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.grant_write = input;
            self
        }
        /// <p>Allows grantee to write the ACL for the applicable bucket.</p>
        pub fn grant_write_acp(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_write_acp = Some(input.into());
            self
        }
        /// <p>Allows grantee to write the ACL for the applicable bucket.</p>
        pub fn set_grant_write_acp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.grant_write_acp = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`PutBucketAclInput`](crate::input::PutBucketAclInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutBucketAclInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutBucketAclInput {
                acl: self.acl,
                access_control_policy: self.access_control_policy,
                bucket: self.bucket,
                content_md5: self.content_md5,
                grant_full_control: self.grant_full_control,
                grant_read: self.grant_read,
                grant_read_acp: self.grant_read_acp,
                grant_write: self.grant_write,
                grant_write_acp: self.grant_write_acp,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type PutBucketAclInputOperationOutputAlias = crate::operation::PutBucketAcl;
#[doc(hidden)]
pub type PutBucketAclInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutBucketAclInput {
    /// Consumes the builder and constructs an Operation<[`PutBucketAcl`](crate::operation::PutBucketAcl)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutBucketAcl,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutBucketAclInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_138 = &_input.bucket;
                let input_138 = input_138.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_138, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::PutBucketAclInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("acl");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutBucketAclInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_put_bucket_acl(input, builder)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_put_bucket_acl_input(
                &self.access_control_policy,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request = request.augment(|mut req, _| {
            let data = req
                .body()
                .bytes()
                .expect("checksum can only be computed for non-streaming operations");
            let checksum = md5::compute(data);
            req.headers_mut().insert(
                http::header::HeaderName::from_static("content-md5"),
                aws_smithy_types::base64::encode(&checksum[..])
                    .parse()
                    .expect("checksum is valid header value"),
            );
            Result::<_, aws_smithy_http::operation::BuildError>::Ok(req)
        })?;
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutBucketAcl::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutBucketAcl",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutBucketAclInput`](crate::input::PutBucketAclInput)
    pub fn builder() -> crate::input::put_bucket_acl_input::Builder {
        crate::input::put_bucket_acl_input::Builder::default()
    }
}

/// See [`PutBucketAnalyticsConfigurationInput`](crate::input::PutBucketAnalyticsConfigurationInput)
pub mod put_bucket_analytics_configuration_input {
    /// A builder for [`PutBucketAnalyticsConfigurationInput`](crate::input::PutBucketAnalyticsConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) analytics_configuration:
            std::option::Option<crate::model::AnalyticsConfiguration>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket to which an analytics configuration is stored.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket to which an analytics configuration is stored.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The ID that identifies the analytics configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID that identifies the analytics configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The configuration and any analyses for the analytics filter.</p>
        pub fn analytics_configuration(
            mut self,
            input: crate::model::AnalyticsConfiguration,
        ) -> Self {
            self.analytics_configuration = Some(input);
            self
        }
        /// <p>The configuration and any analyses for the analytics filter.</p>
        pub fn set_analytics_configuration(
            mut self,
            input: std::option::Option<crate::model::AnalyticsConfiguration>,
        ) -> Self {
            self.analytics_configuration = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`PutBucketAnalyticsConfigurationInput`](crate::input::PutBucketAnalyticsConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutBucketAnalyticsConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutBucketAnalyticsConfigurationInput {
                bucket: self.bucket,
                id: self.id,
                analytics_configuration: self.analytics_configuration,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type PutBucketAnalyticsConfigurationInputOperationOutputAlias =
    crate::operation::PutBucketAnalyticsConfiguration;
#[doc(hidden)]
pub type PutBucketAnalyticsConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutBucketAnalyticsConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`PutBucketAnalyticsConfiguration`](crate::operation::PutBucketAnalyticsConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutBucketAnalyticsConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutBucketAnalyticsConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_139 = &_input.bucket;
                let input_139 = input_139.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_139, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::PutBucketAnalyticsConfigurationInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("analytics");
                if let Some(inner_140) = &_input.id {
                    query.push_kv("id", &aws_smithy_http::query::fmt_string(&inner_140));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutBucketAnalyticsConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_put_bucket_analytics_configuration(
                    input, builder,
                )?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_put_bucket_analytics_configuration_input(
                &self.analytics_configuration,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutBucketAnalyticsConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutBucketAnalyticsConfiguration",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutBucketAnalyticsConfigurationInput`](crate::input::PutBucketAnalyticsConfigurationInput)
    pub fn builder() -> crate::input::put_bucket_analytics_configuration_input::Builder {
        crate::input::put_bucket_analytics_configuration_input::Builder::default()
    }
}

/// See [`PutBucketCorsInput`](crate::input::PutBucketCorsInput)
pub mod put_bucket_cors_input {
    /// A builder for [`PutBucketCorsInput`](crate::input::PutBucketCorsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) cors_configuration: std::option::Option<crate::model::CorsConfiguration>,
        pub(crate) content_md5: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the bucket impacted by the <code>cors</code>configuration.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>Specifies the bucket impacted by the <code>cors</code>configuration.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Describes the cross-origin access configuration for objects in an Amazon S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html">Enabling Cross-Origin Resource Sharing</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn cors_configuration(mut self, input: crate::model::CorsConfiguration) -> Self {
            self.cors_configuration = Some(input);
            self
        }
        /// <p>Describes the cross-origin access configuration for objects in an Amazon S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html">Enabling Cross-Origin Resource Sharing</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_cors_configuration(
            mut self,
            input: std::option::Option<crate::model::CorsConfiguration>,
        ) -> Self {
            self.cors_configuration = input;
            self
        }
        /// <p>The base64-encoded 128-bit MD5 digest of the data. This header must be used as a message integrity check to verify that the request body was not corrupted in transit. For more information, go to <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864.</a> </p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn content_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_md5 = Some(input.into());
            self
        }
        /// <p>The base64-encoded 128-bit MD5 digest of the data. This header must be used as a message integrity check to verify that the request body was not corrupted in transit. For more information, go to <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864.</a> </p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn set_content_md5(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_md5 = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`PutBucketCorsInput`](crate::input::PutBucketCorsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutBucketCorsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutBucketCorsInput {
                bucket: self.bucket,
                cors_configuration: self.cors_configuration,
                content_md5: self.content_md5,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type PutBucketCorsInputOperationOutputAlias = crate::operation::PutBucketCors;
#[doc(hidden)]
pub type PutBucketCorsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutBucketCorsInput {
    /// Consumes the builder and constructs an Operation<[`PutBucketCors`](crate::operation::PutBucketCors)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutBucketCors,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutBucketCorsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_141 = &_input.bucket;
                let input_141 = input_141.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_141, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::PutBucketCorsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("cors");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutBucketCorsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_put_bucket_cors(input, builder)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_put_bucket_cors_input(
                &self.cors_configuration,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request = request.augment(|mut req, _| {
            let data = req
                .body()
                .bytes()
                .expect("checksum can only be computed for non-streaming operations");
            let checksum = md5::compute(data);
            req.headers_mut().insert(
                http::header::HeaderName::from_static("content-md5"),
                aws_smithy_types::base64::encode(&checksum[..])
                    .parse()
                    .expect("checksum is valid header value"),
            );
            Result::<_, aws_smithy_http::operation::BuildError>::Ok(req)
        })?;
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutBucketCors::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutBucketCors",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutBucketCorsInput`](crate::input::PutBucketCorsInput)
    pub fn builder() -> crate::input::put_bucket_cors_input::Builder {
        crate::input::put_bucket_cors_input::Builder::default()
    }
}

/// See [`PutBucketEncryptionInput`](crate::input::PutBucketEncryptionInput)
pub mod put_bucket_encryption_input {
    /// A builder for [`PutBucketEncryptionInput`](crate::input::PutBucketEncryptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) content_md5: std::option::Option<std::string::String>,
        pub(crate) server_side_encryption_configuration:
            std::option::Option<crate::model::ServerSideEncryptionConfiguration>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies default encryption for a bucket using server-side encryption with Amazon S3-managed keys (SSE-S3) or customer managed keys (SSE-KMS). For information about the Amazon S3 default encryption feature, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html">Amazon S3 Default Bucket Encryption</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>Specifies default encryption for a bucket using server-side encryption with Amazon S3-managed keys (SSE-S3) or customer managed keys (SSE-KMS). For information about the Amazon S3 default encryption feature, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html">Amazon S3 Default Bucket Encryption</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The base64-encoded 128-bit MD5 digest of the server-side encryption configuration.</p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn content_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_md5 = Some(input.into());
            self
        }
        /// <p>The base64-encoded 128-bit MD5 digest of the server-side encryption configuration.</p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn set_content_md5(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_md5 = input;
            self
        }
        /// <p>Specifies the default server-side-encryption configuration.</p>
        pub fn server_side_encryption_configuration(
            mut self,
            input: crate::model::ServerSideEncryptionConfiguration,
        ) -> Self {
            self.server_side_encryption_configuration = Some(input);
            self
        }
        /// <p>Specifies the default server-side-encryption configuration.</p>
        pub fn set_server_side_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::ServerSideEncryptionConfiguration>,
        ) -> Self {
            self.server_side_encryption_configuration = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`PutBucketEncryptionInput`](crate::input::PutBucketEncryptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutBucketEncryptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutBucketEncryptionInput {
                bucket: self.bucket,
                content_md5: self.content_md5,
                server_side_encryption_configuration: self.server_side_encryption_configuration,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type PutBucketEncryptionInputOperationOutputAlias = crate::operation::PutBucketEncryption;
#[doc(hidden)]
pub type PutBucketEncryptionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutBucketEncryptionInput {
    /// Consumes the builder and constructs an Operation<[`PutBucketEncryption`](crate::operation::PutBucketEncryption)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutBucketEncryption,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutBucketEncryptionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_142 = &_input.bucket;
                let input_142 = input_142.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_142, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::PutBucketEncryptionInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("encryption");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutBucketEncryptionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_put_bucket_encryption(input, builder)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_put_bucket_encryption_input(
                &self.server_side_encryption_configuration,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request = request.augment(|mut req, _| {
            let data = req
                .body()
                .bytes()
                .expect("checksum can only be computed for non-streaming operations");
            let checksum = md5::compute(data);
            req.headers_mut().insert(
                http::header::HeaderName::from_static("content-md5"),
                aws_smithy_types::base64::encode(&checksum[..])
                    .parse()
                    .expect("checksum is valid header value"),
            );
            Result::<_, aws_smithy_http::operation::BuildError>::Ok(req)
        })?;
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutBucketEncryption::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutBucketEncryption",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutBucketEncryptionInput`](crate::input::PutBucketEncryptionInput)
    pub fn builder() -> crate::input::put_bucket_encryption_input::Builder {
        crate::input::put_bucket_encryption_input::Builder::default()
    }
}

/// See [`PutBucketIntelligentTieringConfigurationInput`](crate::input::PutBucketIntelligentTieringConfigurationInput)
pub mod put_bucket_intelligent_tiering_configuration_input {
    /// A builder for [`PutBucketIntelligentTieringConfigurationInput`](crate::input::PutBucketIntelligentTieringConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) intelligent_tiering_configuration:
            std::option::Option<crate::model::IntelligentTieringConfiguration>,
    }
    impl Builder {
        /// <p>The name of the Amazon S3 bucket whose configuration you want to modify or retrieve.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket whose configuration you want to modify or retrieve.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The ID used to identify the S3 Intelligent-Tiering configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID used to identify the S3 Intelligent-Tiering configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>Container for S3 Intelligent-Tiering configuration.</p>
        pub fn intelligent_tiering_configuration(
            mut self,
            input: crate::model::IntelligentTieringConfiguration,
        ) -> Self {
            self.intelligent_tiering_configuration = Some(input);
            self
        }
        /// <p>Container for S3 Intelligent-Tiering configuration.</p>
        pub fn set_intelligent_tiering_configuration(
            mut self,
            input: std::option::Option<crate::model::IntelligentTieringConfiguration>,
        ) -> Self {
            self.intelligent_tiering_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`PutBucketIntelligentTieringConfigurationInput`](crate::input::PutBucketIntelligentTieringConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutBucketIntelligentTieringConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::PutBucketIntelligentTieringConfigurationInput {
                    bucket: self.bucket,
                    id: self.id,
                    intelligent_tiering_configuration: self.intelligent_tiering_configuration,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type PutBucketIntelligentTieringConfigurationInputOperationOutputAlias =
    crate::operation::PutBucketIntelligentTieringConfiguration;
#[doc(hidden)]
pub type PutBucketIntelligentTieringConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutBucketIntelligentTieringConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`PutBucketIntelligentTieringConfiguration`](crate::operation::PutBucketIntelligentTieringConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutBucketIntelligentTieringConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutBucketIntelligentTieringConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_143 = &_input.bucket;
                let input_143 = input_143.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_143, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::PutBucketIntelligentTieringConfigurationInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("intelligent-tiering");
                if let Some(inner_144) = &_input.id {
                    query.push_kv("id", &aws_smithy_http::query::fmt_string(&inner_144));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutBucketIntelligentTieringConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_put_bucket_intelligent_tiering_configuration_input(& self.intelligent_tiering_configuration)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutBucketIntelligentTieringConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutBucketIntelligentTieringConfiguration",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutBucketIntelligentTieringConfigurationInput`](crate::input::PutBucketIntelligentTieringConfigurationInput)
    pub fn builder() -> crate::input::put_bucket_intelligent_tiering_configuration_input::Builder {
        crate::input::put_bucket_intelligent_tiering_configuration_input::Builder::default()
    }
}

/// See [`PutBucketInventoryConfigurationInput`](crate::input::PutBucketInventoryConfigurationInput)
pub mod put_bucket_inventory_configuration_input {
    /// A builder for [`PutBucketInventoryConfigurationInput`](crate::input::PutBucketInventoryConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) inventory_configuration:
            std::option::Option<crate::model::InventoryConfiguration>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket where the inventory configuration will be stored.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket where the inventory configuration will be stored.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The ID used to identify the inventory configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID used to identify the inventory configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>Specifies the inventory configuration.</p>
        pub fn inventory_configuration(
            mut self,
            input: crate::model::InventoryConfiguration,
        ) -> Self {
            self.inventory_configuration = Some(input);
            self
        }
        /// <p>Specifies the inventory configuration.</p>
        pub fn set_inventory_configuration(
            mut self,
            input: std::option::Option<crate::model::InventoryConfiguration>,
        ) -> Self {
            self.inventory_configuration = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`PutBucketInventoryConfigurationInput`](crate::input::PutBucketInventoryConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutBucketInventoryConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutBucketInventoryConfigurationInput {
                bucket: self.bucket,
                id: self.id,
                inventory_configuration: self.inventory_configuration,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type PutBucketInventoryConfigurationInputOperationOutputAlias =
    crate::operation::PutBucketInventoryConfiguration;
#[doc(hidden)]
pub type PutBucketInventoryConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutBucketInventoryConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`PutBucketInventoryConfiguration`](crate::operation::PutBucketInventoryConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutBucketInventoryConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutBucketInventoryConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_145 = &_input.bucket;
                let input_145 = input_145.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_145, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::PutBucketInventoryConfigurationInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("inventory");
                if let Some(inner_146) = &_input.id {
                    query.push_kv("id", &aws_smithy_http::query::fmt_string(&inner_146));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutBucketInventoryConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_put_bucket_inventory_configuration(
                    input, builder,
                )?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_put_bucket_inventory_configuration_input(
                &self.inventory_configuration,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutBucketInventoryConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutBucketInventoryConfiguration",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutBucketInventoryConfigurationInput`](crate::input::PutBucketInventoryConfigurationInput)
    pub fn builder() -> crate::input::put_bucket_inventory_configuration_input::Builder {
        crate::input::put_bucket_inventory_configuration_input::Builder::default()
    }
}

/// See [`PutBucketLifecycleConfigurationInput`](crate::input::PutBucketLifecycleConfigurationInput)
pub mod put_bucket_lifecycle_configuration_input {
    /// A builder for [`PutBucketLifecycleConfigurationInput`](crate::input::PutBucketLifecycleConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) lifecycle_configuration:
            std::option::Option<crate::model::BucketLifecycleConfiguration>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket for which to set the configuration.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket for which to set the configuration.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Container for lifecycle rules. You can add as many as 1,000 rules.</p>
        pub fn lifecycle_configuration(
            mut self,
            input: crate::model::BucketLifecycleConfiguration,
        ) -> Self {
            self.lifecycle_configuration = Some(input);
            self
        }
        /// <p>Container for lifecycle rules. You can add as many as 1,000 rules.</p>
        pub fn set_lifecycle_configuration(
            mut self,
            input: std::option::Option<crate::model::BucketLifecycleConfiguration>,
        ) -> Self {
            self.lifecycle_configuration = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`PutBucketLifecycleConfigurationInput`](crate::input::PutBucketLifecycleConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutBucketLifecycleConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutBucketLifecycleConfigurationInput {
                bucket: self.bucket,
                lifecycle_configuration: self.lifecycle_configuration,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type PutBucketLifecycleConfigurationInputOperationOutputAlias =
    crate::operation::PutBucketLifecycleConfiguration;
#[doc(hidden)]
pub type PutBucketLifecycleConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutBucketLifecycleConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`PutBucketLifecycleConfiguration`](crate::operation::PutBucketLifecycleConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutBucketLifecycleConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutBucketLifecycleConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_147 = &_input.bucket;
                let input_147 = input_147.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_147, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::PutBucketLifecycleConfigurationInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("lifecycle");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutBucketLifecycleConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_put_bucket_lifecycle_configuration(
                    input, builder,
                )?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_put_bucket_lifecycle_configuration_input(
                &self.lifecycle_configuration,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request = request.augment(|mut req, _| {
            let data = req
                .body()
                .bytes()
                .expect("checksum can only be computed for non-streaming operations");
            let checksum = md5::compute(data);
            req.headers_mut().insert(
                http::header::HeaderName::from_static("content-md5"),
                aws_smithy_types::base64::encode(&checksum[..])
                    .parse()
                    .expect("checksum is valid header value"),
            );
            Result::<_, aws_smithy_http::operation::BuildError>::Ok(req)
        })?;
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutBucketLifecycleConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutBucketLifecycleConfiguration",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutBucketLifecycleConfigurationInput`](crate::input::PutBucketLifecycleConfigurationInput)
    pub fn builder() -> crate::input::put_bucket_lifecycle_configuration_input::Builder {
        crate::input::put_bucket_lifecycle_configuration_input::Builder::default()
    }
}

/// See [`PutBucketLoggingInput`](crate::input::PutBucketLoggingInput)
pub mod put_bucket_logging_input {
    /// A builder for [`PutBucketLoggingInput`](crate::input::PutBucketLoggingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) bucket_logging_status: std::option::Option<crate::model::BucketLoggingStatus>,
        pub(crate) content_md5: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket for which to set the logging parameters.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket for which to set the logging parameters.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Container for logging status information.</p>
        pub fn bucket_logging_status(mut self, input: crate::model::BucketLoggingStatus) -> Self {
            self.bucket_logging_status = Some(input);
            self
        }
        /// <p>Container for logging status information.</p>
        pub fn set_bucket_logging_status(
            mut self,
            input: std::option::Option<crate::model::BucketLoggingStatus>,
        ) -> Self {
            self.bucket_logging_status = input;
            self
        }
        /// <p>The MD5 hash of the <code>PutBucketLogging</code> request body.</p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn content_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_md5 = Some(input.into());
            self
        }
        /// <p>The MD5 hash of the <code>PutBucketLogging</code> request body.</p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn set_content_md5(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_md5 = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`PutBucketLoggingInput`](crate::input::PutBucketLoggingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutBucketLoggingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutBucketLoggingInput {
                bucket: self.bucket,
                bucket_logging_status: self.bucket_logging_status,
                content_md5: self.content_md5,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type PutBucketLoggingInputOperationOutputAlias = crate::operation::PutBucketLogging;
#[doc(hidden)]
pub type PutBucketLoggingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutBucketLoggingInput {
    /// Consumes the builder and constructs an Operation<[`PutBucketLogging`](crate::operation::PutBucketLogging)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutBucketLogging,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutBucketLoggingInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_148 = &_input.bucket;
                let input_148 = input_148.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_148, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::PutBucketLoggingInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("logging");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutBucketLoggingInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_put_bucket_logging(input, builder)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_put_bucket_logging_input(
                &self.bucket_logging_status,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request = request.augment(|mut req, _| {
            let data = req
                .body()
                .bytes()
                .expect("checksum can only be computed for non-streaming operations");
            let checksum = md5::compute(data);
            req.headers_mut().insert(
                http::header::HeaderName::from_static("content-md5"),
                aws_smithy_types::base64::encode(&checksum[..])
                    .parse()
                    .expect("checksum is valid header value"),
            );
            Result::<_, aws_smithy_http::operation::BuildError>::Ok(req)
        })?;
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutBucketLogging::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutBucketLogging",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutBucketLoggingInput`](crate::input::PutBucketLoggingInput)
    pub fn builder() -> crate::input::put_bucket_logging_input::Builder {
        crate::input::put_bucket_logging_input::Builder::default()
    }
}

/// See [`PutBucketMetricsConfigurationInput`](crate::input::PutBucketMetricsConfigurationInput)
pub mod put_bucket_metrics_configuration_input {
    /// A builder for [`PutBucketMetricsConfigurationInput`](crate::input::PutBucketMetricsConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) metrics_configuration: std::option::Option<crate::model::MetricsConfiguration>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket for which the metrics configuration is set.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket for which the metrics configuration is set.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The ID used to identify the metrics configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID used to identify the metrics configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>Specifies the metrics configuration.</p>
        pub fn metrics_configuration(mut self, input: crate::model::MetricsConfiguration) -> Self {
            self.metrics_configuration = Some(input);
            self
        }
        /// <p>Specifies the metrics configuration.</p>
        pub fn set_metrics_configuration(
            mut self,
            input: std::option::Option<crate::model::MetricsConfiguration>,
        ) -> Self {
            self.metrics_configuration = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`PutBucketMetricsConfigurationInput`](crate::input::PutBucketMetricsConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutBucketMetricsConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutBucketMetricsConfigurationInput {
                bucket: self.bucket,
                id: self.id,
                metrics_configuration: self.metrics_configuration,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type PutBucketMetricsConfigurationInputOperationOutputAlias =
    crate::operation::PutBucketMetricsConfiguration;
#[doc(hidden)]
pub type PutBucketMetricsConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutBucketMetricsConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`PutBucketMetricsConfiguration`](crate::operation::PutBucketMetricsConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutBucketMetricsConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutBucketMetricsConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_149 = &_input.bucket;
                let input_149 = input_149.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_149, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::PutBucketMetricsConfigurationInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("metrics");
                if let Some(inner_150) = &_input.id {
                    query.push_kv("id", &aws_smithy_http::query::fmt_string(&inner_150));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutBucketMetricsConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_put_bucket_metrics_configuration(
                    input, builder,
                )?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_put_bucket_metrics_configuration_input(
                &self.metrics_configuration,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutBucketMetricsConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutBucketMetricsConfiguration",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutBucketMetricsConfigurationInput`](crate::input::PutBucketMetricsConfigurationInput)
    pub fn builder() -> crate::input::put_bucket_metrics_configuration_input::Builder {
        crate::input::put_bucket_metrics_configuration_input::Builder::default()
    }
}

/// See [`PutBucketNotificationConfigurationInput`](crate::input::PutBucketNotificationConfigurationInput)
pub mod put_bucket_notification_configuration_input {
    /// A builder for [`PutBucketNotificationConfigurationInput`](crate::input::PutBucketNotificationConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) notification_configuration:
            std::option::Option<crate::model::NotificationConfiguration>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
        pub(crate) skip_destination_validation: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the bucket.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>A container for specifying the notification configuration of the bucket. If this element is empty, notifications are turned off for the bucket.</p>
        pub fn notification_configuration(
            mut self,
            input: crate::model::NotificationConfiguration,
        ) -> Self {
            self.notification_configuration = Some(input);
            self
        }
        /// <p>A container for specifying the notification configuration of the bucket. If this element is empty, notifications are turned off for the bucket.</p>
        pub fn set_notification_configuration(
            mut self,
            input: std::option::Option<crate::model::NotificationConfiguration>,
        ) -> Self {
            self.notification_configuration = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// <p>Skips validation of Amazon SQS, Amazon SNS, and Lambda destinations. True or false value.</p>
        pub fn skip_destination_validation(mut self, input: bool) -> Self {
            self.skip_destination_validation = Some(input);
            self
        }
        /// <p>Skips validation of Amazon SQS, Amazon SNS, and Lambda destinations. True or false value.</p>
        pub fn set_skip_destination_validation(mut self, input: std::option::Option<bool>) -> Self {
            self.skip_destination_validation = input;
            self
        }
        /// Consumes the builder and constructs a [`PutBucketNotificationConfigurationInput`](crate::input::PutBucketNotificationConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutBucketNotificationConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutBucketNotificationConfigurationInput {
                bucket: self.bucket,
                notification_configuration: self.notification_configuration,
                expected_bucket_owner: self.expected_bucket_owner,
                skip_destination_validation: self.skip_destination_validation.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type PutBucketNotificationConfigurationInputOperationOutputAlias =
    crate::operation::PutBucketNotificationConfiguration;
#[doc(hidden)]
pub type PutBucketNotificationConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutBucketNotificationConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`PutBucketNotificationConfiguration`](crate::operation::PutBucketNotificationConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutBucketNotificationConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutBucketNotificationConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_151 = &_input.bucket;
                let input_151 = input_151.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_151, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::PutBucketNotificationConfigurationInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("notification");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutBucketNotificationConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_put_bucket_notification_configuration(
                    input, builder,
                )?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_put_bucket_notification_configuration_input(
                &self.notification_configuration,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutBucketNotificationConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutBucketNotificationConfiguration",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutBucketNotificationConfigurationInput`](crate::input::PutBucketNotificationConfigurationInput)
    pub fn builder() -> crate::input::put_bucket_notification_configuration_input::Builder {
        crate::input::put_bucket_notification_configuration_input::Builder::default()
    }
}

/// See [`PutBucketOwnershipControlsInput`](crate::input::PutBucketOwnershipControlsInput)
pub mod put_bucket_ownership_controls_input {
    /// A builder for [`PutBucketOwnershipControlsInput`](crate::input::PutBucketOwnershipControlsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) content_md5: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
        pub(crate) ownership_controls: std::option::Option<crate::model::OwnershipControls>,
    }
    impl Builder {
        /// <p>The name of the Amazon S3 bucket whose <code>OwnershipControls</code> you want to set.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket whose <code>OwnershipControls</code> you want to set.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The MD5 hash of the <code>OwnershipControls</code> request body. </p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn content_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_md5 = Some(input.into());
            self
        }
        /// <p>The MD5 hash of the <code>OwnershipControls</code> request body. </p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn set_content_md5(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_md5 = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// <p>The <code>OwnershipControls</code> (BucketOwnerEnforced, BucketOwnerPreferred, or ObjectWriter) that you want to apply to this Amazon S3 bucket.</p>
        pub fn ownership_controls(mut self, input: crate::model::OwnershipControls) -> Self {
            self.ownership_controls = Some(input);
            self
        }
        /// <p>The <code>OwnershipControls</code> (BucketOwnerEnforced, BucketOwnerPreferred, or ObjectWriter) that you want to apply to this Amazon S3 bucket.</p>
        pub fn set_ownership_controls(
            mut self,
            input: std::option::Option<crate::model::OwnershipControls>,
        ) -> Self {
            self.ownership_controls = input;
            self
        }
        /// Consumes the builder and constructs a [`PutBucketOwnershipControlsInput`](crate::input::PutBucketOwnershipControlsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutBucketOwnershipControlsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutBucketOwnershipControlsInput {
                bucket: self.bucket,
                content_md5: self.content_md5,
                expected_bucket_owner: self.expected_bucket_owner,
                ownership_controls: self.ownership_controls,
            })
        }
    }
}
#[doc(hidden)]
pub type PutBucketOwnershipControlsInputOperationOutputAlias =
    crate::operation::PutBucketOwnershipControls;
#[doc(hidden)]
pub type PutBucketOwnershipControlsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutBucketOwnershipControlsInput {
    /// Consumes the builder and constructs an Operation<[`PutBucketOwnershipControls`](crate::operation::PutBucketOwnershipControls)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutBucketOwnershipControls,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutBucketOwnershipControlsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_152 = &_input.bucket;
                let input_152 = input_152.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_152, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::PutBucketOwnershipControlsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("ownershipControls");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutBucketOwnershipControlsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_put_bucket_ownership_controls(input, builder)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_put_bucket_ownership_controls_input(
                &self.ownership_controls,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request = request.augment(|mut req, _| {
            let data = req
                .body()
                .bytes()
                .expect("checksum can only be computed for non-streaming operations");
            let checksum = md5::compute(data);
            req.headers_mut().insert(
                http::header::HeaderName::from_static("content-md5"),
                aws_smithy_types::base64::encode(&checksum[..])
                    .parse()
                    .expect("checksum is valid header value"),
            );
            Result::<_, aws_smithy_http::operation::BuildError>::Ok(req)
        })?;
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutBucketOwnershipControls::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutBucketOwnershipControls",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutBucketOwnershipControlsInput`](crate::input::PutBucketOwnershipControlsInput)
    pub fn builder() -> crate::input::put_bucket_ownership_controls_input::Builder {
        crate::input::put_bucket_ownership_controls_input::Builder::default()
    }
}

/// See [`PutBucketPolicyInput`](crate::input::PutBucketPolicyInput)
pub mod put_bucket_policy_input {
    /// A builder for [`PutBucketPolicyInput`](crate::input::PutBucketPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) content_md5: std::option::Option<std::string::String>,
        pub(crate) confirm_remove_self_bucket_access: std::option::Option<bool>,
        pub(crate) policy: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The MD5 hash of the request body.</p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn content_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_md5 = Some(input.into());
            self
        }
        /// <p>The MD5 hash of the request body.</p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn set_content_md5(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_md5 = input;
            self
        }
        /// <p>Set this parameter to true to confirm that you want to remove your permissions to change this bucket policy in the future.</p>
        pub fn confirm_remove_self_bucket_access(mut self, input: bool) -> Self {
            self.confirm_remove_self_bucket_access = Some(input);
            self
        }
        /// <p>Set this parameter to true to confirm that you want to remove your permissions to change this bucket policy in the future.</p>
        pub fn set_confirm_remove_self_bucket_access(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.confirm_remove_self_bucket_access = input;
            self
        }
        /// <p>The bucket policy as a JSON document.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The bucket policy as a JSON document.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`PutBucketPolicyInput`](crate::input::PutBucketPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutBucketPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutBucketPolicyInput {
                bucket: self.bucket,
                content_md5: self.content_md5,
                confirm_remove_self_bucket_access: self
                    .confirm_remove_self_bucket_access
                    .unwrap_or_default(),
                policy: self.policy,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type PutBucketPolicyInputOperationOutputAlias = crate::operation::PutBucketPolicy;
#[doc(hidden)]
pub type PutBucketPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutBucketPolicyInput {
    /// Consumes the builder and constructs an Operation<[`PutBucketPolicy`](crate::operation::PutBucketPolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutBucketPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutBucketPolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_153 = &_input.bucket;
                let input_153 = input_153.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_153, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::PutBucketPolicyInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("policy");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutBucketPolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_put_bucket_policy(input, builder)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "text/plain",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_put_bucket_policy_input(self.policy)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request = request.augment(|mut req, _| {
            let data = req
                .body()
                .bytes()
                .expect("checksum can only be computed for non-streaming operations");
            let checksum = md5::compute(data);
            req.headers_mut().insert(
                http::header::HeaderName::from_static("content-md5"),
                aws_smithy_types::base64::encode(&checksum[..])
                    .parse()
                    .expect("checksum is valid header value"),
            );
            Result::<_, aws_smithy_http::operation::BuildError>::Ok(req)
        })?;
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutBucketPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutBucketPolicy",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutBucketPolicyInput`](crate::input::PutBucketPolicyInput)
    pub fn builder() -> crate::input::put_bucket_policy_input::Builder {
        crate::input::put_bucket_policy_input::Builder::default()
    }
}

/// See [`PutBucketReplicationInput`](crate::input::PutBucketReplicationInput)
pub mod put_bucket_replication_input {
    /// A builder for [`PutBucketReplicationInput`](crate::input::PutBucketReplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) content_md5: std::option::Option<std::string::String>,
        pub(crate) replication_configuration:
            std::option::Option<crate::model::ReplicationConfiguration>,
        pub(crate) token: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The base64-encoded 128-bit MD5 digest of the data. You must use this header as a message integrity check to verify that the request body was not corrupted in transit. For more information, see <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864</a>.</p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn content_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_md5 = Some(input.into());
            self
        }
        /// <p>The base64-encoded 128-bit MD5 digest of the data. You must use this header as a message integrity check to verify that the request body was not corrupted in transit. For more information, see <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864</a>.</p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn set_content_md5(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_md5 = input;
            self
        }
        /// <p>A container for replication rules. You can add up to 1,000 rules. The maximum size of a replication configuration is 2 MB.</p>
        pub fn replication_configuration(
            mut self,
            input: crate::model::ReplicationConfiguration,
        ) -> Self {
            self.replication_configuration = Some(input);
            self
        }
        /// <p>A container for replication rules. You can add up to 1,000 rules. The maximum size of a replication configuration is 2 MB.</p>
        pub fn set_replication_configuration(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfiguration>,
        ) -> Self {
            self.replication_configuration = input;
            self
        }
        /// <p>A token to allow Object Lock to be enabled for an existing bucket.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.token = Some(input.into());
            self
        }
        /// <p>A token to allow Object Lock to be enabled for an existing bucket.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`PutBucketReplicationInput`](crate::input::PutBucketReplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutBucketReplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutBucketReplicationInput {
                bucket: self.bucket,
                content_md5: self.content_md5,
                replication_configuration: self.replication_configuration,
                token: self.token,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type PutBucketReplicationInputOperationOutputAlias = crate::operation::PutBucketReplication;
#[doc(hidden)]
pub type PutBucketReplicationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutBucketReplicationInput {
    /// Consumes the builder and constructs an Operation<[`PutBucketReplication`](crate::operation::PutBucketReplication)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutBucketReplication,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutBucketReplicationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_154 = &_input.bucket;
                let input_154 = input_154.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_154, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::PutBucketReplicationInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("replication");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutBucketReplicationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_put_bucket_replication(input, builder)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_put_bucket_replication_input(
                &self.replication_configuration,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request = request.augment(|mut req, _| {
            let data = req
                .body()
                .bytes()
                .expect("checksum can only be computed for non-streaming operations");
            let checksum = md5::compute(data);
            req.headers_mut().insert(
                http::header::HeaderName::from_static("content-md5"),
                aws_smithy_types::base64::encode(&checksum[..])
                    .parse()
                    .expect("checksum is valid header value"),
            );
            Result::<_, aws_smithy_http::operation::BuildError>::Ok(req)
        })?;
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutBucketReplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutBucketReplication",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutBucketReplicationInput`](crate::input::PutBucketReplicationInput)
    pub fn builder() -> crate::input::put_bucket_replication_input::Builder {
        crate::input::put_bucket_replication_input::Builder::default()
    }
}

/// See [`PutBucketRequestPaymentInput`](crate::input::PutBucketRequestPaymentInput)
pub mod put_bucket_request_payment_input {
    /// A builder for [`PutBucketRequestPaymentInput`](crate::input::PutBucketRequestPaymentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) content_md5: std::option::Option<std::string::String>,
        pub(crate) request_payment_configuration:
            std::option::Option<crate::model::RequestPaymentConfiguration>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket name.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The base64-encoded 128-bit MD5 digest of the data. You must use this header as a message integrity check to verify that the request body was not corrupted in transit. For more information, see <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864</a>.</p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn content_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_md5 = Some(input.into());
            self
        }
        /// <p>The base64-encoded 128-bit MD5 digest of the data. You must use this header as a message integrity check to verify that the request body was not corrupted in transit. For more information, see <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864</a>.</p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn set_content_md5(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_md5 = input;
            self
        }
        /// <p>Container for Payer.</p>
        pub fn request_payment_configuration(
            mut self,
            input: crate::model::RequestPaymentConfiguration,
        ) -> Self {
            self.request_payment_configuration = Some(input);
            self
        }
        /// <p>Container for Payer.</p>
        pub fn set_request_payment_configuration(
            mut self,
            input: std::option::Option<crate::model::RequestPaymentConfiguration>,
        ) -> Self {
            self.request_payment_configuration = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`PutBucketRequestPaymentInput`](crate::input::PutBucketRequestPaymentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutBucketRequestPaymentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutBucketRequestPaymentInput {
                bucket: self.bucket,
                content_md5: self.content_md5,
                request_payment_configuration: self.request_payment_configuration,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type PutBucketRequestPaymentInputOperationOutputAlias =
    crate::operation::PutBucketRequestPayment;
#[doc(hidden)]
pub type PutBucketRequestPaymentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutBucketRequestPaymentInput {
    /// Consumes the builder and constructs an Operation<[`PutBucketRequestPayment`](crate::operation::PutBucketRequestPayment)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutBucketRequestPayment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutBucketRequestPaymentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_155 = &_input.bucket;
                let input_155 = input_155.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_155, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::PutBucketRequestPaymentInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("requestPayment");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutBucketRequestPaymentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_put_bucket_request_payment(input, builder)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_put_bucket_request_payment_input(
                &self.request_payment_configuration,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request = request.augment(|mut req, _| {
            let data = req
                .body()
                .bytes()
                .expect("checksum can only be computed for non-streaming operations");
            let checksum = md5::compute(data);
            req.headers_mut().insert(
                http::header::HeaderName::from_static("content-md5"),
                aws_smithy_types::base64::encode(&checksum[..])
                    .parse()
                    .expect("checksum is valid header value"),
            );
            Result::<_, aws_smithy_http::operation::BuildError>::Ok(req)
        })?;
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutBucketRequestPayment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutBucketRequestPayment",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutBucketRequestPaymentInput`](crate::input::PutBucketRequestPaymentInput)
    pub fn builder() -> crate::input::put_bucket_request_payment_input::Builder {
        crate::input::put_bucket_request_payment_input::Builder::default()
    }
}

/// See [`PutBucketTaggingInput`](crate::input::PutBucketTaggingInput)
pub mod put_bucket_tagging_input {
    /// A builder for [`PutBucketTaggingInput`](crate::input::PutBucketTaggingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) content_md5: std::option::Option<std::string::String>,
        pub(crate) tagging: std::option::Option<crate::model::Tagging>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket name.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The base64-encoded 128-bit MD5 digest of the data. You must use this header as a message integrity check to verify that the request body was not corrupted in transit. For more information, see <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864</a>.</p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn content_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_md5 = Some(input.into());
            self
        }
        /// <p>The base64-encoded 128-bit MD5 digest of the data. You must use this header as a message integrity check to verify that the request body was not corrupted in transit. For more information, see <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864</a>.</p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn set_content_md5(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_md5 = input;
            self
        }
        /// <p>Container for the <code>TagSet</code> and <code>Tag</code> elements.</p>
        pub fn tagging(mut self, input: crate::model::Tagging) -> Self {
            self.tagging = Some(input);
            self
        }
        /// <p>Container for the <code>TagSet</code> and <code>Tag</code> elements.</p>
        pub fn set_tagging(mut self, input: std::option::Option<crate::model::Tagging>) -> Self {
            self.tagging = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`PutBucketTaggingInput`](crate::input::PutBucketTaggingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutBucketTaggingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutBucketTaggingInput {
                bucket: self.bucket,
                content_md5: self.content_md5,
                tagging: self.tagging,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type PutBucketTaggingInputOperationOutputAlias = crate::operation::PutBucketTagging;
#[doc(hidden)]
pub type PutBucketTaggingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutBucketTaggingInput {
    /// Consumes the builder and constructs an Operation<[`PutBucketTagging`](crate::operation::PutBucketTagging)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutBucketTagging,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutBucketTaggingInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_156 = &_input.bucket;
                let input_156 = input_156.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_156, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::PutBucketTaggingInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("tagging");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutBucketTaggingInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_put_bucket_tagging(input, builder)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_put_bucket_tagging_input(&self.tagging)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request = request.augment(|mut req, _| {
            let data = req
                .body()
                .bytes()
                .expect("checksum can only be computed for non-streaming operations");
            let checksum = md5::compute(data);
            req.headers_mut().insert(
                http::header::HeaderName::from_static("content-md5"),
                aws_smithy_types::base64::encode(&checksum[..])
                    .parse()
                    .expect("checksum is valid header value"),
            );
            Result::<_, aws_smithy_http::operation::BuildError>::Ok(req)
        })?;
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutBucketTagging::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutBucketTagging",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutBucketTaggingInput`](crate::input::PutBucketTaggingInput)
    pub fn builder() -> crate::input::put_bucket_tagging_input::Builder {
        crate::input::put_bucket_tagging_input::Builder::default()
    }
}

/// See [`PutBucketVersioningInput`](crate::input::PutBucketVersioningInput)
pub mod put_bucket_versioning_input {
    /// A builder for [`PutBucketVersioningInput`](crate::input::PutBucketVersioningInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) content_md5: std::option::Option<std::string::String>,
        pub(crate) mfa: std::option::Option<std::string::String>,
        pub(crate) versioning_configuration:
            std::option::Option<crate::model::VersioningConfiguration>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket name.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>&gt;The base64-encoded 128-bit MD5 digest of the data. You must use this header as a message integrity check to verify that the request body was not corrupted in transit. For more information, see <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864</a>.</p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn content_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_md5 = Some(input.into());
            self
        }
        /// <p>&gt;The base64-encoded 128-bit MD5 digest of the data. You must use this header as a message integrity check to verify that the request body was not corrupted in transit. For more information, see <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864</a>.</p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn set_content_md5(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_md5 = input;
            self
        }
        /// <p>The concatenation of the authentication device's serial number, a space, and the value that is displayed on your authentication device.</p>
        pub fn mfa(mut self, input: impl Into<std::string::String>) -> Self {
            self.mfa = Some(input.into());
            self
        }
        /// <p>The concatenation of the authentication device's serial number, a space, and the value that is displayed on your authentication device.</p>
        pub fn set_mfa(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mfa = input;
            self
        }
        /// <p>Container for setting the versioning state.</p>
        pub fn versioning_configuration(
            mut self,
            input: crate::model::VersioningConfiguration,
        ) -> Self {
            self.versioning_configuration = Some(input);
            self
        }
        /// <p>Container for setting the versioning state.</p>
        pub fn set_versioning_configuration(
            mut self,
            input: std::option::Option<crate::model::VersioningConfiguration>,
        ) -> Self {
            self.versioning_configuration = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`PutBucketVersioningInput`](crate::input::PutBucketVersioningInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutBucketVersioningInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutBucketVersioningInput {
                bucket: self.bucket,
                content_md5: self.content_md5,
                mfa: self.mfa,
                versioning_configuration: self.versioning_configuration,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type PutBucketVersioningInputOperationOutputAlias = crate::operation::PutBucketVersioning;
#[doc(hidden)]
pub type PutBucketVersioningInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutBucketVersioningInput {
    /// Consumes the builder and constructs an Operation<[`PutBucketVersioning`](crate::operation::PutBucketVersioning)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutBucketVersioning,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutBucketVersioningInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_157 = &_input.bucket;
                let input_157 = input_157.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_157, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::PutBucketVersioningInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("versioning");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutBucketVersioningInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_put_bucket_versioning(input, builder)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_put_bucket_versioning_input(
                &self.versioning_configuration,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request = request.augment(|mut req, _| {
            let data = req
                .body()
                .bytes()
                .expect("checksum can only be computed for non-streaming operations");
            let checksum = md5::compute(data);
            req.headers_mut().insert(
                http::header::HeaderName::from_static("content-md5"),
                aws_smithy_types::base64::encode(&checksum[..])
                    .parse()
                    .expect("checksum is valid header value"),
            );
            Result::<_, aws_smithy_http::operation::BuildError>::Ok(req)
        })?;
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutBucketVersioning::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutBucketVersioning",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutBucketVersioningInput`](crate::input::PutBucketVersioningInput)
    pub fn builder() -> crate::input::put_bucket_versioning_input::Builder {
        crate::input::put_bucket_versioning_input::Builder::default()
    }
}

/// See [`PutBucketWebsiteInput`](crate::input::PutBucketWebsiteInput)
pub mod put_bucket_website_input {
    /// A builder for [`PutBucketWebsiteInput`](crate::input::PutBucketWebsiteInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) content_md5: std::option::Option<std::string::String>,
        pub(crate) website_configuration: std::option::Option<crate::model::WebsiteConfiguration>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket name.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The base64-encoded 128-bit MD5 digest of the data. You must use this header as a message integrity check to verify that the request body was not corrupted in transit. For more information, see <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864</a>.</p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn content_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_md5 = Some(input.into());
            self
        }
        /// <p>The base64-encoded 128-bit MD5 digest of the data. You must use this header as a message integrity check to verify that the request body was not corrupted in transit. For more information, see <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864</a>.</p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn set_content_md5(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_md5 = input;
            self
        }
        /// <p>Container for the request.</p>
        pub fn website_configuration(mut self, input: crate::model::WebsiteConfiguration) -> Self {
            self.website_configuration = Some(input);
            self
        }
        /// <p>Container for the request.</p>
        pub fn set_website_configuration(
            mut self,
            input: std::option::Option<crate::model::WebsiteConfiguration>,
        ) -> Self {
            self.website_configuration = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`PutBucketWebsiteInput`](crate::input::PutBucketWebsiteInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutBucketWebsiteInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutBucketWebsiteInput {
                bucket: self.bucket,
                content_md5: self.content_md5,
                website_configuration: self.website_configuration,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type PutBucketWebsiteInputOperationOutputAlias = crate::operation::PutBucketWebsite;
#[doc(hidden)]
pub type PutBucketWebsiteInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutBucketWebsiteInput {
    /// Consumes the builder and constructs an Operation<[`PutBucketWebsite`](crate::operation::PutBucketWebsite)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutBucketWebsite,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutBucketWebsiteInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_158 = &_input.bucket;
                let input_158 = input_158.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_158, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::PutBucketWebsiteInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("website");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutBucketWebsiteInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_put_bucket_website(input, builder)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_put_bucket_website_input(
                &self.website_configuration,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request = request.augment(|mut req, _| {
            let data = req
                .body()
                .bytes()
                .expect("checksum can only be computed for non-streaming operations");
            let checksum = md5::compute(data);
            req.headers_mut().insert(
                http::header::HeaderName::from_static("content-md5"),
                aws_smithy_types::base64::encode(&checksum[..])
                    .parse()
                    .expect("checksum is valid header value"),
            );
            Result::<_, aws_smithy_http::operation::BuildError>::Ok(req)
        })?;
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutBucketWebsite::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutBucketWebsite",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutBucketWebsiteInput`](crate::input::PutBucketWebsiteInput)
    pub fn builder() -> crate::input::put_bucket_website_input::Builder {
        crate::input::put_bucket_website_input::Builder::default()
    }
}

/// See [`PutObjectInput`](crate::input::PutObjectInput)
pub mod put_object_input {
    /// A builder for [`PutObjectInput`](crate::input::PutObjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) acl: std::option::Option<crate::model::ObjectCannedAcl>,
        pub(crate) body: std::option::Option<aws_smithy_http::byte_stream::ByteStream>,
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) cache_control: std::option::Option<std::string::String>,
        pub(crate) content_disposition: std::option::Option<std::string::String>,
        pub(crate) content_encoding: std::option::Option<std::string::String>,
        pub(crate) content_language: std::option::Option<std::string::String>,
        pub(crate) content_length: std::option::Option<i64>,
        pub(crate) content_md5: std::option::Option<std::string::String>,
        pub(crate) content_type: std::option::Option<std::string::String>,
        pub(crate) expires: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) grant_full_control: std::option::Option<std::string::String>,
        pub(crate) grant_read: std::option::Option<std::string::String>,
        pub(crate) grant_read_acp: std::option::Option<std::string::String>,
        pub(crate) grant_write_acp: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) metadata: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) server_side_encryption: std::option::Option<crate::model::ServerSideEncryption>,
        pub(crate) storage_class: std::option::Option<crate::model::StorageClass>,
        pub(crate) website_redirect_location: std::option::Option<std::string::String>,
        pub(crate) sse_customer_algorithm: std::option::Option<std::string::String>,
        pub(crate) sse_customer_key: std::option::Option<std::string::String>,
        pub(crate) sse_customer_key_md5: std::option::Option<std::string::String>,
        pub(crate) ssekms_key_id: std::option::Option<std::string::String>,
        pub(crate) ssekms_encryption_context: std::option::Option<std::string::String>,
        pub(crate) bucket_key_enabled: std::option::Option<bool>,
        pub(crate) request_payer: std::option::Option<crate::model::RequestPayer>,
        pub(crate) tagging: std::option::Option<std::string::String>,
        pub(crate) object_lock_mode: std::option::Option<crate::model::ObjectLockMode>,
        pub(crate) object_lock_retain_until_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) object_lock_legal_hold_status:
            std::option::Option<crate::model::ObjectLockLegalHoldStatus>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The canned ACL to apply to the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL">Canned ACL</a>.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn acl(mut self, input: crate::model::ObjectCannedAcl) -> Self {
            self.acl = Some(input);
            self
        }
        /// <p>The canned ACL to apply to the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL">Canned ACL</a>.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn set_acl(
            mut self,
            input: std::option::Option<crate::model::ObjectCannedAcl>,
        ) -> Self {
            self.acl = input;
            self
        }
        /// <p>Object data.</p>
        pub fn body(mut self, input: aws_smithy_http::byte_stream::ByteStream) -> Self {
            self.body = Some(input);
            self
        }
        /// <p>Object data.</p>
        pub fn set_body(
            mut self,
            input: std::option::Option<aws_smithy_http::byte_stream::ByteStream>,
        ) -> Self {
            self.body = input;
            self
        }
        /// <p>The bucket name to which the PUT action was initiated. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name to which the PUT action was initiated. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p> Can be used to specify caching behavior along the request/reply chain. For more information, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9">http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9</a>.</p>
        pub fn cache_control(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_control = Some(input.into());
            self
        }
        /// <p> Can be used to specify caching behavior along the request/reply chain. For more information, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9">http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9</a>.</p>
        pub fn set_cache_control(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_control = input;
            self
        }
        /// <p>Specifies presentational information for the object. For more information, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.5.1">http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.5.1</a>.</p>
        pub fn content_disposition(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_disposition = Some(input.into());
            self
        }
        /// <p>Specifies presentational information for the object. For more information, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.5.1">http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.5.1</a>.</p>
        pub fn set_content_disposition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.content_disposition = input;
            self
        }
        /// <p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. For more information, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.11">http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.11</a>.</p>
        pub fn content_encoding(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_encoding = Some(input.into());
            self
        }
        /// <p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. For more information, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.11">http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.11</a>.</p>
        pub fn set_content_encoding(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.content_encoding = input;
            self
        }
        /// <p>The language the content is in.</p>
        pub fn content_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_language = Some(input.into());
            self
        }
        /// <p>The language the content is in.</p>
        pub fn set_content_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.content_language = input;
            self
        }
        /// <p>Size of the body in bytes. This parameter is useful when the size of the body cannot be determined automatically. For more information, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.13">http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.13</a>.</p>
        pub fn content_length(mut self, input: i64) -> Self {
            self.content_length = Some(input);
            self
        }
        /// <p>Size of the body in bytes. This parameter is useful when the size of the body cannot be determined automatically. For more information, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.13">http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.13</a>.</p>
        pub fn set_content_length(mut self, input: std::option::Option<i64>) -> Self {
            self.content_length = input;
            self
        }
        /// <p>The base64-encoded 128-bit MD5 digest of the message (without the headers) according to RFC 1864. This header can be used as a message integrity check to verify that the data is the same data that was originally sent. Although it is optional, we recommend using the Content-MD5 mechanism as an end-to-end integrity check. For more information about REST request authentication, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html">REST Authentication</a>.</p>
        pub fn content_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_md5 = Some(input.into());
            self
        }
        /// <p>The base64-encoded 128-bit MD5 digest of the message (without the headers) according to RFC 1864. This header can be used as a message integrity check to verify that the data is the same data that was originally sent. Although it is optional, we recommend using the Content-MD5 mechanism as an end-to-end integrity check. For more information about REST request authentication, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html">REST Authentication</a>.</p>
        pub fn set_content_md5(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_md5 = input;
            self
        }
        /// <p>A standard MIME type describing the format of the contents. For more information, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17">http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17</a>.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>A standard MIME type describing the format of the contents. For more information, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17">http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17</a>.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// <p>The date and time at which the object is no longer cacheable. For more information, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.21">http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.21</a>.</p>
        pub fn expires(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.expires = Some(input);
            self
        }
        /// <p>The date and time at which the object is no longer cacheable. For more information, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.21">http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.21</a>.</p>
        pub fn set_expires(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.expires = input;
            self
        }
        /// <p>Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn grant_full_control(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_full_control = Some(input.into());
            self
        }
        /// <p>Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn set_grant_full_control(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.grant_full_control = input;
            self
        }
        /// <p>Allows grantee to read the object data and its metadata.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn grant_read(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_read = Some(input.into());
            self
        }
        /// <p>Allows grantee to read the object data and its metadata.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn set_grant_read(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.grant_read = input;
            self
        }
        /// <p>Allows grantee to read the object ACL.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn grant_read_acp(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_read_acp = Some(input.into());
            self
        }
        /// <p>Allows grantee to read the object ACL.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn set_grant_read_acp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.grant_read_acp = input;
            self
        }
        /// <p>Allows grantee to write the ACL for the applicable object.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn grant_write_acp(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_write_acp = Some(input.into());
            self
        }
        /// <p>Allows grantee to write the ACL for the applicable object.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn set_grant_write_acp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.grant_write_acp = input;
            self
        }
        /// <p>Object key for which the PUT action was initiated.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>Object key for which the PUT action was initiated.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// Adds a key-value pair to `metadata`.
        ///
        /// To override the contents of this collection use [`set_metadata`](Self::set_metadata).
        ///
        /// <p>A map of metadata to store with the object in S3.</p>
        pub fn metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.metadata = Some(hash_map);
            self
        }
        /// <p>A map of metadata to store with the object in S3.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// <p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example, AES256, aws:kms).</p>
        pub fn server_side_encryption(mut self, input: crate::model::ServerSideEncryption) -> Self {
            self.server_side_encryption = Some(input);
            self
        }
        /// <p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example, AES256, aws:kms).</p>
        pub fn set_server_side_encryption(
            mut self,
            input: std::option::Option<crate::model::ServerSideEncryption>,
        ) -> Self {
            self.server_side_encryption = input;
            self
        }
        /// <p>By default, Amazon S3 uses the STANDARD Storage Class to store newly created objects. The STANDARD storage class provides high durability and high availability. Depending on performance needs, you can specify a different Storage Class. Amazon S3 on Outposts only uses the OUTPOSTS Storage Class. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn storage_class(mut self, input: crate::model::StorageClass) -> Self {
            self.storage_class = Some(input);
            self
        }
        /// <p>By default, Amazon S3 uses the STANDARD Storage Class to store newly created objects. The STANDARD storage class provides high durability and high availability. Depending on performance needs, you can specify a different Storage Class. Amazon S3 on Outposts only uses the OUTPOSTS Storage Class. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_storage_class(
            mut self,
            input: std::option::Option<crate::model::StorageClass>,
        ) -> Self {
            self.storage_class = input;
            self
        }
        /// <p>If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata. For information about object metadata, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html">Object Key and Metadata</a>.</p>
        /// <p>In the following example, the request header sets the redirect to an object (anotherPage.html) in the same bucket:</p>
        /// <p> <code>x-amz-website-redirect-location: /anotherPage.html</code> </p>
        /// <p>In the following example, the request header sets the object redirect to another website:</p>
        /// <p> <code>x-amz-website-redirect-location: http://www.example.com/</code> </p>
        /// <p>For more information about website hosting in Amazon S3, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html">Hosting Websites on Amazon S3</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html">How to Configure Website Page Redirects</a>. </p>
        pub fn website_redirect_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.website_redirect_location = Some(input.into());
            self
        }
        /// <p>If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata. For information about object metadata, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html">Object Key and Metadata</a>.</p>
        /// <p>In the following example, the request header sets the redirect to an object (anotherPage.html) in the same bucket:</p>
        /// <p> <code>x-amz-website-redirect-location: /anotherPage.html</code> </p>
        /// <p>In the following example, the request header sets the object redirect to another website:</p>
        /// <p> <code>x-amz-website-redirect-location: http://www.example.com/</code> </p>
        /// <p>For more information about website hosting in Amazon S3, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html">Hosting Websites on Amazon S3</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html">How to Configure Website Page Redirects</a>. </p>
        pub fn set_website_redirect_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.website_redirect_location = input;
            self
        }
        /// <p>Specifies the algorithm to use to when encrypting the object (for example, AES256).</p>
        pub fn sse_customer_algorithm(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_customer_algorithm = Some(input.into());
            self
        }
        /// <p>Specifies the algorithm to use to when encrypting the object (for example, AES256).</p>
        pub fn set_sse_customer_algorithm(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_customer_algorithm = input;
            self
        }
        /// <p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p>
        pub fn sse_customer_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_customer_key = Some(input.into());
            self
        }
        /// <p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p>
        pub fn set_sse_customer_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_customer_key = input;
            self
        }
        /// <p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>
        pub fn sse_customer_key_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_customer_key_md5 = Some(input.into());
            self
        }
        /// <p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>
        pub fn set_sse_customer_key_md5(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_customer_key_md5 = input;
            self
        }
        /// <p>If <code>x-amz-server-side-encryption</code> is present and has the value of <code>aws:kms</code>, this header specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetrical customer managed key that was used for the object. If you specify <code>x-amz-server-side-encryption:aws:kms</code>, but do not provide<code> x-amz-server-side-encryption-aws-kms-key-id</code>, Amazon S3 uses the Amazon Web Services managed key to protect the data. If the KMS key does not exist in the same account issuing the command, you must use the full ARN and not just the ID. </p>
        pub fn ssekms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssekms_key_id = Some(input.into());
            self
        }
        /// <p>If <code>x-amz-server-side-encryption</code> is present and has the value of <code>aws:kms</code>, this header specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetrical customer managed key that was used for the object. If you specify <code>x-amz-server-side-encryption:aws:kms</code>, but do not provide<code> x-amz-server-side-encryption-aws-kms-key-id</code>, Amazon S3 uses the Amazon Web Services managed key to protect the data. If the KMS key does not exist in the same account issuing the command, you must use the full ARN and not just the ID. </p>
        pub fn set_ssekms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssekms_key_id = input;
            self
        }
        /// <p>Specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.</p>
        pub fn ssekms_encryption_context(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssekms_encryption_context = Some(input.into());
            self
        }
        /// <p>Specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.</p>
        pub fn set_ssekms_encryption_context(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssekms_encryption_context = input;
            self
        }
        /// <p>Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption with server-side encryption using AWS KMS (SSE-KMS). Setting this header to <code>true</code> causes Amazon S3 to use an S3 Bucket Key for object encryption with SSE-KMS.</p>
        /// <p>Specifying this header with a PUT action doesn’t affect bucket-level settings for S3 Bucket Key.</p>
        pub fn bucket_key_enabled(mut self, input: bool) -> Self {
            self.bucket_key_enabled = Some(input);
            self
        }
        /// <p>Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption with server-side encryption using AWS KMS (SSE-KMS). Setting this header to <code>true</code> causes Amazon S3 to use an S3 Bucket Key for object encryption with SSE-KMS.</p>
        /// <p>Specifying this header with a PUT action doesn’t affect bucket-level settings for S3 Bucket Key.</p>
        pub fn set_bucket_key_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.bucket_key_enabled = input;
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.request_payer = Some(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.request_payer = input;
            self
        }
        /// <p>The tag-set for the object. The tag-set must be encoded as URL Query parameters. (For example, "Key1=Value1")</p>
        pub fn tagging(mut self, input: impl Into<std::string::String>) -> Self {
            self.tagging = Some(input.into());
            self
        }
        /// <p>The tag-set for the object. The tag-set must be encoded as URL Query parameters. (For example, "Key1=Value1")</p>
        pub fn set_tagging(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tagging = input;
            self
        }
        /// <p>The Object Lock mode that you want to apply to this object.</p>
        pub fn object_lock_mode(mut self, input: crate::model::ObjectLockMode) -> Self {
            self.object_lock_mode = Some(input);
            self
        }
        /// <p>The Object Lock mode that you want to apply to this object.</p>
        pub fn set_object_lock_mode(
            mut self,
            input: std::option::Option<crate::model::ObjectLockMode>,
        ) -> Self {
            self.object_lock_mode = input;
            self
        }
        /// <p>The date and time when you want this object's Object Lock to expire. Must be formatted as a timestamp parameter.</p>
        pub fn object_lock_retain_until_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.object_lock_retain_until_date = Some(input);
            self
        }
        /// <p>The date and time when you want this object's Object Lock to expire. Must be formatted as a timestamp parameter.</p>
        pub fn set_object_lock_retain_until_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.object_lock_retain_until_date = input;
            self
        }
        /// <p>Specifies whether a legal hold will be applied to this object. For more information about S3 Object Lock, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Object Lock</a>.</p>
        pub fn object_lock_legal_hold_status(
            mut self,
            input: crate::model::ObjectLockLegalHoldStatus,
        ) -> Self {
            self.object_lock_legal_hold_status = Some(input);
            self
        }
        /// <p>Specifies whether a legal hold will be applied to this object. For more information about S3 Object Lock, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Object Lock</a>.</p>
        pub fn set_object_lock_legal_hold_status(
            mut self,
            input: std::option::Option<crate::model::ObjectLockLegalHoldStatus>,
        ) -> Self {
            self.object_lock_legal_hold_status = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`PutObjectInput`](crate::input::PutObjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::PutObjectInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::PutObjectInput {
                acl: self.acl,
                body: self.body.unwrap_or_default(),
                bucket: self.bucket,
                cache_control: self.cache_control,
                content_disposition: self.content_disposition,
                content_encoding: self.content_encoding,
                content_language: self.content_language,
                content_length: self.content_length.unwrap_or_default(),
                content_md5: self.content_md5,
                content_type: self.content_type,
                expires: self.expires,
                grant_full_control: self.grant_full_control,
                grant_read: self.grant_read,
                grant_read_acp: self.grant_read_acp,
                grant_write_acp: self.grant_write_acp,
                key: self.key,
                metadata: self.metadata,
                server_side_encryption: self.server_side_encryption,
                storage_class: self.storage_class,
                website_redirect_location: self.website_redirect_location,
                sse_customer_algorithm: self.sse_customer_algorithm,
                sse_customer_key: self.sse_customer_key,
                sse_customer_key_md5: self.sse_customer_key_md5,
                ssekms_key_id: self.ssekms_key_id,
                ssekms_encryption_context: self.ssekms_encryption_context,
                bucket_key_enabled: self.bucket_key_enabled.unwrap_or_default(),
                request_payer: self.request_payer,
                tagging: self.tagging,
                object_lock_mode: self.object_lock_mode,
                object_lock_retain_until_date: self.object_lock_retain_until_date,
                object_lock_legal_hold_status: self.object_lock_legal_hold_status,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type PutObjectInputOperationOutputAlias = crate::operation::PutObject;
#[doc(hidden)]
pub type PutObjectInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutObjectInput {
    /// Consumes the builder and constructs an Operation<[`PutObject`](crate::operation::PutObject)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    async fn _make_presigned_operation(
        self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutObject,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutObjectInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_159 = &_input.bucket;
                let input_159 = input_159.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_159, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                let input_160 = &_input.key;
                let input_160 = input_160.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    },
                )?;
                let key = aws_smithy_http::label::fmt_string(input_160, true);
                if key.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}/{Key}", Bucket = bucket, Key = key)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::PutObjectInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_kv("x-id", "PutObject");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutObjectInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_put_object(input, builder)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_put_object_input(self.body)?.into_inner(),
        );
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::PutObject::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new("PutObject", "s3"));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    ///
    /// Creates a presigned request for this operation.
    ///
    /// The credentials provider from the `config` will be used to generate the request's signature.
    /// The `presigning_config` provides additional presigning-specific config values, such as the
    /// amount of time the request should be valid for after creation.
    ///
    /// Presigned requests can be given to other users or applications to access a resource or perform
    /// an operation without having access to the AWS security credentials.
    ///
    pub async fn presigned(
        self,
        config: &crate::config::Config,
        presigning_config: crate::presigning::config::PresigningConfig,
    ) -> Result<
        crate::presigning::request::PresignedRequest,
        aws_smithy_http::result::SdkError<crate::error::PutObjectError>,
    > {
        let (mut request, _) = self
            ._make_presigned_operation(config)
            .await
            .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
            .into_request_response();
        {
            // Change signature type to query params and wire up presigning config
            let mut props = request.properties_mut();
            props.insert(presigning_config.start_time());
            props.insert(aws_sigv4::http_request::SignableBody::UnsignedPayload);
            let mut config = props
                .get_mut::<aws_sig_auth::signer::OperationSigningConfig>()
                .expect("signing config added by make_operation()");
            config.signature_type = aws_sig_auth::signer::HttpSignatureType::HttpRequestQueryParams;
            config.expires_in = Some(presigning_config.expires());
        }
        let middleware = crate::middleware::DefaultMiddleware::default();
        let mut svc = tower::builder::ServiceBuilder::new()
            .layer(&middleware)
            .service(crate::presigning::service::PresignedRequestService::new());

        use tower::{Service, ServiceExt};
        Ok(svc.ready().await?.call(request).await?)
    }
    /// Consumes the builder and constructs an Operation<[`PutObject`](crate::operation::PutObject)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutObject,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutObjectInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_161 = &_input.bucket;
                let input_161 = input_161.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_161, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                let input_162 = &_input.key;
                let input_162 = input_162.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    },
                )?;
                let key = aws_smithy_http::label::fmt_string(input_162, true);
                if key.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}/{Key}", Bucket = bucket, Key = key)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::PutObjectInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_kv("x-id", "PutObject");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutObjectInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_put_object(input, builder)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/octet-stream",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_put_object_input(self.body)?.into_inner(),
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::PutObject::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new("PutObject", "s3"));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutObjectInput`](crate::input::PutObjectInput)
    pub fn builder() -> crate::input::put_object_input::Builder {
        crate::input::put_object_input::Builder::default()
    }
}

/// See [`PutObjectAclInput`](crate::input::PutObjectAclInput)
pub mod put_object_acl_input {
    /// A builder for [`PutObjectAclInput`](crate::input::PutObjectAclInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) acl: std::option::Option<crate::model::ObjectCannedAcl>,
        pub(crate) access_control_policy: std::option::Option<crate::model::AccessControlPolicy>,
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) content_md5: std::option::Option<std::string::String>,
        pub(crate) grant_full_control: std::option::Option<std::string::String>,
        pub(crate) grant_read: std::option::Option<std::string::String>,
        pub(crate) grant_read_acp: std::option::Option<std::string::String>,
        pub(crate) grant_write: std::option::Option<std::string::String>,
        pub(crate) grant_write_acp: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) request_payer: std::option::Option<crate::model::RequestPayer>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The canned ACL to apply to the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL">Canned ACL</a>.</p>
        pub fn acl(mut self, input: crate::model::ObjectCannedAcl) -> Self {
            self.acl = Some(input);
            self
        }
        /// <p>The canned ACL to apply to the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL">Canned ACL</a>.</p>
        pub fn set_acl(
            mut self,
            input: std::option::Option<crate::model::ObjectCannedAcl>,
        ) -> Self {
            self.acl = input;
            self
        }
        /// <p>Contains the elements that set the ACL permissions for an object per grantee.</p>
        pub fn access_control_policy(mut self, input: crate::model::AccessControlPolicy) -> Self {
            self.access_control_policy = Some(input);
            self
        }
        /// <p>Contains the elements that set the ACL permissions for an object per grantee.</p>
        pub fn set_access_control_policy(
            mut self,
            input: std::option::Option<crate::model::AccessControlPolicy>,
        ) -> Self {
            self.access_control_policy = input;
            self
        }
        /// <p>The bucket name that contains the object to which you want to attach the ACL. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name that contains the object to which you want to attach the ACL. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The base64-encoded 128-bit MD5 digest of the data. This header must be used as a message integrity check to verify that the request body was not corrupted in transit. For more information, go to <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864.&gt;</a> </p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn content_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_md5 = Some(input.into());
            self
        }
        /// <p>The base64-encoded 128-bit MD5 digest of the data. This header must be used as a message integrity check to verify that the request body was not corrupted in transit. For more information, go to <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864.&gt;</a> </p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn set_content_md5(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_md5 = input;
            self
        }
        /// <p>Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn grant_full_control(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_full_control = Some(input.into());
            self
        }
        /// <p>Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn set_grant_full_control(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.grant_full_control = input;
            self
        }
        /// <p>Allows grantee to list the objects in the bucket.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn grant_read(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_read = Some(input.into());
            self
        }
        /// <p>Allows grantee to list the objects in the bucket.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn set_grant_read(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.grant_read = input;
            self
        }
        /// <p>Allows grantee to read the bucket ACL.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn grant_read_acp(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_read_acp = Some(input.into());
            self
        }
        /// <p>Allows grantee to read the bucket ACL.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn set_grant_read_acp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.grant_read_acp = input;
            self
        }
        /// <p>Allows grantee to create new objects in the bucket.</p>
        /// <p>For the bucket and object owners of existing objects, also allows deletions and overwrites of those objects.</p>
        pub fn grant_write(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_write = Some(input.into());
            self
        }
        /// <p>Allows grantee to create new objects in the bucket.</p>
        /// <p>For the bucket and object owners of existing objects, also allows deletions and overwrites of those objects.</p>
        pub fn set_grant_write(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.grant_write = input;
            self
        }
        /// <p>Allows grantee to write the ACL for the applicable bucket.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn grant_write_acp(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_write_acp = Some(input.into());
            self
        }
        /// <p>Allows grantee to write the ACL for the applicable bucket.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn set_grant_write_acp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.grant_write_acp = input;
            self
        }
        /// <p>Key for which the PUT action was initiated.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>Key for which the PUT action was initiated.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.request_payer = Some(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.request_payer = input;
            self
        }
        /// <p>VersionId used to reference a specific version of the object.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>VersionId used to reference a specific version of the object.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`PutObjectAclInput`](crate::input::PutObjectAclInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutObjectAclInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutObjectAclInput {
                acl: self.acl,
                access_control_policy: self.access_control_policy,
                bucket: self.bucket,
                content_md5: self.content_md5,
                grant_full_control: self.grant_full_control,
                grant_read: self.grant_read,
                grant_read_acp: self.grant_read_acp,
                grant_write: self.grant_write,
                grant_write_acp: self.grant_write_acp,
                key: self.key,
                request_payer: self.request_payer,
                version_id: self.version_id,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type PutObjectAclInputOperationOutputAlias = crate::operation::PutObjectAcl;
#[doc(hidden)]
pub type PutObjectAclInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutObjectAclInput {
    /// Consumes the builder and constructs an Operation<[`PutObjectAcl`](crate::operation::PutObjectAcl)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutObjectAcl,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutObjectAclInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_163 = &_input.bucket;
                let input_163 = input_163.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_163, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                let input_164 = &_input.key;
                let input_164 = input_164.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    },
                )?;
                let key = aws_smithy_http::label::fmt_string(input_164, true);
                if key.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}/{Key}", Bucket = bucket, Key = key)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::PutObjectAclInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("acl");
                if let Some(inner_165) = &_input.version_id {
                    query.push_kv("versionId", &aws_smithy_http::query::fmt_string(&inner_165));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutObjectAclInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_put_object_acl(input, builder)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_put_object_acl_input(
                &self.access_control_policy,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request = request.augment(|mut req, _| {
            let data = req
                .body()
                .bytes()
                .expect("checksum can only be computed for non-streaming operations");
            let checksum = md5::compute(data);
            req.headers_mut().insert(
                http::header::HeaderName::from_static("content-md5"),
                aws_smithy_types::base64::encode(&checksum[..])
                    .parse()
                    .expect("checksum is valid header value"),
            );
            Result::<_, aws_smithy_http::operation::BuildError>::Ok(req)
        })?;
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutObjectAcl::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutObjectAcl",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutObjectAclInput`](crate::input::PutObjectAclInput)
    pub fn builder() -> crate::input::put_object_acl_input::Builder {
        crate::input::put_object_acl_input::Builder::default()
    }
}

/// See [`PutObjectLegalHoldInput`](crate::input::PutObjectLegalHoldInput)
pub mod put_object_legal_hold_input {
    /// A builder for [`PutObjectLegalHoldInput`](crate::input::PutObjectLegalHoldInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) legal_hold: std::option::Option<crate::model::ObjectLockLegalHold>,
        pub(crate) request_payer: std::option::Option<crate::model::RequestPayer>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) content_md5: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket name containing the object that you want to place a Legal Hold on. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name containing the object that you want to place a Legal Hold on. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The key name for the object that you want to place a Legal Hold on.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key name for the object that you want to place a Legal Hold on.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>Container element for the Legal Hold configuration you want to apply to the specified object.</p>
        pub fn legal_hold(mut self, input: crate::model::ObjectLockLegalHold) -> Self {
            self.legal_hold = Some(input);
            self
        }
        /// <p>Container element for the Legal Hold configuration you want to apply to the specified object.</p>
        pub fn set_legal_hold(
            mut self,
            input: std::option::Option<crate::model::ObjectLockLegalHold>,
        ) -> Self {
            self.legal_hold = input;
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.request_payer = Some(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.request_payer = input;
            self
        }
        /// <p>The version ID of the object that you want to place a Legal Hold on.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The version ID of the object that you want to place a Legal Hold on.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>The MD5 hash for the request body.</p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn content_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_md5 = Some(input.into());
            self
        }
        /// <p>The MD5 hash for the request body.</p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn set_content_md5(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_md5 = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`PutObjectLegalHoldInput`](crate::input::PutObjectLegalHoldInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutObjectLegalHoldInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutObjectLegalHoldInput {
                bucket: self.bucket,
                key: self.key,
                legal_hold: self.legal_hold,
                request_payer: self.request_payer,
                version_id: self.version_id,
                content_md5: self.content_md5,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type PutObjectLegalHoldInputOperationOutputAlias = crate::operation::PutObjectLegalHold;
#[doc(hidden)]
pub type PutObjectLegalHoldInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutObjectLegalHoldInput {
    /// Consumes the builder and constructs an Operation<[`PutObjectLegalHold`](crate::operation::PutObjectLegalHold)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutObjectLegalHold,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutObjectLegalHoldInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_166 = &_input.bucket;
                let input_166 = input_166.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    },
                )?;
                let bucket = aws_smithy_http::label::fmt_string(input_166, false);
                if bucket.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    });
                }
                let input_167 = &_input.key;
                let input_167 = input_167.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    },
                )?;
                let key = aws_smithy_http::label::fmt_string(input_167, true);
                if key.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/{Bucket}/{Key}", Bucket = bucket, Key = key)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::PutObjectLegalHoldInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_v("legal-hold");
                if let Some(inner_168) = &_input.version_id {
                    query.push_kv("versionId", &aws_smithy_http::query::fmt_string(&inner_168));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutObjectLegalHoldInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_put_object_legal_hold(input, builder)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/xml",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_put_object_legal_hold_input(&self.legal_hold)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request = request.augment(|mut req, _| {
            let data = req
                .body()
                .bytes()
                .expect("checksum can only be computed for non-streaming operations");
            let checksum = md5::compute(data);
            req.headers_mut().insert(
                http::header::HeaderName::from_static("content-md5"),
                aws_smithy_types::base64::encode(&checksum[..])
                    .parse()
                    .expect("checksum is valid header value"),
            );
            Result::<_, aws_smithy_http::operation::BuildError>::Ok(req)
        })?;
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutObjectLegalHold::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutObjectLegalHold",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutObjectLegalHoldInput`](crate::input::PutObjectLegalHoldInput)
    pub fn builder() -> crate::input::put_object_legal_hold_input::Builder {
        crate::input::put_object_legal_hold_input::Builder::default()
    }
}

/// See [`PutObjectLockConfigurationInput`](crate::input::PutObjectLockConfigurationInput)
pub mod put_object_lock_configuration_input {
    /// A builder for [`PutObjectLockConfigurationInput`](crate::input::PutObjectLockConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) object_lock_configuration:
            std::option::Option<crate::model::ObjectLockConfiguration>,
        pub(crate) request_payer: std::option::Option<crate::model::RequestPayer>,
        pub(crate) token: std::option::Option<std::string::String>,
        pub(crate) content_md5: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket whose Object Lock configuration you want to create or replace.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket whose Object Lock configuration you want to create or replace.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The Object Lock configuration that you want to apply to the specified bucket.</p>
        pub fn object_lock_configuration(
            mut self,
            input: crate::model::ObjectLockConfiguration,
        ) -> Self {
            self.object_lock_configuration = Some(input);
            self
        }
        /// <p>The Object Lock configuration that you want to apply to the specified bucket.</p>
        pub fn set_object_lock_configuration(
            mut self,
            input: std::option::Option<crate::model::ObjectLockConfiguration>,
        ) -> Self {
            self.object_lock_configuration = input;
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.request_payer = Some(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.request_payer = input;
            self
        }
        /// <p>A token to allow Object Lock to be enabled for an existing bucket.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.token = Some(input.into());
            self
        }
        /// <p>A token to allow Object Lock to be enabled for an existing bucket.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token = input;
            self
        }
        /// <p>The MD5 hash for the request body.</p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn content_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_md5 = Some(input.into());
            self
        }
        /// <p>The MD5 hash for the request body.</p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn set_content_md5(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_md5 = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`PutObjectLockConfigurationInput`](crate::input::PutObjectLockConfigurationInpu