// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WriteGetObjectResponseOutput {}
impl std::fmt::Debug for WriteGetObjectResponseOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WriteGetObjectResponseOutput");
        formatter.finish()
    }
}
/// See [`WriteGetObjectResponseOutput`](crate::output::WriteGetObjectResponseOutput)
pub mod write_get_object_response_output {
    /// A builder for [`WriteGetObjectResponseOutput`](crate::output::WriteGetObjectResponseOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`WriteGetObjectResponseOutput`](crate::output::WriteGetObjectResponseOutput)
        pub fn build(self) -> crate::output::WriteGetObjectResponseOutput {
            crate::output::WriteGetObjectResponseOutput {}
        }
    }
}
impl WriteGetObjectResponseOutput {
    /// Creates a new builder-style object to manufacture [`WriteGetObjectResponseOutput`](crate::output::WriteGetObjectResponseOutput)
    pub fn builder() -> crate::output::write_get_object_response_output::Builder {
        crate::output::write_get_object_response_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UploadPartCopyOutput {
    /// <p>The version of the source object that was copied, if you have enabled versioning on the
    /// source bucket.</p>
    pub copy_source_version_id: std::option::Option<std::string::String>,
    /// <p>Container for all response elements.</p>
    pub copy_part_result: std::option::Option<crate::model::CopyPartResult>,
    /// <p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example,
    /// AES256, aws:kms).</p>
    pub server_side_encryption: std::option::Option<crate::model::ServerSideEncryption>,
    /// <p>If server-side encryption with a customer-provided encryption key was requested, the
    /// response will include this header confirming the encryption algorithm used.</p>
    pub sse_customer_algorithm: std::option::Option<std::string::String>,
    /// <p>If server-side encryption with a customer-provided encryption key was requested, the
    /// response will include this header to provide round-trip message integrity verification of
    /// the customer-provided encryption key.</p>
    pub sse_customer_key_md5: std::option::Option<std::string::String>,
    /// <p>If present, specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric
    /// customer managed key that was used for the object.</p>
    pub ssekms_key_id: std::option::Option<std::string::String>,
    /// <p>Indicates whether the multipart upload uses an S3 Bucket Key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
    pub bucket_key_enabled: bool,
    /// <p>If present, indicates that the requester was successfully charged for the
    /// request.</p>
    pub request_charged: std::option::Option<crate::model::RequestCharged>,
}
impl UploadPartCopyOutput {
    /// <p>The version of the source object that was copied, if you have enabled versioning on the
    /// source bucket.</p>
    pub fn copy_source_version_id(&self) -> std::option::Option<&str> {
        self.copy_source_version_id.as_deref()
    }
    /// <p>Container for all response elements.</p>
    pub fn copy_part_result(&self) -> std::option::Option<&crate::model::CopyPartResult> {
        self.copy_part_result.as_ref()
    }
    /// <p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example,
    /// AES256, aws:kms).</p>
    pub fn server_side_encryption(
        &self,
    ) -> std::option::Option<&crate::model::ServerSideEncryption> {
        self.server_side_encryption.as_ref()
    }
    /// <p>If server-side encryption with a customer-provided encryption key was requested, the
    /// response will include this header confirming the encryption algorithm used.</p>
    pub fn sse_customer_algorithm(&self) -> std::option::Option<&str> {
        self.sse_customer_algorithm.as_deref()
    }
    /// <p>If server-side encryption with a customer-provided encryption key was requested, the
    /// response will include this header to provide round-trip message integrity verification of
    /// the customer-provided encryption key.</p>
    pub fn sse_customer_key_md5(&self) -> std::option::Option<&str> {
        self.sse_customer_key_md5.as_deref()
    }
    /// <p>If present, specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric
    /// customer managed key that was used for the object.</p>
    pub fn ssekms_key_id(&self) -> std::option::Option<&str> {
        self.ssekms_key_id.as_deref()
    }
    /// <p>Indicates whether the multipart upload uses an S3 Bucket Key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
    pub fn bucket_key_enabled(&self) -> bool {
        self.bucket_key_enabled
    }
    /// <p>If present, indicates that the requester was successfully charged for the
    /// request.</p>
    pub fn request_charged(&self) -> std::option::Option<&crate::model::RequestCharged> {
        self.request_charged.as_ref()
    }
}
impl std::fmt::Debug for UploadPartCopyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UploadPartCopyOutput");
        formatter.field("copy_source_version_id", &self.copy_source_version_id);
        formatter.field("copy_part_result", &self.copy_part_result);
        formatter.field("server_side_encryption", &self.server_side_encryption);
        formatter.field("sse_customer_algorithm", &self.sse_customer_algorithm);
        formatter.field("sse_customer_key_md5", &self.sse_customer_key_md5);
        formatter.field("ssekms_key_id", &"*** Sensitive Data Redacted ***");
        formatter.field("bucket_key_enabled", &self.bucket_key_enabled);
        formatter.field("request_charged", &self.request_charged);
        formatter.finish()
    }
}
/// See [`UploadPartCopyOutput`](crate::output::UploadPartCopyOutput)
pub mod upload_part_copy_output {
    /// A builder for [`UploadPartCopyOutput`](crate::output::UploadPartCopyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) copy_source_version_id: std::option::Option<std::string::String>,
        pub(crate) copy_part_result: std::option::Option<crate::model::CopyPartResult>,
        pub(crate) server_side_encryption: std::option::Option<crate::model::ServerSideEncryption>,
        pub(crate) sse_customer_algorithm: std::option::Option<std::string::String>,
        pub(crate) sse_customer_key_md5: std::option::Option<std::string::String>,
        pub(crate) ssekms_key_id: std::option::Option<std::string::String>,
        pub(crate) bucket_key_enabled: std::option::Option<bool>,
        pub(crate) request_charged: std::option::Option<crate::model::RequestCharged>,
    }
    impl Builder {
        /// <p>The version of the source object that was copied, if you have enabled versioning on the
        /// source bucket.</p>
        pub fn copy_source_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.copy_source_version_id = Some(input.into());
            self
        }
        /// <p>The version of the source object that was copied, if you have enabled versioning on the
        /// source bucket.</p>
        pub fn set_copy_source_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.copy_source_version_id = input;
            self
        }
        /// <p>Container for all response elements.</p>
        pub fn copy_part_result(mut self, input: crate::model::CopyPartResult) -> Self {
            self.copy_part_result = Some(input);
            self
        }
        /// <p>Container for all response elements.</p>
        pub fn set_copy_part_result(
            mut self,
            input: std::option::Option<crate::model::CopyPartResult>,
        ) -> Self {
            self.copy_part_result = input;
            self
        }
        /// <p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example,
        /// AES256, aws:kms).</p>
        pub fn server_side_encryption(mut self, input: crate::model::ServerSideEncryption) -> Self {
            self.server_side_encryption = Some(input);
            self
        }
        /// <p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example,
        /// AES256, aws:kms).</p>
        pub fn set_server_side_encryption(
            mut self,
            input: std::option::Option<crate::model::ServerSideEncryption>,
        ) -> Self {
            self.server_side_encryption = input;
            self
        }
        /// <p>If server-side encryption with a customer-provided encryption key was requested, the
        /// response will include this header confirming the encryption algorithm used.</p>
        pub fn sse_customer_algorithm(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_customer_algorithm = Some(input.into());
            self
        }
        /// <p>If server-side encryption with a customer-provided encryption key was requested, the
        /// response will include this header confirming the encryption algorithm used.</p>
        pub fn set_sse_customer_algorithm(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_customer_algorithm = input;
            self
        }
        /// <p>If server-side encryption with a customer-provided encryption key was requested, the
        /// response will include this header to provide round-trip message integrity verification of
        /// the customer-provided encryption key.</p>
        pub fn sse_customer_key_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_customer_key_md5 = Some(input.into());
            self
        }
        /// <p>If server-side encryption with a customer-provided encryption key was requested, the
        /// response will include this header to provide round-trip message integrity verification of
        /// the customer-provided encryption key.</p>
        pub fn set_sse_customer_key_md5(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_customer_key_md5 = input;
            self
        }
        /// <p>If present, specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric
        /// customer managed key that was used for the object.</p>
        pub fn ssekms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssekms_key_id = Some(input.into());
            self
        }
        /// <p>If present, specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric
        /// customer managed key that was used for the object.</p>
        pub fn set_ssekms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssekms_key_id = input;
            self
        }
        /// <p>Indicates whether the multipart upload uses an S3 Bucket Key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
        pub fn bucket_key_enabled(mut self, input: bool) -> Self {
            self.bucket_key_enabled = Some(input);
            self
        }
        /// <p>Indicates whether the multipart upload uses an S3 Bucket Key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
        pub fn set_bucket_key_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.bucket_key_enabled = input;
            self
        }
        /// <p>If present, indicates that the requester was successfully charged for the
        /// request.</p>
        pub fn request_charged(mut self, input: crate::model::RequestCharged) -> Self {
            self.request_charged = Some(input);
            self
        }
        /// <p>If present, indicates that the requester was successfully charged for the
        /// request.</p>
        pub fn set_request_charged(
            mut self,
            input: std::option::Option<crate::model::RequestCharged>,
        ) -> Self {
            self.request_charged = input;
            self
        }
        /// Consumes the builder and constructs a [`UploadPartCopyOutput`](crate::output::UploadPartCopyOutput)
        pub fn build(self) -> crate::output::UploadPartCopyOutput {
            crate::output::UploadPartCopyOutput {
                copy_source_version_id: self.copy_source_version_id,
                copy_part_result: self.copy_part_result,
                server_side_encryption: self.server_side_encryption,
                sse_customer_algorithm: self.sse_customer_algorithm,
                sse_customer_key_md5: self.sse_customer_key_md5,
                ssekms_key_id: self.ssekms_key_id,
                bucket_key_enabled: self.bucket_key_enabled.unwrap_or_default(),
                request_charged: self.request_charged,
            }
        }
    }
}
impl UploadPartCopyOutput {
    /// Creates a new builder-style object to manufacture [`UploadPartCopyOutput`](crate::output::UploadPartCopyOutput)
    pub fn builder() -> crate::output::upload_part_copy_output::Builder {
        crate::output::upload_part_copy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UploadPartOutput {
    /// <p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example,
    /// AES256, aws:kms).</p>
    pub server_side_encryption: std::option::Option<crate::model::ServerSideEncryption>,
    /// <p>Entity tag for the uploaded object.</p>
    pub e_tag: std::option::Option<std::string::String>,
    /// <p>If server-side encryption with a customer-provided encryption key was requested, the
    /// response will include this header confirming the encryption algorithm used.</p>
    pub sse_customer_algorithm: std::option::Option<std::string::String>,
    /// <p>If server-side encryption with a customer-provided encryption key was requested, the
    /// response will include this header to provide round-trip message integrity verification of
    /// the customer-provided encryption key.</p>
    pub sse_customer_key_md5: std::option::Option<std::string::String>,
    /// <p>If present, specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric
    /// customer managed key was used for the object.</p>
    pub ssekms_key_id: std::option::Option<std::string::String>,
    /// <p>Indicates whether the multipart upload uses an S3 Bucket Key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
    pub bucket_key_enabled: bool,
    /// <p>If present, indicates that the requester was successfully charged for the
    /// request.</p>
    pub request_charged: std::option::Option<crate::model::RequestCharged>,
}
impl UploadPartOutput {
    /// <p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example,
    /// AES256, aws:kms).</p>
    pub fn server_side_encryption(
        &self,
    ) -> std::option::Option<&crate::model::ServerSideEncryption> {
        self.server_side_encryption.as_ref()
    }
    /// <p>Entity tag for the uploaded object.</p>
    pub fn e_tag(&self) -> std::option::Option<&str> {
        self.e_tag.as_deref()
    }
    /// <p>If server-side encryption with a customer-provided encryption key was requested, the
    /// response will include this header confirming the encryption algorithm used.</p>
    pub fn sse_customer_algorithm(&self) -> std::option::Option<&str> {
        self.sse_customer_algorithm.as_deref()
    }
    /// <p>If server-side encryption with a customer-provided encryption key was requested, the
    /// response will include this header to provide round-trip message integrity verification of
    /// the customer-provided encryption key.</p>
    pub fn sse_customer_key_md5(&self) -> std::option::Option<&str> {
        self.sse_customer_key_md5.as_deref()
    }
    /// <p>If present, specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric
    /// customer managed key was used for the object.</p>
    pub fn ssekms_key_id(&self) -> std::option::Option<&str> {
        self.ssekms_key_id.as_deref()
    }
    /// <p>Indicates whether the multipart upload uses an S3 Bucket Key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
    pub fn bucket_key_enabled(&self) -> bool {
        self.bucket_key_enabled
    }
    /// <p>If present, indicates that the requester was successfully charged for the
    /// request.</p>
    pub fn request_charged(&self) -> std::option::Option<&crate::model::RequestCharged> {
        self.request_charged.as_ref()
    }
}
impl std::fmt::Debug for UploadPartOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UploadPartOutput");
        formatter.field("server_side_encryption", &self.server_side_encryption);
        formatter.field("e_tag", &self.e_tag);
        formatter.field("sse_customer_algorithm", &self.sse_customer_algorithm);
        formatter.field("sse_customer_key_md5", &self.sse_customer_key_md5);
        formatter.field("ssekms_key_id", &"*** Sensitive Data Redacted ***");
        formatter.field("bucket_key_enabled", &self.bucket_key_enabled);
        formatter.field("request_charged", &self.request_charged);
        formatter.finish()
    }
}
/// See [`UploadPartOutput`](crate::output::UploadPartOutput)
pub mod upload_part_output {
    /// A builder for [`UploadPartOutput`](crate::output::UploadPartOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_side_encryption: std::option::Option<crate::model::ServerSideEncryption>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
        pub(crate) sse_customer_algorithm: std::option::Option<std::string::String>,
        pub(crate) sse_customer_key_md5: std::option::Option<std::string::String>,
        pub(crate) ssekms_key_id: std::option::Option<std::string::String>,
        pub(crate) bucket_key_enabled: std::option::Option<bool>,
        pub(crate) request_charged: std::option::Option<crate::model::RequestCharged>,
    }
    impl Builder {
        /// <p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example,
        /// AES256, aws:kms).</p>
        pub fn server_side_encryption(mut self, input: crate::model::ServerSideEncryption) -> Self {
            self.server_side_encryption = Some(input);
            self
        }
        /// <p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example,
        /// AES256, aws:kms).</p>
        pub fn set_server_side_encryption(
            mut self,
            input: std::option::Option<crate::model::ServerSideEncryption>,
        ) -> Self {
            self.server_side_encryption = input;
            self
        }
        /// <p>Entity tag for the uploaded object.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>Entity tag for the uploaded object.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// <p>If server-side encryption with a customer-provided encryption key was requested, the
        /// response will include this header confirming the encryption algorithm used.</p>
        pub fn sse_customer_algorithm(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_customer_algorithm = Some(input.into());
            self
        }
        /// <p>If server-side encryption with a customer-provided encryption key was requested, the
        /// response will include this header confirming the encryption algorithm used.</p>
        pub fn set_sse_customer_algorithm(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_customer_algorithm = input;
            self
        }
        /// <p>If server-side encryption with a customer-provided encryption key was requested, the
        /// response will include this header to provide round-trip message integrity verification of
        /// the customer-provided encryption key.</p>
        pub fn sse_customer_key_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_customer_key_md5 = Some(input.into());
            self
        }
        /// <p>If server-side encryption with a customer-provided encryption key was requested, the
        /// response will include this header to provide round-trip message integrity verification of
        /// the customer-provided encryption key.</p>
        pub fn set_sse_customer_key_md5(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_customer_key_md5 = input;
            self
        }
        /// <p>If present, specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric
        /// customer managed key was used for the object.</p>
        pub fn ssekms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssekms_key_id = Some(input.into());
            self
        }
        /// <p>If present, specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric
        /// customer managed key was used for the object.</p>
        pub fn set_ssekms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssekms_key_id = input;
            self
        }
        /// <p>Indicates whether the multipart upload uses an S3 Bucket Key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
        pub fn bucket_key_enabled(mut self, input: bool) -> Self {
            self.bucket_key_enabled = Some(input);
            self
        }
        /// <p>Indicates whether the multipart upload uses an S3 Bucket Key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
        pub fn set_bucket_key_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.bucket_key_enabled = input;
            self
        }
        /// <p>If present, indicates that the requester was successfully charged for the
        /// request.</p>
        pub fn request_charged(mut self, input: crate::model::RequestCharged) -> Self {
            self.request_charged = Some(input);
            self
        }
        /// <p>If present, indicates that the requester was successfully charged for the
        /// request.</p>
        pub fn set_request_charged(
            mut self,
            input: std::option::Option<crate::model::RequestCharged>,
        ) -> Self {
            self.request_charged = input;
            self
        }
        /// Consumes the builder and constructs a [`UploadPartOutput`](crate::output::UploadPartOutput)
        pub fn build(self) -> crate::output::UploadPartOutput {
            crate::output::UploadPartOutput {
                server_side_encryption: self.server_side_encryption,
                e_tag: self.e_tag,
                sse_customer_algorithm: self.sse_customer_algorithm,
                sse_customer_key_md5: self.sse_customer_key_md5,
                ssekms_key_id: self.ssekms_key_id,
                bucket_key_enabled: self.bucket_key_enabled.unwrap_or_default(),
                request_charged: self.request_charged,
            }
        }
    }
}
impl UploadPartOutput {
    /// Creates a new builder-style object to manufacture [`UploadPartOutput`](crate::output::UploadPartOutput)
    pub fn builder() -> crate::output::upload_part_output::Builder {
        crate::output::upload_part_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
pub struct SelectObjectContentOutput {
    /// <p>The array of results.</p>
    pub payload: aws_smithy_http::event_stream::Receiver<
        crate::model::SelectObjectContentEventStream,
        crate::error::SelectObjectContentError,
    >,
}
impl SelectObjectContentOutput {
    /// <p>The array of results.</p>
    pub fn payload(
        &self,
    ) -> &aws_smithy_http::event_stream::Receiver<
        crate::model::SelectObjectContentEventStream,
        crate::error::SelectObjectContentError,
    > {
        &self.payload
    }
}
impl std::fmt::Debug for SelectObjectContentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SelectObjectContentOutput");
        formatter.field("payload", &self.payload);
        formatter.finish()
    }
}
/// See [`SelectObjectContentOutput`](crate::output::SelectObjectContentOutput)
pub mod select_object_content_output {
    /// A builder for [`SelectObjectContentOutput`](crate::output::SelectObjectContentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) payload: std::option::Option<
            aws_smithy_http::event_stream::Receiver<
                crate::model::SelectObjectContentEventStream,
                crate::error::SelectObjectContentError,
            >,
        >,
    }
    impl Builder {
        /// <p>The array of results.</p>
        pub fn payload(
            mut self,
            input: aws_smithy_http::event_stream::Receiver<
                crate::model::SelectObjectContentEventStream,
                crate::error::SelectObjectContentError,
            >,
        ) -> Self {
            self.payload = Some(input);
            self
        }
        /// <p>The array of results.</p>
        pub fn set_payload(
            mut self,
            input: std::option::Option<
                aws_smithy_http::event_stream::Receiver<
                    crate::model::SelectObjectContentEventStream,
                    crate::error::SelectObjectContentError,
                >,
            >,
        ) -> Self {
            self.payload = input;
            self
        }
        /// Consumes the builder and constructs a [`SelectObjectContentOutput`](crate::output::SelectObjectContentOutput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::output::SelectObjectContentOutput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::output::SelectObjectContentOutput {
                    payload: self.payload
                        .ok_or(
                            aws_smithy_http::operation::BuildError::MissingField { field: "payload", details: "payload was not specified but it is required when building SelectObjectContentOutput"}
                        )?
                    ,
                }
            )
        }
    }
}
impl SelectObjectContentOutput {
    /// Creates a new builder-style object to manufacture [`SelectObjectContentOutput`](crate::output::SelectObjectContentOutput)
    pub fn builder() -> crate::output::select_object_content_output::Builder {
        crate::output::select_object_content_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestoreObjectOutput {
    /// <p>If present, indicates that the requester was successfully charged for the
    /// request.</p>
    pub request_charged: std::option::Option<crate::model::RequestCharged>,
    /// <p>Indicates the path in the provided S3 output location where Select results will be
    /// restored to.</p>
    pub restore_output_path: std::option::Option<std::string::String>,
}
impl RestoreObjectOutput {
    /// <p>If present, indicates that the requester was successfully charged for the
    /// request.</p>
    pub fn request_charged(&self) -> std::option::Option<&crate::model::RequestCharged> {
        self.request_charged.as_ref()
    }
    /// <p>Indicates the path in the provided S3 output location where Select results will be
    /// restored to.</p>
    pub fn restore_output_path(&self) -> std::option::Option<&str> {
        self.restore_output_path.as_deref()
    }
}
impl std::fmt::Debug for RestoreObjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestoreObjectOutput");
        formatter.field("request_charged", &self.request_charged);
        formatter.field("restore_output_path", &self.restore_output_path);
        formatter.finish()
    }
}
/// See [`RestoreObjectOutput`](crate::output::RestoreObjectOutput)
pub mod restore_object_output {
    /// A builder for [`RestoreObjectOutput`](crate::output::RestoreObjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_charged: std::option::Option<crate::model::RequestCharged>,
        pub(crate) restore_output_path: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>If present, indicates that the requester was successfully charged for the
        /// request.</p>
        pub fn request_charged(mut self, input: crate::model::RequestCharged) -> Self {
            self.request_charged = Some(input);
            self
        }
        /// <p>If present, indicates that the requester was successfully charged for the
        /// request.</p>
        pub fn set_request_charged(
            mut self,
            input: std::option::Option<crate::model::RequestCharged>,
        ) -> Self {
            self.request_charged = input;
            self
        }
        /// <p>Indicates the path in the provided S3 output location where Select results will be
        /// restored to.</p>
        pub fn restore_output_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.restore_output_path = Some(input.into());
            self
        }
        /// <p>Indicates the path in the provided S3 output location where Select results will be
        /// restored to.</p>
        pub fn set_restore_output_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.restore_output_path = input;
            self
        }
        /// Consumes the builder and constructs a [`RestoreObjectOutput`](crate::output::RestoreObjectOutput)
        pub fn build(self) -> crate::output::RestoreObjectOutput {
            crate::output::RestoreObjectOutput {
                request_charged: self.request_charged,
                restore_output_path: self.restore_output_path,
            }
        }
    }
}
impl RestoreObjectOutput {
    /// Creates a new builder-style object to manufacture [`RestoreObjectOutput`](crate::output::RestoreObjectOutput)
    pub fn builder() -> crate::output::restore_object_output::Builder {
        crate::output::restore_object_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutPublicAccessBlockOutput {}
impl std::fmt::Debug for PutPublicAccessBlockOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutPublicAccessBlockOutput");
        formatter.finish()
    }
}
/// See [`PutPublicAccessBlockOutput`](crate::output::PutPublicAccessBlockOutput)
pub mod put_public_access_block_output {
    /// A builder for [`PutPublicAccessBlockOutput`](crate::output::PutPublicAccessBlockOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutPublicAccessBlockOutput`](crate::output::PutPublicAccessBlockOutput)
        pub fn build(self) -> crate::output::PutPublicAccessBlockOutput {
            crate::output::PutPublicAccessBlockOutput {}
        }
    }
}
impl PutPublicAccessBlockOutput {
    /// Creates a new builder-style object to manufacture [`PutPublicAccessBlockOutput`](crate::output::PutPublicAccessBlockOutput)
    pub fn builder() -> crate::output::put_public_access_block_output::Builder {
        crate::output::put_public_access_block_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutObjectTaggingOutput {
    /// <p>The versionId of the object the tag-set was added to.</p>
    pub version_id: std::option::Option<std::string::String>,
}
impl PutObjectTaggingOutput {
    /// <p>The versionId of the object the tag-set was added to.</p>
    pub fn version_id(&self) -> std::option::Option<&str> {
        self.version_id.as_deref()
    }
}
impl std::fmt::Debug for PutObjectTaggingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutObjectTaggingOutput");
        formatter.field("version_id", &self.version_id);
        formatter.finish()
    }
}
/// See [`PutObjectTaggingOutput`](crate::output::PutObjectTaggingOutput)
pub mod put_object_tagging_output {
    /// A builder for [`PutObjectTaggingOutput`](crate::output::PutObjectTaggingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) version_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The versionId of the object the tag-set was added to.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The versionId of the object the tag-set was added to.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// Consumes the builder and constructs a [`PutObjectTaggingOutput`](crate::output::PutObjectTaggingOutput)
        pub fn build(self) -> crate::output::PutObjectTaggingOutput {
            crate::output::PutObjectTaggingOutput {
                version_id: self.version_id,
            }
        }
    }
}
impl PutObjectTaggingOutput {
    /// Creates a new builder-style object to manufacture [`PutObjectTaggingOutput`](crate::output::PutObjectTaggingOutput)
    pub fn builder() -> crate::output::put_object_tagging_output::Builder {
        crate::output::put_object_tagging_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutObjectRetentionOutput {
    /// <p>If present, indicates that the requester was successfully charged for the
    /// request.</p>
    pub request_charged: std::option::Option<crate::model::RequestCharged>,
}
impl PutObjectRetentionOutput {
    /// <p>If present, indicates that the requester was successfully charged for the
    /// request.</p>
    pub fn request_charged(&self) -> std::option::Option<&crate::model::RequestCharged> {
        self.request_charged.as_ref()
    }
}
impl std::fmt::Debug for PutObjectRetentionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutObjectRetentionOutput");
        formatter.field("request_charged", &self.request_charged);
        formatter.finish()
    }
}
/// See [`PutObjectRetentionOutput`](crate::output::PutObjectRetentionOutput)
pub mod put_object_retention_output {
    /// A builder for [`PutObjectRetentionOutput`](crate::output::PutObjectRetentionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_charged: std::option::Option<crate::model::RequestCharged>,
    }
    impl Builder {
        /// <p>If present, indicates that the requester was successfully charged for the
        /// request.</p>
        pub fn request_charged(mut self, input: crate::model::RequestCharged) -> Self {
            self.request_charged = Some(input);
            self
        }
        /// <p>If present, indicates that the requester was successfully charged for the
        /// request.</p>
        pub fn set_request_charged(
            mut self,
            input: std::option::Option<crate::model::RequestCharged>,
        ) -> Self {
            self.request_charged = input;
            self
        }
        /// Consumes the builder and constructs a [`PutObjectRetentionOutput`](crate::output::PutObjectRetentionOutput)
        pub fn build(self) -> crate::output::PutObjectRetentionOutput {
            crate::output::PutObjectRetentionOutput {
                request_charged: self.request_charged,
            }
        }
    }
}
impl PutObjectRetentionOutput {
    /// Creates a new builder-style object to manufacture [`PutObjectRetentionOutput`](crate::output::PutObjectRetentionOutput)
    pub fn builder() -> crate::output::put_object_retention_output::Builder {
        crate::output::put_object_retention_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutObjectLockConfigurationOutput {
    /// <p>If present, indicates that the requester was successfully charged for the
    /// request.</p>
    pub request_charged: std::option::Option<crate::model::RequestCharged>,
}
impl PutObjectLockConfigurationOutput {
    /// <p>If present, indicates that the requester was successfully charged for the
    /// request.</p>
    pub fn request_charged(&self) -> std::option::Option<&crate::model::RequestCharged> {
        self.request_charged.as_ref()
    }
}
impl std::fmt::Debug for PutObjectLockConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutObjectLockConfigurationOutput");
        formatter.field("request_charged", &self.request_charged);
        formatter.finish()
    }
}
/// See [`PutObjectLockConfigurationOutput`](crate::output::PutObjectLockConfigurationOutput)
pub mod put_object_lock_configuration_output {
    /// A builder for [`PutObjectLockConfigurationOutput`](crate::output::PutObjectLockConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_charged: std::option::Option<crate::model::RequestCharged>,
    }
    impl Builder {
        /// <p>If present, indicates that the requester was successfully charged for the
        /// request.</p>
        pub fn request_charged(mut self, input: crate::model::RequestCharged) -> Self {
            self.request_charged = Some(input);
            self
        }
        /// <p>If present, indicates that the requester was successfully charged for the
        /// request.</p>
        pub fn set_request_charged(
            mut self,
            input: std::option::Option<crate::model::RequestCharged>,
        ) -> Self {
            self.request_charged = input;
            self
        }
        /// Consumes the builder and constructs a [`PutObjectLockConfigurationOutput`](crate::output::PutObjectLockConfigurationOutput)
        pub fn build(self) -> crate::output::PutObjectLockConfigurationOutput {
            crate::output::PutObjectLockConfigurationOutput {
                request_charged: self.request_charged,
            }
        }
    }
}
impl PutObjectLockConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`PutObjectLockConfigurationOutput`](crate::output::PutObjectLockConfigurationOutput)
    pub fn builder() -> crate::output::put_object_lock_configuration_output::Builder {
        crate::output::put_object_lock_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutObjectLegalHoldOutput {
    /// <p>If present, indicates that the requester was successfully charged for the
    /// request.</p>
    pub request_charged: std::option::Option<crate::model::RequestCharged>,
}
impl PutObjectLegalHoldOutput {
    /// <p>If present, indicates that the requester was successfully charged for the
    /// request.</p>
    pub fn request_charged(&self) -> std::option::Option<&crate::model::RequestCharged> {
        self.request_charged.as_ref()
    }
}
impl std::fmt::Debug for PutObjectLegalHoldOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutObjectLegalHoldOutput");
        formatter.field("request_charged", &self.request_charged);
        formatter.finish()
    }
}
/// See [`PutObjectLegalHoldOutput`](crate::output::PutObjectLegalHoldOutput)
pub mod put_object_legal_hold_output {
    /// A builder for [`PutObjectLegalHoldOutput`](crate::output::PutObjectLegalHoldOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_charged: std::option::Option<crate::model::RequestCharged>,
    }
    impl Builder {
        /// <p>If present, indicates that the requester was successfully charged for the
        /// request.</p>
        pub fn request_charged(mut self, input: crate::model::RequestCharged) -> Self {
            self.request_charged = Some(input);
            self
        }
        /// <p>If present, indicates that the requester was successfully charged for the
        /// request.</p>
        pub fn set_request_charged(
            mut self,
            input: std::option::Option<crate::model::RequestCharged>,
        ) -> Self {
            self.request_charged = input;
            self
        }
        /// Consumes the builder and constructs a [`PutObjectLegalHoldOutput`](crate::output::PutObjectLegalHoldOutput)
        pub fn build(self) -> crate::output::PutObjectLegalHoldOutput {
            crate::output::PutObjectLegalHoldOutput {
                request_charged: self.request_charged,
            }
        }
    }
}
impl PutObjectLegalHoldOutput {
    /// Creates a new builder-style object to manufacture [`PutObjectLegalHoldOutput`](crate::output::PutObjectLegalHoldOutput)
    pub fn builder() -> crate::output::put_object_legal_hold_output::Builder {
        crate::output::put_object_legal_hold_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutObjectAclOutput {
    /// <p>If present, indicates that the requester was successfully charged for the
    /// request.</p>
    pub request_charged: std::option::Option<crate::model::RequestCharged>,
}
impl PutObjectAclOutput {
    /// <p>If present, indicates that the requester was successfully charged for the
    /// request.</p>
    pub fn request_charged(&self) -> std::option::Option<&crate::model::RequestCharged> {
        self.request_charged.as_ref()
    }
}
impl std::fmt::Debug for PutObjectAclOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutObjectAclOutput");
        formatter.field("request_charged", &self.request_charged);
        formatter.finish()
    }
}
/// See [`PutObjectAclOutput`](crate::output::PutObjectAclOutput)
pub mod put_object_acl_output {
    /// A builder for [`PutObjectAclOutput`](crate::output::PutObjectAclOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_charged: std::option::Option<crate::model::RequestCharged>,
    }
    impl Builder {
        /// <p>If present, indicates that the requester was successfully charged for the
        /// request.</p>
        pub fn request_charged(mut self, input: crate::model::RequestCharged) -> Self {
            self.request_charged = Some(input);
            self
        }
        /// <p>If present, indicates that the requester was successfully charged for the
        /// request.</p>
        pub fn set_request_charged(
            mut self,
            input: std::option::Option<crate::model::RequestCharged>,
        ) -> Self {
            self.request_charged = input;
            self
        }
        /// Consumes the builder and constructs a [`PutObjectAclOutput`](crate::output::PutObjectAclOutput)
        pub fn build(self) -> crate::output::PutObjectAclOutput {
            crate::output::PutObjectAclOutput {
                request_charged: self.request_charged,
            }
        }
    }
}
impl PutObjectAclOutput {
    /// Creates a new builder-style object to manufacture [`PutObjectAclOutput`](crate::output::PutObjectAclOutput)
    pub fn builder() -> crate::output::put_object_acl_output::Builder {
        crate::output::put_object_acl_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutObjectOutput {
    /// <p> If the expiration is configured for the object (see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycleConfiguration.html">PutBucketLifecycleConfiguration</a>), the response includes this header. It
    /// includes the expiry-date and rule-id key-value pairs that provide information about object
    /// expiration. The value of the rule-id is URL encoded.</p>
    pub expiration: std::option::Option<std::string::String>,
    /// <p>Entity tag for the uploaded object.</p>
    pub e_tag: std::option::Option<std::string::String>,
    /// <p>If you specified server-side encryption either with an Amazon Web Services KMS key
    /// or Amazon S3-managed encryption key in your PUT request, the response includes this header. It
    /// confirms the encryption algorithm that Amazon S3 used to encrypt the object.</p>
    pub server_side_encryption: std::option::Option<crate::model::ServerSideEncryption>,
    /// <p>Version of the object.</p>
    pub version_id: std::option::Option<std::string::String>,
    /// <p>If server-side encryption with a customer-provided encryption key was requested, the
    /// response will include this header confirming the encryption algorithm used.</p>
    pub sse_customer_algorithm: std::option::Option<std::string::String>,
    /// <p>If server-side encryption with a customer-provided encryption key was requested, the
    /// response will include this header to provide round-trip message integrity verification of
    /// the customer-provided encryption key.</p>
    pub sse_customer_key_md5: std::option::Option<std::string::String>,
    /// <p>If <code>x-amz-server-side-encryption</code> is present and has the value of
    /// <code>aws:kms</code>, this header specifies the ID of the Amazon Web Services Key Management Service
    /// (Amazon Web Services KMS) symmetric customer managed key that was used for the
    /// object. </p>
    pub ssekms_key_id: std::option::Option<std::string::String>,
    /// <p>If present, specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The
    /// value of this header is a base64-encoded UTF-8 string holding JSON with the encryption
    /// context key-value pairs.</p>
    pub ssekms_encryption_context: std::option::Option<std::string::String>,
    /// <p>Indicates whether the uploaded object uses an S3 Bucket Key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
    pub bucket_key_enabled: bool,
    /// <p>If present, indicates that the requester was successfully charged for the
    /// request.</p>
    pub request_charged: std::option::Option<crate::model::RequestCharged>,
}
impl PutObjectOutput {
    /// <p> If the expiration is configured for the object (see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycleConfiguration.html">PutBucketLifecycleConfiguration</a>), the response includes this header. It
    /// includes the expiry-date and rule-id key-value pairs that provide information about object
    /// expiration. The value of the rule-id is URL encoded.</p>
    pub fn expiration(&self) -> std::option::Option<&str> {
        self.expiration.as_deref()
    }
    /// <p>Entity tag for the uploaded object.</p>
    pub fn e_tag(&self) -> std::option::Option<&str> {
        self.e_tag.as_deref()
    }
    /// <p>If you specified server-side encryption either with an Amazon Web Services KMS key
    /// or Amazon S3-managed encryption key in your PUT request, the response includes this header. It
    /// confirms the encryption algorithm that Amazon S3 used to encrypt the object.</p>
    pub fn server_side_encryption(
        &self,
    ) -> std::option::Option<&crate::model::ServerSideEncryption> {
        self.server_side_encryption.as_ref()
    }
    /// <p>Version of the object.</p>
    pub fn version_id(&self) -> std::option::Option<&str> {
        self.version_id.as_deref()
    }
    /// <p>If server-side encryption with a customer-provided encryption key was requested, the
    /// response will include this header confirming the encryption algorithm used.</p>
    pub fn sse_customer_algorithm(&self) -> std::option::Option<&str> {
        self.sse_customer_algorithm.as_deref()
    }
    /// <p>If server-side encryption with a customer-provided encryption key was requested, the
    /// response will include this header to provide round-trip message integrity verification of
    /// the customer-provided encryption key.</p>
    pub fn sse_customer_key_md5(&self) -> std::option::Option<&str> {
        self.sse_customer_key_md5.as_deref()
    }
    /// <p>If <code>x-amz-server-side-encryption</code> is present and has the value of
    /// <code>aws:kms</code>, this header specifies the ID of the Amazon Web Services Key Management Service
    /// (Amazon Web Services KMS) symmetric customer managed key that was used for the
    /// object. </p>
    pub fn ssekms_key_id(&self) -> std::option::Option<&str> {
        self.ssekms_key_id.as_deref()
    }
    /// <p>If present, specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The
    /// value of this header is a base64-encoded UTF-8 string holding JSON with the encryption
    /// context key-value pairs.</p>
    pub fn ssekms_encryption_context(&self) -> std::option::Option<&str> {
        self.ssekms_encryption_context.as_deref()
    }
    /// <p>Indicates whether the uploaded object uses an S3 Bucket Key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
    pub fn bucket_key_enabled(&self) -> bool {
        self.bucket_key_enabled
    }
    /// <p>If present, indicates that the requester was successfully charged for the
    /// request.</p>
    pub fn request_charged(&self) -> std::option::Option<&crate::model::RequestCharged> {
        self.request_charged.as_ref()
    }
}
impl std::fmt::Debug for PutObjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutObjectOutput");
        formatter.field("expiration", &self.expiration);
        formatter.field("e_tag", &self.e_tag);
        formatter.field("server_side_encryption", &self.server_side_encryption);
        formatter.field("version_id", &self.version_id);
        formatter.field("sse_customer_algorithm", &self.sse_customer_algorithm);
        formatter.field("sse_customer_key_md5", &self.sse_customer_key_md5);
        formatter.field("ssekms_key_id", &"*** Sensitive Data Redacted ***");
        formatter.field(
            "ssekms_encryption_context",
            &"*** Sensitive Data Redacted ***",
        );
        formatter.field("bucket_key_enabled", &self.bucket_key_enabled);
        formatter.field("request_charged", &self.request_charged);
        formatter.finish()
    }
}
/// See [`PutObjectOutput`](crate::output::PutObjectOutput)
pub mod put_object_output {
    /// A builder for [`PutObjectOutput`](crate::output::PutObjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) expiration: std::option::Option<std::string::String>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
        pub(crate) server_side_encryption: std::option::Option<crate::model::ServerSideEncryption>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) sse_customer_algorithm: std::option::Option<std::string::String>,
        pub(crate) sse_customer_key_md5: std::option::Option<std::string::String>,
        pub(crate) ssekms_key_id: std::option::Option<std::string::String>,
        pub(crate) ssekms_encryption_context: std::option::Option<std::string::String>,
        pub(crate) bucket_key_enabled: std::option::Option<bool>,
        pub(crate) request_charged: std::option::Option<crate::model::RequestCharged>,
    }
    impl Builder {
        /// <p> If the expiration is configured for the object (see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycleConfiguration.html">PutBucketLifecycleConfiguration</a>), the response includes this header. It
        /// includes the expiry-date and rule-id key-value pairs that provide information about object
        /// expiration. The value of the rule-id is URL encoded.</p>
        pub fn expiration(mut self, input: impl Into<std::string::String>) -> Self {
            self.expiration = Some(input.into());
            self
        }
        /// <p> If the expiration is configured for the object (see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycleConfiguration.html">PutBucketLifecycleConfiguration</a>), the response includes this header. It
        /// includes the expiry-date and rule-id key-value pairs that provide information about object
        /// expiration. The value of the rule-id is URL encoded.</p>
        pub fn set_expiration(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.expiration = input;
            self
        }
        /// <p>Entity tag for the uploaded object.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>Entity tag for the uploaded object.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// <p>If you specified server-side encryption either with an Amazon Web Services KMS key
        /// or Amazon S3-managed encryption key in your PUT request, the response includes this header. It
        /// confirms the encryption algorithm that Amazon S3 used to encrypt the object.</p>
        pub fn server_side_encryption(mut self, input: crate::model::ServerSideEncryption) -> Self {
            self.server_side_encryption = Some(input);
            self
        }
        /// <p>If you specified server-side encryption either with an Amazon Web Services KMS key
        /// or Amazon S3-managed encryption key in your PUT request, the response includes this header. It
        /// confirms the encryption algorithm that Amazon S3 used to encrypt the object.</p>
        pub fn set_server_side_encryption(
            mut self,
            input: std::option::Option<crate::model::ServerSideEncryption>,
        ) -> Self {
            self.server_side_encryption = input;
            self
        }
        /// <p>Version of the object.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>Version of the object.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>If server-side encryption with a customer-provided encryption key was requested, the
        /// response will include this header confirming the encryption algorithm used.</p>
        pub fn sse_customer_algorithm(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_customer_algorithm = Some(input.into());
            self
        }
        /// <p>If server-side encryption with a customer-provided encryption key was requested, the
        /// response will include this header confirming the encryption algorithm used.</p>
        pub fn set_sse_customer_algorithm(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_customer_algorithm = input;
            self
        }
        /// <p>If server-side encryption with a customer-provided encryption key was requested, the
        /// response will include this header to provide round-trip message integrity verification of
        /// the customer-provided encryption key.</p>
        pub fn sse_customer_key_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_customer_key_md5 = Some(input.into());
            self
        }
        /// <p>If server-side encryption with a customer-provided encryption key was requested, the
        /// response will include this header to provide round-trip message integrity verification of
        /// the customer-provided encryption key.</p>
        pub fn set_sse_customer_key_md5(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_customer_key_md5 = input;
            self
        }
        /// <p>If <code>x-amz-server-side-encryption</code> is present and has the value of
        /// <code>aws:kms</code>, this header specifies the ID of the Amazon Web Services Key Management Service
        /// (Amazon Web Services KMS) symmetric customer managed key that was used for the
        /// object. </p>
        pub fn ssekms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssekms_key_id = Some(input.into());
            self
        }
        /// <p>If <code>x-amz-server-side-encryption</code> is present and has the value of
        /// <code>aws:kms</code>, this header specifies the ID of the Amazon Web Services Key Management Service
        /// (Amazon Web Services KMS) symmetric customer managed key that was used for the
        /// object. </p>
        pub fn set_ssekms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssekms_key_id = input;
            self
        }
        /// <p>If present, specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The
        /// value of this header is a base64-encoded UTF-8 string holding JSON with the encryption
        /// context key-value pairs.</p>
        pub fn ssekms_encryption_context(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssekms_encryption_context = Some(input.into());
            self
        }
        /// <p>If present, specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The
        /// value of this header is a base64-encoded UTF-8 string holding JSON with the encryption
        /// context key-value pairs.</p>
        pub fn set_ssekms_encryption_context(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssekms_encryption_context = input;
            self
        }
        /// <p>Indicates whether the uploaded object uses an S3 Bucket Key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
        pub fn bucket_key_enabled(mut self, input: bool) -> Self {
            self.bucket_key_enabled = Some(input);
            self
        }
        /// <p>Indicates whether the uploaded object uses an S3 Bucket Key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
        pub fn set_bucket_key_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.bucket_key_enabled = input;
            self
        }
        /// <p>If present, indicates that the requester was successfully charged for the
        /// request.</p>
        pub fn request_charged(mut self, input: crate::model::RequestCharged) -> Self {
            self.request_charged = Some(input);
            self
        }
        /// <p>If present, indicates that the requester was successfully charged for the
        /// request.</p>
        pub fn set_request_charged(
            mut self,
            input: std::option::Option<crate::model::RequestCharged>,
        ) -> Self {
            self.request_charged = input;
            self
        }
        /// Consumes the builder and constructs a [`PutObjectOutput`](crate::output::PutObjectOutput)
        pub fn build(self) -> crate::output::PutObjectOutput {
            crate::output::PutObjectOutput {
                expiration: self.expiration,
                e_tag: self.e_tag,
                server_side_encryption: self.server_side_encryption,
                version_id: self.version_id,
                sse_customer_algorithm: self.sse_customer_algorithm,
                sse_customer_key_md5: self.sse_customer_key_md5,
                ssekms_key_id: self.ssekms_key_id,
                ssekms_encryption_context: self.ssekms_encryption_context,
                bucket_key_enabled: self.bucket_key_enabled.unwrap_or_default(),
                request_charged: self.request_charged,
            }
        }
    }
}
impl PutObjectOutput {
    /// Creates a new builder-style object to manufacture [`PutObjectOutput`](crate::output::PutObjectOutput)
    pub fn builder() -> crate::output::put_object_output::Builder {
        crate::output::put_object_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutBucketWebsiteOutput {}
impl std::fmt::Debug for PutBucketWebsiteOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutBucketWebsiteOutput");
        formatter.finish()
    }
}
/// See [`PutBucketWebsiteOutput`](crate::output::PutBucketWebsiteOutput)
pub mod put_bucket_website_output {
    /// A builder for [`PutBucketWebsiteOutput`](crate::output::PutBucketWebsiteOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutBucketWebsiteOutput`](crate::output::PutBucketWebsiteOutput)
        pub fn build(self) -> crate::output::PutBucketWebsiteOutput {
            crate::output::PutBucketWebsiteOutput {}
        }
    }
}
impl PutBucketWebsiteOutput {
    /// Creates a new builder-style object to manufacture [`PutBucketWebsiteOutput`](crate::output::PutBucketWebsiteOutput)
    pub fn builder() -> crate::output::put_bucket_website_output::Builder {
        crate::output::put_bucket_website_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutBucketVersioningOutput {}
impl std::fmt::Debug for PutBucketVersioningOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutBucketVersioningOutput");
        formatter.finish()
    }
}
/// See [`PutBucketVersioningOutput`](crate::output::PutBucketVersioningOutput)
pub mod put_bucket_versioning_output {
    /// A builder for [`PutBucketVersioningOutput`](crate::output::PutBucketVersioningOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutBucketVersioningOutput`](crate::output::PutBucketVersioningOutput)
        pub fn build(self) -> crate::output::PutBucketVersioningOutput {
            crate::output::PutBucketVersioningOutput {}
        }
    }
}
impl PutBucketVersioningOutput {
    /// Creates a new builder-style object to manufacture [`PutBucketVersioningOutput`](crate::output::PutBucketVersioningOutput)
    pub fn builder() -> crate::output::put_bucket_versioning_output::Builder {
        crate::output::put_bucket_versioning_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutBucketTaggingOutput {}
impl std::fmt::Debug for PutBucketTaggingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutBucketTaggingOutput");
        formatter.finish()
    }
}
/// See [`PutBucketTaggingOutput`](crate::output::PutBucketTaggingOutput)
pub mod put_bucket_tagging_output {
    /// A builder for [`PutBucketTaggingOutput`](crate::output::PutBucketTaggingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutBucketTaggingOutput`](crate::output::PutBucketTaggingOutput)
        pub fn build(self) -> crate::output::PutBucketTaggingOutput {
            crate::output::PutBucketTaggingOutput {}
        }
    }
}
impl PutBucketTaggingOutput {
    /// Creates a new builder-style object to manufacture [`PutBucketTaggingOutput`](crate::output::PutBucketTaggingOutput)
    pub fn builder() -> crate::output::put_bucket_tagging_output::Builder {
        crate::output::put_bucket_tagging_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutBucketRequestPaymentOutput {}
impl std::fmt::Debug for PutBucketRequestPaymentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutBucketRequestPaymentOutput");
        formatter.finish()
    }
}
/// See [`PutBucketRequestPaymentOutput`](crate::output::PutBucketRequestPaymentOutput)
pub mod put_bucket_request_payment_output {
    /// A builder for [`PutBucketRequestPaymentOutput`](crate::output::PutBucketRequestPaymentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutBucketRequestPaymentOutput`](crate::output::PutBucketRequestPaymentOutput)
        pub fn build(self) -> crate::output::PutBucketRequestPaymentOutput {
            crate::output::PutBucketRequestPaymentOutput {}
        }
    }
}
impl PutBucketRequestPaymentOutput {
    /// Creates a new builder-style object to manufacture [`PutBucketRequestPaymentOutput`](crate::output::PutBucketRequestPaymentOutput)
    pub fn builder() -> crate::output::put_bucket_request_payment_output::Builder {
        crate::output::put_bucket_request_payment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutBucketReplicationOutput {}
impl std::fmt::Debug for PutBucketReplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutBucketReplicationOutput");
        formatter.finish()
    }
}
/// See [`PutBucketReplicationOutput`](crate::output::PutBucketReplicationOutput)
pub mod put_bucket_replication_output {
    /// A builder for [`PutBucketReplicationOutput`](crate::output::PutBucketReplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutBucketReplicationOutput`](crate::output::PutBucketReplicationOutput)
        pub fn build(self) -> crate::output::PutBucketReplicationOutput {
            crate::output::PutBucketReplicationOutput {}
        }
    }
}
impl PutBucketReplicationOutput {
    /// Creates a new builder-style object to manufacture [`PutBucketReplicationOutput`](crate::output::PutBucketReplicationOutput)
    pub fn builder() -> crate::output::put_bucket_replication_output::Builder {
        crate::output::put_bucket_replication_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutBucketPolicyOutput {}
impl std::fmt::Debug for PutBucketPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutBucketPolicyOutput");
        formatter.finish()
    }
}
/// See [`PutBucketPolicyOutput`](crate::output::PutBucketPolicyOutput)
pub mod put_bucket_policy_output {
    /// A builder for [`PutBucketPolicyOutput`](crate::output::PutBucketPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutBucketPolicyOutput`](crate::output::PutBucketPolicyOutput)
        pub fn build(self) -> crate::output::PutBucketPolicyOutput {
            crate::output::PutBucketPolicyOutput {}
        }
    }
}
impl PutBucketPolicyOutput {
    /// Creates a new builder-style object to manufacture [`PutBucketPolicyOutput`](crate::output::PutBucketPolicyOutput)
    pub fn builder() -> crate::output::put_bucket_policy_output::Builder {
        crate::output::put_bucket_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutBucketOwnershipControlsOutput {}
impl std::fmt::Debug for PutBucketOwnershipControlsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutBucketOwnershipControlsOutput");
        formatter.finish()
    }
}
/// See [`PutBucketOwnershipControlsOutput`](crate::output::PutBucketOwnershipControlsOutput)
pub mod put_bucket_ownership_controls_output {
    /// A builder for [`PutBucketOwnershipControlsOutput`](crate::output::PutBucketOwnershipControlsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutBucketOwnershipControlsOutput`](crate::output::PutBucketOwnershipControlsOutput)
        pub fn build(self) -> crate::output::PutBucketOwnershipControlsOutput {
            crate::output::PutBucketOwnershipControlsOutput {}
        }
    }
}
impl PutBucketOwnershipControlsOutput {
    /// Creates a new builder-style object to manufacture [`PutBucketOwnershipControlsOutput`](crate::output::PutBucketOwnershipControlsOutput)
    pub fn builder() -> crate::output::put_bucket_ownership_controls_output::Builder {
        crate::output::put_bucket_ownership_controls_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutBucketNotificationConfigurationOutput {}
impl std::fmt::Debug for PutBucketNotificationConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutBucketNotificationConfigurationOutput");
        formatter.finish()
    }
}
/// See [`PutBucketNotificationConfigurationOutput`](crate::output::PutBucketNotificationConfigurationOutput)
pub mod put_bucket_notification_configuration_output {
    /// A builder for [`PutBucketNotificationConfigurationOutput`](crate::output::PutBucketNotificationConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutBucketNotificationConfigurationOutput`](crate::output::PutBucketNotificationConfigurationOutput)
        pub fn build(self) -> crate::output::PutBucketNotificationConfigurationOutput {
            crate::output::PutBucketNotificationConfigurationOutput {}
        }
    }
}
impl PutBucketNotificationConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`PutBucketNotificationConfigurationOutput`](crate::output::PutBucketNotificationConfigurationOutput)
    pub fn builder() -> crate::output::put_bucket_notification_configuration_output::Builder {
        crate::output::put_bucket_notification_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutBucketMetricsConfigurationOutput {}
impl std::fmt::Debug for PutBucketMetricsConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutBucketMetricsConfigurationOutput");
        formatter.finish()
    }
}
/// See [`PutBucketMetricsConfigurationOutput`](crate::output::PutBucketMetricsConfigurationOutput)
pub mod put_bucket_metrics_configuration_output {
    /// A builder for [`PutBucketMetricsConfigurationOutput`](crate::output::PutBucketMetricsConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutBucketMetricsConfigurationOutput`](crate::output::PutBucketMetricsConfigurationOutput)
        pub fn build(self) -> crate::output::PutBucketMetricsConfigurationOutput {
            crate::output::PutBucketMetricsConfigurationOutput {}
        }
    }
}
impl PutBucketMetricsConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`PutBucketMetricsConfigurationOutput`](crate::output::PutBucketMetricsConfigurationOutput)
    pub fn builder() -> crate::output::put_bucket_metrics_configuration_output::Builder {
        crate::output::put_bucket_metrics_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutBucketLoggingOutput {}
impl std::fmt::Debug for PutBucketLoggingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutBucketLoggingOutput");
        formatter.finish()
    }
}
/// See [`PutBucketLoggingOutput`](crate::output::PutBucketLoggingOutput)
pub mod put_bucket_logging_output {
    /// A builder for [`PutBucketLoggingOutput`](crate::output::PutBucketLoggingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutBucketLoggingOutput`](crate::output::PutBucketLoggingOutput)
        pub fn build(self) -> crate::output::PutBucketLoggingOutput {
            crate::output::PutBucketLoggingOutput {}
        }
    }
}
impl PutBucketLoggingOutput {
    /// Creates a new builder-style object to manufacture [`PutBucketLoggingOutput`](crate::output::PutBucketLoggingOutput)
    pub fn builder() -> crate::output::put_bucket_logging_output::Builder {
        crate::output::put_bucket_logging_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutBucketLifecycleConfigurationOutput {}
impl std::fmt::Debug for PutBucketLifecycleConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutBucketLifecycleConfigurationOutput");
        formatter.finish()
    }
}
/// See [`PutBucketLifecycleConfigurationOutput`](crate::output::PutBucketLifecycleConfigurationOutput)
pub mod put_bucket_lifecycle_configuration_output {
    /// A builder for [`PutBucketLifecycleConfigurationOutput`](crate::output::PutBucketLifecycleConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutBucketLifecycleConfigurationOutput`](crate::output::PutBucketLifecycleConfigurationOutput)
        pub fn build(self) -> crate::output::PutBucketLifecycleConfigurationOutput {
            crate::output::PutBucketLifecycleConfigurationOutput {}
        }
    }
}
impl PutBucketLifecycleConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`PutBucketLifecycleConfigurationOutput`](crate::output::PutBucketLifecycleConfigurationOutput)
    pub fn builder() -> crate::output::put_bucket_lifecycle_configuration_output::Builder {
        crate::output::put_bucket_lifecycle_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutBucketInventoryConfigurationOutput {}
impl std::fmt::Debug for PutBucketInventoryConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutBucketInventoryConfigurationOutput");
        formatter.finish()
    }
}
/// See [`PutBucketInventoryConfigurationOutput`](crate::output::PutBucketInventoryConfigurationOutput)
pub mod put_bucket_inventory_configuration_output {
    /// A builder for [`PutBucketInventoryConfigurationOutput`](crate::output::PutBucketInventoryConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutBucketInventoryConfigurationOutput`](crate::output::PutBucketInventoryConfigurationOutput)
        pub fn build(self) -> crate::output::PutBucketInventoryConfigurationOutput {
            crate::output::PutBucketInventoryConfigurationOutput {}
        }
    }
}
impl PutBucketInventoryConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`PutBucketInventoryConfigurationOutput`](crate::output::PutBucketInventoryConfigurationOutput)
    pub fn builder() -> crate::output::put_bucket_inventory_configuration_output::Builder {
        crate::output::put_bucket_inventory_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutBucketIntelligentTieringConfigurationOutput {}
impl std::fmt::Debug for PutBucketIntelligentTieringConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutBucketIntelligentTieringConfigurationOutput");
        formatter.finish()
    }
}
/// See [`PutBucketIntelligentTieringConfigurationOutput`](crate::output::PutBucketIntelligentTieringConfigurationOutput)
pub mod put_bucket_intelligent_tiering_configuration_output {
    /// A builder for [`PutBucketIntelligentTieringConfigurationOutput`](crate::output::PutBucketIntelligentTieringConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutBucketIntelligentTieringConfigurationOutput`](crate::output::PutBucketIntelligentTieringConfigurationOutput)
        pub fn build(self) -> crate::output::PutBucketIntelligentTieringConfigurationOutput {
            crate::output::PutBucketIntelligentTieringConfigurationOutput {}
        }
    }
}
impl PutBucketIntelligentTieringConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`PutBucketIntelligentTieringConfigurationOutput`](crate::output::PutBucketIntelligentTieringConfigurationOutput)
    pub fn builder() -> crate::output::put_bucket_intelligent_tiering_configuration_output::Builder
    {
        crate::output::put_bucket_intelligent_tiering_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutBucketEncryptionOutput {}
impl std::fmt::Debug for PutBucketEncryptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutBucketEncryptionOutput");
        formatter.finish()
    }
}
/// See [`PutBucketEncryptionOutput`](crate::output::PutBucketEncryptionOutput)
pub mod put_bucket_encryption_output {
    /// A builder for [`PutBucketEncryptionOutput`](crate::output::PutBucketEncryptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutBucketEncryptionOutput`](crate::output::PutBucketEncryptionOutput)
        pub fn build(self) -> crate::output::PutBucketEncryptionOutput {
            crate::output::PutBucketEncryptionOutput {}
        }
    }
}
impl PutBucketEncryptionOutput {
    /// Creates a new builder-style object to manufacture [`PutBucketEncryptionOutput`](crate::output::PutBucketEncryptionOutput)
    pub fn builder() -> crate::output::put_bucket_encryption_output::Builder {
        crate::output::put_bucket_encryption_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutBucketCorsOutput {}
impl std::fmt::Debug for PutBucketCorsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutBucketCorsOutput");
        formatter.finish()
    }
}
/// See [`PutBucketCorsOutput`](crate::output::PutBucketCorsOutput)
pub mod put_bucket_cors_output {
    /// A builder for [`PutBucketCorsOutput`](crate::output::PutBucketCorsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutBucketCorsOutput`](crate::output::PutBucketCorsOutput)
        pub fn build(self) -> crate::output::PutBucketCorsOutput {
            crate::output::PutBucketCorsOutput {}
        }
    }
}
impl PutBucketCorsOutput {
    /// Creates a new builder-style object to manufacture [`PutBucketCorsOutput`](crate::output::PutBucketCorsOutput)
    pub fn builder() -> crate::output::put_bucket_cors_output::Builder {
        crate::output::put_bucket_cors_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutBucketAnalyticsConfigurationOutput {}
impl std::fmt::Debug for PutBucketAnalyticsConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutBucketAnalyticsConfigurationOutput");
        formatter.finish()
    }
}
/// See [`PutBucketAnalyticsConfigurationOutput`](crate::output::PutBucketAnalyticsConfigurationOutput)
pub mod put_bucket_analytics_configuration_output {
    /// A builder for [`PutBucketAnalyticsConfigurationOutput`](crate::output::PutBucketAnalyticsConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutBucketAnalyticsConfigurationOutput`](crate::output::PutBucketAnalyticsConfigurationOutput)
        pub fn build(self) -> crate::output::PutBucketAnalyticsConfigurationOutput {
            crate::output::PutBucketAnalyticsConfigurationOutput {}
        }
    }
}
impl PutBucketAnalyticsConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`PutBucketAnalyticsConfigurationOutput`](crate::output::PutBucketAnalyticsConfigurationOutput)
    pub fn builder() -> crate::output::put_bucket_analytics_configuration_output::Builder {
        crate::output::put_bucket_analytics_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutBucketAclOutput {}
impl std::fmt::Debug for PutBucketAclOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutBucketAclOutput");
        formatter.finish()
    }
}
/// See [`PutBucketAclOutput`](crate::output::PutBucketAclOutput)
pub mod put_bucket_acl_output {
    /// A builder for [`PutBucketAclOutput`](crate::output::PutBucketAclOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutBucketAclOutput`](crate::output::PutBucketAclOutput)
        pub fn build(self) -> crate::output::PutBucketAclOutput {
            crate::output::PutBucketAclOutput {}
        }
    }
}
impl PutBucketAclOutput {
    /// Creates a new builder-style object to manufacture [`PutBucketAclOutput`](crate::output::PutBucketAclOutput)
    pub fn builder() -> crate::output::put_bucket_acl_output::Builder {
        crate::output::put_bucket_acl_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutBucketAccelerateConfigurationOutput {}
impl std::fmt::Debug for PutBucketAccelerateConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutBucketAccelerateConfigurationOutput");
        formatter.finish()
    }
}
/// See [`PutBucketAccelerateConfigurationOutput`](crate::output::PutBucketAccelerateConfigurationOutput)
pub mod put_bucket_accelerate_configuration_output {
    /// A builder for [`PutBucketAccelerateConfigurationOutput`](crate::output::PutBucketAccelerateConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutBucketAccelerateConfigurationOutput`](crate::output::PutBucketAccelerateConfigurationOutput)
        pub fn build(self) -> crate::output::PutBucketAccelerateConfigurationOutput {
            crate::output::PutBucketAccelerateConfigurationOutput {}
        }
    }
}
impl PutBucketAccelerateConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`PutBucketAccelerateConfigurationOutput`](crate::output::PutBucketAccelerateConfigurationOutput)
    pub fn builder() -> crate::output::put_bucket_accelerate_configuration_output::Builder {
        crate::output::put_bucket_accelerate_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPartsOutput {
    /// <p>If the bucket has a lifecycle rule configured with an action to abort incomplete
    /// multipart uploads and the prefix in the lifecycle rule matches the object name in the
    /// request, then the response includes this header indicating when the initiated multipart
    /// upload will become eligible for abort operation. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config">Aborting
    /// Incomplete Multipart Uploads Using a Bucket Lifecycle Policy</a>.</p>
    ///
    /// <p>The response will also include the <code>x-amz-abort-rule-id</code> header that will
    /// provide the ID of the lifecycle configuration rule that defines this action.</p>
    pub abort_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>This header is returned along with the <code>x-amz-abort-date</code> header. It
    /// identifies applicable lifecycle configuration rule that defines the action to abort
    /// incomplete multipart uploads.</p>
    pub abort_rule_id: std::option::Option<std::string::String>,
    /// <p>The name of the bucket to which the multipart upload was initiated. Does not return the access point ARN or access point alias if used.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>Object key for which the multipart upload was initiated.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>Upload ID identifying the multipart upload whose parts are being listed.</p>
    pub upload_id: std::option::Option<std::string::String>,
    /// <p>When a list is truncated, this element specifies the last part in the list, as well as
    /// the value to use for the part-number-marker request parameter in a subsequent
    /// request.</p>
    pub part_number_marker: std::option::Option<std::string::String>,
    /// <p>When a list is truncated, this element specifies the last part in the list, as well as
    /// the value to use for the part-number-marker request parameter in a subsequent
    /// request.</p>
    pub next_part_number_marker: std::option::Option<std::string::String>,
    /// <p>Maximum number of parts that were allowed in the response.</p>
    pub max_parts: i32,
    /// <p> Indicates whether the returned list of parts is truncated. A true value indicates that
    /// the list was truncated. A list can be truncated if the number of parts exceeds the limit
    /// returned in the MaxParts element.</p>
    pub is_truncated: bool,
    /// <p> Container for elements related to a particular part. A response can contain zero or
    /// more <code>Part</code> elements.</p>
    pub parts: std::option::Option<std::vec::Vec<crate::model::Part>>,
    /// <p>Container element that identifies who initiated the multipart upload. If the initiator
    /// is an Amazon Web Services account, this element provides the same information as the <code>Owner</code>
    /// element. If the initiator is an IAM User, this element provides the user ARN and display
    /// name.</p>
    pub initiator: std::option::Option<crate::model::Initiator>,
    /// <p> Container element that identifies the object owner, after the object is created. If
    /// multipart upload is initiated by an IAM user, this element provides the parent account ID
    /// and display name.</p>
    pub owner: std::option::Option<crate::model::Owner>,
    /// <p>Class of storage (STANDARD or REDUCED_REDUNDANCY) used to store the uploaded
    /// object.</p>
    pub storage_class: std::option::Option<crate::model::StorageClass>,
    /// <p>If present, indicates that the requester was successfully charged for the
    /// request.</p>
    pub request_charged: std::option::Option<crate::model::RequestCharged>,
}
impl ListPartsOutput {
    /// <p>If the bucket has a lifecycle rule configured with an action to abort incomplete
    /// multipart uploads and the prefix in the lifecycle rule matches the object name in the
    /// request, then the response includes this header indicating when the initiated multipart
    /// upload will become eligible for abort operation. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config">Aborting
    /// Incomplete Multipart Uploads Using a Bucket Lifecycle Policy</a>.</p>
    ///
    /// <p>The response will also include the <code>x-amz-abort-rule-id</code> header that will
    /// provide the ID of the lifecycle configuration rule that defines this action.</p>
    pub fn abort_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.abort_date.as_ref()
    }
    /// <p>This header is returned along with the <code>x-amz-abort-date</code> header. It
    /// identifies applicable lifecycle configuration rule that defines the action to abort
    /// incomplete multipart uploads.</p>
    pub fn abort_rule_id(&self) -> std::option::Option<&str> {
        self.abort_rule_id.as_deref()
    }
    /// <p>The name of the bucket to which the multipart upload was initiated. Does not return the access point ARN or access point alias if used.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>Object key for which the multipart upload was initiated.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>Upload ID identifying the multipart upload whose parts are being listed.</p>
    pub fn upload_id(&self) -> std::option::Option<&str> {
        self.upload_id.as_deref()
    }
    /// <p>When a list is truncated, this element specifies the last part in the list, as well as
    /// the value to use for the part-number-marker request parameter in a subsequent
    /// request.</p>
    pub fn part_number_marker(&self) -> std::option::Option<&str> {
        self.part_number_marker.as_deref()
    }
    /// <p>When a list is truncated, this element specifies the last part in the list, as well as
    /// the value to use for the part-number-marker request parameter in a subsequent
    /// request.</p>
    pub fn next_part_number_marker(&self) -> std::option::Option<&str> {
        self.next_part_number_marker.as_deref()
    }
    /// <p>Maximum number of parts that were allowed in the response.</p>
    pub fn max_parts(&self) -> i32 {
        self.max_parts
    }
    /// <p> Indicates whether the returned list of parts is truncated. A true value indicates that
    /// the list was truncated. A list can be truncated if the number of parts exceeds the limit
    /// returned in the MaxParts element.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p> Container for elements related to a particular part. A response can contain zero or
    /// more <code>Part</code> elements.</p>
    pub fn parts(&self) -> std::option::Option<&[crate::model::Part]> {
        self.parts.as_deref()
    }
    /// <p>Container element that identifies who initiated the multipart upload. If the initiator
    /// is an Amazon Web Services account, this element provides the same information as the <code>Owner</code>
    /// element. If the initiator is an IAM User, this element provides the user ARN and display
    /// name.</p>
    pub fn initiator(&self) -> std::option::Option<&crate::model::Initiator> {
        self.initiator.as_ref()
    }
    /// <p> Container element that identifies the object owner, after the object is created. If
    /// multipart upload is initiated by an IAM user, this element provides the parent account ID
    /// and display name.</p>
    pub fn owner(&self) -> std::option::Option<&crate::model::Owner> {
        self.owner.as_ref()
    }
    /// <p>Class of storage (STANDARD or REDUCED_REDUNDANCY) used to store the uploaded
    /// object.</p>
    pub fn storage_class(&self) -> std::option::Option<&crate::model::StorageClass> {
        self.storage_class.as_ref()
    }
    /// <p>If present, indicates that the requester was successfully charged for the
    /// request.</p>
    pub fn request_charged(&self) -> std::option::Option<&crate::model::RequestCharged> {
        self.request_charged.as_ref()
    }
}
impl std::fmt::Debug for ListPartsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPartsOutput");
        formatter.field("abort_date", &self.abort_date);
        formatter.field("abort_rule_id", &self.abort_rule_id);
        formatter.field("bucket", &self.bucket);
        formatter.field("key", &self.key);
        formatter.field("upload_id", &self.upload_id);
        formatter.field("part_number_marker", &self.part_number_marker);
        formatter.field("next_part_number_marker", &self.next_part_number_marker);
        formatter.field("max_parts", &self.max_parts);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("parts", &self.parts);
        formatter.field("initiator", &self.initiator);
        formatter.field("owner", &self.owner);
        formatter.field("storage_class", &self.storage_class);
        formatter.field("request_charged", &self.request_charged);
        formatter.finish()
    }
}
/// See [`ListPartsOutput`](crate::output::ListPartsOutput)
pub mod list_parts_output {
    /// A builder for [`ListPartsOutput`](crate::output::ListPartsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) abort_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) abort_rule_id: std::option::Option<std::string::String>,
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) upload_id: std::option::Option<std::string::String>,
        pub(crate) part_number_marker: std::option::Option<std::string::String>,
        pub(crate) next_part_number_marker: std::option::Option<std::string::String>,
        pub(crate) max_parts: std::option::Option<i32>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) parts: std::option::Option<std::vec::Vec<crate::model::Part>>,
        pub(crate) initiator: std::option::Option<crate::model::Initiator>,
        pub(crate) owner: std::option::Option<crate::model::Owner>,
        pub(crate) storage_class: std::option::Option<crate::model::StorageClass>,
        pub(crate) request_charged: std::option::Option<crate::model::RequestCharged>,
    }
    impl Builder {
        /// <p>If the bucket has a lifecycle rule configured with an action to abort incomplete
        /// multipart uploads and the prefix in the lifecycle rule matches the object name in the
        /// request, then the response includes this header indicating when the initiated multipart
        /// upload will become eligible for abort operation. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config">Aborting
        /// Incomplete Multipart Uploads Using a Bucket Lifecycle Policy</a>.</p>
        ///
        /// <p>The response will also include the <code>x-amz-abort-rule-id</code> header that will
        /// provide the ID of the lifecycle configuration rule that defines this action.</p>
        pub fn abort_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.abort_date = Some(input);
            self
        }
        /// <p>If the bucket has a lifecycle rule configured with an action to abort incomplete
        /// multipart uploads and the prefix in the lifecycle rule matches the object name in the
        /// request, then the response includes this header indicating when the initiated multipart
        /// upload will become eligible for abort operation. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config">Aborting
        /// Incomplete Multipart Uploads Using a Bucket Lifecycle Policy</a>.</p>
        ///
        /// <p>The response will also include the <code>x-amz-abort-rule-id</code> header that will
        /// provide the ID of the lifecycle configuration rule that defines this action.</p>
        pub fn set_abort_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.abort_date = input;
            self
        }
        /// <p>This header is returned along with the <code>x-amz-abort-date</code> header. It
        /// identifies applicable lifecycle configuration rule that defines the action to abort
        /// incomplete multipart uploads.</p>
        pub fn abort_rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.abort_rule_id = Some(input.into());
            self
        }
        /// <p>This header is returned along with the <code>x-amz-abort-date</code> header. It
        /// identifies applicable lifecycle configuration rule that defines the action to abort
        /// incomplete multipart uploads.</p>
        pub fn set_abort_rule_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.abort_rule_id = input;
            self
        }
        /// <p>The name of the bucket to which the multipart upload was initiated. Does not return the access point ARN or access point alias if used.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket to which the multipart upload was initiated. Does not return the access point ARN or access point alias if used.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Object key for which the multipart upload was initiated.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>Object key for which the multipart upload was initiated.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>Upload ID identifying the multipart upload whose parts are being listed.</p>
        pub fn upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.upload_id = Some(input.into());
            self
        }
        /// <p>Upload ID identifying the multipart upload whose parts are being listed.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.upload_id = input;
            self
        }
        /// <p>When a list is truncated, this element specifies the last part in the list, as well as
        /// the value to use for the part-number-marker request parameter in a subsequent
        /// request.</p>
        pub fn part_number_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.part_number_marker = Some(input.into());
            self
        }
        /// <p>When a list is truncated, this element specifies the last part in the list, as well as
        /// the value to use for the part-number-marker request parameter in a subsequent
        /// request.</p>
        pub fn set_part_number_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.part_number_marker = input;
            self
        }
        /// <p>When a list is truncated, this element specifies the last part in the list, as well as
        /// the value to use for the part-number-marker request parameter in a subsequent
        /// request.</p>
        pub fn next_part_number_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_part_number_marker = Some(input.into());
            self
        }
        /// <p>When a list is truncated, this element specifies the last part in the list, as well as
        /// the value to use for the part-number-marker request parameter in a subsequent
        /// request.</p>
        pub fn set_next_part_number_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_part_number_marker = input;
            self
        }
        /// <p>Maximum number of parts that were allowed in the response.</p>
        pub fn max_parts(mut self, input: i32) -> Self {
            self.max_parts = Some(input);
            self
        }
        /// <p>Maximum number of parts that were allowed in the response.</p>
        pub fn set_max_parts(mut self, input: std::option::Option<i32>) -> Self {
            self.max_parts = input;
            self
        }
        /// <p> Indicates whether the returned list of parts is truncated. A true value indicates that
        /// the list was truncated. A list can be truncated if the number of parts exceeds the limit
        /// returned in the MaxParts element.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p> Indicates whether the returned list of parts is truncated. A true value indicates that
        /// the list was truncated. A list can be truncated if the number of parts exceeds the limit
        /// returned in the MaxParts element.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// Appends an item to `parts`.
        ///
        /// To override the contents of this collection use [`set_parts`](Self::set_parts).
        ///
        /// <p> Container for elements related to a particular part. A response can contain zero or
        /// more <code>Part</code> elements.</p>
        pub fn parts(mut self, input: impl Into<crate::model::Part>) -> Self {
            let mut v = self.parts.unwrap_or_default();
            v.push(input.into());
            self.parts = Some(v);
            self
        }
        /// <p> Container for elements related to a particular part. A response can contain zero or
        /// more <code>Part</code> elements.</p>
        pub fn set_parts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Part>>,
        ) -> Self {
            self.parts = input;
            self
        }
        /// <p>Container element that identifies who initiated the multipart upload. If the initiator
        /// is an Amazon Web Services account, this element provides the same information as the <code>Owner</code>
        /// element. If the initiator is an IAM User, this element provides the user ARN and display
        /// name.</p>
        pub fn initiator(mut self, input: crate::model::Initiator) -> Self {
            self.initiator = Some(input);
            self
        }
        /// <p>Container element that identifies who initiated the multipart upload. If the initiator
        /// is an Amazon Web Services account, this element provides the same information as the <code>Owner</code>
        /// element. If the initiator is an IAM User, this element provides the user ARN and display
        /// name.</p>
        pub fn set_initiator(
            mut self,
            input: std::option::Option<crate::model::Initiator>,
        ) -> Self {
            self.initiator = input;
            self
        }
        /// <p> Container element that identifies the object owner, after the object is created. If
        /// multipart upload is initiated by an IAM user, this element provides the parent account ID
        /// and display name.</p>
        pub fn owner(mut self, input: crate::model::Owner) -> Self {
            self.owner = Some(input);
            self
        }
        /// <p> Container element that identifies the object owner, after the object is created. If
        /// multipart upload is initiated by an IAM user, this element provides the parent account ID
        /// and display name.</p>
        pub fn set_owner(mut self, input: std::option::Option<crate::model::Owner>) -> Self {
            self.owner = input;
            self
        }
        /// <p>Class of storage (STANDARD or REDUCED_REDUNDANCY) used to store the uploaded
        /// object.</p>
        pub fn storage_class(mut self, input: crate::model::StorageClass) -> Self {
            self.storage_class = Some(input);
            self
        }
        /// <p>Class of storage (STANDARD or REDUCED_REDUNDANCY) used to store the uploaded
        /// object.</p>
        pub fn set_storage_class(
            mut self,
            input: std::option::Option<crate::model::StorageClass>,
        ) -> Self {
            self.storage_class = input;
            self
        }
        /// <p>If present, indicates that the requester was successfully charged for the
        /// request.</p>
        pub fn request_charged(mut self, input: crate::model::RequestCharged) -> Self {
            self.request_charged = Some(input);
            self
        }
        /// <p>If present, indicates that the requester was successfully charged for the
        /// request.</p>
        pub fn set_request_charged(
            mut self,
            input: std::option::Option<crate::model::RequestCharged>,
        ) -> Self {
            self.request_charged = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPartsOutput`](crate::output::ListPartsOutput)
        pub fn build(self) -> crate::output::ListPartsOutput {
            crate::output::ListPartsOutput {
                abort_date: self.abort_date,
                abort_rule_id: self.abort_rule_id,
                bucket: self.bucket,
                key: self.key,
                upload_id: self.upload_id,
                part_number_marker: self.part_number_marker,
                next_part_number_marker: self.next_part_number_marker,
                max_parts: self.max_parts.unwrap_or_default(),
                is_truncated: self.is_truncated.unwrap_or_default(),
                parts: self.parts,
                initiator: self.initiator,
                owner: self.owner,
                storage_class: self.storage_class,
                request_charged: self.request_charged,
            }
        }
    }
}
impl ListPartsOutput {
    /// Creates a new builder-style object to manufacture [`ListPartsOutput`](crate::output::ListPartsOutput)
    pub fn builder() -> crate::output::list_parts_output::Builder {
        crate::output::list_parts_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListObjectVersionsOutput {
    /// <p>A flag that indicates whether Amazon S3 returned all of the results that satisfied the search
    /// criteria. If your results were truncated, you can make a follow-up paginated request using
    /// the NextKeyMarker and NextVersionIdMarker response parameters as a starting place in
    /// another request to return the rest of the results.</p>
    pub is_truncated: bool,
    /// <p>Marks the last key returned in a truncated response.</p>
    pub key_marker: std::option::Option<std::string::String>,
    /// <p>Marks the last version of the key returned in a truncated response.</p>
    pub version_id_marker: std::option::Option<std::string::String>,
    /// <p>When the number of responses exceeds the value of <code>MaxKeys</code>,
    /// <code>NextKeyMarker</code> specifies the first key not returned that satisfies the
    /// search criteria. Use this value for the key-marker request parameter in a subsequent
    /// request.</p>
    pub next_key_marker: std::option::Option<std::string::String>,
    /// <p>When the number of responses exceeds the value of <code>MaxKeys</code>,
    /// <code>NextVersionIdMarker</code> specifies the first object version not returned that
    /// satisfies the search criteria. Use this value for the version-id-marker request parameter
    /// in a subsequent request.</p>
    pub next_version_id_marker: std::option::Option<std::string::String>,
    /// <p>Container for version information.</p>
    pub versions: std::option::Option<std::vec::Vec<crate::model::ObjectVersion>>,
    /// <p>Container for an object that is a delete marker.</p>
    pub delete_markers: std::option::Option<std::vec::Vec<crate::model::DeleteMarkerEntry>>,
    /// <p>The bucket name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Selects objects that start with the value supplied by this parameter.</p>
    pub prefix: std::option::Option<std::string::String>,
    /// <p>The delimiter grouping the included keys. A delimiter is a character that you specify to
    /// group keys. All keys that contain the same string between the prefix and the first
    /// occurrence of the delimiter are grouped under a single result element in
    /// <code>CommonPrefixes</code>. These groups are counted as one result against the max-keys
    /// limitation. These keys are not returned elsewhere in the response.</p>
    pub delimiter: std::option::Option<std::string::String>,
    /// <p>Specifies the maximum number of objects to return.</p>
    pub max_keys: i32,
    /// <p>All of the keys rolled up into a common prefix count as a single return when calculating
    /// the number of returns.</p>
    pub common_prefixes: std::option::Option<std::vec::Vec<crate::model::CommonPrefix>>,
    /// <p> Encoding type used by Amazon S3 to encode object key names in the XML response.</p>
    ///
    /// <p>If you specify encoding-type request parameter, Amazon S3 includes this element in the
    /// response, and returns encoded key name values in the following response elements:</p>
    ///
    /// <p>
    /// <code>KeyMarker, NextKeyMarker, Prefix, Key</code>, and <code>Delimiter</code>.</p>
    pub encoding_type: std::option::Option<crate::model::EncodingType>,
}
impl ListObjectVersionsOutput {
    /// <p>A flag that indicates whether Amazon S3 returned all of the results that satisfied the search
    /// criteria. If your results were truncated, you can make a follow-up paginated request using
    /// the NextKeyMarker and NextVersionIdMarker response parameters as a starting place in
    /// another request to return the rest of the results.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>Marks the last key returned in a truncated response.</p>
    pub fn key_marker(&self) -> std::option::Option<&str> {
        self.key_marker.as_deref()
    }
    /// <p>Marks the last version of the key returned in a truncated response.</p>
    pub fn version_id_marker(&self) -> std::option::Option<&str> {
        self.version_id_marker.as_deref()
    }
    /// <p>When the number of responses exceeds the value of <code>MaxKeys</code>,
    /// <code>NextKeyMarker</code> specifies the first key not returned that satisfies the
    /// search criteria. Use this value for the key-marker request parameter in a subsequent
    /// request.</p>
    pub fn next_key_marker(&self) -> std::option::Option<&str> {
        self.next_key_marker.as_deref()
    }
    /// <p>When the number of responses exceeds the value of <code>MaxKeys</code>,
    /// <code>NextVersionIdMarker</code> specifies the first object version not returned that
    /// satisfies the search criteria. Use this value for the version-id-marker request parameter
    /// in a subsequent request.</p>
    pub fn next_version_id_marker(&self) -> std::option::Option<&str> {
        self.next_version_id_marker.as_deref()
    }
    /// <p>Container for version information.</p>
    pub fn versions(&self) -> std::option::Option<&[crate::model::ObjectVersion]> {
        self.versions.as_deref()
    }
    /// <p>Container for an object that is a delete marker.</p>
    pub fn delete_markers(&self) -> std::option::Option<&[crate::model::DeleteMarkerEntry]> {
        self.delete_markers.as_deref()
    }
    /// <p>The bucket name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Selects objects that start with the value supplied by this parameter.</p>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
    /// <p>The delimiter grouping the included keys. A delimiter is a character that you specify to
    /// group keys. All keys that contain the same string between the prefix and the first
    /// occurrence of the delimiter are grouped under a single result element in
    /// <code>CommonPrefixes</code>. These groups are counted as one result against the max-keys
    /// limitation. These keys are not returned elsewhere in the response.</p>
    pub fn delimiter(&self) -> std::option::Option<&str> {
        self.delimiter.as_deref()
    }
    /// <p>Specifies the maximum number of objects to return.</p>
    pub fn max_keys(&self) -> i32 {
        self.max_keys
    }
    /// <p>All of the keys rolled up into a common prefix count as a single return when calculating
    /// the number of returns.</p>
    pub fn common_prefixes(&self) -> std::option::Option<&[crate::model::CommonPrefix]> {
        self.common_prefixes.as_deref()
    }
    /// <p> Encoding type used by Amazon S3 to encode object key names in the XML response.</p>
    ///
    /// <p>If you specify encoding-type request parameter, Amazon S3 includes this element in the
    /// response, and returns encoded key name values in the following response elements:</p>
    ///
    /// <p>
    /// <code>KeyMarker, NextKeyMarker, Prefix, Key</code>, and <code>Delimiter</code>.</p>
    pub fn encoding_type(&self) -> std::option::Option<&crate::model::EncodingType> {
        self.encoding_type.as_ref()
    }
}
impl std::fmt::Debug for ListObjectVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListObjectVersionsOutput");
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("key_marker", &self.key_marker);
        formatter.field("version_id_marker", &self.version_id_marker);
        formatter.field("next_key_marker", &self.next_key_marker);
        formatter.field("next_version_id_marker", &self.next_version_id_marker);
        formatter.field("versions", &self.versions);
        formatter.field("delete_markers", &self.delete_markers);
        formatter.field("name", &self.name);
        formatter.field("prefix", &self.prefix);
        formatter.field("delimiter", &self.delimiter);
        formatter.field("max_keys", &self.max_keys);
        formatter.field("common_prefixes", &self.common_prefixes);
        formatter.field("encoding_type", &self.encoding_type);
        formatter.finish()
    }
}
/// See [`ListObjectVersionsOutput`](crate::output::ListObjectVersionsOutput)
pub mod list_object_versions_output {
    /// A builder for [`ListObjectVersionsOutput`](crate::output::ListObjectVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) key_marker: std::option::Option<std::string::String>,
        pub(crate) version_id_marker: std::option::Option<std::string::String>,
        pub(crate) next_key_marker: std::option::Option<std::string::String>,
        pub(crate) next_version_id_marker: std::option::Option<std::string::String>,
        pub(crate) versions: std::option::Option<std::vec::Vec<crate::model::ObjectVersion>>,
        pub(crate) delete_markers:
            std::option::Option<std::vec::Vec<crate::model::DeleteMarkerEntry>>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) delimiter: std::option::Option<std::string::String>,
        pub(crate) max_keys: std::option::Option<i32>,
        pub(crate) common_prefixes: std::option::Option<std::vec::Vec<crate::model::CommonPrefix>>,
        pub(crate) encoding_type: std::option::Option<crate::model::EncodingType>,
    }
    impl Builder {
        /// <p>A flag that indicates whether Amazon S3 returned all of the results that satisfied the search
        /// criteria. If your results were truncated, you can make a follow-up paginated request using
        /// the NextKeyMarker and NextVersionIdMarker response parameters as a starting place in
        /// another request to return the rest of the results.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether Amazon S3 returned all of the results that satisfied the search
        /// criteria. If your results were truncated, you can make a follow-up paginated request using
        /// the NextKeyMarker and NextVersionIdMarker response parameters as a starting place in
        /// another request to return the rest of the results.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>Marks the last key returned in a truncated response.</p>
        pub fn key_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_marker = Some(input.into());
            self
        }
        /// <p>Marks the last key returned in a truncated response.</p>
        pub fn set_key_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_marker = input;
            self
        }
        /// <p>Marks the last version of the key returned in a truncated response.</p>
        pub fn version_id_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id_marker = Some(input.into());
            self
        }
        /// <p>Marks the last version of the key returned in a truncated response.</p>
        pub fn set_version_id_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.version_id_marker = input;
            self
        }
        /// <p>When the number of responses exceeds the value of <code>MaxKeys</code>,
        /// <code>NextKeyMarker</code> specifies the first key not returned that satisfies the
        /// search criteria. Use this value for the key-marker request parameter in a subsequent
        /// request.</p>
        pub fn next_key_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_key_marker = Some(input.into());
            self
        }
        /// <p>When the number of responses exceeds the value of <code>MaxKeys</code>,
        /// <code>NextKeyMarker</code> specifies the first key not returned that satisfies the
        /// search criteria. Use this value for the key-marker request parameter in a subsequent
        /// request.</p>
        pub fn set_next_key_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_key_marker = input;
            self
        }
        /// <p>When the number of responses exceeds the value of <code>MaxKeys</code>,
        /// <code>NextVersionIdMarker</code> specifies the first object version not returned that
        /// satisfies the search criteria. Use this value for the version-id-marker request parameter
        /// in a subsequent request.</p>
        pub fn next_version_id_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_version_id_marker = Some(input.into());
            self
        }
        /// <p>When the number of responses exceeds the value of <code>MaxKeys</code>,
        /// <code>NextVersionIdMarker</code> specifies the first object version not returned that
        /// satisfies the search criteria. Use this value for the version-id-marker request parameter
        /// in a subsequent request.</p>
        pub fn set_next_version_id_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_version_id_marker = input;
            self
        }
        /// Appends an item to `versions`.
        ///
        /// To override the contents of this collection use [`set_versions`](Self::set_versions).
        ///
        /// <p>Container for version information.</p>
        pub fn versions(mut self, input: impl Into<crate::model::ObjectVersion>) -> Self {
            let mut v = self.versions.unwrap_or_default();
            v.push(input.into());
            self.versions = Some(v);
            self
        }
        /// <p>Container for version information.</p>
        pub fn set_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ObjectVersion>>,
        ) -> Self {
            self.versions = input;
            self
        }
        /// Appends an item to `delete_markers`.
        ///
        /// To override the contents of this collection use [`set_delete_markers`](Self::set_delete_markers).
        ///
        /// <p>Container for an object that is a delete marker.</p>
        pub fn delete_markers(mut self, input: impl Into<crate::model::DeleteMarkerEntry>) -> Self {
            let mut v = self.delete_markers.unwrap_or_default();
            v.push(input.into());
            self.delete_markers = Some(v);
            self
        }
        /// <p>Container for an object that is a delete marker.</p>
        pub fn set_delete_markers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeleteMarkerEntry>>,
        ) -> Self {
            self.delete_markers = input;
            self
        }
        /// <p>The bucket name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The bucket name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Selects objects that start with the value supplied by this parameter.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>Selects objects that start with the value supplied by this parameter.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// <p>The delimiter grouping the included keys. A delimiter is a character that you specify to
        /// group keys. All keys that contain the same string between the prefix and the first
        /// occurrence of the delimiter are grouped under a single result element in
        /// <code>CommonPrefixes</code>. These groups are counted as one result against the max-keys
        /// limitation. These keys are not returned elsewhere in the response.</p>
        pub fn delimiter(mut self, input: impl Into<std::string::String>) -> Self {
            self.delimiter = Some(input.into());
            self
        }
        /// <p>The delimiter grouping the included keys. A delimiter is a character that you specify to
        /// group keys. All keys that contain the same string between the prefix and the first
        /// occurrence of the delimiter are grouped under a single result element in
        /// <code>CommonPrefixes</code>. These groups are counted as one result against the max-keys
        /// limitation. These keys are not returned elsewhere in the response.</p>
        pub fn set_delimiter(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.delimiter = input;
            self
        }
        /// <p>Specifies the maximum number of objects to return.</p>
        pub fn max_keys(mut self, input: i32) -> Self {
            self.max_keys = Some(input);
            self
        }
        /// <p>Specifies the maximum number of objects to return.</p>
        pub fn set_max_keys(mut self, input: std::option::Option<i32>) -> Self {
            self.max_keys = input;
            self
        }
        /// Appends an item to `common_prefixes`.
        ///
        /// To override the contents of this collection use [`set_common_prefixes`](Self::set_common_prefixes).
        ///
        /// <p>All of the keys rolled up into a common prefix count as a single return when calculating
        /// the number of returns.</p>
        pub fn common_prefixes(mut self, input: impl Into<crate::model::CommonPrefix>) -> Self {
            let mut v = self.common_prefixes.unwrap_or_default();
            v.push(input.into());
            self.common_prefixes = Some(v);
            self
        }
        /// <p>All of the keys rolled up into a common prefix count as a single return when calculating
        /// the number of returns.</p>
        pub fn set_common_prefixes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CommonPrefix>>,
        ) -> Self {
            self.common_prefixes = input;
            self
        }
        /// <p> Encoding type used by Amazon S3 to encode object key names in the XML response.</p>
        ///
        /// <p>If you specify encoding-type request parameter, Amazon S3 includes this element in the
        /// response, and returns encoded key name values in the following response elements:</p>
        ///
        /// <p>
        /// <code>KeyMarker, NextKeyMarker, Prefix, Key</code>, and <code>Delimiter</code>.</p>
        pub fn encoding_type(mut self, input: crate::model::EncodingType) -> Self {
            self.encoding_type = Some(input);
            self
        }
        /// <p> Encoding type used by Amazon S3 to encode object key names in the XML response.</p>
        ///
        /// <p>If you specify encoding-type request parameter, Amazon S3 includes this element in the
        /// response, and returns encoded key name values in the following response elements:</p>
        ///
        /// <p>
        /// <code>KeyMarker, NextKeyMarker, Prefix, Key</code>, and <code>Delimiter</code>.</p>
        pub fn set_encoding_type(
            mut self,
            input: std::option::Option<crate::model::EncodingType>,
        ) -> Self {
            self.encoding_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ListObjectVersionsOutput`](crate::output::ListObjectVersionsOutput)
        pub fn build(self) -> crate::output::ListObjectVersionsOutput {
            crate::output::ListObjectVersionsOutput {
                is_truncated: self.is_truncated.unwrap_or_default(),
                key_marker: self.key_marker,
                version_id_marker: self.version_id_marker,
                next_key_marker: self.next_key_marker,
                next_version_id_marker: self.next_version_id_marker,
                versions: self.versions,
                delete_markers: self.delete_markers,
                name: self.name,
                prefix: self.prefix,
                delimiter: self.delimiter,
                max_keys: self.max_keys.unwrap_or_default(),
                common_prefixes: self.common_prefixes,
                encoding_type: self.encoding_type,
            }
        }
    }
}
impl ListObjectVersionsOutput {
    /// Creates a new builder-style object to manufacture [`ListObjectVersionsOutput`](crate::output::ListObjectVersionsOutput)
    pub fn builder() -> crate::output::list_object_versions_output::Builder {
        crate::output::list_object_versions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListObjectsV2Output {
    /// <p>Set to false if all of the results were returned. Set to true if more keys are available
    /// to return. If the number of results exceeds that specified by MaxKeys, all of the results
    /// might not be returned.</p>
    pub is_truncated: bool,
    /// <p>Metadata about each object returned.</p>
    pub contents: std::option::Option<std::vec::Vec<crate::model::Object>>,
    /// <p>The bucket name.</p>
    /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p> Keys that begin with the indicated prefix.</p>
    pub prefix: std::option::Option<std::string::String>,
    /// <p>Causes keys that contain the same string between the prefix and the first occurrence of
    /// the delimiter to be rolled up into a single result element in the CommonPrefixes
    /// collection. These rolled-up keys are not returned elsewhere in the response. Each rolled-up
    /// result counts as only one return against the <code>MaxKeys</code> value.</p>
    pub delimiter: std::option::Option<std::string::String>,
    /// <p>Sets the maximum number of keys returned in the response. By default the action returns up
    /// to 1,000 key names. The response might contain fewer keys but will never contain
    /// more.</p>
    pub max_keys: i32,
    /// <p>All of the keys (up to 1,000) rolled up into a common prefix count as a single return when calculating
    /// the number of returns.</p>
    ///
    /// <p>A response can contain <code>CommonPrefixes</code> only if you specify a
    /// delimiter.</p>
    ///
    /// <p>
    /// <code>CommonPrefixes</code> contains all (if there are any) keys between
    /// <code>Prefix</code> and the next occurrence of the string specified by a
    /// delimiter.</p>
    ///
    /// <p>
    /// <code>CommonPrefixes</code> lists keys that act like subdirectories in the directory
    /// specified by <code>Prefix</code>.</p>
    ///
    /// <p>For example, if the prefix is <code>notes/</code> and the delimiter is a slash
    /// (<code>/</code>) as in <code>notes/summer/july</code>, the common prefix is
    /// <code>notes/summer/</code>. All of the keys that roll up into a common prefix count as a
    /// single return when calculating the number of returns. </p>
    pub common_prefixes: std::option::Option<std::vec::Vec<crate::model::CommonPrefix>>,
    /// <p>Encoding type used by Amazon S3 to encode object key names in the XML response.</p>
    ///
    /// <p>If you specify the encoding-type request parameter, Amazon S3 includes this element in the
    /// response, and returns encoded key name values in the following response elements:</p>
    ///
    /// <p>
    /// <code>Delimiter, Prefix, Key,</code> and <code>StartAfter</code>.</p>
    pub encoding_type: std::option::Option<crate::model::EncodingType>,
    /// <p>KeyCount is the number of keys returned with this request. KeyCount will always be less
    /// than or equals to MaxKeys field. Say you ask for 50 keys, your result will include less than
    /// equals 50 keys </p>
    pub key_count: i32,
    /// <p> If ContinuationToken was sent with the request, it is included in the response.</p>
    pub continuation_token: std::option::Option<std::string::String>,
    /// <p>
    /// <code>NextContinuationToken</code> is sent when <code>isTruncated</code> is true, which
    /// means there are more keys in the bucket that can be listed. The next list requests to Amazon S3
    /// can be continued with this <code>NextContinuationToken</code>.
    /// <code>NextContinuationToken</code> is obfuscated and is not a real key</p>
    pub next_continuation_token: std::option::Option<std::string::String>,
    /// <p>If StartAfter was sent with the request, it is included in the response.</p>
    pub start_after: std::option::Option<std::string::String>,
}
impl ListObjectsV2Output {
    /// <p>Set to false if all of the results were returned. Set to true if more keys are available
    /// to return. If the number of results exceeds that specified by MaxKeys, all of the results
    /// might not be returned.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>Metadata about each object returned.</p>
    pub fn contents(&self) -> std::option::Option<&[crate::model::Object]> {
        self.contents.as_deref()
    }
    /// <p>The bucket name.</p>
    /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> Keys that begin with the indicated prefix.</p>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
    /// <p>Causes keys that contain the same string between the prefix and the first occurrence of
    /// the delimiter to be rolled up into a single result element in the CommonPrefixes
    /// collection. These rolled-up keys are not returned elsewhere in the response. Each rolled-up
    /// result counts as only one return against the <code>MaxKeys</code> value.</p>
    pub fn delimiter(&self) -> std::option::Option<&str> {
        self.delimiter.as_deref()
    }
    /// <p>Sets the maximum number of keys returned in the response. By default the action returns up
    /// to 1,000 key names. The response might contain fewer keys but will never contain
    /// more.</p>
    pub fn max_keys(&self) -> i32 {
        self.max_keys
    }
    /// <p>All of the keys (up to 1,000) rolled up into a common prefix count as a single return when calculating
    /// the number of returns.</p>
    ///
    /// <p>A response can contain <code>CommonPrefixes</code> only if you specify a
    /// delimiter.</p>
    ///
    /// <p>
    /// <code>CommonPrefixes</code> contains all (if there are any) keys between
    /// <code>Prefix</code> and the next occurrence of the string specified by a
    /// delimiter.</p>
    ///
    /// <p>
    /// <code>CommonPrefixes</code> lists keys that act like subdirectories in the directory
    /// specified by <code>Prefix</code>.</p>
    ///
    /// <p>For example, if the prefix is <code>notes/</code> and the delimiter is a slash
    /// (<code>/</code>) as in <code>notes/summer/july</code>, the common prefix is
    /// <code>notes/summer/</code>. All of the keys that roll up into a common prefix count as a
    /// single return when calculating the number of returns. </p>
    pub fn common_prefixes(&self) -> std::option::Option<&[crate::model::CommonPrefix]> {
        self.common_prefixes.as_deref()
    }
    /// <p>Encoding type used by Amazon S3 to encode object key names in the XML response.</p>
    ///
    /// <p>If you specify the encoding-type request parameter, Amazon S3 includes this element in the
    /// response, and returns encoded key name values in the following response elements:</p>
    ///
    /// <p>
    /// <code>Delimiter, Prefix, Key,</code> and <code>StartAfter</code>.</p>
    pub fn encoding_type(&self) -> std::option::Option<&crate::model::EncodingType> {
        self.encoding_type.as_ref()
    }
    /// <p>KeyCount is the number of keys returned with this request. KeyCount will always be less
    /// than or equals to MaxKeys field. Say you ask for 50 keys, your result will include less than
    /// equals 50 keys </p>
    pub fn key_count(&self) -> i32 {
        self.key_count
    }
    /// <p> If ContinuationToken was sent with the request, it is included in the response.</p>
    pub fn continuation_token(&self) -> std::option::Option<&str> {
        self.continuation_token.as_deref()
    }
    /// <p>
    /// <code>NextContinuationToken</code> is sent when <code>isTruncated</code> is true, which
    /// means there are more keys in the bucket that can be listed. The next list requests to Amazon S3
    /// can be continued with this <code>NextContinuationToken</code>.
    /// <code>NextContinuationToken</code> is obfuscated and is not a real key</p>
    pub fn next_continuation_token(&self) -> std::option::Option<&str> {
        self.next_continuation_token.as_deref()
    }
    /// <p>If StartAfter was sent with the request, it is included in the response.</p>
    pub fn start_after(&self) -> std::option::Option<&str> {
        self.start_after.as_deref()
    }
}
impl std::fmt::Debug for ListObjectsV2Output {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListObjectsV2Output");
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("contents", &self.contents);
        formatter.field("name", &self.name);
        formatter.field("prefix", &self.prefix);
        formatter.field("delimiter", &self.delimiter);
        formatter.field("max_keys", &self.max_keys);
        formatter.field("common_prefixes", &self.common_prefixes);
        formatter.field("encoding_type", &self.encoding_type);
        formatter.field("key_count", &self.key_count);
        formatter.field("continuation_token", &self.continuation_token);
        formatter.field("next_continuation_token", &self.next_continuation_token);
        formatter.field("start_after", &self.start_after);
        formatter.finish()
    }
}
/// See [`ListObjectsV2Output`](crate::output::ListObjectsV2Output)
pub mod list_objects_v2_output {
    /// A builder for [`ListObjectsV2Output`](crate::output::ListObjectsV2Output)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) contents: std::option::Option<std::vec::Vec<crate::model::Object>>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) delimiter: std::option::Option<std::string::String>,
        pub(crate) max_keys: std::option::Option<i32>,
        pub(crate) common_prefixes: std::option::Option<std::vec::Vec<crate::model::CommonPrefix>>,
        pub(crate) encoding_type: std::option::Option<crate::model::EncodingType>,
        pub(crate) key_count: std::option::Option<i32>,
        pub(crate) continuation_token: std::option::Option<std::string::String>,
        pub(crate) next_continuation_token: std::option::Option<std::string::String>,
        pub(crate) start_after: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Set to false if all of the results were returned. Set to true if more keys are available
        /// to return. If the number of results exceeds that specified by MaxKeys, all of the results
        /// might not be returned.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>Set to false if all of the results were returned. Set to true if more keys are available
        /// to return. If the number of results exceeds that specified by MaxKeys, all of the results
        /// might not be returned.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// Appends an item to `contents`.
        ///
        /// To override the contents of this collection use [`set_contents`](Self::set_contents).
        ///
        /// <p>Metadata about each object returned.</p>
        pub fn contents(mut self, input: impl Into<crate::model::Object>) -> Self {
            let mut v = self.contents.unwrap_or_default();
            v.push(input.into());
            self.contents = Some(v);
            self
        }
        /// <p>Metadata about each object returned.</p>
        pub fn set_contents(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Object>>,
        ) -> Self {
            self.contents = input;
            self
        }
        /// <p>The bucket name.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The bucket name.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> Keys that begin with the indicated prefix.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p> Keys that begin with the indicated prefix.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// <p>Causes keys that contain the same string between the prefix and the first occurrence of
        /// the delimiter to be rolled up into a single result element in the CommonPrefixes
        /// collection. These rolled-up keys are not returned elsewhere in the response. Each rolled-up
        /// result counts as only one return against the <code>MaxKeys</code> value.</p>
        pub fn delimiter(mut self, input: impl Into<std::string::String>) -> Self {
            self.delimiter = Some(input.into());
            self
        }
        /// <p>Causes keys that contain the same string between the prefix and the first occurrence of
        /// the delimiter to be rolled up into a single result element in the CommonPrefixes
        /// collection. These rolled-up keys are not returned elsewhere in the response. Each rolled-up
        /// result counts as only one return against the <code>MaxKeys</code> value.</p>
        pub fn set_delimiter(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.delimiter = input;
            self
        }
        /// <p>Sets the maximum number of keys returned in the response. By default the action returns up
        /// to 1,000 key names. The response might contain fewer keys but will never contain
        /// more.</p>
        pub fn max_keys(mut self, input: i32) -> Self {
            self.max_keys = Some(input);
            self
        }
        /// <p>Sets the maximum number of keys returned in the response. By default the action returns up
        /// to 1,000 key names. The response might contain fewer keys but will never contain
        /// more.</p>
        pub fn set_max_keys(mut self, input: std::option::Option<i32>) -> Self {
            self.max_keys = input;
            self
        }
        /// Appends an item to `common_prefixes`.
        ///
        /// To override the contents of this collection use [`set_common_prefixes`](Self::set_common_prefixes).
        ///
        /// <p>All of the keys (up to 1,000) rolled up into a common prefix count as a single return when calculating
        /// the number of returns.</p>
        ///
        /// <p>A response can contain <code>CommonPrefixes</code> only if you specify a
        /// delimiter.</p>
        ///
        /// <p>
        /// <code>CommonPrefixes</code> contains all (if there are any) keys between
        /// <code>Prefix</code> and the next occurrence of the string specified by a
        /// delimiter.</p>
        ///
        /// <p>
        /// <code>CommonPrefixes</code> lists keys that act like subdirectories in the directory
        /// specified by <code>Prefix</code>.</p>
        ///
        /// <p>For example, if the prefix is <code>notes/</code> and the delimiter is a slash
        /// (<code>/</code>) as in <code>notes/summer/july</code>, the common prefix is
        /// <code>notes/summer/</code>. All of the keys that roll up into a common prefix count as a
        /// single return when calculating the number of returns. </p>
        pub fn common_prefixes(mut self, input: impl Into<crate::model::CommonPrefix>) -> Self {
            let mut v = self.common_prefixes.unwrap_or_default();
            v.push(input.into());
            self.common_prefixes = Some(v);
            self
        }
        /// <p>All of the keys (up to 1,000) rolled up into a common prefix count as a single return when calculating
        /// the number of returns.</p>
        ///
        /// <p>A response can contain <code>CommonPrefixes</code> only if you specify a
        /// delimiter.</p>
        ///
        /// <p>
        /// <code>CommonPrefixes</code> contains all (if there are any) keys between
        /// <code>Prefix</code> and the next occurrence of the string specified by a
        /// delimiter.</p>
        ///
        /// <p>
        /// <code>CommonPrefixes</code> lists keys that act like subdirectories in the directory
        /// specified by <code>Prefix</code>.</p>
        ///
        /// <p>For example, if the prefix is <code>notes/</code> and the delimiter is a slash
        /// (<code>/</code>) as in <code>notes/summer/july</code>, the common prefix is
        /// <code>notes/summer/</code>. All of the keys that roll up into a common prefix count as a
        /// single return when calculating the number of returns. </p>
        pub fn set_common_prefixes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CommonPrefix>>,
        ) -> Self {
            self.common_prefixes = input;
            self
        }
        /// <p>Encoding type used by Amazon S3 to encode object key names in the XML response.</p>
        ///
        /// <p>If you specify the encoding-type request parameter, Amazon S3 includes this element in the
        /// response, and returns encoded key name values in the following response elements:</p>
        ///
        /// <p>
        /// <code>Delimiter, Prefix, Key,</code> and <code>StartAfter</code>.</p>
        pub fn encoding_type(mut self, input: crate::model::EncodingType) -> Self {
            self.encoding_type = Some(input);
            self
        }
        /// <p>Encoding type used by Amazon S3 to encode object key names in the XML response.</p>
        ///
        /// <p>If you specify the encoding-type request parameter, Amazon S3 includes this element in the
        /// response, and returns encoded key name values in the following response elements:</p>
        ///
        /// <p>
        /// <code>Delimiter, Prefix, Key,</code> and <code>StartAfter</code>.</p>
        pub fn set_encoding_type(
            mut self,
            input: std::option::Option<crate::model::EncodingType>,
        ) -> Self {
            self.encoding_type = input;
            self
        }
        /// <p>KeyCount is the number of keys returned with this request. KeyCount will always be less
        /// than or equals to MaxKeys field. Say you ask for 50 keys, your result will include less than
        /// equals 50 keys </p>
        pub fn key_count(mut self, input: i32) -> Self {
            self.key_count = Some(input);
            self
        }
        /// <p>KeyCount is the number of keys returned with this request. KeyCount will always be less
        /// than or equals to MaxKeys field. Say you ask for 50 keys, your result will include less than
        /// equals 50 keys </p>
        pub fn set_key_count(mut self, input: std::option::Option<i32>) -> Self {
            self.key_count = input;
            self
        }
        /// <p> If ContinuationToken was sent with the request, it is included in the response.</p>
        pub fn continuation_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.continuation_token = Some(input.into());
            self
        }
        /// <p> If ContinuationToken was sent with the request, it is included in the response.</p>
        pub fn set_continuation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.continuation_token = input;
            self
        }
        /// <p>
        /// <code>NextContinuationToken</code> is sent when <code>isTruncated</code> is true, which
        /// means there are more keys in the bucket that can be listed. The next list requests to Amazon S3
        /// can be continued with this <code>NextContinuationToken</code>.
        /// <code>NextContinuationToken</code> is obfuscated and is not a real key</p>
        pub fn next_continuation_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_continuation_token = Some(input.into());
            self
        }
        /// <p>
        /// <code>NextContinuationToken</code> is sent when <code>isTruncated</code> is true, which
        /// means there are more keys in the bucket that can be listed. The next list requests to Amazon S3
        /// can be continued with this <code>NextContinuationToken</code>.
        /// <code>NextContinuationToken</code> is obfuscated and is not a real key</p>
        pub fn set_next_continuation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_continuation_token = input;
            self
        }
        /// <p>If StartAfter was sent with the request, it is included in the response.</p>
        pub fn start_after(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_after = Some(input.into());
            self
        }
        /// <p>If StartAfter was sent with the request, it is included in the response.</p>
        pub fn set_start_after(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.start_after = input;
            self
        }
        /// Consumes the builder and constructs a [`ListObjectsV2Output`](crate::output::ListObjectsV2Output)
        pub fn build(self) -> crate::output::ListObjectsV2Output {
            crate::output::ListObjectsV2Output {
                is_truncated: self.is_truncated.unwrap_or_default(),
                contents: self.contents,
                name: self.name,
                prefix: self.prefix,
                delimiter: self.delimiter,
                max_keys: self.max_keys.unwrap_or_default(),
                common_prefixes: self.common_prefixes,
                encoding_type: self.encoding_type,
                key_count: self.key_count.unwrap_or_default(),
                continuation_token: self.continuation_token,
                next_continuation_token: self.next_continuation_token,
                start_after: self.start_after,
            }
        }
    }
}
impl ListObjectsV2Output {
    /// Creates a new builder-style object to manufacture [`ListObjectsV2Output`](crate::output::ListObjectsV2Output)
    pub fn builder() -> crate::output::list_objects_v2_output::Builder {
        crate::output::list_objects_v2_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListObjectsOutput {
    /// <p>A flag that indicates whether Amazon S3 returned all of the results that satisfied the search
    /// criteria.</p>
    pub is_truncated: bool,
    /// <p>Indicates where in the bucket listing begins. Marker is included in the response if it
    /// was sent with the request.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>When response is truncated (the IsTruncated element value in the response is true), you
    /// can use the key name in this field as marker in the subsequent request to get next set of
    /// objects. Amazon S3 lists objects in alphabetical order Note: This element is returned only if
    /// you have delimiter request parameter specified. If response does not include the NextMarker
    /// and it is truncated, you can use the value of the last Key in the response as the marker in
    /// the subsequent request to get the next set of object keys.</p>
    pub next_marker: std::option::Option<std::string::String>,
    /// <p>Metadata about each object returned.</p>
    pub contents: std::option::Option<std::vec::Vec<crate::model::Object>>,
    /// <p>The bucket name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Keys that begin with the indicated prefix.</p>
    pub prefix: std::option::Option<std::string::String>,
    /// <p>Causes keys that contain the same string between the prefix and the first occurrence of
    /// the delimiter to be rolled up into a single result element in the
    /// <code>CommonPrefixes</code> collection. These rolled-up keys are not returned elsewhere
    /// in the response. Each rolled-up result counts as only one return against the
    /// <code>MaxKeys</code> value.</p>
    pub delimiter: std::option::Option<std::string::String>,
    /// <p>The maximum number of keys returned in the response body.</p>
    pub max_keys: i32,
    /// <p>All of the keys (up to 1,000) rolled up in a common prefix count as a single return when calculating
    /// the number of returns. </p>
    ///
    /// <p>A response can contain CommonPrefixes only if you specify a delimiter.</p>
    ///
    /// <p>CommonPrefixes contains all (if there are any) keys between Prefix and the next
    /// occurrence of the string specified by the delimiter.</p>
    ///
    /// <p> CommonPrefixes lists keys that act like subdirectories in the directory specified by
    /// Prefix.</p>
    ///
    /// <p>For example, if the prefix is notes/ and the delimiter is a slash (/) as in
    /// notes/summer/july, the common prefix is notes/summer/. All of the keys that roll up into a
    /// common prefix count as a single return when calculating the number of returns.</p>
    pub common_prefixes: std::option::Option<std::vec::Vec<crate::model::CommonPrefix>>,
    /// <p>Encoding type used by Amazon S3 to encode object keys in the response.</p>
    pub encoding_type: std::option::Option<crate::model::EncodingType>,
}
impl ListObjectsOutput {
    /// <p>A flag that indicates whether Amazon S3 returned all of the results that satisfied the search
    /// criteria.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>Indicates where in the bucket listing begins. Marker is included in the response if it
    /// was sent with the request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>When response is truncated (the IsTruncated element value in the response is true), you
    /// can use the key name in this field as marker in the subsequent request to get next set of
    /// objects. Amazon S3 lists objects in alphabetical order Note: This element is returned only if
    /// you have delimiter request parameter specified. If response does not include the NextMarker
    /// and it is truncated, you can use the value of the last Key in the response as the marker in
    /// the subsequent request to get the next set of object keys.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
    /// <p>Metadata about each object returned.</p>
    pub fn contents(&self) -> std::option::Option<&[crate::model::Object]> {
        self.contents.as_deref()
    }
    /// <p>The bucket name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Keys that begin with the indicated prefix.</p>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
    /// <p>Causes keys that contain the same string between the prefix and the first occurrence of
    /// the delimiter to be rolled up into a single result element in the
    /// <code>CommonPrefixes</code> collection. These rolled-up keys are not returned elsewhere
    /// in the response. Each rolled-up result counts as only one return against the
    /// <code>MaxKeys</code> value.</p>
    pub fn delimiter(&self) -> std::option::Option<&str> {
        self.delimiter.as_deref()
    }
    /// <p>The maximum number of keys returned in the response body.</p>
    pub fn max_keys(&self) -> i32 {
        self.max_keys
    }
    /// <p>All of the keys (up to 1,000) rolled up in a common prefix count as a single return when calculating
    /// the number of returns. </p>
    ///
    /// <p>A response can contain CommonPrefixes only if you specify a delimiter.</p>
    ///
    /// <p>CommonPrefixes contains all (if there are any) keys between Prefix and the next
    /// occurrence of the string specified by the delimiter.</p>
    ///
    /// <p> CommonPrefixes lists keys that act like subdirectories in the directory specified by
    /// Prefix.</p>
    ///
    /// <p>For example, if the prefix is notes/ and the delimiter is a slash (/) as in
    /// notes/summer/july, the common prefix is notes/summer/. All of the keys that roll up into a
    /// common prefix count as a single return when calculating the number of returns.</p>
    pub fn common_prefixes(&self) -> std::option::Option<&[crate::model::CommonPrefix]> {
        self.common_prefixes.as_deref()
    }
    /// <p>Encoding type used by Amazon S3 to encode object keys in the response.</p>
    pub fn encoding_type(&self) -> std::option::Option<&crate::model::EncodingType> {
        self.encoding_type.as_ref()
    }
}
impl std::fmt::Debug for ListObjectsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListObjectsOutput");
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("marker", &self.marker);
        formatter.field("next_marker", &self.next_marker);
        formatter.field("contents", &self.contents);
        formatter.field("name", &self.name);
        formatter.field("prefix", &self.prefix);
        formatter.field("delimiter", &self.delimiter);
        formatter.field("max_keys", &self.max_keys);
        formatter.field("common_prefixes", &self.common_prefixes);
        formatter.field("encoding_type", &self.encoding_type);
        formatter.finish()
    }
}
/// See [`ListObjectsOutput`](crate::output::ListObjectsOutput)
pub mod list_objects_output {
    /// A builder for [`ListObjectsOutput`](crate::output::ListObjectsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) next_marker: std::option::Option<std::string::String>,
        pub(crate) contents: std::option::Option<std::vec::Vec<crate::model::Object>>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) delimiter: std::option::Option<std::string::String>,
        pub(crate) max_keys: std::option::Option<i32>,
        pub(crate) common_prefixes: std::option::Option<std::vec::Vec<crate::model::CommonPrefix>>,
        pub(crate) encoding_type: std::option::Option<crate::model::EncodingType>,
    }
    impl Builder {
        /// <p>A flag that indicates whether Amazon S3 returned all of the results that satisfied the search
        /// criteria.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether Amazon S3 returned all of the results that satisfied the search
        /// criteria.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>Indicates where in the bucket listing begins. Marker is included in the response if it
        /// was sent with the request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Indicates where in the bucket listing begins. Marker is included in the response if it
        /// was sent with the request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>When response is truncated (the IsTruncated element value in the response is true), you
        /// can use the key name in this field as marker in the subsequent request to get next set of
        /// objects. Amazon S3 lists objects in alphabetical order Note: This element is returned only if
        /// you have delimiter request parameter specified. If response does not include the NextMarker
        /// and it is truncated, you can use the value of the last Key in the response as the marker in
        /// the subsequent request to get the next set of object keys.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>When response is truncated (the IsTruncated element value in the response is true), you
        /// can use the key name in this field as marker in the subsequent request to get next set of
        /// objects. Amazon S3 lists objects in alphabetical order Note: This element is returned only if
        /// you have delimiter request parameter specified. If response does not include the NextMarker
        /// and it is truncated, you can use the value of the last Key in the response as the marker in
        /// the subsequent request to get the next set of object keys.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Appends an item to `contents`.
        ///
        /// To override the contents of this collection use [`set_contents`](Self::set_contents).
        ///
        /// <p>Metadata about each object returned.</p>
        pub fn contents(mut self, input: impl Into<crate::model::Object>) -> Self {
            let mut v = self.contents.unwrap_or_default();
            v.push(input.into());
            self.contents = Some(v);
            self
        }
        /// <p>Metadata about each object returned.</p>
        pub fn set_contents(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Object>>,
        ) -> Self {
            self.contents = input;
            self
        }
        /// <p>The bucket name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The bucket name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Keys that begin with the indicated prefix.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>Keys that begin with the indicated prefix.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// <p>Causes keys that contain the same string between the prefix and the first occurrence of
        /// the delimiter to be rolled up into a single result element in the
        /// <code>CommonPrefixes</code> collection. These rolled-up keys are not returned elsewhere
        /// in the response. Each rolled-up result counts as only one return against the
        /// <code>MaxKeys</code> value.</p>
        pub fn delimiter(mut self, input: impl Into<std::string::String>) -> Self {
            self.delimiter = Some(input.into());
            self
        }
        /// <p>Causes keys that contain the same string between the prefix and the first occurrence of
        /// the delimiter to be rolled up into a single result element in the
        /// <code>CommonPrefixes</code> collection. These rolled-up keys are not returned elsewhere
        /// in the response. Each rolled-up result counts as only one return against the
        /// <code>MaxKeys</code> value.</p>
        pub fn set_delimiter(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.delimiter = input;
            self
        }
        /// <p>The maximum number of keys returned in the response body.</p>
        pub fn max_keys(mut self, input: i32) -> Self {
            self.max_keys = Some(input);
            self
        }
        /// <p>The maximum number of keys returned in the response body.</p>
        pub fn set_max_keys(mut self, input: std::option::Option<i32>) -> Self {
            self.max_keys = input;
            self
        }
        /// Appends an item to `common_prefixes`.
        ///
        /// To override the contents of this collection use [`set_common_prefixes`](Self::set_common_prefixes).
        ///
        /// <p>All of the keys (up to 1,000) rolled up in a common prefix count as a single return when calculating
        /// the number of returns. </p>
        ///
        /// <p>A response can contain CommonPrefixes only if you specify a delimiter.</p>
        ///
        /// <p>CommonPrefixes contains all (if there are any) keys between Prefix and the next
        /// occurrence of the string specified by the delimiter.</p>
        ///
        /// <p> CommonPrefixes lists keys that act like subdirectories in the directory specified by
        /// Prefix.</p>
        ///
        /// <p>For example, if the prefix is notes/ and the delimiter is a slash (/) as in
        /// notes/summer/july, the common prefix is notes/summer/. All of the keys that roll up into a
        /// common prefix count as a single return when calculating the number of returns.</p>
        pub fn common_prefixes(mut self, input: impl Into<crate::model::CommonPrefix>) -> Self {
            let mut v = self.common_prefixes.unwrap_or_default();
            v.push(input.into());
            self.common_prefixes = Some(v);
            self
        }
        /// <p>All of the keys (up to 1,000) rolled up in a common prefix count as a single return when calculating
        /// the number of returns. </p>
        ///
        /// <p>A response can contain CommonPrefixes only if you specify a delimiter.</p>
        ///
        /// <p>CommonPrefixes contains all (if there are any) keys between Prefix and the next
        /// occurrence of the string specified by the delimiter.</p>
        ///
        /// <p> CommonPrefixes lists keys that act like subdirectories in the directory specified by
        /// Prefix.</p>
        ///
        /// <p>For example, if the prefix is notes/ and the delimiter is a slash (/) as in
        /// notes/summer/july, the common prefix is notes/summer/. All of the keys that roll up into a
        /// common prefix count as a single return when calculating the number of returns.</p>
        pub fn set_common_prefixes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CommonPrefix>>,
        ) -> Self {
            self.common_prefixes = input;
            self
        }
        /// <p>Encoding type used by Amazon S3 to encode object keys in the response.</p>
        pub fn encoding_type(mut self, input: crate::model::EncodingType) -> Self {
            self.encoding_type = Some(input);
            self
        }
        /// <p>Encoding type used by Amazon S3 to encode object keys in the response.</p>
        pub fn set_encoding_type(
            mut self,
            input: std::option::Option<crate::model::EncodingType>,
        ) -> Self {
            self.encoding_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ListObjectsOutput`](crate::output::ListObjectsOutput)
        pub fn build(self) -> crate::output::ListObjectsOutput {
            crate::output::ListObjectsOutput {
                is_truncated: self.is_truncated.unwrap_or_default(),
                marker: self.marker,
                next_marker: self.next_marker,
                contents: self.contents,
                name: self.name,
                prefix: self.prefix,
                delimiter: self.delimiter,
                max_keys: self.max_keys.unwrap_or_default(),
                common_prefixes: self.common_prefixes,
                encoding_type: self.encoding_type,
            }
        }
    }
}
impl ListObjectsOutput {
    /// Creates a new builder-style object to manufacture [`ListObjectsOutput`](crate::output::ListObjectsOutput)
    pub fn builder() -> crate::output::list_objects_output::Builder {
        crate::output::list_objects_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListMultipartUploadsOutput {
    /// <p>The name of the bucket to which the multipart upload was initiated. Does not return the access point ARN or access point alias if used.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>The key at or after which the listing began.</p>
    pub key_marker: std::option::Option<std::string::String>,
    /// <p>Upload ID after which listing began.</p>
    pub upload_id_marker: std::option::Option<std::string::String>,
    /// <p>When a list is truncated, this element specifies the value that should be used for the
    /// key-marker request parameter in a subsequent request.</p>
    pub next_key_marker: std::option::Option<std::string::String>,
    /// <p>When a prefix is provided in the request, this field contains the specified prefix. The
    /// result contains only keys starting with the specified prefix.</p>
    pub prefix: std::option::Option<std::string::String>,
    /// <p>Contains the delimiter you specified in the request. If you don't specify a delimiter in
    /// your request, this element is absent from the response.</p>
    pub delimiter: std::option::Option<std::string::String>,
    /// <p>When a list is truncated, this element specifies the value that should be used for the
    /// <code>upload-id-marker</code> request parameter in a subsequent request.</p>
    pub next_upload_id_marker: std::option::Option<std::string::String>,
    /// <p>Maximum number of multipart uploads that could have been included in the
    /// response.</p>
    pub max_uploads: i32,
    /// <p>Indicates whether the returned list of multipart uploads is truncated. A value of true
    /// indicates that the list was truncated. The list can be truncated if the number of multipart
    /// uploads exceeds the limit allowed or specified by max uploads.</p>
    pub is_truncated: bool,
    /// <p>Container for elements related to a particular multipart upload. A response can contain
    /// zero or more <code>Upload</code> elements.</p>
    pub uploads: std::option::Option<std::vec::Vec<crate::model::MultipartUpload>>,
    /// <p>If you specify a delimiter in the request, then the result returns each distinct key
    /// prefix containing the delimiter in a <code>CommonPrefixes</code> element. The distinct key
    /// prefixes are returned in the <code>Prefix</code> child element.</p>
    pub common_prefixes: std::option::Option<std::vec::Vec<crate::model::CommonPrefix>>,
    /// <p>Encoding type used by Amazon S3 to encode object keys in the response.</p>
    /// <p>If you specify <code>encoding-type</code> request parameter, Amazon S3 includes this element
    /// in the response, and returns encoded key name values in the following response
    /// elements:</p>
    ///
    /// <p>
    /// <code>Delimiter</code>, <code>KeyMarker</code>, <code>Prefix</code>,
    /// <code>NextKeyMarker</code>, <code>Key</code>.</p>
    pub encoding_type: std::option::Option<crate::model::EncodingType>,
}
impl ListMultipartUploadsOutput {
    /// <p>The name of the bucket to which the multipart upload was initiated. Does not return the access point ARN or access point alias if used.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>The key at or after which the listing began.</p>
    pub fn key_marker(&self) -> std::option::Option<&str> {
        self.key_marker.as_deref()
    }
    /// <p>Upload ID after which listing began.</p>
    pub fn upload_id_marker(&self) -> std::option::Option<&str> {
        self.upload_id_marker.as_deref()
    }
    /// <p>When a list is truncated, this element specifies the value that should be used for the
    /// key-marker request parameter in a subsequent request.</p>
    pub fn next_key_marker(&self) -> std::option::Option<&str> {
        self.next_key_marker.as_deref()
    }
    /// <p>When a prefix is provided in the request, this field contains the specified prefix. The
    /// result contains only keys starting with the specified prefix.</p>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
    /// <p>Contains the delimiter you specified in the request. If you don't specify a delimiter in
    /// your request, this element is absent from the response.</p>
    pub fn delimiter(&self) -> std::option::Option<&str> {
        self.delimiter.as_deref()
    }
    /// <p>When a list is truncated, this element specifies the value that should be used for the
    /// <code>upload-id-marker</code> request parameter in a subsequent request.</p>
    pub fn next_upload_id_marker(&self) -> std::option::Option<&str> {
        self.next_upload_id_marker.as_deref()
    }
    /// <p>Maximum number of multipart uploads that could have been included in the
    /// response.</p>
    pub fn max_uploads(&self) -> i32 {
        self.max_uploads
    }
    /// <p>Indicates whether the returned list of multipart uploads is truncated. A value of true
    /// indicates that the list was truncated. The list can be truncated if the number of multipart
    /// uploads exceeds the limit allowed or specified by max uploads.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>Container for elements related to a particular multipart upload. A response can contain
    /// zero or more <code>Upload</code> elements.</p>
    pub fn uploads(&self) -> std::option::Option<&[crate::model::MultipartUpload]> {
        self.uploads.as_deref()
    }
    /// <p>If you specify a delimiter in the request, then the result returns each distinct key
    /// prefix containing the delimiter in a <code>CommonPrefixes</code> element. The distinct key
    /// prefixes are returned in the <code>Prefix</code> child element.</p>
    pub fn common_prefixes(&self) -> std::option::Option<&[crate::model::CommonPrefix]> {
        self.common_prefixes.as_deref()
    }
    /// <p>Encoding type used by Amazon S3 to encode object keys in the response.</p>
    /// <p>If you specify <code>encoding-type</code> request parameter, Amazon S3 includes this element
    /// in the response, and returns encoded key name values in the following response
    /// elements:</p>
    ///
    /// <p>
    /// <code>Delimiter</code>, <code>KeyMarker</code>, <code>Prefix</code>,
    /// <code>NextKeyMarker</code>, <code>Key</code>.</p>
    pub fn encoding_type(&self) -> std::option::Option<&crate::model::EncodingType> {
        self.encoding_type.as_ref()
    }
}
impl std::fmt::Debug for ListMultipartUploadsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListMultipartUploadsOutput");
        formatter.field("bucket", &self.bucket);
        formatter.field("key_marker", &self.key_marker);
        formatter.field("upload_id_marker", &self.upload_id_marker);
        formatter.field("next_key_marker", &self.next_key_marker);
        formatter.field("prefix", &self.prefix);
        formatter.field("delimiter", &self.delimiter);
        formatter.field("next_upload_id_marker", &self.next_upload_id_marker);
        formatter.field("max_uploads", &self.max_uploads);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("uploads", &self.uploads);
        formatter.field("common_prefixes", &self.common_prefixes);
        formatter.field("encoding_type", &self.encoding_type);
        formatter.finish()
    }
}
/// See [`ListMultipartUploadsOutput`](crate::output::ListMultipartUploadsOutput)
pub mod list_multipart_uploads_output {
    /// A builder for [`ListMultipartUploadsOutput`](crate::output::ListMultipartUploadsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key_marker: std::option::Option<std::string::String>,
        pub(crate) upload_id_marker: std::option::Option<std::string::String>,
        pub(crate) next_key_marker: std::option::Option<std::string::String>,
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) delimiter: std::option::Option<std::string::String>,
        pub(crate) next_upload_id_marker: std::option::Option<std::string::String>,
        pub(crate) max_uploads: std::option::Option<i32>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) uploads: std::option::Option<std::vec::Vec<crate::model::MultipartUpload>>,
        pub(crate) common_prefixes: std::option::Option<std::vec::Vec<crate::model::CommonPrefix>>,
        pub(crate) encoding_type: std::option::Option<crate::model::EncodingType>,
    }
    impl Builder {
        /// <p>The name of the bucket to which the multipart upload was initiated. Does not return the access point ARN or access point alias if used.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket to which the multipart upload was initiated. Does not return the access point ARN or access point alias if used.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The key at or after which the listing began.</p>
        pub fn key_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_marker = Some(input.into());
            self
        }
        /// <p>The key at or after which the listing began.</p>
        pub fn set_key_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_marker = input;
            self
        }
        /// <p>Upload ID after which listing began.</p>
        pub fn upload_id_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.upload_id_marker = Some(input.into());
            self
        }
        /// <p>Upload ID after which listing began.</p>
        pub fn set_upload_id_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.upload_id_marker = input;
            self
        }
        /// <p>When a list is truncated, this element specifies the value that should be used for the
        /// key-marker request parameter in a subsequent request.</p>
        pub fn next_key_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_key_marker = Some(input.into());
            self
        }
        /// <p>When a list is truncated, this element specifies the value that should be used for the
        /// key-marker request parameter in a subsequent request.</p>
        pub fn set_next_key_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_key_marker = input;
            self
        }
        /// <p>When a prefix is provided in the request, this field contains the specified prefix. The
        /// result contains only keys starting with the specified prefix.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>When a prefix is provided in the request, this field contains the specified prefix. The
        /// result contains only keys starting with the specified prefix.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// <p>Contains the delimiter you specified in the request. If you don't specify a delimiter in
        /// your request, this element is absent from the response.</p>
        pub fn delimiter(mut self, input: impl Into<std::string::String>) -> Self {
            self.delimiter = Some(input.into());
            self
        }
        /// <p>Contains the delimiter you specified in the request. If you don't specify a delimiter in
        /// your request, this element is absent from the response.</p>
        pub fn set_delimiter(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.delimiter = input;
            self
        }
        /// <p>When a list is truncated, this element specifies the value that should be used for the
        /// <code>upload-id-marker</code> request parameter in a subsequent request.</p>
        pub fn next_upload_id_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_upload_id_marker = Some(input.into());
            self
        }
        /// <p>When a list is truncated, this element specifies the value that should be used for the
        /// <code>upload-id-marker</code> request parameter in a subsequent request.</p>
        pub fn set_next_upload_id_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_upload_id_marker = input;
            self
        }
        /// <p>Maximum number of multipart uploads that could have been included in the
        /// response.</p>
        pub fn max_uploads(mut self, input: i32) -> Self {
            self.max_uploads = Some(input);
            self
        }
        /// <p>Maximum number of multipart uploads that could have been included in the
        /// response.</p>
        pub fn set_max_uploads(mut self, input: std::option::Option<i32>) -> Self {
            self.max_uploads = input;
            self
        }
        /// <p>Indicates whether the returned list of multipart uploads is truncated. A value of true
        /// indicates that the list was truncated. The list can be truncated if the number of multipart
        /// uploads exceeds the limit allowed or specified by max uploads.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>Indicates whether the returned list of multipart uploads is truncated. A value of true
        /// indicates that the list was truncated. The list can be truncated if the number of multipart
        /// uploads exceeds the limit allowed or specified by max uploads.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// Appends an item to `uploads`.
        ///
        /// To override the contents of this collection use [`set_uploads`](Self::set_uploads).
        ///
        /// <p>Container for elements related to a particular multipart upload. A response can contain
        /// zero or more <code>Upload</code> elements.</p>
        pub fn uploads(mut self, input: impl Into<crate::model::MultipartUpload>) -> Self {
            let mut v = self.uploads.unwrap_or_default();
            v.push(input.into());
            self.uploads = Some(v);
            self
        }
        /// <p>Container for elements related to a particular multipart upload. A response can contain
        /// zero or more <code>Upload</code> elements.</p>
        pub fn set_uploads(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MultipartUpload>>,
        ) -> Self {
            self.uploads = input;
            self
        }
        /// Appends an item to `common_prefixes`.
        ///
        /// To override the contents of this collection use [`set_common_prefixes`](Self::set_common_prefixes).
        ///
        /// <p>If you specify a delimiter in the request, then the result returns each distinct key
        /// prefix containing the delimiter in a <code>CommonPrefixes</code> element. The distinct key
        /// prefixes are returned in the <code>Prefix</code> child element.</p>
        pub fn common_prefixes(mut self, input: impl Into<crate::model::CommonPrefix>) -> Self {
            let mut v = self.common_prefixes.unwrap_or_default();
            v.push(input.into());
            self.common_prefixes = Some(v);
            self
        }
        /// <p>If you specify a delimiter in the request, then the result returns each distinct key
        /// prefix containing the delimiter in a <code>CommonPrefixes</code> element. The distinct key
        /// prefixes are returned in the <code>Prefix</code> child element.</p>
        pub fn set_common_prefixes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CommonPrefix>>,
        ) -> Self {
            self.common_prefixes = input;
            self
        }
        /// <p>Encoding type used by Amazon S3 to encode object keys in the response.</p>
        /// <p>If you specify <code>encoding-type</code> request parameter, Amazon S3 includes this element
        /// in the response, and returns encoded key name values in the following response
        /// elements:</p>
        ///
        /// <p>
        /// <code>Delimiter</code>, <code>KeyMarker</code>, <code>Prefix</code>,
        /// <code>NextKeyMarker</code>, <code>Key</code>.</p>
        pub fn encoding_type(mut self, input: crate::model::EncodingType) -> Self {
            self.encoding_type = Some(input);
            self
        }
        /// <p>Encoding type used by Amazon S3 to encode object keys in the response.</p>
        /// <p>If you specify <code>encoding-type</code> request parameter, Amazon S3 includes this element
        /// in the response, and returns encoded key name values in the following response
        /// elements:</p>
        ///
        /// <p>
        /// <code>Delimiter</code>, <code>KeyMarker</code>, <code>Prefix</code>,
        /// <code>NextKeyMarker</code>, <code>Key</code>.</p>
        pub fn set_encoding_type(
            mut self,
            input: std::option::Option<crate::model::EncodingType>,
        ) -> Self {
            self.encoding_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMultipartUploadsOutput`](crate::output::ListMultipartUploadsOutput)
        pub fn build(self) -> crate::output::ListMultipartUploadsOutput {
            crate::output::ListMultipartUploadsOutput {
                bucket: self.bucket,
                key_marker: self.key_marker,
                upload_id_marker: self.upload_id_marker,
                next_key_marker: self.next_key_marker,
                prefix: self.prefix,
                delimiter: self.delimiter,
                next_upload_id_marker: self.next_upload_id_marker,
                max_uploads: self.max_uploads.unwrap_or_default(),
                is_truncated: self.is_truncated.unwrap_or_default(),
                uploads: self.uploads,
                common_prefixes: self.common_prefixes,
                encoding_type: self.encoding_type,
            }
        }
    }
}
impl ListMultipartUploadsOutput {
    /// Creates a new builder-style object to manufacture [`ListMultipartUploadsOutput`](crate::output::ListMultipartUploadsOutput)
    pub fn builder() -> crate::output::list_multipart_uploads_output::Builder {
        crate::output::list_multipart_uploads_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBucketsOutput {
    /// <p>The list of buckets owned by the requestor.</p>
    pub buckets: std::option::Option<std::vec::Vec<crate::model::Bucket>>,
    /// <p>The owner of the buckets listed.</p>
    pub owner: std::option::Option<crate::model::Owner>,
}
impl ListBucketsOutput {
    /// <p>The list of buckets owned by the requestor.</p>
    pub fn buckets(&self) -> std::option::Option<&[crate::model::Bucket]> {
        self.buckets.as_deref()
    }
    /// <p>The owner of the buckets listed.</p>
    pub fn owner(&self) -> std::option::Option<&crate::model::Owner> {
        self.owner.as_ref()
    }
}
impl std::fmt::Debug for ListBucketsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBucketsOutput");
        formatter.field("buckets", &self.buckets);
        formatter.field("owner", &self.owner);
        formatter.finish()
    }
}
/// See [`ListBucketsOutput`](crate::output::ListBucketsOutput)
pub mod list_buckets_output {
    /// A builder for [`ListBucketsOutput`](crate::output::ListBucketsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) buckets: std::option::Option<std::vec::Vec<crate::model::Bucket>>,
        pub(crate) owner: std::option::Option<crate::model::Owner>,
    }
    impl Builder {
        /// Appends an item to `buckets`.
        ///
        /// To override the contents of this collection use [`set_buckets`](Self::set_buckets).
        ///
        /// <p>The list of buckets owned by the requestor.</p>
        pub fn buckets(mut self, input: impl Into<crate::model::Bucket>) -> Self {
            let mut v = self.buckets.unwrap_or_default();
            v.push(input.into());
            self.buckets = Some(v);
            self
        }
        /// <p>The list of buckets owned by the requestor.</p>
        pub fn set_buckets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Bucket>>,
        ) -> Self {
            self.buckets = input;
            self
        }
        /// <p>The owner of the buckets listed.</p>
        pub fn owner(mut self, input: crate::model::Owner) -> Self {
            self.owner = Some(input);
            self
        }
        /// <p>The owner of the buckets listed.</p>
        pub fn set_owner(mut self, input: std::option::Option<crate::model::Owner>) -> Self {
            self.owner = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBucketsOutput`](crate::output::ListBucketsOutput)
        pub fn build(self) -> crate::output::ListBucketsOutput {
            crate::output::ListBucketsOutput {
                buckets: self.buckets,
                owner: self.owner,
            }
        }
    }
}
impl ListBucketsOutput {
    /// Creates a new builder-style object to manufacture [`ListBucketsOutput`](crate::output::ListBucketsOutput)
    pub fn builder() -> crate::output::list_buckets_output::Builder {
        crate::output::list_buckets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBucketMetricsConfigurationsOutput {
    /// <p>Indicates whether the returned list of metrics configurations is complete. A value of
    /// true indicates that the list is not complete and the NextContinuationToken will be provided
    /// for a subsequent request.</p>
    pub is_truncated: bool,
    /// <p>The marker that is used as a starting point for this metrics configuration list
    /// response. This value is present if it was sent in the request.</p>
    pub continuation_token: std::option::Option<std::string::String>,
    /// <p>The marker used to continue a metrics configuration listing that has been truncated. Use
    /// the <code>NextContinuationToken</code> from a previously truncated list response to
    /// continue the listing. The continuation token is an opaque value that Amazon S3
    /// understands.</p>
    pub next_continuation_token: std::option::Option<std::string::String>,
    /// <p>The list of metrics configurations for a bucket.</p>
    pub metrics_configuration_list:
        std::option::Option<std::vec::Vec<crate::model::MetricsConfiguration>>,
}
impl ListBucketMetricsConfigurationsOutput {
    /// <p>Indicates whether the returned list of metrics configurations is complete. A value of
    /// true indicates that the list is not complete and the NextContinuationToken will be provided
    /// for a subsequent request.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>The marker that is used as a starting point for this metrics configuration list
    /// response. This value is present if it was sent in the request.</p>
    pub fn continuation_token(&self) -> std::option::Option<&str> {
        self.continuation_token.as_deref()
    }
    /// <p>The marker used to continue a metrics configuration listing that has been truncated. Use
    /// the <code>NextContinuationToken</code> from a previously truncated list response to
    /// continue the listing. The continuation token is an opaque value that Amazon S3
    /// understands.</p>
    pub fn next_continuation_token(&self) -> std::option::Option<&str> {
        self.next_continuation_token.as_deref()
    }
    /// <p>The list of metrics configurations for a bucket.</p>
    pub fn metrics_configuration_list(
        &self,
    ) -> std::option::Option<&[crate::model::MetricsConfiguration]> {
        self.metrics_configuration_list.as_deref()
    }
}
impl std::fmt::Debug for ListBucketMetricsConfigurationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBucketMetricsConfigurationsOutput");
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("continuation_token", &self.continuation_token);
        formatter.field("next_continuation_token", &self.next_continuation_token);
        formatter.field(
            "metrics_configuration_list",
            &self.metrics_configuration_list,
        );
        formatter.finish()
    }
}
/// See [`ListBucketMetricsConfigurationsOutput`](crate::output::ListBucketMetricsConfigurationsOutput)
pub mod list_bucket_metrics_configurations_output {
    /// A builder for [`ListBucketMetricsConfigurationsOutput`](crate::output::ListBucketMetricsConfigurationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) continuation_token: std::option::Option<std::string::String>,
        pub(crate) next_continuation_token: std::option::Option<std::string::String>,
        pub(crate) metrics_configuration_list:
            std::option::Option<std::vec::Vec<crate::model::MetricsConfiguration>>,
    }
    impl Builder {
        /// <p>Indicates whether the returned list of metrics configurations is complete. A value of
        /// true indicates that the list is not complete and the NextContinuationToken will be provided
        /// for a subsequent request.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>Indicates whether the returned list of metrics configurations is complete. A value of
        /// true indicates that the list is not complete and the NextContinuationToken will be provided
        /// for a subsequent request.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>The marker that is used as a starting point for this metrics configuration list
        /// response. This value is present if it was sent in the request.</p>
        pub fn continuation_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.continuation_token = Some(input.into());
            self
        }
        /// <p>The marker that is used as a starting point for this metrics configuration list
        /// response. This value is present if it was sent in the request.</p>
        pub fn set_continuation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.continuation_token = input;
            self
        }
        /// <p>The marker used to continue a metrics configuration listing that has been truncated. Use
        /// the <code>NextContinuationToken</code> from a previously truncated list response to
        /// continue the listing. The continuation token is an opaque value that Amazon S3
        /// understands.</p>
        pub fn next_continuation_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_continuation_token = Some(input.into());
            self
        }
        /// <p>The marker used to continue a metrics configuration listing that has been truncated. Use
        /// the <code>NextContinuationToken</code> from a previously truncated list response to
        /// continue the listing. The continuation token is an opaque value that Amazon S3
        /// understands.</p>
        pub fn set_next_continuation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_continuation_token = input;
            self
        }
        /// Appends an item to `metrics_configuration_list`.
        ///
        /// To override the contents of this collection use [`set_metrics_configuration_list`](Self::set_metrics_configuration_list).
        ///
        /// <p>The list of metrics configurations for a bucket.</p>
        pub fn metrics_configuration_list(
            mut self,
            input: impl Into<crate::model::MetricsConfiguration>,
        ) -> Self {
            let mut v = self.metrics_configuration_list.unwrap_or_default();
            v.push(input.into());
            self.metrics_configuration_list = Some(v);
            self
        }
        /// <p>The list of metrics configurations for a bucket.</p>
        pub fn set_metrics_configuration_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricsConfiguration>>,
        ) -> Self {
            self.metrics_configuration_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBucketMetricsConfigurationsOutput`](crate::output::ListBucketMetricsConfigurationsOutput)
        pub fn build(self) -> crate::output::ListBucketMetricsConfigurationsOutput {
            crate::output::ListBucketMetricsConfigurationsOutput {
                is_truncated: self.is_truncated.unwrap_or_default(),
                continuation_token: self.continuation_token,
                next_continuation_token: self.next_continuation_token,
                metrics_configuration_list: self.metrics_configuration_list,
            }
        }
    }
}
impl ListBucketMetricsConfigurationsOutput {
    /// Creates a new builder-style object to manufacture [`ListBucketMetricsConfigurationsOutput`](crate::output::ListBucketMetricsConfigurationsOutput)
    pub fn builder() -> crate::output::list_bucket_metrics_configurations_output::Builder {
        crate::output::list_bucket_metrics_configurations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBucketInventoryConfigurationsOutput {
    /// <p>If sent in the request, the marker that is used as a starting point for this inventory
    /// configuration list response.</p>
    pub continuation_token: std::option::Option<std::string::String>,
    /// <p>The list of inventory configurations for a bucket.</p>
    pub inventory_configuration_list:
        std::option::Option<std::vec::Vec<crate::model::InventoryConfiguration>>,
    /// <p>Tells whether the returned list of inventory configurations is complete. A value of true
    /// indicates that the list is not complete and the NextContinuationToken is provided for a
    /// subsequent request.</p>
    pub is_truncated: bool,
    /// <p>The marker used to continue this inventory configuration listing. Use the
    /// <code>NextContinuationToken</code> from this response to continue the listing in a
    /// subsequent request. The continuation token is an opaque value that Amazon S3 understands.</p>
    pub next_continuation_token: std::option::Option<std::string::String>,
}
impl ListBucketInventoryConfigurationsOutput {
    /// <p>If sent in the request, the marker that is used as a starting point for this inventory
    /// configuration list response.</p>
    pub fn continuation_token(&self) -> std::option::Option<&str> {
        self.continuation_token.as_deref()
    }
    /// <p>The list of inventory configurations for a bucket.</p>
    pub fn inventory_configuration_list(
        &self,
    ) -> std::option::Option<&[crate::model::InventoryConfiguration]> {
        self.inventory_configuration_list.as_deref()
    }
    /// <p>Tells whether the returned list of inventory configurations is complete. A value of true
    /// indicates that the list is not complete and the NextContinuationToken is provided for a
    /// subsequent request.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>The marker used to continue this inventory configuration listing. Use the
    /// <code>NextContinuationToken</code> from this response to continue the listing in a
    /// subsequent request. The continuation token is an opaque value that Amazon S3 understands.</p>
    pub fn next_continuation_token(&self) -> std::option::Option<&str> {
        self.next_continuation_token.as_deref()
    }
}
impl std::fmt::Debug for ListBucketInventoryConfigurationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBucketInventoryConfigurationsOutput");
        formatter.field("continuation_token", &self.continuation_token);
        formatter.field(
            "inventory_configuration_list",
            &self.inventory_configuration_list,
        );
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("next_continuation_token", &self.next_continuation_token);
        formatter.finish()
    }
}
/// See [`ListBucketInventoryConfigurationsOutput`](crate::output::ListBucketInventoryConfigurationsOutput)
pub mod list_bucket_inventory_configurations_output {
    /// A builder for [`ListBucketInventoryConfigurationsOutput`](crate::output::ListBucketInventoryConfigurationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) continuation_token: std::option::Option<std::string::String>,
        pub(crate) inventory_configuration_list:
            std::option::Option<std::vec::Vec<crate::model::InventoryConfiguration>>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) next_continuation_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>If sent in the request, the marker that is used as a starting point for this inventory
        /// configuration list response.</p>
        pub fn continuation_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.continuation_token = Some(input.into());
            self
        }
        /// <p>If sent in the request, the marker that is used as a starting point for this inventory
        /// configuration list response.</p>
        pub fn set_continuation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.continuation_token = input;
            self
        }
        /// Appends an item to `inventory_configuration_list`.
        ///
        /// To override the contents of this collection use [`set_inventory_configuration_list`](Self::set_inventory_configuration_list).
        ///
        /// <p>The list of inventory configurations for a bucket.</p>
        pub fn inventory_configuration_list(
            mut self,
            input: impl Into<crate::model::InventoryConfiguration>,
        ) -> Self {
            let mut v = self.inventory_configuration_list.unwrap_or_default();
            v.push(input.into());
            self.inventory_configuration_list = Some(v);
            self
        }
        /// <p>The list of inventory configurations for a bucket.</p>
        pub fn set_inventory_configuration_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InventoryConfiguration>>,
        ) -> Self {
            self.inventory_configuration_list = input;
            self
        }
        /// <p>Tells whether the returned list of inventory configurations is complete. A value of true
        /// indicates that the list is not complete and the NextContinuationToken is provided for a
        /// subsequent request.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>Tells whether the returned list of inventory configurations is complete. A value of true
        /// indicates that the list is not complete and the NextContinuationToken is provided for a
        /// subsequent request.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>The marker used to continue this inventory configuration listing. Use the
        /// <code>NextContinuationToken</code> from this response to continue the listing in a
        /// subsequent request. The continuation token is an opaque value that Amazon S3 understands.</p>
        pub fn next_continuation_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_continuation_token = Some(input.into());
            self
        }
        /// <p>The marker used to continue this inventory configuration listing. Use the
        /// <code>NextContinuationToken</code> from this response to continue the listing in a
        /// subsequent request. The continuation token is an opaque value that Amazon S3 understands.</p>
        pub fn set_next_continuation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_continuation_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBucketInventoryConfigurationsOutput`](crate::output::ListBucketInventoryConfigurationsOutput)
        pub fn build(self) -> crate::output::ListBucketInventoryConfigurationsOutput {
            crate::output::ListBucketInventoryConfigurationsOutput {
                continuation_token: self.continuation_token,
                inventory_configuration_list: self.inventory_configuration_list,
                is_truncated: self.is_truncated.unwrap_or_default(),
                next_continuation_token: self.next_continuation_token,
            }
        }
    }
}
impl ListBucketInventoryConfigurationsOutput {
    /// Creates a new builder-style object to manufacture [`ListBucketInventoryConfigurationsOutput`](crate::output::ListBucketInventoryConfigurationsOutput)
    pub fn builder() -> crate::output::list_bucket_inventory_configurations_output::Builder {
        crate::output::list_bucket_inventory_configurations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBucketIntelligentTieringConfigurationsOutput {
    /// <p>Indicates whether the returned list of analytics configurations is complete. A value of
    /// true indicates that the list is not complete and the NextContinuationToken will be provided
    /// for a subsequent request.</p>
    pub is_truncated: bool,
    /// <p>The ContinuationToken that represents a placeholder from where this request should
    /// begin.</p>
    pub continuation_token: std::option::Option<std::string::String>,
    /// <p>The marker used to continue this inventory configuration listing. Use the
    /// <code>NextContinuationToken</code> from this response to continue the listing in a
    /// subsequent request. The continuation token is an opaque value that Amazon S3 understands.</p>
    pub next_continuation_token: std::option::Option<std::string::String>,
    /// <p>The list of S3 Intelligent-Tiering configurations for a bucket.</p>
    pub intelligent_tiering_configuration_list:
        std::option::Option<std::vec::Vec<crate::model::IntelligentTieringConfiguration>>,
}
impl ListBucketIntelligentTieringConfigurationsOutput {
    /// <p>Indicates whether the returned list of analytics configurations is complete. A value of
    /// true indicates that the list is not complete and the NextContinuationToken will be provided
    /// for a subsequent request.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>The ContinuationToken that represents a placeholder from where this request should
    /// begin.</p>
    pub fn continuation_token(&self) -> std::option::Option<&str> {
        self.continuation_token.as_deref()
    }
    /// <p>The marker used to continue this inventory configuration listing. Use the
    /// <code>NextContinuationToken</code> from this response to continue the listing in a
    /// subsequent request. The continuation token is an opaque value that Amazon S3 understands.</p>
    pub fn next_continuation_token(&self) -> std::option::Option<&str> {
        self.next_continuation_token.as_deref()
    }
    /// <p>The list of S3 Intelligent-Tiering configurations for a bucket.</p>
    pub fn intelligent_tiering_configuration_list(
        &self,
    ) -> std::option::Option<&[crate::model::IntelligentTieringConfiguration]> {
        self.intelligent_tiering_configuration_list.as_deref()
    }
}
impl std::fmt::Debug for ListBucketIntelligentTieringConfigurationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBucketIntelligentTieringConfigurationsOutput");
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("continuation_token", &self.continuation_token);
        formatter.field("next_continuation_token", &self.next_continuation_token);
        formatter.field(
            "intelligent_tiering_configuration_list",
            &self.intelligent_tiering_configuration_list,
        );
        formatter.finish()
    }
}
/// See [`ListBucketIntelligentTieringConfigurationsOutput`](crate::output::ListBucketIntelligentTieringConfigurationsOutput)
pub mod list_bucket_intelligent_tiering_configurations_output {
    /// A builder for [`ListBucketIntelligentTieringConfigurationsOutput`](crate::output::ListBucketIntelligentTieringConfigurationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) continuation_token: std::option::Option<std::string::String>,
        pub(crate) next_continuation_token: std::option::Option<std::string::String>,
        pub(crate) intelligent_tiering_configuration_list:
            std::option::Option<std::vec::Vec<crate::model::IntelligentTieringConfiguration>>,
    }
    impl Builder {
        /// <p>Indicates whether the returned list of analytics configurations is complete. A value of
        /// true indicates that the list is not complete and the NextContinuationToken will be provided
        /// for a subsequent request.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>Indicates whether the returned list of analytics configurations is complete. A value of
        /// true indicates that the list is not complete and the NextContinuationToken will be provided
        /// for a subsequent request.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>The ContinuationToken that represents a placeholder from where this request should
        /// begin.</p>
        pub fn continuation_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.continuation_token = Some(input.into());
            self
        }
        /// <p>The ContinuationToken that represents a placeholder from where this request should
        /// begin.</p>
        pub fn set_continuation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.continuation_token = input;
            self
        }
        /// <p>The marker used to continue this inventory configuration listing. Use the
        /// <code>NextContinuationToken</code> from this response to continue the listing in a
        /// subsequent request. The continuation token is an opaque value that Amazon S3 understands.</p>
        pub fn next_continuation_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_continuation_token = Some(input.into());
            self
        }
        /// <p>The marker used to continue this inventory configuration listing. Use the
        /// <code>NextContinuationToken</code> from this response to continue the listing in a
        /// subsequent request. The continuation token is an opaque value that Amazon S3 understands.</p>
        pub fn set_next_continuation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_continuation_token = input;
            self
        }
        /// Appends an item to `intelligent_tiering_configuration_list`.
        ///
        /// To override the contents of this collection use [`set_intelligent_tiering_configuration_list`](Self::set_intelligent_tiering_configuration_list).
        ///
        /// <p>The list of S3 Intelligent-Tiering configurations for a bucket.</p>
        pub fn intelligent_tiering_configuration_list(
            mut self,
            input: impl Into<crate::model::IntelligentTieringConfiguration>,
        ) -> Self {
            let mut v = self
                .intelligent_tiering_configuration_list
                .unwrap_or_default();
            v.push(input.into());
            self.intelligent_tiering_configuration_list = Some(v);
            self
        }
        /// <p>The list of S3 Intelligent-Tiering configurations for a bucket.</p>
        pub fn set_intelligent_tiering_configuration_list(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::IntelligentTieringConfiguration>,
            >,
        ) -> Self {
            self.intelligent_tiering_configuration_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBucketIntelligentTieringConfigurationsOutput`](crate::output::ListBucketIntelligentTieringConfigurationsOutput)
        pub fn build(self) -> crate::output::ListBucketIntelligentTieringConfigurationsOutput {
            crate::output::ListBucketIntelligentTieringConfigurationsOutput {
                is_truncated: self.is_truncated.unwrap_or_default(),
                continuation_token: self.continuation_token,
                next_continuation_token: self.next_continuation_token,
                intelligent_tiering_configuration_list: self.intelligent_tiering_configuration_list,
            }
        }
    }
}
impl ListBucketIntelligentTieringConfigurationsOutput {
    /// Creates a new builder-style object to manufacture [`ListBucketIntelligentTieringConfigurationsOutput`](crate::output::ListBucketIntelligentTieringConfigurationsOutput)
    pub fn builder() -> crate::output::list_bucket_intelligent_tiering_configurations_output::Builder
    {
        crate::output::list_bucket_intelligent_tiering_configurations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBucketAnalyticsConfigurationsOutput {
    /// <p>Indicates whether the returned list of analytics configurations is complete. A value of
    /// true indicates that the list is not complete and the NextContinuationToken will be provided
    /// for a subsequent request.</p>
    pub is_truncated: bool,
    /// <p>The marker that is used as a starting point for this analytics configuration list
    /// response. This value is present if it was sent in the request.</p>
    pub continuation_token: std::option::Option<std::string::String>,
    /// <p>
    /// <code>NextContinuationToken</code> is sent when <code>isTruncated</code> is true, which
    /// indicates that there are more analytics configurations to list. The next request must
    /// include this <code>NextContinuationToken</code>. The token is obfuscated and is not a
    /// usable value.</p>
    pub next_continuation_token: std::option::Option<std::string::String>,
    /// <p>The list of analytics configurations for a bucket.</p>
    pub analytics_configuration_list:
        std::option::Option<std::vec::Vec<crate::model::AnalyticsConfiguration>>,
}
impl ListBucketAnalyticsConfigurationsOutput {
    /// <p>Indicates whether the returned list of analytics configurations is complete. A value of
    /// true indicates that the list is not complete and the NextContinuationToken will be provided
    /// for a subsequent request.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>The marker that is used as a starting point for this analytics configuration list
    /// response. This value is present if it was sent in the request.</p>
    pub fn continuation_token(&self) -> std::option::Option<&str> {
        self.continuation_token.as_deref()
    }
    /// <p>
    /// <code>NextContinuationToken</code> is sent when <code>isTruncated</code> is true, which
    /// indicates that there are more analytics configurations to list. The next request must
    /// include this <code>NextContinuationToken</code>. The token is obfuscated and is not a
    /// usable value.</p>
    pub fn next_continuation_token(&self) -> std::option::Option<&str> {
        self.next_continuation_token.as_deref()
    }
    /// <p>The list of analytics configurations for a bucket.</p>
    pub fn analytics_configuration_list(
        &self,
    ) -> std::option::Option<&[crate::model::AnalyticsConfiguration]> {
        self.analytics_configuration_list.as_deref()
    }
}
impl std::fmt::Debug for ListBucketAnalyticsConfigurationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBucketAnalyticsConfigurationsOutput");
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("continuation_token", &self.continuation_token);
        formatter.field("next_continuation_token", &self.next_continuation_token);
        formatter.field(
            "analytics_configuration_list",
            &self.analytics_configuration_list,
        );
        formatter.finish()
    }
}
/// See [`ListBucketAnalyticsConfigurationsOutput`](crate::output::ListBucketAnalyticsConfigurationsOutput)
pub mod list_bucket_analytics_configurations_output {
    /// A builder for [`ListBucketAnalyticsConfigurationsOutput`](crate::output::ListBucketAnalyticsConfigurationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) continuation_token: std::option::Option<std::string::String>,
        pub(crate) next_continuation_token: std::option::Option<std::string::String>,
        pub(crate) analytics_configuration_list:
            std::option::Option<std::vec::Vec<crate::model::AnalyticsConfiguration>>,
    }
    impl Builder {
        /// <p>Indicates whether the returned list of analytics configurations is complete. A value of
        /// true indicates that the list is not complete and the NextContinuationToken will be provided
        /// for a subsequent request.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>Indicates whether the returned list of analytics configurations is complete. A value of
        /// true indicates that the list is not complete and the NextContinuationToken will be provided
        /// for a subsequent request.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>The marker that is used as a starting point for this analytics configuration list
        /// response. This value is present if it was sent in the request.</p>
        pub fn continuation_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.continuation_token = Some(input.into());
            self
        }
        /// <p>The marker that is used as a starting point for this analytics configuration list
        /// response. This value is present if it was sent in the request.</p>
        pub fn set_continuation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.continuation_token = input;
            self
        }
        /// <p>
        /// <code>NextContinuationToken</code> is sent when <code>isTruncated</code> is true, which
        /// indicates that there are more analytics configurations to list. The next request must
        /// include this <code>NextContinuationToken</code>. The token is obfuscated and is not a
        /// usable value.</p>
        pub fn next_continuation_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_continuation_token = Some(input.into());
            self
        }
        /// <p>
        /// <code>NextContinuationToken</code> is sent when <code>isTruncated</code> is true, which
        /// indicates that there are more analytics configurations to list. The next request must
        /// include this <code>NextContinuationToken</code>. The token is obfuscated and is not a
        /// usable value.</p>
        pub fn set_next_continuation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_continuation_token = input;
            self
        }
        /// Appends an item to `analytics_configuration_list`.
        ///
        /// To override the contents of this collection use [`set_analytics_configuration_list`](Self::set_analytics_configuration_list).
        ///
        /// <p>The list of analytics configurations for a bucket.</p>
        pub fn analytics_configuration_list(
            mut self,
            input: impl Into<crate::model::AnalyticsConfiguration>,
        ) -> Self {
            let mut v = self.analytics_configuration_list.unwrap_or_default();
            v.push(input.into());
            self.analytics_configuration_list = Some(v);
            self
        }
        /// <p>The list of analytics configurations for a bucket.</p>
        pub fn set_analytics_configuration_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AnalyticsConfiguration>>,
        ) -> Self {
            self.analytics_configuration_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBucketAnalyticsConfigurationsOutput`](crate::output::ListBucketAnalyticsConfigurationsOutput)
        pub fn build(self) -> crate::output::ListBucketAnalyticsConfigurationsOutput {
            crate::output::ListBucketAnalyticsConfigurationsOutput {
                is_truncated: self.is_truncated.unwrap_or_default(),
                continuation_token: self.continuation_token,
                next_continuation_token: self.next_continuation_token,
                analytics_configuration_list: self.analytics_configuration_list,
            }
        }
    }
}
impl ListBucketAnalyticsConfigurationsOutput {
    /// Creates a new builder-style object to manufacture [`ListBucketAnalyticsConfigurationsOutput`](crate::output::ListBucketAnalyticsConfigurationsOutput)
    pub fn builder() -> crate::output::list_bucket_analytics_configurations_output::Builder {
        crate::output::list_bucket_analytics_configurations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HeadObjectOutput {
    /// <p>Specifies whether the object retrieved was (true) or was not (false) a Delete Marker. If
    /// false, this response header does not appear in the response.</p>
    pub delete_marker: bool,
    /// <p>Indicates that a range of bytes was specified.</p>
    pub accept_ranges: std::option::Option<std::string::String>,
    /// <p>If the object expiration is configured (see PUT Bucket lifecycle), the response includes
    /// this header. It includes the expiry-date and rule-id key-value pairs providing object
    /// expiration information. The value of the rule-id is URL encoded.</p>
    pub expiration: std::option::Option<std::string::String>,
    /// <p>If the object is an archived object (an object whose storage class is GLACIER), the
    /// response includes this header if either the archive restoration is in progress (see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_RestoreObject.html">RestoreObject</a> or an archive copy is already restored.</p>
    ///
    /// <p> If an archive copy is already restored, the header value indicates when Amazon S3 is
    /// scheduled to delete the object copy. For example:</p>
    ///
    /// <p>
    /// <code>x-amz-restore: ongoing-request="false", expiry-date="Fri, 21 Dec 2012 00:00:00
    /// GMT"</code>
    /// </p>
    ///
    /// <p>If the object restoration is in progress, the header returns the value
    /// <code>ongoing-request="true"</code>.</p>
    ///
    /// <p>For more information about archiving objects, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html#lifecycle-transition-general-considerations">Transitioning Objects: General Considerations</a>.</p>
    pub restore: std::option::Option<std::string::String>,
    /// <p>The archive state of the head object.</p>
    pub archive_status: std::option::Option<crate::model::ArchiveStatus>,
    /// <p>Creation date of the object.</p>
    pub last_modified: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Size of the body in bytes.</p>
    pub content_length: i64,
    /// <p>An ETag is an opaque identifier assigned by a web server to a specific version of a
    /// resource found at a URL.</p>
    pub e_tag: std::option::Option<std::string::String>,
    /// <p>This is set to the number of metadata entries not returned in <code>x-amz-meta</code>
    /// headers. This can happen if you create metadata using an API like SOAP that supports more
    /// flexible metadata than the REST API. For example, using SOAP, you can create metadata whose
    /// values are not legal HTTP headers.</p>
    pub missing_meta: i32,
    /// <p>Version of the object.</p>
    pub version_id: std::option::Option<std::string::String>,
    /// <p>Specifies caching behavior along the request/reply chain.</p>
    pub cache_control: std::option::Option<std::string::String>,
    /// <p>Specifies presentational information for the object.</p>
    pub content_disposition: std::option::Option<std::string::String>,
    /// <p>Specifies what content encodings have been applied to the object and thus what decoding
    /// mechanisms must be applied to obtain the media-type referenced by the Content-Type header
    /// field.</p>
    pub content_encoding: std::option::Option<std::string::String>,
    /// <p>The language the content is in.</p>
    pub content_language: std::option::Option<std::string::String>,
    /// <p>A standard MIME type describing the format of the object data.</p>
    pub content_type: std::option::Option<std::string::String>,
    /// <p>The date and time at which the object is no longer cacheable.</p>
    pub expires: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>If the bucket is configured as a website, redirects requests for this object to another
    /// object in the same bucket or to an external URL. Amazon S3 stores the value of this header in
    /// the object metadata.</p>
    pub website_redirect_location: std::option::Option<std::string::String>,
    /// <p>If the object is stored using server-side encryption either with an Amazon Web Services KMS key or
    /// an Amazon S3-managed encryption key, the response includes this header with
    /// the value of the server-side encryption algorithm used when storing this object in Amazon
    /// S3 (for example, AES256, aws:kms).</p>
    pub server_side_encryption: std::option::Option<crate::model::ServerSideEncryption>,
    /// <p>A map of metadata to store with the object in S3.</p>
    pub metadata:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>If server-side encryption with a customer-provided encryption key was requested, the
    /// response will include this header confirming the encryption algorithm used.</p>
    pub sse_customer_algorithm: std::option::Option<std::string::String>,
    /// <p>If server-side encryption with a customer-provided encryption key was requested, the
    /// response will include this header to provide round-trip message integrity verification of
    /// the customer-provided encryption key.</p>
    pub sse_customer_key_md5: std::option::Option<std::string::String>,
    /// <p>If present, specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric
    /// customer managed key that was used for the object.</p>
    pub ssekms_key_id: std::option::Option<std::string::String>,
    /// <p>Indicates whether the object uses an S3 Bucket Key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
    pub bucket_key_enabled: bool,
    /// <p>Provides storage class information of the object. Amazon S3 returns this header for all
    /// objects except for S3 Standard storage class objects.</p>
    ///
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage
    /// Classes</a>.</p>
    pub storage_class: std::option::Option<crate::model::StorageClass>,
    /// <p>If present, indicates that the requester was successfully charged for the
    /// request.</p>
    pub request_charged: std::option::Option<crate::model::RequestCharged>,
    /// <p>Amazon S3 can return this header if your request involves a bucket that is either a source or
    /// a destination in a replication rule.</p>
    ///
    /// <p>In replication, you have a source bucket on which you configure replication and
    /// destination bucket or buckets where Amazon S3 stores object replicas. When you request an object
    /// (<code>GetObject</code>) or object metadata (<code>HeadObject</code>) from these
    /// buckets, Amazon S3 will return the <code>x-amz-replication-status</code> header in the response
    /// as follows:</p>
    /// <ul>
    /// <li>
    /// <p>If requesting an object from the source bucket — Amazon S3 will return the
    /// <code>x-amz-replication-status</code> header if the object in your request is
    /// eligible for replication.</p>
    /// <p> For example, suppose that in your replication configuration, you specify object
    /// prefix <code>TaxDocs</code> requesting Amazon S3 to replicate objects with key prefix
    /// <code>TaxDocs</code>. Any objects you upload with this key name prefix, for
    /// example <code>TaxDocs/document1.pdf</code>, are eligible for replication. For any
    /// object request with this key name prefix, Amazon S3 will return the
    /// <code>x-amz-replication-status</code> header with value PENDING, COMPLETED or
    /// FAILED indicating object replication status.</p>
    /// </li>
    /// <li>
    /// <p>If requesting an object from a destination bucket — Amazon S3 will return the
    /// <code>x-amz-replication-status</code> header with value REPLICA if the object in
    /// your request is a replica that Amazon S3 created and there is no replica modification
    /// replication in progress.</p>
    /// </li>
    /// <li>
    /// <p>When replicating objects to multiple destination buckets the
    /// <code>x-amz-replication-status</code> header acts differently. The header of the
    /// source object will only return a value of COMPLETED when replication is successful to
    /// all destinations. The header will remain at value PENDING until replication has
    /// completed for all destinations. If one or more destinations fails replication the
    /// header will return FAILED. </p>
    /// </li>
    /// </ul>
    ///
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Replication</a>.</p>
    pub replication_status: std::option::Option<crate::model::ReplicationStatus>,
    /// <p>The count of parts this object has.</p>
    pub parts_count: i32,
    /// <p>The Object Lock mode, if any, that's in effect for this object. This header is only
    /// returned if the requester has the <code>s3:GetObjectRetention</code> permission. For more
    /// information about S3 Object Lock, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Object
    /// Lock</a>. </p>
    pub object_lock_mode: std::option::Option<crate::model::ObjectLockMode>,
    /// <p>The date and time when the Object Lock retention period expires. This header is only
    /// returned if the requester has the <code>s3:GetObjectRetention</code> permission.</p>
    pub object_lock_retain_until_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Specifies whether a legal hold is in effect for this object. This header is only
    /// returned if the requester has the <code>s3:GetObjectLegalHold</code> permission. This
    /// header is not returned if the specified version of this object has never had a legal hold
    /// applied. For more information about S3 Object Lock, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Object Lock</a>.</p>
    pub object_lock_legal_hold_status: std::option::Option<crate::model::ObjectLockLegalHoldStatus>,
}
impl HeadObjectOutput {
    /// <p>Specifies whether the object retrieved was (true) or was not (false) a Delete Marker. If
    /// false, this response header does not appear in the response.</p>
    pub fn delete_marker(&self) -> bool {
        self.delete_marker
    }
    /// <p>Indicates that a range of bytes was specified.</p>
    pub fn accept_ranges(&self) -> std::option::Option<&str> {
        self.accept_ranges.as_deref()
    }
    /// <p>If the object expiration is configured (see PUT Bucket lifecycle), the response includes
    /// this header. It includes the expiry-date and rule-id key-value pairs providing object
    /// expiration information. The value of the rule-id is URL encoded.</p>
    pub fn expiration(&self) -> std::option::Option<&str> {
        self.expiration.as_deref()
    }
    /// <p>If the object is an archived object (an object whose storage class is GLACIER), the
    /// response includes this header if either the archive restoration is in progress (see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_RestoreObject.html">RestoreObject</a> or an archive copy is already restored.</p>
    ///
    /// <p> If an archive copy is already restored, the header value indicates when Amazon S3 is
    /// scheduled to delete the object copy. For example:</p>
    ///
    /// <p>
    /// <code>x-amz-restore: ongoing-request="false", expiry-date="Fri, 21 Dec 2012 00:00:00
    /// GMT"</code>
    /// </p>
    ///
    /// <p>If the object restoration is in progress, the header returns the value
    /// <code>ongoing-request="true"</code>.</p>
    ///
    /// <p>For more information about archiving objects, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html#lifecycle-transition-general-considerations">Transitioning Objects: General Considerations</a>.</p>
    pub fn restore(&self) -> std::option::Option<&str> {
        self.restore.as_deref()
    }
    /// <p>The archive state of the head object.</p>
    pub fn archive_status(&self) -> std::option::Option<&crate::model::ArchiveStatus> {
        self.archive_status.as_ref()
    }
    /// <p>Creation date of the object.</p>
    pub fn last_modified(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified.as_ref()
    }
    /// <p>Size of the body in bytes.</p>
    pub fn content_length(&self) -> i64 {
        self.content_length
    }
    /// <p>An ETag is an opaque identifier assigned by a web server to a specific version of a
    /// resource found at a URL.</p>
    pub fn e_tag(&self) -> std::option::Option<&str> {
        self.e_tag.as_deref()
    }
    /// <p>This is set to the number of metadata entries not returned in <code>x-amz-meta</code>
    /// headers. This can happen if you create metadata using an API like SOAP that supports more
    /// flexible metadata than the REST API. For example, using SOAP, you can create metadata whose
    /// values are not legal HTTP headers.</p>
    pub fn missing_meta(&self) -> i32 {
        self.missing_meta
    }
    /// <p>Version of the object.</p>
    pub fn version_id(&self) -> std::option::Option<&str> {
        self.version_id.as_deref()
    }
    /// <p>Specifies caching behavior along the request/reply chain.</p>
    pub fn cache_control(&self) -> std::option::Option<&str> {
        self.cache_control.as_deref()
    }
    /// <p>Specifies presentational information for the object.</p>
    pub fn content_disposition(&self) -> std::option::Option<&str> {
        self.content_disposition.as_deref()
    }
    /// <p>Specifies what content encodings have been applied to the object and thus what decoding
    /// mechanisms must be applied to obtain the media-type referenced by the Content-Type header
    /// field.</p>
    pub fn content_encoding(&self) -> std::option::Option<&str> {
        self.content_encoding.as_deref()
    }
    /// <p>The language the content is in.</p>
    pub fn content_language(&self) -> std::option::Option<&str> {
        self.content_language.as_deref()
    }
    /// <p>A standard MIME type describing the format of the object data.</p>
    pub fn content_type(&self) -> std::option::Option<&str> {
        self.content_type.as_deref()
    }
    /// <p>The date and time at which the object is no longer cacheable.</p>
    pub fn expires(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.expires.as_ref()
    }
    /// <p>If the bucket is configured as a website, redirects requests for this object to another
    /// object in the same bucket or to an external URL. Amazon S3 stores the value of this header in
    /// the object metadata.</p>
    pub fn website_redirect_location(&self) -> std::option::Option<&str> {
        self.website_redirect_location.as_deref()
    }
    /// <p>If the object is stored using server-side encryption either with an Amazon Web Services KMS key or
    /// an Amazon S3-managed encryption key, the response includes this header with
    /// the value of the server-side encryption algorithm used when storing this object in Amazon
    /// S3 (for example, AES256, aws:kms).</p>
    pub fn server_side_encryption(
        &self,
    ) -> std::option::Option<&crate::model::ServerSideEncryption> {
        self.server_side_encryption.as_ref()
    }
    /// <p>A map of metadata to store with the object in S3.</p>
    pub fn metadata(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.metadata.as_ref()
    }
    /// <p>If server-side encryption with a customer-provided encryption key was requested, the
    /// response will include this header confirming the encryption algorithm used.</p>
    pub fn sse_customer_algorithm(&self) -> std::option::Option<&str> {
        self.sse_customer_algorithm.as_deref()
    }
    /// <p>If server-side encryption with a customer-provided encryption key was requested, the
    /// response will include this header to provide round-trip message integrity verification of
    /// the customer-provided encryption key.</p>
    pub fn sse_customer_key_md5(&self) -> std::option::Option<&str> {
        self.sse_customer_key_md5.as_deref()
    }
    /// <p>If present, specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric
    /// customer managed key that was used for the object.</p>
    pub fn ssekms_key_id(&self) -> std::option::Option<&str> {
        self.ssekms_key_id.as_deref()
    }
    /// <p>Indicates whether the object uses an S3 Bucket Key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
    pub fn bucket_key_enabled(&self) -> bool {
        self.bucket_key_enabled
    }
    /// <p>Provides storage class information of the object. Amazon S3 returns this header for all
    /// objects except for S3 Standard storage class objects.</p>
    ///
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage
    /// Classes</a>.</p>
    pub fn storage_class(&self) -> std::option::Option<&crate::model::StorageClass> {
        self.storage_class.as_ref()
    }
    /// <p>If present, indicates that the requester was successfully charged for the
    /// request.</p>
    pub fn request_charged(&self) -> std::option::Option<&crate::model::RequestCharged> {
        self.request_charged.as_ref()
    }
    /// <p>Amazon S3 can return this header if your request involves a bucket that is either a source or
    /// a destination in a replication rule.</p>
    ///
    /// <p>In replication, you have a source bucket on which you configure replication and
    /// destination bucket or buckets where Amazon S3 stores object replicas. When you request an object
    /// (<code>GetObject</code>) or object metadata (<code>HeadObject</code>) from these
    /// buckets, Amazon S3 will return the <code>x-amz-replication-status</code> header in the response
    /// as follows:</p>
    /// <ul>
    /// <li>
    /// <p>If requesting an object from the source bucket — Amazon S3 will return the
    /// <code>x-amz-replication-status</code> header if the object in your request is
    /// eligible for replication.</p>
    /// <p> For example, suppose that in your replication configuration, you specify object
    /// prefix <code>TaxDocs</code> requesting Amazon S3 to replicate objects with key prefix
    /// <code>TaxDocs</code>. Any objects you upload with this key name prefix, for
    /// example <code>TaxDocs/document1.pdf</code>, are eligible for replication. For any
    /// object request with this key name prefix, Amazon S3 will return the
    /// <code>x-amz-replication-status</code> header with value PENDING, COMPLETED or
    /// FAILED indicating object replication status.</p>
    /// </li>
    /// <li>
    /// <p>If requesting an object from a destination bucket — Amazon S3 will return the
    /// <code>x-amz-replication-status</code> header with value REPLICA if the object in
    /// your request is a replica that Amazon S3 created and there is no replica modification
    /// replication in progress.</p>
    /// </li>
    /// <li>
    /// <p>When replicating objects to multiple destination buckets the
    /// <code>x-amz-replication-status</code> header acts differently. The header of the
    /// source object will only return a value of COMPLETED when replication is successful to
    /// all destinations. The header will remain at value PENDING until replication has
    /// completed for all destinations. If one or more destinations fails replication the
    /// header will return FAILED. </p>
    /// </li>
    /// </ul>
    ///
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Replication</a>.</p>
    pub fn replication_status(&self) -> std::option::Option<&crate::model::ReplicationStatus> {
        self.replication_status.as_ref()
    }
    /// <p>The count of parts this object has.</p>
    pub fn parts_count(&self) -> i32 {
        self.parts_count
    }
    /// <p>The Object Lock mode, if any, that's in effect for this object. This header is only
    /// returned if the requester has the <code>s3:GetObjectRetention</code> permission. For more
    /// information about S3 Object Lock, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Object
    /// Lock</a>. </p>
    pub fn object_lock_mode(&self) -> std::option::Option<&crate::model::ObjectLockMode> {
        self.object_lock_mode.as_ref()
    }
    /// <p>The date and time when the Object Lock retention period expires. This header is only
    /// returned if the requester has the <code>s3:GetObjectRetention</code> permission.</p>
    pub fn object_lock_retain_until_date(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.object_lock_retain_until_date.as_ref()
    }
    /// <p>Specifies whether a legal hold is in effect for this object. This header is only
    /// returned if the requester has the <code>s3:GetObjectLegalHold</code> permission. This
    /// header is not returned if the specified version of this object has never had a legal hold
    /// applied. For more information about S3 Object Lock, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Object Lock</a>.</p>
    pub fn object_lock_legal_hold_status(
        &self,
    ) -> std::option::Option<&crate::model::ObjectLockLegalHoldStatus> {
        self.object_lock_legal_hold_status.as_ref()
    }
}
impl std::fmt::Debug for HeadObjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HeadObjectOutput");
        formatter.field("delete_marker", &self.delete_marker);
        formatter.field("accept_ranges", &self.accept_ranges);
        formatter.field("expiration", &self.expiration);
        formatter.field("restore", &self.restore);
        formatter.field("archive_status", &self.archive_status);
        formatter.field("last_modified", &self.last_modified);
        formatter.field("content_length", &self.content_length);
        formatter.field("e_tag", &self.e_tag);
        formatter.field("missing_meta", &self.missing_meta);
        formatter.field("version_id", &self.version_id);
        formatter.field("cache_control", &self.cache_control);
        formatter.field("content_disposition", &self.content_disposition);
        formatter.field("content_encoding", &self.content_encoding);
        formatter.field("content_language", &self.content_language);
        formatter.field("content_type", &self.content_type);
        formatter.field("expires", &self.expires);
        formatter.field("website_redirect_location", &self.website_redirect_location);
        formatter.field("server_side_encryption", &self.server_side_encryption);
        formatter.field("metadata", &self.metadata);
        formatter.field("sse_customer_algorithm", &self.sse_customer_algorithm);
        formatter.field("sse_customer_key_md5", &self.sse_customer_key_md5);
        formatter.field("ssekms_key_id", &"*** Sensitive Data Redacted ***");
        formatter.field("bucket_key_enabled", &self.bucket_key_enabled);
        formatter.field("storage_class", &self.storage_class);
        formatter.field("request_charged", &self.request_charged);
        formatter.field("replication_status", &self.replication_status);
        formatter.field("parts_count", &self.parts_count);
        formatter.field("object_lock_mode", &self.object_lock_mode);
        formatter.field(
            "object_lock_retain_until_date",
            &self.object_lock_retain_until_date,
        );
        formatter.field(
            "object_lock_legal_hold_status",
            &self.object_lock_legal_hold_status,
        );
        formatter.finish()
    }
}
/// See [`HeadObjectOutput`](crate::output::HeadObjectOutput)
pub mod head_object_output {
    /// A builder for [`HeadObjectOutput`](crate::output::HeadObjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delete_marker: std::option::Option<bool>,
        pub(crate) accept_ranges: std::option::Option<std::string::String>,
        pub(crate) expiration: std::option::Option<std::string::String>,
        pub(crate) restore: std::option::Option<std::string::String>,
        pub(crate) archive_status: std::option::Option<crate::model::ArchiveStatus>,
        pub(crate) last_modified: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) content_length: std::option::Option<i64>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
        pub(crate) missing_meta: std::option::Option<i32>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) cache_control: std::option::Option<std::string::String>,
        pub(crate) content_disposition: std::option::Option<std::string::String>,
        pub(crate) content_encoding: std::option::Option<std::string::String>,
        pub(crate) content_language: std::option::Option<std::string::String>,
        pub(crate) content_type: std::option::Option<std::string::String>,
        pub(crate) expires: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) website_redirect_location: std::option::Option<std::string::String>,
        pub(crate) server_side_encryption: std::option::Option<crate::model::ServerSideEncryption>,
        pub(crate) metadata: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) sse_customer_algorithm: std::option::Option<std::string::String>,
        pub(crate) sse_customer_key_md5: std::option::Option<std::string::String>,
        pub(crate) ssekms_key_id: std::option::Option<std::string::String>,
        pub(crate) bucket_key_enabled: std::option::Option<bool>,
        pub(crate) storage_class: std::option::Option<crate::model::StorageClass>,
        pub(crate) request_charged: std::option::Option<crate::model::RequestCharged>,
        pub(crate) replication_status: std::option::Option<crate::model::ReplicationStatus>,
        pub(crate) parts_count: std::option::Option<i32>,
        pub(crate) object_lock_mode: std::option::Option<crate::model::ObjectLockMode>,
        pub(crate) object_lock_retain_until_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) object_lock_legal_hold_status:
            std::option::Option<crate::model::ObjectLockLegalHoldStatus>,
    }
    impl Builder {
        /// <p>Specifies whether the object retrieved was (true) or was not (false) a Delete Marker. If
        /// false, this response header does not appear in the response.</p>
        pub fn delete_marker(mut self, input: bool) -> Self {
            self.delete_marker = Some(input);
            self
        }
        /// <p>Specifies whether the object retrieved was (true) or was not (false) a Delete Marker. If
        /// false, this response header does not appear in the response.</p>
        pub fn set_delete_marker(mut self, input: std::option::Option<bool>) -> Self {
            self.delete_marker = input;
            self
        }
        /// <p>Indicates that a range of bytes was specified.</p>
        pub fn accept_ranges(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_ranges = Some(input.into());
            self
        }
        /// <p>Indicates that a range of bytes was specified.</p>
        pub fn set_accept_ranges(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_ranges = input;
            self
        }
        /// <p>If the object expiration is configured (see PUT Bucket lifecycle), the response includes
        /// this header. It includes the expiry-date and rule-id key-value pairs providing object
        /// expiration information. The value of the rule-id is URL encoded.</p>
        pub fn expiration(mut self, input: impl Into<std::string::String>) -> Self {
            self.expiration = Some(input.into());
            self
        }
        /// <p>If the object expiration is configured (see PUT Bucket lifecycle), the response includes
        /// this header. It includes the expiry-date and rule-id key-value pairs providing object
        /// expiration information. The value of the rule-id is URL encoded.</p>
        pub fn set_expiration(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.expiration = input;
            self
        }
        /// <p>If the object is an archived object (an object whose storage class is GLACIER), the
        /// response includes this header if either the archive restoration is in progress (see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_RestoreObject.html">RestoreObject</a> or an archive copy is already restored.</p>
        ///
        /// <p> If an archive copy is already restored, the header value indicates when Amazon S3 is
        /// scheduled to delete the object copy. For example:</p>
        ///
        /// <p>
        /// <code>x-amz-restore: ongoing-request="false", expiry-date="Fri, 21 Dec 2012 00:00:00
        /// GMT"</code>
        /// </p>
        ///
        /// <p>If the object restoration is in progress, the header returns the value
        /// <code>ongoing-request="true"</code>.</p>
        ///
        /// <p>For more information about archiving objects, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html#lifecycle-transition-general-considerations">Transitioning Objects: General Considerations</a>.</p>
        pub fn restore(mut self, input: impl Into<std::string::String>) -> Self {
            self.restore = Some(input.into());
            self
        }
        /// <p>If the object is an archived object (an object whose storage class is GLACIER), the
        /// response includes this header if either the archive restoration is in progress (see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_RestoreObject.html">RestoreObject</a> or an archive copy is already restored.</p>
        ///
        /// <p> If an archive copy is already restored, the header value indicates when Amazon S3 is
        /// scheduled to delete the object copy. For example:</p>
        ///
        /// <p>
        /// <code>x-amz-restore: ongoing-request="false", expiry-date="Fri, 21 Dec 2012 00:00:00
        /// GMT"</code>
        /// </p>
        ///
        /// <p>If the object restoration is in progress, the header returns the value
        /// <code>ongoing-request="true"</code>.</p>
        ///
        /// <p>For more information about archiving objects, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html#lifecycle-transition-general-considerations">Transitioning Objects: General Considerations</a>.</p>
        pub fn set_restore(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.restore = input;
            self
        }
        /// <p>The archive state of the head object.</p>
        pub fn archive_status(mut self, input: crate::model::ArchiveStatus) -> Self {
            self.archive_status = Some(input);
            self
        }
        /// <p>The archive state of the head object.</p>
        pub fn set_archive_status(
            mut self,
            input: std::option::Option<crate::model::ArchiveStatus>,
        ) -> Self {
            self.archive_status = input;
            self
        }
        /// <p>Creation date of the object.</p>
        pub fn last_modified(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified = Some(input);
            self
        }
        /// <p>Creation date of the object.</p>
        pub fn set_last_modified(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified = input;
            self
        }
        /// <p>Size of the body in bytes.</p>
        pub fn content_length(mut self, input: i64) -> Self {
            self.content_length = Some(input);
            self
        }
        /// <p>Size of the body in bytes.</p>
        pub fn set_content_length(mut self, input: std::option::Option<i64>) -> Self {
            self.content_length = input;
            self
        }
        /// <p>An ETag is an opaque identifier assigned by a web server to a specific version of a
        /// resource found at a URL.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>An ETag is an opaque identifier assigned by a web server to a specific version of a
        /// resource found at a URL.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// <p>This is set to the number of metadata entries not returned in <code>x-amz-meta</code>
        /// headers. This can happen if you create metadata using an API like SOAP that supports more
        /// flexible metadata than the REST API. For example, using SOAP, you can create metadata whose
        /// values are not legal HTTP headers.</p>
        pub fn missing_meta(mut self, input: i32) -> Self {
            self.missing_meta = Some(input);
            self
        }
        /// <p>This is set to the number of metadata entries not returned in <code>x-amz-meta</code>
        /// headers. This can happen if you create metadata using an API like SOAP that supports more
        /// flexible metadata than the REST API. For example, using SOAP, you can create metadata whose
        /// values are not legal HTTP headers.</p>
        pub fn set_missing_meta(mut self, input: std::option::Option<i32>) -> Self {
            self.missing_meta = input;
            self
        }
        /// <p>Version of the object.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>Version of the object.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>Specifies caching behavior along the request/reply chain.</p>
        pub fn cache_control(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_control = Some(input.into());
            self
        }
        /// <p>Specifies caching behavior along the request/reply chain.</p>
        pub fn set_cache_control(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_control = input;
            self
        }
        /// <p>Specifies presentational information for the object.</p>
        pub fn content_disposition(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_disposition = Some(input.into());
            self
        }
        /// <p>Specifies presentational information for the object.</p>
        pub fn set_content_disposition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.content_disposition = input;
            self
        }
        /// <p>Specifies what content encodings have been applied to the object and thus what decoding
        /// mechanisms must be applied to obtain the media-type referenced by the Content-Type header
        /// field.</p>
        pub fn content_encoding(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_encoding = Some(input.into());
            self
        }
        /// <p>Specifies what content encodings have been applied to the object and thus what decoding
        /// mechanisms must be applied to obtain the media-type referenced by the Content-Type header
        /// field.</p>
        pub fn set_content_encoding(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.content_encoding = input;
            self
        }
        /// <p>The language the content is in.</p>
        pub fn content_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_language = Some(input.into());
            self
        }
        /// <p>The language the content is in.</p>
        pub fn set_content_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.content_language = input;
            self
        }
        /// <p>A standard MIME type describing the format of the object data.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>A standard MIME type describing the format of the object data.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// <p>The date and time at which the object is no longer cacheable.</p>
        pub fn expires(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.expires = Some(input);
            self
        }
        /// <p>The date and time at which the object is no longer cacheable.</p>
        pub fn set_expires(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.expires = input;
            self
        }
        /// <p>If the bucket is configured as a website, redirects requests for this object to another
        /// object in the same bucket or to an external URL. Amazon S3 stores the value of this header in
        /// the object metadata.</p>
        pub fn website_redirect_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.website_redirect_location = Some(input.into());
            self
        }
        /// <p>If the bucket is configured as a website, redirects requests for this object to another
        /// object in the same bucket or to an external URL. Amazon S3 stores the value of this header in
        /// the object metadata.</p>
        pub fn set_website_redirect_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.website_redirect_location = input;
            self
        }
        /// <p>If the object is stored using server-side encryption either with an Amazon Web Services KMS key or
        /// an Amazon S3-managed encryption key, the response includes this header with
        /// the value of the server-side encryption algorithm used when storing this object in Amazon
        /// S3 (for example, AES256, aws:kms).</p>
        pub fn server_side_encryption(mut self, input: crate::model::ServerSideEncryption) -> Self {
            self.server_side_encryption = Some(input);
            self
        }
        /// <p>If the object is stored using server-side encryption either with an Amazon Web Services KMS key or
        /// an Amazon S3-managed encryption key, the response includes this header with
        /// the value of the server-side encryption algorithm used when storing this object in Amazon
        /// S3 (for example, AES256, aws:kms).</p>
        pub fn set_server_side_encryption(
            mut self,
            input: std::option::Option<crate::model::ServerSideEncryption>,
        ) -> Self {
            self.server_side_encryption = input;
            self
        }
        /// Adds a key-value pair to `metadata`.
        ///
        /// To override the contents of this collection use [`set_metadata`](Self::set_metadata).
        ///
        /// <p>A map of metadata to store with the object in S3.</p>
        pub fn metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.metadata = Some(hash_map);
            self
        }
        /// <p>A map of metadata to store with the object in S3.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// <p>If server-side encryption with a customer-provided encryption key was requested, the
        /// response will include this header confirming the encryption algorithm used.</p>
        pub fn sse_customer_algorithm(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_customer_algorithm = Some(input.into());
            self
        }
        /// <p>If server-side encryption with a customer-provided encryption key was requested, the
        /// response will include this header confirming the encryption algorithm used.</p>
        pub fn set_sse_customer_algorithm(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_customer_algorithm = input;
            self
        }
        /// <p>If server-side encryption with a customer-provided encryption key was requested, the
        /// response will include this header to provide round-trip message integrity verification of
        /// the customer-provided encryption key.</p>
        pub fn sse_customer_key_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_customer_key_md5 = Some(input.into());
            self
        }
        /// <p>If server-side encryption with a customer-provided encryption key was requested, the
        /// response will include this header to provide round-trip message integrity verification of
        /// the customer-provided encryption key.</p>
        pub fn set_sse_customer_key_md5(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_customer_key_md5 = input;
            self
        }
        /// <p>If present, specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric
        /// customer managed key that was used for the object.</p>
        pub fn ssekms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssekms_key_id = Some(input.into());
            self
        }
        /// <p>If present, specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric
        /// customer managed key that was used for the object.</p>
        pub fn set_ssekms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssekms_key_id = input;
            self
        }
        /// <p>Indicates whether the object uses an S3 Bucket Key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
        pub fn bucket_key_enabled(mut self, input: bool) -> Self {
            self.bucket_key_enabled = Some(input);
            self
        }
        /// <p>Indicates whether the object uses an S3 Bucket Key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
        pub fn set_bucket_key_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.bucket_key_enabled = input;
            self
        }
        /// <p>Provides storage class information of the object. Amazon S3 returns this header for all
        /// objects except for S3 Standard storage class objects.</p>
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage
        /// Classes</a>.</p>
        pub fn storage_class(mut self, input: crate::model::StorageClass) -> Self {
            self.storage_class = Some(input);
            self
        }
        /// <p>Provides storage class information of the object. Amazon S3 returns this header for all
        /// objects except for S3 Standard storage class objects.</p>
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage
        /// Classes</a>.</p>
        pub fn set_storage_class(
            mut self,
            input: std::option::Option<crate::model::StorageClass>,
        ) -> Self {
            self.storage_class = input;
            self
        }
        /// <p>If present, indicates that the requester was successfully charged for the
        /// request.</p>
        pub fn request_charged(mut self, input: crate::model::RequestCharged) -> Self {
            self.request_charged = Some(input);
            self
        }
        /// <p>If present, indicates that the requester was successfully charged for the
        /// request.</p>
        pub fn set_request_charged(
            mut self,
            input: std::option::Option<crate::model::RequestCharged>,
        ) -> Self {
            self.request_charged = input;
            self
        }
        /// <p>Amazon S3 can return this header if your request involves a bucket that is either a source or
        /// a destination in a replication rule.</p>
        ///
        /// <p>In replication, you have a source bucket on which you configure replication and
        /// destination bucket or buckets where Amazon S3 stores object replicas. When you request an object
        /// (<code>GetObject</code>) or object metadata (<code>HeadObject</code>) from these
        /// buckets, Amazon S3 will return the <code>x-amz-replication-status</code> header in the response
        /// as follows:</p>
        /// <ul>
        /// <li>
        /// <p>If requesting an object from the source bucket — Amazon S3 will return the
        /// <code>x-amz-replication-status</code> header if the object in your request is
        /// eligible for replication.</p>
        /// <p> For example, suppose that in your replication configuration, you specify object
        /// prefix <code>TaxDocs</code> requesting Amazon S3 to replicate objects with key prefix
        /// <code>TaxDocs</code>. Any objects you upload with this key name prefix, for
        /// example <code>TaxDocs/document1.pdf</code>, are eligible for replication. For any
        /// object request with this key name prefix, Amazon S3 will return the
        /// <code>x-amz-replication-status</code> header with value PENDING, COMPLETED or
        /// FAILED indicating object replication status.</p>
        /// </li>
        /// <li>
        /// <p>If requesting an object from a destination bucket — Amazon S3 will return the
        /// <code>x-amz-replication-status</code> header with value REPLICA if the object in
        /// your request is a replica that Amazon S3 created and there is no replica modification
        /// replication in progress.</p>
        /// </li>
        /// <li>
        /// <p>When replicating objects to multiple destination buckets the
        /// <code>x-amz-replication-status</code> header acts differently. The header of the
        /// source object will only return a value of COMPLETED when replication is successful to
        /// all destinations. The header will remain at value PENDING until replication has
        /// completed for all destinations. If one or more destinations fails replication the
        /// header will return FAILED. </p>
        /// </li>
        /// </ul>
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Replication</a>.</p>
        pub fn replication_status(mut self, input: crate::model::ReplicationStatus) -> Self {
            self.replication_status = Some(input);
            self
        }
        /// <p>Amazon S3 can return this header if your request involves a bucket that is either a source or
        /// a destination in a replication rule.</p>
        ///
        /// <p>In replication, you have a source bucket on which you configure replication and
        /// destination bucket or buckets where Amazon S3 stores object replicas. When you request an object
        /// (<code>GetObject</code>) or object metadata (<code>HeadObject</code>) from these
        /// buckets, Amazon S3 will return the <code>x-amz-replication-status</code> header in the response
        /// as follows:</p>
        /// <ul>
        /// <li>
        /// <p>If requesting an object from the source bucket — Amazon S3 will return the
        /// <code>x-amz-replication-status</code> header if the object in your request is
        /// eligible for replication.</p>
        /// <p> For example, suppose that in your replication configuration, you specify object
        /// prefix <code>TaxDocs</code> requesting Amazon S3 to replicate objects with key prefix
        /// <code>TaxDocs</code>. Any objects you upload with this key name prefix, for
        /// example <code>TaxDocs/document1.pdf</code>, are eligible for replication. For any
        /// object request with this key name prefix, Amazon S3 will return the
        /// <code>x-amz-replication-status</code> header with value PENDING, COMPLETED or
        /// FAILED indicating object replication status.</p>
        /// </li>
        /// <li>
        /// <p>If requesting an object from a destination bucket — Amazon S3 will return the
        /// <code>x-amz-replication-status</code> header with value REPLICA if the object in
        /// your request is a replica that Amazon S3 created and there is no replica modification
        /// replication in progress.</p>
        /// </li>
        /// <li>
        /// <p>When replicating objects to multiple destination buckets the
        /// <code>x-amz-replication-status</code> header acts differently. The header of the
        /// source object will only return a value of COMPLETED when replication is successful to
        /// all destinations. The header will remain at value PENDING until replication has
        /// completed for all destinations. If one or more destinations fails replication the
        /// header will return FAILED. </p>
        /// </li>
        /// </ul>
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Replication</a>.</p>
        pub fn set_replication_status(
            mut self,
            input: std::option::Option<crate::model::ReplicationStatus>,
        ) -> Self {
            self.replication_status = input;
            self
        }
        /// <p>The count of parts this object has.</p>
        pub fn parts_count(mut self, input: i32) -> Self {
            self.parts_count = Some(input);
            self
        }
        /// <p>The count of parts this object has.</p>
        pub fn set_parts_count(mut self, input: std::option::Option<i32>) -> Self {
            self.parts_count = input;
            self
        }
        /// <p>The Object Lock mode, if any, that's in effect for this object. This header is only
        /// returned if the requester has the <code>s3:GetObjectRetention</code> permission. For more
        /// information about S3 Object Lock, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Object
        /// Lock</a>. </p>
        pub fn object_lock_mode(mut self, input: crate::model::ObjectLockMode) -> Self {
            self.object_lock_mode = Some(input);
            self
        }
        /// <p>The Object Lock mode, if any, that's in effect for this object. This header is only
        /// returned if the requester has the <code>s3:GetObjectRetention</code> permission. For more
        /// information about S3 Object Lock, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Object
        /// Lock</a>. </p>
        pub fn set_object_lock_mode(
            mut self,
            input: std::option::Option<crate::model::ObjectLockMode>,
        ) -> Self {
            self.object_lock_mode = input;
            self
        }
        /// <p>The date and time when the Object Lock retention period expires. This header is only
        /// returned if the requester has the <code>s3:GetObjectRetention</code> permission.</p>
        pub fn object_lock_retain_until_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.object_lock_retain_until_date = Some(input);
            self
        }
        /// <p>The date and time when the Object Lock retention period expires. This header is only
        /// returned if the requester has the <code>s3:GetObjectRetention</code> permission.</p>
        pub fn set_object_lock_retain_until_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.object_lock_retain_until_date = input;
            self
        }
        /// <p>Specifies whether a legal hold is in effect for this object. This header is only
        /// returned if the requester has the <code>s3:GetObjectLegalHold</code> permission. This
        /// header is not returned if the specified version of this object has never had a legal hold
        /// applied. For more information about S3 Object Lock, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Object Lock</a>.</p>
        pub fn object_lock_legal_hold_status(
            mut self,
            input: crate::model::ObjectLockLegalHoldStatus,
        ) -> Self {
            self.object_lock_legal_hold_status = Some(input);
            self
        }
        /// <p>Specifies whether a legal hold is in effect for this object. This header is only
        /// returned if the requester has the <code>s3:GetObjectLegalHold</code> permission. This
        /// header is not returned if the specified version of this object has never had a legal hold
        /// applied. For more information about S3 Object Lock, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Object Lock</a>.</p>
        pub fn set_object_lock_legal_hold_status(
            mut self,
            input: std::option::Option<crate::model::ObjectLockLegalHoldStatus>,
        ) -> Self {
            self.object_lock_legal_hold_status = input;
            self
        }
        /// Consumes the builder and constructs a [`HeadObjectOutput`](crate::output::HeadObjectOutput)
        pub fn build(self) -> crate::output::HeadObjectOutput {
            crate::output::HeadObjectOutput {
                delete_marker: self.delete_marker.unwrap_or_default(),
                accept_ranges: self.accept_ranges,
                expiration: self.expiration,
                restore: self.restore,
                archive_status: self.archive_status,
                last_modified: self.last_modified,
                content_length: self.content_length.unwrap_or_default(),
                e_tag: self.e_tag,
                missing_meta: self.missing_meta.unwrap_or_default(),
                version_id: self.version_id,
                cache_control: self.cache_control,
                content_disposition: self.content_disposition,
                content_encoding: self.content_encoding,
                content_language: self.content_language,
                content_type: self.content_type,
                expires: self.expires,
                website_redirect_location: self.website_redirect_location,
                server_side_encryption: self.server_side_encryption,
                metadata: self.metadata,
                sse_customer_algorithm: self.sse_customer_algorithm,
                sse_customer_key_md5: self.sse_customer_key_md5,
                ssekms_key_id: self.ssekms_key_id,
                bucket_key_enabled: self.bucket_key_enabled.unwrap_or_default(),
                storage_class: self.storage_class,
                request_charged: self.request_charged,
                replication_status: self.replication_status,
                parts_count: self.parts_count.unwrap_or_default(),
                object_lock_mode: self.object_lock_mode,
                object_lock_retain_until_date: self.object_lock_retain_until_date,
                object_lock_legal_hold_status: self.object_lock_legal_hold_status,
            }
        }
    }
}
impl HeadObjectOutput {
    /// Creates a new builder-style object to manufacture [`HeadObjectOutput`](crate::output::HeadObjectOutput)
    pub fn builder() -> crate::output::head_object_output::Builder {
        crate::output::head_object_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HeadBucketOutput {}
impl std::fmt::Debug for HeadBucketOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HeadBucketOutput");
        formatter.finish()
    }
}
/// See [`HeadBucketOutput`](crate::output::HeadBucketOutput)
pub mod head_bucket_output {
    /// A builder for [`HeadBucketOutput`](crate::output::HeadBucketOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`HeadBucketOutput`](crate::output::HeadBucketOutput)
        pub fn build(self) -> crate::output::HeadBucketOutput {
            crate::output::HeadBucketOutput {}
        }
    }
}
impl HeadBucketOutput {
    /// Creates a new builder-style object to manufacture [`HeadBucketOutput`](crate::output::HeadBucketOutput)
    pub fn builder() -> crate::output::head_bucket_output::Builder {
        crate::output::head_bucket_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPublicAccessBlockOutput {
    /// <p>The <code>PublicAccessBlock</code> configuration currently in effect for this Amazon S3
    /// bucket.</p>
    pub public_access_block_configuration:
        std::option::Option<crate::model::PublicAccessBlockConfiguration>,
}
impl GetPublicAccessBlockOutput {
    /// <p>The <code>PublicAccessBlock</code> configuration currently in effect for this Amazon S3
    /// bucket.</p>
    pub fn public_access_block_configuration(
        &self,
    ) -> std::option::Option<&crate::model::PublicAccessBlockConfiguration> {
        self.public_access_block_configuration.as_ref()
    }
}
impl std::fmt::Debug for GetPublicAccessBlockOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPublicAccessBlockOutput");
        formatter.field(
            "public_access_block_configuration",
            &self.public_access_block_configuration,
        );
        formatter.finish()
    }
}
/// See [`GetPublicAccessBlockOutput`](crate::output::GetPublicAccessBlockOutput)
pub mod get_public_access_block_output {
    /// A builder for [`GetPublicAccessBlockOutput`](crate::output::GetPublicAccessBlockOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) public_access_block_configuration:
            std::option::Option<crate::model::PublicAccessBlockConfiguration>,
    }
    impl Builder {
        /// <p>The <code>PublicAccessBlock</code> configuration currently in effect for this Amazon S3
        /// bucket.</p>
        pub fn public_access_block_configuration(
            mut self,
            input: crate::model::PublicAccessBlockConfiguration,
        ) -> Self {
            self.public_access_block_configuration = Some(input);
            self
        }
        /// <p>The <code>PublicAccessBlock</code> configuration currently in effect for this Amazon S3
        /// bucket.</p>
        pub fn set_public_access_block_configuration(
            mut self,
            input: std::option::Option<crate::model::PublicAccessBlockConfiguration>,
        ) -> Self {
            self.public_access_block_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPublicAccessBlockOutput`](crate::output::GetPublicAccessBlockOutput)
        pub fn build(self) -> crate::output::GetPublicAccessBlockOutput {
            crate::output::GetPublicAccessBlockOutput {
                public_access_block_configuration: self.public_access_block_configuration,
            }
        }
    }
}
impl GetPublicAccessBlockOutput {
    /// Creates a new builder-style object to manufacture [`GetPublicAccessBlockOutput`](crate::output::GetPublicAccessBlockOutput)
    pub fn builder() -> crate::output::get_public_access_block_output::Builder {
        crate::output::get_public_access_block_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
pub struct GetObjectTorrentOutput {
    /// <p>A Bencoded dictionary as defined by the BitTorrent specification</p>
    pub body: aws_smithy_http::byte_stream::ByteStream,
    /// <p>If present, indicates that the requester was successfully charged for the
    /// request.</p>
    pub request_charged: std::option::Option<crate::model::RequestCharged>,
}
impl GetObjectTorrentOutput {
    /// <p>A Bencoded dictionary as defined by the BitTorrent specification</p>
    pub fn body(&self) -> &aws_smithy_http::byte_stream::ByteStream {
        &self.body
    }
    /// <p>If present, indicates that the requester was successfully charged for the
    /// request.</p>
    pub fn request_charged(&self) -> std::option::Option<&crate::model::RequestCharged> {
        self.request_charged.as_ref()
    }
}
impl std::fmt::Debug for GetObjectTorrentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetObjectTorrentOutput");
        formatter.field("body", &self.body);
        formatter.field("request_charged", &self.request_charged);
        formatter.finish()
    }
}
/// See [`GetObjectTorrentOutput`](crate::output::GetObjectTorrentOutput)
pub mod get_object_torrent_output {
    /// A builder for [`GetObjectTorrentOutput`](crate::output::GetObjectTorrentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) body: std::option::Option<aws_smithy_http::byte_stream::ByteStream>,
        pub(crate) request_charged: std::option::Option<crate::model::RequestCharged>,
    }
    impl Builder {
        /// <p>A Bencoded dictionary as defined by the BitTorrent specification</p>
        pub fn body(mut self, input: aws_smithy_http::byte_stream::ByteStream) -> Self {
            self.body = Some(input);
            self
        }
        /// <p>A Bencoded dictionary as defined by the BitTorrent specification</p>
        pub fn set_body(
            mut self,
            input: std::option::Option<aws_smithy_http::byte_stream::ByteStream>,
        ) -> Self {
            self.body = input;
            self
        }
        /// <p>If present, indicates that the requester was successfully charged for the
        /// request.</p>
        pub fn request_charged(mut self, input: crate::model::RequestCharged) -> Self {
            self.request_charged = Some(input);
            self
        }
        /// <p>If present, indicates that the requester was successfully charged for the
        /// request.</p>
        pub fn set_request_charged(
            mut self,
            input: std::option::Option<crate::model::RequestCharged>,
        ) -> Self {
            self.request_charged = input;
            self
        }
        /// Consumes the builder and constructs a [`GetObjectTorrentOutput`](crate::output::GetObjectTorrentOutput)
        pub fn build(self) -> crate::output::GetObjectTorrentOutput {
            crate::output::GetObjectTorrentOutput {
                body: self.body.unwrap_or_default(),
                request_charged: self.request_charged,
            }
        }
    }
}
impl GetObjectTorrentOutput {
    /// Creates a new builder-style object to manufacture [`GetObjectTorrentOutput`](crate::output::GetObjectTorrentOutput)
    pub fn builder() -> crate::output::get_object_torrent_output::Builder {
        crate::output::get_object_torrent_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetObjectTaggingOutput {
    /// <p>The versionId of the object for which you got the tagging information.</p>
    pub version_id: std::option::Option<std::string::String>,
    /// <p>Contains the tag set.</p>
    pub tag_set: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl GetObjectTaggingOutput {
    /// <p>The versionId of the object for which you got the tagging information.</p>
    pub fn version_id(&self) -> std::option::Option<&str> {
        self.version_id.as_deref()
    }
    /// <p>Contains the tag set.</p>
    pub fn tag_set(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tag_set.as_deref()
    }
}
impl std::fmt::Debug for GetObjectTaggingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetObjectTaggingOutput");
        formatter.field("version_id", &self.version_id);
        formatter.field("tag_set", &self.tag_set);
        formatter.finish()
    }
}
/// See [`GetObjectTaggingOutput`](crate::output::GetObjectTaggingOutput)
pub mod get_object_tagging_output {
    /// A builder for [`GetObjectTaggingOutput`](crate::output::GetObjectTaggingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) tag_set: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The versionId of the object for which you got the tagging information.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The versionId of the object for which you got the tagging information.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// Appends an item to `tag_set`.
        ///
        /// To override the contents of this collection use [`set_tag_set`](Self::set_tag_set).
        ///
        /// <p>Contains the tag set.</p>
        pub fn tag_set(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tag_set.unwrap_or_default();
            v.push(input.into());
            self.tag_set = Some(v);
            self
        }
        /// <p>Contains the tag set.</p>
        pub fn set_tag_set(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tag_set = input;
            self
        }
        /// Consumes the builder and constructs a [`GetObjectTaggingOutput`](crate::output::GetObjectTaggingOutput)
        pub fn build(self) -> crate::output::GetObjectTaggingOutput {
            crate::output::GetObjectTaggingOutput {
                version_id: self.version_id,
                tag_set: self.tag_set,
            }
        }
    }
}
impl GetObjectTaggingOutput {
    /// Creates a new builder-style object to manufacture [`GetObjectTaggingOutput`](crate::output::GetObjectTaggingOutput)
    pub fn builder() -> crate::output::get_object_tagging_output::Builder {
        crate::output::get_object_tagging_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetObjectRetentionOutput {
    /// <p>The container element for an object's retention settings.</p>
    pub retention: std::option::Option<crate::model::ObjectLockRetention>,
}
impl GetObjectRetentionOutput {
    /// <p>The container element for an object's retention settings.</p>
    pub fn retention(&self) -> std::option::Option<&crate::model::ObjectLockRetention> {
        self.retention.as_ref()
    }
}
impl std::fmt::Debug for GetObjectRetentionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetObjectRetentionOutput");
        formatter.field("retention", &self.retention);
        formatter.finish()
    }
}
/// See [`GetObjectRetentionOutput`](crate::output::GetObjectRetentionOutput)
pub mod get_object_retention_output {
    /// A builder for [`GetObjectRetentionOutput`](crate::output::GetObjectRetentionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) retention: std::option::Option<crate::model::ObjectLockRetention>,
    }
    impl Builder {
        /// <p>The container element for an object's retention settings.</p>
        pub fn retention(mut self, input: crate::model::ObjectLockRetention) -> Self {
            self.retention = Some(input);
            self
        }
        /// <p>The container element for an object's retention settings.</p>
        pub fn set_retention(
            mut self,
            input: std::option::Option<crate::model::ObjectLockRetention>,
        ) -> Self {
            self.retention = input;
            self
        }
        /// Consumes the builder and constructs a [`GetObjectRetentionOutput`](crate::output::GetObjectRetentionOutput)
        pub fn build(self) -> crate::output::GetObjectRetentionOutput {
            crate::output::GetObjectRetentionOutput {
                retention: self.retention,
            }
        }
    }
}
impl GetObjectRetentionOutput {
    /// Creates a new builder-style object to manufacture [`GetObjectRetentionOutput`](crate::output::GetObjectRetentionOutput)
    pub fn builder() -> crate::output::get_object_retention_output::Builder {
        crate::output::get_object_retention_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetObjectLockConfigurationOutput {
    /// <p>The specified bucket's Object Lock configuration.</p>
    pub object_lock_configuration: std::option::Option<crate::model::ObjectLockConfiguration>,
}
impl GetObjectLockConfigurationOutput {
    /// <p>The specified bucket's Object Lock configuration.</p>
    pub fn object_lock_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ObjectLockConfiguration> {
        self.object_lock_configuration.as_ref()
    }
}
impl std::fmt::Debug for GetObjectLockConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetObjectLockConfigurationOutput");
        formatter.field("object_lock_configuration", &self.object_lock_configuration);
        formatter.finish()
    }
}
/// See [`GetObjectLockConfigurationOutput`](crate::output::GetObjectLockConfigurationOutput)
pub mod get_object_lock_configuration_output {
    /// A builder for [`GetObjectLockConfigurationOutput`](crate::output::GetObjectLockConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object_lock_configuration:
            std::option::Option<crate::model::ObjectLockConfiguration>,
    }
    impl Builder {
        /// <p>The specified bucket's Object Lock configuration.</p>
        pub fn object_lock_configuration(
            mut self,
            input: crate::model::ObjectLockConfiguration,
        ) -> Self {
            self.object_lock_configuration = Some(input);
            self
        }
        /// <p>The specified bucket's Object Lock configuration.</p>
        pub fn set_object_lock_configuration(
            mut self,
            input: std::option::Option<crate::model::ObjectLockConfiguration>,
        ) -> Self {
            self.object_lock_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`GetObjectLockConfigurationOutput`](crate::output::GetObjectLockConfigurationOutput)
        pub fn build(self) -> crate::output::GetObjectLockConfigurationOutput {
            crate::output::GetObjectLockConfigurationOutput {
                object_lock_configuration: self.object_lock_configuration,
            }
        }
    }
}
impl GetObjectLockConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`GetObjectLockConfigurationOutput`](crate::output::GetObjectLockConfigurationOutput)
    pub fn builder() -> crate::output::get_object_lock_configuration_output::Builder {
        crate::output::get_object_lock_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetObjectLegalHoldOutput {
    /// <p>The current Legal Hold status for the specified object.</p>
    pub legal_hold: std::option::Option<crate::model::ObjectLockLegalHold>,
}
impl GetObjectLegalHoldOutput {
    /// <p>The current Legal Hold status for the specified object.</p>
    pub fn legal_hold(&self) -> std::option::Option<&crate::model::ObjectLockLegalHold> {
        self.legal_hold.as_ref()
    }
}
impl std::fmt::Debug for GetObjectLegalHoldOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetObjectLegalHoldOutput");
        formatter.field("legal_hold", &self.legal_hold);
        formatter.finish()
    }
}
/// See [`GetObjectLegalHoldOutput`](crate::output::GetObjectLegalHoldOutput)
pub mod get_object_legal_hold_output {
    /// A builder for [`GetObjectLegalHoldOutput`](crate::output::GetObjectLegalHoldOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) legal_hold: std::option::Option<crate::model::ObjectLockLegalHold>,
    }
    impl Builder {
        /// <p>The current Legal Hold status for the specified object.</p>
        pub fn legal_hold(mut self, input: crate::model::ObjectLockLegalHold) -> Self {
            self.legal_hold = Some(input);
            self
        }
        /// <p>The current Legal Hold status for the specified object.</p>
        pub fn set_legal_hold(
            mut self,
            input: std::option::Option<crate::model::ObjectLockLegalHold>,
        ) -> Self {
            self.legal_hold = input;
            self
        }
        /// Consumes the builder and constructs a [`GetObjectLegalHoldOutput`](crate::output::GetObjectLegalHoldOutput)
        pub fn build(self) -> crate::output::GetObjectLegalHoldOutput {
            crate::output::GetObjectLegalHoldOutput {
                legal_hold: self.legal_hold,
            }
        }
    }
}
impl GetObjectLegalHoldOutput {
    /// Creates a new builder-style object to manufacture [`GetObjectLegalHoldOutput`](crate::output::GetObjectLegalHoldOutput)
    pub fn builder() -> crate::output::get_object_legal_hold_output::Builder {
        crate::output::get_object_legal_hold_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetObjectAclOutput {
    /// <p> Container for the bucket owner's display name and ID.</p>
    pub owner: std::option::Option<crate::model::Owner>,
    /// <p>A list of grants.</p>
    pub grants: std::option::Option<std::vec::Vec<crate::model::Grant>>,
    /// <p>If present, indicates that the requester was successfully charged for the
    /// request.</p>
    pub request_charged: std::option::Option<crate::model::RequestCharged>,
}
impl GetObjectAclOutput {
    /// <p> Container for the bucket owner's display name and ID.</p>
    pub fn owner(&self) -> std::option::Option<&crate::model::Owner> {
        self.owner.as_ref()
    }
    /// <p>A list of grants.</p>
    pub fn grants(&self) -> std::option::Option<&[crate::model::Grant]> {
        self.grants.as_deref()
    }
    /// <p>If present, indicates that the requester was successfully charged for the
    /// request.</p>
    pub fn request_charged(&self) -> std::option::Option<&crate::model::RequestCharged> {
        self.request_charged.as_ref()
    }
}
impl std::fmt::Debug for GetObjectAclOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetObjectAclOutput");
        formatter.field("owner", &self.owner);
        formatter.field("grants", &self.grants);
        formatter.field("request_charged", &self.request_charged);
        formatter.finish()
    }
}
/// See [`GetObjectAclOutput`](crate::output::GetObjectAclOutput)
pub mod get_object_acl_output {
    /// A builder for [`GetObjectAclOutput`](crate::output::GetObjectAclOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner: std::option::Option<crate::model::Owner>,
        pub(crate) grants: std::option::Option<std::vec::Vec<crate::model::Grant>>,
        pub(crate) request_charged: std::option::Option<crate::model::RequestCharged>,
    }
    impl Builder {
        /// <p> Container for the bucket owner's display name and ID.</p>
        pub fn owner(mut self, input: crate::model::Owner) -> Self {
            self.owner = Some(input);
            self
        }
        /// <p> Container for the bucket owner's display name and ID.</p>
        pub fn set_owner(mut self, input: std::option::Option<crate::model::Owner>) -> Self {
            self.owner = input;
            self
        }
        /// Appends an item to `grants`.
        ///
        /// To override the contents of this collection use [`set_grants`](Self::set_grants).
        ///
        /// <p>A list of grants.</p>
        pub fn grants(mut self, input: impl Into<crate::model::Grant>) -> Self {
            let mut v = self.grants.unwrap_or_default();
            v.push(input.into());
            self.grants = Some(v);
            self
        }
        /// <p>A list of grants.</p>
        pub fn set_grants(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Grant>>,
        ) -> Self {
            self.grants = input;
            self
        }
        /// <p>If present, indicates that the requester was successfully charged for the
        /// request.</p>
        pub fn request_charged(mut self, input: crate::model::RequestCharged) -> Self {
            self.request_charged = Some(input);
            self
        }
        /// <p>If present, indicates that the requester was successfully charged for the
        /// request.</p>
        pub fn set_request_charged(
            mut self,
            input: std::option::Option<crate::model::RequestCharged>,
        ) -> Self {
            self.request_charged = input;
            self
        }
        /// Consumes the builder and constructs a [`GetObjectAclOutput`](crate::output::GetObjectAclOutput)
        pub fn build(self) -> crate::output::GetObjectAclOutput {
            crate::output::GetObjectAclOutput {
                owner: self.owner,
                grants: self.grants,
                request_charged: self.request_charged,
            }
        }
    }
}
impl GetObjectAclOutput {
    /// Creates a new builder-style object to manufacture [`GetObjectAclOutput`](crate::output::GetObjectAclOutput)
    pub fn builder() -> crate::output::get_object_acl_output::Builder {
        crate::output::get_object_acl_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
pub struct GetObjectOutput {
    /// <p>Object data.</p>
    pub body: aws_smithy_http::byte_stream::ByteStream,
    /// <p>Specifies whether the object retrieved was (true) or was not (false) a Delete Marker. If
    /// false, this response header does not appear in the response.</p>
    pub delete_marker: bool,
    /// <p>Indicates that a range of bytes was specified.</p>
    pub accept_ranges: std::option::Option<std::string::String>,
    /// <p>If the object expiration is configured (see PUT Bucket lifecycle), the response includes
    /// this header. It includes the expiry-date and rule-id key-value pairs providing object
    /// expiration information. The value of the rule-id is URL encoded.</p>
    pub expiration: std::option::Option<std::string::String>,
    /// <p>Provides information about object restoration action and expiration time of the
    /// restored object copy.</p>
    pub restore: std::option::Option<std::string::String>,
    /// <p>Creation date of the object.</p>
    pub last_modified: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Size of the body in bytes.</p>
    pub content_length: i64,
    /// <p>An ETag is an opaque identifier assigned by a web server to a specific version of a
    /// resource found at a URL.</p>
    pub e_tag: std::option::Option<std::string::String>,
    /// <p>This is set to the number of metadata entries not returned in <code>x-amz-meta</code>
    /// headers. This can happen if you create metadata using an API like SOAP that supports more
    /// flexible metadata than the REST API. For example, using SOAP, you can create metadata whose
    /// values are not legal HTTP headers.</p>
    pub missing_meta: i32,
    /// <p>Version of the object.</p>
    pub version_id: std::option::Option<std::string::String>,
    /// <p>Specifies caching behavior along the request/reply chain.</p>
    pub cache_control: std::option::Option<std::string::String>,
    /// <p>Specifies presentational information for the object.</p>
    pub content_disposition: std::option::Option<std::string::String>,
    /// <p>Specifies what content encodings have been applied to the object and thus what decoding
    /// mechanisms must be applied to obtain the media-type referenced by the Content-Type header
    /// field.</p>
    pub content_encoding: std::option::Option<std::string::String>,
    /// <p>The language the content is in.</p>
    pub content_language: std::option::Option<std::string::String>,
    /// <p>The portion of the object returned in the response.</p>
    pub content_range: std::option::Option<std::string::String>,
    /// <p>A standard MIME type describing the format of the object data.</p>
    pub content_type: std::option::Option<std::string::String>,
    /// <p>The date and time at which the object is no longer cacheable.</p>
    pub expires: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>If the bucket is configured as a website, redirects requests for this object to another
    /// object in the same bucket or to an external URL. Amazon S3 stores the value of this header in
    /// the object metadata.</p>
    pub website_redirect_location: std::option::Option<std::string::String>,
    /// <p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example,
    /// AES256, aws:kms).</p>
    pub server_side_encryption: std::option::Option<crate::model::ServerSideEncryption>,
    /// <p>A map of metadata to store with the object in S3.</p>
    pub metadata:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>If server-side encryption with a customer-provided encryption key was requested, the
    /// response will include this header confirming the encryption algorithm used.</p>
    pub sse_customer_algorithm: std::option::Option<std::string::String>,
    /// <p>If server-side encryption with a customer-provided encryption key was requested, the
    /// response will include this header to provide round-trip message integrity verification of
    /// the customer-provided encryption key.</p>
    pub sse_customer_key_md5: std::option::Option<std::string::String>,
    /// <p>If present, specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric
    /// customer managed key that was used for the object.</p>
    pub ssekms_key_id: std::option::Option<std::string::String>,
    /// <p>Indicates whether the object uses an S3 Bucket Key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
    pub bucket_key_enabled: bool,
    /// <p>Provides storage class information of the object. Amazon S3 returns this header for all
    /// objects except for S3 Standard storage class objects.</p>
    pub storage_class: std::option::Option<crate::model::StorageClass>,
    /// <p>If present, indicates that the requester was successfully charged for the
    /// request.</p>
    pub request_charged: std::option::Option<crate::model::RequestCharged>,
    /// <p>Amazon S3 can return this if your request involves a bucket that is either a source or
    /// destination in a replication rule.</p>
    pub replication_status: std::option::Option<crate::model::ReplicationStatus>,
    /// <p>The count of parts this object has.</p>
    pub parts_count: i32,
    /// <p>The number of tags, if any, on the object.</p>
    pub tag_count: i32,
    /// <p>The Object Lock mode currently in place for this object.</p>
    pub object_lock_mode: std::option::Option<crate::model::ObjectLockMode>,
    /// <p>The date and time when this object's Object Lock will expire.</p>
    pub object_lock_retain_until_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Indicates whether this object has an active legal hold. This field is only returned if
    /// you have permission to view an object's legal hold status. </p>
    pub object_lock_legal_hold_status: std::option::Option<crate::model::ObjectLockLegalHoldStatus>,
}
impl GetObjectOutput {
    /// <p>Object data.</p>
    pub fn body(&self) -> &aws_smithy_http::byte_stream::ByteStream {
        &self.body
    }
    /// <p>Specifies whether the object retrieved was (true) or was not (false) a Delete Marker. If
    /// false, this response header does not appear in the response.</p>
    pub fn delete_marker(&self) -> bool {
        self.delete_marker
    }
    /// <p>Indicates that a range of bytes was specified.</p>
    pub fn accept_ranges(&self) -> std::option::Option<&str> {
        self.accept_ranges.as_deref()
    }
    /// <p>If the object expiration is configured (see PUT Bucket lifecycle), the response includes
    /// this header. It includes the expiry-date and rule-id key-value pairs providing object
    /// expiration information. The value of the rule-id is URL encoded.</p>
    pub fn expiration(&self) -> std::option::Option<&str> {
        self.expiration.as_deref()
    }
    /// <p>Provides information about object restoration action and expiration time of the
    /// restored object copy.</p>
    pub fn restore(&self) -> std::option::Option<&str> {
        self.restore.as_deref()
    }
    /// <p>Creation date of the object.</p>
    pub fn last_modified(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified.as_ref()
    }
    /// <p>Size of the body in bytes.</p>
    pub fn content_length(&self) -> i64 {
        self.content_length
    }
    /// <p>An ETag is an opaque identifier assigned by a web server to a specific version of a
    /// resource found at a URL.</p>
    pub fn e_tag(&self) -> std::option::Option<&str> {
        self.e_tag.as_deref()
    }
    /// <p>This is set to the number of metadata entries not returned in <code>x-amz-meta</code>
    /// headers. This can happen if you create metadata using an API like SOAP that supports more
    /// flexible metadata than the REST API. For example, using SOAP, you can create metadata whose
    /// values are not legal HTTP headers.</p>
    pub fn missing_meta(&self) -> i32 {
        self.missing_meta
    }
    /// <p>Version of the object.</p>
    pub fn version_id(&self) -> std::option::Option<&str> {
        self.version_id.as_deref()
    }
    /// <p>Specifies caching behavior along the request/reply chain.</p>
    pub fn cache_control(&self) -> std::option::Option<&str> {
        self.cache_control.as_deref()
    }
    /// <p>Specifies presentational information for the object.</p>
    pub fn content_disposition(&self) -> std::option::Option<&str> {
        self.content_disposition.as_deref()
    }
    /// <p>Specifies what content encodings have been applied to the object and thus what decoding
    /// mechanisms must be applied to obtain the media-type referenced by the Content-Type header
    /// field.</p>
    pub fn content_encoding(&self) -> std::option::Option<&str> {
        self.content_encoding.as_deref()
    }
    /// <p>The language the content is in.</p>
    pub fn content_language(&self) -> std::option::Option<&str> {
        self.content_language.as_deref()
    }
    /// <p>The portion of the object returned in the response.</p>
    pub fn content_range(&self) -> std::option::Option<&str> {
        self.content_range.as_deref()
    }
    /// <p>A standard MIME type describing the format of the object data.</p>
    pub fn content_type(&self) -> std::option::Option<&str> {
        self.content_type.as_deref()
    }
    /// <p>The date and time at which the object is no longer cacheable.</p>
    pub fn expires(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.expires.as_ref()
    }
    /// <p>If the bucket is configured as a website, redirects requests for this object to another
    /// object in the same bucket or to an external URL. Amazon S3 stores the value of this header in
    /// the object metadata.</p>
    pub fn website_redirect_location(&self) -> std::option::Option<&str> {
        self.website_redirect_location.as_deref()
    }
    /// <p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example,
    /// AES256, aws:kms).</p>
    pub fn server_side_encryption(
        &self,
    ) -> std::option::Option<&crate::model::ServerSideEncryption> {
        self.server_side_encryption.as_ref()
    }
    /// <p>A map of metadata to store with the object in S3.</p>
    pub fn metadata(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.metadata.as_ref()
    }
    /// <p>If server-side encryption with a customer-provided encryption key was requested, the
    /// response will include this header confirming the encryption algorithm used.</p>
    pub fn sse_customer_algorithm(&self) -> std::option::Option<&str> {
        self.sse_customer_algorithm.as_deref()
    }
    /// <p>If server-side encryption with a customer-provided encryption key was requested, the
    /// response will include this header to provide round-trip message integrity verification of
    /// the customer-provided encryption key.</p>
    pub fn sse_customer_key_md5(&self) -> std::option::Option<&str> {
        self.sse_customer_key_md5.as_deref()
    }
    /// <p>If present, specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric
    /// customer managed key that was used for the object.</p>
    pub fn ssekms_key_id(&self) -> std::option::Option<&str> {
        self.ssekms_key_id.as_deref()
    }
    /// <p>Indicates whether the object uses an S3 Bucket Key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
    pub fn bucket_key_enabled(&self) -> bool {
        self.bucket_key_enabled
    }
    /// <p>Provides storage class information of the object. Amazon S3 returns this header for all
    /// objects except for S3 Standard storage class objects.</p>
    pub fn storage_class(&self) -> std::option::Option<&crate::model::StorageClass> {
        self.storage_class.as_ref()
    }
    /// <p>If present, indicates that the requester was successfully charged for the
    /// request.</p>
    pub fn request_charged(&self) -> std::option::Option<&crate::model::RequestCharged> {
        self.request_charged.as_ref()
    }
    /// <p>Amazon S3 can return this if your request involves a bucket that is either a source or
    /// destination in a replication rule.</p>
    pub fn replication_status(&self) -> std::option::Option<&crate::model::ReplicationStatus> {
        self.replication_status.as_ref()
    }
    /// <p>The count of parts this object has.</p>
    pub fn parts_count(&self) -> i32 {
        self.parts_count
    }
    /// <p>The number of tags, if any, on the object.</p>
    pub fn tag_count(&self) -> i32 {
        self.tag_count
    }
    /// <p>The Object Lock mode currently in place for this object.</p>
    pub fn object_lock_mode(&self) -> std::option::Option<&crate::model::ObjectLockMode> {
        self.object_lock_mode.as_ref()
    }
    /// <p>The date and time when this object's Object Lock will expire.</p>
    pub fn object_lock_retain_until_date(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.object_lock_retain_until_date.as_ref()
    }
    /// <p>Indicates whether this object has an active legal hold. This field is only returned if
    /// you have permission to view an object's legal hold status. </p>
    pub fn object_lock_legal_hold_status(
        &self,
    ) -> std::option::Option<&crate::model::ObjectLockLegalHoldStatus> {
        self.object_lock_legal_hold_status.as_ref()
    }
}
impl std::fmt::Debug for GetObjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetObjectOutput");
        formatter.field("body", &self.body);
        formatter.field("delete_marker", &self.delete_marker);
        formatter.field("accept_ranges", &self.accept_ranges);
        formatter.field("expiration", &self.expiration);
        formatter.field("restore", &self.restore);
        formatter.field("last_modified", &self.last_modified);
        formatter.field("content_length", &self.content_length);
        formatter.field("e_tag", &self.e_tag);
        formatter.field("missing_meta", &self.missing_meta);
        formatter.field("version_id", &self.version_id);
        formatter.field("cache_control", &self.cache_control);
        formatter.field("content_disposition", &self.content_disposition);
        formatter.field("content_encoding", &self.content_encoding);
        formatter.field("content_language", &self.content_language);
        formatter.field("content_range", &self.content_range);
        formatter.field("content_type", &self.content_type);
        formatter.field("expires", &self.expires);
        formatter.field("website_redirect_location", &self.website_redirect_location);
        formatter.field("server_side_encryption", &self.server_side_encryption);
        formatter.field("metadata", &self.metadata);
        formatter.field("sse_customer_algorithm", &self.sse_customer_algorithm);
        formatter.field("sse_customer_key_md5", &self.sse_customer_key_md5);
        formatter.field("ssekms_key_id", &"*** Sensitive Data Redacted ***");
        formatter.field("bucket_key_enabled", &self.bucket_key_enabled);
        formatter.field("storage_class", &self.storage_class);
        formatter.field("request_charged", &self.request_charged);
        formatter.field("replication_status", &self.replication_status);
        formatter.field("parts_count", &self.parts_count);
        formatter.field("tag_count", &self.tag_count);
        formatter.field("object_lock_mode", &self.object_lock_mode);
        formatter.field(
            "object_lock_retain_until_date",
            &self.object_lock_retain_until_date,
        );
        formatter.field(
            "object_lock_legal_hold_status",
            &self.object_lock_legal_hold_status,
        );
        formatter.finish()
    }
}
/// See [`GetObjectOutput`](crate::output::GetObjectOutput)
pub mod get_object_output {
    /// A builder for [`GetObjectOutput`](crate::output::GetObjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) body: std::option::Option<aws_smithy_http::byte_stream::ByteStream>,
        pub(crate) delete_marker: std::option::Option<bool>,
        pub(crate) accept_ranges: std::option::Option<std::string::String>,
        pub(crate) expiration: std::option::Option<std::string::String>,
        pub(crate) restore: std::option::Option<std::string::String>,
        pub(crate) last_modified: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) content_length: std::option::Option<i64>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
        pub(crate) missing_meta: std::option::Option<i32>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) cache_control: std::option::Option<std::string::String>,
        pub(crate) content_disposition: std::option::Option<std::string::String>,
        pub(crate) content_encoding: std::option::Option<std::string::String>,
        pub(crate) content_language: std::option::Option<std::string::String>,
        pub(crate) content_range: std::option::Option<std::string::String>,
        pub(crate) content_type: std::option::Option<std::string::String>,
        pub(crate) expires: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) website_redirect_location: std::option::Option<std::string::String>,
        pub(crate) server_side_encryption: std::option::Option<crate::model::ServerSideEncryption>,
        pub(crate) metadata: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) sse_customer_algorithm: std::option::Option<std::string::String>,
        pub(crate) sse_customer_key_md5: std::option::Option<std::string::String>,
        pub(crate) ssekms_key_id: std::option::Option<std::string::String>,
        pub(crate) bucket_key_enabled: std::option::Option<bool>,
        pub(crate) storage_class: std::option::Option<crate::model::StorageClass>,
        pub(crate) request_charged: std::option::Option<crate::model::RequestCharged>,
        pub(crate) replication_status: std::option::Option<crate::model::ReplicationStatus>,
        pub(crate) parts_count: std::option::Option<i32>,
        pub(crate) tag_count: std::option::Option<i32>,
        pub(crate) object_lock_mode: std::option::Option<crate::model::ObjectLockMode>,
        pub(crate) object_lock_retain_until_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) object_lock_legal_hold_status:
            std::option::Option<crate::model::ObjectLockLegalHoldStatus>,
    }
    impl Builder {
        /// <p>Object data.</p>
        pub fn body(mut self, input: aws_smithy_http::byte_stream::ByteStream) -> Self {
            self.body = Some(input);
            self
        }
        /// <p>Object data.</p>
        pub fn set_body(
            mut self,
            input: std::option::Option<aws_smithy_http::byte_stream::ByteStream>,
        ) -> Self {
            self.body = input;
            self
        }
        /// <p>Specifies whether the object retrieved was (true) or was not (false) a Delete Marker. If
        /// false, this response header does not appear in the response.</p>
        pub fn delete_marker(mut self, input: bool) -> Self {
            self.delete_marker = Some(input);
            self
        }
        /// <p>Specifies whether the object retrieved was (true) or was not (false) a Delete Marker. If
        /// false, this response header does not appear in the response.</p>
        pub fn set_delete_marker(mut self, input: std::option::Option<bool>) -> Self {
            self.delete_marker = input;
            self
        }
        /// <p>Indicates that a range of bytes was specified.</p>
        pub fn accept_ranges(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept_ranges = Some(input.into());
            self
        }
        /// <p>Indicates that a range of bytes was specified.</p>
        pub fn set_accept_ranges(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.accept_ranges = input;
            self
        }
        /// <p>If the object expiration is configured (see PUT Bucket lifecycle), the response includes
        /// this header. It includes the expiry-date and rule-id key-value pairs providing object
        /// expiration information. The value of the rule-id is URL encoded.</p>
        pub fn expiration(mut self, input: impl Into<std::string::String>) -> Self {
            self.expiration = Some(input.into());
            self
        }
        /// <p>If the object expiration is configured (see PUT Bucket lifecycle), the response includes
        /// this header. It includes the expiry-date and rule-id key-value pairs providing object
        /// expiration information. The value of the rule-id is URL encoded.</p>
        pub fn set_expiration(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.expiration = input;
            self
        }
        /// <p>Provides information about object restoration action and expiration time of the
        /// restored object copy.</p>
        pub fn restore(mut self, input: impl Into<std::string::String>) -> Self {
            self.restore = Some(input.into());
            self
        }
        /// <p>Provides information about object restoration action and expiration time of the
        /// restored object copy.</p>
        pub fn set_restore(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.restore = input;
            self
        }
        /// <p>Creation date of the object.</p>
        pub fn last_modified(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified = Some(input);
            self
        }
        /// <p>Creation date of the object.</p>
        pub fn set_last_modified(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified = input;
            self
        }
        /// <p>Size of the body in bytes.</p>
        pub fn content_length(mut self, input: i64) -> Self {
            self.content_length = Some(input);
            self
        }
        /// <p>Size of the body in bytes.</p>
        pub fn set_content_length(mut self, input: std::option::Option<i64>) -> Self {
            self.content_length = input;
            self
        }
        /// <p>An ETag is an opaque identifier assigned by a web server to a specific version of a
        /// resource found at a URL.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>An ETag is an opaque identifier assigned by a web server to a specific version of a
        /// resource found at a URL.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// <p>This is set to the number of metadata entries not returned in <code>x-amz-meta</code>
        /// headers. This can happen if you create metadata using an API like SOAP that supports more
        /// flexible metadata than the REST API. For example, using SOAP, you can create metadata whose
        /// values are not legal HTTP headers.</p>
        pub fn missing_meta(mut self, input: i32) -> Self {
            self.missing_meta = Some(input);
            self
        }
        /// <p>This is set to the number of metadata entries not returned in <code>x-amz-meta</code>
        /// headers. This can happen if you create metadata using an API like SOAP that supports more
        /// flexible metadata than the REST API. For example, using SOAP, you can create metadata whose
        /// values are not legal HTTP headers.</p>
        pub fn set_missing_meta(mut self, input: std::option::Option<i32>) -> Self {
            self.missing_meta = input;
            self
        }
        /// <p>Version of the object.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>Version of the object.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>Specifies caching behavior along the request/reply chain.</p>
        pub fn cache_control(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_control = Some(input.into());
            self
        }
        /// <p>Specifies caching behavior along the request/reply chain.</p>
        pub fn set_cache_control(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_control = input;
            self
        }
        /// <p>Specifies presentational information for the object.</p>
        pub fn content_disposition(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_disposition = Some(input.into());
            self
        }
        /// <p>Specifies presentational information for the object.</p>
        pub fn set_content_disposition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.content_disposition = input;
            self
        }
        /// <p>Specifies what content encodings have been applied to the object and thus what decoding
        /// mechanisms must be applied to obtain the media-type referenced by the Content-Type header
        /// field.</p>
        pub fn content_encoding(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_encoding = Some(input.into());
            self
        }
        /// <p>Specifies what content encodings have been applied to the object and thus what decoding
        /// mechanisms must be applied to obtain the media-type referenced by the Content-Type header
        /// field.</p>
        pub fn set_content_encoding(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.content_encoding = input;
            self
        }
        /// <p>The language the content is in.</p>
        pub fn content_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_language = Some(input.into());
            self
        }
        /// <p>The language the content is in.</p>
        pub fn set_content_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.content_language = input;
            self
        }
        /// <p>The portion of the object returned in the response.</p>
        pub fn content_range(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_range = Some(input.into());
            self
        }
        /// <p>The portion of the object returned in the response.</p>
        pub fn set_content_range(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.content_range = input;
            self
        }
        /// <p>A standard MIME type describing the format of the object data.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>A standard MIME type describing the format of the object data.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// <p>The date and time at which the object is no longer cacheable.</p>
        pub fn expires(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.expires = Some(input);
            self
        }
        /// <p>The date and time at which the object is no longer cacheable.</p>
        pub fn set_expires(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.expires = input;
            self
        }
        /// <p>If the bucket is configured as a website, redirects requests for this object to another
        /// object in the same bucket or to an external URL. Amazon S3 stores the value of this header in
        /// the object metadata.</p>
        pub fn website_redirect_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.website_redirect_location = Some(input.into());
            self
        }
        /// <p>If the bucket is configured as a website, redirects requests for this object to another
        /// object in the same bucket or to an external URL. Amazon S3 stores the value of this header in
        /// the object metadata.</p>
        pub fn set_website_redirect_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.website_redirect_location = input;
            self
        }
        /// <p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example,
        /// AES256, aws:kms).</p>
        pub fn server_side_encryption(mut self, input: crate::model::ServerSideEncryption) -> Self {
            self.server_side_encryption = Some(input);
            self
        }
        /// <p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example,
        /// AES256, aws:kms).</p>
        pub fn set_server_side_encryption(
            mut self,
            input: std::option::Option<crate::model::ServerSideEncryption>,
        ) -> Self {
            self.server_side_encryption = input;
            self
        }
        /// Adds a key-value pair to `metadata`.
        ///
        /// To override the contents of this collection use [`set_metadata`](Self::set_metadata).
        ///
        /// <p>A map of metadata to store with the object in S3.</p>
        pub fn metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.metadata = Some(hash_map);
            self
        }
        /// <p>A map of metadata to store with the object in S3.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// <p>If server-side encryption with a customer-provided encryption key was requested, the
        /// response will include this header confirming the encryption algorithm used.</p>
        pub fn sse_customer_algorithm(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_customer_algorithm = Some(input.into());
            self
        }
        /// <p>If server-side encryption with a customer-provided encryption key was requested, the
        /// response will include this header confirming the encryption algorithm used.</p>
        pub fn set_sse_customer_algorithm(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_customer_algorithm = input;
            self
        }
        /// <p>If server-side encryption with a customer-provided encryption key was requested, the
        /// response will include this header to provide round-trip message integrity verification of
        /// the customer-provided encryption key.</p>
        pub fn sse_customer_key_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_customer_key_md5 = Some(input.into());
            self
        }
        /// <p>If server-side encryption with a customer-provided encryption key was requested, the
        /// response will include this header to provide round-trip message integrity verification of
        /// the customer-provided encryption key.</p>
        pub fn set_sse_customer_key_md5(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_customer_key_md5 = input;
            self
        }
        /// <p>If present, specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric
        /// customer managed key that was used for the object.</p>
        pub fn ssekms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssekms_key_id = Some(input.into());
            self
        }
        /// <p>If present, specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric
        /// customer managed key that was used for the object.</p>
        pub fn set_ssekms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssekms_key_id = input;
            self
        }
        /// <p>Indicates whether the object uses an S3 Bucket Key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
        pub fn bucket_key_enabled(mut self, input: bool) -> Self {
            self.bucket_key_enabled = Some(input);
            self
        }
        /// <p>Indicates whether the object uses an S3 Bucket Key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
        pub fn set_bucket_key_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.bucket_key_enabled = input;
            self
        }
        /// <p>Provides storage class information of the object. Amazon S3 returns this header for all
        /// objects except for S3 Standard storage class objects.</p>
        pub fn storage_class(mut self, input: crate::model::StorageClass) -> Self {
            self.storage_class = Some(input);
            self
        }
        /// <p>Provides storage class information of the object. Amazon S3 returns this header for all
        /// objects except for S3 Standard storage class objects.</p>
        pub fn set_storage_class(
            mut self,
            input: std::option::Option<crate::model::StorageClass>,
        ) -> Self {
            self.storage_class = input;
            self
        }
        /// <p>If present, indicates that the requester was successfully charged for the
        /// request.</p>
        pub fn request_charged(mut self, input: crate::model::RequestCharged) -> Self {
            self.request_charged = Some(input);
            self
        }
        /// <p>If present, indicates that the requester was successfully charged for the
        /// request.</p>
        pub fn set_request_charged(
            mut self,
            input: std::option::Option<crate::model::RequestCharged>,
        ) -> Self {
            self.request_charged = input;
            self
        }
        /// <p>Amazon S3 can return this if your request involves a bucket that is either a source or
        /// destination in a replication rule.</p>
        pub fn replication_status(mut self, input: crate::model::ReplicationStatus) -> Self {
            self.replication_status = Some(input);
            self
        }
        /// <p>Amazon S3 can return this if your request involves a bucket that is either a source or
        /// destination in a replication rule.</p>
        pub fn set_replication_status(
            mut self,
            input: std::option::Option<crate::model::ReplicationStatus>,
        ) -> Self {
            self.replication_status = input;
            self
        }
        /// <p>The count of parts this object has.</p>
        pub fn parts_count(mut self, input: i32) -> Self {
            self.parts_count = Some(input);
            self
        }
        /// <p>The count of parts this object has.</p>
        pub fn set_parts_count(mut self, input: std::option::Option<i32>) -> Self {
            self.parts_count = input;
            self
        }
        /// <p>The number of tags, if any, on the object.</p>
        pub fn tag_count(mut self, input: i32) -> Self {
            self.tag_count = Some(input);
            self
        }
        /// <p>The number of tags, if any, on the object.</p>
        pub fn set_tag_count(mut self, input: std::option::Option<i32>) -> Self {
            self.tag_count = input;
            self
        }
        /// <p>The Object Lock mode currently in place for this object.</p>
        pub fn object_lock_mode(mut self, input: crate::model::ObjectLockMode) -> Self {
            self.object_lock_mode = Some(input);
            self
        }
        /// <p>The Object Lock mode currently in place for this object.</p>
        pub fn set_object_lock_mode(
            mut self,
            input: std::option::Option<crate::model::ObjectLockMode>,
        ) -> Self {
            self.object_lock_mode = input;
            self
        }
        /// <p>The date and time when this object's Object Lock will expire.</p>
        pub fn object_lock_retain_until_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.object_lock_retain_until_date = Some(input);
            self
        }
        /// <p>The date and time when this object's Object Lock will expire.</p>
        pub fn set_object_lock_retain_until_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.object_lock_retain_until_date = input;
            self
        }
        /// <p>Indicates whether this object has an active legal hold. This field is only returned if
        /// you have permission to view an object's legal hold status. </p>
        pub fn object_lock_legal_hold_status(
            mut self,
            input: crate::model::ObjectLockLegalHoldStatus,
        ) -> Self {
            self.object_lock_legal_hold_status = Some(input);
            self
        }
        /// <p>Indicates whether this object has an active legal hold. This field is only returned if
        /// you have permission to view an object's legal hold status. </p>
        pub fn set_object_lock_legal_hold_status(
            mut self,
            input: std::option::Option<crate::model::ObjectLockLegalHoldStatus>,
        ) -> Self {
            self.object_lock_legal_hold_status = input;
            self
        }
        /// Consumes the builder and constructs a [`GetObjectOutput`](crate::output::GetObjectOutput)
        pub fn build(self) -> crate::output::GetObjectOutput {
            crate::output::GetObjectOutput {
                body: self.body.unwrap_or_default(),
                delete_marker: self.delete_marker.unwrap_or_default(),
                accept_ranges: self.accept_ranges,
                expiration: self.expiration,
                restore: self.restore,
                last_modified: self.last_modified,
                content_length: self.content_length.unwrap_or_default(),
                e_tag: self.e_tag,
                missing_meta: self.missing_meta.unwrap_or_default(),
                version_id: self.version_id,
                cache_control: self.cache_control,
                content_disposition: self.content_disposition,
                content_encoding: self.content_encoding,
                content_language: self.content_language,
                content_range: self.content_range,
                content_type: self.content_type,
                expires: self.expires,
                website_redirect_location: self.website_redirect_location,
                server_side_encryption: self.server_side_encryption,
                metadata: self.metadata,
                sse_customer_algorithm: self.sse_customer_algorithm,
                sse_customer_key_md5: self.sse_customer_key_md5,
                ssekms_key_id: self.ssekms_key_id,
                bucket_key_enabled: self.bucket_key_enabled.unwrap_or_default(),
                storage_class: self.storage_class,
                request_charged: self.request_charged,
                replication_status: self.replication_status,
                parts_count: self.parts_count.unwrap_or_default(),
                tag_count: self.tag_count.unwrap_or_default(),
                object_lock_mode: self.object_lock_mode,
                object_lock_retain_until_date: self.object_lock_retain_until_date,
                object_lock_legal_hold_status: self.object_lock_legal_hold_status,
            }
        }
    }
}
impl GetObjectOutput {
    /// Creates a new builder-style object to manufacture [`GetObjectOutput`](crate::output::GetObjectOutput)
    pub fn builder() -> crate::output::get_object_output::Builder {
        crate::output::get_object_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBucketWebsiteOutput {
    /// <p>Specifies the redirect behavior of all requests to a website endpoint of an Amazon S3
    /// bucket.</p>
    pub redirect_all_requests_to: std::option::Option<crate::model::RedirectAllRequestsTo>,
    /// <p>The name of the index document for the website (for example
    /// <code>index.html</code>).</p>
    pub index_document: std::option::Option<crate::model::IndexDocument>,
    /// <p>The object key name of the website error document to use for 4XX class errors.</p>
    pub error_document: std::option::Option<crate::model::ErrorDocument>,
    /// <p>Rules that define when a redirect is applied and the redirect behavior.</p>
    pub routing_rules: std::option::Option<std::vec::Vec<crate::model::RoutingRule>>,
}
impl GetBucketWebsiteOutput {
    /// <p>Specifies the redirect behavior of all requests to a website endpoint of an Amazon S3
    /// bucket.</p>
    pub fn redirect_all_requests_to(
        &self,
    ) -> std::option::Option<&crate::model::RedirectAllRequestsTo> {
        self.redirect_all_requests_to.as_ref()
    }
    /// <p>The name of the index document for the website (for example
    /// <code>index.html</code>).</p>
    pub fn index_document(&self) -> std::option::Option<&crate::model::IndexDocument> {
        self.index_document.as_ref()
    }
    /// <p>The object key name of the website error document to use for 4XX class errors.</p>
    pub fn error_document(&self) -> std::option::Option<&crate::model::ErrorDocument> {
        self.error_document.as_ref()
    }
    /// <p>Rules that define when a redirect is applied and the redirect behavior.</p>
    pub fn routing_rules(&self) -> std::option::Option<&[crate::model::RoutingRule]> {
        self.routing_rules.as_deref()
    }
}
impl std::fmt::Debug for GetBucketWebsiteOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBucketWebsiteOutput");
        formatter.field("redirect_all_requests_to", &self.redirect_all_requests_to);
        formatter.field("index_document", &self.index_document);
        formatter.field("error_document", &self.error_document);
        formatter.field("routing_rules", &self.routing_rules);
        formatter.finish()
    }
}
/// See [`GetBucketWebsiteOutput`](crate::output::GetBucketWebsiteOutput)
pub mod get_bucket_website_output {
    /// A builder for [`GetBucketWebsiteOutput`](crate::output::GetBucketWebsiteOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) redirect_all_requests_to:
            std::option::Option<crate::model::RedirectAllRequestsTo>,
        pub(crate) index_document: std::option::Option<crate::model::IndexDocument>,
        pub(crate) error_document: std::option::Option<crate::model::ErrorDocument>,
        pub(crate) routing_rules: std::option::Option<std::vec::Vec<crate::model::RoutingRule>>,
    }
    impl Builder {
        /// <p>Specifies the redirect behavior of all requests to a website endpoint of an Amazon S3
        /// bucket.</p>
        pub fn redirect_all_requests_to(
            mut self,
            input: crate::model::RedirectAllRequestsTo,
        ) -> Self {
            self.redirect_all_requests_to = Some(input);
            self
        }
        /// <p>Specifies the redirect behavior of all requests to a website endpoint of an Amazon S3
        /// bucket.</p>
        pub fn set_redirect_all_requests_to(
            mut self,
            input: std::option::Option<crate::model::RedirectAllRequestsTo>,
        ) -> Self {
            self.redirect_all_requests_to = input;
            self
        }
        /// <p>The name of the index document for the website (for example
        /// <code>index.html</code>).</p>
        pub fn index_document(mut self, input: crate::model::IndexDocument) -> Self {
            self.index_document = Some(input);
            self
        }
        /// <p>The name of the index document for the website (for example
        /// <code>index.html</code>).</p>
        pub fn set_index_document(
            mut self,
            input: std::option::Option<crate::model::IndexDocument>,
        ) -> Self {
            self.index_document = input;
            self
        }
        /// <p>The object key name of the website error document to use for 4XX class errors.</p>
        pub fn error_document(mut self, input: crate::model::ErrorDocument) -> Self {
            self.error_document = Some(input);
            self
        }
        /// <p>The object key name of the website error document to use for 4XX class errors.</p>
        pub fn set_error_document(
            mut self,
            input: std::option::Option<crate::model::ErrorDocument>,
        ) -> Self {
            self.error_document = input;
            self
        }
        /// Appends an item to `routing_rules`.
        ///
        /// To override the contents of this collection use [`set_routing_rules`](Self::set_routing_rules).
        ///
        /// <p>Rules that define when a redirect is applied and the redirect behavior.</p>
        pub fn routing_rules(mut self, input: impl Into<crate::model::RoutingRule>) -> Self {
            let mut v = self.routing_rules.unwrap_or_default();
            v.push(input.into());
            self.routing_rules = Some(v);
            self
        }
        /// <p>Rules that define when a redirect is applied and the redirect behavior.</p>
        pub fn set_routing_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RoutingRule>>,
        ) -> Self {
            self.routing_rules = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketWebsiteOutput`](crate::output::GetBucketWebsiteOutput)
        pub fn build(self) -> crate::output::GetBucketWebsiteOutput {
            crate::output::GetBucketWebsiteOutput {
                redirect_all_requests_to: self.redirect_all_requests_to,
                index_document: self.index_document,
                error_document: self.error_document,
                routing_rules: self.routing_rules,
            }
        }
    }
}
impl GetBucketWebsiteOutput {
    /// Creates a new builder-style object to manufacture [`GetBucketWebsiteOutput`](crate::output::GetBucketWebsiteOutput)
    pub fn builder() -> crate::output::get_bucket_website_output::Builder {
        crate::output::get_bucket_website_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBucketVersioningOutput {
    /// <p>The versioning state of the bucket.</p>
    pub status: std::option::Option<crate::model::BucketVersioningStatus>,
    /// <p>Specifies whether MFA delete is enabled in the bucket versioning configuration. This
    /// element is only returned if the bucket has been configured with MFA delete. If the bucket
    /// has never been so configured, this element is not returned.</p>
    pub mfa_delete: std::option::Option<crate::model::MfaDeleteStatus>,
}
impl GetBucketVersioningOutput {
    /// <p>The versioning state of the bucket.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::BucketVersioningStatus> {
        self.status.as_ref()
    }
    /// <p>Specifies whether MFA delete is enabled in the bucket versioning configuration. This
    /// element is only returned if the bucket has been configured with MFA delete. If the bucket
    /// has never been so configured, this element is not returned.</p>
    pub fn mfa_delete(&self) -> std::option::Option<&crate::model::MfaDeleteStatus> {
        self.mfa_delete.as_ref()
    }
}
impl std::fmt::Debug for GetBucketVersioningOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBucketVersioningOutput");
        formatter.field("status", &self.status);
        formatter.field("mfa_delete", &self.mfa_delete);
        formatter.finish()
    }
}
/// See [`GetBucketVersioningOutput`](crate::output::GetBucketVersioningOutput)
pub mod get_bucket_versioning_output {
    /// A builder for [`GetBucketVersioningOutput`](crate::output::GetBucketVersioningOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::BucketVersioningStatus>,
        pub(crate) mfa_delete: std::option::Option<crate::model::MfaDeleteStatus>,
    }
    impl Builder {
        /// <p>The versioning state of the bucket.</p>
        pub fn status(mut self, input: crate::model::BucketVersioningStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The versioning state of the bucket.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::BucketVersioningStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Specifies whether MFA delete is enabled in the bucket versioning configuration. This
        /// element is only returned if the bucket has been configured with MFA delete. If the bucket
        /// has never been so configured, this element is not returned.</p>
        pub fn mfa_delete(mut self, input: crate::model::MfaDeleteStatus) -> Self {
            self.mfa_delete = Some(input);
            self
        }
        /// <p>Specifies whether MFA delete is enabled in the bucket versioning configuration. This
        /// element is only returned if the bucket has been configured with MFA delete. If the bucket
        /// has never been so configured, this element is not returned.</p>
        pub fn set_mfa_delete(
            mut self,
            input: std::option::Option<crate::model::MfaDeleteStatus>,
        ) -> Self {
            self.mfa_delete = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketVersioningOutput`](crate::output::GetBucketVersioningOutput)
        pub fn build(self) -> crate::output::GetBucketVersioningOutput {
            crate::output::GetBucketVersioningOutput {
                status: self.status,
                mfa_delete: self.mfa_delete,
            }
        }
    }
}
impl GetBucketVersioningOutput {
    /// Creates a new builder-style object to manufacture [`GetBucketVersioningOutput`](crate::output::GetBucketVersioningOutput)
    pub fn builder() -> crate::output::get_bucket_versioning_output::Builder {
        crate::output::get_bucket_versioning_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBucketTaggingOutput {
    /// <p>Contains the tag set.</p>
    pub tag_set: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl GetBucketTaggingOutput {
    /// <p>Contains the tag set.</p>
    pub fn tag_set(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tag_set.as_deref()
    }
}
impl std::fmt::Debug for GetBucketTaggingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBucketTaggingOutput");
        formatter.field("tag_set", &self.tag_set);
        formatter.finish()
    }
}
/// See [`GetBucketTaggingOutput`](crate::output::GetBucketTaggingOutput)
pub mod get_bucket_tagging_output {
    /// A builder for [`GetBucketTaggingOutput`](crate::output::GetBucketTaggingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tag_set: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `tag_set`.
        ///
        /// To override the contents of this collection use [`set_tag_set`](Self::set_tag_set).
        ///
        /// <p>Contains the tag set.</p>
        pub fn tag_set(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tag_set.unwrap_or_default();
            v.push(input.into());
            self.tag_set = Some(v);
            self
        }
        /// <p>Contains the tag set.</p>
        pub fn set_tag_set(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tag_set = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketTaggingOutput`](crate::output::GetBucketTaggingOutput)
        pub fn build(self) -> crate::output::GetBucketTaggingOutput {
            crate::output::GetBucketTaggingOutput {
                tag_set: self.tag_set,
            }
        }
    }
}
impl GetBucketTaggingOutput {
    /// Creates a new builder-style object to manufacture [`GetBucketTaggingOutput`](crate::output::GetBucketTaggingOutput)
    pub fn builder() -> crate::output::get_bucket_tagging_output::Builder {
        crate::output::get_bucket_tagging_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBucketRequestPaymentOutput {
    /// <p>Specifies who pays for the download and request fees.</p>
    pub payer: std::option::Option<crate::model::Payer>,
}
impl GetBucketRequestPaymentOutput {
    /// <p>Specifies who pays for the download and request fees.</p>
    pub fn payer(&self) -> std::option::Option<&crate::model::Payer> {
        self.payer.as_ref()
    }
}
impl std::fmt::Debug for GetBucketRequestPaymentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBucketRequestPaymentOutput");
        formatter.field("payer", &self.payer);
        formatter.finish()
    }
}
/// See [`GetBucketRequestPaymentOutput`](crate::output::GetBucketRequestPaymentOutput)
pub mod get_bucket_request_payment_output {
    /// A builder for [`GetBucketRequestPaymentOutput`](crate::output::GetBucketRequestPaymentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) payer: std::option::Option<crate::model::Payer>,
    }
    impl Builder {
        /// <p>Specifies who pays for the download and request fees.</p>
        pub fn payer(mut self, input: crate::model::Payer) -> Self {
            self.payer = Some(input);
            self
        }
        /// <p>Specifies who pays for the download and request fees.</p>
        pub fn set_payer(mut self, input: std::option::Option<crate::model::Payer>) -> Self {
            self.payer = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketRequestPaymentOutput`](crate::output::GetBucketRequestPaymentOutput)
        pub fn build(self) -> crate::output::GetBucketRequestPaymentOutput {
            crate::output::GetBucketRequestPaymentOutput { payer: self.payer }
        }
    }
}
impl GetBucketRequestPaymentOutput {
    /// Creates a new builder-style object to manufacture [`GetBucketRequestPaymentOutput`](crate::output::GetBucketRequestPaymentOutput)
    pub fn builder() -> crate::output::get_bucket_request_payment_output::Builder {
        crate::output::get_bucket_request_payment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBucketReplicationOutput {
    /// <p>A container for replication rules. You can add up to 1,000 rules. The maximum size of a
    /// replication configuration is 2 MB.</p>
    pub replication_configuration: std::option::Option<crate::model::ReplicationConfiguration>,
}
impl GetBucketReplicationOutput {
    /// <p>A container for replication rules. You can add up to 1,000 rules. The maximum size of a
    /// replication configuration is 2 MB.</p>
    pub fn replication_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfiguration> {
        self.replication_configuration.as_ref()
    }
}
impl std::fmt::Debug for GetBucketReplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBucketReplicationOutput");
        formatter.field("replication_configuration", &self.replication_configuration);
        formatter.finish()
    }
}
/// See [`GetBucketReplicationOutput`](crate::output::GetBucketReplicationOutput)
pub mod get_bucket_replication_output {
    /// A builder for [`GetBucketReplicationOutput`](crate::output::GetBucketReplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_configuration:
            std::option::Option<crate::model::ReplicationConfiguration>,
    }
    impl Builder {
        /// <p>A container for replication rules. You can add up to 1,000 rules. The maximum size of a
        /// replication configuration is 2 MB.</p>
        pub fn replication_configuration(
            mut self,
            input: crate::model::ReplicationConfiguration,
        ) -> Self {
            self.replication_configuration = Some(input);
            self
        }
        /// <p>A container for replication rules. You can add up to 1,000 rules. The maximum size of a
        /// replication configuration is 2 MB.</p>
        pub fn set_replication_configuration(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfiguration>,
        ) -> Self {
            self.replication_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketReplicationOutput`](crate::output::GetBucketReplicationOutput)
        pub fn build(self) -> crate::output::GetBucketReplicationOutput {
            crate::output::GetBucketReplicationOutput {
                replication_configuration: self.replication_configuration,
            }
        }
    }
}
impl GetBucketReplicationOutput {
    /// Creates a new builder-style object to manufacture [`GetBucketReplicationOutput`](crate::output::GetBucketReplicationOutput)
    pub fn builder() -> crate::output::get_bucket_replication_output::Builder {
        crate::output::get_bucket_replication_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBucketPolicyStatusOutput {
    /// <p>The policy status for the specified bucket.</p>
    pub policy_status: std::option::Option<crate::model::PolicyStatus>,
}
impl GetBucketPolicyStatusOutput {
    /// <p>The policy status for the specified bucket.</p>
    pub fn policy_status(&self) -> std::option::Option<&crate::model::PolicyStatus> {
        self.policy_status.as_ref()
    }
}
impl std::fmt::Debug for GetBucketPolicyStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBucketPolicyStatusOutput");
        formatter.field("policy_status", &self.policy_status);
        formatter.finish()
    }
}
/// See [`GetBucketPolicyStatusOutput`](crate::output::GetBucketPolicyStatusOutput)
pub mod get_bucket_policy_status_output {
    /// A builder for [`GetBucketPolicyStatusOutput`](crate::output::GetBucketPolicyStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_status: std::option::Option<crate::model::PolicyStatus>,
    }
    impl Builder {
        /// <p>The policy status for the specified bucket.</p>
        pub fn policy_status(mut self, input: crate::model::PolicyStatus) -> Self {
            self.policy_status = Some(input);
            self
        }
        /// <p>The policy status for the specified bucket.</p>
        pub fn set_policy_status(
            mut self,
            input: std::option::Option<crate::model::PolicyStatus>,
        ) -> Self {
            self.policy_status = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketPolicyStatusOutput`](crate::output::GetBucketPolicyStatusOutput)
        pub fn build(self) -> crate::output::GetBucketPolicyStatusOutput {
            crate::output::GetBucketPolicyStatusOutput {
                policy_status: self.policy_status,
            }
        }
    }
}
impl GetBucketPolicyStatusOutput {
    /// Creates a new builder-style object to manufacture [`GetBucketPolicyStatusOutput`](crate::output::GetBucketPolicyStatusOutput)
    pub fn builder() -> crate::output::get_bucket_policy_status_output::Builder {
        crate::output::get_bucket_policy_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBucketPolicyOutput {
    /// <p>The bucket policy as a JSON document.</p>
    pub policy: std::option::Option<std::string::String>,
}
impl GetBucketPolicyOutput {
    /// <p>The bucket policy as a JSON document.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
}
impl std::fmt::Debug for GetBucketPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBucketPolicyOutput");
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`GetBucketPolicyOutput`](crate::output::GetBucketPolicyOutput)
pub mod get_bucket_policy_output {
    /// A builder for [`GetBucketPolicyOutput`](crate::output::GetBucketPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket policy as a JSON document.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The bucket policy as a JSON document.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketPolicyOutput`](crate::output::GetBucketPolicyOutput)
        pub fn build(self) -> crate::output::GetBucketPolicyOutput {
            crate::output::GetBucketPolicyOutput {
                policy: self.policy,
            }
        }
    }
}
impl GetBucketPolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetBucketPolicyOutput`](crate::output::GetBucketPolicyOutput)
    pub fn builder() -> crate::output::get_bucket_policy_output::Builder {
        crate::output::get_bucket_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBucketOwnershipControlsOutput {
    /// <p>The <code>OwnershipControls</code> (BucketOwnerPreferred or ObjectWriter) currently in
    /// effect for this Amazon S3 bucket.</p>
    pub ownership_controls: std::option::Option<crate::model::OwnershipControls>,
}
impl GetBucketOwnershipControlsOutput {
    /// <p>The <code>OwnershipControls</code> (BucketOwnerPreferred or ObjectWriter) currently in
    /// effect for this Amazon S3 bucket.</p>
    pub fn ownership_controls(&self) -> std::option::Option<&crate::model::OwnershipControls> {
        self.ownership_controls.as_ref()
    }
}
impl std::fmt::Debug for GetBucketOwnershipControlsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBucketOwnershipControlsOutput");
        formatter.field("ownership_controls", &self.ownership_controls);
        formatter.finish()
    }
}
/// See [`GetBucketOwnershipControlsOutput`](crate::output::GetBucketOwnershipControlsOutput)
pub mod get_bucket_ownership_controls_output {
    /// A builder for [`GetBucketOwnershipControlsOutput`](crate::output::GetBucketOwnershipControlsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ownership_controls: std::option::Option<crate::model::OwnershipControls>,
    }
    impl Builder {
        /// <p>The <code>OwnershipControls</code> (BucketOwnerPreferred or ObjectWriter) currently in
        /// effect for this Amazon S3 bucket.</p>
        pub fn ownership_controls(mut self, input: crate::model::OwnershipControls) -> Self {
            self.ownership_controls = Some(input);
            self
        }
        /// <p>The <code>OwnershipControls</code> (BucketOwnerPreferred or ObjectWriter) currently in
        /// effect for this Amazon S3 bucket.</p>
        pub fn set_ownership_controls(
            mut self,
            input: std::option::Option<crate::model::OwnershipControls>,
        ) -> Self {
            self.ownership_controls = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketOwnershipControlsOutput`](crate::output::GetBucketOwnershipControlsOutput)
        pub fn build(self) -> crate::output::GetBucketOwnershipControlsOutput {
            crate::output::GetBucketOwnershipControlsOutput {
                ownership_controls: self.ownership_controls,
            }
        }
    }
}
impl GetBucketOwnershipControlsOutput {
    /// Creates a new builder-style object to manufacture [`GetBucketOwnershipControlsOutput`](crate::output::GetBucketOwnershipControlsOutput)
    pub fn builder() -> crate::output::get_bucket_ownership_controls_output::Builder {
        crate::output::get_bucket_ownership_controls_output::Builder::default()
    }
}

/// <p>A container for specifying the notification configuration of the bucket. If this element
/// is empty, notifications are turned off for the bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBucketNotificationConfigurationOutput {
    /// <p>The topic to which notifications are sent and the events for which notifications are
    /// generated.</p>
    pub topic_configurations: std::option::Option<std::vec::Vec<crate::model::TopicConfiguration>>,
    /// <p>The Amazon Simple Queue Service queues to publish messages to and the events for which
    /// to publish messages.</p>
    pub queue_configurations: std::option::Option<std::vec::Vec<crate::model::QueueConfiguration>>,
    /// <p>Describes the Lambda functions to invoke and the events for which to invoke
    /// them.</p>
    pub lambda_function_configurations:
        std::option::Option<std::vec::Vec<crate::model::LambdaFunctionConfiguration>>,
}
impl GetBucketNotificationConfigurationOutput {
    /// <p>The topic to which notifications are sent and the events for which notifications are
    /// generated.</p>
    pub fn topic_configurations(&self) -> std::option::Option<&[crate::model::TopicConfiguration]> {
        self.topic_configurations.as_deref()
    }
    /// <p>The Amazon Simple Queue Service queues to publish messages to and the events for which
    /// to publish messages.</p>
    pub fn queue_configurations(&self) -> std::option::Option<&[crate::model::QueueConfiguration]> {
        self.queue_configurations.as_deref()
    }
    /// <p>Describes the Lambda functions to invoke and the events for which to invoke
    /// them.</p>
    pub fn lambda_function_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::LambdaFunctionConfiguration]> {
        self.lambda_function_configurations.as_deref()
    }
}
impl std::fmt::Debug for GetBucketNotificationConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBucketNotificationConfigurationOutput");
        formatter.field("topic_configurations", &self.topic_configurations);
        formatter.field("queue_configurations", &self.queue_configurations);
        formatter.field(
            "lambda_function_configurations",
            &self.lambda_function_configurations,
        );
        formatter.finish()
    }
}
/// See [`GetBucketNotificationConfigurationOutput`](crate::output::GetBucketNotificationConfigurationOutput)
pub mod get_bucket_notification_configuration_output {
    /// A builder for [`GetBucketNotificationConfigurationOutput`](crate::output::GetBucketNotificationConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) topic_configurations:
            std::option::Option<std::vec::Vec<crate::model::TopicConfiguration>>,
        pub(crate) queue_configurations:
            std::option::Option<std::vec::Vec<crate::model::QueueConfiguration>>,
        pub(crate) lambda_function_configurations:
            std::option::Option<std::vec::Vec<crate::model::LambdaFunctionConfiguration>>,
    }
    impl Builder {
        /// Appends an item to `topic_configurations`.
        ///
        /// To override the contents of this collection use [`set_topic_configurations`](Self::set_topic_configurations).
        ///
        /// <p>The topic to which notifications are sent and the events for which notifications are
        /// generated.</p>
        pub fn topic_configurations(
            mut self,
            input: impl Into<crate::model::TopicConfiguration>,
        ) -> Self {
            let mut v = self.topic_configurations.unwrap_or_default();
            v.push(input.into());
            self.topic_configurations = Some(v);
            self
        }
        /// <p>The topic to which notifications are sent and the events for which notifications are
        /// generated.</p>
        pub fn set_topic_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TopicConfiguration>>,
        ) -> Self {
            self.topic_configurations = input;
            self
        }
        /// Appends an item to `queue_configurations`.
        ///
        /// To override the contents of this collection use [`set_queue_configurations`](Self::set_queue_configurations).
        ///
        /// <p>The Amazon Simple Queue Service queues to publish messages to and the events for which
        /// to publish messages.</p>
        pub fn queue_configurations(
            mut self,
            input: impl Into<crate::model::QueueConfiguration>,
        ) -> Self {
            let mut v = self.queue_configurations.unwrap_or_default();
            v.push(input.into());
            self.queue_configurations = Some(v);
            self
        }
        /// <p>The Amazon Simple Queue Service queues to publish messages to and the events for which
        /// to publish messages.</p>
        pub fn set_queue_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::QueueConfiguration>>,
        ) -> Self {
            self.queue_configurations = input;
            self
        }
        /// Appends an item to `lambda_function_configurations`.
        ///
        /// To override the contents of this collection use [`set_lambda_function_configurations`](Self::set_lambda_function_configurations).
        ///
        /// <p>Describes the Lambda functions to invoke and the events for which to invoke
        /// them.</p>
        pub fn lambda_function_configurations(
            mut self,
            input: impl Into<crate::model::LambdaFunctionConfiguration>,
        ) -> Self {
            let mut v = self.lambda_function_configurations.unwrap_or_default();
            v.push(input.into());
            self.lambda_function_configurations = Some(v);
            self
        }
        /// <p>Describes the Lambda functions to invoke and the events for which to invoke
        /// them.</p>
        pub fn set_lambda_function_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LambdaFunctionConfiguration>>,
        ) -> Self {
            self.lambda_function_configurations = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketNotificationConfigurationOutput`](crate::output::GetBucketNotificationConfigurationOutput)
        pub fn build(self) -> crate::output::GetBucketNotificationConfigurationOutput {
            crate::output::GetBucketNotificationConfigurationOutput {
                topic_configurations: self.topic_configurations,
                queue_configurations: self.queue_configurations,
                lambda_function_configurations: self.lambda_function_configurations,
            }
        }
    }
}
impl GetBucketNotificationConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`GetBucketNotificationConfigurationOutput`](crate::output::GetBucketNotificationConfigurationOutput)
    pub fn builder() -> crate::output::get_bucket_notification_configuration_output::Builder {
        crate::output::get_bucket_notification_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBucketMetricsConfigurationOutput {
    /// <p>Specifies the metrics configuration.</p>
    pub metrics_configuration: std::option::Option<crate::model::MetricsConfiguration>,
}
impl GetBucketMetricsConfigurationOutput {
    /// <p>Specifies the metrics configuration.</p>
    pub fn metrics_configuration(
        &self,
    ) -> std::option::Option<&crate::model::MetricsConfiguration> {
        self.metrics_configuration.as_ref()
    }
}
impl std::fmt::Debug for GetBucketMetricsConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBucketMetricsConfigurationOutput");
        formatter.field("metrics_configuration", &self.metrics_configuration);
        formatter.finish()
    }
}
/// See [`GetBucketMetricsConfigurationOutput`](crate::output::GetBucketMetricsConfigurationOutput)
pub mod get_bucket_metrics_configuration_output {
    /// A builder for [`GetBucketMetricsConfigurationOutput`](crate::output::GetBucketMetricsConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metrics_configuration: std::option::Option<crate::model::MetricsConfiguration>,
    }
    impl Builder {
        /// <p>Specifies the metrics configuration.</p>
        pub fn metrics_configuration(mut self, input: crate::model::MetricsConfiguration) -> Self {
            self.metrics_configuration = Some(input);
            self
        }
        /// <p>Specifies the metrics configuration.</p>
        pub fn set_metrics_configuration(
            mut self,
            input: std::option::Option<crate::model::MetricsConfiguration>,
        ) -> Self {
            self.metrics_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketMetricsConfigurationOutput`](crate::output::GetBucketMetricsConfigurationOutput)
        pub fn build(self) -> crate::output::GetBucketMetricsConfigurationOutput {
            crate::output::GetBucketMetricsConfigurationOutput {
                metrics_configuration: self.metrics_configuration,
            }
        }
    }
}
impl GetBucketMetricsConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`GetBucketMetricsConfigurationOutput`](crate::output::GetBucketMetricsConfigurationOutput)
    pub fn builder() -> crate::output::get_bucket_metrics_configuration_output::Builder {
        crate::output::get_bucket_metrics_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBucketLoggingOutput {
    /// <p>Describes where logs are stored and the prefix that Amazon S3 assigns to all log object keys
    /// for a bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTlogging.html">PUT Bucket logging</a> in the
    /// <i>Amazon S3 API Reference</i>.</p>
    pub logging_enabled: std::option::Option<crate::model::LoggingEnabled>,
}
impl GetBucketLoggingOutput {
    /// <p>Describes where logs are stored and the prefix that Amazon S3 assigns to all log object keys
    /// for a bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTlogging.html">PUT Bucket logging</a> in the
    /// <i>Amazon S3 API Reference</i>.</p>
    pub fn logging_enabled(&self) -> std::option::Option<&crate::model::LoggingEnabled> {
        self.logging_enabled.as_ref()
    }
}
impl std::fmt::Debug for GetBucketLoggingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBucketLoggingOutput");
        formatter.field("logging_enabled", &self.logging_enabled);
        formatter.finish()
    }
}
/// See [`GetBucketLoggingOutput`](crate::output::GetBucketLoggingOutput)
pub mod get_bucket_logging_output {
    /// A builder for [`GetBucketLoggingOutput`](crate::output::GetBucketLoggingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) logging_enabled: std::option::Option<crate::model::LoggingEnabled>,
    }
    impl Builder {
        /// <p>Describes where logs are stored and the prefix that Amazon S3 assigns to all log object keys
        /// for a bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTlogging.html">PUT Bucket logging</a> in the
        /// <i>Amazon S3 API Reference</i>.</p>
        pub fn logging_enabled(mut self, input: crate::model::LoggingEnabled) -> Self {
            self.logging_enabled = Some(input);
            self
        }
        /// <p>Describes where logs are stored and the prefix that Amazon S3 assigns to all log object keys
        /// for a bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTlogging.html">PUT Bucket logging</a> in the
        /// <i>Amazon S3 API Reference</i>.</p>
        pub fn set_logging_enabled(
            mut self,
            input: std::option::Option<crate::model::LoggingEnabled>,
        ) -> Self {
            self.logging_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketLoggingOutput`](crate::output::GetBucketLoggingOutput)
        pub fn build(self) -> crate::output::GetBucketLoggingOutput {
            crate::output::GetBucketLoggingOutput {
                logging_enabled: self.logging_enabled,
            }
        }
    }
}
impl GetBucketLoggingOutput {
    /// Creates a new builder-style object to manufacture [`GetBucketLoggingOutput`](crate::output::GetBucketLoggingOutput)
    pub fn builder() -> crate::output::get_bucket_logging_output::Builder {
        crate::output::get_bucket_logging_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBucketLocationOutput {
    /// <p>Specifies the Region where the bucket resides. For a list of all the Amazon S3 supported
    /// location constraints by Region, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a>.
    /// Buckets in Region <code>us-east-1</code> have a LocationConstraint of
    /// <code>null</code>.</p>
    pub location_constraint: std::option::Option<crate::model::BucketLocationConstraint>,
}
impl GetBucketLocationOutput {
    /// <p>Specifies the Region where the bucket resides. For a list of all the Amazon S3 supported
    /// location constraints by Region, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a>.
    /// Buckets in Region <code>us-east-1</code> have a LocationConstraint of
    /// <code>null</code>.</p>
    pub fn location_constraint(
        &self,
    ) -> std::option::Option<&crate::model::BucketLocationConstraint> {
        self.location_constraint.as_ref()
    }
}
impl std::fmt::Debug for GetBucketLocationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBucketLocationOutput");
        formatter.field("location_constraint", &self.location_constraint);
        formatter.finish()
    }
}
/// See [`GetBucketLocationOutput`](crate::output::GetBucketLocationOutput)
pub mod get_bucket_location_output {
    /// A builder for [`GetBucketLocationOutput`](crate::output::GetBucketLocationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location_constraint: std::option::Option<crate::model::BucketLocationConstraint>,
    }
    impl Builder {
        /// <p>Specifies the Region where the bucket resides. For a list of all the Amazon S3 supported
        /// location constraints by Region, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a>.
        /// Buckets in Region <code>us-east-1</code> have a LocationConstraint of
        /// <code>null</code>.</p>
        pub fn location_constraint(
            mut self,
            input: crate::model::BucketLocationConstraint,
        ) -> Self {
            self.location_constraint = Some(input);
            self
        }
        /// <p>Specifies the Region where the bucket resides. For a list of all the Amazon S3 supported
        /// location constraints by Region, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a>.
        /// Buckets in Region <code>us-east-1</code> have a LocationConstraint of
        /// <code>null</code>.</p>
        pub fn set_location_constraint(
            mut self,
            input: std::option::Option<crate::model::BucketLocationConstraint>,
        ) -> Self {
            self.location_constraint = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketLocationOutput`](crate::output::GetBucketLocationOutput)
        pub fn build(self) -> crate::output::GetBucketLocationOutput {
            crate::output::GetBucketLocationOutput {
                location_constraint: self.location_constraint,
            }
        }
    }
}
impl GetBucketLocationOutput {
    /// Creates a new builder-style object to manufacture [`GetBucketLocationOutput`](crate::output::GetBucketLocationOutput)
    pub fn builder() -> crate::output::get_bucket_location_output::Builder {
        crate::output::get_bucket_location_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBucketLifecycleConfigurationOutput {
    /// <p>Container for a lifecycle rule.</p>
    pub rules: std::option::Option<std::vec::Vec<crate::model::LifecycleRule>>,
}
impl GetBucketLifecycleConfigurationOutput {
    /// <p>Container for a lifecycle rule.</p>
    pub fn rules(&self) -> std::option::Option<&[crate::model::LifecycleRule]> {
        self.rules.as_deref()
    }
}
impl std::fmt::Debug for GetBucketLifecycleConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBucketLifecycleConfigurationOutput");
        formatter.field("rules", &self.rules);
        formatter.finish()
    }
}
/// See [`GetBucketLifecycleConfigurationOutput`](crate::output::GetBucketLifecycleConfigurationOutput)
pub mod get_bucket_lifecycle_configuration_output {
    /// A builder for [`GetBucketLifecycleConfigurationOutput`](crate::output::GetBucketLifecycleConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rules: std::option::Option<std::vec::Vec<crate::model::LifecycleRule>>,
    }
    impl Builder {
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>Container for a lifecycle rule.</p>
        pub fn rules(mut self, input: impl Into<crate::model::LifecycleRule>) -> Self {
            let mut v = self.rules.unwrap_or_default();
            v.push(input.into());
            self.rules = Some(v);
            self
        }
        /// <p>Container for a lifecycle rule.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LifecycleRule>>,
        ) -> Self {
            self.rules = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketLifecycleConfigurationOutput`](crate::output::GetBucketLifecycleConfigurationOutput)
        pub fn build(self) -> crate::output::GetBucketLifecycleConfigurationOutput {
            crate::output::GetBucketLifecycleConfigurationOutput { rules: self.rules }
        }
    }
}
impl GetBucketLifecycleConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`GetBucketLifecycleConfigurationOutput`](crate::output::GetBucketLifecycleConfigurationOutput)
    pub fn builder() -> crate::output::get_bucket_lifecycle_configuration_output::Builder {
        crate::output::get_bucket_lifecycle_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBucketInventoryConfigurationOutput {
    /// <p>Specifies the inventory configuration.</p>
    pub inventory_configuration: std::option::Option<crate::model::InventoryConfiguration>,
}
impl GetBucketInventoryConfigurationOutput {
    /// <p>Specifies the inventory configuration.</p>
    pub fn inventory_configuration(
        &self,
    ) -> std::option::Option<&crate::model::InventoryConfiguration> {
        self.inventory_configuration.as_ref()
    }
}
impl std::fmt::Debug for GetBucketInventoryConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBucketInventoryConfigurationOutput");
        formatter.field("inventory_configuration", &self.inventory_configuration);
        formatter.finish()
    }
}
/// See [`GetBucketInventoryConfigurationOutput`](crate::output::GetBucketInventoryConfigurationOutput)
pub mod get_bucket_inventory_configuration_output {
    /// A builder for [`GetBucketInventoryConfigurationOutput`](crate::output::GetBucketInventoryConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) inventory_configuration:
            std::option::Option<crate::model::InventoryConfiguration>,
    }
    impl Builder {
        /// <p>Specifies the inventory configuration.</p>
        pub fn inventory_configuration(
            mut self,
            input: crate::model::InventoryConfiguration,
        ) -> Self {
            self.inventory_configuration = Some(input);
            self
        }
        /// <p>Specifies the inventory configuration.</p>
        pub fn set_inventory_configuration(
            mut self,
            input: std::option::Option<crate::model::InventoryConfiguration>,
        ) -> Self {
            self.inventory_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketInventoryConfigurationOutput`](crate::output::GetBucketInventoryConfigurationOutput)
        pub fn build(self) -> crate::output::GetBucketInventoryConfigurationOutput {
            crate::output::GetBucketInventoryConfigurationOutput {
                inventory_configuration: self.inventory_configuration,
            }
        }
    }
}
impl GetBucketInventoryConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`GetBucketInventoryConfigurationOutput`](crate::output::GetBucketInventoryConfigurationOutput)
    pub fn builder() -> crate::output::get_bucket_inventory_configuration_output::Builder {
        crate::output::get_bucket_inventory_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBucketIntelligentTieringConfigurationOutput {
    /// <p>Container for S3 Intelligent-Tiering configuration.</p>
    pub intelligent_tiering_configuration:
        std::option::Option<crate::model::IntelligentTieringConfiguration>,
}
impl GetBucketIntelligentTieringConfigurationOutput {
    /// <p>Container for S3 Intelligent-Tiering configuration.</p>
    pub fn intelligent_tiering_configuration(
        &self,
    ) -> std::option::Option<&crate::model::IntelligentTieringConfiguration> {
        self.intelligent_tiering_configuration.as_ref()
    }
}
impl std::fmt::Debug for GetBucketIntelligentTieringConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBucketIntelligentTieringConfigurationOutput");
        formatter.field(
            "intelligent_tiering_configuration",
            &self.intelligent_tiering_configuration,
        );
        formatter.finish()
    }
}
/// See [`GetBucketIntelligentTieringConfigurationOutput`](crate::output::GetBucketIntelligentTieringConfigurationOutput)
pub mod get_bucket_intelligent_tiering_configuration_output {
    /// A builder for [`GetBucketIntelligentTieringConfigurationOutput`](crate::output::GetBucketIntelligentTieringConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) intelligent_tiering_configuration:
            std::option::Option<crate::model::IntelligentTieringConfiguration>,
    }
    impl Builder {
        /// <p>Container for S3 Intelligent-Tiering configuration.</p>
        pub fn intelligent_tiering_configuration(
            mut self,
            input: crate::model::IntelligentTieringConfiguration,
        ) -> Self {
            self.intelligent_tiering_configuration = Some(input);
            self
        }
        /// <p>Container for S3 Intelligent-Tiering configuration.</p>
        pub fn set_intelligent_tiering_configuration(
            mut self,
            input: std::option::Option<crate::model::IntelligentTieringConfiguration>,
        ) -> Self {
            self.intelligent_tiering_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketIntelligentTieringConfigurationOutput`](crate::output::GetBucketIntelligentTieringConfigurationOutput)
        pub fn build(self) -> crate::output::GetBucketIntelligentTieringConfigurationOutput {
            crate::output::GetBucketIntelligentTieringConfigurationOutput {
                intelligent_tiering_configuration: self.intelligent_tiering_configuration,
            }
        }
    }
}
impl GetBucketIntelligentTieringConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`GetBucketIntelligentTieringConfigurationOutput`](crate::output::GetBucketIntelligentTieringConfigurationOutput)
    pub fn builder() -> crate::output::get_bucket_intelligent_tiering_configuration_output::Builder
    {
        crate::output::get_bucket_intelligent_tiering_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBucketEncryptionOutput {
    /// <p>Specifies the default server-side-encryption configuration.</p>
    pub server_side_encryption_configuration:
        std::option::Option<crate::model::ServerSideEncryptionConfiguration>,
}
impl GetBucketEncryptionOutput {
    /// <p>Specifies the default server-side-encryption configuration.</p>
    pub fn server_side_encryption_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ServerSideEncryptionConfiguration> {
        self.server_side_encryption_configuration.as_ref()
    }
}
impl std::fmt::Debug for GetBucketEncryptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBucketEncryptionOutput");
        formatter.field(
            "server_side_encryption_configuration",
            &self.server_side_encryption_configuration,
        );
        formatter.finish()
    }
}
/// See [`GetBucketEncryptionOutput`](crate::output::GetBucketEncryptionOutput)
pub mod get_bucket_encryption_output {
    /// A builder for [`GetBucketEncryptionOutput`](crate::output::GetBucketEncryptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_side_encryption_configuration:
            std::option::Option<crate::model::ServerSideEncryptionConfiguration>,
    }
    impl Builder {
        /// <p>Specifies the default server-side-encryption configuration.</p>
        pub fn server_side_encryption_configuration(
            mut self,
            input: crate::model::ServerSideEncryptionConfiguration,
        ) -> Self {
            self.server_side_encryption_configuration = Some(input);
            self
        }
        /// <p>Specifies the default server-side-encryption configuration.</p>
        pub fn set_server_side_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::ServerSideEncryptionConfiguration>,
        ) -> Self {
            self.server_side_encryption_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketEncryptionOutput`](crate::output::GetBucketEncryptionOutput)
        pub fn build(self) -> crate::output::GetBucketEncryptionOutput {
            crate::output::GetBucketEncryptionOutput {
                server_side_encryption_configuration: self.server_side_encryption_configuration,
            }
        }
    }
}
impl GetBucketEncryptionOutput {
    /// Creates a new builder-style object to manufacture [`GetBucketEncryptionOutput`](crate::output::GetBucketEncryptionOutput)
    pub fn builder() -> crate::output::get_bucket_encryption_output::Builder {
        crate::output::get_bucket_encryption_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBucketCorsOutput {
    /// <p>A set of origins and methods (cross-origin access that you want to allow). You can add
    /// up to 100 rules to the configuration.</p>
    pub cors_rules: std::option::Option<std::vec::Vec<crate::model::CorsRule>>,
}
impl GetBucketCorsOutput {
    /// <p>A set of origins and methods (cross-origin access that you want to allow). You can add
    /// up to 100 rules to the configuration.</p>
    pub fn cors_rules(&self) -> std::option::Option<&[crate::model::CorsRule]> {
        self.cors_rules.as_deref()
    }
}
impl std::fmt::Debug for GetBucketCorsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBucketCorsOutput");
        formatter.field("cors_rules", &self.cors_rules);
        formatter.finish()
    }
}
/// See [`GetBucketCorsOutput`](crate::output::GetBucketCorsOutput)
pub mod get_bucket_cors_output {
    /// A builder for [`GetBucketCorsOutput`](crate::output::GetBucketCorsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cors_rules: std::option::Option<std::vec::Vec<crate::model::CorsRule>>,
    }
    impl Builder {
        /// Appends an item to `cors_rules`.
        ///
        /// To override the contents of this collection use [`set_cors_rules`](Self::set_cors_rules).
        ///
        /// <p>A set of origins and methods (cross-origin access that you want to allow). You can add
        /// up to 100 rules to the configuration.</p>
        pub fn cors_rules(mut self, input: impl Into<crate::model::CorsRule>) -> Self {
            let mut v = self.cors_rules.unwrap_or_default();
            v.push(input.into());
            self.cors_rules = Some(v);
            self
        }
        /// <p>A set of origins and methods (cross-origin access that you want to allow). You can add
        /// up to 100 rules to the configuration.</p>
        pub fn set_cors_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CorsRule>>,
        ) -> Self {
            self.cors_rules = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketCorsOutput`](crate::output::GetBucketCorsOutput)
        pub fn build(self) -> crate::output::GetBucketCorsOutput {
            crate::output::GetBucketCorsOutput {
                cors_rules: self.cors_rules,
            }
        }
    }
}
impl GetBucketCorsOutput {
    /// Creates a new builder-style object to manufacture [`GetBucketCorsOutput`](crate::output::GetBucketCorsOutput)
    pub fn builder() -> crate::output::get_bucket_cors_output::Builder {
        crate::output::get_bucket_cors_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBucketAnalyticsConfigurationOutput {
    /// <p>The configuration and any analyses for the analytics filter.</p>
    pub analytics_configuration: std::option::Option<crate::model::AnalyticsConfiguration>,
}
impl GetBucketAnalyticsConfigurationOutput {
    /// <p>The configuration and any analyses for the analytics filter.</p>
    pub fn analytics_configuration(
        &self,
    ) -> std::option::Option<&crate::model::AnalyticsConfiguration> {
        self.analytics_configuration.as_ref()
    }
}
impl std::fmt::Debug for GetBucketAnalyticsConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBucketAnalyticsConfigurationOutput");
        formatter.field("analytics_configuration", &self.analytics_configuration);
        formatter.finish()
    }
}
/// See [`GetBucketAnalyticsConfigurationOutput`](crate::output::GetBucketAnalyticsConfigurationOutput)
pub mod get_bucket_analytics_configuration_output {
    /// A builder for [`GetBucketAnalyticsConfigurationOutput`](crate::output::GetBucketAnalyticsConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) analytics_configuration:
            std::option::Option<crate::model::AnalyticsConfiguration>,
    }
    impl Builder {
        /// <p>The configuration and any analyses for the analytics filter.</p>
        pub fn analytics_configuration(
            mut self,
            input: crate::model::AnalyticsConfiguration,
        ) -> Self {
            self.analytics_configuration = Some(input);
            self
        }
        /// <p>The configuration and any analyses for the analytics filter.</p>
        pub fn set_analytics_configuration(
            mut self,
            input: std::option::Option<crate::model::AnalyticsConfiguration>,
        ) -> Self {
            self.analytics_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketAnalyticsConfigurationOutput`](crate::output::GetBucketAnalyticsConfigurationOutput)
        pub fn build(self) -> crate::output::GetBucketAnalyticsConfigurationOutput {
            crate::output::GetBucketAnalyticsConfigurationOutput {
                analytics_configuration: self.analytics_configuration,
            }
        }
    }
}
impl GetBucketAnalyticsConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`GetBucketAnalyticsConfigurationOutput`](crate::output::GetBucketAnalyticsConfigurationOutput)
    pub fn builder() -> crate::output::get_bucket_analytics_configuration_output::Builder {
        crate::output::get_bucket_analytics_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBucketAclOutput {
    /// <p>Container for the bucket owner's display name and ID.</p>
    pub owner: std::option::Option<crate::model::Owner>,
    /// <p>A list of grants.</p>
    pub grants: std::option::Option<std::vec::Vec<crate::model::Grant>>,
}
impl GetBucketAclOutput {
    /// <p>Container for the bucket owner's display name and ID.</p>
    pub fn owner(&self) -> std::option::Option<&crate::model::Owner> {
        self.owner.as_ref()
    }
    /// <p>A list of grants.</p>
    pub fn grants(&self) -> std::option::Option<&[crate::model::Grant]> {
        self.grants.as_deref()
    }
}
impl std::fmt::Debug for GetBucketAclOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBucketAclOutput");
        formatter.field("owner", &self.owner);
        formatter.field("grants", &self.grants);
        formatter.finish()
    }
}
/// See [`GetBucketAclOutput`](crate::output::GetBucketAclOutput)
pub mod get_bucket_acl_output {
    /// A builder for [`GetBucketAclOutput`](crate::output::GetBucketAclOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner: std::option::Option<crate::model::Owner>,
        pub(crate) grants: std::option::Option<std::vec::Vec<crate::model::Grant>>,
    }
    impl Builder {
        /// <p>Container for the bucket owner's display name and ID.</p>
        pub fn owner(mut self, input: crate::model::Owner) -> Self {
            self.owner = Some(input);
            self
        }
        /// <p>Container for the bucket owner's display name and ID.</p>
        pub fn set_owner(mut self, input: std::option::Option<crate::model::Owner>) -> Self {
            self.owner = input;
            self
        }
        /// Appends an item to `grants`.
        ///
        /// To override the contents of this collection use [`set_grants`](Self::set_grants).
        ///
        /// <p>A list of grants.</p>
        pub fn grants(mut self, input: impl Into<crate::model::Grant>) -> Self {
            let mut v = self.grants.unwrap_or_default();
            v.push(input.into());
            self.grants = Some(v);
            self
        }
        /// <p>A list of grants.</p>
        pub fn set_grants(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Grant>>,
        ) -> Self {
            self.grants = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketAclOutput`](crate::output::GetBucketAclOutput)
        pub fn build(self) -> crate::output::GetBucketAclOutput {
            crate::output::GetBucketAclOutput {
                owner: self.owner,
                grants: self.grants,
            }
        }
    }
}
impl GetBucketAclOutput {
    /// Creates a new builder-style object to manufacture [`GetBucketAclOutput`](crate::output::GetBucketAclOutput)
    pub fn builder() -> crate::output::get_bucket_acl_output::Builder {
        crate::output::get_bucket_acl_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBucketAccelerateConfigurationOutput {
    /// <p>The accelerate configuration of the bucket.</p>
    pub status: std::option::Option<crate::model::BucketAccelerateStatus>,
}
impl GetBucketAccelerateConfigurationOutput {
    /// <p>The accelerate configuration of the bucket.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::BucketAccelerateStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for GetBucketAccelerateConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBucketAccelerateConfigurationOutput");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`GetBucketAccelerateConfigurationOutput`](crate::output::GetBucketAccelerateConfigurationOutput)
pub mod get_bucket_accelerate_configuration_output {
    /// A builder for [`GetBucketAccelerateConfigurationOutput`](crate::output::GetBucketAccelerateConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::BucketAccelerateStatus>,
    }
    impl Builder {
        /// <p>The accelerate configuration of the bucket.</p>
        pub fn status(mut self, input: crate::model::BucketAccelerateStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The accelerate configuration of the bucket.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::BucketAccelerateStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketAccelerateConfigurationOutput`](crate::output::GetBucketAccelerateConfigurationOutput)
        pub fn build(self) -> crate::output::GetBucketAccelerateConfigurationOutput {
            crate::output::GetBucketAccelerateConfigurationOutput {
                status: self.status,
            }
        }
    }
}
impl GetBucketAccelerateConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`GetBucketAccelerateConfigurationOutput`](crate::output::GetBucketAccelerateConfigurationOutput)
    pub fn builder() -> crate::output::get_bucket_accelerate_configuration_output::Builder {
        crate::output::get_bucket_accelerate_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePublicAccessBlockOutput {}
impl std::fmt::Debug for DeletePublicAccessBlockOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePublicAccessBlockOutput");
        formatter.finish()
    }
}
/// See [`DeletePublicAccessBlockOutput`](crate::output::DeletePublicAccessBlockOutput)
pub mod delete_public_access_block_output {
    /// A builder for [`DeletePublicAccessBlockOutput`](crate::output::DeletePublicAccessBlockOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeletePublicAccessBlockOutput`](crate::output::DeletePublicAccessBlockOutput)
        pub fn build(self) -> crate::output::DeletePublicAccessBlockOutput {
            crate::output::DeletePublicAccessBlockOutput {}
        }
    }
}
impl DeletePublicAccessBlockOutput {
    /// Creates a new builder-style object to manufacture [`DeletePublicAccessBlockOutput`](crate::output::DeletePublicAccessBlockOutput)
    pub fn builder() -> crate::output::delete_public_access_block_output::Builder {
        crate::output::delete_public_access_block_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteObjectTaggingOutput {
    /// <p>The versionId of the object the tag-set was removed from.</p>
    pub version_id: std::option::Option<std::string::String>,
}
impl DeleteObjectTaggingOutput {
    /// <p>The versionId of the object the tag-set was removed from.</p>
    pub fn version_id(&self) -> std::option::Option<&str> {
        self.version_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteObjectTaggingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteObjectTaggingOutput");
        formatter.field("version_id", &self.version_id);
        formatter.finish()
    }
}
/// See [`DeleteObjectTaggingOutput`](crate::output::DeleteObjectTaggingOutput)
pub mod delete_object_tagging_output {
    /// A builder for [`DeleteObjectTaggingOutput`](crate::output::DeleteObjectTaggingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) version_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The versionId of the object the tag-set was removed from.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The versionId of the object the tag-set was removed from.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteObjectTaggingOutput`](crate::output::DeleteObjectTaggingOutput)
        pub fn build(self) -> crate::output::DeleteObjectTaggingOutput {
            crate::output::DeleteObjectTaggingOutput {
                version_id: self.version_id,
            }
        }
    }
}
impl DeleteObjectTaggingOutput {
    /// Creates a new builder-style object to manufacture [`DeleteObjectTaggingOutput`](crate::output::DeleteObjectTaggingOutput)
    pub fn builder() -> crate::output::delete_object_tagging_output::Builder {
        crate::output::delete_object_tagging_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteObjectsOutput {
    /// <p>Container element for a successful delete. It identifies the object that was
    /// successfully deleted.</p>
    pub deleted: std::option::Option<std::vec::Vec<crate::model::DeletedObject>>,
    /// <p>If present, indicates that the requester was successfully charged for the
    /// request.</p>
    pub request_charged: std::option::Option<crate::model::RequestCharged>,
    /// <p>Container for a failed delete action that describes the object that Amazon S3 attempted to
    /// delete and the error it encountered.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::Error>>,
}
impl DeleteObjectsOutput {
    /// <p>Container element for a successful delete. It identifies the object that was
    /// successfully deleted.</p>
    pub fn deleted(&self) -> std::option::Option<&[crate::model::DeletedObject]> {
        self.deleted.as_deref()
    }
    /// <p>If present, indicates that the requester was successfully charged for the
    /// request.</p>
    pub fn request_charged(&self) -> std::option::Option<&crate::model::RequestCharged> {
        self.request_charged.as_ref()
    }
    /// <p>Container for a failed delete action that describes the object that Amazon S3 attempted to
    /// delete and the error it encountered.</p>
    pub fn errors(&self) -> std::option::Option<&[crate::model::Error]> {
        self.errors.as_deref()
    }
}
impl std::fmt::Debug for DeleteObjectsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteObjectsOutput");
        formatter.field("deleted", &self.deleted);
        formatter.field("request_charged", &self.request_charged);
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`DeleteObjectsOutput`](crate::output::DeleteObjectsOutput)
pub mod delete_objects_output {
    /// A builder for [`DeleteObjectsOutput`](crate::output::DeleteObjectsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deleted: std::option::Option<std::vec::Vec<crate::model::DeletedObject>>,
        pub(crate) request_charged: std::option::Option<crate::model::RequestCharged>,
        pub(crate) errors: std::option::Option<std::vec::Vec<crate::model::Error>>,
    }
    impl Builder {
        /// Appends an item to `deleted`.
        ///
        /// To override the contents of this collection use [`set_deleted`](Self::set_deleted).
        ///
        /// <p>Container element for a successful delete. It identifies the object that was
        /// successfully deleted.</p>
        pub fn deleted(mut self, input: impl Into<crate::model::DeletedObject>) -> Self {
            let mut v = self.deleted.unwrap_or_default();
            v.push(input.into());
            self.deleted = Some(v);
            self
        }
        /// <p>Container element for a successful delete. It identifies the object that was
        /// successfully deleted.</p>
        pub fn set_deleted(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeletedObject>>,
        ) -> Self {
            self.deleted = input;
            self
        }
        /// <p>If present, indicates that the requester was successfully charged for the
        /// request.</p>
        pub fn request_charged(mut self, input: crate::model::RequestCharged) -> Self {
            self.request_charged = Some(input);
            self
        }
        /// <p>If present, indicates that the requester was successfully charged for the
        /// request.</p>
        pub fn set_request_charged(
            mut self,
            input: std::option::Option<crate::model::RequestCharged>,
        ) -> Self {
            self.request_charged = input;
            self
        }
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>Container for a failed delete action that describes the object that Amazon S3 attempted to
        /// delete and the error it encountered.</p>
        pub fn errors(mut self, input: impl Into<crate::model::Error>) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input.into());
            self.errors = Some(v);
            self
        }
        /// <p>Container for a failed delete action that describes the object that Amazon S3 attempted to
        /// delete and the error it encountered.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Error>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteObjectsOutput`](crate::output::DeleteObjectsOutput)
        pub fn build(self) -> crate::output::DeleteObjectsOutput {
            crate::output::DeleteObjectsOutput {
                deleted: self.deleted,
                request_charged: self.request_charged,
                errors: self.errors,
            }
        }
    }
}
impl DeleteObjectsOutput {
    /// Creates a new builder-style object to manufacture [`DeleteObjectsOutput`](crate::output::DeleteObjectsOutput)
    pub fn builder() -> crate::output::delete_objects_output::Builder {
        crate::output::delete_objects_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteObjectOutput {
    /// <p>Specifies whether the versioned object that was permanently deleted was (true) or was
    /// not (false) a delete marker.</p>
    pub delete_marker: bool,
    /// <p>Returns the version ID of the delete marker created as a result of the DELETE
    /// operation.</p>
    pub version_id: std::option::Option<std::string::String>,
    /// <p>If present, indicates that the requester was successfully charged for the
    /// request.</p>
    pub request_charged: std::option::Option<crate::model::RequestCharged>,
}
impl DeleteObjectOutput {
    /// <p>Specifies whether the versioned object that was permanently deleted was (true) or was
    /// not (false) a delete marker.</p>
    pub fn delete_marker(&self) -> bool {
        self.delete_marker
    }
    /// <p>Returns the version ID of the delete marker created as a result of the DELETE
    /// operation.</p>
    pub fn version_id(&self) -> std::option::Option<&str> {
        self.version_id.as_deref()
    }
    /// <p>If present, indicates that the requester was successfully charged for the
    /// request.</p>
    pub fn request_charged(&self) -> std::option::Option<&crate::model::RequestCharged> {
        self.request_charged.as_ref()
    }
}
impl std::fmt::Debug for DeleteObjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteObjectOutput");
        formatter.field("delete_marker", &self.delete_marker);
        formatter.field("version_id", &self.version_id);
        formatter.field("request_charged", &self.request_charged);
        formatter.finish()
    }
}
/// See [`DeleteObjectOutput`](crate::output::DeleteObjectOutput)
pub mod delete_object_output {
    /// A builder for [`DeleteObjectOutput`](crate::output::DeleteObjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delete_marker: std::option::Option<bool>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) request_charged: std::option::Option<crate::model::RequestCharged>,
    }
    impl Builder {
        /// <p>Specifies whether the versioned object that was permanently deleted was (true) or was
        /// not (false) a delete marker.</p>
        pub fn delete_marker(mut self, input: bool) -> Self {
            self.delete_marker = Some(input);
            self
        }
        /// <p>Specifies whether the versioned object that was permanently deleted was (true) or was
        /// not (false) a delete marker.</p>
        pub fn set_delete_marker(mut self, input: std::option::Option<bool>) -> Self {
            self.delete_marker = input;
            self
        }
        /// <p>Returns the version ID of the delete marker created as a result of the DELETE
        /// operation.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>Returns the version ID of the delete marker created as a result of the DELETE
        /// operation.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>If present, indicates that the requester was successfully charged for the
        /// request.</p>
        pub fn request_charged(mut self, input: crate::model::RequestCharged) -> Self {
            self.request_charged = Some(input);
            self
        }
        /// <p>If present, indicates that the requester was successfully charged for the
        /// request.</p>
        pub fn set_request_charged(
            mut self,
            input: std::option::Option<crate::model::RequestCharged>,
        ) -> Self {
            self.request_charged = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteObjectOutput`](crate::output::DeleteObjectOutput)
        pub fn build(self) -> crate::output::DeleteObjectOutput {
            crate::output::DeleteObjectOutput {
                delete_marker: self.delete_marker.unwrap_or_default(),
                version_id: self.version_id,
                request_charged: self.request_charged,
            }
        }
    }
}
impl DeleteObjectOutput {
    /// Creates a new builder-style object to manufacture [`DeleteObjectOutput`](crate::output::DeleteObjectOutput)
    pub fn builder() -> crate::output::delete_object_output::Builder {
        crate::output::delete_object_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBucketWebsiteOutput {}
impl std::fmt::Debug for DeleteBucketWebsiteOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBucketWebsiteOutput");
        formatter.finish()
    }
}
/// See [`DeleteBucketWebsiteOutput`](crate::output::DeleteBucketWebsiteOutput)
pub mod delete_bucket_website_output {
    /// A builder for [`DeleteBucketWebsiteOutput`](crate::output::DeleteBucketWebsiteOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteBucketWebsiteOutput`](crate::output::DeleteBucketWebsiteOutput)
        pub fn build(self) -> crate::output::DeleteBucketWebsiteOutput {
            crate::output::DeleteBucketWebsiteOutput {}
        }
    }
}
impl DeleteBucketWebsiteOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBucketWebsiteOutput`](crate::output::DeleteBucketWebsiteOutput)
    pub fn builder() -> crate::output::delete_bucket_website_output::Builder {
        crate::output::delete_bucket_website_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBucketTaggingOutput {}
impl std::fmt::Debug for DeleteBucketTaggingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBucketTaggingOutput");
        formatter.finish()
    }
}
/// See [`DeleteBucketTaggingOutput`](crate::output::DeleteBucketTaggingOutput)
pub mod delete_bucket_tagging_output {
    /// A builder for [`DeleteBucketTaggingOutput`](crate::output::DeleteBucketTaggingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteBucketTaggingOutput`](crate::output::DeleteBucketTaggingOutput)
        pub fn build(self) -> crate::output::DeleteBucketTaggingOutput {
            crate::output::DeleteBucketTaggingOutput {}
        }
    }
}
impl DeleteBucketTaggingOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBucketTaggingOutput`](crate::output::DeleteBucketTaggingOutput)
    pub fn builder() -> crate::output::delete_bucket_tagging_output::Builder {
        crate::output::delete_bucket_tagging_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBucketReplicationOutput {}
impl std::fmt::Debug for DeleteBucketReplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBucketReplicationOutput");
        formatter.finish()
    }
}
/// See [`DeleteBucketReplicationOutput`](crate::output::DeleteBucketReplicationOutput)
pub mod delete_bucket_replication_output {
    /// A builder for [`DeleteBucketReplicationOutput`](crate::output::DeleteBucketReplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteBucketReplicationOutput`](crate::output::DeleteBucketReplicationOutput)
        pub fn build(self) -> crate::output::DeleteBucketReplicationOutput {
            crate::output::DeleteBucketReplicationOutput {}
        }
    }
}
impl DeleteBucketReplicationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBucketReplicationOutput`](crate::output::DeleteBucketReplicationOutput)
    pub fn builder() -> crate::output::delete_bucket_replication_output::Builder {
        crate::output::delete_bucket_replication_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBucketPolicyOutput {}
impl std::fmt::Debug for DeleteBucketPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBucketPolicyOutput");
        formatter.finish()
    }
}
/// See [`DeleteBucketPolicyOutput`](crate::output::DeleteBucketPolicyOutput)
pub mod delete_bucket_policy_output {
    /// A builder for [`DeleteBucketPolicyOutput`](crate::output::DeleteBucketPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteBucketPolicyOutput`](crate::output::DeleteBucketPolicyOutput)
        pub fn build(self) -> crate::output::DeleteBucketPolicyOutput {
            crate::output::DeleteBucketPolicyOutput {}
        }
    }
}
impl DeleteBucketPolicyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBucketPolicyOutput`](crate::output::DeleteBucketPolicyOutput)
    pub fn builder() -> crate::output::delete_bucket_policy_output::Builder {
        crate::output::delete_bucket_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBucketOwnershipControlsOutput {}
impl std::fmt::Debug for DeleteBucketOwnershipControlsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBucketOwnershipControlsOutput");
        formatter.finish()
    }
}
/// See [`DeleteBucketOwnershipControlsOutput`](crate::output::DeleteBucketOwnershipControlsOutput)
pub mod delete_bucket_ownership_controls_output {
    /// A builder for [`DeleteBucketOwnershipControlsOutput`](crate::output::DeleteBucketOwnershipControlsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteBucketOwnershipControlsOutput`](crate::output::DeleteBucketOwnershipControlsOutput)
        pub fn build(self) -> crate::output::DeleteBucketOwnershipControlsOutput {
            crate::output::DeleteBucketOwnershipControlsOutput {}
        }
    }
}
impl DeleteBucketOwnershipControlsOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBucketOwnershipControlsOutput`](crate::output::DeleteBucketOwnershipControlsOutput)
    pub fn builder() -> crate::output::delete_bucket_ownership_controls_output::Builder {
        crate::output::delete_bucket_ownership_controls_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBucketMetricsConfigurationOutput {}
impl std::fmt::Debug for DeleteBucketMetricsConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBucketMetricsConfigurationOutput");
        formatter.finish()
    }
}
/// See [`DeleteBucketMetricsConfigurationOutput`](crate::output::DeleteBucketMetricsConfigurationOutput)
pub mod delete_bucket_metrics_configuration_output {
    /// A builder for [`DeleteBucketMetricsConfigurationOutput`](crate::output::DeleteBucketMetricsConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteBucketMetricsConfigurationOutput`](crate::output::DeleteBucketMetricsConfigurationOutput)
        pub fn build(self) -> crate::output::DeleteBucketMetricsConfigurationOutput {
            crate::output::DeleteBucketMetricsConfigurationOutput {}
        }
    }
}
impl DeleteBucketMetricsConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBucketMetricsConfigurationOutput`](crate::output::DeleteBucketMetricsConfigurationOutput)
    pub fn builder() -> crate::output::delete_bucket_metrics_configuration_output::Builder {
        crate::output::delete_bucket_metrics_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBucketLifecycleOutput {}
impl std::fmt::Debug for DeleteBucketLifecycleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBucketLifecycleOutput");
        formatter.finish()
    }
}
/// See [`DeleteBucketLifecycleOutput`](crate::output::DeleteBucketLifecycleOutput)
pub mod delete_bucket_lifecycle_output {
    /// A builder for [`DeleteBucketLifecycleOutput`](crate::output::DeleteBucketLifecycleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteBucketLifecycleOutput`](crate::output::DeleteBucketLifecycleOutput)
        pub fn build(self) -> crate::output::DeleteBucketLifecycleOutput {
            crate::output::DeleteBucketLifecycleOutput {}
        }
    }
}
impl DeleteBucketLifecycleOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBucketLifecycleOutput`](crate::output::DeleteBucketLifecycleOutput)
    pub fn builder() -> crate::output::delete_bucket_lifecycle_output::Builder {
        crate::output::delete_bucket_lifecycle_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBucketInventoryConfigurationOutput {}
impl std::fmt::Debug for DeleteBucketInventoryConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBucketInventoryConfigurationOutput");
        formatter.finish()
    }
}
/// See [`DeleteBucketInventoryConfigurationOutput`](crate::output::DeleteBucketInventoryConfigurationOutput)
pub mod delete_bucket_inventory_configuration_output {
    /// A builder for [`DeleteBucketInventoryConfigurationOutput`](crate::output::DeleteBucketInventoryConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteBucketInventoryConfigurationOutput`](crate::output::DeleteBucketInventoryConfigurationOutput)
        pub fn build(self) -> crate::output::DeleteBucketInventoryConfigurationOutput {
            crate::output::DeleteBucketInventoryConfigurationOutput {}
        }
    }
}
impl DeleteBucketInventoryConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBucketInventoryConfigurationOutput`](crate::output::DeleteBucketInventoryConfigurationOutput)
    pub fn builder() -> crate::output::delete_bucket_inventory_configuration_output::Builder {
        crate::output::delete_bucket_inventory_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBucketIntelligentTieringConfigurationOutput {}
impl std::fmt::Debug for DeleteBucketIntelligentTieringConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBucketIntelligentTieringConfigurationOutput");
        formatter.finish()
    }
}
/// See [`DeleteBucketIntelligentTieringConfigurationOutput`](crate::output::DeleteBucketIntelligentTieringConfigurationOutput)
pub mod delete_bucket_intelligent_tiering_configuration_output {
    /// A builder for [`DeleteBucketIntelligentTieringConfigurationOutput`](crate::output::DeleteBucketIntelligentTieringConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteBucketIntelligentTieringConfigurationOutput`](crate::output::DeleteBucketIntelligentTieringConfigurationOutput)
        pub fn build(self) -> crate::output::DeleteBucketIntelligentTieringConfigurationOutput {
            crate::output::DeleteBucketIntelligentTieringConfigurationOutput {}
        }
    }
}
impl DeleteBucketIntelligentTieringConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBucketIntelligentTieringConfigurationOutput`](crate::output::DeleteBucketIntelligentTieringConfigurationOutput)
    pub fn builder(
    ) -> crate::output::delete_bucket_intelligent_tiering_configuration_output::Builder {
        crate::output::delete_bucket_intelligent_tiering_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBucketEncryptionOutput {}
impl std::fmt::Debug for DeleteBucketEncryptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBucketEncryptionOutput");
        formatter.finish()
    }
}
/// See [`DeleteBucketEncryptionOutput`](crate::output::DeleteBucketEncryptionOutput)
pub mod delete_bucket_encryption_output {
    /// A builder for [`DeleteBucketEncryptionOutput`](crate::output::DeleteBucketEncryptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteBucketEncryptionOutput`](crate::output::DeleteBucketEncryptionOutput)
        pub fn build(self) -> crate::output::DeleteBucketEncryptionOutput {
            crate::output::DeleteBucketEncryptionOutput {}
        }
    }
}
impl DeleteBucketEncryptionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBucketEncryptionOutput`](crate::output::DeleteBucketEncryptionOutput)
    pub fn builder() -> crate::output::delete_bucket_encryption_output::Builder {
        crate::output::delete_bucket_encryption_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBucketCorsOutput {}
impl std::fmt::Debug for DeleteBucketCorsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBucketCorsOutput");
        formatter.finish()
    }
}
/// See [`DeleteBucketCorsOutput`](crate::output::DeleteBucketCorsOutput)
pub mod delete_bucket_cors_output {
    /// A builder for [`DeleteBucketCorsOutput`](crate::output::DeleteBucketCorsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteBucketCorsOutput`](crate::output::DeleteBucketCorsOutput)
        pub fn build(self) -> crate::output::DeleteBucketCorsOutput {
            crate::output::DeleteBucketCorsOutput {}
        }
    }
}
impl DeleteBucketCorsOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBucketCorsOutput`](crate::output::DeleteBucketCorsOutput)
    pub fn builder() -> crate::output::delete_bucket_cors_output::Builder {
        crate::output::delete_bucket_cors_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBucketAnalyticsConfigurationOutput {}
impl std::fmt::Debug for DeleteBucketAnalyticsConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBucketAnalyticsConfigurationOutput");
        formatter.finish()
    }
}
/// See [`DeleteBucketAnalyticsConfigurationOutput`](crate::output::DeleteBucketAnalyticsConfigurationOutput)
pub mod delete_bucket_analytics_configuration_output {
    /// A builder for [`DeleteBucketAnalyticsConfigurationOutput`](crate::output::DeleteBucketAnalyticsConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteBucketAnalyticsConfigurationOutput`](crate::output::DeleteBucketAnalyticsConfigurationOutput)
        pub fn build(self) -> crate::output::DeleteBucketAnalyticsConfigurationOutput {
            crate::output::DeleteBucketAnalyticsConfigurationOutput {}
        }
    }
}
impl DeleteBucketAnalyticsConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBucketAnalyticsConfigurationOutput`](crate::output::DeleteBucketAnalyticsConfigurationOutput)
    pub fn builder() -> crate::output::delete_bucket_analytics_configuration_output::Builder {
        crate::output::delete_bucket_analytics_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBucketOutput {}
impl std::fmt::Debug for DeleteBucketOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBucketOutput");
        formatter.finish()
    }
}
/// See [`DeleteBucketOutput`](crate::output::DeleteBucketOutput)
pub mod delete_bucket_output {
    /// A builder for [`DeleteBucketOutput`](crate::output::DeleteBucketOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteBucketOutput`](crate::output::DeleteBucketOutput)
        pub fn build(self) -> crate::output::DeleteBucketOutput {
            crate::output::DeleteBucketOutput {}
        }
    }
}
impl DeleteBucketOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBucketOutput`](crate::output::DeleteBucketOutput)
    pub fn builder() -> crate::output::delete_bucket_output::Builder {
        crate::output::delete_bucket_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateMultipartUploadOutput {
    /// <p>If the bucket has a lifecycle rule configured with an action to abort incomplete
    /// multipart uploads and the prefix in the lifecycle rule matches the object name in the
    /// request, the response includes this header. The header indicates when the initiated
    /// multipart upload becomes eligible for an abort operation. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config">
    /// Aborting Incomplete Multipart Uploads Using a Bucket Lifecycle Policy</a>.</p>
    ///
    /// <p>The response also includes the <code>x-amz-abort-rule-id</code> header that provides the
    /// ID of the lifecycle configuration rule that defines this action.</p>
    pub abort_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>This header is returned along with the <code>x-amz-abort-date</code> header. It
    /// identifies the applicable lifecycle configuration rule that defines the action to abort
    /// incomplete multipart uploads.</p>
    pub abort_rule_id: std::option::Option<std::string::String>,
    /// <p>The name of the bucket to which the multipart upload was initiated. Does not return the access point ARN or access point alias if used.</p>
    /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>Object key for which the multipart upload was initiated.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>ID for the initiated multipart upload.</p>
    pub upload_id: std::option::Option<std::string::String>,
    /// <p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example,
    /// AES256, aws:kms).</p>
    pub server_side_encryption: std::option::Option<crate::model::ServerSideEncryption>,
    /// <p>If server-side encryption with a customer-provided encryption key was requested, the
    /// response will include this header confirming the encryption algorithm used.</p>
    pub sse_customer_algorithm: std::option::Option<std::string::String>,
    /// <p>If server-side encryption with a customer-provided encryption key was requested, the
    /// response will include this header to provide round-trip message integrity verification of
    /// the customer-provided encryption key.</p>
    pub sse_customer_key_md5: std::option::Option<std::string::String>,
    /// <p>If present, specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric
    /// customer managed key that was used for the object.</p>
    pub ssekms_key_id: std::option::Option<std::string::String>,
    /// <p>If present, specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The
    /// value of this header is a base64-encoded UTF-8 string holding JSON with the encryption
    /// context key-value pairs.</p>
    pub ssekms_encryption_context: std::option::Option<std::string::String>,
    /// <p>Indicates whether the multipart upload uses an S3 Bucket Key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
    pub bucket_key_enabled: bool,
    /// <p>If present, indicates that the requester was successfully charged for the
    /// request.</p>
    pub request_charged: std::option::Option<crate::model::RequestCharged>,
}
impl CreateMultipartUploadOutput {
    /// <p>If the bucket has a lifecycle rule configured with an action to abort incomplete
    /// multipart uploads and the prefix in the lifecycle rule matches the object name in the
    /// request, the response includes this header. The header indicates when the initiated
    /// multipart upload becomes eligible for an abort operation. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config">
    /// Aborting Incomplete Multipart Uploads Using a Bucket Lifecycle Policy</a>.</p>
    ///
    /// <p>The response also includes the <code>x-amz-abort-rule-id</code> header that provides the
    /// ID of the lifecycle configuration rule that defines this action.</p>
    pub fn abort_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.abort_date.as_ref()
    }
    /// <p>This header is returned along with the <code>x-amz-abort-date</code> header. It
    /// identifies the applicable lifecycle configuration rule that defines the action to abort
    /// incomplete multipart uploads.</p>
    pub fn abort_rule_id(&self) -> std::option::Option<&str> {
        self.abort_rule_id.as_deref()
    }
    /// <p>The name of the bucket to which the multipart upload was initiated. Does not return the access point ARN or access point alias if used.</p>
    /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>Object key for which the multipart upload was initiated.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>ID for the initiated multipart upload.</p>
    pub fn upload_id(&self) -> std::option::Option<&str> {
        self.upload_id.as_deref()
    }
    /// <p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example,
    /// AES256, aws:kms).</p>
    pub fn server_side_encryption(
        &self,
    ) -> std::option::Option<&crate::model::ServerSideEncryption> {
        self.server_side_encryption.as_ref()
    }
    /// <p>If server-side encryption with a customer-provided encryption key was requested, the
    /// response will include this header confirming the encryption algorithm used.</p>
    pub fn sse_customer_algorithm(&self) -> std::option::Option<&str> {
        self.sse_customer_algorithm.as_deref()
    }
    /// <p>If server-side encryption with a customer-provided encryption key was requested, the
    /// response will include this header to provide round-trip message integrity verification of
    /// the customer-provided encryption key.</p>
    pub fn sse_customer_key_md5(&self) -> std::option::Option<&str> {
        self.sse_customer_key_md5.as_deref()
    }
    /// <p>If present, specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric
    /// customer managed key that was used for the object.</p>
    pub fn ssekms_key_id(&self) -> std::option::Option<&str> {
        self.ssekms_key_id.as_deref()
    }
    /// <p>If present, specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The
    /// value of this header is a base64-encoded UTF-8 string holding JSON with the encryption
    /// context key-value pairs.</p>
    pub fn ssekms_encryption_context(&self) -> std::option::Option<&str> {
        self.ssekms_encryption_context.as_deref()
    }
    /// <p>Indicates whether the multipart upload uses an S3 Bucket Key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
    pub fn bucket_key_enabled(&self) -> bool {
        self.bucket_key_enabled
    }
    /// <p>If present, indicates that the requester was successfully charged for the
    /// request.</p>
    pub fn request_charged(&self) -> std::option::Option<&crate::model::RequestCharged> {
        self.request_charged.as_ref()
    }
}
impl std::fmt::Debug for CreateMultipartUploadOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateMultipartUploadOutput");
        formatter.field("abort_date", &self.abort_date);
        formatter.field("abort_rule_id", &self.abort_rule_id);
        formatter.field("bucket", &self.bucket);
        formatter.field("key", &self.key);
        formatter.field("upload_id", &self.upload_id);
        formatter.field("server_side_encryption", &self.server_side_encryption);
        formatter.field("sse_customer_algorithm", &self.sse_customer_algorithm);
        formatter.field("sse_customer_key_md5", &self.sse_customer_key_md5);
        formatter.field("ssekms_key_id", &"*** Sensitive Data Redacted ***");
        formatter.field(
            "ssekms_encryption_context",
            &"*** Sensitive Data Redacted ***",
        );
        formatter.field("bucket_key_enabled", &self.bucket_key_enabled);
        formatter.field("request_charged", &self.request_charged);
        formatter.finish()
    }
}
/// See [`CreateMultipartUploadOutput`](crate::output::CreateMultipartUploadOutput)
pub mod create_multipart_upload_output {
    /// A builder for [`CreateMultipartUploadOutput`](crate::output::CreateMultipartUploadOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) abort_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) abort_rule_id: std::option::Option<std::string::String>,
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) upload_id: std::option::Option<std::string::String>,
        pub(crate) server_side_encryption: std::option::Option<crate::model::ServerSideEncryption>,
        pub(crate) sse_customer_algorithm: std::option::Option<std::string::String>,
        pub(crate) sse_customer_key_md5: std::option::Option<std::string::String>,
        pub(crate) ssekms_key_id: std::option::Option<std::string::String>,
        pub(crate) ssekms_encryption_context: std::option::Option<std::string::String>,
        pub(crate) bucket_key_enabled: std::option::Option<bool>,
        pub(crate) request_charged: std::option::Option<crate::model::RequestCharged>,
    }
    impl Builder {
        /// <p>If the bucket has a lifecycle rule configured with an action to abort incomplete
        /// multipart uploads and the prefix in the lifecycle rule matches the object name in the
        /// request, the response includes this header. The header indicates when the initiated
        /// multipart upload becomes eligible for an abort operation. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config">
        /// Aborting Incomplete Multipart Uploads Using a Bucket Lifecycle Policy</a>.</p>
        ///
        /// <p>The response also includes the <code>x-amz-abort-rule-id</code> header that provides the
        /// ID of the lifecycle configuration rule that defines this action.</p>
        pub fn abort_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.abort_date = Some(input);
            self
        }
        /// <p>If the bucket has a lifecycle rule configured with an action to abort incomplete
        /// multipart uploads and the prefix in the lifecycle rule matches the object name in the
        /// request, the response includes this header. The header indicates when the initiated
        /// multipart upload becomes eligible for an abort operation. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config">
        /// Aborting Incomplete Multipart Uploads Using a Bucket Lifecycle Policy</a>.</p>
        ///
        /// <p>The response also includes the <code>x-amz-abort-rule-id</code> header that provides the
        /// ID of the lifecycle configuration rule that defines this action.</p>
        pub fn set_abort_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.abort_date = input;
            self
        }
        /// <p>This header is returned along with the <code>x-amz-abort-date</code> header. It
        /// identifies the applicable lifecycle configuration rule that defines the action to abort
        /// incomplete multipart uploads.</p>
        pub fn abort_rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.abort_rule_id = Some(input.into());
            self
        }
        /// <p>This header is returned along with the <code>x-amz-abort-date</code> header. It
        /// identifies the applicable lifecycle configuration rule that defines the action to abort
        /// incomplete multipart uploads.</p>
        pub fn set_abort_rule_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.abort_rule_id = input;
            self
        }
        /// <p>The name of the bucket to which the multipart upload was initiated. Does not return the access point ARN or access point alias if used.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket to which the multipart upload was initiated. Does not return the access point ARN or access point alias if used.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Object key for which the multipart upload was initiated.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>Object key for which the multipart upload was initiated.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>ID for the initiated multipart upload.</p>
        pub fn upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.upload_id = Some(input.into());
            self
        }
        /// <p>ID for the initiated multipart upload.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.upload_id = input;
            self
        }
        /// <p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example,
        /// AES256, aws:kms).</p>
        pub fn server_side_encryption(mut self, input: crate::model::ServerSideEncryption) -> Self {
            self.server_side_encryption = Some(input);
            self
        }
        /// <p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example,
        /// AES256, aws:kms).</p>
        pub fn set_server_side_encryption(
            mut self,
            input: std::option::Option<crate::model::ServerSideEncryption>,
        ) -> Self {
            self.server_side_encryption = input;
            self
        }
        /// <p>If server-side encryption with a customer-provided encryption key was requested, the
        /// response will include this header confirming the encryption algorithm used.</p>
        pub fn sse_customer_algorithm(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_customer_algorithm = Some(input.into());
            self
        }
        /// <p>If server-side encryption with a customer-provided encryption key was requested, the
        /// response will include this header confirming the encryption algorithm used.</p>
        pub fn set_sse_customer_algorithm(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_customer_algorithm = input;
            self
        }
        /// <p>If server-side encryption with a customer-provided encryption key was requested, the
        /// response will include this header to provide round-trip message integrity verification of
        /// the customer-provided encryption key.</p>
        pub fn sse_customer_key_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_customer_key_md5 = Some(input.into());
            self
        }
        /// <p>If server-side encryption with a customer-provided encryption key was requested, the
        /// response will include this header to provide round-trip message integrity verification of
        /// the customer-provided encryption key.</p>
        pub fn set_sse_customer_key_md5(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_customer_key_md5 = input;
            self
        }
        /// <p>If present, specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric
        /// customer managed key that was used for the object.</p>
        pub fn ssekms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssekms_key_id = Some(input.into());
            self
        }
        /// <p>If present, specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric
        /// customer managed key that was used for the object.</p>
        pub fn set_ssekms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssekms_key_id = input;
            self
        }
        /// <p>If present, specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The
        /// value of this header is a base64-encoded UTF-8 string holding JSON with the encryption
        /// context key-value pairs.</p>
        pub fn ssekms_encryption_context(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssekms_encryption_context = Some(input.into());
            self
        }
        /// <p>If present, specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The
        /// value of this header is a base64-encoded UTF-8 string holding JSON with the encryption
        /// context key-value pairs.</p>
        pub fn set_ssekms_encryption_context(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssekms_encryption_context = input;
            self
        }
        /// <p>Indicates whether the multipart upload uses an S3 Bucket Key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
        pub fn bucket_key_enabled(mut self, input: bool) -> Self {
            self.bucket_key_enabled = Some(input);
            self
        }
        /// <p>Indicates whether the multipart upload uses an S3 Bucket Key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
        pub fn set_bucket_key_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.bucket_key_enabled = input;
            self
        }
        /// <p>If present, indicates that the requester was successfully charged for the
        /// request.</p>
        pub fn request_charged(mut self, input: crate::model::RequestCharged) -> Self {
            self.request_charged = Some(input);
            self
        }
        /// <p>If present, indicates that the requester was successfully charged for the
        /// request.</p>
        pub fn set_request_charged(
            mut self,
            input: std::option::Option<crate::model::RequestCharged>,
        ) -> Self {
            self.request_charged = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMultipartUploadOutput`](crate::output::CreateMultipartUploadOutput)
        pub fn build(self) -> crate::output::CreateMultipartUploadOutput {
            crate::output::CreateMultipartUploadOutput {
                abort_date: self.abort_date,
                abort_rule_id: self.abort_rule_id,
                bucket: self.bucket,
                key: self.key,
                upload_id: self.upload_id,
                server_side_encryption: self.server_side_encryption,
                sse_customer_algorithm: self.sse_customer_algorithm,
                sse_customer_key_md5: self.sse_customer_key_md5,
                ssekms_key_id: self.ssekms_key_id,
                ssekms_encryption_context: self.ssekms_encryption_context,
                bucket_key_enabled: self.bucket_key_enabled.unwrap_or_default(),
                request_charged: self.request_charged,
            }
        }
    }
}
impl CreateMultipartUploadOutput {
    /// Creates a new builder-style object to manufacture [`CreateMultipartUploadOutput`](crate::output::CreateMultipartUploadOutput)
    pub fn builder() -> crate::output::create_multipart_upload_output::Builder {
        crate::output::create_multipart_upload_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBucketOutput {
    /// <p>Specifies the Region where the bucket will be created. If you are creating a bucket on
    /// the US East (N. Virginia) Region (us-east-1), you do not need to specify the
    /// location.</p>
    pub location: std::option::Option<std::string::String>,
}
impl CreateBucketOutput {
    /// <p>Specifies the Region where the bucket will be created. If you are creating a bucket on
    /// the US East (N. Virginia) Region (us-east-1), you do not need to specify the
    /// location.</p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
}
impl std::fmt::Debug for CreateBucketOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBucketOutput");
        formatter.field("location", &self.location);
        formatter.finish()
    }
}
/// See [`CreateBucketOutput`](crate::output::CreateBucketOutput)
pub mod create_bucket_output {
    /// A builder for [`CreateBucketOutput`](crate::output::CreateBucketOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the Region where the bucket will be created. If you are creating a bucket on
        /// the US East (N. Virginia) Region (us-east-1), you do not need to specify the
        /// location.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>Specifies the Region where the bucket will be created. If you are creating a bucket on
        /// the US East (N. Virginia) Region (us-east-1), you do not need to specify the
        /// location.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBucketOutput`](crate::output::CreateBucketOutput)
        pub fn build(self) -> crate::output::CreateBucketOutput {
            crate::output::CreateBucketOutput {
                location: self.location,
            }
        }
    }
}
impl CreateBucketOutput {
    /// Creates a new builder-style object to manufacture [`CreateBucketOutput`](crate::output::CreateBucketOutput)
    pub fn builder() -> crate::output::create_bucket_output::Builder {
        crate::output::create_bucket_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CopyObjectOutput {
    /// <p>Container for all response elements.</p>
    pub copy_object_result: std::option::Option<crate::model::CopyObjectResult>,
    /// <p>If the object expiration is configured, the response includes this header.</p>
    pub expiration: std::option::Option<std::string::String>,
    /// <p>Version of the copied object in the destination bucket.</p>
    pub copy_source_version_id: std::option::Option<std::string::String>,
    /// <p>Version ID of the newly created copy.</p>
    pub version_id: std::option::Option<std::string::String>,
    /// <p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example,
    /// AES256, aws:kms).</p>
    pub server_side_encryption: std::option::Option<crate::model::ServerSideEncryption>,
    /// <p>If server-side encryption with a customer-provided encryption key was requested, the
    /// response will include this header confirming the encryption algorithm used.</p>
    pub sse_customer_algorithm: std::option::Option<std::string::String>,
    /// <p>If server-side encryption with a customer-provided encryption key was requested, the
    /// response will include this header to provide round-trip message integrity verification of
    /// the customer-provided encryption key.</p>
    pub sse_customer_key_md5: std::option::Option<std::string::String>,
    /// <p>If present, specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric
    /// customer managed key that was used for the object.</p>
    pub ssekms_key_id: std::option::Option<std::string::String>,
    /// <p>If present, specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The
    /// value of this header is a base64-encoded UTF-8 string holding JSON with the encryption
    /// context key-value pairs.</p>
    pub ssekms_encryption_context: std::option::Option<std::string::String>,
    /// <p>Indicates whether the copied object uses an S3 Bucket Key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
    pub bucket_key_enabled: bool,
    /// <p>If present, indicates that the requester was successfully charged for the
    /// request.</p>
    pub request_charged: std::option::Option<crate::model::RequestCharged>,
}
impl CopyObjectOutput {
    /// <p>Container for all response elements.</p>
    pub fn copy_object_result(&self) -> std::option::Option<&crate::model::CopyObjectResult> {
        self.copy_object_result.as_ref()
    }
    /// <p>If the object expiration is configured, the response includes this header.</p>
    pub fn expiration(&self) -> std::option::Option<&str> {
        self.expiration.as_deref()
    }
    /// <p>Version of the copied object in the destination bucket.</p>
    pub fn copy_source_version_id(&self) -> std::option::Option<&str> {
        self.copy_source_version_id.as_deref()
    }
    /// <p>Version ID of the newly created copy.</p>
    pub fn version_id(&self) -> std::option::Option<&str> {
        self.version_id.as_deref()
    }
    /// <p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example,
    /// AES256, aws:kms).</p>
    pub fn server_side_encryption(
        &self,
    ) -> std::option::Option<&crate::model::ServerSideEncryption> {
        self.server_side_encryption.as_ref()
    }
    /// <p>If server-side encryption with a customer-provided encryption key was requested, the
    /// response will include this header confirming the encryption algorithm used.</p>
    pub fn sse_customer_algorithm(&self) -> std::option::Option<&str> {
        self.sse_customer_algorithm.as_deref()
    }
    /// <p>If server-side encryption with a customer-provided encryption key was requested, the
    /// response will include this header to provide round-trip message integrity verification of
    /// the customer-provided encryption key.</p>
    pub fn sse_customer_key_md5(&self) -> std::option::Option<&str> {
        self.sse_customer_key_md5.as_deref()
    }
    /// <p>If present, specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric
    /// customer managed key that was used for the object.</p>
    pub fn ssekms_key_id(&self) -> std::option::Option<&str> {
        self.ssekms_key_id.as_deref()
    }
    /// <p>If present, specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The
    /// value of this header is a base64-encoded UTF-8 string holding JSON with the encryption
    /// context key-value pairs.</p>
    pub fn ssekms_encryption_context(&self) -> std::option::Option<&str> {
        self.ssekms_encryption_context.as_deref()
    }
    /// <p>Indicates whether the copied object uses an S3 Bucket Key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
    pub fn bucket_key_enabled(&self) -> bool {
        self.bucket_key_enabled
    }
    /// <p>If present, indicates that the requester was successfully charged for the
    /// request.</p>
    pub fn request_charged(&self) -> std::option::Option<&crate::model::RequestCharged> {
        self.request_charged.as_ref()
    }
}
impl std::fmt::Debug for CopyObjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CopyObjectOutput");
        formatter.field("copy_object_result", &self.copy_object_result);
        formatter.field("expiration", &self.expiration);
        formatter.field("copy_source_version_id", &self.copy_source_version_id);
        formatter.field("version_id", &self.version_id);
        formatter.field("server_side_encryption", &self.server_side_encryption);
        formatter.field("sse_customer_algorithm", &self.sse_customer_algorithm);
        formatter.field("sse_customer_key_md5", &self.sse_customer_key_md5);
        formatter.field("ssekms_key_id", &"*** Sensitive Data Redacted ***");
        formatter.field(
            "ssekms_encryption_context",
            &"*** Sensitive Data Redacted ***",
        );
        formatter.field("bucket_key_enabled", &self.bucket_key_enabled);
        formatter.field("request_charged", &self.request_charged);
        formatter.finish()
    }
}
/// See [`CopyObjectOutput`](crate::output::CopyObjectOutput)
pub mod copy_object_output {
    /// A builder for [`CopyObjectOutput`](crate::output::CopyObjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) copy_object_result: std::option::Option<crate::model::CopyObjectResult>,
        pub(crate) expiration: std::option::Option<std::string::String>,
        pub(crate) copy_source_version_id: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) server_side_encryption: std::option::Option<crate::model::ServerSideEncryption>,
        pub(crate) sse_customer_algorithm: std::option::Option<std::string::String>,
        pub(crate) sse_customer_key_md5: std::option::Option<std::string::String>,
        pub(crate) ssekms_key_id: std::option::Option<std::string::String>,
        pub(crate) ssekms_encryption_context: std::option::Option<std::string::String>,
        pub(crate) bucket_key_enabled: std::option::Option<bool>,
        pub(crate) request_charged: std::option::Option<crate::model::RequestCharged>,
    }
    impl Builder {
        /// <p>Container for all response elements.</p>
        pub fn copy_object_result(mut self, input: crate::model::CopyObjectResult) -> Self {
            self.copy_object_result = Some(input);
            self
        }
        /// <p>Container for all response elements.</p>
        pub fn set_copy_object_result(
            mut self,
            input: std::option::Option<crate::model::CopyObjectResult>,
        ) -> Self {
            self.copy_object_result = input;
            self
        }
        /// <p>If the object expiration is configured, the response includes this header.</p>
        pub fn expiration(mut self, input: impl Into<std::string::String>) -> Self {
            self.expiration = Some(input.into());
            self
        }
        /// <p>If the object expiration is configured, the response includes this header.</p>
        pub fn set_expiration(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.expiration = input;
            self
        }
        /// <p>Version of the copied object in the destination bucket.</p>
        pub fn copy_source_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.copy_source_version_id = Some(input.into());
            self
        }
        /// <p>Version of the copied object in the destination bucket.</p>
        pub fn set_copy_source_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.copy_source_version_id = input;
            self
        }
        /// <p>Version ID of the newly created copy.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>Version ID of the newly created copy.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example,
        /// AES256, aws:kms).</p>
        pub fn server_side_encryption(mut self, input: crate::model::ServerSideEncryption) -> Self {
            self.server_side_encryption = Some(input);
            self
        }
        /// <p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example,
        /// AES256, aws:kms).</p>
        pub fn set_server_side_encryption(
            mut self,
            input: std::option::Option<crate::model::ServerSideEncryption>,
        ) -> Self {
            self.server_side_encryption = input;
            self
        }
        /// <p>If server-side encryption with a customer-provided encryption key was requested, the
        /// response will include this header confirming the encryption algorithm used.</p>
        pub fn sse_customer_algorithm(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_customer_algorithm = Some(input.into());
            self
        }
        /// <p>If server-side encryption with a customer-provided encryption key was requested, the
        /// response will include this header confirming the encryption algorithm used.</p>
        pub fn set_sse_customer_algorithm(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_customer_algorithm = input;
            self
        }
        /// <p>If server-side encryption with a customer-provided encryption key was requested, the
        /// response will include this header to provide round-trip message integrity verification of
        /// the customer-provided encryption key.</p>
        pub fn sse_customer_key_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_customer_key_md5 = Some(input.into());
            self
        }
        /// <p>If server-side encryption with a customer-provided encryption key was requested, the
        /// response will include this header to provide round-trip message integrity verification of
        /// the customer-provided encryption key.</p>
        pub fn set_sse_customer_key_md5(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_customer_key_md5 = input;
            self
        }
        /// <p>If present, specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric
        /// customer managed key that was used for the object.</p>
        pub fn ssekms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssekms_key_id = Some(input.into());
            self
        }
        /// <p>If present, specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric
        /// customer managed key that was used for the object.</p>
        pub fn set_ssekms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssekms_key_id = input;
            self
        }
        /// <p>If present, specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The
        /// value of this header is a base64-encoded UTF-8 string holding JSON with the encryption
        /// context key-value pairs.</p>
        pub fn ssekms_encryption_context(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssekms_encryption_context = Some(input.into());
            self
        }
        /// <p>If present, specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The
        /// value of this header is a base64-encoded UTF-8 string holding JSON with the encryption
        /// context key-value pairs.</p>
        pub fn set_ssekms_encryption_context(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssekms_encryption_context = input;
            self
        }
        /// <p>Indicates whether the copied object uses an S3 Bucket Key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
        pub fn bucket_key_enabled(mut self, input: bool) -> Self {
            self.bucket_key_enabled = Some(input);
            self
        }
        /// <p>Indicates whether the copied object uses an S3 Bucket Key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
        pub fn set_bucket_key_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.bucket_key_enabled = input;
            self
        }
        /// <p>If present, indicates that the requester was successfully charged for the
        /// request.</p>
        pub fn request_charged(mut self, input: crate::model::RequestCharged) -> Self {
            self.request_charged = Some(input);
            self
        }
        /// <p>If present, indicates that the requester was successfully charged for the
        /// request.</p>
        pub fn set_request_charged(
            mut self,
            input: std::option::Option<crate::model::RequestCharged>,
        ) -> Self {
            self.request_charged = input;
            self
        }
        /// Consumes the builder and constructs a [`CopyObjectOutput`](crate::output::CopyObjectOutput)
        pub fn build(self) -> crate::output::CopyObjectOutput {
            crate::output::CopyObjectOutput {
                copy_object_result: self.copy_object_result,
                expiration: self.expiration,
                copy_source_version_id: self.copy_source_version_id,
                version_id: self.version_id,
                server_side_encryption: self.server_side_encryption,
                sse_customer_algorithm: self.sse_customer_algorithm,
                sse_customer_key_md5: self.sse_customer_key_md5,
                ssekms_key_id: self.ssekms_key_id,
                ssekms_encryption_context: self.ssekms_encryption_context,
                bucket_key_enabled: self.bucket_key_enabled.unwrap_or_default(),
                request_charged: self.request_charged,
            }
        }
    }
}
impl CopyObjectOutput {
    /// Creates a new builder-style object to manufacture [`CopyObjectOutput`](crate::output::CopyObjectOutput)
    pub fn builder() -> crate::output::copy_object_output::Builder {
        crate::output::copy_object_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CompleteMultipartUploadOutput {
    /// <p>The URI that identifies the newly created object.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The name of the bucket that contains the newly created object. Does not return the access point ARN or access point alias if used.</p>
    /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>The object key of the newly created object.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>If the object expiration is configured, this will contain the expiration date
    /// (expiry-date) and rule ID (rule-id). The value of rule-id is URL encoded.</p>
    pub expiration: std::option::Option<std::string::String>,
    /// <p>Entity tag that identifies the newly created object's data. Objects with different
    /// object data will have different entity tags. The entity tag is an opaque string. The entity
    /// tag may or may not be an MD5 digest of the object data. If the entity tag is not an MD5
    /// digest of the object data, it will contain one or more nonhexadecimal characters and/or
    /// will consist of less than 32 or more than 32 hexadecimal digits.</p>
    pub e_tag: std::option::Option<std::string::String>,
    /// <p>If you specified server-side encryption either with an Amazon S3-managed encryption key or an
    /// Amazon Web Services KMS key in your initiate multipart upload request, the response
    /// includes this header. It confirms the encryption algorithm that Amazon S3 used to encrypt the
    /// object.</p>
    pub server_side_encryption: std::option::Option<crate::model::ServerSideEncryption>,
    /// <p>Version ID of the newly created object, in case the bucket has versioning turned
    /// on.</p>
    pub version_id: std::option::Option<std::string::String>,
    /// <p>If present, specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric
    /// customer managed key that was used for the object.</p>
    pub ssekms_key_id: std::option::Option<std::string::String>,
    /// <p>Indicates whether the multipart upload uses an S3 Bucket Key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
    pub bucket_key_enabled: bool,
    /// <p>If present, indicates that the requester was successfully charged for the
    /// request.</p>
    pub request_charged: std::option::Option<crate::model::RequestCharged>,
}
impl CompleteMultipartUploadOutput {
    /// <p>The URI that identifies the newly created object.</p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
    /// <p>The name of the bucket that contains the newly created object. Does not return the access point ARN or access point alias if used.</p>
    /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>The object key of the newly created object.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>If the object expiration is configured, this will contain the expiration date
    /// (expiry-date) and rule ID (rule-id). The value of rule-id is URL encoded.</p>
    pub fn expiration(&self) -> std::option::Option<&str> {
        self.expiration.as_deref()
    }
    /// <p>Entity tag that identifies the newly created object's data. Objects with different
    /// object data will have different entity tags. The entity tag is an opaque string. The entity
    /// tag may or may not be an MD5 digest of the object data. If the entity tag is not an MD5
    /// digest of the object data, it will contain one or more nonhexadecimal characters and/or
    /// will consist of less than 32 or more than 32 hexadecimal digits.</p>
    pub fn e_tag(&self) -> std::option::Option<&str> {
        self.e_tag.as_deref()
    }
    /// <p>If you specified server-side encryption either with an Amazon S3-managed encryption key or an
    /// Amazon Web Services KMS key in your initiate multipart upload request, the response
    /// includes this header. It confirms the encryption algorithm that Amazon S3 used to encrypt the
    /// object.</p>
    pub fn server_side_encryption(
        &self,
    ) -> std::option::Option<&crate::model::ServerSideEncryption> {
        self.server_side_encryption.as_ref()
    }
    /// <p>Version ID of the newly created object, in case the bucket has versioning turned
    /// on.</p>
    pub fn version_id(&self) -> std::option::Option<&str> {
        self.version_id.as_deref()
    }
    /// <p>If present, specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric
    /// customer managed key that was used for the object.</p>
    pub fn ssekms_key_id(&self) -> std::option::Option<&str> {
        self.ssekms_key_id.as_deref()
    }
    /// <p>Indicates whether the multipart upload uses an S3 Bucket Key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
    pub fn bucket_key_enabled(&self) -> bool {
        self.bucket_key_enabled
    }
    /// <p>If present, indicates that the requester was successfully charged for the
    /// request.</p>
    pub fn request_charged(&self) -> std::option::Option<&crate::model::RequestCharged> {
        self.request_charged.as_ref()
    }
}
impl std::fmt::Debug for CompleteMultipartUploadOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CompleteMultipartUploadOutput");
        formatter.field("location", &self.location);
        formatter.field("bucket", &self.bucket);
        formatter.field("key", &self.key);
        formatter.field("expiration", &self.expiration);
        formatter.field("e_tag", &self.e_tag);
        formatter.field("server_side_encryption", &self.server_side_encryption);
        formatter.field("version_id", &self.version_id);
        formatter.field("ssekms_key_id", &"*** Sensitive Data Redacted ***");
        formatter.field("bucket_key_enabled", &self.bucket_key_enabled);
        formatter.field("request_charged", &self.request_charged);
        formatter.finish()
    }
}
/// See [`CompleteMultipartUploadOutput`](crate::output::CompleteMultipartUploadOutput)
pub mod complete_multipart_upload_output {
    /// A builder for [`CompleteMultipartUploadOutput`](crate::output::CompleteMultipartUploadOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) expiration: std::option::Option<std::string::String>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
        pub(crate) server_side_encryption: std::option::Option<crate::model::ServerSideEncryption>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) ssekms_key_id: std::option::Option<std::string::String>,
        pub(crate) bucket_key_enabled: std::option::Option<bool>,
        pub(crate) request_charged: std::option::Option<crate::model::RequestCharged>,
    }
    impl Builder {
        /// <p>The URI that identifies the newly created object.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The URI that identifies the newly created object.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The name of the bucket that contains the newly created object. Does not return the access point ARN or access point alias if used.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket that contains the newly created object. Does not return the access point ARN or access point alias if used.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The object key of the newly created object.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The object key of the newly created object.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>If the object expiration is configured, this will contain the expiration date
        /// (expiry-date) and rule ID (rule-id). The value of rule-id is URL encoded.</p>
        pub fn expiration(mut self, input: impl Into<std::string::String>) -> Self {
            self.expiration = Some(input.into());
            self
        }
        /// <p>If the object expiration is configured, this will contain the expiration date
        /// (expiry-date) and rule ID (rule-id). The value of rule-id is URL encoded.</p>
        pub fn set_expiration(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.expiration = input;
            self
        }
        /// <p>Entity tag that identifies the newly created object's data. Objects with different
        /// object data will have different entity tags. The entity tag is an opaque string. The entity
        /// tag may or may not be an MD5 digest of the object data. If the entity tag is not an MD5
        /// digest of the object data, it will contain one or more nonhexadecimal characters and/or
        /// will consist of less than 32 or more than 32 hexadecimal digits.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>Entity tag that identifies the newly created object's data. Objects with different
        /// object data will have different entity tags. The entity tag is an opaque string. The entity
        /// tag may or may not be an MD5 digest of the object data. If the entity tag is not an MD5
        /// digest of the object data, it will contain one or more nonhexadecimal characters and/or
        /// will consist of less than 32 or more than 32 hexadecimal digits.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// <p>If you specified server-side encryption either with an Amazon S3-managed encryption key or an
        /// Amazon Web Services KMS key in your initiate multipart upload request, the response
        /// includes this header. It confirms the encryption algorithm that Amazon S3 used to encrypt the
        /// object.</p>
        pub fn server_side_encryption(mut self, input: crate::model::ServerSideEncryption) -> Self {
            self.server_side_encryption = Some(input);
            self
        }
        /// <p>If you specified server-side encryption either with an Amazon S3-managed encryption key or an
        /// Amazon Web Services KMS key in your initiate multipart upload request, the response
        /// includes this header. It confirms the encryption algorithm that Amazon S3 used to encrypt the
        /// object.</p>
        pub fn set_server_side_encryption(
            mut self,
            input: std::option::Option<crate::model::ServerSideEncryption>,
        ) -> Self {
            self.server_side_encryption = input;
            self
        }
        /// <p>Version ID of the newly created object, in case the bucket has versioning turned
        /// on.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>Version ID of the newly created object, in case the bucket has versioning turned
        /// on.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>If present, specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric
        /// customer managed key that was used for the object.</p>
        pub fn ssekms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssekms_key_id = Some(input.into());
            self
        }
        /// <p>If present, specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric
        /// customer managed key that was used for the object.</p>
        pub fn set_ssekms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssekms_key_id = input;
            self
        }
        /// <p>Indicates whether the multipart upload uses an S3 Bucket Key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
        pub fn bucket_key_enabled(mut self, input: bool) -> Self {
            self.bucket_key_enabled = Some(input);
            self
        }
        /// <p>Indicates whether the multipart upload uses an S3 Bucket Key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
        pub fn set_bucket_key_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.bucket_key_enabled = input;
            self
        }
        /// <p>If present, indicates that the requester was successfully charged for the
        /// request.</p>
        pub fn request_charged(mut self, input: crate::model::RequestCharged) -> Self {
            self.request_charged = Some(input);
            self
        }
        /// <p>If present, indicates that the requester was successfully charged for the
        /// request.</p>
        pub fn set_request_charged(
            mut self,
            input: std::option::Option<crate::model::RequestCharged>,
        ) -> Self {
            self.request_charged = input;
            self
        }
        /// Consumes the builder and constructs a [`CompleteMultipartUploadOutput`](crate::output::CompleteMultipartUploadOutput)
        pub fn build(self) -> crate::output::CompleteMultipartUploadOutput {
            crate::output::CompleteMultipartUploadOutput {
                location: self.location,
                bucket: self.bucket,
                key: self.key,
                expiration: self.expiration,
                e_tag: self.e_tag,
                server_side_encryption: self.server_side_encryption,
                version_id: self.version_id,
                ssekms_key_id: self.ssekms_key_id,
                bucket_key_enabled: self.bucket_key_enabled.unwrap_or_default(),
                request_charged: self.request_charged,
            }
        }
    }
}
impl CompleteMultipartUploadOutput {
    /// Creates a new builder-style object to manufacture [`CompleteMultipartUploadOutput`](crate::output::CompleteMultipartUploadOutput)
    pub fn builder() -> crate::output::complete_multipart_upload_output::Builder {
        crate::output::complete_multipart_upload_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AbortMultipartUploadOutput {
    /// <p>If present, indicates that the requester was successfully charged for the
    /// request.</p>
    pub request_charged: std::option::Option<crate::model::RequestCharged>,
}
impl AbortMultipartUploadOutput {
    /// <p>If present, indicates that the requester was successfully charged for the
    /// request.</p>
    pub fn request_charged(&self) -> std::option::Option<&crate::model::RequestCharged> {
        self.request_charged.as_ref()
    }
}
impl std::fmt::Debug for AbortMultipartUploadOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AbortMultipartUploadOutput");
        formatter.field("request_charged", &self.request_charged);
        formatter.finish()
    }
}
/// See [`AbortMultipartUploadOutput`](crate::output::AbortMultipartUploadOutput)
pub mod abort_multipart_upload_output {
    /// A builder for [`AbortMultipartUploadOutput`](crate::output::AbortMultipartUploadOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_charged: std::option::Option<crate::model::RequestCharged>,
    }
    impl Builder {
        /// <p>If present, indicates that the requester was successfully charged for the
        /// request.</p>
        pub fn request_charged(mut self, input: crate::model::RequestCharged) -> Self {
            self.request_charged = Some(input);
            self
        }
        /// <p>If present, indicates that the requester was successfully charged for the
        /// request.</p>
        pub fn set_request_charged(
            mut self,
            input: std::option::Option<crate::model::RequestCharged>,
        ) -> Self {
            self.request_charged = input;
            self
        }
        /// Consumes the builder and constructs a [`AbortMultipartUploadOutput`](crate::output::AbortMultipartUploadOutput)
        pub fn build(self) -> crate::output::AbortMultipartUploadOutput {
            crate::output::AbortMultipartUploadOutput {
                request_charged: self.request_charged,
            }
        }
    }
}
impl AbortMultipartUploadOutput {
    /// Creates a new builder-style object to manufacture [`AbortMultipartUploadOutput`](crate::output::AbortMultipartUploadOutput)
    pub fn builder() -> crate::output::abort_multipart_upload_output::Builder {
        crate::output::abort_multipart_upload_output::Builder::default()
    }
}
