// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_abort_multipart_upload_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AbortMultipartUploadOutput,
    crate::error::AbortMultipartUploadError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::AbortMultipartUploadError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AbortMultipartUploadError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchUpload" => crate::error::AbortMultipartUploadError {
            meta: generic,
            kind: crate::error::AbortMultipartUploadErrorKind::NoSuchUpload({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_upload::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_upload_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::AbortMultipartUploadError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AbortMultipartUploadError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_abort_multipart_upload_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AbortMultipartUploadOutput,
    crate::error::AbortMultipartUploadError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::abort_multipart_upload_output::Builder::default();
        let _ = response;
        output = output.set_request_charged(
            crate::http_serde::deser_header_abort_multipart_upload_abort_multipart_upload_output_request_charged(response.headers())
                                        .map_err(|_|crate::error::AbortMultipartUploadError::unhandled("Failed to parse RequestCharged from header `x-amz-request-charged"))?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_complete_multipart_upload_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CompleteMultipartUploadOutput,
    crate::error::CompleteMultipartUploadError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CompleteMultipartUploadError::unhandled)?;
    Err(crate::error::CompleteMultipartUploadError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_complete_multipart_upload_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CompleteMultipartUploadOutput,
    crate::error::CompleteMultipartUploadError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::complete_multipart_upload_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_complete_multipart_upload(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CompleteMultipartUploadError::unhandled)?;
        output = output.set_bucket_key_enabled(
            crate::http_serde::deser_header_complete_multipart_upload_complete_multipart_upload_output_bucket_key_enabled(response.headers())
                                        .map_err(|_|crate::error::CompleteMultipartUploadError::unhandled("Failed to parse BucketKeyEnabled from header `x-amz-server-side-encryption-bucket-key-enabled"))?
        );
        output = output.set_expiration(
            crate::http_serde::deser_header_complete_multipart_upload_complete_multipart_upload_output_expiration(response.headers())
                                        .map_err(|_|crate::error::CompleteMultipartUploadError::unhandled("Failed to parse Expiration from header `x-amz-expiration"))?
        );
        output = output.set_request_charged(
            crate::http_serde::deser_header_complete_multipart_upload_complete_multipart_upload_output_request_charged(response.headers())
                                        .map_err(|_|crate::error::CompleteMultipartUploadError::unhandled("Failed to parse RequestCharged from header `x-amz-request-charged"))?
        );
        output = output.set_ssekms_key_id(
            crate::http_serde::deser_header_complete_multipart_upload_complete_multipart_upload_output_ssekms_key_id(response.headers())
                                        .map_err(|_|crate::error::CompleteMultipartUploadError::unhandled("Failed to parse SSEKMSKeyId from header `x-amz-server-side-encryption-aws-kms-key-id"))?
        );
        output = output.set_server_side_encryption(
            crate::http_serde::deser_header_complete_multipart_upload_complete_multipart_upload_output_server_side_encryption(response.headers())
                                        .map_err(|_|crate::error::CompleteMultipartUploadError::unhandled("Failed to parse ServerSideEncryption from header `x-amz-server-side-encryption"))?
        );
        output = output.set_version_id(
            crate::http_serde::deser_header_complete_multipart_upload_complete_multipart_upload_output_version_id(response.headers())
                                        .map_err(|_|crate::error::CompleteMultipartUploadError::unhandled("Failed to parse VersionId from header `x-amz-version-id"))?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_copy_object_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CopyObjectOutput, crate::error::CopyObjectError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CopyObjectError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CopyObjectError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ObjectNotInActiveTierError" => crate::error::CopyObjectError {
            meta: generic,
            kind: crate::error::CopyObjectErrorKind::ObjectNotInActiveTierError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::object_not_in_active_tier_error::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_object_not_in_active_tier_error_xml_err(response.body().as_ref(), output).map_err(crate::error::CopyObjectError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CopyObjectError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_copy_object_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CopyObjectOutput, crate::error::CopyObjectError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::copy_object_output::Builder::default();
        let _ = response;
        output = output.set_bucket_key_enabled(
            crate::http_serde::deser_header_copy_object_copy_object_output_bucket_key_enabled(response.headers())
                                        .map_err(|_|crate::error::CopyObjectError::unhandled("Failed to parse BucketKeyEnabled from header `x-amz-server-side-encryption-bucket-key-enabled"))?
        );
        output = output.set_copy_object_result(
            crate::http_serde::deser_payload_copy_object_copy_object_output_copy_object_result(
                response.body().as_ref(),
            )?,
        );
        output = output.set_copy_source_version_id(
            crate::http_serde::deser_header_copy_object_copy_object_output_copy_source_version_id(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::CopyObjectError::unhandled(
                    "Failed to parse CopySourceVersionId from header `x-amz-copy-source-version-id",
                )
            })?,
        );
        output = output.set_expiration(
            crate::http_serde::deser_header_copy_object_copy_object_output_expiration(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::CopyObjectError::unhandled(
                    "Failed to parse Expiration from header `x-amz-expiration",
                )
            })?,
        );
        output = output.set_request_charged(
            crate::http_serde::deser_header_copy_object_copy_object_output_request_charged(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::CopyObjectError::unhandled(
                    "Failed to parse RequestCharged from header `x-amz-request-charged",
                )
            })?,
        );
        output = output.set_sse_customer_algorithm(
            crate::http_serde::deser_header_copy_object_copy_object_output_sse_customer_algorithm(response.headers())
                                        .map_err(|_|crate::error::CopyObjectError::unhandled("Failed to parse SSECustomerAlgorithm from header `x-amz-server-side-encryption-customer-algorithm"))?
        );
        output = output.set_sse_customer_key_md5(
            crate::http_serde::deser_header_copy_object_copy_object_output_sse_customer_key_md5(response.headers())
                                        .map_err(|_|crate::error::CopyObjectError::unhandled("Failed to parse SSECustomerKeyMD5 from header `x-amz-server-side-encryption-customer-key-MD5"))?
        );
        output = output.set_ssekms_encryption_context(
            crate::http_serde::deser_header_copy_object_copy_object_output_ssekms_encryption_context(response.headers())
                                        .map_err(|_|crate::error::CopyObjectError::unhandled("Failed to parse SSEKMSEncryptionContext from header `x-amz-server-side-encryption-context"))?
        );
        output = output.set_ssekms_key_id(
            crate::http_serde::deser_header_copy_object_copy_object_output_ssekms_key_id(response.headers())
                                        .map_err(|_|crate::error::CopyObjectError::unhandled("Failed to parse SSEKMSKeyId from header `x-amz-server-side-encryption-aws-kms-key-id"))?
        );
        output = output.set_server_side_encryption(
            crate::http_serde::deser_header_copy_object_copy_object_output_server_side_encryption(response.headers())
                                        .map_err(|_|crate::error::CopyObjectError::unhandled("Failed to parse ServerSideEncryption from header `x-amz-server-side-encryption"))?
        );
        output = output.set_version_id(
            crate::http_serde::deser_header_copy_object_copy_object_output_version_id(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::CopyObjectError::unhandled(
                    "Failed to parse VersionId from header `x-amz-version-id",
                )
            })?,
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_bucket_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateBucketOutput, crate::error::CreateBucketError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateBucketError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateBucketError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BucketAlreadyExists" => crate::error::CreateBucketError {
            meta: generic,
            kind: crate::error::CreateBucketErrorKind::BucketAlreadyExists({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bucket_already_exists::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_bucket_already_exists_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateBucketError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "BucketAlreadyOwnedByYou" => crate::error::CreateBucketError {
            meta: generic,
            kind: crate::error::CreateBucketErrorKind::BucketAlreadyOwnedByYou({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bucket_already_owned_by_you::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_bucket_already_owned_by_you_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateBucketError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateBucketError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_bucket_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateBucketOutput, crate::error::CreateBucketError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_bucket_output::Builder::default();
        let _ = response;
        output = output.set_location(
            crate::http_serde::deser_header_create_bucket_create_bucket_output_location(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::CreateBucketError::unhandled(
                    "Failed to parse Location from header `Location",
                )
            })?,
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_multipart_upload_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateMultipartUploadOutput,
    crate::error::CreateMultipartUploadError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateMultipartUploadError::unhandled)?;
    Err(crate::error::CreateMultipartUploadError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_multipart_upload_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateMultipartUploadOutput,
    crate::error::CreateMultipartUploadError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_multipart_upload_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_multipart_upload(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateMultipartUploadError::unhandled)?;
        output = output.set_abort_date(
            crate::http_serde::deser_header_create_multipart_upload_create_multipart_upload_output_abort_date(response.headers())
                                        .map_err(|_|crate::error::CreateMultipartUploadError::unhandled("Failed to parse AbortDate from header `x-amz-abort-date"))?
        );
        output = output.set_abort_rule_id(
            crate::http_serde::deser_header_create_multipart_upload_create_multipart_upload_output_abort_rule_id(response.headers())
                                        .map_err(|_|crate::error::CreateMultipartUploadError::unhandled("Failed to parse AbortRuleId from header `x-amz-abort-rule-id"))?
        );
        output = output.set_bucket_key_enabled(
            crate::http_serde::deser_header_create_multipart_upload_create_multipart_upload_output_bucket_key_enabled(response.headers())
                                        .map_err(|_|crate::error::CreateMultipartUploadError::unhandled("Failed to parse BucketKeyEnabled from header `x-amz-server-side-encryption-bucket-key-enabled"))?
        );
        output = output.set_request_charged(
            crate::http_serde::deser_header_create_multipart_upload_create_multipart_upload_output_request_charged(response.headers())
                                        .map_err(|_|crate::error::CreateMultipartUploadError::unhandled("Failed to parse RequestCharged from header `x-amz-request-charged"))?
        );
        output = output.set_sse_customer_algorithm(
            crate::http_serde::deser_header_create_multipart_upload_create_multipart_upload_output_sse_customer_algorithm(response.headers())
                                        .map_err(|_|crate::error::CreateMultipartUploadError::unhandled("Failed to parse SSECustomerAlgorithm from header `x-amz-server-side-encryption-customer-algorithm"))?
        );
        output = output.set_sse_customer_key_md5(
            crate::http_serde::deser_header_create_multipart_upload_create_multipart_upload_output_sse_customer_key_md5(response.headers())
                                        .map_err(|_|crate::error::CreateMultipartUploadError::unhandled("Failed to parse SSECustomerKeyMD5 from header `x-amz-server-side-encryption-customer-key-MD5"))?
        );
        output = output.set_ssekms_encryption_context(
            crate::http_serde::deser_header_create_multipart_upload_create_multipart_upload_output_ssekms_encryption_context(response.headers())
                                        .map_err(|_|crate::error::CreateMultipartUploadError::unhandled("Failed to parse SSEKMSEncryptionContext from header `x-amz-server-side-encryption-context"))?
        );
        output = output.set_ssekms_key_id(
            crate::http_serde::deser_header_create_multipart_upload_create_multipart_upload_output_ssekms_key_id(response.headers())
                                        .map_err(|_|crate::error::CreateMultipartUploadError::unhandled("Failed to parse SSEKMSKeyId from header `x-amz-server-side-encryption-aws-kms-key-id"))?
        );
        output = output.set_server_side_encryption(
            crate::http_serde::deser_header_create_multipart_upload_create_multipart_upload_output_server_side_encryption(response.headers())
                                        .map_err(|_|crate::error::CreateMultipartUploadError::unhandled("Failed to parse ServerSideEncryption from header `x-amz-server-side-encryption"))?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_bucket_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteBucketOutput, crate::error::DeleteBucketError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteBucketError::unhandled)?;
    Err(crate::error::DeleteBucketError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_bucket_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteBucketOutput, crate::error::DeleteBucketError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_bucket_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_bucket_analytics_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteBucketAnalyticsConfigurationOutput,
    crate::error::DeleteBucketAnalyticsConfigurationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteBucketAnalyticsConfigurationError::unhandled)?;
    Err(crate::error::DeleteBucketAnalyticsConfigurationError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_bucket_analytics_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteBucketAnalyticsConfigurationOutput,
    crate::error::DeleteBucketAnalyticsConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::delete_bucket_analytics_configuration_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_bucket_cors_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteBucketCorsOutput, crate::error::DeleteBucketCorsError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteBucketCorsError::unhandled)?;
    Err(crate::error::DeleteBucketCorsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_bucket_cors_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteBucketCorsOutput, crate::error::DeleteBucketCorsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_bucket_cors_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_bucket_encryption_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteBucketEncryptionOutput,
    crate::error::DeleteBucketEncryptionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteBucketEncryptionError::unhandled)?;
    Err(crate::error::DeleteBucketEncryptionError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_bucket_encryption_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteBucketEncryptionOutput,
    crate::error::DeleteBucketEncryptionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_bucket_encryption_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_bucket_intelligent_tiering_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteBucketIntelligentTieringConfigurationOutput,
    crate::error::DeleteBucketIntelligentTieringConfigurationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteBucketIntelligentTieringConfigurationError::unhandled)?;
    Err(crate::error::DeleteBucketIntelligentTieringConfigurationError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_bucket_intelligent_tiering_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteBucketIntelligentTieringConfigurationOutput,
    crate::error::DeleteBucketIntelligentTieringConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::delete_bucket_intelligent_tiering_configuration_output::Builder::default(
            );
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_bucket_inventory_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteBucketInventoryConfigurationOutput,
    crate::error::DeleteBucketInventoryConfigurationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteBucketInventoryConfigurationError::unhandled)?;
    Err(crate::error::DeleteBucketInventoryConfigurationError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_bucket_inventory_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteBucketInventoryConfigurationOutput,
    crate::error::DeleteBucketInventoryConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::delete_bucket_inventory_configuration_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_bucket_lifecycle_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteBucketLifecycleOutput,
    crate::error::DeleteBucketLifecycleError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteBucketLifecycleError::unhandled)?;
    Err(crate::error::DeleteBucketLifecycleError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_bucket_lifecycle_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteBucketLifecycleOutput,
    crate::error::DeleteBucketLifecycleError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_bucket_lifecycle_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_bucket_metrics_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteBucketMetricsConfigurationOutput,
    crate::error::DeleteBucketMetricsConfigurationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteBucketMetricsConfigurationError::unhandled)?;
    Err(crate::error::DeleteBucketMetricsConfigurationError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_bucket_metrics_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteBucketMetricsConfigurationOutput,
    crate::error::DeleteBucketMetricsConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::delete_bucket_metrics_configuration_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_bucket_ownership_controls_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteBucketOwnershipControlsOutput,
    crate::error::DeleteBucketOwnershipControlsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteBucketOwnershipControlsError::unhandled)?;
    Err(crate::error::DeleteBucketOwnershipControlsError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_bucket_ownership_controls_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteBucketOwnershipControlsOutput,
    crate::error::DeleteBucketOwnershipControlsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_bucket_ownership_controls_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_bucket_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteBucketPolicyOutput,
    crate::error::DeleteBucketPolicyError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteBucketPolicyError::unhandled)?;
    Err(crate::error::DeleteBucketPolicyError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_bucket_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteBucketPolicyOutput,
    crate::error::DeleteBucketPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_bucket_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_bucket_replication_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteBucketReplicationOutput,
    crate::error::DeleteBucketReplicationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteBucketReplicationError::unhandled)?;
    Err(crate::error::DeleteBucketReplicationError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_bucket_replication_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteBucketReplicationOutput,
    crate::error::DeleteBucketReplicationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_bucket_replication_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_bucket_tagging_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteBucketTaggingOutput,
    crate::error::DeleteBucketTaggingError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteBucketTaggingError::unhandled)?;
    Err(crate::error::DeleteBucketTaggingError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_bucket_tagging_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteBucketTaggingOutput,
    crate::error::DeleteBucketTaggingError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_bucket_tagging_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_bucket_website_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteBucketWebsiteOutput,
    crate::error::DeleteBucketWebsiteError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteBucketWebsiteError::unhandled)?;
    Err(crate::error::DeleteBucketWebsiteError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_bucket_website_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteBucketWebsiteOutput,
    crate::error::DeleteBucketWebsiteError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_bucket_website_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_object_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteObjectOutput, crate::error::DeleteObjectError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteObjectError::unhandled)?;
    Err(crate::error::DeleteObjectError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_object_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteObjectOutput, crate::error::DeleteObjectError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_object_output::Builder::default();
        let _ = response;
        output = output.set_delete_marker(
            crate::http_serde::deser_header_delete_object_delete_object_output_delete_marker(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::DeleteObjectError::unhandled(
                    "Failed to parse DeleteMarker from header `x-amz-delete-marker",
                )
            })?,
        );
        output = output.set_request_charged(
            crate::http_serde::deser_header_delete_object_delete_object_output_request_charged(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::DeleteObjectError::unhandled(
                    "Failed to parse RequestCharged from header `x-amz-request-charged",
                )
            })?,
        );
        output = output.set_version_id(
            crate::http_serde::deser_header_delete_object_delete_object_output_version_id(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::DeleteObjectError::unhandled(
                    "Failed to parse VersionId from header `x-amz-version-id",
                )
            })?,
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_objects_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteObjectsOutput, crate::error::DeleteObjectsError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteObjectsError::unhandled)?;
    Err(crate::error::DeleteObjectsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_objects_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteObjectsOutput, crate::error::DeleteObjectsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_objects_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_delete_objects(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteObjectsError::unhandled)?;
        output = output.set_request_charged(
            crate::http_serde::deser_header_delete_objects_delete_objects_output_request_charged(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::DeleteObjectsError::unhandled(
                    "Failed to parse RequestCharged from header `x-amz-request-charged",
                )
            })?,
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_object_tagging_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteObjectTaggingOutput,
    crate::error::DeleteObjectTaggingError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteObjectTaggingError::unhandled)?;
    Err(crate::error::DeleteObjectTaggingError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_object_tagging_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteObjectTaggingOutput,
    crate::error::DeleteObjectTaggingError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_object_tagging_output::Builder::default();
        let _ = response;
        output = output.set_version_id(
            crate::http_serde::deser_header_delete_object_tagging_delete_object_tagging_output_version_id(response.headers())
                                        .map_err(|_|crate::error::DeleteObjectTaggingError::unhandled("Failed to parse VersionId from header `x-amz-version-id"))?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_public_access_block_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeletePublicAccessBlockOutput,
    crate::error::DeletePublicAccessBlockError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeletePublicAccessBlockError::unhandled)?;
    Err(crate::error::DeletePublicAccessBlockError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_public_access_block_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeletePublicAccessBlockOutput,
    crate::error::DeletePublicAccessBlockError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_public_access_block_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_accelerate_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetBucketAccelerateConfigurationOutput,
    crate::error::GetBucketAccelerateConfigurationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetBucketAccelerateConfigurationError::unhandled)?;
    Err(crate::error::GetBucketAccelerateConfigurationError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_accelerate_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetBucketAccelerateConfigurationOutput,
    crate::error::GetBucketAccelerateConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_bucket_accelerate_configuration_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_get_bucket_accelerate_configuration(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::GetBucketAccelerateConfigurationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_acl_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetBucketAclOutput, crate::error::GetBucketAclError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetBucketAclError::unhandled)?;
    Err(crate::error::GetBucketAclError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_acl_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetBucketAclOutput, crate::error::GetBucketAclError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_bucket_acl_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_bucket_acl(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetBucketAclError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_analytics_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetBucketAnalyticsConfigurationOutput,
    crate::error::GetBucketAnalyticsConfigurationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetBucketAnalyticsConfigurationError::unhandled)?;
    Err(crate::error::GetBucketAnalyticsConfigurationError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_analytics_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetBucketAnalyticsConfigurationOutput,
    crate::error::GetBucketAnalyticsConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_bucket_analytics_configuration_output::Builder::default();
        let _ = response;
        output = output.set_analytics_configuration(
            crate::http_serde::deser_payload_get_bucket_analytics_configuration_get_bucket_analytics_configuration_output_analytics_configuration(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_cors_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetBucketCorsOutput, crate::error::GetBucketCorsError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetBucketCorsError::unhandled)?;
    Err(crate::error::GetBucketCorsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_cors_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetBucketCorsOutput, crate::error::GetBucketCorsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_bucket_cors_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_bucket_cors(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetBucketCorsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_encryption_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetBucketEncryptionOutput,
    crate::error::GetBucketEncryptionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetBucketEncryptionError::unhandled)?;
    Err(crate::error::GetBucketEncryptionError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_encryption_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetBucketEncryptionOutput,
    crate::error::GetBucketEncryptionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_bucket_encryption_output::Builder::default();
        let _ = response;
        output = output.set_server_side_encryption_configuration(
            crate::http_serde::deser_payload_get_bucket_encryption_get_bucket_encryption_output_server_side_encryption_configuration(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_intelligent_tiering_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetBucketIntelligentTieringConfigurationOutput,
    crate::error::GetBucketIntelligentTieringConfigurationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetBucketIntelligentTieringConfigurationError::unhandled)?;
    Err(crate::error::GetBucketIntelligentTieringConfigurationError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_intelligent_tiering_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetBucketIntelligentTieringConfigurationOutput,
    crate::error::GetBucketIntelligentTieringConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_bucket_intelligent_tiering_configuration_output::Builder::default();
        let _ = response;
        output = output.set_intelligent_tiering_configuration(
            crate::http_serde::deser_payload_get_bucket_intelligent_tiering_configuration_get_bucket_intelligent_tiering_configuration_output_intelligent_tiering_configuration(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_inventory_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetBucketInventoryConfigurationOutput,
    crate::error::GetBucketInventoryConfigurationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetBucketInventoryConfigurationError::unhandled)?;
    Err(crate::error::GetBucketInventoryConfigurationError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_inventory_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetBucketInventoryConfigurationOutput,
    crate::error::GetBucketInventoryConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_bucket_inventory_configuration_output::Builder::default();
        let _ = response;
        output = output.set_inventory_configuration(
            crate::http_serde::deser_payload_get_bucket_inventory_configuration_get_bucket_inventory_configuration_output_inventory_configuration(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_lifecycle_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetBucketLifecycleConfigurationOutput,
    crate::error::GetBucketLifecycleConfigurationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetBucketLifecycleConfigurationError::unhandled)?;
    Err(crate::error::GetBucketLifecycleConfigurationError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_lifecycle_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetBucketLifecycleConfigurationOutput,
    crate::error::GetBucketLifecycleConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_bucket_lifecycle_configuration_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_get_bucket_lifecycle_configuration(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::GetBucketLifecycleConfigurationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_location_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetBucketLocationOutput, crate::error::GetBucketLocationError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetBucketLocationError::unhandled)?;
    Err(crate::error::GetBucketLocationError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_location_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetBucketLocationOutput, crate::error::GetBucketLocationError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_bucket_location_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_bucket_location(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetBucketLocationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_logging_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetBucketLoggingOutput, crate::error::GetBucketLoggingError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetBucketLoggingError::unhandled)?;
    Err(crate::error::GetBucketLoggingError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_logging_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetBucketLoggingOutput, crate::error::GetBucketLoggingError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_bucket_logging_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_bucket_logging(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetBucketLoggingError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_metrics_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetBucketMetricsConfigurationOutput,
    crate::error::GetBucketMetricsConfigurationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetBucketMetricsConfigurationError::unhandled)?;
    Err(crate::error::GetBucketMetricsConfigurationError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_metrics_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetBucketMetricsConfigurationOutput,
    crate::error::GetBucketMetricsConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_bucket_metrics_configuration_output::Builder::default();
        let _ = response;
        output = output.set_metrics_configuration(
            crate::http_serde::deser_payload_get_bucket_metrics_configuration_get_bucket_metrics_configuration_output_metrics_configuration(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_notification_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetBucketNotificationConfigurationOutput,
    crate::error::GetBucketNotificationConfigurationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetBucketNotificationConfigurationError::unhandled)?;
    Err(crate::error::GetBucketNotificationConfigurationError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_notification_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetBucketNotificationConfigurationOutput,
    crate::error::GetBucketNotificationConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_bucket_notification_configuration_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_bucket_notification_configuration(response.body().as_ref(), output).map_err(crate::error::GetBucketNotificationConfigurationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_ownership_controls_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetBucketOwnershipControlsOutput,
    crate::error::GetBucketOwnershipControlsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetBucketOwnershipControlsError::unhandled)?;
    Err(crate::error::GetBucketOwnershipControlsError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_ownership_controls_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetBucketOwnershipControlsOutput,
    crate::error::GetBucketOwnershipControlsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_bucket_ownership_controls_output::Builder::default();
        let _ = response;
        output = output.set_ownership_controls(
            crate::http_serde::deser_payload_get_bucket_ownership_controls_get_bucket_ownership_controls_output_ownership_controls(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetBucketPolicyOutput, crate::error::GetBucketPolicyError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetBucketPolicyError::unhandled)?;
    Err(crate::error::GetBucketPolicyError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetBucketPolicyOutput, crate::error::GetBucketPolicyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_bucket_policy_output::Builder::default();
        let _ = response;
        output = output.set_policy(
            crate::http_serde::deser_payload_get_bucket_policy_get_bucket_policy_output_policy(
                response.body().as_ref(),
            )?,
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_policy_status_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetBucketPolicyStatusOutput,
    crate::error::GetBucketPolicyStatusError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetBucketPolicyStatusError::unhandled)?;
    Err(crate::error::GetBucketPolicyStatusError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_policy_status_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetBucketPolicyStatusOutput,
    crate::error::GetBucketPolicyStatusError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_bucket_policy_status_output::Builder::default();
        let _ = response;
        output = output.set_policy_status(
            crate::http_serde::deser_payload_get_bucket_policy_status_get_bucket_policy_status_output_policy_status(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_replication_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetBucketReplicationOutput,
    crate::error::GetBucketReplicationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetBucketReplicationError::unhandled)?;
    Err(crate::error::GetBucketReplicationError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_replication_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetBucketReplicationOutput,
    crate::error::GetBucketReplicationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_bucket_replication_output::Builder::default();
        let _ = response;
        output = output.set_replication_configuration(
            crate::http_serde::deser_payload_get_bucket_replication_get_bucket_replication_output_replication_configuration(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_request_payment_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetBucketRequestPaymentOutput,
    crate::error::GetBucketRequestPaymentError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetBucketRequestPaymentError::unhandled)?;
    Err(crate::error::GetBucketRequestPaymentError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_request_payment_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetBucketRequestPaymentOutput,
    crate::error::GetBucketRequestPaymentError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_bucket_request_payment_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_bucket_request_payment(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetBucketRequestPaymentError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_tagging_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetBucketTaggingOutput, crate::error::GetBucketTaggingError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetBucketTaggingError::unhandled)?;
    Err(crate::error::GetBucketTaggingError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_tagging_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetBucketTaggingOutput, crate::error::GetBucketTaggingError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_bucket_tagging_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_bucket_tagging(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetBucketTaggingError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_versioning_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetBucketVersioningOutput,
    crate::error::GetBucketVersioningError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetBucketVersioningError::unhandled)?;
    Err(crate::error::GetBucketVersioningError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_versioning_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetBucketVersioningOutput,
    crate::error::GetBucketVersioningError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_bucket_versioning_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_bucket_versioning(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetBucketVersioningError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_website_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetBucketWebsiteOutput, crate::error::GetBucketWebsiteError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetBucketWebsiteError::unhandled)?;
    Err(crate::error::GetBucketWebsiteError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_website_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetBucketWebsiteOutput, crate::error::GetBucketWebsiteError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_bucket_website_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_bucket_website(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetBucketWebsiteError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_object(
    op_response: &mut aws_smithy_http::operation::Response,
) -> std::result::Result<crate::output::GetObjectOutput, crate::error::GetObjectError> {
    let response = op_response.http_mut();
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_object_output::Builder::default();
        let _ = response;
        output = output.set_accept_ranges(
            crate::http_serde::deser_header_get_object_get_object_output_accept_ranges(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::GetObjectError::unhandled(
                    "Failed to parse AcceptRanges from header `accept-ranges",
                )
            })?,
        );
        output = output.set_body(Some(
            crate::http_serde::deser_payload_get_object_get_object_output_body(
                response.body_mut(),
            )?,
        ));
        output = output.set_bucket_key_enabled(
            crate::http_serde::deser_header_get_object_get_object_output_bucket_key_enabled(response.headers())
                                        .map_err(|_|crate::error::GetObjectError::unhandled("Failed to parse BucketKeyEnabled from header `x-amz-server-side-encryption-bucket-key-enabled"))?
        );
        output = output.set_cache_control(
            crate::http_serde::deser_header_get_object_get_object_output_cache_control(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::GetObjectError::unhandled(
                    "Failed to parse CacheControl from header `Cache-Control",
                )
            })?,
        );
        output = output.set_content_disposition(
            crate::http_serde::deser_header_get_object_get_object_output_content_disposition(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::GetObjectError::unhandled(
                    "Failed to parse ContentDisposition from header `Content-Disposition",
                )
            })?,
        );
        output = output.set_content_encoding(
            crate::http_serde::deser_header_get_object_get_object_output_content_encoding(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::GetObjectError::unhandled(
                    "Failed to parse ContentEncoding from header `Content-Encoding",
                )
            })?,
        );
        output = output.set_content_language(
            crate::http_serde::deser_header_get_object_get_object_output_content_language(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::GetObjectError::unhandled(
                    "Failed to parse ContentLanguage from header `Content-Language",
                )
            })?,
        );
        output = output.set_content_length(
            crate::http_serde::deser_header_get_object_get_object_output_content_length(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::GetObjectError::unhandled(
                    "Failed to parse ContentLength from header `Content-Length",
                )
            })?,
        );
        output = output.set_content_range(
            crate::http_serde::deser_header_get_object_get_object_output_content_range(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::GetObjectError::unhandled(
                    "Failed to parse ContentRange from header `Content-Range",
                )
            })?,
        );
        output = output.set_content_type(
            crate::http_serde::deser_header_get_object_get_object_output_content_type(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::GetObjectError::unhandled(
                    "Failed to parse ContentType from header `Content-Type",
                )
            })?,
        );
        output = output.set_delete_marker(
            crate::http_serde::deser_header_get_object_get_object_output_delete_marker(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::GetObjectError::unhandled(
                    "Failed to parse DeleteMarker from header `x-amz-delete-marker",
                )
            })?,
        );
        output = output.set_e_tag(
            crate::http_serde::deser_header_get_object_get_object_output_e_tag(response.headers())
                .map_err(|_| {
                    crate::error::GetObjectError::unhandled(
                        "Failed to parse ETag from header `ETag",
                    )
                })?,
        );
        output = output.set_expiration(
            crate::http_serde::deser_header_get_object_get_object_output_expiration(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::GetObjectError::unhandled(
                    "Failed to parse Expiration from header `x-amz-expiration",
                )
            })?,
        );
        output = output.set_expires(
            crate::http_serde::deser_header_get_object_get_object_output_expires(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::GetObjectError::unhandled(
                    "Failed to parse Expires from header `Expires",
                )
            })?,
        );
        output = output.set_last_modified(
            crate::http_serde::deser_header_get_object_get_object_output_last_modified(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::GetObjectError::unhandled(
                    "Failed to parse LastModified from header `Last-Modified",
                )
            })?,
        );
        output = output.set_metadata(
            crate::http_serde::deser_prefix_header_get_object_get_object_output_metadata(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::GetObjectError::unhandled(
                    "Failed to parse Metadata from prefix header `x-amz-meta-",
                )
            })?,
        );
        output = output.set_missing_meta(
            crate::http_serde::deser_header_get_object_get_object_output_missing_meta(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::GetObjectError::unhandled(
                    "Failed to parse MissingMeta from header `x-amz-missing-meta",
                )
            })?,
        );
        output = output.set_object_lock_legal_hold_status(
            crate::http_serde::deser_header_get_object_get_object_output_object_lock_legal_hold_status(response.headers())
                                        .map_err(|_|crate::error::GetObjectError::unhandled("Failed to parse ObjectLockLegalHoldStatus from header `x-amz-object-lock-legal-hold"))?
        );
        output = output.set_object_lock_mode(
            crate::http_serde::deser_header_get_object_get_object_output_object_lock_mode(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::GetObjectError::unhandled(
                    "Failed to parse ObjectLockMode from header `x-amz-object-lock-mode",
                )
            })?,
        );
        output = output.set_object_lock_retain_until_date(
            crate::http_serde::deser_header_get_object_get_object_output_object_lock_retain_until_date(response.headers())
                                        .map_err(|_|crate::error::GetObjectError::unhandled("Failed to parse ObjectLockRetainUntilDate from header `x-amz-object-lock-retain-until-date"))?
        );
        output = output.set_parts_count(
            crate::http_serde::deser_header_get_object_get_object_output_parts_count(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::GetObjectError::unhandled(
                    "Failed to parse PartsCount from header `x-amz-mp-parts-count",
                )
            })?,
        );
        output = output.set_replication_status(
            crate::http_serde::deser_header_get_object_get_object_output_replication_status(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::GetObjectError::unhandled(
                    "Failed to parse ReplicationStatus from header `x-amz-replication-status",
                )
            })?,
        );
        output = output.set_request_charged(
            crate::http_serde::deser_header_get_object_get_object_output_request_charged(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::GetObjectError::unhandled(
                    "Failed to parse RequestCharged from header `x-amz-request-charged",
                )
            })?,
        );
        output = output.set_restore(
            crate::http_serde::deser_header_get_object_get_object_output_restore(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::GetObjectError::unhandled(
                    "Failed to parse Restore from header `x-amz-restore",
                )
            })?,
        );
        output = output.set_sse_customer_algorithm(
            crate::http_serde::deser_header_get_object_get_object_output_sse_customer_algorithm(response.headers())
                                        .map_err(|_|crate::error::GetObjectError::unhandled("Failed to parse SSECustomerAlgorithm from header `x-amz-server-side-encryption-customer-algorithm"))?
        );
        output = output.set_sse_customer_key_md5(
            crate::http_serde::deser_header_get_object_get_object_output_sse_customer_key_md5(response.headers())
                                        .map_err(|_|crate::error::GetObjectError::unhandled("Failed to parse SSECustomerKeyMD5 from header `x-amz-server-side-encryption-customer-key-MD5"))?
        );
        output = output.set_ssekms_key_id(
            crate::http_serde::deser_header_get_object_get_object_output_ssekms_key_id(response.headers())
                                        .map_err(|_|crate::error::GetObjectError::unhandled("Failed to parse SSEKMSKeyId from header `x-amz-server-side-encryption-aws-kms-key-id"))?
        );
        output = output.set_server_side_encryption(
            crate::http_serde::deser_header_get_object_get_object_output_server_side_encryption(response.headers())
                                        .map_err(|_|crate::error::GetObjectError::unhandled("Failed to parse ServerSideEncryption from header `x-amz-server-side-encryption"))?
        );
        output = output.set_storage_class(
            crate::http_serde::deser_header_get_object_get_object_output_storage_class(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::GetObjectError::unhandled(
                    "Failed to parse StorageClass from header `x-amz-storage-class",
                )
            })?,
        );
        output = output.set_tag_count(
            crate::http_serde::deser_header_get_object_get_object_output_tag_count(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::GetObjectError::unhandled(
                    "Failed to parse TagCount from header `x-amz-tagging-count",
                )
            })?,
        );
        output = output.set_version_id(
            crate::http_serde::deser_header_get_object_get_object_output_version_id(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::GetObjectError::unhandled(
                    "Failed to parse VersionId from header `x-amz-version-id",
                )
            })?,
        );
        output = output.set_website_redirect_location(
            crate::http_serde::deser_header_get_object_get_object_output_website_redirect_location(response.headers())
                                        .map_err(|_|crate::error::GetObjectError::unhandled("Failed to parse WebsiteRedirectLocation from header `x-amz-website-redirect-location"))?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_object_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetObjectOutput, crate::error::GetObjectError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetObjectError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetObjectError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidObjectState" => {
            crate::error::GetObjectError {
                meta: generic,
                kind: crate::error::GetObjectErrorKind::InvalidObjectState({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_object_state::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_object_state_xml_err(response.body().as_ref(), output).map_err(crate::error::GetObjectError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "NoSuchKey" => crate::error::GetObjectError {
            meta: generic,
            kind: crate::error::GetObjectErrorKind::NoSuchKey({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_key::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_key_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::GetObjectError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetObjectError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_object_acl_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetObjectAclOutput, crate::error::GetObjectAclError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetObjectAclError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetObjectAclError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchKey" => crate::error::GetObjectAclError {
            meta: generic,
            kind: crate::error::GetObjectAclErrorKind::NoSuchKey({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_key::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_key_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::GetObjectAclError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetObjectAclError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_object_acl_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetObjectAclOutput, crate::error::GetObjectAclError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_object_acl_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_object_acl(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetObjectAclError::unhandled)?;
        output = output.set_request_charged(
            crate::http_serde::deser_header_get_object_acl_get_object_acl_output_request_charged(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::GetObjectAclError::unhandled(
                    "Failed to parse RequestCharged from header `x-amz-request-charged",
                )
            })?,
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_object_legal_hold_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetObjectLegalHoldOutput,
    crate::error::GetObjectLegalHoldError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetObjectLegalHoldError::unhandled)?;
    Err(crate::error::GetObjectLegalHoldError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_object_legal_hold_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetObjectLegalHoldOutput,
    crate::error::GetObjectLegalHoldError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_object_legal_hold_output::Builder::default();
        let _ = response;
        output = output.set_legal_hold(
            crate::http_serde::deser_payload_get_object_legal_hold_get_object_legal_hold_output_legal_hold(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_object_lock_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetObjectLockConfigurationOutput,
    crate::error::GetObjectLockConfigurationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetObjectLockConfigurationError::unhandled)?;
    Err(crate::error::GetObjectLockConfigurationError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_object_lock_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetObjectLockConfigurationOutput,
    crate::error::GetObjectLockConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_object_lock_configuration_output::Builder::default();
        let _ = response;
        output = output.set_object_lock_configuration(
            crate::http_serde::deser_payload_get_object_lock_configuration_get_object_lock_configuration_output_object_lock_configuration(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_object_retention_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetObjectRetentionOutput,
    crate::error::GetObjectRetentionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetObjectRetentionError::unhandled)?;
    Err(crate::error::GetObjectRetentionError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_object_retention_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetObjectRetentionOutput,
    crate::error::GetObjectRetentionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_object_retention_output::Builder::default();
        let _ = response;
        output = output.set_retention(
            crate::http_serde::deser_payload_get_object_retention_get_object_retention_output_retention(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_object_tagging_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetObjectTaggingOutput, crate::error::GetObjectTaggingError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetObjectTaggingError::unhandled)?;
    Err(crate::error::GetObjectTaggingError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_object_tagging_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetObjectTaggingOutput, crate::error::GetObjectTaggingError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_object_tagging_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_object_tagging(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetObjectTaggingError::unhandled)?;
        output = output.set_version_id(
            crate::http_serde::deser_header_get_object_tagging_get_object_tagging_output_version_id(response.headers())
                                        .map_err(|_|crate::error::GetObjectTaggingError::unhandled("Failed to parse VersionId from header `x-amz-version-id"))?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_object_torrent(
    op_response: &mut aws_smithy_http::operation::Response,
) -> std::result::Result<crate::output::GetObjectTorrentOutput, crate::error::GetObjectTorrentError>
{
    let response = op_response.http_mut();
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_object_torrent_output::Builder::default();
        let _ = response;
        output = output.set_body(Some(
            crate::http_serde::deser_payload_get_object_torrent_get_object_torrent_output_body(
                response.body_mut(),
            )?,
        ));
        output = output.set_request_charged(
            crate::http_serde::deser_header_get_object_torrent_get_object_torrent_output_request_charged(response.headers())
                                        .map_err(|_|crate::error::GetObjectTorrentError::unhandled("Failed to parse RequestCharged from header `x-amz-request-charged"))?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_object_torrent_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetObjectTorrentOutput, crate::error::GetObjectTorrentError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetObjectTorrentError::unhandled)?;
    Err(crate::error::GetObjectTorrentError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_public_access_block_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetPublicAccessBlockOutput,
    crate::error::GetPublicAccessBlockError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetPublicAccessBlockError::unhandled)?;
    Err(crate::error::GetPublicAccessBlockError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_public_access_block_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetPublicAccessBlockOutput,
    crate::error::GetPublicAccessBlockError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_public_access_block_output::Builder::default();
        let _ = response;
        output = output.set_public_access_block_configuration(
            crate::http_serde::deser_payload_get_public_access_block_get_public_access_block_output_public_access_block_configuration(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_head_bucket_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::HeadBucketOutput, crate::error::HeadBucketError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::HeadBucketError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::HeadBucketError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFound" => crate::error::HeadBucketError {
            meta: generic,
            kind: crate::error::HeadBucketErrorKind::NotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_not_found_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::HeadBucketError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::HeadBucketError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_head_bucket_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::HeadBucketOutput, crate::error::HeadBucketError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::head_bucket_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_head_object_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::HeadObjectOutput, crate::error::HeadObjectError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::HeadObjectError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::HeadObjectError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFound" => crate::error::HeadObjectError {
            meta: generic,
            kind: crate::error::HeadObjectErrorKind::NotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_not_found_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::HeadObjectError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::HeadObjectError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_head_object_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::HeadObjectOutput, crate::error::HeadObjectError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::head_object_output::Builder::default();
        let _ = response;
        output = output.set_accept_ranges(
            crate::http_serde::deser_header_head_object_head_object_output_accept_ranges(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::HeadObjectError::unhandled(
                    "Failed to parse AcceptRanges from header `accept-ranges",
                )
            })?,
        );
        output = output.set_archive_status(
            crate::http_serde::deser_header_head_object_head_object_output_archive_status(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::HeadObjectError::unhandled(
                    "Failed to parse ArchiveStatus from header `x-amz-archive-status",
                )
            })?,
        );
        output = output.set_bucket_key_enabled(
            crate::http_serde::deser_header_head_object_head_object_output_bucket_key_enabled(response.headers())
                                        .map_err(|_|crate::error::HeadObjectError::unhandled("Failed to parse BucketKeyEnabled from header `x-amz-server-side-encryption-bucket-key-enabled"))?
        );
        output = output.set_cache_control(
            crate::http_serde::deser_header_head_object_head_object_output_cache_control(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::HeadObjectError::unhandled(
                    "Failed to parse CacheControl from header `Cache-Control",
                )
            })?,
        );
        output = output.set_content_disposition(
            crate::http_serde::deser_header_head_object_head_object_output_content_disposition(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::HeadObjectError::unhandled(
                    "Failed to parse ContentDisposition from header `Content-Disposition",
                )
            })?,
        );
        output = output.set_content_encoding(
            crate::http_serde::deser_header_head_object_head_object_output_content_encoding(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::HeadObjectError::unhandled(
                    "Failed to parse ContentEncoding from header `Content-Encoding",
                )
            })?,
        );
        output = output.set_content_language(
            crate::http_serde::deser_header_head_object_head_object_output_content_language(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::HeadObjectError::unhandled(
                    "Failed to parse ContentLanguage from header `Content-Language",
                )
            })?,
        );
        output = output.set_content_length(
            crate::http_serde::deser_header_head_object_head_object_output_content_length(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::HeadObjectError::unhandled(
                    "Failed to parse ContentLength from header `Content-Length",
                )
            })?,
        );
        output = output.set_content_type(
            crate::http_serde::deser_header_head_object_head_object_output_content_type(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::HeadObjectError::unhandled(
                    "Failed to parse ContentType from header `Content-Type",
                )
            })?,
        );
        output = output.set_delete_marker(
            crate::http_serde::deser_header_head_object_head_object_output_delete_marker(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::HeadObjectError::unhandled(
                    "Failed to parse DeleteMarker from header `x-amz-delete-marker",
                )
            })?,
        );
        output = output.set_e_tag(
            crate::http_serde::deser_header_head_object_head_object_output_e_tag(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::HeadObjectError::unhandled("Failed to parse ETag from header `ETag")
            })?,
        );
        output = output.set_expiration(
            crate::http_serde::deser_header_head_object_head_object_output_expiration(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::HeadObjectError::unhandled(
                    "Failed to parse Expiration from header `x-amz-expiration",
                )
            })?,
        );
        output = output.set_expires(
            crate::http_serde::deser_header_head_object_head_object_output_expires(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::HeadObjectError::unhandled(
                    "Failed to parse Expires from header `Expires",
                )
            })?,
        );
        output = output.set_last_modified(
            crate::http_serde::deser_header_head_object_head_object_output_last_modified(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::HeadObjectError::unhandled(
                    "Failed to parse LastModified from header `Last-Modified",
                )
            })?,
        );
        output = output.set_metadata(
            crate::http_serde::deser_prefix_header_head_object_head_object_output_metadata(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::HeadObjectError::unhandled(
                    "Failed to parse Metadata from prefix header `x-amz-meta-",
                )
            })?,
        );
        output = output.set_missing_meta(
            crate::http_serde::deser_header_head_object_head_object_output_missing_meta(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::HeadObjectError::unhandled(
                    "Failed to parse MissingMeta from header `x-amz-missing-meta",
                )
            })?,
        );
        output = output.set_object_lock_legal_hold_status(
            crate::http_serde::deser_header_head_object_head_object_output_object_lock_legal_hold_status(response.headers())
                                        .map_err(|_|crate::error::HeadObjectError::unhandled("Failed to parse ObjectLockLegalHoldStatus from header `x-amz-object-lock-legal-hold"))?
        );
        output = output.set_object_lock_mode(
            crate::http_serde::deser_header_head_object_head_object_output_object_lock_mode(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::HeadObjectError::unhandled(
                    "Failed to parse ObjectLockMode from header `x-amz-object-lock-mode",
                )
            })?,
        );
        output = output.set_object_lock_retain_until_date(
            crate::http_serde::deser_header_head_object_head_object_output_object_lock_retain_until_date(response.headers())
                                        .map_err(|_|crate::error::HeadObjectError::unhandled("Failed to parse ObjectLockRetainUntilDate from header `x-amz-object-lock-retain-until-date"))?
        );
        output = output.set_parts_count(
            crate::http_serde::deser_header_head_object_head_object_output_parts_count(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::HeadObjectError::unhandled(
                    "Failed to parse PartsCount from header `x-amz-mp-parts-count",
                )
            })?,
        );
        output = output.set_replication_status(
            crate::http_serde::deser_header_head_object_head_object_output_replication_status(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::HeadObjectError::unhandled(
                    "Failed to parse ReplicationStatus from header `x-amz-replication-status",
                )
            })?,
        );
        output = output.set_request_charged(
            crate::http_serde::deser_header_head_object_head_object_output_request_charged(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::HeadObjectError::unhandled(
                    "Failed to parse RequestCharged from header `x-amz-request-charged",
                )
            })?,
        );
        output = output.set_restore(
            crate::http_serde::deser_header_head_object_head_object_output_restore(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::HeadObjectError::unhandled(
                    "Failed to parse Restore from header `x-amz-restore",
                )
            })?,
        );
        output = output.set_sse_customer_algorithm(
            crate::http_serde::deser_header_head_object_head_object_output_sse_customer_algorithm(response.headers())
                                        .map_err(|_|crate::error::HeadObjectError::unhandled("Failed to parse SSECustomerAlgorithm from header `x-amz-server-side-encryption-customer-algorithm"))?
        );
        output = output.set_sse_customer_key_md5(
            crate::http_serde::deser_header_head_object_head_object_output_sse_customer_key_md5(response.headers())
                                        .map_err(|_|crate::error::HeadObjectError::unhandled("Failed to parse SSECustomerKeyMD5 from header `x-amz-server-side-encryption-customer-key-MD5"))?
        );
        output = output.set_ssekms_key_id(
            crate::http_serde::deser_header_head_object_head_object_output_ssekms_key_id(response.headers())
                                        .map_err(|_|crate::error::HeadObjectError::unhandled("Failed to parse SSEKMSKeyId from header `x-amz-server-side-encryption-aws-kms-key-id"))?
        );
        output = output.set_server_side_encryption(
            crate::http_serde::deser_header_head_object_head_object_output_server_side_encryption(response.headers())
                                        .map_err(|_|crate::error::HeadObjectError::unhandled("Failed to parse ServerSideEncryption from header `x-amz-server-side-encryption"))?
        );
        output = output.set_storage_class(
            crate::http_serde::deser_header_head_object_head_object_output_storage_class(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::HeadObjectError::unhandled(
                    "Failed to parse StorageClass from header `x-amz-storage-class",
                )
            })?,
        );
        output = output.set_version_id(
            crate::http_serde::deser_header_head_object_head_object_output_version_id(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::HeadObjectError::unhandled(
                    "Failed to parse VersionId from header `x-amz-version-id",
                )
            })?,
        );
        output = output.set_website_redirect_location(
            crate::http_serde::deser_header_head_object_head_object_output_website_redirect_location(response.headers())
                                        .map_err(|_|crate::error::HeadObjectError::unhandled("Failed to parse WebsiteRedirectLocation from header `x-amz-website-redirect-location"))?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_bucket_analytics_configurations_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListBucketAnalyticsConfigurationsOutput,
    crate::error::ListBucketAnalyticsConfigurationsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListBucketAnalyticsConfigurationsError::unhandled)?;
    Err(crate::error::ListBucketAnalyticsConfigurationsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_bucket_analytics_configurations_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListBucketAnalyticsConfigurationsOutput,
    crate::error::ListBucketAnalyticsConfigurationsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_bucket_analytics_configurations_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_list_bucket_analytics_configurations(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ListBucketAnalyticsConfigurationsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_bucket_intelligent_tiering_configurations_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListBucketIntelligentTieringConfigurationsOutput,
    crate::error::ListBucketIntelligentTieringConfigurationsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListBucketIntelligentTieringConfigurationsError::unhandled)?;
    Err(crate::error::ListBucketIntelligentTieringConfigurationsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_bucket_intelligent_tiering_configurations_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListBucketIntelligentTieringConfigurationsOutput,
    crate::error::ListBucketIntelligentTieringConfigurationsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_bucket_intelligent_tiering_configurations_output::Builder::default(
            );
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_bucket_intelligent_tiering_configurations(response.body().as_ref(), output).map_err(crate::error::ListBucketIntelligentTieringConfigurationsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_bucket_inventory_configurations_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListBucketInventoryConfigurationsOutput,
    crate::error::ListBucketInventoryConfigurationsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListBucketInventoryConfigurationsError::unhandled)?;
    Err(crate::error::ListBucketInventoryConfigurationsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_bucket_inventory_configurations_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListBucketInventoryConfigurationsOutput,
    crate::error::ListBucketInventoryConfigurationsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_bucket_inventory_configurations_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_list_bucket_inventory_configurations(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ListBucketInventoryConfigurationsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_bucket_metrics_configurations_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListBucketMetricsConfigurationsOutput,
    crate::error::ListBucketMetricsConfigurationsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListBucketMetricsConfigurationsError::unhandled)?;
    Err(crate::error::ListBucketMetricsConfigurationsError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_bucket_metrics_configurations_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListBucketMetricsConfigurationsOutput,
    crate::error::ListBucketMetricsConfigurationsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_bucket_metrics_configurations_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_list_bucket_metrics_configurations(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ListBucketMetricsConfigurationsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_buckets_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListBucketsOutput, crate::error::ListBucketsError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListBucketsError::unhandled)?;
    Err(crate::error::ListBucketsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_buckets_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListBucketsOutput, crate::error::ListBucketsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_buckets_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_buckets(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListBucketsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_multipart_uploads_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListMultipartUploadsOutput,
    crate::error::ListMultipartUploadsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListMultipartUploadsError::unhandled)?;
    Err(crate::error::ListMultipartUploadsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_multipart_uploads_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListMultipartUploadsOutput,
    crate::error::ListMultipartUploadsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_multipart_uploads_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_multipart_uploads(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListMultipartUploadsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_objects_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListObjectsOutput, crate::error::ListObjectsError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListObjectsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListObjectsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchBucket" => crate::error::ListObjectsError {
            meta: generic,
            kind: crate::error::ListObjectsErrorKind::NoSuchBucket({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_bucket::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_bucket_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListObjectsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListObjectsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_objects_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListObjectsOutput, crate::error::ListObjectsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_objects_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_objects(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListObjectsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_objects_v2_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListObjectsV2Output, crate::error::ListObjectsV2Error> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListObjectsV2Error::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListObjectsV2Error::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchBucket" => crate::error::ListObjectsV2Error {
            meta: generic,
            kind: crate::error::ListObjectsV2ErrorKind::NoSuchBucket({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_bucket::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_bucket_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListObjectsV2Error::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListObjectsV2Error::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_objects_v2_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListObjectsV2Output, crate::error::ListObjectsV2Error> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_objects_v2_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_objects_v2(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListObjectsV2Error::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_object_versions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListObjectVersionsOutput,
    crate::error::ListObjectVersionsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListObjectVersionsError::unhandled)?;
    Err(crate::error::ListObjectVersionsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_object_versions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListObjectVersionsOutput,
    crate::error::ListObjectVersionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_object_versions_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_object_versions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListObjectVersionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_parts_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListPartsOutput, crate::error::ListPartsError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListPartsError::unhandled)?;
    Err(crate::error::ListPartsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_parts_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListPartsOutput, crate::error::ListPartsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_parts_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_parts(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListPartsError::unhandled)?;
        output = output.set_abort_date(
            crate::http_serde::deser_header_list_parts_list_parts_output_abort_date(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::ListPartsError::unhandled(
                    "Failed to parse AbortDate from header `x-amz-abort-date",
                )
            })?,
        );
        output = output.set_abort_rule_id(
            crate::http_serde::deser_header_list_parts_list_parts_output_abort_rule_id(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::ListPartsError::unhandled(
                    "Failed to parse AbortRuleId from header `x-amz-abort-rule-id",
                )
            })?,
        );
        output = output.set_request_charged(
            crate::http_serde::deser_header_list_parts_list_parts_output_request_charged(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::ListPartsError::unhandled(
                    "Failed to parse RequestCharged from header `x-amz-request-charged",
                )
            })?,
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_bucket_accelerate_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutBucketAccelerateConfigurationOutput,
    crate::error::PutBucketAccelerateConfigurationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutBucketAccelerateConfigurationError::unhandled)?;
    Err(crate::error::PutBucketAccelerateConfigurationError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_bucket_accelerate_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutBucketAccelerateConfigurationOutput,
    crate::error::PutBucketAccelerateConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::put_bucket_accelerate_configuration_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_bucket_acl_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutBucketAclOutput, crate::error::PutBucketAclError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutBucketAclError::unhandled)?;
    Err(crate::error::PutBucketAclError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_bucket_acl_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutBucketAclOutput, crate::error::PutBucketAclError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_bucket_acl_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_bucket_analytics_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutBucketAnalyticsConfigurationOutput,
    crate::error::PutBucketAnalyticsConfigurationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutBucketAnalyticsConfigurationError::unhandled)?;
    Err(crate::error::PutBucketAnalyticsConfigurationError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_bucket_analytics_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutBucketAnalyticsConfigurationOutput,
    crate::error::PutBucketAnalyticsConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::put_bucket_analytics_configuration_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_bucket_cors_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutBucketCorsOutput, crate::error::PutBucketCorsError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutBucketCorsError::unhandled)?;
    Err(crate::error::PutBucketCorsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_bucket_cors_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutBucketCorsOutput, crate::error::PutBucketCorsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_bucket_cors_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_bucket_encryption_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutBucketEncryptionOutput,
    crate::error::PutBucketEncryptionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutBucketEncryptionError::unhandled)?;
    Err(crate::error::PutBucketEncryptionError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_bucket_encryption_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutBucketEncryptionOutput,
    crate::error::PutBucketEncryptionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_bucket_encryption_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_bucket_intelligent_tiering_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutBucketIntelligentTieringConfigurationOutput,
    crate::error::PutBucketIntelligentTieringConfigurationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutBucketIntelligentTieringConfigurationError::unhandled)?;
    Err(crate::error::PutBucketIntelligentTieringConfigurationError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_bucket_intelligent_tiering_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutBucketIntelligentTieringConfigurationOutput,
    crate::error::PutBucketIntelligentTieringConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::put_bucket_intelligent_tiering_configuration_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_bucket_inventory_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutBucketInventoryConfigurationOutput,
    crate::error::PutBucketInventoryConfigurationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutBucketInventoryConfigurationError::unhandled)?;
    Err(crate::error::PutBucketInventoryConfigurationError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_bucket_inventory_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutBucketInventoryConfigurationOutput,
    crate::error::PutBucketInventoryConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::put_bucket_inventory_configuration_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_bucket_lifecycle_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutBucketLifecycleConfigurationOutput,
    crate::error::PutBucketLifecycleConfigurationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutBucketLifecycleConfigurationError::unhandled)?;
    Err(crate::error::PutBucketLifecycleConfigurationError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_bucket_lifecycle_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutBucketLifecycleConfigurationOutput,
    crate::error::PutBucketLifecycleConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::put_bucket_lifecycle_configuration_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_bucket_logging_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutBucketLoggingOutput, crate::error::PutBucketLoggingError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutBucketLoggingError::unhandled)?;
    Err(crate::error::PutBucketLoggingError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_bucket_logging_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutBucketLoggingOutput, crate::error::PutBucketLoggingError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_bucket_logging_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_bucket_metrics_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutBucketMetricsConfigurationOutput,
    crate::error::PutBucketMetricsConfigurationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutBucketMetricsConfigurationError::unhandled)?;
    Err(crate::error::PutBucketMetricsConfigurationError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_bucket_metrics_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutBucketMetricsConfigurationOutput,
    crate::error::PutBucketMetricsConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_bucket_metrics_configuration_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_bucket_notification_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutBucketNotificationConfigurationOutput,
    crate::error::PutBucketNotificationConfigurationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutBucketNotificationConfigurationError::unhandled)?;
    Err(crate::error::PutBucketNotificationConfigurationError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_bucket_notification_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutBucketNotificationConfigurationOutput,
    crate::error::PutBucketNotificationConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::put_bucket_notification_configuration_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_bucket_ownership_controls_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutBucketOwnershipControlsOutput,
    crate::error::PutBucketOwnershipControlsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutBucketOwnershipControlsError::unhandled)?;
    Err(crate::error::PutBucketOwnershipControlsError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_bucket_ownership_controls_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutBucketOwnershipControlsOutput,
    crate::error::PutBucketOwnershipControlsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_bucket_ownership_controls_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_bucket_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutBucketPolicyOutput, crate::error::PutBucketPolicyError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutBucketPolicyError::unhandled)?;
    Err(crate::error::PutBucketPolicyError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_bucket_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutBucketPolicyOutput, crate::error::PutBucketPolicyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_bucket_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_bucket_replication_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutBucketReplicationOutput,
    crate::error::PutBucketReplicationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutBucketReplicationError::unhandled)?;
    Err(crate::error::PutBucketReplicationError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_bucket_replication_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutBucketReplicationOutput,
    crate::error::PutBucketReplicationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_bucket_replication_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_bucket_request_payment_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutBucketRequestPaymentOutput,
    crate::error::PutBucketRequestPaymentError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutBucketRequestPaymentError::unhandled)?;
    Err(crate::error::PutBucketRequestPaymentError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_bucket_request_payment_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutBucketRequestPaymentOutput,
    crate::error::PutBucketRequestPaymentError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_bucket_request_payment_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_bucket_tagging_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutBucketTaggingOutput, crate::error::PutBucketTaggingError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutBucketTaggingError::unhandled)?;
    Err(crate::error::PutBucketTaggingError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_bucket_tagging_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutBucketTaggingOutput, crate::error::PutBucketTaggingError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_bucket_tagging_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_bucket_versioning_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutBucketVersioningOutput,
    crate::error::PutBucketVersioningError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutBucketVersioningError::unhandled)?;
    Err(crate::error::PutBucketVersioningError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_bucket_versioning_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutBucketVersioningOutput,
    crate::error::PutBucketVersioningError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_bucket_versioning_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_bucket_website_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutBucketWebsiteOutput, crate::error::PutBucketWebsiteError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutBucketWebsiteError::unhandled)?;
    Err(crate::error::PutBucketWebsiteError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_bucket_website_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutBucketWebsiteOutput, crate::error::PutBucketWebsiteError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_bucket_website_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_object_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutObjectOutput, crate::error::PutObjectError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutObjectError::unhandled)?;
    Err(crate::error::PutObjectError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_object_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutObjectOutput, crate::error::PutObjectError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_object_output::Builder::default();
        let _ = response;
        output = output.set_bucket_key_enabled(
            crate::http_serde::deser_header_put_object_put_object_output_bucket_key_enabled(response.headers())
                                        .map_err(|_|crate::error::PutObjectError::unhandled("Failed to parse BucketKeyEnabled from header `x-amz-server-side-encryption-bucket-key-enabled"))?
        );
        output = output.set_e_tag(
            crate::http_serde::deser_header_put_object_put_object_output_e_tag(response.headers())
                .map_err(|_| {
                    crate::error::PutObjectError::unhandled(
                        "Failed to parse ETag from header `ETag",
                    )
                })?,
        );
        output = output.set_expiration(
            crate::http_serde::deser_header_put_object_put_object_output_expiration(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::PutObjectError::unhandled(
                    "Failed to parse Expiration from header `x-amz-expiration",
                )
            })?,
        );
        output = output.set_request_charged(
            crate::http_serde::deser_header_put_object_put_object_output_request_charged(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::PutObjectError::unhandled(
                    "Failed to parse RequestCharged from header `x-amz-request-charged",
                )
            })?,
        );
        output = output.set_sse_customer_algorithm(
            crate::http_serde::deser_header_put_object_put_object_output_sse_customer_algorithm(response.headers())
                                        .map_err(|_|crate::error::PutObjectError::unhandled("Failed to parse SSECustomerAlgorithm from header `x-amz-server-side-encryption-customer-algorithm"))?
        );
        output = output.set_sse_customer_key_md5(
            crate::http_serde::deser_header_put_object_put_object_output_sse_customer_key_md5(response.headers())
                                        .map_err(|_|crate::error::PutObjectError::unhandled("Failed to parse SSECustomerKeyMD5 from header `x-amz-server-side-encryption-customer-key-MD5"))?
        );
        output = output.set_ssekms_encryption_context(
            crate::http_serde::deser_header_put_object_put_object_output_ssekms_encryption_context(response.headers())
                                        .map_err(|_|crate::error::PutObjectError::unhandled("Failed to parse SSEKMSEncryptionContext from header `x-amz-server-side-encryption-context"))?
        );
        output = output.set_ssekms_key_id(
            crate::http_serde::deser_header_put_object_put_object_output_ssekms_key_id(response.headers())
                                        .map_err(|_|crate::error::PutObjectError::unhandled("Failed to parse SSEKMSKeyId from header `x-amz-server-side-encryption-aws-kms-key-id"))?
        );
        output = output.set_server_side_encryption(
            crate::http_serde::deser_header_put_object_put_object_output_server_side_encryption(response.headers())
                                        .map_err(|_|crate::error::PutObjectError::unhandled("Failed to parse ServerSideEncryption from header `x-amz-server-side-encryption"))?
        );
        output = output.set_version_id(
            crate::http_serde::deser_header_put_object_put_object_output_version_id(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::PutObjectError::unhandled(
                    "Failed to parse VersionId from header `x-amz-version-id",
                )
            })?,
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_object_acl_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutObjectAclOutput, crate::error::PutObjectAclError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutObjectAclError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutObjectAclError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchKey" => crate::error::PutObjectAclError {
            meta: generic,
            kind: crate::error::PutObjectAclErrorKind::NoSuchKey({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_key::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_key_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::PutObjectAclError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutObjectAclError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_object_acl_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutObjectAclOutput, crate::error::PutObjectAclError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_object_acl_output::Builder::default();
        let _ = response;
        output = output.set_request_charged(
            crate::http_serde::deser_header_put_object_acl_put_object_acl_output_request_charged(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::PutObjectAclError::unhandled(
                    "Failed to parse RequestCharged from header `x-amz-request-charged",
                )
            })?,
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_object_legal_hold_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutObjectLegalHoldOutput,
    crate::error::PutObjectLegalHoldError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutObjectLegalHoldError::unhandled)?;
    Err(crate::error::PutObjectLegalHoldError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_object_legal_hold_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutObjectLegalHoldOutput,
    crate::error::PutObjectLegalHoldError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_object_legal_hold_output::Builder::default();
        let _ = response;
        output = output.set_request_charged(
            crate::http_serde::deser_header_put_object_legal_hold_put_object_legal_hold_output_request_charged(response.headers())
                                        .map_err(|_|crate::error::PutObjectLegalHoldError::unhandled("Failed to parse RequestCharged from header `x-amz-request-charged"))?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_object_lock_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutObjectLockConfigurationOutput,
    crate::error::PutObjectLockConfigurationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutObjectLockConfigurationError::unhandled)?;
    Err(crate::error::PutObjectLockConfigurationError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_object_lock_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutObjectLockConfigurationOutput,
    crate::error::PutObjectLockConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_object_lock_configuration_output::Builder::default();
        let _ = response;
        output = output.set_request_charged(
            crate::http_serde::deser_header_put_object_lock_configuration_put_object_lock_configuration_output_request_charged(response.headers())
                                        .map_err(|_|crate::error::PutObjectLockConfigurationError::unhandled("Failed to parse RequestCharged from header `x-amz-request-charged"))?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_object_retention_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutObjectRetentionOutput,
    crate::error::PutObjectRetentionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutObjectRetentionError::unhandled)?;
    Err(crate::error::PutObjectRetentionError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_object_retention_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutObjectRetentionOutput,
    crate::error::PutObjectRetentionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_object_retention_output::Builder::default();
        let _ = response;
        output = output.set_request_charged(
            crate::http_serde::deser_header_put_object_retention_put_object_retention_output_request_charged(response.headers())
                                        .map_err(|_|crate::error::PutObjectRetentionError::unhandled("Failed to parse RequestCharged from header `x-amz-request-charged"))?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_object_tagging_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutObjectTaggingOutput, crate::error::PutObjectTaggingError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutObjectTaggingError::unhandled)?;
    Err(crate::error::PutObjectTaggingError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_object_tagging_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutObjectTaggingOutput, crate::error::PutObjectTaggingError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_object_tagging_output::Builder::default();
        let _ = response;
        output = output.set_version_id(
            crate::http_serde::deser_header_put_object_tagging_put_object_tagging_output_version_id(response.headers())
                                        .map_err(|_|crate::error::PutObjectTaggingError::unhandled("Failed to parse VersionId from header `x-amz-version-id"))?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_public_access_block_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutPublicAccessBlockOutput,
    crate::error::PutPublicAccessBlockError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutPublicAccessBlockError::unhandled)?;
    Err(crate::error::PutPublicAccessBlockError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_public_access_block_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutPublicAccessBlockOutput,
    crate::error::PutPublicAccessBlockError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_public_access_block_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_restore_object_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RestoreObjectOutput, crate::error::RestoreObjectError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RestoreObjectError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RestoreObjectError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ObjectAlreadyInActiveTierError" => crate::error::RestoreObjectError {
            meta: generic,
            kind: crate::error::RestoreObjectErrorKind::ObjectAlreadyInActiveTierError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::object_already_in_active_tier_error::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_object_already_in_active_tier_error_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreObjectError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RestoreObjectError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_restore_object_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RestoreObjectOutput, crate::error::RestoreObjectError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::restore_object_output::Builder::default();
        let _ = response;
        output = output.set_request_charged(
            crate::http_serde::deser_header_restore_object_restore_object_output_request_charged(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::RestoreObjectError::unhandled(
                    "Failed to parse RequestCharged from header `x-amz-request-charged",
                )
            })?,
        );
        output = output.set_restore_output_path(
            crate::http_serde::deser_header_restore_object_restore_object_output_restore_output_path(response.headers())
                                        .map_err(|_|crate::error::RestoreObjectError::unhandled("Failed to parse RestoreOutputPath from header `x-amz-restore-output-path"))?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_select_object_content(
    op_response: &mut aws_smithy_http::operation::Response,
) -> std::result::Result<
    crate::output::SelectObjectContentOutput,
    crate::error::SelectObjectContentError,
> {
    let response = op_response.http_mut();
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::select_object_content_output::Builder::default();
        let _ = response;
        output = output.set_payload(
            Some(crate::http_serde::deser_payload_select_object_content_select_object_content_output_payload(response.body_mut())?)
        );
        output
            .build()
            .map_err(crate::error::SelectObjectContentError::unhandled)?
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_select_object_content_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SelectObjectContentOutput,
    crate::error::SelectObjectContentError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SelectObjectContentError::unhandled)?;
    Err(crate::error::SelectObjectContentError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_upload_part_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UploadPartOutput, crate::error::UploadPartError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UploadPartError::unhandled)?;
    Err(crate::error::UploadPartError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_upload_part_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UploadPartOutput, crate::error::UploadPartError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::upload_part_output::Builder::default();
        let _ = response;
        output = output.set_bucket_key_enabled(
            crate::http_serde::deser_header_upload_part_upload_part_output_bucket_key_enabled(response.headers())
                                        .map_err(|_|crate::error::UploadPartError::unhandled("Failed to parse BucketKeyEnabled from header `x-amz-server-side-encryption-bucket-key-enabled"))?
        );
        output = output.set_e_tag(
            crate::http_serde::deser_header_upload_part_upload_part_output_e_tag(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::UploadPartError::unhandled("Failed to parse ETag from header `ETag")
            })?,
        );
        output = output.set_request_charged(
            crate::http_serde::deser_header_upload_part_upload_part_output_request_charged(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::UploadPartError::unhandled(
                    "Failed to parse RequestCharged from header `x-amz-request-charged",
                )
            })?,
        );
        output = output.set_sse_customer_algorithm(
            crate::http_serde::deser_header_upload_part_upload_part_output_sse_customer_algorithm(response.headers())
                                        .map_err(|_|crate::error::UploadPartError::unhandled("Failed to parse SSECustomerAlgorithm from header `x-amz-server-side-encryption-customer-algorithm"))?
        );
        output = output.set_sse_customer_key_md5(
            crate::http_serde::deser_header_upload_part_upload_part_output_sse_customer_key_md5(response.headers())
                                        .map_err(|_|crate::error::UploadPartError::unhandled("Failed to parse SSECustomerKeyMD5 from header `x-amz-server-side-encryption-customer-key-MD5"))?
        );
        output = output.set_ssekms_key_id(
            crate::http_serde::deser_header_upload_part_upload_part_output_ssekms_key_id(response.headers())
                                        .map_err(|_|crate::error::UploadPartError::unhandled("Failed to parse SSEKMSKeyId from header `x-amz-server-side-encryption-aws-kms-key-id"))?
        );
        output = output.set_server_side_encryption(
            crate::http_serde::deser_header_upload_part_upload_part_output_server_side_encryption(response.headers())
                                        .map_err(|_|crate::error::UploadPartError::unhandled("Failed to parse ServerSideEncryption from header `x-amz-server-side-encryption"))?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_upload_part_copy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UploadPartCopyOutput, crate::error::UploadPartCopyError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UploadPartCopyError::unhandled)?;
    Err(crate::error::UploadPartCopyError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_upload_part_copy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UploadPartCopyOutput, crate::error::UploadPartCopyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::upload_part_copy_output::Builder::default();
        let _ = response;
        output = output.set_bucket_key_enabled(
            crate::http_serde::deser_header_upload_part_copy_upload_part_copy_output_bucket_key_enabled(response.headers())
                                        .map_err(|_|crate::error::UploadPartCopyError::unhandled("Failed to parse BucketKeyEnabled from header `x-amz-server-side-encryption-bucket-key-enabled"))?
        );
        output = output.set_copy_part_result(
            crate::http_serde::deser_payload_upload_part_copy_upload_part_copy_output_copy_part_result(response.body().as_ref())?
        );
        output = output.set_copy_source_version_id(
            crate::http_serde::deser_header_upload_part_copy_upload_part_copy_output_copy_source_version_id(response.headers())
                                        .map_err(|_|crate::error::UploadPartCopyError::unhandled("Failed to parse CopySourceVersionId from header `x-amz-copy-source-version-id"))?
        );
        output = output.set_request_charged(
            crate::http_serde::deser_header_upload_part_copy_upload_part_copy_output_request_charged(response.headers())
                                        .map_err(|_|crate::error::UploadPartCopyError::unhandled("Failed to parse RequestCharged from header `x-amz-request-charged"))?
        );
        output = output.set_sse_customer_algorithm(
            crate::http_serde::deser_header_upload_part_copy_upload_part_copy_output_sse_customer_algorithm(response.headers())
                                        .map_err(|_|crate::error::UploadPartCopyError::unhandled("Failed to parse SSECustomerAlgorithm from header `x-amz-server-side-encryption-customer-algorithm"))?
        );
        output = output.set_sse_customer_key_md5(
            crate::http_serde::deser_header_upload_part_copy_upload_part_copy_output_sse_customer_key_md5(response.headers())
                                        .map_err(|_|crate::error::UploadPartCopyError::unhandled("Failed to parse SSECustomerKeyMD5 from header `x-amz-server-side-encryption-customer-key-MD5"))?
        );
        output = output.set_ssekms_key_id(
            crate::http_serde::deser_header_upload_part_copy_upload_part_copy_output_ssekms_key_id(response.headers())
                                        .map_err(|_|crate::error::UploadPartCopyError::unhandled("Failed to parse SSEKMSKeyId from header `x-amz-server-side-encryption-aws-kms-key-id"))?
        );
        output = output.set_server_side_encryption(
            crate::http_serde::deser_header_upload_part_copy_upload_part_copy_output_server_side_encryption(response.headers())
                                        .map_err(|_|crate::error::UploadPartCopyError::unhandled("Failed to parse ServerSideEncryption from header `x-amz-server-side-encryption"))?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_write_get_object_response_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::WriteGetObjectResponseOutput,
    crate::error::WriteGetObjectResponseError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::WriteGetObjectResponseError::unhandled)?;
    Err(crate::error::WriteGetObjectResponseError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_write_get_object_response_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::WriteGetObjectResponseOutput,
    crate::error::WriteGetObjectResponseError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::write_get_object_response_output::Builder::default();
        let _ = response;
        output.build()
    })
}
