// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AbortMultipartUpload`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`abort_multipart_upload`](crate::client::Client::abort_multipart_upload).
///
/// See [`crate::client::fluent_builders::AbortMultipartUpload`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AbortMultipartUpload {
    _private: (),
}
impl AbortMultipartUpload {
    /// Creates a new builder-style object to manufacture [`AbortMultipartUploadInput`](crate::input::AbortMultipartUploadInput)
    pub fn builder() -> crate::input::abort_multipart_upload_input::Builder {
        crate::input::abort_multipart_upload_input::Builder::default()
    }
    /// Creates a new `AbortMultipartUpload` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AbortMultipartUpload {
    type Output = std::result::Result<
        crate::output::AbortMultipartUploadOutput,
        crate::error::AbortMultipartUploadError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_abort_multipart_upload_error(response)
        } else {
            crate::operation_deser::parse_abort_multipart_upload_response(response)
        }
    }
}

/// Operation shape for `CompleteMultipartUpload`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`complete_multipart_upload`](crate::client::Client::complete_multipart_upload).
///
/// See [`crate::client::fluent_builders::CompleteMultipartUpload`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CompleteMultipartUpload {
    _private: (),
}
impl CompleteMultipartUpload {
    /// Creates a new builder-style object to manufacture [`CompleteMultipartUploadInput`](crate::input::CompleteMultipartUploadInput)
    pub fn builder() -> crate::input::complete_multipart_upload_input::Builder {
        crate::input::complete_multipart_upload_input::Builder::default()
    }
    /// Creates a new `CompleteMultipartUpload` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CompleteMultipartUpload {
    type Output = std::result::Result<
        crate::output::CompleteMultipartUploadOutput,
        crate::error::CompleteMultipartUploadError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_complete_multipart_upload_error(response)
        } else {
            crate::operation_deser::parse_complete_multipart_upload_response(response)
        }
    }
}

/// Operation shape for `CopyObject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`copy_object`](crate::client::Client::copy_object).
///
/// See [`crate::client::fluent_builders::CopyObject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CopyObject {
    _private: (),
}
impl CopyObject {
    /// Creates a new builder-style object to manufacture [`CopyObjectInput`](crate::input::CopyObjectInput)
    pub fn builder() -> crate::input::copy_object_input::Builder {
        crate::input::copy_object_input::Builder::default()
    }
    /// Creates a new `CopyObject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CopyObject {
    type Output =
        std::result::Result<crate::output::CopyObjectOutput, crate::error::CopyObjectError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_copy_object_error(response)
        } else {
            crate::operation_deser::parse_copy_object_response(response)
        }
    }
}

/// Operation shape for `CreateBucket`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_bucket`](crate::client::Client::create_bucket).
///
/// See [`crate::client::fluent_builders::CreateBucket`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateBucket {
    _private: (),
}
impl CreateBucket {
    /// Creates a new builder-style object to manufacture [`CreateBucketInput`](crate::input::CreateBucketInput)
    pub fn builder() -> crate::input::create_bucket_input::Builder {
        crate::input::create_bucket_input::Builder::default()
    }
    /// Creates a new `CreateBucket` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateBucket {
    type Output =
        std::result::Result<crate::output::CreateBucketOutput, crate::error::CreateBucketError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_bucket_error(response)
        } else {
            crate::operation_deser::parse_create_bucket_response(response)
        }
    }
}

/// Operation shape for `CreateMultipartUpload`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_multipart_upload`](crate::client::Client::create_multipart_upload).
///
/// See [`crate::client::fluent_builders::CreateMultipartUpload`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateMultipartUpload {
    _private: (),
}
impl CreateMultipartUpload {
    /// Creates a new builder-style object to manufacture [`CreateMultipartUploadInput`](crate::input::CreateMultipartUploadInput)
    pub fn builder() -> crate::input::create_multipart_upload_input::Builder {
        crate::input::create_multipart_upload_input::Builder::default()
    }
    /// Creates a new `CreateMultipartUpload` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateMultipartUpload {
    type Output = std::result::Result<
        crate::output::CreateMultipartUploadOutput,
        crate::error::CreateMultipartUploadError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_multipart_upload_error(response)
        } else {
            crate::operation_deser::parse_create_multipart_upload_response(response)
        }
    }
}
#[cfg(test)]
#[allow(unreachable_code, unused_variables)]
mod create_multipart_upload_request_test {
    /// This test validates that the URI for CreateMultipartUpload is created correctly
    /// Test ID: CreateMultipartUploadUriConstruction
    #[tokio::test]
    async fn create_multipart_upload_uri_construction_request() {
        let config = crate::config::Config::builder().build();
        let input = crate::input::CreateMultipartUploadInput::builder()
            .set_bucket(Some("test-bucket".to_string()))
            .set_key(Some("object.txt".to_string()))
            .build()
            .unwrap()
            .make_operation(&config)
            .expect("operation failed to build");
        let (http_request, parts) = input.into_request_response().0.into_parts();
        assert_eq!(http_request.method(), "POST");
        assert_eq!(http_request.uri().path(), "/test-bucket/object.txt");
        let expected_query_params = &["uploads", "x-id=CreateMultipartUpload"];
        aws_smithy_protocol_test::assert_ok(aws_smithy_protocol_test::validate_query_string(
            &http_request,
            expected_query_params,
        ));
    }
}

/// Operation shape for `DeleteBucket`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_bucket`](crate::client::Client::delete_bucket).
///
/// See [`crate::client::fluent_builders::DeleteBucket`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBucket {
    _private: (),
}
impl DeleteBucket {
    /// Creates a new builder-style object to manufacture [`DeleteBucketInput`](crate::input::DeleteBucketInput)
    pub fn builder() -> crate::input::delete_bucket_input::Builder {
        crate::input::delete_bucket_input::Builder::default()
    }
    /// Creates a new `DeleteBucket` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBucket {
    type Output =
        std::result::Result<crate::output::DeleteBucketOutput, crate::error::DeleteBucketError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_bucket_error(response)
        } else {
            crate::operation_deser::parse_delete_bucket_response(response)
        }
    }
}

/// Operation shape for `DeleteBucketAnalyticsConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_bucket_analytics_configuration`](crate::client::Client::delete_bucket_analytics_configuration).
///
/// See [`crate::client::fluent_builders::DeleteBucketAnalyticsConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBucketAnalyticsConfiguration {
    _private: (),
}
impl DeleteBucketAnalyticsConfiguration {
    /// Creates a new builder-style object to manufacture [`DeleteBucketAnalyticsConfigurationInput`](crate::input::DeleteBucketAnalyticsConfigurationInput)
    pub fn builder() -> crate::input::delete_bucket_analytics_configuration_input::Builder {
        crate::input::delete_bucket_analytics_configuration_input::Builder::default()
    }
    /// Creates a new `DeleteBucketAnalyticsConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBucketAnalyticsConfiguration {
    type Output = std::result::Result<
        crate::output::DeleteBucketAnalyticsConfigurationOutput,
        crate::error::DeleteBucketAnalyticsConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_bucket_analytics_configuration_error(response)
        } else {
            crate::operation_deser::parse_delete_bucket_analytics_configuration_response(response)
        }
    }
}

/// Operation shape for `DeleteBucketCors`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_bucket_cors`](crate::client::Client::delete_bucket_cors).
///
/// See [`crate::client::fluent_builders::DeleteBucketCors`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBucketCors {
    _private: (),
}
impl DeleteBucketCors {
    /// Creates a new builder-style object to manufacture [`DeleteBucketCorsInput`](crate::input::DeleteBucketCorsInput)
    pub fn builder() -> crate::input::delete_bucket_cors_input::Builder {
        crate::input::delete_bucket_cors_input::Builder::default()
    }
    /// Creates a new `DeleteBucketCors` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBucketCors {
    type Output = std::result::Result<
        crate::output::DeleteBucketCorsOutput,
        crate::error::DeleteBucketCorsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_bucket_cors_error(response)
        } else {
            crate::operation_deser::parse_delete_bucket_cors_response(response)
        }
    }
}

/// Operation shape for `DeleteBucketEncryption`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_bucket_encryption`](crate::client::Client::delete_bucket_encryption).
///
/// See [`crate::client::fluent_builders::DeleteBucketEncryption`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBucketEncryption {
    _private: (),
}
impl DeleteBucketEncryption {
    /// Creates a new builder-style object to manufacture [`DeleteBucketEncryptionInput`](crate::input::DeleteBucketEncryptionInput)
    pub fn builder() -> crate::input::delete_bucket_encryption_input::Builder {
        crate::input::delete_bucket_encryption_input::Builder::default()
    }
    /// Creates a new `DeleteBucketEncryption` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBucketEncryption {
    type Output = std::result::Result<
        crate::output::DeleteBucketEncryptionOutput,
        crate::error::DeleteBucketEncryptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_bucket_encryption_error(response)
        } else {
            crate::operation_deser::parse_delete_bucket_encryption_response(response)
        }
    }
}

/// Operation shape for `DeleteBucketIntelligentTieringConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_bucket_intelligent_tiering_configuration`](crate::client::Client::delete_bucket_intelligent_tiering_configuration).
///
/// See [`crate::client::fluent_builders::DeleteBucketIntelligentTieringConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBucketIntelligentTieringConfiguration {
    _private: (),
}
impl DeleteBucketIntelligentTieringConfiguration {
    /// Creates a new builder-style object to manufacture [`DeleteBucketIntelligentTieringConfigurationInput`](crate::input::DeleteBucketIntelligentTieringConfigurationInput)
    pub fn builder() -> crate::input::delete_bucket_intelligent_tiering_configuration_input::Builder
    {
        crate::input::delete_bucket_intelligent_tiering_configuration_input::Builder::default()
    }
    /// Creates a new `DeleteBucketIntelligentTieringConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for DeleteBucketIntelligentTieringConfiguration
{
    type Output = std::result::Result<
        crate::output::DeleteBucketIntelligentTieringConfigurationOutput,
        crate::error::DeleteBucketIntelligentTieringConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_bucket_intelligent_tiering_configuration_error(
                response,
            )
        } else {
            crate::operation_deser::parse_delete_bucket_intelligent_tiering_configuration_response(
                response,
            )
        }
    }
}

/// Operation shape for `DeleteBucketInventoryConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_bucket_inventory_configuration`](crate::client::Client::delete_bucket_inventory_configuration).
///
/// See [`crate::client::fluent_builders::DeleteBucketInventoryConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBucketInventoryConfiguration {
    _private: (),
}
impl DeleteBucketInventoryConfiguration {
    /// Creates a new builder-style object to manufacture [`DeleteBucketInventoryConfigurationInput`](crate::input::DeleteBucketInventoryConfigurationInput)
    pub fn builder() -> crate::input::delete_bucket_inventory_configuration_input::Builder {
        crate::input::delete_bucket_inventory_configuration_input::Builder::default()
    }
    /// Creates a new `DeleteBucketInventoryConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBucketInventoryConfiguration {
    type Output = std::result::Result<
        crate::output::DeleteBucketInventoryConfigurationOutput,
        crate::error::DeleteBucketInventoryConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_bucket_inventory_configuration_error(response)
        } else {
            crate::operation_deser::parse_delete_bucket_inventory_configuration_response(response)
        }
    }
}

/// Operation shape for `DeleteBucketLifecycle`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_bucket_lifecycle`](crate::client::Client::delete_bucket_lifecycle).
///
/// See [`crate::client::fluent_builders::DeleteBucketLifecycle`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBucketLifecycle {
    _private: (),
}
impl DeleteBucketLifecycle {
    /// Creates a new builder-style object to manufacture [`DeleteBucketLifecycleInput`](crate::input::DeleteBucketLifecycleInput)
    pub fn builder() -> crate::input::delete_bucket_lifecycle_input::Builder {
        crate::input::delete_bucket_lifecycle_input::Builder::default()
    }
    /// Creates a new `DeleteBucketLifecycle` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBucketLifecycle {
    type Output = std::result::Result<
        crate::output::DeleteBucketLifecycleOutput,
        crate::error::DeleteBucketLifecycleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_bucket_lifecycle_error(response)
        } else {
            crate::operation_deser::parse_delete_bucket_lifecycle_response(response)
        }
    }
}

/// Operation shape for `DeleteBucketMetricsConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_bucket_metrics_configuration`](crate::client::Client::delete_bucket_metrics_configuration).
///
/// See [`crate::client::fluent_builders::DeleteBucketMetricsConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBucketMetricsConfiguration {
    _private: (),
}
impl DeleteBucketMetricsConfiguration {
    /// Creates a new builder-style object to manufacture [`DeleteBucketMetricsConfigurationInput`](crate::input::DeleteBucketMetricsConfigurationInput)
    pub fn builder() -> crate::input::delete_bucket_metrics_configuration_input::Builder {
        crate::input::delete_bucket_metrics_configuration_input::Builder::default()
    }
    /// Creates a new `DeleteBucketMetricsConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBucketMetricsConfiguration {
    type Output = std::result::Result<
        crate::output::DeleteBucketMetricsConfigurationOutput,
        crate::error::DeleteBucketMetricsConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_bucket_metrics_configuration_error(response)
        } else {
            crate::operation_deser::parse_delete_bucket_metrics_configuration_response(response)
        }
    }
}

/// Operation shape for `DeleteBucketOwnershipControls`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_bucket_ownership_controls`](crate::client::Client::delete_bucket_ownership_controls).
///
/// See [`crate::client::fluent_builders::DeleteBucketOwnershipControls`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBucketOwnershipControls {
    _private: (),
}
impl DeleteBucketOwnershipControls {
    /// Creates a new builder-style object to manufacture [`DeleteBucketOwnershipControlsInput`](crate::input::DeleteBucketOwnershipControlsInput)
    pub fn builder() -> crate::input::delete_bucket_ownership_controls_input::Builder {
        crate::input::delete_bucket_ownership_controls_input::Builder::default()
    }
    /// Creates a new `DeleteBucketOwnershipControls` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBucketOwnershipControls {
    type Output = std::result::Result<
        crate::output::DeleteBucketOwnershipControlsOutput,
        crate::error::DeleteBucketOwnershipControlsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_bucket_ownership_controls_error(response)
        } else {
            crate::operation_deser::parse_delete_bucket_ownership_controls_response(response)
        }
    }
}

/// Operation shape for `DeleteBucketPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_bucket_policy`](crate::client::Client::delete_bucket_policy).
///
/// See [`crate::client::fluent_builders::DeleteBucketPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBucketPolicy {
    _private: (),
}
impl DeleteBucketPolicy {
    /// Creates a new builder-style object to manufacture [`DeleteBucketPolicyInput`](crate::input::DeleteBucketPolicyInput)
    pub fn builder() -> crate::input::delete_bucket_policy_input::Builder {
        crate::input::delete_bucket_policy_input::Builder::default()
    }
    /// Creates a new `DeleteBucketPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBucketPolicy {
    type Output = std::result::Result<
        crate::output::DeleteBucketPolicyOutput,
        crate::error::DeleteBucketPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_bucket_policy_error(response)
        } else {
            crate::operation_deser::parse_delete_bucket_policy_response(response)
        }
    }
}

/// Operation shape for `DeleteBucketReplication`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_bucket_replication`](crate::client::Client::delete_bucket_replication).
///
/// See [`crate::client::fluent_builders::DeleteBucketReplication`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBucketReplication {
    _private: (),
}
impl DeleteBucketReplication {
    /// Creates a new builder-style object to manufacture [`DeleteBucketReplicationInput`](crate::input::DeleteBucketReplicationInput)
    pub fn builder() -> crate::input::delete_bucket_replication_input::Builder {
        crate::input::delete_bucket_replication_input::Builder::default()
    }
    /// Creates a new `DeleteBucketReplication` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBucketReplication {
    type Output = std::result::Result<
        crate::output::DeleteBucketReplicationOutput,
        crate::error::DeleteBucketReplicationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_bucket_replication_error(response)
        } else {
            crate::operation_deser::parse_delete_bucket_replication_response(response)
        }
    }
}

/// Operation shape for `DeleteBucketTagging`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_bucket_tagging`](crate::client::Client::delete_bucket_tagging).
///
/// See [`crate::client::fluent_builders::DeleteBucketTagging`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBucketTagging {
    _private: (),
}
impl DeleteBucketTagging {
    /// Creates a new builder-style object to manufacture [`DeleteBucketTaggingInput`](crate::input::DeleteBucketTaggingInput)
    pub fn builder() -> crate::input::delete_bucket_tagging_input::Builder {
        crate::input::delete_bucket_tagging_input::Builder::default()
    }
    /// Creates a new `DeleteBucketTagging` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBucketTagging {
    type Output = std::result::Result<
        crate::output::DeleteBucketTaggingOutput,
        crate::error::DeleteBucketTaggingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_bucket_tagging_error(response)
        } else {
            crate::operation_deser::parse_delete_bucket_tagging_response(response)
        }
    }
}

/// Operation shape for `DeleteBucketWebsite`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_bucket_website`](crate::client::Client::delete_bucket_website).
///
/// See [`crate::client::fluent_builders::DeleteBucketWebsite`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBucketWebsite {
    _private: (),
}
impl DeleteBucketWebsite {
    /// Creates a new builder-style object to manufacture [`DeleteBucketWebsiteInput`](crate::input::DeleteBucketWebsiteInput)
    pub fn builder() -> crate::input::delete_bucket_website_input::Builder {
        crate::input::delete_bucket_website_input::Builder::default()
    }
    /// Creates a new `DeleteBucketWebsite` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBucketWebsite {
    type Output = std::result::Result<
        crate::output::DeleteBucketWebsiteOutput,
        crate::error::DeleteBucketWebsiteError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_bucket_website_error(response)
        } else {
            crate::operation_deser::parse_delete_bucket_website_response(response)
        }
    }
}

/// Operation shape for `DeleteObject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_object`](crate::client::Client::delete_object).
///
/// See [`crate::client::fluent_builders::DeleteObject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteObject {
    _private: (),
}
impl DeleteObject {
    /// Creates a new builder-style object to manufacture [`DeleteObjectInput`](crate::input::DeleteObjectInput)
    pub fn builder() -> crate::input::delete_object_input::Builder {
        crate::input::delete_object_input::Builder::default()
    }
    /// Creates a new `DeleteObject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteObject {
    type Output =
        std::result::Result<crate::output::DeleteObjectOutput, crate::error::DeleteObjectError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_object_error(response)
        } else {
            crate::operation_deser::parse_delete_object_response(response)
        }
    }
}

/// Operation shape for `DeleteObjects`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_objects`](crate::client::Client::delete_objects).
///
/// See [`crate::client::fluent_builders::DeleteObjects`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteObjects {
    _private: (),
}
impl DeleteObjects {
    /// Creates a new builder-style object to manufacture [`DeleteObjectsInput`](crate::input::DeleteObjectsInput)
    pub fn builder() -> crate::input::delete_objects_input::Builder {
        crate::input::delete_objects_input::Builder::default()
    }
    /// Creates a new `DeleteObjects` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteObjects {
    type Output =
        std::result::Result<crate::output::DeleteObjectsOutput, crate::error::DeleteObjectsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_objects_error(response)
        } else {
            crate::operation_deser::parse_delete_objects_response(response)
        }
    }
}

/// Operation shape for `DeleteObjectTagging`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_object_tagging`](crate::client::Client::delete_object_tagging).
///
/// See [`crate::client::fluent_builders::DeleteObjectTagging`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteObjectTagging {
    _private: (),
}
impl DeleteObjectTagging {
    /// Creates a new builder-style object to manufacture [`DeleteObjectTaggingInput`](crate::input::DeleteObjectTaggingInput)
    pub fn builder() -> crate::input::delete_object_tagging_input::Builder {
        crate::input::delete_object_tagging_input::Builder::default()
    }
    /// Creates a new `DeleteObjectTagging` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteObjectTagging {
    type Output = std::result::Result<
        crate::output::DeleteObjectTaggingOutput,
        crate::error::DeleteObjectTaggingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_object_tagging_error(response)
        } else {
            crate::operation_deser::parse_delete_object_tagging_response(response)
        }
    }
}

/// Operation shape for `DeletePublicAccessBlock`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_public_access_block`](crate::client::Client::delete_public_access_block).
///
/// See [`crate::client::fluent_builders::DeletePublicAccessBlock`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePublicAccessBlock {
    _private: (),
}
impl DeletePublicAccessBlock {
    /// Creates a new builder-style object to manufacture [`DeletePublicAccessBlockInput`](crate::input::DeletePublicAccessBlockInput)
    pub fn builder() -> crate::input::delete_public_access_block_input::Builder {
        crate::input::delete_public_access_block_input::Builder::default()
    }
    /// Creates a new `DeletePublicAccessBlock` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePublicAccessBlock {
    type Output = std::result::Result<
        crate::output::DeletePublicAccessBlockOutput,
        crate::error::DeletePublicAccessBlockError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_public_access_block_error(response)
        } else {
            crate::operation_deser::parse_delete_public_access_block_response(response)
        }
    }
}

/// Operation shape for `GetBucketAccelerateConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_bucket_accelerate_configuration`](crate::client::Client::get_bucket_accelerate_configuration).
///
/// See [`crate::client::fluent_builders::GetBucketAccelerateConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBucketAccelerateConfiguration {
    _private: (),
}
impl GetBucketAccelerateConfiguration {
    /// Creates a new builder-style object to manufacture [`GetBucketAccelerateConfigurationInput`](crate::input::GetBucketAccelerateConfigurationInput)
    pub fn builder() -> crate::input::get_bucket_accelerate_configuration_input::Builder {
        crate::input::get_bucket_accelerate_configuration_input::Builder::default()
    }
    /// Creates a new `GetBucketAccelerateConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBucketAccelerateConfiguration {
    type Output = std::result::Result<
        crate::output::GetBucketAccelerateConfigurationOutput,
        crate::error::GetBucketAccelerateConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_bucket_accelerate_configuration_error(response)
        } else {
            crate::operation_deser::parse_get_bucket_accelerate_configuration_response(response)
        }
    }
}

/// Operation shape for `GetBucketAcl`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_bucket_acl`](crate::client::Client::get_bucket_acl).
///
/// See [`crate::client::fluent_builders::GetBucketAcl`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBucketAcl {
    _private: (),
}
impl GetBucketAcl {
    /// Creates a new builder-style object to manufacture [`GetBucketAclInput`](crate::input::GetBucketAclInput)
    pub fn builder() -> crate::input::get_bucket_acl_input::Builder {
        crate::input::get_bucket_acl_input::Builder::default()
    }
    /// Creates a new `GetBucketAcl` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBucketAcl {
    type Output =
        std::result::Result<crate::output::GetBucketAclOutput, crate::error::GetBucketAclError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_bucket_acl_error(response)
        } else {
            crate::operation_deser::parse_get_bucket_acl_response(response)
        }
    }
}

/// Operation shape for `GetBucketAnalyticsConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_bucket_analytics_configuration`](crate::client::Client::get_bucket_analytics_configuration).
///
/// See [`crate::client::fluent_builders::GetBucketAnalyticsConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBucketAnalyticsConfiguration {
    _private: (),
}
impl GetBucketAnalyticsConfiguration {
    /// Creates a new builder-style object to manufacture [`GetBucketAnalyticsConfigurationInput`](crate::input::GetBucketAnalyticsConfigurationInput)
    pub fn builder() -> crate::input::get_bucket_analytics_configuration_input::Builder {
        crate::input::get_bucket_analytics_configuration_input::Builder::default()
    }
    /// Creates a new `GetBucketAnalyticsConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBucketAnalyticsConfiguration {
    type Output = std::result::Result<
        crate::output::GetBucketAnalyticsConfigurationOutput,
        crate::error::GetBucketAnalyticsConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_bucket_analytics_configuration_error(response)
        } else {
            crate::operation_deser::parse_get_bucket_analytics_configuration_response(response)
        }
    }
}

/// Operation shape for `GetBucketCors`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_bucket_cors`](crate::client::Client::get_bucket_cors).
///
/// See [`crate::client::fluent_builders::GetBucketCors`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBucketCors {
    _private: (),
}
impl GetBucketCors {
    /// Creates a new builder-style object to manufacture [`GetBucketCorsInput`](crate::input::GetBucketCorsInput)
    pub fn builder() -> crate::input::get_bucket_cors_input::Builder {
        crate::input::get_bucket_cors_input::Builder::default()
    }
    /// Creates a new `GetBucketCors` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBucketCors {
    type Output =
        std::result::Result<crate::output::GetBucketCorsOutput, crate::error::GetBucketCorsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_bucket_cors_error(response)
        } else {
            crate::operation_deser::parse_get_bucket_cors_response(response)
        }
    }
}

/// Operation shape for `GetBucketEncryption`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_bucket_encryption`](crate::client::Client::get_bucket_encryption).
///
/// See [`crate::client::fluent_builders::GetBucketEncryption`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBucketEncryption {
    _private: (),
}
impl GetBucketEncryption {
    /// Creates a new builder-style object to manufacture [`GetBucketEncryptionInput`](crate::input::GetBucketEncryptionInput)
    pub fn builder() -> crate::input::get_bucket_encryption_input::Builder {
        crate::input::get_bucket_encryption_input::Builder::default()
    }
    /// Creates a new `GetBucketEncryption` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBucketEncryption {
    type Output = std::result::Result<
        crate::output::GetBucketEncryptionOutput,
        crate::error::GetBucketEncryptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_bucket_encryption_error(response)
        } else {
            crate::operation_deser::parse_get_bucket_encryption_response(response)
        }
    }
}

/// Operation shape for `GetBucketIntelligentTieringConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_bucket_intelligent_tiering_configuration`](crate::client::Client::get_bucket_intelligent_tiering_configuration).
///
/// See [`crate::client::fluent_builders::GetBucketIntelligentTieringConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBucketIntelligentTieringConfiguration {
    _private: (),
}
impl GetBucketIntelligentTieringConfiguration {
    /// Creates a new builder-style object to manufacture [`GetBucketIntelligentTieringConfigurationInput`](crate::input::GetBucketIntelligentTieringConfigurationInput)
    pub fn builder() -> crate::input::get_bucket_intelligent_tiering_configuration_input::Builder {
        crate::input::get_bucket_intelligent_tiering_configuration_input::Builder::default()
    }
    /// Creates a new `GetBucketIntelligentTieringConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBucketIntelligentTieringConfiguration {
    type Output = std::result::Result<
        crate::output::GetBucketIntelligentTieringConfigurationOutput,
        crate::error::GetBucketIntelligentTieringConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_bucket_intelligent_tiering_configuration_error(
                response,
            )
        } else {
            crate::operation_deser::parse_get_bucket_intelligent_tiering_configuration_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetBucketInventoryConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_bucket_inventory_configuration`](crate::client::Client::get_bucket_inventory_configuration).
///
/// See [`crate::client::fluent_builders::GetBucketInventoryConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBucketInventoryConfiguration {
    _private: (),
}
impl GetBucketInventoryConfiguration {
    /// Creates a new builder-style object to manufacture [`GetBucketInventoryConfigurationInput`](crate::input::GetBucketInventoryConfigurationInput)
    pub fn builder() -> crate::input::get_bucket_inventory_configuration_input::Builder {
        crate::input::get_bucket_inventory_configuration_input::Builder::default()
    }
    /// Creates a new `GetBucketInventoryConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBucketInventoryConfiguration {
    type Output = std::result::Result<
        crate::output::GetBucketInventoryConfigurationOutput,
        crate::error::GetBucketInventoryConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_bucket_inventory_configuration_error(response)
        } else {
            crate::operation_deser::parse_get_bucket_inventory_configuration_response(response)
        }
    }
}

/// Operation shape for `GetBucketLifecycleConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_bucket_lifecycle_configuration`](crate::client::Client::get_bucket_lifecycle_configuration).
///
/// See [`crate::client::fluent_builders::GetBucketLifecycleConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBucketLifecycleConfiguration {
    _private: (),
}
impl GetBucketLifecycleConfiguration {
    /// Creates a new builder-style object to manufacture [`GetBucketLifecycleConfigurationInput`](crate::input::GetBucketLifecycleConfigurationInput)
    pub fn builder() -> crate::input::get_bucket_lifecycle_configuration_input::Builder {
        crate::input::get_bucket_lifecycle_configuration_input::Builder::default()
    }
    /// Creates a new `GetBucketLifecycleConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBucketLifecycleConfiguration {
    type Output = std::result::Result<
        crate::output::GetBucketLifecycleConfigurationOutput,
        crate::error::GetBucketLifecycleConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_bucket_lifecycle_configuration_error(response)
        } else {
            crate::operation_deser::parse_get_bucket_lifecycle_configuration_response(response)
        }
    }
}

/// Operation shape for `GetBucketLocation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_bucket_location`](crate::client::Client::get_bucket_location).
///
/// See [`crate::client::fluent_builders::GetBucketLocation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBucketLocation {
    _private: (),
}
impl GetBucketLocation {
    /// Creates a new builder-style object to manufacture [`GetBucketLocationInput`](crate::input::GetBucketLocationInput)
    pub fn builder() -> crate::input::get_bucket_location_input::Builder {
        crate::input::get_bucket_location_input::Builder::default()
    }
    /// Creates a new `GetBucketLocation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBucketLocation {
    type Output = std::result::Result<
        crate::output::GetBucketLocationOutput,
        crate::error::GetBucketLocationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_bucket_location_error(response)
        } else {
            crate::operation_deser::parse_get_bucket_location_response(response)
        }
    }
}
#[cfg(test)]
#[allow(unreachable_code, unused_variables)]
mod get_bucket_location_request_test {
    /// This test case validates https://github.com/awslabs/aws-sdk-rust/issues/116
    /// Test ID: GetBucketLocation
    #[tokio::test]
    async fn get_bucket_location_response() {
        let expected_output = crate::output::GetBucketLocationOutput::builder()
            .set_location_constraint(Some(crate::model::BucketLocationConstraint::from(
                "us-west-2",
            )))
            .build();
        let http_response = http::response::Builder::new()
        .status(200)
                        .body(aws_smithy_http::body::SdkBody::from("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<LocationConstraint xmlns=\"http://s3.amazonaws.com/doc/2006-03-01/\">us-west-2</LocationConstraint>"))
                        .unwrap();
        let mut op_response = aws_smithy_http::operation::Response::new(http_response);
        use aws_smithy_http::response::ParseHttpResponse;
        let parser = crate::operation::GetBucketLocation::new();
        let parsed = parser.parse_unloaded(&mut op_response);
        let parsed = parsed.unwrap_or_else(|| {
                        let (http_response, _) = op_response.into_parts();
                        let http_response = http_response.map(|body|bytes::Bytes::copy_from_slice(body.bytes().unwrap()));
                        <crate::operation::GetBucketLocation as aws_smithy_http::response::ParseHttpResponse>::parse_loaded(&parser, &http_response)
                    });
        let parsed = parsed.unwrap();
        assert_eq!(
            parsed.location_constraint, expected_output.location_constraint,
            "Unexpected value for `location_constraint`"
        );
    }
}

/// Operation shape for `GetBucketLogging`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_bucket_logging`](crate::client::Client::get_bucket_logging).
///
/// See [`crate::client::fluent_builders::GetBucketLogging`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBucketLogging {
    _private: (),
}
impl GetBucketLogging {
    /// Creates a new builder-style object to manufacture [`GetBucketLoggingInput`](crate::input::GetBucketLoggingInput)
    pub fn builder() -> crate::input::get_bucket_logging_input::Builder {
        crate::input::get_bucket_logging_input::Builder::default()
    }
    /// Creates a new `GetBucketLogging` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBucketLogging {
    type Output = std::result::Result<
        crate::output::GetBucketLoggingOutput,
        crate::error::GetBucketLoggingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_bucket_logging_error(response)
        } else {
            crate::operation_deser::parse_get_bucket_logging_response(response)
        }
    }
}

/// Operation shape for `GetBucketMetricsConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_bucket_metrics_configuration`](crate::client::Client::get_bucket_metrics_configuration).
///
/// See [`crate::client::fluent_builders::GetBucketMetricsConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBucketMetricsConfiguration {
    _private: (),
}
impl GetBucketMetricsConfiguration {
    /// Creates a new builder-style object to manufacture [`GetBucketMetricsConfigurationInput`](crate::input::GetBucketMetricsConfigurationInput)
    pub fn builder() -> crate::input::get_bucket_metrics_configuration_input::Builder {
        crate::input::get_bucket_metrics_configuration_input::Builder::default()
    }
    /// Creates a new `GetBucketMetricsConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBucketMetricsConfiguration {
    type Output = std::result::Result<
        crate::output::GetBucketMetricsConfigurationOutput,
        crate::error::GetBucketMetricsConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_bucket_metrics_configuration_error(response)
        } else {
            crate::operation_deser::parse_get_bucket_metrics_configuration_response(response)
        }
    }
}

/// Operation shape for `GetBucketNotificationConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_bucket_notification_configuration`](crate::client::Client::get_bucket_notification_configuration).
///
/// See [`crate::client::fluent_builders::GetBucketNotificationConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBucketNotificationConfiguration {
    _private: (),
}
impl GetBucketNotificationConfiguration {
    /// Creates a new builder-style object to manufacture [`GetBucketNotificationConfigurationInput`](crate::input::GetBucketNotificationConfigurationInput)
    pub fn builder() -> crate::input::get_bucket_notification_configuration_input::Builder {
        crate::input::get_bucket_notification_configuration_input::Builder::default()
    }
    /// Creates a new `GetBucketNotificationConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBucketNotificationConfiguration {
    type Output = std::result::Result<
        crate::output::GetBucketNotificationConfigurationOutput,
        crate::error::GetBucketNotificationConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_bucket_notification_configuration_error(response)
        } else {
            crate::operation_deser::parse_get_bucket_notification_configuration_response(response)
        }
    }
}

/// Operation shape for `GetBucketOwnershipControls`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_bucket_ownership_controls`](crate::client::Client::get_bucket_ownership_controls).
///
/// See [`crate::client::fluent_builders::GetBucketOwnershipControls`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBucketOwnershipControls {
    _private: (),
}
impl GetBucketOwnershipControls {
    /// Creates a new builder-style object to manufacture [`GetBucketOwnershipControlsInput`](crate::input::GetBucketOwnershipControlsInput)
    pub fn builder() -> crate::input::get_bucket_ownership_controls_input::Builder {
        crate::input::get_bucket_ownership_controls_input::Builder::default()
    }
    /// Creates a new `GetBucketOwnershipControls` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBucketOwnershipControls {
    type Output = std::result::Result<
        crate::output::GetBucketOwnershipControlsOutput,
        crate::error::GetBucketOwnershipControlsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_bucket_ownership_controls_error(response)
        } else {
            crate::operation_deser::parse_get_bucket_ownership_controls_response(response)
        }
    }
}

/// Operation shape for `GetBucketPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_bucket_policy`](crate::client::Client::get_bucket_policy).
///
/// See [`crate::client::fluent_builders::GetBucketPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBucketPolicy {
    _private: (),
}
impl GetBucketPolicy {
    /// Creates a new builder-style object to manufacture [`GetBucketPolicyInput`](crate::input::GetBucketPolicyInput)
    pub fn builder() -> crate::input::get_bucket_policy_input::Builder {
        crate::input::get_bucket_policy_input::Builder::default()
    }
    /// Creates a new `GetBucketPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBucketPolicy {
    type Output = std::result::Result<
        crate::output::GetBucketPolicyOutput,
        crate::error::GetBucketPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_bucket_policy_error(response)
        } else {
            crate::operation_deser::parse_get_bucket_policy_response(response)
        }
    }
}

/// Operation shape for `GetBucketPolicyStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_bucket_policy_status`](crate::client::Client::get_bucket_policy_status).
///
/// See [`crate::client::fluent_builders::GetBucketPolicyStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBucketPolicyStatus {
    _private: (),
}
impl GetBucketPolicyStatus {
    /// Creates a new builder-style object to manufacture [`GetBucketPolicyStatusInput`](crate::input::GetBucketPolicyStatusInput)
    pub fn builder() -> crate::input::get_bucket_policy_status_input::Builder {
        crate::input::get_bucket_policy_status_input::Builder::default()
    }
    /// Creates a new `GetBucketPolicyStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBucketPolicyStatus {
    type Output = std::result::Result<
        crate::output::GetBucketPolicyStatusOutput,
        crate::error::GetBucketPolicyStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_bucket_policy_status_error(response)
        } else {
            crate::operation_deser::parse_get_bucket_policy_status_response(response)
        }
    }
}

/// Operation shape for `GetBucketReplication`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_bucket_replication`](crate::client::Client::get_bucket_replication).
///
/// See [`crate::client::fluent_builders::GetBucketReplication`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBucketReplication {
    _private: (),
}
impl GetBucketReplication {
    /// Creates a new builder-style object to manufacture [`GetBucketReplicationInput`](crate::input::GetBucketReplicationInput)
    pub fn builder() -> crate::input::get_bucket_replication_input::Builder {
        crate::input::get_bucket_replication_input::Builder::default()
    }
    /// Creates a new `GetBucketReplication` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBucketReplication {
    type Output = std::result::Result<
        crate::output::GetBucketReplicationOutput,
        crate::error::GetBucketReplicationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_bucket_replication_error(response)
        } else {
            crate::operation_deser::parse_get_bucket_replication_response(response)
        }
    }
}

/// Operation shape for `GetBucketRequestPayment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_bucket_request_payment`](crate::client::Client::get_bucket_request_payment).
///
/// See [`crate::client::fluent_builders::GetBucketRequestPayment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBucketRequestPayment {
    _private: (),
}
impl GetBucketRequestPayment {
    /// Creates a new builder-style object to manufacture [`GetBucketRequestPaymentInput`](crate::input::GetBucketRequestPaymentInput)
    pub fn builder() -> crate::input::get_bucket_request_payment_input::Builder {
        crate::input::get_bucket_request_payment_input::Builder::default()
    }
    /// Creates a new `GetBucketRequestPayment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBucketRequestPayment {
    type Output = std::result::Result<
        crate::output::GetBucketRequestPaymentOutput,
        crate::error::GetBucketRequestPaymentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_bucket_request_payment_error(response)
        } else {
            crate::operation_deser::parse_get_bucket_request_payment_response(response)
        }
    }
}

/// Operation shape for `GetBucketTagging`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_bucket_tagging`](crate::client::Client::get_bucket_tagging).
///
/// See [`crate::client::fluent_builders::GetBucketTagging`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBucketTagging {
    _private: (),
}
impl GetBucketTagging {
    /// Creates a new builder-style object to manufacture [`GetBucketTaggingInput`](crate::input::GetBucketTaggingInput)
    pub fn builder() -> crate::input::get_bucket_tagging_input::Builder {
        crate::input::get_bucket_tagging_input::Builder::default()
    }
    /// Creates a new `GetBucketTagging` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBucketTagging {
    type Output = std::result::Result<
        crate::output::GetBucketTaggingOutput,
        crate::error::GetBucketTaggingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_bucket_tagging_error(response)
        } else {
            crate::operation_deser::parse_get_bucket_tagging_response(response)
        }
    }
}

/// Operation shape for `GetBucketVersioning`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_bucket_versioning`](crate::client::Client::get_bucket_versioning).
///
/// See [`crate::client::fluent_builders::GetBucketVersioning`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBucketVersioning {
    _private: (),
}
impl GetBucketVersioning {
    /// Creates a new builder-style object to manufacture [`GetBucketVersioningInput`](crate::input::GetBucketVersioningInput)
    pub fn builder() -> crate::input::get_bucket_versioning_input::Builder {
        crate::input::get_bucket_versioning_input::Builder::default()
    }
    /// Creates a new `GetBucketVersioning` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBucketVersioning {
    type Output = std::result::Result<
        crate::output::GetBucketVersioningOutput,
        crate::error::GetBucketVersioningError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_bucket_versioning_error(response)
        } else {
            crate::operation_deser::parse_get_bucket_versioning_response(response)
        }
    }
}

/// Operation shape for `GetBucketWebsite`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_bucket_website`](crate::client::Client::get_bucket_website).
///
/// See [`crate::client::fluent_builders::GetBucketWebsite`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBucketWebsite {
    _private: (),
}
impl GetBucketWebsite {
    /// Creates a new builder-style object to manufacture [`GetBucketWebsiteInput`](crate::input::GetBucketWebsiteInput)
    pub fn builder() -> crate::input::get_bucket_website_input::Builder {
        crate::input::get_bucket_website_input::Builder::default()
    }
    /// Creates a new `GetBucketWebsite` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBucketWebsite {
    type Output = std::result::Result<
        crate::output::GetBucketWebsiteOutput,
        crate::error::GetBucketWebsiteError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_bucket_website_error(response)
        } else {
            crate::operation_deser::parse_get_bucket_website_response(response)
        }
    }
}

/// Operation shape for `GetObject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_object`](crate::client::Client::get_object).
///
/// See [`crate::client::fluent_builders::GetObject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetObject {
    _private: (),
}
impl GetObject {
    /// Creates a new builder-style object to manufacture [`GetObjectInput`](crate::input::GetObjectInput)
    pub fn builder() -> crate::input::get_object_input::Builder {
        crate::input::get_object_input::Builder::default()
    }
    /// Creates a new `GetObject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseHttpResponse for GetObject {
    type Output = std::result::Result<crate::output::GetObjectOutput, crate::error::GetObjectError>;
    fn parse_unloaded(
        &self,
        response: &mut aws_smithy_http::operation::Response,
    ) -> Option<Self::Output> {
        // This is an error, defer to the non-streaming parser
        if !response.http().status().is_success() && response.http().status().as_u16() != 200 {
            return None;
        }
        Some(crate::operation_deser::parse_get_object(response))
    }
    fn parse_loaded(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        // if streaming, we only hit this case if its an error
        crate::operation_deser::parse_get_object_error(response)
    }
}

/// Operation shape for `GetObjectAcl`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_object_acl`](crate::client::Client::get_object_acl).
///
/// See [`crate::client::fluent_builders::GetObjectAcl`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetObjectAcl {
    _private: (),
}
impl GetObjectAcl {
    /// Creates a new builder-style object to manufacture [`GetObjectAclInput`](crate::input::GetObjectAclInput)
    pub fn builder() -> crate::input::get_object_acl_input::Builder {
        crate::input::get_object_acl_input::Builder::default()
    }
    /// Creates a new `GetObjectAcl` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetObjectAcl {
    type Output =
        std::result::Result<crate::output::GetObjectAclOutput, crate::error::GetObjectAclError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_object_acl_error(response)
        } else {
            crate::operation_deser::parse_get_object_acl_response(response)
        }
    }
}

/// Operation shape for `GetObjectLegalHold`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_object_legal_hold`](crate::client::Client::get_object_legal_hold).
///
/// See [`crate::client::fluent_builders::GetObjectLegalHold`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetObjectLegalHold {
    _private: (),
}
impl GetObjectLegalHold {
    /// Creates a new builder-style object to manufacture [`GetObjectLegalHoldInput`](crate::input::GetObjectLegalHoldInput)
    pub fn builder() -> crate::input::get_object_legal_hold_input::Builder {
        crate::input::get_object_legal_hold_input::Builder::default()
    }
    /// Creates a new `GetObjectLegalHold` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetObjectLegalHold {
    type Output = std::result::Result<
        crate::output::GetObjectLegalHoldOutput,
        crate::error::GetObjectLegalHoldError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_object_legal_hold_error(response)
        } else {
            crate::operation_deser::parse_get_object_legal_hold_response(response)
        }
    }
}

/// Operation shape for `GetObjectLockConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_object_lock_configuration`](crate::client::Client::get_object_lock_configuration).
///
/// See [`crate::client::fluent_builders::GetObjectLockConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetObjectLockConfiguration {
    _private: (),
}
impl GetObjectLockConfiguration {
    /// Creates a new builder-style object to manufacture [`GetObjectLockConfigurationInput`](crate::input::GetObjectLockConfigurationInput)
    pub fn builder() -> crate::input::get_object_lock_configuration_input::Builder {
        crate::input::get_object_lock_configuration_input::Builder::default()
    }
    /// Creates a new `GetObjectLockConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetObjectLockConfiguration {
    type Output = std::result::Result<
        crate::output::GetObjectLockConfigurationOutput,
        crate::error::GetObjectLockConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_object_lock_configuration_error(response)
        } else {
            crate::operation_deser::parse_get_object_lock_configuration_response(response)
        }
    }
}

/// Operation shape for `GetObjectRetention`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_object_retention`](crate::client::Client::get_object_retention).
///
/// See [`crate::client::fluent_builders::GetObjectRetention`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetObjectRetention {
    _private: (),
}
impl GetObjectRetention {
    /// Creates a new builder-style object to manufacture [`GetObjectRetentionInput`](crate::input::GetObjectRetentionInput)
    pub fn builder() -> crate::input::get_object_retention_input::Builder {
        crate::input::get_object_retention_input::Builder::default()
    }
    /// Creates a new `GetObjectRetention` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetObjectRetention {
    type Output = std::result::Result<
        crate::output::GetObjectRetentionOutput,
        crate::error::GetObjectRetentionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_object_retention_error(response)
        } else {
            crate::operation_deser::parse_get_object_retention_response(response)
        }
    }
}

/// Operation shape for `GetObjectTagging`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_object_tagging`](crate::client::Client::get_object_tagging).
///
/// See [`crate::client::fluent_builders::GetObjectTagging`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetObjectTagging {
    _private: (),
}
impl GetObjectTagging {
    /// Creates a new builder-style object to manufacture [`GetObjectTaggingInput`](crate::input::GetObjectTaggingInput)
    pub fn builder() -> crate::input::get_object_tagging_input::Builder {
        crate::input::get_object_tagging_input::Builder::default()
    }
    /// Creates a new `GetObjectTagging` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetObjectTagging {
    type Output = std::result::Result<
        crate::output::GetObjectTaggingOutput,
        crate::error::GetObjectTaggingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_object_tagging_error(response)
        } else {
            crate::operation_deser::parse_get_object_tagging_response(response)
        }
    }
}

/// Operation shape for `GetObjectTorrent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_object_torrent`](crate::client::Client::get_object_torrent).
///
/// See [`crate::client::fluent_builders::GetObjectTorrent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetObjectTorrent {
    _private: (),
}
impl GetObjectTorrent {
    /// Creates a new builder-style object to manufacture [`GetObjectTorrentInput`](crate::input::GetObjectTorrentInput)
    pub fn builder() -> crate::input::get_object_torrent_input::Builder {
        crate::input::get_object_torrent_input::Builder::default()
    }
    /// Creates a new `GetObjectTorrent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseHttpResponse for GetObjectTorrent {
    type Output = std::result::Result<
        crate::output::GetObjectTorrentOutput,
        crate::error::GetObjectTorrentError,
    >;
    fn parse_unloaded(
        &self,
        response: &mut aws_smithy_http::operation::Response,
    ) -> Option<Self::Output> {
        // This is an error, defer to the non-streaming parser
        if !response.http().status().is_success() && response.http().status().as_u16() != 200 {
            return None;
        }
        Some(crate::operation_deser::parse_get_object_torrent(response))
    }
    fn parse_loaded(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        // if streaming, we only hit this case if its an error
        crate::operation_deser::parse_get_object_torrent_error(response)
    }
}

/// Operation shape for `GetPublicAccessBlock`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_public_access_block`](crate::client::Client::get_public_access_block).
///
/// See [`crate::client::fluent_builders::GetPublicAccessBlock`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPublicAccessBlock {
    _private: (),
}
impl GetPublicAccessBlock {
    /// Creates a new builder-style object to manufacture [`GetPublicAccessBlockInput`](crate::input::GetPublicAccessBlockInput)
    pub fn builder() -> crate::input::get_public_access_block_input::Builder {
        crate::input::get_public_access_block_input::Builder::default()
    }
    /// Creates a new `GetPublicAccessBlock` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPublicAccessBlock {
    type Output = std::result::Result<
        crate::output::GetPublicAccessBlockOutput,
        crate::error::GetPublicAccessBlockError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_public_access_block_error(response)
        } else {
            crate::operation_deser::parse_get_public_access_block_response(response)
        }
    }
}

/// Operation shape for `HeadBucket`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`head_bucket`](crate::client::Client::head_bucket).
///
/// See [`crate::client::fluent_builders::HeadBucket`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct HeadBucket {
    _private: (),
}
impl HeadBucket {
    /// Creates a new builder-style object to manufacture [`HeadBucketInput`](crate::input::HeadBucketInput)
    pub fn builder() -> crate::input::head_bucket_input::Builder {
        crate::input::head_bucket_input::Builder::default()
    }
    /// Creates a new `HeadBucket` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for HeadBucket {
    type Output =
        std::result::Result<crate::output::HeadBucketOutput, crate::error::HeadBucketError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_head_bucket_error(response)
        } else {
            crate::operation_deser::parse_head_bucket_response(response)
        }
    }
}
#[cfg(test)]
#[allow(unreachable_code, unused_variables)]
mod head_bucket_request_test {
    /// This test case validates https://github.com/awslabs/smithy-rs/issues/456
    /// Test ID: HeadObjectEmptyBody
    #[tokio::test]
    async fn head_object_empty_body_response() {
        let expected_output = crate::error::NotFound::builder().build();
        let http_response = http::response::Builder::new()
            .header("content-type", "application/xml")
            .header("date", "Thu, 03 Jun 2021 04:05:52 GMT")
            .header("server", "AmazonS3")
            .header(
                "x-amz-id-2",
                "UTniwu6QmCIjVeuK2ZfeWBOnu7SqMQOS3Vac6B/K4H2ZCawYUl+nDbhGTImuyhZ5DFiojR3Kcz4=",
            )
            .header("x-amz-request-id", "GRZ6BZ468DF52F2E")
            .status(404)
            .body(aws_smithy_http::body::SdkBody::from(""))
            .unwrap();
        let mut op_response = aws_smithy_http::operation::Response::new(http_response);
        use aws_smithy_http::response::ParseHttpResponse;
        let parser = crate::operation::HeadBucket::new();
        let parsed = parser.parse_unloaded(&mut op_response);
        let parsed = parsed.unwrap_or_else(|| {
                        let (http_response, _) = op_response.into_parts();
                        let http_response = http_response.map(|body|bytes::Bytes::copy_from_slice(body.bytes().unwrap()));
                        <crate::operation::HeadBucket as aws_smithy_http::response::ParseHttpResponse>::parse_loaded(&parser, &http_response)
                    });
        let parsed = parsed.expect_err("should be error response");
        if let crate::error::HeadBucketErrorKind::NotFound(actual_error) = parsed.kind {
            assert_eq!(expected_output, actual_error);
        } else {
            panic!(
                "wrong variant: Got: {:?}. Expected: {:?}",
                parsed, expected_output
            );
        }
    }
}

/// Operation shape for `HeadObject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`head_object`](crate::client::Client::head_object).
///
/// See [`crate::client::fluent_builders::HeadObject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct HeadObject {
    _private: (),
}
impl HeadObject {
    /// Creates a new builder-style object to manufacture [`HeadObjectInput`](crate::input::HeadObjectInput)
    pub fn builder() -> crate::input::head_object_input::Builder {
        crate::input::head_object_input::Builder::default()
    }
    /// Creates a new `HeadObject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for HeadObject {
    type Output =
        std::result::Result<crate::output::HeadObjectOutput, crate::error::HeadObjectError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_head_object_error(response)
        } else {
            crate::operation_deser::parse_head_object_response(response)
        }
    }
}
#[cfg(test)]
#[allow(unreachable_code, unused_variables)]
mod head_object_request_test {
    /// This test case validates https://github.com/awslabs/smithy-rs/issues/456
    /// Test ID: HeadObjectEmptyBody
    #[tokio::test]
    async fn head_object_empty_body_response() {
        let expected_output = crate::error::NotFound::builder().build();
        let http_response = http::response::Builder::new()
            .header("content-type", "application/xml")
            .header("date", "Thu, 03 Jun 2021 04:05:52 GMT")
            .header("server", "AmazonS3")
            .header(
                "x-amz-id-2",
                "UTniwu6QmCIjVeuK2ZfeWBOnu7SqMQOS3Vac6B/K4H2ZCawYUl+nDbhGTImuyhZ5DFiojR3Kcz4=",
            )
            .header("x-amz-request-id", "GRZ6BZ468DF52F2E")
            .status(404)
            .body(aws_smithy_http::body::SdkBody::from(""))
            .unwrap();
        let mut op_response = aws_smithy_http::operation::Response::new(http_response);
        use aws_smithy_http::response::ParseHttpResponse;
        let parser = crate::operation::HeadObject::new();
        let parsed = parser.parse_unloaded(&mut op_response);
        let parsed = parsed.unwrap_or_else(|| {
                        let (http_response, _) = op_response.into_parts();
                        let http_response = http_response.map(|body|bytes::Bytes::copy_from_slice(body.bytes().unwrap()));
                        <crate::operation::HeadObject as aws_smithy_http::response::ParseHttpResponse>::parse_loaded(&parser, &http_response)
                    });
        let parsed = parsed.expect_err("should be error response");
        if let crate::error::HeadObjectErrorKind::NotFound(actual_error) = parsed.kind {
            assert_eq!(expected_output, actual_error);
        } else {
            panic!(
                "wrong variant: Got: {:?}. Expected: {:?}",
                parsed, expected_output
            );
        }
    }
}

/// Operation shape for `ListBucketAnalyticsConfigurations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_bucket_analytics_configurations`](crate::client::Client::list_bucket_analytics_configurations).
///
/// See [`crate::client::fluent_builders::ListBucketAnalyticsConfigurations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBucketAnalyticsConfigurations {
    _private: (),
}
impl ListBucketAnalyticsConfigurations {
    /// Creates a new builder-style object to manufacture [`ListBucketAnalyticsConfigurationsInput`](crate::input::ListBucketAnalyticsConfigurationsInput)
    pub fn builder() -> crate::input::list_bucket_analytics_configurations_input::Builder {
        crate::input::list_bucket_analytics_configurations_input::Builder::default()
    }
    /// Creates a new `ListBucketAnalyticsConfigurations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBucketAnalyticsConfigurations {
    type Output = std::result::Result<
        crate::output::ListBucketAnalyticsConfigurationsOutput,
        crate::error::ListBucketAnalyticsConfigurationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_bucket_analytics_configurations_error(response)
        } else {
            crate::operation_deser::parse_list_bucket_analytics_configurations_response(response)
        }
    }
}

/// Operation shape for `ListBucketIntelligentTieringConfigurations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_bucket_intelligent_tiering_configurations`](crate::client::Client::list_bucket_intelligent_tiering_configurations).
///
/// See [`crate::client::fluent_builders::ListBucketIntelligentTieringConfigurations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBucketIntelligentTieringConfigurations {
    _private: (),
}
impl ListBucketIntelligentTieringConfigurations {
    /// Creates a new builder-style object to manufacture [`ListBucketIntelligentTieringConfigurationsInput`](crate::input::ListBucketIntelligentTieringConfigurationsInput)
    pub fn builder() -> crate::input::list_bucket_intelligent_tiering_configurations_input::Builder
    {
        crate::input::list_bucket_intelligent_tiering_configurations_input::Builder::default()
    }
    /// Creates a new `ListBucketIntelligentTieringConfigurations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBucketIntelligentTieringConfigurations {
    type Output = std::result::Result<
        crate::output::ListBucketIntelligentTieringConfigurationsOutput,
        crate::error::ListBucketIntelligentTieringConfigurationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_bucket_intelligent_tiering_configurations_error(
                response,
            )
        } else {
            crate::operation_deser::parse_list_bucket_intelligent_tiering_configurations_response(
                response,
            )
        }
    }
}

/// Operation shape for `ListBucketInventoryConfigurations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_bucket_inventory_configurations`](crate::client::Client::list_bucket_inventory_configurations).
///
/// See [`crate::client::fluent_builders::ListBucketInventoryConfigurations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBucketInventoryConfigurations {
    _private: (),
}
impl ListBucketInventoryConfigurations {
    /// Creates a new builder-style object to manufacture [`ListBucketInventoryConfigurationsInput`](crate::input::ListBucketInventoryConfigurationsInput)
    pub fn builder() -> crate::input::list_bucket_inventory_configurations_input::Builder {
        crate::input::list_bucket_inventory_configurations_input::Builder::default()
    }
    /// Creates a new `ListBucketInventoryConfigurations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBucketInventoryConfigurations {
    type Output = std::result::Result<
        crate::output::ListBucketInventoryConfigurationsOutput,
        crate::error::ListBucketInventoryConfigurationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_bucket_inventory_configurations_error(response)
        } else {
            crate::operation_deser::parse_list_bucket_inventory_configurations_response(response)
        }
    }
}

/// Operation shape for `ListBucketMetricsConfigurations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_bucket_metrics_configurations`](crate::client::Client::list_bucket_metrics_configurations).
///
/// See [`crate::client::fluent_builders::ListBucketMetricsConfigurations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBucketMetricsConfigurations {
    _private: (),
}
impl ListBucketMetricsConfigurations {
    /// Creates a new builder-style object to manufacture [`ListBucketMetricsConfigurationsInput`](crate::input::ListBucketMetricsConfigurationsInput)
    pub fn builder() -> crate::input::list_bucket_metrics_configurations_input::Builder {
        crate::input::list_bucket_metrics_configurations_input::Builder::default()
    }
    /// Creates a new `ListBucketMetricsConfigurations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBucketMetricsConfigurations {
    type Output = std::result::Result<
        crate::output::ListBucketMetricsConfigurationsOutput,
        crate::error::ListBucketMetricsConfigurationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_bucket_metrics_configurations_error(response)
        } else {
            crate::operation_deser::parse_list_bucket_metrics_configurations_response(response)
        }
    }
}

/// Operation shape for `ListBuckets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_buckets`](crate::client::Client::list_buckets).
///
/// See [`crate::client::fluent_builders::ListBuckets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBuckets {
    _private: (),
}
impl ListBuckets {
    /// Creates a new builder-style object to manufacture [`ListBucketsInput`](crate::input::ListBucketsInput)
    pub fn builder() -> crate::input::list_buckets_input::Builder {
        crate::input::list_buckets_input::Builder::default()
    }
    /// Creates a new `ListBuckets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBuckets {
    type Output =
        std::result::Result<crate::output::ListBucketsOutput, crate::error::ListBucketsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_buckets_error(response)
        } else {
            crate::operation_deser::parse_list_buckets_response(response)
        }
    }
}

/// Operation shape for `ListMultipartUploads`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_multipart_uploads`](crate::client::Client::list_multipart_uploads).
///
/// See [`crate::client::fluent_builders::ListMultipartUploads`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListMultipartUploads {
    _private: (),
}
impl ListMultipartUploads {
    /// Creates a new builder-style object to manufacture [`ListMultipartUploadsInput`](crate::input::ListMultipartUploadsInput)
    pub fn builder() -> crate::input::list_multipart_uploads_input::Builder {
        crate::input::list_multipart_uploads_input::Builder::default()
    }
    /// Creates a new `ListMultipartUploads` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListMultipartUploads {
    type Output = std::result::Result<
        crate::output::ListMultipartUploadsOutput,
        crate::error::ListMultipartUploadsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_multipart_uploads_error(response)
        } else {
            crate::operation_deser::parse_list_multipart_uploads_response(response)
        }
    }
}

/// Operation shape for `ListObjects`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_objects`](crate::client::Client::list_objects).
///
/// See [`crate::client::fluent_builders::ListObjects`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListObjects {
    _private: (),
}
impl ListObjects {
    /// Creates a new builder-style object to manufacture [`ListObjectsInput`](crate::input::ListObjectsInput)
    pub fn builder() -> crate::input::list_objects_input::Builder {
        crate::input::list_objects_input::Builder::default()
    }
    /// Creates a new `ListObjects` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListObjects {
    type Output =
        std::result::Result<crate::output::ListObjectsOutput, crate::error::ListObjectsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_objects_error(response)
        } else {
            crate::operation_deser::parse_list_objects_response(response)
        }
    }
}
#[cfg(test)]
#[allow(unreachable_code, unused_variables)]
mod list_objects_request_test {
    /// This test validates that parsing respects whitespace
    /// Test ID: KeysWithWhitespace
    #[tokio::test]
    async fn keys_with_whitespace_response() {
        let expected_output = crate::output::ListObjectsOutput::builder()
            .set_max_keys(Some(1000))
            .set_is_truncated(Some(false))
            .set_marker(Some("".to_string()))
            .set_name(Some("bucketname".to_string()))
            .set_prefix(Some("".to_string()))
            .set_contents(Some(vec![
                crate::model::Object::builder()
                    .set_key(Some("    ".to_string()))
                    .set_last_modified(Some(aws_smithy_types::Instant::from_epoch_seconds(
                        1626452453,
                    )))
                    .set_e_tag(Some("\"etag123\"".to_string()))
                    .set_size(Some(0))
                    .set_owner(Some(
                        crate::model::Owner::builder()
                            .set_id(Some("owner".to_string()))
                            .build(),
                    ))
                    .set_storage_class(Some(crate::model::ObjectStorageClass::from("STANDARD")))
                    .build(),
                crate::model::Object::builder()
                    .set_key(Some(" a ".to_string()))
                    .set_last_modified(Some(aws_smithy_types::Instant::from_epoch_seconds(
                        1626451330,
                    )))
                    .set_e_tag(Some("\"etag123\"".to_string()))
                    .set_size(Some(0))
                    .set_owner(Some(
                        crate::model::Owner::builder()
                            .set_id(Some("owner".to_string()))
                            .build(),
                    ))
                    .set_storage_class(Some(crate::model::ObjectStorageClass::from("STANDARD")))
                    .build(),
            ]))
            .build();
        let http_response = http::response::Builder::new()
        .status(200)
                        .body(aws_smithy_http::body::SdkBody::from("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n<ListBucketResult\n\txmlns=\"http://s3.amazonaws.com/doc/2006-03-01/\">\n\t<Name>bucketname</Name>\n\t<Prefix></Prefix>\n\t<Marker></Marker>\n\t<MaxKeys>1000</MaxKeys>\n\t<IsTruncated>false</IsTruncated>\n\t<Contents>\n\t\t<Key>    </Key>\n\t\t<LastModified>2021-07-16T16:20:53.000Z</LastModified>\n\t\t<ETag>&quot;etag123&quot;</ETag>\n\t\t<Size>0</Size>\n\t\t<Owner>\n\t\t\t<ID>owner</ID>\n\t\t</Owner>\n\t\t<StorageClass>STANDARD</StorageClass>\n\t</Contents>\n\t<Contents>\n\t\t<Key> a </Key>\n\t\t<LastModified>2021-07-16T16:02:10.000Z</LastModified>\n\t\t<ETag>&quot;etag123&quot;</ETag>\n\t\t<Size>0</Size>\n\t\t<Owner>\n\t\t\t<ID>owner</ID>\n\t\t</Owner>\n\t\t<StorageClass>STANDARD</StorageClass>\n\t</Contents>\n</ListBucketResult>\n"))
                        .unwrap();
        let mut op_response = aws_smithy_http::operation::Response::new(http_response);
        use aws_smithy_http::response::ParseHttpResponse;
        let parser = crate::operation::ListObjects::new();
        let parsed = parser.parse_unloaded(&mut op_response);
        let parsed = parsed.unwrap_or_else(|| {
                        let (http_response, _) = op_response.into_parts();
                        let http_response = http_response.map(|body|bytes::Bytes::copy_from_slice(body.bytes().unwrap()));
                        <crate::operation::ListObjects as aws_smithy_http::response::ParseHttpResponse>::parse_loaded(&parser, &http_response)
                    });
        let parsed = parsed.unwrap();
        assert_eq!(
            parsed.is_truncated, expected_output.is_truncated,
            "Unexpected value for `is_truncated`"
        );
        assert_eq!(
            parsed.marker, expected_output.marker,
            "Unexpected value for `marker`"
        );
        assert_eq!(
            parsed.next_marker, expected_output.next_marker,
            "Unexpected value for `next_marker`"
        );
        assert_eq!(
            parsed.contents, expected_output.contents,
            "Unexpected value for `contents`"
        );
        assert_eq!(
            parsed.name, expected_output.name,
            "Unexpected value for `name`"
        );
        assert_eq!(
            parsed.prefix, expected_output.prefix,
            "Unexpected value for `prefix`"
        );
        assert_eq!(
            parsed.delimiter, expected_output.delimiter,
            "Unexpected value for `delimiter`"
        );
        assert_eq!(
            parsed.max_keys, expected_output.max_keys,
            "Unexpected value for `max_keys`"
        );
        assert_eq!(
            parsed.common_prefixes, expected_output.common_prefixes,
            "Unexpected value for `common_prefixes`"
        );
        assert_eq!(
            parsed.encoding_type, expected_output.encoding_type,
            "Unexpected value for `encoding_type`"
        );
    }
}

/// Operation shape for `ListObjectsV2`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_objects_v2`](crate::client::Client::list_objects_v2).
///
/// See [`crate::client::fluent_builders::ListObjectsV2`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListObjectsV2 {
    _private: (),
}
impl ListObjectsV2 {
    /// Creates a new builder-style object to manufacture [`ListObjectsV2Input`](crate::input::ListObjectsV2Input)
    pub fn builder() -> crate::input::list_objects_v2_input::Builder {
        crate::input::list_objects_v2_input::Builder::default()
    }
    /// Creates a new `ListObjectsV2` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListObjectsV2 {
    type Output =
        std::result::Result<crate::output::ListObjectsV2Output, crate::error::ListObjectsV2Error>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_objects_v2_error(response)
        } else {
            crate::operation_deser::parse_list_objects_v2_response(response)
        }
    }
}

/// Operation shape for `ListObjectVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_object_versions`](crate::client::Client::list_object_versions).
///
/// See [`crate::client::fluent_builders::ListObjectVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListObjectVersions {
    _private: (),
}
impl ListObjectVersions {
    /// Creates a new builder-style object to manufacture [`ListObjectVersionsInput`](crate::input::ListObjectVersionsInput)
    pub fn builder() -> crate::input::list_object_versions_input::Builder {
        crate::input::list_object_versions_input::Builder::default()
    }
    /// Creates a new `ListObjectVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListObjectVersions {
    type Output = std::result::Result<
        crate::output::ListObjectVersionsOutput,
        crate::error::ListObjectVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_object_versions_error(response)
        } else {
            crate::operation_deser::parse_list_object_versions_response(response)
        }
    }
}

/// Operation shape for `ListParts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_parts`](crate::client::Client::list_parts).
///
/// See [`crate::client::fluent_builders::ListParts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListParts {
    _private: (),
}
impl ListParts {
    /// Creates a new builder-style object to manufacture [`ListPartsInput`](crate::input::ListPartsInput)
    pub fn builder() -> crate::input::list_parts_input::Builder {
        crate::input::list_parts_input::Builder::default()
    }
    /// Creates a new `ListParts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListParts {
    type Output = std::result::Result<crate::output::ListPartsOutput, crate::error::ListPartsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_parts_error(response)
        } else {
            crate::operation_deser::parse_list_parts_response(response)
        }
    }
}

/// Operation shape for `PutBucketAccelerateConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_bucket_accelerate_configuration`](crate::client::Client::put_bucket_accelerate_configuration).
///
/// See [`crate::client::fluent_builders::PutBucketAccelerateConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutBucketAccelerateConfiguration {
    _private: (),
}
impl PutBucketAccelerateConfiguration {
    /// Creates a new builder-style object to manufacture [`PutBucketAccelerateConfigurationInput`](crate::input::PutBucketAccelerateConfigurationInput)
    pub fn builder() -> crate::input::put_bucket_accelerate_configuration_input::Builder {
        crate::input::put_bucket_accelerate_configuration_input::Builder::default()
    }
    /// Creates a new `PutBucketAccelerateConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutBucketAccelerateConfiguration {
    type Output = std::result::Result<
        crate::output::PutBucketAccelerateConfigurationOutput,
        crate::error::PutBucketAccelerateConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_bucket_accelerate_configuration_error(response)
        } else {
            crate::operation_deser::parse_put_bucket_accelerate_configuration_response(response)
        }
    }
}

/// Operation shape for `PutBucketAcl`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_bucket_acl`](crate::client::Client::put_bucket_acl).
///
/// See [`crate::client::fluent_builders::PutBucketAcl`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutBucketAcl {
    _private: (),
}
impl PutBucketAcl {
    /// Creates a new builder-style object to manufacture [`PutBucketAclInput`](crate::input::PutBucketAclInput)
    pub fn builder() -> crate::input::put_bucket_acl_input::Builder {
        crate::input::put_bucket_acl_input::Builder::default()
    }
    /// Creates a new `PutBucketAcl` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutBucketAcl {
    type Output =
        std::result::Result<crate::output::PutBucketAclOutput, crate::error::PutBucketAclError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_bucket_acl_error(response)
        } else {
            crate::operation_deser::parse_put_bucket_acl_response(response)
        }
    }
}

/// Operation shape for `PutBucketAnalyticsConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_bucket_analytics_configuration`](crate::client::Client::put_bucket_analytics_configuration).
///
/// See [`crate::client::fluent_builders::PutBucketAnalyticsConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutBucketAnalyticsConfiguration {
    _private: (),
}
impl PutBucketAnalyticsConfiguration {
    /// Creates a new builder-style object to manufacture [`PutBucketAnalyticsConfigurationInput`](crate::input::PutBucketAnalyticsConfigurationInput)
    pub fn builder() -> crate::input::put_bucket_analytics_configuration_input::Builder {
        crate::input::put_bucket_analytics_configuration_input::Builder::default()
    }
    /// Creates a new `PutBucketAnalyticsConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutBucketAnalyticsConfiguration {
    type Output = std::result::Result<
        crate::output::PutBucketAnalyticsConfigurationOutput,
        crate::error::PutBucketAnalyticsConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_bucket_analytics_configuration_error(response)
        } else {
            crate::operation_deser::parse_put_bucket_analytics_configuration_response(response)
        }
    }
}

/// Operation shape for `PutBucketCors`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_bucket_cors`](crate::client::Client::put_bucket_cors).
///
/// See [`crate::client::fluent_builders::PutBucketCors`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutBucketCors {
    _private: (),
}
impl PutBucketCors {
    /// Creates a new builder-style object to manufacture [`PutBucketCorsInput`](crate::input::PutBucketCorsInput)
    pub fn builder() -> crate::input::put_bucket_cors_input::Builder {
        crate::input::put_bucket_cors_input::Builder::default()
    }
    /// Creates a new `PutBucketCors` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutBucketCors {
    type Output =
        std::result::Result<crate::output::PutBucketCorsOutput, crate::error::PutBucketCorsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_bucket_cors_error(response)
        } else {
            crate::operation_deser::parse_put_bucket_cors_response(response)
        }
    }
}

/// Operation shape for `PutBucketEncryption`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_bucket_encryption`](crate::client::Client::put_bucket_encryption).
///
/// See [`crate::client::fluent_builders::PutBucketEncryption`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutBucketEncryption {
    _private: (),
}
impl PutBucketEncryption {
    /// Creates a new builder-style object to manufacture [`PutBucketEncryptionInput`](crate::input::PutBucketEncryptionInput)
    pub fn builder() -> crate::input::put_bucket_encryption_input::Builder {
        crate::input::put_bucket_encryption_input::Builder::default()
    }
    /// Creates a new `PutBucketEncryption` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutBucketEncryption {
    type Output = std::result::Result<
        crate::output::PutBucketEncryptionOutput,
        crate::error::PutBucketEncryptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_bucket_encryption_error(response)
        } else {
            crate::operation_deser::parse_put_bucket_encryption_response(response)
        }
    }
}

/// Operation shape for `PutBucketIntelligentTieringConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_bucket_intelligent_tiering_configuration`](crate::client::Client::put_bucket_intelligent_tiering_configuration).
///
/// See [`crate::client::fluent_builders::PutBucketIntelligentTieringConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutBucketIntelligentTieringConfiguration {
    _private: (),
}
impl PutBucketIntelligentTieringConfiguration {
    /// Creates a new builder-style object to manufacture [`PutBucketIntelligentTieringConfigurationInput`](crate::input::PutBucketIntelligentTieringConfigurationInput)
    pub fn builder() -> crate::input::put_bucket_intelligent_tiering_configuration_input::Builder {
        crate::input::put_bucket_intelligent_tiering_configuration_input::Builder::default()
    }
    /// Creates a new `PutBucketIntelligentTieringConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutBucketIntelligentTieringConfiguration {
    type Output = std::result::Result<
        crate::output::PutBucketIntelligentTieringConfigurationOutput,
        crate::error::PutBucketIntelligentTieringConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_bucket_intelligent_tiering_configuration_error(
                response,
            )
        } else {
            crate::operation_deser::parse_put_bucket_intelligent_tiering_configuration_response(
                response,
            )
        }
    }
}

/// Operation shape for `PutBucketInventoryConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_bucket_inventory_configuration`](crate::client::Client::put_bucket_inventory_configuration).
///
/// See [`crate::client::fluent_builders::PutBucketInventoryConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutBucketInventoryConfiguration {
    _private: (),
}
impl PutBucketInventoryConfiguration {
    /// Creates a new builder-style object to manufacture [`PutBucketInventoryConfigurationInput`](crate::input::PutBucketInventoryConfigurationInput)
    pub fn builder() -> crate::input::put_bucket_inventory_configuration_input::Builder {
        crate::input::put_bucket_inventory_configuration_input::Builder::default()
    }
    /// Creates a new `PutBucketInventoryConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutBucketInventoryConfiguration {
    type Output = std::result::Result<
        crate::output::PutBucketInventoryConfigurationOutput,
        crate::error::PutBucketInventoryConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_bucket_inventory_configuration_error(response)
        } else {
            crate::operation_deser::parse_put_bucket_inventory_configuration_response(response)
        }
    }
}

/// Operation shape for `PutBucketLifecycleConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_bucket_lifecycle_configuration`](crate::client::Client::put_bucket_lifecycle_configuration).
///
/// See [`crate::client::fluent_builders::PutBucketLifecycleConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutBucketLifecycleConfiguration {
    _private: (),
}
impl PutBucketLifecycleConfiguration {
    /// Creates a new builder-style object to manufacture [`PutBucketLifecycleConfigurationInput`](crate::input::PutBucketLifecycleConfigurationInput)
    pub fn builder() -> crate::input::put_bucket_lifecycle_configuration_input::Builder {
        crate::input::put_bucket_lifecycle_configuration_input::Builder::default()
    }
    /// Creates a new `PutBucketLifecycleConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutBucketLifecycleConfiguration {
    type Output = std::result::Result<
        crate::output::PutBucketLifecycleConfigurationOutput,
        crate::error::PutBucketLifecycleConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_bucket_lifecycle_configuration_error(response)
        } else {
            crate::operation_deser::parse_put_bucket_lifecycle_configuration_response(response)
        }
    }
}
#[cfg(test)]
#[allow(unreachable_code, unused_variables)]
mod put_bucket_lifecycle_configuration_request_test {
    /// This test validates that the content md5 header is set correctly
    /// Test ID: PutBucketLifecycleConfiguration
    #[tokio::test]
    async fn put_bucket_lifecycle_configuration_request() {
        let config = crate::config::Config::builder().build();
        let input = crate::input::PutBucketLifecycleConfigurationInput::builder()
            .set_bucket(Some("test-bucket".to_string()))
            .set_lifecycle_configuration(Some(
                crate::model::BucketLifecycleConfiguration::builder()
                    .set_rules(Some(vec![crate::model::LifecycleRule::builder()
                        .set_expiration(Some(
                            crate::model::LifecycleExpiration::builder()
                                .set_days(Some(1))
                                .build(),
                        ))
                        .set_status(Some(crate::model::ExpirationStatus::from("Enabled")))
                        .set_id(Some("Expire".to_string()))
                        .build()]))
                    .build(),
            ))
            .build()
            .unwrap()
            .make_operation(&config)
            .expect("operation failed to build");
        let (http_request, parts) = input.into_request_response().0.into_parts();
        assert_eq!(http_request.method(), "PUT");
        assert_eq!(http_request.uri().path(), "/test-bucket");
        let expected_headers = &[("content-md5", "sUu+uAZPkTtAxJdaA+9uSg==")];
        aws_smithy_protocol_test::assert_ok(aws_smithy_protocol_test::validate_headers(
            &http_request,
            expected_headers,
        ));
        let body = http_request.body().bytes().expect("body should be strict");
        aws_smithy_protocol_test::assert_ok(
        aws_smithy_protocol_test::validate_body(&body, "<LifecycleConfiguration xmlns=\"http://s3.amazonaws.com/doc/2006-03-01/\">\n    <Rule xmlns=\"http://s3.amazonaws.com/doc/2006-03-01/\">\n        <Expiration xmlns=\"http://s3.amazonaws.com/doc/2006-03-01/\">\n            <Days xmlns=\"http://s3.amazonaws.com/doc/2006-03-01/\">1</Days>\n        </Expiration>\n        <ID xmlns=\"http://s3.amazonaws.com/doc/2006-03-01/\">Expire</ID>\n        <Status xmlns=\"http://s3.amazonaws.com/doc/2006-03-01/\">Enabled</Status>\n    </Rule>\n</LifecycleConfiguration>\n", aws_smithy_protocol_test::MediaType::from("application/xml"))
        );
    }
}

/// Operation shape for `PutBucketLogging`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_bucket_logging`](crate::client::Client::put_bucket_logging).
///
/// See [`crate::client::fluent_builders::PutBucketLogging`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutBucketLogging {
    _private: (),
}
impl PutBucketLogging {
    /// Creates a new builder-style object to manufacture [`PutBucketLoggingInput`](crate::input::PutBucketLoggingInput)
    pub fn builder() -> crate::input::put_bucket_logging_input::Builder {
        crate::input::put_bucket_logging_input::Builder::default()
    }
    /// Creates a new `PutBucketLogging` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutBucketLogging {
    type Output = std::result::Result<
        crate::output::PutBucketLoggingOutput,
        crate::error::PutBucketLoggingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_bucket_logging_error(response)
        } else {
            crate::operation_deser::parse_put_bucket_logging_response(response)
        }
    }
}

/// Operation shape for `PutBucketMetricsConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_bucket_metrics_configuration`](crate::client::Client::put_bucket_metrics_configuration).
///
/// See [`crate::client::fluent_builders::PutBucketMetricsConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutBucketMetricsConfiguration {
    _private: (),
}
impl PutBucketMetricsConfiguration {
    /// Creates a new builder-style object to manufacture [`PutBucketMetricsConfigurationInput`](crate::input::PutBucketMetricsConfigurationInput)
    pub fn builder() -> crate::input::put_bucket_metrics_configuration_input::Builder {
        crate::input::put_bucket_metrics_configuration_input::Builder::default()
    }
    /// Creates a new `PutBucketMetricsConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutBucketMetricsConfiguration {
    type Output = std::result::Result<
        crate::output::PutBucketMetricsConfigurationOutput,
        crate::error::PutBucketMetricsConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_bucket_metrics_configuration_error(response)
        } else {
            crate::operation_deser::parse_put_bucket_metrics_configuration_response(response)
        }
    }
}

/// Operation shape for `PutBucketNotificationConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_bucket_notification_configuration`](crate::client::Client::put_bucket_notification_configuration).
///
/// See [`crate::client::fluent_builders::PutBucketNotificationConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutBucketNotificationConfiguration {
    _private: (),
}
impl PutBucketNotificationConfiguration {
    /// Creates a new builder-style object to manufacture [`PutBucketNotificationConfigurationInput`](crate::input::PutBucketNotificationConfigurationInput)
    pub fn builder() -> crate::input::put_bucket_notification_configuration_input::Builder {
        crate::input::put_bucket_notification_configuration_input::Builder::default()
    }
    /// Creates a new `PutBucketNotificationConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutBucketNotificationConfiguration {
    type Output = std::result::Result<
        crate::output::PutBucketNotificationConfigurationOutput,
        crate::error::PutBucketNotificationConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_bucket_notification_configuration_error(response)
        } else {
            crate::operation_deser::parse_put_bucket_notification_configuration_response(response)
        }
    }
}

/// Operation shape for `PutBucketOwnershipControls`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_bucket_ownership_controls`](crate::client::Client::put_bucket_ownership_controls).
///
/// See [`crate::client::fluent_builders::PutBucketOwnershipControls`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutBucketOwnershipControls {
    _private: (),
}
impl PutBucketOwnershipControls {
    /// Creates a new builder-style object to manufacture [`PutBucketOwnershipControlsInput`](crate::input::PutBucketOwnershipControlsInput)
    pub fn builder() -> crate::input::put_bucket_ownership_controls_input::Builder {
        crate::input::put_bucket_ownership_controls_input::Builder::default()
    }
    /// Creates a new `PutBucketOwnershipControls` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutBucketOwnershipControls {
    type Output = std::result::Result<
        crate::output::PutBucketOwnershipControlsOutput,
        crate::error::PutBucketOwnershipControlsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_bucket_ownership_controls_error(response)
        } else {
            crate::operation_deser::parse_put_bucket_ownership_controls_response(response)
        }
    }
}

/// Operation shape for `PutBucketPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_bucket_policy`](crate::client::Client::put_bucket_policy).
///
/// See [`crate::client::fluent_builders::PutBucketPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutBucketPolicy {
    _private: (),
}
impl PutBucketPolicy {
    /// Creates a new builder-style object to manufacture [`PutBucketPolicyInput`](crate::input::PutBucketPolicyInput)
    pub fn builder() -> crate::input::put_bucket_policy_input::Builder {
        crate::input::put_bucket_policy_input::Builder::default()
    }
    /// Creates a new `PutBucketPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutBucketPolicy {
    type Output = std::result::Result<
        crate::output::PutBucketPolicyOutput,
        crate::error::PutBucketPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_bucket_policy_error(response)
        } else {
            crate::operation_deser::parse_put_bucket_policy_response(response)
        }
    }
}

/// Operation shape for `PutBucketReplication`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_bucket_replication`](crate::client::Client::put_bucket_replication).
///
/// See [`crate::client::fluent_builders::PutBucketReplication`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutBucketReplication {
    _private: (),
}
impl PutBucketReplication {
    /// Creates a new builder-style object to manufacture [`PutBucketReplicationInput`](crate::input::PutBucketReplicationInput)
    pub fn builder() -> crate::input::put_bucket_replication_input::Builder {
        crate::input::put_bucket_replication_input::Builder::default()
    }
    /// Creates a new `PutBucketReplication` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutBucketReplication {
    type Output = std::result::Result<
        crate::output::PutBucketReplicationOutput,
        crate::error::PutBucketReplicationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_bucket_replication_error(response)
        } else {
            crate::operation_deser::parse_put_bucket_replication_response(response)
        }
    }
}

/// Operation shape for `PutBucketRequestPayment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_bucket_request_payment`](crate::client::Client::put_bucket_request_payment).
///
/// See [`crate::client::fluent_builders::PutBucketRequestPayment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutBucketRequestPayment {
    _private: (),
}
impl PutBucketRequestPayment {
    /// Creates a new builder-style object to manufacture [`PutBucketRequestPaymentInput`](crate::input::PutBucketRequestPaymentInput)
    pub fn builder() -> crate::input::put_bucket_request_payment_input::Builder {
        crate::input::put_bucket_request_payment_input::Builder::default()
    }
    /// Creates a new `PutBucketRequestPayment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutBucketRequestPayment {
    type Output = std::result::Result<
        crate::output::PutBucketRequestPaymentOutput,
        crate::error::PutBucketRequestPaymentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_bucket_request_payment_error(response)
        } else {
            crate::operation_deser::parse_put_bucket_request_payment_response(response)
        }
    }
}

/// Operation shape for `PutBucketTagging`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_bucket_tagging`](crate::client::Client::put_bucket_tagging).
///
/// See [`crate::client::fluent_builders::PutBucketTagging`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutBucketTagging {
    _private: (),
}
impl PutBucketTagging {
    /// Creates a new builder-style object to manufacture [`PutBucketTaggingInput`](crate::input::PutBucketTaggingInput)
    pub fn builder() -> crate::input::put_bucket_tagging_input::Builder {
        crate::input::put_bucket_tagging_input::Builder::default()
    }
    /// Creates a new `PutBucketTagging` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutBucketTagging {
    type Output = std::result::Result<
        crate::output::PutBucketTaggingOutput,
        crate::error::PutBucketTaggingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_bucket_tagging_error(response)
        } else {
            crate::operation_deser::parse_put_bucket_tagging_response(response)
        }
    }
}

/// Operation shape for `PutBucketVersioning`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_bucket_versioning`](crate::client::Client::put_bucket_versioning).
///
/// See [`crate::client::fluent_builders::PutBucketVersioning`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutBucketVersioning {
    _private: (),
}
impl PutBucketVersioning {
    /// Creates a new builder-style object to manufacture [`PutBucketVersioningInput`](crate::input::PutBucketVersioningInput)
    pub fn builder() -> crate::input::put_bucket_versioning_input::Builder {
        crate::input::put_bucket_versioning_input::Builder::default()
    }
    /// Creates a new `PutBucketVersioning` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutBucketVersioning {
    type Output = std::result::Result<
        crate::output::PutBucketVersioningOutput,
        crate::error::PutBucketVersioningError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_bucket_versioning_error(response)
        } else {
            crate::operation_deser::parse_put_bucket_versioning_response(response)
        }
    }
}

/// Operation shape for `PutBucketWebsite`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_bucket_website`](crate::client::Client::put_bucket_website).
///
/// See [`crate::client::fluent_builders::PutBucketWebsite`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutBucketWebsite {
    _private: (),
}
impl PutBucketWebsite {
    /// Creates a new builder-style object to manufacture [`PutBucketWebsiteInput`](crate::input::PutBucketWebsiteInput)
    pub fn builder() -> crate::input::put_bucket_website_input::Builder {
        crate::input::put_bucket_website_input::Builder::default()
    }
    /// Creates a new `PutBucketWebsite` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutBucketWebsite {
    type Output = std::result::Result<
        crate::output::PutBucketWebsiteOutput,
        crate::error::PutBucketWebsiteError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_bucket_website_error(response)
        } else {
            crate::operation_deser::parse_put_bucket_website_response(response)
        }
    }
}

/// Operation shape for `PutObject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_object`](crate::client::Client::put_object).
///
/// See [`crate::client::fluent_builders::PutObject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutObject {
    _private: (),
}
impl PutObject {
    /// Creates a new builder-style object to manufacture [`PutObjectInput`](crate::input::PutObjectInput)
    pub fn builder() -> crate::input::put_object_input::Builder {
        crate::input::put_object_input::Builder::default()
    }
    /// Creates a new `PutObject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutObject {
    type Output = std::result::Result<crate::output::PutObjectOutput, crate::error::PutObjectError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_object_error(response)
        } else {
            crate::operation_deser::parse_put_object_response(response)
        }
    }
}
#[cfg(test)]
#[allow(unreachable_code, unused_variables)]
mod put_object_request_test {
    /// This test validates that if a content-type is specified, that only one content-type header is sent
    /// Test ID: DontSendDuplicateContentType
    #[tokio::test]
    async fn dont_send_duplicate_content_type_request() {
        let config = crate::config::Config::builder().build();
        let input = crate::input::PutObjectInput::builder()
            .set_bucket(Some("test-bucket".to_string()))
            .set_key(Some("test-key".to_string()))
            .set_content_type(Some("text/html".to_string()))
            .build()
            .unwrap()
            .make_operation(&config)
            .expect("operation failed to build");
        let (http_request, parts) = input.into_request_response().0.into_parts();
        assert_eq!(http_request.method(), "PUT");
        assert_eq!(http_request.uri().path(), "/test-bucket/test-key");
        let expected_headers = &[("content-type", "text/html")];
        aws_smithy_protocol_test::assert_ok(aws_smithy_protocol_test::validate_headers(
            &http_request,
            expected_headers,
        ));
    }
    /// This test validates that if a content-length is specified, that only one content-length header is sent
    /// Test ID: DontSendDuplicateContentLength
    #[tokio::test]
    async fn dont_send_duplicate_content_length_request() {
        let config = crate::config::Config::builder().build();
        let input = crate::input::PutObjectInput::builder()
            .set_bucket(Some("test-bucket".to_string()))
            .set_key(Some("test-key".to_string()))
            .set_content_length(Some(2))
            .set_body(Some(aws_smithy_http::byte_stream::ByteStream::from_static(
                b"ab",
            )))
            .build()
            .unwrap()
            .make_operation(&config)
            .expect("operation failed to build");
        let (http_request, parts) = input.into_request_response().0.into_parts();
        assert_eq!(http_request.method(), "PUT");
        assert_eq!(http_request.uri().path(), "/test-bucket/test-key");
        let expected_headers = &[("content-length", "2")];
        aws_smithy_protocol_test::assert_ok(aws_smithy_protocol_test::validate_headers(
            &http_request,
            expected_headers,
        ));
    }
}

/// Operation shape for `PutObjectAcl`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_object_acl`](crate::client::Client::put_object_acl).
///
/// See [`crate::client::fluent_builders::PutObjectAcl`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutObjectAcl {
    _private: (),
}
impl PutObjectAcl {
    /// Creates a new builder-style object to manufacture [`PutObjectAclInput`](crate::input::PutObjectAclInput)
    pub fn builder() -> crate::input::put_object_acl_input::Builder {
        crate::input::put_object_acl_input::Builder::default()
    }
    /// Creates a new `PutObjectAcl` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutObjectAcl {
    type Output =
        std::result::Result<crate::output::PutObjectAclOutput, crate::error::PutObjectAclError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_object_acl_error(response)
        } else {
            crate::operation_deser::parse_put_object_acl_response(response)
        }
    }
}

/// Operation shape for `PutObjectLegalHold`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_object_legal_hold`](crate::client::Client::put_object_legal_hold).
///
/// See [`crate::client::fluent_builders::PutObjectLegalHold`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutObjectLegalHold {
    _private: (),
}
impl PutObjectLegalHold {
    /// Creates a new builder-style object to manufacture [`PutObjectLegalHoldInput`](crate::input::PutObjectLegalHoldInput)
    pub fn builder() -> crate::input::put_object_legal_hold_input::Builder {
        crate::input::put_object_legal_hold_input::Builder::default()
    }
    /// Creates a new `PutObjectLegalHold` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutObjectLegalHold {
    type Output = std::result::Result<
        crate::output::PutObjectLegalHoldOutput,
        crate::error::PutObjectLegalHoldError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_object_legal_hold_error(response)
        } else {
            crate::operation_deser::parse_put_object_legal_hold_response(response)
        }
    }
}

/// Operation shape for `PutObjectLockConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_object_lock_configuration`](crate::client::Client::put_object_lock_configuration).
///
/// See [`crate::client::fluent_builders::PutObjectLockConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutObjectLockConfiguration {
    _private: (),
}
impl PutObjectLockConfiguration {
    /// Creates a new builder-style object to manufacture [`PutObjectLockConfigurationInput`](crate::input::PutObjectLockConfigurationInput)
    pub fn builder() -> crate::input::put_object_lock_configuration_input::Builder {
        crate::input::put_object_lock_configuration_input::Builder::default()
    }
    /// Creates a new `PutObjectLockConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutObjectLockConfiguration {
    type Output = std::result::Result<
        crate::output::PutObjectLockConfigurationOutput,
        crate::error::PutObjectLockConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_object_lock_configuration_error(response)
        } else {
            crate::operation_deser::parse_put_object_lock_configuration_response(response)
        }
    }
}

/// Operation shape for `PutObjectRetention`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_object_retention`](crate::client::Client::put_object_retention).
///
/// See [`crate::client::fluent_builders::PutObjectRetention`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutObjectRetention {
    _private: (),
}
impl PutObjectRetention {
    /// Creates a new builder-style object to manufacture [`PutObjectRetentionInput`](crate::input::PutObjectRetentionInput)
    pub fn builder() -> crate::input::put_object_retention_input::Builder {
        crate::input::put_object_retention_input::Builder::default()
    }
    /// Creates a new `PutObjectRetention` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutObjectRetention {
    type Output = std::result::Result<
        crate::output::PutObjectRetentionOutput,
        crate::error::PutObjectRetentionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_object_retention_error(response)
        } else {
            crate::operation_deser::parse_put_object_retention_response(response)
        }
    }
}

/// Operation shape for `PutObjectTagging`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_object_tagging`](crate::client::Client::put_object_tagging).
///
/// See [`crate::client::fluent_builders::PutObjectTagging`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutObjectTagging {
    _private: (),
}
impl PutObjectTagging {
    /// Creates a new builder-style object to manufacture [`PutObjectTaggingInput`](crate::input::PutObjectTaggingInput)
    pub fn builder() -> crate::input::put_object_tagging_input::Builder {
        crate::input::put_object_tagging_input::Builder::default()
    }
    /// Creates a new `PutObjectTagging` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutObjectTagging {
    type Output = std::result::Result<
        crate::output::PutObjectTaggingOutput,
        crate::error::PutObjectTaggingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_object_tagging_error(response)
        } else {
            crate::operation_deser::parse_put_object_tagging_response(response)
        }
    }
}

/// Operation shape for `PutPublicAccessBlock`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_public_access_block`](crate::client::Client::put_public_access_block).
///
/// See [`crate::client::fluent_builders::PutPublicAccessBlock`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutPublicAccessBlock {
    _private: (),
}
impl PutPublicAccessBlock {
    /// Creates a new builder-style object to manufacture [`PutPublicAccessBlockInput`](crate::input::PutPublicAccessBlockInput)
    pub fn builder() -> crate::input::put_public_access_block_input::Builder {
        crate::input::put_public_access_block_input::Builder::default()
    }
    /// Creates a new `PutPublicAccessBlock` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutPublicAccessBlock {
    type Output = std::result::Result<
        crate::output::PutPublicAccessBlockOutput,
        crate::error::PutPublicAccessBlockError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_public_access_block_error(response)
        } else {
            crate::operation_deser::parse_put_public_access_block_response(response)
        }
    }
}

/// Operation shape for `RestoreObject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`restore_object`](crate::client::Client::restore_object).
///
/// See [`crate::client::fluent_builders::RestoreObject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RestoreObject {
    _private: (),
}
impl RestoreObject {
    /// Creates a new builder-style object to manufacture [`RestoreObjectInput`](crate::input::RestoreObjectInput)
    pub fn builder() -> crate::input::restore_object_input::Builder {
        crate::input::restore_object_input::Builder::default()
    }
    /// Creates a new `RestoreObject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RestoreObject {
    type Output =
        std::result::Result<crate::output::RestoreObjectOutput, crate::error::RestoreObjectError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_restore_object_error(response)
        } else {
            crate::operation_deser::parse_restore_object_response(response)
        }
    }
}

/// Operation shape for `SelectObjectContent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`select_object_content`](crate::client::Client::select_object_content).
///
/// See [`crate::client::fluent_builders::SelectObjectContent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SelectObjectContent {
    _private: (),
}
impl SelectObjectContent {
    /// Creates a new builder-style object to manufacture [`SelectObjectContentInput`](crate::input::SelectObjectContentInput)
    pub fn builder() -> crate::input::select_object_content_input::Builder {
        crate::input::select_object_content_input::Builder::default()
    }
    /// Creates a new `SelectObjectContent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseHttpResponse for SelectObjectContent {
    type Output = std::result::Result<
        crate::output::SelectObjectContentOutput,
        crate::error::SelectObjectContentError,
    >;
    fn parse_unloaded(
        &self,
        response: &mut aws_smithy_http::operation::Response,
    ) -> Option<Self::Output> {
        // This is an error, defer to the non-streaming parser
        if !response.http().status().is_success() && response.http().status().as_u16() != 200 {
            return None;
        }
        Some(crate::operation_deser::parse_select_object_content(
            response,
        ))
    }
    fn parse_loaded(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        // if streaming, we only hit this case if its an error
        crate::operation_deser::parse_select_object_content_error(response)
    }
}

/// Operation shape for `UploadPart`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`upload_part`](crate::client::Client::upload_part).
///
/// See [`crate::client::fluent_builders::UploadPart`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UploadPart {
    _private: (),
}
impl UploadPart {
    /// Creates a new builder-style object to manufacture [`UploadPartInput`](crate::input::UploadPartInput)
    pub fn builder() -> crate::input::upload_part_input::Builder {
        crate::input::upload_part_input::Builder::default()
    }
    /// Creates a new `UploadPart` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UploadPart {
    type Output =
        std::result::Result<crate::output::UploadPartOutput, crate::error::UploadPartError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_upload_part_error(response)
        } else {
            crate::operation_deser::parse_upload_part_response(response)
        }
    }
}

/// Operation shape for `UploadPartCopy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`upload_part_copy`](crate::client::Client::upload_part_copy).
///
/// See [`crate::client::fluent_builders::UploadPartCopy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UploadPartCopy {
    _private: (),
}
impl UploadPartCopy {
    /// Creates a new builder-style object to manufacture [`UploadPartCopyInput`](crate::input::UploadPartCopyInput)
    pub fn builder() -> crate::input::upload_part_copy_input::Builder {
        crate::input::upload_part_copy_input::Builder::default()
    }
    /// Creates a new `UploadPartCopy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UploadPartCopy {
    type Output =
        std::result::Result<crate::output::UploadPartCopyOutput, crate::error::UploadPartCopyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_upload_part_copy_error(response)
        } else {
            crate::operation_deser::parse_upload_part_copy_response(response)
        }
    }
}

/// Operation shape for `WriteGetObjectResponse`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`write_get_object_response`](crate::client::Client::write_get_object_response).
///
/// See [`crate::client::fluent_builders::WriteGetObjectResponse`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct WriteGetObjectResponse {
    _private: (),
}
impl WriteGetObjectResponse {
    /// Creates a new builder-style object to manufacture [`WriteGetObjectResponseInput`](crate::input::WriteGetObjectResponseInput)
    pub fn builder() -> crate::input::write_get_object_response_input::Builder {
        crate::input::write_get_object_response_input::Builder::default()
    }
    /// Creates a new `WriteGetObjectResponse` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for WriteGetObjectResponse {
    type Output = std::result::Result<
        crate::output::WriteGetObjectResponseOutput,
        crate::error::WriteGetObjectResponseError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_write_get_object_response_error(response)
        } else {
            crate::operation_deser::parse_write_get_object_response_response(response)
        }
    }
}
