// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for CloudWatch RUM
///
/// Client for invoking operations on CloudWatch RUM. Each operation on CloudWatch RUM is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_rum::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_rum::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_rum::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CreateAppMonitor`](crate::client::fluent_builders::CreateAppMonitor) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateAppMonitor::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateAppMonitor::set_name): <p>A name for the app monitor.</p>
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::CreateAppMonitor::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::CreateAppMonitor::set_domain): <p>The top-level internet domain name for which your application has administrative authority.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateAppMonitor::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateAppMonitor::set_tags): <p>Assigns one or more tags (key-value pairs) to the app monitor.</p>  <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>  <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>  <p>You can associate as many as 50 tags with an app monitor.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
    ///   - [`app_monitor_configuration(AppMonitorConfiguration)`](crate::client::fluent_builders::CreateAppMonitor::app_monitor_configuration) / [`set_app_monitor_configuration(Option<AppMonitorConfiguration>)`](crate::client::fluent_builders::CreateAppMonitor::set_app_monitor_configuration): <p>A structure that contains much of the configuration data for the app monitor. If you are using Amazon Cognito for authorization, you must include this structure in your request, and it must include the ID of the Amazon Cognito identity pool to use for authorization. If you don't include <code>AppMonitorConfiguration</code>, you must set up your own authorization method. For more information, see <a href="https://docs.aws.amazon.com/monitoring/CloudWatch-RUM-get-started-authorization.html">Authorize your application to send data to Amazon Web Services</a>.</p>  <p>If you omit this argument, the sample rate used for RUM is set to 10% of the user sessions.</p>
    ///   - [`cw_log_enabled(bool)`](crate::client::fluent_builders::CreateAppMonitor::cw_log_enabled) / [`set_cw_log_enabled(Option<bool>)`](crate::client::fluent_builders::CreateAppMonitor::set_cw_log_enabled): <p>Data collected by RUM is kept by RUM for 30 days and then deleted. This parameter specifies whether RUM sends a copy of this telemetry data to Amazon CloudWatch Logs in your account. This enables you to keep the telemetry data for more than 30 days, but it does incur Amazon CloudWatch Logs charges.</p>  <p>If you omit this parameter, the default is <code>false</code>.</p>
    /// - On success, responds with [`CreateAppMonitorOutput`](crate::output::CreateAppMonitorOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::CreateAppMonitorOutput::id): <p>The unique ID of the new app monitor.</p>
    /// - On failure, responds with [`SdkError<CreateAppMonitorError>`](crate::error::CreateAppMonitorError)
    pub fn create_app_monitor(&self) -> fluent_builders::CreateAppMonitor {
        fluent_builders::CreateAppMonitor::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAppMonitor`](crate::client::fluent_builders::DeleteAppMonitor) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteAppMonitor::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteAppMonitor::set_name): <p>The name of the app monitor to delete.</p>
    /// - On success, responds with [`DeleteAppMonitorOutput`](crate::output::DeleteAppMonitorOutput)

    /// - On failure, responds with [`SdkError<DeleteAppMonitorError>`](crate::error::DeleteAppMonitorError)
    pub fn delete_app_monitor(&self) -> fluent_builders::DeleteAppMonitor {
        fluent_builders::DeleteAppMonitor::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAppMonitor`](crate::client::fluent_builders::GetAppMonitor) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetAppMonitor::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetAppMonitor::set_name): <p>The app monitor to retrieve information for.</p>
    /// - On success, responds with [`GetAppMonitorOutput`](crate::output::GetAppMonitorOutput) with field(s):
    ///   - [`app_monitor(Option<AppMonitor>)`](crate::output::GetAppMonitorOutput::app_monitor): <p>A structure containing all the configuration information for the app monitor.</p>
    /// - On failure, responds with [`SdkError<GetAppMonitorError>`](crate::error::GetAppMonitorError)
    pub fn get_app_monitor(&self) -> fluent_builders::GetAppMonitor {
        fluent_builders::GetAppMonitor::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAppMonitorData`](crate::client::fluent_builders::GetAppMonitorData) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetAppMonitorData::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetAppMonitorData::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetAppMonitorData::set_name): <p>The name of the app monitor that collected the data that you want to retrieve.</p>
    ///   - [`time_range(TimeRange)`](crate::client::fluent_builders::GetAppMonitorData::time_range) / [`set_time_range(Option<TimeRange>)`](crate::client::fluent_builders::GetAppMonitorData::set_time_range): <p>A structure that defines the time range that you want to retrieve results from.</p>
    ///   - [`filters(Vec<QueryFilter>)`](crate::client::fluent_builders::GetAppMonitorData::filters) / [`set_filters(Option<Vec<QueryFilter>>)`](crate::client::fluent_builders::GetAppMonitorData::set_filters): <p>An array of structures that you can use to filter the results to those that match one or more sets of key-value pairs that you specify.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetAppMonitorData::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::GetAppMonitorData::set_max_results): <p>The maximum number of results to return in one operation. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetAppMonitorData::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetAppMonitorData::set_next_token): <p>Use the token returned by the previous operation to request the next page of results.</p>
    /// - On success, responds with [`GetAppMonitorDataOutput`](crate::output::GetAppMonitorDataOutput) with field(s):
    ///   - [`events(Option<Vec<String>>)`](crate::output::GetAppMonitorDataOutput::events): <p>The events that RUM collected that match your request.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetAppMonitorDataOutput::next_token): <p>A token that you can use in a subsequent operation to retrieve the next set of results.</p>
    /// - On failure, responds with [`SdkError<GetAppMonitorDataError>`](crate::error::GetAppMonitorDataError)
    pub fn get_app_monitor_data(&self) -> fluent_builders::GetAppMonitorData {
        fluent_builders::GetAppMonitorData::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAppMonitors`](crate::client::fluent_builders::ListAppMonitors) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAppMonitors::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAppMonitors::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAppMonitors::set_max_results): <p>The maximum number of results to return in one operation. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAppMonitors::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAppMonitors::set_next_token): <p>Use the token returned by the previous operation to request the next page of results.</p>
    /// - On success, responds with [`ListAppMonitorsOutput`](crate::output::ListAppMonitorsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListAppMonitorsOutput::next_token): <p>A token that you can use in a subsequent operation to retrieve the next set of results.</p>
    ///   - [`app_monitor_summaries(Option<Vec<AppMonitorSummary>>)`](crate::output::ListAppMonitorsOutput::app_monitor_summaries): <p>An array of structures that contain information about the returned app monitors.</p>
    /// - On failure, responds with [`SdkError<ListAppMonitorsError>`](crate::error::ListAppMonitorsError)
    pub fn list_app_monitors(&self) -> fluent_builders::ListAppMonitors {
        fluent_builders::ListAppMonitors::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The ARN of the resource that you want to see the tags of.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`resource_arn(Option<String>)`](crate::output::ListTagsForResourceOutput::resource_arn): <p>The ARN of the resource that you are viewing.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The list of tag keys and values associated with the resource you specified.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutRumEvents`](crate::client::fluent_builders::PutRumEvents) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::PutRumEvents::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::PutRumEvents::set_id): <p>The ID of the app monitor that is sending this data.</p>
    ///   - [`batch_id(impl Into<String>)`](crate::client::fluent_builders::PutRumEvents::batch_id) / [`set_batch_id(Option<String>)`](crate::client::fluent_builders::PutRumEvents::set_batch_id): <p>A unique identifier for this batch of RUM event data.</p>
    ///   - [`app_monitor_details(AppMonitorDetails)`](crate::client::fluent_builders::PutRumEvents::app_monitor_details) / [`set_app_monitor_details(Option<AppMonitorDetails>)`](crate::client::fluent_builders::PutRumEvents::set_app_monitor_details): <p>A structure that contains information about the app monitor that collected this telemetry information.</p>
    ///   - [`user_details(UserDetails)`](crate::client::fluent_builders::PutRumEvents::user_details) / [`set_user_details(Option<UserDetails>)`](crate::client::fluent_builders::PutRumEvents::set_user_details): <p>A structure that contains information about the user session that this batch of events was collected from.</p>
    ///   - [`rum_events(Vec<RumEvent>)`](crate::client::fluent_builders::PutRumEvents::rum_events) / [`set_rum_events(Option<Vec<RumEvent>>)`](crate::client::fluent_builders::PutRumEvents::set_rum_events): <p>An array of structures that contain the telemetry event data.</p>
    /// - On success, responds with [`PutRumEventsOutput`](crate::output::PutRumEventsOutput)

    /// - On failure, responds with [`SdkError<PutRumEventsError>`](crate::error::PutRumEventsError)
    pub fn put_rum_events(&self) -> fluent_builders::PutRumEvents {
        fluent_builders::PutRumEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The ARN of the CloudWatch RUM resource that you're adding tags to.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The list of key-value pairs to associate with the resource.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The ARN of the CloudWatch RUM resource that you're removing tags from.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The list of tag keys to remove from the resource.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAppMonitor`](crate::client::fluent_builders::UpdateAppMonitor) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateAppMonitor::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateAppMonitor::set_name): <p>The name of the app monitor to update.</p>
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::UpdateAppMonitor::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::UpdateAppMonitor::set_domain): <p>The top-level internet domain name for which your application has administrative authority.</p>
    ///   - [`app_monitor_configuration(AppMonitorConfiguration)`](crate::client::fluent_builders::UpdateAppMonitor::app_monitor_configuration) / [`set_app_monitor_configuration(Option<AppMonitorConfiguration>)`](crate::client::fluent_builders::UpdateAppMonitor::set_app_monitor_configuration): <p>A structure that contains much of the configuration data for the app monitor. If you are using Amazon Cognito for authorization, you must include this structure in your request, and it must include the ID of the Amazon Cognito identity pool to use for authorization. If you don't include <code>AppMonitorConfiguration</code>, you must set up your own authorization method. For more information, see <a href="https://docs.aws.amazon.com/monitoring/CloudWatch-RUM-get-started-authorization.html">Authorize your application to send data to Amazon Web Services</a>.</p>
    ///   - [`cw_log_enabled(bool)`](crate::client::fluent_builders::UpdateAppMonitor::cw_log_enabled) / [`set_cw_log_enabled(Option<bool>)`](crate::client::fluent_builders::UpdateAppMonitor::set_cw_log_enabled): <p>Data collected by RUM is kept by RUM for 30 days and then deleted. This parameter specifies whether RUM sends a copy of this telemetry data to Amazon CloudWatch Logs in your account. This enables you to keep the telemetry data for more than 30 days, but it does incur Amazon CloudWatch Logs charges.</p>
    /// - On success, responds with [`UpdateAppMonitorOutput`](crate::output::UpdateAppMonitorOutput)

    /// - On failure, responds with [`SdkError<UpdateAppMonitorError>`](crate::error::UpdateAppMonitorError)
    pub fn update_app_monitor(&self) -> fluent_builders::UpdateAppMonitor {
        fluent_builders::UpdateAppMonitor::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateAppMonitor`.
    ///
    /// <p>Creates a Amazon CloudWatch RUM app monitor, which collects telemetry data from your application and sends that data to RUM. The data includes performance and reliability information such as page load time, client-side errors, and user behavior.</p>
    /// <p>You use this operation only to create a new app monitor. To update an existing app monitor, use <a href="https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_UpdateAppMonitor.html">UpdateAppMonitor</a> instead.</p>
    /// <p>After you create an app monitor, sign in to the CloudWatch RUM console to get the JavaScript code snippet to add to your web application. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-find-code-snippet.html">How do I find a code snippet that I've already generated?</a> </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAppMonitor {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_app_monitor_input::Builder,
    }
    impl CreateAppMonitor {
        /// Creates a new `CreateAppMonitor`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAppMonitorOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAppMonitorError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A name for the app monitor.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A name for the app monitor.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The top-level internet domain name for which your application has administrative authority.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>The top-level internet domain name for which your application has administrative authority.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Assigns one or more tags (key-value pairs) to the app monitor.</p>
        /// <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>
        /// <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>
        /// <p>You can associate as many as 50 tags with an app monitor.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Assigns one or more tags (key-value pairs) to the app monitor.</p>
        /// <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>
        /// <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>
        /// <p>You can associate as many as 50 tags with an app monitor.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A structure that contains much of the configuration data for the app monitor. If you are using Amazon Cognito for authorization, you must include this structure in your request, and it must include the ID of the Amazon Cognito identity pool to use for authorization. If you don't include <code>AppMonitorConfiguration</code>, you must set up your own authorization method. For more information, see <a href="https://docs.aws.amazon.com/monitoring/CloudWatch-RUM-get-started-authorization.html">Authorize your application to send data to Amazon Web Services</a>.</p>
        /// <p>If you omit this argument, the sample rate used for RUM is set to 10% of the user sessions.</p>
        pub fn app_monitor_configuration(
            mut self,
            input: crate::model::AppMonitorConfiguration,
        ) -> Self {
            self.inner = self.inner.app_monitor_configuration(input);
            self
        }
        /// <p>A structure that contains much of the configuration data for the app monitor. If you are using Amazon Cognito for authorization, you must include this structure in your request, and it must include the ID of the Amazon Cognito identity pool to use for authorization. If you don't include <code>AppMonitorConfiguration</code>, you must set up your own authorization method. For more information, see <a href="https://docs.aws.amazon.com/monitoring/CloudWatch-RUM-get-started-authorization.html">Authorize your application to send data to Amazon Web Services</a>.</p>
        /// <p>If you omit this argument, the sample rate used for RUM is set to 10% of the user sessions.</p>
        pub fn set_app_monitor_configuration(
            mut self,
            input: std::option::Option<crate::model::AppMonitorConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_app_monitor_configuration(input);
            self
        }
        /// <p>Data collected by RUM is kept by RUM for 30 days and then deleted. This parameter specifies whether RUM sends a copy of this telemetry data to Amazon CloudWatch Logs in your account. This enables you to keep the telemetry data for more than 30 days, but it does incur Amazon CloudWatch Logs charges.</p>
        /// <p>If you omit this parameter, the default is <code>false</code>.</p>
        pub fn cw_log_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.cw_log_enabled(input);
            self
        }
        /// <p>Data collected by RUM is kept by RUM for 30 days and then deleted. This parameter specifies whether RUM sends a copy of this telemetry data to Amazon CloudWatch Logs in your account. This enables you to keep the telemetry data for more than 30 days, but it does incur Amazon CloudWatch Logs charges.</p>
        /// <p>If you omit this parameter, the default is <code>false</code>.</p>
        pub fn set_cw_log_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_cw_log_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAppMonitor`.
    ///
    /// <p>Deletes an existing app monitor. This immediately stops the collection of data.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAppMonitor {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_app_monitor_input::Builder,
    }
    impl DeleteAppMonitor {
        /// Creates a new `DeleteAppMonitor`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAppMonitorOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAppMonitorError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the app monitor to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the app monitor to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAppMonitor`.
    ///
    /// <p>Retrieves the complete configuration information for one app monitor.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAppMonitor {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_app_monitor_input::Builder,
    }
    impl GetAppMonitor {
        /// Creates a new `GetAppMonitor`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAppMonitorOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAppMonitorError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The app monitor to retrieve information for.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The app monitor to retrieve information for.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAppMonitorData`.
    ///
    /// <p>Retrieves the raw performance events that RUM has collected from your web application, so that you can do your own processing or analysis of this data.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAppMonitorData {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_app_monitor_data_input::Builder,
    }
    impl GetAppMonitorData {
        /// Creates a new `GetAppMonitorData`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAppMonitorDataOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAppMonitorDataError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetAppMonitorDataPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetAppMonitorDataPaginator {
            crate::paginator::GetAppMonitorDataPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the app monitor that collected the data that you want to retrieve.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the app monitor that collected the data that you want to retrieve.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A structure that defines the time range that you want to retrieve results from.</p>
        pub fn time_range(mut self, input: crate::model::TimeRange) -> Self {
            self.inner = self.inner.time_range(input);
            self
        }
        /// <p>A structure that defines the time range that you want to retrieve results from.</p>
        pub fn set_time_range(
            mut self,
            input: std::option::Option<crate::model::TimeRange>,
        ) -> Self {
            self.inner = self.inner.set_time_range(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An array of structures that you can use to filter the results to those that match one or more sets of key-value pairs that you specify.</p>
        pub fn filters(mut self, input: crate::model::QueryFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>An array of structures that you can use to filter the results to those that match one or more sets of key-value pairs that you specify.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::QueryFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of results to return in one operation. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in one operation. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Use the token returned by the previous operation to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Use the token returned by the previous operation to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAppMonitors`.
    ///
    /// <p>Returns a list of the Amazon CloudWatch RUM app monitors in the account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAppMonitors {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_app_monitors_input::Builder,
    }
    impl ListAppMonitors {
        /// Creates a new `ListAppMonitors`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAppMonitorsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAppMonitorsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAppMonitorsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAppMonitorsPaginator {
            crate::paginator::ListAppMonitorsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of results to return in one operation. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in one operation. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Use the token returned by the previous operation to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Use the token returned by the previous operation to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Displays the tags associated with a CloudWatch RUM resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource that you want to see the tags of.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource that you want to see the tags of.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutRumEvents`.
    ///
    /// <p>Sends telemetry events about your application performance and user behavior to CloudWatch RUM. The code snippet that RUM generates for you to add to your application includes <code>PutRumEvents</code> operations to send this data to RUM.</p>
    /// <p>Each <code>PutRumEvents</code> operation can send a batch of events from one user session.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutRumEvents {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_rum_events_input::Builder,
    }
    impl PutRumEvents {
        /// Creates a new `PutRumEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutRumEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutRumEventsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the app monitor that is sending this data.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the app monitor that is sending this data.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>A unique identifier for this batch of RUM event data.</p>
        pub fn batch_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.batch_id(input.into());
            self
        }
        /// <p>A unique identifier for this batch of RUM event data.</p>
        pub fn set_batch_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_batch_id(input);
            self
        }
        /// <p>A structure that contains information about the app monitor that collected this telemetry information.</p>
        pub fn app_monitor_details(mut self, input: crate::model::AppMonitorDetails) -> Self {
            self.inner = self.inner.app_monitor_details(input);
            self
        }
        /// <p>A structure that contains information about the app monitor that collected this telemetry information.</p>
        pub fn set_app_monitor_details(
            mut self,
            input: std::option::Option<crate::model::AppMonitorDetails>,
        ) -> Self {
            self.inner = self.inner.set_app_monitor_details(input);
            self
        }
        /// <p>A structure that contains information about the user session that this batch of events was collected from.</p>
        pub fn user_details(mut self, input: crate::model::UserDetails) -> Self {
            self.inner = self.inner.user_details(input);
            self
        }
        /// <p>A structure that contains information about the user session that this batch of events was collected from.</p>
        pub fn set_user_details(
            mut self,
            input: std::option::Option<crate::model::UserDetails>,
        ) -> Self {
            self.inner = self.inner.set_user_details(input);
            self
        }
        /// Appends an item to `RumEvents`.
        ///
        /// To override the contents of this collection use [`set_rum_events`](Self::set_rum_events).
        ///
        /// <p>An array of structures that contain the telemetry event data.</p>
        pub fn rum_events(mut self, input: crate::model::RumEvent) -> Self {
            self.inner = self.inner.rum_events(input);
            self
        }
        /// <p>An array of structures that contain the telemetry event data.</p>
        pub fn set_rum_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RumEvent>>,
        ) -> Self {
            self.inner = self.inner.set_rum_events(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Assigns one or more tags (key-value pairs) to the specified CloudWatch RUM resource. Currently, the only resources that can be tagged app monitors.</p>
    /// <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>
    /// <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>
    /// <p>You can use the <code>TagResource</code> action with a resource that already has tags. If you specify a new tag key for the resource, this tag is appended to the list of tags associated with the alarm. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.</p>
    /// <p>You can associate as many as 50 tags with a resource.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the CloudWatch RUM resource that you're adding tags to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the CloudWatch RUM resource that you're adding tags to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of key-value pairs to associate with the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The list of key-value pairs to associate with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes one or more tags from the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the CloudWatch RUM resource that you're removing tags from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the CloudWatch RUM resource that you're removing tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of tag keys to remove from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The list of tag keys to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAppMonitor`.
    ///
    /// <p>Updates the configuration of an existing app monitor. When you use this operation, only the parts of the app monitor configuration that you specify in this operation are changed. For any parameters that you omit, the existing values are kept.</p>
    /// <p>You can't use this operation to change the tags of an existing app monitor. To change the tags of an existing app monitor, use <a href="https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_TagResource.html">TagResource</a>.</p>
    /// <p>To create a new app monitor, use <a href="https://docs.aws.amazon.com/cloudwatchrum/latest/APIReference/API_CreateAppMonitor.html">CreateAppMonitor</a>.</p>
    /// <p>After you update an app monitor, sign in to the CloudWatch RUM console to get the updated JavaScript code snippet to add to your web application. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-find-code-snippet.html">How do I find a code snippet that I've already generated?</a> </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAppMonitor {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_app_monitor_input::Builder,
    }
    impl UpdateAppMonitor {
        /// Creates a new `UpdateAppMonitor`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAppMonitorOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAppMonitorError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the app monitor to update.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the app monitor to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The top-level internet domain name for which your application has administrative authority.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>The top-level internet domain name for which your application has administrative authority.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>A structure that contains much of the configuration data for the app monitor. If you are using Amazon Cognito for authorization, you must include this structure in your request, and it must include the ID of the Amazon Cognito identity pool to use for authorization. If you don't include <code>AppMonitorConfiguration</code>, you must set up your own authorization method. For more information, see <a href="https://docs.aws.amazon.com/monitoring/CloudWatch-RUM-get-started-authorization.html">Authorize your application to send data to Amazon Web Services</a>.</p>
        pub fn app_monitor_configuration(
            mut self,
            input: crate::model::AppMonitorConfiguration,
        ) -> Self {
            self.inner = self.inner.app_monitor_configuration(input);
            self
        }
        /// <p>A structure that contains much of the configuration data for the app monitor. If you are using Amazon Cognito for authorization, you must include this structure in your request, and it must include the ID of the Amazon Cognito identity pool to use for authorization. If you don't include <code>AppMonitorConfiguration</code>, you must set up your own authorization method. For more information, see <a href="https://docs.aws.amazon.com/monitoring/CloudWatch-RUM-get-started-authorization.html">Authorize your application to send data to Amazon Web Services</a>.</p>
        pub fn set_app_monitor_configuration(
            mut self,
            input: std::option::Option<crate::model::AppMonitorConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_app_monitor_configuration(input);
            self
        }
        /// <p>Data collected by RUM is kept by RUM for 30 days and then deleted. This parameter specifies whether RUM sends a copy of this telemetry data to Amazon CloudWatch Logs in your account. This enables you to keep the telemetry data for more than 30 days, but it does incur Amazon CloudWatch Logs charges.</p>
        pub fn cw_log_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.cw_log_enabled(input);
            self
        }
        /// <p>Data collected by RUM is kept by RUM for 30 days and then deleted. This parameter specifies whether RUM sends a copy of this telemetry data to Amazon CloudWatch Logs in your account. This enables you to keep the telemetry data for more than 30 days, but it does incur Amazon CloudWatch Logs charges.</p>
        pub fn set_cw_log_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_cw_log_enabled(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
