// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>A structure that defines a key and values that you can use to filter the results. The only performance events that are returned are those that have values matching the ones that you specify in one of your <code>QueryFilter</code> structures.</p>
/// <p>For example, you could specify <code>Browser</code> as the <code>Name</code> and specify <code>Chrome,Firefox</code> as the <code>Values</code> to return events generated only from those browsers.</p>
/// <p>Specifying <code>Invert</code> as the <code>Name</code> works as a "not equal to" filter. For example, specify <code>Invert</code> as the <code>Name</code> and specify <code>Chrome</code> as the value to return all events except events from user sessions with the Chrome browser.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueryFilter {
    /// <p>The name of a key to search for. The filter returns only the events that match the <code>Name</code> and <code>Values</code> that you specify. </p>
    /// <p>Valid values for <code>Name</code> are <code>Browser</code> | <code>Device</code> | <code>Country</code> | <code>Page</code> | <code>OS</code> | <code>EventType</code> | <code>Invert</code> </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The values of the <code>Name</code> that are to be be included in the returned results.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl QueryFilter {
    /// <p>The name of a key to search for. The filter returns only the events that match the <code>Name</code> and <code>Values</code> that you specify. </p>
    /// <p>Valid values for <code>Name</code> are <code>Browser</code> | <code>Device</code> | <code>Country</code> | <code>Page</code> | <code>OS</code> | <code>EventType</code> | <code>Invert</code> </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The values of the <code>Name</code> that are to be be included in the returned results.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for QueryFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueryFilter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`QueryFilter`](crate::model::QueryFilter)
pub mod query_filter {
    /// A builder for [`QueryFilter`](crate::model::QueryFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of a key to search for. The filter returns only the events that match the <code>Name</code> and <code>Values</code> that you specify. </p>
        /// <p>Valid values for <code>Name</code> are <code>Browser</code> | <code>Device</code> | <code>Country</code> | <code>Page</code> | <code>OS</code> | <code>EventType</code> | <code>Invert</code> </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of a key to search for. The filter returns only the events that match the <code>Name</code> and <code>Values</code> that you specify. </p>
        /// <p>Valid values for <code>Name</code> are <code>Browser</code> | <code>Device</code> | <code>Country</code> | <code>Page</code> | <code>OS</code> | <code>EventType</code> | <code>Invert</code> </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The values of the <code>Name</code> that are to be be included in the returned results.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The values of the <code>Name</code> that are to be be included in the returned results.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`QueryFilter`](crate::model::QueryFilter)
        pub fn build(self) -> crate::model::QueryFilter {
            crate::model::QueryFilter {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl QueryFilter {
    /// Creates a new builder-style object to manufacture [`QueryFilter`](crate::model::QueryFilter)
    pub fn builder() -> crate::model::query_filter::Builder {
        crate::model::query_filter::Builder::default()
    }
}

/// <p>A structure that defines the time range that you want to retrieve results from.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TimeRange {
    /// <p>The beginning of the time range to retrieve performance events from.</p>
    pub after: i64,
    /// <p>The end of the time range to retrieve performance events from. If you omit this, the time range extends to the time that this operation is performed.</p>
    pub before: i64,
}
impl TimeRange {
    /// <p>The beginning of the time range to retrieve performance events from.</p>
    pub fn after(&self) -> i64 {
        self.after
    }
    /// <p>The end of the time range to retrieve performance events from. If you omit this, the time range extends to the time that this operation is performed.</p>
    pub fn before(&self) -> i64 {
        self.before
    }
}
impl std::fmt::Debug for TimeRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TimeRange");
        formatter.field("after", &self.after);
        formatter.field("before", &self.before);
        formatter.finish()
    }
}
/// See [`TimeRange`](crate::model::TimeRange)
pub mod time_range {
    /// A builder for [`TimeRange`](crate::model::TimeRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) after: std::option::Option<i64>,
        pub(crate) before: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The beginning of the time range to retrieve performance events from.</p>
        pub fn after(mut self, input: i64) -> Self {
            self.after = Some(input);
            self
        }
        /// <p>The beginning of the time range to retrieve performance events from.</p>
        pub fn set_after(mut self, input: std::option::Option<i64>) -> Self {
            self.after = input;
            self
        }
        /// <p>The end of the time range to retrieve performance events from. If you omit this, the time range extends to the time that this operation is performed.</p>
        pub fn before(mut self, input: i64) -> Self {
            self.before = Some(input);
            self
        }
        /// <p>The end of the time range to retrieve performance events from. If you omit this, the time range extends to the time that this operation is performed.</p>
        pub fn set_before(mut self, input: std::option::Option<i64>) -> Self {
            self.before = input;
            self
        }
        /// Consumes the builder and constructs a [`TimeRange`](crate::model::TimeRange)
        pub fn build(self) -> crate::model::TimeRange {
            crate::model::TimeRange {
                after: self.after.unwrap_or_default(),
                before: self.before.unwrap_or_default(),
            }
        }
    }
}
impl TimeRange {
    /// Creates a new builder-style object to manufacture [`TimeRange`](crate::model::TimeRange)
    pub fn builder() -> crate::model::time_range::Builder {
        crate::model::time_range::Builder::default()
    }
}

/// <p>This structure contains much of the configuration data for the app monitor.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AppMonitorConfiguration {
    /// <p>The ID of the Amazon Cognito identity pool that is used to authorize the sending of data to RUM.</p>
    pub identity_pool_id: std::option::Option<std::string::String>,
    /// <p>A list of URLs in your website or application to exclude from RUM data collection.</p>
    /// <p>You can't include both <code>ExcludedPages</code> and <code>IncludedPages</code> in the same operation.</p>
    pub excluded_pages: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>If this app monitor is to collect data from only certain pages in your application, this structure lists those pages. </p>
    /// <p>You can't include both <code>ExcludedPages</code> and <code>IncludedPages</code> in the same operation.</p>
    pub included_pages: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of pages in the CloudWatch RUM console that are to be displayed with a "favorite" icon.</p>
    pub favorite_pages: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies the percentage of user sessions to use for RUM data collection. Choosing a higher percentage gives you more data but also incurs more costs.</p>
    /// <p>The number you specify is the percentage of user sessions that will be used.</p>
    /// <p>If you omit this parameter, the default of 10 is used.</p>
    pub session_sample_rate: f64,
    /// <p>The ARN of the guest IAM role that is attached to the Amazon Cognito identity pool that is used to authorize the sending of data to RUM.</p>
    pub guest_role_arn: std::option::Option<std::string::String>,
    /// <p>If you set this to <code>true</code>, the RUM web client sets two cookies, a session cookie and a user cookie. The cookies allow the RUM web client to collect data relating to the number of users an application has and the behavior of the application across a sequence of events. Cookies are stored in the top-level domain of the current page.</p>
    pub allow_cookies: std::option::Option<bool>,
    /// <p>An array that lists the types of telemetry data that this app monitor is to collect.</p>
    /// <ul>
    /// <li> <p> <code>errors</code> indicates that RUM collects data about unhandled JavaScript errors raised by your application.</p> </li>
    /// <li> <p> <code>performance</code> indicates that RUM collects performance data about how your application and its resources are loaded and rendered. This includes Core Web Vitals.</p> </li>
    /// <li> <p> <code>http</code> indicates that RUM collects data about HTTP errors thrown by your application.</p> </li>
    /// </ul>
    pub telemetries: std::option::Option<std::vec::Vec<crate::model::Telemetry>>,
    /// <p>If you set this to <code>true</code>, RUM enables X-Ray tracing for the user sessions that RUM samples. RUM adds an X-Ray trace header to allowed HTTP requests. It also records an X-Ray segment for allowed HTTP requests. You can see traces and segments from these user sessions in the X-Ray console and the CloudWatch ServiceLens console. For more information, see <a href="https://docs.aws.amazon.com/xray/latest/devguide/aws-xray.html">What is X-Ray?</a> </p>
    pub enable_x_ray: std::option::Option<bool>,
}
impl AppMonitorConfiguration {
    /// <p>The ID of the Amazon Cognito identity pool that is used to authorize the sending of data to RUM.</p>
    pub fn identity_pool_id(&self) -> std::option::Option<&str> {
        self.identity_pool_id.as_deref()
    }
    /// <p>A list of URLs in your website or application to exclude from RUM data collection.</p>
    /// <p>You can't include both <code>ExcludedPages</code> and <code>IncludedPages</code> in the same operation.</p>
    pub fn excluded_pages(&self) -> std::option::Option<&[std::string::String]> {
        self.excluded_pages.as_deref()
    }
    /// <p>If this app monitor is to collect data from only certain pages in your application, this structure lists those pages. </p>
    /// <p>You can't include both <code>ExcludedPages</code> and <code>IncludedPages</code> in the same operation.</p>
    pub fn included_pages(&self) -> std::option::Option<&[std::string::String]> {
        self.included_pages.as_deref()
    }
    /// <p>A list of pages in the CloudWatch RUM console that are to be displayed with a "favorite" icon.</p>
    pub fn favorite_pages(&self) -> std::option::Option<&[std::string::String]> {
        self.favorite_pages.as_deref()
    }
    /// <p>Specifies the percentage of user sessions to use for RUM data collection. Choosing a higher percentage gives you more data but also incurs more costs.</p>
    /// <p>The number you specify is the percentage of user sessions that will be used.</p>
    /// <p>If you omit this parameter, the default of 10 is used.</p>
    pub fn session_sample_rate(&self) -> f64 {
        self.session_sample_rate
    }
    /// <p>The ARN of the guest IAM role that is attached to the Amazon Cognito identity pool that is used to authorize the sending of data to RUM.</p>
    pub fn guest_role_arn(&self) -> std::option::Option<&str> {
        self.guest_role_arn.as_deref()
    }
    /// <p>If you set this to <code>true</code>, the RUM web client sets two cookies, a session cookie and a user cookie. The cookies allow the RUM web client to collect data relating to the number of users an application has and the behavior of the application across a sequence of events. Cookies are stored in the top-level domain of the current page.</p>
    pub fn allow_cookies(&self) -> std::option::Option<bool> {
        self.allow_cookies
    }
    /// <p>An array that lists the types of telemetry data that this app monitor is to collect.</p>
    /// <ul>
    /// <li> <p> <code>errors</code> indicates that RUM collects data about unhandled JavaScript errors raised by your application.</p> </li>
    /// <li> <p> <code>performance</code> indicates that RUM collects performance data about how your application and its resources are loaded and rendered. This includes Core Web Vitals.</p> </li>
    /// <li> <p> <code>http</code> indicates that RUM collects data about HTTP errors thrown by your application.</p> </li>
    /// </ul>
    pub fn telemetries(&self) -> std::option::Option<&[crate::model::Telemetry]> {
        self.telemetries.as_deref()
    }
    /// <p>If you set this to <code>true</code>, RUM enables X-Ray tracing for the user sessions that RUM samples. RUM adds an X-Ray trace header to allowed HTTP requests. It also records an X-Ray segment for allowed HTTP requests. You can see traces and segments from these user sessions in the X-Ray console and the CloudWatch ServiceLens console. For more information, see <a href="https://docs.aws.amazon.com/xray/latest/devguide/aws-xray.html">What is X-Ray?</a> </p>
    pub fn enable_x_ray(&self) -> std::option::Option<bool> {
        self.enable_x_ray
    }
}
impl std::fmt::Debug for AppMonitorConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AppMonitorConfiguration");
        formatter.field("identity_pool_id", &self.identity_pool_id);
        formatter.field("excluded_pages", &self.excluded_pages);
        formatter.field("included_pages", &self.included_pages);
        formatter.field("favorite_pages", &self.favorite_pages);
        formatter.field("session_sample_rate", &self.session_sample_rate);
        formatter.field("guest_role_arn", &self.guest_role_arn);
        formatter.field("allow_cookies", &self.allow_cookies);
        formatter.field("telemetries", &self.telemetries);
        formatter.field("enable_x_ray", &self.enable_x_ray);
        formatter.finish()
    }
}
/// See [`AppMonitorConfiguration`](crate::model::AppMonitorConfiguration)
pub mod app_monitor_configuration {
    /// A builder for [`AppMonitorConfiguration`](crate::model::AppMonitorConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_pool_id: std::option::Option<std::string::String>,
        pub(crate) excluded_pages: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) included_pages: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) favorite_pages: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) session_sample_rate: std::option::Option<f64>,
        pub(crate) guest_role_arn: std::option::Option<std::string::String>,
        pub(crate) allow_cookies: std::option::Option<bool>,
        pub(crate) telemetries: std::option::Option<std::vec::Vec<crate::model::Telemetry>>,
        pub(crate) enable_x_ray: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Cognito identity pool that is used to authorize the sending of data to RUM.</p>
        pub fn identity_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.identity_pool_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Cognito identity pool that is used to authorize the sending of data to RUM.</p>
        pub fn set_identity_pool_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_pool_id = input;
            self
        }
        /// Appends an item to `excluded_pages`.
        ///
        /// To override the contents of this collection use [`set_excluded_pages`](Self::set_excluded_pages).
        ///
        /// <p>A list of URLs in your website or application to exclude from RUM data collection.</p>
        /// <p>You can't include both <code>ExcludedPages</code> and <code>IncludedPages</code> in the same operation.</p>
        pub fn excluded_pages(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.excluded_pages.unwrap_or_default();
            v.push(input.into());
            self.excluded_pages = Some(v);
            self
        }
        /// <p>A list of URLs in your website or application to exclude from RUM data collection.</p>
        /// <p>You can't include both <code>ExcludedPages</code> and <code>IncludedPages</code> in the same operation.</p>
        pub fn set_excluded_pages(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.excluded_pages = input;
            self
        }
        /// Appends an item to `included_pages`.
        ///
        /// To override the contents of this collection use [`set_included_pages`](Self::set_included_pages).
        ///
        /// <p>If this app monitor is to collect data from only certain pages in your application, this structure lists those pages. </p>
        /// <p>You can't include both <code>ExcludedPages</code> and <code>IncludedPages</code> in the same operation.</p>
        pub fn included_pages(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.included_pages.unwrap_or_default();
            v.push(input.into());
            self.included_pages = Some(v);
            self
        }
        /// <p>If this app monitor is to collect data from only certain pages in your application, this structure lists those pages. </p>
        /// <p>You can't include both <code>ExcludedPages</code> and <code>IncludedPages</code> in the same operation.</p>
        pub fn set_included_pages(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.included_pages = input;
            self
        }
        /// Appends an item to `favorite_pages`.
        ///
        /// To override the contents of this collection use [`set_favorite_pages`](Self::set_favorite_pages).
        ///
        /// <p>A list of pages in the CloudWatch RUM console that are to be displayed with a "favorite" icon.</p>
        pub fn favorite_pages(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.favorite_pages.unwrap_or_default();
            v.push(input.into());
            self.favorite_pages = Some(v);
            self
        }
        /// <p>A list of pages in the CloudWatch RUM console that are to be displayed with a "favorite" icon.</p>
        pub fn set_favorite_pages(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.favorite_pages = input;
            self
        }
        /// <p>Specifies the percentage of user sessions to use for RUM data collection. Choosing a higher percentage gives you more data but also incurs more costs.</p>
        /// <p>The number you specify is the percentage of user sessions that will be used.</p>
        /// <p>If you omit this parameter, the default of 10 is used.</p>
        pub fn session_sample_rate(mut self, input: f64) -> Self {
            self.session_sample_rate = Some(input);
            self
        }
        /// <p>Specifies the percentage of user sessions to use for RUM data collection. Choosing a higher percentage gives you more data but also incurs more costs.</p>
        /// <p>The number you specify is the percentage of user sessions that will be used.</p>
        /// <p>If you omit this parameter, the default of 10 is used.</p>
        pub fn set_session_sample_rate(mut self, input: std::option::Option<f64>) -> Self {
            self.session_sample_rate = input;
            self
        }
        /// <p>The ARN of the guest IAM role that is attached to the Amazon Cognito identity pool that is used to authorize the sending of data to RUM.</p>
        pub fn guest_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.guest_role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the guest IAM role that is attached to the Amazon Cognito identity pool that is used to authorize the sending of data to RUM.</p>
        pub fn set_guest_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.guest_role_arn = input;
            self
        }
        /// <p>If you set this to <code>true</code>, the RUM web client sets two cookies, a session cookie and a user cookie. The cookies allow the RUM web client to collect data relating to the number of users an application has and the behavior of the application across a sequence of events. Cookies are stored in the top-level domain of the current page.</p>
        pub fn allow_cookies(mut self, input: bool) -> Self {
            self.allow_cookies = Some(input);
            self
        }
        /// <p>If you set this to <code>true</code>, the RUM web client sets two cookies, a session cookie and a user cookie. The cookies allow the RUM web client to collect data relating to the number of users an application has and the behavior of the application across a sequence of events. Cookies are stored in the top-level domain of the current page.</p>
        pub fn set_allow_cookies(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_cookies = input;
            self
        }
        /// Appends an item to `telemetries`.
        ///
        /// To override the contents of this collection use [`set_telemetries`](Self::set_telemetries).
        ///
        /// <p>An array that lists the types of telemetry data that this app monitor is to collect.</p>
        /// <ul>
        /// <li> <p> <code>errors</code> indicates that RUM collects data about unhandled JavaScript errors raised by your application.</p> </li>
        /// <li> <p> <code>performance</code> indicates that RUM collects performance data about how your application and its resources are loaded and rendered. This includes Core Web Vitals.</p> </li>
        /// <li> <p> <code>http</code> indicates that RUM collects data about HTTP errors thrown by your application.</p> </li>
        /// </ul>
        pub fn telemetries(mut self, input: crate::model::Telemetry) -> Self {
            let mut v = self.telemetries.unwrap_or_default();
            v.push(input);
            self.telemetries = Some(v);
            self
        }
        /// <p>An array that lists the types of telemetry data that this app monitor is to collect.</p>
        /// <ul>
        /// <li> <p> <code>errors</code> indicates that RUM collects data about unhandled JavaScript errors raised by your application.</p> </li>
        /// <li> <p> <code>performance</code> indicates that RUM collects performance data about how your application and its resources are loaded and rendered. This includes Core Web Vitals.</p> </li>
        /// <li> <p> <code>http</code> indicates that RUM collects data about HTTP errors thrown by your application.</p> </li>
        /// </ul>
        pub fn set_telemetries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Telemetry>>,
        ) -> Self {
            self.telemetries = input;
            self
        }
        /// <p>If you set this to <code>true</code>, RUM enables X-Ray tracing for the user sessions that RUM samples. RUM adds an X-Ray trace header to allowed HTTP requests. It also records an X-Ray segment for allowed HTTP requests. You can see traces and segments from these user sessions in the X-Ray console and the CloudWatch ServiceLens console. For more information, see <a href="https://docs.aws.amazon.com/xray/latest/devguide/aws-xray.html">What is X-Ray?</a> </p>
        pub fn enable_x_ray(mut self, input: bool) -> Self {
            self.enable_x_ray = Some(input);
            self
        }
        /// <p>If you set this to <code>true</code>, RUM enables X-Ray tracing for the user sessions that RUM samples. RUM adds an X-Ray trace header to allowed HTTP requests. It also records an X-Ray segment for allowed HTTP requests. You can see traces and segments from these user sessions in the X-Ray console and the CloudWatch ServiceLens console. For more information, see <a href="https://docs.aws.amazon.com/xray/latest/devguide/aws-xray.html">What is X-Ray?</a> </p>
        pub fn set_enable_x_ray(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_x_ray = input;
            self
        }
        /// Consumes the builder and constructs a [`AppMonitorConfiguration`](crate::model::AppMonitorConfiguration)
        pub fn build(self) -> crate::model::AppMonitorConfiguration {
            crate::model::AppMonitorConfiguration {
                identity_pool_id: self.identity_pool_id,
                excluded_pages: self.excluded_pages,
                included_pages: self.included_pages,
                favorite_pages: self.favorite_pages,
                session_sample_rate: self.session_sample_rate.unwrap_or_default(),
                guest_role_arn: self.guest_role_arn,
                allow_cookies: self.allow_cookies,
                telemetries: self.telemetries,
                enable_x_ray: self.enable_x_ray,
            }
        }
    }
}
impl AppMonitorConfiguration {
    /// Creates a new builder-style object to manufacture [`AppMonitorConfiguration`](crate::model::AppMonitorConfiguration)
    pub fn builder() -> crate::model::app_monitor_configuration::Builder {
        crate::model::app_monitor_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Telemetry {
    /// Includes JS error event plugin
    Errors,
    /// Includes X-Ray Xhr and X-Ray Fetch plugin
    Http,
    /// Includes navigation, paint, resource and web vital event plugins
    Performance,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Telemetry {
    fn from(s: &str) -> Self {
        match s {
            "errors" => Telemetry::Errors,
            "http" => Telemetry::Http,
            "performance" => Telemetry::Performance,
            other => Telemetry::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Telemetry {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Telemetry::from(s))
    }
}
impl Telemetry {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Telemetry::Errors => "errors",
            Telemetry::Http => "http",
            Telemetry::Performance => "performance",
            Telemetry::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["errors", "http", "performance"]
    }
}
impl AsRef<str> for Telemetry {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A structure that includes some data about app monitors and their settings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AppMonitorSummary {
    /// <p>The name of this app monitor.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The unique ID of this app monitor.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The date and time that the app monitor was created.</p>
    pub created: std::option::Option<std::string::String>,
    /// <p>The date and time of the most recent changes to this app monitor's configuration.</p>
    pub last_modified: std::option::Option<std::string::String>,
    /// <p>The current state of this app monitor.</p>
    pub state: std::option::Option<crate::model::StateEnum>,
}
impl AppMonitorSummary {
    /// <p>The name of this app monitor.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The unique ID of this app monitor.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The date and time that the app monitor was created.</p>
    pub fn created(&self) -> std::option::Option<&str> {
        self.created.as_deref()
    }
    /// <p>The date and time of the most recent changes to this app monitor's configuration.</p>
    pub fn last_modified(&self) -> std::option::Option<&str> {
        self.last_modified.as_deref()
    }
    /// <p>The current state of this app monitor.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::StateEnum> {
        self.state.as_ref()
    }
}
impl std::fmt::Debug for AppMonitorSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AppMonitorSummary");
        formatter.field("name", &self.name);
        formatter.field("id", &self.id);
        formatter.field("created", &self.created);
        formatter.field("last_modified", &self.last_modified);
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`AppMonitorSummary`](crate::model::AppMonitorSummary)
pub mod app_monitor_summary {
    /// A builder for [`AppMonitorSummary`](crate::model::AppMonitorSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) created: std::option::Option<std::string::String>,
        pub(crate) last_modified: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::StateEnum>,
    }
    impl Builder {
        /// <p>The name of this app monitor.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of this app monitor.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The unique ID of this app monitor.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique ID of this app monitor.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The date and time that the app monitor was created.</p>
        pub fn created(mut self, input: impl Into<std::string::String>) -> Self {
            self.created = Some(input.into());
            self
        }
        /// <p>The date and time that the app monitor was created.</p>
        pub fn set_created(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created = input;
            self
        }
        /// <p>The date and time of the most recent changes to this app monitor's configuration.</p>
        pub fn last_modified(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified = Some(input.into());
            self
        }
        /// <p>The date and time of the most recent changes to this app monitor's configuration.</p>
        pub fn set_last_modified(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified = input;
            self
        }
        /// <p>The current state of this app monitor.</p>
        pub fn state(mut self, input: crate::model::StateEnum) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of this app monitor.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::StateEnum>) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`AppMonitorSummary`](crate::model::AppMonitorSummary)
        pub fn build(self) -> crate::model::AppMonitorSummary {
            crate::model::AppMonitorSummary {
                name: self.name,
                id: self.id,
                created: self.created,
                last_modified: self.last_modified,
                state: self.state,
            }
        }
    }
}
impl AppMonitorSummary {
    /// Creates a new builder-style object to manufacture [`AppMonitorSummary`](crate::model::AppMonitorSummary)
    pub fn builder() -> crate::model::app_monitor_summary::Builder {
        crate::model::app_monitor_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StateEnum {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Created,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StateEnum {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => StateEnum::Active,
            "CREATED" => StateEnum::Created,
            "DELETING" => StateEnum::Deleting,
            other => StateEnum::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StateEnum {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StateEnum::from(s))
    }
}
impl StateEnum {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StateEnum::Active => "ACTIVE",
            StateEnum::Created => "CREATED",
            StateEnum::Deleting => "DELETING",
            StateEnum::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "CREATED", "DELETING"]
    }
}
impl AsRef<str> for StateEnum {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A RUM app monitor collects telemetry data from your application and sends that data to RUM. The data includes performance and reliability information such as page load time, client-side errors, and user behavior.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AppMonitor {
    /// <p>The name of the app monitor.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The top-level internet domain name for which your application has administrative authority.</p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>The unique ID of this app monitor.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The date and time that this app monitor was created.</p>
    pub created: std::option::Option<std::string::String>,
    /// <p>The date and time of the most recent changes to this app monitor's configuration.</p>
    pub last_modified: std::option::Option<std::string::String>,
    /// <p>The list of tag keys and values associated with this app monitor.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The current state of the app monitor.</p>
    pub state: std::option::Option<crate::model::StateEnum>,
    /// <p>A structure that contains much of the configuration data for the app monitor.</p>
    pub app_monitor_configuration: std::option::Option<crate::model::AppMonitorConfiguration>,
    /// <p>A structure that contains information about whether this app monitor stores a copy of the telemetry data that RUM collects using CloudWatch Logs.</p>
    pub data_storage: std::option::Option<crate::model::DataStorage>,
}
impl AppMonitor {
    /// <p>The name of the app monitor.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The top-level internet domain name for which your application has administrative authority.</p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>The unique ID of this app monitor.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The date and time that this app monitor was created.</p>
    pub fn created(&self) -> std::option::Option<&str> {
        self.created.as_deref()
    }
    /// <p>The date and time of the most recent changes to this app monitor's configuration.</p>
    pub fn last_modified(&self) -> std::option::Option<&str> {
        self.last_modified.as_deref()
    }
    /// <p>The list of tag keys and values associated with this app monitor.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The current state of the app monitor.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::StateEnum> {
        self.state.as_ref()
    }
    /// <p>A structure that contains much of the configuration data for the app monitor.</p>
    pub fn app_monitor_configuration(
        &self,
    ) -> std::option::Option<&crate::model::AppMonitorConfiguration> {
        self.app_monitor_configuration.as_ref()
    }
    /// <p>A structure that contains information about whether this app monitor stores a copy of the telemetry data that RUM collects using CloudWatch Logs.</p>
    pub fn data_storage(&self) -> std::option::Option<&crate::model::DataStorage> {
        self.data_storage.as_ref()
    }
}
impl std::fmt::Debug for AppMonitor {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AppMonitor");
        formatter.field("name", &self.name);
        formatter.field("domain", &self.domain);
        formatter.field("id", &self.id);
        formatter.field("created", &self.created);
        formatter.field("last_modified", &self.last_modified);
        formatter.field("tags", &self.tags);
        formatter.field("state", &self.state);
        formatter.field("app_monitor_configuration", &self.app_monitor_configuration);
        formatter.field("data_storage", &self.data_storage);
        formatter.finish()
    }
}
/// See [`AppMonitor`](crate::model::AppMonitor)
pub mod app_monitor {
    /// A builder for [`AppMonitor`](crate::model::AppMonitor)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) created: std::option::Option<std::string::String>,
        pub(crate) last_modified: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) state: std::option::Option<crate::model::StateEnum>,
        pub(crate) app_monitor_configuration:
            std::option::Option<crate::model::AppMonitorConfiguration>,
        pub(crate) data_storage: std::option::Option<crate::model::DataStorage>,
    }
    impl Builder {
        /// <p>The name of the app monitor.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the app monitor.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The top-level internet domain name for which your application has administrative authority.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The top-level internet domain name for which your application has administrative authority.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>The unique ID of this app monitor.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique ID of this app monitor.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The date and time that this app monitor was created.</p>
        pub fn created(mut self, input: impl Into<std::string::String>) -> Self {
            self.created = Some(input.into());
            self
        }
        /// <p>The date and time that this app monitor was created.</p>
        pub fn set_created(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created = input;
            self
        }
        /// <p>The date and time of the most recent changes to this app monitor's configuration.</p>
        pub fn last_modified(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified = Some(input.into());
            self
        }
        /// <p>The date and time of the most recent changes to this app monitor's configuration.</p>
        pub fn set_last_modified(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tag keys and values associated with this app monitor.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The list of tag keys and values associated with this app monitor.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The current state of the app monitor.</p>
        pub fn state(mut self, input: crate::model::StateEnum) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the app monitor.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::StateEnum>) -> Self {
            self.state = input;
            self
        }
        /// <p>A structure that contains much of the configuration data for the app monitor.</p>
        pub fn app_monitor_configuration(
            mut self,
            input: crate::model::AppMonitorConfiguration,
        ) -> Self {
            self.app_monitor_configuration = Some(input);
            self
        }
        /// <p>A structure that contains much of the configuration data for the app monitor.</p>
        pub fn set_app_monitor_configuration(
            mut self,
            input: std::option::Option<crate::model::AppMonitorConfiguration>,
        ) -> Self {
            self.app_monitor_configuration = input;
            self
        }
        /// <p>A structure that contains information about whether this app monitor stores a copy of the telemetry data that RUM collects using CloudWatch Logs.</p>
        pub fn data_storage(mut self, input: crate::model::DataStorage) -> Self {
            self.data_storage = Some(input);
            self
        }
        /// <p>A structure that contains information about whether this app monitor stores a copy of the telemetry data that RUM collects using CloudWatch Logs.</p>
        pub fn set_data_storage(
            mut self,
            input: std::option::Option<crate::model::DataStorage>,
        ) -> Self {
            self.data_storage = input;
            self
        }
        /// Consumes the builder and constructs a [`AppMonitor`](crate::model::AppMonitor)
        pub fn build(self) -> crate::model::AppMonitor {
            crate::model::AppMonitor {
                name: self.name,
                domain: self.domain,
                id: self.id,
                created: self.created,
                last_modified: self.last_modified,
                tags: self.tags,
                state: self.state,
                app_monitor_configuration: self.app_monitor_configuration,
                data_storage: self.data_storage,
            }
        }
    }
}
impl AppMonitor {
    /// Creates a new builder-style object to manufacture [`AppMonitor`](crate::model::AppMonitor)
    pub fn builder() -> crate::model::app_monitor::Builder {
        crate::model::app_monitor::Builder::default()
    }
}

/// <p>A structure that contains information about whether this app monitor stores a copy of the telemetry data that RUM collects using CloudWatch Logs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataStorage {
    /// <p>A structure that contains the information about whether the app monitor stores copies of the data that RUM collects in CloudWatch Logs. If it does, this structure also contains the name of the log group.</p>
    pub cw_log: std::option::Option<crate::model::CwLog>,
}
impl DataStorage {
    /// <p>A structure that contains the information about whether the app monitor stores copies of the data that RUM collects in CloudWatch Logs. If it does, this structure also contains the name of the log group.</p>
    pub fn cw_log(&self) -> std::option::Option<&crate::model::CwLog> {
        self.cw_log.as_ref()
    }
}
impl std::fmt::Debug for DataStorage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataStorage");
        formatter.field("cw_log", &self.cw_log);
        formatter.finish()
    }
}
/// See [`DataStorage`](crate::model::DataStorage)
pub mod data_storage {
    /// A builder for [`DataStorage`](crate::model::DataStorage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cw_log: std::option::Option<crate::model::CwLog>,
    }
    impl Builder {
        /// <p>A structure that contains the information about whether the app monitor stores copies of the data that RUM collects in CloudWatch Logs. If it does, this structure also contains the name of the log group.</p>
        pub fn cw_log(mut self, input: crate::model::CwLog) -> Self {
            self.cw_log = Some(input);
            self
        }
        /// <p>A structure that contains the information about whether the app monitor stores copies of the data that RUM collects in CloudWatch Logs. If it does, this structure also contains the name of the log group.</p>
        pub fn set_cw_log(mut self, input: std::option::Option<crate::model::CwLog>) -> Self {
            self.cw_log = input;
            self
        }
        /// Consumes the builder and constructs a [`DataStorage`](crate::model::DataStorage)
        pub fn build(self) -> crate::model::DataStorage {
            crate::model::DataStorage {
                cw_log: self.cw_log,
            }
        }
    }
}
impl DataStorage {
    /// Creates a new builder-style object to manufacture [`DataStorage`](crate::model::DataStorage)
    pub fn builder() -> crate::model::data_storage::Builder {
        crate::model::data_storage::Builder::default()
    }
}

/// <p>A structure that contains the information about whether the app monitor stores copies of the data that RUM collects in CloudWatch Logs. If it does, this structure also contains the name of the log group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CwLog {
    /// <p>Indicated whether the app monitor stores copies of the data that RUM collects in CloudWatch Logs.</p>
    pub cw_log_enabled: std::option::Option<bool>,
    /// <p>The name of the log group where the copies are stored.</p>
    pub cw_log_group: std::option::Option<std::string::String>,
}
impl CwLog {
    /// <p>Indicated whether the app monitor stores copies of the data that RUM collects in CloudWatch Logs.</p>
    pub fn cw_log_enabled(&self) -> std::option::Option<bool> {
        self.cw_log_enabled
    }
    /// <p>The name of the log group where the copies are stored.</p>
    pub fn cw_log_group(&self) -> std::option::Option<&str> {
        self.cw_log_group.as_deref()
    }
}
impl std::fmt::Debug for CwLog {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CwLog");
        formatter.field("cw_log_enabled", &self.cw_log_enabled);
        formatter.field("cw_log_group", &self.cw_log_group);
        formatter.finish()
    }
}
/// See [`CwLog`](crate::model::CwLog)
pub mod cw_log {
    /// A builder for [`CwLog`](crate::model::CwLog)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cw_log_enabled: std::option::Option<bool>,
        pub(crate) cw_log_group: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicated whether the app monitor stores copies of the data that RUM collects in CloudWatch Logs.</p>
        pub fn cw_log_enabled(mut self, input: bool) -> Self {
            self.cw_log_enabled = Some(input);
            self
        }
        /// <p>Indicated whether the app monitor stores copies of the data that RUM collects in CloudWatch Logs.</p>
        pub fn set_cw_log_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.cw_log_enabled = input;
            self
        }
        /// <p>The name of the log group where the copies are stored.</p>
        pub fn cw_log_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.cw_log_group = Some(input.into());
            self
        }
        /// <p>The name of the log group where the copies are stored.</p>
        pub fn set_cw_log_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cw_log_group = input;
            self
        }
        /// Consumes the builder and constructs a [`CwLog`](crate::model::CwLog)
        pub fn build(self) -> crate::model::CwLog {
            crate::model::CwLog {
                cw_log_enabled: self.cw_log_enabled,
                cw_log_group: self.cw_log_group,
            }
        }
    }
}
impl CwLog {
    /// Creates a new builder-style object to manufacture [`CwLog`](crate::model::CwLog)
    pub fn builder() -> crate::model::cw_log::Builder {
        crate::model::cw_log::Builder::default()
    }
}

/// <p>A structure that contains the information for one performance event that RUM collects from a user session with your application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RumEvent {
    /// <p>A unique ID for this event.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The exact time that this event occurred.</p>
    pub timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The JSON schema that denotes the type of event this is, such as a page load or a new session.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>Metadata about this event, which contains a JSON serialization of the identity of the user for this session. The user information comes from information such as the HTTP user-agent request header and document interface.</p>
    pub metadata: std::option::Option<std::string::String>,
    /// <p>A string containing details about the event.</p>
    pub details: std::option::Option<std::string::String>,
}
impl RumEvent {
    /// <p>A unique ID for this event.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The exact time that this event occurred.</p>
    pub fn timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.timestamp.as_ref()
    }
    /// <p>The JSON schema that denotes the type of event this is, such as a page load or a new session.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>Metadata about this event, which contains a JSON serialization of the identity of the user for this session. The user information comes from information such as the HTTP user-agent request header and document interface.</p>
    pub fn metadata(&self) -> std::option::Option<&str> {
        self.metadata.as_deref()
    }
    /// <p>A string containing details about the event.</p>
    pub fn details(&self) -> std::option::Option<&str> {
        self.details.as_deref()
    }
}
impl std::fmt::Debug for RumEvent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RumEvent");
        formatter.field("id", &self.id);
        formatter.field("timestamp", &self.timestamp);
        formatter.field("r#type", &self.r#type);
        formatter.field("metadata", &self.metadata);
        formatter.field("details", &self.details);
        formatter.finish()
    }
}
/// See [`RumEvent`](crate::model::RumEvent)
pub mod rum_event {
    /// A builder for [`RumEvent`](crate::model::RumEvent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) metadata: std::option::Option<std::string::String>,
        pub(crate) details: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique ID for this event.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>A unique ID for this event.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The exact time that this event occurred.</p>
        pub fn timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>The exact time that this event occurred.</p>
        pub fn set_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>The JSON schema that denotes the type of event this is, such as a page load or a new session.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The JSON schema that denotes the type of event this is, such as a page load or a new session.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Metadata about this event, which contains a JSON serialization of the identity of the user for this session. The user information comes from information such as the HTTP user-agent request header and document interface.</p>
        pub fn metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.metadata = Some(input.into());
            self
        }
        /// <p>Metadata about this event, which contains a JSON serialization of the identity of the user for this session. The user information comes from information such as the HTTP user-agent request header and document interface.</p>
        pub fn set_metadata(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metadata = input;
            self
        }
        /// <p>A string containing details about the event.</p>
        pub fn details(mut self, input: impl Into<std::string::String>) -> Self {
            self.details = Some(input.into());
            self
        }
        /// <p>A string containing details about the event.</p>
        pub fn set_details(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.details = input;
            self
        }
        /// Consumes the builder and constructs a [`RumEvent`](crate::model::RumEvent)
        pub fn build(self) -> crate::model::RumEvent {
            crate::model::RumEvent {
                id: self.id,
                timestamp: self.timestamp,
                r#type: self.r#type,
                metadata: self.metadata,
                details: self.details,
            }
        }
    }
}
impl RumEvent {
    /// Creates a new builder-style object to manufacture [`RumEvent`](crate::model::RumEvent)
    pub fn builder() -> crate::model::rum_event::Builder {
        crate::model::rum_event::Builder::default()
    }
}

/// <p>A structure that contains information about the user session that this batch of events was collected from.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserDetails {
    /// <p>The ID of the user for this user session. This ID is generated by RUM and does not include any personally identifiable information about the user.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>The session ID that the performance events are from.</p>
    pub session_id: std::option::Option<std::string::String>,
}
impl UserDetails {
    /// <p>The ID of the user for this user session. This ID is generated by RUM and does not include any personally identifiable information about the user.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p>The session ID that the performance events are from.</p>
    pub fn session_id(&self) -> std::option::Option<&str> {
        self.session_id.as_deref()
    }
}
impl std::fmt::Debug for UserDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserDetails");
        formatter.field("user_id", &self.user_id);
        formatter.field("session_id", &self.session_id);
        formatter.finish()
    }
}
/// See [`UserDetails`](crate::model::UserDetails)
pub mod user_details {
    /// A builder for [`UserDetails`](crate::model::UserDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) session_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the user for this user session. This ID is generated by RUM and does not include any personally identifiable information about the user.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The ID of the user for this user session. This ID is generated by RUM and does not include any personally identifiable information about the user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>The session ID that the performance events are from.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_id = Some(input.into());
            self
        }
        /// <p>The session ID that the performance events are from.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UserDetails`](crate::model::UserDetails)
        pub fn build(self) -> crate::model::UserDetails {
            crate::model::UserDetails {
                user_id: self.user_id,
                session_id: self.session_id,
            }
        }
    }
}
impl UserDetails {
    /// Creates a new builder-style object to manufacture [`UserDetails`](crate::model::UserDetails)
    pub fn builder() -> crate::model::user_details::Builder {
        crate::model::user_details::Builder::default()
    }
}

/// <p>A structure that contains information about the RUM app monitor.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AppMonitorDetails {
    /// <p>The name of the app monitor.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The unique ID of the app monitor.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The version of the app monitor.</p>
    pub version: std::option::Option<std::string::String>,
}
impl AppMonitorDetails {
    /// <p>The name of the app monitor.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The unique ID of the app monitor.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The version of the app monitor.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for AppMonitorDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AppMonitorDetails");
        formatter.field("name", &self.name);
        formatter.field("id", &self.id);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`AppMonitorDetails`](crate::model::AppMonitorDetails)
pub mod app_monitor_details {
    /// A builder for [`AppMonitorDetails`](crate::model::AppMonitorDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the app monitor.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the app monitor.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The unique ID of the app monitor.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique ID of the app monitor.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The version of the app monitor.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the app monitor.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`AppMonitorDetails`](crate::model::AppMonitorDetails)
        pub fn build(self) -> crate::model::AppMonitorDetails {
            crate::model::AppMonitorDetails {
                name: self.name,
                id: self.id,
                version: self.version,
            }
        }
    }
}
impl AppMonitorDetails {
    /// Creates a new builder-style object to manufacture [`AppMonitorDetails`](crate::model::AppMonitorDetails)
    pub fn builder() -> crate::model::app_monitor_details::Builder {
        crate::model::app_monitor_details::Builder::default()
    }
}
