// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAppMonitorDataOutput {
    /// <p>The events that RUM collected that match your request.</p>
    pub events: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A token that you can use in a subsequent operation to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetAppMonitorDataOutput {
    /// <p>The events that RUM collected that match your request.</p>
    pub fn events(&self) -> std::option::Option<&[std::string::String]> {
        self.events.as_deref()
    }
    /// <p>A token that you can use in a subsequent operation to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetAppMonitorDataOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAppMonitorDataOutput");
        formatter.field("events", &self.events);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetAppMonitorDataOutput`](crate::output::GetAppMonitorDataOutput)
pub mod get_app_monitor_data_output {
    /// A builder for [`GetAppMonitorDataOutput`](crate::output::GetAppMonitorDataOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) events: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `events`.
        ///
        /// To override the contents of this collection use [`set_events`](Self::set_events).
        ///
        /// <p>The events that RUM collected that match your request.</p>
        pub fn events(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.events.unwrap_or_default();
            v.push(input.into());
            self.events = Some(v);
            self
        }
        /// <p>The events that RUM collected that match your request.</p>
        pub fn set_events(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.events = input;
            self
        }
        /// <p>A token that you can use in a subsequent operation to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that you can use in a subsequent operation to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAppMonitorDataOutput`](crate::output::GetAppMonitorDataOutput)
        pub fn build(self) -> crate::output::GetAppMonitorDataOutput {
            crate::output::GetAppMonitorDataOutput {
                events: self.events,
                next_token: self.next_token,
            }
        }
    }
}
impl GetAppMonitorDataOutput {
    /// Creates a new builder-style object to manufacture [`GetAppMonitorDataOutput`](crate::output::GetAppMonitorDataOutput)
    pub fn builder() -> crate::output::get_app_monitor_data_output::Builder {
        crate::output::get_app_monitor_data_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAppMonitorOutput {
    /// <p>The unique ID of the new app monitor.</p>
    pub id: std::option::Option<std::string::String>,
}
impl CreateAppMonitorOutput {
    /// <p>The unique ID of the new app monitor.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for CreateAppMonitorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAppMonitorOutput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}
/// See [`CreateAppMonitorOutput`](crate::output::CreateAppMonitorOutput)
pub mod create_app_monitor_output {
    /// A builder for [`CreateAppMonitorOutput`](crate::output::CreateAppMonitorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of the new app monitor.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique ID of the new app monitor.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAppMonitorOutput`](crate::output::CreateAppMonitorOutput)
        pub fn build(self) -> crate::output::CreateAppMonitorOutput {
            crate::output::CreateAppMonitorOutput { id: self.id }
        }
    }
}
impl CreateAppMonitorOutput {
    /// Creates a new builder-style object to manufacture [`CreateAppMonitorOutput`](crate::output::CreateAppMonitorOutput)
    pub fn builder() -> crate::output::create_app_monitor_output::Builder {
        crate::output::create_app_monitor_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAppMonitorsOutput {
    /// <p>A token that you can use in a subsequent operation to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An array of structures that contain information about the returned app monitors.</p>
    pub app_monitor_summaries: std::option::Option<std::vec::Vec<crate::model::AppMonitorSummary>>,
}
impl ListAppMonitorsOutput {
    /// <p>A token that you can use in a subsequent operation to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>An array of structures that contain information about the returned app monitors.</p>
    pub fn app_monitor_summaries(&self) -> std::option::Option<&[crate::model::AppMonitorSummary]> {
        self.app_monitor_summaries.as_deref()
    }
}
impl std::fmt::Debug for ListAppMonitorsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAppMonitorsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("app_monitor_summaries", &self.app_monitor_summaries);
        formatter.finish()
    }
}
/// See [`ListAppMonitorsOutput`](crate::output::ListAppMonitorsOutput)
pub mod list_app_monitors_output {
    /// A builder for [`ListAppMonitorsOutput`](crate::output::ListAppMonitorsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) app_monitor_summaries:
            std::option::Option<std::vec::Vec<crate::model::AppMonitorSummary>>,
    }
    impl Builder {
        /// <p>A token that you can use in a subsequent operation to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that you can use in a subsequent operation to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `app_monitor_summaries`.
        ///
        /// To override the contents of this collection use [`set_app_monitor_summaries`](Self::set_app_monitor_summaries).
        ///
        /// <p>An array of structures that contain information about the returned app monitors.</p>
        pub fn app_monitor_summaries(mut self, input: crate::model::AppMonitorSummary) -> Self {
            let mut v = self.app_monitor_summaries.unwrap_or_default();
            v.push(input);
            self.app_monitor_summaries = Some(v);
            self
        }
        /// <p>An array of structures that contain information about the returned app monitors.</p>
        pub fn set_app_monitor_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AppMonitorSummary>>,
        ) -> Self {
            self.app_monitor_summaries = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAppMonitorsOutput`](crate::output::ListAppMonitorsOutput)
        pub fn build(self) -> crate::output::ListAppMonitorsOutput {
            crate::output::ListAppMonitorsOutput {
                next_token: self.next_token,
                app_monitor_summaries: self.app_monitor_summaries,
            }
        }
    }
}
impl ListAppMonitorsOutput {
    /// Creates a new builder-style object to manufacture [`ListAppMonitorsOutput`](crate::output::ListAppMonitorsOutput)
    pub fn builder() -> crate::output::list_app_monitors_output::Builder {
        crate::output::list_app_monitors_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAppMonitorOutput {}
impl std::fmt::Debug for DeleteAppMonitorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAppMonitorOutput");
        formatter.finish()
    }
}
/// See [`DeleteAppMonitorOutput`](crate::output::DeleteAppMonitorOutput)
pub mod delete_app_monitor_output {
    /// A builder for [`DeleteAppMonitorOutput`](crate::output::DeleteAppMonitorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAppMonitorOutput`](crate::output::DeleteAppMonitorOutput)
        pub fn build(self) -> crate::output::DeleteAppMonitorOutput {
            crate::output::DeleteAppMonitorOutput {}
        }
    }
}
impl DeleteAppMonitorOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAppMonitorOutput`](crate::output::DeleteAppMonitorOutput)
    pub fn builder() -> crate::output::delete_app_monitor_output::Builder {
        crate::output::delete_app_monitor_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAppMonitorOutput {}
impl std::fmt::Debug for UpdateAppMonitorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAppMonitorOutput");
        formatter.finish()
    }
}
/// See [`UpdateAppMonitorOutput`](crate::output::UpdateAppMonitorOutput)
pub mod update_app_monitor_output {
    /// A builder for [`UpdateAppMonitorOutput`](crate::output::UpdateAppMonitorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateAppMonitorOutput`](crate::output::UpdateAppMonitorOutput)
        pub fn build(self) -> crate::output::UpdateAppMonitorOutput {
            crate::output::UpdateAppMonitorOutput {}
        }
    }
}
impl UpdateAppMonitorOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAppMonitorOutput`](crate::output::UpdateAppMonitorOutput)
    pub fn builder() -> crate::output::update_app_monitor_output::Builder {
        crate::output::update_app_monitor_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAppMonitorOutput {
    /// <p>A structure containing all the configuration information for the app monitor.</p>
    pub app_monitor: std::option::Option<crate::model::AppMonitor>,
}
impl GetAppMonitorOutput {
    /// <p>A structure containing all the configuration information for the app monitor.</p>
    pub fn app_monitor(&self) -> std::option::Option<&crate::model::AppMonitor> {
        self.app_monitor.as_ref()
    }
}
impl std::fmt::Debug for GetAppMonitorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAppMonitorOutput");
        formatter.field("app_monitor", &self.app_monitor);
        formatter.finish()
    }
}
/// See [`GetAppMonitorOutput`](crate::output::GetAppMonitorOutput)
pub mod get_app_monitor_output {
    /// A builder for [`GetAppMonitorOutput`](crate::output::GetAppMonitorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_monitor: std::option::Option<crate::model::AppMonitor>,
    }
    impl Builder {
        /// <p>A structure containing all the configuration information for the app monitor.</p>
        pub fn app_monitor(mut self, input: crate::model::AppMonitor) -> Self {
            self.app_monitor = Some(input);
            self
        }
        /// <p>A structure containing all the configuration information for the app monitor.</p>
        pub fn set_app_monitor(
            mut self,
            input: std::option::Option<crate::model::AppMonitor>,
        ) -> Self {
            self.app_monitor = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAppMonitorOutput`](crate::output::GetAppMonitorOutput)
        pub fn build(self) -> crate::output::GetAppMonitorOutput {
            crate::output::GetAppMonitorOutput {
                app_monitor: self.app_monitor,
            }
        }
    }
}
impl GetAppMonitorOutput {
    /// Creates a new builder-style object to manufacture [`GetAppMonitorOutput`](crate::output::GetAppMonitorOutput)
    pub fn builder() -> crate::output::get_app_monitor_output::Builder {
        crate::output::get_app_monitor_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutRumEventsOutput {}
impl std::fmt::Debug for PutRumEventsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutRumEventsOutput");
        formatter.finish()
    }
}
/// See [`PutRumEventsOutput`](crate::output::PutRumEventsOutput)
pub mod put_rum_events_output {
    /// A builder for [`PutRumEventsOutput`](crate::output::PutRumEventsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutRumEventsOutput`](crate::output::PutRumEventsOutput)
        pub fn build(self) -> crate::output::PutRumEventsOutput {
            crate::output::PutRumEventsOutput {}
        }
    }
}
impl PutRumEventsOutput {
    /// Creates a new builder-style object to manufacture [`PutRumEventsOutput`](crate::output::PutRumEventsOutput)
    pub fn builder() -> crate::output::put_rum_events_output::Builder {
        crate::output::put_rum_events_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The ARN of the resource that you are viewing.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The list of tag keys and values associated with the resource you specified.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsForResourceOutput {
    /// <p>The ARN of the resource that you are viewing.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The list of tag keys and values associated with the resource you specified.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ARN of the resource that you are viewing.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource that you are viewing.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tag keys and values associated with the resource you specified.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The list of tag keys and values associated with the resource you specified.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}
