// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Route 53 Resolver
///
/// Client for invoking operations on Amazon Route 53 Resolver. Each operation on Amazon Route 53 Resolver is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_route53resolver::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_route53resolver::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_route53resolver::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AssociateFirewallRuleGroup`](crate::client::fluent_builders::AssociateFirewallRuleGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`creator_request_id(impl Into<String>)`](crate::client::fluent_builders::AssociateFirewallRuleGroup::creator_request_id) / [`set_creator_request_id(Option<String>)`](crate::client::fluent_builders::AssociateFirewallRuleGroup::set_creator_request_id): <p>A unique string that identifies the request and that allows failed requests to be retried without the risk of running the operation twice. <code>CreatorRequestId</code> can be any unique string, for example, a date/time stamp. </p>
    ///   - [`firewall_rule_group_id(impl Into<String>)`](crate::client::fluent_builders::AssociateFirewallRuleGroup::firewall_rule_group_id) / [`set_firewall_rule_group_id(Option<String>)`](crate::client::fluent_builders::AssociateFirewallRuleGroup::set_firewall_rule_group_id): <p>The unique identifier of the firewall rule group. </p>
    ///   - [`vpc_id(impl Into<String>)`](crate::client::fluent_builders::AssociateFirewallRuleGroup::vpc_id) / [`set_vpc_id(Option<String>)`](crate::client::fluent_builders::AssociateFirewallRuleGroup::set_vpc_id): <p>The unique identifier of the VPC that you want to associate with the rule group. </p>
    ///   - [`priority(i32)`](crate::client::fluent_builders::AssociateFirewallRuleGroup::priority) / [`set_priority(Option<i32>)`](crate::client::fluent_builders::AssociateFirewallRuleGroup::set_priority): <p>The setting that determines the processing order of the rule group among the rule groups that you associate with the specified VPC. DNS Firewall filters VPC traffic starting from the rule group with the lowest numeric priority setting. </p>  <p>You must specify a unique priority for each rule group that you associate with a single VPC. To make it easier to insert rule groups later, leave space between the numbers, for example, use 101, 200, and so on. You can change the priority setting for a rule group association after you create it.</p>  <p>The allowed values for <code>Priority</code> are between 100 and 9900.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::AssociateFirewallRuleGroup::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::AssociateFirewallRuleGroup::set_name): <p>A name that lets you identify the association, to manage and use it.</p>
    ///   - [`mutation_protection(MutationProtectionStatus)`](crate::client::fluent_builders::AssociateFirewallRuleGroup::mutation_protection) / [`set_mutation_protection(Option<MutationProtectionStatus>)`](crate::client::fluent_builders::AssociateFirewallRuleGroup::set_mutation_protection): <p>If enabled, this setting disallows modification or removal of the association, to help prevent against accidentally altering DNS firewall protections. When you create the association, the default setting is <code>DISABLED</code>. </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::AssociateFirewallRuleGroup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::AssociateFirewallRuleGroup::set_tags): <p>A list of the tag keys and values that you want to associate with the rule group association. </p>
    /// - On success, responds with [`AssociateFirewallRuleGroupOutput`](crate::output::AssociateFirewallRuleGroupOutput) with field(s):
    ///   - [`firewall_rule_group_association(Option<FirewallRuleGroupAssociation>)`](crate::output::AssociateFirewallRuleGroupOutput::firewall_rule_group_association): <p>The association that you just created. The association has an ID that you can use to identify it in other requests, like update and delete.</p>
    /// - On failure, responds with [`SdkError<AssociateFirewallRuleGroupError>`](crate::error::AssociateFirewallRuleGroupError)
    pub fn associate_firewall_rule_group(&self) -> fluent_builders::AssociateFirewallRuleGroup {
        fluent_builders::AssociateFirewallRuleGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateResolverEndpointIpAddress`](crate::client::fluent_builders::AssociateResolverEndpointIpAddress) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resolver_endpoint_id(impl Into<String>)`](crate::client::fluent_builders::AssociateResolverEndpointIpAddress::resolver_endpoint_id) / [`set_resolver_endpoint_id(Option<String>)`](crate::client::fluent_builders::AssociateResolverEndpointIpAddress::set_resolver_endpoint_id): <p>The ID of the Resolver endpoint that you want to associate IP addresses with.</p>
    ///   - [`ip_address(IpAddressUpdate)`](crate::client::fluent_builders::AssociateResolverEndpointIpAddress::ip_address) / [`set_ip_address(Option<IpAddressUpdate>)`](crate::client::fluent_builders::AssociateResolverEndpointIpAddress::set_ip_address): <p>Either the IPv4 address that you want to add to a Resolver endpoint or a subnet ID. If you specify a subnet ID, Resolver chooses an IP address for you from the available IPs in the specified subnet.</p>
    /// - On success, responds with [`AssociateResolverEndpointIpAddressOutput`](crate::output::AssociateResolverEndpointIpAddressOutput) with field(s):
    ///   - [`resolver_endpoint(Option<ResolverEndpoint>)`](crate::output::AssociateResolverEndpointIpAddressOutput::resolver_endpoint): <p>The response to an <code>AssociateResolverEndpointIpAddress</code> request.</p>
    /// - On failure, responds with [`SdkError<AssociateResolverEndpointIpAddressError>`](crate::error::AssociateResolverEndpointIpAddressError)
    pub fn associate_resolver_endpoint_ip_address(
        &self,
    ) -> fluent_builders::AssociateResolverEndpointIpAddress {
        fluent_builders::AssociateResolverEndpointIpAddress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateResolverQueryLogConfig`](crate::client::fluent_builders::AssociateResolverQueryLogConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resolver_query_log_config_id(impl Into<String>)`](crate::client::fluent_builders::AssociateResolverQueryLogConfig::resolver_query_log_config_id) / [`set_resolver_query_log_config_id(Option<String>)`](crate::client::fluent_builders::AssociateResolverQueryLogConfig::set_resolver_query_log_config_id): <p>The ID of the query logging configuration that you want to associate a VPC with.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::AssociateResolverQueryLogConfig::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::AssociateResolverQueryLogConfig::set_resource_id): <p>The ID of an Amazon VPC that you want this query logging configuration to log queries for.</p> <note>   <p>The VPCs and the query logging configuration must be in the same Region.</p>  </note>
    /// - On success, responds with [`AssociateResolverQueryLogConfigOutput`](crate::output::AssociateResolverQueryLogConfigOutput) with field(s):
    ///   - [`resolver_query_log_config_association(Option<ResolverQueryLogConfigAssociation>)`](crate::output::AssociateResolverQueryLogConfigOutput::resolver_query_log_config_association): <p>A complex type that contains settings for a specified association between an Amazon VPC and a query logging configuration.</p>
    /// - On failure, responds with [`SdkError<AssociateResolverQueryLogConfigError>`](crate::error::AssociateResolverQueryLogConfigError)
    pub fn associate_resolver_query_log_config(
        &self,
    ) -> fluent_builders::AssociateResolverQueryLogConfig {
        fluent_builders::AssociateResolverQueryLogConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateResolverRule`](crate::client::fluent_builders::AssociateResolverRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resolver_rule_id(impl Into<String>)`](crate::client::fluent_builders::AssociateResolverRule::resolver_rule_id) / [`set_resolver_rule_id(Option<String>)`](crate::client::fluent_builders::AssociateResolverRule::set_resolver_rule_id): <p>The ID of the Resolver rule that you want to associate with the VPC. To list the existing Resolver rules, use <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html">ListResolverRules</a>.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::AssociateResolverRule::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::AssociateResolverRule::set_name): <p>A name for the association that you're creating between a Resolver rule and a VPC.</p>
    ///   - [`vpc_id(impl Into<String>)`](crate::client::fluent_builders::AssociateResolverRule::vpc_id) / [`set_vpc_id(Option<String>)`](crate::client::fluent_builders::AssociateResolverRule::set_vpc_id): <p>The ID of the VPC that you want to associate the Resolver rule with.</p>
    /// - On success, responds with [`AssociateResolverRuleOutput`](crate::output::AssociateResolverRuleOutput) with field(s):
    ///   - [`resolver_rule_association(Option<ResolverRuleAssociation>)`](crate::output::AssociateResolverRuleOutput::resolver_rule_association): <p>Information about the <code>AssociateResolverRule</code> request, including the status of the request.</p>
    /// - On failure, responds with [`SdkError<AssociateResolverRuleError>`](crate::error::AssociateResolverRuleError)
    pub fn associate_resolver_rule(&self) -> fluent_builders::AssociateResolverRule {
        fluent_builders::AssociateResolverRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateFirewallDomainList`](crate::client::fluent_builders::CreateFirewallDomainList) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`creator_request_id(impl Into<String>)`](crate::client::fluent_builders::CreateFirewallDomainList::creator_request_id) / [`set_creator_request_id(Option<String>)`](crate::client::fluent_builders::CreateFirewallDomainList::set_creator_request_id): <p>A unique string that identifies the request and that allows you to retry failed requests without the risk of running the operation twice. <code>CreatorRequestId</code> can be any unique string, for example, a date/time stamp. </p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateFirewallDomainList::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateFirewallDomainList::set_name): <p>A name that lets you identify the domain list to manage and use it.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateFirewallDomainList::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateFirewallDomainList::set_tags): <p>A list of the tag keys and values that you want to associate with the domain list. </p>
    /// - On success, responds with [`CreateFirewallDomainListOutput`](crate::output::CreateFirewallDomainListOutput) with field(s):
    ///   - [`firewall_domain_list(Option<FirewallDomainList>)`](crate::output::CreateFirewallDomainListOutput::firewall_domain_list): <p>The domain list that you just created.</p>
    /// - On failure, responds with [`SdkError<CreateFirewallDomainListError>`](crate::error::CreateFirewallDomainListError)
    pub fn create_firewall_domain_list(&self) -> fluent_builders::CreateFirewallDomainList {
        fluent_builders::CreateFirewallDomainList::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateFirewallRule`](crate::client::fluent_builders::CreateFirewallRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`creator_request_id(impl Into<String>)`](crate::client::fluent_builders::CreateFirewallRule::creator_request_id) / [`set_creator_request_id(Option<String>)`](crate::client::fluent_builders::CreateFirewallRule::set_creator_request_id): <p>A unique string that identifies the request and that allows you to retry failed requests without the risk of running the operation twice. <code>CreatorRequestId</code> can be any unique string, for example, a date/time stamp. </p>
    ///   - [`firewall_rule_group_id(impl Into<String>)`](crate::client::fluent_builders::CreateFirewallRule::firewall_rule_group_id) / [`set_firewall_rule_group_id(Option<String>)`](crate::client::fluent_builders::CreateFirewallRule::set_firewall_rule_group_id): <p>The unique identifier of the firewall rule group where you want to create the rule. </p>
    ///   - [`firewall_domain_list_id(impl Into<String>)`](crate::client::fluent_builders::CreateFirewallRule::firewall_domain_list_id) / [`set_firewall_domain_list_id(Option<String>)`](crate::client::fluent_builders::CreateFirewallRule::set_firewall_domain_list_id): <p>The ID of the domain list that you want to use in the rule. </p>
    ///   - [`priority(i32)`](crate::client::fluent_builders::CreateFirewallRule::priority) / [`set_priority(Option<i32>)`](crate::client::fluent_builders::CreateFirewallRule::set_priority): <p>The setting that determines the processing order of the rule in the rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.</p>  <p>You must specify a unique priority for each rule in a rule group. To make it easier to insert rules later, leave space between the numbers, for example, use 100, 200, and so on. You can change the priority setting for the rules in a rule group at any time.</p>
    ///   - [`action(Action)`](crate::client::fluent_builders::CreateFirewallRule::action) / [`set_action(Option<Action>)`](crate::client::fluent_builders::CreateFirewallRule::set_action): <p>The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list:</p>  <ul>   <li> <p> <code>ALLOW</code> - Permit the request to go through.</p> </li>   <li> <p> <code>ALERT</code> - Permit the request and send metrics and logs to Cloud Watch.</p> </li>   <li> <p> <code>BLOCK</code> - Disallow the request. This option requires additional details in the rule's <code>BlockResponse</code>. </p> </li>  </ul>
    ///   - [`block_response(BlockResponse)`](crate::client::fluent_builders::CreateFirewallRule::block_response) / [`set_block_response(Option<BlockResponse>)`](crate::client::fluent_builders::CreateFirewallRule::set_block_response): <p>The way that you want DNS Firewall to block the request, used with the rule action setting <code>BLOCK</code>. </p>  <ul>   <li> <p> <code>NODATA</code> - Respond indicating that the query was successful, but no response is available for it.</p> </li>   <li> <p> <code>NXDOMAIN</code> - Respond indicating that the domain name that's in the query doesn't exist.</p> </li>   <li> <p> <code>OVERRIDE</code> - Provide a custom override in the response. This option requires custom handling details in the rule's <code>BlockOverride*</code> settings. </p> </li>  </ul>  <p>This setting is required if the rule action setting is <code>BLOCK</code>.</p>
    ///   - [`block_override_domain(impl Into<String>)`](crate::client::fluent_builders::CreateFirewallRule::block_override_domain) / [`set_block_override_domain(Option<String>)`](crate::client::fluent_builders::CreateFirewallRule::set_block_override_domain): <p>The custom DNS record to send back in response to the query. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>  <p>This setting is required if the <code>BlockResponse</code> setting is <code>OVERRIDE</code>.</p>
    ///   - [`block_override_dns_type(BlockOverrideDnsType)`](crate::client::fluent_builders::CreateFirewallRule::block_override_dns_type) / [`set_block_override_dns_type(Option<BlockOverrideDnsType>)`](crate::client::fluent_builders::CreateFirewallRule::set_block_override_dns_type): <p>The DNS record's type. This determines the format of the record value that you provided in <code>BlockOverrideDomain</code>. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>  <p>This setting is required if the <code>BlockResponse</code> setting is <code>OVERRIDE</code>.</p>
    ///   - [`block_override_ttl(i32)`](crate::client::fluent_builders::CreateFirewallRule::block_override_ttl) / [`set_block_override_ttl(Option<i32>)`](crate::client::fluent_builders::CreateFirewallRule::set_block_override_ttl): <p>The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>  <p>This setting is required if the <code>BlockResponse</code> setting is <code>OVERRIDE</code>.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateFirewallRule::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateFirewallRule::set_name): <p>A name that lets you identify the rule in the rule group.</p>
    /// - On success, responds with [`CreateFirewallRuleOutput`](crate::output::CreateFirewallRuleOutput) with field(s):
    ///   - [`firewall_rule(Option<FirewallRule>)`](crate::output::CreateFirewallRuleOutput::firewall_rule): <p>The firewall rule that you just created. </p>
    /// - On failure, responds with [`SdkError<CreateFirewallRuleError>`](crate::error::CreateFirewallRuleError)
    pub fn create_firewall_rule(&self) -> fluent_builders::CreateFirewallRule {
        fluent_builders::CreateFirewallRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateFirewallRuleGroup`](crate::client::fluent_builders::CreateFirewallRuleGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`creator_request_id(impl Into<String>)`](crate::client::fluent_builders::CreateFirewallRuleGroup::creator_request_id) / [`set_creator_request_id(Option<String>)`](crate::client::fluent_builders::CreateFirewallRuleGroup::set_creator_request_id): <p>A unique string defined by you to identify the request. This allows you to retry failed requests without the risk of running the operation twice. This can be any unique string, for example, a timestamp. </p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateFirewallRuleGroup::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateFirewallRuleGroup::set_name): <p>A name that lets you identify the rule group, to manage and use it.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateFirewallRuleGroup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateFirewallRuleGroup::set_tags): <p>A list of the tag keys and values that you want to associate with the rule group. </p>
    /// - On success, responds with [`CreateFirewallRuleGroupOutput`](crate::output::CreateFirewallRuleGroupOutput) with field(s):
    ///   - [`firewall_rule_group(Option<FirewallRuleGroup>)`](crate::output::CreateFirewallRuleGroupOutput::firewall_rule_group): <p>A collection of rules used to filter DNS network traffic. </p>
    /// - On failure, responds with [`SdkError<CreateFirewallRuleGroupError>`](crate::error::CreateFirewallRuleGroupError)
    pub fn create_firewall_rule_group(&self) -> fluent_builders::CreateFirewallRuleGroup {
        fluent_builders::CreateFirewallRuleGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateResolverEndpoint`](crate::client::fluent_builders::CreateResolverEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`creator_request_id(impl Into<String>)`](crate::client::fluent_builders::CreateResolverEndpoint::creator_request_id) / [`set_creator_request_id(Option<String>)`](crate::client::fluent_builders::CreateResolverEndpoint::set_creator_request_id): <p>A unique string that identifies the request and that allows failed requests to be retried without the risk of running the operation twice. <code>CreatorRequestId</code> can be any unique string, for example, a date/time stamp. </p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateResolverEndpoint::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateResolverEndpoint::set_name): <p>A friendly name that lets you easily find a configuration in the Resolver dashboard in the Route 53 console.</p>
    ///   - [`security_group_ids(Vec<String>)`](crate::client::fluent_builders::CreateResolverEndpoint::security_group_ids) / [`set_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateResolverEndpoint::set_security_group_ids): <p>The ID of one or more security groups that you want to use to control access to this VPC. The security group that you specify must include one or more inbound rules (for inbound Resolver endpoints) or outbound rules (for outbound Resolver endpoints). Inbound and outbound rules must allow TCP and UDP access. For inbound access, open port 53. For outbound access, open the port that you're using for DNS queries on your network.</p>
    ///   - [`direction(ResolverEndpointDirection)`](crate::client::fluent_builders::CreateResolverEndpoint::direction) / [`set_direction(Option<ResolverEndpointDirection>)`](crate::client::fluent_builders::CreateResolverEndpoint::set_direction): <p>Specify the applicable value:</p>  <ul>   <li> <p> <code>INBOUND</code>: Resolver forwards DNS queries to the DNS service for a VPC from your network</p> </li>   <li> <p> <code>OUTBOUND</code>: Resolver forwards DNS queries from the DNS service for a VPC to your network</p> </li>  </ul>
    ///   - [`ip_addresses(Vec<IpAddressRequest>)`](crate::client::fluent_builders::CreateResolverEndpoint::ip_addresses) / [`set_ip_addresses(Option<Vec<IpAddressRequest>>)`](crate::client::fluent_builders::CreateResolverEndpoint::set_ip_addresses): <p>The subnets and IP addresses in your VPC that DNS queries originate from (for outbound endpoints) or that you forward DNS queries to (for inbound endpoints). The subnet ID uniquely identifies a VPC. </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateResolverEndpoint::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateResolverEndpoint::set_tags): <p>A list of the tag keys and values that you want to associate with the endpoint.</p>
    /// - On success, responds with [`CreateResolverEndpointOutput`](crate::output::CreateResolverEndpointOutput) with field(s):
    ///   - [`resolver_endpoint(Option<ResolverEndpoint>)`](crate::output::CreateResolverEndpointOutput::resolver_endpoint): <p>Information about the <code>CreateResolverEndpoint</code> request, including the status of the request.</p>
    /// - On failure, responds with [`SdkError<CreateResolverEndpointError>`](crate::error::CreateResolverEndpointError)
    pub fn create_resolver_endpoint(&self) -> fluent_builders::CreateResolverEndpoint {
        fluent_builders::CreateResolverEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateResolverQueryLogConfig`](crate::client::fluent_builders::CreateResolverQueryLogConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateResolverQueryLogConfig::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateResolverQueryLogConfig::set_name): <p>The name that you want to give the query logging configuration.</p>
    ///   - [`destination_arn(impl Into<String>)`](crate::client::fluent_builders::CreateResolverQueryLogConfig::destination_arn) / [`set_destination_arn(Option<String>)`](crate::client::fluent_builders::CreateResolverQueryLogConfig::set_destination_arn): <p>The ARN of the resource that you want Resolver to send query logs. You can send query logs to an S3 bucket, a CloudWatch Logs log group, or a Kinesis Data Firehose delivery stream. Examples of valid values include the following:</p>  <ul>   <li> <p> <b>S3 bucket</b>: </p> <p> <code>arn:aws:s3:::examplebucket</code> </p> <p>You can optionally append a file prefix to the end of the ARN.</p> <p> <code>arn:aws:s3:::examplebucket/development/</code> </p> </li>   <li> <p> <b>CloudWatch Logs log group</b>: </p> <p> <code>arn:aws:logs:us-west-1:123456789012:log-group:/mystack-testgroup-12ABC1AB12A1:*</code> </p> </li>   <li> <p> <b>Kinesis Data Firehose delivery stream</b>:</p> <p> <code>arn:aws:kinesis:us-east-2:0123456789:stream/my_stream_name</code> </p> </li>  </ul>
    ///   - [`creator_request_id(impl Into<String>)`](crate::client::fluent_builders::CreateResolverQueryLogConfig::creator_request_id) / [`set_creator_request_id(Option<String>)`](crate::client::fluent_builders::CreateResolverQueryLogConfig::set_creator_request_id): <p>A unique string that identifies the request and that allows failed requests to be retried without the risk of running the operation twice. <code>CreatorRequestId</code> can be any unique string, for example, a date/time stamp. </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateResolverQueryLogConfig::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateResolverQueryLogConfig::set_tags): <p>A list of the tag keys and values that you want to associate with the query logging configuration.</p>
    /// - On success, responds with [`CreateResolverQueryLogConfigOutput`](crate::output::CreateResolverQueryLogConfigOutput) with field(s):
    ///   - [`resolver_query_log_config(Option<ResolverQueryLogConfig>)`](crate::output::CreateResolverQueryLogConfigOutput::resolver_query_log_config): <p>Information about the <code>CreateResolverQueryLogConfig</code> request, including the status of the request.</p>
    /// - On failure, responds with [`SdkError<CreateResolverQueryLogConfigError>`](crate::error::CreateResolverQueryLogConfigError)
    pub fn create_resolver_query_log_config(
        &self,
    ) -> fluent_builders::CreateResolverQueryLogConfig {
        fluent_builders::CreateResolverQueryLogConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateResolverRule`](crate::client::fluent_builders::CreateResolverRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`creator_request_id(impl Into<String>)`](crate::client::fluent_builders::CreateResolverRule::creator_request_id) / [`set_creator_request_id(Option<String>)`](crate::client::fluent_builders::CreateResolverRule::set_creator_request_id): <p>A unique string that identifies the request and that allows failed requests to be retried without the risk of running the operation twice. <code>CreatorRequestId</code> can be any unique string, for example, a date/time stamp. </p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateResolverRule::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateResolverRule::set_name): <p>A friendly name that lets you easily find a rule in the Resolver dashboard in the Route 53 console.</p>
    ///   - [`rule_type(RuleTypeOption)`](crate::client::fluent_builders::CreateResolverRule::rule_type) / [`set_rule_type(Option<RuleTypeOption>)`](crate::client::fluent_builders::CreateResolverRule::set_rule_type): <p>When you want to forward DNS queries for specified domain name to resolvers on your network, specify <code>FORWARD</code>.</p>  <p>When you have a forwarding rule to forward DNS queries for a domain to your network and you want Resolver to process queries for a subdomain of that domain, specify <code>SYSTEM</code>.</p>  <p>For example, to forward DNS queries for example.com to resolvers on your network, you create a rule and specify <code>FORWARD</code> for <code>RuleType</code>. To then have Resolver process queries for apex.example.com, you create a rule and specify <code>SYSTEM</code> for <code>RuleType</code>.</p>  <p>Currently, only Resolver can create rules that have a value of <code>RECURSIVE</code> for <code>RuleType</code>.</p>
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::CreateResolverRule::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::CreateResolverRule::set_domain_name): <p>DNS queries for this domain name are forwarded to the IP addresses that you specify in <code>TargetIps</code>. If a query matches multiple Resolver rules (example.com and www.example.com), outbound DNS queries are routed using the Resolver rule that contains the most specific domain name (www.example.com).</p>
    ///   - [`target_ips(Vec<TargetAddress>)`](crate::client::fluent_builders::CreateResolverRule::target_ips) / [`set_target_ips(Option<Vec<TargetAddress>>)`](crate::client::fluent_builders::CreateResolverRule::set_target_ips): <p>The IPs that you want Resolver to forward DNS queries to. You can specify only IPv4 addresses. Separate IP addresses with a space.</p>  <p> <code>TargetIps</code> is available only when the value of <code>Rule type</code> is <code>FORWARD</code>.</p>
    ///   - [`resolver_endpoint_id(impl Into<String>)`](crate::client::fluent_builders::CreateResolverRule::resolver_endpoint_id) / [`set_resolver_endpoint_id(Option<String>)`](crate::client::fluent_builders::CreateResolverRule::set_resolver_endpoint_id): <p>The ID of the outbound Resolver endpoint that you want to use to route DNS queries to the IP addresses that you specify in <code>TargetIps</code>.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateResolverRule::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateResolverRule::set_tags): <p>A list of the tag keys and values that you want to associate with the endpoint.</p>
    /// - On success, responds with [`CreateResolverRuleOutput`](crate::output::CreateResolverRuleOutput) with field(s):
    ///   - [`resolver_rule(Option<ResolverRule>)`](crate::output::CreateResolverRuleOutput::resolver_rule): <p>Information about the <code>CreateResolverRule</code> request, including the status of the request.</p>
    /// - On failure, responds with [`SdkError<CreateResolverRuleError>`](crate::error::CreateResolverRuleError)
    pub fn create_resolver_rule(&self) -> fluent_builders::CreateResolverRule {
        fluent_builders::CreateResolverRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteFirewallDomainList`](crate::client::fluent_builders::DeleteFirewallDomainList) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`firewall_domain_list_id(impl Into<String>)`](crate::client::fluent_builders::DeleteFirewallDomainList::firewall_domain_list_id) / [`set_firewall_domain_list_id(Option<String>)`](crate::client::fluent_builders::DeleteFirewallDomainList::set_firewall_domain_list_id): <p>The ID of the domain list that you want to delete. </p>
    /// - On success, responds with [`DeleteFirewallDomainListOutput`](crate::output::DeleteFirewallDomainListOutput) with field(s):
    ///   - [`firewall_domain_list(Option<FirewallDomainList>)`](crate::output::DeleteFirewallDomainListOutput::firewall_domain_list): <p>The domain list that you just deleted. </p>
    /// - On failure, responds with [`SdkError<DeleteFirewallDomainListError>`](crate::error::DeleteFirewallDomainListError)
    pub fn delete_firewall_domain_list(&self) -> fluent_builders::DeleteFirewallDomainList {
        fluent_builders::DeleteFirewallDomainList::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteFirewallRule`](crate::client::fluent_builders::DeleteFirewallRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`firewall_rule_group_id(impl Into<String>)`](crate::client::fluent_builders::DeleteFirewallRule::firewall_rule_group_id) / [`set_firewall_rule_group_id(Option<String>)`](crate::client::fluent_builders::DeleteFirewallRule::set_firewall_rule_group_id): <p>The unique identifier of the firewall rule group that you want to delete the rule from. </p>
    ///   - [`firewall_domain_list_id(impl Into<String>)`](crate::client::fluent_builders::DeleteFirewallRule::firewall_domain_list_id) / [`set_firewall_domain_list_id(Option<String>)`](crate::client::fluent_builders::DeleteFirewallRule::set_firewall_domain_list_id): <p>The ID of the domain list that's used in the rule. </p>
    /// - On success, responds with [`DeleteFirewallRuleOutput`](crate::output::DeleteFirewallRuleOutput) with field(s):
    ///   - [`firewall_rule(Option<FirewallRule>)`](crate::output::DeleteFirewallRuleOutput::firewall_rule): <p>The specification for the firewall rule that you just deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteFirewallRuleError>`](crate::error::DeleteFirewallRuleError)
    pub fn delete_firewall_rule(&self) -> fluent_builders::DeleteFirewallRule {
        fluent_builders::DeleteFirewallRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteFirewallRuleGroup`](crate::client::fluent_builders::DeleteFirewallRuleGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`firewall_rule_group_id(impl Into<String>)`](crate::client::fluent_builders::DeleteFirewallRuleGroup::firewall_rule_group_id) / [`set_firewall_rule_group_id(Option<String>)`](crate::client::fluent_builders::DeleteFirewallRuleGroup::set_firewall_rule_group_id): <p>The unique identifier of the firewall rule group that you want to delete. </p>
    /// - On success, responds with [`DeleteFirewallRuleGroupOutput`](crate::output::DeleteFirewallRuleGroupOutput) with field(s):
    ///   - [`firewall_rule_group(Option<FirewallRuleGroup>)`](crate::output::DeleteFirewallRuleGroupOutput::firewall_rule_group): <p>A collection of rules used to filter DNS network traffic. </p>
    /// - On failure, responds with [`SdkError<DeleteFirewallRuleGroupError>`](crate::error::DeleteFirewallRuleGroupError)
    pub fn delete_firewall_rule_group(&self) -> fluent_builders::DeleteFirewallRuleGroup {
        fluent_builders::DeleteFirewallRuleGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteResolverEndpoint`](crate::client::fluent_builders::DeleteResolverEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resolver_endpoint_id(impl Into<String>)`](crate::client::fluent_builders::DeleteResolverEndpoint::resolver_endpoint_id) / [`set_resolver_endpoint_id(Option<String>)`](crate::client::fluent_builders::DeleteResolverEndpoint::set_resolver_endpoint_id): <p>The ID of the Resolver endpoint that you want to delete.</p>
    /// - On success, responds with [`DeleteResolverEndpointOutput`](crate::output::DeleteResolverEndpointOutput) with field(s):
    ///   - [`resolver_endpoint(Option<ResolverEndpoint>)`](crate::output::DeleteResolverEndpointOutput::resolver_endpoint): <p>Information about the <code>DeleteResolverEndpoint</code> request, including the status of the request.</p>
    /// - On failure, responds with [`SdkError<DeleteResolverEndpointError>`](crate::error::DeleteResolverEndpointError)
    pub fn delete_resolver_endpoint(&self) -> fluent_builders::DeleteResolverEndpoint {
        fluent_builders::DeleteResolverEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteResolverQueryLogConfig`](crate::client::fluent_builders::DeleteResolverQueryLogConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resolver_query_log_config_id(impl Into<String>)`](crate::client::fluent_builders::DeleteResolverQueryLogConfig::resolver_query_log_config_id) / [`set_resolver_query_log_config_id(Option<String>)`](crate::client::fluent_builders::DeleteResolverQueryLogConfig::set_resolver_query_log_config_id): <p>The ID of the query logging configuration that you want to delete.</p>
    /// - On success, responds with [`DeleteResolverQueryLogConfigOutput`](crate::output::DeleteResolverQueryLogConfigOutput) with field(s):
    ///   - [`resolver_query_log_config(Option<ResolverQueryLogConfig>)`](crate::output::DeleteResolverQueryLogConfigOutput::resolver_query_log_config): <p>Information about the query logging configuration that you deleted, including the status of the request.</p>
    /// - On failure, responds with [`SdkError<DeleteResolverQueryLogConfigError>`](crate::error::DeleteResolverQueryLogConfigError)
    pub fn delete_resolver_query_log_config(
        &self,
    ) -> fluent_builders::DeleteResolverQueryLogConfig {
        fluent_builders::DeleteResolverQueryLogConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteResolverRule`](crate::client::fluent_builders::DeleteResolverRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resolver_rule_id(impl Into<String>)`](crate::client::fluent_builders::DeleteResolverRule::resolver_rule_id) / [`set_resolver_rule_id(Option<String>)`](crate::client::fluent_builders::DeleteResolverRule::set_resolver_rule_id): <p>The ID of the Resolver rule that you want to delete.</p>
    /// - On success, responds with [`DeleteResolverRuleOutput`](crate::output::DeleteResolverRuleOutput) with field(s):
    ///   - [`resolver_rule(Option<ResolverRule>)`](crate::output::DeleteResolverRuleOutput::resolver_rule): <p>Information about the <code>DeleteResolverRule</code> request, including the status of the request.</p>
    /// - On failure, responds with [`SdkError<DeleteResolverRuleError>`](crate::error::DeleteResolverRuleError)
    pub fn delete_resolver_rule(&self) -> fluent_builders::DeleteResolverRule {
        fluent_builders::DeleteResolverRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateFirewallRuleGroup`](crate::client::fluent_builders::DisassociateFirewallRuleGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`firewall_rule_group_association_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateFirewallRuleGroup::firewall_rule_group_association_id) / [`set_firewall_rule_group_association_id(Option<String>)`](crate::client::fluent_builders::DisassociateFirewallRuleGroup::set_firewall_rule_group_association_id): <p>The identifier of the <code>FirewallRuleGroupAssociation</code>. </p>
    /// - On success, responds with [`DisassociateFirewallRuleGroupOutput`](crate::output::DisassociateFirewallRuleGroupOutput) with field(s):
    ///   - [`firewall_rule_group_association(Option<FirewallRuleGroupAssociation>)`](crate::output::DisassociateFirewallRuleGroupOutput::firewall_rule_group_association): <p>The firewall rule group association that you just removed. </p>
    /// - On failure, responds with [`SdkError<DisassociateFirewallRuleGroupError>`](crate::error::DisassociateFirewallRuleGroupError)
    pub fn disassociate_firewall_rule_group(
        &self,
    ) -> fluent_builders::DisassociateFirewallRuleGroup {
        fluent_builders::DisassociateFirewallRuleGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateResolverEndpointIpAddress`](crate::client::fluent_builders::DisassociateResolverEndpointIpAddress) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resolver_endpoint_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateResolverEndpointIpAddress::resolver_endpoint_id) / [`set_resolver_endpoint_id(Option<String>)`](crate::client::fluent_builders::DisassociateResolverEndpointIpAddress::set_resolver_endpoint_id): <p>The ID of the Resolver endpoint that you want to disassociate an IP address from.</p>
    ///   - [`ip_address(IpAddressUpdate)`](crate::client::fluent_builders::DisassociateResolverEndpointIpAddress::ip_address) / [`set_ip_address(Option<IpAddressUpdate>)`](crate::client::fluent_builders::DisassociateResolverEndpointIpAddress::set_ip_address): <p>The IPv4 address that you want to remove from a Resolver endpoint.</p>
    /// - On success, responds with [`DisassociateResolverEndpointIpAddressOutput`](crate::output::DisassociateResolverEndpointIpAddressOutput) with field(s):
    ///   - [`resolver_endpoint(Option<ResolverEndpoint>)`](crate::output::DisassociateResolverEndpointIpAddressOutput::resolver_endpoint): <p>The response to an <code>DisassociateResolverEndpointIpAddress</code> request.</p>
    /// - On failure, responds with [`SdkError<DisassociateResolverEndpointIpAddressError>`](crate::error::DisassociateResolverEndpointIpAddressError)
    pub fn disassociate_resolver_endpoint_ip_address(
        &self,
    ) -> fluent_builders::DisassociateResolverEndpointIpAddress {
        fluent_builders::DisassociateResolverEndpointIpAddress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateResolverQueryLogConfig`](crate::client::fluent_builders::DisassociateResolverQueryLogConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resolver_query_log_config_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateResolverQueryLogConfig::resolver_query_log_config_id) / [`set_resolver_query_log_config_id(Option<String>)`](crate::client::fluent_builders::DisassociateResolverQueryLogConfig::set_resolver_query_log_config_id): <p>The ID of the query logging configuration that you want to disassociate a specified VPC from.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateResolverQueryLogConfig::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::DisassociateResolverQueryLogConfig::set_resource_id): <p>The ID of the Amazon VPC that you want to disassociate from a specified query logging configuration.</p>
    /// - On success, responds with [`DisassociateResolverQueryLogConfigOutput`](crate::output::DisassociateResolverQueryLogConfigOutput) with field(s):
    ///   - [`resolver_query_log_config_association(Option<ResolverQueryLogConfigAssociation>)`](crate::output::DisassociateResolverQueryLogConfigOutput::resolver_query_log_config_association): <p>A complex type that contains settings for the association that you deleted between an Amazon VPC and a query logging configuration.</p>
    /// - On failure, responds with [`SdkError<DisassociateResolverQueryLogConfigError>`](crate::error::DisassociateResolverQueryLogConfigError)
    pub fn disassociate_resolver_query_log_config(
        &self,
    ) -> fluent_builders::DisassociateResolverQueryLogConfig {
        fluent_builders::DisassociateResolverQueryLogConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateResolverRule`](crate::client::fluent_builders::DisassociateResolverRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`vpc_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateResolverRule::vpc_id) / [`set_vpc_id(Option<String>)`](crate::client::fluent_builders::DisassociateResolverRule::set_vpc_id): <p>The ID of the VPC that you want to disassociate the Resolver rule from.</p>
    ///   - [`resolver_rule_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateResolverRule::resolver_rule_id) / [`set_resolver_rule_id(Option<String>)`](crate::client::fluent_builders::DisassociateResolverRule::set_resolver_rule_id): <p>The ID of the Resolver rule that you want to disassociate from the specified VPC.</p>
    /// - On success, responds with [`DisassociateResolverRuleOutput`](crate::output::DisassociateResolverRuleOutput) with field(s):
    ///   - [`resolver_rule_association(Option<ResolverRuleAssociation>)`](crate::output::DisassociateResolverRuleOutput::resolver_rule_association): <p>Information about the <code>DisassociateResolverRule</code> request, including the status of the request.</p>
    /// - On failure, responds with [`SdkError<DisassociateResolverRuleError>`](crate::error::DisassociateResolverRuleError)
    pub fn disassociate_resolver_rule(&self) -> fluent_builders::DisassociateResolverRule {
        fluent_builders::DisassociateResolverRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetFirewallConfig`](crate::client::fluent_builders::GetFirewallConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::GetFirewallConfig::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::GetFirewallConfig::set_resource_id): <p>The ID of the VPC from Amazon VPC that the configuration is for.</p>
    /// - On success, responds with [`GetFirewallConfigOutput`](crate::output::GetFirewallConfigOutput) with field(s):
    ///   - [`firewall_config(Option<FirewallConfig>)`](crate::output::GetFirewallConfigOutput::firewall_config): <p>Configuration of the firewall behavior provided by DNS Firewall for a single VPC from AmazonVPC. </p>
    /// - On failure, responds with [`SdkError<GetFirewallConfigError>`](crate::error::GetFirewallConfigError)
    pub fn get_firewall_config(&self) -> fluent_builders::GetFirewallConfig {
        fluent_builders::GetFirewallConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetFirewallDomainList`](crate::client::fluent_builders::GetFirewallDomainList) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`firewall_domain_list_id(impl Into<String>)`](crate::client::fluent_builders::GetFirewallDomainList::firewall_domain_list_id) / [`set_firewall_domain_list_id(Option<String>)`](crate::client::fluent_builders::GetFirewallDomainList::set_firewall_domain_list_id): <p>The ID of the domain list. </p>
    /// - On success, responds with [`GetFirewallDomainListOutput`](crate::output::GetFirewallDomainListOutput) with field(s):
    ///   - [`firewall_domain_list(Option<FirewallDomainList>)`](crate::output::GetFirewallDomainListOutput::firewall_domain_list): <p>The domain list that you requested. </p>
    /// - On failure, responds with [`SdkError<GetFirewallDomainListError>`](crate::error::GetFirewallDomainListError)
    pub fn get_firewall_domain_list(&self) -> fluent_builders::GetFirewallDomainList {
        fluent_builders::GetFirewallDomainList::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetFirewallRuleGroup`](crate::client::fluent_builders::GetFirewallRuleGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`firewall_rule_group_id(impl Into<String>)`](crate::client::fluent_builders::GetFirewallRuleGroup::firewall_rule_group_id) / [`set_firewall_rule_group_id(Option<String>)`](crate::client::fluent_builders::GetFirewallRuleGroup::set_firewall_rule_group_id): <p>The unique identifier of the firewall rule group. </p>
    /// - On success, responds with [`GetFirewallRuleGroupOutput`](crate::output::GetFirewallRuleGroupOutput) with field(s):
    ///   - [`firewall_rule_group(Option<FirewallRuleGroup>)`](crate::output::GetFirewallRuleGroupOutput::firewall_rule_group): <p>A collection of rules used to filter DNS network traffic. </p>
    /// - On failure, responds with [`SdkError<GetFirewallRuleGroupError>`](crate::error::GetFirewallRuleGroupError)
    pub fn get_firewall_rule_group(&self) -> fluent_builders::GetFirewallRuleGroup {
        fluent_builders::GetFirewallRuleGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetFirewallRuleGroupAssociation`](crate::client::fluent_builders::GetFirewallRuleGroupAssociation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`firewall_rule_group_association_id(impl Into<String>)`](crate::client::fluent_builders::GetFirewallRuleGroupAssociation::firewall_rule_group_association_id) / [`set_firewall_rule_group_association_id(Option<String>)`](crate::client::fluent_builders::GetFirewallRuleGroupAssociation::set_firewall_rule_group_association_id): <p>The identifier of the <code>FirewallRuleGroupAssociation</code>. </p>
    /// - On success, responds with [`GetFirewallRuleGroupAssociationOutput`](crate::output::GetFirewallRuleGroupAssociationOutput) with field(s):
    ///   - [`firewall_rule_group_association(Option<FirewallRuleGroupAssociation>)`](crate::output::GetFirewallRuleGroupAssociationOutput::firewall_rule_group_association): <p>The association that you requested. </p>
    /// - On failure, responds with [`SdkError<GetFirewallRuleGroupAssociationError>`](crate::error::GetFirewallRuleGroupAssociationError)
    pub fn get_firewall_rule_group_association(
        &self,
    ) -> fluent_builders::GetFirewallRuleGroupAssociation {
        fluent_builders::GetFirewallRuleGroupAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetFirewallRuleGroupPolicy`](crate::client::fluent_builders::GetFirewallRuleGroupPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::GetFirewallRuleGroupPolicy::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::GetFirewallRuleGroupPolicy::set_arn): <p>The ARN (Amazon Resource Name) for the rule group.</p>
    /// - On success, responds with [`GetFirewallRuleGroupPolicyOutput`](crate::output::GetFirewallRuleGroupPolicyOutput) with field(s):
    ///   - [`firewall_rule_group_policy(Option<String>)`](crate::output::GetFirewallRuleGroupPolicyOutput::firewall_rule_group_policy): <p>The Identity and Access Management (Amazon Web Services IAM) policy for sharing the specified rule group. You can use the policy to share the rule group using Resource Access Manager (RAM). </p>
    /// - On failure, responds with [`SdkError<GetFirewallRuleGroupPolicyError>`](crate::error::GetFirewallRuleGroupPolicyError)
    pub fn get_firewall_rule_group_policy(&self) -> fluent_builders::GetFirewallRuleGroupPolicy {
        fluent_builders::GetFirewallRuleGroupPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetResolverConfig`](crate::client::fluent_builders::GetResolverConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::GetResolverConfig::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::GetResolverConfig::set_resource_id): <p>Resource ID of the Amazon VPC that you want to get information about.</p>
    /// - On success, responds with [`GetResolverConfigOutput`](crate::output::GetResolverConfigOutput) with field(s):
    ///   - [`resolver_config(Option<ResolverConfig>)`](crate::output::GetResolverConfigOutput::resolver_config): <p>Information about the behavior configuration of Route 53 Resolver behavior for the VPC you specified in the <code>GetResolverConfig</code> request.</p>
    /// - On failure, responds with [`SdkError<GetResolverConfigError>`](crate::error::GetResolverConfigError)
    pub fn get_resolver_config(&self) -> fluent_builders::GetResolverConfig {
        fluent_builders::GetResolverConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetResolverDnssecConfig`](crate::client::fluent_builders::GetResolverDnssecConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::GetResolverDnssecConfig::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::GetResolverDnssecConfig::set_resource_id): <p>The ID of the virtual private cloud (VPC) for the DNSSEC validation status.</p>
    /// - On success, responds with [`GetResolverDnssecConfigOutput`](crate::output::GetResolverDnssecConfigOutput) with field(s):
    ///   - [`resolver_dnssec_config(Option<ResolverDnssecConfig>)`](crate::output::GetResolverDnssecConfigOutput::resolver_dnssec_config): <p>The information about a configuration for DNSSEC validation.</p>
    /// - On failure, responds with [`SdkError<GetResolverDnssecConfigError>`](crate::error::GetResolverDnssecConfigError)
    pub fn get_resolver_dnssec_config(&self) -> fluent_builders::GetResolverDnssecConfig {
        fluent_builders::GetResolverDnssecConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetResolverEndpoint`](crate::client::fluent_builders::GetResolverEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resolver_endpoint_id(impl Into<String>)`](crate::client::fluent_builders::GetResolverEndpoint::resolver_endpoint_id) / [`set_resolver_endpoint_id(Option<String>)`](crate::client::fluent_builders::GetResolverEndpoint::set_resolver_endpoint_id): <p>The ID of the Resolver endpoint that you want to get information about.</p>
    /// - On success, responds with [`GetResolverEndpointOutput`](crate::output::GetResolverEndpointOutput) with field(s):
    ///   - [`resolver_endpoint(Option<ResolverEndpoint>)`](crate::output::GetResolverEndpointOutput::resolver_endpoint): <p>Information about the Resolver endpoint that you specified in a <code>GetResolverEndpoint</code> request.</p>
    /// - On failure, responds with [`SdkError<GetResolverEndpointError>`](crate::error::GetResolverEndpointError)
    pub fn get_resolver_endpoint(&self) -> fluent_builders::GetResolverEndpoint {
        fluent_builders::GetResolverEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetResolverQueryLogConfig`](crate::client::fluent_builders::GetResolverQueryLogConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resolver_query_log_config_id(impl Into<String>)`](crate::client::fluent_builders::GetResolverQueryLogConfig::resolver_query_log_config_id) / [`set_resolver_query_log_config_id(Option<String>)`](crate::client::fluent_builders::GetResolverQueryLogConfig::set_resolver_query_log_config_id): <p>The ID of the Resolver query logging configuration that you want to get information about.</p>
    /// - On success, responds with [`GetResolverQueryLogConfigOutput`](crate::output::GetResolverQueryLogConfigOutput) with field(s):
    ///   - [`resolver_query_log_config(Option<ResolverQueryLogConfig>)`](crate::output::GetResolverQueryLogConfigOutput::resolver_query_log_config): <p>Information about the Resolver query logging configuration that you specified in a <code>GetQueryLogConfig</code> request.</p>
    /// - On failure, responds with [`SdkError<GetResolverQueryLogConfigError>`](crate::error::GetResolverQueryLogConfigError)
    pub fn get_resolver_query_log_config(&self) -> fluent_builders::GetResolverQueryLogConfig {
        fluent_builders::GetResolverQueryLogConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetResolverQueryLogConfigAssociation`](crate::client::fluent_builders::GetResolverQueryLogConfigAssociation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resolver_query_log_config_association_id(impl Into<String>)`](crate::client::fluent_builders::GetResolverQueryLogConfigAssociation::resolver_query_log_config_association_id) / [`set_resolver_query_log_config_association_id(Option<String>)`](crate::client::fluent_builders::GetResolverQueryLogConfigAssociation::set_resolver_query_log_config_association_id): <p>The ID of the Resolver query logging configuration association that you want to get information about.</p>
    /// - On success, responds with [`GetResolverQueryLogConfigAssociationOutput`](crate::output::GetResolverQueryLogConfigAssociationOutput) with field(s):
    ///   - [`resolver_query_log_config_association(Option<ResolverQueryLogConfigAssociation>)`](crate::output::GetResolverQueryLogConfigAssociationOutput::resolver_query_log_config_association): <p>Information about the Resolver query logging configuration association that you specified in a <code>GetQueryLogConfigAssociation</code> request.</p>
    /// - On failure, responds with [`SdkError<GetResolverQueryLogConfigAssociationError>`](crate::error::GetResolverQueryLogConfigAssociationError)
    pub fn get_resolver_query_log_config_association(
        &self,
    ) -> fluent_builders::GetResolverQueryLogConfigAssociation {
        fluent_builders::GetResolverQueryLogConfigAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetResolverQueryLogConfigPolicy`](crate::client::fluent_builders::GetResolverQueryLogConfigPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::GetResolverQueryLogConfigPolicy::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::GetResolverQueryLogConfigPolicy::set_arn): <p>The ARN of the query logging configuration that you want to get the query logging policy for.</p>
    /// - On success, responds with [`GetResolverQueryLogConfigPolicyOutput`](crate::output::GetResolverQueryLogConfigPolicyOutput) with field(s):
    ///   - [`resolver_query_log_config_policy(Option<String>)`](crate::output::GetResolverQueryLogConfigPolicyOutput::resolver_query_log_config_policy): <p>Information about the query logging policy for the query logging configuration that you specified in a <code>GetResolverQueryLogConfigPolicy</code> request.</p>
    /// - On failure, responds with [`SdkError<GetResolverQueryLogConfigPolicyError>`](crate::error::GetResolverQueryLogConfigPolicyError)
    pub fn get_resolver_query_log_config_policy(
        &self,
    ) -> fluent_builders::GetResolverQueryLogConfigPolicy {
        fluent_builders::GetResolverQueryLogConfigPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetResolverRule`](crate::client::fluent_builders::GetResolverRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resolver_rule_id(impl Into<String>)`](crate::client::fluent_builders::GetResolverRule::resolver_rule_id) / [`set_resolver_rule_id(Option<String>)`](crate::client::fluent_builders::GetResolverRule::set_resolver_rule_id): <p>The ID of the Resolver rule that you want to get information about.</p>
    /// - On success, responds with [`GetResolverRuleOutput`](crate::output::GetResolverRuleOutput) with field(s):
    ///   - [`resolver_rule(Option<ResolverRule>)`](crate::output::GetResolverRuleOutput::resolver_rule): <p>Information about the Resolver rule that you specified in a <code>GetResolverRule</code> request.</p>
    /// - On failure, responds with [`SdkError<GetResolverRuleError>`](crate::error::GetResolverRuleError)
    pub fn get_resolver_rule(&self) -> fluent_builders::GetResolverRule {
        fluent_builders::GetResolverRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetResolverRuleAssociation`](crate::client::fluent_builders::GetResolverRuleAssociation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resolver_rule_association_id(impl Into<String>)`](crate::client::fluent_builders::GetResolverRuleAssociation::resolver_rule_association_id) / [`set_resolver_rule_association_id(Option<String>)`](crate::client::fluent_builders::GetResolverRuleAssociation::set_resolver_rule_association_id): <p>The ID of the Resolver rule association that you want to get information about.</p>
    /// - On success, responds with [`GetResolverRuleAssociationOutput`](crate::output::GetResolverRuleAssociationOutput) with field(s):
    ///   - [`resolver_rule_association(Option<ResolverRuleAssociation>)`](crate::output::GetResolverRuleAssociationOutput::resolver_rule_association): <p>Information about the Resolver rule association that you specified in a <code>GetResolverRuleAssociation</code> request.</p>
    /// - On failure, responds with [`SdkError<GetResolverRuleAssociationError>`](crate::error::GetResolverRuleAssociationError)
    pub fn get_resolver_rule_association(&self) -> fluent_builders::GetResolverRuleAssociation {
        fluent_builders::GetResolverRuleAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetResolverRulePolicy`](crate::client::fluent_builders::GetResolverRulePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::GetResolverRulePolicy::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::GetResolverRulePolicy::set_arn): <p>The ID of the Resolver rule that you want to get the Resolver rule policy for.</p>
    /// - On success, responds with [`GetResolverRulePolicyOutput`](crate::output::GetResolverRulePolicyOutput) with field(s):
    ///   - [`resolver_rule_policy(Option<String>)`](crate::output::GetResolverRulePolicyOutput::resolver_rule_policy): <p>The Resolver rule policy for the rule that you specified in a <code>GetResolverRulePolicy</code> request.</p>
    /// - On failure, responds with [`SdkError<GetResolverRulePolicyError>`](crate::error::GetResolverRulePolicyError)
    pub fn get_resolver_rule_policy(&self) -> fluent_builders::GetResolverRulePolicy {
        fluent_builders::GetResolverRulePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ImportFirewallDomains`](crate::client::fluent_builders::ImportFirewallDomains) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`firewall_domain_list_id(impl Into<String>)`](crate::client::fluent_builders::ImportFirewallDomains::firewall_domain_list_id) / [`set_firewall_domain_list_id(Option<String>)`](crate::client::fluent_builders::ImportFirewallDomains::set_firewall_domain_list_id): <p>The ID of the domain list that you want to modify with the import operation.</p>
    ///   - [`operation(FirewallDomainImportOperation)`](crate::client::fluent_builders::ImportFirewallDomains::operation) / [`set_operation(Option<FirewallDomainImportOperation>)`](crate::client::fluent_builders::ImportFirewallDomains::set_operation): <p>What you want DNS Firewall to do with the domains that are listed in the file. This must be set to <code>REPLACE</code>, which updates the domain list to exactly match the list in the file. </p>
    ///   - [`domain_file_url(impl Into<String>)`](crate::client::fluent_builders::ImportFirewallDomains::domain_file_url) / [`set_domain_file_url(Option<String>)`](crate::client::fluent_builders::ImportFirewallDomains::set_domain_file_url): <p>The fully qualified URL or URI of the file stored in Amazon Simple Storage Service (Amazon S3) that contains the list of domains to import.</p>  <p>The file must be in an S3 bucket that's in the same Region as your DNS Firewall. The file must be a text file and must contain a single domain per line.</p>
    /// - On success, responds with [`ImportFirewallDomainsOutput`](crate::output::ImportFirewallDomainsOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::ImportFirewallDomainsOutput::id): <p>The Id of the firewall domain list that DNS Firewall just updated.</p>
    ///   - [`name(Option<String>)`](crate::output::ImportFirewallDomainsOutput::name): <p>The name of the domain list. </p>
    ///   - [`status(Option<FirewallDomainListStatus>)`](crate::output::ImportFirewallDomainsOutput::status): <p> </p>
    ///   - [`status_message(Option<String>)`](crate::output::ImportFirewallDomainsOutput::status_message): <p>Additional information about the status of the list, if available.</p>
    /// - On failure, responds with [`SdkError<ImportFirewallDomainsError>`](crate::error::ImportFirewallDomainsError)
    pub fn import_firewall_domains(&self) -> fluent_builders::ImportFirewallDomains {
        fluent_builders::ImportFirewallDomains::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFirewallConfigs`](crate::client::fluent_builders::ListFirewallConfigs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListFirewallConfigs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListFirewallConfigs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListFirewallConfigs::set_max_results): <p>The maximum number of objects that you want Resolver to return for this request. If more objects are available, in the response, Resolver provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>  <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListFirewallConfigs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListFirewallConfigs::set_next_token): <p>For the first call to this list request, omit this value.</p>  <p>When you request a list of objects, Resolver returns at most the number of objects specified in <code>MaxResults</code>. If more objects are available for retrieval, Resolver returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token that was returned for the prior request in your next request.</p>
    /// - On success, responds with [`ListFirewallConfigsOutput`](crate::output::ListFirewallConfigsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListFirewallConfigsOutput::next_token): <p>If objects are still available for retrieval, Resolver returns this token in the response. To retrieve the next batch of objects, provide this token in your next request.</p>
    ///   - [`firewall_configs(Option<Vec<FirewallConfig>>)`](crate::output::ListFirewallConfigsOutput::firewall_configs): <p>The configurations for the firewall behavior provided by DNS Firewall for VPCs from Amazon Virtual Private Cloud (Amazon VPC). </p>
    /// - On failure, responds with [`SdkError<ListFirewallConfigsError>`](crate::error::ListFirewallConfigsError)
    pub fn list_firewall_configs(&self) -> fluent_builders::ListFirewallConfigs {
        fluent_builders::ListFirewallConfigs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFirewallDomainLists`](crate::client::fluent_builders::ListFirewallDomainLists) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListFirewallDomainLists::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListFirewallDomainLists::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListFirewallDomainLists::set_max_results): <p>The maximum number of objects that you want Resolver to return for this request. If more objects are available, in the response, Resolver provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>  <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListFirewallDomainLists::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListFirewallDomainLists::set_next_token): <p>For the first call to this list request, omit this value.</p>  <p>When you request a list of objects, Resolver returns at most the number of objects specified in <code>MaxResults</code>. If more objects are available for retrieval, Resolver returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token that was returned for the prior request in your next request.</p>
    /// - On success, responds with [`ListFirewallDomainListsOutput`](crate::output::ListFirewallDomainListsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListFirewallDomainListsOutput::next_token): <p>If objects are still available for retrieval, Resolver returns this token in the response. To retrieve the next batch of objects, provide this token in your next request.</p>
    ///   - [`firewall_domain_lists(Option<Vec<FirewallDomainListMetadata>>)`](crate::output::ListFirewallDomainListsOutput::firewall_domain_lists): <p>A list of the domain lists that you have defined. </p>  <p>This might be a partial list of the domain lists that you've defined. For information, see <code>MaxResults</code>. </p>
    /// - On failure, responds with [`SdkError<ListFirewallDomainListsError>`](crate::error::ListFirewallDomainListsError)
    pub fn list_firewall_domain_lists(&self) -> fluent_builders::ListFirewallDomainLists {
        fluent_builders::ListFirewallDomainLists::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFirewallDomains`](crate::client::fluent_builders::ListFirewallDomains) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListFirewallDomains::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`firewall_domain_list_id(impl Into<String>)`](crate::client::fluent_builders::ListFirewallDomains::firewall_domain_list_id) / [`set_firewall_domain_list_id(Option<String>)`](crate::client::fluent_builders::ListFirewallDomains::set_firewall_domain_list_id): <p>The ID of the domain list whose domains you want to retrieve. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListFirewallDomains::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListFirewallDomains::set_max_results): <p>The maximum number of objects that you want Resolver to return for this request. If more objects are available, in the response, Resolver provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>  <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListFirewallDomains::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListFirewallDomains::set_next_token): <p>For the first call to this list request, omit this value.</p>  <p>When you request a list of objects, Resolver returns at most the number of objects specified in <code>MaxResults</code>. If more objects are available for retrieval, Resolver returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token that was returned for the prior request in your next request.</p>
    /// - On success, responds with [`ListFirewallDomainsOutput`](crate::output::ListFirewallDomainsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListFirewallDomainsOutput::next_token): <p>If objects are still available for retrieval, Resolver returns this token in the response. To retrieve the next batch of objects, provide this token in your next request.</p>
    ///   - [`domains(Option<Vec<String>>)`](crate::output::ListFirewallDomainsOutput::domains): <p>A list of the domains in the firewall domain list. </p>  <p>This might be a partial list of the domains that you've defined in the domain list. For information, see <code>MaxResults</code>. </p>
    /// - On failure, responds with [`SdkError<ListFirewallDomainsError>`](crate::error::ListFirewallDomainsError)
    pub fn list_firewall_domains(&self) -> fluent_builders::ListFirewallDomains {
        fluent_builders::ListFirewallDomains::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFirewallRuleGroupAssociations`](crate::client::fluent_builders::ListFirewallRuleGroupAssociations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListFirewallRuleGroupAssociations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`firewall_rule_group_id(impl Into<String>)`](crate::client::fluent_builders::ListFirewallRuleGroupAssociations::firewall_rule_group_id) / [`set_firewall_rule_group_id(Option<String>)`](crate::client::fluent_builders::ListFirewallRuleGroupAssociations::set_firewall_rule_group_id): <p>The unique identifier of the firewall rule group that you want to retrieve the associations for. Leave this blank to retrieve associations for any rule group. </p>
    ///   - [`vpc_id(impl Into<String>)`](crate::client::fluent_builders::ListFirewallRuleGroupAssociations::vpc_id) / [`set_vpc_id(Option<String>)`](crate::client::fluent_builders::ListFirewallRuleGroupAssociations::set_vpc_id): <p>The unique identifier of the VPC that you want to retrieve the associations for. Leave this blank to retrieve associations for any VPC. </p>
    ///   - [`priority(i32)`](crate::client::fluent_builders::ListFirewallRuleGroupAssociations::priority) / [`set_priority(Option<i32>)`](crate::client::fluent_builders::ListFirewallRuleGroupAssociations::set_priority): <p>The setting that determines the processing order of the rule group among the rule groups that are associated with a single VPC. DNS Firewall filters VPC traffic starting from the rule group with the lowest numeric priority setting. </p>
    ///   - [`status(FirewallRuleGroupAssociationStatus)`](crate::client::fluent_builders::ListFirewallRuleGroupAssociations::status) / [`set_status(Option<FirewallRuleGroupAssociationStatus>)`](crate::client::fluent_builders::ListFirewallRuleGroupAssociations::set_status): <p>The association <code>Status</code> setting that you want DNS Firewall to filter on for the list. If you don't specify this, then DNS Firewall returns all associations, regardless of status.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListFirewallRuleGroupAssociations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListFirewallRuleGroupAssociations::set_max_results): <p>The maximum number of objects that you want Resolver to return for this request. If more objects are available, in the response, Resolver provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>  <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListFirewallRuleGroupAssociations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListFirewallRuleGroupAssociations::set_next_token): <p>For the first call to this list request, omit this value.</p>  <p>When you request a list of objects, Resolver returns at most the number of objects specified in <code>MaxResults</code>. If more objects are available for retrieval, Resolver returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token that was returned for the prior request in your next request.</p>
    /// - On success, responds with [`ListFirewallRuleGroupAssociationsOutput`](crate::output::ListFirewallRuleGroupAssociationsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListFirewallRuleGroupAssociationsOutput::next_token): <p>If objects are still available for retrieval, Resolver returns this token in the response. To retrieve the next batch of objects, provide this token in your next request.</p>
    ///   - [`firewall_rule_group_associations(Option<Vec<FirewallRuleGroupAssociation>>)`](crate::output::ListFirewallRuleGroupAssociationsOutput::firewall_rule_group_associations): <p>A list of your firewall rule group associations.</p>  <p>This might be a partial list of the associations that you have defined. For information, see <code>MaxResults</code>. </p>
    /// - On failure, responds with [`SdkError<ListFirewallRuleGroupAssociationsError>`](crate::error::ListFirewallRuleGroupAssociationsError)
    pub fn list_firewall_rule_group_associations(
        &self,
    ) -> fluent_builders::ListFirewallRuleGroupAssociations {
        fluent_builders::ListFirewallRuleGroupAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFirewallRuleGroups`](crate::client::fluent_builders::ListFirewallRuleGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListFirewallRuleGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListFirewallRuleGroups::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListFirewallRuleGroups::set_max_results): <p>The maximum number of objects that you want Resolver to return for this request. If more objects are available, in the response, Resolver provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>  <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListFirewallRuleGroups::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListFirewallRuleGroups::set_next_token): <p>For the first call to this list request, omit this value.</p>  <p>When you request a list of objects, Resolver returns at most the number of objects specified in <code>MaxResults</code>. If more objects are available for retrieval, Resolver returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token that was returned for the prior request in your next request.</p>
    /// - On success, responds with [`ListFirewallRuleGroupsOutput`](crate::output::ListFirewallRuleGroupsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListFirewallRuleGroupsOutput::next_token): <p>If objects are still available for retrieval, Resolver returns this token in the response. To retrieve the next batch of objects, provide this token in your next request.</p>
    ///   - [`firewall_rule_groups(Option<Vec<FirewallRuleGroupMetadata>>)`](crate::output::ListFirewallRuleGroupsOutput::firewall_rule_groups): <p>A list of your firewall rule groups.</p>  <p>This might be a partial list of the rule groups that you have defined. For information, see <code>MaxResults</code>. </p>
    /// - On failure, responds with [`SdkError<ListFirewallRuleGroupsError>`](crate::error::ListFirewallRuleGroupsError)
    pub fn list_firewall_rule_groups(&self) -> fluent_builders::ListFirewallRuleGroups {
        fluent_builders::ListFirewallRuleGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFirewallRules`](crate::client::fluent_builders::ListFirewallRules) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListFirewallRules::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`firewall_rule_group_id(impl Into<String>)`](crate::client::fluent_builders::ListFirewallRules::firewall_rule_group_id) / [`set_firewall_rule_group_id(Option<String>)`](crate::client::fluent_builders::ListFirewallRules::set_firewall_rule_group_id): <p>The unique identifier of the firewall rule group that you want to retrieve the rules for. </p>
    ///   - [`priority(i32)`](crate::client::fluent_builders::ListFirewallRules::priority) / [`set_priority(Option<i32>)`](crate::client::fluent_builders::ListFirewallRules::set_priority): <p>Optional additional filter for the rules to retrieve.</p>  <p>The setting that determines the processing order of the rules in a rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.</p>
    ///   - [`action(Action)`](crate::client::fluent_builders::ListFirewallRules::action) / [`set_action(Option<Action>)`](crate::client::fluent_builders::ListFirewallRules::set_action): <p>Optional additional filter for the rules to retrieve.</p>  <p>The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list:</p>  <ul>   <li> <p> <code>ALLOW</code> - Permit the request to go through.</p> </li>   <li> <p> <code>ALERT</code> - Permit the request to go through but send an alert to the logs.</p> </li>   <li> <p> <code>BLOCK</code> - Disallow the request. If this is specified, additional handling details are provided in the rule's <code>BlockResponse</code> setting. </p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListFirewallRules::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListFirewallRules::set_max_results): <p>The maximum number of objects that you want Resolver to return for this request. If more objects are available, in the response, Resolver provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>  <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListFirewallRules::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListFirewallRules::set_next_token): <p>For the first call to this list request, omit this value.</p>  <p>When you request a list of objects, Resolver returns at most the number of objects specified in <code>MaxResults</code>. If more objects are available for retrieval, Resolver returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token that was returned for the prior request in your next request.</p>
    /// - On success, responds with [`ListFirewallRulesOutput`](crate::output::ListFirewallRulesOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListFirewallRulesOutput::next_token): <p>If objects are still available for retrieval, Resolver returns this token in the response. To retrieve the next batch of objects, provide this token in your next request.</p>
    ///   - [`firewall_rules(Option<Vec<FirewallRule>>)`](crate::output::ListFirewallRulesOutput::firewall_rules): <p>A list of the rules that you have defined. </p>  <p>This might be a partial list of the firewall rules that you've defined. For information, see <code>MaxResults</code>. </p>
    /// - On failure, responds with [`SdkError<ListFirewallRulesError>`](crate::error::ListFirewallRulesError)
    pub fn list_firewall_rules(&self) -> fluent_builders::ListFirewallRules {
        fluent_builders::ListFirewallRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListResolverConfigs`](crate::client::fluent_builders::ListResolverConfigs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListResolverConfigs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListResolverConfigs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListResolverConfigs::set_max_results): <p>The maximum number of Resolver configurations that you want to return in the response to a <code>ListResolverConfigs</code> request. If you don't specify a value for <code>MaxResults</code>, up to 100 Resolver configurations are returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListResolverConfigs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListResolverConfigs::set_next_token): <p>(Optional) If the current Amazon Web Services account has more than <code>MaxResults</code> Resolver configurations, use <code>NextToken</code> to get the second and subsequent pages of results.</p>  <p>For the first <code>ListResolverConfigs</code> request, omit this value.</p>  <p>For the second and subsequent requests, get the value of <code>NextToken</code> from the previous response and specify that value for <code>NextToken</code> in the request.</p>
    /// - On success, responds with [`ListResolverConfigsOutput`](crate::output::ListResolverConfigsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListResolverConfigsOutput::next_token): <p>If a response includes the last of the Resolver configurations that are associated with the current Amazon Web Services account, <code>NextToken</code> doesn't appear in the response.</p>  <p>If a response doesn't include the last of the configurations, you can get more configurations by submitting another <code>ListResolverConfigs</code> request. Get the value of <code>NextToken</code> that Amazon Route 53 returned in the previous response and include it in <code>NextToken</code> in the next request.</p>
    ///   - [`resolver_configs(Option<Vec<ResolverConfig>>)`](crate::output::ListResolverConfigsOutput::resolver_configs): <p>An array that contains one <code>ResolverConfigs</code> element for each Resolver configuration that is associated with the current Amazon Web Services account.</p>
    /// - On failure, responds with [`SdkError<ListResolverConfigsError>`](crate::error::ListResolverConfigsError)
    pub fn list_resolver_configs(&self) -> fluent_builders::ListResolverConfigs {
        fluent_builders::ListResolverConfigs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListResolverDnssecConfigs`](crate::client::fluent_builders::ListResolverDnssecConfigs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListResolverDnssecConfigs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListResolverDnssecConfigs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListResolverDnssecConfigs::set_max_results): <p> <i>Optional</i>: An integer that specifies the maximum number of DNSSEC configuration results that you want Amazon Route 53 to return. If you don't specify a value for <code>MaxResults</code>, Route 53 returns up to 100 configuration per page.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListResolverDnssecConfigs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListResolverDnssecConfigs::set_next_token): <p>(Optional) If the current Amazon Web Services account has more than <code>MaxResults</code> DNSSEC configurations, use <code>NextToken</code> to get the second and subsequent pages of results.</p>  <p>For the first <code>ListResolverDnssecConfigs</code> request, omit this value.</p>  <p>For the second and subsequent requests, get the value of <code>NextToken</code> from the previous response and specify that value for <code>NextToken</code> in the request.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::ListResolverDnssecConfigs::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::ListResolverDnssecConfigs::set_filters): <p>An optional specification to return a subset of objects.</p>
    /// - On success, responds with [`ListResolverDnssecConfigsOutput`](crate::output::ListResolverDnssecConfigsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListResolverDnssecConfigsOutput::next_token): <p>If a response includes the last of the DNSSEC configurations that are associated with the current Amazon Web Services account, <code>NextToken</code> doesn't appear in the response.</p>  <p>If a response doesn't include the last of the configurations, you can get more configurations by submitting another <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListResolverDnssecConfigs.html">ListResolverDnssecConfigs</a> request. Get the value of <code>NextToken</code> that Amazon Route 53 returned in the previous response and include it in <code>NextToken</code> in the next request.</p>
    ///   - [`resolver_dnssec_configs(Option<Vec<ResolverDnssecConfig>>)`](crate::output::ListResolverDnssecConfigsOutput::resolver_dnssec_configs): <p>An array that contains one <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ResolverDnssecConfig.html">ResolverDnssecConfig</a> element for each configuration for DNSSEC validation that is associated with the current Amazon Web Services account.</p>
    /// - On failure, responds with [`SdkError<ListResolverDnssecConfigsError>`](crate::error::ListResolverDnssecConfigsError)
    pub fn list_resolver_dnssec_configs(&self) -> fluent_builders::ListResolverDnssecConfigs {
        fluent_builders::ListResolverDnssecConfigs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListResolverEndpointIpAddresses`](crate::client::fluent_builders::ListResolverEndpointIpAddresses) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListResolverEndpointIpAddresses::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`resolver_endpoint_id(impl Into<String>)`](crate::client::fluent_builders::ListResolverEndpointIpAddresses::resolver_endpoint_id) / [`set_resolver_endpoint_id(Option<String>)`](crate::client::fluent_builders::ListResolverEndpointIpAddresses::set_resolver_endpoint_id): <p>The ID of the Resolver endpoint that you want to get IP addresses for.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListResolverEndpointIpAddresses::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListResolverEndpointIpAddresses::set_max_results): <p>The maximum number of IP addresses that you want to return in the response to a <code>ListResolverEndpointIpAddresses</code> request. If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 IP addresses. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListResolverEndpointIpAddresses::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListResolverEndpointIpAddresses::set_next_token): <p>For the first <code>ListResolverEndpointIpAddresses</code> request, omit this value.</p>  <p>If the specified Resolver endpoint has more than <code>MaxResults</code> IP addresses, you can submit another <code>ListResolverEndpointIpAddresses</code> request to get the next group of IP addresses. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
    /// - On success, responds with [`ListResolverEndpointIpAddressesOutput`](crate::output::ListResolverEndpointIpAddressesOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListResolverEndpointIpAddressesOutput::next_token): <p>If the specified endpoint has more than <code>MaxResults</code> IP addresses, you can submit another <code>ListResolverEndpointIpAddresses</code> request to get the next group of IP addresses. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
    ///   - [`max_results(Option<i32>)`](crate::output::ListResolverEndpointIpAddressesOutput::max_results): <p>The value that you specified for <code>MaxResults</code> in the request.</p>
    ///   - [`ip_addresses(Option<Vec<IpAddressResponse>>)`](crate::output::ListResolverEndpointIpAddressesOutput::ip_addresses): <p>Information about the IP addresses in your VPC that DNS queries originate from (for outbound endpoints) or that you forward DNS queries to (for inbound endpoints).</p>
    /// - On failure, responds with [`SdkError<ListResolverEndpointIpAddressesError>`](crate::error::ListResolverEndpointIpAddressesError)
    pub fn list_resolver_endpoint_ip_addresses(
        &self,
    ) -> fluent_builders::ListResolverEndpointIpAddresses {
        fluent_builders::ListResolverEndpointIpAddresses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListResolverEndpoints`](crate::client::fluent_builders::ListResolverEndpoints) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListResolverEndpoints::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListResolverEndpoints::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListResolverEndpoints::set_max_results): <p>The maximum number of Resolver endpoints that you want to return in the response to a <code>ListResolverEndpoints</code> request. If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 Resolver endpoints. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListResolverEndpoints::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListResolverEndpoints::set_next_token): <p>For the first <code>ListResolverEndpoints</code> request, omit this value.</p>  <p>If you have more than <code>MaxResults</code> Resolver endpoints, you can submit another <code>ListResolverEndpoints</code> request to get the next group of Resolver endpoints. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::ListResolverEndpoints::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::ListResolverEndpoints::set_filters): <p>An optional specification to return a subset of Resolver endpoints, such as all inbound Resolver endpoints.</p> <note>   <p>If you submit a second or subsequent <code>ListResolverEndpoints</code> request and specify the <code>NextToken</code> parameter, you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>  </note>
    /// - On success, responds with [`ListResolverEndpointsOutput`](crate::output::ListResolverEndpointsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListResolverEndpointsOutput::next_token): <p>If more than <code>MaxResults</code> IP addresses match the specified criteria, you can submit another <code>ListResolverEndpoint</code> request to get the next group of results. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
    ///   - [`max_results(Option<i32>)`](crate::output::ListResolverEndpointsOutput::max_results): <p>The value that you specified for <code>MaxResults</code> in the request.</p>
    ///   - [`resolver_endpoints(Option<Vec<ResolverEndpoint>>)`](crate::output::ListResolverEndpointsOutput::resolver_endpoints): <p>The Resolver endpoints that were created by using the current Amazon Web Services account, and that match the specified filters, if any.</p>
    /// - On failure, responds with [`SdkError<ListResolverEndpointsError>`](crate::error::ListResolverEndpointsError)
    pub fn list_resolver_endpoints(&self) -> fluent_builders::ListResolverEndpoints {
        fluent_builders::ListResolverEndpoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListResolverQueryLogConfigAssociations`](crate::client::fluent_builders::ListResolverQueryLogConfigAssociations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListResolverQueryLogConfigAssociations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListResolverQueryLogConfigAssociations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListResolverQueryLogConfigAssociations::set_max_results): <p>The maximum number of query logging associations that you want to return in the response to a <code>ListResolverQueryLogConfigAssociations</code> request. If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 query logging associations. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListResolverQueryLogConfigAssociations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListResolverQueryLogConfigAssociations::set_next_token): <p>For the first <code>ListResolverQueryLogConfigAssociations</code> request, omit this value.</p>  <p>If there are more than <code>MaxResults</code> query logging associations that match the values that you specify for <code>Filters</code>, you can submit another <code>ListResolverQueryLogConfigAssociations</code> request to get the next group of associations. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::ListResolverQueryLogConfigAssociations::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::ListResolverQueryLogConfigAssociations::set_filters): <p>An optional specification to return a subset of query logging associations.</p> <note>   <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigAssociations</code> request and specify the <code>NextToken</code> parameter, you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>  </note>
    ///   - [`sort_by(impl Into<String>)`](crate::client::fluent_builders::ListResolverQueryLogConfigAssociations::sort_by) / [`set_sort_by(Option<String>)`](crate::client::fluent_builders::ListResolverQueryLogConfigAssociations::set_sort_by): <p>The element that you want Resolver to sort query logging associations by. </p> <note>   <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigAssociations</code> request and specify the <code>NextToken</code> parameter, you must use the same value for <code>SortBy</code>, if any, as in the previous request.</p>  </note>  <p>Valid values include the following elements:</p>  <ul>   <li> <p> <code>CreationTime</code>: The ID of the query logging association.</p> </li>   <li> <p> <code>Error</code>: If the value of <code>Status</code> is <code>FAILED</code>, the value of <code>Error</code> indicates the cause: </p>    <ul>     <li> <p> <code>DESTINATION_NOT_FOUND</code>: The specified destination (for example, an Amazon S3 bucket) was deleted.</p> </li>     <li> <p> <code>ACCESS_DENIED</code>: Permissions don't allow sending logs to the destination.</p> </li>    </ul> <p>If <code>Status</code> is a value other than <code>FAILED</code>, <code>ERROR</code> is null.</p> </li>   <li> <p> <code>Id</code>: The ID of the query logging association</p> </li>   <li> <p> <code>ResolverQueryLogConfigId</code>: The ID of the query logging configuration</p> </li>   <li> <p> <code>ResourceId</code>: The ID of the VPC that is associated with the query logging configuration</p> </li>   <li> <p> <code>Status</code>: The current status of the configuration. Valid values include the following:</p>    <ul>     <li> <p> <code>CREATING</code>: Resolver is creating an association between an Amazon VPC and a query logging configuration.</p> </li>     <li> <p> <code>CREATED</code>: The association between an Amazon VPC and a query logging configuration was successfully created. Resolver is logging queries that originate in the specified VPC.</p> </li>     <li> <p> <code>DELETING</code>: Resolver is deleting this query logging association.</p> </li>     <li> <p> <code>FAILED</code>: Resolver either couldn't create or couldn't delete the query logging association. Here are two common causes:</p>      <ul>       <li> <p>The specified destination (for example, an Amazon S3 bucket) was deleted.</p> </li>       <li> <p>Permissions don't allow sending logs to the destination.</p> </li>      </ul> </li>    </ul> </li>  </ul>
    ///   - [`sort_order(SortOrder)`](crate::client::fluent_builders::ListResolverQueryLogConfigAssociations::sort_order) / [`set_sort_order(Option<SortOrder>)`](crate::client::fluent_builders::ListResolverQueryLogConfigAssociations::set_sort_order): <p>If you specified a value for <code>SortBy</code>, the order that you want query logging associations to be listed in, <code>ASCENDING</code> or <code>DESCENDING</code>.</p> <note>   <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigAssociations</code> request and specify the <code>NextToken</code> parameter, you must use the same value for <code>SortOrder</code>, if any, as in the previous request.</p>  </note>
    /// - On success, responds with [`ListResolverQueryLogConfigAssociationsOutput`](crate::output::ListResolverQueryLogConfigAssociationsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListResolverQueryLogConfigAssociationsOutput::next_token): <p>If there are more than <code>MaxResults</code> query logging associations, you can submit another <code>ListResolverQueryLogConfigAssociations</code> request to get the next group of associations. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
    ///   - [`total_count(i32)`](crate::output::ListResolverQueryLogConfigAssociationsOutput::total_count): <p>The total number of query logging associations that were created by the current account in the specified Region. This count can differ from the number of associations that are returned in a <code>ListResolverQueryLogConfigAssociations</code> response, depending on the values that you specify in the request.</p>
    ///   - [`total_filtered_count(i32)`](crate::output::ListResolverQueryLogConfigAssociationsOutput::total_filtered_count): <p>The total number of query logging associations that were created by the current account in the specified Region and that match the filters that were specified in the <code>ListResolverQueryLogConfigAssociations</code> request. For the total number of associations that were created by the current account in the specified Region, see <code>TotalCount</code>.</p>
    ///   - [`resolver_query_log_config_associations(Option<Vec<ResolverQueryLogConfigAssociation>>)`](crate::output::ListResolverQueryLogConfigAssociationsOutput::resolver_query_log_config_associations): <p>A list that contains one <code>ResolverQueryLogConfigAssociations</code> element for each query logging association that matches the values that you specified for <code>Filter</code>.</p>
    /// - On failure, responds with [`SdkError<ListResolverQueryLogConfigAssociationsError>`](crate::error::ListResolverQueryLogConfigAssociationsError)
    pub fn list_resolver_query_log_config_associations(
        &self,
    ) -> fluent_builders::ListResolverQueryLogConfigAssociations {
        fluent_builders::ListResolverQueryLogConfigAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListResolverQueryLogConfigs`](crate::client::fluent_builders::ListResolverQueryLogConfigs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListResolverQueryLogConfigs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListResolverQueryLogConfigs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListResolverQueryLogConfigs::set_max_results): <p>The maximum number of query logging configurations that you want to return in the response to a <code>ListResolverQueryLogConfigs</code> request. If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 query logging configurations. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListResolverQueryLogConfigs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListResolverQueryLogConfigs::set_next_token): <p>For the first <code>ListResolverQueryLogConfigs</code> request, omit this value.</p>  <p>If there are more than <code>MaxResults</code> query logging configurations that match the values that you specify for <code>Filters</code>, you can submit another <code>ListResolverQueryLogConfigs</code> request to get the next group of configurations. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::ListResolverQueryLogConfigs::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::ListResolverQueryLogConfigs::set_filters): <p>An optional specification to return a subset of query logging configurations.</p> <note>   <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the <code>NextToken</code> parameter, you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>  </note>
    ///   - [`sort_by(impl Into<String>)`](crate::client::fluent_builders::ListResolverQueryLogConfigs::sort_by) / [`set_sort_by(Option<String>)`](crate::client::fluent_builders::ListResolverQueryLogConfigs::set_sort_by): <p>The element that you want Resolver to sort query logging configurations by. </p> <note>   <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the <code>NextToken</code> parameter, you must use the same value for <code>SortBy</code>, if any, as in the previous request.</p>  </note>  <p>Valid values include the following elements:</p>  <ul>   <li> <p> <code>Arn</code>: The ARN of the query logging configuration</p> </li>   <li> <p> <code>AssociationCount</code>: The number of VPCs that are associated with the specified configuration </p> </li>   <li> <p> <code>CreationTime</code>: The date and time that Resolver returned when the configuration was created</p> </li>   <li> <p> <code>CreatorRequestId</code>: The value that was specified for <code>CreatorRequestId</code> when the configuration was created</p> </li>   <li> <p> <code>DestinationArn</code>: The location that logs are sent to</p> </li>   <li> <p> <code>Id</code>: The ID of the configuration</p> </li>   <li> <p> <code>Name</code>: The name of the configuration</p> </li>   <li> <p> <code>OwnerId</code>: The Amazon Web Services account number of the account that created the configuration</p> </li>   <li> <p> <code>ShareStatus</code>: Whether the configuration is shared with other Amazon Web Services accounts or shared with the current account by another Amazon Web Services account. Sharing is configured through Resource Access Manager (RAM).</p> </li>   <li> <p> <code>Status</code>: The current status of the configuration. Valid values include the following:</p>    <ul>     <li> <p> <code>CREATING</code>: Resolver is creating the query logging configuration.</p> </li>     <li> <p> <code>CREATED</code>: The query logging configuration was successfully created. Resolver is logging queries that originate in the specified VPC.</p> </li>     <li> <p> <code>DELETING</code>: Resolver is deleting this query logging configuration.</p> </li>     <li> <p> <code>FAILED</code>: Resolver either couldn't create or couldn't delete the query logging configuration. Here are two common causes:</p>      <ul>       <li> <p>The specified destination (for example, an Amazon S3 bucket) was deleted.</p> </li>       <li> <p>Permissions don't allow sending logs to the destination.</p> </li>      </ul> </li>    </ul> </li>  </ul>
    ///   - [`sort_order(SortOrder)`](crate::client::fluent_builders::ListResolverQueryLogConfigs::sort_order) / [`set_sort_order(Option<SortOrder>)`](crate::client::fluent_builders::ListResolverQueryLogConfigs::set_sort_order): <p>If you specified a value for <code>SortBy</code>, the order that you want query logging configurations to be listed in, <code>ASCENDING</code> or <code>DESCENDING</code>.</p> <note>   <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the <code>NextToken</code> parameter, you must use the same value for <code>SortOrder</code>, if any, as in the previous request.</p>  </note>
    /// - On success, responds with [`ListResolverQueryLogConfigsOutput`](crate::output::ListResolverQueryLogConfigsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListResolverQueryLogConfigsOutput::next_token): <p>If there are more than <code>MaxResults</code> query logging configurations, you can submit another <code>ListResolverQueryLogConfigs</code> request to get the next group of configurations. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
    ///   - [`total_count(i32)`](crate::output::ListResolverQueryLogConfigsOutput::total_count): <p>The total number of query logging configurations that were created by the current account in the specified Region. This count can differ from the number of query logging configurations that are returned in a <code>ListResolverQueryLogConfigs</code> response, depending on the values that you specify in the request.</p>
    ///   - [`total_filtered_count(i32)`](crate::output::ListResolverQueryLogConfigsOutput::total_filtered_count): <p>The total number of query logging configurations that were created by the current account in the specified Region and that match the filters that were specified in the <code>ListResolverQueryLogConfigs</code> request. For the total number of query logging configurations that were created by the current account in the specified Region, see <code>TotalCount</code>.</p>
    ///   - [`resolver_query_log_configs(Option<Vec<ResolverQueryLogConfig>>)`](crate::output::ListResolverQueryLogConfigsOutput::resolver_query_log_configs): <p>A list that contains one <code>ResolverQueryLogConfig</code> element for each query logging configuration that matches the values that you specified for <code>Filter</code>.</p>
    /// - On failure, responds with [`SdkError<ListResolverQueryLogConfigsError>`](crate::error::ListResolverQueryLogConfigsError)
    pub fn list_resolver_query_log_configs(&self) -> fluent_builders::ListResolverQueryLogConfigs {
        fluent_builders::ListResolverQueryLogConfigs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListResolverRuleAssociations`](crate::client::fluent_builders::ListResolverRuleAssociations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListResolverRuleAssociations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListResolverRuleAssociations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListResolverRuleAssociations::set_max_results): <p>The maximum number of rule associations that you want to return in the response to a <code>ListResolverRuleAssociations</code> request. If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 rule associations. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListResolverRuleAssociations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListResolverRuleAssociations::set_next_token): <p>For the first <code>ListResolverRuleAssociation</code> request, omit this value.</p>  <p>If you have more than <code>MaxResults</code> rule associations, you can submit another <code>ListResolverRuleAssociation</code> request to get the next group of rule associations. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::ListResolverRuleAssociations::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::ListResolverRuleAssociations::set_filters): <p>An optional specification to return a subset of Resolver rules, such as Resolver rules that are associated with the same VPC ID.</p> <note>   <p>If you submit a second or subsequent <code>ListResolverRuleAssociations</code> request and specify the <code>NextToken</code> parameter, you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>  </note>
    /// - On success, responds with [`ListResolverRuleAssociationsOutput`](crate::output::ListResolverRuleAssociationsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListResolverRuleAssociationsOutput::next_token): <p>If more than <code>MaxResults</code> rule associations match the specified criteria, you can submit another <code>ListResolverRuleAssociation</code> request to get the next group of results. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
    ///   - [`max_results(Option<i32>)`](crate::output::ListResolverRuleAssociationsOutput::max_results): <p>The value that you specified for <code>MaxResults</code> in the request.</p>
    ///   - [`resolver_rule_associations(Option<Vec<ResolverRuleAssociation>>)`](crate::output::ListResolverRuleAssociationsOutput::resolver_rule_associations): <p>The associations that were created between Resolver rules and VPCs using the current Amazon Web Services account, and that match the specified filters, if any.</p>
    /// - On failure, responds with [`SdkError<ListResolverRuleAssociationsError>`](crate::error::ListResolverRuleAssociationsError)
    pub fn list_resolver_rule_associations(&self) -> fluent_builders::ListResolverRuleAssociations {
        fluent_builders::ListResolverRuleAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListResolverRules`](crate::client::fluent_builders::ListResolverRules) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListResolverRules::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListResolverRules::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListResolverRules::set_max_results): <p>The maximum number of Resolver rules that you want to return in the response to a <code>ListResolverRules</code> request. If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 Resolver rules.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListResolverRules::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListResolverRules::set_next_token): <p>For the first <code>ListResolverRules</code> request, omit this value.</p>  <p>If you have more than <code>MaxResults</code> Resolver rules, you can submit another <code>ListResolverRules</code> request to get the next group of Resolver rules. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::ListResolverRules::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::ListResolverRules::set_filters): <p>An optional specification to return a subset of Resolver rules, such as all Resolver rules that are associated with the same Resolver endpoint.</p> <note>   <p>If you submit a second or subsequent <code>ListResolverRules</code> request and specify the <code>NextToken</code> parameter, you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>  </note>
    /// - On success, responds with [`ListResolverRulesOutput`](crate::output::ListResolverRulesOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListResolverRulesOutput::next_token): <p>If more than <code>MaxResults</code> Resolver rules match the specified criteria, you can submit another <code>ListResolverRules</code> request to get the next group of results. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
    ///   - [`max_results(Option<i32>)`](crate::output::ListResolverRulesOutput::max_results): <p>The value that you specified for <code>MaxResults</code> in the request.</p>
    ///   - [`resolver_rules(Option<Vec<ResolverRule>>)`](crate::output::ListResolverRulesOutput::resolver_rules): <p>The Resolver rules that were created using the current Amazon Web Services account and that match the specified filters, if any.</p>
    /// - On failure, responds with [`SdkError<ListResolverRulesError>`](crate::error::ListResolverRulesError)
    pub fn list_resolver_rules(&self) -> fluent_builders::ListResolverRules {
        fluent_builders::ListResolverRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTagsForResource::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) for the resource that you want to list tags for.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTagsForResource::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTagsForResource::set_max_results): <p>The maximum number of tags that you want to return in the response to a <code>ListTagsForResource</code> request. If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 tags.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_next_token): <p>For the first <code>ListTagsForResource</code> request, omit this value.</p>  <p>If you have more than <code>MaxResults</code> tags, you can submit another <code>ListTagsForResource</code> request to get the next group of tags for the resource. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The tags that are associated with the resource that you specified in the <code>ListTagsForResource</code> request.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTagsForResourceOutput::next_token): <p>If more than <code>MaxResults</code> tags match the specified criteria, you can submit another <code>ListTagsForResource</code> request to get the next group of results. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutFirewallRuleGroupPolicy`](crate::client::fluent_builders::PutFirewallRuleGroupPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::PutFirewallRuleGroupPolicy::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::PutFirewallRuleGroupPolicy::set_arn): <p>The ARN (Amazon Resource Name) for the rule group that you want to share.</p>
    ///   - [`firewall_rule_group_policy(impl Into<String>)`](crate::client::fluent_builders::PutFirewallRuleGroupPolicy::firewall_rule_group_policy) / [`set_firewall_rule_group_policy(Option<String>)`](crate::client::fluent_builders::PutFirewallRuleGroupPolicy::set_firewall_rule_group_policy): <p>The Identity and Access Management (Amazon Web Services IAM) policy to attach to the rule group.</p>
    /// - On success, responds with [`PutFirewallRuleGroupPolicyOutput`](crate::output::PutFirewallRuleGroupPolicyOutput) with field(s):
    ///   - [`return_value(bool)`](crate::output::PutFirewallRuleGroupPolicyOutput::return_value): <p></p>
    /// - On failure, responds with [`SdkError<PutFirewallRuleGroupPolicyError>`](crate::error::PutFirewallRuleGroupPolicyError)
    pub fn put_firewall_rule_group_policy(&self) -> fluent_builders::PutFirewallRuleGroupPolicy {
        fluent_builders::PutFirewallRuleGroupPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutResolverQueryLogConfigPolicy`](crate::client::fluent_builders::PutResolverQueryLogConfigPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::PutResolverQueryLogConfigPolicy::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::PutResolverQueryLogConfigPolicy::set_arn): <p>The Amazon Resource Name (ARN) of the account that you want to share rules with.</p>
    ///   - [`resolver_query_log_config_policy(impl Into<String>)`](crate::client::fluent_builders::PutResolverQueryLogConfigPolicy::resolver_query_log_config_policy) / [`set_resolver_query_log_config_policy(Option<String>)`](crate::client::fluent_builders::PutResolverQueryLogConfigPolicy::set_resolver_query_log_config_policy): <p>An Identity and Access Management policy statement that lists the query logging configurations that you want to share with another Amazon Web Services account and the operations that you want the account to be able to perform. You can specify the following operations in the <code>Actions</code> section of the statement:</p>  <ul>   <li> <p> <code>route53resolver:AssociateResolverQueryLogConfig</code> </p> </li>   <li> <p> <code>route53resolver:DisassociateResolverQueryLogConfig</code> </p> </li>   <li> <p> <code>route53resolver:ListResolverQueryLogConfigAssociations</code> </p> </li>   <li> <p> <code>route53resolver:ListResolverQueryLogConfigs</code> </p> </li>  </ul>  <p>In the <code>Resource</code> section of the statement, you specify the ARNs for the query logging configurations that you want to share with the account that you specified in <code>Arn</code>. </p>
    /// - On success, responds with [`PutResolverQueryLogConfigPolicyOutput`](crate::output::PutResolverQueryLogConfigPolicyOutput) with field(s):
    ///   - [`return_value(bool)`](crate::output::PutResolverQueryLogConfigPolicyOutput::return_value): <p>Whether the <code>PutResolverQueryLogConfigPolicy</code> request was successful.</p>
    /// - On failure, responds with [`SdkError<PutResolverQueryLogConfigPolicyError>`](crate::error::PutResolverQueryLogConfigPolicyError)
    pub fn put_resolver_query_log_config_policy(
        &self,
    ) -> fluent_builders::PutResolverQueryLogConfigPolicy {
        fluent_builders::PutResolverQueryLogConfigPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutResolverRulePolicy`](crate::client::fluent_builders::PutResolverRulePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::PutResolverRulePolicy::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::PutResolverRulePolicy::set_arn): <p>The Amazon Resource Name (ARN) of the rule that you want to share with another account.</p>
    ///   - [`resolver_rule_policy(impl Into<String>)`](crate::client::fluent_builders::PutResolverRulePolicy::resolver_rule_policy) / [`set_resolver_rule_policy(Option<String>)`](crate::client::fluent_builders::PutResolverRulePolicy::set_resolver_rule_policy): <p>An Identity and Access Management policy statement that lists the rules that you want to share with another Amazon Web Services account and the operations that you want the account to be able to perform. You can specify the following operations in the <code>Action</code> section of the statement:</p>  <ul>   <li> <p> <code>route53resolver:GetResolverRule</code> </p> </li>   <li> <p> <code>route53resolver:AssociateResolverRule</code> </p> </li>   <li> <p> <code>route53resolver:DisassociateResolverRule</code> </p> </li>   <li> <p> <code>route53resolver:ListResolverRules</code> </p> </li>   <li> <p> <code>route53resolver:ListResolverRuleAssociations</code> </p> </li>  </ul>  <p>In the <code>Resource</code> section of the statement, specify the ARN for the rule that you want to share with another account. Specify the same ARN that you specified in <code>Arn</code>.</p>
    /// - On success, responds with [`PutResolverRulePolicyOutput`](crate::output::PutResolverRulePolicyOutput) with field(s):
    ///   - [`return_value(bool)`](crate::output::PutResolverRulePolicyOutput::return_value): <p>Whether the <code>PutResolverRulePolicy</code> request was successful.</p>
    /// - On failure, responds with [`SdkError<PutResolverRulePolicyError>`](crate::error::PutResolverRulePolicyError)
    pub fn put_resolver_rule_policy(&self) -> fluent_builders::PutResolverRulePolicy {
        fluent_builders::PutResolverRulePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) for the resource that you want to add tags to. To get the ARN for a resource, use the applicable <code>Get</code> or <code>List</code> command: </p>  <ul>   <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html">GetResolverEndpoint</a> </p> </li>   <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRule.html">GetResolverRule</a> </p> </li>   <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRuleAssociation.html">GetResolverRuleAssociation</a> </p> </li>   <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html">ListResolverEndpoints</a> </p> </li>   <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html">ListResolverRuleAssociations</a> </p> </li>   <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html">ListResolverRules</a> </p> </li>  </ul>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The tags that you want to add to the specified resource.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) for the resource that you want to remove tags from. To get the ARN for a resource, use the applicable <code>Get</code> or <code>List</code> command: </p>  <ul>   <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html">GetResolverEndpoint</a> </p> </li>   <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRule.html">GetResolverRule</a> </p> </li>   <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRuleAssociation.html">GetResolverRuleAssociation</a> </p> </li>   <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html">ListResolverEndpoints</a> </p> </li>   <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html">ListResolverRuleAssociations</a> </p> </li>   <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html">ListResolverRules</a> </p> </li>  </ul>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The tags that you want to remove to the specified resource.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateFirewallConfig`](crate::client::fluent_builders::UpdateFirewallConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::UpdateFirewallConfig::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::UpdateFirewallConfig::set_resource_id): <p>The ID of the VPC that the configuration is for.</p>
    ///   - [`firewall_fail_open(FirewallFailOpenStatus)`](crate::client::fluent_builders::UpdateFirewallConfig::firewall_fail_open) / [`set_firewall_fail_open(Option<FirewallFailOpenStatus>)`](crate::client::fluent_builders::UpdateFirewallConfig::set_firewall_fail_open): <p>Determines how Route 53 Resolver handles queries during failures, for example when all traffic that is sent to DNS Firewall fails to receive a reply. </p>  <ul>   <li> <p>By default, fail open is disabled, which means the failure mode is closed. This approach favors security over availability. DNS Firewall blocks queries that it is unable to evaluate properly. </p> </li>   <li> <p>If you enable this option, the failure mode is open. This approach favors availability over security. DNS Firewall allows queries to proceed if it is unable to properly evaluate them. </p> </li>  </ul>  <p>This behavior is only enforced for VPCs that have at least one DNS Firewall rule group association. </p>
    /// - On success, responds with [`UpdateFirewallConfigOutput`](crate::output::UpdateFirewallConfigOutput) with field(s):
    ///   - [`firewall_config(Option<FirewallConfig>)`](crate::output::UpdateFirewallConfigOutput::firewall_config): <p>Configuration of the firewall behavior provided by DNS Firewall for a single VPC. </p>
    /// - On failure, responds with [`SdkError<UpdateFirewallConfigError>`](crate::error::UpdateFirewallConfigError)
    pub fn update_firewall_config(&self) -> fluent_builders::UpdateFirewallConfig {
        fluent_builders::UpdateFirewallConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateFirewallDomains`](crate::client::fluent_builders::UpdateFirewallDomains) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`firewall_domain_list_id(impl Into<String>)`](crate::client::fluent_builders::UpdateFirewallDomains::firewall_domain_list_id) / [`set_firewall_domain_list_id(Option<String>)`](crate::client::fluent_builders::UpdateFirewallDomains::set_firewall_domain_list_id): <p>The ID of the domain list whose domains you want to update. </p>
    ///   - [`operation(FirewallDomainUpdateOperation)`](crate::client::fluent_builders::UpdateFirewallDomains::operation) / [`set_operation(Option<FirewallDomainUpdateOperation>)`](crate::client::fluent_builders::UpdateFirewallDomains::set_operation): <p>What you want DNS Firewall to do with the domains that you are providing: </p>  <ul>   <li> <p> <code>ADD</code> - Add the domains to the ones that are already in the domain list. </p> </li>   <li> <p> <code>REMOVE</code> - Search the domain list for the domains and remove them from the list.</p> </li>   <li> <p> <code>REPLACE</code> - Update the domain list to exactly match the list that you are providing. </p> </li>  </ul>
    ///   - [`domains(Vec<String>)`](crate::client::fluent_builders::UpdateFirewallDomains::domains) / [`set_domains(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateFirewallDomains::set_domains): <p>A list of domains to use in the update operation.</p>  <p>Each domain specification in your domain list must satisfy the following requirements: </p>  <ul>   <li> <p>It can optionally start with <code>*</code> (asterisk).</p> </li>   <li> <p>With the exception of the optional starting asterisk, it must only contain the following characters: <code>A-Z</code>, <code>a-z</code>, <code>0-9</code>, <code>-</code> (hyphen).</p> </li>   <li> <p>It must be from 1-255 characters in length. </p> </li>  </ul>
    /// - On success, responds with [`UpdateFirewallDomainsOutput`](crate::output::UpdateFirewallDomainsOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::UpdateFirewallDomainsOutput::id): <p>The ID of the firewall domain list that DNS Firewall just updated.</p>
    ///   - [`name(Option<String>)`](crate::output::UpdateFirewallDomainsOutput::name): <p>The name of the domain list. </p>
    ///   - [`status(Option<FirewallDomainListStatus>)`](crate::output::UpdateFirewallDomainsOutput::status): <p> </p>
    ///   - [`status_message(Option<String>)`](crate::output::UpdateFirewallDomainsOutput::status_message): <p>Additional information about the status of the list, if available.</p>
    /// - On failure, responds with [`SdkError<UpdateFirewallDomainsError>`](crate::error::UpdateFirewallDomainsError)
    pub fn update_firewall_domains(&self) -> fluent_builders::UpdateFirewallDomains {
        fluent_builders::UpdateFirewallDomains::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateFirewallRule`](crate::client::fluent_builders::UpdateFirewallRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`firewall_rule_group_id(impl Into<String>)`](crate::client::fluent_builders::UpdateFirewallRule::firewall_rule_group_id) / [`set_firewall_rule_group_id(Option<String>)`](crate::client::fluent_builders::UpdateFirewallRule::set_firewall_rule_group_id): <p>The unique identifier of the firewall rule group for the rule. </p>
    ///   - [`firewall_domain_list_id(impl Into<String>)`](crate::client::fluent_builders::UpdateFirewallRule::firewall_domain_list_id) / [`set_firewall_domain_list_id(Option<String>)`](crate::client::fluent_builders::UpdateFirewallRule::set_firewall_domain_list_id): <p>The ID of the domain list to use in the rule. </p>
    ///   - [`priority(i32)`](crate::client::fluent_builders::UpdateFirewallRule::priority) / [`set_priority(Option<i32>)`](crate::client::fluent_builders::UpdateFirewallRule::set_priority): <p>The setting that determines the processing order of the rule in the rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.</p>  <p>You must specify a unique priority for each rule in a rule group. To make it easier to insert rules later, leave space between the numbers, for example, use 100, 200, and so on. You can change the priority setting for the rules in a rule group at any time.</p>
    ///   - [`action(Action)`](crate::client::fluent_builders::UpdateFirewallRule::action) / [`set_action(Option<Action>)`](crate::client::fluent_builders::UpdateFirewallRule::set_action): <p>The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list:</p>  <ul>   <li> <p> <code>ALLOW</code> - Permit the request to go through.</p> </li>   <li> <p> <code>ALERT</code> - Permit the request to go through but send an alert to the logs.</p> </li>   <li> <p> <code>BLOCK</code> - Disallow the request. This option requires additional details in the rule's <code>BlockResponse</code>. </p> </li>  </ul>
    ///   - [`block_response(BlockResponse)`](crate::client::fluent_builders::UpdateFirewallRule::block_response) / [`set_block_response(Option<BlockResponse>)`](crate::client::fluent_builders::UpdateFirewallRule::set_block_response): <p>The way that you want DNS Firewall to block the request. Used for the rule action setting <code>BLOCK</code>.</p>  <ul>   <li> <p> <code>NODATA</code> - Respond indicating that the query was successful, but no response is available for it.</p> </li>   <li> <p> <code>NXDOMAIN</code> - Respond indicating that the domain name that's in the query doesn't exist.</p> </li>   <li> <p> <code>OVERRIDE</code> - Provide a custom override in the response. This option requires custom handling details in the rule's <code>BlockOverride*</code> settings. </p> </li>  </ul>
    ///   - [`block_override_domain(impl Into<String>)`](crate::client::fluent_builders::UpdateFirewallRule::block_override_domain) / [`set_block_override_domain(Option<String>)`](crate::client::fluent_builders::UpdateFirewallRule::set_block_override_domain): <p>The custom DNS record to send back in response to the query. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
    ///   - [`block_override_dns_type(BlockOverrideDnsType)`](crate::client::fluent_builders::UpdateFirewallRule::block_override_dns_type) / [`set_block_override_dns_type(Option<BlockOverrideDnsType>)`](crate::client::fluent_builders::UpdateFirewallRule::set_block_override_dns_type): <p>The DNS record's type. This determines the format of the record value that you provided in <code>BlockOverrideDomain</code>. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
    ///   - [`block_override_ttl(i32)`](crate::client::fluent_builders::UpdateFirewallRule::block_override_ttl) / [`set_block_override_ttl(Option<i32>)`](crate::client::fluent_builders::UpdateFirewallRule::set_block_override_ttl): <p>The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateFirewallRule::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateFirewallRule::set_name): <p>The name of the rule.</p>
    /// - On success, responds with [`UpdateFirewallRuleOutput`](crate::output::UpdateFirewallRuleOutput) with field(s):
    ///   - [`firewall_rule(Option<FirewallRule>)`](crate::output::UpdateFirewallRuleOutput::firewall_rule): <p>The firewall rule that you just updated. </p>
    /// - On failure, responds with [`SdkError<UpdateFirewallRuleError>`](crate::error::UpdateFirewallRuleError)
    pub fn update_firewall_rule(&self) -> fluent_builders::UpdateFirewallRule {
        fluent_builders::UpdateFirewallRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateFirewallRuleGroupAssociation`](crate::client::fluent_builders::UpdateFirewallRuleGroupAssociation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`firewall_rule_group_association_id(impl Into<String>)`](crate::client::fluent_builders::UpdateFirewallRuleGroupAssociation::firewall_rule_group_association_id) / [`set_firewall_rule_group_association_id(Option<String>)`](crate::client::fluent_builders::UpdateFirewallRuleGroupAssociation::set_firewall_rule_group_association_id): <p>The identifier of the <code>FirewallRuleGroupAssociation</code>. </p>
    ///   - [`priority(i32)`](crate::client::fluent_builders::UpdateFirewallRuleGroupAssociation::priority) / [`set_priority(Option<i32>)`](crate::client::fluent_builders::UpdateFirewallRuleGroupAssociation::set_priority): <p>The setting that determines the processing order of the rule group among the rule groups that you associate with the specified VPC. DNS Firewall filters VPC traffic starting from the rule group with the lowest numeric priority setting. </p>  <p>You must specify a unique priority for each rule group that you associate with a single VPC. To make it easier to insert rule groups later, leave space between the numbers, for example, use 100, 200, and so on. You can change the priority setting for a rule group association after you create it.</p>
    ///   - [`mutation_protection(MutationProtectionStatus)`](crate::client::fluent_builders::UpdateFirewallRuleGroupAssociation::mutation_protection) / [`set_mutation_protection(Option<MutationProtectionStatus>)`](crate::client::fluent_builders::UpdateFirewallRuleGroupAssociation::set_mutation_protection): <p>If enabled, this setting disallows modification or removal of the association, to help prevent against accidentally altering DNS firewall protections. </p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateFirewallRuleGroupAssociation::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateFirewallRuleGroupAssociation::set_name): <p>The name of the rule group association.</p>
    /// - On success, responds with [`UpdateFirewallRuleGroupAssociationOutput`](crate::output::UpdateFirewallRuleGroupAssociationOutput) with field(s):
    ///   - [`firewall_rule_group_association(Option<FirewallRuleGroupAssociation>)`](crate::output::UpdateFirewallRuleGroupAssociationOutput::firewall_rule_group_association): <p>The association that you just updated. </p>
    /// - On failure, responds with [`SdkError<UpdateFirewallRuleGroupAssociationError>`](crate::error::UpdateFirewallRuleGroupAssociationError)
    pub fn update_firewall_rule_group_association(
        &self,
    ) -> fluent_builders::UpdateFirewallRuleGroupAssociation {
        fluent_builders::UpdateFirewallRuleGroupAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateResolverConfig`](crate::client::fluent_builders::UpdateResolverConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::UpdateResolverConfig::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::UpdateResolverConfig::set_resource_id): <p>Resource ID of the Amazon VPC that you want to update the Resolver configuration for.</p>
    ///   - [`autodefined_reverse_flag(AutodefinedReverseFlag)`](crate::client::fluent_builders::UpdateResolverConfig::autodefined_reverse_flag) / [`set_autodefined_reverse_flag(Option<AutodefinedReverseFlag>)`](crate::client::fluent_builders::UpdateResolverConfig::set_autodefined_reverse_flag): <p>Indicates whether or not the Resolver will create autodefined rules for reverse DNS lookups. This is enabled by default. Disabling this option will also affect EC2-Classic instances using ClassicLink. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the <i>Amazon EC2 guide</i>.</p> <note>   <p>It can take some time for the status change to be completed.</p>  </note>  <p></p>
    /// - On success, responds with [`UpdateResolverConfigOutput`](crate::output::UpdateResolverConfigOutput) with field(s):
    ///   - [`resolver_config(Option<ResolverConfig>)`](crate::output::UpdateResolverConfigOutput::resolver_config): <p>An array that contains settings for the specified Resolver configuration.</p>
    /// - On failure, responds with [`SdkError<UpdateResolverConfigError>`](crate::error::UpdateResolverConfigError)
    pub fn update_resolver_config(&self) -> fluent_builders::UpdateResolverConfig {
        fluent_builders::UpdateResolverConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateResolverDnssecConfig`](crate::client::fluent_builders::UpdateResolverDnssecConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::UpdateResolverDnssecConfig::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::UpdateResolverDnssecConfig::set_resource_id): <p>The ID of the virtual private cloud (VPC) that you're updating the DNSSEC validation status for.</p>
    ///   - [`validation(Validation)`](crate::client::fluent_builders::UpdateResolverDnssecConfig::validation) / [`set_validation(Option<Validation>)`](crate::client::fluent_builders::UpdateResolverDnssecConfig::set_validation): <p>The new value that you are specifying for DNSSEC validation for the VPC. The value can be <code>ENABLE</code> or <code>DISABLE</code>. Be aware that it can take time for a validation status change to be completed.</p>
    /// - On success, responds with [`UpdateResolverDnssecConfigOutput`](crate::output::UpdateResolverDnssecConfigOutput) with field(s):
    ///   - [`resolver_dnssec_config(Option<ResolverDnssecConfig>)`](crate::output::UpdateResolverDnssecConfigOutput::resolver_dnssec_config): <p>A complex type that contains settings for the specified DNSSEC configuration.</p>
    /// - On failure, responds with [`SdkError<UpdateResolverDnssecConfigError>`](crate::error::UpdateResolverDnssecConfigError)
    pub fn update_resolver_dnssec_config(&self) -> fluent_builders::UpdateResolverDnssecConfig {
        fluent_builders::UpdateResolverDnssecConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateResolverEndpoint`](crate::client::fluent_builders::UpdateResolverEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resolver_endpoint_id(impl Into<String>)`](crate::client::fluent_builders::UpdateResolverEndpoint::resolver_endpoint_id) / [`set_resolver_endpoint_id(Option<String>)`](crate::client::fluent_builders::UpdateResolverEndpoint::set_resolver_endpoint_id): <p>The ID of the Resolver endpoint that you want to update.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateResolverEndpoint::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateResolverEndpoint::set_name): <p>The name of the Resolver endpoint that you want to update.</p>
    /// - On success, responds with [`UpdateResolverEndpointOutput`](crate::output::UpdateResolverEndpointOutput) with field(s):
    ///   - [`resolver_endpoint(Option<ResolverEndpoint>)`](crate::output::UpdateResolverEndpointOutput::resolver_endpoint): <p>The response to an <code>UpdateResolverEndpoint</code> request.</p>
    /// - On failure, responds with [`SdkError<UpdateResolverEndpointError>`](crate::error::UpdateResolverEndpointError)
    pub fn update_resolver_endpoint(&self) -> fluent_builders::UpdateResolverEndpoint {
        fluent_builders::UpdateResolverEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateResolverRule`](crate::client::fluent_builders::UpdateResolverRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resolver_rule_id(impl Into<String>)`](crate::client::fluent_builders::UpdateResolverRule::resolver_rule_id) / [`set_resolver_rule_id(Option<String>)`](crate::client::fluent_builders::UpdateResolverRule::set_resolver_rule_id): <p>The ID of the Resolver rule that you want to update.</p>
    ///   - [`config(ResolverRuleConfig)`](crate::client::fluent_builders::UpdateResolverRule::config) / [`set_config(Option<ResolverRuleConfig>)`](crate::client::fluent_builders::UpdateResolverRule::set_config): <p>The new settings for the Resolver rule.</p>
    /// - On success, responds with [`UpdateResolverRuleOutput`](crate::output::UpdateResolverRuleOutput) with field(s):
    ///   - [`resolver_rule(Option<ResolverRule>)`](crate::output::UpdateResolverRuleOutput::resolver_rule): <p>The response to an <code>UpdateResolverRule</code> request.</p>
    /// - On failure, responds with [`SdkError<UpdateResolverRuleError>`](crate::error::UpdateResolverRuleError)
    pub fn update_resolver_rule(&self) -> fluent_builders::UpdateResolverRule {
        fluent_builders::UpdateResolverRule::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateFirewallRuleGroup`.
    ///
    /// <p>Associates a <code>FirewallRuleGroup</code> with a VPC, to provide DNS filtering for the VPC. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateFirewallRuleGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_firewall_rule_group_input::Builder,
    }
    impl AssociateFirewallRuleGroup {
        /// Creates a new `AssociateFirewallRuleGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateFirewallRuleGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateFirewallRuleGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique string that identifies the request and that allows failed requests to be retried without the risk of running the operation twice. <code>CreatorRequestId</code> can be any unique string, for example, a date/time stamp. </p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.creator_request_id(input.into());
            self
        }
        /// <p>A unique string that identifies the request and that allows failed requests to be retried without the risk of running the operation twice. <code>CreatorRequestId</code> can be any unique string, for example, a date/time stamp. </p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_creator_request_id(input);
            self
        }
        /// <p>The unique identifier of the firewall rule group. </p>
        pub fn firewall_rule_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_rule_group_id(input.into());
            self
        }
        /// <p>The unique identifier of the firewall rule group. </p>
        pub fn set_firewall_rule_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_rule_group_id(input);
            self
        }
        /// <p>The unique identifier of the VPC that you want to associate with the rule group. </p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_id(input.into());
            self
        }
        /// <p>The unique identifier of the VPC that you want to associate with the rule group. </p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_id(input);
            self
        }
        /// <p>The setting that determines the processing order of the rule group among the rule groups that you associate with the specified VPC. DNS Firewall filters VPC traffic starting from the rule group with the lowest numeric priority setting. </p>
        /// <p>You must specify a unique priority for each rule group that you associate with a single VPC. To make it easier to insert rule groups later, leave space between the numbers, for example, use 101, 200, and so on. You can change the priority setting for a rule group association after you create it.</p>
        /// <p>The allowed values for <code>Priority</code> are between 100 and 9900.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.inner = self.inner.priority(input);
            self
        }
        /// <p>The setting that determines the processing order of the rule group among the rule groups that you associate with the specified VPC. DNS Firewall filters VPC traffic starting from the rule group with the lowest numeric priority setting. </p>
        /// <p>You must specify a unique priority for each rule group that you associate with a single VPC. To make it easier to insert rule groups later, leave space between the numbers, for example, use 101, 200, and so on. You can change the priority setting for a rule group association after you create it.</p>
        /// <p>The allowed values for <code>Priority</code> are between 100 and 9900.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_priority(input);
            self
        }
        /// <p>A name that lets you identify the association, to manage and use it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A name that lets you identify the association, to manage and use it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>If enabled, this setting disallows modification or removal of the association, to help prevent against accidentally altering DNS firewall protections. When you create the association, the default setting is <code>DISABLED</code>. </p>
        pub fn mutation_protection(
            mut self,
            input: crate::model::MutationProtectionStatus,
        ) -> Self {
            self.inner = self.inner.mutation_protection(input);
            self
        }
        /// <p>If enabled, this setting disallows modification or removal of the association, to help prevent against accidentally altering DNS firewall protections. When you create the association, the default setting is <code>DISABLED</code>. </p>
        pub fn set_mutation_protection(
            mut self,
            input: std::option::Option<crate::model::MutationProtectionStatus>,
        ) -> Self {
            self.inner = self.inner.set_mutation_protection(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of the tag keys and values that you want to associate with the rule group association. </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of the tag keys and values that you want to associate with the rule group association. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateResolverEndpointIpAddress`.
    ///
    /// <p>Adds IP addresses to an inbound or an outbound Resolver endpoint. If you want to add more than one IP address, submit one <code>AssociateResolverEndpointIpAddress</code> request for each IP address.</p>
    /// <p>To remove an IP address from an endpoint, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverEndpointIpAddress.html">DisassociateResolverEndpointIpAddress</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateResolverEndpointIpAddress {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_resolver_endpoint_ip_address_input::Builder,
    }
    impl AssociateResolverEndpointIpAddress {
        /// Creates a new `AssociateResolverEndpointIpAddress`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateResolverEndpointIpAddressOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AssociateResolverEndpointIpAddressError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Resolver endpoint that you want to associate IP addresses with.</p>
        pub fn resolver_endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolver_endpoint_id(input.into());
            self
        }
        /// <p>The ID of the Resolver endpoint that you want to associate IP addresses with.</p>
        pub fn set_resolver_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolver_endpoint_id(input);
            self
        }
        /// <p>Either the IPv4 address that you want to add to a Resolver endpoint or a subnet ID. If you specify a subnet ID, Resolver chooses an IP address for you from the available IPs in the specified subnet.</p>
        pub fn ip_address(mut self, input: crate::model::IpAddressUpdate) -> Self {
            self.inner = self.inner.ip_address(input);
            self
        }
        /// <p>Either the IPv4 address that you want to add to a Resolver endpoint or a subnet ID. If you specify a subnet ID, Resolver chooses an IP address for you from the available IPs in the specified subnet.</p>
        pub fn set_ip_address(
            mut self,
            input: std::option::Option<crate::model::IpAddressUpdate>,
        ) -> Self {
            self.inner = self.inner.set_ip_address(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateResolverQueryLogConfig`.
    ///
    /// <p>Associates an Amazon VPC with a specified query logging configuration. Route 53 Resolver logs DNS queries that originate in all of the Amazon VPCs that are associated with a specified query logging configuration. To associate more than one VPC with a configuration, submit one <code>AssociateResolverQueryLogConfig</code> request for each VPC.</p> <note>
    /// <p>The VPCs that you associate with a query logging configuration must be in the same Region as the configuration.</p>
    /// </note>
    /// <p>To remove a VPC from a query logging configuration, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverQueryLogConfig.html">DisassociateResolverQueryLogConfig</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateResolverQueryLogConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_resolver_query_log_config_input::Builder,
    }
    impl AssociateResolverQueryLogConfig {
        /// Creates a new `AssociateResolverQueryLogConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateResolverQueryLogConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateResolverQueryLogConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the query logging configuration that you want to associate a VPC with.</p>
        pub fn resolver_query_log_config_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.resolver_query_log_config_id(input.into());
            self
        }
        /// <p>The ID of the query logging configuration that you want to associate a VPC with.</p>
        pub fn set_resolver_query_log_config_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolver_query_log_config_id(input);
            self
        }
        /// <p>The ID of an Amazon VPC that you want this query logging configuration to log queries for.</p> <note>
        /// <p>The VPCs and the query logging configuration must be in the same Region.</p>
        /// </note>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The ID of an Amazon VPC that you want this query logging configuration to log queries for.</p> <note>
        /// <p>The VPCs and the query logging configuration must be in the same Region.</p>
        /// </note>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateResolverRule`.
    ///
    /// <p>Associates a Resolver rule with a VPC. When you associate a rule with a VPC, Resolver forwards all DNS queries for the domain name that is specified in the rule and that originate in the VPC. The queries are forwarded to the IP addresses for the DNS resolvers that are specified in the rule. For more information about rules, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverRule.html">CreateResolverRule</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateResolverRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_resolver_rule_input::Builder,
    }
    impl AssociateResolverRule {
        /// Creates a new `AssociateResolverRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateResolverRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateResolverRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Resolver rule that you want to associate with the VPC. To list the existing Resolver rules, use <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html">ListResolverRules</a>.</p>
        pub fn resolver_rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolver_rule_id(input.into());
            self
        }
        /// <p>The ID of the Resolver rule that you want to associate with the VPC. To list the existing Resolver rules, use <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html">ListResolverRules</a>.</p>
        pub fn set_resolver_rule_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolver_rule_id(input);
            self
        }
        /// <p>A name for the association that you're creating between a Resolver rule and a VPC.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A name for the association that you're creating between a Resolver rule and a VPC.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The ID of the VPC that you want to associate the Resolver rule with.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_id(input.into());
            self
        }
        /// <p>The ID of the VPC that you want to associate the Resolver rule with.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFirewallDomainList`.
    ///
    /// <p>Creates an empty firewall domain list for use in DNS Firewall rules. You can populate the domains for the new list with a file, using <code>ImportFirewallDomains</code>, or with domain strings, using <code>UpdateFirewallDomains</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFirewallDomainList {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_firewall_domain_list_input::Builder,
    }
    impl CreateFirewallDomainList {
        /// Creates a new `CreateFirewallDomainList`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFirewallDomainListOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFirewallDomainListError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique string that identifies the request and that allows you to retry failed requests without the risk of running the operation twice. <code>CreatorRequestId</code> can be any unique string, for example, a date/time stamp. </p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.creator_request_id(input.into());
            self
        }
        /// <p>A unique string that identifies the request and that allows you to retry failed requests without the risk of running the operation twice. <code>CreatorRequestId</code> can be any unique string, for example, a date/time stamp. </p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_creator_request_id(input);
            self
        }
        /// <p>A name that lets you identify the domain list to manage and use it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A name that lets you identify the domain list to manage and use it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of the tag keys and values that you want to associate with the domain list. </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of the tag keys and values that you want to associate with the domain list. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFirewallRule`.
    ///
    /// <p>Creates a single DNS Firewall rule in the specified rule group, using the specified domain list.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFirewallRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_firewall_rule_input::Builder,
    }
    impl CreateFirewallRule {
        /// Creates a new `CreateFirewallRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFirewallRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFirewallRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique string that identifies the request and that allows you to retry failed requests without the risk of running the operation twice. <code>CreatorRequestId</code> can be any unique string, for example, a date/time stamp. </p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.creator_request_id(input.into());
            self
        }
        /// <p>A unique string that identifies the request and that allows you to retry failed requests without the risk of running the operation twice. <code>CreatorRequestId</code> can be any unique string, for example, a date/time stamp. </p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_creator_request_id(input);
            self
        }
        /// <p>The unique identifier of the firewall rule group where you want to create the rule. </p>
        pub fn firewall_rule_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_rule_group_id(input.into());
            self
        }
        /// <p>The unique identifier of the firewall rule group where you want to create the rule. </p>
        pub fn set_firewall_rule_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_rule_group_id(input);
            self
        }
        /// <p>The ID of the domain list that you want to use in the rule. </p>
        pub fn firewall_domain_list_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_domain_list_id(input.into());
            self
        }
        /// <p>The ID of the domain list that you want to use in the rule. </p>
        pub fn set_firewall_domain_list_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_domain_list_id(input);
            self
        }
        /// <p>The setting that determines the processing order of the rule in the rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.</p>
        /// <p>You must specify a unique priority for each rule in a rule group. To make it easier to insert rules later, leave space between the numbers, for example, use 100, 200, and so on. You can change the priority setting for the rules in a rule group at any time.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.inner = self.inner.priority(input);
            self
        }
        /// <p>The setting that determines the processing order of the rule in the rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.</p>
        /// <p>You must specify a unique priority for each rule in a rule group. To make it easier to insert rules later, leave space between the numbers, for example, use 100, 200, and so on. You can change the priority setting for the rules in a rule group at any time.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_priority(input);
            self
        }
        /// <p>The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list:</p>
        /// <ul>
        /// <li> <p> <code>ALLOW</code> - Permit the request to go through.</p> </li>
        /// <li> <p> <code>ALERT</code> - Permit the request and send metrics and logs to Cloud Watch.</p> </li>
        /// <li> <p> <code>BLOCK</code> - Disallow the request. This option requires additional details in the rule's <code>BlockResponse</code>. </p> </li>
        /// </ul>
        pub fn action(mut self, input: crate::model::Action) -> Self {
            self.inner = self.inner.action(input);
            self
        }
        /// <p>The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list:</p>
        /// <ul>
        /// <li> <p> <code>ALLOW</code> - Permit the request to go through.</p> </li>
        /// <li> <p> <code>ALERT</code> - Permit the request and send metrics and logs to Cloud Watch.</p> </li>
        /// <li> <p> <code>BLOCK</code> - Disallow the request. This option requires additional details in the rule's <code>BlockResponse</code>. </p> </li>
        /// </ul>
        pub fn set_action(mut self, input: std::option::Option<crate::model::Action>) -> Self {
            self.inner = self.inner.set_action(input);
            self
        }
        /// <p>The way that you want DNS Firewall to block the request, used with the rule action setting <code>BLOCK</code>. </p>
        /// <ul>
        /// <li> <p> <code>NODATA</code> - Respond indicating that the query was successful, but no response is available for it.</p> </li>
        /// <li> <p> <code>NXDOMAIN</code> - Respond indicating that the domain name that's in the query doesn't exist.</p> </li>
        /// <li> <p> <code>OVERRIDE</code> - Provide a custom override in the response. This option requires custom handling details in the rule's <code>BlockOverride*</code> settings. </p> </li>
        /// </ul>
        /// <p>This setting is required if the rule action setting is <code>BLOCK</code>.</p>
        pub fn block_response(mut self, input: crate::model::BlockResponse) -> Self {
            self.inner = self.inner.block_response(input);
            self
        }
        /// <p>The way that you want DNS Firewall to block the request, used with the rule action setting <code>BLOCK</code>. </p>
        /// <ul>
        /// <li> <p> <code>NODATA</code> - Respond indicating that the query was successful, but no response is available for it.</p> </li>
        /// <li> <p> <code>NXDOMAIN</code> - Respond indicating that the domain name that's in the query doesn't exist.</p> </li>
        /// <li> <p> <code>OVERRIDE</code> - Provide a custom override in the response. This option requires custom handling details in the rule's <code>BlockOverride*</code> settings. </p> </li>
        /// </ul>
        /// <p>This setting is required if the rule action setting is <code>BLOCK</code>.</p>
        pub fn set_block_response(
            mut self,
            input: std::option::Option<crate::model::BlockResponse>,
        ) -> Self {
            self.inner = self.inner.set_block_response(input);
            self
        }
        /// <p>The custom DNS record to send back in response to the query. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
        /// <p>This setting is required if the <code>BlockResponse</code> setting is <code>OVERRIDE</code>.</p>
        pub fn block_override_domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.block_override_domain(input.into());
            self
        }
        /// <p>The custom DNS record to send back in response to the query. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
        /// <p>This setting is required if the <code>BlockResponse</code> setting is <code>OVERRIDE</code>.</p>
        pub fn set_block_override_domain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_block_override_domain(input);
            self
        }
        /// <p>The DNS record's type. This determines the format of the record value that you provided in <code>BlockOverrideDomain</code>. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
        /// <p>This setting is required if the <code>BlockResponse</code> setting is <code>OVERRIDE</code>.</p>
        pub fn block_override_dns_type(
            mut self,
            input: crate::model::BlockOverrideDnsType,
        ) -> Self {
            self.inner = self.inner.block_override_dns_type(input);
            self
        }
        /// <p>The DNS record's type. This determines the format of the record value that you provided in <code>BlockOverrideDomain</code>. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
        /// <p>This setting is required if the <code>BlockResponse</code> setting is <code>OVERRIDE</code>.</p>
        pub fn set_block_override_dns_type(
            mut self,
            input: std::option::Option<crate::model::BlockOverrideDnsType>,
        ) -> Self {
            self.inner = self.inner.set_block_override_dns_type(input);
            self
        }
        /// <p>The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
        /// <p>This setting is required if the <code>BlockResponse</code> setting is <code>OVERRIDE</code>.</p>
        pub fn block_override_ttl(mut self, input: i32) -> Self {
            self.inner = self.inner.block_override_ttl(input);
            self
        }
        /// <p>The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
        /// <p>This setting is required if the <code>BlockResponse</code> setting is <code>OVERRIDE</code>.</p>
        pub fn set_block_override_ttl(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_block_override_ttl(input);
            self
        }
        /// <p>A name that lets you identify the rule in the rule group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A name that lets you identify the rule in the rule group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFirewallRuleGroup`.
    ///
    /// <p>Creates an empty DNS Firewall rule group for filtering DNS network traffic in a VPC. You can add rules to the new rule group by calling <code>CreateFirewallRule</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFirewallRuleGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_firewall_rule_group_input::Builder,
    }
    impl CreateFirewallRuleGroup {
        /// Creates a new `CreateFirewallRuleGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFirewallRuleGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFirewallRuleGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique string defined by you to identify the request. This allows you to retry failed requests without the risk of running the operation twice. This can be any unique string, for example, a timestamp. </p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.creator_request_id(input.into());
            self
        }
        /// <p>A unique string defined by you to identify the request. This allows you to retry failed requests without the risk of running the operation twice. This can be any unique string, for example, a timestamp. </p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_creator_request_id(input);
            self
        }
        /// <p>A name that lets you identify the rule group, to manage and use it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A name that lets you identify the rule group, to manage and use it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of the tag keys and values that you want to associate with the rule group. </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of the tag keys and values that you want to associate with the rule group. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateResolverEndpoint`.
    ///
    /// <p>Creates a Resolver endpoint. There are two types of Resolver endpoints, inbound and outbound:</p>
    /// <ul>
    /// <li> <p>An <i>inbound Resolver endpoint</i> forwards DNS queries to the DNS service for a VPC from your network.</p> </li>
    /// <li> <p>An <i>outbound Resolver endpoint</i> forwards DNS queries from the DNS service for a VPC to your network.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateResolverEndpoint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_resolver_endpoint_input::Builder,
    }
    impl CreateResolverEndpoint {
        /// Creates a new `CreateResolverEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateResolverEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateResolverEndpointError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique string that identifies the request and that allows failed requests to be retried without the risk of running the operation twice. <code>CreatorRequestId</code> can be any unique string, for example, a date/time stamp. </p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.creator_request_id(input.into());
            self
        }
        /// <p>A unique string that identifies the request and that allows failed requests to be retried without the risk of running the operation twice. <code>CreatorRequestId</code> can be any unique string, for example, a date/time stamp. </p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_creator_request_id(input);
            self
        }
        /// <p>A friendly name that lets you easily find a configuration in the Resolver dashboard in the Route 53 console.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A friendly name that lets you easily find a configuration in the Resolver dashboard in the Route 53 console.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `SecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>The ID of one or more security groups that you want to use to control access to this VPC. The security group that you specify must include one or more inbound rules (for inbound Resolver endpoints) or outbound rules (for outbound Resolver endpoints). Inbound and outbound rules must allow TCP and UDP access. For inbound access, open port 53. For outbound access, open the port that you're using for DNS queries on your network.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_group_ids(input.into());
            self
        }
        /// <p>The ID of one or more security groups that you want to use to control access to this VPC. The security group that you specify must include one or more inbound rules (for inbound Resolver endpoints) or outbound rules (for outbound Resolver endpoints). Inbound and outbound rules must allow TCP and UDP access. For inbound access, open port 53. For outbound access, open the port that you're using for DNS queries on your network.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_group_ids(input);
            self
        }
        /// <p>Specify the applicable value:</p>
        /// <ul>
        /// <li> <p> <code>INBOUND</code>: Resolver forwards DNS queries to the DNS service for a VPC from your network</p> </li>
        /// <li> <p> <code>OUTBOUND</code>: Resolver forwards DNS queries from the DNS service for a VPC to your network</p> </li>
        /// </ul>
        pub fn direction(mut self, input: crate::model::ResolverEndpointDirection) -> Self {
            self.inner = self.inner.direction(input);
            self
        }
        /// <p>Specify the applicable value:</p>
        /// <ul>
        /// <li> <p> <code>INBOUND</code>: Resolver forwards DNS queries to the DNS service for a VPC from your network</p> </li>
        /// <li> <p> <code>OUTBOUND</code>: Resolver forwards DNS queries from the DNS service for a VPC to your network</p> </li>
        /// </ul>
        pub fn set_direction(
            mut self,
            input: std::option::Option<crate::model::ResolverEndpointDirection>,
        ) -> Self {
            self.inner = self.inner.set_direction(input);
            self
        }
        /// Appends an item to `IpAddresses`.
        ///
        /// To override the contents of this collection use [`set_ip_addresses`](Self::set_ip_addresses).
        ///
        /// <p>The subnets and IP addresses in your VPC that DNS queries originate from (for outbound endpoints) or that you forward DNS queries to (for inbound endpoints). The subnet ID uniquely identifies a VPC. </p>
        pub fn ip_addresses(mut self, input: crate::model::IpAddressRequest) -> Self {
            self.inner = self.inner.ip_addresses(input);
            self
        }
        /// <p>The subnets and IP addresses in your VPC that DNS queries originate from (for outbound endpoints) or that you forward DNS queries to (for inbound endpoints). The subnet ID uniquely identifies a VPC. </p>
        pub fn set_ip_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IpAddressRequest>>,
        ) -> Self {
            self.inner = self.inner.set_ip_addresses(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of the tag keys and values that you want to associate with the endpoint.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of the tag keys and values that you want to associate with the endpoint.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateResolverQueryLogConfig`.
    ///
    /// <p>Creates a Resolver query logging configuration, which defines where you want Resolver to save DNS query logs that originate in your VPCs. Resolver can log queries only for VPCs that are in the same Region as the query logging configuration.</p>
    /// <p>To specify which VPCs you want to log queries for, you use <code>AssociateResolverQueryLogConfig</code>. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverQueryLogConfig.html">AssociateResolverQueryLogConfig</a>. </p>
    /// <p>You can optionally use Resource Access Manager (RAM) to share a query logging configuration with other Amazon Web Services accounts. The other accounts can then associate VPCs with the configuration. The query logs that Resolver creates for a configuration include all DNS queries that originate in all VPCs that are associated with the configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateResolverQueryLogConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_resolver_query_log_config_input::Builder,
    }
    impl CreateResolverQueryLogConfig {
        /// Creates a new `CreateResolverQueryLogConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateResolverQueryLogConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateResolverQueryLogConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name that you want to give the query logging configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name that you want to give the query logging configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The ARN of the resource that you want Resolver to send query logs. You can send query logs to an S3 bucket, a CloudWatch Logs log group, or a Kinesis Data Firehose delivery stream. Examples of valid values include the following:</p>
        /// <ul>
        /// <li> <p> <b>S3 bucket</b>: </p> <p> <code>arn:aws:s3:::examplebucket</code> </p> <p>You can optionally append a file prefix to the end of the ARN.</p> <p> <code>arn:aws:s3:::examplebucket/development/</code> </p> </li>
        /// <li> <p> <b>CloudWatch Logs log group</b>: </p> <p> <code>arn:aws:logs:us-west-1:123456789012:log-group:/mystack-testgroup-12ABC1AB12A1:*</code> </p> </li>
        /// <li> <p> <b>Kinesis Data Firehose delivery stream</b>:</p> <p> <code>arn:aws:kinesis:us-east-2:0123456789:stream/my_stream_name</code> </p> </li>
        /// </ul>
        pub fn destination_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_arn(input.into());
            self
        }
        /// <p>The ARN of the resource that you want Resolver to send query logs. You can send query logs to an S3 bucket, a CloudWatch Logs log group, or a Kinesis Data Firehose delivery stream. Examples of valid values include the following:</p>
        /// <ul>
        /// <li> <p> <b>S3 bucket</b>: </p> <p> <code>arn:aws:s3:::examplebucket</code> </p> <p>You can optionally append a file prefix to the end of the ARN.</p> <p> <code>arn:aws:s3:::examplebucket/development/</code> </p> </li>
        /// <li> <p> <b>CloudWatch Logs log group</b>: </p> <p> <code>arn:aws:logs:us-west-1:123456789012:log-group:/mystack-testgroup-12ABC1AB12A1:*</code> </p> </li>
        /// <li> <p> <b>Kinesis Data Firehose delivery stream</b>:</p> <p> <code>arn:aws:kinesis:us-east-2:0123456789:stream/my_stream_name</code> </p> </li>
        /// </ul>
        pub fn set_destination_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_arn(input);
            self
        }
        /// <p>A unique string that identifies the request and that allows failed requests to be retried without the risk of running the operation twice. <code>CreatorRequestId</code> can be any unique string, for example, a date/time stamp. </p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.creator_request_id(input.into());
            self
        }
        /// <p>A unique string that identifies the request and that allows failed requests to be retried without the risk of running the operation twice. <code>CreatorRequestId</code> can be any unique string, for example, a date/time stamp. </p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_creator_request_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of the tag keys and values that you want to associate with the query logging configuration.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of the tag keys and values that you want to associate with the query logging configuration.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateResolverRule`.
    ///
    /// <p>For DNS queries that originate in your VPCs, specifies which Resolver endpoint the queries pass through, one domain name that you want to forward to your network, and the IP addresses of the DNS resolvers in your network.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateResolverRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_resolver_rule_input::Builder,
    }
    impl CreateResolverRule {
        /// Creates a new `CreateResolverRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateResolverRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateResolverRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique string that identifies the request and that allows failed requests to be retried without the risk of running the operation twice. <code>CreatorRequestId</code> can be any unique string, for example, a date/time stamp. </p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.creator_request_id(input.into());
            self
        }
        /// <p>A unique string that identifies the request and that allows failed requests to be retried without the risk of running the operation twice. <code>CreatorRequestId</code> can be any unique string, for example, a date/time stamp. </p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_creator_request_id(input);
            self
        }
        /// <p>A friendly name that lets you easily find a rule in the Resolver dashboard in the Route 53 console.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A friendly name that lets you easily find a rule in the Resolver dashboard in the Route 53 console.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>When you want to forward DNS queries for specified domain name to resolvers on your network, specify <code>FORWARD</code>.</p>
        /// <p>When you have a forwarding rule to forward DNS queries for a domain to your network and you want Resolver to process queries for a subdomain of that domain, specify <code>SYSTEM</code>.</p>
        /// <p>For example, to forward DNS queries for example.com to resolvers on your network, you create a rule and specify <code>FORWARD</code> for <code>RuleType</code>. To then have Resolver process queries for apex.example.com, you create a rule and specify <code>SYSTEM</code> for <code>RuleType</code>.</p>
        /// <p>Currently, only Resolver can create rules that have a value of <code>RECURSIVE</code> for <code>RuleType</code>.</p>
        pub fn rule_type(mut self, input: crate::model::RuleTypeOption) -> Self {
            self.inner = self.inner.rule_type(input);
            self
        }
        /// <p>When you want to forward DNS queries for specified domain name to resolvers on your network, specify <code>FORWARD</code>.</p>
        /// <p>When you have a forwarding rule to forward DNS queries for a domain to your network and you want Resolver to process queries for a subdomain of that domain, specify <code>SYSTEM</code>.</p>
        /// <p>For example, to forward DNS queries for example.com to resolvers on your network, you create a rule and specify <code>FORWARD</code> for <code>RuleType</code>. To then have Resolver process queries for apex.example.com, you create a rule and specify <code>SYSTEM</code> for <code>RuleType</code>.</p>
        /// <p>Currently, only Resolver can create rules that have a value of <code>RECURSIVE</code> for <code>RuleType</code>.</p>
        pub fn set_rule_type(
            mut self,
            input: std::option::Option<crate::model::RuleTypeOption>,
        ) -> Self {
            self.inner = self.inner.set_rule_type(input);
            self
        }
        /// <p>DNS queries for this domain name are forwarded to the IP addresses that you specify in <code>TargetIps</code>. If a query matches multiple Resolver rules (example.com and www.example.com), outbound DNS queries are routed using the Resolver rule that contains the most specific domain name (www.example.com).</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>DNS queries for this domain name are forwarded to the IP addresses that you specify in <code>TargetIps</code>. If a query matches multiple Resolver rules (example.com and www.example.com), outbound DNS queries are routed using the Resolver rule that contains the most specific domain name (www.example.com).</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// Appends an item to `TargetIps`.
        ///
        /// To override the contents of this collection use [`set_target_ips`](Self::set_target_ips).
        ///
        /// <p>The IPs that you want Resolver to forward DNS queries to. You can specify only IPv4 addresses. Separate IP addresses with a space.</p>
        /// <p> <code>TargetIps</code> is available only when the value of <code>Rule type</code> is <code>FORWARD</code>.</p>
        pub fn target_ips(mut self, input: crate::model::TargetAddress) -> Self {
            self.inner = self.inner.target_ips(input);
            self
        }
        /// <p>The IPs that you want Resolver to forward DNS queries to. You can specify only IPv4 addresses. Separate IP addresses with a space.</p>
        /// <p> <code>TargetIps</code> is available only when the value of <code>Rule type</code> is <code>FORWARD</code>.</p>
        pub fn set_target_ips(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetAddress>>,
        ) -> Self {
            self.inner = self.inner.set_target_ips(input);
            self
        }
        /// <p>The ID of the outbound Resolver endpoint that you want to use to route DNS queries to the IP addresses that you specify in <code>TargetIps</code>.</p>
        pub fn resolver_endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolver_endpoint_id(input.into());
            self
        }
        /// <p>The ID of the outbound Resolver endpoint that you want to use to route DNS queries to the IP addresses that you specify in <code>TargetIps</code>.</p>
        pub fn set_resolver_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolver_endpoint_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of the tag keys and values that you want to associate with the endpoint.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of the tag keys and values that you want to associate with the endpoint.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFirewallDomainList`.
    ///
    /// <p>Deletes the specified domain list. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFirewallDomainList {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_firewall_domain_list_input::Builder,
    }
    impl DeleteFirewallDomainList {
        /// Creates a new `DeleteFirewallDomainList`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFirewallDomainListOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFirewallDomainListError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the domain list that you want to delete. </p>
        pub fn firewall_domain_list_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_domain_list_id(input.into());
            self
        }
        /// <p>The ID of the domain list that you want to delete. </p>
        pub fn set_firewall_domain_list_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_domain_list_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFirewallRule`.
    ///
    /// <p>Deletes the specified firewall rule.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFirewallRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_firewall_rule_input::Builder,
    }
    impl DeleteFirewallRule {
        /// Creates a new `DeleteFirewallRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFirewallRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFirewallRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the firewall rule group that you want to delete the rule from. </p>
        pub fn firewall_rule_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_rule_group_id(input.into());
            self
        }
        /// <p>The unique identifier of the firewall rule group that you want to delete the rule from. </p>
        pub fn set_firewall_rule_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_rule_group_id(input);
            self
        }
        /// <p>The ID of the domain list that's used in the rule. </p>
        pub fn firewall_domain_list_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_domain_list_id(input.into());
            self
        }
        /// <p>The ID of the domain list that's used in the rule. </p>
        pub fn set_firewall_domain_list_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_domain_list_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFirewallRuleGroup`.
    ///
    /// <p>Deletes the specified firewall rule group. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFirewallRuleGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_firewall_rule_group_input::Builder,
    }
    impl DeleteFirewallRuleGroup {
        /// Creates a new `DeleteFirewallRuleGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFirewallRuleGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFirewallRuleGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the firewall rule group that you want to delete. </p>
        pub fn firewall_rule_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_rule_group_id(input.into());
            self
        }
        /// <p>The unique identifier of the firewall rule group that you want to delete. </p>
        pub fn set_firewall_rule_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_rule_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResolverEndpoint`.
    ///
    /// <p>Deletes a Resolver endpoint. The effect of deleting a Resolver endpoint depends on whether it's an inbound or an outbound Resolver endpoint:</p>
    /// <ul>
    /// <li> <p> <b>Inbound</b>: DNS queries from your network are no longer routed to the DNS service for the specified VPC.</p> </li>
    /// <li> <p> <b>Outbound</b>: DNS queries from a VPC are no longer routed to your network.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteResolverEndpoint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_resolver_endpoint_input::Builder,
    }
    impl DeleteResolverEndpoint {
        /// Creates a new `DeleteResolverEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResolverEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResolverEndpointError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Resolver endpoint that you want to delete.</p>
        pub fn resolver_endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolver_endpoint_id(input.into());
            self
        }
        /// <p>The ID of the Resolver endpoint that you want to delete.</p>
        pub fn set_resolver_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolver_endpoint_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResolverQueryLogConfig`.
    ///
    /// <p>Deletes a query logging configuration. When you delete a configuration, Resolver stops logging DNS queries for all of the Amazon VPCs that are associated with the configuration. This also applies if the query logging configuration is shared with other Amazon Web Services accounts, and the other accounts have associated VPCs with the shared configuration.</p>
    /// <p>Before you can delete a query logging configuration, you must first disassociate all VPCs from the configuration. See <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverQueryLogConfig.html">DisassociateResolverQueryLogConfig</a>.</p>
    /// <p>If you used Resource Access Manager (RAM) to share a query logging configuration with other accounts, you must stop sharing the configuration before you can delete a configuration. The accounts that you shared the configuration with can first disassociate VPCs that they associated with the configuration, but that's not necessary. If you stop sharing the configuration, those VPCs are automatically disassociated from the configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteResolverQueryLogConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_resolver_query_log_config_input::Builder,
    }
    impl DeleteResolverQueryLogConfig {
        /// Creates a new `DeleteResolverQueryLogConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResolverQueryLogConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResolverQueryLogConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the query logging configuration that you want to delete.</p>
        pub fn resolver_query_log_config_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.resolver_query_log_config_id(input.into());
            self
        }
        /// <p>The ID of the query logging configuration that you want to delete.</p>
        pub fn set_resolver_query_log_config_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolver_query_log_config_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResolverRule`.
    ///
    /// <p>Deletes a Resolver rule. Before you can delete a Resolver rule, you must disassociate it from all the VPCs that you associated the Resolver rule with. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverRule.html">DisassociateResolverRule</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteResolverRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_resolver_rule_input::Builder,
    }
    impl DeleteResolverRule {
        /// Creates a new `DeleteResolverRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResolverRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResolverRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Resolver rule that you want to delete.</p>
        pub fn resolver_rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolver_rule_id(input.into());
            self
        }
        /// <p>The ID of the Resolver rule that you want to delete.</p>
        pub fn set_resolver_rule_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolver_rule_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateFirewallRuleGroup`.
    ///
    /// <p>Disassociates a <code>FirewallRuleGroup</code> from a VPC, to remove DNS filtering from the VPC. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateFirewallRuleGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_firewall_rule_group_input::Builder,
    }
    impl DisassociateFirewallRuleGroup {
        /// Creates a new `DisassociateFirewallRuleGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateFirewallRuleGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateFirewallRuleGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the <code>FirewallRuleGroupAssociation</code>. </p>
        pub fn firewall_rule_group_association_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.firewall_rule_group_association_id(input.into());
            self
        }
        /// <p>The identifier of the <code>FirewallRuleGroupAssociation</code>. </p>
        pub fn set_firewall_rule_group_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_rule_group_association_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateResolverEndpointIpAddress`.
    ///
    /// <p>Removes IP addresses from an inbound or an outbound Resolver endpoint. If you want to remove more than one IP address, submit one <code>DisassociateResolverEndpointIpAddress</code> request for each IP address.</p>
    /// <p>To add an IP address to an endpoint, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverEndpointIpAddress.html">AssociateResolverEndpointIpAddress</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateResolverEndpointIpAddress {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_resolver_endpoint_ip_address_input::Builder,
    }
    impl DisassociateResolverEndpointIpAddress {
        /// Creates a new `DisassociateResolverEndpointIpAddress`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateResolverEndpointIpAddressOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateResolverEndpointIpAddressError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Resolver endpoint that you want to disassociate an IP address from.</p>
        pub fn resolver_endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolver_endpoint_id(input.into());
            self
        }
        /// <p>The ID of the Resolver endpoint that you want to disassociate an IP address from.</p>
        pub fn set_resolver_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolver_endpoint_id(input);
            self
        }
        /// <p>The IPv4 address that you want to remove from a Resolver endpoint.</p>
        pub fn ip_address(mut self, input: crate::model::IpAddressUpdate) -> Self {
            self.inner = self.inner.ip_address(input);
            self
        }
        /// <p>The IPv4 address that you want to remove from a Resolver endpoint.</p>
        pub fn set_ip_address(
            mut self,
            input: std::option::Option<crate::model::IpAddressUpdate>,
        ) -> Self {
            self.inner = self.inner.set_ip_address(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateResolverQueryLogConfig`.
    ///
    /// <p>Disassociates a VPC from a query logging configuration.</p> <note>
    /// <p>Before you can delete a query logging configuration, you must first disassociate all VPCs from the configuration. If you used Resource Access Manager (RAM) to share a query logging configuration with other accounts, VPCs can be disassociated from the configuration in the following ways:</p>
    /// <ul>
    /// <li> <p>The accounts that you shared the configuration with can disassociate VPCs from the configuration.</p> </li>
    /// <li> <p>You can stop sharing the configuration.</p> </li>
    /// </ul>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateResolverQueryLogConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_resolver_query_log_config_input::Builder,
    }
    impl DisassociateResolverQueryLogConfig {
        /// Creates a new `DisassociateResolverQueryLogConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateResolverQueryLogConfigOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateResolverQueryLogConfigError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the query logging configuration that you want to disassociate a specified VPC from.</p>
        pub fn resolver_query_log_config_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.resolver_query_log_config_id(input.into());
            self
        }
        /// <p>The ID of the query logging configuration that you want to disassociate a specified VPC from.</p>
        pub fn set_resolver_query_log_config_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolver_query_log_config_id(input);
            self
        }
        /// <p>The ID of the Amazon VPC that you want to disassociate from a specified query logging configuration.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The ID of the Amazon VPC that you want to disassociate from a specified query logging configuration.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateResolverRule`.
    ///
    /// <p>Removes the association between a specified Resolver rule and a specified VPC.</p> <important>
    /// <p>If you disassociate a Resolver rule from a VPC, Resolver stops forwarding DNS queries for the domain name that you specified in the Resolver rule. </p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateResolverRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_resolver_rule_input::Builder,
    }
    impl DisassociateResolverRule {
        /// Creates a new `DisassociateResolverRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateResolverRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateResolverRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the VPC that you want to disassociate the Resolver rule from.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_id(input.into());
            self
        }
        /// <p>The ID of the VPC that you want to disassociate the Resolver rule from.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_id(input);
            self
        }
        /// <p>The ID of the Resolver rule that you want to disassociate from the specified VPC.</p>
        pub fn resolver_rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolver_rule_id(input.into());
            self
        }
        /// <p>The ID of the Resolver rule that you want to disassociate from the specified VPC.</p>
        pub fn set_resolver_rule_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolver_rule_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFirewallConfig`.
    ///
    /// <p>Retrieves the configuration of the firewall behavior provided by DNS Firewall for a single VPC from Amazon Virtual Private Cloud (Amazon VPC). </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFirewallConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_firewall_config_input::Builder,
    }
    impl GetFirewallConfig {
        /// Creates a new `GetFirewallConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFirewallConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFirewallConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the VPC from Amazon VPC that the configuration is for.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The ID of the VPC from Amazon VPC that the configuration is for.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFirewallDomainList`.
    ///
    /// <p>Retrieves the specified firewall domain list.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFirewallDomainList {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_firewall_domain_list_input::Builder,
    }
    impl GetFirewallDomainList {
        /// Creates a new `GetFirewallDomainList`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFirewallDomainListOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFirewallDomainListError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the domain list. </p>
        pub fn firewall_domain_list_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_domain_list_id(input.into());
            self
        }
        /// <p>The ID of the domain list. </p>
        pub fn set_firewall_domain_list_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_domain_list_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFirewallRuleGroup`.
    ///
    /// <p>Retrieves the specified firewall rule group. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFirewallRuleGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_firewall_rule_group_input::Builder,
    }
    impl GetFirewallRuleGroup {
        /// Creates a new `GetFirewallRuleGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFirewallRuleGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFirewallRuleGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the firewall rule group. </p>
        pub fn firewall_rule_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_rule_group_id(input.into());
            self
        }
        /// <p>The unique identifier of the firewall rule group. </p>
        pub fn set_firewall_rule_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_rule_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFirewallRuleGroupAssociation`.
    ///
    /// <p>Retrieves a firewall rule group association, which enables DNS filtering for a VPC with one rule group. A VPC can have more than one firewall rule group association, and a rule group can be associated with more than one VPC.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFirewallRuleGroupAssociation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_firewall_rule_group_association_input::Builder,
    }
    impl GetFirewallRuleGroupAssociation {
        /// Creates a new `GetFirewallRuleGroupAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFirewallRuleGroupAssociationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFirewallRuleGroupAssociationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the <code>FirewallRuleGroupAssociation</code>. </p>
        pub fn firewall_rule_group_association_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.firewall_rule_group_association_id(input.into());
            self
        }
        /// <p>The identifier of the <code>FirewallRuleGroupAssociation</code>. </p>
        pub fn set_firewall_rule_group_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_rule_group_association_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFirewallRuleGroupPolicy`.
    ///
    /// <p>Returns the Identity and Access Management (Amazon Web Services IAM) policy for sharing the specified rule group. You can use the policy to share the rule group using Resource Access Manager (RAM). </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFirewallRuleGroupPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_firewall_rule_group_policy_input::Builder,
    }
    impl GetFirewallRuleGroupPolicy {
        /// Creates a new `GetFirewallRuleGroupPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFirewallRuleGroupPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFirewallRuleGroupPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN (Amazon Resource Name) for the rule group.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The ARN (Amazon Resource Name) for the rule group.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResolverConfig`.
    ///
    /// <p>Retrieves the behavior configuration of Route 53 Resolver behavior for a single VPC from Amazon Virtual Private Cloud.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetResolverConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_resolver_config_input::Builder,
    }
    impl GetResolverConfig {
        /// Creates a new `GetResolverConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResolverConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResolverConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Resource ID of the Amazon VPC that you want to get information about.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>Resource ID of the Amazon VPC that you want to get information about.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResolverDnssecConfig`.
    ///
    /// <p>Gets DNSSEC validation information for a specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetResolverDnssecConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_resolver_dnssec_config_input::Builder,
    }
    impl GetResolverDnssecConfig {
        /// Creates a new `GetResolverDnssecConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResolverDnssecConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResolverDnssecConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the virtual private cloud (VPC) for the DNSSEC validation status.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The ID of the virtual private cloud (VPC) for the DNSSEC validation status.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResolverEndpoint`.
    ///
    /// <p>Gets information about a specified Resolver endpoint, such as whether it's an inbound or an outbound Resolver endpoint, and the current status of the endpoint.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetResolverEndpoint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_resolver_endpoint_input::Builder,
    }
    impl GetResolverEndpoint {
        /// Creates a new `GetResolverEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResolverEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResolverEndpointError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Resolver endpoint that you want to get information about.</p>
        pub fn resolver_endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolver_endpoint_id(input.into());
            self
        }
        /// <p>The ID of the Resolver endpoint that you want to get information about.</p>
        pub fn set_resolver_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolver_endpoint_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResolverQueryLogConfig`.
    ///
    /// <p>Gets information about a specified Resolver query logging configuration, such as the number of VPCs that the configuration is logging queries for and the location that logs are sent to. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetResolverQueryLogConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_resolver_query_log_config_input::Builder,
    }
    impl GetResolverQueryLogConfig {
        /// Creates a new `GetResolverQueryLogConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResolverQueryLogConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResolverQueryLogConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Resolver query logging configuration that you want to get information about.</p>
        pub fn resolver_query_log_config_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.resolver_query_log_config_id(input.into());
            self
        }
        /// <p>The ID of the Resolver query logging configuration that you want to get information about.</p>
        pub fn set_resolver_query_log_config_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolver_query_log_config_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResolverQueryLogConfigAssociation`.
    ///
    /// <p>Gets information about a specified association between a Resolver query logging configuration and an Amazon VPC. When you associate a VPC with a query logging configuration, Resolver logs DNS queries that originate in that VPC.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetResolverQueryLogConfigAssociation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_resolver_query_log_config_association_input::Builder,
    }
    impl GetResolverQueryLogConfigAssociation {
        /// Creates a new `GetResolverQueryLogConfigAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResolverQueryLogConfigAssociationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetResolverQueryLogConfigAssociationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Resolver query logging configuration association that you want to get information about.</p>
        pub fn resolver_query_log_config_association_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .resolver_query_log_config_association_id(input.into());
            self
        }
        /// <p>The ID of the Resolver query logging configuration association that you want to get information about.</p>
        pub fn set_resolver_query_log_config_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .set_resolver_query_log_config_association_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResolverQueryLogConfigPolicy`.
    ///
    /// <p>Gets information about a query logging policy. A query logging policy specifies the Resolver query logging operations and resources that you want to allow another Amazon Web Services account to be able to use.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetResolverQueryLogConfigPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_resolver_query_log_config_policy_input::Builder,
    }
    impl GetResolverQueryLogConfigPolicy {
        /// Creates a new `GetResolverQueryLogConfigPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResolverQueryLogConfigPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResolverQueryLogConfigPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the query logging configuration that you want to get the query logging policy for.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The ARN of the query logging configuration that you want to get the query logging policy for.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResolverRule`.
    ///
    /// <p>Gets information about a specified Resolver rule, such as the domain name that the rule forwards DNS queries for and the ID of the outbound Resolver endpoint that the rule is associated with.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetResolverRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_resolver_rule_input::Builder,
    }
    impl GetResolverRule {
        /// Creates a new `GetResolverRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResolverRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResolverRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Resolver rule that you want to get information about.</p>
        pub fn resolver_rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolver_rule_id(input.into());
            self
        }
        /// <p>The ID of the Resolver rule that you want to get information about.</p>
        pub fn set_resolver_rule_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolver_rule_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResolverRuleAssociation`.
    ///
    /// <p>Gets information about an association between a specified Resolver rule and a VPC. You associate a Resolver rule and a VPC using <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverRule.html">AssociateResolverRule</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetResolverRuleAssociation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_resolver_rule_association_input::Builder,
    }
    impl GetResolverRuleAssociation {
        /// Creates a new `GetResolverRuleAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResolverRuleAssociationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResolverRuleAssociationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Resolver rule association that you want to get information about.</p>
        pub fn resolver_rule_association_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.resolver_rule_association_id(input.into());
            self
        }
        /// <p>The ID of the Resolver rule association that you want to get information about.</p>
        pub fn set_resolver_rule_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolver_rule_association_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResolverRulePolicy`.
    ///
    /// <p>Gets information about the Resolver rule policy for a specified rule. A Resolver rule policy includes the rule that you want to share with another account, the account that you want to share the rule with, and the Resolver operations that you want to allow the account to use. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetResolverRulePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_resolver_rule_policy_input::Builder,
    }
    impl GetResolverRulePolicy {
        /// Creates a new `GetResolverRulePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResolverRulePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResolverRulePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Resolver rule that you want to get the Resolver rule policy for.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The ID of the Resolver rule that you want to get the Resolver rule policy for.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportFirewallDomains`.
    ///
    /// <p>Imports domain names from a file into a domain list, for use in a DNS firewall rule group. </p>
    /// <p>Each domain specification in your domain list must satisfy the following requirements: </p>
    /// <ul>
    /// <li> <p>It can optionally start with <code>*</code> (asterisk).</p> </li>
    /// <li> <p>With the exception of the optional starting asterisk, it must only contain the following characters: <code>A-Z</code>, <code>a-z</code>, <code>0-9</code>, <code>-</code> (hyphen).</p> </li>
    /// <li> <p>It must be from 1-255 characters in length. </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ImportFirewallDomains {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::import_firewall_domains_input::Builder,
    }
    impl ImportFirewallDomains {
        /// Creates a new `ImportFirewallDomains`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportFirewallDomainsOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportFirewallDomainsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the domain list that you want to modify with the import operation.</p>
        pub fn firewall_domain_list_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_domain_list_id(input.into());
            self
        }
        /// <p>The ID of the domain list that you want to modify with the import operation.</p>
        pub fn set_firewall_domain_list_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_domain_list_id(input);
            self
        }
        /// <p>What you want DNS Firewall to do with the domains that are listed in the file. This must be set to <code>REPLACE</code>, which updates the domain list to exactly match the list in the file. </p>
        pub fn operation(mut self, input: crate::model::FirewallDomainImportOperation) -> Self {
            self.inner = self.inner.operation(input);
            self
        }
        /// <p>What you want DNS Firewall to do with the domains that are listed in the file. This must be set to <code>REPLACE</code>, which updates the domain list to exactly match the list in the file. </p>
        pub fn set_operation(
            mut self,
            input: std::option::Option<crate::model::FirewallDomainImportOperation>,
        ) -> Self {
            self.inner = self.inner.set_operation(input);
            self
        }
        /// <p>The fully qualified URL or URI of the file stored in Amazon Simple Storage Service (Amazon S3) that contains the list of domains to import.</p>
        /// <p>The file must be in an S3 bucket that's in the same Region as your DNS Firewall. The file must be a text file and must contain a single domain per line.</p>
        pub fn domain_file_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_file_url(input.into());
            self
        }
        /// <p>The fully qualified URL or URI of the file stored in Amazon Simple Storage Service (Amazon S3) that contains the list of domains to import.</p>
        /// <p>The file must be in an S3 bucket that's in the same Region as your DNS Firewall. The file must be a text file and must contain a single domain per line.</p>
        pub fn set_domain_file_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_domain_file_url(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFirewallConfigs`.
    ///
    /// <p>Retrieves the firewall configurations that you have defined. DNS Firewall uses the configurations to manage firewall behavior for your VPCs. </p>
    /// <p>A single call might return only a partial list of the configurations. For information, see <code>MaxResults</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFirewallConfigs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_firewall_configs_input::Builder,
    }
    impl ListFirewallConfigs {
        /// Creates a new `ListFirewallConfigs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFirewallConfigsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFirewallConfigsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFirewallConfigsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListFirewallConfigsPaginator {
            crate::paginator::ListFirewallConfigsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of objects that you want Resolver to return for this request. If more objects are available, in the response, Resolver provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of objects that you want Resolver to return for this request. If more objects are available, in the response, Resolver provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>For the first call to this list request, omit this value.</p>
        /// <p>When you request a list of objects, Resolver returns at most the number of objects specified in <code>MaxResults</code>. If more objects are available for retrieval, Resolver returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token that was returned for the prior request in your next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>For the first call to this list request, omit this value.</p>
        /// <p>When you request a list of objects, Resolver returns at most the number of objects specified in <code>MaxResults</code>. If more objects are available for retrieval, Resolver returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token that was returned for the prior request in your next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFirewallDomainLists`.
    ///
    /// <p>Retrieves the firewall domain lists that you have defined. For each firewall domain list, you can retrieve the domains that are defined for a list by calling <code>ListFirewallDomains</code>. </p>
    /// <p>A single call to this list operation might return only a partial list of the domain lists. For information, see <code>MaxResults</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFirewallDomainLists {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_firewall_domain_lists_input::Builder,
    }
    impl ListFirewallDomainLists {
        /// Creates a new `ListFirewallDomainLists`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFirewallDomainListsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFirewallDomainListsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFirewallDomainListsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListFirewallDomainListsPaginator {
            crate::paginator::ListFirewallDomainListsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of objects that you want Resolver to return for this request. If more objects are available, in the response, Resolver provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of objects that you want Resolver to return for this request. If more objects are available, in the response, Resolver provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>For the first call to this list request, omit this value.</p>
        /// <p>When you request a list of objects, Resolver returns at most the number of objects specified in <code>MaxResults</code>. If more objects are available for retrieval, Resolver returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token that was returned for the prior request in your next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>For the first call to this list request, omit this value.</p>
        /// <p>When you request a list of objects, Resolver returns at most the number of objects specified in <code>MaxResults</code>. If more objects are available for retrieval, Resolver returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token that was returned for the prior request in your next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFirewallDomains`.
    ///
    /// <p>Retrieves the domains that you have defined for the specified firewall domain list. </p>
    /// <p>A single call might return only a partial list of the domains. For information, see <code>MaxResults</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFirewallDomains {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_firewall_domains_input::Builder,
    }
    impl ListFirewallDomains {
        /// Creates a new `ListFirewallDomains`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFirewallDomainsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFirewallDomainsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFirewallDomainsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListFirewallDomainsPaginator {
            crate::paginator::ListFirewallDomainsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the domain list whose domains you want to retrieve. </p>
        pub fn firewall_domain_list_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_domain_list_id(input.into());
            self
        }
        /// <p>The ID of the domain list whose domains you want to retrieve. </p>
        pub fn set_firewall_domain_list_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_domain_list_id(input);
            self
        }
        /// <p>The maximum number of objects that you want Resolver to return for this request. If more objects are available, in the response, Resolver provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of objects that you want Resolver to return for this request. If more objects are available, in the response, Resolver provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>For the first call to this list request, omit this value.</p>
        /// <p>When you request a list of objects, Resolver returns at most the number of objects specified in <code>MaxResults</code>. If more objects are available for retrieval, Resolver returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token that was returned for the prior request in your next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>For the first call to this list request, omit this value.</p>
        /// <p>When you request a list of objects, Resolver returns at most the number of objects specified in <code>MaxResults</code>. If more objects are available for retrieval, Resolver returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token that was returned for the prior request in your next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFirewallRuleGroupAssociations`.
    ///
    /// <p>Retrieves the firewall rule group associations that you have defined. Each association enables DNS filtering for a VPC with one rule group. </p>
    /// <p>A single call might return only a partial list of the associations. For information, see <code>MaxResults</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFirewallRuleGroupAssociations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_firewall_rule_group_associations_input::Builder,
    }
    impl ListFirewallRuleGroupAssociations {
        /// Creates a new `ListFirewallRuleGroupAssociations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFirewallRuleGroupAssociationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFirewallRuleGroupAssociationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFirewallRuleGroupAssociationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListFirewallRuleGroupAssociationsPaginator {
            crate::paginator::ListFirewallRuleGroupAssociationsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The unique identifier of the firewall rule group that you want to retrieve the associations for. Leave this blank to retrieve associations for any rule group. </p>
        pub fn firewall_rule_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_rule_group_id(input.into());
            self
        }
        /// <p>The unique identifier of the firewall rule group that you want to retrieve the associations for. Leave this blank to retrieve associations for any rule group. </p>
        pub fn set_firewall_rule_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_rule_group_id(input);
            self
        }
        /// <p>The unique identifier of the VPC that you want to retrieve the associations for. Leave this blank to retrieve associations for any VPC. </p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_id(input.into());
            self
        }
        /// <p>The unique identifier of the VPC that you want to retrieve the associations for. Leave this blank to retrieve associations for any VPC. </p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_id(input);
            self
        }
        /// <p>The setting that determines the processing order of the rule group among the rule groups that are associated with a single VPC. DNS Firewall filters VPC traffic starting from the rule group with the lowest numeric priority setting. </p>
        pub fn priority(mut self, input: i32) -> Self {
            self.inner = self.inner.priority(input);
            self
        }
        /// <p>The setting that determines the processing order of the rule group among the rule groups that are associated with a single VPC. DNS Firewall filters VPC traffic starting from the rule group with the lowest numeric priority setting. </p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_priority(input);
            self
        }
        /// <p>The association <code>Status</code> setting that you want DNS Firewall to filter on for the list. If you don't specify this, then DNS Firewall returns all associations, regardless of status.</p>
        pub fn status(mut self, input: crate::model::FirewallRuleGroupAssociationStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>The association <code>Status</code> setting that you want DNS Firewall to filter on for the list. If you don't specify this, then DNS Firewall returns all associations, regardless of status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::FirewallRuleGroupAssociationStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>The maximum number of objects that you want Resolver to return for this request. If more objects are available, in the response, Resolver provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of objects that you want Resolver to return for this request. If more objects are available, in the response, Resolver provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>For the first call to this list request, omit this value.</p>
        /// <p>When you request a list of objects, Resolver returns at most the number of objects specified in <code>MaxResults</code>. If more objects are available for retrieval, Resolver returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token that was returned for the prior request in your next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>For the first call to this list request, omit this value.</p>
        /// <p>When you request a list of objects, Resolver returns at most the number of objects specified in <code>MaxResults</code>. If more objects are available for retrieval, Resolver returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token that was returned for the prior request in your next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFirewallRuleGroups`.
    ///
    /// <p>Retrieves the minimal high-level information for the rule groups that you have defined. </p>
    /// <p>A single call might return only a partial list of the rule groups. For information, see <code>MaxResults</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFirewallRuleGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_firewall_rule_groups_input::Builder,
    }
    impl ListFirewallRuleGroups {
        /// Creates a new `ListFirewallRuleGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFirewallRuleGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFirewallRuleGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFirewallRuleGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListFirewallRuleGroupsPaginator {
            crate::paginator::ListFirewallRuleGroupsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of objects that you want Resolver to return for this request. If more objects are available, in the response, Resolver provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of objects that you want Resolver to return for this request. If more objects are available, in the response, Resolver provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>For the first call to this list request, omit this value.</p>
        /// <p>When you request a list of objects, Resolver returns at most the number of objects specified in <code>MaxResults</code>. If more objects are available for retrieval, Resolver returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token that was returned for the prior request in your next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>For the first call to this list request, omit this value.</p>
        /// <p>When you request a list of objects, Resolver returns at most the number of objects specified in <code>MaxResults</code>. If more objects are available for retrieval, Resolver returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token that was returned for the prior request in your next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFirewallRules`.
    ///
    /// <p>Retrieves the firewall rules that you have defined for the specified firewall rule group. DNS Firewall uses the rules in a rule group to filter DNS network traffic for a VPC. </p>
    /// <p>A single call might return only a partial list of the rules. For information, see <code>MaxResults</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFirewallRules {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_firewall_rules_input::Builder,
    }
    impl ListFirewallRules {
        /// Creates a new `ListFirewallRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFirewallRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFirewallRulesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFirewallRulesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListFirewallRulesPaginator {
            crate::paginator::ListFirewallRulesPaginator::new(self.handle, self.inner)
        }
        /// <p>The unique identifier of the firewall rule group that you want to retrieve the rules for. </p>
        pub fn firewall_rule_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_rule_group_id(input.into());
            self
        }
        /// <p>The unique identifier of the firewall rule group that you want to retrieve the rules for. </p>
        pub fn set_firewall_rule_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_rule_group_id(input);
            self
        }
        /// <p>Optional additional filter for the rules to retrieve.</p>
        /// <p>The setting that determines the processing order of the rules in a rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.inner = self.inner.priority(input);
            self
        }
        /// <p>Optional additional filter for the rules to retrieve.</p>
        /// <p>The setting that determines the processing order of the rules in a rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_priority(input);
            self
        }
        /// <p>Optional additional filter for the rules to retrieve.</p>
        /// <p>The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list:</p>
        /// <ul>
        /// <li> <p> <code>ALLOW</code> - Permit the request to go through.</p> </li>
        /// <li> <p> <code>ALERT</code> - Permit the request to go through but send an alert to the logs.</p> </li>
        /// <li> <p> <code>BLOCK</code> - Disallow the request. If this is specified, additional handling details are provided in the rule's <code>BlockResponse</code> setting. </p> </li>
        /// </ul>
        pub fn action(mut self, input: crate::model::Action) -> Self {
            self.inner = self.inner.action(input);
            self
        }
        /// <p>Optional additional filter for the rules to retrieve.</p>
        /// <p>The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list:</p>
        /// <ul>
        /// <li> <p> <code>ALLOW</code> - Permit the request to go through.</p> </li>
        /// <li> <p> <code>ALERT</code> - Permit the request to go through but send an alert to the logs.</p> </li>
        /// <li> <p> <code>BLOCK</code> - Disallow the request. If this is specified, additional handling details are provided in the rule's <code>BlockResponse</code> setting. </p> </li>
        /// </ul>
        pub fn set_action(mut self, input: std::option::Option<crate::model::Action>) -> Self {
            self.inner = self.inner.set_action(input);
            self
        }
        /// <p>The maximum number of objects that you want Resolver to return for this request. If more objects are available, in the response, Resolver provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of objects that you want Resolver to return for this request. If more objects are available, in the response, Resolver provides a <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>For the first call to this list request, omit this value.</p>
        /// <p>When you request a list of objects, Resolver returns at most the number of objects specified in <code>MaxResults</code>. If more objects are available for retrieval, Resolver returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token that was returned for the prior request in your next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>For the first call to this list request, omit this value.</p>
        /// <p>When you request a list of objects, Resolver returns at most the number of objects specified in <code>MaxResults</code>. If more objects are available for retrieval, Resolver returns a <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token that was returned for the prior request in your next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResolverConfigs`.
    ///
    /// <p>Retrieves the Resolver configurations that you have defined. Route 53 Resolver uses the configurations to manage DNS resolution behavior for your VPCs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListResolverConfigs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_resolver_configs_input::Builder,
    }
    impl ListResolverConfigs {
        /// Creates a new `ListResolverConfigs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResolverConfigsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResolverConfigsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListResolverConfigsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListResolverConfigsPaginator {
            crate::paginator::ListResolverConfigsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of Resolver configurations that you want to return in the response to a <code>ListResolverConfigs</code> request. If you don't specify a value for <code>MaxResults</code>, up to 100 Resolver configurations are returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of Resolver configurations that you want to return in the response to a <code>ListResolverConfigs</code> request. If you don't specify a value for <code>MaxResults</code>, up to 100 Resolver configurations are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>(Optional) If the current Amazon Web Services account has more than <code>MaxResults</code> Resolver configurations, use <code>NextToken</code> to get the second and subsequent pages of results.</p>
        /// <p>For the first <code>ListResolverConfigs</code> request, omit this value.</p>
        /// <p>For the second and subsequent requests, get the value of <code>NextToken</code> from the previous response and specify that value for <code>NextToken</code> in the request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>(Optional) If the current Amazon Web Services account has more than <code>MaxResults</code> Resolver configurations, use <code>NextToken</code> to get the second and subsequent pages of results.</p>
        /// <p>For the first <code>ListResolverConfigs</code> request, omit this value.</p>
        /// <p>For the second and subsequent requests, get the value of <code>NextToken</code> from the previous response and specify that value for <code>NextToken</code> in the request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResolverDnssecConfigs`.
    ///
    /// <p>Lists the configurations for DNSSEC validation that are associated with the current Amazon Web Services account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListResolverDnssecConfigs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_resolver_dnssec_configs_input::Builder,
    }
    impl ListResolverDnssecConfigs {
        /// Creates a new `ListResolverDnssecConfigs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResolverDnssecConfigsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResolverDnssecConfigsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListResolverDnssecConfigsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListResolverDnssecConfigsPaginator {
            crate::paginator::ListResolverDnssecConfigsPaginator::new(self.handle, self.inner)
        }
        /// <p> <i>Optional</i>: An integer that specifies the maximum number of DNSSEC configuration results that you want Amazon Route 53 to return. If you don't specify a value for <code>MaxResults</code>, Route 53 returns up to 100 configuration per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> <i>Optional</i>: An integer that specifies the maximum number of DNSSEC configuration results that you want Amazon Route 53 to return. If you don't specify a value for <code>MaxResults</code>, Route 53 returns up to 100 configuration per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>(Optional) If the current Amazon Web Services account has more than <code>MaxResults</code> DNSSEC configurations, use <code>NextToken</code> to get the second and subsequent pages of results.</p>
        /// <p>For the first <code>ListResolverDnssecConfigs</code> request, omit this value.</p>
        /// <p>For the second and subsequent requests, get the value of <code>NextToken</code> from the previous response and specify that value for <code>NextToken</code> in the request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>(Optional) If the current Amazon Web Services account has more than <code>MaxResults</code> DNSSEC configurations, use <code>NextToken</code> to get the second and subsequent pages of results.</p>
        /// <p>For the first <code>ListResolverDnssecConfigs</code> request, omit this value.</p>
        /// <p>For the second and subsequent requests, get the value of <code>NextToken</code> from the previous response and specify that value for <code>NextToken</code> in the request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An optional specification to return a subset of objects.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>An optional specification to return a subset of objects.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResolverEndpointIpAddresses`.
    ///
    /// <p>Gets the IP addresses for a specified Resolver endpoint.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListResolverEndpointIpAddresses {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_resolver_endpoint_ip_addresses_input::Builder,
    }
    impl ListResolverEndpointIpAddresses {
        /// Creates a new `ListResolverEndpointIpAddresses`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResolverEndpointIpAddressesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResolverEndpointIpAddressesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListResolverEndpointIpAddressesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListResolverEndpointIpAddressesPaginator {
            crate::paginator::ListResolverEndpointIpAddressesPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the Resolver endpoint that you want to get IP addresses for.</p>
        pub fn resolver_endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolver_endpoint_id(input.into());
            self
        }
        /// <p>The ID of the Resolver endpoint that you want to get IP addresses for.</p>
        pub fn set_resolver_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolver_endpoint_id(input);
            self
        }
        /// <p>The maximum number of IP addresses that you want to return in the response to a <code>ListResolverEndpointIpAddresses</code> request. If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 IP addresses. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of IP addresses that you want to return in the response to a <code>ListResolverEndpointIpAddresses</code> request. If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 IP addresses. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>For the first <code>ListResolverEndpointIpAddresses</code> request, omit this value.</p>
        /// <p>If the specified Resolver endpoint has more than <code>MaxResults</code> IP addresses, you can submit another <code>ListResolverEndpointIpAddresses</code> request to get the next group of IP addresses. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>For the first <code>ListResolverEndpointIpAddresses</code> request, omit this value.</p>
        /// <p>If the specified Resolver endpoint has more than <code>MaxResults</code> IP addresses, you can submit another <code>ListResolverEndpointIpAddresses</code> request to get the next group of IP addresses. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResolverEndpoints`.
    ///
    /// <p>Lists all the Resolver endpoints that were created using the current Amazon Web Services account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListResolverEndpoints {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_resolver_endpoints_input::Builder,
    }
    impl ListResolverEndpoints {
        /// Creates a new `ListResolverEndpoints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResolverEndpointsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResolverEndpointsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListResolverEndpointsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListResolverEndpointsPaginator {
            crate::paginator::ListResolverEndpointsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of Resolver endpoints that you want to return in the response to a <code>ListResolverEndpoints</code> request. If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 Resolver endpoints. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of Resolver endpoints that you want to return in the response to a <code>ListResolverEndpoints</code> request. If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 Resolver endpoints. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>For the first <code>ListResolverEndpoints</code> request, omit this value.</p>
        /// <p>If you have more than <code>MaxResults</code> Resolver endpoints, you can submit another <code>ListResolverEndpoints</code> request to get the next group of Resolver endpoints. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>For the first <code>ListResolverEndpoints</code> request, omit this value.</p>
        /// <p>If you have more than <code>MaxResults</code> Resolver endpoints, you can submit another <code>ListResolverEndpoints</code> request to get the next group of Resolver endpoints. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An optional specification to return a subset of Resolver endpoints, such as all inbound Resolver endpoints.</p> <note>
        /// <p>If you submit a second or subsequent <code>ListResolverEndpoints</code> request and specify the <code>NextToken</code> parameter, you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>
        /// </note>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>An optional specification to return a subset of Resolver endpoints, such as all inbound Resolver endpoints.</p> <note>
        /// <p>If you submit a second or subsequent <code>ListResolverEndpoints</code> request and specify the <code>NextToken</code> parameter, you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>
        /// </note>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResolverQueryLogConfigAssociations`.
    ///
    /// <p>Lists information about associations between Amazon VPCs and query logging configurations.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListResolverQueryLogConfigAssociations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_resolver_query_log_config_associations_input::Builder,
    }
    impl ListResolverQueryLogConfigAssociations {
        /// Creates a new `ListResolverQueryLogConfigAssociations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResolverQueryLogConfigAssociationsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListResolverQueryLogConfigAssociationsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListResolverQueryLogConfigAssociationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListResolverQueryLogConfigAssociationsPaginator {
            crate::paginator::ListResolverQueryLogConfigAssociationsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The maximum number of query logging associations that you want to return in the response to a <code>ListResolverQueryLogConfigAssociations</code> request. If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 query logging associations. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of query logging associations that you want to return in the response to a <code>ListResolverQueryLogConfigAssociations</code> request. If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 query logging associations. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>For the first <code>ListResolverQueryLogConfigAssociations</code> request, omit this value.</p>
        /// <p>If there are more than <code>MaxResults</code> query logging associations that match the values that you specify for <code>Filters</code>, you can submit another <code>ListResolverQueryLogConfigAssociations</code> request to get the next group of associations. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>For the first <code>ListResolverQueryLogConfigAssociations</code> request, omit this value.</p>
        /// <p>If there are more than <code>MaxResults</code> query logging associations that match the values that you specify for <code>Filters</code>, you can submit another <code>ListResolverQueryLogConfigAssociations</code> request to get the next group of associations. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An optional specification to return a subset of query logging associations.</p> <note>
        /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigAssociations</code> request and specify the <code>NextToken</code> parameter, you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>
        /// </note>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>An optional specification to return a subset of query logging associations.</p> <note>
        /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigAssociations</code> request and specify the <code>NextToken</code> parameter, you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>
        /// </note>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The element that you want Resolver to sort query logging associations by. </p> <note>
        /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigAssociations</code> request and specify the <code>NextToken</code> parameter, you must use the same value for <code>SortBy</code>, if any, as in the previous request.</p>
        /// </note>
        /// <p>Valid values include the following elements:</p>
        /// <ul>
        /// <li> <p> <code>CreationTime</code>: The ID of the query logging association.</p> </li>
        /// <li> <p> <code>Error</code>: If the value of <code>Status</code> is <code>FAILED</code>, the value of <code>Error</code> indicates the cause: </p>
        /// <ul>
        /// <li> <p> <code>DESTINATION_NOT_FOUND</code>: The specified destination (for example, an Amazon S3 bucket) was deleted.</p> </li>
        /// <li> <p> <code>ACCESS_DENIED</code>: Permissions don't allow sending logs to the destination.</p> </li>
        /// </ul> <p>If <code>Status</code> is a value other than <code>FAILED</code>, <code>ERROR</code> is null.</p> </li>
        /// <li> <p> <code>Id</code>: The ID of the query logging association</p> </li>
        /// <li> <p> <code>ResolverQueryLogConfigId</code>: The ID of the query logging configuration</p> </li>
        /// <li> <p> <code>ResourceId</code>: The ID of the VPC that is associated with the query logging configuration</p> </li>
        /// <li> <p> <code>Status</code>: The current status of the configuration. Valid values include the following:</p>
        /// <ul>
        /// <li> <p> <code>CREATING</code>: Resolver is creating an association between an Amazon VPC and a query logging configuration.</p> </li>
        /// <li> <p> <code>CREATED</code>: The association between an Amazon VPC and a query logging configuration was successfully created. Resolver is logging queries that originate in the specified VPC.</p> </li>
        /// <li> <p> <code>DELETING</code>: Resolver is deleting this query logging association.</p> </li>
        /// <li> <p> <code>FAILED</code>: Resolver either couldn't create or couldn't delete the query logging association. Here are two common causes:</p>
        /// <ul>
        /// <li> <p>The specified destination (for example, an Amazon S3 bucket) was deleted.</p> </li>
        /// <li> <p>Permissions don't allow sending logs to the destination.</p> </li>
        /// </ul> </li>
        /// </ul> </li>
        /// </ul>
        pub fn sort_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sort_by(input.into());
            self
        }
        /// <p>The element that you want Resolver to sort query logging associations by. </p> <note>
        /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigAssociations</code> request and specify the <code>NextToken</code> parameter, you must use the same value for <code>SortBy</code>, if any, as in the previous request.</p>
        /// </note>
        /// <p>Valid values include the following elements:</p>
        /// <ul>
        /// <li> <p> <code>CreationTime</code>: The ID of the query logging association.</p> </li>
        /// <li> <p> <code>Error</code>: If the value of <code>Status</code> is <code>FAILED</code>, the value of <code>Error</code> indicates the cause: </p>
        /// <ul>
        /// <li> <p> <code>DESTINATION_NOT_FOUND</code>: The specified destination (for example, an Amazon S3 bucket) was deleted.</p> </li>
        /// <li> <p> <code>ACCESS_DENIED</code>: Permissions don't allow sending logs to the destination.</p> </li>
        /// </ul> <p>If <code>Status</code> is a value other than <code>FAILED</code>, <code>ERROR</code> is null.</p> </li>
        /// <li> <p> <code>Id</code>: The ID of the query logging association</p> </li>
        /// <li> <p> <code>ResolverQueryLogConfigId</code>: The ID of the query logging configuration</p> </li>
        /// <li> <p> <code>ResourceId</code>: The ID of the VPC that is associated with the query logging configuration</p> </li>
        /// <li> <p> <code>Status</code>: The current status of the configuration. Valid values include the following:</p>
        /// <ul>
        /// <li> <p> <code>CREATING</code>: Resolver is creating an association between an Amazon VPC and a query logging configuration.</p> </li>
        /// <li> <p> <code>CREATED</code>: The association between an Amazon VPC and a query logging configuration was successfully created. Resolver is logging queries that originate in the specified VPC.</p> </li>
        /// <li> <p> <code>DELETING</code>: Resolver is deleting this query logging association.</p> </li>
        /// <li> <p> <code>FAILED</code>: Resolver either couldn't create or couldn't delete the query logging association. Here are two common causes:</p>
        /// <ul>
        /// <li> <p>The specified destination (for example, an Amazon S3 bucket) was deleted.</p> </li>
        /// <li> <p>Permissions don't allow sending logs to the destination.</p> </li>
        /// </ul> </li>
        /// </ul> </li>
        /// </ul>
        pub fn set_sort_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>If you specified a value for <code>SortBy</code>, the order that you want query logging associations to be listed in, <code>ASCENDING</code> or <code>DESCENDING</code>.</p> <note>
        /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigAssociations</code> request and specify the <code>NextToken</code> parameter, you must use the same value for <code>SortOrder</code>, if any, as in the previous request.</p>
        /// </note>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.inner = self.inner.sort_order(input);
            self
        }
        /// <p>If you specified a value for <code>SortBy</code>, the order that you want query logging associations to be listed in, <code>ASCENDING</code> or <code>DESCENDING</code>.</p> <note>
        /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigAssociations</code> request and specify the <code>NextToken</code> parameter, you must use the same value for <code>SortOrder</code>, if any, as in the previous request.</p>
        /// </note>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResolverQueryLogConfigs`.
    ///
    /// <p>Lists information about the specified query logging configurations. Each configuration defines where you want Resolver to save DNS query logs and specifies the VPCs that you want to log queries for.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListResolverQueryLogConfigs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_resolver_query_log_configs_input::Builder,
    }
    impl ListResolverQueryLogConfigs {
        /// Creates a new `ListResolverQueryLogConfigs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResolverQueryLogConfigsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResolverQueryLogConfigsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListResolverQueryLogConfigsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListResolverQueryLogConfigsPaginator {
            crate::paginator::ListResolverQueryLogConfigsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of query logging configurations that you want to return in the response to a <code>ListResolverQueryLogConfigs</code> request. If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 query logging configurations. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of query logging configurations that you want to return in the response to a <code>ListResolverQueryLogConfigs</code> request. If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 query logging configurations. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>For the first <code>ListResolverQueryLogConfigs</code> request, omit this value.</p>
        /// <p>If there are more than <code>MaxResults</code> query logging configurations that match the values that you specify for <code>Filters</code>, you can submit another <code>ListResolverQueryLogConfigs</code> request to get the next group of configurations. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>For the first <code>ListResolverQueryLogConfigs</code> request, omit this value.</p>
        /// <p>If there are more than <code>MaxResults</code> query logging configurations that match the values that you specify for <code>Filters</code>, you can submit another <code>ListResolverQueryLogConfigs</code> request to get the next group of configurations. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An optional specification to return a subset of query logging configurations.</p> <note>
        /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the <code>NextToken</code> parameter, you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>
        /// </note>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>An optional specification to return a subset of query logging configurations.</p> <note>
        /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the <code>NextToken</code> parameter, you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>
        /// </note>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The element that you want Resolver to sort query logging configurations by. </p> <note>
        /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the <code>NextToken</code> parameter, you must use the same value for <code>SortBy</code>, if any, as in the previous request.</p>
        /// </note>
        /// <p>Valid values include the following elements:</p>
        /// <ul>
        /// <li> <p> <code>Arn</code>: The ARN of the query logging configuration</p> </li>
        /// <li> <p> <code>AssociationCount</code>: The number of VPCs that are associated with the specified configuration </p> </li>
        /// <li> <p> <code>CreationTime</code>: The date and time that Resolver returned when the configuration was created</p> </li>
        /// <li> <p> <code>CreatorRequestId</code>: The value that was specified for <code>CreatorRequestId</code> when the configuration was created</p> </li>
        /// <li> <p> <code>DestinationArn</code>: The location that logs are sent to</p> </li>
        /// <li> <p> <code>Id</code>: The ID of the configuration</p> </li>
        /// <li> <p> <code>Name</code>: The name of the configuration</p> </li>
        /// <li> <p> <code>OwnerId</code>: The Amazon Web Services account number of the account that created the configuration</p> </li>
        /// <li> <p> <code>ShareStatus</code>: Whether the configuration is shared with other Amazon Web Services accounts or shared with the current account by another Amazon Web Services account. Sharing is configured through Resource Access Manager (RAM).</p> </li>
        /// <li> <p> <code>Status</code>: The current status of the configuration. Valid values include the following:</p>
        /// <ul>
        /// <li> <p> <code>CREATING</code>: Resolver is creating the query logging configuration.</p> </li>
        /// <li> <p> <code>CREATED</code>: The query logging configuration was successfully created. Resolver is logging queries that originate in the specified VPC.</p> </li>
        /// <li> <p> <code>DELETING</code>: Resolver is deleting this query logging configuration.</p> </li>
        /// <li> <p> <code>FAILED</code>: Resolver either couldn't create or couldn't delete the query logging configuration. Here are two common causes:</p>
        /// <ul>
        /// <li> <p>The specified destination (for example, an Amazon S3 bucket) was deleted.</p> </li>
        /// <li> <p>Permissions don't allow sending logs to the destination.</p> </li>
        /// </ul> </li>
        /// </ul> </li>
        /// </ul>
        pub fn sort_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sort_by(input.into());
            self
        }
        /// <p>The element that you want Resolver to sort query logging configurations by. </p> <note>
        /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the <code>NextToken</code> parameter, you must use the same value for <code>SortBy</code>, if any, as in the previous request.</p>
        /// </note>
        /// <p>Valid values include the following elements:</p>
        /// <ul>
        /// <li> <p> <code>Arn</code>: The ARN of the query logging configuration</p> </li>
        /// <li> <p> <code>AssociationCount</code>: The number of VPCs that are associated with the specified configuration </p> </li>
        /// <li> <p> <code>CreationTime</code>: The date and time that Resolver returned when the configuration was created</p> </li>
        /// <li> <p> <code>CreatorRequestId</code>: The value that was specified for <code>CreatorRequestId</code> when the configuration was created</p> </li>
        /// <li> <p> <code>DestinationArn</code>: The location that logs are sent to</p> </li>
        /// <li> <p> <code>Id</code>: The ID of the configuration</p> </li>
        /// <li> <p> <code>Name</code>: The name of the configuration</p> </li>
        /// <li> <p> <code>OwnerId</code>: The Amazon Web Services account number of the account that created the configuration</p> </li>
        /// <li> <p> <code>ShareStatus</code>: Whether the configuration is shared with other Amazon Web Services accounts or shared with the current account by another Amazon Web Services account. Sharing is configured through Resource Access Manager (RAM).</p> </li>
        /// <li> <p> <code>Status</code>: The current status of the configuration. Valid values include the following:</p>
        /// <ul>
        /// <li> <p> <code>CREATING</code>: Resolver is creating the query logging configuration.</p> </li>
        /// <li> <p> <code>CREATED</code>: The query logging configuration was successfully created. Resolver is logging queries that originate in the specified VPC.</p> </li>
        /// <li> <p> <code>DELETING</code>: Resolver is deleting this query logging configuration.</p> </li>
        /// <li> <p> <code>FAILED</code>: Resolver either couldn't create or couldn't delete the query logging configuration. Here are two common causes:</p>
        /// <ul>
        /// <li> <p>The specified destination (for example, an Amazon S3 bucket) was deleted.</p> </li>
        /// <li> <p>Permissions don't allow sending logs to the destination.</p> </li>
        /// </ul> </li>
        /// </ul> </li>
        /// </ul>
        pub fn set_sort_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>If you specified a value for <code>SortBy</code>, the order that you want query logging configurations to be listed in, <code>ASCENDING</code> or <code>DESCENDING</code>.</p> <note>
        /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the <code>NextToken</code> parameter, you must use the same value for <code>SortOrder</code>, if any, as in the previous request.</p>
        /// </note>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.inner = self.inner.sort_order(input);
            self
        }
        /// <p>If you specified a value for <code>SortBy</code>, the order that you want query logging configurations to be listed in, <code>ASCENDING</code> or <code>DESCENDING</code>.</p> <note>
        /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the <code>NextToken</code> parameter, you must use the same value for <code>SortOrder</code>, if any, as in the previous request.</p>
        /// </note>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResolverRuleAssociations`.
    ///
    /// <p>Lists the associations that were created between Resolver rules and VPCs using the current Amazon Web Services account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListResolverRuleAssociations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_resolver_rule_associations_input::Builder,
    }
    impl ListResolverRuleAssociations {
        /// Creates a new `ListResolverRuleAssociations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResolverRuleAssociationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResolverRuleAssociationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListResolverRuleAssociationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListResolverRuleAssociationsPaginator {
            crate::paginator::ListResolverRuleAssociationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of rule associations that you want to return in the response to a <code>ListResolverRuleAssociations</code> request. If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 rule associations. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of rule associations that you want to return in the response to a <code>ListResolverRuleAssociations</code> request. If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 rule associations. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>For the first <code>ListResolverRuleAssociation</code> request, omit this value.</p>
        /// <p>If you have more than <code>MaxResults</code> rule associations, you can submit another <code>ListResolverRuleAssociation</code> request to get the next group of rule associations. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>For the first <code>ListResolverRuleAssociation</code> request, omit this value.</p>
        /// <p>If you have more than <code>MaxResults</code> rule associations, you can submit another <code>ListResolverRuleAssociation</code> request to get the next group of rule associations. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An optional specification to return a subset of Resolver rules, such as Resolver rules that are associated with the same VPC ID.</p> <note>
        /// <p>If you submit a second or subsequent <code>ListResolverRuleAssociations</code> request and specify the <code>NextToken</code> parameter, you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>
        /// </note>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>An optional specification to return a subset of Resolver rules, such as Resolver rules that are associated with the same VPC ID.</p> <note>
        /// <p>If you submit a second or subsequent <code>ListResolverRuleAssociations</code> request and specify the <code>NextToken</code> parameter, you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>
        /// </note>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResolverRules`.
    ///
    /// <p>Lists the Resolver rules that were created using the current Amazon Web Services account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListResolverRules {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_resolver_rules_input::Builder,
    }
    impl ListResolverRules {
        /// Creates a new `ListResolverRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResolverRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResolverRulesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListResolverRulesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListResolverRulesPaginator {
            crate::paginator::ListResolverRulesPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of Resolver rules that you want to return in the response to a <code>ListResolverRules</code> request. If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 Resolver rules.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of Resolver rules that you want to return in the response to a <code>ListResolverRules</code> request. If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 Resolver rules.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>For the first <code>ListResolverRules</code> request, omit this value.</p>
        /// <p>If you have more than <code>MaxResults</code> Resolver rules, you can submit another <code>ListResolverRules</code> request to get the next group of Resolver rules. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>For the first <code>ListResolverRules</code> request, omit this value.</p>
        /// <p>If you have more than <code>MaxResults</code> Resolver rules, you can submit another <code>ListResolverRules</code> request to get the next group of Resolver rules. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An optional specification to return a subset of Resolver rules, such as all Resolver rules that are associated with the same Resolver endpoint.</p> <note>
        /// <p>If you submit a second or subsequent <code>ListResolverRules</code> request and specify the <code>NextToken</code> parameter, you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>
        /// </note>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>An optional specification to return a subset of Resolver rules, such as all Resolver rules that are associated with the same Resolver endpoint.</p> <note>
        /// <p>If you submit a second or subsequent <code>ListResolverRules</code> request and specify the <code>NextToken</code> parameter, you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>
        /// </note>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags that you associated with the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTagsForResourcePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTagsForResourcePaginator {
            crate::paginator::ListTagsForResourcePaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) for the resource that you want to list tags for.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the resource that you want to list tags for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The maximum number of tags that you want to return in the response to a <code>ListTagsForResource</code> request. If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 tags.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of tags that you want to return in the response to a <code>ListTagsForResource</code> request. If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 tags.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>For the first <code>ListTagsForResource</code> request, omit this value.</p>
        /// <p>If you have more than <code>MaxResults</code> tags, you can submit another <code>ListTagsForResource</code> request to get the next group of tags for the resource. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>For the first <code>ListTagsForResource</code> request, omit this value.</p>
        /// <p>If you have more than <code>MaxResults</code> tags, you can submit another <code>ListTagsForResource</code> request to get the next group of tags for the resource. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutFirewallRuleGroupPolicy`.
    ///
    /// <p>Attaches an Identity and Access Management (Amazon Web Services IAM) policy for sharing the rule group. You can use the policy to share the rule group using Resource Access Manager (RAM). </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutFirewallRuleGroupPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_firewall_rule_group_policy_input::Builder,
    }
    impl PutFirewallRuleGroupPolicy {
        /// Creates a new `PutFirewallRuleGroupPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutFirewallRuleGroupPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutFirewallRuleGroupPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN (Amazon Resource Name) for the rule group that you want to share.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The ARN (Amazon Resource Name) for the rule group that you want to share.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>The Identity and Access Management (Amazon Web Services IAM) policy to attach to the rule group.</p>
        pub fn firewall_rule_group_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_rule_group_policy(input.into());
            self
        }
        /// <p>The Identity and Access Management (Amazon Web Services IAM) policy to attach to the rule group.</p>
        pub fn set_firewall_rule_group_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_rule_group_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutResolverQueryLogConfigPolicy`.
    ///
    /// <p>Specifies an Amazon Web Services account that you want to share a query logging configuration with, the query logging configuration that you want to share, and the operations that you want the account to be able to perform on the configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutResolverQueryLogConfigPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_resolver_query_log_config_policy_input::Builder,
    }
    impl PutResolverQueryLogConfigPolicy {
        /// Creates a new `PutResolverQueryLogConfigPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutResolverQueryLogConfigPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutResolverQueryLogConfigPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the account that you want to share rules with.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the account that you want to share rules with.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>An Identity and Access Management policy statement that lists the query logging configurations that you want to share with another Amazon Web Services account and the operations that you want the account to be able to perform. You can specify the following operations in the <code>Actions</code> section of the statement:</p>
        /// <ul>
        /// <li> <p> <code>route53resolver:AssociateResolverQueryLogConfig</code> </p> </li>
        /// <li> <p> <code>route53resolver:DisassociateResolverQueryLogConfig</code> </p> </li>
        /// <li> <p> <code>route53resolver:ListResolverQueryLogConfigAssociations</code> </p> </li>
        /// <li> <p> <code>route53resolver:ListResolverQueryLogConfigs</code> </p> </li>
        /// </ul>
        /// <p>In the <code>Resource</code> section of the statement, you specify the ARNs for the query logging configurations that you want to share with the account that you specified in <code>Arn</code>. </p>
        pub fn resolver_query_log_config_policy(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.resolver_query_log_config_policy(input.into());
            self
        }
        /// <p>An Identity and Access Management policy statement that lists the query logging configurations that you want to share with another Amazon Web Services account and the operations that you want the account to be able to perform. You can specify the following operations in the <code>Actions</code> section of the statement:</p>
        /// <ul>
        /// <li> <p> <code>route53resolver:AssociateResolverQueryLogConfig</code> </p> </li>
        /// <li> <p> <code>route53resolver:DisassociateResolverQueryLogConfig</code> </p> </li>
        /// <li> <p> <code>route53resolver:ListResolverQueryLogConfigAssociations</code> </p> </li>
        /// <li> <p> <code>route53resolver:ListResolverQueryLogConfigs</code> </p> </li>
        /// </ul>
        /// <p>In the <code>Resource</code> section of the statement, you specify the ARNs for the query logging configurations that you want to share with the account that you specified in <code>Arn</code>. </p>
        pub fn set_resolver_query_log_config_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolver_query_log_config_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutResolverRulePolicy`.
    ///
    /// <p>Specifies an Amazon Web Services rule that you want to share with another account, the account that you want to share the rule with, and the operations that you want the account to be able to perform on the rule.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutResolverRulePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_resolver_rule_policy_input::Builder,
    }
    impl PutResolverRulePolicy {
        /// Creates a new `PutResolverRulePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutResolverRulePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutResolverRulePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the rule that you want to share with another account.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the rule that you want to share with another account.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>An Identity and Access Management policy statement that lists the rules that you want to share with another Amazon Web Services account and the operations that you want the account to be able to perform. You can specify the following operations in the <code>Action</code> section of the statement:</p>
        /// <ul>
        /// <li> <p> <code>route53resolver:GetResolverRule</code> </p> </li>
        /// <li> <p> <code>route53resolver:AssociateResolverRule</code> </p> </li>
        /// <li> <p> <code>route53resolver:DisassociateResolverRule</code> </p> </li>
        /// <li> <p> <code>route53resolver:ListResolverRules</code> </p> </li>
        /// <li> <p> <code>route53resolver:ListResolverRuleAssociations</code> </p> </li>
        /// </ul>
        /// <p>In the <code>Resource</code> section of the statement, specify the ARN for the rule that you want to share with another account. Specify the same ARN that you specified in <code>Arn</code>.</p>
        pub fn resolver_rule_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolver_rule_policy(input.into());
            self
        }
        /// <p>An Identity and Access Management policy statement that lists the rules that you want to share with another Amazon Web Services account and the operations that you want the account to be able to perform. You can specify the following operations in the <code>Action</code> section of the statement:</p>
        /// <ul>
        /// <li> <p> <code>route53resolver:GetResolverRule</code> </p> </li>
        /// <li> <p> <code>route53resolver:AssociateResolverRule</code> </p> </li>
        /// <li> <p> <code>route53resolver:DisassociateResolverRule</code> </p> </li>
        /// <li> <p> <code>route53resolver:ListResolverRules</code> </p> </li>
        /// <li> <p> <code>route53resolver:ListResolverRuleAssociations</code> </p> </li>
        /// </ul>
        /// <p>In the <code>Resource</code> section of the statement, specify the ARN for the rule that you want to share with another account. Specify the same ARN that you specified in <code>Arn</code>.</p>
        pub fn set_resolver_rule_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolver_rule_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds one or more tags to a specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the resource that you want to add tags to. To get the ARN for a resource, use the applicable <code>Get</code> or <code>List</code> command: </p>
        /// <ul>
        /// <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html">GetResolverEndpoint</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRule.html">GetResolverRule</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRuleAssociation.html">GetResolverRuleAssociation</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html">ListResolverEndpoints</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html">ListResolverRuleAssociations</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html">ListResolverRules</a> </p> </li>
        /// </ul>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the resource that you want to add tags to. To get the ARN for a resource, use the applicable <code>Get</code> or <code>List</code> command: </p>
        /// <ul>
        /// <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html">GetResolverEndpoint</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRule.html">GetResolverRule</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRuleAssociation.html">GetResolverRuleAssociation</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html">ListResolverEndpoints</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html">ListResolverRuleAssociations</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html">ListResolverRules</a> </p> </li>
        /// </ul>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags that you want to add to the specified resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags that you want to add to the specified resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes one or more tags from a specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the resource that you want to remove tags from. To get the ARN for a resource, use the applicable <code>Get</code> or <code>List</code> command: </p>
        /// <ul>
        /// <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html">GetResolverEndpoint</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRule.html">GetResolverRule</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRuleAssociation.html">GetResolverRuleAssociation</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html">ListResolverEndpoints</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html">ListResolverRuleAssociations</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html">ListResolverRules</a> </p> </li>
        /// </ul>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the resource that you want to remove tags from. To get the ARN for a resource, use the applicable <code>Get</code> or <code>List</code> command: </p>
        /// <ul>
        /// <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html">GetResolverEndpoint</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRule.html">GetResolverRule</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRuleAssociation.html">GetResolverRuleAssociation</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html">ListResolverEndpoints</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html">ListResolverRuleAssociations</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html">ListResolverRules</a> </p> </li>
        /// </ul>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tags that you want to remove to the specified resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tags that you want to remove to the specified resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFirewallConfig`.
    ///
    /// <p>Updates the configuration of the firewall behavior provided by DNS Firewall for a single VPC from Amazon Virtual Private Cloud (Amazon VPC). </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFirewallConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_firewall_config_input::Builder,
    }
    impl UpdateFirewallConfig {
        /// Creates a new `UpdateFirewallConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFirewallConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFirewallConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the VPC that the configuration is for.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The ID of the VPC that the configuration is for.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>Determines how Route 53 Resolver handles queries during failures, for example when all traffic that is sent to DNS Firewall fails to receive a reply. </p>
        /// <ul>
        /// <li> <p>By default, fail open is disabled, which means the failure mode is closed. This approach favors security over availability. DNS Firewall blocks queries that it is unable to evaluate properly. </p> </li>
        /// <li> <p>If you enable this option, the failure mode is open. This approach favors availability over security. DNS Firewall allows queries to proceed if it is unable to properly evaluate them. </p> </li>
        /// </ul>
        /// <p>This behavior is only enforced for VPCs that have at least one DNS Firewall rule group association. </p>
        pub fn firewall_fail_open(mut self, input: crate::model::FirewallFailOpenStatus) -> Self {
            self.inner = self.inner.firewall_fail_open(input);
            self
        }
        /// <p>Determines how Route 53 Resolver handles queries during failures, for example when all traffic that is sent to DNS Firewall fails to receive a reply. </p>
        /// <ul>
        /// <li> <p>By default, fail open is disabled, which means the failure mode is closed. This approach favors security over availability. DNS Firewall blocks queries that it is unable to evaluate properly. </p> </li>
        /// <li> <p>If you enable this option, the failure mode is open. This approach favors availability over security. DNS Firewall allows queries to proceed if it is unable to properly evaluate them. </p> </li>
        /// </ul>
        /// <p>This behavior is only enforced for VPCs that have at least one DNS Firewall rule group association. </p>
        pub fn set_firewall_fail_open(
            mut self,
            input: std::option::Option<crate::model::FirewallFailOpenStatus>,
        ) -> Self {
            self.inner = self.inner.set_firewall_fail_open(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFirewallDomains`.
    ///
    /// <p>Updates the firewall domain list from an array of domain specifications. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFirewallDomains {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_firewall_domains_input::Builder,
    }
    impl UpdateFirewallDomains {
        /// Creates a new `UpdateFirewallDomains`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFirewallDomainsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFirewallDomainsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the domain list whose domains you want to update. </p>
        pub fn firewall_domain_list_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_domain_list_id(input.into());
            self
        }
        /// <p>The ID of the domain list whose domains you want to update. </p>
        pub fn set_firewall_domain_list_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_domain_list_id(input);
            self
        }
        /// <p>What you want DNS Firewall to do with the domains that you are providing: </p>
        /// <ul>
        /// <li> <p> <code>ADD</code> - Add the domains to the ones that are already in the domain list. </p> </li>
        /// <li> <p> <code>REMOVE</code> - Search the domain list for the domains and remove them from the list.</p> </li>
        /// <li> <p> <code>REPLACE</code> - Update the domain list to exactly match the list that you are providing. </p> </li>
        /// </ul>
        pub fn operation(mut self, input: crate::model::FirewallDomainUpdateOperation) -> Self {
            self.inner = self.inner.operation(input);
            self
        }
        /// <p>What you want DNS Firewall to do with the domains that you are providing: </p>
        /// <ul>
        /// <li> <p> <code>ADD</code> - Add the domains to the ones that are already in the domain list. </p> </li>
        /// <li> <p> <code>REMOVE</code> - Search the domain list for the domains and remove them from the list.</p> </li>
        /// <li> <p> <code>REPLACE</code> - Update the domain list to exactly match the list that you are providing. </p> </li>
        /// </ul>
        pub fn set_operation(
            mut self,
            input: std::option::Option<crate::model::FirewallDomainUpdateOperation>,
        ) -> Self {
            self.inner = self.inner.set_operation(input);
            self
        }
        /// Appends an item to `Domains`.
        ///
        /// To override the contents of this collection use [`set_domains`](Self::set_domains).
        ///
        /// <p>A list of domains to use in the update operation.</p>
        /// <p>Each domain specification in your domain list must satisfy the following requirements: </p>
        /// <ul>
        /// <li> <p>It can optionally start with <code>*</code> (asterisk).</p> </li>
        /// <li> <p>With the exception of the optional starting asterisk, it must only contain the following characters: <code>A-Z</code>, <code>a-z</code>, <code>0-9</code>, <code>-</code> (hyphen).</p> </li>
        /// <li> <p>It must be from 1-255 characters in length. </p> </li>
        /// </ul>
        pub fn domains(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domains(input.into());
            self
        }
        /// <p>A list of domains to use in the update operation.</p>
        /// <p>Each domain specification in your domain list must satisfy the following requirements: </p>
        /// <ul>
        /// <li> <p>It can optionally start with <code>*</code> (asterisk).</p> </li>
        /// <li> <p>With the exception of the optional starting asterisk, it must only contain the following characters: <code>A-Z</code>, <code>a-z</code>, <code>0-9</code>, <code>-</code> (hyphen).</p> </li>
        /// <li> <p>It must be from 1-255 characters in length. </p> </li>
        /// </ul>
        pub fn set_domains(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_domains(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFirewallRule`.
    ///
    /// <p>Updates the specified firewall rule. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFirewallRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_firewall_rule_input::Builder,
    }
    impl UpdateFirewallRule {
        /// Creates a new `UpdateFirewallRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFirewallRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFirewallRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the firewall rule group for the rule. </p>
        pub fn firewall_rule_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_rule_group_id(input.into());
            self
        }
        /// <p>The unique identifier of the firewall rule group for the rule. </p>
        pub fn set_firewall_rule_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_rule_group_id(input);
            self
        }
        /// <p>The ID of the domain list to use in the rule. </p>
        pub fn firewall_domain_list_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_domain_list_id(input.into());
            self
        }
        /// <p>The ID of the domain list to use in the rule. </p>
        pub fn set_firewall_domain_list_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_domain_list_id(input);
            self
        }
        /// <p>The setting that determines the processing order of the rule in the rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.</p>
        /// <p>You must specify a unique priority for each rule in a rule group. To make it easier to insert rules later, leave space between the numbers, for example, use 100, 200, and so on. You can change the priority setting for the rules in a rule group at any time.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.inner = self.inner.priority(input);
            self
        }
        /// <p>The setting that determines the processing order of the rule in the rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.</p>
        /// <p>You must specify a unique priority for each rule in a rule group. To make it easier to insert rules later, leave space between the numbers, for example, use 100, 200, and so on. You can change the priority setting for the rules in a rule group at any time.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_priority(input);
            self
        }
        /// <p>The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list:</p>
        /// <ul>
        /// <li> <p> <code>ALLOW</code> - Permit the request to go through.</p> </li>
        /// <li> <p> <code>ALERT</code> - Permit the request to go through but send an alert to the logs.</p> </li>
        /// <li> <p> <code>BLOCK</code> - Disallow the request. This option requires additional details in the rule's <code>BlockResponse</code>. </p> </li>
        /// </ul>
        pub fn action(mut self, input: crate::model::Action) -> Self {
            self.inner = self.inner.action(input);
            self
        }
        /// <p>The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list:</p>
        /// <ul>
        /// <li> <p> <code>ALLOW</code> - Permit the request to go through.</p> </li>
        /// <li> <p> <code>ALERT</code> - Permit the request to go through but send an alert to the logs.</p> </li>
        /// <li> <p> <code>BLOCK</code> - Disallow the request. This option requires additional details in the rule's <code>BlockResponse</code>. </p> </li>
        /// </ul>
        pub fn set_action(mut self, input: std::option::Option<crate::model::Action>) -> Self {
            self.inner = self.inner.set_action(input);
            self
        }
        /// <p>The way that you want DNS Firewall to block the request. Used for the rule action setting <code>BLOCK</code>.</p>
        /// <ul>
        /// <li> <p> <code>NODATA</code> - Respond indicating that the query was successful, but no response is available for it.</p> </li>
        /// <li> <p> <code>NXDOMAIN</code> - Respond indicating that the domain name that's in the query doesn't exist.</p> </li>
        /// <li> <p> <code>OVERRIDE</code> - Provide a custom override in the response. This option requires custom handling details in the rule's <code>BlockOverride*</code> settings. </p> </li>
        /// </ul>
        pub fn block_response(mut self, input: crate::model::BlockResponse) -> Self {
            self.inner = self.inner.block_response(input);
            self
        }
        /// <p>The way that you want DNS Firewall to block the request. Used for the rule action setting <code>BLOCK</code>.</p>
        /// <ul>
        /// <li> <p> <code>NODATA</code> - Respond indicating that the query was successful, but no response is available for it.</p> </li>
        /// <li> <p> <code>NXDOMAIN</code> - Respond indicating that the domain name that's in the query doesn't exist.</p> </li>
        /// <li> <p> <code>OVERRIDE</code> - Provide a custom override in the response. This option requires custom handling details in the rule's <code>BlockOverride*</code> settings. </p> </li>
        /// </ul>
        pub fn set_block_response(
            mut self,
            input: std::option::Option<crate::model::BlockResponse>,
        ) -> Self {
            self.inner = self.inner.set_block_response(input);
            self
        }
        /// <p>The custom DNS record to send back in response to the query. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
        pub fn block_override_domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.block_override_domain(input.into());
            self
        }
        /// <p>The custom DNS record to send back in response to the query. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
        pub fn set_block_override_domain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_block_override_domain(input);
            self
        }
        /// <p>The DNS record's type. This determines the format of the record value that you provided in <code>BlockOverrideDomain</code>. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
        pub fn block_override_dns_type(
            mut self,
            input: crate::model::BlockOverrideDnsType,
        ) -> Self {
            self.inner = self.inner.block_override_dns_type(input);
            self
        }
        /// <p>The DNS record's type. This determines the format of the record value that you provided in <code>BlockOverrideDomain</code>. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
        pub fn set_block_override_dns_type(
            mut self,
            input: std::option::Option<crate::model::BlockOverrideDnsType>,
        ) -> Self {
            self.inner = self.inner.set_block_override_dns_type(input);
            self
        }
        /// <p>The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
        pub fn block_override_ttl(mut self, input: i32) -> Self {
            self.inner = self.inner.block_override_ttl(input);
            self
        }
        /// <p>The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
        pub fn set_block_override_ttl(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_block_override_ttl(input);
            self
        }
        /// <p>The name of the rule.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the rule.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFirewallRuleGroupAssociation`.
    ///
    /// <p>Changes the association of a <code>FirewallRuleGroup</code> with a VPC. The association enables DNS filtering for the VPC. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFirewallRuleGroupAssociation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_firewall_rule_group_association_input::Builder,
    }
    impl UpdateFirewallRuleGroupAssociation {
        /// Creates a new `UpdateFirewallRuleGroupAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFirewallRuleGroupAssociationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateFirewallRuleGroupAssociationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the <code>FirewallRuleGroupAssociation</code>. </p>
        pub fn firewall_rule_group_association_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.firewall_rule_group_association_id(input.into());
            self
        }
        /// <p>The identifier of the <code>FirewallRuleGroupAssociation</code>. </p>
        pub fn set_firewall_rule_group_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_rule_group_association_id(input);
            self
        }
        /// <p>The setting that determines the processing order of the rule group among the rule groups that you associate with the specified VPC. DNS Firewall filters VPC traffic starting from the rule group with the lowest numeric priority setting. </p>
        /// <p>You must specify a unique priority for each rule group that you associate with a single VPC. To make it easier to insert rule groups later, leave space between the numbers, for example, use 100, 200, and so on. You can change the priority setting for a rule group association after you create it.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.inner = self.inner.priority(input);
            self
        }
        /// <p>The setting that determines the processing order of the rule group among the rule groups that you associate with the specified VPC. DNS Firewall filters VPC traffic starting from the rule group with the lowest numeric priority setting. </p>
        /// <p>You must specify a unique priority for each rule group that you associate with a single VPC. To make it easier to insert rule groups later, leave space between the numbers, for example, use 100, 200, and so on. You can change the priority setting for a rule group association after you create it.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_priority(input);
            self
        }
        /// <p>If enabled, this setting disallows modification or removal of the association, to help prevent against accidentally altering DNS firewall protections. </p>
        pub fn mutation_protection(
            mut self,
            input: crate::model::MutationProtectionStatus,
        ) -> Self {
            self.inner = self.inner.mutation_protection(input);
            self
        }
        /// <p>If enabled, this setting disallows modification or removal of the association, to help prevent against accidentally altering DNS firewall protections. </p>
        pub fn set_mutation_protection(
            mut self,
            input: std::option::Option<crate::model::MutationProtectionStatus>,
        ) -> Self {
            self.inner = self.inner.set_mutation_protection(input);
            self
        }
        /// <p>The name of the rule group association.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the rule group association.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateResolverConfig`.
    ///
    /// <p>Updates the behavior configuration of Route 53 Resolver behavior for a single VPC from Amazon Virtual Private Cloud.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateResolverConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_resolver_config_input::Builder,
    }
    impl UpdateResolverConfig {
        /// Creates a new `UpdateResolverConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateResolverConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateResolverConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Resource ID of the Amazon VPC that you want to update the Resolver configuration for.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>Resource ID of the Amazon VPC that you want to update the Resolver configuration for.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>Indicates whether or not the Resolver will create autodefined rules for reverse DNS lookups. This is enabled by default. Disabling this option will also affect EC2-Classic instances using ClassicLink. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the <i>Amazon EC2 guide</i>.</p> <note>
        /// <p>It can take some time for the status change to be completed.</p>
        /// </note>
        /// <p></p>
        pub fn autodefined_reverse_flag(
            mut self,
            input: crate::model::AutodefinedReverseFlag,
        ) -> Self {
            self.inner = self.inner.autodefined_reverse_flag(input);
            self
        }
        /// <p>Indicates whether or not the Resolver will create autodefined rules for reverse DNS lookups. This is enabled by default. Disabling this option will also affect EC2-Classic instances using ClassicLink. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the <i>Amazon EC2 guide</i>.</p> <note>
        /// <p>It can take some time for the status change to be completed.</p>
        /// </note>
        /// <p></p>
        pub fn set_autodefined_reverse_flag(
            mut self,
            input: std::option::Option<crate::model::AutodefinedReverseFlag>,
        ) -> Self {
            self.inner = self.inner.set_autodefined_reverse_flag(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateResolverDnssecConfig`.
    ///
    /// <p>Updates an existing DNSSEC validation configuration. If there is no existing DNSSEC validation configuration, one is created.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateResolverDnssecConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_resolver_dnssec_config_input::Builder,
    }
    impl UpdateResolverDnssecConfig {
        /// Creates a new `UpdateResolverDnssecConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateResolverDnssecConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateResolverDnssecConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the virtual private cloud (VPC) that you're updating the DNSSEC validation status for.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The ID of the virtual private cloud (VPC) that you're updating the DNSSEC validation status for.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The new value that you are specifying for DNSSEC validation for the VPC. The value can be <code>ENABLE</code> or <code>DISABLE</code>. Be aware that it can take time for a validation status change to be completed.</p>
        pub fn validation(mut self, input: crate::model::Validation) -> Self {
            self.inner = self.inner.validation(input);
            self
        }
        /// <p>The new value that you are specifying for DNSSEC validation for the VPC. The value can be <code>ENABLE</code> or <code>DISABLE</code>. Be aware that it can take time for a validation status change to be completed.</p>
        pub fn set_validation(
            mut self,
            input: std::option::Option<crate::model::Validation>,
        ) -> Self {
            self.inner = self.inner.set_validation(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateResolverEndpoint`.
    ///
    /// <p>Updates the name of an inbound or an outbound Resolver endpoint. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateResolverEndpoint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_resolver_endpoint_input::Builder,
    }
    impl UpdateResolverEndpoint {
        /// Creates a new `UpdateResolverEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateResolverEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateResolverEndpointError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Resolver endpoint that you want to update.</p>
        pub fn resolver_endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolver_endpoint_id(input.into());
            self
        }
        /// <p>The ID of the Resolver endpoint that you want to update.</p>
        pub fn set_resolver_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolver_endpoint_id(input);
            self
        }
        /// <p>The name of the Resolver endpoint that you want to update.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the Resolver endpoint that you want to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateResolverRule`.
    ///
    /// <p>Updates settings for a specified Resolver rule. <code>ResolverRuleId</code> is required, and all other parameters are optional. If you don't specify a parameter, it retains its current value.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateResolverRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_resolver_rule_input::Builder,
    }
    impl UpdateResolverRule {
        /// Creates a new `UpdateResolverRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateResolverRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateResolverRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Resolver rule that you want to update.</p>
        pub fn resolver_rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolver_rule_id(input.into());
            self
        }
        /// <p>The ID of the Resolver rule that you want to update.</p>
        pub fn set_resolver_rule_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolver_rule_id(input);
            self
        }
        /// <p>The new settings for the Resolver rule.</p>
        pub fn config(mut self, input: crate::model::ResolverRuleConfig) -> Self {
            self.inner = self.inner.config(input);
            self
        }
        /// <p>The new settings for the Resolver rule.</p>
        pub fn set_config(
            mut self,
            input: std::option::Option<crate::model::ResolverRuleConfig>,
        ) -> Self {
            self.inner = self.inner.set_config(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
