// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AssociateFirewallRuleGroupInput`](crate::input::AssociateFirewallRuleGroupInput)
pub mod associate_firewall_rule_group_input {
    /// A builder for [`AssociateFirewallRuleGroupInput`](crate::input::AssociateFirewallRuleGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) creator_request_id: std::option::Option<std::string::String>,
        pub(crate) firewall_rule_group_id: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) priority: std::option::Option<i32>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) mutation_protection: std::option::Option<crate::model::MutationProtectionStatus>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>A unique string that identifies the request and that allows failed requests to be
        /// retried without the risk of running the operation twice. <code>CreatorRequestId</code>
        /// can be any unique string, for example, a date/time stamp. </p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.creator_request_id = Some(input.into());
            self
        }
        /// <p>A unique string that identifies the request and that allows failed requests to be
        /// retried without the risk of running the operation twice. <code>CreatorRequestId</code>
        /// can be any unique string, for example, a date/time stamp. </p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creator_request_id = input;
            self
        }
        /// <p>The unique identifier of the firewall rule group. </p>
        pub fn firewall_rule_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_rule_group_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the firewall rule group. </p>
        pub fn set_firewall_rule_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firewall_rule_group_id = input;
            self
        }
        /// <p>The unique identifier of the VPC that you want to associate with the rule group. </p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the VPC that you want to associate with the rule group. </p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>The setting that determines the processing order of the rule group among the rule
        /// groups that you associate with the specified VPC. DNS Firewall filters VPC traffic
        /// starting from the rule group with the lowest numeric priority setting. </p>
        /// <p>You must specify a unique priority for each rule group that you associate with a single VPC.
        /// To make it easier to insert rule groups later, leave space between the numbers, for example, use 101, 200, and so on. You
        /// can change the priority setting for a rule group association after you create it.</p>
        /// <p>The allowed values for <code>Priority</code> are between 100 and 9900.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.priority = Some(input);
            self
        }
        /// <p>The setting that determines the processing order of the rule group among the rule
        /// groups that you associate with the specified VPC. DNS Firewall filters VPC traffic
        /// starting from the rule group with the lowest numeric priority setting. </p>
        /// <p>You must specify a unique priority for each rule group that you associate with a single VPC.
        /// To make it easier to insert rule groups later, leave space between the numbers, for example, use 101, 200, and so on. You
        /// can change the priority setting for a rule group association after you create it.</p>
        /// <p>The allowed values for <code>Priority</code> are between 100 and 9900.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.priority = input;
            self
        }
        /// <p>A name that lets you identify the association, to manage and use it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A name that lets you identify the association, to manage and use it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>If enabled, this setting disallows modification or removal of the association, to help prevent against accidentally altering DNS firewall protections.
        /// When you create the association, the default setting is <code>DISABLED</code>. </p>
        pub fn mutation_protection(
            mut self,
            input: crate::model::MutationProtectionStatus,
        ) -> Self {
            self.mutation_protection = Some(input);
            self
        }
        /// <p>If enabled, this setting disallows modification or removal of the association, to help prevent against accidentally altering DNS firewall protections.
        /// When you create the association, the default setting is <code>DISABLED</code>. </p>
        pub fn set_mutation_protection(
            mut self,
            input: std::option::Option<crate::model::MutationProtectionStatus>,
        ) -> Self {
            self.mutation_protection = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of the tag keys and values that you want to associate with the rule group association. </p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of the tag keys and values that you want to associate with the rule group association. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateFirewallRuleGroupInput`](crate::input::AssociateFirewallRuleGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateFirewallRuleGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateFirewallRuleGroupInput {
                creator_request_id: self.creator_request_id,
                firewall_rule_group_id: self.firewall_rule_group_id,
                vpc_id: self.vpc_id,
                priority: self.priority,
                name: self.name,
                mutation_protection: self.mutation_protection,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateFirewallRuleGroupInputOperationOutputAlias =
    crate::operation::AssociateFirewallRuleGroup;
#[doc(hidden)]
pub type AssociateFirewallRuleGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AssociateFirewallRuleGroupInput {
    /// Consumes the builder and constructs an Operation<[`AssociateFirewallRuleGroup`](crate::operation::AssociateFirewallRuleGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateFirewallRuleGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateFirewallRuleGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateFirewallRuleGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateFirewallRuleGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.AssociateFirewallRuleGroup",
            );
            Ok(builder)
        }
        if self.creator_request_id.is_none() {
            self.creator_request_id = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_firewall_rule_group(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateFirewallRuleGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateFirewallRuleGroup",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateFirewallRuleGroupInput`](crate::input::AssociateFirewallRuleGroupInput)
    pub fn builder() -> crate::input::associate_firewall_rule_group_input::Builder {
        crate::input::associate_firewall_rule_group_input::Builder::default()
    }
}

/// See [`AssociateResolverEndpointIpAddressInput`](crate::input::AssociateResolverEndpointIpAddressInput)
pub mod associate_resolver_endpoint_ip_address_input {
    /// A builder for [`AssociateResolverEndpointIpAddressInput`](crate::input::AssociateResolverEndpointIpAddressInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resolver_endpoint_id: std::option::Option<std::string::String>,
        pub(crate) ip_address: std::option::Option<crate::model::IpAddressUpdate>,
    }
    impl Builder {
        /// <p>The ID of the Resolver endpoint that you want to associate IP addresses with.</p>
        pub fn resolver_endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resolver_endpoint_id = Some(input.into());
            self
        }
        /// <p>The ID of the Resolver endpoint that you want to associate IP addresses with.</p>
        pub fn set_resolver_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resolver_endpoint_id = input;
            self
        }
        /// <p>Either the IPv4 address that you want to add to a Resolver endpoint or a subnet ID. If you specify a subnet ID,
        /// Resolver chooses an IP address for you from the available IPs in the specified subnet.</p>
        pub fn ip_address(mut self, input: crate::model::IpAddressUpdate) -> Self {
            self.ip_address = Some(input);
            self
        }
        /// <p>Either the IPv4 address that you want to add to a Resolver endpoint or a subnet ID. If you specify a subnet ID,
        /// Resolver chooses an IP address for you from the available IPs in the specified subnet.</p>
        pub fn set_ip_address(
            mut self,
            input: std::option::Option<crate::model::IpAddressUpdate>,
        ) -> Self {
            self.ip_address = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateResolverEndpointIpAddressInput`](crate::input::AssociateResolverEndpointIpAddressInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateResolverEndpointIpAddressInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateResolverEndpointIpAddressInput {
                resolver_endpoint_id: self.resolver_endpoint_id,
                ip_address: self.ip_address,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateResolverEndpointIpAddressInputOperationOutputAlias =
    crate::operation::AssociateResolverEndpointIpAddress;
#[doc(hidden)]
pub type AssociateResolverEndpointIpAddressInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AssociateResolverEndpointIpAddressInput {
    /// Consumes the builder and constructs an Operation<[`AssociateResolverEndpointIpAddress`](crate::operation::AssociateResolverEndpointIpAddress)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateResolverEndpointIpAddress,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateResolverEndpointIpAddressInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateResolverEndpointIpAddressInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateResolverEndpointIpAddressInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.AssociateResolverEndpointIpAddress",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_resolver_endpoint_ip_address(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateResolverEndpointIpAddress::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateResolverEndpointIpAddress",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateResolverEndpointIpAddressInput`](crate::input::AssociateResolverEndpointIpAddressInput)
    pub fn builder() -> crate::input::associate_resolver_endpoint_ip_address_input::Builder {
        crate::input::associate_resolver_endpoint_ip_address_input::Builder::default()
    }
}

/// See [`AssociateResolverQueryLogConfigInput`](crate::input::AssociateResolverQueryLogConfigInput)
pub mod associate_resolver_query_log_config_input {
    /// A builder for [`AssociateResolverQueryLogConfigInput`](crate::input::AssociateResolverQueryLogConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resolver_query_log_config_id: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the query logging configuration that you want to associate a VPC with.</p>
        pub fn resolver_query_log_config_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.resolver_query_log_config_id = Some(input.into());
            self
        }
        /// <p>The ID of the query logging configuration that you want to associate a VPC with.</p>
        pub fn set_resolver_query_log_config_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resolver_query_log_config_id = input;
            self
        }
        /// <p>The ID of an Amazon VPC that you want this query logging configuration to log queries for.</p>
        ///
        /// <note>
        /// <p>The VPCs and the query logging configuration must be in the same Region.</p>
        /// </note>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of an Amazon VPC that you want this query logging configuration to log queries for.</p>
        ///
        /// <note>
        /// <p>The VPCs and the query logging configuration must be in the same Region.</p>
        /// </note>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateResolverQueryLogConfigInput`](crate::input::AssociateResolverQueryLogConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateResolverQueryLogConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateResolverQueryLogConfigInput {
                resolver_query_log_config_id: self.resolver_query_log_config_id,
                resource_id: self.resource_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateResolverQueryLogConfigInputOperationOutputAlias =
    crate::operation::AssociateResolverQueryLogConfig;
#[doc(hidden)]
pub type AssociateResolverQueryLogConfigInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AssociateResolverQueryLogConfigInput {
    /// Consumes the builder and constructs an Operation<[`AssociateResolverQueryLogConfig`](crate::operation::AssociateResolverQueryLogConfig)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateResolverQueryLogConfig,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateResolverQueryLogConfigInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateResolverQueryLogConfigInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateResolverQueryLogConfigInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.AssociateResolverQueryLogConfig",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_resolver_query_log_config(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateResolverQueryLogConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateResolverQueryLogConfig",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateResolverQueryLogConfigInput`](crate::input::AssociateResolverQueryLogConfigInput)
    pub fn builder() -> crate::input::associate_resolver_query_log_config_input::Builder {
        crate::input::associate_resolver_query_log_config_input::Builder::default()
    }
}

/// See [`AssociateResolverRuleInput`](crate::input::AssociateResolverRuleInput)
pub mod associate_resolver_rule_input {
    /// A builder for [`AssociateResolverRuleInput`](crate::input::AssociateResolverRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resolver_rule_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Resolver rule that you want to associate with the VPC. To list the existing Resolver rules, use
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html">ListResolverRules</a>.</p>
        pub fn resolver_rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resolver_rule_id = Some(input.into());
            self
        }
        /// <p>The ID of the Resolver rule that you want to associate with the VPC. To list the existing Resolver rules, use
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html">ListResolverRules</a>.</p>
        pub fn set_resolver_rule_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resolver_rule_id = input;
            self
        }
        /// <p>A name for the association that you're creating between a Resolver rule and a VPC.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A name for the association that you're creating between a Resolver rule and a VPC.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ID of the VPC that you want to associate the Resolver rule with.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC that you want to associate the Resolver rule with.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateResolverRuleInput`](crate::input::AssociateResolverRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateResolverRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateResolverRuleInput {
                resolver_rule_id: self.resolver_rule_id,
                name: self.name,
                vpc_id: self.vpc_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateResolverRuleInputOperationOutputAlias = crate::operation::AssociateResolverRule;
#[doc(hidden)]
pub type AssociateResolverRuleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AssociateResolverRuleInput {
    /// Consumes the builder and constructs an Operation<[`AssociateResolverRule`](crate::operation::AssociateResolverRule)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateResolverRule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateResolverRuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateResolverRuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateResolverRuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.AssociateResolverRule",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_resolver_rule(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateResolverRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateResolverRule",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateResolverRuleInput`](crate::input::AssociateResolverRuleInput)
    pub fn builder() -> crate::input::associate_resolver_rule_input::Builder {
        crate::input::associate_resolver_rule_input::Builder::default()
    }
}

/// See [`CreateFirewallDomainListInput`](crate::input::CreateFirewallDomainListInput)
pub mod create_firewall_domain_list_input {
    /// A builder for [`CreateFirewallDomainListInput`](crate::input::CreateFirewallDomainListInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) creator_request_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>A unique string that identifies the request and that allows you to retry failed requests
        /// without the risk of running the operation twice. <code>CreatorRequestId</code> can be
        /// any unique string, for example, a date/time stamp. </p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.creator_request_id = Some(input.into());
            self
        }
        /// <p>A unique string that identifies the request and that allows you to retry failed requests
        /// without the risk of running the operation twice. <code>CreatorRequestId</code> can be
        /// any unique string, for example, a date/time stamp. </p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creator_request_id = input;
            self
        }
        /// <p>A name that lets you identify the domain list to manage and use it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A name that lets you identify the domain list to manage and use it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of the tag keys and values that you want to associate with the domain list. </p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of the tag keys and values that you want to associate with the domain list. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFirewallDomainListInput`](crate::input::CreateFirewallDomainListInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateFirewallDomainListInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateFirewallDomainListInput {
                creator_request_id: self.creator_request_id,
                name: self.name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateFirewallDomainListInputOperationOutputAlias =
    crate::operation::CreateFirewallDomainList;
#[doc(hidden)]
pub type CreateFirewallDomainListInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateFirewallDomainListInput {
    /// Consumes the builder and constructs an Operation<[`CreateFirewallDomainList`](crate::operation::CreateFirewallDomainList)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateFirewallDomainList,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateFirewallDomainListInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateFirewallDomainListInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateFirewallDomainListInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.CreateFirewallDomainList",
            );
            Ok(builder)
        }
        if self.creator_request_id.is_none() {
            self.creator_request_id = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_firewall_domain_list(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateFirewallDomainList::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateFirewallDomainList",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateFirewallDomainListInput`](crate::input::CreateFirewallDomainListInput)
    pub fn builder() -> crate::input::create_firewall_domain_list_input::Builder {
        crate::input::create_firewall_domain_list_input::Builder::default()
    }
}

/// See [`CreateFirewallRuleInput`](crate::input::CreateFirewallRuleInput)
pub mod create_firewall_rule_input {
    /// A builder for [`CreateFirewallRuleInput`](crate::input::CreateFirewallRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) creator_request_id: std::option::Option<std::string::String>,
        pub(crate) firewall_rule_group_id: std::option::Option<std::string::String>,
        pub(crate) firewall_domain_list_id: std::option::Option<std::string::String>,
        pub(crate) priority: std::option::Option<i32>,
        pub(crate) action: std::option::Option<crate::model::Action>,
        pub(crate) block_response: std::option::Option<crate::model::BlockResponse>,
        pub(crate) block_override_domain: std::option::Option<std::string::String>,
        pub(crate) block_override_dns_type: std::option::Option<crate::model::BlockOverrideDnsType>,
        pub(crate) block_override_ttl: std::option::Option<i32>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique string that identifies the request and that allows you to retry failed requests
        /// without the risk of running the operation twice. <code>CreatorRequestId</code> can be
        /// any unique string, for example, a date/time stamp. </p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.creator_request_id = Some(input.into());
            self
        }
        /// <p>A unique string that identifies the request and that allows you to retry failed requests
        /// without the risk of running the operation twice. <code>CreatorRequestId</code> can be
        /// any unique string, for example, a date/time stamp. </p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creator_request_id = input;
            self
        }
        /// <p>The unique identifier of the firewall rule group where you want to create the rule. </p>
        pub fn firewall_rule_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_rule_group_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the firewall rule group where you want to create the rule. </p>
        pub fn set_firewall_rule_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firewall_rule_group_id = input;
            self
        }
        /// <p>The ID of the domain list that you want to use in the rule. </p>
        pub fn firewall_domain_list_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_domain_list_id = Some(input.into());
            self
        }
        /// <p>The ID of the domain list that you want to use in the rule. </p>
        pub fn set_firewall_domain_list_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firewall_domain_list_id = input;
            self
        }
        /// <p>The setting that determines the processing order of the rule in the rule group. DNS Firewall
        /// processes the rules in a rule group by order of priority, starting from the lowest setting.</p>
        /// <p>You must specify a unique priority for each rule in a rule group.
        /// To make it easier to insert rules later, leave space between the numbers, for example, use 100, 200, and so on. You
        /// can change the priority setting for the rules in a rule group at any time.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.priority = Some(input);
            self
        }
        /// <p>The setting that determines the processing order of the rule in the rule group. DNS Firewall
        /// processes the rules in a rule group by order of priority, starting from the lowest setting.</p>
        /// <p>You must specify a unique priority for each rule in a rule group.
        /// To make it easier to insert rules later, leave space between the numbers, for example, use 100, 200, and so on. You
        /// can change the priority setting for the rules in a rule group at any time.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.priority = input;
            self
        }
        /// <p>The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALLOW</code> - Permit the request to go through.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALERT</code> - Permit the request and send metrics and logs to Cloud Watch.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BLOCK</code> - Disallow the request. This option requires additional details in the rule's <code>BlockResponse</code>. </p>
        /// </li>
        /// </ul>
        pub fn action(mut self, input: crate::model::Action) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALLOW</code> - Permit the request to go through.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALERT</code> - Permit the request and send metrics and logs to Cloud Watch.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BLOCK</code> - Disallow the request. This option requires additional details in the rule's <code>BlockResponse</code>. </p>
        /// </li>
        /// </ul>
        pub fn set_action(mut self, input: std::option::Option<crate::model::Action>) -> Self {
            self.action = input;
            self
        }
        /// <p>The way that you want DNS Firewall to block the request, used with the rule action
        /// setting <code>BLOCK</code>. </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NODATA</code> - Respond indicating that the query was successful, but no response is available for it.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NXDOMAIN</code> - Respond indicating that the domain name that's in the query doesn't exist.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OVERRIDE</code> - Provide a custom override in the response. This option requires custom handling details in the rule's <code>BlockOverride*</code> settings. </p>
        /// </li>
        /// </ul>
        /// <p>This setting is required if the rule action setting is <code>BLOCK</code>.</p>
        pub fn block_response(mut self, input: crate::model::BlockResponse) -> Self {
            self.block_response = Some(input);
            self
        }
        /// <p>The way that you want DNS Firewall to block the request, used with the rule action
        /// setting <code>BLOCK</code>. </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NODATA</code> - Respond indicating that the query was successful, but no response is available for it.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NXDOMAIN</code> - Respond indicating that the domain name that's in the query doesn't exist.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OVERRIDE</code> - Provide a custom override in the response. This option requires custom handling details in the rule's <code>BlockOverride*</code> settings. </p>
        /// </li>
        /// </ul>
        /// <p>This setting is required if the rule action setting is <code>BLOCK</code>.</p>
        pub fn set_block_response(
            mut self,
            input: std::option::Option<crate::model::BlockResponse>,
        ) -> Self {
            self.block_response = input;
            self
        }
        /// <p>The custom DNS record to send back in response to the query. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
        /// <p>This setting is required if the <code>BlockResponse</code> setting is <code>OVERRIDE</code>.</p>
        pub fn block_override_domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.block_override_domain = Some(input.into());
            self
        }
        /// <p>The custom DNS record to send back in response to the query. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
        /// <p>This setting is required if the <code>BlockResponse</code> setting is <code>OVERRIDE</code>.</p>
        pub fn set_block_override_domain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.block_override_domain = input;
            self
        }
        /// <p>The DNS record's type. This determines the format of the record value that you provided in <code>BlockOverrideDomain</code>. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
        /// <p>This setting is required if the <code>BlockResponse</code> setting is <code>OVERRIDE</code>.</p>
        pub fn block_override_dns_type(
            mut self,
            input: crate::model::BlockOverrideDnsType,
        ) -> Self {
            self.block_override_dns_type = Some(input);
            self
        }
        /// <p>The DNS record's type. This determines the format of the record value that you provided in <code>BlockOverrideDomain</code>. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
        /// <p>This setting is required if the <code>BlockResponse</code> setting is <code>OVERRIDE</code>.</p>
        pub fn set_block_override_dns_type(
            mut self,
            input: std::option::Option<crate::model::BlockOverrideDnsType>,
        ) -> Self {
            self.block_override_dns_type = input;
            self
        }
        /// <p>The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
        /// <p>This setting is required if the <code>BlockResponse</code> setting is <code>OVERRIDE</code>.</p>
        pub fn block_override_ttl(mut self, input: i32) -> Self {
            self.block_override_ttl = Some(input);
            self
        }
        /// <p>The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
        /// <p>This setting is required if the <code>BlockResponse</code> setting is <code>OVERRIDE</code>.</p>
        pub fn set_block_override_ttl(mut self, input: std::option::Option<i32>) -> Self {
            self.block_override_ttl = input;
            self
        }
        /// <p>A name that lets you identify the rule in the rule group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A name that lets you identify the rule in the rule group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFirewallRuleInput`](crate::input::CreateFirewallRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateFirewallRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateFirewallRuleInput {
                creator_request_id: self.creator_request_id,
                firewall_rule_group_id: self.firewall_rule_group_id,
                firewall_domain_list_id: self.firewall_domain_list_id,
                priority: self.priority,
                action: self.action,
                block_response: self.block_response,
                block_override_domain: self.block_override_domain,
                block_override_dns_type: self.block_override_dns_type,
                block_override_ttl: self.block_override_ttl,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateFirewallRuleInputOperationOutputAlias = crate::operation::CreateFirewallRule;
#[doc(hidden)]
pub type CreateFirewallRuleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateFirewallRuleInput {
    /// Consumes the builder and constructs an Operation<[`CreateFirewallRule`](crate::operation::CreateFirewallRule)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateFirewallRule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateFirewallRuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateFirewallRuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateFirewallRuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.CreateFirewallRule",
            );
            Ok(builder)
        }
        if self.creator_request_id.is_none() {
            self.creator_request_id = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_firewall_rule(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateFirewallRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateFirewallRule",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateFirewallRuleInput`](crate::input::CreateFirewallRuleInput)
    pub fn builder() -> crate::input::create_firewall_rule_input::Builder {
        crate::input::create_firewall_rule_input::Builder::default()
    }
}

/// See [`CreateFirewallRuleGroupInput`](crate::input::CreateFirewallRuleGroupInput)
pub mod create_firewall_rule_group_input {
    /// A builder for [`CreateFirewallRuleGroupInput`](crate::input::CreateFirewallRuleGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) creator_request_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>A unique string defined by you to identify the request. This allows you to retry failed
        /// requests without the risk of running the operation twice. This can be any unique string,
        /// for example, a timestamp. </p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.creator_request_id = Some(input.into());
            self
        }
        /// <p>A unique string defined by you to identify the request. This allows you to retry failed
        /// requests without the risk of running the operation twice. This can be any unique string,
        /// for example, a timestamp. </p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creator_request_id = input;
            self
        }
        /// <p>A name that lets you identify the rule group, to manage and use it.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A name that lets you identify the rule group, to manage and use it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of the tag keys and values that you want to associate with the rule group. </p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of the tag keys and values that you want to associate with the rule group. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFirewallRuleGroupInput`](crate::input::CreateFirewallRuleGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateFirewallRuleGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateFirewallRuleGroupInput {
                creator_request_id: self.creator_request_id,
                name: self.name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateFirewallRuleGroupInputOperationOutputAlias =
    crate::operation::CreateFirewallRuleGroup;
#[doc(hidden)]
pub type CreateFirewallRuleGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateFirewallRuleGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateFirewallRuleGroup`](crate::operation::CreateFirewallRuleGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateFirewallRuleGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateFirewallRuleGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateFirewallRuleGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateFirewallRuleGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.CreateFirewallRuleGroup",
            );
            Ok(builder)
        }
        if self.creator_request_id.is_none() {
            self.creator_request_id = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_firewall_rule_group(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateFirewallRuleGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateFirewallRuleGroup",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateFirewallRuleGroupInput`](crate::input::CreateFirewallRuleGroupInput)
    pub fn builder() -> crate::input::create_firewall_rule_group_input::Builder {
        crate::input::create_firewall_rule_group_input::Builder::default()
    }
}

/// See [`CreateResolverEndpointInput`](crate::input::CreateResolverEndpointInput)
pub mod create_resolver_endpoint_input {
    /// A builder for [`CreateResolverEndpointInput`](crate::input::CreateResolverEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) creator_request_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) direction: std::option::Option<crate::model::ResolverEndpointDirection>,
        pub(crate) ip_addresses: std::option::Option<std::vec::Vec<crate::model::IpAddressRequest>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>A unique string that identifies the request and that allows failed requests to be retried
        /// without the risk of running the operation twice. <code>CreatorRequestId</code> can be
        /// any unique string, for example, a date/time stamp. </p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.creator_request_id = Some(input.into());
            self
        }
        /// <p>A unique string that identifies the request and that allows failed requests to be retried
        /// without the risk of running the operation twice. <code>CreatorRequestId</code> can be
        /// any unique string, for example, a date/time stamp. </p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creator_request_id = input;
            self
        }
        /// <p>A friendly name that lets you easily find a configuration in the Resolver dashboard in the Route 53 console.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A friendly name that lets you easily find a configuration in the Resolver dashboard in the Route 53 console.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>The ID of one or more security groups that you want to use to control access to this VPC. The security group that you specify
        /// must include one or more inbound rules (for inbound Resolver endpoints) or outbound rules (for outbound Resolver endpoints).
        /// Inbound and outbound rules must allow TCP and UDP access. For inbound access, open port 53. For outbound access, open the port
        /// that you're using for DNS queries on your network.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>The ID of one or more security groups that you want to use to control access to this VPC. The security group that you specify
        /// must include one or more inbound rules (for inbound Resolver endpoints) or outbound rules (for outbound Resolver endpoints).
        /// Inbound and outbound rules must allow TCP and UDP access. For inbound access, open port 53. For outbound access, open the port
        /// that you're using for DNS queries on your network.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// <p>Specify the applicable value:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INBOUND</code>: Resolver forwards DNS queries to the DNS service for a VPC from your network</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OUTBOUND</code>: Resolver forwards DNS queries from the DNS service for a VPC to your network</p>
        /// </li>
        /// </ul>
        pub fn direction(mut self, input: crate::model::ResolverEndpointDirection) -> Self {
            self.direction = Some(input);
            self
        }
        /// <p>Specify the applicable value:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INBOUND</code>: Resolver forwards DNS queries to the DNS service for a VPC from your network</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OUTBOUND</code>: Resolver forwards DNS queries from the DNS service for a VPC to your network</p>
        /// </li>
        /// </ul>
        pub fn set_direction(
            mut self,
            input: std::option::Option<crate::model::ResolverEndpointDirection>,
        ) -> Self {
            self.direction = input;
            self
        }
        /// Appends an item to `ip_addresses`.
        ///
        /// To override the contents of this collection use [`set_ip_addresses`](Self::set_ip_addresses).
        ///
        /// <p>The subnets and IP addresses in your VPC that DNS queries originate from (for outbound endpoints) or that you forward
        /// DNS queries to (for inbound endpoints). The subnet ID uniquely identifies a VPC. </p>
        pub fn ip_addresses(mut self, input: impl Into<crate::model::IpAddressRequest>) -> Self {
            let mut v = self.ip_addresses.unwrap_or_default();
            v.push(input.into());
            self.ip_addresses = Some(v);
            self
        }
        /// <p>The subnets and IP addresses in your VPC that DNS queries originate from (for outbound endpoints) or that you forward
        /// DNS queries to (for inbound endpoints). The subnet ID uniquely identifies a VPC. </p>
        pub fn set_ip_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IpAddressRequest>>,
        ) -> Self {
            self.ip_addresses = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of the tag keys and values that you want to associate with the endpoint.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of the tag keys and values that you want to associate with the endpoint.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateResolverEndpointInput`](crate::input::CreateResolverEndpointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateResolverEndpointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateResolverEndpointInput {
                creator_request_id: self.creator_request_id,
                name: self.name,
                security_group_ids: self.security_group_ids,
                direction: self.direction,
                ip_addresses: self.ip_addresses,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateResolverEndpointInputOperationOutputAlias = crate::operation::CreateResolverEndpoint;
#[doc(hidden)]
pub type CreateResolverEndpointInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateResolverEndpointInput {
    /// Consumes the builder and constructs an Operation<[`CreateResolverEndpoint`](crate::operation::CreateResolverEndpoint)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateResolverEndpoint,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateResolverEndpointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateResolverEndpointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateResolverEndpointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.CreateResolverEndpoint",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_resolver_endpoint(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateResolverEndpoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateResolverEndpoint",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateResolverEndpointInput`](crate::input::CreateResolverEndpointInput)
    pub fn builder() -> crate::input::create_resolver_endpoint_input::Builder {
        crate::input::create_resolver_endpoint_input::Builder::default()
    }
}

/// See [`CreateResolverQueryLogConfigInput`](crate::input::CreateResolverQueryLogConfigInput)
pub mod create_resolver_query_log_config_input {
    /// A builder for [`CreateResolverQueryLogConfigInput`](crate::input::CreateResolverQueryLogConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) destination_arn: std::option::Option<std::string::String>,
        pub(crate) creator_request_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name that you want to give the query logging configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name that you want to give the query logging configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ARN of the resource that you want Resolver to send query logs. You can send query logs to an S3 bucket, a CloudWatch Logs log group,
        /// or a Kinesis Data Firehose delivery stream. Examples of valid values include the following:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <b>S3 bucket</b>: </p>
        /// <p>
        /// <code>arn:aws:s3:::examplebucket</code>
        /// </p>
        /// <p>You can optionally append a file prefix to the end of the ARN.</p>
        /// <p>
        /// <code>arn:aws:s3:::examplebucket/development/</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>CloudWatch Logs log group</b>: </p>
        /// <p>
        /// <code>arn:aws:logs:us-west-1:123456789012:log-group:/mystack-testgroup-12ABC1AB12A1:*</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Kinesis Data Firehose delivery stream</b>:</p>
        /// <p>
        /// <code>arn:aws:kinesis:us-east-2:0123456789:stream/my_stream_name</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn destination_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource that you want Resolver to send query logs. You can send query logs to an S3 bucket, a CloudWatch Logs log group,
        /// or a Kinesis Data Firehose delivery stream. Examples of valid values include the following:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <b>S3 bucket</b>: </p>
        /// <p>
        /// <code>arn:aws:s3:::examplebucket</code>
        /// </p>
        /// <p>You can optionally append a file prefix to the end of the ARN.</p>
        /// <p>
        /// <code>arn:aws:s3:::examplebucket/development/</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>CloudWatch Logs log group</b>: </p>
        /// <p>
        /// <code>arn:aws:logs:us-west-1:123456789012:log-group:/mystack-testgroup-12ABC1AB12A1:*</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Kinesis Data Firehose delivery stream</b>:</p>
        /// <p>
        /// <code>arn:aws:kinesis:us-east-2:0123456789:stream/my_stream_name</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_destination_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_arn = input;
            self
        }
        /// <p>A unique string that identifies the request and that allows failed requests to be retried
        /// without the risk of running the operation twice. <code>CreatorRequestId</code> can be
        /// any unique string, for example, a date/time stamp. </p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.creator_request_id = Some(input.into());
            self
        }
        /// <p>A unique string that identifies the request and that allows failed requests to be retried
        /// without the risk of running the operation twice. <code>CreatorRequestId</code> can be
        /// any unique string, for example, a date/time stamp. </p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creator_request_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of the tag keys and values that you want to associate with the query logging configuration.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of the tag keys and values that you want to associate with the query logging configuration.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateResolverQueryLogConfigInput`](crate::input::CreateResolverQueryLogConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateResolverQueryLogConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateResolverQueryLogConfigInput {
                name: self.name,
                destination_arn: self.destination_arn,
                creator_request_id: self.creator_request_id,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateResolverQueryLogConfigInputOperationOutputAlias =
    crate::operation::CreateResolverQueryLogConfig;
#[doc(hidden)]
pub type CreateResolverQueryLogConfigInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateResolverQueryLogConfigInput {
    /// Consumes the builder and constructs an Operation<[`CreateResolverQueryLogConfig`](crate::operation::CreateResolverQueryLogConfig)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateResolverQueryLogConfig,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateResolverQueryLogConfigInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateResolverQueryLogConfigInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateResolverQueryLogConfigInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.CreateResolverQueryLogConfig",
            );
            Ok(builder)
        }
        if self.creator_request_id.is_none() {
            self.creator_request_id = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_resolver_query_log_config(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateResolverQueryLogConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateResolverQueryLogConfig",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateResolverQueryLogConfigInput`](crate::input::CreateResolverQueryLogConfigInput)
    pub fn builder() -> crate::input::create_resolver_query_log_config_input::Builder {
        crate::input::create_resolver_query_log_config_input::Builder::default()
    }
}

/// See [`CreateResolverRuleInput`](crate::input::CreateResolverRuleInput)
pub mod create_resolver_rule_input {
    /// A builder for [`CreateResolverRuleInput`](crate::input::CreateResolverRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) creator_request_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) rule_type: std::option::Option<crate::model::RuleTypeOption>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) target_ips: std::option::Option<std::vec::Vec<crate::model::TargetAddress>>,
        pub(crate) resolver_endpoint_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>A unique string that identifies the request and that allows failed requests to be retried
        /// without the risk of running the operation twice. <code>CreatorRequestId</code> can be
        /// any unique string, for example, a date/time stamp. </p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.creator_request_id = Some(input.into());
            self
        }
        /// <p>A unique string that identifies the request and that allows failed requests to be retried
        /// without the risk of running the operation twice. <code>CreatorRequestId</code> can be
        /// any unique string, for example, a date/time stamp. </p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creator_request_id = input;
            self
        }
        /// <p>A friendly name that lets you easily find a rule in the Resolver dashboard in the Route 53 console.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A friendly name that lets you easily find a rule in the Resolver dashboard in the Route 53 console.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>When you want to forward DNS queries for specified domain name to resolvers on your network, specify <code>FORWARD</code>.</p>
        /// <p>When you have a forwarding rule to forward DNS queries for a domain to your network and you want Resolver to process queries for
        /// a subdomain of that domain, specify <code>SYSTEM</code>.</p>
        /// <p>For example, to forward DNS queries for example.com to resolvers on your network, you create a rule and specify <code>FORWARD</code>
        /// for <code>RuleType</code>. To then have Resolver process queries for apex.example.com, you create a rule and specify
        /// <code>SYSTEM</code> for <code>RuleType</code>.</p>
        /// <p>Currently, only Resolver can create rules that have a value of <code>RECURSIVE</code> for <code>RuleType</code>.</p>
        pub fn rule_type(mut self, input: crate::model::RuleTypeOption) -> Self {
            self.rule_type = Some(input);
            self
        }
        /// <p>When you want to forward DNS queries for specified domain name to resolvers on your network, specify <code>FORWARD</code>.</p>
        /// <p>When you have a forwarding rule to forward DNS queries for a domain to your network and you want Resolver to process queries for
        /// a subdomain of that domain, specify <code>SYSTEM</code>.</p>
        /// <p>For example, to forward DNS queries for example.com to resolvers on your network, you create a rule and specify <code>FORWARD</code>
        /// for <code>RuleType</code>. To then have Resolver process queries for apex.example.com, you create a rule and specify
        /// <code>SYSTEM</code> for <code>RuleType</code>.</p>
        /// <p>Currently, only Resolver can create rules that have a value of <code>RECURSIVE</code> for <code>RuleType</code>.</p>
        pub fn set_rule_type(
            mut self,
            input: std::option::Option<crate::model::RuleTypeOption>,
        ) -> Self {
            self.rule_type = input;
            self
        }
        /// <p>DNS queries for this domain name are forwarded to the IP addresses that you specify in <code>TargetIps</code>. If a query matches
        /// multiple Resolver rules (example.com and www.example.com), outbound DNS queries are routed using the Resolver rule that contains
        /// the most specific domain name (www.example.com).</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>DNS queries for this domain name are forwarded to the IP addresses that you specify in <code>TargetIps</code>. If a query matches
        /// multiple Resolver rules (example.com and www.example.com), outbound DNS queries are routed using the Resolver rule that contains
        /// the most specific domain name (www.example.com).</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Appends an item to `target_ips`.
        ///
        /// To override the contents of this collection use [`set_target_ips`](Self::set_target_ips).
        ///
        /// <p>The IPs that you want Resolver to forward DNS queries to. You can specify only IPv4 addresses. Separate IP addresses with a space.</p>
        /// <p>
        /// <code>TargetIps</code> is available only when the value of <code>Rule type</code> is <code>FORWARD</code>.</p>
        pub fn target_ips(mut self, input: impl Into<crate::model::TargetAddress>) -> Self {
            let mut v = self.target_ips.unwrap_or_default();
            v.push(input.into());
            self.target_ips = Some(v);
            self
        }
        /// <p>The IPs that you want Resolver to forward DNS queries to. You can specify only IPv4 addresses. Separate IP addresses with a space.</p>
        /// <p>
        /// <code>TargetIps</code> is available only when the value of <code>Rule type</code> is <code>FORWARD</code>.</p>
        pub fn set_target_ips(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetAddress>>,
        ) -> Self {
            self.target_ips = input;
            self
        }
        /// <p>The ID of the outbound Resolver endpoint that you want to use to route DNS queries to the IP addresses that you specify
        /// in <code>TargetIps</code>.</p>
        pub fn resolver_endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resolver_endpoint_id = Some(input.into());
            self
        }
        /// <p>The ID of the outbound Resolver endpoint that you want to use to route DNS queries to the IP addresses that you specify
        /// in <code>TargetIps</code>.</p>
        pub fn set_resolver_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resolver_endpoint_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of the tag keys and values that you want to associate with the endpoint.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of the tag keys and values that you want to associate with the endpoint.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateResolverRuleInput`](crate::input::CreateResolverRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateResolverRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateResolverRuleInput {
                creator_request_id: self.creator_request_id,
                name: self.name,
                rule_type: self.rule_type,
                domain_name: self.domain_name,
                target_ips: self.target_ips,
                resolver_endpoint_id: self.resolver_endpoint_id,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateResolverRuleInputOperationOutputAlias = crate::operation::CreateResolverRule;
#[doc(hidden)]
pub type CreateResolverRuleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateResolverRuleInput {
    /// Consumes the builder and constructs an Operation<[`CreateResolverRule`](crate::operation::CreateResolverRule)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateResolverRule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateResolverRuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateResolverRuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateResolverRuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.CreateResolverRule",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_resolver_rule(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateResolverRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateResolverRule",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateResolverRuleInput`](crate::input::CreateResolverRuleInput)
    pub fn builder() -> crate::input::create_resolver_rule_input::Builder {
        crate::input::create_resolver_rule_input::Builder::default()
    }
}

/// See [`DeleteFirewallDomainListInput`](crate::input::DeleteFirewallDomainListInput)
pub mod delete_firewall_domain_list_input {
    /// A builder for [`DeleteFirewallDomainListInput`](crate::input::DeleteFirewallDomainListInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_domain_list_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the domain list that you want to delete. </p>
        pub fn firewall_domain_list_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_domain_list_id = Some(input.into());
            self
        }
        /// <p>The ID of the domain list that you want to delete. </p>
        pub fn set_firewall_domain_list_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firewall_domain_list_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFirewallDomainListInput`](crate::input::DeleteFirewallDomainListInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFirewallDomainListInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFirewallDomainListInput {
                firewall_domain_list_id: self.firewall_domain_list_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteFirewallDomainListInputOperationOutputAlias =
    crate::operation::DeleteFirewallDomainList;
#[doc(hidden)]
pub type DeleteFirewallDomainListInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteFirewallDomainListInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFirewallDomainList`](crate::operation::DeleteFirewallDomainList)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFirewallDomainList,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteFirewallDomainListInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteFirewallDomainListInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteFirewallDomainListInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.DeleteFirewallDomainList",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_firewall_domain_list(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFirewallDomainList::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFirewallDomainList",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteFirewallDomainListInput`](crate::input::DeleteFirewallDomainListInput)
    pub fn builder() -> crate::input::delete_firewall_domain_list_input::Builder {
        crate::input::delete_firewall_domain_list_input::Builder::default()
    }
}

/// See [`DeleteFirewallRuleInput`](crate::input::DeleteFirewallRuleInput)
pub mod delete_firewall_rule_input {
    /// A builder for [`DeleteFirewallRuleInput`](crate::input::DeleteFirewallRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_rule_group_id: std::option::Option<std::string::String>,
        pub(crate) firewall_domain_list_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the firewall rule group that you want to delete the rule from. </p>
        pub fn firewall_rule_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_rule_group_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the firewall rule group that you want to delete the rule from. </p>
        pub fn set_firewall_rule_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firewall_rule_group_id = input;
            self
        }
        /// <p>The ID of the domain list that's used in the rule.  </p>
        pub fn firewall_domain_list_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_domain_list_id = Some(input.into());
            self
        }
        /// <p>The ID of the domain list that's used in the rule.  </p>
        pub fn set_firewall_domain_list_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firewall_domain_list_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFirewallRuleInput`](crate::input::DeleteFirewallRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFirewallRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFirewallRuleInput {
                firewall_rule_group_id: self.firewall_rule_group_id,
                firewall_domain_list_id: self.firewall_domain_list_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteFirewallRuleInputOperationOutputAlias = crate::operation::DeleteFirewallRule;
#[doc(hidden)]
pub type DeleteFirewallRuleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteFirewallRuleInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFirewallRule`](crate::operation::DeleteFirewallRule)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFirewallRule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteFirewallRuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteFirewallRuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteFirewallRuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.DeleteFirewallRule",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_firewall_rule(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFirewallRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFirewallRule",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteFirewallRuleInput`](crate::input::DeleteFirewallRuleInput)
    pub fn builder() -> crate::input::delete_firewall_rule_input::Builder {
        crate::input::delete_firewall_rule_input::Builder::default()
    }
}

/// See [`DeleteFirewallRuleGroupInput`](crate::input::DeleteFirewallRuleGroupInput)
pub mod delete_firewall_rule_group_input {
    /// A builder for [`DeleteFirewallRuleGroupInput`](crate::input::DeleteFirewallRuleGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_rule_group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the firewall rule group that you want to delete. </p>
        pub fn firewall_rule_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_rule_group_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the firewall rule group that you want to delete. </p>
        pub fn set_firewall_rule_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firewall_rule_group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFirewallRuleGroupInput`](crate::input::DeleteFirewallRuleGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFirewallRuleGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFirewallRuleGroupInput {
                firewall_rule_group_id: self.firewall_rule_group_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteFirewallRuleGroupInputOperationOutputAlias =
    crate::operation::DeleteFirewallRuleGroup;
#[doc(hidden)]
pub type DeleteFirewallRuleGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteFirewallRuleGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFirewallRuleGroup`](crate::operation::DeleteFirewallRuleGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFirewallRuleGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteFirewallRuleGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteFirewallRuleGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteFirewallRuleGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.DeleteFirewallRuleGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_firewall_rule_group(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFirewallRuleGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFirewallRuleGroup",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteFirewallRuleGroupInput`](crate::input::DeleteFirewallRuleGroupInput)
    pub fn builder() -> crate::input::delete_firewall_rule_group_input::Builder {
        crate::input::delete_firewall_rule_group_input::Builder::default()
    }
}

/// See [`DeleteResolverEndpointInput`](crate::input::DeleteResolverEndpointInput)
pub mod delete_resolver_endpoint_input {
    /// A builder for [`DeleteResolverEndpointInput`](crate::input::DeleteResolverEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resolver_endpoint_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Resolver endpoint that you want to delete.</p>
        pub fn resolver_endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resolver_endpoint_id = Some(input.into());
            self
        }
        /// <p>The ID of the Resolver endpoint that you want to delete.</p>
        pub fn set_resolver_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resolver_endpoint_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteResolverEndpointInput`](crate::input::DeleteResolverEndpointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteResolverEndpointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteResolverEndpointInput {
                resolver_endpoint_id: self.resolver_endpoint_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteResolverEndpointInputOperationOutputAlias = crate::operation::DeleteResolverEndpoint;
#[doc(hidden)]
pub type DeleteResolverEndpointInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteResolverEndpointInput {
    /// Consumes the builder and constructs an Operation<[`DeleteResolverEndpoint`](crate::operation::DeleteResolverEndpoint)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteResolverEndpoint,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteResolverEndpointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteResolverEndpointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteResolverEndpointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.DeleteResolverEndpoint",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_resolver_endpoint(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteResolverEndpoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteResolverEndpoint",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteResolverEndpointInput`](crate::input::DeleteResolverEndpointInput)
    pub fn builder() -> crate::input::delete_resolver_endpoint_input::Builder {
        crate::input::delete_resolver_endpoint_input::Builder::default()
    }
}

/// See [`DeleteResolverQueryLogConfigInput`](crate::input::DeleteResolverQueryLogConfigInput)
pub mod delete_resolver_query_log_config_input {
    /// A builder for [`DeleteResolverQueryLogConfigInput`](crate::input::DeleteResolverQueryLogConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resolver_query_log_config_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the query logging configuration that you want to delete.</p>
        pub fn resolver_query_log_config_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.resolver_query_log_config_id = Some(input.into());
            self
        }
        /// <p>The ID of the query logging configuration that you want to delete.</p>
        pub fn set_resolver_query_log_config_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resolver_query_log_config_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteResolverQueryLogConfigInput`](crate::input::DeleteResolverQueryLogConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteResolverQueryLogConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteResolverQueryLogConfigInput {
                resolver_query_log_config_id: self.resolver_query_log_config_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteResolverQueryLogConfigInputOperationOutputAlias =
    crate::operation::DeleteResolverQueryLogConfig;
#[doc(hidden)]
pub type DeleteResolverQueryLogConfigInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteResolverQueryLogConfigInput {
    /// Consumes the builder and constructs an Operation<[`DeleteResolverQueryLogConfig`](crate::operation::DeleteResolverQueryLogConfig)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteResolverQueryLogConfig,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteResolverQueryLogConfigInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteResolverQueryLogConfigInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteResolverQueryLogConfigInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.DeleteResolverQueryLogConfig",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_resolver_query_log_config(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteResolverQueryLogConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteResolverQueryLogConfig",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteResolverQueryLogConfigInput`](crate::input::DeleteResolverQueryLogConfigInput)
    pub fn builder() -> crate::input::delete_resolver_query_log_config_input::Builder {
        crate::input::delete_resolver_query_log_config_input::Builder::default()
    }
}

/// See [`DeleteResolverRuleInput`](crate::input::DeleteResolverRuleInput)
pub mod delete_resolver_rule_input {
    /// A builder for [`DeleteResolverRuleInput`](crate::input::DeleteResolverRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resolver_rule_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Resolver rule that you want to delete.</p>
        pub fn resolver_rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resolver_rule_id = Some(input.into());
            self
        }
        /// <p>The ID of the Resolver rule that you want to delete.</p>
        pub fn set_resolver_rule_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resolver_rule_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteResolverRuleInput`](crate::input::DeleteResolverRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteResolverRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteResolverRuleInput {
                resolver_rule_id: self.resolver_rule_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteResolverRuleInputOperationOutputAlias = crate::operation::DeleteResolverRule;
#[doc(hidden)]
pub type DeleteResolverRuleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteResolverRuleInput {
    /// Consumes the builder and constructs an Operation<[`DeleteResolverRule`](crate::operation::DeleteResolverRule)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteResolverRule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteResolverRuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteResolverRuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteResolverRuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.DeleteResolverRule",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_resolver_rule(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteResolverRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteResolverRule",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteResolverRuleInput`](crate::input::DeleteResolverRuleInput)
    pub fn builder() -> crate::input::delete_resolver_rule_input::Builder {
        crate::input::delete_resolver_rule_input::Builder::default()
    }
}

/// See [`DisassociateFirewallRuleGroupInput`](crate::input::DisassociateFirewallRuleGroupInput)
pub mod disassociate_firewall_rule_group_input {
    /// A builder for [`DisassociateFirewallRuleGroupInput`](crate::input::DisassociateFirewallRuleGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_rule_group_association_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the <a>FirewallRuleGroupAssociation</a>. </p>
        pub fn firewall_rule_group_association_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.firewall_rule_group_association_id = Some(input.into());
            self
        }
        /// <p>The identifier of the <a>FirewallRuleGroupAssociation</a>. </p>
        pub fn set_firewall_rule_group_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firewall_rule_group_association_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateFirewallRuleGroupInput`](crate::input::DisassociateFirewallRuleGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateFirewallRuleGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateFirewallRuleGroupInput {
                firewall_rule_group_association_id: self.firewall_rule_group_association_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateFirewallRuleGroupInputOperationOutputAlias =
    crate::operation::DisassociateFirewallRuleGroup;
#[doc(hidden)]
pub type DisassociateFirewallRuleGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisassociateFirewallRuleGroupInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateFirewallRuleGroup`](crate::operation::DisassociateFirewallRuleGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateFirewallRuleGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateFirewallRuleGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateFirewallRuleGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateFirewallRuleGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.DisassociateFirewallRuleGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_firewall_rule_group(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateFirewallRuleGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateFirewallRuleGroup",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateFirewallRuleGroupInput`](crate::input::DisassociateFirewallRuleGroupInput)
    pub fn builder() -> crate::input::disassociate_firewall_rule_group_input::Builder {
        crate::input::disassociate_firewall_rule_group_input::Builder::default()
    }
}

/// See [`DisassociateResolverEndpointIpAddressInput`](crate::input::DisassociateResolverEndpointIpAddressInput)
pub mod disassociate_resolver_endpoint_ip_address_input {
    /// A builder for [`DisassociateResolverEndpointIpAddressInput`](crate::input::DisassociateResolverEndpointIpAddressInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resolver_endpoint_id: std::option::Option<std::string::String>,
        pub(crate) ip_address: std::option::Option<crate::model::IpAddressUpdate>,
    }
    impl Builder {
        /// <p>The ID of the Resolver endpoint that you want to disassociate an IP address from.</p>
        pub fn resolver_endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resolver_endpoint_id = Some(input.into());
            self
        }
        /// <p>The ID of the Resolver endpoint that you want to disassociate an IP address from.</p>
        pub fn set_resolver_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resolver_endpoint_id = input;
            self
        }
        /// <p>The IPv4 address that you want to remove from a Resolver endpoint.</p>
        pub fn ip_address(mut self, input: crate::model::IpAddressUpdate) -> Self {
            self.ip_address = Some(input);
            self
        }
        /// <p>The IPv4 address that you want to remove from a Resolver endpoint.</p>
        pub fn set_ip_address(
            mut self,
            input: std::option::Option<crate::model::IpAddressUpdate>,
        ) -> Self {
            self.ip_address = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateResolverEndpointIpAddressInput`](crate::input::DisassociateResolverEndpointIpAddressInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateResolverEndpointIpAddressInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateResolverEndpointIpAddressInput {
                resolver_endpoint_id: self.resolver_endpoint_id,
                ip_address: self.ip_address,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateResolverEndpointIpAddressInputOperationOutputAlias =
    crate::operation::DisassociateResolverEndpointIpAddress;
#[doc(hidden)]
pub type DisassociateResolverEndpointIpAddressInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DisassociateResolverEndpointIpAddressInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateResolverEndpointIpAddress`](crate::operation::DisassociateResolverEndpointIpAddress)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateResolverEndpointIpAddress,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateResolverEndpointIpAddressInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateResolverEndpointIpAddressInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateResolverEndpointIpAddressInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.DisassociateResolverEndpointIpAddress",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_resolver_endpoint_ip_address(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateResolverEndpointIpAddress::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateResolverEndpointIpAddress",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateResolverEndpointIpAddressInput`](crate::input::DisassociateResolverEndpointIpAddressInput)
    pub fn builder() -> crate::input::disassociate_resolver_endpoint_ip_address_input::Builder {
        crate::input::disassociate_resolver_endpoint_ip_address_input::Builder::default()
    }
}

/// See [`DisassociateResolverQueryLogConfigInput`](crate::input::DisassociateResolverQueryLogConfigInput)
pub mod disassociate_resolver_query_log_config_input {
    /// A builder for [`DisassociateResolverQueryLogConfigInput`](crate::input::DisassociateResolverQueryLogConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resolver_query_log_config_id: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the query logging configuration that you want to disassociate a specified VPC from.</p>
        pub fn resolver_query_log_config_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.resolver_query_log_config_id = Some(input.into());
            self
        }
        /// <p>The ID of the query logging configuration that you want to disassociate a specified VPC from.</p>
        pub fn set_resolver_query_log_config_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resolver_query_log_config_id = input;
            self
        }
        /// <p>The ID of the Amazon VPC that you want to disassociate from a specified query logging configuration.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon VPC that you want to disassociate from a specified query logging configuration.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateResolverQueryLogConfigInput`](crate::input::DisassociateResolverQueryLogConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateResolverQueryLogConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateResolverQueryLogConfigInput {
                resolver_query_log_config_id: self.resolver_query_log_config_id,
                resource_id: self.resource_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateResolverQueryLogConfigInputOperationOutputAlias =
    crate::operation::DisassociateResolverQueryLogConfig;
#[doc(hidden)]
pub type DisassociateResolverQueryLogConfigInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisassociateResolverQueryLogConfigInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateResolverQueryLogConfig`](crate::operation::DisassociateResolverQueryLogConfig)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateResolverQueryLogConfig,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateResolverQueryLogConfigInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateResolverQueryLogConfigInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateResolverQueryLogConfigInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.DisassociateResolverQueryLogConfig",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_resolver_query_log_config(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateResolverQueryLogConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateResolverQueryLogConfig",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateResolverQueryLogConfigInput`](crate::input::DisassociateResolverQueryLogConfigInput)
    pub fn builder() -> crate::input::disassociate_resolver_query_log_config_input::Builder {
        crate::input::disassociate_resolver_query_log_config_input::Builder::default()
    }
}

/// See [`DisassociateResolverRuleInput`](crate::input::DisassociateResolverRuleInput)
pub mod disassociate_resolver_rule_input {
    /// A builder for [`DisassociateResolverRuleInput`](crate::input::DisassociateResolverRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) resolver_rule_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the VPC that you want to disassociate the Resolver rule from.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC that you want to disassociate the Resolver rule from.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>The ID of the Resolver rule that you want to disassociate from the specified VPC.</p>
        pub fn resolver_rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resolver_rule_id = Some(input.into());
            self
        }
        /// <p>The ID of the Resolver rule that you want to disassociate from the specified VPC.</p>
        pub fn set_resolver_rule_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resolver_rule_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateResolverRuleInput`](crate::input::DisassociateResolverRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateResolverRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateResolverRuleInput {
                vpc_id: self.vpc_id,
                resolver_rule_id: self.resolver_rule_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateResolverRuleInputOperationOutputAlias =
    crate::operation::DisassociateResolverRule;
#[doc(hidden)]
pub type DisassociateResolverRuleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisassociateResolverRuleInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateResolverRule`](crate::operation::DisassociateResolverRule)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateResolverRule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateResolverRuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateResolverRuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateResolverRuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.DisassociateResolverRule",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_resolver_rule(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateResolverRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateResolverRule",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateResolverRuleInput`](crate::input::DisassociateResolverRuleInput)
    pub fn builder() -> crate::input::disassociate_resolver_rule_input::Builder {
        crate::input::disassociate_resolver_rule_input::Builder::default()
    }
}

/// See [`GetFirewallConfigInput`](crate::input::GetFirewallConfigInput)
pub mod get_firewall_config_input {
    /// A builder for [`GetFirewallConfigInput`](crate::input::GetFirewallConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the VPC from Amazon VPC that the configuration is for.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC from Amazon VPC that the configuration is for.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFirewallConfigInput`](crate::input::GetFirewallConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetFirewallConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetFirewallConfigInput {
                resource_id: self.resource_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetFirewallConfigInputOperationOutputAlias = crate::operation::GetFirewallConfig;
#[doc(hidden)]
pub type GetFirewallConfigInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetFirewallConfigInput {
    /// Consumes the builder and constructs an Operation<[`GetFirewallConfig`](crate::operation::GetFirewallConfig)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFirewallConfig,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetFirewallConfigInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetFirewallConfigInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetFirewallConfigInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.GetFirewallConfig",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_firewall_config(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetFirewallConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetFirewallConfig",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetFirewallConfigInput`](crate::input::GetFirewallConfigInput)
    pub fn builder() -> crate::input::get_firewall_config_input::Builder {
        crate::input::get_firewall_config_input::Builder::default()
    }
}

/// See [`GetFirewallDomainListInput`](crate::input::GetFirewallDomainListInput)
pub mod get_firewall_domain_list_input {
    /// A builder for [`GetFirewallDomainListInput`](crate::input::GetFirewallDomainListInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_domain_list_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the domain list.  </p>
        pub fn firewall_domain_list_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_domain_list_id = Some(input.into());
            self
        }
        /// <p>The ID of the domain list.  </p>
        pub fn set_firewall_domain_list_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firewall_domain_list_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFirewallDomainListInput`](crate::input::GetFirewallDomainListInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetFirewallDomainListInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetFirewallDomainListInput {
                firewall_domain_list_id: self.firewall_domain_list_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetFirewallDomainListInputOperationOutputAlias = crate::operation::GetFirewallDomainList;
#[doc(hidden)]
pub type GetFirewallDomainListInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetFirewallDomainListInput {
    /// Consumes the builder and constructs an Operation<[`GetFirewallDomainList`](crate::operation::GetFirewallDomainList)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFirewallDomainList,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetFirewallDomainListInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetFirewallDomainListInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetFirewallDomainListInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.GetFirewallDomainList",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_firewall_domain_list(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetFirewallDomainList::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetFirewallDomainList",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetFirewallDomainListInput`](crate::input::GetFirewallDomainListInput)
    pub fn builder() -> crate::input::get_firewall_domain_list_input::Builder {
        crate::input::get_firewall_domain_list_input::Builder::default()
    }
}

/// See [`GetFirewallRuleGroupInput`](crate::input::GetFirewallRuleGroupInput)
pub mod get_firewall_rule_group_input {
    /// A builder for [`GetFirewallRuleGroupInput`](crate::input::GetFirewallRuleGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_rule_group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the firewall rule group. </p>
        pub fn firewall_rule_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_rule_group_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the firewall rule group. </p>
        pub fn set_firewall_rule_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firewall_rule_group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFirewallRuleGroupInput`](crate::input::GetFirewallRuleGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetFirewallRuleGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetFirewallRuleGroupInput {
                firewall_rule_group_id: self.firewall_rule_group_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetFirewallRuleGroupInputOperationOutputAlias = crate::operation::GetFirewallRuleGroup;
#[doc(hidden)]
pub type GetFirewallRuleGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetFirewallRuleGroupInput {
    /// Consumes the builder and constructs an Operation<[`GetFirewallRuleGroup`](crate::operation::GetFirewallRuleGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFirewallRuleGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetFirewallRuleGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetFirewallRuleGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetFirewallRuleGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.GetFirewallRuleGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_firewall_rule_group(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetFirewallRuleGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetFirewallRuleGroup",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetFirewallRuleGroupInput`](crate::input::GetFirewallRuleGroupInput)
    pub fn builder() -> crate::input::get_firewall_rule_group_input::Builder {
        crate::input::get_firewall_rule_group_input::Builder::default()
    }
}

/// See [`GetFirewallRuleGroupAssociationInput`](crate::input::GetFirewallRuleGroupAssociationInput)
pub mod get_firewall_rule_group_association_input {
    /// A builder for [`GetFirewallRuleGroupAssociationInput`](crate::input::GetFirewallRuleGroupAssociationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_rule_group_association_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the <a>FirewallRuleGroupAssociation</a>. </p>
        pub fn firewall_rule_group_association_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.firewall_rule_group_association_id = Some(input.into());
            self
        }
        /// <p>The identifier of the <a>FirewallRuleGroupAssociation</a>. </p>
        pub fn set_firewall_rule_group_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firewall_rule_group_association_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFirewallRuleGroupAssociationInput`](crate::input::GetFirewallRuleGroupAssociationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetFirewallRuleGroupAssociationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetFirewallRuleGroupAssociationInput {
                firewall_rule_group_association_id: self.firewall_rule_group_association_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetFirewallRuleGroupAssociationInputOperationOutputAlias =
    crate::operation::GetFirewallRuleGroupAssociation;
#[doc(hidden)]
pub type GetFirewallRuleGroupAssociationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetFirewallRuleGroupAssociationInput {
    /// Consumes the builder and constructs an Operation<[`GetFirewallRuleGroupAssociation`](crate::operation::GetFirewallRuleGroupAssociation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFirewallRuleGroupAssociation,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetFirewallRuleGroupAssociationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetFirewallRuleGroupAssociationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetFirewallRuleGroupAssociationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.GetFirewallRuleGroupAssociation",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_firewall_rule_group_association(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetFirewallRuleGroupAssociation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetFirewallRuleGroupAssociation",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetFirewallRuleGroupAssociationInput`](crate::input::GetFirewallRuleGroupAssociationInput)
    pub fn builder() -> crate::input::get_firewall_rule_group_association_input::Builder {
        crate::input::get_firewall_rule_group_association_input::Builder::default()
    }
}

/// See [`GetFirewallRuleGroupPolicyInput`](crate::input::GetFirewallRuleGroupPolicyInput)
pub mod get_firewall_rule_group_policy_input {
    /// A builder for [`GetFirewallRuleGroupPolicyInput`](crate::input::GetFirewallRuleGroupPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN (Amazon Resource Name) for the rule group.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN (Amazon Resource Name) for the rule group.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFirewallRuleGroupPolicyInput`](crate::input::GetFirewallRuleGroupPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetFirewallRuleGroupPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetFirewallRuleGroupPolicyInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type GetFirewallRuleGroupPolicyInputOperationOutputAlias =
    crate::operation::GetFirewallRuleGroupPolicy;
#[doc(hidden)]
pub type GetFirewallRuleGroupPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetFirewallRuleGroupPolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetFirewallRuleGroupPolicy`](crate::operation::GetFirewallRuleGroupPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFirewallRuleGroupPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetFirewallRuleGroupPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetFirewallRuleGroupPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetFirewallRuleGroupPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.GetFirewallRuleGroupPolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_firewall_rule_group_policy(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetFirewallRuleGroupPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetFirewallRuleGroupPolicy",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetFirewallRuleGroupPolicyInput`](crate::input::GetFirewallRuleGroupPolicyInput)
    pub fn builder() -> crate::input::get_firewall_rule_group_policy_input::Builder {
        crate::input::get_firewall_rule_group_policy_input::Builder::default()
    }
}

/// See [`GetResolverConfigInput`](crate::input::GetResolverConfigInput)
pub mod get_resolver_config_input {
    /// A builder for [`GetResolverConfigInput`](crate::input::GetResolverConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Resource ID of the Amazon VPC that you want to get information about.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>Resource ID of the Amazon VPC that you want to get information about.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResolverConfigInput`](crate::input::GetResolverConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetResolverConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetResolverConfigInput {
                resource_id: self.resource_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetResolverConfigInputOperationOutputAlias = crate::operation::GetResolverConfig;
#[doc(hidden)]
pub type GetResolverConfigInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetResolverConfigInput {
    /// Consumes the builder and constructs an Operation<[`GetResolverConfig`](crate::operation::GetResolverConfig)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetResolverConfig,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetResolverConfigInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetResolverConfigInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetResolverConfigInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.GetResolverConfig",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_resolver_config(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetResolverConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetResolverConfig",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetResolverConfigInput`](crate::input::GetResolverConfigInput)
    pub fn builder() -> crate::input::get_resolver_config_input::Builder {
        crate::input::get_resolver_config_input::Builder::default()
    }
}

/// See [`GetResolverDnssecConfigInput`](crate::input::GetResolverDnssecConfigInput)
pub mod get_resolver_dnssec_config_input {
    /// A builder for [`GetResolverDnssecConfigInput`](crate::input::GetResolverDnssecConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the virtual private cloud (VPC) for the DNSSEC validation status.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual private cloud (VPC) for the DNSSEC validation status.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResolverDnssecConfigInput`](crate::input::GetResolverDnssecConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetResolverDnssecConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetResolverDnssecConfigInput {
                resource_id: self.resource_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetResolverDnssecConfigInputOperationOutputAlias =
    crate::operation::GetResolverDnssecConfig;
#[doc(hidden)]
pub type GetResolverDnssecConfigInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetResolverDnssecConfigInput {
    /// Consumes the builder and constructs an Operation<[`GetResolverDnssecConfig`](crate::operation::GetResolverDnssecConfig)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetResolverDnssecConfig,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetResolverDnssecConfigInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetResolverDnssecConfigInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetResolverDnssecConfigInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.GetResolverDnssecConfig",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_resolver_dnssec_config(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetResolverDnssecConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetResolverDnssecConfig",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetResolverDnssecConfigInput`](crate::input::GetResolverDnssecConfigInput)
    pub fn builder() -> crate::input::get_resolver_dnssec_config_input::Builder {
        crate::input::get_resolver_dnssec_config_input::Builder::default()
    }
}

/// See [`GetResolverEndpointInput`](crate::input::GetResolverEndpointInput)
pub mod get_resolver_endpoint_input {
    /// A builder for [`GetResolverEndpointInput`](crate::input::GetResolverEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resolver_endpoint_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Resolver endpoint that you want to get information about.</p>
        pub fn resolver_endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resolver_endpoint_id = Some(input.into());
            self
        }
        /// <p>The ID of the Resolver endpoint that you want to get information about.</p>
        pub fn set_resolver_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resolver_endpoint_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResolverEndpointInput`](crate::input::GetResolverEndpointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetResolverEndpointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetResolverEndpointInput {
                resolver_endpoint_id: self.resolver_endpoint_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetResolverEndpointInputOperationOutputAlias = crate::operation::GetResolverEndpoint;
#[doc(hidden)]
pub type GetResolverEndpointInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetResolverEndpointInput {
    /// Consumes the builder and constructs an Operation<[`GetResolverEndpoint`](crate::operation::GetResolverEndpoint)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetResolverEndpoint,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetResolverEndpointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetResolverEndpointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetResolverEndpointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.GetResolverEndpoint",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_resolver_endpoint(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetResolverEndpoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetResolverEndpoint",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetResolverEndpointInput`](crate::input::GetResolverEndpointInput)
    pub fn builder() -> crate::input::get_resolver_endpoint_input::Builder {
        crate::input::get_resolver_endpoint_input::Builder::default()
    }
}

/// See [`GetResolverQueryLogConfigInput`](crate::input::GetResolverQueryLogConfigInput)
pub mod get_resolver_query_log_config_input {
    /// A builder for [`GetResolverQueryLogConfigInput`](crate::input::GetResolverQueryLogConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resolver_query_log_config_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Resolver query logging configuration that you want to get information about.</p>
        pub fn resolver_query_log_config_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.resolver_query_log_config_id = Some(input.into());
            self
        }
        /// <p>The ID of the Resolver query logging configuration that you want to get information about.</p>
        pub fn set_resolver_query_log_config_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resolver_query_log_config_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResolverQueryLogConfigInput`](crate::input::GetResolverQueryLogConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetResolverQueryLogConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetResolverQueryLogConfigInput {
                resolver_query_log_config_id: self.resolver_query_log_config_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetResolverQueryLogConfigInputOperationOutputAlias =
    crate::operation::GetResolverQueryLogConfig;
#[doc(hidden)]
pub type GetResolverQueryLogConfigInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetResolverQueryLogConfigInput {
    /// Consumes the builder and constructs an Operation<[`GetResolverQueryLogConfig`](crate::operation::GetResolverQueryLogConfig)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetResolverQueryLogConfig,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetResolverQueryLogConfigInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetResolverQueryLogConfigInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetResolverQueryLogConfigInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.GetResolverQueryLogConfig",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_resolver_query_log_config(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetResolverQueryLogConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetResolverQueryLogConfig",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetResolverQueryLogConfigInput`](crate::input::GetResolverQueryLogConfigInput)
    pub fn builder() -> crate::input::get_resolver_query_log_config_input::Builder {
        crate::input::get_resolver_query_log_config_input::Builder::default()
    }
}

/// See [`GetResolverQueryLogConfigAssociationInput`](crate::input::GetResolverQueryLogConfigAssociationInput)
pub mod get_resolver_query_log_config_association_input {
    /// A builder for [`GetResolverQueryLogConfigAssociationInput`](crate::input::GetResolverQueryLogConfigAssociationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resolver_query_log_config_association_id:
            std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Resolver query logging configuration association that you want to get information about.</p>
        pub fn resolver_query_log_config_association_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.resolver_query_log_config_association_id = Some(input.into());
            self
        }
        /// <p>The ID of the Resolver query logging configuration association that you want to get information about.</p>
        pub fn set_resolver_query_log_config_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resolver_query_log_config_association_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResolverQueryLogConfigAssociationInput`](crate::input::GetResolverQueryLogConfigAssociationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetResolverQueryLogConfigAssociationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetResolverQueryLogConfigAssociationInput {
                resolver_query_log_config_association_id: self
                    .resolver_query_log_config_association_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetResolverQueryLogConfigAssociationInputOperationOutputAlias =
    crate::operation::GetResolverQueryLogConfigAssociation;
#[doc(hidden)]
pub type GetResolverQueryLogConfigAssociationInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl GetResolverQueryLogConfigAssociationInput {
    /// Consumes the builder and constructs an Operation<[`GetResolverQueryLogConfigAssociation`](crate::operation::GetResolverQueryLogConfigAssociation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetResolverQueryLogConfigAssociation,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetResolverQueryLogConfigAssociationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetResolverQueryLogConfigAssociationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetResolverQueryLogConfigAssociationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.GetResolverQueryLogConfigAssociation",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_resolver_query_log_config_association(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetResolverQueryLogConfigAssociation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetResolverQueryLogConfigAssociation",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetResolverQueryLogConfigAssociationInput`](crate::input::GetResolverQueryLogConfigAssociationInput)
    pub fn builder() -> crate::input::get_resolver_query_log_config_association_input::Builder {
        crate::input::get_resolver_query_log_config_association_input::Builder::default()
    }
}

/// See [`GetResolverQueryLogConfigPolicyInput`](crate::input::GetResolverQueryLogConfigPolicyInput)
pub mod get_resolver_query_log_config_policy_input {
    /// A builder for [`GetResolverQueryLogConfigPolicyInput`](crate::input::GetResolverQueryLogConfigPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the query logging configuration that you want to get the query logging policy for.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the query logging configuration that you want to get the query logging policy for.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResolverQueryLogConfigPolicyInput`](crate::input::GetResolverQueryLogConfigPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetResolverQueryLogConfigPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetResolverQueryLogConfigPolicyInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type GetResolverQueryLogConfigPolicyInputOperationOutputAlias =
    crate::operation::GetResolverQueryLogConfigPolicy;
#[doc(hidden)]
pub type GetResolverQueryLogConfigPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetResolverQueryLogConfigPolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetResolverQueryLogConfigPolicy`](crate::operation::GetResolverQueryLogConfigPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetResolverQueryLogConfigPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetResolverQueryLogConfigPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetResolverQueryLogConfigPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetResolverQueryLogConfigPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.GetResolverQueryLogConfigPolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_resolver_query_log_config_policy(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetResolverQueryLogConfigPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetResolverQueryLogConfigPolicy",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetResolverQueryLogConfigPolicyInput`](crate::input::GetResolverQueryLogConfigPolicyInput)
    pub fn builder() -> crate::input::get_resolver_query_log_config_policy_input::Builder {
        crate::input::get_resolver_query_log_config_policy_input::Builder::default()
    }
}

/// See [`GetResolverRuleInput`](crate::input::GetResolverRuleInput)
pub mod get_resolver_rule_input {
    /// A builder for [`GetResolverRuleInput`](crate::input::GetResolverRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resolver_rule_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Resolver rule that you want to get information about.</p>
        pub fn resolver_rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resolver_rule_id = Some(input.into());
            self
        }
        /// <p>The ID of the Resolver rule that you want to get information about.</p>
        pub fn set_resolver_rule_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resolver_rule_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResolverRuleInput`](crate::input::GetResolverRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetResolverRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetResolverRuleInput {
                resolver_rule_id: self.resolver_rule_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetResolverRuleInputOperationOutputAlias = crate::operation::GetResolverRule;
#[doc(hidden)]
pub type GetResolverRuleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetResolverRuleInput {
    /// Consumes the builder and constructs an Operation<[`GetResolverRule`](crate::operation::GetResolverRule)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetResolverRule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetResolverRuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetResolverRuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetResolverRuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.GetResolverRule",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_resolver_rule(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetResolverRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetResolverRule",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetResolverRuleInput`](crate::input::GetResolverRuleInput)
    pub fn builder() -> crate::input::get_resolver_rule_input::Builder {
        crate::input::get_resolver_rule_input::Builder::default()
    }
}

/// See [`GetResolverRuleAssociationInput`](crate::input::GetResolverRuleAssociationInput)
pub mod get_resolver_rule_association_input {
    /// A builder for [`GetResolverRuleAssociationInput`](crate::input::GetResolverRuleAssociationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resolver_rule_association_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Resolver rule association that you want to get information about.</p>
        pub fn resolver_rule_association_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.resolver_rule_association_id = Some(input.into());
            self
        }
        /// <p>The ID of the Resolver rule association that you want to get information about.</p>
        pub fn set_resolver_rule_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resolver_rule_association_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResolverRuleAssociationInput`](crate::input::GetResolverRuleAssociationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetResolverRuleAssociationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetResolverRuleAssociationInput {
                resolver_rule_association_id: self.resolver_rule_association_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetResolverRuleAssociationInputOperationOutputAlias =
    crate::operation::GetResolverRuleAssociation;
#[doc(hidden)]
pub type GetResolverRuleAssociationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetResolverRuleAssociationInput {
    /// Consumes the builder and constructs an Operation<[`GetResolverRuleAssociation`](crate::operation::GetResolverRuleAssociation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetResolverRuleAssociation,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetResolverRuleAssociationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetResolverRuleAssociationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetResolverRuleAssociationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.GetResolverRuleAssociation",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_resolver_rule_association(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetResolverRuleAssociation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetResolverRuleAssociation",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetResolverRuleAssociationInput`](crate::input::GetResolverRuleAssociationInput)
    pub fn builder() -> crate::input::get_resolver_rule_association_input::Builder {
        crate::input::get_resolver_rule_association_input::Builder::default()
    }
}

/// See [`GetResolverRulePolicyInput`](crate::input::GetResolverRulePolicyInput)
pub mod get_resolver_rule_policy_input {
    /// A builder for [`GetResolverRulePolicyInput`](crate::input::GetResolverRulePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Resolver rule that you want to get the Resolver rule policy for.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ID of the Resolver rule that you want to get the Resolver rule policy for.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResolverRulePolicyInput`](crate::input::GetResolverRulePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetResolverRulePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetResolverRulePolicyInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type GetResolverRulePolicyInputOperationOutputAlias = crate::operation::GetResolverRulePolicy;
#[doc(hidden)]
pub type GetResolverRulePolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetResolverRulePolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetResolverRulePolicy`](crate::operation::GetResolverRulePolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetResolverRulePolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetResolverRulePolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetResolverRulePolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetResolverRulePolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.GetResolverRulePolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_resolver_rule_policy(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetResolverRulePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetResolverRulePolicy",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetResolverRulePolicyInput`](crate::input::GetResolverRulePolicyInput)
    pub fn builder() -> crate::input::get_resolver_rule_policy_input::Builder {
        crate::input::get_resolver_rule_policy_input::Builder::default()
    }
}

/// See [`ImportFirewallDomainsInput`](crate::input::ImportFirewallDomainsInput)
pub mod import_firewall_domains_input {
    /// A builder for [`ImportFirewallDomainsInput`](crate::input::ImportFirewallDomainsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_domain_list_id: std::option::Option<std::string::String>,
        pub(crate) operation: std::option::Option<crate::model::FirewallDomainImportOperation>,
        pub(crate) domain_file_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the domain list that you want to modify with the import operation.</p>
        pub fn firewall_domain_list_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_domain_list_id = Some(input.into());
            self
        }
        /// <p>The ID of the domain list that you want to modify with the import operation.</p>
        pub fn set_firewall_domain_list_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firewall_domain_list_id = input;
            self
        }
        /// <p>What you want DNS Firewall to do with the domains that are listed in the file. This must be set to <code>REPLACE</code>, which updates the domain list to exactly match the list in the file. </p>
        pub fn operation(mut self, input: crate::model::FirewallDomainImportOperation) -> Self {
            self.operation = Some(input);
            self
        }
        /// <p>What you want DNS Firewall to do with the domains that are listed in the file. This must be set to <code>REPLACE</code>, which updates the domain list to exactly match the list in the file. </p>
        pub fn set_operation(
            mut self,
            input: std::option::Option<crate::model::FirewallDomainImportOperation>,
        ) -> Self {
            self.operation = input;
            self
        }
        /// <p>The fully qualified URL or URI of the file stored in Amazon Simple Storage Service
        /// (Amazon S3) that contains the list of domains to import.</p>
        /// <p>The file must be in an S3 bucket that's in the same Region
        /// as your DNS Firewall. The file must be a text file and must contain a single domain per line.</p>
        pub fn domain_file_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_file_url = Some(input.into());
            self
        }
        /// <p>The fully qualified URL or URI of the file stored in Amazon Simple Storage Service
        /// (Amazon S3) that contains the list of domains to import.</p>
        /// <p>The file must be in an S3 bucket that's in the same Region
        /// as your DNS Firewall. The file must be a text file and must contain a single domain per line.</p>
        pub fn set_domain_file_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.domain_file_url = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportFirewallDomainsInput`](crate::input::ImportFirewallDomainsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ImportFirewallDomainsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ImportFirewallDomainsInput {
                firewall_domain_list_id: self.firewall_domain_list_id,
                operation: self.operation,
                domain_file_url: self.domain_file_url,
            })
        }
    }
}
#[doc(hidden)]
pub type ImportFirewallDomainsInputOperationOutputAlias = crate::operation::ImportFirewallDomains;
#[doc(hidden)]
pub type ImportFirewallDomainsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ImportFirewallDomainsInput {
    /// Consumes the builder and constructs an Operation<[`ImportFirewallDomains`](crate::operation::ImportFirewallDomains)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ImportFirewallDomains,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ImportFirewallDomainsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ImportFirewallDomainsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ImportFirewallDomainsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.ImportFirewallDomains",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_import_firewall_domains(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ImportFirewallDomains::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ImportFirewallDomains",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ImportFirewallDomainsInput`](crate::input::ImportFirewallDomainsInput)
    pub fn builder() -> crate::input::import_firewall_domains_input::Builder {
        crate::input::import_firewall_domains_input::Builder::default()
    }
}

/// See [`ListFirewallConfigsInput`](crate::input::ListFirewallConfigsInput)
pub mod list_firewall_configs_input {
    /// A builder for [`ListFirewallConfigsInput`](crate::input::ListFirewallConfigsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of objects that you want Resolver to return for this request. If more
        /// objects are available, in the response, Resolver provides a
        /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of objects that you want Resolver to return for this request. If more
        /// objects are available, in the response, Resolver provides a
        /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>For the first call to this list request, omit this value.</p>
        /// <p>When you request a list of objects, Resolver returns at most the number of objects
        /// specified in <code>MaxResults</code>. If more objects are available for retrieval,
        /// Resolver returns a <code>NextToken</code> value in the response. To retrieve the next
        /// batch of objects, use the token that was returned for the prior request in your next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>For the first call to this list request, omit this value.</p>
        /// <p>When you request a list of objects, Resolver returns at most the number of objects
        /// specified in <code>MaxResults</code>. If more objects are available for retrieval,
        /// Resolver returns a <code>NextToken</code> value in the response. To retrieve the next
        /// batch of objects, use the token that was returned for the prior request in your next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFirewallConfigsInput`](crate::input::ListFirewallConfigsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListFirewallConfigsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListFirewallConfigsInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListFirewallConfigsInputOperationOutputAlias = crate::operation::ListFirewallConfigs;
#[doc(hidden)]
pub type ListFirewallConfigsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListFirewallConfigsInput {
    /// Consumes the builder and constructs an Operation<[`ListFirewallConfigs`](crate::operation::ListFirewallConfigs)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFirewallConfigs,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListFirewallConfigsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListFirewallConfigsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListFirewallConfigsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.ListFirewallConfigs",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_firewall_configs(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListFirewallConfigs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListFirewallConfigs",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListFirewallConfigsInput`](crate::input::ListFirewallConfigsInput)
    pub fn builder() -> crate::input::list_firewall_configs_input::Builder {
        crate::input::list_firewall_configs_input::Builder::default()
    }
}

/// See [`ListFirewallDomainListsInput`](crate::input::ListFirewallDomainListsInput)
pub mod list_firewall_domain_lists_input {
    /// A builder for [`ListFirewallDomainListsInput`](crate::input::ListFirewallDomainListsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of objects that you want Resolver to return for this request. If more
        /// objects are available, in the response, Resolver provides a
        /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of objects that you want Resolver to return for this request. If more
        /// objects are available, in the response, Resolver provides a
        /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>For the first call to this list request, omit this value.</p>
        /// <p>When you request a list of objects, Resolver returns at most the number of objects
        /// specified in <code>MaxResults</code>. If more objects are available for retrieval,
        /// Resolver returns a <code>NextToken</code> value in the response. To retrieve the next
        /// batch of objects, use the token that was returned for the prior request in your next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>For the first call to this list request, omit this value.</p>
        /// <p>When you request a list of objects, Resolver returns at most the number of objects
        /// specified in <code>MaxResults</code>. If more objects are available for retrieval,
        /// Resolver returns a <code>NextToken</code> value in the response. To retrieve the next
        /// batch of objects, use the token that was returned for the prior request in your next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFirewallDomainListsInput`](crate::input::ListFirewallDomainListsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListFirewallDomainListsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListFirewallDomainListsInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListFirewallDomainListsInputOperationOutputAlias =
    crate::operation::ListFirewallDomainLists;
#[doc(hidden)]
pub type ListFirewallDomainListsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListFirewallDomainListsInput {
    /// Consumes the builder and constructs an Operation<[`ListFirewallDomainLists`](crate::operation::ListFirewallDomainLists)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFirewallDomainLists,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListFirewallDomainListsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListFirewallDomainListsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListFirewallDomainListsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.ListFirewallDomainLists",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_firewall_domain_lists(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListFirewallDomainLists::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListFirewallDomainLists",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListFirewallDomainListsInput`](crate::input::ListFirewallDomainListsInput)
    pub fn builder() -> crate::input::list_firewall_domain_lists_input::Builder {
        crate::input::list_firewall_domain_lists_input::Builder::default()
    }
}

/// See [`ListFirewallDomainsInput`](crate::input::ListFirewallDomainsInput)
pub mod list_firewall_domains_input {
    /// A builder for [`ListFirewallDomainsInput`](crate::input::ListFirewallDomainsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_domain_list_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the domain list whose domains you want to retrieve. </p>
        pub fn firewall_domain_list_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_domain_list_id = Some(input.into());
            self
        }
        /// <p>The ID of the domain list whose domains you want to retrieve. </p>
        pub fn set_firewall_domain_list_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firewall_domain_list_id = input;
            self
        }
        /// <p>The maximum number of objects that you want Resolver to return for this request. If more
        /// objects are available, in the response, Resolver provides a
        /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of objects that you want Resolver to return for this request. If more
        /// objects are available, in the response, Resolver provides a
        /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>For the first call to this list request, omit this value.</p>
        /// <p>When you request a list of objects, Resolver returns at most the number of objects
        /// specified in <code>MaxResults</code>. If more objects are available for retrieval,
        /// Resolver returns a <code>NextToken</code> value in the response. To retrieve the next
        /// batch of objects, use the token that was returned for the prior request in your next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>For the first call to this list request, omit this value.</p>
        /// <p>When you request a list of objects, Resolver returns at most the number of objects
        /// specified in <code>MaxResults</code>. If more objects are available for retrieval,
        /// Resolver returns a <code>NextToken</code> value in the response. To retrieve the next
        /// batch of objects, use the token that was returned for the prior request in your next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFirewallDomainsInput`](crate::input::ListFirewallDomainsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListFirewallDomainsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListFirewallDomainsInput {
                firewall_domain_list_id: self.firewall_domain_list_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListFirewallDomainsInputOperationOutputAlias = crate::operation::ListFirewallDomains;
#[doc(hidden)]
pub type ListFirewallDomainsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListFirewallDomainsInput {
    /// Consumes the builder and constructs an Operation<[`ListFirewallDomains`](crate::operation::ListFirewallDomains)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFirewallDomains,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListFirewallDomainsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListFirewallDomainsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListFirewallDomainsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.ListFirewallDomains",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_firewall_domains(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListFirewallDomains::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListFirewallDomains",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListFirewallDomainsInput`](crate::input::ListFirewallDomainsInput)
    pub fn builder() -> crate::input::list_firewall_domains_input::Builder {
        crate::input::list_firewall_domains_input::Builder::default()
    }
}

/// See [`ListFirewallRuleGroupAssociationsInput`](crate::input::ListFirewallRuleGroupAssociationsInput)
pub mod list_firewall_rule_group_associations_input {
    /// A builder for [`ListFirewallRuleGroupAssociationsInput`](crate::input::ListFirewallRuleGroupAssociationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_rule_group_id: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) priority: std::option::Option<i32>,
        pub(crate) status: std::option::Option<crate::model::FirewallRuleGroupAssociationStatus>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the firewall rule group that you want to retrieve the associations
        /// for. Leave this blank to retrieve associations for any rule group. </p>
        pub fn firewall_rule_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_rule_group_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the firewall rule group that you want to retrieve the associations
        /// for. Leave this blank to retrieve associations for any rule group. </p>
        pub fn set_firewall_rule_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firewall_rule_group_id = input;
            self
        }
        /// <p>The unique identifier of the VPC that you want to retrieve the associations
        /// for. Leave this blank to retrieve associations for any VPC. </p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the VPC that you want to retrieve the associations
        /// for. Leave this blank to retrieve associations for any VPC. </p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>The setting that determines the processing order of the rule group among the rule
        /// groups that are associated with a single VPC. DNS Firewall filters VPC traffic starting
        /// from the rule group with the lowest numeric priority setting. </p>
        pub fn priority(mut self, input: i32) -> Self {
            self.priority = Some(input);
            self
        }
        /// <p>The setting that determines the processing order of the rule group among the rule
        /// groups that are associated with a single VPC. DNS Firewall filters VPC traffic starting
        /// from the rule group with the lowest numeric priority setting. </p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.priority = input;
            self
        }
        /// <p>The association <code>Status</code> setting that you want DNS Firewall to filter on for the list. If you don't specify this, then DNS Firewall returns all associations, regardless of status.</p>
        pub fn status(mut self, input: crate::model::FirewallRuleGroupAssociationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The association <code>Status</code> setting that you want DNS Firewall to filter on for the list. If you don't specify this, then DNS Firewall returns all associations, regardless of status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::FirewallRuleGroupAssociationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The maximum number of objects that you want Resolver to return for this request. If more
        /// objects are available, in the response, Resolver provides a
        /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of objects that you want Resolver to return for this request. If more
        /// objects are available, in the response, Resolver provides a
        /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>For the first call to this list request, omit this value.</p>
        /// <p>When you request a list of objects, Resolver returns at most the number of objects
        /// specified in <code>MaxResults</code>. If more objects are available for retrieval,
        /// Resolver returns a <code>NextToken</code> value in the response. To retrieve the next
        /// batch of objects, use the token that was returned for the prior request in your next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>For the first call to this list request, omit this value.</p>
        /// <p>When you request a list of objects, Resolver returns at most the number of objects
        /// specified in <code>MaxResults</code>. If more objects are available for retrieval,
        /// Resolver returns a <code>NextToken</code> value in the response. To retrieve the next
        /// batch of objects, use the token that was returned for the prior request in your next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFirewallRuleGroupAssociationsInput`](crate::input::ListFirewallRuleGroupAssociationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListFirewallRuleGroupAssociationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListFirewallRuleGroupAssociationsInput {
                firewall_rule_group_id: self.firewall_rule_group_id,
                vpc_id: self.vpc_id,
                priority: self.priority,
                status: self.status,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListFirewallRuleGroupAssociationsInputOperationOutputAlias =
    crate::operation::ListFirewallRuleGroupAssociations;
#[doc(hidden)]
pub type ListFirewallRuleGroupAssociationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListFirewallRuleGroupAssociationsInput {
    /// Consumes the builder and constructs an Operation<[`ListFirewallRuleGroupAssociations`](crate::operation::ListFirewallRuleGroupAssociations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFirewallRuleGroupAssociations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListFirewallRuleGroupAssociationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListFirewallRuleGroupAssociationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListFirewallRuleGroupAssociationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.ListFirewallRuleGroupAssociations",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_firewall_rule_group_associations(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListFirewallRuleGroupAssociations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListFirewallRuleGroupAssociations",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListFirewallRuleGroupAssociationsInput`](crate::input::ListFirewallRuleGroupAssociationsInput)
    pub fn builder() -> crate::input::list_firewall_rule_group_associations_input::Builder {
        crate::input::list_firewall_rule_group_associations_input::Builder::default()
    }
}

/// See [`ListFirewallRuleGroupsInput`](crate::input::ListFirewallRuleGroupsInput)
pub mod list_firewall_rule_groups_input {
    /// A builder for [`ListFirewallRuleGroupsInput`](crate::input::ListFirewallRuleGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of objects that you want Resolver to return for this request. If more
        /// objects are available, in the response, Resolver provides a
        /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of objects that you want Resolver to return for this request. If more
        /// objects are available, in the response, Resolver provides a
        /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>For the first call to this list request, omit this value.</p>
        /// <p>When you request a list of objects, Resolver returns at most the number of objects
        /// specified in <code>MaxResults</code>. If more objects are available for retrieval,
        /// Resolver returns a <code>NextToken</code> value in the response. To retrieve the next
        /// batch of objects, use the token that was returned for the prior request in your next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>For the first call to this list request, omit this value.</p>
        /// <p>When you request a list of objects, Resolver returns at most the number of objects
        /// specified in <code>MaxResults</code>. If more objects are available for retrieval,
        /// Resolver returns a <code>NextToken</code> value in the response. To retrieve the next
        /// batch of objects, use the token that was returned for the prior request in your next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFirewallRuleGroupsInput`](crate::input::ListFirewallRuleGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListFirewallRuleGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListFirewallRuleGroupsInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListFirewallRuleGroupsInputOperationOutputAlias = crate::operation::ListFirewallRuleGroups;
#[doc(hidden)]
pub type ListFirewallRuleGroupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListFirewallRuleGroupsInput {
    /// Consumes the builder and constructs an Operation<[`ListFirewallRuleGroups`](crate::operation::ListFirewallRuleGroups)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFirewallRuleGroups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListFirewallRuleGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListFirewallRuleGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListFirewallRuleGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.ListFirewallRuleGroups",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_firewall_rule_groups(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListFirewallRuleGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListFirewallRuleGroups",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListFirewallRuleGroupsInput`](crate::input::ListFirewallRuleGroupsInput)
    pub fn builder() -> crate::input::list_firewall_rule_groups_input::Builder {
        crate::input::list_firewall_rule_groups_input::Builder::default()
    }
}

/// See [`ListFirewallRulesInput`](crate::input::ListFirewallRulesInput)
pub mod list_firewall_rules_input {
    /// A builder for [`ListFirewallRulesInput`](crate::input::ListFirewallRulesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_rule_group_id: std::option::Option<std::string::String>,
        pub(crate) priority: std::option::Option<i32>,
        pub(crate) action: std::option::Option<crate::model::Action>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the firewall rule group that you want to retrieve the rules for. </p>
        pub fn firewall_rule_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_rule_group_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the firewall rule group that you want to retrieve the rules for. </p>
        pub fn set_firewall_rule_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firewall_rule_group_id = input;
            self
        }
        /// <p>Optional additional filter for the rules to retrieve.</p>
        /// <p>The setting that determines the processing order of the rules in a rule group. DNS Firewall
        /// processes the rules in a rule group by order of priority, starting from the lowest setting.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.priority = Some(input);
            self
        }
        /// <p>Optional additional filter for the rules to retrieve.</p>
        /// <p>The setting that determines the processing order of the rules in a rule group. DNS Firewall
        /// processes the rules in a rule group by order of priority, starting from the lowest setting.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.priority = input;
            self
        }
        /// <p>Optional additional filter for the rules to retrieve.</p>
        /// <p>The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALLOW</code> - Permit the request to go through.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALERT</code> - Permit the request to go through but send an alert to the logs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BLOCK</code> - Disallow the request. If this is specified, additional handling details are provided in the rule's <code>BlockResponse</code> setting. </p>
        /// </li>
        /// </ul>
        pub fn action(mut self, input: crate::model::Action) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>Optional additional filter for the rules to retrieve.</p>
        /// <p>The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALLOW</code> - Permit the request to go through.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALERT</code> - Permit the request to go through but send an alert to the logs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BLOCK</code> - Disallow the request. If this is specified, additional handling details are provided in the rule's <code>BlockResponse</code> setting. </p>
        /// </li>
        /// </ul>
        pub fn set_action(mut self, input: std::option::Option<crate::model::Action>) -> Self {
            self.action = input;
            self
        }
        /// <p>The maximum number of objects that you want Resolver to return for this request. If more
        /// objects are available, in the response, Resolver provides a
        /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of objects that you want Resolver to return for this request. If more
        /// objects are available, in the response, Resolver provides a
        /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>For the first call to this list request, omit this value.</p>
        /// <p>When you request a list of objects, Resolver returns at most the number of objects
        /// specified in <code>MaxResults</code>. If more objects are available for retrieval,
        /// Resolver returns a <code>NextToken</code> value in the response. To retrieve the next
        /// batch of objects, use the token that was returned for the prior request in your next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>For the first call to this list request, omit this value.</p>
        /// <p>When you request a list of objects, Resolver returns at most the number of objects
        /// specified in <code>MaxResults</code>. If more objects are available for retrieval,
        /// Resolver returns a <code>NextToken</code> value in the response. To retrieve the next
        /// batch of objects, use the token that was returned for the prior request in your next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFirewallRulesInput`](crate::input::ListFirewallRulesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListFirewallRulesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListFirewallRulesInput {
                firewall_rule_group_id: self.firewall_rule_group_id,
                priority: self.priority,
                action: self.action,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListFirewallRulesInputOperationOutputAlias = crate::operation::ListFirewallRules;
#[doc(hidden)]
pub type ListFirewallRulesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListFirewallRulesInput {
    /// Consumes the builder and constructs an Operation<[`ListFirewallRules`](crate::operation::ListFirewallRules)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFirewallRules,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListFirewallRulesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListFirewallRulesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListFirewallRulesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.ListFirewallRules",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_firewall_rules(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListFirewallRules::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListFirewallRules",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListFirewallRulesInput`](crate::input::ListFirewallRulesInput)
    pub fn builder() -> crate::input::list_firewall_rules_input::Builder {
        crate::input::list_firewall_rules_input::Builder::default()
    }
}

/// See [`ListResolverConfigsInput`](crate::input::ListResolverConfigsInput)
pub mod list_resolver_configs_input {
    /// A builder for [`ListResolverConfigsInput`](crate::input::ListResolverConfigsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of Resolver configurations that you want to return in the response to
        /// a <code>ListResolverConfigs</code> request. If you don't specify a value for <code>MaxResults</code>,
        /// up to 100 Resolver configurations are returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of Resolver configurations that you want to return in the response to
        /// a <code>ListResolverConfigs</code> request. If you don't specify a value for <code>MaxResults</code>,
        /// up to 100 Resolver configurations are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>(Optional) If the current Amazon Web Services account has more than <code>MaxResults</code> Resolver configurations, use
        /// <code>NextToken</code> to get the second and subsequent pages of results.</p>
        /// <p>For the first <code>ListResolverConfigs</code> request, omit this value.</p>
        /// <p>For the second and subsequent requests, get the value of <code>NextToken</code> from the previous response and
        /// specify that value for <code>NextToken</code> in the request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>(Optional) If the current Amazon Web Services account has more than <code>MaxResults</code> Resolver configurations, use
        /// <code>NextToken</code> to get the second and subsequent pages of results.</p>
        /// <p>For the first <code>ListResolverConfigs</code> request, omit this value.</p>
        /// <p>For the second and subsequent requests, get the value of <code>NextToken</code> from the previous response and
        /// specify that value for <code>NextToken</code> in the request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResolverConfigsInput`](crate::input::ListResolverConfigsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListResolverConfigsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListResolverConfigsInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListResolverConfigsInputOperationOutputAlias = crate::operation::ListResolverConfigs;
#[doc(hidden)]
pub type ListResolverConfigsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListResolverConfigsInput {
    /// Consumes the builder and constructs an Operation<[`ListResolverConfigs`](crate::operation::ListResolverConfigs)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListResolverConfigs,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListResolverConfigsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListResolverConfigsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListResolverConfigsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.ListResolverConfigs",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_resolver_configs(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListResolverConfigs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListResolverConfigs",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListResolverConfigsInput`](crate::input::ListResolverConfigsInput)
    pub fn builder() -> crate::input::list_resolver_configs_input::Builder {
        crate::input::list_resolver_configs_input::Builder::default()
    }
}

/// See [`ListResolverDnssecConfigsInput`](crate::input::ListResolverDnssecConfigsInput)
pub mod list_resolver_dnssec_configs_input {
    /// A builder for [`ListResolverDnssecConfigsInput`](crate::input::ListResolverDnssecConfigsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    }
    impl Builder {
        /// <p>
        /// <i>Optional</i>: An integer that specifies the maximum number of DNSSEC configuration results that you want Amazon Route 53 to return.
        /// If you don't specify a value for <code>MaxResults</code>, Route 53 returns up to 100 configuration per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>
        /// <i>Optional</i>: An integer that specifies the maximum number of DNSSEC configuration results that you want Amazon Route 53 to return.
        /// If you don't specify a value for <code>MaxResults</code>, Route 53 returns up to 100 configuration per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>(Optional) If the current Amazon Web Services account has more than <code>MaxResults</code> DNSSEC configurations, use <code>NextToken</code>
        /// to get the second and subsequent pages of results.</p>
        /// <p>For the first <code>ListResolverDnssecConfigs</code> request, omit this value.</p>
        /// <p>For the second and subsequent requests, get the value of <code>NextToken</code> from the previous response and specify that value
        /// for <code>NextToken</code> in the request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>(Optional) If the current Amazon Web Services account has more than <code>MaxResults</code> DNSSEC configurations, use <code>NextToken</code>
        /// to get the second and subsequent pages of results.</p>
        /// <p>For the first <code>ListResolverDnssecConfigs</code> request, omit this value.</p>
        /// <p>For the second and subsequent requests, get the value of <code>NextToken</code> from the previous response and specify that value
        /// for <code>NextToken</code> in the request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An optional specification to return a subset of objects.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>An optional specification to return a subset of objects.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResolverDnssecConfigsInput`](crate::input::ListResolverDnssecConfigsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListResolverDnssecConfigsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListResolverDnssecConfigsInput {
                max_results: self.max_results,
                next_token: self.next_token,
                filters: self.filters,
            })
        }
    }
}
#[doc(hidden)]
pub type ListResolverDnssecConfigsInputOperationOutputAlias =
    crate::operation::ListResolverDnssecConfigs;
#[doc(hidden)]
pub type ListResolverDnssecConfigsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListResolverDnssecConfigsInput {
    /// Consumes the builder and constructs an Operation<[`ListResolverDnssecConfigs`](crate::operation::ListResolverDnssecConfigs)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListResolverDnssecConfigs,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListResolverDnssecConfigsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListResolverDnssecConfigsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListResolverDnssecConfigsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.ListResolverDnssecConfigs",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_resolver_dnssec_configs(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListResolverDnssecConfigs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListResolverDnssecConfigs",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListResolverDnssecConfigsInput`](crate::input::ListResolverDnssecConfigsInput)
    pub fn builder() -> crate::input::list_resolver_dnssec_configs_input::Builder {
        crate::input::list_resolver_dnssec_configs_input::Builder::default()
    }
}

/// See [`ListResolverEndpointIpAddressesInput`](crate::input::ListResolverEndpointIpAddressesInput)
pub mod list_resolver_endpoint_ip_addresses_input {
    /// A builder for [`ListResolverEndpointIpAddressesInput`](crate::input::ListResolverEndpointIpAddressesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resolver_endpoint_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Resolver endpoint that you want to get IP addresses for.</p>
        pub fn resolver_endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resolver_endpoint_id = Some(input.into());
            self
        }
        /// <p>The ID of the Resolver endpoint that you want to get IP addresses for.</p>
        pub fn set_resolver_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resolver_endpoint_id = input;
            self
        }
        /// <p>The maximum number of IP addresses that you want to return in the response to a <code>ListResolverEndpointIpAddresses</code> request.
        /// If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 IP addresses. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of IP addresses that you want to return in the response to a <code>ListResolverEndpointIpAddresses</code> request.
        /// If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 IP addresses. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>For the first <code>ListResolverEndpointIpAddresses</code> request, omit this value.</p>
        /// <p>If the specified Resolver endpoint has more than <code>MaxResults</code> IP addresses, you can submit another
        /// <code>ListResolverEndpointIpAddresses</code> request to get the next group of IP addresses. In the next request, specify the value of
        /// <code>NextToken</code> from the previous response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>For the first <code>ListResolverEndpointIpAddresses</code> request, omit this value.</p>
        /// <p>If the specified Resolver endpoint has more than <code>MaxResults</code> IP addresses, you can submit another
        /// <code>ListResolverEndpointIpAddresses</code> request to get the next group of IP addresses. In the next request, specify the value of
        /// <code>NextToken</code> from the previous response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResolverEndpointIpAddressesInput`](crate::input::ListResolverEndpointIpAddressesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListResolverEndpointIpAddressesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListResolverEndpointIpAddressesInput {
                resolver_endpoint_id: self.resolver_endpoint_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListResolverEndpointIpAddressesInputOperationOutputAlias =
    crate::operation::ListResolverEndpointIpAddresses;
#[doc(hidden)]
pub type ListResolverEndpointIpAddressesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListResolverEndpointIpAddressesInput {
    /// Consumes the builder and constructs an Operation<[`ListResolverEndpointIpAddresses`](crate::operation::ListResolverEndpointIpAddresses)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListResolverEndpointIpAddresses,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListResolverEndpointIpAddressesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListResolverEndpointIpAddressesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListResolverEndpointIpAddressesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.ListResolverEndpointIpAddresses",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_resolver_endpoint_ip_addresses(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListResolverEndpointIpAddresses::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListResolverEndpointIpAddresses",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListResolverEndpointIpAddressesInput`](crate::input::ListResolverEndpointIpAddressesInput)
    pub fn builder() -> crate::input::list_resolver_endpoint_ip_addresses_input::Builder {
        crate::input::list_resolver_endpoint_ip_addresses_input::Builder::default()
    }
}

/// See [`ListResolverEndpointsInput`](crate::input::ListResolverEndpointsInput)
pub mod list_resolver_endpoints_input {
    /// A builder for [`ListResolverEndpointsInput`](crate::input::ListResolverEndpointsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    }
    impl Builder {
        /// <p>The maximum number of Resolver endpoints that you want to return in the response to a <code>ListResolverEndpoints</code> request.
        /// If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 Resolver endpoints. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of Resolver endpoints that you want to return in the response to a <code>ListResolverEndpoints</code> request.
        /// If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 Resolver endpoints. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>For the first <code>ListResolverEndpoints</code> request, omit this value.</p>
        /// <p>If you have more than <code>MaxResults</code> Resolver endpoints, you can submit another <code>ListResolverEndpoints</code> request
        /// to get the next group of Resolver endpoints. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>For the first <code>ListResolverEndpoints</code> request, omit this value.</p>
        /// <p>If you have more than <code>MaxResults</code> Resolver endpoints, you can submit another <code>ListResolverEndpoints</code> request
        /// to get the next group of Resolver endpoints. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An optional specification to return a subset of Resolver endpoints, such as all inbound Resolver endpoints.</p>
        /// <note>
        /// <p>If you submit a second or subsequent <code>ListResolverEndpoints</code> request and specify the <code>NextToken</code> parameter,
        /// you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>
        /// </note>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>An optional specification to return a subset of Resolver endpoints, such as all inbound Resolver endpoints.</p>
        /// <note>
        /// <p>If you submit a second or subsequent <code>ListResolverEndpoints</code> request and specify the <code>NextToken</code> parameter,
        /// you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>
        /// </note>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResolverEndpointsInput`](crate::input::ListResolverEndpointsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListResolverEndpointsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListResolverEndpointsInput {
                max_results: self.max_results,
                next_token: self.next_token,
                filters: self.filters,
            })
        }
    }
}
#[doc(hidden)]
pub type ListResolverEndpointsInputOperationOutputAlias = crate::operation::ListResolverEndpoints;
#[doc(hidden)]
pub type ListResolverEndpointsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListResolverEndpointsInput {
    /// Consumes the builder and constructs an Operation<[`ListResolverEndpoints`](crate::operation::ListResolverEndpoints)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListResolverEndpoints,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListResolverEndpointsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListResolverEndpointsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListResolverEndpointsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.ListResolverEndpoints",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_resolver_endpoints(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListResolverEndpoints::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListResolverEndpoints",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListResolverEndpointsInput`](crate::input::ListResolverEndpointsInput)
    pub fn builder() -> crate::input::list_resolver_endpoints_input::Builder {
        crate::input::list_resolver_endpoints_input::Builder::default()
    }
}

/// See [`ListResolverQueryLogConfigAssociationsInput`](crate::input::ListResolverQueryLogConfigAssociationsInput)
pub mod list_resolver_query_log_config_associations_input {
    /// A builder for [`ListResolverQueryLogConfigAssociationsInput`](crate::input::ListResolverQueryLogConfigAssociationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) sort_by: std::option::Option<std::string::String>,
        pub(crate) sort_order: std::option::Option<crate::model::SortOrder>,
    }
    impl Builder {
        /// <p>The maximum number of query logging associations that you want to return in the response to a <code>ListResolverQueryLogConfigAssociations</code> request.
        /// If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 query logging associations. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of query logging associations that you want to return in the response to a <code>ListResolverQueryLogConfigAssociations</code> request.
        /// If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 query logging associations. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>For the first <code>ListResolverQueryLogConfigAssociations</code> request, omit this value.</p>
        /// <p>If there are more than <code>MaxResults</code> query logging associations that match the values that you specify for <code>Filters</code>,
        /// you can submit another <code>ListResolverQueryLogConfigAssociations</code> request to get the next group of associations. In the next request, specify the value of
        /// <code>NextToken</code> from the previous response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>For the first <code>ListResolverQueryLogConfigAssociations</code> request, omit this value.</p>
        /// <p>If there are more than <code>MaxResults</code> query logging associations that match the values that you specify for <code>Filters</code>,
        /// you can submit another <code>ListResolverQueryLogConfigAssociations</code> request to get the next group of associations. In the next request, specify the value of
        /// <code>NextToken</code> from the previous response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An optional specification to return a subset of query logging associations.</p>
        /// <note>
        /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigAssociations</code> request and specify the <code>NextToken</code> parameter,
        /// you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>
        /// </note>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>An optional specification to return a subset of query logging associations.</p>
        /// <note>
        /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigAssociations</code> request and specify the <code>NextToken</code> parameter,
        /// you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>
        /// </note>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The element that you want Resolver to sort query logging associations by. </p>
        /// <note>
        /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigAssociations</code> request and specify the <code>NextToken</code> parameter,
        /// you must use the same value for <code>SortBy</code>, if any, as in the previous request.</p>
        /// </note>
        ///
        /// <p>Valid values include the following elements:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CreationTime</code>: The ID of the query logging association.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Error</code>: If the value of <code>Status</code> is <code>FAILED</code>, the value of <code>Error</code>
        /// indicates the cause: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DESTINATION_NOT_FOUND</code>: The specified destination (for example, an Amazon S3 bucket) was deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACCESS_DENIED</code>: Permissions don't allow sending logs to the destination.</p>
        /// </li>
        /// </ul>
        /// <p>If <code>Status</code> is a value other than <code>FAILED</code>, <code>ERROR</code> is null.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Id</code>: The ID of the query logging association</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ResolverQueryLogConfigId</code>: The ID of the query logging configuration</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ResourceId</code>: The ID of the VPC that is associated with the query logging configuration</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Status</code>: The current status of the configuration. Valid values include the following:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATING</code>: Resolver is creating an association between an Amazon VPC and a query logging configuration.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATED</code>: The association between an Amazon VPC and a query logging configuration
        /// was successfully created. Resolver is logging queries that originate in the specified VPC.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETING</code>: Resolver is deleting this query logging association.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code>: Resolver either couldn't create or couldn't delete the query logging association.
        /// Here are two common causes:</p>
        /// <ul>
        /// <li>
        /// <p>The specified destination (for example, an Amazon S3 bucket) was deleted.</p>
        /// </li>
        /// <li>
        /// <p>Permissions don't allow sending logs to the destination.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn sort_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.sort_by = Some(input.into());
            self
        }
        /// <p>The element that you want Resolver to sort query logging associations by. </p>
        /// <note>
        /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigAssociations</code> request and specify the <code>NextToken</code> parameter,
        /// you must use the same value for <code>SortBy</code>, if any, as in the previous request.</p>
        /// </note>
        ///
        /// <p>Valid values include the following elements:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CreationTime</code>: The ID of the query logging association.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Error</code>: If the value of <code>Status</code> is <code>FAILED</code>, the value of <code>Error</code>
        /// indicates the cause: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DESTINATION_NOT_FOUND</code>: The specified destination (for example, an Amazon S3 bucket) was deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACCESS_DENIED</code>: Permissions don't allow sending logs to the destination.</p>
        /// </li>
        /// </ul>
        /// <p>If <code>Status</code> is a value other than <code>FAILED</code>, <code>ERROR</code> is null.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Id</code>: The ID of the query logging association</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ResolverQueryLogConfigId</code>: The ID of the query logging configuration</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ResourceId</code>: The ID of the VPC that is associated with the query logging configuration</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Status</code>: The current status of the configuration. Valid values include the following:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATING</code>: Resolver is creating an association between an Amazon VPC and a query logging configuration.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATED</code>: The association between an Amazon VPC and a query logging configuration
        /// was successfully created. Resolver is logging queries that originate in the specified VPC.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETING</code>: Resolver is deleting this query logging association.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code>: Resolver either couldn't create or couldn't delete the query logging association.
        /// Here are two common causes:</p>
        /// <ul>
        /// <li>
        /// <p>The specified destination (for example, an Amazon S3 bucket) was deleted.</p>
        /// </li>
        /// <li>
        /// <p>Permissions don't allow sending logs to the destination.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn set_sort_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sort_by = input;
            self
        }
        /// <p>If you specified a value for <code>SortBy</code>, the order that you want query logging associations to be listed in,
        /// <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
        /// <note>
        /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigAssociations</code> request and specify the <code>NextToken</code> parameter,
        /// you must use the same value for <code>SortOrder</code>, if any, as in the previous request.</p>
        /// </note>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.sort_order = Some(input);
            self
        }
        /// <p>If you specified a value for <code>SortBy</code>, the order that you want query logging associations to be listed in,
        /// <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
        /// <note>
        /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigAssociations</code> request and specify the <code>NextToken</code> parameter,
        /// you must use the same value for <code>SortOrder</code>, if any, as in the previous request.</p>
        /// </note>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.sort_order = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResolverQueryLogConfigAssociationsInput`](crate::input::ListResolverQueryLogConfigAssociationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListResolverQueryLogConfigAssociationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListResolverQueryLogConfigAssociationsInput {
                max_results: self.max_results,
                next_token: self.next_token,
                filters: self.filters,
                sort_by: self.sort_by,
                sort_order: self.sort_order,
            })
        }
    }
}
#[doc(hidden)]
pub type ListResolverQueryLogConfigAssociationsInputOperationOutputAlias =
    crate::operation::ListResolverQueryLogConfigAssociations;
#[doc(hidden)]
pub type ListResolverQueryLogConfigAssociationsInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl ListResolverQueryLogConfigAssociationsInput {
    /// Consumes the builder and constructs an Operation<[`ListResolverQueryLogConfigAssociations`](crate::operation::ListResolverQueryLogConfigAssociations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListResolverQueryLogConfigAssociations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListResolverQueryLogConfigAssociationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListResolverQueryLogConfigAssociationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListResolverQueryLogConfigAssociationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.ListResolverQueryLogConfigAssociations",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_resolver_query_log_config_associations(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListResolverQueryLogConfigAssociations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListResolverQueryLogConfigAssociations",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListResolverQueryLogConfigAssociationsInput`](crate::input::ListResolverQueryLogConfigAssociationsInput)
    pub fn builder() -> crate::input::list_resolver_query_log_config_associations_input::Builder {
        crate::input::list_resolver_query_log_config_associations_input::Builder::default()
    }
}

/// See [`ListResolverQueryLogConfigsInput`](crate::input::ListResolverQueryLogConfigsInput)
pub mod list_resolver_query_log_configs_input {
    /// A builder for [`ListResolverQueryLogConfigsInput`](crate::input::ListResolverQueryLogConfigsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) sort_by: std::option::Option<std::string::String>,
        pub(crate) sort_order: std::option::Option<crate::model::SortOrder>,
    }
    impl Builder {
        /// <p>The maximum number of query logging configurations that you want to return in the response to a <code>ListResolverQueryLogConfigs</code> request.
        /// If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 query logging configurations. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of query logging configurations that you want to return in the response to a <code>ListResolverQueryLogConfigs</code> request.
        /// If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 query logging configurations. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>For the first <code>ListResolverQueryLogConfigs</code> request, omit this value.</p>
        /// <p>If there are more than <code>MaxResults</code> query logging configurations that match the values that you specify for <code>Filters</code>,
        /// you can submit another <code>ListResolverQueryLogConfigs</code> request to get the next group of configurations. In the next request, specify the value of
        /// <code>NextToken</code> from the previous response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>For the first <code>ListResolverQueryLogConfigs</code> request, omit this value.</p>
        /// <p>If there are more than <code>MaxResults</code> query logging configurations that match the values that you specify for <code>Filters</code>,
        /// you can submit another <code>ListResolverQueryLogConfigs</code> request to get the next group of configurations. In the next request, specify the value of
        /// <code>NextToken</code> from the previous response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An optional specification to return a subset of query logging configurations.</p>
        /// <note>
        /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the <code>NextToken</code> parameter,
        /// you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>
        /// </note>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>An optional specification to return a subset of query logging configurations.</p>
        /// <note>
        /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the <code>NextToken</code> parameter,
        /// you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>
        /// </note>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The element that you want Resolver to sort query logging configurations by. </p>
        /// <note>
        /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the <code>NextToken</code> parameter,
        /// you must use the same value for <code>SortBy</code>, if any, as in the previous request.</p>
        /// </note>
        ///
        /// <p>Valid values include the following elements:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Arn</code>: The ARN of the query logging configuration</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AssociationCount</code>: The number of VPCs that are associated with the specified configuration </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CreationTime</code>: The date and time that Resolver returned when the configuration was created</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CreatorRequestId</code>: The value that was specified for <code>CreatorRequestId</code> when the configuration was created</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DestinationArn</code>: The location that logs are sent to</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Id</code>: The ID of the configuration</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Name</code>: The name of the configuration</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OwnerId</code>: The Amazon Web Services account number of the account that created the configuration</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ShareStatus</code>: Whether the configuration is shared with other Amazon Web Services accounts or shared with the current account by
        /// another Amazon Web Services account. Sharing is configured through Resource Access Manager (RAM).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Status</code>: The current status of the configuration. Valid values include the following:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATING</code>: Resolver is creating the query logging configuration.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATED</code>: The query logging configuration was successfully created.
        /// Resolver is logging queries that originate in the specified VPC.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETING</code>: Resolver is deleting this query logging configuration.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code>: Resolver either couldn't create or couldn't delete the query logging configuration.
        /// Here are two common causes:</p>
        /// <ul>
        /// <li>
        /// <p>The specified destination (for example, an Amazon S3 bucket) was deleted.</p>
        /// </li>
        /// <li>
        /// <p>Permissions don't allow sending logs to the destination.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn sort_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.sort_by = Some(input.into());
            self
        }
        /// <p>The element that you want Resolver to sort query logging configurations by. </p>
        /// <note>
        /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the <code>NextToken</code> parameter,
        /// you must use the same value for <code>SortBy</code>, if any, as in the previous request.</p>
        /// </note>
        ///
        /// <p>Valid values include the following elements:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Arn</code>: The ARN of the query logging configuration</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AssociationCount</code>: The number of VPCs that are associated with the specified configuration </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CreationTime</code>: The date and time that Resolver returned when the configuration was created</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CreatorRequestId</code>: The value that was specified for <code>CreatorRequestId</code> when the configuration was created</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DestinationArn</code>: The location that logs are sent to</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Id</code>: The ID of the configuration</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Name</code>: The name of the configuration</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OwnerId</code>: The Amazon Web Services account number of the account that created the configuration</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ShareStatus</code>: Whether the configuration is shared with other Amazon Web Services accounts or shared with the current account by
        /// another Amazon Web Services account. Sharing is configured through Resource Access Manager (RAM).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Status</code>: The current status of the configuration. Valid values include the following:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATING</code>: Resolver is creating the query logging configuration.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATED</code>: The query logging configuration was successfully created.
        /// Resolver is logging queries that originate in the specified VPC.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETING</code>: Resolver is deleting this query logging configuration.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code>: Resolver either couldn't create or couldn't delete the query logging configuration.
        /// Here are two common causes:</p>
        /// <ul>
        /// <li>
        /// <p>The specified destination (for example, an Amazon S3 bucket) was deleted.</p>
        /// </li>
        /// <li>
        /// <p>Permissions don't allow sending logs to the destination.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn set_sort_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sort_by = input;
            self
        }
        /// <p>If you specified a value for <code>SortBy</code>, the order that you want query logging configurations to be listed in,
        /// <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
        /// <note>
        /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the <code>NextToken</code> parameter,
        /// you must use the same value for <code>SortOrder</code>, if any, as in the previous request.</p>
        /// </note>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.sort_order = Some(input);
            self
        }
        /// <p>If you specified a value for <code>SortBy</code>, the order that you want query logging configurations to be listed in,
        /// <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
        /// <note>
        /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the <code>NextToken</code> parameter,
        /// you must use the same value for <code>SortOrder</code>, if any, as in the previous request.</p>
        /// </note>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.sort_order = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResolverQueryLogConfigsInput`](crate::input::ListResolverQueryLogConfigsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListResolverQueryLogConfigsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListResolverQueryLogConfigsInput {
                max_results: self.max_results,
                next_token: self.next_token,
                filters: self.filters,
                sort_by: self.sort_by,
                sort_order: self.sort_order,
            })
        }
    }
}
#[doc(hidden)]
pub type ListResolverQueryLogConfigsInputOperationOutputAlias =
    crate::operation::ListResolverQueryLogConfigs;
#[doc(hidden)]
pub type ListResolverQueryLogConfigsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListResolverQueryLogConfigsInput {
    /// Consumes the builder and constructs an Operation<[`ListResolverQueryLogConfigs`](crate::operation::ListResolverQueryLogConfigs)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListResolverQueryLogConfigs,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListResolverQueryLogConfigsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListResolverQueryLogConfigsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListResolverQueryLogConfigsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.ListResolverQueryLogConfigs",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_resolver_query_log_configs(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListResolverQueryLogConfigs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListResolverQueryLogConfigs",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListResolverQueryLogConfigsInput`](crate::input::ListResolverQueryLogConfigsInput)
    pub fn builder() -> crate::input::list_resolver_query_log_configs_input::Builder {
        crate::input::list_resolver_query_log_configs_input::Builder::default()
    }
}

/// See [`ListResolverRuleAssociationsInput`](crate::input::ListResolverRuleAssociationsInput)
pub mod list_resolver_rule_associations_input {
    /// A builder for [`ListResolverRuleAssociationsInput`](crate::input::ListResolverRuleAssociationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    }
    impl Builder {
        /// <p>The maximum number of rule associations that you want to return in the response to a <code>ListResolverRuleAssociations</code> request.
        /// If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 rule associations. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of rule associations that you want to return in the response to a <code>ListResolverRuleAssociations</code> request.
        /// If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 rule associations. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>For the first <code>ListResolverRuleAssociation</code> request, omit this value.</p>
        /// <p>If you have more than <code>MaxResults</code> rule associations, you can submit another <code>ListResolverRuleAssociation</code> request
        /// to get the next group of rule associations. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>For the first <code>ListResolverRuleAssociation</code> request, omit this value.</p>
        /// <p>If you have more than <code>MaxResults</code> rule associations, you can submit another <code>ListResolverRuleAssociation</code> request
        /// to get the next group of rule associations. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An optional specification to return a subset of Resolver rules, such as Resolver rules that are associated with the same VPC ID.</p>
        /// <note>
        /// <p>If you submit a second or subsequent <code>ListResolverRuleAssociations</code> request and specify the <code>NextToken</code> parameter,
        /// you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>
        /// </note>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>An optional specification to return a subset of Resolver rules, such as Resolver rules that are associated with the same VPC ID.</p>
        /// <note>
        /// <p>If you submit a second or subsequent <code>ListResolverRuleAssociations</code> request and specify the <code>NextToken</code> parameter,
        /// you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>
        /// </note>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResolverRuleAssociationsInput`](crate::input::ListResolverRuleAssociationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListResolverRuleAssociationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListResolverRuleAssociationsInput {
                max_results: self.max_results,
                next_token: self.next_token,
                filters: self.filters,
            })
        }
    }
}
#[doc(hidden)]
pub type ListResolverRuleAssociationsInputOperationOutputAlias =
    crate::operation::ListResolverRuleAssociations;
#[doc(hidden)]
pub type ListResolverRuleAssociationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListResolverRuleAssociationsInput {
    /// Consumes the builder and constructs an Operation<[`ListResolverRuleAssociations`](crate::operation::ListResolverRuleAssociations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListResolverRuleAssociations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListResolverRuleAssociationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListResolverRuleAssociationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListResolverRuleAssociationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.ListResolverRuleAssociations",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_resolver_rule_associations(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListResolverRuleAssociations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListResolverRuleAssociations",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListResolverRuleAssociationsInput`](crate::input::ListResolverRuleAssociationsInput)
    pub fn builder() -> crate::input::list_resolver_rule_associations_input::Builder {
        crate::input::list_resolver_rule_associations_input::Builder::default()
    }
}

/// See [`ListResolverRulesInput`](crate::input::ListResolverRulesInput)
pub mod list_resolver_rules_input {
    /// A builder for [`ListResolverRulesInput`](crate::input::ListResolverRulesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    }
    impl Builder {
        /// <p>The maximum number of Resolver rules that you want to return in the response to a <code>ListResolverRules</code> request.
        /// If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 Resolver rules.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of Resolver rules that you want to return in the response to a <code>ListResolverRules</code> request.
        /// If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 Resolver rules.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>For the first <code>ListResolverRules</code> request, omit this value.</p>
        /// <p>If you have more than <code>MaxResults</code> Resolver rules, you can submit another <code>ListResolverRules</code> request
        /// to get the next group of Resolver rules. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>For the first <code>ListResolverRules</code> request, omit this value.</p>
        /// <p>If you have more than <code>MaxResults</code> Resolver rules, you can submit another <code>ListResolverRules</code> request
        /// to get the next group of Resolver rules. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An optional specification to return a subset of Resolver rules, such as all Resolver rules that are associated with the same Resolver endpoint.</p>
        /// <note>
        /// <p>If you submit a second or subsequent <code>ListResolverRules</code> request and specify the <code>NextToken</code> parameter,
        /// you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>
        /// </note>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>An optional specification to return a subset of Resolver rules, such as all Resolver rules that are associated with the same Resolver endpoint.</p>
        /// <note>
        /// <p>If you submit a second or subsequent <code>ListResolverRules</code> request and specify the <code>NextToken</code> parameter,
        /// you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>
        /// </note>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResolverRulesInput`](crate::input::ListResolverRulesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListResolverRulesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListResolverRulesInput {
                max_results: self.max_results,
                next_token: self.next_token,
                filters: self.filters,
            })
        }
    }
}
#[doc(hidden)]
pub type ListResolverRulesInputOperationOutputAlias = crate::operation::ListResolverRules;
#[doc(hidden)]
pub type ListResolverRulesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListResolverRulesInput {
    /// Consumes the builder and constructs an Operation<[`ListResolverRules`](crate::operation::ListResolverRules)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListResolverRules,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListResolverRulesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListResolverRulesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListResolverRulesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.ListResolverRules",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_resolver_rules(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListResolverRules::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListResolverRules",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListResolverRulesInput`](crate::input::ListResolverRulesInput)
    pub fn builder() -> crate::input::list_resolver_rules_input::Builder {
        crate::input::list_resolver_rules_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the resource that you want to list tags for.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the resource that you want to list tags for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The maximum number of tags that you want to return in the response to a <code>ListTagsForResource</code> request.
        /// If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 tags.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of tags that you want to return in the response to a <code>ListTagsForResource</code> request.
        /// If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 tags.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>For the first <code>ListTagsForResource</code> request, omit this value.</p>
        /// <p>If you have more than <code>MaxResults</code> tags, you can submit another <code>ListTagsForResource</code> request
        /// to get the next group of tags for the resource. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>For the first <code>ListTagsForResource</code> request, omit this value.</p>
        /// <p>If you have more than <code>MaxResults</code> tags, you can submit another <code>ListTagsForResource</code> request
        /// to get the next group of tags for the resource. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.ListTagsForResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`PutFirewallRuleGroupPolicyInput`](crate::input::PutFirewallRuleGroupPolicyInput)
pub mod put_firewall_rule_group_policy_input {
    /// A builder for [`PutFirewallRuleGroupPolicyInput`](crate::input::PutFirewallRuleGroupPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) firewall_rule_group_policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN (Amazon Resource Name) for the rule group that you want to share.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN (Amazon Resource Name) for the rule group that you want to share.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The Identity and Access Management (Amazon Web Services IAM) policy to attach to the rule group.</p>
        pub fn firewall_rule_group_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_rule_group_policy = Some(input.into());
            self
        }
        /// <p>The Identity and Access Management (Amazon Web Services IAM) policy to attach to the rule group.</p>
        pub fn set_firewall_rule_group_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firewall_rule_group_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`PutFirewallRuleGroupPolicyInput`](crate::input::PutFirewallRuleGroupPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutFirewallRuleGroupPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutFirewallRuleGroupPolicyInput {
                arn: self.arn,
                firewall_rule_group_policy: self.firewall_rule_group_policy,
            })
        }
    }
}
#[doc(hidden)]
pub type PutFirewallRuleGroupPolicyInputOperationOutputAlias =
    crate::operation::PutFirewallRuleGroupPolicy;
#[doc(hidden)]
pub type PutFirewallRuleGroupPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutFirewallRuleGroupPolicyInput {
    /// Consumes the builder and constructs an Operation<[`PutFirewallRuleGroupPolicy`](crate::operation::PutFirewallRuleGroupPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutFirewallRuleGroupPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutFirewallRuleGroupPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutFirewallRuleGroupPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutFirewallRuleGroupPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.PutFirewallRuleGroupPolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_firewall_rule_group_policy(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutFirewallRuleGroupPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutFirewallRuleGroupPolicy",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutFirewallRuleGroupPolicyInput`](crate::input::PutFirewallRuleGroupPolicyInput)
    pub fn builder() -> crate::input::put_firewall_rule_group_policy_input::Builder {
        crate::input::put_firewall_rule_group_policy_input::Builder::default()
    }
}

/// See [`PutResolverQueryLogConfigPolicyInput`](crate::input::PutResolverQueryLogConfigPolicyInput)
pub mod put_resolver_query_log_config_policy_input {
    /// A builder for [`PutResolverQueryLogConfigPolicyInput`](crate::input::PutResolverQueryLogConfigPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) resolver_query_log_config_policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the account that you want to share rules with.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the account that you want to share rules with.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>An Identity and Access Management policy statement that lists the query logging configurations that you want to share with another Amazon Web Services account
        /// and the operations that you want the account to be able to perform. You can specify the following operations in the <code>Actions</code> section
        /// of the statement:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>route53resolver:AssociateResolverQueryLogConfig</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>route53resolver:DisassociateResolverQueryLogConfig</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>route53resolver:ListResolverQueryLogConfigAssociations</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>route53resolver:ListResolverQueryLogConfigs</code>
        /// </p>
        /// </li>
        /// </ul>
        ///
        /// <p>In the <code>Resource</code> section of the statement, you specify the ARNs for the query logging configurations that you want to share
        /// with the account that you specified in <code>Arn</code>. </p>
        pub fn resolver_query_log_config_policy(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.resolver_query_log_config_policy = Some(input.into());
            self
        }
        /// <p>An Identity and Access Management policy statement that lists the query logging configurations that you want to share with another Amazon Web Services account
        /// and the operations that you want the account to be able to perform. You can specify the following operations in the <code>Actions</code> section
        /// of the statement:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>route53resolver:AssociateResolverQueryLogConfig</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>route53resolver:DisassociateResolverQueryLogConfig</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>route53resolver:ListResolverQueryLogConfigAssociations</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>route53resolver:ListResolverQueryLogConfigs</code>
        /// </p>
        /// </li>
        /// </ul>
        ///
        /// <p>In the <code>Resource</code> section of the statement, you specify the ARNs for the query logging configurations that you want to share
        /// with the account that you specified in <code>Arn</code>. </p>
        pub fn set_resolver_query_log_config_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resolver_query_log_config_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`PutResolverQueryLogConfigPolicyInput`](crate::input::PutResolverQueryLogConfigPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutResolverQueryLogConfigPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutResolverQueryLogConfigPolicyInput {
                arn: self.arn,
                resolver_query_log_config_policy: self.resolver_query_log_config_policy,
            })
        }
    }
}
#[doc(hidden)]
pub type PutResolverQueryLogConfigPolicyInputOperationOutputAlias =
    crate::operation::PutResolverQueryLogConfigPolicy;
#[doc(hidden)]
pub type PutResolverQueryLogConfigPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutResolverQueryLogConfigPolicyInput {
    /// Consumes the builder and constructs an Operation<[`PutResolverQueryLogConfigPolicy`](crate::operation::PutResolverQueryLogConfigPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutResolverQueryLogConfigPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutResolverQueryLogConfigPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutResolverQueryLogConfigPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutResolverQueryLogConfigPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.PutResolverQueryLogConfigPolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_resolver_query_log_config_policy(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutResolverQueryLogConfigPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutResolverQueryLogConfigPolicy",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutResolverQueryLogConfigPolicyInput`](crate::input::PutResolverQueryLogConfigPolicyInput)
    pub fn builder() -> crate::input::put_resolver_query_log_config_policy_input::Builder {
        crate::input::put_resolver_query_log_config_policy_input::Builder::default()
    }
}

/// See [`PutResolverRulePolicyInput`](crate::input::PutResolverRulePolicyInput)
pub mod put_resolver_rule_policy_input {
    /// A builder for [`PutResolverRulePolicyInput`](crate::input::PutResolverRulePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) resolver_rule_policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the rule that you want to share with another account.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the rule that you want to share with another account.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>An Identity and Access Management policy statement that lists the rules that you want to share with another Amazon Web Services account and the operations that you want the account
        /// to be able to perform. You can specify the following operations in the <code>Action</code> section of the statement:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>route53resolver:GetResolverRule</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>route53resolver:AssociateResolverRule</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>route53resolver:DisassociateResolverRule</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>route53resolver:ListResolverRules</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>route53resolver:ListResolverRuleAssociations</code>
        /// </p>
        /// </li>
        /// </ul>
        ///
        /// <p>In the <code>Resource</code> section of the statement, specify the ARN for the rule that you want to share with another account. Specify the same ARN
        /// that you specified in <code>Arn</code>.</p>
        pub fn resolver_rule_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.resolver_rule_policy = Some(input.into());
            self
        }
        /// <p>An Identity and Access Management policy statement that lists the rules that you want to share with another Amazon Web Services account and the operations that you want the account
        /// to be able to perform. You can specify the following operations in the <code>Action</code> section of the statement:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>route53resolver:GetResolverRule</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>route53resolver:AssociateResolverRule</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>route53resolver:DisassociateResolverRule</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>route53resolver:ListResolverRules</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>route53resolver:ListResolverRuleAssociations</code>
        /// </p>
        /// </li>
        /// </ul>
        ///
        /// <p>In the <code>Resource</code> section of the statement, specify the ARN for the rule that you want to share with another account. Specify the same ARN
        /// that you specified in <code>Arn</code>.</p>
        pub fn set_resolver_rule_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resolver_rule_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`PutResolverRulePolicyInput`](crate::input::PutResolverRulePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutResolverRulePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutResolverRulePolicyInput {
                arn: self.arn,
                resolver_rule_policy: self.resolver_rule_policy,
            })
        }
    }
}
#[doc(hidden)]
pub type PutResolverRulePolicyInputOperationOutputAlias = crate::operation::PutResolverRulePolicy;
#[doc(hidden)]
pub type PutResolverRulePolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutResolverRulePolicyInput {
    /// Consumes the builder and constructs an Operation<[`PutResolverRulePolicy`](crate::operation::PutResolverRulePolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutResolverRulePolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutResolverRulePolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutResolverRulePolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutResolverRulePolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.PutResolverRulePolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_resolver_rule_policy(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutResolverRulePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutResolverRulePolicy",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutResolverRulePolicyInput`](crate::input::PutResolverRulePolicyInput)
    pub fn builder() -> crate::input::put_resolver_rule_policy_input::Builder {
        crate::input::put_resolver_rule_policy_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the resource that you want to add tags to. To get the ARN for a resource, use the applicable
        /// <code>Get</code> or <code>List</code> command: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html">GetResolverEndpoint</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRule.html">GetResolverRule</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRuleAssociation.html">GetResolverRuleAssociation</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html">ListResolverEndpoints</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html">ListResolverRuleAssociations</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html">ListResolverRules</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the resource that you want to add tags to. To get the ARN for a resource, use the applicable
        /// <code>Get</code> or <code>List</code> command: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html">GetResolverEndpoint</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRule.html">GetResolverRule</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRuleAssociation.html">GetResolverRuleAssociation</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html">ListResolverEndpoints</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html">ListResolverRuleAssociations</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html">ListResolverRules</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags that you want to add to the specified resource.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags that you want to add to the specified resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.TagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the resource that you want to remove tags from. To get the ARN for a resource, use the applicable
        /// <code>Get</code> or <code>List</code> command: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html">GetResolverEndpoint</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRule.html">GetResolverRule</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRuleAssociation.html">GetResolverRuleAssociation</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html">ListResolverEndpoints</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html">ListResolverRuleAssociations</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html">ListResolverRules</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the resource that you want to remove tags from. To get the ARN for a resource, use the applicable
        /// <code>Get</code> or <code>List</code> command: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html">GetResolverEndpoint</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRule.html">GetResolverRule</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRuleAssociation.html">GetResolverRuleAssociation</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html">ListResolverEndpoints</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html">ListResolverRuleAssociations</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html">ListResolverRules</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tags that you want to remove to the specified resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The tags that you want to remove to the specified resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.UntagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateFirewallConfigInput`](crate::input::UpdateFirewallConfigInput)
pub mod update_firewall_config_input {
    /// A builder for [`UpdateFirewallConfigInput`](crate::input::UpdateFirewallConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) firewall_fail_open: std::option::Option<crate::model::FirewallFailOpenStatus>,
    }
    impl Builder {
        /// <p>The ID of the VPC that the configuration is for.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC that the configuration is for.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>Determines how Route 53 Resolver handles queries during failures, for example when all traffic that is sent to DNS Firewall fails to receive a reply. </p>
        /// <ul>
        /// <li>
        /// <p>By default, fail open is disabled, which means the failure mode is closed. This approach favors security over availability.
        /// DNS Firewall blocks queries that it is unable to evaluate properly. </p>
        /// </li>
        /// <li>
        /// <p>If you enable this option, the failure mode is open. This approach favors availability over security. DNS Firewall allows queries to proceed if it
        /// is unable to properly evaluate them. </p>
        /// </li>
        /// </ul>
        /// <p>This behavior is only enforced for VPCs that have at least one DNS Firewall rule group association. </p>
        pub fn firewall_fail_open(mut self, input: crate::model::FirewallFailOpenStatus) -> Self {
            self.firewall_fail_open = Some(input);
            self
        }
        /// <p>Determines how Route 53 Resolver handles queries during failures, for example when all traffic that is sent to DNS Firewall fails to receive a reply. </p>
        /// <ul>
        /// <li>
        /// <p>By default, fail open is disabled, which means the failure mode is closed. This approach favors security over availability.
        /// DNS Firewall blocks queries that it is unable to evaluate properly. </p>
        /// </li>
        /// <li>
        /// <p>If you enable this option, the failure mode is open. This approach favors availability over security. DNS Firewall allows queries to proceed if it
        /// is unable to properly evaluate them. </p>
        /// </li>
        /// </ul>
        /// <p>This behavior is only enforced for VPCs that have at least one DNS Firewall rule group association. </p>
        pub fn set_firewall_fail_open(
            mut self,
            input: std::option::Option<crate::model::FirewallFailOpenStatus>,
        ) -> Self {
            self.firewall_fail_open = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFirewallConfigInput`](crate::input::UpdateFirewallConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateFirewallConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateFirewallConfigInput {
                resource_id: self.resource_id,
                firewall_fail_open: self.firewall_fail_open,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateFirewallConfigInputOperationOutputAlias = crate::operation::UpdateFirewallConfig;
#[doc(hidden)]
pub type UpdateFirewallConfigInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateFirewallConfigInput {
    /// Consumes the builder and constructs an Operation<[`UpdateFirewallConfig`](crate::operation::UpdateFirewallConfig)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateFirewallConfig,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateFirewallConfigInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateFirewallConfigInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateFirewallConfigInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.UpdateFirewallConfig",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_firewall_config(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateFirewallConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateFirewallConfig",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateFirewallConfigInput`](crate::input::UpdateFirewallConfigInput)
    pub fn builder() -> crate::input::update_firewall_config_input::Builder {
        crate::input::update_firewall_config_input::Builder::default()
    }
}

/// See [`UpdateFirewallDomainsInput`](crate::input::UpdateFirewallDomainsInput)
pub mod update_firewall_domains_input {
    /// A builder for [`UpdateFirewallDomainsInput`](crate::input::UpdateFirewallDomainsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_domain_list_id: std::option::Option<std::string::String>,
        pub(crate) operation: std::option::Option<crate::model::FirewallDomainUpdateOperation>,
        pub(crate) domains: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ID of the domain list whose domains you want to update. </p>
        pub fn firewall_domain_list_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_domain_list_id = Some(input.into());
            self
        }
        /// <p>The ID of the domain list whose domains you want to update. </p>
        pub fn set_firewall_domain_list_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firewall_domain_list_id = input;
            self
        }
        /// <p>What you want DNS Firewall to do with the domains that you are providing: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ADD</code> - Add the domains to the ones that are already in the domain list. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REMOVE</code> - Search the domain list for the domains and remove them from the list.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REPLACE</code> - Update the domain list to exactly match the list that you are providing. </p>
        /// </li>
        /// </ul>
        pub fn operation(mut self, input: crate::model::FirewallDomainUpdateOperation) -> Self {
            self.operation = Some(input);
            self
        }
        /// <p>What you want DNS Firewall to do with the domains that you are providing: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ADD</code> - Add the domains to the ones that are already in the domain list. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REMOVE</code> - Search the domain list for the domains and remove them from the list.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REPLACE</code> - Update the domain list to exactly match the list that you are providing. </p>
        /// </li>
        /// </ul>
        pub fn set_operation(
            mut self,
            input: std::option::Option<crate::model::FirewallDomainUpdateOperation>,
        ) -> Self {
            self.operation = input;
            self
        }
        /// Appends an item to `domains`.
        ///
        /// To override the contents of this collection use [`set_domains`](Self::set_domains).
        ///
        /// <p>A list of domains to use in the update operation.</p>
        /// <p>Each domain specification in your domain list must satisfy the following
        /// requirements: </p>
        /// <ul>
        /// <li>
        /// <p>It can optionally start with <code>*</code> (asterisk).</p>
        /// </li>
        /// <li>
        /// <p>With the exception of the optional starting asterisk, it must only contain
        /// the following characters: <code>A-Z</code>, <code>a-z</code>,
        /// <code>0-9</code>, <code>-</code> (hyphen).</p>
        /// </li>
        /// <li>
        /// <p>It must be from 1-255 characters in length. </p>
        /// </li>
        /// </ul>
        pub fn domains(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.domains.unwrap_or_default();
            v.push(input.into());
            self.domains = Some(v);
            self
        }
        /// <p>A list of domains to use in the update operation.</p>
        /// <p>Each domain specification in your domain list must satisfy the following
        /// requirements: </p>
        /// <ul>
        /// <li>
        /// <p>It can optionally start with <code>*</code> (asterisk).</p>
        /// </li>
        /// <li>
        /// <p>With the exception of the optional starting asterisk, it must only contain
        /// the following characters: <code>A-Z</code>, <code>a-z</code>,
        /// <code>0-9</code>, <code>-</code> (hyphen).</p>
        /// </li>
        /// <li>
        /// <p>It must be from 1-255 characters in length. </p>
        /// </li>
        /// </ul>
        pub fn set_domains(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.domains = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFirewallDomainsInput`](crate::input::UpdateFirewallDomainsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateFirewallDomainsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateFirewallDomainsInput {
                firewall_domain_list_id: self.firewall_domain_list_id,
                operation: self.operation,
                domains: self.domains,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateFirewallDomainsInputOperationOutputAlias = crate::operation::UpdateFirewallDomains;
#[doc(hidden)]
pub type UpdateFirewallDomainsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateFirewallDomainsInput {
    /// Consumes the builder and constructs an Operation<[`UpdateFirewallDomains`](crate::operation::UpdateFirewallDomains)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateFirewallDomains,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateFirewallDomainsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateFirewallDomainsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateFirewallDomainsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.UpdateFirewallDomains",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_firewall_domains(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateFirewallDomains::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateFirewallDomains",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateFirewallDomainsInput`](crate::input::UpdateFirewallDomainsInput)
    pub fn builder() -> crate::input::update_firewall_domains_input::Builder {
        crate::input::update_firewall_domains_input::Builder::default()
    }
}

/// See [`UpdateFirewallRuleInput`](crate::input::UpdateFirewallRuleInput)
pub mod update_firewall_rule_input {
    /// A builder for [`UpdateFirewallRuleInput`](crate::input::UpdateFirewallRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_rule_group_id: std::option::Option<std::string::String>,
        pub(crate) firewall_domain_list_id: std::option::Option<std::string::String>,
        pub(crate) priority: std::option::Option<i32>,
        pub(crate) action: std::option::Option<crate::model::Action>,
        pub(crate) block_response: std::option::Option<crate::model::BlockResponse>,
        pub(crate) block_override_domain: std::option::Option<std::string::String>,
        pub(crate) block_override_dns_type: std::option::Option<crate::model::BlockOverrideDnsType>,
        pub(crate) block_override_ttl: std::option::Option<i32>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the firewall rule group for the rule. </p>
        pub fn firewall_rule_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_rule_group_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the firewall rule group for the rule. </p>
        pub fn set_firewall_rule_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firewall_rule_group_id = input;
            self
        }
        /// <p>The ID of the domain list to use in the rule.  </p>
        pub fn firewall_domain_list_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_domain_list_id = Some(input.into());
            self
        }
        /// <p>The ID of the domain list to use in the rule.  </p>
        pub fn set_firewall_domain_list_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firewall_domain_list_id = input;
            self
        }
        /// <p>The setting that determines the processing order of the rule in the rule group. DNS Firewall
        /// processes the rules in a rule group by order of priority, starting from the lowest setting.</p>
        /// <p>You must specify a unique priority for each rule in a rule group.
        /// To make it easier to insert rules later, leave space between the numbers, for example, use 100, 200, and so on. You
        /// can change the priority setting for the rules in a rule group at any time.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.priority = Some(input);
            self
        }
        /// <p>The setting that determines the processing order of the rule in the rule group. DNS Firewall
        /// processes the rules in a rule group by order of priority, starting from the lowest setting.</p>
        /// <p>You must specify a unique priority for each rule in a rule group.
        /// To make it easier to insert rules later, leave space between the numbers, for example, use 100, 200, and so on. You
        /// can change the priority setting for the rules in a rule group at any time.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.priority = input;
            self
        }
        /// <p>The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALLOW</code> - Permit the request to go through.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALERT</code> - Permit the request to go through but send an alert to the logs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BLOCK</code> - Disallow the request. This option requires additional details in the rule's <code>BlockResponse</code>. </p>
        /// </li>
        /// </ul>
        pub fn action(mut self, input: crate::model::Action) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALLOW</code> - Permit the request to go through.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALERT</code> - Permit the request to go through but send an alert to the logs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BLOCK</code> - Disallow the request. This option requires additional details in the rule's <code>BlockResponse</code>. </p>
        /// </li>
        /// </ul>
        pub fn set_action(mut self, input: std::option::Option<crate::model::Action>) -> Self {
            self.action = input;
            self
        }
        /// <p>The way that you want DNS Firewall to block the request. Used for the rule action setting <code>BLOCK</code>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NODATA</code> - Respond indicating that the query was successful, but no response is available for it.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NXDOMAIN</code> - Respond indicating that the domain name that's in the query doesn't exist.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OVERRIDE</code> - Provide a custom override in the response. This option requires custom handling details in the rule's <code>BlockOverride*</code> settings. </p>
        /// </li>
        /// </ul>
        pub fn block_response(mut self, input: crate::model::BlockResponse) -> Self {
            self.block_response = Some(input);
            self
        }
        /// <p>The way that you want DNS Firewall to block the request. Used for the rule action setting <code>BLOCK</code>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NODATA</code> - Respond indicating that the query was successful, but no response is available for it.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NXDOMAIN</code> - Respond indicating that the domain name that's in the query doesn't exist.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OVERRIDE</code> - Provide a custom override in the response. This option requires custom handling details in the rule's <code>BlockOverride*</code> settings. </p>
        /// </li>
        /// </ul>
        pub fn set_block_response(
            mut self,
            input: std::option::Option<crate::model::BlockResponse>,
        ) -> Self {
            self.block_response = input;
            self
        }
        /// <p>The custom DNS record to send back in response to the query. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
        pub fn block_override_domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.block_override_domain = Some(input.into());
            self
        }
        /// <p>The custom DNS record to send back in response to the query. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
        pub fn set_block_override_domain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.block_override_domain = input;
            self
        }
        /// <p>The DNS record's type. This determines the format of the record value that you provided in <code>BlockOverrideDomain</code>. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
        pub fn block_override_dns_type(
            mut self,
            input: crate::model::BlockOverrideDnsType,
        ) -> Self {
            self.block_override_dns_type = Some(input);
            self
        }
        /// <p>The DNS record's type. This determines the format of the record value that you provided in <code>BlockOverrideDomain</code>. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
        pub fn set_block_override_dns_type(
            mut self,
            input: std::option::Option<crate::model::BlockOverrideDnsType>,
        ) -> Self {
            self.block_override_dns_type = input;
            self
        }
        /// <p>The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
        pub fn block_override_ttl(mut self, input: i32) -> Self {
            self.block_override_ttl = Some(input);
            self
        }
        /// <p>The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
        pub fn set_block_override_ttl(mut self, input: std::option::Option<i32>) -> Self {
            self.block_override_ttl = input;
            self
        }
        /// <p>The name of the rule.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the rule.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFirewallRuleInput`](crate::input::UpdateFirewallRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateFirewallRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateFirewallRuleInput {
                firewall_rule_group_id: self.firewall_rule_group_id,
                firewall_domain_list_id: self.firewall_domain_list_id,
                priority: self.priority,
                action: self.action,
                block_response: self.block_response,
                block_override_domain: self.block_override_domain,
                block_override_dns_type: self.block_override_dns_type,
                block_override_ttl: self.block_override_ttl,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateFirewallRuleInputOperationOutputAlias = crate::operation::UpdateFirewallRule;
#[doc(hidden)]
pub type UpdateFirewallRuleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateFirewallRuleInput {
    /// Consumes the builder and constructs an Operation<[`UpdateFirewallRule`](crate::operation::UpdateFirewallRule)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateFirewallRule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateFirewallRuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateFirewallRuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateFirewallRuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.UpdateFirewallRule",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_firewall_rule(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateFirewallRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateFirewallRule",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateFirewallRuleInput`](crate::input::UpdateFirewallRuleInput)
    pub fn builder() -> crate::input::update_firewall_rule_input::Builder {
        crate::input::update_firewall_rule_input::Builder::default()
    }
}

/// See [`UpdateFirewallRuleGroupAssociationInput`](crate::input::UpdateFirewallRuleGroupAssociationInput)
pub mod update_firewall_rule_group_association_input {
    /// A builder for [`UpdateFirewallRuleGroupAssociationInput`](crate::input::UpdateFirewallRuleGroupAssociationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_rule_group_association_id: std::option::Option<std::string::String>,
        pub(crate) priority: std::option::Option<i32>,
        pub(crate) mutation_protection: std::option::Option<crate::model::MutationProtectionStatus>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the <a>FirewallRuleGroupAssociation</a>. </p>
        pub fn firewall_rule_group_association_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.firewall_rule_group_association_id = Some(input.into());
            self
        }
        /// <p>The identifier of the <a>FirewallRuleGroupAssociation</a>. </p>
        pub fn set_firewall_rule_group_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firewall_rule_group_association_id = input;
            self
        }
        /// <p>The setting that determines the processing order of the rule group among the rule
        /// groups that you associate with the specified VPC. DNS Firewall filters VPC traffic
        /// starting from the rule group with the lowest numeric priority setting. </p>
        /// <p>You must specify a unique priority for each rule group that you associate with a single VPC.
        /// To make it easier to insert rule groups later, leave space between the numbers, for example, use 100, 200, and so on. You
        /// can change the priority setting for a rule group association after you create it.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.priority = Some(input);
            self
        }
        /// <p>The setting that determines the processing order of the rule group among the rule
        /// groups that you associate with the specified VPC. DNS Firewall filters VPC traffic
        /// starting from the rule group with the lowest numeric priority setting. </p>
        /// <p>You must specify a unique priority for each rule group that you associate with a single VPC.
        /// To make it easier to insert rule groups later, leave space between the numbers, for example, use 100, 200, and so on. You
        /// can change the priority setting for a rule group association after you create it.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.priority = input;
            self
        }
        /// <p>If enabled, this setting disallows modification or removal of the association, to help prevent against accidentally altering DNS firewall protections. </p>
        pub fn mutation_protection(
            mut self,
            input: crate::model::MutationProtectionStatus,
        ) -> Self {
            self.mutation_protection = Some(input);
            self
        }
        /// <p>If enabled, this setting disallows modification or removal of the association, to help prevent against accidentally altering DNS firewall protections. </p>
        pub fn set_mutation_protection(
            mut self,
            input: std::option::Option<crate::model::MutationProtectionStatus>,
        ) -> Self {
            self.mutation_protection = input;
            self
        }
        /// <p>The name of the rule group association.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the rule group association.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFirewallRuleGroupAssociationInput`](crate::input::UpdateFirewallRuleGroupAssociationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateFirewallRuleGroupAssociationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateFirewallRuleGroupAssociationInput {
                firewall_rule_group_association_id: self.firewall_rule_group_association_id,
                priority: self.priority,
                mutation_protection: self.mutation_protection,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateFirewallRuleGroupAssociationInputOperationOutputAlias =
    crate::operation::UpdateFirewallRuleGroupAssociation;
#[doc(hidden)]
pub type UpdateFirewallRuleGroupAssociationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateFirewallRuleGroupAssociationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateFirewallRuleGroupAssociation`](crate::operation::UpdateFirewallRuleGroupAssociation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateFirewallRuleGroupAssociation,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateFirewallRuleGroupAssociationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateFirewallRuleGroupAssociationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateFirewallRuleGroupAssociationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.UpdateFirewallRuleGroupAssociation",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_firewall_rule_group_association(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateFirewallRuleGroupAssociation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateFirewallRuleGroupAssociation",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateFirewallRuleGroupAssociationInput`](crate::input::UpdateFirewallRuleGroupAssociationInput)
    pub fn builder() -> crate::input::update_firewall_rule_group_association_input::Builder {
        crate::input::update_firewall_rule_group_association_input::Builder::default()
    }
}

/// See [`UpdateResolverConfigInput`](crate::input::UpdateResolverConfigInput)
pub mod update_resolver_config_input {
    /// A builder for [`UpdateResolverConfigInput`](crate::input::UpdateResolverConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) autodefined_reverse_flag:
            std::option::Option<crate::model::AutodefinedReverseFlag>,
    }
    impl Builder {
        /// <p>Resource ID of the Amazon VPC that you want to update the Resolver configuration for.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>Resource ID of the Amazon VPC that you want to update the Resolver configuration for.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>Indicates whether or not the Resolver will create autodefined rules for reverse DNS
        /// lookups. This is enabled by default. Disabling this option will also affect EC2-Classic
        /// instances using ClassicLink. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
        /// <i>Amazon EC2 guide</i>.</p>
        /// <note>
        /// <p>It can take some time for the status change to be completed.</p>
        /// </note>
        /// <p></p>
        pub fn autodefined_reverse_flag(
            mut self,
            input: crate::model::AutodefinedReverseFlag,
        ) -> Self {
            self.autodefined_reverse_flag = Some(input);
            self
        }
        /// <p>Indicates whether or not the Resolver will create autodefined rules for reverse DNS
        /// lookups. This is enabled by default. Disabling this option will also affect EC2-Classic
        /// instances using ClassicLink. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
        /// <i>Amazon EC2 guide</i>.</p>
        /// <note>
        /// <p>It can take some time for the status change to be completed.</p>
        /// </note>
        /// <p></p>
        pub fn set_autodefined_reverse_flag(
            mut self,
            input: std::option::Option<crate::model::AutodefinedReverseFlag>,
        ) -> Self {
            self.autodefined_reverse_flag = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateResolverConfigInput`](crate::input::UpdateResolverConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateResolverConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateResolverConfigInput {
                resource_id: self.resource_id,
                autodefined_reverse_flag: self.autodefined_reverse_flag,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateResolverConfigInputOperationOutputAlias = crate::operation::UpdateResolverConfig;
#[doc(hidden)]
pub type UpdateResolverConfigInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateResolverConfigInput {
    /// Consumes the builder and constructs an Operation<[`UpdateResolverConfig`](crate::operation::UpdateResolverConfig)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateResolverConfig,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateResolverConfigInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateResolverConfigInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateResolverConfigInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.UpdateResolverConfig",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_resolver_config(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateResolverConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateResolverConfig",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateResolverConfigInput`](crate::input::UpdateResolverConfigInput)
    pub fn builder() -> crate::input::update_resolver_config_input::Builder {
        crate::input::update_resolver_config_input::Builder::default()
    }
}

/// See [`UpdateResolverDnssecConfigInput`](crate::input::UpdateResolverDnssecConfigInput)
pub mod update_resolver_dnssec_config_input {
    /// A builder for [`UpdateResolverDnssecConfigInput`](crate::input::UpdateResolverDnssecConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) validation: std::option::Option<crate::model::Validation>,
    }
    impl Builder {
        /// <p>The ID of the virtual private cloud (VPC) that you're updating the DNSSEC validation status for.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual private cloud (VPC) that you're updating the DNSSEC validation status for.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The new value that you are specifying for DNSSEC validation for the VPC. The value can be <code>ENABLE</code>
        /// or <code>DISABLE</code>. Be aware that it can take time for a validation status change to be completed.</p>
        pub fn validation(mut self, input: crate::model::Validation) -> Self {
            self.validation = Some(input);
            self
        }
        /// <p>The new value that you are specifying for DNSSEC validation for the VPC. The value can be <code>ENABLE</code>
        /// or <code>DISABLE</code>. Be aware that it can take time for a validation status change to be completed.</p>
        pub fn set_validation(
            mut self,
            input: std::option::Option<crate::model::Validation>,
        ) -> Self {
            self.validation = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateResolverDnssecConfigInput`](crate::input::UpdateResolverDnssecConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateResolverDnssecConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateResolverDnssecConfigInput {
                resource_id: self.resource_id,
                validation: self.validation,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateResolverDnssecConfigInputOperationOutputAlias =
    crate::operation::UpdateResolverDnssecConfig;
#[doc(hidden)]
pub type UpdateResolverDnssecConfigInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateResolverDnssecConfigInput {
    /// Consumes the builder and constructs an Operation<[`UpdateResolverDnssecConfig`](crate::operation::UpdateResolverDnssecConfig)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateResolverDnssecConfig,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateResolverDnssecConfigInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateResolverDnssecConfigInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateResolverDnssecConfigInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.UpdateResolverDnssecConfig",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_resolver_dnssec_config(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateResolverDnssecConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateResolverDnssecConfig",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateResolverDnssecConfigInput`](crate::input::UpdateResolverDnssecConfigInput)
    pub fn builder() -> crate::input::update_resolver_dnssec_config_input::Builder {
        crate::input::update_resolver_dnssec_config_input::Builder::default()
    }
}

/// See [`UpdateResolverEndpointInput`](crate::input::UpdateResolverEndpointInput)
pub mod update_resolver_endpoint_input {
    /// A builder for [`UpdateResolverEndpointInput`](crate::input::UpdateResolverEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resolver_endpoint_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Resolver endpoint that you want to update.</p>
        pub fn resolver_endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resolver_endpoint_id = Some(input.into());
            self
        }
        /// <p>The ID of the Resolver endpoint that you want to update.</p>
        pub fn set_resolver_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resolver_endpoint_id = input;
            self
        }
        /// <p>The name of the Resolver endpoint that you want to update.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Resolver endpoint that you want to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateResolverEndpointInput`](crate::input::UpdateResolverEndpointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateResolverEndpointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateResolverEndpointInput {
                resolver_endpoint_id: self.resolver_endpoint_id,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateResolverEndpointInputOperationOutputAlias = crate::operation::UpdateResolverEndpoint;
#[doc(hidden)]
pub type UpdateResolverEndpointInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateResolverEndpointInput {
    /// Consumes the builder and constructs an Operation<[`UpdateResolverEndpoint`](crate::operation::UpdateResolverEndpoint)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateResolverEndpoint,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateResolverEndpointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateResolverEndpointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateResolverEndpointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.UpdateResolverEndpoint",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_resolver_endpoint(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateResolverEndpoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateResolverEndpoint",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateResolverEndpointInput`](crate::input::UpdateResolverEndpointInput)
    pub fn builder() -> crate::input::update_resolver_endpoint_input::Builder {
        crate::input::update_resolver_endpoint_input::Builder::default()
    }
}

/// See [`UpdateResolverRuleInput`](crate::input::UpdateResolverRuleInput)
pub mod update_resolver_rule_input {
    /// A builder for [`UpdateResolverRuleInput`](crate::input::UpdateResolverRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resolver_rule_id: std::option::Option<std::string::String>,
        pub(crate) config: std::option::Option<crate::model::ResolverRuleConfig>,
    }
    impl Builder {
        /// <p>The ID of the Resolver rule that you want to update.</p>
        pub fn resolver_rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resolver_rule_id = Some(input.into());
            self
        }
        /// <p>The ID of the Resolver rule that you want to update.</p>
        pub fn set_resolver_rule_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resolver_rule_id = input;
            self
        }
        /// <p>The new settings for the Resolver rule.</p>
        pub fn config(mut self, input: crate::model::ResolverRuleConfig) -> Self {
            self.config = Some(input);
            self
        }
        /// <p>The new settings for the Resolver rule.</p>
        pub fn set_config(
            mut self,
            input: std::option::Option<crate::model::ResolverRuleConfig>,
        ) -> Self {
            self.config = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateResolverRuleInput`](crate::input::UpdateResolverRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateResolverRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateResolverRuleInput {
                resolver_rule_id: self.resolver_rule_id,
                config: self.config,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateResolverRuleInputOperationOutputAlias = crate::operation::UpdateResolverRule;
#[doc(hidden)]
pub type UpdateResolverRuleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateResolverRuleInput {
    /// Consumes the builder and constructs an Operation<[`UpdateResolverRule`](crate::operation::UpdateResolverRule)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateResolverRule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateResolverRuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateResolverRuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateResolverRuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Resolver.UpdateResolverRule",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_resolver_rule(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateResolverRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateResolverRule",
            "route53resolver",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateResolverRuleInput`](crate::input::UpdateResolverRuleInput)
    pub fn builder() -> crate::input::update_resolver_rule_input::Builder {
        crate::input::update_resolver_rule_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateResolverRuleInput {
    /// <p>The ID of the Resolver rule that you want to update.</p>
    pub resolver_rule_id: std::option::Option<std::string::String>,
    /// <p>The new settings for the Resolver rule.</p>
    pub config: std::option::Option<crate::model::ResolverRuleConfig>,
}
impl UpdateResolverRuleInput {
    /// <p>The ID of the Resolver rule that you want to update.</p>
    pub fn resolver_rule_id(&self) -> std::option::Option<&str> {
        self.resolver_rule_id.as_deref()
    }
    /// <p>The new settings for the Resolver rule.</p>
    pub fn config(&self) -> std::option::Option<&crate::model::ResolverRuleConfig> {
        self.config.as_ref()
    }
}
impl std::fmt::Debug for UpdateResolverRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateResolverRuleInput");
        formatter.field("resolver_rule_id", &self.resolver_rule_id);
        formatter.field("config", &self.config);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateResolverEndpointInput {
    /// <p>The ID of the Resolver endpoint that you want to update.</p>
    pub resolver_endpoint_id: std::option::Option<std::string::String>,
    /// <p>The name of the Resolver endpoint that you want to update.</p>
    pub name: std::option::Option<std::string::String>,
}
impl UpdateResolverEndpointInput {
    /// <p>The ID of the Resolver endpoint that you want to update.</p>
    pub fn resolver_endpoint_id(&self) -> std::option::Option<&str> {
        self.resolver_endpoint_id.as_deref()
    }
    /// <p>The name of the Resolver endpoint that you want to update.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for UpdateResolverEndpointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateResolverEndpointInput");
        formatter.field("resolver_endpoint_id", &self.resolver_endpoint_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateResolverDnssecConfigInput {
    /// <p>The ID of the virtual private cloud (VPC) that you're updating the DNSSEC validation status for.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The new value that you are specifying for DNSSEC validation for the VPC. The value can be <code>ENABLE</code>
    /// or <code>DISABLE</code>. Be aware that it can take time for a validation status change to be completed.</p>
    pub validation: std::option::Option<crate::model::Validation>,
}
impl UpdateResolverDnssecConfigInput {
    /// <p>The ID of the virtual private cloud (VPC) that you're updating the DNSSEC validation status for.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The new value that you are specifying for DNSSEC validation for the VPC. The value can be <code>ENABLE</code>
    /// or <code>DISABLE</code>. Be aware that it can take time for a validation status change to be completed.</p>
    pub fn validation(&self) -> std::option::Option<&crate::model::Validation> {
        self.validation.as_ref()
    }
}
impl std::fmt::Debug for UpdateResolverDnssecConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateResolverDnssecConfigInput");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("validation", &self.validation);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateResolverConfigInput {
    /// <p>Resource ID of the Amazon VPC that you want to update the Resolver configuration for.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>Indicates whether or not the Resolver will create autodefined rules for reverse DNS
    /// lookups. This is enabled by default. Disabling this option will also affect EC2-Classic
    /// instances using ClassicLink. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
    /// <i>Amazon EC2 guide</i>.</p>
    /// <note>
    /// <p>It can take some time for the status change to be completed.</p>
    /// </note>
    /// <p></p>
    pub autodefined_reverse_flag: std::option::Option<crate::model::AutodefinedReverseFlag>,
}
impl UpdateResolverConfigInput {
    /// <p>Resource ID of the Amazon VPC that you want to update the Resolver configuration for.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>Indicates whether or not the Resolver will create autodefined rules for reverse DNS
    /// lookups. This is enabled by default. Disabling this option will also affect EC2-Classic
    /// instances using ClassicLink. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
    /// <i>Amazon EC2 guide</i>.</p>
    /// <note>
    /// <p>It can take some time for the status change to be completed.</p>
    /// </note>
    /// <p></p>
    pub fn autodefined_reverse_flag(
        &self,
    ) -> std::option::Option<&crate::model::AutodefinedReverseFlag> {
        self.autodefined_reverse_flag.as_ref()
    }
}
impl std::fmt::Debug for UpdateResolverConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateResolverConfigInput");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("autodefined_reverse_flag", &self.autodefined_reverse_flag);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFirewallRuleGroupAssociationInput {
    /// <p>The identifier of the <a>FirewallRuleGroupAssociation</a>. </p>
    pub firewall_rule_group_association_id: std::option::Option<std::string::String>,
    /// <p>The setting that determines the processing order of the rule group among the rule
    /// groups that you associate with the specified VPC. DNS Firewall filters VPC traffic
    /// starting from the rule group with the lowest numeric priority setting. </p>
    /// <p>You must specify a unique priority for each rule group that you associate with a single VPC.
    /// To make it easier to insert rule groups later, leave space between the numbers, for example, use 100, 200, and so on. You
    /// can change the priority setting for a rule group association after you create it.</p>
    pub priority: std::option::Option<i32>,
    /// <p>If enabled, this setting disallows modification or removal of the association, to help prevent against accidentally altering DNS firewall protections. </p>
    pub mutation_protection: std::option::Option<crate::model::MutationProtectionStatus>,
    /// <p>The name of the rule group association.</p>
    pub name: std::option::Option<std::string::String>,
}
impl UpdateFirewallRuleGroupAssociationInput {
    /// <p>The identifier of the <a>FirewallRuleGroupAssociation</a>. </p>
    pub fn firewall_rule_group_association_id(&self) -> std::option::Option<&str> {
        self.firewall_rule_group_association_id.as_deref()
    }
    /// <p>The setting that determines the processing order of the rule group among the rule
    /// groups that you associate with the specified VPC. DNS Firewall filters VPC traffic
    /// starting from the rule group with the lowest numeric priority setting. </p>
    /// <p>You must specify a unique priority for each rule group that you associate with a single VPC.
    /// To make it easier to insert rule groups later, leave space between the numbers, for example, use 100, 200, and so on. You
    /// can change the priority setting for a rule group association after you create it.</p>
    pub fn priority(&self) -> std::option::Option<i32> {
        self.priority
    }
    /// <p>If enabled, this setting disallows modification or removal of the association, to help prevent against accidentally altering DNS firewall protections. </p>
    pub fn mutation_protection(
        &self,
    ) -> std::option::Option<&crate::model::MutationProtectionStatus> {
        self.mutation_protection.as_ref()
    }
    /// <p>The name of the rule group association.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for UpdateFirewallRuleGroupAssociationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFirewallRuleGroupAssociationInput");
        formatter.field(
            "firewall_rule_group_association_id",
            &self.firewall_rule_group_association_id,
        );
        formatter.field("priority", &self.priority);
        formatter.field("mutation_protection", &self.mutation_protection);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFirewallRuleInput {
    /// <p>The unique identifier of the firewall rule group for the rule. </p>
    pub firewall_rule_group_id: std::option::Option<std::string::String>,
    /// <p>The ID of the domain list to use in the rule.  </p>
    pub firewall_domain_list_id: std::option::Option<std::string::String>,
    /// <p>The setting that determines the processing order of the rule in the rule group. DNS Firewall
    /// processes the rules in a rule group by order of priority, starting from the lowest setting.</p>
    /// <p>You must specify a unique priority for each rule in a rule group.
    /// To make it easier to insert rules later, leave space between the numbers, for example, use 100, 200, and so on. You
    /// can change the priority setting for the rules in a rule group at any time.</p>
    pub priority: std::option::Option<i32>,
    /// <p>The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ALLOW</code> - Permit the request to go through.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ALERT</code> - Permit the request to go through but send an alert to the logs.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>BLOCK</code> - Disallow the request. This option requires additional details in the rule's <code>BlockResponse</code>. </p>
    /// </li>
    /// </ul>
    pub action: std::option::Option<crate::model::Action>,
    /// <p>The way that you want DNS Firewall to block the request. Used for the rule action setting <code>BLOCK</code>.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NODATA</code> - Respond indicating that the query was successful, but no response is available for it.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NXDOMAIN</code> - Respond indicating that the domain name that's in the query doesn't exist.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>OVERRIDE</code> - Provide a custom override in the response. This option requires custom handling details in the rule's <code>BlockOverride*</code> settings. </p>
    /// </li>
    /// </ul>
    pub block_response: std::option::Option<crate::model::BlockResponse>,
    /// <p>The custom DNS record to send back in response to the query. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
    pub block_override_domain: std::option::Option<std::string::String>,
    /// <p>The DNS record's type. This determines the format of the record value that you provided in <code>BlockOverrideDomain</code>. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
    pub block_override_dns_type: std::option::Option<crate::model::BlockOverrideDnsType>,
    /// <p>The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
    pub block_override_ttl: std::option::Option<i32>,
    /// <p>The name of the rule.</p>
    pub name: std::option::Option<std::string::String>,
}
impl UpdateFirewallRuleInput {
    /// <p>The unique identifier of the firewall rule group for the rule. </p>
    pub fn firewall_rule_group_id(&self) -> std::option::Option<&str> {
        self.firewall_rule_group_id.as_deref()
    }
    /// <p>The ID of the domain list to use in the rule.  </p>
    pub fn firewall_domain_list_id(&self) -> std::option::Option<&str> {
        self.firewall_domain_list_id.as_deref()
    }
    /// <p>The setting that determines the processing order of the rule in the rule group. DNS Firewall
    /// processes the rules in a rule group by order of priority, starting from the lowest setting.</p>
    /// <p>You must specify a unique priority for each rule in a rule group.
    /// To make it easier to insert rules later, leave space between the numbers, for example, use 100, 200, and so on. You
    /// can change the priority setting for the rules in a rule group at any time.</p>
    pub fn priority(&self) -> std::option::Option<i32> {
        self.priority
    }
    /// <p>The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ALLOW</code> - Permit the request to go through.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ALERT</code> - Permit the request to go through but send an alert to the logs.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>BLOCK</code> - Disallow the request. This option requires additional details in the rule's <code>BlockResponse</code>. </p>
    /// </li>
    /// </ul>
    pub fn action(&self) -> std::option::Option<&crate::model::Action> {
        self.action.as_ref()
    }
    /// <p>The way that you want DNS Firewall to block the request. Used for the rule action setting <code>BLOCK</code>.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NODATA</code> - Respond indicating that the query was successful, but no response is available for it.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NXDOMAIN</code> - Respond indicating that the domain name that's in the query doesn't exist.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>OVERRIDE</code> - Provide a custom override in the response. This option requires custom handling details in the rule's <code>BlockOverride*</code> settings. </p>
    /// </li>
    /// </ul>
    pub fn block_response(&self) -> std::option::Option<&crate::model::BlockResponse> {
        self.block_response.as_ref()
    }
    /// <p>The custom DNS record to send back in response to the query. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
    pub fn block_override_domain(&self) -> std::option::Option<&str> {
        self.block_override_domain.as_deref()
    }
    /// <p>The DNS record's type. This determines the format of the record value that you provided in <code>BlockOverrideDomain</code>. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
    pub fn block_override_dns_type(
        &self,
    ) -> std::option::Option<&crate::model::BlockOverrideDnsType> {
        self.block_override_dns_type.as_ref()
    }
    /// <p>The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
    pub fn block_override_ttl(&self) -> std::option::Option<i32> {
        self.block_override_ttl
    }
    /// <p>The name of the rule.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for UpdateFirewallRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFirewallRuleInput");
        formatter.field("firewall_rule_group_id", &self.firewall_rule_group_id);
        formatter.field("firewall_domain_list_id", &self.firewall_domain_list_id);
        formatter.field("priority", &self.priority);
        formatter.field("action", &self.action);
        formatter.field("block_response", &self.block_response);
        formatter.field("block_override_domain", &self.block_override_domain);
        formatter.field("block_override_dns_type", &self.block_override_dns_type);
        formatter.field("block_override_ttl", &self.block_override_ttl);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFirewallDomainsInput {
    /// <p>The ID of the domain list whose domains you want to update. </p>
    pub firewall_domain_list_id: std::option::Option<std::string::String>,
    /// <p>What you want DNS Firewall to do with the domains that you are providing: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ADD</code> - Add the domains to the ones that are already in the domain list. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>REMOVE</code> - Search the domain list for the domains and remove them from the list.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>REPLACE</code> - Update the domain list to exactly match the list that you are providing. </p>
    /// </li>
    /// </ul>
    pub operation: std::option::Option<crate::model::FirewallDomainUpdateOperation>,
    /// <p>A list of domains to use in the update operation.</p>
    /// <p>Each domain specification in your domain list must satisfy the following
    /// requirements: </p>
    /// <ul>
    /// <li>
    /// <p>It can optionally start with <code>*</code> (asterisk).</p>
    /// </li>
    /// <li>
    /// <p>With the exception of the optional starting asterisk, it must only contain
    /// the following characters: <code>A-Z</code>, <code>a-z</code>,
    /// <code>0-9</code>, <code>-</code> (hyphen).</p>
    /// </li>
    /// <li>
    /// <p>It must be from 1-255 characters in length. </p>
    /// </li>
    /// </ul>
    pub domains: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UpdateFirewallDomainsInput {
    /// <p>The ID of the domain list whose domains you want to update. </p>
    pub fn firewall_domain_list_id(&self) -> std::option::Option<&str> {
        self.firewall_domain_list_id.as_deref()
    }
    /// <p>What you want DNS Firewall to do with the domains that you are providing: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ADD</code> - Add the domains to the ones that are already in the domain list. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>REMOVE</code> - Search the domain list for the domains and remove them from the list.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>REPLACE</code> - Update the domain list to exactly match the list that you are providing. </p>
    /// </li>
    /// </ul>
    pub fn operation(&self) -> std::option::Option<&crate::model::FirewallDomainUpdateOperation> {
        self.operation.as_ref()
    }
    /// <p>A list of domains to use in the update operation.</p>
    /// <p>Each domain specification in your domain list must satisfy the following
    /// requirements: </p>
    /// <ul>
    /// <li>
    /// <p>It can optionally start with <code>*</code> (asterisk).</p>
    /// </li>
    /// <li>
    /// <p>With the exception of the optional starting asterisk, it must only contain
    /// the following characters: <code>A-Z</code>, <code>a-z</code>,
    /// <code>0-9</code>, <code>-</code> (hyphen).</p>
    /// </li>
    /// <li>
    /// <p>It must be from 1-255 characters in length. </p>
    /// </li>
    /// </ul>
    pub fn domains(&self) -> std::option::Option<&[std::string::String]> {
        self.domains.as_deref()
    }
}
impl std::fmt::Debug for UpdateFirewallDomainsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFirewallDomainsInput");
        formatter.field("firewall_domain_list_id", &self.firewall_domain_list_id);
        formatter.field("operation", &self.operation);
        formatter.field("domains", &self.domains);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFirewallConfigInput {
    /// <p>The ID of the VPC that the configuration is for.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>Determines how Route 53 Resolver handles queries during failures, for example when all traffic that is sent to DNS Firewall fails to receive a reply. </p>
    /// <ul>
    /// <li>
    /// <p>By default, fail open is disabled, which means the failure mode is closed. This approach favors security over availability.
    /// DNS Firewall blocks queries that it is unable to evaluate properly. </p>
    /// </li>
    /// <li>
    /// <p>If you enable this option, the failure mode is open. This approach favors availability over security. DNS Firewall allows queries to proceed if it
    /// is unable to properly evaluate them. </p>
    /// </li>
    /// </ul>
    /// <p>This behavior is only enforced for VPCs that have at least one DNS Firewall rule group association. </p>
    pub firewall_fail_open: std::option::Option<crate::model::FirewallFailOpenStatus>,
}
impl UpdateFirewallConfigInput {
    /// <p>The ID of the VPC that the configuration is for.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>Determines how Route 53 Resolver handles queries during failures, for example when all traffic that is sent to DNS Firewall fails to receive a reply. </p>
    /// <ul>
    /// <li>
    /// <p>By default, fail open is disabled, which means the failure mode is closed. This approach favors security over availability.
    /// DNS Firewall blocks queries that it is unable to evaluate properly. </p>
    /// </li>
    /// <li>
    /// <p>If you enable this option, the failure mode is open. This approach favors availability over security. DNS Firewall allows queries to proceed if it
    /// is unable to properly evaluate them. </p>
    /// </li>
    /// </ul>
    /// <p>This behavior is only enforced for VPCs that have at least one DNS Firewall rule group association. </p>
    pub fn firewall_fail_open(&self) -> std::option::Option<&crate::model::FirewallFailOpenStatus> {
        self.firewall_fail_open.as_ref()
    }
}
impl std::fmt::Debug for UpdateFirewallConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFirewallConfigInput");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("firewall_fail_open", &self.firewall_fail_open);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) for the resource that you want to remove tags from. To get the ARN for a resource, use the applicable
    /// <code>Get</code> or <code>List</code> command: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html">GetResolverEndpoint</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRule.html">GetResolverRule</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRuleAssociation.html">GetResolverRuleAssociation</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html">ListResolverEndpoints</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html">ListResolverRuleAssociations</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html">ListResolverRules</a>
    /// </p>
    /// </li>
    /// </ul>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tags that you want to remove to the specified resource.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) for the resource that you want to remove tags from. To get the ARN for a resource, use the applicable
    /// <code>Get</code> or <code>List</code> command: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html">GetResolverEndpoint</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRule.html">GetResolverRule</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRuleAssociation.html">GetResolverRuleAssociation</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html">ListResolverEndpoints</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html">ListResolverRuleAssociations</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html">ListResolverRules</a>
    /// </p>
    /// </li>
    /// </ul>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tags that you want to remove to the specified resource.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) for the resource that you want to add tags to. To get the ARN for a resource, use the applicable
    /// <code>Get</code> or <code>List</code> command: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html">GetResolverEndpoint</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRule.html">GetResolverRule</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRuleAssociation.html">GetResolverRuleAssociation</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html">ListResolverEndpoints</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html">ListResolverRuleAssociations</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html">ListResolverRules</a>
    /// </p>
    /// </li>
    /// </ul>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tags that you want to add to the specified resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) for the resource that you want to add tags to. To get the ARN for a resource, use the applicable
    /// <code>Get</code> or <code>List</code> command: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html">GetResolverEndpoint</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRule.html">GetResolverRule</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRuleAssociation.html">GetResolverRuleAssociation</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html">ListResolverEndpoints</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html">ListResolverRuleAssociations</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html">ListResolverRules</a>
    /// </p>
    /// </li>
    /// </ul>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tags that you want to add to the specified resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutResolverRulePolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the rule that you want to share with another account.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>An Identity and Access Management policy statement that lists the rules that you want to share with another Amazon Web Services account and the operations that you want the account
    /// to be able to perform. You can specify the following operations in the <code>Action</code> section of the statement:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>route53resolver:GetResolverRule</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>route53resolver:AssociateResolverRule</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>route53resolver:DisassociateResolverRule</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>route53resolver:ListResolverRules</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>route53resolver:ListResolverRuleAssociations</code>
    /// </p>
    /// </li>
    /// </ul>
    ///
    /// <p>In the <code>Resource</code> section of the statement, specify the ARN for the rule that you want to share with another account. Specify the same ARN
    /// that you specified in <code>Arn</code>.</p>
    pub resolver_rule_policy: std::option::Option<std::string::String>,
}
impl PutResolverRulePolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the rule that you want to share with another account.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>An Identity and Access Management policy statement that lists the rules that you want to share with another Amazon Web Services account and the operations that you want the account
    /// to be able to perform. You can specify the following operations in the <code>Action</code> section of the statement:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>route53resolver:GetResolverRule</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>route53resolver:AssociateResolverRule</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>route53resolver:DisassociateResolverRule</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>route53resolver:ListResolverRules</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>route53resolver:ListResolverRuleAssociations</code>
    /// </p>
    /// </li>
    /// </ul>
    ///
    /// <p>In the <code>Resource</code> section of the statement, specify the ARN for the rule that you want to share with another account. Specify the same ARN
    /// that you specified in <code>Arn</code>.</p>
    pub fn resolver_rule_policy(&self) -> std::option::Option<&str> {
        self.resolver_rule_policy.as_deref()
    }
}
impl std::fmt::Debug for PutResolverRulePolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutResolverRulePolicyInput");
        formatter.field("arn", &self.arn);
        formatter.field("resolver_rule_policy", &self.resolver_rule_policy);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutResolverQueryLogConfigPolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the account that you want to share rules with.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>An Identity and Access Management policy statement that lists the query logging configurations that you want to share with another Amazon Web Services account
    /// and the operations that you want the account to be able to perform. You can specify the following operations in the <code>Actions</code> section
    /// of the statement:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>route53resolver:AssociateResolverQueryLogConfig</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>route53resolver:DisassociateResolverQueryLogConfig</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>route53resolver:ListResolverQueryLogConfigAssociations</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>route53resolver:ListResolverQueryLogConfigs</code>
    /// </p>
    /// </li>
    /// </ul>
    ///
    /// <p>In the <code>Resource</code> section of the statement, you specify the ARNs for the query logging configurations that you want to share
    /// with the account that you specified in <code>Arn</code>. </p>
    pub resolver_query_log_config_policy: std::option::Option<std::string::String>,
}
impl PutResolverQueryLogConfigPolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the account that you want to share rules with.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>An Identity and Access Management policy statement that lists the query logging configurations that you want to share with another Amazon Web Services account
    /// and the operations that you want the account to be able to perform. You can specify the following operations in the <code>Actions</code> section
    /// of the statement:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>route53resolver:AssociateResolverQueryLogConfig</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>route53resolver:DisassociateResolverQueryLogConfig</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>route53resolver:ListResolverQueryLogConfigAssociations</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>route53resolver:ListResolverQueryLogConfigs</code>
    /// </p>
    /// </li>
    /// </ul>
    ///
    /// <p>In the <code>Resource</code> section of the statement, you specify the ARNs for the query logging configurations that you want to share
    /// with the account that you specified in <code>Arn</code>. </p>
    pub fn resolver_query_log_config_policy(&self) -> std::option::Option<&str> {
        self.resolver_query_log_config_policy.as_deref()
    }
}
impl std::fmt::Debug for PutResolverQueryLogConfigPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutResolverQueryLogConfigPolicyInput");
        formatter.field("arn", &self.arn);
        formatter.field(
            "resolver_query_log_config_policy",
            &self.resolver_query_log_config_policy,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutFirewallRuleGroupPolicyInput {
    /// <p>The ARN (Amazon Resource Name) for the rule group that you want to share.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The Identity and Access Management (Amazon Web Services IAM) policy to attach to the rule group.</p>
    pub firewall_rule_group_policy: std::option::Option<std::string::String>,
}
impl PutFirewallRuleGroupPolicyInput {
    /// <p>The ARN (Amazon Resource Name) for the rule group that you want to share.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The Identity and Access Management (Amazon Web Services IAM) policy to attach to the rule group.</p>
    pub fn firewall_rule_group_policy(&self) -> std::option::Option<&str> {
        self.firewall_rule_group_policy.as_deref()
    }
}
impl std::fmt::Debug for PutFirewallRuleGroupPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutFirewallRuleGroupPolicyInput");
        formatter.field("arn", &self.arn);
        formatter.field(
            "firewall_rule_group_policy",
            &self.firewall_rule_group_policy,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) for the resource that you want to list tags for.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The maximum number of tags that you want to return in the response to a <code>ListTagsForResource</code> request.
    /// If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 tags.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>For the first <code>ListTagsForResource</code> request, omit this value.</p>
    /// <p>If you have more than <code>MaxResults</code> tags, you can submit another <code>ListTagsForResource</code> request
    /// to get the next group of tags for the resource. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) for the resource that you want to list tags for.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The maximum number of tags that you want to return in the response to a <code>ListTagsForResource</code> request.
    /// If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 tags.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>For the first <code>ListTagsForResource</code> request, omit this value.</p>
    /// <p>If you have more than <code>MaxResults</code> tags, you can submit another <code>ListTagsForResource</code> request
    /// to get the next group of tags for the resource. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResolverRulesInput {
    /// <p>The maximum number of Resolver rules that you want to return in the response to a <code>ListResolverRules</code> request.
    /// If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 Resolver rules.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>For the first <code>ListResolverRules</code> request, omit this value.</p>
    /// <p>If you have more than <code>MaxResults</code> Resolver rules, you can submit another <code>ListResolverRules</code> request
    /// to get the next group of Resolver rules. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An optional specification to return a subset of Resolver rules, such as all Resolver rules that are associated with the same Resolver endpoint.</p>
    /// <note>
    /// <p>If you submit a second or subsequent <code>ListResolverRules</code> request and specify the <code>NextToken</code> parameter,
    /// you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>
    /// </note>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
}
impl ListResolverRulesInput {
    /// <p>The maximum number of Resolver rules that you want to return in the response to a <code>ListResolverRules</code> request.
    /// If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 Resolver rules.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>For the first <code>ListResolverRules</code> request, omit this value.</p>
    /// <p>If you have more than <code>MaxResults</code> Resolver rules, you can submit another <code>ListResolverRules</code> request
    /// to get the next group of Resolver rules. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>An optional specification to return a subset of Resolver rules, such as all Resolver rules that are associated with the same Resolver endpoint.</p>
    /// <note>
    /// <p>If you submit a second or subsequent <code>ListResolverRules</code> request and specify the <code>NextToken</code> parameter,
    /// you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>
    /// </note>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
}
impl std::fmt::Debug for ListResolverRulesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResolverRulesInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("filters", &self.filters);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResolverRuleAssociationsInput {
    /// <p>The maximum number of rule associations that you want to return in the response to a <code>ListResolverRuleAssociations</code> request.
    /// If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 rule associations. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>For the first <code>ListResolverRuleAssociation</code> request, omit this value.</p>
    /// <p>If you have more than <code>MaxResults</code> rule associations, you can submit another <code>ListResolverRuleAssociation</code> request
    /// to get the next group of rule associations. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An optional specification to return a subset of Resolver rules, such as Resolver rules that are associated with the same VPC ID.</p>
    /// <note>
    /// <p>If you submit a second or subsequent <code>ListResolverRuleAssociations</code> request and specify the <code>NextToken</code> parameter,
    /// you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>
    /// </note>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
}
impl ListResolverRuleAssociationsInput {
    /// <p>The maximum number of rule associations that you want to return in the response to a <code>ListResolverRuleAssociations</code> request.
    /// If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 rule associations. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>For the first <code>ListResolverRuleAssociation</code> request, omit this value.</p>
    /// <p>If you have more than <code>MaxResults</code> rule associations, you can submit another <code>ListResolverRuleAssociation</code> request
    /// to get the next group of rule associations. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>An optional specification to return a subset of Resolver rules, such as Resolver rules that are associated with the same VPC ID.</p>
    /// <note>
    /// <p>If you submit a second or subsequent <code>ListResolverRuleAssociations</code> request and specify the <code>NextToken</code> parameter,
    /// you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>
    /// </note>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
}
impl std::fmt::Debug for ListResolverRuleAssociationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResolverRuleAssociationsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("filters", &self.filters);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResolverQueryLogConfigsInput {
    /// <p>The maximum number of query logging configurations that you want to return in the response to a <code>ListResolverQueryLogConfigs</code> request.
    /// If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 query logging configurations. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>For the first <code>ListResolverQueryLogConfigs</code> request, omit this value.</p>
    /// <p>If there are more than <code>MaxResults</code> query logging configurations that match the values that you specify for <code>Filters</code>,
    /// you can submit another <code>ListResolverQueryLogConfigs</code> request to get the next group of configurations. In the next request, specify the value of
    /// <code>NextToken</code> from the previous response. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An optional specification to return a subset of query logging configurations.</p>
    /// <note>
    /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the <code>NextToken</code> parameter,
    /// you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>
    /// </note>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>The element that you want Resolver to sort query logging configurations by. </p>
    /// <note>
    /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the <code>NextToken</code> parameter,
    /// you must use the same value for <code>SortBy</code>, if any, as in the previous request.</p>
    /// </note>
    ///
    /// <p>Valid values include the following elements:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Arn</code>: The ARN of the query logging configuration</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AssociationCount</code>: The number of VPCs that are associated with the specified configuration </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CreationTime</code>: The date and time that Resolver returned when the configuration was created</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CreatorRequestId</code>: The value that was specified for <code>CreatorRequestId</code> when the configuration was created</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DestinationArn</code>: The location that logs are sent to</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Id</code>: The ID of the configuration</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Name</code>: The name of the configuration</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>OwnerId</code>: The Amazon Web Services account number of the account that created the configuration</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ShareStatus</code>: Whether the configuration is shared with other Amazon Web Services accounts or shared with the current account by
    /// another Amazon Web Services account. Sharing is configured through Resource Access Manager (RAM).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Status</code>: The current status of the configuration. Valid values include the following:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATING</code>: Resolver is creating the query logging configuration.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATED</code>: The query logging configuration was successfully created.
    /// Resolver is logging queries that originate in the specified VPC.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETING</code>: Resolver is deleting this query logging configuration.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code>: Resolver either couldn't create or couldn't delete the query logging configuration.
    /// Here are two common causes:</p>
    /// <ul>
    /// <li>
    /// <p>The specified destination (for example, an Amazon S3 bucket) was deleted.</p>
    /// </li>
    /// <li>
    /// <p>Permissions don't allow sending logs to the destination.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    pub sort_by: std::option::Option<std::string::String>,
    /// <p>If you specified a value for <code>SortBy</code>, the order that you want query logging configurations to be listed in,
    /// <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
    /// <note>
    /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the <code>NextToken</code> parameter,
    /// you must use the same value for <code>SortOrder</code>, if any, as in the previous request.</p>
    /// </note>
    pub sort_order: std::option::Option<crate::model::SortOrder>,
}
impl ListResolverQueryLogConfigsInput {
    /// <p>The maximum number of query logging configurations that you want to return in the response to a <code>ListResolverQueryLogConfigs</code> request.
    /// If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 query logging configurations. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>For the first <code>ListResolverQueryLogConfigs</code> request, omit this value.</p>
    /// <p>If there are more than <code>MaxResults</code> query logging configurations that match the values that you specify for <code>Filters</code>,
    /// you can submit another <code>ListResolverQueryLogConfigs</code> request to get the next group of configurations. In the next request, specify the value of
    /// <code>NextToken</code> from the previous response. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>An optional specification to return a subset of query logging configurations.</p>
    /// <note>
    /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the <code>NextToken</code> parameter,
    /// you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>
    /// </note>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
    /// <p>The element that you want Resolver to sort query logging configurations by. </p>
    /// <note>
    /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the <code>NextToken</code> parameter,
    /// you must use the same value for <code>SortBy</code>, if any, as in the previous request.</p>
    /// </note>
    ///
    /// <p>Valid values include the following elements:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Arn</code>: The ARN of the query logging configuration</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AssociationCount</code>: The number of VPCs that are associated with the specified configuration </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CreationTime</code>: The date and time that Resolver returned when the configuration was created</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CreatorRequestId</code>: The value that was specified for <code>CreatorRequestId</code> when the configuration was created</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DestinationArn</code>: The location that logs are sent to</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Id</code>: The ID of the configuration</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Name</code>: The name of the configuration</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>OwnerId</code>: The Amazon Web Services account number of the account that created the configuration</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ShareStatus</code>: Whether the configuration is shared with other Amazon Web Services accounts or shared with the current account by
    /// another Amazon Web Services account. Sharing is configured through Resource Access Manager (RAM).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Status</code>: The current status of the configuration. Valid values include the following:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATING</code>: Resolver is creating the query logging configuration.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATED</code>: The query logging configuration was successfully created.
    /// Resolver is logging queries that originate in the specified VPC.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETING</code>: Resolver is deleting this query logging configuration.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code>: Resolver either couldn't create or couldn't delete the query logging configuration.
    /// Here are two common causes:</p>
    /// <ul>
    /// <li>
    /// <p>The specified destination (for example, an Amazon S3 bucket) was deleted.</p>
    /// </li>
    /// <li>
    /// <p>Permissions don't allow sending logs to the destination.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    pub fn sort_by(&self) -> std::option::Option<&str> {
        self.sort_by.as_deref()
    }
    /// <p>If you specified a value for <code>SortBy</code>, the order that you want query logging configurations to be listed in,
    /// <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
    /// <note>
    /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the <code>NextToken</code> parameter,
    /// you must use the same value for <code>SortOrder</code>, if any, as in the previous request.</p>
    /// </note>
    pub fn sort_order(&self) -> std::option::Option<&crate::model::SortOrder> {
        self.sort_order.as_ref()
    }
}
impl std::fmt::Debug for ListResolverQueryLogConfigsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResolverQueryLogConfigsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("filters", &self.filters);
        formatter.field("sort_by", &self.sort_by);
        formatter.field("sort_order", &self.sort_order);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResolverQueryLogConfigAssociationsInput {
    /// <p>The maximum number of query logging associations that you want to return in the response to a <code>ListResolverQueryLogConfigAssociations</code> request.
    /// If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 query logging associations. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>For the first <code>ListResolverQueryLogConfigAssociations</code> request, omit this value.</p>
    /// <p>If there are more than <code>MaxResults</code> query logging associations that match the values that you specify for <code>Filters</code>,
    /// you can submit another <code>ListResolverQueryLogConfigAssociations</code> request to get the next group of associations. In the next request, specify the value of
    /// <code>NextToken</code> from the previous response. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An optional specification to return a subset of query logging associations.</p>
    /// <note>
    /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigAssociations</code> request and specify the <code>NextToken</code> parameter,
    /// you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>
    /// </note>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>The element that you want Resolver to sort query logging associations by. </p>
    /// <note>
    /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigAssociations</code> request and specify the <code>NextToken</code> parameter,
    /// you must use the same value for <code>SortBy</code>, if any, as in the previous request.</p>
    /// </note>
    ///
    /// <p>Valid values include the following elements:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CreationTime</code>: The ID of the query logging association.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Error</code>: If the value of <code>Status</code> is <code>FAILED</code>, the value of <code>Error</code>
    /// indicates the cause: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>DESTINATION_NOT_FOUND</code>: The specified destination (for example, an Amazon S3 bucket) was deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ACCESS_DENIED</code>: Permissions don't allow sending logs to the destination.</p>
    /// </li>
    /// </ul>
    /// <p>If <code>Status</code> is a value other than <code>FAILED</code>, <code>ERROR</code> is null.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Id</code>: The ID of the query logging association</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ResolverQueryLogConfigId</code>: The ID of the query logging configuration</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ResourceId</code>: The ID of the VPC that is associated with the query logging configuration</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Status</code>: The current status of the configuration. Valid values include the following:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATING</code>: Resolver is creating an association between an Amazon VPC and a query logging configuration.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATED</code>: The association between an Amazon VPC and a query logging configuration
    /// was successfully created. Resolver is logging queries that originate in the specified VPC.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETING</code>: Resolver is deleting this query logging association.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code>: Resolver either couldn't create or couldn't delete the query logging association.
    /// Here are two common causes:</p>
    /// <ul>
    /// <li>
    /// <p>The specified destination (for example, an Amazon S3 bucket) was deleted.</p>
    /// </li>
    /// <li>
    /// <p>Permissions don't allow sending logs to the destination.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    pub sort_by: std::option::Option<std::string::String>,
    /// <p>If you specified a value for <code>SortBy</code>, the order that you want query logging associations to be listed in,
    /// <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
    /// <note>
    /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigAssociations</code> request and specify the <code>NextToken</code> parameter,
    /// you must use the same value for <code>SortOrder</code>, if any, as in the previous request.</p>
    /// </note>
    pub sort_order: std::option::Option<crate::model::SortOrder>,
}
impl ListResolverQueryLogConfigAssociationsInput {
    /// <p>The maximum number of query logging associations that you want to return in the response to a <code>ListResolverQueryLogConfigAssociations</code> request.
    /// If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 query logging associations. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>For the first <code>ListResolverQueryLogConfigAssociations</code> request, omit this value.</p>
    /// <p>If there are more than <code>MaxResults</code> query logging associations that match the values that you specify for <code>Filters</code>,
    /// you can submit another <code>ListResolverQueryLogConfigAssociations</code> request to get the next group of associations. In the next request, specify the value of
    /// <code>NextToken</code> from the previous response. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>An optional specification to return a subset of query logging associations.</p>
    /// <note>
    /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigAssociations</code> request and specify the <code>NextToken</code> parameter,
    /// you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>
    /// </note>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
    /// <p>The element that you want Resolver to sort query logging associations by. </p>
    /// <note>
    /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigAssociations</code> request and specify the <code>NextToken</code> parameter,
    /// you must use the same value for <code>SortBy</code>, if any, as in the previous request.</p>
    /// </note>
    ///
    /// <p>Valid values include the following elements:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CreationTime</code>: The ID of the query logging association.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Error</code>: If the value of <code>Status</code> is <code>FAILED</code>, the value of <code>Error</code>
    /// indicates the cause: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>DESTINATION_NOT_FOUND</code>: The specified destination (for example, an Amazon S3 bucket) was deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ACCESS_DENIED</code>: Permissions don't allow sending logs to the destination.</p>
    /// </li>
    /// </ul>
    /// <p>If <code>Status</code> is a value other than <code>FAILED</code>, <code>ERROR</code> is null.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Id</code>: The ID of the query logging association</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ResolverQueryLogConfigId</code>: The ID of the query logging configuration</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ResourceId</code>: The ID of the VPC that is associated with the query logging configuration</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Status</code>: The current status of the configuration. Valid values include the following:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATING</code>: Resolver is creating an association between an Amazon VPC and a query logging configuration.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATED</code>: The association between an Amazon VPC and a query logging configuration
    /// was successfully created. Resolver is logging queries that originate in the specified VPC.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETING</code>: Resolver is deleting this query logging association.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code>: Resolver either couldn't create or couldn't delete the query logging association.
    /// Here are two common causes:</p>
    /// <ul>
    /// <li>
    /// <p>The specified destination (for example, an Amazon S3 bucket) was deleted.</p>
    /// </li>
    /// <li>
    /// <p>Permissions don't allow sending logs to the destination.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    pub fn sort_by(&self) -> std::option::Option<&str> {
        self.sort_by.as_deref()
    }
    /// <p>If you specified a value for <code>SortBy</code>, the order that you want query logging associations to be listed in,
    /// <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
    /// <note>
    /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigAssociations</code> request and specify the <code>NextToken</code> parameter,
    /// you must use the same value for <code>SortOrder</code>, if any, as in the previous request.</p>
    /// </note>
    pub fn sort_order(&self) -> std::option::Option<&crate::model::SortOrder> {
        self.sort_order.as_ref()
    }
}
impl std::fmt::Debug for ListResolverQueryLogConfigAssociationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResolverQueryLogConfigAssociationsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("filters", &self.filters);
        formatter.field("sort_by", &self.sort_by);
        formatter.field("sort_order", &self.sort_order);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResolverEndpointsInput {
    /// <p>The maximum number of Resolver endpoints that you want to return in the response to a <code>ListResolverEndpoints</code> request.
    /// If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 Resolver endpoints. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>For the first <code>ListResolverEndpoints</code> request, omit this value.</p>
    /// <p>If you have more than <code>MaxResults</code> Resolver endpoints, you can submit another <code>ListResolverEndpoints</code> request
    /// to get the next group of Resolver endpoints. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An optional specification to return a subset of Resolver endpoints, such as all inbound Resolver endpoints.</p>
    /// <note>
    /// <p>If you submit a second or subsequent <code>ListResolverEndpoints</code> request and specify the <code>NextToken</code> parameter,
    /// you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>
    /// </note>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
}
impl ListResolverEndpointsInput {
    /// <p>The maximum number of Resolver endpoints that you want to return in the response to a <code>ListResolverEndpoints</code> request.
    /// If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 Resolver endpoints. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>For the first <code>ListResolverEndpoints</code> request, omit this value.</p>
    /// <p>If you have more than <code>MaxResults</code> Resolver endpoints, you can submit another <code>ListResolverEndpoints</code> request
    /// to get the next group of Resolver endpoints. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>An optional specification to return a subset of Resolver endpoints, such as all inbound Resolver endpoints.</p>
    /// <note>
    /// <p>If you submit a second or subsequent <code>ListResolverEndpoints</code> request and specify the <code>NextToken</code> parameter,
    /// you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>
    /// </note>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
}
impl std::fmt::Debug for ListResolverEndpointsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResolverEndpointsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("filters", &self.filters);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResolverEndpointIpAddressesInput {
    /// <p>The ID of the Resolver endpoint that you want to get IP addresses for.</p>
    pub resolver_endpoint_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of IP addresses that you want to return in the response to a <code>ListResolverEndpointIpAddresses</code> request.
    /// If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 IP addresses. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>For the first <code>ListResolverEndpointIpAddresses</code> request, omit this value.</p>
    /// <p>If the specified Resolver endpoint has more than <code>MaxResults</code> IP addresses, you can submit another
    /// <code>ListResolverEndpointIpAddresses</code> request to get the next group of IP addresses. In the next request, specify the value of
    /// <code>NextToken</code> from the previous response. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListResolverEndpointIpAddressesInput {
    /// <p>The ID of the Resolver endpoint that you want to get IP addresses for.</p>
    pub fn resolver_endpoint_id(&self) -> std::option::Option<&str> {
        self.resolver_endpoint_id.as_deref()
    }
    /// <p>The maximum number of IP addresses that you want to return in the response to a <code>ListResolverEndpointIpAddresses</code> request.
    /// If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 IP addresses. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>For the first <code>ListResolverEndpointIpAddresses</code> request, omit this value.</p>
    /// <p>If the specified Resolver endpoint has more than <code>MaxResults</code> IP addresses, you can submit another
    /// <code>ListResolverEndpointIpAddresses</code> request to get the next group of IP addresses. In the next request, specify the value of
    /// <code>NextToken</code> from the previous response. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListResolverEndpointIpAddressesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResolverEndpointIpAddressesInput");
        formatter.field("resolver_endpoint_id", &self.resolver_endpoint_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResolverDnssecConfigsInput {
    /// <p>
    /// <i>Optional</i>: An integer that specifies the maximum number of DNSSEC configuration results that you want Amazon Route 53 to return.
    /// If you don't specify a value for <code>MaxResults</code>, Route 53 returns up to 100 configuration per page.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>(Optional) If the current Amazon Web Services account has more than <code>MaxResults</code> DNSSEC configurations, use <code>NextToken</code>
    /// to get the second and subsequent pages of results.</p>
    /// <p>For the first <code>ListResolverDnssecConfigs</code> request, omit this value.</p>
    /// <p>For the second and subsequent requests, get the value of <code>NextToken</code> from the previous response and specify that value
    /// for <code>NextToken</code> in the request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An optional specification to return a subset of objects.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
}
impl ListResolverDnssecConfigsInput {
    /// <p>
    /// <i>Optional</i>: An integer that specifies the maximum number of DNSSEC configuration results that you want Amazon Route 53 to return.
    /// If you don't specify a value for <code>MaxResults</code>, Route 53 returns up to 100 configuration per page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>(Optional) If the current Amazon Web Services account has more than <code>MaxResults</code> DNSSEC configurations, use <code>NextToken</code>
    /// to get the second and subsequent pages of results.</p>
    /// <p>For the first <code>ListResolverDnssecConfigs</code> request, omit this value.</p>
    /// <p>For the second and subsequent requests, get the value of <code>NextToken</code> from the previous response and specify that value
    /// for <code>NextToken</code> in the request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>An optional specification to return a subset of objects.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
}
impl std::fmt::Debug for ListResolverDnssecConfigsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResolverDnssecConfigsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("filters", &self.filters);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResolverConfigsInput {
    /// <p>The maximum number of Resolver configurations that you want to return in the response to
    /// a <code>ListResolverConfigs</code> request. If you don't specify a value for <code>MaxResults</code>,
    /// up to 100 Resolver configurations are returned.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>(Optional) If the current Amazon Web Services account has more than <code>MaxResults</code> Resolver configurations, use
    /// <code>NextToken</code> to get the second and subsequent pages of results.</p>
    /// <p>For the first <code>ListResolverConfigs</code> request, omit this value.</p>
    /// <p>For the second and subsequent requests, get the value of <code>NextToken</code> from the previous response and
    /// specify that value for <code>NextToken</code> in the request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListResolverConfigsInput {
    /// <p>The maximum number of Resolver configurations that you want to return in the response to
    /// a <code>ListResolverConfigs</code> request. If you don't specify a value for <code>MaxResults</code>,
    /// up to 100 Resolver configurations are returned.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>(Optional) If the current Amazon Web Services account has more than <code>MaxResults</code> Resolver configurations, use
    /// <code>NextToken</code> to get the second and subsequent pages of results.</p>
    /// <p>For the first <code>ListResolverConfigs</code> request, omit this value.</p>
    /// <p>For the second and subsequent requests, get the value of <code>NextToken</code> from the previous response and
    /// specify that value for <code>NextToken</code> in the request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListResolverConfigsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResolverConfigsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFirewallRulesInput {
    /// <p>The unique identifier of the firewall rule group that you want to retrieve the rules for. </p>
    pub firewall_rule_group_id: std::option::Option<std::string::String>,
    /// <p>Optional additional filter for the rules to retrieve.</p>
    /// <p>The setting that determines the processing order of the rules in a rule group. DNS Firewall
    /// processes the rules in a rule group by order of priority, starting from the lowest setting.</p>
    pub priority: std::option::Option<i32>,
    /// <p>Optional additional filter for the rules to retrieve.</p>
    /// <p>The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ALLOW</code> - Permit the request to go through.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ALERT</code> - Permit the request to go through but send an alert to the logs.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>BLOCK</code> - Disallow the request. If this is specified, additional handling details are provided in the rule's <code>BlockResponse</code> setting. </p>
    /// </li>
    /// </ul>
    pub action: std::option::Option<crate::model::Action>,
    /// <p>The maximum number of objects that you want Resolver to return for this request. If more
    /// objects are available, in the response, Resolver provides a
    /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
    /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>For the first call to this list request, omit this value.</p>
    /// <p>When you request a list of objects, Resolver returns at most the number of objects
    /// specified in <code>MaxResults</code>. If more objects are available for retrieval,
    /// Resolver returns a <code>NextToken</code> value in the response. To retrieve the next
    /// batch of objects, use the token that was returned for the prior request in your next request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListFirewallRulesInput {
    /// <p>The unique identifier of the firewall rule group that you want to retrieve the rules for. </p>
    pub fn firewall_rule_group_id(&self) -> std::option::Option<&str> {
        self.firewall_rule_group_id.as_deref()
    }
    /// <p>Optional additional filter for the rules to retrieve.</p>
    /// <p>The setting that determines the processing order of the rules in a rule group. DNS Firewall
    /// processes the rules in a rule group by order of priority, starting from the lowest setting.</p>
    pub fn priority(&self) -> std::option::Option<i32> {
        self.priority
    }
    /// <p>Optional additional filter for the rules to retrieve.</p>
    /// <p>The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ALLOW</code> - Permit the request to go through.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ALERT</code> - Permit the request to go through but send an alert to the logs.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>BLOCK</code> - Disallow the request. If this is specified, additional handling details are provided in the rule's <code>BlockResponse</code> setting. </p>
    /// </li>
    /// </ul>
    pub fn action(&self) -> std::option::Option<&crate::model::Action> {
        self.action.as_ref()
    }
    /// <p>The maximum number of objects that you want Resolver to return for this request. If more
    /// objects are available, in the response, Resolver provides a
    /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
    /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>For the first call to this list request, omit this value.</p>
    /// <p>When you request a list of objects, Resolver returns at most the number of objects
    /// specified in <code>MaxResults</code>. If more objects are available for retrieval,
    /// Resolver returns a <code>NextToken</code> value in the response. To retrieve the next
    /// batch of objects, use the token that was returned for the prior request in your next request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListFirewallRulesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFirewallRulesInput");
        formatter.field("firewall_rule_group_id", &self.firewall_rule_group_id);
        formatter.field("priority", &self.priority);
        formatter.field("action", &self.action);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFirewallRuleGroupsInput {
    /// <p>The maximum number of objects that you want Resolver to return for this request. If more
    /// objects are available, in the response, Resolver provides a
    /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
    /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>For the first call to this list request, omit this value.</p>
    /// <p>When you request a list of objects, Resolver returns at most the number of objects
    /// specified in <code>MaxResults</code>. If more objects are available for retrieval,
    /// Resolver returns a <code>NextToken</code> value in the response. To retrieve the next
    /// batch of objects, use the token that was returned for the prior request in your next request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListFirewallRuleGroupsInput {
    /// <p>The maximum number of objects that you want Resolver to return for this request. If more
    /// objects are available, in the response, Resolver provides a
    /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
    /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>For the first call to this list request, omit this value.</p>
    /// <p>When you request a list of objects, Resolver returns at most the number of objects
    /// specified in <code>MaxResults</code>. If more objects are available for retrieval,
    /// Resolver returns a <code>NextToken</code> value in the response. To retrieve the next
    /// batch of objects, use the token that was returned for the prior request in your next request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListFirewallRuleGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFirewallRuleGroupsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFirewallRuleGroupAssociationsInput {
    /// <p>The unique identifier of the firewall rule group that you want to retrieve the associations
    /// for. Leave this blank to retrieve associations for any rule group. </p>
    pub firewall_rule_group_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the VPC that you want to retrieve the associations
    /// for. Leave this blank to retrieve associations for any VPC. </p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>The setting that determines the processing order of the rule group among the rule
    /// groups that are associated with a single VPC. DNS Firewall filters VPC traffic starting
    /// from the rule group with the lowest numeric priority setting. </p>
    pub priority: std::option::Option<i32>,
    /// <p>The association <code>Status</code> setting that you want DNS Firewall to filter on for the list. If you don't specify this, then DNS Firewall returns all associations, regardless of status.</p>
    pub status: std::option::Option<crate::model::FirewallRuleGroupAssociationStatus>,
    /// <p>The maximum number of objects that you want Resolver to return for this request. If more
    /// objects are available, in the response, Resolver provides a
    /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
    /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>For the first call to this list request, omit this value.</p>
    /// <p>When you request a list of objects, Resolver returns at most the number of objects
    /// specified in <code>MaxResults</code>. If more objects are available for retrieval,
    /// Resolver returns a <code>NextToken</code> value in the response. To retrieve the next
    /// batch of objects, use the token that was returned for the prior request in your next request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListFirewallRuleGroupAssociationsInput {
    /// <p>The unique identifier of the firewall rule group that you want to retrieve the associations
    /// for. Leave this blank to retrieve associations for any rule group. </p>
    pub fn firewall_rule_group_id(&self) -> std::option::Option<&str> {
        self.firewall_rule_group_id.as_deref()
    }
    /// <p>The unique identifier of the VPC that you want to retrieve the associations
    /// for. Leave this blank to retrieve associations for any VPC. </p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>The setting that determines the processing order of the rule group among the rule
    /// groups that are associated with a single VPC. DNS Firewall filters VPC traffic starting
    /// from the rule group with the lowest numeric priority setting. </p>
    pub fn priority(&self) -> std::option::Option<i32> {
        self.priority
    }
    /// <p>The association <code>Status</code> setting that you want DNS Firewall to filter on for the list. If you don't specify this, then DNS Firewall returns all associations, regardless of status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::FirewallRuleGroupAssociationStatus> {
        self.status.as_ref()
    }
    /// <p>The maximum number of objects that you want Resolver to return for this request. If more
    /// objects are available, in the response, Resolver provides a
    /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
    /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>For the first call to this list request, omit this value.</p>
    /// <p>When you request a list of objects, Resolver returns at most the number of objects
    /// specified in <code>MaxResults</code>. If more objects are available for retrieval,
    /// Resolver returns a <code>NextToken</code> value in the response. To retrieve the next
    /// batch of objects, use the token that was returned for the prior request in your next request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListFirewallRuleGroupAssociationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFirewallRuleGroupAssociationsInput");
        formatter.field("firewall_rule_group_id", &self.firewall_rule_group_id);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("priority", &self.priority);
        formatter.field("status", &self.status);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFirewallDomainsInput {
    /// <p>The ID of the domain list whose domains you want to retrieve. </p>
    pub firewall_domain_list_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of objects that you want Resolver to return for this request. If more
    /// objects are available, in the response, Resolver provides a
    /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
    /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>For the first call to this list request, omit this value.</p>
    /// <p>When you request a list of objects, Resolver returns at most the number of objects
    /// specified in <code>MaxResults</code>. If more objects are available for retrieval,
    /// Resolver returns a <code>NextToken</code> value in the response. To retrieve the next
    /// batch of objects, use the token that was returned for the prior request in your next request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListFirewallDomainsInput {
    /// <p>The ID of the domain list whose domains you want to retrieve. </p>
    pub fn firewall_domain_list_id(&self) -> std::option::Option<&str> {
        self.firewall_domain_list_id.as_deref()
    }
    /// <p>The maximum number of objects that you want Resolver to return for this request. If more
    /// objects are available, in the response, Resolver provides a
    /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
    /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>For the first call to this list request, omit this value.</p>
    /// <p>When you request a list of objects, Resolver returns at most the number of objects
    /// specified in <code>MaxResults</code>. If more objects are available for retrieval,
    /// Resolver returns a <code>NextToken</code> value in the response. To retrieve the next
    /// batch of objects, use the token that was returned for the prior request in your next request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListFirewallDomainsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFirewallDomainsInput");
        formatter.field("firewall_domain_list_id", &self.firewall_domain_list_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFirewallDomainListsInput {
    /// <p>The maximum number of objects that you want Resolver to return for this request. If more
    /// objects are available, in the response, Resolver provides a
    /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
    /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>For the first call to this list request, omit this value.</p>
    /// <p>When you request a list of objects, Resolver returns at most the number of objects
    /// specified in <code>MaxResults</code>. If more objects are available for retrieval,
    /// Resolver returns a <code>NextToken</code> value in the response. To retrieve the next
    /// batch of objects, use the token that was returned for the prior request in your next request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListFirewallDomainListsInput {
    /// <p>The maximum number of objects that you want Resolver to return for this request. If more
    /// objects are available, in the response, Resolver provides a
    /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
    /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>For the first call to this list request, omit this value.</p>
    /// <p>When you request a list of objects, Resolver returns at most the number of objects
    /// specified in <code>MaxResults</code>. If more objects are available for retrieval,
    /// Resolver returns a <code>NextToken</code> value in the response. To retrieve the next
    /// batch of objects, use the token that was returned for the prior request in your next request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListFirewallDomainListsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFirewallDomainListsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFirewallConfigsInput {
    /// <p>The maximum number of objects that you want Resolver to return for this request. If more
    /// objects are available, in the response, Resolver provides a
    /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
    /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>For the first call to this list request, omit this value.</p>
    /// <p>When you request a list of objects, Resolver returns at most the number of objects
    /// specified in <code>MaxResults</code>. If more objects are available for retrieval,
    /// Resolver returns a <code>NextToken</code> value in the response. To retrieve the next
    /// batch of objects, use the token that was returned for the prior request in your next request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListFirewallConfigsInput {
    /// <p>The maximum number of objects that you want Resolver to return for this request. If more
    /// objects are available, in the response, Resolver provides a
    /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
    /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>For the first call to this list request, omit this value.</p>
    /// <p>When you request a list of objects, Resolver returns at most the number of objects
    /// specified in <code>MaxResults</code>. If more objects are available for retrieval,
    /// Resolver returns a <code>NextToken</code> value in the response. To retrieve the next
    /// batch of objects, use the token that was returned for the prior request in your next request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListFirewallConfigsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFirewallConfigsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportFirewallDomainsInput {
    /// <p>The ID of the domain list that you want to modify with the import operation.</p>
    pub firewall_domain_list_id: std::option::Option<std::string::String>,
    /// <p>What you want DNS Firewall to do with the domains that are listed in the file. This must be set to <code>REPLACE</code>, which updates the domain list to exactly match the list in the file. </p>
    pub operation: std::option::Option<crate::model::FirewallDomainImportOperation>,
    /// <p>The fully qualified URL or URI of the file stored in Amazon Simple Storage Service
    /// (Amazon S3) that contains the list of domains to import.</p>
    /// <p>The file must be in an S3 bucket that's in the same Region
    /// as your DNS Firewall. The file must be a text file and must contain a single domain per line.</p>
    pub domain_file_url: std::option::Option<std::string::String>,
}
impl ImportFirewallDomainsInput {
    /// <p>The ID of the domain list that you want to modify with the import operation.</p>
    pub fn firewall_domain_list_id(&self) -> std::option::Option<&str> {
        self.firewall_domain_list_id.as_deref()
    }
    /// <p>What you want DNS Firewall to do with the domains that are listed in the file. This must be set to <code>REPLACE</code>, which updates the domain list to exactly match the list in the file. </p>
    pub fn operation(&self) -> std::option::Option<&crate::model::FirewallDomainImportOperation> {
        self.operation.as_ref()
    }
    /// <p>The fully qualified URL or URI of the file stored in Amazon Simple Storage Service
    /// (Amazon S3) that contains the list of domains to import.</p>
    /// <p>The file must be in an S3 bucket that's in the same Region
    /// as your DNS Firewall. The file must be a text file and must contain a single domain per line.</p>
    pub fn domain_file_url(&self) -> std::option::Option<&str> {
        self.domain_file_url.as_deref()
    }
}
impl std::fmt::Debug for ImportFirewallDomainsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportFirewallDomainsInput");
        formatter.field("firewall_domain_list_id", &self.firewall_domain_list_id);
        formatter.field("operation", &self.operation);
        formatter.field("domain_file_url", &self.domain_file_url);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResolverRulePolicyInput {
    /// <p>The ID of the Resolver rule that you want to get the Resolver rule policy for.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl GetResolverRulePolicyInput {
    /// <p>The ID of the Resolver rule that you want to get the Resolver rule policy for.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for GetResolverRulePolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResolverRulePolicyInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResolverRuleAssociationInput {
    /// <p>The ID of the Resolver rule association that you want to get information about.</p>
    pub resolver_rule_association_id: std::option::Option<std::string::String>,
}
impl GetResolverRuleAssociationInput {
    /// <p>The ID of the Resolver rule association that you want to get information about.</p>
    pub fn resolver_rule_association_id(&self) -> std::option::Option<&str> {
        self.resolver_rule_association_id.as_deref()
    }
}
impl std::fmt::Debug for GetResolverRuleAssociationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResolverRuleAssociationInput");
        formatter.field(
            "resolver_rule_association_id",
            &self.resolver_rule_association_id,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResolverRuleInput {
    /// <p>The ID of the Resolver rule that you want to get information about.</p>
    pub resolver_rule_id: std::option::Option<std::string::String>,
}
impl GetResolverRuleInput {
    /// <p>The ID of the Resolver rule that you want to get information about.</p>
    pub fn resolver_rule_id(&self) -> std::option::Option<&str> {
        self.resolver_rule_id.as_deref()
    }
}
impl std::fmt::Debug for GetResolverRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResolverRuleInput");
        formatter.field("resolver_rule_id", &self.resolver_rule_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResolverQueryLogConfigPolicyInput {
    /// <p>The ARN of the query logging configuration that you want to get the query logging policy for.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl GetResolverQueryLogConfigPolicyInput {
    /// <p>The ARN of the query logging configuration that you want to get the query logging policy for.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for GetResolverQueryLogConfigPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResolverQueryLogConfigPolicyInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResolverQueryLogConfigAssociationInput {
    /// <p>The ID of the Resolver query logging configuration association that you want to get information about.</p>
    pub resolver_query_log_config_association_id: std::option::Option<std::string::String>,
}
impl GetResolverQueryLogConfigAssociationInput {
    /// <p>The ID of the Resolver query logging configuration association that you want to get information about.</p>
    pub fn resolver_query_log_config_association_id(&self) -> std::option::Option<&str> {
        self.resolver_query_log_config_association_id.as_deref()
    }
}
impl std::fmt::Debug for GetResolverQueryLogConfigAssociationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResolverQueryLogConfigAssociationInput");
        formatter.field(
            "resolver_query_log_config_association_id",
            &self.resolver_query_log_config_association_id,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResolverQueryLogConfigInput {
    /// <p>The ID of the Resolver query logging configuration that you want to get information about.</p>
    pub resolver_query_log_config_id: std::option::Option<std::string::String>,
}
impl GetResolverQueryLogConfigInput {
    /// <p>The ID of the Resolver query logging configuration that you want to get information about.</p>
    pub fn resolver_query_log_config_id(&self) -> std::option::Option<&str> {
        self.resolver_query_log_config_id.as_deref()
    }
}
impl std::fmt::Debug for GetResolverQueryLogConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResolverQueryLogConfigInput");
        formatter.field(
            "resolver_query_log_config_id",
            &self.resolver_query_log_config_id,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResolverEndpointInput {
    /// <p>The ID of the Resolver endpoint that you want to get information about.</p>
    pub resolver_endpoint_id: std::option::Option<std::string::String>,
}
impl GetResolverEndpointInput {
    /// <p>The ID of the Resolver endpoint that you want to get information about.</p>
    pub fn resolver_endpoint_id(&self) -> std::option::Option<&str> {
        self.resolver_endpoint_id.as_deref()
    }
}
impl std::fmt::Debug for GetResolverEndpointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResolverEndpointInput");
        formatter.field("resolver_endpoint_id", &self.resolver_endpoint_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResolverDnssecConfigInput {
    /// <p>The ID of the virtual private cloud (VPC) for the DNSSEC validation status.</p>
    pub resource_id: std::option::Option<std::string::String>,
}
impl GetResolverDnssecConfigInput {
    /// <p>The ID of the virtual private cloud (VPC) for the DNSSEC validation status.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
}
impl std::fmt::Debug for GetResolverDnssecConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResolverDnssecConfigInput");
        formatter.field("resource_id", &self.resource_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResolverConfigInput {
    /// <p>Resource ID of the Amazon VPC that you want to get information about.</p>
    pub resource_id: std::option::Option<std::string::String>,
}
impl GetResolverConfigInput {
    /// <p>Resource ID of the Amazon VPC that you want to get information about.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
}
impl std::fmt::Debug for GetResolverConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResolverConfigInput");
        formatter.field("resource_id", &self.resource_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFirewallRuleGroupPolicyInput {
    /// <p>The ARN (Amazon Resource Name) for the rule group.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl GetFirewallRuleGroupPolicyInput {
    /// <p>The ARN (Amazon Resource Name) for the rule group.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for GetFirewallRuleGroupPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFirewallRuleGroupPolicyInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFirewallRuleGroupAssociationInput {
    /// <p>The identifier of the <a>FirewallRuleGroupAssociation</a>. </p>
    pub firewall_rule_group_association_id: std::option::Option<std::string::String>,
}
impl GetFirewallRuleGroupAssociationInput {
    /// <p>The identifier of the <a>FirewallRuleGroupAssociation</a>. </p>
    pub fn firewall_rule_group_association_id(&self) -> std::option::Option<&str> {
        self.firewall_rule_group_association_id.as_deref()
    }
}
impl std::fmt::Debug for GetFirewallRuleGroupAssociationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFirewallRuleGroupAssociationInput");
        formatter.field(
            "firewall_rule_group_association_id",
            &self.firewall_rule_group_association_id,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFirewallRuleGroupInput {
    /// <p>The unique identifier of the firewall rule group. </p>
    pub firewall_rule_group_id: std::option::Option<std::string::String>,
}
impl GetFirewallRuleGroupInput {
    /// <p>The unique identifier of the firewall rule group. </p>
    pub fn firewall_rule_group_id(&self) -> std::option::Option<&str> {
        self.firewall_rule_group_id.as_deref()
    }
}
impl std::fmt::Debug for GetFirewallRuleGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFirewallRuleGroupInput");
        formatter.field("firewall_rule_group_id", &self.firewall_rule_group_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFirewallDomainListInput {
    /// <p>The ID of the domain list.  </p>
    pub firewall_domain_list_id: std::option::Option<std::string::String>,
}
impl GetFirewallDomainListInput {
    /// <p>The ID of the domain list.  </p>
    pub fn firewall_domain_list_id(&self) -> std::option::Option<&str> {
        self.firewall_domain_list_id.as_deref()
    }
}
impl std::fmt::Debug for GetFirewallDomainListInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFirewallDomainListInput");
        formatter.field("firewall_domain_list_id", &self.firewall_domain_list_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFirewallConfigInput {
    /// <p>The ID of the VPC from Amazon VPC that the configuration is for.</p>
    pub resource_id: std::option::Option<std::string::String>,
}
impl GetFirewallConfigInput {
    /// <p>The ID of the VPC from Amazon VPC that the configuration is for.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
}
impl std::fmt::Debug for GetFirewallConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFirewallConfigInput");
        formatter.field("resource_id", &self.resource_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateResolverRuleInput {
    /// <p>The ID of the VPC that you want to disassociate the Resolver rule from.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>The ID of the Resolver rule that you want to disassociate from the specified VPC.</p>
    pub resolver_rule_id: std::option::Option<std::string::String>,
}
impl DisassociateResolverRuleInput {
    /// <p>The ID of the VPC that you want to disassociate the Resolver rule from.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>The ID of the Resolver rule that you want to disassociate from the specified VPC.</p>
    pub fn resolver_rule_id(&self) -> std::option::Option<&str> {
        self.resolver_rule_id.as_deref()
    }
}
impl std::fmt::Debug for DisassociateResolverRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateResolverRuleInput");
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("resolver_rule_id", &self.resolver_rule_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateResolverQueryLogConfigInput {
    /// <p>The ID of the query logging configuration that you want to disassociate a specified VPC from.</p>
    pub resolver_query_log_config_id: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon VPC that you want to disassociate from a specified query logging configuration.</p>
    pub resource_id: std::option::Option<std::string::String>,
}
impl DisassociateResolverQueryLogConfigInput {
    /// <p>The ID of the query logging configuration that you want to disassociate a specified VPC from.</p>
    pub fn resolver_query_log_config_id(&self) -> std::option::Option<&str> {
        self.resolver_query_log_config_id.as_deref()
    }
    /// <p>The ID of the Amazon VPC that you want to disassociate from a specified query logging configuration.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
}
impl std::fmt::Debug for DisassociateResolverQueryLogConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateResolverQueryLogConfigInput");
        formatter.field(
            "resolver_query_log_config_id",
            &self.resolver_query_log_config_id,
        );
        formatter.field("resource_id", &self.resource_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateResolverEndpointIpAddressInput {
    /// <p>The ID of the Resolver endpoint that you want to disassociate an IP address from.</p>
    pub resolver_endpoint_id: std::option::Option<std::string::String>,
    /// <p>The IPv4 address that you want to remove from a Resolver endpoint.</p>
    pub ip_address: std::option::Option<crate::model::IpAddressUpdate>,
}
impl DisassociateResolverEndpointIpAddressInput {
    /// <p>The ID of the Resolver endpoint that you want to disassociate an IP address from.</p>
    pub fn resolver_endpoint_id(&self) -> std::option::Option<&str> {
        self.resolver_endpoint_id.as_deref()
    }
    /// <p>The IPv4 address that you want to remove from a Resolver endpoint.</p>
    pub fn ip_address(&self) -> std::option::Option<&crate::model::IpAddressUpdate> {
        self.ip_address.as_ref()
    }
}
impl std::fmt::Debug for DisassociateResolverEndpointIpAddressInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateResolverEndpointIpAddressInput");
        formatter.field("resolver_endpoint_id", &self.resolver_endpoint_id);
        formatter.field("ip_address", &self.ip_address);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateFirewallRuleGroupInput {
    /// <p>The identifier of the <a>FirewallRuleGroupAssociation</a>. </p>
    pub firewall_rule_group_association_id: std::option::Option<std::string::String>,
}
impl DisassociateFirewallRuleGroupInput {
    /// <p>The identifier of the <a>FirewallRuleGroupAssociation</a>. </p>
    pub fn firewall_rule_group_association_id(&self) -> std::option::Option<&str> {
        self.firewall_rule_group_association_id.as_deref()
    }
}
impl std::fmt::Debug for DisassociateFirewallRuleGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateFirewallRuleGroupInput");
        formatter.field(
            "firewall_rule_group_association_id",
            &self.firewall_rule_group_association_id,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteResolverRuleInput {
    /// <p>The ID of the Resolver rule that you want to delete.</p>
    pub resolver_rule_id: std::option::Option<std::string::String>,
}
impl DeleteResolverRuleInput {
    /// <p>The ID of the Resolver rule that you want to delete.</p>
    pub fn resolver_rule_id(&self) -> std::option::Option<&str> {
        self.resolver_rule_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteResolverRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteResolverRuleInput");
        formatter.field("resolver_rule_id", &self.resolver_rule_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteResolverQueryLogConfigInput {
    /// <p>The ID of the query logging configuration that you want to delete.</p>
    pub resolver_query_log_config_id: std::option::Option<std::string::String>,
}
impl DeleteResolverQueryLogConfigInput {
    /// <p>The ID of the query logging configuration that you want to delete.</p>
    pub fn resolver_query_log_config_id(&self) -> std::option::Option<&str> {
        self.resolver_query_log_config_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteResolverQueryLogConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteResolverQueryLogConfigInput");
        formatter.field(
            "resolver_query_log_config_id",
            &self.resolver_query_log_config_id,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteResolverEndpointInput {
    /// <p>The ID of the Resolver endpoint that you want to delete.</p>
    pub resolver_endpoint_id: std::option::Option<std::string::String>,
}
impl DeleteResolverEndpointInput {
    /// <p>The ID of the Resolver endpoint that you want to delete.</p>
    pub fn resolver_endpoint_id(&self) -> std::option::Option<&str> {
        self.resolver_endpoint_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteResolverEndpointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteResolverEndpointInput");
        formatter.field("resolver_endpoint_id", &self.resolver_endpoint_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFirewallRuleGroupInput {
    /// <p>The unique identifier of the firewall rule group that you want to delete. </p>
    pub firewall_rule_group_id: std::option::Option<std::string::String>,
}
impl DeleteFirewallRuleGroupInput {
    /// <p>The unique identifier of the firewall rule group that you want to delete. </p>
    pub fn firewall_rule_group_id(&self) -> std::option::Option<&str> {
        self.firewall_rule_group_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteFirewallRuleGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFirewallRuleGroupInput");
        formatter.field("firewall_rule_group_id", &self.firewall_rule_group_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFirewallRuleInput {
    /// <p>The unique identifier of the firewall rule group that you want to delete the rule from. </p>
    pub firewall_rule_group_id: std::option::Option<std::string::String>,
    /// <p>The ID of the domain list that's used in the rule.  </p>
    pub firewall_domain_list_id: std::option::Option<std::string::String>,
}
impl DeleteFirewallRuleInput {
    /// <p>The unique identifier of the firewall rule group that you want to delete the rule from. </p>
    pub fn firewall_rule_group_id(&self) -> std::option::Option<&str> {
        self.firewall_rule_group_id.as_deref()
    }
    /// <p>The ID of the domain list that's used in the rule.  </p>
    pub fn firewall_domain_list_id(&self) -> std::option::Option<&str> {
        self.firewall_domain_list_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteFirewallRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFirewallRuleInput");
        formatter.field("firewall_rule_group_id", &self.firewall_rule_group_id);
        formatter.field("firewall_domain_list_id", &self.firewall_domain_list_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFirewallDomainListInput {
    /// <p>The ID of the domain list that you want to delete. </p>
    pub firewall_domain_list_id: std::option::Option<std::string::String>,
}
impl DeleteFirewallDomainListInput {
    /// <p>The ID of the domain list that you want to delete. </p>
    pub fn firewall_domain_list_id(&self) -> std::option::Option<&str> {
        self.firewall_domain_list_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteFirewallDomainListInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFirewallDomainListInput");
        formatter.field("firewall_domain_list_id", &self.firewall_domain_list_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateResolverRuleInput {
    /// <p>A unique string that identifies the request and that allows failed requests to be retried
    /// without the risk of running the operation twice. <code>CreatorRequestId</code> can be
    /// any unique string, for example, a date/time stamp. </p>
    pub creator_request_id: std::option::Option<std::string::String>,
    /// <p>A friendly name that lets you easily find a rule in the Resolver dashboard in the Route 53 console.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>When you want to forward DNS queries for specified domain name to resolvers on your network, specify <code>FORWARD</code>.</p>
    /// <p>When you have a forwarding rule to forward DNS queries for a domain to your network and you want Resolver to process queries for
    /// a subdomain of that domain, specify <code>SYSTEM</code>.</p>
    /// <p>For example, to forward DNS queries for example.com to resolvers on your network, you create a rule and specify <code>FORWARD</code>
    /// for <code>RuleType</code>. To then have Resolver process queries for apex.example.com, you create a rule and specify
    /// <code>SYSTEM</code> for <code>RuleType</code>.</p>
    /// <p>Currently, only Resolver can create rules that have a value of <code>RECURSIVE</code> for <code>RuleType</code>.</p>
    pub rule_type: std::option::Option<crate::model::RuleTypeOption>,
    /// <p>DNS queries for this domain name are forwarded to the IP addresses that you specify in <code>TargetIps</code>. If a query matches
    /// multiple Resolver rules (example.com and www.example.com), outbound DNS queries are routed using the Resolver rule that contains
    /// the most specific domain name (www.example.com).</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The IPs that you want Resolver to forward DNS queries to. You can specify only IPv4 addresses. Separate IP addresses with a space.</p>
    /// <p>
    /// <code>TargetIps</code> is available only when the value of <code>Rule type</code> is <code>FORWARD</code>.</p>
    pub target_ips: std::option::Option<std::vec::Vec<crate::model::TargetAddress>>,
    /// <p>The ID of the outbound Resolver endpoint that you want to use to route DNS queries to the IP addresses that you specify
    /// in <code>TargetIps</code>.</p>
    pub resolver_endpoint_id: std::option::Option<std::string::String>,
    /// <p>A list of the tag keys and values that you want to associate with the endpoint.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateResolverRuleInput {
    /// <p>A unique string that identifies the request and that allows failed requests to be retried
    /// without the risk of running the operation twice. <code>CreatorRequestId</code> can be
    /// any unique string, for example, a date/time stamp. </p>
    pub fn creator_request_id(&self) -> std::option::Option<&str> {
        self.creator_request_id.as_deref()
    }
    /// <p>A friendly name that lets you easily find a rule in the Resolver dashboard in the Route 53 console.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>When you want to forward DNS queries for specified domain name to resolvers on your network, specify <code>FORWARD</code>.</p>
    /// <p>When you have a forwarding rule to forward DNS queries for a domain to your network and you want Resolver to process queries for
    /// a subdomain of that domain, specify <code>SYSTEM</code>.</p>
    /// <p>For example, to forward DNS queries for example.com to resolvers on your network, you create a rule and specify <code>FORWARD</code>
    /// for <code>RuleType</code>. To then have Resolver process queries for apex.example.com, you create a rule and specify
    /// <code>SYSTEM</code> for <code>RuleType</code>.</p>
    /// <p>Currently, only Resolver can create rules that have a value of <code>RECURSIVE</code> for <code>RuleType</code>.</p>
    pub fn rule_type(&self) -> std::option::Option<&crate::model::RuleTypeOption> {
        self.rule_type.as_ref()
    }
    /// <p>DNS queries for this domain name are forwarded to the IP addresses that you specify in <code>TargetIps</code>. If a query matches
    /// multiple Resolver rules (example.com and www.example.com), outbound DNS queries are routed using the Resolver rule that contains
    /// the most specific domain name (www.example.com).</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The IPs that you want Resolver to forward DNS queries to. You can specify only IPv4 addresses. Separate IP addresses with a space.</p>
    /// <p>
    /// <code>TargetIps</code> is available only when the value of <code>Rule type</code> is <code>FORWARD</code>.</p>
    pub fn target_ips(&self) -> std::option::Option<&[crate::model::TargetAddress]> {
        self.target_ips.as_deref()
    }
    /// <p>The ID of the outbound Resolver endpoint that you want to use to route DNS queries to the IP addresses that you specify
    /// in <code>TargetIps</code>.</p>
    pub fn resolver_endpoint_id(&self) -> std::option::Option<&str> {
        self.resolver_endpoint_id.as_deref()
    }
    /// <p>A list of the tag keys and values that you want to associate with the endpoint.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateResolverRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateResolverRuleInput");
        formatter.field("creator_request_id", &self.creator_request_id);
        formatter.field("name", &self.name);
        formatter.field("rule_type", &self.rule_type);
        formatter.field("domain_name", &self.domain_name);
        formatter.field("target_ips", &self.target_ips);
        formatter.field("resolver_endpoint_id", &self.resolver_endpoint_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateResolverQueryLogConfigInput {
    /// <p>The name that you want to give the query logging configuration.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ARN of the resource that you want Resolver to send query logs. You can send query logs to an S3 bucket, a CloudWatch Logs log group,
    /// or a Kinesis Data Firehose delivery stream. Examples of valid values include the following:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <b>S3 bucket</b>: </p>
    /// <p>
    /// <code>arn:aws:s3:::examplebucket</code>
    /// </p>
    /// <p>You can optionally append a file prefix to the end of the ARN.</p>
    /// <p>
    /// <code>arn:aws:s3:::examplebucket/development/</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>CloudWatch Logs log group</b>: </p>
    /// <p>
    /// <code>arn:aws:logs:us-west-1:123456789012:log-group:/mystack-testgroup-12ABC1AB12A1:*</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Kinesis Data Firehose delivery stream</b>:</p>
    /// <p>
    /// <code>arn:aws:kinesis:us-east-2:0123456789:stream/my_stream_name</code>
    /// </p>
    /// </li>
    /// </ul>
    pub destination_arn: std::option::Option<std::string::String>,
    /// <p>A unique string that identifies the request and that allows failed requests to be retried
    /// without the risk of running the operation twice. <code>CreatorRequestId</code> can be
    /// any unique string, for example, a date/time stamp. </p>
    pub creator_request_id: std::option::Option<std::string::String>,
    /// <p>A list of the tag keys and values that you want to associate with the query logging configuration.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateResolverQueryLogConfigInput {
    /// <p>The name that you want to give the query logging configuration.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ARN of the resource that you want Resolver to send query logs. You can send query logs to an S3 bucket, a CloudWatch Logs log group,
    /// or a Kinesis Data Firehose delivery stream. Examples of valid values include the following:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <b>S3 bucket</b>: </p>
    /// <p>
    /// <code>arn:aws:s3:::examplebucket</code>
    /// </p>
    /// <p>You can optionally append a file prefix to the end of the ARN.</p>
    /// <p>
    /// <code>arn:aws:s3:::examplebucket/development/</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>CloudWatch Logs log group</b>: </p>
    /// <p>
    /// <code>arn:aws:logs:us-west-1:123456789012:log-group:/mystack-testgroup-12ABC1AB12A1:*</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Kinesis Data Firehose delivery stream</b>:</p>
    /// <p>
    /// <code>arn:aws:kinesis:us-east-2:0123456789:stream/my_stream_name</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn destination_arn(&self) -> std::option::Option<&str> {
        self.destination_arn.as_deref()
    }
    /// <p>A unique string that identifies the request and that allows failed requests to be retried
    /// without the risk of running the operation twice. <code>CreatorRequestId</code> can be
    /// any unique string, for example, a date/time stamp. </p>
    pub fn creator_request_id(&self) -> std::option::Option<&str> {
        self.creator_request_id.as_deref()
    }
    /// <p>A list of the tag keys and values that you want to associate with the query logging configuration.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateResolverQueryLogConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateResolverQueryLogConfigInput");
        formatter.field("name", &self.name);
        formatter.field("destination_arn", &self.destination_arn);
        formatter.field("creator_request_id", &self.creator_request_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateResolverEndpointInput {
    /// <p>A unique string that identifies the request and that allows failed requests to be retried
    /// without the risk of running the operation twice. <code>CreatorRequestId</code> can be
    /// any unique string, for example, a date/time stamp. </p>
    pub creator_request_id: std::option::Option<std::string::String>,
    /// <p>A friendly name that lets you easily find a configuration in the Resolver dashboard in the Route 53 console.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ID of one or more security groups that you want to use to control access to this VPC. The security group that you specify
    /// must include one or more inbound rules (for inbound Resolver endpoints) or outbound rules (for outbound Resolver endpoints).
    /// Inbound and outbound rules must allow TCP and UDP access. For inbound access, open port 53. For outbound access, open the port
    /// that you're using for DNS queries on your network.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specify the applicable value:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>INBOUND</code>: Resolver forwards DNS queries to the DNS service for a VPC from your network</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>OUTBOUND</code>: Resolver forwards DNS queries from the DNS service for a VPC to your network</p>
    /// </li>
    /// </ul>
    pub direction: std::option::Option<crate::model::ResolverEndpointDirection>,
    /// <p>The subnets and IP addresses in your VPC that DNS queries originate from (for outbound endpoints) or that you forward
    /// DNS queries to (for inbound endpoints). The subnet ID uniquely identifies a VPC. </p>
    pub ip_addresses: std::option::Option<std::vec::Vec<crate::model::IpAddressRequest>>,
    /// <p>A list of the tag keys and values that you want to associate with the endpoint.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateResolverEndpointInput {
    /// <p>A unique string that identifies the request and that allows failed requests to be retried
    /// without the risk of running the operation twice. <code>CreatorRequestId</code> can be
    /// any unique string, for example, a date/time stamp. </p>
    pub fn creator_request_id(&self) -> std::option::Option<&str> {
        self.creator_request_id.as_deref()
    }
    /// <p>A friendly name that lets you easily find a configuration in the Resolver dashboard in the Route 53 console.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ID of one or more security groups that you want to use to control access to this VPC. The security group that you specify
    /// must include one or more inbound rules (for inbound Resolver endpoints) or outbound rules (for outbound Resolver endpoints).
    /// Inbound and outbound rules must allow TCP and UDP access. For inbound access, open port 53. For outbound access, open the port
    /// that you're using for DNS queries on your network.</p>
    pub fn security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_ids.as_deref()
    }
    /// <p>Specify the applicable value:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>INBOUND</code>: Resolver forwards DNS queries to the DNS service for a VPC from your network</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>OUTBOUND</code>: Resolver forwards DNS queries from the DNS service for a VPC to your network</p>
    /// </li>
    /// </ul>
    pub fn direction(&self) -> std::option::Option<&crate::model::ResolverEndpointDirection> {
        self.direction.as_ref()
    }
    /// <p>The subnets and IP addresses in your VPC that DNS queries originate from (for outbound endpoints) or that you forward
    /// DNS queries to (for inbound endpoints). The subnet ID uniquely identifies a VPC. </p>
    pub fn ip_addresses(&self) -> std::option::Option<&[crate::model::IpAddressRequest]> {
        self.ip_addresses.as_deref()
    }
    /// <p>A list of the tag keys and values that you want to associate with the endpoint.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateResolverEndpointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateResolverEndpointInput");
        formatter.field("creator_request_id", &self.creator_request_id);
        formatter.field("name", &self.name);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.field("direction", &self.direction);
        formatter.field("ip_addresses", &self.ip_addresses);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFirewallRuleGroupInput {
    /// <p>A unique string defined by you to identify the request. This allows you to retry failed
    /// requests without the risk of running the operation twice. This can be any unique string,
    /// for example, a timestamp. </p>
    pub creator_request_id: std::option::Option<std::string::String>,
    /// <p>A name that lets you identify the rule group, to manage and use it.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A list of the tag keys and values that you want to associate with the rule group. </p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateFirewallRuleGroupInput {
    /// <p>A unique string defined by you to identify the request. This allows you to retry failed
    /// requests without the risk of running the operation twice. This can be any unique string,
    /// for example, a timestamp. </p>
    pub fn creator_request_id(&self) -> std::option::Option<&str> {
        self.creator_request_id.as_deref()
    }
    /// <p>A name that lets you identify the rule group, to manage and use it.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A list of the tag keys and values that you want to associate with the rule group. </p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateFirewallRuleGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFirewallRuleGroupInput");
        formatter.field("creator_request_id", &self.creator_request_id);
        formatter.field("name", &self.name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFirewallRuleInput {
    /// <p>A unique string that identifies the request and that allows you to retry failed requests
    /// without the risk of running the operation twice. <code>CreatorRequestId</code> can be
    /// any unique string, for example, a date/time stamp. </p>
    pub creator_request_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the firewall rule group where you want to create the rule. </p>
    pub firewall_rule_group_id: std::option::Option<std::string::String>,
    /// <p>The ID of the domain list that you want to use in the rule. </p>
    pub firewall_domain_list_id: std::option::Option<std::string::String>,
    /// <p>The setting that determines the processing order of the rule in the rule group. DNS Firewall
    /// processes the rules in a rule group by order of priority, starting from the lowest setting.</p>
    /// <p>You must specify a unique priority for each rule in a rule group.
    /// To make it easier to insert rules later, leave space between the numbers, for example, use 100, 200, and so on. You
    /// can change the priority setting for the rules in a rule group at any time.</p>
    pub priority: std::option::Option<i32>,
    /// <p>The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ALLOW</code> - Permit the request to go through.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ALERT</code> - Permit the request and send metrics and logs to Cloud Watch.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>BLOCK</code> - Disallow the request. This option requires additional details in the rule's <code>BlockResponse</code>. </p>
    /// </li>
    /// </ul>
    pub action: std::option::Option<crate::model::Action>,
    /// <p>The way that you want DNS Firewall to block the request, used with the rule action
    /// setting <code>BLOCK</code>. </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NODATA</code> - Respond indicating that the query was successful, but no response is available for it.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NXDOMAIN</code> - Respond indicating that the domain name that's in the query doesn't exist.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>OVERRIDE</code> - Provide a custom override in the response. This option requires custom handling details in the rule's <code>BlockOverride*</code> settings. </p>
    /// </li>
    /// </ul>
    /// <p>This setting is required if the rule action setting is <code>BLOCK</code>.</p>
    pub block_response: std::option::Option<crate::model::BlockResponse>,
    /// <p>The custom DNS record to send back in response to the query. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
    /// <p>This setting is required if the <code>BlockResponse</code> setting is <code>OVERRIDE</code>.</p>
    pub block_override_domain: std::option::Option<std::string::String>,
    /// <p>The DNS record's type. This determines the format of the record value that you provided in <code>BlockOverrideDomain</code>. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
    /// <p>This setting is required if the <code>BlockResponse</code> setting is <code>OVERRIDE</code>.</p>
    pub block_override_dns_type: std::option::Option<crate::model::BlockOverrideDnsType>,
    /// <p>The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
    /// <p>This setting is required if the <code>BlockResponse</code> setting is <code>OVERRIDE</code>.</p>
    pub block_override_ttl: std::option::Option<i32>,
    /// <p>A name that lets you identify the rule in the rule group.</p>
    pub name: std::option::Option<std::string::String>,
}
impl CreateFirewallRuleInput {
    /// <p>A unique string that identifies the request and that allows you to retry failed requests
    /// without the risk of running the operation twice. <code>CreatorRequestId</code> can be
    /// any unique string, for example, a date/time stamp. </p>
    pub fn creator_request_id(&self) -> std::option::Option<&str> {
        self.creator_request_id.as_deref()
    }
    /// <p>The unique identifier of the firewall rule group where you want to create the rule. </p>
    pub fn firewall_rule_group_id(&self) -> std::option::Option<&str> {
        self.firewall_rule_group_id.as_deref()
    }
    /// <p>The ID of the domain list that you want to use in the rule. </p>
    pub fn firewall_domain_list_id(&self) -> std::option::Option<&str> {
        self.firewall_domain_list_id.as_deref()
    }
    /// <p>The setting that determines the processing order of the rule in the rule group. DNS Firewall
    /// processes the rules in a rule group by order of priority, starting from the lowest setting.</p>
    /// <p>You must specify a unique priority for each rule in a rule group.
    /// To make it easier to insert rules later, leave space between the numbers, for example, use 100, 200, and so on. You
    /// can change the priority setting for the rules in a rule group at any time.</p>
    pub fn priority(&self) -> std::option::Option<i32> {
        self.priority
    }
    /// <p>The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ALLOW</code> - Permit the request to go through.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ALERT</code> - Permit the request and send metrics and logs to Cloud Watch.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>BLOCK</code> - Disallow the request. This option requires additional details in the rule's <code>BlockResponse</code>. </p>
    /// </li>
    /// </ul>
    pub fn action(&self) -> std::option::Option<&crate::model::Action> {
        self.action.as_ref()
    }
    /// <p>The way that you want DNS Firewall to block the request, used with the rule action
    /// setting <code>BLOCK</code>. </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NODATA</code> - Respond indicating that the query was successful, but no response is available for it.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NXDOMAIN</code> - Respond indicating that the domain name that's in the query doesn't exist.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>OVERRIDE</code> - Provide a custom override in the response. This option requires custom handling details in the rule's <code>BlockOverride*</code> settings. </p>
    /// </li>
    /// </ul>
    /// <p>This setting is required if the rule action setting is <code>BLOCK</code>.</p>
    pub fn block_response(&self) -> std::option::Option<&crate::model::BlockResponse> {
        self.block_response.as_ref()
    }
    /// <p>The custom DNS record to send back in response to the query. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
    /// <p>This setting is required if the <code>BlockResponse</code> setting is <code>OVERRIDE</code>.</p>
    pub fn block_override_domain(&self) -> std::option::Option<&str> {
        self.block_override_domain.as_deref()
    }
    /// <p>The DNS record's type. This determines the format of the record value that you provided in <code>BlockOverrideDomain</code>. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
    /// <p>This setting is required if the <code>BlockResponse</code> setting is <code>OVERRIDE</code>.</p>
    pub fn block_override_dns_type(
        &self,
    ) -> std::option::Option<&crate::model::BlockOverrideDnsType> {
        self.block_override_dns_type.as_ref()
    }
    /// <p>The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
    /// <p>This setting is required if the <code>BlockResponse</code> setting is <code>OVERRIDE</code>.</p>
    pub fn block_override_ttl(&self) -> std::option::Option<i32> {
        self.block_override_ttl
    }
    /// <p>A name that lets you identify the rule in the rule group.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for CreateFirewallRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFirewallRuleInput");
        formatter.field("creator_request_id", &self.creator_request_id);
        formatter.field("firewall_rule_group_id", &self.firewall_rule_group_id);
        formatter.field("firewall_domain_list_id", &self.firewall_domain_list_id);
        formatter.field("priority", &self.priority);
        formatter.field("action", &self.action);
        formatter.field("block_response", &self.block_response);
        formatter.field("block_override_domain", &self.block_override_domain);
        formatter.field("block_override_dns_type", &self.block_override_dns_type);
        formatter.field("block_override_ttl", &self.block_override_ttl);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFirewallDomainListInput {
    /// <p>A unique string that identifies the request and that allows you to retry failed requests
    /// without the risk of running the operation twice. <code>CreatorRequestId</code> can be
    /// any unique string, for example, a date/time stamp. </p>
    pub creator_request_id: std::option::Option<std::string::String>,
    /// <p>A name that lets you identify the domain list to manage and use it.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A list of the tag keys and values that you want to associate with the domain list. </p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateFirewallDomainListInput {
    /// <p>A unique string that identifies the request and that allows you to retry failed requests
    /// without the risk of running the operation twice. <code>CreatorRequestId</code> can be
    /// any unique string, for example, a date/time stamp. </p>
    pub fn creator_request_id(&self) -> std::option::Option<&str> {
        self.creator_request_id.as_deref()
    }
    /// <p>A name that lets you identify the domain list to manage and use it.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A list of the tag keys and values that you want to associate with the domain list. </p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateFirewallDomainListInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFirewallDomainListInput");
        formatter.field("creator_request_id", &self.creator_request_id);
        formatter.field("name", &self.name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateResolverRuleInput {
    /// <p>The ID of the Resolver rule that you want to associate with the VPC. To list the existing Resolver rules, use
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html">ListResolverRules</a>.</p>
    pub resolver_rule_id: std::option::Option<std::string::String>,
    /// <p>A name for the association that you're creating between a Resolver rule and a VPC.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ID of the VPC that you want to associate the Resolver rule with.</p>
    pub vpc_id: std::option::Option<std::string::String>,
}
impl AssociateResolverRuleInput {
    /// <p>The ID of the Resolver rule that you want to associate with the VPC. To list the existing Resolver rules, use
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html">ListResolverRules</a>.</p>
    pub fn resolver_rule_id(&self) -> std::option::Option<&str> {
        self.resolver_rule_id.as_deref()
    }
    /// <p>A name for the association that you're creating between a Resolver rule and a VPC.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ID of the VPC that you want to associate the Resolver rule with.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
}
impl std::fmt::Debug for AssociateResolverRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateResolverRuleInput");
        formatter.field("resolver_rule_id", &self.resolver_rule_id);
        formatter.field("name", &self.name);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateResolverQueryLogConfigInput {
    /// <p>The ID of the query logging configuration that you want to associate a VPC with.</p>
    pub resolver_query_log_config_id: std::option::Option<std::string::String>,
    /// <p>The ID of an Amazon VPC that you want this query logging configuration to log queries for.</p>
    ///
    /// <note>
    /// <p>The VPCs and the query logging configuration must be in the same Region.</p>
    /// </note>
    pub resource_id: std::option::Option<std::string::String>,
}
impl AssociateResolverQueryLogConfigInput {
    /// <p>The ID of the query logging configuration that you want to associate a VPC with.</p>
    pub fn resolver_query_log_config_id(&self) -> std::option::Option<&str> {
        self.resolver_query_log_config_id.as_deref()
    }
    /// <p>The ID of an Amazon VPC that you want this query logging configuration to log queries for.</p>
    ///
    /// <note>
    /// <p>The VPCs and the query logging configuration must be in the same Region.</p>
    /// </note>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
}
impl std::fmt::Debug for AssociateResolverQueryLogConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateResolverQueryLogConfigInput");
        formatter.field(
            "resolver_query_log_config_id",
            &self.resolver_query_log_config_id,
        );
        formatter.field("resource_id", &self.resource_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateResolverEndpointIpAddressInput {
    /// <p>The ID of the Resolver endpoint that you want to associate IP addresses with.</p>
    pub resolver_endpoint_id: std::option::Option<std::string::String>,
    /// <p>Either the IPv4 address that you want to add to a Resolver endpoint or a subnet ID. If you specify a subnet ID,
    /// Resolver chooses an IP address for you from the available IPs in the specified subnet.</p>
    pub ip_address: std::option::Option<crate::model::IpAddressUpdate>,
}
impl AssociateResolverEndpointIpAddressInput {
    /// <p>The ID of the Resolver endpoint that you want to associate IP addresses with.</p>
    pub fn resolver_endpoint_id(&self) -> std::option::Option<&str> {
        self.resolver_endpoint_id.as_deref()
    }
    /// <p>Either the IPv4 address that you want to add to a Resolver endpoint or a subnet ID. If you specify a subnet ID,
    /// Resolver chooses an IP address for you from the available IPs in the specified subnet.</p>
    pub fn ip_address(&self) -> std::option::Option<&crate::model::IpAddressUpdate> {
        self.ip_address.as_ref()
    }
}
impl std::fmt::Debug for AssociateResolverEndpointIpAddressInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateResolverEndpointIpAddressInput");
        formatter.field("resolver_endpoint_id", &self.resolver_endpoint_id);
        formatter.field("ip_address", &self.ip_address);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateFirewallRuleGroupInput {
    /// <p>A unique string that identifies the request and that allows failed requests to be
    /// retried without the risk of running the operation twice. <code>CreatorRequestId</code>
    /// can be any unique string, for example, a date/time stamp. </p>
    pub creator_request_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the firewall rule group. </p>
    pub firewall_rule_group_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the VPC that you want to associate with the rule group. </p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>The setting that determines the processing order of the rule group among the rule
    /// groups that you associate with the specified VPC. DNS Firewall filters VPC traffic
    /// starting from the rule group with the lowest numeric priority setting. </p>
    /// <p>You must specify a unique priority for each rule group that you associate with a single VPC.
    /// To make it easier to insert rule groups later, leave space between the numbers, for example, use 101, 200, and so on. You
    /// can change the priority setting for a rule group association after you create it.</p>
    /// <p>The allowed values for <code>Priority</code> are between 100 and 9900.</p>
    pub priority: std::option::Option<i32>,
    /// <p>A name that lets you identify the association, to manage and use it.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>If enabled, this setting disallows modification or removal of the association, to help prevent against accidentally altering DNS firewall protections.
    /// When you create the association, the default setting is <code>DISABLED</code>. </p>
    pub mutation_protection: std::option::Option<crate::model::MutationProtectionStatus>,
    /// <p>A list of the tag keys and values that you want to associate with the rule group association. </p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl AssociateFirewallRuleGroupInput {
    /// <p>A unique string that identifies the request and that allows failed requests to be
    /// retried without the risk of running the operation twice. <code>CreatorRequestId</code>
    /// can be any unique string, for example, a date/time stamp. </p>
    pub fn creator_request_id(&self) -> std::option::Option<&str> {
        self.creator_request_id.as_deref()
    }
    /// <p>The unique identifier of the firewall rule group. </p>
    pub fn firewall_rule_group_id(&self) -> std::option::Option<&str> {
        self.firewall_rule_group_id.as_deref()
    }
    /// <p>The unique identifier of the VPC that you want to associate with the rule group. </p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>The setting that determines the processing order of the rule group among the rule
    /// groups that you associate with the specified VPC. DNS Firewall filters VPC traffic
    /// starting from the rule group with the lowest numeric priority setting. </p>
    /// <p>You must specify a unique priority for each rule group that you associate with a single VPC.
    /// To make it easier to insert rule groups later, leave space between the numbers, for example, use 101, 200, and so on. You
    /// can change the priority setting for a rule group association after you create it.</p>
    /// <p>The allowed values for <code>Priority</code> are between 100 and 9900.</p>
    pub fn priority(&self) -> std::option::Option<i32> {
        self.priority
    }
    /// <p>A name that lets you identify the association, to manage and use it.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>If enabled, this setting disallows modification or removal of the association, to help prevent against accidentally altering DNS firewall protections.
    /// When you create the association, the default setting is <code>DISABLED</code>. </p>
    pub fn mutation_protection(
        &self,
    ) -> std::option::Option<&crate::model::MutationProtectionStatus> {
        self.mutation_protection.as_ref()
    }
    /// <p>A list of the tag keys and values that you want to associate with the rule group association. </p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for AssociateFirewallRuleGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateFirewallRuleGroupInput");
        formatter.field("creator_request_id", &self.creator_request_id);
        formatter.field("firewall_rule_group_id", &self.firewall_rule_group_id);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("priority", &self.priority);
        formatter.field("name", &self.name);
        formatter.field("mutation_protection", &self.mutation_protection);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
