// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `Route53Resolver`.
///
/// This client allows ergonomic access to a `Route53Resolver`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AssociateFirewallRuleGroup` operation.
    ///
    /// See [`AssociateFirewallRuleGroup`](crate::client::fluent_builders::AssociateFirewallRuleGroup) for more information about the
    /// operation and its arguments.
    pub fn associate_firewall_rule_group(
        &self,
    ) -> fluent_builders::AssociateFirewallRuleGroup<C, M, R> {
        fluent_builders::AssociateFirewallRuleGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateResolverEndpointIpAddress` operation.
    ///
    /// See [`AssociateResolverEndpointIpAddress`](crate::client::fluent_builders::AssociateResolverEndpointIpAddress) for more information about the
    /// operation and its arguments.
    pub fn associate_resolver_endpoint_ip_address(
        &self,
    ) -> fluent_builders::AssociateResolverEndpointIpAddress<C, M, R> {
        fluent_builders::AssociateResolverEndpointIpAddress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateResolverQueryLogConfig` operation.
    ///
    /// See [`AssociateResolverQueryLogConfig`](crate::client::fluent_builders::AssociateResolverQueryLogConfig) for more information about the
    /// operation and its arguments.
    pub fn associate_resolver_query_log_config(
        &self,
    ) -> fluent_builders::AssociateResolverQueryLogConfig<C, M, R> {
        fluent_builders::AssociateResolverQueryLogConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateResolverRule` operation.
    ///
    /// See [`AssociateResolverRule`](crate::client::fluent_builders::AssociateResolverRule) for more information about the
    /// operation and its arguments.
    pub fn associate_resolver_rule(&self) -> fluent_builders::AssociateResolverRule<C, M, R> {
        fluent_builders::AssociateResolverRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateFirewallDomainList` operation.
    ///
    /// See [`CreateFirewallDomainList`](crate::client::fluent_builders::CreateFirewallDomainList) for more information about the
    /// operation and its arguments.
    pub fn create_firewall_domain_list(
        &self,
    ) -> fluent_builders::CreateFirewallDomainList<C, M, R> {
        fluent_builders::CreateFirewallDomainList::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateFirewallRule` operation.
    ///
    /// See [`CreateFirewallRule`](crate::client::fluent_builders::CreateFirewallRule) for more information about the
    /// operation and its arguments.
    pub fn create_firewall_rule(&self) -> fluent_builders::CreateFirewallRule<C, M, R> {
        fluent_builders::CreateFirewallRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateFirewallRuleGroup` operation.
    ///
    /// See [`CreateFirewallRuleGroup`](crate::client::fluent_builders::CreateFirewallRuleGroup) for more information about the
    /// operation and its arguments.
    pub fn create_firewall_rule_group(&self) -> fluent_builders::CreateFirewallRuleGroup<C, M, R> {
        fluent_builders::CreateFirewallRuleGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateResolverEndpoint` operation.
    ///
    /// See [`CreateResolverEndpoint`](crate::client::fluent_builders::CreateResolverEndpoint) for more information about the
    /// operation and its arguments.
    pub fn create_resolver_endpoint(&self) -> fluent_builders::CreateResolverEndpoint<C, M, R> {
        fluent_builders::CreateResolverEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateResolverQueryLogConfig` operation.
    ///
    /// See [`CreateResolverQueryLogConfig`](crate::client::fluent_builders::CreateResolverQueryLogConfig) for more information about the
    /// operation and its arguments.
    pub fn create_resolver_query_log_config(
        &self,
    ) -> fluent_builders::CreateResolverQueryLogConfig<C, M, R> {
        fluent_builders::CreateResolverQueryLogConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateResolverRule` operation.
    ///
    /// See [`CreateResolverRule`](crate::client::fluent_builders::CreateResolverRule) for more information about the
    /// operation and its arguments.
    pub fn create_resolver_rule(&self) -> fluent_builders::CreateResolverRule<C, M, R> {
        fluent_builders::CreateResolverRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFirewallDomainList` operation.
    ///
    /// See [`DeleteFirewallDomainList`](crate::client::fluent_builders::DeleteFirewallDomainList) for more information about the
    /// operation and its arguments.
    pub fn delete_firewall_domain_list(
        &self,
    ) -> fluent_builders::DeleteFirewallDomainList<C, M, R> {
        fluent_builders::DeleteFirewallDomainList::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFirewallRule` operation.
    ///
    /// See [`DeleteFirewallRule`](crate::client::fluent_builders::DeleteFirewallRule) for more information about the
    /// operation and its arguments.
    pub fn delete_firewall_rule(&self) -> fluent_builders::DeleteFirewallRule<C, M, R> {
        fluent_builders::DeleteFirewallRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFirewallRuleGroup` operation.
    ///
    /// See [`DeleteFirewallRuleGroup`](crate::client::fluent_builders::DeleteFirewallRuleGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_firewall_rule_group(&self) -> fluent_builders::DeleteFirewallRuleGroup<C, M, R> {
        fluent_builders::DeleteFirewallRuleGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteResolverEndpoint` operation.
    ///
    /// See [`DeleteResolverEndpoint`](crate::client::fluent_builders::DeleteResolverEndpoint) for more information about the
    /// operation and its arguments.
    pub fn delete_resolver_endpoint(&self) -> fluent_builders::DeleteResolverEndpoint<C, M, R> {
        fluent_builders::DeleteResolverEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteResolverQueryLogConfig` operation.
    ///
    /// See [`DeleteResolverQueryLogConfig`](crate::client::fluent_builders::DeleteResolverQueryLogConfig) for more information about the
    /// operation and its arguments.
    pub fn delete_resolver_query_log_config(
        &self,
    ) -> fluent_builders::DeleteResolverQueryLogConfig<C, M, R> {
        fluent_builders::DeleteResolverQueryLogConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteResolverRule` operation.
    ///
    /// See [`DeleteResolverRule`](crate::client::fluent_builders::DeleteResolverRule) for more information about the
    /// operation and its arguments.
    pub fn delete_resolver_rule(&self) -> fluent_builders::DeleteResolverRule<C, M, R> {
        fluent_builders::DeleteResolverRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateFirewallRuleGroup` operation.
    ///
    /// See [`DisassociateFirewallRuleGroup`](crate::client::fluent_builders::DisassociateFirewallRuleGroup) for more information about the
    /// operation and its arguments.
    pub fn disassociate_firewall_rule_group(
        &self,
    ) -> fluent_builders::DisassociateFirewallRuleGroup<C, M, R> {
        fluent_builders::DisassociateFirewallRuleGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateResolverEndpointIpAddress` operation.
    ///
    /// See [`DisassociateResolverEndpointIpAddress`](crate::client::fluent_builders::DisassociateResolverEndpointIpAddress) for more information about the
    /// operation and its arguments.
    pub fn disassociate_resolver_endpoint_ip_address(
        &self,
    ) -> fluent_builders::DisassociateResolverEndpointIpAddress<C, M, R> {
        fluent_builders::DisassociateResolverEndpointIpAddress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateResolverQueryLogConfig` operation.
    ///
    /// See [`DisassociateResolverQueryLogConfig`](crate::client::fluent_builders::DisassociateResolverQueryLogConfig) for more information about the
    /// operation and its arguments.
    pub fn disassociate_resolver_query_log_config(
        &self,
    ) -> fluent_builders::DisassociateResolverQueryLogConfig<C, M, R> {
        fluent_builders::DisassociateResolverQueryLogConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateResolverRule` operation.
    ///
    /// See [`DisassociateResolverRule`](crate::client::fluent_builders::DisassociateResolverRule) for more information about the
    /// operation and its arguments.
    pub fn disassociate_resolver_rule(&self) -> fluent_builders::DisassociateResolverRule<C, M, R> {
        fluent_builders::DisassociateResolverRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetFirewallConfig` operation.
    ///
    /// See [`GetFirewallConfig`](crate::client::fluent_builders::GetFirewallConfig) for more information about the
    /// operation and its arguments.
    pub fn get_firewall_config(&self) -> fluent_builders::GetFirewallConfig<C, M, R> {
        fluent_builders::GetFirewallConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetFirewallDomainList` operation.
    ///
    /// See [`GetFirewallDomainList`](crate::client::fluent_builders::GetFirewallDomainList) for more information about the
    /// operation and its arguments.
    pub fn get_firewall_domain_list(&self) -> fluent_builders::GetFirewallDomainList<C, M, R> {
        fluent_builders::GetFirewallDomainList::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetFirewallRuleGroup` operation.
    ///
    /// See [`GetFirewallRuleGroup`](crate::client::fluent_builders::GetFirewallRuleGroup) for more information about the
    /// operation and its arguments.
    pub fn get_firewall_rule_group(&self) -> fluent_builders::GetFirewallRuleGroup<C, M, R> {
        fluent_builders::GetFirewallRuleGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetFirewallRuleGroupAssociation` operation.
    ///
    /// See [`GetFirewallRuleGroupAssociation`](crate::client::fluent_builders::GetFirewallRuleGroupAssociation) for more information about the
    /// operation and its arguments.
    pub fn get_firewall_rule_group_association(
        &self,
    ) -> fluent_builders::GetFirewallRuleGroupAssociation<C, M, R> {
        fluent_builders::GetFirewallRuleGroupAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetFirewallRuleGroupPolicy` operation.
    ///
    /// See [`GetFirewallRuleGroupPolicy`](crate::client::fluent_builders::GetFirewallRuleGroupPolicy) for more information about the
    /// operation and its arguments.
    pub fn get_firewall_rule_group_policy(
        &self,
    ) -> fluent_builders::GetFirewallRuleGroupPolicy<C, M, R> {
        fluent_builders::GetFirewallRuleGroupPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetResolverConfig` operation.
    ///
    /// See [`GetResolverConfig`](crate::client::fluent_builders::GetResolverConfig) for more information about the
    /// operation and its arguments.
    pub fn get_resolver_config(&self) -> fluent_builders::GetResolverConfig<C, M, R> {
        fluent_builders::GetResolverConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetResolverDnssecConfig` operation.
    ///
    /// See [`GetResolverDnssecConfig`](crate::client::fluent_builders::GetResolverDnssecConfig) for more information about the
    /// operation and its arguments.
    pub fn get_resolver_dnssec_config(&self) -> fluent_builders::GetResolverDnssecConfig<C, M, R> {
        fluent_builders::GetResolverDnssecConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetResolverEndpoint` operation.
    ///
    /// See [`GetResolverEndpoint`](crate::client::fluent_builders::GetResolverEndpoint) for more information about the
    /// operation and its arguments.
    pub fn get_resolver_endpoint(&self) -> fluent_builders::GetResolverEndpoint<C, M, R> {
        fluent_builders::GetResolverEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetResolverQueryLogConfig` operation.
    ///
    /// See [`GetResolverQueryLogConfig`](crate::client::fluent_builders::GetResolverQueryLogConfig) for more information about the
    /// operation and its arguments.
    pub fn get_resolver_query_log_config(
        &self,
    ) -> fluent_builders::GetResolverQueryLogConfig<C, M, R> {
        fluent_builders::GetResolverQueryLogConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetResolverQueryLogConfigAssociation` operation.
    ///
    /// See [`GetResolverQueryLogConfigAssociation`](crate::client::fluent_builders::GetResolverQueryLogConfigAssociation) for more information about the
    /// operation and its arguments.
    pub fn get_resolver_query_log_config_association(
        &self,
    ) -> fluent_builders::GetResolverQueryLogConfigAssociation<C, M, R> {
        fluent_builders::GetResolverQueryLogConfigAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetResolverQueryLogConfigPolicy` operation.
    ///
    /// See [`GetResolverQueryLogConfigPolicy`](crate::client::fluent_builders::GetResolverQueryLogConfigPolicy) for more information about the
    /// operation and its arguments.
    pub fn get_resolver_query_log_config_policy(
        &self,
    ) -> fluent_builders::GetResolverQueryLogConfigPolicy<C, M, R> {
        fluent_builders::GetResolverQueryLogConfigPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetResolverRule` operation.
    ///
    /// See [`GetResolverRule`](crate::client::fluent_builders::GetResolverRule) for more information about the
    /// operation and its arguments.
    pub fn get_resolver_rule(&self) -> fluent_builders::GetResolverRule<C, M, R> {
        fluent_builders::GetResolverRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetResolverRuleAssociation` operation.
    ///
    /// See [`GetResolverRuleAssociation`](crate::client::fluent_builders::GetResolverRuleAssociation) for more information about the
    /// operation and its arguments.
    pub fn get_resolver_rule_association(
        &self,
    ) -> fluent_builders::GetResolverRuleAssociation<C, M, R> {
        fluent_builders::GetResolverRuleAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetResolverRulePolicy` operation.
    ///
    /// See [`GetResolverRulePolicy`](crate::client::fluent_builders::GetResolverRulePolicy) for more information about the
    /// operation and its arguments.
    pub fn get_resolver_rule_policy(&self) -> fluent_builders::GetResolverRulePolicy<C, M, R> {
        fluent_builders::GetResolverRulePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ImportFirewallDomains` operation.
    ///
    /// See [`ImportFirewallDomains`](crate::client::fluent_builders::ImportFirewallDomains) for more information about the
    /// operation and its arguments.
    pub fn import_firewall_domains(&self) -> fluent_builders::ImportFirewallDomains<C, M, R> {
        fluent_builders::ImportFirewallDomains::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFirewallConfigs` operation.
    ///
    /// See [`ListFirewallConfigs`](crate::client::fluent_builders::ListFirewallConfigs) for more information about the
    /// operation and its arguments.
    pub fn list_firewall_configs(&self) -> fluent_builders::ListFirewallConfigs<C, M, R> {
        fluent_builders::ListFirewallConfigs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFirewallDomainLists` operation.
    ///
    /// See [`ListFirewallDomainLists`](crate::client::fluent_builders::ListFirewallDomainLists) for more information about the
    /// operation and its arguments.
    pub fn list_firewall_domain_lists(&self) -> fluent_builders::ListFirewallDomainLists<C, M, R> {
        fluent_builders::ListFirewallDomainLists::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFirewallDomains` operation.
    ///
    /// See [`ListFirewallDomains`](crate::client::fluent_builders::ListFirewallDomains) for more information about the
    /// operation and its arguments.
    pub fn list_firewall_domains(&self) -> fluent_builders::ListFirewallDomains<C, M, R> {
        fluent_builders::ListFirewallDomains::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFirewallRuleGroupAssociations` operation.
    ///
    /// See [`ListFirewallRuleGroupAssociations`](crate::client::fluent_builders::ListFirewallRuleGroupAssociations) for more information about the
    /// operation and its arguments.
    pub fn list_firewall_rule_group_associations(
        &self,
    ) -> fluent_builders::ListFirewallRuleGroupAssociations<C, M, R> {
        fluent_builders::ListFirewallRuleGroupAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFirewallRuleGroups` operation.
    ///
    /// See [`ListFirewallRuleGroups`](crate::client::fluent_builders::ListFirewallRuleGroups) for more information about the
    /// operation and its arguments.
    pub fn list_firewall_rule_groups(&self) -> fluent_builders::ListFirewallRuleGroups<C, M, R> {
        fluent_builders::ListFirewallRuleGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFirewallRules` operation.
    ///
    /// See [`ListFirewallRules`](crate::client::fluent_builders::ListFirewallRules) for more information about the
    /// operation and its arguments.
    pub fn list_firewall_rules(&self) -> fluent_builders::ListFirewallRules<C, M, R> {
        fluent_builders::ListFirewallRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListResolverConfigs` operation.
    ///
    /// See [`ListResolverConfigs`](crate::client::fluent_builders::ListResolverConfigs) for more information about the
    /// operation and its arguments.
    pub fn list_resolver_configs(&self) -> fluent_builders::ListResolverConfigs<C, M, R> {
        fluent_builders::ListResolverConfigs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListResolverDnssecConfigs` operation.
    ///
    /// See [`ListResolverDnssecConfigs`](crate::client::fluent_builders::ListResolverDnssecConfigs) for more information about the
    /// operation and its arguments.
    pub fn list_resolver_dnssec_configs(
        &self,
    ) -> fluent_builders::ListResolverDnssecConfigs<C, M, R> {
        fluent_builders::ListResolverDnssecConfigs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListResolverEndpointIpAddresses` operation.
    ///
    /// See [`ListResolverEndpointIpAddresses`](crate::client::fluent_builders::ListResolverEndpointIpAddresses) for more information about the
    /// operation and its arguments.
    pub fn list_resolver_endpoint_ip_addresses(
        &self,
    ) -> fluent_builders::ListResolverEndpointIpAddresses<C, M, R> {
        fluent_builders::ListResolverEndpointIpAddresses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListResolverEndpoints` operation.
    ///
    /// See [`ListResolverEndpoints`](crate::client::fluent_builders::ListResolverEndpoints) for more information about the
    /// operation and its arguments.
    pub fn list_resolver_endpoints(&self) -> fluent_builders::ListResolverEndpoints<C, M, R> {
        fluent_builders::ListResolverEndpoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListResolverQueryLogConfigAssociations` operation.
    ///
    /// See [`ListResolverQueryLogConfigAssociations`](crate::client::fluent_builders::ListResolverQueryLogConfigAssociations) for more information about the
    /// operation and its arguments.
    pub fn list_resolver_query_log_config_associations(
        &self,
    ) -> fluent_builders::ListResolverQueryLogConfigAssociations<C, M, R> {
        fluent_builders::ListResolverQueryLogConfigAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListResolverQueryLogConfigs` operation.
    ///
    /// See [`ListResolverQueryLogConfigs`](crate::client::fluent_builders::ListResolverQueryLogConfigs) for more information about the
    /// operation and its arguments.
    pub fn list_resolver_query_log_configs(
        &self,
    ) -> fluent_builders::ListResolverQueryLogConfigs<C, M, R> {
        fluent_builders::ListResolverQueryLogConfigs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListResolverRuleAssociations` operation.
    ///
    /// See [`ListResolverRuleAssociations`](crate::client::fluent_builders::ListResolverRuleAssociations) for more information about the
    /// operation and its arguments.
    pub fn list_resolver_rule_associations(
        &self,
    ) -> fluent_builders::ListResolverRuleAssociations<C, M, R> {
        fluent_builders::ListResolverRuleAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListResolverRules` operation.
    ///
    /// See [`ListResolverRules`](crate::client::fluent_builders::ListResolverRules) for more information about the
    /// operation and its arguments.
    pub fn list_resolver_rules(&self) -> fluent_builders::ListResolverRules<C, M, R> {
        fluent_builders::ListResolverRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutFirewallRuleGroupPolicy` operation.
    ///
    /// See [`PutFirewallRuleGroupPolicy`](crate::client::fluent_builders::PutFirewallRuleGroupPolicy) for more information about the
    /// operation and its arguments.
    pub fn put_firewall_rule_group_policy(
        &self,
    ) -> fluent_builders::PutFirewallRuleGroupPolicy<C, M, R> {
        fluent_builders::PutFirewallRuleGroupPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutResolverQueryLogConfigPolicy` operation.
    ///
    /// See [`PutResolverQueryLogConfigPolicy`](crate::client::fluent_builders::PutResolverQueryLogConfigPolicy) for more information about the
    /// operation and its arguments.
    pub fn put_resolver_query_log_config_policy(
        &self,
    ) -> fluent_builders::PutResolverQueryLogConfigPolicy<C, M, R> {
        fluent_builders::PutResolverQueryLogConfigPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutResolverRulePolicy` operation.
    ///
    /// See [`PutResolverRulePolicy`](crate::client::fluent_builders::PutResolverRulePolicy) for more information about the
    /// operation and its arguments.
    pub fn put_resolver_rule_policy(&self) -> fluent_builders::PutResolverRulePolicy<C, M, R> {
        fluent_builders::PutResolverRulePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateFirewallConfig` operation.
    ///
    /// See [`UpdateFirewallConfig`](crate::client::fluent_builders::UpdateFirewallConfig) for more information about the
    /// operation and its arguments.
    pub fn update_firewall_config(&self) -> fluent_builders::UpdateFirewallConfig<C, M, R> {
        fluent_builders::UpdateFirewallConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateFirewallDomains` operation.
    ///
    /// See [`UpdateFirewallDomains`](crate::client::fluent_builders::UpdateFirewallDomains) for more information about the
    /// operation and its arguments.
    pub fn update_firewall_domains(&self) -> fluent_builders::UpdateFirewallDomains<C, M, R> {
        fluent_builders::UpdateFirewallDomains::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateFirewallRule` operation.
    ///
    /// See [`UpdateFirewallRule`](crate::client::fluent_builders::UpdateFirewallRule) for more information about the
    /// operation and its arguments.
    pub fn update_firewall_rule(&self) -> fluent_builders::UpdateFirewallRule<C, M, R> {
        fluent_builders::UpdateFirewallRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateFirewallRuleGroupAssociation` operation.
    ///
    /// See [`UpdateFirewallRuleGroupAssociation`](crate::client::fluent_builders::UpdateFirewallRuleGroupAssociation) for more information about the
    /// operation and its arguments.
    pub fn update_firewall_rule_group_association(
        &self,
    ) -> fluent_builders::UpdateFirewallRuleGroupAssociation<C, M, R> {
        fluent_builders::UpdateFirewallRuleGroupAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateResolverConfig` operation.
    ///
    /// See [`UpdateResolverConfig`](crate::client::fluent_builders::UpdateResolverConfig) for more information about the
    /// operation and its arguments.
    pub fn update_resolver_config(&self) -> fluent_builders::UpdateResolverConfig<C, M, R> {
        fluent_builders::UpdateResolverConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateResolverDnssecConfig` operation.
    ///
    /// See [`UpdateResolverDnssecConfig`](crate::client::fluent_builders::UpdateResolverDnssecConfig) for more information about the
    /// operation and its arguments.
    pub fn update_resolver_dnssec_config(
        &self,
    ) -> fluent_builders::UpdateResolverDnssecConfig<C, M, R> {
        fluent_builders::UpdateResolverDnssecConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateResolverEndpoint` operation.
    ///
    /// See [`UpdateResolverEndpoint`](crate::client::fluent_builders::UpdateResolverEndpoint) for more information about the
    /// operation and its arguments.
    pub fn update_resolver_endpoint(&self) -> fluent_builders::UpdateResolverEndpoint<C, M, R> {
        fluent_builders::UpdateResolverEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateResolverRule` operation.
    ///
    /// See [`UpdateResolverRule`](crate::client::fluent_builders::UpdateResolverRule) for more information about the
    /// operation and its arguments.
    pub fn update_resolver_rule(&self) -> fluent_builders::UpdateResolverRule<C, M, R> {
        fluent_builders::UpdateResolverRule::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateFirewallRuleGroup`.
    ///
    /// <p>Associates a <a>FirewallRuleGroup</a> with a VPC, to provide DNS filtering for the VPC. </p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateFirewallRuleGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_firewall_rule_group_input::Builder,
    }
    impl<C, M, R> AssociateFirewallRuleGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateFirewallRuleGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateFirewallRuleGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateFirewallRuleGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateFirewallRuleGroupInputOperationOutputAlias,
                crate::output::AssociateFirewallRuleGroupOutput,
                crate::error::AssociateFirewallRuleGroupError,
                crate::input::AssociateFirewallRuleGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique string that identifies the request and that allows failed requests to be
        /// retried without the risk of running the operation twice. <code>CreatorRequestId</code>
        /// can be any unique string, for example, a date/time stamp. </p>
        pub fn creator_request_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.creator_request_id(inp);
            self
        }
        /// <p>A unique string that identifies the request and that allows failed requests to be
        /// retried without the risk of running the operation twice. <code>CreatorRequestId</code>
        /// can be any unique string, for example, a date/time stamp. </p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_creator_request_id(input);
            self
        }
        /// <p>The unique identifier of the firewall rule group. </p>
        pub fn firewall_rule_group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_rule_group_id(inp);
            self
        }
        /// <p>The unique identifier of the firewall rule group. </p>
        pub fn set_firewall_rule_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_rule_group_id(input);
            self
        }
        /// <p>The unique identifier of the VPC that you want to associate with the rule group. </p>
        pub fn vpc_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_id(inp);
            self
        }
        /// <p>The unique identifier of the VPC that you want to associate with the rule group. </p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_id(input);
            self
        }
        /// <p>The setting that determines the processing order of the rule group among the rule
        /// groups that you associate with the specified VPC. DNS Firewall filters VPC traffic
        /// starting from the rule group with the lowest numeric priority setting. </p>
        /// <p>You must specify a unique priority for each rule group that you associate with a single VPC.
        /// To make it easier to insert rule groups later, leave space between the numbers, for example, use 101, 200, and so on. You
        /// can change the priority setting for a rule group association after you create it.</p>
        /// <p>The allowed values for <code>Priority</code> are between 100 and 9900.</p>
        pub fn priority(mut self, inp: i32) -> Self {
            self.inner = self.inner.priority(inp);
            self
        }
        /// <p>The setting that determines the processing order of the rule group among the rule
        /// groups that you associate with the specified VPC. DNS Firewall filters VPC traffic
        /// starting from the rule group with the lowest numeric priority setting. </p>
        /// <p>You must specify a unique priority for each rule group that you associate with a single VPC.
        /// To make it easier to insert rule groups later, leave space between the numbers, for example, use 101, 200, and so on. You
        /// can change the priority setting for a rule group association after you create it.</p>
        /// <p>The allowed values for <code>Priority</code> are between 100 and 9900.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_priority(input);
            self
        }
        /// <p>A name that lets you identify the association, to manage and use it.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A name that lets you identify the association, to manage and use it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>If enabled, this setting disallows modification or removal of the association, to help prevent against accidentally altering DNS firewall protections.
        /// When you create the association, the default setting is <code>DISABLED</code>. </p>
        pub fn mutation_protection(mut self, inp: crate::model::MutationProtectionStatus) -> Self {
            self.inner = self.inner.mutation_protection(inp);
            self
        }
        /// <p>If enabled, this setting disallows modification or removal of the association, to help prevent against accidentally altering DNS firewall protections.
        /// When you create the association, the default setting is <code>DISABLED</code>. </p>
        pub fn set_mutation_protection(
            mut self,
            input: std::option::Option<crate::model::MutationProtectionStatus>,
        ) -> Self {
            self.inner = self.inner.set_mutation_protection(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of the tag keys and values that you want to associate with the rule group association. </p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of the tag keys and values that you want to associate with the rule group association. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateResolverEndpointIpAddress`.
    ///
    /// <p>Adds IP addresses to an inbound or an outbound Resolver endpoint. If you want to add more than one IP address,
    /// submit one <code>AssociateResolverEndpointIpAddress</code> request for each IP address.</p>
    /// <p>To remove an IP address from an endpoint, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverEndpointIpAddress.html">DisassociateResolverEndpointIpAddress</a>.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateResolverEndpointIpAddress<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_resolver_endpoint_ip_address_input::Builder,
    }
    impl<C, M, R> AssociateResolverEndpointIpAddress<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateResolverEndpointIpAddress`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateResolverEndpointIpAddressOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AssociateResolverEndpointIpAddressError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateResolverEndpointIpAddressInputOperationOutputAlias,
                crate::output::AssociateResolverEndpointIpAddressOutput,
                crate::error::AssociateResolverEndpointIpAddressError,
                crate::input::AssociateResolverEndpointIpAddressInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Resolver endpoint that you want to associate IP addresses with.</p>
        pub fn resolver_endpoint_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolver_endpoint_id(inp);
            self
        }
        /// <p>The ID of the Resolver endpoint that you want to associate IP addresses with.</p>
        pub fn set_resolver_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolver_endpoint_id(input);
            self
        }
        /// <p>Either the IPv4 address that you want to add to a Resolver endpoint or a subnet ID. If you specify a subnet ID,
        /// Resolver chooses an IP address for you from the available IPs in the specified subnet.</p>
        pub fn ip_address(mut self, inp: crate::model::IpAddressUpdate) -> Self {
            self.inner = self.inner.ip_address(inp);
            self
        }
        /// <p>Either the IPv4 address that you want to add to a Resolver endpoint or a subnet ID. If you specify a subnet ID,
        /// Resolver chooses an IP address for you from the available IPs in the specified subnet.</p>
        pub fn set_ip_address(
            mut self,
            input: std::option::Option<crate::model::IpAddressUpdate>,
        ) -> Self {
            self.inner = self.inner.set_ip_address(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateResolverQueryLogConfig`.
    ///
    /// <p>Associates an Amazon VPC with a specified query logging configuration. Route 53 Resolver logs DNS queries that originate in all of the Amazon VPCs
    /// that are associated with a specified query logging configuration. To associate more than one VPC with a configuration, submit one <code>AssociateResolverQueryLogConfig</code>
    /// request for each VPC.</p>
    ///
    /// <note>
    /// <p>The VPCs that you associate with a query logging configuration must be in the same Region as the configuration.</p>
    /// </note>
    ///
    /// <p>To remove a VPC from a query logging configuration, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverQueryLogConfig.html">DisassociateResolverQueryLogConfig</a>.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateResolverQueryLogConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_resolver_query_log_config_input::Builder,
    }
    impl<C, M, R> AssociateResolverQueryLogConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateResolverQueryLogConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateResolverQueryLogConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateResolverQueryLogConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateResolverQueryLogConfigInputOperationOutputAlias,
                crate::output::AssociateResolverQueryLogConfigOutput,
                crate::error::AssociateResolverQueryLogConfigError,
                crate::input::AssociateResolverQueryLogConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the query logging configuration that you want to associate a VPC with.</p>
        pub fn resolver_query_log_config_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolver_query_log_config_id(inp);
            self
        }
        /// <p>The ID of the query logging configuration that you want to associate a VPC with.</p>
        pub fn set_resolver_query_log_config_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolver_query_log_config_id(input);
            self
        }
        /// <p>The ID of an Amazon VPC that you want this query logging configuration to log queries for.</p>
        ///
        /// <note>
        /// <p>The VPCs and the query logging configuration must be in the same Region.</p>
        /// </note>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>The ID of an Amazon VPC that you want this query logging configuration to log queries for.</p>
        ///
        /// <note>
        /// <p>The VPCs and the query logging configuration must be in the same Region.</p>
        /// </note>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateResolverRule`.
    ///
    /// <p>Associates a Resolver rule with a VPC. When you associate a rule with a VPC, Resolver forwards all DNS queries
    /// for the domain name that is specified in the rule and that originate in the VPC. The queries are forwarded to the
    /// IP addresses for the DNS resolvers that are specified in the rule. For more information about rules, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverRule.html">CreateResolverRule</a>. </p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateResolverRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_resolver_rule_input::Builder,
    }
    impl<C, M, R> AssociateResolverRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateResolverRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateResolverRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateResolverRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateResolverRuleInputOperationOutputAlias,
                crate::output::AssociateResolverRuleOutput,
                crate::error::AssociateResolverRuleError,
                crate::input::AssociateResolverRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Resolver rule that you want to associate with the VPC. To list the existing Resolver rules, use
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html">ListResolverRules</a>.</p>
        pub fn resolver_rule_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolver_rule_id(inp);
            self
        }
        /// <p>The ID of the Resolver rule that you want to associate with the VPC. To list the existing Resolver rules, use
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html">ListResolverRules</a>.</p>
        pub fn set_resolver_rule_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolver_rule_id(input);
            self
        }
        /// <p>A name for the association that you're creating between a Resolver rule and a VPC.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A name for the association that you're creating between a Resolver rule and a VPC.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The ID of the VPC that you want to associate the Resolver rule with.</p>
        pub fn vpc_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_id(inp);
            self
        }
        /// <p>The ID of the VPC that you want to associate the Resolver rule with.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFirewallDomainList`.
    ///
    /// <p>Creates an empty firewall domain list for use in DNS Firewall rules. You can populate the domains for the new list with a file, using <a>ImportFirewallDomains</a>, or with domain strings, using <a>UpdateFirewallDomains</a>. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateFirewallDomainList<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_firewall_domain_list_input::Builder,
    }
    impl<C, M, R> CreateFirewallDomainList<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFirewallDomainList`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFirewallDomainListOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFirewallDomainListError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFirewallDomainListInputOperationOutputAlias,
                crate::output::CreateFirewallDomainListOutput,
                crate::error::CreateFirewallDomainListError,
                crate::input::CreateFirewallDomainListInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique string that identifies the request and that allows you to retry failed requests
        /// without the risk of running the operation twice. <code>CreatorRequestId</code> can be
        /// any unique string, for example, a date/time stamp. </p>
        pub fn creator_request_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.creator_request_id(inp);
            self
        }
        /// <p>A unique string that identifies the request and that allows you to retry failed requests
        /// without the risk of running the operation twice. <code>CreatorRequestId</code> can be
        /// any unique string, for example, a date/time stamp. </p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_creator_request_id(input);
            self
        }
        /// <p>A name that lets you identify the domain list to manage and use it.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A name that lets you identify the domain list to manage and use it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of the tag keys and values that you want to associate with the domain list. </p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of the tag keys and values that you want to associate with the domain list. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFirewallRule`.
    ///
    /// <p>Creates a single DNS Firewall rule in the specified rule group, using the specified domain list.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateFirewallRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_firewall_rule_input::Builder,
    }
    impl<C, M, R> CreateFirewallRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFirewallRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFirewallRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFirewallRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFirewallRuleInputOperationOutputAlias,
                crate::output::CreateFirewallRuleOutput,
                crate::error::CreateFirewallRuleError,
                crate::input::CreateFirewallRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique string that identifies the request and that allows you to retry failed requests
        /// without the risk of running the operation twice. <code>CreatorRequestId</code> can be
        /// any unique string, for example, a date/time stamp. </p>
        pub fn creator_request_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.creator_request_id(inp);
            self
        }
        /// <p>A unique string that identifies the request and that allows you to retry failed requests
        /// without the risk of running the operation twice. <code>CreatorRequestId</code> can be
        /// any unique string, for example, a date/time stamp. </p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_creator_request_id(input);
            self
        }
        /// <p>The unique identifier of the firewall rule group where you want to create the rule. </p>
        pub fn firewall_rule_group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_rule_group_id(inp);
            self
        }
        /// <p>The unique identifier of the firewall rule group where you want to create the rule. </p>
        pub fn set_firewall_rule_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_rule_group_id(input);
            self
        }
        /// <p>The ID of the domain list that you want to use in the rule. </p>
        pub fn firewall_domain_list_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_domain_list_id(inp);
            self
        }
        /// <p>The ID of the domain list that you want to use in the rule. </p>
        pub fn set_firewall_domain_list_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_domain_list_id(input);
            self
        }
        /// <p>The setting that determines the processing order of the rule in the rule group. DNS Firewall
        /// processes the rules in a rule group by order of priority, starting from the lowest setting.</p>
        /// <p>You must specify a unique priority for each rule in a rule group.
        /// To make it easier to insert rules later, leave space between the numbers, for example, use 100, 200, and so on. You
        /// can change the priority setting for the rules in a rule group at any time.</p>
        pub fn priority(mut self, inp: i32) -> Self {
            self.inner = self.inner.priority(inp);
            self
        }
        /// <p>The setting that determines the processing order of the rule in the rule group. DNS Firewall
        /// processes the rules in a rule group by order of priority, starting from the lowest setting.</p>
        /// <p>You must specify a unique priority for each rule in a rule group.
        /// To make it easier to insert rules later, leave space between the numbers, for example, use 100, 200, and so on. You
        /// can change the priority setting for the rules in a rule group at any time.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_priority(input);
            self
        }
        /// <p>The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALLOW</code> - Permit the request to go through.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALERT</code> - Permit the request and send metrics and logs to Cloud Watch.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BLOCK</code> - Disallow the request. This option requires additional details in the rule's <code>BlockResponse</code>. </p>
        /// </li>
        /// </ul>
        pub fn action(mut self, inp: crate::model::Action) -> Self {
            self.inner = self.inner.action(inp);
            self
        }
        /// <p>The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALLOW</code> - Permit the request to go through.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALERT</code> - Permit the request and send metrics and logs to Cloud Watch.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BLOCK</code> - Disallow the request. This option requires additional details in the rule's <code>BlockResponse</code>. </p>
        /// </li>
        /// </ul>
        pub fn set_action(mut self, input: std::option::Option<crate::model::Action>) -> Self {
            self.inner = self.inner.set_action(input);
            self
        }
        /// <p>The way that you want DNS Firewall to block the request, used with the rule action
        /// setting <code>BLOCK</code>. </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NODATA</code> - Respond indicating that the query was successful, but no response is available for it.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NXDOMAIN</code> - Respond indicating that the domain name that's in the query doesn't exist.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OVERRIDE</code> - Provide a custom override in the response. This option requires custom handling details in the rule's <code>BlockOverride*</code> settings. </p>
        /// </li>
        /// </ul>
        /// <p>This setting is required if the rule action setting is <code>BLOCK</code>.</p>
        pub fn block_response(mut self, inp: crate::model::BlockResponse) -> Self {
            self.inner = self.inner.block_response(inp);
            self
        }
        /// <p>The way that you want DNS Firewall to block the request, used with the rule action
        /// setting <code>BLOCK</code>. </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NODATA</code> - Respond indicating that the query was successful, but no response is available for it.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NXDOMAIN</code> - Respond indicating that the domain name that's in the query doesn't exist.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OVERRIDE</code> - Provide a custom override in the response. This option requires custom handling details in the rule's <code>BlockOverride*</code> settings. </p>
        /// </li>
        /// </ul>
        /// <p>This setting is required if the rule action setting is <code>BLOCK</code>.</p>
        pub fn set_block_response(
            mut self,
            input: std::option::Option<crate::model::BlockResponse>,
        ) -> Self {
            self.inner = self.inner.set_block_response(input);
            self
        }
        /// <p>The custom DNS record to send back in response to the query. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
        /// <p>This setting is required if the <code>BlockResponse</code> setting is <code>OVERRIDE</code>.</p>
        pub fn block_override_domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.block_override_domain(inp);
            self
        }
        /// <p>The custom DNS record to send back in response to the query. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
        /// <p>This setting is required if the <code>BlockResponse</code> setting is <code>OVERRIDE</code>.</p>
        pub fn set_block_override_domain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_block_override_domain(input);
            self
        }
        /// <p>The DNS record's type. This determines the format of the record value that you provided in <code>BlockOverrideDomain</code>. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
        /// <p>This setting is required if the <code>BlockResponse</code> setting is <code>OVERRIDE</code>.</p>
        pub fn block_override_dns_type(mut self, inp: crate::model::BlockOverrideDnsType) -> Self {
            self.inner = self.inner.block_override_dns_type(inp);
            self
        }
        /// <p>The DNS record's type. This determines the format of the record value that you provided in <code>BlockOverrideDomain</code>. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
        /// <p>This setting is required if the <code>BlockResponse</code> setting is <code>OVERRIDE</code>.</p>
        pub fn set_block_override_dns_type(
            mut self,
            input: std::option::Option<crate::model::BlockOverrideDnsType>,
        ) -> Self {
            self.inner = self.inner.set_block_override_dns_type(input);
            self
        }
        /// <p>The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
        /// <p>This setting is required if the <code>BlockResponse</code> setting is <code>OVERRIDE</code>.</p>
        pub fn block_override_ttl(mut self, inp: i32) -> Self {
            self.inner = self.inner.block_override_ttl(inp);
            self
        }
        /// <p>The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
        /// <p>This setting is required if the <code>BlockResponse</code> setting is <code>OVERRIDE</code>.</p>
        pub fn set_block_override_ttl(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_block_override_ttl(input);
            self
        }
        /// <p>A name that lets you identify the rule in the rule group.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A name that lets you identify the rule in the rule group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFirewallRuleGroup`.
    ///
    /// <p>Creates an empty DNS Firewall rule group for filtering DNS network traffic in a VPC. You can add rules to the new rule group
    /// by calling <a>CreateFirewallRule</a>. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateFirewallRuleGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_firewall_rule_group_input::Builder,
    }
    impl<C, M, R> CreateFirewallRuleGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFirewallRuleGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFirewallRuleGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFirewallRuleGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFirewallRuleGroupInputOperationOutputAlias,
                crate::output::CreateFirewallRuleGroupOutput,
                crate::error::CreateFirewallRuleGroupError,
                crate::input::CreateFirewallRuleGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique string defined by you to identify the request. This allows you to retry failed
        /// requests without the risk of running the operation twice. This can be any unique string,
        /// for example, a timestamp. </p>
        pub fn creator_request_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.creator_request_id(inp);
            self
        }
        /// <p>A unique string defined by you to identify the request. This allows you to retry failed
        /// requests without the risk of running the operation twice. This can be any unique string,
        /// for example, a timestamp. </p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_creator_request_id(input);
            self
        }
        /// <p>A name that lets you identify the rule group, to manage and use it.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A name that lets you identify the rule group, to manage and use it.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of the tag keys and values that you want to associate with the rule group. </p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of the tag keys and values that you want to associate with the rule group. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateResolverEndpoint`.
    ///
    /// <p>Creates a Resolver endpoint. There are two types of Resolver endpoints, inbound and outbound:</p>
    /// <ul>
    /// <li>
    /// <p>An <i>inbound Resolver endpoint</i> forwards DNS queries to the DNS service for a VPC
    /// from your network.</p>
    /// </li>
    /// <li>
    /// <p>An <i>outbound Resolver endpoint</i> forwards DNS queries from the DNS service for a VPC
    /// to your network.</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct CreateResolverEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_resolver_endpoint_input::Builder,
    }
    impl<C, M, R> CreateResolverEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateResolverEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateResolverEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateResolverEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateResolverEndpointInputOperationOutputAlias,
                crate::output::CreateResolverEndpointOutput,
                crate::error::CreateResolverEndpointError,
                crate::input::CreateResolverEndpointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique string that identifies the request and that allows failed requests to be retried
        /// without the risk of running the operation twice. <code>CreatorRequestId</code> can be
        /// any unique string, for example, a date/time stamp. </p>
        pub fn creator_request_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.creator_request_id(inp);
            self
        }
        /// <p>A unique string that identifies the request and that allows failed requests to be retried
        /// without the risk of running the operation twice. <code>CreatorRequestId</code> can be
        /// any unique string, for example, a date/time stamp. </p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_creator_request_id(input);
            self
        }
        /// <p>A friendly name that lets you easily find a configuration in the Resolver dashboard in the Route 53 console.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A friendly name that lets you easily find a configuration in the Resolver dashboard in the Route 53 console.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `SecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>The ID of one or more security groups that you want to use to control access to this VPC. The security group that you specify
        /// must include one or more inbound rules (for inbound Resolver endpoints) or outbound rules (for outbound Resolver endpoints).
        /// Inbound and outbound rules must allow TCP and UDP access. For inbound access, open port 53. For outbound access, open the port
        /// that you're using for DNS queries on your network.</p>
        pub fn security_group_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_group_ids(inp);
            self
        }
        /// <p>The ID of one or more security groups that you want to use to control access to this VPC. The security group that you specify
        /// must include one or more inbound rules (for inbound Resolver endpoints) or outbound rules (for outbound Resolver endpoints).
        /// Inbound and outbound rules must allow TCP and UDP access. For inbound access, open port 53. For outbound access, open the port
        /// that you're using for DNS queries on your network.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_group_ids(input);
            self
        }
        /// <p>Specify the applicable value:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INBOUND</code>: Resolver forwards DNS queries to the DNS service for a VPC from your network</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OUTBOUND</code>: Resolver forwards DNS queries from the DNS service for a VPC to your network</p>
        /// </li>
        /// </ul>
        pub fn direction(mut self, inp: crate::model::ResolverEndpointDirection) -> Self {
            self.inner = self.inner.direction(inp);
            self
        }
        /// <p>Specify the applicable value:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INBOUND</code>: Resolver forwards DNS queries to the DNS service for a VPC from your network</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OUTBOUND</code>: Resolver forwards DNS queries from the DNS service for a VPC to your network</p>
        /// </li>
        /// </ul>
        pub fn set_direction(
            mut self,
            input: std::option::Option<crate::model::ResolverEndpointDirection>,
        ) -> Self {
            self.inner = self.inner.set_direction(input);
            self
        }
        /// Appends an item to `IpAddresses`.
        ///
        /// To override the contents of this collection use [`set_ip_addresses`](Self::set_ip_addresses).
        ///
        /// <p>The subnets and IP addresses in your VPC that DNS queries originate from (for outbound endpoints) or that you forward
        /// DNS queries to (for inbound endpoints). The subnet ID uniquely identifies a VPC. </p>
        pub fn ip_addresses(mut self, inp: impl Into<crate::model::IpAddressRequest>) -> Self {
            self.inner = self.inner.ip_addresses(inp);
            self
        }
        /// <p>The subnets and IP addresses in your VPC that DNS queries originate from (for outbound endpoints) or that you forward
        /// DNS queries to (for inbound endpoints). The subnet ID uniquely identifies a VPC. </p>
        pub fn set_ip_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IpAddressRequest>>,
        ) -> Self {
            self.inner = self.inner.set_ip_addresses(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of the tag keys and values that you want to associate with the endpoint.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of the tag keys and values that you want to associate with the endpoint.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateResolverQueryLogConfig`.
    ///
    /// <p>Creates a Resolver query logging configuration, which defines where you want Resolver to save DNS query logs that originate in your VPCs.
    /// Resolver can log queries only for VPCs that are in the same Region as the query logging configuration.</p>
    ///
    /// <p>To specify which VPCs you want to log queries for, you use <code>AssociateResolverQueryLogConfig</code>. For more information, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverQueryLogConfig.html">AssociateResolverQueryLogConfig</a>. </p>
    ///
    /// <p>You can optionally use Resource Access Manager (RAM) to share a query logging configuration with other Amazon Web Services accounts. The other accounts
    /// can then associate VPCs with the configuration. The query logs that Resolver creates for a configuration include all DNS queries that originate in all
    /// VPCs that are associated with the configuration.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateResolverQueryLogConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_resolver_query_log_config_input::Builder,
    }
    impl<C, M, R> CreateResolverQueryLogConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateResolverQueryLogConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateResolverQueryLogConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateResolverQueryLogConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateResolverQueryLogConfigInputOperationOutputAlias,
                crate::output::CreateResolverQueryLogConfigOutput,
                crate::error::CreateResolverQueryLogConfigError,
                crate::input::CreateResolverQueryLogConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name that you want to give the query logging configuration.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name that you want to give the query logging configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The ARN of the resource that you want Resolver to send query logs. You can send query logs to an S3 bucket, a CloudWatch Logs log group,
        /// or a Kinesis Data Firehose delivery stream. Examples of valid values include the following:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <b>S3 bucket</b>: </p>
        /// <p>
        /// <code>arn:aws:s3:::examplebucket</code>
        /// </p>
        /// <p>You can optionally append a file prefix to the end of the ARN.</p>
        /// <p>
        /// <code>arn:aws:s3:::examplebucket/development/</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>CloudWatch Logs log group</b>: </p>
        /// <p>
        /// <code>arn:aws:logs:us-west-1:123456789012:log-group:/mystack-testgroup-12ABC1AB12A1:*</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Kinesis Data Firehose delivery stream</b>:</p>
        /// <p>
        /// <code>arn:aws:kinesis:us-east-2:0123456789:stream/my_stream_name</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn destination_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_arn(inp);
            self
        }
        /// <p>The ARN of the resource that you want Resolver to send query logs. You can send query logs to an S3 bucket, a CloudWatch Logs log group,
        /// or a Kinesis Data Firehose delivery stream. Examples of valid values include the following:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <b>S3 bucket</b>: </p>
        /// <p>
        /// <code>arn:aws:s3:::examplebucket</code>
        /// </p>
        /// <p>You can optionally append a file prefix to the end of the ARN.</p>
        /// <p>
        /// <code>arn:aws:s3:::examplebucket/development/</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>CloudWatch Logs log group</b>: </p>
        /// <p>
        /// <code>arn:aws:logs:us-west-1:123456789012:log-group:/mystack-testgroup-12ABC1AB12A1:*</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Kinesis Data Firehose delivery stream</b>:</p>
        /// <p>
        /// <code>arn:aws:kinesis:us-east-2:0123456789:stream/my_stream_name</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_destination_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_arn(input);
            self
        }
        /// <p>A unique string that identifies the request and that allows failed requests to be retried
        /// without the risk of running the operation twice. <code>CreatorRequestId</code> can be
        /// any unique string, for example, a date/time stamp. </p>
        pub fn creator_request_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.creator_request_id(inp);
            self
        }
        /// <p>A unique string that identifies the request and that allows failed requests to be retried
        /// without the risk of running the operation twice. <code>CreatorRequestId</code> can be
        /// any unique string, for example, a date/time stamp. </p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_creator_request_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of the tag keys and values that you want to associate with the query logging configuration.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of the tag keys and values that you want to associate with the query logging configuration.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateResolverRule`.
    ///
    /// <p>For DNS queries that originate in your VPCs, specifies which Resolver endpoint the queries pass through,
    /// one domain name that you want to forward to your network, and the IP addresses of the DNS resolvers in your network.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateResolverRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_resolver_rule_input::Builder,
    }
    impl<C, M, R> CreateResolverRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateResolverRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateResolverRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateResolverRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateResolverRuleInputOperationOutputAlias,
                crate::output::CreateResolverRuleOutput,
                crate::error::CreateResolverRuleError,
                crate::input::CreateResolverRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique string that identifies the request and that allows failed requests to be retried
        /// without the risk of running the operation twice. <code>CreatorRequestId</code> can be
        /// any unique string, for example, a date/time stamp. </p>
        pub fn creator_request_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.creator_request_id(inp);
            self
        }
        /// <p>A unique string that identifies the request and that allows failed requests to be retried
        /// without the risk of running the operation twice. <code>CreatorRequestId</code> can be
        /// any unique string, for example, a date/time stamp. </p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_creator_request_id(input);
            self
        }
        /// <p>A friendly name that lets you easily find a rule in the Resolver dashboard in the Route 53 console.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A friendly name that lets you easily find a rule in the Resolver dashboard in the Route 53 console.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>When you want to forward DNS queries for specified domain name to resolvers on your network, specify <code>FORWARD</code>.</p>
        /// <p>When you have a forwarding rule to forward DNS queries for a domain to your network and you want Resolver to process queries for
        /// a subdomain of that domain, specify <code>SYSTEM</code>.</p>
        /// <p>For example, to forward DNS queries for example.com to resolvers on your network, you create a rule and specify <code>FORWARD</code>
        /// for <code>RuleType</code>. To then have Resolver process queries for apex.example.com, you create a rule and specify
        /// <code>SYSTEM</code> for <code>RuleType</code>.</p>
        /// <p>Currently, only Resolver can create rules that have a value of <code>RECURSIVE</code> for <code>RuleType</code>.</p>
        pub fn rule_type(mut self, inp: crate::model::RuleTypeOption) -> Self {
            self.inner = self.inner.rule_type(inp);
            self
        }
        /// <p>When you want to forward DNS queries for specified domain name to resolvers on your network, specify <code>FORWARD</code>.</p>
        /// <p>When you have a forwarding rule to forward DNS queries for a domain to your network and you want Resolver to process queries for
        /// a subdomain of that domain, specify <code>SYSTEM</code>.</p>
        /// <p>For example, to forward DNS queries for example.com to resolvers on your network, you create a rule and specify <code>FORWARD</code>
        /// for <code>RuleType</code>. To then have Resolver process queries for apex.example.com, you create a rule and specify
        /// <code>SYSTEM</code> for <code>RuleType</code>.</p>
        /// <p>Currently, only Resolver can create rules that have a value of <code>RECURSIVE</code> for <code>RuleType</code>.</p>
        pub fn set_rule_type(
            mut self,
            input: std::option::Option<crate::model::RuleTypeOption>,
        ) -> Self {
            self.inner = self.inner.set_rule_type(input);
            self
        }
        /// <p>DNS queries for this domain name are forwarded to the IP addresses that you specify in <code>TargetIps</code>. If a query matches
        /// multiple Resolver rules (example.com and www.example.com), outbound DNS queries are routed using the Resolver rule that contains
        /// the most specific domain name (www.example.com).</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>DNS queries for this domain name are forwarded to the IP addresses that you specify in <code>TargetIps</code>. If a query matches
        /// multiple Resolver rules (example.com and www.example.com), outbound DNS queries are routed using the Resolver rule that contains
        /// the most specific domain name (www.example.com).</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// Appends an item to `TargetIps`.
        ///
        /// To override the contents of this collection use [`set_target_ips`](Self::set_target_ips).
        ///
        /// <p>The IPs that you want Resolver to forward DNS queries to. You can specify only IPv4 addresses. Separate IP addresses with a space.</p>
        /// <p>
        /// <code>TargetIps</code> is available only when the value of <code>Rule type</code> is <code>FORWARD</code>.</p>
        pub fn target_ips(mut self, inp: impl Into<crate::model::TargetAddress>) -> Self {
            self.inner = self.inner.target_ips(inp);
            self
        }
        /// <p>The IPs that you want Resolver to forward DNS queries to. You can specify only IPv4 addresses. Separate IP addresses with a space.</p>
        /// <p>
        /// <code>TargetIps</code> is available only when the value of <code>Rule type</code> is <code>FORWARD</code>.</p>
        pub fn set_target_ips(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetAddress>>,
        ) -> Self {
            self.inner = self.inner.set_target_ips(input);
            self
        }
        /// <p>The ID of the outbound Resolver endpoint that you want to use to route DNS queries to the IP addresses that you specify
        /// in <code>TargetIps</code>.</p>
        pub fn resolver_endpoint_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolver_endpoint_id(inp);
            self
        }
        /// <p>The ID of the outbound Resolver endpoint that you want to use to route DNS queries to the IP addresses that you specify
        /// in <code>TargetIps</code>.</p>
        pub fn set_resolver_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolver_endpoint_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of the tag keys and values that you want to associate with the endpoint.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of the tag keys and values that you want to associate with the endpoint.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFirewallDomainList`.
    ///
    /// <p>Deletes the specified domain list. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteFirewallDomainList<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_firewall_domain_list_input::Builder,
    }
    impl<C, M, R> DeleteFirewallDomainList<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFirewallDomainList`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFirewallDomainListOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFirewallDomainListError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFirewallDomainListInputOperationOutputAlias,
                crate::output::DeleteFirewallDomainListOutput,
                crate::error::DeleteFirewallDomainListError,
                crate::input::DeleteFirewallDomainListInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the domain list that you want to delete. </p>
        pub fn firewall_domain_list_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_domain_list_id(inp);
            self
        }
        /// <p>The ID of the domain list that you want to delete. </p>
        pub fn set_firewall_domain_list_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_domain_list_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFirewallRule`.
    ///
    /// <p>Deletes the specified firewall rule.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteFirewallRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_firewall_rule_input::Builder,
    }
    impl<C, M, R> DeleteFirewallRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFirewallRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFirewallRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFirewallRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFirewallRuleInputOperationOutputAlias,
                crate::output::DeleteFirewallRuleOutput,
                crate::error::DeleteFirewallRuleError,
                crate::input::DeleteFirewallRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the firewall rule group that you want to delete the rule from. </p>
        pub fn firewall_rule_group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_rule_group_id(inp);
            self
        }
        /// <p>The unique identifier of the firewall rule group that you want to delete the rule from. </p>
        pub fn set_firewall_rule_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_rule_group_id(input);
            self
        }
        /// <p>The ID of the domain list that's used in the rule.  </p>
        pub fn firewall_domain_list_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_domain_list_id(inp);
            self
        }
        /// <p>The ID of the domain list that's used in the rule.  </p>
        pub fn set_firewall_domain_list_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_domain_list_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFirewallRuleGroup`.
    ///
    /// <p>Deletes the specified firewall rule group. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteFirewallRuleGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_firewall_rule_group_input::Builder,
    }
    impl<C, M, R> DeleteFirewallRuleGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFirewallRuleGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFirewallRuleGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFirewallRuleGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFirewallRuleGroupInputOperationOutputAlias,
                crate::output::DeleteFirewallRuleGroupOutput,
                crate::error::DeleteFirewallRuleGroupError,
                crate::input::DeleteFirewallRuleGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the firewall rule group that you want to delete. </p>
        pub fn firewall_rule_group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_rule_group_id(inp);
            self
        }
        /// <p>The unique identifier of the firewall rule group that you want to delete. </p>
        pub fn set_firewall_rule_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_rule_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResolverEndpoint`.
    ///
    /// <p>Deletes a Resolver endpoint. The effect of deleting a Resolver endpoint depends on whether it's an inbound or an outbound
    /// Resolver endpoint:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Inbound</b>: DNS queries from your network are no longer routed
    /// to the DNS service for the specified VPC.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Outbound</b>: DNS queries from a VPC are no longer routed to your network.</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct DeleteResolverEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_resolver_endpoint_input::Builder,
    }
    impl<C, M, R> DeleteResolverEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteResolverEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResolverEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResolverEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteResolverEndpointInputOperationOutputAlias,
                crate::output::DeleteResolverEndpointOutput,
                crate::error::DeleteResolverEndpointError,
                crate::input::DeleteResolverEndpointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Resolver endpoint that you want to delete.</p>
        pub fn resolver_endpoint_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolver_endpoint_id(inp);
            self
        }
        /// <p>The ID of the Resolver endpoint that you want to delete.</p>
        pub fn set_resolver_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolver_endpoint_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResolverQueryLogConfig`.
    ///
    /// <p>Deletes a query logging configuration. When you delete a configuration, Resolver stops logging DNS queries for all of the Amazon VPCs that are
    /// associated with the configuration. This also applies if the query logging configuration is shared with other Amazon Web Services accounts, and
    /// the other accounts have associated VPCs with the shared configuration.</p>
    ///
    /// <p>Before you can delete a query logging configuration, you must first disassociate all VPCs from the configuration. See
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverQueryLogConfig.html">DisassociateResolverQueryLogConfig</a>.</p>
    ///
    /// <p>If you used Resource Access Manager (RAM) to share a query logging configuration with other accounts, you must stop sharing
    /// the configuration before you can delete a configuration. The accounts that you shared the configuration with can first disassociate VPCs
    /// that they associated with the configuration, but that's not necessary. If you stop sharing the configuration, those VPCs are automatically
    /// disassociated from the configuration.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteResolverQueryLogConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_resolver_query_log_config_input::Builder,
    }
    impl<C, M, R> DeleteResolverQueryLogConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteResolverQueryLogConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResolverQueryLogConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResolverQueryLogConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteResolverQueryLogConfigInputOperationOutputAlias,
                crate::output::DeleteResolverQueryLogConfigOutput,
                crate::error::DeleteResolverQueryLogConfigError,
                crate::input::DeleteResolverQueryLogConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the query logging configuration that you want to delete.</p>
        pub fn resolver_query_log_config_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolver_query_log_config_id(inp);
            self
        }
        /// <p>The ID of the query logging configuration that you want to delete.</p>
        pub fn set_resolver_query_log_config_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolver_query_log_config_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResolverRule`.
    ///
    /// <p>Deletes a Resolver rule. Before you can delete a Resolver rule, you must disassociate it from all the VPCs that you
    /// associated the Resolver rule with. For more information, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverRule.html">DisassociateResolverRule</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteResolverRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_resolver_rule_input::Builder,
    }
    impl<C, M, R> DeleteResolverRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteResolverRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResolverRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResolverRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteResolverRuleInputOperationOutputAlias,
                crate::output::DeleteResolverRuleOutput,
                crate::error::DeleteResolverRuleError,
                crate::input::DeleteResolverRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Resolver rule that you want to delete.</p>
        pub fn resolver_rule_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolver_rule_id(inp);
            self
        }
        /// <p>The ID of the Resolver rule that you want to delete.</p>
        pub fn set_resolver_rule_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolver_rule_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateFirewallRuleGroup`.
    ///
    /// <p>Disassociates a <a>FirewallRuleGroup</a> from a VPC, to remove DNS filtering from the VPC. </p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateFirewallRuleGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_firewall_rule_group_input::Builder,
    }
    impl<C, M, R> DisassociateFirewallRuleGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateFirewallRuleGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateFirewallRuleGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateFirewallRuleGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateFirewallRuleGroupInputOperationOutputAlias,
                crate::output::DisassociateFirewallRuleGroupOutput,
                crate::error::DisassociateFirewallRuleGroupError,
                crate::input::DisassociateFirewallRuleGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the <a>FirewallRuleGroupAssociation</a>. </p>
        pub fn firewall_rule_group_association_id(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.firewall_rule_group_association_id(inp);
            self
        }
        /// <p>The identifier of the <a>FirewallRuleGroupAssociation</a>. </p>
        pub fn set_firewall_rule_group_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_rule_group_association_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateResolverEndpointIpAddress`.
    ///
    /// <p>Removes IP addresses from an inbound or an outbound Resolver endpoint. If you want to remove more than one IP address,
    /// submit one <code>DisassociateResolverEndpointIpAddress</code> request for each IP address.</p>
    /// <p>To add an IP address to an endpoint, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverEndpointIpAddress.html">AssociateResolverEndpointIpAddress</a>.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateResolverEndpointIpAddress<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_resolver_endpoint_ip_address_input::Builder,
    }
    impl<C, M, R> DisassociateResolverEndpointIpAddress<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateResolverEndpointIpAddress`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateResolverEndpointIpAddressOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateResolverEndpointIpAddressError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateResolverEndpointIpAddressInputOperationOutputAlias,
                crate::output::DisassociateResolverEndpointIpAddressOutput,
                crate::error::DisassociateResolverEndpointIpAddressError,
                crate::input::DisassociateResolverEndpointIpAddressInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Resolver endpoint that you want to disassociate an IP address from.</p>
        pub fn resolver_endpoint_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolver_endpoint_id(inp);
            self
        }
        /// <p>The ID of the Resolver endpoint that you want to disassociate an IP address from.</p>
        pub fn set_resolver_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolver_endpoint_id(input);
            self
        }
        /// <p>The IPv4 address that you want to remove from a Resolver endpoint.</p>
        pub fn ip_address(mut self, inp: crate::model::IpAddressUpdate) -> Self {
            self.inner = self.inner.ip_address(inp);
            self
        }
        /// <p>The IPv4 address that you want to remove from a Resolver endpoint.</p>
        pub fn set_ip_address(
            mut self,
            input: std::option::Option<crate::model::IpAddressUpdate>,
        ) -> Self {
            self.inner = self.inner.set_ip_address(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateResolverQueryLogConfig`.
    ///
    /// <p>Disassociates a VPC from a query logging configuration.</p>
    ///
    /// <note>
    /// <p>Before you can delete a query logging configuration, you must first disassociate all VPCs
    /// from the configuration. If you used Resource Access Manager (RAM) to share a
    /// query logging configuration with other accounts, VPCs can be disassociated from the
    /// configuration in the following ways:</p>
    /// <ul>
    /// <li>
    /// <p>The accounts that you shared the configuration with can disassociate VPCs from the configuration.</p>
    /// </li>
    /// <li>
    /// <p>You can stop sharing the configuration.</p>
    /// </li>
    /// </ul>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateResolverQueryLogConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_resolver_query_log_config_input::Builder,
    }
    impl<C, M, R> DisassociateResolverQueryLogConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateResolverQueryLogConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateResolverQueryLogConfigOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateResolverQueryLogConfigError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateResolverQueryLogConfigInputOperationOutputAlias,
                crate::output::DisassociateResolverQueryLogConfigOutput,
                crate::error::DisassociateResolverQueryLogConfigError,
                crate::input::DisassociateResolverQueryLogConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the query logging configuration that you want to disassociate a specified VPC from.</p>
        pub fn resolver_query_log_config_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolver_query_log_config_id(inp);
            self
        }
        /// <p>The ID of the query logging configuration that you want to disassociate a specified VPC from.</p>
        pub fn set_resolver_query_log_config_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolver_query_log_config_id(input);
            self
        }
        /// <p>The ID of the Amazon VPC that you want to disassociate from a specified query logging configuration.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>The ID of the Amazon VPC that you want to disassociate from a specified query logging configuration.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateResolverRule`.
    ///
    /// <p>Removes the association between a specified Resolver rule and a specified VPC.</p>
    /// <important>
    /// <p>If you disassociate a Resolver rule from a VPC, Resolver stops forwarding DNS queries for the
    /// domain name that you specified in the Resolver rule. </p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateResolverRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_resolver_rule_input::Builder,
    }
    impl<C, M, R> DisassociateResolverRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateResolverRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateResolverRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateResolverRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateResolverRuleInputOperationOutputAlias,
                crate::output::DisassociateResolverRuleOutput,
                crate::error::DisassociateResolverRuleError,
                crate::input::DisassociateResolverRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the VPC that you want to disassociate the Resolver rule from.</p>
        pub fn vpc_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_id(inp);
            self
        }
        /// <p>The ID of the VPC that you want to disassociate the Resolver rule from.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_id(input);
            self
        }
        /// <p>The ID of the Resolver rule that you want to disassociate from the specified VPC.</p>
        pub fn resolver_rule_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolver_rule_id(inp);
            self
        }
        /// <p>The ID of the Resolver rule that you want to disassociate from the specified VPC.</p>
        pub fn set_resolver_rule_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolver_rule_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFirewallConfig`.
    ///
    /// <p>Retrieves the configuration of the firewall behavior provided by DNS Firewall for a
    /// single VPC from Amazon Virtual Private Cloud (Amazon VPC). </p>
    #[derive(std::fmt::Debug)]
    pub struct GetFirewallConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_firewall_config_input::Builder,
    }
    impl<C, M, R> GetFirewallConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFirewallConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFirewallConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFirewallConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFirewallConfigInputOperationOutputAlias,
                crate::output::GetFirewallConfigOutput,
                crate::error::GetFirewallConfigError,
                crate::input::GetFirewallConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the VPC from Amazon VPC that the configuration is for.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>The ID of the VPC from Amazon VPC that the configuration is for.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFirewallDomainList`.
    ///
    /// <p>Retrieves the specified firewall domain list.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetFirewallDomainList<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_firewall_domain_list_input::Builder,
    }
    impl<C, M, R> GetFirewallDomainList<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFirewallDomainList`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFirewallDomainListOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFirewallDomainListError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFirewallDomainListInputOperationOutputAlias,
                crate::output::GetFirewallDomainListOutput,
                crate::error::GetFirewallDomainListError,
                crate::input::GetFirewallDomainListInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the domain list.  </p>
        pub fn firewall_domain_list_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_domain_list_id(inp);
            self
        }
        /// <p>The ID of the domain list.  </p>
        pub fn set_firewall_domain_list_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_domain_list_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFirewallRuleGroup`.
    ///
    /// <p>Retrieves the specified firewall rule group. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetFirewallRuleGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_firewall_rule_group_input::Builder,
    }
    impl<C, M, R> GetFirewallRuleGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFirewallRuleGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFirewallRuleGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFirewallRuleGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFirewallRuleGroupInputOperationOutputAlias,
                crate::output::GetFirewallRuleGroupOutput,
                crate::error::GetFirewallRuleGroupError,
                crate::input::GetFirewallRuleGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the firewall rule group. </p>
        pub fn firewall_rule_group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_rule_group_id(inp);
            self
        }
        /// <p>The unique identifier of the firewall rule group. </p>
        pub fn set_firewall_rule_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_rule_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFirewallRuleGroupAssociation`.
    ///
    /// <p>Retrieves a firewall rule group association, which enables DNS filtering for a VPC with one rule group. A VPC can have more than one firewall rule group association, and a rule group can be associated with more than one VPC.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetFirewallRuleGroupAssociation<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_firewall_rule_group_association_input::Builder,
    }
    impl<C, M, R> GetFirewallRuleGroupAssociation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFirewallRuleGroupAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFirewallRuleGroupAssociationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFirewallRuleGroupAssociationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFirewallRuleGroupAssociationInputOperationOutputAlias,
                crate::output::GetFirewallRuleGroupAssociationOutput,
                crate::error::GetFirewallRuleGroupAssociationError,
                crate::input::GetFirewallRuleGroupAssociationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the <a>FirewallRuleGroupAssociation</a>. </p>
        pub fn firewall_rule_group_association_id(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.firewall_rule_group_association_id(inp);
            self
        }
        /// <p>The identifier of the <a>FirewallRuleGroupAssociation</a>. </p>
        pub fn set_firewall_rule_group_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_rule_group_association_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFirewallRuleGroupPolicy`.
    ///
    /// <p>Returns the Identity and Access Management (Amazon Web Services IAM) policy for sharing the
    /// specified rule group. You can use the policy to share the rule group using Resource Access Manager (RAM). </p>
    #[derive(std::fmt::Debug)]
    pub struct GetFirewallRuleGroupPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_firewall_rule_group_policy_input::Builder,
    }
    impl<C, M, R> GetFirewallRuleGroupPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFirewallRuleGroupPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFirewallRuleGroupPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFirewallRuleGroupPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFirewallRuleGroupPolicyInputOperationOutputAlias,
                crate::output::GetFirewallRuleGroupPolicyOutput,
                crate::error::GetFirewallRuleGroupPolicyError,
                crate::input::GetFirewallRuleGroupPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN (Amazon Resource Name) for the rule group.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The ARN (Amazon Resource Name) for the rule group.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResolverConfig`.
    ///
    /// <p>Retrieves the behavior configuration of Route 53 Resolver behavior for a single VPC from
    /// Amazon Virtual Private Cloud.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetResolverConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_resolver_config_input::Builder,
    }
    impl<C, M, R> GetResolverConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetResolverConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResolverConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResolverConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetResolverConfigInputOperationOutputAlias,
                crate::output::GetResolverConfigOutput,
                crate::error::GetResolverConfigError,
                crate::input::GetResolverConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Resource ID of the Amazon VPC that you want to get information about.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>Resource ID of the Amazon VPC that you want to get information about.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResolverDnssecConfig`.
    ///
    /// <p>Gets DNSSEC validation information for a specified resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetResolverDnssecConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_resolver_dnssec_config_input::Builder,
    }
    impl<C, M, R> GetResolverDnssecConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetResolverDnssecConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResolverDnssecConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResolverDnssecConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetResolverDnssecConfigInputOperationOutputAlias,
                crate::output::GetResolverDnssecConfigOutput,
                crate::error::GetResolverDnssecConfigError,
                crate::input::GetResolverDnssecConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the virtual private cloud (VPC) for the DNSSEC validation status.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>The ID of the virtual private cloud (VPC) for the DNSSEC validation status.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResolverEndpoint`.
    ///
    /// <p>Gets information about a specified Resolver endpoint, such as whether it's an inbound or an outbound Resolver endpoint, and the
    /// current status of the endpoint.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetResolverEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_resolver_endpoint_input::Builder,
    }
    impl<C, M, R> GetResolverEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetResolverEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResolverEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResolverEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetResolverEndpointInputOperationOutputAlias,
                crate::output::GetResolverEndpointOutput,
                crate::error::GetResolverEndpointError,
                crate::input::GetResolverEndpointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Resolver endpoint that you want to get information about.</p>
        pub fn resolver_endpoint_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolver_endpoint_id(inp);
            self
        }
        /// <p>The ID of the Resolver endpoint that you want to get information about.</p>
        pub fn set_resolver_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolver_endpoint_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResolverQueryLogConfig`.
    ///
    /// <p>Gets information about a specified Resolver query logging configuration, such as the number of VPCs that the configuration
    /// is logging queries for and the location that logs are sent to. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetResolverQueryLogConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_resolver_query_log_config_input::Builder,
    }
    impl<C, M, R> GetResolverQueryLogConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetResolverQueryLogConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResolverQueryLogConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResolverQueryLogConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetResolverQueryLogConfigInputOperationOutputAlias,
                crate::output::GetResolverQueryLogConfigOutput,
                crate::error::GetResolverQueryLogConfigError,
                crate::input::GetResolverQueryLogConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Resolver query logging configuration that you want to get information about.</p>
        pub fn resolver_query_log_config_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolver_query_log_config_id(inp);
            self
        }
        /// <p>The ID of the Resolver query logging configuration that you want to get information about.</p>
        pub fn set_resolver_query_log_config_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolver_query_log_config_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResolverQueryLogConfigAssociation`.
    ///
    /// <p>Gets information about a specified association between a Resolver query logging configuration and an Amazon VPC. When you associate a VPC
    /// with a query logging configuration, Resolver logs DNS queries that originate in that VPC.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetResolverQueryLogConfigAssociation<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_resolver_query_log_config_association_input::Builder,
    }
    impl<C, M, R> GetResolverQueryLogConfigAssociation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetResolverQueryLogConfigAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResolverQueryLogConfigAssociationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetResolverQueryLogConfigAssociationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetResolverQueryLogConfigAssociationInputOperationOutputAlias,
                crate::output::GetResolverQueryLogConfigAssociationOutput,
                crate::error::GetResolverQueryLogConfigAssociationError,
                crate::input::GetResolverQueryLogConfigAssociationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Resolver query logging configuration association that you want to get information about.</p>
        pub fn resolver_query_log_config_association_id(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.resolver_query_log_config_association_id(inp);
            self
        }
        /// <p>The ID of the Resolver query logging configuration association that you want to get information about.</p>
        pub fn set_resolver_query_log_config_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .set_resolver_query_log_config_association_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResolverQueryLogConfigPolicy`.
    ///
    /// <p>Gets information about a query logging policy. A query logging policy specifies the Resolver query logging
    /// operations and resources that you want to allow another Amazon Web Services account to be able to use.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetResolverQueryLogConfigPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_resolver_query_log_config_policy_input::Builder,
    }
    impl<C, M, R> GetResolverQueryLogConfigPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetResolverQueryLogConfigPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResolverQueryLogConfigPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResolverQueryLogConfigPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetResolverQueryLogConfigPolicyInputOperationOutputAlias,
                crate::output::GetResolverQueryLogConfigPolicyOutput,
                crate::error::GetResolverQueryLogConfigPolicyError,
                crate::input::GetResolverQueryLogConfigPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the query logging configuration that you want to get the query logging policy for.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The ARN of the query logging configuration that you want to get the query logging policy for.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResolverRule`.
    ///
    /// <p>Gets information about a specified Resolver rule, such as the domain name that the rule forwards DNS queries for and the ID of the
    /// outbound Resolver endpoint that the rule is associated with.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetResolverRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_resolver_rule_input::Builder,
    }
    impl<C, M, R> GetResolverRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetResolverRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResolverRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResolverRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetResolverRuleInputOperationOutputAlias,
                crate::output::GetResolverRuleOutput,
                crate::error::GetResolverRuleError,
                crate::input::GetResolverRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Resolver rule that you want to get information about.</p>
        pub fn resolver_rule_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolver_rule_id(inp);
            self
        }
        /// <p>The ID of the Resolver rule that you want to get information about.</p>
        pub fn set_resolver_rule_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolver_rule_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResolverRuleAssociation`.
    ///
    /// <p>Gets information about an association between a specified Resolver rule and a VPC. You associate a Resolver rule and a VPC using
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverRule.html">AssociateResolverRule</a>. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetResolverRuleAssociation<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_resolver_rule_association_input::Builder,
    }
    impl<C, M, R> GetResolverRuleAssociation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetResolverRuleAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResolverRuleAssociationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResolverRuleAssociationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetResolverRuleAssociationInputOperationOutputAlias,
                crate::output::GetResolverRuleAssociationOutput,
                crate::error::GetResolverRuleAssociationError,
                crate::input::GetResolverRuleAssociationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Resolver rule association that you want to get information about.</p>
        pub fn resolver_rule_association_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolver_rule_association_id(inp);
            self
        }
        /// <p>The ID of the Resolver rule association that you want to get information about.</p>
        pub fn set_resolver_rule_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolver_rule_association_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResolverRulePolicy`.
    ///
    /// <p>Gets information about the Resolver rule policy for a specified rule. A Resolver rule policy includes the rule that you want to share
    /// with another account, the account that you want to share the rule with, and the Resolver operations that you want to allow the account to use. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetResolverRulePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_resolver_rule_policy_input::Builder,
    }
    impl<C, M, R> GetResolverRulePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetResolverRulePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResolverRulePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResolverRulePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetResolverRulePolicyInputOperationOutputAlias,
                crate::output::GetResolverRulePolicyOutput,
                crate::error::GetResolverRulePolicyError,
                crate::input::GetResolverRulePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Resolver rule that you want to get the Resolver rule policy for.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The ID of the Resolver rule that you want to get the Resolver rule policy for.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportFirewallDomains`.
    ///
    /// <p>Imports domain names from a file into a domain list, for use in a DNS firewall rule group. </p>
    /// <p>Each domain specification in your domain list must satisfy the following
    /// requirements: </p>
    /// <ul>
    /// <li>
    /// <p>It can optionally start with <code>*</code> (asterisk).</p>
    /// </li>
    /// <li>
    /// <p>With the exception of the optional starting asterisk, it must only contain
    /// the following characters: <code>A-Z</code>, <code>a-z</code>,
    /// <code>0-9</code>, <code>-</code> (hyphen).</p>
    /// </li>
    /// <li>
    /// <p>It must be from 1-255 characters in length. </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct ImportFirewallDomains<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::import_firewall_domains_input::Builder,
    }
    impl<C, M, R> ImportFirewallDomains<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ImportFirewallDomains`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportFirewallDomainsOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportFirewallDomainsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ImportFirewallDomainsInputOperationOutputAlias,
                crate::output::ImportFirewallDomainsOutput,
                crate::error::ImportFirewallDomainsError,
                crate::input::ImportFirewallDomainsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the domain list that you want to modify with the import operation.</p>
        pub fn firewall_domain_list_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_domain_list_id(inp);
            self
        }
        /// <p>The ID of the domain list that you want to modify with the import operation.</p>
        pub fn set_firewall_domain_list_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_domain_list_id(input);
            self
        }
        /// <p>What you want DNS Firewall to do with the domains that are listed in the file. This must be set to <code>REPLACE</code>, which updates the domain list to exactly match the list in the file. </p>
        pub fn operation(mut self, inp: crate::model::FirewallDomainImportOperation) -> Self {
            self.inner = self.inner.operation(inp);
            self
        }
        /// <p>What you want DNS Firewall to do with the domains that are listed in the file. This must be set to <code>REPLACE</code>, which updates the domain list to exactly match the list in the file. </p>
        pub fn set_operation(
            mut self,
            input: std::option::Option<crate::model::FirewallDomainImportOperation>,
        ) -> Self {
            self.inner = self.inner.set_operation(input);
            self
        }
        /// <p>The fully qualified URL or URI of the file stored in Amazon Simple Storage Service
        /// (Amazon S3) that contains the list of domains to import.</p>
        /// <p>The file must be in an S3 bucket that's in the same Region
        /// as your DNS Firewall. The file must be a text file and must contain a single domain per line.</p>
        pub fn domain_file_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_file_url(inp);
            self
        }
        /// <p>The fully qualified URL or URI of the file stored in Amazon Simple Storage Service
        /// (Amazon S3) that contains the list of domains to import.</p>
        /// <p>The file must be in an S3 bucket that's in the same Region
        /// as your DNS Firewall. The file must be a text file and must contain a single domain per line.</p>
        pub fn set_domain_file_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_domain_file_url(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFirewallConfigs`.
    ///
    /// <p>Retrieves the firewall configurations that you have defined. DNS Firewall uses the configurations to manage firewall behavior for your VPCs. </p>
    /// <p>A single call might return only a partial list of the configurations. For information, see <code>MaxResults</code>. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListFirewallConfigs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_firewall_configs_input::Builder,
    }
    impl<C, M, R> ListFirewallConfigs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFirewallConfigs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFirewallConfigsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFirewallConfigsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFirewallConfigsInputOperationOutputAlias,
                crate::output::ListFirewallConfigsOutput,
                crate::error::ListFirewallConfigsError,
                crate::input::ListFirewallConfigsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of objects that you want Resolver to return for this request. If more
        /// objects are available, in the response, Resolver provides a
        /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of objects that you want Resolver to return for this request. If more
        /// objects are available, in the response, Resolver provides a
        /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>For the first call to this list request, omit this value.</p>
        /// <p>When you request a list of objects, Resolver returns at most the number of objects
        /// specified in <code>MaxResults</code>. If more objects are available for retrieval,
        /// Resolver returns a <code>NextToken</code> value in the response. To retrieve the next
        /// batch of objects, use the token that was returned for the prior request in your next request.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>For the first call to this list request, omit this value.</p>
        /// <p>When you request a list of objects, Resolver returns at most the number of objects
        /// specified in <code>MaxResults</code>. If more objects are available for retrieval,
        /// Resolver returns a <code>NextToken</code> value in the response. To retrieve the next
        /// batch of objects, use the token that was returned for the prior request in your next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFirewallDomainLists`.
    ///
    /// <p>Retrieves the firewall domain lists that you have defined. For each firewall domain list, you can retrieve the domains that are defined for a list by calling <a>ListFirewallDomains</a>. </p>
    /// <p>A single call to this list operation might return only a partial list of the domain lists. For information, see <code>MaxResults</code>. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListFirewallDomainLists<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_firewall_domain_lists_input::Builder,
    }
    impl<C, M, R> ListFirewallDomainLists<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFirewallDomainLists`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFirewallDomainListsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFirewallDomainListsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFirewallDomainListsInputOperationOutputAlias,
                crate::output::ListFirewallDomainListsOutput,
                crate::error::ListFirewallDomainListsError,
                crate::input::ListFirewallDomainListsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of objects that you want Resolver to return for this request. If more
        /// objects are available, in the response, Resolver provides a
        /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of objects that you want Resolver to return for this request. If more
        /// objects are available, in the response, Resolver provides a
        /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>For the first call to this list request, omit this value.</p>
        /// <p>When you request a list of objects, Resolver returns at most the number of objects
        /// specified in <code>MaxResults</code>. If more objects are available for retrieval,
        /// Resolver returns a <code>NextToken</code> value in the response. To retrieve the next
        /// batch of objects, use the token that was returned for the prior request in your next request.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>For the first call to this list request, omit this value.</p>
        /// <p>When you request a list of objects, Resolver returns at most the number of objects
        /// specified in <code>MaxResults</code>. If more objects are available for retrieval,
        /// Resolver returns a <code>NextToken</code> value in the response. To retrieve the next
        /// batch of objects, use the token that was returned for the prior request in your next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFirewallDomains`.
    ///
    /// <p>Retrieves the domains that you have defined for the specified firewall domain list.  </p>
    /// <p>A single call might return only a partial list of the domains. For information, see <code>MaxResults</code>. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListFirewallDomains<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_firewall_domains_input::Builder,
    }
    impl<C, M, R> ListFirewallDomains<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFirewallDomains`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFirewallDomainsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFirewallDomainsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFirewallDomainsInputOperationOutputAlias,
                crate::output::ListFirewallDomainsOutput,
                crate::error::ListFirewallDomainsError,
                crate::input::ListFirewallDomainsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the domain list whose domains you want to retrieve. </p>
        pub fn firewall_domain_list_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_domain_list_id(inp);
            self
        }
        /// <p>The ID of the domain list whose domains you want to retrieve. </p>
        pub fn set_firewall_domain_list_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_domain_list_id(input);
            self
        }
        /// <p>The maximum number of objects that you want Resolver to return for this request. If more
        /// objects are available, in the response, Resolver provides a
        /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of objects that you want Resolver to return for this request. If more
        /// objects are available, in the response, Resolver provides a
        /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>For the first call to this list request, omit this value.</p>
        /// <p>When you request a list of objects, Resolver returns at most the number of objects
        /// specified in <code>MaxResults</code>. If more objects are available for retrieval,
        /// Resolver returns a <code>NextToken</code> value in the response. To retrieve the next
        /// batch of objects, use the token that was returned for the prior request in your next request.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>For the first call to this list request, omit this value.</p>
        /// <p>When you request a list of objects, Resolver returns at most the number of objects
        /// specified in <code>MaxResults</code>. If more objects are available for retrieval,
        /// Resolver returns a <code>NextToken</code> value in the response. To retrieve the next
        /// batch of objects, use the token that was returned for the prior request in your next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFirewallRuleGroupAssociations`.
    ///
    /// <p>Retrieves the firewall rule group associations that you have defined. Each association enables DNS filtering for a VPC with one rule group. </p>
    /// <p>A single call might return only a partial list of the associations. For information, see <code>MaxResults</code>. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListFirewallRuleGroupAssociations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_firewall_rule_group_associations_input::Builder,
    }
    impl<C, M, R> ListFirewallRuleGroupAssociations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFirewallRuleGroupAssociations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFirewallRuleGroupAssociationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFirewallRuleGroupAssociationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFirewallRuleGroupAssociationsInputOperationOutputAlias,
                crate::output::ListFirewallRuleGroupAssociationsOutput,
                crate::error::ListFirewallRuleGroupAssociationsError,
                crate::input::ListFirewallRuleGroupAssociationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the firewall rule group that you want to retrieve the associations
        /// for. Leave this blank to retrieve associations for any rule group. </p>
        pub fn firewall_rule_group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_rule_group_id(inp);
            self
        }
        /// <p>The unique identifier of the firewall rule group that you want to retrieve the associations
        /// for. Leave this blank to retrieve associations for any rule group. </p>
        pub fn set_firewall_rule_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_rule_group_id(input);
            self
        }
        /// <p>The unique identifier of the VPC that you want to retrieve the associations
        /// for. Leave this blank to retrieve associations for any VPC. </p>
        pub fn vpc_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_id(inp);
            self
        }
        /// <p>The unique identifier of the VPC that you want to retrieve the associations
        /// for. Leave this blank to retrieve associations for any VPC. </p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_id(input);
            self
        }
        /// <p>The setting that determines the processing order of the rule group among the rule
        /// groups that are associated with a single VPC. DNS Firewall filters VPC traffic starting
        /// from the rule group with the lowest numeric priority setting. </p>
        pub fn priority(mut self, inp: i32) -> Self {
            self.inner = self.inner.priority(inp);
            self
        }
        /// <p>The setting that determines the processing order of the rule group among the rule
        /// groups that are associated with a single VPC. DNS Firewall filters VPC traffic starting
        /// from the rule group with the lowest numeric priority setting. </p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_priority(input);
            self
        }
        /// <p>The association <code>Status</code> setting that you want DNS Firewall to filter on for the list. If you don't specify this, then DNS Firewall returns all associations, regardless of status.</p>
        pub fn status(mut self, inp: crate::model::FirewallRuleGroupAssociationStatus) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p>The association <code>Status</code> setting that you want DNS Firewall to filter on for the list. If you don't specify this, then DNS Firewall returns all associations, regardless of status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::FirewallRuleGroupAssociationStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>The maximum number of objects that you want Resolver to return for this request. If more
        /// objects are available, in the response, Resolver provides a
        /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of objects that you want Resolver to return for this request. If more
        /// objects are available, in the response, Resolver provides a
        /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>For the first call to this list request, omit this value.</p>
        /// <p>When you request a list of objects, Resolver returns at most the number of objects
        /// specified in <code>MaxResults</code>. If more objects are available for retrieval,
        /// Resolver returns a <code>NextToken</code> value in the response. To retrieve the next
        /// batch of objects, use the token that was returned for the prior request in your next request.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>For the first call to this list request, omit this value.</p>
        /// <p>When you request a list of objects, Resolver returns at most the number of objects
        /// specified in <code>MaxResults</code>. If more objects are available for retrieval,
        /// Resolver returns a <code>NextToken</code> value in the response. To retrieve the next
        /// batch of objects, use the token that was returned for the prior request in your next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFirewallRuleGroups`.
    ///
    /// <p>Retrieves the minimal high-level information for the rule groups that you have defined.  </p>
    /// <p>A single call might return only a partial list of the rule groups. For information, see <code>MaxResults</code>. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListFirewallRuleGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_firewall_rule_groups_input::Builder,
    }
    impl<C, M, R> ListFirewallRuleGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFirewallRuleGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFirewallRuleGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFirewallRuleGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFirewallRuleGroupsInputOperationOutputAlias,
                crate::output::ListFirewallRuleGroupsOutput,
                crate::error::ListFirewallRuleGroupsError,
                crate::input::ListFirewallRuleGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of objects that you want Resolver to return for this request. If more
        /// objects are available, in the response, Resolver provides a
        /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of objects that you want Resolver to return for this request. If more
        /// objects are available, in the response, Resolver provides a
        /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>For the first call to this list request, omit this value.</p>
        /// <p>When you request a list of objects, Resolver returns at most the number of objects
        /// specified in <code>MaxResults</code>. If more objects are available for retrieval,
        /// Resolver returns a <code>NextToken</code> value in the response. To retrieve the next
        /// batch of objects, use the token that was returned for the prior request in your next request.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>For the first call to this list request, omit this value.</p>
        /// <p>When you request a list of objects, Resolver returns at most the number of objects
        /// specified in <code>MaxResults</code>. If more objects are available for retrieval,
        /// Resolver returns a <code>NextToken</code> value in the response. To retrieve the next
        /// batch of objects, use the token that was returned for the prior request in your next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFirewallRules`.
    ///
    /// <p>Retrieves the firewall rules that you have defined for the specified firewall rule group. DNS Firewall uses the rules in a rule group to filter DNS network traffic for a VPC. </p>
    /// <p>A single call might return only a partial list of the rules. For information, see <code>MaxResults</code>. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListFirewallRules<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_firewall_rules_input::Builder,
    }
    impl<C, M, R> ListFirewallRules<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFirewallRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFirewallRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFirewallRulesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFirewallRulesInputOperationOutputAlias,
                crate::output::ListFirewallRulesOutput,
                crate::error::ListFirewallRulesError,
                crate::input::ListFirewallRulesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the firewall rule group that you want to retrieve the rules for. </p>
        pub fn firewall_rule_group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_rule_group_id(inp);
            self
        }
        /// <p>The unique identifier of the firewall rule group that you want to retrieve the rules for. </p>
        pub fn set_firewall_rule_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_rule_group_id(input);
            self
        }
        /// <p>Optional additional filter for the rules to retrieve.</p>
        /// <p>The setting that determines the processing order of the rules in a rule group. DNS Firewall
        /// processes the rules in a rule group by order of priority, starting from the lowest setting.</p>
        pub fn priority(mut self, inp: i32) -> Self {
            self.inner = self.inner.priority(inp);
            self
        }
        /// <p>Optional additional filter for the rules to retrieve.</p>
        /// <p>The setting that determines the processing order of the rules in a rule group. DNS Firewall
        /// processes the rules in a rule group by order of priority, starting from the lowest setting.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_priority(input);
            self
        }
        /// <p>Optional additional filter for the rules to retrieve.</p>
        /// <p>The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALLOW</code> - Permit the request to go through.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALERT</code> - Permit the request to go through but send an alert to the logs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BLOCK</code> - Disallow the request. If this is specified, additional handling details are provided in the rule's <code>BlockResponse</code> setting. </p>
        /// </li>
        /// </ul>
        pub fn action(mut self, inp: crate::model::Action) -> Self {
            self.inner = self.inner.action(inp);
            self
        }
        /// <p>Optional additional filter for the rules to retrieve.</p>
        /// <p>The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALLOW</code> - Permit the request to go through.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALERT</code> - Permit the request to go through but send an alert to the logs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BLOCK</code> - Disallow the request. If this is specified, additional handling details are provided in the rule's <code>BlockResponse</code> setting. </p>
        /// </li>
        /// </ul>
        pub fn set_action(mut self, input: std::option::Option<crate::model::Action>) -> Self {
            self.inner = self.inner.set_action(input);
            self
        }
        /// <p>The maximum number of objects that you want Resolver to return for this request. If more
        /// objects are available, in the response, Resolver provides a
        /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of objects that you want Resolver to return for this request. If more
        /// objects are available, in the response, Resolver provides a
        /// <code>NextToken</code> value that you can use in a subsequent call to get the next batch of objects.</p>
        /// <p>If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>For the first call to this list request, omit this value.</p>
        /// <p>When you request a list of objects, Resolver returns at most the number of objects
        /// specified in <code>MaxResults</code>. If more objects are available for retrieval,
        /// Resolver returns a <code>NextToken</code> value in the response. To retrieve the next
        /// batch of objects, use the token that was returned for the prior request in your next request.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>For the first call to this list request, omit this value.</p>
        /// <p>When you request a list of objects, Resolver returns at most the number of objects
        /// specified in <code>MaxResults</code>. If more objects are available for retrieval,
        /// Resolver returns a <code>NextToken</code> value in the response. To retrieve the next
        /// batch of objects, use the token that was returned for the prior request in your next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResolverConfigs`.
    ///
    /// <p>Retrieves the Resolver configurations that you have defined.
    /// Route 53 Resolver uses the configurations to manage DNS resolution behavior for your VPCs.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListResolverConfigs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_resolver_configs_input::Builder,
    }
    impl<C, M, R> ListResolverConfigs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListResolverConfigs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResolverConfigsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResolverConfigsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListResolverConfigsInputOperationOutputAlias,
                crate::output::ListResolverConfigsOutput,
                crate::error::ListResolverConfigsError,
                crate::input::ListResolverConfigsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of Resolver configurations that you want to return in the response to
        /// a <code>ListResolverConfigs</code> request. If you don't specify a value for <code>MaxResults</code>,
        /// up to 100 Resolver configurations are returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of Resolver configurations that you want to return in the response to
        /// a <code>ListResolverConfigs</code> request. If you don't specify a value for <code>MaxResults</code>,
        /// up to 100 Resolver configurations are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>(Optional) If the current Amazon Web Services account has more than <code>MaxResults</code> Resolver configurations, use
        /// <code>NextToken</code> to get the second and subsequent pages of results.</p>
        /// <p>For the first <code>ListResolverConfigs</code> request, omit this value.</p>
        /// <p>For the second and subsequent requests, get the value of <code>NextToken</code> from the previous response and
        /// specify that value for <code>NextToken</code> in the request.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>(Optional) If the current Amazon Web Services account has more than <code>MaxResults</code> Resolver configurations, use
        /// <code>NextToken</code> to get the second and subsequent pages of results.</p>
        /// <p>For the first <code>ListResolverConfigs</code> request, omit this value.</p>
        /// <p>For the second and subsequent requests, get the value of <code>NextToken</code> from the previous response and
        /// specify that value for <code>NextToken</code> in the request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResolverDnssecConfigs`.
    ///
    /// <p>Lists the configurations for DNSSEC validation that are associated with the current Amazon Web Services account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListResolverDnssecConfigs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_resolver_dnssec_configs_input::Builder,
    }
    impl<C, M, R> ListResolverDnssecConfigs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListResolverDnssecConfigs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResolverDnssecConfigsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResolverDnssecConfigsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListResolverDnssecConfigsInputOperationOutputAlias,
                crate::output::ListResolverDnssecConfigsOutput,
                crate::error::ListResolverDnssecConfigsError,
                crate::input::ListResolverDnssecConfigsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// <i>Optional</i>: An integer that specifies the maximum number of DNSSEC configuration results that you want Amazon Route 53 to return.
        /// If you don't specify a value for <code>MaxResults</code>, Route 53 returns up to 100 configuration per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>
        /// <i>Optional</i>: An integer that specifies the maximum number of DNSSEC configuration results that you want Amazon Route 53 to return.
        /// If you don't specify a value for <code>MaxResults</code>, Route 53 returns up to 100 configuration per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>(Optional) If the current Amazon Web Services account has more than <code>MaxResults</code> DNSSEC configurations, use <code>NextToken</code>
        /// to get the second and subsequent pages of results.</p>
        /// <p>For the first <code>ListResolverDnssecConfigs</code> request, omit this value.</p>
        /// <p>For the second and subsequent requests, get the value of <code>NextToken</code> from the previous response and specify that value
        /// for <code>NextToken</code> in the request.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>(Optional) If the current Amazon Web Services account has more than <code>MaxResults</code> DNSSEC configurations, use <code>NextToken</code>
        /// to get the second and subsequent pages of results.</p>
        /// <p>For the first <code>ListResolverDnssecConfigs</code> request, omit this value.</p>
        /// <p>For the second and subsequent requests, get the value of <code>NextToken</code> from the previous response and specify that value
        /// for <code>NextToken</code> in the request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An optional specification to return a subset of objects.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>An optional specification to return a subset of objects.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResolverEndpointIpAddresses`.
    ///
    /// <p>Gets the IP addresses for a specified Resolver endpoint.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListResolverEndpointIpAddresses<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_resolver_endpoint_ip_addresses_input::Builder,
    }
    impl<C, M, R> ListResolverEndpointIpAddresses<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListResolverEndpointIpAddresses`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResolverEndpointIpAddressesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResolverEndpointIpAddressesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListResolverEndpointIpAddressesInputOperationOutputAlias,
                crate::output::ListResolverEndpointIpAddressesOutput,
                crate::error::ListResolverEndpointIpAddressesError,
                crate::input::ListResolverEndpointIpAddressesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Resolver endpoint that you want to get IP addresses for.</p>
        pub fn resolver_endpoint_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolver_endpoint_id(inp);
            self
        }
        /// <p>The ID of the Resolver endpoint that you want to get IP addresses for.</p>
        pub fn set_resolver_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolver_endpoint_id(input);
            self
        }
        /// <p>The maximum number of IP addresses that you want to return in the response to a <code>ListResolverEndpointIpAddresses</code> request.
        /// If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 IP addresses. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of IP addresses that you want to return in the response to a <code>ListResolverEndpointIpAddresses</code> request.
        /// If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 IP addresses. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>For the first <code>ListResolverEndpointIpAddresses</code> request, omit this value.</p>
        /// <p>If the specified Resolver endpoint has more than <code>MaxResults</code> IP addresses, you can submit another
        /// <code>ListResolverEndpointIpAddresses</code> request to get the next group of IP addresses. In the next request, specify the value of
        /// <code>NextToken</code> from the previous response. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>For the first <code>ListResolverEndpointIpAddresses</code> request, omit this value.</p>
        /// <p>If the specified Resolver endpoint has more than <code>MaxResults</code> IP addresses, you can submit another
        /// <code>ListResolverEndpointIpAddresses</code> request to get the next group of IP addresses. In the next request, specify the value of
        /// <code>NextToken</code> from the previous response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResolverEndpoints`.
    ///
    /// <p>Lists all the Resolver endpoints that were created using the current Amazon Web Services account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListResolverEndpoints<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_resolver_endpoints_input::Builder,
    }
    impl<C, M, R> ListResolverEndpoints<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListResolverEndpoints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResolverEndpointsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResolverEndpointsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListResolverEndpointsInputOperationOutputAlias,
                crate::output::ListResolverEndpointsOutput,
                crate::error::ListResolverEndpointsError,
                crate::input::ListResolverEndpointsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of Resolver endpoints that you want to return in the response to a <code>ListResolverEndpoints</code> request.
        /// If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 Resolver endpoints. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of Resolver endpoints that you want to return in the response to a <code>ListResolverEndpoints</code> request.
        /// If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 Resolver endpoints. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>For the first <code>ListResolverEndpoints</code> request, omit this value.</p>
        /// <p>If you have more than <code>MaxResults</code> Resolver endpoints, you can submit another <code>ListResolverEndpoints</code> request
        /// to get the next group of Resolver endpoints. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>For the first <code>ListResolverEndpoints</code> request, omit this value.</p>
        /// <p>If you have more than <code>MaxResults</code> Resolver endpoints, you can submit another <code>ListResolverEndpoints</code> request
        /// to get the next group of Resolver endpoints. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An optional specification to return a subset of Resolver endpoints, such as all inbound Resolver endpoints.</p>
        /// <note>
        /// <p>If you submit a second or subsequent <code>ListResolverEndpoints</code> request and specify the <code>NextToken</code> parameter,
        /// you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>
        /// </note>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>An optional specification to return a subset of Resolver endpoints, such as all inbound Resolver endpoints.</p>
        /// <note>
        /// <p>If you submit a second or subsequent <code>ListResolverEndpoints</code> request and specify the <code>NextToken</code> parameter,
        /// you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>
        /// </note>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResolverQueryLogConfigAssociations`.
    ///
    /// <p>Lists information about associations between Amazon VPCs and query logging configurations.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListResolverQueryLogConfigAssociations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_resolver_query_log_config_associations_input::Builder,
    }
    impl<C, M, R> ListResolverQueryLogConfigAssociations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListResolverQueryLogConfigAssociations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResolverQueryLogConfigAssociationsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListResolverQueryLogConfigAssociationsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListResolverQueryLogConfigAssociationsInputOperationOutputAlias,
                crate::output::ListResolverQueryLogConfigAssociationsOutput,
                crate::error::ListResolverQueryLogConfigAssociationsError,
                crate::input::ListResolverQueryLogConfigAssociationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of query logging associations that you want to return in the response to a <code>ListResolverQueryLogConfigAssociations</code> request.
        /// If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 query logging associations. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of query logging associations that you want to return in the response to a <code>ListResolverQueryLogConfigAssociations</code> request.
        /// If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 query logging associations. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>For the first <code>ListResolverQueryLogConfigAssociations</code> request, omit this value.</p>
        /// <p>If there are more than <code>MaxResults</code> query logging associations that match the values that you specify for <code>Filters</code>,
        /// you can submit another <code>ListResolverQueryLogConfigAssociations</code> request to get the next group of associations. In the next request, specify the value of
        /// <code>NextToken</code> from the previous response. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>For the first <code>ListResolverQueryLogConfigAssociations</code> request, omit this value.</p>
        /// <p>If there are more than <code>MaxResults</code> query logging associations that match the values that you specify for <code>Filters</code>,
        /// you can submit another <code>ListResolverQueryLogConfigAssociations</code> request to get the next group of associations. In the next request, specify the value of
        /// <code>NextToken</code> from the previous response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An optional specification to return a subset of query logging associations.</p>
        /// <note>
        /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigAssociations</code> request and specify the <code>NextToken</code> parameter,
        /// you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>
        /// </note>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>An optional specification to return a subset of query logging associations.</p>
        /// <note>
        /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigAssociations</code> request and specify the <code>NextToken</code> parameter,
        /// you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>
        /// </note>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The element that you want Resolver to sort query logging associations by. </p>
        /// <note>
        /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigAssociations</code> request and specify the <code>NextToken</code> parameter,
        /// you must use the same value for <code>SortBy</code>, if any, as in the previous request.</p>
        /// </note>
        ///
        /// <p>Valid values include the following elements:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CreationTime</code>: The ID of the query logging association.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Error</code>: If the value of <code>Status</code> is <code>FAILED</code>, the value of <code>Error</code>
        /// indicates the cause: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DESTINATION_NOT_FOUND</code>: The specified destination (for example, an Amazon S3 bucket) was deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACCESS_DENIED</code>: Permissions don't allow sending logs to the destination.</p>
        /// </li>
        /// </ul>
        /// <p>If <code>Status</code> is a value other than <code>FAILED</code>, <code>ERROR</code> is null.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Id</code>: The ID of the query logging association</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ResolverQueryLogConfigId</code>: The ID of the query logging configuration</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ResourceId</code>: The ID of the VPC that is associated with the query logging configuration</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Status</code>: The current status of the configuration. Valid values include the following:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATING</code>: Resolver is creating an association between an Amazon VPC and a query logging configuration.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATED</code>: The association between an Amazon VPC and a query logging configuration
        /// was successfully created. Resolver is logging queries that originate in the specified VPC.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETING</code>: Resolver is deleting this query logging association.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code>: Resolver either couldn't create or couldn't delete the query logging association.
        /// Here are two common causes:</p>
        /// <ul>
        /// <li>
        /// <p>The specified destination (for example, an Amazon S3 bucket) was deleted.</p>
        /// </li>
        /// <li>
        /// <p>Permissions don't allow sending logs to the destination.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn sort_by(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sort_by(inp);
            self
        }
        /// <p>The element that you want Resolver to sort query logging associations by. </p>
        /// <note>
        /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigAssociations</code> request and specify the <code>NextToken</code> parameter,
        /// you must use the same value for <code>SortBy</code>, if any, as in the previous request.</p>
        /// </note>
        ///
        /// <p>Valid values include the following elements:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CreationTime</code>: The ID of the query logging association.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Error</code>: If the value of <code>Status</code> is <code>FAILED</code>, the value of <code>Error</code>
        /// indicates the cause: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DESTINATION_NOT_FOUND</code>: The specified destination (for example, an Amazon S3 bucket) was deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACCESS_DENIED</code>: Permissions don't allow sending logs to the destination.</p>
        /// </li>
        /// </ul>
        /// <p>If <code>Status</code> is a value other than <code>FAILED</code>, <code>ERROR</code> is null.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Id</code>: The ID of the query logging association</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ResolverQueryLogConfigId</code>: The ID of the query logging configuration</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ResourceId</code>: The ID of the VPC that is associated with the query logging configuration</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Status</code>: The current status of the configuration. Valid values include the following:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATING</code>: Resolver is creating an association between an Amazon VPC and a query logging configuration.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATED</code>: The association between an Amazon VPC and a query logging configuration
        /// was successfully created. Resolver is logging queries that originate in the specified VPC.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETING</code>: Resolver is deleting this query logging association.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code>: Resolver either couldn't create or couldn't delete the query logging association.
        /// Here are two common causes:</p>
        /// <ul>
        /// <li>
        /// <p>The specified destination (for example, an Amazon S3 bucket) was deleted.</p>
        /// </li>
        /// <li>
        /// <p>Permissions don't allow sending logs to the destination.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn set_sort_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>If you specified a value for <code>SortBy</code>, the order that you want query logging associations to be listed in,
        /// <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
        /// <note>
        /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigAssociations</code> request and specify the <code>NextToken</code> parameter,
        /// you must use the same value for <code>SortOrder</code>, if any, as in the previous request.</p>
        /// </note>
        pub fn sort_order(mut self, inp: crate::model::SortOrder) -> Self {
            self.inner = self.inner.sort_order(inp);
            self
        }
        /// <p>If you specified a value for <code>SortBy</code>, the order that you want query logging associations to be listed in,
        /// <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
        /// <note>
        /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigAssociations</code> request and specify the <code>NextToken</code> parameter,
        /// you must use the same value for <code>SortOrder</code>, if any, as in the previous request.</p>
        /// </note>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResolverQueryLogConfigs`.
    ///
    /// <p>Lists information about the specified query logging configurations. Each configuration defines where you want Resolver to save
    /// DNS query logs and specifies the VPCs that you want to log queries for.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListResolverQueryLogConfigs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_resolver_query_log_configs_input::Builder,
    }
    impl<C, M, R> ListResolverQueryLogConfigs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListResolverQueryLogConfigs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResolverQueryLogConfigsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResolverQueryLogConfigsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListResolverQueryLogConfigsInputOperationOutputAlias,
                crate::output::ListResolverQueryLogConfigsOutput,
                crate::error::ListResolverQueryLogConfigsError,
                crate::input::ListResolverQueryLogConfigsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of query logging configurations that you want to return in the response to a <code>ListResolverQueryLogConfigs</code> request.
        /// If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 query logging configurations. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of query logging configurations that you want to return in the response to a <code>ListResolverQueryLogConfigs</code> request.
        /// If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 query logging configurations. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>For the first <code>ListResolverQueryLogConfigs</code> request, omit this value.</p>
        /// <p>If there are more than <code>MaxResults</code> query logging configurations that match the values that you specify for <code>Filters</code>,
        /// you can submit another <code>ListResolverQueryLogConfigs</code> request to get the next group of configurations. In the next request, specify the value of
        /// <code>NextToken</code> from the previous response. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>For the first <code>ListResolverQueryLogConfigs</code> request, omit this value.</p>
        /// <p>If there are more than <code>MaxResults</code> query logging configurations that match the values that you specify for <code>Filters</code>,
        /// you can submit another <code>ListResolverQueryLogConfigs</code> request to get the next group of configurations. In the next request, specify the value of
        /// <code>NextToken</code> from the previous response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An optional specification to return a subset of query logging configurations.</p>
        /// <note>
        /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the <code>NextToken</code> parameter,
        /// you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>
        /// </note>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>An optional specification to return a subset of query logging configurations.</p>
        /// <note>
        /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the <code>NextToken</code> parameter,
        /// you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>
        /// </note>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The element that you want Resolver to sort query logging configurations by. </p>
        /// <note>
        /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the <code>NextToken</code> parameter,
        /// you must use the same value for <code>SortBy</code>, if any, as in the previous request.</p>
        /// </note>
        ///
        /// <p>Valid values include the following elements:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Arn</code>: The ARN of the query logging configuration</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AssociationCount</code>: The number of VPCs that are associated with the specified configuration </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CreationTime</code>: The date and time that Resolver returned when the configuration was created</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CreatorRequestId</code>: The value that was specified for <code>CreatorRequestId</code> when the configuration was created</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DestinationArn</code>: The location that logs are sent to</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Id</code>: The ID of the configuration</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Name</code>: The name of the configuration</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OwnerId</code>: The Amazon Web Services account number of the account that created the configuration</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ShareStatus</code>: Whether the configuration is shared with other Amazon Web Services accounts or shared with the current account by
        /// another Amazon Web Services account. Sharing is configured through Resource Access Manager (RAM).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Status</code>: The current status of the configuration. Valid values include the following:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATING</code>: Resolver is creating the query logging configuration.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATED</code>: The query logging configuration was successfully created.
        /// Resolver is logging queries that originate in the specified VPC.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETING</code>: Resolver is deleting this query logging configuration.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code>: Resolver either couldn't create or couldn't delete the query logging configuration.
        /// Here are two common causes:</p>
        /// <ul>
        /// <li>
        /// <p>The specified destination (for example, an Amazon S3 bucket) was deleted.</p>
        /// </li>
        /// <li>
        /// <p>Permissions don't allow sending logs to the destination.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn sort_by(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sort_by(inp);
            self
        }
        /// <p>The element that you want Resolver to sort query logging configurations by. </p>
        /// <note>
        /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the <code>NextToken</code> parameter,
        /// you must use the same value for <code>SortBy</code>, if any, as in the previous request.</p>
        /// </note>
        ///
        /// <p>Valid values include the following elements:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Arn</code>: The ARN of the query logging configuration</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AssociationCount</code>: The number of VPCs that are associated with the specified configuration </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CreationTime</code>: The date and time that Resolver returned when the configuration was created</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CreatorRequestId</code>: The value that was specified for <code>CreatorRequestId</code> when the configuration was created</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DestinationArn</code>: The location that logs are sent to</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Id</code>: The ID of the configuration</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Name</code>: The name of the configuration</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OwnerId</code>: The Amazon Web Services account number of the account that created the configuration</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ShareStatus</code>: Whether the configuration is shared with other Amazon Web Services accounts or shared with the current account by
        /// another Amazon Web Services account. Sharing is configured through Resource Access Manager (RAM).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Status</code>: The current status of the configuration. Valid values include the following:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATING</code>: Resolver is creating the query logging configuration.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATED</code>: The query logging configuration was successfully created.
        /// Resolver is logging queries that originate in the specified VPC.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETING</code>: Resolver is deleting this query logging configuration.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code>: Resolver either couldn't create or couldn't delete the query logging configuration.
        /// Here are two common causes:</p>
        /// <ul>
        /// <li>
        /// <p>The specified destination (for example, an Amazon S3 bucket) was deleted.</p>
        /// </li>
        /// <li>
        /// <p>Permissions don't allow sending logs to the destination.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn set_sort_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>If you specified a value for <code>SortBy</code>, the order that you want query logging configurations to be listed in,
        /// <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
        /// <note>
        /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the <code>NextToken</code> parameter,
        /// you must use the same value for <code>SortOrder</code>, if any, as in the previous request.</p>
        /// </note>
        pub fn sort_order(mut self, inp: crate::model::SortOrder) -> Self {
            self.inner = self.inner.sort_order(inp);
            self
        }
        /// <p>If you specified a value for <code>SortBy</code>, the order that you want query logging configurations to be listed in,
        /// <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
        /// <note>
        /// <p>If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the <code>NextToken</code> parameter,
        /// you must use the same value for <code>SortOrder</code>, if any, as in the previous request.</p>
        /// </note>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResolverRuleAssociations`.
    ///
    /// <p>Lists the associations that were created between Resolver rules and VPCs using the current Amazon Web Services account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListResolverRuleAssociations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_resolver_rule_associations_input::Builder,
    }
    impl<C, M, R> ListResolverRuleAssociations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListResolverRuleAssociations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResolverRuleAssociationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResolverRuleAssociationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListResolverRuleAssociationsInputOperationOutputAlias,
                crate::output::ListResolverRuleAssociationsOutput,
                crate::error::ListResolverRuleAssociationsError,
                crate::input::ListResolverRuleAssociationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of rule associations that you want to return in the response to a <code>ListResolverRuleAssociations</code> request.
        /// If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 rule associations. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of rule associations that you want to return in the response to a <code>ListResolverRuleAssociations</code> request.
        /// If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 rule associations. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>For the first <code>ListResolverRuleAssociation</code> request, omit this value.</p>
        /// <p>If you have more than <code>MaxResults</code> rule associations, you can submit another <code>ListResolverRuleAssociation</code> request
        /// to get the next group of rule associations. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>For the first <code>ListResolverRuleAssociation</code> request, omit this value.</p>
        /// <p>If you have more than <code>MaxResults</code> rule associations, you can submit another <code>ListResolverRuleAssociation</code> request
        /// to get the next group of rule associations. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An optional specification to return a subset of Resolver rules, such as Resolver rules that are associated with the same VPC ID.</p>
        /// <note>
        /// <p>If you submit a second or subsequent <code>ListResolverRuleAssociations</code> request and specify the <code>NextToken</code> parameter,
        /// you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>
        /// </note>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>An optional specification to return a subset of Resolver rules, such as Resolver rules that are associated with the same VPC ID.</p>
        /// <note>
        /// <p>If you submit a second or subsequent <code>ListResolverRuleAssociations</code> request and specify the <code>NextToken</code> parameter,
        /// you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>
        /// </note>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResolverRules`.
    ///
    /// <p>Lists the Resolver rules that were created using the current Amazon Web Services account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListResolverRules<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_resolver_rules_input::Builder,
    }
    impl<C, M, R> ListResolverRules<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListResolverRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResolverRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResolverRulesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListResolverRulesInputOperationOutputAlias,
                crate::output::ListResolverRulesOutput,
                crate::error::ListResolverRulesError,
                crate::input::ListResolverRulesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of Resolver rules that you want to return in the response to a <code>ListResolverRules</code> request.
        /// If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 Resolver rules.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of Resolver rules that you want to return in the response to a <code>ListResolverRules</code> request.
        /// If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 Resolver rules.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>For the first <code>ListResolverRules</code> request, omit this value.</p>
        /// <p>If you have more than <code>MaxResults</code> Resolver rules, you can submit another <code>ListResolverRules</code> request
        /// to get the next group of Resolver rules. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>For the first <code>ListResolverRules</code> request, omit this value.</p>
        /// <p>If you have more than <code>MaxResults</code> Resolver rules, you can submit another <code>ListResolverRules</code> request
        /// to get the next group of Resolver rules. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>An optional specification to return a subset of Resolver rules, such as all Resolver rules that are associated with the same Resolver endpoint.</p>
        /// <note>
        /// <p>If you submit a second or subsequent <code>ListResolverRules</code> request and specify the <code>NextToken</code> parameter,
        /// you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>
        /// </note>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>An optional specification to return a subset of Resolver rules, such as all Resolver rules that are associated with the same Resolver endpoint.</p>
        /// <note>
        /// <p>If you submit a second or subsequent <code>ListResolverRules</code> request and specify the <code>NextToken</code> parameter,
        /// you must use the same values for <code>Filters</code>, if any, as in the previous request.</p>
        /// </note>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags that you associated with the specified resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the resource that you want to list tags for.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the resource that you want to list tags for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The maximum number of tags that you want to return in the response to a <code>ListTagsForResource</code> request.
        /// If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 tags.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of tags that you want to return in the response to a <code>ListTagsForResource</code> request.
        /// If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 tags.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>For the first <code>ListTagsForResource</code> request, omit this value.</p>
        /// <p>If you have more than <code>MaxResults</code> tags, you can submit another <code>ListTagsForResource</code> request
        /// to get the next group of tags for the resource. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>For the first <code>ListTagsForResource</code> request, omit this value.</p>
        /// <p>If you have more than <code>MaxResults</code> tags, you can submit another <code>ListTagsForResource</code> request
        /// to get the next group of tags for the resource. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutFirewallRuleGroupPolicy`.
    ///
    /// <p>Attaches an Identity and Access Management (Amazon Web Services IAM) policy for sharing the rule
    /// group. You can use the policy to share the rule group using Resource Access Manager
    /// (RAM). </p>
    #[derive(std::fmt::Debug)]
    pub struct PutFirewallRuleGroupPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_firewall_rule_group_policy_input::Builder,
    }
    impl<C, M, R> PutFirewallRuleGroupPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutFirewallRuleGroupPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutFirewallRuleGroupPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutFirewallRuleGroupPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutFirewallRuleGroupPolicyInputOperationOutputAlias,
                crate::output::PutFirewallRuleGroupPolicyOutput,
                crate::error::PutFirewallRuleGroupPolicyError,
                crate::input::PutFirewallRuleGroupPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN (Amazon Resource Name) for the rule group that you want to share.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The ARN (Amazon Resource Name) for the rule group that you want to share.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>The Identity and Access Management (Amazon Web Services IAM) policy to attach to the rule group.</p>
        pub fn firewall_rule_group_policy(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_rule_group_policy(inp);
            self
        }
        /// <p>The Identity and Access Management (Amazon Web Services IAM) policy to attach to the rule group.</p>
        pub fn set_firewall_rule_group_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_rule_group_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutResolverQueryLogConfigPolicy`.
    ///
    /// <p>Specifies an Amazon Web Services account that you want to share a query logging configuration with, the query logging configuration that you want to share,
    /// and the operations that you want the account to be able to perform on the configuration.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutResolverQueryLogConfigPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_resolver_query_log_config_policy_input::Builder,
    }
    impl<C, M, R> PutResolverQueryLogConfigPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutResolverQueryLogConfigPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutResolverQueryLogConfigPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutResolverQueryLogConfigPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutResolverQueryLogConfigPolicyInputOperationOutputAlias,
                crate::output::PutResolverQueryLogConfigPolicyOutput,
                crate::error::PutResolverQueryLogConfigPolicyError,
                crate::input::PutResolverQueryLogConfigPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the account that you want to share rules with.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the account that you want to share rules with.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>An Identity and Access Management policy statement that lists the query logging configurations that you want to share with another Amazon Web Services account
        /// and the operations that you want the account to be able to perform. You can specify the following operations in the <code>Actions</code> section
        /// of the statement:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>route53resolver:AssociateResolverQueryLogConfig</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>route53resolver:DisassociateResolverQueryLogConfig</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>route53resolver:ListResolverQueryLogConfigAssociations</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>route53resolver:ListResolverQueryLogConfigs</code>
        /// </p>
        /// </li>
        /// </ul>
        ///
        /// <p>In the <code>Resource</code> section of the statement, you specify the ARNs for the query logging configurations that you want to share
        /// with the account that you specified in <code>Arn</code>. </p>
        pub fn resolver_query_log_config_policy(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.resolver_query_log_config_policy(inp);
            self
        }
        /// <p>An Identity and Access Management policy statement that lists the query logging configurations that you want to share with another Amazon Web Services account
        /// and the operations that you want the account to be able to perform. You can specify the following operations in the <code>Actions</code> section
        /// of the statement:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>route53resolver:AssociateResolverQueryLogConfig</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>route53resolver:DisassociateResolverQueryLogConfig</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>route53resolver:ListResolverQueryLogConfigAssociations</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>route53resolver:ListResolverQueryLogConfigs</code>
        /// </p>
        /// </li>
        /// </ul>
        ///
        /// <p>In the <code>Resource</code> section of the statement, you specify the ARNs for the query logging configurations that you want to share
        /// with the account that you specified in <code>Arn</code>. </p>
        pub fn set_resolver_query_log_config_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolver_query_log_config_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutResolverRulePolicy`.
    ///
    /// <p>Specifies an Amazon Web Services rule that you want to share with another account, the account that you want to share the rule with,
    /// and the operations that you want the account to be able to perform on the rule.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutResolverRulePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_resolver_rule_policy_input::Builder,
    }
    impl<C, M, R> PutResolverRulePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutResolverRulePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutResolverRulePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutResolverRulePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutResolverRulePolicyInputOperationOutputAlias,
                crate::output::PutResolverRulePolicyOutput,
                crate::error::PutResolverRulePolicyError,
                crate::input::PutResolverRulePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the rule that you want to share with another account.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the rule that you want to share with another account.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>An Identity and Access Management policy statement that lists the rules that you want to share with another Amazon Web Services account and the operations that you want the account
        /// to be able to perform. You can specify the following operations in the <code>Action</code> section of the statement:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>route53resolver:GetResolverRule</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>route53resolver:AssociateResolverRule</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>route53resolver:DisassociateResolverRule</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>route53resolver:ListResolverRules</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>route53resolver:ListResolverRuleAssociations</code>
        /// </p>
        /// </li>
        /// </ul>
        ///
        /// <p>In the <code>Resource</code> section of the statement, specify the ARN for the rule that you want to share with another account. Specify the same ARN
        /// that you specified in <code>Arn</code>.</p>
        pub fn resolver_rule_policy(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolver_rule_policy(inp);
            self
        }
        /// <p>An Identity and Access Management policy statement that lists the rules that you want to share with another Amazon Web Services account and the operations that you want the account
        /// to be able to perform. You can specify the following operations in the <code>Action</code> section of the statement:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>route53resolver:GetResolverRule</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>route53resolver:AssociateResolverRule</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>route53resolver:DisassociateResolverRule</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>route53resolver:ListResolverRules</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>route53resolver:ListResolverRuleAssociations</code>
        /// </p>
        /// </li>
        /// </ul>
        ///
        /// <p>In the <code>Resource</code> section of the statement, specify the ARN for the rule that you want to share with another account. Specify the same ARN
        /// that you specified in <code>Arn</code>.</p>
        pub fn set_resolver_rule_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolver_rule_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds one or more tags to a specified resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the resource that you want to add tags to. To get the ARN for a resource, use the applicable
        /// <code>Get</code> or <code>List</code> command: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html">GetResolverEndpoint</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRule.html">GetResolverRule</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRuleAssociation.html">GetResolverRuleAssociation</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html">ListResolverEndpoints</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html">ListResolverRuleAssociations</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html">ListResolverRules</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the resource that you want to add tags to. To get the ARN for a resource, use the applicable
        /// <code>Get</code> or <code>List</code> command: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html">GetResolverEndpoint</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRule.html">GetResolverRule</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRuleAssociation.html">GetResolverRuleAssociation</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html">ListResolverEndpoints</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html">ListResolverRuleAssociations</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html">ListResolverRules</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags that you want to add to the specified resource.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags that you want to add to the specified resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes one or more tags from a specified resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the resource that you want to remove tags from. To get the ARN for a resource, use the applicable
        /// <code>Get</code> or <code>List</code> command: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html">GetResolverEndpoint</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRule.html">GetResolverRule</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRuleAssociation.html">GetResolverRuleAssociation</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html">ListResolverEndpoints</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html">ListResolverRuleAssociations</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html">ListResolverRules</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the resource that you want to remove tags from. To get the ARN for a resource, use the applicable
        /// <code>Get</code> or <code>List</code> command: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html">GetResolverEndpoint</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRule.html">GetResolverRule</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRuleAssociation.html">GetResolverRuleAssociation</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html">ListResolverEndpoints</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html">ListResolverRuleAssociations</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html">ListResolverRules</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tags that you want to remove to the specified resource.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The tags that you want to remove to the specified resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFirewallConfig`.
    ///
    /// <p>Updates the configuration of the firewall behavior provided by DNS Firewall for a single
    /// VPC from Amazon Virtual Private Cloud (Amazon VPC). </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateFirewallConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_firewall_config_input::Builder,
    }
    impl<C, M, R> UpdateFirewallConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFirewallConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFirewallConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFirewallConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFirewallConfigInputOperationOutputAlias,
                crate::output::UpdateFirewallConfigOutput,
                crate::error::UpdateFirewallConfigError,
                crate::input::UpdateFirewallConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the VPC that the configuration is for.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>The ID of the VPC that the configuration is for.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>Determines how Route 53 Resolver handles queries during failures, for example when all traffic that is sent to DNS Firewall fails to receive a reply. </p>
        /// <ul>
        /// <li>
        /// <p>By default, fail open is disabled, which means the failure mode is closed. This approach favors security over availability.
        /// DNS Firewall blocks queries that it is unable to evaluate properly. </p>
        /// </li>
        /// <li>
        /// <p>If you enable this option, the failure mode is open. This approach favors availability over security. DNS Firewall allows queries to proceed if it
        /// is unable to properly evaluate them. </p>
        /// </li>
        /// </ul>
        /// <p>This behavior is only enforced for VPCs that have at least one DNS Firewall rule group association. </p>
        pub fn firewall_fail_open(mut self, inp: crate::model::FirewallFailOpenStatus) -> Self {
            self.inner = self.inner.firewall_fail_open(inp);
            self
        }
        /// <p>Determines how Route 53 Resolver handles queries during failures, for example when all traffic that is sent to DNS Firewall fails to receive a reply. </p>
        /// <ul>
        /// <li>
        /// <p>By default, fail open is disabled, which means the failure mode is closed. This approach favors security over availability.
        /// DNS Firewall blocks queries that it is unable to evaluate properly. </p>
        /// </li>
        /// <li>
        /// <p>If you enable this option, the failure mode is open. This approach favors availability over security. DNS Firewall allows queries to proceed if it
        /// is unable to properly evaluate them. </p>
        /// </li>
        /// </ul>
        /// <p>This behavior is only enforced for VPCs that have at least one DNS Firewall rule group association. </p>
        pub fn set_firewall_fail_open(
            mut self,
            input: std::option::Option<crate::model::FirewallFailOpenStatus>,
        ) -> Self {
            self.inner = self.inner.set_firewall_fail_open(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFirewallDomains`.
    ///
    /// <p>Updates the firewall domain list from an array of domain specifications. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateFirewallDomains<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_firewall_domains_input::Builder,
    }
    impl<C, M, R> UpdateFirewallDomains<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFirewallDomains`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFirewallDomainsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFirewallDomainsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFirewallDomainsInputOperationOutputAlias,
                crate::output::UpdateFirewallDomainsOutput,
                crate::error::UpdateFirewallDomainsError,
                crate::input::UpdateFirewallDomainsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the domain list whose domains you want to update. </p>
        pub fn firewall_domain_list_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_domain_list_id(inp);
            self
        }
        /// <p>The ID of the domain list whose domains you want to update. </p>
        pub fn set_firewall_domain_list_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_domain_list_id(input);
            self
        }
        /// <p>What you want DNS Firewall to do with the domains that you are providing: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ADD</code> - Add the domains to the ones that are already in the domain list. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REMOVE</code> - Search the domain list for the domains and remove them from the list.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REPLACE</code> - Update the domain list to exactly match the list that you are providing. </p>
        /// </li>
        /// </ul>
        pub fn operation(mut self, inp: crate::model::FirewallDomainUpdateOperation) -> Self {
            self.inner = self.inner.operation(inp);
            self
        }
        /// <p>What you want DNS Firewall to do with the domains that you are providing: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ADD</code> - Add the domains to the ones that are already in the domain list. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REMOVE</code> - Search the domain list for the domains and remove them from the list.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REPLACE</code> - Update the domain list to exactly match the list that you are providing. </p>
        /// </li>
        /// </ul>
        pub fn set_operation(
            mut self,
            input: std::option::Option<crate::model::FirewallDomainUpdateOperation>,
        ) -> Self {
            self.inner = self.inner.set_operation(input);
            self
        }
        /// Appends an item to `Domains`.
        ///
        /// To override the contents of this collection use [`set_domains`](Self::set_domains).
        ///
        /// <p>A list of domains to use in the update operation.</p>
        /// <p>Each domain specification in your domain list must satisfy the following
        /// requirements: </p>
        /// <ul>
        /// <li>
        /// <p>It can optionally start with <code>*</code> (asterisk).</p>
        /// </li>
        /// <li>
        /// <p>With the exception of the optional starting asterisk, it must only contain
        /// the following characters: <code>A-Z</code>, <code>a-z</code>,
        /// <code>0-9</code>, <code>-</code> (hyphen).</p>
        /// </li>
        /// <li>
        /// <p>It must be from 1-255 characters in length. </p>
        /// </li>
        /// </ul>
        pub fn domains(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domains(inp);
            self
        }
        /// <p>A list of domains to use in the update operation.</p>
        /// <p>Each domain specification in your domain list must satisfy the following
        /// requirements: </p>
        /// <ul>
        /// <li>
        /// <p>It can optionally start with <code>*</code> (asterisk).</p>
        /// </li>
        /// <li>
        /// <p>With the exception of the optional starting asterisk, it must only contain
        /// the following characters: <code>A-Z</code>, <code>a-z</code>,
        /// <code>0-9</code>, <code>-</code> (hyphen).</p>
        /// </li>
        /// <li>
        /// <p>It must be from 1-255 characters in length. </p>
        /// </li>
        /// </ul>
        pub fn set_domains(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_domains(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFirewallRule`.
    ///
    /// <p>Updates the specified firewall rule. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateFirewallRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_firewall_rule_input::Builder,
    }
    impl<C, M, R> UpdateFirewallRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFirewallRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFirewallRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFirewallRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFirewallRuleInputOperationOutputAlias,
                crate::output::UpdateFirewallRuleOutput,
                crate::error::UpdateFirewallRuleError,
                crate::input::UpdateFirewallRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the firewall rule group for the rule. </p>
        pub fn firewall_rule_group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_rule_group_id(inp);
            self
        }
        /// <p>The unique identifier of the firewall rule group for the rule. </p>
        pub fn set_firewall_rule_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_rule_group_id(input);
            self
        }
        /// <p>The ID of the domain list to use in the rule.  </p>
        pub fn firewall_domain_list_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.firewall_domain_list_id(inp);
            self
        }
        /// <p>The ID of the domain list to use in the rule.  </p>
        pub fn set_firewall_domain_list_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_domain_list_id(input);
            self
        }
        /// <p>The setting that determines the processing order of the rule in the rule group. DNS Firewall
        /// processes the rules in a rule group by order of priority, starting from the lowest setting.</p>
        /// <p>You must specify a unique priority for each rule in a rule group.
        /// To make it easier to insert rules later, leave space between the numbers, for example, use 100, 200, and so on. You
        /// can change the priority setting for the rules in a rule group at any time.</p>
        pub fn priority(mut self, inp: i32) -> Self {
            self.inner = self.inner.priority(inp);
            self
        }
        /// <p>The setting that determines the processing order of the rule in the rule group. DNS Firewall
        /// processes the rules in a rule group by order of priority, starting from the lowest setting.</p>
        /// <p>You must specify a unique priority for each rule in a rule group.
        /// To make it easier to insert rules later, leave space between the numbers, for example, use 100, 200, and so on. You
        /// can change the priority setting for the rules in a rule group at any time.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_priority(input);
            self
        }
        /// <p>The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALLOW</code> - Permit the request to go through.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALERT</code> - Permit the request to go through but send an alert to the logs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BLOCK</code> - Disallow the request. This option requires additional details in the rule's <code>BlockResponse</code>. </p>
        /// </li>
        /// </ul>
        pub fn action(mut self, inp: crate::model::Action) -> Self {
            self.inner = self.inner.action(inp);
            self
        }
        /// <p>The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALLOW</code> - Permit the request to go through.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALERT</code> - Permit the request to go through but send an alert to the logs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BLOCK</code> - Disallow the request. This option requires additional details in the rule's <code>BlockResponse</code>. </p>
        /// </li>
        /// </ul>
        pub fn set_action(mut self, input: std::option::Option<crate::model::Action>) -> Self {
            self.inner = self.inner.set_action(input);
            self
        }
        /// <p>The way that you want DNS Firewall to block the request. Used for the rule action setting <code>BLOCK</code>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NODATA</code> - Respond indicating that the query was successful, but no response is available for it.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NXDOMAIN</code> - Respond indicating that the domain name that's in the query doesn't exist.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OVERRIDE</code> - Provide a custom override in the response. This option requires custom handling details in the rule's <code>BlockOverride*</code> settings. </p>
        /// </li>
        /// </ul>
        pub fn block_response(mut self, inp: crate::model::BlockResponse) -> Self {
            self.inner = self.inner.block_response(inp);
            self
        }
        /// <p>The way that you want DNS Firewall to block the request. Used for the rule action setting <code>BLOCK</code>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NODATA</code> - Respond indicating that the query was successful, but no response is available for it.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NXDOMAIN</code> - Respond indicating that the domain name that's in the query doesn't exist.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OVERRIDE</code> - Provide a custom override in the response. This option requires custom handling details in the rule's <code>BlockOverride*</code> settings. </p>
        /// </li>
        /// </ul>
        pub fn set_block_response(
            mut self,
            input: std::option::Option<crate::model::BlockResponse>,
        ) -> Self {
            self.inner = self.inner.set_block_response(input);
            self
        }
        /// <p>The custom DNS record to send back in response to the query. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
        pub fn block_override_domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.block_override_domain(inp);
            self
        }
        /// <p>The custom DNS record to send back in response to the query. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
        pub fn set_block_override_domain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_block_override_domain(input);
            self
        }
        /// <p>The DNS record's type. This determines the format of the record value that you provided in <code>BlockOverrideDomain</code>. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
        pub fn block_override_dns_type(mut self, inp: crate::model::BlockOverrideDnsType) -> Self {
            self.inner = self.inner.block_override_dns_type(inp);
            self
        }
        /// <p>The DNS record's type. This determines the format of the record value that you provided in <code>BlockOverrideDomain</code>. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
        pub fn set_block_override_dns_type(
            mut self,
            input: std::option::Option<crate::model::BlockOverrideDnsType>,
        ) -> Self {
            self.inner = self.inner.set_block_override_dns_type(input);
            self
        }
        /// <p>The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
        pub fn block_override_ttl(mut self, inp: i32) -> Self {
            self.inner = self.inner.block_override_ttl(inp);
            self
        }
        /// <p>The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
        pub fn set_block_override_ttl(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_block_override_ttl(input);
            self
        }
        /// <p>The name of the rule.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the rule.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFirewallRuleGroupAssociation`.
    ///
    /// <p>Changes the association of a <a>FirewallRuleGroup</a> with a VPC. The association enables DNS filtering for the VPC. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateFirewallRuleGroupAssociation<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_firewall_rule_group_association_input::Builder,
    }
    impl<C, M, R> UpdateFirewallRuleGroupAssociation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFirewallRuleGroupAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFirewallRuleGroupAssociationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateFirewallRuleGroupAssociationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFirewallRuleGroupAssociationInputOperationOutputAlias,
                crate::output::UpdateFirewallRuleGroupAssociationOutput,
                crate::error::UpdateFirewallRuleGroupAssociationError,
                crate::input::UpdateFirewallRuleGroupAssociationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the <a>FirewallRuleGroupAssociation</a>. </p>
        pub fn firewall_rule_group_association_id(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.firewall_rule_group_association_id(inp);
            self
        }
        /// <p>The identifier of the <a>FirewallRuleGroupAssociation</a>. </p>
        pub fn set_firewall_rule_group_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_firewall_rule_group_association_id(input);
            self
        }
        /// <p>The setting that determines the processing order of the rule group among the rule
        /// groups that you associate with the specified VPC. DNS Firewall filters VPC traffic
        /// starting from the rule group with the lowest numeric priority setting. </p>
        /// <p>You must specify a unique priority for each rule group that you associate with a single VPC.
        /// To make it easier to insert rule groups later, leave space between the numbers, for example, use 100, 200, and so on. You
        /// can change the priority setting for a rule group association after you create it.</p>
        pub fn priority(mut self, inp: i32) -> Self {
            self.inner = self.inner.priority(inp);
            self
        }
        /// <p>The setting that determines the processing order of the rule group among the rule
        /// groups that you associate with the specified VPC. DNS Firewall filters VPC traffic
        /// starting from the rule group with the lowest numeric priority setting. </p>
        /// <p>You must specify a unique priority for each rule group that you associate with a single VPC.
        /// To make it easier to insert rule groups later, leave space between the numbers, for example, use 100, 200, and so on. You
        /// can change the priority setting for a rule group association after you create it.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_priority(input);
            self
        }
        /// <p>If enabled, this setting disallows modification or removal of the association, to help prevent against accidentally altering DNS firewall protections. </p>
        pub fn mutation_protection(mut self, inp: crate::model::MutationProtectionStatus) -> Self {
            self.inner = self.inner.mutation_protection(inp);
            self
        }
        /// <p>If enabled, this setting disallows modification or removal of the association, to help prevent against accidentally altering DNS firewall protections. </p>
        pub fn set_mutation_protection(
            mut self,
            input: std::option::Option<crate::model::MutationProtectionStatus>,
        ) -> Self {
            self.inner = self.inner.set_mutation_protection(input);
            self
        }
        /// <p>The name of the rule group association.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the rule group association.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateResolverConfig`.
    ///
    /// <p>Updates the behavior configuration of Route 53 Resolver behavior for a single VPC from
    /// Amazon Virtual Private Cloud.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateResolverConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_resolver_config_input::Builder,
    }
    impl<C, M, R> UpdateResolverConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateResolverConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateResolverConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateResolverConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateResolverConfigInputOperationOutputAlias,
                crate::output::UpdateResolverConfigOutput,
                crate::error::UpdateResolverConfigError,
                crate::input::UpdateResolverConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Resource ID of the Amazon VPC that you want to update the Resolver configuration for.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>Resource ID of the Amazon VPC that you want to update the Resolver configuration for.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>Indicates whether or not the Resolver will create autodefined rules for reverse DNS
        /// lookups. This is enabled by default. Disabling this option will also affect EC2-Classic
        /// instances using ClassicLink. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
        /// <i>Amazon EC2 guide</i>.</p>
        /// <note>
        /// <p>It can take some time for the status change to be completed.</p>
        /// </note>
        /// <p></p>
        pub fn autodefined_reverse_flag(
            mut self,
            inp: crate::model::AutodefinedReverseFlag,
        ) -> Self {
            self.inner = self.inner.autodefined_reverse_flag(inp);
            self
        }
        /// <p>Indicates whether or not the Resolver will create autodefined rules for reverse DNS
        /// lookups. This is enabled by default. Disabling this option will also affect EC2-Classic
        /// instances using ClassicLink. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
        /// <i>Amazon EC2 guide</i>.</p>
        /// <note>
        /// <p>It can take some time for the status change to be completed.</p>
        /// </note>
        /// <p></p>
        pub fn set_autodefined_reverse_flag(
            mut self,
            input: std::option::Option<crate::model::AutodefinedReverseFlag>,
        ) -> Self {
            self.inner = self.inner.set_autodefined_reverse_flag(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateResolverDnssecConfig`.
    ///
    /// <p>Updates an existing DNSSEC validation configuration. If there is no existing DNSSEC validation configuration, one is created.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateResolverDnssecConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_resolver_dnssec_config_input::Builder,
    }
    impl<C, M, R> UpdateResolverDnssecConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateResolverDnssecConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateResolverDnssecConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateResolverDnssecConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateResolverDnssecConfigInputOperationOutputAlias,
                crate::output::UpdateResolverDnssecConfigOutput,
                crate::error::UpdateResolverDnssecConfigError,
                crate::input::UpdateResolverDnssecConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the virtual private cloud (VPC) that you're updating the DNSSEC validation status for.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>The ID of the virtual private cloud (VPC) that you're updating the DNSSEC validation status for.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The new value that you are specifying for DNSSEC validation for the VPC. The value can be <code>ENABLE</code>
        /// or <code>DISABLE</code>. Be aware that it can take time for a validation status change to be completed.</p>
        pub fn validation(mut self, inp: crate::model::Validation) -> Self {
            self.inner = self.inner.validation(inp);
            self
        }
        /// <p>The new value that you are specifying for DNSSEC validation for the VPC. The value can be <code>ENABLE</code>
        /// or <code>DISABLE</code>. Be aware that it can take time for a validation status change to be completed.</p>
        pub fn set_validation(
            mut self,
            input: std::option::Option<crate::model::Validation>,
        ) -> Self {
            self.inner = self.inner.set_validation(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateResolverEndpoint`.
    ///
    /// <p>Updates the name of an inbound or an outbound Resolver endpoint.  </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateResolverEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_resolver_endpoint_input::Builder,
    }
    impl<C, M, R> UpdateResolverEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateResolverEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateResolverEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateResolverEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateResolverEndpointInputOperationOutputAlias,
                crate::output::UpdateResolverEndpointOutput,
                crate::error::UpdateResolverEndpointError,
                crate::input::UpdateResolverEndpointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Resolver endpoint that you want to update.</p>
        pub fn resolver_endpoint_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolver_endpoint_id(inp);
            self
        }
        /// <p>The ID of the Resolver endpoint that you want to update.</p>
        pub fn set_resolver_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolver_endpoint_id(input);
            self
        }
        /// <p>The name of the Resolver endpoint that you want to update.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the Resolver endpoint that you want to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateResolverRule`.
    ///
    /// <p>Updates settings for a specified Resolver rule. <code>ResolverRuleId</code> is required, and all other parameters are optional.
    /// If you don't specify a parameter, it retains its current value.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateResolverRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_resolver_rule_input::Builder,
    }
    impl<C, M, R> UpdateResolverRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateResolverRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateResolverRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateResolverRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateResolverRuleInputOperationOutputAlias,
                crate::output::UpdateResolverRuleOutput,
                crate::error::UpdateResolverRuleError,
                crate::input::UpdateResolverRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Resolver rule that you want to update.</p>
        pub fn resolver_rule_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolver_rule_id(inp);
            self
        }
        /// <p>The ID of the Resolver rule that you want to update.</p>
        pub fn set_resolver_rule_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolver_rule_id(input);
            self
        }
        /// <p>The new settings for the Resolver rule.</p>
        pub fn config(mut self, inp: crate::model::ResolverRuleConfig) -> Self {
            self.inner = self.inner.config(inp);
            self
        }
        /// <p>The new settings for the Resolver rule.</p>
        pub fn set_config(
            mut self,
            input: std::option::Option<crate::model::ResolverRuleConfig>,
        ) -> Self {
            self.inner = self.inner.set_config(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
