// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateResolverRuleOutput {
    /// <p>The response to an <code>UpdateResolverRule</code> request.</p>
    pub resolver_rule: std::option::Option<crate::model::ResolverRule>,
}
impl std::fmt::Debug for UpdateResolverRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateResolverRuleOutput");
        formatter.field("resolver_rule", &self.resolver_rule);
        formatter.finish()
    }
}
/// See [`UpdateResolverRuleOutput`](crate::output::UpdateResolverRuleOutput)
pub mod update_resolver_rule_output {
    /// A builder for [`UpdateResolverRuleOutput`](crate::output::UpdateResolverRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resolver_rule: std::option::Option<crate::model::ResolverRule>,
    }
    impl Builder {
        /// <p>The response to an <code>UpdateResolverRule</code> request.</p>
        pub fn resolver_rule(mut self, input: crate::model::ResolverRule) -> Self {
            self.resolver_rule = Some(input);
            self
        }
        /// <p>The response to an <code>UpdateResolverRule</code> request.</p>
        pub fn set_resolver_rule(
            mut self,
            input: std::option::Option<crate::model::ResolverRule>,
        ) -> Self {
            self.resolver_rule = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateResolverRuleOutput`](crate::output::UpdateResolverRuleOutput)
        pub fn build(self) -> crate::output::UpdateResolverRuleOutput {
            crate::output::UpdateResolverRuleOutput {
                resolver_rule: self.resolver_rule,
            }
        }
    }
}
impl UpdateResolverRuleOutput {
    /// Creates a new builder-style object to manufacture [`UpdateResolverRuleOutput`](crate::output::UpdateResolverRuleOutput)
    pub fn builder() -> crate::output::update_resolver_rule_output::Builder {
        crate::output::update_resolver_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateResolverEndpointOutput {
    /// <p>The response to an <code>UpdateResolverEndpoint</code> request.</p>
    pub resolver_endpoint: std::option::Option<crate::model::ResolverEndpoint>,
}
impl std::fmt::Debug for UpdateResolverEndpointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateResolverEndpointOutput");
        formatter.field("resolver_endpoint", &self.resolver_endpoint);
        formatter.finish()
    }
}
/// See [`UpdateResolverEndpointOutput`](crate::output::UpdateResolverEndpointOutput)
pub mod update_resolver_endpoint_output {
    /// A builder for [`UpdateResolverEndpointOutput`](crate::output::UpdateResolverEndpointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resolver_endpoint: std::option::Option<crate::model::ResolverEndpoint>,
    }
    impl Builder {
        /// <p>The response to an <code>UpdateResolverEndpoint</code> request.</p>
        pub fn resolver_endpoint(mut self, input: crate::model::ResolverEndpoint) -> Self {
            self.resolver_endpoint = Some(input);
            self
        }
        /// <p>The response to an <code>UpdateResolverEndpoint</code> request.</p>
        pub fn set_resolver_endpoint(
            mut self,
            input: std::option::Option<crate::model::ResolverEndpoint>,
        ) -> Self {
            self.resolver_endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateResolverEndpointOutput`](crate::output::UpdateResolverEndpointOutput)
        pub fn build(self) -> crate::output::UpdateResolverEndpointOutput {
            crate::output::UpdateResolverEndpointOutput {
                resolver_endpoint: self.resolver_endpoint,
            }
        }
    }
}
impl UpdateResolverEndpointOutput {
    /// Creates a new builder-style object to manufacture [`UpdateResolverEndpointOutput`](crate::output::UpdateResolverEndpointOutput)
    pub fn builder() -> crate::output::update_resolver_endpoint_output::Builder {
        crate::output::update_resolver_endpoint_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateResolverDnssecConfigOutput {
    /// <p>A complex type that contains settings for the specified DNSSEC configuration.</p>
    pub resolver_dnssec_config: std::option::Option<crate::model::ResolverDnssecConfig>,
}
impl std::fmt::Debug for UpdateResolverDnssecConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateResolverDnssecConfigOutput");
        formatter.field("resolver_dnssec_config", &self.resolver_dnssec_config);
        formatter.finish()
    }
}
/// See [`UpdateResolverDnssecConfigOutput`](crate::output::UpdateResolverDnssecConfigOutput)
pub mod update_resolver_dnssec_config_output {
    /// A builder for [`UpdateResolverDnssecConfigOutput`](crate::output::UpdateResolverDnssecConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resolver_dnssec_config: std::option::Option<crate::model::ResolverDnssecConfig>,
    }
    impl Builder {
        /// <p>A complex type that contains settings for the specified DNSSEC configuration.</p>
        pub fn resolver_dnssec_config(mut self, input: crate::model::ResolverDnssecConfig) -> Self {
            self.resolver_dnssec_config = Some(input);
            self
        }
        /// <p>A complex type that contains settings for the specified DNSSEC configuration.</p>
        pub fn set_resolver_dnssec_config(
            mut self,
            input: std::option::Option<crate::model::ResolverDnssecConfig>,
        ) -> Self {
            self.resolver_dnssec_config = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateResolverDnssecConfigOutput`](crate::output::UpdateResolverDnssecConfigOutput)
        pub fn build(self) -> crate::output::UpdateResolverDnssecConfigOutput {
            crate::output::UpdateResolverDnssecConfigOutput {
                resolver_dnssec_config: self.resolver_dnssec_config,
            }
        }
    }
}
impl UpdateResolverDnssecConfigOutput {
    /// Creates a new builder-style object to manufacture [`UpdateResolverDnssecConfigOutput`](crate::output::UpdateResolverDnssecConfigOutput)
    pub fn builder() -> crate::output::update_resolver_dnssec_config_output::Builder {
        crate::output::update_resolver_dnssec_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFirewallRuleGroupAssociationOutput {
    /// <p>The association that you just updated. </p>
    pub firewall_rule_group_association:
        std::option::Option<crate::model::FirewallRuleGroupAssociation>,
}
impl std::fmt::Debug for UpdateFirewallRuleGroupAssociationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFirewallRuleGroupAssociationOutput");
        formatter.field(
            "firewall_rule_group_association",
            &self.firewall_rule_group_association,
        );
        formatter.finish()
    }
}
/// See [`UpdateFirewallRuleGroupAssociationOutput`](crate::output::UpdateFirewallRuleGroupAssociationOutput)
pub mod update_firewall_rule_group_association_output {
    /// A builder for [`UpdateFirewallRuleGroupAssociationOutput`](crate::output::UpdateFirewallRuleGroupAssociationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_rule_group_association:
            std::option::Option<crate::model::FirewallRuleGroupAssociation>,
    }
    impl Builder {
        /// <p>The association that you just updated. </p>
        pub fn firewall_rule_group_association(
            mut self,
            input: crate::model::FirewallRuleGroupAssociation,
        ) -> Self {
            self.firewall_rule_group_association = Some(input);
            self
        }
        /// <p>The association that you just updated. </p>
        pub fn set_firewall_rule_group_association(
            mut self,
            input: std::option::Option<crate::model::FirewallRuleGroupAssociation>,
        ) -> Self {
            self.firewall_rule_group_association = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFirewallRuleGroupAssociationOutput`](crate::output::UpdateFirewallRuleGroupAssociationOutput)
        pub fn build(self) -> crate::output::UpdateFirewallRuleGroupAssociationOutput {
            crate::output::UpdateFirewallRuleGroupAssociationOutput {
                firewall_rule_group_association: self.firewall_rule_group_association,
            }
        }
    }
}
impl UpdateFirewallRuleGroupAssociationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateFirewallRuleGroupAssociationOutput`](crate::output::UpdateFirewallRuleGroupAssociationOutput)
    pub fn builder() -> crate::output::update_firewall_rule_group_association_output::Builder {
        crate::output::update_firewall_rule_group_association_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFirewallRuleOutput {
    /// <p>The firewall rule that you just updated. </p>
    pub firewall_rule: std::option::Option<crate::model::FirewallRule>,
}
impl std::fmt::Debug for UpdateFirewallRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFirewallRuleOutput");
        formatter.field("firewall_rule", &self.firewall_rule);
        formatter.finish()
    }
}
/// See [`UpdateFirewallRuleOutput`](crate::output::UpdateFirewallRuleOutput)
pub mod update_firewall_rule_output {
    /// A builder for [`UpdateFirewallRuleOutput`](crate::output::UpdateFirewallRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_rule: std::option::Option<crate::model::FirewallRule>,
    }
    impl Builder {
        /// <p>The firewall rule that you just updated. </p>
        pub fn firewall_rule(mut self, input: crate::model::FirewallRule) -> Self {
            self.firewall_rule = Some(input);
            self
        }
        /// <p>The firewall rule that you just updated. </p>
        pub fn set_firewall_rule(
            mut self,
            input: std::option::Option<crate::model::FirewallRule>,
        ) -> Self {
            self.firewall_rule = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFirewallRuleOutput`](crate::output::UpdateFirewallRuleOutput)
        pub fn build(self) -> crate::output::UpdateFirewallRuleOutput {
            crate::output::UpdateFirewallRuleOutput {
                firewall_rule: self.firewall_rule,
            }
        }
    }
}
impl UpdateFirewallRuleOutput {
    /// Creates a new builder-style object to manufacture [`UpdateFirewallRuleOutput`](crate::output::UpdateFirewallRuleOutput)
    pub fn builder() -> crate::output::update_firewall_rule_output::Builder {
        crate::output::update_firewall_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFirewallDomainsOutput {
    /// <p>The ID of the firewall domain list that DNS Firewall just updated.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the domain list. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> </p>
    pub status: std::option::Option<crate::model::FirewallDomainListStatus>,
    /// <p>Additional information about the status of the list, if available.</p>
    pub status_message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateFirewallDomainsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFirewallDomainsOutput");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.finish()
    }
}
/// See [`UpdateFirewallDomainsOutput`](crate::output::UpdateFirewallDomainsOutput)
pub mod update_firewall_domains_output {
    /// A builder for [`UpdateFirewallDomainsOutput`](crate::output::UpdateFirewallDomainsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::FirewallDomainListStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the firewall domain list that DNS Firewall just updated.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the firewall domain list that DNS Firewall just updated.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the domain list. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the domain list. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> </p>
        pub fn status(mut self, input: crate::model::FirewallDomainListStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::FirewallDomainListStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Additional information about the status of the list, if available.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>Additional information about the status of the list, if available.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFirewallDomainsOutput`](crate::output::UpdateFirewallDomainsOutput)
        pub fn build(self) -> crate::output::UpdateFirewallDomainsOutput {
            crate::output::UpdateFirewallDomainsOutput {
                id: self.id,
                name: self.name,
                status: self.status,
                status_message: self.status_message,
            }
        }
    }
}
impl UpdateFirewallDomainsOutput {
    /// Creates a new builder-style object to manufacture [`UpdateFirewallDomainsOutput`](crate::output::UpdateFirewallDomainsOutput)
    pub fn builder() -> crate::output::update_firewall_domains_output::Builder {
        crate::output::update_firewall_domains_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFirewallConfigOutput {
    /// <p>Configuration of the firewall behavior provided by DNS Firewall for a single VPC. </p>
    pub firewall_config: std::option::Option<crate::model::FirewallConfig>,
}
impl std::fmt::Debug for UpdateFirewallConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFirewallConfigOutput");
        formatter.field("firewall_config", &self.firewall_config);
        formatter.finish()
    }
}
/// See [`UpdateFirewallConfigOutput`](crate::output::UpdateFirewallConfigOutput)
pub mod update_firewall_config_output {
    /// A builder for [`UpdateFirewallConfigOutput`](crate::output::UpdateFirewallConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_config: std::option::Option<crate::model::FirewallConfig>,
    }
    impl Builder {
        /// <p>Configuration of the firewall behavior provided by DNS Firewall for a single VPC. </p>
        pub fn firewall_config(mut self, input: crate::model::FirewallConfig) -> Self {
            self.firewall_config = Some(input);
            self
        }
        /// <p>Configuration of the firewall behavior provided by DNS Firewall for a single VPC. </p>
        pub fn set_firewall_config(
            mut self,
            input: std::option::Option<crate::model::FirewallConfig>,
        ) -> Self {
            self.firewall_config = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFirewallConfigOutput`](crate::output::UpdateFirewallConfigOutput)
        pub fn build(self) -> crate::output::UpdateFirewallConfigOutput {
            crate::output::UpdateFirewallConfigOutput {
                firewall_config: self.firewall_config,
            }
        }
    }
}
impl UpdateFirewallConfigOutput {
    /// Creates a new builder-style object to manufacture [`UpdateFirewallConfigOutput`](crate::output::UpdateFirewallConfigOutput)
    pub fn builder() -> crate::output::update_firewall_config_output::Builder {
        crate::output::update_firewall_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

/// <p>The response to a <code>PutResolverRulePolicy</code> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutResolverRulePolicyOutput {
    /// <p>Whether the <code>PutResolverRulePolicy</code> request was successful.</p>
    pub return_value: bool,
}
impl std::fmt::Debug for PutResolverRulePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutResolverRulePolicyOutput");
        formatter.field("return_value", &self.return_value);
        formatter.finish()
    }
}
/// See [`PutResolverRulePolicyOutput`](crate::output::PutResolverRulePolicyOutput)
pub mod put_resolver_rule_policy_output {
    /// A builder for [`PutResolverRulePolicyOutput`](crate::output::PutResolverRulePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) return_value: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Whether the <code>PutResolverRulePolicy</code> request was successful.</p>
        pub fn return_value(mut self, input: bool) -> Self {
            self.return_value = Some(input);
            self
        }
        /// <p>Whether the <code>PutResolverRulePolicy</code> request was successful.</p>
        pub fn set_return_value(mut self, input: std::option::Option<bool>) -> Self {
            self.return_value = input;
            self
        }
        /// Consumes the builder and constructs a [`PutResolverRulePolicyOutput`](crate::output::PutResolverRulePolicyOutput)
        pub fn build(self) -> crate::output::PutResolverRulePolicyOutput {
            crate::output::PutResolverRulePolicyOutput {
                return_value: self.return_value.unwrap_or_default(),
            }
        }
    }
}
impl PutResolverRulePolicyOutput {
    /// Creates a new builder-style object to manufacture [`PutResolverRulePolicyOutput`](crate::output::PutResolverRulePolicyOutput)
    pub fn builder() -> crate::output::put_resolver_rule_policy_output::Builder {
        crate::output::put_resolver_rule_policy_output::Builder::default()
    }
}

/// <p>The response to a <code>PutResolverQueryLogConfigPolicy</code> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutResolverQueryLogConfigPolicyOutput {
    /// <p>Whether the <code>PutResolverQueryLogConfigPolicy</code> request was successful.</p>
    pub return_value: bool,
}
impl std::fmt::Debug for PutResolverQueryLogConfigPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutResolverQueryLogConfigPolicyOutput");
        formatter.field("return_value", &self.return_value);
        formatter.finish()
    }
}
/// See [`PutResolverQueryLogConfigPolicyOutput`](crate::output::PutResolverQueryLogConfigPolicyOutput)
pub mod put_resolver_query_log_config_policy_output {
    /// A builder for [`PutResolverQueryLogConfigPolicyOutput`](crate::output::PutResolverQueryLogConfigPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) return_value: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Whether the <code>PutResolverQueryLogConfigPolicy</code> request was successful.</p>
        pub fn return_value(mut self, input: bool) -> Self {
            self.return_value = Some(input);
            self
        }
        /// <p>Whether the <code>PutResolverQueryLogConfigPolicy</code> request was successful.</p>
        pub fn set_return_value(mut self, input: std::option::Option<bool>) -> Self {
            self.return_value = input;
            self
        }
        /// Consumes the builder and constructs a [`PutResolverQueryLogConfigPolicyOutput`](crate::output::PutResolverQueryLogConfigPolicyOutput)
        pub fn build(self) -> crate::output::PutResolverQueryLogConfigPolicyOutput {
            crate::output::PutResolverQueryLogConfigPolicyOutput {
                return_value: self.return_value.unwrap_or_default(),
            }
        }
    }
}
impl PutResolverQueryLogConfigPolicyOutput {
    /// Creates a new builder-style object to manufacture [`PutResolverQueryLogConfigPolicyOutput`](crate::output::PutResolverQueryLogConfigPolicyOutput)
    pub fn builder() -> crate::output::put_resolver_query_log_config_policy_output::Builder {
        crate::output::put_resolver_query_log_config_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutFirewallRuleGroupPolicyOutput {
    /// <p></p>
    pub return_value: bool,
}
impl std::fmt::Debug for PutFirewallRuleGroupPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutFirewallRuleGroupPolicyOutput");
        formatter.field("return_value", &self.return_value);
        formatter.finish()
    }
}
/// See [`PutFirewallRuleGroupPolicyOutput`](crate::output::PutFirewallRuleGroupPolicyOutput)
pub mod put_firewall_rule_group_policy_output {
    /// A builder for [`PutFirewallRuleGroupPolicyOutput`](crate::output::PutFirewallRuleGroupPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) return_value: std::option::Option<bool>,
    }
    impl Builder {
        /// <p></p>
        pub fn return_value(mut self, input: bool) -> Self {
            self.return_value = Some(input);
            self
        }
        /// <p></p>
        pub fn set_return_value(mut self, input: std::option::Option<bool>) -> Self {
            self.return_value = input;
            self
        }
        /// Consumes the builder and constructs a [`PutFirewallRuleGroupPolicyOutput`](crate::output::PutFirewallRuleGroupPolicyOutput)
        pub fn build(self) -> crate::output::PutFirewallRuleGroupPolicyOutput {
            crate::output::PutFirewallRuleGroupPolicyOutput {
                return_value: self.return_value.unwrap_or_default(),
            }
        }
    }
}
impl PutFirewallRuleGroupPolicyOutput {
    /// Creates a new builder-style object to manufacture [`PutFirewallRuleGroupPolicyOutput`](crate::output::PutFirewallRuleGroupPolicyOutput)
    pub fn builder() -> crate::output::put_firewall_rule_group_policy_output::Builder {
        crate::output::put_firewall_rule_group_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The tags that are associated with the resource that you specified in the <code>ListTagsForResource</code> request.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>If more than <code>MaxResults</code> tags match the specified criteria, you can submit another
    /// <code>ListTagsForResource</code> request to get the next group of results. In the next request, specify the value of
    /// <code>NextToken</code> from the previous response. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags that are associated with the resource that you specified in the <code>ListTagsForResource</code> request.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags that are associated with the resource that you specified in the <code>ListTagsForResource</code> request.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>If more than <code>MaxResults</code> tags match the specified criteria, you can submit another
        /// <code>ListTagsForResource</code> request to get the next group of results. In the next request, specify the value of
        /// <code>NextToken</code> from the previous response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If more than <code>MaxResults</code> tags match the specified criteria, you can submit another
        /// <code>ListTagsForResource</code> request to get the next group of results. In the next request, specify the value of
        /// <code>NextToken</code> from the previous response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput {
                tags: self.tags,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResolverRulesOutput {
    /// <p>If more than <code>MaxResults</code> Resolver rules match the specified criteria, you can submit another
    /// <code>ListResolverRules</code> request to get the next group of results. In the next request, specify the value of
    /// <code>NextToken</code> from the previous response. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The value that you specified for <code>MaxResults</code> in the request.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The Resolver rules that were created using the current Amazon Web Services account and that match the specified filters, if any.</p>
    pub resolver_rules: std::option::Option<std::vec::Vec<crate::model::ResolverRule>>,
}
impl std::fmt::Debug for ListResolverRulesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResolverRulesOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("resolver_rules", &self.resolver_rules);
        formatter.finish()
    }
}
/// See [`ListResolverRulesOutput`](crate::output::ListResolverRulesOutput)
pub mod list_resolver_rules_output {
    /// A builder for [`ListResolverRulesOutput`](crate::output::ListResolverRulesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) resolver_rules: std::option::Option<std::vec::Vec<crate::model::ResolverRule>>,
    }
    impl Builder {
        /// <p>If more than <code>MaxResults</code> Resolver rules match the specified criteria, you can submit another
        /// <code>ListResolverRules</code> request to get the next group of results. In the next request, specify the value of
        /// <code>NextToken</code> from the previous response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If more than <code>MaxResults</code> Resolver rules match the specified criteria, you can submit another
        /// <code>ListResolverRules</code> request to get the next group of results. In the next request, specify the value of
        /// <code>NextToken</code> from the previous response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The value that you specified for <code>MaxResults</code> in the request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The value that you specified for <code>MaxResults</code> in the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Appends an item to `resolver_rules`.
        ///
        /// To override the contents of this collection use [`set_resolver_rules`](Self::set_resolver_rules).
        ///
        /// <p>The Resolver rules that were created using the current Amazon Web Services account and that match the specified filters, if any.</p>
        pub fn resolver_rules(mut self, input: impl Into<crate::model::ResolverRule>) -> Self {
            let mut v = self.resolver_rules.unwrap_or_default();
            v.push(input.into());
            self.resolver_rules = Some(v);
            self
        }
        /// <p>The Resolver rules that were created using the current Amazon Web Services account and that match the specified filters, if any.</p>
        pub fn set_resolver_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResolverRule>>,
        ) -> Self {
            self.resolver_rules = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResolverRulesOutput`](crate::output::ListResolverRulesOutput)
        pub fn build(self) -> crate::output::ListResolverRulesOutput {
            crate::output::ListResolverRulesOutput {
                next_token: self.next_token,
                max_results: self.max_results,
                resolver_rules: self.resolver_rules,
            }
        }
    }
}
impl ListResolverRulesOutput {
    /// Creates a new builder-style object to manufacture [`ListResolverRulesOutput`](crate::output::ListResolverRulesOutput)
    pub fn builder() -> crate::output::list_resolver_rules_output::Builder {
        crate::output::list_resolver_rules_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResolverRuleAssociationsOutput {
    /// <p>If more than <code>MaxResults</code> rule associations match the specified criteria, you can submit another
    /// <code>ListResolverRuleAssociation</code> request to get the next group of results. In the next request, specify the value of
    /// <code>NextToken</code> from the previous response. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The value that you specified for <code>MaxResults</code> in the request.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The associations that were created between Resolver rules and VPCs using the current Amazon Web Services account, and that match the
    /// specified filters, if any.</p>
    pub resolver_rule_associations:
        std::option::Option<std::vec::Vec<crate::model::ResolverRuleAssociation>>,
}
impl std::fmt::Debug for ListResolverRuleAssociationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResolverRuleAssociationsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field(
            "resolver_rule_associations",
            &self.resolver_rule_associations,
        );
        formatter.finish()
    }
}
/// See [`ListResolverRuleAssociationsOutput`](crate::output::ListResolverRuleAssociationsOutput)
pub mod list_resolver_rule_associations_output {
    /// A builder for [`ListResolverRuleAssociationsOutput`](crate::output::ListResolverRuleAssociationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) resolver_rule_associations:
            std::option::Option<std::vec::Vec<crate::model::ResolverRuleAssociation>>,
    }
    impl Builder {
        /// <p>If more than <code>MaxResults</code> rule associations match the specified criteria, you can submit another
        /// <code>ListResolverRuleAssociation</code> request to get the next group of results. In the next request, specify the value of
        /// <code>NextToken</code> from the previous response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If more than <code>MaxResults</code> rule associations match the specified criteria, you can submit another
        /// <code>ListResolverRuleAssociation</code> request to get the next group of results. In the next request, specify the value of
        /// <code>NextToken</code> from the previous response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The value that you specified for <code>MaxResults</code> in the request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The value that you specified for <code>MaxResults</code> in the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Appends an item to `resolver_rule_associations`.
        ///
        /// To override the contents of this collection use [`set_resolver_rule_associations`](Self::set_resolver_rule_associations).
        ///
        /// <p>The associations that were created between Resolver rules and VPCs using the current Amazon Web Services account, and that match the
        /// specified filters, if any.</p>
        pub fn resolver_rule_associations(
            mut self,
            input: impl Into<crate::model::ResolverRuleAssociation>,
        ) -> Self {
            let mut v = self.resolver_rule_associations.unwrap_or_default();
            v.push(input.into());
            self.resolver_rule_associations = Some(v);
            self
        }
        /// <p>The associations that were created between Resolver rules and VPCs using the current Amazon Web Services account, and that match the
        /// specified filters, if any.</p>
        pub fn set_resolver_rule_associations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResolverRuleAssociation>>,
        ) -> Self {
            self.resolver_rule_associations = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResolverRuleAssociationsOutput`](crate::output::ListResolverRuleAssociationsOutput)
        pub fn build(self) -> crate::output::ListResolverRuleAssociationsOutput {
            crate::output::ListResolverRuleAssociationsOutput {
                next_token: self.next_token,
                max_results: self.max_results,
                resolver_rule_associations: self.resolver_rule_associations,
            }
        }
    }
}
impl ListResolverRuleAssociationsOutput {
    /// Creates a new builder-style object to manufacture [`ListResolverRuleAssociationsOutput`](crate::output::ListResolverRuleAssociationsOutput)
    pub fn builder() -> crate::output::list_resolver_rule_associations_output::Builder {
        crate::output::list_resolver_rule_associations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResolverQueryLogConfigsOutput {
    /// <p>If there are more than <code>MaxResults</code> query logging configurations, you can submit another <code>ListResolverQueryLogConfigs</code> request
    /// to get the next group of configurations. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The total number of query logging configurations that were created by the current account in the specified Region. This count can differ from the
    /// number of query logging configurations that are returned in a <code>ListResolverQueryLogConfigs</code> response, depending on the values that you specify
    /// in the request.</p>
    pub total_count: i32,
    /// <p>The total number of query logging configurations that were created by the current account in the specified Region and that match the filters
    /// that were specified in the <code>ListResolverQueryLogConfigs</code> request. For the total number of query logging configurations that were created by the
    /// current account in the specified Region, see <code>TotalCount</code>.</p>
    pub total_filtered_count: i32,
    /// <p>A list that contains one <code>ResolverQueryLogConfig</code> element for each query logging configuration that matches the
    /// values that you specified for <code>Filter</code>.</p>
    pub resolver_query_log_configs:
        std::option::Option<std::vec::Vec<crate::model::ResolverQueryLogConfig>>,
}
impl std::fmt::Debug for ListResolverQueryLogConfigsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResolverQueryLogConfigsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("total_count", &self.total_count);
        formatter.field("total_filtered_count", &self.total_filtered_count);
        formatter.field(
            "resolver_query_log_configs",
            &self.resolver_query_log_configs,
        );
        formatter.finish()
    }
}
/// See [`ListResolverQueryLogConfigsOutput`](crate::output::ListResolverQueryLogConfigsOutput)
pub mod list_resolver_query_log_configs_output {
    /// A builder for [`ListResolverQueryLogConfigsOutput`](crate::output::ListResolverQueryLogConfigsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) total_count: std::option::Option<i32>,
        pub(crate) total_filtered_count: std::option::Option<i32>,
        pub(crate) resolver_query_log_configs:
            std::option::Option<std::vec::Vec<crate::model::ResolverQueryLogConfig>>,
    }
    impl Builder {
        /// <p>If there are more than <code>MaxResults</code> query logging configurations, you can submit another <code>ListResolverQueryLogConfigs</code> request
        /// to get the next group of configurations. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If there are more than <code>MaxResults</code> query logging configurations, you can submit another <code>ListResolverQueryLogConfigs</code> request
        /// to get the next group of configurations. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The total number of query logging configurations that were created by the current account in the specified Region. This count can differ from the
        /// number of query logging configurations that are returned in a <code>ListResolverQueryLogConfigs</code> response, depending on the values that you specify
        /// in the request.</p>
        pub fn total_count(mut self, input: i32) -> Self {
            self.total_count = Some(input);
            self
        }
        /// <p>The total number of query logging configurations that were created by the current account in the specified Region. This count can differ from the
        /// number of query logging configurations that are returned in a <code>ListResolverQueryLogConfigs</code> response, depending on the values that you specify
        /// in the request.</p>
        pub fn set_total_count(mut self, input: std::option::Option<i32>) -> Self {
            self.total_count = input;
            self
        }
        /// <p>The total number of query logging configurations that were created by the current account in the specified Region and that match the filters
        /// that were specified in the <code>ListResolverQueryLogConfigs</code> request. For the total number of query logging configurations that were created by the
        /// current account in the specified Region, see <code>TotalCount</code>.</p>
        pub fn total_filtered_count(mut self, input: i32) -> Self {
            self.total_filtered_count = Some(input);
            self
        }
        /// <p>The total number of query logging configurations that were created by the current account in the specified Region and that match the filters
        /// that were specified in the <code>ListResolverQueryLogConfigs</code> request. For the total number of query logging configurations that were created by the
        /// current account in the specified Region, see <code>TotalCount</code>.</p>
        pub fn set_total_filtered_count(mut self, input: std::option::Option<i32>) -> Self {
            self.total_filtered_count = input;
            self
        }
        /// Appends an item to `resolver_query_log_configs`.
        ///
        /// To override the contents of this collection use [`set_resolver_query_log_configs`](Self::set_resolver_query_log_configs).
        ///
        /// <p>A list that contains one <code>ResolverQueryLogConfig</code> element for each query logging configuration that matches the
        /// values that you specified for <code>Filter</code>.</p>
        pub fn resolver_query_log_configs(
            mut self,
            input: impl Into<crate::model::ResolverQueryLogConfig>,
        ) -> Self {
            let mut v = self.resolver_query_log_configs.unwrap_or_default();
            v.push(input.into());
            self.resolver_query_log_configs = Some(v);
            self
        }
        /// <p>A list that contains one <code>ResolverQueryLogConfig</code> element for each query logging configuration that matches the
        /// values that you specified for <code>Filter</code>.</p>
        pub fn set_resolver_query_log_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResolverQueryLogConfig>>,
        ) -> Self {
            self.resolver_query_log_configs = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResolverQueryLogConfigsOutput`](crate::output::ListResolverQueryLogConfigsOutput)
        pub fn build(self) -> crate::output::ListResolverQueryLogConfigsOutput {
            crate::output::ListResolverQueryLogConfigsOutput {
                next_token: self.next_token,
                total_count: self.total_count.unwrap_or_default(),
                total_filtered_count: self.total_filtered_count.unwrap_or_default(),
                resolver_query_log_configs: self.resolver_query_log_configs,
            }
        }
    }
}
impl ListResolverQueryLogConfigsOutput {
    /// Creates a new builder-style object to manufacture [`ListResolverQueryLogConfigsOutput`](crate::output::ListResolverQueryLogConfigsOutput)
    pub fn builder() -> crate::output::list_resolver_query_log_configs_output::Builder {
        crate::output::list_resolver_query_log_configs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResolverQueryLogConfigAssociationsOutput {
    /// <p>If there are more than <code>MaxResults</code> query logging associations, you can submit another <code>ListResolverQueryLogConfigAssociations</code> request
    /// to get the next group of associations. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The total number of query logging associations that were created by the current account in the specified Region. This count can differ from the
    /// number of associations that are returned in a <code>ListResolverQueryLogConfigAssociations</code> response, depending on the values that you specify
    /// in the request.</p>
    pub total_count: i32,
    /// <p>The total number of query logging associations that were created by the current account in the specified Region and that match the filters
    /// that were specified in the <code>ListResolverQueryLogConfigAssociations</code> request. For the total number of associations that were created by the
    /// current account in the specified Region, see <code>TotalCount</code>.</p>
    pub total_filtered_count: i32,
    /// <p>A list that contains one <code>ResolverQueryLogConfigAssociations</code> element for each query logging association that matches the
    /// values that you specified for <code>Filter</code>.</p>
    pub resolver_query_log_config_associations:
        std::option::Option<std::vec::Vec<crate::model::ResolverQueryLogConfigAssociation>>,
}
impl std::fmt::Debug for ListResolverQueryLogConfigAssociationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResolverQueryLogConfigAssociationsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("total_count", &self.total_count);
        formatter.field("total_filtered_count", &self.total_filtered_count);
        formatter.field(
            "resolver_query_log_config_associations",
            &self.resolver_query_log_config_associations,
        );
        formatter.finish()
    }
}
/// See [`ListResolverQueryLogConfigAssociationsOutput`](crate::output::ListResolverQueryLogConfigAssociationsOutput)
pub mod list_resolver_query_log_config_associations_output {
    /// A builder for [`ListResolverQueryLogConfigAssociationsOutput`](crate::output::ListResolverQueryLogConfigAssociationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) total_count: std::option::Option<i32>,
        pub(crate) total_filtered_count: std::option::Option<i32>,
        pub(crate) resolver_query_log_config_associations:
            std::option::Option<std::vec::Vec<crate::model::ResolverQueryLogConfigAssociation>>,
    }
    impl Builder {
        /// <p>If there are more than <code>MaxResults</code> query logging associations, you can submit another <code>ListResolverQueryLogConfigAssociations</code> request
        /// to get the next group of associations. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If there are more than <code>MaxResults</code> query logging associations, you can submit another <code>ListResolverQueryLogConfigAssociations</code> request
        /// to get the next group of associations. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The total number of query logging associations that were created by the current account in the specified Region. This count can differ from the
        /// number of associations that are returned in a <code>ListResolverQueryLogConfigAssociations</code> response, depending on the values that you specify
        /// in the request.</p>
        pub fn total_count(mut self, input: i32) -> Self {
            self.total_count = Some(input);
            self
        }
        /// <p>The total number of query logging associations that were created by the current account in the specified Region. This count can differ from the
        /// number of associations that are returned in a <code>ListResolverQueryLogConfigAssociations</code> response, depending on the values that you specify
        /// in the request.</p>
        pub fn set_total_count(mut self, input: std::option::Option<i32>) -> Self {
            self.total_count = input;
            self
        }
        /// <p>The total number of query logging associations that were created by the current account in the specified Region and that match the filters
        /// that were specified in the <code>ListResolverQueryLogConfigAssociations</code> request. For the total number of associations that were created by the
        /// current account in the specified Region, see <code>TotalCount</code>.</p>
        pub fn total_filtered_count(mut self, input: i32) -> Self {
            self.total_filtered_count = Some(input);
            self
        }
        /// <p>The total number of query logging associations that were created by the current account in the specified Region and that match the filters
        /// that were specified in the <code>ListResolverQueryLogConfigAssociations</code> request. For the total number of associations that were created by the
        /// current account in the specified Region, see <code>TotalCount</code>.</p>
        pub fn set_total_filtered_count(mut self, input: std::option::Option<i32>) -> Self {
            self.total_filtered_count = input;
            self
        }
        /// Appends an item to `resolver_query_log_config_associations`.
        ///
        /// To override the contents of this collection use [`set_resolver_query_log_config_associations`](Self::set_resolver_query_log_config_associations).
        ///
        /// <p>A list that contains one <code>ResolverQueryLogConfigAssociations</code> element for each query logging association that matches the
        /// values that you specified for <code>Filter</code>.</p>
        pub fn resolver_query_log_config_associations(
            mut self,
            input: impl Into<crate::model::ResolverQueryLogConfigAssociation>,
        ) -> Self {
            let mut v = self
                .resolver_query_log_config_associations
                .unwrap_or_default();
            v.push(input.into());
            self.resolver_query_log_config_associations = Some(v);
            self
        }
        /// <p>A list that contains one <code>ResolverQueryLogConfigAssociations</code> element for each query logging association that matches the
        /// values that you specified for <code>Filter</code>.</p>
        pub fn set_resolver_query_log_config_associations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ResolverQueryLogConfigAssociation>,
            >,
        ) -> Self {
            self.resolver_query_log_config_associations = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResolverQueryLogConfigAssociationsOutput`](crate::output::ListResolverQueryLogConfigAssociationsOutput)
        pub fn build(self) -> crate::output::ListResolverQueryLogConfigAssociationsOutput {
            crate::output::ListResolverQueryLogConfigAssociationsOutput {
                next_token: self.next_token,
                total_count: self.total_count.unwrap_or_default(),
                total_filtered_count: self.total_filtered_count.unwrap_or_default(),
                resolver_query_log_config_associations: self.resolver_query_log_config_associations,
            }
        }
    }
}
impl ListResolverQueryLogConfigAssociationsOutput {
    /// Creates a new builder-style object to manufacture [`ListResolverQueryLogConfigAssociationsOutput`](crate::output::ListResolverQueryLogConfigAssociationsOutput)
    pub fn builder() -> crate::output::list_resolver_query_log_config_associations_output::Builder {
        crate::output::list_resolver_query_log_config_associations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResolverEndpointsOutput {
    /// <p>If more than <code>MaxResults</code> IP addresses match the specified criteria, you can submit another <code>ListResolverEndpoint</code> request
    /// to get the next group of results. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The value that you specified for <code>MaxResults</code> in the request.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The Resolver endpoints that were created by using the current Amazon Web Services account, and that match the specified filters, if any.</p>
    pub resolver_endpoints: std::option::Option<std::vec::Vec<crate::model::ResolverEndpoint>>,
}
impl std::fmt::Debug for ListResolverEndpointsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResolverEndpointsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("resolver_endpoints", &self.resolver_endpoints);
        formatter.finish()
    }
}
/// See [`ListResolverEndpointsOutput`](crate::output::ListResolverEndpointsOutput)
pub mod list_resolver_endpoints_output {
    /// A builder for [`ListResolverEndpointsOutput`](crate::output::ListResolverEndpointsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) resolver_endpoints:
            std::option::Option<std::vec::Vec<crate::model::ResolverEndpoint>>,
    }
    impl Builder {
        /// <p>If more than <code>MaxResults</code> IP addresses match the specified criteria, you can submit another <code>ListResolverEndpoint</code> request
        /// to get the next group of results. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If more than <code>MaxResults</code> IP addresses match the specified criteria, you can submit another <code>ListResolverEndpoint</code> request
        /// to get the next group of results. In the next request, specify the value of <code>NextToken</code> from the previous response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The value that you specified for <code>MaxResults</code> in the request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The value that you specified for <code>MaxResults</code> in the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Appends an item to `resolver_endpoints`.
        ///
        /// To override the contents of this collection use [`set_resolver_endpoints`](Self::set_resolver_endpoints).
        ///
        /// <p>The Resolver endpoints that were created by using the current Amazon Web Services account, and that match the specified filters, if any.</p>
        pub fn resolver_endpoints(
            mut self,
            input: impl Into<crate::model::ResolverEndpoint>,
        ) -> Self {
            let mut v = self.resolver_endpoints.unwrap_or_default();
            v.push(input.into());
            self.resolver_endpoints = Some(v);
            self
        }
        /// <p>The Resolver endpoints that were created by using the current Amazon Web Services account, and that match the specified filters, if any.</p>
        pub fn set_resolver_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResolverEndpoint>>,
        ) -> Self {
            self.resolver_endpoints = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResolverEndpointsOutput`](crate::output::ListResolverEndpointsOutput)
        pub fn build(self) -> crate::output::ListResolverEndpointsOutput {
            crate::output::ListResolverEndpointsOutput {
                next_token: self.next_token,
                max_results: self.max_results,
                resolver_endpoints: self.resolver_endpoints,
            }
        }
    }
}
impl ListResolverEndpointsOutput {
    /// Creates a new builder-style object to manufacture [`ListResolverEndpointsOutput`](crate::output::ListResolverEndpointsOutput)
    pub fn builder() -> crate::output::list_resolver_endpoints_output::Builder {
        crate::output::list_resolver_endpoints_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResolverEndpointIpAddressesOutput {
    /// <p>If the specified endpoint has more than <code>MaxResults</code> IP addresses, you can submit another
    /// <code>ListResolverEndpointIpAddresses</code> request to get the next group of IP addresses. In the next request,
    /// specify the value of <code>NextToken</code> from the previous response. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The value that you specified for <code>MaxResults</code> in the request.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Information about the IP addresses in your VPC that DNS queries originate from (for outbound endpoints) or that you forward
    /// DNS queries to (for inbound endpoints).</p>
    pub ip_addresses: std::option::Option<std::vec::Vec<crate::model::IpAddressResponse>>,
}
impl std::fmt::Debug for ListResolverEndpointIpAddressesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResolverEndpointIpAddressesOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("ip_addresses", &self.ip_addresses);
        formatter.finish()
    }
}
/// See [`ListResolverEndpointIpAddressesOutput`](crate::output::ListResolverEndpointIpAddressesOutput)
pub mod list_resolver_endpoint_ip_addresses_output {
    /// A builder for [`ListResolverEndpointIpAddressesOutput`](crate::output::ListResolverEndpointIpAddressesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) ip_addresses:
            std::option::Option<std::vec::Vec<crate::model::IpAddressResponse>>,
    }
    impl Builder {
        /// <p>If the specified endpoint has more than <code>MaxResults</code> IP addresses, you can submit another
        /// <code>ListResolverEndpointIpAddresses</code> request to get the next group of IP addresses. In the next request,
        /// specify the value of <code>NextToken</code> from the previous response. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the specified endpoint has more than <code>MaxResults</code> IP addresses, you can submit another
        /// <code>ListResolverEndpointIpAddresses</code> request to get the next group of IP addresses. In the next request,
        /// specify the value of <code>NextToken</code> from the previous response. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The value that you specified for <code>MaxResults</code> in the request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The value that you specified for <code>MaxResults</code> in the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Appends an item to `ip_addresses`.
        ///
        /// To override the contents of this collection use [`set_ip_addresses`](Self::set_ip_addresses).
        ///
        /// <p>Information about the IP addresses in your VPC that DNS queries originate from (for outbound endpoints) or that you forward
        /// DNS queries to (for inbound endpoints).</p>
        pub fn ip_addresses(mut self, input: impl Into<crate::model::IpAddressResponse>) -> Self {
            let mut v = self.ip_addresses.unwrap_or_default();
            v.push(input.into());
            self.ip_addresses = Some(v);
            self
        }
        /// <p>Information about the IP addresses in your VPC that DNS queries originate from (for outbound endpoints) or that you forward
        /// DNS queries to (for inbound endpoints).</p>
        pub fn set_ip_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IpAddressResponse>>,
        ) -> Self {
            self.ip_addresses = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResolverEndpointIpAddressesOutput`](crate::output::ListResolverEndpointIpAddressesOutput)
        pub fn build(self) -> crate::output::ListResolverEndpointIpAddressesOutput {
            crate::output::ListResolverEndpointIpAddressesOutput {
                next_token: self.next_token,
                max_results: self.max_results,
                ip_addresses: self.ip_addresses,
            }
        }
    }
}
impl ListResolverEndpointIpAddressesOutput {
    /// Creates a new builder-style object to manufacture [`ListResolverEndpointIpAddressesOutput`](crate::output::ListResolverEndpointIpAddressesOutput)
    pub fn builder() -> crate::output::list_resolver_endpoint_ip_addresses_output::Builder {
        crate::output::list_resolver_endpoint_ip_addresses_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResolverDnssecConfigsOutput {
    /// <p>If a response includes the last of the DNSSEC configurations that are associated with the current Amazon Web Services account,
    /// <code>NextToken</code> doesn't appear in the response.</p>
    /// <p>If a response doesn't include the last of the configurations, you can get more configurations by submitting another
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListResolverDnssecConfigs.html">ListResolverDnssecConfigs</a>
    /// request. Get the value of <code>NextToken</code> that Amazon Route 53 returned in the previous response and include it in
    /// <code>NextToken</code> in the next request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An array that contains one
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ResolverDnssecConfig.html">ResolverDnssecConfig</a> element
    /// for each configuration for DNSSEC validation that is associated with the current Amazon Web Services account.</p>
    pub resolver_dnssec_configs:
        std::option::Option<std::vec::Vec<crate::model::ResolverDnssecConfig>>,
}
impl std::fmt::Debug for ListResolverDnssecConfigsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResolverDnssecConfigsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("resolver_dnssec_configs", &self.resolver_dnssec_configs);
        formatter.finish()
    }
}
/// See [`ListResolverDnssecConfigsOutput`](crate::output::ListResolverDnssecConfigsOutput)
pub mod list_resolver_dnssec_configs_output {
    /// A builder for [`ListResolverDnssecConfigsOutput`](crate::output::ListResolverDnssecConfigsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) resolver_dnssec_configs:
            std::option::Option<std::vec::Vec<crate::model::ResolverDnssecConfig>>,
    }
    impl Builder {
        /// <p>If a response includes the last of the DNSSEC configurations that are associated with the current Amazon Web Services account,
        /// <code>NextToken</code> doesn't appear in the response.</p>
        /// <p>If a response doesn't include the last of the configurations, you can get more configurations by submitting another
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListResolverDnssecConfigs.html">ListResolverDnssecConfigs</a>
        /// request. Get the value of <code>NextToken</code> that Amazon Route 53 returned in the previous response and include it in
        /// <code>NextToken</code> in the next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If a response includes the last of the DNSSEC configurations that are associated with the current Amazon Web Services account,
        /// <code>NextToken</code> doesn't appear in the response.</p>
        /// <p>If a response doesn't include the last of the configurations, you can get more configurations by submitting another
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListResolverDnssecConfigs.html">ListResolverDnssecConfigs</a>
        /// request. Get the value of <code>NextToken</code> that Amazon Route 53 returned in the previous response and include it in
        /// <code>NextToken</code> in the next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `resolver_dnssec_configs`.
        ///
        /// To override the contents of this collection use [`set_resolver_dnssec_configs`](Self::set_resolver_dnssec_configs).
        ///
        /// <p>An array that contains one
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ResolverDnssecConfig.html">ResolverDnssecConfig</a> element
        /// for each configuration for DNSSEC validation that is associated with the current Amazon Web Services account.</p>
        pub fn resolver_dnssec_configs(
            mut self,
            input: impl Into<crate::model::ResolverDnssecConfig>,
        ) -> Self {
            let mut v = self.resolver_dnssec_configs.unwrap_or_default();
            v.push(input.into());
            self.resolver_dnssec_configs = Some(v);
            self
        }
        /// <p>An array that contains one
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ResolverDnssecConfig.html">ResolverDnssecConfig</a> element
        /// for each configuration for DNSSEC validation that is associated with the current Amazon Web Services account.</p>
        pub fn set_resolver_dnssec_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResolverDnssecConfig>>,
        ) -> Self {
            self.resolver_dnssec_configs = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResolverDnssecConfigsOutput`](crate::output::ListResolverDnssecConfigsOutput)
        pub fn build(self) -> crate::output::ListResolverDnssecConfigsOutput {
            crate::output::ListResolverDnssecConfigsOutput {
                next_token: self.next_token,
                resolver_dnssec_configs: self.resolver_dnssec_configs,
            }
        }
    }
}
impl ListResolverDnssecConfigsOutput {
    /// Creates a new builder-style object to manufacture [`ListResolverDnssecConfigsOutput`](crate::output::ListResolverDnssecConfigsOutput)
    pub fn builder() -> crate::output::list_resolver_dnssec_configs_output::Builder {
        crate::output::list_resolver_dnssec_configs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFirewallRulesOutput {
    /// <p>If objects are still available for retrieval, Resolver returns this token in the response.
    /// To retrieve the next batch of objects, provide this token in your next request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A list of the rules that you have defined.  </p>
    /// <p>This might be a partial list of the firewall rules that you've defined. For information,
    /// see <code>MaxResults</code>. </p>
    pub firewall_rules: std::option::Option<std::vec::Vec<crate::model::FirewallRule>>,
}
impl std::fmt::Debug for ListFirewallRulesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFirewallRulesOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("firewall_rules", &self.firewall_rules);
        formatter.finish()
    }
}
/// See [`ListFirewallRulesOutput`](crate::output::ListFirewallRulesOutput)
pub mod list_firewall_rules_output {
    /// A builder for [`ListFirewallRulesOutput`](crate::output::ListFirewallRulesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) firewall_rules: std::option::Option<std::vec::Vec<crate::model::FirewallRule>>,
    }
    impl Builder {
        /// <p>If objects are still available for retrieval, Resolver returns this token in the response.
        /// To retrieve the next batch of objects, provide this token in your next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If objects are still available for retrieval, Resolver returns this token in the response.
        /// To retrieve the next batch of objects, provide this token in your next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `firewall_rules`.
        ///
        /// To override the contents of this collection use [`set_firewall_rules`](Self::set_firewall_rules).
        ///
        /// <p>A list of the rules that you have defined.  </p>
        /// <p>This might be a partial list of the firewall rules that you've defined. For information,
        /// see <code>MaxResults</code>. </p>
        pub fn firewall_rules(mut self, input: impl Into<crate::model::FirewallRule>) -> Self {
            let mut v = self.firewall_rules.unwrap_or_default();
            v.push(input.into());
            self.firewall_rules = Some(v);
            self
        }
        /// <p>A list of the rules that you have defined.  </p>
        /// <p>This might be a partial list of the firewall rules that you've defined. For information,
        /// see <code>MaxResults</code>. </p>
        pub fn set_firewall_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FirewallRule>>,
        ) -> Self {
            self.firewall_rules = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFirewallRulesOutput`](crate::output::ListFirewallRulesOutput)
        pub fn build(self) -> crate::output::ListFirewallRulesOutput {
            crate::output::ListFirewallRulesOutput {
                next_token: self.next_token,
                firewall_rules: self.firewall_rules,
            }
        }
    }
}
impl ListFirewallRulesOutput {
    /// Creates a new builder-style object to manufacture [`ListFirewallRulesOutput`](crate::output::ListFirewallRulesOutput)
    pub fn builder() -> crate::output::list_firewall_rules_output::Builder {
        crate::output::list_firewall_rules_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFirewallRuleGroupsOutput {
    /// <p>If objects are still available for retrieval, Resolver returns this token in the response.
    /// To retrieve the next batch of objects, provide this token in your next request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A list of your firewall rule groups.</p>
    /// <p>This might be a partial list of the rule groups that you have defined. For information, see <code>MaxResults</code>. </p>
    pub firewall_rule_groups:
        std::option::Option<std::vec::Vec<crate::model::FirewallRuleGroupMetadata>>,
}
impl std::fmt::Debug for ListFirewallRuleGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFirewallRuleGroupsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("firewall_rule_groups", &self.firewall_rule_groups);
        formatter.finish()
    }
}
/// See [`ListFirewallRuleGroupsOutput`](crate::output::ListFirewallRuleGroupsOutput)
pub mod list_firewall_rule_groups_output {
    /// A builder for [`ListFirewallRuleGroupsOutput`](crate::output::ListFirewallRuleGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) firewall_rule_groups:
            std::option::Option<std::vec::Vec<crate::model::FirewallRuleGroupMetadata>>,
    }
    impl Builder {
        /// <p>If objects are still available for retrieval, Resolver returns this token in the response.
        /// To retrieve the next batch of objects, provide this token in your next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If objects are still available for retrieval, Resolver returns this token in the response.
        /// To retrieve the next batch of objects, provide this token in your next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `firewall_rule_groups`.
        ///
        /// To override the contents of this collection use [`set_firewall_rule_groups`](Self::set_firewall_rule_groups).
        ///
        /// <p>A list of your firewall rule groups.</p>
        /// <p>This might be a partial list of the rule groups that you have defined. For information, see <code>MaxResults</code>. </p>
        pub fn firewall_rule_groups(
            mut self,
            input: impl Into<crate::model::FirewallRuleGroupMetadata>,
        ) -> Self {
            let mut v = self.firewall_rule_groups.unwrap_or_default();
            v.push(input.into());
            self.firewall_rule_groups = Some(v);
            self
        }
        /// <p>A list of your firewall rule groups.</p>
        /// <p>This might be a partial list of the rule groups that you have defined. For information, see <code>MaxResults</code>. </p>
        pub fn set_firewall_rule_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FirewallRuleGroupMetadata>>,
        ) -> Self {
            self.firewall_rule_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFirewallRuleGroupsOutput`](crate::output::ListFirewallRuleGroupsOutput)
        pub fn build(self) -> crate::output::ListFirewallRuleGroupsOutput {
            crate::output::ListFirewallRuleGroupsOutput {
                next_token: self.next_token,
                firewall_rule_groups: self.firewall_rule_groups,
            }
        }
    }
}
impl ListFirewallRuleGroupsOutput {
    /// Creates a new builder-style object to manufacture [`ListFirewallRuleGroupsOutput`](crate::output::ListFirewallRuleGroupsOutput)
    pub fn builder() -> crate::output::list_firewall_rule_groups_output::Builder {
        crate::output::list_firewall_rule_groups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFirewallRuleGroupAssociationsOutput {
    /// <p>If objects are still available for retrieval, Resolver returns this token in the response.
    /// To retrieve the next batch of objects, provide this token in your next request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A list of your firewall rule group associations.</p>
    /// <p>This might be a partial list of the associations that you have defined. For information, see <code>MaxResults</code>. </p>
    pub firewall_rule_group_associations:
        std::option::Option<std::vec::Vec<crate::model::FirewallRuleGroupAssociation>>,
}
impl std::fmt::Debug for ListFirewallRuleGroupAssociationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFirewallRuleGroupAssociationsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field(
            "firewall_rule_group_associations",
            &self.firewall_rule_group_associations,
        );
        formatter.finish()
    }
}
/// See [`ListFirewallRuleGroupAssociationsOutput`](crate::output::ListFirewallRuleGroupAssociationsOutput)
pub mod list_firewall_rule_group_associations_output {
    /// A builder for [`ListFirewallRuleGroupAssociationsOutput`](crate::output::ListFirewallRuleGroupAssociationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) firewall_rule_group_associations:
            std::option::Option<std::vec::Vec<crate::model::FirewallRuleGroupAssociation>>,
    }
    impl Builder {
        /// <p>If objects are still available for retrieval, Resolver returns this token in the response.
        /// To retrieve the next batch of objects, provide this token in your next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If objects are still available for retrieval, Resolver returns this token in the response.
        /// To retrieve the next batch of objects, provide this token in your next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `firewall_rule_group_associations`.
        ///
        /// To override the contents of this collection use [`set_firewall_rule_group_associations`](Self::set_firewall_rule_group_associations).
        ///
        /// <p>A list of your firewall rule group associations.</p>
        /// <p>This might be a partial list of the associations that you have defined. For information, see <code>MaxResults</code>. </p>
        pub fn firewall_rule_group_associations(
            mut self,
            input: impl Into<crate::model::FirewallRuleGroupAssociation>,
        ) -> Self {
            let mut v = self.firewall_rule_group_associations.unwrap_or_default();
            v.push(input.into());
            self.firewall_rule_group_associations = Some(v);
            self
        }
        /// <p>A list of your firewall rule group associations.</p>
        /// <p>This might be a partial list of the associations that you have defined. For information, see <code>MaxResults</code>. </p>
        pub fn set_firewall_rule_group_associations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FirewallRuleGroupAssociation>>,
        ) -> Self {
            self.firewall_rule_group_associations = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFirewallRuleGroupAssociationsOutput`](crate::output::ListFirewallRuleGroupAssociationsOutput)
        pub fn build(self) -> crate::output::ListFirewallRuleGroupAssociationsOutput {
            crate::output::ListFirewallRuleGroupAssociationsOutput {
                next_token: self.next_token,
                firewall_rule_group_associations: self.firewall_rule_group_associations,
            }
        }
    }
}
impl ListFirewallRuleGroupAssociationsOutput {
    /// Creates a new builder-style object to manufacture [`ListFirewallRuleGroupAssociationsOutput`](crate::output::ListFirewallRuleGroupAssociationsOutput)
    pub fn builder() -> crate::output::list_firewall_rule_group_associations_output::Builder {
        crate::output::list_firewall_rule_group_associations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFirewallDomainsOutput {
    /// <p>If objects are still available for retrieval, Resolver returns this token in the response.
    /// To retrieve the next batch of objects, provide this token in your next request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A list of the domains in the firewall domain list.  </p>
    /// <p>This might be a partial list of the domains that you've defined in the domain list. For
    /// information, see <code>MaxResults</code>. </p>
    pub domains: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for ListFirewallDomainsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFirewallDomainsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("domains", &self.domains);
        formatter.finish()
    }
}
/// See [`ListFirewallDomainsOutput`](crate::output::ListFirewallDomainsOutput)
pub mod list_firewall_domains_output {
    /// A builder for [`ListFirewallDomainsOutput`](crate::output::ListFirewallDomainsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) domains: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>If objects are still available for retrieval, Resolver returns this token in the response.
        /// To retrieve the next batch of objects, provide this token in your next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If objects are still available for retrieval, Resolver returns this token in the response.
        /// To retrieve the next batch of objects, provide this token in your next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `domains`.
        ///
        /// To override the contents of this collection use [`set_domains`](Self::set_domains).
        ///
        /// <p>A list of the domains in the firewall domain list.  </p>
        /// <p>This might be a partial list of the domains that you've defined in the domain list. For
        /// information, see <code>MaxResults</code>. </p>
        pub fn domains(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.domains.unwrap_or_default();
            v.push(input.into());
            self.domains = Some(v);
            self
        }
        /// <p>A list of the domains in the firewall domain list.  </p>
        /// <p>This might be a partial list of the domains that you've defined in the domain list. For
        /// information, see <code>MaxResults</code>. </p>
        pub fn set_domains(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.domains = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFirewallDomainsOutput`](crate::output::ListFirewallDomainsOutput)
        pub fn build(self) -> crate::output::ListFirewallDomainsOutput {
            crate::output::ListFirewallDomainsOutput {
                next_token: self.next_token,
                domains: self.domains,
            }
        }
    }
}
impl ListFirewallDomainsOutput {
    /// Creates a new builder-style object to manufacture [`ListFirewallDomainsOutput`](crate::output::ListFirewallDomainsOutput)
    pub fn builder() -> crate::output::list_firewall_domains_output::Builder {
        crate::output::list_firewall_domains_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFirewallDomainListsOutput {
    /// <p>If objects are still available for retrieval, Resolver returns this token in the response.
    /// To retrieve the next batch of objects, provide this token in your next request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A list of the domain lists that you have defined.   </p>
    /// <p>This might be a partial list of the domain lists that you've defined. For information,
    /// see <code>MaxResults</code>. </p>
    pub firewall_domain_lists:
        std::option::Option<std::vec::Vec<crate::model::FirewallDomainListMetadata>>,
}
impl std::fmt::Debug for ListFirewallDomainListsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFirewallDomainListsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("firewall_domain_lists", &self.firewall_domain_lists);
        formatter.finish()
    }
}
/// See [`ListFirewallDomainListsOutput`](crate::output::ListFirewallDomainListsOutput)
pub mod list_firewall_domain_lists_output {
    /// A builder for [`ListFirewallDomainListsOutput`](crate::output::ListFirewallDomainListsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) firewall_domain_lists:
            std::option::Option<std::vec::Vec<crate::model::FirewallDomainListMetadata>>,
    }
    impl Builder {
        /// <p>If objects are still available for retrieval, Resolver returns this token in the response.
        /// To retrieve the next batch of objects, provide this token in your next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If objects are still available for retrieval, Resolver returns this token in the response.
        /// To retrieve the next batch of objects, provide this token in your next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `firewall_domain_lists`.
        ///
        /// To override the contents of this collection use [`set_firewall_domain_lists`](Self::set_firewall_domain_lists).
        ///
        /// <p>A list of the domain lists that you have defined.   </p>
        /// <p>This might be a partial list of the domain lists that you've defined. For information,
        /// see <code>MaxResults</code>. </p>
        pub fn firewall_domain_lists(
            mut self,
            input: impl Into<crate::model::FirewallDomainListMetadata>,
        ) -> Self {
            let mut v = self.firewall_domain_lists.unwrap_or_default();
            v.push(input.into());
            self.firewall_domain_lists = Some(v);
            self
        }
        /// <p>A list of the domain lists that you have defined.   </p>
        /// <p>This might be a partial list of the domain lists that you've defined. For information,
        /// see <code>MaxResults</code>. </p>
        pub fn set_firewall_domain_lists(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FirewallDomainListMetadata>>,
        ) -> Self {
            self.firewall_domain_lists = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFirewallDomainListsOutput`](crate::output::ListFirewallDomainListsOutput)
        pub fn build(self) -> crate::output::ListFirewallDomainListsOutput {
            crate::output::ListFirewallDomainListsOutput {
                next_token: self.next_token,
                firewall_domain_lists: self.firewall_domain_lists,
            }
        }
    }
}
impl ListFirewallDomainListsOutput {
    /// Creates a new builder-style object to manufacture [`ListFirewallDomainListsOutput`](crate::output::ListFirewallDomainListsOutput)
    pub fn builder() -> crate::output::list_firewall_domain_lists_output::Builder {
        crate::output::list_firewall_domain_lists_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFirewallConfigsOutput {
    /// <p>If objects are still available for retrieval, Resolver returns this token in the response.
    /// To retrieve the next batch of objects, provide this token in your next request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The configurations for the firewall behavior provided by DNS Firewall for VPCs from
    /// Amazon Virtual Private Cloud (Amazon VPC). </p>
    pub firewall_configs: std::option::Option<std::vec::Vec<crate::model::FirewallConfig>>,
}
impl std::fmt::Debug for ListFirewallConfigsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFirewallConfigsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("firewall_configs", &self.firewall_configs);
        formatter.finish()
    }
}
/// See [`ListFirewallConfigsOutput`](crate::output::ListFirewallConfigsOutput)
pub mod list_firewall_configs_output {
    /// A builder for [`ListFirewallConfigsOutput`](crate::output::ListFirewallConfigsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) firewall_configs:
            std::option::Option<std::vec::Vec<crate::model::FirewallConfig>>,
    }
    impl Builder {
        /// <p>If objects are still available for retrieval, Resolver returns this token in the response.
        /// To retrieve the next batch of objects, provide this token in your next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If objects are still available for retrieval, Resolver returns this token in the response.
        /// To retrieve the next batch of objects, provide this token in your next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `firewall_configs`.
        ///
        /// To override the contents of this collection use [`set_firewall_configs`](Self::set_firewall_configs).
        ///
        /// <p>The configurations for the firewall behavior provided by DNS Firewall for VPCs from
        /// Amazon Virtual Private Cloud (Amazon VPC). </p>
        pub fn firewall_configs(mut self, input: impl Into<crate::model::FirewallConfig>) -> Self {
            let mut v = self.firewall_configs.unwrap_or_default();
            v.push(input.into());
            self.firewall_configs = Some(v);
            self
        }
        /// <p>The configurations for the firewall behavior provided by DNS Firewall for VPCs from
        /// Amazon Virtual Private Cloud (Amazon VPC). </p>
        pub fn set_firewall_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FirewallConfig>>,
        ) -> Self {
            self.firewall_configs = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFirewallConfigsOutput`](crate::output::ListFirewallConfigsOutput)
        pub fn build(self) -> crate::output::ListFirewallConfigsOutput {
            crate::output::ListFirewallConfigsOutput {
                next_token: self.next_token,
                firewall_configs: self.firewall_configs,
            }
        }
    }
}
impl ListFirewallConfigsOutput {
    /// Creates a new builder-style object to manufacture [`ListFirewallConfigsOutput`](crate::output::ListFirewallConfigsOutput)
    pub fn builder() -> crate::output::list_firewall_configs_output::Builder {
        crate::output::list_firewall_configs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportFirewallDomainsOutput {
    /// <p>The Id of the firewall domain list that DNS Firewall just updated.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the domain list. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> </p>
    pub status: std::option::Option<crate::model::FirewallDomainListStatus>,
    /// <p>Additional information about the status of the list, if available.</p>
    pub status_message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ImportFirewallDomainsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportFirewallDomainsOutput");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.finish()
    }
}
/// See [`ImportFirewallDomainsOutput`](crate::output::ImportFirewallDomainsOutput)
pub mod import_firewall_domains_output {
    /// A builder for [`ImportFirewallDomainsOutput`](crate::output::ImportFirewallDomainsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::FirewallDomainListStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Id of the firewall domain list that DNS Firewall just updated.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The Id of the firewall domain list that DNS Firewall just updated.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the domain list. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the domain list. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> </p>
        pub fn status(mut self, input: crate::model::FirewallDomainListStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::FirewallDomainListStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Additional information about the status of the list, if available.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>Additional information about the status of the list, if available.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportFirewallDomainsOutput`](crate::output::ImportFirewallDomainsOutput)
        pub fn build(self) -> crate::output::ImportFirewallDomainsOutput {
            crate::output::ImportFirewallDomainsOutput {
                id: self.id,
                name: self.name,
                status: self.status,
                status_message: self.status_message,
            }
        }
    }
}
impl ImportFirewallDomainsOutput {
    /// Creates a new builder-style object to manufacture [`ImportFirewallDomainsOutput`](crate::output::ImportFirewallDomainsOutput)
    pub fn builder() -> crate::output::import_firewall_domains_output::Builder {
        crate::output::import_firewall_domains_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResolverRulePolicyOutput {
    /// <p>The Resolver rule policy for the rule that you specified in a <code>GetResolverRulePolicy</code> request.</p>
    pub resolver_rule_policy: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetResolverRulePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResolverRulePolicyOutput");
        formatter.field("resolver_rule_policy", &self.resolver_rule_policy);
        formatter.finish()
    }
}
/// See [`GetResolverRulePolicyOutput`](crate::output::GetResolverRulePolicyOutput)
pub mod get_resolver_rule_policy_output {
    /// A builder for [`GetResolverRulePolicyOutput`](crate::output::GetResolverRulePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resolver_rule_policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Resolver rule policy for the rule that you specified in a <code>GetResolverRulePolicy</code> request.</p>
        pub fn resolver_rule_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.resolver_rule_policy = Some(input.into());
            self
        }
        /// <p>The Resolver rule policy for the rule that you specified in a <code>GetResolverRulePolicy</code> request.</p>
        pub fn set_resolver_rule_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resolver_rule_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResolverRulePolicyOutput`](crate::output::GetResolverRulePolicyOutput)
        pub fn build(self) -> crate::output::GetResolverRulePolicyOutput {
            crate::output::GetResolverRulePolicyOutput {
                resolver_rule_policy: self.resolver_rule_policy,
            }
        }
    }
}
impl GetResolverRulePolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetResolverRulePolicyOutput`](crate::output::GetResolverRulePolicyOutput)
    pub fn builder() -> crate::output::get_resolver_rule_policy_output::Builder {
        crate::output::get_resolver_rule_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResolverRuleAssociationOutput {
    /// <p>Information about the Resolver rule association that you specified in a <code>GetResolverRuleAssociation</code> request.</p>
    pub resolver_rule_association: std::option::Option<crate::model::ResolverRuleAssociation>,
}
impl std::fmt::Debug for GetResolverRuleAssociationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResolverRuleAssociationOutput");
        formatter.field("resolver_rule_association", &self.resolver_rule_association);
        formatter.finish()
    }
}
/// See [`GetResolverRuleAssociationOutput`](crate::output::GetResolverRuleAssociationOutput)
pub mod get_resolver_rule_association_output {
    /// A builder for [`GetResolverRuleAssociationOutput`](crate::output::GetResolverRuleAssociationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resolver_rule_association:
            std::option::Option<crate::model::ResolverRuleAssociation>,
    }
    impl Builder {
        /// <p>Information about the Resolver rule association that you specified in a <code>GetResolverRuleAssociation</code> request.</p>
        pub fn resolver_rule_association(
            mut self,
            input: crate::model::ResolverRuleAssociation,
        ) -> Self {
            self.resolver_rule_association = Some(input);
            self
        }
        /// <p>Information about the Resolver rule association that you specified in a <code>GetResolverRuleAssociation</code> request.</p>
        pub fn set_resolver_rule_association(
            mut self,
            input: std::option::Option<crate::model::ResolverRuleAssociation>,
        ) -> Self {
            self.resolver_rule_association = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResolverRuleAssociationOutput`](crate::output::GetResolverRuleAssociationOutput)
        pub fn build(self) -> crate::output::GetResolverRuleAssociationOutput {
            crate::output::GetResolverRuleAssociationOutput {
                resolver_rule_association: self.resolver_rule_association,
            }
        }
    }
}
impl GetResolverRuleAssociationOutput {
    /// Creates a new builder-style object to manufacture [`GetResolverRuleAssociationOutput`](crate::output::GetResolverRuleAssociationOutput)
    pub fn builder() -> crate::output::get_resolver_rule_association_output::Builder {
        crate::output::get_resolver_rule_association_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResolverRuleOutput {
    /// <p>Information about the Resolver rule that you specified in a <code>GetResolverRule</code> request.</p>
    pub resolver_rule: std::option::Option<crate::model::ResolverRule>,
}
impl std::fmt::Debug for GetResolverRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResolverRuleOutput");
        formatter.field("resolver_rule", &self.resolver_rule);
        formatter.finish()
    }
}
/// See [`GetResolverRuleOutput`](crate::output::GetResolverRuleOutput)
pub mod get_resolver_rule_output {
    /// A builder for [`GetResolverRuleOutput`](crate::output::GetResolverRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resolver_rule: std::option::Option<crate::model::ResolverRule>,
    }
    impl Builder {
        /// <p>Information about the Resolver rule that you specified in a <code>GetResolverRule</code> request.</p>
        pub fn resolver_rule(mut self, input: crate::model::ResolverRule) -> Self {
            self.resolver_rule = Some(input);
            self
        }
        /// <p>Information about the Resolver rule that you specified in a <code>GetResolverRule</code> request.</p>
        pub fn set_resolver_rule(
            mut self,
            input: std::option::Option<crate::model::ResolverRule>,
        ) -> Self {
            self.resolver_rule = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResolverRuleOutput`](crate::output::GetResolverRuleOutput)
        pub fn build(self) -> crate::output::GetResolverRuleOutput {
            crate::output::GetResolverRuleOutput {
                resolver_rule: self.resolver_rule,
            }
        }
    }
}
impl GetResolverRuleOutput {
    /// Creates a new builder-style object to manufacture [`GetResolverRuleOutput`](crate::output::GetResolverRuleOutput)
    pub fn builder() -> crate::output::get_resolver_rule_output::Builder {
        crate::output::get_resolver_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResolverQueryLogConfigPolicyOutput {
    /// <p>Information about the query logging policy for the query logging configuration that you specified in a
    /// <code>GetResolverQueryLogConfigPolicy</code> request.</p>
    pub resolver_query_log_config_policy: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetResolverQueryLogConfigPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResolverQueryLogConfigPolicyOutput");
        formatter.field(
            "resolver_query_log_config_policy",
            &self.resolver_query_log_config_policy,
        );
        formatter.finish()
    }
}
/// See [`GetResolverQueryLogConfigPolicyOutput`](crate::output::GetResolverQueryLogConfigPolicyOutput)
pub mod get_resolver_query_log_config_policy_output {
    /// A builder for [`GetResolverQueryLogConfigPolicyOutput`](crate::output::GetResolverQueryLogConfigPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resolver_query_log_config_policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Information about the query logging policy for the query logging configuration that you specified in a
        /// <code>GetResolverQueryLogConfigPolicy</code> request.</p>
        pub fn resolver_query_log_config_policy(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.resolver_query_log_config_policy = Some(input.into());
            self
        }
        /// <p>Information about the query logging policy for the query logging configuration that you specified in a
        /// <code>GetResolverQueryLogConfigPolicy</code> request.</p>
        pub fn set_resolver_query_log_config_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resolver_query_log_config_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResolverQueryLogConfigPolicyOutput`](crate::output::GetResolverQueryLogConfigPolicyOutput)
        pub fn build(self) -> crate::output::GetResolverQueryLogConfigPolicyOutput {
            crate::output::GetResolverQueryLogConfigPolicyOutput {
                resolver_query_log_config_policy: self.resolver_query_log_config_policy,
            }
        }
    }
}
impl GetResolverQueryLogConfigPolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetResolverQueryLogConfigPolicyOutput`](crate::output::GetResolverQueryLogConfigPolicyOutput)
    pub fn builder() -> crate::output::get_resolver_query_log_config_policy_output::Builder {
        crate::output::get_resolver_query_log_config_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResolverQueryLogConfigAssociationOutput {
    /// <p>Information about the Resolver query logging configuration association that you specified in a <code>GetQueryLogConfigAssociation</code> request.</p>
    pub resolver_query_log_config_association:
        std::option::Option<crate::model::ResolverQueryLogConfigAssociation>,
}
impl std::fmt::Debug for GetResolverQueryLogConfigAssociationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResolverQueryLogConfigAssociationOutput");
        formatter.field(
            "resolver_query_log_config_association",
            &self.resolver_query_log_config_association,
        );
        formatter.finish()
    }
}
/// See [`GetResolverQueryLogConfigAssociationOutput`](crate::output::GetResolverQueryLogConfigAssociationOutput)
pub mod get_resolver_query_log_config_association_output {
    /// A builder for [`GetResolverQueryLogConfigAssociationOutput`](crate::output::GetResolverQueryLogConfigAssociationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resolver_query_log_config_association:
            std::option::Option<crate::model::ResolverQueryLogConfigAssociation>,
    }
    impl Builder {
        /// <p>Information about the Resolver query logging configuration association that you specified in a <code>GetQueryLogConfigAssociation</code> request.</p>
        pub fn resolver_query_log_config_association(
            mut self,
            input: crate::model::ResolverQueryLogConfigAssociation,
        ) -> Self {
            self.resolver_query_log_config_association = Some(input);
            self
        }
        /// <p>Information about the Resolver query logging configuration association that you specified in a <code>GetQueryLogConfigAssociation</code> request.</p>
        pub fn set_resolver_query_log_config_association(
            mut self,
            input: std::option::Option<crate::model::ResolverQueryLogConfigAssociation>,
        ) -> Self {
            self.resolver_query_log_config_association = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResolverQueryLogConfigAssociationOutput`](crate::output::GetResolverQueryLogConfigAssociationOutput)
        pub fn build(self) -> crate::output::GetResolverQueryLogConfigAssociationOutput {
            crate::output::GetResolverQueryLogConfigAssociationOutput {
                resolver_query_log_config_association: self.resolver_query_log_config_association,
            }
        }
    }
}
impl GetResolverQueryLogConfigAssociationOutput {
    /// Creates a new builder-style object to manufacture [`GetResolverQueryLogConfigAssociationOutput`](crate::output::GetResolverQueryLogConfigAssociationOutput)
    pub fn builder() -> crate::output::get_resolver_query_log_config_association_output::Builder {
        crate::output::get_resolver_query_log_config_association_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResolverQueryLogConfigOutput {
    /// <p>Information about the Resolver query logging configuration that you specified in a <code>GetQueryLogConfig</code> request.</p>
    pub resolver_query_log_config: std::option::Option<crate::model::ResolverQueryLogConfig>,
}
impl std::fmt::Debug for GetResolverQueryLogConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResolverQueryLogConfigOutput");
        formatter.field("resolver_query_log_config", &self.resolver_query_log_config);
        formatter.finish()
    }
}
/// See [`GetResolverQueryLogConfigOutput`](crate::output::GetResolverQueryLogConfigOutput)
pub mod get_resolver_query_log_config_output {
    /// A builder for [`GetResolverQueryLogConfigOutput`](crate::output::GetResolverQueryLogConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resolver_query_log_config:
            std::option::Option<crate::model::ResolverQueryLogConfig>,
    }
    impl Builder {
        /// <p>Information about the Resolver query logging configuration that you specified in a <code>GetQueryLogConfig</code> request.</p>
        pub fn resolver_query_log_config(
            mut self,
            input: crate::model::ResolverQueryLogConfig,
        ) -> Self {
            self.resolver_query_log_config = Some(input);
            self
        }
        /// <p>Information about the Resolver query logging configuration that you specified in a <code>GetQueryLogConfig</code> request.</p>
        pub fn set_resolver_query_log_config(
            mut self,
            input: std::option::Option<crate::model::ResolverQueryLogConfig>,
        ) -> Self {
            self.resolver_query_log_config = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResolverQueryLogConfigOutput`](crate::output::GetResolverQueryLogConfigOutput)
        pub fn build(self) -> crate::output::GetResolverQueryLogConfigOutput {
            crate::output::GetResolverQueryLogConfigOutput {
                resolver_query_log_config: self.resolver_query_log_config,
            }
        }
    }
}
impl GetResolverQueryLogConfigOutput {
    /// Creates a new builder-style object to manufacture [`GetResolverQueryLogConfigOutput`](crate::output::GetResolverQueryLogConfigOutput)
    pub fn builder() -> crate::output::get_resolver_query_log_config_output::Builder {
        crate::output::get_resolver_query_log_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResolverEndpointOutput {
    /// <p>Information about the Resolver endpoint that you specified in a <code>GetResolverEndpoint</code> request.</p>
    pub resolver_endpoint: std::option::Option<crate::model::ResolverEndpoint>,
}
impl std::fmt::Debug for GetResolverEndpointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResolverEndpointOutput");
        formatter.field("resolver_endpoint", &self.resolver_endpoint);
        formatter.finish()
    }
}
/// See [`GetResolverEndpointOutput`](crate::output::GetResolverEndpointOutput)
pub mod get_resolver_endpoint_output {
    /// A builder for [`GetResolverEndpointOutput`](crate::output::GetResolverEndpointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resolver_endpoint: std::option::Option<crate::model::ResolverEndpoint>,
    }
    impl Builder {
        /// <p>Information about the Resolver endpoint that you specified in a <code>GetResolverEndpoint</code> request.</p>
        pub fn resolver_endpoint(mut self, input: crate::model::ResolverEndpoint) -> Self {
            self.resolver_endpoint = Some(input);
            self
        }
        /// <p>Information about the Resolver endpoint that you specified in a <code>GetResolverEndpoint</code> request.</p>
        pub fn set_resolver_endpoint(
            mut self,
            input: std::option::Option<crate::model::ResolverEndpoint>,
        ) -> Self {
            self.resolver_endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResolverEndpointOutput`](crate::output::GetResolverEndpointOutput)
        pub fn build(self) -> crate::output::GetResolverEndpointOutput {
            crate::output::GetResolverEndpointOutput {
                resolver_endpoint: self.resolver_endpoint,
            }
        }
    }
}
impl GetResolverEndpointOutput {
    /// Creates a new builder-style object to manufacture [`GetResolverEndpointOutput`](crate::output::GetResolverEndpointOutput)
    pub fn builder() -> crate::output::get_resolver_endpoint_output::Builder {
        crate::output::get_resolver_endpoint_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResolverDnssecConfigOutput {
    /// <p>The information about a configuration for DNSSEC validation.</p>
    pub resolver_dnssec_config: std::option::Option<crate::model::ResolverDnssecConfig>,
}
impl std::fmt::Debug for GetResolverDnssecConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResolverDnssecConfigOutput");
        formatter.field("resolver_dnssec_config", &self.resolver_dnssec_config);
        formatter.finish()
    }
}
/// See [`GetResolverDnssecConfigOutput`](crate::output::GetResolverDnssecConfigOutput)
pub mod get_resolver_dnssec_config_output {
    /// A builder for [`GetResolverDnssecConfigOutput`](crate::output::GetResolverDnssecConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resolver_dnssec_config: std::option::Option<crate::model::ResolverDnssecConfig>,
    }
    impl Builder {
        /// <p>The information about a configuration for DNSSEC validation.</p>
        pub fn resolver_dnssec_config(mut self, input: crate::model::ResolverDnssecConfig) -> Self {
            self.resolver_dnssec_config = Some(input);
            self
        }
        /// <p>The information about a configuration for DNSSEC validation.</p>
        pub fn set_resolver_dnssec_config(
            mut self,
            input: std::option::Option<crate::model::ResolverDnssecConfig>,
        ) -> Self {
            self.resolver_dnssec_config = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResolverDnssecConfigOutput`](crate::output::GetResolverDnssecConfigOutput)
        pub fn build(self) -> crate::output::GetResolverDnssecConfigOutput {
            crate::output::GetResolverDnssecConfigOutput {
                resolver_dnssec_config: self.resolver_dnssec_config,
            }
        }
    }
}
impl GetResolverDnssecConfigOutput {
    /// Creates a new builder-style object to manufacture [`GetResolverDnssecConfigOutput`](crate::output::GetResolverDnssecConfigOutput)
    pub fn builder() -> crate::output::get_resolver_dnssec_config_output::Builder {
        crate::output::get_resolver_dnssec_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFirewallRuleGroupPolicyOutput {
    /// <p>The Identity and Access Management (Amazon Web Services IAM) policy for sharing the specified rule
    /// group. You can use the policy to share the rule group using Resource Access Manager
    /// (RAM). </p>
    pub firewall_rule_group_policy: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetFirewallRuleGroupPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFirewallRuleGroupPolicyOutput");
        formatter.field(
            "firewall_rule_group_policy",
            &self.firewall_rule_group_policy,
        );
        formatter.finish()
    }
}
/// See [`GetFirewallRuleGroupPolicyOutput`](crate::output::GetFirewallRuleGroupPolicyOutput)
pub mod get_firewall_rule_group_policy_output {
    /// A builder for [`GetFirewallRuleGroupPolicyOutput`](crate::output::GetFirewallRuleGroupPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_rule_group_policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Identity and Access Management (Amazon Web Services IAM) policy for sharing the specified rule
        /// group. You can use the policy to share the rule group using Resource Access Manager
        /// (RAM). </p>
        pub fn firewall_rule_group_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_rule_group_policy = Some(input.into());
            self
        }
        /// <p>The Identity and Access Management (Amazon Web Services IAM) policy for sharing the specified rule
        /// group. You can use the policy to share the rule group using Resource Access Manager
        /// (RAM). </p>
        pub fn set_firewall_rule_group_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firewall_rule_group_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFirewallRuleGroupPolicyOutput`](crate::output::GetFirewallRuleGroupPolicyOutput)
        pub fn build(self) -> crate::output::GetFirewallRuleGroupPolicyOutput {
            crate::output::GetFirewallRuleGroupPolicyOutput {
                firewall_rule_group_policy: self.firewall_rule_group_policy,
            }
        }
    }
}
impl GetFirewallRuleGroupPolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetFirewallRuleGroupPolicyOutput`](crate::output::GetFirewallRuleGroupPolicyOutput)
    pub fn builder() -> crate::output::get_firewall_rule_group_policy_output::Builder {
        crate::output::get_firewall_rule_group_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFirewallRuleGroupAssociationOutput {
    /// <p>The association that you requested. </p>
    pub firewall_rule_group_association:
        std::option::Option<crate::model::FirewallRuleGroupAssociation>,
}
impl std::fmt::Debug for GetFirewallRuleGroupAssociationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFirewallRuleGroupAssociationOutput");
        formatter.field(
            "firewall_rule_group_association",
            &self.firewall_rule_group_association,
        );
        formatter.finish()
    }
}
/// See [`GetFirewallRuleGroupAssociationOutput`](crate::output::GetFirewallRuleGroupAssociationOutput)
pub mod get_firewall_rule_group_association_output {
    /// A builder for [`GetFirewallRuleGroupAssociationOutput`](crate::output::GetFirewallRuleGroupAssociationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_rule_group_association:
            std::option::Option<crate::model::FirewallRuleGroupAssociation>,
    }
    impl Builder {
        /// <p>The association that you requested. </p>
        pub fn firewall_rule_group_association(
            mut self,
            input: crate::model::FirewallRuleGroupAssociation,
        ) -> Self {
            self.firewall_rule_group_association = Some(input);
            self
        }
        /// <p>The association that you requested. </p>
        pub fn set_firewall_rule_group_association(
            mut self,
            input: std::option::Option<crate::model::FirewallRuleGroupAssociation>,
        ) -> Self {
            self.firewall_rule_group_association = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFirewallRuleGroupAssociationOutput`](crate::output::GetFirewallRuleGroupAssociationOutput)
        pub fn build(self) -> crate::output::GetFirewallRuleGroupAssociationOutput {
            crate::output::GetFirewallRuleGroupAssociationOutput {
                firewall_rule_group_association: self.firewall_rule_group_association,
            }
        }
    }
}
impl GetFirewallRuleGroupAssociationOutput {
    /// Creates a new builder-style object to manufacture [`GetFirewallRuleGroupAssociationOutput`](crate::output::GetFirewallRuleGroupAssociationOutput)
    pub fn builder() -> crate::output::get_firewall_rule_group_association_output::Builder {
        crate::output::get_firewall_rule_group_association_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFirewallRuleGroupOutput {
    /// <p>A collection of rules used to filter DNS network traffic. </p>
    pub firewall_rule_group: std::option::Option<crate::model::FirewallRuleGroup>,
}
impl std::fmt::Debug for GetFirewallRuleGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFirewallRuleGroupOutput");
        formatter.field("firewall_rule_group", &self.firewall_rule_group);
        formatter.finish()
    }
}
/// See [`GetFirewallRuleGroupOutput`](crate::output::GetFirewallRuleGroupOutput)
pub mod get_firewall_rule_group_output {
    /// A builder for [`GetFirewallRuleGroupOutput`](crate::output::GetFirewallRuleGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_rule_group: std::option::Option<crate::model::FirewallRuleGroup>,
    }
    impl Builder {
        /// <p>A collection of rules used to filter DNS network traffic. </p>
        pub fn firewall_rule_group(mut self, input: crate::model::FirewallRuleGroup) -> Self {
            self.firewall_rule_group = Some(input);
            self
        }
        /// <p>A collection of rules used to filter DNS network traffic. </p>
        pub fn set_firewall_rule_group(
            mut self,
            input: std::option::Option<crate::model::FirewallRuleGroup>,
        ) -> Self {
            self.firewall_rule_group = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFirewallRuleGroupOutput`](crate::output::GetFirewallRuleGroupOutput)
        pub fn build(self) -> crate::output::GetFirewallRuleGroupOutput {
            crate::output::GetFirewallRuleGroupOutput {
                firewall_rule_group: self.firewall_rule_group,
            }
        }
    }
}
impl GetFirewallRuleGroupOutput {
    /// Creates a new builder-style object to manufacture [`GetFirewallRuleGroupOutput`](crate::output::GetFirewallRuleGroupOutput)
    pub fn builder() -> crate::output::get_firewall_rule_group_output::Builder {
        crate::output::get_firewall_rule_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFirewallDomainListOutput {
    /// <p>The domain list that you requested.  </p>
    pub firewall_domain_list: std::option::Option<crate::model::FirewallDomainList>,
}
impl std::fmt::Debug for GetFirewallDomainListOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFirewallDomainListOutput");
        formatter.field("firewall_domain_list", &self.firewall_domain_list);
        formatter.finish()
    }
}
/// See [`GetFirewallDomainListOutput`](crate::output::GetFirewallDomainListOutput)
pub mod get_firewall_domain_list_output {
    /// A builder for [`GetFirewallDomainListOutput`](crate::output::GetFirewallDomainListOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_domain_list: std::option::Option<crate::model::FirewallDomainList>,
    }
    impl Builder {
        /// <p>The domain list that you requested.  </p>
        pub fn firewall_domain_list(mut self, input: crate::model::FirewallDomainList) -> Self {
            self.firewall_domain_list = Some(input);
            self
        }
        /// <p>The domain list that you requested.  </p>
        pub fn set_firewall_domain_list(
            mut self,
            input: std::option::Option<crate::model::FirewallDomainList>,
        ) -> Self {
            self.firewall_domain_list = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFirewallDomainListOutput`](crate::output::GetFirewallDomainListOutput)
        pub fn build(self) -> crate::output::GetFirewallDomainListOutput {
            crate::output::GetFirewallDomainListOutput {
                firewall_domain_list: self.firewall_domain_list,
            }
        }
    }
}
impl GetFirewallDomainListOutput {
    /// Creates a new builder-style object to manufacture [`GetFirewallDomainListOutput`](crate::output::GetFirewallDomainListOutput)
    pub fn builder() -> crate::output::get_firewall_domain_list_output::Builder {
        crate::output::get_firewall_domain_list_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFirewallConfigOutput {
    /// <p>Configuration of the firewall behavior provided by DNS Firewall for a single VPC from
    /// AmazonVPC. </p>
    pub firewall_config: std::option::Option<crate::model::FirewallConfig>,
}
impl std::fmt::Debug for GetFirewallConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFirewallConfigOutput");
        formatter.field("firewall_config", &self.firewall_config);
        formatter.finish()
    }
}
/// See [`GetFirewallConfigOutput`](crate::output::GetFirewallConfigOutput)
pub mod get_firewall_config_output {
    /// A builder for [`GetFirewallConfigOutput`](crate::output::GetFirewallConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_config: std::option::Option<crate::model::FirewallConfig>,
    }
    impl Builder {
        /// <p>Configuration of the firewall behavior provided by DNS Firewall for a single VPC from
        /// AmazonVPC. </p>
        pub fn firewall_config(mut self, input: crate::model::FirewallConfig) -> Self {
            self.firewall_config = Some(input);
            self
        }
        /// <p>Configuration of the firewall behavior provided by DNS Firewall for a single VPC from
        /// AmazonVPC. </p>
        pub fn set_firewall_config(
            mut self,
            input: std::option::Option<crate::model::FirewallConfig>,
        ) -> Self {
            self.firewall_config = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFirewallConfigOutput`](crate::output::GetFirewallConfigOutput)
        pub fn build(self) -> crate::output::GetFirewallConfigOutput {
            crate::output::GetFirewallConfigOutput {
                firewall_config: self.firewall_config,
            }
        }
    }
}
impl GetFirewallConfigOutput {
    /// Creates a new builder-style object to manufacture [`GetFirewallConfigOutput`](crate::output::GetFirewallConfigOutput)
    pub fn builder() -> crate::output::get_firewall_config_output::Builder {
        crate::output::get_firewall_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateResolverRuleOutput {
    /// <p>Information about the <code>DisassociateResolverRule</code> request, including the status of the request.</p>
    pub resolver_rule_association: std::option::Option<crate::model::ResolverRuleAssociation>,
}
impl std::fmt::Debug for DisassociateResolverRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateResolverRuleOutput");
        formatter.field("resolver_rule_association", &self.resolver_rule_association);
        formatter.finish()
    }
}
/// See [`DisassociateResolverRuleOutput`](crate::output::DisassociateResolverRuleOutput)
pub mod disassociate_resolver_rule_output {
    /// A builder for [`DisassociateResolverRuleOutput`](crate::output::DisassociateResolverRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resolver_rule_association:
            std::option::Option<crate::model::ResolverRuleAssociation>,
    }
    impl Builder {
        /// <p>Information about the <code>DisassociateResolverRule</code> request, including the status of the request.</p>
        pub fn resolver_rule_association(
            mut self,
            input: crate::model::ResolverRuleAssociation,
        ) -> Self {
            self.resolver_rule_association = Some(input);
            self
        }
        /// <p>Information about the <code>DisassociateResolverRule</code> request, including the status of the request.</p>
        pub fn set_resolver_rule_association(
            mut self,
            input: std::option::Option<crate::model::ResolverRuleAssociation>,
        ) -> Self {
            self.resolver_rule_association = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateResolverRuleOutput`](crate::output::DisassociateResolverRuleOutput)
        pub fn build(self) -> crate::output::DisassociateResolverRuleOutput {
            crate::output::DisassociateResolverRuleOutput {
                resolver_rule_association: self.resolver_rule_association,
            }
        }
    }
}
impl DisassociateResolverRuleOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateResolverRuleOutput`](crate::output::DisassociateResolverRuleOutput)
    pub fn builder() -> crate::output::disassociate_resolver_rule_output::Builder {
        crate::output::disassociate_resolver_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateResolverQueryLogConfigOutput {
    /// <p>A complex type that contains settings for the association that you deleted between an Amazon VPC and a query logging configuration.</p>
    pub resolver_query_log_config_association:
        std::option::Option<crate::model::ResolverQueryLogConfigAssociation>,
}
impl std::fmt::Debug for DisassociateResolverQueryLogConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateResolverQueryLogConfigOutput");
        formatter.field(
            "resolver_query_log_config_association",
            &self.resolver_query_log_config_association,
        );
        formatter.finish()
    }
}
/// See [`DisassociateResolverQueryLogConfigOutput`](crate::output::DisassociateResolverQueryLogConfigOutput)
pub mod disassociate_resolver_query_log_config_output {
    /// A builder for [`DisassociateResolverQueryLogConfigOutput`](crate::output::DisassociateResolverQueryLogConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resolver_query_log_config_association:
            std::option::Option<crate::model::ResolverQueryLogConfigAssociation>,
    }
    impl Builder {
        /// <p>A complex type that contains settings for the association that you deleted between an Amazon VPC and a query logging configuration.</p>
        pub fn resolver_query_log_config_association(
            mut self,
            input: crate::model::ResolverQueryLogConfigAssociation,
        ) -> Self {
            self.resolver_query_log_config_association = Some(input);
            self
        }
        /// <p>A complex type that contains settings for the association that you deleted between an Amazon VPC and a query logging configuration.</p>
        pub fn set_resolver_query_log_config_association(
            mut self,
            input: std::option::Option<crate::model::ResolverQueryLogConfigAssociation>,
        ) -> Self {
            self.resolver_query_log_config_association = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateResolverQueryLogConfigOutput`](crate::output::DisassociateResolverQueryLogConfigOutput)
        pub fn build(self) -> crate::output::DisassociateResolverQueryLogConfigOutput {
            crate::output::DisassociateResolverQueryLogConfigOutput {
                resolver_query_log_config_association: self.resolver_query_log_config_association,
            }
        }
    }
}
impl DisassociateResolverQueryLogConfigOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateResolverQueryLogConfigOutput`](crate::output::DisassociateResolverQueryLogConfigOutput)
    pub fn builder() -> crate::output::disassociate_resolver_query_log_config_output::Builder {
        crate::output::disassociate_resolver_query_log_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateResolverEndpointIpAddressOutput {
    /// <p>The response to an <code>DisassociateResolverEndpointIpAddress</code> request.</p>
    pub resolver_endpoint: std::option::Option<crate::model::ResolverEndpoint>,
}
impl std::fmt::Debug for DisassociateResolverEndpointIpAddressOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateResolverEndpointIpAddressOutput");
        formatter.field("resolver_endpoint", &self.resolver_endpoint);
        formatter.finish()
    }
}
/// See [`DisassociateResolverEndpointIpAddressOutput`](crate::output::DisassociateResolverEndpointIpAddressOutput)
pub mod disassociate_resolver_endpoint_ip_address_output {
    /// A builder for [`DisassociateResolverEndpointIpAddressOutput`](crate::output::DisassociateResolverEndpointIpAddressOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resolver_endpoint: std::option::Option<crate::model::ResolverEndpoint>,
    }
    impl Builder {
        /// <p>The response to an <code>DisassociateResolverEndpointIpAddress</code> request.</p>
        pub fn resolver_endpoint(mut self, input: crate::model::ResolverEndpoint) -> Self {
            self.resolver_endpoint = Some(input);
            self
        }
        /// <p>The response to an <code>DisassociateResolverEndpointIpAddress</code> request.</p>
        pub fn set_resolver_endpoint(
            mut self,
            input: std::option::Option<crate::model::ResolverEndpoint>,
        ) -> Self {
            self.resolver_endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateResolverEndpointIpAddressOutput`](crate::output::DisassociateResolverEndpointIpAddressOutput)
        pub fn build(self) -> crate::output::DisassociateResolverEndpointIpAddressOutput {
            crate::output::DisassociateResolverEndpointIpAddressOutput {
                resolver_endpoint: self.resolver_endpoint,
            }
        }
    }
}
impl DisassociateResolverEndpointIpAddressOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateResolverEndpointIpAddressOutput`](crate::output::DisassociateResolverEndpointIpAddressOutput)
    pub fn builder() -> crate::output::disassociate_resolver_endpoint_ip_address_output::Builder {
        crate::output::disassociate_resolver_endpoint_ip_address_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateFirewallRuleGroupOutput {
    /// <p>The firewall rule group association that you just removed. </p>
    pub firewall_rule_group_association:
        std::option::Option<crate::model::FirewallRuleGroupAssociation>,
}
impl std::fmt::Debug for DisassociateFirewallRuleGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateFirewallRuleGroupOutput");
        formatter.field(
            "firewall_rule_group_association",
            &self.firewall_rule_group_association,
        );
        formatter.finish()
    }
}
/// See [`DisassociateFirewallRuleGroupOutput`](crate::output::DisassociateFirewallRuleGroupOutput)
pub mod disassociate_firewall_rule_group_output {
    /// A builder for [`DisassociateFirewallRuleGroupOutput`](crate::output::DisassociateFirewallRuleGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_rule_group_association:
            std::option::Option<crate::model::FirewallRuleGroupAssociation>,
    }
    impl Builder {
        /// <p>The firewall rule group association that you just removed. </p>
        pub fn firewall_rule_group_association(
            mut self,
            input: crate::model::FirewallRuleGroupAssociation,
        ) -> Self {
            self.firewall_rule_group_association = Some(input);
            self
        }
        /// <p>The firewall rule group association that you just removed. </p>
        pub fn set_firewall_rule_group_association(
            mut self,
            input: std::option::Option<crate::model::FirewallRuleGroupAssociation>,
        ) -> Self {
            self.firewall_rule_group_association = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateFirewallRuleGroupOutput`](crate::output::DisassociateFirewallRuleGroupOutput)
        pub fn build(self) -> crate::output::DisassociateFirewallRuleGroupOutput {
            crate::output::DisassociateFirewallRuleGroupOutput {
                firewall_rule_group_association: self.firewall_rule_group_association,
            }
        }
    }
}
impl DisassociateFirewallRuleGroupOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateFirewallRuleGroupOutput`](crate::output::DisassociateFirewallRuleGroupOutput)
    pub fn builder() -> crate::output::disassociate_firewall_rule_group_output::Builder {
        crate::output::disassociate_firewall_rule_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteResolverRuleOutput {
    /// <p>Information about the <code>DeleteResolverRule</code> request, including the status of the request.</p>
    pub resolver_rule: std::option::Option<crate::model::ResolverRule>,
}
impl std::fmt::Debug for DeleteResolverRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteResolverRuleOutput");
        formatter.field("resolver_rule", &self.resolver_rule);
        formatter.finish()
    }
}
/// See [`DeleteResolverRuleOutput`](crate::output::DeleteResolverRuleOutput)
pub mod delete_resolver_rule_output {
    /// A builder for [`DeleteResolverRuleOutput`](crate::output::DeleteResolverRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resolver_rule: std::option::Option<crate::model::ResolverRule>,
    }
    impl Builder {
        /// <p>Information about the <code>DeleteResolverRule</code> request, including the status of the request.</p>
        pub fn resolver_rule(mut self, input: crate::model::ResolverRule) -> Self {
            self.resolver_rule = Some(input);
            self
        }
        /// <p>Information about the <code>DeleteResolverRule</code> request, including the status of the request.</p>
        pub fn set_resolver_rule(
            mut self,
            input: std::option::Option<crate::model::ResolverRule>,
        ) -> Self {
            self.resolver_rule = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteResolverRuleOutput`](crate::output::DeleteResolverRuleOutput)
        pub fn build(self) -> crate::output::DeleteResolverRuleOutput {
            crate::output::DeleteResolverRuleOutput {
                resolver_rule: self.resolver_rule,
            }
        }
    }
}
impl DeleteResolverRuleOutput {
    /// Creates a new builder-style object to manufacture [`DeleteResolverRuleOutput`](crate::output::DeleteResolverRuleOutput)
    pub fn builder() -> crate::output::delete_resolver_rule_output::Builder {
        crate::output::delete_resolver_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteResolverQueryLogConfigOutput {
    /// <p>Information about the query logging configuration that you deleted, including the status of the request.</p>
    pub resolver_query_log_config: std::option::Option<crate::model::ResolverQueryLogConfig>,
}
impl std::fmt::Debug for DeleteResolverQueryLogConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteResolverQueryLogConfigOutput");
        formatter.field("resolver_query_log_config", &self.resolver_query_log_config);
        formatter.finish()
    }
}
/// See [`DeleteResolverQueryLogConfigOutput`](crate::output::DeleteResolverQueryLogConfigOutput)
pub mod delete_resolver_query_log_config_output {
    /// A builder for [`DeleteResolverQueryLogConfigOutput`](crate::output::DeleteResolverQueryLogConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resolver_query_log_config:
            std::option::Option<crate::model::ResolverQueryLogConfig>,
    }
    impl Builder {
        /// <p>Information about the query logging configuration that you deleted, including the status of the request.</p>
        pub fn resolver_query_log_config(
            mut self,
            input: crate::model::ResolverQueryLogConfig,
        ) -> Self {
            self.resolver_query_log_config = Some(input);
            self
        }
        /// <p>Information about the query logging configuration that you deleted, including the status of the request.</p>
        pub fn set_resolver_query_log_config(
            mut self,
            input: std::option::Option<crate::model::ResolverQueryLogConfig>,
        ) -> Self {
            self.resolver_query_log_config = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteResolverQueryLogConfigOutput`](crate::output::DeleteResolverQueryLogConfigOutput)
        pub fn build(self) -> crate::output::DeleteResolverQueryLogConfigOutput {
            crate::output::DeleteResolverQueryLogConfigOutput {
                resolver_query_log_config: self.resolver_query_log_config,
            }
        }
    }
}
impl DeleteResolverQueryLogConfigOutput {
    /// Creates a new builder-style object to manufacture [`DeleteResolverQueryLogConfigOutput`](crate::output::DeleteResolverQueryLogConfigOutput)
    pub fn builder() -> crate::output::delete_resolver_query_log_config_output::Builder {
        crate::output::delete_resolver_query_log_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteResolverEndpointOutput {
    /// <p>Information about the <code>DeleteResolverEndpoint</code> request, including the status of the request.</p>
    pub resolver_endpoint: std::option::Option<crate::model::ResolverEndpoint>,
}
impl std::fmt::Debug for DeleteResolverEndpointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteResolverEndpointOutput");
        formatter.field("resolver_endpoint", &self.resolver_endpoint);
        formatter.finish()
    }
}
/// See [`DeleteResolverEndpointOutput`](crate::output::DeleteResolverEndpointOutput)
pub mod delete_resolver_endpoint_output {
    /// A builder for [`DeleteResolverEndpointOutput`](crate::output::DeleteResolverEndpointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resolver_endpoint: std::option::Option<crate::model::ResolverEndpoint>,
    }
    impl Builder {
        /// <p>Information about the <code>DeleteResolverEndpoint</code> request, including the status of the request.</p>
        pub fn resolver_endpoint(mut self, input: crate::model::ResolverEndpoint) -> Self {
            self.resolver_endpoint = Some(input);
            self
        }
        /// <p>Information about the <code>DeleteResolverEndpoint</code> request, including the status of the request.</p>
        pub fn set_resolver_endpoint(
            mut self,
            input: std::option::Option<crate::model::ResolverEndpoint>,
        ) -> Self {
            self.resolver_endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteResolverEndpointOutput`](crate::output::DeleteResolverEndpointOutput)
        pub fn build(self) -> crate::output::DeleteResolverEndpointOutput {
            crate::output::DeleteResolverEndpointOutput {
                resolver_endpoint: self.resolver_endpoint,
            }
        }
    }
}
impl DeleteResolverEndpointOutput {
    /// Creates a new builder-style object to manufacture [`DeleteResolverEndpointOutput`](crate::output::DeleteResolverEndpointOutput)
    pub fn builder() -> crate::output::delete_resolver_endpoint_output::Builder {
        crate::output::delete_resolver_endpoint_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFirewallRuleGroupOutput {
    /// <p>A collection of rules used to filter DNS network traffic. </p>
    pub firewall_rule_group: std::option::Option<crate::model::FirewallRuleGroup>,
}
impl std::fmt::Debug for DeleteFirewallRuleGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFirewallRuleGroupOutput");
        formatter.field("firewall_rule_group", &self.firewall_rule_group);
        formatter.finish()
    }
}
/// See [`DeleteFirewallRuleGroupOutput`](crate::output::DeleteFirewallRuleGroupOutput)
pub mod delete_firewall_rule_group_output {
    /// A builder for [`DeleteFirewallRuleGroupOutput`](crate::output::DeleteFirewallRuleGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_rule_group: std::option::Option<crate::model::FirewallRuleGroup>,
    }
    impl Builder {
        /// <p>A collection of rules used to filter DNS network traffic. </p>
        pub fn firewall_rule_group(mut self, input: crate::model::FirewallRuleGroup) -> Self {
            self.firewall_rule_group = Some(input);
            self
        }
        /// <p>A collection of rules used to filter DNS network traffic. </p>
        pub fn set_firewall_rule_group(
            mut self,
            input: std::option::Option<crate::model::FirewallRuleGroup>,
        ) -> Self {
            self.firewall_rule_group = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFirewallRuleGroupOutput`](crate::output::DeleteFirewallRuleGroupOutput)
        pub fn build(self) -> crate::output::DeleteFirewallRuleGroupOutput {
            crate::output::DeleteFirewallRuleGroupOutput {
                firewall_rule_group: self.firewall_rule_group,
            }
        }
    }
}
impl DeleteFirewallRuleGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteFirewallRuleGroupOutput`](crate::output::DeleteFirewallRuleGroupOutput)
    pub fn builder() -> crate::output::delete_firewall_rule_group_output::Builder {
        crate::output::delete_firewall_rule_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFirewallRuleOutput {
    /// <p>The specification for the firewall rule that you just deleted.</p>
    pub firewall_rule: std::option::Option<crate::model::FirewallRule>,
}
impl std::fmt::Debug for DeleteFirewallRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFirewallRuleOutput");
        formatter.field("firewall_rule", &self.firewall_rule);
        formatter.finish()
    }
}
/// See [`DeleteFirewallRuleOutput`](crate::output::DeleteFirewallRuleOutput)
pub mod delete_firewall_rule_output {
    /// A builder for [`DeleteFirewallRuleOutput`](crate::output::DeleteFirewallRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_rule: std::option::Option<crate::model::FirewallRule>,
    }
    impl Builder {
        /// <p>The specification for the firewall rule that you just deleted.</p>
        pub fn firewall_rule(mut self, input: crate::model::FirewallRule) -> Self {
            self.firewall_rule = Some(input);
            self
        }
        /// <p>The specification for the firewall rule that you just deleted.</p>
        pub fn set_firewall_rule(
            mut self,
            input: std::option::Option<crate::model::FirewallRule>,
        ) -> Self {
            self.firewall_rule = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFirewallRuleOutput`](crate::output::DeleteFirewallRuleOutput)
        pub fn build(self) -> crate::output::DeleteFirewallRuleOutput {
            crate::output::DeleteFirewallRuleOutput {
                firewall_rule: self.firewall_rule,
            }
        }
    }
}
impl DeleteFirewallRuleOutput {
    /// Creates a new builder-style object to manufacture [`DeleteFirewallRuleOutput`](crate::output::DeleteFirewallRuleOutput)
    pub fn builder() -> crate::output::delete_firewall_rule_output::Builder {
        crate::output::delete_firewall_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFirewallDomainListOutput {
    /// <p>The domain list that you just deleted. </p>
    pub firewall_domain_list: std::option::Option<crate::model::FirewallDomainList>,
}
impl std::fmt::Debug for DeleteFirewallDomainListOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFirewallDomainListOutput");
        formatter.field("firewall_domain_list", &self.firewall_domain_list);
        formatter.finish()
    }
}
/// See [`DeleteFirewallDomainListOutput`](crate::output::DeleteFirewallDomainListOutput)
pub mod delete_firewall_domain_list_output {
    /// A builder for [`DeleteFirewallDomainListOutput`](crate::output::DeleteFirewallDomainListOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_domain_list: std::option::Option<crate::model::FirewallDomainList>,
    }
    impl Builder {
        /// <p>The domain list that you just deleted. </p>
        pub fn firewall_domain_list(mut self, input: crate::model::FirewallDomainList) -> Self {
            self.firewall_domain_list = Some(input);
            self
        }
        /// <p>The domain list that you just deleted. </p>
        pub fn set_firewall_domain_list(
            mut self,
            input: std::option::Option<crate::model::FirewallDomainList>,
        ) -> Self {
            self.firewall_domain_list = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFirewallDomainListOutput`](crate::output::DeleteFirewallDomainListOutput)
        pub fn build(self) -> crate::output::DeleteFirewallDomainListOutput {
            crate::output::DeleteFirewallDomainListOutput {
                firewall_domain_list: self.firewall_domain_list,
            }
        }
    }
}
impl DeleteFirewallDomainListOutput {
    /// Creates a new builder-style object to manufacture [`DeleteFirewallDomainListOutput`](crate::output::DeleteFirewallDomainListOutput)
    pub fn builder() -> crate::output::delete_firewall_domain_list_output::Builder {
        crate::output::delete_firewall_domain_list_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateResolverRuleOutput {
    /// <p>Information about the <code>CreateResolverRule</code> request, including the status of the request.</p>
    pub resolver_rule: std::option::Option<crate::model::ResolverRule>,
}
impl std::fmt::Debug for CreateResolverRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateResolverRuleOutput");
        formatter.field("resolver_rule", &self.resolver_rule);
        formatter.finish()
    }
}
/// See [`CreateResolverRuleOutput`](crate::output::CreateResolverRuleOutput)
pub mod create_resolver_rule_output {
    /// A builder for [`CreateResolverRuleOutput`](crate::output::CreateResolverRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resolver_rule: std::option::Option<crate::model::ResolverRule>,
    }
    impl Builder {
        /// <p>Information about the <code>CreateResolverRule</code> request, including the status of the request.</p>
        pub fn resolver_rule(mut self, input: crate::model::ResolverRule) -> Self {
            self.resolver_rule = Some(input);
            self
        }
        /// <p>Information about the <code>CreateResolverRule</code> request, including the status of the request.</p>
        pub fn set_resolver_rule(
            mut self,
            input: std::option::Option<crate::model::ResolverRule>,
        ) -> Self {
            self.resolver_rule = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateResolverRuleOutput`](crate::output::CreateResolverRuleOutput)
        pub fn build(self) -> crate::output::CreateResolverRuleOutput {
            crate::output::CreateResolverRuleOutput {
                resolver_rule: self.resolver_rule,
            }
        }
    }
}
impl CreateResolverRuleOutput {
    /// Creates a new builder-style object to manufacture [`CreateResolverRuleOutput`](crate::output::CreateResolverRuleOutput)
    pub fn builder() -> crate::output::create_resolver_rule_output::Builder {
        crate::output::create_resolver_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateResolverQueryLogConfigOutput {
    /// <p>Information about the <code>CreateResolverQueryLogConfig</code> request, including the status of the request.</p>
    pub resolver_query_log_config: std::option::Option<crate::model::ResolverQueryLogConfig>,
}
impl std::fmt::Debug for CreateResolverQueryLogConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateResolverQueryLogConfigOutput");
        formatter.field("resolver_query_log_config", &self.resolver_query_log_config);
        formatter.finish()
    }
}
/// See [`CreateResolverQueryLogConfigOutput`](crate::output::CreateResolverQueryLogConfigOutput)
pub mod create_resolver_query_log_config_output {
    /// A builder for [`CreateResolverQueryLogConfigOutput`](crate::output::CreateResolverQueryLogConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resolver_query_log_config:
            std::option::Option<crate::model::ResolverQueryLogConfig>,
    }
    impl Builder {
        /// <p>Information about the <code>CreateResolverQueryLogConfig</code> request, including the status of the request.</p>
        pub fn resolver_query_log_config(
            mut self,
            input: crate::model::ResolverQueryLogConfig,
        ) -> Self {
            self.resolver_query_log_config = Some(input);
            self
        }
        /// <p>Information about the <code>CreateResolverQueryLogConfig</code> request, including the status of the request.</p>
        pub fn set_resolver_query_log_config(
            mut self,
            input: std::option::Option<crate::model::ResolverQueryLogConfig>,
        ) -> Self {
            self.resolver_query_log_config = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateResolverQueryLogConfigOutput`](crate::output::CreateResolverQueryLogConfigOutput)
        pub fn build(self) -> crate::output::CreateResolverQueryLogConfigOutput {
            crate::output::CreateResolverQueryLogConfigOutput {
                resolver_query_log_config: self.resolver_query_log_config,
            }
        }
    }
}
impl CreateResolverQueryLogConfigOutput {
    /// Creates a new builder-style object to manufacture [`CreateResolverQueryLogConfigOutput`](crate::output::CreateResolverQueryLogConfigOutput)
    pub fn builder() -> crate::output::create_resolver_query_log_config_output::Builder {
        crate::output::create_resolver_query_log_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateResolverEndpointOutput {
    /// <p>Information about the <code>CreateResolverEndpoint</code> request, including the status of the request.</p>
    pub resolver_endpoint: std::option::Option<crate::model::ResolverEndpoint>,
}
impl std::fmt::Debug for CreateResolverEndpointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateResolverEndpointOutput");
        formatter.field("resolver_endpoint", &self.resolver_endpoint);
        formatter.finish()
    }
}
/// See [`CreateResolverEndpointOutput`](crate::output::CreateResolverEndpointOutput)
pub mod create_resolver_endpoint_output {
    /// A builder for [`CreateResolverEndpointOutput`](crate::output::CreateResolverEndpointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resolver_endpoint: std::option::Option<crate::model::ResolverEndpoint>,
    }
    impl Builder {
        /// <p>Information about the <code>CreateResolverEndpoint</code> request, including the status of the request.</p>
        pub fn resolver_endpoint(mut self, input: crate::model::ResolverEndpoint) -> Self {
            self.resolver_endpoint = Some(input);
            self
        }
        /// <p>Information about the <code>CreateResolverEndpoint</code> request, including the status of the request.</p>
        pub fn set_resolver_endpoint(
            mut self,
            input: std::option::Option<crate::model::ResolverEndpoint>,
        ) -> Self {
            self.resolver_endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateResolverEndpointOutput`](crate::output::CreateResolverEndpointOutput)
        pub fn build(self) -> crate::output::CreateResolverEndpointOutput {
            crate::output::CreateResolverEndpointOutput {
                resolver_endpoint: self.resolver_endpoint,
            }
        }
    }
}
impl CreateResolverEndpointOutput {
    /// Creates a new builder-style object to manufacture [`CreateResolverEndpointOutput`](crate::output::CreateResolverEndpointOutput)
    pub fn builder() -> crate::output::create_resolver_endpoint_output::Builder {
        crate::output::create_resolver_endpoint_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFirewallRuleGroupOutput {
    /// <p>A collection of rules used to filter DNS network traffic. </p>
    pub firewall_rule_group: std::option::Option<crate::model::FirewallRuleGroup>,
}
impl std::fmt::Debug for CreateFirewallRuleGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFirewallRuleGroupOutput");
        formatter.field("firewall_rule_group", &self.firewall_rule_group);
        formatter.finish()
    }
}
/// See [`CreateFirewallRuleGroupOutput`](crate::output::CreateFirewallRuleGroupOutput)
pub mod create_firewall_rule_group_output {
    /// A builder for [`CreateFirewallRuleGroupOutput`](crate::output::CreateFirewallRuleGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_rule_group: std::option::Option<crate::model::FirewallRuleGroup>,
    }
    impl Builder {
        /// <p>A collection of rules used to filter DNS network traffic. </p>
        pub fn firewall_rule_group(mut self, input: crate::model::FirewallRuleGroup) -> Self {
            self.firewall_rule_group = Some(input);
            self
        }
        /// <p>A collection of rules used to filter DNS network traffic. </p>
        pub fn set_firewall_rule_group(
            mut self,
            input: std::option::Option<crate::model::FirewallRuleGroup>,
        ) -> Self {
            self.firewall_rule_group = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFirewallRuleGroupOutput`](crate::output::CreateFirewallRuleGroupOutput)
        pub fn build(self) -> crate::output::CreateFirewallRuleGroupOutput {
            crate::output::CreateFirewallRuleGroupOutput {
                firewall_rule_group: self.firewall_rule_group,
            }
        }
    }
}
impl CreateFirewallRuleGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateFirewallRuleGroupOutput`](crate::output::CreateFirewallRuleGroupOutput)
    pub fn builder() -> crate::output::create_firewall_rule_group_output::Builder {
        crate::output::create_firewall_rule_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFirewallRuleOutput {
    /// <p>The
    /// firewall rule that you just created. </p>
    pub firewall_rule: std::option::Option<crate::model::FirewallRule>,
}
impl std::fmt::Debug for CreateFirewallRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFirewallRuleOutput");
        formatter.field("firewall_rule", &self.firewall_rule);
        formatter.finish()
    }
}
/// See [`CreateFirewallRuleOutput`](crate::output::CreateFirewallRuleOutput)
pub mod create_firewall_rule_output {
    /// A builder for [`CreateFirewallRuleOutput`](crate::output::CreateFirewallRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_rule: std::option::Option<crate::model::FirewallRule>,
    }
    impl Builder {
        /// <p>The
        /// firewall rule that you just created. </p>
        pub fn firewall_rule(mut self, input: crate::model::FirewallRule) -> Self {
            self.firewall_rule = Some(input);
            self
        }
        /// <p>The
        /// firewall rule that you just created. </p>
        pub fn set_firewall_rule(
            mut self,
            input: std::option::Option<crate::model::FirewallRule>,
        ) -> Self {
            self.firewall_rule = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFirewallRuleOutput`](crate::output::CreateFirewallRuleOutput)
        pub fn build(self) -> crate::output::CreateFirewallRuleOutput {
            crate::output::CreateFirewallRuleOutput {
                firewall_rule: self.firewall_rule,
            }
        }
    }
}
impl CreateFirewallRuleOutput {
    /// Creates a new builder-style object to manufacture [`CreateFirewallRuleOutput`](crate::output::CreateFirewallRuleOutput)
    pub fn builder() -> crate::output::create_firewall_rule_output::Builder {
        crate::output::create_firewall_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFirewallDomainListOutput {
    /// <p>The
    /// domain list that you just created.</p>
    pub firewall_domain_list: std::option::Option<crate::model::FirewallDomainList>,
}
impl std::fmt::Debug for CreateFirewallDomainListOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFirewallDomainListOutput");
        formatter.field("firewall_domain_list", &self.firewall_domain_list);
        formatter.finish()
    }
}
/// See [`CreateFirewallDomainListOutput`](crate::output::CreateFirewallDomainListOutput)
pub mod create_firewall_domain_list_output {
    /// A builder for [`CreateFirewallDomainListOutput`](crate::output::CreateFirewallDomainListOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_domain_list: std::option::Option<crate::model::FirewallDomainList>,
    }
    impl Builder {
        /// <p>The
        /// domain list that you just created.</p>
        pub fn firewall_domain_list(mut self, input: crate::model::FirewallDomainList) -> Self {
            self.firewall_domain_list = Some(input);
            self
        }
        /// <p>The
        /// domain list that you just created.</p>
        pub fn set_firewall_domain_list(
            mut self,
            input: std::option::Option<crate::model::FirewallDomainList>,
        ) -> Self {
            self.firewall_domain_list = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFirewallDomainListOutput`](crate::output::CreateFirewallDomainListOutput)
        pub fn build(self) -> crate::output::CreateFirewallDomainListOutput {
            crate::output::CreateFirewallDomainListOutput {
                firewall_domain_list: self.firewall_domain_list,
            }
        }
    }
}
impl CreateFirewallDomainListOutput {
    /// Creates a new builder-style object to manufacture [`CreateFirewallDomainListOutput`](crate::output::CreateFirewallDomainListOutput)
    pub fn builder() -> crate::output::create_firewall_domain_list_output::Builder {
        crate::output::create_firewall_domain_list_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateResolverRuleOutput {
    /// <p>Information about the <code>AssociateResolverRule</code> request, including the status of the request.</p>
    pub resolver_rule_association: std::option::Option<crate::model::ResolverRuleAssociation>,
}
impl std::fmt::Debug for AssociateResolverRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateResolverRuleOutput");
        formatter.field("resolver_rule_association", &self.resolver_rule_association);
        formatter.finish()
    }
}
/// See [`AssociateResolverRuleOutput`](crate::output::AssociateResolverRuleOutput)
pub mod associate_resolver_rule_output {
    /// A builder for [`AssociateResolverRuleOutput`](crate::output::AssociateResolverRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resolver_rule_association:
            std::option::Option<crate::model::ResolverRuleAssociation>,
    }
    impl Builder {
        /// <p>Information about the <code>AssociateResolverRule</code> request, including the status of the request.</p>
        pub fn resolver_rule_association(
            mut self,
            input: crate::model::ResolverRuleAssociation,
        ) -> Self {
            self.resolver_rule_association = Some(input);
            self
        }
        /// <p>Information about the <code>AssociateResolverRule</code> request, including the status of the request.</p>
        pub fn set_resolver_rule_association(
            mut self,
            input: std::option::Option<crate::model::ResolverRuleAssociation>,
        ) -> Self {
            self.resolver_rule_association = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateResolverRuleOutput`](crate::output::AssociateResolverRuleOutput)
        pub fn build(self) -> crate::output::AssociateResolverRuleOutput {
            crate::output::AssociateResolverRuleOutput {
                resolver_rule_association: self.resolver_rule_association,
            }
        }
    }
}
impl AssociateResolverRuleOutput {
    /// Creates a new builder-style object to manufacture [`AssociateResolverRuleOutput`](crate::output::AssociateResolverRuleOutput)
    pub fn builder() -> crate::output::associate_resolver_rule_output::Builder {
        crate::output::associate_resolver_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateResolverQueryLogConfigOutput {
    /// <p>A complex type that contains settings for a specified association between an Amazon VPC and a query logging configuration.</p>
    pub resolver_query_log_config_association:
        std::option::Option<crate::model::ResolverQueryLogConfigAssociation>,
}
impl std::fmt::Debug for AssociateResolverQueryLogConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateResolverQueryLogConfigOutput");
        formatter.field(
            "resolver_query_log_config_association",
            &self.resolver_query_log_config_association,
        );
        formatter.finish()
    }
}
/// See [`AssociateResolverQueryLogConfigOutput`](crate::output::AssociateResolverQueryLogConfigOutput)
pub mod associate_resolver_query_log_config_output {
    /// A builder for [`AssociateResolverQueryLogConfigOutput`](crate::output::AssociateResolverQueryLogConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resolver_query_log_config_association:
            std::option::Option<crate::model::ResolverQueryLogConfigAssociation>,
    }
    impl Builder {
        /// <p>A complex type that contains settings for a specified association between an Amazon VPC and a query logging configuration.</p>
        pub fn resolver_query_log_config_association(
            mut self,
            input: crate::model::ResolverQueryLogConfigAssociation,
        ) -> Self {
            self.resolver_query_log_config_association = Some(input);
            self
        }
        /// <p>A complex type that contains settings for a specified association between an Amazon VPC and a query logging configuration.</p>
        pub fn set_resolver_query_log_config_association(
            mut self,
            input: std::option::Option<crate::model::ResolverQueryLogConfigAssociation>,
        ) -> Self {
            self.resolver_query_log_config_association = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateResolverQueryLogConfigOutput`](crate::output::AssociateResolverQueryLogConfigOutput)
        pub fn build(self) -> crate::output::AssociateResolverQueryLogConfigOutput {
            crate::output::AssociateResolverQueryLogConfigOutput {
                resolver_query_log_config_association: self.resolver_query_log_config_association,
            }
        }
    }
}
impl AssociateResolverQueryLogConfigOutput {
    /// Creates a new builder-style object to manufacture [`AssociateResolverQueryLogConfigOutput`](crate::output::AssociateResolverQueryLogConfigOutput)
    pub fn builder() -> crate::output::associate_resolver_query_log_config_output::Builder {
        crate::output::associate_resolver_query_log_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateResolverEndpointIpAddressOutput {
    /// <p>The response to an <code>AssociateResolverEndpointIpAddress</code> request.</p>
    pub resolver_endpoint: std::option::Option<crate::model::ResolverEndpoint>,
}
impl std::fmt::Debug for AssociateResolverEndpointIpAddressOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateResolverEndpointIpAddressOutput");
        formatter.field("resolver_endpoint", &self.resolver_endpoint);
        formatter.finish()
    }
}
/// See [`AssociateResolverEndpointIpAddressOutput`](crate::output::AssociateResolverEndpointIpAddressOutput)
pub mod associate_resolver_endpoint_ip_address_output {
    /// A builder for [`AssociateResolverEndpointIpAddressOutput`](crate::output::AssociateResolverEndpointIpAddressOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resolver_endpoint: std::option::Option<crate::model::ResolverEndpoint>,
    }
    impl Builder {
        /// <p>The response to an <code>AssociateResolverEndpointIpAddress</code> request.</p>
        pub fn resolver_endpoint(mut self, input: crate::model::ResolverEndpoint) -> Self {
            self.resolver_endpoint = Some(input);
            self
        }
        /// <p>The response to an <code>AssociateResolverEndpointIpAddress</code> request.</p>
        pub fn set_resolver_endpoint(
            mut self,
            input: std::option::Option<crate::model::ResolverEndpoint>,
        ) -> Self {
            self.resolver_endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateResolverEndpointIpAddressOutput`](crate::output::AssociateResolverEndpointIpAddressOutput)
        pub fn build(self) -> crate::output::AssociateResolverEndpointIpAddressOutput {
            crate::output::AssociateResolverEndpointIpAddressOutput {
                resolver_endpoint: self.resolver_endpoint,
            }
        }
    }
}
impl AssociateResolverEndpointIpAddressOutput {
    /// Creates a new builder-style object to manufacture [`AssociateResolverEndpointIpAddressOutput`](crate::output::AssociateResolverEndpointIpAddressOutput)
    pub fn builder() -> crate::output::associate_resolver_endpoint_ip_address_output::Builder {
        crate::output::associate_resolver_endpoint_ip_address_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateFirewallRuleGroupOutput {
    /// <p>The association that you just created. The association has an ID that you can use to
    /// identify it in other requests, like update and delete.</p>
    pub firewall_rule_group_association:
        std::option::Option<crate::model::FirewallRuleGroupAssociation>,
}
impl std::fmt::Debug for AssociateFirewallRuleGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateFirewallRuleGroupOutput");
        formatter.field(
            "firewall_rule_group_association",
            &self.firewall_rule_group_association,
        );
        formatter.finish()
    }
}
/// See [`AssociateFirewallRuleGroupOutput`](crate::output::AssociateFirewallRuleGroupOutput)
pub mod associate_firewall_rule_group_output {
    /// A builder for [`AssociateFirewallRuleGroupOutput`](crate::output::AssociateFirewallRuleGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_rule_group_association:
            std::option::Option<crate::model::FirewallRuleGroupAssociation>,
    }
    impl Builder {
        /// <p>The association that you just created. The association has an ID that you can use to
        /// identify it in other requests, like update and delete.</p>
        pub fn firewall_rule_group_association(
            mut self,
            input: crate::model::FirewallRuleGroupAssociation,
        ) -> Self {
            self.firewall_rule_group_association = Some(input);
            self
        }
        /// <p>The association that you just created. The association has an ID that you can use to
        /// identify it in other requests, like update and delete.</p>
        pub fn set_firewall_rule_group_association(
            mut self,
            input: std::option::Option<crate::model::FirewallRuleGroupAssociation>,
        ) -> Self {
            self.firewall_rule_group_association = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateFirewallRuleGroupOutput`](crate::output::AssociateFirewallRuleGroupOutput)
        pub fn build(self) -> crate::output::AssociateFirewallRuleGroupOutput {
            crate::output::AssociateFirewallRuleGroupOutput {
                firewall_rule_group_association: self.firewall_rule_group_association,
            }
        }
    }
}
impl AssociateFirewallRuleGroupOutput {
    /// Creates a new builder-style object to manufacture [`AssociateFirewallRuleGroupOutput`](crate::output::AssociateFirewallRuleGroupOutput)
    pub fn builder() -> crate::output::associate_firewall_rule_group_output::Builder {
        crate::output::associate_firewall_rule_group_output::Builder::default()
    }
}
