// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AssociateFirewallRuleGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_firewall_rule_group`](crate::client::Client::associate_firewall_rule_group).
///
/// See [`crate::client::fluent_builders::AssociateFirewallRuleGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateFirewallRuleGroup {
    _private: (),
}
impl AssociateFirewallRuleGroup {
    /// Creates a new builder-style object to manufacture [`AssociateFirewallRuleGroupInput`](crate::input::AssociateFirewallRuleGroupInput)
    pub fn builder() -> crate::input::associate_firewall_rule_group_input::Builder {
        crate::input::associate_firewall_rule_group_input::Builder::default()
    }
    /// Creates a new `AssociateFirewallRuleGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateFirewallRuleGroup {
    type Output = std::result::Result<
        crate::output::AssociateFirewallRuleGroupOutput,
        crate::error::AssociateFirewallRuleGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_firewall_rule_group_error(response)
        } else {
            crate::operation_deser::parse_associate_firewall_rule_group_response(response)
        }
    }
}

/// Operation shape for `AssociateResolverEndpointIpAddress`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_resolver_endpoint_ip_address`](crate::client::Client::associate_resolver_endpoint_ip_address).
///
/// See [`crate::client::fluent_builders::AssociateResolverEndpointIpAddress`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateResolverEndpointIpAddress {
    _private: (),
}
impl AssociateResolverEndpointIpAddress {
    /// Creates a new builder-style object to manufacture [`AssociateResolverEndpointIpAddressInput`](crate::input::AssociateResolverEndpointIpAddressInput)
    pub fn builder() -> crate::input::associate_resolver_endpoint_ip_address_input::Builder {
        crate::input::associate_resolver_endpoint_ip_address_input::Builder::default()
    }
    /// Creates a new `AssociateResolverEndpointIpAddress` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateResolverEndpointIpAddress {
    type Output = std::result::Result<
        crate::output::AssociateResolverEndpointIpAddressOutput,
        crate::error::AssociateResolverEndpointIpAddressError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_resolver_endpoint_ip_address_error(response)
        } else {
            crate::operation_deser::parse_associate_resolver_endpoint_ip_address_response(response)
        }
    }
}

/// Operation shape for `AssociateResolverQueryLogConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_resolver_query_log_config`](crate::client::Client::associate_resolver_query_log_config).
///
/// See [`crate::client::fluent_builders::AssociateResolverQueryLogConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateResolverQueryLogConfig {
    _private: (),
}
impl AssociateResolverQueryLogConfig {
    /// Creates a new builder-style object to manufacture [`AssociateResolverQueryLogConfigInput`](crate::input::AssociateResolverQueryLogConfigInput)
    pub fn builder() -> crate::input::associate_resolver_query_log_config_input::Builder {
        crate::input::associate_resolver_query_log_config_input::Builder::default()
    }
    /// Creates a new `AssociateResolverQueryLogConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateResolverQueryLogConfig {
    type Output = std::result::Result<
        crate::output::AssociateResolverQueryLogConfigOutput,
        crate::error::AssociateResolverQueryLogConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_resolver_query_log_config_error(response)
        } else {
            crate::operation_deser::parse_associate_resolver_query_log_config_response(response)
        }
    }
}

/// Operation shape for `AssociateResolverRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_resolver_rule`](crate::client::Client::associate_resolver_rule).
///
/// See [`crate::client::fluent_builders::AssociateResolverRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateResolverRule {
    _private: (),
}
impl AssociateResolverRule {
    /// Creates a new builder-style object to manufacture [`AssociateResolverRuleInput`](crate::input::AssociateResolverRuleInput)
    pub fn builder() -> crate::input::associate_resolver_rule_input::Builder {
        crate::input::associate_resolver_rule_input::Builder::default()
    }
    /// Creates a new `AssociateResolverRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateResolverRule {
    type Output = std::result::Result<
        crate::output::AssociateResolverRuleOutput,
        crate::error::AssociateResolverRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_resolver_rule_error(response)
        } else {
            crate::operation_deser::parse_associate_resolver_rule_response(response)
        }
    }
}

/// Operation shape for `CreateFirewallDomainList`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_firewall_domain_list`](crate::client::Client::create_firewall_domain_list).
///
/// See [`crate::client::fluent_builders::CreateFirewallDomainList`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateFirewallDomainList {
    _private: (),
}
impl CreateFirewallDomainList {
    /// Creates a new builder-style object to manufacture [`CreateFirewallDomainListInput`](crate::input::CreateFirewallDomainListInput)
    pub fn builder() -> crate::input::create_firewall_domain_list_input::Builder {
        crate::input::create_firewall_domain_list_input::Builder::default()
    }
    /// Creates a new `CreateFirewallDomainList` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateFirewallDomainList {
    type Output = std::result::Result<
        crate::output::CreateFirewallDomainListOutput,
        crate::error::CreateFirewallDomainListError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_firewall_domain_list_error(response)
        } else {
            crate::operation_deser::parse_create_firewall_domain_list_response(response)
        }
    }
}

/// Operation shape for `CreateFirewallRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_firewall_rule`](crate::client::Client::create_firewall_rule).
///
/// See [`crate::client::fluent_builders::CreateFirewallRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateFirewallRule {
    _private: (),
}
impl CreateFirewallRule {
    /// Creates a new builder-style object to manufacture [`CreateFirewallRuleInput`](crate::input::CreateFirewallRuleInput)
    pub fn builder() -> crate::input::create_firewall_rule_input::Builder {
        crate::input::create_firewall_rule_input::Builder::default()
    }
    /// Creates a new `CreateFirewallRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateFirewallRule {
    type Output = std::result::Result<
        crate::output::CreateFirewallRuleOutput,
        crate::error::CreateFirewallRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_firewall_rule_error(response)
        } else {
            crate::operation_deser::parse_create_firewall_rule_response(response)
        }
    }
}

/// Operation shape for `CreateFirewallRuleGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_firewall_rule_group`](crate::client::Client::create_firewall_rule_group).
///
/// See [`crate::client::fluent_builders::CreateFirewallRuleGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateFirewallRuleGroup {
    _private: (),
}
impl CreateFirewallRuleGroup {
    /// Creates a new builder-style object to manufacture [`CreateFirewallRuleGroupInput`](crate::input::CreateFirewallRuleGroupInput)
    pub fn builder() -> crate::input::create_firewall_rule_group_input::Builder {
        crate::input::create_firewall_rule_group_input::Builder::default()
    }
    /// Creates a new `CreateFirewallRuleGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateFirewallRuleGroup {
    type Output = std::result::Result<
        crate::output::CreateFirewallRuleGroupOutput,
        crate::error::CreateFirewallRuleGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_firewall_rule_group_error(response)
        } else {
            crate::operation_deser::parse_create_firewall_rule_group_response(response)
        }
    }
}

/// Operation shape for `CreateResolverEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_resolver_endpoint`](crate::client::Client::create_resolver_endpoint).
///
/// See [`crate::client::fluent_builders::CreateResolverEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateResolverEndpoint {
    _private: (),
}
impl CreateResolverEndpoint {
    /// Creates a new builder-style object to manufacture [`CreateResolverEndpointInput`](crate::input::CreateResolverEndpointInput)
    pub fn builder() -> crate::input::create_resolver_endpoint_input::Builder {
        crate::input::create_resolver_endpoint_input::Builder::default()
    }
    /// Creates a new `CreateResolverEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateResolverEndpoint {
    type Output = std::result::Result<
        crate::output::CreateResolverEndpointOutput,
        crate::error::CreateResolverEndpointError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_resolver_endpoint_error(response)
        } else {
            crate::operation_deser::parse_create_resolver_endpoint_response(response)
        }
    }
}

/// Operation shape for `CreateResolverQueryLogConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_resolver_query_log_config`](crate::client::Client::create_resolver_query_log_config).
///
/// See [`crate::client::fluent_builders::CreateResolverQueryLogConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateResolverQueryLogConfig {
    _private: (),
}
impl CreateResolverQueryLogConfig {
    /// Creates a new builder-style object to manufacture [`CreateResolverQueryLogConfigInput`](crate::input::CreateResolverQueryLogConfigInput)
    pub fn builder() -> crate::input::create_resolver_query_log_config_input::Builder {
        crate::input::create_resolver_query_log_config_input::Builder::default()
    }
    /// Creates a new `CreateResolverQueryLogConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateResolverQueryLogConfig {
    type Output = std::result::Result<
        crate::output::CreateResolverQueryLogConfigOutput,
        crate::error::CreateResolverQueryLogConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_resolver_query_log_config_error(response)
        } else {
            crate::operation_deser::parse_create_resolver_query_log_config_response(response)
        }
    }
}

/// Operation shape for `CreateResolverRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_resolver_rule`](crate::client::Client::create_resolver_rule).
///
/// See [`crate::client::fluent_builders::CreateResolverRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateResolverRule {
    _private: (),
}
impl CreateResolverRule {
    /// Creates a new builder-style object to manufacture [`CreateResolverRuleInput`](crate::input::CreateResolverRuleInput)
    pub fn builder() -> crate::input::create_resolver_rule_input::Builder {
        crate::input::create_resolver_rule_input::Builder::default()
    }
    /// Creates a new `CreateResolverRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateResolverRule {
    type Output = std::result::Result<
        crate::output::CreateResolverRuleOutput,
        crate::error::CreateResolverRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_resolver_rule_error(response)
        } else {
            crate::operation_deser::parse_create_resolver_rule_response(response)
        }
    }
}

/// Operation shape for `DeleteFirewallDomainList`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_firewall_domain_list`](crate::client::Client::delete_firewall_domain_list).
///
/// See [`crate::client::fluent_builders::DeleteFirewallDomainList`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFirewallDomainList {
    _private: (),
}
impl DeleteFirewallDomainList {
    /// Creates a new builder-style object to manufacture [`DeleteFirewallDomainListInput`](crate::input::DeleteFirewallDomainListInput)
    pub fn builder() -> crate::input::delete_firewall_domain_list_input::Builder {
        crate::input::delete_firewall_domain_list_input::Builder::default()
    }
    /// Creates a new `DeleteFirewallDomainList` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFirewallDomainList {
    type Output = std::result::Result<
        crate::output::DeleteFirewallDomainListOutput,
        crate::error::DeleteFirewallDomainListError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_firewall_domain_list_error(response)
        } else {
            crate::operation_deser::parse_delete_firewall_domain_list_response(response)
        }
    }
}

/// Operation shape for `DeleteFirewallRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_firewall_rule`](crate::client::Client::delete_firewall_rule).
///
/// See [`crate::client::fluent_builders::DeleteFirewallRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFirewallRule {
    _private: (),
}
impl DeleteFirewallRule {
    /// Creates a new builder-style object to manufacture [`DeleteFirewallRuleInput`](crate::input::DeleteFirewallRuleInput)
    pub fn builder() -> crate::input::delete_firewall_rule_input::Builder {
        crate::input::delete_firewall_rule_input::Builder::default()
    }
    /// Creates a new `DeleteFirewallRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFirewallRule {
    type Output = std::result::Result<
        crate::output::DeleteFirewallRuleOutput,
        crate::error::DeleteFirewallRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_firewall_rule_error(response)
        } else {
            crate::operation_deser::parse_delete_firewall_rule_response(response)
        }
    }
}

/// Operation shape for `DeleteFirewallRuleGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_firewall_rule_group`](crate::client::Client::delete_firewall_rule_group).
///
/// See [`crate::client::fluent_builders::DeleteFirewallRuleGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFirewallRuleGroup {
    _private: (),
}
impl DeleteFirewallRuleGroup {
    /// Creates a new builder-style object to manufacture [`DeleteFirewallRuleGroupInput`](crate::input::DeleteFirewallRuleGroupInput)
    pub fn builder() -> crate::input::delete_firewall_rule_group_input::Builder {
        crate::input::delete_firewall_rule_group_input::Builder::default()
    }
    /// Creates a new `DeleteFirewallRuleGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFirewallRuleGroup {
    type Output = std::result::Result<
        crate::output::DeleteFirewallRuleGroupOutput,
        crate::error::DeleteFirewallRuleGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_firewall_rule_group_error(response)
        } else {
            crate::operation_deser::parse_delete_firewall_rule_group_response(response)
        }
    }
}

/// Operation shape for `DeleteResolverEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_resolver_endpoint`](crate::client::Client::delete_resolver_endpoint).
///
/// See [`crate::client::fluent_builders::DeleteResolverEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteResolverEndpoint {
    _private: (),
}
impl DeleteResolverEndpoint {
    /// Creates a new builder-style object to manufacture [`DeleteResolverEndpointInput`](crate::input::DeleteResolverEndpointInput)
    pub fn builder() -> crate::input::delete_resolver_endpoint_input::Builder {
        crate::input::delete_resolver_endpoint_input::Builder::default()
    }
    /// Creates a new `DeleteResolverEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteResolverEndpoint {
    type Output = std::result::Result<
        crate::output::DeleteResolverEndpointOutput,
        crate::error::DeleteResolverEndpointError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_resolver_endpoint_error(response)
        } else {
            crate::operation_deser::parse_delete_resolver_endpoint_response(response)
        }
    }
}

/// Operation shape for `DeleteResolverQueryLogConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_resolver_query_log_config`](crate::client::Client::delete_resolver_query_log_config).
///
/// See [`crate::client::fluent_builders::DeleteResolverQueryLogConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteResolverQueryLogConfig {
    _private: (),
}
impl DeleteResolverQueryLogConfig {
    /// Creates a new builder-style object to manufacture [`DeleteResolverQueryLogConfigInput`](crate::input::DeleteResolverQueryLogConfigInput)
    pub fn builder() -> crate::input::delete_resolver_query_log_config_input::Builder {
        crate::input::delete_resolver_query_log_config_input::Builder::default()
    }
    /// Creates a new `DeleteResolverQueryLogConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteResolverQueryLogConfig {
    type Output = std::result::Result<
        crate::output::DeleteResolverQueryLogConfigOutput,
        crate::error::DeleteResolverQueryLogConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_resolver_query_log_config_error(response)
        } else {
            crate::operation_deser::parse_delete_resolver_query_log_config_response(response)
        }
    }
}

/// Operation shape for `DeleteResolverRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_resolver_rule`](crate::client::Client::delete_resolver_rule).
///
/// See [`crate::client::fluent_builders::DeleteResolverRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteResolverRule {
    _private: (),
}
impl DeleteResolverRule {
    /// Creates a new builder-style object to manufacture [`DeleteResolverRuleInput`](crate::input::DeleteResolverRuleInput)
    pub fn builder() -> crate::input::delete_resolver_rule_input::Builder {
        crate::input::delete_resolver_rule_input::Builder::default()
    }
    /// Creates a new `DeleteResolverRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteResolverRule {
    type Output = std::result::Result<
        crate::output::DeleteResolverRuleOutput,
        crate::error::DeleteResolverRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_resolver_rule_error(response)
        } else {
            crate::operation_deser::parse_delete_resolver_rule_response(response)
        }
    }
}

/// Operation shape for `DisassociateFirewallRuleGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_firewall_rule_group`](crate::client::Client::disassociate_firewall_rule_group).
///
/// See [`crate::client::fluent_builders::DisassociateFirewallRuleGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateFirewallRuleGroup {
    _private: (),
}
impl DisassociateFirewallRuleGroup {
    /// Creates a new builder-style object to manufacture [`DisassociateFirewallRuleGroupInput`](crate::input::DisassociateFirewallRuleGroupInput)
    pub fn builder() -> crate::input::disassociate_firewall_rule_group_input::Builder {
        crate::input::disassociate_firewall_rule_group_input::Builder::default()
    }
    /// Creates a new `DisassociateFirewallRuleGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateFirewallRuleGroup {
    type Output = std::result::Result<
        crate::output::DisassociateFirewallRuleGroupOutput,
        crate::error::DisassociateFirewallRuleGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_firewall_rule_group_error(response)
        } else {
            crate::operation_deser::parse_disassociate_firewall_rule_group_response(response)
        }
    }
}

/// Operation shape for `DisassociateResolverEndpointIpAddress`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_resolver_endpoint_ip_address`](crate::client::Client::disassociate_resolver_endpoint_ip_address).
///
/// See [`crate::client::fluent_builders::DisassociateResolverEndpointIpAddress`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateResolverEndpointIpAddress {
    _private: (),
}
impl DisassociateResolverEndpointIpAddress {
    /// Creates a new builder-style object to manufacture [`DisassociateResolverEndpointIpAddressInput`](crate::input::DisassociateResolverEndpointIpAddressInput)
    pub fn builder() -> crate::input::disassociate_resolver_endpoint_ip_address_input::Builder {
        crate::input::disassociate_resolver_endpoint_ip_address_input::Builder::default()
    }
    /// Creates a new `DisassociateResolverEndpointIpAddress` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateResolverEndpointIpAddress {
    type Output = std::result::Result<
        crate::output::DisassociateResolverEndpointIpAddressOutput,
        crate::error::DisassociateResolverEndpointIpAddressError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_resolver_endpoint_ip_address_error(response)
        } else {
            crate::operation_deser::parse_disassociate_resolver_endpoint_ip_address_response(
                response,
            )
        }
    }
}

/// Operation shape for `DisassociateResolverQueryLogConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_resolver_query_log_config`](crate::client::Client::disassociate_resolver_query_log_config).
///
/// See [`crate::client::fluent_builders::DisassociateResolverQueryLogConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateResolverQueryLogConfig {
    _private: (),
}
impl DisassociateResolverQueryLogConfig {
    /// Creates a new builder-style object to manufacture [`DisassociateResolverQueryLogConfigInput`](crate::input::DisassociateResolverQueryLogConfigInput)
    pub fn builder() -> crate::input::disassociate_resolver_query_log_config_input::Builder {
        crate::input::disassociate_resolver_query_log_config_input::Builder::default()
    }
    /// Creates a new `DisassociateResolverQueryLogConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateResolverQueryLogConfig {
    type Output = std::result::Result<
        crate::output::DisassociateResolverQueryLogConfigOutput,
        crate::error::DisassociateResolverQueryLogConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_resolver_query_log_config_error(response)
        } else {
            crate::operation_deser::parse_disassociate_resolver_query_log_config_response(response)
        }
    }
}

/// Operation shape for `DisassociateResolverRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_resolver_rule`](crate::client::Client::disassociate_resolver_rule).
///
/// See [`crate::client::fluent_builders::DisassociateResolverRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateResolverRule {
    _private: (),
}
impl DisassociateResolverRule {
    /// Creates a new builder-style object to manufacture [`DisassociateResolverRuleInput`](crate::input::DisassociateResolverRuleInput)
    pub fn builder() -> crate::input::disassociate_resolver_rule_input::Builder {
        crate::input::disassociate_resolver_rule_input::Builder::default()
    }
    /// Creates a new `DisassociateResolverRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateResolverRule {
    type Output = std::result::Result<
        crate::output::DisassociateResolverRuleOutput,
        crate::error::DisassociateResolverRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_resolver_rule_error(response)
        } else {
            crate::operation_deser::parse_disassociate_resolver_rule_response(response)
        }
    }
}

/// Operation shape for `GetFirewallConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_firewall_config`](crate::client::Client::get_firewall_config).
///
/// See [`crate::client::fluent_builders::GetFirewallConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFirewallConfig {
    _private: (),
}
impl GetFirewallConfig {
    /// Creates a new builder-style object to manufacture [`GetFirewallConfigInput`](crate::input::GetFirewallConfigInput)
    pub fn builder() -> crate::input::get_firewall_config_input::Builder {
        crate::input::get_firewall_config_input::Builder::default()
    }
    /// Creates a new `GetFirewallConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFirewallConfig {
    type Output = std::result::Result<
        crate::output::GetFirewallConfigOutput,
        crate::error::GetFirewallConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_firewall_config_error(response)
        } else {
            crate::operation_deser::parse_get_firewall_config_response(response)
        }
    }
}

/// Operation shape for `GetFirewallDomainList`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_firewall_domain_list`](crate::client::Client::get_firewall_domain_list).
///
/// See [`crate::client::fluent_builders::GetFirewallDomainList`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFirewallDomainList {
    _private: (),
}
impl GetFirewallDomainList {
    /// Creates a new builder-style object to manufacture [`GetFirewallDomainListInput`](crate::input::GetFirewallDomainListInput)
    pub fn builder() -> crate::input::get_firewall_domain_list_input::Builder {
        crate::input::get_firewall_domain_list_input::Builder::default()
    }
    /// Creates a new `GetFirewallDomainList` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFirewallDomainList {
    type Output = std::result::Result<
        crate::output::GetFirewallDomainListOutput,
        crate::error::GetFirewallDomainListError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_firewall_domain_list_error(response)
        } else {
            crate::operation_deser::parse_get_firewall_domain_list_response(response)
        }
    }
}

/// Operation shape for `GetFirewallRuleGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_firewall_rule_group`](crate::client::Client::get_firewall_rule_group).
///
/// See [`crate::client::fluent_builders::GetFirewallRuleGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFirewallRuleGroup {
    _private: (),
}
impl GetFirewallRuleGroup {
    /// Creates a new builder-style object to manufacture [`GetFirewallRuleGroupInput`](crate::input::GetFirewallRuleGroupInput)
    pub fn builder() -> crate::input::get_firewall_rule_group_input::Builder {
        crate::input::get_firewall_rule_group_input::Builder::default()
    }
    /// Creates a new `GetFirewallRuleGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFirewallRuleGroup {
    type Output = std::result::Result<
        crate::output::GetFirewallRuleGroupOutput,
        crate::error::GetFirewallRuleGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_firewall_rule_group_error(response)
        } else {
            crate::operation_deser::parse_get_firewall_rule_group_response(response)
        }
    }
}

/// Operation shape for `GetFirewallRuleGroupAssociation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_firewall_rule_group_association`](crate::client::Client::get_firewall_rule_group_association).
///
/// See [`crate::client::fluent_builders::GetFirewallRuleGroupAssociation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFirewallRuleGroupAssociation {
    _private: (),
}
impl GetFirewallRuleGroupAssociation {
    /// Creates a new builder-style object to manufacture [`GetFirewallRuleGroupAssociationInput`](crate::input::GetFirewallRuleGroupAssociationInput)
    pub fn builder() -> crate::input::get_firewall_rule_group_association_input::Builder {
        crate::input::get_firewall_rule_group_association_input::Builder::default()
    }
    /// Creates a new `GetFirewallRuleGroupAssociation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFirewallRuleGroupAssociation {
    type Output = std::result::Result<
        crate::output::GetFirewallRuleGroupAssociationOutput,
        crate::error::GetFirewallRuleGroupAssociationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_firewall_rule_group_association_error(response)
        } else {
            crate::operation_deser::parse_get_firewall_rule_group_association_response(response)
        }
    }
}

/// Operation shape for `GetFirewallRuleGroupPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_firewall_rule_group_policy`](crate::client::Client::get_firewall_rule_group_policy).
///
/// See [`crate::client::fluent_builders::GetFirewallRuleGroupPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFirewallRuleGroupPolicy {
    _private: (),
}
impl GetFirewallRuleGroupPolicy {
    /// Creates a new builder-style object to manufacture [`GetFirewallRuleGroupPolicyInput`](crate::input::GetFirewallRuleGroupPolicyInput)
    pub fn builder() -> crate::input::get_firewall_rule_group_policy_input::Builder {
        crate::input::get_firewall_rule_group_policy_input::Builder::default()
    }
    /// Creates a new `GetFirewallRuleGroupPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFirewallRuleGroupPolicy {
    type Output = std::result::Result<
        crate::output::GetFirewallRuleGroupPolicyOutput,
        crate::error::GetFirewallRuleGroupPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_firewall_rule_group_policy_error(response)
        } else {
            crate::operation_deser::parse_get_firewall_rule_group_policy_response(response)
        }
    }
}

/// Operation shape for `GetResolverDnssecConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_resolver_dnssec_config`](crate::client::Client::get_resolver_dnssec_config).
///
/// See [`crate::client::fluent_builders::GetResolverDnssecConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetResolverDnssecConfig {
    _private: (),
}
impl GetResolverDnssecConfig {
    /// Creates a new builder-style object to manufacture [`GetResolverDnssecConfigInput`](crate::input::GetResolverDnssecConfigInput)
    pub fn builder() -> crate::input::get_resolver_dnssec_config_input::Builder {
        crate::input::get_resolver_dnssec_config_input::Builder::default()
    }
    /// Creates a new `GetResolverDnssecConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetResolverDnssecConfig {
    type Output = std::result::Result<
        crate::output::GetResolverDnssecConfigOutput,
        crate::error::GetResolverDnssecConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_resolver_dnssec_config_error(response)
        } else {
            crate::operation_deser::parse_get_resolver_dnssec_config_response(response)
        }
    }
}

/// Operation shape for `GetResolverEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_resolver_endpoint`](crate::client::Client::get_resolver_endpoint).
///
/// See [`crate::client::fluent_builders::GetResolverEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetResolverEndpoint {
    _private: (),
}
impl GetResolverEndpoint {
    /// Creates a new builder-style object to manufacture [`GetResolverEndpointInput`](crate::input::GetResolverEndpointInput)
    pub fn builder() -> crate::input::get_resolver_endpoint_input::Builder {
        crate::input::get_resolver_endpoint_input::Builder::default()
    }
    /// Creates a new `GetResolverEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetResolverEndpoint {
    type Output = std::result::Result<
        crate::output::GetResolverEndpointOutput,
        crate::error::GetResolverEndpointError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_resolver_endpoint_error(response)
        } else {
            crate::operation_deser::parse_get_resolver_endpoint_response(response)
        }
    }
}

/// Operation shape for `GetResolverQueryLogConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_resolver_query_log_config`](crate::client::Client::get_resolver_query_log_config).
///
/// See [`crate::client::fluent_builders::GetResolverQueryLogConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetResolverQueryLogConfig {
    _private: (),
}
impl GetResolverQueryLogConfig {
    /// Creates a new builder-style object to manufacture [`GetResolverQueryLogConfigInput`](crate::input::GetResolverQueryLogConfigInput)
    pub fn builder() -> crate::input::get_resolver_query_log_config_input::Builder {
        crate::input::get_resolver_query_log_config_input::Builder::default()
    }
    /// Creates a new `GetResolverQueryLogConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetResolverQueryLogConfig {
    type Output = std::result::Result<
        crate::output::GetResolverQueryLogConfigOutput,
        crate::error::GetResolverQueryLogConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_resolver_query_log_config_error(response)
        } else {
            crate::operation_deser::parse_get_resolver_query_log_config_response(response)
        }
    }
}

/// Operation shape for `GetResolverQueryLogConfigAssociation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_resolver_query_log_config_association`](crate::client::Client::get_resolver_query_log_config_association).
///
/// See [`crate::client::fluent_builders::GetResolverQueryLogConfigAssociation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetResolverQueryLogConfigAssociation {
    _private: (),
}
impl GetResolverQueryLogConfigAssociation {
    /// Creates a new builder-style object to manufacture [`GetResolverQueryLogConfigAssociationInput`](crate::input::GetResolverQueryLogConfigAssociationInput)
    pub fn builder() -> crate::input::get_resolver_query_log_config_association_input::Builder {
        crate::input::get_resolver_query_log_config_association_input::Builder::default()
    }
    /// Creates a new `GetResolverQueryLogConfigAssociation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetResolverQueryLogConfigAssociation {
    type Output = std::result::Result<
        crate::output::GetResolverQueryLogConfigAssociationOutput,
        crate::error::GetResolverQueryLogConfigAssociationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_resolver_query_log_config_association_error(response)
        } else {
            crate::operation_deser::parse_get_resolver_query_log_config_association_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetResolverQueryLogConfigPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_resolver_query_log_config_policy`](crate::client::Client::get_resolver_query_log_config_policy).
///
/// See [`crate::client::fluent_builders::GetResolverQueryLogConfigPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetResolverQueryLogConfigPolicy {
    _private: (),
}
impl GetResolverQueryLogConfigPolicy {
    /// Creates a new builder-style object to manufacture [`GetResolverQueryLogConfigPolicyInput`](crate::input::GetResolverQueryLogConfigPolicyInput)
    pub fn builder() -> crate::input::get_resolver_query_log_config_policy_input::Builder {
        crate::input::get_resolver_query_log_config_policy_input::Builder::default()
    }
    /// Creates a new `GetResolverQueryLogConfigPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetResolverQueryLogConfigPolicy {
    type Output = std::result::Result<
        crate::output::GetResolverQueryLogConfigPolicyOutput,
        crate::error::GetResolverQueryLogConfigPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_resolver_query_log_config_policy_error(response)
        } else {
            crate::operation_deser::parse_get_resolver_query_log_config_policy_response(response)
        }
    }
}

/// Operation shape for `GetResolverRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_resolver_rule`](crate::client::Client::get_resolver_rule).
///
/// See [`crate::client::fluent_builders::GetResolverRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetResolverRule {
    _private: (),
}
impl GetResolverRule {
    /// Creates a new builder-style object to manufacture [`GetResolverRuleInput`](crate::input::GetResolverRuleInput)
    pub fn builder() -> crate::input::get_resolver_rule_input::Builder {
        crate::input::get_resolver_rule_input::Builder::default()
    }
    /// Creates a new `GetResolverRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetResolverRule {
    type Output = std::result::Result<
        crate::output::GetResolverRuleOutput,
        crate::error::GetResolverRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_resolver_rule_error(response)
        } else {
            crate::operation_deser::parse_get_resolver_rule_response(response)
        }
    }
}

/// Operation shape for `GetResolverRuleAssociation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_resolver_rule_association`](crate::client::Client::get_resolver_rule_association).
///
/// See [`crate::client::fluent_builders::GetResolverRuleAssociation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetResolverRuleAssociation {
    _private: (),
}
impl GetResolverRuleAssociation {
    /// Creates a new builder-style object to manufacture [`GetResolverRuleAssociationInput`](crate::input::GetResolverRuleAssociationInput)
    pub fn builder() -> crate::input::get_resolver_rule_association_input::Builder {
        crate::input::get_resolver_rule_association_input::Builder::default()
    }
    /// Creates a new `GetResolverRuleAssociation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetResolverRuleAssociation {
    type Output = std::result::Result<
        crate::output::GetResolverRuleAssociationOutput,
        crate::error::GetResolverRuleAssociationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_resolver_rule_association_error(response)
        } else {
            crate::operation_deser::parse_get_resolver_rule_association_response(response)
        }
    }
}

/// Operation shape for `GetResolverRulePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_resolver_rule_policy`](crate::client::Client::get_resolver_rule_policy).
///
/// See [`crate::client::fluent_builders::GetResolverRulePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetResolverRulePolicy {
    _private: (),
}
impl GetResolverRulePolicy {
    /// Creates a new builder-style object to manufacture [`GetResolverRulePolicyInput`](crate::input::GetResolverRulePolicyInput)
    pub fn builder() -> crate::input::get_resolver_rule_policy_input::Builder {
        crate::input::get_resolver_rule_policy_input::Builder::default()
    }
    /// Creates a new `GetResolverRulePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetResolverRulePolicy {
    type Output = std::result::Result<
        crate::output::GetResolverRulePolicyOutput,
        crate::error::GetResolverRulePolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_resolver_rule_policy_error(response)
        } else {
            crate::operation_deser::parse_get_resolver_rule_policy_response(response)
        }
    }
}

/// Operation shape for `ImportFirewallDomains`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`import_firewall_domains`](crate::client::Client::import_firewall_domains).
///
/// See [`crate::client::fluent_builders::ImportFirewallDomains`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ImportFirewallDomains {
    _private: (),
}
impl ImportFirewallDomains {
    /// Creates a new builder-style object to manufacture [`ImportFirewallDomainsInput`](crate::input::ImportFirewallDomainsInput)
    pub fn builder() -> crate::input::import_firewall_domains_input::Builder {
        crate::input::import_firewall_domains_input::Builder::default()
    }
    /// Creates a new `ImportFirewallDomains` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ImportFirewallDomains {
    type Output = std::result::Result<
        crate::output::ImportFirewallDomainsOutput,
        crate::error::ImportFirewallDomainsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_import_firewall_domains_error(response)
        } else {
            crate::operation_deser::parse_import_firewall_domains_response(response)
        }
    }
}

/// Operation shape for `ListFirewallConfigs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_firewall_configs`](crate::client::Client::list_firewall_configs).
///
/// See [`crate::client::fluent_builders::ListFirewallConfigs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFirewallConfigs {
    _private: (),
}
impl ListFirewallConfigs {
    /// Creates a new builder-style object to manufacture [`ListFirewallConfigsInput`](crate::input::ListFirewallConfigsInput)
    pub fn builder() -> crate::input::list_firewall_configs_input::Builder {
        crate::input::list_firewall_configs_input::Builder::default()
    }
    /// Creates a new `ListFirewallConfigs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFirewallConfigs {
    type Output = std::result::Result<
        crate::output::ListFirewallConfigsOutput,
        crate::error::ListFirewallConfigsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_firewall_configs_error(response)
        } else {
            crate::operation_deser::parse_list_firewall_configs_response(response)
        }
    }
}

/// Operation shape for `ListFirewallDomainLists`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_firewall_domain_lists`](crate::client::Client::list_firewall_domain_lists).
///
/// See [`crate::client::fluent_builders::ListFirewallDomainLists`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFirewallDomainLists {
    _private: (),
}
impl ListFirewallDomainLists {
    /// Creates a new builder-style object to manufacture [`ListFirewallDomainListsInput`](crate::input::ListFirewallDomainListsInput)
    pub fn builder() -> crate::input::list_firewall_domain_lists_input::Builder {
        crate::input::list_firewall_domain_lists_input::Builder::default()
    }
    /// Creates a new `ListFirewallDomainLists` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFirewallDomainLists {
    type Output = std::result::Result<
        crate::output::ListFirewallDomainListsOutput,
        crate::error::ListFirewallDomainListsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_firewall_domain_lists_error(response)
        } else {
            crate::operation_deser::parse_list_firewall_domain_lists_response(response)
        }
    }
}

/// Operation shape for `ListFirewallDomains`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_firewall_domains`](crate::client::Client::list_firewall_domains).
///
/// See [`crate::client::fluent_builders::ListFirewallDomains`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFirewallDomains {
    _private: (),
}
impl ListFirewallDomains {
    /// Creates a new builder-style object to manufacture [`ListFirewallDomainsInput`](crate::input::ListFirewallDomainsInput)
    pub fn builder() -> crate::input::list_firewall_domains_input::Builder {
        crate::input::list_firewall_domains_input::Builder::default()
    }
    /// Creates a new `ListFirewallDomains` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFirewallDomains {
    type Output = std::result::Result<
        crate::output::ListFirewallDomainsOutput,
        crate::error::ListFirewallDomainsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_firewall_domains_error(response)
        } else {
            crate::operation_deser::parse_list_firewall_domains_response(response)
        }
    }
}

/// Operation shape for `ListFirewallRuleGroupAssociations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_firewall_rule_group_associations`](crate::client::Client::list_firewall_rule_group_associations).
///
/// See [`crate::client::fluent_builders::ListFirewallRuleGroupAssociations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFirewallRuleGroupAssociations {
    _private: (),
}
impl ListFirewallRuleGroupAssociations {
    /// Creates a new builder-style object to manufacture [`ListFirewallRuleGroupAssociationsInput`](crate::input::ListFirewallRuleGroupAssociationsInput)
    pub fn builder() -> crate::input::list_firewall_rule_group_associations_input::Builder {
        crate::input::list_firewall_rule_group_associations_input::Builder::default()
    }
    /// Creates a new `ListFirewallRuleGroupAssociations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFirewallRuleGroupAssociations {
    type Output = std::result::Result<
        crate::output::ListFirewallRuleGroupAssociationsOutput,
        crate::error::ListFirewallRuleGroupAssociationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_firewall_rule_group_associations_error(response)
        } else {
            crate::operation_deser::parse_list_firewall_rule_group_associations_response(response)
        }
    }
}

/// Operation shape for `ListFirewallRuleGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_firewall_rule_groups`](crate::client::Client::list_firewall_rule_groups).
///
/// See [`crate::client::fluent_builders::ListFirewallRuleGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFirewallRuleGroups {
    _private: (),
}
impl ListFirewallRuleGroups {
    /// Creates a new builder-style object to manufacture [`ListFirewallRuleGroupsInput`](crate::input::ListFirewallRuleGroupsInput)
    pub fn builder() -> crate::input::list_firewall_rule_groups_input::Builder {
        crate::input::list_firewall_rule_groups_input::Builder::default()
    }
    /// Creates a new `ListFirewallRuleGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFirewallRuleGroups {
    type Output = std::result::Result<
        crate::output::ListFirewallRuleGroupsOutput,
        crate::error::ListFirewallRuleGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_firewall_rule_groups_error(response)
        } else {
            crate::operation_deser::parse_list_firewall_rule_groups_response(response)
        }
    }
}

/// Operation shape for `ListFirewallRules`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_firewall_rules`](crate::client::Client::list_firewall_rules).
///
/// See [`crate::client::fluent_builders::ListFirewallRules`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFirewallRules {
    _private: (),
}
impl ListFirewallRules {
    /// Creates a new builder-style object to manufacture [`ListFirewallRulesInput`](crate::input::ListFirewallRulesInput)
    pub fn builder() -> crate::input::list_firewall_rules_input::Builder {
        crate::input::list_firewall_rules_input::Builder::default()
    }
    /// Creates a new `ListFirewallRules` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFirewallRules {
    type Output = std::result::Result<
        crate::output::ListFirewallRulesOutput,
        crate::error::ListFirewallRulesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_firewall_rules_error(response)
        } else {
            crate::operation_deser::parse_list_firewall_rules_response(response)
        }
    }
}

/// Operation shape for `ListResolverDnssecConfigs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_resolver_dnssec_configs`](crate::client::Client::list_resolver_dnssec_configs).
///
/// See [`crate::client::fluent_builders::ListResolverDnssecConfigs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListResolverDnssecConfigs {
    _private: (),
}
impl ListResolverDnssecConfigs {
    /// Creates a new builder-style object to manufacture [`ListResolverDnssecConfigsInput`](crate::input::ListResolverDnssecConfigsInput)
    pub fn builder() -> crate::input::list_resolver_dnssec_configs_input::Builder {
        crate::input::list_resolver_dnssec_configs_input::Builder::default()
    }
    /// Creates a new `ListResolverDnssecConfigs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListResolverDnssecConfigs {
    type Output = std::result::Result<
        crate::output::ListResolverDnssecConfigsOutput,
        crate::error::ListResolverDnssecConfigsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_resolver_dnssec_configs_error(response)
        } else {
            crate::operation_deser::parse_list_resolver_dnssec_configs_response(response)
        }
    }
}

/// Operation shape for `ListResolverEndpointIpAddresses`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_resolver_endpoint_ip_addresses`](crate::client::Client::list_resolver_endpoint_ip_addresses).
///
/// See [`crate::client::fluent_builders::ListResolverEndpointIpAddresses`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListResolverEndpointIpAddresses {
    _private: (),
}
impl ListResolverEndpointIpAddresses {
    /// Creates a new builder-style object to manufacture [`ListResolverEndpointIpAddressesInput`](crate::input::ListResolverEndpointIpAddressesInput)
    pub fn builder() -> crate::input::list_resolver_endpoint_ip_addresses_input::Builder {
        crate::input::list_resolver_endpoint_ip_addresses_input::Builder::default()
    }
    /// Creates a new `ListResolverEndpointIpAddresses` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListResolverEndpointIpAddresses {
    type Output = std::result::Result<
        crate::output::ListResolverEndpointIpAddressesOutput,
        crate::error::ListResolverEndpointIpAddressesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_resolver_endpoint_ip_addresses_error(response)
        } else {
            crate::operation_deser::parse_list_resolver_endpoint_ip_addresses_response(response)
        }
    }
}

/// Operation shape for `ListResolverEndpoints`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_resolver_endpoints`](crate::client::Client::list_resolver_endpoints).
///
/// See [`crate::client::fluent_builders::ListResolverEndpoints`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListResolverEndpoints {
    _private: (),
}
impl ListResolverEndpoints {
    /// Creates a new builder-style object to manufacture [`ListResolverEndpointsInput`](crate::input::ListResolverEndpointsInput)
    pub fn builder() -> crate::input::list_resolver_endpoints_input::Builder {
        crate::input::list_resolver_endpoints_input::Builder::default()
    }
    /// Creates a new `ListResolverEndpoints` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListResolverEndpoints {
    type Output = std::result::Result<
        crate::output::ListResolverEndpointsOutput,
        crate::error::ListResolverEndpointsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_resolver_endpoints_error(response)
        } else {
            crate::operation_deser::parse_list_resolver_endpoints_response(response)
        }
    }
}

/// Operation shape for `ListResolverQueryLogConfigAssociations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_resolver_query_log_config_associations`](crate::client::Client::list_resolver_query_log_config_associations).
///
/// See [`crate::client::fluent_builders::ListResolverQueryLogConfigAssociations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListResolverQueryLogConfigAssociations {
    _private: (),
}
impl ListResolverQueryLogConfigAssociations {
    /// Creates a new builder-style object to manufacture [`ListResolverQueryLogConfigAssociationsInput`](crate::input::ListResolverQueryLogConfigAssociationsInput)
    pub fn builder() -> crate::input::list_resolver_query_log_config_associations_input::Builder {
        crate::input::list_resolver_query_log_config_associations_input::Builder::default()
    }
    /// Creates a new `ListResolverQueryLogConfigAssociations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListResolverQueryLogConfigAssociations {
    type Output = std::result::Result<
        crate::output::ListResolverQueryLogConfigAssociationsOutput,
        crate::error::ListResolverQueryLogConfigAssociationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_resolver_query_log_config_associations_error(
                response,
            )
        } else {
            crate::operation_deser::parse_list_resolver_query_log_config_associations_response(
                response,
            )
        }
    }
}

/// Operation shape for `ListResolverQueryLogConfigs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_resolver_query_log_configs`](crate::client::Client::list_resolver_query_log_configs).
///
/// See [`crate::client::fluent_builders::ListResolverQueryLogConfigs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListResolverQueryLogConfigs {
    _private: (),
}
impl ListResolverQueryLogConfigs {
    /// Creates a new builder-style object to manufacture [`ListResolverQueryLogConfigsInput`](crate::input::ListResolverQueryLogConfigsInput)
    pub fn builder() -> crate::input::list_resolver_query_log_configs_input::Builder {
        crate::input::list_resolver_query_log_configs_input::Builder::default()
    }
    /// Creates a new `ListResolverQueryLogConfigs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListResolverQueryLogConfigs {
    type Output = std::result::Result<
        crate::output::ListResolverQueryLogConfigsOutput,
        crate::error::ListResolverQueryLogConfigsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_resolver_query_log_configs_error(response)
        } else {
            crate::operation_deser::parse_list_resolver_query_log_configs_response(response)
        }
    }
}

/// Operation shape for `ListResolverRuleAssociations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_resolver_rule_associations`](crate::client::Client::list_resolver_rule_associations).
///
/// See [`crate::client::fluent_builders::ListResolverRuleAssociations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListResolverRuleAssociations {
    _private: (),
}
impl ListResolverRuleAssociations {
    /// Creates a new builder-style object to manufacture [`ListResolverRuleAssociationsInput`](crate::input::ListResolverRuleAssociationsInput)
    pub fn builder() -> crate::input::list_resolver_rule_associations_input::Builder {
        crate::input::list_resolver_rule_associations_input::Builder::default()
    }
    /// Creates a new `ListResolverRuleAssociations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListResolverRuleAssociations {
    type Output = std::result::Result<
        crate::output::ListResolverRuleAssociationsOutput,
        crate::error::ListResolverRuleAssociationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_resolver_rule_associations_error(response)
        } else {
            crate::operation_deser::parse_list_resolver_rule_associations_response(response)
        }
    }
}

/// Operation shape for `ListResolverRules`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_resolver_rules`](crate::client::Client::list_resolver_rules).
///
/// See [`crate::client::fluent_builders::ListResolverRules`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListResolverRules {
    _private: (),
}
impl ListResolverRules {
    /// Creates a new builder-style object to manufacture [`ListResolverRulesInput`](crate::input::ListResolverRulesInput)
    pub fn builder() -> crate::input::list_resolver_rules_input::Builder {
        crate::input::list_resolver_rules_input::Builder::default()
    }
    /// Creates a new `ListResolverRules` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListResolverRules {
    type Output = std::result::Result<
        crate::output::ListResolverRulesOutput,
        crate::error::ListResolverRulesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_resolver_rules_error(response)
        } else {
            crate::operation_deser::parse_list_resolver_rules_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `PutFirewallRuleGroupPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_firewall_rule_group_policy`](crate::client::Client::put_firewall_rule_group_policy).
///
/// See [`crate::client::fluent_builders::PutFirewallRuleGroupPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutFirewallRuleGroupPolicy {
    _private: (),
}
impl PutFirewallRuleGroupPolicy {
    /// Creates a new builder-style object to manufacture [`PutFirewallRuleGroupPolicyInput`](crate::input::PutFirewallRuleGroupPolicyInput)
    pub fn builder() -> crate::input::put_firewall_rule_group_policy_input::Builder {
        crate::input::put_firewall_rule_group_policy_input::Builder::default()
    }
    /// Creates a new `PutFirewallRuleGroupPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutFirewallRuleGroupPolicy {
    type Output = std::result::Result<
        crate::output::PutFirewallRuleGroupPolicyOutput,
        crate::error::PutFirewallRuleGroupPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_firewall_rule_group_policy_error(response)
        } else {
            crate::operation_deser::parse_put_firewall_rule_group_policy_response(response)
        }
    }
}

/// Operation shape for `PutResolverQueryLogConfigPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_resolver_query_log_config_policy`](crate::client::Client::put_resolver_query_log_config_policy).
///
/// See [`crate::client::fluent_builders::PutResolverQueryLogConfigPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutResolverQueryLogConfigPolicy {
    _private: (),
}
impl PutResolverQueryLogConfigPolicy {
    /// Creates a new builder-style object to manufacture [`PutResolverQueryLogConfigPolicyInput`](crate::input::PutResolverQueryLogConfigPolicyInput)
    pub fn builder() -> crate::input::put_resolver_query_log_config_policy_input::Builder {
        crate::input::put_resolver_query_log_config_policy_input::Builder::default()
    }
    /// Creates a new `PutResolverQueryLogConfigPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutResolverQueryLogConfigPolicy {
    type Output = std::result::Result<
        crate::output::PutResolverQueryLogConfigPolicyOutput,
        crate::error::PutResolverQueryLogConfigPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_resolver_query_log_config_policy_error(response)
        } else {
            crate::operation_deser::parse_put_resolver_query_log_config_policy_response(response)
        }
    }
}

/// Operation shape for `PutResolverRulePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_resolver_rule_policy`](crate::client::Client::put_resolver_rule_policy).
///
/// See [`crate::client::fluent_builders::PutResolverRulePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutResolverRulePolicy {
    _private: (),
}
impl PutResolverRulePolicy {
    /// Creates a new builder-style object to manufacture [`PutResolverRulePolicyInput`](crate::input::PutResolverRulePolicyInput)
    pub fn builder() -> crate::input::put_resolver_rule_policy_input::Builder {
        crate::input::put_resolver_rule_policy_input::Builder::default()
    }
    /// Creates a new `PutResolverRulePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutResolverRulePolicy {
    type Output = std::result::Result<
        crate::output::PutResolverRulePolicyOutput,
        crate::error::PutResolverRulePolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_resolver_rule_policy_error(response)
        } else {
            crate::operation_deser::parse_put_resolver_rule_policy_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateFirewallConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_firewall_config`](crate::client::Client::update_firewall_config).
///
/// See [`crate::client::fluent_builders::UpdateFirewallConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFirewallConfig {
    _private: (),
}
impl UpdateFirewallConfig {
    /// Creates a new builder-style object to manufacture [`UpdateFirewallConfigInput`](crate::input::UpdateFirewallConfigInput)
    pub fn builder() -> crate::input::update_firewall_config_input::Builder {
        crate::input::update_firewall_config_input::Builder::default()
    }
    /// Creates a new `UpdateFirewallConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFirewallConfig {
    type Output = std::result::Result<
        crate::output::UpdateFirewallConfigOutput,
        crate::error::UpdateFirewallConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_firewall_config_error(response)
        } else {
            crate::operation_deser::parse_update_firewall_config_response(response)
        }
    }
}

/// Operation shape for `UpdateFirewallDomains`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_firewall_domains`](crate::client::Client::update_firewall_domains).
///
/// See [`crate::client::fluent_builders::UpdateFirewallDomains`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFirewallDomains {
    _private: (),
}
impl UpdateFirewallDomains {
    /// Creates a new builder-style object to manufacture [`UpdateFirewallDomainsInput`](crate::input::UpdateFirewallDomainsInput)
    pub fn builder() -> crate::input::update_firewall_domains_input::Builder {
        crate::input::update_firewall_domains_input::Builder::default()
    }
    /// Creates a new `UpdateFirewallDomains` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFirewallDomains {
    type Output = std::result::Result<
        crate::output::UpdateFirewallDomainsOutput,
        crate::error::UpdateFirewallDomainsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_firewall_domains_error(response)
        } else {
            crate::operation_deser::parse_update_firewall_domains_response(response)
        }
    }
}

/// Operation shape for `UpdateFirewallRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_firewall_rule`](crate::client::Client::update_firewall_rule).
///
/// See [`crate::client::fluent_builders::UpdateFirewallRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFirewallRule {
    _private: (),
}
impl UpdateFirewallRule {
    /// Creates a new builder-style object to manufacture [`UpdateFirewallRuleInput`](crate::input::UpdateFirewallRuleInput)
    pub fn builder() -> crate::input::update_firewall_rule_input::Builder {
        crate::input::update_firewall_rule_input::Builder::default()
    }
    /// Creates a new `UpdateFirewallRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFirewallRule {
    type Output = std::result::Result<
        crate::output::UpdateFirewallRuleOutput,
        crate::error::UpdateFirewallRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_firewall_rule_error(response)
        } else {
            crate::operation_deser::parse_update_firewall_rule_response(response)
        }
    }
}

/// Operation shape for `UpdateFirewallRuleGroupAssociation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_firewall_rule_group_association`](crate::client::Client::update_firewall_rule_group_association).
///
/// See [`crate::client::fluent_builders::UpdateFirewallRuleGroupAssociation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFirewallRuleGroupAssociation {
    _private: (),
}
impl UpdateFirewallRuleGroupAssociation {
    /// Creates a new builder-style object to manufacture [`UpdateFirewallRuleGroupAssociationInput`](crate::input::UpdateFirewallRuleGroupAssociationInput)
    pub fn builder() -> crate::input::update_firewall_rule_group_association_input::Builder {
        crate::input::update_firewall_rule_group_association_input::Builder::default()
    }
    /// Creates a new `UpdateFirewallRuleGroupAssociation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFirewallRuleGroupAssociation {
    type Output = std::result::Result<
        crate::output::UpdateFirewallRuleGroupAssociationOutput,
        crate::error::UpdateFirewallRuleGroupAssociationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_firewall_rule_group_association_error(response)
        } else {
            crate::operation_deser::parse_update_firewall_rule_group_association_response(response)
        }
    }
}

/// Operation shape for `UpdateResolverDnssecConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_resolver_dnssec_config`](crate::client::Client::update_resolver_dnssec_config).
///
/// See [`crate::client::fluent_builders::UpdateResolverDnssecConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateResolverDnssecConfig {
    _private: (),
}
impl UpdateResolverDnssecConfig {
    /// Creates a new builder-style object to manufacture [`UpdateResolverDnssecConfigInput`](crate::input::UpdateResolverDnssecConfigInput)
    pub fn builder() -> crate::input::update_resolver_dnssec_config_input::Builder {
        crate::input::update_resolver_dnssec_config_input::Builder::default()
    }
    /// Creates a new `UpdateResolverDnssecConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateResolverDnssecConfig {
    type Output = std::result::Result<
        crate::output::UpdateResolverDnssecConfigOutput,
        crate::error::UpdateResolverDnssecConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_resolver_dnssec_config_error(response)
        } else {
            crate::operation_deser::parse_update_resolver_dnssec_config_response(response)
        }
    }
}

/// Operation shape for `UpdateResolverEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_resolver_endpoint`](crate::client::Client::update_resolver_endpoint).
///
/// See [`crate::client::fluent_builders::UpdateResolverEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateResolverEndpoint {
    _private: (),
}
impl UpdateResolverEndpoint {
    /// Creates a new builder-style object to manufacture [`UpdateResolverEndpointInput`](crate::input::UpdateResolverEndpointInput)
    pub fn builder() -> crate::input::update_resolver_endpoint_input::Builder {
        crate::input::update_resolver_endpoint_input::Builder::default()
    }
    /// Creates a new `UpdateResolverEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateResolverEndpoint {
    type Output = std::result::Result<
        crate::output::UpdateResolverEndpointOutput,
        crate::error::UpdateResolverEndpointError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_resolver_endpoint_error(response)
        } else {
            crate::operation_deser::parse_update_resolver_endpoint_response(response)
        }
    }
}

/// Operation shape for `UpdateResolverRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_resolver_rule`](crate::client::Client::update_resolver_rule).
///
/// See [`crate::client::fluent_builders::UpdateResolverRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateResolverRule {
    _private: (),
}
impl UpdateResolverRule {
    /// Creates a new builder-style object to manufacture [`UpdateResolverRuleInput`](crate::input::UpdateResolverRuleInput)
    pub fn builder() -> crate::input::update_resolver_rule_input::Builder {
        crate::input::update_resolver_rule_input::Builder::default()
    }
    /// Creates a new `UpdateResolverRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateResolverRule {
    type Output = std::result::Result<
        crate::output::UpdateResolverRuleOutput,
        crate::error::UpdateResolverRuleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_resolver_rule_error(response)
        } else {
            crate::operation_deser::parse_update_resolver_rule_response(response)
        }
    }
}
