// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>For queries that originate in your VPC, detailed information about a Resolver rule, which specifies how to route DNS queries
/// out of the VPC. The <code>ResolverRule</code> parameter appears in the response to a
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverRule.html">CreateResolverRule</a>,
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DeleteResolverRule.html">DeleteResolverRule</a>,
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRule.html">GetResolverRule</a>,
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html">ListResolverRules</a>,
/// or
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_UpdateResolverRule.html">UpdateResolverRule</a> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResolverRule {
    /// <p>The ID that Resolver assigned to the Resolver rule when you created it.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>A unique string that you specified when you created the Resolver rule.
    /// <code>CreatorRequestId</code> identifies the request and allows failed requests to
    /// be retried without the risk of running the operation twice. </p>
    pub creator_request_id: std::option::Option<std::string::String>,
    /// <p>The ARN (Amazon Resource Name) for the Resolver rule specified by <code>Id</code>.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>DNS queries for this domain name are forwarded to the IP addresses that are specified in <code>TargetIps</code>. If a query matches
    /// multiple Resolver rules (example.com and www.example.com), the query is routed using the Resolver rule that contains the most specific domain name
    /// (www.example.com).</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>A code that specifies the current status of the Resolver rule.</p>
    pub status: std::option::Option<crate::model::ResolverRuleStatus>,
    /// <p>A detailed description of the status of a Resolver rule.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>When you want to forward DNS queries for specified domain name to resolvers on your network, specify <code>FORWARD</code>.</p>
    /// <p>When you have a forwarding rule to forward DNS queries for a domain to your network and you want Resolver to process queries for
    /// a subdomain of that domain, specify <code>SYSTEM</code>.</p>
    /// <p>For example, to forward DNS queries for example.com to resolvers on your network, you create a rule and specify <code>FORWARD</code>
    /// for <code>RuleType</code>. To then have Resolver process queries for apex.example.com, you create a rule and specify
    /// <code>SYSTEM</code> for <code>RuleType</code>.</p>
    /// <p>Currently, only Resolver can create rules that have a value of <code>RECURSIVE</code> for <code>RuleType</code>.</p>
    pub rule_type: std::option::Option<crate::model::RuleTypeOption>,
    /// <p>The name for the Resolver rule, which you specified when you created the Resolver rule.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>An array that contains the IP addresses and ports that an outbound endpoint forwards DNS queries to. Typically,
    /// these are the IP addresses of DNS resolvers on your network. Specify IPv4 addresses. IPv6 is not supported.</p>
    pub target_ips: std::option::Option<std::vec::Vec<crate::model::TargetAddress>>,
    /// <p>The ID of the endpoint that the rule is associated with.</p>
    pub resolver_endpoint_id: std::option::Option<std::string::String>,
    /// <p>When a rule is shared with another Amazon Web Services account, the account ID of the account that the rule is shared with.</p>
    pub owner_id: std::option::Option<std::string::String>,
    /// <p>Whether the rule is shared and, if so, whether the current account is sharing the rule with
    /// another account, or another account is sharing the rule with the current account.</p>
    pub share_status: std::option::Option<crate::model::ShareStatus>,
    /// <p>The date and time that the Resolver rule was created, in Unix time format and Coordinated Universal Time (UTC).</p>
    pub creation_time: std::option::Option<std::string::String>,
    /// <p>The date and time that the Resolver rule was last updated, in Unix time format and Coordinated Universal Time (UTC).</p>
    pub modification_time: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResolverRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResolverRule");
        formatter.field("id", &self.id);
        formatter.field("creator_request_id", &self.creator_request_id);
        formatter.field("arn", &self.arn);
        formatter.field("domain_name", &self.domain_name);
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.field("rule_type", &self.rule_type);
        formatter.field("name", &self.name);
        formatter.field("target_ips", &self.target_ips);
        formatter.field("resolver_endpoint_id", &self.resolver_endpoint_id);
        formatter.field("owner_id", &self.owner_id);
        formatter.field("share_status", &self.share_status);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("modification_time", &self.modification_time);
        formatter.finish()
    }
}
/// See [`ResolverRule`](crate::model::ResolverRule)
pub mod resolver_rule {
    /// A builder for [`ResolverRule`](crate::model::ResolverRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) creator_request_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ResolverRuleStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) rule_type: std::option::Option<crate::model::RuleTypeOption>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) target_ips: std::option::Option<std::vec::Vec<crate::model::TargetAddress>>,
        pub(crate) resolver_endpoint_id: std::option::Option<std::string::String>,
        pub(crate) owner_id: std::option::Option<std::string::String>,
        pub(crate) share_status: std::option::Option<crate::model::ShareStatus>,
        pub(crate) creation_time: std::option::Option<std::string::String>,
        pub(crate) modification_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID that Resolver assigned to the Resolver rule when you created it.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID that Resolver assigned to the Resolver rule when you created it.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>A unique string that you specified when you created the Resolver rule.
        /// <code>CreatorRequestId</code> identifies the request and allows failed requests to
        /// be retried without the risk of running the operation twice. </p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.creator_request_id = Some(input.into());
            self
        }
        /// <p>A unique string that you specified when you created the Resolver rule.
        /// <code>CreatorRequestId</code> identifies the request and allows failed requests to
        /// be retried without the risk of running the operation twice. </p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creator_request_id = input;
            self
        }
        /// <p>The ARN (Amazon Resource Name) for the Resolver rule specified by <code>Id</code>.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN (Amazon Resource Name) for the Resolver rule specified by <code>Id</code>.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>DNS queries for this domain name are forwarded to the IP addresses that are specified in <code>TargetIps</code>. If a query matches
        /// multiple Resolver rules (example.com and www.example.com), the query is routed using the Resolver rule that contains the most specific domain name
        /// (www.example.com).</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>DNS queries for this domain name are forwarded to the IP addresses that are specified in <code>TargetIps</code>. If a query matches
        /// multiple Resolver rules (example.com and www.example.com), the query is routed using the Resolver rule that contains the most specific domain name
        /// (www.example.com).</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>A code that specifies the current status of the Resolver rule.</p>
        pub fn status(mut self, input: crate::model::ResolverRuleStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>A code that specifies the current status of the Resolver rule.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ResolverRuleStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A detailed description of the status of a Resolver rule.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>A detailed description of the status of a Resolver rule.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>When you want to forward DNS queries for specified domain name to resolvers on your network, specify <code>FORWARD</code>.</p>
        /// <p>When you have a forwarding rule to forward DNS queries for a domain to your network and you want Resolver to process queries for
        /// a subdomain of that domain, specify <code>SYSTEM</code>.</p>
        /// <p>For example, to forward DNS queries for example.com to resolvers on your network, you create a rule and specify <code>FORWARD</code>
        /// for <code>RuleType</code>. To then have Resolver process queries for apex.example.com, you create a rule and specify
        /// <code>SYSTEM</code> for <code>RuleType</code>.</p>
        /// <p>Currently, only Resolver can create rules that have a value of <code>RECURSIVE</code> for <code>RuleType</code>.</p>
        pub fn rule_type(mut self, input: crate::model::RuleTypeOption) -> Self {
            self.rule_type = Some(input);
            self
        }
        /// <p>When you want to forward DNS queries for specified domain name to resolvers on your network, specify <code>FORWARD</code>.</p>
        /// <p>When you have a forwarding rule to forward DNS queries for a domain to your network and you want Resolver to process queries for
        /// a subdomain of that domain, specify <code>SYSTEM</code>.</p>
        /// <p>For example, to forward DNS queries for example.com to resolvers on your network, you create a rule and specify <code>FORWARD</code>
        /// for <code>RuleType</code>. To then have Resolver process queries for apex.example.com, you create a rule and specify
        /// <code>SYSTEM</code> for <code>RuleType</code>.</p>
        /// <p>Currently, only Resolver can create rules that have a value of <code>RECURSIVE</code> for <code>RuleType</code>.</p>
        pub fn set_rule_type(
            mut self,
            input: std::option::Option<crate::model::RuleTypeOption>,
        ) -> Self {
            self.rule_type = input;
            self
        }
        /// <p>The name for the Resolver rule, which you specified when you created the Resolver rule.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for the Resolver rule, which you specified when you created the Resolver rule.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `target_ips`.
        ///
        /// To override the contents of this collection use [`set_target_ips`](Self::set_target_ips).
        ///
        /// <p>An array that contains the IP addresses and ports that an outbound endpoint forwards DNS queries to. Typically,
        /// these are the IP addresses of DNS resolvers on your network. Specify IPv4 addresses. IPv6 is not supported.</p>
        pub fn target_ips(mut self, input: impl Into<crate::model::TargetAddress>) -> Self {
            let mut v = self.target_ips.unwrap_or_default();
            v.push(input.into());
            self.target_ips = Some(v);
            self
        }
        /// <p>An array that contains the IP addresses and ports that an outbound endpoint forwards DNS queries to. Typically,
        /// these are the IP addresses of DNS resolvers on your network. Specify IPv4 addresses. IPv6 is not supported.</p>
        pub fn set_target_ips(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetAddress>>,
        ) -> Self {
            self.target_ips = input;
            self
        }
        /// <p>The ID of the endpoint that the rule is associated with.</p>
        pub fn resolver_endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resolver_endpoint_id = Some(input.into());
            self
        }
        /// <p>The ID of the endpoint that the rule is associated with.</p>
        pub fn set_resolver_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resolver_endpoint_id = input;
            self
        }
        /// <p>When a rule is shared with another Amazon Web Services account, the account ID of the account that the rule is shared with.</p>
        pub fn owner_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_id = Some(input.into());
            self
        }
        /// <p>When a rule is shared with another Amazon Web Services account, the account ID of the account that the rule is shared with.</p>
        pub fn set_owner_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner_id = input;
            self
        }
        /// <p>Whether the rule is shared and, if so, whether the current account is sharing the rule with
        /// another account, or another account is sharing the rule with the current account.</p>
        pub fn share_status(mut self, input: crate::model::ShareStatus) -> Self {
            self.share_status = Some(input);
            self
        }
        /// <p>Whether the rule is shared and, if so, whether the current account is sharing the rule with
        /// another account, or another account is sharing the rule with the current account.</p>
        pub fn set_share_status(
            mut self,
            input: std::option::Option<crate::model::ShareStatus>,
        ) -> Self {
            self.share_status = input;
            self
        }
        /// <p>The date and time that the Resolver rule was created, in Unix time format and Coordinated Universal Time (UTC).</p>
        pub fn creation_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_time = Some(input.into());
            self
        }
        /// <p>The date and time that the Resolver rule was created, in Unix time format and Coordinated Universal Time (UTC).</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The date and time that the Resolver rule was last updated, in Unix time format and Coordinated Universal Time (UTC).</p>
        pub fn modification_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.modification_time = Some(input.into());
            self
        }
        /// <p>The date and time that the Resolver rule was last updated, in Unix time format and Coordinated Universal Time (UTC).</p>
        pub fn set_modification_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.modification_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ResolverRule`](crate::model::ResolverRule)
        pub fn build(self) -> crate::model::ResolverRule {
            crate::model::ResolverRule {
                id: self.id,
                creator_request_id: self.creator_request_id,
                arn: self.arn,
                domain_name: self.domain_name,
                status: self.status,
                status_message: self.status_message,
                rule_type: self.rule_type,
                name: self.name,
                target_ips: self.target_ips,
                resolver_endpoint_id: self.resolver_endpoint_id,
                owner_id: self.owner_id,
                share_status: self.share_status,
                creation_time: self.creation_time,
                modification_time: self.modification_time,
            }
        }
    }
}
impl ResolverRule {
    /// Creates a new builder-style object to manufacture [`ResolverRule`](crate::model::ResolverRule)
    pub fn builder() -> crate::model::resolver_rule::Builder {
        crate::model::resolver_rule::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ShareStatus {
    #[allow(missing_docs)] // documentation missing in model
    NotShared,
    #[allow(missing_docs)] // documentation missing in model
    SharedByMe,
    #[allow(missing_docs)] // documentation missing in model
    SharedWithMe,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ShareStatus {
    fn from(s: &str) -> Self {
        match s {
            "NOT_SHARED" => ShareStatus::NotShared,
            "SHARED_BY_ME" => ShareStatus::SharedByMe,
            "SHARED_WITH_ME" => ShareStatus::SharedWithMe,
            other => ShareStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ShareStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ShareStatus::from(s))
    }
}
impl ShareStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ShareStatus::NotShared => "NOT_SHARED",
            ShareStatus::SharedByMe => "SHARED_BY_ME",
            ShareStatus::SharedWithMe => "SHARED_WITH_ME",
            ShareStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NOT_SHARED", "SHARED_BY_ME", "SHARED_WITH_ME"]
    }
}
impl AsRef<str> for ShareStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>In a
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverRule.html">CreateResolverRule</a>
/// request, an array of the IPs that you want to forward DNS queries to.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TargetAddress {
    /// <p>One IP address that you want to forward DNS queries to. You can specify only IPv4 addresses.</p>
    pub ip: std::option::Option<std::string::String>,
    /// <p>The port at <code>Ip</code> that you want to forward DNS queries to.</p>
    pub port: std::option::Option<i32>,
}
impl std::fmt::Debug for TargetAddress {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TargetAddress");
        formatter.field("ip", &self.ip);
        formatter.field("port", &self.port);
        formatter.finish()
    }
}
/// See [`TargetAddress`](crate::model::TargetAddress)
pub mod target_address {
    /// A builder for [`TargetAddress`](crate::model::TargetAddress)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ip: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>One IP address that you want to forward DNS queries to. You can specify only IPv4 addresses.</p>
        pub fn ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip = Some(input.into());
            self
        }
        /// <p>One IP address that you want to forward DNS queries to. You can specify only IPv4 addresses.</p>
        pub fn set_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip = input;
            self
        }
        /// <p>The port at <code>Ip</code> that you want to forward DNS queries to.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port at <code>Ip</code> that you want to forward DNS queries to.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// Consumes the builder and constructs a [`TargetAddress`](crate::model::TargetAddress)
        pub fn build(self) -> crate::model::TargetAddress {
            crate::model::TargetAddress {
                ip: self.ip,
                port: self.port,
            }
        }
    }
}
impl TargetAddress {
    /// Creates a new builder-style object to manufacture [`TargetAddress`](crate::model::TargetAddress)
    pub fn builder() -> crate::model::target_address::Builder {
        crate::model::target_address::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RuleTypeOption {
    #[allow(missing_docs)] // documentation missing in model
    Forward,
    #[allow(missing_docs)] // documentation missing in model
    Recursive,
    #[allow(missing_docs)] // documentation missing in model
    System,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RuleTypeOption {
    fn from(s: &str) -> Self {
        match s {
            "FORWARD" => RuleTypeOption::Forward,
            "RECURSIVE" => RuleTypeOption::Recursive,
            "SYSTEM" => RuleTypeOption::System,
            other => RuleTypeOption::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RuleTypeOption {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RuleTypeOption::from(s))
    }
}
impl RuleTypeOption {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RuleTypeOption::Forward => "FORWARD",
            RuleTypeOption::Recursive => "RECURSIVE",
            RuleTypeOption::System => "SYSTEM",
            RuleTypeOption::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FORWARD", "RECURSIVE", "SYSTEM"]
    }
}
impl AsRef<str> for RuleTypeOption {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResolverRuleStatus {
    #[allow(missing_docs)] // documentation missing in model
    Complete,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResolverRuleStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETE" => ResolverRuleStatus::Complete,
            "DELETING" => ResolverRuleStatus::Deleting,
            "FAILED" => ResolverRuleStatus::Failed,
            "UPDATING" => ResolverRuleStatus::Updating,
            other => ResolverRuleStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResolverRuleStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResolverRuleStatus::from(s))
    }
}
impl ResolverRuleStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResolverRuleStatus::Complete => "COMPLETE",
            ResolverRuleStatus::Deleting => "DELETING",
            ResolverRuleStatus::Failed => "FAILED",
            ResolverRuleStatus::Updating => "UPDATING",
            ResolverRuleStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLETE", "DELETING", "FAILED", "UPDATING"]
    }
}
impl AsRef<str> for ResolverRuleStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>In an
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_UpdateResolverRule.html">UpdateResolverRule</a>
/// request, information about the changes that you want to make.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResolverRuleConfig {
    /// <p>The new name for the Resolver rule. The name that you specify appears in the Resolver dashboard in the Route 53 console. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>For DNS queries that originate in your VPC, the new IP addresses that you want to route outbound DNS queries to.</p>
    pub target_ips: std::option::Option<std::vec::Vec<crate::model::TargetAddress>>,
    /// <p>The ID of the new outbound Resolver endpoint that you want to use to route DNS queries to the IP addresses that you specify in
    /// <code>TargetIps</code>.</p>
    pub resolver_endpoint_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResolverRuleConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResolverRuleConfig");
        formatter.field("name", &self.name);
        formatter.field("target_ips", &self.target_ips);
        formatter.field("resolver_endpoint_id", &self.resolver_endpoint_id);
        formatter.finish()
    }
}
/// See [`ResolverRuleConfig`](crate::model::ResolverRuleConfig)
pub mod resolver_rule_config {
    /// A builder for [`ResolverRuleConfig`](crate::model::ResolverRuleConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) target_ips: std::option::Option<std::vec::Vec<crate::model::TargetAddress>>,
        pub(crate) resolver_endpoint_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The new name for the Resolver rule. The name that you specify appears in the Resolver dashboard in the Route 53 console. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The new name for the Resolver rule. The name that you specify appears in the Resolver dashboard in the Route 53 console. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `target_ips`.
        ///
        /// To override the contents of this collection use [`set_target_ips`](Self::set_target_ips).
        ///
        /// <p>For DNS queries that originate in your VPC, the new IP addresses that you want to route outbound DNS queries to.</p>
        pub fn target_ips(mut self, input: impl Into<crate::model::TargetAddress>) -> Self {
            let mut v = self.target_ips.unwrap_or_default();
            v.push(input.into());
            self.target_ips = Some(v);
            self
        }
        /// <p>For DNS queries that originate in your VPC, the new IP addresses that you want to route outbound DNS queries to.</p>
        pub fn set_target_ips(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetAddress>>,
        ) -> Self {
            self.target_ips = input;
            self
        }
        /// <p>The ID of the new outbound Resolver endpoint that you want to use to route DNS queries to the IP addresses that you specify in
        /// <code>TargetIps</code>.</p>
        pub fn resolver_endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resolver_endpoint_id = Some(input.into());
            self
        }
        /// <p>The ID of the new outbound Resolver endpoint that you want to use to route DNS queries to the IP addresses that you specify in
        /// <code>TargetIps</code>.</p>
        pub fn set_resolver_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resolver_endpoint_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ResolverRuleConfig`](crate::model::ResolverRuleConfig)
        pub fn build(self) -> crate::model::ResolverRuleConfig {
            crate::model::ResolverRuleConfig {
                name: self.name,
                target_ips: self.target_ips,
                resolver_endpoint_id: self.resolver_endpoint_id,
            }
        }
    }
}
impl ResolverRuleConfig {
    /// Creates a new builder-style object to manufacture [`ResolverRuleConfig`](crate::model::ResolverRuleConfig)
    pub fn builder() -> crate::model::resolver_rule_config::Builder {
        crate::model::resolver_rule_config::Builder::default()
    }
}

/// <p>In the response to a
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverEndpoint.html">CreateResolverEndpoint</a>,
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DeleteResolverEndpoint.html">DeleteResolverEndpoint</a>,
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html">GetResolverEndpoint</a>,
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html">ListResolverEndpoints</a>,
/// or
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_UpdateResolverEndpoint.html">UpdateResolverEndpoint</a>
/// request, a complex type that contains settings for an existing inbound or outbound Resolver endpoint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResolverEndpoint {
    /// <p>The ID of the Resolver endpoint.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>A unique string that identifies the request that created the Resolver endpoint. The
    /// <code>CreatorRequestId</code> allows failed requests to be retried without the risk
    /// of running the operation twice.</p>
    pub creator_request_id: std::option::Option<std::string::String>,
    /// <p>The ARN (Amazon Resource Name) for the Resolver endpoint.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name that you assigned to the Resolver endpoint when you submitted a
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverEndpoint.html">CreateResolverEndpoint</a>
    /// request.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ID of one or more security groups that control access to this VPC. The security group must include one or more inbound rules
    /// (for inbound endpoints) or outbound rules (for outbound endpoints). Inbound and outbound rules must allow TCP and UDP access.
    /// For inbound access, open port 53. For outbound access, open the port that you're using for DNS queries on your network.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Indicates whether the Resolver endpoint allows inbound or outbound DNS queries:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>INBOUND</code>: allows DNS queries to your VPC from your network</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>OUTBOUND</code>: allows DNS queries from your VPC to your network</p>
    /// </li>
    /// </ul>
    pub direction: std::option::Option<crate::model::ResolverEndpointDirection>,
    /// <p>The number of IP addresses that the Resolver endpoint can use for DNS queries.</p>
    pub ip_address_count: std::option::Option<i32>,
    /// <p>The ID of the VPC that you want to create the Resolver endpoint in.</p>
    pub host_vpc_id: std::option::Option<std::string::String>,
    /// <p>A code that specifies the current status of the Resolver endpoint. Valid values include the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATING</code>: Resolver is creating and configuring one or more Amazon VPC network interfaces
    /// for this endpoint.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>OPERATIONAL</code>: The Amazon VPC network interfaces for this endpoint are correctly configured and
    /// able to pass inbound or outbound DNS queries between your network and Resolver.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATING</code>: Resolver is associating or disassociating one or more network interfaces
    /// with this endpoint.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AUTO_RECOVERING</code>: Resolver is trying to recover one or more of the network interfaces
    /// that are associated with this endpoint. During the recovery process, the endpoint functions with limited capacity because of the
    /// limit on the number of DNS queries per IP address (per network interface). For the current limit, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html#limits-api-entities-resolver">Limits on Route 53 Resolver</a>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ACTION_NEEDED</code>: This endpoint is unhealthy, and Resolver can't automatically recover it.
    /// To resolve the problem, we recommend that you check each IP address that you associated with the endpoint. For each IP address
    /// that isn't available, add another IP address and then delete the IP address that isn't available. (An endpoint must always include
    /// at least two IP addresses.) A status of <code>ACTION_NEEDED</code> can have a variety of causes. Here are two common causes:</p>
    /// <ul>
    /// <li>
    /// <p>One or more of the network interfaces that are associated with the endpoint were deleted using Amazon VPC.</p>
    /// </li>
    /// <li>
    /// <p>The network interface couldn't be created for some reason that's outside the control of Resolver.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETING</code>: Resolver is deleting this endpoint and the associated network interfaces.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::ResolverEndpointStatus>,
    /// <p>A detailed description of the status of the Resolver endpoint.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>The date and time that the endpoint was created, in Unix time format and Coordinated Universal Time (UTC).</p>
    pub creation_time: std::option::Option<std::string::String>,
    /// <p>The date and time that the endpoint was last modified, in Unix time format and Coordinated Universal Time (UTC).</p>
    pub modification_time: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResolverEndpoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResolverEndpoint");
        formatter.field("id", &self.id);
        formatter.field("creator_request_id", &self.creator_request_id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.field("direction", &self.direction);
        formatter.field("ip_address_count", &self.ip_address_count);
        formatter.field("host_vpc_id", &self.host_vpc_id);
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("modification_time", &self.modification_time);
        formatter.finish()
    }
}
/// See [`ResolverEndpoint`](crate::model::ResolverEndpoint)
pub mod resolver_endpoint {
    /// A builder for [`ResolverEndpoint`](crate::model::ResolverEndpoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) creator_request_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) direction: std::option::Option<crate::model::ResolverEndpointDirection>,
        pub(crate) ip_address_count: std::option::Option<i32>,
        pub(crate) host_vpc_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ResolverEndpointStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<std::string::String>,
        pub(crate) modification_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Resolver endpoint.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the Resolver endpoint.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>A unique string that identifies the request that created the Resolver endpoint. The
        /// <code>CreatorRequestId</code> allows failed requests to be retried without the risk
        /// of running the operation twice.</p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.creator_request_id = Some(input.into());
            self
        }
        /// <p>A unique string that identifies the request that created the Resolver endpoint. The
        /// <code>CreatorRequestId</code> allows failed requests to be retried without the risk
        /// of running the operation twice.</p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creator_request_id = input;
            self
        }
        /// <p>The ARN (Amazon Resource Name) for the Resolver endpoint.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN (Amazon Resource Name) for the Resolver endpoint.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name that you assigned to the Resolver endpoint when you submitted a
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverEndpoint.html">CreateResolverEndpoint</a>
        /// request.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name that you assigned to the Resolver endpoint when you submitted a
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverEndpoint.html">CreateResolverEndpoint</a>
        /// request.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>The ID of one or more security groups that control access to this VPC. The security group must include one or more inbound rules
        /// (for inbound endpoints) or outbound rules (for outbound endpoints). Inbound and outbound rules must allow TCP and UDP access.
        /// For inbound access, open port 53. For outbound access, open the port that you're using for DNS queries on your network.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>The ID of one or more security groups that control access to this VPC. The security group must include one or more inbound rules
        /// (for inbound endpoints) or outbound rules (for outbound endpoints). Inbound and outbound rules must allow TCP and UDP access.
        /// For inbound access, open port 53. For outbound access, open the port that you're using for DNS queries on your network.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// <p>Indicates whether the Resolver endpoint allows inbound or outbound DNS queries:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INBOUND</code>: allows DNS queries to your VPC from your network</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OUTBOUND</code>: allows DNS queries from your VPC to your network</p>
        /// </li>
        /// </ul>
        pub fn direction(mut self, input: crate::model::ResolverEndpointDirection) -> Self {
            self.direction = Some(input);
            self
        }
        /// <p>Indicates whether the Resolver endpoint allows inbound or outbound DNS queries:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INBOUND</code>: allows DNS queries to your VPC from your network</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OUTBOUND</code>: allows DNS queries from your VPC to your network</p>
        /// </li>
        /// </ul>
        pub fn set_direction(
            mut self,
            input: std::option::Option<crate::model::ResolverEndpointDirection>,
        ) -> Self {
            self.direction = input;
            self
        }
        /// <p>The number of IP addresses that the Resolver endpoint can use for DNS queries.</p>
        pub fn ip_address_count(mut self, input: i32) -> Self {
            self.ip_address_count = Some(input);
            self
        }
        /// <p>The number of IP addresses that the Resolver endpoint can use for DNS queries.</p>
        pub fn set_ip_address_count(mut self, input: std::option::Option<i32>) -> Self {
            self.ip_address_count = input;
            self
        }
        /// <p>The ID of the VPC that you want to create the Resolver endpoint in.</p>
        pub fn host_vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.host_vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC that you want to create the Resolver endpoint in.</p>
        pub fn set_host_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.host_vpc_id = input;
            self
        }
        /// <p>A code that specifies the current status of the Resolver endpoint. Valid values include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATING</code>: Resolver is creating and configuring one or more Amazon VPC network interfaces
        /// for this endpoint.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OPERATIONAL</code>: The Amazon VPC network interfaces for this endpoint are correctly configured and
        /// able to pass inbound or outbound DNS queries between your network and Resolver.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATING</code>: Resolver is associating or disassociating one or more network interfaces
        /// with this endpoint.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AUTO_RECOVERING</code>: Resolver is trying to recover one or more of the network interfaces
        /// that are associated with this endpoint. During the recovery process, the endpoint functions with limited capacity because of the
        /// limit on the number of DNS queries per IP address (per network interface). For the current limit, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html#limits-api-entities-resolver">Limits on Route 53 Resolver</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACTION_NEEDED</code>: This endpoint is unhealthy, and Resolver can't automatically recover it.
        /// To resolve the problem, we recommend that you check each IP address that you associated with the endpoint. For each IP address
        /// that isn't available, add another IP address and then delete the IP address that isn't available. (An endpoint must always include
        /// at least two IP addresses.) A status of <code>ACTION_NEEDED</code> can have a variety of causes. Here are two common causes:</p>
        /// <ul>
        /// <li>
        /// <p>One or more of the network interfaces that are associated with the endpoint were deleted using Amazon VPC.</p>
        /// </li>
        /// <li>
        /// <p>The network interface couldn't be created for some reason that's outside the control of Resolver.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETING</code>: Resolver is deleting this endpoint and the associated network interfaces.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::ResolverEndpointStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>A code that specifies the current status of the Resolver endpoint. Valid values include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATING</code>: Resolver is creating and configuring one or more Amazon VPC network interfaces
        /// for this endpoint.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OPERATIONAL</code>: The Amazon VPC network interfaces for this endpoint are correctly configured and
        /// able to pass inbound or outbound DNS queries between your network and Resolver.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATING</code>: Resolver is associating or disassociating one or more network interfaces
        /// with this endpoint.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AUTO_RECOVERING</code>: Resolver is trying to recover one or more of the network interfaces
        /// that are associated with this endpoint. During the recovery process, the endpoint functions with limited capacity because of the
        /// limit on the number of DNS queries per IP address (per network interface). For the current limit, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html#limits-api-entities-resolver">Limits on Route 53 Resolver</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACTION_NEEDED</code>: This endpoint is unhealthy, and Resolver can't automatically recover it.
        /// To resolve the problem, we recommend that you check each IP address that you associated with the endpoint. For each IP address
        /// that isn't available, add another IP address and then delete the IP address that isn't available. (An endpoint must always include
        /// at least two IP addresses.) A status of <code>ACTION_NEEDED</code> can have a variety of causes. Here are two common causes:</p>
        /// <ul>
        /// <li>
        /// <p>One or more of the network interfaces that are associated with the endpoint were deleted using Amazon VPC.</p>
        /// </li>
        /// <li>
        /// <p>The network interface couldn't be created for some reason that's outside the control of Resolver.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETING</code>: Resolver is deleting this endpoint and the associated network interfaces.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ResolverEndpointStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A detailed description of the status of the Resolver endpoint.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>A detailed description of the status of the Resolver endpoint.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>The date and time that the endpoint was created, in Unix time format and Coordinated Universal Time (UTC).</p>
        pub fn creation_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_time = Some(input.into());
            self
        }
        /// <p>The date and time that the endpoint was created, in Unix time format and Coordinated Universal Time (UTC).</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The date and time that the endpoint was last modified, in Unix time format and Coordinated Universal Time (UTC).</p>
        pub fn modification_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.modification_time = Some(input.into());
            self
        }
        /// <p>The date and time that the endpoint was last modified, in Unix time format and Coordinated Universal Time (UTC).</p>
        pub fn set_modification_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.modification_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ResolverEndpoint`](crate::model::ResolverEndpoint)
        pub fn build(self) -> crate::model::ResolverEndpoint {
            crate::model::ResolverEndpoint {
                id: self.id,
                creator_request_id: self.creator_request_id,
                arn: self.arn,
                name: self.name,
                security_group_ids: self.security_group_ids,
                direction: self.direction,
                ip_address_count: self.ip_address_count,
                host_vpc_id: self.host_vpc_id,
                status: self.status,
                status_message: self.status_message,
                creation_time: self.creation_time,
                modification_time: self.modification_time,
            }
        }
    }
}
impl ResolverEndpoint {
    /// Creates a new builder-style object to manufacture [`ResolverEndpoint`](crate::model::ResolverEndpoint)
    pub fn builder() -> crate::model::resolver_endpoint::Builder {
        crate::model::resolver_endpoint::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResolverEndpointStatus {
    #[allow(missing_docs)] // documentation missing in model
    ActionNeeded,
    #[allow(missing_docs)] // documentation missing in model
    AutoRecovering,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Operational,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResolverEndpointStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTION_NEEDED" => ResolverEndpointStatus::ActionNeeded,
            "AUTO_RECOVERING" => ResolverEndpointStatus::AutoRecovering,
            "CREATING" => ResolverEndpointStatus::Creating,
            "DELETING" => ResolverEndpointStatus::Deleting,
            "OPERATIONAL" => ResolverEndpointStatus::Operational,
            "UPDATING" => ResolverEndpointStatus::Updating,
            other => ResolverEndpointStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResolverEndpointStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResolverEndpointStatus::from(s))
    }
}
impl ResolverEndpointStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResolverEndpointStatus::ActionNeeded => "ACTION_NEEDED",
            ResolverEndpointStatus::AutoRecovering => "AUTO_RECOVERING",
            ResolverEndpointStatus::Creating => "CREATING",
            ResolverEndpointStatus::Deleting => "DELETING",
            ResolverEndpointStatus::Operational => "OPERATIONAL",
            ResolverEndpointStatus::Updating => "UPDATING",
            ResolverEndpointStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTION_NEEDED",
            "AUTO_RECOVERING",
            "CREATING",
            "DELETING",
            "OPERATIONAL",
            "UPDATING",
        ]
    }
}
impl AsRef<str> for ResolverEndpointStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResolverEndpointDirection {
    #[allow(missing_docs)] // documentation missing in model
    Inbound,
    #[allow(missing_docs)] // documentation missing in model
    Outbound,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResolverEndpointDirection {
    fn from(s: &str) -> Self {
        match s {
            "INBOUND" => ResolverEndpointDirection::Inbound,
            "OUTBOUND" => ResolverEndpointDirection::Outbound,
            other => ResolverEndpointDirection::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResolverEndpointDirection {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResolverEndpointDirection::from(s))
    }
}
impl ResolverEndpointDirection {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResolverEndpointDirection::Inbound => "INBOUND",
            ResolverEndpointDirection::Outbound => "OUTBOUND",
            ResolverEndpointDirection::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INBOUND", "OUTBOUND"]
    }
}
impl AsRef<str> for ResolverEndpointDirection {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A complex type that contains information about a configuration for DNSSEC validation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResolverDnssecConfig {
    /// <p>The ID for a configuration for DNSSEC validation.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The owner account ID of the virtual private cloud (VPC) for a configuration for DNSSEC validation.</p>
    pub owner_id: std::option::Option<std::string::String>,
    /// <p>The ID of the virtual private cloud (VPC) that you're configuring the DNSSEC validation status for.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The validation status for a DNSSEC configuration. The status can be one of the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>ENABLING:</b> DNSSEC validation is being enabled but is not complete.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>ENABLED:</b> DNSSEC validation is enabled.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>DISABLING:</b> DNSSEC validation is being disabled but is not complete.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>DISABLED</b> DNSSEC validation is disabled.</p>
    /// </li>
    /// </ul>
    pub validation_status: std::option::Option<crate::model::ResolverDnssecValidationStatus>,
}
impl std::fmt::Debug for ResolverDnssecConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResolverDnssecConfig");
        formatter.field("id", &self.id);
        formatter.field("owner_id", &self.owner_id);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("validation_status", &self.validation_status);
        formatter.finish()
    }
}
/// See [`ResolverDnssecConfig`](crate::model::ResolverDnssecConfig)
pub mod resolver_dnssec_config {
    /// A builder for [`ResolverDnssecConfig`](crate::model::ResolverDnssecConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) owner_id: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) validation_status:
            std::option::Option<crate::model::ResolverDnssecValidationStatus>,
    }
    impl Builder {
        /// <p>The ID for a configuration for DNSSEC validation.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID for a configuration for DNSSEC validation.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The owner account ID of the virtual private cloud (VPC) for a configuration for DNSSEC validation.</p>
        pub fn owner_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_id = Some(input.into());
            self
        }
        /// <p>The owner account ID of the virtual private cloud (VPC) for a configuration for DNSSEC validation.</p>
        pub fn set_owner_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner_id = input;
            self
        }
        /// <p>The ID of the virtual private cloud (VPC) that you're configuring the DNSSEC validation status for.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the virtual private cloud (VPC) that you're configuring the DNSSEC validation status for.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The validation status for a DNSSEC configuration. The status can be one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>ENABLING:</b> DNSSEC validation is being enabled but is not complete.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>ENABLED:</b> DNSSEC validation is enabled.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>DISABLING:</b> DNSSEC validation is being disabled but is not complete.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>DISABLED</b> DNSSEC validation is disabled.</p>
        /// </li>
        /// </ul>
        pub fn validation_status(
            mut self,
            input: crate::model::ResolverDnssecValidationStatus,
        ) -> Self {
            self.validation_status = Some(input);
            self
        }
        /// <p>The validation status for a DNSSEC configuration. The status can be one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>ENABLING:</b> DNSSEC validation is being enabled but is not complete.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>ENABLED:</b> DNSSEC validation is enabled.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>DISABLING:</b> DNSSEC validation is being disabled but is not complete.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>DISABLED</b> DNSSEC validation is disabled.</p>
        /// </li>
        /// </ul>
        pub fn set_validation_status(
            mut self,
            input: std::option::Option<crate::model::ResolverDnssecValidationStatus>,
        ) -> Self {
            self.validation_status = input;
            self
        }
        /// Consumes the builder and constructs a [`ResolverDnssecConfig`](crate::model::ResolverDnssecConfig)
        pub fn build(self) -> crate::model::ResolverDnssecConfig {
            crate::model::ResolverDnssecConfig {
                id: self.id,
                owner_id: self.owner_id,
                resource_id: self.resource_id,
                validation_status: self.validation_status,
            }
        }
    }
}
impl ResolverDnssecConfig {
    /// Creates a new builder-style object to manufacture [`ResolverDnssecConfig`](crate::model::ResolverDnssecConfig)
    pub fn builder() -> crate::model::resolver_dnssec_config::Builder {
        crate::model::resolver_dnssec_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResolverDnssecValidationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Disabling,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabling,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResolverDnssecValidationStatus {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => ResolverDnssecValidationStatus::Disabled,
            "DISABLING" => ResolverDnssecValidationStatus::Disabling,
            "ENABLED" => ResolverDnssecValidationStatus::Enabled,
            "ENABLING" => ResolverDnssecValidationStatus::Enabling,
            other => ResolverDnssecValidationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResolverDnssecValidationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResolverDnssecValidationStatus::from(s))
    }
}
impl ResolverDnssecValidationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResolverDnssecValidationStatus::Disabled => "DISABLED",
            ResolverDnssecValidationStatus::Disabling => "DISABLING",
            ResolverDnssecValidationStatus::Enabled => "ENABLED",
            ResolverDnssecValidationStatus::Enabling => "ENABLING",
            ResolverDnssecValidationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "DISABLING", "ENABLED", "ENABLING"]
    }
}
impl AsRef<str> for ResolverDnssecValidationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Validation {
    #[allow(missing_docs)] // documentation missing in model
    Disable,
    #[allow(missing_docs)] // documentation missing in model
    Enable,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Validation {
    fn from(s: &str) -> Self {
        match s {
            "DISABLE" => Validation::Disable,
            "ENABLE" => Validation::Enable,
            other => Validation::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Validation {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Validation::from(s))
    }
}
impl Validation {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Validation::Disable => "DISABLE",
            Validation::Enable => "ENABLE",
            Validation::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLE", "ENABLE"]
    }
}
impl AsRef<str> for Validation {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An association between a firewall rule group and a VPC, which enables DNS filtering for
/// the VPC. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FirewallRuleGroupAssociation {
    /// <p>The identifier for the association.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the firewall rule group association.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the firewall rule group. </p>
    pub firewall_rule_group_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the VPC that is associated with the rule group. </p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>The name of the association.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The setting that determines the processing order of the rule group among the rule groups that are associated with a single VPC. DNS Firewall
    /// filters VPC traffic starting from rule group with the lowest numeric priority setting. </p>
    pub priority: std::option::Option<i32>,
    /// <p>If enabled, this setting disallows modification or removal of the association, to help prevent against accidentally altering DNS firewall protections. </p>
    pub mutation_protection: std::option::Option<crate::model::MutationProtectionStatus>,
    /// <p>The owner of the association, used only for associations that are not managed by you. If you use Firewall Manager to
    /// manage your DNS Firewalls, then this reports Firewall Manager as the managed owner.</p>
    pub managed_owner_name: std::option::Option<std::string::String>,
    /// <p>The current status of the association.</p>
    pub status: std::option::Option<crate::model::FirewallRuleGroupAssociationStatus>,
    /// <p>Additional information about the status of the response, if available.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>A unique string defined by you to identify the request. This allows you to retry failed
    /// requests without the risk of running the operation twice. This can be any unique string,
    /// for example, a timestamp. </p>
    pub creator_request_id: std::option::Option<std::string::String>,
    /// <p>The date and time that the association was created, in Unix time format and Coordinated Universal Time (UTC). </p>
    pub creation_time: std::option::Option<std::string::String>,
    /// <p>The date and time that the association was last modified, in Unix time format and Coordinated Universal Time (UTC).</p>
    pub modification_time: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for FirewallRuleGroupAssociation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FirewallRuleGroupAssociation");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("firewall_rule_group_id", &self.firewall_rule_group_id);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("name", &self.name);
        formatter.field("priority", &self.priority);
        formatter.field("mutation_protection", &self.mutation_protection);
        formatter.field("managed_owner_name", &self.managed_owner_name);
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.field("creator_request_id", &self.creator_request_id);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("modification_time", &self.modification_time);
        formatter.finish()
    }
}
/// See [`FirewallRuleGroupAssociation`](crate::model::FirewallRuleGroupAssociation)
pub mod firewall_rule_group_association {
    /// A builder for [`FirewallRuleGroupAssociation`](crate::model::FirewallRuleGroupAssociation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) firewall_rule_group_id: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) priority: std::option::Option<i32>,
        pub(crate) mutation_protection: std::option::Option<crate::model::MutationProtectionStatus>,
        pub(crate) managed_owner_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::FirewallRuleGroupAssociationStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) creator_request_id: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<std::string::String>,
        pub(crate) modification_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier for the association.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier for the association.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall rule group association.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall rule group association.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The unique identifier of the firewall rule group. </p>
        pub fn firewall_rule_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_rule_group_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the firewall rule group. </p>
        pub fn set_firewall_rule_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firewall_rule_group_id = input;
            self
        }
        /// <p>The unique identifier of the VPC that is associated with the rule group. </p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the VPC that is associated with the rule group. </p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>The name of the association.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the association.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The setting that determines the processing order of the rule group among the rule groups that are associated with a single VPC. DNS Firewall
        /// filters VPC traffic starting from rule group with the lowest numeric priority setting. </p>
        pub fn priority(mut self, input: i32) -> Self {
            self.priority = Some(input);
            self
        }
        /// <p>The setting that determines the processing order of the rule group among the rule groups that are associated with a single VPC. DNS Firewall
        /// filters VPC traffic starting from rule group with the lowest numeric priority setting. </p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.priority = input;
            self
        }
        /// <p>If enabled, this setting disallows modification or removal of the association, to help prevent against accidentally altering DNS firewall protections. </p>
        pub fn mutation_protection(
            mut self,
            input: crate::model::MutationProtectionStatus,
        ) -> Self {
            self.mutation_protection = Some(input);
            self
        }
        /// <p>If enabled, this setting disallows modification or removal of the association, to help prevent against accidentally altering DNS firewall protections. </p>
        pub fn set_mutation_protection(
            mut self,
            input: std::option::Option<crate::model::MutationProtectionStatus>,
        ) -> Self {
            self.mutation_protection = input;
            self
        }
        /// <p>The owner of the association, used only for associations that are not managed by you. If you use Firewall Manager to
        /// manage your DNS Firewalls, then this reports Firewall Manager as the managed owner.</p>
        pub fn managed_owner_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.managed_owner_name = Some(input.into());
            self
        }
        /// <p>The owner of the association, used only for associations that are not managed by you. If you use Firewall Manager to
        /// manage your DNS Firewalls, then this reports Firewall Manager as the managed owner.</p>
        pub fn set_managed_owner_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.managed_owner_name = input;
            self
        }
        /// <p>The current status of the association.</p>
        pub fn status(mut self, input: crate::model::FirewallRuleGroupAssociationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the association.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::FirewallRuleGroupAssociationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Additional information about the status of the response, if available.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>Additional information about the status of the response, if available.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>A unique string defined by you to identify the request. This allows you to retry failed
        /// requests without the risk of running the operation twice. This can be any unique string,
        /// for example, a timestamp. </p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.creator_request_id = Some(input.into());
            self
        }
        /// <p>A unique string defined by you to identify the request. This allows you to retry failed
        /// requests without the risk of running the operation twice. This can be any unique string,
        /// for example, a timestamp. </p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creator_request_id = input;
            self
        }
        /// <p>The date and time that the association was created, in Unix time format and Coordinated Universal Time (UTC). </p>
        pub fn creation_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_time = Some(input.into());
            self
        }
        /// <p>The date and time that the association was created, in Unix time format and Coordinated Universal Time (UTC). </p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The date and time that the association was last modified, in Unix time format and Coordinated Universal Time (UTC).</p>
        pub fn modification_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.modification_time = Some(input.into());
            self
        }
        /// <p>The date and time that the association was last modified, in Unix time format and Coordinated Universal Time (UTC).</p>
        pub fn set_modification_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.modification_time = input;
            self
        }
        /// Consumes the builder and constructs a [`FirewallRuleGroupAssociation`](crate::model::FirewallRuleGroupAssociation)
        pub fn build(self) -> crate::model::FirewallRuleGroupAssociation {
            crate::model::FirewallRuleGroupAssociation {
                id: self.id,
                arn: self.arn,
                firewall_rule_group_id: self.firewall_rule_group_id,
                vpc_id: self.vpc_id,
                name: self.name,
                priority: self.priority,
                mutation_protection: self.mutation_protection,
                managed_owner_name: self.managed_owner_name,
                status: self.status,
                status_message: self.status_message,
                creator_request_id: self.creator_request_id,
                creation_time: self.creation_time,
                modification_time: self.modification_time,
            }
        }
    }
}
impl FirewallRuleGroupAssociation {
    /// Creates a new builder-style object to manufacture [`FirewallRuleGroupAssociation`](crate::model::FirewallRuleGroupAssociation)
    pub fn builder() -> crate::model::firewall_rule_group_association::Builder {
        crate::model::firewall_rule_group_association::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FirewallRuleGroupAssociationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Complete,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FirewallRuleGroupAssociationStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETE" => FirewallRuleGroupAssociationStatus::Complete,
            "DELETING" => FirewallRuleGroupAssociationStatus::Deleting,
            "UPDATING" => FirewallRuleGroupAssociationStatus::Updating,
            other => FirewallRuleGroupAssociationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FirewallRuleGroupAssociationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FirewallRuleGroupAssociationStatus::from(s))
    }
}
impl FirewallRuleGroupAssociationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FirewallRuleGroupAssociationStatus::Complete => "COMPLETE",
            FirewallRuleGroupAssociationStatus::Deleting => "DELETING",
            FirewallRuleGroupAssociationStatus::Updating => "UPDATING",
            FirewallRuleGroupAssociationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLETE", "DELETING", "UPDATING"]
    }
}
impl AsRef<str> for FirewallRuleGroupAssociationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MutationProtectionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MutationProtectionStatus {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => MutationProtectionStatus::Disabled,
            "ENABLED" => MutationProtectionStatus::Enabled,
            other => MutationProtectionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MutationProtectionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MutationProtectionStatus::from(s))
    }
}
impl MutationProtectionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MutationProtectionStatus::Disabled => "DISABLED",
            MutationProtectionStatus::Enabled => "ENABLED",
            MutationProtectionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for MutationProtectionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A single firewall rule in a rule group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FirewallRule {
    /// <p>The unique identifier of the firewall rule group of the rule. </p>
    pub firewall_rule_group_id: std::option::Option<std::string::String>,
    /// <p>The ID of the domain list that's used in the rule. </p>
    pub firewall_domain_list_id: std::option::Option<std::string::String>,
    /// <p>The name of the rule. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The priority of the rule in the rule group. This value must be unique within the rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.</p>
    pub priority: std::option::Option<i32>,
    /// <p>The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ALLOW</code> - Permit the request to go through.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ALERT</code> - Permit the request to go through but send an alert to the logs.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>BLOCK</code> - Disallow the request. If this is specified, additional handling details are provided in the rule's <code>BlockResponse</code> setting. </p>
    /// </li>
    /// </ul>
    pub action: std::option::Option<crate::model::Action>,
    /// <p>The way that you want DNS Firewall to block the request. Used for the rule action setting <code>BLOCK</code>.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NODATA</code> - Respond indicating that the query was successful, but no response is available for it.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NXDOMAIN</code> - Respond indicating that the domain name that's in the query doesn't exist.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>OVERRIDE</code> - Provide a custom override in the response. This option requires custom handling details in the rule's <code>BlockOverride*</code> settings. </p>
    /// </li>
    /// </ul>
    pub block_response: std::option::Option<crate::model::BlockResponse>,
    /// <p>The custom DNS record to send back in response to the query. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
    pub block_override_domain: std::option::Option<std::string::String>,
    /// <p>The DNS record's type. This determines the format of the record value that you provided in <code>BlockOverrideDomain</code>. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
    pub block_override_dns_type: std::option::Option<crate::model::BlockOverrideDnsType>,
    /// <p>The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
    pub block_override_ttl: std::option::Option<i32>,
    /// <p>A unique string defined by you to identify the request. This allows you to retry failed requests
    /// without the risk of executing the operation twice. This can be any unique string, for example, a timestamp. </p>
    pub creator_request_id: std::option::Option<std::string::String>,
    /// <p>The date and time that the rule was created, in Unix time format and Coordinated Universal Time (UTC). </p>
    pub creation_time: std::option::Option<std::string::String>,
    /// <p>The date and time that the rule was last modified, in Unix time format and Coordinated Universal Time (UTC).</p>
    pub modification_time: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for FirewallRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FirewallRule");
        formatter.field("firewall_rule_group_id", &self.firewall_rule_group_id);
        formatter.field("firewall_domain_list_id", &self.firewall_domain_list_id);
        formatter.field("name", &self.name);
        formatter.field("priority", &self.priority);
        formatter.field("action", &self.action);
        formatter.field("block_response", &self.block_response);
        formatter.field("block_override_domain", &self.block_override_domain);
        formatter.field("block_override_dns_type", &self.block_override_dns_type);
        formatter.field("block_override_ttl", &self.block_override_ttl);
        formatter.field("creator_request_id", &self.creator_request_id);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("modification_time", &self.modification_time);
        formatter.finish()
    }
}
/// See [`FirewallRule`](crate::model::FirewallRule)
pub mod firewall_rule {
    /// A builder for [`FirewallRule`](crate::model::FirewallRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) firewall_rule_group_id: std::option::Option<std::string::String>,
        pub(crate) firewall_domain_list_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) priority: std::option::Option<i32>,
        pub(crate) action: std::option::Option<crate::model::Action>,
        pub(crate) block_response: std::option::Option<crate::model::BlockResponse>,
        pub(crate) block_override_domain: std::option::Option<std::string::String>,
        pub(crate) block_override_dns_type: std::option::Option<crate::model::BlockOverrideDnsType>,
        pub(crate) block_override_ttl: std::option::Option<i32>,
        pub(crate) creator_request_id: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<std::string::String>,
        pub(crate) modification_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the firewall rule group of the rule. </p>
        pub fn firewall_rule_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_rule_group_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the firewall rule group of the rule. </p>
        pub fn set_firewall_rule_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firewall_rule_group_id = input;
            self
        }
        /// <p>The ID of the domain list that's used in the rule. </p>
        pub fn firewall_domain_list_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.firewall_domain_list_id = Some(input.into());
            self
        }
        /// <p>The ID of the domain list that's used in the rule. </p>
        pub fn set_firewall_domain_list_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.firewall_domain_list_id = input;
            self
        }
        /// <p>The name of the rule. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the rule. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The priority of the rule in the rule group. This value must be unique within the rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.priority = Some(input);
            self
        }
        /// <p>The priority of the rule in the rule group. This value must be unique within the rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.priority = input;
            self
        }
        /// <p>The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALLOW</code> - Permit the request to go through.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALERT</code> - Permit the request to go through but send an alert to the logs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BLOCK</code> - Disallow the request. If this is specified, additional handling details are provided in the rule's <code>BlockResponse</code> setting. </p>
        /// </li>
        /// </ul>
        pub fn action(mut self, input: crate::model::Action) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALLOW</code> - Permit the request to go through.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALERT</code> - Permit the request to go through but send an alert to the logs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BLOCK</code> - Disallow the request. If this is specified, additional handling details are provided in the rule's <code>BlockResponse</code> setting. </p>
        /// </li>
        /// </ul>
        pub fn set_action(mut self, input: std::option::Option<crate::model::Action>) -> Self {
            self.action = input;
            self
        }
        /// <p>The way that you want DNS Firewall to block the request. Used for the rule action setting <code>BLOCK</code>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NODATA</code> - Respond indicating that the query was successful, but no response is available for it.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NXDOMAIN</code> - Respond indicating that the domain name that's in the query doesn't exist.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OVERRIDE</code> - Provide a custom override in the response. This option requires custom handling details in the rule's <code>BlockOverride*</code> settings. </p>
        /// </li>
        /// </ul>
        pub fn block_response(mut self, input: crate::model::BlockResponse) -> Self {
            self.block_response = Some(input);
            self
        }
        /// <p>The way that you want DNS Firewall to block the request. Used for the rule action setting <code>BLOCK</code>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NODATA</code> - Respond indicating that the query was successful, but no response is available for it.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NXDOMAIN</code> - Respond indicating that the domain name that's in the query doesn't exist.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OVERRIDE</code> - Provide a custom override in the response. This option requires custom handling details in the rule's <code>BlockOverride*</code> settings. </p>
        /// </li>
        /// </ul>
        pub fn set_block_response(
            mut self,
            input: std::option::Option<crate::model::BlockResponse>,
        ) -> Self {
            self.block_response = input;
            self
        }
        /// <p>The custom DNS record to send back in response to the query. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
        pub fn block_override_domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.block_override_domain = Some(input.into());
            self
        }
        /// <p>The custom DNS record to send back in response to the query. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
        pub fn set_block_override_domain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.block_override_domain = input;
            self
        }
        /// <p>The DNS record's type. This determines the format of the record value that you provided in <code>BlockOverrideDomain</code>. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
        pub fn block_override_dns_type(
            mut self,
            input: crate::model::BlockOverrideDnsType,
        ) -> Self {
            self.block_override_dns_type = Some(input);
            self
        }
        /// <p>The DNS record's type. This determines the format of the record value that you provided in <code>BlockOverrideDomain</code>. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
        pub fn set_block_override_dns_type(
            mut self,
            input: std::option::Option<crate::model::BlockOverrideDnsType>,
        ) -> Self {
            self.block_override_dns_type = input;
            self
        }
        /// <p>The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
        pub fn block_override_ttl(mut self, input: i32) -> Self {
            self.block_override_ttl = Some(input);
            self
        }
        /// <p>The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Used for the rule action <code>BLOCK</code> with a <code>BlockResponse</code> setting of <code>OVERRIDE</code>.</p>
        pub fn set_block_override_ttl(mut self, input: std::option::Option<i32>) -> Self {
            self.block_override_ttl = input;
            self
        }
        /// <p>A unique string defined by you to identify the request. This allows you to retry failed requests
        /// without the risk of executing the operation twice. This can be any unique string, for example, a timestamp. </p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.creator_request_id = Some(input.into());
            self
        }
        /// <p>A unique string defined by you to identify the request. This allows you to retry failed requests
        /// without the risk of executing the operation twice. This can be any unique string, for example, a timestamp. </p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creator_request_id = input;
            self
        }
        /// <p>The date and time that the rule was created, in Unix time format and Coordinated Universal Time (UTC). </p>
        pub fn creation_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_time = Some(input.into());
            self
        }
        /// <p>The date and time that the rule was created, in Unix time format and Coordinated Universal Time (UTC). </p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The date and time that the rule was last modified, in Unix time format and Coordinated Universal Time (UTC).</p>
        pub fn modification_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.modification_time = Some(input.into());
            self
        }
        /// <p>The date and time that the rule was last modified, in Unix time format and Coordinated Universal Time (UTC).</p>
        pub fn set_modification_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.modification_time = input;
            self
        }
        /// Consumes the builder and constructs a [`FirewallRule`](crate::model::FirewallRule)
        pub fn build(self) -> crate::model::FirewallRule {
            crate::model::FirewallRule {
                firewall_rule_group_id: self.firewall_rule_group_id,
                firewall_domain_list_id: self.firewall_domain_list_id,
                name: self.name,
                priority: self.priority,
                action: self.action,
                block_response: self.block_response,
                block_override_domain: self.block_override_domain,
                block_override_dns_type: self.block_override_dns_type,
                block_override_ttl: self.block_override_ttl,
                creator_request_id: self.creator_request_id,
                creation_time: self.creation_time,
                modification_time: self.modification_time,
            }
        }
    }
}
impl FirewallRule {
    /// Creates a new builder-style object to manufacture [`FirewallRule`](crate::model::FirewallRule)
    pub fn builder() -> crate::model::firewall_rule::Builder {
        crate::model::firewall_rule::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BlockOverrideDnsType {
    #[allow(missing_docs)] // documentation missing in model
    Cname,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BlockOverrideDnsType {
    fn from(s: &str) -> Self {
        match s {
            "CNAME" => BlockOverrideDnsType::Cname,
            other => BlockOverrideDnsType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BlockOverrideDnsType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BlockOverrideDnsType::from(s))
    }
}
impl BlockOverrideDnsType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BlockOverrideDnsType::Cname => "CNAME",
            BlockOverrideDnsType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CNAME"]
    }
}
impl AsRef<str> for BlockOverrideDnsType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BlockResponse {
    #[allow(missing_docs)] // documentation missing in model
    Nodata,
    #[allow(missing_docs)] // documentation missing in model
    Nxdomain,
    #[allow(missing_docs)] // documentation missing in model
    Override,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BlockResponse {
    fn from(s: &str) -> Self {
        match s {
            "NODATA" => BlockResponse::Nodata,
            "NXDOMAIN" => BlockResponse::Nxdomain,
            "OVERRIDE" => BlockResponse::Override,
            other => BlockResponse::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BlockResponse {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BlockResponse::from(s))
    }
}
impl BlockResponse {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BlockResponse::Nodata => "NODATA",
            BlockResponse::Nxdomain => "NXDOMAIN",
            BlockResponse::Override => "OVERRIDE",
            BlockResponse::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NODATA", "NXDOMAIN", "OVERRIDE"]
    }
}
impl AsRef<str> for BlockResponse {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Action {
    #[allow(missing_docs)] // documentation missing in model
    Alert,
    #[allow(missing_docs)] // documentation missing in model
    Allow,
    #[allow(missing_docs)] // documentation missing in model
    Block,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Action {
    fn from(s: &str) -> Self {
        match s {
            "ALERT" => Action::Alert,
            "ALLOW" => Action::Allow,
            "BLOCK" => Action::Block,
            other => Action::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Action {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Action::from(s))
    }
}
impl Action {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Action::Alert => "ALERT",
            Action::Allow => "ALLOW",
            Action::Block => "BLOCK",
            Action::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALERT", "ALLOW", "BLOCK"]
    }
}
impl AsRef<str> for Action {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FirewallDomainListStatus {
    #[allow(missing_docs)] // documentation missing in model
    Complete,
    #[allow(missing_docs)] // documentation missing in model
    CompleteImportFailed,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Importing,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FirewallDomainListStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETE" => FirewallDomainListStatus::Complete,
            "COMPLETE_IMPORT_FAILED" => FirewallDomainListStatus::CompleteImportFailed,
            "DELETING" => FirewallDomainListStatus::Deleting,
            "IMPORTING" => FirewallDomainListStatus::Importing,
            "UPDATING" => FirewallDomainListStatus::Updating,
            other => FirewallDomainListStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FirewallDomainListStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FirewallDomainListStatus::from(s))
    }
}
impl FirewallDomainListStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FirewallDomainListStatus::Complete => "COMPLETE",
            FirewallDomainListStatus::CompleteImportFailed => "COMPLETE_IMPORT_FAILED",
            FirewallDomainListStatus::Deleting => "DELETING",
            FirewallDomainListStatus::Importing => "IMPORTING",
            FirewallDomainListStatus::Updating => "UPDATING",
            FirewallDomainListStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "COMPLETE",
            "COMPLETE_IMPORT_FAILED",
            "DELETING",
            "IMPORTING",
            "UPDATING",
        ]
    }
}
impl AsRef<str> for FirewallDomainListStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FirewallDomainUpdateOperation {
    #[allow(missing_docs)] // documentation missing in model
    Add,
    #[allow(missing_docs)] // documentation missing in model
    Remove,
    #[allow(missing_docs)] // documentation missing in model
    Replace,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FirewallDomainUpdateOperation {
    fn from(s: &str) -> Self {
        match s {
            "ADD" => FirewallDomainUpdateOperation::Add,
            "REMOVE" => FirewallDomainUpdateOperation::Remove,
            "REPLACE" => FirewallDomainUpdateOperation::Replace,
            other => FirewallDomainUpdateOperation::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FirewallDomainUpdateOperation {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FirewallDomainUpdateOperation::from(s))
    }
}
impl FirewallDomainUpdateOperation {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FirewallDomainUpdateOperation::Add => "ADD",
            FirewallDomainUpdateOperation::Remove => "REMOVE",
            FirewallDomainUpdateOperation::Replace => "REPLACE",
            FirewallDomainUpdateOperation::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ADD", "REMOVE", "REPLACE"]
    }
}
impl AsRef<str> for FirewallDomainUpdateOperation {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Configuration of the firewall behavior provided by DNS Firewall for a single VPC from
/// Amazon Virtual Private Cloud (Amazon VPC). </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FirewallConfig {
    /// <p>The ID of the firewall configuration.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The ID of the VPC that this firewall configuration applies to.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID of the owner of the VPC that this firewall configuration applies to.</p>
    pub owner_id: std::option::Option<std::string::String>,
    /// <p>Determines how DNS Firewall operates during failures, for example when all traffic that is sent to DNS Firewall fails to receive a reply. </p>
    /// <ul>
    /// <li>
    /// <p>By default, fail open is disabled, which means the failure mode is closed. This approach favors security over availability. DNS Firewall returns
    /// a failure error when it is unable to properly evaluate a query. </p>
    /// </li>
    /// <li>
    /// <p>If you enable this option, the failure mode is open. This approach favors availability over security. DNS Firewall allows queries to proceed if it
    /// is unable to properly evaluate them. </p>
    /// </li>
    /// </ul>
    /// <p>This behavior is only enforced for VPCs that have at least one DNS Firewall rule group association. </p>
    pub firewall_fail_open: std::option::Option<crate::model::FirewallFailOpenStatus>,
}
impl std::fmt::Debug for FirewallConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FirewallConfig");
        formatter.field("id", &self.id);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("owner_id", &self.owner_id);
        formatter.field("firewall_fail_open", &self.firewall_fail_open);
        formatter.finish()
    }
}
/// See [`FirewallConfig`](crate::model::FirewallConfig)
pub mod firewall_config {
    /// A builder for [`FirewallConfig`](crate::model::FirewallConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) owner_id: std::option::Option<std::string::String>,
        pub(crate) firewall_fail_open: std::option::Option<crate::model::FirewallFailOpenStatus>,
    }
    impl Builder {
        /// <p>The ID of the firewall configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the firewall configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The ID of the VPC that this firewall configuration applies to.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC that this firewall configuration applies to.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the owner of the VPC that this firewall configuration applies to.</p>
        pub fn owner_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the owner of the VPC that this firewall configuration applies to.</p>
        pub fn set_owner_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner_id = input;
            self
        }
        /// <p>Determines how DNS Firewall operates during failures, for example when all traffic that is sent to DNS Firewall fails to receive a reply. </p>
        /// <ul>
        /// <li>
        /// <p>By default, fail open is disabled, which means the failure mode is closed. This approach favors security over availability. DNS Firewall returns
        /// a failure error when it is unable to properly evaluate a query. </p>
        /// </li>
        /// <li>
        /// <p>If you enable this option, the failure mode is open. This approach favors availability over security. DNS Firewall allows queries to proceed if it
        /// is unable to properly evaluate them. </p>
        /// </li>
        /// </ul>
        /// <p>This behavior is only enforced for VPCs that have at least one DNS Firewall rule group association. </p>
        pub fn firewall_fail_open(mut self, input: crate::model::FirewallFailOpenStatus) -> Self {
            self.firewall_fail_open = Some(input);
            self
        }
        /// <p>Determines how DNS Firewall operates during failures, for example when all traffic that is sent to DNS Firewall fails to receive a reply. </p>
        /// <ul>
        /// <li>
        /// <p>By default, fail open is disabled, which means the failure mode is closed. This approach favors security over availability. DNS Firewall returns
        /// a failure error when it is unable to properly evaluate a query. </p>
        /// </li>
        /// <li>
        /// <p>If you enable this option, the failure mode is open. This approach favors availability over security. DNS Firewall allows queries to proceed if it
        /// is unable to properly evaluate them. </p>
        /// </li>
        /// </ul>
        /// <p>This behavior is only enforced for VPCs that have at least one DNS Firewall rule group association. </p>
        pub fn set_firewall_fail_open(
            mut self,
            input: std::option::Option<crate::model::FirewallFailOpenStatus>,
        ) -> Self {
            self.firewall_fail_open = input;
            self
        }
        /// Consumes the builder and constructs a [`FirewallConfig`](crate::model::FirewallConfig)
        pub fn build(self) -> crate::model::FirewallConfig {
            crate::model::FirewallConfig {
                id: self.id,
                resource_id: self.resource_id,
                owner_id: self.owner_id,
                firewall_fail_open: self.firewall_fail_open,
            }
        }
    }
}
impl FirewallConfig {
    /// Creates a new builder-style object to manufacture [`FirewallConfig`](crate::model::FirewallConfig)
    pub fn builder() -> crate::model::firewall_config::Builder {
        crate::model::firewall_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FirewallFailOpenStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FirewallFailOpenStatus {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => FirewallFailOpenStatus::Disabled,
            "ENABLED" => FirewallFailOpenStatus::Enabled,
            other => FirewallFailOpenStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FirewallFailOpenStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FirewallFailOpenStatus::from(s))
    }
}
impl FirewallFailOpenStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FirewallFailOpenStatus::Disabled => "DISABLED",
            FirewallFailOpenStatus::Enabled => "ENABLED",
            FirewallFailOpenStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for FirewallFailOpenStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>One tag that you want to add to the specified resource. A tag consists of a <code>Key</code> (a name for the tag) and a <code>Value</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The name for the tag. For example, if you want to associate Resolver resources with the account IDs of your customers for billing purposes,
    /// the value of <code>Key</code> might be <code>account-id</code>.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value for the tag. For example, if <code>Key</code> is <code>account-id</code>, then <code>Value</code> might be the ID of the
    /// customer account that you're creating the resource for.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name for the tag. For example, if you want to associate Resolver resources with the account IDs of your customers for billing purposes,
        /// the value of <code>Key</code> might be <code>account-id</code>.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The name for the tag. For example, if you want to associate Resolver resources with the account IDs of your customers for billing purposes,
        /// the value of <code>Key</code> might be <code>account-id</code>.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value for the tag. For example, if <code>Key</code> is <code>account-id</code>, then <code>Value</code> might be the ID of the
        /// customer account that you're creating the resource for.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value for the tag. For example, if <code>Key</code> is <code>account-id</code>, then <code>Value</code> might be the ID of the
        /// customer account that you're creating the resource for.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>For Resolver list operations
/// (<a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html">ListResolverEndpoints</a>,
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html">ListResolverRules</a>,
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html">ListResolverRuleAssociations</a>,
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigs.html">ListResolverQueryLogConfigs</a>,
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigAssociations.html">ListResolverQueryLogConfigAssociations</a>),
/// and
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverDnssecConfigs.html">ListResolverDnssecConfigs</a>),
/// an optional specification to return a subset of objects.</p>
/// <p>To filter objects, such as Resolver endpoints or Resolver rules, you specify <code>Name</code> and <code>Values</code>. For example,
/// to list only inbound Resolver endpoints, specify <code>Direction</code> for <code>Name</code> and specify <code>INBOUND</code> for <code>Values</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Filter {
    /// <p>The name of the parameter that you want to use to filter objects.</p>
    /// <p>The valid values for <code>Name</code> depend on the action that you're including the filter in,
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html">ListResolverEndpoints</a>,
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html">ListResolverRules</a>,
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html">ListResolverRuleAssociations</a>,
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigs.html">ListResolverQueryLogConfigs</a>,
    /// or
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigAssociations.html">ListResolverQueryLogConfigAssociations</a>.</p>
    ///
    /// <note>
    /// <p>In early versions of Resolver, values for <code>Name</code> were listed as uppercase, with underscore (_) delimiters. For example,
    /// <code>CreatorRequestId</code> was originally listed as <code>CREATOR_REQUEST_ID</code>. Uppercase values for <code>Name</code> are still supported.</p>
    /// </note>
    ///
    /// <p>
    /// <b>ListResolverEndpoints</b>
    /// </p>
    /// <p>Valid values for <code>Name</code> include the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CreatorRequestId</code>: The value that you specified when you created the Resolver endpoint.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Direction</code>: Whether you want to return inbound or outbound Resolver endpoints. If you specify <code>DIRECTION</code>
    /// for <code>Name</code>, specify <code>INBOUND</code> or <code>OUTBOUND</code> for <code>Values</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>HostVPCId</code>: The ID of the VPC that inbound DNS queries pass through on the way from your network to your VPCs in a region, or
    /// the VPC that outbound queries pass through on the way from your VPCs to your network. In a
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverEndpoint.html">CreateResolverEndpoint</a>
    /// request, <code>SubnetId</code> indirectly identifies the VPC. In a
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html">GetResolverEndpoint</a>
    /// request, the VPC ID for a Resolver endpoint
    /// is returned in the <code>HostVPCId</code> element. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IpAddressCount</code>: The number of IP addresses that you have associated with the Resolver endpoint.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Name</code>: The name of the Resolver endpoint.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SecurityGroupIds</code>: The IDs of the VPC security groups that you specified when you created the
    /// Resolver endpoint.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Status</code>: The status of the Resolver endpoint. If you specify <code>Status</code> for <code>Name</code>,
    /// specify one of the following status codes for <code>Values</code>: <code>CREATING</code>, <code>OPERATIONAL</code>, <code>UPDATING</code>,
    /// <code>AUTO_RECOVERING</code>, <code>ACTION_NEEDED</code>, or <code>DELETING</code>. For more information, see <code>Status</code> in
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ResolverEndpoint.html">ResolverEndpoint</a>.</p>
    /// </li>
    /// </ul>
    ///
    /// <p>
    /// <b>ListResolverRules</b>
    /// </p>
    /// <p>Valid values for <code>Name</code> include the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CreatorRequestId</code>: The value that you specified when you created the Resolver rule.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DomainName</code>: The domain name for which Resolver is forwarding DNS queries to your network. In the value that
    /// you specify for <code>Values</code>, include a trailing dot (.) after the domain name. For example, if the domain name is example.com,
    /// specify the following value. Note the "." after <code>com</code>:</p>
    /// <p>
    /// <code>example.com.</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Name</code>: The name of the Resolver rule.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ResolverEndpointId</code>: The ID of the Resolver endpoint that the Resolver rule is associated with.</p>
    /// <note>
    /// <p>You can filter on the Resolver endpoint only for rules that have a value of <code>FORWARD</code> for
    /// <code>RuleType</code>.</p>
    /// </note>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Status</code>: The status of the Resolver rule. If you specify <code>Status</code> for <code>Name</code>,
    /// specify one of the following status codes for <code>Values</code>: <code>COMPLETE</code>, <code>DELETING</code>, <code>UPDATING</code>,
    /// or <code>FAILED</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Type</code>: The type of the Resolver rule. If you specify <code>TYPE</code>
    /// for <code>Name</code>, specify <code>FORWARD</code> or <code>SYSTEM</code> for <code>Values</code>.</p>
    /// </li>
    /// </ul>
    ///
    /// <p>
    /// <b>ListResolverRuleAssociations</b>
    /// </p>
    /// <p>Valid values for <code>Name</code> include the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Name</code>: The name of the Resolver rule association.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ResolverRuleId</code>: The ID of the Resolver rule that is associated with one or more VPCs.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Status</code>: The status of the Resolver rule association. If you specify <code>Status</code> for <code>Name</code>,
    /// specify one of the following status codes for <code>Values</code>: <code>CREATING</code>, <code>COMPLETE</code>, <code>DELETING</code>, or
    /// <code>FAILED</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>VPCId</code>: The ID of the VPC that the Resolver rule is associated with.</p>
    /// </li>
    /// </ul>
    ///
    /// <p>
    /// <b>ListResolverQueryLogConfigs</b>
    /// </p>
    /// <p>Valid values for <code>Name</code> include the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Arn</code>: The ARN for the query logging configuration.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AssociationCount</code>: The number of VPCs that are associated with the query logging configuration.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CreationTime</code>: The date and time that the query logging configuration was created, in Unix time format and
    /// Coordinated Universal Time (UTC). </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CreatorRequestId</code>: A unique string that identifies the request that created the query logging configuration.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Destination</code>: The Amazon Web Services service that you want to forward query logs to. Valid values include the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>S3</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CloudWatchLogs</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>KinesisFirehose</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DestinationArn</code>: The ARN of the location that Resolver is sending query logs to. This value can be the ARN for an
    /// S3 bucket, a CloudWatch Logs log group, or a Kinesis Data Firehose delivery stream.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Id</code>: The ID of the query logging configuration</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Name</code>: The name of the query logging configuration</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>OwnerId</code>: The Amazon Web Services account ID for the account that created the query logging configuration.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ShareStatus</code>: An indication of whether the query logging configuration is shared with other Amazon Web Services accounts,
    /// or was shared with the current account by another Amazon Web Services account. Valid values include: <code>NOT_SHARED</code>, <code>SHARED_WITH_ME</code>,
    /// or <code>SHARED_BY_ME</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Status</code>: The status of the query logging configuration. If you specify <code>Status</code> for <code>Name</code>,
    /// specify the applicable status code for <code>Values</code>: <code>CREATING</code>, <code>CREATED</code>,
    /// <code>DELETING</code>, or <code>FAILED</code>. For more information, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ResolverQueryLogConfig.html#Route53Resolver-Type-route53resolver_ResolverQueryLogConfig-Status">Status</a>.
    /// </p>
    /// </li>
    /// </ul>
    ///
    /// <p>
    /// <b>ListResolverQueryLogConfigAssociations</b>
    /// </p>
    /// <p>Valid values for <code>Name</code> include the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CreationTime</code>: The date and time that the VPC was associated with the query logging configuration, in Unix time format and
    /// Coordinated Universal Time (UTC).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Error</code>: If the value of <code>Status</code> is <code>FAILED</code>, specify the cause:
    /// <code>DESTINATION_NOT_FOUND</code> or <code>ACCESS_DENIED</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Id</code>: The ID of the query logging association.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ResolverQueryLogConfigId</code>: The ID of the query logging configuration that a VPC is associated with.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ResourceId</code>: The ID of the Amazon VPC that is associated with the query logging configuration.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Status</code>: The status of the query logging association. If you specify <code>Status</code> for <code>Name</code>,
    /// specify the applicable status code for <code>Values</code>: <code>CREATING</code>, <code>CREATED</code>,
    /// <code>DELETING</code>, or <code>FAILED</code>. For more information, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ResolverQueryLogConfigAssociation.html#Route53Resolver-Type-route53resolver_ResolverQueryLogConfigAssociation-Status">Status</a>.
    /// </p>
    /// </li>
    /// </ul>
    pub name: std::option::Option<std::string::String>,
    /// <p>When you're using a <code>List</code> operation and you want the operation to return a subset of objects, such as Resolver endpoints or Resolver rules,
    /// the value of the parameter that you want to use to filter objects. For example, to list only inbound Resolver endpoints, specify <code>Direction</code> for
    /// <code>Name</code> and specify <code>INBOUND</code> for <code>Values</code>.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for Filter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Filter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`Filter`](crate::model::Filter)
pub mod filter {
    /// A builder for [`Filter`](crate::model::Filter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the parameter that you want to use to filter objects.</p>
        /// <p>The valid values for <code>Name</code> depend on the action that you're including the filter in,
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html">ListResolverEndpoints</a>,
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html">ListResolverRules</a>,
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html">ListResolverRuleAssociations</a>,
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigs.html">ListResolverQueryLogConfigs</a>,
        /// or
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigAssociations.html">ListResolverQueryLogConfigAssociations</a>.</p>
        ///
        /// <note>
        /// <p>In early versions of Resolver, values for <code>Name</code> were listed as uppercase, with underscore (_) delimiters. For example,
        /// <code>CreatorRequestId</code> was originally listed as <code>CREATOR_REQUEST_ID</code>. Uppercase values for <code>Name</code> are still supported.</p>
        /// </note>
        ///
        /// <p>
        /// <b>ListResolverEndpoints</b>
        /// </p>
        /// <p>Valid values for <code>Name</code> include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CreatorRequestId</code>: The value that you specified when you created the Resolver endpoint.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Direction</code>: Whether you want to return inbound or outbound Resolver endpoints. If you specify <code>DIRECTION</code>
        /// for <code>Name</code>, specify <code>INBOUND</code> or <code>OUTBOUND</code> for <code>Values</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>HostVPCId</code>: The ID of the VPC that inbound DNS queries pass through on the way from your network to your VPCs in a region, or
        /// the VPC that outbound queries pass through on the way from your VPCs to your network. In a
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverEndpoint.html">CreateResolverEndpoint</a>
        /// request, <code>SubnetId</code> indirectly identifies the VPC. In a
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html">GetResolverEndpoint</a>
        /// request, the VPC ID for a Resolver endpoint
        /// is returned in the <code>HostVPCId</code> element. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IpAddressCount</code>: The number of IP addresses that you have associated with the Resolver endpoint.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Name</code>: The name of the Resolver endpoint.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SecurityGroupIds</code>: The IDs of the VPC security groups that you specified when you created the
        /// Resolver endpoint.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Status</code>: The status of the Resolver endpoint. If you specify <code>Status</code> for <code>Name</code>,
        /// specify one of the following status codes for <code>Values</code>: <code>CREATING</code>, <code>OPERATIONAL</code>, <code>UPDATING</code>,
        /// <code>AUTO_RECOVERING</code>, <code>ACTION_NEEDED</code>, or <code>DELETING</code>. For more information, see <code>Status</code> in
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ResolverEndpoint.html">ResolverEndpoint</a>.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>
        /// <b>ListResolverRules</b>
        /// </p>
        /// <p>Valid values for <code>Name</code> include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CreatorRequestId</code>: The value that you specified when you created the Resolver rule.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DomainName</code>: The domain name for which Resolver is forwarding DNS queries to your network. In the value that
        /// you specify for <code>Values</code>, include a trailing dot (.) after the domain name. For example, if the domain name is example.com,
        /// specify the following value. Note the "." after <code>com</code>:</p>
        /// <p>
        /// <code>example.com.</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Name</code>: The name of the Resolver rule.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ResolverEndpointId</code>: The ID of the Resolver endpoint that the Resolver rule is associated with.</p>
        /// <note>
        /// <p>You can filter on the Resolver endpoint only for rules that have a value of <code>FORWARD</code> for
        /// <code>RuleType</code>.</p>
        /// </note>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Status</code>: The status of the Resolver rule. If you specify <code>Status</code> for <code>Name</code>,
        /// specify one of the following status codes for <code>Values</code>: <code>COMPLETE</code>, <code>DELETING</code>, <code>UPDATING</code>,
        /// or <code>FAILED</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Type</code>: The type of the Resolver rule. If you specify <code>TYPE</code>
        /// for <code>Name</code>, specify <code>FORWARD</code> or <code>SYSTEM</code> for <code>Values</code>.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>
        /// <b>ListResolverRuleAssociations</b>
        /// </p>
        /// <p>Valid values for <code>Name</code> include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Name</code>: The name of the Resolver rule association.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ResolverRuleId</code>: The ID of the Resolver rule that is associated with one or more VPCs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Status</code>: The status of the Resolver rule association. If you specify <code>Status</code> for <code>Name</code>,
        /// specify one of the following status codes for <code>Values</code>: <code>CREATING</code>, <code>COMPLETE</code>, <code>DELETING</code>, or
        /// <code>FAILED</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>VPCId</code>: The ID of the VPC that the Resolver rule is associated with.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>
        /// <b>ListResolverQueryLogConfigs</b>
        /// </p>
        /// <p>Valid values for <code>Name</code> include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Arn</code>: The ARN for the query logging configuration.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AssociationCount</code>: The number of VPCs that are associated with the query logging configuration.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CreationTime</code>: The date and time that the query logging configuration was created, in Unix time format and
        /// Coordinated Universal Time (UTC). </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CreatorRequestId</code>: A unique string that identifies the request that created the query logging configuration.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Destination</code>: The Amazon Web Services service that you want to forward query logs to. Valid values include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>S3</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CloudWatchLogs</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KinesisFirehose</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DestinationArn</code>: The ARN of the location that Resolver is sending query logs to. This value can be the ARN for an
        /// S3 bucket, a CloudWatch Logs log group, or a Kinesis Data Firehose delivery stream.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Id</code>: The ID of the query logging configuration</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Name</code>: The name of the query logging configuration</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OwnerId</code>: The Amazon Web Services account ID for the account that created the query logging configuration.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ShareStatus</code>: An indication of whether the query logging configuration is shared with other Amazon Web Services accounts,
        /// or was shared with the current account by another Amazon Web Services account. Valid values include: <code>NOT_SHARED</code>, <code>SHARED_WITH_ME</code>,
        /// or <code>SHARED_BY_ME</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Status</code>: The status of the query logging configuration. If you specify <code>Status</code> for <code>Name</code>,
        /// specify the applicable status code for <code>Values</code>: <code>CREATING</code>, <code>CREATED</code>,
        /// <code>DELETING</code>, or <code>FAILED</code>. For more information, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ResolverQueryLogConfig.html#Route53Resolver-Type-route53resolver_ResolverQueryLogConfig-Status">Status</a>.
        /// </p>
        /// </li>
        /// </ul>
        ///
        /// <p>
        /// <b>ListResolverQueryLogConfigAssociations</b>
        /// </p>
        /// <p>Valid values for <code>Name</code> include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CreationTime</code>: The date and time that the VPC was associated with the query logging configuration, in Unix time format and
        /// Coordinated Universal Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Error</code>: If the value of <code>Status</code> is <code>FAILED</code>, specify the cause:
        /// <code>DESTINATION_NOT_FOUND</code> or <code>ACCESS_DENIED</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Id</code>: The ID of the query logging association.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ResolverQueryLogConfigId</code>: The ID of the query logging configuration that a VPC is associated with.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ResourceId</code>: The ID of the Amazon VPC that is associated with the query logging configuration.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Status</code>: The status of the query logging association. If you specify <code>Status</code> for <code>Name</code>,
        /// specify the applicable status code for <code>Values</code>: <code>CREATING</code>, <code>CREATED</code>,
        /// <code>DELETING</code>, or <code>FAILED</code>. For more information, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ResolverQueryLogConfigAssociation.html#Route53Resolver-Type-route53resolver_ResolverQueryLogConfigAssociation-Status">Status</a>.
        /// </p>
        /// </li>
        /// </ul>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the parameter that you want to use to filter objects.</p>
        /// <p>The valid values for <code>Name</code> depend on the action that you're including the filter in,
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html">ListResolverEndpoints</a>,
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html">ListResolverRules</a>,
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html">ListResolverRuleAssociations</a>,
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigs.html">ListResolverQueryLogConfigs</a>,
        /// or
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigAssociations.html">ListResolverQueryLogConfigAssociations</a>.</p>
        ///
        /// <note>
        /// <p>In early versions of Resolver, values for <code>Name</code> were listed as uppercase, with underscore (_) delimiters. For example,
        /// <code>CreatorRequestId</code> was originally listed as <code>CREATOR_REQUEST_ID</code>. Uppercase values for <code>Name</code> are still supported.</p>
        /// </note>
        ///
        /// <p>
        /// <b>ListResolverEndpoints</b>
        /// </p>
        /// <p>Valid values for <code>Name</code> include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CreatorRequestId</code>: The value that you specified when you created the Resolver endpoint.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Direction</code>: Whether you want to return inbound or outbound Resolver endpoints. If you specify <code>DIRECTION</code>
        /// for <code>Name</code>, specify <code>INBOUND</code> or <code>OUTBOUND</code> for <code>Values</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>HostVPCId</code>: The ID of the VPC that inbound DNS queries pass through on the way from your network to your VPCs in a region, or
        /// the VPC that outbound queries pass through on the way from your VPCs to your network. In a
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverEndpoint.html">CreateResolverEndpoint</a>
        /// request, <code>SubnetId</code> indirectly identifies the VPC. In a
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html">GetResolverEndpoint</a>
        /// request, the VPC ID for a Resolver endpoint
        /// is returned in the <code>HostVPCId</code> element. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IpAddressCount</code>: The number of IP addresses that you have associated with the Resolver endpoint.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Name</code>: The name of the Resolver endpoint.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SecurityGroupIds</code>: The IDs of the VPC security groups that you specified when you created the
        /// Resolver endpoint.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Status</code>: The status of the Resolver endpoint. If you specify <code>Status</code> for <code>Name</code>,
        /// specify one of the following status codes for <code>Values</code>: <code>CREATING</code>, <code>OPERATIONAL</code>, <code>UPDATING</code>,
        /// <code>AUTO_RECOVERING</code>, <code>ACTION_NEEDED</code>, or <code>DELETING</code>. For more information, see <code>Status</code> in
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ResolverEndpoint.html">ResolverEndpoint</a>.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>
        /// <b>ListResolverRules</b>
        /// </p>
        /// <p>Valid values for <code>Name</code> include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CreatorRequestId</code>: The value that you specified when you created the Resolver rule.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DomainName</code>: The domain name for which Resolver is forwarding DNS queries to your network. In the value that
        /// you specify for <code>Values</code>, include a trailing dot (.) after the domain name. For example, if the domain name is example.com,
        /// specify the following value. Note the "." after <code>com</code>:</p>
        /// <p>
        /// <code>example.com.</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Name</code>: The name of the Resolver rule.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ResolverEndpointId</code>: The ID of the Resolver endpoint that the Resolver rule is associated with.</p>
        /// <note>
        /// <p>You can filter on the Resolver endpoint only for rules that have a value of <code>FORWARD</code> for
        /// <code>RuleType</code>.</p>
        /// </note>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Status</code>: The status of the Resolver rule. If you specify <code>Status</code> for <code>Name</code>,
        /// specify one of the following status codes for <code>Values</code>: <code>COMPLETE</code>, <code>DELETING</code>, <code>UPDATING</code>,
        /// or <code>FAILED</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Type</code>: The type of the Resolver rule. If you specify <code>TYPE</code>
        /// for <code>Name</code>, specify <code>FORWARD</code> or <code>SYSTEM</code> for <code>Values</code>.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>
        /// <b>ListResolverRuleAssociations</b>
        /// </p>
        /// <p>Valid values for <code>Name</code> include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Name</code>: The name of the Resolver rule association.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ResolverRuleId</code>: The ID of the Resolver rule that is associated with one or more VPCs.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Status</code>: The status of the Resolver rule association. If you specify <code>Status</code> for <code>Name</code>,
        /// specify one of the following status codes for <code>Values</code>: <code>CREATING</code>, <code>COMPLETE</code>, <code>DELETING</code>, or
        /// <code>FAILED</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>VPCId</code>: The ID of the VPC that the Resolver rule is associated with.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>
        /// <b>ListResolverQueryLogConfigs</b>
        /// </p>
        /// <p>Valid values for <code>Name</code> include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Arn</code>: The ARN for the query logging configuration.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AssociationCount</code>: The number of VPCs that are associated with the query logging configuration.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CreationTime</code>: The date and time that the query logging configuration was created, in Unix time format and
        /// Coordinated Universal Time (UTC). </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CreatorRequestId</code>: A unique string that identifies the request that created the query logging configuration.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Destination</code>: The Amazon Web Services service that you want to forward query logs to. Valid values include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>S3</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CloudWatchLogs</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>KinesisFirehose</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DestinationArn</code>: The ARN of the location that Resolver is sending query logs to. This value can be the ARN for an
        /// S3 bucket, a CloudWatch Logs log group, or a Kinesis Data Firehose delivery stream.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Id</code>: The ID of the query logging configuration</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Name</code>: The name of the query logging configuration</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OwnerId</code>: The Amazon Web Services account ID for the account that created the query logging configuration.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ShareStatus</code>: An indication of whether the query logging configuration is shared with other Amazon Web Services accounts,
        /// or was shared with the current account by another Amazon Web Services account. Valid values include: <code>NOT_SHARED</code>, <code>SHARED_WITH_ME</code>,
        /// or <code>SHARED_BY_ME</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Status</code>: The status of the query logging configuration. If you specify <code>Status</code> for <code>Name</code>,
        /// specify the applicable status code for <code>Values</code>: <code>CREATING</code>, <code>CREATED</code>,
        /// <code>DELETING</code>, or <code>FAILED</code>. For more information, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ResolverQueryLogConfig.html#Route53Resolver-Type-route53resolver_ResolverQueryLogConfig-Status">Status</a>.
        /// </p>
        /// </li>
        /// </ul>
        ///
        /// <p>
        /// <b>ListResolverQueryLogConfigAssociations</b>
        /// </p>
        /// <p>Valid values for <code>Name</code> include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CreationTime</code>: The date and time that the VPC was associated with the query logging configuration, in Unix time format and
        /// Coordinated Universal Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Error</code>: If the value of <code>Status</code> is <code>FAILED</code>, specify the cause:
        /// <code>DESTINATION_NOT_FOUND</code> or <code>ACCESS_DENIED</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Id</code>: The ID of the query logging association.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ResolverQueryLogConfigId</code>: The ID of the query logging configuration that a VPC is associated with.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ResourceId</code>: The ID of the Amazon VPC that is associated with the query logging configuration.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Status</code>: The status of the query logging association. If you specify <code>Status</code> for <code>Name</code>,
        /// specify the applicable status code for <code>Values</code>: <code>CREATING</code>, <code>CREATED</code>,
        /// <code>DELETING</code>, or <code>FAILED</code>. For more information, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ResolverQueryLogConfigAssociation.html#Route53Resolver-Type-route53resolver_ResolverQueryLogConfigAssociation-Status">Status</a>.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>When you're using a <code>List</code> operation and you want the operation to return a subset of objects, such as Resolver endpoints or Resolver rules,
        /// the value of the parameter that you want to use to filter objects. For example, to list only inbound Resolver endpoints, specify <code>Direction</code> for
        /// <code>Name</code> and specify <code>INBOUND</code> for <code>Values</code>.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>When you're using a <code>List</code> operation and you want the operation to return a subset of objects, such as Resolver endpoints or Resolver rules,
        /// the value of the parameter that you want to use to filter objects. For example, to list only inbound Resolver endpoints, specify <code>Direction</code> for
        /// <code>Name</code> and specify <code>INBOUND</code> for <code>Values</code>.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`Filter`](crate::model::Filter)
        pub fn build(self) -> crate::model::Filter {
            crate::model::Filter {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl Filter {
    /// Creates a new builder-style object to manufacture [`Filter`](crate::model::Filter)
    pub fn builder() -> crate::model::filter::Builder {
        crate::model::filter::Builder::default()
    }
}

/// <p>In the response to an
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverRule.html">AssociateResolverRule</a>,
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverRule.html">DisassociateResolverRule</a>,
/// or
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html">ListResolverRuleAssociations</a>
/// request, provides information about an association between a Resolver rule and a VPC.
/// The association determines which DNS queries that originate in the VPC are forwarded to your network. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResolverRuleAssociation {
    /// <p>The ID of the association between a Resolver rule and a VPC. Resolver assigns this value when you submit an
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverRule.html">AssociateResolverRule</a>
    /// request.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The ID of the Resolver rule that you associated with the VPC that is specified by <code>VPCId</code>.</p>
    pub resolver_rule_id: std::option::Option<std::string::String>,
    /// <p>The name of an association between a Resolver rule and a VPC.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ID of the VPC that you associated the Resolver rule with.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>A code that specifies the current status of the association between a Resolver rule and a VPC.</p>
    pub status: std::option::Option<crate::model::ResolverRuleAssociationStatus>,
    /// <p>A detailed description of the status of the association between a Resolver rule and a VPC.</p>
    pub status_message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResolverRuleAssociation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResolverRuleAssociation");
        formatter.field("id", &self.id);
        formatter.field("resolver_rule_id", &self.resolver_rule_id);
        formatter.field("name", &self.name);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.finish()
    }
}
/// See [`ResolverRuleAssociation`](crate::model::ResolverRuleAssociation)
pub mod resolver_rule_association {
    /// A builder for [`ResolverRuleAssociation`](crate::model::ResolverRuleAssociation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) resolver_rule_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ResolverRuleAssociationStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the association between a Resolver rule and a VPC. Resolver assigns this value when you submit an
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverRule.html">AssociateResolverRule</a>
        /// request.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the association between a Resolver rule and a VPC. Resolver assigns this value when you submit an
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverRule.html">AssociateResolverRule</a>
        /// request.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The ID of the Resolver rule that you associated with the VPC that is specified by <code>VPCId</code>.</p>
        pub fn resolver_rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resolver_rule_id = Some(input.into());
            self
        }
        /// <p>The ID of the Resolver rule that you associated with the VPC that is specified by <code>VPCId</code>.</p>
        pub fn set_resolver_rule_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resolver_rule_id = input;
            self
        }
        /// <p>The name of an association between a Resolver rule and a VPC.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of an association between a Resolver rule and a VPC.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ID of the VPC that you associated the Resolver rule with.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC that you associated the Resolver rule with.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>A code that specifies the current status of the association between a Resolver rule and a VPC.</p>
        pub fn status(mut self, input: crate::model::ResolverRuleAssociationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>A code that specifies the current status of the association between a Resolver rule and a VPC.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ResolverRuleAssociationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A detailed description of the status of the association between a Resolver rule and a VPC.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>A detailed description of the status of the association between a Resolver rule and a VPC.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResolverRuleAssociation`](crate::model::ResolverRuleAssociation)
        pub fn build(self) -> crate::model::ResolverRuleAssociation {
            crate::model::ResolverRuleAssociation {
                id: self.id,
                resolver_rule_id: self.resolver_rule_id,
                name: self.name,
                vpc_id: self.vpc_id,
                status: self.status,
                status_message: self.status_message,
            }
        }
    }
}
impl ResolverRuleAssociation {
    /// Creates a new builder-style object to manufacture [`ResolverRuleAssociation`](crate::model::ResolverRuleAssociation)
    pub fn builder() -> crate::model::resolver_rule_association::Builder {
        crate::model::resolver_rule_association::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResolverRuleAssociationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Complete,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Overridden,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResolverRuleAssociationStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETE" => ResolverRuleAssociationStatus::Complete,
            "CREATING" => ResolverRuleAssociationStatus::Creating,
            "DELETING" => ResolverRuleAssociationStatus::Deleting,
            "FAILED" => ResolverRuleAssociationStatus::Failed,
            "OVERRIDDEN" => ResolverRuleAssociationStatus::Overridden,
            other => ResolverRuleAssociationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResolverRuleAssociationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResolverRuleAssociationStatus::from(s))
    }
}
impl ResolverRuleAssociationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResolverRuleAssociationStatus::Complete => "COMPLETE",
            ResolverRuleAssociationStatus::Creating => "CREATING",
            ResolverRuleAssociationStatus::Deleting => "DELETING",
            ResolverRuleAssociationStatus::Failed => "FAILED",
            ResolverRuleAssociationStatus::Overridden => "OVERRIDDEN",
            ResolverRuleAssociationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLETE", "CREATING", "DELETING", "FAILED", "OVERRIDDEN"]
    }
}
impl AsRef<str> for ResolverRuleAssociationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>In the response to a
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverQueryLogConfig.html">CreateResolverQueryLogConfig</a>,
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DeleteResolverQueryLogConfig.html">DeleteResolverQueryLogConfig</a>,
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverQueryLogConfig.html">GetResolverQueryLogConfig</a>,
/// or
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigs.html">ListResolverQueryLogConfigs</a>
/// request, a complex type that contains settings for one query logging configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResolverQueryLogConfig {
    /// <p>The ID for the query logging configuration.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID for the account that created the query logging configuration. </p>
    pub owner_id: std::option::Option<std::string::String>,
    /// <p>The status of the specified query logging configuration. Valid values include the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATING</code>: Resolver is creating the query logging configuration.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATED</code>: The query logging configuration was successfully created.
    /// Resolver is logging queries that originate in the specified VPC.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETING</code>: Resolver is deleting this query logging configuration.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code>: Resolver can't deliver logs to the location that is specified in the query logging configuration.
    /// Here are two common causes:</p>
    /// <ul>
    /// <li>
    /// <p>The specified destination (for example, an Amazon S3 bucket) was deleted.</p>
    /// </li>
    /// <li>
    /// <p>Permissions don't allow sending logs to the destination.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::ResolverQueryLogConfigStatus>,
    /// <p>An indication of whether the query logging configuration is shared with other Amazon Web Services accounts, or was shared with the current account by another
    /// Amazon Web Services account. Sharing is configured through Resource Access Manager (RAM).</p>
    pub share_status: std::option::Option<crate::model::ShareStatus>,
    /// <p>The number of VPCs that are associated with the query logging configuration.</p>
    pub association_count: i32,
    /// <p>The ARN for the query logging configuration.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the query logging configuration. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ARN of the resource that you want Resolver to send query logs: an Amazon S3 bucket, a CloudWatch Logs log group, or
    /// a Kinesis Data Firehose delivery stream.</p>
    pub destination_arn: std::option::Option<std::string::String>,
    /// <p>A unique string that identifies the request that created the query logging configuration.
    /// The <code>CreatorRequestId</code> allows failed requests to be retried without the risk
    /// of running the operation twice.</p>
    pub creator_request_id: std::option::Option<std::string::String>,
    /// <p>The date and time that the query logging configuration was created, in Unix time format and Coordinated Universal Time (UTC).</p>
    pub creation_time: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResolverQueryLogConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResolverQueryLogConfig");
        formatter.field("id", &self.id);
        formatter.field("owner_id", &self.owner_id);
        formatter.field("status", &self.status);
        formatter.field("share_status", &self.share_status);
        formatter.field("association_count", &self.association_count);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("destination_arn", &self.destination_arn);
        formatter.field("creator_request_id", &self.creator_request_id);
        formatter.field("creation_time", &self.creation_time);
        formatter.finish()
    }
}
/// See [`ResolverQueryLogConfig`](crate::model::ResolverQueryLogConfig)
pub mod resolver_query_log_config {
    /// A builder for [`ResolverQueryLogConfig`](crate::model::ResolverQueryLogConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) owner_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ResolverQueryLogConfigStatus>,
        pub(crate) share_status: std::option::Option<crate::model::ShareStatus>,
        pub(crate) association_count: std::option::Option<i32>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) destination_arn: std::option::Option<std::string::String>,
        pub(crate) creator_request_id: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID for the query logging configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID for the query logging configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Web Services account ID for the account that created the query logging configuration. </p>
        pub fn owner_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID for the account that created the query logging configuration. </p>
        pub fn set_owner_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner_id = input;
            self
        }
        /// <p>The status of the specified query logging configuration. Valid values include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATING</code>: Resolver is creating the query logging configuration.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATED</code>: The query logging configuration was successfully created.
        /// Resolver is logging queries that originate in the specified VPC.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETING</code>: Resolver is deleting this query logging configuration.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code>: Resolver can't deliver logs to the location that is specified in the query logging configuration.
        /// Here are two common causes:</p>
        /// <ul>
        /// <li>
        /// <p>The specified destination (for example, an Amazon S3 bucket) was deleted.</p>
        /// </li>
        /// <li>
        /// <p>Permissions don't allow sending logs to the destination.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::ResolverQueryLogConfigStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the specified query logging configuration. Valid values include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATING</code>: Resolver is creating the query logging configuration.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATED</code>: The query logging configuration was successfully created.
        /// Resolver is logging queries that originate in the specified VPC.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETING</code>: Resolver is deleting this query logging configuration.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code>: Resolver can't deliver logs to the location that is specified in the query logging configuration.
        /// Here are two common causes:</p>
        /// <ul>
        /// <li>
        /// <p>The specified destination (for example, an Amazon S3 bucket) was deleted.</p>
        /// </li>
        /// <li>
        /// <p>Permissions don't allow sending logs to the destination.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ResolverQueryLogConfigStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>An indication of whether the query logging configuration is shared with other Amazon Web Services accounts, or was shared with the current account by another
        /// Amazon Web Services account. Sharing is configured through Resource Access Manager (RAM).</p>
        pub fn share_status(mut self, input: crate::model::ShareStatus) -> Self {
            self.share_status = Some(input);
            self
        }
        /// <p>An indication of whether the query logging configuration is shared with other Amazon Web Services accounts, or was shared with the current account by another
        /// Amazon Web Services account. Sharing is configured through Resource Access Manager (RAM).</p>
        pub fn set_share_status(
            mut self,
            input: std::option::Option<crate::model::ShareStatus>,
        ) -> Self {
            self.share_status = input;
            self
        }
        /// <p>The number of VPCs that are associated with the query logging configuration.</p>
        pub fn association_count(mut self, input: i32) -> Self {
            self.association_count = Some(input);
            self
        }
        /// <p>The number of VPCs that are associated with the query logging configuration.</p>
        pub fn set_association_count(mut self, input: std::option::Option<i32>) -> Self {
            self.association_count = input;
            self
        }
        /// <p>The ARN for the query logging configuration.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN for the query logging configuration.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the query logging configuration. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the query logging configuration. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ARN of the resource that you want Resolver to send query logs: an Amazon S3 bucket, a CloudWatch Logs log group, or
        /// a Kinesis Data Firehose delivery stream.</p>
        pub fn destination_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource that you want Resolver to send query logs: an Amazon S3 bucket, a CloudWatch Logs log group, or
        /// a Kinesis Data Firehose delivery stream.</p>
        pub fn set_destination_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_arn = input;
            self
        }
        /// <p>A unique string that identifies the request that created the query logging configuration.
        /// The <code>CreatorRequestId</code> allows failed requests to be retried without the risk
        /// of running the operation twice.</p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.creator_request_id = Some(input.into());
            self
        }
        /// <p>A unique string that identifies the request that created the query logging configuration.
        /// The <code>CreatorRequestId</code> allows failed requests to be retried without the risk
        /// of running the operation twice.</p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creator_request_id = input;
            self
        }
        /// <p>The date and time that the query logging configuration was created, in Unix time format and Coordinated Universal Time (UTC).</p>
        pub fn creation_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_time = Some(input.into());
            self
        }
        /// <p>The date and time that the query logging configuration was created, in Unix time format and Coordinated Universal Time (UTC).</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ResolverQueryLogConfig`](crate::model::ResolverQueryLogConfig)
        pub fn build(self) -> crate::model::ResolverQueryLogConfig {
            crate::model::ResolverQueryLogConfig {
                id: self.id,
                owner_id: self.owner_id,
                status: self.status,
                share_status: self.share_status,
                association_count: self.association_count.unwrap_or_default(),
                arn: self.arn,
                name: self.name,
                destination_arn: self.destination_arn,
                creator_request_id: self.creator_request_id,
                creation_time: self.creation_time,
            }
        }
    }
}
impl ResolverQueryLogConfig {
    /// Creates a new builder-style object to manufacture [`ResolverQueryLogConfig`](crate::model::ResolverQueryLogConfig)
    pub fn builder() -> crate::model::resolver_query_log_config::Builder {
        crate::model::resolver_query_log_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResolverQueryLogConfigStatus {
    #[allow(missing_docs)] // documentation missing in model
    Created,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResolverQueryLogConfigStatus {
    fn from(s: &str) -> Self {
        match s {
            "CREATED" => ResolverQueryLogConfigStatus::Created,
            "CREATING" => ResolverQueryLogConfigStatus::Creating,
            "DELETING" => ResolverQueryLogConfigStatus::Deleting,
            "FAILED" => ResolverQueryLogConfigStatus::Failed,
            other => ResolverQueryLogConfigStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResolverQueryLogConfigStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResolverQueryLogConfigStatus::from(s))
    }
}
impl ResolverQueryLogConfigStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResolverQueryLogConfigStatus::Created => "CREATED",
            ResolverQueryLogConfigStatus::Creating => "CREATING",
            ResolverQueryLogConfigStatus::Deleting => "DELETING",
            ResolverQueryLogConfigStatus::Failed => "FAILED",
            ResolverQueryLogConfigStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CREATED", "CREATING", "DELETING", "FAILED"]
    }
}
impl AsRef<str> for ResolverQueryLogConfigStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SortOrder {
    #[allow(missing_docs)] // documentation missing in model
    Ascending,
    #[allow(missing_docs)] // documentation missing in model
    Descending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SortOrder {
    fn from(s: &str) -> Self {
        match s {
            "ASCENDING" => SortOrder::Ascending,
            "DESCENDING" => SortOrder::Descending,
            other => SortOrder::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SortOrder {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SortOrder::from(s))
    }
}
impl SortOrder {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SortOrder::Ascending => "ASCENDING",
            SortOrder::Descending => "DESCENDING",
            SortOrder::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ASCENDING", "DESCENDING"]
    }
}
impl AsRef<str> for SortOrder {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>In the response to an
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverQueryLogConfig.html">AssociateResolverQueryLogConfig</a>,
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverQueryLogConfig.html">DisassociateResolverQueryLogConfig</a>,
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverQueryLogConfigAssociation.html">GetResolverQueryLogConfigAssociation</a>,
/// or
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigAssociations.html">ListResolverQueryLogConfigAssociations</a>,
/// request, a complex type that contains settings for a specified association between an Amazon VPC and a query logging configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResolverQueryLogConfigAssociation {
    /// <p>The ID of the query logging association.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The ID of the query logging configuration that a VPC is associated with.</p>
    pub resolver_query_log_config_id: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon VPC that is associated with the query logging configuration.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The status of the specified query logging association. Valid values include the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATING</code>: Resolver is creating an association between an Amazon VPC and a query logging configuration.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATED</code>: The association between an Amazon VPC and a query logging configuration
    /// was successfully created. Resolver is logging queries that originate in the specified VPC.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETING</code>: Resolver is deleting this query logging association.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code>: Resolver either couldn't create or couldn't delete the query logging association.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::ResolverQueryLogConfigAssociationStatus>,
    /// <p>If the value of <code>Status</code> is <code>FAILED</code>, the value of <code>Error</code> indicates the cause:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>DESTINATION_NOT_FOUND</code>: The specified destination (for example, an Amazon S3 bucket) was deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ACCESS_DENIED</code>: Permissions don't allow sending logs to the destination.</p>
    /// </li>
    /// </ul>
    /// <p>If the value of <code>Status</code> is a value other than <code>FAILED</code>, <code>Error</code> is null. </p>
    pub error: std::option::Option<crate::model::ResolverQueryLogConfigAssociationError>,
    /// <p>Contains additional information about the error. If the value or <code>Error</code> is null, the value of <code>ErrorMessage</code> also is null.</p>
    pub error_message: std::option::Option<std::string::String>,
    /// <p>The date and time that the VPC was associated with the query logging configuration, in Unix time format and Coordinated Universal Time (UTC).</p>
    pub creation_time: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResolverQueryLogConfigAssociation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResolverQueryLogConfigAssociation");
        formatter.field("id", &self.id);
        formatter.field(
            "resolver_query_log_config_id",
            &self.resolver_query_log_config_id,
        );
        formatter.field("resource_id", &self.resource_id);
        formatter.field("status", &self.status);
        formatter.field("error", &self.error);
        formatter.field("error_message", &self.error_message);
        formatter.field("creation_time", &self.creation_time);
        formatter.finish()
    }
}
/// See [`ResolverQueryLogConfigAssociation`](crate::model::ResolverQueryLogConfigAssociation)
pub mod resolver_query_log_config_association {
    /// A builder for [`ResolverQueryLogConfigAssociation`](crate::model::ResolverQueryLogConfigAssociation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) resolver_query_log_config_id: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) status:
            std::option::Option<crate::model::ResolverQueryLogConfigAssociationStatus>,
        pub(crate) error: std::option::Option<crate::model::ResolverQueryLogConfigAssociationError>,
        pub(crate) error_message: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the query logging association.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the query logging association.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The ID of the query logging configuration that a VPC is associated with.</p>
        pub fn resolver_query_log_config_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.resolver_query_log_config_id = Some(input.into());
            self
        }
        /// <p>The ID of the query logging configuration that a VPC is associated with.</p>
        pub fn set_resolver_query_log_config_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resolver_query_log_config_id = input;
            self
        }
        /// <p>The ID of the Amazon VPC that is associated with the query logging configuration.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon VPC that is associated with the query logging configuration.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The status of the specified query logging association. Valid values include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATING</code>: Resolver is creating an association between an Amazon VPC and a query logging configuration.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATED</code>: The association between an Amazon VPC and a query logging configuration
        /// was successfully created. Resolver is logging queries that originate in the specified VPC.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETING</code>: Resolver is deleting this query logging association.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code>: Resolver either couldn't create or couldn't delete the query logging association.</p>
        /// </li>
        /// </ul>
        pub fn status(
            mut self,
            input: crate::model::ResolverQueryLogConfigAssociationStatus,
        ) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the specified query logging association. Valid values include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATING</code>: Resolver is creating an association between an Amazon VPC and a query logging configuration.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATED</code>: The association between an Amazon VPC and a query logging configuration
        /// was successfully created. Resolver is logging queries that originate in the specified VPC.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETING</code>: Resolver is deleting this query logging association.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code>: Resolver either couldn't create or couldn't delete the query logging association.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ResolverQueryLogConfigAssociationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>If the value of <code>Status</code> is <code>FAILED</code>, the value of <code>Error</code> indicates the cause:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DESTINATION_NOT_FOUND</code>: The specified destination (for example, an Amazon S3 bucket) was deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACCESS_DENIED</code>: Permissions don't allow sending logs to the destination.</p>
        /// </li>
        /// </ul>
        /// <p>If the value of <code>Status</code> is a value other than <code>FAILED</code>, <code>Error</code> is null. </p>
        pub fn error(
            mut self,
            input: crate::model::ResolverQueryLogConfigAssociationError,
        ) -> Self {
            self.error = Some(input);
            self
        }
        /// <p>If the value of <code>Status</code> is <code>FAILED</code>, the value of <code>Error</code> indicates the cause:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DESTINATION_NOT_FOUND</code>: The specified destination (for example, an Amazon S3 bucket) was deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACCESS_DENIED</code>: Permissions don't allow sending logs to the destination.</p>
        /// </li>
        /// </ul>
        /// <p>If the value of <code>Status</code> is a value other than <code>FAILED</code>, <code>Error</code> is null. </p>
        pub fn set_error(
            mut self,
            input: std::option::Option<crate::model::ResolverQueryLogConfigAssociationError>,
        ) -> Self {
            self.error = input;
            self
        }
        /// <p>Contains additional information about the error. If the value or <code>Error</code> is null, the value of <code>ErrorMessage</code> also is null.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>Contains additional information about the error. If the value or <code>Error</code> is null, the value of <code>ErrorMessage</code> also is null.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// <p>The date and time that the VPC was associated with the query logging configuration, in Unix time format and Coordinated Universal Time (UTC).</p>
        pub fn creation_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_time = Some(input.into());
            self
        }
        /// <p>The date and time that the VPC was associated with the query logging configuration, in Unix time format and Coordinated Universal Time (UTC).</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ResolverQueryLogConfigAssociation`](crate::model::ResolverQueryLogConfigAssociation)
        pub fn build(self) -> crate::model::ResolverQueryLogConfigAssociation {
            crate::model::ResolverQueryLogConfigAssociation {
                id: self.id,
                resolver_query_log_config_id: self.resolver_query_log_config_id,
                resource_id: self.resource_id,
                status: self.status,
                error: self.error,
                error_message: self.error_message,
                creation_time: self.creation_time,
            }
        }
    }
}
impl ResolverQueryLogConfigAssociation {
    /// Creates a new builder-style object to manufacture [`ResolverQueryLogConfigAssociation`](crate::model::ResolverQueryLogConfigAssociation)
    pub fn builder() -> crate::model::resolver_query_log_config_association::Builder {
        crate::model::resolver_query_log_config_association::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResolverQueryLogConfigAssociationError {
    #[allow(missing_docs)] // documentation missing in model
    AccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    DestinationNotFound,
    #[allow(missing_docs)] // documentation missing in model
    InternalServiceError,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResolverQueryLogConfigAssociationError {
    fn from(s: &str) -> Self {
        match s {
            "ACCESS_DENIED" => ResolverQueryLogConfigAssociationError::AccessDenied,
            "DESTINATION_NOT_FOUND" => ResolverQueryLogConfigAssociationError::DestinationNotFound,
            "INTERNAL_SERVICE_ERROR" => {
                ResolverQueryLogConfigAssociationError::InternalServiceError
            }
            "NONE" => ResolverQueryLogConfigAssociationError::None,
            other => ResolverQueryLogConfigAssociationError::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResolverQueryLogConfigAssociationError {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResolverQueryLogConfigAssociationError::from(s))
    }
}
impl ResolverQueryLogConfigAssociationError {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResolverQueryLogConfigAssociationError::AccessDenied => "ACCESS_DENIED",
            ResolverQueryLogConfigAssociationError::DestinationNotFound => "DESTINATION_NOT_FOUND",
            ResolverQueryLogConfigAssociationError::InternalServiceError => {
                "INTERNAL_SERVICE_ERROR"
            }
            ResolverQueryLogConfigAssociationError::None => "NONE",
            ResolverQueryLogConfigAssociationError::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACCESS_DENIED",
            "DESTINATION_NOT_FOUND",
            "INTERNAL_SERVICE_ERROR",
            "NONE",
        ]
    }
}
impl AsRef<str> for ResolverQueryLogConfigAssociationError {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResolverQueryLogConfigAssociationStatus {
    #[allow(missing_docs)] // documentation missing in model
    ActionNeeded,
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResolverQueryLogConfigAssociationStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTION_NEEDED" => ResolverQueryLogConfigAssociationStatus::ActionNeeded,
            "ACTIVE" => ResolverQueryLogConfigAssociationStatus::Active,
            "CREATING" => ResolverQueryLogConfigAssociationStatus::Creating,
            "DELETING" => ResolverQueryLogConfigAssociationStatus::Deleting,
            "FAILED" => ResolverQueryLogConfigAssociationStatus::Failed,
            other => ResolverQueryLogConfigAssociationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResolverQueryLogConfigAssociationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResolverQueryLogConfigAssociationStatus::from(s))
    }
}
impl ResolverQueryLogConfigAssociationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResolverQueryLogConfigAssociationStatus::ActionNeeded => "ACTION_NEEDED",
            ResolverQueryLogConfigAssociationStatus::Active => "ACTIVE",
            ResolverQueryLogConfigAssociationStatus::Creating => "CREATING",
            ResolverQueryLogConfigAssociationStatus::Deleting => "DELETING",
            ResolverQueryLogConfigAssociationStatus::Failed => "FAILED",
            ResolverQueryLogConfigAssociationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTION_NEEDED", "ACTIVE", "CREATING", "DELETING", "FAILED"]
    }
}
impl AsRef<str> for ResolverQueryLogConfigAssociationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>In the response to a
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html">GetResolverEndpoint</a>
/// request, information about the IP addresses that the Resolver endpoint uses for DNS queries.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IpAddressResponse {
    /// <p>The ID of one IP address.</p>
    pub ip_id: std::option::Option<std::string::String>,
    /// <p>The ID of one subnet.</p>
    pub subnet_id: std::option::Option<std::string::String>,
    /// <p>One IP address that the Resolver endpoint uses for DNS queries.</p>
    pub ip: std::option::Option<std::string::String>,
    /// <p>A status code that gives the current status of the request.</p>
    pub status: std::option::Option<crate::model::IpAddressStatus>,
    /// <p>A message that provides additional information about the status of the request.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>The date and time that the IP address was created, in Unix time format and Coordinated Universal Time (UTC).</p>
    pub creation_time: std::option::Option<std::string::String>,
    /// <p>The date and time that the IP address was last modified, in Unix time format and Coordinated Universal Time (UTC).</p>
    pub modification_time: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IpAddressResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IpAddressResponse");
        formatter.field("ip_id", &self.ip_id);
        formatter.field("subnet_id", &self.subnet_id);
        formatter.field("ip", &self.ip);
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("modification_time", &self.modification_time);
        formatter.finish()
    }
}
/// See [`IpAddressResponse`](crate::model::IpAddressResponse)
pub mod ip_address_response {
    /// A builder for [`IpAddressResponse`](crate::model::IpAddressResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ip_id: std::option::Option<std::string::String>,
        pub(crate) subnet_id: std::option::Option<std::string::String>,
        pub(crate) ip: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::IpAddressStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<std::string::String>,
        pub(crate) modification_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of one IP address.</p>
        pub fn ip_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_id = Some(input.into());
            self
        }
        /// <p>The ID of one IP address.</p>
        pub fn set_ip_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_id = input;
            self
        }
        /// <p>The ID of one subnet.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>The ID of one subnet.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// <p>One IP address that the Resolver endpoint uses for DNS queries.</p>
        pub fn ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip = Some(input.into());
            self
        }
        /// <p>One IP address that the Resolver endpoint uses for DNS queries.</p>
        pub fn set_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip = input;
            self
        }
        /// <p>A status code that gives the current status of the request.</p>
        pub fn status(mut self, input: crate::model::IpAddressStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>A status code that gives the current status of the request.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::IpAddressStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A message that provides additional information about the status of the request.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>A message that provides additional information about the status of the request.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>The date and time that the IP address was created, in Unix time format and Coordinated Universal Time (UTC).</p>
        pub fn creation_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_time = Some(input.into());
            self
        }
        /// <p>The date and time that the IP address was created, in Unix time format and Coordinated Universal Time (UTC).</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The date and time that the IP address was last modified, in Unix time format and Coordinated Universal Time (UTC).</p>
        pub fn modification_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.modification_time = Some(input.into());
            self
        }
        /// <p>The date and time that the IP address was last modified, in Unix time format and Coordinated Universal Time (UTC).</p>
        pub fn set_modification_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.modification_time = input;
            self
        }
        /// Consumes the builder and constructs a [`IpAddressResponse`](crate::model::IpAddressResponse)
        pub fn build(self) -> crate::model::IpAddressResponse {
            crate::model::IpAddressResponse {
                ip_id: self.ip_id,
                subnet_id: self.subnet_id,
                ip: self.ip,
                status: self.status,
                status_message: self.status_message,
                creation_time: self.creation_time,
                modification_time: self.modification_time,
            }
        }
    }
}
impl IpAddressResponse {
    /// Creates a new builder-style object to manufacture [`IpAddressResponse`](crate::model::IpAddressResponse)
    pub fn builder() -> crate::model::ip_address_response::Builder {
        crate::model::ip_address_response::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IpAddressStatus {
    #[allow(missing_docs)] // documentation missing in model
    Attached,
    #[allow(missing_docs)] // documentation missing in model
    Attaching,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    DeleteFailedFasExpired,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Detaching,
    #[allow(missing_docs)] // documentation missing in model
    FailedCreation,
    #[allow(missing_docs)] // documentation missing in model
    FailedResourceGone,
    #[allow(missing_docs)] // documentation missing in model
    RemapAttaching,
    #[allow(missing_docs)] // documentation missing in model
    RemapDetaching,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IpAddressStatus {
    fn from(s: &str) -> Self {
        match s {
            "ATTACHED" => IpAddressStatus::Attached,
            "ATTACHING" => IpAddressStatus::Attaching,
            "CREATING" => IpAddressStatus::Creating,
            "DELETE_FAILED_FAS_EXPIRED" => IpAddressStatus::DeleteFailedFasExpired,
            "DELETING" => IpAddressStatus::Deleting,
            "DETACHING" => IpAddressStatus::Detaching,
            "FAILED_CREATION" => IpAddressStatus::FailedCreation,
            "FAILED_RESOURCE_GONE" => IpAddressStatus::FailedResourceGone,
            "REMAP_ATTACHING" => IpAddressStatus::RemapAttaching,
            "REMAP_DETACHING" => IpAddressStatus::RemapDetaching,
            other => IpAddressStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IpAddressStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IpAddressStatus::from(s))
    }
}
impl IpAddressStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IpAddressStatus::Attached => "ATTACHED",
            IpAddressStatus::Attaching => "ATTACHING",
            IpAddressStatus::Creating => "CREATING",
            IpAddressStatus::DeleteFailedFasExpired => "DELETE_FAILED_FAS_EXPIRED",
            IpAddressStatus::Deleting => "DELETING",
            IpAddressStatus::Detaching => "DETACHING",
            IpAddressStatus::FailedCreation => "FAILED_CREATION",
            IpAddressStatus::FailedResourceGone => "FAILED_RESOURCE_GONE",
            IpAddressStatus::RemapAttaching => "REMAP_ATTACHING",
            IpAddressStatus::RemapDetaching => "REMAP_DETACHING",
            IpAddressStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ATTACHED",
            "ATTACHING",
            "CREATING",
            "DELETE_FAILED_FAS_EXPIRED",
            "DELETING",
            "DETACHING",
            "FAILED_CREATION",
            "FAILED_RESOURCE_GONE",
            "REMAP_ATTACHING",
            "REMAP_DETACHING",
        ]
    }
}
impl AsRef<str> for IpAddressStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Minimal high-level information for a firewall rule group. The action <a>ListFirewallRuleGroups</a> returns an array of these objects. </p>
/// <p>To retrieve full information for a firewall rule group, call <a>GetFirewallRuleGroup</a> and <a>ListFirewallRules</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FirewallRuleGroupMetadata {
    /// <p>The ID of the rule group. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The ARN (Amazon Resource Name) of the rule group.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the rule group.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID for the account that created the rule group. When a rule group is shared with your account,
    /// this is the account that has shared the rule group with you.  </p>
    pub owner_id: std::option::Option<std::string::String>,
    /// <p>A unique string defined by you to identify the request. This allows you to retry failed
    /// requests without the risk of running the operation twice. This can be any unique string,
    /// for example, a timestamp. </p>
    pub creator_request_id: std::option::Option<std::string::String>,
    /// <p>Whether the rule group is shared with other Amazon Web Services accounts, or was shared with the current account by another
    /// Amazon Web Services account. Sharing is configured through Resource Access Manager (RAM).</p>
    pub share_status: std::option::Option<crate::model::ShareStatus>,
}
impl std::fmt::Debug for FirewallRuleGroupMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FirewallRuleGroupMetadata");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("owner_id", &self.owner_id);
        formatter.field("creator_request_id", &self.creator_request_id);
        formatter.field("share_status", &self.share_status);
        formatter.finish()
    }
}
/// See [`FirewallRuleGroupMetadata`](crate::model::FirewallRuleGroupMetadata)
pub mod firewall_rule_group_metadata {
    /// A builder for [`FirewallRuleGroupMetadata`](crate::model::FirewallRuleGroupMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) owner_id: std::option::Option<std::string::String>,
        pub(crate) creator_request_id: std::option::Option<std::string::String>,
        pub(crate) share_status: std::option::Option<crate::model::ShareStatus>,
    }
    impl Builder {
        /// <p>The ID of the rule group. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the rule group. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the rule group.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the rule group.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the rule group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the rule group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Web Services account ID for the account that created the rule group. When a rule group is shared with your account,
        /// this is the account that has shared the rule group with you.  </p>
        pub fn owner_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID for the account that created the rule group. When a rule group is shared with your account,
        /// this is the account that has shared the rule group with you.  </p>
        pub fn set_owner_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner_id = input;
            self
        }
        /// <p>A unique string defined by you to identify the request. This allows you to retry failed
        /// requests without the risk of running the operation twice. This can be any unique string,
        /// for example, a timestamp. </p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.creator_request_id = Some(input.into());
            self
        }
        /// <p>A unique string defined by you to identify the request. This allows you to retry failed
        /// requests without the risk of running the operation twice. This can be any unique string,
        /// for example, a timestamp. </p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creator_request_id = input;
            self
        }
        /// <p>Whether the rule group is shared with other Amazon Web Services accounts, or was shared with the current account by another
        /// Amazon Web Services account. Sharing is configured through Resource Access Manager (RAM).</p>
        pub fn share_status(mut self, input: crate::model::ShareStatus) -> Self {
            self.share_status = Some(input);
            self
        }
        /// <p>Whether the rule group is shared with other Amazon Web Services accounts, or was shared with the current account by another
        /// Amazon Web Services account. Sharing is configured through Resource Access Manager (RAM).</p>
        pub fn set_share_status(
            mut self,
            input: std::option::Option<crate::model::ShareStatus>,
        ) -> Self {
            self.share_status = input;
            self
        }
        /// Consumes the builder and constructs a [`FirewallRuleGroupMetadata`](crate::model::FirewallRuleGroupMetadata)
        pub fn build(self) -> crate::model::FirewallRuleGroupMetadata {
            crate::model::FirewallRuleGroupMetadata {
                id: self.id,
                arn: self.arn,
                name: self.name,
                owner_id: self.owner_id,
                creator_request_id: self.creator_request_id,
                share_status: self.share_status,
            }
        }
    }
}
impl FirewallRuleGroupMetadata {
    /// Creates a new builder-style object to manufacture [`FirewallRuleGroupMetadata`](crate::model::FirewallRuleGroupMetadata)
    pub fn builder() -> crate::model::firewall_rule_group_metadata::Builder {
        crate::model::firewall_rule_group_metadata::Builder::default()
    }
}

/// <p>Minimal high-level information for a firewall domain list. The action <a>ListFirewallDomainLists</a> returns an array of these objects. </p>
/// <p>To retrieve full information for a firewall domain list, call  <a>GetFirewallDomainList</a> and <a>ListFirewallDomains</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FirewallDomainListMetadata {
    /// <p>The ID of the domain list. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the firewall domain list metadata.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the domain list. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A unique string defined by you to identify the request. This allows you to retry failed
    /// requests without the risk of running the operation twice. This can be any unique string,
    /// for example, a timestamp. </p>
    pub creator_request_id: std::option::Option<std::string::String>,
    /// <p>The owner of the list, used only for lists that are not managed by you. For example, the managed domain list <code>AWSManagedDomainsMalwareDomainList</code> has the managed owner name <code>Route 53 Resolver DNS Firewall</code>.</p>
    pub managed_owner_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for FirewallDomainListMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FirewallDomainListMetadata");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("creator_request_id", &self.creator_request_id);
        formatter.field("managed_owner_name", &self.managed_owner_name);
        formatter.finish()
    }
}
/// See [`FirewallDomainListMetadata`](crate::model::FirewallDomainListMetadata)
pub mod firewall_domain_list_metadata {
    /// A builder for [`FirewallDomainListMetadata`](crate::model::FirewallDomainListMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) creator_request_id: std::option::Option<std::string::String>,
        pub(crate) managed_owner_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the domain list. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the domain list. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall domain list metadata.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall domain list metadata.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the domain list. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the domain list. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A unique string defined by you to identify the request. This allows you to retry failed
        /// requests without the risk of running the operation twice. This can be any unique string,
        /// for example, a timestamp. </p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.creator_request_id = Some(input.into());
            self
        }
        /// <p>A unique string defined by you to identify the request. This allows you to retry failed
        /// requests without the risk of running the operation twice. This can be any unique string,
        /// for example, a timestamp. </p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creator_request_id = input;
            self
        }
        /// <p>The owner of the list, used only for lists that are not managed by you. For example, the managed domain list <code>AWSManagedDomainsMalwareDomainList</code> has the managed owner name <code>Route 53 Resolver DNS Firewall</code>.</p>
        pub fn managed_owner_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.managed_owner_name = Some(input.into());
            self
        }
        /// <p>The owner of the list, used only for lists that are not managed by you. For example, the managed domain list <code>AWSManagedDomainsMalwareDomainList</code> has the managed owner name <code>Route 53 Resolver DNS Firewall</code>.</p>
        pub fn set_managed_owner_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.managed_owner_name = input;
            self
        }
        /// Consumes the builder and constructs a [`FirewallDomainListMetadata`](crate::model::FirewallDomainListMetadata)
        pub fn build(self) -> crate::model::FirewallDomainListMetadata {
            crate::model::FirewallDomainListMetadata {
                id: self.id,
                arn: self.arn,
                name: self.name,
                creator_request_id: self.creator_request_id,
                managed_owner_name: self.managed_owner_name,
            }
        }
    }
}
impl FirewallDomainListMetadata {
    /// Creates a new builder-style object to manufacture [`FirewallDomainListMetadata`](crate::model::FirewallDomainListMetadata)
    pub fn builder() -> crate::model::firewall_domain_list_metadata::Builder {
        crate::model::firewall_domain_list_metadata::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FirewallDomainImportOperation {
    #[allow(missing_docs)] // documentation missing in model
    Replace,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FirewallDomainImportOperation {
    fn from(s: &str) -> Self {
        match s {
            "REPLACE" => FirewallDomainImportOperation::Replace,
            other => FirewallDomainImportOperation::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FirewallDomainImportOperation {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FirewallDomainImportOperation::from(s))
    }
}
impl FirewallDomainImportOperation {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FirewallDomainImportOperation::Replace => "REPLACE",
            FirewallDomainImportOperation::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["REPLACE"]
    }
}
impl AsRef<str> for FirewallDomainImportOperation {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>High-level information for a firewall rule group. A firewall rule group is a collection of rules that DNS Firewall uses to filter DNS network traffic for a VPC. To retrieve the rules for the rule group, call <a>ListFirewallRules</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FirewallRuleGroup {
    /// <p>The ID of the rule group. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The ARN (Amazon Resource Name) of the rule group.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the rule group.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The number of rules in the rule group.</p>
    pub rule_count: std::option::Option<i32>,
    /// <p>The status of the domain list.  </p>
    pub status: std::option::Option<crate::model::FirewallRuleGroupStatus>,
    /// <p>Additional information about the status of the rule group, if available.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID for the account that created the rule group. When a rule group is shared with your account,
    /// this is the account that has shared the rule group with you.  </p>
    pub owner_id: std::option::Option<std::string::String>,
    /// <p>A unique string defined by you to identify the request. This allows you to retry failed
    /// requests without the risk of running the operation twice. This can be any unique string,
    /// for example, a timestamp. </p>
    pub creator_request_id: std::option::Option<std::string::String>,
    /// <p>Whether the rule group is shared with other Amazon Web Services accounts, or was shared with the current account by another
    /// Amazon Web Services account. Sharing is configured through Resource Access Manager (RAM).</p>
    pub share_status: std::option::Option<crate::model::ShareStatus>,
    /// <p>The date and time that the rule group was created, in Unix time format and Coordinated Universal Time (UTC). </p>
    pub creation_time: std::option::Option<std::string::String>,
    /// <p>The date and time that the rule group was last modified, in Unix time format and Coordinated Universal Time (UTC).</p>
    pub modification_time: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for FirewallRuleGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FirewallRuleGroup");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("rule_count", &self.rule_count);
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.field("owner_id", &self.owner_id);
        formatter.field("creator_request_id", &self.creator_request_id);
        formatter.field("share_status", &self.share_status);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("modification_time", &self.modification_time);
        formatter.finish()
    }
}
/// See [`FirewallRuleGroup`](crate::model::FirewallRuleGroup)
pub mod firewall_rule_group {
    /// A builder for [`FirewallRuleGroup`](crate::model::FirewallRuleGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) rule_count: std::option::Option<i32>,
        pub(crate) status: std::option::Option<crate::model::FirewallRuleGroupStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) owner_id: std::option::Option<std::string::String>,
        pub(crate) creator_request_id: std::option::Option<std::string::String>,
        pub(crate) share_status: std::option::Option<crate::model::ShareStatus>,
        pub(crate) creation_time: std::option::Option<std::string::String>,
        pub(crate) modification_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the rule group. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the rule group. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the rule group.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN (Amazon Resource Name) of the rule group.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the rule group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the rule group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The number of rules in the rule group.</p>
        pub fn rule_count(mut self, input: i32) -> Self {
            self.rule_count = Some(input);
            self
        }
        /// <p>The number of rules in the rule group.</p>
        pub fn set_rule_count(mut self, input: std::option::Option<i32>) -> Self {
            self.rule_count = input;
            self
        }
        /// <p>The status of the domain list.  </p>
        pub fn status(mut self, input: crate::model::FirewallRuleGroupStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the domain list.  </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::FirewallRuleGroupStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Additional information about the status of the rule group, if available.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>Additional information about the status of the rule group, if available.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>The Amazon Web Services account ID for the account that created the rule group. When a rule group is shared with your account,
        /// this is the account that has shared the rule group with you.  </p>
        pub fn owner_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID for the account that created the rule group. When a rule group is shared with your account,
        /// this is the account that has shared the rule group with you.  </p>
        pub fn set_owner_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner_id = input;
            self
        }
        /// <p>A unique string defined by you to identify the request. This allows you to retry failed
        /// requests without the risk of running the operation twice. This can be any unique string,
        /// for example, a timestamp. </p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.creator_request_id = Some(input.into());
            self
        }
        /// <p>A unique string defined by you to identify the request. This allows you to retry failed
        /// requests without the risk of running the operation twice. This can be any unique string,
        /// for example, a timestamp. </p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creator_request_id = input;
            self
        }
        /// <p>Whether the rule group is shared with other Amazon Web Services accounts, or was shared with the current account by another
        /// Amazon Web Services account. Sharing is configured through Resource Access Manager (RAM).</p>
        pub fn share_status(mut self, input: crate::model::ShareStatus) -> Self {
            self.share_status = Some(input);
            self
        }
        /// <p>Whether the rule group is shared with other Amazon Web Services accounts, or was shared with the current account by another
        /// Amazon Web Services account. Sharing is configured through Resource Access Manager (RAM).</p>
        pub fn set_share_status(
            mut self,
            input: std::option::Option<crate::model::ShareStatus>,
        ) -> Self {
            self.share_status = input;
            self
        }
        /// <p>The date and time that the rule group was created, in Unix time format and Coordinated Universal Time (UTC). </p>
        pub fn creation_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_time = Some(input.into());
            self
        }
        /// <p>The date and time that the rule group was created, in Unix time format and Coordinated Universal Time (UTC). </p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The date and time that the rule group was last modified, in Unix time format and Coordinated Universal Time (UTC).</p>
        pub fn modification_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.modification_time = Some(input.into());
            self
        }
        /// <p>The date and time that the rule group was last modified, in Unix time format and Coordinated Universal Time (UTC).</p>
        pub fn set_modification_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.modification_time = input;
            self
        }
        /// Consumes the builder and constructs a [`FirewallRuleGroup`](crate::model::FirewallRuleGroup)
        pub fn build(self) -> crate::model::FirewallRuleGroup {
            crate::model::FirewallRuleGroup {
                id: self.id,
                arn: self.arn,
                name: self.name,
                rule_count: self.rule_count,
                status: self.status,
                status_message: self.status_message,
                owner_id: self.owner_id,
                creator_request_id: self.creator_request_id,
                share_status: self.share_status,
                creation_time: self.creation_time,
                modification_time: self.modification_time,
            }
        }
    }
}
impl FirewallRuleGroup {
    /// Creates a new builder-style object to manufacture [`FirewallRuleGroup`](crate::model::FirewallRuleGroup)
    pub fn builder() -> crate::model::firewall_rule_group::Builder {
        crate::model::firewall_rule_group::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FirewallRuleGroupStatus {
    #[allow(missing_docs)] // documentation missing in model
    Complete,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FirewallRuleGroupStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETE" => FirewallRuleGroupStatus::Complete,
            "DELETING" => FirewallRuleGroupStatus::Deleting,
            "UPDATING" => FirewallRuleGroupStatus::Updating,
            other => FirewallRuleGroupStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FirewallRuleGroupStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FirewallRuleGroupStatus::from(s))
    }
}
impl FirewallRuleGroupStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FirewallRuleGroupStatus::Complete => "COMPLETE",
            FirewallRuleGroupStatus::Deleting => "DELETING",
            FirewallRuleGroupStatus::Updating => "UPDATING",
            FirewallRuleGroupStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLETE", "DELETING", "UPDATING"]
    }
}
impl AsRef<str> for FirewallRuleGroupStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>High-level information about a list of firewall domains for use in a <a>FirewallRule</a>. This is returned by <a>GetFirewallDomainList</a>.</p>
/// <p>To retrieve the domains that are defined for this domain list, call <a>ListFirewallDomains</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FirewallDomainList {
    /// <p>The ID of the domain list. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the firewall domain list.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the domain list. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The number of domain names that are specified in the domain list.</p>
    pub domain_count: std::option::Option<i32>,
    /// <p>The status of the domain list.  </p>
    pub status: std::option::Option<crate::model::FirewallDomainListStatus>,
    /// <p>Additional information about the status of the list, if available.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>The owner of the list, used only for lists that are not managed by you. For example, the managed domain list <code>AWSManagedDomainsMalwareDomainList</code> has the managed owner name <code>Route 53 Resolver DNS Firewall</code>.</p>
    pub managed_owner_name: std::option::Option<std::string::String>,
    /// <p>A unique string defined by you to identify the request. This allows you to retry failed
    /// requests without the risk of running the operation twice. This can be any unique string,
    /// for example, a timestamp. </p>
    pub creator_request_id: std::option::Option<std::string::String>,
    /// <p>The date and time that the domain list was created, in Unix time format and Coordinated Universal Time (UTC). </p>
    pub creation_time: std::option::Option<std::string::String>,
    /// <p>The date and time that the domain list was last modified, in Unix time format and Coordinated Universal Time (UTC). </p>
    pub modification_time: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for FirewallDomainList {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FirewallDomainList");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("domain_count", &self.domain_count);
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.field("managed_owner_name", &self.managed_owner_name);
        formatter.field("creator_request_id", &self.creator_request_id);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("modification_time", &self.modification_time);
        formatter.finish()
    }
}
/// See [`FirewallDomainList`](crate::model::FirewallDomainList)
pub mod firewall_domain_list {
    /// A builder for [`FirewallDomainList`](crate::model::FirewallDomainList)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) domain_count: std::option::Option<i32>,
        pub(crate) status: std::option::Option<crate::model::FirewallDomainListStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) managed_owner_name: std::option::Option<std::string::String>,
        pub(crate) creator_request_id: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<std::string::String>,
        pub(crate) modification_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the domain list. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the domain list. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall domain list.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the firewall domain list.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the domain list. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the domain list. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The number of domain names that are specified in the domain list.</p>
        pub fn domain_count(mut self, input: i32) -> Self {
            self.domain_count = Some(input);
            self
        }
        /// <p>The number of domain names that are specified in the domain list.</p>
        pub fn set_domain_count(mut self, input: std::option::Option<i32>) -> Self {
            self.domain_count = input;
            self
        }
        /// <p>The status of the domain list.  </p>
        pub fn status(mut self, input: crate::model::FirewallDomainListStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the domain list.  </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::FirewallDomainListStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Additional information about the status of the list, if available.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>Additional information about the status of the list, if available.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>The owner of the list, used only for lists that are not managed by you. For example, the managed domain list <code>AWSManagedDomainsMalwareDomainList</code> has the managed owner name <code>Route 53 Resolver DNS Firewall</code>.</p>
        pub fn managed_owner_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.managed_owner_name = Some(input.into());
            self
        }
        /// <p>The owner of the list, used only for lists that are not managed by you. For example, the managed domain list <code>AWSManagedDomainsMalwareDomainList</code> has the managed owner name <code>Route 53 Resolver DNS Firewall</code>.</p>
        pub fn set_managed_owner_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.managed_owner_name = input;
            self
        }
        /// <p>A unique string defined by you to identify the request. This allows you to retry failed
        /// requests without the risk of running the operation twice. This can be any unique string,
        /// for example, a timestamp. </p>
        pub fn creator_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.creator_request_id = Some(input.into());
            self
        }
        /// <p>A unique string defined by you to identify the request. This allows you to retry failed
        /// requests without the risk of running the operation twice. This can be any unique string,
        /// for example, a timestamp. </p>
        pub fn set_creator_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creator_request_id = input;
            self
        }
        /// <p>The date and time that the domain list was created, in Unix time format and Coordinated Universal Time (UTC). </p>
        pub fn creation_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_time = Some(input.into());
            self
        }
        /// <p>The date and time that the domain list was created, in Unix time format and Coordinated Universal Time (UTC). </p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The date and time that the domain list was last modified, in Unix time format and Coordinated Universal Time (UTC). </p>
        pub fn modification_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.modification_time = Some(input.into());
            self
        }
        /// <p>The date and time that the domain list was last modified, in Unix time format and Coordinated Universal Time (UTC). </p>
        pub fn set_modification_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.modification_time = input;
            self
        }
        /// Consumes the builder and constructs a [`FirewallDomainList`](crate::model::FirewallDomainList)
        pub fn build(self) -> crate::model::FirewallDomainList {
            crate::model::FirewallDomainList {
                id: self.id,
                arn: self.arn,
                name: self.name,
                domain_count: self.domain_count,
                status: self.status,
                status_message: self.status_message,
                managed_owner_name: self.managed_owner_name,
                creator_request_id: self.creator_request_id,
                creation_time: self.creation_time,
                modification_time: self.modification_time,
            }
        }
    }
}
impl FirewallDomainList {
    /// Creates a new builder-style object to manufacture [`FirewallDomainList`](crate::model::FirewallDomainList)
    pub fn builder() -> crate::model::firewall_domain_list::Builder {
        crate::model::firewall_domain_list::Builder::default()
    }
}

/// <p>In an
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_UpdateResolverEndpoint.html">UpdateResolverEndpoint</a>
/// request, information about an IP address to update.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IpAddressUpdate {
    /// <p>
    /// <i>Only when removing an IP address from a Resolver endpoint</i>: The ID of the IP address that you want to remove.
    /// To get this ID, use
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html">GetResolverEndpoint</a>.</p>
    pub ip_id: std::option::Option<std::string::String>,
    /// <p>The ID of the subnet that includes the IP address that you want to update. To get this ID, use
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html">GetResolverEndpoint</a>.</p>
    pub subnet_id: std::option::Option<std::string::String>,
    /// <p>The new IP address.</p>
    pub ip: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IpAddressUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IpAddressUpdate");
        formatter.field("ip_id", &self.ip_id);
        formatter.field("subnet_id", &self.subnet_id);
        formatter.field("ip", &self.ip);
        formatter.finish()
    }
}
/// See [`IpAddressUpdate`](crate::model::IpAddressUpdate)
pub mod ip_address_update {
    /// A builder for [`IpAddressUpdate`](crate::model::IpAddressUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ip_id: std::option::Option<std::string::String>,
        pub(crate) subnet_id: std::option::Option<std::string::String>,
        pub(crate) ip: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// <i>Only when removing an IP address from a Resolver endpoint</i>: The ID of the IP address that you want to remove.
        /// To get this ID, use
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html">GetResolverEndpoint</a>.</p>
        pub fn ip_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_id = Some(input.into());
            self
        }
        /// <p>
        /// <i>Only when removing an IP address from a Resolver endpoint</i>: The ID of the IP address that you want to remove.
        /// To get this ID, use
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html">GetResolverEndpoint</a>.</p>
        pub fn set_ip_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_id = input;
            self
        }
        /// <p>The ID of the subnet that includes the IP address that you want to update. To get this ID, use
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html">GetResolverEndpoint</a>.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>The ID of the subnet that includes the IP address that you want to update. To get this ID, use
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html">GetResolverEndpoint</a>.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// <p>The new IP address.</p>
        pub fn ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip = Some(input.into());
            self
        }
        /// <p>The new IP address.</p>
        pub fn set_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip = input;
            self
        }
        /// Consumes the builder and constructs a [`IpAddressUpdate`](crate::model::IpAddressUpdate)
        pub fn build(self) -> crate::model::IpAddressUpdate {
            crate::model::IpAddressUpdate {
                ip_id: self.ip_id,
                subnet_id: self.subnet_id,
                ip: self.ip,
            }
        }
    }
}
impl IpAddressUpdate {
    /// Creates a new builder-style object to manufacture [`IpAddressUpdate`](crate::model::IpAddressUpdate)
    pub fn builder() -> crate::model::ip_address_update::Builder {
        crate::model::ip_address_update::Builder::default()
    }
}

/// <p>In a
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverEndpoint.html">CreateResolverEndpoint</a>
/// request, the IP address that DNS queries originate from (for outbound endpoints) or that you forward DNS queries to (for inbound endpoints).
/// <code>IpAddressRequest</code> also includes the ID of the subnet that contains the IP address.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IpAddressRequest {
    /// <p>The ID of the subnet that contains the IP address. </p>
    pub subnet_id: std::option::Option<std::string::String>,
    /// <p>The IP address that you want to use for DNS queries.</p>
    pub ip: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IpAddressRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IpAddressRequest");
        formatter.field("subnet_id", &self.subnet_id);
        formatter.field("ip", &self.ip);
        formatter.finish()
    }
}
/// See [`IpAddressRequest`](crate::model::IpAddressRequest)
pub mod ip_address_request {
    /// A builder for [`IpAddressRequest`](crate::model::IpAddressRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_id: std::option::Option<std::string::String>,
        pub(crate) ip: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the subnet that contains the IP address. </p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>The ID of the subnet that contains the IP address. </p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// <p>The IP address that you want to use for DNS queries.</p>
        pub fn ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip = Some(input.into());
            self
        }
        /// <p>The IP address that you want to use for DNS queries.</p>
        pub fn set_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip = input;
            self
        }
        /// Consumes the builder and constructs a [`IpAddressRequest`](crate::model::IpAddressRequest)
        pub fn build(self) -> crate::model::IpAddressRequest {
            crate::model::IpAddressRequest {
                subnet_id: self.subnet_id,
                ip: self.ip,
            }
        }
    }
}
impl IpAddressRequest {
    /// Creates a new builder-style object to manufacture [`IpAddressRequest`](crate::model::IpAddressRequest)
    pub fn builder() -> crate::model::ip_address_request::Builder {
        crate::model::ip_address_request::Builder::default()
    }
}
