// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>The current account doesn't have the IAM permissions required to perform the specified Resolver operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    ConflictException(crate::error::ConflictException),
    /// <p>We encountered an unknown error. Try again in a few minutes.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>The value that you specified for <code>NextToken</code> in a <code>List</code> request isn't valid.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>One or more parameters in this request are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified Resolver rule policy is invalid.</p>
    InvalidPolicyDocument(crate::error::InvalidPolicyDocument),
    /// <p>The request is invalid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified tag is invalid.</p>
    InvalidTagException(crate::error::InvalidTagException),
    /// <p>The request caused one or more limits to be exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource that you tried to create already exists.</p>
    ResourceExistsException(crate::error::ResourceExistsException),
    /// <p>The resource that you tried to update or delete is currently in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified resource doesn't exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The specified resource isn't available.</p>
    ResourceUnavailableException(crate::error::ResourceUnavailableException),
    /// <p>The request was throttled. Try again in a few minutes.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The specified resource doesn't exist.</p>
    UnknownResourceException(crate::error::UnknownResourceException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::AccessDeniedException(inner) => inner.fmt(f),
            Error::ConflictException(inner) => inner.fmt(f),
            Error::InternalServiceErrorException(inner) => inner.fmt(f),
            Error::InvalidNextTokenException(inner) => inner.fmt(f),
            Error::InvalidParameterException(inner) => inner.fmt(f),
            Error::InvalidPolicyDocument(inner) => inner.fmt(f),
            Error::InvalidRequestException(inner) => inner.fmt(f),
            Error::InvalidTagException(inner) => inner.fmt(f),
            Error::LimitExceededException(inner) => inner.fmt(f),
            Error::ResourceExistsException(inner) => inner.fmt(f),
            Error::ResourceInUseException(inner) => inner.fmt(f),
            Error::ResourceNotFoundException(inner) => inner.fmt(f),
            Error::ResourceUnavailableException(inner) => inner.fmt(f),
            Error::ThrottlingException(inner) => inner.fmt(f),
            Error::UnknownResourceException(inner) => inner.fmt(f),
            Error::ValidationException(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AssociateFirewallRuleGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AssociateFirewallRuleGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::AssociateFirewallRuleGroupErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::AssociateFirewallRuleGroupErrorKind::ConflictException(inner) => Error::ConflictException(inner),
                crate::error::AssociateFirewallRuleGroupErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::AssociateFirewallRuleGroupErrorKind::LimitExceededException(inner) => Error::LimitExceededException(inner),
                crate::error::AssociateFirewallRuleGroupErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::AssociateFirewallRuleGroupErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::AssociateFirewallRuleGroupErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::AssociateFirewallRuleGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<crate::error::AssociateResolverEndpointIpAddressError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::AssociateResolverEndpointIpAddressError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::AssociateResolverEndpointIpAddressErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::AssociateResolverEndpointIpAddressErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::AssociateResolverEndpointIpAddressErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::AssociateResolverEndpointIpAddressErrorKind::LimitExceededException(inner) => Error::LimitExceededException(inner),
                crate::error::AssociateResolverEndpointIpAddressErrorKind::ResourceExistsException(inner) => Error::ResourceExistsException(inner),
                crate::error::AssociateResolverEndpointIpAddressErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::AssociateResolverEndpointIpAddressErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::AssociateResolverEndpointIpAddressErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::AssociateResolverQueryLogConfigError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::AssociateResolverQueryLogConfigError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::AssociateResolverQueryLogConfigErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::AssociateResolverQueryLogConfigErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::AssociateResolverQueryLogConfigErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::AssociateResolverQueryLogConfigErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::AssociateResolverQueryLogConfigErrorKind::LimitExceededException(inner) => Error::LimitExceededException(inner),
                crate::error::AssociateResolverQueryLogConfigErrorKind::ResourceExistsException(inner) => Error::ResourceExistsException(inner),
                crate::error::AssociateResolverQueryLogConfigErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::AssociateResolverQueryLogConfigErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::AssociateResolverQueryLogConfigErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AssociateResolverRuleError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AssociateResolverRuleError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AssociateResolverRuleErrorKind::InternalServiceErrorException(
                    inner,
                ) => Error::InternalServiceErrorException(inner),
                crate::error::AssociateResolverRuleErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::AssociateResolverRuleErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::AssociateResolverRuleErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::AssociateResolverRuleErrorKind::ResourceExistsException(inner) => {
                    Error::ResourceExistsException(inner)
                }
                crate::error::AssociateResolverRuleErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::AssociateResolverRuleErrorKind::ResourceUnavailableException(
                    inner,
                ) => Error::ResourceUnavailableException(inner),
                crate::error::AssociateResolverRuleErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::AssociateResolverRuleErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateFirewallDomainListError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateFirewallDomainListError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateFirewallDomainListErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateFirewallDomainListErrorKind::InternalServiceErrorException(
                    inner,
                ) => Error::InternalServiceErrorException(inner),
                crate::error::CreateFirewallDomainListErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::CreateFirewallDomainListErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::CreateFirewallDomainListErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::CreateFirewallDomainListErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateFirewallRuleError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateFirewallRuleError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateFirewallRuleErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateFirewallRuleErrorKind::InternalServiceErrorException(inner) => {
                    Error::InternalServiceErrorException(inner)
                }
                crate::error::CreateFirewallRuleErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::CreateFirewallRuleErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::CreateFirewallRuleErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::CreateFirewallRuleErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::CreateFirewallRuleErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateFirewallRuleGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateFirewallRuleGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateFirewallRuleGroupErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateFirewallRuleGroupErrorKind::InternalServiceErrorException(
                    inner,
                ) => Error::InternalServiceErrorException(inner),
                crate::error::CreateFirewallRuleGroupErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::CreateFirewallRuleGroupErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::CreateFirewallRuleGroupErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::CreateFirewallRuleGroupErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateResolverEndpointError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateResolverEndpointError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateResolverEndpointErrorKind::InternalServiceErrorException(
                    inner,
                ) => Error::InternalServiceErrorException(inner),
                crate::error::CreateResolverEndpointErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::CreateResolverEndpointErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::CreateResolverEndpointErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::CreateResolverEndpointErrorKind::ResourceExistsException(inner) => {
                    Error::ResourceExistsException(inner)
                }
                crate::error::CreateResolverEndpointErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::CreateResolverEndpointErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::CreateResolverEndpointErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateResolverQueryLogConfigError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateResolverQueryLogConfigError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateResolverQueryLogConfigErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::CreateResolverQueryLogConfigErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::CreateResolverQueryLogConfigErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::CreateResolverQueryLogConfigErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::CreateResolverQueryLogConfigErrorKind::LimitExceededException(inner) => Error::LimitExceededException(inner),
                crate::error::CreateResolverQueryLogConfigErrorKind::ResourceExistsException(inner) => Error::ResourceExistsException(inner),
                crate::error::CreateResolverQueryLogConfigErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::CreateResolverQueryLogConfigErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::CreateResolverQueryLogConfigErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateResolverRuleError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateResolverRuleError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateResolverRuleErrorKind::InternalServiceErrorException(inner) => {
                    Error::InternalServiceErrorException(inner)
                }
                crate::error::CreateResolverRuleErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::CreateResolverRuleErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::CreateResolverRuleErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::CreateResolverRuleErrorKind::ResourceExistsException(inner) => {
                    Error::ResourceExistsException(inner)
                }
                crate::error::CreateResolverRuleErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::CreateResolverRuleErrorKind::ResourceUnavailableException(inner) => {
                    Error::ResourceUnavailableException(inner)
                }
                crate::error::CreateResolverRuleErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::CreateResolverRuleErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteFirewallDomainListError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteFirewallDomainListError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteFirewallDomainListErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteFirewallDomainListErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::DeleteFirewallDomainListErrorKind::InternalServiceErrorException(
                    inner,
                ) => Error::InternalServiceErrorException(inner),
                crate::error::DeleteFirewallDomainListErrorKind::ResourceNotFoundException(
                    inner,
                ) => Error::ResourceNotFoundException(inner),
                crate::error::DeleteFirewallDomainListErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DeleteFirewallDomainListErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteFirewallRuleError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteFirewallRuleError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteFirewallRuleErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteFirewallRuleErrorKind::InternalServiceErrorException(inner) => {
                    Error::InternalServiceErrorException(inner)
                }
                crate::error::DeleteFirewallRuleErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DeleteFirewallRuleErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DeleteFirewallRuleErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteFirewallRuleGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteFirewallRuleGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteFirewallRuleGroupErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteFirewallRuleGroupErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::DeleteFirewallRuleGroupErrorKind::InternalServiceErrorException(
                    inner,
                ) => Error::InternalServiceErrorException(inner),
                crate::error::DeleteFirewallRuleGroupErrorKind::ResourceNotFoundException(
                    inner,
                ) => Error::ResourceNotFoundException(inner),
                crate::error::DeleteFirewallRuleGroupErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DeleteFirewallRuleGroupErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::DeleteFirewallRuleGroupErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteResolverEndpointError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteResolverEndpointError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteResolverEndpointErrorKind::InternalServiceErrorException(
                    inner,
                ) => Error::InternalServiceErrorException(inner),
                crate::error::DeleteResolverEndpointErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DeleteResolverEndpointErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::DeleteResolverEndpointErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DeleteResolverEndpointErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DeleteResolverEndpointErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteResolverQueryLogConfigError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteResolverQueryLogConfigError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteResolverQueryLogConfigErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::DeleteResolverQueryLogConfigErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::DeleteResolverQueryLogConfigErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::DeleteResolverQueryLogConfigErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::DeleteResolverQueryLogConfigErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::DeleteResolverQueryLogConfigErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::DeleteResolverQueryLogConfigErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteResolverRuleError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteResolverRuleError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteResolverRuleErrorKind::InternalServiceErrorException(inner) => {
                    Error::InternalServiceErrorException(inner)
                }
                crate::error::DeleteResolverRuleErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DeleteResolverRuleErrorKind::ResourceInUseException(inner) => {
                    Error::ResourceInUseException(inner)
                }
                crate::error::DeleteResolverRuleErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DeleteResolverRuleErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DeleteResolverRuleErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DisassociateFirewallRuleGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DisassociateFirewallRuleGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DisassociateFirewallRuleGroupErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::DisassociateFirewallRuleGroupErrorKind::ConflictException(inner) => Error::ConflictException(inner),
                crate::error::DisassociateFirewallRuleGroupErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::DisassociateFirewallRuleGroupErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::DisassociateFirewallRuleGroupErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::DisassociateFirewallRuleGroupErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::DisassociateFirewallRuleGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DisassociateResolverEndpointIpAddressError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DisassociateResolverEndpointIpAddressError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DisassociateResolverEndpointIpAddressErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::DisassociateResolverEndpointIpAddressErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::DisassociateResolverEndpointIpAddressErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::DisassociateResolverEndpointIpAddressErrorKind::ResourceExistsException(inner) => Error::ResourceExistsException(inner),
                crate::error::DisassociateResolverEndpointIpAddressErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::DisassociateResolverEndpointIpAddressErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::DisassociateResolverEndpointIpAddressErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<crate::error::DisassociateResolverQueryLogConfigError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DisassociateResolverQueryLogConfigError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DisassociateResolverQueryLogConfigErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::DisassociateResolverQueryLogConfigErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::DisassociateResolverQueryLogConfigErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::DisassociateResolverQueryLogConfigErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::DisassociateResolverQueryLogConfigErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::DisassociateResolverQueryLogConfigErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::DisassociateResolverQueryLogConfigErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DisassociateResolverRuleError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DisassociateResolverRuleError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DisassociateResolverRuleErrorKind::InternalServiceErrorException(
                    inner,
                ) => Error::InternalServiceErrorException(inner),
                crate::error::DisassociateResolverRuleErrorKind::InvalidParameterException(
                    inner,
                ) => Error::InvalidParameterException(inner),
                crate::error::DisassociateResolverRuleErrorKind::ResourceNotFoundException(
                    inner,
                ) => Error::ResourceNotFoundException(inner),
                crate::error::DisassociateResolverRuleErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DisassociateResolverRuleErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetFirewallConfigError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetFirewallConfigError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetFirewallConfigErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetFirewallConfigErrorKind::InternalServiceErrorException(inner) => {
                    Error::InternalServiceErrorException(inner)
                }
                crate::error::GetFirewallConfigErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::GetFirewallConfigErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::GetFirewallConfigErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::GetFirewallConfigErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetFirewallDomainListError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetFirewallDomainListError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetFirewallDomainListErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetFirewallDomainListErrorKind::InternalServiceErrorException(
                    inner,
                ) => Error::InternalServiceErrorException(inner),
                crate::error::GetFirewallDomainListErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::GetFirewallDomainListErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::GetFirewallDomainListErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetFirewallRuleGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetFirewallRuleGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetFirewallRuleGroupErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetFirewallRuleGroupErrorKind::InternalServiceErrorException(
                    inner,
                ) => Error::InternalServiceErrorException(inner),
                crate::error::GetFirewallRuleGroupErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::GetFirewallRuleGroupErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::GetFirewallRuleGroupErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::GetFirewallRuleGroupAssociationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetFirewallRuleGroupAssociationError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetFirewallRuleGroupAssociationErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::GetFirewallRuleGroupAssociationErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::GetFirewallRuleGroupAssociationErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::GetFirewallRuleGroupAssociationErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::GetFirewallRuleGroupAssociationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetFirewallRuleGroupPolicyError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetFirewallRuleGroupPolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetFirewallRuleGroupPolicyErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::GetFirewallRuleGroupPolicyErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::GetFirewallRuleGroupPolicyErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::GetFirewallRuleGroupPolicyErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::GetFirewallRuleGroupPolicyErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::GetFirewallRuleGroupPolicyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetResolverDnssecConfigError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetResolverDnssecConfigError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetResolverDnssecConfigErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetResolverDnssecConfigErrorKind::InternalServiceErrorException(
                    inner,
                ) => Error::InternalServiceErrorException(inner),
                crate::error::GetResolverDnssecConfigErrorKind::InvalidParameterException(
                    inner,
                ) => Error::InvalidParameterException(inner),
                crate::error::GetResolverDnssecConfigErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::GetResolverDnssecConfigErrorKind::ResourceNotFoundException(
                    inner,
                ) => Error::ResourceNotFoundException(inner),
                crate::error::GetResolverDnssecConfigErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::GetResolverDnssecConfigErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetResolverEndpointError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetResolverEndpointError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetResolverEndpointErrorKind::InternalServiceErrorException(
                    inner,
                ) => Error::InternalServiceErrorException(inner),
                crate::error::GetResolverEndpointErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::GetResolverEndpointErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::GetResolverEndpointErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::GetResolverEndpointErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetResolverQueryLogConfigError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetResolverQueryLogConfigError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetResolverQueryLogConfigErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetResolverQueryLogConfigErrorKind::InternalServiceErrorException(
                    inner,
                ) => Error::InternalServiceErrorException(inner),
                crate::error::GetResolverQueryLogConfigErrorKind::InvalidParameterException(
                    inner,
                ) => Error::InvalidParameterException(inner),
                crate::error::GetResolverQueryLogConfigErrorKind::InvalidRequestException(
                    inner,
                ) => Error::InvalidRequestException(inner),
                crate::error::GetResolverQueryLogConfigErrorKind::ResourceNotFoundException(
                    inner,
                ) => Error::ResourceNotFoundException(inner),
                crate::error::GetResolverQueryLogConfigErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::GetResolverQueryLogConfigErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::GetResolverQueryLogConfigAssociationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetResolverQueryLogConfigAssociationError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetResolverQueryLogConfigAssociationErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::GetResolverQueryLogConfigAssociationErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::GetResolverQueryLogConfigAssociationErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::GetResolverQueryLogConfigAssociationErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::GetResolverQueryLogConfigAssociationErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::GetResolverQueryLogConfigAssociationErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::GetResolverQueryLogConfigAssociationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::GetResolverQueryLogConfigPolicyError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetResolverQueryLogConfigPolicyError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetResolverQueryLogConfigPolicyErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::GetResolverQueryLogConfigPolicyErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::GetResolverQueryLogConfigPolicyErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::GetResolverQueryLogConfigPolicyErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::GetResolverQueryLogConfigPolicyErrorKind::UnknownResourceException(inner) => Error::UnknownResourceException(inner),
                crate::error::GetResolverQueryLogConfigPolicyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetResolverRuleError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetResolverRuleError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetResolverRuleErrorKind::InternalServiceErrorException(inner) => {
                    Error::InternalServiceErrorException(inner)
                }
                crate::error::GetResolverRuleErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::GetResolverRuleErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::GetResolverRuleErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::GetResolverRuleErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetResolverRuleAssociationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetResolverRuleAssociationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetResolverRuleAssociationErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::GetResolverRuleAssociationErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::GetResolverRuleAssociationErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::GetResolverRuleAssociationErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::GetResolverRuleAssociationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetResolverRulePolicyError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetResolverRulePolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetResolverRulePolicyErrorKind::InternalServiceErrorException(
                    inner,
                ) => Error::InternalServiceErrorException(inner),
                crate::error::GetResolverRulePolicyErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::GetResolverRulePolicyErrorKind::UnknownResourceException(inner) => {
                    Error::UnknownResourceException(inner)
                }
                crate::error::GetResolverRulePolicyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ImportFirewallDomainsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ImportFirewallDomainsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ImportFirewallDomainsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ImportFirewallDomainsErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::ImportFirewallDomainsErrorKind::InternalServiceErrorException(
                    inner,
                ) => Error::InternalServiceErrorException(inner),
                crate::error::ImportFirewallDomainsErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::ImportFirewallDomainsErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ImportFirewallDomainsErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::ImportFirewallDomainsErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::ImportFirewallDomainsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListFirewallConfigsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListFirewallConfigsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListFirewallConfigsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListFirewallConfigsErrorKind::InternalServiceErrorException(
                    inner,
                ) => Error::InternalServiceErrorException(inner),
                crate::error::ListFirewallConfigsErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::ListFirewallConfigsErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::ListFirewallConfigsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListFirewallDomainListsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListFirewallDomainListsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListFirewallDomainListsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListFirewallDomainListsErrorKind::InternalServiceErrorException(
                    inner,
                ) => Error::InternalServiceErrorException(inner),
                crate::error::ListFirewallDomainListsErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::ListFirewallDomainListsErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::ListFirewallDomainListsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListFirewallDomainsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListFirewallDomainsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListFirewallDomainsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListFirewallDomainsErrorKind::InternalServiceErrorException(
                    inner,
                ) => Error::InternalServiceErrorException(inner),
                crate::error::ListFirewallDomainsErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ListFirewallDomainsErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::ListFirewallDomainsErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::ListFirewallDomainsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::ListFirewallRuleGroupAssociationsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ListFirewallRuleGroupAssociationsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListFirewallRuleGroupAssociationsErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::ListFirewallRuleGroupAssociationsErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::ListFirewallRuleGroupAssociationsErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::ListFirewallRuleGroupAssociationsErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::ListFirewallRuleGroupAssociationsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListFirewallRuleGroupsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListFirewallRuleGroupsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListFirewallRuleGroupsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListFirewallRuleGroupsErrorKind::InternalServiceErrorException(
                    inner,
                ) => Error::InternalServiceErrorException(inner),
                crate::error::ListFirewallRuleGroupsErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::ListFirewallRuleGroupsErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::ListFirewallRuleGroupsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListFirewallRulesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListFirewallRulesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListFirewallRulesErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListFirewallRulesErrorKind::InternalServiceErrorException(inner) => {
                    Error::InternalServiceErrorException(inner)
                }
                crate::error::ListFirewallRulesErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ListFirewallRulesErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::ListFirewallRulesErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::ListFirewallRulesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListResolverDnssecConfigsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListResolverDnssecConfigsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListResolverDnssecConfigsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListResolverDnssecConfigsErrorKind::InternalServiceErrorException(
                    inner,
                ) => Error::InternalServiceErrorException(inner),
                crate::error::ListResolverDnssecConfigsErrorKind::InvalidNextTokenException(
                    inner,
                ) => Error::InvalidNextTokenException(inner),
                crate::error::ListResolverDnssecConfigsErrorKind::InvalidParameterException(
                    inner,
                ) => Error::InvalidParameterException(inner),
                crate::error::ListResolverDnssecConfigsErrorKind::InvalidRequestException(
                    inner,
                ) => Error::InvalidRequestException(inner),
                crate::error::ListResolverDnssecConfigsErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::ListResolverDnssecConfigsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::ListResolverEndpointIpAddressesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ListResolverEndpointIpAddressesError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListResolverEndpointIpAddressesErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::ListResolverEndpointIpAddressesErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::ListResolverEndpointIpAddressesErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::ListResolverEndpointIpAddressesErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::ListResolverEndpointIpAddressesErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::ListResolverEndpointIpAddressesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListResolverEndpointsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListResolverEndpointsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListResolverEndpointsErrorKind::InternalServiceErrorException(
                    inner,
                ) => Error::InternalServiceErrorException(inner),
                crate::error::ListResolverEndpointsErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListResolverEndpointsErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ListResolverEndpointsErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::ListResolverEndpointsErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::ListResolverEndpointsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::ListResolverQueryLogConfigAssociationsError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ListResolverQueryLogConfigAssociationsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListResolverQueryLogConfigAssociationsErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::ListResolverQueryLogConfigAssociationsErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::ListResolverQueryLogConfigAssociationsErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::ListResolverQueryLogConfigAssociationsErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::ListResolverQueryLogConfigAssociationsErrorKind::LimitExceededException(inner) => Error::LimitExceededException(inner),
                crate::error::ListResolverQueryLogConfigAssociationsErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::ListResolverQueryLogConfigAssociationsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListResolverQueryLogConfigsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListResolverQueryLogConfigsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListResolverQueryLogConfigsErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::ListResolverQueryLogConfigsErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::ListResolverQueryLogConfigsErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::ListResolverQueryLogConfigsErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::ListResolverQueryLogConfigsErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::ListResolverQueryLogConfigsErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::ListResolverQueryLogConfigsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListResolverRuleAssociationsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListResolverRuleAssociationsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListResolverRuleAssociationsErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::ListResolverRuleAssociationsErrorKind::InvalidNextTokenException(inner) => Error::InvalidNextTokenException(inner),
                crate::error::ListResolverRuleAssociationsErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::ListResolverRuleAssociationsErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::ListResolverRuleAssociationsErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::ListResolverRuleAssociationsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListResolverRulesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListResolverRulesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListResolverRulesErrorKind::InternalServiceErrorException(inner) => {
                    Error::InternalServiceErrorException(inner)
                }
                crate::error::ListResolverRulesErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListResolverRulesErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ListResolverRulesErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::ListResolverRulesErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::ListResolverRulesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTagsForResourceErrorKind::InternalServiceErrorException(
                    inner,
                ) => Error::InternalServiceErrorException(inner),
                crate::error::ListTagsForResourceErrorKind::InvalidNextTokenException(inner) => {
                    Error::InvalidNextTokenException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutFirewallRuleGroupPolicyError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutFirewallRuleGroupPolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::PutFirewallRuleGroupPolicyErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::PutFirewallRuleGroupPolicyErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::PutFirewallRuleGroupPolicyErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::PutFirewallRuleGroupPolicyErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::PutFirewallRuleGroupPolicyErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::PutFirewallRuleGroupPolicyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::PutResolverQueryLogConfigPolicyError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::PutResolverQueryLogConfigPolicyError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::PutResolverQueryLogConfigPolicyErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::PutResolverQueryLogConfigPolicyErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::PutResolverQueryLogConfigPolicyErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::PutResolverQueryLogConfigPolicyErrorKind::InvalidPolicyDocument(inner) => Error::InvalidPolicyDocument(inner),
                crate::error::PutResolverQueryLogConfigPolicyErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::PutResolverQueryLogConfigPolicyErrorKind::UnknownResourceException(inner) => Error::UnknownResourceException(inner),
                crate::error::PutResolverQueryLogConfigPolicyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutResolverRulePolicyError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutResolverRulePolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutResolverRulePolicyErrorKind::InternalServiceErrorException(
                    inner,
                ) => Error::InternalServiceErrorException(inner),
                crate::error::PutResolverRulePolicyErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::PutResolverRulePolicyErrorKind::InvalidPolicyDocument(inner) => {
                    Error::InvalidPolicyDocument(inner)
                }
                crate::error::PutResolverRulePolicyErrorKind::UnknownResourceException(inner) => {
                    Error::UnknownResourceException(inner)
                }
                crate::error::PutResolverRulePolicyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::TagResourceErrorKind::InternalServiceErrorException(inner) => {
                    Error::InternalServiceErrorException(inner)
                }
                crate::error::TagResourceErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::TagResourceErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::TagResourceErrorKind::InvalidTagException(inner) => {
                    Error::InvalidTagException(inner)
                }
                crate::error::TagResourceErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::TagResourceErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::TagResourceErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::TagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UntagResourceErrorKind::InternalServiceErrorException(inner) => {
                    Error::InternalServiceErrorException(inner)
                }
                crate::error::UntagResourceErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::UntagResourceErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::UntagResourceErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::UntagResourceErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::UntagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateFirewallConfigError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateFirewallConfigError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateFirewallConfigErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::UpdateFirewallConfigErrorKind::InternalServiceErrorException(
                    inner,
                ) => Error::InternalServiceErrorException(inner),
                crate::error::UpdateFirewallConfigErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::UpdateFirewallConfigErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::UpdateFirewallConfigErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::UpdateFirewallConfigErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateFirewallDomainsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateFirewallDomainsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateFirewallDomainsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::UpdateFirewallDomainsErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::UpdateFirewallDomainsErrorKind::InternalServiceErrorException(
                    inner,
                ) => Error::InternalServiceErrorException(inner),
                crate::error::UpdateFirewallDomainsErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::UpdateFirewallDomainsErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::UpdateFirewallDomainsErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::UpdateFirewallDomainsErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::UpdateFirewallDomainsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateFirewallRuleError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateFirewallRuleError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateFirewallRuleErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::UpdateFirewallRuleErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::UpdateFirewallRuleErrorKind::InternalServiceErrorException(inner) => {
                    Error::InternalServiceErrorException(inner)
                }
                crate::error::UpdateFirewallRuleErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::UpdateFirewallRuleErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::UpdateFirewallRuleErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::UpdateFirewallRuleErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<crate::error::UpdateFirewallRuleGroupAssociationError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::UpdateFirewallRuleGroupAssociationError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateFirewallRuleGroupAssociationErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::UpdateFirewallRuleGroupAssociationErrorKind::ConflictException(inner) => Error::ConflictException(inner),
                crate::error::UpdateFirewallRuleGroupAssociationErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::UpdateFirewallRuleGroupAssociationErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::UpdateFirewallRuleGroupAssociationErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::UpdateFirewallRuleGroupAssociationErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::UpdateFirewallRuleGroupAssociationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateResolverDnssecConfigError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateResolverDnssecConfigError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateResolverDnssecConfigErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::UpdateResolverDnssecConfigErrorKind::InternalServiceErrorException(inner) => Error::InternalServiceErrorException(inner),
                crate::error::UpdateResolverDnssecConfigErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::UpdateResolverDnssecConfigErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::UpdateResolverDnssecConfigErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::UpdateResolverDnssecConfigErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::UpdateResolverDnssecConfigErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateResolverEndpointError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateResolverEndpointError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateResolverEndpointErrorKind::InternalServiceErrorException(
                    inner,
                ) => Error::InternalServiceErrorException(inner),
                crate::error::UpdateResolverEndpointErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::UpdateResolverEndpointErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::UpdateResolverEndpointErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::UpdateResolverEndpointErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::UpdateResolverEndpointErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateResolverRuleError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateResolverRuleError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateResolverRuleErrorKind::InternalServiceErrorException(inner) => {
                    Error::InternalServiceErrorException(inner)
                }
                crate::error::UpdateResolverRuleErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::UpdateResolverRuleErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::UpdateResolverRuleErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::UpdateResolverRuleErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::UpdateResolverRuleErrorKind::ResourceUnavailableException(inner) => {
                    Error::ResourceUnavailableException(inner)
                }
                crate::error::UpdateResolverRuleErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::UpdateResolverRuleErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
