// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateResourceSetOutput {
    /// <p>The Amazon Resource Name (ARN) for the resource set.</p>
    pub resource_set_arn: std::option::Option<std::string::String>,
    /// <p>The name of the resource set.</p>
    pub resource_set_name: std::option::Option<std::string::String>,
    /// <p>The resource type of the resources in the resource set. Enter one of the following values for resource type:</p>
    /// <p>AWS::ApiGateway::Stage, AWS::ApiGatewayV2::Stage, AWS::AutoScaling::AutoScalingGroup, AWS::CloudWatch::Alarm, AWS::EC2::CustomerGateway, AWS::DynamoDB::Table, AWS::EC2::Volume, AWS::ElasticLoadBalancing::LoadBalancer, AWS::ElasticLoadBalancingV2::LoadBalancer, AWS::Lambda::Function, AWS::MSK::Cluster, AWS::RDS::DBCluster, AWS::Route53::HealthCheck, AWS::SQS::Queue, AWS::SNS::Topic, AWS::SNS::Subscription, AWS::EC2::VPC, AWS::EC2::VPNConnection, AWS::EC2::VPNGateway, AWS::Route53RecoveryReadiness::DNSTargetResource</p>
    pub resource_set_type: std::option::Option<std::string::String>,
    /// <p>A list of resource objects.</p>
    pub resources: std::option::Option<std::vec::Vec<crate::model::Resource>>,
    /// <p>A collection of tags associated with a resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl UpdateResourceSetOutput {
    /// <p>The Amazon Resource Name (ARN) for the resource set.</p>
    pub fn resource_set_arn(&self) -> std::option::Option<&str> {
        self.resource_set_arn.as_deref()
    }
    /// <p>The name of the resource set.</p>
    pub fn resource_set_name(&self) -> std::option::Option<&str> {
        self.resource_set_name.as_deref()
    }
    /// <p>The resource type of the resources in the resource set. Enter one of the following values for resource type:</p>
    /// <p>AWS::ApiGateway::Stage, AWS::ApiGatewayV2::Stage, AWS::AutoScaling::AutoScalingGroup, AWS::CloudWatch::Alarm, AWS::EC2::CustomerGateway, AWS::DynamoDB::Table, AWS::EC2::Volume, AWS::ElasticLoadBalancing::LoadBalancer, AWS::ElasticLoadBalancingV2::LoadBalancer, AWS::Lambda::Function, AWS::MSK::Cluster, AWS::RDS::DBCluster, AWS::Route53::HealthCheck, AWS::SQS::Queue, AWS::SNS::Topic, AWS::SNS::Subscription, AWS::EC2::VPC, AWS::EC2::VPNConnection, AWS::EC2::VPNGateway, AWS::Route53RecoveryReadiness::DNSTargetResource</p>
    pub fn resource_set_type(&self) -> std::option::Option<&str> {
        self.resource_set_type.as_deref()
    }
    /// <p>A list of resource objects.</p>
    pub fn resources(&self) -> std::option::Option<&[crate::model::Resource]> {
        self.resources.as_deref()
    }
    /// <p>A collection of tags associated with a resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for UpdateResourceSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateResourceSetOutput");
        formatter.field("resource_set_arn", &self.resource_set_arn);
        formatter.field("resource_set_name", &self.resource_set_name);
        formatter.field("resource_set_type", &self.resource_set_type);
        formatter.field("resources", &self.resources);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`UpdateResourceSetOutput`](crate::output::UpdateResourceSetOutput)
pub mod update_resource_set_output {
    /// A builder for [`UpdateResourceSetOutput`](crate::output::UpdateResourceSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_set_arn: std::option::Option<std::string::String>,
        pub(crate) resource_set_name: std::option::Option<std::string::String>,
        pub(crate) resource_set_type: std::option::Option<std::string::String>,
        pub(crate) resources: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the resource set.</p>
        pub fn resource_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_set_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the resource set.</p>
        pub fn set_resource_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_set_arn = input;
            self
        }
        /// <p>The name of the resource set.</p>
        pub fn resource_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_set_name = Some(input.into());
            self
        }
        /// <p>The name of the resource set.</p>
        pub fn set_resource_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_set_name = input;
            self
        }
        /// <p>The resource type of the resources in the resource set. Enter one of the following values for resource type:</p>
        /// <p>AWS::ApiGateway::Stage, AWS::ApiGatewayV2::Stage, AWS::AutoScaling::AutoScalingGroup, AWS::CloudWatch::Alarm, AWS::EC2::CustomerGateway, AWS::DynamoDB::Table, AWS::EC2::Volume, AWS::ElasticLoadBalancing::LoadBalancer, AWS::ElasticLoadBalancingV2::LoadBalancer, AWS::Lambda::Function, AWS::MSK::Cluster, AWS::RDS::DBCluster, AWS::Route53::HealthCheck, AWS::SQS::Queue, AWS::SNS::Topic, AWS::SNS::Subscription, AWS::EC2::VPC, AWS::EC2::VPNConnection, AWS::EC2::VPNGateway, AWS::Route53RecoveryReadiness::DNSTargetResource</p>
        pub fn resource_set_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_set_type = Some(input.into());
            self
        }
        /// <p>The resource type of the resources in the resource set. Enter one of the following values for resource type:</p>
        /// <p>AWS::ApiGateway::Stage, AWS::ApiGatewayV2::Stage, AWS::AutoScaling::AutoScalingGroup, AWS::CloudWatch::Alarm, AWS::EC2::CustomerGateway, AWS::DynamoDB::Table, AWS::EC2::Volume, AWS::ElasticLoadBalancing::LoadBalancer, AWS::ElasticLoadBalancingV2::LoadBalancer, AWS::Lambda::Function, AWS::MSK::Cluster, AWS::RDS::DBCluster, AWS::Route53::HealthCheck, AWS::SQS::Queue, AWS::SNS::Topic, AWS::SNS::Subscription, AWS::EC2::VPC, AWS::EC2::VPNConnection, AWS::EC2::VPNGateway, AWS::Route53RecoveryReadiness::DNSTargetResource</p>
        pub fn set_resource_set_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_set_type = input;
            self
        }
        /// Appends an item to `resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// <p>A list of resource objects.</p>
        pub fn resources(mut self, input: crate::model::Resource) -> Self {
            let mut v = self.resources.unwrap_or_default();
            v.push(input);
            self.resources = Some(v);
            self
        }
        /// <p>A list of resource objects.</p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of tags associated with a resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A collection of tags associated with a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateResourceSetOutput`](crate::output::UpdateResourceSetOutput)
        pub fn build(self) -> crate::output::UpdateResourceSetOutput {
            crate::output::UpdateResourceSetOutput {
                resource_set_arn: self.resource_set_arn,
                resource_set_name: self.resource_set_name,
                resource_set_type: self.resource_set_type,
                resources: self.resources,
                tags: self.tags,
            }
        }
    }
}
impl UpdateResourceSetOutput {
    /// Creates a new builder-style object to manufacture [`UpdateResourceSetOutput`](crate::output::UpdateResourceSetOutput)
    pub fn builder() -> crate::output::update_resource_set_output::Builder {
        crate::output::update_resource_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRecoveryGroupOutput {
    /// <p>A list of a cell's Amazon Resource Names (ARNs).</p>
    pub cells: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) for the recovery group.</p>
    pub recovery_group_arn: std::option::Option<std::string::String>,
    /// <p>The name of the recovery group.</p>
    pub recovery_group_name: std::option::Option<std::string::String>,
    /// <p>The tags associated with the recovery group.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl UpdateRecoveryGroupOutput {
    /// <p>A list of a cell's Amazon Resource Names (ARNs).</p>
    pub fn cells(&self) -> std::option::Option<&[std::string::String]> {
        self.cells.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the recovery group.</p>
    pub fn recovery_group_arn(&self) -> std::option::Option<&str> {
        self.recovery_group_arn.as_deref()
    }
    /// <p>The name of the recovery group.</p>
    pub fn recovery_group_name(&self) -> std::option::Option<&str> {
        self.recovery_group_name.as_deref()
    }
    /// <p>The tags associated with the recovery group.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for UpdateRecoveryGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRecoveryGroupOutput");
        formatter.field("cells", &self.cells);
        formatter.field("recovery_group_arn", &self.recovery_group_arn);
        formatter.field("recovery_group_name", &self.recovery_group_name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`UpdateRecoveryGroupOutput`](crate::output::UpdateRecoveryGroupOutput)
pub mod update_recovery_group_output {
    /// A builder for [`UpdateRecoveryGroupOutput`](crate::output::UpdateRecoveryGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cells: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) recovery_group_arn: std::option::Option<std::string::String>,
        pub(crate) recovery_group_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Appends an item to `cells`.
        ///
        /// To override the contents of this collection use [`set_cells`](Self::set_cells).
        ///
        /// <p>A list of a cell's Amazon Resource Names (ARNs).</p>
        pub fn cells(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cells.unwrap_or_default();
            v.push(input.into());
            self.cells = Some(v);
            self
        }
        /// <p>A list of a cell's Amazon Resource Names (ARNs).</p>
        pub fn set_cells(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cells = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the recovery group.</p>
        pub fn recovery_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the recovery group.</p>
        pub fn set_recovery_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_group_arn = input;
            self
        }
        /// <p>The name of the recovery group.</p>
        pub fn recovery_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_group_name = Some(input.into());
            self
        }
        /// <p>The name of the recovery group.</p>
        pub fn set_recovery_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_group_name = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the recovery group.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags associated with the recovery group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRecoveryGroupOutput`](crate::output::UpdateRecoveryGroupOutput)
        pub fn build(self) -> crate::output::UpdateRecoveryGroupOutput {
            crate::output::UpdateRecoveryGroupOutput {
                cells: self.cells,
                recovery_group_arn: self.recovery_group_arn,
                recovery_group_name: self.recovery_group_name,
                tags: self.tags,
            }
        }
    }
}
impl UpdateRecoveryGroupOutput {
    /// Creates a new builder-style object to manufacture [`UpdateRecoveryGroupOutput`](crate::output::UpdateRecoveryGroupOutput)
    pub fn builder() -> crate::output::update_recovery_group_output::Builder {
        crate::output::update_recovery_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateReadinessCheckOutput {
    /// <p>The Amazon Resource Name (ARN) associated with a readiness check.</p>
    pub readiness_check_arn: std::option::Option<std::string::String>,
    /// <p>Name of a readiness check.</p>
    pub readiness_check_name: std::option::Option<std::string::String>,
    /// <p>Name of the resource set to be checked.</p>
    pub resource_set: std::option::Option<std::string::String>,
    /// <p>A collection of tags associated with a resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl UpdateReadinessCheckOutput {
    /// <p>The Amazon Resource Name (ARN) associated with a readiness check.</p>
    pub fn readiness_check_arn(&self) -> std::option::Option<&str> {
        self.readiness_check_arn.as_deref()
    }
    /// <p>Name of a readiness check.</p>
    pub fn readiness_check_name(&self) -> std::option::Option<&str> {
        self.readiness_check_name.as_deref()
    }
    /// <p>Name of the resource set to be checked.</p>
    pub fn resource_set(&self) -> std::option::Option<&str> {
        self.resource_set.as_deref()
    }
    /// <p>A collection of tags associated with a resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for UpdateReadinessCheckOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateReadinessCheckOutput");
        formatter.field("readiness_check_arn", &self.readiness_check_arn);
        formatter.field("readiness_check_name", &self.readiness_check_name);
        formatter.field("resource_set", &self.resource_set);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`UpdateReadinessCheckOutput`](crate::output::UpdateReadinessCheckOutput)
pub mod update_readiness_check_output {
    /// A builder for [`UpdateReadinessCheckOutput`](crate::output::UpdateReadinessCheckOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) readiness_check_arn: std::option::Option<std::string::String>,
        pub(crate) readiness_check_name: std::option::Option<std::string::String>,
        pub(crate) resource_set: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) associated with a readiness check.</p>
        pub fn readiness_check_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.readiness_check_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) associated with a readiness check.</p>
        pub fn set_readiness_check_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.readiness_check_arn = input;
            self
        }
        /// <p>Name of a readiness check.</p>
        pub fn readiness_check_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.readiness_check_name = Some(input.into());
            self
        }
        /// <p>Name of a readiness check.</p>
        pub fn set_readiness_check_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.readiness_check_name = input;
            self
        }
        /// <p>Name of the resource set to be checked.</p>
        pub fn resource_set(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_set = Some(input.into());
            self
        }
        /// <p>Name of the resource set to be checked.</p>
        pub fn set_resource_set(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_set = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of tags associated with a resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A collection of tags associated with a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateReadinessCheckOutput`](crate::output::UpdateReadinessCheckOutput)
        pub fn build(self) -> crate::output::UpdateReadinessCheckOutput {
            crate::output::UpdateReadinessCheckOutput {
                readiness_check_arn: self.readiness_check_arn,
                readiness_check_name: self.readiness_check_name,
                resource_set: self.resource_set,
                tags: self.tags,
            }
        }
    }
}
impl UpdateReadinessCheckOutput {
    /// Creates a new builder-style object to manufacture [`UpdateReadinessCheckOutput`](crate::output::UpdateReadinessCheckOutput)
    pub fn builder() -> crate::output::update_readiness_check_output::Builder {
        crate::output::update_readiness_check_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateCellOutput {
    /// <p>The Amazon Resource Name (ARN) for the cell.</p>
    pub cell_arn: std::option::Option<std::string::String>,
    /// <p>The name of the cell.</p>
    pub cell_name: std::option::Option<std::string::String>,
    /// <p>A list of cell ARNs.</p>
    pub cells: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The readiness scope for the cell, which can be a cell Amazon Resource Name (ARN) or a recovery group ARN. This is a list but currently can have only one element.</p>
    pub parent_readiness_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Tags on the resources.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl UpdateCellOutput {
    /// <p>The Amazon Resource Name (ARN) for the cell.</p>
    pub fn cell_arn(&self) -> std::option::Option<&str> {
        self.cell_arn.as_deref()
    }
    /// <p>The name of the cell.</p>
    pub fn cell_name(&self) -> std::option::Option<&str> {
        self.cell_name.as_deref()
    }
    /// <p>A list of cell ARNs.</p>
    pub fn cells(&self) -> std::option::Option<&[std::string::String]> {
        self.cells.as_deref()
    }
    /// <p>The readiness scope for the cell, which can be a cell Amazon Resource Name (ARN) or a recovery group ARN. This is a list but currently can have only one element.</p>
    pub fn parent_readiness_scopes(&self) -> std::option::Option<&[std::string::String]> {
        self.parent_readiness_scopes.as_deref()
    }
    /// <p>Tags on the resources.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for UpdateCellOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCellOutput");
        formatter.field("cell_arn", &self.cell_arn);
        formatter.field("cell_name", &self.cell_name);
        formatter.field("cells", &self.cells);
        formatter.field("parent_readiness_scopes", &self.parent_readiness_scopes);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`UpdateCellOutput`](crate::output::UpdateCellOutput)
pub mod update_cell_output {
    /// A builder for [`UpdateCellOutput`](crate::output::UpdateCellOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cell_arn: std::option::Option<std::string::String>,
        pub(crate) cell_name: std::option::Option<std::string::String>,
        pub(crate) cells: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) parent_readiness_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the cell.</p>
        pub fn cell_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cell_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the cell.</p>
        pub fn set_cell_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cell_arn = input;
            self
        }
        /// <p>The name of the cell.</p>
        pub fn cell_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cell_name = Some(input.into());
            self
        }
        /// <p>The name of the cell.</p>
        pub fn set_cell_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cell_name = input;
            self
        }
        /// Appends an item to `cells`.
        ///
        /// To override the contents of this collection use [`set_cells`](Self::set_cells).
        ///
        /// <p>A list of cell ARNs.</p>
        pub fn cells(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cells.unwrap_or_default();
            v.push(input.into());
            self.cells = Some(v);
            self
        }
        /// <p>A list of cell ARNs.</p>
        pub fn set_cells(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cells = input;
            self
        }
        /// Appends an item to `parent_readiness_scopes`.
        ///
        /// To override the contents of this collection use [`set_parent_readiness_scopes`](Self::set_parent_readiness_scopes).
        ///
        /// <p>The readiness scope for the cell, which can be a cell Amazon Resource Name (ARN) or a recovery group ARN. This is a list but currently can have only one element.</p>
        pub fn parent_readiness_scopes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.parent_readiness_scopes.unwrap_or_default();
            v.push(input.into());
            self.parent_readiness_scopes = Some(v);
            self
        }
        /// <p>The readiness scope for the cell, which can be a cell Amazon Resource Name (ARN) or a recovery group ARN. This is a list but currently can have only one element.</p>
        pub fn set_parent_readiness_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.parent_readiness_scopes = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags on the resources.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags on the resources.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateCellOutput`](crate::output::UpdateCellOutput)
        pub fn build(self) -> crate::output::UpdateCellOutput {
            crate::output::UpdateCellOutput {
                cell_arn: self.cell_arn,
                cell_name: self.cell_name,
                cells: self.cells,
                parent_readiness_scopes: self.parent_readiness_scopes,
                tags: self.tags,
            }
        }
    }
}
impl UpdateCellOutput {
    /// Creates a new builder-style object to manufacture [`UpdateCellOutput`](crate::output::UpdateCellOutput)
    pub fn builder() -> crate::output::update_cell_output::Builder {
        crate::output::update_cell_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourcesOutput {
    /// <p></p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsForResourcesOutput {
    /// <p></p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForResourcesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourcesOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourcesOutput`](crate::output::ListTagsForResourcesOutput)
pub mod list_tags_for_resources_output {
    /// A builder for [`ListTagsForResourcesOutput`](crate::output::ListTagsForResourcesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p></p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p></p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourcesOutput`](crate::output::ListTagsForResourcesOutput)
        pub fn build(self) -> crate::output::ListTagsForResourcesOutput {
            crate::output::ListTagsForResourcesOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourcesOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourcesOutput`](crate::output::ListTagsForResourcesOutput)
    pub fn builder() -> crate::output::list_tags_for_resources_output::Builder {
        crate::output::list_tags_for_resources_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRulesOutput {
    /// <p>The token that identifies which batch of results you want to see.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A list of readiness rules for a specific resource type.</p>
    pub rules: std::option::Option<std::vec::Vec<crate::model::ListRulesOutput>>,
}
impl ListRulesOutput {
    /// <p>The token that identifies which batch of results you want to see.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A list of readiness rules for a specific resource type.</p>
    pub fn rules(&self) -> std::option::Option<&[crate::model::ListRulesOutput]> {
        self.rules.as_deref()
    }
}
impl std::fmt::Debug for ListRulesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRulesOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("rules", &self.rules);
        formatter.finish()
    }
}
/// See [`ListRulesOutput`](crate::output::ListRulesOutput)
pub mod list_rules_output {
    /// A builder for [`ListRulesOutput`](crate::output::ListRulesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) rules: std::option::Option<std::vec::Vec<crate::model::ListRulesOutput>>,
    }
    impl Builder {
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>A list of readiness rules for a specific resource type.</p>
        pub fn rules(mut self, input: crate::model::ListRulesOutput) -> Self {
            let mut v = self.rules.unwrap_or_default();
            v.push(input);
            self.rules = Some(v);
            self
        }
        /// <p>A list of readiness rules for a specific resource type.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ListRulesOutput>>,
        ) -> Self {
            self.rules = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRulesOutput`](crate::output::ListRulesOutput)
        pub fn build(self) -> crate::output::ListRulesOutput {
            crate::output::ListRulesOutput {
                next_token: self.next_token,
                rules: self.rules,
            }
        }
    }
}
impl ListRulesOutput {
    /// Creates a new builder-style object to manufacture [`ListRulesOutput`](crate::output::ListRulesOutput)
    pub fn builder() -> crate::output::list_rules_output::Builder {
        crate::output::list_rules_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResourceSetsOutput {
    /// <p>The token that identifies which batch of results you want to see.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A list of resource sets associated with the account.</p>
    pub resource_sets: std::option::Option<std::vec::Vec<crate::model::ResourceSetOutput>>,
}
impl ListResourceSetsOutput {
    /// <p>The token that identifies which batch of results you want to see.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A list of resource sets associated with the account.</p>
    pub fn resource_sets(&self) -> std::option::Option<&[crate::model::ResourceSetOutput]> {
        self.resource_sets.as_deref()
    }
}
impl std::fmt::Debug for ListResourceSetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResourceSetsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("resource_sets", &self.resource_sets);
        formatter.finish()
    }
}
/// See [`ListResourceSetsOutput`](crate::output::ListResourceSetsOutput)
pub mod list_resource_sets_output {
    /// A builder for [`ListResourceSetsOutput`](crate::output::ListResourceSetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) resource_sets:
            std::option::Option<std::vec::Vec<crate::model::ResourceSetOutput>>,
    }
    impl Builder {
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `resource_sets`.
        ///
        /// To override the contents of this collection use [`set_resource_sets`](Self::set_resource_sets).
        ///
        /// <p>A list of resource sets associated with the account.</p>
        pub fn resource_sets(mut self, input: crate::model::ResourceSetOutput) -> Self {
            let mut v = self.resource_sets.unwrap_or_default();
            v.push(input);
            self.resource_sets = Some(v);
            self
        }
        /// <p>A list of resource sets associated with the account.</p>
        pub fn set_resource_sets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceSetOutput>>,
        ) -> Self {
            self.resource_sets = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResourceSetsOutput`](crate::output::ListResourceSetsOutput)
        pub fn build(self) -> crate::output::ListResourceSetsOutput {
            crate::output::ListResourceSetsOutput {
                next_token: self.next_token,
                resource_sets: self.resource_sets,
            }
        }
    }
}
impl ListResourceSetsOutput {
    /// Creates a new builder-style object to manufacture [`ListResourceSetsOutput`](crate::output::ListResourceSetsOutput)
    pub fn builder() -> crate::output::list_resource_sets_output::Builder {
        crate::output::list_resource_sets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRecoveryGroupsOutput {
    /// <p>The token that identifies which batch of results you want to see.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A list of recovery groups.</p>
    pub recovery_groups: std::option::Option<std::vec::Vec<crate::model::RecoveryGroupOutput>>,
}
impl ListRecoveryGroupsOutput {
    /// <p>The token that identifies which batch of results you want to see.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A list of recovery groups.</p>
    pub fn recovery_groups(&self) -> std::option::Option<&[crate::model::RecoveryGroupOutput]> {
        self.recovery_groups.as_deref()
    }
}
impl std::fmt::Debug for ListRecoveryGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRecoveryGroupsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("recovery_groups", &self.recovery_groups);
        formatter.finish()
    }
}
/// See [`ListRecoveryGroupsOutput`](crate::output::ListRecoveryGroupsOutput)
pub mod list_recovery_groups_output {
    /// A builder for [`ListRecoveryGroupsOutput`](crate::output::ListRecoveryGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) recovery_groups:
            std::option::Option<std::vec::Vec<crate::model::RecoveryGroupOutput>>,
    }
    impl Builder {
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `recovery_groups`.
        ///
        /// To override the contents of this collection use [`set_recovery_groups`](Self::set_recovery_groups).
        ///
        /// <p>A list of recovery groups.</p>
        pub fn recovery_groups(mut self, input: crate::model::RecoveryGroupOutput) -> Self {
            let mut v = self.recovery_groups.unwrap_or_default();
            v.push(input);
            self.recovery_groups = Some(v);
            self
        }
        /// <p>A list of recovery groups.</p>
        pub fn set_recovery_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecoveryGroupOutput>>,
        ) -> Self {
            self.recovery_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRecoveryGroupsOutput`](crate::output::ListRecoveryGroupsOutput)
        pub fn build(self) -> crate::output::ListRecoveryGroupsOutput {
            crate::output::ListRecoveryGroupsOutput {
                next_token: self.next_token,
                recovery_groups: self.recovery_groups,
            }
        }
    }
}
impl ListRecoveryGroupsOutput {
    /// Creates a new builder-style object to manufacture [`ListRecoveryGroupsOutput`](crate::output::ListRecoveryGroupsOutput)
    pub fn builder() -> crate::output::list_recovery_groups_output::Builder {
        crate::output::list_recovery_groups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListReadinessChecksOutput {
    /// <p>The token that identifies which batch of results you want to see.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A list of readiness checks associated with the account.</p>
    pub readiness_checks: std::option::Option<std::vec::Vec<crate::model::ReadinessCheckOutput>>,
}
impl ListReadinessChecksOutput {
    /// <p>The token that identifies which batch of results you want to see.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A list of readiness checks associated with the account.</p>
    pub fn readiness_checks(&self) -> std::option::Option<&[crate::model::ReadinessCheckOutput]> {
        self.readiness_checks.as_deref()
    }
}
impl std::fmt::Debug for ListReadinessChecksOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListReadinessChecksOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("readiness_checks", &self.readiness_checks);
        formatter.finish()
    }
}
/// See [`ListReadinessChecksOutput`](crate::output::ListReadinessChecksOutput)
pub mod list_readiness_checks_output {
    /// A builder for [`ListReadinessChecksOutput`](crate::output::ListReadinessChecksOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) readiness_checks:
            std::option::Option<std::vec::Vec<crate::model::ReadinessCheckOutput>>,
    }
    impl Builder {
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `readiness_checks`.
        ///
        /// To override the contents of this collection use [`set_readiness_checks`](Self::set_readiness_checks).
        ///
        /// <p>A list of readiness checks associated with the account.</p>
        pub fn readiness_checks(mut self, input: crate::model::ReadinessCheckOutput) -> Self {
            let mut v = self.readiness_checks.unwrap_or_default();
            v.push(input);
            self.readiness_checks = Some(v);
            self
        }
        /// <p>A list of readiness checks associated with the account.</p>
        pub fn set_readiness_checks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReadinessCheckOutput>>,
        ) -> Self {
            self.readiness_checks = input;
            self
        }
        /// Consumes the builder and constructs a [`ListReadinessChecksOutput`](crate::output::ListReadinessChecksOutput)
        pub fn build(self) -> crate::output::ListReadinessChecksOutput {
            crate::output::ListReadinessChecksOutput {
                next_token: self.next_token,
                readiness_checks: self.readiness_checks,
            }
        }
    }
}
impl ListReadinessChecksOutput {
    /// Creates a new builder-style object to manufacture [`ListReadinessChecksOutput`](crate::output::ListReadinessChecksOutput)
    pub fn builder() -> crate::output::list_readiness_checks_output::Builder {
        crate::output::list_readiness_checks_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCrossAccountAuthorizationsOutput {
    /// <p>A list of cross-account authorizations.</p>
    pub cross_account_authorizations: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The token that identifies which batch of results you want to see.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListCrossAccountAuthorizationsOutput {
    /// <p>A list of cross-account authorizations.</p>
    pub fn cross_account_authorizations(&self) -> std::option::Option<&[std::string::String]> {
        self.cross_account_authorizations.as_deref()
    }
    /// <p>The token that identifies which batch of results you want to see.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListCrossAccountAuthorizationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCrossAccountAuthorizationsOutput");
        formatter.field(
            "cross_account_authorizations",
            &self.cross_account_authorizations,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListCrossAccountAuthorizationsOutput`](crate::output::ListCrossAccountAuthorizationsOutput)
pub mod list_cross_account_authorizations_output {
    /// A builder for [`ListCrossAccountAuthorizationsOutput`](crate::output::ListCrossAccountAuthorizationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cross_account_authorizations:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `cross_account_authorizations`.
        ///
        /// To override the contents of this collection use [`set_cross_account_authorizations`](Self::set_cross_account_authorizations).
        ///
        /// <p>A list of cross-account authorizations.</p>
        pub fn cross_account_authorizations(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.cross_account_authorizations.unwrap_or_default();
            v.push(input.into());
            self.cross_account_authorizations = Some(v);
            self
        }
        /// <p>A list of cross-account authorizations.</p>
        pub fn set_cross_account_authorizations(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cross_account_authorizations = input;
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCrossAccountAuthorizationsOutput`](crate::output::ListCrossAccountAuthorizationsOutput)
        pub fn build(self) -> crate::output::ListCrossAccountAuthorizationsOutput {
            crate::output::ListCrossAccountAuthorizationsOutput {
                cross_account_authorizations: self.cross_account_authorizations,
                next_token: self.next_token,
            }
        }
    }
}
impl ListCrossAccountAuthorizationsOutput {
    /// Creates a new builder-style object to manufacture [`ListCrossAccountAuthorizationsOutput`](crate::output::ListCrossAccountAuthorizationsOutput)
    pub fn builder() -> crate::output::list_cross_account_authorizations_output::Builder {
        crate::output::list_cross_account_authorizations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCellsOutput {
    /// <p>A list of cells.</p>
    pub cells: std::option::Option<std::vec::Vec<crate::model::CellOutput>>,
    /// <p>The token that identifies which batch of results you want to see.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListCellsOutput {
    /// <p>A list of cells.</p>
    pub fn cells(&self) -> std::option::Option<&[crate::model::CellOutput]> {
        self.cells.as_deref()
    }
    /// <p>The token that identifies which batch of results you want to see.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListCellsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCellsOutput");
        formatter.field("cells", &self.cells);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListCellsOutput`](crate::output::ListCellsOutput)
pub mod list_cells_output {
    /// A builder for [`ListCellsOutput`](crate::output::ListCellsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cells: std::option::Option<std::vec::Vec<crate::model::CellOutput>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `cells`.
        ///
        /// To override the contents of this collection use [`set_cells`](Self::set_cells).
        ///
        /// <p>A list of cells.</p>
        pub fn cells(mut self, input: crate::model::CellOutput) -> Self {
            let mut v = self.cells.unwrap_or_default();
            v.push(input);
            self.cells = Some(v);
            self
        }
        /// <p>A list of cells.</p>
        pub fn set_cells(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CellOutput>>,
        ) -> Self {
            self.cells = input;
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCellsOutput`](crate::output::ListCellsOutput)
        pub fn build(self) -> crate::output::ListCellsOutput {
            crate::output::ListCellsOutput {
                cells: self.cells,
                next_token: self.next_token,
            }
        }
    }
}
impl ListCellsOutput {
    /// Creates a new builder-style object to manufacture [`ListCellsOutput`](crate::output::ListCellsOutput)
    pub fn builder() -> crate::output::list_cells_output::Builder {
        crate::output::list_cells_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResourceSetOutput {
    /// <p>The Amazon Resource Name (ARN) for the resource set.</p>
    pub resource_set_arn: std::option::Option<std::string::String>,
    /// <p>The name of the resource set.</p>
    pub resource_set_name: std::option::Option<std::string::String>,
    /// <p>The resource type of the resources in the resource set. Enter one of the following values for resource type:</p>
    /// <p>AWS::ApiGateway::Stage, AWS::ApiGatewayV2::Stage, AWS::AutoScaling::AutoScalingGroup, AWS::CloudWatch::Alarm, AWS::EC2::CustomerGateway, AWS::DynamoDB::Table, AWS::EC2::Volume, AWS::ElasticLoadBalancing::LoadBalancer, AWS::ElasticLoadBalancingV2::LoadBalancer, AWS::Lambda::Function, AWS::MSK::Cluster, AWS::RDS::DBCluster, AWS::Route53::HealthCheck, AWS::SQS::Queue, AWS::SNS::Topic, AWS::SNS::Subscription, AWS::EC2::VPC, AWS::EC2::VPNConnection, AWS::EC2::VPNGateway, AWS::Route53RecoveryReadiness::DNSTargetResource</p>
    pub resource_set_type: std::option::Option<std::string::String>,
    /// <p>A list of resource objects.</p>
    pub resources: std::option::Option<std::vec::Vec<crate::model::Resource>>,
    /// <p>A collection of tags associated with a resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl GetResourceSetOutput {
    /// <p>The Amazon Resource Name (ARN) for the resource set.</p>
    pub fn resource_set_arn(&self) -> std::option::Option<&str> {
        self.resource_set_arn.as_deref()
    }
    /// <p>The name of the resource set.</p>
    pub fn resource_set_name(&self) -> std::option::Option<&str> {
        self.resource_set_name.as_deref()
    }
    /// <p>The resource type of the resources in the resource set. Enter one of the following values for resource type:</p>
    /// <p>AWS::ApiGateway::Stage, AWS::ApiGatewayV2::Stage, AWS::AutoScaling::AutoScalingGroup, AWS::CloudWatch::Alarm, AWS::EC2::CustomerGateway, AWS::DynamoDB::Table, AWS::EC2::Volume, AWS::ElasticLoadBalancing::LoadBalancer, AWS::ElasticLoadBalancingV2::LoadBalancer, AWS::Lambda::Function, AWS::MSK::Cluster, AWS::RDS::DBCluster, AWS::Route53::HealthCheck, AWS::SQS::Queue, AWS::SNS::Topic, AWS::SNS::Subscription, AWS::EC2::VPC, AWS::EC2::VPNConnection, AWS::EC2::VPNGateway, AWS::Route53RecoveryReadiness::DNSTargetResource</p>
    pub fn resource_set_type(&self) -> std::option::Option<&str> {
        self.resource_set_type.as_deref()
    }
    /// <p>A list of resource objects.</p>
    pub fn resources(&self) -> std::option::Option<&[crate::model::Resource]> {
        self.resources.as_deref()
    }
    /// <p>A collection of tags associated with a resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for GetResourceSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResourceSetOutput");
        formatter.field("resource_set_arn", &self.resource_set_arn);
        formatter.field("resource_set_name", &self.resource_set_name);
        formatter.field("resource_set_type", &self.resource_set_type);
        formatter.field("resources", &self.resources);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`GetResourceSetOutput`](crate::output::GetResourceSetOutput)
pub mod get_resource_set_output {
    /// A builder for [`GetResourceSetOutput`](crate::output::GetResourceSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_set_arn: std::option::Option<std::string::String>,
        pub(crate) resource_set_name: std::option::Option<std::string::String>,
        pub(crate) resource_set_type: std::option::Option<std::string::String>,
        pub(crate) resources: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the resource set.</p>
        pub fn resource_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_set_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the resource set.</p>
        pub fn set_resource_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_set_arn = input;
            self
        }
        /// <p>The name of the resource set.</p>
        pub fn resource_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_set_name = Some(input.into());
            self
        }
        /// <p>The name of the resource set.</p>
        pub fn set_resource_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_set_name = input;
            self
        }
        /// <p>The resource type of the resources in the resource set. Enter one of the following values for resource type:</p>
        /// <p>AWS::ApiGateway::Stage, AWS::ApiGatewayV2::Stage, AWS::AutoScaling::AutoScalingGroup, AWS::CloudWatch::Alarm, AWS::EC2::CustomerGateway, AWS::DynamoDB::Table, AWS::EC2::Volume, AWS::ElasticLoadBalancing::LoadBalancer, AWS::ElasticLoadBalancingV2::LoadBalancer, AWS::Lambda::Function, AWS::MSK::Cluster, AWS::RDS::DBCluster, AWS::Route53::HealthCheck, AWS::SQS::Queue, AWS::SNS::Topic, AWS::SNS::Subscription, AWS::EC2::VPC, AWS::EC2::VPNConnection, AWS::EC2::VPNGateway, AWS::Route53RecoveryReadiness::DNSTargetResource</p>
        pub fn resource_set_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_set_type = Some(input.into());
            self
        }
        /// <p>The resource type of the resources in the resource set. Enter one of the following values for resource type:</p>
        /// <p>AWS::ApiGateway::Stage, AWS::ApiGatewayV2::Stage, AWS::AutoScaling::AutoScalingGroup, AWS::CloudWatch::Alarm, AWS::EC2::CustomerGateway, AWS::DynamoDB::Table, AWS::EC2::Volume, AWS::ElasticLoadBalancing::LoadBalancer, AWS::ElasticLoadBalancingV2::LoadBalancer, AWS::Lambda::Function, AWS::MSK::Cluster, AWS::RDS::DBCluster, AWS::Route53::HealthCheck, AWS::SQS::Queue, AWS::SNS::Topic, AWS::SNS::Subscription, AWS::EC2::VPC, AWS::EC2::VPNConnection, AWS::EC2::VPNGateway, AWS::Route53RecoveryReadiness::DNSTargetResource</p>
        pub fn set_resource_set_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_set_type = input;
            self
        }
        /// Appends an item to `resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// <p>A list of resource objects.</p>
        pub fn resources(mut self, input: crate::model::Resource) -> Self {
            let mut v = self.resources.unwrap_or_default();
            v.push(input);
            self.resources = Some(v);
            self
        }
        /// <p>A list of resource objects.</p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of tags associated with a resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A collection of tags associated with a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResourceSetOutput`](crate::output::GetResourceSetOutput)
        pub fn build(self) -> crate::output::GetResourceSetOutput {
            crate::output::GetResourceSetOutput {
                resource_set_arn: self.resource_set_arn,
                resource_set_name: self.resource_set_name,
                resource_set_type: self.resource_set_type,
                resources: self.resources,
                tags: self.tags,
            }
        }
    }
}
impl GetResourceSetOutput {
    /// Creates a new builder-style object to manufacture [`GetResourceSetOutput`](crate::output::GetResourceSetOutput)
    pub fn builder() -> crate::output::get_resource_set_output::Builder {
        crate::output::get_resource_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRecoveryGroupReadinessSummaryOutput {
    /// <p>The token that identifies which batch of results you want to see.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The readiness status at a recovery group level.</p>
    pub readiness: std::option::Option<crate::model::Readiness>,
    /// <p>Summaries of the readiness checks for the recovery group.</p>
    pub readiness_checks: std::option::Option<std::vec::Vec<crate::model::ReadinessCheckSummary>>,
}
impl GetRecoveryGroupReadinessSummaryOutput {
    /// <p>The token that identifies which batch of results you want to see.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The readiness status at a recovery group level.</p>
    pub fn readiness(&self) -> std::option::Option<&crate::model::Readiness> {
        self.readiness.as_ref()
    }
    /// <p>Summaries of the readiness checks for the recovery group.</p>
    pub fn readiness_checks(&self) -> std::option::Option<&[crate::model::ReadinessCheckSummary]> {
        self.readiness_checks.as_deref()
    }
}
impl std::fmt::Debug for GetRecoveryGroupReadinessSummaryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRecoveryGroupReadinessSummaryOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("readiness", &self.readiness);
        formatter.field("readiness_checks", &self.readiness_checks);
        formatter.finish()
    }
}
/// See [`GetRecoveryGroupReadinessSummaryOutput`](crate::output::GetRecoveryGroupReadinessSummaryOutput)
pub mod get_recovery_group_readiness_summary_output {
    /// A builder for [`GetRecoveryGroupReadinessSummaryOutput`](crate::output::GetRecoveryGroupReadinessSummaryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) readiness: std::option::Option<crate::model::Readiness>,
        pub(crate) readiness_checks:
            std::option::Option<std::vec::Vec<crate::model::ReadinessCheckSummary>>,
    }
    impl Builder {
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The readiness status at a recovery group level.</p>
        pub fn readiness(mut self, input: crate::model::Readiness) -> Self {
            self.readiness = Some(input);
            self
        }
        /// <p>The readiness status at a recovery group level.</p>
        pub fn set_readiness(
            mut self,
            input: std::option::Option<crate::model::Readiness>,
        ) -> Self {
            self.readiness = input;
            self
        }
        /// Appends an item to `readiness_checks`.
        ///
        /// To override the contents of this collection use [`set_readiness_checks`](Self::set_readiness_checks).
        ///
        /// <p>Summaries of the readiness checks for the recovery group.</p>
        pub fn readiness_checks(mut self, input: crate::model::ReadinessCheckSummary) -> Self {
            let mut v = self.readiness_checks.unwrap_or_default();
            v.push(input);
            self.readiness_checks = Some(v);
            self
        }
        /// <p>Summaries of the readiness checks for the recovery group.</p>
        pub fn set_readiness_checks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReadinessCheckSummary>>,
        ) -> Self {
            self.readiness_checks = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRecoveryGroupReadinessSummaryOutput`](crate::output::GetRecoveryGroupReadinessSummaryOutput)
        pub fn build(self) -> crate::output::GetRecoveryGroupReadinessSummaryOutput {
            crate::output::GetRecoveryGroupReadinessSummaryOutput {
                next_token: self.next_token,
                readiness: self.readiness,
                readiness_checks: self.readiness_checks,
            }
        }
    }
}
impl GetRecoveryGroupReadinessSummaryOutput {
    /// Creates a new builder-style object to manufacture [`GetRecoveryGroupReadinessSummaryOutput`](crate::output::GetRecoveryGroupReadinessSummaryOutput)
    pub fn builder() -> crate::output::get_recovery_group_readiness_summary_output::Builder {
        crate::output::get_recovery_group_readiness_summary_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRecoveryGroupOutput {
    /// <p>A list of a cell's Amazon Resource Names (ARNs).</p>
    pub cells: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) for the recovery group.</p>
    pub recovery_group_arn: std::option::Option<std::string::String>,
    /// <p>The name of the recovery group.</p>
    pub recovery_group_name: std::option::Option<std::string::String>,
    /// <p>The tags associated with the recovery group.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl GetRecoveryGroupOutput {
    /// <p>A list of a cell's Amazon Resource Names (ARNs).</p>
    pub fn cells(&self) -> std::option::Option<&[std::string::String]> {
        self.cells.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the recovery group.</p>
    pub fn recovery_group_arn(&self) -> std::option::Option<&str> {
        self.recovery_group_arn.as_deref()
    }
    /// <p>The name of the recovery group.</p>
    pub fn recovery_group_name(&self) -> std::option::Option<&str> {
        self.recovery_group_name.as_deref()
    }
    /// <p>The tags associated with the recovery group.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for GetRecoveryGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRecoveryGroupOutput");
        formatter.field("cells", &self.cells);
        formatter.field("recovery_group_arn", &self.recovery_group_arn);
        formatter.field("recovery_group_name", &self.recovery_group_name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`GetRecoveryGroupOutput`](crate::output::GetRecoveryGroupOutput)
pub mod get_recovery_group_output {
    /// A builder for [`GetRecoveryGroupOutput`](crate::output::GetRecoveryGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cells: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) recovery_group_arn: std::option::Option<std::string::String>,
        pub(crate) recovery_group_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Appends an item to `cells`.
        ///
        /// To override the contents of this collection use [`set_cells`](Self::set_cells).
        ///
        /// <p>A list of a cell's Amazon Resource Names (ARNs).</p>
        pub fn cells(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cells.unwrap_or_default();
            v.push(input.into());
            self.cells = Some(v);
            self
        }
        /// <p>A list of a cell's Amazon Resource Names (ARNs).</p>
        pub fn set_cells(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cells = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the recovery group.</p>
        pub fn recovery_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the recovery group.</p>
        pub fn set_recovery_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_group_arn = input;
            self
        }
        /// <p>The name of the recovery group.</p>
        pub fn recovery_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_group_name = Some(input.into());
            self
        }
        /// <p>The name of the recovery group.</p>
        pub fn set_recovery_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_group_name = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the recovery group.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags associated with the recovery group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRecoveryGroupOutput`](crate::output::GetRecoveryGroupOutput)
        pub fn build(self) -> crate::output::GetRecoveryGroupOutput {
            crate::output::GetRecoveryGroupOutput {
                cells: self.cells,
                recovery_group_arn: self.recovery_group_arn,
                recovery_group_name: self.recovery_group_name,
                tags: self.tags,
            }
        }
    }
}
impl GetRecoveryGroupOutput {
    /// Creates a new builder-style object to manufacture [`GetRecoveryGroupOutput`](crate::output::GetRecoveryGroupOutput)
    pub fn builder() -> crate::output::get_recovery_group_output::Builder {
        crate::output::get_recovery_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetReadinessCheckStatusOutput {
    /// <p>Top level messages for readiness check status</p>
    pub messages: std::option::Option<std::vec::Vec<crate::model::Message>>,
    /// <p>The token that identifies which batch of results you want to see.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The readiness at rule level.</p>
    pub readiness: std::option::Option<crate::model::Readiness>,
    /// <p>Summary of the readiness of resources.</p>
    pub resources: std::option::Option<std::vec::Vec<crate::model::ResourceResult>>,
}
impl GetReadinessCheckStatusOutput {
    /// <p>Top level messages for readiness check status</p>
    pub fn messages(&self) -> std::option::Option<&[crate::model::Message]> {
        self.messages.as_deref()
    }
    /// <p>The token that identifies which batch of results you want to see.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The readiness at rule level.</p>
    pub fn readiness(&self) -> std::option::Option<&crate::model::Readiness> {
        self.readiness.as_ref()
    }
    /// <p>Summary of the readiness of resources.</p>
    pub fn resources(&self) -> std::option::Option<&[crate::model::ResourceResult]> {
        self.resources.as_deref()
    }
}
impl std::fmt::Debug for GetReadinessCheckStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetReadinessCheckStatusOutput");
        formatter.field("messages", &self.messages);
        formatter.field("next_token", &self.next_token);
        formatter.field("readiness", &self.readiness);
        formatter.field("resources", &self.resources);
        formatter.finish()
    }
}
/// See [`GetReadinessCheckStatusOutput`](crate::output::GetReadinessCheckStatusOutput)
pub mod get_readiness_check_status_output {
    /// A builder for [`GetReadinessCheckStatusOutput`](crate::output::GetReadinessCheckStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) messages: std::option::Option<std::vec::Vec<crate::model::Message>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) readiness: std::option::Option<crate::model::Readiness>,
        pub(crate) resources: std::option::Option<std::vec::Vec<crate::model::ResourceResult>>,
    }
    impl Builder {
        /// Appends an item to `messages`.
        ///
        /// To override the contents of this collection use [`set_messages`](Self::set_messages).
        ///
        /// <p>Top level messages for readiness check status</p>
        pub fn messages(mut self, input: crate::model::Message) -> Self {
            let mut v = self.messages.unwrap_or_default();
            v.push(input);
            self.messages = Some(v);
            self
        }
        /// <p>Top level messages for readiness check status</p>
        pub fn set_messages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Message>>,
        ) -> Self {
            self.messages = input;
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The readiness at rule level.</p>
        pub fn readiness(mut self, input: crate::model::Readiness) -> Self {
            self.readiness = Some(input);
            self
        }
        /// <p>The readiness at rule level.</p>
        pub fn set_readiness(
            mut self,
            input: std::option::Option<crate::model::Readiness>,
        ) -> Self {
            self.readiness = input;
            self
        }
        /// Appends an item to `resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// <p>Summary of the readiness of resources.</p>
        pub fn resources(mut self, input: crate::model::ResourceResult) -> Self {
            let mut v = self.resources.unwrap_or_default();
            v.push(input);
            self.resources = Some(v);
            self
        }
        /// <p>Summary of the readiness of resources.</p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceResult>>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// Consumes the builder and constructs a [`GetReadinessCheckStatusOutput`](crate::output::GetReadinessCheckStatusOutput)
        pub fn build(self) -> crate::output::GetReadinessCheckStatusOutput {
            crate::output::GetReadinessCheckStatusOutput {
                messages: self.messages,
                next_token: self.next_token,
                readiness: self.readiness,
                resources: self.resources,
            }
        }
    }
}
impl GetReadinessCheckStatusOutput {
    /// Creates a new builder-style object to manufacture [`GetReadinessCheckStatusOutput`](crate::output::GetReadinessCheckStatusOutput)
    pub fn builder() -> crate::output::get_readiness_check_status_output::Builder {
        crate::output::get_readiness_check_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetReadinessCheckResourceStatusOutput {
    /// <p>The token that identifies which batch of results you want to see.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The readiness at a rule level.</p>
    pub readiness: std::option::Option<crate::model::Readiness>,
    /// <p>Details of the rule's results.</p>
    pub rules: std::option::Option<std::vec::Vec<crate::model::RuleResult>>,
}
impl GetReadinessCheckResourceStatusOutput {
    /// <p>The token that identifies which batch of results you want to see.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The readiness at a rule level.</p>
    pub fn readiness(&self) -> std::option::Option<&crate::model::Readiness> {
        self.readiness.as_ref()
    }
    /// <p>Details of the rule's results.</p>
    pub fn rules(&self) -> std::option::Option<&[crate::model::RuleResult]> {
        self.rules.as_deref()
    }
}
impl std::fmt::Debug for GetReadinessCheckResourceStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetReadinessCheckResourceStatusOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("readiness", &self.readiness);
        formatter.field("rules", &self.rules);
        formatter.finish()
    }
}
/// See [`GetReadinessCheckResourceStatusOutput`](crate::output::GetReadinessCheckResourceStatusOutput)
pub mod get_readiness_check_resource_status_output {
    /// A builder for [`GetReadinessCheckResourceStatusOutput`](crate::output::GetReadinessCheckResourceStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) readiness: std::option::Option<crate::model::Readiness>,
        pub(crate) rules: std::option::Option<std::vec::Vec<crate::model::RuleResult>>,
    }
    impl Builder {
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The readiness at a rule level.</p>
        pub fn readiness(mut self, input: crate::model::Readiness) -> Self {
            self.readiness = Some(input);
            self
        }
        /// <p>The readiness at a rule level.</p>
        pub fn set_readiness(
            mut self,
            input: std::option::Option<crate::model::Readiness>,
        ) -> Self {
            self.readiness = input;
            self
        }
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>Details of the rule's results.</p>
        pub fn rules(mut self, input: crate::model::RuleResult) -> Self {
            let mut v = self.rules.unwrap_or_default();
            v.push(input);
            self.rules = Some(v);
            self
        }
        /// <p>Details of the rule's results.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RuleResult>>,
        ) -> Self {
            self.rules = input;
            self
        }
        /// Consumes the builder and constructs a [`GetReadinessCheckResourceStatusOutput`](crate::output::GetReadinessCheckResourceStatusOutput)
        pub fn build(self) -> crate::output::GetReadinessCheckResourceStatusOutput {
            crate::output::GetReadinessCheckResourceStatusOutput {
                next_token: self.next_token,
                readiness: self.readiness,
                rules: self.rules,
            }
        }
    }
}
impl GetReadinessCheckResourceStatusOutput {
    /// Creates a new builder-style object to manufacture [`GetReadinessCheckResourceStatusOutput`](crate::output::GetReadinessCheckResourceStatusOutput)
    pub fn builder() -> crate::output::get_readiness_check_resource_status_output::Builder {
        crate::output::get_readiness_check_resource_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetReadinessCheckOutput {
    /// <p>The Amazon Resource Name (ARN) associated with a readiness check.</p>
    pub readiness_check_arn: std::option::Option<std::string::String>,
    /// <p>Name of a readiness check.</p>
    pub readiness_check_name: std::option::Option<std::string::String>,
    /// <p>Name of the resource set to be checked.</p>
    pub resource_set: std::option::Option<std::string::String>,
    /// <p>A collection of tags associated with a resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl GetReadinessCheckOutput {
    /// <p>The Amazon Resource Name (ARN) associated with a readiness check.</p>
    pub fn readiness_check_arn(&self) -> std::option::Option<&str> {
        self.readiness_check_arn.as_deref()
    }
    /// <p>Name of a readiness check.</p>
    pub fn readiness_check_name(&self) -> std::option::Option<&str> {
        self.readiness_check_name.as_deref()
    }
    /// <p>Name of the resource set to be checked.</p>
    pub fn resource_set(&self) -> std::option::Option<&str> {
        self.resource_set.as_deref()
    }
    /// <p>A collection of tags associated with a resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for GetReadinessCheckOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetReadinessCheckOutput");
        formatter.field("readiness_check_arn", &self.readiness_check_arn);
        formatter.field("readiness_check_name", &self.readiness_check_name);
        formatter.field("resource_set", &self.resource_set);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`GetReadinessCheckOutput`](crate::output::GetReadinessCheckOutput)
pub mod get_readiness_check_output {
    /// A builder for [`GetReadinessCheckOutput`](crate::output::GetReadinessCheckOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) readiness_check_arn: std::option::Option<std::string::String>,
        pub(crate) readiness_check_name: std::option::Option<std::string::String>,
        pub(crate) resource_set: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) associated with a readiness check.</p>
        pub fn readiness_check_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.readiness_check_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) associated with a readiness check.</p>
        pub fn set_readiness_check_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.readiness_check_arn = input;
            self
        }
        /// <p>Name of a readiness check.</p>
        pub fn readiness_check_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.readiness_check_name = Some(input.into());
            self
        }
        /// <p>Name of a readiness check.</p>
        pub fn set_readiness_check_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.readiness_check_name = input;
            self
        }
        /// <p>Name of the resource set to be checked.</p>
        pub fn resource_set(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_set = Some(input.into());
            self
        }
        /// <p>Name of the resource set to be checked.</p>
        pub fn set_resource_set(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_set = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of tags associated with a resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A collection of tags associated with a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`GetReadinessCheckOutput`](crate::output::GetReadinessCheckOutput)
        pub fn build(self) -> crate::output::GetReadinessCheckOutput {
            crate::output::GetReadinessCheckOutput {
                readiness_check_arn: self.readiness_check_arn,
                readiness_check_name: self.readiness_check_name,
                resource_set: self.resource_set,
                tags: self.tags,
            }
        }
    }
}
impl GetReadinessCheckOutput {
    /// Creates a new builder-style object to manufacture [`GetReadinessCheckOutput`](crate::output::GetReadinessCheckOutput)
    pub fn builder() -> crate::output::get_readiness_check_output::Builder {
        crate::output::get_readiness_check_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCellReadinessSummaryOutput {
    /// <p>The token that identifies which batch of results you want to see.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The readiness at a cell level.</p>
    pub readiness: std::option::Option<crate::model::Readiness>,
    /// <p>Summaries for the readiness checks that make up the cell.</p>
    pub readiness_checks: std::option::Option<std::vec::Vec<crate::model::ReadinessCheckSummary>>,
}
impl GetCellReadinessSummaryOutput {
    /// <p>The token that identifies which batch of results you want to see.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The readiness at a cell level.</p>
    pub fn readiness(&self) -> std::option::Option<&crate::model::Readiness> {
        self.readiness.as_ref()
    }
    /// <p>Summaries for the readiness checks that make up the cell.</p>
    pub fn readiness_checks(&self) -> std::option::Option<&[crate::model::ReadinessCheckSummary]> {
        self.readiness_checks.as_deref()
    }
}
impl std::fmt::Debug for GetCellReadinessSummaryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCellReadinessSummaryOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("readiness", &self.readiness);
        formatter.field("readiness_checks", &self.readiness_checks);
        formatter.finish()
    }
}
/// See [`GetCellReadinessSummaryOutput`](crate::output::GetCellReadinessSummaryOutput)
pub mod get_cell_readiness_summary_output {
    /// A builder for [`GetCellReadinessSummaryOutput`](crate::output::GetCellReadinessSummaryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) readiness: std::option::Option<crate::model::Readiness>,
        pub(crate) readiness_checks:
            std::option::Option<std::vec::Vec<crate::model::ReadinessCheckSummary>>,
    }
    impl Builder {
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The readiness at a cell level.</p>
        pub fn readiness(mut self, input: crate::model::Readiness) -> Self {
            self.readiness = Some(input);
            self
        }
        /// <p>The readiness at a cell level.</p>
        pub fn set_readiness(
            mut self,
            input: std::option::Option<crate::model::Readiness>,
        ) -> Self {
            self.readiness = input;
            self
        }
        /// Appends an item to `readiness_checks`.
        ///
        /// To override the contents of this collection use [`set_readiness_checks`](Self::set_readiness_checks).
        ///
        /// <p>Summaries for the readiness checks that make up the cell.</p>
        pub fn readiness_checks(mut self, input: crate::model::ReadinessCheckSummary) -> Self {
            let mut v = self.readiness_checks.unwrap_or_default();
            v.push(input);
            self.readiness_checks = Some(v);
            self
        }
        /// <p>Summaries for the readiness checks that make up the cell.</p>
        pub fn set_readiness_checks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReadinessCheckSummary>>,
        ) -> Self {
            self.readiness_checks = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCellReadinessSummaryOutput`](crate::output::GetCellReadinessSummaryOutput)
        pub fn build(self) -> crate::output::GetCellReadinessSummaryOutput {
            crate::output::GetCellReadinessSummaryOutput {
                next_token: self.next_token,
                readiness: self.readiness,
                readiness_checks: self.readiness_checks,
            }
        }
    }
}
impl GetCellReadinessSummaryOutput {
    /// Creates a new builder-style object to manufacture [`GetCellReadinessSummaryOutput`](crate::output::GetCellReadinessSummaryOutput)
    pub fn builder() -> crate::output::get_cell_readiness_summary_output::Builder {
        crate::output::get_cell_readiness_summary_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCellOutput {
    /// <p>The Amazon Resource Name (ARN) for the cell.</p>
    pub cell_arn: std::option::Option<std::string::String>,
    /// <p>The name of the cell.</p>
    pub cell_name: std::option::Option<std::string::String>,
    /// <p>A list of cell ARNs.</p>
    pub cells: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The readiness scope for the cell, which can be a cell Amazon Resource Name (ARN) or a recovery group ARN. This is a list but currently can have only one element.</p>
    pub parent_readiness_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Tags on the resources.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl GetCellOutput {
    /// <p>The Amazon Resource Name (ARN) for the cell.</p>
    pub fn cell_arn(&self) -> std::option::Option<&str> {
        self.cell_arn.as_deref()
    }
    /// <p>The name of the cell.</p>
    pub fn cell_name(&self) -> std::option::Option<&str> {
        self.cell_name.as_deref()
    }
    /// <p>A list of cell ARNs.</p>
    pub fn cells(&self) -> std::option::Option<&[std::string::String]> {
        self.cells.as_deref()
    }
    /// <p>The readiness scope for the cell, which can be a cell Amazon Resource Name (ARN) or a recovery group ARN. This is a list but currently can have only one element.</p>
    pub fn parent_readiness_scopes(&self) -> std::option::Option<&[std::string::String]> {
        self.parent_readiness_scopes.as_deref()
    }
    /// <p>Tags on the resources.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for GetCellOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCellOutput");
        formatter.field("cell_arn", &self.cell_arn);
        formatter.field("cell_name", &self.cell_name);
        formatter.field("cells", &self.cells);
        formatter.field("parent_readiness_scopes", &self.parent_readiness_scopes);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`GetCellOutput`](crate::output::GetCellOutput)
pub mod get_cell_output {
    /// A builder for [`GetCellOutput`](crate::output::GetCellOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cell_arn: std::option::Option<std::string::String>,
        pub(crate) cell_name: std::option::Option<std::string::String>,
        pub(crate) cells: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) parent_readiness_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the cell.</p>
        pub fn cell_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cell_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the cell.</p>
        pub fn set_cell_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cell_arn = input;
            self
        }
        /// <p>The name of the cell.</p>
        pub fn cell_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cell_name = Some(input.into());
            self
        }
        /// <p>The name of the cell.</p>
        pub fn set_cell_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cell_name = input;
            self
        }
        /// Appends an item to `cells`.
        ///
        /// To override the contents of this collection use [`set_cells`](Self::set_cells).
        ///
        /// <p>A list of cell ARNs.</p>
        pub fn cells(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cells.unwrap_or_default();
            v.push(input.into());
            self.cells = Some(v);
            self
        }
        /// <p>A list of cell ARNs.</p>
        pub fn set_cells(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cells = input;
            self
        }
        /// Appends an item to `parent_readiness_scopes`.
        ///
        /// To override the contents of this collection use [`set_parent_readiness_scopes`](Self::set_parent_readiness_scopes).
        ///
        /// <p>The readiness scope for the cell, which can be a cell Amazon Resource Name (ARN) or a recovery group ARN. This is a list but currently can have only one element.</p>
        pub fn parent_readiness_scopes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.parent_readiness_scopes.unwrap_or_default();
            v.push(input.into());
            self.parent_readiness_scopes = Some(v);
            self
        }
        /// <p>The readiness scope for the cell, which can be a cell Amazon Resource Name (ARN) or a recovery group ARN. This is a list but currently can have only one element.</p>
        pub fn set_parent_readiness_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.parent_readiness_scopes = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags on the resources.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags on the resources.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCellOutput`](crate::output::GetCellOutput)
        pub fn build(self) -> crate::output::GetCellOutput {
            crate::output::GetCellOutput {
                cell_arn: self.cell_arn,
                cell_name: self.cell_name,
                cells: self.cells,
                parent_readiness_scopes: self.parent_readiness_scopes,
                tags: self.tags,
            }
        }
    }
}
impl GetCellOutput {
    /// Creates a new builder-style object to manufacture [`GetCellOutput`](crate::output::GetCellOutput)
    pub fn builder() -> crate::output::get_cell_output::Builder {
        crate::output::get_cell_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetArchitectureRecommendationsOutput {
    /// <p>The time that a recovery group was last assessed for recommendations, in UTC ISO-8601 format.</p>
    pub last_audit_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The token that identifies which batch of results you want to see.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A list of the recommendations for the customer's application.</p>
    pub recommendations: std::option::Option<std::vec::Vec<crate::model::Recommendation>>,
}
impl GetArchitectureRecommendationsOutput {
    /// <p>The time that a recovery group was last assessed for recommendations, in UTC ISO-8601 format.</p>
    pub fn last_audit_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_audit_timestamp.as_ref()
    }
    /// <p>The token that identifies which batch of results you want to see.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A list of the recommendations for the customer's application.</p>
    pub fn recommendations(&self) -> std::option::Option<&[crate::model::Recommendation]> {
        self.recommendations.as_deref()
    }
}
impl std::fmt::Debug for GetArchitectureRecommendationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetArchitectureRecommendationsOutput");
        formatter.field("last_audit_timestamp", &self.last_audit_timestamp);
        formatter.field("next_token", &self.next_token);
        formatter.field("recommendations", &self.recommendations);
        formatter.finish()
    }
}
/// See [`GetArchitectureRecommendationsOutput`](crate::output::GetArchitectureRecommendationsOutput)
pub mod get_architecture_recommendations_output {
    /// A builder for [`GetArchitectureRecommendationsOutput`](crate::output::GetArchitectureRecommendationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) last_audit_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) recommendations:
            std::option::Option<std::vec::Vec<crate::model::Recommendation>>,
    }
    impl Builder {
        /// <p>The time that a recovery group was last assessed for recommendations, in UTC ISO-8601 format.</p>
        pub fn last_audit_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_audit_timestamp = Some(input);
            self
        }
        /// <p>The time that a recovery group was last assessed for recommendations, in UTC ISO-8601 format.</p>
        pub fn set_last_audit_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_audit_timestamp = input;
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `recommendations`.
        ///
        /// To override the contents of this collection use [`set_recommendations`](Self::set_recommendations).
        ///
        /// <p>A list of the recommendations for the customer's application.</p>
        pub fn recommendations(mut self, input: crate::model::Recommendation) -> Self {
            let mut v = self.recommendations.unwrap_or_default();
            v.push(input);
            self.recommendations = Some(v);
            self
        }
        /// <p>A list of the recommendations for the customer's application.</p>
        pub fn set_recommendations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Recommendation>>,
        ) -> Self {
            self.recommendations = input;
            self
        }
        /// Consumes the builder and constructs a [`GetArchitectureRecommendationsOutput`](crate::output::GetArchitectureRecommendationsOutput)
        pub fn build(self) -> crate::output::GetArchitectureRecommendationsOutput {
            crate::output::GetArchitectureRecommendationsOutput {
                last_audit_timestamp: self.last_audit_timestamp,
                next_token: self.next_token,
                recommendations: self.recommendations,
            }
        }
    }
}
impl GetArchitectureRecommendationsOutput {
    /// Creates a new builder-style object to manufacture [`GetArchitectureRecommendationsOutput`](crate::output::GetArchitectureRecommendationsOutput)
    pub fn builder() -> crate::output::get_architecture_recommendations_output::Builder {
        crate::output::get_architecture_recommendations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteResourceSetOutput {}
impl std::fmt::Debug for DeleteResourceSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteResourceSetOutput");
        formatter.finish()
    }
}
/// See [`DeleteResourceSetOutput`](crate::output::DeleteResourceSetOutput)
pub mod delete_resource_set_output {
    /// A builder for [`DeleteResourceSetOutput`](crate::output::DeleteResourceSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteResourceSetOutput`](crate::output::DeleteResourceSetOutput)
        pub fn build(self) -> crate::output::DeleteResourceSetOutput {
            crate::output::DeleteResourceSetOutput {}
        }
    }
}
impl DeleteResourceSetOutput {
    /// Creates a new builder-style object to manufacture [`DeleteResourceSetOutput`](crate::output::DeleteResourceSetOutput)
    pub fn builder() -> crate::output::delete_resource_set_output::Builder {
        crate::output::delete_resource_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRecoveryGroupOutput {}
impl std::fmt::Debug for DeleteRecoveryGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRecoveryGroupOutput");
        formatter.finish()
    }
}
/// See [`DeleteRecoveryGroupOutput`](crate::output::DeleteRecoveryGroupOutput)
pub mod delete_recovery_group_output {
    /// A builder for [`DeleteRecoveryGroupOutput`](crate::output::DeleteRecoveryGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteRecoveryGroupOutput`](crate::output::DeleteRecoveryGroupOutput)
        pub fn build(self) -> crate::output::DeleteRecoveryGroupOutput {
            crate::output::DeleteRecoveryGroupOutput {}
        }
    }
}
impl DeleteRecoveryGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRecoveryGroupOutput`](crate::output::DeleteRecoveryGroupOutput)
    pub fn builder() -> crate::output::delete_recovery_group_output::Builder {
        crate::output::delete_recovery_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteReadinessCheckOutput {}
impl std::fmt::Debug for DeleteReadinessCheckOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteReadinessCheckOutput");
        formatter.finish()
    }
}
/// See [`DeleteReadinessCheckOutput`](crate::output::DeleteReadinessCheckOutput)
pub mod delete_readiness_check_output {
    /// A builder for [`DeleteReadinessCheckOutput`](crate::output::DeleteReadinessCheckOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteReadinessCheckOutput`](crate::output::DeleteReadinessCheckOutput)
        pub fn build(self) -> crate::output::DeleteReadinessCheckOutput {
            crate::output::DeleteReadinessCheckOutput {}
        }
    }
}
impl DeleteReadinessCheckOutput {
    /// Creates a new builder-style object to manufacture [`DeleteReadinessCheckOutput`](crate::output::DeleteReadinessCheckOutput)
    pub fn builder() -> crate::output::delete_readiness_check_output::Builder {
        crate::output::delete_readiness_check_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCrossAccountAuthorizationOutput {}
impl std::fmt::Debug for DeleteCrossAccountAuthorizationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCrossAccountAuthorizationOutput");
        formatter.finish()
    }
}
/// See [`DeleteCrossAccountAuthorizationOutput`](crate::output::DeleteCrossAccountAuthorizationOutput)
pub mod delete_cross_account_authorization_output {
    /// A builder for [`DeleteCrossAccountAuthorizationOutput`](crate::output::DeleteCrossAccountAuthorizationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteCrossAccountAuthorizationOutput`](crate::output::DeleteCrossAccountAuthorizationOutput)
        pub fn build(self) -> crate::output::DeleteCrossAccountAuthorizationOutput {
            crate::output::DeleteCrossAccountAuthorizationOutput {}
        }
    }
}
impl DeleteCrossAccountAuthorizationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteCrossAccountAuthorizationOutput`](crate::output::DeleteCrossAccountAuthorizationOutput)
    pub fn builder() -> crate::output::delete_cross_account_authorization_output::Builder {
        crate::output::delete_cross_account_authorization_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCellOutput {}
impl std::fmt::Debug for DeleteCellOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCellOutput");
        formatter.finish()
    }
}
/// See [`DeleteCellOutput`](crate::output::DeleteCellOutput)
pub mod delete_cell_output {
    /// A builder for [`DeleteCellOutput`](crate::output::DeleteCellOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteCellOutput`](crate::output::DeleteCellOutput)
        pub fn build(self) -> crate::output::DeleteCellOutput {
            crate::output::DeleteCellOutput {}
        }
    }
}
impl DeleteCellOutput {
    /// Creates a new builder-style object to manufacture [`DeleteCellOutput`](crate::output::DeleteCellOutput)
    pub fn builder() -> crate::output::delete_cell_output::Builder {
        crate::output::delete_cell_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateResourceSetOutput {
    /// <p>The Amazon Resource Name (ARN) for the resource set.</p>
    pub resource_set_arn: std::option::Option<std::string::String>,
    /// <p>The name of the resource set.</p>
    pub resource_set_name: std::option::Option<std::string::String>,
    /// <p>The resource type of the resources in the resource set. Enter one of the following values for resource type:</p>
    /// <p>AWS::ApiGateway::Stage, AWS::ApiGatewayV2::Stage, AWS::AutoScaling::AutoScalingGroup, AWS::CloudWatch::Alarm, AWS::EC2::CustomerGateway, AWS::DynamoDB::Table, AWS::EC2::Volume, AWS::ElasticLoadBalancing::LoadBalancer, AWS::ElasticLoadBalancingV2::LoadBalancer, AWS::Lambda::Function, AWS::MSK::Cluster, AWS::RDS::DBCluster, AWS::Route53::HealthCheck, AWS::SQS::Queue, AWS::SNS::Topic, AWS::SNS::Subscription, AWS::EC2::VPC, AWS::EC2::VPNConnection, AWS::EC2::VPNGateway, AWS::Route53RecoveryReadiness::DNSTargetResource</p>
    pub resource_set_type: std::option::Option<std::string::String>,
    /// <p>A list of resource objects.</p>
    pub resources: std::option::Option<std::vec::Vec<crate::model::Resource>>,
    /// <p>A collection of tags associated with a resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateResourceSetOutput {
    /// <p>The Amazon Resource Name (ARN) for the resource set.</p>
    pub fn resource_set_arn(&self) -> std::option::Option<&str> {
        self.resource_set_arn.as_deref()
    }
    /// <p>The name of the resource set.</p>
    pub fn resource_set_name(&self) -> std::option::Option<&str> {
        self.resource_set_name.as_deref()
    }
    /// <p>The resource type of the resources in the resource set. Enter one of the following values for resource type:</p>
    /// <p>AWS::ApiGateway::Stage, AWS::ApiGatewayV2::Stage, AWS::AutoScaling::AutoScalingGroup, AWS::CloudWatch::Alarm, AWS::EC2::CustomerGateway, AWS::DynamoDB::Table, AWS::EC2::Volume, AWS::ElasticLoadBalancing::LoadBalancer, AWS::ElasticLoadBalancingV2::LoadBalancer, AWS::Lambda::Function, AWS::MSK::Cluster, AWS::RDS::DBCluster, AWS::Route53::HealthCheck, AWS::SQS::Queue, AWS::SNS::Topic, AWS::SNS::Subscription, AWS::EC2::VPC, AWS::EC2::VPNConnection, AWS::EC2::VPNGateway, AWS::Route53RecoveryReadiness::DNSTargetResource</p>
    pub fn resource_set_type(&self) -> std::option::Option<&str> {
        self.resource_set_type.as_deref()
    }
    /// <p>A list of resource objects.</p>
    pub fn resources(&self) -> std::option::Option<&[crate::model::Resource]> {
        self.resources.as_deref()
    }
    /// <p>A collection of tags associated with a resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateResourceSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateResourceSetOutput");
        formatter.field("resource_set_arn", &self.resource_set_arn);
        formatter.field("resource_set_name", &self.resource_set_name);
        formatter.field("resource_set_type", &self.resource_set_type);
        formatter.field("resources", &self.resources);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`CreateResourceSetOutput`](crate::output::CreateResourceSetOutput)
pub mod create_resource_set_output {
    /// A builder for [`CreateResourceSetOutput`](crate::output::CreateResourceSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_set_arn: std::option::Option<std::string::String>,
        pub(crate) resource_set_name: std::option::Option<std::string::String>,
        pub(crate) resource_set_type: std::option::Option<std::string::String>,
        pub(crate) resources: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the resource set.</p>
        pub fn resource_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_set_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the resource set.</p>
        pub fn set_resource_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_set_arn = input;
            self
        }
        /// <p>The name of the resource set.</p>
        pub fn resource_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_set_name = Some(input.into());
            self
        }
        /// <p>The name of the resource set.</p>
        pub fn set_resource_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_set_name = input;
            self
        }
        /// <p>The resource type of the resources in the resource set. Enter one of the following values for resource type:</p>
        /// <p>AWS::ApiGateway::Stage, AWS::ApiGatewayV2::Stage, AWS::AutoScaling::AutoScalingGroup, AWS::CloudWatch::Alarm, AWS::EC2::CustomerGateway, AWS::DynamoDB::Table, AWS::EC2::Volume, AWS::ElasticLoadBalancing::LoadBalancer, AWS::ElasticLoadBalancingV2::LoadBalancer, AWS::Lambda::Function, AWS::MSK::Cluster, AWS::RDS::DBCluster, AWS::Route53::HealthCheck, AWS::SQS::Queue, AWS::SNS::Topic, AWS::SNS::Subscription, AWS::EC2::VPC, AWS::EC2::VPNConnection, AWS::EC2::VPNGateway, AWS::Route53RecoveryReadiness::DNSTargetResource</p>
        pub fn resource_set_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_set_type = Some(input.into());
            self
        }
        /// <p>The resource type of the resources in the resource set. Enter one of the following values for resource type:</p>
        /// <p>AWS::ApiGateway::Stage, AWS::ApiGatewayV2::Stage, AWS::AutoScaling::AutoScalingGroup, AWS::CloudWatch::Alarm, AWS::EC2::CustomerGateway, AWS::DynamoDB::Table, AWS::EC2::Volume, AWS::ElasticLoadBalancing::LoadBalancer, AWS::ElasticLoadBalancingV2::LoadBalancer, AWS::Lambda::Function, AWS::MSK::Cluster, AWS::RDS::DBCluster, AWS::Route53::HealthCheck, AWS::SQS::Queue, AWS::SNS::Topic, AWS::SNS::Subscription, AWS::EC2::VPC, AWS::EC2::VPNConnection, AWS::EC2::VPNGateway, AWS::Route53RecoveryReadiness::DNSTargetResource</p>
        pub fn set_resource_set_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_set_type = input;
            self
        }
        /// Appends an item to `resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// <p>A list of resource objects.</p>
        pub fn resources(mut self, input: crate::model::Resource) -> Self {
            let mut v = self.resources.unwrap_or_default();
            v.push(input);
            self.resources = Some(v);
            self
        }
        /// <p>A list of resource objects.</p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of tags associated with a resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A collection of tags associated with a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateResourceSetOutput`](crate::output::CreateResourceSetOutput)
        pub fn build(self) -> crate::output::CreateResourceSetOutput {
            crate::output::CreateResourceSetOutput {
                resource_set_arn: self.resource_set_arn,
                resource_set_name: self.resource_set_name,
                resource_set_type: self.resource_set_type,
                resources: self.resources,
                tags: self.tags,
            }
        }
    }
}
impl CreateResourceSetOutput {
    /// Creates a new builder-style object to manufacture [`CreateResourceSetOutput`](crate::output::CreateResourceSetOutput)
    pub fn builder() -> crate::output::create_resource_set_output::Builder {
        crate::output::create_resource_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRecoveryGroupOutput {
    /// <p>A list of a cell's Amazon Resource Names (ARNs).</p>
    pub cells: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) for the recovery group.</p>
    pub recovery_group_arn: std::option::Option<std::string::String>,
    /// <p>The name of the recovery group.</p>
    pub recovery_group_name: std::option::Option<std::string::String>,
    /// <p>The tags associated with the recovery group.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateRecoveryGroupOutput {
    /// <p>A list of a cell's Amazon Resource Names (ARNs).</p>
    pub fn cells(&self) -> std::option::Option<&[std::string::String]> {
        self.cells.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the recovery group.</p>
    pub fn recovery_group_arn(&self) -> std::option::Option<&str> {
        self.recovery_group_arn.as_deref()
    }
    /// <p>The name of the recovery group.</p>
    pub fn recovery_group_name(&self) -> std::option::Option<&str> {
        self.recovery_group_name.as_deref()
    }
    /// <p>The tags associated with the recovery group.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateRecoveryGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRecoveryGroupOutput");
        formatter.field("cells", &self.cells);
        formatter.field("recovery_group_arn", &self.recovery_group_arn);
        formatter.field("recovery_group_name", &self.recovery_group_name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`CreateRecoveryGroupOutput`](crate::output::CreateRecoveryGroupOutput)
pub mod create_recovery_group_output {
    /// A builder for [`CreateRecoveryGroupOutput`](crate::output::CreateRecoveryGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cells: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) recovery_group_arn: std::option::Option<std::string::String>,
        pub(crate) recovery_group_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Appends an item to `cells`.
        ///
        /// To override the contents of this collection use [`set_cells`](Self::set_cells).
        ///
        /// <p>A list of a cell's Amazon Resource Names (ARNs).</p>
        pub fn cells(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cells.unwrap_or_default();
            v.push(input.into());
            self.cells = Some(v);
            self
        }
        /// <p>A list of a cell's Amazon Resource Names (ARNs).</p>
        pub fn set_cells(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cells = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the recovery group.</p>
        pub fn recovery_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the recovery group.</p>
        pub fn set_recovery_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_group_arn = input;
            self
        }
        /// <p>The name of the recovery group.</p>
        pub fn recovery_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_group_name = Some(input.into());
            self
        }
        /// <p>The name of the recovery group.</p>
        pub fn set_recovery_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_group_name = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the recovery group.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags associated with the recovery group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRecoveryGroupOutput`](crate::output::CreateRecoveryGroupOutput)
        pub fn build(self) -> crate::output::CreateRecoveryGroupOutput {
            crate::output::CreateRecoveryGroupOutput {
                cells: self.cells,
                recovery_group_arn: self.recovery_group_arn,
                recovery_group_name: self.recovery_group_name,
                tags: self.tags,
            }
        }
    }
}
impl CreateRecoveryGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateRecoveryGroupOutput`](crate::output::CreateRecoveryGroupOutput)
    pub fn builder() -> crate::output::create_recovery_group_output::Builder {
        crate::output::create_recovery_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateReadinessCheckOutput {
    /// <p>The Amazon Resource Name (ARN) associated with a readiness check.</p>
    pub readiness_check_arn: std::option::Option<std::string::String>,
    /// <p>Name of a readiness check.</p>
    pub readiness_check_name: std::option::Option<std::string::String>,
    /// <p>Name of the resource set to be checked.</p>
    pub resource_set: std::option::Option<std::string::String>,
    /// <p>A collection of tags associated with a resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateReadinessCheckOutput {
    /// <p>The Amazon Resource Name (ARN) associated with a readiness check.</p>
    pub fn readiness_check_arn(&self) -> std::option::Option<&str> {
        self.readiness_check_arn.as_deref()
    }
    /// <p>Name of a readiness check.</p>
    pub fn readiness_check_name(&self) -> std::option::Option<&str> {
        self.readiness_check_name.as_deref()
    }
    /// <p>Name of the resource set to be checked.</p>
    pub fn resource_set(&self) -> std::option::Option<&str> {
        self.resource_set.as_deref()
    }
    /// <p>A collection of tags associated with a resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateReadinessCheckOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateReadinessCheckOutput");
        formatter.field("readiness_check_arn", &self.readiness_check_arn);
        formatter.field("readiness_check_name", &self.readiness_check_name);
        formatter.field("resource_set", &self.resource_set);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`CreateReadinessCheckOutput`](crate::output::CreateReadinessCheckOutput)
pub mod create_readiness_check_output {
    /// A builder for [`CreateReadinessCheckOutput`](crate::output::CreateReadinessCheckOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) readiness_check_arn: std::option::Option<std::string::String>,
        pub(crate) readiness_check_name: std::option::Option<std::string::String>,
        pub(crate) resource_set: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) associated with a readiness check.</p>
        pub fn readiness_check_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.readiness_check_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) associated with a readiness check.</p>
        pub fn set_readiness_check_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.readiness_check_arn = input;
            self
        }
        /// <p>Name of a readiness check.</p>
        pub fn readiness_check_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.readiness_check_name = Some(input.into());
            self
        }
        /// <p>Name of a readiness check.</p>
        pub fn set_readiness_check_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.readiness_check_name = input;
            self
        }
        /// <p>Name of the resource set to be checked.</p>
        pub fn resource_set(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_set = Some(input.into());
            self
        }
        /// <p>Name of the resource set to be checked.</p>
        pub fn set_resource_set(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_set = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of tags associated with a resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A collection of tags associated with a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateReadinessCheckOutput`](crate::output::CreateReadinessCheckOutput)
        pub fn build(self) -> crate::output::CreateReadinessCheckOutput {
            crate::output::CreateReadinessCheckOutput {
                readiness_check_arn: self.readiness_check_arn,
                readiness_check_name: self.readiness_check_name,
                resource_set: self.resource_set,
                tags: self.tags,
            }
        }
    }
}
impl CreateReadinessCheckOutput {
    /// Creates a new builder-style object to manufacture [`CreateReadinessCheckOutput`](crate::output::CreateReadinessCheckOutput)
    pub fn builder() -> crate::output::create_readiness_check_output::Builder {
        crate::output::create_readiness_check_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCrossAccountAuthorizationOutput {
    /// <p>The cross-account authorization.</p>
    pub cross_account_authorization: std::option::Option<std::string::String>,
}
impl CreateCrossAccountAuthorizationOutput {
    /// <p>The cross-account authorization.</p>
    pub fn cross_account_authorization(&self) -> std::option::Option<&str> {
        self.cross_account_authorization.as_deref()
    }
}
impl std::fmt::Debug for CreateCrossAccountAuthorizationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCrossAccountAuthorizationOutput");
        formatter.field(
            "cross_account_authorization",
            &self.cross_account_authorization,
        );
        formatter.finish()
    }
}
/// See [`CreateCrossAccountAuthorizationOutput`](crate::output::CreateCrossAccountAuthorizationOutput)
pub mod create_cross_account_authorization_output {
    /// A builder for [`CreateCrossAccountAuthorizationOutput`](crate::output::CreateCrossAccountAuthorizationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cross_account_authorization: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The cross-account authorization.</p>
        pub fn cross_account_authorization(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cross_account_authorization = Some(input.into());
            self
        }
        /// <p>The cross-account authorization.</p>
        pub fn set_cross_account_authorization(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cross_account_authorization = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCrossAccountAuthorizationOutput`](crate::output::CreateCrossAccountAuthorizationOutput)
        pub fn build(self) -> crate::output::CreateCrossAccountAuthorizationOutput {
            crate::output::CreateCrossAccountAuthorizationOutput {
                cross_account_authorization: self.cross_account_authorization,
            }
        }
    }
}
impl CreateCrossAccountAuthorizationOutput {
    /// Creates a new builder-style object to manufacture [`CreateCrossAccountAuthorizationOutput`](crate::output::CreateCrossAccountAuthorizationOutput)
    pub fn builder() -> crate::output::create_cross_account_authorization_output::Builder {
        crate::output::create_cross_account_authorization_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCellOutput {
    /// <p>The Amazon Resource Name (ARN) for the cell.</p>
    pub cell_arn: std::option::Option<std::string::String>,
    /// <p>The name of the cell.</p>
    pub cell_name: std::option::Option<std::string::String>,
    /// <p>A list of cell ARNs.</p>
    pub cells: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The readiness scope for the cell, which can be a cell Amazon Resource Name (ARN) or a recovery group ARN. This is a list but currently can have only one element.</p>
    pub parent_readiness_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Tags on the resources.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateCellOutput {
    /// <p>The Amazon Resource Name (ARN) for the cell.</p>
    pub fn cell_arn(&self) -> std::option::Option<&str> {
        self.cell_arn.as_deref()
    }
    /// <p>The name of the cell.</p>
    pub fn cell_name(&self) -> std::option::Option<&str> {
        self.cell_name.as_deref()
    }
    /// <p>A list of cell ARNs.</p>
    pub fn cells(&self) -> std::option::Option<&[std::string::String]> {
        self.cells.as_deref()
    }
    /// <p>The readiness scope for the cell, which can be a cell Amazon Resource Name (ARN) or a recovery group ARN. This is a list but currently can have only one element.</p>
    pub fn parent_readiness_scopes(&self) -> std::option::Option<&[std::string::String]> {
        self.parent_readiness_scopes.as_deref()
    }
    /// <p>Tags on the resources.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateCellOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCellOutput");
        formatter.field("cell_arn", &self.cell_arn);
        formatter.field("cell_name", &self.cell_name);
        formatter.field("cells", &self.cells);
        formatter.field("parent_readiness_scopes", &self.parent_readiness_scopes);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`CreateCellOutput`](crate::output::CreateCellOutput)
pub mod create_cell_output {
    /// A builder for [`CreateCellOutput`](crate::output::CreateCellOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cell_arn: std::option::Option<std::string::String>,
        pub(crate) cell_name: std::option::Option<std::string::String>,
        pub(crate) cells: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) parent_readiness_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the cell.</p>
        pub fn cell_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cell_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the cell.</p>
        pub fn set_cell_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cell_arn = input;
            self
        }
        /// <p>The name of the cell.</p>
        pub fn cell_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cell_name = Some(input.into());
            self
        }
        /// <p>The name of the cell.</p>
        pub fn set_cell_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cell_name = input;
            self
        }
        /// Appends an item to `cells`.
        ///
        /// To override the contents of this collection use [`set_cells`](Self::set_cells).
        ///
        /// <p>A list of cell ARNs.</p>
        pub fn cells(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cells.unwrap_or_default();
            v.push(input.into());
            self.cells = Some(v);
            self
        }
        /// <p>A list of cell ARNs.</p>
        pub fn set_cells(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cells = input;
            self
        }
        /// Appends an item to `parent_readiness_scopes`.
        ///
        /// To override the contents of this collection use [`set_parent_readiness_scopes`](Self::set_parent_readiness_scopes).
        ///
        /// <p>The readiness scope for the cell, which can be a cell Amazon Resource Name (ARN) or a recovery group ARN. This is a list but currently can have only one element.</p>
        pub fn parent_readiness_scopes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.parent_readiness_scopes.unwrap_or_default();
            v.push(input.into());
            self.parent_readiness_scopes = Some(v);
            self
        }
        /// <p>The readiness scope for the cell, which can be a cell Amazon Resource Name (ARN) or a recovery group ARN. This is a list but currently can have only one element.</p>
        pub fn set_parent_readiness_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.parent_readiness_scopes = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags on the resources.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags on the resources.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCellOutput`](crate::output::CreateCellOutput)
        pub fn build(self) -> crate::output::CreateCellOutput {
            crate::output::CreateCellOutput {
                cell_arn: self.cell_arn,
                cell_name: self.cell_name,
                cells: self.cells,
                parent_readiness_scopes: self.parent_readiness_scopes,
                tags: self.tags,
            }
        }
    }
}
impl CreateCellOutput {
    /// Creates a new builder-style object to manufacture [`CreateCellOutput`](crate::output::CreateCellOutput)
    pub fn builder() -> crate::output::create_cell_output::Builder {
        crate::output::create_cell_output::Builder::default()
    }
}
