// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>The resource element of a resource set.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Resource {
    /// <p>The component identifier of the resource, generated when DNS target resource is used.</p>
    pub component_id: std::option::Option<std::string::String>,
    /// <p>The DNS target resource.</p>
    pub dns_target_resource: std::option::Option<crate::model::DnsTargetResource>,
    /// <p>A list of recovery group Amazon Resource Names (ARNs) and cell ARNs that this resource is contained within.</p>
    pub readiness_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl Resource {
    /// <p>The component identifier of the resource, generated when DNS target resource is used.</p>
    pub fn component_id(&self) -> std::option::Option<&str> {
        self.component_id.as_deref()
    }
    /// <p>The DNS target resource.</p>
    pub fn dns_target_resource(&self) -> std::option::Option<&crate::model::DnsTargetResource> {
        self.dns_target_resource.as_ref()
    }
    /// <p>A list of recovery group Amazon Resource Names (ARNs) and cell ARNs that this resource is contained within.</p>
    pub fn readiness_scopes(&self) -> std::option::Option<&[std::string::String]> {
        self.readiness_scopes.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for Resource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Resource");
        formatter.field("component_id", &self.component_id);
        formatter.field("dns_target_resource", &self.dns_target_resource);
        formatter.field("readiness_scopes", &self.readiness_scopes);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}
/// See [`Resource`](crate::model::Resource)
pub mod resource {
    /// A builder for [`Resource`](crate::model::Resource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) component_id: std::option::Option<std::string::String>,
        pub(crate) dns_target_resource: std::option::Option<crate::model::DnsTargetResource>,
        pub(crate) readiness_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The component identifier of the resource, generated when DNS target resource is used.</p>
        pub fn component_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_id = Some(input.into());
            self
        }
        /// <p>The component identifier of the resource, generated when DNS target resource is used.</p>
        pub fn set_component_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.component_id = input;
            self
        }
        /// <p>The DNS target resource.</p>
        pub fn dns_target_resource(mut self, input: crate::model::DnsTargetResource) -> Self {
            self.dns_target_resource = Some(input);
            self
        }
        /// <p>The DNS target resource.</p>
        pub fn set_dns_target_resource(
            mut self,
            input: std::option::Option<crate::model::DnsTargetResource>,
        ) -> Self {
            self.dns_target_resource = input;
            self
        }
        /// Appends an item to `readiness_scopes`.
        ///
        /// To override the contents of this collection use [`set_readiness_scopes`](Self::set_readiness_scopes).
        ///
        /// <p>A list of recovery group Amazon Resource Names (ARNs) and cell ARNs that this resource is contained within.</p>
        pub fn readiness_scopes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.readiness_scopes.unwrap_or_default();
            v.push(input.into());
            self.readiness_scopes = Some(v);
            self
        }
        /// <p>A list of recovery group Amazon Resource Names (ARNs) and cell ARNs that this resource is contained within.</p>
        pub fn set_readiness_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.readiness_scopes = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Resource`](crate::model::Resource)
        pub fn build(self) -> crate::model::Resource {
            crate::model::Resource {
                component_id: self.component_id,
                dns_target_resource: self.dns_target_resource,
                readiness_scopes: self.readiness_scopes,
                resource_arn: self.resource_arn,
            }
        }
    }
}
impl Resource {
    /// Creates a new builder-style object to manufacture [`Resource`](crate::model::Resource)
    pub fn builder() -> crate::model::resource::Builder {
        crate::model::resource::Builder::default()
    }
}

/// <p>A component for DNS/routing control readiness checks and architecture checks.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DnsTargetResource {
    /// <p>The domain name that acts as an ingress point to a portion of the customer application.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The hosted zone Amazon Resource Name (ARN) that contains the DNS record with the provided name of the target resource.</p>
    pub hosted_zone_arn: std::option::Option<std::string::String>,
    /// <p>The Route 53 record set ID that uniquely identifies a DNS record, given a name and a type.</p>
    pub record_set_id: std::option::Option<std::string::String>,
    /// <p>The type of DNS record of the target resource.</p>
    pub record_type: std::option::Option<std::string::String>,
    /// <p>The target resource of the DNS target resource.</p>
    pub target_resource: std::option::Option<crate::model::TargetResource>,
}
impl DnsTargetResource {
    /// <p>The domain name that acts as an ingress point to a portion of the customer application.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The hosted zone Amazon Resource Name (ARN) that contains the DNS record with the provided name of the target resource.</p>
    pub fn hosted_zone_arn(&self) -> std::option::Option<&str> {
        self.hosted_zone_arn.as_deref()
    }
    /// <p>The Route 53 record set ID that uniquely identifies a DNS record, given a name and a type.</p>
    pub fn record_set_id(&self) -> std::option::Option<&str> {
        self.record_set_id.as_deref()
    }
    /// <p>The type of DNS record of the target resource.</p>
    pub fn record_type(&self) -> std::option::Option<&str> {
        self.record_type.as_deref()
    }
    /// <p>The target resource of the DNS target resource.</p>
    pub fn target_resource(&self) -> std::option::Option<&crate::model::TargetResource> {
        self.target_resource.as_ref()
    }
}
impl std::fmt::Debug for DnsTargetResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DnsTargetResource");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("hosted_zone_arn", &self.hosted_zone_arn);
        formatter.field("record_set_id", &self.record_set_id);
        formatter.field("record_type", &self.record_type);
        formatter.field("target_resource", &self.target_resource);
        formatter.finish()
    }
}
/// See [`DnsTargetResource`](crate::model::DnsTargetResource)
pub mod dns_target_resource {
    /// A builder for [`DnsTargetResource`](crate::model::DnsTargetResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) hosted_zone_arn: std::option::Option<std::string::String>,
        pub(crate) record_set_id: std::option::Option<std::string::String>,
        pub(crate) record_type: std::option::Option<std::string::String>,
        pub(crate) target_resource: std::option::Option<crate::model::TargetResource>,
    }
    impl Builder {
        /// <p>The domain name that acts as an ingress point to a portion of the customer application.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain name that acts as an ingress point to a portion of the customer application.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The hosted zone Amazon Resource Name (ARN) that contains the DNS record with the provided name of the target resource.</p>
        pub fn hosted_zone_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.hosted_zone_arn = Some(input.into());
            self
        }
        /// <p>The hosted zone Amazon Resource Name (ARN) that contains the DNS record with the provided name of the target resource.</p>
        pub fn set_hosted_zone_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hosted_zone_arn = input;
            self
        }
        /// <p>The Route 53 record set ID that uniquely identifies a DNS record, given a name and a type.</p>
        pub fn record_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.record_set_id = Some(input.into());
            self
        }
        /// <p>The Route 53 record set ID that uniquely identifies a DNS record, given a name and a type.</p>
        pub fn set_record_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.record_set_id = input;
            self
        }
        /// <p>The type of DNS record of the target resource.</p>
        pub fn record_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.record_type = Some(input.into());
            self
        }
        /// <p>The type of DNS record of the target resource.</p>
        pub fn set_record_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.record_type = input;
            self
        }
        /// <p>The target resource of the DNS target resource.</p>
        pub fn target_resource(mut self, input: crate::model::TargetResource) -> Self {
            self.target_resource = Some(input);
            self
        }
        /// <p>The target resource of the DNS target resource.</p>
        pub fn set_target_resource(
            mut self,
            input: std::option::Option<crate::model::TargetResource>,
        ) -> Self {
            self.target_resource = input;
            self
        }
        /// Consumes the builder and constructs a [`DnsTargetResource`](crate::model::DnsTargetResource)
        pub fn build(self) -> crate::model::DnsTargetResource {
            crate::model::DnsTargetResource {
                domain_name: self.domain_name,
                hosted_zone_arn: self.hosted_zone_arn,
                record_set_id: self.record_set_id,
                record_type: self.record_type,
                target_resource: self.target_resource,
            }
        }
    }
}
impl DnsTargetResource {
    /// Creates a new builder-style object to manufacture [`DnsTargetResource`](crate::model::DnsTargetResource)
    pub fn builder() -> crate::model::dns_target_resource::Builder {
        crate::model::dns_target_resource::Builder::default()
    }
}

/// <p>The target resource that the Route 53 record points to.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TargetResource {
    /// <p>The Network Load Balancer Resource.</p>
    pub nlb_resource: std::option::Option<crate::model::NlbResource>,
    /// <p>The Route 53 resource.</p>
    pub r53_resource: std::option::Option<crate::model::R53ResourceRecord>,
}
impl TargetResource {
    /// <p>The Network Load Balancer Resource.</p>
    pub fn nlb_resource(&self) -> std::option::Option<&crate::model::NlbResource> {
        self.nlb_resource.as_ref()
    }
    /// <p>The Route 53 resource.</p>
    pub fn r53_resource(&self) -> std::option::Option<&crate::model::R53ResourceRecord> {
        self.r53_resource.as_ref()
    }
}
impl std::fmt::Debug for TargetResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TargetResource");
        formatter.field("nlb_resource", &self.nlb_resource);
        formatter.field("r53_resource", &self.r53_resource);
        formatter.finish()
    }
}
/// See [`TargetResource`](crate::model::TargetResource)
pub mod target_resource {
    /// A builder for [`TargetResource`](crate::model::TargetResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) nlb_resource: std::option::Option<crate::model::NlbResource>,
        pub(crate) r53_resource: std::option::Option<crate::model::R53ResourceRecord>,
    }
    impl Builder {
        /// <p>The Network Load Balancer Resource.</p>
        pub fn nlb_resource(mut self, input: crate::model::NlbResource) -> Self {
            self.nlb_resource = Some(input);
            self
        }
        /// <p>The Network Load Balancer Resource.</p>
        pub fn set_nlb_resource(
            mut self,
            input: std::option::Option<crate::model::NlbResource>,
        ) -> Self {
            self.nlb_resource = input;
            self
        }
        /// <p>The Route 53 resource.</p>
        pub fn r53_resource(mut self, input: crate::model::R53ResourceRecord) -> Self {
            self.r53_resource = Some(input);
            self
        }
        /// <p>The Route 53 resource.</p>
        pub fn set_r53_resource(
            mut self,
            input: std::option::Option<crate::model::R53ResourceRecord>,
        ) -> Self {
            self.r53_resource = input;
            self
        }
        /// Consumes the builder and constructs a [`TargetResource`](crate::model::TargetResource)
        pub fn build(self) -> crate::model::TargetResource {
            crate::model::TargetResource {
                nlb_resource: self.nlb_resource,
                r53_resource: self.r53_resource,
            }
        }
    }
}
impl TargetResource {
    /// Creates a new builder-style object to manufacture [`TargetResource`](crate::model::TargetResource)
    pub fn builder() -> crate::model::target_resource::Builder {
        crate::model::target_resource::Builder::default()
    }
}

/// <p>The Route 53 resource that a DNS target resource record points to.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct R53ResourceRecord {
    /// <p>The DNS target domain name.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The Route 53 Resource Record Set ID.</p>
    pub record_set_id: std::option::Option<std::string::String>,
}
impl R53ResourceRecord {
    /// <p>The DNS target domain name.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The Route 53 Resource Record Set ID.</p>
    pub fn record_set_id(&self) -> std::option::Option<&str> {
        self.record_set_id.as_deref()
    }
}
impl std::fmt::Debug for R53ResourceRecord {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("R53ResourceRecord");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("record_set_id", &self.record_set_id);
        formatter.finish()
    }
}
/// See [`R53ResourceRecord`](crate::model::R53ResourceRecord)
pub mod r53_resource_record {
    /// A builder for [`R53ResourceRecord`](crate::model::R53ResourceRecord)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) record_set_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The DNS target domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The DNS target domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The Route 53 Resource Record Set ID.</p>
        pub fn record_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.record_set_id = Some(input.into());
            self
        }
        /// <p>The Route 53 Resource Record Set ID.</p>
        pub fn set_record_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.record_set_id = input;
            self
        }
        /// Consumes the builder and constructs a [`R53ResourceRecord`](crate::model::R53ResourceRecord)
        pub fn build(self) -> crate::model::R53ResourceRecord {
            crate::model::R53ResourceRecord {
                domain_name: self.domain_name,
                record_set_id: self.record_set_id,
            }
        }
    }
}
impl R53ResourceRecord {
    /// Creates a new builder-style object to manufacture [`R53ResourceRecord`](crate::model::R53ResourceRecord)
    pub fn builder() -> crate::model::r53_resource_record::Builder {
        crate::model::r53_resource_record::Builder::default()
    }
}

/// <p>The Network Load Balancer resource that a DNS target resource points to.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NlbResource {
    /// <p>The Network Load Balancer resource Amazon Resource Name (ARN).</p>
    pub arn: std::option::Option<std::string::String>,
}
impl NlbResource {
    /// <p>The Network Load Balancer resource Amazon Resource Name (ARN).</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for NlbResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NlbResource");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`NlbResource`](crate::model::NlbResource)
pub mod nlb_resource {
    /// A builder for [`NlbResource`](crate::model::NlbResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Network Load Balancer resource Amazon Resource Name (ARN).</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Network Load Balancer resource Amazon Resource Name (ARN).</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`NlbResource`](crate::model::NlbResource)
        pub fn build(self) -> crate::model::NlbResource {
            crate::model::NlbResource { arn: self.arn }
        }
    }
}
impl NlbResource {
    /// Creates a new builder-style object to manufacture [`NlbResource`](crate::model::NlbResource)
    pub fn builder() -> crate::model::nlb_resource::Builder {
        crate::model::nlb_resource::Builder::default()
    }
}

/// <p>Readiness rule information, including the resource type, rule ID, and rule description.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRulesOutput {
    /// <p>The resource type that the readiness rule applies to.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The description of a readiness rule.</p>
    pub rule_description: std::option::Option<std::string::String>,
    /// <p>The ID for the readiness rule.</p>
    pub rule_id: std::option::Option<std::string::String>,
}
impl ListRulesOutput {
    /// <p>The resource type that the readiness rule applies to.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The description of a readiness rule.</p>
    pub fn rule_description(&self) -> std::option::Option<&str> {
        self.rule_description.as_deref()
    }
    /// <p>The ID for the readiness rule.</p>
    pub fn rule_id(&self) -> std::option::Option<&str> {
        self.rule_id.as_deref()
    }
}
impl std::fmt::Debug for ListRulesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRulesOutput");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("rule_description", &self.rule_description);
        formatter.field("rule_id", &self.rule_id);
        formatter.finish()
    }
}
/// See [`ListRulesOutput`](crate::model::ListRulesOutput)
pub mod list_rules_output {
    /// A builder for [`ListRulesOutput`](crate::model::ListRulesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) rule_description: std::option::Option<std::string::String>,
        pub(crate) rule_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The resource type that the readiness rule applies to.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The resource type that the readiness rule applies to.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The description of a readiness rule.</p>
        pub fn rule_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_description = Some(input.into());
            self
        }
        /// <p>The description of a readiness rule.</p>
        pub fn set_rule_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rule_description = input;
            self
        }
        /// <p>The ID for the readiness rule.</p>
        pub fn rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_id = Some(input.into());
            self
        }
        /// <p>The ID for the readiness rule.</p>
        pub fn set_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRulesOutput`](crate::model::ListRulesOutput)
        pub fn build(self) -> crate::model::ListRulesOutput {
            crate::model::ListRulesOutput {
                resource_type: self.resource_type,
                rule_description: self.rule_description,
                rule_id: self.rule_id,
            }
        }
    }
}
impl ListRulesOutput {
    /// Creates a new builder-style object to manufacture [`ListRulesOutput`](crate::model::ListRulesOutput)
    pub fn builder() -> crate::model::list_rules_output::Builder {
        crate::model::list_rules_output::Builder::default()
    }
}

/// <p>A collection of resources of the same type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceSetOutput {
    /// <p>The Amazon Resource Name (ARN) for the resource set.</p>
    pub resource_set_arn: std::option::Option<std::string::String>,
    /// <p>The name of the resource set.</p>
    pub resource_set_name: std::option::Option<std::string::String>,
    /// <p>The resource type of the resources in the resource set. Enter one of the following values for resource type:</p>
    /// <p>AWS::ApiGateway::Stage, AWS::ApiGatewayV2::Stage, AWS::AutoScaling::AutoScalingGroup, AWS::CloudWatch::Alarm, AWS::EC2::CustomerGateway, AWS::DynamoDB::Table, AWS::EC2::Volume, AWS::ElasticLoadBalancing::LoadBalancer, AWS::ElasticLoadBalancingV2::LoadBalancer, AWS::Lambda::Function, AWS::MSK::Cluster, AWS::RDS::DBCluster, AWS::Route53::HealthCheck, AWS::SQS::Queue, AWS::SNS::Topic, AWS::SNS::Subscription, AWS::EC2::VPC, AWS::EC2::VPNConnection, AWS::EC2::VPNGateway, AWS::Route53RecoveryReadiness::DNSTargetResource</p>
    pub resource_set_type: std::option::Option<std::string::String>,
    /// <p>A list of resource objects.</p>
    pub resources: std::option::Option<std::vec::Vec<crate::model::Resource>>,
    /// <p>A collection of tags associated with a resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ResourceSetOutput {
    /// <p>The Amazon Resource Name (ARN) for the resource set.</p>
    pub fn resource_set_arn(&self) -> std::option::Option<&str> {
        self.resource_set_arn.as_deref()
    }
    /// <p>The name of the resource set.</p>
    pub fn resource_set_name(&self) -> std::option::Option<&str> {
        self.resource_set_name.as_deref()
    }
    /// <p>The resource type of the resources in the resource set. Enter one of the following values for resource type:</p>
    /// <p>AWS::ApiGateway::Stage, AWS::ApiGatewayV2::Stage, AWS::AutoScaling::AutoScalingGroup, AWS::CloudWatch::Alarm, AWS::EC2::CustomerGateway, AWS::DynamoDB::Table, AWS::EC2::Volume, AWS::ElasticLoadBalancing::LoadBalancer, AWS::ElasticLoadBalancingV2::LoadBalancer, AWS::Lambda::Function, AWS::MSK::Cluster, AWS::RDS::DBCluster, AWS::Route53::HealthCheck, AWS::SQS::Queue, AWS::SNS::Topic, AWS::SNS::Subscription, AWS::EC2::VPC, AWS::EC2::VPNConnection, AWS::EC2::VPNGateway, AWS::Route53RecoveryReadiness::DNSTargetResource</p>
    pub fn resource_set_type(&self) -> std::option::Option<&str> {
        self.resource_set_type.as_deref()
    }
    /// <p>A list of resource objects.</p>
    pub fn resources(&self) -> std::option::Option<&[crate::model::Resource]> {
        self.resources.as_deref()
    }
    /// <p>A collection of tags associated with a resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ResourceSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceSetOutput");
        formatter.field("resource_set_arn", &self.resource_set_arn);
        formatter.field("resource_set_name", &self.resource_set_name);
        formatter.field("resource_set_type", &self.resource_set_type);
        formatter.field("resources", &self.resources);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ResourceSetOutput`](crate::model::ResourceSetOutput)
pub mod resource_set_output {
    /// A builder for [`ResourceSetOutput`](crate::model::ResourceSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_set_arn: std::option::Option<std::string::String>,
        pub(crate) resource_set_name: std::option::Option<std::string::String>,
        pub(crate) resource_set_type: std::option::Option<std::string::String>,
        pub(crate) resources: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the resource set.</p>
        pub fn resource_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_set_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the resource set.</p>
        pub fn set_resource_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_set_arn = input;
            self
        }
        /// <p>The name of the resource set.</p>
        pub fn resource_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_set_name = Some(input.into());
            self
        }
        /// <p>The name of the resource set.</p>
        pub fn set_resource_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_set_name = input;
            self
        }
        /// <p>The resource type of the resources in the resource set. Enter one of the following values for resource type:</p>
        /// <p>AWS::ApiGateway::Stage, AWS::ApiGatewayV2::Stage, AWS::AutoScaling::AutoScalingGroup, AWS::CloudWatch::Alarm, AWS::EC2::CustomerGateway, AWS::DynamoDB::Table, AWS::EC2::Volume, AWS::ElasticLoadBalancing::LoadBalancer, AWS::ElasticLoadBalancingV2::LoadBalancer, AWS::Lambda::Function, AWS::MSK::Cluster, AWS::RDS::DBCluster, AWS::Route53::HealthCheck, AWS::SQS::Queue, AWS::SNS::Topic, AWS::SNS::Subscription, AWS::EC2::VPC, AWS::EC2::VPNConnection, AWS::EC2::VPNGateway, AWS::Route53RecoveryReadiness::DNSTargetResource</p>
        pub fn resource_set_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_set_type = Some(input.into());
            self
        }
        /// <p>The resource type of the resources in the resource set. Enter one of the following values for resource type:</p>
        /// <p>AWS::ApiGateway::Stage, AWS::ApiGatewayV2::Stage, AWS::AutoScaling::AutoScalingGroup, AWS::CloudWatch::Alarm, AWS::EC2::CustomerGateway, AWS::DynamoDB::Table, AWS::EC2::Volume, AWS::ElasticLoadBalancing::LoadBalancer, AWS::ElasticLoadBalancingV2::LoadBalancer, AWS::Lambda::Function, AWS::MSK::Cluster, AWS::RDS::DBCluster, AWS::Route53::HealthCheck, AWS::SQS::Queue, AWS::SNS::Topic, AWS::SNS::Subscription, AWS::EC2::VPC, AWS::EC2::VPNConnection, AWS::EC2::VPNGateway, AWS::Route53RecoveryReadiness::DNSTargetResource</p>
        pub fn set_resource_set_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_set_type = input;
            self
        }
        /// Appends an item to `resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// <p>A list of resource objects.</p>
        pub fn resources(mut self, input: crate::model::Resource) -> Self {
            let mut v = self.resources.unwrap_or_default();
            v.push(input);
            self.resources = Some(v);
            self
        }
        /// <p>A list of resource objects.</p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of tags associated with a resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A collection of tags associated with a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceSetOutput`](crate::model::ResourceSetOutput)
        pub fn build(self) -> crate::model::ResourceSetOutput {
            crate::model::ResourceSetOutput {
                resource_set_arn: self.resource_set_arn,
                resource_set_name: self.resource_set_name,
                resource_set_type: self.resource_set_type,
                resources: self.resources,
                tags: self.tags,
            }
        }
    }
}
impl ResourceSetOutput {
    /// Creates a new builder-style object to manufacture [`ResourceSetOutput`](crate::model::ResourceSetOutput)
    pub fn builder() -> crate::model::resource_set_output::Builder {
        crate::model::resource_set_output::Builder::default()
    }
}

/// <p>A representation of the application, typically containing multiple cells.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecoveryGroupOutput {
    /// <p>A list of a cell's Amazon Resource Names (ARNs).</p>
    pub cells: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) for the recovery group.</p>
    pub recovery_group_arn: std::option::Option<std::string::String>,
    /// <p>The name of the recovery group.</p>
    pub recovery_group_name: std::option::Option<std::string::String>,
    /// <p>The tags associated with the recovery group.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl RecoveryGroupOutput {
    /// <p>A list of a cell's Amazon Resource Names (ARNs).</p>
    pub fn cells(&self) -> std::option::Option<&[std::string::String]> {
        self.cells.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the recovery group.</p>
    pub fn recovery_group_arn(&self) -> std::option::Option<&str> {
        self.recovery_group_arn.as_deref()
    }
    /// <p>The name of the recovery group.</p>
    pub fn recovery_group_name(&self) -> std::option::Option<&str> {
        self.recovery_group_name.as_deref()
    }
    /// <p>The tags associated with the recovery group.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for RecoveryGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecoveryGroupOutput");
        formatter.field("cells", &self.cells);
        formatter.field("recovery_group_arn", &self.recovery_group_arn);
        formatter.field("recovery_group_name", &self.recovery_group_name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`RecoveryGroupOutput`](crate::model::RecoveryGroupOutput)
pub mod recovery_group_output {
    /// A builder for [`RecoveryGroupOutput`](crate::model::RecoveryGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cells: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) recovery_group_arn: std::option::Option<std::string::String>,
        pub(crate) recovery_group_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Appends an item to `cells`.
        ///
        /// To override the contents of this collection use [`set_cells`](Self::set_cells).
        ///
        /// <p>A list of a cell's Amazon Resource Names (ARNs).</p>
        pub fn cells(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cells.unwrap_or_default();
            v.push(input.into());
            self.cells = Some(v);
            self
        }
        /// <p>A list of a cell's Amazon Resource Names (ARNs).</p>
        pub fn set_cells(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cells = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the recovery group.</p>
        pub fn recovery_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the recovery group.</p>
        pub fn set_recovery_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_group_arn = input;
            self
        }
        /// <p>The name of the recovery group.</p>
        pub fn recovery_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_group_name = Some(input.into());
            self
        }
        /// <p>The name of the recovery group.</p>
        pub fn set_recovery_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_group_name = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the recovery group.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags associated with the recovery group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`RecoveryGroupOutput`](crate::model::RecoveryGroupOutput)
        pub fn build(self) -> crate::model::RecoveryGroupOutput {
            crate::model::RecoveryGroupOutput {
                cells: self.cells,
                recovery_group_arn: self.recovery_group_arn,
                recovery_group_name: self.recovery_group_name,
                tags: self.tags,
            }
        }
    }
}
impl RecoveryGroupOutput {
    /// Creates a new builder-style object to manufacture [`RecoveryGroupOutput`](crate::model::RecoveryGroupOutput)
    pub fn builder() -> crate::model::recovery_group_output::Builder {
        crate::model::recovery_group_output::Builder::default()
    }
}

/// <p>A readiness check.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReadinessCheckOutput {
    /// <p>The Amazon Resource Name (ARN) associated with a readiness check.</p>
    pub readiness_check_arn: std::option::Option<std::string::String>,
    /// <p>Name of a readiness check.</p>
    pub readiness_check_name: std::option::Option<std::string::String>,
    /// <p>Name of the resource set to be checked.</p>
    pub resource_set: std::option::Option<std::string::String>,
    /// <p>A collection of tags associated with a resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ReadinessCheckOutput {
    /// <p>The Amazon Resource Name (ARN) associated with a readiness check.</p>
    pub fn readiness_check_arn(&self) -> std::option::Option<&str> {
        self.readiness_check_arn.as_deref()
    }
    /// <p>Name of a readiness check.</p>
    pub fn readiness_check_name(&self) -> std::option::Option<&str> {
        self.readiness_check_name.as_deref()
    }
    /// <p>Name of the resource set to be checked.</p>
    pub fn resource_set(&self) -> std::option::Option<&str> {
        self.resource_set.as_deref()
    }
    /// <p>A collection of tags associated with a resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ReadinessCheckOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReadinessCheckOutput");
        formatter.field("readiness_check_arn", &self.readiness_check_arn);
        formatter.field("readiness_check_name", &self.readiness_check_name);
        formatter.field("resource_set", &self.resource_set);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ReadinessCheckOutput`](crate::model::ReadinessCheckOutput)
pub mod readiness_check_output {
    /// A builder for [`ReadinessCheckOutput`](crate::model::ReadinessCheckOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) readiness_check_arn: std::option::Option<std::string::String>,
        pub(crate) readiness_check_name: std::option::Option<std::string::String>,
        pub(crate) resource_set: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) associated with a readiness check.</p>
        pub fn readiness_check_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.readiness_check_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) associated with a readiness check.</p>
        pub fn set_readiness_check_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.readiness_check_arn = input;
            self
        }
        /// <p>Name of a readiness check.</p>
        pub fn readiness_check_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.readiness_check_name = Some(input.into());
            self
        }
        /// <p>Name of a readiness check.</p>
        pub fn set_readiness_check_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.readiness_check_name = input;
            self
        }
        /// <p>Name of the resource set to be checked.</p>
        pub fn resource_set(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_set = Some(input.into());
            self
        }
        /// <p>Name of the resource set to be checked.</p>
        pub fn set_resource_set(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_set = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of tags associated with a resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A collection of tags associated with a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ReadinessCheckOutput`](crate::model::ReadinessCheckOutput)
        pub fn build(self) -> crate::model::ReadinessCheckOutput {
            crate::model::ReadinessCheckOutput {
                readiness_check_arn: self.readiness_check_arn,
                readiness_check_name: self.readiness_check_name,
                resource_set: self.resource_set,
                tags: self.tags,
            }
        }
    }
}
impl ReadinessCheckOutput {
    /// Creates a new builder-style object to manufacture [`ReadinessCheckOutput`](crate::model::ReadinessCheckOutput)
    pub fn builder() -> crate::model::readiness_check_output::Builder {
        crate::model::readiness_check_output::Builder::default()
    }
}

/// <p>Information about a cell.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CellOutput {
    /// <p>The Amazon Resource Name (ARN) for the cell.</p>
    pub cell_arn: std::option::Option<std::string::String>,
    /// <p>The name of the cell.</p>
    pub cell_name: std::option::Option<std::string::String>,
    /// <p>A list of cell ARNs.</p>
    pub cells: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The readiness scope for the cell, which can be a cell Amazon Resource Name (ARN) or a recovery group ARN. This is a list but currently can have only one element.</p>
    pub parent_readiness_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Tags on the resources.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CellOutput {
    /// <p>The Amazon Resource Name (ARN) for the cell.</p>
    pub fn cell_arn(&self) -> std::option::Option<&str> {
        self.cell_arn.as_deref()
    }
    /// <p>The name of the cell.</p>
    pub fn cell_name(&self) -> std::option::Option<&str> {
        self.cell_name.as_deref()
    }
    /// <p>A list of cell ARNs.</p>
    pub fn cells(&self) -> std::option::Option<&[std::string::String]> {
        self.cells.as_deref()
    }
    /// <p>The readiness scope for the cell, which can be a cell Amazon Resource Name (ARN) or a recovery group ARN. This is a list but currently can have only one element.</p>
    pub fn parent_readiness_scopes(&self) -> std::option::Option<&[std::string::String]> {
        self.parent_readiness_scopes.as_deref()
    }
    /// <p>Tags on the resources.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CellOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CellOutput");
        formatter.field("cell_arn", &self.cell_arn);
        formatter.field("cell_name", &self.cell_name);
        formatter.field("cells", &self.cells);
        formatter.field("parent_readiness_scopes", &self.parent_readiness_scopes);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`CellOutput`](crate::model::CellOutput)
pub mod cell_output {
    /// A builder for [`CellOutput`](crate::model::CellOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cell_arn: std::option::Option<std::string::String>,
        pub(crate) cell_name: std::option::Option<std::string::String>,
        pub(crate) cells: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) parent_readiness_scopes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the cell.</p>
        pub fn cell_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cell_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the cell.</p>
        pub fn set_cell_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cell_arn = input;
            self
        }
        /// <p>The name of the cell.</p>
        pub fn cell_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cell_name = Some(input.into());
            self
        }
        /// <p>The name of the cell.</p>
        pub fn set_cell_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cell_name = input;
            self
        }
        /// Appends an item to `cells`.
        ///
        /// To override the contents of this collection use [`set_cells`](Self::set_cells).
        ///
        /// <p>A list of cell ARNs.</p>
        pub fn cells(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cells.unwrap_or_default();
            v.push(input.into());
            self.cells = Some(v);
            self
        }
        /// <p>A list of cell ARNs.</p>
        pub fn set_cells(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cells = input;
            self
        }
        /// Appends an item to `parent_readiness_scopes`.
        ///
        /// To override the contents of this collection use [`set_parent_readiness_scopes`](Self::set_parent_readiness_scopes).
        ///
        /// <p>The readiness scope for the cell, which can be a cell Amazon Resource Name (ARN) or a recovery group ARN. This is a list but currently can have only one element.</p>
        pub fn parent_readiness_scopes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.parent_readiness_scopes.unwrap_or_default();
            v.push(input.into());
            self.parent_readiness_scopes = Some(v);
            self
        }
        /// <p>The readiness scope for the cell, which can be a cell Amazon Resource Name (ARN) or a recovery group ARN. This is a list but currently can have only one element.</p>
        pub fn set_parent_readiness_scopes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.parent_readiness_scopes = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags on the resources.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags on the resources.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CellOutput`](crate::model::CellOutput)
        pub fn build(self) -> crate::model::CellOutput {
            crate::model::CellOutput {
                cell_arn: self.cell_arn,
                cell_name: self.cell_name,
                cells: self.cells,
                parent_readiness_scopes: self.parent_readiness_scopes,
                tags: self.tags,
            }
        }
    }
}
impl CellOutput {
    /// Creates a new builder-style object to manufacture [`CellOutput`](crate::model::CellOutput)
    pub fn builder() -> crate::model::cell_output::Builder {
        crate::model::cell_output::Builder::default()
    }
}

/// <p>Summary of all readiness check statuses in a recovery group, paginated in GetRecoveryGroupReadinessSummary and GetCellReadinessSummary.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReadinessCheckSummary {
    /// <p>The readiness status of this readiness check.</p>
    pub readiness: std::option::Option<crate::model::Readiness>,
    /// <p>The name of a readiness check.</p>
    pub readiness_check_name: std::option::Option<std::string::String>,
}
impl ReadinessCheckSummary {
    /// <p>The readiness status of this readiness check.</p>
    pub fn readiness(&self) -> std::option::Option<&crate::model::Readiness> {
        self.readiness.as_ref()
    }
    /// <p>The name of a readiness check.</p>
    pub fn readiness_check_name(&self) -> std::option::Option<&str> {
        self.readiness_check_name.as_deref()
    }
}
impl std::fmt::Debug for ReadinessCheckSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReadinessCheckSummary");
        formatter.field("readiness", &self.readiness);
        formatter.field("readiness_check_name", &self.readiness_check_name);
        formatter.finish()
    }
}
/// See [`ReadinessCheckSummary`](crate::model::ReadinessCheckSummary)
pub mod readiness_check_summary {
    /// A builder for [`ReadinessCheckSummary`](crate::model::ReadinessCheckSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) readiness: std::option::Option<crate::model::Readiness>,
        pub(crate) readiness_check_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The readiness status of this readiness check.</p>
        pub fn readiness(mut self, input: crate::model::Readiness) -> Self {
            self.readiness = Some(input);
            self
        }
        /// <p>The readiness status of this readiness check.</p>
        pub fn set_readiness(
            mut self,
            input: std::option::Option<crate::model::Readiness>,
        ) -> Self {
            self.readiness = input;
            self
        }
        /// <p>The name of a readiness check.</p>
        pub fn readiness_check_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.readiness_check_name = Some(input.into());
            self
        }
        /// <p>The name of a readiness check.</p>
        pub fn set_readiness_check_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.readiness_check_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ReadinessCheckSummary`](crate::model::ReadinessCheckSummary)
        pub fn build(self) -> crate::model::ReadinessCheckSummary {
            crate::model::ReadinessCheckSummary {
                readiness: self.readiness,
                readiness_check_name: self.readiness_check_name,
            }
        }
    }
}
impl ReadinessCheckSummary {
    /// Creates a new builder-style object to manufacture [`ReadinessCheckSummary`](crate::model::ReadinessCheckSummary)
    pub fn builder() -> crate::model::readiness_check_summary::Builder {
        crate::model::readiness_check_summary::Builder::default()
    }
}

/// <p>The readiness status.</p>
///
/// _Note: `Readiness::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Readiness {
    #[allow(missing_docs)] // documentation missing in model
    NotAuthorized,
    #[allow(missing_docs)] // documentation missing in model
    NotReady,
    #[allow(missing_docs)] // documentation missing in model
    Ready,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Readiness {
    fn from(s: &str) -> Self {
        match s {
            "NOT_AUTHORIZED" => Readiness::NotAuthorized,
            "NOT_READY" => Readiness::NotReady,
            "READY" => Readiness::Ready,
            "UNKNOWN" => Readiness::UnknownValue,
            other => Readiness::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Readiness {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Readiness::from(s))
    }
}
impl Readiness {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Readiness::NotAuthorized => "NOT_AUTHORIZED",
            Readiness::NotReady => "NOT_READY",
            Readiness::Ready => "READY",
            Readiness::UnknownValue => "UNKNOWN",
            Readiness::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NOT_AUTHORIZED", "NOT_READY", "READY", "UNKNOWN"]
    }
}
impl AsRef<str> for Readiness {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The result of a successful Resource request, with status for an individual resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceResult {
    /// <p>The component id of the resource.</p>
    pub component_id: std::option::Option<std::string::String>,
    /// <p>The time (UTC) that the resource was last checked for readiness, in ISO-8601 format.</p>
    pub last_checked_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The readiness of a resource.</p>
    pub readiness: std::option::Option<crate::model::Readiness>,
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ResourceResult {
    /// <p>The component id of the resource.</p>
    pub fn component_id(&self) -> std::option::Option<&str> {
        self.component_id.as_deref()
    }
    /// <p>The time (UTC) that the resource was last checked for readiness, in ISO-8601 format.</p>
    pub fn last_checked_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_checked_timestamp.as_ref()
    }
    /// <p>The readiness of a resource.</p>
    pub fn readiness(&self) -> std::option::Option<&crate::model::Readiness> {
        self.readiness.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ResourceResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceResult");
        formatter.field("component_id", &self.component_id);
        formatter.field("last_checked_timestamp", &self.last_checked_timestamp);
        formatter.field("readiness", &self.readiness);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}
/// See [`ResourceResult`](crate::model::ResourceResult)
pub mod resource_result {
    /// A builder for [`ResourceResult`](crate::model::ResourceResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) component_id: std::option::Option<std::string::String>,
        pub(crate) last_checked_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) readiness: std::option::Option<crate::model::Readiness>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The component id of the resource.</p>
        pub fn component_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_id = Some(input.into());
            self
        }
        /// <p>The component id of the resource.</p>
        pub fn set_component_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.component_id = input;
            self
        }
        /// <p>The time (UTC) that the resource was last checked for readiness, in ISO-8601 format.</p>
        pub fn last_checked_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_checked_timestamp = Some(input);
            self
        }
        /// <p>The time (UTC) that the resource was last checked for readiness, in ISO-8601 format.</p>
        pub fn set_last_checked_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_checked_timestamp = input;
            self
        }
        /// <p>The readiness of a resource.</p>
        pub fn readiness(mut self, input: crate::model::Readiness) -> Self {
            self.readiness = Some(input);
            self
        }
        /// <p>The readiness of a resource.</p>
        pub fn set_readiness(
            mut self,
            input: std::option::Option<crate::model::Readiness>,
        ) -> Self {
            self.readiness = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceResult`](crate::model::ResourceResult)
        pub fn build(self) -> crate::model::ResourceResult {
            crate::model::ResourceResult {
                component_id: self.component_id,
                last_checked_timestamp: self.last_checked_timestamp,
                readiness: self.readiness,
                resource_arn: self.resource_arn,
            }
        }
    }
}
impl ResourceResult {
    /// Creates a new builder-style object to manufacture [`ResourceResult`](crate::model::ResourceResult)
    pub fn builder() -> crate::model::resource_result::Builder {
        crate::model::resource_result::Builder::default()
    }
}

/// <p>Information relating to readiness check status.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Message {
    /// <p>The text of a readiness check message.</p>
    pub message_text: std::option::Option<std::string::String>,
}
impl Message {
    /// <p>The text of a readiness check message.</p>
    pub fn message_text(&self) -> std::option::Option<&str> {
        self.message_text.as_deref()
    }
}
impl std::fmt::Debug for Message {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Message");
        formatter.field("message_text", &self.message_text);
        formatter.finish()
    }
}
/// See [`Message`](crate::model::Message)
pub mod message {
    /// A builder for [`Message`](crate::model::Message)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message_text: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The text of a readiness check message.</p>
        pub fn message_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_text = Some(input.into());
            self
        }
        /// <p>The text of a readiness check message.</p>
        pub fn set_message_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message_text = input;
            self
        }
        /// Consumes the builder and constructs a [`Message`](crate::model::Message)
        pub fn build(self) -> crate::model::Message {
            crate::model::Message {
                message_text: self.message_text,
            }
        }
    }
}
impl Message {
    /// Creates a new builder-style object to manufacture [`Message`](crate::model::Message)
    pub fn builder() -> crate::model::message::Builder {
        crate::model::message::Builder::default()
    }
}

/// <p>The result of a successful Rule request, with status for an individual rule.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RuleResult {
    /// <p>The time the resource was last checked for readiness, in ISO-8601 format, UTC.</p>
    pub last_checked_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Details about the resource's readiness.</p>
    pub messages: std::option::Option<std::vec::Vec<crate::model::Message>>,
    /// <p>The readiness at rule level.</p>
    pub readiness: std::option::Option<crate::model::Readiness>,
    /// <p>The identifier of the rule.</p>
    pub rule_id: std::option::Option<std::string::String>,
}
impl RuleResult {
    /// <p>The time the resource was last checked for readiness, in ISO-8601 format, UTC.</p>
    pub fn last_checked_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_checked_timestamp.as_ref()
    }
    /// <p>Details about the resource's readiness.</p>
    pub fn messages(&self) -> std::option::Option<&[crate::model::Message]> {
        self.messages.as_deref()
    }
    /// <p>The readiness at rule level.</p>
    pub fn readiness(&self) -> std::option::Option<&crate::model::Readiness> {
        self.readiness.as_ref()
    }
    /// <p>The identifier of the rule.</p>
    pub fn rule_id(&self) -> std::option::Option<&str> {
        self.rule_id.as_deref()
    }
}
impl std::fmt::Debug for RuleResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RuleResult");
        formatter.field("last_checked_timestamp", &self.last_checked_timestamp);
        formatter.field("messages", &self.messages);
        formatter.field("readiness", &self.readiness);
        formatter.field("rule_id", &self.rule_id);
        formatter.finish()
    }
}
/// See [`RuleResult`](crate::model::RuleResult)
pub mod rule_result {
    /// A builder for [`RuleResult`](crate::model::RuleResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) last_checked_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) messages: std::option::Option<std::vec::Vec<crate::model::Message>>,
        pub(crate) readiness: std::option::Option<crate::model::Readiness>,
        pub(crate) rule_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The time the resource was last checked for readiness, in ISO-8601 format, UTC.</p>
        pub fn last_checked_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_checked_timestamp = Some(input);
            self
        }
        /// <p>The time the resource was last checked for readiness, in ISO-8601 format, UTC.</p>
        pub fn set_last_checked_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_checked_timestamp = input;
            self
        }
        /// Appends an item to `messages`.
        ///
        /// To override the contents of this collection use [`set_messages`](Self::set_messages).
        ///
        /// <p>Details about the resource's readiness.</p>
        pub fn messages(mut self, input: crate::model::Message) -> Self {
            let mut v = self.messages.unwrap_or_default();
            v.push(input);
            self.messages = Some(v);
            self
        }
        /// <p>Details about the resource's readiness.</p>
        pub fn set_messages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Message>>,
        ) -> Self {
            self.messages = input;
            self
        }
        /// <p>The readiness at rule level.</p>
        pub fn readiness(mut self, input: crate::model::Readiness) -> Self {
            self.readiness = Some(input);
            self
        }
        /// <p>The readiness at rule level.</p>
        pub fn set_readiness(
            mut self,
            input: std::option::Option<crate::model::Readiness>,
        ) -> Self {
            self.readiness = input;
            self
        }
        /// <p>The identifier of the rule.</p>
        pub fn rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_id = Some(input.into());
            self
        }
        /// <p>The identifier of the rule.</p>
        pub fn set_rule_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.rule_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RuleResult`](crate::model::RuleResult)
        pub fn build(self) -> crate::model::RuleResult {
            crate::model::RuleResult {
                last_checked_timestamp: self.last_checked_timestamp,
                messages: self.messages,
                readiness: self.readiness,
                rule_id: self.rule_id,
            }
        }
    }
}
impl RuleResult {
    /// Creates a new builder-style object to manufacture [`RuleResult`](crate::model::RuleResult)
    pub fn builder() -> crate::model::rule_result::Builder {
        crate::model::rule_result::Builder::default()
    }
}

/// <p>Recommendations that are provided to make an application more recovery resilient.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Recommendation {
    /// <p>Text of the recommendations that are provided to make an application more recovery resilient.</p>
    pub recommendation_text: std::option::Option<std::string::String>,
}
impl Recommendation {
    /// <p>Text of the recommendations that are provided to make an application more recovery resilient.</p>
    pub fn recommendation_text(&self) -> std::option::Option<&str> {
        self.recommendation_text.as_deref()
    }
}
impl std::fmt::Debug for Recommendation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Recommendation");
        formatter.field("recommendation_text", &self.recommendation_text);
        formatter.finish()
    }
}
/// See [`Recommendation`](crate::model::Recommendation)
pub mod recommendation {
    /// A builder for [`Recommendation`](crate::model::Recommendation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recommendation_text: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Text of the recommendations that are provided to make an application more recovery resilient.</p>
        pub fn recommendation_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.recommendation_text = Some(input.into());
            self
        }
        /// <p>Text of the recommendations that are provided to make an application more recovery resilient.</p>
        pub fn set_recommendation_text(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommendation_text = input;
            self
        }
        /// Consumes the builder and constructs a [`Recommendation`](crate::model::Recommendation)
        pub fn build(self) -> crate::model::Recommendation {
            crate::model::Recommendation {
                recommendation_text: self.recommendation_text,
            }
        }
    }
}
impl Recommendation {
    /// Creates a new builder-style object to manufacture [`Recommendation`](crate::model::Recommendation)
    pub fn builder() -> crate::model::recommendation::Builder {
        crate::model::recommendation::Builder::default()
    }
}
