// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Route53 Recovery Readiness
///
/// Client for invoking operations on AWS Route53 Recovery Readiness. Each operation on AWS Route53 Recovery Readiness is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_route53recoveryreadiness::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_route53recoveryreadiness::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_route53recoveryreadiness::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CreateCell`](crate::client::fluent_builders::CreateCell) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cell_name(impl Into<String>)`](crate::client::fluent_builders::CreateCell::cell_name) / [`set_cell_name(Option<String>)`](crate::client::fluent_builders::CreateCell::set_cell_name): <p>The name of the cell to create.</p>
    ///   - [`cells(Vec<String>)`](crate::client::fluent_builders::CreateCell::cells) / [`set_cells(Option<Vec<String>>)`](crate::client::fluent_builders::CreateCell::set_cells): <p>A list of cell Amazon Resource Names (ARNs) contained within this cell, for use in nested cells. For example, Availability Zones within specific Amazon Web Services Regions.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateCell::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateCell::set_tags): <p>A collection of tags associated with a resource.</p>
    /// - On success, responds with [`CreateCellOutput`](crate::output::CreateCellOutput) with field(s):
    ///   - [`cell_arn(Option<String>)`](crate::output::CreateCellOutput::cell_arn): <p>The Amazon Resource Name (ARN) for the cell.</p>
    ///   - [`cell_name(Option<String>)`](crate::output::CreateCellOutput::cell_name): <p>The name of the cell.</p>
    ///   - [`cells(Option<Vec<String>>)`](crate::output::CreateCellOutput::cells): <p>A list of cell ARNs.</p>
    ///   - [`parent_readiness_scopes(Option<Vec<String>>)`](crate::output::CreateCellOutput::parent_readiness_scopes): <p>The readiness scope for the cell, which can be a cell Amazon Resource Name (ARN) or a recovery group ARN. This is a list but currently can have only one element.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::CreateCellOutput::tags): <p>Tags on the resources.</p>
    /// - On failure, responds with [`SdkError<CreateCellError>`](crate::error::CreateCellError)
    pub fn create_cell(&self) -> fluent_builders::CreateCell {
        fluent_builders::CreateCell::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateCrossAccountAuthorization`](crate::client::fluent_builders::CreateCrossAccountAuthorization) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cross_account_authorization(impl Into<String>)`](crate::client::fluent_builders::CreateCrossAccountAuthorization::cross_account_authorization) / [`set_cross_account_authorization(Option<String>)`](crate::client::fluent_builders::CreateCrossAccountAuthorization::set_cross_account_authorization): <p>The cross-account authorization.</p>
    /// - On success, responds with [`CreateCrossAccountAuthorizationOutput`](crate::output::CreateCrossAccountAuthorizationOutput) with field(s):
    ///   - [`cross_account_authorization(Option<String>)`](crate::output::CreateCrossAccountAuthorizationOutput::cross_account_authorization): <p>The cross-account authorization.</p>
    /// - On failure, responds with [`SdkError<CreateCrossAccountAuthorizationError>`](crate::error::CreateCrossAccountAuthorizationError)
    pub fn create_cross_account_authorization(
        &self,
    ) -> fluent_builders::CreateCrossAccountAuthorization {
        fluent_builders::CreateCrossAccountAuthorization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateReadinessCheck`](crate::client::fluent_builders::CreateReadinessCheck) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`readiness_check_name(impl Into<String>)`](crate::client::fluent_builders::CreateReadinessCheck::readiness_check_name) / [`set_readiness_check_name(Option<String>)`](crate::client::fluent_builders::CreateReadinessCheck::set_readiness_check_name): <p>The name of the readiness check to create.</p>
    ///   - [`resource_set_name(impl Into<String>)`](crate::client::fluent_builders::CreateReadinessCheck::resource_set_name) / [`set_resource_set_name(Option<String>)`](crate::client::fluent_builders::CreateReadinessCheck::set_resource_set_name): <p>The name of the resource set to check.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateReadinessCheck::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateReadinessCheck::set_tags): <p>A collection of tags associated with a resource.</p>
    /// - On success, responds with [`CreateReadinessCheckOutput`](crate::output::CreateReadinessCheckOutput) with field(s):
    ///   - [`readiness_check_arn(Option<String>)`](crate::output::CreateReadinessCheckOutput::readiness_check_arn): <p>The Amazon Resource Name (ARN) associated with a readiness check.</p>
    ///   - [`readiness_check_name(Option<String>)`](crate::output::CreateReadinessCheckOutput::readiness_check_name): <p>Name of a readiness check.</p>
    ///   - [`resource_set(Option<String>)`](crate::output::CreateReadinessCheckOutput::resource_set): <p>Name of the resource set to be checked.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::CreateReadinessCheckOutput::tags): <p>A collection of tags associated with a resource.</p>
    /// - On failure, responds with [`SdkError<CreateReadinessCheckError>`](crate::error::CreateReadinessCheckError)
    pub fn create_readiness_check(&self) -> fluent_builders::CreateReadinessCheck {
        fluent_builders::CreateReadinessCheck::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateRecoveryGroup`](crate::client::fluent_builders::CreateRecoveryGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cells(Vec<String>)`](crate::client::fluent_builders::CreateRecoveryGroup::cells) / [`set_cells(Option<Vec<String>>)`](crate::client::fluent_builders::CreateRecoveryGroup::set_cells): <p>A list of the cell Amazon Resource Names (ARNs) in the recovery group.</p>
    ///   - [`recovery_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateRecoveryGroup::recovery_group_name) / [`set_recovery_group_name(Option<String>)`](crate::client::fluent_builders::CreateRecoveryGroup::set_recovery_group_name): <p>The name of the recovery group to create.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateRecoveryGroup::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateRecoveryGroup::set_tags): <p>A collection of tags associated with a resource.</p>
    /// - On success, responds with [`CreateRecoveryGroupOutput`](crate::output::CreateRecoveryGroupOutput) with field(s):
    ///   - [`cells(Option<Vec<String>>)`](crate::output::CreateRecoveryGroupOutput::cells): <p>A list of a cell's Amazon Resource Names (ARNs).</p>
    ///   - [`recovery_group_arn(Option<String>)`](crate::output::CreateRecoveryGroupOutput::recovery_group_arn): <p>The Amazon Resource Name (ARN) for the recovery group.</p>
    ///   - [`recovery_group_name(Option<String>)`](crate::output::CreateRecoveryGroupOutput::recovery_group_name): <p>The name of the recovery group.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::CreateRecoveryGroupOutput::tags): <p>The tags associated with the recovery group.</p>
    /// - On failure, responds with [`SdkError<CreateRecoveryGroupError>`](crate::error::CreateRecoveryGroupError)
    pub fn create_recovery_group(&self) -> fluent_builders::CreateRecoveryGroup {
        fluent_builders::CreateRecoveryGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateResourceSet`](crate::client::fluent_builders::CreateResourceSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_set_name(impl Into<String>)`](crate::client::fluent_builders::CreateResourceSet::resource_set_name) / [`set_resource_set_name(Option<String>)`](crate::client::fluent_builders::CreateResourceSet::set_resource_set_name): <p>The name of the resource set to create.</p>
    ///   - [`resource_set_type(impl Into<String>)`](crate::client::fluent_builders::CreateResourceSet::resource_set_type) / [`set_resource_set_type(Option<String>)`](crate::client::fluent_builders::CreateResourceSet::set_resource_set_type): <p>The resource type of the resources in the resource set. Enter one of the following values for resource type:</p>  <p>AWS::ApiGateway::Stage, AWS::ApiGatewayV2::Stage, AWS::AutoScaling::AutoScalingGroup, AWS::CloudWatch::Alarm, AWS::EC2::CustomerGateway, AWS::DynamoDB::Table, AWS::EC2::Volume, AWS::ElasticLoadBalancing::LoadBalancer, AWS::ElasticLoadBalancingV2::LoadBalancer, AWS::Lambda::Function, AWS::MSK::Cluster, AWS::RDS::DBCluster, AWS::Route53::HealthCheck, AWS::SQS::Queue, AWS::SNS::Topic, AWS::SNS::Subscription, AWS::EC2::VPC, AWS::EC2::VPNConnection, AWS::EC2::VPNGateway, AWS::Route53RecoveryReadiness::DNSTargetResource</p>
    ///   - [`resources(Vec<Resource>)`](crate::client::fluent_builders::CreateResourceSet::resources) / [`set_resources(Option<Vec<Resource>>)`](crate::client::fluent_builders::CreateResourceSet::set_resources): <p>A list of resource objects in the resource set.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateResourceSet::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateResourceSet::set_tags): <p>A tag to associate with the parameters for a resource set.</p>
    /// - On success, responds with [`CreateResourceSetOutput`](crate::output::CreateResourceSetOutput) with field(s):
    ///   - [`resource_set_arn(Option<String>)`](crate::output::CreateResourceSetOutput::resource_set_arn): <p>The Amazon Resource Name (ARN) for the resource set.</p>
    ///   - [`resource_set_name(Option<String>)`](crate::output::CreateResourceSetOutput::resource_set_name): <p>The name of the resource set.</p>
    ///   - [`resource_set_type(Option<String>)`](crate::output::CreateResourceSetOutput::resource_set_type): <p>The resource type of the resources in the resource set. Enter one of the following values for resource type:</p>  <p>AWS::ApiGateway::Stage, AWS::ApiGatewayV2::Stage, AWS::AutoScaling::AutoScalingGroup, AWS::CloudWatch::Alarm, AWS::EC2::CustomerGateway, AWS::DynamoDB::Table, AWS::EC2::Volume, AWS::ElasticLoadBalancing::LoadBalancer, AWS::ElasticLoadBalancingV2::LoadBalancer, AWS::Lambda::Function, AWS::MSK::Cluster, AWS::RDS::DBCluster, AWS::Route53::HealthCheck, AWS::SQS::Queue, AWS::SNS::Topic, AWS::SNS::Subscription, AWS::EC2::VPC, AWS::EC2::VPNConnection, AWS::EC2::VPNGateway, AWS::Route53RecoveryReadiness::DNSTargetResource</p>
    ///   - [`resources(Option<Vec<Resource>>)`](crate::output::CreateResourceSetOutput::resources): <p>A list of resource objects.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::CreateResourceSetOutput::tags): <p>A collection of tags associated with a resource.</p>
    /// - On failure, responds with [`SdkError<CreateResourceSetError>`](crate::error::CreateResourceSetError)
    pub fn create_resource_set(&self) -> fluent_builders::CreateResourceSet {
        fluent_builders::CreateResourceSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCell`](crate::client::fluent_builders::DeleteCell) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cell_name(impl Into<String>)`](crate::client::fluent_builders::DeleteCell::cell_name) / [`set_cell_name(Option<String>)`](crate::client::fluent_builders::DeleteCell::set_cell_name): <p>The name of the cell.</p>
    /// - On success, responds with [`DeleteCellOutput`](crate::output::DeleteCellOutput)

    /// - On failure, responds with [`SdkError<DeleteCellError>`](crate::error::DeleteCellError)
    pub fn delete_cell(&self) -> fluent_builders::DeleteCell {
        fluent_builders::DeleteCell::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCrossAccountAuthorization`](crate::client::fluent_builders::DeleteCrossAccountAuthorization) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cross_account_authorization(impl Into<String>)`](crate::client::fluent_builders::DeleteCrossAccountAuthorization::cross_account_authorization) / [`set_cross_account_authorization(Option<String>)`](crate::client::fluent_builders::DeleteCrossAccountAuthorization::set_cross_account_authorization): <p>The cross-account authorization.</p>
    /// - On success, responds with [`DeleteCrossAccountAuthorizationOutput`](crate::output::DeleteCrossAccountAuthorizationOutput)

    /// - On failure, responds with [`SdkError<DeleteCrossAccountAuthorizationError>`](crate::error::DeleteCrossAccountAuthorizationError)
    pub fn delete_cross_account_authorization(
        &self,
    ) -> fluent_builders::DeleteCrossAccountAuthorization {
        fluent_builders::DeleteCrossAccountAuthorization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteReadinessCheck`](crate::client::fluent_builders::DeleteReadinessCheck) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`readiness_check_name(impl Into<String>)`](crate::client::fluent_builders::DeleteReadinessCheck::readiness_check_name) / [`set_readiness_check_name(Option<String>)`](crate::client::fluent_builders::DeleteReadinessCheck::set_readiness_check_name): <p>Name of a readiness check.</p>
    /// - On success, responds with [`DeleteReadinessCheckOutput`](crate::output::DeleteReadinessCheckOutput)

    /// - On failure, responds with [`SdkError<DeleteReadinessCheckError>`](crate::error::DeleteReadinessCheckError)
    pub fn delete_readiness_check(&self) -> fluent_builders::DeleteReadinessCheck {
        fluent_builders::DeleteReadinessCheck::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRecoveryGroup`](crate::client::fluent_builders::DeleteRecoveryGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`recovery_group_name(impl Into<String>)`](crate::client::fluent_builders::DeleteRecoveryGroup::recovery_group_name) / [`set_recovery_group_name(Option<String>)`](crate::client::fluent_builders::DeleteRecoveryGroup::set_recovery_group_name): <p>The name of a recovery group.</p>
    /// - On success, responds with [`DeleteRecoveryGroupOutput`](crate::output::DeleteRecoveryGroupOutput)

    /// - On failure, responds with [`SdkError<DeleteRecoveryGroupError>`](crate::error::DeleteRecoveryGroupError)
    pub fn delete_recovery_group(&self) -> fluent_builders::DeleteRecoveryGroup {
        fluent_builders::DeleteRecoveryGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteResourceSet`](crate::client::fluent_builders::DeleteResourceSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_set_name(impl Into<String>)`](crate::client::fluent_builders::DeleteResourceSet::resource_set_name) / [`set_resource_set_name(Option<String>)`](crate::client::fluent_builders::DeleteResourceSet::set_resource_set_name): <p>Name of a resource set.</p>
    /// - On success, responds with [`DeleteResourceSetOutput`](crate::output::DeleteResourceSetOutput)

    /// - On failure, responds with [`SdkError<DeleteResourceSetError>`](crate::error::DeleteResourceSetError)
    pub fn delete_resource_set(&self) -> fluent_builders::DeleteResourceSet {
        fluent_builders::DeleteResourceSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetArchitectureRecommendations`](crate::client::fluent_builders::GetArchitectureRecommendations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetArchitectureRecommendations::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::GetArchitectureRecommendations::set_max_results): <p>The number of objects that you want to return with this call.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetArchitectureRecommendations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetArchitectureRecommendations::set_next_token): <p>The token that identifies which batch of results you want to see.</p>
    ///   - [`recovery_group_name(impl Into<String>)`](crate::client::fluent_builders::GetArchitectureRecommendations::recovery_group_name) / [`set_recovery_group_name(Option<String>)`](crate::client::fluent_builders::GetArchitectureRecommendations::set_recovery_group_name): <p>The name of a recovery group.</p>
    /// - On success, responds with [`GetArchitectureRecommendationsOutput`](crate::output::GetArchitectureRecommendationsOutput) with field(s):
    ///   - [`last_audit_timestamp(Option<DateTime>)`](crate::output::GetArchitectureRecommendationsOutput::last_audit_timestamp): <p>The time that a recovery group was last assessed for recommendations, in UTC ISO-8601 format.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetArchitectureRecommendationsOutput::next_token): <p>The token that identifies which batch of results you want to see.</p>
    ///   - [`recommendations(Option<Vec<Recommendation>>)`](crate::output::GetArchitectureRecommendationsOutput::recommendations): <p>A list of the recommendations for the customer's application.</p>
    /// - On failure, responds with [`SdkError<GetArchitectureRecommendationsError>`](crate::error::GetArchitectureRecommendationsError)
    pub fn get_architecture_recommendations(
        &self,
    ) -> fluent_builders::GetArchitectureRecommendations {
        fluent_builders::GetArchitectureRecommendations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCell`](crate::client::fluent_builders::GetCell) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cell_name(impl Into<String>)`](crate::client::fluent_builders::GetCell::cell_name) / [`set_cell_name(Option<String>)`](crate::client::fluent_builders::GetCell::set_cell_name): <p>The name of the cell.</p>
    /// - On success, responds with [`GetCellOutput`](crate::output::GetCellOutput) with field(s):
    ///   - [`cell_arn(Option<String>)`](crate::output::GetCellOutput::cell_arn): <p>The Amazon Resource Name (ARN) for the cell.</p>
    ///   - [`cell_name(Option<String>)`](crate::output::GetCellOutput::cell_name): <p>The name of the cell.</p>
    ///   - [`cells(Option<Vec<String>>)`](crate::output::GetCellOutput::cells): <p>A list of cell ARNs.</p>
    ///   - [`parent_readiness_scopes(Option<Vec<String>>)`](crate::output::GetCellOutput::parent_readiness_scopes): <p>The readiness scope for the cell, which can be a cell Amazon Resource Name (ARN) or a recovery group ARN. This is a list but currently can have only one element.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetCellOutput::tags): <p>Tags on the resources.</p>
    /// - On failure, responds with [`SdkError<GetCellError>`](crate::error::GetCellError)
    pub fn get_cell(&self) -> fluent_builders::GetCell {
        fluent_builders::GetCell::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCellReadinessSummary`](crate::client::fluent_builders::GetCellReadinessSummary) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetCellReadinessSummary::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`cell_name(impl Into<String>)`](crate::client::fluent_builders::GetCellReadinessSummary::cell_name) / [`set_cell_name(Option<String>)`](crate::client::fluent_builders::GetCellReadinessSummary::set_cell_name): <p>The name of the cell.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetCellReadinessSummary::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::GetCellReadinessSummary::set_max_results): <p>The number of objects that you want to return with this call.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetCellReadinessSummary::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetCellReadinessSummary::set_next_token): <p>The token that identifies which batch of results you want to see.</p>
    /// - On success, responds with [`GetCellReadinessSummaryOutput`](crate::output::GetCellReadinessSummaryOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::GetCellReadinessSummaryOutput::next_token): <p>The token that identifies which batch of results you want to see.</p>
    ///   - [`readiness(Option<Readiness>)`](crate::output::GetCellReadinessSummaryOutput::readiness): <p>The readiness at a cell level.</p>
    ///   - [`readiness_checks(Option<Vec<ReadinessCheckSummary>>)`](crate::output::GetCellReadinessSummaryOutput::readiness_checks): <p>Summaries for the readiness checks that make up the cell.</p>
    /// - On failure, responds with [`SdkError<GetCellReadinessSummaryError>`](crate::error::GetCellReadinessSummaryError)
    pub fn get_cell_readiness_summary(&self) -> fluent_builders::GetCellReadinessSummary {
        fluent_builders::GetCellReadinessSummary::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetReadinessCheck`](crate::client::fluent_builders::GetReadinessCheck) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`readiness_check_name(impl Into<String>)`](crate::client::fluent_builders::GetReadinessCheck::readiness_check_name) / [`set_readiness_check_name(Option<String>)`](crate::client::fluent_builders::GetReadinessCheck::set_readiness_check_name): <p>Name of a readiness check.</p>
    /// - On success, responds with [`GetReadinessCheckOutput`](crate::output::GetReadinessCheckOutput) with field(s):
    ///   - [`readiness_check_arn(Option<String>)`](crate::output::GetReadinessCheckOutput::readiness_check_arn): <p>The Amazon Resource Name (ARN) associated with a readiness check.</p>
    ///   - [`readiness_check_name(Option<String>)`](crate::output::GetReadinessCheckOutput::readiness_check_name): <p>Name of a readiness check.</p>
    ///   - [`resource_set(Option<String>)`](crate::output::GetReadinessCheckOutput::resource_set): <p>Name of the resource set to be checked.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetReadinessCheckOutput::tags): <p>A collection of tags associated with a resource.</p>
    /// - On failure, responds with [`SdkError<GetReadinessCheckError>`](crate::error::GetReadinessCheckError)
    pub fn get_readiness_check(&self) -> fluent_builders::GetReadinessCheck {
        fluent_builders::GetReadinessCheck::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetReadinessCheckResourceStatus`](crate::client::fluent_builders::GetReadinessCheckResourceStatus) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetReadinessCheckResourceStatus::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetReadinessCheckResourceStatus::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::GetReadinessCheckResourceStatus::set_max_results): <p>The number of objects that you want to return with this call.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetReadinessCheckResourceStatus::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetReadinessCheckResourceStatus::set_next_token): <p>The token that identifies which batch of results you want to see.</p>
    ///   - [`readiness_check_name(impl Into<String>)`](crate::client::fluent_builders::GetReadinessCheckResourceStatus::readiness_check_name) / [`set_readiness_check_name(Option<String>)`](crate::client::fluent_builders::GetReadinessCheckResourceStatus::set_readiness_check_name): <p>Name of a readiness check.</p>
    ///   - [`resource_identifier(impl Into<String>)`](crate::client::fluent_builders::GetReadinessCheckResourceStatus::resource_identifier) / [`set_resource_identifier(Option<String>)`](crate::client::fluent_builders::GetReadinessCheckResourceStatus::set_resource_identifier): <p>The resource identifier, which is the Amazon Resource Name (ARN) or the identifier generated for the resource by Application Recovery Controller (for example, for a DNS target resource).</p>
    /// - On success, responds with [`GetReadinessCheckResourceStatusOutput`](crate::output::GetReadinessCheckResourceStatusOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::GetReadinessCheckResourceStatusOutput::next_token): <p>The token that identifies which batch of results you want to see.</p>
    ///   - [`readiness(Option<Readiness>)`](crate::output::GetReadinessCheckResourceStatusOutput::readiness): <p>The readiness at a rule level.</p>
    ///   - [`rules(Option<Vec<RuleResult>>)`](crate::output::GetReadinessCheckResourceStatusOutput::rules): <p>Details of the rule's results.</p>
    /// - On failure, responds with [`SdkError<GetReadinessCheckResourceStatusError>`](crate::error::GetReadinessCheckResourceStatusError)
    pub fn get_readiness_check_resource_status(
        &self,
    ) -> fluent_builders::GetReadinessCheckResourceStatus {
        fluent_builders::GetReadinessCheckResourceStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetReadinessCheckStatus`](crate::client::fluent_builders::GetReadinessCheckStatus) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetReadinessCheckStatus::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetReadinessCheckStatus::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::GetReadinessCheckStatus::set_max_results): <p>The number of objects that you want to return with this call.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetReadinessCheckStatus::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetReadinessCheckStatus::set_next_token): <p>The token that identifies which batch of results you want to see.</p>
    ///   - [`readiness_check_name(impl Into<String>)`](crate::client::fluent_builders::GetReadinessCheckStatus::readiness_check_name) / [`set_readiness_check_name(Option<String>)`](crate::client::fluent_builders::GetReadinessCheckStatus::set_readiness_check_name): <p>Name of a readiness check.</p>
    /// - On success, responds with [`GetReadinessCheckStatusOutput`](crate::output::GetReadinessCheckStatusOutput) with field(s):
    ///   - [`messages(Option<Vec<Message>>)`](crate::output::GetReadinessCheckStatusOutput::messages): <p>Top level messages for readiness check status</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetReadinessCheckStatusOutput::next_token): <p>The token that identifies which batch of results you want to see.</p>
    ///   - [`readiness(Option<Readiness>)`](crate::output::GetReadinessCheckStatusOutput::readiness): <p>The readiness at rule level.</p>
    ///   - [`resources(Option<Vec<ResourceResult>>)`](crate::output::GetReadinessCheckStatusOutput::resources): <p>Summary of the readiness of resources.</p>
    /// - On failure, responds with [`SdkError<GetReadinessCheckStatusError>`](crate::error::GetReadinessCheckStatusError)
    pub fn get_readiness_check_status(&self) -> fluent_builders::GetReadinessCheckStatus {
        fluent_builders::GetReadinessCheckStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRecoveryGroup`](crate::client::fluent_builders::GetRecoveryGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`recovery_group_name(impl Into<String>)`](crate::client::fluent_builders::GetRecoveryGroup::recovery_group_name) / [`set_recovery_group_name(Option<String>)`](crate::client::fluent_builders::GetRecoveryGroup::set_recovery_group_name): <p>The name of a recovery group.</p>
    /// - On success, responds with [`GetRecoveryGroupOutput`](crate::output::GetRecoveryGroupOutput) with field(s):
    ///   - [`cells(Option<Vec<String>>)`](crate::output::GetRecoveryGroupOutput::cells): <p>A list of a cell's Amazon Resource Names (ARNs).</p>
    ///   - [`recovery_group_arn(Option<String>)`](crate::output::GetRecoveryGroupOutput::recovery_group_arn): <p>The Amazon Resource Name (ARN) for the recovery group.</p>
    ///   - [`recovery_group_name(Option<String>)`](crate::output::GetRecoveryGroupOutput::recovery_group_name): <p>The name of the recovery group.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetRecoveryGroupOutput::tags): <p>The tags associated with the recovery group.</p>
    /// - On failure, responds with [`SdkError<GetRecoveryGroupError>`](crate::error::GetRecoveryGroupError)
    pub fn get_recovery_group(&self) -> fluent_builders::GetRecoveryGroup {
        fluent_builders::GetRecoveryGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRecoveryGroupReadinessSummary`](crate::client::fluent_builders::GetRecoveryGroupReadinessSummary) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetRecoveryGroupReadinessSummary::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetRecoveryGroupReadinessSummary::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::GetRecoveryGroupReadinessSummary::set_max_results): <p>The number of objects that you want to return with this call.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetRecoveryGroupReadinessSummary::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetRecoveryGroupReadinessSummary::set_next_token): <p>The token that identifies which batch of results you want to see.</p>
    ///   - [`recovery_group_name(impl Into<String>)`](crate::client::fluent_builders::GetRecoveryGroupReadinessSummary::recovery_group_name) / [`set_recovery_group_name(Option<String>)`](crate::client::fluent_builders::GetRecoveryGroupReadinessSummary::set_recovery_group_name): <p>The name of a recovery group.</p>
    /// - On success, responds with [`GetRecoveryGroupReadinessSummaryOutput`](crate::output::GetRecoveryGroupReadinessSummaryOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::GetRecoveryGroupReadinessSummaryOutput::next_token): <p>The token that identifies which batch of results you want to see.</p>
    ///   - [`readiness(Option<Readiness>)`](crate::output::GetRecoveryGroupReadinessSummaryOutput::readiness): <p>The readiness status at a recovery group level.</p>
    ///   - [`readiness_checks(Option<Vec<ReadinessCheckSummary>>)`](crate::output::GetRecoveryGroupReadinessSummaryOutput::readiness_checks): <p>Summaries of the readiness checks for the recovery group.</p>
    /// - On failure, responds with [`SdkError<GetRecoveryGroupReadinessSummaryError>`](crate::error::GetRecoveryGroupReadinessSummaryError)
    pub fn get_recovery_group_readiness_summary(
        &self,
    ) -> fluent_builders::GetRecoveryGroupReadinessSummary {
        fluent_builders::GetRecoveryGroupReadinessSummary::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetResourceSet`](crate::client::fluent_builders::GetResourceSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_set_name(impl Into<String>)`](crate::client::fluent_builders::GetResourceSet::resource_set_name) / [`set_resource_set_name(Option<String>)`](crate::client::fluent_builders::GetResourceSet::set_resource_set_name): <p>Name of a resource set.</p>
    /// - On success, responds with [`GetResourceSetOutput`](crate::output::GetResourceSetOutput) with field(s):
    ///   - [`resource_set_arn(Option<String>)`](crate::output::GetResourceSetOutput::resource_set_arn): <p>The Amazon Resource Name (ARN) for the resource set.</p>
    ///   - [`resource_set_name(Option<String>)`](crate::output::GetResourceSetOutput::resource_set_name): <p>The name of the resource set.</p>
    ///   - [`resource_set_type(Option<String>)`](crate::output::GetResourceSetOutput::resource_set_type): <p>The resource type of the resources in the resource set. Enter one of the following values for resource type:</p>  <p>AWS::ApiGateway::Stage, AWS::ApiGatewayV2::Stage, AWS::AutoScaling::AutoScalingGroup, AWS::CloudWatch::Alarm, AWS::EC2::CustomerGateway, AWS::DynamoDB::Table, AWS::EC2::Volume, AWS::ElasticLoadBalancing::LoadBalancer, AWS::ElasticLoadBalancingV2::LoadBalancer, AWS::Lambda::Function, AWS::MSK::Cluster, AWS::RDS::DBCluster, AWS::Route53::HealthCheck, AWS::SQS::Queue, AWS::SNS::Topic, AWS::SNS::Subscription, AWS::EC2::VPC, AWS::EC2::VPNConnection, AWS::EC2::VPNGateway, AWS::Route53RecoveryReadiness::DNSTargetResource</p>
    ///   - [`resources(Option<Vec<Resource>>)`](crate::output::GetResourceSetOutput::resources): <p>A list of resource objects.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetResourceSetOutput::tags): <p>A collection of tags associated with a resource.</p>
    /// - On failure, responds with [`SdkError<GetResourceSetError>`](crate::error::GetResourceSetError)
    pub fn get_resource_set(&self) -> fluent_builders::GetResourceSet {
        fluent_builders::GetResourceSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListCells`](crate::client::fluent_builders::ListCells) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListCells::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListCells::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListCells::set_max_results): <p>The number of objects that you want to return with this call.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListCells::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListCells::set_next_token): <p>The token that identifies which batch of results you want to see.</p>
    /// - On success, responds with [`ListCellsOutput`](crate::output::ListCellsOutput) with field(s):
    ///   - [`cells(Option<Vec<CellOutput>>)`](crate::output::ListCellsOutput::cells): <p>A list of cells.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListCellsOutput::next_token): <p>The token that identifies which batch of results you want to see.</p>
    /// - On failure, responds with [`SdkError<ListCellsError>`](crate::error::ListCellsError)
    pub fn list_cells(&self) -> fluent_builders::ListCells {
        fluent_builders::ListCells::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListCrossAccountAuthorizations`](crate::client::fluent_builders::ListCrossAccountAuthorizations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListCrossAccountAuthorizations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListCrossAccountAuthorizations::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListCrossAccountAuthorizations::set_max_results): <p>The number of objects that you want to return with this call.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListCrossAccountAuthorizations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListCrossAccountAuthorizations::set_next_token): <p>The token that identifies which batch of results you want to see.</p>
    /// - On success, responds with [`ListCrossAccountAuthorizationsOutput`](crate::output::ListCrossAccountAuthorizationsOutput) with field(s):
    ///   - [`cross_account_authorizations(Option<Vec<String>>)`](crate::output::ListCrossAccountAuthorizationsOutput::cross_account_authorizations): <p>A list of cross-account authorizations.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListCrossAccountAuthorizationsOutput::next_token): <p>The token that identifies which batch of results you want to see.</p>
    /// - On failure, responds with [`SdkError<ListCrossAccountAuthorizationsError>`](crate::error::ListCrossAccountAuthorizationsError)
    pub fn list_cross_account_authorizations(
        &self,
    ) -> fluent_builders::ListCrossAccountAuthorizations {
        fluent_builders::ListCrossAccountAuthorizations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListReadinessChecks`](crate::client::fluent_builders::ListReadinessChecks) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListReadinessChecks::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListReadinessChecks::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListReadinessChecks::set_max_results): <p>The number of objects that you want to return with this call.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListReadinessChecks::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListReadinessChecks::set_next_token): <p>The token that identifies which batch of results you want to see.</p>
    /// - On success, responds with [`ListReadinessChecksOutput`](crate::output::ListReadinessChecksOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListReadinessChecksOutput::next_token): <p>The token that identifies which batch of results you want to see.</p>
    ///   - [`readiness_checks(Option<Vec<ReadinessCheckOutput>>)`](crate::output::ListReadinessChecksOutput::readiness_checks): <p>A list of readiness checks associated with the account.</p>
    /// - On failure, responds with [`SdkError<ListReadinessChecksError>`](crate::error::ListReadinessChecksError)
    pub fn list_readiness_checks(&self) -> fluent_builders::ListReadinessChecks {
        fluent_builders::ListReadinessChecks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRecoveryGroups`](crate::client::fluent_builders::ListRecoveryGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListRecoveryGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListRecoveryGroups::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListRecoveryGroups::set_max_results): <p>The number of objects that you want to return with this call.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListRecoveryGroups::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListRecoveryGroups::set_next_token): <p>The token that identifies which batch of results you want to see.</p>
    /// - On success, responds with [`ListRecoveryGroupsOutput`](crate::output::ListRecoveryGroupsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListRecoveryGroupsOutput::next_token): <p>The token that identifies which batch of results you want to see.</p>
    ///   - [`recovery_groups(Option<Vec<RecoveryGroupOutput>>)`](crate::output::ListRecoveryGroupsOutput::recovery_groups): <p>A list of recovery groups.</p>
    /// - On failure, responds with [`SdkError<ListRecoveryGroupsError>`](crate::error::ListRecoveryGroupsError)
    pub fn list_recovery_groups(&self) -> fluent_builders::ListRecoveryGroups {
        fluent_builders::ListRecoveryGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListResourceSets`](crate::client::fluent_builders::ListResourceSets) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListResourceSets::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListResourceSets::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListResourceSets::set_max_results): <p>The number of objects that you want to return with this call.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListResourceSets::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListResourceSets::set_next_token): <p>The token that identifies which batch of results you want to see.</p>
    /// - On success, responds with [`ListResourceSetsOutput`](crate::output::ListResourceSetsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListResourceSetsOutput::next_token): <p>The token that identifies which batch of results you want to see.</p>
    ///   - [`resource_sets(Option<Vec<ResourceSetOutput>>)`](crate::output::ListResourceSetsOutput::resource_sets): <p>A list of resource sets associated with the account.</p>
    /// - On failure, responds with [`SdkError<ListResourceSetsError>`](crate::error::ListResourceSetsError)
    pub fn list_resource_sets(&self) -> fluent_builders::ListResourceSets {
        fluent_builders::ListResourceSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRules`](crate::client::fluent_builders::ListRules) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListRules::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListRules::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListRules::set_max_results): <p>The number of objects that you want to return with this call.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListRules::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListRules::set_next_token): <p>The token that identifies which batch of results you want to see.</p>
    ///   - [`resource_type(impl Into<String>)`](crate::client::fluent_builders::ListRules::resource_type) / [`set_resource_type(Option<String>)`](crate::client::fluent_builders::ListRules::set_resource_type): <p>The resource type that a readiness rule applies to.</p>
    /// - On success, responds with [`ListRulesOutput`](crate::output::ListRulesOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListRulesOutput::next_token): <p>The token that identifies which batch of results you want to see.</p>
    ///   - [`rules(Option<Vec<ListRulesOutput>>)`](crate::output::ListRulesOutput::rules): <p>A list of readiness rules for a specific resource type.</p>
    /// - On failure, responds with [`SdkError<ListRulesError>`](crate::error::ListRulesError)
    pub fn list_rules(&self) -> fluent_builders::ListRules {
        fluent_builders::ListRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResources`](crate::client::fluent_builders::ListTagsForResources) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResources::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResources::set_resource_arn): <p>The Amazon Resource Name (ARN) for a resource.</p>
    /// - On success, responds with [`ListTagsForResourcesOutput`](crate::output::ListTagsForResourcesOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourcesOutput::tags): <p></p>
    /// - On failure, responds with [`SdkError<ListTagsForResourcesError>`](crate::error::ListTagsForResourcesError)
    pub fn list_tags_for_resources(&self) -> fluent_builders::ListTagsForResources {
        fluent_builders::ListTagsForResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) for a resource.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p></p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) for a resource.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The keys for tags you add to resources.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateCell`](crate::client::fluent_builders::UpdateCell) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cell_name(impl Into<String>)`](crate::client::fluent_builders::UpdateCell::cell_name) / [`set_cell_name(Option<String>)`](crate::client::fluent_builders::UpdateCell::set_cell_name): <p>The name of the cell.</p>
    ///   - [`cells(Vec<String>)`](crate::client::fluent_builders::UpdateCell::cells) / [`set_cells(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateCell::set_cells): <p>A list of cell Amazon Resource Names (ARNs), which completely replaces the previous list.</p>
    /// - On success, responds with [`UpdateCellOutput`](crate::output::UpdateCellOutput) with field(s):
    ///   - [`cell_arn(Option<String>)`](crate::output::UpdateCellOutput::cell_arn): <p>The Amazon Resource Name (ARN) for the cell.</p>
    ///   - [`cell_name(Option<String>)`](crate::output::UpdateCellOutput::cell_name): <p>The name of the cell.</p>
    ///   - [`cells(Option<Vec<String>>)`](crate::output::UpdateCellOutput::cells): <p>A list of cell ARNs.</p>
    ///   - [`parent_readiness_scopes(Option<Vec<String>>)`](crate::output::UpdateCellOutput::parent_readiness_scopes): <p>The readiness scope for the cell, which can be a cell Amazon Resource Name (ARN) or a recovery group ARN. This is a list but currently can have only one element.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::UpdateCellOutput::tags): <p>Tags on the resources.</p>
    /// - On failure, responds with [`SdkError<UpdateCellError>`](crate::error::UpdateCellError)
    pub fn update_cell(&self) -> fluent_builders::UpdateCell {
        fluent_builders::UpdateCell::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateReadinessCheck`](crate::client::fluent_builders::UpdateReadinessCheck) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`readiness_check_name(impl Into<String>)`](crate::client::fluent_builders::UpdateReadinessCheck::readiness_check_name) / [`set_readiness_check_name(Option<String>)`](crate::client::fluent_builders::UpdateReadinessCheck::set_readiness_check_name): <p>Name of a readiness check.</p>
    ///   - [`resource_set_name(impl Into<String>)`](crate::client::fluent_builders::UpdateReadinessCheck::resource_set_name) / [`set_resource_set_name(Option<String>)`](crate::client::fluent_builders::UpdateReadinessCheck::set_resource_set_name): <p>The name of the resource set to be checked.</p>
    /// - On success, responds with [`UpdateReadinessCheckOutput`](crate::output::UpdateReadinessCheckOutput) with field(s):
    ///   - [`readiness_check_arn(Option<String>)`](crate::output::UpdateReadinessCheckOutput::readiness_check_arn): <p>The Amazon Resource Name (ARN) associated with a readiness check.</p>
    ///   - [`readiness_check_name(Option<String>)`](crate::output::UpdateReadinessCheckOutput::readiness_check_name): <p>Name of a readiness check.</p>
    ///   - [`resource_set(Option<String>)`](crate::output::UpdateReadinessCheckOutput::resource_set): <p>Name of the resource set to be checked.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::UpdateReadinessCheckOutput::tags): <p>A collection of tags associated with a resource.</p>
    /// - On failure, responds with [`SdkError<UpdateReadinessCheckError>`](crate::error::UpdateReadinessCheckError)
    pub fn update_readiness_check(&self) -> fluent_builders::UpdateReadinessCheck {
        fluent_builders::UpdateReadinessCheck::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateRecoveryGroup`](crate::client::fluent_builders::UpdateRecoveryGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cells(Vec<String>)`](crate::client::fluent_builders::UpdateRecoveryGroup::cells) / [`set_cells(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateRecoveryGroup::set_cells): <p>A list of cell Amazon Resource Names (ARNs). This list completely replaces the previous list.</p>
    ///   - [`recovery_group_name(impl Into<String>)`](crate::client::fluent_builders::UpdateRecoveryGroup::recovery_group_name) / [`set_recovery_group_name(Option<String>)`](crate::client::fluent_builders::UpdateRecoveryGroup::set_recovery_group_name): <p>The name of a recovery group.</p>
    /// - On success, responds with [`UpdateRecoveryGroupOutput`](crate::output::UpdateRecoveryGroupOutput) with field(s):
    ///   - [`cells(Option<Vec<String>>)`](crate::output::UpdateRecoveryGroupOutput::cells): <p>A list of a cell's Amazon Resource Names (ARNs).</p>
    ///   - [`recovery_group_arn(Option<String>)`](crate::output::UpdateRecoveryGroupOutput::recovery_group_arn): <p>The Amazon Resource Name (ARN) for the recovery group.</p>
    ///   - [`recovery_group_name(Option<String>)`](crate::output::UpdateRecoveryGroupOutput::recovery_group_name): <p>The name of the recovery group.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::UpdateRecoveryGroupOutput::tags): <p>The tags associated with the recovery group.</p>
    /// - On failure, responds with [`SdkError<UpdateRecoveryGroupError>`](crate::error::UpdateRecoveryGroupError)
    pub fn update_recovery_group(&self) -> fluent_builders::UpdateRecoveryGroup {
        fluent_builders::UpdateRecoveryGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateResourceSet`](crate::client::fluent_builders::UpdateResourceSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_set_name(impl Into<String>)`](crate::client::fluent_builders::UpdateResourceSet::resource_set_name) / [`set_resource_set_name(Option<String>)`](crate::client::fluent_builders::UpdateResourceSet::set_resource_set_name): <p>Name of a resource set.</p>
    ///   - [`resource_set_type(impl Into<String>)`](crate::client::fluent_builders::UpdateResourceSet::resource_set_type) / [`set_resource_set_type(Option<String>)`](crate::client::fluent_builders::UpdateResourceSet::set_resource_set_type): <p>The resource type of the resources in the resource set. Enter one of the following values for resource type:</p>  <p>AWS::ApiGateway::Stage, AWS::ApiGatewayV2::Stage, AWS::AutoScaling::AutoScalingGroup, AWS::CloudWatch::Alarm, AWS::EC2::CustomerGateway, AWS::DynamoDB::Table, AWS::EC2::Volume, AWS::ElasticLoadBalancing::LoadBalancer, AWS::ElasticLoadBalancingV2::LoadBalancer, AWS::Lambda::Function, AWS::MSK::Cluster, AWS::RDS::DBCluster, AWS::Route53::HealthCheck, AWS::SQS::Queue, AWS::SNS::Topic, AWS::SNS::Subscription, AWS::EC2::VPC, AWS::EC2::VPNConnection, AWS::EC2::VPNGateway, AWS::Route53RecoveryReadiness::DNSTargetResource</p>
    ///   - [`resources(Vec<Resource>)`](crate::client::fluent_builders::UpdateResourceSet::resources) / [`set_resources(Option<Vec<Resource>>)`](crate::client::fluent_builders::UpdateResourceSet::set_resources): <p>A list of resource objects.</p>
    /// - On success, responds with [`UpdateResourceSetOutput`](crate::output::UpdateResourceSetOutput) with field(s):
    ///   - [`resource_set_arn(Option<String>)`](crate::output::UpdateResourceSetOutput::resource_set_arn): <p>The Amazon Resource Name (ARN) for the resource set.</p>
    ///   - [`resource_set_name(Option<String>)`](crate::output::UpdateResourceSetOutput::resource_set_name): <p>The name of the resource set.</p>
    ///   - [`resource_set_type(Option<String>)`](crate::output::UpdateResourceSetOutput::resource_set_type): <p>The resource type of the resources in the resource set. Enter one of the following values for resource type:</p>  <p>AWS::ApiGateway::Stage, AWS::ApiGatewayV2::Stage, AWS::AutoScaling::AutoScalingGroup, AWS::CloudWatch::Alarm, AWS::EC2::CustomerGateway, AWS::DynamoDB::Table, AWS::EC2::Volume, AWS::ElasticLoadBalancing::LoadBalancer, AWS::ElasticLoadBalancingV2::LoadBalancer, AWS::Lambda::Function, AWS::MSK::Cluster, AWS::RDS::DBCluster, AWS::Route53::HealthCheck, AWS::SQS::Queue, AWS::SNS::Topic, AWS::SNS::Subscription, AWS::EC2::VPC, AWS::EC2::VPNConnection, AWS::EC2::VPNGateway, AWS::Route53RecoveryReadiness::DNSTargetResource</p>
    ///   - [`resources(Option<Vec<Resource>>)`](crate::output::UpdateResourceSetOutput::resources): <p>A list of resource objects.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::UpdateResourceSetOutput::tags): <p>A collection of tags associated with a resource.</p>
    /// - On failure, responds with [`SdkError<UpdateResourceSetError>`](crate::error::UpdateResourceSetError)
    pub fn update_resource_set(&self) -> fluent_builders::UpdateResourceSet {
        fluent_builders::UpdateResourceSet::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateCell`.
    ///
    /// <p>Creates a cell in an account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCell {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_cell_input::Builder,
    }
    impl CreateCell {
        /// Creates a new `CreateCell`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCellOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCellError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cell to create.</p>
        pub fn cell_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cell_name(input.into());
            self
        }
        /// <p>The name of the cell to create.</p>
        pub fn set_cell_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cell_name(input);
            self
        }
        /// Appends an item to `Cells`.
        ///
        /// To override the contents of this collection use [`set_cells`](Self::set_cells).
        ///
        /// <p>A list of cell Amazon Resource Names (ARNs) contained within this cell, for use in nested cells. For example, Availability Zones within specific Amazon Web Services Regions.</p>
        pub fn cells(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cells(input.into());
            self
        }
        /// <p>A list of cell Amazon Resource Names (ARNs) contained within this cell, for use in nested cells. For example, Availability Zones within specific Amazon Web Services Regions.</p>
        pub fn set_cells(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_cells(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of tags associated with a resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A collection of tags associated with a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCrossAccountAuthorization`.
    ///
    /// <p>Creates a cross-account readiness authorization. This lets you authorize another account to work with Route 53 Application Recovery Controller, for example, to check the readiness status of resources in a separate account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCrossAccountAuthorization {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_cross_account_authorization_input::Builder,
    }
    impl CreateCrossAccountAuthorization {
        /// Creates a new `CreateCrossAccountAuthorization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCrossAccountAuthorizationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCrossAccountAuthorizationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The cross-account authorization.</p>
        pub fn cross_account_authorization(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.cross_account_authorization(input.into());
            self
        }
        /// <p>The cross-account authorization.</p>
        pub fn set_cross_account_authorization(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cross_account_authorization(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateReadinessCheck`.
    ///
    /// <p>Creates a readiness check in an account. A readiness check monitors a resource set in your application, such as a set of Amazon Aurora instances, that Application Recovery Controller is auditing recovery readiness for. The audits run once every minute on every resource that's associated with a readiness check.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateReadinessCheck {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_readiness_check_input::Builder,
    }
    impl CreateReadinessCheck {
        /// Creates a new `CreateReadinessCheck`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateReadinessCheckOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateReadinessCheckError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the readiness check to create.</p>
        pub fn readiness_check_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.readiness_check_name(input.into());
            self
        }
        /// <p>The name of the readiness check to create.</p>
        pub fn set_readiness_check_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_readiness_check_name(input);
            self
        }
        /// <p>The name of the resource set to check.</p>
        pub fn resource_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_set_name(input.into());
            self
        }
        /// <p>The name of the resource set to check.</p>
        pub fn set_resource_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_set_name(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of tags associated with a resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A collection of tags associated with a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRecoveryGroup`.
    ///
    /// <p>Creates a recovery group in an account. A recovery group corresponds to an application and includes a list of the cells that make up the application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRecoveryGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_recovery_group_input::Builder,
    }
    impl CreateRecoveryGroup {
        /// Creates a new `CreateRecoveryGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRecoveryGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRecoveryGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Cells`.
        ///
        /// To override the contents of this collection use [`set_cells`](Self::set_cells).
        ///
        /// <p>A list of the cell Amazon Resource Names (ARNs) in the recovery group.</p>
        pub fn cells(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cells(input.into());
            self
        }
        /// <p>A list of the cell Amazon Resource Names (ARNs) in the recovery group.</p>
        pub fn set_cells(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_cells(input);
            self
        }
        /// <p>The name of the recovery group to create.</p>
        pub fn recovery_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recovery_group_name(input.into());
            self
        }
        /// <p>The name of the recovery group to create.</p>
        pub fn set_recovery_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recovery_group_name(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of tags associated with a resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A collection of tags associated with a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateResourceSet`.
    ///
    /// <p>Creates a resource set. A resource set is a set of resources of one type that span multiple cells. You can associate a resource set with a readiness check to monitor the resources for failover readiness.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateResourceSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_resource_set_input::Builder,
    }
    impl CreateResourceSet {
        /// Creates a new `CreateResourceSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateResourceSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateResourceSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource set to create.</p>
        pub fn resource_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_set_name(input.into());
            self
        }
        /// <p>The name of the resource set to create.</p>
        pub fn set_resource_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_set_name(input);
            self
        }
        /// <p>The resource type of the resources in the resource set. Enter one of the following values for resource type:</p>
        /// <p>AWS::ApiGateway::Stage, AWS::ApiGatewayV2::Stage, AWS::AutoScaling::AutoScalingGroup, AWS::CloudWatch::Alarm, AWS::EC2::CustomerGateway, AWS::DynamoDB::Table, AWS::EC2::Volume, AWS::ElasticLoadBalancing::LoadBalancer, AWS::ElasticLoadBalancingV2::LoadBalancer, AWS::Lambda::Function, AWS::MSK::Cluster, AWS::RDS::DBCluster, AWS::Route53::HealthCheck, AWS::SQS::Queue, AWS::SNS::Topic, AWS::SNS::Subscription, AWS::EC2::VPC, AWS::EC2::VPNConnection, AWS::EC2::VPNGateway, AWS::Route53RecoveryReadiness::DNSTargetResource</p>
        pub fn resource_set_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_set_type(input.into());
            self
        }
        /// <p>The resource type of the resources in the resource set. Enter one of the following values for resource type:</p>
        /// <p>AWS::ApiGateway::Stage, AWS::ApiGatewayV2::Stage, AWS::AutoScaling::AutoScalingGroup, AWS::CloudWatch::Alarm, AWS::EC2::CustomerGateway, AWS::DynamoDB::Table, AWS::EC2::Volume, AWS::ElasticLoadBalancing::LoadBalancer, AWS::ElasticLoadBalancingV2::LoadBalancer, AWS::Lambda::Function, AWS::MSK::Cluster, AWS::RDS::DBCluster, AWS::Route53::HealthCheck, AWS::SQS::Queue, AWS::SNS::Topic, AWS::SNS::Subscription, AWS::EC2::VPC, AWS::EC2::VPNConnection, AWS::EC2::VPNGateway, AWS::Route53RecoveryReadiness::DNSTargetResource</p>
        pub fn set_resource_set_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_set_type(input);
            self
        }
        /// Appends an item to `Resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// <p>A list of resource objects in the resource set.</p>
        pub fn resources(mut self, input: crate::model::Resource) -> Self {
            self.inner = self.inner.resources(input);
            self
        }
        /// <p>A list of resource objects in the resource set.</p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        ) -> Self {
            self.inner = self.inner.set_resources(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A tag to associate with the parameters for a resource set.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A tag to associate with the parameters for a resource set.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCell`.
    ///
    /// <p>Delete a cell. When successful, the response code is 204, with no response body.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCell {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_cell_input::Builder,
    }
    impl DeleteCell {
        /// Creates a new `DeleteCell`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCellOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCellError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cell.</p>
        pub fn cell_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cell_name(input.into());
            self
        }
        /// <p>The name of the cell.</p>
        pub fn set_cell_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cell_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCrossAccountAuthorization`.
    ///
    /// <p>Deletes cross account readiness authorization.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCrossAccountAuthorization {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_cross_account_authorization_input::Builder,
    }
    impl DeleteCrossAccountAuthorization {
        /// Creates a new `DeleteCrossAccountAuthorization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCrossAccountAuthorizationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCrossAccountAuthorizationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The cross-account authorization.</p>
        pub fn cross_account_authorization(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.cross_account_authorization(input.into());
            self
        }
        /// <p>The cross-account authorization.</p>
        pub fn set_cross_account_authorization(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cross_account_authorization(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteReadinessCheck`.
    ///
    /// <p>Deletes a readiness check.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteReadinessCheck {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_readiness_check_input::Builder,
    }
    impl DeleteReadinessCheck {
        /// Creates a new `DeleteReadinessCheck`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteReadinessCheckOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteReadinessCheckError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of a readiness check.</p>
        pub fn readiness_check_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.readiness_check_name(input.into());
            self
        }
        /// <p>Name of a readiness check.</p>
        pub fn set_readiness_check_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_readiness_check_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRecoveryGroup`.
    ///
    /// <p>Deletes a recovery group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRecoveryGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_recovery_group_input::Builder,
    }
    impl DeleteRecoveryGroup {
        /// Creates a new `DeleteRecoveryGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRecoveryGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRecoveryGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a recovery group.</p>
        pub fn recovery_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recovery_group_name(input.into());
            self
        }
        /// <p>The name of a recovery group.</p>
        pub fn set_recovery_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recovery_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResourceSet`.
    ///
    /// <p>Deletes a resource set.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteResourceSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_resource_set_input::Builder,
    }
    impl DeleteResourceSet {
        /// Creates a new `DeleteResourceSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResourceSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResourceSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of a resource set.</p>
        pub fn resource_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_set_name(input.into());
            self
        }
        /// <p>Name of a resource set.</p>
        pub fn set_resource_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetArchitectureRecommendations`.
    ///
    /// <p>Gets recommendations about architecture designs for improving resiliency for an application, based on a recovery group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetArchitectureRecommendations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_architecture_recommendations_input::Builder,
    }
    impl GetArchitectureRecommendations {
        /// Creates a new `GetArchitectureRecommendations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetArchitectureRecommendationsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetArchitectureRecommendationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The number of objects that you want to return with this call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The number of objects that you want to return with this call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The name of a recovery group.</p>
        pub fn recovery_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recovery_group_name(input.into());
            self
        }
        /// <p>The name of a recovery group.</p>
        pub fn set_recovery_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recovery_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCell`.
    ///
    /// <p>Gets information about a cell including cell name, cell Amazon Resource Name (ARN), ARNs of nested cells for this cell, and a list of those cell ARNs with their associated recovery group ARNs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCell {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_cell_input::Builder,
    }
    impl GetCell {
        /// Creates a new `GetCell`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCellOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCellError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cell.</p>
        pub fn cell_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cell_name(input.into());
            self
        }
        /// <p>The name of the cell.</p>
        pub fn set_cell_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cell_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCellReadinessSummary`.
    ///
    /// <p>Gets readiness for a cell. Aggregates the readiness of all the resources that are associated with the cell into a single value.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCellReadinessSummary {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_cell_readiness_summary_input::Builder,
    }
    impl GetCellReadinessSummary {
        /// Creates a new `GetCellReadinessSummary`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCellReadinessSummaryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCellReadinessSummaryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetCellReadinessSummaryPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetCellReadinessSummaryPaginator {
            crate::paginator::GetCellReadinessSummaryPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the cell.</p>
        pub fn cell_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cell_name(input.into());
            self
        }
        /// <p>The name of the cell.</p>
        pub fn set_cell_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cell_name(input);
            self
        }
        /// <p>The number of objects that you want to return with this call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The number of objects that you want to return with this call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetReadinessCheck`.
    ///
    /// <p>Gets details about a readiness check.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetReadinessCheck {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_readiness_check_input::Builder,
    }
    impl GetReadinessCheck {
        /// Creates a new `GetReadinessCheck`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetReadinessCheckOutput,
            aws_smithy_http::result::SdkError<crate::error::GetReadinessCheckError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of a readiness check.</p>
        pub fn readiness_check_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.readiness_check_name(input.into());
            self
        }
        /// <p>Name of a readiness check.</p>
        pub fn set_readiness_check_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_readiness_check_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetReadinessCheckResourceStatus`.
    ///
    /// <p>Gets individual readiness status for a readiness check. To see the overall readiness status for a recovery group, that considers the readiness status for all the readiness checks in the recovery group, use GetRecoveryGroupReadinessSummary.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetReadinessCheckResourceStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_readiness_check_resource_status_input::Builder,
    }
    impl GetReadinessCheckResourceStatus {
        /// Creates a new `GetReadinessCheckResourceStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetReadinessCheckResourceStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetReadinessCheckResourceStatusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetReadinessCheckResourceStatusPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetReadinessCheckResourceStatusPaginator {
            crate::paginator::GetReadinessCheckResourceStatusPaginator::new(self.handle, self.inner)
        }
        /// <p>The number of objects that you want to return with this call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The number of objects that you want to return with this call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Name of a readiness check.</p>
        pub fn readiness_check_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.readiness_check_name(input.into());
            self
        }
        /// <p>Name of a readiness check.</p>
        pub fn set_readiness_check_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_readiness_check_name(input);
            self
        }
        /// <p>The resource identifier, which is the Amazon Resource Name (ARN) or the identifier generated for the resource by Application Recovery Controller (for example, for a DNS target resource).</p>
        pub fn resource_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_identifier(input.into());
            self
        }
        /// <p>The resource identifier, which is the Amazon Resource Name (ARN) or the identifier generated for the resource by Application Recovery Controller (for example, for a DNS target resource).</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetReadinessCheckStatus`.
    ///
    /// <p>Gets the readiness status for an individual readiness check. To see the overall readiness status for a recovery group, that considers the readiness status for all the readiness checks in a recovery group, use GetRecoveryGroupReadinessSummary.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetReadinessCheckStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_readiness_check_status_input::Builder,
    }
    impl GetReadinessCheckStatus {
        /// Creates a new `GetReadinessCheckStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetReadinessCheckStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetReadinessCheckStatusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetReadinessCheckStatusPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetReadinessCheckStatusPaginator {
            crate::paginator::GetReadinessCheckStatusPaginator::new(self.handle, self.inner)
        }
        /// <p>The number of objects that you want to return with this call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The number of objects that you want to return with this call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Name of a readiness check.</p>
        pub fn readiness_check_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.readiness_check_name(input.into());
            self
        }
        /// <p>Name of a readiness check.</p>
        pub fn set_readiness_check_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_readiness_check_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRecoveryGroup`.
    ///
    /// <p>Gets details about a recovery group, including a list of the cells that are included in it.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRecoveryGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_recovery_group_input::Builder,
    }
    impl GetRecoveryGroup {
        /// Creates a new `GetRecoveryGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRecoveryGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRecoveryGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a recovery group.</p>
        pub fn recovery_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recovery_group_name(input.into());
            self
        }
        /// <p>The name of a recovery group.</p>
        pub fn set_recovery_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recovery_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRecoveryGroupReadinessSummary`.
    ///
    /// <p>Displays a summary of information about a recovery group's readiness status. Includes the readiness checks for resources in the recovery group and the readiness status of each one.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRecoveryGroupReadinessSummary {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_recovery_group_readiness_summary_input::Builder,
    }
    impl GetRecoveryGroupReadinessSummary {
        /// Creates a new `GetRecoveryGroupReadinessSummary`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRecoveryGroupReadinessSummaryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRecoveryGroupReadinessSummaryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetRecoveryGroupReadinessSummaryPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetRecoveryGroupReadinessSummaryPaginator {
            crate::paginator::GetRecoveryGroupReadinessSummaryPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The number of objects that you want to return with this call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The number of objects that you want to return with this call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The name of a recovery group.</p>
        pub fn recovery_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recovery_group_name(input.into());
            self
        }
        /// <p>The name of a recovery group.</p>
        pub fn set_recovery_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recovery_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResourceSet`.
    ///
    /// <p>Displays the details about a resource set, including a list of the resources in the set.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetResourceSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_resource_set_input::Builder,
    }
    impl GetResourceSet {
        /// Creates a new `GetResourceSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResourceSetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResourceSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of a resource set.</p>
        pub fn resource_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_set_name(input.into());
            self
        }
        /// <p>Name of a resource set.</p>
        pub fn set_resource_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCells`.
    ///
    /// <p>Lists the cells for an account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCells {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_cells_input::Builder,
    }
    impl ListCells {
        /// Creates a new `ListCells`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCellsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCellsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListCellsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListCellsPaginator {
            crate::paginator::ListCellsPaginator::new(self.handle, self.inner)
        }
        /// <p>The number of objects that you want to return with this call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The number of objects that you want to return with this call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCrossAccountAuthorizations`.
    ///
    /// <p>Lists the cross-account readiness authorizations that are in place for an account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCrossAccountAuthorizations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_cross_account_authorizations_input::Builder,
    }
    impl ListCrossAccountAuthorizations {
        /// Creates a new `ListCrossAccountAuthorizations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCrossAccountAuthorizationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCrossAccountAuthorizationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListCrossAccountAuthorizationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListCrossAccountAuthorizationsPaginator {
            crate::paginator::ListCrossAccountAuthorizationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The number of objects that you want to return with this call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The number of objects that you want to return with this call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListReadinessChecks`.
    ///
    /// <p>Lists the readiness checks for an account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListReadinessChecks {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_readiness_checks_input::Builder,
    }
    impl ListReadinessChecks {
        /// Creates a new `ListReadinessChecks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListReadinessChecksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListReadinessChecksError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListReadinessChecksPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListReadinessChecksPaginator {
            crate::paginator::ListReadinessChecksPaginator::new(self.handle, self.inner)
        }
        /// <p>The number of objects that you want to return with this call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The number of objects that you want to return with this call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRecoveryGroups`.
    ///
    /// <p>Lists the recovery groups in an account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRecoveryGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_recovery_groups_input::Builder,
    }
    impl ListRecoveryGroups {
        /// Creates a new `ListRecoveryGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRecoveryGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRecoveryGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListRecoveryGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListRecoveryGroupsPaginator {
            crate::paginator::ListRecoveryGroupsPaginator::new(self.handle, self.inner)
        }
        /// <p>The number of objects that you want to return with this call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The number of objects that you want to return with this call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResourceSets`.
    ///
    /// <p>Lists the resource sets in an account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListResourceSets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_resource_sets_input::Builder,
    }
    impl ListResourceSets {
        /// Creates a new `ListResourceSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResourceSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResourceSetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListResourceSetsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListResourceSetsPaginator {
            crate::paginator::ListResourceSetsPaginator::new(self.handle, self.inner)
        }
        /// <p>The number of objects that you want to return with this call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The number of objects that you want to return with this call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRules`.
    ///
    /// <p>Lists all readiness rules, or lists the readiness rules for a specific resource type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRules {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_rules_input::Builder,
    }
    impl ListRules {
        /// Creates a new `ListRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRulesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListRulesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListRulesPaginator {
            crate::paginator::ListRulesPaginator::new(self.handle, self.inner)
        }
        /// <p>The number of objects that you want to return with this call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The number of objects that you want to return with this call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The resource type that a readiness rule applies to.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_type(input.into());
            self
        }
        /// <p>The resource type that a readiness rule applies to.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResources`.
    ///
    /// <p>Lists the tags for a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResources {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resources_input::Builder,
    }
    impl ListTagsForResources {
        /// Creates a new `ListTagsForResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourcesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for a resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for a resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds a tag to a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for a resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for a resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p></p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p></p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes a tag from a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for a resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for a resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys for tags you add to resources.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The keys for tags you add to resources.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateCell`.
    ///
    /// <p>Updates a cell to replace the list of nested cells with a new list of nested cells.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateCell {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_cell_input::Builder,
    }
    impl UpdateCell {
        /// Creates a new `UpdateCell`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateCellOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateCellError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cell.</p>
        pub fn cell_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cell_name(input.into());
            self
        }
        /// <p>The name of the cell.</p>
        pub fn set_cell_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cell_name(input);
            self
        }
        /// Appends an item to `Cells`.
        ///
        /// To override the contents of this collection use [`set_cells`](Self::set_cells).
        ///
        /// <p>A list of cell Amazon Resource Names (ARNs), which completely replaces the previous list.</p>
        pub fn cells(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cells(input.into());
            self
        }
        /// <p>A list of cell Amazon Resource Names (ARNs), which completely replaces the previous list.</p>
        pub fn set_cells(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_cells(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateReadinessCheck`.
    ///
    /// <p>Updates a readiness check.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateReadinessCheck {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_readiness_check_input::Builder,
    }
    impl UpdateReadinessCheck {
        /// Creates a new `UpdateReadinessCheck`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateReadinessCheckOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateReadinessCheckError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of a readiness check.</p>
        pub fn readiness_check_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.readiness_check_name(input.into());
            self
        }
        /// <p>Name of a readiness check.</p>
        pub fn set_readiness_check_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_readiness_check_name(input);
            self
        }
        /// <p>The name of the resource set to be checked.</p>
        pub fn resource_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_set_name(input.into());
            self
        }
        /// <p>The name of the resource set to be checked.</p>
        pub fn set_resource_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRecoveryGroup`.
    ///
    /// <p>Updates a recovery group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateRecoveryGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_recovery_group_input::Builder,
    }
    impl UpdateRecoveryGroup {
        /// Creates a new `UpdateRecoveryGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRecoveryGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRecoveryGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Cells`.
        ///
        /// To override the contents of this collection use [`set_cells`](Self::set_cells).
        ///
        /// <p>A list of cell Amazon Resource Names (ARNs). This list completely replaces the previous list.</p>
        pub fn cells(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cells(input.into());
            self
        }
        /// <p>A list of cell Amazon Resource Names (ARNs). This list completely replaces the previous list.</p>
        pub fn set_cells(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_cells(input);
            self
        }
        /// <p>The name of a recovery group.</p>
        pub fn recovery_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recovery_group_name(input.into());
            self
        }
        /// <p>The name of a recovery group.</p>
        pub fn set_recovery_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recovery_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateResourceSet`.
    ///
    /// <p>Updates a resource set.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateResourceSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_resource_set_input::Builder,
    }
    impl UpdateResourceSet {
        /// Creates a new `UpdateResourceSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateResourceSetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateResourceSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of a resource set.</p>
        pub fn resource_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_set_name(input.into());
            self
        }
        /// <p>Name of a resource set.</p>
        pub fn set_resource_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_set_name(input);
            self
        }
        /// <p>The resource type of the resources in the resource set. Enter one of the following values for resource type:</p>
        /// <p>AWS::ApiGateway::Stage, AWS::ApiGatewayV2::Stage, AWS::AutoScaling::AutoScalingGroup, AWS::CloudWatch::Alarm, AWS::EC2::CustomerGateway, AWS::DynamoDB::Table, AWS::EC2::Volume, AWS::ElasticLoadBalancing::LoadBalancer, AWS::ElasticLoadBalancingV2::LoadBalancer, AWS::Lambda::Function, AWS::MSK::Cluster, AWS::RDS::DBCluster, AWS::Route53::HealthCheck, AWS::SQS::Queue, AWS::SNS::Topic, AWS::SNS::Subscription, AWS::EC2::VPC, AWS::EC2::VPNConnection, AWS::EC2::VPNGateway, AWS::Route53RecoveryReadiness::DNSTargetResource</p>
        pub fn resource_set_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_set_type(input.into());
            self
        }
        /// <p>The resource type of the resources in the resource set. Enter one of the following values for resource type:</p>
        /// <p>AWS::ApiGateway::Stage, AWS::ApiGatewayV2::Stage, AWS::AutoScaling::AutoScalingGroup, AWS::CloudWatch::Alarm, AWS::EC2::CustomerGateway, AWS::DynamoDB::Table, AWS::EC2::Volume, AWS::ElasticLoadBalancing::LoadBalancer, AWS::ElasticLoadBalancingV2::LoadBalancer, AWS::Lambda::Function, AWS::MSK::Cluster, AWS::RDS::DBCluster, AWS::Route53::HealthCheck, AWS::SQS::Queue, AWS::SNS::Topic, AWS::SNS::Subscription, AWS::EC2::VPC, AWS::EC2::VPNConnection, AWS::EC2::VPNGateway, AWS::Route53RecoveryReadiness::DNSTargetResource</p>
        pub fn set_resource_set_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_set_type(input);
            self
        }
        /// Appends an item to `Resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// <p>A list of resource objects.</p>
        pub fn resources(mut self, input: crate::model::Resource) -> Self {
            self.inner = self.inner.resources(input);
            self
        }
        /// <p>A list of resource objects.</p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        ) -> Self {
            self.inner = self.inner.set_resources(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
