// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Route53 Recovery Readiness
///
/// Client for invoking operations on AWS Route53 Recovery Readiness. Each operation on AWS Route53 Recovery Readiness is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_route53recoveryreadiness::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_route53recoveryreadiness::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_route53recoveryreadiness::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`CreateCell`](crate::client::fluent_builders::CreateCell) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cell_name(impl Into<String>)`](crate::client::fluent_builders::CreateCell::cell_name) / [`set_cell_name(Option<String>)`](crate::client::fluent_builders::CreateCell::set_cell_name): The name of the Cell to create
    ///   - [`cells(Vec<String>)`](crate::client::fluent_builders::CreateCell::cells) / [`set_cells(Option<Vec<String>>)`](crate::client::fluent_builders::CreateCell::set_cells): A list of Cell arns contained within this Cell (for use in nested Cells, e.g. regions within which AZs)
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateCell::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateCell::set_tags): A collection of tags associated with a resource
    /// - On success, responds with [`CreateCellOutput`](crate::output::CreateCellOutput) with field(s):
    ///   - [`cell_arn(Option<String>)`](crate::output::CreateCellOutput::cell_arn): The arn for the Cell
    ///   - [`cell_name(Option<String>)`](crate::output::CreateCellOutput::cell_name): The name of the Cell
    ///   - [`cells(Option<Vec<String>>)`](crate::output::CreateCellOutput::cells): A list of Cell arns
    ///   - [`parent_readiness_scopes(Option<Vec<String>>)`](crate::output::CreateCellOutput::parent_readiness_scopes): A list of Cell ARNs and/or RecoveryGroup ARNs
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::CreateCellOutput::tags): A collection of tags associated with a resource
    /// - On failure, responds with [`SdkError<CreateCellError>`](crate::error::CreateCellError)
    pub fn create_cell(&self) -> fluent_builders::CreateCell<C, M, R> {
        fluent_builders::CreateCell::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateCrossAccountAuthorization`](crate::client::fluent_builders::CreateCrossAccountAuthorization) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cross_account_authorization(impl Into<String>)`](crate::client::fluent_builders::CreateCrossAccountAuthorization::cross_account_authorization) / [`set_cross_account_authorization(Option<String>)`](crate::client::fluent_builders::CreateCrossAccountAuthorization::set_cross_account_authorization): The cross account authorization
    /// - On success, responds with [`CreateCrossAccountAuthorizationOutput`](crate::output::CreateCrossAccountAuthorizationOutput) with field(s):
    ///   - [`cross_account_authorization(Option<String>)`](crate::output::CreateCrossAccountAuthorizationOutput::cross_account_authorization): The cross account authorization
    /// - On failure, responds with [`SdkError<CreateCrossAccountAuthorizationError>`](crate::error::CreateCrossAccountAuthorizationError)
    pub fn create_cross_account_authorization(
        &self,
    ) -> fluent_builders::CreateCrossAccountAuthorization<C, M, R> {
        fluent_builders::CreateCrossAccountAuthorization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateReadinessCheck`](crate::client::fluent_builders::CreateReadinessCheck) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`readiness_check_name(impl Into<String>)`](crate::client::fluent_builders::CreateReadinessCheck::readiness_check_name) / [`set_readiness_check_name(Option<String>)`](crate::client::fluent_builders::CreateReadinessCheck::set_readiness_check_name): The name of the ReadinessCheck to create
    ///   - [`resource_set_name(impl Into<String>)`](crate::client::fluent_builders::CreateReadinessCheck::resource_set_name) / [`set_resource_set_name(Option<String>)`](crate::client::fluent_builders::CreateReadinessCheck::set_resource_set_name): The name of the ResourceSet to check
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateReadinessCheck::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateReadinessCheck::set_tags): A collection of tags associated with a resource
    /// - On success, responds with [`CreateReadinessCheckOutput`](crate::output::CreateReadinessCheckOutput) with field(s):
    ///   - [`readiness_check_arn(Option<String>)`](crate::output::CreateReadinessCheckOutput::readiness_check_arn): Arn associated with ReadinessCheck
    ///   - [`readiness_check_name(Option<String>)`](crate::output::CreateReadinessCheckOutput::readiness_check_name): Name for a ReadinessCheck
    ///   - [`resource_set(Option<String>)`](crate::output::CreateReadinessCheckOutput::resource_set): Name of the ResourceSet to be checked
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::CreateReadinessCheckOutput::tags): A collection of tags associated with a resource
    /// - On failure, responds with [`SdkError<CreateReadinessCheckError>`](crate::error::CreateReadinessCheckError)
    pub fn create_readiness_check(&self) -> fluent_builders::CreateReadinessCheck<C, M, R> {
        fluent_builders::CreateReadinessCheck::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateRecoveryGroup`](crate::client::fluent_builders::CreateRecoveryGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cells(Vec<String>)`](crate::client::fluent_builders::CreateRecoveryGroup::cells) / [`set_cells(Option<Vec<String>>)`](crate::client::fluent_builders::CreateRecoveryGroup::set_cells): A list of Cell arns
    ///   - [`recovery_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateRecoveryGroup::recovery_group_name) / [`set_recovery_group_name(Option<String>)`](crate::client::fluent_builders::CreateRecoveryGroup::set_recovery_group_name): The name of the RecoveryGroup to create
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateRecoveryGroup::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateRecoveryGroup::set_tags): A collection of tags associated with a resource
    /// - On success, responds with [`CreateRecoveryGroupOutput`](crate::output::CreateRecoveryGroupOutput) with field(s):
    ///   - [`cells(Option<Vec<String>>)`](crate::output::CreateRecoveryGroupOutput::cells): A list of Cell arns
    ///   - [`recovery_group_arn(Option<String>)`](crate::output::CreateRecoveryGroupOutput::recovery_group_arn): The arn for the RecoveryGroup
    ///   - [`recovery_group_name(Option<String>)`](crate::output::CreateRecoveryGroupOutput::recovery_group_name): The name of the RecoveryGroup
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::CreateRecoveryGroupOutput::tags): A collection of tags associated with a resource
    /// - On failure, responds with [`SdkError<CreateRecoveryGroupError>`](crate::error::CreateRecoveryGroupError)
    pub fn create_recovery_group(&self) -> fluent_builders::CreateRecoveryGroup<C, M, R> {
        fluent_builders::CreateRecoveryGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateResourceSet`](crate::client::fluent_builders::CreateResourceSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_set_name(impl Into<String>)`](crate::client::fluent_builders::CreateResourceSet::resource_set_name) / [`set_resource_set_name(Option<String>)`](crate::client::fluent_builders::CreateResourceSet::set_resource_set_name): The name of the ResourceSet to create
    ///   - [`resource_set_type(impl Into<String>)`](crate::client::fluent_builders::CreateResourceSet::resource_set_type) / [`set_resource_set_type(Option<String>)`](crate::client::fluent_builders::CreateResourceSet::set_resource_set_type): AWS Resource type of the resources in the ResourceSet
    ///   - [`resources(Vec<Resource>)`](crate::client::fluent_builders::CreateResourceSet::resources) / [`set_resources(Option<Vec<Resource>>)`](crate::client::fluent_builders::CreateResourceSet::set_resources): A list of Resource objects
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateResourceSet::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateResourceSet::set_tags): A collection of tags associated with a resource
    /// - On success, responds with [`CreateResourceSetOutput`](crate::output::CreateResourceSetOutput) with field(s):
    ///   - [`resource_set_arn(Option<String>)`](crate::output::CreateResourceSetOutput::resource_set_arn): The arn for the ResourceSet
    ///   - [`resource_set_name(Option<String>)`](crate::output::CreateResourceSetOutput::resource_set_name): The name of the ResourceSet
    ///   - [`resource_set_type(Option<String>)`](crate::output::CreateResourceSetOutput::resource_set_type): AWS Resource Type of the resources in the ResourceSet
    ///   - [`resources(Option<Vec<Resource>>)`](crate::output::CreateResourceSetOutput::resources): A list of Resource objects
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::CreateResourceSetOutput::tags): A collection of tags associated with a resource
    /// - On failure, responds with [`SdkError<CreateResourceSetError>`](crate::error::CreateResourceSetError)
    pub fn create_resource_set(&self) -> fluent_builders::CreateResourceSet<C, M, R> {
        fluent_builders::CreateResourceSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCell`](crate::client::fluent_builders::DeleteCell) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cell_name(impl Into<String>)`](crate::client::fluent_builders::DeleteCell::cell_name) / [`set_cell_name(Option<String>)`](crate::client::fluent_builders::DeleteCell::set_cell_name): The Cell to delete
    /// - On success, responds with [`DeleteCellOutput`](crate::output::DeleteCellOutput)

    /// - On failure, responds with [`SdkError<DeleteCellError>`](crate::error::DeleteCellError)
    pub fn delete_cell(&self) -> fluent_builders::DeleteCell<C, M, R> {
        fluent_builders::DeleteCell::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCrossAccountAuthorization`](crate::client::fluent_builders::DeleteCrossAccountAuthorization) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cross_account_authorization(impl Into<String>)`](crate::client::fluent_builders::DeleteCrossAccountAuthorization::cross_account_authorization) / [`set_cross_account_authorization(Option<String>)`](crate::client::fluent_builders::DeleteCrossAccountAuthorization::set_cross_account_authorization): The cross account authorization
    /// - On success, responds with [`DeleteCrossAccountAuthorizationOutput`](crate::output::DeleteCrossAccountAuthorizationOutput)

    /// - On failure, responds with [`SdkError<DeleteCrossAccountAuthorizationError>`](crate::error::DeleteCrossAccountAuthorizationError)
    pub fn delete_cross_account_authorization(
        &self,
    ) -> fluent_builders::DeleteCrossAccountAuthorization<C, M, R> {
        fluent_builders::DeleteCrossAccountAuthorization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteReadinessCheck`](crate::client::fluent_builders::DeleteReadinessCheck) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`readiness_check_name(impl Into<String>)`](crate::client::fluent_builders::DeleteReadinessCheck::readiness_check_name) / [`set_readiness_check_name(Option<String>)`](crate::client::fluent_builders::DeleteReadinessCheck::set_readiness_check_name): The ReadinessCheck to delete
    /// - On success, responds with [`DeleteReadinessCheckOutput`](crate::output::DeleteReadinessCheckOutput)

    /// - On failure, responds with [`SdkError<DeleteReadinessCheckError>`](crate::error::DeleteReadinessCheckError)
    pub fn delete_readiness_check(&self) -> fluent_builders::DeleteReadinessCheck<C, M, R> {
        fluent_builders::DeleteReadinessCheck::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRecoveryGroup`](crate::client::fluent_builders::DeleteRecoveryGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`recovery_group_name(impl Into<String>)`](crate::client::fluent_builders::DeleteRecoveryGroup::recovery_group_name) / [`set_recovery_group_name(Option<String>)`](crate::client::fluent_builders::DeleteRecoveryGroup::set_recovery_group_name): The RecoveryGroup to delete
    /// - On success, responds with [`DeleteRecoveryGroupOutput`](crate::output::DeleteRecoveryGroupOutput)

    /// - On failure, responds with [`SdkError<DeleteRecoveryGroupError>`](crate::error::DeleteRecoveryGroupError)
    pub fn delete_recovery_group(&self) -> fluent_builders::DeleteRecoveryGroup<C, M, R> {
        fluent_builders::DeleteRecoveryGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteResourceSet`](crate::client::fluent_builders::DeleteResourceSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_set_name(impl Into<String>)`](crate::client::fluent_builders::DeleteResourceSet::resource_set_name) / [`set_resource_set_name(Option<String>)`](crate::client::fluent_builders::DeleteResourceSet::set_resource_set_name): The ResourceSet to delete
    /// - On success, responds with [`DeleteResourceSetOutput`](crate::output::DeleteResourceSetOutput)

    /// - On failure, responds with [`SdkError<DeleteResourceSetError>`](crate::error::DeleteResourceSetError)
    pub fn delete_resource_set(&self) -> fluent_builders::DeleteResourceSet<C, M, R> {
        fluent_builders::DeleteResourceSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetArchitectureRecommendations`](crate::client::fluent_builders::GetArchitectureRecommendations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetArchitectureRecommendations::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::GetArchitectureRecommendations::set_max_results): Upper bound on number of records to return.
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetArchitectureRecommendations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetArchitectureRecommendations::set_next_token): A token that can be used to resume pagination from the end of the collection.
    ///   - [`recovery_group_name(impl Into<String>)`](crate::client::fluent_builders::GetArchitectureRecommendations::recovery_group_name) / [`set_recovery_group_name(Option<String>)`](crate::client::fluent_builders::GetArchitectureRecommendations::set_recovery_group_name): Name of RecoveryGroup (top level resource) to be analyzed.
    /// - On success, responds with [`GetArchitectureRecommendationsOutput`](crate::output::GetArchitectureRecommendationsOutput) with field(s):
    ///   - [`last_audit_timestamp(Option<DateTime>)`](crate::output::GetArchitectureRecommendationsOutput::last_audit_timestamp): The time a Recovery Group was last assessed for recommendations in UTC ISO-8601 format.
    ///   - [`next_token(Option<String>)`](crate::output::GetArchitectureRecommendationsOutput::next_token): A token that can be used to resume pagination from the end of the collection
    ///   - [`recommendations(Option<Vec<Recommendation>>)`](crate::output::GetArchitectureRecommendationsOutput::recommendations): A list of recommendations for the customer's application
    /// - On failure, responds with [`SdkError<GetArchitectureRecommendationsError>`](crate::error::GetArchitectureRecommendationsError)
    pub fn get_architecture_recommendations(
        &self,
    ) -> fluent_builders::GetArchitectureRecommendations<C, M, R> {
        fluent_builders::GetArchitectureRecommendations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCell`](crate::client::fluent_builders::GetCell) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cell_name(impl Into<String>)`](crate::client::fluent_builders::GetCell::cell_name) / [`set_cell_name(Option<String>)`](crate::client::fluent_builders::GetCell::set_cell_name): The Cell to get
    /// - On success, responds with [`GetCellOutput`](crate::output::GetCellOutput) with field(s):
    ///   - [`cell_arn(Option<String>)`](crate::output::GetCellOutput::cell_arn): The arn for the Cell
    ///   - [`cell_name(Option<String>)`](crate::output::GetCellOutput::cell_name): The name of the Cell
    ///   - [`cells(Option<Vec<String>>)`](crate::output::GetCellOutput::cells): A list of Cell arns
    ///   - [`parent_readiness_scopes(Option<Vec<String>>)`](crate::output::GetCellOutput::parent_readiness_scopes): A list of Cell ARNs and/or RecoveryGroup ARNs
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetCellOutput::tags): A collection of tags associated with a resource
    /// - On failure, responds with [`SdkError<GetCellError>`](crate::error::GetCellError)
    pub fn get_cell(&self) -> fluent_builders::GetCell<C, M, R> {
        fluent_builders::GetCell::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCellReadinessSummary`](crate::client::fluent_builders::GetCellReadinessSummary) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetCellReadinessSummary::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`cell_name(impl Into<String>)`](crate::client::fluent_builders::GetCellReadinessSummary::cell_name) / [`set_cell_name(Option<String>)`](crate::client::fluent_builders::GetCellReadinessSummary::set_cell_name): The name of the Cell
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetCellReadinessSummary::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::GetCellReadinessSummary::set_max_results): Upper bound on number of records to return.
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetCellReadinessSummary::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetCellReadinessSummary::set_next_token): A token used to resume pagination from the end of a previous request.
    /// - On success, responds with [`GetCellReadinessSummaryOutput`](crate::output::GetCellReadinessSummaryOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::GetCellReadinessSummaryOutput::next_token): A token that can be used to resume pagination from the end of the collection.
    ///   - [`readiness(Option<Readiness>)`](crate::output::GetCellReadinessSummaryOutput::readiness): The readiness at Cell level.
    ///   - [`readiness_checks(Option<Vec<ReadinessCheckSummary>>)`](crate::output::GetCellReadinessSummaryOutput::readiness_checks): Summaries for the ReadinessChecks making up the Cell
    /// - On failure, responds with [`SdkError<GetCellReadinessSummaryError>`](crate::error::GetCellReadinessSummaryError)
    pub fn get_cell_readiness_summary(&self) -> fluent_builders::GetCellReadinessSummary<C, M, R> {
        fluent_builders::GetCellReadinessSummary::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetReadinessCheck`](crate::client::fluent_builders::GetReadinessCheck) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`readiness_check_name(impl Into<String>)`](crate::client::fluent_builders::GetReadinessCheck::readiness_check_name) / [`set_readiness_check_name(Option<String>)`](crate::client::fluent_builders::GetReadinessCheck::set_readiness_check_name): The ReadinessCheck to get
    /// - On success, responds with [`GetReadinessCheckOutput`](crate::output::GetReadinessCheckOutput) with field(s):
    ///   - [`readiness_check_arn(Option<String>)`](crate::output::GetReadinessCheckOutput::readiness_check_arn): Arn associated with ReadinessCheck
    ///   - [`readiness_check_name(Option<String>)`](crate::output::GetReadinessCheckOutput::readiness_check_name): Name for a ReadinessCheck
    ///   - [`resource_set(Option<String>)`](crate::output::GetReadinessCheckOutput::resource_set): Name of the ResourceSet to be checked
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetReadinessCheckOutput::tags): A collection of tags associated with a resource
    /// - On failure, responds with [`SdkError<GetReadinessCheckError>`](crate::error::GetReadinessCheckError)
    pub fn get_readiness_check(&self) -> fluent_builders::GetReadinessCheck<C, M, R> {
        fluent_builders::GetReadinessCheck::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetReadinessCheckResourceStatus`](crate::client::fluent_builders::GetReadinessCheckResourceStatus) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetReadinessCheckResourceStatus::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetReadinessCheckResourceStatus::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::GetReadinessCheckResourceStatus::set_max_results): Upper bound on number of records to return.
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetReadinessCheckResourceStatus::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetReadinessCheckResourceStatus::set_next_token): A token used to resume pagination from the end of a previous request.
    ///   - [`readiness_check_name(impl Into<String>)`](crate::client::fluent_builders::GetReadinessCheckResourceStatus::readiness_check_name) / [`set_readiness_check_name(Option<String>)`](crate::client::fluent_builders::GetReadinessCheckResourceStatus::set_readiness_check_name): The ReadinessCheck to get
    ///   - [`resource_identifier(impl Into<String>)`](crate::client::fluent_builders::GetReadinessCheckResourceStatus::resource_identifier) / [`set_resource_identifier(Option<String>)`](crate::client::fluent_builders::GetReadinessCheckResourceStatus::set_resource_identifier): The resource ARN or component Id to get
    /// - On success, responds with [`GetReadinessCheckResourceStatusOutput`](crate::output::GetReadinessCheckResourceStatusOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::GetReadinessCheckResourceStatusOutput::next_token): A token that can be used to resume pagination from the end of the collection.
    ///   - [`readiness(Option<Readiness>)`](crate::output::GetReadinessCheckResourceStatusOutput::readiness): The readiness at rule level.
    ///   - [`rules(Option<Vec<RuleResult>>)`](crate::output::GetReadinessCheckResourceStatusOutput::rules): Details of the rules's results
    /// - On failure, responds with [`SdkError<GetReadinessCheckResourceStatusError>`](crate::error::GetReadinessCheckResourceStatusError)
    pub fn get_readiness_check_resource_status(
        &self,
    ) -> fluent_builders::GetReadinessCheckResourceStatus<C, M, R> {
        fluent_builders::GetReadinessCheckResourceStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetReadinessCheckStatus`](crate::client::fluent_builders::GetReadinessCheckStatus) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetReadinessCheckStatus::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetReadinessCheckStatus::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::GetReadinessCheckStatus::set_max_results): Upper bound on number of records to return.
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetReadinessCheckStatus::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetReadinessCheckStatus::set_next_token): A token used to resume pagination from the end of a previous request.
    ///   - [`readiness_check_name(impl Into<String>)`](crate::client::fluent_builders::GetReadinessCheckStatus::readiness_check_name) / [`set_readiness_check_name(Option<String>)`](crate::client::fluent_builders::GetReadinessCheckStatus::set_readiness_check_name): The ReadinessCheck to get
    /// - On success, responds with [`GetReadinessCheckStatusOutput`](crate::output::GetReadinessCheckStatusOutput) with field(s):
    ///   - [`messages(Option<Vec<Message>>)`](crate::output::GetReadinessCheckStatusOutput::messages): Top level messages for readiness check status
    ///   - [`next_token(Option<String>)`](crate::output::GetReadinessCheckStatusOutput::next_token): A token that can be used to resume pagination from the end of the collection.
    ///   - [`readiness(Option<Readiness>)`](crate::output::GetReadinessCheckStatusOutput::readiness): The readiness at rule level.
    ///   - [`resources(Option<Vec<ResourceResult>>)`](crate::output::GetReadinessCheckStatusOutput::resources): Summary of resources's readiness
    /// - On failure, responds with [`SdkError<GetReadinessCheckStatusError>`](crate::error::GetReadinessCheckStatusError)
    pub fn get_readiness_check_status(&self) -> fluent_builders::GetReadinessCheckStatus<C, M, R> {
        fluent_builders::GetReadinessCheckStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRecoveryGroup`](crate::client::fluent_builders::GetRecoveryGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`recovery_group_name(impl Into<String>)`](crate::client::fluent_builders::GetRecoveryGroup::recovery_group_name) / [`set_recovery_group_name(Option<String>)`](crate::client::fluent_builders::GetRecoveryGroup::set_recovery_group_name): The RecoveryGroup to get
    /// - On success, responds with [`GetRecoveryGroupOutput`](crate::output::GetRecoveryGroupOutput) with field(s):
    ///   - [`cells(Option<Vec<String>>)`](crate::output::GetRecoveryGroupOutput::cells): A list of Cell arns
    ///   - [`recovery_group_arn(Option<String>)`](crate::output::GetRecoveryGroupOutput::recovery_group_arn): The arn for the RecoveryGroup
    ///   - [`recovery_group_name(Option<String>)`](crate::output::GetRecoveryGroupOutput::recovery_group_name): The name of the RecoveryGroup
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetRecoveryGroupOutput::tags): A collection of tags associated with a resource
    /// - On failure, responds with [`SdkError<GetRecoveryGroupError>`](crate::error::GetRecoveryGroupError)
    pub fn get_recovery_group(&self) -> fluent_builders::GetRecoveryGroup<C, M, R> {
        fluent_builders::GetRecoveryGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRecoveryGroupReadinessSummary`](crate::client::fluent_builders::GetRecoveryGroupReadinessSummary) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetRecoveryGroupReadinessSummary::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetRecoveryGroupReadinessSummary::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::GetRecoveryGroupReadinessSummary::set_max_results): Upper bound on number of records to return.
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetRecoveryGroupReadinessSummary::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetRecoveryGroupReadinessSummary::set_next_token): A token used to resume pagination from the end of a previous request.
    ///   - [`recovery_group_name(impl Into<String>)`](crate::client::fluent_builders::GetRecoveryGroupReadinessSummary::recovery_group_name) / [`set_recovery_group_name(Option<String>)`](crate::client::fluent_builders::GetRecoveryGroupReadinessSummary::set_recovery_group_name): The name of the RecoveryGroup
    /// - On success, responds with [`GetRecoveryGroupReadinessSummaryOutput`](crate::output::GetRecoveryGroupReadinessSummaryOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::GetRecoveryGroupReadinessSummaryOutput::next_token): A token that can be used to resume pagination from the end of the collection.
    ///   - [`readiness(Option<Readiness>)`](crate::output::GetRecoveryGroupReadinessSummaryOutput::readiness): The readiness at RecoveryGroup level.
    ///   - [`readiness_checks(Option<Vec<ReadinessCheckSummary>>)`](crate::output::GetRecoveryGroupReadinessSummaryOutput::readiness_checks): Summaries for the ReadinessChecks making up the RecoveryGroup
    /// - On failure, responds with [`SdkError<GetRecoveryGroupReadinessSummaryError>`](crate::error::GetRecoveryGroupReadinessSummaryError)
    pub fn get_recovery_group_readiness_summary(
        &self,
    ) -> fluent_builders::GetRecoveryGroupReadinessSummary<C, M, R> {
        fluent_builders::GetRecoveryGroupReadinessSummary::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetResourceSet`](crate::client::fluent_builders::GetResourceSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_set_name(impl Into<String>)`](crate::client::fluent_builders::GetResourceSet::resource_set_name) / [`set_resource_set_name(Option<String>)`](crate::client::fluent_builders::GetResourceSet::set_resource_set_name): The ResourceSet to get
    /// - On success, responds with [`GetResourceSetOutput`](crate::output::GetResourceSetOutput) with field(s):
    ///   - [`resource_set_arn(Option<String>)`](crate::output::GetResourceSetOutput::resource_set_arn): The arn for the ResourceSet
    ///   - [`resource_set_name(Option<String>)`](crate::output::GetResourceSetOutput::resource_set_name): The name of the ResourceSet
    ///   - [`resource_set_type(Option<String>)`](crate::output::GetResourceSetOutput::resource_set_type): AWS Resource Type of the resources in the ResourceSet
    ///   - [`resources(Option<Vec<Resource>>)`](crate::output::GetResourceSetOutput::resources): A list of Resource objects
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetResourceSetOutput::tags): A collection of tags associated with a resource
    /// - On failure, responds with [`SdkError<GetResourceSetError>`](crate::error::GetResourceSetError)
    pub fn get_resource_set(&self) -> fluent_builders::GetResourceSet<C, M, R> {
        fluent_builders::GetResourceSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListCells`](crate::client::fluent_builders::ListCells) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListCells::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListCells::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListCells::set_max_results): Upper bound on number of records to return.
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListCells::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListCells::set_next_token): A token used to resume pagination from the end of a previous request.
    /// - On success, responds with [`ListCellsOutput`](crate::output::ListCellsOutput) with field(s):
    ///   - [`cells(Option<Vec<CellOutput>>)`](crate::output::ListCellsOutput::cells): A list of Cells
    ///   - [`next_token(Option<String>)`](crate::output::ListCellsOutput::next_token): A token that can be used to resume pagination from the end of the collection.
    /// - On failure, responds with [`SdkError<ListCellsError>`](crate::error::ListCellsError)
    pub fn list_cells(&self) -> fluent_builders::ListCells<C, M, R> {
        fluent_builders::ListCells::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListCrossAccountAuthorizations`](crate::client::fluent_builders::ListCrossAccountAuthorizations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListCrossAccountAuthorizations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListCrossAccountAuthorizations::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListCrossAccountAuthorizations::set_max_results): Upper bound on number of records to return.
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListCrossAccountAuthorizations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListCrossAccountAuthorizations::set_next_token): A token used to resume pagination from the end of a previous request.
    /// - On success, responds with [`ListCrossAccountAuthorizationsOutput`](crate::output::ListCrossAccountAuthorizationsOutput) with field(s):
    ///   - [`cross_account_authorizations(Option<Vec<String>>)`](crate::output::ListCrossAccountAuthorizationsOutput::cross_account_authorizations): A list of CrossAccountAuthorizations
    ///   - [`next_token(Option<String>)`](crate::output::ListCrossAccountAuthorizationsOutput::next_token): A token that can be used to resume pagination from the end of the collection.
    /// - On failure, responds with [`SdkError<ListCrossAccountAuthorizationsError>`](crate::error::ListCrossAccountAuthorizationsError)
    pub fn list_cross_account_authorizations(
        &self,
    ) -> fluent_builders::ListCrossAccountAuthorizations<C, M, R> {
        fluent_builders::ListCrossAccountAuthorizations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListReadinessChecks`](crate::client::fluent_builders::ListReadinessChecks) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListReadinessChecks::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListReadinessChecks::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListReadinessChecks::set_max_results): Upper bound on number of records to return.
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListReadinessChecks::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListReadinessChecks::set_next_token): A token used to resume pagination from the end of a previous request.
    /// - On success, responds with [`ListReadinessChecksOutput`](crate::output::ListReadinessChecksOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListReadinessChecksOutput::next_token): A token that can be used to resume pagination from the end of the collection.
    ///   - [`readiness_checks(Option<Vec<ReadinessCheckOutput>>)`](crate::output::ListReadinessChecksOutput::readiness_checks): A list of ReadinessCheck associated with the account
    /// - On failure, responds with [`SdkError<ListReadinessChecksError>`](crate::error::ListReadinessChecksError)
    pub fn list_readiness_checks(&self) -> fluent_builders::ListReadinessChecks<C, M, R> {
        fluent_builders::ListReadinessChecks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRecoveryGroups`](crate::client::fluent_builders::ListRecoveryGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListRecoveryGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListRecoveryGroups::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListRecoveryGroups::set_max_results): Upper bound on number of records to return.
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListRecoveryGroups::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListRecoveryGroups::set_next_token): A token used to resume pagination from the end of a previous request.
    /// - On success, responds with [`ListRecoveryGroupsOutput`](crate::output::ListRecoveryGroupsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListRecoveryGroupsOutput::next_token): A token that can be used to resume pagination from the end of the collection.
    ///   - [`recovery_groups(Option<Vec<RecoveryGroupOutput>>)`](crate::output::ListRecoveryGroupsOutput::recovery_groups): A list of RecoveryGroups
    /// - On failure, responds with [`SdkError<ListRecoveryGroupsError>`](crate::error::ListRecoveryGroupsError)
    pub fn list_recovery_groups(&self) -> fluent_builders::ListRecoveryGroups<C, M, R> {
        fluent_builders::ListRecoveryGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListResourceSets`](crate::client::fluent_builders::ListResourceSets) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListResourceSets::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListResourceSets::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListResourceSets::set_max_results): Upper bound on number of records to return.
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListResourceSets::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListResourceSets::set_next_token): A token used to resume pagination from the end of a previous request.
    /// - On success, responds with [`ListResourceSetsOutput`](crate::output::ListResourceSetsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListResourceSetsOutput::next_token): A token that can be used to resume pagination from the end of the collection.
    ///   - [`resource_sets(Option<Vec<ResourceSetOutput>>)`](crate::output::ListResourceSetsOutput::resource_sets): A list of ResourceSets associated with the account
    /// - On failure, responds with [`SdkError<ListResourceSetsError>`](crate::error::ListResourceSetsError)
    pub fn list_resource_sets(&self) -> fluent_builders::ListResourceSets<C, M, R> {
        fluent_builders::ListResourceSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRules`](crate::client::fluent_builders::ListRules) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListRules::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListRules::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListRules::set_max_results): Upper bound on number of records to return.
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListRules::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListRules::set_next_token): A token used to resume pagination from the end of a previous request.
    ///   - [`resource_type(impl Into<String>)`](crate::client::fluent_builders::ListRules::resource_type) / [`set_resource_type(Option<String>)`](crate::client::fluent_builders::ListRules::set_resource_type): Filter parameter which specifies the rules to return given a resource type.
    /// - On success, responds with [`ListRulesOutput`](crate::output::ListRulesOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListRulesOutput::next_token): A token that can be used to resume pagination from the end of the collection.
    ///   - [`rules(Option<Vec<ListRulesOutput>>)`](crate::output::ListRulesOutput::rules): A list of rules
    /// - On failure, responds with [`SdkError<ListRulesError>`](crate::error::ListRulesError)
    pub fn list_rules(&self) -> fluent_builders::ListRules<C, M, R> {
        fluent_builders::ListRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResources`](crate::client::fluent_builders::ListTagsForResources) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResources::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResources::set_resource_arn): The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
    /// - On success, responds with [`ListTagsForResourcesOutput`](crate::output::ListTagsForResourcesOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourcesOutput::tags): A collection of tags associated with a resource
    /// - On failure, responds with [`SdkError<ListTagsForResourcesError>`](crate::error::ListTagsForResourcesError)
    pub fn list_tags_for_resources(&self) -> fluent_builders::ListTagsForResources<C, M, R> {
        fluent_builders::ListTagsForResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): A collection of tags associated with a resource
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): A comma-separated list of the tag keys to remove from the resource.
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateCell`](crate::client::fluent_builders::UpdateCell) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cell_name(impl Into<String>)`](crate::client::fluent_builders::UpdateCell::cell_name) / [`set_cell_name(Option<String>)`](crate::client::fluent_builders::UpdateCell::set_cell_name): The Cell to update
    ///   - [`cells(Vec<String>)`](crate::client::fluent_builders::UpdateCell::cells) / [`set_cells(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateCell::set_cells): A list of Cell arns, completely replaces previous list
    /// - On success, responds with [`UpdateCellOutput`](crate::output::UpdateCellOutput) with field(s):
    ///   - [`cell_arn(Option<String>)`](crate::output::UpdateCellOutput::cell_arn): The arn for the Cell
    ///   - [`cell_name(Option<String>)`](crate::output::UpdateCellOutput::cell_name): The name of the Cell
    ///   - [`cells(Option<Vec<String>>)`](crate::output::UpdateCellOutput::cells): A list of Cell arns
    ///   - [`parent_readiness_scopes(Option<Vec<String>>)`](crate::output::UpdateCellOutput::parent_readiness_scopes): A list of Cell ARNs and/or RecoveryGroup ARNs
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::UpdateCellOutput::tags): A collection of tags associated with a resource
    /// - On failure, responds with [`SdkError<UpdateCellError>`](crate::error::UpdateCellError)
    pub fn update_cell(&self) -> fluent_builders::UpdateCell<C, M, R> {
        fluent_builders::UpdateCell::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateReadinessCheck`](crate::client::fluent_builders::UpdateReadinessCheck) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`readiness_check_name(impl Into<String>)`](crate::client::fluent_builders::UpdateReadinessCheck::readiness_check_name) / [`set_readiness_check_name(Option<String>)`](crate::client::fluent_builders::UpdateReadinessCheck::set_readiness_check_name): The ReadinessCheck to update
    ///   - [`resource_set_name(impl Into<String>)`](crate::client::fluent_builders::UpdateReadinessCheck::resource_set_name) / [`set_resource_set_name(Option<String>)`](crate::client::fluent_builders::UpdateReadinessCheck::set_resource_set_name): The name of the ResourceSet to check
    /// - On success, responds with [`UpdateReadinessCheckOutput`](crate::output::UpdateReadinessCheckOutput) with field(s):
    ///   - [`readiness_check_arn(Option<String>)`](crate::output::UpdateReadinessCheckOutput::readiness_check_arn): Arn associated with ReadinessCheck
    ///   - [`readiness_check_name(Option<String>)`](crate::output::UpdateReadinessCheckOutput::readiness_check_name): Name for a ReadinessCheck
    ///   - [`resource_set(Option<String>)`](crate::output::UpdateReadinessCheckOutput::resource_set): Name of the ResourceSet to be checked
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::UpdateReadinessCheckOutput::tags): A collection of tags associated with a resource
    /// - On failure, responds with [`SdkError<UpdateReadinessCheckError>`](crate::error::UpdateReadinessCheckError)
    pub fn update_readiness_check(&self) -> fluent_builders::UpdateReadinessCheck<C, M, R> {
        fluent_builders::UpdateReadinessCheck::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateRecoveryGroup`](crate::client::fluent_builders::UpdateRecoveryGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cells(Vec<String>)`](crate::client::fluent_builders::UpdateRecoveryGroup::cells) / [`set_cells(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateRecoveryGroup::set_cells): A list of Cell arns, completely replaces previous list
    ///   - [`recovery_group_name(impl Into<String>)`](crate::client::fluent_builders::UpdateRecoveryGroup::recovery_group_name) / [`set_recovery_group_name(Option<String>)`](crate::client::fluent_builders::UpdateRecoveryGroup::set_recovery_group_name): The RecoveryGroup to update
    /// - On success, responds with [`UpdateRecoveryGroupOutput`](crate::output::UpdateRecoveryGroupOutput) with field(s):
    ///   - [`cells(Option<Vec<String>>)`](crate::output::UpdateRecoveryGroupOutput::cells): A list of Cell arns
    ///   - [`recovery_group_arn(Option<String>)`](crate::output::UpdateRecoveryGroupOutput::recovery_group_arn): The arn for the RecoveryGroup
    ///   - [`recovery_group_name(Option<String>)`](crate::output::UpdateRecoveryGroupOutput::recovery_group_name): The name of the RecoveryGroup
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::UpdateRecoveryGroupOutput::tags): A collection of tags associated with a resource
    /// - On failure, responds with [`SdkError<UpdateRecoveryGroupError>`](crate::error::UpdateRecoveryGroupError)
    pub fn update_recovery_group(&self) -> fluent_builders::UpdateRecoveryGroup<C, M, R> {
        fluent_builders::UpdateRecoveryGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateResourceSet`](crate::client::fluent_builders::UpdateResourceSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_set_name(impl Into<String>)`](crate::client::fluent_builders::UpdateResourceSet::resource_set_name) / [`set_resource_set_name(Option<String>)`](crate::client::fluent_builders::UpdateResourceSet::set_resource_set_name): The ResourceSet to update
    ///   - [`resource_set_type(impl Into<String>)`](crate::client::fluent_builders::UpdateResourceSet::resource_set_type) / [`set_resource_set_type(Option<String>)`](crate::client::fluent_builders::UpdateResourceSet::set_resource_set_type): AWS Resource Type of the resources in the ResourceSet
    ///   - [`resources(Vec<Resource>)`](crate::client::fluent_builders::UpdateResourceSet::resources) / [`set_resources(Option<Vec<Resource>>)`](crate::client::fluent_builders::UpdateResourceSet::set_resources): A list of Resource objects
    /// - On success, responds with [`UpdateResourceSetOutput`](crate::output::UpdateResourceSetOutput) with field(s):
    ///   - [`resource_set_arn(Option<String>)`](crate::output::UpdateResourceSetOutput::resource_set_arn): The arn for the ResourceSet
    ///   - [`resource_set_name(Option<String>)`](crate::output::UpdateResourceSetOutput::resource_set_name): The name of the ResourceSet
    ///   - [`resource_set_type(Option<String>)`](crate::output::UpdateResourceSetOutput::resource_set_type): AWS Resource Type of the resources in the ResourceSet
    ///   - [`resources(Option<Vec<Resource>>)`](crate::output::UpdateResourceSetOutput::resources): A list of Resource objects
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::UpdateResourceSetOutput::tags): A collection of tags associated with a resource
    /// - On failure, responds with [`SdkError<UpdateResourceSetError>`](crate::error::UpdateResourceSetError)
    pub fn update_resource_set(&self) -> fluent_builders::UpdateResourceSet<C, M, R> {
        fluent_builders::UpdateResourceSet::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateCell`.
    ///
    /// Creates a new Cell.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCell<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_cell_input::Builder,
    }
    impl<C, M, R> CreateCell<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCell`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCellOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCellError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCellInputOperationOutputAlias,
                crate::output::CreateCellOutput,
                crate::error::CreateCellError,
                crate::input::CreateCellInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The name of the Cell to create
        pub fn cell_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cell_name(input.into());
            self
        }
        /// The name of the Cell to create
        pub fn set_cell_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cell_name(input);
            self
        }
        /// Appends an item to `Cells`.
        ///
        /// To override the contents of this collection use [`set_cells`](Self::set_cells).
        ///
        /// A list of Cell arns contained within this Cell (for use in nested Cells, e.g. regions within which AZs)
        pub fn cells(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cells(input.into());
            self
        }
        /// A list of Cell arns contained within this Cell (for use in nested Cells, e.g. regions within which AZs)
        pub fn set_cells(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_cells(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCrossAccountAuthorization`.
    ///
    /// Create a new cross account readiness authorization.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCrossAccountAuthorization<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_cross_account_authorization_input::Builder,
    }
    impl<C, M, R> CreateCrossAccountAuthorization<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCrossAccountAuthorization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCrossAccountAuthorizationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCrossAccountAuthorizationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCrossAccountAuthorizationInputOperationOutputAlias,
                crate::output::CreateCrossAccountAuthorizationOutput,
                crate::error::CreateCrossAccountAuthorizationError,
                crate::input::CreateCrossAccountAuthorizationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The cross account authorization
        pub fn cross_account_authorization(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.cross_account_authorization(input.into());
            self
        }
        /// The cross account authorization
        pub fn set_cross_account_authorization(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cross_account_authorization(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateReadinessCheck`.
    ///
    /// Creates a new Readiness Check.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateReadinessCheck<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_readiness_check_input::Builder,
    }
    impl<C, M, R> CreateReadinessCheck<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateReadinessCheck`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateReadinessCheckOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateReadinessCheckError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateReadinessCheckInputOperationOutputAlias,
                crate::output::CreateReadinessCheckOutput,
                crate::error::CreateReadinessCheckError,
                crate::input::CreateReadinessCheckInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The name of the ReadinessCheck to create
        pub fn readiness_check_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.readiness_check_name(input.into());
            self
        }
        /// The name of the ReadinessCheck to create
        pub fn set_readiness_check_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_readiness_check_name(input);
            self
        }
        /// The name of the ResourceSet to check
        pub fn resource_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_set_name(input.into());
            self
        }
        /// The name of the ResourceSet to check
        pub fn set_resource_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_set_name(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRecoveryGroup`.
    ///
    /// Creates a new Recovery Group.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRecoveryGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_recovery_group_input::Builder,
    }
    impl<C, M, R> CreateRecoveryGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRecoveryGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRecoveryGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRecoveryGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRecoveryGroupInputOperationOutputAlias,
                crate::output::CreateRecoveryGroupOutput,
                crate::error::CreateRecoveryGroupError,
                crate::input::CreateRecoveryGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Cells`.
        ///
        /// To override the contents of this collection use [`set_cells`](Self::set_cells).
        ///
        /// A list of Cell arns
        pub fn cells(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cells(input.into());
            self
        }
        /// A list of Cell arns
        pub fn set_cells(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_cells(input);
            self
        }
        /// The name of the RecoveryGroup to create
        pub fn recovery_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recovery_group_name(input.into());
            self
        }
        /// The name of the RecoveryGroup to create
        pub fn set_recovery_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recovery_group_name(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateResourceSet`.
    ///
    /// Creates a new Resource Set.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateResourceSet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_resource_set_input::Builder,
    }
    impl<C, M, R> CreateResourceSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateResourceSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateResourceSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateResourceSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateResourceSetInputOperationOutputAlias,
                crate::output::CreateResourceSetOutput,
                crate::error::CreateResourceSetError,
                crate::input::CreateResourceSetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The name of the ResourceSet to create
        pub fn resource_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_set_name(input.into());
            self
        }
        /// The name of the ResourceSet to create
        pub fn set_resource_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_set_name(input);
            self
        }
        /// AWS Resource type of the resources in the ResourceSet
        pub fn resource_set_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_set_type(input.into());
            self
        }
        /// AWS Resource type of the resources in the ResourceSet
        pub fn set_resource_set_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_set_type(input);
            self
        }
        /// Appends an item to `Resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// A list of Resource objects
        pub fn resources(mut self, input: crate::model::Resource) -> Self {
            self.inner = self.inner.resources(input);
            self
        }
        /// A list of Resource objects
        pub fn set_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        ) -> Self {
            self.inner = self.inner.set_resources(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCell`.
    ///
    /// Deletes an existing Cell.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCell<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_cell_input::Builder,
    }
    impl<C, M, R> DeleteCell<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCell`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCellOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCellError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteCellInputOperationOutputAlias,
                crate::output::DeleteCellOutput,
                crate::error::DeleteCellError,
                crate::input::DeleteCellInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The Cell to delete
        pub fn cell_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cell_name(input.into());
            self
        }
        /// The Cell to delete
        pub fn set_cell_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cell_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCrossAccountAuthorization`.
    ///
    /// Delete cross account readiness authorization
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCrossAccountAuthorization<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_cross_account_authorization_input::Builder,
    }
    impl<C, M, R> DeleteCrossAccountAuthorization<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCrossAccountAuthorization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCrossAccountAuthorizationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCrossAccountAuthorizationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteCrossAccountAuthorizationInputOperationOutputAlias,
                crate::output::DeleteCrossAccountAuthorizationOutput,
                crate::error::DeleteCrossAccountAuthorizationError,
                crate::input::DeleteCrossAccountAuthorizationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The cross account authorization
        pub fn cross_account_authorization(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.cross_account_authorization(input.into());
            self
        }
        /// The cross account authorization
        pub fn set_cross_account_authorization(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cross_account_authorization(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteReadinessCheck`.
    ///
    /// Deletes an existing Readiness Check.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteReadinessCheck<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_readiness_check_input::Builder,
    }
    impl<C, M, R> DeleteReadinessCheck<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteReadinessCheck`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteReadinessCheckOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteReadinessCheckError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteReadinessCheckInputOperationOutputAlias,
                crate::output::DeleteReadinessCheckOutput,
                crate::error::DeleteReadinessCheckError,
                crate::input::DeleteReadinessCheckInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ReadinessCheck to delete
        pub fn readiness_check_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.readiness_check_name(input.into());
            self
        }
        /// The ReadinessCheck to delete
        pub fn set_readiness_check_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_readiness_check_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRecoveryGroup`.
    ///
    /// Deletes an existing Recovery Group.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRecoveryGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_recovery_group_input::Builder,
    }
    impl<C, M, R> DeleteRecoveryGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRecoveryGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRecoveryGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRecoveryGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRecoveryGroupInputOperationOutputAlias,
                crate::output::DeleteRecoveryGroupOutput,
                crate::error::DeleteRecoveryGroupError,
                crate::input::DeleteRecoveryGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The RecoveryGroup to delete
        pub fn recovery_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recovery_group_name(input.into());
            self
        }
        /// The RecoveryGroup to delete
        pub fn set_recovery_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recovery_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResourceSet`.
    ///
    /// Deletes an existing Resource Set.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteResourceSet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_resource_set_input::Builder,
    }
    impl<C, M, R> DeleteResourceSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteResourceSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResourceSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResourceSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteResourceSetInputOperationOutputAlias,
                crate::output::DeleteResourceSetOutput,
                crate::error::DeleteResourceSetError,
                crate::input::DeleteResourceSetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ResourceSet to delete
        pub fn resource_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_set_name(input.into());
            self
        }
        /// The ResourceSet to delete
        pub fn set_resource_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetArchitectureRecommendations`.
    ///
    /// Returns a collection of recommendations to improve resilliance and readiness check quality for a Recovery Group.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetArchitectureRecommendations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_architecture_recommendations_input::Builder,
    }
    impl<C, M, R> GetArchitectureRecommendations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetArchitectureRecommendations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetArchitectureRecommendationsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetArchitectureRecommendationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetArchitectureRecommendationsInputOperationOutputAlias,
                crate::output::GetArchitectureRecommendationsOutput,
                crate::error::GetArchitectureRecommendationsError,
                crate::input::GetArchitectureRecommendationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Upper bound on number of records to return.
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// Upper bound on number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// A token that can be used to resume pagination from the end of the collection.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// A token that can be used to resume pagination from the end of the collection.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Name of RecoveryGroup (top level resource) to be analyzed.
        pub fn recovery_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recovery_group_name(input.into());
            self
        }
        /// Name of RecoveryGroup (top level resource) to be analyzed.
        pub fn set_recovery_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recovery_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCell`.
    ///
    /// Returns information about a Cell.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCell<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_cell_input::Builder,
    }
    impl<C, M, R> GetCell<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCell`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCellOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCellError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCellInputOperationOutputAlias,
                crate::output::GetCellOutput,
                crate::error::GetCellError,
                crate::input::GetCellInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The Cell to get
        pub fn cell_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cell_name(input.into());
            self
        }
        /// The Cell to get
        pub fn set_cell_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cell_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCellReadinessSummary`.
    ///
    /// Returns information about readiness of a Cell.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCellReadinessSummary<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_cell_readiness_summary_input::Builder,
    }
    impl<C, M, R> GetCellReadinessSummary<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCellReadinessSummary`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCellReadinessSummaryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCellReadinessSummaryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCellReadinessSummaryInputOperationOutputAlias,
                crate::output::GetCellReadinessSummaryOutput,
                crate::error::GetCellReadinessSummaryError,
                crate::input::GetCellReadinessSummaryInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetCellReadinessSummaryPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetCellReadinessSummaryPaginator<C, M, R> {
            crate::paginator::GetCellReadinessSummaryPaginator::new(self.handle, self.inner)
        }
        /// The name of the Cell
        pub fn cell_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cell_name(input.into());
            self
        }
        /// The name of the Cell
        pub fn set_cell_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cell_name(input);
            self
        }
        /// Upper bound on number of records to return.
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// Upper bound on number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetReadinessCheck`.
    ///
    /// Returns information about a ReadinessCheck.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetReadinessCheck<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_readiness_check_input::Builder,
    }
    impl<C, M, R> GetReadinessCheck<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetReadinessCheck`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetReadinessCheckOutput,
            aws_smithy_http::result::SdkError<crate::error::GetReadinessCheckError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetReadinessCheckInputOperationOutputAlias,
                crate::output::GetReadinessCheckOutput,
                crate::error::GetReadinessCheckError,
                crate::input::GetReadinessCheckInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ReadinessCheck to get
        pub fn readiness_check_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.readiness_check_name(input.into());
            self
        }
        /// The ReadinessCheck to get
        pub fn set_readiness_check_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_readiness_check_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetReadinessCheckResourceStatus`.
    ///
    /// Returns detailed information about the status of an individual resource within a Readiness Check's Resource Set.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetReadinessCheckResourceStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_readiness_check_resource_status_input::Builder,
    }
    impl<C, M, R> GetReadinessCheckResourceStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetReadinessCheckResourceStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetReadinessCheckResourceStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetReadinessCheckResourceStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetReadinessCheckResourceStatusInputOperationOutputAlias,
                crate::output::GetReadinessCheckResourceStatusOutput,
                crate::error::GetReadinessCheckResourceStatusError,
                crate::input::GetReadinessCheckResourceStatusInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetReadinessCheckResourceStatusPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::GetReadinessCheckResourceStatusPaginator<C, M, R> {
            crate::paginator::GetReadinessCheckResourceStatusPaginator::new(self.handle, self.inner)
        }
        /// Upper bound on number of records to return.
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// Upper bound on number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// The ReadinessCheck to get
        pub fn readiness_check_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.readiness_check_name(input.into());
            self
        }
        /// The ReadinessCheck to get
        pub fn set_readiness_check_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_readiness_check_name(input);
            self
        }
        /// The resource ARN or component Id to get
        pub fn resource_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_identifier(input.into());
            self
        }
        /// The resource ARN or component Id to get
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetReadinessCheckStatus`.
    ///
    /// Returns information about the status of a Readiness Check.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetReadinessCheckStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_readiness_check_status_input::Builder,
    }
    impl<C, M, R> GetReadinessCheckStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetReadinessCheckStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetReadinessCheckStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetReadinessCheckStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetReadinessCheckStatusInputOperationOutputAlias,
                crate::output::GetReadinessCheckStatusOutput,
                crate::error::GetReadinessCheckStatusError,
                crate::input::GetReadinessCheckStatusInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetReadinessCheckStatusPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetReadinessCheckStatusPaginator<C, M, R> {
            crate::paginator::GetReadinessCheckStatusPaginator::new(self.handle, self.inner)
        }
        /// Upper bound on number of records to return.
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// Upper bound on number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// The ReadinessCheck to get
        pub fn readiness_check_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.readiness_check_name(input.into());
            self
        }
        /// The ReadinessCheck to get
        pub fn set_readiness_check_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_readiness_check_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRecoveryGroup`.
    ///
    /// Returns information about a Recovery Group.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRecoveryGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_recovery_group_input::Builder,
    }
    impl<C, M, R> GetRecoveryGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRecoveryGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRecoveryGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRecoveryGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRecoveryGroupInputOperationOutputAlias,
                crate::output::GetRecoveryGroupOutput,
                crate::error::GetRecoveryGroupError,
                crate::input::GetRecoveryGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The RecoveryGroup to get
        pub fn recovery_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recovery_group_name(input.into());
            self
        }
        /// The RecoveryGroup to get
        pub fn set_recovery_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recovery_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRecoveryGroupReadinessSummary`.
    ///
    /// Returns information about a Recovery Group.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRecoveryGroupReadinessSummary<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_recovery_group_readiness_summary_input::Builder,
    }
    impl<C, M, R> GetRecoveryGroupReadinessSummary<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRecoveryGroupReadinessSummary`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRecoveryGroupReadinessSummaryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRecoveryGroupReadinessSummaryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRecoveryGroupReadinessSummaryInputOperationOutputAlias,
                crate::output::GetRecoveryGroupReadinessSummaryOutput,
                crate::error::GetRecoveryGroupReadinessSummaryError,
                crate::input::GetRecoveryGroupReadinessSummaryInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetRecoveryGroupReadinessSummaryPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::GetRecoveryGroupReadinessSummaryPaginator<C, M, R> {
            crate::paginator::GetRecoveryGroupReadinessSummaryPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// Upper bound on number of records to return.
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// Upper bound on number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// The name of the RecoveryGroup
        pub fn recovery_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recovery_group_name(input.into());
            self
        }
        /// The name of the RecoveryGroup
        pub fn set_recovery_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recovery_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResourceSet`.
    ///
    /// Returns information about a Resource Set.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetResourceSet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_resource_set_input::Builder,
    }
    impl<C, M, R> GetResourceSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetResourceSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResourceSetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResourceSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetResourceSetInputOperationOutputAlias,
                crate::output::GetResourceSetOutput,
                crate::error::GetResourceSetError,
                crate::input::GetResourceSetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ResourceSet to get
        pub fn resource_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_set_name(input.into());
            self
        }
        /// The ResourceSet to get
        pub fn set_resource_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCells`.
    ///
    /// Returns a collection of Cells.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCells<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_cells_input::Builder,
    }
    impl<C, M, R> ListCells<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCells`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCellsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCellsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCellsInputOperationOutputAlias,
                crate::output::ListCellsOutput,
                crate::error::ListCellsError,
                crate::input::ListCellsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListCellsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListCellsPaginator<C, M, R> {
            crate::paginator::ListCellsPaginator::new(self.handle, self.inner)
        }
        /// Upper bound on number of records to return.
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// Upper bound on number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCrossAccountAuthorizations`.
    ///
    /// Returns a collection of cross account readiness authorizations.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCrossAccountAuthorizations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_cross_account_authorizations_input::Builder,
    }
    impl<C, M, R> ListCrossAccountAuthorizations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCrossAccountAuthorizations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCrossAccountAuthorizationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCrossAccountAuthorizationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCrossAccountAuthorizationsInputOperationOutputAlias,
                crate::output::ListCrossAccountAuthorizationsOutput,
                crate::error::ListCrossAccountAuthorizationsError,
                crate::input::ListCrossAccountAuthorizationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListCrossAccountAuthorizationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListCrossAccountAuthorizationsPaginator<C, M, R> {
            crate::paginator::ListCrossAccountAuthorizationsPaginator::new(self.handle, self.inner)
        }
        /// Upper bound on number of records to return.
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// Upper bound on number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListReadinessChecks`.
    ///
    /// Returns a collection of Readiness Checks.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListReadinessChecks<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_readiness_checks_input::Builder,
    }
    impl<C, M, R> ListReadinessChecks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListReadinessChecks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListReadinessChecksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListReadinessChecksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListReadinessChecksInputOperationOutputAlias,
                crate::output::ListReadinessChecksOutput,
                crate::error::ListReadinessChecksError,
                crate::input::ListReadinessChecksInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListReadinessChecksPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListReadinessChecksPaginator<C, M, R> {
            crate::paginator::ListReadinessChecksPaginator::new(self.handle, self.inner)
        }
        /// Upper bound on number of records to return.
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// Upper bound on number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRecoveryGroups`.
    ///
    /// Returns a collection of Recovery Groups.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRecoveryGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_recovery_groups_input::Builder,
    }
    impl<C, M, R> ListRecoveryGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRecoveryGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRecoveryGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRecoveryGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRecoveryGroupsInputOperationOutputAlias,
                crate::output::ListRecoveryGroupsOutput,
                crate::error::ListRecoveryGroupsError,
                crate::input::ListRecoveryGroupsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListRecoveryGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListRecoveryGroupsPaginator<C, M, R> {
            crate::paginator::ListRecoveryGroupsPaginator::new(self.handle, self.inner)
        }
        /// Upper bound on number of records to return.
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// Upper bound on number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResourceSets`.
    ///
    /// Returns a collection of Resource Sets.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListResourceSets<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_resource_sets_input::Builder,
    }
    impl<C, M, R> ListResourceSets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListResourceSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResourceSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResourceSetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListResourceSetsInputOperationOutputAlias,
                crate::output::ListResourceSetsOutput,
                crate::error::ListResourceSetsError,
                crate::input::ListResourceSetsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListResourceSetsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListResourceSetsPaginator<C, M, R> {
            crate::paginator::ListResourceSetsPaginator::new(self.handle, self.inner)
        }
        /// Upper bound on number of records to return.
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// Upper bound on number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRules`.
    ///
    /// Returns a collection of rules that are applied as part of Readiness Checks.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRules<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_rules_input::Builder,
    }
    impl<C, M, R> ListRules<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRulesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRulesInputOperationOutputAlias,
                crate::output::ListRulesOutput,
                crate::error::ListRulesError,
                crate::input::ListRulesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListRulesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListRulesPaginator<C, M, R> {
            crate::paginator::ListRulesPaginator::new(self.handle, self.inner)
        }
        /// Upper bound on number of records to return.
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// Upper bound on number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Filter parameter which specifies the rules to return given a resource type.
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_type(input.into());
            self
        }
        /// Filter parameter which specifies the rules to return given a resource type.
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResources`.
    ///
    /// Returns a list of the tags assigned to the specified resource.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResources<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resources_input::Builder,
    }
    impl<C, M, R> ListTagsForResources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourcesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourcesInputOperationOutputAlias,
                crate::output::ListTagsForResourcesOutput,
                crate::error::ListTagsForResourcesError,
                crate::input::ListTagsForResourcesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// Adds tags to the specified resource. You can specify one or more tags to add.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// Removes tags from the specified resource. You can specify one or more tags to remove.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// A comma-separated list of the tag keys to remove from the resource.
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// A comma-separated list of the tag keys to remove from the resource.
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateCell`.
    ///
    /// Updates an existing Cell.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateCell<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_cell_input::Builder,
    }
    impl<C, M, R> UpdateCell<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateCell`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateCellOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateCellError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateCellInputOperationOutputAlias,
                crate::output::UpdateCellOutput,
                crate::error::UpdateCellError,
                crate::input::UpdateCellInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The Cell to update
        pub fn cell_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cell_name(input.into());
            self
        }
        /// The Cell to update
        pub fn set_cell_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cell_name(input);
            self
        }
        /// Appends an item to `Cells`.
        ///
        /// To override the contents of this collection use [`set_cells`](Self::set_cells).
        ///
        /// A list of Cell arns, completely replaces previous list
        pub fn cells(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cells(input.into());
            self
        }
        /// A list of Cell arns, completely replaces previous list
        pub fn set_cells(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_cells(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateReadinessCheck`.
    ///
    /// Updates an exisiting Readiness Check.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateReadinessCheck<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_readiness_check_input::Builder,
    }
    impl<C, M, R> UpdateReadinessCheck<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateReadinessCheck`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateReadinessCheckOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateReadinessCheckError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateReadinessCheckInputOperationOutputAlias,
                crate::output::UpdateReadinessCheckOutput,
                crate::error::UpdateReadinessCheckError,
                crate::input::UpdateReadinessCheckInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ReadinessCheck to update
        pub fn readiness_check_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.readiness_check_name(input.into());
            self
        }
        /// The ReadinessCheck to update
        pub fn set_readiness_check_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_readiness_check_name(input);
            self
        }
        /// The name of the ResourceSet to check
        pub fn resource_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_set_name(input.into());
            self
        }
        /// The name of the ResourceSet to check
        pub fn set_resource_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRecoveryGroup`.
    ///
    /// Updates an existing Recovery Group.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateRecoveryGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_recovery_group_input::Builder,
    }
    impl<C, M, R> UpdateRecoveryGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRecoveryGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRecoveryGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRecoveryGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRecoveryGroupInputOperationOutputAlias,
                crate::output::UpdateRecoveryGroupOutput,
                crate::error::UpdateRecoveryGroupError,
                crate::input::UpdateRecoveryGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Cells`.
        ///
        /// To override the contents of this collection use [`set_cells`](Self::set_cells).
        ///
        /// A list of Cell arns, completely replaces previous list
        pub fn cells(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cells(input.into());
            self
        }
        /// A list of Cell arns, completely replaces previous list
        pub fn set_cells(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_cells(input);
            self
        }
        /// The RecoveryGroup to update
        pub fn recovery_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recovery_group_name(input.into());
            self
        }
        /// The RecoveryGroup to update
        pub fn set_recovery_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recovery_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateResourceSet`.
    ///
    /// Updates an existing Resource Set.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateResourceSet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_resource_set_input::Builder,
    }
    impl<C, M, R> UpdateResourceSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateResourceSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateResourceSetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateResourceSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateResourceSetInputOperationOutputAlias,
                crate::output::UpdateResourceSetOutput,
                crate::error::UpdateResourceSetError,
                crate::input::UpdateResourceSetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ResourceSet to update
        pub fn resource_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_set_name(input.into());
            self
        }
        /// The ResourceSet to update
        pub fn set_resource_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_set_name(input);
            self
        }
        /// AWS Resource Type of the resources in the ResourceSet
        pub fn resource_set_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_set_type(input.into());
            self
        }
        /// AWS Resource Type of the resources in the ResourceSet
        pub fn set_resource_set_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_set_type(input);
            self
        }
        /// Appends an item to `Resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// A list of Resource objects
        pub fn resources(mut self, input: crate::model::Resource) -> Self {
            self.inner = self.inner.resources(input);
            self
        }
        /// A list of Resource objects
        pub fn set_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        ) -> Self {
            self.inner = self.inner.set_resources(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
