// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CreateCell`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_cell`](crate::client::Client::create_cell).
///
/// See [`crate::client::fluent_builders::CreateCell`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCell {
    _private: (),
}
impl CreateCell {
    /// Creates a new builder-style object to manufacture [`CreateCellInput`](crate::input::CreateCellInput)
    pub fn builder() -> crate::input::create_cell_input::Builder {
        crate::input::create_cell_input::Builder::default()
    }
    /// Creates a new `CreateCell` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCell {
    type Output =
        std::result::Result<crate::output::CreateCellOutput, crate::error::CreateCellError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_cell_error(response)
        } else {
            crate::operation_deser::parse_create_cell_response(response)
        }
    }
}

/// Operation shape for `CreateCrossAccountAuthorization`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_cross_account_authorization`](crate::client::Client::create_cross_account_authorization).
///
/// See [`crate::client::fluent_builders::CreateCrossAccountAuthorization`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCrossAccountAuthorization {
    _private: (),
}
impl CreateCrossAccountAuthorization {
    /// Creates a new builder-style object to manufacture [`CreateCrossAccountAuthorizationInput`](crate::input::CreateCrossAccountAuthorizationInput)
    pub fn builder() -> crate::input::create_cross_account_authorization_input::Builder {
        crate::input::create_cross_account_authorization_input::Builder::default()
    }
    /// Creates a new `CreateCrossAccountAuthorization` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCrossAccountAuthorization {
    type Output = std::result::Result<
        crate::output::CreateCrossAccountAuthorizationOutput,
        crate::error::CreateCrossAccountAuthorizationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_cross_account_authorization_error(response)
        } else {
            crate::operation_deser::parse_create_cross_account_authorization_response(response)
        }
    }
}

/// Operation shape for `CreateReadinessCheck`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_readiness_check`](crate::client::Client::create_readiness_check).
///
/// See [`crate::client::fluent_builders::CreateReadinessCheck`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateReadinessCheck {
    _private: (),
}
impl CreateReadinessCheck {
    /// Creates a new builder-style object to manufacture [`CreateReadinessCheckInput`](crate::input::CreateReadinessCheckInput)
    pub fn builder() -> crate::input::create_readiness_check_input::Builder {
        crate::input::create_readiness_check_input::Builder::default()
    }
    /// Creates a new `CreateReadinessCheck` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateReadinessCheck {
    type Output = std::result::Result<
        crate::output::CreateReadinessCheckOutput,
        crate::error::CreateReadinessCheckError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_readiness_check_error(response)
        } else {
            crate::operation_deser::parse_create_readiness_check_response(response)
        }
    }
}

/// Operation shape for `CreateRecoveryGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_recovery_group`](crate::client::Client::create_recovery_group).
///
/// See [`crate::client::fluent_builders::CreateRecoveryGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRecoveryGroup {
    _private: (),
}
impl CreateRecoveryGroup {
    /// Creates a new builder-style object to manufacture [`CreateRecoveryGroupInput`](crate::input::CreateRecoveryGroupInput)
    pub fn builder() -> crate::input::create_recovery_group_input::Builder {
        crate::input::create_recovery_group_input::Builder::default()
    }
    /// Creates a new `CreateRecoveryGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRecoveryGroup {
    type Output = std::result::Result<
        crate::output::CreateRecoveryGroupOutput,
        crate::error::CreateRecoveryGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_recovery_group_error(response)
        } else {
            crate::operation_deser::parse_create_recovery_group_response(response)
        }
    }
}

/// Operation shape for `CreateResourceSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_resource_set`](crate::client::Client::create_resource_set).
///
/// See [`crate::client::fluent_builders::CreateResourceSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateResourceSet {
    _private: (),
}
impl CreateResourceSet {
    /// Creates a new builder-style object to manufacture [`CreateResourceSetInput`](crate::input::CreateResourceSetInput)
    pub fn builder() -> crate::input::create_resource_set_input::Builder {
        crate::input::create_resource_set_input::Builder::default()
    }
    /// Creates a new `CreateResourceSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateResourceSet {
    type Output = std::result::Result<
        crate::output::CreateResourceSetOutput,
        crate::error::CreateResourceSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_resource_set_error(response)
        } else {
            crate::operation_deser::parse_create_resource_set_response(response)
        }
    }
}

/// Operation shape for `DeleteCell`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_cell`](crate::client::Client::delete_cell).
///
/// See [`crate::client::fluent_builders::DeleteCell`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCell {
    _private: (),
}
impl DeleteCell {
    /// Creates a new builder-style object to manufacture [`DeleteCellInput`](crate::input::DeleteCellInput)
    pub fn builder() -> crate::input::delete_cell_input::Builder {
        crate::input::delete_cell_input::Builder::default()
    }
    /// Creates a new `DeleteCell` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCell {
    type Output =
        std::result::Result<crate::output::DeleteCellOutput, crate::error::DeleteCellError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_cell_error(response)
        } else {
            crate::operation_deser::parse_delete_cell_response(response)
        }
    }
}

/// Operation shape for `DeleteCrossAccountAuthorization`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_cross_account_authorization`](crate::client::Client::delete_cross_account_authorization).
///
/// See [`crate::client::fluent_builders::DeleteCrossAccountAuthorization`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCrossAccountAuthorization {
    _private: (),
}
impl DeleteCrossAccountAuthorization {
    /// Creates a new builder-style object to manufacture [`DeleteCrossAccountAuthorizationInput`](crate::input::DeleteCrossAccountAuthorizationInput)
    pub fn builder() -> crate::input::delete_cross_account_authorization_input::Builder {
        crate::input::delete_cross_account_authorization_input::Builder::default()
    }
    /// Creates a new `DeleteCrossAccountAuthorization` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCrossAccountAuthorization {
    type Output = std::result::Result<
        crate::output::DeleteCrossAccountAuthorizationOutput,
        crate::error::DeleteCrossAccountAuthorizationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_cross_account_authorization_error(response)
        } else {
            crate::operation_deser::parse_delete_cross_account_authorization_response(response)
        }
    }
}

/// Operation shape for `DeleteReadinessCheck`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_readiness_check`](crate::client::Client::delete_readiness_check).
///
/// See [`crate::client::fluent_builders::DeleteReadinessCheck`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteReadinessCheck {
    _private: (),
}
impl DeleteReadinessCheck {
    /// Creates a new builder-style object to manufacture [`DeleteReadinessCheckInput`](crate::input::DeleteReadinessCheckInput)
    pub fn builder() -> crate::input::delete_readiness_check_input::Builder {
        crate::input::delete_readiness_check_input::Builder::default()
    }
    /// Creates a new `DeleteReadinessCheck` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteReadinessCheck {
    type Output = std::result::Result<
        crate::output::DeleteReadinessCheckOutput,
        crate::error::DeleteReadinessCheckError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_readiness_check_error(response)
        } else {
            crate::operation_deser::parse_delete_readiness_check_response(response)
        }
    }
}

/// Operation shape for `DeleteRecoveryGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_recovery_group`](crate::client::Client::delete_recovery_group).
///
/// See [`crate::client::fluent_builders::DeleteRecoveryGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRecoveryGroup {
    _private: (),
}
impl DeleteRecoveryGroup {
    /// Creates a new builder-style object to manufacture [`DeleteRecoveryGroupInput`](crate::input::DeleteRecoveryGroupInput)
    pub fn builder() -> crate::input::delete_recovery_group_input::Builder {
        crate::input::delete_recovery_group_input::Builder::default()
    }
    /// Creates a new `DeleteRecoveryGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRecoveryGroup {
    type Output = std::result::Result<
        crate::output::DeleteRecoveryGroupOutput,
        crate::error::DeleteRecoveryGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_recovery_group_error(response)
        } else {
            crate::operation_deser::parse_delete_recovery_group_response(response)
        }
    }
}

/// Operation shape for `DeleteResourceSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_resource_set`](crate::client::Client::delete_resource_set).
///
/// See [`crate::client::fluent_builders::DeleteResourceSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteResourceSet {
    _private: (),
}
impl DeleteResourceSet {
    /// Creates a new builder-style object to manufacture [`DeleteResourceSetInput`](crate::input::DeleteResourceSetInput)
    pub fn builder() -> crate::input::delete_resource_set_input::Builder {
        crate::input::delete_resource_set_input::Builder::default()
    }
    /// Creates a new `DeleteResourceSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteResourceSet {
    type Output = std::result::Result<
        crate::output::DeleteResourceSetOutput,
        crate::error::DeleteResourceSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_resource_set_error(response)
        } else {
            crate::operation_deser::parse_delete_resource_set_response(response)
        }
    }
}

/// Operation shape for `GetArchitectureRecommendations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_architecture_recommendations`](crate::client::Client::get_architecture_recommendations).
///
/// See [`crate::client::fluent_builders::GetArchitectureRecommendations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetArchitectureRecommendations {
    _private: (),
}
impl GetArchitectureRecommendations {
    /// Creates a new builder-style object to manufacture [`GetArchitectureRecommendationsInput`](crate::input::GetArchitectureRecommendationsInput)
    pub fn builder() -> crate::input::get_architecture_recommendations_input::Builder {
        crate::input::get_architecture_recommendations_input::Builder::default()
    }
    /// Creates a new `GetArchitectureRecommendations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetArchitectureRecommendations {
    type Output = std::result::Result<
        crate::output::GetArchitectureRecommendationsOutput,
        crate::error::GetArchitectureRecommendationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_architecture_recommendations_error(response)
        } else {
            crate::operation_deser::parse_get_architecture_recommendations_response(response)
        }
    }
}

/// Operation shape for `GetCell`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_cell`](crate::client::Client::get_cell).
///
/// See [`crate::client::fluent_builders::GetCell`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCell {
    _private: (),
}
impl GetCell {
    /// Creates a new builder-style object to manufacture [`GetCellInput`](crate::input::GetCellInput)
    pub fn builder() -> crate::input::get_cell_input::Builder {
        crate::input::get_cell_input::Builder::default()
    }
    /// Creates a new `GetCell` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCell {
    type Output = std::result::Result<crate::output::GetCellOutput, crate::error::GetCellError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_cell_error(response)
        } else {
            crate::operation_deser::parse_get_cell_response(response)
        }
    }
}

/// Operation shape for `GetCellReadinessSummary`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_cell_readiness_summary`](crate::client::Client::get_cell_readiness_summary).
///
/// See [`crate::client::fluent_builders::GetCellReadinessSummary`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCellReadinessSummary {
    _private: (),
}
impl GetCellReadinessSummary {
    /// Creates a new builder-style object to manufacture [`GetCellReadinessSummaryInput`](crate::input::GetCellReadinessSummaryInput)
    pub fn builder() -> crate::input::get_cell_readiness_summary_input::Builder {
        crate::input::get_cell_readiness_summary_input::Builder::default()
    }
    /// Creates a new `GetCellReadinessSummary` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCellReadinessSummary {
    type Output = std::result::Result<
        crate::output::GetCellReadinessSummaryOutput,
        crate::error::GetCellReadinessSummaryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_cell_readiness_summary_error(response)
        } else {
            crate::operation_deser::parse_get_cell_readiness_summary_response(response)
        }
    }
}

/// Operation shape for `GetReadinessCheck`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_readiness_check`](crate::client::Client::get_readiness_check).
///
/// See [`crate::client::fluent_builders::GetReadinessCheck`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetReadinessCheck {
    _private: (),
}
impl GetReadinessCheck {
    /// Creates a new builder-style object to manufacture [`GetReadinessCheckInput`](crate::input::GetReadinessCheckInput)
    pub fn builder() -> crate::input::get_readiness_check_input::Builder {
        crate::input::get_readiness_check_input::Builder::default()
    }
    /// Creates a new `GetReadinessCheck` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetReadinessCheck {
    type Output = std::result::Result<
        crate::output::GetReadinessCheckOutput,
        crate::error::GetReadinessCheckError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_readiness_check_error(response)
        } else {
            crate::operation_deser::parse_get_readiness_check_response(response)
        }
    }
}

/// Operation shape for `GetReadinessCheckResourceStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_readiness_check_resource_status`](crate::client::Client::get_readiness_check_resource_status).
///
/// See [`crate::client::fluent_builders::GetReadinessCheckResourceStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetReadinessCheckResourceStatus {
    _private: (),
}
impl GetReadinessCheckResourceStatus {
    /// Creates a new builder-style object to manufacture [`GetReadinessCheckResourceStatusInput`](crate::input::GetReadinessCheckResourceStatusInput)
    pub fn builder() -> crate::input::get_readiness_check_resource_status_input::Builder {
        crate::input::get_readiness_check_resource_status_input::Builder::default()
    }
    /// Creates a new `GetReadinessCheckResourceStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetReadinessCheckResourceStatus {
    type Output = std::result::Result<
        crate::output::GetReadinessCheckResourceStatusOutput,
        crate::error::GetReadinessCheckResourceStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_readiness_check_resource_status_error(response)
        } else {
            crate::operation_deser::parse_get_readiness_check_resource_status_response(response)
        }
    }
}

/// Operation shape for `GetReadinessCheckStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_readiness_check_status`](crate::client::Client::get_readiness_check_status).
///
/// See [`crate::client::fluent_builders::GetReadinessCheckStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetReadinessCheckStatus {
    _private: (),
}
impl GetReadinessCheckStatus {
    /// Creates a new builder-style object to manufacture [`GetReadinessCheckStatusInput`](crate::input::GetReadinessCheckStatusInput)
    pub fn builder() -> crate::input::get_readiness_check_status_input::Builder {
        crate::input::get_readiness_check_status_input::Builder::default()
    }
    /// Creates a new `GetReadinessCheckStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetReadinessCheckStatus {
    type Output = std::result::Result<
        crate::output::GetReadinessCheckStatusOutput,
        crate::error::GetReadinessCheckStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_readiness_check_status_error(response)
        } else {
            crate::operation_deser::parse_get_readiness_check_status_response(response)
        }
    }
}

/// Operation shape for `GetRecoveryGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_recovery_group`](crate::client::Client::get_recovery_group).
///
/// See [`crate::client::fluent_builders::GetRecoveryGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRecoveryGroup {
    _private: (),
}
impl GetRecoveryGroup {
    /// Creates a new builder-style object to manufacture [`GetRecoveryGroupInput`](crate::input::GetRecoveryGroupInput)
    pub fn builder() -> crate::input::get_recovery_group_input::Builder {
        crate::input::get_recovery_group_input::Builder::default()
    }
    /// Creates a new `GetRecoveryGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRecoveryGroup {
    type Output = std::result::Result<
        crate::output::GetRecoveryGroupOutput,
        crate::error::GetRecoveryGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_recovery_group_error(response)
        } else {
            crate::operation_deser::parse_get_recovery_group_response(response)
        }
    }
}

/// Operation shape for `GetRecoveryGroupReadinessSummary`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_recovery_group_readiness_summary`](crate::client::Client::get_recovery_group_readiness_summary).
///
/// See [`crate::client::fluent_builders::GetRecoveryGroupReadinessSummary`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRecoveryGroupReadinessSummary {
    _private: (),
}
impl GetRecoveryGroupReadinessSummary {
    /// Creates a new builder-style object to manufacture [`GetRecoveryGroupReadinessSummaryInput`](crate::input::GetRecoveryGroupReadinessSummaryInput)
    pub fn builder() -> crate::input::get_recovery_group_readiness_summary_input::Builder {
        crate::input::get_recovery_group_readiness_summary_input::Builder::default()
    }
    /// Creates a new `GetRecoveryGroupReadinessSummary` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRecoveryGroupReadinessSummary {
    type Output = std::result::Result<
        crate::output::GetRecoveryGroupReadinessSummaryOutput,
        crate::error::GetRecoveryGroupReadinessSummaryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_recovery_group_readiness_summary_error(response)
        } else {
            crate::operation_deser::parse_get_recovery_group_readiness_summary_response(response)
        }
    }
}

/// Operation shape for `GetResourceSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_resource_set`](crate::client::Client::get_resource_set).
///
/// See [`crate::client::fluent_builders::GetResourceSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetResourceSet {
    _private: (),
}
impl GetResourceSet {
    /// Creates a new builder-style object to manufacture [`GetResourceSetInput`](crate::input::GetResourceSetInput)
    pub fn builder() -> crate::input::get_resource_set_input::Builder {
        crate::input::get_resource_set_input::Builder::default()
    }
    /// Creates a new `GetResourceSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetResourceSet {
    type Output =
        std::result::Result<crate::output::GetResourceSetOutput, crate::error::GetResourceSetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_resource_set_error(response)
        } else {
            crate::operation_deser::parse_get_resource_set_response(response)
        }
    }
}

/// Operation shape for `ListCells`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_cells`](crate::client::Client::list_cells).
///
/// See [`crate::client::fluent_builders::ListCells`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListCells {
    _private: (),
}
impl ListCells {
    /// Creates a new builder-style object to manufacture [`ListCellsInput`](crate::input::ListCellsInput)
    pub fn builder() -> crate::input::list_cells_input::Builder {
        crate::input::list_cells_input::Builder::default()
    }
    /// Creates a new `ListCells` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListCells {
    type Output = std::result::Result<crate::output::ListCellsOutput, crate::error::ListCellsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_cells_error(response)
        } else {
            crate::operation_deser::parse_list_cells_response(response)
        }
    }
}

/// Operation shape for `ListCrossAccountAuthorizations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_cross_account_authorizations`](crate::client::Client::list_cross_account_authorizations).
///
/// See [`crate::client::fluent_builders::ListCrossAccountAuthorizations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListCrossAccountAuthorizations {
    _private: (),
}
impl ListCrossAccountAuthorizations {
    /// Creates a new builder-style object to manufacture [`ListCrossAccountAuthorizationsInput`](crate::input::ListCrossAccountAuthorizationsInput)
    pub fn builder() -> crate::input::list_cross_account_authorizations_input::Builder {
        crate::input::list_cross_account_authorizations_input::Builder::default()
    }
    /// Creates a new `ListCrossAccountAuthorizations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListCrossAccountAuthorizations {
    type Output = std::result::Result<
        crate::output::ListCrossAccountAuthorizationsOutput,
        crate::error::ListCrossAccountAuthorizationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_cross_account_authorizations_error(response)
        } else {
            crate::operation_deser::parse_list_cross_account_authorizations_response(response)
        }
    }
}

/// Operation shape for `ListReadinessChecks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_readiness_checks`](crate::client::Client::list_readiness_checks).
///
/// See [`crate::client::fluent_builders::ListReadinessChecks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListReadinessChecks {
    _private: (),
}
impl ListReadinessChecks {
    /// Creates a new builder-style object to manufacture [`ListReadinessChecksInput`](crate::input::ListReadinessChecksInput)
    pub fn builder() -> crate::input::list_readiness_checks_input::Builder {
        crate::input::list_readiness_checks_input::Builder::default()
    }
    /// Creates a new `ListReadinessChecks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListReadinessChecks {
    type Output = std::result::Result<
        crate::output::ListReadinessChecksOutput,
        crate::error::ListReadinessChecksError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_readiness_checks_error(response)
        } else {
            crate::operation_deser::parse_list_readiness_checks_response(response)
        }
    }
}

/// Operation shape for `ListRecoveryGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_recovery_groups`](crate::client::Client::list_recovery_groups).
///
/// See [`crate::client::fluent_builders::ListRecoveryGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRecoveryGroups {
    _private: (),
}
impl ListRecoveryGroups {
    /// Creates a new builder-style object to manufacture [`ListRecoveryGroupsInput`](crate::input::ListRecoveryGroupsInput)
    pub fn builder() -> crate::input::list_recovery_groups_input::Builder {
        crate::input::list_recovery_groups_input::Builder::default()
    }
    /// Creates a new `ListRecoveryGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRecoveryGroups {
    type Output = std::result::Result<
        crate::output::ListRecoveryGroupsOutput,
        crate::error::ListRecoveryGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_recovery_groups_error(response)
        } else {
            crate::operation_deser::parse_list_recovery_groups_response(response)
        }
    }
}

/// Operation shape for `ListResourceSets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_resource_sets`](crate::client::Client::list_resource_sets).
///
/// See [`crate::client::fluent_builders::ListResourceSets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListResourceSets {
    _private: (),
}
impl ListResourceSets {
    /// Creates a new builder-style object to manufacture [`ListResourceSetsInput`](crate::input::ListResourceSetsInput)
    pub fn builder() -> crate::input::list_resource_sets_input::Builder {
        crate::input::list_resource_sets_input::Builder::default()
    }
    /// Creates a new `ListResourceSets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListResourceSets {
    type Output = std::result::Result<
        crate::output::ListResourceSetsOutput,
        crate::error::ListResourceSetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_resource_sets_error(response)
        } else {
            crate::operation_deser::parse_list_resource_sets_response(response)
        }
    }
}

/// Operation shape for `ListRules`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_rules`](crate::client::Client::list_rules).
///
/// See [`crate::client::fluent_builders::ListRules`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRules {
    _private: (),
}
impl ListRules {
    /// Creates a new builder-style object to manufacture [`ListRulesInput`](crate::input::ListRulesInput)
    pub fn builder() -> crate::input::list_rules_input::Builder {
        crate::input::list_rules_input::Builder::default()
    }
    /// Creates a new `ListRules` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRules {
    type Output = std::result::Result<crate::output::ListRulesOutput, crate::error::ListRulesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_rules_error(response)
        } else {
            crate::operation_deser::parse_list_rules_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResources`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resources`](crate::client::Client::list_tags_for_resources).
///
/// See [`crate::client::fluent_builders::ListTagsForResources`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResources {
    _private: (),
}
impl ListTagsForResources {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourcesInput`](crate::input::ListTagsForResourcesInput)
    pub fn builder() -> crate::input::list_tags_for_resources_input::Builder {
        crate::input::list_tags_for_resources_input::Builder::default()
    }
    /// Creates a new `ListTagsForResources` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResources {
    type Output = std::result::Result<
        crate::output::ListTagsForResourcesOutput,
        crate::error::ListTagsForResourcesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resources_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resources_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateCell`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_cell`](crate::client::Client::update_cell).
///
/// See [`crate::client::fluent_builders::UpdateCell`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateCell {
    _private: (),
}
impl UpdateCell {
    /// Creates a new builder-style object to manufacture [`UpdateCellInput`](crate::input::UpdateCellInput)
    pub fn builder() -> crate::input::update_cell_input::Builder {
        crate::input::update_cell_input::Builder::default()
    }
    /// Creates a new `UpdateCell` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateCell {
    type Output =
        std::result::Result<crate::output::UpdateCellOutput, crate::error::UpdateCellError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_cell_error(response)
        } else {
            crate::operation_deser::parse_update_cell_response(response)
        }
    }
}

/// Operation shape for `UpdateReadinessCheck`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_readiness_check`](crate::client::Client::update_readiness_check).
///
/// See [`crate::client::fluent_builders::UpdateReadinessCheck`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateReadinessCheck {
    _private: (),
}
impl UpdateReadinessCheck {
    /// Creates a new builder-style object to manufacture [`UpdateReadinessCheckInput`](crate::input::UpdateReadinessCheckInput)
    pub fn builder() -> crate::input::update_readiness_check_input::Builder {
        crate::input::update_readiness_check_input::Builder::default()
    }
    /// Creates a new `UpdateReadinessCheck` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateReadinessCheck {
    type Output = std::result::Result<
        crate::output::UpdateReadinessCheckOutput,
        crate::error::UpdateReadinessCheckError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_readiness_check_error(response)
        } else {
            crate::operation_deser::parse_update_readiness_check_response(response)
        }
    }
}

/// Operation shape for `UpdateRecoveryGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_recovery_group`](crate::client::Client::update_recovery_group).
///
/// See [`crate::client::fluent_builders::UpdateRecoveryGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRecoveryGroup {
    _private: (),
}
impl UpdateRecoveryGroup {
    /// Creates a new builder-style object to manufacture [`UpdateRecoveryGroupInput`](crate::input::UpdateRecoveryGroupInput)
    pub fn builder() -> crate::input::update_recovery_group_input::Builder {
        crate::input::update_recovery_group_input::Builder::default()
    }
    /// Creates a new `UpdateRecoveryGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRecoveryGroup {
    type Output = std::result::Result<
        crate::output::UpdateRecoveryGroupOutput,
        crate::error::UpdateRecoveryGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_recovery_group_error(response)
        } else {
            crate::operation_deser::parse_update_recovery_group_response(response)
        }
    }
}

/// Operation shape for `UpdateResourceSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_resource_set`](crate::client::Client::update_resource_set).
///
/// See [`crate::client::fluent_builders::UpdateResourceSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateResourceSet {
    _private: (),
}
impl UpdateResourceSet {
    /// Creates a new builder-style object to manufacture [`UpdateResourceSetInput`](crate::input::UpdateResourceSetInput)
    pub fn builder() -> crate::input::update_resource_set_input::Builder {
        crate::input::update_resource_set_input::Builder::default()
    }
    /// Creates a new `UpdateResourceSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateResourceSet {
    type Output = std::result::Result<
        crate::output::UpdateResourceSetOutput,
        crate::error::UpdateResourceSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_resource_set_error(response)
        } else {
            crate::operation_deser::parse_update_resource_set_response(response)
        }
    }
}
