// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateCell` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateCellError {
    /// Kind of error that occurred.
    pub kind: CreateCellErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateCell` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateCellErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// Updating or deleting a resource can cause an inconsistent state.
    ConflictException(crate::error::ConflictException),
    /// An unexpected error occurred.
    InternalServerException(crate::error::InternalServerException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateCellError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateCellErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateCellErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateCellErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateCellErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateCellErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateCellErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateCellError {
    fn code(&self) -> Option<&str> {
        CreateCellError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateCellError {
    /// Creates a new `CreateCellError`.
    pub fn new(kind: CreateCellErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateCellError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateCellErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateCellError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateCellErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateCellErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateCellErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateCellErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateCellErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateCellErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, CreateCellErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `CreateCellErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateCellErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateCellErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateCellErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateCellError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateCellErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateCellErrorKind::ConflictException(_inner) => Some(_inner),
            CreateCellErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateCellErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateCellErrorKind::ValidationException(_inner) => Some(_inner),
            CreateCellErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateCrossAccountAuthorization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateCrossAccountAuthorizationError {
    /// Kind of error that occurred.
    pub kind: CreateCrossAccountAuthorizationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateCrossAccountAuthorization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateCrossAccountAuthorizationErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// Updating or deleting a resource can cause an inconsistent state.
    ConflictException(crate::error::ConflictException),
    /// An unexpected error occurred.
    InternalServerException(crate::error::InternalServerException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateCrossAccountAuthorizationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateCrossAccountAuthorizationErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            CreateCrossAccountAuthorizationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateCrossAccountAuthorizationErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            CreateCrossAccountAuthorizationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateCrossAccountAuthorizationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateCrossAccountAuthorizationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateCrossAccountAuthorizationError {
    fn code(&self) -> Option<&str> {
        CreateCrossAccountAuthorizationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateCrossAccountAuthorizationError {
    /// Creates a new `CreateCrossAccountAuthorizationError`.
    pub fn new(
        kind: CreateCrossAccountAuthorizationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateCrossAccountAuthorizationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateCrossAccountAuthorizationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateCrossAccountAuthorizationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateCrossAccountAuthorizationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateCrossAccountAuthorizationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCrossAccountAuthorizationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCrossAccountAuthorizationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCrossAccountAuthorizationErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCrossAccountAuthorizationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCrossAccountAuthorizationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCrossAccountAuthorizationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCrossAccountAuthorizationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCrossAccountAuthorizationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCrossAccountAuthorizationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateCrossAccountAuthorizationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateCrossAccountAuthorizationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateCrossAccountAuthorizationErrorKind::ConflictException(_inner) => Some(_inner),
            CreateCrossAccountAuthorizationErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            CreateCrossAccountAuthorizationErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateCrossAccountAuthorizationErrorKind::ValidationException(_inner) => Some(_inner),
            CreateCrossAccountAuthorizationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateReadinessCheck` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateReadinessCheckError {
    /// Kind of error that occurred.
    pub kind: CreateReadinessCheckErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateReadinessCheck` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateReadinessCheckErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// Updating or deleting a resource can cause an inconsistent state.
    ConflictException(crate::error::ConflictException),
    /// An unexpected error occurred.
    InternalServerException(crate::error::InternalServerException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateReadinessCheckError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateReadinessCheckErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateReadinessCheckErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateReadinessCheckErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateReadinessCheckErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateReadinessCheckErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateReadinessCheckErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateReadinessCheckError {
    fn code(&self) -> Option<&str> {
        CreateReadinessCheckError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateReadinessCheckError {
    /// Creates a new `CreateReadinessCheckError`.
    pub fn new(kind: CreateReadinessCheckErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateReadinessCheckError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateReadinessCheckErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateReadinessCheckError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateReadinessCheckErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateReadinessCheckErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReadinessCheckErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReadinessCheckErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReadinessCheckErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReadinessCheckErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReadinessCheckErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReadinessCheckErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReadinessCheckErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReadinessCheckErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReadinessCheckErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateReadinessCheckError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateReadinessCheckErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateReadinessCheckErrorKind::ConflictException(_inner) => Some(_inner),
            CreateReadinessCheckErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateReadinessCheckErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateReadinessCheckErrorKind::ValidationException(_inner) => Some(_inner),
            CreateReadinessCheckErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateRecoveryGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateRecoveryGroupError {
    /// Kind of error that occurred.
    pub kind: CreateRecoveryGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateRecoveryGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateRecoveryGroupErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// Updating or deleting a resource can cause an inconsistent state.
    ConflictException(crate::error::ConflictException),
    /// An unexpected error occurred.
    InternalServerException(crate::error::InternalServerException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateRecoveryGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateRecoveryGroupErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateRecoveryGroupErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateRecoveryGroupErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateRecoveryGroupErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateRecoveryGroupErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateRecoveryGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateRecoveryGroupError {
    fn code(&self) -> Option<&str> {
        CreateRecoveryGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateRecoveryGroupError {
    /// Creates a new `CreateRecoveryGroupError`.
    pub fn new(kind: CreateRecoveryGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateRecoveryGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateRecoveryGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateRecoveryGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateRecoveryGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateRecoveryGroupErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRecoveryGroupErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRecoveryGroupErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRecoveryGroupErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRecoveryGroupErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRecoveryGroupErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRecoveryGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRecoveryGroupErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRecoveryGroupErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRecoveryGroupErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateRecoveryGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateRecoveryGroupErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateRecoveryGroupErrorKind::ConflictException(_inner) => Some(_inner),
            CreateRecoveryGroupErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateRecoveryGroupErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateRecoveryGroupErrorKind::ValidationException(_inner) => Some(_inner),
            CreateRecoveryGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateResourceSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateResourceSetError {
    /// Kind of error that occurred.
    pub kind: CreateResourceSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateResourceSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateResourceSetErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// Updating or deleting a resource can cause an inconsistent state.
    ConflictException(crate::error::ConflictException),
    /// An unexpected error occurred.
    InternalServerException(crate::error::InternalServerException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateResourceSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateResourceSetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateResourceSetErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateResourceSetErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateResourceSetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateResourceSetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateResourceSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateResourceSetError {
    fn code(&self) -> Option<&str> {
        CreateResourceSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateResourceSetError {
    /// Creates a new `CreateResourceSetError`.
    pub fn new(kind: CreateResourceSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateResourceSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateResourceSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateResourceSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateResourceSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateResourceSetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceSetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceSetErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateResourceSetErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateResourceSetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceSetErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceSetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceSetErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourceSetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourceSetErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateResourceSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateResourceSetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateResourceSetErrorKind::ConflictException(_inner) => Some(_inner),
            CreateResourceSetErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateResourceSetErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateResourceSetErrorKind::ValidationException(_inner) => Some(_inner),
            CreateResourceSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteCell` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteCellError {
    /// Kind of error that occurred.
    pub kind: DeleteCellErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteCell` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteCellErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// An unexpected error occurred.
    InternalServerException(crate::error::InternalServerException),
    /// The requested resource does not exist.
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteCellError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteCellErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteCellErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteCellErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteCellErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteCellErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteCellErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteCellError {
    fn code(&self) -> Option<&str> {
        DeleteCellError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteCellError {
    /// Creates a new `DeleteCellError`.
    pub fn new(kind: DeleteCellErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteCellError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteCellErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteCellError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteCellErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteCellErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteCellErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteCellErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, DeleteCellErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `DeleteCellErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCellErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCellErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteCellErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteCellErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteCellErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteCellError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteCellErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteCellErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteCellErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteCellErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteCellErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteCellErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteCrossAccountAuthorization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteCrossAccountAuthorizationError {
    /// Kind of error that occurred.
    pub kind: DeleteCrossAccountAuthorizationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteCrossAccountAuthorization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteCrossAccountAuthorizationErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// An unexpected error occurred.
    InternalServerException(crate::error::InternalServerException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteCrossAccountAuthorizationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteCrossAccountAuthorizationErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DeleteCrossAccountAuthorizationErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DeleteCrossAccountAuthorizationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteCrossAccountAuthorizationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteCrossAccountAuthorizationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteCrossAccountAuthorizationError {
    fn code(&self) -> Option<&str> {
        DeleteCrossAccountAuthorizationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteCrossAccountAuthorizationError {
    /// Creates a new `DeleteCrossAccountAuthorizationError`.
    pub fn new(
        kind: DeleteCrossAccountAuthorizationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteCrossAccountAuthorizationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteCrossAccountAuthorizationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteCrossAccountAuthorizationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteCrossAccountAuthorizationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteCrossAccountAuthorizationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCrossAccountAuthorizationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCrossAccountAuthorizationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCrossAccountAuthorizationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCrossAccountAuthorizationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCrossAccountAuthorizationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCrossAccountAuthorizationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCrossAccountAuthorizationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteCrossAccountAuthorizationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteCrossAccountAuthorizationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteCrossAccountAuthorizationErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DeleteCrossAccountAuthorizationErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteCrossAccountAuthorizationErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteCrossAccountAuthorizationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteReadinessCheck` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteReadinessCheckError {
    /// Kind of error that occurred.
    pub kind: DeleteReadinessCheckErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteReadinessCheck` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteReadinessCheckErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// An unexpected error occurred.
    InternalServerException(crate::error::InternalServerException),
    /// The requested resource does not exist.
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteReadinessCheckError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteReadinessCheckErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteReadinessCheckErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteReadinessCheckErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteReadinessCheckErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteReadinessCheckErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteReadinessCheckErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteReadinessCheckError {
    fn code(&self) -> Option<&str> {
        DeleteReadinessCheckError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteReadinessCheckError {
    /// Creates a new `DeleteReadinessCheckError`.
    pub fn new(kind: DeleteReadinessCheckErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteReadinessCheckError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteReadinessCheckErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteReadinessCheckError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteReadinessCheckErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteReadinessCheckErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReadinessCheckErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteReadinessCheckErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReadinessCheckErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteReadinessCheckErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReadinessCheckErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteReadinessCheckErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReadinessCheckErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteReadinessCheckErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReadinessCheckErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteReadinessCheckError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteReadinessCheckErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteReadinessCheckErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteReadinessCheckErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteReadinessCheckErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteReadinessCheckErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteReadinessCheckErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRecoveryGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRecoveryGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteRecoveryGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRecoveryGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRecoveryGroupErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// An unexpected error occurred.
    InternalServerException(crate::error::InternalServerException),
    /// The requested resource does not exist.
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRecoveryGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRecoveryGroupErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteRecoveryGroupErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteRecoveryGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteRecoveryGroupErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteRecoveryGroupErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteRecoveryGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRecoveryGroupError {
    fn code(&self) -> Option<&str> {
        DeleteRecoveryGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRecoveryGroupError {
    /// Creates a new `DeleteRecoveryGroupError`.
    pub fn new(kind: DeleteRecoveryGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRecoveryGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRecoveryGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRecoveryGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRecoveryGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRecoveryGroupErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRecoveryGroupErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRecoveryGroupErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRecoveryGroupErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRecoveryGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRecoveryGroupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRecoveryGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRecoveryGroupErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRecoveryGroupErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRecoveryGroupErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteRecoveryGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRecoveryGroupErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteRecoveryGroupErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteRecoveryGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteRecoveryGroupErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteRecoveryGroupErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteRecoveryGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteResourceSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteResourceSetError {
    /// Kind of error that occurred.
    pub kind: DeleteResourceSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteResourceSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteResourceSetErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// An unexpected error occurred.
    InternalServerException(crate::error::InternalServerException),
    /// The requested resource does not exist.
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteResourceSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteResourceSetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteResourceSetErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteResourceSetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteResourceSetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteResourceSetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteResourceSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteResourceSetError {
    fn code(&self) -> Option<&str> {
        DeleteResourceSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteResourceSetError {
    /// Creates a new `DeleteResourceSetError`.
    pub fn new(kind: DeleteResourceSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteResourceSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteResourceSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteResourceSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteResourceSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteResourceSetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceSetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourceSetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceSetErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourceSetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceSetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourceSetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceSetErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourceSetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourceSetErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteResourceSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteResourceSetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteResourceSetErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteResourceSetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteResourceSetErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteResourceSetErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteResourceSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetArchitectureRecommendations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetArchitectureRecommendationsError {
    /// Kind of error that occurred.
    pub kind: GetArchitectureRecommendationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetArchitectureRecommendations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetArchitectureRecommendationsErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// An unexpected error occurred.
    InternalServerException(crate::error::InternalServerException),
    /// The requested resource does not exist.
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetArchitectureRecommendationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetArchitectureRecommendationsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetArchitectureRecommendationsErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            GetArchitectureRecommendationsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetArchitectureRecommendationsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetArchitectureRecommendationsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetArchitectureRecommendationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetArchitectureRecommendationsError {
    fn code(&self) -> Option<&str> {
        GetArchitectureRecommendationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetArchitectureRecommendationsError {
    /// Creates a new `GetArchitectureRecommendationsError`.
    pub fn new(
        kind: GetArchitectureRecommendationsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetArchitectureRecommendationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetArchitectureRecommendationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetArchitectureRecommendationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetArchitectureRecommendationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetArchitectureRecommendationsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetArchitectureRecommendationsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetArchitectureRecommendationsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetArchitectureRecommendationsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetArchitectureRecommendationsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetArchitectureRecommendationsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetArchitectureRecommendationsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetArchitectureRecommendationsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetArchitectureRecommendationsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetArchitectureRecommendationsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetArchitectureRecommendationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetArchitectureRecommendationsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetArchitectureRecommendationsErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            GetArchitectureRecommendationsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetArchitectureRecommendationsErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetArchitectureRecommendationsErrorKind::ValidationException(_inner) => Some(_inner),
            GetArchitectureRecommendationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCell` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCellError {
    /// Kind of error that occurred.
    pub kind: GetCellErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCell` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCellErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// An unexpected error occurred.
    InternalServerException(crate::error::InternalServerException),
    /// The requested resource does not exist.
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCellError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCellErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetCellErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetCellErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetCellErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetCellErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetCellErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCellError {
    fn code(&self) -> Option<&str> {
        GetCellError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCellError {
    /// Creates a new `GetCellError`.
    pub fn new(kind: GetCellErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCellError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCellErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCellError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCellErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCellErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetCellErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetCellErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetCellErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `GetCellErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetCellErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetCellErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetCellErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetCellErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetCellErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetCellError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCellErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetCellErrorKind::InternalServerException(_inner) => Some(_inner),
            GetCellErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetCellErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetCellErrorKind::ValidationException(_inner) => Some(_inner),
            GetCellErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCellReadinessSummary` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCellReadinessSummaryError {
    /// Kind of error that occurred.
    pub kind: GetCellReadinessSummaryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCellReadinessSummary` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCellReadinessSummaryErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// An unexpected error occurred.
    InternalServerException(crate::error::InternalServerException),
    /// The requested resource does not exist.
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCellReadinessSummaryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCellReadinessSummaryErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetCellReadinessSummaryErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetCellReadinessSummaryErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetCellReadinessSummaryErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetCellReadinessSummaryErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetCellReadinessSummaryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCellReadinessSummaryError {
    fn code(&self) -> Option<&str> {
        GetCellReadinessSummaryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCellReadinessSummaryError {
    /// Creates a new `GetCellReadinessSummaryError`.
    pub fn new(kind: GetCellReadinessSummaryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCellReadinessSummaryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCellReadinessSummaryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCellReadinessSummaryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCellReadinessSummaryErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCellReadinessSummaryErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCellReadinessSummaryErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCellReadinessSummaryErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCellReadinessSummaryErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCellReadinessSummaryErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCellReadinessSummaryErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCellReadinessSummaryErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCellReadinessSummaryErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCellReadinessSummaryErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCellReadinessSummaryErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetCellReadinessSummaryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCellReadinessSummaryErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetCellReadinessSummaryErrorKind::InternalServerException(_inner) => Some(_inner),
            GetCellReadinessSummaryErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetCellReadinessSummaryErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetCellReadinessSummaryErrorKind::ValidationException(_inner) => Some(_inner),
            GetCellReadinessSummaryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetReadinessCheck` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetReadinessCheckError {
    /// Kind of error that occurred.
    pub kind: GetReadinessCheckErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetReadinessCheck` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetReadinessCheckErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// An unexpected error occurred.
    InternalServerException(crate::error::InternalServerException),
    /// The requested resource does not exist.
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetReadinessCheckError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetReadinessCheckErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetReadinessCheckErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetReadinessCheckErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetReadinessCheckErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetReadinessCheckErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetReadinessCheckErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetReadinessCheckError {
    fn code(&self) -> Option<&str> {
        GetReadinessCheckError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetReadinessCheckError {
    /// Creates a new `GetReadinessCheckError`.
    pub fn new(kind: GetReadinessCheckErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetReadinessCheckError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetReadinessCheckErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetReadinessCheckError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetReadinessCheckErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetReadinessCheckErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReadinessCheckErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetReadinessCheckErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReadinessCheckErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetReadinessCheckErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReadinessCheckErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetReadinessCheckErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReadinessCheckErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetReadinessCheckErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReadinessCheckErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetReadinessCheckError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetReadinessCheckErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetReadinessCheckErrorKind::InternalServerException(_inner) => Some(_inner),
            GetReadinessCheckErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetReadinessCheckErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetReadinessCheckErrorKind::ValidationException(_inner) => Some(_inner),
            GetReadinessCheckErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetReadinessCheckResourceStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetReadinessCheckResourceStatusError {
    /// Kind of error that occurred.
    pub kind: GetReadinessCheckResourceStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetReadinessCheckResourceStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetReadinessCheckResourceStatusErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// An unexpected error occurred.
    InternalServerException(crate::error::InternalServerException),
    /// The requested resource does not exist.
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetReadinessCheckResourceStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetReadinessCheckResourceStatusErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            GetReadinessCheckResourceStatusErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            GetReadinessCheckResourceStatusErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetReadinessCheckResourceStatusErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetReadinessCheckResourceStatusErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetReadinessCheckResourceStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetReadinessCheckResourceStatusError {
    fn code(&self) -> Option<&str> {
        GetReadinessCheckResourceStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetReadinessCheckResourceStatusError {
    /// Creates a new `GetReadinessCheckResourceStatusError`.
    pub fn new(
        kind: GetReadinessCheckResourceStatusErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetReadinessCheckResourceStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetReadinessCheckResourceStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetReadinessCheckResourceStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetReadinessCheckResourceStatusErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetReadinessCheckResourceStatusErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReadinessCheckResourceStatusErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetReadinessCheckResourceStatusErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReadinessCheckResourceStatusErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetReadinessCheckResourceStatusErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReadinessCheckResourceStatusErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetReadinessCheckResourceStatusErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReadinessCheckResourceStatusErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetReadinessCheckResourceStatusErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReadinessCheckResourceStatusErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetReadinessCheckResourceStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetReadinessCheckResourceStatusErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetReadinessCheckResourceStatusErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            GetReadinessCheckResourceStatusErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetReadinessCheckResourceStatusErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetReadinessCheckResourceStatusErrorKind::ValidationException(_inner) => Some(_inner),
            GetReadinessCheckResourceStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetReadinessCheckStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetReadinessCheckStatusError {
    /// Kind of error that occurred.
    pub kind: GetReadinessCheckStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetReadinessCheckStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetReadinessCheckStatusErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// An unexpected error occurred.
    InternalServerException(crate::error::InternalServerException),
    /// The requested resource does not exist.
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetReadinessCheckStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetReadinessCheckStatusErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetReadinessCheckStatusErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetReadinessCheckStatusErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetReadinessCheckStatusErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetReadinessCheckStatusErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetReadinessCheckStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetReadinessCheckStatusError {
    fn code(&self) -> Option<&str> {
        GetReadinessCheckStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetReadinessCheckStatusError {
    /// Creates a new `GetReadinessCheckStatusError`.
    pub fn new(kind: GetReadinessCheckStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetReadinessCheckStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetReadinessCheckStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetReadinessCheckStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetReadinessCheckStatusErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetReadinessCheckStatusErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReadinessCheckStatusErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetReadinessCheckStatusErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReadinessCheckStatusErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetReadinessCheckStatusErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReadinessCheckStatusErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetReadinessCheckStatusErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReadinessCheckStatusErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetReadinessCheckStatusErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReadinessCheckStatusErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetReadinessCheckStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetReadinessCheckStatusErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetReadinessCheckStatusErrorKind::InternalServerException(_inner) => Some(_inner),
            GetReadinessCheckStatusErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetReadinessCheckStatusErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetReadinessCheckStatusErrorKind::ValidationException(_inner) => Some(_inner),
            GetReadinessCheckStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRecoveryGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRecoveryGroupError {
    /// Kind of error that occurred.
    pub kind: GetRecoveryGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRecoveryGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRecoveryGroupErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// An unexpected error occurred.
    InternalServerException(crate::error::InternalServerException),
    /// The requested resource does not exist.
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRecoveryGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRecoveryGroupErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetRecoveryGroupErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetRecoveryGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetRecoveryGroupErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetRecoveryGroupErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetRecoveryGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRecoveryGroupError {
    fn code(&self) -> Option<&str> {
        GetRecoveryGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRecoveryGroupError {
    /// Creates a new `GetRecoveryGroupError`.
    pub fn new(kind: GetRecoveryGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRecoveryGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRecoveryGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRecoveryGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRecoveryGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRecoveryGroupErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecoveryGroupErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRecoveryGroupErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecoveryGroupErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRecoveryGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecoveryGroupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRecoveryGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecoveryGroupErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRecoveryGroupErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecoveryGroupErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetRecoveryGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRecoveryGroupErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetRecoveryGroupErrorKind::InternalServerException(_inner) => Some(_inner),
            GetRecoveryGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetRecoveryGroupErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetRecoveryGroupErrorKind::ValidationException(_inner) => Some(_inner),
            GetRecoveryGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRecoveryGroupReadinessSummary` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRecoveryGroupReadinessSummaryError {
    /// Kind of error that occurred.
    pub kind: GetRecoveryGroupReadinessSummaryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRecoveryGroupReadinessSummary` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRecoveryGroupReadinessSummaryErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// An unexpected error occurred.
    InternalServerException(crate::error::InternalServerException),
    /// The requested resource does not exist.
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRecoveryGroupReadinessSummaryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRecoveryGroupReadinessSummaryErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            GetRecoveryGroupReadinessSummaryErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            GetRecoveryGroupReadinessSummaryErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetRecoveryGroupReadinessSummaryErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetRecoveryGroupReadinessSummaryErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetRecoveryGroupReadinessSummaryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRecoveryGroupReadinessSummaryError {
    fn code(&self) -> Option<&str> {
        GetRecoveryGroupReadinessSummaryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRecoveryGroupReadinessSummaryError {
    /// Creates a new `GetRecoveryGroupReadinessSummaryError`.
    pub fn new(
        kind: GetRecoveryGroupReadinessSummaryErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRecoveryGroupReadinessSummaryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRecoveryGroupReadinessSummaryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRecoveryGroupReadinessSummaryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRecoveryGroupReadinessSummaryErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRecoveryGroupReadinessSummaryErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecoveryGroupReadinessSummaryErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRecoveryGroupReadinessSummaryErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecoveryGroupReadinessSummaryErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRecoveryGroupReadinessSummaryErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecoveryGroupReadinessSummaryErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRecoveryGroupReadinessSummaryErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecoveryGroupReadinessSummaryErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRecoveryGroupReadinessSummaryErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRecoveryGroupReadinessSummaryErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetRecoveryGroupReadinessSummaryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRecoveryGroupReadinessSummaryErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            GetRecoveryGroupReadinessSummaryErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            GetRecoveryGroupReadinessSummaryErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetRecoveryGroupReadinessSummaryErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetRecoveryGroupReadinessSummaryErrorKind::ValidationException(_inner) => Some(_inner),
            GetRecoveryGroupReadinessSummaryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetResourceSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetResourceSetError {
    /// Kind of error that occurred.
    pub kind: GetResourceSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetResourceSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetResourceSetErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// An unexpected error occurred.
    InternalServerException(crate::error::InternalServerException),
    /// The requested resource does not exist.
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetResourceSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetResourceSetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetResourceSetErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetResourceSetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetResourceSetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetResourceSetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetResourceSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetResourceSetError {
    fn code(&self) -> Option<&str> {
        GetResourceSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetResourceSetError {
    /// Creates a new `GetResourceSetError`.
    pub fn new(kind: GetResourceSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetResourceSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetResourceSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetResourceSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetResourceSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetResourceSetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceSetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceSetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceSetErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceSetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourceSetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourceSetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetResourceSetErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetResourceSetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetResourceSetErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetResourceSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetResourceSetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetResourceSetErrorKind::InternalServerException(_inner) => Some(_inner),
            GetResourceSetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetResourceSetErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetResourceSetErrorKind::ValidationException(_inner) => Some(_inner),
            GetResourceSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListCells` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListCellsError {
    /// Kind of error that occurred.
    pub kind: ListCellsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListCells` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListCellsErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// An unexpected error occurred.
    InternalServerException(crate::error::InternalServerException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListCellsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListCellsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListCellsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListCellsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListCellsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListCellsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListCellsError {
    fn code(&self) -> Option<&str> {
        ListCellsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListCellsError {
    /// Creates a new `ListCellsError`.
    pub fn new(kind: ListCellsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListCellsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListCellsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListCellsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListCellsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListCellsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListCellsErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListCellsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, ListCellsErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `ListCellsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListCellsErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListCellsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListCellsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListCellsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListCellsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListCellsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListCellsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListCellsErrorKind::ValidationException(_inner) => Some(_inner),
            ListCellsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListCrossAccountAuthorizations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListCrossAccountAuthorizationsError {
    /// Kind of error that occurred.
    pub kind: ListCrossAccountAuthorizationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListCrossAccountAuthorizations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListCrossAccountAuthorizationsErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// An unexpected error occurred.
    InternalServerException(crate::error::InternalServerException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListCrossAccountAuthorizationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListCrossAccountAuthorizationsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListCrossAccountAuthorizationsErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            ListCrossAccountAuthorizationsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListCrossAccountAuthorizationsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListCrossAccountAuthorizationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListCrossAccountAuthorizationsError {
    fn code(&self) -> Option<&str> {
        ListCrossAccountAuthorizationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListCrossAccountAuthorizationsError {
    /// Creates a new `ListCrossAccountAuthorizationsError`.
    pub fn new(
        kind: ListCrossAccountAuthorizationsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListCrossAccountAuthorizationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListCrossAccountAuthorizationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListCrossAccountAuthorizationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListCrossAccountAuthorizationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListCrossAccountAuthorizationsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCrossAccountAuthorizationsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCrossAccountAuthorizationsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCrossAccountAuthorizationsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCrossAccountAuthorizationsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCrossAccountAuthorizationsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCrossAccountAuthorizationsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCrossAccountAuthorizationsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListCrossAccountAuthorizationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListCrossAccountAuthorizationsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListCrossAccountAuthorizationsErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            ListCrossAccountAuthorizationsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListCrossAccountAuthorizationsErrorKind::ValidationException(_inner) => Some(_inner),
            ListCrossAccountAuthorizationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListReadinessChecks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListReadinessChecksError {
    /// Kind of error that occurred.
    pub kind: ListReadinessChecksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListReadinessChecks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListReadinessChecksErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// An unexpected error occurred.
    InternalServerException(crate::error::InternalServerException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListReadinessChecksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListReadinessChecksErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListReadinessChecksErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListReadinessChecksErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListReadinessChecksErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListReadinessChecksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListReadinessChecksError {
    fn code(&self) -> Option<&str> {
        ListReadinessChecksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListReadinessChecksError {
    /// Creates a new `ListReadinessChecksError`.
    pub fn new(kind: ListReadinessChecksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListReadinessChecksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListReadinessChecksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListReadinessChecksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListReadinessChecksErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListReadinessChecksErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListReadinessChecksErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListReadinessChecksErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListReadinessChecksErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListReadinessChecksErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListReadinessChecksErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListReadinessChecksErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListReadinessChecksErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListReadinessChecksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListReadinessChecksErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListReadinessChecksErrorKind::InternalServerException(_inner) => Some(_inner),
            ListReadinessChecksErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListReadinessChecksErrorKind::ValidationException(_inner) => Some(_inner),
            ListReadinessChecksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRecoveryGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRecoveryGroupsError {
    /// Kind of error that occurred.
    pub kind: ListRecoveryGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRecoveryGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRecoveryGroupsErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// An unexpected error occurred.
    InternalServerException(crate::error::InternalServerException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRecoveryGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRecoveryGroupsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListRecoveryGroupsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListRecoveryGroupsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListRecoveryGroupsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListRecoveryGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRecoveryGroupsError {
    fn code(&self) -> Option<&str> {
        ListRecoveryGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRecoveryGroupsError {
    /// Creates a new `ListRecoveryGroupsError`.
    pub fn new(kind: ListRecoveryGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRecoveryGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRecoveryGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRecoveryGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRecoveryGroupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRecoveryGroupsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRecoveryGroupsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRecoveryGroupsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRecoveryGroupsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRecoveryGroupsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRecoveryGroupsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRecoveryGroupsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRecoveryGroupsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListRecoveryGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRecoveryGroupsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListRecoveryGroupsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListRecoveryGroupsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListRecoveryGroupsErrorKind::ValidationException(_inner) => Some(_inner),
            ListRecoveryGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListResourceSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListResourceSetsError {
    /// Kind of error that occurred.
    pub kind: ListResourceSetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListResourceSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListResourceSetsErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// An unexpected error occurred.
    InternalServerException(crate::error::InternalServerException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListResourceSetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListResourceSetsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListResourceSetsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListResourceSetsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListResourceSetsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListResourceSetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListResourceSetsError {
    fn code(&self) -> Option<&str> {
        ListResourceSetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListResourceSetsError {
    /// Creates a new `ListResourceSetsError`.
    pub fn new(kind: ListResourceSetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListResourceSetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListResourceSetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListResourceSetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListResourceSetsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListResourceSetsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourceSetsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourceSetsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourceSetsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourceSetsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourceSetsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourceSetsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourceSetsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListResourceSetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListResourceSetsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListResourceSetsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListResourceSetsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListResourceSetsErrorKind::ValidationException(_inner) => Some(_inner),
            ListResourceSetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRulesError {
    /// Kind of error that occurred.
    pub kind: ListRulesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRulesErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// An unexpected error occurred.
    InternalServerException(crate::error::InternalServerException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRulesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRulesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListRulesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListRulesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListRulesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListRulesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRulesError {
    fn code(&self) -> Option<&str> {
        ListRulesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRulesError {
    /// Creates a new `ListRulesError`.
    pub fn new(kind: ListRulesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRulesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRulesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRulesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRulesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRulesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListRulesErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListRulesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, ListRulesErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `ListRulesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListRulesErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListRulesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListRulesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListRulesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRulesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListRulesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListRulesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListRulesErrorKind::ValidationException(_inner) => Some(_inner),
            ListRulesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourcesError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourcesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourcesErrorKind {
    /// An unexpected error occurred.
    InternalServerException(crate::error::InternalServerException),
    /// The requested resource does not exist.
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourcesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourcesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListTagsForResourcesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourcesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTagsForResourcesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourcesError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourcesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourcesError {
    /// Creates a new `ListTagsForResourcesError`.
    pub fn new(kind: ListTagsForResourcesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourcesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourcesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourcesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourcesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourcesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourcesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourcesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourcesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourcesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourcesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourcesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourcesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListTagsForResourcesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourcesErrorKind::ValidationException(_inner) => Some(_inner),
            ListTagsForResourcesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// An unexpected error occurred.
    InternalServerException(crate::error::InternalServerException),
    /// The requested resource does not exist.
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// An unexpected error occurred.
    InternalServerException(crate::error::InternalServerException),
    /// The requested resource does not exist.
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateCell` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateCellError {
    /// Kind of error that occurred.
    pub kind: UpdateCellErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateCell` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateCellErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// An unexpected error occurred.
    InternalServerException(crate::error::InternalServerException),
    /// The requested resource does not exist.
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateCellError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateCellErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateCellErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateCellErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateCellErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateCellErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateCellErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateCellError {
    fn code(&self) -> Option<&str> {
        UpdateCellError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateCellError {
    /// Creates a new `UpdateCellError`.
    pub fn new(kind: UpdateCellErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateCellError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateCellErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateCellError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateCellErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateCellErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdateCellErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UpdateCellErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, UpdateCellErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `UpdateCellErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCellErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCellErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateCellErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UpdateCellErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateCellErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateCellError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateCellErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateCellErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateCellErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateCellErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateCellErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateCellErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateReadinessCheck` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateReadinessCheckError {
    /// Kind of error that occurred.
    pub kind: UpdateReadinessCheckErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateReadinessCheck` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateReadinessCheckErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// An unexpected error occurred.
    InternalServerException(crate::error::InternalServerException),
    /// The requested resource does not exist.
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateReadinessCheckError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateReadinessCheckErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateReadinessCheckErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateReadinessCheckErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateReadinessCheckErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateReadinessCheckErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateReadinessCheckErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateReadinessCheckError {
    fn code(&self) -> Option<&str> {
        UpdateReadinessCheckError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateReadinessCheckError {
    /// Creates a new `UpdateReadinessCheckError`.
    pub fn new(kind: UpdateReadinessCheckErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateReadinessCheckError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateReadinessCheckErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateReadinessCheckError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateReadinessCheckErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateReadinessCheckErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReadinessCheckErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateReadinessCheckErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReadinessCheckErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateReadinessCheckErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReadinessCheckErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateReadinessCheckErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReadinessCheckErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateReadinessCheckErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReadinessCheckErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateReadinessCheckError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateReadinessCheckErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateReadinessCheckErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateReadinessCheckErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateReadinessCheckErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateReadinessCheckErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateReadinessCheckErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateRecoveryGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateRecoveryGroupError {
    /// Kind of error that occurred.
    pub kind: UpdateRecoveryGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateRecoveryGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateRecoveryGroupErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// An unexpected error occurred.
    InternalServerException(crate::error::InternalServerException),
    /// The requested resource does not exist.
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateRecoveryGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateRecoveryGroupErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateRecoveryGroupErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateRecoveryGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateRecoveryGroupErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateRecoveryGroupErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateRecoveryGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateRecoveryGroupError {
    fn code(&self) -> Option<&str> {
        UpdateRecoveryGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateRecoveryGroupError {
    /// Creates a new `UpdateRecoveryGroupError`.
    pub fn new(kind: UpdateRecoveryGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateRecoveryGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateRecoveryGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateRecoveryGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateRecoveryGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateRecoveryGroupErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRecoveryGroupErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRecoveryGroupErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRecoveryGroupErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRecoveryGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRecoveryGroupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRecoveryGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRecoveryGroupErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRecoveryGroupErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRecoveryGroupErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateRecoveryGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateRecoveryGroupErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateRecoveryGroupErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateRecoveryGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateRecoveryGroupErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateRecoveryGroupErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateRecoveryGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateResourceSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateResourceSetError {
    /// Kind of error that occurred.
    pub kind: UpdateResourceSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateResourceSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateResourceSetErrorKind {
    /// User does not have sufficient access to perform this action.
    AccessDeniedException(crate::error::AccessDeniedException),
    /// An unexpected error occurred.
    InternalServerException(crate::error::InternalServerException),
    /// The requested resource does not exist.
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// Request was denied due to request throttling.
    ThrottlingException(crate::error::ThrottlingException),
    /// The input fails to satisfy the constraints specified by an AWS service.
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateResourceSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateResourceSetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateResourceSetErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateResourceSetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateResourceSetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateResourceSetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateResourceSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateResourceSetError {
    fn code(&self) -> Option<&str> {
        UpdateResourceSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateResourceSetError {
    /// Creates a new `UpdateResourceSetError`.
    pub fn new(kind: UpdateResourceSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateResourceSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateResourceSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateResourceSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateResourceSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateResourceSetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceSetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceSetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceSetErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceSetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceSetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceSetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceSetErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourceSetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourceSetErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateResourceSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateResourceSetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateResourceSetErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateResourceSetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateResourceSetErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateResourceSetErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateResourceSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// The input fails to satisfy the constraints specified by an AWS service.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// Request was denied due to request throttling.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// The requested resource does not exist.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// An unexpected error occurred.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// User does not have sufficient access to perform this action.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// Updating or deleting a resource can cause an inconsistent state.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}
