// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateCellInput`](crate::input::CreateCellInput)
pub mod create_cell_input {
    /// A builder for [`CreateCellInput`](crate::input::CreateCellInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cell_name: std::option::Option<std::string::String>,
        pub(crate) cells: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// The name of the Cell to create
        pub fn cell_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cell_name = Some(input.into());
            self
        }
        /// The name of the Cell to create
        pub fn set_cell_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cell_name = input;
            self
        }
        /// Appends an item to `cells`.
        ///
        /// To override the contents of this collection use [`set_cells`](Self::set_cells).
        ///
        /// A list of Cell arns contained within this Cell (for use in nested Cells, e.g. regions within which AZs)
        pub fn cells(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cells.unwrap_or_default();
            v.push(input.into());
            self.cells = Some(v);
            self
        }
        /// A list of Cell arns contained within this Cell (for use in nested Cells, e.g. regions within which AZs)
        pub fn set_cells(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cells = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCellInput`](crate::input::CreateCellInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCellInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCellInput {
                cell_name: self.cell_name,
                cells: self.cells,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCellInputOperationOutputAlias = crate::operation::CreateCell;
#[doc(hidden)]
pub type CreateCellInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateCellInput {
    /// Consumes the builder and constructs an Operation<[`CreateCell`](crate::operation::CreateCell)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCell,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateCellInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/cells").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateCellInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateCellInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_cell(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCell::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCell",
            "route53recoveryreadiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateCellInput`](crate::input::CreateCellInput)
    pub fn builder() -> crate::input::create_cell_input::Builder {
        crate::input::create_cell_input::Builder::default()
    }
}

/// See [`CreateCrossAccountAuthorizationInput`](crate::input::CreateCrossAccountAuthorizationInput)
pub mod create_cross_account_authorization_input {
    /// A builder for [`CreateCrossAccountAuthorizationInput`](crate::input::CreateCrossAccountAuthorizationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cross_account_authorization: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The cross account authorization
        pub fn cross_account_authorization(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cross_account_authorization = Some(input.into());
            self
        }
        /// The cross account authorization
        pub fn set_cross_account_authorization(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cross_account_authorization = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCrossAccountAuthorizationInput`](crate::input::CreateCrossAccountAuthorizationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCrossAccountAuthorizationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCrossAccountAuthorizationInput {
                cross_account_authorization: self.cross_account_authorization,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCrossAccountAuthorizationInputOperationOutputAlias =
    crate::operation::CreateCrossAccountAuthorization;
#[doc(hidden)]
pub type CreateCrossAccountAuthorizationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateCrossAccountAuthorizationInput {
    /// Consumes the builder and constructs an Operation<[`CreateCrossAccountAuthorization`](crate::operation::CreateCrossAccountAuthorization)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCrossAccountAuthorization,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateCrossAccountAuthorizationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/crossaccountauthorizations").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateCrossAccountAuthorizationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateCrossAccountAuthorizationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_cross_account_authorization(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCrossAccountAuthorization::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCrossAccountAuthorization",
            "route53recoveryreadiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateCrossAccountAuthorizationInput`](crate::input::CreateCrossAccountAuthorizationInput)
    pub fn builder() -> crate::input::create_cross_account_authorization_input::Builder {
        crate::input::create_cross_account_authorization_input::Builder::default()
    }
}

/// See [`CreateReadinessCheckInput`](crate::input::CreateReadinessCheckInput)
pub mod create_readiness_check_input {
    /// A builder for [`CreateReadinessCheckInput`](crate::input::CreateReadinessCheckInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) readiness_check_name: std::option::Option<std::string::String>,
        pub(crate) resource_set_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// The name of the ReadinessCheck to create
        pub fn readiness_check_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.readiness_check_name = Some(input.into());
            self
        }
        /// The name of the ReadinessCheck to create
        pub fn set_readiness_check_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.readiness_check_name = input;
            self
        }
        /// The name of the ResourceSet to check
        pub fn resource_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_set_name = Some(input.into());
            self
        }
        /// The name of the ResourceSet to check
        pub fn set_resource_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_set_name = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateReadinessCheckInput`](crate::input::CreateReadinessCheckInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateReadinessCheckInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateReadinessCheckInput {
                readiness_check_name: self.readiness_check_name,
                resource_set_name: self.resource_set_name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateReadinessCheckInputOperationOutputAlias = crate::operation::CreateReadinessCheck;
#[doc(hidden)]
pub type CreateReadinessCheckInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateReadinessCheckInput {
    /// Consumes the builder and constructs an Operation<[`CreateReadinessCheck`](crate::operation::CreateReadinessCheck)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateReadinessCheck,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateReadinessCheckInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/readinesschecks").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateReadinessCheckInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateReadinessCheckInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_readiness_check(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateReadinessCheck::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateReadinessCheck",
            "route53recoveryreadiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateReadinessCheckInput`](crate::input::CreateReadinessCheckInput)
    pub fn builder() -> crate::input::create_readiness_check_input::Builder {
        crate::input::create_readiness_check_input::Builder::default()
    }
}

/// See [`CreateRecoveryGroupInput`](crate::input::CreateRecoveryGroupInput)
pub mod create_recovery_group_input {
    /// A builder for [`CreateRecoveryGroupInput`](crate::input::CreateRecoveryGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cells: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) recovery_group_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Appends an item to `cells`.
        ///
        /// To override the contents of this collection use [`set_cells`](Self::set_cells).
        ///
        /// A list of Cell arns
        pub fn cells(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cells.unwrap_or_default();
            v.push(input.into());
            self.cells = Some(v);
            self
        }
        /// A list of Cell arns
        pub fn set_cells(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cells = input;
            self
        }
        /// The name of the RecoveryGroup to create
        pub fn recovery_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_group_name = Some(input.into());
            self
        }
        /// The name of the RecoveryGroup to create
        pub fn set_recovery_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_group_name = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRecoveryGroupInput`](crate::input::CreateRecoveryGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateRecoveryGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateRecoveryGroupInput {
                cells: self.cells,
                recovery_group_name: self.recovery_group_name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateRecoveryGroupInputOperationOutputAlias = crate::operation::CreateRecoveryGroup;
#[doc(hidden)]
pub type CreateRecoveryGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateRecoveryGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateRecoveryGroup`](crate::operation::CreateRecoveryGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateRecoveryGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateRecoveryGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/recoverygroups").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateRecoveryGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateRecoveryGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_recovery_group(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateRecoveryGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateRecoveryGroup",
            "route53recoveryreadiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateRecoveryGroupInput`](crate::input::CreateRecoveryGroupInput)
    pub fn builder() -> crate::input::create_recovery_group_input::Builder {
        crate::input::create_recovery_group_input::Builder::default()
    }
}

/// See [`CreateResourceSetInput`](crate::input::CreateResourceSetInput)
pub mod create_resource_set_input {
    /// A builder for [`CreateResourceSetInput`](crate::input::CreateResourceSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_set_name: std::option::Option<std::string::String>,
        pub(crate) resource_set_type: std::option::Option<std::string::String>,
        pub(crate) resources: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// The name of the ResourceSet to create
        pub fn resource_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_set_name = Some(input.into());
            self
        }
        /// The name of the ResourceSet to create
        pub fn set_resource_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_set_name = input;
            self
        }
        /// AWS Resource type of the resources in the ResourceSet
        pub fn resource_set_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_set_type = Some(input.into());
            self
        }
        /// AWS Resource type of the resources in the ResourceSet
        pub fn set_resource_set_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_set_type = input;
            self
        }
        /// Appends an item to `resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// A list of Resource objects
        pub fn resources(mut self, input: impl Into<crate::model::Resource>) -> Self {
            let mut v = self.resources.unwrap_or_default();
            v.push(input.into());
            self.resources = Some(v);
            self
        }
        /// A list of Resource objects
        pub fn set_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateResourceSetInput`](crate::input::CreateResourceSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateResourceSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateResourceSetInput {
                resource_set_name: self.resource_set_name,
                resource_set_type: self.resource_set_type,
                resources: self.resources,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateResourceSetInputOperationOutputAlias = crate::operation::CreateResourceSet;
#[doc(hidden)]
pub type CreateResourceSetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateResourceSetInput {
    /// Consumes the builder and constructs an Operation<[`CreateResourceSet`](crate::operation::CreateResourceSet)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateResourceSet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateResourceSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/resourcesets").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateResourceSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateResourceSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_resource_set(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateResourceSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateResourceSet",
            "route53recoveryreadiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateResourceSetInput`](crate::input::CreateResourceSetInput)
    pub fn builder() -> crate::input::create_resource_set_input::Builder {
        crate::input::create_resource_set_input::Builder::default()
    }
}

/// See [`DeleteCellInput`](crate::input::DeleteCellInput)
pub mod delete_cell_input {
    /// A builder for [`DeleteCellInput`](crate::input::DeleteCellInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cell_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The Cell to delete
        pub fn cell_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cell_name = Some(input.into());
            self
        }
        /// The Cell to delete
        pub fn set_cell_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cell_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCellInput`](crate::input::DeleteCellInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteCellInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteCellInput {
                cell_name: self.cell_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteCellInputOperationOutputAlias = crate::operation::DeleteCell;
#[doc(hidden)]
pub type DeleteCellInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteCellInput {
    /// Consumes the builder and constructs an Operation<[`DeleteCell`](crate::operation::DeleteCell)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteCell,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteCellInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.cell_name;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "cell_name",
                        details: "cannot be empty or unset",
                    })?;
            let cell_name = aws_smithy_http::label::fmt_string(input_1, false);
            if cell_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "cell_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/cells/{CellName}", CellName = cell_name)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteCellInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteCellInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteCell::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteCell",
            "route53recoveryreadiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteCellInput`](crate::input::DeleteCellInput)
    pub fn builder() -> crate::input::delete_cell_input::Builder {
        crate::input::delete_cell_input::Builder::default()
    }
}

/// See [`DeleteCrossAccountAuthorizationInput`](crate::input::DeleteCrossAccountAuthorizationInput)
pub mod delete_cross_account_authorization_input {
    /// A builder for [`DeleteCrossAccountAuthorizationInput`](crate::input::DeleteCrossAccountAuthorizationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cross_account_authorization: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The cross account authorization
        pub fn cross_account_authorization(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cross_account_authorization = Some(input.into());
            self
        }
        /// The cross account authorization
        pub fn set_cross_account_authorization(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cross_account_authorization = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCrossAccountAuthorizationInput`](crate::input::DeleteCrossAccountAuthorizationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteCrossAccountAuthorizationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteCrossAccountAuthorizationInput {
                cross_account_authorization: self.cross_account_authorization,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteCrossAccountAuthorizationInputOperationOutputAlias =
    crate::operation::DeleteCrossAccountAuthorization;
#[doc(hidden)]
pub type DeleteCrossAccountAuthorizationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteCrossAccountAuthorizationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteCrossAccountAuthorization`](crate::operation::DeleteCrossAccountAuthorization)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteCrossAccountAuthorization,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteCrossAccountAuthorizationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.cross_account_authorization;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "cross_account_authorization",
                        details: "cannot be empty or unset",
                    })?;
            let cross_account_authorization = aws_smithy_http::label::fmt_string(input_2, false);
            if cross_account_authorization.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "cross_account_authorization",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/crossaccountauthorizations/{CrossAccountAuthorization}",
                CrossAccountAuthorization = cross_account_authorization
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteCrossAccountAuthorizationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteCrossAccountAuthorizationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteCrossAccountAuthorization::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteCrossAccountAuthorization",
            "route53recoveryreadiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteCrossAccountAuthorizationInput`](crate::input::DeleteCrossAccountAuthorizationInput)
    pub fn builder() -> crate::input::delete_cross_account_authorization_input::Builder {
        crate::input::delete_cross_account_authorization_input::Builder::default()
    }
}

/// See [`DeleteReadinessCheckInput`](crate::input::DeleteReadinessCheckInput)
pub mod delete_readiness_check_input {
    /// A builder for [`DeleteReadinessCheckInput`](crate::input::DeleteReadinessCheckInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) readiness_check_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ReadinessCheck to delete
        pub fn readiness_check_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.readiness_check_name = Some(input.into());
            self
        }
        /// The ReadinessCheck to delete
        pub fn set_readiness_check_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.readiness_check_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteReadinessCheckInput`](crate::input::DeleteReadinessCheckInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteReadinessCheckInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteReadinessCheckInput {
                readiness_check_name: self.readiness_check_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteReadinessCheckInputOperationOutputAlias = crate::operation::DeleteReadinessCheck;
#[doc(hidden)]
pub type DeleteReadinessCheckInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteReadinessCheckInput {
    /// Consumes the builder and constructs an Operation<[`DeleteReadinessCheck`](crate::operation::DeleteReadinessCheck)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteReadinessCheck,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteReadinessCheckInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_3 = &_input.readiness_check_name;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "readiness_check_name",
                        details: "cannot be empty or unset",
                    })?;
            let readiness_check_name = aws_smithy_http::label::fmt_string(input_3, false);
            if readiness_check_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "readiness_check_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/readinesschecks/{ReadinessCheckName}",
                ReadinessCheckName = readiness_check_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteReadinessCheckInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteReadinessCheckInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteReadinessCheck::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteReadinessCheck",
            "route53recoveryreadiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteReadinessCheckInput`](crate::input::DeleteReadinessCheckInput)
    pub fn builder() -> crate::input::delete_readiness_check_input::Builder {
        crate::input::delete_readiness_check_input::Builder::default()
    }
}

/// See [`DeleteRecoveryGroupInput`](crate::input::DeleteRecoveryGroupInput)
pub mod delete_recovery_group_input {
    /// A builder for [`DeleteRecoveryGroupInput`](crate::input::DeleteRecoveryGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recovery_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The RecoveryGroup to delete
        pub fn recovery_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_group_name = Some(input.into());
            self
        }
        /// The RecoveryGroup to delete
        pub fn set_recovery_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRecoveryGroupInput`](crate::input::DeleteRecoveryGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRecoveryGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRecoveryGroupInput {
                recovery_group_name: self.recovery_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRecoveryGroupInputOperationOutputAlias = crate::operation::DeleteRecoveryGroup;
#[doc(hidden)]
pub type DeleteRecoveryGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteRecoveryGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRecoveryGroup`](crate::operation::DeleteRecoveryGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRecoveryGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteRecoveryGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.recovery_group_name;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "recovery_group_name",
                        details: "cannot be empty or unset",
                    })?;
            let recovery_group_name = aws_smithy_http::label::fmt_string(input_4, false);
            if recovery_group_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "recovery_group_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/recoverygroups/{RecoveryGroupName}",
                RecoveryGroupName = recovery_group_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteRecoveryGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteRecoveryGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRecoveryGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRecoveryGroup",
            "route53recoveryreadiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteRecoveryGroupInput`](crate::input::DeleteRecoveryGroupInput)
    pub fn builder() -> crate::input::delete_recovery_group_input::Builder {
        crate::input::delete_recovery_group_input::Builder::default()
    }
}

/// See [`DeleteResourceSetInput`](crate::input::DeleteResourceSetInput)
pub mod delete_resource_set_input {
    /// A builder for [`DeleteResourceSetInput`](crate::input::DeleteResourceSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_set_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ResourceSet to delete
        pub fn resource_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_set_name = Some(input.into());
            self
        }
        /// The ResourceSet to delete
        pub fn set_resource_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_set_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteResourceSetInput`](crate::input::DeleteResourceSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteResourceSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteResourceSetInput {
                resource_set_name: self.resource_set_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteResourceSetInputOperationOutputAlias = crate::operation::DeleteResourceSet;
#[doc(hidden)]
pub type DeleteResourceSetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteResourceSetInput {
    /// Consumes the builder and constructs an Operation<[`DeleteResourceSet`](crate::operation::DeleteResourceSet)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteResourceSet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteResourceSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.resource_set_name;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_set_name",
                        details: "cannot be empty or unset",
                    })?;
            let resource_set_name = aws_smithy_http::label::fmt_string(input_5, false);
            if resource_set_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_set_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/resourcesets/{ResourceSetName}",
                ResourceSetName = resource_set_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteResourceSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteResourceSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteResourceSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteResourceSet",
            "route53recoveryreadiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteResourceSetInput`](crate::input::DeleteResourceSetInput)
    pub fn builder() -> crate::input::delete_resource_set_input::Builder {
        crate::input::delete_resource_set_input::Builder::default()
    }
}

/// See [`GetArchitectureRecommendationsInput`](crate::input::GetArchitectureRecommendationsInput)
pub mod get_architecture_recommendations_input {
    /// A builder for [`GetArchitectureRecommendationsInput`](crate::input::GetArchitectureRecommendationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) recovery_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Upper bound on number of records to return.
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// Upper bound on number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// A token that can be used to resume pagination from the end of the collection.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// A token that can be used to resume pagination from the end of the collection.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Name of RecoveryGroup (top level resource) to be analyzed.
        pub fn recovery_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_group_name = Some(input.into());
            self
        }
        /// Name of RecoveryGroup (top level resource) to be analyzed.
        pub fn set_recovery_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetArchitectureRecommendationsInput`](crate::input::GetArchitectureRecommendationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetArchitectureRecommendationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetArchitectureRecommendationsInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
                recovery_group_name: self.recovery_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetArchitectureRecommendationsInputOperationOutputAlias =
    crate::operation::GetArchitectureRecommendations;
#[doc(hidden)]
pub type GetArchitectureRecommendationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetArchitectureRecommendationsInput {
    /// Consumes the builder and constructs an Operation<[`GetArchitectureRecommendations`](crate::operation::GetArchitectureRecommendations)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetArchitectureRecommendations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetArchitectureRecommendationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_6 = &_input.recovery_group_name;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "recovery_group_name",
                        details: "cannot be empty or unset",
                    })?;
            let recovery_group_name = aws_smithy_http::label::fmt_string(input_6, false);
            if recovery_group_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "recovery_group_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/recoverygroups/{RecoveryGroupName}/architectureRecommendations",
                RecoveryGroupName = recovery_group_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetArchitectureRecommendationsInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_7) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_7));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetArchitectureRecommendationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetArchitectureRecommendationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetArchitectureRecommendations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetArchitectureRecommendations",
            "route53recoveryreadiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetArchitectureRecommendationsInput`](crate::input::GetArchitectureRecommendationsInput)
    pub fn builder() -> crate::input::get_architecture_recommendations_input::Builder {
        crate::input::get_architecture_recommendations_input::Builder::default()
    }
}

/// See [`GetCellInput`](crate::input::GetCellInput)
pub mod get_cell_input {
    /// A builder for [`GetCellInput`](crate::input::GetCellInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cell_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The Cell to get
        pub fn cell_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cell_name = Some(input.into());
            self
        }
        /// The Cell to get
        pub fn set_cell_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cell_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCellInput`](crate::input::GetCellInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetCellInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetCellInput {
                cell_name: self.cell_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCellInputOperationOutputAlias = crate::operation::GetCell;
#[doc(hidden)]
pub type GetCellInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetCellInput {
    /// Consumes the builder and constructs an Operation<[`GetCell`](crate::operation::GetCell)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCell,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetCellInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_8 = &_input.cell_name;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "cell_name",
                        details: "cannot be empty or unset",
                    })?;
            let cell_name = aws_smithy_http::label::fmt_string(input_8, false);
            if cell_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "cell_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/cells/{CellName}", CellName = cell_name)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetCellInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetCellInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetCell::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetCell",
                    "route53recoveryreadiness",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetCellInput`](crate::input::GetCellInput)
    pub fn builder() -> crate::input::get_cell_input::Builder {
        crate::input::get_cell_input::Builder::default()
    }
}

/// See [`GetCellReadinessSummaryInput`](crate::input::GetCellReadinessSummaryInput)
pub mod get_cell_readiness_summary_input {
    /// A builder for [`GetCellReadinessSummaryInput`](crate::input::GetCellReadinessSummaryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cell_name: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The name of the Cell
        pub fn cell_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cell_name = Some(input.into());
            self
        }
        /// The name of the Cell
        pub fn set_cell_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cell_name = input;
            self
        }
        /// Upper bound on number of records to return.
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// Upper bound on number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCellReadinessSummaryInput`](crate::input::GetCellReadinessSummaryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCellReadinessSummaryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCellReadinessSummaryInput {
                cell_name: self.cell_name,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCellReadinessSummaryInputOperationOutputAlias =
    crate::operation::GetCellReadinessSummary;
#[doc(hidden)]
pub type GetCellReadinessSummaryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetCellReadinessSummaryInput {
    /// Consumes the builder and constructs an Operation<[`GetCellReadinessSummary`](crate::operation::GetCellReadinessSummary)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCellReadinessSummary,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetCellReadinessSummaryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_9 = &_input.cell_name;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "cell_name",
                        details: "cannot be empty or unset",
                    })?;
            let cell_name = aws_smithy_http::label::fmt_string(input_9, false);
            if cell_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "cell_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/cellreadiness/{CellName}", CellName = cell_name)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetCellReadinessSummaryInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_10) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_10));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetCellReadinessSummaryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetCellReadinessSummaryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCellReadinessSummary::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCellReadinessSummary",
            "route53recoveryreadiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetCellReadinessSummaryInput`](crate::input::GetCellReadinessSummaryInput)
    pub fn builder() -> crate::input::get_cell_readiness_summary_input::Builder {
        crate::input::get_cell_readiness_summary_input::Builder::default()
    }
}

/// See [`GetReadinessCheckInput`](crate::input::GetReadinessCheckInput)
pub mod get_readiness_check_input {
    /// A builder for [`GetReadinessCheckInput`](crate::input::GetReadinessCheckInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) readiness_check_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ReadinessCheck to get
        pub fn readiness_check_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.readiness_check_name = Some(input.into());
            self
        }
        /// The ReadinessCheck to get
        pub fn set_readiness_check_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.readiness_check_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetReadinessCheckInput`](crate::input::GetReadinessCheckInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetReadinessCheckInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetReadinessCheckInput {
                readiness_check_name: self.readiness_check_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetReadinessCheckInputOperationOutputAlias = crate::operation::GetReadinessCheck;
#[doc(hidden)]
pub type GetReadinessCheckInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetReadinessCheckInput {
    /// Consumes the builder and constructs an Operation<[`GetReadinessCheck`](crate::operation::GetReadinessCheck)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetReadinessCheck,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetReadinessCheckInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_11 = &_input.readiness_check_name;
            let input_11 =
                input_11
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "readiness_check_name",
                        details: "cannot be empty or unset",
                    })?;
            let readiness_check_name = aws_smithy_http::label::fmt_string(input_11, false);
            if readiness_check_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "readiness_check_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/readinesschecks/{ReadinessCheckName}",
                ReadinessCheckName = readiness_check_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetReadinessCheckInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetReadinessCheckInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetReadinessCheck::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetReadinessCheck",
            "route53recoveryreadiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetReadinessCheckInput`](crate::input::GetReadinessCheckInput)
    pub fn builder() -> crate::input::get_readiness_check_input::Builder {
        crate::input::get_readiness_check_input::Builder::default()
    }
}

/// See [`GetReadinessCheckResourceStatusInput`](crate::input::GetReadinessCheckResourceStatusInput)
pub mod get_readiness_check_resource_status_input {
    /// A builder for [`GetReadinessCheckResourceStatusInput`](crate::input::GetReadinessCheckResourceStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) readiness_check_name: std::option::Option<std::string::String>,
        pub(crate) resource_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Upper bound on number of records to return.
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// Upper bound on number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// The ReadinessCheck to get
        pub fn readiness_check_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.readiness_check_name = Some(input.into());
            self
        }
        /// The ReadinessCheck to get
        pub fn set_readiness_check_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.readiness_check_name = input;
            self
        }
        /// The resource ARN or component Id to get
        pub fn resource_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_identifier = Some(input.into());
            self
        }
        /// The resource ARN or component Id to get
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`GetReadinessCheckResourceStatusInput`](crate::input::GetReadinessCheckResourceStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetReadinessCheckResourceStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetReadinessCheckResourceStatusInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
                readiness_check_name: self.readiness_check_name,
                resource_identifier: self.resource_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type GetReadinessCheckResourceStatusInputOperationOutputAlias =
    crate::operation::GetReadinessCheckResourceStatus;
#[doc(hidden)]
pub type GetReadinessCheckResourceStatusInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetReadinessCheckResourceStatusInput {
    /// Consumes the builder and constructs an Operation<[`GetReadinessCheckResourceStatus`](crate::operation::GetReadinessCheckResourceStatus)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetReadinessCheckResourceStatus,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetReadinessCheckResourceStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_12 = &_input.readiness_check_name;
            let input_12 =
                input_12
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "readiness_check_name",
                        details: "cannot be empty or unset",
                    })?;
            let readiness_check_name = aws_smithy_http::label::fmt_string(input_12, false);
            if readiness_check_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "readiness_check_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_13 = &_input.resource_identifier;
            let input_13 =
                input_13
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_identifier",
                        details: "cannot be empty or unset",
                    })?;
            let resource_identifier = aws_smithy_http::label::fmt_string(input_13, false);
            if resource_identifier.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_identifier",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/readinesschecks/{ReadinessCheckName}/resource/{ResourceIdentifier}/status",
                ReadinessCheckName = readiness_check_name,
                ResourceIdentifier = resource_identifier
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetReadinessCheckResourceStatusInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_14) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_14));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetReadinessCheckResourceStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetReadinessCheckResourceStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetReadinessCheckResourceStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetReadinessCheckResourceStatus",
            "route53recoveryreadiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetReadinessCheckResourceStatusInput`](crate::input::GetReadinessCheckResourceStatusInput)
    pub fn builder() -> crate::input::get_readiness_check_resource_status_input::Builder {
        crate::input::get_readiness_check_resource_status_input::Builder::default()
    }
}

/// See [`GetReadinessCheckStatusInput`](crate::input::GetReadinessCheckStatusInput)
pub mod get_readiness_check_status_input {
    /// A builder for [`GetReadinessCheckStatusInput`](crate::input::GetReadinessCheckStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) readiness_check_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Upper bound on number of records to return.
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// Upper bound on number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// The ReadinessCheck to get
        pub fn readiness_check_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.readiness_check_name = Some(input.into());
            self
        }
        /// The ReadinessCheck to get
        pub fn set_readiness_check_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.readiness_check_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetReadinessCheckStatusInput`](crate::input::GetReadinessCheckStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetReadinessCheckStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetReadinessCheckStatusInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
                readiness_check_name: self.readiness_check_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetReadinessCheckStatusInputOperationOutputAlias =
    crate::operation::GetReadinessCheckStatus;
#[doc(hidden)]
pub type GetReadinessCheckStatusInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetReadinessCheckStatusInput {
    /// Consumes the builder and constructs an Operation<[`GetReadinessCheckStatus`](crate::operation::GetReadinessCheckStatus)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetReadinessCheckStatus,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetReadinessCheckStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_15 = &_input.readiness_check_name;
            let input_15 =
                input_15
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "readiness_check_name",
                        details: "cannot be empty or unset",
                    })?;
            let readiness_check_name = aws_smithy_http::label::fmt_string(input_15, false);
            if readiness_check_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "readiness_check_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/readinesschecks/{ReadinessCheckName}/status",
                ReadinessCheckName = readiness_check_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetReadinessCheckStatusInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_16) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_16));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetReadinessCheckStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetReadinessCheckStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetReadinessCheckStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetReadinessCheckStatus",
            "route53recoveryreadiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetReadinessCheckStatusInput`](crate::input::GetReadinessCheckStatusInput)
    pub fn builder() -> crate::input::get_readiness_check_status_input::Builder {
        crate::input::get_readiness_check_status_input::Builder::default()
    }
}

/// See [`GetRecoveryGroupInput`](crate::input::GetRecoveryGroupInput)
pub mod get_recovery_group_input {
    /// A builder for [`GetRecoveryGroupInput`](crate::input::GetRecoveryGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recovery_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The RecoveryGroup to get
        pub fn recovery_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_group_name = Some(input.into());
            self
        }
        /// The RecoveryGroup to get
        pub fn set_recovery_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRecoveryGroupInput`](crate::input::GetRecoveryGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetRecoveryGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetRecoveryGroupInput {
                recovery_group_name: self.recovery_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRecoveryGroupInputOperationOutputAlias = crate::operation::GetRecoveryGroup;
#[doc(hidden)]
pub type GetRecoveryGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetRecoveryGroupInput {
    /// Consumes the builder and constructs an Operation<[`GetRecoveryGroup`](crate::operation::GetRecoveryGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRecoveryGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetRecoveryGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_17 = &_input.recovery_group_name;
            let input_17 =
                input_17
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "recovery_group_name",
                        details: "cannot be empty or unset",
                    })?;
            let recovery_group_name = aws_smithy_http::label::fmt_string(input_17, false);
            if recovery_group_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "recovery_group_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/recoverygroups/{RecoveryGroupName}",
                RecoveryGroupName = recovery_group_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetRecoveryGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetRecoveryGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetRecoveryGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetRecoveryGroup",
            "route53recoveryreadiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetRecoveryGroupInput`](crate::input::GetRecoveryGroupInput)
    pub fn builder() -> crate::input::get_recovery_group_input::Builder {
        crate::input::get_recovery_group_input::Builder::default()
    }
}

/// See [`GetRecoveryGroupReadinessSummaryInput`](crate::input::GetRecoveryGroupReadinessSummaryInput)
pub mod get_recovery_group_readiness_summary_input {
    /// A builder for [`GetRecoveryGroupReadinessSummaryInput`](crate::input::GetRecoveryGroupReadinessSummaryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) recovery_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Upper bound on number of records to return.
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// Upper bound on number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// The name of the RecoveryGroup
        pub fn recovery_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_group_name = Some(input.into());
            self
        }
        /// The name of the RecoveryGroup
        pub fn set_recovery_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRecoveryGroupReadinessSummaryInput`](crate::input::GetRecoveryGroupReadinessSummaryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetRecoveryGroupReadinessSummaryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetRecoveryGroupReadinessSummaryInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
                recovery_group_name: self.recovery_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRecoveryGroupReadinessSummaryInputOperationOutputAlias =
    crate::operation::GetRecoveryGroupReadinessSummary;
#[doc(hidden)]
pub type GetRecoveryGroupReadinessSummaryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetRecoveryGroupReadinessSummaryInput {
    /// Consumes the builder and constructs an Operation<[`GetRecoveryGroupReadinessSummary`](crate::operation::GetRecoveryGroupReadinessSummary)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRecoveryGroupReadinessSummary,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetRecoveryGroupReadinessSummaryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_18 = &_input.recovery_group_name;
            let input_18 =
                input_18
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "recovery_group_name",
                        details: "cannot be empty or unset",
                    })?;
            let recovery_group_name = aws_smithy_http::label::fmt_string(input_18, false);
            if recovery_group_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "recovery_group_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/recoverygroupreadiness/{RecoveryGroupName}",
                RecoveryGroupName = recovery_group_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetRecoveryGroupReadinessSummaryInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_19) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_19));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetRecoveryGroupReadinessSummaryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetRecoveryGroupReadinessSummaryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetRecoveryGroupReadinessSummary::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetRecoveryGroupReadinessSummary",
            "route53recoveryreadiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetRecoveryGroupReadinessSummaryInput`](crate::input::GetRecoveryGroupReadinessSummaryInput)
    pub fn builder() -> crate::input::get_recovery_group_readiness_summary_input::Builder {
        crate::input::get_recovery_group_readiness_summary_input::Builder::default()
    }
}

/// See [`GetResourceSetInput`](crate::input::GetResourceSetInput)
pub mod get_resource_set_input {
    /// A builder for [`GetResourceSetInput`](crate::input::GetResourceSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_set_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ResourceSet to get
        pub fn resource_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_set_name = Some(input.into());
            self
        }
        /// The ResourceSet to get
        pub fn set_resource_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_set_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResourceSetInput`](crate::input::GetResourceSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetResourceSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetResourceSetInput {
                resource_set_name: self.resource_set_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetResourceSetInputOperationOutputAlias = crate::operation::GetResourceSet;
#[doc(hidden)]
pub type GetResourceSetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetResourceSetInput {
    /// Consumes the builder and constructs an Operation<[`GetResourceSet`](crate::operation::GetResourceSet)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetResourceSet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetResourceSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_20 = &_input.resource_set_name;
            let input_20 =
                input_20
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_set_name",
                        details: "cannot be empty or unset",
                    })?;
            let resource_set_name = aws_smithy_http::label::fmt_string(input_20, false);
            if resource_set_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_set_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/resourcesets/{ResourceSetName}",
                ResourceSetName = resource_set_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetResourceSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetResourceSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetResourceSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetResourceSet",
            "route53recoveryreadiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetResourceSetInput`](crate::input::GetResourceSetInput)
    pub fn builder() -> crate::input::get_resource_set_input::Builder {
        crate::input::get_resource_set_input::Builder::default()
    }
}

/// See [`ListCellsInput`](crate::input::ListCellsInput)
pub mod list_cells_input {
    /// A builder for [`ListCellsInput`](crate::input::ListCellsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Upper bound on number of records to return.
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// Upper bound on number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCellsInput`](crate::input::ListCellsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListCellsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListCellsInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListCellsInputOperationOutputAlias = crate::operation::ListCells;
#[doc(hidden)]
pub type ListCellsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListCellsInput {
    /// Consumes the builder and constructs an Operation<[`ListCells`](crate::operation::ListCells)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListCells,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListCellsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/cells").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListCellsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_21) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_21));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListCellsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListCellsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListCells::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListCells",
                    "route53recoveryreadiness",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListCellsInput`](crate::input::ListCellsInput)
    pub fn builder() -> crate::input::list_cells_input::Builder {
        crate::input::list_cells_input::Builder::default()
    }
}

/// See [`ListCrossAccountAuthorizationsInput`](crate::input::ListCrossAccountAuthorizationsInput)
pub mod list_cross_account_authorizations_input {
    /// A builder for [`ListCrossAccountAuthorizationsInput`](crate::input::ListCrossAccountAuthorizationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Upper bound on number of records to return.
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// Upper bound on number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCrossAccountAuthorizationsInput`](crate::input::ListCrossAccountAuthorizationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListCrossAccountAuthorizationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListCrossAccountAuthorizationsInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListCrossAccountAuthorizationsInputOperationOutputAlias =
    crate::operation::ListCrossAccountAuthorizations;
#[doc(hidden)]
pub type ListCrossAccountAuthorizationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListCrossAccountAuthorizationsInput {
    /// Consumes the builder and constructs an Operation<[`ListCrossAccountAuthorizations`](crate::operation::ListCrossAccountAuthorizations)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListCrossAccountAuthorizations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListCrossAccountAuthorizationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/crossaccountauthorizations").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListCrossAccountAuthorizationsInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_22) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_22));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListCrossAccountAuthorizationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListCrossAccountAuthorizationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListCrossAccountAuthorizations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListCrossAccountAuthorizations",
            "route53recoveryreadiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListCrossAccountAuthorizationsInput`](crate::input::ListCrossAccountAuthorizationsInput)
    pub fn builder() -> crate::input::list_cross_account_authorizations_input::Builder {
        crate::input::list_cross_account_authorizations_input::Builder::default()
    }
}

/// See [`ListReadinessChecksInput`](crate::input::ListReadinessChecksInput)
pub mod list_readiness_checks_input {
    /// A builder for [`ListReadinessChecksInput`](crate::input::ListReadinessChecksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Upper bound on number of records to return.
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// Upper bound on number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListReadinessChecksInput`](crate::input::ListReadinessChecksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListReadinessChecksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListReadinessChecksInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListReadinessChecksInputOperationOutputAlias = crate::operation::ListReadinessChecks;
#[doc(hidden)]
pub type ListReadinessChecksInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListReadinessChecksInput {
    /// Consumes the builder and constructs an Operation<[`ListReadinessChecks`](crate::operation::ListReadinessChecks)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListReadinessChecks,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListReadinessChecksInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/readinesschecks").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListReadinessChecksInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_23) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_23));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListReadinessChecksInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListReadinessChecksInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListReadinessChecks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListReadinessChecks",
            "route53recoveryreadiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListReadinessChecksInput`](crate::input::ListReadinessChecksInput)
    pub fn builder() -> crate::input::list_readiness_checks_input::Builder {
        crate::input::list_readiness_checks_input::Builder::default()
    }
}

/// See [`ListRecoveryGroupsInput`](crate::input::ListRecoveryGroupsInput)
pub mod list_recovery_groups_input {
    /// A builder for [`ListRecoveryGroupsInput`](crate::input::ListRecoveryGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Upper bound on number of records to return.
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// Upper bound on number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRecoveryGroupsInput`](crate::input::ListRecoveryGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListRecoveryGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListRecoveryGroupsInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRecoveryGroupsInputOperationOutputAlias = crate::operation::ListRecoveryGroups;
#[doc(hidden)]
pub type ListRecoveryGroupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListRecoveryGroupsInput {
    /// Consumes the builder and constructs an Operation<[`ListRecoveryGroups`](crate::operation::ListRecoveryGroups)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRecoveryGroups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListRecoveryGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/recoverygroups").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListRecoveryGroupsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_24) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_24));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListRecoveryGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListRecoveryGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListRecoveryGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListRecoveryGroups",
            "route53recoveryreadiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListRecoveryGroupsInput`](crate::input::ListRecoveryGroupsInput)
    pub fn builder() -> crate::input::list_recovery_groups_input::Builder {
        crate::input::list_recovery_groups_input::Builder::default()
    }
}

/// See [`ListResourceSetsInput`](crate::input::ListResourceSetsInput)
pub mod list_resource_sets_input {
    /// A builder for [`ListResourceSetsInput`](crate::input::ListResourceSetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Upper bound on number of records to return.
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// Upper bound on number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResourceSetsInput`](crate::input::ListResourceSetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListResourceSetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListResourceSetsInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListResourceSetsInputOperationOutputAlias = crate::operation::ListResourceSets;
#[doc(hidden)]
pub type ListResourceSetsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListResourceSetsInput {
    /// Consumes the builder and constructs an Operation<[`ListResourceSets`](crate::operation::ListResourceSets)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListResourceSets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListResourceSetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/resourcesets").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListResourceSetsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_25) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_25));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListResourceSetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListResourceSetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListResourceSets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListResourceSets",
            "route53recoveryreadiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListResourceSetsInput`](crate::input::ListResourceSetsInput)
    pub fn builder() -> crate::input::list_resource_sets_input::Builder {
        crate::input::list_resource_sets_input::Builder::default()
    }
}

/// See [`ListRulesInput`](crate::input::ListRulesInput)
pub mod list_rules_input {
    /// A builder for [`ListRulesInput`](crate::input::ListRulesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Upper bound on number of records to return.
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// Upper bound on number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Filter parameter which specifies the rules to return given a resource type.
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// Filter parameter which specifies the rules to return given a resource type.
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRulesInput`](crate::input::ListRulesInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListRulesInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListRulesInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
                resource_type: self.resource_type,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRulesInputOperationOutputAlias = crate::operation::ListRules;
#[doc(hidden)]
pub type ListRulesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListRulesInput {
    /// Consumes the builder and constructs an Operation<[`ListRules`](crate::operation::ListRules)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRules,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListRulesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/rules").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListRulesInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_26) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_26));
            }
            if let Some(inner_27) = &_input.resource_type {
                query.push_kv(
                    "resourceType",
                    &aws_smithy_http::query::fmt_string(&inner_27),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListRulesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListRulesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListRules::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListRules",
                    "route53recoveryreadiness",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListRulesInput`](crate::input::ListRulesInput)
    pub fn builder() -> crate::input::list_rules_input::Builder {
        crate::input::list_rules_input::Builder::default()
    }
}

/// See [`ListTagsForResourcesInput`](crate::input::ListTagsForResourcesInput)
pub mod list_tags_for_resources_input {
    /// A builder for [`ListTagsForResourcesInput`](crate::input::ListTagsForResourcesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourcesInput`](crate::input::ListTagsForResourcesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourcesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourcesInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourcesInputOperationOutputAlias = crate::operation::ListTagsForResources;
#[doc(hidden)]
pub type ListTagsForResourcesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourcesInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResources`](crate::operation::ListTagsForResources)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResources,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourcesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_28 = &_input.resource_arn;
            let input_28 =
                input_28
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_28, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourcesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourcesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResources::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResources",
            "route53recoveryreadiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourcesInput`](crate::input::ListTagsForResourcesInput)
    pub fn builder() -> crate::input::list_tags_for_resources_input::Builder {
        crate::input::list_tags_for_resources_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_29 = &_input.resource_arn;
            let input_29 =
                input_29
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_29, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "route53recoveryreadiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// A comma-separated list of the tag keys to remove from the resource.
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// A comma-separated list of the tag keys to remove from the resource.
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_30 = &_input.resource_arn;
            let input_30 =
                input_30
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_30, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::UntagResourceInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_31) = &_input.tag_keys {
                for inner_32 in inner_31 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_32));
                }
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "route53recoveryreadiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateCellInput`](crate::input::UpdateCellInput)
pub mod update_cell_input {
    /// A builder for [`UpdateCellInput`](crate::input::UpdateCellInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cell_name: std::option::Option<std::string::String>,
        pub(crate) cells: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// The Cell to update
        pub fn cell_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cell_name = Some(input.into());
            self
        }
        /// The Cell to update
        pub fn set_cell_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cell_name = input;
            self
        }
        /// Appends an item to `cells`.
        ///
        /// To override the contents of this collection use [`set_cells`](Self::set_cells).
        ///
        /// A list of Cell arns, completely replaces previous list
        pub fn cells(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cells.unwrap_or_default();
            v.push(input.into());
            self.cells = Some(v);
            self
        }
        /// A list of Cell arns, completely replaces previous list
        pub fn set_cells(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cells = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateCellInput`](crate::input::UpdateCellInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateCellInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateCellInput {
                cell_name: self.cell_name,
                cells: self.cells,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateCellInputOperationOutputAlias = crate::operation::UpdateCell;
#[doc(hidden)]
pub type UpdateCellInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateCellInput {
    /// Consumes the builder and constructs an Operation<[`UpdateCell`](crate::operation::UpdateCell)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateCell,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateCellInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_33 = &_input.cell_name;
            let input_33 =
                input_33
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "cell_name",
                        details: "cannot be empty or unset",
                    })?;
            let cell_name = aws_smithy_http::label::fmt_string(input_33, false);
            if cell_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "cell_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/cells/{CellName}", CellName = cell_name)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateCellInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateCellInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_cell(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateCell::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateCell",
            "route53recoveryreadiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateCellInput`](crate::input::UpdateCellInput)
    pub fn builder() -> crate::input::update_cell_input::Builder {
        crate::input::update_cell_input::Builder::default()
    }
}

/// See [`UpdateReadinessCheckInput`](crate::input::UpdateReadinessCheckInput)
pub mod update_readiness_check_input {
    /// A builder for [`UpdateReadinessCheckInput`](crate::input::UpdateReadinessCheckInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) readiness_check_name: std::option::Option<std::string::String>,
        pub(crate) resource_set_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ReadinessCheck to update
        pub fn readiness_check_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.readiness_check_name = Some(input.into());
            self
        }
        /// The ReadinessCheck to update
        pub fn set_readiness_check_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.readiness_check_name = input;
            self
        }
        /// The name of the ResourceSet to check
        pub fn resource_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_set_name = Some(input.into());
            self
        }
        /// The name of the ResourceSet to check
        pub fn set_resource_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_set_name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateReadinessCheckInput`](crate::input::UpdateReadinessCheckInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateReadinessCheckInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateReadinessCheckInput {
                readiness_check_name: self.readiness_check_name,
                resource_set_name: self.resource_set_name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateReadinessCheckInputOperationOutputAlias = crate::operation::UpdateReadinessCheck;
#[doc(hidden)]
pub type UpdateReadinessCheckInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateReadinessCheckInput {
    /// Consumes the builder and constructs an Operation<[`UpdateReadinessCheck`](crate::operation::UpdateReadinessCheck)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateReadinessCheck,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateReadinessCheckInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_34 = &_input.readiness_check_name;
            let input_34 =
                input_34
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "readiness_check_name",
                        details: "cannot be empty or unset",
                    })?;
            let readiness_check_name = aws_smithy_http::label::fmt_string(input_34, false);
            if readiness_check_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "readiness_check_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/readinesschecks/{ReadinessCheckName}",
                ReadinessCheckName = readiness_check_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateReadinessCheckInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateReadinessCheckInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_readiness_check(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateReadinessCheck::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateReadinessCheck",
            "route53recoveryreadiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateReadinessCheckInput`](crate::input::UpdateReadinessCheckInput)
    pub fn builder() -> crate::input::update_readiness_check_input::Builder {
        crate::input::update_readiness_check_input::Builder::default()
    }
}

/// See [`UpdateRecoveryGroupInput`](crate::input::UpdateRecoveryGroupInput)
pub mod update_recovery_group_input {
    /// A builder for [`UpdateRecoveryGroupInput`](crate::input::UpdateRecoveryGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cells: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) recovery_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `cells`.
        ///
        /// To override the contents of this collection use [`set_cells`](Self::set_cells).
        ///
        /// A list of Cell arns, completely replaces previous list
        pub fn cells(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cells.unwrap_or_default();
            v.push(input.into());
            self.cells = Some(v);
            self
        }
        /// A list of Cell arns, completely replaces previous list
        pub fn set_cells(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cells = input;
            self
        }
        /// The RecoveryGroup to update
        pub fn recovery_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_group_name = Some(input.into());
            self
        }
        /// The RecoveryGroup to update
        pub fn set_recovery_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRecoveryGroupInput`](crate::input::UpdateRecoveryGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateRecoveryGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateRecoveryGroupInput {
                cells: self.cells,
                recovery_group_name: self.recovery_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateRecoveryGroupInputOperationOutputAlias = crate::operation::UpdateRecoveryGroup;
#[doc(hidden)]
pub type UpdateRecoveryGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateRecoveryGroupInput {
    /// Consumes the builder and constructs an Operation<[`UpdateRecoveryGroup`](crate::operation::UpdateRecoveryGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateRecoveryGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateRecoveryGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_35 = &_input.recovery_group_name;
            let input_35 =
                input_35
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "recovery_group_name",
                        details: "cannot be empty or unset",
                    })?;
            let recovery_group_name = aws_smithy_http::label::fmt_string(input_35, false);
            if recovery_group_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "recovery_group_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/recoverygroups/{RecoveryGroupName}",
                RecoveryGroupName = recovery_group_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateRecoveryGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateRecoveryGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_recovery_group(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateRecoveryGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateRecoveryGroup",
            "route53recoveryreadiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateRecoveryGroupInput`](crate::input::UpdateRecoveryGroupInput)
    pub fn builder() -> crate::input::update_recovery_group_input::Builder {
        crate::input::update_recovery_group_input::Builder::default()
    }
}

/// See [`UpdateResourceSetInput`](crate::input::UpdateResourceSetInput)
pub mod update_resource_set_input {
    /// A builder for [`UpdateResourceSetInput`](crate::input::UpdateResourceSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_set_name: std::option::Option<std::string::String>,
        pub(crate) resource_set_type: std::option::Option<std::string::String>,
        pub(crate) resources: std::option::Option<std::vec::Vec<crate::model::Resource>>,
    }
    impl Builder {
        /// The ResourceSet to update
        pub fn resource_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_set_name = Some(input.into());
            self
        }
        /// The ResourceSet to update
        pub fn set_resource_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_set_name = input;
            self
        }
        /// AWS Resource Type of the resources in the ResourceSet
        pub fn resource_set_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_set_type = Some(input.into());
            self
        }
        /// AWS Resource Type of the resources in the ResourceSet
        pub fn set_resource_set_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_set_type = input;
            self
        }
        /// Appends an item to `resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// A list of Resource objects
        pub fn resources(mut self, input: impl Into<crate::model::Resource>) -> Self {
            let mut v = self.resources.unwrap_or_default();
            v.push(input.into());
            self.resources = Some(v);
            self
        }
        /// A list of Resource objects
        pub fn set_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateResourceSetInput`](crate::input::UpdateResourceSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateResourceSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateResourceSetInput {
                resource_set_name: self.resource_set_name,
                resource_set_type: self.resource_set_type,
                resources: self.resources,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateResourceSetInputOperationOutputAlias = crate::operation::UpdateResourceSet;
#[doc(hidden)]
pub type UpdateResourceSetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateResourceSetInput {
    /// Consumes the builder and constructs an Operation<[`UpdateResourceSet`](crate::operation::UpdateResourceSet)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateResourceSet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateResourceSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_36 = &_input.resource_set_name;
            let input_36 =
                input_36
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_set_name",
                        details: "cannot be empty or unset",
                    })?;
            let resource_set_name = aws_smithy_http::label::fmt_string(input_36, false);
            if resource_set_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_set_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/resourcesets/{ResourceSetName}",
                ResourceSetName = resource_set_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateResourceSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateResourceSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_resource_set(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateResourceSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateResourceSet",
            "route53recoveryreadiness",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateResourceSetInput`](crate::input::UpdateResourceSetInput)
    pub fn builder() -> crate::input::update_resource_set_input::Builder {
        crate::input::update_resource_set_input::Builder::default()
    }
}

/// configuration for the desired
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateResourceSetInput {
    /// The ResourceSet to update
    pub resource_set_name: std::option::Option<std::string::String>,
    /// AWS Resource Type of the resources in the ResourceSet
    pub resource_set_type: std::option::Option<std::string::String>,
    /// A list of Resource objects
    pub resources: std::option::Option<std::vec::Vec<crate::model::Resource>>,
}
impl std::fmt::Debug for UpdateResourceSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateResourceSetInput");
        formatter.field("resource_set_name", &self.resource_set_name);
        formatter.field("resource_set_type", &self.resource_set_type);
        formatter.field("resources", &self.resources);
        formatter.finish()
    }
}

/// Parameters to update for the RecoveryGroup
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRecoveryGroupInput {
    /// A list of Cell arns, completely replaces previous list
    pub cells: std::option::Option<std::vec::Vec<std::string::String>>,
    /// The RecoveryGroup to update
    pub recovery_group_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateRecoveryGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRecoveryGroupInput");
        formatter.field("cells", &self.cells);
        formatter.field("recovery_group_name", &self.recovery_group_name);
        formatter.finish()
    }
}

/// The new Readiness Check values
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateReadinessCheckInput {
    /// The ReadinessCheck to update
    pub readiness_check_name: std::option::Option<std::string::String>,
    /// The name of the ResourceSet to check
    pub resource_set_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateReadinessCheckInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateReadinessCheckInput");
        formatter.field("readiness_check_name", &self.readiness_check_name);
        formatter.field("resource_set_name", &self.resource_set_name);
        formatter.finish()
    }
}

/// Parameters to update for the Cell
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateCellInput {
    /// The Cell to update
    pub cell_name: std::option::Option<std::string::String>,
    /// A list of Cell arns, completely replaces previous list
    pub cells: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for UpdateCellInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCellInput");
        formatter.field("cell_name", &self.cell_name);
        formatter.field("cells", &self.cells);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
    pub resource_arn: std::option::Option<std::string::String>,
    /// A comma-separated list of the tag keys to remove from the resource.
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
    pub resource_arn: std::option::Option<std::string::String>,
    /// A collection of tags associated with a resource
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourcesInput {
    /// The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
    pub resource_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListTagsForResourcesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourcesInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRulesInput {
    /// Upper bound on number of records to return.
    pub max_results: i32,
    /// A token used to resume pagination from the end of a previous request.
    pub next_token: std::option::Option<std::string::String>,
    /// Filter parameter which specifies the rules to return given a resource type.
    pub resource_type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListRulesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRulesInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResourceSetsInput {
    /// Upper bound on number of records to return.
    pub max_results: i32,
    /// A token used to resume pagination from the end of a previous request.
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListResourceSetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResourceSetsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRecoveryGroupsInput {
    /// Upper bound on number of records to return.
    pub max_results: i32,
    /// A token used to resume pagination from the end of a previous request.
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListRecoveryGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRecoveryGroupsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListReadinessChecksInput {
    /// Upper bound on number of records to return.
    pub max_results: i32,
    /// A token used to resume pagination from the end of a previous request.
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListReadinessChecksInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListReadinessChecksInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCrossAccountAuthorizationsInput {
    /// Upper bound on number of records to return.
    pub max_results: i32,
    /// A token used to resume pagination from the end of a previous request.
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListCrossAccountAuthorizationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCrossAccountAuthorizationsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCellsInput {
    /// Upper bound on number of records to return.
    pub max_results: i32,
    /// A token used to resume pagination from the end of a previous request.
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListCellsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCellsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResourceSetInput {
    /// The ResourceSet to get
    pub resource_set_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetResourceSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResourceSetInput");
        formatter.field("resource_set_name", &self.resource_set_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRecoveryGroupReadinessSummaryInput {
    /// Upper bound on number of records to return.
    pub max_results: i32,
    /// A token used to resume pagination from the end of a previous request.
    pub next_token: std::option::Option<std::string::String>,
    /// The name of the RecoveryGroup
    pub recovery_group_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetRecoveryGroupReadinessSummaryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRecoveryGroupReadinessSummaryInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("recovery_group_name", &self.recovery_group_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRecoveryGroupInput {
    /// The RecoveryGroup to get
    pub recovery_group_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetRecoveryGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRecoveryGroupInput");
        formatter.field("recovery_group_name", &self.recovery_group_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetReadinessCheckStatusInput {
    /// Upper bound on number of records to return.
    pub max_results: i32,
    /// A token used to resume pagination from the end of a previous request.
    pub next_token: std::option::Option<std::string::String>,
    /// The ReadinessCheck to get
    pub readiness_check_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetReadinessCheckStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetReadinessCheckStatusInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("readiness_check_name", &self.readiness_check_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetReadinessCheckResourceStatusInput {
    /// Upper bound on number of records to return.
    pub max_results: i32,
    /// A token used to resume pagination from the end of a previous request.
    pub next_token: std::option::Option<std::string::String>,
    /// The ReadinessCheck to get
    pub readiness_check_name: std::option::Option<std::string::String>,
    /// The resource ARN or component Id to get
    pub resource_identifier: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetReadinessCheckResourceStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetReadinessCheckResourceStatusInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("readiness_check_name", &self.readiness_check_name);
        formatter.field("resource_identifier", &self.resource_identifier);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetReadinessCheckInput {
    /// The ReadinessCheck to get
    pub readiness_check_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetReadinessCheckInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetReadinessCheckInput");
        formatter.field("readiness_check_name", &self.readiness_check_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCellReadinessSummaryInput {
    /// The name of the Cell
    pub cell_name: std::option::Option<std::string::String>,
    /// Upper bound on number of records to return.
    pub max_results: i32,
    /// A token used to resume pagination from the end of a previous request.
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetCellReadinessSummaryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCellReadinessSummaryInput");
        formatter.field("cell_name", &self.cell_name);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCellInput {
    /// The Cell to get
    pub cell_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetCellInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCellInput");
        formatter.field("cell_name", &self.cell_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetArchitectureRecommendationsInput {
    /// Upper bound on number of records to return.
    pub max_results: i32,
    /// A token that can be used to resume pagination from the end of the collection.
    pub next_token: std::option::Option<std::string::String>,
    /// Name of RecoveryGroup (top level resource) to be analyzed.
    pub recovery_group_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetArchitectureRecommendationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetArchitectureRecommendationsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("recovery_group_name", &self.recovery_group_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteResourceSetInput {
    /// The ResourceSet to delete
    pub resource_set_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteResourceSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteResourceSetInput");
        formatter.field("resource_set_name", &self.resource_set_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRecoveryGroupInput {
    /// The RecoveryGroup to delete
    pub recovery_group_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteRecoveryGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRecoveryGroupInput");
        formatter.field("recovery_group_name", &self.recovery_group_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteReadinessCheckInput {
    /// The ReadinessCheck to delete
    pub readiness_check_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteReadinessCheckInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteReadinessCheckInput");
        formatter.field("readiness_check_name", &self.readiness_check_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCrossAccountAuthorizationInput {
    /// The cross account authorization
    pub cross_account_authorization: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteCrossAccountAuthorizationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCrossAccountAuthorizationInput");
        formatter.field(
            "cross_account_authorization",
            &self.cross_account_authorization,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCellInput {
    /// The Cell to delete
    pub cell_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteCellInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCellInput");
        formatter.field("cell_name", &self.cell_name);
        formatter.finish()
    }
}

/// The ResourceSet to create
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateResourceSetInput {
    /// The name of the ResourceSet to create
    pub resource_set_name: std::option::Option<std::string::String>,
    /// AWS Resource type of the resources in the ResourceSet
    pub resource_set_type: std::option::Option<std::string::String>,
    /// A list of Resource objects
    pub resources: std::option::Option<std::vec::Vec<crate::model::Resource>>,
    /// A collection of tags associated with a resource
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for CreateResourceSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateResourceSetInput");
        formatter.field("resource_set_name", &self.resource_set_name);
        formatter.field("resource_set_type", &self.resource_set_type);
        formatter.field("resources", &self.resources);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// The RecoveryGroup to create
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRecoveryGroupInput {
    /// A list of Cell arns
    pub cells: std::option::Option<std::vec::Vec<std::string::String>>,
    /// The name of the RecoveryGroup to create
    pub recovery_group_name: std::option::Option<std::string::String>,
    /// A collection of tags associated with a resource
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for CreateRecoveryGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRecoveryGroupInput");
        formatter.field("cells", &self.cells);
        formatter.field("recovery_group_name", &self.recovery_group_name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// The ReadinessCheck to create
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateReadinessCheckInput {
    /// The name of the ReadinessCheck to create
    pub readiness_check_name: std::option::Option<std::string::String>,
    /// The name of the ResourceSet to check
    pub resource_set_name: std::option::Option<std::string::String>,
    /// A collection of tags associated with a resource
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for CreateReadinessCheckInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateReadinessCheckInput");
        formatter.field("readiness_check_name", &self.readiness_check_name);
        formatter.field("resource_set_name", &self.resource_set_name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// The cross account authorization
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCrossAccountAuthorizationInput {
    /// The cross account authorization
    pub cross_account_authorization: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateCrossAccountAuthorizationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCrossAccountAuthorizationInput");
        formatter.field(
            "cross_account_authorization",
            &self.cross_account_authorization,
        );
        formatter.finish()
    }
}

/// The Cell to create
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCellInput {
    /// The name of the Cell to create
    pub cell_name: std::option::Option<std::string::String>,
    /// A list of Cell arns contained within this Cell (for use in nested Cells, e.g. regions within which AZs)
    pub cells: std::option::Option<std::vec::Vec<std::string::String>>,
    /// A collection of tags associated with a resource
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for CreateCellInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCellInput");
        formatter.field("cell_name", &self.cell_name);
        formatter.field("cells", &self.cells);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
