// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `Route53RecoveryReadiness`.
///
/// This client allows ergonomic access to a `Route53RecoveryReadiness`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateCell` operation.
    ///
    /// See [`CreateCell`](crate::client::fluent_builders::CreateCell) for more information about the
    /// operation and its arguments.
    pub fn create_cell(&self) -> fluent_builders::CreateCell<C, M, R> {
        fluent_builders::CreateCell::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateCrossAccountAuthorization` operation.
    ///
    /// See [`CreateCrossAccountAuthorization`](crate::client::fluent_builders::CreateCrossAccountAuthorization) for more information about the
    /// operation and its arguments.
    pub fn create_cross_account_authorization(
        &self,
    ) -> fluent_builders::CreateCrossAccountAuthorization<C, M, R> {
        fluent_builders::CreateCrossAccountAuthorization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateReadinessCheck` operation.
    ///
    /// See [`CreateReadinessCheck`](crate::client::fluent_builders::CreateReadinessCheck) for more information about the
    /// operation and its arguments.
    pub fn create_readiness_check(&self) -> fluent_builders::CreateReadinessCheck<C, M, R> {
        fluent_builders::CreateReadinessCheck::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRecoveryGroup` operation.
    ///
    /// See [`CreateRecoveryGroup`](crate::client::fluent_builders::CreateRecoveryGroup) for more information about the
    /// operation and its arguments.
    pub fn create_recovery_group(&self) -> fluent_builders::CreateRecoveryGroup<C, M, R> {
        fluent_builders::CreateRecoveryGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateResourceSet` operation.
    ///
    /// See [`CreateResourceSet`](crate::client::fluent_builders::CreateResourceSet) for more information about the
    /// operation and its arguments.
    pub fn create_resource_set(&self) -> fluent_builders::CreateResourceSet<C, M, R> {
        fluent_builders::CreateResourceSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteCell` operation.
    ///
    /// See [`DeleteCell`](crate::client::fluent_builders::DeleteCell) for more information about the
    /// operation and its arguments.
    pub fn delete_cell(&self) -> fluent_builders::DeleteCell<C, M, R> {
        fluent_builders::DeleteCell::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteCrossAccountAuthorization` operation.
    ///
    /// See [`DeleteCrossAccountAuthorization`](crate::client::fluent_builders::DeleteCrossAccountAuthorization) for more information about the
    /// operation and its arguments.
    pub fn delete_cross_account_authorization(
        &self,
    ) -> fluent_builders::DeleteCrossAccountAuthorization<C, M, R> {
        fluent_builders::DeleteCrossAccountAuthorization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteReadinessCheck` operation.
    ///
    /// See [`DeleteReadinessCheck`](crate::client::fluent_builders::DeleteReadinessCheck) for more information about the
    /// operation and its arguments.
    pub fn delete_readiness_check(&self) -> fluent_builders::DeleteReadinessCheck<C, M, R> {
        fluent_builders::DeleteReadinessCheck::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRecoveryGroup` operation.
    ///
    /// See [`DeleteRecoveryGroup`](crate::client::fluent_builders::DeleteRecoveryGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_recovery_group(&self) -> fluent_builders::DeleteRecoveryGroup<C, M, R> {
        fluent_builders::DeleteRecoveryGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteResourceSet` operation.
    ///
    /// See [`DeleteResourceSet`](crate::client::fluent_builders::DeleteResourceSet) for more information about the
    /// operation and its arguments.
    pub fn delete_resource_set(&self) -> fluent_builders::DeleteResourceSet<C, M, R> {
        fluent_builders::DeleteResourceSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetArchitectureRecommendations` operation.
    ///
    /// See [`GetArchitectureRecommendations`](crate::client::fluent_builders::GetArchitectureRecommendations) for more information about the
    /// operation and its arguments.
    pub fn get_architecture_recommendations(
        &self,
    ) -> fluent_builders::GetArchitectureRecommendations<C, M, R> {
        fluent_builders::GetArchitectureRecommendations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCell` operation.
    ///
    /// See [`GetCell`](crate::client::fluent_builders::GetCell) for more information about the
    /// operation and its arguments.
    pub fn get_cell(&self) -> fluent_builders::GetCell<C, M, R> {
        fluent_builders::GetCell::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCellReadinessSummary` operation.
    ///
    /// See [`GetCellReadinessSummary`](crate::client::fluent_builders::GetCellReadinessSummary) for more information about the
    /// operation and its arguments.
    pub fn get_cell_readiness_summary(&self) -> fluent_builders::GetCellReadinessSummary<C, M, R> {
        fluent_builders::GetCellReadinessSummary::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetReadinessCheck` operation.
    ///
    /// See [`GetReadinessCheck`](crate::client::fluent_builders::GetReadinessCheck) for more information about the
    /// operation and its arguments.
    pub fn get_readiness_check(&self) -> fluent_builders::GetReadinessCheck<C, M, R> {
        fluent_builders::GetReadinessCheck::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetReadinessCheckResourceStatus` operation.
    ///
    /// See [`GetReadinessCheckResourceStatus`](crate::client::fluent_builders::GetReadinessCheckResourceStatus) for more information about the
    /// operation and its arguments.
    pub fn get_readiness_check_resource_status(
        &self,
    ) -> fluent_builders::GetReadinessCheckResourceStatus<C, M, R> {
        fluent_builders::GetReadinessCheckResourceStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetReadinessCheckStatus` operation.
    ///
    /// See [`GetReadinessCheckStatus`](crate::client::fluent_builders::GetReadinessCheckStatus) for more information about the
    /// operation and its arguments.
    pub fn get_readiness_check_status(&self) -> fluent_builders::GetReadinessCheckStatus<C, M, R> {
        fluent_builders::GetReadinessCheckStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRecoveryGroup` operation.
    ///
    /// See [`GetRecoveryGroup`](crate::client::fluent_builders::GetRecoveryGroup) for more information about the
    /// operation and its arguments.
    pub fn get_recovery_group(&self) -> fluent_builders::GetRecoveryGroup<C, M, R> {
        fluent_builders::GetRecoveryGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRecoveryGroupReadinessSummary` operation.
    ///
    /// See [`GetRecoveryGroupReadinessSummary`](crate::client::fluent_builders::GetRecoveryGroupReadinessSummary) for more information about the
    /// operation and its arguments.
    pub fn get_recovery_group_readiness_summary(
        &self,
    ) -> fluent_builders::GetRecoveryGroupReadinessSummary<C, M, R> {
        fluent_builders::GetRecoveryGroupReadinessSummary::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetResourceSet` operation.
    ///
    /// See [`GetResourceSet`](crate::client::fluent_builders::GetResourceSet) for more information about the
    /// operation and its arguments.
    pub fn get_resource_set(&self) -> fluent_builders::GetResourceSet<C, M, R> {
        fluent_builders::GetResourceSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListCells` operation.
    ///
    /// See [`ListCells`](crate::client::fluent_builders::ListCells) for more information about the
    /// operation and its arguments.
    pub fn list_cells(&self) -> fluent_builders::ListCells<C, M, R> {
        fluent_builders::ListCells::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListCrossAccountAuthorizations` operation.
    ///
    /// See [`ListCrossAccountAuthorizations`](crate::client::fluent_builders::ListCrossAccountAuthorizations) for more information about the
    /// operation and its arguments.
    pub fn list_cross_account_authorizations(
        &self,
    ) -> fluent_builders::ListCrossAccountAuthorizations<C, M, R> {
        fluent_builders::ListCrossAccountAuthorizations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListReadinessChecks` operation.
    ///
    /// See [`ListReadinessChecks`](crate::client::fluent_builders::ListReadinessChecks) for more information about the
    /// operation and its arguments.
    pub fn list_readiness_checks(&self) -> fluent_builders::ListReadinessChecks<C, M, R> {
        fluent_builders::ListReadinessChecks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRecoveryGroups` operation.
    ///
    /// See [`ListRecoveryGroups`](crate::client::fluent_builders::ListRecoveryGroups) for more information about the
    /// operation and its arguments.
    pub fn list_recovery_groups(&self) -> fluent_builders::ListRecoveryGroups<C, M, R> {
        fluent_builders::ListRecoveryGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListResourceSets` operation.
    ///
    /// See [`ListResourceSets`](crate::client::fluent_builders::ListResourceSets) for more information about the
    /// operation and its arguments.
    pub fn list_resource_sets(&self) -> fluent_builders::ListResourceSets<C, M, R> {
        fluent_builders::ListResourceSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRules` operation.
    ///
    /// See [`ListRules`](crate::client::fluent_builders::ListRules) for more information about the
    /// operation and its arguments.
    pub fn list_rules(&self) -> fluent_builders::ListRules<C, M, R> {
        fluent_builders::ListRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResources` operation.
    ///
    /// See [`ListTagsForResources`](crate::client::fluent_builders::ListTagsForResources) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resources(&self) -> fluent_builders::ListTagsForResources<C, M, R> {
        fluent_builders::ListTagsForResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateCell` operation.
    ///
    /// See [`UpdateCell`](crate::client::fluent_builders::UpdateCell) for more information about the
    /// operation and its arguments.
    pub fn update_cell(&self) -> fluent_builders::UpdateCell<C, M, R> {
        fluent_builders::UpdateCell::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateReadinessCheck` operation.
    ///
    /// See [`UpdateReadinessCheck`](crate::client::fluent_builders::UpdateReadinessCheck) for more information about the
    /// operation and its arguments.
    pub fn update_readiness_check(&self) -> fluent_builders::UpdateReadinessCheck<C, M, R> {
        fluent_builders::UpdateReadinessCheck::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRecoveryGroup` operation.
    ///
    /// See [`UpdateRecoveryGroup`](crate::client::fluent_builders::UpdateRecoveryGroup) for more information about the
    /// operation and its arguments.
    pub fn update_recovery_group(&self) -> fluent_builders::UpdateRecoveryGroup<C, M, R> {
        fluent_builders::UpdateRecoveryGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateResourceSet` operation.
    ///
    /// See [`UpdateResourceSet`](crate::client::fluent_builders::UpdateResourceSet) for more information about the
    /// operation and its arguments.
    pub fn update_resource_set(&self) -> fluent_builders::UpdateResourceSet<C, M, R> {
        fluent_builders::UpdateResourceSet::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateCell`.
    ///
    /// Creates a new Cell.
    #[derive(std::fmt::Debug)]
    pub struct CreateCell<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_cell_input::Builder,
    }
    impl<C, M, R> CreateCell<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCell`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCellOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCellError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCellInputOperationOutputAlias,
                crate::output::CreateCellOutput,
                crate::error::CreateCellError,
                crate::input::CreateCellInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// The name of the Cell to create
        pub fn cell_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cell_name(inp);
            self
        }
        /// The name of the Cell to create
        pub fn set_cell_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cell_name(input);
            self
        }
        /// Appends an item to `Cells`.
        ///
        /// To override the contents of this collection use [`set_cells`](Self::set_cells).
        ///
        /// A list of Cell arns contained within this Cell (for use in nested Cells, e.g. regions within which AZs)
        pub fn cells(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cells(inp);
            self
        }
        /// A list of Cell arns contained within this Cell (for use in nested Cells, e.g. regions within which AZs)
        pub fn set_cells(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_cells(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCrossAccountAuthorization`.
    ///
    /// Create a new cross account readiness authorization.
    #[derive(std::fmt::Debug)]
    pub struct CreateCrossAccountAuthorization<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_cross_account_authorization_input::Builder,
    }
    impl<C, M, R> CreateCrossAccountAuthorization<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCrossAccountAuthorization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCrossAccountAuthorizationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCrossAccountAuthorizationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCrossAccountAuthorizationInputOperationOutputAlias,
                crate::output::CreateCrossAccountAuthorizationOutput,
                crate::error::CreateCrossAccountAuthorizationError,
                crate::input::CreateCrossAccountAuthorizationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// The cross account authorization
        pub fn cross_account_authorization(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cross_account_authorization(inp);
            self
        }
        /// The cross account authorization
        pub fn set_cross_account_authorization(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cross_account_authorization(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateReadinessCheck`.
    ///
    /// Creates a new Readiness Check.
    #[derive(std::fmt::Debug)]
    pub struct CreateReadinessCheck<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_readiness_check_input::Builder,
    }
    impl<C, M, R> CreateReadinessCheck<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateReadinessCheck`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateReadinessCheckOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateReadinessCheckError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateReadinessCheckInputOperationOutputAlias,
                crate::output::CreateReadinessCheckOutput,
                crate::error::CreateReadinessCheckError,
                crate::input::CreateReadinessCheckInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// The name of the ReadinessCheck to create
        pub fn readiness_check_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.readiness_check_name(inp);
            self
        }
        /// The name of the ReadinessCheck to create
        pub fn set_readiness_check_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_readiness_check_name(input);
            self
        }
        /// The name of the ResourceSet to check
        pub fn resource_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_set_name(inp);
            self
        }
        /// The name of the ResourceSet to check
        pub fn set_resource_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_set_name(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRecoveryGroup`.
    ///
    /// Creates a new Recovery Group.
    #[derive(std::fmt::Debug)]
    pub struct CreateRecoveryGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_recovery_group_input::Builder,
    }
    impl<C, M, R> CreateRecoveryGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRecoveryGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRecoveryGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRecoveryGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRecoveryGroupInputOperationOutputAlias,
                crate::output::CreateRecoveryGroupOutput,
                crate::error::CreateRecoveryGroupError,
                crate::input::CreateRecoveryGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Cells`.
        ///
        /// To override the contents of this collection use [`set_cells`](Self::set_cells).
        ///
        /// A list of Cell arns
        pub fn cells(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cells(inp);
            self
        }
        /// A list of Cell arns
        pub fn set_cells(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_cells(input);
            self
        }
        /// The name of the RecoveryGroup to create
        pub fn recovery_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recovery_group_name(inp);
            self
        }
        /// The name of the RecoveryGroup to create
        pub fn set_recovery_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recovery_group_name(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateResourceSet`.
    ///
    /// Creates a new Resource Set.
    #[derive(std::fmt::Debug)]
    pub struct CreateResourceSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_resource_set_input::Builder,
    }
    impl<C, M, R> CreateResourceSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateResourceSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateResourceSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateResourceSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateResourceSetInputOperationOutputAlias,
                crate::output::CreateResourceSetOutput,
                crate::error::CreateResourceSetError,
                crate::input::CreateResourceSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// The name of the ResourceSet to create
        pub fn resource_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_set_name(inp);
            self
        }
        /// The name of the ResourceSet to create
        pub fn set_resource_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_set_name(input);
            self
        }
        /// AWS Resource type of the resources in the ResourceSet
        pub fn resource_set_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_set_type(inp);
            self
        }
        /// AWS Resource type of the resources in the ResourceSet
        pub fn set_resource_set_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_set_type(input);
            self
        }
        /// Appends an item to `Resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// A list of Resource objects
        pub fn resources(mut self, inp: impl Into<crate::model::Resource>) -> Self {
            self.inner = self.inner.resources(inp);
            self
        }
        /// A list of Resource objects
        pub fn set_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        ) -> Self {
            self.inner = self.inner.set_resources(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCell`.
    ///
    /// Deletes an existing Cell.
    #[derive(std::fmt::Debug)]
    pub struct DeleteCell<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_cell_input::Builder,
    }
    impl<C, M, R> DeleteCell<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCell`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCellOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCellError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteCellInputOperationOutputAlias,
                crate::output::DeleteCellOutput,
                crate::error::DeleteCellError,
                crate::input::DeleteCellInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// The Cell to delete
        pub fn cell_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cell_name(inp);
            self
        }
        /// The Cell to delete
        pub fn set_cell_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cell_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCrossAccountAuthorization`.
    ///
    /// Delete cross account readiness authorization
    #[derive(std::fmt::Debug)]
    pub struct DeleteCrossAccountAuthorization<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_cross_account_authorization_input::Builder,
    }
    impl<C, M, R> DeleteCrossAccountAuthorization<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCrossAccountAuthorization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCrossAccountAuthorizationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCrossAccountAuthorizationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteCrossAccountAuthorizationInputOperationOutputAlias,
                crate::output::DeleteCrossAccountAuthorizationOutput,
                crate::error::DeleteCrossAccountAuthorizationError,
                crate::input::DeleteCrossAccountAuthorizationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// The cross account authorization
        pub fn cross_account_authorization(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cross_account_authorization(inp);
            self
        }
        /// The cross account authorization
        pub fn set_cross_account_authorization(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cross_account_authorization(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteReadinessCheck`.
    ///
    /// Deletes an existing Readiness Check.
    #[derive(std::fmt::Debug)]
    pub struct DeleteReadinessCheck<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_readiness_check_input::Builder,
    }
    impl<C, M, R> DeleteReadinessCheck<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteReadinessCheck`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteReadinessCheckOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteReadinessCheckError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteReadinessCheckInputOperationOutputAlias,
                crate::output::DeleteReadinessCheckOutput,
                crate::error::DeleteReadinessCheckError,
                crate::input::DeleteReadinessCheckInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// The ReadinessCheck to delete
        pub fn readiness_check_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.readiness_check_name(inp);
            self
        }
        /// The ReadinessCheck to delete
        pub fn set_readiness_check_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_readiness_check_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRecoveryGroup`.
    ///
    /// Deletes an existing Recovery Group.
    #[derive(std::fmt::Debug)]
    pub struct DeleteRecoveryGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_recovery_group_input::Builder,
    }
    impl<C, M, R> DeleteRecoveryGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRecoveryGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRecoveryGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRecoveryGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRecoveryGroupInputOperationOutputAlias,
                crate::output::DeleteRecoveryGroupOutput,
                crate::error::DeleteRecoveryGroupError,
                crate::input::DeleteRecoveryGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// The RecoveryGroup to delete
        pub fn recovery_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recovery_group_name(inp);
            self
        }
        /// The RecoveryGroup to delete
        pub fn set_recovery_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recovery_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResourceSet`.
    ///
    /// Deletes an existing Resource Set.
    #[derive(std::fmt::Debug)]
    pub struct DeleteResourceSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_resource_set_input::Builder,
    }
    impl<C, M, R> DeleteResourceSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteResourceSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResourceSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResourceSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteResourceSetInputOperationOutputAlias,
                crate::output::DeleteResourceSetOutput,
                crate::error::DeleteResourceSetError,
                crate::input::DeleteResourceSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// The ResourceSet to delete
        pub fn resource_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_set_name(inp);
            self
        }
        /// The ResourceSet to delete
        pub fn set_resource_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetArchitectureRecommendations`.
    ///
    /// Returns a collection of recommendations to improve resilliance and readiness check quality for a Recovery Group.
    #[derive(std::fmt::Debug)]
    pub struct GetArchitectureRecommendations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_architecture_recommendations_input::Builder,
    }
    impl<C, M, R> GetArchitectureRecommendations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetArchitectureRecommendations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetArchitectureRecommendationsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetArchitectureRecommendationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetArchitectureRecommendationsInputOperationOutputAlias,
                crate::output::GetArchitectureRecommendationsOutput,
                crate::error::GetArchitectureRecommendationsError,
                crate::input::GetArchitectureRecommendationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Upper bound on number of records to return.
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// Upper bound on number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// A token that can be used to resume pagination from the end of the collection.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// A token that can be used to resume pagination from the end of the collection.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Name of RecoveryGroup (top level resource) to be analyzed.
        pub fn recovery_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recovery_group_name(inp);
            self
        }
        /// Name of RecoveryGroup (top level resource) to be analyzed.
        pub fn set_recovery_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recovery_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCell`.
    ///
    /// Returns information about a Cell.
    #[derive(std::fmt::Debug)]
    pub struct GetCell<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_cell_input::Builder,
    }
    impl<C, M, R> GetCell<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCell`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCellOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCellError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCellInputOperationOutputAlias,
                crate::output::GetCellOutput,
                crate::error::GetCellError,
                crate::input::GetCellInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// The Cell to get
        pub fn cell_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cell_name(inp);
            self
        }
        /// The Cell to get
        pub fn set_cell_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cell_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCellReadinessSummary`.
    ///
    /// Returns information about readiness of a Cell.
    #[derive(std::fmt::Debug)]
    pub struct GetCellReadinessSummary<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_cell_readiness_summary_input::Builder,
    }
    impl<C, M, R> GetCellReadinessSummary<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCellReadinessSummary`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCellReadinessSummaryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCellReadinessSummaryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCellReadinessSummaryInputOperationOutputAlias,
                crate::output::GetCellReadinessSummaryOutput,
                crate::error::GetCellReadinessSummaryError,
                crate::input::GetCellReadinessSummaryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// The name of the Cell
        pub fn cell_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cell_name(inp);
            self
        }
        /// The name of the Cell
        pub fn set_cell_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cell_name(input);
            self
        }
        /// Upper bound on number of records to return.
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// Upper bound on number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetReadinessCheck`.
    ///
    /// Returns information about a ReadinessCheck.
    #[derive(std::fmt::Debug)]
    pub struct GetReadinessCheck<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_readiness_check_input::Builder,
    }
    impl<C, M, R> GetReadinessCheck<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetReadinessCheck`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetReadinessCheckOutput,
            aws_smithy_http::result::SdkError<crate::error::GetReadinessCheckError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetReadinessCheckInputOperationOutputAlias,
                crate::output::GetReadinessCheckOutput,
                crate::error::GetReadinessCheckError,
                crate::input::GetReadinessCheckInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// The ReadinessCheck to get
        pub fn readiness_check_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.readiness_check_name(inp);
            self
        }
        /// The ReadinessCheck to get
        pub fn set_readiness_check_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_readiness_check_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetReadinessCheckResourceStatus`.
    ///
    /// Returns detailed information about the status of an individual resource within a Readiness Check's Resource Set.
    #[derive(std::fmt::Debug)]
    pub struct GetReadinessCheckResourceStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_readiness_check_resource_status_input::Builder,
    }
    impl<C, M, R> GetReadinessCheckResourceStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetReadinessCheckResourceStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetReadinessCheckResourceStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetReadinessCheckResourceStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetReadinessCheckResourceStatusInputOperationOutputAlias,
                crate::output::GetReadinessCheckResourceStatusOutput,
                crate::error::GetReadinessCheckResourceStatusError,
                crate::input::GetReadinessCheckResourceStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Upper bound on number of records to return.
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// Upper bound on number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// The ReadinessCheck to get
        pub fn readiness_check_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.readiness_check_name(inp);
            self
        }
        /// The ReadinessCheck to get
        pub fn set_readiness_check_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_readiness_check_name(input);
            self
        }
        /// The resource ARN or component Id to get
        pub fn resource_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_identifier(inp);
            self
        }
        /// The resource ARN or component Id to get
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetReadinessCheckStatus`.
    ///
    /// Returns information about the status of a Readiness Check.
    #[derive(std::fmt::Debug)]
    pub struct GetReadinessCheckStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_readiness_check_status_input::Builder,
    }
    impl<C, M, R> GetReadinessCheckStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetReadinessCheckStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetReadinessCheckStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetReadinessCheckStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetReadinessCheckStatusInputOperationOutputAlias,
                crate::output::GetReadinessCheckStatusOutput,
                crate::error::GetReadinessCheckStatusError,
                crate::input::GetReadinessCheckStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Upper bound on number of records to return.
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// Upper bound on number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// The ReadinessCheck to get
        pub fn readiness_check_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.readiness_check_name(inp);
            self
        }
        /// The ReadinessCheck to get
        pub fn set_readiness_check_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_readiness_check_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRecoveryGroup`.
    ///
    /// Returns information about a Recovery Group.
    #[derive(std::fmt::Debug)]
    pub struct GetRecoveryGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_recovery_group_input::Builder,
    }
    impl<C, M, R> GetRecoveryGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRecoveryGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRecoveryGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRecoveryGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRecoveryGroupInputOperationOutputAlias,
                crate::output::GetRecoveryGroupOutput,
                crate::error::GetRecoveryGroupError,
                crate::input::GetRecoveryGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// The RecoveryGroup to get
        pub fn recovery_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recovery_group_name(inp);
            self
        }
        /// The RecoveryGroup to get
        pub fn set_recovery_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recovery_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRecoveryGroupReadinessSummary`.
    ///
    /// Returns information about a Recovery Group.
    #[derive(std::fmt::Debug)]
    pub struct GetRecoveryGroupReadinessSummary<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_recovery_group_readiness_summary_input::Builder,
    }
    impl<C, M, R> GetRecoveryGroupReadinessSummary<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRecoveryGroupReadinessSummary`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRecoveryGroupReadinessSummaryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRecoveryGroupReadinessSummaryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRecoveryGroupReadinessSummaryInputOperationOutputAlias,
                crate::output::GetRecoveryGroupReadinessSummaryOutput,
                crate::error::GetRecoveryGroupReadinessSummaryError,
                crate::input::GetRecoveryGroupReadinessSummaryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Upper bound on number of records to return.
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// Upper bound on number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// The name of the RecoveryGroup
        pub fn recovery_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recovery_group_name(inp);
            self
        }
        /// The name of the RecoveryGroup
        pub fn set_recovery_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recovery_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResourceSet`.
    ///
    /// Returns information about a Resource Set.
    #[derive(std::fmt::Debug)]
    pub struct GetResourceSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_resource_set_input::Builder,
    }
    impl<C, M, R> GetResourceSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetResourceSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResourceSetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResourceSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetResourceSetInputOperationOutputAlias,
                crate::output::GetResourceSetOutput,
                crate::error::GetResourceSetError,
                crate::input::GetResourceSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// The ResourceSet to get
        pub fn resource_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_set_name(inp);
            self
        }
        /// The ResourceSet to get
        pub fn set_resource_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCells`.
    ///
    /// Returns a collection of Cells.
    #[derive(std::fmt::Debug)]
    pub struct ListCells<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_cells_input::Builder,
    }
    impl<C, M, R> ListCells<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCells`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCellsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCellsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCellsInputOperationOutputAlias,
                crate::output::ListCellsOutput,
                crate::error::ListCellsError,
                crate::input::ListCellsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Upper bound on number of records to return.
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// Upper bound on number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCrossAccountAuthorizations`.
    ///
    /// Returns a collection of cross account readiness authorizations.
    #[derive(std::fmt::Debug)]
    pub struct ListCrossAccountAuthorizations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_cross_account_authorizations_input::Builder,
    }
    impl<C, M, R> ListCrossAccountAuthorizations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCrossAccountAuthorizations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCrossAccountAuthorizationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCrossAccountAuthorizationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCrossAccountAuthorizationsInputOperationOutputAlias,
                crate::output::ListCrossAccountAuthorizationsOutput,
                crate::error::ListCrossAccountAuthorizationsError,
                crate::input::ListCrossAccountAuthorizationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Upper bound on number of records to return.
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// Upper bound on number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListReadinessChecks`.
    ///
    /// Returns a collection of Readiness Checks.
    #[derive(std::fmt::Debug)]
    pub struct ListReadinessChecks<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_readiness_checks_input::Builder,
    }
    impl<C, M, R> ListReadinessChecks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListReadinessChecks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListReadinessChecksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListReadinessChecksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListReadinessChecksInputOperationOutputAlias,
                crate::output::ListReadinessChecksOutput,
                crate::error::ListReadinessChecksError,
                crate::input::ListReadinessChecksInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Upper bound on number of records to return.
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// Upper bound on number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRecoveryGroups`.
    ///
    /// Returns a collection of Recovery Groups.
    #[derive(std::fmt::Debug)]
    pub struct ListRecoveryGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_recovery_groups_input::Builder,
    }
    impl<C, M, R> ListRecoveryGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRecoveryGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRecoveryGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRecoveryGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRecoveryGroupsInputOperationOutputAlias,
                crate::output::ListRecoveryGroupsOutput,
                crate::error::ListRecoveryGroupsError,
                crate::input::ListRecoveryGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Upper bound on number of records to return.
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// Upper bound on number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResourceSets`.
    ///
    /// Returns a collection of Resource Sets.
    #[derive(std::fmt::Debug)]
    pub struct ListResourceSets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_resource_sets_input::Builder,
    }
    impl<C, M, R> ListResourceSets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListResourceSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResourceSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResourceSetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListResourceSetsInputOperationOutputAlias,
                crate::output::ListResourceSetsOutput,
                crate::error::ListResourceSetsError,
                crate::input::ListResourceSetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Upper bound on number of records to return.
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// Upper bound on number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRules`.
    ///
    /// Returns a collection of rules that are applied as part of Readiness Checks.
    #[derive(std::fmt::Debug)]
    pub struct ListRules<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_rules_input::Builder,
    }
    impl<C, M, R> ListRules<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRulesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRulesInputOperationOutputAlias,
                crate::output::ListRulesOutput,
                crate::error::ListRulesError,
                crate::input::ListRulesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Upper bound on number of records to return.
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// Upper bound on number of records to return.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// A token used to resume pagination from the end of a previous request.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Filter parameter which specifies the rules to return given a resource type.
        pub fn resource_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_type(inp);
            self
        }
        /// Filter parameter which specifies the rules to return given a resource type.
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResources`.
    ///
    /// Returns a list of the tags assigned to the specified resource.
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResources<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resources_input::Builder,
    }
    impl<C, M, R> ListTagsForResources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourcesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourcesInputOperationOutputAlias,
                crate::output::ListTagsForResourcesOutput,
                crate::error::ListTagsForResourcesError,
                crate::input::ListTagsForResourcesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// Adds tags to the specified resource. You can specify one or more tags to add.
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of tags associated with a resource
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// A collection of tags associated with a resource
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// Removes tags from the specified resource. You can specify one or more tags to remove.
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// A comma-separated list of the tag keys to remove from the resource.
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// A comma-separated list of the tag keys to remove from the resource.
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateCell`.
    ///
    /// Updates an existing Cell.
    #[derive(std::fmt::Debug)]
    pub struct UpdateCell<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_cell_input::Builder,
    }
    impl<C, M, R> UpdateCell<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateCell`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateCellOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateCellError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateCellInputOperationOutputAlias,
                crate::output::UpdateCellOutput,
                crate::error::UpdateCellError,
                crate::input::UpdateCellInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// The Cell to update
        pub fn cell_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cell_name(inp);
            self
        }
        /// The Cell to update
        pub fn set_cell_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cell_name(input);
            self
        }
        /// Appends an item to `Cells`.
        ///
        /// To override the contents of this collection use [`set_cells`](Self::set_cells).
        ///
        /// A list of Cell arns, completely replaces previous list
        pub fn cells(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cells(inp);
            self
        }
        /// A list of Cell arns, completely replaces previous list
        pub fn set_cells(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_cells(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateReadinessCheck`.
    ///
    /// Updates an exisiting Readiness Check.
    #[derive(std::fmt::Debug)]
    pub struct UpdateReadinessCheck<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_readiness_check_input::Builder,
    }
    impl<C, M, R> UpdateReadinessCheck<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateReadinessCheck`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateReadinessCheckOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateReadinessCheckError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateReadinessCheckInputOperationOutputAlias,
                crate::output::UpdateReadinessCheckOutput,
                crate::error::UpdateReadinessCheckError,
                crate::input::UpdateReadinessCheckInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// The ReadinessCheck to update
        pub fn readiness_check_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.readiness_check_name(inp);
            self
        }
        /// The ReadinessCheck to update
        pub fn set_readiness_check_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_readiness_check_name(input);
            self
        }
        /// The name of the ResourceSet to check
        pub fn resource_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_set_name(inp);
            self
        }
        /// The name of the ResourceSet to check
        pub fn set_resource_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRecoveryGroup`.
    ///
    /// Updates an existing Recovery Group.
    #[derive(std::fmt::Debug)]
    pub struct UpdateRecoveryGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_recovery_group_input::Builder,
    }
    impl<C, M, R> UpdateRecoveryGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRecoveryGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRecoveryGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRecoveryGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRecoveryGroupInputOperationOutputAlias,
                crate::output::UpdateRecoveryGroupOutput,
                crate::error::UpdateRecoveryGroupError,
                crate::input::UpdateRecoveryGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Cells`.
        ///
        /// To override the contents of this collection use [`set_cells`](Self::set_cells).
        ///
        /// A list of Cell arns, completely replaces previous list
        pub fn cells(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cells(inp);
            self
        }
        /// A list of Cell arns, completely replaces previous list
        pub fn set_cells(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_cells(input);
            self
        }
        /// The RecoveryGroup to update
        pub fn recovery_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recovery_group_name(inp);
            self
        }
        /// The RecoveryGroup to update
        pub fn set_recovery_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recovery_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateResourceSet`.
    ///
    /// Updates an existing Resource Set.
    #[derive(std::fmt::Debug)]
    pub struct UpdateResourceSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_resource_set_input::Builder,
    }
    impl<C, M, R> UpdateResourceSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateResourceSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateResourceSetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateResourceSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateResourceSetInputOperationOutputAlias,
                crate::output::UpdateResourceSetOutput,
                crate::error::UpdateResourceSetError,
                crate::input::UpdateResourceSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// The ResourceSet to update
        pub fn resource_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_set_name(inp);
            self
        }
        /// The ResourceSet to update
        pub fn set_resource_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_set_name(input);
            self
        }
        /// AWS Resource Type of the resources in the ResourceSet
        pub fn resource_set_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_set_type(inp);
            self
        }
        /// AWS Resource Type of the resources in the ResourceSet
        pub fn set_resource_set_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_set_type(input);
            self
        }
        /// Appends an item to `Resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// A list of Resource objects
        pub fn resources(mut self, inp: impl Into<crate::model::Resource>) -> Self {
            self.inner = self.inner.resources(inp);
            self
        }
        /// A list of Resource objects
        pub fn set_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        ) -> Self {
            self.inner = self.inner.set_resources(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
