// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateClusterError {
    /// Kind of error that occurred.
    pub kind: CreateClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateClusterErrorKind {
    /// <p>403 response - You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>409 response - ConflictException. You might be using a predefined variable.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>500 response - InternalServiceError. Temporary service error. Retry the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>404 response - MalformedQueryString. The query string contains a syntax error or resource not found..</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>402 response - You attempted to create more resources than the service allows based on service quotas.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>429 response - LimitExceededException or TooManyRequestsException.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>400 response - Multiple causes. For example, you might have a malformed query string and input parameter might be out of range, or you might have used parameters together incorrectly.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateClusterErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateClusterError {
    fn code(&self) -> Option<&str> {
        CreateClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateClusterError {
    /// Creates a new `CreateClusterError`.
    pub fn new(kind: CreateClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateClusterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateClusterErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateClusterErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateClusterErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateClusterErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateClusterErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateClusterErrorKind::ConflictException(_inner) => Some(_inner),
            CreateClusterErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateClusterErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateClusterErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateClusterErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateClusterErrorKind::ValidationException(_inner) => Some(_inner),
            CreateClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateControlPanel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateControlPanelError {
    /// Kind of error that occurred.
    pub kind: CreateControlPanelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateControlPanel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateControlPanelErrorKind {
    /// <p>403 response - You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>409 response - ConflictException. You might be using a predefined variable.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>500 response - InternalServiceError. Temporary service error. Retry the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>404 response - MalformedQueryString. The query string contains a syntax error or resource not found..</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>402 response - You attempted to create more resources than the service allows based on service quotas.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>429 response - LimitExceededException or TooManyRequestsException.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>400 response - Multiple causes. For example, you might have a malformed query string and input parameter might be out of range, or you might have used parameters together incorrectly.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateControlPanelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateControlPanelErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateControlPanelErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateControlPanelErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateControlPanelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateControlPanelErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateControlPanelErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateControlPanelErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateControlPanelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateControlPanelError {
    fn code(&self) -> Option<&str> {
        CreateControlPanelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateControlPanelError {
    /// Creates a new `CreateControlPanelError`.
    pub fn new(kind: CreateControlPanelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateControlPanelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateControlPanelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateControlPanelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateControlPanelErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateControlPanelErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateControlPanelErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateControlPanelErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateControlPanelErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateControlPanelErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateControlPanelErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateControlPanelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateControlPanelErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateControlPanelErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateControlPanelErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateControlPanelErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateControlPanelErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateControlPanelErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateControlPanelErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateControlPanelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateControlPanelErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateControlPanelErrorKind::ConflictException(_inner) => Some(_inner),
            CreateControlPanelErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateControlPanelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateControlPanelErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateControlPanelErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateControlPanelErrorKind::ValidationException(_inner) => Some(_inner),
            CreateControlPanelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateRoutingControl` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateRoutingControlError {
    /// Kind of error that occurred.
    pub kind: CreateRoutingControlErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateRoutingControl` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateRoutingControlErrorKind {
    /// <p>403 response - You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>409 response - ConflictException. You might be using a predefined variable.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>500 response - InternalServiceError. Temporary service error. Retry the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>404 response - MalformedQueryString. The query string contains a syntax error or resource not found..</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>402 response - You attempted to create more resources than the service allows based on service quotas.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>429 response - LimitExceededException or TooManyRequestsException.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>400 response - Multiple causes. For example, you might have a malformed query string and input parameter might be out of range, or you might have used parameters together incorrectly.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateRoutingControlError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateRoutingControlErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateRoutingControlErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateRoutingControlErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateRoutingControlErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateRoutingControlErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateRoutingControlErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateRoutingControlErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateRoutingControlErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateRoutingControlError {
    fn code(&self) -> Option<&str> {
        CreateRoutingControlError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateRoutingControlError {
    /// Creates a new `CreateRoutingControlError`.
    pub fn new(kind: CreateRoutingControlErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateRoutingControlError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateRoutingControlErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateRoutingControlError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateRoutingControlErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateRoutingControlErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRoutingControlErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRoutingControlErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRoutingControlErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRoutingControlErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRoutingControlErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRoutingControlErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRoutingControlErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRoutingControlErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRoutingControlErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRoutingControlErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRoutingControlErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRoutingControlErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRoutingControlErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateRoutingControlError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateRoutingControlErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateRoutingControlErrorKind::ConflictException(_inner) => Some(_inner),
            CreateRoutingControlErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateRoutingControlErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateRoutingControlErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateRoutingControlErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateRoutingControlErrorKind::ValidationException(_inner) => Some(_inner),
            CreateRoutingControlErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateSafetyRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSafetyRuleError {
    /// Kind of error that occurred.
    pub kind: CreateSafetyRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSafetyRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSafetyRuleErrorKind {
    /// <p>500 response - InternalServiceError. Temporary service error. Retry the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>400 response - Multiple causes. For example, you might have a malformed query string and input parameter might be out of range, or you might have used parameters together incorrectly.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSafetyRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSafetyRuleErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateSafetyRuleErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateSafetyRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSafetyRuleError {
    fn code(&self) -> Option<&str> {
        CreateSafetyRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSafetyRuleError {
    /// Creates a new `CreateSafetyRuleError`.
    pub fn new(kind: CreateSafetyRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSafetyRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSafetyRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSafetyRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSafetyRuleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateSafetyRuleErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSafetyRuleErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSafetyRuleErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSafetyRuleErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateSafetyRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSafetyRuleErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateSafetyRuleErrorKind::ValidationException(_inner) => Some(_inner),
            CreateSafetyRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteClusterError {
    /// Kind of error that occurred.
    pub kind: DeleteClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteClusterErrorKind {
    /// <p>403 response - You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>409 response - ConflictException. You might be using a predefined variable.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>500 response - InternalServiceError. Temporary service error. Retry the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>404 response - MalformedQueryString. The query string contains a syntax error or resource not found..</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>429 response - LimitExceededException or TooManyRequestsException.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>400 response - Multiple causes. For example, you might have a malformed query string and input parameter might be out of range, or you might have used parameters together incorrectly.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteClusterErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteClusterErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteClusterErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteClusterErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteClusterErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteClusterErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteClusterError {
    fn code(&self) -> Option<&str> {
        DeleteClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteClusterError {
    /// Creates a new `DeleteClusterError`.
    pub fn new(kind: DeleteClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteClusterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteClusterErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteClusterErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteClusterErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteClusterErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteClusterErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClusterErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteClusterErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClusterErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteClusterErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteClusterErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteClusterErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteClusterErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteClusterErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteClusterErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteClusterErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteClusterErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteClusterErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteClusterErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteControlPanel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteControlPanelError {
    /// Kind of error that occurred.
    pub kind: DeleteControlPanelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteControlPanel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteControlPanelErrorKind {
    /// <p>403 response - You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>409 response - ConflictException. You might be using a predefined variable.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>500 response - InternalServiceError. Temporary service error. Retry the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>404 response - MalformedQueryString. The query string contains a syntax error or resource not found..</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>429 response - LimitExceededException or TooManyRequestsException.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>400 response - Multiple causes. For example, you might have a malformed query string and input parameter might be out of range, or you might have used parameters together incorrectly.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteControlPanelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteControlPanelErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteControlPanelErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteControlPanelErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteControlPanelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteControlPanelErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteControlPanelErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteControlPanelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteControlPanelError {
    fn code(&self) -> Option<&str> {
        DeleteControlPanelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteControlPanelError {
    /// Creates a new `DeleteControlPanelError`.
    pub fn new(kind: DeleteControlPanelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteControlPanelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteControlPanelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteControlPanelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteControlPanelErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteControlPanelErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteControlPanelErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteControlPanelErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteControlPanelErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteControlPanelErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteControlPanelErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteControlPanelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteControlPanelErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteControlPanelErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteControlPanelErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteControlPanelErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteControlPanelErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteControlPanelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteControlPanelErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteControlPanelErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteControlPanelErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteControlPanelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteControlPanelErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteControlPanelErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteControlPanelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRoutingControl` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRoutingControlError {
    /// Kind of error that occurred.
    pub kind: DeleteRoutingControlErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRoutingControl` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRoutingControlErrorKind {
    /// <p>403 response - You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>409 response - ConflictException. You might be using a predefined variable.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>500 response - InternalServiceError. Temporary service error. Retry the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>404 response - MalformedQueryString. The query string contains a syntax error or resource not found..</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>429 response - LimitExceededException or TooManyRequestsException.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>400 response - Multiple causes. For example, you might have a malformed query string and input parameter might be out of range, or you might have used parameters together incorrectly.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRoutingControlError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRoutingControlErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteRoutingControlErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteRoutingControlErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteRoutingControlErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteRoutingControlErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteRoutingControlErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteRoutingControlErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRoutingControlError {
    fn code(&self) -> Option<&str> {
        DeleteRoutingControlError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRoutingControlError {
    /// Creates a new `DeleteRoutingControlError`.
    pub fn new(kind: DeleteRoutingControlErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRoutingControlError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRoutingControlErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRoutingControlError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRoutingControlErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRoutingControlErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRoutingControlErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRoutingControlErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRoutingControlErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRoutingControlErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRoutingControlErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRoutingControlErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRoutingControlErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRoutingControlErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRoutingControlErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRoutingControlErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRoutingControlErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteRoutingControlError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRoutingControlErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteRoutingControlErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteRoutingControlErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteRoutingControlErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteRoutingControlErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteRoutingControlErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteRoutingControlErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSafetyRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSafetyRuleError {
    /// Kind of error that occurred.
    pub kind: DeleteSafetyRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSafetyRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSafetyRuleErrorKind {
    /// <p>500 response - InternalServiceError. Temporary service error. Retry the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>404 response - MalformedQueryString. The query string contains a syntax error or resource not found..</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>400 response - Multiple causes. For example, you might have a malformed query string and input parameter might be out of range, or you might have used parameters together incorrectly.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSafetyRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSafetyRuleErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteSafetyRuleErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteSafetyRuleErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteSafetyRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSafetyRuleError {
    fn code(&self) -> Option<&str> {
        DeleteSafetyRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSafetyRuleError {
    /// Creates a new `DeleteSafetyRuleError`.
    pub fn new(kind: DeleteSafetyRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSafetyRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSafetyRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSafetyRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSafetyRuleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteSafetyRuleErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSafetyRuleErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSafetyRuleErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSafetyRuleErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSafetyRuleErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSafetyRuleErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteSafetyRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSafetyRuleErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteSafetyRuleErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteSafetyRuleErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteSafetyRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeClusterError {
    /// Kind of error that occurred.
    pub kind: DescribeClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeClusterErrorKind {
    /// <p>403 response - You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>409 response - ConflictException. You might be using a predefined variable.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>500 response - InternalServiceError. Temporary service error. Retry the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>404 response - MalformedQueryString. The query string contains a syntax error or resource not found..</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>429 response - LimitExceededException or TooManyRequestsException.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>400 response - Multiple causes. For example, you might have a malformed query string and input parameter might be out of range, or you might have used parameters together incorrectly.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeClusterErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeClusterErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DescribeClusterErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeClusterErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeClusterErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeClusterErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeClusterError {
    fn code(&self) -> Option<&str> {
        DescribeClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeClusterError {
    /// Creates a new `DescribeClusterError`.
    pub fn new(kind: DescribeClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeClusterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeClusterErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClusterErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeClusterErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DescribeClusterErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DescribeClusterErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClusterErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeClusterErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClusterErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeClusterErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DescribeClusterErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DescribeClusterErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DescribeClusterErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DescribeClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeClusterErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeClusterErrorKind::ConflictException(_inner) => Some(_inner),
            DescribeClusterErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeClusterErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeClusterErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeClusterErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeControlPanel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeControlPanelError {
    /// Kind of error that occurred.
    pub kind: DescribeControlPanelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeControlPanel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeControlPanelErrorKind {
    /// <p>403 response - You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>409 response - ConflictException. You might be using a predefined variable.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>500 response - InternalServiceError. Temporary service error. Retry the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>404 response - MalformedQueryString. The query string contains a syntax error or resource not found..</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>429 response - LimitExceededException or TooManyRequestsException.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>400 response - Multiple causes. For example, you might have a malformed query string and input parameter might be out of range, or you might have used parameters together incorrectly.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeControlPanelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeControlPanelErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeControlPanelErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DescribeControlPanelErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeControlPanelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeControlPanelErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeControlPanelErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeControlPanelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeControlPanelError {
    fn code(&self) -> Option<&str> {
        DescribeControlPanelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeControlPanelError {
    /// Creates a new `DescribeControlPanelError`.
    pub fn new(kind: DescribeControlPanelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeControlPanelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeControlPanelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeControlPanelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeControlPanelErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeControlPanelErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeControlPanelErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeControlPanelErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeControlPanelErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeControlPanelErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeControlPanelErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeControlPanelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeControlPanelErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeControlPanelErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeControlPanelErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeControlPanelErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeControlPanelErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeControlPanelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeControlPanelErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeControlPanelErrorKind::ConflictException(_inner) => Some(_inner),
            DescribeControlPanelErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeControlPanelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeControlPanelErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeControlPanelErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeControlPanelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeRoutingControl` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeRoutingControlError {
    /// Kind of error that occurred.
    pub kind: DescribeRoutingControlErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeRoutingControl` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeRoutingControlErrorKind {
    /// <p>403 response - You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>409 response - ConflictException. You might be using a predefined variable.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>500 response - InternalServiceError. Temporary service error. Retry the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>404 response - MalformedQueryString. The query string contains a syntax error or resource not found..</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>429 response - LimitExceededException or TooManyRequestsException.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>400 response - Multiple causes. For example, you might have a malformed query string and input parameter might be out of range, or you might have used parameters together incorrectly.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeRoutingControlError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeRoutingControlErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeRoutingControlErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DescribeRoutingControlErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeRoutingControlErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeRoutingControlErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeRoutingControlErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeRoutingControlErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeRoutingControlError {
    fn code(&self) -> Option<&str> {
        DescribeRoutingControlError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeRoutingControlError {
    /// Creates a new `DescribeRoutingControlError`.
    pub fn new(kind: DescribeRoutingControlErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeRoutingControlError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeRoutingControlErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeRoutingControlError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeRoutingControlErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeRoutingControlErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRoutingControlErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRoutingControlErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRoutingControlErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRoutingControlErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRoutingControlErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRoutingControlErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRoutingControlErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRoutingControlErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRoutingControlErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRoutingControlErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRoutingControlErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeRoutingControlError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeRoutingControlErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeRoutingControlErrorKind::ConflictException(_inner) => Some(_inner),
            DescribeRoutingControlErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeRoutingControlErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeRoutingControlErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeRoutingControlErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeRoutingControlErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeSafetyRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeSafetyRuleError {
    /// Kind of error that occurred.
    pub kind: DescribeSafetyRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeSafetyRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeSafetyRuleErrorKind {
    /// <p>404 response - MalformedQueryString. The query string contains a syntax error or resource not found..</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>400 response - Multiple causes. For example, you might have a malformed query string and input parameter might be out of range, or you might have used parameters together incorrectly.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeSafetyRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeSafetyRuleErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeSafetyRuleErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeSafetyRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeSafetyRuleError {
    fn code(&self) -> Option<&str> {
        DescribeSafetyRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeSafetyRuleError {
    /// Creates a new `DescribeSafetyRuleError`.
    pub fn new(kind: DescribeSafetyRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeSafetyRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeSafetyRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeSafetyRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeSafetyRuleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeSafetyRuleErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSafetyRuleErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSafetyRuleErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSafetyRuleErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeSafetyRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeSafetyRuleErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeSafetyRuleErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeSafetyRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAssociatedRoute53HealthChecks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAssociatedRoute53HealthChecksError {
    /// Kind of error that occurred.
    pub kind: ListAssociatedRoute53HealthChecksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAssociatedRoute53HealthChecks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAssociatedRoute53HealthChecksErrorKind {
    /// <p>500 response - InternalServiceError. Temporary service error. Retry the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>404 response - MalformedQueryString. The query string contains a syntax error or resource not found..</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>400 response - Multiple causes. For example, you might have a malformed query string and input parameter might be out of range, or you might have used parameters together incorrectly.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAssociatedRoute53HealthChecksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAssociatedRoute53HealthChecksErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            ListAssociatedRoute53HealthChecksErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListAssociatedRoute53HealthChecksErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            ListAssociatedRoute53HealthChecksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAssociatedRoute53HealthChecksError {
    fn code(&self) -> Option<&str> {
        ListAssociatedRoute53HealthChecksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAssociatedRoute53HealthChecksError {
    /// Creates a new `ListAssociatedRoute53HealthChecksError`.
    pub fn new(
        kind: ListAssociatedRoute53HealthChecksErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAssociatedRoute53HealthChecksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAssociatedRoute53HealthChecksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAssociatedRoute53HealthChecksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAssociatedRoute53HealthChecksErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAssociatedRoute53HealthChecksErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssociatedRoute53HealthChecksErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAssociatedRoute53HealthChecksErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssociatedRoute53HealthChecksErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAssociatedRoute53HealthChecksErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssociatedRoute53HealthChecksErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListAssociatedRoute53HealthChecksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAssociatedRoute53HealthChecksErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            ListAssociatedRoute53HealthChecksErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListAssociatedRoute53HealthChecksErrorKind::ValidationException(_inner) => Some(_inner),
            ListAssociatedRoute53HealthChecksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListClusters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListClustersError {
    /// Kind of error that occurred.
    pub kind: ListClustersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListClusters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListClustersErrorKind {
    /// <p>403 response - You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>500 response - InternalServiceError. Temporary service error. Retry the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>404 response - MalformedQueryString. The query string contains a syntax error or resource not found..</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>429 response - LimitExceededException or TooManyRequestsException.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>400 response - Multiple causes. For example, you might have a malformed query string and input parameter might be out of range, or you might have used parameters together incorrectly.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListClustersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListClustersErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListClustersErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListClustersErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListClustersErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListClustersErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListClustersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListClustersError {
    fn code(&self) -> Option<&str> {
        ListClustersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListClustersError {
    /// Creates a new `ListClustersError`.
    pub fn new(kind: ListClustersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListClustersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListClustersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListClustersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListClustersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListClustersErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListClustersErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListClustersErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListClustersErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListClustersErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListClustersErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListClustersErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListClustersErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListClustersErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListClustersErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListClustersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListClustersErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListClustersErrorKind::InternalServerException(_inner) => Some(_inner),
            ListClustersErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListClustersErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListClustersErrorKind::ValidationException(_inner) => Some(_inner),
            ListClustersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListControlPanels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListControlPanelsError {
    /// Kind of error that occurred.
    pub kind: ListControlPanelsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListControlPanels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListControlPanelsErrorKind {
    /// <p>403 response - You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>500 response - InternalServiceError. Temporary service error. Retry the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>404 response - MalformedQueryString. The query string contains a syntax error or resource not found..</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>429 response - LimitExceededException or TooManyRequestsException.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>400 response - Multiple causes. For example, you might have a malformed query string and input parameter might be out of range, or you might have used parameters together incorrectly.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListControlPanelsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListControlPanelsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListControlPanelsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListControlPanelsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListControlPanelsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListControlPanelsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListControlPanelsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListControlPanelsError {
    fn code(&self) -> Option<&str> {
        ListControlPanelsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListControlPanelsError {
    /// Creates a new `ListControlPanelsError`.
    pub fn new(kind: ListControlPanelsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListControlPanelsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListControlPanelsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListControlPanelsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListControlPanelsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListControlPanelsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListControlPanelsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListControlPanelsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListControlPanelsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListControlPanelsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListControlPanelsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListControlPanelsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListControlPanelsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListControlPanelsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListControlPanelsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListControlPanelsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListControlPanelsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListControlPanelsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListControlPanelsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListControlPanelsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListControlPanelsErrorKind::ValidationException(_inner) => Some(_inner),
            ListControlPanelsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRoutingControls` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRoutingControlsError {
    /// Kind of error that occurred.
    pub kind: ListRoutingControlsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRoutingControls` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRoutingControlsErrorKind {
    /// <p>403 response - You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>500 response - InternalServiceError. Temporary service error. Retry the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>404 response - MalformedQueryString. The query string contains a syntax error or resource not found..</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>429 response - LimitExceededException or TooManyRequestsException.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>400 response - Multiple causes. For example, you might have a malformed query string and input parameter might be out of range, or you might have used parameters together incorrectly.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRoutingControlsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRoutingControlsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListRoutingControlsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListRoutingControlsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListRoutingControlsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListRoutingControlsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListRoutingControlsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRoutingControlsError {
    fn code(&self) -> Option<&str> {
        ListRoutingControlsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRoutingControlsError {
    /// Creates a new `ListRoutingControlsError`.
    pub fn new(kind: ListRoutingControlsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRoutingControlsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRoutingControlsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRoutingControlsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRoutingControlsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRoutingControlsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRoutingControlsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRoutingControlsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRoutingControlsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRoutingControlsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRoutingControlsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRoutingControlsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRoutingControlsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRoutingControlsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRoutingControlsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListRoutingControlsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRoutingControlsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListRoutingControlsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListRoutingControlsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListRoutingControlsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListRoutingControlsErrorKind::ValidationException(_inner) => Some(_inner),
            ListRoutingControlsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSafetyRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSafetyRulesError {
    /// Kind of error that occurred.
    pub kind: ListSafetyRulesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSafetyRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSafetyRulesErrorKind {
    /// <p>403 response - You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>500 response - InternalServiceError. Temporary service error. Retry the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>404 response - MalformedQueryString. The query string contains a syntax error or resource not found..</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>429 response - LimitExceededException or TooManyRequestsException.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>400 response - Multiple causes. For example, you might have a malformed query string and input parameter might be out of range, or you might have used parameters together incorrectly.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSafetyRulesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSafetyRulesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListSafetyRulesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListSafetyRulesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListSafetyRulesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListSafetyRulesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListSafetyRulesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSafetyRulesError {
    fn code(&self) -> Option<&str> {
        ListSafetyRulesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSafetyRulesError {
    /// Creates a new `ListSafetyRulesError`.
    pub fn new(kind: ListSafetyRulesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSafetyRulesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSafetyRulesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSafetyRulesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSafetyRulesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListSafetyRulesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSafetyRulesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSafetyRulesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSafetyRulesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSafetyRulesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSafetyRulesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSafetyRulesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListSafetyRulesErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListSafetyRulesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListSafetyRulesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListSafetyRulesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSafetyRulesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListSafetyRulesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListSafetyRulesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListSafetyRulesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListSafetyRulesErrorKind::ValidationException(_inner) => Some(_inner),
            ListSafetyRulesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>500 response - InternalServiceError. Temporary service error. Retry the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>404 response - MalformedQueryString. The query string contains a syntax error or resource not found..</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>400 response - Multiple causes. For example, you might have a malformed query string and input parameter might be out of range, or you might have used parameters together incorrectly.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ValidationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>500 response - InternalServiceError. Temporary service error. Retry the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>404 response - MalformedQueryString. The query string contains a syntax error or resource not found..</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>400 response - Multiple causes. For example, you might have a malformed query string and input parameter might be out of range, or you might have used parameters together incorrectly.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>500 response - InternalServiceError. Temporary service error. Retry the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>404 response - MalformedQueryString. The query string contains a syntax error or resource not found..</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>400 response - Multiple causes. For example, you might have a malformed query string and input parameter might be out of range, or you might have used parameters together incorrectly.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateControlPanel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateControlPanelError {
    /// Kind of error that occurred.
    pub kind: UpdateControlPanelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateControlPanel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateControlPanelErrorKind {
    /// <p>403 response - You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>409 response - ConflictException. You might be using a predefined variable.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>500 response - InternalServiceError. Temporary service error. Retry the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>404 response - MalformedQueryString. The query string contains a syntax error or resource not found..</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>429 response - LimitExceededException or TooManyRequestsException.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>400 response - Multiple causes. For example, you might have a malformed query string and input parameter might be out of range, or you might have used parameters together incorrectly.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateControlPanelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateControlPanelErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateControlPanelErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateControlPanelErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateControlPanelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateControlPanelErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateControlPanelErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateControlPanelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateControlPanelError {
    fn code(&self) -> Option<&str> {
        UpdateControlPanelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateControlPanelError {
    /// Creates a new `UpdateControlPanelError`.
    pub fn new(kind: UpdateControlPanelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateControlPanelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateControlPanelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateControlPanelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateControlPanelErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateControlPanelErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateControlPanelErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateControlPanelErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateControlPanelErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateControlPanelErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateControlPanelErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateControlPanelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateControlPanelErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateControlPanelErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateControlPanelErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateControlPanelErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateControlPanelErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateControlPanelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateControlPanelErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateControlPanelErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateControlPanelErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateControlPanelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateControlPanelErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateControlPanelErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateControlPanelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateRoutingControl` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateRoutingControlError {
    /// Kind of error that occurred.
    pub kind: UpdateRoutingControlErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateRoutingControl` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateRoutingControlErrorKind {
    /// <p>403 response - You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>409 response - ConflictException. You might be using a predefined variable.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>500 response - InternalServiceError. Temporary service error. Retry the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>404 response - MalformedQueryString. The query string contains a syntax error or resource not found..</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>429 response - LimitExceededException or TooManyRequestsException.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>400 response - Multiple causes. For example, you might have a malformed query string and input parameter might be out of range, or you might have used parameters together incorrectly.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateRoutingControlError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateRoutingControlErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateRoutingControlErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateRoutingControlErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateRoutingControlErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateRoutingControlErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateRoutingControlErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateRoutingControlErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateRoutingControlError {
    fn code(&self) -> Option<&str> {
        UpdateRoutingControlError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateRoutingControlError {
    /// Creates a new `UpdateRoutingControlError`.
    pub fn new(kind: UpdateRoutingControlErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateRoutingControlError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateRoutingControlErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateRoutingControlError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateRoutingControlErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateRoutingControlErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoutingControlErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRoutingControlErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoutingControlErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRoutingControlErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoutingControlErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRoutingControlErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoutingControlErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRoutingControlErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoutingControlErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRoutingControlErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoutingControlErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateRoutingControlError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateRoutingControlErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateRoutingControlErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateRoutingControlErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateRoutingControlErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateRoutingControlErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateRoutingControlErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateRoutingControlErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateSafetyRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateSafetyRuleError {
    /// Kind of error that occurred.
    pub kind: UpdateSafetyRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateSafetyRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateSafetyRuleErrorKind {
    /// <p>500 response - InternalServiceError. Temporary service error. Retry the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>404 response - MalformedQueryString. The query string contains a syntax error or resource not found..</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>400 response - Multiple causes. For example, you might have a malformed query string and input parameter might be out of range, or you might have used parameters together incorrectly.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateSafetyRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateSafetyRuleErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateSafetyRuleErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateSafetyRuleErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateSafetyRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateSafetyRuleError {
    fn code(&self) -> Option<&str> {
        UpdateSafetyRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateSafetyRuleError {
    /// Creates a new `UpdateSafetyRuleError`.
    pub fn new(kind: UpdateSafetyRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateSafetyRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateSafetyRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateSafetyRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateSafetyRuleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateSafetyRuleErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSafetyRuleErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSafetyRuleErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSafetyRuleErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSafetyRuleErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSafetyRuleErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateSafetyRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateSafetyRuleErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateSafetyRuleErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateSafetyRuleErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateSafetyRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>400 response - Multiple causes. For example, you might have a malformed query string and input parameter might be out of range, or you might have used parameters together incorrectly.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>404 response - MalformedQueryString. The query string contains a syntax error or resource not found..</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>500 response - InternalServiceError. Temporary service error. Retry the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p>429 response - LimitExceededException or TooManyRequestsException.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>409 response - ConflictException. You might be using a predefined variable.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>403 response - You do not have sufficient access to perform this action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>402 response - You attempted to create more resources than the service allows based on service quotas.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceQuotaExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceQuotaExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceQuotaExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceQuotaExceededException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceQuotaExceededException {}
/// See [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
pub mod service_quota_exceeded_exception {
    /// A builder for [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
        pub fn build(self) -> crate::error::ServiceQuotaExceededException {
            crate::error::ServiceQuotaExceededException {
                message: self.message,
            }
        }
    }
}
impl ServiceQuotaExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    pub fn builder() -> crate::error::service_quota_exceeded_exception::Builder {
        crate::error::service_quota_exceeded_exception::Builder::default()
    }
}
