// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateClusterInput`](crate::input::CreateClusterInput)
pub mod create_cluster_input {
    /// A builder for [`CreateClusterInput`](crate::input::CreateClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) cluster_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>A unique, case-sensitive string of up to 64 ASCII characters. To make an idempotent API request with an action, specify a client token in the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive string of up to 64 ASCII characters. To make an idempotent API request with an action, specify a client token in the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The name of the cluster.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_name = Some(input.into());
            self
        }
        /// <p>The name of the cluster.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_name = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the cluster.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags associated with the cluster.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateClusterInput`](crate::input::CreateClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateClusterInput {
                client_token: self.client_token,
                cluster_name: self.cluster_name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateClusterInputOperationOutputAlias = crate::operation::CreateCluster;
#[doc(hidden)]
pub type CreateClusterInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateClusterInput {
    /// Consumes the builder and constructs an Operation<[`CreateCluster`](crate::operation::CreateCluster)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCluster,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateClusterInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/cluster").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateClusterInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_cluster(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCluster",
            "route53recoverycontrolconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateClusterInput`](crate::input::CreateClusterInput)
    pub fn builder() -> crate::input::create_cluster_input::Builder {
        crate::input::create_cluster_input::Builder::default()
    }
}

/// See [`CreateControlPanelInput`](crate::input::CreateControlPanelInput)
pub mod create_control_panel_input {
    /// A builder for [`CreateControlPanelInput`](crate::input::CreateControlPanelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) cluster_arn: std::option::Option<std::string::String>,
        pub(crate) control_panel_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>A unique, case-sensitive string of up to 64 ASCII characters. To make an idempotent API request with an action, specify a client token in the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive string of up to 64 ASCII characters. To make an idempotent API request with an action, specify a client token in the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the cluster for the control panel.</p>
        pub fn cluster_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the cluster for the control panel.</p>
        pub fn set_cluster_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_arn = input;
            self
        }
        /// <p>The name of the control panel.</p>
        pub fn control_panel_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_panel_name = Some(input.into());
            self
        }
        /// <p>The name of the control panel.</p>
        pub fn set_control_panel_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.control_panel_name = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the control panel.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags associated with the control panel.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateControlPanelInput`](crate::input::CreateControlPanelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateControlPanelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateControlPanelInput {
                client_token: self.client_token,
                cluster_arn: self.cluster_arn,
                control_panel_name: self.control_panel_name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateControlPanelInputOperationOutputAlias = crate::operation::CreateControlPanel;
#[doc(hidden)]
pub type CreateControlPanelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateControlPanelInput {
    /// Consumes the builder and constructs an Operation<[`CreateControlPanel`](crate::operation::CreateControlPanel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateControlPanel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateControlPanelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/controlpanel").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateControlPanelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_control_panel(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateControlPanel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateControlPanel",
            "route53recoverycontrolconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateControlPanelInput`](crate::input::CreateControlPanelInput)
    pub fn builder() -> crate::input::create_control_panel_input::Builder {
        crate::input::create_control_panel_input::Builder::default()
    }
}

/// See [`CreateRoutingControlInput`](crate::input::CreateRoutingControlInput)
pub mod create_routing_control_input {
    /// A builder for [`CreateRoutingControlInput`](crate::input::CreateRoutingControlInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) cluster_arn: std::option::Option<std::string::String>,
        pub(crate) control_panel_arn: std::option::Option<std::string::String>,
        pub(crate) routing_control_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique, case-sensitive string of up to 64 ASCII characters. To make an idempotent API request with an action, specify a client token in the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive string of up to 64 ASCII characters. To make an idempotent API request with an action, specify a client token in the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the cluster that includes the routing control.</p>
        pub fn cluster_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the cluster that includes the routing control.</p>
        pub fn set_cluster_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the control panel that includes the routing control.</p>
        pub fn control_panel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_panel_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the control panel that includes the routing control.</p>
        pub fn set_control_panel_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.control_panel_arn = input;
            self
        }
        /// <p>The name of the routing control.</p>
        pub fn routing_control_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.routing_control_name = Some(input.into());
            self
        }
        /// <p>The name of the routing control.</p>
        pub fn set_routing_control_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.routing_control_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRoutingControlInput`](crate::input::CreateRoutingControlInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateRoutingControlInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateRoutingControlInput {
                client_token: self.client_token,
                cluster_arn: self.cluster_arn,
                control_panel_arn: self.control_panel_arn,
                routing_control_name: self.routing_control_name,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateRoutingControlInputOperationOutputAlias = crate::operation::CreateRoutingControl;
#[doc(hidden)]
pub type CreateRoutingControlInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateRoutingControlInput {
    /// Consumes the builder and constructs an Operation<[`CreateRoutingControl`](crate::operation::CreateRoutingControl)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateRoutingControl,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateRoutingControlInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/routingcontrol").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateRoutingControlInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_routing_control(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateRoutingControl::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateRoutingControl",
            "route53recoverycontrolconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateRoutingControlInput`](crate::input::CreateRoutingControlInput)
    pub fn builder() -> crate::input::create_routing_control_input::Builder {
        crate::input::create_routing_control_input::Builder::default()
    }
}

/// See [`CreateSafetyRuleInput`](crate::input::CreateSafetyRuleInput)
pub mod create_safety_rule_input {
    /// A builder for [`CreateSafetyRuleInput`](crate::input::CreateSafetyRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assertion_rule: std::option::Option<crate::model::NewAssertionRule>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) gating_rule: std::option::Option<crate::model::NewGatingRule>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The assertion rule requested.</p>
        pub fn assertion_rule(mut self, input: crate::model::NewAssertionRule) -> Self {
            self.assertion_rule = Some(input);
            self
        }
        /// <p>The assertion rule requested.</p>
        pub fn set_assertion_rule(
            mut self,
            input: std::option::Option<crate::model::NewAssertionRule>,
        ) -> Self {
            self.assertion_rule = input;
            self
        }
        /// <p>A unique, case-sensitive string of up to 64 ASCII characters. To make an idempotent API request with an action, specify a client token in the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive string of up to 64 ASCII characters. To make an idempotent API request with an action, specify a client token in the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The gating rule requested.</p>
        pub fn gating_rule(mut self, input: crate::model::NewGatingRule) -> Self {
            self.gating_rule = Some(input);
            self
        }
        /// <p>The gating rule requested.</p>
        pub fn set_gating_rule(
            mut self,
            input: std::option::Option<crate::model::NewGatingRule>,
        ) -> Self {
            self.gating_rule = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the safety rule.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags associated with the safety rule.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSafetyRuleInput`](crate::input::CreateSafetyRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSafetyRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSafetyRuleInput {
                assertion_rule: self.assertion_rule,
                client_token: self.client_token,
                gating_rule: self.gating_rule,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSafetyRuleInputOperationOutputAlias = crate::operation::CreateSafetyRule;
#[doc(hidden)]
pub type CreateSafetyRuleInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateSafetyRuleInput {
    /// Consumes the builder and constructs an Operation<[`CreateSafetyRule`](crate::operation::CreateSafetyRule)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSafetyRule,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateSafetyRuleInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/safetyrule").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateSafetyRuleInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_safety_rule(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSafetyRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSafetyRule",
            "route53recoverycontrolconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateSafetyRuleInput`](crate::input::CreateSafetyRuleInput)
    pub fn builder() -> crate::input::create_safety_rule_input::Builder {
        crate::input::create_safety_rule_input::Builder::default()
    }
}

/// See [`DeleteClusterInput`](crate::input::DeleteClusterInput)
pub mod delete_cluster_input {
    /// A builder for [`DeleteClusterInput`](crate::input::DeleteClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the cluster that you're deleting.</p>
        pub fn cluster_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the cluster that you're deleting.</p>
        pub fn set_cluster_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteClusterInput`](crate::input::DeleteClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteClusterInput {
                cluster_arn: self.cluster_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteClusterInputOperationOutputAlias = crate::operation::DeleteCluster;
#[doc(hidden)]
pub type DeleteClusterInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteClusterInput {
    /// Consumes the builder and constructs an Operation<[`DeleteCluster`](crate::operation::DeleteCluster)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteCluster,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteClusterInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_1 = &_input.cluster_arn;
                let input_1 = input_1.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "cluster_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let cluster_arn = aws_smithy_http::label::fmt_string(input_1, false);
                if cluster_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "cluster_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/cluster/{ClusterArn}", ClusterArn = cluster_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteClusterInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteCluster",
            "route53recoverycontrolconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteClusterInput`](crate::input::DeleteClusterInput)
    pub fn builder() -> crate::input::delete_cluster_input::Builder {
        crate::input::delete_cluster_input::Builder::default()
    }
}

/// See [`DeleteControlPanelInput`](crate::input::DeleteControlPanelInput)
pub mod delete_control_panel_input {
    /// A builder for [`DeleteControlPanelInput`](crate::input::DeleteControlPanelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) control_panel_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the control panel.</p>
        pub fn control_panel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_panel_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the control panel.</p>
        pub fn set_control_panel_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.control_panel_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteControlPanelInput`](crate::input::DeleteControlPanelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteControlPanelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteControlPanelInput {
                control_panel_arn: self.control_panel_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteControlPanelInputOperationOutputAlias = crate::operation::DeleteControlPanel;
#[doc(hidden)]
pub type DeleteControlPanelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteControlPanelInput {
    /// Consumes the builder and constructs an Operation<[`DeleteControlPanel`](crate::operation::DeleteControlPanel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteControlPanel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteControlPanelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_2 = &_input.control_panel_arn;
                let input_2 = input_2.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "control_panel_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let control_panel_arn = aws_smithy_http::label::fmt_string(input_2, false);
                if control_panel_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "control_panel_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/controlpanel/{ControlPanelArn}",
                    ControlPanelArn = control_panel_arn
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteControlPanelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteControlPanel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteControlPanel",
            "route53recoverycontrolconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteControlPanelInput`](crate::input::DeleteControlPanelInput)
    pub fn builder() -> crate::input::delete_control_panel_input::Builder {
        crate::input::delete_control_panel_input::Builder::default()
    }
}

/// See [`DeleteRoutingControlInput`](crate::input::DeleteRoutingControlInput)
pub mod delete_routing_control_input {
    /// A builder for [`DeleteRoutingControlInput`](crate::input::DeleteRoutingControlInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) routing_control_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the routing control that you're deleting.</p>
        pub fn routing_control_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.routing_control_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the routing control that you're deleting.</p>
        pub fn set_routing_control_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.routing_control_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRoutingControlInput`](crate::input::DeleteRoutingControlInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRoutingControlInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRoutingControlInput {
                routing_control_arn: self.routing_control_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRoutingControlInputOperationOutputAlias = crate::operation::DeleteRoutingControl;
#[doc(hidden)]
pub type DeleteRoutingControlInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteRoutingControlInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRoutingControl`](crate::operation::DeleteRoutingControl)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRoutingControl,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteRoutingControlInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_3 = &_input.routing_control_arn;
                let input_3 = input_3.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "routing_control_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let routing_control_arn = aws_smithy_http::label::fmt_string(input_3, false);
                if routing_control_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "routing_control_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/routingcontrol/{RoutingControlArn}",
                    RoutingControlArn = routing_control_arn
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteRoutingControlInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRoutingControl::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRoutingControl",
            "route53recoverycontrolconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteRoutingControlInput`](crate::input::DeleteRoutingControlInput)
    pub fn builder() -> crate::input::delete_routing_control_input::Builder {
        crate::input::delete_routing_control_input::Builder::default()
    }
}

/// See [`DeleteSafetyRuleInput`](crate::input::DeleteSafetyRuleInput)
pub mod delete_safety_rule_input {
    /// A builder for [`DeleteSafetyRuleInput`](crate::input::DeleteSafetyRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) safety_rule_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the safety rule.</p>
        pub fn safety_rule_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.safety_rule_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the safety rule.</p>
        pub fn set_safety_rule_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.safety_rule_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSafetyRuleInput`](crate::input::DeleteSafetyRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSafetyRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSafetyRuleInput {
                safety_rule_arn: self.safety_rule_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSafetyRuleInputOperationOutputAlias = crate::operation::DeleteSafetyRule;
#[doc(hidden)]
pub type DeleteSafetyRuleInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteSafetyRuleInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSafetyRule`](crate::operation::DeleteSafetyRule)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSafetyRule,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteSafetyRuleInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_4 = &_input.safety_rule_arn;
                let input_4 = input_4.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "safety_rule_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let safety_rule_arn = aws_smithy_http::label::fmt_string(input_4, false);
                if safety_rule_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "safety_rule_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/safetyrule/{SafetyRuleArn}",
                    SafetyRuleArn = safety_rule_arn
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteSafetyRuleInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSafetyRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSafetyRule",
            "route53recoverycontrolconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteSafetyRuleInput`](crate::input::DeleteSafetyRuleInput)
    pub fn builder() -> crate::input::delete_safety_rule_input::Builder {
        crate::input::delete_safety_rule_input::Builder::default()
    }
}

/// See [`DescribeClusterInput`](crate::input::DescribeClusterInput)
pub mod describe_cluster_input {
    /// A builder for [`DescribeClusterInput`](crate::input::DescribeClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the cluster.</p>
        pub fn cluster_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the cluster.</p>
        pub fn set_cluster_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeClusterInput`](crate::input::DescribeClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeClusterInput {
                cluster_arn: self.cluster_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeClusterInputOperationOutputAlias = crate::operation::DescribeCluster;
#[doc(hidden)]
pub type DescribeClusterInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeClusterInput {
    /// Consumes the builder and constructs an Operation<[`DescribeCluster`](crate::operation::DescribeCluster)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeCluster,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeClusterInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_5 = &_input.cluster_arn;
                let input_5 = input_5.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "cluster_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let cluster_arn = aws_smithy_http::label::fmt_string(input_5, false);
                if cluster_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "cluster_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/cluster/{ClusterArn}", ClusterArn = cluster_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeClusterInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeCluster",
            "route53recoverycontrolconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeClusterInput`](crate::input::DescribeClusterInput)
    pub fn builder() -> crate::input::describe_cluster_input::Builder {
        crate::input::describe_cluster_input::Builder::default()
    }
}

/// See [`DescribeControlPanelInput`](crate::input::DescribeControlPanelInput)
pub mod describe_control_panel_input {
    /// A builder for [`DescribeControlPanelInput`](crate::input::DescribeControlPanelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) control_panel_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the control panel.</p>
        pub fn control_panel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_panel_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the control panel.</p>
        pub fn set_control_panel_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.control_panel_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeControlPanelInput`](crate::input::DescribeControlPanelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeControlPanelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeControlPanelInput {
                control_panel_arn: self.control_panel_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeControlPanelInputOperationOutputAlias = crate::operation::DescribeControlPanel;
#[doc(hidden)]
pub type DescribeControlPanelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeControlPanelInput {
    /// Consumes the builder and constructs an Operation<[`DescribeControlPanel`](crate::operation::DescribeControlPanel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeControlPanel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeControlPanelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_6 = &_input.control_panel_arn;
                let input_6 = input_6.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "control_panel_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let control_panel_arn = aws_smithy_http::label::fmt_string(input_6, false);
                if control_panel_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "control_panel_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/controlpanel/{ControlPanelArn}",
                    ControlPanelArn = control_panel_arn
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeControlPanelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeControlPanel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeControlPanel",
            "route53recoverycontrolconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeControlPanelInput`](crate::input::DescribeControlPanelInput)
    pub fn builder() -> crate::input::describe_control_panel_input::Builder {
        crate::input::describe_control_panel_input::Builder::default()
    }
}

/// See [`DescribeRoutingControlInput`](crate::input::DescribeRoutingControlInput)
pub mod describe_routing_control_input {
    /// A builder for [`DescribeRoutingControlInput`](crate::input::DescribeRoutingControlInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) routing_control_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the routing control.</p>
        pub fn routing_control_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.routing_control_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the routing control.</p>
        pub fn set_routing_control_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.routing_control_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRoutingControlInput`](crate::input::DescribeRoutingControlInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeRoutingControlInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeRoutingControlInput {
                routing_control_arn: self.routing_control_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeRoutingControlInputOperationOutputAlias = crate::operation::DescribeRoutingControl;
#[doc(hidden)]
pub type DescribeRoutingControlInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeRoutingControlInput {
    /// Consumes the builder and constructs an Operation<[`DescribeRoutingControl`](crate::operation::DescribeRoutingControl)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeRoutingControl,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeRoutingControlInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_7 = &_input.routing_control_arn;
                let input_7 = input_7.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "routing_control_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let routing_control_arn = aws_smithy_http::label::fmt_string(input_7, false);
                if routing_control_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "routing_control_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/routingcontrol/{RoutingControlArn}",
                    RoutingControlArn = routing_control_arn
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeRoutingControlInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeRoutingControl::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeRoutingControl",
            "route53recoverycontrolconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeRoutingControlInput`](crate::input::DescribeRoutingControlInput)
    pub fn builder() -> crate::input::describe_routing_control_input::Builder {
        crate::input::describe_routing_control_input::Builder::default()
    }
}

/// See [`DescribeSafetyRuleInput`](crate::input::DescribeSafetyRuleInput)
pub mod describe_safety_rule_input {
    /// A builder for [`DescribeSafetyRuleInput`](crate::input::DescribeSafetyRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) safety_rule_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the safety rule.</p>
        pub fn safety_rule_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.safety_rule_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the safety rule.</p>
        pub fn set_safety_rule_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.safety_rule_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSafetyRuleInput`](crate::input::DescribeSafetyRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeSafetyRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeSafetyRuleInput {
                safety_rule_arn: self.safety_rule_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeSafetyRuleInputOperationOutputAlias = crate::operation::DescribeSafetyRule;
#[doc(hidden)]
pub type DescribeSafetyRuleInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeSafetyRuleInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSafetyRule`](crate::operation::DescribeSafetyRule)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSafetyRule,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeSafetyRuleInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_8 = &_input.safety_rule_arn;
                let input_8 = input_8.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "safety_rule_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let safety_rule_arn = aws_smithy_http::label::fmt_string(input_8, false);
                if safety_rule_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "safety_rule_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/safetyrule/{SafetyRuleArn}",
                    SafetyRuleArn = safety_rule_arn
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeSafetyRuleInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSafetyRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSafetyRule",
            "route53recoverycontrolconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeSafetyRuleInput`](crate::input::DescribeSafetyRuleInput)
    pub fn builder() -> crate::input::describe_safety_rule_input::Builder {
        crate::input::describe_safety_rule_input::Builder::default()
    }
}

/// See [`ListAssociatedRoute53HealthChecksInput`](crate::input::ListAssociatedRoute53HealthChecksInput)
pub mod list_associated_route53_health_checks_input {
    /// A builder for [`ListAssociatedRoute53HealthChecksInput`](crate::input::ListAssociatedRoute53HealthChecksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) routing_control_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The number of objects that you want to return with this call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The number of objects that you want to return with this call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the routing control.</p>
        pub fn routing_control_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.routing_control_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the routing control.</p>
        pub fn set_routing_control_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.routing_control_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssociatedRoute53HealthChecksInput`](crate::input::ListAssociatedRoute53HealthChecksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAssociatedRoute53HealthChecksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAssociatedRoute53HealthChecksInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
                routing_control_arn: self.routing_control_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAssociatedRoute53HealthChecksInputOperationOutputAlias =
    crate::operation::ListAssociatedRoute53HealthChecks;
#[doc(hidden)]
pub type ListAssociatedRoute53HealthChecksInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListAssociatedRoute53HealthChecksInput {
    /// Consumes the builder and constructs an Operation<[`ListAssociatedRoute53HealthChecks`](crate::operation::ListAssociatedRoute53HealthChecks)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAssociatedRoute53HealthChecks,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListAssociatedRoute53HealthChecksInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_9 = &_input.routing_control_arn;
                let input_9 = input_9.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "routing_control_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let routing_control_arn = aws_smithy_http::label::fmt_string(input_9, false);
                if routing_control_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "routing_control_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/routingcontrol/{RoutingControlArn}/associatedRoute53HealthChecks",
                    RoutingControlArn = routing_control_arn
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListAssociatedRoute53HealthChecksInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if _input.max_results != 0 {
                    query.push_kv(
                        "MaxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                if let Some(inner_10) = &_input.next_token {
                    query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_10));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListAssociatedRoute53HealthChecksInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAssociatedRoute53HealthChecks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAssociatedRoute53HealthChecks",
            "route53recoverycontrolconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListAssociatedRoute53HealthChecksInput`](crate::input::ListAssociatedRoute53HealthChecksInput)
    pub fn builder() -> crate::input::list_associated_route53_health_checks_input::Builder {
        crate::input::list_associated_route53_health_checks_input::Builder::default()
    }
}

/// See [`ListClustersInput`](crate::input::ListClustersInput)
pub mod list_clusters_input {
    /// A builder for [`ListClustersInput`](crate::input::ListClustersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The number of objects that you want to return with this call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The number of objects that you want to return with this call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListClustersInput`](crate::input::ListClustersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListClustersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListClustersInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListClustersInputOperationOutputAlias = crate::operation::ListClusters;
#[doc(hidden)]
pub type ListClustersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListClustersInput {
    /// Consumes the builder and constructs an Operation<[`ListClusters`](crate::operation::ListClusters)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListClusters,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListClustersInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/cluster").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListClustersInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if _input.max_results != 0 {
                    query.push_kv(
                        "MaxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                if let Some(inner_11) = &_input.next_token {
                    query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_11));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListClustersInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListClusters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListClusters",
            "route53recoverycontrolconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListClustersInput`](crate::input::ListClustersInput)
    pub fn builder() -> crate::input::list_clusters_input::Builder {
        crate::input::list_clusters_input::Builder::default()
    }
}

/// See [`ListControlPanelsInput`](crate::input::ListControlPanelsInput)
pub mod list_control_panels_input {
    /// A builder for [`ListControlPanelsInput`](crate::input::ListControlPanelsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of a cluster.</p>
        pub fn cluster_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a cluster.</p>
        pub fn set_cluster_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_arn = input;
            self
        }
        /// <p>The number of objects that you want to return with this call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The number of objects that you want to return with this call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListControlPanelsInput`](crate::input::ListControlPanelsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListControlPanelsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListControlPanelsInput {
                cluster_arn: self.cluster_arn,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListControlPanelsInputOperationOutputAlias = crate::operation::ListControlPanels;
#[doc(hidden)]
pub type ListControlPanelsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListControlPanelsInput {
    /// Consumes the builder and constructs an Operation<[`ListControlPanels`](crate::operation::ListControlPanels)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListControlPanels,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListControlPanelsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/controlpanels").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListControlPanelsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_12) = &_input.cluster_arn {
                    query.push_kv("ClusterArn", &aws_smithy_http::query::fmt_string(&inner_12));
                }
                if _input.max_results != 0 {
                    query.push_kv(
                        "MaxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                if let Some(inner_13) = &_input.next_token {
                    query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_13));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListControlPanelsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListControlPanels::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListControlPanels",
            "route53recoverycontrolconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListControlPanelsInput`](crate::input::ListControlPanelsInput)
    pub fn builder() -> crate::input::list_control_panels_input::Builder {
        crate::input::list_control_panels_input::Builder::default()
    }
}

/// See [`ListRoutingControlsInput`](crate::input::ListRoutingControlsInput)
pub mod list_routing_controls_input {
    /// A builder for [`ListRoutingControlsInput`](crate::input::ListRoutingControlsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) control_panel_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the control panel.</p>
        pub fn control_panel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_panel_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the control panel.</p>
        pub fn set_control_panel_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.control_panel_arn = input;
            self
        }
        /// <p>The number of objects that you want to return with this call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The number of objects that you want to return with this call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRoutingControlsInput`](crate::input::ListRoutingControlsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListRoutingControlsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListRoutingControlsInput {
                control_panel_arn: self.control_panel_arn,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRoutingControlsInputOperationOutputAlias = crate::operation::ListRoutingControls;
#[doc(hidden)]
pub type ListRoutingControlsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListRoutingControlsInput {
    /// Consumes the builder and constructs an Operation<[`ListRoutingControls`](crate::operation::ListRoutingControls)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRoutingControls,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListRoutingControlsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_14 = &_input.control_panel_arn;
                let input_14 = input_14.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "control_panel_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let control_panel_arn = aws_smithy_http::label::fmt_string(input_14, false);
                if control_panel_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "control_panel_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/controlpanel/{ControlPanelArn}/routingcontrols",
                    ControlPanelArn = control_panel_arn
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListRoutingControlsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if _input.max_results != 0 {
                    query.push_kv(
                        "MaxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                if let Some(inner_15) = &_input.next_token {
                    query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_15));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListRoutingControlsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListRoutingControls::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListRoutingControls",
            "route53recoverycontrolconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListRoutingControlsInput`](crate::input::ListRoutingControlsInput)
    pub fn builder() -> crate::input::list_routing_controls_input::Builder {
        crate::input::list_routing_controls_input::Builder::default()
    }
}

/// See [`ListSafetyRulesInput`](crate::input::ListSafetyRulesInput)
pub mod list_safety_rules_input {
    /// A builder for [`ListSafetyRulesInput`](crate::input::ListSafetyRulesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) control_panel_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the control panel.</p>
        pub fn control_panel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_panel_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the control panel.</p>
        pub fn set_control_panel_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.control_panel_arn = input;
            self
        }
        /// <p>The number of objects that you want to return with this call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The number of objects that you want to return with this call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSafetyRulesInput`](crate::input::ListSafetyRulesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSafetyRulesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSafetyRulesInput {
                control_panel_arn: self.control_panel_arn,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSafetyRulesInputOperationOutputAlias = crate::operation::ListSafetyRules;
#[doc(hidden)]
pub type ListSafetyRulesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListSafetyRulesInput {
    /// Consumes the builder and constructs an Operation<[`ListSafetyRules`](crate::operation::ListSafetyRules)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSafetyRules,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListSafetyRulesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_16 = &_input.control_panel_arn;
                let input_16 = input_16.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "control_panel_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let control_panel_arn = aws_smithy_http::label::fmt_string(input_16, false);
                if control_panel_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "control_panel_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/controlpanel/{ControlPanelArn}/safetyrules",
                    ControlPanelArn = control_panel_arn
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListSafetyRulesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if _input.max_results != 0 {
                    query.push_kv(
                        "MaxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                if let Some(inner_17) = &_input.next_token {
                    query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_17));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListSafetyRulesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSafetyRules::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSafetyRules",
            "route53recoverycontrolconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListSafetyRulesInput`](crate::input::ListSafetyRulesInput)
    pub fn builder() -> crate::input::list_safety_rules_input::Builder {
        crate::input::list_safety_rules_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the resource that's tagged.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the resource that's tagged.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListTagsForResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_18 = &_input.resource_arn;
                let input_18 = input_18.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_18, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListTagsForResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "route53recoverycontrolconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the resource that's tagged.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the resource that's tagged.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags associated with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::TagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_19 = &_input.resource_arn;
                let input_19 = input_19.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_19, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::TagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "route53recoverycontrolconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the resource that's tagged.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the resource that's tagged.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>Keys for the tags to be removed.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>Keys for the tags to be removed.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UntagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_20 = &_input.resource_arn;
                let input_20 = input_20.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_20, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::UntagResourceInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_21) = &_input.tag_keys {
                    for inner_22 in inner_21 {
                        query.push_kv("TagKeys", &aws_smithy_http::query::fmt_string(&inner_22));
                    }
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UntagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "route53recoverycontrolconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateControlPanelInput`](crate::input::UpdateControlPanelInput)
pub mod update_control_panel_input {
    /// A builder for [`UpdateControlPanelInput`](crate::input::UpdateControlPanelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) control_panel_arn: std::option::Option<std::string::String>,
        pub(crate) control_panel_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the control panel.</p>
        pub fn control_panel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_panel_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the control panel.</p>
        pub fn set_control_panel_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.control_panel_arn = input;
            self
        }
        /// <p>The name of the control panel.</p>
        pub fn control_panel_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_panel_name = Some(input.into());
            self
        }
        /// <p>The name of the control panel.</p>
        pub fn set_control_panel_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.control_panel_name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateControlPanelInput`](crate::input::UpdateControlPanelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateControlPanelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateControlPanelInput {
                control_panel_arn: self.control_panel_arn,
                control_panel_name: self.control_panel_name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateControlPanelInputOperationOutputAlias = crate::operation::UpdateControlPanel;
#[doc(hidden)]
pub type UpdateControlPanelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateControlPanelInput {
    /// Consumes the builder and constructs an Operation<[`UpdateControlPanel`](crate::operation::UpdateControlPanel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateControlPanel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateControlPanelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/controlpanel").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateControlPanelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_control_panel(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateControlPanel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateControlPanel",
            "route53recoverycontrolconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateControlPanelInput`](crate::input::UpdateControlPanelInput)
    pub fn builder() -> crate::input::update_control_panel_input::Builder {
        crate::input::update_control_panel_input::Builder::default()
    }
}

/// See [`UpdateRoutingControlInput`](crate::input::UpdateRoutingControlInput)
pub mod update_routing_control_input {
    /// A builder for [`UpdateRoutingControlInput`](crate::input::UpdateRoutingControlInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) routing_control_arn: std::option::Option<std::string::String>,
        pub(crate) routing_control_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the routing control.</p>
        pub fn routing_control_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.routing_control_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the routing control.</p>
        pub fn set_routing_control_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.routing_control_arn = input;
            self
        }
        /// <p>The name of the routing control.</p>
        pub fn routing_control_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.routing_control_name = Some(input.into());
            self
        }
        /// <p>The name of the routing control.</p>
        pub fn set_routing_control_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.routing_control_name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRoutingControlInput`](crate::input::UpdateRoutingControlInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateRoutingControlInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateRoutingControlInput {
                routing_control_arn: self.routing_control_arn,
                routing_control_name: self.routing_control_name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateRoutingControlInputOperationOutputAlias = crate::operation::UpdateRoutingControl;
#[doc(hidden)]
pub type UpdateRoutingControlInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateRoutingControlInput {
    /// Consumes the builder and constructs an Operation<[`UpdateRoutingControl`](crate::operation::UpdateRoutingControl)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateRoutingControl,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateRoutingControlInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/routingcontrol").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateRoutingControlInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_routing_control(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateRoutingControl::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateRoutingControl",
            "route53recoverycontrolconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateRoutingControlInput`](crate::input::UpdateRoutingControlInput)
    pub fn builder() -> crate::input::update_routing_control_input::Builder {
        crate::input::update_routing_control_input::Builder::default()
    }
}

/// See [`UpdateSafetyRuleInput`](crate::input::UpdateSafetyRuleInput)
pub mod update_safety_rule_input {
    /// A builder for [`UpdateSafetyRuleInput`](crate::input::UpdateSafetyRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assertion_rule_update: std::option::Option<crate::model::AssertionRuleUpdate>,
        pub(crate) gating_rule_update: std::option::Option<crate::model::GatingRuleUpdate>,
    }
    impl Builder {
        /// <p>The assertion rule to update.</p>
        pub fn assertion_rule_update(mut self, input: crate::model::AssertionRuleUpdate) -> Self {
            self.assertion_rule_update = Some(input);
            self
        }
        /// <p>The assertion rule to update.</p>
        pub fn set_assertion_rule_update(
            mut self,
            input: std::option::Option<crate::model::AssertionRuleUpdate>,
        ) -> Self {
            self.assertion_rule_update = input;
            self
        }
        /// <p>The gating rule to update.</p>
        pub fn gating_rule_update(mut self, input: crate::model::GatingRuleUpdate) -> Self {
            self.gating_rule_update = Some(input);
            self
        }
        /// <p>The gating rule to update.</p>
        pub fn set_gating_rule_update(
            mut self,
            input: std::option::Option<crate::model::GatingRuleUpdate>,
        ) -> Self {
            self.gating_rule_update = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSafetyRuleInput`](crate::input::UpdateSafetyRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateSafetyRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateSafetyRuleInput {
                assertion_rule_update: self.assertion_rule_update,
                gating_rule_update: self.gating_rule_update,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateSafetyRuleInputOperationOutputAlias = crate::operation::UpdateSafetyRule;
#[doc(hidden)]
pub type UpdateSafetyRuleInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateSafetyRuleInput {
    /// Consumes the builder and constructs an Operation<[`UpdateSafetyRule`](crate::operation::UpdateSafetyRule)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateSafetyRule,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateSafetyRuleInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/safetyrule").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateSafetyRuleInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_safety_rule(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateSafetyRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateSafetyRule",
            "route53recoverycontrolconfig",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateSafetyRuleInput`](crate::input::UpdateSafetyRuleInput)
    pub fn builder() -> crate::input::update_safety_rule_input::Builder {
        crate::input::update_safety_rule_input::Builder::default()
    }
}

/// <p>A rule that you add to Application Recovery Controller to ensure that recovery actions don't accidentally impair your application's availability.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSafetyRuleInput {
    /// <p>The assertion rule to update.</p>
    pub assertion_rule_update: std::option::Option<crate::model::AssertionRuleUpdate>,
    /// <p>The gating rule to update.</p>
    pub gating_rule_update: std::option::Option<crate::model::GatingRuleUpdate>,
}
impl UpdateSafetyRuleInput {
    /// <p>The assertion rule to update.</p>
    pub fn assertion_rule_update(&self) -> std::option::Option<&crate::model::AssertionRuleUpdate> {
        self.assertion_rule_update.as_ref()
    }
    /// <p>The gating rule to update.</p>
    pub fn gating_rule_update(&self) -> std::option::Option<&crate::model::GatingRuleUpdate> {
        self.gating_rule_update.as_ref()
    }
}
impl std::fmt::Debug for UpdateSafetyRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSafetyRuleInput");
        formatter.field("assertion_rule_update", &self.assertion_rule_update);
        formatter.field("gating_rule_update", &self.gating_rule_update);
        formatter.finish()
    }
}

/// <p>The details of the routing control that you're updating.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRoutingControlInput {
    /// <p>The Amazon Resource Name (ARN) of the routing control.</p>
    pub routing_control_arn: std::option::Option<std::string::String>,
    /// <p>The name of the routing control.</p>
    pub routing_control_name: std::option::Option<std::string::String>,
}
impl UpdateRoutingControlInput {
    /// <p>The Amazon Resource Name (ARN) of the routing control.</p>
    pub fn routing_control_arn(&self) -> std::option::Option<&str> {
        self.routing_control_arn.as_deref()
    }
    /// <p>The name of the routing control.</p>
    pub fn routing_control_name(&self) -> std::option::Option<&str> {
        self.routing_control_name.as_deref()
    }
}
impl std::fmt::Debug for UpdateRoutingControlInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRoutingControlInput");
        formatter.field("routing_control_arn", &self.routing_control_arn);
        formatter.field("routing_control_name", &self.routing_control_name);
        formatter.finish()
    }
}

/// <p>The details of the control panel that you're updating.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateControlPanelInput {
    /// <p>The Amazon Resource Name (ARN) of the control panel.</p>
    pub control_panel_arn: std::option::Option<std::string::String>,
    /// <p>The name of the control panel.</p>
    pub control_panel_name: std::option::Option<std::string::String>,
}
impl UpdateControlPanelInput {
    /// <p>The Amazon Resource Name (ARN) of the control panel.</p>
    pub fn control_panel_arn(&self) -> std::option::Option<&str> {
        self.control_panel_arn.as_deref()
    }
    /// <p>The name of the control panel.</p>
    pub fn control_panel_name(&self) -> std::option::Option<&str> {
        self.control_panel_name.as_deref()
    }
}
impl std::fmt::Debug for UpdateControlPanelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateControlPanelInput");
        formatter.field("control_panel_arn", &self.control_panel_arn);
        formatter.field("control_panel_name", &self.control_panel_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) for the resource that's tagged.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>Keys for the tags to be removed.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) for the resource that's tagged.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>Keys for the tags to be removed.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

/// <p>Request of adding tag to the resource</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) for the resource that's tagged.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tags associated with the resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) for the resource that's tagged.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tags associated with the resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) for the resource that's tagged.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) for the resource that's tagged.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSafetyRulesInput {
    /// <p>The Amazon Resource Name (ARN) of the control panel.</p>
    pub control_panel_arn: std::option::Option<std::string::String>,
    /// <p>The number of objects that you want to return with this call.</p>
    pub max_results: i32,
    /// <p>The token that identifies which batch of results you want to see.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListSafetyRulesInput {
    /// <p>The Amazon Resource Name (ARN) of the control panel.</p>
    pub fn control_panel_arn(&self) -> std::option::Option<&str> {
        self.control_panel_arn.as_deref()
    }
    /// <p>The number of objects that you want to return with this call.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The token that identifies which batch of results you want to see.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListSafetyRulesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSafetyRulesInput");
        formatter.field("control_panel_arn", &self.control_panel_arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRoutingControlsInput {
    /// <p>The Amazon Resource Name (ARN) of the control panel.</p>
    pub control_panel_arn: std::option::Option<std::string::String>,
    /// <p>The number of objects that you want to return with this call.</p>
    pub max_results: i32,
    /// <p>The token that identifies which batch of results you want to see.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListRoutingControlsInput {
    /// <p>The Amazon Resource Name (ARN) of the control panel.</p>
    pub fn control_panel_arn(&self) -> std::option::Option<&str> {
        self.control_panel_arn.as_deref()
    }
    /// <p>The number of objects that you want to return with this call.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The token that identifies which batch of results you want to see.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListRoutingControlsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRoutingControlsInput");
        formatter.field("control_panel_arn", &self.control_panel_arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListControlPanelsInput {
    /// <p>The Amazon Resource Name (ARN) of a cluster.</p>
    pub cluster_arn: std::option::Option<std::string::String>,
    /// <p>The number of objects that you want to return with this call.</p>
    pub max_results: i32,
    /// <p>The token that identifies which batch of results you want to see.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListControlPanelsInput {
    /// <p>The Amazon Resource Name (ARN) of a cluster.</p>
    pub fn cluster_arn(&self) -> std::option::Option<&str> {
        self.cluster_arn.as_deref()
    }
    /// <p>The number of objects that you want to return with this call.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The token that identifies which batch of results you want to see.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListControlPanelsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListControlPanelsInput");
        formatter.field("cluster_arn", &self.cluster_arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListClustersInput {
    /// <p>The number of objects that you want to return with this call.</p>
    pub max_results: i32,
    /// <p>The token that identifies which batch of results you want to see.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListClustersInput {
    /// <p>The number of objects that you want to return with this call.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The token that identifies which batch of results you want to see.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListClustersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListClustersInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAssociatedRoute53HealthChecksInput {
    /// <p>The number of objects that you want to return with this call.</p>
    pub max_results: i32,
    /// <p>The token that identifies which batch of results you want to see.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the routing control.</p>
    pub routing_control_arn: std::option::Option<std::string::String>,
}
impl ListAssociatedRoute53HealthChecksInput {
    /// <p>The number of objects that you want to return with this call.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The token that identifies which batch of results you want to see.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the routing control.</p>
    pub fn routing_control_arn(&self) -> std::option::Option<&str> {
        self.routing_control_arn.as_deref()
    }
}
impl std::fmt::Debug for ListAssociatedRoute53HealthChecksInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAssociatedRoute53HealthChecksInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("routing_control_arn", &self.routing_control_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSafetyRuleInput {
    /// <p>The ARN of the safety rule.</p>
    pub safety_rule_arn: std::option::Option<std::string::String>,
}
impl DescribeSafetyRuleInput {
    /// <p>The ARN of the safety rule.</p>
    pub fn safety_rule_arn(&self) -> std::option::Option<&str> {
        self.safety_rule_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeSafetyRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSafetyRuleInput");
        formatter.field("safety_rule_arn", &self.safety_rule_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRoutingControlInput {
    /// <p>The Amazon Resource Name (ARN) of the routing control.</p>
    pub routing_control_arn: std::option::Option<std::string::String>,
}
impl DescribeRoutingControlInput {
    /// <p>The Amazon Resource Name (ARN) of the routing control.</p>
    pub fn routing_control_arn(&self) -> std::option::Option<&str> {
        self.routing_control_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeRoutingControlInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRoutingControlInput");
        formatter.field("routing_control_arn", &self.routing_control_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeControlPanelInput {
    /// <p>The Amazon Resource Name (ARN) of the control panel.</p>
    pub control_panel_arn: std::option::Option<std::string::String>,
}
impl DescribeControlPanelInput {
    /// <p>The Amazon Resource Name (ARN) of the control panel.</p>
    pub fn control_panel_arn(&self) -> std::option::Option<&str> {
        self.control_panel_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeControlPanelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeControlPanelInput");
        formatter.field("control_panel_arn", &self.control_panel_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeClusterInput {
    /// <p>The Amazon Resource Name (ARN) of the cluster.</p>
    pub cluster_arn: std::option::Option<std::string::String>,
}
impl DescribeClusterInput {
    /// <p>The Amazon Resource Name (ARN) of the cluster.</p>
    pub fn cluster_arn(&self) -> std::option::Option<&str> {
        self.cluster_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeClusterInput");
        formatter.field("cluster_arn", &self.cluster_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSafetyRuleInput {
    /// <p>The ARN of the safety rule.</p>
    pub safety_rule_arn: std::option::Option<std::string::String>,
}
impl DeleteSafetyRuleInput {
    /// <p>The ARN of the safety rule.</p>
    pub fn safety_rule_arn(&self) -> std::option::Option<&str> {
        self.safety_rule_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteSafetyRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSafetyRuleInput");
        formatter.field("safety_rule_arn", &self.safety_rule_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRoutingControlInput {
    /// <p>The Amazon Resource Name (ARN) of the routing control that you're deleting.</p>
    pub routing_control_arn: std::option::Option<std::string::String>,
}
impl DeleteRoutingControlInput {
    /// <p>The Amazon Resource Name (ARN) of the routing control that you're deleting.</p>
    pub fn routing_control_arn(&self) -> std::option::Option<&str> {
        self.routing_control_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteRoutingControlInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRoutingControlInput");
        formatter.field("routing_control_arn", &self.routing_control_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteControlPanelInput {
    /// <p>The Amazon Resource Name (ARN) of the control panel.</p>
    pub control_panel_arn: std::option::Option<std::string::String>,
}
impl DeleteControlPanelInput {
    /// <p>The Amazon Resource Name (ARN) of the control panel.</p>
    pub fn control_panel_arn(&self) -> std::option::Option<&str> {
        self.control_panel_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteControlPanelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteControlPanelInput");
        formatter.field("control_panel_arn", &self.control_panel_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteClusterInput {
    /// <p>The Amazon Resource Name (ARN) of the cluster that you're deleting.</p>
    pub cluster_arn: std::option::Option<std::string::String>,
}
impl DeleteClusterInput {
    /// <p>The Amazon Resource Name (ARN) of the cluster that you're deleting.</p>
    pub fn cluster_arn(&self) -> std::option::Option<&str> {
        self.cluster_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteClusterInput");
        formatter.field("cluster_arn", &self.cluster_arn);
        formatter.finish()
    }
}

/// <p>The request body that you include when you create a safety rule.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSafetyRuleInput {
    /// <p>The assertion rule requested.</p>
    pub assertion_rule: std::option::Option<crate::model::NewAssertionRule>,
    /// <p>A unique, case-sensitive string of up to 64 ASCII characters. To make an idempotent API request with an action, specify a client token in the request.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The gating rule requested.</p>
    pub gating_rule: std::option::Option<crate::model::NewGatingRule>,
    /// <p>The tags associated with the safety rule.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateSafetyRuleInput {
    /// <p>The assertion rule requested.</p>
    pub fn assertion_rule(&self) -> std::option::Option<&crate::model::NewAssertionRule> {
        self.assertion_rule.as_ref()
    }
    /// <p>A unique, case-sensitive string of up to 64 ASCII characters. To make an idempotent API request with an action, specify a client token in the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The gating rule requested.</p>
    pub fn gating_rule(&self) -> std::option::Option<&crate::model::NewGatingRule> {
        self.gating_rule.as_ref()
    }
    /// <p>The tags associated with the safety rule.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateSafetyRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSafetyRuleInput");
        formatter.field("assertion_rule", &self.assertion_rule);
        formatter.field("client_token", &self.client_token);
        formatter.field("gating_rule", &self.gating_rule);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>The details of the routing control that you're creating.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRoutingControlInput {
    /// <p>A unique, case-sensitive string of up to 64 ASCII characters. To make an idempotent API request with an action, specify a client token in the request.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the cluster that includes the routing control.</p>
    pub cluster_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the control panel that includes the routing control.</p>
    pub control_panel_arn: std::option::Option<std::string::String>,
    /// <p>The name of the routing control.</p>
    pub routing_control_name: std::option::Option<std::string::String>,
}
impl CreateRoutingControlInput {
    /// <p>A unique, case-sensitive string of up to 64 ASCII characters. To make an idempotent API request with an action, specify a client token in the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the cluster that includes the routing control.</p>
    pub fn cluster_arn(&self) -> std::option::Option<&str> {
        self.cluster_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the control panel that includes the routing control.</p>
    pub fn control_panel_arn(&self) -> std::option::Option<&str> {
        self.control_panel_arn.as_deref()
    }
    /// <p>The name of the routing control.</p>
    pub fn routing_control_name(&self) -> std::option::Option<&str> {
        self.routing_control_name.as_deref()
    }
}
impl std::fmt::Debug for CreateRoutingControlInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRoutingControlInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("cluster_arn", &self.cluster_arn);
        formatter.field("control_panel_arn", &self.control_panel_arn);
        formatter.field("routing_control_name", &self.routing_control_name);
        formatter.finish()
    }
}

/// <p>The details of the control panel that you're creating.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateControlPanelInput {
    /// <p>A unique, case-sensitive string of up to 64 ASCII characters. To make an idempotent API request with an action, specify a client token in the request.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the cluster for the control panel.</p>
    pub cluster_arn: std::option::Option<std::string::String>,
    /// <p>The name of the control panel.</p>
    pub control_panel_name: std::option::Option<std::string::String>,
    /// <p>The tags associated with the control panel.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateControlPanelInput {
    /// <p>A unique, case-sensitive string of up to 64 ASCII characters. To make an idempotent API request with an action, specify a client token in the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the cluster for the control panel.</p>
    pub fn cluster_arn(&self) -> std::option::Option<&str> {
        self.cluster_arn.as_deref()
    }
    /// <p>The name of the control panel.</p>
    pub fn control_panel_name(&self) -> std::option::Option<&str> {
        self.control_panel_name.as_deref()
    }
    /// <p>The tags associated with the control panel.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateControlPanelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateControlPanelInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("cluster_arn", &self.cluster_arn);
        formatter.field("control_panel_name", &self.control_panel_name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>Creates a cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateClusterInput {
    /// <p>A unique, case-sensitive string of up to 64 ASCII characters. To make an idempotent API request with an action, specify a client token in the request.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The name of the cluster.</p>
    pub cluster_name: std::option::Option<std::string::String>,
    /// <p>The tags associated with the cluster.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateClusterInput {
    /// <p>A unique, case-sensitive string of up to 64 ASCII characters. To make an idempotent API request with an action, specify a client token in the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The name of the cluster.</p>
    pub fn cluster_name(&self) -> std::option::Option<&str> {
        self.cluster_name.as_deref()
    }
    /// <p>The tags associated with the cluster.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateClusterInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("cluster_name", &self.cluster_name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
