// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `Route53RecoveryControlConfig`.
///
/// This client allows ergonomic access to a `Route53RecoveryControlConfig`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateCluster` operation.
    ///
    /// See [`CreateCluster`](crate::client::fluent_builders::CreateCluster) for more information about the
    /// operation and its arguments.
    pub fn create_cluster(&self) -> fluent_builders::CreateCluster<C, M, R> {
        fluent_builders::CreateCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateControlPanel` operation.
    ///
    /// See [`CreateControlPanel`](crate::client::fluent_builders::CreateControlPanel) for more information about the
    /// operation and its arguments.
    pub fn create_control_panel(&self) -> fluent_builders::CreateControlPanel<C, M, R> {
        fluent_builders::CreateControlPanel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRoutingControl` operation.
    ///
    /// See [`CreateRoutingControl`](crate::client::fluent_builders::CreateRoutingControl) for more information about the
    /// operation and its arguments.
    pub fn create_routing_control(&self) -> fluent_builders::CreateRoutingControl<C, M, R> {
        fluent_builders::CreateRoutingControl::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSafetyRule` operation.
    ///
    /// See [`CreateSafetyRule`](crate::client::fluent_builders::CreateSafetyRule) for more information about the
    /// operation and its arguments.
    pub fn create_safety_rule(&self) -> fluent_builders::CreateSafetyRule<C, M, R> {
        fluent_builders::CreateSafetyRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteCluster` operation.
    ///
    /// See [`DeleteCluster`](crate::client::fluent_builders::DeleteCluster) for more information about the
    /// operation and its arguments.
    pub fn delete_cluster(&self) -> fluent_builders::DeleteCluster<C, M, R> {
        fluent_builders::DeleteCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteControlPanel` operation.
    ///
    /// See [`DeleteControlPanel`](crate::client::fluent_builders::DeleteControlPanel) for more information about the
    /// operation and its arguments.
    pub fn delete_control_panel(&self) -> fluent_builders::DeleteControlPanel<C, M, R> {
        fluent_builders::DeleteControlPanel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRoutingControl` operation.
    ///
    /// See [`DeleteRoutingControl`](crate::client::fluent_builders::DeleteRoutingControl) for more information about the
    /// operation and its arguments.
    pub fn delete_routing_control(&self) -> fluent_builders::DeleteRoutingControl<C, M, R> {
        fluent_builders::DeleteRoutingControl::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSafetyRule` operation.
    ///
    /// See [`DeleteSafetyRule`](crate::client::fluent_builders::DeleteSafetyRule) for more information about the
    /// operation and its arguments.
    pub fn delete_safety_rule(&self) -> fluent_builders::DeleteSafetyRule<C, M, R> {
        fluent_builders::DeleteSafetyRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeCluster` operation.
    ///
    /// See [`DescribeCluster`](crate::client::fluent_builders::DescribeCluster) for more information about the
    /// operation and its arguments.
    pub fn describe_cluster(&self) -> fluent_builders::DescribeCluster<C, M, R> {
        fluent_builders::DescribeCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeControlPanel` operation.
    ///
    /// See [`DescribeControlPanel`](crate::client::fluent_builders::DescribeControlPanel) for more information about the
    /// operation and its arguments.
    pub fn describe_control_panel(&self) -> fluent_builders::DescribeControlPanel<C, M, R> {
        fluent_builders::DescribeControlPanel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeRoutingControl` operation.
    ///
    /// See [`DescribeRoutingControl`](crate::client::fluent_builders::DescribeRoutingControl) for more information about the
    /// operation and its arguments.
    pub fn describe_routing_control(&self) -> fluent_builders::DescribeRoutingControl<C, M, R> {
        fluent_builders::DescribeRoutingControl::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSafetyRule` operation.
    ///
    /// See [`DescribeSafetyRule`](crate::client::fluent_builders::DescribeSafetyRule) for more information about the
    /// operation and its arguments.
    pub fn describe_safety_rule(&self) -> fluent_builders::DescribeSafetyRule<C, M, R> {
        fluent_builders::DescribeSafetyRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAssociatedRoute53HealthChecks` operation.
    ///
    /// See [`ListAssociatedRoute53HealthChecks`](crate::client::fluent_builders::ListAssociatedRoute53HealthChecks) for more information about the
    /// operation and its arguments.
    pub fn list_associated_route53_health_checks(
        &self,
    ) -> fluent_builders::ListAssociatedRoute53HealthChecks<C, M, R> {
        fluent_builders::ListAssociatedRoute53HealthChecks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListClusters` operation.
    ///
    /// See [`ListClusters`](crate::client::fluent_builders::ListClusters) for more information about the
    /// operation and its arguments.
    pub fn list_clusters(&self) -> fluent_builders::ListClusters<C, M, R> {
        fluent_builders::ListClusters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListControlPanels` operation.
    ///
    /// See [`ListControlPanels`](crate::client::fluent_builders::ListControlPanels) for more information about the
    /// operation and its arguments.
    pub fn list_control_panels(&self) -> fluent_builders::ListControlPanels<C, M, R> {
        fluent_builders::ListControlPanels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRoutingControls` operation.
    ///
    /// See [`ListRoutingControls`](crate::client::fluent_builders::ListRoutingControls) for more information about the
    /// operation and its arguments.
    pub fn list_routing_controls(&self) -> fluent_builders::ListRoutingControls<C, M, R> {
        fluent_builders::ListRoutingControls::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSafetyRules` operation.
    ///
    /// See [`ListSafetyRules`](crate::client::fluent_builders::ListSafetyRules) for more information about the
    /// operation and its arguments.
    pub fn list_safety_rules(&self) -> fluent_builders::ListSafetyRules<C, M, R> {
        fluent_builders::ListSafetyRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateControlPanel` operation.
    ///
    /// See [`UpdateControlPanel`](crate::client::fluent_builders::UpdateControlPanel) for more information about the
    /// operation and its arguments.
    pub fn update_control_panel(&self) -> fluent_builders::UpdateControlPanel<C, M, R> {
        fluent_builders::UpdateControlPanel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRoutingControl` operation.
    ///
    /// See [`UpdateRoutingControl`](crate::client::fluent_builders::UpdateRoutingControl) for more information about the
    /// operation and its arguments.
    pub fn update_routing_control(&self) -> fluent_builders::UpdateRoutingControl<C, M, R> {
        fluent_builders::UpdateRoutingControl::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateSafetyRule` operation.
    ///
    /// See [`UpdateSafetyRule`](crate::client::fluent_builders::UpdateSafetyRule) for more information about the
    /// operation and its arguments.
    pub fn update_safety_rule(&self) -> fluent_builders::UpdateSafetyRule<C, M, R> {
        fluent_builders::UpdateSafetyRule::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateCluster`.
    ///
    /// <p>Create a new cluster. A cluster is a set of redundant Regional endpoints against which you can run API calls to update or get the state of one or more routing controls. Each cluster has a name, status, Amazon Resource Name (ARN), and an array of the five cluster endpoints (one for each supported Amazon Web Services Region) that you can use with API calls to the Amazon Route 53 Application Recovery Controller cluster data plane.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_cluster_input::Builder,
    }
    impl<C, M, R> CreateCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateClusterInputOperationOutputAlias,
                crate::output::CreateClusterOutput,
                crate::error::CreateClusterError,
                crate::input::CreateClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique client idempotency token.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique client idempotency token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The name of the cluster.</p>
        pub fn cluster_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(inp);
            self
        }
        /// <p>The name of the cluster.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateControlPanel`.
    ///
    /// <p>Creates a new control panel. A control panel represents a group of routing controls that can be changed together in a single transaction. You can use a control panel to centrally view the operational status of applications across your organization, and trigger multi-app failovers in a single transaction, for example, to fail over an Availability Zone or AWS Region.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateControlPanel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_control_panel_input::Builder,
    }
    impl<C, M, R> CreateControlPanel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateControlPanel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateControlPanelOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateControlPanelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateControlPanelInputOperationOutputAlias,
                crate::output::CreateControlPanelOutput,
                crate::error::CreateControlPanelError,
                crate::input::CreateControlPanelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique client idempotency token.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique client idempotency token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the cluster for the control panel.</p>
        pub fn cluster_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the cluster for the control panel.</p>
        pub fn set_cluster_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_arn(input);
            self
        }
        /// <p>The name of the control panel.</p>
        pub fn control_panel_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.control_panel_name(inp);
            self
        }
        /// <p>The name of the control panel.</p>
        pub fn set_control_panel_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_control_panel_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRoutingControl`.
    ///
    /// <p>Creates a new routing control.</p> <p>A routing control has one of two states: ON and OFF. You can map the routing control state to the state of an Amazon Route 53 health check, which can be used to control traffic routing.</p> <p>To get or update the routing control state, see the Recovery Cluster (data plane) API actions for Amazon Route 53 Application Recovery Controller.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateRoutingControl<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_routing_control_input::Builder,
    }
    impl<C, M, R> CreateRoutingControl<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRoutingControl`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRoutingControlOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRoutingControlError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRoutingControlInputOperationOutputAlias,
                crate::output::CreateRoutingControlOutput,
                crate::error::CreateRoutingControlError,
                crate::input::CreateRoutingControlInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique client idempotency token.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique client idempotency token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the cluster that includes the routing control.</p>
        pub fn cluster_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the cluster that includes the routing control.</p>
        pub fn set_cluster_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the control panel that includes the routing control.</p>
        pub fn control_panel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.control_panel_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the control panel that includes the routing control.</p>
        pub fn set_control_panel_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_control_panel_arn(input);
            self
        }
        /// <p>The name of the routing control.</p>
        pub fn routing_control_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.routing_control_name(inp);
            self
        }
        /// <p>The name of the routing control.</p>
        pub fn set_routing_control_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_routing_control_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSafetyRule`.
    ///
    /// <p>Creates a safety rule in a control panel. Safety rules let you add safeguards around enabling and disabling routing controls, to help prevent unexpected outcomes.</p> <p>There are two types of safety rules: assertion rules and gating rules.</p> <p>Assertion rule: An assertion rule enforces that, when a routing control state is changed, the criteria set by the rule configuration is met. Otherwise, the change to the routing control is not accepted.</p> <p>Gating rule: A gating rule verifies that a set of gating controls evaluates as true, based on a rule configuration that you specify. If the gating rule evaluates to true, Amazon Route 53 Application Recovery Controller allows a set of routing control state changes to run and complete against the set of target controls.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateSafetyRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_safety_rule_input::Builder,
    }
    impl<C, M, R> CreateSafetyRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSafetyRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSafetyRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSafetyRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSafetyRuleInputOperationOutputAlias,
                crate::output::CreateSafetyRuleOutput,
                crate::error::CreateSafetyRuleError,
                crate::input::CreateSafetyRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A new assertion rule for a control panel.</p>
        pub fn assertion_rule(mut self, inp: crate::model::NewAssertionRule) -> Self {
            self.inner = self.inner.assertion_rule(inp);
            self
        }
        /// <p>A new assertion rule for a control panel.</p>
        pub fn set_assertion_rule(
            mut self,
            input: std::option::Option<crate::model::NewAssertionRule>,
        ) -> Self {
            self.inner = self.inner.set_assertion_rule(input);
            self
        }
        /// <p>Unique client idempotency token.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique client idempotency token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>A new gating rule for a control panel.</p>
        pub fn gating_rule(mut self, inp: crate::model::NewGatingRule) -> Self {
            self.inner = self.inner.gating_rule(inp);
            self
        }
        /// <p>A new gating rule for a control panel.</p>
        pub fn set_gating_rule(
            mut self,
            input: std::option::Option<crate::model::NewGatingRule>,
        ) -> Self {
            self.inner = self.inner.set_gating_rule(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCluster`.
    ///
    /// <p>Delete a cluster.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_cluster_input::Builder,
    }
    impl<C, M, R> DeleteCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteClusterInputOperationOutputAlias,
                crate::output::DeleteClusterOutput,
                crate::error::DeleteClusterError,
                crate::input::DeleteClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the cluster that you're deleting.</p>
        pub fn cluster_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the cluster that you're deleting.</p>
        pub fn set_cluster_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteControlPanel`.
    ///
    /// <p>Deletes a control panel.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteControlPanel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_control_panel_input::Builder,
    }
    impl<C, M, R> DeleteControlPanel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteControlPanel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteControlPanelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteControlPanelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteControlPanelInputOperationOutputAlias,
                crate::output::DeleteControlPanelOutput,
                crate::error::DeleteControlPanelError,
                crate::input::DeleteControlPanelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the control panel that you're deleting.</p>
        pub fn control_panel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.control_panel_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the control panel that you're deleting.</p>
        pub fn set_control_panel_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_control_panel_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRoutingControl`.
    ///
    /// <p>Deletes a routing control.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteRoutingControl<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_routing_control_input::Builder,
    }
    impl<C, M, R> DeleteRoutingControl<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRoutingControl`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRoutingControlOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRoutingControlError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRoutingControlInputOperationOutputAlias,
                crate::output::DeleteRoutingControlOutput,
                crate::error::DeleteRoutingControlError,
                crate::input::DeleteRoutingControlInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the routing control that you're deleting.</p>
        pub fn routing_control_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.routing_control_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the routing control that you're deleting.</p>
        pub fn set_routing_control_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_routing_control_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSafetyRule`.
    ///
    /// <p>Deletes a safety rule.</p>/&gt;
    #[derive(std::fmt::Debug)]
    pub struct DeleteSafetyRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_safety_rule_input::Builder,
    }
    impl<C, M, R> DeleteSafetyRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSafetyRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSafetyRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSafetyRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSafetyRuleInputOperationOutputAlias,
                crate::output::DeleteSafetyRuleOutput,
                crate::error::DeleteSafetyRuleError,
                crate::input::DeleteSafetyRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The request body that you include when you update a safety rule.</p>
        pub fn safety_rule_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.safety_rule_arn(inp);
            self
        }
        /// <p>The request body that you include when you update a safety rule.</p>
        pub fn set_safety_rule_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_safety_rule_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCluster`.
    ///
    /// <p>Display the details about a cluster. The response includes the cluster name, endpoints, status, and Amazon Resource Name (ARN).</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_cluster_input::Builder,
    }
    impl<C, M, R> DescribeCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeClusterInputOperationOutputAlias,
                crate::output::DescribeClusterOutput,
                crate::error::DescribeClusterError,
                crate::input::DescribeClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the cluster that you're getting details for.</p>
        pub fn cluster_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the cluster that you're getting details for.</p>
        pub fn set_cluster_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeControlPanel`.
    ///
    /// <p>Displays details about a control panel.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeControlPanel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_control_panel_input::Builder,
    }
    impl<C, M, R> DescribeControlPanel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeControlPanel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeControlPanelOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeControlPanelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeControlPanelInputOperationOutputAlias,
                crate::output::DescribeControlPanelOutput,
                crate::error::DescribeControlPanelError,
                crate::input::DescribeControlPanelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the control panel that you're getting details for.</p>
        pub fn control_panel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.control_panel_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the control panel that you're getting details for.</p>
        pub fn set_control_panel_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_control_panel_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRoutingControl`.
    ///
    /// <p>Displays details about a routing control. A routing control has one of two states: ON and OFF. You can map the routing control state to the state of an Amazon Route 53 health check, which can be used to control routing.</p> <p>To get or update the routing control state, see the Recovery Cluster (data plane) API actions for Amazon Route 53 Application Recovery Controller.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeRoutingControl<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_routing_control_input::Builder,
    }
    impl<C, M, R> DescribeRoutingControl<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRoutingControl`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRoutingControlOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRoutingControlError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRoutingControlInputOperationOutputAlias,
                crate::output::DescribeRoutingControlOutput,
                crate::error::DescribeRoutingControlError,
                crate::input::DescribeRoutingControlInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the routing control that you're getting details for.</p>
        pub fn routing_control_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.routing_control_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the routing control that you're getting details for.</p>
        pub fn set_routing_control_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_routing_control_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSafetyRule`.
    ///
    /// <p>Describes the safety rules (that is, the assertion rules and gating rules) for the routing controls in a control panel.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeSafetyRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_safety_rule_input::Builder,
    }
    impl<C, M, R> DescribeSafetyRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSafetyRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSafetyRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSafetyRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSafetyRuleInputOperationOutputAlias,
                crate::output::DescribeSafetyRuleOutput,
                crate::error::DescribeSafetyRuleError,
                crate::input::DescribeSafetyRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The request body that you include when you update a safety rule.</p>
        pub fn safety_rule_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.safety_rule_arn(inp);
            self
        }
        /// <p>The request body that you include when you update a safety rule.</p>
        pub fn set_safety_rule_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_safety_rule_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssociatedRoute53HealthChecks`.
    ///
    /// <p>Returns an array of all Amazon Route 53 health checks associated with a specific routing control.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAssociatedRoute53HealthChecks<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_associated_route53_health_checks_input::Builder,
    }
    impl<C, M, R> ListAssociatedRoute53HealthChecks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAssociatedRoute53HealthChecks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssociatedRoute53HealthChecksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAssociatedRoute53HealthChecksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAssociatedRoute53HealthChecksInputOperationOutputAlias,
                crate::output::ListAssociatedRoute53HealthChecksOutput,
                crate::error::ListAssociatedRoute53HealthChecksError,
                crate::input::ListAssociatedRoute53HealthChecksInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The number of objects that you want to return with this call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The number of objects that you want to return with this call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the routing control that you're getting details for.</p>
        pub fn routing_control_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.routing_control_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the routing control that you're getting details for.</p>
        pub fn set_routing_control_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_routing_control_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListClusters`.
    ///
    /// <p>Returns an array of all the clusters in an account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListClusters<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_clusters_input::Builder,
    }
    impl<C, M, R> ListClusters<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListClusters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListClustersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListClustersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListClustersInputOperationOutputAlias,
                crate::output::ListClustersOutput,
                crate::error::ListClustersError,
                crate::input::ListClustersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The number of objects that you want to return with this call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The number of objects that you want to return with this call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListControlPanels`.
    ///
    /// <p>Returns an array of control panels for a cluster.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListControlPanels<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_control_panels_input::Builder,
    }
    impl<C, M, R> ListControlPanels<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListControlPanels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListControlPanelsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListControlPanelsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListControlPanelsInputOperationOutputAlias,
                crate::output::ListControlPanelsOutput,
                crate::error::ListControlPanelsError,
                crate::input::ListControlPanelsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of a cluster.</p>
        pub fn cluster_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a cluster.</p>
        pub fn set_cluster_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_arn(input);
            self
        }
        /// <p>The number of objects that you want to return with this call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The number of objects that you want to return with this call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRoutingControls`.
    ///
    /// <p>Returns an array of routing controls for a control panel. A routing control is an Amazon Route 53 Application Recovery Controller construct that has one of two states: ON and OFF. You can map the routing control state to the state of an Amazon Route 53 health check, which can be used to control routing.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListRoutingControls<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_routing_controls_input::Builder,
    }
    impl<C, M, R> ListRoutingControls<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRoutingControls`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRoutingControlsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRoutingControlsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRoutingControlsInputOperationOutputAlias,
                crate::output::ListRoutingControlsOutput,
                crate::error::ListRoutingControlsError,
                crate::input::ListRoutingControlsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the control panel that you're getting routing control details for.</p>
        pub fn control_panel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.control_panel_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the control panel that you're getting routing control details for.</p>
        pub fn set_control_panel_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_control_panel_arn(input);
            self
        }
        /// <p>The number of objects that you want to return with this call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The number of objects that you want to return with this call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSafetyRules`.
    ///
    /// <p>List the safety rules (the assertion rules and gating rules) that you've defined for the routing controls in a control panel.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListSafetyRules<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_safety_rules_input::Builder,
    }
    impl<C, M, R> ListSafetyRules<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSafetyRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSafetyRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSafetyRulesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSafetyRulesInputOperationOutputAlias,
                crate::output::ListSafetyRulesOutput,
                crate::error::ListSafetyRulesError,
                crate::input::ListSafetyRulesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the control panel that you're getting details for.</p>
        pub fn control_panel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.control_panel_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the control panel that you're getting details for.</p>
        pub fn set_control_panel_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_control_panel_arn(input);
            self
        }
        /// <p>The number of objects that you want to return with this call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The number of objects that you want to return with this call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateControlPanel`.
    ///
    /// <p>Updates a control panel. The only update you can make to a control panel is to change the name of the control panel.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateControlPanel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_control_panel_input::Builder,
    }
    impl<C, M, R> UpdateControlPanel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateControlPanel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateControlPanelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateControlPanelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateControlPanelInputOperationOutputAlias,
                crate::output::UpdateControlPanelOutput,
                crate::error::UpdateControlPanelError,
                crate::input::UpdateControlPanelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the control panel.</p>
        pub fn control_panel_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.control_panel_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the control panel.</p>
        pub fn set_control_panel_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_control_panel_arn(input);
            self
        }
        /// <p>The name of the control panel.</p>
        pub fn control_panel_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.control_panel_name(inp);
            self
        }
        /// <p>The name of the control panel.</p>
        pub fn set_control_panel_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_control_panel_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRoutingControl`.
    ///
    /// <p>Updates a routing control. You can only update the name of the routing control. To get or update the routing control state, see the Recovery Cluster (data plane) API actions for Amazon Route 53 Application Recovery Controller.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateRoutingControl<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_routing_control_input::Builder,
    }
    impl<C, M, R> UpdateRoutingControl<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRoutingControl`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRoutingControlOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRoutingControlError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRoutingControlInputOperationOutputAlias,
                crate::output::UpdateRoutingControlOutput,
                crate::error::UpdateRoutingControlError,
                crate::input::UpdateRoutingControlInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the routing control.</p>
        pub fn routing_control_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.routing_control_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the routing control.</p>
        pub fn set_routing_control_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_routing_control_arn(input);
            self
        }
        /// <p>The name of the routing control.</p>
        pub fn routing_control_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.routing_control_name(inp);
            self
        }
        /// <p>The name of the routing control.</p>
        pub fn set_routing_control_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_routing_control_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSafetyRule`.
    ///
    /// <p>Update a safety rule (an assertion rule or gating rule) for the routing controls in a control panel. You can only update the name and the waiting period for a safety rule. To make other updates, delete the safety rule and create a new safety rule.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateSafetyRule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_safety_rule_input::Builder,
    }
    impl<C, M, R> UpdateSafetyRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateSafetyRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSafetyRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSafetyRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateSafetyRuleInputOperationOutputAlias,
                crate::output::UpdateSafetyRuleOutput,
                crate::error::UpdateSafetyRuleError,
                crate::input::UpdateSafetyRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An update to an assertion rule. You can update the name or the evaluation period (wait period). If you don't specify one of the items to update, the item is unchanged.</p>
        pub fn assertion_rule_update(mut self, inp: crate::model::AssertionRuleUpdate) -> Self {
            self.inner = self.inner.assertion_rule_update(inp);
            self
        }
        /// <p>An update to an assertion rule. You can update the name or the evaluation period (wait period). If you don't specify one of the items to update, the item is unchanged.</p>
        pub fn set_assertion_rule_update(
            mut self,
            input: std::option::Option<crate::model::AssertionRuleUpdate>,
        ) -> Self {
            self.inner = self.inner.set_assertion_rule_update(input);
            self
        }
        /// <p>Update to a gating rule. You can update the name or the evaluation period (wait period). If you don't specify one of the items to update, the item is unchanged.</p>
        pub fn gating_rule_update(mut self, inp: crate::model::GatingRuleUpdate) -> Self {
            self.inner = self.inner.gating_rule_update(inp);
            self
        }
        /// <p>Update to a gating rule. You can update the name or the evaluation period (wait period). If you don't specify one of the items to update, the item is unchanged.</p>
        pub fn set_gating_rule_update(
            mut self,
            input: std::option::Option<crate::model::GatingRuleUpdate>,
        ) -> Self {
            self.inner = self.inner.set_gating_rule_update(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
