// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSafetyRuleOutput {
    /// <p>An assertion rule enforces that, when a routing control state is changed, the criteria set by the rule configuration is met. Otherwise, the change to the routing control is not accepted.</p>
    pub assertion_rule: std::option::Option<crate::model::AssertionRule>,
    /// <p>A gating rule verifies that a set of gating controls evaluates as true, based on a rule configuration that you specify. If the gating rule evaluates to true, Amazon Route 53 Application Recovery Controller allows a set of routing control state changes to run and complete against the set of target controls.</p>
    pub gating_rule: std::option::Option<crate::model::GatingRule>,
}
impl std::fmt::Debug for UpdateSafetyRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSafetyRuleOutput");
        formatter.field("assertion_rule", &self.assertion_rule);
        formatter.field("gating_rule", &self.gating_rule);
        formatter.finish()
    }
}
/// See [`UpdateSafetyRuleOutput`](crate::output::UpdateSafetyRuleOutput)
pub mod update_safety_rule_output {
    /// A builder for [`UpdateSafetyRuleOutput`](crate::output::UpdateSafetyRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assertion_rule: std::option::Option<crate::model::AssertionRule>,
        pub(crate) gating_rule: std::option::Option<crate::model::GatingRule>,
    }
    impl Builder {
        /// <p>An assertion rule enforces that, when a routing control state is changed, the criteria set by the rule configuration is met. Otherwise, the change to the routing control is not accepted.</p>
        pub fn assertion_rule(mut self, input: crate::model::AssertionRule) -> Self {
            self.assertion_rule = Some(input);
            self
        }
        /// <p>An assertion rule enforces that, when a routing control state is changed, the criteria set by the rule configuration is met. Otherwise, the change to the routing control is not accepted.</p>
        pub fn set_assertion_rule(
            mut self,
            input: std::option::Option<crate::model::AssertionRule>,
        ) -> Self {
            self.assertion_rule = input;
            self
        }
        /// <p>A gating rule verifies that a set of gating controls evaluates as true, based on a rule configuration that you specify. If the gating rule evaluates to true, Amazon Route 53 Application Recovery Controller allows a set of routing control state changes to run and complete against the set of target controls.</p>
        pub fn gating_rule(mut self, input: crate::model::GatingRule) -> Self {
            self.gating_rule = Some(input);
            self
        }
        /// <p>A gating rule verifies that a set of gating controls evaluates as true, based on a rule configuration that you specify. If the gating rule evaluates to true, Amazon Route 53 Application Recovery Controller allows a set of routing control state changes to run and complete against the set of target controls.</p>
        pub fn set_gating_rule(
            mut self,
            input: std::option::Option<crate::model::GatingRule>,
        ) -> Self {
            self.gating_rule = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSafetyRuleOutput`](crate::output::UpdateSafetyRuleOutput)
        pub fn build(self) -> crate::output::UpdateSafetyRuleOutput {
            crate::output::UpdateSafetyRuleOutput {
                assertion_rule: self.assertion_rule,
                gating_rule: self.gating_rule,
            }
        }
    }
}
impl UpdateSafetyRuleOutput {
    /// Creates a new builder-style object to manufacture [`UpdateSafetyRuleOutput`](crate::output::UpdateSafetyRuleOutput)
    pub fn builder() -> crate::output::update_safety_rule_output::Builder {
        crate::output::update_safety_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRoutingControlOutput {
    /// <p>The routing control that was updated.</p>
    pub routing_control: std::option::Option<crate::model::RoutingControl>,
}
impl std::fmt::Debug for UpdateRoutingControlOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRoutingControlOutput");
        formatter.field("routing_control", &self.routing_control);
        formatter.finish()
    }
}
/// See [`UpdateRoutingControlOutput`](crate::output::UpdateRoutingControlOutput)
pub mod update_routing_control_output {
    /// A builder for [`UpdateRoutingControlOutput`](crate::output::UpdateRoutingControlOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) routing_control: std::option::Option<crate::model::RoutingControl>,
    }
    impl Builder {
        /// <p>The routing control that was updated.</p>
        pub fn routing_control(mut self, input: crate::model::RoutingControl) -> Self {
            self.routing_control = Some(input);
            self
        }
        /// <p>The routing control that was updated.</p>
        pub fn set_routing_control(
            mut self,
            input: std::option::Option<crate::model::RoutingControl>,
        ) -> Self {
            self.routing_control = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRoutingControlOutput`](crate::output::UpdateRoutingControlOutput)
        pub fn build(self) -> crate::output::UpdateRoutingControlOutput {
            crate::output::UpdateRoutingControlOutput {
                routing_control: self.routing_control,
            }
        }
    }
}
impl UpdateRoutingControlOutput {
    /// Creates a new builder-style object to manufacture [`UpdateRoutingControlOutput`](crate::output::UpdateRoutingControlOutput)
    pub fn builder() -> crate::output::update_routing_control_output::Builder {
        crate::output::update_routing_control_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateControlPanelOutput {
    /// <p>The control panel to update.</p>
    pub control_panel: std::option::Option<crate::model::ControlPanel>,
}
impl std::fmt::Debug for UpdateControlPanelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateControlPanelOutput");
        formatter.field("control_panel", &self.control_panel);
        formatter.finish()
    }
}
/// See [`UpdateControlPanelOutput`](crate::output::UpdateControlPanelOutput)
pub mod update_control_panel_output {
    /// A builder for [`UpdateControlPanelOutput`](crate::output::UpdateControlPanelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) control_panel: std::option::Option<crate::model::ControlPanel>,
    }
    impl Builder {
        /// <p>The control panel to update.</p>
        pub fn control_panel(mut self, input: crate::model::ControlPanel) -> Self {
            self.control_panel = Some(input);
            self
        }
        /// <p>The control panel to update.</p>
        pub fn set_control_panel(
            mut self,
            input: std::option::Option<crate::model::ControlPanel>,
        ) -> Self {
            self.control_panel = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateControlPanelOutput`](crate::output::UpdateControlPanelOutput)
        pub fn build(self) -> crate::output::UpdateControlPanelOutput {
            crate::output::UpdateControlPanelOutput {
                control_panel: self.control_panel,
            }
        }
    }
}
impl UpdateControlPanelOutput {
    /// Creates a new builder-style object to manufacture [`UpdateControlPanelOutput`](crate::output::UpdateControlPanelOutput)
    pub fn builder() -> crate::output::update_control_panel_output::Builder {
        crate::output::update_control_panel_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSafetyRulesOutput {
    /// <p>The token that identifies which batch of results you want to see.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The list of safety rules in a control panel.</p>
    pub safety_rules: std::option::Option<std::vec::Vec<crate::model::Rule>>,
}
impl std::fmt::Debug for ListSafetyRulesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSafetyRulesOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("safety_rules", &self.safety_rules);
        formatter.finish()
    }
}
/// See [`ListSafetyRulesOutput`](crate::output::ListSafetyRulesOutput)
pub mod list_safety_rules_output {
    /// A builder for [`ListSafetyRulesOutput`](crate::output::ListSafetyRulesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) safety_rules: std::option::Option<std::vec::Vec<crate::model::Rule>>,
    }
    impl Builder {
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `safety_rules`.
        ///
        /// To override the contents of this collection use [`set_safety_rules`](Self::set_safety_rules).
        ///
        /// <p>The list of safety rules in a control panel.</p>
        pub fn safety_rules(mut self, input: impl Into<crate::model::Rule>) -> Self {
            let mut v = self.safety_rules.unwrap_or_default();
            v.push(input.into());
            self.safety_rules = Some(v);
            self
        }
        /// <p>The list of safety rules in a control panel.</p>
        pub fn set_safety_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Rule>>,
        ) -> Self {
            self.safety_rules = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSafetyRulesOutput`](crate::output::ListSafetyRulesOutput)
        pub fn build(self) -> crate::output::ListSafetyRulesOutput {
            crate::output::ListSafetyRulesOutput {
                next_token: self.next_token,
                safety_rules: self.safety_rules,
            }
        }
    }
}
impl ListSafetyRulesOutput {
    /// Creates a new builder-style object to manufacture [`ListSafetyRulesOutput`](crate::output::ListSafetyRulesOutput)
    pub fn builder() -> crate::output::list_safety_rules_output::Builder {
        crate::output::list_safety_rules_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRoutingControlsOutput {
    /// <p>The token that identifies which batch of results you want to see.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An array of routing controls.</p>
    pub routing_controls: std::option::Option<std::vec::Vec<crate::model::RoutingControl>>,
}
impl std::fmt::Debug for ListRoutingControlsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRoutingControlsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("routing_controls", &self.routing_controls);
        formatter.finish()
    }
}
/// See [`ListRoutingControlsOutput`](crate::output::ListRoutingControlsOutput)
pub mod list_routing_controls_output {
    /// A builder for [`ListRoutingControlsOutput`](crate::output::ListRoutingControlsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) routing_controls:
            std::option::Option<std::vec::Vec<crate::model::RoutingControl>>,
    }
    impl Builder {
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `routing_controls`.
        ///
        /// To override the contents of this collection use [`set_routing_controls`](Self::set_routing_controls).
        ///
        /// <p>An array of routing controls.</p>
        pub fn routing_controls(mut self, input: impl Into<crate::model::RoutingControl>) -> Self {
            let mut v = self.routing_controls.unwrap_or_default();
            v.push(input.into());
            self.routing_controls = Some(v);
            self
        }
        /// <p>An array of routing controls.</p>
        pub fn set_routing_controls(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RoutingControl>>,
        ) -> Self {
            self.routing_controls = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRoutingControlsOutput`](crate::output::ListRoutingControlsOutput)
        pub fn build(self) -> crate::output::ListRoutingControlsOutput {
            crate::output::ListRoutingControlsOutput {
                next_token: self.next_token,
                routing_controls: self.routing_controls,
            }
        }
    }
}
impl ListRoutingControlsOutput {
    /// Creates a new builder-style object to manufacture [`ListRoutingControlsOutput`](crate::output::ListRoutingControlsOutput)
    pub fn builder() -> crate::output::list_routing_controls_output::Builder {
        crate::output::list_routing_controls_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListControlPanelsOutput {
    /// <p>The result of a successful ListControlPanel request.</p>
    pub control_panels: std::option::Option<std::vec::Vec<crate::model::ControlPanel>>,
    /// <p>The token that identifies which batch of results you want to see.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListControlPanelsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListControlPanelsOutput");
        formatter.field("control_panels", &self.control_panels);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListControlPanelsOutput`](crate::output::ListControlPanelsOutput)
pub mod list_control_panels_output {
    /// A builder for [`ListControlPanelsOutput`](crate::output::ListControlPanelsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) control_panels: std::option::Option<std::vec::Vec<crate::model::ControlPanel>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `control_panels`.
        ///
        /// To override the contents of this collection use [`set_control_panels`](Self::set_control_panels).
        ///
        /// <p>The result of a successful ListControlPanel request.</p>
        pub fn control_panels(mut self, input: impl Into<crate::model::ControlPanel>) -> Self {
            let mut v = self.control_panels.unwrap_or_default();
            v.push(input.into());
            self.control_panels = Some(v);
            self
        }
        /// <p>The result of a successful ListControlPanel request.</p>
        pub fn set_control_panels(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ControlPanel>>,
        ) -> Self {
            self.control_panels = input;
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListControlPanelsOutput`](crate::output::ListControlPanelsOutput)
        pub fn build(self) -> crate::output::ListControlPanelsOutput {
            crate::output::ListControlPanelsOutput {
                control_panels: self.control_panels,
                next_token: self.next_token,
            }
        }
    }
}
impl ListControlPanelsOutput {
    /// Creates a new builder-style object to manufacture [`ListControlPanelsOutput`](crate::output::ListControlPanelsOutput)
    pub fn builder() -> crate::output::list_control_panels_output::Builder {
        crate::output::list_control_panels_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListClustersOutput {
    /// <p>An array of the clusters in an account.</p>
    pub clusters: std::option::Option<std::vec::Vec<crate::model::Cluster>>,
    /// <p>The token that identifies which batch of results you want to see.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListClustersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListClustersOutput");
        formatter.field("clusters", &self.clusters);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListClustersOutput`](crate::output::ListClustersOutput)
pub mod list_clusters_output {
    /// A builder for [`ListClustersOutput`](crate::output::ListClustersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) clusters: std::option::Option<std::vec::Vec<crate::model::Cluster>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `clusters`.
        ///
        /// To override the contents of this collection use [`set_clusters`](Self::set_clusters).
        ///
        /// <p>An array of the clusters in an account.</p>
        pub fn clusters(mut self, input: impl Into<crate::model::Cluster>) -> Self {
            let mut v = self.clusters.unwrap_or_default();
            v.push(input.into());
            self.clusters = Some(v);
            self
        }
        /// <p>An array of the clusters in an account.</p>
        pub fn set_clusters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Cluster>>,
        ) -> Self {
            self.clusters = input;
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListClustersOutput`](crate::output::ListClustersOutput)
        pub fn build(self) -> crate::output::ListClustersOutput {
            crate::output::ListClustersOutput {
                clusters: self.clusters,
                next_token: self.next_token,
            }
        }
    }
}
impl ListClustersOutput {
    /// Creates a new builder-style object to manufacture [`ListClustersOutput`](crate::output::ListClustersOutput)
    pub fn builder() -> crate::output::list_clusters_output::Builder {
        crate::output::list_clusters_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAssociatedRoute53HealthChecksOutput {
    /// <p>Identifiers for the health checks.</p>
    pub health_check_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The token that identifies which batch of results you want to see.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListAssociatedRoute53HealthChecksOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAssociatedRoute53HealthChecksOutput");
        formatter.field("health_check_ids", &self.health_check_ids);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAssociatedRoute53HealthChecksOutput`](crate::output::ListAssociatedRoute53HealthChecksOutput)
pub mod list_associated_route53_health_checks_output {
    /// A builder for [`ListAssociatedRoute53HealthChecksOutput`](crate::output::ListAssociatedRoute53HealthChecksOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) health_check_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `health_check_ids`.
        ///
        /// To override the contents of this collection use [`set_health_check_ids`](Self::set_health_check_ids).
        ///
        /// <p>Identifiers for the health checks.</p>
        pub fn health_check_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.health_check_ids.unwrap_or_default();
            v.push(input.into());
            self.health_check_ids = Some(v);
            self
        }
        /// <p>Identifiers for the health checks.</p>
        pub fn set_health_check_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.health_check_ids = input;
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that identifies which batch of results you want to see.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssociatedRoute53HealthChecksOutput`](crate::output::ListAssociatedRoute53HealthChecksOutput)
        pub fn build(self) -> crate::output::ListAssociatedRoute53HealthChecksOutput {
            crate::output::ListAssociatedRoute53HealthChecksOutput {
                health_check_ids: self.health_check_ids,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAssociatedRoute53HealthChecksOutput {
    /// Creates a new builder-style object to manufacture [`ListAssociatedRoute53HealthChecksOutput`](crate::output::ListAssociatedRoute53HealthChecksOutput)
    pub fn builder() -> crate::output::list_associated_route53_health_checks_output::Builder {
        crate::output::list_associated_route53_health_checks_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSafetyRuleOutput {
    /// <p>An assertion rule enforces that, when a routing control state is changed, the criteria set by the rule configuration is met. Otherwise, the change to the routing control is not accepted.</p>
    pub assertion_rule: std::option::Option<crate::model::AssertionRule>,
    /// <p>A gating rule verifies that a set of gating controls evaluates as true, based on a rule configuration that you specify. If the gating rule evaluates to true, Amazon Route 53 Application Recovery Controller allows a set of routing control state changes to run and complete against the set of target controls.</p>
    pub gating_rule: std::option::Option<crate::model::GatingRule>,
}
impl std::fmt::Debug for DescribeSafetyRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSafetyRuleOutput");
        formatter.field("assertion_rule", &self.assertion_rule);
        formatter.field("gating_rule", &self.gating_rule);
        formatter.finish()
    }
}
/// See [`DescribeSafetyRuleOutput`](crate::output::DescribeSafetyRuleOutput)
pub mod describe_safety_rule_output {
    /// A builder for [`DescribeSafetyRuleOutput`](crate::output::DescribeSafetyRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assertion_rule: std::option::Option<crate::model::AssertionRule>,
        pub(crate) gating_rule: std::option::Option<crate::model::GatingRule>,
    }
    impl Builder {
        /// <p>An assertion rule enforces that, when a routing control state is changed, the criteria set by the rule configuration is met. Otherwise, the change to the routing control is not accepted.</p>
        pub fn assertion_rule(mut self, input: crate::model::AssertionRule) -> Self {
            self.assertion_rule = Some(input);
            self
        }
        /// <p>An assertion rule enforces that, when a routing control state is changed, the criteria set by the rule configuration is met. Otherwise, the change to the routing control is not accepted.</p>
        pub fn set_assertion_rule(
            mut self,
            input: std::option::Option<crate::model::AssertionRule>,
        ) -> Self {
            self.assertion_rule = input;
            self
        }
        /// <p>A gating rule verifies that a set of gating controls evaluates as true, based on a rule configuration that you specify. If the gating rule evaluates to true, Amazon Route 53 Application Recovery Controller allows a set of routing control state changes to run and complete against the set of target controls.</p>
        pub fn gating_rule(mut self, input: crate::model::GatingRule) -> Self {
            self.gating_rule = Some(input);
            self
        }
        /// <p>A gating rule verifies that a set of gating controls evaluates as true, based on a rule configuration that you specify. If the gating rule evaluates to true, Amazon Route 53 Application Recovery Controller allows a set of routing control state changes to run and complete against the set of target controls.</p>
        pub fn set_gating_rule(
            mut self,
            input: std::option::Option<crate::model::GatingRule>,
        ) -> Self {
            self.gating_rule = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSafetyRuleOutput`](crate::output::DescribeSafetyRuleOutput)
        pub fn build(self) -> crate::output::DescribeSafetyRuleOutput {
            crate::output::DescribeSafetyRuleOutput {
                assertion_rule: self.assertion_rule,
                gating_rule: self.gating_rule,
            }
        }
    }
}
impl DescribeSafetyRuleOutput {
    /// Creates a new builder-style object to manufacture [`DescribeSafetyRuleOutput`](crate::output::DescribeSafetyRuleOutput)
    pub fn builder() -> crate::output::describe_safety_rule_output::Builder {
        crate::output::describe_safety_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRoutingControlOutput {
    /// <p>Information about the routing control.</p>
    pub routing_control: std::option::Option<crate::model::RoutingControl>,
}
impl std::fmt::Debug for DescribeRoutingControlOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRoutingControlOutput");
        formatter.field("routing_control", &self.routing_control);
        formatter.finish()
    }
}
/// See [`DescribeRoutingControlOutput`](crate::output::DescribeRoutingControlOutput)
pub mod describe_routing_control_output {
    /// A builder for [`DescribeRoutingControlOutput`](crate::output::DescribeRoutingControlOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) routing_control: std::option::Option<crate::model::RoutingControl>,
    }
    impl Builder {
        /// <p>Information about the routing control.</p>
        pub fn routing_control(mut self, input: crate::model::RoutingControl) -> Self {
            self.routing_control = Some(input);
            self
        }
        /// <p>Information about the routing control.</p>
        pub fn set_routing_control(
            mut self,
            input: std::option::Option<crate::model::RoutingControl>,
        ) -> Self {
            self.routing_control = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRoutingControlOutput`](crate::output::DescribeRoutingControlOutput)
        pub fn build(self) -> crate::output::DescribeRoutingControlOutput {
            crate::output::DescribeRoutingControlOutput {
                routing_control: self.routing_control,
            }
        }
    }
}
impl DescribeRoutingControlOutput {
    /// Creates a new builder-style object to manufacture [`DescribeRoutingControlOutput`](crate::output::DescribeRoutingControlOutput)
    pub fn builder() -> crate::output::describe_routing_control_output::Builder {
        crate::output::describe_routing_control_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeControlPanelOutput {
    /// <p>Information about the control panel.</p>
    pub control_panel: std::option::Option<crate::model::ControlPanel>,
}
impl std::fmt::Debug for DescribeControlPanelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeControlPanelOutput");
        formatter.field("control_panel", &self.control_panel);
        formatter.finish()
    }
}
/// See [`DescribeControlPanelOutput`](crate::output::DescribeControlPanelOutput)
pub mod describe_control_panel_output {
    /// A builder for [`DescribeControlPanelOutput`](crate::output::DescribeControlPanelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) control_panel: std::option::Option<crate::model::ControlPanel>,
    }
    impl Builder {
        /// <p>Information about the control panel.</p>
        pub fn control_panel(mut self, input: crate::model::ControlPanel) -> Self {
            self.control_panel = Some(input);
            self
        }
        /// <p>Information about the control panel.</p>
        pub fn set_control_panel(
            mut self,
            input: std::option::Option<crate::model::ControlPanel>,
        ) -> Self {
            self.control_panel = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeControlPanelOutput`](crate::output::DescribeControlPanelOutput)
        pub fn build(self) -> crate::output::DescribeControlPanelOutput {
            crate::output::DescribeControlPanelOutput {
                control_panel: self.control_panel,
            }
        }
    }
}
impl DescribeControlPanelOutput {
    /// Creates a new builder-style object to manufacture [`DescribeControlPanelOutput`](crate::output::DescribeControlPanelOutput)
    pub fn builder() -> crate::output::describe_control_panel_output::Builder {
        crate::output::describe_control_panel_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeClusterOutput {
    /// <p>The cluster for the DescribeCluster request.</p>
    pub cluster: std::option::Option<crate::model::Cluster>,
}
impl std::fmt::Debug for DescribeClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeClusterOutput");
        formatter.field("cluster", &self.cluster);
        formatter.finish()
    }
}
/// See [`DescribeClusterOutput`](crate::output::DescribeClusterOutput)
pub mod describe_cluster_output {
    /// A builder for [`DescribeClusterOutput`](crate::output::DescribeClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<crate::model::Cluster>,
    }
    impl Builder {
        /// <p>The cluster for the DescribeCluster request.</p>
        pub fn cluster(mut self, input: crate::model::Cluster) -> Self {
            self.cluster = Some(input);
            self
        }
        /// <p>The cluster for the DescribeCluster request.</p>
        pub fn set_cluster(mut self, input: std::option::Option<crate::model::Cluster>) -> Self {
            self.cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeClusterOutput`](crate::output::DescribeClusterOutput)
        pub fn build(self) -> crate::output::DescribeClusterOutput {
            crate::output::DescribeClusterOutput {
                cluster: self.cluster,
            }
        }
    }
}
impl DescribeClusterOutput {
    /// Creates a new builder-style object to manufacture [`DescribeClusterOutput`](crate::output::DescribeClusterOutput)
    pub fn builder() -> crate::output::describe_cluster_output::Builder {
        crate::output::describe_cluster_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSafetyRuleOutput {}
impl std::fmt::Debug for DeleteSafetyRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSafetyRuleOutput");
        formatter.finish()
    }
}
/// See [`DeleteSafetyRuleOutput`](crate::output::DeleteSafetyRuleOutput)
pub mod delete_safety_rule_output {
    /// A builder for [`DeleteSafetyRuleOutput`](crate::output::DeleteSafetyRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteSafetyRuleOutput`](crate::output::DeleteSafetyRuleOutput)
        pub fn build(self) -> crate::output::DeleteSafetyRuleOutput {
            crate::output::DeleteSafetyRuleOutput {}
        }
    }
}
impl DeleteSafetyRuleOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSafetyRuleOutput`](crate::output::DeleteSafetyRuleOutput)
    pub fn builder() -> crate::output::delete_safety_rule_output::Builder {
        crate::output::delete_safety_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRoutingControlOutput {}
impl std::fmt::Debug for DeleteRoutingControlOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRoutingControlOutput");
        formatter.finish()
    }
}
/// See [`DeleteRoutingControlOutput`](crate::output::DeleteRoutingControlOutput)
pub mod delete_routing_control_output {
    /// A builder for [`DeleteRoutingControlOutput`](crate::output::DeleteRoutingControlOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteRoutingControlOutput`](crate::output::DeleteRoutingControlOutput)
        pub fn build(self) -> crate::output::DeleteRoutingControlOutput {
            crate::output::DeleteRoutingControlOutput {}
        }
    }
}
impl DeleteRoutingControlOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRoutingControlOutput`](crate::output::DeleteRoutingControlOutput)
    pub fn builder() -> crate::output::delete_routing_control_output::Builder {
        crate::output::delete_routing_control_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteControlPanelOutput {}
impl std::fmt::Debug for DeleteControlPanelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteControlPanelOutput");
        formatter.finish()
    }
}
/// See [`DeleteControlPanelOutput`](crate::output::DeleteControlPanelOutput)
pub mod delete_control_panel_output {
    /// A builder for [`DeleteControlPanelOutput`](crate::output::DeleteControlPanelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteControlPanelOutput`](crate::output::DeleteControlPanelOutput)
        pub fn build(self) -> crate::output::DeleteControlPanelOutput {
            crate::output::DeleteControlPanelOutput {}
        }
    }
}
impl DeleteControlPanelOutput {
    /// Creates a new builder-style object to manufacture [`DeleteControlPanelOutput`](crate::output::DeleteControlPanelOutput)
    pub fn builder() -> crate::output::delete_control_panel_output::Builder {
        crate::output::delete_control_panel_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteClusterOutput {}
impl std::fmt::Debug for DeleteClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteClusterOutput");
        formatter.finish()
    }
}
/// See [`DeleteClusterOutput`](crate::output::DeleteClusterOutput)
pub mod delete_cluster_output {
    /// A builder for [`DeleteClusterOutput`](crate::output::DeleteClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteClusterOutput`](crate::output::DeleteClusterOutput)
        pub fn build(self) -> crate::output::DeleteClusterOutput {
            crate::output::DeleteClusterOutput {}
        }
    }
}
impl DeleteClusterOutput {
    /// Creates a new builder-style object to manufacture [`DeleteClusterOutput`](crate::output::DeleteClusterOutput)
    pub fn builder() -> crate::output::delete_cluster_output::Builder {
        crate::output::delete_cluster_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSafetyRuleOutput {
    /// <p>An assertion rule enforces that, when a routing control state is changed, the criteria set by the rule configuration is met. Otherwise, the change to the routing control is not accepted.</p>
    pub assertion_rule: std::option::Option<crate::model::AssertionRule>,
    /// <p>A gating rule verifies that a set of gating controls evaluates as true, based on a rule configuration that you specify. If the gating rule evaluates to true, Amazon Route 53 Application Recovery Controller allows a set of routing control state changes to run and complete against the set of target controls.</p>
    pub gating_rule: std::option::Option<crate::model::GatingRule>,
}
impl std::fmt::Debug for CreateSafetyRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSafetyRuleOutput");
        formatter.field("assertion_rule", &self.assertion_rule);
        formatter.field("gating_rule", &self.gating_rule);
        formatter.finish()
    }
}
/// See [`CreateSafetyRuleOutput`](crate::output::CreateSafetyRuleOutput)
pub mod create_safety_rule_output {
    /// A builder for [`CreateSafetyRuleOutput`](crate::output::CreateSafetyRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assertion_rule: std::option::Option<crate::model::AssertionRule>,
        pub(crate) gating_rule: std::option::Option<crate::model::GatingRule>,
    }
    impl Builder {
        /// <p>An assertion rule enforces that, when a routing control state is changed, the criteria set by the rule configuration is met. Otherwise, the change to the routing control is not accepted.</p>
        pub fn assertion_rule(mut self, input: crate::model::AssertionRule) -> Self {
            self.assertion_rule = Some(input);
            self
        }
        /// <p>An assertion rule enforces that, when a routing control state is changed, the criteria set by the rule configuration is met. Otherwise, the change to the routing control is not accepted.</p>
        pub fn set_assertion_rule(
            mut self,
            input: std::option::Option<crate::model::AssertionRule>,
        ) -> Self {
            self.assertion_rule = input;
            self
        }
        /// <p>A gating rule verifies that a set of gating controls evaluates as true, based on a rule configuration that you specify. If the gating rule evaluates to true, Amazon Route 53 Application Recovery Controller allows a set of routing control state changes to run and complete against the set of target controls.</p>
        pub fn gating_rule(mut self, input: crate::model::GatingRule) -> Self {
            self.gating_rule = Some(input);
            self
        }
        /// <p>A gating rule verifies that a set of gating controls evaluates as true, based on a rule configuration that you specify. If the gating rule evaluates to true, Amazon Route 53 Application Recovery Controller allows a set of routing control state changes to run and complete against the set of target controls.</p>
        pub fn set_gating_rule(
            mut self,
            input: std::option::Option<crate::model::GatingRule>,
        ) -> Self {
            self.gating_rule = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSafetyRuleOutput`](crate::output::CreateSafetyRuleOutput)
        pub fn build(self) -> crate::output::CreateSafetyRuleOutput {
            crate::output::CreateSafetyRuleOutput {
                assertion_rule: self.assertion_rule,
                gating_rule: self.gating_rule,
            }
        }
    }
}
impl CreateSafetyRuleOutput {
    /// Creates a new builder-style object to manufacture [`CreateSafetyRuleOutput`](crate::output::CreateSafetyRuleOutput)
    pub fn builder() -> crate::output::create_safety_rule_output::Builder {
        crate::output::create_safety_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRoutingControlOutput {
    /// <p>The routing control that is created.</p>
    pub routing_control: std::option::Option<crate::model::RoutingControl>,
}
impl std::fmt::Debug for CreateRoutingControlOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRoutingControlOutput");
        formatter.field("routing_control", &self.routing_control);
        formatter.finish()
    }
}
/// See [`CreateRoutingControlOutput`](crate::output::CreateRoutingControlOutput)
pub mod create_routing_control_output {
    /// A builder for [`CreateRoutingControlOutput`](crate::output::CreateRoutingControlOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) routing_control: std::option::Option<crate::model::RoutingControl>,
    }
    impl Builder {
        /// <p>The routing control that is created.</p>
        pub fn routing_control(mut self, input: crate::model::RoutingControl) -> Self {
            self.routing_control = Some(input);
            self
        }
        /// <p>The routing control that is created.</p>
        pub fn set_routing_control(
            mut self,
            input: std::option::Option<crate::model::RoutingControl>,
        ) -> Self {
            self.routing_control = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRoutingControlOutput`](crate::output::CreateRoutingControlOutput)
        pub fn build(self) -> crate::output::CreateRoutingControlOutput {
            crate::output::CreateRoutingControlOutput {
                routing_control: self.routing_control,
            }
        }
    }
}
impl CreateRoutingControlOutput {
    /// Creates a new builder-style object to manufacture [`CreateRoutingControlOutput`](crate::output::CreateRoutingControlOutput)
    pub fn builder() -> crate::output::create_routing_control_output::Builder {
        crate::output::create_routing_control_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateControlPanelOutput {
    /// <p>Information about a control panel.</p>
    pub control_panel: std::option::Option<crate::model::ControlPanel>,
}
impl std::fmt::Debug for CreateControlPanelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateControlPanelOutput");
        formatter.field("control_panel", &self.control_panel);
        formatter.finish()
    }
}
/// See [`CreateControlPanelOutput`](crate::output::CreateControlPanelOutput)
pub mod create_control_panel_output {
    /// A builder for [`CreateControlPanelOutput`](crate::output::CreateControlPanelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) control_panel: std::option::Option<crate::model::ControlPanel>,
    }
    impl Builder {
        /// <p>Information about a control panel.</p>
        pub fn control_panel(mut self, input: crate::model::ControlPanel) -> Self {
            self.control_panel = Some(input);
            self
        }
        /// <p>Information about a control panel.</p>
        pub fn set_control_panel(
            mut self,
            input: std::option::Option<crate::model::ControlPanel>,
        ) -> Self {
            self.control_panel = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateControlPanelOutput`](crate::output::CreateControlPanelOutput)
        pub fn build(self) -> crate::output::CreateControlPanelOutput {
            crate::output::CreateControlPanelOutput {
                control_panel: self.control_panel,
            }
        }
    }
}
impl CreateControlPanelOutput {
    /// Creates a new builder-style object to manufacture [`CreateControlPanelOutput`](crate::output::CreateControlPanelOutput)
    pub fn builder() -> crate::output::create_control_panel_output::Builder {
        crate::output::create_control_panel_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateClusterOutput {
    /// <p>The cluster that was created.</p>
    pub cluster: std::option::Option<crate::model::Cluster>,
}
impl std::fmt::Debug for CreateClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateClusterOutput");
        formatter.field("cluster", &self.cluster);
        formatter.finish()
    }
}
/// See [`CreateClusterOutput`](crate::output::CreateClusterOutput)
pub mod create_cluster_output {
    /// A builder for [`CreateClusterOutput`](crate::output::CreateClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<crate::model::Cluster>,
    }
    impl Builder {
        /// <p>The cluster that was created.</p>
        pub fn cluster(mut self, input: crate::model::Cluster) -> Self {
            self.cluster = Some(input);
            self
        }
        /// <p>The cluster that was created.</p>
        pub fn set_cluster(mut self, input: std::option::Option<crate::model::Cluster>) -> Self {
            self.cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateClusterOutput`](crate::output::CreateClusterOutput)
        pub fn build(self) -> crate::output::CreateClusterOutput {
            crate::output::CreateClusterOutput {
                cluster: self.cluster,
            }
        }
    }
}
impl CreateClusterOutput {
    /// Creates a new builder-style object to manufacture [`CreateClusterOutput`](crate::output::CreateClusterOutput)
    pub fn builder() -> crate::output::create_cluster_output::Builder {
        crate::output::create_cluster_output::Builder::default()
    }
}
