// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>A gating rule verifies that a set of gating controls evaluates as true, based on a rule configuration that you specify. If the gating rule evaluates to true, Amazon Route 53 Application Recovery Controller allows a set of routing control state changes to run and complete against the set of target controls.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GatingRule {
    /// <p>The Amazon Resource Name (ARN) of the control panel.</p>
    pub control_panel_arn: std::option::Option<std::string::String>,
    /// <p>The gating controls for the gating rule. That is, routing controls that are evaluated by the rule configuration that you specify.</p>
    pub gating_controls: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name for the gating rule.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The criteria that you set for specific gating controls (routing controls) that designates how many controls must be enabled to allow you to change (set or unset) the target controls.</p>
    pub rule_config: std::option::Option<crate::model::RuleConfig>,
    /// <p>The Amazon Resource Name (ARN) of the gating rule.</p>
    pub safety_rule_arn: std::option::Option<std::string::String>,
    /// <p>The deployment status of a gating rule. Status can be one of the following: PENDING, DEPLOYED, PENDING_DELETION.</p>
    pub status: std::option::Option<crate::model::Status>,
    /// <p>Routing controls that can only be set or unset if the specified RuleConfig evaluates to true for the specified GatingControls. For example, say you have three gating controls, one for each of three Amazon Web Services Regions. Now you specify ATLEAST 2 as your RuleConfig. With these settings, you can only change (set or unset) the routing controls that you have specified as TargetControls if that rule evaluates to true.</p> <p>In other words, your ability to change the routing controls that you have specified as TargetControls is gated by the rule that you set for the routing controls in GatingControls.</p>
    pub target_controls: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but you can choose a custom value.</p>
    pub wait_period_ms: i32,
}
impl std::fmt::Debug for GatingRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GatingRule");
        formatter.field("control_panel_arn", &self.control_panel_arn);
        formatter.field("gating_controls", &self.gating_controls);
        formatter.field("name", &self.name);
        formatter.field("rule_config", &self.rule_config);
        formatter.field("safety_rule_arn", &self.safety_rule_arn);
        formatter.field("status", &self.status);
        formatter.field("target_controls", &self.target_controls);
        formatter.field("wait_period_ms", &self.wait_period_ms);
        formatter.finish()
    }
}
/// See [`GatingRule`](crate::model::GatingRule)
pub mod gating_rule {
    /// A builder for [`GatingRule`](crate::model::GatingRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) control_panel_arn: std::option::Option<std::string::String>,
        pub(crate) gating_controls: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) rule_config: std::option::Option<crate::model::RuleConfig>,
        pub(crate) safety_rule_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::Status>,
        pub(crate) target_controls: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) wait_period_ms: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the control panel.</p>
        pub fn control_panel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_panel_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the control panel.</p>
        pub fn set_control_panel_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.control_panel_arn = input;
            self
        }
        /// Appends an item to `gating_controls`.
        ///
        /// To override the contents of this collection use [`set_gating_controls`](Self::set_gating_controls).
        ///
        /// <p>The gating controls for the gating rule. That is, routing controls that are evaluated by the rule configuration that you specify.</p>
        pub fn gating_controls(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.gating_controls.unwrap_or_default();
            v.push(input.into());
            self.gating_controls = Some(v);
            self
        }
        /// <p>The gating controls for the gating rule. That is, routing controls that are evaluated by the rule configuration that you specify.</p>
        pub fn set_gating_controls(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.gating_controls = input;
            self
        }
        /// <p>The name for the gating rule.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for the gating rule.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The criteria that you set for specific gating controls (routing controls) that designates how many controls must be enabled to allow you to change (set or unset) the target controls.</p>
        pub fn rule_config(mut self, input: crate::model::RuleConfig) -> Self {
            self.rule_config = Some(input);
            self
        }
        /// <p>The criteria that you set for specific gating controls (routing controls) that designates how many controls must be enabled to allow you to change (set or unset) the target controls.</p>
        pub fn set_rule_config(
            mut self,
            input: std::option::Option<crate::model::RuleConfig>,
        ) -> Self {
            self.rule_config = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gating rule.</p>
        pub fn safety_rule_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.safety_rule_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gating rule.</p>
        pub fn set_safety_rule_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.safety_rule_arn = input;
            self
        }
        /// <p>The deployment status of a gating rule. Status can be one of the following: PENDING, DEPLOYED, PENDING_DELETION.</p>
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The deployment status of a gating rule. Status can be one of the following: PENDING, DEPLOYED, PENDING_DELETION.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `target_controls`.
        ///
        /// To override the contents of this collection use [`set_target_controls`](Self::set_target_controls).
        ///
        /// <p>Routing controls that can only be set or unset if the specified RuleConfig evaluates to true for the specified GatingControls. For example, say you have three gating controls, one for each of three Amazon Web Services Regions. Now you specify ATLEAST 2 as your RuleConfig. With these settings, you can only change (set or unset) the routing controls that you have specified as TargetControls if that rule evaluates to true.</p> <p>In other words, your ability to change the routing controls that you have specified as TargetControls is gated by the rule that you set for the routing controls in GatingControls.</p>
        pub fn target_controls(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.target_controls.unwrap_or_default();
            v.push(input.into());
            self.target_controls = Some(v);
            self
        }
        /// <p>Routing controls that can only be set or unset if the specified RuleConfig evaluates to true for the specified GatingControls. For example, say you have three gating controls, one for each of three Amazon Web Services Regions. Now you specify ATLEAST 2 as your RuleConfig. With these settings, you can only change (set or unset) the routing controls that you have specified as TargetControls if that rule evaluates to true.</p> <p>In other words, your ability to change the routing controls that you have specified as TargetControls is gated by the rule that you set for the routing controls in GatingControls.</p>
        pub fn set_target_controls(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.target_controls = input;
            self
        }
        /// <p>An evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but you can choose a custom value.</p>
        pub fn wait_period_ms(mut self, input: i32) -> Self {
            self.wait_period_ms = Some(input);
            self
        }
        /// <p>An evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but you can choose a custom value.</p>
        pub fn set_wait_period_ms(mut self, input: std::option::Option<i32>) -> Self {
            self.wait_period_ms = input;
            self
        }
        /// Consumes the builder and constructs a [`GatingRule`](crate::model::GatingRule)
        pub fn build(self) -> crate::model::GatingRule {
            crate::model::GatingRule {
                control_panel_arn: self.control_panel_arn,
                gating_controls: self.gating_controls,
                name: self.name,
                rule_config: self.rule_config,
                safety_rule_arn: self.safety_rule_arn,
                status: self.status,
                target_controls: self.target_controls,
                wait_period_ms: self.wait_period_ms.unwrap_or_default(),
            }
        }
    }
}
impl GatingRule {
    /// Creates a new builder-style object to manufacture [`GatingRule`](crate::model::GatingRule)
    pub fn builder() -> crate::model::gating_rule::Builder {
        crate::model::gating_rule::Builder::default()
    }
}

/// <p>The deployment status of a resource. Status can be one of the following:</p> <p>PENDING: Amazon Route 53 Application Recovery Controller is creating the resource.</p> <p>DEPLOYED: The resource is deployed and ready to use.</p> <p>PENDING_DELETION: Amazon Route 53 Application Recovery Controller is deleting the resource.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Status {
    #[allow(missing_docs)] // documentation missing in model
    Deployed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    PendingDeletion,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Status {
    fn from(s: &str) -> Self {
        match s {
            "DEPLOYED" => Status::Deployed,
            "PENDING" => Status::Pending,
            "PENDING_DELETION" => Status::PendingDeletion,
            other => Status::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Status {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Status::from(s))
    }
}
impl Status {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Status::Deployed => "DEPLOYED",
            Status::Pending => "PENDING",
            Status::PendingDeletion => "PENDING_DELETION",
            Status::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEPLOYED", "PENDING", "PENDING_DELETION"]
    }
}
impl AsRef<str> for Status {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The rule configuration for an assertion rule. That is, the criteria that you set for specific assertion controls (routing controls) that specify how many controls must be enabled after a transaction completes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RuleConfig {
    /// <p>Logical negation of the rule. If the rule would usually evaluate true, it's evaluated as false, and vice versa.</p>
    pub inverted: bool,
    /// <p>The value of N, when you specify an ATLEAST rule type. That is, Threshold is the number of controls that must be set when you specify an ATLEAST type.</p>
    pub threshold: i32,
    /// <p>A rule can be one of the following: ATLEAST, AND, or OR.</p>
    pub r#type: std::option::Option<crate::model::RuleType>,
}
impl std::fmt::Debug for RuleConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RuleConfig");
        formatter.field("inverted", &self.inverted);
        formatter.field("threshold", &self.threshold);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`RuleConfig`](crate::model::RuleConfig)
pub mod rule_config {
    /// A builder for [`RuleConfig`](crate::model::RuleConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) inverted: std::option::Option<bool>,
        pub(crate) threshold: std::option::Option<i32>,
        pub(crate) r#type: std::option::Option<crate::model::RuleType>,
    }
    impl Builder {
        /// <p>Logical negation of the rule. If the rule would usually evaluate true, it's evaluated as false, and vice versa.</p>
        pub fn inverted(mut self, input: bool) -> Self {
            self.inverted = Some(input);
            self
        }
        /// <p>Logical negation of the rule. If the rule would usually evaluate true, it's evaluated as false, and vice versa.</p>
        pub fn set_inverted(mut self, input: std::option::Option<bool>) -> Self {
            self.inverted = input;
            self
        }
        /// <p>The value of N, when you specify an ATLEAST rule type. That is, Threshold is the number of controls that must be set when you specify an ATLEAST type.</p>
        pub fn threshold(mut self, input: i32) -> Self {
            self.threshold = Some(input);
            self
        }
        /// <p>The value of N, when you specify an ATLEAST rule type. That is, Threshold is the number of controls that must be set when you specify an ATLEAST type.</p>
        pub fn set_threshold(mut self, input: std::option::Option<i32>) -> Self {
            self.threshold = input;
            self
        }
        /// <p>A rule can be one of the following: ATLEAST, AND, or OR.</p>
        pub fn r#type(mut self, input: crate::model::RuleType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>A rule can be one of the following: ATLEAST, AND, or OR.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::RuleType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`RuleConfig`](crate::model::RuleConfig)
        pub fn build(self) -> crate::model::RuleConfig {
            crate::model::RuleConfig {
                inverted: self.inverted.unwrap_or_default(),
                threshold: self.threshold.unwrap_or_default(),
                r#type: self.r#type,
            }
        }
    }
}
impl RuleConfig {
    /// Creates a new builder-style object to manufacture [`RuleConfig`](crate::model::RuleConfig)
    pub fn builder() -> crate::model::rule_config::Builder {
        crate::model::rule_config::Builder::default()
    }
}

/// <p>An enumerated type that determines how the evaluated rules are processed. RuleType can be one of the following:</p> <p>ATLEAST - At least N routing controls must be set. You specify N as the Threshold in the rule configuration.</p> <p>AND - All routing controls must be set. This is a shortcut for "At least N," where N is the total number of controls in the rule.</p> <p>OR - Any control must be set. This is a shortcut for "At least N," where N is 1.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RuleType {
    #[allow(missing_docs)] // documentation missing in model
    And,
    #[allow(missing_docs)] // documentation missing in model
    Atleast,
    #[allow(missing_docs)] // documentation missing in model
    Or,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RuleType {
    fn from(s: &str) -> Self {
        match s {
            "AND" => RuleType::And,
            "ATLEAST" => RuleType::Atleast,
            "OR" => RuleType::Or,
            other => RuleType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RuleType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RuleType::from(s))
    }
}
impl RuleType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RuleType::And => "AND",
            RuleType::Atleast => "ATLEAST",
            RuleType::Or => "OR",
            RuleType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AND", "ATLEAST", "OR"]
    }
}
impl AsRef<str> for RuleType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An assertion rule enforces that, when a routing control state is changed, the criteria set by the rule configuration is met. Otherwise, the change to the routing control is not accepted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssertionRule {
    /// <p>The routing controls that are part of transactions that are evaluated to determine if a request to change a routing control state is allowed. For example, you might include three routing controls, one for each of three Amazon Web Services Regions.</p>
    pub asserted_controls: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) of the control panel.</p>
    pub control_panel_arn: std::option::Option<std::string::String>,
    /// <p>Name of the assertion rule. You can use any non-white space character in the name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The criteria that you set for specific assertion controls (routing controls) that designate how many controls must be enabled as the result of a transaction. For example, if you have three assertion controls, you might specify atleast 2 for your rule configuration. This means that at least two assertion controls must be enabled, so that at least two Amazon Web Services Regions are enabled.</p>
    pub rule_config: std::option::Option<crate::model::RuleConfig>,
    /// <p>The Amazon Resource Name (ARN) of the assertion rule.</p>
    pub safety_rule_arn: std::option::Option<std::string::String>,
    /// <p>The deployment status of an assertion rule. Status can be one of the following: PENDING, DEPLOYED, PENDING_DELETION.</p>
    pub status: std::option::Option<crate::model::Status>,
    /// <p>An evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but you can choose a custom value.</p>
    pub wait_period_ms: i32,
}
impl std::fmt::Debug for AssertionRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssertionRule");
        formatter.field("asserted_controls", &self.asserted_controls);
        formatter.field("control_panel_arn", &self.control_panel_arn);
        formatter.field("name", &self.name);
        formatter.field("rule_config", &self.rule_config);
        formatter.field("safety_rule_arn", &self.safety_rule_arn);
        formatter.field("status", &self.status);
        formatter.field("wait_period_ms", &self.wait_period_ms);
        formatter.finish()
    }
}
/// See [`AssertionRule`](crate::model::AssertionRule)
pub mod assertion_rule {
    /// A builder for [`AssertionRule`](crate::model::AssertionRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asserted_controls: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) control_panel_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) rule_config: std::option::Option<crate::model::RuleConfig>,
        pub(crate) safety_rule_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::Status>,
        pub(crate) wait_period_ms: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `asserted_controls`.
        ///
        /// To override the contents of this collection use [`set_asserted_controls`](Self::set_asserted_controls).
        ///
        /// <p>The routing controls that are part of transactions that are evaluated to determine if a request to change a routing control state is allowed. For example, you might include three routing controls, one for each of three Amazon Web Services Regions.</p>
        pub fn asserted_controls(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.asserted_controls.unwrap_or_default();
            v.push(input.into());
            self.asserted_controls = Some(v);
            self
        }
        /// <p>The routing controls that are part of transactions that are evaluated to determine if a request to change a routing control state is allowed. For example, you might include three routing controls, one for each of three Amazon Web Services Regions.</p>
        pub fn set_asserted_controls(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.asserted_controls = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the control panel.</p>
        pub fn control_panel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_panel_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the control panel.</p>
        pub fn set_control_panel_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.control_panel_arn = input;
            self
        }
        /// <p>Name of the assertion rule. You can use any non-white space character in the name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Name of the assertion rule. You can use any non-white space character in the name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The criteria that you set for specific assertion controls (routing controls) that designate how many controls must be enabled as the result of a transaction. For example, if you have three assertion controls, you might specify atleast 2 for your rule configuration. This means that at least two assertion controls must be enabled, so that at least two Amazon Web Services Regions are enabled.</p>
        pub fn rule_config(mut self, input: crate::model::RuleConfig) -> Self {
            self.rule_config = Some(input);
            self
        }
        /// <p>The criteria that you set for specific assertion controls (routing controls) that designate how many controls must be enabled as the result of a transaction. For example, if you have three assertion controls, you might specify atleast 2 for your rule configuration. This means that at least two assertion controls must be enabled, so that at least two Amazon Web Services Regions are enabled.</p>
        pub fn set_rule_config(
            mut self,
            input: std::option::Option<crate::model::RuleConfig>,
        ) -> Self {
            self.rule_config = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assertion rule.</p>
        pub fn safety_rule_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.safety_rule_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assertion rule.</p>
        pub fn set_safety_rule_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.safety_rule_arn = input;
            self
        }
        /// <p>The deployment status of an assertion rule. Status can be one of the following: PENDING, DEPLOYED, PENDING_DELETION.</p>
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The deployment status of an assertion rule. Status can be one of the following: PENDING, DEPLOYED, PENDING_DELETION.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// <p>An evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but you can choose a custom value.</p>
        pub fn wait_period_ms(mut self, input: i32) -> Self {
            self.wait_period_ms = Some(input);
            self
        }
        /// <p>An evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but you can choose a custom value.</p>
        pub fn set_wait_period_ms(mut self, input: std::option::Option<i32>) -> Self {
            self.wait_period_ms = input;
            self
        }
        /// Consumes the builder and constructs a [`AssertionRule`](crate::model::AssertionRule)
        pub fn build(self) -> crate::model::AssertionRule {
            crate::model::AssertionRule {
                asserted_controls: self.asserted_controls,
                control_panel_arn: self.control_panel_arn,
                name: self.name,
                rule_config: self.rule_config,
                safety_rule_arn: self.safety_rule_arn,
                status: self.status,
                wait_period_ms: self.wait_period_ms.unwrap_or_default(),
            }
        }
    }
}
impl AssertionRule {
    /// Creates a new builder-style object to manufacture [`AssertionRule`](crate::model::AssertionRule)
    pub fn builder() -> crate::model::assertion_rule::Builder {
        crate::model::assertion_rule::Builder::default()
    }
}

/// <p>Update to a gating rule. You can update the name or the evaluation period (wait period). If you don't specify one of the items to update, the item is unchanged.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GatingRuleUpdate {
    /// <p>The name for the gating rule.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the gating rule.</p>
    pub safety_rule_arn: std::option::Option<std::string::String>,
    /// <p>An evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but you can choose a custom value.</p>
    pub wait_period_ms: i32,
}
impl std::fmt::Debug for GatingRuleUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GatingRuleUpdate");
        formatter.field("name", &self.name);
        formatter.field("safety_rule_arn", &self.safety_rule_arn);
        formatter.field("wait_period_ms", &self.wait_period_ms);
        formatter.finish()
    }
}
/// See [`GatingRuleUpdate`](crate::model::GatingRuleUpdate)
pub mod gating_rule_update {
    /// A builder for [`GatingRuleUpdate`](crate::model::GatingRuleUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) safety_rule_arn: std::option::Option<std::string::String>,
        pub(crate) wait_period_ms: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name for the gating rule.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for the gating rule.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gating rule.</p>
        pub fn safety_rule_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.safety_rule_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the gating rule.</p>
        pub fn set_safety_rule_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.safety_rule_arn = input;
            self
        }
        /// <p>An evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but you can choose a custom value.</p>
        pub fn wait_period_ms(mut self, input: i32) -> Self {
            self.wait_period_ms = Some(input);
            self
        }
        /// <p>An evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but you can choose a custom value.</p>
        pub fn set_wait_period_ms(mut self, input: std::option::Option<i32>) -> Self {
            self.wait_period_ms = input;
            self
        }
        /// Consumes the builder and constructs a [`GatingRuleUpdate`](crate::model::GatingRuleUpdate)
        pub fn build(self) -> crate::model::GatingRuleUpdate {
            crate::model::GatingRuleUpdate {
                name: self.name,
                safety_rule_arn: self.safety_rule_arn,
                wait_period_ms: self.wait_period_ms.unwrap_or_default(),
            }
        }
    }
}
impl GatingRuleUpdate {
    /// Creates a new builder-style object to manufacture [`GatingRuleUpdate`](crate::model::GatingRuleUpdate)
    pub fn builder() -> crate::model::gating_rule_update::Builder {
        crate::model::gating_rule_update::Builder::default()
    }
}

/// <p>An update to an assertion rule. You can update the name or the evaluation period (wait period). If you don't specify one of the items to update, the item is unchanged.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssertionRuleUpdate {
    /// <p>The name of the assertion rule. You can use any non-white space character in the name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the assertion rule.</p>
    pub safety_rule_arn: std::option::Option<std::string::String>,
    /// <p>An evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but you can choose a custom value.</p>
    pub wait_period_ms: i32,
}
impl std::fmt::Debug for AssertionRuleUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssertionRuleUpdate");
        formatter.field("name", &self.name);
        formatter.field("safety_rule_arn", &self.safety_rule_arn);
        formatter.field("wait_period_ms", &self.wait_period_ms);
        formatter.finish()
    }
}
/// See [`AssertionRuleUpdate`](crate::model::AssertionRuleUpdate)
pub mod assertion_rule_update {
    /// A builder for [`AssertionRuleUpdate`](crate::model::AssertionRuleUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) safety_rule_arn: std::option::Option<std::string::String>,
        pub(crate) wait_period_ms: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the assertion rule. You can use any non-white space character in the name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the assertion rule. You can use any non-white space character in the name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assertion rule.</p>
        pub fn safety_rule_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.safety_rule_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assertion rule.</p>
        pub fn set_safety_rule_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.safety_rule_arn = input;
            self
        }
        /// <p>An evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but you can choose a custom value.</p>
        pub fn wait_period_ms(mut self, input: i32) -> Self {
            self.wait_period_ms = Some(input);
            self
        }
        /// <p>An evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but you can choose a custom value.</p>
        pub fn set_wait_period_ms(mut self, input: std::option::Option<i32>) -> Self {
            self.wait_period_ms = input;
            self
        }
        /// Consumes the builder and constructs a [`AssertionRuleUpdate`](crate::model::AssertionRuleUpdate)
        pub fn build(self) -> crate::model::AssertionRuleUpdate {
            crate::model::AssertionRuleUpdate {
                name: self.name,
                safety_rule_arn: self.safety_rule_arn,
                wait_period_ms: self.wait_period_ms.unwrap_or_default(),
            }
        }
    }
}
impl AssertionRuleUpdate {
    /// Creates a new builder-style object to manufacture [`AssertionRuleUpdate`](crate::model::AssertionRuleUpdate)
    pub fn builder() -> crate::model::assertion_rule_update::Builder {
        crate::model::assertion_rule_update::Builder::default()
    }
}

/// <p>A routing control has one of two states: ON and OFF. You can map the routing control state to the state of an Amazon Route 53 health check, which can be used to control traffic routing.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RoutingControl {
    /// <p>The Amazon Resource Name (ARN) of the control panel that includes the routing control.</p>
    pub control_panel_arn: std::option::Option<std::string::String>,
    /// <p>The name of the routing control.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the routing control.</p>
    pub routing_control_arn: std::option::Option<std::string::String>,
    /// <p>The deployment status of a routing control. Status can be one of the following: PENDING, DEPLOYED, PENDING_DELETION.</p>
    pub status: std::option::Option<crate::model::Status>,
}
impl std::fmt::Debug for RoutingControl {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RoutingControl");
        formatter.field("control_panel_arn", &self.control_panel_arn);
        formatter.field("name", &self.name);
        formatter.field("routing_control_arn", &self.routing_control_arn);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`RoutingControl`](crate::model::RoutingControl)
pub mod routing_control {
    /// A builder for [`RoutingControl`](crate::model::RoutingControl)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) control_panel_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) routing_control_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::Status>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the control panel that includes the routing control.</p>
        pub fn control_panel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_panel_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the control panel that includes the routing control.</p>
        pub fn set_control_panel_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.control_panel_arn = input;
            self
        }
        /// <p>The name of the routing control.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the routing control.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the routing control.</p>
        pub fn routing_control_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.routing_control_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the routing control.</p>
        pub fn set_routing_control_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.routing_control_arn = input;
            self
        }
        /// <p>The deployment status of a routing control. Status can be one of the following: PENDING, DEPLOYED, PENDING_DELETION.</p>
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The deployment status of a routing control. Status can be one of the following: PENDING, DEPLOYED, PENDING_DELETION.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`RoutingControl`](crate::model::RoutingControl)
        pub fn build(self) -> crate::model::RoutingControl {
            crate::model::RoutingControl {
                control_panel_arn: self.control_panel_arn,
                name: self.name,
                routing_control_arn: self.routing_control_arn,
                status: self.status,
            }
        }
    }
}
impl RoutingControl {
    /// Creates a new builder-style object to manufacture [`RoutingControl`](crate::model::RoutingControl)
    pub fn builder() -> crate::model::routing_control::Builder {
        crate::model::routing_control::Builder::default()
    }
}

/// <p>A control panel represents a group of routing controls that can be changed together in a single transaction.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ControlPanel {
    /// <p>The Amazon Resource Name (ARN) of the cluster that includes the control panel.</p>
    pub cluster_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the control panel.</p>
    pub control_panel_arn: std::option::Option<std::string::String>,
    /// <p>A flag that Amazon Route 53 Application Recovery Controller sets to true to designate the default control panel for a cluster. When you create a cluster, Amazon Route 53 Application Recovery Controller creates a control panel, and sets this flag for that control panel. If you create a control panel yourself, this flag is set to false.</p>
    pub default_control_panel: bool,
    /// <p>The name of the control panel. You can use any non-white space character in the name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The number of routing controls in the control panel.</p>
    pub routing_control_count: i32,
    /// <p>The deployment status of control panel. Status can be one of the following: PENDING, DEPLOYED, PENDING_DELETION.</p>
    pub status: std::option::Option<crate::model::Status>,
}
impl std::fmt::Debug for ControlPanel {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ControlPanel");
        formatter.field("cluster_arn", &self.cluster_arn);
        formatter.field("control_panel_arn", &self.control_panel_arn);
        formatter.field("default_control_panel", &self.default_control_panel);
        formatter.field("name", &self.name);
        formatter.field("routing_control_count", &self.routing_control_count);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ControlPanel`](crate::model::ControlPanel)
pub mod control_panel {
    /// A builder for [`ControlPanel`](crate::model::ControlPanel)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_arn: std::option::Option<std::string::String>,
        pub(crate) control_panel_arn: std::option::Option<std::string::String>,
        pub(crate) default_control_panel: std::option::Option<bool>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) routing_control_count: std::option::Option<i32>,
        pub(crate) status: std::option::Option<crate::model::Status>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the cluster that includes the control panel.</p>
        pub fn cluster_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the cluster that includes the control panel.</p>
        pub fn set_cluster_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the control panel.</p>
        pub fn control_panel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_panel_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the control panel.</p>
        pub fn set_control_panel_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.control_panel_arn = input;
            self
        }
        /// <p>A flag that Amazon Route 53 Application Recovery Controller sets to true to designate the default control panel for a cluster. When you create a cluster, Amazon Route 53 Application Recovery Controller creates a control panel, and sets this flag for that control panel. If you create a control panel yourself, this flag is set to false.</p>
        pub fn default_control_panel(mut self, input: bool) -> Self {
            self.default_control_panel = Some(input);
            self
        }
        /// <p>A flag that Amazon Route 53 Application Recovery Controller sets to true to designate the default control panel for a cluster. When you create a cluster, Amazon Route 53 Application Recovery Controller creates a control panel, and sets this flag for that control panel. If you create a control panel yourself, this flag is set to false.</p>
        pub fn set_default_control_panel(mut self, input: std::option::Option<bool>) -> Self {
            self.default_control_panel = input;
            self
        }
        /// <p>The name of the control panel. You can use any non-white space character in the name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the control panel. You can use any non-white space character in the name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The number of routing controls in the control panel.</p>
        pub fn routing_control_count(mut self, input: i32) -> Self {
            self.routing_control_count = Some(input);
            self
        }
        /// <p>The number of routing controls in the control panel.</p>
        pub fn set_routing_control_count(mut self, input: std::option::Option<i32>) -> Self {
            self.routing_control_count = input;
            self
        }
        /// <p>The deployment status of control panel. Status can be one of the following: PENDING, DEPLOYED, PENDING_DELETION.</p>
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The deployment status of control panel. Status can be one of the following: PENDING, DEPLOYED, PENDING_DELETION.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ControlPanel`](crate::model::ControlPanel)
        pub fn build(self) -> crate::model::ControlPanel {
            crate::model::ControlPanel {
                cluster_arn: self.cluster_arn,
                control_panel_arn: self.control_panel_arn,
                default_control_panel: self.default_control_panel.unwrap_or_default(),
                name: self.name,
                routing_control_count: self.routing_control_count.unwrap_or_default(),
                status: self.status,
            }
        }
    }
}
impl ControlPanel {
    /// Creates a new builder-style object to manufacture [`ControlPanel`](crate::model::ControlPanel)
    pub fn builder() -> crate::model::control_panel::Builder {
        crate::model::control_panel::Builder::default()
    }
}

/// <p>A safety rule. A safety rule can be an assertion rule or a gating rule.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Rule {
    /// <p>An assertion rule enforces that, when a routing control state is changed, the criteria set by the rule configuration is met. Otherwise, the change to the routing control is not accepted.</p>
    pub assertion: std::option::Option<crate::model::AssertionRule>,
    /// <p>A gating rule verifies that a set of gating controls evaluates as true, based on a rule configuration that you specify. If the gating rule evaluates to true, Amazon Route 53 Application Recovery Controller allows a set of routing control state changes to run and complete against the set of target controls.</p>
    pub gating: std::option::Option<crate::model::GatingRule>,
}
impl std::fmt::Debug for Rule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Rule");
        formatter.field("assertion", &self.assertion);
        formatter.field("gating", &self.gating);
        formatter.finish()
    }
}
/// See [`Rule`](crate::model::Rule)
pub mod rule {
    /// A builder for [`Rule`](crate::model::Rule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assertion: std::option::Option<crate::model::AssertionRule>,
        pub(crate) gating: std::option::Option<crate::model::GatingRule>,
    }
    impl Builder {
        /// <p>An assertion rule enforces that, when a routing control state is changed, the criteria set by the rule configuration is met. Otherwise, the change to the routing control is not accepted.</p>
        pub fn assertion(mut self, input: crate::model::AssertionRule) -> Self {
            self.assertion = Some(input);
            self
        }
        /// <p>An assertion rule enforces that, when a routing control state is changed, the criteria set by the rule configuration is met. Otherwise, the change to the routing control is not accepted.</p>
        pub fn set_assertion(
            mut self,
            input: std::option::Option<crate::model::AssertionRule>,
        ) -> Self {
            self.assertion = input;
            self
        }
        /// <p>A gating rule verifies that a set of gating controls evaluates as true, based on a rule configuration that you specify. If the gating rule evaluates to true, Amazon Route 53 Application Recovery Controller allows a set of routing control state changes to run and complete against the set of target controls.</p>
        pub fn gating(mut self, input: crate::model::GatingRule) -> Self {
            self.gating = Some(input);
            self
        }
        /// <p>A gating rule verifies that a set of gating controls evaluates as true, based on a rule configuration that you specify. If the gating rule evaluates to true, Amazon Route 53 Application Recovery Controller allows a set of routing control state changes to run and complete against the set of target controls.</p>
        pub fn set_gating(mut self, input: std::option::Option<crate::model::GatingRule>) -> Self {
            self.gating = input;
            self
        }
        /// Consumes the builder and constructs a [`Rule`](crate::model::Rule)
        pub fn build(self) -> crate::model::Rule {
            crate::model::Rule {
                assertion: self.assertion,
                gating: self.gating,
            }
        }
    }
}
impl Rule {
    /// Creates a new builder-style object to manufacture [`Rule`](crate::model::Rule)
    pub fn builder() -> crate::model::rule::Builder {
        crate::model::rule::Builder::default()
    }
}

/// <p>A cluster is a set of five consensus-forming Regional endpoints that represent the infrastructure that hosts your routing controls. Typically, you host together on one cluster all of the routing controls for your applications.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Cluster {
    /// <p>The Amazon Resource Name (ARN) of the cluster.</p>
    pub cluster_arn: std::option::Option<std::string::String>,
    /// <p>Endpoints for a cluster. Specify one of these endpoints when you want to set or retrieve a routing control state in the cluster.</p> <p>To get or update the routing control state, see the Amazon Route 53 Application Recovery Controller Cluster (Data Plane) Actions.</p>
    pub cluster_endpoints: std::option::Option<std::vec::Vec<crate::model::ClusterEndpoint>>,
    /// <p>The name of the cluster.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Deployment status of a resource. Status can be one of the following: PENDING, DEPLOYED, PENDING_DELETION.</p>
    pub status: std::option::Option<crate::model::Status>,
}
impl std::fmt::Debug for Cluster {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Cluster");
        formatter.field("cluster_arn", &self.cluster_arn);
        formatter.field("cluster_endpoints", &self.cluster_endpoints);
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`Cluster`](crate::model::Cluster)
pub mod cluster {
    /// A builder for [`Cluster`](crate::model::Cluster)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_arn: std::option::Option<std::string::String>,
        pub(crate) cluster_endpoints:
            std::option::Option<std::vec::Vec<crate::model::ClusterEndpoint>>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::Status>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the cluster.</p>
        pub fn cluster_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the cluster.</p>
        pub fn set_cluster_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_arn = input;
            self
        }
        /// Appends an item to `cluster_endpoints`.
        ///
        /// To override the contents of this collection use [`set_cluster_endpoints`](Self::set_cluster_endpoints).
        ///
        /// <p>Endpoints for a cluster. Specify one of these endpoints when you want to set or retrieve a routing control state in the cluster.</p> <p>To get or update the routing control state, see the Amazon Route 53 Application Recovery Controller Cluster (Data Plane) Actions.</p>
        pub fn cluster_endpoints(
            mut self,
            input: impl Into<crate::model::ClusterEndpoint>,
        ) -> Self {
            let mut v = self.cluster_endpoints.unwrap_or_default();
            v.push(input.into());
            self.cluster_endpoints = Some(v);
            self
        }
        /// <p>Endpoints for a cluster. Specify one of these endpoints when you want to set or retrieve a routing control state in the cluster.</p> <p>To get or update the routing control state, see the Amazon Route 53 Application Recovery Controller Cluster (Data Plane) Actions.</p>
        pub fn set_cluster_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ClusterEndpoint>>,
        ) -> Self {
            self.cluster_endpoints = input;
            self
        }
        /// <p>The name of the cluster.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the cluster.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Deployment status of a resource. Status can be one of the following: PENDING, DEPLOYED, PENDING_DELETION.</p>
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Deployment status of a resource. Status can be one of the following: PENDING, DEPLOYED, PENDING_DELETION.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`Cluster`](crate::model::Cluster)
        pub fn build(self) -> crate::model::Cluster {
            crate::model::Cluster {
                cluster_arn: self.cluster_arn,
                cluster_endpoints: self.cluster_endpoints,
                name: self.name,
                status: self.status,
            }
        }
    }
}
impl Cluster {
    /// Creates a new builder-style object to manufacture [`Cluster`](crate::model::Cluster)
    pub fn builder() -> crate::model::cluster::Builder {
        crate::model::cluster::Builder::default()
    }
}

/// <p>A cluster endpoint. Specify an endpoint when you want to set or retrieve a routing control state in the cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterEndpoint {
    /// <p>A cluster endpoint. Specify an endpoint and Amazon Web Services Region when you want to set or retrieve a routing control state in the cluster.</p> <p>To get or update the routing control state, see the Amazon Route 53 Application Recovery Controller Cluster (Data Plane) Actions.</p>
    pub endpoint: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services Region for a cluster endpoint.</p>
    pub region: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ClusterEndpoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterEndpoint");
        formatter.field("endpoint", &self.endpoint);
        formatter.field("region", &self.region);
        formatter.finish()
    }
}
/// See [`ClusterEndpoint`](crate::model::ClusterEndpoint)
pub mod cluster_endpoint {
    /// A builder for [`ClusterEndpoint`](crate::model::ClusterEndpoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A cluster endpoint. Specify an endpoint and Amazon Web Services Region when you want to set or retrieve a routing control state in the cluster.</p> <p>To get or update the routing control state, see the Amazon Route 53 Application Recovery Controller Cluster (Data Plane) Actions.</p>
        pub fn endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint = Some(input.into());
            self
        }
        /// <p>A cluster endpoint. Specify an endpoint and Amazon Web Services Region when you want to set or retrieve a routing control state in the cluster.</p> <p>To get or update the routing control state, see the Amazon Route 53 Application Recovery Controller Cluster (Data Plane) Actions.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint = input;
            self
        }
        /// <p>The Amazon Web Services Region for a cluster endpoint.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region for a cluster endpoint.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterEndpoint`](crate::model::ClusterEndpoint)
        pub fn build(self) -> crate::model::ClusterEndpoint {
            crate::model::ClusterEndpoint {
                endpoint: self.endpoint,
                region: self.region,
            }
        }
    }
}
impl ClusterEndpoint {
    /// Creates a new builder-style object to manufacture [`ClusterEndpoint`](crate::model::ClusterEndpoint)
    pub fn builder() -> crate::model::cluster_endpoint::Builder {
        crate::model::cluster_endpoint::Builder::default()
    }
}

/// <p>A new gating rule for a control panel.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NewGatingRule {
    /// <p>The Amazon Resource Name (ARN) of the control panel.</p>
    pub control_panel_arn: std::option::Option<std::string::String>,
    /// <p>The gating controls for the new gating rule. That is, routing controls that are evaluated by the rule configuration that you specify.</p>
    pub gating_controls: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name for the new gating rule.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The criteria that you set for specific gating controls (routing controls) that designates how many controls must be enabled to allow you to change (set or unset) the target controls.</p>
    pub rule_config: std::option::Option<crate::model::RuleConfig>,
    /// <p>Routing controls that can only be set or unset if the specified RuleConfig evaluates to true for the specified GatingControls. For example, say you have three gating controls, one for each of three Amazon Web Services Regions. Now you specify AtLeast 2 as your RuleConfig. With these settings, you can only change (set or unset) the routing controls that you have specified as TargetControls if that rule evaluates to true.</p> <p>In other words, your ability to change the routing controls that you have specified as TargetControls is gated by the rule that you set for the routing controls in GatingControls.</p>
    pub target_controls: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but you can choose a custom value.</p>
    pub wait_period_ms: i32,
}
impl std::fmt::Debug for NewGatingRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NewGatingRule");
        formatter.field("control_panel_arn", &self.control_panel_arn);
        formatter.field("gating_controls", &self.gating_controls);
        formatter.field("name", &self.name);
        formatter.field("rule_config", &self.rule_config);
        formatter.field("target_controls", &self.target_controls);
        formatter.field("wait_period_ms", &self.wait_period_ms);
        formatter.finish()
    }
}
/// See [`NewGatingRule`](crate::model::NewGatingRule)
pub mod new_gating_rule {
    /// A builder for [`NewGatingRule`](crate::model::NewGatingRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) control_panel_arn: std::option::Option<std::string::String>,
        pub(crate) gating_controls: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) rule_config: std::option::Option<crate::model::RuleConfig>,
        pub(crate) target_controls: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) wait_period_ms: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the control panel.</p>
        pub fn control_panel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_panel_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the control panel.</p>
        pub fn set_control_panel_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.control_panel_arn = input;
            self
        }
        /// Appends an item to `gating_controls`.
        ///
        /// To override the contents of this collection use [`set_gating_controls`](Self::set_gating_controls).
        ///
        /// <p>The gating controls for the new gating rule. That is, routing controls that are evaluated by the rule configuration that you specify.</p>
        pub fn gating_controls(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.gating_controls.unwrap_or_default();
            v.push(input.into());
            self.gating_controls = Some(v);
            self
        }
        /// <p>The gating controls for the new gating rule. That is, routing controls that are evaluated by the rule configuration that you specify.</p>
        pub fn set_gating_controls(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.gating_controls = input;
            self
        }
        /// <p>The name for the new gating rule.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for the new gating rule.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The criteria that you set for specific gating controls (routing controls) that designates how many controls must be enabled to allow you to change (set or unset) the target controls.</p>
        pub fn rule_config(mut self, input: crate::model::RuleConfig) -> Self {
            self.rule_config = Some(input);
            self
        }
        /// <p>The criteria that you set for specific gating controls (routing controls) that designates how many controls must be enabled to allow you to change (set or unset) the target controls.</p>
        pub fn set_rule_config(
            mut self,
            input: std::option::Option<crate::model::RuleConfig>,
        ) -> Self {
            self.rule_config = input;
            self
        }
        /// Appends an item to `target_controls`.
        ///
        /// To override the contents of this collection use [`set_target_controls`](Self::set_target_controls).
        ///
        /// <p>Routing controls that can only be set or unset if the specified RuleConfig evaluates to true for the specified GatingControls. For example, say you have three gating controls, one for each of three Amazon Web Services Regions. Now you specify AtLeast 2 as your RuleConfig. With these settings, you can only change (set or unset) the routing controls that you have specified as TargetControls if that rule evaluates to true.</p> <p>In other words, your ability to change the routing controls that you have specified as TargetControls is gated by the rule that you set for the routing controls in GatingControls.</p>
        pub fn target_controls(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.target_controls.unwrap_or_default();
            v.push(input.into());
            self.target_controls = Some(v);
            self
        }
        /// <p>Routing controls that can only be set or unset if the specified RuleConfig evaluates to true for the specified GatingControls. For example, say you have three gating controls, one for each of three Amazon Web Services Regions. Now you specify AtLeast 2 as your RuleConfig. With these settings, you can only change (set or unset) the routing controls that you have specified as TargetControls if that rule evaluates to true.</p> <p>In other words, your ability to change the routing controls that you have specified as TargetControls is gated by the rule that you set for the routing controls in GatingControls.</p>
        pub fn set_target_controls(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.target_controls = input;
            self
        }
        /// <p>An evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but you can choose a custom value.</p>
        pub fn wait_period_ms(mut self, input: i32) -> Self {
            self.wait_period_ms = Some(input);
            self
        }
        /// <p>An evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but you can choose a custom value.</p>
        pub fn set_wait_period_ms(mut self, input: std::option::Option<i32>) -> Self {
            self.wait_period_ms = input;
            self
        }
        /// Consumes the builder and constructs a [`NewGatingRule`](crate::model::NewGatingRule)
        pub fn build(self) -> crate::model::NewGatingRule {
            crate::model::NewGatingRule {
                control_panel_arn: self.control_panel_arn,
                gating_controls: self.gating_controls,
                name: self.name,
                rule_config: self.rule_config,
                target_controls: self.target_controls,
                wait_period_ms: self.wait_period_ms.unwrap_or_default(),
            }
        }
    }
}
impl NewGatingRule {
    /// Creates a new builder-style object to manufacture [`NewGatingRule`](crate::model::NewGatingRule)
    pub fn builder() -> crate::model::new_gating_rule::Builder {
        crate::model::new_gating_rule::Builder::default()
    }
}

/// <p>A new assertion rule for a control panel.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NewAssertionRule {
    /// <p>The routing controls that are part of transactions that are evaluated to determine if a request to change a routing control state is allowed. For example, you might include three routing controls, one for each of three Amazon Web Services Regions.</p>
    pub asserted_controls: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) for the control panel.</p>
    pub control_panel_arn: std::option::Option<std::string::String>,
    /// <p>The name of the assertion rule. You can use any non-white space character in the name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The criteria that you set for specific assertion controls (routing controls) that designate how many controls must be enabled as the result of a transaction. For example, if you have three assertion controls, you might specify atleast 2 for your rule configuration. This means that at least two assertion controls must be enabled, so that at least two Amazon Web Services Regions are enabled.</p>
    pub rule_config: std::option::Option<crate::model::RuleConfig>,
    /// <p>An evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but you can choose a custom value.</p>
    pub wait_period_ms: i32,
}
impl std::fmt::Debug for NewAssertionRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NewAssertionRule");
        formatter.field("asserted_controls", &self.asserted_controls);
        formatter.field("control_panel_arn", &self.control_panel_arn);
        formatter.field("name", &self.name);
        formatter.field("rule_config", &self.rule_config);
        formatter.field("wait_period_ms", &self.wait_period_ms);
        formatter.finish()
    }
}
/// See [`NewAssertionRule`](crate::model::NewAssertionRule)
pub mod new_assertion_rule {
    /// A builder for [`NewAssertionRule`](crate::model::NewAssertionRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asserted_controls: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) control_panel_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) rule_config: std::option::Option<crate::model::RuleConfig>,
        pub(crate) wait_period_ms: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `asserted_controls`.
        ///
        /// To override the contents of this collection use [`set_asserted_controls`](Self::set_asserted_controls).
        ///
        /// <p>The routing controls that are part of transactions that are evaluated to determine if a request to change a routing control state is allowed. For example, you might include three routing controls, one for each of three Amazon Web Services Regions.</p>
        pub fn asserted_controls(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.asserted_controls.unwrap_or_default();
            v.push(input.into());
            self.asserted_controls = Some(v);
            self
        }
        /// <p>The routing controls that are part of transactions that are evaluated to determine if a request to change a routing control state is allowed. For example, you might include three routing controls, one for each of three Amazon Web Services Regions.</p>
        pub fn set_asserted_controls(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.asserted_controls = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the control panel.</p>
        pub fn control_panel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_panel_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the control panel.</p>
        pub fn set_control_panel_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.control_panel_arn = input;
            self
        }
        /// <p>The name of the assertion rule. You can use any non-white space character in the name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the assertion rule. You can use any non-white space character in the name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The criteria that you set for specific assertion controls (routing controls) that designate how many controls must be enabled as the result of a transaction. For example, if you have three assertion controls, you might specify atleast 2 for your rule configuration. This means that at least two assertion controls must be enabled, so that at least two Amazon Web Services Regions are enabled.</p>
        pub fn rule_config(mut self, input: crate::model::RuleConfig) -> Self {
            self.rule_config = Some(input);
            self
        }
        /// <p>The criteria that you set for specific assertion controls (routing controls) that designate how many controls must be enabled as the result of a transaction. For example, if you have three assertion controls, you might specify atleast 2 for your rule configuration. This means that at least two assertion controls must be enabled, so that at least two Amazon Web Services Regions are enabled.</p>
        pub fn set_rule_config(
            mut self,
            input: std::option::Option<crate::model::RuleConfig>,
        ) -> Self {
            self.rule_config = input;
            self
        }
        /// <p>An evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but you can choose a custom value.</p>
        pub fn wait_period_ms(mut self, input: i32) -> Self {
            self.wait_period_ms = Some(input);
            self
        }
        /// <p>An evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but you can choose a custom value.</p>
        pub fn set_wait_period_ms(mut self, input: std::option::Option<i32>) -> Self {
            self.wait_period_ms = input;
            self
        }
        /// Consumes the builder and constructs a [`NewAssertionRule`](crate::model::NewAssertionRule)
        pub fn build(self) -> crate::model::NewAssertionRule {
            crate::model::NewAssertionRule {
                asserted_controls: self.asserted_controls,
                control_panel_arn: self.control_panel_arn,
                name: self.name,
                rule_config: self.rule_config,
                wait_period_ms: self.wait_period_ms.unwrap_or_default(),
            }
        }
    }
}
impl NewAssertionRule {
    /// Creates a new builder-style object to manufacture [`NewAssertionRule`](crate::model::NewAssertionRule)
    pub fn builder() -> crate::model::new_assertion_rule::Builder {
        crate::model::new_assertion_rule::Builder::default()
    }
}
