// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>There was a validation error on the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationExceptionField {
    /// <p>The field that had the validation exception.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Information about the validation exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ValidationExceptionField {
    /// <p>The field that had the validation exception.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Information about the validation exception.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for ValidationExceptionField {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationExceptionField");
        formatter.field("name", &self.name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ValidationExceptionField`](crate::model::ValidationExceptionField)
pub mod validation_exception_field {
    /// A builder for [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The field that had the validation exception.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The field that had the validation exception.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Information about the validation exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Information about the validation exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationExceptionField`](crate::model::ValidationExceptionField)
        pub fn build(self) -> crate::model::ValidationExceptionField {
            crate::model::ValidationExceptionField {
                name: self.name,
                message: self.message,
            }
        }
    }
}
impl ValidationExceptionField {
    /// Creates a new builder-style object to manufacture [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    pub fn builder() -> crate::model::validation_exception_field::Builder {
        crate::model::validation_exception_field::Builder::default()
    }
}

/// Reason the request failed validation
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ValidationExceptionReason {
    #[allow(missing_docs)] // documentation missing in model
    CannotParse,
    #[allow(missing_docs)] // documentation missing in model
    FieldValidationFailed,
    #[allow(missing_docs)] // documentation missing in model
    Other,
    #[allow(missing_docs)] // documentation missing in model
    UnknownOperation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ValidationExceptionReason {
    fn from(s: &str) -> Self {
        match s {
            "cannotParse" => ValidationExceptionReason::CannotParse,
            "fieldValidationFailed" => ValidationExceptionReason::FieldValidationFailed,
            "other" => ValidationExceptionReason::Other,
            "unknownOperation" => ValidationExceptionReason::UnknownOperation,
            other => ValidationExceptionReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ValidationExceptionReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ValidationExceptionReason::from(s))
    }
}
impl ValidationExceptionReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ValidationExceptionReason::CannotParse => "cannotParse",
            ValidationExceptionReason::FieldValidationFailed => "fieldValidationFailed",
            ValidationExceptionReason::Other => "other",
            ValidationExceptionReason::UnknownOperation => "unknownOperation",
            ValidationExceptionReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "cannotParse",
            "fieldValidationFailed",
            "other",
            "unknownOperation",
        ]
    }
}
impl AsRef<str> for ValidationExceptionReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A routing control state entry.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRoutingControlStateEntry {
    /// <p>The Amazon Resource Name (ARN) for a routing control state entry.</p>
    pub routing_control_arn: std::option::Option<std::string::String>,
    /// <p>The routing control state in a set of routing control state entries.</p>
    pub routing_control_state: std::option::Option<crate::model::RoutingControlState>,
}
impl UpdateRoutingControlStateEntry {
    /// <p>The Amazon Resource Name (ARN) for a routing control state entry.</p>
    pub fn routing_control_arn(&self) -> std::option::Option<&str> {
        self.routing_control_arn.as_deref()
    }
    /// <p>The routing control state in a set of routing control state entries.</p>
    pub fn routing_control_state(&self) -> std::option::Option<&crate::model::RoutingControlState> {
        self.routing_control_state.as_ref()
    }
}
impl std::fmt::Debug for UpdateRoutingControlStateEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRoutingControlStateEntry");
        formatter.field("routing_control_arn", &self.routing_control_arn);
        formatter.field("routing_control_state", &self.routing_control_state);
        formatter.finish()
    }
}
/// See [`UpdateRoutingControlStateEntry`](crate::model::UpdateRoutingControlStateEntry)
pub mod update_routing_control_state_entry {
    /// A builder for [`UpdateRoutingControlStateEntry`](crate::model::UpdateRoutingControlStateEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) routing_control_arn: std::option::Option<std::string::String>,
        pub(crate) routing_control_state: std::option::Option<crate::model::RoutingControlState>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for a routing control state entry.</p>
        pub fn routing_control_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.routing_control_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for a routing control state entry.</p>
        pub fn set_routing_control_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.routing_control_arn = input;
            self
        }
        /// <p>The routing control state in a set of routing control state entries.</p>
        pub fn routing_control_state(mut self, input: crate::model::RoutingControlState) -> Self {
            self.routing_control_state = Some(input);
            self
        }
        /// <p>The routing control state in a set of routing control state entries.</p>
        pub fn set_routing_control_state(
            mut self,
            input: std::option::Option<crate::model::RoutingControlState>,
        ) -> Self {
            self.routing_control_state = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRoutingControlStateEntry`](crate::model::UpdateRoutingControlStateEntry)
        pub fn build(self) -> crate::model::UpdateRoutingControlStateEntry {
            crate::model::UpdateRoutingControlStateEntry {
                routing_control_arn: self.routing_control_arn,
                routing_control_state: self.routing_control_state,
            }
        }
    }
}
impl UpdateRoutingControlStateEntry {
    /// Creates a new builder-style object to manufacture [`UpdateRoutingControlStateEntry`](crate::model::UpdateRoutingControlStateEntry)
    pub fn builder() -> crate::model::update_routing_control_state_entry::Builder {
        crate::model::update_routing_control_state_entry::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RoutingControlState {
    #[allow(missing_docs)] // documentation missing in model
    Off,
    #[allow(missing_docs)] // documentation missing in model
    On,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RoutingControlState {
    fn from(s: &str) -> Self {
        match s {
            "Off" => RoutingControlState::Off,
            "On" => RoutingControlState::On,
            other => RoutingControlState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RoutingControlState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RoutingControlState::from(s))
    }
}
impl RoutingControlState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RoutingControlState::Off => "Off",
            RoutingControlState::On => "On",
            RoutingControlState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Off", "On"]
    }
}
impl AsRef<str> for RoutingControlState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A routing control, which is a simple on/off switch that you can use to route traffic to cells. When a routing control state is On, traffic flows to a cell. When the state is Off, traffic does not flow. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RoutingControl {
    /// <p>The Amazon Resource Name (ARN) of the control panel where the routing control is located.</p>
    pub control_panel_arn: std::option::Option<std::string::String>,
    /// <p>The name of the control panel where the routing control is located.</p>
    pub control_panel_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the routing control.</p>
    pub routing_control_arn: std::option::Option<std::string::String>,
    /// <p>The name of the routing control.</p>
    pub routing_control_name: std::option::Option<std::string::String>,
    /// <p>The current state of the routing control. When a routing control state is On, traffic flows to a cell. When the state is Off, traffic does not flow. </p>
    pub routing_control_state: std::option::Option<crate::model::RoutingControlState>,
}
impl RoutingControl {
    /// <p>The Amazon Resource Name (ARN) of the control panel where the routing control is located.</p>
    pub fn control_panel_arn(&self) -> std::option::Option<&str> {
        self.control_panel_arn.as_deref()
    }
    /// <p>The name of the control panel where the routing control is located.</p>
    pub fn control_panel_name(&self) -> std::option::Option<&str> {
        self.control_panel_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the routing control.</p>
    pub fn routing_control_arn(&self) -> std::option::Option<&str> {
        self.routing_control_arn.as_deref()
    }
    /// <p>The name of the routing control.</p>
    pub fn routing_control_name(&self) -> std::option::Option<&str> {
        self.routing_control_name.as_deref()
    }
    /// <p>The current state of the routing control. When a routing control state is On, traffic flows to a cell. When the state is Off, traffic does not flow. </p>
    pub fn routing_control_state(&self) -> std::option::Option<&crate::model::RoutingControlState> {
        self.routing_control_state.as_ref()
    }
}
impl std::fmt::Debug for RoutingControl {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RoutingControl");
        formatter.field("control_panel_arn", &self.control_panel_arn);
        formatter.field("control_panel_name", &self.control_panel_name);
        formatter.field("routing_control_arn", &self.routing_control_arn);
        formatter.field("routing_control_name", &self.routing_control_name);
        formatter.field("routing_control_state", &self.routing_control_state);
        formatter.finish()
    }
}
/// See [`RoutingControl`](crate::model::RoutingControl)
pub mod routing_control {
    /// A builder for [`RoutingControl`](crate::model::RoutingControl)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) control_panel_arn: std::option::Option<std::string::String>,
        pub(crate) control_panel_name: std::option::Option<std::string::String>,
        pub(crate) routing_control_arn: std::option::Option<std::string::String>,
        pub(crate) routing_control_name: std::option::Option<std::string::String>,
        pub(crate) routing_control_state: std::option::Option<crate::model::RoutingControlState>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the control panel where the routing control is located.</p>
        pub fn control_panel_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_panel_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the control panel where the routing control is located.</p>
        pub fn set_control_panel_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.control_panel_arn = input;
            self
        }
        /// <p>The name of the control panel where the routing control is located.</p>
        pub fn control_panel_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_panel_name = Some(input.into());
            self
        }
        /// <p>The name of the control panel where the routing control is located.</p>
        pub fn set_control_panel_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.control_panel_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the routing control.</p>
        pub fn routing_control_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.routing_control_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the routing control.</p>
        pub fn set_routing_control_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.routing_control_arn = input;
            self
        }
        /// <p>The name of the routing control.</p>
        pub fn routing_control_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.routing_control_name = Some(input.into());
            self
        }
        /// <p>The name of the routing control.</p>
        pub fn set_routing_control_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.routing_control_name = input;
            self
        }
        /// <p>The current state of the routing control. When a routing control state is On, traffic flows to a cell. When the state is Off, traffic does not flow. </p>
        pub fn routing_control_state(mut self, input: crate::model::RoutingControlState) -> Self {
            self.routing_control_state = Some(input);
            self
        }
        /// <p>The current state of the routing control. When a routing control state is On, traffic flows to a cell. When the state is Off, traffic does not flow. </p>
        pub fn set_routing_control_state(
            mut self,
            input: std::option::Option<crate::model::RoutingControlState>,
        ) -> Self {
            self.routing_control_state = input;
            self
        }
        /// Consumes the builder and constructs a [`RoutingControl`](crate::model::RoutingControl)
        pub fn build(self) -> crate::model::RoutingControl {
            crate::model::RoutingControl {
                control_panel_arn: self.control_panel_arn,
                control_panel_name: self.control_panel_name,
                routing_control_arn: self.routing_control_arn,
                routing_control_name: self.routing_control_name,
                routing_control_state: self.routing_control_state,
            }
        }
    }
}
impl RoutingControl {
    /// Creates a new builder-style object to manufacture [`RoutingControl`](crate::model::RoutingControl)
    pub fn builder() -> crate::model::routing_control::Builder {
        crate::model::routing_control::Builder::default()
    }
}
