// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `GetRoutingControlState` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRoutingControlStateError {
    /// Kind of error that occurred.
    pub kind: GetRoutingControlStateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRoutingControlState` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRoutingControlStateErrorKind {
    /// <p>You don't have sufficient permissions to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The cluster endpoint isn't available. Try another cluster endpoint.</p>
    EndpointTemporarilyUnavailableException(crate::error::EndpointTemporarilyUnavailableException),
    /// <p>There was an unexpected error during processing of the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a routing control or control panel that was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because of request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There was a validation error on the request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRoutingControlStateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRoutingControlStateErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetRoutingControlStateErrorKind::EndpointTemporarilyUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            GetRoutingControlStateErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetRoutingControlStateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetRoutingControlStateErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetRoutingControlStateErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetRoutingControlStateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRoutingControlStateError {
    fn code(&self) -> Option<&str> {
        GetRoutingControlStateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRoutingControlStateError {
    /// Creates a new `GetRoutingControlStateError`.
    pub fn new(kind: GetRoutingControlStateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRoutingControlStateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRoutingControlStateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRoutingControlStateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRoutingControlStateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRoutingControlStateErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRoutingControlStateErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRoutingControlStateErrorKind::EndpointTemporarilyUnavailableException`.
    pub fn is_endpoint_temporarily_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRoutingControlStateErrorKind::EndpointTemporarilyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRoutingControlStateErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRoutingControlStateErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRoutingControlStateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRoutingControlStateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRoutingControlStateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRoutingControlStateErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRoutingControlStateErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRoutingControlStateErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetRoutingControlStateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRoutingControlStateErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetRoutingControlStateErrorKind::EndpointTemporarilyUnavailableException(_inner) => {
                Some(_inner)
            }
            GetRoutingControlStateErrorKind::InternalServerException(_inner) => Some(_inner),
            GetRoutingControlStateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetRoutingControlStateErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetRoutingControlStateErrorKind::ValidationException(_inner) => Some(_inner),
            GetRoutingControlStateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRoutingControls` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRoutingControlsError {
    /// Kind of error that occurred.
    pub kind: ListRoutingControlsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRoutingControls` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRoutingControlsErrorKind {
    /// <p>You don't have sufficient permissions to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The cluster endpoint isn't available. Try another cluster endpoint.</p>
    EndpointTemporarilyUnavailableException(crate::error::EndpointTemporarilyUnavailableException),
    /// <p>There was an unexpected error during processing of the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a routing control or control panel that was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because of request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There was a validation error on the request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRoutingControlsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRoutingControlsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListRoutingControlsErrorKind::EndpointTemporarilyUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            ListRoutingControlsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListRoutingControlsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListRoutingControlsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListRoutingControlsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListRoutingControlsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRoutingControlsError {
    fn code(&self) -> Option<&str> {
        ListRoutingControlsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRoutingControlsError {
    /// Creates a new `ListRoutingControlsError`.
    pub fn new(kind: ListRoutingControlsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRoutingControlsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRoutingControlsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRoutingControlsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRoutingControlsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRoutingControlsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRoutingControlsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRoutingControlsErrorKind::EndpointTemporarilyUnavailableException`.
    pub fn is_endpoint_temporarily_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRoutingControlsErrorKind::EndpointTemporarilyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRoutingControlsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRoutingControlsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRoutingControlsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRoutingControlsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRoutingControlsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRoutingControlsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRoutingControlsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRoutingControlsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListRoutingControlsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRoutingControlsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListRoutingControlsErrorKind::EndpointTemporarilyUnavailableException(_inner) => {
                Some(_inner)
            }
            ListRoutingControlsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListRoutingControlsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListRoutingControlsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListRoutingControlsErrorKind::ValidationException(_inner) => Some(_inner),
            ListRoutingControlsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateRoutingControlState` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateRoutingControlStateError {
    /// Kind of error that occurred.
    pub kind: UpdateRoutingControlStateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateRoutingControlState` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateRoutingControlStateErrorKind {
    /// <p>You don't have sufficient permissions to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict with this request. Try again.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The cluster endpoint isn't available. Try another cluster endpoint.</p>
    EndpointTemporarilyUnavailableException(crate::error::EndpointTemporarilyUnavailableException),
    /// <p>There was an unexpected error during processing of the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a routing control or control panel that was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied because of request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There was a validation error on the request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateRoutingControlStateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateRoutingControlStateErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateRoutingControlStateErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateRoutingControlStateErrorKind::EndpointTemporarilyUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            UpdateRoutingControlStateErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateRoutingControlStateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateRoutingControlStateErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateRoutingControlStateErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateRoutingControlStateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateRoutingControlStateError {
    fn code(&self) -> Option<&str> {
        UpdateRoutingControlStateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateRoutingControlStateError {
    /// Creates a new `UpdateRoutingControlStateError`.
    pub fn new(kind: UpdateRoutingControlStateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateRoutingControlStateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateRoutingControlStateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateRoutingControlStateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateRoutingControlStateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateRoutingControlStateErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoutingControlStateErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRoutingControlStateErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoutingControlStateErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRoutingControlStateErrorKind::EndpointTemporarilyUnavailableException`.
    pub fn is_endpoint_temporarily_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoutingControlStateErrorKind::EndpointTemporarilyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRoutingControlStateErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoutingControlStateErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRoutingControlStateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoutingControlStateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRoutingControlStateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoutingControlStateErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRoutingControlStateErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoutingControlStateErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateRoutingControlStateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateRoutingControlStateErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateRoutingControlStateErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateRoutingControlStateErrorKind::EndpointTemporarilyUnavailableException(_inner) => {
                Some(_inner)
            }
            UpdateRoutingControlStateErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateRoutingControlStateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateRoutingControlStateErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateRoutingControlStateErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateRoutingControlStateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateRoutingControlStates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateRoutingControlStatesError {
    /// Kind of error that occurred.
    pub kind: UpdateRoutingControlStatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateRoutingControlStates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateRoutingControlStatesErrorKind {
    /// <p>You don't have sufficient permissions to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict with this request. Try again.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The cluster endpoint isn't available. Try another cluster endpoint.</p>
    EndpointTemporarilyUnavailableException(crate::error::EndpointTemporarilyUnavailableException),
    /// <p>There was an unexpected error during processing of the request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request references a routing control or control panel that was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request can't update that many routing control states at the same time. Try again with fewer routing control states.</p>
    ServiceLimitExceededException(crate::error::ServiceLimitExceededException),
    /// <p>The request was denied because of request throttling.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>There was a validation error on the request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateRoutingControlStatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateRoutingControlStatesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateRoutingControlStatesErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateRoutingControlStatesErrorKind::EndpointTemporarilyUnavailableException(
                _inner,
            ) => _inner.fmt(f),
            UpdateRoutingControlStatesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateRoutingControlStatesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateRoutingControlStatesErrorKind::ServiceLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            UpdateRoutingControlStatesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateRoutingControlStatesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateRoutingControlStatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateRoutingControlStatesError {
    fn code(&self) -> Option<&str> {
        UpdateRoutingControlStatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateRoutingControlStatesError {
    /// Creates a new `UpdateRoutingControlStatesError`.
    pub fn new(kind: UpdateRoutingControlStatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateRoutingControlStatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateRoutingControlStatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateRoutingControlStatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateRoutingControlStatesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateRoutingControlStatesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoutingControlStatesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRoutingControlStatesErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoutingControlStatesErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRoutingControlStatesErrorKind::EndpointTemporarilyUnavailableException`.
    pub fn is_endpoint_temporarily_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoutingControlStatesErrorKind::EndpointTemporarilyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRoutingControlStatesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoutingControlStatesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRoutingControlStatesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoutingControlStatesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRoutingControlStatesErrorKind::ServiceLimitExceededException`.
    pub fn is_service_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoutingControlStatesErrorKind::ServiceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRoutingControlStatesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoutingControlStatesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRoutingControlStatesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoutingControlStatesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateRoutingControlStatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateRoutingControlStatesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateRoutingControlStatesErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateRoutingControlStatesErrorKind::EndpointTemporarilyUnavailableException(
                _inner,
            ) => Some(_inner),
            UpdateRoutingControlStatesErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateRoutingControlStatesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateRoutingControlStatesErrorKind::ServiceLimitExceededException(_inner) => {
                Some(_inner)
            }
            UpdateRoutingControlStatesErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateRoutingControlStatesErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateRoutingControlStatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>There was a validation error on the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// Reason the request failed validation
    pub reason: std::option::Option<crate::model::ValidationExceptionReason>,
    /// The fields that caused the error, if applicable
    pub fields: std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
}
impl ValidationException {
    /// Reason the request failed validation
    pub fn reason(&self) -> std::option::Option<&crate::model::ValidationExceptionReason> {
        self.reason.as_ref()
    }
    /// The fields that caused the error, if applicable
    pub fn fields(&self) -> std::option::Option<&[crate::model::ValidationExceptionField]> {
        self.fields.as_deref()
    }
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.field("reason", &self.reason);
        formatter.field("fields", &self.fields);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<crate::model::ValidationExceptionReason>,
        pub(crate) fields:
            std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Reason the request failed validation
        pub fn reason(mut self, input: crate::model::ValidationExceptionReason) -> Self {
            self.reason = Some(input);
            self
        }
        /// Reason the request failed validation
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::ValidationExceptionReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// Appends an item to `fields`.
        ///
        /// To override the contents of this collection use [`set_fields`](Self::set_fields).
        ///
        /// The fields that caused the error, if applicable
        pub fn fields(mut self, input: crate::model::ValidationExceptionField) -> Self {
            let mut v = self.fields.unwrap_or_default();
            v.push(input);
            self.fields = Some(v);
            self
        }
        /// The fields that caused the error, if applicable
        pub fn set_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
        ) -> Self {
            self.fields = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
                reason: self.reason,
                fields: self.fields,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>The request was denied because of request throttling.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// Advice to clients on when the call can be safely retried
    pub retry_after_seconds: i32,
}
impl ThrottlingException {
    /// Advice to clients on when the call can be safely retried
    pub fn retry_after_seconds(&self) -> i32 {
        self.retry_after_seconds
    }
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.field("retry_after_seconds", &self.retry_after_seconds);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) retry_after_seconds: std::option::Option<i32>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Advice to clients on when the call can be safely retried
        pub fn retry_after_seconds(mut self, input: i32) -> Self {
            self.retry_after_seconds = Some(input);
            self
        }
        /// Advice to clients on when the call can be safely retried
        pub fn set_retry_after_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.retry_after_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
                retry_after_seconds: self.retry_after_seconds.unwrap_or_default(),
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>The request can't update that many routing control states at the same time. Try again with fewer routing control states.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The resource identifier of the limit that was exceeded.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The resource type of the limit that was exceeded.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The code of the limit that was exceeded.</p>
    pub limit_code: std::option::Option<std::string::String>,
    /// <p>The service code of the limit that was exceeded.</p>
    pub service_code: std::option::Option<std::string::String>,
}
impl ServiceLimitExceededException {
    /// <p>The resource identifier of the limit that was exceeded.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The resource type of the limit that was exceeded.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The code of the limit that was exceeded.</p>
    pub fn limit_code(&self) -> std::option::Option<&str> {
        self.limit_code.as_deref()
    }
    /// <p>The service code of the limit that was exceeded.</p>
    pub fn service_code(&self) -> std::option::Option<&str> {
        self.service_code.as_deref()
    }
}
impl std::fmt::Debug for ServiceLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceLimitExceededException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("limit_code", &self.limit_code);
        formatter.field("service_code", &self.service_code);
        formatter.finish()
    }
}
impl ServiceLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceLimitExceededException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceLimitExceededException {}
/// See [`ServiceLimitExceededException`](crate::error::ServiceLimitExceededException)
pub mod service_limit_exceeded_exception {
    /// A builder for [`ServiceLimitExceededException`](crate::error::ServiceLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) limit_code: std::option::Option<std::string::String>,
        pub(crate) service_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The resource identifier of the limit that was exceeded.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The resource identifier of the limit that was exceeded.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The resource type of the limit that was exceeded.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The resource type of the limit that was exceeded.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The code of the limit that was exceeded.</p>
        pub fn limit_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.limit_code = Some(input.into());
            self
        }
        /// <p>The code of the limit that was exceeded.</p>
        pub fn set_limit_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.limit_code = input;
            self
        }
        /// <p>The service code of the limit that was exceeded.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_code = Some(input.into());
            self
        }
        /// <p>The service code of the limit that was exceeded.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_code = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceLimitExceededException`](crate::error::ServiceLimitExceededException)
        pub fn build(self) -> crate::error::ServiceLimitExceededException {
            crate::error::ServiceLimitExceededException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
                limit_code: self.limit_code,
                service_code: self.service_code,
            }
        }
    }
}
impl ServiceLimitExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceLimitExceededException`](crate::error::ServiceLimitExceededException)
    pub fn builder() -> crate::error::service_limit_exceeded_exception::Builder {
        crate::error::service_limit_exceeded_exception::Builder::default()
    }
}

/// <p>The request references a routing control or control panel that was not found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// Hypothetical resource identifier that was not found
    pub resource_id: std::option::Option<std::string::String>,
    /// Hypothetical resource type that was not found
    pub resource_type: std::option::Option<std::string::String>,
}
impl ResourceNotFoundException {
    /// Hypothetical resource identifier that was not found
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// Hypothetical resource type that was not found
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Hypothetical resource identifier that was not found
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// Hypothetical resource identifier that was not found
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Hypothetical resource type that was not found
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// Hypothetical resource type that was not found
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>There was an unexpected error during processing of the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// Advice to clients on when the call can be safely retried
    pub retry_after_seconds: i32,
}
impl InternalServerException {
    /// Advice to clients on when the call can be safely retried
    pub fn retry_after_seconds(&self) -> i32 {
        self.retry_after_seconds
    }
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.field("retry_after_seconds", &self.retry_after_seconds);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) retry_after_seconds: std::option::Option<i32>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Advice to clients on when the call can be safely retried
        pub fn retry_after_seconds(mut self, input: i32) -> Self {
            self.retry_after_seconds = Some(input);
            self
        }
        /// Advice to clients on when the call can be safely retried
        pub fn set_retry_after_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.retry_after_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
                retry_after_seconds: self.retry_after_seconds.unwrap_or_default(),
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p>The cluster endpoint isn't available. Try another cluster endpoint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EndpointTemporarilyUnavailableException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EndpointTemporarilyUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EndpointTemporarilyUnavailableException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl EndpointTemporarilyUnavailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EndpointTemporarilyUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "EndpointTemporarilyUnavailableException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for EndpointTemporarilyUnavailableException {}
/// See [`EndpointTemporarilyUnavailableException`](crate::error::EndpointTemporarilyUnavailableException)
pub mod endpoint_temporarily_unavailable_exception {
    /// A builder for [`EndpointTemporarilyUnavailableException`](crate::error::EndpointTemporarilyUnavailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EndpointTemporarilyUnavailableException`](crate::error::EndpointTemporarilyUnavailableException)
        pub fn build(self) -> crate::error::EndpointTemporarilyUnavailableException {
            crate::error::EndpointTemporarilyUnavailableException {
                message: self.message,
            }
        }
    }
}
impl EndpointTemporarilyUnavailableException {
    /// Creates a new builder-style object to manufacture [`EndpointTemporarilyUnavailableException`](crate::error::EndpointTemporarilyUnavailableException)
    pub fn builder() -> crate::error::endpoint_temporarily_unavailable_exception::Builder {
        crate::error::endpoint_temporarily_unavailable_exception::Builder::default()
    }
}

/// <p>There was a conflict with this request. Try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    /// Description of the ConflictException error
    pub message: std::option::Option<std::string::String>,
    /// Identifier of the resource in use
    pub resource_id: std::option::Option<std::string::String>,
    /// Type of the resource in use
    pub resource_type: std::option::Option<std::string::String>,
}
impl ConflictException {
    /// Identifier of the resource in use
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// Type of the resource in use
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Description of the ConflictException error
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// Description of the ConflictException error
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Identifier of the resource in use
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// Identifier of the resource in use
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Type of the resource in use
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// Type of the resource in use
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>You don't have sufficient permissions to perform this action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}
