// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AcceptDomainTransferFromAnotherAwsAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AcceptDomainTransferFromAnotherAwsAccountError {
    /// Kind of error that occurred.
    pub kind: AcceptDomainTransferFromAnotherAwsAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AcceptDomainTransferFromAnotherAwsAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AcceptDomainTransferFromAnotherAwsAccountErrorKind {
    /// <p>The number of domains has exceeded the allowed threshold for the account.</p>
    DomainLimitExceeded(crate::error::DomainLimitExceeded),
    /// <p>The requested item is not acceptable. For example, for APIs that accept a domain name, the request might specify a domain name that doesn't belong to the account that submitted the request. For <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The number of operations or jobs running exceeded the allowed threshold for the account.</p>
    OperationLimitExceeded(crate::error::OperationLimitExceeded),
    /// <p>Amazon Route 53 does not support this top-level domain (TLD).</p>
    UnsupportedTld(crate::error::UnsupportedTld),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AcceptDomainTransferFromAnotherAwsAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AcceptDomainTransferFromAnotherAwsAccountErrorKind::DomainLimitExceeded(_inner) => {
                _inner.fmt(f)
            }
            AcceptDomainTransferFromAnotherAwsAccountErrorKind::InvalidInput(_inner) => {
                _inner.fmt(f)
            }
            AcceptDomainTransferFromAnotherAwsAccountErrorKind::OperationLimitExceeded(_inner) => {
                _inner.fmt(f)
            }
            AcceptDomainTransferFromAnotherAwsAccountErrorKind::UnsupportedTld(_inner) => {
                _inner.fmt(f)
            }
            AcceptDomainTransferFromAnotherAwsAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AcceptDomainTransferFromAnotherAwsAccountError {
    fn code(&self) -> Option<&str> {
        AcceptDomainTransferFromAnotherAwsAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AcceptDomainTransferFromAnotherAwsAccountError {
    /// Creates a new `AcceptDomainTransferFromAnotherAwsAccountError`.
    pub fn new(
        kind: AcceptDomainTransferFromAnotherAwsAccountErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AcceptDomainTransferFromAnotherAwsAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AcceptDomainTransferFromAnotherAwsAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AcceptDomainTransferFromAnotherAwsAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AcceptDomainTransferFromAnotherAwsAccountErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AcceptDomainTransferFromAnotherAwsAccountErrorKind::DomainLimitExceeded`.
    pub fn is_domain_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            AcceptDomainTransferFromAnotherAwsAccountErrorKind::DomainLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptDomainTransferFromAnotherAwsAccountErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            AcceptDomainTransferFromAnotherAwsAccountErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptDomainTransferFromAnotherAwsAccountErrorKind::OperationLimitExceeded`.
    pub fn is_operation_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            AcceptDomainTransferFromAnotherAwsAccountErrorKind::OperationLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptDomainTransferFromAnotherAwsAccountErrorKind::UnsupportedTld`.
    pub fn is_unsupported_tld(&self) -> bool {
        matches!(
            &self.kind,
            AcceptDomainTransferFromAnotherAwsAccountErrorKind::UnsupportedTld(_)
        )
    }
}
impl std::error::Error for AcceptDomainTransferFromAnotherAwsAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AcceptDomainTransferFromAnotherAwsAccountErrorKind::DomainLimitExceeded(_inner) => {
                Some(_inner)
            }
            AcceptDomainTransferFromAnotherAwsAccountErrorKind::InvalidInput(_inner) => {
                Some(_inner)
            }
            AcceptDomainTransferFromAnotherAwsAccountErrorKind::OperationLimitExceeded(_inner) => {
                Some(_inner)
            }
            AcceptDomainTransferFromAnotherAwsAccountErrorKind::UnsupportedTld(_inner) => {
                Some(_inner)
            }
            AcceptDomainTransferFromAnotherAwsAccountErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `CancelDomainTransferToAnotherAwsAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelDomainTransferToAnotherAwsAccountError {
    /// Kind of error that occurred.
    pub kind: CancelDomainTransferToAnotherAwsAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelDomainTransferToAnotherAwsAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelDomainTransferToAnotherAwsAccountErrorKind {
    /// <p>The requested item is not acceptable. For example, for APIs that accept a domain name, the request might specify a domain name that doesn't belong to the account that submitted the request. For <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The number of operations or jobs running exceeded the allowed threshold for the account.</p>
    OperationLimitExceeded(crate::error::OperationLimitExceeded),
    /// <p>Amazon Route 53 does not support this top-level domain (TLD).</p>
    UnsupportedTld(crate::error::UnsupportedTld),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelDomainTransferToAnotherAwsAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelDomainTransferToAnotherAwsAccountErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            CancelDomainTransferToAnotherAwsAccountErrorKind::OperationLimitExceeded(_inner) => {
                _inner.fmt(f)
            }
            CancelDomainTransferToAnotherAwsAccountErrorKind::UnsupportedTld(_inner) => {
                _inner.fmt(f)
            }
            CancelDomainTransferToAnotherAwsAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelDomainTransferToAnotherAwsAccountError {
    fn code(&self) -> Option<&str> {
        CancelDomainTransferToAnotherAwsAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelDomainTransferToAnotherAwsAccountError {
    /// Creates a new `CancelDomainTransferToAnotherAwsAccountError`.
    pub fn new(
        kind: CancelDomainTransferToAnotherAwsAccountErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelDomainTransferToAnotherAwsAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelDomainTransferToAnotherAwsAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelDomainTransferToAnotherAwsAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelDomainTransferToAnotherAwsAccountErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelDomainTransferToAnotherAwsAccountErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            CancelDomainTransferToAnotherAwsAccountErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `CancelDomainTransferToAnotherAwsAccountErrorKind::OperationLimitExceeded`.
    pub fn is_operation_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            CancelDomainTransferToAnotherAwsAccountErrorKind::OperationLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `CancelDomainTransferToAnotherAwsAccountErrorKind::UnsupportedTld`.
    pub fn is_unsupported_tld(&self) -> bool {
        matches!(
            &self.kind,
            CancelDomainTransferToAnotherAwsAccountErrorKind::UnsupportedTld(_)
        )
    }
}
impl std::error::Error for CancelDomainTransferToAnotherAwsAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelDomainTransferToAnotherAwsAccountErrorKind::InvalidInput(_inner) => Some(_inner),
            CancelDomainTransferToAnotherAwsAccountErrorKind::OperationLimitExceeded(_inner) => {
                Some(_inner)
            }
            CancelDomainTransferToAnotherAwsAccountErrorKind::UnsupportedTld(_inner) => {
                Some(_inner)
            }
            CancelDomainTransferToAnotherAwsAccountErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `CheckDomainAvailability` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CheckDomainAvailabilityError {
    /// Kind of error that occurred.
    pub kind: CheckDomainAvailabilityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CheckDomainAvailability` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CheckDomainAvailabilityErrorKind {
    /// <p>The requested item is not acceptable. For example, for APIs that accept a domain name, the request might specify a domain name that doesn't belong to the account that submitted the request. For <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>Amazon Route 53 does not support this top-level domain (TLD).</p>
    UnsupportedTld(crate::error::UnsupportedTld),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CheckDomainAvailabilityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CheckDomainAvailabilityErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            CheckDomainAvailabilityErrorKind::UnsupportedTld(_inner) => _inner.fmt(f),
            CheckDomainAvailabilityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CheckDomainAvailabilityError {
    fn code(&self) -> Option<&str> {
        CheckDomainAvailabilityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CheckDomainAvailabilityError {
    /// Creates a new `CheckDomainAvailabilityError`.
    pub fn new(kind: CheckDomainAvailabilityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CheckDomainAvailabilityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CheckDomainAvailabilityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CheckDomainAvailabilityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CheckDomainAvailabilityErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CheckDomainAvailabilityErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            CheckDomainAvailabilityErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `CheckDomainAvailabilityErrorKind::UnsupportedTld`.
    pub fn is_unsupported_tld(&self) -> bool {
        matches!(
            &self.kind,
            CheckDomainAvailabilityErrorKind::UnsupportedTld(_)
        )
    }
}
impl std::error::Error for CheckDomainAvailabilityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CheckDomainAvailabilityErrorKind::InvalidInput(_inner) => Some(_inner),
            CheckDomainAvailabilityErrorKind::UnsupportedTld(_inner) => Some(_inner),
            CheckDomainAvailabilityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CheckDomainTransferability` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CheckDomainTransferabilityError {
    /// Kind of error that occurred.
    pub kind: CheckDomainTransferabilityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CheckDomainTransferability` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CheckDomainTransferabilityErrorKind {
    /// <p>The requested item is not acceptable. For example, for APIs that accept a domain name, the request might specify a domain name that doesn't belong to the account that submitted the request. For <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>Amazon Route 53 does not support this top-level domain (TLD).</p>
    UnsupportedTld(crate::error::UnsupportedTld),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CheckDomainTransferabilityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CheckDomainTransferabilityErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            CheckDomainTransferabilityErrorKind::UnsupportedTld(_inner) => _inner.fmt(f),
            CheckDomainTransferabilityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CheckDomainTransferabilityError {
    fn code(&self) -> Option<&str> {
        CheckDomainTransferabilityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CheckDomainTransferabilityError {
    /// Creates a new `CheckDomainTransferabilityError`.
    pub fn new(kind: CheckDomainTransferabilityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CheckDomainTransferabilityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CheckDomainTransferabilityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CheckDomainTransferabilityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CheckDomainTransferabilityErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CheckDomainTransferabilityErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            CheckDomainTransferabilityErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `CheckDomainTransferabilityErrorKind::UnsupportedTld`.
    pub fn is_unsupported_tld(&self) -> bool {
        matches!(
            &self.kind,
            CheckDomainTransferabilityErrorKind::UnsupportedTld(_)
        )
    }
}
impl std::error::Error for CheckDomainTransferabilityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CheckDomainTransferabilityErrorKind::InvalidInput(_inner) => Some(_inner),
            CheckDomainTransferabilityErrorKind::UnsupportedTld(_inner) => Some(_inner),
            CheckDomainTransferabilityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDomainError {
    /// Kind of error that occurred.
    pub kind: DeleteDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDomainErrorKind {
    /// <p>The request is already in progress for the domain.</p>
    DuplicateRequest(crate::error::DuplicateRequest),
    /// <p>The requested item is not acceptable. For example, for APIs that accept a domain name, the request might specify a domain name that doesn't belong to the account that submitted the request. For <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The top-level domain does not support this operation.</p>
    TldRulesViolation(crate::error::TldRulesViolation),
    /// <p>Amazon Route 53 does not support this top-level domain (TLD).</p>
    UnsupportedTld(crate::error::UnsupportedTld),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDomainErrorKind::DuplicateRequest(_inner) => _inner.fmt(f),
            DeleteDomainErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            DeleteDomainErrorKind::TldRulesViolation(_inner) => _inner.fmt(f),
            DeleteDomainErrorKind::UnsupportedTld(_inner) => _inner.fmt(f),
            DeleteDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDomainError {
    fn code(&self) -> Option<&str> {
        DeleteDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDomainError {
    /// Creates a new `DeleteDomainError`.
    pub fn new(kind: DeleteDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDomainErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDomainErrorKind::DuplicateRequest`.
    pub fn is_duplicate_request(&self) -> bool {
        matches!(&self.kind, DeleteDomainErrorKind::DuplicateRequest(_))
    }
    /// Returns `true` if the error kind is `DeleteDomainErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, DeleteDomainErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `DeleteDomainErrorKind::TldRulesViolation`.
    pub fn is_tld_rules_violation(&self) -> bool {
        matches!(&self.kind, DeleteDomainErrorKind::TldRulesViolation(_))
    }
    /// Returns `true` if the error kind is `DeleteDomainErrorKind::UnsupportedTld`.
    pub fn is_unsupported_tld(&self) -> bool {
        matches!(&self.kind, DeleteDomainErrorKind::UnsupportedTld(_))
    }
}
impl std::error::Error for DeleteDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDomainErrorKind::DuplicateRequest(_inner) => Some(_inner),
            DeleteDomainErrorKind::InvalidInput(_inner) => Some(_inner),
            DeleteDomainErrorKind::TldRulesViolation(_inner) => Some(_inner),
            DeleteDomainErrorKind::UnsupportedTld(_inner) => Some(_inner),
            DeleteDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteTagsForDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteTagsForDomainError {
    /// Kind of error that occurred.
    pub kind: DeleteTagsForDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteTagsForDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteTagsForDomainErrorKind {
    /// <p>The requested item is not acceptable. For example, for APIs that accept a domain name, the request might specify a domain name that doesn't belong to the account that submitted the request. For <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The number of operations or jobs running exceeded the allowed threshold for the account.</p>
    OperationLimitExceeded(crate::error::OperationLimitExceeded),
    /// <p>Amazon Route 53 does not support this top-level domain (TLD).</p>
    UnsupportedTld(crate::error::UnsupportedTld),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteTagsForDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteTagsForDomainErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            DeleteTagsForDomainErrorKind::OperationLimitExceeded(_inner) => _inner.fmt(f),
            DeleteTagsForDomainErrorKind::UnsupportedTld(_inner) => _inner.fmt(f),
            DeleteTagsForDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteTagsForDomainError {
    fn code(&self) -> Option<&str> {
        DeleteTagsForDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteTagsForDomainError {
    /// Creates a new `DeleteTagsForDomainError`.
    pub fn new(kind: DeleteTagsForDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteTagsForDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteTagsForDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteTagsForDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteTagsForDomainErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteTagsForDomainErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, DeleteTagsForDomainErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `DeleteTagsForDomainErrorKind::OperationLimitExceeded`.
    pub fn is_operation_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTagsForDomainErrorKind::OperationLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTagsForDomainErrorKind::UnsupportedTld`.
    pub fn is_unsupported_tld(&self) -> bool {
        matches!(&self.kind, DeleteTagsForDomainErrorKind::UnsupportedTld(_))
    }
}
impl std::error::Error for DeleteTagsForDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteTagsForDomainErrorKind::InvalidInput(_inner) => Some(_inner),
            DeleteTagsForDomainErrorKind::OperationLimitExceeded(_inner) => Some(_inner),
            DeleteTagsForDomainErrorKind::UnsupportedTld(_inner) => Some(_inner),
            DeleteTagsForDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisableDomainAutoRenew` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisableDomainAutoRenewError {
    /// Kind of error that occurred.
    pub kind: DisableDomainAutoRenewErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisableDomainAutoRenew` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisableDomainAutoRenewErrorKind {
    /// <p>The requested item is not acceptable. For example, for APIs that accept a domain name, the request might specify a domain name that doesn't belong to the account that submitted the request. For <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>Amazon Route 53 does not support this top-level domain (TLD).</p>
    UnsupportedTld(crate::error::UnsupportedTld),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisableDomainAutoRenewError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisableDomainAutoRenewErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            DisableDomainAutoRenewErrorKind::UnsupportedTld(_inner) => _inner.fmt(f),
            DisableDomainAutoRenewErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisableDomainAutoRenewError {
    fn code(&self) -> Option<&str> {
        DisableDomainAutoRenewError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisableDomainAutoRenewError {
    /// Creates a new `DisableDomainAutoRenewError`.
    pub fn new(kind: DisableDomainAutoRenewErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisableDomainAutoRenewError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisableDomainAutoRenewErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisableDomainAutoRenewError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisableDomainAutoRenewErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisableDomainAutoRenewErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, DisableDomainAutoRenewErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `DisableDomainAutoRenewErrorKind::UnsupportedTld`.
    pub fn is_unsupported_tld(&self) -> bool {
        matches!(
            &self.kind,
            DisableDomainAutoRenewErrorKind::UnsupportedTld(_)
        )
    }
}
impl std::error::Error for DisableDomainAutoRenewError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisableDomainAutoRenewErrorKind::InvalidInput(_inner) => Some(_inner),
            DisableDomainAutoRenewErrorKind::UnsupportedTld(_inner) => Some(_inner),
            DisableDomainAutoRenewErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisableDomainTransferLock` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisableDomainTransferLockError {
    /// Kind of error that occurred.
    pub kind: DisableDomainTransferLockErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisableDomainTransferLock` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisableDomainTransferLockErrorKind {
    /// <p>The request is already in progress for the domain.</p>
    DuplicateRequest(crate::error::DuplicateRequest),
    /// <p>The requested item is not acceptable. For example, for APIs that accept a domain name, the request might specify a domain name that doesn't belong to the account that submitted the request. For <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The number of operations or jobs running exceeded the allowed threshold for the account.</p>
    OperationLimitExceeded(crate::error::OperationLimitExceeded),
    /// <p>The top-level domain does not support this operation.</p>
    TldRulesViolation(crate::error::TldRulesViolation),
    /// <p>Amazon Route 53 does not support this top-level domain (TLD).</p>
    UnsupportedTld(crate::error::UnsupportedTld),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisableDomainTransferLockError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisableDomainTransferLockErrorKind::DuplicateRequest(_inner) => _inner.fmt(f),
            DisableDomainTransferLockErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            DisableDomainTransferLockErrorKind::OperationLimitExceeded(_inner) => _inner.fmt(f),
            DisableDomainTransferLockErrorKind::TldRulesViolation(_inner) => _inner.fmt(f),
            DisableDomainTransferLockErrorKind::UnsupportedTld(_inner) => _inner.fmt(f),
            DisableDomainTransferLockErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisableDomainTransferLockError {
    fn code(&self) -> Option<&str> {
        DisableDomainTransferLockError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisableDomainTransferLockError {
    /// Creates a new `DisableDomainTransferLockError`.
    pub fn new(kind: DisableDomainTransferLockErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisableDomainTransferLockError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisableDomainTransferLockErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisableDomainTransferLockError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisableDomainTransferLockErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisableDomainTransferLockErrorKind::DuplicateRequest`.
    pub fn is_duplicate_request(&self) -> bool {
        matches!(
            &self.kind,
            DisableDomainTransferLockErrorKind::DuplicateRequest(_)
        )
    }
    /// Returns `true` if the error kind is `DisableDomainTransferLockErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            DisableDomainTransferLockErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `DisableDomainTransferLockErrorKind::OperationLimitExceeded`.
    pub fn is_operation_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            DisableDomainTransferLockErrorKind::OperationLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `DisableDomainTransferLockErrorKind::TldRulesViolation`.
    pub fn is_tld_rules_violation(&self) -> bool {
        matches!(
            &self.kind,
            DisableDomainTransferLockErrorKind::TldRulesViolation(_)
        )
    }
    /// Returns `true` if the error kind is `DisableDomainTransferLockErrorKind::UnsupportedTld`.
    pub fn is_unsupported_tld(&self) -> bool {
        matches!(
            &self.kind,
            DisableDomainTransferLockErrorKind::UnsupportedTld(_)
        )
    }
}
impl std::error::Error for DisableDomainTransferLockError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisableDomainTransferLockErrorKind::DuplicateRequest(_inner) => Some(_inner),
            DisableDomainTransferLockErrorKind::InvalidInput(_inner) => Some(_inner),
            DisableDomainTransferLockErrorKind::OperationLimitExceeded(_inner) => Some(_inner),
            DisableDomainTransferLockErrorKind::TldRulesViolation(_inner) => Some(_inner),
            DisableDomainTransferLockErrorKind::UnsupportedTld(_inner) => Some(_inner),
            DisableDomainTransferLockErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `EnableDomainAutoRenew` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EnableDomainAutoRenewError {
    /// Kind of error that occurred.
    pub kind: EnableDomainAutoRenewErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `EnableDomainAutoRenew` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EnableDomainAutoRenewErrorKind {
    /// <p>The requested item is not acceptable. For example, for APIs that accept a domain name, the request might specify a domain name that doesn't belong to the account that submitted the request. For <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The top-level domain does not support this operation.</p>
    TldRulesViolation(crate::error::TldRulesViolation),
    /// <p>Amazon Route 53 does not support this top-level domain (TLD).</p>
    UnsupportedTld(crate::error::UnsupportedTld),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EnableDomainAutoRenewError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EnableDomainAutoRenewErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            EnableDomainAutoRenewErrorKind::TldRulesViolation(_inner) => _inner.fmt(f),
            EnableDomainAutoRenewErrorKind::UnsupportedTld(_inner) => _inner.fmt(f),
            EnableDomainAutoRenewErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EnableDomainAutoRenewError {
    fn code(&self) -> Option<&str> {
        EnableDomainAutoRenewError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl EnableDomainAutoRenewError {
    /// Creates a new `EnableDomainAutoRenewError`.
    pub fn new(kind: EnableDomainAutoRenewErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EnableDomainAutoRenewError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EnableDomainAutoRenewErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EnableDomainAutoRenewError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EnableDomainAutoRenewErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `EnableDomainAutoRenewErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, EnableDomainAutoRenewErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `EnableDomainAutoRenewErrorKind::TldRulesViolation`.
    pub fn is_tld_rules_violation(&self) -> bool {
        matches!(
            &self.kind,
            EnableDomainAutoRenewErrorKind::TldRulesViolation(_)
        )
    }
    /// Returns `true` if the error kind is `EnableDomainAutoRenewErrorKind::UnsupportedTld`.
    pub fn is_unsupported_tld(&self) -> bool {
        matches!(
            &self.kind,
            EnableDomainAutoRenewErrorKind::UnsupportedTld(_)
        )
    }
}
impl std::error::Error for EnableDomainAutoRenewError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EnableDomainAutoRenewErrorKind::InvalidInput(_inner) => Some(_inner),
            EnableDomainAutoRenewErrorKind::TldRulesViolation(_inner) => Some(_inner),
            EnableDomainAutoRenewErrorKind::UnsupportedTld(_inner) => Some(_inner),
            EnableDomainAutoRenewErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `EnableDomainTransferLock` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EnableDomainTransferLockError {
    /// Kind of error that occurred.
    pub kind: EnableDomainTransferLockErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `EnableDomainTransferLock` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EnableDomainTransferLockErrorKind {
    /// <p>The request is already in progress for the domain.</p>
    DuplicateRequest(crate::error::DuplicateRequest),
    /// <p>The requested item is not acceptable. For example, for APIs that accept a domain name, the request might specify a domain name that doesn't belong to the account that submitted the request. For <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The number of operations or jobs running exceeded the allowed threshold for the account.</p>
    OperationLimitExceeded(crate::error::OperationLimitExceeded),
    /// <p>The top-level domain does not support this operation.</p>
    TldRulesViolation(crate::error::TldRulesViolation),
    /// <p>Amazon Route 53 does not support this top-level domain (TLD).</p>
    UnsupportedTld(crate::error::UnsupportedTld),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EnableDomainTransferLockError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EnableDomainTransferLockErrorKind::DuplicateRequest(_inner) => _inner.fmt(f),
            EnableDomainTransferLockErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            EnableDomainTransferLockErrorKind::OperationLimitExceeded(_inner) => _inner.fmt(f),
            EnableDomainTransferLockErrorKind::TldRulesViolation(_inner) => _inner.fmt(f),
            EnableDomainTransferLockErrorKind::UnsupportedTld(_inner) => _inner.fmt(f),
            EnableDomainTransferLockErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EnableDomainTransferLockError {
    fn code(&self) -> Option<&str> {
        EnableDomainTransferLockError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl EnableDomainTransferLockError {
    /// Creates a new `EnableDomainTransferLockError`.
    pub fn new(kind: EnableDomainTransferLockErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EnableDomainTransferLockError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EnableDomainTransferLockErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EnableDomainTransferLockError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EnableDomainTransferLockErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `EnableDomainTransferLockErrorKind::DuplicateRequest`.
    pub fn is_duplicate_request(&self) -> bool {
        matches!(
            &self.kind,
            EnableDomainTransferLockErrorKind::DuplicateRequest(_)
        )
    }
    /// Returns `true` if the error kind is `EnableDomainTransferLockErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            EnableDomainTransferLockErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `EnableDomainTransferLockErrorKind::OperationLimitExceeded`.
    pub fn is_operation_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            EnableDomainTransferLockErrorKind::OperationLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `EnableDomainTransferLockErrorKind::TldRulesViolation`.
    pub fn is_tld_rules_violation(&self) -> bool {
        matches!(
            &self.kind,
            EnableDomainTransferLockErrorKind::TldRulesViolation(_)
        )
    }
    /// Returns `true` if the error kind is `EnableDomainTransferLockErrorKind::UnsupportedTld`.
    pub fn is_unsupported_tld(&self) -> bool {
        matches!(
            &self.kind,
            EnableDomainTransferLockErrorKind::UnsupportedTld(_)
        )
    }
}
impl std::error::Error for EnableDomainTransferLockError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EnableDomainTransferLockErrorKind::DuplicateRequest(_inner) => Some(_inner),
            EnableDomainTransferLockErrorKind::InvalidInput(_inner) => Some(_inner),
            EnableDomainTransferLockErrorKind::OperationLimitExceeded(_inner) => Some(_inner),
            EnableDomainTransferLockErrorKind::TldRulesViolation(_inner) => Some(_inner),
            EnableDomainTransferLockErrorKind::UnsupportedTld(_inner) => Some(_inner),
            EnableDomainTransferLockErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetContactReachabilityStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetContactReachabilityStatusError {
    /// Kind of error that occurred.
    pub kind: GetContactReachabilityStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetContactReachabilityStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetContactReachabilityStatusErrorKind {
    /// <p>The requested item is not acceptable. For example, for APIs that accept a domain name, the request might specify a domain name that doesn't belong to the account that submitted the request. For <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The number of operations or jobs running exceeded the allowed threshold for the account.</p>
    OperationLimitExceeded(crate::error::OperationLimitExceeded),
    /// <p>Amazon Route 53 does not support this top-level domain (TLD).</p>
    UnsupportedTld(crate::error::UnsupportedTld),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetContactReachabilityStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetContactReachabilityStatusErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            GetContactReachabilityStatusErrorKind::OperationLimitExceeded(_inner) => _inner.fmt(f),
            GetContactReachabilityStatusErrorKind::UnsupportedTld(_inner) => _inner.fmt(f),
            GetContactReachabilityStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetContactReachabilityStatusError {
    fn code(&self) -> Option<&str> {
        GetContactReachabilityStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetContactReachabilityStatusError {
    /// Creates a new `GetContactReachabilityStatusError`.
    pub fn new(kind: GetContactReachabilityStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetContactReachabilityStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetContactReachabilityStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetContactReachabilityStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetContactReachabilityStatusErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetContactReachabilityStatusErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            GetContactReachabilityStatusErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `GetContactReachabilityStatusErrorKind::OperationLimitExceeded`.
    pub fn is_operation_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            GetContactReachabilityStatusErrorKind::OperationLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `GetContactReachabilityStatusErrorKind::UnsupportedTld`.
    pub fn is_unsupported_tld(&self) -> bool {
        matches!(
            &self.kind,
            GetContactReachabilityStatusErrorKind::UnsupportedTld(_)
        )
    }
}
impl std::error::Error for GetContactReachabilityStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetContactReachabilityStatusErrorKind::InvalidInput(_inner) => Some(_inner),
            GetContactReachabilityStatusErrorKind::OperationLimitExceeded(_inner) => Some(_inner),
            GetContactReachabilityStatusErrorKind::UnsupportedTld(_inner) => Some(_inner),
            GetContactReachabilityStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDomainDetail` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDomainDetailError {
    /// Kind of error that occurred.
    pub kind: GetDomainDetailErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDomainDetail` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDomainDetailErrorKind {
    /// <p>The requested item is not acceptable. For example, for APIs that accept a domain name, the request might specify a domain name that doesn't belong to the account that submitted the request. For <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>Amazon Route 53 does not support this top-level domain (TLD).</p>
    UnsupportedTld(crate::error::UnsupportedTld),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDomainDetailError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDomainDetailErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            GetDomainDetailErrorKind::UnsupportedTld(_inner) => _inner.fmt(f),
            GetDomainDetailErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDomainDetailError {
    fn code(&self) -> Option<&str> {
        GetDomainDetailError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDomainDetailError {
    /// Creates a new `GetDomainDetailError`.
    pub fn new(kind: GetDomainDetailErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDomainDetailError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDomainDetailErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDomainDetailError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDomainDetailErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDomainDetailErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, GetDomainDetailErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `GetDomainDetailErrorKind::UnsupportedTld`.
    pub fn is_unsupported_tld(&self) -> bool {
        matches!(&self.kind, GetDomainDetailErrorKind::UnsupportedTld(_))
    }
}
impl std::error::Error for GetDomainDetailError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDomainDetailErrorKind::InvalidInput(_inner) => Some(_inner),
            GetDomainDetailErrorKind::UnsupportedTld(_inner) => Some(_inner),
            GetDomainDetailErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDomainSuggestions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDomainSuggestionsError {
    /// Kind of error that occurred.
    pub kind: GetDomainSuggestionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDomainSuggestions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDomainSuggestionsErrorKind {
    /// <p>The requested item is not acceptable. For example, for APIs that accept a domain name, the request might specify a domain name that doesn't belong to the account that submitted the request. For <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>Amazon Route 53 does not support this top-level domain (TLD).</p>
    UnsupportedTld(crate::error::UnsupportedTld),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDomainSuggestionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDomainSuggestionsErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            GetDomainSuggestionsErrorKind::UnsupportedTld(_inner) => _inner.fmt(f),
            GetDomainSuggestionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDomainSuggestionsError {
    fn code(&self) -> Option<&str> {
        GetDomainSuggestionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDomainSuggestionsError {
    /// Creates a new `GetDomainSuggestionsError`.
    pub fn new(kind: GetDomainSuggestionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDomainSuggestionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDomainSuggestionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDomainSuggestionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDomainSuggestionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDomainSuggestionsErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, GetDomainSuggestionsErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `GetDomainSuggestionsErrorKind::UnsupportedTld`.
    pub fn is_unsupported_tld(&self) -> bool {
        matches!(&self.kind, GetDomainSuggestionsErrorKind::UnsupportedTld(_))
    }
}
impl std::error::Error for GetDomainSuggestionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDomainSuggestionsErrorKind::InvalidInput(_inner) => Some(_inner),
            GetDomainSuggestionsErrorKind::UnsupportedTld(_inner) => Some(_inner),
            GetDomainSuggestionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetOperationDetail` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetOperationDetailError {
    /// Kind of error that occurred.
    pub kind: GetOperationDetailErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetOperationDetail` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetOperationDetailErrorKind {
    /// <p>The requested item is not acceptable. For example, for APIs that accept a domain name, the request might specify a domain name that doesn't belong to the account that submitted the request. For <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetOperationDetailError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetOperationDetailErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            GetOperationDetailErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetOperationDetailError {
    fn code(&self) -> Option<&str> {
        GetOperationDetailError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetOperationDetailError {
    /// Creates a new `GetOperationDetailError`.
    pub fn new(kind: GetOperationDetailErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetOperationDetailError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetOperationDetailErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetOperationDetailError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetOperationDetailErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetOperationDetailErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, GetOperationDetailErrorKind::InvalidInput(_))
    }
}
impl std::error::Error for GetOperationDetailError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetOperationDetailErrorKind::InvalidInput(_inner) => Some(_inner),
            GetOperationDetailErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDomains` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDomainsError {
    /// Kind of error that occurred.
    pub kind: ListDomainsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDomains` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDomainsErrorKind {
    /// <p>The requested item is not acceptable. For example, for APIs that accept a domain name, the request might specify a domain name that doesn't belong to the account that submitted the request. For <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDomainsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDomainsErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            ListDomainsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDomainsError {
    fn code(&self) -> Option<&str> {
        ListDomainsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDomainsError {
    /// Creates a new `ListDomainsError`.
    pub fn new(kind: ListDomainsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDomainsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDomainsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDomainsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDomainsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDomainsErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, ListDomainsErrorKind::InvalidInput(_))
    }
}
impl std::error::Error for ListDomainsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDomainsErrorKind::InvalidInput(_inner) => Some(_inner),
            ListDomainsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListOperations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListOperationsError {
    /// Kind of error that occurred.
    pub kind: ListOperationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListOperations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListOperationsErrorKind {
    /// <p>The requested item is not acceptable. For example, for APIs that accept a domain name, the request might specify a domain name that doesn't belong to the account that submitted the request. For <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListOperationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListOperationsErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            ListOperationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListOperationsError {
    fn code(&self) -> Option<&str> {
        ListOperationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListOperationsError {
    /// Creates a new `ListOperationsError`.
    pub fn new(kind: ListOperationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListOperationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListOperationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListOperationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListOperationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListOperationsErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, ListOperationsErrorKind::InvalidInput(_))
    }
}
impl std::error::Error for ListOperationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListOperationsErrorKind::InvalidInput(_inner) => Some(_inner),
            ListOperationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPrices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPricesError {
    /// Kind of error that occurred.
    pub kind: ListPricesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPrices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPricesErrorKind {
    /// <p>The requested item is not acceptable. For example, for APIs that accept a domain name, the request might specify a domain name that doesn't belong to the account that submitted the request. For <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>Amazon Route 53 does not support this top-level domain (TLD).</p>
    UnsupportedTld(crate::error::UnsupportedTld),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPricesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPricesErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            ListPricesErrorKind::UnsupportedTld(_inner) => _inner.fmt(f),
            ListPricesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPricesError {
    fn code(&self) -> Option<&str> {
        ListPricesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPricesError {
    /// Creates a new `ListPricesError`.
    pub fn new(kind: ListPricesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPricesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPricesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPricesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPricesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPricesErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, ListPricesErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `ListPricesErrorKind::UnsupportedTld`.
    pub fn is_unsupported_tld(&self) -> bool {
        matches!(&self.kind, ListPricesErrorKind::UnsupportedTld(_))
    }
}
impl std::error::Error for ListPricesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPricesErrorKind::InvalidInput(_inner) => Some(_inner),
            ListPricesErrorKind::UnsupportedTld(_inner) => Some(_inner),
            ListPricesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForDomainError {
    /// Kind of error that occurred.
    pub kind: ListTagsForDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForDomainErrorKind {
    /// <p>The requested item is not acceptable. For example, for APIs that accept a domain name, the request might specify a domain name that doesn't belong to the account that submitted the request. For <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The number of operations or jobs running exceeded the allowed threshold for the account.</p>
    OperationLimitExceeded(crate::error::OperationLimitExceeded),
    /// <p>Amazon Route 53 does not support this top-level domain (TLD).</p>
    UnsupportedTld(crate::error::UnsupportedTld),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForDomainErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            ListTagsForDomainErrorKind::OperationLimitExceeded(_inner) => _inner.fmt(f),
            ListTagsForDomainErrorKind::UnsupportedTld(_inner) => _inner.fmt(f),
            ListTagsForDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForDomainError {
    fn code(&self) -> Option<&str> {
        ListTagsForDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForDomainError {
    /// Creates a new `ListTagsForDomainError`.
    pub fn new(kind: ListTagsForDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForDomainErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForDomainErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, ListTagsForDomainErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `ListTagsForDomainErrorKind::OperationLimitExceeded`.
    pub fn is_operation_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForDomainErrorKind::OperationLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForDomainErrorKind::UnsupportedTld`.
    pub fn is_unsupported_tld(&self) -> bool {
        matches!(&self.kind, ListTagsForDomainErrorKind::UnsupportedTld(_))
    }
}
impl std::error::Error for ListTagsForDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForDomainErrorKind::InvalidInput(_inner) => Some(_inner),
            ListTagsForDomainErrorKind::OperationLimitExceeded(_inner) => Some(_inner),
            ListTagsForDomainErrorKind::UnsupportedTld(_inner) => Some(_inner),
            ListTagsForDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RegisterDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RegisterDomainError {
    /// Kind of error that occurred.
    pub kind: RegisterDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RegisterDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RegisterDomainErrorKind {
    /// <p>The number of domains has exceeded the allowed threshold for the account.</p>
    DomainLimitExceeded(crate::error::DomainLimitExceeded),
    /// <p>The request is already in progress for the domain.</p>
    DuplicateRequest(crate::error::DuplicateRequest),
    /// <p>The requested item is not acceptable. For example, for APIs that accept a domain name, the request might specify a domain name that doesn't belong to the account that submitted the request. For <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The number of operations or jobs running exceeded the allowed threshold for the account.</p>
    OperationLimitExceeded(crate::error::OperationLimitExceeded),
    /// <p>The top-level domain does not support this operation.</p>
    TldRulesViolation(crate::error::TldRulesViolation),
    /// <p>Amazon Route 53 does not support this top-level domain (TLD).</p>
    UnsupportedTld(crate::error::UnsupportedTld),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RegisterDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RegisterDomainErrorKind::DomainLimitExceeded(_inner) => _inner.fmt(f),
            RegisterDomainErrorKind::DuplicateRequest(_inner) => _inner.fmt(f),
            RegisterDomainErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            RegisterDomainErrorKind::OperationLimitExceeded(_inner) => _inner.fmt(f),
            RegisterDomainErrorKind::TldRulesViolation(_inner) => _inner.fmt(f),
            RegisterDomainErrorKind::UnsupportedTld(_inner) => _inner.fmt(f),
            RegisterDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RegisterDomainError {
    fn code(&self) -> Option<&str> {
        RegisterDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RegisterDomainError {
    /// Creates a new `RegisterDomainError`.
    pub fn new(kind: RegisterDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RegisterDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RegisterDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RegisterDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RegisterDomainErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RegisterDomainErrorKind::DomainLimitExceeded`.
    pub fn is_domain_limit_exceeded(&self) -> bool {
        matches!(&self.kind, RegisterDomainErrorKind::DomainLimitExceeded(_))
    }
    /// Returns `true` if the error kind is `RegisterDomainErrorKind::DuplicateRequest`.
    pub fn is_duplicate_request(&self) -> bool {
        matches!(&self.kind, RegisterDomainErrorKind::DuplicateRequest(_))
    }
    /// Returns `true` if the error kind is `RegisterDomainErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, RegisterDomainErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `RegisterDomainErrorKind::OperationLimitExceeded`.
    pub fn is_operation_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            RegisterDomainErrorKind::OperationLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterDomainErrorKind::TldRulesViolation`.
    pub fn is_tld_rules_violation(&self) -> bool {
        matches!(&self.kind, RegisterDomainErrorKind::TldRulesViolation(_))
    }
    /// Returns `true` if the error kind is `RegisterDomainErrorKind::UnsupportedTld`.
    pub fn is_unsupported_tld(&self) -> bool {
        matches!(&self.kind, RegisterDomainErrorKind::UnsupportedTld(_))
    }
}
impl std::error::Error for RegisterDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RegisterDomainErrorKind::DomainLimitExceeded(_inner) => Some(_inner),
            RegisterDomainErrorKind::DuplicateRequest(_inner) => Some(_inner),
            RegisterDomainErrorKind::InvalidInput(_inner) => Some(_inner),
            RegisterDomainErrorKind::OperationLimitExceeded(_inner) => Some(_inner),
            RegisterDomainErrorKind::TldRulesViolation(_inner) => Some(_inner),
            RegisterDomainErrorKind::UnsupportedTld(_inner) => Some(_inner),
            RegisterDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RejectDomainTransferFromAnotherAwsAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RejectDomainTransferFromAnotherAwsAccountError {
    /// Kind of error that occurred.
    pub kind: RejectDomainTransferFromAnotherAwsAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RejectDomainTransferFromAnotherAwsAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RejectDomainTransferFromAnotherAwsAccountErrorKind {
    /// <p>The requested item is not acceptable. For example, for APIs that accept a domain name, the request might specify a domain name that doesn't belong to the account that submitted the request. For <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The number of operations or jobs running exceeded the allowed threshold for the account.</p>
    OperationLimitExceeded(crate::error::OperationLimitExceeded),
    /// <p>Amazon Route 53 does not support this top-level domain (TLD).</p>
    UnsupportedTld(crate::error::UnsupportedTld),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RejectDomainTransferFromAnotherAwsAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RejectDomainTransferFromAnotherAwsAccountErrorKind::InvalidInput(_inner) => {
                _inner.fmt(f)
            }
            RejectDomainTransferFromAnotherAwsAccountErrorKind::OperationLimitExceeded(_inner) => {
                _inner.fmt(f)
            }
            RejectDomainTransferFromAnotherAwsAccountErrorKind::UnsupportedTld(_inner) => {
                _inner.fmt(f)
            }
            RejectDomainTransferFromAnotherAwsAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RejectDomainTransferFromAnotherAwsAccountError {
    fn code(&self) -> Option<&str> {
        RejectDomainTransferFromAnotherAwsAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RejectDomainTransferFromAnotherAwsAccountError {
    /// Creates a new `RejectDomainTransferFromAnotherAwsAccountError`.
    pub fn new(
        kind: RejectDomainTransferFromAnotherAwsAccountErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RejectDomainTransferFromAnotherAwsAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RejectDomainTransferFromAnotherAwsAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RejectDomainTransferFromAnotherAwsAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RejectDomainTransferFromAnotherAwsAccountErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RejectDomainTransferFromAnotherAwsAccountErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            RejectDomainTransferFromAnotherAwsAccountErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `RejectDomainTransferFromAnotherAwsAccountErrorKind::OperationLimitExceeded`.
    pub fn is_operation_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            RejectDomainTransferFromAnotherAwsAccountErrorKind::OperationLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `RejectDomainTransferFromAnotherAwsAccountErrorKind::UnsupportedTld`.
    pub fn is_unsupported_tld(&self) -> bool {
        matches!(
            &self.kind,
            RejectDomainTransferFromAnotherAwsAccountErrorKind::UnsupportedTld(_)
        )
    }
}
impl std::error::Error for RejectDomainTransferFromAnotherAwsAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RejectDomainTransferFromAnotherAwsAccountErrorKind::InvalidInput(_inner) => {
                Some(_inner)
            }
            RejectDomainTransferFromAnotherAwsAccountErrorKind::OperationLimitExceeded(_inner) => {
                Some(_inner)
            }
            RejectDomainTransferFromAnotherAwsAccountErrorKind::UnsupportedTld(_inner) => {
                Some(_inner)
            }
            RejectDomainTransferFromAnotherAwsAccountErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `RenewDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RenewDomainError {
    /// Kind of error that occurred.
    pub kind: RenewDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RenewDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RenewDomainErrorKind {
    /// <p>The request is already in progress for the domain.</p>
    DuplicateRequest(crate::error::DuplicateRequest),
    /// <p>The requested item is not acceptable. For example, for APIs that accept a domain name, the request might specify a domain name that doesn't belong to the account that submitted the request. For <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The number of operations or jobs running exceeded the allowed threshold for the account.</p>
    OperationLimitExceeded(crate::error::OperationLimitExceeded),
    /// <p>The top-level domain does not support this operation.</p>
    TldRulesViolation(crate::error::TldRulesViolation),
    /// <p>Amazon Route 53 does not support this top-level domain (TLD).</p>
    UnsupportedTld(crate::error::UnsupportedTld),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RenewDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RenewDomainErrorKind::DuplicateRequest(_inner) => _inner.fmt(f),
            RenewDomainErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            RenewDomainErrorKind::OperationLimitExceeded(_inner) => _inner.fmt(f),
            RenewDomainErrorKind::TldRulesViolation(_inner) => _inner.fmt(f),
            RenewDomainErrorKind::UnsupportedTld(_inner) => _inner.fmt(f),
            RenewDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RenewDomainError {
    fn code(&self) -> Option<&str> {
        RenewDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RenewDomainError {
    /// Creates a new `RenewDomainError`.
    pub fn new(kind: RenewDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RenewDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RenewDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RenewDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RenewDomainErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RenewDomainErrorKind::DuplicateRequest`.
    pub fn is_duplicate_request(&self) -> bool {
        matches!(&self.kind, RenewDomainErrorKind::DuplicateRequest(_))
    }
    /// Returns `true` if the error kind is `RenewDomainErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, RenewDomainErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `RenewDomainErrorKind::OperationLimitExceeded`.
    pub fn is_operation_limit_exceeded(&self) -> bool {
        matches!(&self.kind, RenewDomainErrorKind::OperationLimitExceeded(_))
    }
    /// Returns `true` if the error kind is `RenewDomainErrorKind::TldRulesViolation`.
    pub fn is_tld_rules_violation(&self) -> bool {
        matches!(&self.kind, RenewDomainErrorKind::TldRulesViolation(_))
    }
    /// Returns `true` if the error kind is `RenewDomainErrorKind::UnsupportedTld`.
    pub fn is_unsupported_tld(&self) -> bool {
        matches!(&self.kind, RenewDomainErrorKind::UnsupportedTld(_))
    }
}
impl std::error::Error for RenewDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RenewDomainErrorKind::DuplicateRequest(_inner) => Some(_inner),
            RenewDomainErrorKind::InvalidInput(_inner) => Some(_inner),
            RenewDomainErrorKind::OperationLimitExceeded(_inner) => Some(_inner),
            RenewDomainErrorKind::TldRulesViolation(_inner) => Some(_inner),
            RenewDomainErrorKind::UnsupportedTld(_inner) => Some(_inner),
            RenewDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ResendContactReachabilityEmail` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ResendContactReachabilityEmailError {
    /// Kind of error that occurred.
    pub kind: ResendContactReachabilityEmailErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ResendContactReachabilityEmail` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ResendContactReachabilityEmailErrorKind {
    /// <p>The requested item is not acceptable. For example, for APIs that accept a domain name, the request might specify a domain name that doesn't belong to the account that submitted the request. For <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The number of operations or jobs running exceeded the allowed threshold for the account.</p>
    OperationLimitExceeded(crate::error::OperationLimitExceeded),
    /// <p>Amazon Route 53 does not support this top-level domain (TLD).</p>
    UnsupportedTld(crate::error::UnsupportedTld),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ResendContactReachabilityEmailError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ResendContactReachabilityEmailErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            ResendContactReachabilityEmailErrorKind::OperationLimitExceeded(_inner) => {
                _inner.fmt(f)
            }
            ResendContactReachabilityEmailErrorKind::UnsupportedTld(_inner) => _inner.fmt(f),
            ResendContactReachabilityEmailErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ResendContactReachabilityEmailError {
    fn code(&self) -> Option<&str> {
        ResendContactReachabilityEmailError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ResendContactReachabilityEmailError {
    /// Creates a new `ResendContactReachabilityEmailError`.
    pub fn new(
        kind: ResendContactReachabilityEmailErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ResendContactReachabilityEmailError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ResendContactReachabilityEmailErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ResendContactReachabilityEmailError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ResendContactReachabilityEmailErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ResendContactReachabilityEmailErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            ResendContactReachabilityEmailErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `ResendContactReachabilityEmailErrorKind::OperationLimitExceeded`.
    pub fn is_operation_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            ResendContactReachabilityEmailErrorKind::OperationLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `ResendContactReachabilityEmailErrorKind::UnsupportedTld`.
    pub fn is_unsupported_tld(&self) -> bool {
        matches!(
            &self.kind,
            ResendContactReachabilityEmailErrorKind::UnsupportedTld(_)
        )
    }
}
impl std::error::Error for ResendContactReachabilityEmailError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ResendContactReachabilityEmailErrorKind::InvalidInput(_inner) => Some(_inner),
            ResendContactReachabilityEmailErrorKind::OperationLimitExceeded(_inner) => Some(_inner),
            ResendContactReachabilityEmailErrorKind::UnsupportedTld(_inner) => Some(_inner),
            ResendContactReachabilityEmailErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RetrieveDomainAuthCode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RetrieveDomainAuthCodeError {
    /// Kind of error that occurred.
    pub kind: RetrieveDomainAuthCodeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RetrieveDomainAuthCode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RetrieveDomainAuthCodeErrorKind {
    /// <p>The requested item is not acceptable. For example, for APIs that accept a domain name, the request might specify a domain name that doesn't belong to the account that submitted the request. For <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>Amazon Route 53 does not support this top-level domain (TLD).</p>
    UnsupportedTld(crate::error::UnsupportedTld),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RetrieveDomainAuthCodeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RetrieveDomainAuthCodeErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            RetrieveDomainAuthCodeErrorKind::UnsupportedTld(_inner) => _inner.fmt(f),
            RetrieveDomainAuthCodeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RetrieveDomainAuthCodeError {
    fn code(&self) -> Option<&str> {
        RetrieveDomainAuthCodeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RetrieveDomainAuthCodeError {
    /// Creates a new `RetrieveDomainAuthCodeError`.
    pub fn new(kind: RetrieveDomainAuthCodeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RetrieveDomainAuthCodeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RetrieveDomainAuthCodeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RetrieveDomainAuthCodeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RetrieveDomainAuthCodeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RetrieveDomainAuthCodeErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, RetrieveDomainAuthCodeErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `RetrieveDomainAuthCodeErrorKind::UnsupportedTld`.
    pub fn is_unsupported_tld(&self) -> bool {
        matches!(
            &self.kind,
            RetrieveDomainAuthCodeErrorKind::UnsupportedTld(_)
        )
    }
}
impl std::error::Error for RetrieveDomainAuthCodeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RetrieveDomainAuthCodeErrorKind::InvalidInput(_inner) => Some(_inner),
            RetrieveDomainAuthCodeErrorKind::UnsupportedTld(_inner) => Some(_inner),
            RetrieveDomainAuthCodeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TransferDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TransferDomainError {
    /// Kind of error that occurred.
    pub kind: TransferDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TransferDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TransferDomainErrorKind {
    /// <p>The number of domains has exceeded the allowed threshold for the account.</p>
    DomainLimitExceeded(crate::error::DomainLimitExceeded),
    /// <p>The request is already in progress for the domain.</p>
    DuplicateRequest(crate::error::DuplicateRequest),
    /// <p>The requested item is not acceptable. For example, for APIs that accept a domain name, the request might specify a domain name that doesn't belong to the account that submitted the request. For <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The number of operations or jobs running exceeded the allowed threshold for the account.</p>
    OperationLimitExceeded(crate::error::OperationLimitExceeded),
    /// <p>The top-level domain does not support this operation.</p>
    TldRulesViolation(crate::error::TldRulesViolation),
    /// <p>Amazon Route 53 does not support this top-level domain (TLD).</p>
    UnsupportedTld(crate::error::UnsupportedTld),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TransferDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TransferDomainErrorKind::DomainLimitExceeded(_inner) => _inner.fmt(f),
            TransferDomainErrorKind::DuplicateRequest(_inner) => _inner.fmt(f),
            TransferDomainErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            TransferDomainErrorKind::OperationLimitExceeded(_inner) => _inner.fmt(f),
            TransferDomainErrorKind::TldRulesViolation(_inner) => _inner.fmt(f),
            TransferDomainErrorKind::UnsupportedTld(_inner) => _inner.fmt(f),
            TransferDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TransferDomainError {
    fn code(&self) -> Option<&str> {
        TransferDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TransferDomainError {
    /// Creates a new `TransferDomainError`.
    pub fn new(kind: TransferDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TransferDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TransferDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TransferDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TransferDomainErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TransferDomainErrorKind::DomainLimitExceeded`.
    pub fn is_domain_limit_exceeded(&self) -> bool {
        matches!(&self.kind, TransferDomainErrorKind::DomainLimitExceeded(_))
    }
    /// Returns `true` if the error kind is `TransferDomainErrorKind::DuplicateRequest`.
    pub fn is_duplicate_request(&self) -> bool {
        matches!(&self.kind, TransferDomainErrorKind::DuplicateRequest(_))
    }
    /// Returns `true` if the error kind is `TransferDomainErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, TransferDomainErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `TransferDomainErrorKind::OperationLimitExceeded`.
    pub fn is_operation_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            TransferDomainErrorKind::OperationLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `TransferDomainErrorKind::TldRulesViolation`.
    pub fn is_tld_rules_violation(&self) -> bool {
        matches!(&self.kind, TransferDomainErrorKind::TldRulesViolation(_))
    }
    /// Returns `true` if the error kind is `TransferDomainErrorKind::UnsupportedTld`.
    pub fn is_unsupported_tld(&self) -> bool {
        matches!(&self.kind, TransferDomainErrorKind::UnsupportedTld(_))
    }
}
impl std::error::Error for TransferDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TransferDomainErrorKind::DomainLimitExceeded(_inner) => Some(_inner),
            TransferDomainErrorKind::DuplicateRequest(_inner) => Some(_inner),
            TransferDomainErrorKind::InvalidInput(_inner) => Some(_inner),
            TransferDomainErrorKind::OperationLimitExceeded(_inner) => Some(_inner),
            TransferDomainErrorKind::TldRulesViolation(_inner) => Some(_inner),
            TransferDomainErrorKind::UnsupportedTld(_inner) => Some(_inner),
            TransferDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TransferDomainToAnotherAwsAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TransferDomainToAnotherAwsAccountError {
    /// Kind of error that occurred.
    pub kind: TransferDomainToAnotherAwsAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TransferDomainToAnotherAwsAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TransferDomainToAnotherAwsAccountErrorKind {
    /// <p>The request is already in progress for the domain.</p>
    DuplicateRequest(crate::error::DuplicateRequest),
    /// <p>The requested item is not acceptable. For example, for APIs that accept a domain name, the request might specify a domain name that doesn't belong to the account that submitted the request. For <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The number of operations or jobs running exceeded the allowed threshold for the account.</p>
    OperationLimitExceeded(crate::error::OperationLimitExceeded),
    /// <p>Amazon Route 53 does not support this top-level domain (TLD).</p>
    UnsupportedTld(crate::error::UnsupportedTld),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TransferDomainToAnotherAwsAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TransferDomainToAnotherAwsAccountErrorKind::DuplicateRequest(_inner) => _inner.fmt(f),
            TransferDomainToAnotherAwsAccountErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            TransferDomainToAnotherAwsAccountErrorKind::OperationLimitExceeded(_inner) => {
                _inner.fmt(f)
            }
            TransferDomainToAnotherAwsAccountErrorKind::UnsupportedTld(_inner) => _inner.fmt(f),
            TransferDomainToAnotherAwsAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TransferDomainToAnotherAwsAccountError {
    fn code(&self) -> Option<&str> {
        TransferDomainToAnotherAwsAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TransferDomainToAnotherAwsAccountError {
    /// Creates a new `TransferDomainToAnotherAwsAccountError`.
    pub fn new(
        kind: TransferDomainToAnotherAwsAccountErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TransferDomainToAnotherAwsAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TransferDomainToAnotherAwsAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TransferDomainToAnotherAwsAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TransferDomainToAnotherAwsAccountErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TransferDomainToAnotherAwsAccountErrorKind::DuplicateRequest`.
    pub fn is_duplicate_request(&self) -> bool {
        matches!(
            &self.kind,
            TransferDomainToAnotherAwsAccountErrorKind::DuplicateRequest(_)
        )
    }
    /// Returns `true` if the error kind is `TransferDomainToAnotherAwsAccountErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            TransferDomainToAnotherAwsAccountErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `TransferDomainToAnotherAwsAccountErrorKind::OperationLimitExceeded`.
    pub fn is_operation_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            TransferDomainToAnotherAwsAccountErrorKind::OperationLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `TransferDomainToAnotherAwsAccountErrorKind::UnsupportedTld`.
    pub fn is_unsupported_tld(&self) -> bool {
        matches!(
            &self.kind,
            TransferDomainToAnotherAwsAccountErrorKind::UnsupportedTld(_)
        )
    }
}
impl std::error::Error for TransferDomainToAnotherAwsAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TransferDomainToAnotherAwsAccountErrorKind::DuplicateRequest(_inner) => Some(_inner),
            TransferDomainToAnotherAwsAccountErrorKind::InvalidInput(_inner) => Some(_inner),
            TransferDomainToAnotherAwsAccountErrorKind::OperationLimitExceeded(_inner) => {
                Some(_inner)
            }
            TransferDomainToAnotherAwsAccountErrorKind::UnsupportedTld(_inner) => Some(_inner),
            TransferDomainToAnotherAwsAccountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDomainContact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDomainContactError {
    /// Kind of error that occurred.
    pub kind: UpdateDomainContactErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDomainContact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDomainContactErrorKind {
    /// <p>The request is already in progress for the domain.</p>
    DuplicateRequest(crate::error::DuplicateRequest),
    /// <p>The requested item is not acceptable. For example, for APIs that accept a domain name, the request might specify a domain name that doesn't belong to the account that submitted the request. For <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The number of operations or jobs running exceeded the allowed threshold for the account.</p>
    OperationLimitExceeded(crate::error::OperationLimitExceeded),
    /// <p>The top-level domain does not support this operation.</p>
    TldRulesViolation(crate::error::TldRulesViolation),
    /// <p>Amazon Route 53 does not support this top-level domain (TLD).</p>
    UnsupportedTld(crate::error::UnsupportedTld),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDomainContactError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDomainContactErrorKind::DuplicateRequest(_inner) => _inner.fmt(f),
            UpdateDomainContactErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            UpdateDomainContactErrorKind::OperationLimitExceeded(_inner) => _inner.fmt(f),
            UpdateDomainContactErrorKind::TldRulesViolation(_inner) => _inner.fmt(f),
            UpdateDomainContactErrorKind::UnsupportedTld(_inner) => _inner.fmt(f),
            UpdateDomainContactErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDomainContactError {
    fn code(&self) -> Option<&str> {
        UpdateDomainContactError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDomainContactError {
    /// Creates a new `UpdateDomainContactError`.
    pub fn new(kind: UpdateDomainContactErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDomainContactError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDomainContactErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDomainContactError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDomainContactErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateDomainContactErrorKind::DuplicateRequest`.
    pub fn is_duplicate_request(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainContactErrorKind::DuplicateRequest(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDomainContactErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, UpdateDomainContactErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `UpdateDomainContactErrorKind::OperationLimitExceeded`.
    pub fn is_operation_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainContactErrorKind::OperationLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDomainContactErrorKind::TldRulesViolation`.
    pub fn is_tld_rules_violation(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainContactErrorKind::TldRulesViolation(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDomainContactErrorKind::UnsupportedTld`.
    pub fn is_unsupported_tld(&self) -> bool {
        matches!(&self.kind, UpdateDomainContactErrorKind::UnsupportedTld(_))
    }
}
impl std::error::Error for UpdateDomainContactError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDomainContactErrorKind::DuplicateRequest(_inner) => Some(_inner),
            UpdateDomainContactErrorKind::InvalidInput(_inner) => Some(_inner),
            UpdateDomainContactErrorKind::OperationLimitExceeded(_inner) => Some(_inner),
            UpdateDomainContactErrorKind::TldRulesViolation(_inner) => Some(_inner),
            UpdateDomainContactErrorKind::UnsupportedTld(_inner) => Some(_inner),
            UpdateDomainContactErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDomainContactPrivacy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDomainContactPrivacyError {
    /// Kind of error that occurred.
    pub kind: UpdateDomainContactPrivacyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDomainContactPrivacy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDomainContactPrivacyErrorKind {
    /// <p>The request is already in progress for the domain.</p>
    DuplicateRequest(crate::error::DuplicateRequest),
    /// <p>The requested item is not acceptable. For example, for APIs that accept a domain name, the request might specify a domain name that doesn't belong to the account that submitted the request. For <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The number of operations or jobs running exceeded the allowed threshold for the account.</p>
    OperationLimitExceeded(crate::error::OperationLimitExceeded),
    /// <p>The top-level domain does not support this operation.</p>
    TldRulesViolation(crate::error::TldRulesViolation),
    /// <p>Amazon Route 53 does not support this top-level domain (TLD).</p>
    UnsupportedTld(crate::error::UnsupportedTld),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDomainContactPrivacyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDomainContactPrivacyErrorKind::DuplicateRequest(_inner) => _inner.fmt(f),
            UpdateDomainContactPrivacyErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            UpdateDomainContactPrivacyErrorKind::OperationLimitExceeded(_inner) => _inner.fmt(f),
            UpdateDomainContactPrivacyErrorKind::TldRulesViolation(_inner) => _inner.fmt(f),
            UpdateDomainContactPrivacyErrorKind::UnsupportedTld(_inner) => _inner.fmt(f),
            UpdateDomainContactPrivacyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDomainContactPrivacyError {
    fn code(&self) -> Option<&str> {
        UpdateDomainContactPrivacyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDomainContactPrivacyError {
    /// Creates a new `UpdateDomainContactPrivacyError`.
    pub fn new(kind: UpdateDomainContactPrivacyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDomainContactPrivacyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDomainContactPrivacyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDomainContactPrivacyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDomainContactPrivacyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateDomainContactPrivacyErrorKind::DuplicateRequest`.
    pub fn is_duplicate_request(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainContactPrivacyErrorKind::DuplicateRequest(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDomainContactPrivacyErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainContactPrivacyErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDomainContactPrivacyErrorKind::OperationLimitExceeded`.
    pub fn is_operation_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainContactPrivacyErrorKind::OperationLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDomainContactPrivacyErrorKind::TldRulesViolation`.
    pub fn is_tld_rules_violation(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainContactPrivacyErrorKind::TldRulesViolation(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDomainContactPrivacyErrorKind::UnsupportedTld`.
    pub fn is_unsupported_tld(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainContactPrivacyErrorKind::UnsupportedTld(_)
        )
    }
}
impl std::error::Error for UpdateDomainContactPrivacyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDomainContactPrivacyErrorKind::DuplicateRequest(_inner) => Some(_inner),
            UpdateDomainContactPrivacyErrorKind::InvalidInput(_inner) => Some(_inner),
            UpdateDomainContactPrivacyErrorKind::OperationLimitExceeded(_inner) => Some(_inner),
            UpdateDomainContactPrivacyErrorKind::TldRulesViolation(_inner) => Some(_inner),
            UpdateDomainContactPrivacyErrorKind::UnsupportedTld(_inner) => Some(_inner),
            UpdateDomainContactPrivacyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDomainNameservers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDomainNameserversError {
    /// Kind of error that occurred.
    pub kind: UpdateDomainNameserversErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDomainNameservers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDomainNameserversErrorKind {
    /// <p>The request is already in progress for the domain.</p>
    DuplicateRequest(crate::error::DuplicateRequest),
    /// <p>The requested item is not acceptable. For example, for APIs that accept a domain name, the request might specify a domain name that doesn't belong to the account that submitted the request. For <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The number of operations or jobs running exceeded the allowed threshold for the account.</p>
    OperationLimitExceeded(crate::error::OperationLimitExceeded),
    /// <p>The top-level domain does not support this operation.</p>
    TldRulesViolation(crate::error::TldRulesViolation),
    /// <p>Amazon Route 53 does not support this top-level domain (TLD).</p>
    UnsupportedTld(crate::error::UnsupportedTld),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDomainNameserversError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDomainNameserversErrorKind::DuplicateRequest(_inner) => _inner.fmt(f),
            UpdateDomainNameserversErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            UpdateDomainNameserversErrorKind::OperationLimitExceeded(_inner) => _inner.fmt(f),
            UpdateDomainNameserversErrorKind::TldRulesViolation(_inner) => _inner.fmt(f),
            UpdateDomainNameserversErrorKind::UnsupportedTld(_inner) => _inner.fmt(f),
            UpdateDomainNameserversErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDomainNameserversError {
    fn code(&self) -> Option<&str> {
        UpdateDomainNameserversError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDomainNameserversError {
    /// Creates a new `UpdateDomainNameserversError`.
    pub fn new(kind: UpdateDomainNameserversErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDomainNameserversError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDomainNameserversErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDomainNameserversError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDomainNameserversErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateDomainNameserversErrorKind::DuplicateRequest`.
    pub fn is_duplicate_request(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainNameserversErrorKind::DuplicateRequest(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDomainNameserversErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainNameserversErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDomainNameserversErrorKind::OperationLimitExceeded`.
    pub fn is_operation_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainNameserversErrorKind::OperationLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDomainNameserversErrorKind::TldRulesViolation`.
    pub fn is_tld_rules_violation(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainNameserversErrorKind::TldRulesViolation(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDomainNameserversErrorKind::UnsupportedTld`.
    pub fn is_unsupported_tld(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainNameserversErrorKind::UnsupportedTld(_)
        )
    }
}
impl std::error::Error for UpdateDomainNameserversError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDomainNameserversErrorKind::DuplicateRequest(_inner) => Some(_inner),
            UpdateDomainNameserversErrorKind::InvalidInput(_inner) => Some(_inner),
            UpdateDomainNameserversErrorKind::OperationLimitExceeded(_inner) => Some(_inner),
            UpdateDomainNameserversErrorKind::TldRulesViolation(_inner) => Some(_inner),
            UpdateDomainNameserversErrorKind::UnsupportedTld(_inner) => Some(_inner),
            UpdateDomainNameserversErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateTagsForDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateTagsForDomainError {
    /// Kind of error that occurred.
    pub kind: UpdateTagsForDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateTagsForDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateTagsForDomainErrorKind {
    /// <p>The requested item is not acceptable. For example, for APIs that accept a domain name, the request might specify a domain name that doesn't belong to the account that submitted the request. For <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The number of operations or jobs running exceeded the allowed threshold for the account.</p>
    OperationLimitExceeded(crate::error::OperationLimitExceeded),
    /// <p>Amazon Route 53 does not support this top-level domain (TLD).</p>
    UnsupportedTld(crate::error::UnsupportedTld),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateTagsForDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateTagsForDomainErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            UpdateTagsForDomainErrorKind::OperationLimitExceeded(_inner) => _inner.fmt(f),
            UpdateTagsForDomainErrorKind::UnsupportedTld(_inner) => _inner.fmt(f),
            UpdateTagsForDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateTagsForDomainError {
    fn code(&self) -> Option<&str> {
        UpdateTagsForDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateTagsForDomainError {
    /// Creates a new `UpdateTagsForDomainError`.
    pub fn new(kind: UpdateTagsForDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateTagsForDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateTagsForDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateTagsForDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateTagsForDomainErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateTagsForDomainErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, UpdateTagsForDomainErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `UpdateTagsForDomainErrorKind::OperationLimitExceeded`.
    pub fn is_operation_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTagsForDomainErrorKind::OperationLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTagsForDomainErrorKind::UnsupportedTld`.
    pub fn is_unsupported_tld(&self) -> bool {
        matches!(&self.kind, UpdateTagsForDomainErrorKind::UnsupportedTld(_))
    }
}
impl std::error::Error for UpdateTagsForDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateTagsForDomainErrorKind::InvalidInput(_inner) => Some(_inner),
            UpdateTagsForDomainErrorKind::OperationLimitExceeded(_inner) => Some(_inner),
            UpdateTagsForDomainErrorKind::UnsupportedTld(_inner) => Some(_inner),
            UpdateTagsForDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ViewBilling` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ViewBillingError {
    /// Kind of error that occurred.
    pub kind: ViewBillingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ViewBilling` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ViewBillingErrorKind {
    /// <p>The requested item is not acceptable. For example, for APIs that accept a domain name, the request might specify a domain name that doesn't belong to the account that submitted the request. For <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ViewBillingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ViewBillingErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            ViewBillingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ViewBillingError {
    fn code(&self) -> Option<&str> {
        ViewBillingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ViewBillingError {
    /// Creates a new `ViewBillingError`.
    pub fn new(kind: ViewBillingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ViewBillingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ViewBillingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ViewBillingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ViewBillingErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ViewBillingErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, ViewBillingErrorKind::InvalidInput(_))
    }
}
impl std::error::Error for ViewBillingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ViewBillingErrorKind::InvalidInput(_inner) => Some(_inner),
            ViewBillingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The requested item is not acceptable. For example, for APIs that accept a domain name, the request might specify a domain name that doesn't belong to the account that submitted the request. For <code>AcceptDomainTransferFromAnotherAwsAccount</code>, the password might be invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidInput {
    /// <p>The requested item is not acceptable. For example, for an OperationId it might refer to the ID of an operation that is already completed. For a domain name, it might not be a valid domain name or belong to the requester account.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidInput");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidInput {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidInput")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidInput {}
/// See [`InvalidInput`](crate::error::InvalidInput)
pub mod invalid_input {
    /// A builder for [`InvalidInput`](crate::error::InvalidInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The requested item is not acceptable. For example, for an OperationId it might refer to the ID of an operation that is already completed. For a domain name, it might not be a valid domain name or belong to the requester account.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The requested item is not acceptable. For example, for an OperationId it might refer to the ID of an operation that is already completed. For a domain name, it might not be a valid domain name or belong to the requester account.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidInput`](crate::error::InvalidInput)
        pub fn build(self) -> crate::error::InvalidInput {
            crate::error::InvalidInput {
                message: self.message,
            }
        }
    }
}
impl InvalidInput {
    /// Creates a new builder-style object to manufacture [`InvalidInput`](crate::error::InvalidInput)
    pub fn builder() -> crate::error::invalid_input::Builder {
        crate::error::invalid_input::Builder::default()
    }
}

/// <p>Amazon Route 53 does not support this top-level domain (TLD).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedTld {
    /// <p>Amazon Route 53 does not support this top-level domain (TLD).</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnsupportedTld {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedTld");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnsupportedTld {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedTld {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedTld [UnsupportedTLD]")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedTld {}
/// See [`UnsupportedTld`](crate::error::UnsupportedTld)
pub mod unsupported_tld {
    /// A builder for [`UnsupportedTld`](crate::error::UnsupportedTld)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Route 53 does not support this top-level domain (TLD).</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Amazon Route 53 does not support this top-level domain (TLD).</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedTld`](crate::error::UnsupportedTld)
        pub fn build(self) -> crate::error::UnsupportedTld {
            crate::error::UnsupportedTld {
                message: self.message,
            }
        }
    }
}
impl UnsupportedTld {
    /// Creates a new builder-style object to manufacture [`UnsupportedTld`](crate::error::UnsupportedTld)
    pub fn builder() -> crate::error::unsupported_tld::Builder {
        crate::error::unsupported_tld::Builder::default()
    }
}

/// <p>The number of operations or jobs running exceeded the allowed threshold for the account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OperationLimitExceeded {
    /// <p>The number of operations or jobs running exceeded the allowed threshold for the account.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OperationLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OperationLimitExceeded");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OperationLimitExceeded {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OperationLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OperationLimitExceeded")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for OperationLimitExceeded {}
/// See [`OperationLimitExceeded`](crate::error::OperationLimitExceeded)
pub mod operation_limit_exceeded {
    /// A builder for [`OperationLimitExceeded`](crate::error::OperationLimitExceeded)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The number of operations or jobs running exceeded the allowed threshold for the account.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The number of operations or jobs running exceeded the allowed threshold for the account.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OperationLimitExceeded`](crate::error::OperationLimitExceeded)
        pub fn build(self) -> crate::error::OperationLimitExceeded {
            crate::error::OperationLimitExceeded {
                message: self.message,
            }
        }
    }
}
impl OperationLimitExceeded {
    /// Creates a new builder-style object to manufacture [`OperationLimitExceeded`](crate::error::OperationLimitExceeded)
    pub fn builder() -> crate::error::operation_limit_exceeded::Builder {
        crate::error::operation_limit_exceeded::Builder::default()
    }
}

/// <p>The top-level domain does not support this operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TldRulesViolation {
    /// <p>The top-level domain does not support this operation.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TldRulesViolation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TldRulesViolation");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TldRulesViolation {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TldRulesViolation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TldRulesViolation [TLDRulesViolation]")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for TldRulesViolation {}
/// See [`TldRulesViolation`](crate::error::TldRulesViolation)
pub mod tld_rules_violation {
    /// A builder for [`TldRulesViolation`](crate::error::TldRulesViolation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The top-level domain does not support this operation.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The top-level domain does not support this operation.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TldRulesViolation`](crate::error::TldRulesViolation)
        pub fn build(self) -> crate::error::TldRulesViolation {
            crate::error::TldRulesViolation {
                message: self.message,
            }
        }
    }
}
impl TldRulesViolation {
    /// Creates a new builder-style object to manufacture [`TldRulesViolation`](crate::error::TldRulesViolation)
    pub fn builder() -> crate::error::tld_rules_violation::Builder {
        crate::error::tld_rules_violation::Builder::default()
    }
}

/// <p>The request is already in progress for the domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DuplicateRequest {
    /// <p>The request is already in progress for the domain.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DuplicateRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DuplicateRequest");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DuplicateRequest {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DuplicateRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DuplicateRequest")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for DuplicateRequest {}
/// See [`DuplicateRequest`](crate::error::DuplicateRequest)
pub mod duplicate_request {
    /// A builder for [`DuplicateRequest`](crate::error::DuplicateRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request is already in progress for the domain.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The request is already in progress for the domain.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DuplicateRequest`](crate::error::DuplicateRequest)
        pub fn build(self) -> crate::error::DuplicateRequest {
            crate::error::DuplicateRequest {
                message: self.message,
            }
        }
    }
}
impl DuplicateRequest {
    /// Creates a new builder-style object to manufacture [`DuplicateRequest`](crate::error::DuplicateRequest)
    pub fn builder() -> crate::error::duplicate_request::Builder {
        crate::error::duplicate_request::Builder::default()
    }
}

/// <p>The number of domains has exceeded the allowed threshold for the account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainLimitExceeded {
    /// <p>The number of domains has exceeded the allowed threshold for the account.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DomainLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainLimitExceeded");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DomainLimitExceeded {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DomainLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DomainLimitExceeded")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for DomainLimitExceeded {}
/// See [`DomainLimitExceeded`](crate::error::DomainLimitExceeded)
pub mod domain_limit_exceeded {
    /// A builder for [`DomainLimitExceeded`](crate::error::DomainLimitExceeded)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The number of domains has exceeded the allowed threshold for the account.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The number of domains has exceeded the allowed threshold for the account.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainLimitExceeded`](crate::error::DomainLimitExceeded)
        pub fn build(self) -> crate::error::DomainLimitExceeded {
            crate::error::DomainLimitExceeded {
                message: self.message,
            }
        }
    }
}
impl DomainLimitExceeded {
    /// Creates a new builder-style object to manufacture [`DomainLimitExceeded`](crate::error::DomainLimitExceeded)
    pub fn builder() -> crate::error::domain_limit_exceeded::Builder {
        crate::error::domain_limit_exceeded::Builder::default()
    }
}
