// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AcceptDomainTransferFromAnotherAwsAccountInput`](crate::input::AcceptDomainTransferFromAnotherAwsAccountInput)
pub mod accept_domain_transfer_from_another_aws_account_input {
    /// A builder for [`AcceptDomainTransferFromAnotherAwsAccountInput`](crate::input::AcceptDomainTransferFromAnotherAwsAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the domain that was specified when another Amazon Web Services account submitted a <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html">TransferDomainToAnotherAwsAccount</a> request. </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the domain that was specified when another Amazon Web Services account submitted a <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html">TransferDomainToAnotherAwsAccount</a> request. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The password that was returned by the <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html">TransferDomainToAnotherAwsAccount</a> request. </p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>The password that was returned by the <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html">TransferDomainToAnotherAwsAccount</a> request. </p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// Consumes the builder and constructs a [`AcceptDomainTransferFromAnotherAwsAccountInput`](crate::input::AcceptDomainTransferFromAnotherAwsAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AcceptDomainTransferFromAnotherAwsAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::AcceptDomainTransferFromAnotherAwsAccountInput {
                    domain_name: self.domain_name,
                    password: self.password,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type AcceptDomainTransferFromAnotherAwsAccountInputOperationOutputAlias =
    crate::operation::AcceptDomainTransferFromAnotherAwsAccount;
#[doc(hidden)]
pub type AcceptDomainTransferFromAnotherAwsAccountInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AcceptDomainTransferFromAnotherAwsAccountInput {
    /// Consumes the builder and constructs an Operation<[`AcceptDomainTransferFromAnotherAwsAccount`](crate::operation::AcceptDomainTransferFromAnotherAwsAccount)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AcceptDomainTransferFromAnotherAwsAccount,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AcceptDomainTransferFromAnotherAwsAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AcceptDomainTransferFromAnotherAwsAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AcceptDomainTransferFromAnotherAwsAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Domains_v20140515.AcceptDomainTransferFromAnotherAwsAccount",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_accept_domain_transfer_from_another_aws_account(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AcceptDomainTransferFromAnotherAwsAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AcceptDomainTransferFromAnotherAwsAccount",
            "route53domains",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AcceptDomainTransferFromAnotherAwsAccountInput`](crate::input::AcceptDomainTransferFromAnotherAwsAccountInput)
    pub fn builder() -> crate::input::accept_domain_transfer_from_another_aws_account_input::Builder
    {
        crate::input::accept_domain_transfer_from_another_aws_account_input::Builder::default()
    }
}

/// See [`CancelDomainTransferToAnotherAwsAccountInput`](crate::input::CancelDomainTransferToAnotherAwsAccountInput)
pub mod cancel_domain_transfer_to_another_aws_account_input {
    /// A builder for [`CancelDomainTransferToAnotherAwsAccountInput`](crate::input::CancelDomainTransferToAnotherAwsAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the domain for which you want to cancel the transfer to another Amazon Web Services account.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the domain for which you want to cancel the transfer to another Amazon Web Services account.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelDomainTransferToAnotherAwsAccountInput`](crate::input::CancelDomainTransferToAnotherAwsAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelDomainTransferToAnotherAwsAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelDomainTransferToAnotherAwsAccountInput {
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelDomainTransferToAnotherAwsAccountInputOperationOutputAlias =
    crate::operation::CancelDomainTransferToAnotherAwsAccount;
#[doc(hidden)]
pub type CancelDomainTransferToAnotherAwsAccountInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CancelDomainTransferToAnotherAwsAccountInput {
    /// Consumes the builder and constructs an Operation<[`CancelDomainTransferToAnotherAwsAccount`](crate::operation::CancelDomainTransferToAnotherAwsAccount)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelDomainTransferToAnotherAwsAccount,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CancelDomainTransferToAnotherAwsAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CancelDomainTransferToAnotherAwsAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CancelDomainTransferToAnotherAwsAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Domains_v20140515.CancelDomainTransferToAnotherAwsAccount",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_cancel_domain_transfer_to_another_aws_account(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelDomainTransferToAnotherAwsAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelDomainTransferToAnotherAwsAccount",
            "route53domains",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CancelDomainTransferToAnotherAwsAccountInput`](crate::input::CancelDomainTransferToAnotherAwsAccountInput)
    pub fn builder() -> crate::input::cancel_domain_transfer_to_another_aws_account_input::Builder {
        crate::input::cancel_domain_transfer_to_another_aws_account_input::Builder::default()
    }
}

/// See [`CheckDomainAvailabilityInput`](crate::input::CheckDomainAvailabilityInput)
pub mod check_domain_availability_input {
    /// A builder for [`CheckDomainAvailabilityInput`](crate::input::CheckDomainAvailabilityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) idn_lang_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the domain that you want to get availability for. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>The domain name can contain only the following characters:</p>
        /// <ul>
        /// <li> <p>Letters a through z. Domain names are not case sensitive.</p> </li>
        /// <li> <p>Numbers 0 through 9.</p> </li>
        /// <li> <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p> </li>
        /// <li> <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p> </li>
        /// </ul>
        /// <p>Internationalized domain names are not supported for some top-level domains. To determine whether the TLD that you want to use supports internationalized domain names, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a>. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html#domain-name-format-idns">Formatting Internationalized Domain Names</a>. </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the domain that you want to get availability for. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>The domain name can contain only the following characters:</p>
        /// <ul>
        /// <li> <p>Letters a through z. Domain names are not case sensitive.</p> </li>
        /// <li> <p>Numbers 0 through 9.</p> </li>
        /// <li> <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p> </li>
        /// <li> <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p> </li>
        /// </ul>
        /// <p>Internationalized domain names are not supported for some top-level domains. To determine whether the TLD that you want to use supports internationalized domain names, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a>. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html#domain-name-format-idns">Formatting Internationalized Domain Names</a>. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn idn_lang_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.idn_lang_code = Some(input.into());
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_idn_lang_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.idn_lang_code = input;
            self
        }
        /// Consumes the builder and constructs a [`CheckDomainAvailabilityInput`](crate::input::CheckDomainAvailabilityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CheckDomainAvailabilityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CheckDomainAvailabilityInput {
                domain_name: self.domain_name,
                idn_lang_code: self.idn_lang_code,
            })
        }
    }
}
#[doc(hidden)]
pub type CheckDomainAvailabilityInputOperationOutputAlias =
    crate::operation::CheckDomainAvailability;
#[doc(hidden)]
pub type CheckDomainAvailabilityInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CheckDomainAvailabilityInput {
    /// Consumes the builder and constructs an Operation<[`CheckDomainAvailability`](crate::operation::CheckDomainAvailability)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CheckDomainAvailability,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CheckDomainAvailabilityInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CheckDomainAvailabilityInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CheckDomainAvailabilityInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Domains_v20140515.CheckDomainAvailability",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_check_domain_availability(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CheckDomainAvailability::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CheckDomainAvailability",
            "route53domains",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CheckDomainAvailabilityInput`](crate::input::CheckDomainAvailabilityInput)
    pub fn builder() -> crate::input::check_domain_availability_input::Builder {
        crate::input::check_domain_availability_input::Builder::default()
    }
}

/// See [`CheckDomainTransferabilityInput`](crate::input::CheckDomainTransferabilityInput)
pub mod check_domain_transferability_input {
    /// A builder for [`CheckDomainTransferabilityInput`](crate::input::CheckDomainTransferabilityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) auth_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the domain that you want to transfer to Route 53. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>The domain name can contain only the following characters:</p>
        /// <ul>
        /// <li> <p>Letters a through z. Domain names are not case sensitive.</p> </li>
        /// <li> <p>Numbers 0 through 9.</p> </li>
        /// <li> <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p> </li>
        /// <li> <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p> </li>
        /// </ul>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the domain that you want to transfer to Route 53. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>The domain name can contain only the following characters:</p>
        /// <ul>
        /// <li> <p>Letters a through z. Domain names are not case sensitive.</p> </li>
        /// <li> <p>Numbers 0 through 9.</p> </li>
        /// <li> <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p> </li>
        /// <li> <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p> </li>
        /// </ul>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>If the registrar for the top-level domain (TLD) requires an authorization code to transfer the domain, the code that you got from the current registrar for the domain.</p>
        pub fn auth_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.auth_code = Some(input.into());
            self
        }
        /// <p>If the registrar for the top-level domain (TLD) requires an authorization code to transfer the domain, the code that you got from the current registrar for the domain.</p>
        pub fn set_auth_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.auth_code = input;
            self
        }
        /// Consumes the builder and constructs a [`CheckDomainTransferabilityInput`](crate::input::CheckDomainTransferabilityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CheckDomainTransferabilityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CheckDomainTransferabilityInput {
                domain_name: self.domain_name,
                auth_code: self.auth_code,
            })
        }
    }
}
#[doc(hidden)]
pub type CheckDomainTransferabilityInputOperationOutputAlias =
    crate::operation::CheckDomainTransferability;
#[doc(hidden)]
pub type CheckDomainTransferabilityInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CheckDomainTransferabilityInput {
    /// Consumes the builder and constructs an Operation<[`CheckDomainTransferability`](crate::operation::CheckDomainTransferability)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CheckDomainTransferability,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CheckDomainTransferabilityInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CheckDomainTransferabilityInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CheckDomainTransferabilityInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Domains_v20140515.CheckDomainTransferability",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_check_domain_transferability(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CheckDomainTransferability::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CheckDomainTransferability",
            "route53domains",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CheckDomainTransferabilityInput`](crate::input::CheckDomainTransferabilityInput)
    pub fn builder() -> crate::input::check_domain_transferability_input::Builder {
        crate::input::check_domain_transferability_input::Builder::default()
    }
}

/// See [`DeleteDomainInput`](crate::input::DeleteDomainInput)
pub mod delete_domain_input {
    /// A builder for [`DeleteDomainInput`](crate::input::DeleteDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Name of the domain to be deleted.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>Name of the domain to be deleted.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDomainInput`](crate::input::DeleteDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDomainInput {
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDomainInputOperationOutputAlias = crate::operation::DeleteDomain;
#[doc(hidden)]
pub type DeleteDomainInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDomainInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDomain`](crate::operation::DeleteDomain)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDomain,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDomainInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDomainInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDomainInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Domains_v20140515.DeleteDomain",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_domain(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDomain",
            "route53domains",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDomainInput`](crate::input::DeleteDomainInput)
    pub fn builder() -> crate::input::delete_domain_input::Builder {
        crate::input::delete_domain_input::Builder::default()
    }
}

/// See [`DeleteTagsForDomainInput`](crate::input::DeleteTagsForDomainInput)
pub mod delete_tags_for_domain_input {
    /// A builder for [`DeleteTagsForDomainInput`](crate::input::DeleteTagsForDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) tags_to_delete: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The domain for which you want to delete one or more tags.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain for which you want to delete one or more tags.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Appends an item to `tags_to_delete`.
        ///
        /// To override the contents of this collection use [`set_tags_to_delete`](Self::set_tags_to_delete).
        ///
        /// <p>A list of tag keys to delete.</p>
        pub fn tags_to_delete(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tags_to_delete.unwrap_or_default();
            v.push(input.into());
            self.tags_to_delete = Some(v);
            self
        }
        /// <p>A list of tag keys to delete.</p>
        pub fn set_tags_to_delete(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tags_to_delete = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTagsForDomainInput`](crate::input::DeleteTagsForDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteTagsForDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteTagsForDomainInput {
                domain_name: self.domain_name,
                tags_to_delete: self.tags_to_delete,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteTagsForDomainInputOperationOutputAlias = crate::operation::DeleteTagsForDomain;
#[doc(hidden)]
pub type DeleteTagsForDomainInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteTagsForDomainInput {
    /// Consumes the builder and constructs an Operation<[`DeleteTagsForDomain`](crate::operation::DeleteTagsForDomain)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteTagsForDomain,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteTagsForDomainInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteTagsForDomainInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteTagsForDomainInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Domains_v20140515.DeleteTagsForDomain",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_tags_for_domain(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteTagsForDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteTagsForDomain",
            "route53domains",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteTagsForDomainInput`](crate::input::DeleteTagsForDomainInput)
    pub fn builder() -> crate::input::delete_tags_for_domain_input::Builder {
        crate::input::delete_tags_for_domain_input::Builder::default()
    }
}

/// See [`DisableDomainAutoRenewInput`](crate::input::DisableDomainAutoRenewInput)
pub mod disable_domain_auto_renew_input {
    /// A builder for [`DisableDomainAutoRenewInput`](crate::input::DisableDomainAutoRenewInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the domain that you want to disable automatic renewal for.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the domain that you want to disable automatic renewal for.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DisableDomainAutoRenewInput`](crate::input::DisableDomainAutoRenewInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisableDomainAutoRenewInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisableDomainAutoRenewInput {
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DisableDomainAutoRenewInputOperationOutputAlias = crate::operation::DisableDomainAutoRenew;
#[doc(hidden)]
pub type DisableDomainAutoRenewInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DisableDomainAutoRenewInput {
    /// Consumes the builder and constructs an Operation<[`DisableDomainAutoRenew`](crate::operation::DisableDomainAutoRenew)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisableDomainAutoRenew,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisableDomainAutoRenewInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisableDomainAutoRenewInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisableDomainAutoRenewInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Domains_v20140515.DisableDomainAutoRenew",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disable_domain_auto_renew(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisableDomainAutoRenew::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisableDomainAutoRenew",
            "route53domains",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisableDomainAutoRenewInput`](crate::input::DisableDomainAutoRenewInput)
    pub fn builder() -> crate::input::disable_domain_auto_renew_input::Builder {
        crate::input::disable_domain_auto_renew_input::Builder::default()
    }
}

/// See [`DisableDomainTransferLockInput`](crate::input::DisableDomainTransferLockInput)
pub mod disable_domain_transfer_lock_input {
    /// A builder for [`DisableDomainTransferLockInput`](crate::input::DisableDomainTransferLockInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the domain that you want to remove the transfer lock for.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the domain that you want to remove the transfer lock for.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DisableDomainTransferLockInput`](crate::input::DisableDomainTransferLockInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisableDomainTransferLockInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisableDomainTransferLockInput {
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DisableDomainTransferLockInputOperationOutputAlias =
    crate::operation::DisableDomainTransferLock;
#[doc(hidden)]
pub type DisableDomainTransferLockInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DisableDomainTransferLockInput {
    /// Consumes the builder and constructs an Operation<[`DisableDomainTransferLock`](crate::operation::DisableDomainTransferLock)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisableDomainTransferLock,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisableDomainTransferLockInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisableDomainTransferLockInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisableDomainTransferLockInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Domains_v20140515.DisableDomainTransferLock",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disable_domain_transfer_lock(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisableDomainTransferLock::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisableDomainTransferLock",
            "route53domains",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisableDomainTransferLockInput`](crate::input::DisableDomainTransferLockInput)
    pub fn builder() -> crate::input::disable_domain_transfer_lock_input::Builder {
        crate::input::disable_domain_transfer_lock_input::Builder::default()
    }
}

/// See [`EnableDomainAutoRenewInput`](crate::input::EnableDomainAutoRenewInput)
pub mod enable_domain_auto_renew_input {
    /// A builder for [`EnableDomainAutoRenewInput`](crate::input::EnableDomainAutoRenewInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the domain that you want to enable automatic renewal for.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the domain that you want to enable automatic renewal for.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableDomainAutoRenewInput`](crate::input::EnableDomainAutoRenewInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::EnableDomainAutoRenewInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::EnableDomainAutoRenewInput {
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type EnableDomainAutoRenewInputOperationOutputAlias = crate::operation::EnableDomainAutoRenew;
#[doc(hidden)]
pub type EnableDomainAutoRenewInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl EnableDomainAutoRenewInput {
    /// Consumes the builder and constructs an Operation<[`EnableDomainAutoRenew`](crate::operation::EnableDomainAutoRenew)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::EnableDomainAutoRenew,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::EnableDomainAutoRenewInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::EnableDomainAutoRenewInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::EnableDomainAutoRenewInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Domains_v20140515.EnableDomainAutoRenew",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_enable_domain_auto_renew(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::EnableDomainAutoRenew::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "EnableDomainAutoRenew",
            "route53domains",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`EnableDomainAutoRenewInput`](crate::input::EnableDomainAutoRenewInput)
    pub fn builder() -> crate::input::enable_domain_auto_renew_input::Builder {
        crate::input::enable_domain_auto_renew_input::Builder::default()
    }
}

/// See [`EnableDomainTransferLockInput`](crate::input::EnableDomainTransferLockInput)
pub mod enable_domain_transfer_lock_input {
    /// A builder for [`EnableDomainTransferLockInput`](crate::input::EnableDomainTransferLockInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the domain that you want to set the transfer lock for.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the domain that you want to set the transfer lock for.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableDomainTransferLockInput`](crate::input::EnableDomainTransferLockInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::EnableDomainTransferLockInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::EnableDomainTransferLockInput {
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type EnableDomainTransferLockInputOperationOutputAlias =
    crate::operation::EnableDomainTransferLock;
#[doc(hidden)]
pub type EnableDomainTransferLockInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl EnableDomainTransferLockInput {
    /// Consumes the builder and constructs an Operation<[`EnableDomainTransferLock`](crate::operation::EnableDomainTransferLock)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::EnableDomainTransferLock,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::EnableDomainTransferLockInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::EnableDomainTransferLockInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::EnableDomainTransferLockInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Domains_v20140515.EnableDomainTransferLock",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_enable_domain_transfer_lock(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::EnableDomainTransferLock::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "EnableDomainTransferLock",
            "route53domains",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`EnableDomainTransferLockInput`](crate::input::EnableDomainTransferLockInput)
    pub fn builder() -> crate::input::enable_domain_transfer_lock_input::Builder {
        crate::input::enable_domain_transfer_lock_input::Builder::default()
    }
}

/// See [`GetContactReachabilityStatusInput`](crate::input::GetContactReachabilityStatusInput)
pub mod get_contact_reachability_status_input {
    /// A builder for [`GetContactReachabilityStatusInput`](crate::input::GetContactReachabilityStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the domain for which you want to know whether the registrant contact has confirmed that the email address is valid.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the domain for which you want to know whether the registrant contact has confirmed that the email address is valid.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetContactReachabilityStatusInput`](crate::input::GetContactReachabilityStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetContactReachabilityStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetContactReachabilityStatusInput {
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetContactReachabilityStatusInputOperationOutputAlias =
    crate::operation::GetContactReachabilityStatus;
#[doc(hidden)]
pub type GetContactReachabilityStatusInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetContactReachabilityStatusInput {
    /// Consumes the builder and constructs an Operation<[`GetContactReachabilityStatus`](crate::operation::GetContactReachabilityStatus)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetContactReachabilityStatus,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetContactReachabilityStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetContactReachabilityStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetContactReachabilityStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Domains_v20140515.GetContactReachabilityStatus",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_contact_reachability_status(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetContactReachabilityStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetContactReachabilityStatus",
            "route53domains",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetContactReachabilityStatusInput`](crate::input::GetContactReachabilityStatusInput)
    pub fn builder() -> crate::input::get_contact_reachability_status_input::Builder {
        crate::input::get_contact_reachability_status_input::Builder::default()
    }
}

/// See [`GetDomainDetailInput`](crate::input::GetDomainDetailInput)
pub mod get_domain_detail_input {
    /// A builder for [`GetDomainDetailInput`](crate::input::GetDomainDetailInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the domain that you want to get detailed information about.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the domain that you want to get detailed information about.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDomainDetailInput`](crate::input::GetDomainDetailInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDomainDetailInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDomainDetailInput {
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDomainDetailInputOperationOutputAlias = crate::operation::GetDomainDetail;
#[doc(hidden)]
pub type GetDomainDetailInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDomainDetailInput {
    /// Consumes the builder and constructs an Operation<[`GetDomainDetail`](crate::operation::GetDomainDetail)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDomainDetail,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDomainDetailInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDomainDetailInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDomainDetailInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Domains_v20140515.GetDomainDetail",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_domain_detail(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDomainDetail::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDomainDetail",
            "route53domains",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDomainDetailInput`](crate::input::GetDomainDetailInput)
    pub fn builder() -> crate::input::get_domain_detail_input::Builder {
        crate::input::get_domain_detail_input::Builder::default()
    }
}

/// See [`GetDomainSuggestionsInput`](crate::input::GetDomainSuggestionsInput)
pub mod get_domain_suggestions_input {
    /// A builder for [`GetDomainSuggestionsInput`](crate::input::GetDomainSuggestionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) suggestion_count: std::option::Option<i32>,
        pub(crate) only_available: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>A domain name that you want to use as the basis for a list of possible domain names. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>The domain name can contain only the following characters:</p>
        /// <ul>
        /// <li> <p>Letters a through z. Domain names are not case sensitive.</p> </li>
        /// <li> <p>Numbers 0 through 9.</p> </li>
        /// <li> <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p> </li>
        /// <li> <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p> </li>
        /// </ul>
        /// <p>Internationalized domain names are not supported for some top-level domains. To determine whether the TLD that you want to use supports internationalized domain names, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a>. </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>A domain name that you want to use as the basis for a list of possible domain names. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>The domain name can contain only the following characters:</p>
        /// <ul>
        /// <li> <p>Letters a through z. Domain names are not case sensitive.</p> </li>
        /// <li> <p>Numbers 0 through 9.</p> </li>
        /// <li> <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p> </li>
        /// <li> <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p> </li>
        /// </ul>
        /// <p>Internationalized domain names are not supported for some top-level domains. To determine whether the TLD that you want to use supports internationalized domain names, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a>. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The number of suggested domain names that you want Route 53 to return. Specify a value between 1 and 50.</p>
        pub fn suggestion_count(mut self, input: i32) -> Self {
            self.suggestion_count = Some(input);
            self
        }
        /// <p>The number of suggested domain names that you want Route 53 to return. Specify a value between 1 and 50.</p>
        pub fn set_suggestion_count(mut self, input: std::option::Option<i32>) -> Self {
            self.suggestion_count = input;
            self
        }
        /// <p>If <code>OnlyAvailable</code> is <code>true</code>, Route 53 returns only domain names that are available. If <code>OnlyAvailable</code> is <code>false</code>, Route 53 returns domain names without checking whether they're available to be registered. To determine whether the domain is available, you can call <code>checkDomainAvailability</code> for each suggestion.</p>
        pub fn only_available(mut self, input: bool) -> Self {
            self.only_available = Some(input);
            self
        }
        /// <p>If <code>OnlyAvailable</code> is <code>true</code>, Route 53 returns only domain names that are available. If <code>OnlyAvailable</code> is <code>false</code>, Route 53 returns domain names without checking whether they're available to be registered. To determine whether the domain is available, you can call <code>checkDomainAvailability</code> for each suggestion.</p>
        pub fn set_only_available(mut self, input: std::option::Option<bool>) -> Self {
            self.only_available = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDomainSuggestionsInput`](crate::input::GetDomainSuggestionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDomainSuggestionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDomainSuggestionsInput {
                domain_name: self.domain_name,
                suggestion_count: self.suggestion_count.unwrap_or_default(),
                only_available: self.only_available,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDomainSuggestionsInputOperationOutputAlias = crate::operation::GetDomainSuggestions;
#[doc(hidden)]
pub type GetDomainSuggestionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDomainSuggestionsInput {
    /// Consumes the builder and constructs an Operation<[`GetDomainSuggestions`](crate::operation::GetDomainSuggestions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDomainSuggestions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDomainSuggestionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDomainSuggestionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDomainSuggestionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Domains_v20140515.GetDomainSuggestions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_domain_suggestions(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDomainSuggestions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDomainSuggestions",
            "route53domains",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDomainSuggestionsInput`](crate::input::GetDomainSuggestionsInput)
    pub fn builder() -> crate::input::get_domain_suggestions_input::Builder {
        crate::input::get_domain_suggestions_input::Builder::default()
    }
}

/// See [`GetOperationDetailInput`](crate::input::GetOperationDetailInput)
pub mod get_operation_detail_input {
    /// A builder for [`GetOperationDetailInput`](crate::input::GetOperationDetailInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier for the operation for which you want to get the status. Route 53 returned the identifier in the response to the original request.</p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>The identifier for the operation for which you want to get the status. Route 53 returned the identifier in the response to the original request.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetOperationDetailInput`](crate::input::GetOperationDetailInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetOperationDetailInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetOperationDetailInput {
                operation_id: self.operation_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetOperationDetailInputOperationOutputAlias = crate::operation::GetOperationDetail;
#[doc(hidden)]
pub type GetOperationDetailInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetOperationDetailInput {
    /// Consumes the builder and constructs an Operation<[`GetOperationDetail`](crate::operation::GetOperationDetail)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetOperationDetail,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetOperationDetailInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetOperationDetailInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetOperationDetailInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Domains_v20140515.GetOperationDetail",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_operation_detail(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetOperationDetail::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetOperationDetail",
            "route53domains",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetOperationDetailInput`](crate::input::GetOperationDetailInput)
    pub fn builder() -> crate::input::get_operation_detail_input::Builder {
        crate::input::get_operation_detail_input::Builder::default()
    }
}

/// See [`ListDomainsInput`](crate::input::ListDomainsInput)
pub mod list_domains_input {
    /// A builder for [`ListDomainsInput`](crate::input::ListDomainsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter_conditions:
            std::option::Option<std::vec::Vec<crate::model::FilterCondition>>,
        pub(crate) sort_condition: std::option::Option<crate::model::SortCondition>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `filter_conditions`.
        ///
        /// To override the contents of this collection use [`set_filter_conditions`](Self::set_filter_conditions).
        ///
        /// <p>A complex type that contains information about the filters applied during the <code>ListDomains</code> request. The filter conditions can include domain name and domain expiration.</p>
        pub fn filter_conditions(mut self, input: crate::model::FilterCondition) -> Self {
            let mut v = self.filter_conditions.unwrap_or_default();
            v.push(input);
            self.filter_conditions = Some(v);
            self
        }
        /// <p>A complex type that contains information about the filters applied during the <code>ListDomains</code> request. The filter conditions can include domain name and domain expiration.</p>
        pub fn set_filter_conditions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FilterCondition>>,
        ) -> Self {
            self.filter_conditions = input;
            self
        }
        /// <p>A complex type that contains information about the requested ordering of domains in the returned list.</p>
        pub fn sort_condition(mut self, input: crate::model::SortCondition) -> Self {
            self.sort_condition = Some(input);
            self
        }
        /// <p>A complex type that contains information about the requested ordering of domains in the returned list.</p>
        pub fn set_sort_condition(
            mut self,
            input: std::option::Option<crate::model::SortCondition>,
        ) -> Self {
            self.sort_condition = input;
            self
        }
        /// <p>For an initial request for a list of domains, omit this element. If the number of domains that are associated with the current Amazon Web Services account is greater than the value that you specified for <code>MaxItems</code>, you can use <code>Marker</code> to return additional domains. Get the value of <code>NextPageMarker</code> from the previous response, and submit another request that includes the value of <code>NextPageMarker</code> in the <code>Marker</code> element.</p>
        /// <p>Constraints: The marker must match the value specified in the previous request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>For an initial request for a list of domains, omit this element. If the number of domains that are associated with the current Amazon Web Services account is greater than the value that you specified for <code>MaxItems</code>, you can use <code>Marker</code> to return additional domains. Get the value of <code>NextPageMarker</code> from the previous response, and submit another request that includes the value of <code>NextPageMarker</code> in the <code>Marker</code> element.</p>
        /// <p>Constraints: The marker must match the value specified in the previous request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Number of domains to be returned.</p>
        /// <p>Default: 20</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>Number of domains to be returned.</p>
        /// <p>Default: 20</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDomainsInput`](crate::input::ListDomainsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDomainsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDomainsInput {
                filter_conditions: self.filter_conditions,
                sort_condition: self.sort_condition,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDomainsInputOperationOutputAlias = crate::operation::ListDomains;
#[doc(hidden)]
pub type ListDomainsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDomainsInput {
    /// Consumes the builder and constructs an Operation<[`ListDomains`](crate::operation::ListDomains)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDomains,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDomainsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDomainsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDomainsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Domains_v20140515.ListDomains",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_domains(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDomains::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDomains",
            "route53domains",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDomainsInput`](crate::input::ListDomainsInput)
    pub fn builder() -> crate::input::list_domains_input::Builder {
        crate::input::list_domains_input::Builder::default()
    }
}

/// See [`ListOperationsInput`](crate::input::ListOperationsInput)
pub mod list_operations_input {
    /// A builder for [`ListOperationsInput`](crate::input::ListOperationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) submitted_since: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>An optional parameter that lets you get information about all the operations that you submitted after a specified date and time. Specify the date and time in Unix time format and Coordinated Universal time (UTC).</p>
        pub fn submitted_since(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.submitted_since = Some(input);
            self
        }
        /// <p>An optional parameter that lets you get information about all the operations that you submitted after a specified date and time. Specify the date and time in Unix time format and Coordinated Universal time (UTC).</p>
        pub fn set_submitted_since(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.submitted_since = input;
            self
        }
        /// <p>For an initial request for a list of operations, omit this element. If the number of operations that are not yet complete is greater than the value that you specified for <code>MaxItems</code>, you can use <code>Marker</code> to return additional operations. Get the value of <code>NextPageMarker</code> from the previous response, and submit another request that includes the value of <code>NextPageMarker</code> in the <code>Marker</code> element.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>For an initial request for a list of operations, omit this element. If the number of operations that are not yet complete is greater than the value that you specified for <code>MaxItems</code>, you can use <code>Marker</code> to return additional operations. Get the value of <code>NextPageMarker</code> from the previous response, and submit another request that includes the value of <code>NextPageMarker</code> in the <code>Marker</code> element.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Number of domains to be returned.</p>
        /// <p>Default: 20</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>Number of domains to be returned.</p>
        /// <p>Default: 20</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOperationsInput`](crate::input::ListOperationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListOperationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListOperationsInput {
                submitted_since: self.submitted_since,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListOperationsInputOperationOutputAlias = crate::operation::ListOperations;
#[doc(hidden)]
pub type ListOperationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListOperationsInput {
    /// Consumes the builder and constructs an Operation<[`ListOperations`](crate::operation::ListOperations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListOperations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListOperationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListOperationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListOperationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Domains_v20140515.ListOperations",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_operations(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListOperations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListOperations",
            "route53domains",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListOperationsInput`](crate::input::ListOperationsInput)
    pub fn builder() -> crate::input::list_operations_input::Builder {
        crate::input::list_operations_input::Builder::default()
    }
}

/// See [`ListPricesInput`](crate::input::ListPricesInput)
pub mod list_prices_input {
    /// A builder for [`ListPricesInput`](crate::input::ListPricesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tld: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The TLD for which you want to receive the pricing information. For example. <code>.net</code>.</p>
        /// <p>If a <code>Tld</code> value is not provided, a list of prices for all TLDs supported by Route&nbsp;53 is returned.</p>
        pub fn tld(mut self, input: impl Into<std::string::String>) -> Self {
            self.tld = Some(input.into());
            self
        }
        /// <p>The TLD for which you want to receive the pricing information. For example. <code>.net</code>.</p>
        /// <p>If a <code>Tld</code> value is not provided, a list of prices for all TLDs supported by Route&nbsp;53 is returned.</p>
        pub fn set_tld(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tld = input;
            self
        }
        /// <p>For an initial request for a list of prices, omit this element. If the number of prices that are not yet complete is greater than the value that you specified for <code>MaxItems</code>, you can use <code>Marker</code> to return additional prices. Get the value of <code>NextPageMarker</code> from the previous response, and submit another request that includes the value of <code>NextPageMarker</code> in the <code>Marker</code> element. </p>
        /// <p>Used only for all TLDs. If you specify a TLD, don't specify a <code>Marker</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>For an initial request for a list of prices, omit this element. If the number of prices that are not yet complete is greater than the value that you specified for <code>MaxItems</code>, you can use <code>Marker</code> to return additional prices. Get the value of <code>NextPageMarker</code> from the previous response, and submit another request that includes the value of <code>NextPageMarker</code> in the <code>Marker</code> element. </p>
        /// <p>Used only for all TLDs. If you specify a TLD, don't specify a <code>Marker</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Number of <code>Prices</code> to be returned.</p>
        /// <p>Used only for all TLDs. If you specify a TLD, don't specify a <code>MaxItems</code>.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>Number of <code>Prices</code> to be returned.</p>
        /// <p>Used only for all TLDs. If you specify a TLD, don't specify a <code>MaxItems</code>.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPricesInput`](crate::input::ListPricesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPricesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPricesInput {
                tld: self.tld,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPricesInputOperationOutputAlias = crate::operation::ListPrices;
#[doc(hidden)]
pub type ListPricesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListPricesInput {
    /// Consumes the builder and constructs an Operation<[`ListPrices`](crate::operation::ListPrices)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPrices,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPricesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPricesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPricesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Domains_v20140515.ListPrices",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_prices(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPrices::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPrices",
            "route53domains",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPricesInput`](crate::input::ListPricesInput)
    pub fn builder() -> crate::input::list_prices_input::Builder {
        crate::input::list_prices_input::Builder::default()
    }
}

/// See [`ListTagsForDomainInput`](crate::input::ListTagsForDomainInput)
pub mod list_tags_for_domain_input {
    /// A builder for [`ListTagsForDomainInput`](crate::input::ListTagsForDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The domain for which you want to get a list of tags.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain for which you want to get a list of tags.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForDomainInput`](crate::input::ListTagsForDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForDomainInput {
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForDomainInputOperationOutputAlias = crate::operation::ListTagsForDomain;
#[doc(hidden)]
pub type ListTagsForDomainInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForDomainInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForDomain`](crate::operation::ListTagsForDomain)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForDomain,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForDomainInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForDomainInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForDomainInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Domains_v20140515.ListTagsForDomain",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_domain(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForDomain",
            "route53domains",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForDomainInput`](crate::input::ListTagsForDomainInput)
    pub fn builder() -> crate::input::list_tags_for_domain_input::Builder {
        crate::input::list_tags_for_domain_input::Builder::default()
    }
}

/// See [`RegisterDomainInput`](crate::input::RegisterDomainInput)
pub mod register_domain_input {
    /// A builder for [`RegisterDomainInput`](crate::input::RegisterDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) idn_lang_code: std::option::Option<std::string::String>,
        pub(crate) duration_in_years: std::option::Option<i32>,
        pub(crate) auto_renew: std::option::Option<bool>,
        pub(crate) admin_contact: std::option::Option<crate::model::ContactDetail>,
        pub(crate) registrant_contact: std::option::Option<crate::model::ContactDetail>,
        pub(crate) tech_contact: std::option::Option<crate::model::ContactDetail>,
        pub(crate) privacy_protect_admin_contact: std::option::Option<bool>,
        pub(crate) privacy_protect_registrant_contact: std::option::Option<bool>,
        pub(crate) privacy_protect_tech_contact: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The domain name that you want to register. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>The domain name can contain only the following characters:</p>
        /// <ul>
        /// <li> <p>Letters a through z. Domain names are not case sensitive.</p> </li>
        /// <li> <p>Numbers 0 through 9.</p> </li>
        /// <li> <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p> </li>
        /// <li> <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p> </li>
        /// </ul>
        /// <p>Internationalized domain names are not supported for some top-level domains. To determine whether the TLD that you want to use supports internationalized domain names, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a>. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html#domain-name-format-idns">Formatting Internationalized Domain Names</a>. </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain name that you want to register. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>The domain name can contain only the following characters:</p>
        /// <ul>
        /// <li> <p>Letters a through z. Domain names are not case sensitive.</p> </li>
        /// <li> <p>Numbers 0 through 9.</p> </li>
        /// <li> <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p> </li>
        /// <li> <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p> </li>
        /// </ul>
        /// <p>Internationalized domain names are not supported for some top-level domains. To determine whether the TLD that you want to use supports internationalized domain names, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a>. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html#domain-name-format-idns">Formatting Internationalized Domain Names</a>. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn idn_lang_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.idn_lang_code = Some(input.into());
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_idn_lang_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.idn_lang_code = input;
            self
        }
        /// <p>The number of years that you want to register the domain for. Domains are registered for a minimum of one year. The maximum period depends on the top-level domain. For the range of valid values for your domain, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>Default: 1</p>
        pub fn duration_in_years(mut self, input: i32) -> Self {
            self.duration_in_years = Some(input);
            self
        }
        /// <p>The number of years that you want to register the domain for. Domains are registered for a minimum of one year. The maximum period depends on the top-level domain. For the range of valid values for your domain, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>Default: 1</p>
        pub fn set_duration_in_years(mut self, input: std::option::Option<i32>) -> Self {
            self.duration_in_years = input;
            self
        }
        /// <p>Indicates whether the domain will be automatically renewed (<code>true</code>) or not (<code>false</code>). Autorenewal only takes effect after the account is charged.</p>
        /// <p>Default: <code>true</code> </p>
        pub fn auto_renew(mut self, input: bool) -> Self {
            self.auto_renew = Some(input);
            self
        }
        /// <p>Indicates whether the domain will be automatically renewed (<code>true</code>) or not (<code>false</code>). Autorenewal only takes effect after the account is charged.</p>
        /// <p>Default: <code>true</code> </p>
        pub fn set_auto_renew(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_renew = input;
            self
        }
        /// <p>Provides detailed contact information. For information about the values that you specify for each element, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html">ContactDetail</a>.</p>
        pub fn admin_contact(mut self, input: crate::model::ContactDetail) -> Self {
            self.admin_contact = Some(input);
            self
        }
        /// <p>Provides detailed contact information. For information about the values that you specify for each element, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html">ContactDetail</a>.</p>
        pub fn set_admin_contact(
            mut self,
            input: std::option::Option<crate::model::ContactDetail>,
        ) -> Self {
            self.admin_contact = input;
            self
        }
        /// <p>Provides detailed contact information. For information about the values that you specify for each element, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html">ContactDetail</a>.</p>
        pub fn registrant_contact(mut self, input: crate::model::ContactDetail) -> Self {
            self.registrant_contact = Some(input);
            self
        }
        /// <p>Provides detailed contact information. For information about the values that you specify for each element, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html">ContactDetail</a>.</p>
        pub fn set_registrant_contact(
            mut self,
            input: std::option::Option<crate::model::ContactDetail>,
        ) -> Self {
            self.registrant_contact = input;
            self
        }
        /// <p>Provides detailed contact information. For information about the values that you specify for each element, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html">ContactDetail</a>.</p>
        pub fn tech_contact(mut self, input: crate::model::ContactDetail) -> Self {
            self.tech_contact = Some(input);
            self
        }
        /// <p>Provides detailed contact information. For information about the values that you specify for each element, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html">ContactDetail</a>.</p>
        pub fn set_tech_contact(
            mut self,
            input: std::option::Option<crate::model::ContactDetail>,
        ) -> Self {
            self.tech_contact = input;
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the admin contact.</p> <note>
        /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
        /// </note>
        /// <p>Default: <code>true</code> </p>
        pub fn privacy_protect_admin_contact(mut self, input: bool) -> Self {
            self.privacy_protect_admin_contact = Some(input);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the admin contact.</p> <note>
        /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
        /// </note>
        /// <p>Default: <code>true</code> </p>
        pub fn set_privacy_protect_admin_contact(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.privacy_protect_admin_contact = input;
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the registrant contact (the domain owner).</p> <note>
        /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
        /// </note>
        /// <p>Default: <code>true</code> </p>
        pub fn privacy_protect_registrant_contact(mut self, input: bool) -> Self {
            self.privacy_protect_registrant_contact = Some(input);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the registrant contact (the domain owner).</p> <note>
        /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
        /// </note>
        /// <p>Default: <code>true</code> </p>
        pub fn set_privacy_protect_registrant_contact(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.privacy_protect_registrant_contact = input;
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the technical contact.</p> <note>
        /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
        /// </note>
        /// <p>Default: <code>true</code> </p>
        pub fn privacy_protect_tech_contact(mut self, input: bool) -> Self {
            self.privacy_protect_tech_contact = Some(input);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the technical contact.</p> <note>
        /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
        /// </note>
        /// <p>Default: <code>true</code> </p>
        pub fn set_privacy_protect_tech_contact(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.privacy_protect_tech_contact = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterDomainInput`](crate::input::RegisterDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RegisterDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RegisterDomainInput {
                domain_name: self.domain_name,
                idn_lang_code: self.idn_lang_code,
                duration_in_years: self.duration_in_years,
                auto_renew: self.auto_renew,
                admin_contact: self.admin_contact,
                registrant_contact: self.registrant_contact,
                tech_contact: self.tech_contact,
                privacy_protect_admin_contact: self.privacy_protect_admin_contact,
                privacy_protect_registrant_contact: self.privacy_protect_registrant_contact,
                privacy_protect_tech_contact: self.privacy_protect_tech_contact,
            })
        }
    }
}
#[doc(hidden)]
pub type RegisterDomainInputOperationOutputAlias = crate::operation::RegisterDomain;
#[doc(hidden)]
pub type RegisterDomainInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RegisterDomainInput {
    /// Consumes the builder and constructs an Operation<[`RegisterDomain`](crate::operation::RegisterDomain)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RegisterDomain,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RegisterDomainInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RegisterDomainInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RegisterDomainInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Domains_v20140515.RegisterDomain",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_register_domain(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RegisterDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RegisterDomain",
            "route53domains",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RegisterDomainInput`](crate::input::RegisterDomainInput)
    pub fn builder() -> crate::input::register_domain_input::Builder {
        crate::input::register_domain_input::Builder::default()
    }
}

/// See [`RejectDomainTransferFromAnotherAwsAccountInput`](crate::input::RejectDomainTransferFromAnotherAwsAccountInput)
pub mod reject_domain_transfer_from_another_aws_account_input {
    /// A builder for [`RejectDomainTransferFromAnotherAwsAccountInput`](crate::input::RejectDomainTransferFromAnotherAwsAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the domain that was specified when another Amazon Web Services account submitted a <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html">TransferDomainToAnotherAwsAccount</a> request. </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the domain that was specified when another Amazon Web Services account submitted a <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html">TransferDomainToAnotherAwsAccount</a> request. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`RejectDomainTransferFromAnotherAwsAccountInput`](crate::input::RejectDomainTransferFromAnotherAwsAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RejectDomainTransferFromAnotherAwsAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::RejectDomainTransferFromAnotherAwsAccountInput {
                    domain_name: self.domain_name,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type RejectDomainTransferFromAnotherAwsAccountInputOperationOutputAlias =
    crate::operation::RejectDomainTransferFromAnotherAwsAccount;
#[doc(hidden)]
pub type RejectDomainTransferFromAnotherAwsAccountInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl RejectDomainTransferFromAnotherAwsAccountInput {
    /// Consumes the builder and constructs an Operation<[`RejectDomainTransferFromAnotherAwsAccount`](crate::operation::RejectDomainTransferFromAnotherAwsAccount)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RejectDomainTransferFromAnotherAwsAccount,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RejectDomainTransferFromAnotherAwsAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RejectDomainTransferFromAnotherAwsAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RejectDomainTransferFromAnotherAwsAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Domains_v20140515.RejectDomainTransferFromAnotherAwsAccount",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_reject_domain_transfer_from_another_aws_account(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RejectDomainTransferFromAnotherAwsAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RejectDomainTransferFromAnotherAwsAccount",
            "route53domains",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RejectDomainTransferFromAnotherAwsAccountInput`](crate::input::RejectDomainTransferFromAnotherAwsAccountInput)
    pub fn builder() -> crate::input::reject_domain_transfer_from_another_aws_account_input::Builder
    {
        crate::input::reject_domain_transfer_from_another_aws_account_input::Builder::default()
    }
}

/// See [`RenewDomainInput`](crate::input::RenewDomainInput)
pub mod renew_domain_input {
    /// A builder for [`RenewDomainInput`](crate::input::RenewDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) duration_in_years: std::option::Option<i32>,
        pub(crate) current_expiry_year: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the domain that you want to renew.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the domain that you want to renew.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The number of years that you want to renew the domain for. The maximum number of years depends on the top-level domain. For the range of valid values for your domain, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>Default: 1</p>
        pub fn duration_in_years(mut self, input: i32) -> Self {
            self.duration_in_years = Some(input);
            self
        }
        /// <p>The number of years that you want to renew the domain for. The maximum number of years depends on the top-level domain. For the range of valid values for your domain, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>Default: 1</p>
        pub fn set_duration_in_years(mut self, input: std::option::Option<i32>) -> Self {
            self.duration_in_years = input;
            self
        }
        /// <p>The year when the registration for the domain is set to expire. This value must match the current expiration date for the domain.</p>
        pub fn current_expiry_year(mut self, input: i32) -> Self {
            self.current_expiry_year = Some(input);
            self
        }
        /// <p>The year when the registration for the domain is set to expire. This value must match the current expiration date for the domain.</p>
        pub fn set_current_expiry_year(mut self, input: std::option::Option<i32>) -> Self {
            self.current_expiry_year = input;
            self
        }
        /// Consumes the builder and constructs a [`RenewDomainInput`](crate::input::RenewDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RenewDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RenewDomainInput {
                domain_name: self.domain_name,
                duration_in_years: self.duration_in_years,
                current_expiry_year: self.current_expiry_year.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type RenewDomainInputOperationOutputAlias = crate::operation::RenewDomain;
#[doc(hidden)]
pub type RenewDomainInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RenewDomainInput {
    /// Consumes the builder and constructs an Operation<[`RenewDomain`](crate::operation::RenewDomain)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RenewDomain,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RenewDomainInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RenewDomainInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RenewDomainInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Domains_v20140515.RenewDomain",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_renew_domain(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RenewDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RenewDomain",
            "route53domains",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RenewDomainInput`](crate::input::RenewDomainInput)
    pub fn builder() -> crate::input::renew_domain_input::Builder {
        crate::input::renew_domain_input::Builder::default()
    }
}

/// See [`ResendContactReachabilityEmailInput`](crate::input::ResendContactReachabilityEmailInput)
pub mod resend_contact_reachability_email_input {
    /// A builder for [`ResendContactReachabilityEmailInput`](crate::input::ResendContactReachabilityEmailInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the domain for which you want Route 53 to resend a confirmation email to the registrant contact.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the domain for which you want Route 53 to resend a confirmation email to the registrant contact.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ResendContactReachabilityEmailInput`](crate::input::ResendContactReachabilityEmailInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ResendContactReachabilityEmailInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ResendContactReachabilityEmailInput {
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type ResendContactReachabilityEmailInputOperationOutputAlias =
    crate::operation::ResendContactReachabilityEmail;
#[doc(hidden)]
pub type ResendContactReachabilityEmailInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ResendContactReachabilityEmailInput {
    /// Consumes the builder and constructs an Operation<[`ResendContactReachabilityEmail`](crate::operation::ResendContactReachabilityEmail)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ResendContactReachabilityEmail,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ResendContactReachabilityEmailInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ResendContactReachabilityEmailInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ResendContactReachabilityEmailInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Domains_v20140515.ResendContactReachabilityEmail",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_resend_contact_reachability_email(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ResendContactReachabilityEmail::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ResendContactReachabilityEmail",
            "route53domains",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ResendContactReachabilityEmailInput`](crate::input::ResendContactReachabilityEmailInput)
    pub fn builder() -> crate::input::resend_contact_reachability_email_input::Builder {
        crate::input::resend_contact_reachability_email_input::Builder::default()
    }
}

/// See [`RetrieveDomainAuthCodeInput`](crate::input::RetrieveDomainAuthCodeInput)
pub mod retrieve_domain_auth_code_input {
    /// A builder for [`RetrieveDomainAuthCodeInput`](crate::input::RetrieveDomainAuthCodeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the domain that you want to get an authorization code for.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the domain that you want to get an authorization code for.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`RetrieveDomainAuthCodeInput`](crate::input::RetrieveDomainAuthCodeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RetrieveDomainAuthCodeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RetrieveDomainAuthCodeInput {
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type RetrieveDomainAuthCodeInputOperationOutputAlias = crate::operation::RetrieveDomainAuthCode;
#[doc(hidden)]
pub type RetrieveDomainAuthCodeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RetrieveDomainAuthCodeInput {
    /// Consumes the builder and constructs an Operation<[`RetrieveDomainAuthCode`](crate::operation::RetrieveDomainAuthCode)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RetrieveDomainAuthCode,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RetrieveDomainAuthCodeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RetrieveDomainAuthCodeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RetrieveDomainAuthCodeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Domains_v20140515.RetrieveDomainAuthCode",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_retrieve_domain_auth_code(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RetrieveDomainAuthCode::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RetrieveDomainAuthCode",
            "route53domains",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RetrieveDomainAuthCodeInput`](crate::input::RetrieveDomainAuthCodeInput)
    pub fn builder() -> crate::input::retrieve_domain_auth_code_input::Builder {
        crate::input::retrieve_domain_auth_code_input::Builder::default()
    }
}

/// See [`TransferDomainInput`](crate::input::TransferDomainInput)
pub mod transfer_domain_input {
    /// A builder for [`TransferDomainInput`](crate::input::TransferDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) idn_lang_code: std::option::Option<std::string::String>,
        pub(crate) duration_in_years: std::option::Option<i32>,
        pub(crate) nameservers: std::option::Option<std::vec::Vec<crate::model::Nameserver>>,
        pub(crate) auth_code: std::option::Option<std::string::String>,
        pub(crate) auto_renew: std::option::Option<bool>,
        pub(crate) admin_contact: std::option::Option<crate::model::ContactDetail>,
        pub(crate) registrant_contact: std::option::Option<crate::model::ContactDetail>,
        pub(crate) tech_contact: std::option::Option<crate::model::ContactDetail>,
        pub(crate) privacy_protect_admin_contact: std::option::Option<bool>,
        pub(crate) privacy_protect_registrant_contact: std::option::Option<bool>,
        pub(crate) privacy_protect_tech_contact: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the domain that you want to transfer to Route 53. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>The domain name can contain only the following characters:</p>
        /// <ul>
        /// <li> <p>Letters a through z. Domain names are not case sensitive.</p> </li>
        /// <li> <p>Numbers 0 through 9.</p> </li>
        /// <li> <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p> </li>
        /// <li> <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p> </li>
        /// </ul>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the domain that you want to transfer to Route 53. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>The domain name can contain only the following characters:</p>
        /// <ul>
        /// <li> <p>Letters a through z. Domain names are not case sensitive.</p> </li>
        /// <li> <p>Numbers 0 through 9.</p> </li>
        /// <li> <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p> </li>
        /// <li> <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p> </li>
        /// </ul>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn idn_lang_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.idn_lang_code = Some(input.into());
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_idn_lang_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.idn_lang_code = input;
            self
        }
        /// <p>The number of years that you want to register the domain for. Domains are registered for a minimum of one year. The maximum period depends on the top-level domain.</p>
        /// <p>Default: 1</p>
        pub fn duration_in_years(mut self, input: i32) -> Self {
            self.duration_in_years = Some(input);
            self
        }
        /// <p>The number of years that you want to register the domain for. Domains are registered for a minimum of one year. The maximum period depends on the top-level domain.</p>
        /// <p>Default: 1</p>
        pub fn set_duration_in_years(mut self, input: std::option::Option<i32>) -> Self {
            self.duration_in_years = input;
            self
        }
        /// Appends an item to `nameservers`.
        ///
        /// To override the contents of this collection use [`set_nameservers`](Self::set_nameservers).
        ///
        /// <p>Contains details for the host and glue IP addresses.</p>
        pub fn nameservers(mut self, input: crate::model::Nameserver) -> Self {
            let mut v = self.nameservers.unwrap_or_default();
            v.push(input);
            self.nameservers = Some(v);
            self
        }
        /// <p>Contains details for the host and glue IP addresses.</p>
        pub fn set_nameservers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Nameserver>>,
        ) -> Self {
            self.nameservers = input;
            self
        }
        /// <p>The authorization code for the domain. You get this value from the current registrar.</p>
        pub fn auth_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.auth_code = Some(input.into());
            self
        }
        /// <p>The authorization code for the domain. You get this value from the current registrar.</p>
        pub fn set_auth_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.auth_code = input;
            self
        }
        /// <p>Indicates whether the domain will be automatically renewed (true) or not (false). Autorenewal only takes effect after the account is charged.</p>
        /// <p>Default: true</p>
        pub fn auto_renew(mut self, input: bool) -> Self {
            self.auto_renew = Some(input);
            self
        }
        /// <p>Indicates whether the domain will be automatically renewed (true) or not (false). Autorenewal only takes effect after the account is charged.</p>
        /// <p>Default: true</p>
        pub fn set_auto_renew(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_renew = input;
            self
        }
        /// <p>Provides detailed contact information.</p>
        pub fn admin_contact(mut self, input: crate::model::ContactDetail) -> Self {
            self.admin_contact = Some(input);
            self
        }
        /// <p>Provides detailed contact information.</p>
        pub fn set_admin_contact(
            mut self,
            input: std::option::Option<crate::model::ContactDetail>,
        ) -> Self {
            self.admin_contact = input;
            self
        }
        /// <p>Provides detailed contact information.</p>
        pub fn registrant_contact(mut self, input: crate::model::ContactDetail) -> Self {
            self.registrant_contact = Some(input);
            self
        }
        /// <p>Provides detailed contact information.</p>
        pub fn set_registrant_contact(
            mut self,
            input: std::option::Option<crate::model::ContactDetail>,
        ) -> Self {
            self.registrant_contact = input;
            self
        }
        /// <p>Provides detailed contact information.</p>
        pub fn tech_contact(mut self, input: crate::model::ContactDetail) -> Self {
            self.tech_contact = Some(input);
            self
        }
        /// <p>Provides detailed contact information.</p>
        pub fn set_tech_contact(
            mut self,
            input: std::option::Option<crate::model::ContactDetail>,
        ) -> Self {
            self.tech_contact = input;
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the admin contact.</p> <note>
        /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
        /// </note>
        /// <p>Default: <code>true</code> </p>
        pub fn privacy_protect_admin_contact(mut self, input: bool) -> Self {
            self.privacy_protect_admin_contact = Some(input);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the admin contact.</p> <note>
        /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
        /// </note>
        /// <p>Default: <code>true</code> </p>
        pub fn set_privacy_protect_admin_contact(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.privacy_protect_admin_contact = input;
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the registrant contact (domain owner).</p> <note>
        /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
        /// </note>
        /// <p>Default: <code>true</code> </p>
        pub fn privacy_protect_registrant_contact(mut self, input: bool) -> Self {
            self.privacy_protect_registrant_contact = Some(input);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the registrant contact (domain owner).</p> <note>
        /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
        /// </note>
        /// <p>Default: <code>true</code> </p>
        pub fn set_privacy_protect_registrant_contact(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.privacy_protect_registrant_contact = input;
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the technical contact.</p> <note>
        /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
        /// </note>
        /// <p>Default: <code>true</code> </p>
        pub fn privacy_protect_tech_contact(mut self, input: bool) -> Self {
            self.privacy_protect_tech_contact = Some(input);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the technical contact.</p> <note>
        /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
        /// </note>
        /// <p>Default: <code>true</code> </p>
        pub fn set_privacy_protect_tech_contact(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.privacy_protect_tech_contact = input;
            self
        }
        /// Consumes the builder and constructs a [`TransferDomainInput`](crate::input::TransferDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TransferDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TransferDomainInput {
                domain_name: self.domain_name,
                idn_lang_code: self.idn_lang_code,
                duration_in_years: self.duration_in_years,
                nameservers: self.nameservers,
                auth_code: self.auth_code,
                auto_renew: self.auto_renew,
                admin_contact: self.admin_contact,
                registrant_contact: self.registrant_contact,
                tech_contact: self.tech_contact,
                privacy_protect_admin_contact: self.privacy_protect_admin_contact,
                privacy_protect_registrant_contact: self.privacy_protect_registrant_contact,
                privacy_protect_tech_contact: self.privacy_protect_tech_contact,
            })
        }
    }
}
#[doc(hidden)]
pub type TransferDomainInputOperationOutputAlias = crate::operation::TransferDomain;
#[doc(hidden)]
pub type TransferDomainInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TransferDomainInput {
    /// Consumes the builder and constructs an Operation<[`TransferDomain`](crate::operation::TransferDomain)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TransferDomain,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TransferDomainInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TransferDomainInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TransferDomainInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Domains_v20140515.TransferDomain",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_transfer_domain(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TransferDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TransferDomain",
            "route53domains",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TransferDomainInput`](crate::input::TransferDomainInput)
    pub fn builder() -> crate::input::transfer_domain_input::Builder {
        crate::input::transfer_domain_input::Builder::default()
    }
}

/// See [`TransferDomainToAnotherAwsAccountInput`](crate::input::TransferDomainToAnotherAwsAccountInput)
pub mod transfer_domain_to_another_aws_account_input {
    /// A builder for [`TransferDomainToAnotherAwsAccountInput`](crate::input::TransferDomainToAnotherAwsAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the domain that you want to transfer from the current Amazon Web Services account to another account.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the domain that you want to transfer from the current Amazon Web Services account to another account.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The account ID of the Amazon Web Services account that you want to transfer the domain to, for example, <code>111122223333</code>.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID of the Amazon Web Services account that you want to transfer the domain to, for example, <code>111122223333</code>.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`TransferDomainToAnotherAwsAccountInput`](crate::input::TransferDomainToAnotherAwsAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TransferDomainToAnotherAwsAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TransferDomainToAnotherAwsAccountInput {
                domain_name: self.domain_name,
                account_id: self.account_id,
            })
        }
    }
}
#[doc(hidden)]
pub type TransferDomainToAnotherAwsAccountInputOperationOutputAlias =
    crate::operation::TransferDomainToAnotherAwsAccount;
#[doc(hidden)]
pub type TransferDomainToAnotherAwsAccountInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl TransferDomainToAnotherAwsAccountInput {
    /// Consumes the builder and constructs an Operation<[`TransferDomainToAnotherAwsAccount`](crate::operation::TransferDomainToAnotherAwsAccount)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TransferDomainToAnotherAwsAccount,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TransferDomainToAnotherAwsAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TransferDomainToAnotherAwsAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TransferDomainToAnotherAwsAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Domains_v20140515.TransferDomainToAnotherAwsAccount",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_transfer_domain_to_another_aws_account(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TransferDomainToAnotherAwsAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TransferDomainToAnotherAwsAccount",
            "route53domains",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TransferDomainToAnotherAwsAccountInput`](crate::input::TransferDomainToAnotherAwsAccountInput)
    pub fn builder() -> crate::input::transfer_domain_to_another_aws_account_input::Builder {
        crate::input::transfer_domain_to_another_aws_account_input::Builder::default()
    }
}

/// See [`UpdateDomainContactInput`](crate::input::UpdateDomainContactInput)
pub mod update_domain_contact_input {
    /// A builder for [`UpdateDomainContactInput`](crate::input::UpdateDomainContactInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) admin_contact: std::option::Option<crate::model::ContactDetail>,
        pub(crate) registrant_contact: std::option::Option<crate::model::ContactDetail>,
        pub(crate) tech_contact: std::option::Option<crate::model::ContactDetail>,
    }
    impl Builder {
        /// <p>The name of the domain that you want to update contact information for.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the domain that you want to update contact information for.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>Provides detailed contact information.</p>
        pub fn admin_contact(mut self, input: crate::model::ContactDetail) -> Self {
            self.admin_contact = Some(input);
            self
        }
        /// <p>Provides detailed contact information.</p>
        pub fn set_admin_contact(
            mut self,
            input: std::option::Option<crate::model::ContactDetail>,
        ) -> Self {
            self.admin_contact = input;
            self
        }
        /// <p>Provides detailed contact information.</p>
        pub fn registrant_contact(mut self, input: crate::model::ContactDetail) -> Self {
            self.registrant_contact = Some(input);
            self
        }
        /// <p>Provides detailed contact information.</p>
        pub fn set_registrant_contact(
            mut self,
            input: std::option::Option<crate::model::ContactDetail>,
        ) -> Self {
            self.registrant_contact = input;
            self
        }
        /// <p>Provides detailed contact information.</p>
        pub fn tech_contact(mut self, input: crate::model::ContactDetail) -> Self {
            self.tech_contact = Some(input);
            self
        }
        /// <p>Provides detailed contact information.</p>
        pub fn set_tech_contact(
            mut self,
            input: std::option::Option<crate::model::ContactDetail>,
        ) -> Self {
            self.tech_contact = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDomainContactInput`](crate::input::UpdateDomainContactInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDomainContactInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDomainContactInput {
                domain_name: self.domain_name,
                admin_contact: self.admin_contact,
                registrant_contact: self.registrant_contact,
                tech_contact: self.tech_contact,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDomainContactInputOperationOutputAlias = crate::operation::UpdateDomainContact;
#[doc(hidden)]
pub type UpdateDomainContactInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateDomainContactInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDomainContact`](crate::operation::UpdateDomainContact)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDomainContact,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateDomainContactInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateDomainContactInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateDomainContactInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Domains_v20140515.UpdateDomainContact",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_domain_contact(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDomainContact::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDomainContact",
            "route53domains",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateDomainContactInput`](crate::input::UpdateDomainContactInput)
    pub fn builder() -> crate::input::update_domain_contact_input::Builder {
        crate::input::update_domain_contact_input::Builder::default()
    }
}

/// See [`UpdateDomainContactPrivacyInput`](crate::input::UpdateDomainContactPrivacyInput)
pub mod update_domain_contact_privacy_input {
    /// A builder for [`UpdateDomainContactPrivacyInput`](crate::input::UpdateDomainContactPrivacyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) admin_privacy: std::option::Option<bool>,
        pub(crate) registrant_privacy: std::option::Option<bool>,
        pub(crate) tech_privacy: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the domain that you want to update the privacy setting for.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the domain that you want to update the privacy setting for.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the admin contact.</p> <note>
        /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
        /// </note>
        pub fn admin_privacy(mut self, input: bool) -> Self {
            self.admin_privacy = Some(input);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the admin contact.</p> <note>
        /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
        /// </note>
        pub fn set_admin_privacy(mut self, input: std::option::Option<bool>) -> Self {
            self.admin_privacy = input;
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the registrant contact (domain owner).</p> <note>
        /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
        /// </note>
        pub fn registrant_privacy(mut self, input: bool) -> Self {
            self.registrant_privacy = Some(input);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the registrant contact (domain owner).</p> <note>
        /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
        /// </note>
        pub fn set_registrant_privacy(mut self, input: std::option::Option<bool>) -> Self {
            self.registrant_privacy = input;
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the technical contact.</p> <note>
        /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
        /// </note>
        pub fn tech_privacy(mut self, input: bool) -> Self {
            self.tech_privacy = Some(input);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the technical contact.</p> <note>
        /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
        /// </note>
        pub fn set_tech_privacy(mut self, input: std::option::Option<bool>) -> Self {
            self.tech_privacy = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDomainContactPrivacyInput`](crate::input::UpdateDomainContactPrivacyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDomainContactPrivacyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDomainContactPrivacyInput {
                domain_name: self.domain_name,
                admin_privacy: self.admin_privacy,
                registrant_privacy: self.registrant_privacy,
                tech_privacy: self.tech_privacy,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDomainContactPrivacyInputOperationOutputAlias =
    crate::operation::UpdateDomainContactPrivacy;
#[doc(hidden)]
pub type UpdateDomainContactPrivacyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateDomainContactPrivacyInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDomainContactPrivacy`](crate::operation::UpdateDomainContactPrivacy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDomainContactPrivacy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateDomainContactPrivacyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateDomainContactPrivacyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateDomainContactPrivacyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Domains_v20140515.UpdateDomainContactPrivacy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_domain_contact_privacy(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDomainContactPrivacy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDomainContactPrivacy",
            "route53domains",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateDomainContactPrivacyInput`](crate::input::UpdateDomainContactPrivacyInput)
    pub fn builder() -> crate::input::update_domain_contact_privacy_input::Builder {
        crate::input::update_domain_contact_privacy_input::Builder::default()
    }
}

/// See [`UpdateDomainNameserversInput`](crate::input::UpdateDomainNameserversInput)
pub mod update_domain_nameservers_input {
    /// A builder for [`UpdateDomainNameserversInput`](crate::input::UpdateDomainNameserversInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) fi_auth_key: std::option::Option<std::string::String>,
        pub(crate) nameservers: std::option::Option<std::vec::Vec<crate::model::Nameserver>>,
    }
    impl Builder {
        /// <p>The name of the domain that you want to change name servers for.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the domain that you want to change name servers for.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The authorization key for .fi domains</p>
        pub fn fi_auth_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.fi_auth_key = Some(input.into());
            self
        }
        /// <p>The authorization key for .fi domains</p>
        pub fn set_fi_auth_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fi_auth_key = input;
            self
        }
        /// Appends an item to `nameservers`.
        ///
        /// To override the contents of this collection use [`set_nameservers`](Self::set_nameservers).
        ///
        /// <p>A list of new name servers for the domain.</p>
        pub fn nameservers(mut self, input: crate::model::Nameserver) -> Self {
            let mut v = self.nameservers.unwrap_or_default();
            v.push(input);
            self.nameservers = Some(v);
            self
        }
        /// <p>A list of new name servers for the domain.</p>
        pub fn set_nameservers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Nameserver>>,
        ) -> Self {
            self.nameservers = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDomainNameserversInput`](crate::input::UpdateDomainNameserversInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDomainNameserversInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDomainNameserversInput {
                domain_name: self.domain_name,
                fi_auth_key: self.fi_auth_key,
                nameservers: self.nameservers,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDomainNameserversInputOperationOutputAlias =
    crate::operation::UpdateDomainNameservers;
#[doc(hidden)]
pub type UpdateDomainNameserversInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateDomainNameserversInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDomainNameservers`](crate::operation::UpdateDomainNameservers)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDomainNameservers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateDomainNameserversInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateDomainNameserversInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateDomainNameserversInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Domains_v20140515.UpdateDomainNameservers",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_domain_nameservers(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDomainNameservers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDomainNameservers",
            "route53domains",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateDomainNameserversInput`](crate::input::UpdateDomainNameserversInput)
    pub fn builder() -> crate::input::update_domain_nameservers_input::Builder {
        crate::input::update_domain_nameservers_input::Builder::default()
    }
}

/// See [`UpdateTagsForDomainInput`](crate::input::UpdateTagsForDomainInput)
pub mod update_tags_for_domain_input {
    /// A builder for [`UpdateTagsForDomainInput`](crate::input::UpdateTagsForDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) tags_to_update: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The domain for which you want to add or update tags.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain for which you want to add or update tags.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Appends an item to `tags_to_update`.
        ///
        /// To override the contents of this collection use [`set_tags_to_update`](Self::set_tags_to_update).
        ///
        /// <p>A list of the tag keys and values that you want to add or update. If you specify a key that already exists, the corresponding value will be replaced.</p>
        pub fn tags_to_update(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags_to_update.unwrap_or_default();
            v.push(input);
            self.tags_to_update = Some(v);
            self
        }
        /// <p>A list of the tag keys and values that you want to add or update. If you specify a key that already exists, the corresponding value will be replaced.</p>
        pub fn set_tags_to_update(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags_to_update = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTagsForDomainInput`](crate::input::UpdateTagsForDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateTagsForDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateTagsForDomainInput {
                domain_name: self.domain_name,
                tags_to_update: self.tags_to_update,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateTagsForDomainInputOperationOutputAlias = crate::operation::UpdateTagsForDomain;
#[doc(hidden)]
pub type UpdateTagsForDomainInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateTagsForDomainInput {
    /// Consumes the builder and constructs an Operation<[`UpdateTagsForDomain`](crate::operation::UpdateTagsForDomain)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateTagsForDomain,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateTagsForDomainInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateTagsForDomainInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateTagsForDomainInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Domains_v20140515.UpdateTagsForDomain",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_tags_for_domain(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateTagsForDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateTagsForDomain",
            "route53domains",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateTagsForDomainInput`](crate::input::UpdateTagsForDomainInput)
    pub fn builder() -> crate::input::update_tags_for_domain_input::Builder {
        crate::input::update_tags_for_domain_input::Builder::default()
    }
}

/// See [`ViewBillingInput`](crate::input::ViewBillingInput)
pub mod view_billing_input {
    /// A builder for [`ViewBillingInput`](crate::input::ViewBillingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The beginning date and time for the time period for which you want a list of billing records. Specify the date and time in Unix time format and Coordinated Universal time (UTC).</p>
        pub fn start(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start = Some(input);
            self
        }
        /// <p>The beginning date and time for the time period for which you want a list of billing records. Specify the date and time in Unix time format and Coordinated Universal time (UTC).</p>
        pub fn set_start(mut self, input: std::option::Option<aws_smithy_types::DateTime>) -> Self {
            self.start = input;
            self
        }
        /// <p>The end date and time for the time period for which you want a list of billing records. Specify the date and time in Unix time format and Coordinated Universal time (UTC).</p>
        pub fn end(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end = Some(input);
            self
        }
        /// <p>The end date and time for the time period for which you want a list of billing records. Specify the date and time in Unix time format and Coordinated Universal time (UTC).</p>
        pub fn set_end(mut self, input: std::option::Option<aws_smithy_types::DateTime>) -> Self {
            self.end = input;
            self
        }
        /// <p>For an initial request for a list of billing records, omit this element. If the number of billing records that are associated with the current Amazon Web Services account during the specified period is greater than the value that you specified for <code>MaxItems</code>, you can use <code>Marker</code> to return additional billing records. Get the value of <code>NextPageMarker</code> from the previous response, and submit another request that includes the value of <code>NextPageMarker</code> in the <code>Marker</code> element. </p>
        /// <p>Constraints: The marker must match the value of <code>NextPageMarker</code> that was returned in the previous response.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>For an initial request for a list of billing records, omit this element. If the number of billing records that are associated with the current Amazon Web Services account during the specified period is greater than the value that you specified for <code>MaxItems</code>, you can use <code>Marker</code> to return additional billing records. Get the value of <code>NextPageMarker</code> from the previous response, and submit another request that includes the value of <code>NextPageMarker</code> in the <code>Marker</code> element. </p>
        /// <p>Constraints: The marker must match the value of <code>NextPageMarker</code> that was returned in the previous response.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The number of billing records to be returned.</p>
        /// <p>Default: 20</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The number of billing records to be returned.</p>
        /// <p>Default: 20</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ViewBillingInput`](crate::input::ViewBillingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ViewBillingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ViewBillingInput {
                start: self.start,
                end: self.end,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ViewBillingInputOperationOutputAlias = crate::operation::ViewBilling;
#[doc(hidden)]
pub type ViewBillingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ViewBillingInput {
    /// Consumes the builder and constructs an Operation<[`ViewBilling`](crate::operation::ViewBilling)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ViewBilling,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ViewBillingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ViewBillingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ViewBillingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Route53Domains_v20140515.ViewBilling",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_view_billing(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ViewBilling::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ViewBilling",
            "route53domains",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ViewBillingInput`](crate::input::ViewBillingInput)
    pub fn builder() -> crate::input::view_billing_input::Builder {
        crate::input::view_billing_input::Builder::default()
    }
}

/// <p>The ViewBilling request includes the following elements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ViewBillingInput {
    /// <p>The beginning date and time for the time period for which you want a list of billing records. Specify the date and time in Unix time format and Coordinated Universal time (UTC).</p>
    pub start: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The end date and time for the time period for which you want a list of billing records. Specify the date and time in Unix time format and Coordinated Universal time (UTC).</p>
    pub end: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>For an initial request for a list of billing records, omit this element. If the number of billing records that are associated with the current Amazon Web Services account during the specified period is greater than the value that you specified for <code>MaxItems</code>, you can use <code>Marker</code> to return additional billing records. Get the value of <code>NextPageMarker</code> from the previous response, and submit another request that includes the value of <code>NextPageMarker</code> in the <code>Marker</code> element. </p>
    /// <p>Constraints: The marker must match the value of <code>NextPageMarker</code> that was returned in the previous response.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The number of billing records to be returned.</p>
    /// <p>Default: 20</p>
    pub max_items: std::option::Option<i32>,
}
impl ViewBillingInput {
    /// <p>The beginning date and time for the time period for which you want a list of billing records. Specify the date and time in Unix time format and Coordinated Universal time (UTC).</p>
    pub fn start(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start.as_ref()
    }
    /// <p>The end date and time for the time period for which you want a list of billing records. Specify the date and time in Unix time format and Coordinated Universal time (UTC).</p>
    pub fn end(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end.as_ref()
    }
    /// <p>For an initial request for a list of billing records, omit this element. If the number of billing records that are associated with the current Amazon Web Services account during the specified period is greater than the value that you specified for <code>MaxItems</code>, you can use <code>Marker</code> to return additional billing records. Get the value of <code>NextPageMarker</code> from the previous response, and submit another request that includes the value of <code>NextPageMarker</code> in the <code>Marker</code> element. </p>
    /// <p>Constraints: The marker must match the value of <code>NextPageMarker</code> that was returned in the previous response.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The number of billing records to be returned.</p>
    /// <p>Default: 20</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ViewBillingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ViewBillingInput");
        formatter.field("start", &self.start);
        formatter.field("end", &self.end);
        formatter.field("marker", &self.marker);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}

/// <p>The UpdateTagsForDomainRequest includes the following elements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTagsForDomainInput {
    /// <p>The domain for which you want to add or update tags.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>A list of the tag keys and values that you want to add or update. If you specify a key that already exists, the corresponding value will be replaced.</p>
    pub tags_to_update: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl UpdateTagsForDomainInput {
    /// <p>The domain for which you want to add or update tags.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>A list of the tag keys and values that you want to add or update. If you specify a key that already exists, the corresponding value will be replaced.</p>
    pub fn tags_to_update(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags_to_update.as_deref()
    }
}
impl std::fmt::Debug for UpdateTagsForDomainInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTagsForDomainInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("tags_to_update", &self.tags_to_update);
        formatter.finish()
    }
}

/// <p>Replaces the current set of name servers for the domain with the specified set of name servers. If you use Amazon Route 53 as your DNS service, specify the four name servers in the delegation set for the hosted zone for the domain.</p>
/// <p>If successful, this operation returns an operation ID that you can use to track the progress and completion of the action. If the request is not completed successfully, the domain registrant will be notified by email. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDomainNameserversInput {
    /// <p>The name of the domain that you want to change name servers for.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The authorization key for .fi domains</p>
    pub fi_auth_key: std::option::Option<std::string::String>,
    /// <p>A list of new name servers for the domain.</p>
    pub nameservers: std::option::Option<std::vec::Vec<crate::model::Nameserver>>,
}
impl UpdateDomainNameserversInput {
    /// <p>The name of the domain that you want to change name servers for.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The authorization key for .fi domains</p>
    pub fn fi_auth_key(&self) -> std::option::Option<&str> {
        self.fi_auth_key.as_deref()
    }
    /// <p>A list of new name servers for the domain.</p>
    pub fn nameservers(&self) -> std::option::Option<&[crate::model::Nameserver]> {
        self.nameservers.as_deref()
    }
}
impl std::fmt::Debug for UpdateDomainNameserversInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDomainNameserversInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("fi_auth_key", &"*** Sensitive Data Redacted ***");
        formatter.field("nameservers", &self.nameservers);
        formatter.finish()
    }
}

/// <p>The UpdateDomainContactPrivacy request includes the following elements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDomainContactPrivacyInput {
    /// <p>The name of the domain that you want to update the privacy setting for.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the admin contact.</p> <note>
    /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
    /// </note>
    pub admin_privacy: std::option::Option<bool>,
    /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the registrant contact (domain owner).</p> <note>
    /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
    /// </note>
    pub registrant_privacy: std::option::Option<bool>,
    /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the technical contact.</p> <note>
    /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
    /// </note>
    pub tech_privacy: std::option::Option<bool>,
}
impl UpdateDomainContactPrivacyInput {
    /// <p>The name of the domain that you want to update the privacy setting for.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the admin contact.</p> <note>
    /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
    /// </note>
    pub fn admin_privacy(&self) -> std::option::Option<bool> {
        self.admin_privacy
    }
    /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the registrant contact (domain owner).</p> <note>
    /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
    /// </note>
    pub fn registrant_privacy(&self) -> std::option::Option<bool> {
        self.registrant_privacy
    }
    /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the technical contact.</p> <note>
    /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
    /// </note>
    pub fn tech_privacy(&self) -> std::option::Option<bool> {
        self.tech_privacy
    }
}
impl std::fmt::Debug for UpdateDomainContactPrivacyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDomainContactPrivacyInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("admin_privacy", &self.admin_privacy);
        formatter.field("registrant_privacy", &self.registrant_privacy);
        formatter.field("tech_privacy", &self.tech_privacy);
        formatter.finish()
    }
}

/// <p>The UpdateDomainContact request includes the following elements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDomainContactInput {
    /// <p>The name of the domain that you want to update contact information for.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>Provides detailed contact information.</p>
    pub admin_contact: std::option::Option<crate::model::ContactDetail>,
    /// <p>Provides detailed contact information.</p>
    pub registrant_contact: std::option::Option<crate::model::ContactDetail>,
    /// <p>Provides detailed contact information.</p>
    pub tech_contact: std::option::Option<crate::model::ContactDetail>,
}
impl UpdateDomainContactInput {
    /// <p>The name of the domain that you want to update contact information for.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>Provides detailed contact information.</p>
    pub fn admin_contact(&self) -> std::option::Option<&crate::model::ContactDetail> {
        self.admin_contact.as_ref()
    }
    /// <p>Provides detailed contact information.</p>
    pub fn registrant_contact(&self) -> std::option::Option<&crate::model::ContactDetail> {
        self.registrant_contact.as_ref()
    }
    /// <p>Provides detailed contact information.</p>
    pub fn tech_contact(&self) -> std::option::Option<&crate::model::ContactDetail> {
        self.tech_contact.as_ref()
    }
}
impl std::fmt::Debug for UpdateDomainContactInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDomainContactInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("admin_contact", &"*** Sensitive Data Redacted ***");
        formatter.field("registrant_contact", &"*** Sensitive Data Redacted ***");
        formatter.field("tech_contact", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

/// <p>The TransferDomainToAnotherAwsAccount request includes the following elements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TransferDomainToAnotherAwsAccountInput {
    /// <p>The name of the domain that you want to transfer from the current Amazon Web Services account to another account.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The account ID of the Amazon Web Services account that you want to transfer the domain to, for example, <code>111122223333</code>.</p>
    pub account_id: std::option::Option<std::string::String>,
}
impl TransferDomainToAnotherAwsAccountInput {
    /// <p>The name of the domain that you want to transfer from the current Amazon Web Services account to another account.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The account ID of the Amazon Web Services account that you want to transfer the domain to, for example, <code>111122223333</code>.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
}
impl std::fmt::Debug for TransferDomainToAnotherAwsAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TransferDomainToAnotherAwsAccountInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("account_id", &self.account_id);
        formatter.finish()
    }
}

/// <p>The TransferDomain request includes the following elements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TransferDomainInput {
    /// <p>The name of the domain that you want to transfer to Route 53. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
    /// <p>The domain name can contain only the following characters:</p>
    /// <ul>
    /// <li> <p>Letters a through z. Domain names are not case sensitive.</p> </li>
    /// <li> <p>Numbers 0 through 9.</p> </li>
    /// <li> <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p> </li>
    /// <li> <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p> </li>
    /// </ul>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>Reserved for future use.</p>
    pub idn_lang_code: std::option::Option<std::string::String>,
    /// <p>The number of years that you want to register the domain for. Domains are registered for a minimum of one year. The maximum period depends on the top-level domain.</p>
    /// <p>Default: 1</p>
    pub duration_in_years: std::option::Option<i32>,
    /// <p>Contains details for the host and glue IP addresses.</p>
    pub nameservers: std::option::Option<std::vec::Vec<crate::model::Nameserver>>,
    /// <p>The authorization code for the domain. You get this value from the current registrar.</p>
    pub auth_code: std::option::Option<std::string::String>,
    /// <p>Indicates whether the domain will be automatically renewed (true) or not (false). Autorenewal only takes effect after the account is charged.</p>
    /// <p>Default: true</p>
    pub auto_renew: std::option::Option<bool>,
    /// <p>Provides detailed contact information.</p>
    pub admin_contact: std::option::Option<crate::model::ContactDetail>,
    /// <p>Provides detailed contact information.</p>
    pub registrant_contact: std::option::Option<crate::model::ContactDetail>,
    /// <p>Provides detailed contact information.</p>
    pub tech_contact: std::option::Option<crate::model::ContactDetail>,
    /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the admin contact.</p> <note>
    /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
    /// </note>
    /// <p>Default: <code>true</code> </p>
    pub privacy_protect_admin_contact: std::option::Option<bool>,
    /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the registrant contact (domain owner).</p> <note>
    /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
    /// </note>
    /// <p>Default: <code>true</code> </p>
    pub privacy_protect_registrant_contact: std::option::Option<bool>,
    /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the technical contact.</p> <note>
    /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
    /// </note>
    /// <p>Default: <code>true</code> </p>
    pub privacy_protect_tech_contact: std::option::Option<bool>,
}
impl TransferDomainInput {
    /// <p>The name of the domain that you want to transfer to Route 53. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
    /// <p>The domain name can contain only the following characters:</p>
    /// <ul>
    /// <li> <p>Letters a through z. Domain names are not case sensitive.</p> </li>
    /// <li> <p>Numbers 0 through 9.</p> </li>
    /// <li> <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p> </li>
    /// <li> <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p> </li>
    /// </ul>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>Reserved for future use.</p>
    pub fn idn_lang_code(&self) -> std::option::Option<&str> {
        self.idn_lang_code.as_deref()
    }
    /// <p>The number of years that you want to register the domain for. Domains are registered for a minimum of one year. The maximum period depends on the top-level domain.</p>
    /// <p>Default: 1</p>
    pub fn duration_in_years(&self) -> std::option::Option<i32> {
        self.duration_in_years
    }
    /// <p>Contains details for the host and glue IP addresses.</p>
    pub fn nameservers(&self) -> std::option::Option<&[crate::model::Nameserver]> {
        self.nameservers.as_deref()
    }
    /// <p>The authorization code for the domain. You get this value from the current registrar.</p>
    pub fn auth_code(&self) -> std::option::Option<&str> {
        self.auth_code.as_deref()
    }
    /// <p>Indicates whether the domain will be automatically renewed (true) or not (false). Autorenewal only takes effect after the account is charged.</p>
    /// <p>Default: true</p>
    pub fn auto_renew(&self) -> std::option::Option<bool> {
        self.auto_renew
    }
    /// <p>Provides detailed contact information.</p>
    pub fn admin_contact(&self) -> std::option::Option<&crate::model::ContactDetail> {
        self.admin_contact.as_ref()
    }
    /// <p>Provides detailed contact information.</p>
    pub fn registrant_contact(&self) -> std::option::Option<&crate::model::ContactDetail> {
        self.registrant_contact.as_ref()
    }
    /// <p>Provides detailed contact information.</p>
    pub fn tech_contact(&self) -> std::option::Option<&crate::model::ContactDetail> {
        self.tech_contact.as_ref()
    }
    /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the admin contact.</p> <note>
    /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
    /// </note>
    /// <p>Default: <code>true</code> </p>
    pub fn privacy_protect_admin_contact(&self) -> std::option::Option<bool> {
        self.privacy_protect_admin_contact
    }
    /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the registrant contact (domain owner).</p> <note>
    /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
    /// </note>
    /// <p>Default: <code>true</code> </p>
    pub fn privacy_protect_registrant_contact(&self) -> std::option::Option<bool> {
        self.privacy_protect_registrant_contact
    }
    /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the technical contact.</p> <note>
    /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
    /// </note>
    /// <p>Default: <code>true</code> </p>
    pub fn privacy_protect_tech_contact(&self) -> std::option::Option<bool> {
        self.privacy_protect_tech_contact
    }
}
impl std::fmt::Debug for TransferDomainInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TransferDomainInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("idn_lang_code", &self.idn_lang_code);
        formatter.field("duration_in_years", &self.duration_in_years);
        formatter.field("nameservers", &self.nameservers);
        formatter.field("auth_code", &"*** Sensitive Data Redacted ***");
        formatter.field("auto_renew", &self.auto_renew);
        formatter.field("admin_contact", &"*** Sensitive Data Redacted ***");
        formatter.field("registrant_contact", &"*** Sensitive Data Redacted ***");
        formatter.field("tech_contact", &"*** Sensitive Data Redacted ***");
        formatter.field(
            "privacy_protect_admin_contact",
            &self.privacy_protect_admin_contact,
        );
        formatter.field(
            "privacy_protect_registrant_contact",
            &self.privacy_protect_registrant_contact,
        );
        formatter.field(
            "privacy_protect_tech_contact",
            &self.privacy_protect_tech_contact,
        );
        formatter.finish()
    }
}

/// <p>A request for the authorization code for the specified domain. To transfer a domain to another registrar, you provide this value to the new registrar.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RetrieveDomainAuthCodeInput {
    /// <p>The name of the domain that you want to get an authorization code for.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl RetrieveDomainAuthCodeInput {
    /// <p>The name of the domain that you want to get an authorization code for.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for RetrieveDomainAuthCodeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RetrieveDomainAuthCodeInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResendContactReachabilityEmailInput {
    /// <p>The name of the domain for which you want Route 53 to resend a confirmation email to the registrant contact.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl ResendContactReachabilityEmailInput {
    /// <p>The name of the domain for which you want Route 53 to resend a confirmation email to the registrant contact.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for ResendContactReachabilityEmailInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResendContactReachabilityEmailInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

/// <p>A <code>RenewDomain</code> request includes the number of years that you want to renew for and the current expiration year.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RenewDomainInput {
    /// <p>The name of the domain that you want to renew.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The number of years that you want to renew the domain for. The maximum number of years depends on the top-level domain. For the range of valid values for your domain, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
    /// <p>Default: 1</p>
    pub duration_in_years: std::option::Option<i32>,
    /// <p>The year when the registration for the domain is set to expire. This value must match the current expiration date for the domain.</p>
    pub current_expiry_year: i32,
}
impl RenewDomainInput {
    /// <p>The name of the domain that you want to renew.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The number of years that you want to renew the domain for. The maximum number of years depends on the top-level domain. For the range of valid values for your domain, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
    /// <p>Default: 1</p>
    pub fn duration_in_years(&self) -> std::option::Option<i32> {
        self.duration_in_years
    }
    /// <p>The year when the registration for the domain is set to expire. This value must match the current expiration date for the domain.</p>
    pub fn current_expiry_year(&self) -> i32 {
        self.current_expiry_year
    }
}
impl std::fmt::Debug for RenewDomainInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RenewDomainInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("duration_in_years", &self.duration_in_years);
        formatter.field("current_expiry_year", &self.current_expiry_year);
        formatter.finish()
    }
}

/// <p>The RejectDomainTransferFromAnotherAwsAccount request includes the following element.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RejectDomainTransferFromAnotherAwsAccountInput {
    /// <p>The name of the domain that was specified when another Amazon Web Services account submitted a <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html">TransferDomainToAnotherAwsAccount</a> request. </p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl RejectDomainTransferFromAnotherAwsAccountInput {
    /// <p>The name of the domain that was specified when another Amazon Web Services account submitted a <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html">TransferDomainToAnotherAwsAccount</a> request. </p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for RejectDomainTransferFromAnotherAwsAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RejectDomainTransferFromAnotherAwsAccountInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

/// <p>The RegisterDomain request includes the following elements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterDomainInput {
    /// <p>The domain name that you want to register. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
    /// <p>The domain name can contain only the following characters:</p>
    /// <ul>
    /// <li> <p>Letters a through z. Domain names are not case sensitive.</p> </li>
    /// <li> <p>Numbers 0 through 9.</p> </li>
    /// <li> <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p> </li>
    /// <li> <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p> </li>
    /// </ul>
    /// <p>Internationalized domain names are not supported for some top-level domains. To determine whether the TLD that you want to use supports internationalized domain names, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a>. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html#domain-name-format-idns">Formatting Internationalized Domain Names</a>. </p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>Reserved for future use.</p>
    pub idn_lang_code: std::option::Option<std::string::String>,
    /// <p>The number of years that you want to register the domain for. Domains are registered for a minimum of one year. The maximum period depends on the top-level domain. For the range of valid values for your domain, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
    /// <p>Default: 1</p>
    pub duration_in_years: std::option::Option<i32>,
    /// <p>Indicates whether the domain will be automatically renewed (<code>true</code>) or not (<code>false</code>). Autorenewal only takes effect after the account is charged.</p>
    /// <p>Default: <code>true</code> </p>
    pub auto_renew: std::option::Option<bool>,
    /// <p>Provides detailed contact information. For information about the values that you specify for each element, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html">ContactDetail</a>.</p>
    pub admin_contact: std::option::Option<crate::model::ContactDetail>,
    /// <p>Provides detailed contact information. For information about the values that you specify for each element, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html">ContactDetail</a>.</p>
    pub registrant_contact: std::option::Option<crate::model::ContactDetail>,
    /// <p>Provides detailed contact information. For information about the values that you specify for each element, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html">ContactDetail</a>.</p>
    pub tech_contact: std::option::Option<crate::model::ContactDetail>,
    /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the admin contact.</p> <note>
    /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
    /// </note>
    /// <p>Default: <code>true</code> </p>
    pub privacy_protect_admin_contact: std::option::Option<bool>,
    /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the registrant contact (the domain owner).</p> <note>
    /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
    /// </note>
    /// <p>Default: <code>true</code> </p>
    pub privacy_protect_registrant_contact: std::option::Option<bool>,
    /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the technical contact.</p> <note>
    /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
    /// </note>
    /// <p>Default: <code>true</code> </p>
    pub privacy_protect_tech_contact: std::option::Option<bool>,
}
impl RegisterDomainInput {
    /// <p>The domain name that you want to register. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
    /// <p>The domain name can contain only the following characters:</p>
    /// <ul>
    /// <li> <p>Letters a through z. Domain names are not case sensitive.</p> </li>
    /// <li> <p>Numbers 0 through 9.</p> </li>
    /// <li> <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p> </li>
    /// <li> <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p> </li>
    /// </ul>
    /// <p>Internationalized domain names are not supported for some top-level domains. To determine whether the TLD that you want to use supports internationalized domain names, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a>. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html#domain-name-format-idns">Formatting Internationalized Domain Names</a>. </p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>Reserved for future use.</p>
    pub fn idn_lang_code(&self) -> std::option::Option<&str> {
        self.idn_lang_code.as_deref()
    }
    /// <p>The number of years that you want to register the domain for. Domains are registered for a minimum of one year. The maximum period depends on the top-level domain. For the range of valid values for your domain, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
    /// <p>Default: 1</p>
    pub fn duration_in_years(&self) -> std::option::Option<i32> {
        self.duration_in_years
    }
    /// <p>Indicates whether the domain will be automatically renewed (<code>true</code>) or not (<code>false</code>). Autorenewal only takes effect after the account is charged.</p>
    /// <p>Default: <code>true</code> </p>
    pub fn auto_renew(&self) -> std::option::Option<bool> {
        self.auto_renew
    }
    /// <p>Provides detailed contact information. For information about the values that you specify for each element, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html">ContactDetail</a>.</p>
    pub fn admin_contact(&self) -> std::option::Option<&crate::model::ContactDetail> {
        self.admin_contact.as_ref()
    }
    /// <p>Provides detailed contact information. For information about the values that you specify for each element, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html">ContactDetail</a>.</p>
    pub fn registrant_contact(&self) -> std::option::Option<&crate::model::ContactDetail> {
        self.registrant_contact.as_ref()
    }
    /// <p>Provides detailed contact information. For information about the values that you specify for each element, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html">ContactDetail</a>.</p>
    pub fn tech_contact(&self) -> std::option::Option<&crate::model::ContactDetail> {
        self.tech_contact.as_ref()
    }
    /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the admin contact.</p> <note>
    /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
    /// </note>
    /// <p>Default: <code>true</code> </p>
    pub fn privacy_protect_admin_contact(&self) -> std::option::Option<bool> {
        self.privacy_protect_admin_contact
    }
    /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the registrant contact (the domain owner).</p> <note>
    /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
    /// </note>
    /// <p>Default: <code>true</code> </p>
    pub fn privacy_protect_registrant_contact(&self) -> std::option::Option<bool> {
        self.privacy_protect_registrant_contact
    }
    /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the technical contact.</p> <note>
    /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
    /// </note>
    /// <p>Default: <code>true</code> </p>
    pub fn privacy_protect_tech_contact(&self) -> std::option::Option<bool> {
        self.privacy_protect_tech_contact
    }
}
impl std::fmt::Debug for RegisterDomainInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterDomainInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("idn_lang_code", &self.idn_lang_code);
        formatter.field("duration_in_years", &self.duration_in_years);
        formatter.field("auto_renew", &self.auto_renew);
        formatter.field("admin_contact", &"*** Sensitive Data Redacted ***");
        formatter.field("registrant_contact", &"*** Sensitive Data Redacted ***");
        formatter.field("tech_contact", &"*** Sensitive Data Redacted ***");
        formatter.field(
            "privacy_protect_admin_contact",
            &self.privacy_protect_admin_contact,
        );
        formatter.field(
            "privacy_protect_registrant_contact",
            &self.privacy_protect_registrant_contact,
        );
        formatter.field(
            "privacy_protect_tech_contact",
            &self.privacy_protect_tech_contact,
        );
        formatter.finish()
    }
}

/// <p>The ListTagsForDomainRequest includes the following elements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForDomainInput {
    /// <p>The domain for which you want to get a list of tags.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl ListTagsForDomainInput {
    /// <p>The domain for which you want to get a list of tags.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForDomainInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForDomainInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPricesInput {
    /// <p>The TLD for which you want to receive the pricing information. For example. <code>.net</code>.</p>
    /// <p>If a <code>Tld</code> value is not provided, a list of prices for all TLDs supported by Route&nbsp;53 is returned.</p>
    pub tld: std::option::Option<std::string::String>,
    /// <p>For an initial request for a list of prices, omit this element. If the number of prices that are not yet complete is greater than the value that you specified for <code>MaxItems</code>, you can use <code>Marker</code> to return additional prices. Get the value of <code>NextPageMarker</code> from the previous response, and submit another request that includes the value of <code>NextPageMarker</code> in the <code>Marker</code> element. </p>
    /// <p>Used only for all TLDs. If you specify a TLD, don't specify a <code>Marker</code>.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>Number of <code>Prices</code> to be returned.</p>
    /// <p>Used only for all TLDs. If you specify a TLD, don't specify a <code>MaxItems</code>.</p>
    pub max_items: std::option::Option<i32>,
}
impl ListPricesInput {
    /// <p>The TLD for which you want to receive the pricing information. For example. <code>.net</code>.</p>
    /// <p>If a <code>Tld</code> value is not provided, a list of prices for all TLDs supported by Route&nbsp;53 is returned.</p>
    pub fn tld(&self) -> std::option::Option<&str> {
        self.tld.as_deref()
    }
    /// <p>For an initial request for a list of prices, omit this element. If the number of prices that are not yet complete is greater than the value that you specified for <code>MaxItems</code>, you can use <code>Marker</code> to return additional prices. Get the value of <code>NextPageMarker</code> from the previous response, and submit another request that includes the value of <code>NextPageMarker</code> in the <code>Marker</code> element. </p>
    /// <p>Used only for all TLDs. If you specify a TLD, don't specify a <code>Marker</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>Number of <code>Prices</code> to be returned.</p>
    /// <p>Used only for all TLDs. If you specify a TLD, don't specify a <code>MaxItems</code>.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListPricesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPricesInput");
        formatter.field("tld", &self.tld);
        formatter.field("marker", &self.marker);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}

/// <p>The ListOperations request includes the following elements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOperationsInput {
    /// <p>An optional parameter that lets you get information about all the operations that you submitted after a specified date and time. Specify the date and time in Unix time format and Coordinated Universal time (UTC).</p>
    pub submitted_since: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>For an initial request for a list of operations, omit this element. If the number of operations that are not yet complete is greater than the value that you specified for <code>MaxItems</code>, you can use <code>Marker</code> to return additional operations. Get the value of <code>NextPageMarker</code> from the previous response, and submit another request that includes the value of <code>NextPageMarker</code> in the <code>Marker</code> element.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>Number of domains to be returned.</p>
    /// <p>Default: 20</p>
    pub max_items: std::option::Option<i32>,
}
impl ListOperationsInput {
    /// <p>An optional parameter that lets you get information about all the operations that you submitted after a specified date and time. Specify the date and time in Unix time format and Coordinated Universal time (UTC).</p>
    pub fn submitted_since(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.submitted_since.as_ref()
    }
    /// <p>For an initial request for a list of operations, omit this element. If the number of operations that are not yet complete is greater than the value that you specified for <code>MaxItems</code>, you can use <code>Marker</code> to return additional operations. Get the value of <code>NextPageMarker</code> from the previous response, and submit another request that includes the value of <code>NextPageMarker</code> in the <code>Marker</code> element.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>Number of domains to be returned.</p>
    /// <p>Default: 20</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListOperationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOperationsInput");
        formatter.field("submitted_since", &self.submitted_since);
        formatter.field("marker", &self.marker);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}

/// <p>The ListDomains request includes the following elements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDomainsInput {
    /// <p>A complex type that contains information about the filters applied during the <code>ListDomains</code> request. The filter conditions can include domain name and domain expiration.</p>
    pub filter_conditions: std::option::Option<std::vec::Vec<crate::model::FilterCondition>>,
    /// <p>A complex type that contains information about the requested ordering of domains in the returned list.</p>
    pub sort_condition: std::option::Option<crate::model::SortCondition>,
    /// <p>For an initial request for a list of domains, omit this element. If the number of domains that are associated with the current Amazon Web Services account is greater than the value that you specified for <code>MaxItems</code>, you can use <code>Marker</code> to return additional domains. Get the value of <code>NextPageMarker</code> from the previous response, and submit another request that includes the value of <code>NextPageMarker</code> in the <code>Marker</code> element.</p>
    /// <p>Constraints: The marker must match the value specified in the previous request.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>Number of domains to be returned.</p>
    /// <p>Default: 20</p>
    pub max_items: std::option::Option<i32>,
}
impl ListDomainsInput {
    /// <p>A complex type that contains information about the filters applied during the <code>ListDomains</code> request. The filter conditions can include domain name and domain expiration.</p>
    pub fn filter_conditions(&self) -> std::option::Option<&[crate::model::FilterCondition]> {
        self.filter_conditions.as_deref()
    }
    /// <p>A complex type that contains information about the requested ordering of domains in the returned list.</p>
    pub fn sort_condition(&self) -> std::option::Option<&crate::model::SortCondition> {
        self.sort_condition.as_ref()
    }
    /// <p>For an initial request for a list of domains, omit this element. If the number of domains that are associated with the current Amazon Web Services account is greater than the value that you specified for <code>MaxItems</code>, you can use <code>Marker</code> to return additional domains. Get the value of <code>NextPageMarker</code> from the previous response, and submit another request that includes the value of <code>NextPageMarker</code> in the <code>Marker</code> element.</p>
    /// <p>Constraints: The marker must match the value specified in the previous request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>Number of domains to be returned.</p>
    /// <p>Default: 20</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListDomainsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDomainsInput");
        formatter.field("filter_conditions", &self.filter_conditions);
        formatter.field("sort_condition", &self.sort_condition);
        formatter.field("marker", &self.marker);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}

/// <p>The <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a> request includes the following element.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetOperationDetailInput {
    /// <p>The identifier for the operation for which you want to get the status. Route 53 returned the identifier in the response to the original request.</p>
    pub operation_id: std::option::Option<std::string::String>,
}
impl GetOperationDetailInput {
    /// <p>The identifier for the operation for which you want to get the status. Route 53 returned the identifier in the response to the original request.</p>
    pub fn operation_id(&self) -> std::option::Option<&str> {
        self.operation_id.as_deref()
    }
}
impl std::fmt::Debug for GetOperationDetailInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetOperationDetailInput");
        formatter.field("operation_id", &self.operation_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDomainSuggestionsInput {
    /// <p>A domain name that you want to use as the basis for a list of possible domain names. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
    /// <p>The domain name can contain only the following characters:</p>
    /// <ul>
    /// <li> <p>Letters a through z. Domain names are not case sensitive.</p> </li>
    /// <li> <p>Numbers 0 through 9.</p> </li>
    /// <li> <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p> </li>
    /// <li> <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p> </li>
    /// </ul>
    /// <p>Internationalized domain names are not supported for some top-level domains. To determine whether the TLD that you want to use supports internationalized domain names, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a>. </p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The number of suggested domain names that you want Route 53 to return. Specify a value between 1 and 50.</p>
    pub suggestion_count: i32,
    /// <p>If <code>OnlyAvailable</code> is <code>true</code>, Route 53 returns only domain names that are available. If <code>OnlyAvailable</code> is <code>false</code>, Route 53 returns domain names without checking whether they're available to be registered. To determine whether the domain is available, you can call <code>checkDomainAvailability</code> for each suggestion.</p>
    pub only_available: std::option::Option<bool>,
}
impl GetDomainSuggestionsInput {
    /// <p>A domain name that you want to use as the basis for a list of possible domain names. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
    /// <p>The domain name can contain only the following characters:</p>
    /// <ul>
    /// <li> <p>Letters a through z. Domain names are not case sensitive.</p> </li>
    /// <li> <p>Numbers 0 through 9.</p> </li>
    /// <li> <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p> </li>
    /// <li> <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p> </li>
    /// </ul>
    /// <p>Internationalized domain names are not supported for some top-level domains. To determine whether the TLD that you want to use supports internationalized domain names, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a>. </p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The number of suggested domain names that you want Route 53 to return. Specify a value between 1 and 50.</p>
    pub fn suggestion_count(&self) -> i32 {
        self.suggestion_count
    }
    /// <p>If <code>OnlyAvailable</code> is <code>true</code>, Route 53 returns only domain names that are available. If <code>OnlyAvailable</code> is <code>false</code>, Route 53 returns domain names without checking whether they're available to be registered. To determine whether the domain is available, you can call <code>checkDomainAvailability</code> for each suggestion.</p>
    pub fn only_available(&self) -> std::option::Option<bool> {
        self.only_available
    }
}
impl std::fmt::Debug for GetDomainSuggestionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDomainSuggestionsInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("suggestion_count", &self.suggestion_count);
        formatter.field("only_available", &self.only_available);
        formatter.finish()
    }
}

/// <p>The GetDomainDetail request includes the following element.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDomainDetailInput {
    /// <p>The name of the domain that you want to get detailed information about.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl GetDomainDetailInput {
    /// <p>The name of the domain that you want to get detailed information about.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for GetDomainDetailInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDomainDetailInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetContactReachabilityStatusInput {
    /// <p>The name of the domain for which you want to know whether the registrant contact has confirmed that the email address is valid.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl GetContactReachabilityStatusInput {
    /// <p>The name of the domain for which you want to know whether the registrant contact has confirmed that the email address is valid.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for GetContactReachabilityStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetContactReachabilityStatusInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

/// <p>A request to set the transfer lock for the specified domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableDomainTransferLockInput {
    /// <p>The name of the domain that you want to set the transfer lock for.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl EnableDomainTransferLockInput {
    /// <p>The name of the domain that you want to set the transfer lock for.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for EnableDomainTransferLockInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableDomainTransferLockInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableDomainAutoRenewInput {
    /// <p>The name of the domain that you want to enable automatic renewal for.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl EnableDomainAutoRenewInput {
    /// <p>The name of the domain that you want to enable automatic renewal for.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for EnableDomainAutoRenewInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableDomainAutoRenewInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

/// <p>The DisableDomainTransferLock request includes the following element.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableDomainTransferLockInput {
    /// <p>The name of the domain that you want to remove the transfer lock for.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl DisableDomainTransferLockInput {
    /// <p>The name of the domain that you want to remove the transfer lock for.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for DisableDomainTransferLockInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableDomainTransferLockInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableDomainAutoRenewInput {
    /// <p>The name of the domain that you want to disable automatic renewal for.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl DisableDomainAutoRenewInput {
    /// <p>The name of the domain that you want to disable automatic renewal for.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for DisableDomainAutoRenewInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableDomainAutoRenewInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

/// <p>The DeleteTagsForDomainRequest includes the following elements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTagsForDomainInput {
    /// <p>The domain for which you want to delete one or more tags.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>A list of tag keys to delete.</p>
    pub tags_to_delete: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DeleteTagsForDomainInput {
    /// <p>The domain for which you want to delete one or more tags.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>A list of tag keys to delete.</p>
    pub fn tags_to_delete(&self) -> std::option::Option<&[std::string::String]> {
        self.tags_to_delete.as_deref()
    }
}
impl std::fmt::Debug for DeleteTagsForDomainInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTagsForDomainInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("tags_to_delete", &self.tags_to_delete);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDomainInput {
    /// <p>Name of the domain to be deleted.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl DeleteDomainInput {
    /// <p>Name of the domain to be deleted.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteDomainInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDomainInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

/// <p>The CheckDomainTransferability request contains the following elements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CheckDomainTransferabilityInput {
    /// <p>The name of the domain that you want to transfer to Route 53. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
    /// <p>The domain name can contain only the following characters:</p>
    /// <ul>
    /// <li> <p>Letters a through z. Domain names are not case sensitive.</p> </li>
    /// <li> <p>Numbers 0 through 9.</p> </li>
    /// <li> <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p> </li>
    /// <li> <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p> </li>
    /// </ul>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>If the registrar for the top-level domain (TLD) requires an authorization code to transfer the domain, the code that you got from the current registrar for the domain.</p>
    pub auth_code: std::option::Option<std::string::String>,
}
impl CheckDomainTransferabilityInput {
    /// <p>The name of the domain that you want to transfer to Route 53. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
    /// <p>The domain name can contain only the following characters:</p>
    /// <ul>
    /// <li> <p>Letters a through z. Domain names are not case sensitive.</p> </li>
    /// <li> <p>Numbers 0 through 9.</p> </li>
    /// <li> <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p> </li>
    /// <li> <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p> </li>
    /// </ul>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>If the registrar for the top-level domain (TLD) requires an authorization code to transfer the domain, the code that you got from the current registrar for the domain.</p>
    pub fn auth_code(&self) -> std::option::Option<&str> {
        self.auth_code.as_deref()
    }
}
impl std::fmt::Debug for CheckDomainTransferabilityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CheckDomainTransferabilityInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("auth_code", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

/// <p>The CheckDomainAvailability request contains the following elements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CheckDomainAvailabilityInput {
    /// <p>The name of the domain that you want to get availability for. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
    /// <p>The domain name can contain only the following characters:</p>
    /// <ul>
    /// <li> <p>Letters a through z. Domain names are not case sensitive.</p> </li>
    /// <li> <p>Numbers 0 through 9.</p> </li>
    /// <li> <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p> </li>
    /// <li> <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p> </li>
    /// </ul>
    /// <p>Internationalized domain names are not supported for some top-level domains. To determine whether the TLD that you want to use supports internationalized domain names, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a>. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html#domain-name-format-idns">Formatting Internationalized Domain Names</a>. </p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>Reserved for future use.</p>
    pub idn_lang_code: std::option::Option<std::string::String>,
}
impl CheckDomainAvailabilityInput {
    /// <p>The name of the domain that you want to get availability for. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
    /// <p>The domain name can contain only the following characters:</p>
    /// <ul>
    /// <li> <p>Letters a through z. Domain names are not case sensitive.</p> </li>
    /// <li> <p>Numbers 0 through 9.</p> </li>
    /// <li> <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p> </li>
    /// <li> <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p> </li>
    /// </ul>
    /// <p>Internationalized domain names are not supported for some top-level domains. To determine whether the TLD that you want to use supports internationalized domain names, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a>. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html#domain-name-format-idns">Formatting Internationalized Domain Names</a>. </p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>Reserved for future use.</p>
    pub fn idn_lang_code(&self) -> std::option::Option<&str> {
        self.idn_lang_code.as_deref()
    }
}
impl std::fmt::Debug for CheckDomainAvailabilityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CheckDomainAvailabilityInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("idn_lang_code", &self.idn_lang_code);
        formatter.finish()
    }
}

/// <p>The CancelDomainTransferToAnotherAwsAccount request includes the following element.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelDomainTransferToAnotherAwsAccountInput {
    /// <p>The name of the domain for which you want to cancel the transfer to another Amazon Web Services account.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl CancelDomainTransferToAnotherAwsAccountInput {
    /// <p>The name of the domain for which you want to cancel the transfer to another Amazon Web Services account.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for CancelDomainTransferToAnotherAwsAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelDomainTransferToAnotherAwsAccountInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

/// <p>The AcceptDomainTransferFromAnotherAwsAccount request includes the following elements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcceptDomainTransferFromAnotherAwsAccountInput {
    /// <p>The name of the domain that was specified when another Amazon Web Services account submitted a <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html">TransferDomainToAnotherAwsAccount</a> request. </p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The password that was returned by the <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html">TransferDomainToAnotherAwsAccount</a> request. </p>
    pub password: std::option::Option<std::string::String>,
}
impl AcceptDomainTransferFromAnotherAwsAccountInput {
    /// <p>The name of the domain that was specified when another Amazon Web Services account submitted a <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html">TransferDomainToAnotherAwsAccount</a> request. </p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The password that was returned by the <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html">TransferDomainToAnotherAwsAccount</a> request. </p>
    pub fn password(&self) -> std::option::Option<&str> {
        self.password.as_deref()
    }
}
impl std::fmt::Debug for AcceptDomainTransferFromAnotherAwsAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcceptDomainTransferFromAnotherAwsAccountInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("password", &self.password);
        formatter.finish()
    }
}
