// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for Amazon Route 53 Domains
///
/// Client for invoking operations on Amazon Route 53 Domains. Each operation on Amazon Route 53 Domains is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_route53domains::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_route53domains::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_route53domains::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AcceptDomainTransferFromAnotherAwsAccount` operation.
    ///
    /// See [`AcceptDomainTransferFromAnotherAwsAccount`](crate::client::fluent_builders::AcceptDomainTransferFromAnotherAwsAccount) for more information about the
    /// operation and its arguments.
    pub fn accept_domain_transfer_from_another_aws_account(
        &self,
    ) -> fluent_builders::AcceptDomainTransferFromAnotherAwsAccount<C, M, R> {
        fluent_builders::AcceptDomainTransferFromAnotherAwsAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelDomainTransferToAnotherAwsAccount` operation.
    ///
    /// See [`CancelDomainTransferToAnotherAwsAccount`](crate::client::fluent_builders::CancelDomainTransferToAnotherAwsAccount) for more information about the
    /// operation and its arguments.
    pub fn cancel_domain_transfer_to_another_aws_account(
        &self,
    ) -> fluent_builders::CancelDomainTransferToAnotherAwsAccount<C, M, R> {
        fluent_builders::CancelDomainTransferToAnotherAwsAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CheckDomainAvailability` operation.
    ///
    /// See [`CheckDomainAvailability`](crate::client::fluent_builders::CheckDomainAvailability) for more information about the
    /// operation and its arguments.
    pub fn check_domain_availability(&self) -> fluent_builders::CheckDomainAvailability<C, M, R> {
        fluent_builders::CheckDomainAvailability::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CheckDomainTransferability` operation.
    ///
    /// See [`CheckDomainTransferability`](crate::client::fluent_builders::CheckDomainTransferability) for more information about the
    /// operation and its arguments.
    pub fn check_domain_transferability(
        &self,
    ) -> fluent_builders::CheckDomainTransferability<C, M, R> {
        fluent_builders::CheckDomainTransferability::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTagsForDomain` operation.
    ///
    /// See [`DeleteTagsForDomain`](crate::client::fluent_builders::DeleteTagsForDomain) for more information about the
    /// operation and its arguments.
    pub fn delete_tags_for_domain(&self) -> fluent_builders::DeleteTagsForDomain<C, M, R> {
        fluent_builders::DeleteTagsForDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisableDomainAutoRenew` operation.
    ///
    /// See [`DisableDomainAutoRenew`](crate::client::fluent_builders::DisableDomainAutoRenew) for more information about the
    /// operation and its arguments.
    pub fn disable_domain_auto_renew(&self) -> fluent_builders::DisableDomainAutoRenew<C, M, R> {
        fluent_builders::DisableDomainAutoRenew::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisableDomainTransferLock` operation.
    ///
    /// See [`DisableDomainTransferLock`](crate::client::fluent_builders::DisableDomainTransferLock) for more information about the
    /// operation and its arguments.
    pub fn disable_domain_transfer_lock(
        &self,
    ) -> fluent_builders::DisableDomainTransferLock<C, M, R> {
        fluent_builders::DisableDomainTransferLock::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EnableDomainAutoRenew` operation.
    ///
    /// See [`EnableDomainAutoRenew`](crate::client::fluent_builders::EnableDomainAutoRenew) for more information about the
    /// operation and its arguments.
    pub fn enable_domain_auto_renew(&self) -> fluent_builders::EnableDomainAutoRenew<C, M, R> {
        fluent_builders::EnableDomainAutoRenew::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EnableDomainTransferLock` operation.
    ///
    /// See [`EnableDomainTransferLock`](crate::client::fluent_builders::EnableDomainTransferLock) for more information about the
    /// operation and its arguments.
    pub fn enable_domain_transfer_lock(
        &self,
    ) -> fluent_builders::EnableDomainTransferLock<C, M, R> {
        fluent_builders::EnableDomainTransferLock::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetContactReachabilityStatus` operation.
    ///
    /// See [`GetContactReachabilityStatus`](crate::client::fluent_builders::GetContactReachabilityStatus) for more information about the
    /// operation and its arguments.
    pub fn get_contact_reachability_status(
        &self,
    ) -> fluent_builders::GetContactReachabilityStatus<C, M, R> {
        fluent_builders::GetContactReachabilityStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDomainDetail` operation.
    ///
    /// See [`GetDomainDetail`](crate::client::fluent_builders::GetDomainDetail) for more information about the
    /// operation and its arguments.
    pub fn get_domain_detail(&self) -> fluent_builders::GetDomainDetail<C, M, R> {
        fluent_builders::GetDomainDetail::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDomainSuggestions` operation.
    ///
    /// See [`GetDomainSuggestions`](crate::client::fluent_builders::GetDomainSuggestions) for more information about the
    /// operation and its arguments.
    pub fn get_domain_suggestions(&self) -> fluent_builders::GetDomainSuggestions<C, M, R> {
        fluent_builders::GetDomainSuggestions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetOperationDetail` operation.
    ///
    /// See [`GetOperationDetail`](crate::client::fluent_builders::GetOperationDetail) for more information about the
    /// operation and its arguments.
    pub fn get_operation_detail(&self) -> fluent_builders::GetOperationDetail<C, M, R> {
        fluent_builders::GetOperationDetail::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDomains` operation.
    ///
    /// See [`ListDomains`](crate::client::fluent_builders::ListDomains) for more information about the
    /// operation and its arguments.
    pub fn list_domains(&self) -> fluent_builders::ListDomains<C, M, R> {
        fluent_builders::ListDomains::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListOperations` operation.
    ///
    /// See [`ListOperations`](crate::client::fluent_builders::ListOperations) for more information about the
    /// operation and its arguments.
    pub fn list_operations(&self) -> fluent_builders::ListOperations<C, M, R> {
        fluent_builders::ListOperations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForDomain` operation.
    ///
    /// See [`ListTagsForDomain`](crate::client::fluent_builders::ListTagsForDomain) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_domain(&self) -> fluent_builders::ListTagsForDomain<C, M, R> {
        fluent_builders::ListTagsForDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterDomain` operation.
    ///
    /// See [`RegisterDomain`](crate::client::fluent_builders::RegisterDomain) for more information about the
    /// operation and its arguments.
    pub fn register_domain(&self) -> fluent_builders::RegisterDomain<C, M, R> {
        fluent_builders::RegisterDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RejectDomainTransferFromAnotherAwsAccount` operation.
    ///
    /// See [`RejectDomainTransferFromAnotherAwsAccount`](crate::client::fluent_builders::RejectDomainTransferFromAnotherAwsAccount) for more information about the
    /// operation and its arguments.
    pub fn reject_domain_transfer_from_another_aws_account(
        &self,
    ) -> fluent_builders::RejectDomainTransferFromAnotherAwsAccount<C, M, R> {
        fluent_builders::RejectDomainTransferFromAnotherAwsAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RenewDomain` operation.
    ///
    /// See [`RenewDomain`](crate::client::fluent_builders::RenewDomain) for more information about the
    /// operation and its arguments.
    pub fn renew_domain(&self) -> fluent_builders::RenewDomain<C, M, R> {
        fluent_builders::RenewDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ResendContactReachabilityEmail` operation.
    ///
    /// See [`ResendContactReachabilityEmail`](crate::client::fluent_builders::ResendContactReachabilityEmail) for more information about the
    /// operation and its arguments.
    pub fn resend_contact_reachability_email(
        &self,
    ) -> fluent_builders::ResendContactReachabilityEmail<C, M, R> {
        fluent_builders::ResendContactReachabilityEmail::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RetrieveDomainAuthCode` operation.
    ///
    /// See [`RetrieveDomainAuthCode`](crate::client::fluent_builders::RetrieveDomainAuthCode) for more information about the
    /// operation and its arguments.
    pub fn retrieve_domain_auth_code(&self) -> fluent_builders::RetrieveDomainAuthCode<C, M, R> {
        fluent_builders::RetrieveDomainAuthCode::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TransferDomain` operation.
    ///
    /// See [`TransferDomain`](crate::client::fluent_builders::TransferDomain) for more information about the
    /// operation and its arguments.
    pub fn transfer_domain(&self) -> fluent_builders::TransferDomain<C, M, R> {
        fluent_builders::TransferDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TransferDomainToAnotherAwsAccount` operation.
    ///
    /// See [`TransferDomainToAnotherAwsAccount`](crate::client::fluent_builders::TransferDomainToAnotherAwsAccount) for more information about the
    /// operation and its arguments.
    pub fn transfer_domain_to_another_aws_account(
        &self,
    ) -> fluent_builders::TransferDomainToAnotherAwsAccount<C, M, R> {
        fluent_builders::TransferDomainToAnotherAwsAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDomainContact` operation.
    ///
    /// See [`UpdateDomainContact`](crate::client::fluent_builders::UpdateDomainContact) for more information about the
    /// operation and its arguments.
    pub fn update_domain_contact(&self) -> fluent_builders::UpdateDomainContact<C, M, R> {
        fluent_builders::UpdateDomainContact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDomainContactPrivacy` operation.
    ///
    /// See [`UpdateDomainContactPrivacy`](crate::client::fluent_builders::UpdateDomainContactPrivacy) for more information about the
    /// operation and its arguments.
    pub fn update_domain_contact_privacy(
        &self,
    ) -> fluent_builders::UpdateDomainContactPrivacy<C, M, R> {
        fluent_builders::UpdateDomainContactPrivacy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDomainNameservers` operation.
    ///
    /// See [`UpdateDomainNameservers`](crate::client::fluent_builders::UpdateDomainNameservers) for more information about the
    /// operation and its arguments.
    pub fn update_domain_nameservers(&self) -> fluent_builders::UpdateDomainNameservers<C, M, R> {
        fluent_builders::UpdateDomainNameservers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateTagsForDomain` operation.
    ///
    /// See [`UpdateTagsForDomain`](crate::client::fluent_builders::UpdateTagsForDomain) for more information about the
    /// operation and its arguments.
    pub fn update_tags_for_domain(&self) -> fluent_builders::UpdateTagsForDomain<C, M, R> {
        fluent_builders::UpdateTagsForDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ViewBilling` operation.
    ///
    /// See [`ViewBilling`](crate::client::fluent_builders::ViewBilling) for more information about the
    /// operation and its arguments.
    pub fn view_billing(&self) -> fluent_builders::ViewBilling<C, M, R> {
        fluent_builders::ViewBilling::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AcceptDomainTransferFromAnotherAwsAccount`.
    ///
    /// <p>Accepts the transfer of a domain from another AWS account to the current AWS account. You initiate a transfer between AWS accounts using
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html">TransferDomainToAnotherAwsAccount</a>.
    /// </p>
    ///
    /// <p>Use either
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListOperations.html">ListOperations</a> or
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>
    /// to determine whether the operation succeeded.
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>
    /// provides additional information, for example, <code>Domain Transfer from Aws Account 111122223333 has been cancelled</code>.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct AcceptDomainTransferFromAnotherAwsAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::accept_domain_transfer_from_another_aws_account_input::Builder,
    }
    impl<C, M, R> AcceptDomainTransferFromAnotherAwsAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AcceptDomainTransferFromAnotherAwsAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcceptDomainTransferFromAnotherAwsAccountOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AcceptDomainTransferFromAnotherAwsAccountError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AcceptDomainTransferFromAnotherAwsAccountInputOperationOutputAlias,
                crate::output::AcceptDomainTransferFromAnotherAwsAccountOutput,
                crate::error::AcceptDomainTransferFromAnotherAwsAccountError,
                crate::input::AcceptDomainTransferFromAnotherAwsAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that was specified when another AWS account submitted a
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html">TransferDomainToAnotherAwsAccount</a>
        /// request.
        /// </p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The name of the domain that was specified when another AWS account submitted a
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html">TransferDomainToAnotherAwsAccount</a>
        /// request.
        /// </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The password that was returned by the
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html">TransferDomainToAnotherAwsAccount</a>
        /// request.
        /// </p>
        pub fn password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(inp);
            self
        }
        /// <p>The password that was returned by the
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html">TransferDomainToAnotherAwsAccount</a>
        /// request.
        /// </p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelDomainTransferToAnotherAwsAccount`.
    ///
    /// <p>Cancels the transfer of a domain from the current AWS account to another AWS account. You initiate a transfer between AWS accounts using
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html">TransferDomainToAnotherAwsAccount</a>.
    /// </p>
    ///
    /// <important>
    /// <p>You must cancel the transfer before the other AWS account accepts the transfer using
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_AcceptDomainTransferFromAnotherAwsAccount.html">AcceptDomainTransferFromAnotherAwsAccount</a>.</p>
    /// </important>
    ///
    /// <p>Use either
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListOperations.html">ListOperations</a> or
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>
    /// to determine whether the operation succeeded.
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>
    /// provides additional information, for example, <code>Domain Transfer from Aws Account 111122223333 has been cancelled</code>.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct CancelDomainTransferToAnotherAwsAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_domain_transfer_to_another_aws_account_input::Builder,
    }
    impl<C, M, R> CancelDomainTransferToAnotherAwsAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelDomainTransferToAnotherAwsAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelDomainTransferToAnotherAwsAccountOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CancelDomainTransferToAnotherAwsAccountError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelDomainTransferToAnotherAwsAccountInputOperationOutputAlias,
                crate::output::CancelDomainTransferToAnotherAwsAccountOutput,
                crate::error::CancelDomainTransferToAnotherAwsAccountError,
                crate::input::CancelDomainTransferToAnotherAwsAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain for which you want to cancel the transfer to another AWS account.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The name of the domain for which you want to cancel the transfer to another AWS account.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CheckDomainAvailability`.
    ///
    /// <p>This operation checks the availability of one domain name. Note that if the availability status of a domain is pending, you must
    /// submit another request to determine the availability of the domain name.</p>
    #[derive(std::fmt::Debug)]
    pub struct CheckDomainAvailability<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::check_domain_availability_input::Builder,
    }
    impl<C, M, R> CheckDomainAvailability<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CheckDomainAvailability`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CheckDomainAvailabilityOutput,
            aws_smithy_http::result::SdkError<crate::error::CheckDomainAvailabilityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CheckDomainAvailabilityInputOperationOutputAlias,
                crate::output::CheckDomainAvailabilityOutput,
                crate::error::CheckDomainAvailabilityError,
                crate::input::CheckDomainAvailabilityInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that you want to get availability for. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports.
        /// For a list of supported TLDs, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the
        /// <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>The domain name can contain only the following characters:</p>
        /// <ul>
        /// <li>
        /// <p>Letters a through z. Domain names are not case sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Numbers 0 through 9.</p>
        /// </li>
        /// <li>
        /// <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p>
        /// </li>
        /// <li>
        /// <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p>
        /// </li>
        /// </ul>
        /// <p>Internationalized domain names are not supported for some top-level domains. To determine whether the TLD that you want to use supports
        /// internationalized domain names, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a>.
        /// For more information, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html#domain-name-format-idns">Formatting Internationalized Domain Names</a>.
        /// </p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The name of the domain that you want to get availability for. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports.
        /// For a list of supported TLDs, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the
        /// <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>The domain name can contain only the following characters:</p>
        /// <ul>
        /// <li>
        /// <p>Letters a through z. Domain names are not case sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Numbers 0 through 9.</p>
        /// </li>
        /// <li>
        /// <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p>
        /// </li>
        /// <li>
        /// <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p>
        /// </li>
        /// </ul>
        /// <p>Internationalized domain names are not supported for some top-level domains. To determine whether the TLD that you want to use supports
        /// internationalized domain names, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a>.
        /// For more information, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html#domain-name-format-idns">Formatting Internationalized Domain Names</a>.
        /// </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn idn_lang_code(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idn_lang_code(inp);
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_idn_lang_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idn_lang_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CheckDomainTransferability`.
    ///
    /// <p>Checks whether a domain name can be transferred to Amazon Route 53. </p>
    #[derive(std::fmt::Debug)]
    pub struct CheckDomainTransferability<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::check_domain_transferability_input::Builder,
    }
    impl<C, M, R> CheckDomainTransferability<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CheckDomainTransferability`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CheckDomainTransferabilityOutput,
            aws_smithy_http::result::SdkError<crate::error::CheckDomainTransferabilityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CheckDomainTransferabilityInputOperationOutputAlias,
                crate::output::CheckDomainTransferabilityOutput,
                crate::error::CheckDomainTransferabilityError,
                crate::input::CheckDomainTransferabilityInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that you want to transfer to Route 53. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports.
        /// For a list of supported TLDs, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the
        /// <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>The domain name can contain only the following characters:</p>
        /// <ul>
        /// <li>
        /// <p>Letters a through z. Domain names are not case sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Numbers 0 through 9.</p>
        /// </li>
        /// <li>
        /// <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p>
        /// </li>
        /// <li>
        /// <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p>
        /// </li>
        /// </ul>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The name of the domain that you want to transfer to Route 53. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports.
        /// For a list of supported TLDs, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the
        /// <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>The domain name can contain only the following characters:</p>
        /// <ul>
        /// <li>
        /// <p>Letters a through z. Domain names are not case sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Numbers 0 through 9.</p>
        /// </li>
        /// <li>
        /// <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p>
        /// </li>
        /// <li>
        /// <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>If the registrar for the top-level domain (TLD) requires an authorization code to transfer the domain,
        /// the code that you got from the current registrar for the domain.</p>
        pub fn auth_code(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.auth_code(inp);
            self
        }
        /// <p>If the registrar for the top-level domain (TLD) requires an authorization code to transfer the domain,
        /// the code that you got from the current registrar for the domain.</p>
        pub fn set_auth_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_auth_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTagsForDomain`.
    ///
    /// <p>This operation deletes the specified tags for a domain.</p>
    /// <p>All tag operations are eventually consistent; subsequent operations might not immediately represent all issued operations.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteTagsForDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_tags_for_domain_input::Builder,
    }
    impl<C, M, R> DeleteTagsForDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTagsForDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTagsForDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTagsForDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTagsForDomainInputOperationOutputAlias,
                crate::output::DeleteTagsForDomainOutput,
                crate::error::DeleteTagsForDomainError,
                crate::input::DeleteTagsForDomainInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain for which you want to delete one or more tags.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The domain for which you want to delete one or more tags.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// Appends an item to `TagsToDelete`.
        ///
        /// To override the contents of this collection use [`set_tags_to_delete`](Self::set_tags_to_delete).
        ///
        /// <p>A list of tag keys to delete.</p>
        pub fn tags_to_delete(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tags_to_delete(inp);
            self
        }
        /// <p>A list of tag keys to delete.</p>
        pub fn set_tags_to_delete(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tags_to_delete(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableDomainAutoRenew`.
    ///
    /// <p>This operation disables automatic renewal of domain registration for the specified domain.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisableDomainAutoRenew<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disable_domain_auto_renew_input::Builder,
    }
    impl<C, M, R> DisableDomainAutoRenew<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisableDomainAutoRenew`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableDomainAutoRenewOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableDomainAutoRenewError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisableDomainAutoRenewInputOperationOutputAlias,
                crate::output::DisableDomainAutoRenewOutput,
                crate::error::DisableDomainAutoRenewError,
                crate::input::DisableDomainAutoRenewInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that you want to disable automatic renewal for.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The name of the domain that you want to disable automatic renewal for.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableDomainTransferLock`.
    ///
    /// <p>This operation removes the transfer lock on the domain (specifically the
    /// <code>clientTransferProhibited</code> status) to allow domain transfers. We recommend
    /// you refrain from performing this action unless you intend to transfer the domain to a
    /// different registrar. Successful submission returns an operation ID that you can use to track
    /// the progress and completion of the action. If the request is not completed successfully, the
    /// domain registrant will be notified by email.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisableDomainTransferLock<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disable_domain_transfer_lock_input::Builder,
    }
    impl<C, M, R> DisableDomainTransferLock<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisableDomainTransferLock`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableDomainTransferLockOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableDomainTransferLockError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisableDomainTransferLockInputOperationOutputAlias,
                crate::output::DisableDomainTransferLockOutput,
                crate::error::DisableDomainTransferLockError,
                crate::input::DisableDomainTransferLockInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that you want to remove the transfer lock for.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The name of the domain that you want to remove the transfer lock for.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableDomainAutoRenew`.
    ///
    /// <p>This operation configures Amazon Route 53 to automatically renew the specified domain before the domain registration expires.
    /// The cost of renewing your domain registration is billed to your AWS account.</p>
    /// <p>The period during which you can renew a domain name varies by TLD. For a list of TLDs and their renewal policies, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains That You Can Register with Amazon Route 53</a>
    /// in the <i>Amazon Route 53 Developer Guide</i>. Route 53 requires that you renew before the end of the renewal period
    /// so we can complete processing before the deadline.</p>
    #[derive(std::fmt::Debug)]
    pub struct EnableDomainAutoRenew<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::enable_domain_auto_renew_input::Builder,
    }
    impl<C, M, R> EnableDomainAutoRenew<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EnableDomainAutoRenew`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableDomainAutoRenewOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableDomainAutoRenewError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EnableDomainAutoRenewInputOperationOutputAlias,
                crate::output::EnableDomainAutoRenewOutput,
                crate::error::EnableDomainAutoRenewError,
                crate::input::EnableDomainAutoRenewInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that you want to enable automatic renewal for.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The name of the domain that you want to enable automatic renewal for.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableDomainTransferLock`.
    ///
    /// <p>This operation sets the transfer lock on the domain (specifically the <code>clientTransferProhibited</code> status)
    /// to prevent domain transfers. Successful submission returns an operation ID that you can use to track the progress and
    /// completion of the action. If the request is not completed successfully, the domain registrant will be notified by email.</p>
    #[derive(std::fmt::Debug)]
    pub struct EnableDomainTransferLock<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::enable_domain_transfer_lock_input::Builder,
    }
    impl<C, M, R> EnableDomainTransferLock<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EnableDomainTransferLock`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableDomainTransferLockOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableDomainTransferLockError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EnableDomainTransferLockInputOperationOutputAlias,
                crate::output::EnableDomainTransferLockOutput,
                crate::error::EnableDomainTransferLockError,
                crate::input::EnableDomainTransferLockInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that you want to set the transfer lock for.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The name of the domain that you want to set the transfer lock for.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetContactReachabilityStatus`.
    ///
    /// <p>For operations that require confirmation that the email address for the registrant contact is valid,
    /// such as registering a new domain, this operation returns information about whether the registrant contact has responded.</p>
    /// <p>If you want us to resend the email, use the <code>ResendContactReachabilityEmail</code> operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetContactReachabilityStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_contact_reachability_status_input::Builder,
    }
    impl<C, M, R> GetContactReachabilityStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetContactReachabilityStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetContactReachabilityStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetContactReachabilityStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetContactReachabilityStatusInputOperationOutputAlias,
                crate::output::GetContactReachabilityStatusOutput,
                crate::error::GetContactReachabilityStatusError,
                crate::input::GetContactReachabilityStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain for which you want to know whether the registrant contact has confirmed that the email address is valid.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The name of the domain for which you want to know whether the registrant contact has confirmed that the email address is valid.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDomainDetail`.
    ///
    /// <p>This operation returns detailed information about a specified domain that is associated with the current AWS account.
    /// Contact information for the domain is also returned as part of the output.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDomainDetail<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_domain_detail_input::Builder,
    }
    impl<C, M, R> GetDomainDetail<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDomainDetail`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDomainDetailOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDomainDetailError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDomainDetailInputOperationOutputAlias,
                crate::output::GetDomainDetailOutput,
                crate::error::GetDomainDetailError,
                crate::input::GetDomainDetailInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that you want to get detailed information about.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The name of the domain that you want to get detailed information about.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDomainSuggestions`.
    ///
    /// <p>The GetDomainSuggestions operation returns a list of suggested domain names.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDomainSuggestions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_domain_suggestions_input::Builder,
    }
    impl<C, M, R> GetDomainSuggestions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDomainSuggestions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDomainSuggestionsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDomainSuggestionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDomainSuggestionsInputOperationOutputAlias,
                crate::output::GetDomainSuggestionsOutput,
                crate::error::GetDomainSuggestionsError,
                crate::input::GetDomainSuggestionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A domain name that you want to use as the basis for a list of possible domain names. The top-level domain (TLD), such as .com,
        /// must be a TLD that Route 53 supports. For a list of supported TLDs, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the
        /// <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>The domain name can contain only the following characters:</p>
        /// <ul>
        /// <li>
        /// <p>Letters a through z. Domain names are not case sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Numbers 0 through 9.</p>
        /// </li>
        /// <li>
        /// <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p>
        /// </li>
        /// <li>
        /// <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p>
        /// </li>
        /// </ul>
        /// <p>Internationalized domain names are not supported for some top-level domains. To determine whether the TLD that you want to use
        /// supports internationalized domain names, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a>.
        /// </p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>A domain name that you want to use as the basis for a list of possible domain names. The top-level domain (TLD), such as .com,
        /// must be a TLD that Route 53 supports. For a list of supported TLDs, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the
        /// <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>The domain name can contain only the following characters:</p>
        /// <ul>
        /// <li>
        /// <p>Letters a through z. Domain names are not case sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Numbers 0 through 9.</p>
        /// </li>
        /// <li>
        /// <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p>
        /// </li>
        /// <li>
        /// <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p>
        /// </li>
        /// </ul>
        /// <p>Internationalized domain names are not supported for some top-level domains. To determine whether the TLD that you want to use
        /// supports internationalized domain names, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a>.
        /// </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The number of suggested domain names that you want Route 53 to return. Specify a value between 1 and 50.</p>
        pub fn suggestion_count(mut self, inp: i32) -> Self {
            self.inner = self.inner.suggestion_count(inp);
            self
        }
        /// <p>The number of suggested domain names that you want Route 53 to return. Specify a value between 1 and 50.</p>
        pub fn set_suggestion_count(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_suggestion_count(input);
            self
        }
        /// <p>If <code>OnlyAvailable</code> is <code>true</code>, Route 53 returns only domain names that are available.
        /// If <code>OnlyAvailable</code> is <code>false</code>, Route 53 returns domain names without checking whether they're
        /// available to be registered. To determine whether the domain is available, you can call <code>checkDomainAvailability</code>
        /// for each suggestion.</p>
        pub fn only_available(mut self, inp: bool) -> Self {
            self.inner = self.inner.only_available(inp);
            self
        }
        /// <p>If <code>OnlyAvailable</code> is <code>true</code>, Route 53 returns only domain names that are available.
        /// If <code>OnlyAvailable</code> is <code>false</code>, Route 53 returns domain names without checking whether they're
        /// available to be registered. To determine whether the domain is available, you can call <code>checkDomainAvailability</code>
        /// for each suggestion.</p>
        pub fn set_only_available(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_only_available(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetOperationDetail`.
    ///
    /// <p>This operation returns the current status of an operation that is not completed.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetOperationDetail<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_operation_detail_input::Builder,
    }
    impl<C, M, R> GetOperationDetail<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetOperationDetail`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetOperationDetailOutput,
            aws_smithy_http::result::SdkError<crate::error::GetOperationDetailError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetOperationDetailInputOperationOutputAlias,
                crate::output::GetOperationDetailOutput,
                crate::error::GetOperationDetailError,
                crate::input::GetOperationDetailInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the operation for which you want to get the status. Route 53 returned the identifier
        /// in the response to the original request.</p>
        pub fn operation_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.operation_id(inp);
            self
        }
        /// <p>The identifier for the operation for which you want to get the status. Route 53 returned the identifier
        /// in the response to the original request.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_operation_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDomains`.
    ///
    /// <p>This operation returns all the domain names registered with Amazon Route 53 for the current AWS account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDomains<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_domains_input::Builder,
    }
    impl<C, M, R> ListDomains<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDomains`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDomainsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDomainsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDomainsInputOperationOutputAlias,
                crate::output::ListDomainsOutput,
                crate::error::ListDomainsError,
                crate::input::ListDomainsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>For an initial request for a list of domains, omit this element. If the number of domains
        /// that are associated with the current AWS account is greater than the value that you specified for
        /// <code>MaxItems</code>, you can use <code>Marker</code> to return additional domains. Get the value of
        /// <code>NextPageMarker</code> from the previous response, and submit another request that includes the
        /// value of <code>NextPageMarker</code> in the <code>Marker</code> element.</p>
        /// <p>Constraints: The marker must match the value specified in the previous request.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>For an initial request for a list of domains, omit this element. If the number of domains
        /// that are associated with the current AWS account is greater than the value that you specified for
        /// <code>MaxItems</code>, you can use <code>Marker</code> to return additional domains. Get the value of
        /// <code>NextPageMarker</code> from the previous response, and submit another request that includes the
        /// value of <code>NextPageMarker</code> in the <code>Marker</code> element.</p>
        /// <p>Constraints: The marker must match the value specified in the previous request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Number of domains to be returned.</p>
        /// <p>Default: 20</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Number of domains to be returned.</p>
        /// <p>Default: 20</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOperations`.
    ///
    /// <p>Returns information about all of the operations that return an operation ID and that have ever been
    /// performed on domains that were registered by the current account. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListOperations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_operations_input::Builder,
    }
    impl<C, M, R> ListOperations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListOperations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOperationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOperationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListOperationsInputOperationOutputAlias,
                crate::output::ListOperationsOutput,
                crate::error::ListOperationsError,
                crate::input::ListOperationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An optional parameter that lets you get information about all the operations that you submitted after a specified date and time.
        /// Specify the date and time in Unix time format and Coordinated Universal time (UTC).</p>
        pub fn submitted_since(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.submitted_since(inp);
            self
        }
        /// <p>An optional parameter that lets you get information about all the operations that you submitted after a specified date and time.
        /// Specify the date and time in Unix time format and Coordinated Universal time (UTC).</p>
        pub fn set_submitted_since(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_submitted_since(input);
            self
        }
        /// <p>For an initial request for a list of operations, omit this element. If the number of operations that are
        /// not yet complete is greater than the value that you specified for <code>MaxItems</code>, you can use <code>Marker</code>
        /// to return additional operations. Get the value of <code>NextPageMarker</code> from the previous response,
        /// and submit another request that includes the value of <code>NextPageMarker</code> in the <code>Marker</code> element.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>For an initial request for a list of operations, omit this element. If the number of operations that are
        /// not yet complete is greater than the value that you specified for <code>MaxItems</code>, you can use <code>Marker</code>
        /// to return additional operations. Get the value of <code>NextPageMarker</code> from the previous response,
        /// and submit another request that includes the value of <code>NextPageMarker</code> in the <code>Marker</code> element.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Number of domains to be returned.</p>
        /// <p>Default: 20</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Number of domains to be returned.</p>
        /// <p>Default: 20</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForDomain`.
    ///
    /// <p>This operation returns all of the tags that are associated with the specified domain.</p>
    /// <p>All tag operations are eventually consistent; subsequent operations might not immediately represent all issued operations.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_domain_input::Builder,
    }
    impl<C, M, R> ListTagsForDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForDomainInputOperationOutputAlias,
                crate::output::ListTagsForDomainOutput,
                crate::error::ListTagsForDomainError,
                crate::input::ListTagsForDomainInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain for which you want to get a list of tags.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The domain for which you want to get a list of tags.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterDomain`.
    ///
    /// <p>This operation registers a domain. Domains are registered either by Amazon Registrar (for .com, .net, and .org domains) or by  
    /// our registrar associate, Gandi (for all other domains). For some top-level domains (TLDs), this operation requires extra parameters.</p>
    /// <p>When you register a domain, Amazon Route 53 does the following:</p>
    /// <ul>
    /// <li>
    /// <p>Creates a Route 53 hosted zone that has the same name as the domain. Route 53 assigns four name servers
    /// to your hosted zone and automatically updates your domain registration with the names of these name servers.</p>
    /// </li>
    /// <li>
    /// <p>Enables autorenew, so your domain registration will renew automatically each year. We'll notify you
    /// in advance of the renewal date so you can choose whether to renew the registration.</p>
    /// </li>
    /// <li>
    /// <p>Optionally enables privacy protection, so WHOIS queries return contact information either for Amazon Registrar
    /// (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you don't enable privacy
    /// protection, WHOIS queries return the information that you entered for the registrant, admin, and tech contacts.</p>
    /// </li>
    /// <li>
    /// <p>If registration is successful, returns an operation ID that you can use to track the progress and
    /// completion of the action. If the request is not completed successfully, the domain registrant is notified by email.</p>
    /// </li>
    /// <li>
    /// <p>Charges your AWS account an amount based on the top-level domain. For more information, see
    /// <a href="http://aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a>.</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct RegisterDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::register_domain_input::Builder,
    }
    impl<C, M, R> RegisterDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegisterDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegisterDomainInputOperationOutputAlias,
                crate::output::RegisterDomainOutput,
                crate::error::RegisterDomainError,
                crate::input::RegisterDomainInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain name that you want to register. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports.
        /// For a list of supported TLDs, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the
        /// <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>The domain name can contain only the following characters:</p>
        /// <ul>
        /// <li>
        /// <p>Letters a through z. Domain names are not case sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Numbers 0 through 9.</p>
        /// </li>
        /// <li>
        /// <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p>
        /// </li>
        /// <li>
        /// <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p>
        /// </li>
        /// </ul>
        /// <p>Internationalized domain names are not supported for some top-level domains. To determine whether the TLD that you want to use supports
        /// internationalized domain names, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a>.
        /// For more information, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html#domain-name-format-idns">Formatting Internationalized Domain Names</a>.
        /// </p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The domain name that you want to register. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports.
        /// For a list of supported TLDs, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the
        /// <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>The domain name can contain only the following characters:</p>
        /// <ul>
        /// <li>
        /// <p>Letters a through z. Domain names are not case sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Numbers 0 through 9.</p>
        /// </li>
        /// <li>
        /// <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p>
        /// </li>
        /// <li>
        /// <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p>
        /// </li>
        /// </ul>
        /// <p>Internationalized domain names are not supported for some top-level domains. To determine whether the TLD that you want to use supports
        /// internationalized domain names, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a>.
        /// For more information, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html#domain-name-format-idns">Formatting Internationalized Domain Names</a>.
        /// </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn idn_lang_code(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idn_lang_code(inp);
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_idn_lang_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idn_lang_code(input);
            self
        }
        /// <p>The number of years that you want to register the domain for. Domains are registered for a minimum of one year.
        /// The maximum period depends on the top-level domain. For the range of valid values for your domain, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the
        /// <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>Default: 1</p>
        pub fn duration_in_years(mut self, inp: i32) -> Self {
            self.inner = self.inner.duration_in_years(inp);
            self
        }
        /// <p>The number of years that you want to register the domain for. Domains are registered for a minimum of one year.
        /// The maximum period depends on the top-level domain. For the range of valid values for your domain, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the
        /// <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>Default: 1</p>
        pub fn set_duration_in_years(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_duration_in_years(input);
            self
        }
        /// <p>Indicates whether the domain will be automatically renewed (<code>true</code>) or not (<code>false</code>).
        /// Autorenewal only takes effect after the account is charged.</p>
        /// <p>Default: <code>true</code>
        /// </p>
        pub fn auto_renew(mut self, inp: bool) -> Self {
            self.inner = self.inner.auto_renew(inp);
            self
        }
        /// <p>Indicates whether the domain will be automatically renewed (<code>true</code>) or not (<code>false</code>).
        /// Autorenewal only takes effect after the account is charged.</p>
        /// <p>Default: <code>true</code>
        /// </p>
        pub fn set_auto_renew(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_renew(input);
            self
        }
        /// <p>Provides detailed contact information. For information about the values that you specify for each element, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html">ContactDetail</a>.</p>
        pub fn admin_contact(mut self, inp: crate::model::ContactDetail) -> Self {
            self.inner = self.inner.admin_contact(inp);
            self
        }
        /// <p>Provides detailed contact information. For information about the values that you specify for each element, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html">ContactDetail</a>.</p>
        pub fn set_admin_contact(
            mut self,
            input: std::option::Option<crate::model::ContactDetail>,
        ) -> Self {
            self.inner = self.inner.set_admin_contact(input);
            self
        }
        /// <p>Provides detailed contact information. For information about the values that you specify for each element, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html">ContactDetail</a>.</p>
        pub fn registrant_contact(mut self, inp: crate::model::ContactDetail) -> Self {
            self.inner = self.inner.registrant_contact(inp);
            self
        }
        /// <p>Provides detailed contact information. For information about the values that you specify for each element, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html">ContactDetail</a>.</p>
        pub fn set_registrant_contact(
            mut self,
            input: std::option::Option<crate::model::ContactDetail>,
        ) -> Self {
            self.inner = self.inner.set_registrant_contact(input);
            self
        }
        /// <p>Provides detailed contact information. For information about the values that you specify for each element, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html">ContactDetail</a>.</p>
        pub fn tech_contact(mut self, inp: crate::model::ContactDetail) -> Self {
            self.inner = self.inner.tech_contact(inp);
            self
        }
        /// <p>Provides detailed contact information. For information about the values that you specify for each element, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html">ContactDetail</a>.</p>
        pub fn set_tech_contact(
            mut self,
            input: std::option::Option<crate::model::ContactDetail>,
        ) -> Self {
            self.inner = self.inner.set_tech_contact(input);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
        /// WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains)
        /// or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>,
        /// WHOIS queries return the information that you entered for the admin contact.</p>
        /// <p>Default: <code>true</code>
        /// </p>
        pub fn privacy_protect_admin_contact(mut self, inp: bool) -> Self {
            self.inner = self.inner.privacy_protect_admin_contact(inp);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
        /// WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains)
        /// or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>,
        /// WHOIS queries return the information that you entered for the admin contact.</p>
        /// <p>Default: <code>true</code>
        /// </p>
        pub fn set_privacy_protect_admin_contact(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_privacy_protect_admin_contact(input);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
        /// WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains)
        /// or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>,
        /// WHOIS queries return the information that you entered for the registrant contact (the domain owner).</p>
        /// <p>Default: <code>true</code>
        /// </p>
        pub fn privacy_protect_registrant_contact(mut self, inp: bool) -> Self {
            self.inner = self.inner.privacy_protect_registrant_contact(inp);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
        /// WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains)
        /// or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>,
        /// WHOIS queries return the information that you entered for the registrant contact (the domain owner).</p>
        /// <p>Default: <code>true</code>
        /// </p>
        pub fn set_privacy_protect_registrant_contact(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_privacy_protect_registrant_contact(input);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
        /// WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains)
        /// or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>,
        /// WHOIS queries return the information that you entered for the technical contact.</p>
        /// <p>Default: <code>true</code>
        /// </p>
        pub fn privacy_protect_tech_contact(mut self, inp: bool) -> Self {
            self.inner = self.inner.privacy_protect_tech_contact(inp);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
        /// WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains)
        /// or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>,
        /// WHOIS queries return the information that you entered for the technical contact.</p>
        /// <p>Default: <code>true</code>
        /// </p>
        pub fn set_privacy_protect_tech_contact(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_privacy_protect_tech_contact(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RejectDomainTransferFromAnotherAwsAccount`.
    ///
    /// <p>Rejects the transfer of a domain from another AWS account to the current AWS account. You initiate a transfer between AWS accounts using
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html">TransferDomainToAnotherAwsAccount</a>.
    /// </p>
    ///
    /// <p>Use either
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListOperations.html">ListOperations</a> or
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>
    /// to determine whether the operation succeeded.
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>
    /// provides additional information, for example, <code>Domain Transfer from Aws Account 111122223333 has been cancelled</code>.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct RejectDomainTransferFromAnotherAwsAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reject_domain_transfer_from_another_aws_account_input::Builder,
    }
    impl<C, M, R> RejectDomainTransferFromAnotherAwsAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RejectDomainTransferFromAnotherAwsAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RejectDomainTransferFromAnotherAwsAccountOutput,
            aws_smithy_http::result::SdkError<
                crate::error::RejectDomainTransferFromAnotherAwsAccountError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RejectDomainTransferFromAnotherAwsAccountInputOperationOutputAlias,
                crate::output::RejectDomainTransferFromAnotherAwsAccountOutput,
                crate::error::RejectDomainTransferFromAnotherAwsAccountError,
                crate::input::RejectDomainTransferFromAnotherAwsAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that was specified when another AWS account submitted a
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html">TransferDomainToAnotherAwsAccount</a>
        /// request.
        /// </p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The name of the domain that was specified when another AWS account submitted a
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html">TransferDomainToAnotherAwsAccount</a>
        /// request.
        /// </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RenewDomain`.
    ///
    /// <p>This operation renews a domain for the specified number of years. The cost of renewing your domain is billed to your AWS account.</p>
    /// <p>We recommend that you renew your domain several weeks before the expiration date. Some TLD registries delete domains before the
    /// expiration date if you haven't renewed far enough in advance. For more information about renewing domain registration, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/domain-renew.html">Renewing Registration for a Domain</a>
    /// in the <i>Amazon Route 53 Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct RenewDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::renew_domain_input::Builder,
    }
    impl<C, M, R> RenewDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RenewDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RenewDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::RenewDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RenewDomainInputOperationOutputAlias,
                crate::output::RenewDomainOutput,
                crate::error::RenewDomainError,
                crate::input::RenewDomainInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that you want to renew.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The name of the domain that you want to renew.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The number of years that you want to renew the domain for. The maximum number of years depends on the top-level domain.
        /// For the range of valid values for your domain, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the
        /// <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>Default: 1</p>
        pub fn duration_in_years(mut self, inp: i32) -> Self {
            self.inner = self.inner.duration_in_years(inp);
            self
        }
        /// <p>The number of years that you want to renew the domain for. The maximum number of years depends on the top-level domain.
        /// For the range of valid values for your domain, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the
        /// <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>Default: 1</p>
        pub fn set_duration_in_years(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_duration_in_years(input);
            self
        }
        /// <p>The year when the registration for the domain is set to expire. This value must match the current expiration date for the domain.</p>
        pub fn current_expiry_year(mut self, inp: i32) -> Self {
            self.inner = self.inner.current_expiry_year(inp);
            self
        }
        /// <p>The year when the registration for the domain is set to expire. This value must match the current expiration date for the domain.</p>
        pub fn set_current_expiry_year(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_current_expiry_year(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResendContactReachabilityEmail`.
    ///
    /// <p>For operations that require confirmation that the email address for the registrant contact is valid,
    /// such as registering a new domain, this operation resends the confirmation email to the current email address for the registrant contact.</p>
    #[derive(std::fmt::Debug)]
    pub struct ResendContactReachabilityEmail<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::resend_contact_reachability_email_input::Builder,
    }
    impl<C, M, R> ResendContactReachabilityEmail<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ResendContactReachabilityEmail`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResendContactReachabilityEmailOutput,
            aws_smithy_http::result::SdkError<crate::error::ResendContactReachabilityEmailError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ResendContactReachabilityEmailInputOperationOutputAlias,
                crate::output::ResendContactReachabilityEmailOutput,
                crate::error::ResendContactReachabilityEmailError,
                crate::input::ResendContactReachabilityEmailInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain for which you want Route 53 to resend a confirmation email to the registrant contact.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The name of the domain for which you want Route 53 to resend a confirmation email to the registrant contact.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RetrieveDomainAuthCode`.
    ///
    /// <p>This operation returns the AuthCode for the domain. To transfer a domain to another registrar, you provide this value to the new registrar.</p>
    #[derive(std::fmt::Debug)]
    pub struct RetrieveDomainAuthCode<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::retrieve_domain_auth_code_input::Builder,
    }
    impl<C, M, R> RetrieveDomainAuthCode<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RetrieveDomainAuthCode`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RetrieveDomainAuthCodeOutput,
            aws_smithy_http::result::SdkError<crate::error::RetrieveDomainAuthCodeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RetrieveDomainAuthCodeInputOperationOutputAlias,
                crate::output::RetrieveDomainAuthCodeOutput,
                crate::error::RetrieveDomainAuthCodeError,
                crate::input::RetrieveDomainAuthCodeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that you want to get an authorization code for.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The name of the domain that you want to get an authorization code for.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TransferDomain`.
    ///
    /// <p>Transfers a domain from another registrar to Amazon Route 53. When the transfer is complete, the domain is registered either with
    /// Amazon Registrar (for .com, .net, and .org domains) or with our registrar associate, Gandi (for all other TLDs).</p>
    /// <p>For more information about transferring domains, see the following topics:</p>
    /// <ul>
    /// <li>
    /// <p>For transfer requirements, a detailed procedure, and information about viewing the status of a domain that you're transferring
    /// to Route 53, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/domain-transfer-to-route-53.html">Transferring Registration for a
    /// Domain to Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
    /// </li>
    /// <li>
    /// <p>For information about how to transfer a domain from one AWS account to another, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html">TransferDomainToAnotherAwsAccount</a>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>For information about how to transfer a domain to another domain registrar, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/domain-transfer-from-route-53.html">Transferring a Domain from
    /// Amazon Route 53 to Another Registrar</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
    /// </li>
    /// </ul>
    /// <p>If the registrar for your domain is also the DNS service provider for the domain, we highly recommend that you
    /// transfer your DNS service to Route 53 or to another DNS service provider before you transfer your registration. Some registrars
    /// provide free DNS service when you purchase a domain registration. When you transfer the registration, the previous registrar
    /// will not renew your domain registration and could end your DNS service at any time.</p>
    ///
    /// <important>
    /// <p>If the registrar for your domain is also the DNS service provider for the domain and you don't
    /// transfer DNS service to another provider, your website, email, and the web applications associated with the domain
    /// might become unavailable.</p>
    /// </important>
    ///
    /// <p>If the transfer is successful, this method returns an operation ID that you can use to track the progress and
    /// completion of the action. If the transfer doesn't complete successfully, the domain registrant will be notified by email.</p>
    #[derive(std::fmt::Debug)]
    pub struct TransferDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::transfer_domain_input::Builder,
    }
    impl<C, M, R> TransferDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TransferDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TransferDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::TransferDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TransferDomainInputOperationOutputAlias,
                crate::output::TransferDomainOutput,
                crate::error::TransferDomainError,
                crate::input::TransferDomainInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that you want to transfer to Route 53. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports.
        /// For a list of supported TLDs, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the
        /// <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>The domain name can contain only the following characters:</p>
        /// <ul>
        /// <li>
        /// <p>Letters a through z. Domain names are not case sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Numbers 0 through 9.</p>
        /// </li>
        /// <li>
        /// <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p>
        /// </li>
        /// <li>
        /// <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p>
        /// </li>
        /// </ul>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The name of the domain that you want to transfer to Route 53. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports.
        /// For a list of supported TLDs, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the
        /// <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>The domain name can contain only the following characters:</p>
        /// <ul>
        /// <li>
        /// <p>Letters a through z. Domain names are not case sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Numbers 0 through 9.</p>
        /// </li>
        /// <li>
        /// <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p>
        /// </li>
        /// <li>
        /// <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn idn_lang_code(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idn_lang_code(inp);
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_idn_lang_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idn_lang_code(input);
            self
        }
        /// <p>The number of years that you want to register the domain for. Domains are registered for a minimum of one year.
        /// The maximum period depends on the top-level domain.</p>
        /// <p>Default: 1</p>
        pub fn duration_in_years(mut self, inp: i32) -> Self {
            self.inner = self.inner.duration_in_years(inp);
            self
        }
        /// <p>The number of years that you want to register the domain for. Domains are registered for a minimum of one year.
        /// The maximum period depends on the top-level domain.</p>
        /// <p>Default: 1</p>
        pub fn set_duration_in_years(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_duration_in_years(input);
            self
        }
        /// Appends an item to `Nameservers`.
        ///
        /// To override the contents of this collection use [`set_nameservers`](Self::set_nameservers).
        ///
        /// <p>Contains details for the host and glue IP addresses.</p>
        pub fn nameservers(mut self, inp: impl Into<crate::model::Nameserver>) -> Self {
            self.inner = self.inner.nameservers(inp);
            self
        }
        /// <p>Contains details for the host and glue IP addresses.</p>
        pub fn set_nameservers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Nameserver>>,
        ) -> Self {
            self.inner = self.inner.set_nameservers(input);
            self
        }
        /// <p>The authorization code for the domain. You get this value from the current registrar.</p>
        pub fn auth_code(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.auth_code(inp);
            self
        }
        /// <p>The authorization code for the domain. You get this value from the current registrar.</p>
        pub fn set_auth_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_auth_code(input);
            self
        }
        /// <p>Indicates whether the domain will be automatically renewed (true) or not (false). Autorenewal only takes effect
        /// after the account is charged.</p>
        /// <p>Default: true</p>
        pub fn auto_renew(mut self, inp: bool) -> Self {
            self.inner = self.inner.auto_renew(inp);
            self
        }
        /// <p>Indicates whether the domain will be automatically renewed (true) or not (false). Autorenewal only takes effect
        /// after the account is charged.</p>
        /// <p>Default: true</p>
        pub fn set_auto_renew(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_renew(input);
            self
        }
        /// <p>Provides detailed contact information.</p>
        pub fn admin_contact(mut self, inp: crate::model::ContactDetail) -> Self {
            self.inner = self.inner.admin_contact(inp);
            self
        }
        /// <p>Provides detailed contact information.</p>
        pub fn set_admin_contact(
            mut self,
            input: std::option::Option<crate::model::ContactDetail>,
        ) -> Self {
            self.inner = self.inner.set_admin_contact(input);
            self
        }
        /// <p>Provides detailed contact information.</p>
        pub fn registrant_contact(mut self, inp: crate::model::ContactDetail) -> Self {
            self.inner = self.inner.registrant_contact(inp);
            self
        }
        /// <p>Provides detailed contact information.</p>
        pub fn set_registrant_contact(
            mut self,
            input: std::option::Option<crate::model::ContactDetail>,
        ) -> Self {
            self.inner = self.inner.set_registrant_contact(input);
            self
        }
        /// <p>Provides detailed contact information.</p>
        pub fn tech_contact(mut self, inp: crate::model::ContactDetail) -> Self {
            self.inner = self.inner.tech_contact(inp);
            self
        }
        /// <p>Provides detailed contact information.</p>
        pub fn set_tech_contact(
            mut self,
            input: std::option::Option<crate::model::ContactDetail>,
        ) -> Self {
            self.inner = self.inner.set_tech_contact(input);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
        /// WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains)
        /// or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>,
        /// WHOIS queries return the information that you entered for the admin contact.</p>
        /// <p>Default: <code>true</code>
        /// </p>
        pub fn privacy_protect_admin_contact(mut self, inp: bool) -> Self {
            self.inner = self.inner.privacy_protect_admin_contact(inp);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
        /// WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains)
        /// or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>,
        /// WHOIS queries return the information that you entered for the admin contact.</p>
        /// <p>Default: <code>true</code>
        /// </p>
        pub fn set_privacy_protect_admin_contact(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_privacy_protect_admin_contact(input);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
        /// WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains)
        /// or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>,
        /// WHOIS queries return the information that you entered for the registrant contact (domain owner).</p>
        /// <p>Default: <code>true</code>
        /// </p>
        pub fn privacy_protect_registrant_contact(mut self, inp: bool) -> Self {
            self.inner = self.inner.privacy_protect_registrant_contact(inp);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
        /// WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains)
        /// or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>,
        /// WHOIS queries return the information that you entered for the registrant contact (domain owner).</p>
        /// <p>Default: <code>true</code>
        /// </p>
        pub fn set_privacy_protect_registrant_contact(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_privacy_protect_registrant_contact(input);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
        /// WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains)
        /// or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>,
        /// WHOIS queries return the information that you entered for the technical contact.</p>
        /// <p>Default: <code>true</code>
        /// </p>
        pub fn privacy_protect_tech_contact(mut self, inp: bool) -> Self {
            self.inner = self.inner.privacy_protect_tech_contact(inp);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
        /// WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains)
        /// or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>,
        /// WHOIS queries return the information that you entered for the technical contact.</p>
        /// <p>Default: <code>true</code>
        /// </p>
        pub fn set_privacy_protect_tech_contact(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_privacy_protect_tech_contact(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TransferDomainToAnotherAwsAccount`.
    ///
    /// <p>Transfers a domain from the current AWS account to another AWS account. Note the following:</p>
    /// <ul>
    /// <li>
    /// <p>The AWS account that you're transferring the domain to must accept the transfer. If the other account
    /// doesn't accept the transfer within 3 days, we cancel the transfer. See
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_AcceptDomainTransferFromAnotherAwsAccount.html">AcceptDomainTransferFromAnotherAwsAccount</a>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>You can cancel the transfer before the other account accepts it. See
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_CancelDomainTransferToAnotherAwsAccount.html">CancelDomainTransferToAnotherAwsAccount</a>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>The other account can reject the transfer. See
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RejectDomainTransferFromAnotherAwsAccount.html">RejectDomainTransferFromAnotherAwsAccount</a>.
    /// </p>
    /// </li>
    /// </ul>
    ///
    /// <important>
    /// <p>When you transfer a domain from one AWS account to another, Route 53 doesn't transfer the hosted zone that is associated
    /// with the domain. DNS resolution isn't affected if the domain and the hosted zone are owned by separate accounts,
    /// so transferring the hosted zone is optional. For information about transferring the hosted zone to another AWS account, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/hosted-zones-migrating.html">Migrating a Hosted Zone to a
    /// Different AWS Account</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
    /// </important>
    ///
    /// <p>Use either
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListOperations.html">ListOperations</a> or
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>
    /// to determine whether the operation succeeded.
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>
    /// provides additional information, for example, <code>Domain Transfer from Aws Account 111122223333 has been cancelled</code>.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct TransferDomainToAnotherAwsAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::transfer_domain_to_another_aws_account_input::Builder,
    }
    impl<C, M, R> TransferDomainToAnotherAwsAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TransferDomainToAnotherAwsAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TransferDomainToAnotherAwsAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::TransferDomainToAnotherAwsAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TransferDomainToAnotherAwsAccountInputOperationOutputAlias,
                crate::output::TransferDomainToAnotherAwsAccountOutput,
                crate::error::TransferDomainToAnotherAwsAccountError,
                crate::input::TransferDomainToAnotherAwsAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that you want to transfer from the current AWS account to another account.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The name of the domain that you want to transfer from the current AWS account to another account.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The account ID of the AWS account that you want to transfer the domain to, for example, <code>111122223333</code>.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The account ID of the AWS account that you want to transfer the domain to, for example, <code>111122223333</code>.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDomainContact`.
    ///
    /// <p>This operation updates the contact information for a particular domain. You must specify information for at least one contact:
    /// registrant, administrator, or technical.</p>
    /// <p>If the update is successful, this method returns an operation ID that you can use to track the progress and completion of the action.
    /// If the request is not completed successfully, the domain registrant will be notified by email.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDomainContact<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_domain_contact_input::Builder,
    }
    impl<C, M, R> UpdateDomainContact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDomainContact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDomainContactOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDomainContactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDomainContactInputOperationOutputAlias,
                crate::output::UpdateDomainContactOutput,
                crate::error::UpdateDomainContactError,
                crate::input::UpdateDomainContactInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that you want to update contact information for.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The name of the domain that you want to update contact information for.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>Provides detailed contact information.</p>
        pub fn admin_contact(mut self, inp: crate::model::ContactDetail) -> Self {
            self.inner = self.inner.admin_contact(inp);
            self
        }
        /// <p>Provides detailed contact information.</p>
        pub fn set_admin_contact(
            mut self,
            input: std::option::Option<crate::model::ContactDetail>,
        ) -> Self {
            self.inner = self.inner.set_admin_contact(input);
            self
        }
        /// <p>Provides detailed contact information.</p>
        pub fn registrant_contact(mut self, inp: crate::model::ContactDetail) -> Self {
            self.inner = self.inner.registrant_contact(inp);
            self
        }
        /// <p>Provides detailed contact information.</p>
        pub fn set_registrant_contact(
            mut self,
            input: std::option::Option<crate::model::ContactDetail>,
        ) -> Self {
            self.inner = self.inner.set_registrant_contact(input);
            self
        }
        /// <p>Provides detailed contact information.</p>
        pub fn tech_contact(mut self, inp: crate::model::ContactDetail) -> Self {
            self.inner = self.inner.tech_contact(inp);
            self
        }
        /// <p>Provides detailed contact information.</p>
        pub fn set_tech_contact(
            mut self,
            input: std::option::Option<crate::model::ContactDetail>,
        ) -> Self {
            self.inner = self.inner.set_tech_contact(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDomainContactPrivacy`.
    ///
    /// <p>This operation updates the specified domain contact's privacy setting. When privacy protection is enabled,
    /// contact information such as email address is replaced either with contact information for Amazon Registrar (for .com, .net, and .org
    /// domains) or with contact information for our registrar associate, Gandi.</p>
    /// <p>This operation affects only the contact information for the specified contact type (registrant, administrator, or tech).
    /// If the request succeeds, Amazon Route 53 returns an operation ID that you can use with
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>
    /// to track the progress and completion of the action. If the request doesn't complete successfully, the domain registrant will be notified by email.</p>
    /// <important>
    /// <p>By disabling the privacy service via API, you consent to the publication of the contact information provided for this domain
    /// via the public WHOIS database. You certify that you are the registrant of this domain name and have the authority to make this decision.
    /// You may withdraw your consent at any time by enabling privacy protection using either <code>UpdateDomainContactPrivacy</code> or the
    /// Route 53 console. Enabling privacy protection removes the contact information provided for this domain from the WHOIS database.
    /// For more information on our privacy practices, see
    /// <a href="https://aws.amazon.com/privacy/">https://aws.amazon.com/privacy/</a>.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDomainContactPrivacy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_domain_contact_privacy_input::Builder,
    }
    impl<C, M, R> UpdateDomainContactPrivacy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDomainContactPrivacy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDomainContactPrivacyOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDomainContactPrivacyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDomainContactPrivacyInputOperationOutputAlias,
                crate::output::UpdateDomainContactPrivacyOutput,
                crate::error::UpdateDomainContactPrivacyError,
                crate::input::UpdateDomainContactPrivacyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that you want to update the privacy setting for.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The name of the domain that you want to update the privacy setting for.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
        /// WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains)
        /// or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>,
        /// WHOIS queries return the information that you entered for the admin contact.</p>
        pub fn admin_privacy(mut self, inp: bool) -> Self {
            self.inner = self.inner.admin_privacy(inp);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
        /// WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains)
        /// or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>,
        /// WHOIS queries return the information that you entered for the admin contact.</p>
        pub fn set_admin_privacy(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_admin_privacy(input);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
        /// WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains)
        /// or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>,
        /// WHOIS queries return the information that you entered for the registrant contact (domain owner).</p>
        pub fn registrant_privacy(mut self, inp: bool) -> Self {
            self.inner = self.inner.registrant_privacy(inp);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
        /// WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains)
        /// or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>,
        /// WHOIS queries return the information that you entered for the registrant contact (domain owner).</p>
        pub fn set_registrant_privacy(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_registrant_privacy(input);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
        /// WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains)
        /// or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>,
        /// WHOIS queries return the information that you entered for the technical contact.</p>
        pub fn tech_privacy(mut self, inp: bool) -> Self {
            self.inner = self.inner.tech_privacy(inp);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
        /// WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains)
        /// or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>,
        /// WHOIS queries return the information that you entered for the technical contact.</p>
        pub fn set_tech_privacy(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_tech_privacy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDomainNameservers`.
    ///
    /// <p>This operation replaces the current set of name servers for the domain with the specified set of name servers.
    /// If you use Amazon Route 53 as your DNS service, specify the four name servers in the delegation set for the hosted zone for the domain.</p>
    /// <p>If successful, this operation returns an operation ID that you can use to track the progress and completion of the action.
    /// If the request is not completed successfully, the domain registrant will be notified by email.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDomainNameservers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_domain_nameservers_input::Builder,
    }
    impl<C, M, R> UpdateDomainNameservers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDomainNameservers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDomainNameserversOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDomainNameserversError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDomainNameserversInputOperationOutputAlias,
                crate::output::UpdateDomainNameserversOutput,
                crate::error::UpdateDomainNameserversError,
                crate::input::UpdateDomainNameserversInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that you want to change name servers for.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The name of the domain that you want to change name servers for.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The authorization key for .fi domains</p>
        pub fn fi_auth_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fi_auth_key(inp);
            self
        }
        /// <p>The authorization key for .fi domains</p>
        pub fn set_fi_auth_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fi_auth_key(input);
            self
        }
        /// Appends an item to `Nameservers`.
        ///
        /// To override the contents of this collection use [`set_nameservers`](Self::set_nameservers).
        ///
        /// <p>A list of new name servers for the domain.</p>
        pub fn nameservers(mut self, inp: impl Into<crate::model::Nameserver>) -> Self {
            self.inner = self.inner.nameservers(inp);
            self
        }
        /// <p>A list of new name servers for the domain.</p>
        pub fn set_nameservers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Nameserver>>,
        ) -> Self {
            self.inner = self.inner.set_nameservers(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTagsForDomain`.
    ///
    /// <p>This operation adds or updates tags for a specified domain.</p>
    /// <p>All tag operations are eventually consistent; subsequent operations might not immediately represent all issued operations.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateTagsForDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_tags_for_domain_input::Builder,
    }
    impl<C, M, R> UpdateTagsForDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateTagsForDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTagsForDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTagsForDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateTagsForDomainInputOperationOutputAlias,
                crate::output::UpdateTagsForDomainOutput,
                crate::error::UpdateTagsForDomainError,
                crate::input::UpdateTagsForDomainInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain for which you want to add or update tags.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The domain for which you want to add or update tags.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// Appends an item to `TagsToUpdate`.
        ///
        /// To override the contents of this collection use [`set_tags_to_update`](Self::set_tags_to_update).
        ///
        /// <p>A list of the tag keys and values that you want to add or update. If you specify a key
        /// that already exists, the corresponding value will be replaced.</p>
        pub fn tags_to_update(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags_to_update(inp);
            self
        }
        /// <p>A list of the tag keys and values that you want to add or update. If you specify a key
        /// that already exists, the corresponding value will be replaced.</p>
        pub fn set_tags_to_update(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags_to_update(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ViewBilling`.
    ///
    /// <p>Returns all the domain-related billing records for the current AWS account for a specified period</p>
    #[derive(std::fmt::Debug)]
    pub struct ViewBilling<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::view_billing_input::Builder,
    }
    impl<C, M, R> ViewBilling<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ViewBilling`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ViewBillingOutput,
            aws_smithy_http::result::SdkError<crate::error::ViewBillingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ViewBillingInputOperationOutputAlias,
                crate::output::ViewBillingOutput,
                crate::error::ViewBillingError,
                crate::input::ViewBillingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The beginning date and time for the time period for which you want a list of billing records. Specify the date and time
        /// in Unix time format and Coordinated Universal time (UTC).</p>
        pub fn start(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start(inp);
            self
        }
        /// <p>The beginning date and time for the time period for which you want a list of billing records. Specify the date and time
        /// in Unix time format and Coordinated Universal time (UTC).</p>
        pub fn set_start(mut self, input: std::option::Option<aws_smithy_types::DateTime>) -> Self {
            self.inner = self.inner.set_start(input);
            self
        }
        /// <p>The end date and time for the time period for which you want a list of billing records. Specify the date and time
        /// in Unix time format and Coordinated Universal time (UTC).</p>
        pub fn end(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end(inp);
            self
        }
        /// <p>The end date and time for the time period for which you want a list of billing records. Specify the date and time
        /// in Unix time format and Coordinated Universal time (UTC).</p>
        pub fn set_end(mut self, input: std::option::Option<aws_smithy_types::DateTime>) -> Self {
            self.inner = self.inner.set_end(input);
            self
        }
        /// <p>For an initial request for a list of billing records, omit this element. If the number of billing records
        /// that are associated with the current AWS account during the specified period is greater than the value that
        /// you specified for <code>MaxItems</code>, you can use <code>Marker</code> to return additional billing records.
        /// Get the value of <code>NextPageMarker</code> from the previous response, and submit another request that includes
        /// the value of <code>NextPageMarker</code> in the <code>Marker</code> element.
        /// </p>
        /// <p>Constraints: The marker must match the value of <code>NextPageMarker</code> that was returned in the previous response.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>For an initial request for a list of billing records, omit this element. If the number of billing records
        /// that are associated with the current AWS account during the specified period is greater than the value that
        /// you specified for <code>MaxItems</code>, you can use <code>Marker</code> to return additional billing records.
        /// Get the value of <code>NextPageMarker</code> from the previous response, and submit another request that includes
        /// the value of <code>NextPageMarker</code> in the <code>Marker</code> element.
        /// </p>
        /// <p>Constraints: The marker must match the value of <code>NextPageMarker</code> that was returned in the previous response.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The number of billing records to be returned.</p>
        /// <p>Default: 20</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>The number of billing records to be returned.</p>
        /// <p>Default: 20</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
}
impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
