// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Information for one billing record.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BillingRecord {
    /// <p>The name of the domain that the billing record applies to. If the domain name contains characters
    /// other than a-z, 0-9, and - (hyphen), such as an internationalized domain name, then this value is in Punycode.
    /// For more information, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html">DNS Domain Name Format</a>
    /// in the <i>Amazon Route 53 Developer Guide</i>.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The operation that you were charged for.</p>
    pub operation: std::option::Option<crate::model::OperationType>,
    /// <p>The ID of the invoice that is associated with the billing record.</p>
    pub invoice_id: std::option::Option<std::string::String>,
    /// <p>The date that the operation was billed, in Unix format.</p>
    pub bill_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The price that you were charged for the operation, in US dollars.</p>
    /// <p>Example value: 12.0</p>
    pub price: f64,
}
impl BillingRecord {
    /// <p>The name of the domain that the billing record applies to. If the domain name contains characters
    /// other than a-z, 0-9, and - (hyphen), such as an internationalized domain name, then this value is in Punycode.
    /// For more information, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html">DNS Domain Name Format</a>
    /// in the <i>Amazon Route 53 Developer Guide</i>.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The operation that you were charged for.</p>
    pub fn operation(&self) -> std::option::Option<&crate::model::OperationType> {
        self.operation.as_ref()
    }
    /// <p>The ID of the invoice that is associated with the billing record.</p>
    pub fn invoice_id(&self) -> std::option::Option<&str> {
        self.invoice_id.as_deref()
    }
    /// <p>The date that the operation was billed, in Unix format.</p>
    pub fn bill_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.bill_date.as_ref()
    }
    /// <p>The price that you were charged for the operation, in US dollars.</p>
    /// <p>Example value: 12.0</p>
    pub fn price(&self) -> f64 {
        self.price
    }
}
impl std::fmt::Debug for BillingRecord {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BillingRecord");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("operation", &self.operation);
        formatter.field("invoice_id", &self.invoice_id);
        formatter.field("bill_date", &self.bill_date);
        formatter.field("price", &self.price);
        formatter.finish()
    }
}
/// See [`BillingRecord`](crate::model::BillingRecord)
pub mod billing_record {
    /// A builder for [`BillingRecord`](crate::model::BillingRecord)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) operation: std::option::Option<crate::model::OperationType>,
        pub(crate) invoice_id: std::option::Option<std::string::String>,
        pub(crate) bill_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) price: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The name of the domain that the billing record applies to. If the domain name contains characters
        /// other than a-z, 0-9, and - (hyphen), such as an internationalized domain name, then this value is in Punycode.
        /// For more information, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html">DNS Domain Name Format</a>
        /// in the <i>Amazon Route 53 Developer Guide</i>.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the domain that the billing record applies to. If the domain name contains characters
        /// other than a-z, 0-9, and - (hyphen), such as an internationalized domain name, then this value is in Punycode.
        /// For more information, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html">DNS Domain Name Format</a>
        /// in the <i>Amazon Route 53 Developer Guide</i>.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The operation that you were charged for.</p>
        pub fn operation(mut self, input: crate::model::OperationType) -> Self {
            self.operation = Some(input);
            self
        }
        /// <p>The operation that you were charged for.</p>
        pub fn set_operation(
            mut self,
            input: std::option::Option<crate::model::OperationType>,
        ) -> Self {
            self.operation = input;
            self
        }
        /// <p>The ID of the invoice that is associated with the billing record.</p>
        pub fn invoice_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.invoice_id = Some(input.into());
            self
        }
        /// <p>The ID of the invoice that is associated with the billing record.</p>
        pub fn set_invoice_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.invoice_id = input;
            self
        }
        /// <p>The date that the operation was billed, in Unix format.</p>
        pub fn bill_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.bill_date = Some(input);
            self
        }
        /// <p>The date that the operation was billed, in Unix format.</p>
        pub fn set_bill_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.bill_date = input;
            self
        }
        /// <p>The price that you were charged for the operation, in US dollars.</p>
        /// <p>Example value: 12.0</p>
        pub fn price(mut self, input: f64) -> Self {
            self.price = Some(input);
            self
        }
        /// <p>The price that you were charged for the operation, in US dollars.</p>
        /// <p>Example value: 12.0</p>
        pub fn set_price(mut self, input: std::option::Option<f64>) -> Self {
            self.price = input;
            self
        }
        /// Consumes the builder and constructs a [`BillingRecord`](crate::model::BillingRecord)
        pub fn build(self) -> crate::model::BillingRecord {
            crate::model::BillingRecord {
                domain_name: self.domain_name,
                operation: self.operation,
                invoice_id: self.invoice_id,
                bill_date: self.bill_date,
                price: self.price.unwrap_or_default(),
            }
        }
    }
}
impl BillingRecord {
    /// Creates a new builder-style object to manufacture [`BillingRecord`](crate::model::BillingRecord)
    pub fn builder() -> crate::model::billing_record::Builder {
        crate::model::billing_record::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OperationType {
    #[allow(missing_docs)] // documentation missing in model
    AddDnssec,
    #[allow(missing_docs)] // documentation missing in model
    ChangeDomainOwner,
    #[allow(missing_docs)] // documentation missing in model
    ChangePrivacyProtection,
    #[allow(missing_docs)] // documentation missing in model
    DeleteDomain,
    #[allow(missing_docs)] // documentation missing in model
    DisableAutorenew,
    #[allow(missing_docs)] // documentation missing in model
    DomainLock,
    #[allow(missing_docs)] // documentation missing in model
    EnableAutorenew,
    #[allow(missing_docs)] // documentation missing in model
    ExpireDomain,
    #[allow(missing_docs)] // documentation missing in model
    InternalTransferInDomain,
    #[allow(missing_docs)] // documentation missing in model
    InternalTransferOutDomain,
    #[allow(missing_docs)] // documentation missing in model
    PushDomain,
    #[allow(missing_docs)] // documentation missing in model
    RegisterDomain,
    #[allow(missing_docs)] // documentation missing in model
    RemoveDnssec,
    #[allow(missing_docs)] // documentation missing in model
    RenewDomain,
    #[allow(missing_docs)] // documentation missing in model
    TransferInDomain,
    #[allow(missing_docs)] // documentation missing in model
    TransferOutDomain,
    #[allow(missing_docs)] // documentation missing in model
    UpdateDomainContact,
    #[allow(missing_docs)] // documentation missing in model
    UpdateNameserver,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OperationType {
    fn from(s: &str) -> Self {
        match s {
            "ADD_DNSSEC" => OperationType::AddDnssec,
            "CHANGE_DOMAIN_OWNER" => OperationType::ChangeDomainOwner,
            "CHANGE_PRIVACY_PROTECTION" => OperationType::ChangePrivacyProtection,
            "DELETE_DOMAIN" => OperationType::DeleteDomain,
            "DISABLE_AUTORENEW" => OperationType::DisableAutorenew,
            "DOMAIN_LOCK" => OperationType::DomainLock,
            "ENABLE_AUTORENEW" => OperationType::EnableAutorenew,
            "EXPIRE_DOMAIN" => OperationType::ExpireDomain,
            "INTERNAL_TRANSFER_IN_DOMAIN" => OperationType::InternalTransferInDomain,
            "INTERNAL_TRANSFER_OUT_DOMAIN" => OperationType::InternalTransferOutDomain,
            "PUSH_DOMAIN" => OperationType::PushDomain,
            "REGISTER_DOMAIN" => OperationType::RegisterDomain,
            "REMOVE_DNSSEC" => OperationType::RemoveDnssec,
            "RENEW_DOMAIN" => OperationType::RenewDomain,
            "TRANSFER_IN_DOMAIN" => OperationType::TransferInDomain,
            "TRANSFER_OUT_DOMAIN" => OperationType::TransferOutDomain,
            "UPDATE_DOMAIN_CONTACT" => OperationType::UpdateDomainContact,
            "UPDATE_NAMESERVER" => OperationType::UpdateNameserver,
            other => OperationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OperationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OperationType::from(s))
    }
}
impl OperationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OperationType::AddDnssec => "ADD_DNSSEC",
            OperationType::ChangeDomainOwner => "CHANGE_DOMAIN_OWNER",
            OperationType::ChangePrivacyProtection => "CHANGE_PRIVACY_PROTECTION",
            OperationType::DeleteDomain => "DELETE_DOMAIN",
            OperationType::DisableAutorenew => "DISABLE_AUTORENEW",
            OperationType::DomainLock => "DOMAIN_LOCK",
            OperationType::EnableAutorenew => "ENABLE_AUTORENEW",
            OperationType::ExpireDomain => "EXPIRE_DOMAIN",
            OperationType::InternalTransferInDomain => "INTERNAL_TRANSFER_IN_DOMAIN",
            OperationType::InternalTransferOutDomain => "INTERNAL_TRANSFER_OUT_DOMAIN",
            OperationType::PushDomain => "PUSH_DOMAIN",
            OperationType::RegisterDomain => "REGISTER_DOMAIN",
            OperationType::RemoveDnssec => "REMOVE_DNSSEC",
            OperationType::RenewDomain => "RENEW_DOMAIN",
            OperationType::TransferInDomain => "TRANSFER_IN_DOMAIN",
            OperationType::TransferOutDomain => "TRANSFER_OUT_DOMAIN",
            OperationType::UpdateDomainContact => "UPDATE_DOMAIN_CONTACT",
            OperationType::UpdateNameserver => "UPDATE_NAMESERVER",
            OperationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ADD_DNSSEC",
            "CHANGE_DOMAIN_OWNER",
            "CHANGE_PRIVACY_PROTECTION",
            "DELETE_DOMAIN",
            "DISABLE_AUTORENEW",
            "DOMAIN_LOCK",
            "ENABLE_AUTORENEW",
            "EXPIRE_DOMAIN",
            "INTERNAL_TRANSFER_IN_DOMAIN",
            "INTERNAL_TRANSFER_OUT_DOMAIN",
            "PUSH_DOMAIN",
            "REGISTER_DOMAIN",
            "REMOVE_DNSSEC",
            "RENEW_DOMAIN",
            "TRANSFER_IN_DOMAIN",
            "TRANSFER_OUT_DOMAIN",
            "UPDATE_DOMAIN_CONTACT",
            "UPDATE_NAMESERVER",
        ]
    }
}
impl AsRef<str> for OperationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Each tag includes the following elements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The key (name) of a tag.</p>
    /// <p>Valid values: A-Z, a-z, 0-9, space, ".:/=+\-@"</p>
    /// <p>Constraints: Each key can be 1-128 characters long.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value of a tag.</p>
    /// <p>Valid values: A-Z, a-z, 0-9, space, ".:/=+\-@"</p>
    /// <p>Constraints: Each value can be 0-256 characters long.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The key (name) of a tag.</p>
    /// <p>Valid values: A-Z, a-z, 0-9, space, ".:/=+\-@"</p>
    /// <p>Constraints: Each key can be 1-128 characters long.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The value of a tag.</p>
    /// <p>Valid values: A-Z, a-z, 0-9, space, ".:/=+\-@"</p>
    /// <p>Constraints: Each value can be 0-256 characters long.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key (name) of a tag.</p>
        /// <p>Valid values: A-Z, a-z, 0-9, space, ".:/=+\-@"</p>
        /// <p>Constraints: Each key can be 1-128 characters long.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key (name) of a tag.</p>
        /// <p>Valid values: A-Z, a-z, 0-9, space, ".:/=+\-@"</p>
        /// <p>Constraints: Each key can be 1-128 characters long.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value of a tag.</p>
        /// <p>Valid values: A-Z, a-z, 0-9, space, ".:/=+\-@"</p>
        /// <p>Constraints: Each value can be 0-256 characters long.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of a tag.</p>
        /// <p>Valid values: A-Z, a-z, 0-9, space, ".:/=+\-@"</p>
        /// <p>Constraints: Each value can be 0-256 characters long.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>Nameserver includes the following elements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Nameserver {
    /// <p>The fully qualified host name of the name server.</p>
    /// <p>Constraint: Maximum 255 characters</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Glue IP address of a name server entry. Glue IP addresses are required only when the name of the name server
    /// is a subdomain of the domain. For example, if your domain is example.com and the name server for the domain is
    /// ns.example.com, you need to specify the IP address for ns.example.com.</p>
    /// <p>Constraints: The list can contain only one IPv4 and one IPv6 address.</p>
    pub glue_ips: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl Nameserver {
    /// <p>The fully qualified host name of the name server.</p>
    /// <p>Constraint: Maximum 255 characters</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Glue IP address of a name server entry. Glue IP addresses are required only when the name of the name server
    /// is a subdomain of the domain. For example, if your domain is example.com and the name server for the domain is
    /// ns.example.com, you need to specify the IP address for ns.example.com.</p>
    /// <p>Constraints: The list can contain only one IPv4 and one IPv6 address.</p>
    pub fn glue_ips(&self) -> std::option::Option<&[std::string::String]> {
        self.glue_ips.as_deref()
    }
}
impl std::fmt::Debug for Nameserver {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Nameserver");
        formatter.field("name", &self.name);
        formatter.field("glue_ips", &self.glue_ips);
        formatter.finish()
    }
}
/// See [`Nameserver`](crate::model::Nameserver)
pub mod nameserver {
    /// A builder for [`Nameserver`](crate::model::Nameserver)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) glue_ips: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The fully qualified host name of the name server.</p>
        /// <p>Constraint: Maximum 255 characters</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The fully qualified host name of the name server.</p>
        /// <p>Constraint: Maximum 255 characters</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `glue_ips`.
        ///
        /// To override the contents of this collection use [`set_glue_ips`](Self::set_glue_ips).
        ///
        /// <p>Glue IP address of a name server entry. Glue IP addresses are required only when the name of the name server
        /// is a subdomain of the domain. For example, if your domain is example.com and the name server for the domain is
        /// ns.example.com, you need to specify the IP address for ns.example.com.</p>
        /// <p>Constraints: The list can contain only one IPv4 and one IPv6 address.</p>
        pub fn glue_ips(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.glue_ips.unwrap_or_default();
            v.push(input.into());
            self.glue_ips = Some(v);
            self
        }
        /// <p>Glue IP address of a name server entry. Glue IP addresses are required only when the name of the name server
        /// is a subdomain of the domain. For example, if your domain is example.com and the name server for the domain is
        /// ns.example.com, you need to specify the IP address for ns.example.com.</p>
        /// <p>Constraints: The list can contain only one IPv4 and one IPv6 address.</p>
        pub fn set_glue_ips(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.glue_ips = input;
            self
        }
        /// Consumes the builder and constructs a [`Nameserver`](crate::model::Nameserver)
        pub fn build(self) -> crate::model::Nameserver {
            crate::model::Nameserver {
                name: self.name,
                glue_ips: self.glue_ips,
            }
        }
    }
}
impl Nameserver {
    /// Creates a new builder-style object to manufacture [`Nameserver`](crate::model::Nameserver)
    pub fn builder() -> crate::model::nameserver::Builder {
        crate::model::nameserver::Builder::default()
    }
}

/// <p>ContactDetail includes the following elements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContactDetail {
    /// <p>First name of contact.</p>
    pub first_name: std::option::Option<std::string::String>,
    /// <p>Last name of contact.</p>
    pub last_name: std::option::Option<std::string::String>,
    /// <p>Indicates whether the contact is a person, company, association, or public organization. Note the following:</p>
    /// <ul>
    /// <li>
    /// <p>If you specify a value other than <code>PERSON</code>, you must also specify a value for
    /// <code>OrganizationName</code>.</p>
    /// </li>
    /// <li>
    /// <p>For some TLDs, the privacy protection available depends on the value that you specify for
    /// <code>Contact Type</code>. For the privacy protection settings for your TLD, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can
    /// Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>
    /// </p>
    /// </li>
    /// <li>
    /// <p>For .es domains, if you specify <code>PERSON</code>, you must specify <code>INDIVIDUAL</code>
    /// for the value of <code>ES_LEGAL_FORM</code>.</p>
    /// </li>
    /// </ul>
    pub contact_type: std::option::Option<crate::model::ContactType>,
    /// <p>Name of the organization for contact types other than <code>PERSON</code>.</p>
    pub organization_name: std::option::Option<std::string::String>,
    /// <p>First line of the contact's address.</p>
    pub address_line1: std::option::Option<std::string::String>,
    /// <p>Second line of contact's address, if any.</p>
    pub address_line2: std::option::Option<std::string::String>,
    /// <p>The city of the contact's address.</p>
    pub city: std::option::Option<std::string::String>,
    /// <p>The state or province of the contact's city.</p>
    pub state: std::option::Option<std::string::String>,
    /// <p>Code for the country of the contact's address.</p>
    pub country_code: std::option::Option<crate::model::CountryCode>,
    /// <p>The zip or postal code of the contact's address.</p>
    pub zip_code: std::option::Option<std::string::String>,
    /// <p>The phone number of the contact.</p>
    /// <p>Constraints: Phone number must be specified in the format "+[country  dialing code].[number including any area code>]".
    /// For example, a US phone number might appear as <code>"+1.1234567890"</code>.</p>
    pub phone_number: std::option::Option<std::string::String>,
    /// <p>Email address of the contact.</p>
    pub email: std::option::Option<std::string::String>,
    /// <p>Fax number of the contact.</p>
    /// <p>Constraints: Phone number must be specified in the format "+[country dialing code].[number including any area code]".
    /// For example, a US phone number might appear as <code>"+1.1234567890"</code>.</p>
    pub fax: std::option::Option<std::string::String>,
    /// <p>A list of name-value pairs for parameters required by certain top-level domains.</p>
    pub extra_params: std::option::Option<std::vec::Vec<crate::model::ExtraParam>>,
}
impl ContactDetail {
    /// <p>First name of contact.</p>
    pub fn first_name(&self) -> std::option::Option<&str> {
        self.first_name.as_deref()
    }
    /// <p>Last name of contact.</p>
    pub fn last_name(&self) -> std::option::Option<&str> {
        self.last_name.as_deref()
    }
    /// <p>Indicates whether the contact is a person, company, association, or public organization. Note the following:</p>
    /// <ul>
    /// <li>
    /// <p>If you specify a value other than <code>PERSON</code>, you must also specify a value for
    /// <code>OrganizationName</code>.</p>
    /// </li>
    /// <li>
    /// <p>For some TLDs, the privacy protection available depends on the value that you specify for
    /// <code>Contact Type</code>. For the privacy protection settings for your TLD, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can
    /// Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>
    /// </p>
    /// </li>
    /// <li>
    /// <p>For .es domains, if you specify <code>PERSON</code>, you must specify <code>INDIVIDUAL</code>
    /// for the value of <code>ES_LEGAL_FORM</code>.</p>
    /// </li>
    /// </ul>
    pub fn contact_type(&self) -> std::option::Option<&crate::model::ContactType> {
        self.contact_type.as_ref()
    }
    /// <p>Name of the organization for contact types other than <code>PERSON</code>.</p>
    pub fn organization_name(&self) -> std::option::Option<&str> {
        self.organization_name.as_deref()
    }
    /// <p>First line of the contact's address.</p>
    pub fn address_line1(&self) -> std::option::Option<&str> {
        self.address_line1.as_deref()
    }
    /// <p>Second line of contact's address, if any.</p>
    pub fn address_line2(&self) -> std::option::Option<&str> {
        self.address_line2.as_deref()
    }
    /// <p>The city of the contact's address.</p>
    pub fn city(&self) -> std::option::Option<&str> {
        self.city.as_deref()
    }
    /// <p>The state or province of the contact's city.</p>
    pub fn state(&self) -> std::option::Option<&str> {
        self.state.as_deref()
    }
    /// <p>Code for the country of the contact's address.</p>
    pub fn country_code(&self) -> std::option::Option<&crate::model::CountryCode> {
        self.country_code.as_ref()
    }
    /// <p>The zip or postal code of the contact's address.</p>
    pub fn zip_code(&self) -> std::option::Option<&str> {
        self.zip_code.as_deref()
    }
    /// <p>The phone number of the contact.</p>
    /// <p>Constraints: Phone number must be specified in the format "+[country  dialing code].[number including any area code>]".
    /// For example, a US phone number might appear as <code>"+1.1234567890"</code>.</p>
    pub fn phone_number(&self) -> std::option::Option<&str> {
        self.phone_number.as_deref()
    }
    /// <p>Email address of the contact.</p>
    pub fn email(&self) -> std::option::Option<&str> {
        self.email.as_deref()
    }
    /// <p>Fax number of the contact.</p>
    /// <p>Constraints: Phone number must be specified in the format "+[country dialing code].[number including any area code]".
    /// For example, a US phone number might appear as <code>"+1.1234567890"</code>.</p>
    pub fn fax(&self) -> std::option::Option<&str> {
        self.fax.as_deref()
    }
    /// <p>A list of name-value pairs for parameters required by certain top-level domains.</p>
    pub fn extra_params(&self) -> std::option::Option<&[crate::model::ExtraParam]> {
        self.extra_params.as_deref()
    }
}
impl std::fmt::Debug for ContactDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContactDetail");
        formatter.field("first_name", &self.first_name);
        formatter.field("last_name", &self.last_name);
        formatter.field("contact_type", &self.contact_type);
        formatter.field("organization_name", &self.organization_name);
        formatter.field("address_line1", &self.address_line1);
        formatter.field("address_line2", &self.address_line2);
        formatter.field("city", &self.city);
        formatter.field("state", &self.state);
        formatter.field("country_code", &self.country_code);
        formatter.field("zip_code", &self.zip_code);
        formatter.field("phone_number", &self.phone_number);
        formatter.field("email", &self.email);
        formatter.field("fax", &self.fax);
        formatter.field("extra_params", &self.extra_params);
        formatter.finish()
    }
}
/// See [`ContactDetail`](crate::model::ContactDetail)
pub mod contact_detail {
    /// A builder for [`ContactDetail`](crate::model::ContactDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) first_name: std::option::Option<std::string::String>,
        pub(crate) last_name: std::option::Option<std::string::String>,
        pub(crate) contact_type: std::option::Option<crate::model::ContactType>,
        pub(crate) organization_name: std::option::Option<std::string::String>,
        pub(crate) address_line1: std::option::Option<std::string::String>,
        pub(crate) address_line2: std::option::Option<std::string::String>,
        pub(crate) city: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<std::string::String>,
        pub(crate) country_code: std::option::Option<crate::model::CountryCode>,
        pub(crate) zip_code: std::option::Option<std::string::String>,
        pub(crate) phone_number: std::option::Option<std::string::String>,
        pub(crate) email: std::option::Option<std::string::String>,
        pub(crate) fax: std::option::Option<std::string::String>,
        pub(crate) extra_params: std::option::Option<std::vec::Vec<crate::model::ExtraParam>>,
    }
    impl Builder {
        /// <p>First name of contact.</p>
        pub fn first_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.first_name = Some(input.into());
            self
        }
        /// <p>First name of contact.</p>
        pub fn set_first_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.first_name = input;
            self
        }
        /// <p>Last name of contact.</p>
        pub fn last_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_name = Some(input.into());
            self
        }
        /// <p>Last name of contact.</p>
        pub fn set_last_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.last_name = input;
            self
        }
        /// <p>Indicates whether the contact is a person, company, association, or public organization. Note the following:</p>
        /// <ul>
        /// <li>
        /// <p>If you specify a value other than <code>PERSON</code>, you must also specify a value for
        /// <code>OrganizationName</code>.</p>
        /// </li>
        /// <li>
        /// <p>For some TLDs, the privacy protection available depends on the value that you specify for
        /// <code>Contact Type</code>. For the privacy protection settings for your TLD, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can
        /// Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>
        /// </p>
        /// </li>
        /// <li>
        /// <p>For .es domains, if you specify <code>PERSON</code>, you must specify <code>INDIVIDUAL</code>
        /// for the value of <code>ES_LEGAL_FORM</code>.</p>
        /// </li>
        /// </ul>
        pub fn contact_type(mut self, input: crate::model::ContactType) -> Self {
            self.contact_type = Some(input);
            self
        }
        /// <p>Indicates whether the contact is a person, company, association, or public organization. Note the following:</p>
        /// <ul>
        /// <li>
        /// <p>If you specify a value other than <code>PERSON</code>, you must also specify a value for
        /// <code>OrganizationName</code>.</p>
        /// </li>
        /// <li>
        /// <p>For some TLDs, the privacy protection available depends on the value that you specify for
        /// <code>Contact Type</code>. For the privacy protection settings for your TLD, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can
        /// Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>
        /// </p>
        /// </li>
        /// <li>
        /// <p>For .es domains, if you specify <code>PERSON</code>, you must specify <code>INDIVIDUAL</code>
        /// for the value of <code>ES_LEGAL_FORM</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_contact_type(
            mut self,
            input: std::option::Option<crate::model::ContactType>,
        ) -> Self {
            self.contact_type = input;
            self
        }
        /// <p>Name of the organization for contact types other than <code>PERSON</code>.</p>
        pub fn organization_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_name = Some(input.into());
            self
        }
        /// <p>Name of the organization for contact types other than <code>PERSON</code>.</p>
        pub fn set_organization_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_name = input;
            self
        }
        /// <p>First line of the contact's address.</p>
        pub fn address_line1(mut self, input: impl Into<std::string::String>) -> Self {
            self.address_line1 = Some(input.into());
            self
        }
        /// <p>First line of the contact's address.</p>
        pub fn set_address_line1(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.address_line1 = input;
            self
        }
        /// <p>Second line of contact's address, if any.</p>
        pub fn address_line2(mut self, input: impl Into<std::string::String>) -> Self {
            self.address_line2 = Some(input.into());
            self
        }
        /// <p>Second line of contact's address, if any.</p>
        pub fn set_address_line2(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.address_line2 = input;
            self
        }
        /// <p>The city of the contact's address.</p>
        pub fn city(mut self, input: impl Into<std::string::String>) -> Self {
            self.city = Some(input.into());
            self
        }
        /// <p>The city of the contact's address.</p>
        pub fn set_city(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.city = input;
            self
        }
        /// <p>The state or province of the contact's city.</p>
        pub fn state(mut self, input: impl Into<std::string::String>) -> Self {
            self.state = Some(input.into());
            self
        }
        /// <p>The state or province of the contact's city.</p>
        pub fn set_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state = input;
            self
        }
        /// <p>Code for the country of the contact's address.</p>
        pub fn country_code(mut self, input: crate::model::CountryCode) -> Self {
            self.country_code = Some(input);
            self
        }
        /// <p>Code for the country of the contact's address.</p>
        pub fn set_country_code(
            mut self,
            input: std::option::Option<crate::model::CountryCode>,
        ) -> Self {
            self.country_code = input;
            self
        }
        /// <p>The zip or postal code of the contact's address.</p>
        pub fn zip_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.zip_code = Some(input.into());
            self
        }
        /// <p>The zip or postal code of the contact's address.</p>
        pub fn set_zip_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.zip_code = input;
            self
        }
        /// <p>The phone number of the contact.</p>
        /// <p>Constraints: Phone number must be specified in the format "+[country  dialing code].[number including any area code>]".
        /// For example, a US phone number might appear as <code>"+1.1234567890"</code>.</p>
        pub fn phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number = Some(input.into());
            self
        }
        /// <p>The phone number of the contact.</p>
        /// <p>Constraints: Phone number must be specified in the format "+[country  dialing code].[number including any area code>]".
        /// For example, a US phone number might appear as <code>"+1.1234567890"</code>.</p>
        pub fn set_phone_number(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.phone_number = input;
            self
        }
        /// <p>Email address of the contact.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.email = Some(input.into());
            self
        }
        /// <p>Email address of the contact.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.email = input;
            self
        }
        /// <p>Fax number of the contact.</p>
        /// <p>Constraints: Phone number must be specified in the format "+[country dialing code].[number including any area code]".
        /// For example, a US phone number might appear as <code>"+1.1234567890"</code>.</p>
        pub fn fax(mut self, input: impl Into<std::string::String>) -> Self {
            self.fax = Some(input.into());
            self
        }
        /// <p>Fax number of the contact.</p>
        /// <p>Constraints: Phone number must be specified in the format "+[country dialing code].[number including any area code]".
        /// For example, a US phone number might appear as <code>"+1.1234567890"</code>.</p>
        pub fn set_fax(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fax = input;
            self
        }
        /// Appends an item to `extra_params`.
        ///
        /// To override the contents of this collection use [`set_extra_params`](Self::set_extra_params).
        ///
        /// <p>A list of name-value pairs for parameters required by certain top-level domains.</p>
        pub fn extra_params(mut self, input: impl Into<crate::model::ExtraParam>) -> Self {
            let mut v = self.extra_params.unwrap_or_default();
            v.push(input.into());
            self.extra_params = Some(v);
            self
        }
        /// <p>A list of name-value pairs for parameters required by certain top-level domains.</p>
        pub fn set_extra_params(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExtraParam>>,
        ) -> Self {
            self.extra_params = input;
            self
        }
        /// Consumes the builder and constructs a [`ContactDetail`](crate::model::ContactDetail)
        pub fn build(self) -> crate::model::ContactDetail {
            crate::model::ContactDetail {
                first_name: self.first_name,
                last_name: self.last_name,
                contact_type: self.contact_type,
                organization_name: self.organization_name,
                address_line1: self.address_line1,
                address_line2: self.address_line2,
                city: self.city,
                state: self.state,
                country_code: self.country_code,
                zip_code: self.zip_code,
                phone_number: self.phone_number,
                email: self.email,
                fax: self.fax,
                extra_params: self.extra_params,
            }
        }
    }
}
impl ContactDetail {
    /// Creates a new builder-style object to manufacture [`ContactDetail`](crate::model::ContactDetail)
    pub fn builder() -> crate::model::contact_detail::Builder {
        crate::model::contact_detail::Builder::default()
    }
}

/// <p>ExtraParam includes the following elements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExtraParam {
    /// <p>The name of an additional parameter that is required by a top-level domain. Here are the top-level domains that require
    /// additional parameters and the names of the parameters that they require:</p>
    ///
    /// <dl>
    /// <dt>.com.au and .net.au</dt>
    /// <dd>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>AU_ID_NUMBER</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AU_ID_TYPE</code>
    /// </p>
    /// <p>Valid values include the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ABN</code> (Australian business number)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ACN</code> (Australian company number)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TM</code> (Trademark number)</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    /// </dd>
    /// <dt>.ca</dt>
    /// <dd>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>BRAND_NUMBER</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CA_BUSINESS_ENTITY_TYPE</code>
    /// </p>
    /// <p>Valid values include the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>BANK</code> (Bank)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COMMERCIAL_COMPANY</code> (Commercial company)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COMPANY</code> (Company)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COOPERATION</code> (Cooperation)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COOPERATIVE</code> (Cooperative)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COOPRIX</code> (Cooprix)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CORP</code> (Corporation)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREDIT_UNION</code> (Credit union)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FOMIA</code> (Federation of mutual insurance associations)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INC</code> (Incorporated)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LTD</code> (Limited)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LTEE</code> (Limitée)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LLC</code> (Limited liability corporation)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LLP</code> (Limited liability partnership)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LTE</code> (Lte.)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MBA</code> (Mutual benefit association)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MIC</code> (Mutual insurance company)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NFP</code> (Not-for-profit corporation)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SA</code> (S.A.)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SAVINGS_COMPANY</code> (Savings company)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SAVINGS_UNION</code> (Savings union)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SARL</code> (Société à responsabilité limitée)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TRUST</code> (Trust)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ULC</code> (Unlimited liability corporation)</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CA_LEGAL_TYPE</code>
    /// </p>
    /// <p>When <code>ContactType</code> is <code>PERSON</code>, valid values include the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ABO</code> (Aboriginal Peoples indigenous to Canada)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CCT</code> (Canadian citizen)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LGR</code> (Legal Representative of a Canadian Citizen or Permanent Resident)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RES</code> (Permanent resident of Canada)</p>
    /// </li>
    /// </ul>
    ///
    /// <p>When <code>ContactType</code> is a value other than <code>PERSON</code>, valid values include the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ASS</code> (Canadian unincorporated association)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CCO</code> (Canadian corporation)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EDU</code> (Canadian educational institution)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GOV</code> (Government or government entity in Canada)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>HOP</code> (Canadian Hospital)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INB</code> (Indian Band recognized by the Indian Act of Canada)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LAM</code> (Canadian Library, Archive, or Museum)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MAJ</code> (Her/His Majesty the Queen/King)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>OMK</code> (Official mark registered in Canada)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PLT</code> (Canadian Political Party)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PRT</code> (Partnership Registered in Canada)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TDM</code> (Trademark registered in Canada)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TRD</code> (Canadian Trade Union)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TRS</code> (Trust established in Canada)</p>
    /// </li>
    /// </ul>
    ///
    /// </li>
    /// </ul>
    /// </dd>
    /// <dt>.es</dt>
    /// <dd>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ES_IDENTIFICATION</code>
    /// </p>
    /// <p>Specify the applicable value:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>For contacts inside Spain:</b> Enter your passport ID.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>For contacts outside of Spain:</b> Enter the VAT identification number
    /// for the company.</p>
    /// <note>
    /// <p>For .es domains, the value of <code>ContactType</code> must be <code>PERSON</code>.</p>
    /// </note>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ES_IDENTIFICATION_TYPE</code>
    /// </p>
    /// <p>Valid values include the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>DNI_AND_NIF</code> (For Spanish contacts)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NIE</code> (For foreigners with legal residence)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>OTHER</code> (For contacts outside of Spain)</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ES_LEGAL_FORM</code>
    /// </p>
    /// <p>Valid values include the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ASSOCIATION</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CENTRAL_GOVERNMENT_BODY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CIVIL_SOCIETY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COMMUNITY_OF_OWNERS</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COMMUNITY_PROPERTY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CONSULATE</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COOPERATIVE</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DESIGNATION_OF_ORIGIN_SUPERVISORY_COUNCIL</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ECONOMIC_INTEREST_GROUP</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EMBASSY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ENTITY_MANAGING_NATURAL_AREAS</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FARM_PARTNERSHIP</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FOUNDATION</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GENERAL_AND_LIMITED_PARTNERSHIP</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GENERAL_PARTNERSHIP</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INDIVIDUAL</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LIMITED_COMPANY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LOCAL_AUTHORITY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LOCAL_PUBLIC_ENTITY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MUTUAL_INSURANCE_COMPANY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NATIONAL_PUBLIC_ENTITY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ORDER_OR_RELIGIOUS_INSTITUTION</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>OTHERS (Only for contacts outside of Spain)</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>POLITICAL_PARTY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PROFESSIONAL_ASSOCIATION</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PUBLIC_LAW_ASSOCIATION</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PUBLIC_LIMITED_COMPANY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>REGIONAL_GOVERNMENT_BODY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>REGIONAL_PUBLIC_ENTITY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SAVINGS_BANK</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SPANISH_OFFICE</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SPORTS_ASSOCIATION</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SPORTS_FEDERATION</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SPORTS_LIMITED_COMPANY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TEMPORARY_ALLIANCE_OF_ENTERPRISES</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TRADE_UNION</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>WORKER_OWNED_COMPANY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>WORKER_OWNED_LIMITED_COMPANY</code>
    /// </p>
    /// </li>
    /// </ul>
    ///
    /// </li>
    /// </ul>
    /// </dd>
    /// <dt>.fi</dt>
    /// <dd>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>BIRTH_DATE_IN_YYYY_MM_DD</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FI_BUSINESS_NUMBER</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FI_ID_NUMBER</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FI_NATIONALITY</code>
    /// </p>
    /// <p>Valid values include the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>FINNISH</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NOT_FINNISH</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FI_ORGANIZATION_TYPE</code>
    /// </p>
    /// <p>Valid values include the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>COMPANY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CORPORATION</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GOVERNMENT</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INSTITUTION</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>POLITICAL_PARTY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PUBLIC_COMMUNITY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TOWNSHIP</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    /// </dd>
    /// <dt>.fr</dt>
    /// <dd>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>BIRTH_CITY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>BIRTH_COUNTRY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>BIRTH_DATE_IN_YYYY_MM_DD</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>BIRTH_DEPARTMENT</code>: Specify the INSEE code that corresponds with the department where the contact was born.
    /// If the contact was born somewhere other than France or its overseas departments, specify <code>99</code>. For more information,
    /// including a list of departments and the corresponding INSEE numbers, see the Wikipedia entry
    /// <a href="https://en.wikipedia.org/wiki/Departments_of_France">Departments of France</a>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>BRAND_NUMBER</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </dd>
    /// <dt>.it</dt>
    /// <dd>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>IT_NATIONALITY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IT_PIN</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IT_REGISTRANT_ENTITY_TYPE</code>
    /// </p>
    /// <p>Valid values include the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>FOREIGNERS</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FREELANCE_WORKERS</code> (Freelance workers and professionals)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ITALIAN_COMPANIES</code> (Italian companies and one-person companies)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NON_PROFIT_ORGANIZATIONS</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>OTHER_SUBJECTS</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PUBLIC_ORGANIZATIONS</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    /// </dd>
    /// <dt>.ru</dt>
    /// <dd>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>BIRTH_DATE_IN_YYYY_MM_DD</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RU_PASSPORT_DATA</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </dd>
    /// <dt>.se</dt>
    /// <dd>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>BIRTH_COUNTRY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SE_ID_NUMBER</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </dd>
    /// <dt>.sg</dt>
    /// <dd>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SG_ID_NUMBER</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </dd>
    /// <dt>.co.uk, .me.uk, and .org.uk</dt>
    /// <dd>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>UK_CONTACT_TYPE</code>
    /// </p>
    /// <p>Valid values include the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CRC</code> (UK Corporation by Royal Charter)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FCORP</code> (Non-UK Corporation)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FIND</code> (Non-UK Individual, representing self)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FOTHER</code> (Non-UK Entity that does not fit into any other category)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GOV</code> (UK Government Body)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IND</code> (UK Individual (representing self))</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IP</code> (UK Industrial/Provident Registered Company)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LLP</code> (UK Limited Liability Partnership)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LTD</code> (UK Limited Company)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>OTHER</code> (UK Entity that does not fit into any other category)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PLC</code> (UK Public Limited Company)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PTNR</code> (UK Partnership)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RCHAR</code> (UK Registered Charity)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SCH</code> (UK School)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>STAT</code> (UK Statutory Body)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>STRA</code> (UK Sole Trader)</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UK_COMPANY_NUMBER</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </dd>
    /// </dl>
    ///
    /// <p>In addition, many TLDs require a <code>VAT_NUMBER</code>.</p>
    pub name: std::option::Option<crate::model::ExtraParamName>,
    /// <p>The value that corresponds with the name of an extra parameter.</p>
    pub value: std::option::Option<std::string::String>,
}
impl ExtraParam {
    /// <p>The name of an additional parameter that is required by a top-level domain. Here are the top-level domains that require
    /// additional parameters and the names of the parameters that they require:</p>
    ///
    /// <dl>
    /// <dt>.com.au and .net.au</dt>
    /// <dd>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>AU_ID_NUMBER</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AU_ID_TYPE</code>
    /// </p>
    /// <p>Valid values include the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ABN</code> (Australian business number)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ACN</code> (Australian company number)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TM</code> (Trademark number)</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    /// </dd>
    /// <dt>.ca</dt>
    /// <dd>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>BRAND_NUMBER</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CA_BUSINESS_ENTITY_TYPE</code>
    /// </p>
    /// <p>Valid values include the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>BANK</code> (Bank)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COMMERCIAL_COMPANY</code> (Commercial company)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COMPANY</code> (Company)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COOPERATION</code> (Cooperation)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COOPERATIVE</code> (Cooperative)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COOPRIX</code> (Cooprix)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CORP</code> (Corporation)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREDIT_UNION</code> (Credit union)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FOMIA</code> (Federation of mutual insurance associations)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INC</code> (Incorporated)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LTD</code> (Limited)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LTEE</code> (Limitée)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LLC</code> (Limited liability corporation)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LLP</code> (Limited liability partnership)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LTE</code> (Lte.)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MBA</code> (Mutual benefit association)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MIC</code> (Mutual insurance company)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NFP</code> (Not-for-profit corporation)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SA</code> (S.A.)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SAVINGS_COMPANY</code> (Savings company)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SAVINGS_UNION</code> (Savings union)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SARL</code> (Société à responsabilité limitée)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TRUST</code> (Trust)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ULC</code> (Unlimited liability corporation)</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CA_LEGAL_TYPE</code>
    /// </p>
    /// <p>When <code>ContactType</code> is <code>PERSON</code>, valid values include the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ABO</code> (Aboriginal Peoples indigenous to Canada)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CCT</code> (Canadian citizen)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LGR</code> (Legal Representative of a Canadian Citizen or Permanent Resident)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RES</code> (Permanent resident of Canada)</p>
    /// </li>
    /// </ul>
    ///
    /// <p>When <code>ContactType</code> is a value other than <code>PERSON</code>, valid values include the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ASS</code> (Canadian unincorporated association)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CCO</code> (Canadian corporation)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EDU</code> (Canadian educational institution)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GOV</code> (Government or government entity in Canada)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>HOP</code> (Canadian Hospital)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INB</code> (Indian Band recognized by the Indian Act of Canada)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LAM</code> (Canadian Library, Archive, or Museum)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MAJ</code> (Her/His Majesty the Queen/King)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>OMK</code> (Official mark registered in Canada)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PLT</code> (Canadian Political Party)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PRT</code> (Partnership Registered in Canada)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TDM</code> (Trademark registered in Canada)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TRD</code> (Canadian Trade Union)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TRS</code> (Trust established in Canada)</p>
    /// </li>
    /// </ul>
    ///
    /// </li>
    /// </ul>
    /// </dd>
    /// <dt>.es</dt>
    /// <dd>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ES_IDENTIFICATION</code>
    /// </p>
    /// <p>Specify the applicable value:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>For contacts inside Spain:</b> Enter your passport ID.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>For contacts outside of Spain:</b> Enter the VAT identification number
    /// for the company.</p>
    /// <note>
    /// <p>For .es domains, the value of <code>ContactType</code> must be <code>PERSON</code>.</p>
    /// </note>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ES_IDENTIFICATION_TYPE</code>
    /// </p>
    /// <p>Valid values include the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>DNI_AND_NIF</code> (For Spanish contacts)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NIE</code> (For foreigners with legal residence)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>OTHER</code> (For contacts outside of Spain)</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ES_LEGAL_FORM</code>
    /// </p>
    /// <p>Valid values include the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ASSOCIATION</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CENTRAL_GOVERNMENT_BODY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CIVIL_SOCIETY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COMMUNITY_OF_OWNERS</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COMMUNITY_PROPERTY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CONSULATE</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COOPERATIVE</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DESIGNATION_OF_ORIGIN_SUPERVISORY_COUNCIL</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ECONOMIC_INTEREST_GROUP</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EMBASSY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ENTITY_MANAGING_NATURAL_AREAS</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FARM_PARTNERSHIP</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FOUNDATION</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GENERAL_AND_LIMITED_PARTNERSHIP</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GENERAL_PARTNERSHIP</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INDIVIDUAL</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LIMITED_COMPANY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LOCAL_AUTHORITY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LOCAL_PUBLIC_ENTITY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MUTUAL_INSURANCE_COMPANY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NATIONAL_PUBLIC_ENTITY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ORDER_OR_RELIGIOUS_INSTITUTION</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>OTHERS (Only for contacts outside of Spain)</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>POLITICAL_PARTY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PROFESSIONAL_ASSOCIATION</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PUBLIC_LAW_ASSOCIATION</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PUBLIC_LIMITED_COMPANY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>REGIONAL_GOVERNMENT_BODY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>REGIONAL_PUBLIC_ENTITY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SAVINGS_BANK</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SPANISH_OFFICE</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SPORTS_ASSOCIATION</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SPORTS_FEDERATION</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SPORTS_LIMITED_COMPANY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TEMPORARY_ALLIANCE_OF_ENTERPRISES</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TRADE_UNION</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>WORKER_OWNED_COMPANY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>WORKER_OWNED_LIMITED_COMPANY</code>
    /// </p>
    /// </li>
    /// </ul>
    ///
    /// </li>
    /// </ul>
    /// </dd>
    /// <dt>.fi</dt>
    /// <dd>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>BIRTH_DATE_IN_YYYY_MM_DD</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FI_BUSINESS_NUMBER</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FI_ID_NUMBER</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FI_NATIONALITY</code>
    /// </p>
    /// <p>Valid values include the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>FINNISH</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NOT_FINNISH</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FI_ORGANIZATION_TYPE</code>
    /// </p>
    /// <p>Valid values include the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>COMPANY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CORPORATION</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GOVERNMENT</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INSTITUTION</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>POLITICAL_PARTY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PUBLIC_COMMUNITY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TOWNSHIP</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    /// </dd>
    /// <dt>.fr</dt>
    /// <dd>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>BIRTH_CITY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>BIRTH_COUNTRY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>BIRTH_DATE_IN_YYYY_MM_DD</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>BIRTH_DEPARTMENT</code>: Specify the INSEE code that corresponds with the department where the contact was born.
    /// If the contact was born somewhere other than France or its overseas departments, specify <code>99</code>. For more information,
    /// including a list of departments and the corresponding INSEE numbers, see the Wikipedia entry
    /// <a href="https://en.wikipedia.org/wiki/Departments_of_France">Departments of France</a>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>BRAND_NUMBER</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </dd>
    /// <dt>.it</dt>
    /// <dd>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>IT_NATIONALITY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IT_PIN</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IT_REGISTRANT_ENTITY_TYPE</code>
    /// </p>
    /// <p>Valid values include the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>FOREIGNERS</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FREELANCE_WORKERS</code> (Freelance workers and professionals)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ITALIAN_COMPANIES</code> (Italian companies and one-person companies)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NON_PROFIT_ORGANIZATIONS</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>OTHER_SUBJECTS</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PUBLIC_ORGANIZATIONS</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    /// </dd>
    /// <dt>.ru</dt>
    /// <dd>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>BIRTH_DATE_IN_YYYY_MM_DD</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RU_PASSPORT_DATA</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </dd>
    /// <dt>.se</dt>
    /// <dd>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>BIRTH_COUNTRY</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SE_ID_NUMBER</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </dd>
    /// <dt>.sg</dt>
    /// <dd>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SG_ID_NUMBER</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </dd>
    /// <dt>.co.uk, .me.uk, and .org.uk</dt>
    /// <dd>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>UK_CONTACT_TYPE</code>
    /// </p>
    /// <p>Valid values include the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CRC</code> (UK Corporation by Royal Charter)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FCORP</code> (Non-UK Corporation)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FIND</code> (Non-UK Individual, representing self)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FOTHER</code> (Non-UK Entity that does not fit into any other category)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GOV</code> (UK Government Body)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IND</code> (UK Individual (representing self))</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IP</code> (UK Industrial/Provident Registered Company)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LLP</code> (UK Limited Liability Partnership)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LTD</code> (UK Limited Company)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>OTHER</code> (UK Entity that does not fit into any other category)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PLC</code> (UK Public Limited Company)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PTNR</code> (UK Partnership)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RCHAR</code> (UK Registered Charity)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SCH</code> (UK School)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>STAT</code> (UK Statutory Body)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>STRA</code> (UK Sole Trader)</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UK_COMPANY_NUMBER</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </dd>
    /// </dl>
    ///
    /// <p>In addition, many TLDs require a <code>VAT_NUMBER</code>.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::ExtraParamName> {
        self.name.as_ref()
    }
    /// <p>The value that corresponds with the name of an extra parameter.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for ExtraParam {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExtraParam");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`ExtraParam`](crate::model::ExtraParam)
pub mod extra_param {
    /// A builder for [`ExtraParam`](crate::model::ExtraParam)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::ExtraParamName>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of an additional parameter that is required by a top-level domain. Here are the top-level domains that require
        /// additional parameters and the names of the parameters that they require:</p>
        ///
        /// <dl>
        /// <dt>.com.au and .net.au</dt>
        /// <dd>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AU_ID_NUMBER</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AU_ID_TYPE</code>
        /// </p>
        /// <p>Valid values include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ABN</code> (Australian business number)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACN</code> (Australian company number)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TM</code> (Trademark number)</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        /// </dd>
        /// <dt>.ca</dt>
        /// <dd>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>BRAND_NUMBER</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CA_BUSINESS_ENTITY_TYPE</code>
        /// </p>
        /// <p>Valid values include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>BANK</code> (Bank)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COMMERCIAL_COMPANY</code> (Commercial company)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COMPANY</code> (Company)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COOPERATION</code> (Cooperation)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COOPERATIVE</code> (Cooperative)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COOPRIX</code> (Cooprix)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CORP</code> (Corporation)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREDIT_UNION</code> (Credit union)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FOMIA</code> (Federation of mutual insurance associations)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INC</code> (Incorporated)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LTD</code> (Limited)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LTEE</code> (Limitée)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LLC</code> (Limited liability corporation)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LLP</code> (Limited liability partnership)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LTE</code> (Lte.)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MBA</code> (Mutual benefit association)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MIC</code> (Mutual insurance company)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NFP</code> (Not-for-profit corporation)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SA</code> (S.A.)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SAVINGS_COMPANY</code> (Savings company)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SAVINGS_UNION</code> (Savings union)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SARL</code> (Société à responsabilité limitée)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TRUST</code> (Trust)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ULC</code> (Unlimited liability corporation)</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CA_LEGAL_TYPE</code>
        /// </p>
        /// <p>When <code>ContactType</code> is <code>PERSON</code>, valid values include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ABO</code> (Aboriginal Peoples indigenous to Canada)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CCT</code> (Canadian citizen)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LGR</code> (Legal Representative of a Canadian Citizen or Permanent Resident)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RES</code> (Permanent resident of Canada)</p>
        /// </li>
        /// </ul>
        ///
        /// <p>When <code>ContactType</code> is a value other than <code>PERSON</code>, valid values include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ASS</code> (Canadian unincorporated association)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CCO</code> (Canadian corporation)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EDU</code> (Canadian educational institution)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GOV</code> (Government or government entity in Canada)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>HOP</code> (Canadian Hospital)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INB</code> (Indian Band recognized by the Indian Act of Canada)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LAM</code> (Canadian Library, Archive, or Museum)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MAJ</code> (Her/His Majesty the Queen/King)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OMK</code> (Official mark registered in Canada)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PLT</code> (Canadian Political Party)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PRT</code> (Partnership Registered in Canada)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TDM</code> (Trademark registered in Canada)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TRD</code> (Canadian Trade Union)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TRS</code> (Trust established in Canada)</p>
        /// </li>
        /// </ul>
        ///
        /// </li>
        /// </ul>
        /// </dd>
        /// <dt>.es</dt>
        /// <dd>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ES_IDENTIFICATION</code>
        /// </p>
        /// <p>Specify the applicable value:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>For contacts inside Spain:</b> Enter your passport ID.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>For contacts outside of Spain:</b> Enter the VAT identification number
        /// for the company.</p>
        /// <note>
        /// <p>For .es domains, the value of <code>ContactType</code> must be <code>PERSON</code>.</p>
        /// </note>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ES_IDENTIFICATION_TYPE</code>
        /// </p>
        /// <p>Valid values include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DNI_AND_NIF</code> (For Spanish contacts)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NIE</code> (For foreigners with legal residence)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OTHER</code> (For contacts outside of Spain)</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ES_LEGAL_FORM</code>
        /// </p>
        /// <p>Valid values include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ASSOCIATION</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CENTRAL_GOVERNMENT_BODY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CIVIL_SOCIETY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COMMUNITY_OF_OWNERS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COMMUNITY_PROPERTY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CONSULATE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COOPERATIVE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DESIGNATION_OF_ORIGIN_SUPERVISORY_COUNCIL</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ECONOMIC_INTEREST_GROUP</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EMBASSY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ENTITY_MANAGING_NATURAL_AREAS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FARM_PARTNERSHIP</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FOUNDATION</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GENERAL_AND_LIMITED_PARTNERSHIP</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GENERAL_PARTNERSHIP</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INDIVIDUAL</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LIMITED_COMPANY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LOCAL_AUTHORITY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LOCAL_PUBLIC_ENTITY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MUTUAL_INSURANCE_COMPANY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NATIONAL_PUBLIC_ENTITY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ORDER_OR_RELIGIOUS_INSTITUTION</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OTHERS (Only for contacts outside of Spain)</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>POLITICAL_PARTY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PROFESSIONAL_ASSOCIATION</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PUBLIC_LAW_ASSOCIATION</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PUBLIC_LIMITED_COMPANY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REGIONAL_GOVERNMENT_BODY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REGIONAL_PUBLIC_ENTITY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SAVINGS_BANK</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SPANISH_OFFICE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SPORTS_ASSOCIATION</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SPORTS_FEDERATION</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SPORTS_LIMITED_COMPANY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TEMPORARY_ALLIANCE_OF_ENTERPRISES</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TRADE_UNION</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>WORKER_OWNED_COMPANY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>WORKER_OWNED_LIMITED_COMPANY</code>
        /// </p>
        /// </li>
        /// </ul>
        ///
        /// </li>
        /// </ul>
        /// </dd>
        /// <dt>.fi</dt>
        /// <dd>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>BIRTH_DATE_IN_YYYY_MM_DD</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FI_BUSINESS_NUMBER</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FI_ID_NUMBER</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FI_NATIONALITY</code>
        /// </p>
        /// <p>Valid values include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>FINNISH</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NOT_FINNISH</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FI_ORGANIZATION_TYPE</code>
        /// </p>
        /// <p>Valid values include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>COMPANY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CORPORATION</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GOVERNMENT</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INSTITUTION</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>POLITICAL_PARTY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PUBLIC_COMMUNITY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOWNSHIP</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        /// </dd>
        /// <dt>.fr</dt>
        /// <dd>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>BIRTH_CITY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BIRTH_COUNTRY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BIRTH_DATE_IN_YYYY_MM_DD</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BIRTH_DEPARTMENT</code>: Specify the INSEE code that corresponds with the department where the contact was born.
        /// If the contact was born somewhere other than France or its overseas departments, specify <code>99</code>. For more information,
        /// including a list of departments and the corresponding INSEE numbers, see the Wikipedia entry
        /// <a href="https://en.wikipedia.org/wiki/Departments_of_France">Departments of France</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BRAND_NUMBER</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </dd>
        /// <dt>.it</dt>
        /// <dd>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>IT_NATIONALITY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IT_PIN</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IT_REGISTRANT_ENTITY_TYPE</code>
        /// </p>
        /// <p>Valid values include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>FOREIGNERS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FREELANCE_WORKERS</code> (Freelance workers and professionals)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ITALIAN_COMPANIES</code> (Italian companies and one-person companies)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NON_PROFIT_ORGANIZATIONS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OTHER_SUBJECTS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PUBLIC_ORGANIZATIONS</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        /// </dd>
        /// <dt>.ru</dt>
        /// <dd>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>BIRTH_DATE_IN_YYYY_MM_DD</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RU_PASSPORT_DATA</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </dd>
        /// <dt>.se</dt>
        /// <dd>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>BIRTH_COUNTRY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SE_ID_NUMBER</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </dd>
        /// <dt>.sg</dt>
        /// <dd>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SG_ID_NUMBER</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </dd>
        /// <dt>.co.uk, .me.uk, and .org.uk</dt>
        /// <dd>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>UK_CONTACT_TYPE</code>
        /// </p>
        /// <p>Valid values include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CRC</code> (UK Corporation by Royal Charter)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FCORP</code> (Non-UK Corporation)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FIND</code> (Non-UK Individual, representing self)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FOTHER</code> (Non-UK Entity that does not fit into any other category)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GOV</code> (UK Government Body)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IND</code> (UK Individual (representing self))</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IP</code> (UK Industrial/Provident Registered Company)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LLP</code> (UK Limited Liability Partnership)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LTD</code> (UK Limited Company)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OTHER</code> (UK Entity that does not fit into any other category)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PLC</code> (UK Public Limited Company)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PTNR</code> (UK Partnership)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RCHAR</code> (UK Registered Charity)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SCH</code> (UK School)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STAT</code> (UK Statutory Body)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STRA</code> (UK Sole Trader)</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UK_COMPANY_NUMBER</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </dd>
        /// </dl>
        ///
        /// <p>In addition, many TLDs require a <code>VAT_NUMBER</code>.</p>
        pub fn name(mut self, input: crate::model::ExtraParamName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of an additional parameter that is required by a top-level domain. Here are the top-level domains that require
        /// additional parameters and the names of the parameters that they require:</p>
        ///
        /// <dl>
        /// <dt>.com.au and .net.au</dt>
        /// <dd>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AU_ID_NUMBER</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AU_ID_TYPE</code>
        /// </p>
        /// <p>Valid values include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ABN</code> (Australian business number)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACN</code> (Australian company number)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TM</code> (Trademark number)</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        /// </dd>
        /// <dt>.ca</dt>
        /// <dd>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>BRAND_NUMBER</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CA_BUSINESS_ENTITY_TYPE</code>
        /// </p>
        /// <p>Valid values include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>BANK</code> (Bank)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COMMERCIAL_COMPANY</code> (Commercial company)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COMPANY</code> (Company)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COOPERATION</code> (Cooperation)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COOPERATIVE</code> (Cooperative)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COOPRIX</code> (Cooprix)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CORP</code> (Corporation)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREDIT_UNION</code> (Credit union)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FOMIA</code> (Federation of mutual insurance associations)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INC</code> (Incorporated)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LTD</code> (Limited)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LTEE</code> (Limitée)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LLC</code> (Limited liability corporation)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LLP</code> (Limited liability partnership)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LTE</code> (Lte.)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MBA</code> (Mutual benefit association)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MIC</code> (Mutual insurance company)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NFP</code> (Not-for-profit corporation)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SA</code> (S.A.)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SAVINGS_COMPANY</code> (Savings company)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SAVINGS_UNION</code> (Savings union)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SARL</code> (Société à responsabilité limitée)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TRUST</code> (Trust)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ULC</code> (Unlimited liability corporation)</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CA_LEGAL_TYPE</code>
        /// </p>
        /// <p>When <code>ContactType</code> is <code>PERSON</code>, valid values include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ABO</code> (Aboriginal Peoples indigenous to Canada)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CCT</code> (Canadian citizen)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LGR</code> (Legal Representative of a Canadian Citizen or Permanent Resident)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RES</code> (Permanent resident of Canada)</p>
        /// </li>
        /// </ul>
        ///
        /// <p>When <code>ContactType</code> is a value other than <code>PERSON</code>, valid values include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ASS</code> (Canadian unincorporated association)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CCO</code> (Canadian corporation)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EDU</code> (Canadian educational institution)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GOV</code> (Government or government entity in Canada)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>HOP</code> (Canadian Hospital)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INB</code> (Indian Band recognized by the Indian Act of Canada)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LAM</code> (Canadian Library, Archive, or Museum)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MAJ</code> (Her/His Majesty the Queen/King)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OMK</code> (Official mark registered in Canada)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PLT</code> (Canadian Political Party)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PRT</code> (Partnership Registered in Canada)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TDM</code> (Trademark registered in Canada)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TRD</code> (Canadian Trade Union)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TRS</code> (Trust established in Canada)</p>
        /// </li>
        /// </ul>
        ///
        /// </li>
        /// </ul>
        /// </dd>
        /// <dt>.es</dt>
        /// <dd>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ES_IDENTIFICATION</code>
        /// </p>
        /// <p>Specify the applicable value:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>For contacts inside Spain:</b> Enter your passport ID.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>For contacts outside of Spain:</b> Enter the VAT identification number
        /// for the company.</p>
        /// <note>
        /// <p>For .es domains, the value of <code>ContactType</code> must be <code>PERSON</code>.</p>
        /// </note>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ES_IDENTIFICATION_TYPE</code>
        /// </p>
        /// <p>Valid values include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DNI_AND_NIF</code> (For Spanish contacts)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NIE</code> (For foreigners with legal residence)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OTHER</code> (For contacts outside of Spain)</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ES_LEGAL_FORM</code>
        /// </p>
        /// <p>Valid values include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ASSOCIATION</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CENTRAL_GOVERNMENT_BODY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CIVIL_SOCIETY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COMMUNITY_OF_OWNERS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COMMUNITY_PROPERTY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CONSULATE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COOPERATIVE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DESIGNATION_OF_ORIGIN_SUPERVISORY_COUNCIL</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ECONOMIC_INTEREST_GROUP</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EMBASSY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ENTITY_MANAGING_NATURAL_AREAS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FARM_PARTNERSHIP</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FOUNDATION</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GENERAL_AND_LIMITED_PARTNERSHIP</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GENERAL_PARTNERSHIP</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INDIVIDUAL</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LIMITED_COMPANY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LOCAL_AUTHORITY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LOCAL_PUBLIC_ENTITY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MUTUAL_INSURANCE_COMPANY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NATIONAL_PUBLIC_ENTITY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ORDER_OR_RELIGIOUS_INSTITUTION</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OTHERS (Only for contacts outside of Spain)</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>POLITICAL_PARTY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PROFESSIONAL_ASSOCIATION</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PUBLIC_LAW_ASSOCIATION</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PUBLIC_LIMITED_COMPANY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REGIONAL_GOVERNMENT_BODY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REGIONAL_PUBLIC_ENTITY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SAVINGS_BANK</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SPANISH_OFFICE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SPORTS_ASSOCIATION</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SPORTS_FEDERATION</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SPORTS_LIMITED_COMPANY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TEMPORARY_ALLIANCE_OF_ENTERPRISES</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TRADE_UNION</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>WORKER_OWNED_COMPANY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>WORKER_OWNED_LIMITED_COMPANY</code>
        /// </p>
        /// </li>
        /// </ul>
        ///
        /// </li>
        /// </ul>
        /// </dd>
        /// <dt>.fi</dt>
        /// <dd>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>BIRTH_DATE_IN_YYYY_MM_DD</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FI_BUSINESS_NUMBER</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FI_ID_NUMBER</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FI_NATIONALITY</code>
        /// </p>
        /// <p>Valid values include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>FINNISH</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NOT_FINNISH</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FI_ORGANIZATION_TYPE</code>
        /// </p>
        /// <p>Valid values include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>COMPANY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CORPORATION</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GOVERNMENT</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INSTITUTION</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>POLITICAL_PARTY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PUBLIC_COMMUNITY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOWNSHIP</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        /// </dd>
        /// <dt>.fr</dt>
        /// <dd>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>BIRTH_CITY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BIRTH_COUNTRY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BIRTH_DATE_IN_YYYY_MM_DD</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BIRTH_DEPARTMENT</code>: Specify the INSEE code that corresponds with the department where the contact was born.
        /// If the contact was born somewhere other than France or its overseas departments, specify <code>99</code>. For more information,
        /// including a list of departments and the corresponding INSEE numbers, see the Wikipedia entry
        /// <a href="https://en.wikipedia.org/wiki/Departments_of_France">Departments of France</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BRAND_NUMBER</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </dd>
        /// <dt>.it</dt>
        /// <dd>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>IT_NATIONALITY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IT_PIN</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IT_REGISTRANT_ENTITY_TYPE</code>
        /// </p>
        /// <p>Valid values include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>FOREIGNERS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FREELANCE_WORKERS</code> (Freelance workers and professionals)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ITALIAN_COMPANIES</code> (Italian companies and one-person companies)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NON_PROFIT_ORGANIZATIONS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OTHER_SUBJECTS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PUBLIC_ORGANIZATIONS</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        /// </dd>
        /// <dt>.ru</dt>
        /// <dd>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>BIRTH_DATE_IN_YYYY_MM_DD</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RU_PASSPORT_DATA</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </dd>
        /// <dt>.se</dt>
        /// <dd>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>BIRTH_COUNTRY</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SE_ID_NUMBER</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </dd>
        /// <dt>.sg</dt>
        /// <dd>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SG_ID_NUMBER</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </dd>
        /// <dt>.co.uk, .me.uk, and .org.uk</dt>
        /// <dd>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>UK_CONTACT_TYPE</code>
        /// </p>
        /// <p>Valid values include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CRC</code> (UK Corporation by Royal Charter)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FCORP</code> (Non-UK Corporation)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FIND</code> (Non-UK Individual, representing self)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FOTHER</code> (Non-UK Entity that does not fit into any other category)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GOV</code> (UK Government Body)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IND</code> (UK Individual (representing self))</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IP</code> (UK Industrial/Provident Registered Company)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LLP</code> (UK Limited Liability Partnership)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LTD</code> (UK Limited Company)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OTHER</code> (UK Entity that does not fit into any other category)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PLC</code> (UK Public Limited Company)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PTNR</code> (UK Partnership)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RCHAR</code> (UK Registered Charity)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SCH</code> (UK School)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STAT</code> (UK Statutory Body)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STRA</code> (UK Sole Trader)</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UK_COMPANY_NUMBER</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </dd>
        /// </dl>
        ///
        /// <p>In addition, many TLDs require a <code>VAT_NUMBER</code>.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::ExtraParamName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// <p>The value that corresponds with the name of an extra parameter.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value that corresponds with the name of an extra parameter.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`ExtraParam`](crate::model::ExtraParam)
        pub fn build(self) -> crate::model::ExtraParam {
            crate::model::ExtraParam {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl ExtraParam {
    /// Creates a new builder-style object to manufacture [`ExtraParam`](crate::model::ExtraParam)
    pub fn builder() -> crate::model::extra_param::Builder {
        crate::model::extra_param::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExtraParamName {
    #[allow(missing_docs)] // documentation missing in model
    AuIdNumber,
    #[allow(missing_docs)] // documentation missing in model
    AuIdType,
    #[allow(missing_docs)] // documentation missing in model
    BirthCity,
    #[allow(missing_docs)] // documentation missing in model
    BirthCountry,
    #[allow(missing_docs)] // documentation missing in model
    BirthDateInYyyyMmDd,
    #[allow(missing_docs)] // documentation missing in model
    BirthDepartment,
    #[allow(missing_docs)] // documentation missing in model
    BrandNumber,
    #[allow(missing_docs)] // documentation missing in model
    CaBusinessEntityType,
    #[allow(missing_docs)] // documentation missing in model
    CaLegalRepresentative,
    #[allow(missing_docs)] // documentation missing in model
    CaLegalRepresentativeCapacity,
    #[allow(missing_docs)] // documentation missing in model
    CaLegalType,
    #[allow(missing_docs)] // documentation missing in model
    DocumentNumber,
    #[allow(missing_docs)] // documentation missing in model
    DunsNumber,
    #[allow(missing_docs)] // documentation missing in model
    EsIdentification,
    #[allow(missing_docs)] // documentation missing in model
    EsIdentificationType,
    #[allow(missing_docs)] // documentation missing in model
    EsLegalForm,
    #[allow(missing_docs)] // documentation missing in model
    FiBusinessNumber,
    #[allow(missing_docs)] // documentation missing in model
    OnwerFiIdNumber,
    #[allow(missing_docs)] // documentation missing in model
    FiNationality,
    #[allow(missing_docs)] // documentation missing in model
    FiOrganizationType,
    #[allow(missing_docs)] // documentation missing in model
    ItNationality,
    #[allow(missing_docs)] // documentation missing in model
    ItPin,
    #[allow(missing_docs)] // documentation missing in model
    ItRegistrantEntityType,
    #[allow(missing_docs)] // documentation missing in model
    RuPassportData,
    #[allow(missing_docs)] // documentation missing in model
    SeIdNumber,
    #[allow(missing_docs)] // documentation missing in model
    SgIdNumber,
    #[allow(missing_docs)] // documentation missing in model
    UkCompanyNumber,
    #[allow(missing_docs)] // documentation missing in model
    UkContactType,
    #[allow(missing_docs)] // documentation missing in model
    VatNumber,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExtraParamName {
    fn from(s: &str) -> Self {
        match s {
            "AU_ID_NUMBER" => ExtraParamName::AuIdNumber,
            "AU_ID_TYPE" => ExtraParamName::AuIdType,
            "BIRTH_CITY" => ExtraParamName::BirthCity,
            "BIRTH_COUNTRY" => ExtraParamName::BirthCountry,
            "BIRTH_DATE_IN_YYYY_MM_DD" => ExtraParamName::BirthDateInYyyyMmDd,
            "BIRTH_DEPARTMENT" => ExtraParamName::BirthDepartment,
            "BRAND_NUMBER" => ExtraParamName::BrandNumber,
            "CA_BUSINESS_ENTITY_TYPE" => ExtraParamName::CaBusinessEntityType,
            "CA_LEGAL_REPRESENTATIVE" => ExtraParamName::CaLegalRepresentative,
            "CA_LEGAL_REPRESENTATIVE_CAPACITY" => ExtraParamName::CaLegalRepresentativeCapacity,
            "CA_LEGAL_TYPE" => ExtraParamName::CaLegalType,
            "DOCUMENT_NUMBER" => ExtraParamName::DocumentNumber,
            "DUNS_NUMBER" => ExtraParamName::DunsNumber,
            "ES_IDENTIFICATION" => ExtraParamName::EsIdentification,
            "ES_IDENTIFICATION_TYPE" => ExtraParamName::EsIdentificationType,
            "ES_LEGAL_FORM" => ExtraParamName::EsLegalForm,
            "FI_BUSINESS_NUMBER" => ExtraParamName::FiBusinessNumber,
            "FI_ID_NUMBER" => ExtraParamName::OnwerFiIdNumber,
            "FI_NATIONALITY" => ExtraParamName::FiNationality,
            "FI_ORGANIZATION_TYPE" => ExtraParamName::FiOrganizationType,
            "IT_NATIONALITY" => ExtraParamName::ItNationality,
            "IT_PIN" => ExtraParamName::ItPin,
            "IT_REGISTRANT_ENTITY_TYPE" => ExtraParamName::ItRegistrantEntityType,
            "RU_PASSPORT_DATA" => ExtraParamName::RuPassportData,
            "SE_ID_NUMBER" => ExtraParamName::SeIdNumber,
            "SG_ID_NUMBER" => ExtraParamName::SgIdNumber,
            "UK_COMPANY_NUMBER" => ExtraParamName::UkCompanyNumber,
            "UK_CONTACT_TYPE" => ExtraParamName::UkContactType,
            "VAT_NUMBER" => ExtraParamName::VatNumber,
            other => ExtraParamName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExtraParamName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExtraParamName::from(s))
    }
}
impl ExtraParamName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExtraParamName::AuIdNumber => "AU_ID_NUMBER",
            ExtraParamName::AuIdType => "AU_ID_TYPE",
            ExtraParamName::BirthCity => "BIRTH_CITY",
            ExtraParamName::BirthCountry => "BIRTH_COUNTRY",
            ExtraParamName::BirthDateInYyyyMmDd => "BIRTH_DATE_IN_YYYY_MM_DD",
            ExtraParamName::BirthDepartment => "BIRTH_DEPARTMENT",
            ExtraParamName::BrandNumber => "BRAND_NUMBER",
            ExtraParamName::CaBusinessEntityType => "CA_BUSINESS_ENTITY_TYPE",
            ExtraParamName::CaLegalRepresentative => "CA_LEGAL_REPRESENTATIVE",
            ExtraParamName::CaLegalRepresentativeCapacity => "CA_LEGAL_REPRESENTATIVE_CAPACITY",
            ExtraParamName::CaLegalType => "CA_LEGAL_TYPE",
            ExtraParamName::DocumentNumber => "DOCUMENT_NUMBER",
            ExtraParamName::DunsNumber => "DUNS_NUMBER",
            ExtraParamName::EsIdentification => "ES_IDENTIFICATION",
            ExtraParamName::EsIdentificationType => "ES_IDENTIFICATION_TYPE",
            ExtraParamName::EsLegalForm => "ES_LEGAL_FORM",
            ExtraParamName::FiBusinessNumber => "FI_BUSINESS_NUMBER",
            ExtraParamName::OnwerFiIdNumber => "FI_ID_NUMBER",
            ExtraParamName::FiNationality => "FI_NATIONALITY",
            ExtraParamName::FiOrganizationType => "FI_ORGANIZATION_TYPE",
            ExtraParamName::ItNationality => "IT_NATIONALITY",
            ExtraParamName::ItPin => "IT_PIN",
            ExtraParamName::ItRegistrantEntityType => "IT_REGISTRANT_ENTITY_TYPE",
            ExtraParamName::RuPassportData => "RU_PASSPORT_DATA",
            ExtraParamName::SeIdNumber => "SE_ID_NUMBER",
            ExtraParamName::SgIdNumber => "SG_ID_NUMBER",
            ExtraParamName::UkCompanyNumber => "UK_COMPANY_NUMBER",
            ExtraParamName::UkContactType => "UK_CONTACT_TYPE",
            ExtraParamName::VatNumber => "VAT_NUMBER",
            ExtraParamName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AU_ID_NUMBER",
            "AU_ID_TYPE",
            "BIRTH_CITY",
            "BIRTH_COUNTRY",
            "BIRTH_DATE_IN_YYYY_MM_DD",
            "BIRTH_DEPARTMENT",
            "BRAND_NUMBER",
            "CA_BUSINESS_ENTITY_TYPE",
            "CA_LEGAL_REPRESENTATIVE",
            "CA_LEGAL_REPRESENTATIVE_CAPACITY",
            "CA_LEGAL_TYPE",
            "DOCUMENT_NUMBER",
            "DUNS_NUMBER",
            "ES_IDENTIFICATION",
            "ES_IDENTIFICATION_TYPE",
            "ES_LEGAL_FORM",
            "FI_BUSINESS_NUMBER",
            "FI_ID_NUMBER",
            "FI_NATIONALITY",
            "FI_ORGANIZATION_TYPE",
            "IT_NATIONALITY",
            "IT_PIN",
            "IT_REGISTRANT_ENTITY_TYPE",
            "RU_PASSPORT_DATA",
            "SE_ID_NUMBER",
            "SG_ID_NUMBER",
            "UK_COMPANY_NUMBER",
            "UK_CONTACT_TYPE",
            "VAT_NUMBER",
        ]
    }
}
impl AsRef<str> for ExtraParamName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CountryCode {
    #[allow(missing_docs)] // documentation missing in model
    Ad,
    #[allow(missing_docs)] // documentation missing in model
    Ae,
    #[allow(missing_docs)] // documentation missing in model
    Af,
    #[allow(missing_docs)] // documentation missing in model
    Ag,
    #[allow(missing_docs)] // documentation missing in model
    Ai,
    #[allow(missing_docs)] // documentation missing in model
    Al,
    #[allow(missing_docs)] // documentation missing in model
    Am,
    #[allow(missing_docs)] // documentation missing in model
    An,
    #[allow(missing_docs)] // documentation missing in model
    Ao,
    #[allow(missing_docs)] // documentation missing in model
    Aq,
    #[allow(missing_docs)] // documentation missing in model
    Ar,
    #[allow(missing_docs)] // documentation missing in model
    As,
    #[allow(missing_docs)] // documentation missing in model
    At,
    #[allow(missing_docs)] // documentation missing in model
    Au,
    #[allow(missing_docs)] // documentation missing in model
    Aw,
    #[allow(missing_docs)] // documentation missing in model
    Az,
    #[allow(missing_docs)] // documentation missing in model
    Ba,
    #[allow(missing_docs)] // documentation missing in model
    Bb,
    #[allow(missing_docs)] // documentation missing in model
    Bd,
    #[allow(missing_docs)] // documentation missing in model
    Be,
    #[allow(missing_docs)] // documentation missing in model
    Bf,
    #[allow(missing_docs)] // documentation missing in model
    Bg,
    #[allow(missing_docs)] // documentation missing in model
    Bh,
    #[allow(missing_docs)] // documentation missing in model
    Bi,
    #[allow(missing_docs)] // documentation missing in model
    Bj,
    #[allow(missing_docs)] // documentation missing in model
    Bl,
    #[allow(missing_docs)] // documentation missing in model
    Bm,
    #[allow(missing_docs)] // documentation missing in model
    Bn,
    #[allow(missing_docs)] // documentation missing in model
    Bo,
    #[allow(missing_docs)] // documentation missing in model
    Br,
    #[allow(missing_docs)] // documentation missing in model
    Bs,
    #[allow(missing_docs)] // documentation missing in model
    Bt,
    #[allow(missing_docs)] // documentation missing in model
    Bw,
    #[allow(missing_docs)] // documentation missing in model
    By,
    #[allow(missing_docs)] // documentation missing in model
    Bz,
    #[allow(missing_docs)] // documentation missing in model
    Ca,
    #[allow(missing_docs)] // documentation missing in model
    Cc,
    #[allow(missing_docs)] // documentation missing in model
    Cd,
    #[allow(missing_docs)] // documentation missing in model
    Cf,
    #[allow(missing_docs)] // documentation missing in model
    Cg,
    #[allow(missing_docs)] // documentation missing in model
    Ch,
    #[allow(missing_docs)] // documentation missing in model
    Ci,
    #[allow(missing_docs)] // documentation missing in model
    Ck,
    #[allow(missing_docs)] // documentation missing in model
    Cl,
    #[allow(missing_docs)] // documentation missing in model
    Cm,
    #[allow(missing_docs)] // documentation missing in model
    Cn,
    #[allow(missing_docs)] // documentation missing in model
    Co,
    #[allow(missing_docs)] // documentation missing in model
    Cr,
    #[allow(missing_docs)] // documentation missing in model
    Cu,
    #[allow(missing_docs)] // documentation missing in model
    Cv,
    #[allow(missing_docs)] // documentation missing in model
    Cx,
    #[allow(missing_docs)] // documentation missing in model
    Cy,
    #[allow(missing_docs)] // documentation missing in model
    Cz,
    #[allow(missing_docs)] // documentation missing in model
    De,
    #[allow(missing_docs)] // documentation missing in model
    Dj,
    #[allow(missing_docs)] // documentation missing in model
    Dk,
    #[allow(missing_docs)] // documentation missing in model
    Dm,
    #[allow(missing_docs)] // documentation missing in model
    Do,
    #[allow(missing_docs)] // documentation missing in model
    Dz,
    #[allow(missing_docs)] // documentation missing in model
    Ec,
    #[allow(missing_docs)] // documentation missing in model
    Ee,
    #[allow(missing_docs)] // documentation missing in model
    Eg,
    #[allow(missing_docs)] // documentation missing in model
    Er,
    #[allow(missing_docs)] // documentation missing in model
    Es,
    #[allow(missing_docs)] // documentation missing in model
    Et,
    #[allow(missing_docs)] // documentation missing in model
    Fi,
    #[allow(missing_docs)] // documentation missing in model
    Fj,
    #[allow(missing_docs)] // documentation missing in model
    Fk,
    #[allow(missing_docs)] // documentation missing in model
    Fm,
    #[allow(missing_docs)] // documentation missing in model
    Fo,
    #[allow(missing_docs)] // documentation missing in model
    Fr,
    #[allow(missing_docs)] // documentation missing in model
    Ga,
    #[allow(missing_docs)] // documentation missing in model
    Gb,
    #[allow(missing_docs)] // documentation missing in model
    Gd,
    #[allow(missing_docs)] // documentation missing in model
    Ge,
    #[allow(missing_docs)] // documentation missing in model
    Gh,
    #[allow(missing_docs)] // documentation missing in model
    Gi,
    #[allow(missing_docs)] // documentation missing in model
    Gl,
    #[allow(missing_docs)] // documentation missing in model
    Gm,
    #[allow(missing_docs)] // documentation missing in model
    Gn,
    #[allow(missing_docs)] // documentation missing in model
    Gq,
    #[allow(missing_docs)] // documentation missing in model
    Gr,
    #[allow(missing_docs)] // documentation missing in model
    Gt,
    #[allow(missing_docs)] // documentation missing in model
    Gu,
    #[allow(missing_docs)] // documentation missing in model
    Gw,
    #[allow(missing_docs)] // documentation missing in model
    Gy,
    #[allow(missing_docs)] // documentation missing in model
    Hk,
    #[allow(missing_docs)] // documentation missing in model
    Hn,
    #[allow(missing_docs)] // documentation missing in model
    Hr,
    #[allow(missing_docs)] // documentation missing in model
    Ht,
    #[allow(missing_docs)] // documentation missing in model
    Hu,
    #[allow(missing_docs)] // documentation missing in model
    Id,
    #[allow(missing_docs)] // documentation missing in model
    Ie,
    #[allow(missing_docs)] // documentation missing in model
    Il,
    #[allow(missing_docs)] // documentation missing in model
    Im,
    #[allow(missing_docs)] // documentation missing in model
    In,
    #[allow(missing_docs)] // documentation missing in model
    Iq,
    #[allow(missing_docs)] // documentation missing in model
    Ir,
    #[allow(missing_docs)] // documentation missing in model
    Is,
    #[allow(missing_docs)] // documentation missing in model
    It,
    #[allow(missing_docs)] // documentation missing in model
    Jm,
    #[allow(missing_docs)] // documentation missing in model
    Jo,
    #[allow(missing_docs)] // documentation missing in model
    Jp,
    #[allow(missing_docs)] // documentation missing in model
    Ke,
    #[allow(missing_docs)] // documentation missing in model
    Kg,
    #[allow(missing_docs)] // documentation missing in model
    Kh,
    #[allow(missing_docs)] // documentation missing in model
    Ki,
    #[allow(missing_docs)] // documentation missing in model
    Km,
    #[allow(missing_docs)] // documentation missing in model
    Kn,
    #[allow(missing_docs)] // documentation missing in model
    Kp,
    #[allow(missing_docs)] // documentation missing in model
    Kr,
    #[allow(missing_docs)] // documentation missing in model
    Kw,
    #[allow(missing_docs)] // documentation missing in model
    Ky,
    #[allow(missing_docs)] // documentation missing in model
    Kz,
    #[allow(missing_docs)] // documentation missing in model
    La,
    #[allow(missing_docs)] // documentation missing in model
    Lb,
    #[allow(missing_docs)] // documentation missing in model
    Lc,
    #[allow(missing_docs)] // documentation missing in model
    Li,
    #[allow(missing_docs)] // documentation missing in model
    Lk,
    #[allow(missing_docs)] // documentation missing in model
    Lr,
    #[allow(missing_docs)] // documentation missing in model
    Ls,
    #[allow(missing_docs)] // documentation missing in model
    Lt,
    #[allow(missing_docs)] // documentation missing in model
    Lu,
    #[allow(missing_docs)] // documentation missing in model
    Lv,
    #[allow(missing_docs)] // documentation missing in model
    Ly,
    #[allow(missing_docs)] // documentation missing in model
    Ma,
    #[allow(missing_docs)] // documentation missing in model
    Mc,
    #[allow(missing_docs)] // documentation missing in model
    Md,
    #[allow(missing_docs)] // documentation missing in model
    Me,
    #[allow(missing_docs)] // documentation missing in model
    Mf,
    #[allow(missing_docs)] // documentation missing in model
    Mg,
    #[allow(missing_docs)] // documentation missing in model
    Mh,
    #[allow(missing_docs)] // documentation missing in model
    Mk,
    #[allow(missing_docs)] // documentation missing in model
    Ml,
    #[allow(missing_docs)] // documentation missing in model
    Mm,
    #[allow(missing_docs)] // documentation missing in model
    Mn,
    #[allow(missing_docs)] // documentation missing in model
    Mo,
    #[allow(missing_docs)] // documentation missing in model
    Mp,
    #[allow(missing_docs)] // documentation missing in model
    Mr,
    #[allow(missing_docs)] // documentation missing in model
    Ms,
    #[allow(missing_docs)] // documentation missing in model
    Mt,
    #[allow(missing_docs)] // documentation missing in model
    Mu,
    #[allow(missing_docs)] // documentation missing in model
    Mv,
    #[allow(missing_docs)] // documentation missing in model
    Mw,
    #[allow(missing_docs)] // documentation missing in model
    Mx,
    #[allow(missing_docs)] // documentation missing in model
    My,
    #[allow(missing_docs)] // documentation missing in model
    Mz,
    #[allow(missing_docs)] // documentation missing in model
    Na,
    #[allow(missing_docs)] // documentation missing in model
    Nc,
    #[allow(missing_docs)] // documentation missing in model
    Ne,
    #[allow(missing_docs)] // documentation missing in model
    Ng,
    #[allow(missing_docs)] // documentation missing in model
    Ni,
    #[allow(missing_docs)] // documentation missing in model
    Nl,
    #[allow(missing_docs)] // documentation missing in model
    No,
    #[allow(missing_docs)] // documentation missing in model
    Np,
    #[allow(missing_docs)] // documentation missing in model
    Nr,
    #[allow(missing_docs)] // documentation missing in model
    Nu,
    #[allow(missing_docs)] // documentation missing in model
    Nz,
    #[allow(missing_docs)] // documentation missing in model
    Om,
    #[allow(missing_docs)] // documentation missing in model
    Pa,
    #[allow(missing_docs)] // documentation missing in model
    Pe,
    #[allow(missing_docs)] // documentation missing in model
    Pf,
    #[allow(missing_docs)] // documentation missing in model
    Pg,
    #[allow(missing_docs)] // documentation missing in model
    Ph,
    #[allow(missing_docs)] // documentation missing in model
    Pk,
    #[allow(missing_docs)] // documentation missing in model
    Pl,
    #[allow(missing_docs)] // documentation missing in model
    Pm,
    #[allow(missing_docs)] // documentation missing in model
    Pn,
    #[allow(missing_docs)] // documentation missing in model
    Pr,
    #[allow(missing_docs)] // documentation missing in model
    Pt,
    #[allow(missing_docs)] // documentation missing in model
    Pw,
    #[allow(missing_docs)] // documentation missing in model
    Py,
    #[allow(missing_docs)] // documentation missing in model
    Qa,
    #[allow(missing_docs)] // documentation missing in model
    Ro,
    #[allow(missing_docs)] // documentation missing in model
    Rs,
    #[allow(missing_docs)] // documentation missing in model
    Ru,
    #[allow(missing_docs)] // documentation missing in model
    Rw,
    #[allow(missing_docs)] // documentation missing in model
    Sa,
    #[allow(missing_docs)] // documentation missing in model
    Sb,
    #[allow(missing_docs)] // documentation missing in model
    Sc,
    #[allow(missing_docs)] // documentation missing in model
    Sd,
    #[allow(missing_docs)] // documentation missing in model
    Se,
    #[allow(missing_docs)] // documentation missing in model
    Sg,
    #[allow(missing_docs)] // documentation missing in model
    Sh,
    #[allow(missing_docs)] // documentation missing in model
    Si,
    #[allow(missing_docs)] // documentation missing in model
    Sk,
    #[allow(missing_docs)] // documentation missing in model
    Sl,
    #[allow(missing_docs)] // documentation missing in model
    Sm,
    #[allow(missing_docs)] // documentation missing in model
    Sn,
    #[allow(missing_docs)] // documentation missing in model
    So,
    #[allow(missing_docs)] // documentation missing in model
    Sr,
    #[allow(missing_docs)] // documentation missing in model
    St,
    #[allow(missing_docs)] // documentation missing in model
    Sv,
    #[allow(missing_docs)] // documentation missing in model
    Sy,
    #[allow(missing_docs)] // documentation missing in model
    Sz,
    #[allow(missing_docs)] // documentation missing in model
    Tc,
    #[allow(missing_docs)] // documentation missing in model
    Td,
    #[allow(missing_docs)] // documentation missing in model
    Tg,
    #[allow(missing_docs)] // documentation missing in model
    Th,
    #[allow(missing_docs)] // documentation missing in model
    Tj,
    #[allow(missing_docs)] // documentation missing in model
    Tk,
    #[allow(missing_docs)] // documentation missing in model
    Tl,
    #[allow(missing_docs)] // documentation missing in model
    Tm,
    #[allow(missing_docs)] // documentation missing in model
    Tn,
    #[allow(missing_docs)] // documentation missing in model
    To,
    #[allow(missing_docs)] // documentation missing in model
    Tr,
    #[allow(missing_docs)] // documentation missing in model
    Tt,
    #[allow(missing_docs)] // documentation missing in model
    Tv,
    #[allow(missing_docs)] // documentation missing in model
    Tw,
    #[allow(missing_docs)] // documentation missing in model
    Tz,
    #[allow(missing_docs)] // documentation missing in model
    Ua,
    #[allow(missing_docs)] // documentation missing in model
    Ug,
    #[allow(missing_docs)] // documentation missing in model
    Us,
    #[allow(missing_docs)] // documentation missing in model
    Uy,
    #[allow(missing_docs)] // documentation missing in model
    Uz,
    #[allow(missing_docs)] // documentation missing in model
    Va,
    #[allow(missing_docs)] // documentation missing in model
    Vc,
    #[allow(missing_docs)] // documentation missing in model
    Ve,
    #[allow(missing_docs)] // documentation missing in model
    Vg,
    #[allow(missing_docs)] // documentation missing in model
    Vi,
    #[allow(missing_docs)] // documentation missing in model
    Vn,
    #[allow(missing_docs)] // documentation missing in model
    Vu,
    #[allow(missing_docs)] // documentation missing in model
    Wf,
    #[allow(missing_docs)] // documentation missing in model
    Ws,
    #[allow(missing_docs)] // documentation missing in model
    Ye,
    #[allow(missing_docs)] // documentation missing in model
    Yt,
    #[allow(missing_docs)] // documentation missing in model
    Za,
    #[allow(missing_docs)] // documentation missing in model
    Zm,
    #[allow(missing_docs)] // documentation missing in model
    Zw,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CountryCode {
    fn from(s: &str) -> Self {
        match s {
            "AD" => CountryCode::Ad,
            "AE" => CountryCode::Ae,
            "AF" => CountryCode::Af,
            "AG" => CountryCode::Ag,
            "AI" => CountryCode::Ai,
            "AL" => CountryCode::Al,
            "AM" => CountryCode::Am,
            "AN" => CountryCode::An,
            "AO" => CountryCode::Ao,
            "AQ" => CountryCode::Aq,
            "AR" => CountryCode::Ar,
            "AS" => CountryCode::As,
            "AT" => CountryCode::At,
            "AU" => CountryCode::Au,
            "AW" => CountryCode::Aw,
            "AZ" => CountryCode::Az,
            "BA" => CountryCode::Ba,
            "BB" => CountryCode::Bb,
            "BD" => CountryCode::Bd,
            "BE" => CountryCode::Be,
            "BF" => CountryCode::Bf,
            "BG" => CountryCode::Bg,
            "BH" => CountryCode::Bh,
            "BI" => CountryCode::Bi,
            "BJ" => CountryCode::Bj,
            "BL" => CountryCode::Bl,
            "BM" => CountryCode::Bm,
            "BN" => CountryCode::Bn,
            "BO" => CountryCode::Bo,
            "BR" => CountryCode::Br,
            "BS" => CountryCode::Bs,
            "BT" => CountryCode::Bt,
            "BW" => CountryCode::Bw,
            "BY" => CountryCode::By,
            "BZ" => CountryCode::Bz,
            "CA" => CountryCode::Ca,
            "CC" => CountryCode::Cc,
            "CD" => CountryCode::Cd,
            "CF" => CountryCode::Cf,
            "CG" => CountryCode::Cg,
            "CH" => CountryCode::Ch,
            "CI" => CountryCode::Ci,
            "CK" => CountryCode::Ck,
            "CL" => CountryCode::Cl,
            "CM" => CountryCode::Cm,
            "CN" => CountryCode::Cn,
            "CO" => CountryCode::Co,
            "CR" => CountryCode::Cr,
            "CU" => CountryCode::Cu,
            "CV" => CountryCode::Cv,
            "CX" => CountryCode::Cx,
            "CY" => CountryCode::Cy,
            "CZ" => CountryCode::Cz,
            "DE" => CountryCode::De,
            "DJ" => CountryCode::Dj,
            "DK" => CountryCode::Dk,
            "DM" => CountryCode::Dm,
            "DO" => CountryCode::Do,
            "DZ" => CountryCode::Dz,
            "EC" => CountryCode::Ec,
            "EE" => CountryCode::Ee,
            "EG" => CountryCode::Eg,
            "ER" => CountryCode::Er,
            "ES" => CountryCode::Es,
            "ET" => CountryCode::Et,
            "FI" => CountryCode::Fi,
            "FJ" => CountryCode::Fj,
            "FK" => CountryCode::Fk,
            "FM" => CountryCode::Fm,
            "FO" => CountryCode::Fo,
            "FR" => CountryCode::Fr,
            "GA" => CountryCode::Ga,
            "GB" => CountryCode::Gb,
            "GD" => CountryCode::Gd,
            "GE" => CountryCode::Ge,
            "GH" => CountryCode::Gh,
            "GI" => CountryCode::Gi,
            "GL" => CountryCode::Gl,
            "GM" => CountryCode::Gm,
            "GN" => CountryCode::Gn,
            "GQ" => CountryCode::Gq,
            "GR" => CountryCode::Gr,
            "GT" => CountryCode::Gt,
            "GU" => CountryCode::Gu,
            "GW" => CountryCode::Gw,
            "GY" => CountryCode::Gy,
            "HK" => CountryCode::Hk,
            "HN" => CountryCode::Hn,
            "HR" => CountryCode::Hr,
            "HT" => CountryCode::Ht,
            "HU" => CountryCode::Hu,
            "ID" => CountryCode::Id,
            "IE" => CountryCode::Ie,
            "IL" => CountryCode::Il,
            "IM" => CountryCode::Im,
            "IN" => CountryCode::In,
            "IQ" => CountryCode::Iq,
            "IR" => CountryCode::Ir,
            "IS" => CountryCode::Is,
            "IT" => CountryCode::It,
            "JM" => CountryCode::Jm,
            "JO" => CountryCode::Jo,
            "JP" => CountryCode::Jp,
            "KE" => CountryCode::Ke,
            "KG" => CountryCode::Kg,
            "KH" => CountryCode::Kh,
            "KI" => CountryCode::Ki,
            "KM" => CountryCode::Km,
            "KN" => CountryCode::Kn,
            "KP" => CountryCode::Kp,
            "KR" => CountryCode::Kr,
            "KW" => CountryCode::Kw,
            "KY" => CountryCode::Ky,
            "KZ" => CountryCode::Kz,
            "LA" => CountryCode::La,
            "LB" => CountryCode::Lb,
            "LC" => CountryCode::Lc,
            "LI" => CountryCode::Li,
            "LK" => CountryCode::Lk,
            "LR" => CountryCode::Lr,
            "LS" => CountryCode::Ls,
            "LT" => CountryCode::Lt,
            "LU" => CountryCode::Lu,
            "LV" => CountryCode::Lv,
            "LY" => CountryCode::Ly,
            "MA" => CountryCode::Ma,
            "MC" => CountryCode::Mc,
            "MD" => CountryCode::Md,
            "ME" => CountryCode::Me,
            "MF" => CountryCode::Mf,
            "MG" => CountryCode::Mg,
            "MH" => CountryCode::Mh,
            "MK" => CountryCode::Mk,
            "ML" => CountryCode::Ml,
            "MM" => CountryCode::Mm,
            "MN" => CountryCode::Mn,
            "MO" => CountryCode::Mo,
            "MP" => CountryCode::Mp,
            "MR" => CountryCode::Mr,
            "MS" => CountryCode::Ms,
            "MT" => CountryCode::Mt,
            "MU" => CountryCode::Mu,
            "MV" => CountryCode::Mv,
            "MW" => CountryCode::Mw,
            "MX" => CountryCode::Mx,
            "MY" => CountryCode::My,
            "MZ" => CountryCode::Mz,
            "NA" => CountryCode::Na,
            "NC" => CountryCode::Nc,
            "NE" => CountryCode::Ne,
            "NG" => CountryCode::Ng,
            "NI" => CountryCode::Ni,
            "NL" => CountryCode::Nl,
            "NO" => CountryCode::No,
            "NP" => CountryCode::Np,
            "NR" => CountryCode::Nr,
            "NU" => CountryCode::Nu,
            "NZ" => CountryCode::Nz,
            "OM" => CountryCode::Om,
            "PA" => CountryCode::Pa,
            "PE" => CountryCode::Pe,
            "PF" => CountryCode::Pf,
            "PG" => CountryCode::Pg,
            "PH" => CountryCode::Ph,
            "PK" => CountryCode::Pk,
            "PL" => CountryCode::Pl,
            "PM" => CountryCode::Pm,
            "PN" => CountryCode::Pn,
            "PR" => CountryCode::Pr,
            "PT" => CountryCode::Pt,
            "PW" => CountryCode::Pw,
            "PY" => CountryCode::Py,
            "QA" => CountryCode::Qa,
            "RO" => CountryCode::Ro,
            "RS" => CountryCode::Rs,
            "RU" => CountryCode::Ru,
            "RW" => CountryCode::Rw,
            "SA" => CountryCode::Sa,
            "SB" => CountryCode::Sb,
            "SC" => CountryCode::Sc,
            "SD" => CountryCode::Sd,
            "SE" => CountryCode::Se,
            "SG" => CountryCode::Sg,
            "SH" => CountryCode::Sh,
            "SI" => CountryCode::Si,
            "SK" => CountryCode::Sk,
            "SL" => CountryCode::Sl,
            "SM" => CountryCode::Sm,
            "SN" => CountryCode::Sn,
            "SO" => CountryCode::So,
            "SR" => CountryCode::Sr,
            "ST" => CountryCode::St,
            "SV" => CountryCode::Sv,
            "SY" => CountryCode::Sy,
            "SZ" => CountryCode::Sz,
            "TC" => CountryCode::Tc,
            "TD" => CountryCode::Td,
            "TG" => CountryCode::Tg,
            "TH" => CountryCode::Th,
            "TJ" => CountryCode::Tj,
            "TK" => CountryCode::Tk,
            "TL" => CountryCode::Tl,
            "TM" => CountryCode::Tm,
            "TN" => CountryCode::Tn,
            "TO" => CountryCode::To,
            "TR" => CountryCode::Tr,
            "TT" => CountryCode::Tt,
            "TV" => CountryCode::Tv,
            "TW" => CountryCode::Tw,
            "TZ" => CountryCode::Tz,
            "UA" => CountryCode::Ua,
            "UG" => CountryCode::Ug,
            "US" => CountryCode::Us,
            "UY" => CountryCode::Uy,
            "UZ" => CountryCode::Uz,
            "VA" => CountryCode::Va,
            "VC" => CountryCode::Vc,
            "VE" => CountryCode::Ve,
            "VG" => CountryCode::Vg,
            "VI" => CountryCode::Vi,
            "VN" => CountryCode::Vn,
            "VU" => CountryCode::Vu,
            "WF" => CountryCode::Wf,
            "WS" => CountryCode::Ws,
            "YE" => CountryCode::Ye,
            "YT" => CountryCode::Yt,
            "ZA" => CountryCode::Za,
            "ZM" => CountryCode::Zm,
            "ZW" => CountryCode::Zw,
            other => CountryCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CountryCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CountryCode::from(s))
    }
}
impl CountryCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CountryCode::Ad => "AD",
            CountryCode::Ae => "AE",
            CountryCode::Af => "AF",
            CountryCode::Ag => "AG",
            CountryCode::Ai => "AI",
            CountryCode::Al => "AL",
            CountryCode::Am => "AM",
            CountryCode::An => "AN",
            CountryCode::Ao => "AO",
            CountryCode::Aq => "AQ",
            CountryCode::Ar => "AR",
            CountryCode::As => "AS",
            CountryCode::At => "AT",
            CountryCode::Au => "AU",
            CountryCode::Aw => "AW",
            CountryCode::Az => "AZ",
            CountryCode::Ba => "BA",
            CountryCode::Bb => "BB",
            CountryCode::Bd => "BD",
            CountryCode::Be => "BE",
            CountryCode::Bf => "BF",
            CountryCode::Bg => "BG",
            CountryCode::Bh => "BH",
            CountryCode::Bi => "BI",
            CountryCode::Bj => "BJ",
            CountryCode::Bl => "BL",
            CountryCode::Bm => "BM",
            CountryCode::Bn => "BN",
            CountryCode::Bo => "BO",
            CountryCode::Br => "BR",
            CountryCode::Bs => "BS",
            CountryCode::Bt => "BT",
            CountryCode::Bw => "BW",
            CountryCode::By => "BY",
            CountryCode::Bz => "BZ",
            CountryCode::Ca => "CA",
            CountryCode::Cc => "CC",
            CountryCode::Cd => "CD",
            CountryCode::Cf => "CF",
            CountryCode::Cg => "CG",
            CountryCode::Ch => "CH",
            CountryCode::Ci => "CI",
            CountryCode::Ck => "CK",
            CountryCode::Cl => "CL",
            CountryCode::Cm => "CM",
            CountryCode::Cn => "CN",
            CountryCode::Co => "CO",
            CountryCode::Cr => "CR",
            CountryCode::Cu => "CU",
            CountryCode::Cv => "CV",
            CountryCode::Cx => "CX",
            CountryCode::Cy => "CY",
            CountryCode::Cz => "CZ",
            CountryCode::De => "DE",
            CountryCode::Dj => "DJ",
            CountryCode::Dk => "DK",
            CountryCode::Dm => "DM",
            CountryCode::Do => "DO",
            CountryCode::Dz => "DZ",
            CountryCode::Ec => "EC",
            CountryCode::Ee => "EE",
            CountryCode::Eg => "EG",
            CountryCode::Er => "ER",
            CountryCode::Es => "ES",
            CountryCode::Et => "ET",
            CountryCode::Fi => "FI",
            CountryCode::Fj => "FJ",
            CountryCode::Fk => "FK",
            CountryCode::Fm => "FM",
            CountryCode::Fo => "FO",
            CountryCode::Fr => "FR",
            CountryCode::Ga => "GA",
            CountryCode::Gb => "GB",
            CountryCode::Gd => "GD",
            CountryCode::Ge => "GE",
            CountryCode::Gh => "GH",
            CountryCode::Gi => "GI",
            CountryCode::Gl => "GL",
            CountryCode::Gm => "GM",
            CountryCode::Gn => "GN",
            CountryCode::Gq => "GQ",
            CountryCode::Gr => "GR",
            CountryCode::Gt => "GT",
            CountryCode::Gu => "GU",
            CountryCode::Gw => "GW",
            CountryCode::Gy => "GY",
            CountryCode::Hk => "HK",
            CountryCode::Hn => "HN",
            CountryCode::Hr => "HR",
            CountryCode::Ht => "HT",
            CountryCode::Hu => "HU",
            CountryCode::Id => "ID",
            CountryCode::Ie => "IE",
            CountryCode::Il => "IL",
            CountryCode::Im => "IM",
            CountryCode::In => "IN",
            CountryCode::Iq => "IQ",
            CountryCode::Ir => "IR",
            CountryCode::Is => "IS",
            CountryCode::It => "IT",
            CountryCode::Jm => "JM",
            CountryCode::Jo => "JO",
            CountryCode::Jp => "JP",
            CountryCode::Ke => "KE",
            CountryCode::Kg => "KG",
            CountryCode::Kh => "KH",
            CountryCode::Ki => "KI",
            CountryCode::Km => "KM",
            CountryCode::Kn => "KN",
            CountryCode::Kp => "KP",
            CountryCode::Kr => "KR",
            CountryCode::Kw => "KW",
            CountryCode::Ky => "KY",
            CountryCode::Kz => "KZ",
            CountryCode::La => "LA",
            CountryCode::Lb => "LB",
            CountryCode::Lc => "LC",
            CountryCode::Li => "LI",
            CountryCode::Lk => "LK",
            CountryCode::Lr => "LR",
            CountryCode::Ls => "LS",
            CountryCode::Lt => "LT",
            CountryCode::Lu => "LU",
            CountryCode::Lv => "LV",
            CountryCode::Ly => "LY",
            CountryCode::Ma => "MA",
            CountryCode::Mc => "MC",
            CountryCode::Md => "MD",
            CountryCode::Me => "ME",
            CountryCode::Mf => "MF",
            CountryCode::Mg => "MG",
            CountryCode::Mh => "MH",
            CountryCode::Mk => "MK",
            CountryCode::Ml => "ML",
            CountryCode::Mm => "MM",
            CountryCode::Mn => "MN",
            CountryCode::Mo => "MO",
            CountryCode::Mp => "MP",
            CountryCode::Mr => "MR",
            CountryCode::Ms => "MS",
            CountryCode::Mt => "MT",
            CountryCode::Mu => "MU",
            CountryCode::Mv => "MV",
            CountryCode::Mw => "MW",
            CountryCode::Mx => "MX",
            CountryCode::My => "MY",
            CountryCode::Mz => "MZ",
            CountryCode::Na => "NA",
            CountryCode::Nc => "NC",
            CountryCode::Ne => "NE",
            CountryCode::Ng => "NG",
            CountryCode::Ni => "NI",
            CountryCode::Nl => "NL",
            CountryCode::No => "NO",
            CountryCode::Np => "NP",
            CountryCode::Nr => "NR",
            CountryCode::Nu => "NU",
            CountryCode::Nz => "NZ",
            CountryCode::Om => "OM",
            CountryCode::Pa => "PA",
            CountryCode::Pe => "PE",
            CountryCode::Pf => "PF",
            CountryCode::Pg => "PG",
            CountryCode::Ph => "PH",
            CountryCode::Pk => "PK",
            CountryCode::Pl => "PL",
            CountryCode::Pm => "PM",
            CountryCode::Pn => "PN",
            CountryCode::Pr => "PR",
            CountryCode::Pt => "PT",
            CountryCode::Pw => "PW",
            CountryCode::Py => "PY",
            CountryCode::Qa => "QA",
            CountryCode::Ro => "RO",
            CountryCode::Rs => "RS",
            CountryCode::Ru => "RU",
            CountryCode::Rw => "RW",
            CountryCode::Sa => "SA",
            CountryCode::Sb => "SB",
            CountryCode::Sc => "SC",
            CountryCode::Sd => "SD",
            CountryCode::Se => "SE",
            CountryCode::Sg => "SG",
            CountryCode::Sh => "SH",
            CountryCode::Si => "SI",
            CountryCode::Sk => "SK",
            CountryCode::Sl => "SL",
            CountryCode::Sm => "SM",
            CountryCode::Sn => "SN",
            CountryCode::So => "SO",
            CountryCode::Sr => "SR",
            CountryCode::St => "ST",
            CountryCode::Sv => "SV",
            CountryCode::Sy => "SY",
            CountryCode::Sz => "SZ",
            CountryCode::Tc => "TC",
            CountryCode::Td => "TD",
            CountryCode::Tg => "TG",
            CountryCode::Th => "TH",
            CountryCode::Tj => "TJ",
            CountryCode::Tk => "TK",
            CountryCode::Tl => "TL",
            CountryCode::Tm => "TM",
            CountryCode::Tn => "TN",
            CountryCode::To => "TO",
            CountryCode::Tr => "TR",
            CountryCode::Tt => "TT",
            CountryCode::Tv => "TV",
            CountryCode::Tw => "TW",
            CountryCode::Tz => "TZ",
            CountryCode::Ua => "UA",
            CountryCode::Ug => "UG",
            CountryCode::Us => "US",
            CountryCode::Uy => "UY",
            CountryCode::Uz => "UZ",
            CountryCode::Va => "VA",
            CountryCode::Vc => "VC",
            CountryCode::Ve => "VE",
            CountryCode::Vg => "VG",
            CountryCode::Vi => "VI",
            CountryCode::Vn => "VN",
            CountryCode::Vu => "VU",
            CountryCode::Wf => "WF",
            CountryCode::Ws => "WS",
            CountryCode::Ye => "YE",
            CountryCode::Yt => "YT",
            CountryCode::Za => "ZA",
            CountryCode::Zm => "ZM",
            CountryCode::Zw => "ZW",
            CountryCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AD", "AE", "AF", "AG", "AI", "AL", "AM", "AN", "AO", "AQ", "AR", "AS", "AT", "AU",
            "AW", "AZ", "BA", "BB", "BD", "BE", "BF", "BG", "BH", "BI", "BJ", "BL", "BM", "BN",
            "BO", "BR", "BS", "BT", "BW", "BY", "BZ", "CA", "CC", "CD", "CF", "CG", "CH", "CI",
            "CK", "CL", "CM", "CN", "CO", "CR", "CU", "CV", "CX", "CY", "CZ", "DE", "DJ", "DK",
            "DM", "DO", "DZ", "EC", "EE", "EG", "ER", "ES", "ET", "FI", "FJ", "FK", "FM", "FO",
            "FR", "GA", "GB", "GD", "GE", "GH", "GI", "GL", "GM", "GN", "GQ", "GR", "GT", "GU",
            "GW", "GY", "HK", "HN", "HR", "HT", "HU", "ID", "IE", "IL", "IM", "IN", "IQ", "IR",
            "IS", "IT", "JM", "JO", "JP", "KE", "KG", "KH", "KI", "KM", "KN", "KP", "KR", "KW",
            "KY", "KZ", "LA", "LB", "LC", "LI", "LK", "LR", "LS", "LT", "LU", "LV", "LY", "MA",
            "MC", "MD", "ME", "MF", "MG", "MH", "MK", "ML", "MM", "MN", "MO", "MP", "MR", "MS",
            "MT", "MU", "MV", "MW", "MX", "MY", "MZ", "NA", "NC", "NE", "NG", "NI", "NL", "NO",
            "NP", "NR", "NU", "NZ", "OM", "PA", "PE", "PF", "PG", "PH", "PK", "PL", "PM", "PN",
            "PR", "PT", "PW", "PY", "QA", "RO", "RS", "RU", "RW", "SA", "SB", "SC", "SD", "SE",
            "SG", "SH", "SI", "SK", "SL", "SM", "SN", "SO", "SR", "ST", "SV", "SY", "SZ", "TC",
            "TD", "TG", "TH", "TJ", "TK", "TL", "TM", "TN", "TO", "TR", "TT", "TV", "TW", "TZ",
            "UA", "UG", "US", "UY", "UZ", "VA", "VC", "VE", "VG", "VI", "VN", "VU", "WF", "WS",
            "YE", "YT", "ZA", "ZM", "ZW",
        ]
    }
}
impl AsRef<str> for CountryCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContactType {
    #[allow(missing_docs)] // documentation missing in model
    Association,
    #[allow(missing_docs)] // documentation missing in model
    Company,
    #[allow(missing_docs)] // documentation missing in model
    Person,
    #[allow(missing_docs)] // documentation missing in model
    PublicBody,
    #[allow(missing_docs)] // documentation missing in model
    Reseller,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContactType {
    fn from(s: &str) -> Self {
        match s {
            "ASSOCIATION" => ContactType::Association,
            "COMPANY" => ContactType::Company,
            "PERSON" => ContactType::Person,
            "PUBLIC_BODY" => ContactType::PublicBody,
            "RESELLER" => ContactType::Reseller,
            other => ContactType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ContactType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContactType::from(s))
    }
}
impl ContactType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContactType::Association => "ASSOCIATION",
            ContactType::Company => "COMPANY",
            ContactType::Person => "PERSON",
            ContactType::PublicBody => "PUBLIC_BODY",
            ContactType::Reseller => "RESELLER",
            ContactType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ASSOCIATION",
            "COMPANY",
            "PERSON",
            "PUBLIC_BODY",
            "RESELLER",
        ]
    }
}
impl AsRef<str> for ContactType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>OperationSummary includes the following elements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OperationSummary {
    /// <p>Identifier returned to track the requested action.</p>
    pub operation_id: std::option::Option<std::string::String>,
    /// <p>The current status of the requested operation in the system.</p>
    pub status: std::option::Option<crate::model::OperationStatus>,
    /// <p>Type of the action requested.</p>
    pub r#type: std::option::Option<crate::model::OperationType>,
    /// <p>The date when the request was submitted.</p>
    pub submitted_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl OperationSummary {
    /// <p>Identifier returned to track the requested action.</p>
    pub fn operation_id(&self) -> std::option::Option<&str> {
        self.operation_id.as_deref()
    }
    /// <p>The current status of the requested operation in the system.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::OperationStatus> {
        self.status.as_ref()
    }
    /// <p>Type of the action requested.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::OperationType> {
        self.r#type.as_ref()
    }
    /// <p>The date when the request was submitted.</p>
    pub fn submitted_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.submitted_date.as_ref()
    }
}
impl std::fmt::Debug for OperationSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OperationSummary");
        formatter.field("operation_id", &self.operation_id);
        formatter.field("status", &self.status);
        formatter.field("r#type", &self.r#type);
        formatter.field("submitted_date", &self.submitted_date);
        formatter.finish()
    }
}
/// See [`OperationSummary`](crate::model::OperationSummary)
pub mod operation_summary {
    /// A builder for [`OperationSummary`](crate::model::OperationSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operation_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::OperationStatus>,
        pub(crate) r#type: std::option::Option<crate::model::OperationType>,
        pub(crate) submitted_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>Identifier returned to track the requested action.</p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>Identifier returned to track the requested action.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// <p>The current status of the requested operation in the system.</p>
        pub fn status(mut self, input: crate::model::OperationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the requested operation in the system.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::OperationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Type of the action requested.</p>
        pub fn r#type(mut self, input: crate::model::OperationType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Type of the action requested.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::OperationType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The date when the request was submitted.</p>
        pub fn submitted_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.submitted_date = Some(input);
            self
        }
        /// <p>The date when the request was submitted.</p>
        pub fn set_submitted_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.submitted_date = input;
            self
        }
        /// Consumes the builder and constructs a [`OperationSummary`](crate::model::OperationSummary)
        pub fn build(self) -> crate::model::OperationSummary {
            crate::model::OperationSummary {
                operation_id: self.operation_id,
                status: self.status,
                r#type: self.r#type,
                submitted_date: self.submitted_date,
            }
        }
    }
}
impl OperationSummary {
    /// Creates a new builder-style object to manufacture [`OperationSummary`](crate::model::OperationSummary)
    pub fn builder() -> crate::model::operation_summary::Builder {
        crate::model::operation_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OperationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Submitted,
    #[allow(missing_docs)] // documentation missing in model
    Successful,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OperationStatus {
    fn from(s: &str) -> Self {
        match s {
            "ERROR" => OperationStatus::Error,
            "FAILED" => OperationStatus::Failed,
            "IN_PROGRESS" => OperationStatus::InProgress,
            "SUBMITTED" => OperationStatus::Submitted,
            "SUCCESSFUL" => OperationStatus::Successful,
            other => OperationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OperationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OperationStatus::from(s))
    }
}
impl OperationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OperationStatus::Error => "ERROR",
            OperationStatus::Failed => "FAILED",
            OperationStatus::InProgress => "IN_PROGRESS",
            OperationStatus::Submitted => "SUBMITTED",
            OperationStatus::Successful => "SUCCESSFUL",
            OperationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ERROR", "FAILED", "IN_PROGRESS", "SUBMITTED", "SUCCESSFUL"]
    }
}
impl AsRef<str> for OperationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Summary information about one domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainSummary {
    /// <p>The name of the domain that the summary information applies to.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>Indicates whether the domain is automatically renewed upon expiration.</p>
    pub auto_renew: std::option::Option<bool>,
    /// <p>Indicates whether a domain is locked from unauthorized transfer to another party.</p>
    pub transfer_lock: std::option::Option<bool>,
    /// <p>Expiration date of the domain in Unix time format and Coordinated Universal Time (UTC).</p>
    pub expiry: std::option::Option<aws_smithy_types::DateTime>,
}
impl DomainSummary {
    /// <p>The name of the domain that the summary information applies to.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>Indicates whether the domain is automatically renewed upon expiration.</p>
    pub fn auto_renew(&self) -> std::option::Option<bool> {
        self.auto_renew
    }
    /// <p>Indicates whether a domain is locked from unauthorized transfer to another party.</p>
    pub fn transfer_lock(&self) -> std::option::Option<bool> {
        self.transfer_lock
    }
    /// <p>Expiration date of the domain in Unix time format and Coordinated Universal Time (UTC).</p>
    pub fn expiry(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.expiry.as_ref()
    }
}
impl std::fmt::Debug for DomainSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainSummary");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("auto_renew", &self.auto_renew);
        formatter.field("transfer_lock", &self.transfer_lock);
        formatter.field("expiry", &self.expiry);
        formatter.finish()
    }
}
/// See [`DomainSummary`](crate::model::DomainSummary)
pub mod domain_summary {
    /// A builder for [`DomainSummary`](crate::model::DomainSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) auto_renew: std::option::Option<bool>,
        pub(crate) transfer_lock: std::option::Option<bool>,
        pub(crate) expiry: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the domain that the summary information applies to.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the domain that the summary information applies to.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>Indicates whether the domain is automatically renewed upon expiration.</p>
        pub fn auto_renew(mut self, input: bool) -> Self {
            self.auto_renew = Some(input);
            self
        }
        /// <p>Indicates whether the domain is automatically renewed upon expiration.</p>
        pub fn set_auto_renew(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_renew = input;
            self
        }
        /// <p>Indicates whether a domain is locked from unauthorized transfer to another party.</p>
        pub fn transfer_lock(mut self, input: bool) -> Self {
            self.transfer_lock = Some(input);
            self
        }
        /// <p>Indicates whether a domain is locked from unauthorized transfer to another party.</p>
        pub fn set_transfer_lock(mut self, input: std::option::Option<bool>) -> Self {
            self.transfer_lock = input;
            self
        }
        /// <p>Expiration date of the domain in Unix time format and Coordinated Universal Time (UTC).</p>
        pub fn expiry(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.expiry = Some(input);
            self
        }
        /// <p>Expiration date of the domain in Unix time format and Coordinated Universal Time (UTC).</p>
        pub fn set_expiry(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.expiry = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainSummary`](crate::model::DomainSummary)
        pub fn build(self) -> crate::model::DomainSummary {
            crate::model::DomainSummary {
                domain_name: self.domain_name,
                auto_renew: self.auto_renew,
                transfer_lock: self.transfer_lock,
                expiry: self.expiry,
            }
        }
    }
}
impl DomainSummary {
    /// Creates a new builder-style object to manufacture [`DomainSummary`](crate::model::DomainSummary)
    pub fn builder() -> crate::model::domain_summary::Builder {
        crate::model::domain_summary::Builder::default()
    }
}

/// <p>Information about one suggested domain name.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainSuggestion {
    /// <p>A suggested domain name.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>Whether the domain name is available for registering.</p>
    /// <note>
    /// <p>You can register only the domains that are designated as <code>AVAILABLE</code>.</p>
    /// </note>
    /// <p>Valid values:</p>
    /// <dl>
    /// <dt>AVAILABLE</dt>
    /// <dd>
    /// <p>The domain name is available.</p>
    /// </dd>
    /// <dt>AVAILABLE_RESERVED</dt>
    /// <dd>
    /// <p>The domain name is reserved under specific conditions.</p>
    /// </dd>
    /// <dt>AVAILABLE_PREORDER</dt>
    /// <dd>
    /// <p>The domain name is available and can be preordered.</p>
    /// </dd>
    /// <dt>DONT_KNOW</dt>
    /// <dd>
    /// <p>The TLD registry didn't reply with a definitive answer about whether the domain name is available.
    /// Route 53 can return this response for a variety of reasons, for example, the registry is performing maintenance.
    /// Try again later.</p>
    /// </dd>
    /// <dt>PENDING</dt>
    /// <dd>
    /// <p>The TLD registry didn't return a response in the expected amount of time. When the response is delayed,
    /// it usually takes just a few extra seconds. You can resubmit the request immediately.</p>
    /// </dd>
    /// <dt>RESERVED</dt>
    /// <dd>
    /// <p>The domain name has been reserved for another person or organization.</p>
    /// </dd>
    /// <dt>UNAVAILABLE</dt>
    /// <dd>
    /// <p>The domain name is not available.</p>
    /// </dd>
    /// <dt>UNAVAILABLE_PREMIUM</dt>
    /// <dd>
    /// <p>The domain name is not available.</p>
    /// </dd>
    /// <dt>UNAVAILABLE_RESTRICTED</dt>
    /// <dd>
    /// <p>The domain name is forbidden.</p>
    /// </dd>
    /// </dl>
    pub availability: std::option::Option<std::string::String>,
}
impl DomainSuggestion {
    /// <p>A suggested domain name.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>Whether the domain name is available for registering.</p>
    /// <note>
    /// <p>You can register only the domains that are designated as <code>AVAILABLE</code>.</p>
    /// </note>
    /// <p>Valid values:</p>
    /// <dl>
    /// <dt>AVAILABLE</dt>
    /// <dd>
    /// <p>The domain name is available.</p>
    /// </dd>
    /// <dt>AVAILABLE_RESERVED</dt>
    /// <dd>
    /// <p>The domain name is reserved under specific conditions.</p>
    /// </dd>
    /// <dt>AVAILABLE_PREORDER</dt>
    /// <dd>
    /// <p>The domain name is available and can be preordered.</p>
    /// </dd>
    /// <dt>DONT_KNOW</dt>
    /// <dd>
    /// <p>The TLD registry didn't reply with a definitive answer about whether the domain name is available.
    /// Route 53 can return this response for a variety of reasons, for example, the registry is performing maintenance.
    /// Try again later.</p>
    /// </dd>
    /// <dt>PENDING</dt>
    /// <dd>
    /// <p>The TLD registry didn't return a response in the expected amount of time. When the response is delayed,
    /// it usually takes just a few extra seconds. You can resubmit the request immediately.</p>
    /// </dd>
    /// <dt>RESERVED</dt>
    /// <dd>
    /// <p>The domain name has been reserved for another person or organization.</p>
    /// </dd>
    /// <dt>UNAVAILABLE</dt>
    /// <dd>
    /// <p>The domain name is not available.</p>
    /// </dd>
    /// <dt>UNAVAILABLE_PREMIUM</dt>
    /// <dd>
    /// <p>The domain name is not available.</p>
    /// </dd>
    /// <dt>UNAVAILABLE_RESTRICTED</dt>
    /// <dd>
    /// <p>The domain name is forbidden.</p>
    /// </dd>
    /// </dl>
    pub fn availability(&self) -> std::option::Option<&str> {
        self.availability.as_deref()
    }
}
impl std::fmt::Debug for DomainSuggestion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainSuggestion");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("availability", &self.availability);
        formatter.finish()
    }
}
/// See [`DomainSuggestion`](crate::model::DomainSuggestion)
pub mod domain_suggestion {
    /// A builder for [`DomainSuggestion`](crate::model::DomainSuggestion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) availability: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A suggested domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>A suggested domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>Whether the domain name is available for registering.</p>
        /// <note>
        /// <p>You can register only the domains that are designated as <code>AVAILABLE</code>.</p>
        /// </note>
        /// <p>Valid values:</p>
        /// <dl>
        /// <dt>AVAILABLE</dt>
        /// <dd>
        /// <p>The domain name is available.</p>
        /// </dd>
        /// <dt>AVAILABLE_RESERVED</dt>
        /// <dd>
        /// <p>The domain name is reserved under specific conditions.</p>
        /// </dd>
        /// <dt>AVAILABLE_PREORDER</dt>
        /// <dd>
        /// <p>The domain name is available and can be preordered.</p>
        /// </dd>
        /// <dt>DONT_KNOW</dt>
        /// <dd>
        /// <p>The TLD registry didn't reply with a definitive answer about whether the domain name is available.
        /// Route 53 can return this response for a variety of reasons, for example, the registry is performing maintenance.
        /// Try again later.</p>
        /// </dd>
        /// <dt>PENDING</dt>
        /// <dd>
        /// <p>The TLD registry didn't return a response in the expected amount of time. When the response is delayed,
        /// it usually takes just a few extra seconds. You can resubmit the request immediately.</p>
        /// </dd>
        /// <dt>RESERVED</dt>
        /// <dd>
        /// <p>The domain name has been reserved for another person or organization.</p>
        /// </dd>
        /// <dt>UNAVAILABLE</dt>
        /// <dd>
        /// <p>The domain name is not available.</p>
        /// </dd>
        /// <dt>UNAVAILABLE_PREMIUM</dt>
        /// <dd>
        /// <p>The domain name is not available.</p>
        /// </dd>
        /// <dt>UNAVAILABLE_RESTRICTED</dt>
        /// <dd>
        /// <p>The domain name is forbidden.</p>
        /// </dd>
        /// </dl>
        pub fn availability(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability = Some(input.into());
            self
        }
        /// <p>Whether the domain name is available for registering.</p>
        /// <note>
        /// <p>You can register only the domains that are designated as <code>AVAILABLE</code>.</p>
        /// </note>
        /// <p>Valid values:</p>
        /// <dl>
        /// <dt>AVAILABLE</dt>
        /// <dd>
        /// <p>The domain name is available.</p>
        /// </dd>
        /// <dt>AVAILABLE_RESERVED</dt>
        /// <dd>
        /// <p>The domain name is reserved under specific conditions.</p>
        /// </dd>
        /// <dt>AVAILABLE_PREORDER</dt>
        /// <dd>
        /// <p>The domain name is available and can be preordered.</p>
        /// </dd>
        /// <dt>DONT_KNOW</dt>
        /// <dd>
        /// <p>The TLD registry didn't reply with a definitive answer about whether the domain name is available.
        /// Route 53 can return this response for a variety of reasons, for example, the registry is performing maintenance.
        /// Try again later.</p>
        /// </dd>
        /// <dt>PENDING</dt>
        /// <dd>
        /// <p>The TLD registry didn't return a response in the expected amount of time. When the response is delayed,
        /// it usually takes just a few extra seconds. You can resubmit the request immediately.</p>
        /// </dd>
        /// <dt>RESERVED</dt>
        /// <dd>
        /// <p>The domain name has been reserved for another person or organization.</p>
        /// </dd>
        /// <dt>UNAVAILABLE</dt>
        /// <dd>
        /// <p>The domain name is not available.</p>
        /// </dd>
        /// <dt>UNAVAILABLE_PREMIUM</dt>
        /// <dd>
        /// <p>The domain name is not available.</p>
        /// </dd>
        /// <dt>UNAVAILABLE_RESTRICTED</dt>
        /// <dd>
        /// <p>The domain name is forbidden.</p>
        /// </dd>
        /// </dl>
        pub fn set_availability(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.availability = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainSuggestion`](crate::model::DomainSuggestion)
        pub fn build(self) -> crate::model::DomainSuggestion {
            crate::model::DomainSuggestion {
                domain_name: self.domain_name,
                availability: self.availability,
            }
        }
    }
}
impl DomainSuggestion {
    /// Creates a new builder-style object to manufacture [`DomainSuggestion`](crate::model::DomainSuggestion)
    pub fn builder() -> crate::model::domain_suggestion::Builder {
        crate::model::domain_suggestion::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReachabilityStatus {
    #[allow(missing_docs)] // documentation missing in model
    Done,
    #[allow(missing_docs)] // documentation missing in model
    Expired,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReachabilityStatus {
    fn from(s: &str) -> Self {
        match s {
            "DONE" => ReachabilityStatus::Done,
            "EXPIRED" => ReachabilityStatus::Expired,
            "PENDING" => ReachabilityStatus::Pending,
            other => ReachabilityStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReachabilityStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReachabilityStatus::from(s))
    }
}
impl ReachabilityStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReachabilityStatus::Done => "DONE",
            ReachabilityStatus::Expired => "EXPIRED",
            ReachabilityStatus::Pending => "PENDING",
            ReachabilityStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DONE", "EXPIRED", "PENDING"]
    }
}
impl AsRef<str> for ReachabilityStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A complex type that contains information about whether the specified domain can be transferred to Route 53.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainTransferability {
    /// <p>Whether the domain name can be transferred to Route 53.</p>
    /// <note>
    /// <p>You can transfer only domains that have a value of <code>TRANSFERABLE</code> for <code>Transferable</code>.</p>
    /// </note>
    ///
    /// <p>Valid values:</p>
    /// <dl>
    /// <dt>TRANSFERABLE</dt>
    /// <dd>
    /// <p>The domain name can be transferred to Route 53.</p>
    /// </dd>
    /// <dt>UNTRANSFERRABLE</dt>
    /// <dd>
    /// <p>The domain name can't be transferred to Route 53.</p>
    /// </dd>
    /// <dt>DONT_KNOW</dt>
    /// <dd>
    /// <p>Reserved for future use.</p>
    /// </dd>
    /// </dl>
    pub transferable: std::option::Option<crate::model::Transferable>,
}
impl DomainTransferability {
    /// <p>Whether the domain name can be transferred to Route 53.</p>
    /// <note>
    /// <p>You can transfer only domains that have a value of <code>TRANSFERABLE</code> for <code>Transferable</code>.</p>
    /// </note>
    ///
    /// <p>Valid values:</p>
    /// <dl>
    /// <dt>TRANSFERABLE</dt>
    /// <dd>
    /// <p>The domain name can be transferred to Route 53.</p>
    /// </dd>
    /// <dt>UNTRANSFERRABLE</dt>
    /// <dd>
    /// <p>The domain name can't be transferred to Route 53.</p>
    /// </dd>
    /// <dt>DONT_KNOW</dt>
    /// <dd>
    /// <p>Reserved for future use.</p>
    /// </dd>
    /// </dl>
    pub fn transferable(&self) -> std::option::Option<&crate::model::Transferable> {
        self.transferable.as_ref()
    }
}
impl std::fmt::Debug for DomainTransferability {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainTransferability");
        formatter.field("transferable", &self.transferable);
        formatter.finish()
    }
}
/// See [`DomainTransferability`](crate::model::DomainTransferability)
pub mod domain_transferability {
    /// A builder for [`DomainTransferability`](crate::model::DomainTransferability)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transferable: std::option::Option<crate::model::Transferable>,
    }
    impl Builder {
        /// <p>Whether the domain name can be transferred to Route 53.</p>
        /// <note>
        /// <p>You can transfer only domains that have a value of <code>TRANSFERABLE</code> for <code>Transferable</code>.</p>
        /// </note>
        ///
        /// <p>Valid values:</p>
        /// <dl>
        /// <dt>TRANSFERABLE</dt>
        /// <dd>
        /// <p>The domain name can be transferred to Route 53.</p>
        /// </dd>
        /// <dt>UNTRANSFERRABLE</dt>
        /// <dd>
        /// <p>The domain name can't be transferred to Route 53.</p>
        /// </dd>
        /// <dt>DONT_KNOW</dt>
        /// <dd>
        /// <p>Reserved for future use.</p>
        /// </dd>
        /// </dl>
        pub fn transferable(mut self, input: crate::model::Transferable) -> Self {
            self.transferable = Some(input);
            self
        }
        /// <p>Whether the domain name can be transferred to Route 53.</p>
        /// <note>
        /// <p>You can transfer only domains that have a value of <code>TRANSFERABLE</code> for <code>Transferable</code>.</p>
        /// </note>
        ///
        /// <p>Valid values:</p>
        /// <dl>
        /// <dt>TRANSFERABLE</dt>
        /// <dd>
        /// <p>The domain name can be transferred to Route 53.</p>
        /// </dd>
        /// <dt>UNTRANSFERRABLE</dt>
        /// <dd>
        /// <p>The domain name can't be transferred to Route 53.</p>
        /// </dd>
        /// <dt>DONT_KNOW</dt>
        /// <dd>
        /// <p>Reserved for future use.</p>
        /// </dd>
        /// </dl>
        pub fn set_transferable(
            mut self,
            input: std::option::Option<crate::model::Transferable>,
        ) -> Self {
            self.transferable = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainTransferability`](crate::model::DomainTransferability)
        pub fn build(self) -> crate::model::DomainTransferability {
            crate::model::DomainTransferability {
                transferable: self.transferable,
            }
        }
    }
}
impl DomainTransferability {
    /// Creates a new builder-style object to manufacture [`DomainTransferability`](crate::model::DomainTransferability)
    pub fn builder() -> crate::model::domain_transferability::Builder {
        crate::model::domain_transferability::Builder::default()
    }
}

/// <p>Whether the domain name can be transferred to Route 53.</p>
/// <note>
/// <p>You can transfer only domains that have a value of <code>TRANSFERABLE</code> for <code>Transferable</code>.</p>
/// </note>
///
/// <p>Valid values:</p>
/// <dl>
/// <dt>TRANSFERABLE</dt>
/// <dd>
/// <p>The domain name can be transferred to Route 53.</p>
/// </dd>
/// <dt>UNTRANSFERRABLE</dt>
/// <dd>
/// <p>The domain name can't be transferred to Route 53.</p>
/// </dd>
/// <dt>DONT_KNOW</dt>
/// <dd>
/// <p>Reserved for future use.</p>
/// </dd>
/// </dl>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Transferable {
    #[allow(missing_docs)] // documentation missing in model
    DontKnow,
    #[allow(missing_docs)] // documentation missing in model
    Transferable,
    #[allow(missing_docs)] // documentation missing in model
    Untransferable,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Transferable {
    fn from(s: &str) -> Self {
        match s {
            "DONT_KNOW" => Transferable::DontKnow,
            "TRANSFERABLE" => Transferable::Transferable,
            "UNTRANSFERABLE" => Transferable::Untransferable,
            other => Transferable::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Transferable {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Transferable::from(s))
    }
}
impl Transferable {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Transferable::DontKnow => "DONT_KNOW",
            Transferable::Transferable => "TRANSFERABLE",
            Transferable::Untransferable => "UNTRANSFERABLE",
            Transferable::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DONT_KNOW", "TRANSFERABLE", "UNTRANSFERABLE"]
    }
}
impl AsRef<str> for Transferable {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DomainAvailability {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    AvailablePreorder,
    #[allow(missing_docs)] // documentation missing in model
    AvailableReserved,
    #[allow(missing_docs)] // documentation missing in model
    DontKnow,
    #[allow(missing_docs)] // documentation missing in model
    Reserved,
    #[allow(missing_docs)] // documentation missing in model
    Unavailable,
    #[allow(missing_docs)] // documentation missing in model
    UnavailablePremium,
    #[allow(missing_docs)] // documentation missing in model
    UnavailableRestricted,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DomainAvailability {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => DomainAvailability::Available,
            "AVAILABLE_PREORDER" => DomainAvailability::AvailablePreorder,
            "AVAILABLE_RESERVED" => DomainAvailability::AvailableReserved,
            "DONT_KNOW" => DomainAvailability::DontKnow,
            "RESERVED" => DomainAvailability::Reserved,
            "UNAVAILABLE" => DomainAvailability::Unavailable,
            "UNAVAILABLE_PREMIUM" => DomainAvailability::UnavailablePremium,
            "UNAVAILABLE_RESTRICTED" => DomainAvailability::UnavailableRestricted,
            other => DomainAvailability::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DomainAvailability {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DomainAvailability::from(s))
    }
}
impl DomainAvailability {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DomainAvailability::Available => "AVAILABLE",
            DomainAvailability::AvailablePreorder => "AVAILABLE_PREORDER",
            DomainAvailability::AvailableReserved => "AVAILABLE_RESERVED",
            DomainAvailability::DontKnow => "DONT_KNOW",
            DomainAvailability::Reserved => "RESERVED",
            DomainAvailability::Unavailable => "UNAVAILABLE",
            DomainAvailability::UnavailablePremium => "UNAVAILABLE_PREMIUM",
            DomainAvailability::UnavailableRestricted => "UNAVAILABLE_RESTRICTED",
            DomainAvailability::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AVAILABLE",
            "AVAILABLE_PREORDER",
            "AVAILABLE_RESERVED",
            "DONT_KNOW",
            "RESERVED",
            "UNAVAILABLE",
            "UNAVAILABLE_PREMIUM",
            "UNAVAILABLE_RESTRICTED",
        ]
    }
}
impl AsRef<str> for DomainAvailability {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
