// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Route 53 Domains
///
/// Client for invoking operations on Amazon Route 53 Domains. Each operation on Amazon Route 53 Domains is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_route53domains::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_route53domains::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_route53domains::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AcceptDomainTransferFromAnotherAwsAccount`](crate::client::fluent_builders::AcceptDomainTransferFromAnotherAwsAccount) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::AcceptDomainTransferFromAnotherAwsAccount::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::AcceptDomainTransferFromAnotherAwsAccount::set_domain_name): <p>The name of the domain that was specified when another Amazon Web Services account submitted a <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html">TransferDomainToAnotherAwsAccount</a> request. </p>
    ///   - [`password(impl Into<String>)`](crate::client::fluent_builders::AcceptDomainTransferFromAnotherAwsAccount::password) / [`set_password(Option<String>)`](crate::client::fluent_builders::AcceptDomainTransferFromAnotherAwsAccount::set_password): <p>The password that was returned by the <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html">TransferDomainToAnotherAwsAccount</a> request. </p>
    /// - On success, responds with [`AcceptDomainTransferFromAnotherAwsAccountOutput`](crate::output::AcceptDomainTransferFromAnotherAwsAccountOutput) with field(s):
    ///   - [`operation_id(Option<String>)`](crate::output::AcceptDomainTransferFromAnotherAwsAccountOutput::operation_id): <p>Identifier for tracking the progress of the request. To query the operation status, use <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>.</p>
    /// - On failure, responds with [`SdkError<AcceptDomainTransferFromAnotherAwsAccountError>`](crate::error::AcceptDomainTransferFromAnotherAwsAccountError)
    pub fn accept_domain_transfer_from_another_aws_account(
        &self,
    ) -> fluent_builders::AcceptDomainTransferFromAnotherAwsAccount {
        fluent_builders::AcceptDomainTransferFromAnotherAwsAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelDomainTransferToAnotherAwsAccount`](crate::client::fluent_builders::CancelDomainTransferToAnotherAwsAccount) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::CancelDomainTransferToAnotherAwsAccount::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::CancelDomainTransferToAnotherAwsAccount::set_domain_name): <p>The name of the domain for which you want to cancel the transfer to another Amazon Web Services account.</p>
    /// - On success, responds with [`CancelDomainTransferToAnotherAwsAccountOutput`](crate::output::CancelDomainTransferToAnotherAwsAccountOutput) with field(s):
    ///   - [`operation_id(Option<String>)`](crate::output::CancelDomainTransferToAnotherAwsAccountOutput::operation_id): <p>The identifier that <code>TransferDomainToAnotherAwsAccount</code> returned to track the progress of the request. Because the transfer request was canceled, the value is no longer valid, and you can't use <code>GetOperationDetail</code> to query the operation status.</p>
    /// - On failure, responds with [`SdkError<CancelDomainTransferToAnotherAwsAccountError>`](crate::error::CancelDomainTransferToAnotherAwsAccountError)
    pub fn cancel_domain_transfer_to_another_aws_account(
        &self,
    ) -> fluent_builders::CancelDomainTransferToAnotherAwsAccount {
        fluent_builders::CancelDomainTransferToAnotherAwsAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CheckDomainAvailability`](crate::client::fluent_builders::CheckDomainAvailability) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::CheckDomainAvailability::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::CheckDomainAvailability::set_domain_name): <p>The name of the domain that you want to get availability for. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>  <p>The domain name can contain only the following characters:</p>  <ul>   <li> <p>Letters a through z. Domain names are not case sensitive.</p> </li>   <li> <p>Numbers 0 through 9.</p> </li>   <li> <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p> </li>   <li> <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p> </li>  </ul>  <p>Internationalized domain names are not supported for some top-level domains. To determine whether the TLD that you want to use supports internationalized domain names, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a>. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html#domain-name-format-idns">Formatting Internationalized Domain Names</a>. </p>
    ///   - [`idn_lang_code(impl Into<String>)`](crate::client::fluent_builders::CheckDomainAvailability::idn_lang_code) / [`set_idn_lang_code(Option<String>)`](crate::client::fluent_builders::CheckDomainAvailability::set_idn_lang_code): <p>Reserved for future use.</p>
    /// - On success, responds with [`CheckDomainAvailabilityOutput`](crate::output::CheckDomainAvailabilityOutput) with field(s):
    ///   - [`availability(Option<DomainAvailability>)`](crate::output::CheckDomainAvailabilityOutput::availability): <p>Whether the domain name is available for registering.</p> <note>   <p>You can register only domains designated as <code>AVAILABLE</code>.</p>  </note>  <p>Valid values:</p>  <dl>   <dt>   AVAILABLE  </dt>   <dd>    <p>The domain name is available.</p>   </dd>   <dt>   AVAILABLE_RESERVED  </dt>   <dd>    <p>The domain name is reserved under specific conditions.</p>   </dd>   <dt>   AVAILABLE_PREORDER  </dt>   <dd>    <p>The domain name is available and can be preordered.</p>   </dd>   <dt>   DONT_KNOW  </dt>   <dd>    <p>The TLD registry didn't reply with a definitive answer about whether the domain name is available. Route 53 can return this response for a variety of reasons, for example, the registry is performing maintenance. Try again later.</p>   </dd>   <dt>   PENDING  </dt>   <dd>    <p>The TLD registry didn't return a response in the expected amount of time. When the response is delayed, it usually takes just a few extra seconds. You can resubmit the request immediately.</p>   </dd>   <dt>   RESERVED  </dt>   <dd>    <p>The domain name has been reserved for another person or organization.</p>   </dd>   <dt>   UNAVAILABLE  </dt>   <dd>    <p>The domain name is not available.</p>   </dd>   <dt>   UNAVAILABLE_PREMIUM  </dt>   <dd>    <p>The domain name is not available.</p>   </dd>   <dt>   UNAVAILABLE_RESTRICTED  </dt>   <dd>    <p>The domain name is forbidden.</p>   </dd>  </dl>
    /// - On failure, responds with [`SdkError<CheckDomainAvailabilityError>`](crate::error::CheckDomainAvailabilityError)
    pub fn check_domain_availability(&self) -> fluent_builders::CheckDomainAvailability {
        fluent_builders::CheckDomainAvailability::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CheckDomainTransferability`](crate::client::fluent_builders::CheckDomainTransferability) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::CheckDomainTransferability::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::CheckDomainTransferability::set_domain_name): <p>The name of the domain that you want to transfer to Route 53. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>  <p>The domain name can contain only the following characters:</p>  <ul>   <li> <p>Letters a through z. Domain names are not case sensitive.</p> </li>   <li> <p>Numbers 0 through 9.</p> </li>   <li> <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p> </li>   <li> <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p> </li>  </ul>
    ///   - [`auth_code(impl Into<String>)`](crate::client::fluent_builders::CheckDomainTransferability::auth_code) / [`set_auth_code(Option<String>)`](crate::client::fluent_builders::CheckDomainTransferability::set_auth_code): <p>If the registrar for the top-level domain (TLD) requires an authorization code to transfer the domain, the code that you got from the current registrar for the domain.</p>
    /// - On success, responds with [`CheckDomainTransferabilityOutput`](crate::output::CheckDomainTransferabilityOutput) with field(s):
    ///   - [`transferability(Option<DomainTransferability>)`](crate::output::CheckDomainTransferabilityOutput::transferability): <p>A complex type that contains information about whether the specified domain can be transferred to Route 53.</p>
    /// - On failure, responds with [`SdkError<CheckDomainTransferabilityError>`](crate::error::CheckDomainTransferabilityError)
    pub fn check_domain_transferability(&self) -> fluent_builders::CheckDomainTransferability {
        fluent_builders::CheckDomainTransferability::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDomain`](crate::client::fluent_builders::DeleteDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::DeleteDomain::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::DeleteDomain::set_domain_name): <p>Name of the domain to be deleted.</p>
    /// - On success, responds with [`DeleteDomainOutput`](crate::output::DeleteDomainOutput) with field(s):
    ///   - [`operation_id(Option<String>)`](crate::output::DeleteDomainOutput::operation_id): <p>Identifier for tracking the progress of the request. To query the operation status, use <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>.</p>
    /// - On failure, responds with [`SdkError<DeleteDomainError>`](crate::error::DeleteDomainError)
    pub fn delete_domain(&self) -> fluent_builders::DeleteDomain {
        fluent_builders::DeleteDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTagsForDomain`](crate::client::fluent_builders::DeleteTagsForDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::DeleteTagsForDomain::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::DeleteTagsForDomain::set_domain_name): <p>The domain for which you want to delete one or more tags.</p>
    ///   - [`tags_to_delete(Vec<String>)`](crate::client::fluent_builders::DeleteTagsForDomain::tags_to_delete) / [`set_tags_to_delete(Option<Vec<String>>)`](crate::client::fluent_builders::DeleteTagsForDomain::set_tags_to_delete): <p>A list of tag keys to delete.</p>
    /// - On success, responds with [`DeleteTagsForDomainOutput`](crate::output::DeleteTagsForDomainOutput)

    /// - On failure, responds with [`SdkError<DeleteTagsForDomainError>`](crate::error::DeleteTagsForDomainError)
    pub fn delete_tags_for_domain(&self) -> fluent_builders::DeleteTagsForDomain {
        fluent_builders::DeleteTagsForDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisableDomainAutoRenew`](crate::client::fluent_builders::DisableDomainAutoRenew) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::DisableDomainAutoRenew::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::DisableDomainAutoRenew::set_domain_name): <p>The name of the domain that you want to disable automatic renewal for.</p>
    /// - On success, responds with [`DisableDomainAutoRenewOutput`](crate::output::DisableDomainAutoRenewOutput)

    /// - On failure, responds with [`SdkError<DisableDomainAutoRenewError>`](crate::error::DisableDomainAutoRenewError)
    pub fn disable_domain_auto_renew(&self) -> fluent_builders::DisableDomainAutoRenew {
        fluent_builders::DisableDomainAutoRenew::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisableDomainTransferLock`](crate::client::fluent_builders::DisableDomainTransferLock) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::DisableDomainTransferLock::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::DisableDomainTransferLock::set_domain_name): <p>The name of the domain that you want to remove the transfer lock for.</p>
    /// - On success, responds with [`DisableDomainTransferLockOutput`](crate::output::DisableDomainTransferLockOutput) with field(s):
    ///   - [`operation_id(Option<String>)`](crate::output::DisableDomainTransferLockOutput::operation_id): <p>Identifier for tracking the progress of the request. To query the operation status, use <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>.</p>
    /// - On failure, responds with [`SdkError<DisableDomainTransferLockError>`](crate::error::DisableDomainTransferLockError)
    pub fn disable_domain_transfer_lock(&self) -> fluent_builders::DisableDomainTransferLock {
        fluent_builders::DisableDomainTransferLock::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`EnableDomainAutoRenew`](crate::client::fluent_builders::EnableDomainAutoRenew) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::EnableDomainAutoRenew::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::EnableDomainAutoRenew::set_domain_name): <p>The name of the domain that you want to enable automatic renewal for.</p>
    /// - On success, responds with [`EnableDomainAutoRenewOutput`](crate::output::EnableDomainAutoRenewOutput)

    /// - On failure, responds with [`SdkError<EnableDomainAutoRenewError>`](crate::error::EnableDomainAutoRenewError)
    pub fn enable_domain_auto_renew(&self) -> fluent_builders::EnableDomainAutoRenew {
        fluent_builders::EnableDomainAutoRenew::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`EnableDomainTransferLock`](crate::client::fluent_builders::EnableDomainTransferLock) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::EnableDomainTransferLock::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::EnableDomainTransferLock::set_domain_name): <p>The name of the domain that you want to set the transfer lock for.</p>
    /// - On success, responds with [`EnableDomainTransferLockOutput`](crate::output::EnableDomainTransferLockOutput) with field(s):
    ///   - [`operation_id(Option<String>)`](crate::output::EnableDomainTransferLockOutput::operation_id): <p>Identifier for tracking the progress of the request. To use this ID to query the operation status, use GetOperationDetail.</p>
    /// - On failure, responds with [`SdkError<EnableDomainTransferLockError>`](crate::error::EnableDomainTransferLockError)
    pub fn enable_domain_transfer_lock(&self) -> fluent_builders::EnableDomainTransferLock {
        fluent_builders::EnableDomainTransferLock::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetContactReachabilityStatus`](crate::client::fluent_builders::GetContactReachabilityStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::GetContactReachabilityStatus::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::GetContactReachabilityStatus::set_domain_name): <p>The name of the domain for which you want to know whether the registrant contact has confirmed that the email address is valid.</p>
    /// - On success, responds with [`GetContactReachabilityStatusOutput`](crate::output::GetContactReachabilityStatusOutput) with field(s):
    ///   - [`domain_name(Option<String>)`](crate::output::GetContactReachabilityStatusOutput::domain_name): <p>The domain name for which you requested the reachability status.</p>
    ///   - [`status(Option<ReachabilityStatus>)`](crate::output::GetContactReachabilityStatusOutput::status): <p>Whether the registrant contact has responded. Values include the following:</p>  <dl>   <dt>   PENDING  </dt>   <dd>    <p>We sent the confirmation email and haven't received a response yet.</p>   </dd>   <dt>   DONE  </dt>   <dd>    <p>We sent the email and got confirmation from the registrant contact.</p>   </dd>   <dt>   EXPIRED  </dt>   <dd>    <p>The time limit expired before the registrant contact responded.</p>   </dd>  </dl>
    /// - On failure, responds with [`SdkError<GetContactReachabilityStatusError>`](crate::error::GetContactReachabilityStatusError)
    pub fn get_contact_reachability_status(&self) -> fluent_builders::GetContactReachabilityStatus {
        fluent_builders::GetContactReachabilityStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDomainDetail`](crate::client::fluent_builders::GetDomainDetail) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::GetDomainDetail::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::GetDomainDetail::set_domain_name): <p>The name of the domain that you want to get detailed information about.</p>
    /// - On success, responds with [`GetDomainDetailOutput`](crate::output::GetDomainDetailOutput) with field(s):
    ///   - [`domain_name(Option<String>)`](crate::output::GetDomainDetailOutput::domain_name): <p>The name of a domain.</p>
    ///   - [`nameservers(Option<Vec<Nameserver>>)`](crate::output::GetDomainDetailOutput::nameservers): <p>The name of the domain.</p>
    ///   - [`auto_renew(Option<bool>)`](crate::output::GetDomainDetailOutput::auto_renew): <p>Specifies whether the domain registration is set to renew automatically.</p>
    ///   - [`admin_contact(Option<ContactDetail>)`](crate::output::GetDomainDetailOutput::admin_contact): <p>Provides details about the domain administrative contact.</p>
    ///   - [`registrant_contact(Option<ContactDetail>)`](crate::output::GetDomainDetailOutput::registrant_contact): <p>Provides details about the domain registrant.</p>
    ///   - [`tech_contact(Option<ContactDetail>)`](crate::output::GetDomainDetailOutput::tech_contact): <p>Provides details about the domain technical contact.</p>
    ///   - [`admin_privacy(Option<bool>)`](crate::output::GetDomainDetailOutput::admin_privacy): <p>Specifies whether contact information is concealed from WHOIS queries. If the value is <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If the value is <code>false</code>, WHOIS queries return the information that you entered for the admin contact.</p>
    ///   - [`registrant_privacy(Option<bool>)`](crate::output::GetDomainDetailOutput::registrant_privacy): <p>Specifies whether contact information is concealed from WHOIS queries. If the value is <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If the value is <code>false</code>, WHOIS queries return the information that you entered for the registrant contact (domain owner).</p>
    ///   - [`tech_privacy(Option<bool>)`](crate::output::GetDomainDetailOutput::tech_privacy): <p>Specifies whether contact information is concealed from WHOIS queries. If the value is <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If the value is <code>false</code>, WHOIS queries return the information that you entered for the technical contact.</p>
    ///   - [`registrar_name(Option<String>)`](crate::output::GetDomainDetailOutput::registrar_name): <p>Name of the registrar of the domain as identified in the registry. Domains with a .com, .net, or .org TLD are registered by Amazon Registrar. All other domains are registered by our registrar associate, Gandi. The value for domains that are registered by Gandi is <code>"GANDI SAS"</code>. </p>
    ///   - [`who_is_server(Option<String>)`](crate::output::GetDomainDetailOutput::who_is_server): <p>The fully qualified name of the WHOIS server that can answer the WHOIS query for the domain.</p>
    ///   - [`registrar_url(Option<String>)`](crate::output::GetDomainDetailOutput::registrar_url): <p>Web address of the registrar.</p>
    ///   - [`abuse_contact_email(Option<String>)`](crate::output::GetDomainDetailOutput::abuse_contact_email): <p>Email address to contact to report incorrect contact information for a domain, to report that the domain is being used to send spam, to report that someone is cybersquatting on a domain name, or report some other type of abuse.</p>
    ///   - [`abuse_contact_phone(Option<String>)`](crate::output::GetDomainDetailOutput::abuse_contact_phone): <p>Phone number for reporting abuse.</p>
    ///   - [`registry_domain_id(Option<String>)`](crate::output::GetDomainDetailOutput::registry_domain_id): <p>Reserved for future use.</p>
    ///   - [`creation_date(Option<DateTime>)`](crate::output::GetDomainDetailOutput::creation_date): <p>The date when the domain was created as found in the response to a WHOIS query. The date and time is in Unix time format and Coordinated Universal time (UTC).</p>
    ///   - [`updated_date(Option<DateTime>)`](crate::output::GetDomainDetailOutput::updated_date): <p>The last updated date of the domain as found in the response to a WHOIS query. The date and time is in Unix time format and Coordinated Universal time (UTC).</p>
    ///   - [`expiration_date(Option<DateTime>)`](crate::output::GetDomainDetailOutput::expiration_date): <p>The date when the registration for the domain is set to expire. The date and time is in Unix time format and Coordinated Universal time (UTC).</p>
    ///   - [`reseller(Option<String>)`](crate::output::GetDomainDetailOutput::reseller): <p>Reseller of the domain. Domains registered or transferred using Route 53 domains will have <code>"Amazon"</code> as the reseller. </p>
    ///   - [`dns_sec(Option<String>)`](crate::output::GetDomainDetailOutput::dns_sec): <p>Deprecated.</p>
    ///   - [`status_list(Option<Vec<String>>)`](crate::output::GetDomainDetailOutput::status_list): <p>An array of domain name status codes, also known as Extensible Provisioning Protocol (EPP) status codes.</p>  <p>ICANN, the organization that maintains a central database of domain names, has developed a set of domain name status codes that tell you the status of a variety of operations on a domain name, for example, registering a domain name, transferring a domain name to another registrar, renewing the registration for a domain name, and so on. All registrars use this same set of status codes.</p>  <p>For a current list of domain name status codes and an explanation of what each code means, go to the <a href="https://www.icann.org/">ICANN website</a> and search for <code>epp status codes</code>. (Search on the ICANN website; web searches sometimes return an old version of the document.)</p>
    /// - On failure, responds with [`SdkError<GetDomainDetailError>`](crate::error::GetDomainDetailError)
    pub fn get_domain_detail(&self) -> fluent_builders::GetDomainDetail {
        fluent_builders::GetDomainDetail::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDomainSuggestions`](crate::client::fluent_builders::GetDomainSuggestions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::GetDomainSuggestions::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::GetDomainSuggestions::set_domain_name): <p>A domain name that you want to use as the basis for a list of possible domain names. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>  <p>The domain name can contain only the following characters:</p>  <ul>   <li> <p>Letters a through z. Domain names are not case sensitive.</p> </li>   <li> <p>Numbers 0 through 9.</p> </li>   <li> <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p> </li>   <li> <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p> </li>  </ul>  <p>Internationalized domain names are not supported for some top-level domains. To determine whether the TLD that you want to use supports internationalized domain names, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a>. </p>
    ///   - [`suggestion_count(i32)`](crate::client::fluent_builders::GetDomainSuggestions::suggestion_count) / [`set_suggestion_count(i32)`](crate::client::fluent_builders::GetDomainSuggestions::set_suggestion_count): <p>The number of suggested domain names that you want Route 53 to return. Specify a value between 1 and 50.</p>
    ///   - [`only_available(bool)`](crate::client::fluent_builders::GetDomainSuggestions::only_available) / [`set_only_available(Option<bool>)`](crate::client::fluent_builders::GetDomainSuggestions::set_only_available): <p>If <code>OnlyAvailable</code> is <code>true</code>, Route 53 returns only domain names that are available. If <code>OnlyAvailable</code> is <code>false</code>, Route 53 returns domain names without checking whether they're available to be registered. To determine whether the domain is available, you can call <code>checkDomainAvailability</code> for each suggestion.</p>
    /// - On success, responds with [`GetDomainSuggestionsOutput`](crate::output::GetDomainSuggestionsOutput) with field(s):
    ///   - [`suggestions_list(Option<Vec<DomainSuggestion>>)`](crate::output::GetDomainSuggestionsOutput::suggestions_list): <p>A list of possible domain names. If you specified <code>true</code> for <code>OnlyAvailable</code> in the request, the list contains only domains that are available for registration.</p>
    /// - On failure, responds with [`SdkError<GetDomainSuggestionsError>`](crate::error::GetDomainSuggestionsError)
    pub fn get_domain_suggestions(&self) -> fluent_builders::GetDomainSuggestions {
        fluent_builders::GetDomainSuggestions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetOperationDetail`](crate::client::fluent_builders::GetOperationDetail) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`operation_id(impl Into<String>)`](crate::client::fluent_builders::GetOperationDetail::operation_id) / [`set_operation_id(Option<String>)`](crate::client::fluent_builders::GetOperationDetail::set_operation_id): <p>The identifier for the operation for which you want to get the status. Route 53 returned the identifier in the response to the original request.</p>
    /// - On success, responds with [`GetOperationDetailOutput`](crate::output::GetOperationDetailOutput) with field(s):
    ///   - [`operation_id(Option<String>)`](crate::output::GetOperationDetailOutput::operation_id): <p>The identifier for the operation.</p>
    ///   - [`status(Option<OperationStatus>)`](crate::output::GetOperationDetailOutput::status): <p>The current status of the requested operation in the system.</p>
    ///   - [`message(Option<String>)`](crate::output::GetOperationDetailOutput::message): <p>Detailed information on the status including possible errors.</p>
    ///   - [`domain_name(Option<String>)`](crate::output::GetOperationDetailOutput::domain_name): <p>The name of a domain.</p>
    ///   - [`r#type(Option<OperationType>)`](crate::output::GetOperationDetailOutput::type): <p>The type of operation that was requested.</p>
    ///   - [`submitted_date(Option<DateTime>)`](crate::output::GetOperationDetailOutput::submitted_date): <p>The date when the request was submitted.</p>
    /// - On failure, responds with [`SdkError<GetOperationDetailError>`](crate::error::GetOperationDetailError)
    pub fn get_operation_detail(&self) -> fluent_builders::GetOperationDetail {
        fluent_builders::GetOperationDetail::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDomains`](crate::client::fluent_builders::ListDomains) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDomains::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filter_conditions(Vec<FilterCondition>)`](crate::client::fluent_builders::ListDomains::filter_conditions) / [`set_filter_conditions(Option<Vec<FilterCondition>>)`](crate::client::fluent_builders::ListDomains::set_filter_conditions): <p>A complex type that contains information about the filters applied during the <code>ListDomains</code> request. The filter conditions can include domain name and domain expiration.</p>
    ///   - [`sort_condition(SortCondition)`](crate::client::fluent_builders::ListDomains::sort_condition) / [`set_sort_condition(Option<SortCondition>)`](crate::client::fluent_builders::ListDomains::set_sort_condition): <p>A complex type that contains information about the requested ordering of domains in the returned list.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListDomains::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListDomains::set_marker): <p>For an initial request for a list of domains, omit this element. If the number of domains that are associated with the current Amazon Web Services account is greater than the value that you specified for <code>MaxItems</code>, you can use <code>Marker</code> to return additional domains. Get the value of <code>NextPageMarker</code> from the previous response, and submit another request that includes the value of <code>NextPageMarker</code> in the <code>Marker</code> element.</p>  <p>Constraints: The marker must match the value specified in the previous request.</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListDomains::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListDomains::set_max_items): <p>Number of domains to be returned.</p>  <p>Default: 20</p>
    /// - On success, responds with [`ListDomainsOutput`](crate::output::ListDomainsOutput) with field(s):
    ///   - [`domains(Option<Vec<DomainSummary>>)`](crate::output::ListDomainsOutput::domains): <p>A list of domains.</p>
    ///   - [`next_page_marker(Option<String>)`](crate::output::ListDomainsOutput::next_page_marker): <p>If there are more domains than you specified for <code>MaxItems</code> in the request, submit another request and include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>.</p>
    /// - On failure, responds with [`SdkError<ListDomainsError>`](crate::error::ListDomainsError)
    pub fn list_domains(&self) -> fluent_builders::ListDomains {
        fluent_builders::ListDomains::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListOperations`](crate::client::fluent_builders::ListOperations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListOperations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`submitted_since(DateTime)`](crate::client::fluent_builders::ListOperations::submitted_since) / [`set_submitted_since(Option<DateTime>)`](crate::client::fluent_builders::ListOperations::set_submitted_since): <p>An optional parameter that lets you get information about all the operations that you submitted after a specified date and time. Specify the date and time in Unix time format and Coordinated Universal time (UTC).</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListOperations::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListOperations::set_marker): <p>For an initial request for a list of operations, omit this element. If the number of operations that are not yet complete is greater than the value that you specified for <code>MaxItems</code>, you can use <code>Marker</code> to return additional operations. Get the value of <code>NextPageMarker</code> from the previous response, and submit another request that includes the value of <code>NextPageMarker</code> in the <code>Marker</code> element.</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListOperations::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListOperations::set_max_items): <p>Number of domains to be returned.</p>  <p>Default: 20</p>
    /// - On success, responds with [`ListOperationsOutput`](crate::output::ListOperationsOutput) with field(s):
    ///   - [`operations(Option<Vec<OperationSummary>>)`](crate::output::ListOperationsOutput::operations): <p>Lists summaries of the operations.</p>
    ///   - [`next_page_marker(Option<String>)`](crate::output::ListOperationsOutput::next_page_marker): <p>If there are more operations than you specified for <code>MaxItems</code> in the request, submit another request and include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>.</p>
    /// - On failure, responds with [`SdkError<ListOperationsError>`](crate::error::ListOperationsError)
    pub fn list_operations(&self) -> fluent_builders::ListOperations {
        fluent_builders::ListOperations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPrices`](crate::client::fluent_builders::ListPrices) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPrices::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`tld(impl Into<String>)`](crate::client::fluent_builders::ListPrices::tld) / [`set_tld(Option<String>)`](crate::client::fluent_builders::ListPrices::set_tld): <p>The TLD for which you want to receive the pricing information. For example. <code>.net</code>.</p>  <p>If a <code>Tld</code> value is not provided, a list of prices for all TLDs supported by Route&nbsp;53 is returned.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListPrices::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListPrices::set_marker): <p>For an initial request for a list of prices, omit this element. If the number of prices that are not yet complete is greater than the value that you specified for <code>MaxItems</code>, you can use <code>Marker</code> to return additional prices. Get the value of <code>NextPageMarker</code> from the previous response, and submit another request that includes the value of <code>NextPageMarker</code> in the <code>Marker</code> element. </p>  <p>Used only for all TLDs. If you specify a TLD, don't specify a <code>Marker</code>.</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListPrices::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListPrices::set_max_items): <p>Number of <code>Prices</code> to be returned.</p>  <p>Used only for all TLDs. If you specify a TLD, don't specify a <code>MaxItems</code>.</p>
    /// - On success, responds with [`ListPricesOutput`](crate::output::ListPricesOutput) with field(s):
    ///   - [`prices(Option<Vec<DomainPrice>>)`](crate::output::ListPricesOutput::prices): <p>A complex type that includes all the pricing information. If you specify a TLD, this array contains only the pricing for that TLD.</p>
    ///   - [`next_page_marker(Option<String>)`](crate::output::ListPricesOutput::next_page_marker): <p>If there are more prices than you specified for <code>MaxItems</code> in the request, submit another request and include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>. </p>  <p>Used only for all TLDs. If you specify a TLD, don't specify a <code>NextPageMarker</code>.</p>
    /// - On failure, responds with [`SdkError<ListPricesError>`](crate::error::ListPricesError)
    pub fn list_prices(&self) -> fluent_builders::ListPrices {
        fluent_builders::ListPrices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForDomain`](crate::client::fluent_builders::ListTagsForDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::ListTagsForDomain::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::ListTagsForDomain::set_domain_name): <p>The domain for which you want to get a list of tags.</p>
    /// - On success, responds with [`ListTagsForDomainOutput`](crate::output::ListTagsForDomainOutput) with field(s):
    ///   - [`tag_list(Option<Vec<Tag>>)`](crate::output::ListTagsForDomainOutput::tag_list): <p>A list of the tags that are associated with the specified domain.</p>
    /// - On failure, responds with [`SdkError<ListTagsForDomainError>`](crate::error::ListTagsForDomainError)
    pub fn list_tags_for_domain(&self) -> fluent_builders::ListTagsForDomain {
        fluent_builders::ListTagsForDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RegisterDomain`](crate::client::fluent_builders::RegisterDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::RegisterDomain::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::RegisterDomain::set_domain_name): <p>The domain name that you want to register. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>  <p>The domain name can contain only the following characters:</p>  <ul>   <li> <p>Letters a through z. Domain names are not case sensitive.</p> </li>   <li> <p>Numbers 0 through 9.</p> </li>   <li> <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p> </li>   <li> <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p> </li>  </ul>  <p>Internationalized domain names are not supported for some top-level domains. To determine whether the TLD that you want to use supports internationalized domain names, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a>. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html#domain-name-format-idns">Formatting Internationalized Domain Names</a>. </p>
    ///   - [`idn_lang_code(impl Into<String>)`](crate::client::fluent_builders::RegisterDomain::idn_lang_code) / [`set_idn_lang_code(Option<String>)`](crate::client::fluent_builders::RegisterDomain::set_idn_lang_code): <p>Reserved for future use.</p>
    ///   - [`duration_in_years(i32)`](crate::client::fluent_builders::RegisterDomain::duration_in_years) / [`set_duration_in_years(Option<i32>)`](crate::client::fluent_builders::RegisterDomain::set_duration_in_years): <p>The number of years that you want to register the domain for. Domains are registered for a minimum of one year. The maximum period depends on the top-level domain. For the range of valid values for your domain, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>  <p>Default: 1</p>
    ///   - [`auto_renew(bool)`](crate::client::fluent_builders::RegisterDomain::auto_renew) / [`set_auto_renew(Option<bool>)`](crate::client::fluent_builders::RegisterDomain::set_auto_renew): <p>Indicates whether the domain will be automatically renewed (<code>true</code>) or not (<code>false</code>). Autorenewal only takes effect after the account is charged.</p>  <p>Default: <code>true</code> </p>
    ///   - [`admin_contact(ContactDetail)`](crate::client::fluent_builders::RegisterDomain::admin_contact) / [`set_admin_contact(Option<ContactDetail>)`](crate::client::fluent_builders::RegisterDomain::set_admin_contact): <p>Provides detailed contact information. For information about the values that you specify for each element, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html">ContactDetail</a>.</p>
    ///   - [`registrant_contact(ContactDetail)`](crate::client::fluent_builders::RegisterDomain::registrant_contact) / [`set_registrant_contact(Option<ContactDetail>)`](crate::client::fluent_builders::RegisterDomain::set_registrant_contact): <p>Provides detailed contact information. For information about the values that you specify for each element, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html">ContactDetail</a>.</p>
    ///   - [`tech_contact(ContactDetail)`](crate::client::fluent_builders::RegisterDomain::tech_contact) / [`set_tech_contact(Option<ContactDetail>)`](crate::client::fluent_builders::RegisterDomain::set_tech_contact): <p>Provides detailed contact information. For information about the values that you specify for each element, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html">ContactDetail</a>.</p>
    ///   - [`privacy_protect_admin_contact(bool)`](crate::client::fluent_builders::RegisterDomain::privacy_protect_admin_contact) / [`set_privacy_protect_admin_contact(Option<bool>)`](crate::client::fluent_builders::RegisterDomain::set_privacy_protect_admin_contact): <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the admin contact.</p> <note>   <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>  </note>  <p>Default: <code>true</code> </p>
    ///   - [`privacy_protect_registrant_contact(bool)`](crate::client::fluent_builders::RegisterDomain::privacy_protect_registrant_contact) / [`set_privacy_protect_registrant_contact(Option<bool>)`](crate::client::fluent_builders::RegisterDomain::set_privacy_protect_registrant_contact): <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the registrant contact (the domain owner).</p> <note>   <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>  </note>  <p>Default: <code>true</code> </p>
    ///   - [`privacy_protect_tech_contact(bool)`](crate::client::fluent_builders::RegisterDomain::privacy_protect_tech_contact) / [`set_privacy_protect_tech_contact(Option<bool>)`](crate::client::fluent_builders::RegisterDomain::set_privacy_protect_tech_contact): <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the technical contact.</p> <note>   <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>  </note>  <p>Default: <code>true</code> </p>
    /// - On success, responds with [`RegisterDomainOutput`](crate::output::RegisterDomainOutput) with field(s):
    ///   - [`operation_id(Option<String>)`](crate::output::RegisterDomainOutput::operation_id): <p>Identifier for tracking the progress of the request. To query the operation status, use <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>.</p>
    /// - On failure, responds with [`SdkError<RegisterDomainError>`](crate::error::RegisterDomainError)
    pub fn register_domain(&self) -> fluent_builders::RegisterDomain {
        fluent_builders::RegisterDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RejectDomainTransferFromAnotherAwsAccount`](crate::client::fluent_builders::RejectDomainTransferFromAnotherAwsAccount) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::RejectDomainTransferFromAnotherAwsAccount::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::RejectDomainTransferFromAnotherAwsAccount::set_domain_name): <p>The name of the domain that was specified when another Amazon Web Services account submitted a <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html">TransferDomainToAnotherAwsAccount</a> request. </p>
    /// - On success, responds with [`RejectDomainTransferFromAnotherAwsAccountOutput`](crate::output::RejectDomainTransferFromAnotherAwsAccountOutput) with field(s):
    ///   - [`operation_id(Option<String>)`](crate::output::RejectDomainTransferFromAnotherAwsAccountOutput::operation_id): <p>The identifier that <code>TransferDomainToAnotherAwsAccount</code> returned to track the progress of the request. Because the transfer request was rejected, the value is no longer valid, and you can't use <code>GetOperationDetail</code> to query the operation status.</p>
    /// - On failure, responds with [`SdkError<RejectDomainTransferFromAnotherAwsAccountError>`](crate::error::RejectDomainTransferFromAnotherAwsAccountError)
    pub fn reject_domain_transfer_from_another_aws_account(
        &self,
    ) -> fluent_builders::RejectDomainTransferFromAnotherAwsAccount {
        fluent_builders::RejectDomainTransferFromAnotherAwsAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RenewDomain`](crate::client::fluent_builders::RenewDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::RenewDomain::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::RenewDomain::set_domain_name): <p>The name of the domain that you want to renew.</p>
    ///   - [`duration_in_years(i32)`](crate::client::fluent_builders::RenewDomain::duration_in_years) / [`set_duration_in_years(Option<i32>)`](crate::client::fluent_builders::RenewDomain::set_duration_in_years): <p>The number of years that you want to renew the domain for. The maximum number of years depends on the top-level domain. For the range of valid values for your domain, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>  <p>Default: 1</p>
    ///   - [`current_expiry_year(i32)`](crate::client::fluent_builders::RenewDomain::current_expiry_year) / [`set_current_expiry_year(i32)`](crate::client::fluent_builders::RenewDomain::set_current_expiry_year): <p>The year when the registration for the domain is set to expire. This value must match the current expiration date for the domain.</p>
    /// - On success, responds with [`RenewDomainOutput`](crate::output::RenewDomainOutput) with field(s):
    ///   - [`operation_id(Option<String>)`](crate::output::RenewDomainOutput::operation_id): <p>Identifier for tracking the progress of the request. To query the operation status, use <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>.</p>
    /// - On failure, responds with [`SdkError<RenewDomainError>`](crate::error::RenewDomainError)
    pub fn renew_domain(&self) -> fluent_builders::RenewDomain {
        fluent_builders::RenewDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ResendContactReachabilityEmail`](crate::client::fluent_builders::ResendContactReachabilityEmail) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::ResendContactReachabilityEmail::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::ResendContactReachabilityEmail::set_domain_name): <p>The name of the domain for which you want Route 53 to resend a confirmation email to the registrant contact.</p>
    /// - On success, responds with [`ResendContactReachabilityEmailOutput`](crate::output::ResendContactReachabilityEmailOutput) with field(s):
    ///   - [`domain_name(Option<String>)`](crate::output::ResendContactReachabilityEmailOutput::domain_name): <p>The domain name for which you requested a confirmation email.</p>
    ///   - [`email_address(Option<String>)`](crate::output::ResendContactReachabilityEmailOutput::email_address): <p>The email address for the registrant contact at the time that we sent the verification email.</p>
    ///   - [`is_already_verified(Option<bool>)`](crate::output::ResendContactReachabilityEmailOutput::is_already_verified): <p> <code>True</code> if the email address for the registrant contact has already been verified, and <code>false</code> otherwise. If the email address has already been verified, we don't send another confirmation email.</p>
    /// - On failure, responds with [`SdkError<ResendContactReachabilityEmailError>`](crate::error::ResendContactReachabilityEmailError)
    pub fn resend_contact_reachability_email(
        &self,
    ) -> fluent_builders::ResendContactReachabilityEmail {
        fluent_builders::ResendContactReachabilityEmail::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RetrieveDomainAuthCode`](crate::client::fluent_builders::RetrieveDomainAuthCode) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::RetrieveDomainAuthCode::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::RetrieveDomainAuthCode::set_domain_name): <p>The name of the domain that you want to get an authorization code for.</p>
    /// - On success, responds with [`RetrieveDomainAuthCodeOutput`](crate::output::RetrieveDomainAuthCodeOutput) with field(s):
    ///   - [`auth_code(Option<String>)`](crate::output::RetrieveDomainAuthCodeOutput::auth_code): <p>The authorization code for the domain.</p>
    /// - On failure, responds with [`SdkError<RetrieveDomainAuthCodeError>`](crate::error::RetrieveDomainAuthCodeError)
    pub fn retrieve_domain_auth_code(&self) -> fluent_builders::RetrieveDomainAuthCode {
        fluent_builders::RetrieveDomainAuthCode::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TransferDomain`](crate::client::fluent_builders::TransferDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::TransferDomain::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::TransferDomain::set_domain_name): <p>The name of the domain that you want to transfer to Route 53. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>  <p>The domain name can contain only the following characters:</p>  <ul>   <li> <p>Letters a through z. Domain names are not case sensitive.</p> </li>   <li> <p>Numbers 0 through 9.</p> </li>   <li> <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p> </li>   <li> <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p> </li>  </ul>
    ///   - [`idn_lang_code(impl Into<String>)`](crate::client::fluent_builders::TransferDomain::idn_lang_code) / [`set_idn_lang_code(Option<String>)`](crate::client::fluent_builders::TransferDomain::set_idn_lang_code): <p>Reserved for future use.</p>
    ///   - [`duration_in_years(i32)`](crate::client::fluent_builders::TransferDomain::duration_in_years) / [`set_duration_in_years(Option<i32>)`](crate::client::fluent_builders::TransferDomain::set_duration_in_years): <p>The number of years that you want to register the domain for. Domains are registered for a minimum of one year. The maximum period depends on the top-level domain.</p>  <p>Default: 1</p>
    ///   - [`nameservers(Vec<Nameserver>)`](crate::client::fluent_builders::TransferDomain::nameservers) / [`set_nameservers(Option<Vec<Nameserver>>)`](crate::client::fluent_builders::TransferDomain::set_nameservers): <p>Contains details for the host and glue IP addresses.</p>
    ///   - [`auth_code(impl Into<String>)`](crate::client::fluent_builders::TransferDomain::auth_code) / [`set_auth_code(Option<String>)`](crate::client::fluent_builders::TransferDomain::set_auth_code): <p>The authorization code for the domain. You get this value from the current registrar.</p>
    ///   - [`auto_renew(bool)`](crate::client::fluent_builders::TransferDomain::auto_renew) / [`set_auto_renew(Option<bool>)`](crate::client::fluent_builders::TransferDomain::set_auto_renew): <p>Indicates whether the domain will be automatically renewed (true) or not (false). Autorenewal only takes effect after the account is charged.</p>  <p>Default: true</p>
    ///   - [`admin_contact(ContactDetail)`](crate::client::fluent_builders::TransferDomain::admin_contact) / [`set_admin_contact(Option<ContactDetail>)`](crate::client::fluent_builders::TransferDomain::set_admin_contact): <p>Provides detailed contact information.</p>
    ///   - [`registrant_contact(ContactDetail)`](crate::client::fluent_builders::TransferDomain::registrant_contact) / [`set_registrant_contact(Option<ContactDetail>)`](crate::client::fluent_builders::TransferDomain::set_registrant_contact): <p>Provides detailed contact information.</p>
    ///   - [`tech_contact(ContactDetail)`](crate::client::fluent_builders::TransferDomain::tech_contact) / [`set_tech_contact(Option<ContactDetail>)`](crate::client::fluent_builders::TransferDomain::set_tech_contact): <p>Provides detailed contact information.</p>
    ///   - [`privacy_protect_admin_contact(bool)`](crate::client::fluent_builders::TransferDomain::privacy_protect_admin_contact) / [`set_privacy_protect_admin_contact(Option<bool>)`](crate::client::fluent_builders::TransferDomain::set_privacy_protect_admin_contact): <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the admin contact.</p> <note>   <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>  </note>  <p>Default: <code>true</code> </p>
    ///   - [`privacy_protect_registrant_contact(bool)`](crate::client::fluent_builders::TransferDomain::privacy_protect_registrant_contact) / [`set_privacy_protect_registrant_contact(Option<bool>)`](crate::client::fluent_builders::TransferDomain::set_privacy_protect_registrant_contact): <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the registrant contact (domain owner).</p> <note>   <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>  </note>  <p>Default: <code>true</code> </p>
    ///   - [`privacy_protect_tech_contact(bool)`](crate::client::fluent_builders::TransferDomain::privacy_protect_tech_contact) / [`set_privacy_protect_tech_contact(Option<bool>)`](crate::client::fluent_builders::TransferDomain::set_privacy_protect_tech_contact): <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the technical contact.</p> <note>   <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>  </note>  <p>Default: <code>true</code> </p>
    /// - On success, responds with [`TransferDomainOutput`](crate::output::TransferDomainOutput) with field(s):
    ///   - [`operation_id(Option<String>)`](crate::output::TransferDomainOutput::operation_id): <p>Identifier for tracking the progress of the request. To query the operation status, use <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>.</p>
    /// - On failure, responds with [`SdkError<TransferDomainError>`](crate::error::TransferDomainError)
    pub fn transfer_domain(&self) -> fluent_builders::TransferDomain {
        fluent_builders::TransferDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TransferDomainToAnotherAwsAccount`](crate::client::fluent_builders::TransferDomainToAnotherAwsAccount) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::TransferDomainToAnotherAwsAccount::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::TransferDomainToAnotherAwsAccount::set_domain_name): <p>The name of the domain that you want to transfer from the current Amazon Web Services account to another account.</p>
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::TransferDomainToAnotherAwsAccount::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::TransferDomainToAnotherAwsAccount::set_account_id): <p>The account ID of the Amazon Web Services account that you want to transfer the domain to, for example, <code>111122223333</code>.</p>
    /// - On success, responds with [`TransferDomainToAnotherAwsAccountOutput`](crate::output::TransferDomainToAnotherAwsAccountOutput) with field(s):
    ///   - [`operation_id(Option<String>)`](crate::output::TransferDomainToAnotherAwsAccountOutput::operation_id): <p>Identifier for tracking the progress of the request. To query the operation status, use <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>.</p>
    ///   - [`password(Option<String>)`](crate::output::TransferDomainToAnotherAwsAccountOutput::password): <p>To finish transferring a domain to another Amazon Web Services account, the account that the domain is being transferred to must submit an <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_AcceptDomainTransferFromAnotherAwsAccount.html">AcceptDomainTransferFromAnotherAwsAccount</a> request. The request must include the value of the <code>Password</code> element that was returned in the <code>TransferDomainToAnotherAwsAccount</code> response.</p>
    /// - On failure, responds with [`SdkError<TransferDomainToAnotherAwsAccountError>`](crate::error::TransferDomainToAnotherAwsAccountError)
    pub fn transfer_domain_to_another_aws_account(
        &self,
    ) -> fluent_builders::TransferDomainToAnotherAwsAccount {
        fluent_builders::TransferDomainToAnotherAwsAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDomainContact`](crate::client::fluent_builders::UpdateDomainContact) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::UpdateDomainContact::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::UpdateDomainContact::set_domain_name): <p>The name of the domain that you want to update contact information for.</p>
    ///   - [`admin_contact(ContactDetail)`](crate::client::fluent_builders::UpdateDomainContact::admin_contact) / [`set_admin_contact(Option<ContactDetail>)`](crate::client::fluent_builders::UpdateDomainContact::set_admin_contact): <p>Provides detailed contact information.</p>
    ///   - [`registrant_contact(ContactDetail)`](crate::client::fluent_builders::UpdateDomainContact::registrant_contact) / [`set_registrant_contact(Option<ContactDetail>)`](crate::client::fluent_builders::UpdateDomainContact::set_registrant_contact): <p>Provides detailed contact information.</p>
    ///   - [`tech_contact(ContactDetail)`](crate::client::fluent_builders::UpdateDomainContact::tech_contact) / [`set_tech_contact(Option<ContactDetail>)`](crate::client::fluent_builders::UpdateDomainContact::set_tech_contact): <p>Provides detailed contact information.</p>
    /// - On success, responds with [`UpdateDomainContactOutput`](crate::output::UpdateDomainContactOutput) with field(s):
    ///   - [`operation_id(Option<String>)`](crate::output::UpdateDomainContactOutput::operation_id): <p>Identifier for tracking the progress of the request. To query the operation status, use <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>.</p>
    /// - On failure, responds with [`SdkError<UpdateDomainContactError>`](crate::error::UpdateDomainContactError)
    pub fn update_domain_contact(&self) -> fluent_builders::UpdateDomainContact {
        fluent_builders::UpdateDomainContact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDomainContactPrivacy`](crate::client::fluent_builders::UpdateDomainContactPrivacy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::UpdateDomainContactPrivacy::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::UpdateDomainContactPrivacy::set_domain_name): <p>The name of the domain that you want to update the privacy setting for.</p>
    ///   - [`admin_privacy(bool)`](crate::client::fluent_builders::UpdateDomainContactPrivacy::admin_privacy) / [`set_admin_privacy(Option<bool>)`](crate::client::fluent_builders::UpdateDomainContactPrivacy::set_admin_privacy): <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the admin contact.</p> <note>   <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>  </note>
    ///   - [`registrant_privacy(bool)`](crate::client::fluent_builders::UpdateDomainContactPrivacy::registrant_privacy) / [`set_registrant_privacy(Option<bool>)`](crate::client::fluent_builders::UpdateDomainContactPrivacy::set_registrant_privacy): <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the registrant contact (domain owner).</p> <note>   <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>  </note>
    ///   - [`tech_privacy(bool)`](crate::client::fluent_builders::UpdateDomainContactPrivacy::tech_privacy) / [`set_tech_privacy(Option<bool>)`](crate::client::fluent_builders::UpdateDomainContactPrivacy::set_tech_privacy): <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the technical contact.</p> <note>   <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>  </note>
    /// - On success, responds with [`UpdateDomainContactPrivacyOutput`](crate::output::UpdateDomainContactPrivacyOutput) with field(s):
    ///   - [`operation_id(Option<String>)`](crate::output::UpdateDomainContactPrivacyOutput::operation_id): <p>Identifier for tracking the progress of the request. To use this ID to query the operation status, use GetOperationDetail.</p>
    /// - On failure, responds with [`SdkError<UpdateDomainContactPrivacyError>`](crate::error::UpdateDomainContactPrivacyError)
    pub fn update_domain_contact_privacy(&self) -> fluent_builders::UpdateDomainContactPrivacy {
        fluent_builders::UpdateDomainContactPrivacy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDomainNameservers`](crate::client::fluent_builders::UpdateDomainNameservers) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::UpdateDomainNameservers::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::UpdateDomainNameservers::set_domain_name): <p>The name of the domain that you want to change name servers for.</p>
    ///   - [`fi_auth_key(impl Into<String>)`](crate::client::fluent_builders::UpdateDomainNameservers::fi_auth_key) / [`set_fi_auth_key(Option<String>)`](crate::client::fluent_builders::UpdateDomainNameservers::set_fi_auth_key): <p>The authorization key for .fi domains</p>
    ///   - [`nameservers(Vec<Nameserver>)`](crate::client::fluent_builders::UpdateDomainNameservers::nameservers) / [`set_nameservers(Option<Vec<Nameserver>>)`](crate::client::fluent_builders::UpdateDomainNameservers::set_nameservers): <p>A list of new name servers for the domain.</p>
    /// - On success, responds with [`UpdateDomainNameserversOutput`](crate::output::UpdateDomainNameserversOutput) with field(s):
    ///   - [`operation_id(Option<String>)`](crate::output::UpdateDomainNameserversOutput::operation_id): <p>Identifier for tracking the progress of the request. To query the operation status, use <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>.</p>
    /// - On failure, responds with [`SdkError<UpdateDomainNameserversError>`](crate::error::UpdateDomainNameserversError)
    pub fn update_domain_nameservers(&self) -> fluent_builders::UpdateDomainNameservers {
        fluent_builders::UpdateDomainNameservers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateTagsForDomain`](crate::client::fluent_builders::UpdateTagsForDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::UpdateTagsForDomain::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::UpdateTagsForDomain::set_domain_name): <p>The domain for which you want to add or update tags.</p>
    ///   - [`tags_to_update(Vec<Tag>)`](crate::client::fluent_builders::UpdateTagsForDomain::tags_to_update) / [`set_tags_to_update(Option<Vec<Tag>>)`](crate::client::fluent_builders::UpdateTagsForDomain::set_tags_to_update): <p>A list of the tag keys and values that you want to add or update. If you specify a key that already exists, the corresponding value will be replaced.</p>
    /// - On success, responds with [`UpdateTagsForDomainOutput`](crate::output::UpdateTagsForDomainOutput)

    /// - On failure, responds with [`SdkError<UpdateTagsForDomainError>`](crate::error::UpdateTagsForDomainError)
    pub fn update_tags_for_domain(&self) -> fluent_builders::UpdateTagsForDomain {
        fluent_builders::UpdateTagsForDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ViewBilling`](crate::client::fluent_builders::ViewBilling) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ViewBilling::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`start(DateTime)`](crate::client::fluent_builders::ViewBilling::start) / [`set_start(Option<DateTime>)`](crate::client::fluent_builders::ViewBilling::set_start): <p>The beginning date and time for the time period for which you want a list of billing records. Specify the date and time in Unix time format and Coordinated Universal time (UTC).</p>
    ///   - [`end(DateTime)`](crate::client::fluent_builders::ViewBilling::end) / [`set_end(Option<DateTime>)`](crate::client::fluent_builders::ViewBilling::set_end): <p>The end date and time for the time period for which you want a list of billing records. Specify the date and time in Unix time format and Coordinated Universal time (UTC).</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ViewBilling::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ViewBilling::set_marker): <p>For an initial request for a list of billing records, omit this element. If the number of billing records that are associated with the current Amazon Web Services account during the specified period is greater than the value that you specified for <code>MaxItems</code>, you can use <code>Marker</code> to return additional billing records. Get the value of <code>NextPageMarker</code> from the previous response, and submit another request that includes the value of <code>NextPageMarker</code> in the <code>Marker</code> element. </p>  <p>Constraints: The marker must match the value of <code>NextPageMarker</code> that was returned in the previous response.</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ViewBilling::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ViewBilling::set_max_items): <p>The number of billing records to be returned.</p>  <p>Default: 20</p>
    /// - On success, responds with [`ViewBillingOutput`](crate::output::ViewBillingOutput) with field(s):
    ///   - [`next_page_marker(Option<String>)`](crate::output::ViewBillingOutput::next_page_marker): <p>If there are more billing records than you specified for <code>MaxItems</code> in the request, submit another request and include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>.</p>
    ///   - [`billing_records(Option<Vec<BillingRecord>>)`](crate::output::ViewBillingOutput::billing_records): <p>A summary of billing records.</p>
    /// - On failure, responds with [`SdkError<ViewBillingError>`](crate::error::ViewBillingError)
    pub fn view_billing(&self) -> fluent_builders::ViewBilling {
        fluent_builders::ViewBilling::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AcceptDomainTransferFromAnotherAwsAccount`.
    ///
    /// <p>Accepts the transfer of a domain from another Amazon Web Services account to the currentAmazon Web Services account. You initiate a transfer between Amazon Web Services accounts using <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html">TransferDomainToAnotherAwsAccount</a>.</p>
    /// <p>If you use the CLI command at <a href="https://docs.aws.amazon.com/cli/latest/reference/route53domains/accept-domain-transfer-from-another-aws-account.html">accept-domain-transfer-from-another-aws-account</a>, use JSON format as input instead of text because otherwise CLI will throw an error from domain transfer input that includes single quotes.</p>
    /// <p>Use either <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListOperations.html">ListOperations</a> or <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a> to determine whether the operation succeeded. <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a> provides additional information, for example, <code>Domain Transfer from Aws Account 111122223333 has been cancelled</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AcceptDomainTransferFromAnotherAwsAccount {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::accept_domain_transfer_from_another_aws_account_input::Builder,
    }
    impl AcceptDomainTransferFromAnotherAwsAccount {
        /// Creates a new `AcceptDomainTransferFromAnotherAwsAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcceptDomainTransferFromAnotherAwsAccountOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AcceptDomainTransferFromAnotherAwsAccountError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that was specified when another Amazon Web Services account submitted a <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html">TransferDomainToAnotherAwsAccount</a> request. </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain that was specified when another Amazon Web Services account submitted a <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html">TransferDomainToAnotherAwsAccount</a> request. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The password that was returned by the <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html">TransferDomainToAnotherAwsAccount</a> request. </p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(input.into());
            self
        }
        /// <p>The password that was returned by the <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html">TransferDomainToAnotherAwsAccount</a> request. </p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelDomainTransferToAnotherAwsAccount`.
    ///
    /// <p>Cancels the transfer of a domain from the current Amazon Web Services account to another Amazon Web Services account. You initiate a transfer betweenAmazon Web Services accounts using <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html">TransferDomainToAnotherAwsAccount</a>. </p> <important>
    /// <p>You must cancel the transfer before the other Amazon Web Services account accepts the transfer using <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_AcceptDomainTransferFromAnotherAwsAccount.html">AcceptDomainTransferFromAnotherAwsAccount</a>.</p>
    /// </important>
    /// <p>Use either <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListOperations.html">ListOperations</a> or <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a> to determine whether the operation succeeded. <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a> provides additional information, for example, <code>Domain Transfer from Aws Account 111122223333 has been cancelled</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelDomainTransferToAnotherAwsAccount {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::cancel_domain_transfer_to_another_aws_account_input::Builder,
    }
    impl CancelDomainTransferToAnotherAwsAccount {
        /// Creates a new `CancelDomainTransferToAnotherAwsAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelDomainTransferToAnotherAwsAccountOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CancelDomainTransferToAnotherAwsAccountError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain for which you want to cancel the transfer to another Amazon Web Services account.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain for which you want to cancel the transfer to another Amazon Web Services account.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CheckDomainAvailability`.
    ///
    /// <p>This operation checks the availability of one domain name. Note that if the availability status of a domain is pending, you must submit another request to determine the availability of the domain name.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CheckDomainAvailability {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::check_domain_availability_input::Builder,
    }
    impl CheckDomainAvailability {
        /// Creates a new `CheckDomainAvailability`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CheckDomainAvailabilityOutput,
            aws_smithy_http::result::SdkError<crate::error::CheckDomainAvailabilityError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that you want to get availability for. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>The domain name can contain only the following characters:</p>
        /// <ul>
        /// <li> <p>Letters a through z. Domain names are not case sensitive.</p> </li>
        /// <li> <p>Numbers 0 through 9.</p> </li>
        /// <li> <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p> </li>
        /// <li> <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p> </li>
        /// </ul>
        /// <p>Internationalized domain names are not supported for some top-level domains. To determine whether the TLD that you want to use supports internationalized domain names, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a>. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html#domain-name-format-idns">Formatting Internationalized Domain Names</a>. </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain that you want to get availability for. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>The domain name can contain only the following characters:</p>
        /// <ul>
        /// <li> <p>Letters a through z. Domain names are not case sensitive.</p> </li>
        /// <li> <p>Numbers 0 through 9.</p> </li>
        /// <li> <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p> </li>
        /// <li> <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p> </li>
        /// </ul>
        /// <p>Internationalized domain names are not supported for some top-level domains. To determine whether the TLD that you want to use supports internationalized domain names, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a>. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html#domain-name-format-idns">Formatting Internationalized Domain Names</a>. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn idn_lang_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idn_lang_code(input.into());
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_idn_lang_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idn_lang_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CheckDomainTransferability`.
    ///
    /// <p>Checks whether a domain name can be transferred to Amazon Route 53. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CheckDomainTransferability {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::check_domain_transferability_input::Builder,
    }
    impl CheckDomainTransferability {
        /// Creates a new `CheckDomainTransferability`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CheckDomainTransferabilityOutput,
            aws_smithy_http::result::SdkError<crate::error::CheckDomainTransferabilityError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that you want to transfer to Route 53. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>The domain name can contain only the following characters:</p>
        /// <ul>
        /// <li> <p>Letters a through z. Domain names are not case sensitive.</p> </li>
        /// <li> <p>Numbers 0 through 9.</p> </li>
        /// <li> <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p> </li>
        /// <li> <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p> </li>
        /// </ul>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain that you want to transfer to Route 53. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>The domain name can contain only the following characters:</p>
        /// <ul>
        /// <li> <p>Letters a through z. Domain names are not case sensitive.</p> </li>
        /// <li> <p>Numbers 0 through 9.</p> </li>
        /// <li> <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p> </li>
        /// <li> <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p> </li>
        /// </ul>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>If the registrar for the top-level domain (TLD) requires an authorization code to transfer the domain, the code that you got from the current registrar for the domain.</p>
        pub fn auth_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.auth_code(input.into());
            self
        }
        /// <p>If the registrar for the top-level domain (TLD) requires an authorization code to transfer the domain, the code that you got from the current registrar for the domain.</p>
        pub fn set_auth_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_auth_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDomain`.
    ///
    /// <p>This operation deletes the specified domain. This action is permanent. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/domain-delete.html">Deleting a domain name registration</a>.</p>
    /// <p>To transfer the domain registration to another registrar, use the transfer process that’s provided by the registrar to which you want to transfer the registration. Otherwise, the following apply:</p>
    /// <ol>
    /// <li> <p>You can’t get a refund for the cost of a deleted domain registration.</p> </li>
    /// <li> <p>The registry for the top-level domain might hold the domain name for a brief time before releasing it for other users to register (varies by registry). </p> </li>
    /// <li> <p>When the registration has been deleted, we'll send you a confirmation to the registrant contact. The email will come from <code>noreply@domainnameverification.net</code> or <code>noreply@registrar.amazon.com</code>.</p> </li>
    /// </ol>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDomain {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_domain_input::Builder,
    }
    impl DeleteDomain {
        /// Creates a new `DeleteDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDomainError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the domain to be deleted.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>Name of the domain to be deleted.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTagsForDomain`.
    ///
    /// <p>This operation deletes the specified tags for a domain.</p>
    /// <p>All tag operations are eventually consistent; subsequent operations might not immediately represent all issued operations.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTagsForDomain {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_tags_for_domain_input::Builder,
    }
    impl DeleteTagsForDomain {
        /// Creates a new `DeleteTagsForDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTagsForDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTagsForDomainError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain for which you want to delete one or more tags.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The domain for which you want to delete one or more tags.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// Appends an item to `TagsToDelete`.
        ///
        /// To override the contents of this collection use [`set_tags_to_delete`](Self::set_tags_to_delete).
        ///
        /// <p>A list of tag keys to delete.</p>
        pub fn tags_to_delete(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tags_to_delete(input.into());
            self
        }
        /// <p>A list of tag keys to delete.</p>
        pub fn set_tags_to_delete(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tags_to_delete(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableDomainAutoRenew`.
    ///
    /// <p>This operation disables automatic renewal of domain registration for the specified domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisableDomainAutoRenew {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disable_domain_auto_renew_input::Builder,
    }
    impl DisableDomainAutoRenew {
        /// Creates a new `DisableDomainAutoRenew`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableDomainAutoRenewOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableDomainAutoRenewError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that you want to disable automatic renewal for.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain that you want to disable automatic renewal for.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableDomainTransferLock`.
    ///
    /// <p>This operation removes the transfer lock on the domain (specifically the <code>clientTransferProhibited</code> status) to allow domain transfers. We recommend you refrain from performing this action unless you intend to transfer the domain to a different registrar. Successful submission returns an operation ID that you can use to track the progress and completion of the action. If the request is not completed successfully, the domain registrant will be notified by email.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisableDomainTransferLock {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disable_domain_transfer_lock_input::Builder,
    }
    impl DisableDomainTransferLock {
        /// Creates a new `DisableDomainTransferLock`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableDomainTransferLockOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableDomainTransferLockError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that you want to remove the transfer lock for.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain that you want to remove the transfer lock for.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableDomainAutoRenew`.
    ///
    /// <p>This operation configures Amazon Route 53 to automatically renew the specified domain before the domain registration expires. The cost of renewing your domain registration is billed to your Amazon Web Services account.</p>
    /// <p>The period during which you can renew a domain name varies by TLD. For a list of TLDs and their renewal policies, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains That You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>. Route 53 requires that you renew before the end of the renewal period so we can complete processing before the deadline.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct EnableDomainAutoRenew {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::enable_domain_auto_renew_input::Builder,
    }
    impl EnableDomainAutoRenew {
        /// Creates a new `EnableDomainAutoRenew`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableDomainAutoRenewOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableDomainAutoRenewError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that you want to enable automatic renewal for.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain that you want to enable automatic renewal for.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableDomainTransferLock`.
    ///
    /// <p>This operation sets the transfer lock on the domain (specifically the <code>clientTransferProhibited</code> status) to prevent domain transfers. Successful submission returns an operation ID that you can use to track the progress and completion of the action. If the request is not completed successfully, the domain registrant will be notified by email.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct EnableDomainTransferLock {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::enable_domain_transfer_lock_input::Builder,
    }
    impl EnableDomainTransferLock {
        /// Creates a new `EnableDomainTransferLock`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableDomainTransferLockOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableDomainTransferLockError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that you want to set the transfer lock for.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain that you want to set the transfer lock for.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetContactReachabilityStatus`.
    ///
    /// <p>For operations that require confirmation that the email address for the registrant contact is valid, such as registering a new domain, this operation returns information about whether the registrant contact has responded.</p>
    /// <p>If you want us to resend the email, use the <code>ResendContactReachabilityEmail</code> operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetContactReachabilityStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_contact_reachability_status_input::Builder,
    }
    impl GetContactReachabilityStatus {
        /// Creates a new `GetContactReachabilityStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetContactReachabilityStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetContactReachabilityStatusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain for which you want to know whether the registrant contact has confirmed that the email address is valid.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain for which you want to know whether the registrant contact has confirmed that the email address is valid.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDomainDetail`.
    ///
    /// <p>This operation returns detailed information about a specified domain that is associated with the current Amazon Web Services account. Contact information for the domain is also returned as part of the output.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDomainDetail {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_domain_detail_input::Builder,
    }
    impl GetDomainDetail {
        /// Creates a new `GetDomainDetail`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDomainDetailOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDomainDetailError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that you want to get detailed information about.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain that you want to get detailed information about.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDomainSuggestions`.
    ///
    /// <p>The GetDomainSuggestions operation returns a list of suggested domain names.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDomainSuggestions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_domain_suggestions_input::Builder,
    }
    impl GetDomainSuggestions {
        /// Creates a new `GetDomainSuggestions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDomainSuggestionsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDomainSuggestionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A domain name that you want to use as the basis for a list of possible domain names. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>The domain name can contain only the following characters:</p>
        /// <ul>
        /// <li> <p>Letters a through z. Domain names are not case sensitive.</p> </li>
        /// <li> <p>Numbers 0 through 9.</p> </li>
        /// <li> <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p> </li>
        /// <li> <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p> </li>
        /// </ul>
        /// <p>Internationalized domain names are not supported for some top-level domains. To determine whether the TLD that you want to use supports internationalized domain names, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a>. </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>A domain name that you want to use as the basis for a list of possible domain names. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>The domain name can contain only the following characters:</p>
        /// <ul>
        /// <li> <p>Letters a through z. Domain names are not case sensitive.</p> </li>
        /// <li> <p>Numbers 0 through 9.</p> </li>
        /// <li> <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p> </li>
        /// <li> <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p> </li>
        /// </ul>
        /// <p>Internationalized domain names are not supported for some top-level domains. To determine whether the TLD that you want to use supports internationalized domain names, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a>. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The number of suggested domain names that you want Route 53 to return. Specify a value between 1 and 50.</p>
        pub fn suggestion_count(mut self, input: i32) -> Self {
            self.inner = self.inner.suggestion_count(input);
            self
        }
        /// <p>The number of suggested domain names that you want Route 53 to return. Specify a value between 1 and 50.</p>
        pub fn set_suggestion_count(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_suggestion_count(input);
            self
        }
        /// <p>If <code>OnlyAvailable</code> is <code>true</code>, Route 53 returns only domain names that are available. If <code>OnlyAvailable</code> is <code>false</code>, Route 53 returns domain names without checking whether they're available to be registered. To determine whether the domain is available, you can call <code>checkDomainAvailability</code> for each suggestion.</p>
        pub fn only_available(mut self, input: bool) -> Self {
            self.inner = self.inner.only_available(input);
            self
        }
        /// <p>If <code>OnlyAvailable</code> is <code>true</code>, Route 53 returns only domain names that are available. If <code>OnlyAvailable</code> is <code>false</code>, Route 53 returns domain names without checking whether they're available to be registered. To determine whether the domain is available, you can call <code>checkDomainAvailability</code> for each suggestion.</p>
        pub fn set_only_available(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_only_available(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetOperationDetail`.
    ///
    /// <p>This operation returns the current status of an operation that is not completed.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetOperationDetail {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_operation_detail_input::Builder,
    }
    impl GetOperationDetail {
        /// Creates a new `GetOperationDetail`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetOperationDetailOutput,
            aws_smithy_http::result::SdkError<crate::error::GetOperationDetailError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the operation for which you want to get the status. Route 53 returned the identifier in the response to the original request.</p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.operation_id(input.into());
            self
        }
        /// <p>The identifier for the operation for which you want to get the status. Route 53 returned the identifier in the response to the original request.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_operation_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDomains`.
    ///
    /// <p>This operation returns all the domain names registered with Amazon Route 53 for the current Amazon Web Services account if no filtering conditions are used.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDomains {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_domains_input::Builder,
    }
    impl ListDomains {
        /// Creates a new `ListDomains`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDomainsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDomainsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDomainsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDomainsPaginator {
            crate::paginator::ListDomainsPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `FilterConditions`.
        ///
        /// To override the contents of this collection use [`set_filter_conditions`](Self::set_filter_conditions).
        ///
        /// <p>A complex type that contains information about the filters applied during the <code>ListDomains</code> request. The filter conditions can include domain name and domain expiration.</p>
        pub fn filter_conditions(mut self, input: crate::model::FilterCondition) -> Self {
            self.inner = self.inner.filter_conditions(input);
            self
        }
        /// <p>A complex type that contains information about the filters applied during the <code>ListDomains</code> request. The filter conditions can include domain name and domain expiration.</p>
        pub fn set_filter_conditions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FilterCondition>>,
        ) -> Self {
            self.inner = self.inner.set_filter_conditions(input);
            self
        }
        /// <p>A complex type that contains information about the requested ordering of domains in the returned list.</p>
        pub fn sort_condition(mut self, input: crate::model::SortCondition) -> Self {
            self.inner = self.inner.sort_condition(input);
            self
        }
        /// <p>A complex type that contains information about the requested ordering of domains in the returned list.</p>
        pub fn set_sort_condition(
            mut self,
            input: std::option::Option<crate::model::SortCondition>,
        ) -> Self {
            self.inner = self.inner.set_sort_condition(input);
            self
        }
        /// <p>For an initial request for a list of domains, omit this element. If the number of domains that are associated with the current Amazon Web Services account is greater than the value that you specified for <code>MaxItems</code>, you can use <code>Marker</code> to return additional domains. Get the value of <code>NextPageMarker</code> from the previous response, and submit another request that includes the value of <code>NextPageMarker</code> in the <code>Marker</code> element.</p>
        /// <p>Constraints: The marker must match the value specified in the previous request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>For an initial request for a list of domains, omit this element. If the number of domains that are associated with the current Amazon Web Services account is greater than the value that you specified for <code>MaxItems</code>, you can use <code>Marker</code> to return additional domains. Get the value of <code>NextPageMarker</code> from the previous response, and submit another request that includes the value of <code>NextPageMarker</code> in the <code>Marker</code> element.</p>
        /// <p>Constraints: The marker must match the value specified in the previous request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Number of domains to be returned.</p>
        /// <p>Default: 20</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>Number of domains to be returned.</p>
        /// <p>Default: 20</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOperations`.
    ///
    /// <p>Returns information about all of the operations that return an operation ID and that have ever been performed on domains that were registered by the current account. </p>
    /// <p>This command runs only in the us-east-1 Region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListOperations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_operations_input::Builder,
    }
    impl ListOperations {
        /// Creates a new `ListOperations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOperationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOperationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListOperationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListOperationsPaginator {
            crate::paginator::ListOperationsPaginator::new(self.handle, self.inner)
        }
        /// <p>An optional parameter that lets you get information about all the operations that you submitted after a specified date and time. Specify the date and time in Unix time format and Coordinated Universal time (UTC).</p>
        pub fn submitted_since(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.submitted_since(input);
            self
        }
        /// <p>An optional parameter that lets you get information about all the operations that you submitted after a specified date and time. Specify the date and time in Unix time format and Coordinated Universal time (UTC).</p>
        pub fn set_submitted_since(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_submitted_since(input);
            self
        }
        /// <p>For an initial request for a list of operations, omit this element. If the number of operations that are not yet complete is greater than the value that you specified for <code>MaxItems</code>, you can use <code>Marker</code> to return additional operations. Get the value of <code>NextPageMarker</code> from the previous response, and submit another request that includes the value of <code>NextPageMarker</code> in the <code>Marker</code> element.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>For an initial request for a list of operations, omit this element. If the number of operations that are not yet complete is greater than the value that you specified for <code>MaxItems</code>, you can use <code>Marker</code> to return additional operations. Get the value of <code>NextPageMarker</code> from the previous response, and submit another request that includes the value of <code>NextPageMarker</code> in the <code>Marker</code> element.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Number of domains to be returned.</p>
        /// <p>Default: 20</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>Number of domains to be returned.</p>
        /// <p>Default: 20</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPrices`.
    ///
    /// <p>Lists the following prices for either all the TLDs supported by Route&nbsp;53, or the specified TLD:</p>
    /// <ul>
    /// <li> <p>Registration</p> </li>
    /// <li> <p>Transfer</p> </li>
    /// <li> <p>Owner change</p> </li>
    /// <li> <p>Domain renewal</p> </li>
    /// <li> <p>Domain restoration</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPrices {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_prices_input::Builder,
    }
    impl ListPrices {
        /// Creates a new `ListPrices`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPricesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPricesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPricesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPricesPaginator {
            crate::paginator::ListPricesPaginator::new(self.handle, self.inner)
        }
        /// <p>The TLD for which you want to receive the pricing information. For example. <code>.net</code>.</p>
        /// <p>If a <code>Tld</code> value is not provided, a list of prices for all TLDs supported by Route&nbsp;53 is returned.</p>
        pub fn tld(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tld(input.into());
            self
        }
        /// <p>The TLD for which you want to receive the pricing information. For example. <code>.net</code>.</p>
        /// <p>If a <code>Tld</code> value is not provided, a list of prices for all TLDs supported by Route&nbsp;53 is returned.</p>
        pub fn set_tld(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tld(input);
            self
        }
        /// <p>For an initial request for a list of prices, omit this element. If the number of prices that are not yet complete is greater than the value that you specified for <code>MaxItems</code>, you can use <code>Marker</code> to return additional prices. Get the value of <code>NextPageMarker</code> from the previous response, and submit another request that includes the value of <code>NextPageMarker</code> in the <code>Marker</code> element. </p>
        /// <p>Used only for all TLDs. If you specify a TLD, don't specify a <code>Marker</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>For an initial request for a list of prices, omit this element. If the number of prices that are not yet complete is greater than the value that you specified for <code>MaxItems</code>, you can use <code>Marker</code> to return additional prices. Get the value of <code>NextPageMarker</code> from the previous response, and submit another request that includes the value of <code>NextPageMarker</code> in the <code>Marker</code> element. </p>
        /// <p>Used only for all TLDs. If you specify a TLD, don't specify a <code>Marker</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Number of <code>Prices</code> to be returned.</p>
        /// <p>Used only for all TLDs. If you specify a TLD, don't specify a <code>MaxItems</code>.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>Number of <code>Prices</code> to be returned.</p>
        /// <p>Used only for all TLDs. If you specify a TLD, don't specify a <code>MaxItems</code>.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForDomain`.
    ///
    /// <p>This operation returns all of the tags that are associated with the specified domain.</p>
    /// <p>All tag operations are eventually consistent; subsequent operations might not immediately represent all issued operations.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForDomain {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_domain_input::Builder,
    }
    impl ListTagsForDomain {
        /// Creates a new `ListTagsForDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForDomainError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain for which you want to get a list of tags.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The domain for which you want to get a list of tags.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterDomain`.
    ///
    /// <p>This operation registers a domain. Domains are registered either by Amazon Registrar (for .com, .net, and .org domains) or by our registrar associate, Gandi (for all other domains). For some top-level domains (TLDs), this operation requires extra parameters.</p>
    /// <p>When you register a domain, Amazon Route 53 does the following:</p>
    /// <ul>
    /// <li> <p>Creates a Route 53 hosted zone that has the same name as the domain. Route 53 assigns four name servers to your hosted zone and automatically updates your domain registration with the names of these name servers.</p> </li>
    /// <li> <p>Enables autorenew, so your domain registration will renew automatically each year. We'll notify you in advance of the renewal date so you can choose whether to renew the registration.</p> </li>
    /// <li> <p>Optionally enables privacy protection, so WHOIS queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you don't enable privacy protection, WHOIS queries return the information that you entered for the administrative, registrant, and technical contacts.</p> <note>
    /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
    /// </note> </li>
    /// <li> <p>If registration is successful, returns an operation ID that you can use to track the progress and completion of the action. If the request is not completed successfully, the domain registrant is notified by email.</p> </li>
    /// <li> <p>Charges your Amazon Web Services account an amount based on the top-level domain. For more information, see <a href="http://aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a>.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RegisterDomain {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::register_domain_input::Builder,
    }
    impl RegisterDomain {
        /// Creates a new `RegisterDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterDomainError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain name that you want to register. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>The domain name can contain only the following characters:</p>
        /// <ul>
        /// <li> <p>Letters a through z. Domain names are not case sensitive.</p> </li>
        /// <li> <p>Numbers 0 through 9.</p> </li>
        /// <li> <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p> </li>
        /// <li> <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p> </li>
        /// </ul>
        /// <p>Internationalized domain names are not supported for some top-level domains. To determine whether the TLD that you want to use supports internationalized domain names, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a>. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html#domain-name-format-idns">Formatting Internationalized Domain Names</a>. </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The domain name that you want to register. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>The domain name can contain only the following characters:</p>
        /// <ul>
        /// <li> <p>Letters a through z. Domain names are not case sensitive.</p> </li>
        /// <li> <p>Numbers 0 through 9.</p> </li>
        /// <li> <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p> </li>
        /// <li> <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p> </li>
        /// </ul>
        /// <p>Internationalized domain names are not supported for some top-level domains. To determine whether the TLD that you want to use supports internationalized domain names, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a>. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html#domain-name-format-idns">Formatting Internationalized Domain Names</a>. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn idn_lang_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idn_lang_code(input.into());
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_idn_lang_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idn_lang_code(input);
            self
        }
        /// <p>The number of years that you want to register the domain for. Domains are registered for a minimum of one year. The maximum period depends on the top-level domain. For the range of valid values for your domain, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>Default: 1</p>
        pub fn duration_in_years(mut self, input: i32) -> Self {
            self.inner = self.inner.duration_in_years(input);
            self
        }
        /// <p>The number of years that you want to register the domain for. Domains are registered for a minimum of one year. The maximum period depends on the top-level domain. For the range of valid values for your domain, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>Default: 1</p>
        pub fn set_duration_in_years(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_duration_in_years(input);
            self
        }
        /// <p>Indicates whether the domain will be automatically renewed (<code>true</code>) or not (<code>false</code>). Autorenewal only takes effect after the account is charged.</p>
        /// <p>Default: <code>true</code> </p>
        pub fn auto_renew(mut self, input: bool) -> Self {
            self.inner = self.inner.auto_renew(input);
            self
        }
        /// <p>Indicates whether the domain will be automatically renewed (<code>true</code>) or not (<code>false</code>). Autorenewal only takes effect after the account is charged.</p>
        /// <p>Default: <code>true</code> </p>
        pub fn set_auto_renew(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_renew(input);
            self
        }
        /// <p>Provides detailed contact information. For information about the values that you specify for each element, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html">ContactDetail</a>.</p>
        pub fn admin_contact(mut self, input: crate::model::ContactDetail) -> Self {
            self.inner = self.inner.admin_contact(input);
            self
        }
        /// <p>Provides detailed contact information. For information about the values that you specify for each element, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html">ContactDetail</a>.</p>
        pub fn set_admin_contact(
            mut self,
            input: std::option::Option<crate::model::ContactDetail>,
        ) -> Self {
            self.inner = self.inner.set_admin_contact(input);
            self
        }
        /// <p>Provides detailed contact information. For information about the values that you specify for each element, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html">ContactDetail</a>.</p>
        pub fn registrant_contact(mut self, input: crate::model::ContactDetail) -> Self {
            self.inner = self.inner.registrant_contact(input);
            self
        }
        /// <p>Provides detailed contact information. For information about the values that you specify for each element, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html">ContactDetail</a>.</p>
        pub fn set_registrant_contact(
            mut self,
            input: std::option::Option<crate::model::ContactDetail>,
        ) -> Self {
            self.inner = self.inner.set_registrant_contact(input);
            self
        }
        /// <p>Provides detailed contact information. For information about the values that you specify for each element, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html">ContactDetail</a>.</p>
        pub fn tech_contact(mut self, input: crate::model::ContactDetail) -> Self {
            self.inner = self.inner.tech_contact(input);
            self
        }
        /// <p>Provides detailed contact information. For information about the values that you specify for each element, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html">ContactDetail</a>.</p>
        pub fn set_tech_contact(
            mut self,
            input: std::option::Option<crate::model::ContactDetail>,
        ) -> Self {
            self.inner = self.inner.set_tech_contact(input);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the admin contact.</p> <note>
        /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
        /// </note>
        /// <p>Default: <code>true</code> </p>
        pub fn privacy_protect_admin_contact(mut self, input: bool) -> Self {
            self.inner = self.inner.privacy_protect_admin_contact(input);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the admin contact.</p> <note>
        /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
        /// </note>
        /// <p>Default: <code>true</code> </p>
        pub fn set_privacy_protect_admin_contact(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_privacy_protect_admin_contact(input);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the registrant contact (the domain owner).</p> <note>
        /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
        /// </note>
        /// <p>Default: <code>true</code> </p>
        pub fn privacy_protect_registrant_contact(mut self, input: bool) -> Self {
            self.inner = self.inner.privacy_protect_registrant_contact(input);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the registrant contact (the domain owner).</p> <note>
        /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
        /// </note>
        /// <p>Default: <code>true</code> </p>
        pub fn set_privacy_protect_registrant_contact(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_privacy_protect_registrant_contact(input);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the technical contact.</p> <note>
        /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
        /// </note>
        /// <p>Default: <code>true</code> </p>
        pub fn privacy_protect_tech_contact(mut self, input: bool) -> Self {
            self.inner = self.inner.privacy_protect_tech_contact(input);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the technical contact.</p> <note>
        /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
        /// </note>
        /// <p>Default: <code>true</code> </p>
        pub fn set_privacy_protect_tech_contact(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_privacy_protect_tech_contact(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RejectDomainTransferFromAnotherAwsAccount`.
    ///
    /// <p>Rejects the transfer of a domain from another Amazon Web Services account to the current Amazon Web Services account. You initiate a transfer betweenAmazon Web Services accounts using <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html">TransferDomainToAnotherAwsAccount</a>. </p>
    /// <p>Use either <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListOperations.html">ListOperations</a> or <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a> to determine whether the operation succeeded. <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a> provides additional information, for example, <code>Domain Transfer from Aws Account 111122223333 has been cancelled</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RejectDomainTransferFromAnotherAwsAccount {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::reject_domain_transfer_from_another_aws_account_input::Builder,
    }
    impl RejectDomainTransferFromAnotherAwsAccount {
        /// Creates a new `RejectDomainTransferFromAnotherAwsAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RejectDomainTransferFromAnotherAwsAccountOutput,
            aws_smithy_http::result::SdkError<
                crate::error::RejectDomainTransferFromAnotherAwsAccountError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that was specified when another Amazon Web Services account submitted a <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html">TransferDomainToAnotherAwsAccount</a> request. </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain that was specified when another Amazon Web Services account submitted a <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html">TransferDomainToAnotherAwsAccount</a> request. </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RenewDomain`.
    ///
    /// <p>This operation renews a domain for the specified number of years. The cost of renewing your domain is billed to your Amazon Web Services account.</p>
    /// <p>We recommend that you renew your domain several weeks before the expiration date. Some TLD registries delete domains before the expiration date if you haven't renewed far enough in advance. For more information about renewing domain registration, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/domain-renew.html">Renewing Registration for a Domain</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RenewDomain {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::renew_domain_input::Builder,
    }
    impl RenewDomain {
        /// Creates a new `RenewDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RenewDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::RenewDomainError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that you want to renew.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain that you want to renew.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The number of years that you want to renew the domain for. The maximum number of years depends on the top-level domain. For the range of valid values for your domain, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>Default: 1</p>
        pub fn duration_in_years(mut self, input: i32) -> Self {
            self.inner = self.inner.duration_in_years(input);
            self
        }
        /// <p>The number of years that you want to renew the domain for. The maximum number of years depends on the top-level domain. For the range of valid values for your domain, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>Default: 1</p>
        pub fn set_duration_in_years(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_duration_in_years(input);
            self
        }
        /// <p>The year when the registration for the domain is set to expire. This value must match the current expiration date for the domain.</p>
        pub fn current_expiry_year(mut self, input: i32) -> Self {
            self.inner = self.inner.current_expiry_year(input);
            self
        }
        /// <p>The year when the registration for the domain is set to expire. This value must match the current expiration date for the domain.</p>
        pub fn set_current_expiry_year(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_current_expiry_year(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResendContactReachabilityEmail`.
    ///
    /// <p>For operations that require confirmation that the email address for the registrant contact is valid, such as registering a new domain, this operation resends the confirmation email to the current email address for the registrant contact.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ResendContactReachabilityEmail {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::resend_contact_reachability_email_input::Builder,
    }
    impl ResendContactReachabilityEmail {
        /// Creates a new `ResendContactReachabilityEmail`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResendContactReachabilityEmailOutput,
            aws_smithy_http::result::SdkError<crate::error::ResendContactReachabilityEmailError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain for which you want Route 53 to resend a confirmation email to the registrant contact.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain for which you want Route 53 to resend a confirmation email to the registrant contact.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RetrieveDomainAuthCode`.
    ///
    /// <p>This operation returns the AuthCode for the domain. To transfer a domain to another registrar, you provide this value to the new registrar.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RetrieveDomainAuthCode {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::retrieve_domain_auth_code_input::Builder,
    }
    impl RetrieveDomainAuthCode {
        /// Creates a new `RetrieveDomainAuthCode`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RetrieveDomainAuthCodeOutput,
            aws_smithy_http::result::SdkError<crate::error::RetrieveDomainAuthCodeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that you want to get an authorization code for.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain that you want to get an authorization code for.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TransferDomain`.
    ///
    /// <p>Transfers a domain from another registrar to Amazon Route 53. When the transfer is complete, the domain is registered either with Amazon Registrar (for .com, .net, and .org domains) or with our registrar associate, Gandi (for all other TLDs).</p>
    /// <p>For more information about transferring domains, see the following topics:</p>
    /// <ul>
    /// <li> <p>For transfer requirements, a detailed procedure, and information about viewing the status of a domain that you're transferring to Route 53, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/domain-transfer-to-route-53.html">Transferring Registration for a Domain to Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p> </li>
    /// <li> <p>For information about how to transfer a domain from one Amazon Web Services account to another, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html">TransferDomainToAnotherAwsAccount</a>. </p> </li>
    /// <li> <p>For information about how to transfer a domain to another domain registrar, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/domain-transfer-from-route-53.html">Transferring a Domain from Amazon Route 53 to Another Registrar</a> in the <i>Amazon Route 53 Developer Guide</i>.</p> </li>
    /// </ul>
    /// <p>If the registrar for your domain is also the DNS service provider for the domain, we highly recommend that you transfer your DNS service to Route 53 or to another DNS service provider before you transfer your registration. Some registrars provide free DNS service when you purchase a domain registration. When you transfer the registration, the previous registrar will not renew your domain registration and could end your DNS service at any time.</p> <important>
    /// <p>If the registrar for your domain is also the DNS service provider for the domain and you don't transfer DNS service to another provider, your website, email, and the web applications associated with the domain might become unavailable.</p>
    /// </important>
    /// <p>If the transfer is successful, this method returns an operation ID that you can use to track the progress and completion of the action. If the transfer doesn't complete successfully, the domain registrant will be notified by email.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TransferDomain {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::transfer_domain_input::Builder,
    }
    impl TransferDomain {
        /// Creates a new `TransferDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TransferDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::TransferDomainError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that you want to transfer to Route 53. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>The domain name can contain only the following characters:</p>
        /// <ul>
        /// <li> <p>Letters a through z. Domain names are not case sensitive.</p> </li>
        /// <li> <p>Numbers 0 through 9.</p> </li>
        /// <li> <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p> </li>
        /// <li> <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p> </li>
        /// </ul>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain that you want to transfer to Route 53. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>The domain name can contain only the following characters:</p>
        /// <ul>
        /// <li> <p>Letters a through z. Domain names are not case sensitive.</p> </li>
        /// <li> <p>Numbers 0 through 9.</p> </li>
        /// <li> <p>Hyphen (-). You can't specify a hyphen at the beginning or end of a label. </p> </li>
        /// <li> <p>Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.</p> </li>
        /// </ul>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn idn_lang_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idn_lang_code(input.into());
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_idn_lang_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idn_lang_code(input);
            self
        }
        /// <p>The number of years that you want to register the domain for. Domains are registered for a minimum of one year. The maximum period depends on the top-level domain.</p>
        /// <p>Default: 1</p>
        pub fn duration_in_years(mut self, input: i32) -> Self {
            self.inner = self.inner.duration_in_years(input);
            self
        }
        /// <p>The number of years that you want to register the domain for. Domains are registered for a minimum of one year. The maximum period depends on the top-level domain.</p>
        /// <p>Default: 1</p>
        pub fn set_duration_in_years(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_duration_in_years(input);
            self
        }
        /// Appends an item to `Nameservers`.
        ///
        /// To override the contents of this collection use [`set_nameservers`](Self::set_nameservers).
        ///
        /// <p>Contains details for the host and glue IP addresses.</p>
        pub fn nameservers(mut self, input: crate::model::Nameserver) -> Self {
            self.inner = self.inner.nameservers(input);
            self
        }
        /// <p>Contains details for the host and glue IP addresses.</p>
        pub fn set_nameservers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Nameserver>>,
        ) -> Self {
            self.inner = self.inner.set_nameservers(input);
            self
        }
        /// <p>The authorization code for the domain. You get this value from the current registrar.</p>
        pub fn auth_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.auth_code(input.into());
            self
        }
        /// <p>The authorization code for the domain. You get this value from the current registrar.</p>
        pub fn set_auth_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_auth_code(input);
            self
        }
        /// <p>Indicates whether the domain will be automatically renewed (true) or not (false). Autorenewal only takes effect after the account is charged.</p>
        /// <p>Default: true</p>
        pub fn auto_renew(mut self, input: bool) -> Self {
            self.inner = self.inner.auto_renew(input);
            self
        }
        /// <p>Indicates whether the domain will be automatically renewed (true) or not (false). Autorenewal only takes effect after the account is charged.</p>
        /// <p>Default: true</p>
        pub fn set_auto_renew(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_renew(input);
            self
        }
        /// <p>Provides detailed contact information.</p>
        pub fn admin_contact(mut self, input: crate::model::ContactDetail) -> Self {
            self.inner = self.inner.admin_contact(input);
            self
        }
        /// <p>Provides detailed contact information.</p>
        pub fn set_admin_contact(
            mut self,
            input: std::option::Option<crate::model::ContactDetail>,
        ) -> Self {
            self.inner = self.inner.set_admin_contact(input);
            self
        }
        /// <p>Provides detailed contact information.</p>
        pub fn registrant_contact(mut self, input: crate::model::ContactDetail) -> Self {
            self.inner = self.inner.registrant_contact(input);
            self
        }
        /// <p>Provides detailed contact information.</p>
        pub fn set_registrant_contact(
            mut self,
            input: std::option::Option<crate::model::ContactDetail>,
        ) -> Self {
            self.inner = self.inner.set_registrant_contact(input);
            self
        }
        /// <p>Provides detailed contact information.</p>
        pub fn tech_contact(mut self, input: crate::model::ContactDetail) -> Self {
            self.inner = self.inner.tech_contact(input);
            self
        }
        /// <p>Provides detailed contact information.</p>
        pub fn set_tech_contact(
            mut self,
            input: std::option::Option<crate::model::ContactDetail>,
        ) -> Self {
            self.inner = self.inner.set_tech_contact(input);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the admin contact.</p> <note>
        /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
        /// </note>
        /// <p>Default: <code>true</code> </p>
        pub fn privacy_protect_admin_contact(mut self, input: bool) -> Self {
            self.inner = self.inner.privacy_protect_admin_contact(input);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the admin contact.</p> <note>
        /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
        /// </note>
        /// <p>Default: <code>true</code> </p>
        pub fn set_privacy_protect_admin_contact(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_privacy_protect_admin_contact(input);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the registrant contact (domain owner).</p> <note>
        /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
        /// </note>
        /// <p>Default: <code>true</code> </p>
        pub fn privacy_protect_registrant_contact(mut self, input: bool) -> Self {
            self.inner = self.inner.privacy_protect_registrant_contact(input);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the registrant contact (domain owner).</p> <note>
        /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
        /// </note>
        /// <p>Default: <code>true</code> </p>
        pub fn set_privacy_protect_registrant_contact(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_privacy_protect_registrant_contact(input);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the technical contact.</p> <note>
        /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
        /// </note>
        /// <p>Default: <code>true</code> </p>
        pub fn privacy_protect_tech_contact(mut self, input: bool) -> Self {
            self.inner = self.inner.privacy_protect_tech_contact(input);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the technical contact.</p> <note>
        /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
        /// </note>
        /// <p>Default: <code>true</code> </p>
        pub fn set_privacy_protect_tech_contact(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_privacy_protect_tech_contact(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TransferDomainToAnotherAwsAccount`.
    ///
    /// <p>Transfers a domain from the current Amazon Web Services account to another Amazon Web Services account. Note the following:</p>
    /// <ul>
    /// <li> <p>The Amazon Web Services account that you're transferring the domain to must accept the transfer. If the other account doesn't accept the transfer within 3 days, we cancel the transfer. See <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_AcceptDomainTransferFromAnotherAwsAccount.html">AcceptDomainTransferFromAnotherAwsAccount</a>. </p> </li>
    /// <li> <p>You can cancel the transfer before the other account accepts it. See <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_CancelDomainTransferToAnotherAwsAccount.html">CancelDomainTransferToAnotherAwsAccount</a>. </p> </li>
    /// <li> <p>The other account can reject the transfer. See <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RejectDomainTransferFromAnotherAwsAccount.html">RejectDomainTransferFromAnotherAwsAccount</a>. </p> </li>
    /// </ul> <important>
    /// <p>When you transfer a domain from one Amazon Web Services account to another, Route 53 doesn't transfer the hosted zone that is associated with the domain. DNS resolution isn't affected if the domain and the hosted zone are owned by separate accounts, so transferring the hosted zone is optional. For information about transferring the hosted zone to another Amazon Web Services account, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/hosted-zones-migrating.html">Migrating a Hosted Zone to a Different Amazon Web Services Account</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
    /// </important>
    /// <p>Use either <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListOperations.html">ListOperations</a> or <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a> to determine whether the operation succeeded. <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a> provides additional information, for example, <code>Domain Transfer from Aws Account 111122223333 has been cancelled</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TransferDomainToAnotherAwsAccount {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::transfer_domain_to_another_aws_account_input::Builder,
    }
    impl TransferDomainToAnotherAwsAccount {
        /// Creates a new `TransferDomainToAnotherAwsAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TransferDomainToAnotherAwsAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::TransferDomainToAnotherAwsAccountError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that you want to transfer from the current Amazon Web Services account to another account.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain that you want to transfer from the current Amazon Web Services account to another account.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The account ID of the Amazon Web Services account that you want to transfer the domain to, for example, <code>111122223333</code>.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID of the Amazon Web Services account that you want to transfer the domain to, for example, <code>111122223333</code>.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDomainContact`.
    ///
    /// <p>This operation updates the contact information for a particular domain. You must specify information for at least one contact: registrant, administrator, or technical.</p>
    /// <p>If the update is successful, this method returns an operation ID that you can use to track the progress and completion of the action. If the request is not completed successfully, the domain registrant will be notified by email.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDomainContact {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_domain_contact_input::Builder,
    }
    impl UpdateDomainContact {
        /// Creates a new `UpdateDomainContact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDomainContactOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDomainContactError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that you want to update contact information for.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain that you want to update contact information for.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>Provides detailed contact information.</p>
        pub fn admin_contact(mut self, input: crate::model::ContactDetail) -> Self {
            self.inner = self.inner.admin_contact(input);
            self
        }
        /// <p>Provides detailed contact information.</p>
        pub fn set_admin_contact(
            mut self,
            input: std::option::Option<crate::model::ContactDetail>,
        ) -> Self {
            self.inner = self.inner.set_admin_contact(input);
            self
        }
        /// <p>Provides detailed contact information.</p>
        pub fn registrant_contact(mut self, input: crate::model::ContactDetail) -> Self {
            self.inner = self.inner.registrant_contact(input);
            self
        }
        /// <p>Provides detailed contact information.</p>
        pub fn set_registrant_contact(
            mut self,
            input: std::option::Option<crate::model::ContactDetail>,
        ) -> Self {
            self.inner = self.inner.set_registrant_contact(input);
            self
        }
        /// <p>Provides detailed contact information.</p>
        pub fn tech_contact(mut self, input: crate::model::ContactDetail) -> Self {
            self.inner = self.inner.tech_contact(input);
            self
        }
        /// <p>Provides detailed contact information.</p>
        pub fn set_tech_contact(
            mut self,
            input: std::option::Option<crate::model::ContactDetail>,
        ) -> Self {
            self.inner = self.inner.set_tech_contact(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDomainContactPrivacy`.
    ///
    /// <p>This operation updates the specified domain contact's privacy setting. When privacy protection is enabled, contact information such as email address is replaced either with contact information for Amazon Registrar (for .com, .net, and .org domains) or with contact information for our registrar associate, Gandi.</p> <note>
    /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
    /// </note>
    /// <p>This operation affects only the contact information for the specified contact type (administrative, registrant, or technical). If the request succeeds, Amazon Route 53 returns an operation ID that you can use with <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a> to track the progress and completion of the action. If the request doesn't complete successfully, the domain registrant will be notified by email.</p> <important>
    /// <p>By disabling the privacy service via API, you consent to the publication of the contact information provided for this domain via the public WHOIS database. You certify that you are the registrant of this domain name and have the authority to make this decision. You may withdraw your consent at any time by enabling privacy protection using either <code>UpdateDomainContactPrivacy</code> or the Route 53 console. Enabling privacy protection removes the contact information provided for this domain from the WHOIS database. For more information on our privacy practices, see <a href="https://aws.amazon.com/privacy/">https://aws.amazon.com/privacy/</a>.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDomainContactPrivacy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_domain_contact_privacy_input::Builder,
    }
    impl UpdateDomainContactPrivacy {
        /// Creates a new `UpdateDomainContactPrivacy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDomainContactPrivacyOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDomainContactPrivacyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that you want to update the privacy setting for.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain that you want to update the privacy setting for.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the admin contact.</p> <note>
        /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
        /// </note>
        pub fn admin_privacy(mut self, input: bool) -> Self {
            self.inner = self.inner.admin_privacy(input);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the admin contact.</p> <note>
        /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
        /// </note>
        pub fn set_admin_privacy(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_admin_privacy(input);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the registrant contact (domain owner).</p> <note>
        /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
        /// </note>
        pub fn registrant_privacy(mut self, input: bool) -> Self {
            self.inner = self.inner.registrant_privacy(input);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the registrant contact (domain owner).</p> <note>
        /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
        /// </note>
        pub fn set_registrant_privacy(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_registrant_privacy(input);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the technical contact.</p> <note>
        /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
        /// </note>
        pub fn tech_privacy(mut self, input: bool) -> Self {
            self.inner = self.inner.tech_privacy(input);
            self
        }
        /// <p>Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return the information that you entered for the technical contact.</p> <note>
        /// <p>You must specify the same privacy setting for the administrative, registrant, and technical contacts.</p>
        /// </note>
        pub fn set_tech_privacy(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_tech_privacy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDomainNameservers`.
    ///
    /// <p>This operation replaces the current set of name servers for the domain with the specified set of name servers. If you use Amazon Route 53 as your DNS service, specify the four name servers in the delegation set for the hosted zone for the domain.</p>
    /// <p>If successful, this operation returns an operation ID that you can use to track the progress and completion of the action. If the request is not completed successfully, the domain registrant will be notified by email.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDomainNameservers {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_domain_nameservers_input::Builder,
    }
    impl UpdateDomainNameservers {
        /// Creates a new `UpdateDomainNameservers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDomainNameserversOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDomainNameserversError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that you want to change name servers for.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The name of the domain that you want to change name servers for.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The authorization key for .fi domains</p>
        pub fn fi_auth_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fi_auth_key(input.into());
            self
        }
        /// <p>The authorization key for .fi domains</p>
        pub fn set_fi_auth_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fi_auth_key(input);
            self
        }
        /// Appends an item to `Nameservers`.
        ///
        /// To override the contents of this collection use [`set_nameservers`](Self::set_nameservers).
        ///
        /// <p>A list of new name servers for the domain.</p>
        pub fn nameservers(mut self, input: crate::model::Nameserver) -> Self {
            self.inner = self.inner.nameservers(input);
            self
        }
        /// <p>A list of new name servers for the domain.</p>
        pub fn set_nameservers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Nameserver>>,
        ) -> Self {
            self.inner = self.inner.set_nameservers(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTagsForDomain`.
    ///
    /// <p>This operation adds or updates tags for a specified domain.</p>
    /// <p>All tag operations are eventually consistent; subsequent operations might not immediately represent all issued operations.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateTagsForDomain {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_tags_for_domain_input::Builder,
    }
    impl UpdateTagsForDomain {
        /// Creates a new `UpdateTagsForDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTagsForDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTagsForDomainError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain for which you want to add or update tags.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The domain for which you want to add or update tags.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// Appends an item to `TagsToUpdate`.
        ///
        /// To override the contents of this collection use [`set_tags_to_update`](Self::set_tags_to_update).
        ///
        /// <p>A list of the tag keys and values that you want to add or update. If you specify a key that already exists, the corresponding value will be replaced.</p>
        pub fn tags_to_update(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags_to_update(input);
            self
        }
        /// <p>A list of the tag keys and values that you want to add or update. If you specify a key that already exists, the corresponding value will be replaced.</p>
        pub fn set_tags_to_update(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags_to_update(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ViewBilling`.
    ///
    /// <p>Returns all the domain-related billing records for the current Amazon Web Services account for a specified period</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ViewBilling {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::view_billing_input::Builder,
    }
    impl ViewBilling {
        /// Creates a new `ViewBilling`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ViewBillingOutput,
            aws_smithy_http::result::SdkError<crate::error::ViewBillingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ViewBillingPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ViewBillingPaginator {
            crate::paginator::ViewBillingPaginator::new(self.handle, self.inner)
        }
        /// <p>The beginning date and time for the time period for which you want a list of billing records. Specify the date and time in Unix time format and Coordinated Universal time (UTC).</p>
        pub fn start(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start(input);
            self
        }
        /// <p>The beginning date and time for the time period for which you want a list of billing records. Specify the date and time in Unix time format and Coordinated Universal time (UTC).</p>
        pub fn set_start(mut self, input: std::option::Option<aws_smithy_types::DateTime>) -> Self {
            self.inner = self.inner.set_start(input);
            self
        }
        /// <p>The end date and time for the time period for which you want a list of billing records. Specify the date and time in Unix time format and Coordinated Universal time (UTC).</p>
        pub fn end(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end(input);
            self
        }
        /// <p>The end date and time for the time period for which you want a list of billing records. Specify the date and time in Unix time format and Coordinated Universal time (UTC).</p>
        pub fn set_end(mut self, input: std::option::Option<aws_smithy_types::DateTime>) -> Self {
            self.inner = self.inner.set_end(input);
            self
        }
        /// <p>For an initial request for a list of billing records, omit this element. If the number of billing records that are associated with the current Amazon Web Services account during the specified period is greater than the value that you specified for <code>MaxItems</code>, you can use <code>Marker</code> to return additional billing records. Get the value of <code>NextPageMarker</code> from the previous response, and submit another request that includes the value of <code>NextPageMarker</code> in the <code>Marker</code> element. </p>
        /// <p>Constraints: The marker must match the value of <code>NextPageMarker</code> that was returned in the previous response.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>For an initial request for a list of billing records, omit this element. If the number of billing records that are associated with the current Amazon Web Services account during the specified period is greater than the value that you specified for <code>MaxItems</code>, you can use <code>Marker</code> to return additional billing records. Get the value of <code>NextPageMarker</code> from the previous response, and submit another request that includes the value of <code>NextPageMarker</code> in the <code>Marker</code> element. </p>
        /// <p>Constraints: The marker must match the value of <code>NextPageMarker</code> that was returned in the previous response.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The number of billing records to be returned.</p>
        /// <p>Default: 20</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The number of billing records to be returned.</p>
        /// <p>Default: 20</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
