// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>The ViewBilling response includes the following elements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ViewBillingOutput {
    /// <p>If there are more billing records than you specified for <code>MaxItems</code> in the request, submit another
    /// request and include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>.</p>
    pub next_page_marker: std::option::Option<std::string::String>,
    /// <p>A summary of billing records.</p>
    pub billing_records: std::option::Option<std::vec::Vec<crate::model::BillingRecord>>,
}
impl ViewBillingOutput {
    /// <p>If there are more billing records than you specified for <code>MaxItems</code> in the request, submit another
    /// request and include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>.</p>
    pub fn next_page_marker(&self) -> std::option::Option<&str> {
        self.next_page_marker.as_deref()
    }
    /// <p>A summary of billing records.</p>
    pub fn billing_records(&self) -> std::option::Option<&[crate::model::BillingRecord]> {
        self.billing_records.as_deref()
    }
}
impl std::fmt::Debug for ViewBillingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ViewBillingOutput");
        formatter.field("next_page_marker", &self.next_page_marker);
        formatter.field("billing_records", &self.billing_records);
        formatter.finish()
    }
}
/// See [`ViewBillingOutput`](crate::output::ViewBillingOutput)
pub mod view_billing_output {
    /// A builder for [`ViewBillingOutput`](crate::output::ViewBillingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_page_marker: std::option::Option<std::string::String>,
        pub(crate) billing_records: std::option::Option<std::vec::Vec<crate::model::BillingRecord>>,
    }
    impl Builder {
        /// <p>If there are more billing records than you specified for <code>MaxItems</code> in the request, submit another
        /// request and include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>.</p>
        pub fn next_page_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_marker = Some(input.into());
            self
        }
        /// <p>If there are more billing records than you specified for <code>MaxItems</code> in the request, submit another
        /// request and include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>.</p>
        pub fn set_next_page_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_marker = input;
            self
        }
        /// Appends an item to `billing_records`.
        ///
        /// To override the contents of this collection use [`set_billing_records`](Self::set_billing_records).
        ///
        /// <p>A summary of billing records.</p>
        pub fn billing_records(mut self, input: impl Into<crate::model::BillingRecord>) -> Self {
            let mut v = self.billing_records.unwrap_or_default();
            v.push(input.into());
            self.billing_records = Some(v);
            self
        }
        /// <p>A summary of billing records.</p>
        pub fn set_billing_records(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BillingRecord>>,
        ) -> Self {
            self.billing_records = input;
            self
        }
        /// Consumes the builder and constructs a [`ViewBillingOutput`](crate::output::ViewBillingOutput)
        pub fn build(self) -> crate::output::ViewBillingOutput {
            crate::output::ViewBillingOutput {
                next_page_marker: self.next_page_marker,
                billing_records: self.billing_records,
            }
        }
    }
}
impl ViewBillingOutput {
    /// Creates a new builder-style object to manufacture [`ViewBillingOutput`](crate::output::ViewBillingOutput)
    pub fn builder() -> crate::output::view_billing_output::Builder {
        crate::output::view_billing_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTagsForDomainOutput {}
impl std::fmt::Debug for UpdateTagsForDomainOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTagsForDomainOutput");
        formatter.finish()
    }
}
/// See [`UpdateTagsForDomainOutput`](crate::output::UpdateTagsForDomainOutput)
pub mod update_tags_for_domain_output {
    /// A builder for [`UpdateTagsForDomainOutput`](crate::output::UpdateTagsForDomainOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateTagsForDomainOutput`](crate::output::UpdateTagsForDomainOutput)
        pub fn build(self) -> crate::output::UpdateTagsForDomainOutput {
            crate::output::UpdateTagsForDomainOutput {}
        }
    }
}
impl UpdateTagsForDomainOutput {
    /// Creates a new builder-style object to manufacture [`UpdateTagsForDomainOutput`](crate::output::UpdateTagsForDomainOutput)
    pub fn builder() -> crate::output::update_tags_for_domain_output::Builder {
        crate::output::update_tags_for_domain_output::Builder::default()
    }
}

/// <p>The UpdateDomainNameservers response includes the following element.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDomainNameserversOutput {
    /// <p>Identifier for tracking the progress of the request. To query the operation status, use
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>.</p>
    pub operation_id: std::option::Option<std::string::String>,
}
impl UpdateDomainNameserversOutput {
    /// <p>Identifier for tracking the progress of the request. To query the operation status, use
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>.</p>
    pub fn operation_id(&self) -> std::option::Option<&str> {
        self.operation_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateDomainNameserversOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDomainNameserversOutput");
        formatter.field("operation_id", &self.operation_id);
        formatter.finish()
    }
}
/// See [`UpdateDomainNameserversOutput`](crate::output::UpdateDomainNameserversOutput)
pub mod update_domain_nameservers_output {
    /// A builder for [`UpdateDomainNameserversOutput`](crate::output::UpdateDomainNameserversOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Identifier for tracking the progress of the request. To query the operation status, use
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>.</p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>Identifier for tracking the progress of the request. To query the operation status, use
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDomainNameserversOutput`](crate::output::UpdateDomainNameserversOutput)
        pub fn build(self) -> crate::output::UpdateDomainNameserversOutput {
            crate::output::UpdateDomainNameserversOutput {
                operation_id: self.operation_id,
            }
        }
    }
}
impl UpdateDomainNameserversOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDomainNameserversOutput`](crate::output::UpdateDomainNameserversOutput)
    pub fn builder() -> crate::output::update_domain_nameservers_output::Builder {
        crate::output::update_domain_nameservers_output::Builder::default()
    }
}

/// <p>The UpdateDomainContactPrivacy response includes the following element.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDomainContactPrivacyOutput {
    /// <p>Identifier for tracking the progress of the request. To use this ID to query the operation status, use GetOperationDetail.</p>
    pub operation_id: std::option::Option<std::string::String>,
}
impl UpdateDomainContactPrivacyOutput {
    /// <p>Identifier for tracking the progress of the request. To use this ID to query the operation status, use GetOperationDetail.</p>
    pub fn operation_id(&self) -> std::option::Option<&str> {
        self.operation_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateDomainContactPrivacyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDomainContactPrivacyOutput");
        formatter.field("operation_id", &self.operation_id);
        formatter.finish()
    }
}
/// See [`UpdateDomainContactPrivacyOutput`](crate::output::UpdateDomainContactPrivacyOutput)
pub mod update_domain_contact_privacy_output {
    /// A builder for [`UpdateDomainContactPrivacyOutput`](crate::output::UpdateDomainContactPrivacyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Identifier for tracking the progress of the request. To use this ID to query the operation status, use GetOperationDetail.</p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>Identifier for tracking the progress of the request. To use this ID to query the operation status, use GetOperationDetail.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDomainContactPrivacyOutput`](crate::output::UpdateDomainContactPrivacyOutput)
        pub fn build(self) -> crate::output::UpdateDomainContactPrivacyOutput {
            crate::output::UpdateDomainContactPrivacyOutput {
                operation_id: self.operation_id,
            }
        }
    }
}
impl UpdateDomainContactPrivacyOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDomainContactPrivacyOutput`](crate::output::UpdateDomainContactPrivacyOutput)
    pub fn builder() -> crate::output::update_domain_contact_privacy_output::Builder {
        crate::output::update_domain_contact_privacy_output::Builder::default()
    }
}

/// <p>The UpdateDomainContact response includes the following element.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDomainContactOutput {
    /// <p>Identifier for tracking the progress of the request. To query the operation status, use
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>.</p>
    pub operation_id: std::option::Option<std::string::String>,
}
impl UpdateDomainContactOutput {
    /// <p>Identifier for tracking the progress of the request. To query the operation status, use
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>.</p>
    pub fn operation_id(&self) -> std::option::Option<&str> {
        self.operation_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateDomainContactOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDomainContactOutput");
        formatter.field("operation_id", &self.operation_id);
        formatter.finish()
    }
}
/// See [`UpdateDomainContactOutput`](crate::output::UpdateDomainContactOutput)
pub mod update_domain_contact_output {
    /// A builder for [`UpdateDomainContactOutput`](crate::output::UpdateDomainContactOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Identifier for tracking the progress of the request. To query the operation status, use
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>.</p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>Identifier for tracking the progress of the request. To query the operation status, use
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDomainContactOutput`](crate::output::UpdateDomainContactOutput)
        pub fn build(self) -> crate::output::UpdateDomainContactOutput {
            crate::output::UpdateDomainContactOutput {
                operation_id: self.operation_id,
            }
        }
    }
}
impl UpdateDomainContactOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDomainContactOutput`](crate::output::UpdateDomainContactOutput)
    pub fn builder() -> crate::output::update_domain_contact_output::Builder {
        crate::output::update_domain_contact_output::Builder::default()
    }
}

/// <p>The <code>TransferDomainToAnotherAwsAccount</code> response includes the following elements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TransferDomainToAnotherAwsAccountOutput {
    /// <p>Identifier for tracking the progress of the request. To query the operation status, use
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>.</p>
    pub operation_id: std::option::Option<std::string::String>,
    /// <p>To finish transferring a domain to another AWS account, the account that the domain is being transferred to must submit an
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_AcceptDomainTransferFromAnotherAwsAccount.html">AcceptDomainTransferFromAnotherAwsAccount</a>
    /// request. The request must include the value of the <code>Password</code> element that was returned in the
    /// <code>TransferDomainToAnotherAwsAccount</code> response.</p>
    pub password: std::option::Option<std::string::String>,
}
impl TransferDomainToAnotherAwsAccountOutput {
    /// <p>Identifier for tracking the progress of the request. To query the operation status, use
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>.</p>
    pub fn operation_id(&self) -> std::option::Option<&str> {
        self.operation_id.as_deref()
    }
    /// <p>To finish transferring a domain to another AWS account, the account that the domain is being transferred to must submit an
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_AcceptDomainTransferFromAnotherAwsAccount.html">AcceptDomainTransferFromAnotherAwsAccount</a>
    /// request. The request must include the value of the <code>Password</code> element that was returned in the
    /// <code>TransferDomainToAnotherAwsAccount</code> response.</p>
    pub fn password(&self) -> std::option::Option<&str> {
        self.password.as_deref()
    }
}
impl std::fmt::Debug for TransferDomainToAnotherAwsAccountOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TransferDomainToAnotherAwsAccountOutput");
        formatter.field("operation_id", &self.operation_id);
        formatter.field("password", &self.password);
        formatter.finish()
    }
}
/// See [`TransferDomainToAnotherAwsAccountOutput`](crate::output::TransferDomainToAnotherAwsAccountOutput)
pub mod transfer_domain_to_another_aws_account_output {
    /// A builder for [`TransferDomainToAnotherAwsAccountOutput`](crate::output::TransferDomainToAnotherAwsAccountOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operation_id: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Identifier for tracking the progress of the request. To query the operation status, use
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>.</p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>Identifier for tracking the progress of the request. To query the operation status, use
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// <p>To finish transferring a domain to another AWS account, the account that the domain is being transferred to must submit an
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_AcceptDomainTransferFromAnotherAwsAccount.html">AcceptDomainTransferFromAnotherAwsAccount</a>
        /// request. The request must include the value of the <code>Password</code> element that was returned in the
        /// <code>TransferDomainToAnotherAwsAccount</code> response.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>To finish transferring a domain to another AWS account, the account that the domain is being transferred to must submit an
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_AcceptDomainTransferFromAnotherAwsAccount.html">AcceptDomainTransferFromAnotherAwsAccount</a>
        /// request. The request must include the value of the <code>Password</code> element that was returned in the
        /// <code>TransferDomainToAnotherAwsAccount</code> response.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// Consumes the builder and constructs a [`TransferDomainToAnotherAwsAccountOutput`](crate::output::TransferDomainToAnotherAwsAccountOutput)
        pub fn build(self) -> crate::output::TransferDomainToAnotherAwsAccountOutput {
            crate::output::TransferDomainToAnotherAwsAccountOutput {
                operation_id: self.operation_id,
                password: self.password,
            }
        }
    }
}
impl TransferDomainToAnotherAwsAccountOutput {
    /// Creates a new builder-style object to manufacture [`TransferDomainToAnotherAwsAccountOutput`](crate::output::TransferDomainToAnotherAwsAccountOutput)
    pub fn builder() -> crate::output::transfer_domain_to_another_aws_account_output::Builder {
        crate::output::transfer_domain_to_another_aws_account_output::Builder::default()
    }
}

/// <p>The TransferDomain response includes the following element.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TransferDomainOutput {
    /// <p>Identifier for tracking the progress of the request. To query the operation status, use
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>.</p>
    pub operation_id: std::option::Option<std::string::String>,
}
impl TransferDomainOutput {
    /// <p>Identifier for tracking the progress of the request. To query the operation status, use
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>.</p>
    pub fn operation_id(&self) -> std::option::Option<&str> {
        self.operation_id.as_deref()
    }
}
impl std::fmt::Debug for TransferDomainOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TransferDomainOutput");
        formatter.field("operation_id", &self.operation_id);
        formatter.finish()
    }
}
/// See [`TransferDomainOutput`](crate::output::TransferDomainOutput)
pub mod transfer_domain_output {
    /// A builder for [`TransferDomainOutput`](crate::output::TransferDomainOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Identifier for tracking the progress of the request. To query the operation status, use
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>.</p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>Identifier for tracking the progress of the request. To query the operation status, use
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`TransferDomainOutput`](crate::output::TransferDomainOutput)
        pub fn build(self) -> crate::output::TransferDomainOutput {
            crate::output::TransferDomainOutput {
                operation_id: self.operation_id,
            }
        }
    }
}
impl TransferDomainOutput {
    /// Creates a new builder-style object to manufacture [`TransferDomainOutput`](crate::output::TransferDomainOutput)
    pub fn builder() -> crate::output::transfer_domain_output::Builder {
        crate::output::transfer_domain_output::Builder::default()
    }
}

/// <p>The RetrieveDomainAuthCode response includes the following element.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RetrieveDomainAuthCodeOutput {
    /// <p>The authorization code for the domain.</p>
    pub auth_code: std::option::Option<std::string::String>,
}
impl RetrieveDomainAuthCodeOutput {
    /// <p>The authorization code for the domain.</p>
    pub fn auth_code(&self) -> std::option::Option<&str> {
        self.auth_code.as_deref()
    }
}
impl std::fmt::Debug for RetrieveDomainAuthCodeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RetrieveDomainAuthCodeOutput");
        formatter.field("auth_code", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`RetrieveDomainAuthCodeOutput`](crate::output::RetrieveDomainAuthCodeOutput)
pub mod retrieve_domain_auth_code_output {
    /// A builder for [`RetrieveDomainAuthCodeOutput`](crate::output::RetrieveDomainAuthCodeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auth_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The authorization code for the domain.</p>
        pub fn auth_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.auth_code = Some(input.into());
            self
        }
        /// <p>The authorization code for the domain.</p>
        pub fn set_auth_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.auth_code = input;
            self
        }
        /// Consumes the builder and constructs a [`RetrieveDomainAuthCodeOutput`](crate::output::RetrieveDomainAuthCodeOutput)
        pub fn build(self) -> crate::output::RetrieveDomainAuthCodeOutput {
            crate::output::RetrieveDomainAuthCodeOutput {
                auth_code: self.auth_code,
            }
        }
    }
}
impl RetrieveDomainAuthCodeOutput {
    /// Creates a new builder-style object to manufacture [`RetrieveDomainAuthCodeOutput`](crate::output::RetrieveDomainAuthCodeOutput)
    pub fn builder() -> crate::output::retrieve_domain_auth_code_output::Builder {
        crate::output::retrieve_domain_auth_code_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResendContactReachabilityEmailOutput {
    /// <p>The domain name for which you requested a confirmation email.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The email address for the registrant contact at the time that we sent the verification email.</p>
    pub email_address: std::option::Option<std::string::String>,
    /// <p>
    /// <code>True</code> if the email address for the registrant contact has already been verified, and <code>false</code> otherwise.
    /// If the email address has already been verified, we don't send another confirmation email.</p>
    pub is_already_verified: std::option::Option<bool>,
}
impl ResendContactReachabilityEmailOutput {
    /// <p>The domain name for which you requested a confirmation email.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The email address for the registrant contact at the time that we sent the verification email.</p>
    pub fn email_address(&self) -> std::option::Option<&str> {
        self.email_address.as_deref()
    }
    /// <p>
    /// <code>True</code> if the email address for the registrant contact has already been verified, and <code>false</code> otherwise.
    /// If the email address has already been verified, we don't send another confirmation email.</p>
    pub fn is_already_verified(&self) -> std::option::Option<bool> {
        self.is_already_verified
    }
}
impl std::fmt::Debug for ResendContactReachabilityEmailOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResendContactReachabilityEmailOutput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("email_address", &self.email_address);
        formatter.field("is_already_verified", &self.is_already_verified);
        formatter.finish()
    }
}
/// See [`ResendContactReachabilityEmailOutput`](crate::output::ResendContactReachabilityEmailOutput)
pub mod resend_contact_reachability_email_output {
    /// A builder for [`ResendContactReachabilityEmailOutput`](crate::output::ResendContactReachabilityEmailOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) email_address: std::option::Option<std::string::String>,
        pub(crate) is_already_verified: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The domain name for which you requested a confirmation email.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain name for which you requested a confirmation email.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The email address for the registrant contact at the time that we sent the verification email.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_address = Some(input.into());
            self
        }
        /// <p>The email address for the registrant contact at the time that we sent the verification email.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_address = input;
            self
        }
        /// <p>
        /// <code>True</code> if the email address for the registrant contact has already been verified, and <code>false</code> otherwise.
        /// If the email address has already been verified, we don't send another confirmation email.</p>
        pub fn is_already_verified(mut self, input: bool) -> Self {
            self.is_already_verified = Some(input);
            self
        }
        /// <p>
        /// <code>True</code> if the email address for the registrant contact has already been verified, and <code>false</code> otherwise.
        /// If the email address has already been verified, we don't send another confirmation email.</p>
        pub fn set_is_already_verified(mut self, input: std::option::Option<bool>) -> Self {
            self.is_already_verified = input;
            self
        }
        /// Consumes the builder and constructs a [`ResendContactReachabilityEmailOutput`](crate::output::ResendContactReachabilityEmailOutput)
        pub fn build(self) -> crate::output::ResendContactReachabilityEmailOutput {
            crate::output::ResendContactReachabilityEmailOutput {
                domain_name: self.domain_name,
                email_address: self.email_address,
                is_already_verified: self.is_already_verified,
            }
        }
    }
}
impl ResendContactReachabilityEmailOutput {
    /// Creates a new builder-style object to manufacture [`ResendContactReachabilityEmailOutput`](crate::output::ResendContactReachabilityEmailOutput)
    pub fn builder() -> crate::output::resend_contact_reachability_email_output::Builder {
        crate::output::resend_contact_reachability_email_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RenewDomainOutput {
    /// <p>Identifier for tracking the progress of the request. To query the operation status, use
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>.</p>
    pub operation_id: std::option::Option<std::string::String>,
}
impl RenewDomainOutput {
    /// <p>Identifier for tracking the progress of the request. To query the operation status, use
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>.</p>
    pub fn operation_id(&self) -> std::option::Option<&str> {
        self.operation_id.as_deref()
    }
}
impl std::fmt::Debug for RenewDomainOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RenewDomainOutput");
        formatter.field("operation_id", &self.operation_id);
        formatter.finish()
    }
}
/// See [`RenewDomainOutput`](crate::output::RenewDomainOutput)
pub mod renew_domain_output {
    /// A builder for [`RenewDomainOutput`](crate::output::RenewDomainOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Identifier for tracking the progress of the request. To query the operation status, use
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>.</p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>Identifier for tracking the progress of the request. To query the operation status, use
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RenewDomainOutput`](crate::output::RenewDomainOutput)
        pub fn build(self) -> crate::output::RenewDomainOutput {
            crate::output::RenewDomainOutput {
                operation_id: self.operation_id,
            }
        }
    }
}
impl RenewDomainOutput {
    /// Creates a new builder-style object to manufacture [`RenewDomainOutput`](crate::output::RenewDomainOutput)
    pub fn builder() -> crate::output::renew_domain_output::Builder {
        crate::output::renew_domain_output::Builder::default()
    }
}

/// <p>The RejectDomainTransferFromAnotherAwsAccount response includes the following element.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RejectDomainTransferFromAnotherAwsAccountOutput {
    /// <p>The identifier that <code>TransferDomainToAnotherAwsAccount</code> returned to track the progress of the request.
    /// Because the transfer request was rejected, the value is no longer valid, and you can't use <code>GetOperationDetail</code>
    /// to query the operation status.</p>
    pub operation_id: std::option::Option<std::string::String>,
}
impl RejectDomainTransferFromAnotherAwsAccountOutput {
    /// <p>The identifier that <code>TransferDomainToAnotherAwsAccount</code> returned to track the progress of the request.
    /// Because the transfer request was rejected, the value is no longer valid, and you can't use <code>GetOperationDetail</code>
    /// to query the operation status.</p>
    pub fn operation_id(&self) -> std::option::Option<&str> {
        self.operation_id.as_deref()
    }
}
impl std::fmt::Debug for RejectDomainTransferFromAnotherAwsAccountOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RejectDomainTransferFromAnotherAwsAccountOutput");
        formatter.field("operation_id", &self.operation_id);
        formatter.finish()
    }
}
/// See [`RejectDomainTransferFromAnotherAwsAccountOutput`](crate::output::RejectDomainTransferFromAnotherAwsAccountOutput)
pub mod reject_domain_transfer_from_another_aws_account_output {
    /// A builder for [`RejectDomainTransferFromAnotherAwsAccountOutput`](crate::output::RejectDomainTransferFromAnotherAwsAccountOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier that <code>TransferDomainToAnotherAwsAccount</code> returned to track the progress of the request.
        /// Because the transfer request was rejected, the value is no longer valid, and you can't use <code>GetOperationDetail</code>
        /// to query the operation status.</p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>The identifier that <code>TransferDomainToAnotherAwsAccount</code> returned to track the progress of the request.
        /// Because the transfer request was rejected, the value is no longer valid, and you can't use <code>GetOperationDetail</code>
        /// to query the operation status.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RejectDomainTransferFromAnotherAwsAccountOutput`](crate::output::RejectDomainTransferFromAnotherAwsAccountOutput)
        pub fn build(self) -> crate::output::RejectDomainTransferFromAnotherAwsAccountOutput {
            crate::output::RejectDomainTransferFromAnotherAwsAccountOutput {
                operation_id: self.operation_id,
            }
        }
    }
}
impl RejectDomainTransferFromAnotherAwsAccountOutput {
    /// Creates a new builder-style object to manufacture [`RejectDomainTransferFromAnotherAwsAccountOutput`](crate::output::RejectDomainTransferFromAnotherAwsAccountOutput)
    pub fn builder(
    ) -> crate::output::reject_domain_transfer_from_another_aws_account_output::Builder {
        crate::output::reject_domain_transfer_from_another_aws_account_output::Builder::default()
    }
}

/// <p>The RegisterDomain response includes the following element.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterDomainOutput {
    /// <p>Identifier for tracking the progress of the request. To query the operation status, use
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>.</p>
    pub operation_id: std::option::Option<std::string::String>,
}
impl RegisterDomainOutput {
    /// <p>Identifier for tracking the progress of the request. To query the operation status, use
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>.</p>
    pub fn operation_id(&self) -> std::option::Option<&str> {
        self.operation_id.as_deref()
    }
}
impl std::fmt::Debug for RegisterDomainOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterDomainOutput");
        formatter.field("operation_id", &self.operation_id);
        formatter.finish()
    }
}
/// See [`RegisterDomainOutput`](crate::output::RegisterDomainOutput)
pub mod register_domain_output {
    /// A builder for [`RegisterDomainOutput`](crate::output::RegisterDomainOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Identifier for tracking the progress of the request. To query the operation status, use
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>.</p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>Identifier for tracking the progress of the request. To query the operation status, use
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterDomainOutput`](crate::output::RegisterDomainOutput)
        pub fn build(self) -> crate::output::RegisterDomainOutput {
            crate::output::RegisterDomainOutput {
                operation_id: self.operation_id,
            }
        }
    }
}
impl RegisterDomainOutput {
    /// Creates a new builder-style object to manufacture [`RegisterDomainOutput`](crate::output::RegisterDomainOutput)
    pub fn builder() -> crate::output::register_domain_output::Builder {
        crate::output::register_domain_output::Builder::default()
    }
}

/// <p>The ListTagsForDomain response includes the following elements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForDomainOutput {
    /// <p>A list of the tags that are associated with the specified domain.</p>
    pub tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ListTagsForDomainOutput {
    /// <p>A list of the tags that are associated with the specified domain.</p>
    pub fn tag_list(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tag_list.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForDomainOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForDomainOutput");
        formatter.field("tag_list", &self.tag_list);
        formatter.finish()
    }
}
/// See [`ListTagsForDomainOutput`](crate::output::ListTagsForDomainOutput)
pub mod list_tags_for_domain_output {
    /// A builder for [`ListTagsForDomainOutput`](crate::output::ListTagsForDomainOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `tag_list`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>A list of the tags that are associated with the specified domain.</p>
        pub fn tag_list(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tag_list.unwrap_or_default();
            v.push(input.into());
            self.tag_list = Some(v);
            self
        }
        /// <p>A list of the tags that are associated with the specified domain.</p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tag_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForDomainOutput`](crate::output::ListTagsForDomainOutput)
        pub fn build(self) -> crate::output::ListTagsForDomainOutput {
            crate::output::ListTagsForDomainOutput {
                tag_list: self.tag_list,
            }
        }
    }
}
impl ListTagsForDomainOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForDomainOutput`](crate::output::ListTagsForDomainOutput)
    pub fn builder() -> crate::output::list_tags_for_domain_output::Builder {
        crate::output::list_tags_for_domain_output::Builder::default()
    }
}

/// <p>The ListOperations response includes the following elements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOperationsOutput {
    /// <p>Lists summaries of the operations.</p>
    pub operations: std::option::Option<std::vec::Vec<crate::model::OperationSummary>>,
    /// <p>If there are more operations than you specified for <code>MaxItems</code> in the request, submit another
    /// request and include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>.</p>
    pub next_page_marker: std::option::Option<std::string::String>,
}
impl ListOperationsOutput {
    /// <p>Lists summaries of the operations.</p>
    pub fn operations(&self) -> std::option::Option<&[crate::model::OperationSummary]> {
        self.operations.as_deref()
    }
    /// <p>If there are more operations than you specified for <code>MaxItems</code> in the request, submit another
    /// request and include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>.</p>
    pub fn next_page_marker(&self) -> std::option::Option<&str> {
        self.next_page_marker.as_deref()
    }
}
impl std::fmt::Debug for ListOperationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOperationsOutput");
        formatter.field("operations", &self.operations);
        formatter.field("next_page_marker", &self.next_page_marker);
        formatter.finish()
    }
}
/// See [`ListOperationsOutput`](crate::output::ListOperationsOutput)
pub mod list_operations_output {
    /// A builder for [`ListOperationsOutput`](crate::output::ListOperationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operations: std::option::Option<std::vec::Vec<crate::model::OperationSummary>>,
        pub(crate) next_page_marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `operations`.
        ///
        /// To override the contents of this collection use [`set_operations`](Self::set_operations).
        ///
        /// <p>Lists summaries of the operations.</p>
        pub fn operations(mut self, input: impl Into<crate::model::OperationSummary>) -> Self {
            let mut v = self.operations.unwrap_or_default();
            v.push(input.into());
            self.operations = Some(v);
            self
        }
        /// <p>Lists summaries of the operations.</p>
        pub fn set_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OperationSummary>>,
        ) -> Self {
            self.operations = input;
            self
        }
        /// <p>If there are more operations than you specified for <code>MaxItems</code> in the request, submit another
        /// request and include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>.</p>
        pub fn next_page_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_marker = Some(input.into());
            self
        }
        /// <p>If there are more operations than you specified for <code>MaxItems</code> in the request, submit another
        /// request and include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>.</p>
        pub fn set_next_page_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOperationsOutput`](crate::output::ListOperationsOutput)
        pub fn build(self) -> crate::output::ListOperationsOutput {
            crate::output::ListOperationsOutput {
                operations: self.operations,
                next_page_marker: self.next_page_marker,
            }
        }
    }
}
impl ListOperationsOutput {
    /// Creates a new builder-style object to manufacture [`ListOperationsOutput`](crate::output::ListOperationsOutput)
    pub fn builder() -> crate::output::list_operations_output::Builder {
        crate::output::list_operations_output::Builder::default()
    }
}

/// <p>The ListDomains response includes the following elements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDomainsOutput {
    /// <p>A summary of domains.</p>
    pub domains: std::option::Option<std::vec::Vec<crate::model::DomainSummary>>,
    /// <p>If there are more domains than you specified for <code>MaxItems</code> in the request, submit another
    /// request and include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>.</p>
    pub next_page_marker: std::option::Option<std::string::String>,
}
impl ListDomainsOutput {
    /// <p>A summary of domains.</p>
    pub fn domains(&self) -> std::option::Option<&[crate::model::DomainSummary]> {
        self.domains.as_deref()
    }
    /// <p>If there are more domains than you specified for <code>MaxItems</code> in the request, submit another
    /// request and include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>.</p>
    pub fn next_page_marker(&self) -> std::option::Option<&str> {
        self.next_page_marker.as_deref()
    }
}
impl std::fmt::Debug for ListDomainsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDomainsOutput");
        formatter.field("domains", &self.domains);
        formatter.field("next_page_marker", &self.next_page_marker);
        formatter.finish()
    }
}
/// See [`ListDomainsOutput`](crate::output::ListDomainsOutput)
pub mod list_domains_output {
    /// A builder for [`ListDomainsOutput`](crate::output::ListDomainsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domains: std::option::Option<std::vec::Vec<crate::model::DomainSummary>>,
        pub(crate) next_page_marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `domains`.
        ///
        /// To override the contents of this collection use [`set_domains`](Self::set_domains).
        ///
        /// <p>A summary of domains.</p>
        pub fn domains(mut self, input: impl Into<crate::model::DomainSummary>) -> Self {
            let mut v = self.domains.unwrap_or_default();
            v.push(input.into());
            self.domains = Some(v);
            self
        }
        /// <p>A summary of domains.</p>
        pub fn set_domains(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DomainSummary>>,
        ) -> Self {
            self.domains = input;
            self
        }
        /// <p>If there are more domains than you specified for <code>MaxItems</code> in the request, submit another
        /// request and include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>.</p>
        pub fn next_page_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_marker = Some(input.into());
            self
        }
        /// <p>If there are more domains than you specified for <code>MaxItems</code> in the request, submit another
        /// request and include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>.</p>
        pub fn set_next_page_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDomainsOutput`](crate::output::ListDomainsOutput)
        pub fn build(self) -> crate::output::ListDomainsOutput {
            crate::output::ListDomainsOutput {
                domains: self.domains,
                next_page_marker: self.next_page_marker,
            }
        }
    }
}
impl ListDomainsOutput {
    /// Creates a new builder-style object to manufacture [`ListDomainsOutput`](crate::output::ListDomainsOutput)
    pub fn builder() -> crate::output::list_domains_output::Builder {
        crate::output::list_domains_output::Builder::default()
    }
}

/// <p>The GetOperationDetail response includes the following elements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetOperationDetailOutput {
    /// <p>The identifier for the operation.</p>
    pub operation_id: std::option::Option<std::string::String>,
    /// <p>The current status of the requested operation in the system.</p>
    pub status: std::option::Option<crate::model::OperationStatus>,
    /// <p>Detailed information on the status including possible errors.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The name of a domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The type of operation that was requested.</p>
    pub r#type: std::option::Option<crate::model::OperationType>,
    /// <p>The date when the request was submitted.</p>
    pub submitted_date: std::option::Option<aws_smithy_types::Instant>,
}
impl GetOperationDetailOutput {
    /// <p>The identifier for the operation.</p>
    pub fn operation_id(&self) -> std::option::Option<&str> {
        self.operation_id.as_deref()
    }
    /// <p>The current status of the requested operation in the system.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::OperationStatus> {
        self.status.as_ref()
    }
    /// <p>Detailed information on the status including possible errors.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The name of a domain.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The type of operation that was requested.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::OperationType> {
        self.r#type.as_ref()
    }
    /// <p>The date when the request was submitted.</p>
    pub fn submitted_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.submitted_date.as_ref()
    }
}
impl std::fmt::Debug for GetOperationDetailOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetOperationDetailOutput");
        formatter.field("operation_id", &self.operation_id);
        formatter.field("status", &self.status);
        formatter.field("message", &self.message);
        formatter.field("domain_name", &self.domain_name);
        formatter.field("r#type", &self.r#type);
        formatter.field("submitted_date", &self.submitted_date);
        formatter.finish()
    }
}
/// See [`GetOperationDetailOutput`](crate::output::GetOperationDetailOutput)
pub mod get_operation_detail_output {
    /// A builder for [`GetOperationDetailOutput`](crate::output::GetOperationDetailOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operation_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::OperationStatus>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::OperationType>,
        pub(crate) submitted_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The identifier for the operation.</p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>The identifier for the operation.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// <p>The current status of the requested operation in the system.</p>
        pub fn status(mut self, input: crate::model::OperationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the requested operation in the system.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::OperationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Detailed information on the status including possible errors.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Detailed information on the status including possible errors.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The name of a domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of a domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The type of operation that was requested.</p>
        pub fn r#type(mut self, input: crate::model::OperationType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of operation that was requested.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::OperationType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The date when the request was submitted.</p>
        pub fn submitted_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.submitted_date = Some(input);
            self
        }
        /// <p>The date when the request was submitted.</p>
        pub fn set_submitted_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.submitted_date = input;
            self
        }
        /// Consumes the builder and constructs a [`GetOperationDetailOutput`](crate::output::GetOperationDetailOutput)
        pub fn build(self) -> crate::output::GetOperationDetailOutput {
            crate::output::GetOperationDetailOutput {
                operation_id: self.operation_id,
                status: self.status,
                message: self.message,
                domain_name: self.domain_name,
                r#type: self.r#type,
                submitted_date: self.submitted_date,
            }
        }
    }
}
impl GetOperationDetailOutput {
    /// Creates a new builder-style object to manufacture [`GetOperationDetailOutput`](crate::output::GetOperationDetailOutput)
    pub fn builder() -> crate::output::get_operation_detail_output::Builder {
        crate::output::get_operation_detail_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDomainSuggestionsOutput {
    /// <p>A list of possible domain names. If you specified <code>true</code> for <code>OnlyAvailable</code> in the request,
    /// the list contains only domains that are available for registration.</p>
    pub suggestions_list: std::option::Option<std::vec::Vec<crate::model::DomainSuggestion>>,
}
impl GetDomainSuggestionsOutput {
    /// <p>A list of possible domain names. If you specified <code>true</code> for <code>OnlyAvailable</code> in the request,
    /// the list contains only domains that are available for registration.</p>
    pub fn suggestions_list(&self) -> std::option::Option<&[crate::model::DomainSuggestion]> {
        self.suggestions_list.as_deref()
    }
}
impl std::fmt::Debug for GetDomainSuggestionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDomainSuggestionsOutput");
        formatter.field("suggestions_list", &self.suggestions_list);
        formatter.finish()
    }
}
/// See [`GetDomainSuggestionsOutput`](crate::output::GetDomainSuggestionsOutput)
pub mod get_domain_suggestions_output {
    /// A builder for [`GetDomainSuggestionsOutput`](crate::output::GetDomainSuggestionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) suggestions_list:
            std::option::Option<std::vec::Vec<crate::model::DomainSuggestion>>,
    }
    impl Builder {
        /// Appends an item to `suggestions_list`.
        ///
        /// To override the contents of this collection use [`set_suggestions_list`](Self::set_suggestions_list).
        ///
        /// <p>A list of possible domain names. If you specified <code>true</code> for <code>OnlyAvailable</code> in the request,
        /// the list contains only domains that are available for registration.</p>
        pub fn suggestions_list(
            mut self,
            input: impl Into<crate::model::DomainSuggestion>,
        ) -> Self {
            let mut v = self.suggestions_list.unwrap_or_default();
            v.push(input.into());
            self.suggestions_list = Some(v);
            self
        }
        /// <p>A list of possible domain names. If you specified <code>true</code> for <code>OnlyAvailable</code> in the request,
        /// the list contains only domains that are available for registration.</p>
        pub fn set_suggestions_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DomainSuggestion>>,
        ) -> Self {
            self.suggestions_list = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDomainSuggestionsOutput`](crate::output::GetDomainSuggestionsOutput)
        pub fn build(self) -> crate::output::GetDomainSuggestionsOutput {
            crate::output::GetDomainSuggestionsOutput {
                suggestions_list: self.suggestions_list,
            }
        }
    }
}
impl GetDomainSuggestionsOutput {
    /// Creates a new builder-style object to manufacture [`GetDomainSuggestionsOutput`](crate::output::GetDomainSuggestionsOutput)
    pub fn builder() -> crate::output::get_domain_suggestions_output::Builder {
        crate::output::get_domain_suggestions_output::Builder::default()
    }
}

/// <p>The GetDomainDetail response includes the following elements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDomainDetailOutput {
    /// <p>The name of a domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The name of the domain.</p>
    pub nameservers: std::option::Option<std::vec::Vec<crate::model::Nameserver>>,
    /// <p>Specifies whether the domain registration is set to renew automatically.</p>
    pub auto_renew: std::option::Option<bool>,
    /// <p>Provides details about the domain administrative contact.</p>
    pub admin_contact: std::option::Option<crate::model::ContactDetail>,
    /// <p>Provides details about the domain registrant.</p>
    pub registrant_contact: std::option::Option<crate::model::ContactDetail>,
    /// <p>Provides details about the domain technical contact.</p>
    pub tech_contact: std::option::Option<crate::model::ContactDetail>,
    /// <p>Specifies whether contact information is concealed from WHOIS queries. If the value is <code>true</code>,
    /// WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains)
    /// or for our registrar associate, Gandi (for all other TLDs). If the value is <code>false</code>,
    /// WHOIS queries return the information that you entered for the admin contact.</p>
    pub admin_privacy: std::option::Option<bool>,
    /// <p>Specifies whether contact information is concealed from WHOIS queries. If the value is <code>true</code>,
    /// WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains)
    /// or for our registrar associate, Gandi (for all other TLDs). If the value is <code>false</code>,
    /// WHOIS queries return the information that you entered for the registrant contact (domain owner).</p>
    pub registrant_privacy: std::option::Option<bool>,
    /// <p>Specifies whether contact information is concealed from WHOIS queries. If the value is <code>true</code>,
    /// WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains)
    /// or for our registrar associate, Gandi (for all other TLDs). If the value is <code>false</code>,
    /// WHOIS queries return the information that you entered for the technical contact.</p>
    pub tech_privacy: std::option::Option<bool>,
    /// <p>Name of the registrar of the domain as identified in the registry. Domains with a .com, .net, or .org TLD are registered by
    /// Amazon Registrar. All other domains are registered by our registrar associate, Gandi. The value for domains that are registered by
    /// Gandi is <code>"GANDI SAS"</code>. </p>
    pub registrar_name: std::option::Option<std::string::String>,
    /// <p>The fully qualified name of the WHOIS server that can answer the WHOIS query for the domain.</p>
    pub who_is_server: std::option::Option<std::string::String>,
    /// <p>Web address of the registrar.</p>
    pub registrar_url: std::option::Option<std::string::String>,
    /// <p>Email address to contact to report incorrect contact information for a domain, to report that the domain
    /// is being used to send spam, to report that someone is cybersquatting on a domain name, or report some other type of abuse.</p>
    pub abuse_contact_email: std::option::Option<std::string::String>,
    /// <p>Phone number for reporting abuse.</p>
    pub abuse_contact_phone: std::option::Option<std::string::String>,
    /// <p>Reserved for future use.</p>
    pub registry_domain_id: std::option::Option<std::string::String>,
    /// <p>The date when the domain was created as found in the response to a WHOIS query. The date and time is in
    /// Unix time format and Coordinated Universal time (UTC).</p>
    pub creation_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The last updated date of the domain as found in the response to a WHOIS query. The date and time is in
    /// Unix time format and Coordinated Universal time (UTC).</p>
    pub updated_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date when the registration for the domain is set to expire. The date and time is in
    /// Unix time format and Coordinated Universal time (UTC).</p>
    pub expiration_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Reseller of the domain. Domains registered or transferred using Route 53 domains will have <code>"Amazon"</code>
    /// as the reseller. </p>
    pub reseller: std::option::Option<std::string::String>,
    /// <p>Reserved for future use.</p>
    pub dns_sec: std::option::Option<std::string::String>,
    /// <p>An array of domain name status codes, also known as Extensible Provisioning Protocol (EPP) status codes.</p>
    /// <p>ICANN, the organization that maintains a central database of domain names, has developed a set of domain name
    /// status codes that tell you the status of a variety of operations on a domain name, for example, registering a domain name,
    /// transferring a domain name to another registrar, renewing the registration for a domain name, and so on. All registrars
    /// use this same set of status codes.</p>
    /// <p>For a current list of domain name status codes and an explanation of what each code means, go to the
    /// <a href="https://www.icann.org/">ICANN website</a> and search for <code>epp status codes</code>.
    /// (Search on the ICANN website; web searches sometimes return an old version of the document.)</p>
    pub status_list: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl GetDomainDetailOutput {
    /// <p>The name of a domain.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The name of the domain.</p>
    pub fn nameservers(&self) -> std::option::Option<&[crate::model::Nameserver]> {
        self.nameservers.as_deref()
    }
    /// <p>Specifies whether the domain registration is set to renew automatically.</p>
    pub fn auto_renew(&self) -> std::option::Option<bool> {
        self.auto_renew
    }
    /// <p>Provides details about the domain administrative contact.</p>
    pub fn admin_contact(&self) -> std::option::Option<&crate::model::ContactDetail> {
        self.admin_contact.as_ref()
    }
    /// <p>Provides details about the domain registrant.</p>
    pub fn registrant_contact(&self) -> std::option::Option<&crate::model::ContactDetail> {
        self.registrant_contact.as_ref()
    }
    /// <p>Provides details about the domain technical contact.</p>
    pub fn tech_contact(&self) -> std::option::Option<&crate::model::ContactDetail> {
        self.tech_contact.as_ref()
    }
    /// <p>Specifies whether contact information is concealed from WHOIS queries. If the value is <code>true</code>,
    /// WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains)
    /// or for our registrar associate, Gandi (for all other TLDs). If the value is <code>false</code>,
    /// WHOIS queries return the information that you entered for the admin contact.</p>
    pub fn admin_privacy(&self) -> std::option::Option<bool> {
        self.admin_privacy
    }
    /// <p>Specifies whether contact information is concealed from WHOIS queries. If the value is <code>true</code>,
    /// WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains)
    /// or for our registrar associate, Gandi (for all other TLDs). If the value is <code>false</code>,
    /// WHOIS queries return the information that you entered for the registrant contact (domain owner).</p>
    pub fn registrant_privacy(&self) -> std::option::Option<bool> {
        self.registrant_privacy
    }
    /// <p>Specifies whether contact information is concealed from WHOIS queries. If the value is <code>true</code>,
    /// WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains)
    /// or for our registrar associate, Gandi (for all other TLDs). If the value is <code>false</code>,
    /// WHOIS queries return the information that you entered for the technical contact.</p>
    pub fn tech_privacy(&self) -> std::option::Option<bool> {
        self.tech_privacy
    }
    /// <p>Name of the registrar of the domain as identified in the registry. Domains with a .com, .net, or .org TLD are registered by
    /// Amazon Registrar. All other domains are registered by our registrar associate, Gandi. The value for domains that are registered by
    /// Gandi is <code>"GANDI SAS"</code>. </p>
    pub fn registrar_name(&self) -> std::option::Option<&str> {
        self.registrar_name.as_deref()
    }
    /// <p>The fully qualified name of the WHOIS server that can answer the WHOIS query for the domain.</p>
    pub fn who_is_server(&self) -> std::option::Option<&str> {
        self.who_is_server.as_deref()
    }
    /// <p>Web address of the registrar.</p>
    pub fn registrar_url(&self) -> std::option::Option<&str> {
        self.registrar_url.as_deref()
    }
    /// <p>Email address to contact to report incorrect contact information for a domain, to report that the domain
    /// is being used to send spam, to report that someone is cybersquatting on a domain name, or report some other type of abuse.</p>
    pub fn abuse_contact_email(&self) -> std::option::Option<&str> {
        self.abuse_contact_email.as_deref()
    }
    /// <p>Phone number for reporting abuse.</p>
    pub fn abuse_contact_phone(&self) -> std::option::Option<&str> {
        self.abuse_contact_phone.as_deref()
    }
    /// <p>Reserved for future use.</p>
    pub fn registry_domain_id(&self) -> std::option::Option<&str> {
        self.registry_domain_id.as_deref()
    }
    /// <p>The date when the domain was created as found in the response to a WHOIS query. The date and time is in
    /// Unix time format and Coordinated Universal time (UTC).</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_date.as_ref()
    }
    /// <p>The last updated date of the domain as found in the response to a WHOIS query. The date and time is in
    /// Unix time format and Coordinated Universal time (UTC).</p>
    pub fn updated_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.updated_date.as_ref()
    }
    /// <p>The date when the registration for the domain is set to expire. The date and time is in
    /// Unix time format and Coordinated Universal time (UTC).</p>
    pub fn expiration_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.expiration_date.as_ref()
    }
    /// <p>Reseller of the domain. Domains registered or transferred using Route 53 domains will have <code>"Amazon"</code>
    /// as the reseller. </p>
    pub fn reseller(&self) -> std::option::Option<&str> {
        self.reseller.as_deref()
    }
    /// <p>Reserved for future use.</p>
    pub fn dns_sec(&self) -> std::option::Option<&str> {
        self.dns_sec.as_deref()
    }
    /// <p>An array of domain name status codes, also known as Extensible Provisioning Protocol (EPP) status codes.</p>
    /// <p>ICANN, the organization that maintains a central database of domain names, has developed a set of domain name
    /// status codes that tell you the status of a variety of operations on a domain name, for example, registering a domain name,
    /// transferring a domain name to another registrar, renewing the registration for a domain name, and so on. All registrars
    /// use this same set of status codes.</p>
    /// <p>For a current list of domain name status codes and an explanation of what each code means, go to the
    /// <a href="https://www.icann.org/">ICANN website</a> and search for <code>epp status codes</code>.
    /// (Search on the ICANN website; web searches sometimes return an old version of the document.)</p>
    pub fn status_list(&self) -> std::option::Option<&[std::string::String]> {
        self.status_list.as_deref()
    }
}
impl std::fmt::Debug for GetDomainDetailOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDomainDetailOutput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("nameservers", &self.nameservers);
        formatter.field("auto_renew", &self.auto_renew);
        formatter.field("admin_contact", &"*** Sensitive Data Redacted ***");
        formatter.field("registrant_contact", &"*** Sensitive Data Redacted ***");
        formatter.field("tech_contact", &"*** Sensitive Data Redacted ***");
        formatter.field("admin_privacy", &self.admin_privacy);
        formatter.field("registrant_privacy", &self.registrant_privacy);
        formatter.field("tech_privacy", &self.tech_privacy);
        formatter.field("registrar_name", &self.registrar_name);
        formatter.field("who_is_server", &self.who_is_server);
        formatter.field("registrar_url", &self.registrar_url);
        formatter.field("abuse_contact_email", &self.abuse_contact_email);
        formatter.field("abuse_contact_phone", &self.abuse_contact_phone);
        formatter.field("registry_domain_id", &self.registry_domain_id);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("updated_date", &self.updated_date);
        formatter.field("expiration_date", &self.expiration_date);
        formatter.field("reseller", &self.reseller);
        formatter.field("dns_sec", &self.dns_sec);
        formatter.field("status_list", &self.status_list);
        formatter.finish()
    }
}
/// See [`GetDomainDetailOutput`](crate::output::GetDomainDetailOutput)
pub mod get_domain_detail_output {
    /// A builder for [`GetDomainDetailOutput`](crate::output::GetDomainDetailOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) nameservers: std::option::Option<std::vec::Vec<crate::model::Nameserver>>,
        pub(crate) auto_renew: std::option::Option<bool>,
        pub(crate) admin_contact: std::option::Option<crate::model::ContactDetail>,
        pub(crate) registrant_contact: std::option::Option<crate::model::ContactDetail>,
        pub(crate) tech_contact: std::option::Option<crate::model::ContactDetail>,
        pub(crate) admin_privacy: std::option::Option<bool>,
        pub(crate) registrant_privacy: std::option::Option<bool>,
        pub(crate) tech_privacy: std::option::Option<bool>,
        pub(crate) registrar_name: std::option::Option<std::string::String>,
        pub(crate) who_is_server: std::option::Option<std::string::String>,
        pub(crate) registrar_url: std::option::Option<std::string::String>,
        pub(crate) abuse_contact_email: std::option::Option<std::string::String>,
        pub(crate) abuse_contact_phone: std::option::Option<std::string::String>,
        pub(crate) registry_domain_id: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) updated_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) expiration_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) reseller: std::option::Option<std::string::String>,
        pub(crate) dns_sec: std::option::Option<std::string::String>,
        pub(crate) status_list: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of a domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of a domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Appends an item to `nameservers`.
        ///
        /// To override the contents of this collection use [`set_nameservers`](Self::set_nameservers).
        ///
        /// <p>The name of the domain.</p>
        pub fn nameservers(mut self, input: impl Into<crate::model::Nameserver>) -> Self {
            let mut v = self.nameservers.unwrap_or_default();
            v.push(input.into());
            self.nameservers = Some(v);
            self
        }
        /// <p>The name of the domain.</p>
        pub fn set_nameservers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Nameserver>>,
        ) -> Self {
            self.nameservers = input;
            self
        }
        /// <p>Specifies whether the domain registration is set to renew automatically.</p>
        pub fn auto_renew(mut self, input: bool) -> Self {
            self.auto_renew = Some(input);
            self
        }
        /// <p>Specifies whether the domain registration is set to renew automatically.</p>
        pub fn set_auto_renew(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_renew = input;
            self
        }
        /// <p>Provides details about the domain administrative contact.</p>
        pub fn admin_contact(mut self, input: crate::model::ContactDetail) -> Self {
            self.admin_contact = Some(input);
            self
        }
        /// <p>Provides details about the domain administrative contact.</p>
        pub fn set_admin_contact(
            mut self,
            input: std::option::Option<crate::model::ContactDetail>,
        ) -> Self {
            self.admin_contact = input;
            self
        }
        /// <p>Provides details about the domain registrant.</p>
        pub fn registrant_contact(mut self, input: crate::model::ContactDetail) -> Self {
            self.registrant_contact = Some(input);
            self
        }
        /// <p>Provides details about the domain registrant.</p>
        pub fn set_registrant_contact(
            mut self,
            input: std::option::Option<crate::model::ContactDetail>,
        ) -> Self {
            self.registrant_contact = input;
            self
        }
        /// <p>Provides details about the domain technical contact.</p>
        pub fn tech_contact(mut self, input: crate::model::ContactDetail) -> Self {
            self.tech_contact = Some(input);
            self
        }
        /// <p>Provides details about the domain technical contact.</p>
        pub fn set_tech_contact(
            mut self,
            input: std::option::Option<crate::model::ContactDetail>,
        ) -> Self {
            self.tech_contact = input;
            self
        }
        /// <p>Specifies whether contact information is concealed from WHOIS queries. If the value is <code>true</code>,
        /// WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains)
        /// or for our registrar associate, Gandi (for all other TLDs). If the value is <code>false</code>,
        /// WHOIS queries return the information that you entered for the admin contact.</p>
        pub fn admin_privacy(mut self, input: bool) -> Self {
            self.admin_privacy = Some(input);
            self
        }
        /// <p>Specifies whether contact information is concealed from WHOIS queries. If the value is <code>true</code>,
        /// WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains)
        /// or for our registrar associate, Gandi (for all other TLDs). If the value is <code>false</code>,
        /// WHOIS queries return the information that you entered for the admin contact.</p>
        pub fn set_admin_privacy(mut self, input: std::option::Option<bool>) -> Self {
            self.admin_privacy = input;
            self
        }
        /// <p>Specifies whether contact information is concealed from WHOIS queries. If the value is <code>true</code>,
        /// WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains)
        /// or for our registrar associate, Gandi (for all other TLDs). If the value is <code>false</code>,
        /// WHOIS queries return the information that you entered for the registrant contact (domain owner).</p>
        pub fn registrant_privacy(mut self, input: bool) -> Self {
            self.registrant_privacy = Some(input);
            self
        }
        /// <p>Specifies whether contact information is concealed from WHOIS queries. If the value is <code>true</code>,
        /// WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains)
        /// or for our registrar associate, Gandi (for all other TLDs). If the value is <code>false</code>,
        /// WHOIS queries return the information that you entered for the registrant contact (domain owner).</p>
        pub fn set_registrant_privacy(mut self, input: std::option::Option<bool>) -> Self {
            self.registrant_privacy = input;
            self
        }
        /// <p>Specifies whether contact information is concealed from WHOIS queries. If the value is <code>true</code>,
        /// WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains)
        /// or for our registrar associate, Gandi (for all other TLDs). If the value is <code>false</code>,
        /// WHOIS queries return the information that you entered for the technical contact.</p>
        pub fn tech_privacy(mut self, input: bool) -> Self {
            self.tech_privacy = Some(input);
            self
        }
        /// <p>Specifies whether contact information is concealed from WHOIS queries. If the value is <code>true</code>,
        /// WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains)
        /// or for our registrar associate, Gandi (for all other TLDs). If the value is <code>false</code>,
        /// WHOIS queries return the information that you entered for the technical contact.</p>
        pub fn set_tech_privacy(mut self, input: std::option::Option<bool>) -> Self {
            self.tech_privacy = input;
            self
        }
        /// <p>Name of the registrar of the domain as identified in the registry. Domains with a .com, .net, or .org TLD are registered by
        /// Amazon Registrar. All other domains are registered by our registrar associate, Gandi. The value for domains that are registered by
        /// Gandi is <code>"GANDI SAS"</code>. </p>
        pub fn registrar_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.registrar_name = Some(input.into());
            self
        }
        /// <p>Name of the registrar of the domain as identified in the registry. Domains with a .com, .net, or .org TLD are registered by
        /// Amazon Registrar. All other domains are registered by our registrar associate, Gandi. The value for domains that are registered by
        /// Gandi is <code>"GANDI SAS"</code>. </p>
        pub fn set_registrar_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registrar_name = input;
            self
        }
        /// <p>The fully qualified name of the WHOIS server that can answer the WHOIS query for the domain.</p>
        pub fn who_is_server(mut self, input: impl Into<std::string::String>) -> Self {
            self.who_is_server = Some(input.into());
            self
        }
        /// <p>The fully qualified name of the WHOIS server that can answer the WHOIS query for the domain.</p>
        pub fn set_who_is_server(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.who_is_server = input;
            self
        }
        /// <p>Web address of the registrar.</p>
        pub fn registrar_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.registrar_url = Some(input.into());
            self
        }
        /// <p>Web address of the registrar.</p>
        pub fn set_registrar_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registrar_url = input;
            self
        }
        /// <p>Email address to contact to report incorrect contact information for a domain, to report that the domain
        /// is being used to send spam, to report that someone is cybersquatting on a domain name, or report some other type of abuse.</p>
        pub fn abuse_contact_email(mut self, input: impl Into<std::string::String>) -> Self {
            self.abuse_contact_email = Some(input.into());
            self
        }
        /// <p>Email address to contact to report incorrect contact information for a domain, to report that the domain
        /// is being used to send spam, to report that someone is cybersquatting on a domain name, or report some other type of abuse.</p>
        pub fn set_abuse_contact_email(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.abuse_contact_email = input;
            self
        }
        /// <p>Phone number for reporting abuse.</p>
        pub fn abuse_contact_phone(mut self, input: impl Into<std::string::String>) -> Self {
            self.abuse_contact_phone = Some(input.into());
            self
        }
        /// <p>Phone number for reporting abuse.</p>
        pub fn set_abuse_contact_phone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.abuse_contact_phone = input;
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn registry_domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_domain_id = Some(input.into());
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_registry_domain_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registry_domain_id = input;
            self
        }
        /// <p>The date when the domain was created as found in the response to a WHOIS query. The date and time is in
        /// Unix time format and Coordinated Universal time (UTC).</p>
        pub fn creation_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date when the domain was created as found in the response to a WHOIS query. The date and time is in
        /// Unix time format and Coordinated Universal time (UTC).</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The last updated date of the domain as found in the response to a WHOIS query. The date and time is in
        /// Unix time format and Coordinated Universal time (UTC).</p>
        pub fn updated_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated_date = Some(input);
            self
        }
        /// <p>The last updated date of the domain as found in the response to a WHOIS query. The date and time is in
        /// Unix time format and Coordinated Universal time (UTC).</p>
        pub fn set_updated_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated_date = input;
            self
        }
        /// <p>The date when the registration for the domain is set to expire. The date and time is in
        /// Unix time format and Coordinated Universal time (UTC).</p>
        pub fn expiration_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.expiration_date = Some(input);
            self
        }
        /// <p>The date when the registration for the domain is set to expire. The date and time is in
        /// Unix time format and Coordinated Universal time (UTC).</p>
        pub fn set_expiration_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.expiration_date = input;
            self
        }
        /// <p>Reseller of the domain. Domains registered or transferred using Route 53 domains will have <code>"Amazon"</code>
        /// as the reseller. </p>
        pub fn reseller(mut self, input: impl Into<std::string::String>) -> Self {
            self.reseller = Some(input.into());
            self
        }
        /// <p>Reseller of the domain. Domains registered or transferred using Route 53 domains will have <code>"Amazon"</code>
        /// as the reseller. </p>
        pub fn set_reseller(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reseller = input;
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn dns_sec(mut self, input: impl Into<std::string::String>) -> Self {
            self.dns_sec = Some(input.into());
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_dns_sec(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dns_sec = input;
            self
        }
        /// Appends an item to `status_list`.
        ///
        /// To override the contents of this collection use [`set_status_list`](Self::set_status_list).
        ///
        /// <p>An array of domain name status codes, also known as Extensible Provisioning Protocol (EPP) status codes.</p>
        /// <p>ICANN, the organization that maintains a central database of domain names, has developed a set of domain name
        /// status codes that tell you the status of a variety of operations on a domain name, for example, registering a domain name,
        /// transferring a domain name to another registrar, renewing the registration for a domain name, and so on. All registrars
        /// use this same set of status codes.</p>
        /// <p>For a current list of domain name status codes and an explanation of what each code means, go to the
        /// <a href="https://www.icann.org/">ICANN website</a> and search for <code>epp status codes</code>.
        /// (Search on the ICANN website; web searches sometimes return an old version of the document.)</p>
        pub fn status_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.status_list.unwrap_or_default();
            v.push(input.into());
            self.status_list = Some(v);
            self
        }
        /// <p>An array of domain name status codes, also known as Extensible Provisioning Protocol (EPP) status codes.</p>
        /// <p>ICANN, the organization that maintains a central database of domain names, has developed a set of domain name
        /// status codes that tell you the status of a variety of operations on a domain name, for example, registering a domain name,
        /// transferring a domain name to another registrar, renewing the registration for a domain name, and so on. All registrars
        /// use this same set of status codes.</p>
        /// <p>For a current list of domain name status codes and an explanation of what each code means, go to the
        /// <a href="https://www.icann.org/">ICANN website</a> and search for <code>epp status codes</code>.
        /// (Search on the ICANN website; web searches sometimes return an old version of the document.)</p>
        pub fn set_status_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.status_list = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDomainDetailOutput`](crate::output::GetDomainDetailOutput)
        pub fn build(self) -> crate::output::GetDomainDetailOutput {
            crate::output::GetDomainDetailOutput {
                domain_name: self.domain_name,
                nameservers: self.nameservers,
                auto_renew: self.auto_renew,
                admin_contact: self.admin_contact,
                registrant_contact: self.registrant_contact,
                tech_contact: self.tech_contact,
                admin_privacy: self.admin_privacy,
                registrant_privacy: self.registrant_privacy,
                tech_privacy: self.tech_privacy,
                registrar_name: self.registrar_name,
                who_is_server: self.who_is_server,
                registrar_url: self.registrar_url,
                abuse_contact_email: self.abuse_contact_email,
                abuse_contact_phone: self.abuse_contact_phone,
                registry_domain_id: self.registry_domain_id,
                creation_date: self.creation_date,
                updated_date: self.updated_date,
                expiration_date: self.expiration_date,
                reseller: self.reseller,
                dns_sec: self.dns_sec,
                status_list: self.status_list,
            }
        }
    }
}
impl GetDomainDetailOutput {
    /// Creates a new builder-style object to manufacture [`GetDomainDetailOutput`](crate::output::GetDomainDetailOutput)
    pub fn builder() -> crate::output::get_domain_detail_output::Builder {
        crate::output::get_domain_detail_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetContactReachabilityStatusOutput {
    /// <p>The domain name for which you requested the reachability status.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>Whether the registrant contact has responded. Values include the following:</p>
    /// <dl>
    /// <dt>PENDING</dt>
    /// <dd>
    /// <p>We sent the confirmation email and haven't received a response yet.</p>
    /// </dd>
    /// <dt>DONE</dt>
    /// <dd>
    /// <p>We sent the email and got confirmation from the registrant contact.</p>
    /// </dd>
    /// <dt>EXPIRED</dt>
    /// <dd>
    /// <p>The time limit expired before the registrant contact responded.</p>
    /// </dd>
    /// </dl>
    pub status: std::option::Option<crate::model::ReachabilityStatus>,
}
impl GetContactReachabilityStatusOutput {
    /// <p>The domain name for which you requested the reachability status.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>Whether the registrant contact has responded. Values include the following:</p>
    /// <dl>
    /// <dt>PENDING</dt>
    /// <dd>
    /// <p>We sent the confirmation email and haven't received a response yet.</p>
    /// </dd>
    /// <dt>DONE</dt>
    /// <dd>
    /// <p>We sent the email and got confirmation from the registrant contact.</p>
    /// </dd>
    /// <dt>EXPIRED</dt>
    /// <dd>
    /// <p>The time limit expired before the registrant contact responded.</p>
    /// </dd>
    /// </dl>
    pub fn status(&self) -> std::option::Option<&crate::model::ReachabilityStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for GetContactReachabilityStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetContactReachabilityStatusOutput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`GetContactReachabilityStatusOutput`](crate::output::GetContactReachabilityStatusOutput)
pub mod get_contact_reachability_status_output {
    /// A builder for [`GetContactReachabilityStatusOutput`](crate::output::GetContactReachabilityStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ReachabilityStatus>,
    }
    impl Builder {
        /// <p>The domain name for which you requested the reachability status.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain name for which you requested the reachability status.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>Whether the registrant contact has responded. Values include the following:</p>
        /// <dl>
        /// <dt>PENDING</dt>
        /// <dd>
        /// <p>We sent the confirmation email and haven't received a response yet.</p>
        /// </dd>
        /// <dt>DONE</dt>
        /// <dd>
        /// <p>We sent the email and got confirmation from the registrant contact.</p>
        /// </dd>
        /// <dt>EXPIRED</dt>
        /// <dd>
        /// <p>The time limit expired before the registrant contact responded.</p>
        /// </dd>
        /// </dl>
        pub fn status(mut self, input: crate::model::ReachabilityStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Whether the registrant contact has responded. Values include the following:</p>
        /// <dl>
        /// <dt>PENDING</dt>
        /// <dd>
        /// <p>We sent the confirmation email and haven't received a response yet.</p>
        /// </dd>
        /// <dt>DONE</dt>
        /// <dd>
        /// <p>We sent the email and got confirmation from the registrant contact.</p>
        /// </dd>
        /// <dt>EXPIRED</dt>
        /// <dd>
        /// <p>The time limit expired before the registrant contact responded.</p>
        /// </dd>
        /// </dl>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ReachabilityStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`GetContactReachabilityStatusOutput`](crate::output::GetContactReachabilityStatusOutput)
        pub fn build(self) -> crate::output::GetContactReachabilityStatusOutput {
            crate::output::GetContactReachabilityStatusOutput {
                domain_name: self.domain_name,
                status: self.status,
            }
        }
    }
}
impl GetContactReachabilityStatusOutput {
    /// Creates a new builder-style object to manufacture [`GetContactReachabilityStatusOutput`](crate::output::GetContactReachabilityStatusOutput)
    pub fn builder() -> crate::output::get_contact_reachability_status_output::Builder {
        crate::output::get_contact_reachability_status_output::Builder::default()
    }
}

/// <p>The EnableDomainTransferLock response includes the following elements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableDomainTransferLockOutput {
    /// <p>Identifier for tracking the progress of the request. To use this ID to query the operation status, use GetOperationDetail.</p>
    pub operation_id: std::option::Option<std::string::String>,
}
impl EnableDomainTransferLockOutput {
    /// <p>Identifier for tracking the progress of the request. To use this ID to query the operation status, use GetOperationDetail.</p>
    pub fn operation_id(&self) -> std::option::Option<&str> {
        self.operation_id.as_deref()
    }
}
impl std::fmt::Debug for EnableDomainTransferLockOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableDomainTransferLockOutput");
        formatter.field("operation_id", &self.operation_id);
        formatter.finish()
    }
}
/// See [`EnableDomainTransferLockOutput`](crate::output::EnableDomainTransferLockOutput)
pub mod enable_domain_transfer_lock_output {
    /// A builder for [`EnableDomainTransferLockOutput`](crate::output::EnableDomainTransferLockOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Identifier for tracking the progress of the request. To use this ID to query the operation status, use GetOperationDetail.</p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>Identifier for tracking the progress of the request. To use this ID to query the operation status, use GetOperationDetail.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableDomainTransferLockOutput`](crate::output::EnableDomainTransferLockOutput)
        pub fn build(self) -> crate::output::EnableDomainTransferLockOutput {
            crate::output::EnableDomainTransferLockOutput {
                operation_id: self.operation_id,
            }
        }
    }
}
impl EnableDomainTransferLockOutput {
    /// Creates a new builder-style object to manufacture [`EnableDomainTransferLockOutput`](crate::output::EnableDomainTransferLockOutput)
    pub fn builder() -> crate::output::enable_domain_transfer_lock_output::Builder {
        crate::output::enable_domain_transfer_lock_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableDomainAutoRenewOutput {}
impl std::fmt::Debug for EnableDomainAutoRenewOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableDomainAutoRenewOutput");
        formatter.finish()
    }
}
/// See [`EnableDomainAutoRenewOutput`](crate::output::EnableDomainAutoRenewOutput)
pub mod enable_domain_auto_renew_output {
    /// A builder for [`EnableDomainAutoRenewOutput`](crate::output::EnableDomainAutoRenewOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`EnableDomainAutoRenewOutput`](crate::output::EnableDomainAutoRenewOutput)
        pub fn build(self) -> crate::output::EnableDomainAutoRenewOutput {
            crate::output::EnableDomainAutoRenewOutput {}
        }
    }
}
impl EnableDomainAutoRenewOutput {
    /// Creates a new builder-style object to manufacture [`EnableDomainAutoRenewOutput`](crate::output::EnableDomainAutoRenewOutput)
    pub fn builder() -> crate::output::enable_domain_auto_renew_output::Builder {
        crate::output::enable_domain_auto_renew_output::Builder::default()
    }
}

/// <p>The DisableDomainTransferLock response includes the following element.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableDomainTransferLockOutput {
    /// <p>Identifier for tracking the progress of the request. To query the operation status, use
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>.</p>
    pub operation_id: std::option::Option<std::string::String>,
}
impl DisableDomainTransferLockOutput {
    /// <p>Identifier for tracking the progress of the request. To query the operation status, use
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>.</p>
    pub fn operation_id(&self) -> std::option::Option<&str> {
        self.operation_id.as_deref()
    }
}
impl std::fmt::Debug for DisableDomainTransferLockOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableDomainTransferLockOutput");
        formatter.field("operation_id", &self.operation_id);
        formatter.finish()
    }
}
/// See [`DisableDomainTransferLockOutput`](crate::output::DisableDomainTransferLockOutput)
pub mod disable_domain_transfer_lock_output {
    /// A builder for [`DisableDomainTransferLockOutput`](crate::output::DisableDomainTransferLockOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Identifier for tracking the progress of the request. To query the operation status, use
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>.</p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>Identifier for tracking the progress of the request. To query the operation status, use
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DisableDomainTransferLockOutput`](crate::output::DisableDomainTransferLockOutput)
        pub fn build(self) -> crate::output::DisableDomainTransferLockOutput {
            crate::output::DisableDomainTransferLockOutput {
                operation_id: self.operation_id,
            }
        }
    }
}
impl DisableDomainTransferLockOutput {
    /// Creates a new builder-style object to manufacture [`DisableDomainTransferLockOutput`](crate::output::DisableDomainTransferLockOutput)
    pub fn builder() -> crate::output::disable_domain_transfer_lock_output::Builder {
        crate::output::disable_domain_transfer_lock_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableDomainAutoRenewOutput {}
impl std::fmt::Debug for DisableDomainAutoRenewOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableDomainAutoRenewOutput");
        formatter.finish()
    }
}
/// See [`DisableDomainAutoRenewOutput`](crate::output::DisableDomainAutoRenewOutput)
pub mod disable_domain_auto_renew_output {
    /// A builder for [`DisableDomainAutoRenewOutput`](crate::output::DisableDomainAutoRenewOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisableDomainAutoRenewOutput`](crate::output::DisableDomainAutoRenewOutput)
        pub fn build(self) -> crate::output::DisableDomainAutoRenewOutput {
            crate::output::DisableDomainAutoRenewOutput {}
        }
    }
}
impl DisableDomainAutoRenewOutput {
    /// Creates a new builder-style object to manufacture [`DisableDomainAutoRenewOutput`](crate::output::DisableDomainAutoRenewOutput)
    pub fn builder() -> crate::output::disable_domain_auto_renew_output::Builder {
        crate::output::disable_domain_auto_renew_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTagsForDomainOutput {}
impl std::fmt::Debug for DeleteTagsForDomainOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTagsForDomainOutput");
        formatter.finish()
    }
}
/// See [`DeleteTagsForDomainOutput`](crate::output::DeleteTagsForDomainOutput)
pub mod delete_tags_for_domain_output {
    /// A builder for [`DeleteTagsForDomainOutput`](crate::output::DeleteTagsForDomainOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteTagsForDomainOutput`](crate::output::DeleteTagsForDomainOutput)
        pub fn build(self) -> crate::output::DeleteTagsForDomainOutput {
            crate::output::DeleteTagsForDomainOutput {}
        }
    }
}
impl DeleteTagsForDomainOutput {
    /// Creates a new builder-style object to manufacture [`DeleteTagsForDomainOutput`](crate::output::DeleteTagsForDomainOutput)
    pub fn builder() -> crate::output::delete_tags_for_domain_output::Builder {
        crate::output::delete_tags_for_domain_output::Builder::default()
    }
}

/// <p>The CheckDomainTransferability response includes the following elements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CheckDomainTransferabilityOutput {
    /// <p>A complex type that contains information about whether the specified domain can be transferred to Route 53.</p>
    pub transferability: std::option::Option<crate::model::DomainTransferability>,
}
impl CheckDomainTransferabilityOutput {
    /// <p>A complex type that contains information about whether the specified domain can be transferred to Route 53.</p>
    pub fn transferability(&self) -> std::option::Option<&crate::model::DomainTransferability> {
        self.transferability.as_ref()
    }
}
impl std::fmt::Debug for CheckDomainTransferabilityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CheckDomainTransferabilityOutput");
        formatter.field("transferability", &self.transferability);
        formatter.finish()
    }
}
/// See [`CheckDomainTransferabilityOutput`](crate::output::CheckDomainTransferabilityOutput)
pub mod check_domain_transferability_output {
    /// A builder for [`CheckDomainTransferabilityOutput`](crate::output::CheckDomainTransferabilityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transferability: std::option::Option<crate::model::DomainTransferability>,
    }
    impl Builder {
        /// <p>A complex type that contains information about whether the specified domain can be transferred to Route 53.</p>
        pub fn transferability(mut self, input: crate::model::DomainTransferability) -> Self {
            self.transferability = Some(input);
            self
        }
        /// <p>A complex type that contains information about whether the specified domain can be transferred to Route 53.</p>
        pub fn set_transferability(
            mut self,
            input: std::option::Option<crate::model::DomainTransferability>,
        ) -> Self {
            self.transferability = input;
            self
        }
        /// Consumes the builder and constructs a [`CheckDomainTransferabilityOutput`](crate::output::CheckDomainTransferabilityOutput)
        pub fn build(self) -> crate::output::CheckDomainTransferabilityOutput {
            crate::output::CheckDomainTransferabilityOutput {
                transferability: self.transferability,
            }
        }
    }
}
impl CheckDomainTransferabilityOutput {
    /// Creates a new builder-style object to manufacture [`CheckDomainTransferabilityOutput`](crate::output::CheckDomainTransferabilityOutput)
    pub fn builder() -> crate::output::check_domain_transferability_output::Builder {
        crate::output::check_domain_transferability_output::Builder::default()
    }
}

/// <p>The CheckDomainAvailability response includes the following elements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CheckDomainAvailabilityOutput {
    /// <p>Whether the domain name is available for registering.</p>
    /// <note>
    /// <p>You can register only domains designated as <code>AVAILABLE</code>.</p>
    /// </note>
    /// <p>Valid values:</p>
    /// <dl>
    /// <dt>AVAILABLE</dt>
    /// <dd>
    /// <p>The domain name is available.</p>
    /// </dd>
    /// <dt>AVAILABLE_RESERVED</dt>
    /// <dd>
    /// <p>The domain name is reserved under specific conditions.</p>
    /// </dd>
    /// <dt>AVAILABLE_PREORDER</dt>
    /// <dd>
    /// <p>The domain name is available and can be preordered.</p>
    /// </dd>
    /// <dt>DONT_KNOW</dt>
    /// <dd>
    /// <p>The TLD registry didn't reply with a definitive answer about whether the domain name is available.
    /// Route 53 can return this response for a variety of reasons, for example, the registry is performing maintenance.
    /// Try again later.</p>
    /// </dd>
    /// <dt>PENDING</dt>
    /// <dd>
    /// <p>The TLD registry didn't return a response in the expected amount of time. When the response is delayed,
    /// it usually takes just a few extra seconds. You can resubmit the request immediately.</p>
    /// </dd>
    /// <dt>RESERVED</dt>
    /// <dd>
    /// <p>The domain name has been reserved for another person or organization.</p>
    /// </dd>
    /// <dt>UNAVAILABLE</dt>
    /// <dd>
    /// <p>The domain name is not available.</p>
    /// </dd>
    /// <dt>UNAVAILABLE_PREMIUM</dt>
    /// <dd>
    /// <p>The domain name is not available.</p>
    /// </dd>
    /// <dt>UNAVAILABLE_RESTRICTED</dt>
    /// <dd>
    /// <p>The domain name is forbidden.</p>
    /// </dd>
    /// </dl>
    pub availability: std::option::Option<crate::model::DomainAvailability>,
}
impl CheckDomainAvailabilityOutput {
    /// <p>Whether the domain name is available for registering.</p>
    /// <note>
    /// <p>You can register only domains designated as <code>AVAILABLE</code>.</p>
    /// </note>
    /// <p>Valid values:</p>
    /// <dl>
    /// <dt>AVAILABLE</dt>
    /// <dd>
    /// <p>The domain name is available.</p>
    /// </dd>
    /// <dt>AVAILABLE_RESERVED</dt>
    /// <dd>
    /// <p>The domain name is reserved under specific conditions.</p>
    /// </dd>
    /// <dt>AVAILABLE_PREORDER</dt>
    /// <dd>
    /// <p>The domain name is available and can be preordered.</p>
    /// </dd>
    /// <dt>DONT_KNOW</dt>
    /// <dd>
    /// <p>The TLD registry didn't reply with a definitive answer about whether the domain name is available.
    /// Route 53 can return this response for a variety of reasons, for example, the registry is performing maintenance.
    /// Try again later.</p>
    /// </dd>
    /// <dt>PENDING</dt>
    /// <dd>
    /// <p>The TLD registry didn't return a response in the expected amount of time. When the response is delayed,
    /// it usually takes just a few extra seconds. You can resubmit the request immediately.</p>
    /// </dd>
    /// <dt>RESERVED</dt>
    /// <dd>
    /// <p>The domain name has been reserved for another person or organization.</p>
    /// </dd>
    /// <dt>UNAVAILABLE</dt>
    /// <dd>
    /// <p>The domain name is not available.</p>
    /// </dd>
    /// <dt>UNAVAILABLE_PREMIUM</dt>
    /// <dd>
    /// <p>The domain name is not available.</p>
    /// </dd>
    /// <dt>UNAVAILABLE_RESTRICTED</dt>
    /// <dd>
    /// <p>The domain name is forbidden.</p>
    /// </dd>
    /// </dl>
    pub fn availability(&self) -> std::option::Option<&crate::model::DomainAvailability> {
        self.availability.as_ref()
    }
}
impl std::fmt::Debug for CheckDomainAvailabilityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CheckDomainAvailabilityOutput");
        formatter.field("availability", &self.availability);
        formatter.finish()
    }
}
/// See [`CheckDomainAvailabilityOutput`](crate::output::CheckDomainAvailabilityOutput)
pub mod check_domain_availability_output {
    /// A builder for [`CheckDomainAvailabilityOutput`](crate::output::CheckDomainAvailabilityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) availability: std::option::Option<crate::model::DomainAvailability>,
    }
    impl Builder {
        /// <p>Whether the domain name is available for registering.</p>
        /// <note>
        /// <p>You can register only domains designated as <code>AVAILABLE</code>.</p>
        /// </note>
        /// <p>Valid values:</p>
        /// <dl>
        /// <dt>AVAILABLE</dt>
        /// <dd>
        /// <p>The domain name is available.</p>
        /// </dd>
        /// <dt>AVAILABLE_RESERVED</dt>
        /// <dd>
        /// <p>The domain name is reserved under specific conditions.</p>
        /// </dd>
        /// <dt>AVAILABLE_PREORDER</dt>
        /// <dd>
        /// <p>The domain name is available and can be preordered.</p>
        /// </dd>
        /// <dt>DONT_KNOW</dt>
        /// <dd>
        /// <p>The TLD registry didn't reply with a definitive answer about whether the domain name is available.
        /// Route 53 can return this response for a variety of reasons, for example, the registry is performing maintenance.
        /// Try again later.</p>
        /// </dd>
        /// <dt>PENDING</dt>
        /// <dd>
        /// <p>The TLD registry didn't return a response in the expected amount of time. When the response is delayed,
        /// it usually takes just a few extra seconds. You can resubmit the request immediately.</p>
        /// </dd>
        /// <dt>RESERVED</dt>
        /// <dd>
        /// <p>The domain name has been reserved for another person or organization.</p>
        /// </dd>
        /// <dt>UNAVAILABLE</dt>
        /// <dd>
        /// <p>The domain name is not available.</p>
        /// </dd>
        /// <dt>UNAVAILABLE_PREMIUM</dt>
        /// <dd>
        /// <p>The domain name is not available.</p>
        /// </dd>
        /// <dt>UNAVAILABLE_RESTRICTED</dt>
        /// <dd>
        /// <p>The domain name is forbidden.</p>
        /// </dd>
        /// </dl>
        pub fn availability(mut self, input: crate::model::DomainAvailability) -> Self {
            self.availability = Some(input);
            self
        }
        /// <p>Whether the domain name is available for registering.</p>
        /// <note>
        /// <p>You can register only domains designated as <code>AVAILABLE</code>.</p>
        /// </note>
        /// <p>Valid values:</p>
        /// <dl>
        /// <dt>AVAILABLE</dt>
        /// <dd>
        /// <p>The domain name is available.</p>
        /// </dd>
        /// <dt>AVAILABLE_RESERVED</dt>
        /// <dd>
        /// <p>The domain name is reserved under specific conditions.</p>
        /// </dd>
        /// <dt>AVAILABLE_PREORDER</dt>
        /// <dd>
        /// <p>The domain name is available and can be preordered.</p>
        /// </dd>
        /// <dt>DONT_KNOW</dt>
        /// <dd>
        /// <p>The TLD registry didn't reply with a definitive answer about whether the domain name is available.
        /// Route 53 can return this response for a variety of reasons, for example, the registry is performing maintenance.
        /// Try again later.</p>
        /// </dd>
        /// <dt>PENDING</dt>
        /// <dd>
        /// <p>The TLD registry didn't return a response in the expected amount of time. When the response is delayed,
        /// it usually takes just a few extra seconds. You can resubmit the request immediately.</p>
        /// </dd>
        /// <dt>RESERVED</dt>
        /// <dd>
        /// <p>The domain name has been reserved for another person or organization.</p>
        /// </dd>
        /// <dt>UNAVAILABLE</dt>
        /// <dd>
        /// <p>The domain name is not available.</p>
        /// </dd>
        /// <dt>UNAVAILABLE_PREMIUM</dt>
        /// <dd>
        /// <p>The domain name is not available.</p>
        /// </dd>
        /// <dt>UNAVAILABLE_RESTRICTED</dt>
        /// <dd>
        /// <p>The domain name is forbidden.</p>
        /// </dd>
        /// </dl>
        pub fn set_availability(
            mut self,
            input: std::option::Option<crate::model::DomainAvailability>,
        ) -> Self {
            self.availability = input;
            self
        }
        /// Consumes the builder and constructs a [`CheckDomainAvailabilityOutput`](crate::output::CheckDomainAvailabilityOutput)
        pub fn build(self) -> crate::output::CheckDomainAvailabilityOutput {
            crate::output::CheckDomainAvailabilityOutput {
                availability: self.availability,
            }
        }
    }
}
impl CheckDomainAvailabilityOutput {
    /// Creates a new builder-style object to manufacture [`CheckDomainAvailabilityOutput`](crate::output::CheckDomainAvailabilityOutput)
    pub fn builder() -> crate::output::check_domain_availability_output::Builder {
        crate::output::check_domain_availability_output::Builder::default()
    }
}

/// <p>The <code>CancelDomainTransferToAnotherAwsAccount</code> response includes the following element.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelDomainTransferToAnotherAwsAccountOutput {
    /// <p>The identifier that <code>TransferDomainToAnotherAwsAccount</code> returned to track the progress of the request.
    /// Because the transfer request was canceled, the value is no longer valid, and you can't use <code>GetOperationDetail</code>
    /// to query the operation status.</p>
    pub operation_id: std::option::Option<std::string::String>,
}
impl CancelDomainTransferToAnotherAwsAccountOutput {
    /// <p>The identifier that <code>TransferDomainToAnotherAwsAccount</code> returned to track the progress of the request.
    /// Because the transfer request was canceled, the value is no longer valid, and you can't use <code>GetOperationDetail</code>
    /// to query the operation status.</p>
    pub fn operation_id(&self) -> std::option::Option<&str> {
        self.operation_id.as_deref()
    }
}
impl std::fmt::Debug for CancelDomainTransferToAnotherAwsAccountOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelDomainTransferToAnotherAwsAccountOutput");
        formatter.field("operation_id", &self.operation_id);
        formatter.finish()
    }
}
/// See [`CancelDomainTransferToAnotherAwsAccountOutput`](crate::output::CancelDomainTransferToAnotherAwsAccountOutput)
pub mod cancel_domain_transfer_to_another_aws_account_output {
    /// A builder for [`CancelDomainTransferToAnotherAwsAccountOutput`](crate::output::CancelDomainTransferToAnotherAwsAccountOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier that <code>TransferDomainToAnotherAwsAccount</code> returned to track the progress of the request.
        /// Because the transfer request was canceled, the value is no longer valid, and you can't use <code>GetOperationDetail</code>
        /// to query the operation status.</p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>The identifier that <code>TransferDomainToAnotherAwsAccount</code> returned to track the progress of the request.
        /// Because the transfer request was canceled, the value is no longer valid, and you can't use <code>GetOperationDetail</code>
        /// to query the operation status.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelDomainTransferToAnotherAwsAccountOutput`](crate::output::CancelDomainTransferToAnotherAwsAccountOutput)
        pub fn build(self) -> crate::output::CancelDomainTransferToAnotherAwsAccountOutput {
            crate::output::CancelDomainTransferToAnotherAwsAccountOutput {
                operation_id: self.operation_id,
            }
        }
    }
}
impl CancelDomainTransferToAnotherAwsAccountOutput {
    /// Creates a new builder-style object to manufacture [`CancelDomainTransferToAnotherAwsAccountOutput`](crate::output::CancelDomainTransferToAnotherAwsAccountOutput)
    pub fn builder() -> crate::output::cancel_domain_transfer_to_another_aws_account_output::Builder
    {
        crate::output::cancel_domain_transfer_to_another_aws_account_output::Builder::default()
    }
}

/// <p>The AcceptDomainTransferFromAnotherAwsAccount response includes the following element.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcceptDomainTransferFromAnotherAwsAccountOutput {
    /// <p>Identifier for tracking the progress of the request. To query the operation status, use
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>.</p>
    pub operation_id: std::option::Option<std::string::String>,
}
impl AcceptDomainTransferFromAnotherAwsAccountOutput {
    /// <p>Identifier for tracking the progress of the request. To query the operation status, use
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>.</p>
    pub fn operation_id(&self) -> std::option::Option<&str> {
        self.operation_id.as_deref()
    }
}
impl std::fmt::Debug for AcceptDomainTransferFromAnotherAwsAccountOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcceptDomainTransferFromAnotherAwsAccountOutput");
        formatter.field("operation_id", &self.operation_id);
        formatter.finish()
    }
}
/// See [`AcceptDomainTransferFromAnotherAwsAccountOutput`](crate::output::AcceptDomainTransferFromAnotherAwsAccountOutput)
pub mod accept_domain_transfer_from_another_aws_account_output {
    /// A builder for [`AcceptDomainTransferFromAnotherAwsAccountOutput`](crate::output::AcceptDomainTransferFromAnotherAwsAccountOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Identifier for tracking the progress of the request. To query the operation status, use
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>.</p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>Identifier for tracking the progress of the request. To query the operation status, use
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html">GetOperationDetail</a>.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AcceptDomainTransferFromAnotherAwsAccountOutput`](crate::output::AcceptDomainTransferFromAnotherAwsAccountOutput)
        pub fn build(self) -> crate::output::AcceptDomainTransferFromAnotherAwsAccountOutput {
            crate::output::AcceptDomainTransferFromAnotherAwsAccountOutput {
                operation_id: self.operation_id,
            }
        }
    }
}
impl AcceptDomainTransferFromAnotherAwsAccountOutput {
    /// Creates a new builder-style object to manufacture [`AcceptDomainTransferFromAnotherAwsAccountOutput`](crate::output::AcceptDomainTransferFromAnotherAwsAccountOutput)
    pub fn builder(
    ) -> crate::output::accept_domain_transfer_from_another_aws_account_output::Builder {
        crate::output::accept_domain_transfer_from_another_aws_account_output::Builder::default()
    }
}
