// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Route 53
///
/// Client for invoking operations on Amazon Route 53. Each operation on Amazon Route 53 is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_route53::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_route53::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_route53::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`ActivateKeySigningKey`](crate::client::fluent_builders::ActivateKeySigningKey) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hosted_zone_id(impl Into<String>)`](crate::client::fluent_builders::ActivateKeySigningKey::hosted_zone_id) / [`set_hosted_zone_id(Option<String>)`](crate::client::fluent_builders::ActivateKeySigningKey::set_hosted_zone_id): <p>A unique string used to identify a hosted zone.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::ActivateKeySigningKey::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::ActivateKeySigningKey::set_name): <p>A string used to identify a key-signing key (KSK). <code>Name</code> can include numbers, letters, and underscores (_). <code>Name</code> must be unique for each key-signing key in the same hosted zone.</p>
    /// - On success, responds with [`ActivateKeySigningKeyOutput`](crate::output::ActivateKeySigningKeyOutput) with field(s):
    ///   - [`change_info(Option<ChangeInfo>)`](crate::output::ActivateKeySigningKeyOutput::change_info): <p>A complex type that describes change information about changes made to your hosted zone.</p>
    /// - On failure, responds with [`SdkError<ActivateKeySigningKeyError>`](crate::error::ActivateKeySigningKeyError)
    pub fn activate_key_signing_key(&self) -> fluent_builders::ActivateKeySigningKey {
        fluent_builders::ActivateKeySigningKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateVPCWithHostedZone`](crate::client::fluent_builders::AssociateVPCWithHostedZone) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hosted_zone_id(impl Into<String>)`](crate::client::fluent_builders::AssociateVPCWithHostedZone::hosted_zone_id) / [`set_hosted_zone_id(Option<String>)`](crate::client::fluent_builders::AssociateVPCWithHostedZone::set_hosted_zone_id): <p>The ID of the private hosted zone that you want to associate an Amazon VPC with.</p>  <p>Note that you can't associate a VPC with a hosted zone that doesn't have an existing VPC association.</p>
    ///   - [`vpc(Vpc)`](crate::client::fluent_builders::AssociateVPCWithHostedZone::vpc) / [`set_vpc(Option<Vpc>)`](crate::client::fluent_builders::AssociateVPCWithHostedZone::set_vpc): <p>A complex type that contains information about the VPC that you want to associate with a private hosted zone.</p>
    ///   - [`comment(impl Into<String>)`](crate::client::fluent_builders::AssociateVPCWithHostedZone::comment) / [`set_comment(Option<String>)`](crate::client::fluent_builders::AssociateVPCWithHostedZone::set_comment): <p> <i>Optional:</i> A comment about the association request.</p>
    /// - On success, responds with [`AssociateVpcWithHostedZoneOutput`](crate::output::AssociateVpcWithHostedZoneOutput) with field(s):
    ///   - [`change_info(Option<ChangeInfo>)`](crate::output::AssociateVpcWithHostedZoneOutput::change_info): <p>A complex type that describes the changes made to your hosted zone.</p>
    /// - On failure, responds with [`SdkError<AssociateVPCWithHostedZoneError>`](crate::error::AssociateVPCWithHostedZoneError)
    pub fn associate_vpc_with_hosted_zone(&self) -> fluent_builders::AssociateVPCWithHostedZone {
        fluent_builders::AssociateVPCWithHostedZone::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ChangeResourceRecordSets`](crate::client::fluent_builders::ChangeResourceRecordSets) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hosted_zone_id(impl Into<String>)`](crate::client::fluent_builders::ChangeResourceRecordSets::hosted_zone_id) / [`set_hosted_zone_id(Option<String>)`](crate::client::fluent_builders::ChangeResourceRecordSets::set_hosted_zone_id): <p>The ID of the hosted zone that contains the resource record sets that you want to change.</p>
    ///   - [`change_batch(ChangeBatch)`](crate::client::fluent_builders::ChangeResourceRecordSets::change_batch) / [`set_change_batch(Option<ChangeBatch>)`](crate::client::fluent_builders::ChangeResourceRecordSets::set_change_batch): <p>A complex type that contains an optional comment and the <code>Changes</code> element.</p>
    /// - On success, responds with [`ChangeResourceRecordSetsOutput`](crate::output::ChangeResourceRecordSetsOutput) with field(s):
    ///   - [`change_info(Option<ChangeInfo>)`](crate::output::ChangeResourceRecordSetsOutput::change_info): <p>A complex type that contains information about changes made to your hosted zone.</p>  <p>This element contains an ID that you use when performing a <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetChange.html">GetChange</a> action to get detailed information about the change.</p>
    /// - On failure, responds with [`SdkError<ChangeResourceRecordSetsError>`](crate::error::ChangeResourceRecordSetsError)
    pub fn change_resource_record_sets(&self) -> fluent_builders::ChangeResourceRecordSets {
        fluent_builders::ChangeResourceRecordSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ChangeTagsForResource`](crate::client::fluent_builders::ChangeTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_type(TagResourceType)`](crate::client::fluent_builders::ChangeTagsForResource::resource_type) / [`set_resource_type(Option<TagResourceType>)`](crate::client::fluent_builders::ChangeTagsForResource::set_resource_type): <p>The type of the resource.</p>  <ul>   <li> <p>The resource type for health checks is <code>healthcheck</code>.</p> </li>   <li> <p>The resource type for hosted zones is <code>hostedzone</code>.</p> </li>  </ul>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::ChangeTagsForResource::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::ChangeTagsForResource::set_resource_id): <p>The ID of the resource for which you want to add, change, or delete tags.</p>
    ///   - [`add_tags(Vec<Tag>)`](crate::client::fluent_builders::ChangeTagsForResource::add_tags) / [`set_add_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::ChangeTagsForResource::set_add_tags): <p>A complex type that contains a list of the tags that you want to add to the specified health check or hosted zone and/or the tags that you want to edit <code>Value</code> for.</p>  <p>You can add a maximum of 10 tags to a health check or a hosted zone.</p>
    ///   - [`remove_tag_keys(Vec<String>)`](crate::client::fluent_builders::ChangeTagsForResource::remove_tag_keys) / [`set_remove_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::ChangeTagsForResource::set_remove_tag_keys): <p>A complex type that contains a list of the tags that you want to delete from the specified health check or hosted zone. You can specify up to 10 keys.</p>
    /// - On success, responds with [`ChangeTagsForResourceOutput`](crate::output::ChangeTagsForResourceOutput)

    /// - On failure, responds with [`SdkError<ChangeTagsForResourceError>`](crate::error::ChangeTagsForResourceError)
    pub fn change_tags_for_resource(&self) -> fluent_builders::ChangeTagsForResource {
        fluent_builders::ChangeTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateHealthCheck`](crate::client::fluent_builders::CreateHealthCheck) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`caller_reference(impl Into<String>)`](crate::client::fluent_builders::CreateHealthCheck::caller_reference) / [`set_caller_reference(Option<String>)`](crate::client::fluent_builders::CreateHealthCheck::set_caller_reference): <p>A unique string that identifies the request and that allows you to retry a failed <code>CreateHealthCheck</code> request without the risk of creating two identical health checks:</p>  <ul>   <li> <p>If you send a <code>CreateHealthCheck</code> request with the same <code>CallerReference</code> and settings as a previous request, and if the health check doesn't exist, Amazon Route 53 creates the health check. If the health check does exist, Route 53 returns the settings for the existing health check.</p> </li>   <li> <p>If you send a <code>CreateHealthCheck</code> request with the same <code>CallerReference</code> as a deleted health check, regardless of the settings, Route 53 returns a <code>HealthCheckAlreadyExists</code> error.</p> </li>   <li> <p>If you send a <code>CreateHealthCheck</code> request with the same <code>CallerReference</code> as an existing health check but with different settings, Route 53 returns a <code>HealthCheckAlreadyExists</code> error.</p> </li>   <li> <p>If you send a <code>CreateHealthCheck</code> request with a unique <code>CallerReference</code> but settings identical to an existing health check, Route 53 creates the health check.</p> </li>  </ul>
    ///   - [`health_check_config(HealthCheckConfig)`](crate::client::fluent_builders::CreateHealthCheck::health_check_config) / [`set_health_check_config(Option<HealthCheckConfig>)`](crate::client::fluent_builders::CreateHealthCheck::set_health_check_config): <p>A complex type that contains settings for a new health check.</p>
    /// - On success, responds with [`CreateHealthCheckOutput`](crate::output::CreateHealthCheckOutput) with field(s):
    ///   - [`health_check(Option<HealthCheck>)`](crate::output::CreateHealthCheckOutput::health_check): <p>A complex type that contains identifying information about the health check.</p>
    ///   - [`location(Option<String>)`](crate::output::CreateHealthCheckOutput::location): <p>The unique URL representing the new health check.</p>
    /// - On failure, responds with [`SdkError<CreateHealthCheckError>`](crate::error::CreateHealthCheckError)
    pub fn create_health_check(&self) -> fluent_builders::CreateHealthCheck {
        fluent_builders::CreateHealthCheck::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateHostedZone`](crate::client::fluent_builders::CreateHostedZone) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateHostedZone::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateHostedZone::set_name): <p>The name of the domain. Specify a fully qualified domain name, for example, <i>www.example.com</i>. The trailing dot is optional; Amazon Route 53 assumes that the domain name is fully qualified. This means that Route 53 treats <i>www.example.com</i> (without a trailing dot) and <i>www.example.com.</i> (with a trailing dot) as identical.</p>  <p>If you're creating a public hosted zone, this is the name you have registered with your DNS registrar. If your domain name is registered with a registrar other than Route 53, change the name servers for your domain to the set of <code>NameServers</code> that <code>CreateHostedZone</code> returns in <code>DelegationSet</code>.</p>
    ///   - [`vpc(Vpc)`](crate::client::fluent_builders::CreateHostedZone::vpc) / [`set_vpc(Option<Vpc>)`](crate::client::fluent_builders::CreateHostedZone::set_vpc): <p>(Private hosted zones only) A complex type that contains information about the Amazon VPC that you're associating with this hosted zone.</p>  <p>You can specify only one Amazon VPC when you create a private hosted zone. If you are associating a VPC with a hosted zone with this request, the paramaters <code>VPCId</code> and <code>VPCRegion</code> are also required.</p>  <p>To associate additional Amazon VPCs with the hosted zone, use <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_AssociateVPCWithHostedZone.html">AssociateVPCWithHostedZone</a> after you create a hosted zone.</p>
    ///   - [`caller_reference(impl Into<String>)`](crate::client::fluent_builders::CreateHostedZone::caller_reference) / [`set_caller_reference(Option<String>)`](crate::client::fluent_builders::CreateHostedZone::set_caller_reference): <p>A unique string that identifies the request and that allows failed <code>CreateHostedZone</code> requests to be retried without the risk of executing the operation twice. You must use a unique <code>CallerReference</code> string every time you submit a <code>CreateHostedZone</code> request. <code>CallerReference</code> can be any unique string, for example, a date/time stamp.</p>
    ///   - [`hosted_zone_config(HostedZoneConfig)`](crate::client::fluent_builders::CreateHostedZone::hosted_zone_config) / [`set_hosted_zone_config(Option<HostedZoneConfig>)`](crate::client::fluent_builders::CreateHostedZone::set_hosted_zone_config): <p>(Optional) A complex type that contains the following optional values:</p>  <ul>   <li> <p>For public and private hosted zones, an optional comment</p> </li>   <li> <p>For private hosted zones, an optional <code>PrivateZone</code> element</p> </li>  </ul>  <p>If you don't specify a comment or the <code>PrivateZone</code> element, omit <code>HostedZoneConfig</code> and the other elements.</p>
    ///   - [`delegation_set_id(impl Into<String>)`](crate::client::fluent_builders::CreateHostedZone::delegation_set_id) / [`set_delegation_set_id(Option<String>)`](crate::client::fluent_builders::CreateHostedZone::set_delegation_set_id): <p>If you want to associate a reusable delegation set with this hosted zone, the ID that Amazon Route 53 assigned to the reusable delegation set when you created it. For more information about reusable delegation sets, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateReusableDelegationSet.html">CreateReusableDelegationSet</a>.</p>
    /// - On success, responds with [`CreateHostedZoneOutput`](crate::output::CreateHostedZoneOutput) with field(s):
    ///   - [`hosted_zone(Option<HostedZone>)`](crate::output::CreateHostedZoneOutput::hosted_zone): <p>A complex type that contains general information about the hosted zone.</p>
    ///   - [`change_info(Option<ChangeInfo>)`](crate::output::CreateHostedZoneOutput::change_info): <p>A complex type that contains information about the <code>CreateHostedZone</code> request.</p>
    ///   - [`delegation_set(Option<DelegationSet>)`](crate::output::CreateHostedZoneOutput::delegation_set): <p>A complex type that describes the name servers for this hosted zone.</p>
    ///   - [`vpc(Option<Vpc>)`](crate::output::CreateHostedZoneOutput::vpc): <p>A complex type that contains information about an Amazon VPC that you associated with this hosted zone.</p>
    ///   - [`location(Option<String>)`](crate::output::CreateHostedZoneOutput::location): <p>The unique URL representing the new hosted zone.</p>
    /// - On failure, responds with [`SdkError<CreateHostedZoneError>`](crate::error::CreateHostedZoneError)
    pub fn create_hosted_zone(&self) -> fluent_builders::CreateHostedZone {
        fluent_builders::CreateHostedZone::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateKeySigningKey`](crate::client::fluent_builders::CreateKeySigningKey) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`caller_reference(impl Into<String>)`](crate::client::fluent_builders::CreateKeySigningKey::caller_reference) / [`set_caller_reference(Option<String>)`](crate::client::fluent_builders::CreateKeySigningKey::set_caller_reference): <p>A unique string that identifies the request.</p>
    ///   - [`hosted_zone_id(impl Into<String>)`](crate::client::fluent_builders::CreateKeySigningKey::hosted_zone_id) / [`set_hosted_zone_id(Option<String>)`](crate::client::fluent_builders::CreateKeySigningKey::set_hosted_zone_id): <p>The unique string (ID) used to identify a hosted zone.</p>
    ///   - [`key_management_service_arn(impl Into<String>)`](crate::client::fluent_builders::CreateKeySigningKey::key_management_service_arn) / [`set_key_management_service_arn(Option<String>)`](crate::client::fluent_builders::CreateKeySigningKey::set_key_management_service_arn): <p>The Amazon resource name (ARN) for a customer managed key in Key Management Service (KMS). The <code>KeyManagementServiceArn</code> must be unique for each key-signing key (KSK) in a single hosted zone. To see an example of <code>KeyManagementServiceArn</code> that grants the correct permissions for DNSSEC, scroll down to <b>Example</b>. </p>  <p>You must configure the customer managed customer managed key as follows:</p>  <dl>   <dt>   Status  </dt>   <dd>    <p>Enabled</p>   </dd>   <dt>   Key spec  </dt>   <dd>    <p>ECC_NIST_P256</p>   </dd>   <dt>   Key usage  </dt>   <dd>    <p>Sign and verify</p>   </dd>   <dt>   Key policy  </dt>   <dd>    <p>The key policy must give permission for the following actions:</p>    <ul>     <li> <p>DescribeKey</p> </li>     <li> <p>GetPublicKey</p> </li>     <li> <p>Sign</p> </li>    </ul>    <p>The key policy must also include the Amazon Route 53 service in the principal for your account. Specify the following:</p>    <ul>     <li> <p> <code>"Service": "dnssec-route53.amazonaws.com"</code> </p> </li>    </ul>   </dd>  </dl>  <p>For more information about working with a customer managed key in KMS, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html">Key Management Service concepts</a>.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateKeySigningKey::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateKeySigningKey::set_name): <p>A string used to identify a key-signing key (KSK). <code>Name</code> can include numbers, letters, and underscores (_). <code>Name</code> must be unique for each key-signing key in the same hosted zone.</p>
    ///   - [`status(impl Into<String>)`](crate::client::fluent_builders::CreateKeySigningKey::status) / [`set_status(Option<String>)`](crate::client::fluent_builders::CreateKeySigningKey::set_status): <p>A string specifying the initial status of the key-signing key (KSK). You can set the value to <code>ACTIVE</code> or <code>INACTIVE</code>.</p>
    /// - On success, responds with [`CreateKeySigningKeyOutput`](crate::output::CreateKeySigningKeyOutput) with field(s):
    ///   - [`change_info(Option<ChangeInfo>)`](crate::output::CreateKeySigningKeyOutput::change_info): <p>A complex type that describes change information about changes made to your hosted zone.</p>
    ///   - [`key_signing_key(Option<KeySigningKey>)`](crate::output::CreateKeySigningKeyOutput::key_signing_key): <p>The key-signing key (KSK) that the request creates.</p>
    ///   - [`location(Option<String>)`](crate::output::CreateKeySigningKeyOutput::location): <p>The unique URL representing the new key-signing key (KSK).</p>
    /// - On failure, responds with [`SdkError<CreateKeySigningKeyError>`](crate::error::CreateKeySigningKeyError)
    pub fn create_key_signing_key(&self) -> fluent_builders::CreateKeySigningKey {
        fluent_builders::CreateKeySigningKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateQueryLoggingConfig`](crate::client::fluent_builders::CreateQueryLoggingConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hosted_zone_id(impl Into<String>)`](crate::client::fluent_builders::CreateQueryLoggingConfig::hosted_zone_id) / [`set_hosted_zone_id(Option<String>)`](crate::client::fluent_builders::CreateQueryLoggingConfig::set_hosted_zone_id): <p>The ID of the hosted zone that you want to log queries for. You can log queries only for public hosted zones.</p>
    ///   - [`cloud_watch_logs_log_group_arn(impl Into<String>)`](crate::client::fluent_builders::CreateQueryLoggingConfig::cloud_watch_logs_log_group_arn) / [`set_cloud_watch_logs_log_group_arn(Option<String>)`](crate::client::fluent_builders::CreateQueryLoggingConfig::set_cloud_watch_logs_log_group_arn): <p>The Amazon Resource Name (ARN) for the log group that you want to Amazon Route 53 to send query logs to. This is the format of the ARN:</p>  <p>arn:aws:logs:<i>region</i>:<i>account-id</i>:log-group:<i>log_group_name</i> </p>  <p>To get the ARN for a log group, you can use the CloudWatch console, the <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeLogGroups.html">DescribeLogGroups</a> API action, the <a href="https://docs.aws.amazon.com/cli/latest/reference/logs/describe-log-groups.html">describe-log-groups</a> command, or the applicable command in one of the Amazon Web Services SDKs.</p>
    /// - On success, responds with [`CreateQueryLoggingConfigOutput`](crate::output::CreateQueryLoggingConfigOutput) with field(s):
    ///   - [`query_logging_config(Option<QueryLoggingConfig>)`](crate::output::CreateQueryLoggingConfigOutput::query_logging_config): <p>A complex type that contains the ID for a query logging configuration, the ID of the hosted zone that you want to log queries for, and the ARN for the log group that you want Amazon Route 53 to send query logs to.</p>
    ///   - [`location(Option<String>)`](crate::output::CreateQueryLoggingConfigOutput::location): <p>The unique URL representing the new query logging configuration.</p>
    /// - On failure, responds with [`SdkError<CreateQueryLoggingConfigError>`](crate::error::CreateQueryLoggingConfigError)
    pub fn create_query_logging_config(&self) -> fluent_builders::CreateQueryLoggingConfig {
        fluent_builders::CreateQueryLoggingConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateReusableDelegationSet`](crate::client::fluent_builders::CreateReusableDelegationSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`caller_reference(impl Into<String>)`](crate::client::fluent_builders::CreateReusableDelegationSet::caller_reference) / [`set_caller_reference(Option<String>)`](crate::client::fluent_builders::CreateReusableDelegationSet::set_caller_reference): <p>A unique string that identifies the request, and that allows you to retry failed <code>CreateReusableDelegationSet</code> requests without the risk of executing the operation twice. You must use a unique <code>CallerReference</code> string every time you submit a <code>CreateReusableDelegationSet</code> request. <code>CallerReference</code> can be any unique string, for example a date/time stamp.</p>
    ///   - [`hosted_zone_id(impl Into<String>)`](crate::client::fluent_builders::CreateReusableDelegationSet::hosted_zone_id) / [`set_hosted_zone_id(Option<String>)`](crate::client::fluent_builders::CreateReusableDelegationSet::set_hosted_zone_id): <p>If you want to mark the delegation set for an existing hosted zone as reusable, the ID for that hosted zone.</p>
    /// - On success, responds with [`CreateReusableDelegationSetOutput`](crate::output::CreateReusableDelegationSetOutput) with field(s):
    ///   - [`delegation_set(Option<DelegationSet>)`](crate::output::CreateReusableDelegationSetOutput::delegation_set): <p>A complex type that contains name server information.</p>
    ///   - [`location(Option<String>)`](crate::output::CreateReusableDelegationSetOutput::location): <p>The unique URL representing the new reusable delegation set.</p>
    /// - On failure, responds with [`SdkError<CreateReusableDelegationSetError>`](crate::error::CreateReusableDelegationSetError)
    pub fn create_reusable_delegation_set(&self) -> fluent_builders::CreateReusableDelegationSet {
        fluent_builders::CreateReusableDelegationSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTrafficPolicy`](crate::client::fluent_builders::CreateTrafficPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateTrafficPolicy::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateTrafficPolicy::set_name): <p>The name of the traffic policy.</p>
    ///   - [`document(impl Into<String>)`](crate::client::fluent_builders::CreateTrafficPolicy::document) / [`set_document(Option<String>)`](crate::client::fluent_builders::CreateTrafficPolicy::set_document): <p>The definition of this traffic policy in JSON format. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/api-policies-traffic-policy-document-format.html">Traffic Policy Document Format</a>.</p>
    ///   - [`comment(impl Into<String>)`](crate::client::fluent_builders::CreateTrafficPolicy::comment) / [`set_comment(Option<String>)`](crate::client::fluent_builders::CreateTrafficPolicy::set_comment): <p>(Optional) Any comments that you want to include about the traffic policy.</p>
    /// - On success, responds with [`CreateTrafficPolicyOutput`](crate::output::CreateTrafficPolicyOutput) with field(s):
    ///   - [`traffic_policy(Option<TrafficPolicy>)`](crate::output::CreateTrafficPolicyOutput::traffic_policy): <p>A complex type that contains settings for the new traffic policy.</p>
    ///   - [`location(Option<String>)`](crate::output::CreateTrafficPolicyOutput::location): <p>A unique URL that represents a new traffic policy.</p>
    /// - On failure, responds with [`SdkError<CreateTrafficPolicyError>`](crate::error::CreateTrafficPolicyError)
    pub fn create_traffic_policy(&self) -> fluent_builders::CreateTrafficPolicy {
        fluent_builders::CreateTrafficPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTrafficPolicyInstance`](crate::client::fluent_builders::CreateTrafficPolicyInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hosted_zone_id(impl Into<String>)`](crate::client::fluent_builders::CreateTrafficPolicyInstance::hosted_zone_id) / [`set_hosted_zone_id(Option<String>)`](crate::client::fluent_builders::CreateTrafficPolicyInstance::set_hosted_zone_id): <p>The ID of the hosted zone that you want Amazon Route 53 to create resource record sets in by using the configuration in a traffic policy.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateTrafficPolicyInstance::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateTrafficPolicyInstance::set_name): <p>The domain name (such as example.com) or subdomain name (such as www.example.com) for which Amazon Route 53 responds to DNS queries by using the resource record sets that Route 53 creates for this traffic policy instance.</p>
    ///   - [`ttl(i64)`](crate::client::fluent_builders::CreateTrafficPolicyInstance::ttl) / [`set_ttl(Option<i64>)`](crate::client::fluent_builders::CreateTrafficPolicyInstance::set_ttl): <p>(Optional) The TTL that you want Amazon Route 53 to assign to all of the resource record sets that it creates in the specified hosted zone.</p>
    ///   - [`traffic_policy_id(impl Into<String>)`](crate::client::fluent_builders::CreateTrafficPolicyInstance::traffic_policy_id) / [`set_traffic_policy_id(Option<String>)`](crate::client::fluent_builders::CreateTrafficPolicyInstance::set_traffic_policy_id): <p>The ID of the traffic policy that you want to use to create resource record sets in the specified hosted zone.</p>
    ///   - [`traffic_policy_version(i32)`](crate::client::fluent_builders::CreateTrafficPolicyInstance::traffic_policy_version) / [`set_traffic_policy_version(Option<i32>)`](crate::client::fluent_builders::CreateTrafficPolicyInstance::set_traffic_policy_version): <p>The version of the traffic policy that you want to use to create resource record sets in the specified hosted zone.</p>
    /// - On success, responds with [`CreateTrafficPolicyInstanceOutput`](crate::output::CreateTrafficPolicyInstanceOutput) with field(s):
    ///   - [`traffic_policy_instance(Option<TrafficPolicyInstance>)`](crate::output::CreateTrafficPolicyInstanceOutput::traffic_policy_instance): <p>A complex type that contains settings for the new traffic policy instance.</p>
    ///   - [`location(Option<String>)`](crate::output::CreateTrafficPolicyInstanceOutput::location): <p>A unique URL that represents a new traffic policy instance.</p>
    /// - On failure, responds with [`SdkError<CreateTrafficPolicyInstanceError>`](crate::error::CreateTrafficPolicyInstanceError)
    pub fn create_traffic_policy_instance(&self) -> fluent_builders::CreateTrafficPolicyInstance {
        fluent_builders::CreateTrafficPolicyInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTrafficPolicyVersion`](crate::client::fluent_builders::CreateTrafficPolicyVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::CreateTrafficPolicyVersion::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::CreateTrafficPolicyVersion::set_id): <p>The ID of the traffic policy for which you want to create a new version.</p>
    ///   - [`document(impl Into<String>)`](crate::client::fluent_builders::CreateTrafficPolicyVersion::document) / [`set_document(Option<String>)`](crate::client::fluent_builders::CreateTrafficPolicyVersion::set_document): <p>The definition of this version of the traffic policy, in JSON format. You specified the JSON in the <code>CreateTrafficPolicyVersion</code> request. For more information about the JSON format, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateTrafficPolicy.html">CreateTrafficPolicy</a>.</p>
    ///   - [`comment(impl Into<String>)`](crate::client::fluent_builders::CreateTrafficPolicyVersion::comment) / [`set_comment(Option<String>)`](crate::client::fluent_builders::CreateTrafficPolicyVersion::set_comment): <p>The comment that you specified in the <code>CreateTrafficPolicyVersion</code> request, if any.</p>
    /// - On success, responds with [`CreateTrafficPolicyVersionOutput`](crate::output::CreateTrafficPolicyVersionOutput) with field(s):
    ///   - [`traffic_policy(Option<TrafficPolicy>)`](crate::output::CreateTrafficPolicyVersionOutput::traffic_policy): <p>A complex type that contains settings for the new version of the traffic policy.</p>
    ///   - [`location(Option<String>)`](crate::output::CreateTrafficPolicyVersionOutput::location): <p>A unique URL that represents a new traffic policy version.</p>
    /// - On failure, responds with [`SdkError<CreateTrafficPolicyVersionError>`](crate::error::CreateTrafficPolicyVersionError)
    pub fn create_traffic_policy_version(&self) -> fluent_builders::CreateTrafficPolicyVersion {
        fluent_builders::CreateTrafficPolicyVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateVPCAssociationAuthorization`](crate::client::fluent_builders::CreateVPCAssociationAuthorization) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hosted_zone_id(impl Into<String>)`](crate::client::fluent_builders::CreateVPCAssociationAuthorization::hosted_zone_id) / [`set_hosted_zone_id(Option<String>)`](crate::client::fluent_builders::CreateVPCAssociationAuthorization::set_hosted_zone_id): <p>The ID of the private hosted zone that you want to authorize associating a VPC with.</p>
    ///   - [`vpc(Vpc)`](crate::client::fluent_builders::CreateVPCAssociationAuthorization::vpc) / [`set_vpc(Option<Vpc>)`](crate::client::fluent_builders::CreateVPCAssociationAuthorization::set_vpc): <p>A complex type that contains the VPC ID and region for the VPC that you want to authorize associating with your hosted zone.</p>
    /// - On success, responds with [`CreateVpcAssociationAuthorizationOutput`](crate::output::CreateVpcAssociationAuthorizationOutput) with field(s):
    ///   - [`hosted_zone_id(Option<String>)`](crate::output::CreateVpcAssociationAuthorizationOutput::hosted_zone_id): <p>The ID of the hosted zone that you authorized associating a VPC with.</p>
    ///   - [`vpc(Option<Vpc>)`](crate::output::CreateVpcAssociationAuthorizationOutput::vpc): <p>The VPC that you authorized associating with a hosted zone.</p>
    /// - On failure, responds with [`SdkError<CreateVPCAssociationAuthorizationError>`](crate::error::CreateVPCAssociationAuthorizationError)
    pub fn create_vpc_association_authorization(
        &self,
    ) -> fluent_builders::CreateVPCAssociationAuthorization {
        fluent_builders::CreateVPCAssociationAuthorization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeactivateKeySigningKey`](crate::client::fluent_builders::DeactivateKeySigningKey) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hosted_zone_id(impl Into<String>)`](crate::client::fluent_builders::DeactivateKeySigningKey::hosted_zone_id) / [`set_hosted_zone_id(Option<String>)`](crate::client::fluent_builders::DeactivateKeySigningKey::set_hosted_zone_id): <p>A unique string used to identify a hosted zone.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeactivateKeySigningKey::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeactivateKeySigningKey::set_name): <p>A string used to identify a key-signing key (KSK).</p>
    /// - On success, responds with [`DeactivateKeySigningKeyOutput`](crate::output::DeactivateKeySigningKeyOutput) with field(s):
    ///   - [`change_info(Option<ChangeInfo>)`](crate::output::DeactivateKeySigningKeyOutput::change_info): <p>A complex type that describes change information about changes made to your hosted zone.</p>
    /// - On failure, responds with [`SdkError<DeactivateKeySigningKeyError>`](crate::error::DeactivateKeySigningKeyError)
    pub fn deactivate_key_signing_key(&self) -> fluent_builders::DeactivateKeySigningKey {
        fluent_builders::DeactivateKeySigningKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteHealthCheck`](crate::client::fluent_builders::DeleteHealthCheck) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`health_check_id(impl Into<String>)`](crate::client::fluent_builders::DeleteHealthCheck::health_check_id) / [`set_health_check_id(Option<String>)`](crate::client::fluent_builders::DeleteHealthCheck::set_health_check_id): <p>The ID of the health check that you want to delete.</p>
    /// - On success, responds with [`DeleteHealthCheckOutput`](crate::output::DeleteHealthCheckOutput)

    /// - On failure, responds with [`SdkError<DeleteHealthCheckError>`](crate::error::DeleteHealthCheckError)
    pub fn delete_health_check(&self) -> fluent_builders::DeleteHealthCheck {
        fluent_builders::DeleteHealthCheck::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteHostedZone`](crate::client::fluent_builders::DeleteHostedZone) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteHostedZone::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteHostedZone::set_id): <p>The ID of the hosted zone you want to delete.</p>
    /// - On success, responds with [`DeleteHostedZoneOutput`](crate::output::DeleteHostedZoneOutput) with field(s):
    ///   - [`change_info(Option<ChangeInfo>)`](crate::output::DeleteHostedZoneOutput::change_info): <p>A complex type that contains the ID, the status, and the date and time of a request to delete a hosted zone.</p>
    /// - On failure, responds with [`SdkError<DeleteHostedZoneError>`](crate::error::DeleteHostedZoneError)
    pub fn delete_hosted_zone(&self) -> fluent_builders::DeleteHostedZone {
        fluent_builders::DeleteHostedZone::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteKeySigningKey`](crate::client::fluent_builders::DeleteKeySigningKey) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hosted_zone_id(impl Into<String>)`](crate::client::fluent_builders::DeleteKeySigningKey::hosted_zone_id) / [`set_hosted_zone_id(Option<String>)`](crate::client::fluent_builders::DeleteKeySigningKey::set_hosted_zone_id): <p>A unique string used to identify a hosted zone.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteKeySigningKey::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteKeySigningKey::set_name): <p>A string used to identify a key-signing key (KSK).</p>
    /// - On success, responds with [`DeleteKeySigningKeyOutput`](crate::output::DeleteKeySigningKeyOutput) with field(s):
    ///   - [`change_info(Option<ChangeInfo>)`](crate::output::DeleteKeySigningKeyOutput::change_info): <p>A complex type that describes change information about changes made to your hosted zone.</p>
    /// - On failure, responds with [`SdkError<DeleteKeySigningKeyError>`](crate::error::DeleteKeySigningKeyError)
    pub fn delete_key_signing_key(&self) -> fluent_builders::DeleteKeySigningKey {
        fluent_builders::DeleteKeySigningKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteQueryLoggingConfig`](crate::client::fluent_builders::DeleteQueryLoggingConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteQueryLoggingConfig::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteQueryLoggingConfig::set_id): <p>The ID of the configuration that you want to delete. </p>
    /// - On success, responds with [`DeleteQueryLoggingConfigOutput`](crate::output::DeleteQueryLoggingConfigOutput)

    /// - On failure, responds with [`SdkError<DeleteQueryLoggingConfigError>`](crate::error::DeleteQueryLoggingConfigError)
    pub fn delete_query_logging_config(&self) -> fluent_builders::DeleteQueryLoggingConfig {
        fluent_builders::DeleteQueryLoggingConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteReusableDelegationSet`](crate::client::fluent_builders::DeleteReusableDelegationSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteReusableDelegationSet::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteReusableDelegationSet::set_id): <p>The ID of the reusable delegation set that you want to delete.</p>
    /// - On success, responds with [`DeleteReusableDelegationSetOutput`](crate::output::DeleteReusableDelegationSetOutput)

    /// - On failure, responds with [`SdkError<DeleteReusableDelegationSetError>`](crate::error::DeleteReusableDelegationSetError)
    pub fn delete_reusable_delegation_set(&self) -> fluent_builders::DeleteReusableDelegationSet {
        fluent_builders::DeleteReusableDelegationSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTrafficPolicy`](crate::client::fluent_builders::DeleteTrafficPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteTrafficPolicy::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteTrafficPolicy::set_id): <p>The ID of the traffic policy that you want to delete.</p>
    ///   - [`version(i32)`](crate::client::fluent_builders::DeleteTrafficPolicy::version) / [`set_version(Option<i32>)`](crate::client::fluent_builders::DeleteTrafficPolicy::set_version): <p>The version number of the traffic policy that you want to delete.</p>
    /// - On success, responds with [`DeleteTrafficPolicyOutput`](crate::output::DeleteTrafficPolicyOutput)

    /// - On failure, responds with [`SdkError<DeleteTrafficPolicyError>`](crate::error::DeleteTrafficPolicyError)
    pub fn delete_traffic_policy(&self) -> fluent_builders::DeleteTrafficPolicy {
        fluent_builders::DeleteTrafficPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTrafficPolicyInstance`](crate::client::fluent_builders::DeleteTrafficPolicyInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteTrafficPolicyInstance::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteTrafficPolicyInstance::set_id): <p>The ID of the traffic policy instance that you want to delete. </p> <important>   <p>When you delete a traffic policy instance, Amazon Route 53 also deletes all of the resource record sets that were created when you created the traffic policy instance.</p>  </important>
    /// - On success, responds with [`DeleteTrafficPolicyInstanceOutput`](crate::output::DeleteTrafficPolicyInstanceOutput)

    /// - On failure, responds with [`SdkError<DeleteTrafficPolicyInstanceError>`](crate::error::DeleteTrafficPolicyInstanceError)
    pub fn delete_traffic_policy_instance(&self) -> fluent_builders::DeleteTrafficPolicyInstance {
        fluent_builders::DeleteTrafficPolicyInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteVPCAssociationAuthorization`](crate::client::fluent_builders::DeleteVPCAssociationAuthorization) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hosted_zone_id(impl Into<String>)`](crate::client::fluent_builders::DeleteVPCAssociationAuthorization::hosted_zone_id) / [`set_hosted_zone_id(Option<String>)`](crate::client::fluent_builders::DeleteVPCAssociationAuthorization::set_hosted_zone_id): <p>When removing authorization to associate a VPC that was created by one Amazon Web Services account with a hosted zone that was created with a different Amazon Web Services account, the ID of the hosted zone.</p>
    ///   - [`vpc(Vpc)`](crate::client::fluent_builders::DeleteVPCAssociationAuthorization::vpc) / [`set_vpc(Option<Vpc>)`](crate::client::fluent_builders::DeleteVPCAssociationAuthorization::set_vpc): <p>When removing authorization to associate a VPC that was created by one Amazon Web Services account with a hosted zone that was created with a different Amazon Web Services account, a complex type that includes the ID and region of the VPC.</p>
    /// - On success, responds with [`DeleteVpcAssociationAuthorizationOutput`](crate::output::DeleteVpcAssociationAuthorizationOutput)

    /// - On failure, responds with [`SdkError<DeleteVPCAssociationAuthorizationError>`](crate::error::DeleteVPCAssociationAuthorizationError)
    pub fn delete_vpc_association_authorization(
        &self,
    ) -> fluent_builders::DeleteVPCAssociationAuthorization {
        fluent_builders::DeleteVPCAssociationAuthorization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisableHostedZoneDNSSEC`](crate::client::fluent_builders::DisableHostedZoneDNSSEC) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hosted_zone_id(impl Into<String>)`](crate::client::fluent_builders::DisableHostedZoneDNSSEC::hosted_zone_id) / [`set_hosted_zone_id(Option<String>)`](crate::client::fluent_builders::DisableHostedZoneDNSSEC::set_hosted_zone_id): <p>A unique string used to identify a hosted zone.</p>
    /// - On success, responds with [`DisableHostedZoneDnssecOutput`](crate::output::DisableHostedZoneDnssecOutput) with field(s):
    ///   - [`change_info(Option<ChangeInfo>)`](crate::output::DisableHostedZoneDnssecOutput::change_info): <p>A complex type that describes change information about changes made to your hosted zone.</p>
    /// - On failure, responds with [`SdkError<DisableHostedZoneDNSSECError>`](crate::error::DisableHostedZoneDNSSECError)
    pub fn disable_hosted_zone_dnssec(&self) -> fluent_builders::DisableHostedZoneDNSSEC {
        fluent_builders::DisableHostedZoneDNSSEC::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateVPCFromHostedZone`](crate::client::fluent_builders::DisassociateVPCFromHostedZone) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hosted_zone_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateVPCFromHostedZone::hosted_zone_id) / [`set_hosted_zone_id(Option<String>)`](crate::client::fluent_builders::DisassociateVPCFromHostedZone::set_hosted_zone_id): <p>The ID of the private hosted zone that you want to disassociate a VPC from.</p>
    ///   - [`vpc(Vpc)`](crate::client::fluent_builders::DisassociateVPCFromHostedZone::vpc) / [`set_vpc(Option<Vpc>)`](crate::client::fluent_builders::DisassociateVPCFromHostedZone::set_vpc): <p>A complex type that contains information about the VPC that you're disassociating from the specified hosted zone.</p>
    ///   - [`comment(impl Into<String>)`](crate::client::fluent_builders::DisassociateVPCFromHostedZone::comment) / [`set_comment(Option<String>)`](crate::client::fluent_builders::DisassociateVPCFromHostedZone::set_comment): <p> <i>Optional:</i> A comment about the disassociation request.</p>
    /// - On success, responds with [`DisassociateVpcFromHostedZoneOutput`](crate::output::DisassociateVpcFromHostedZoneOutput) with field(s):
    ///   - [`change_info(Option<ChangeInfo>)`](crate::output::DisassociateVpcFromHostedZoneOutput::change_info): <p>A complex type that describes the changes made to the specified private hosted zone.</p>
    /// - On failure, responds with [`SdkError<DisassociateVPCFromHostedZoneError>`](crate::error::DisassociateVPCFromHostedZoneError)
    pub fn disassociate_vpc_from_hosted_zone(
        &self,
    ) -> fluent_builders::DisassociateVPCFromHostedZone {
        fluent_builders::DisassociateVPCFromHostedZone::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`EnableHostedZoneDNSSEC`](crate::client::fluent_builders::EnableHostedZoneDNSSEC) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hosted_zone_id(impl Into<String>)`](crate::client::fluent_builders::EnableHostedZoneDNSSEC::hosted_zone_id) / [`set_hosted_zone_id(Option<String>)`](crate::client::fluent_builders::EnableHostedZoneDNSSEC::set_hosted_zone_id): <p>A unique string used to identify a hosted zone.</p>
    /// - On success, responds with [`EnableHostedZoneDnssecOutput`](crate::output::EnableHostedZoneDnssecOutput) with field(s):
    ///   - [`change_info(Option<ChangeInfo>)`](crate::output::EnableHostedZoneDnssecOutput::change_info): <p>A complex type that describes change information about changes made to your hosted zone.</p>
    /// - On failure, responds with [`SdkError<EnableHostedZoneDNSSECError>`](crate::error::EnableHostedZoneDNSSECError)
    pub fn enable_hosted_zone_dnssec(&self) -> fluent_builders::EnableHostedZoneDNSSEC {
        fluent_builders::EnableHostedZoneDNSSEC::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAccountLimit`](crate::client::fluent_builders::GetAccountLimit) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`r#type(AccountLimitType)`](crate::client::fluent_builders::GetAccountLimit::type) / [`set_type(Option<AccountLimitType>)`](crate::client::fluent_builders::GetAccountLimit::set_type): <p>The limit that you want to get. Valid values include the following:</p>  <ul>   <li> <p> <b>MAX_HEALTH_CHECKS_BY_OWNER</b>: The maximum number of health checks that you can create using the current account.</p> </li>   <li> <p> <b>MAX_HOSTED_ZONES_BY_OWNER</b>: The maximum number of hosted zones that you can create using the current account.</p> </li>   <li> <p> <b>MAX_REUSABLE_DELEGATION_SETS_BY_OWNER</b>: The maximum number of reusable delegation sets that you can create using the current account.</p> </li>   <li> <p> <b>MAX_TRAFFIC_POLICIES_BY_OWNER</b>: The maximum number of traffic policies that you can create using the current account.</p> </li>   <li> <p> <b>MAX_TRAFFIC_POLICY_INSTANCES_BY_OWNER</b>: The maximum number of traffic policy instances that you can create using the current account. (Traffic policy instances are referred to as traffic flow policy records in the Amazon Route 53 console.)</p> </li>  </ul>
    /// - On success, responds with [`GetAccountLimitOutput`](crate::output::GetAccountLimitOutput) with field(s):
    ///   - [`limit(Option<AccountLimit>)`](crate::output::GetAccountLimitOutput::limit): <p>The current setting for the specified limit. For example, if you specified <code>MAX_HEALTH_CHECKS_BY_OWNER</code> for the value of <code>Type</code> in the request, the value of <code>Limit</code> is the maximum number of health checks that you can create using the current account.</p>
    ///   - [`count(i64)`](crate::output::GetAccountLimitOutput::count): <p>The current number of entities that you have created of the specified type. For example, if you specified <code>MAX_HEALTH_CHECKS_BY_OWNER</code> for the value of <code>Type</code> in the request, the value of <code>Count</code> is the current number of health checks that you have created using the current account.</p>
    /// - On failure, responds with [`SdkError<GetAccountLimitError>`](crate::error::GetAccountLimitError)
    pub fn get_account_limit(&self) -> fluent_builders::GetAccountLimit {
        fluent_builders::GetAccountLimit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetChange`](crate::client::fluent_builders::GetChange) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetChange::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetChange::set_id): <p>The ID of the change batch request. The value that you specify here is the value that <code>ChangeResourceRecordSets</code> returned in the <code>Id</code> element when you submitted the request.</p>
    /// - On success, responds with [`GetChangeOutput`](crate::output::GetChangeOutput) with field(s):
    ///   - [`change_info(Option<ChangeInfo>)`](crate::output::GetChangeOutput::change_info): <p>A complex type that contains information about the specified change batch.</p>
    /// - On failure, responds with [`SdkError<GetChangeError>`](crate::error::GetChangeError)
    pub fn get_change(&self) -> fluent_builders::GetChange {
        fluent_builders::GetChange::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCheckerIpRanges`](crate::client::fluent_builders::GetCheckerIpRanges) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetCheckerIpRanges::send) it.

    /// - On success, responds with [`GetCheckerIpRangesOutput`](crate::output::GetCheckerIpRangesOutput) with field(s):
    ///   - [`checker_ip_ranges(Option<Vec<String>>)`](crate::output::GetCheckerIpRangesOutput::checker_ip_ranges): <p>A complex type that contains sorted list of IP ranges in CIDR format for Amazon Route 53 health checkers.</p>
    /// - On failure, responds with [`SdkError<GetCheckerIpRangesError>`](crate::error::GetCheckerIpRangesError)
    pub fn get_checker_ip_ranges(&self) -> fluent_builders::GetCheckerIpRanges {
        fluent_builders::GetCheckerIpRanges::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDNSSEC`](crate::client::fluent_builders::GetDNSSEC) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hosted_zone_id(impl Into<String>)`](crate::client::fluent_builders::GetDNSSEC::hosted_zone_id) / [`set_hosted_zone_id(Option<String>)`](crate::client::fluent_builders::GetDNSSEC::set_hosted_zone_id): <p>A unique string used to identify a hosted zone.</p>
    /// - On success, responds with [`GetDnssecOutput`](crate::output::GetDnssecOutput) with field(s):
    ///   - [`status(Option<DnssecStatus>)`](crate::output::GetDnssecOutput::status): <p>A string repesenting the status of DNSSEC.</p>
    ///   - [`key_signing_keys(Option<Vec<KeySigningKey>>)`](crate::output::GetDnssecOutput::key_signing_keys): <p>The key-signing keys (KSKs) in your account.</p>
    /// - On failure, responds with [`SdkError<GetDNSSECError>`](crate::error::GetDNSSECError)
    pub fn get_dnssec(&self) -> fluent_builders::GetDNSSEC {
        fluent_builders::GetDNSSEC::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetGeoLocation`](crate::client::fluent_builders::GetGeoLocation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`continent_code(impl Into<String>)`](crate::client::fluent_builders::GetGeoLocation::continent_code) / [`set_continent_code(Option<String>)`](crate::client::fluent_builders::GetGeoLocation::set_continent_code): <p>For geolocation resource record sets, a two-letter abbreviation that identifies a continent. Amazon Route 53 supports the following continent codes:</p>  <ul>   <li> <p> <b>AF</b>: Africa</p> </li>   <li> <p> <b>AN</b>: Antarctica</p> </li>   <li> <p> <b>AS</b>: Asia</p> </li>   <li> <p> <b>EU</b>: Europe</p> </li>   <li> <p> <b>OC</b>: Oceania</p> </li>   <li> <p> <b>NA</b>: North America</p> </li>   <li> <p> <b>SA</b>: South America</p> </li>  </ul>
    ///   - [`country_code(impl Into<String>)`](crate::client::fluent_builders::GetGeoLocation::country_code) / [`set_country_code(Option<String>)`](crate::client::fluent_builders::GetGeoLocation::set_country_code): <p>Amazon Route 53 uses the two-letter country codes that are specified in <a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO standard 3166-1 alpha-2</a>.</p>
    ///   - [`subdivision_code(impl Into<String>)`](crate::client::fluent_builders::GetGeoLocation::subdivision_code) / [`set_subdivision_code(Option<String>)`](crate::client::fluent_builders::GetGeoLocation::set_subdivision_code): <p>The code for the subdivision, such as a particular state within the United States. For a list of US state abbreviations, see <a href="https://pe.usps.com/text/pub28/28apb.htm">Appendix B: Two–Letter State and Possession Abbreviations</a> on the United States Postal Service website. For a list of all supported subdivision codes, use the <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListGeoLocations.html">ListGeoLocations</a> API.</p>
    /// - On success, responds with [`GetGeoLocationOutput`](crate::output::GetGeoLocationOutput) with field(s):
    ///   - [`geo_location_details(Option<GeoLocationDetails>)`](crate::output::GetGeoLocationOutput::geo_location_details): <p>A complex type that contains the codes and full continent, country, and subdivision names for the specified geolocation code.</p>
    /// - On failure, responds with [`SdkError<GetGeoLocationError>`](crate::error::GetGeoLocationError)
    pub fn get_geo_location(&self) -> fluent_builders::GetGeoLocation {
        fluent_builders::GetGeoLocation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetHealthCheck`](crate::client::fluent_builders::GetHealthCheck) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`health_check_id(impl Into<String>)`](crate::client::fluent_builders::GetHealthCheck::health_check_id) / [`set_health_check_id(Option<String>)`](crate::client::fluent_builders::GetHealthCheck::set_health_check_id): <p>The identifier that Amazon Route 53 assigned to the health check when you created it. When you add or update a resource record set, you use this value to specify which health check to use. The value can be up to 64 characters long.</p>
    /// - On success, responds with [`GetHealthCheckOutput`](crate::output::GetHealthCheckOutput) with field(s):
    ///   - [`health_check(Option<HealthCheck>)`](crate::output::GetHealthCheckOutput::health_check): <p>A complex type that contains information about one health check that is associated with the current Amazon Web Services account.</p>
    /// - On failure, responds with [`SdkError<GetHealthCheckError>`](crate::error::GetHealthCheckError)
    pub fn get_health_check(&self) -> fluent_builders::GetHealthCheck {
        fluent_builders::GetHealthCheck::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetHealthCheckCount`](crate::client::fluent_builders::GetHealthCheckCount) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetHealthCheckCount::send) it.

    /// - On success, responds with [`GetHealthCheckCountOutput`](crate::output::GetHealthCheckCountOutput) with field(s):
    ///   - [`health_check_count(Option<i64>)`](crate::output::GetHealthCheckCountOutput::health_check_count): <p>The number of health checks associated with the current Amazon Web Services account.</p>
    /// - On failure, responds with [`SdkError<GetHealthCheckCountError>`](crate::error::GetHealthCheckCountError)
    pub fn get_health_check_count(&self) -> fluent_builders::GetHealthCheckCount {
        fluent_builders::GetHealthCheckCount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetHealthCheckLastFailureReason`](crate::client::fluent_builders::GetHealthCheckLastFailureReason) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`health_check_id(impl Into<String>)`](crate::client::fluent_builders::GetHealthCheckLastFailureReason::health_check_id) / [`set_health_check_id(Option<String>)`](crate::client::fluent_builders::GetHealthCheckLastFailureReason::set_health_check_id): <p>The ID for the health check for which you want the last failure reason. When you created the health check, <code>CreateHealthCheck</code> returned the ID in the response, in the <code>HealthCheckId</code> element.</p> <note>   <p>If you want to get the last failure reason for a calculated health check, you must use the Amazon Route 53 console or the CloudWatch console. You can't use <code>GetHealthCheckLastFailureReason</code> for a calculated health check.</p>  </note>
    /// - On success, responds with [`GetHealthCheckLastFailureReasonOutput`](crate::output::GetHealthCheckLastFailureReasonOutput) with field(s):
    ///   - [`health_check_observations(Option<Vec<HealthCheckObservation>>)`](crate::output::GetHealthCheckLastFailureReasonOutput::health_check_observations): <p>A list that contains one <code>Observation</code> element for each Amazon Route 53 health checker that is reporting a last failure reason. </p>
    /// - On failure, responds with [`SdkError<GetHealthCheckLastFailureReasonError>`](crate::error::GetHealthCheckLastFailureReasonError)
    pub fn get_health_check_last_failure_reason(
        &self,
    ) -> fluent_builders::GetHealthCheckLastFailureReason {
        fluent_builders::GetHealthCheckLastFailureReason::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetHealthCheckStatus`](crate::client::fluent_builders::GetHealthCheckStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`health_check_id(impl Into<String>)`](crate::client::fluent_builders::GetHealthCheckStatus::health_check_id) / [`set_health_check_id(Option<String>)`](crate::client::fluent_builders::GetHealthCheckStatus::set_health_check_id): <p>The ID for the health check that you want the current status for. When you created the health check, <code>CreateHealthCheck</code> returned the ID in the response, in the <code>HealthCheckId</code> element.</p> <note>   <p>If you want to check the status of a calculated health check, you must use the Amazon Route 53 console or the CloudWatch console. You can't use <code>GetHealthCheckStatus</code> to get the status of a calculated health check.</p>  </note>
    /// - On success, responds with [`GetHealthCheckStatusOutput`](crate::output::GetHealthCheckStatusOutput) with field(s):
    ///   - [`health_check_observations(Option<Vec<HealthCheckObservation>>)`](crate::output::GetHealthCheckStatusOutput::health_check_observations): <p>A list that contains one <code>HealthCheckObservation</code> element for each Amazon Route 53 health checker that is reporting a status about the health check endpoint.</p>
    /// - On failure, responds with [`SdkError<GetHealthCheckStatusError>`](crate::error::GetHealthCheckStatusError)
    pub fn get_health_check_status(&self) -> fluent_builders::GetHealthCheckStatus {
        fluent_builders::GetHealthCheckStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetHostedZone`](crate::client::fluent_builders::GetHostedZone) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetHostedZone::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetHostedZone::set_id): <p>The ID of the hosted zone that you want to get information about.</p>
    /// - On success, responds with [`GetHostedZoneOutput`](crate::output::GetHostedZoneOutput) with field(s):
    ///   - [`hosted_zone(Option<HostedZone>)`](crate::output::GetHostedZoneOutput::hosted_zone): <p>A complex type that contains general information about the specified hosted zone.</p>
    ///   - [`delegation_set(Option<DelegationSet>)`](crate::output::GetHostedZoneOutput::delegation_set): <p>A complex type that lists the Amazon Route 53 name servers for the specified hosted zone.</p>
    ///   - [`vp_cs(Option<Vec<Vpc>>)`](crate::output::GetHostedZoneOutput::vp_cs): <p>A complex type that contains information about the VPCs that are associated with the specified hosted zone.</p>
    /// - On failure, responds with [`SdkError<GetHostedZoneError>`](crate::error::GetHostedZoneError)
    pub fn get_hosted_zone(&self) -> fluent_builders::GetHostedZone {
        fluent_builders::GetHostedZone::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetHostedZoneCount`](crate::client::fluent_builders::GetHostedZoneCount) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetHostedZoneCount::send) it.

    /// - On success, responds with [`GetHostedZoneCountOutput`](crate::output::GetHostedZoneCountOutput) with field(s):
    ///   - [`hosted_zone_count(Option<i64>)`](crate::output::GetHostedZoneCountOutput::hosted_zone_count): <p>The total number of public and private hosted zones that are associated with the current Amazon Web Services account.</p>
    /// - On failure, responds with [`SdkError<GetHostedZoneCountError>`](crate::error::GetHostedZoneCountError)
    pub fn get_hosted_zone_count(&self) -> fluent_builders::GetHostedZoneCount {
        fluent_builders::GetHostedZoneCount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetHostedZoneLimit`](crate::client::fluent_builders::GetHostedZoneLimit) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`r#type(HostedZoneLimitType)`](crate::client::fluent_builders::GetHostedZoneLimit::type) / [`set_type(Option<HostedZoneLimitType>)`](crate::client::fluent_builders::GetHostedZoneLimit::set_type): <p>The limit that you want to get. Valid values include the following:</p>  <ul>   <li> <p> <b>MAX_RRSETS_BY_ZONE</b>: The maximum number of records that you can create in the specified hosted zone.</p> </li>   <li> <p> <b>MAX_VPCS_ASSOCIATED_BY_ZONE</b>: The maximum number of Amazon VPCs that you can associate with the specified private hosted zone.</p> </li>  </ul>
    ///   - [`hosted_zone_id(impl Into<String>)`](crate::client::fluent_builders::GetHostedZoneLimit::hosted_zone_id) / [`set_hosted_zone_id(Option<String>)`](crate::client::fluent_builders::GetHostedZoneLimit::set_hosted_zone_id): <p>The ID of the hosted zone that you want to get a limit for.</p>
    /// - On success, responds with [`GetHostedZoneLimitOutput`](crate::output::GetHostedZoneLimitOutput) with field(s):
    ///   - [`limit(Option<HostedZoneLimit>)`](crate::output::GetHostedZoneLimitOutput::limit): <p>The current setting for the specified limit. For example, if you specified <code>MAX_RRSETS_BY_ZONE</code> for the value of <code>Type</code> in the request, the value of <code>Limit</code> is the maximum number of records that you can create in the specified hosted zone.</p>
    ///   - [`count(i64)`](crate::output::GetHostedZoneLimitOutput::count): <p>The current number of entities that you have created of the specified type. For example, if you specified <code>MAX_RRSETS_BY_ZONE</code> for the value of <code>Type</code> in the request, the value of <code>Count</code> is the current number of records that you have created in the specified hosted zone.</p>
    /// - On failure, responds with [`SdkError<GetHostedZoneLimitError>`](crate::error::GetHostedZoneLimitError)
    pub fn get_hosted_zone_limit(&self) -> fluent_builders::GetHostedZoneLimit {
        fluent_builders::GetHostedZoneLimit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetQueryLoggingConfig`](crate::client::fluent_builders::GetQueryLoggingConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetQueryLoggingConfig::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetQueryLoggingConfig::set_id): <p>The ID of the configuration for DNS query logging that you want to get information about.</p>
    /// - On success, responds with [`GetQueryLoggingConfigOutput`](crate::output::GetQueryLoggingConfigOutput) with field(s):
    ///   - [`query_logging_config(Option<QueryLoggingConfig>)`](crate::output::GetQueryLoggingConfigOutput::query_logging_config): <p>A complex type that contains information about the query logging configuration that you specified in a <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetQueryLoggingConfig.html">GetQueryLoggingConfig</a> request.</p>
    /// - On failure, responds with [`SdkError<GetQueryLoggingConfigError>`](crate::error::GetQueryLoggingConfigError)
    pub fn get_query_logging_config(&self) -> fluent_builders::GetQueryLoggingConfig {
        fluent_builders::GetQueryLoggingConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetReusableDelegationSet`](crate::client::fluent_builders::GetReusableDelegationSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetReusableDelegationSet::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetReusableDelegationSet::set_id): <p>The ID of the reusable delegation set that you want to get a list of name servers for.</p>
    /// - On success, responds with [`GetReusableDelegationSetOutput`](crate::output::GetReusableDelegationSetOutput) with field(s):
    ///   - [`delegation_set(Option<DelegationSet>)`](crate::output::GetReusableDelegationSetOutput::delegation_set): <p>A complex type that contains information about the reusable delegation set.</p>
    /// - On failure, responds with [`SdkError<GetReusableDelegationSetError>`](crate::error::GetReusableDelegationSetError)
    pub fn get_reusable_delegation_set(&self) -> fluent_builders::GetReusableDelegationSet {
        fluent_builders::GetReusableDelegationSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetReusableDelegationSetLimit`](crate::client::fluent_builders::GetReusableDelegationSetLimit) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`r#type(ReusableDelegationSetLimitType)`](crate::client::fluent_builders::GetReusableDelegationSetLimit::type) / [`set_type(Option<ReusableDelegationSetLimitType>)`](crate::client::fluent_builders::GetReusableDelegationSetLimit::set_type): <p>Specify <code>MAX_ZONES_BY_REUSABLE_DELEGATION_SET</code> to get the maximum number of hosted zones that you can associate with the specified reusable delegation set.</p>
    ///   - [`delegation_set_id(impl Into<String>)`](crate::client::fluent_builders::GetReusableDelegationSetLimit::delegation_set_id) / [`set_delegation_set_id(Option<String>)`](crate::client::fluent_builders::GetReusableDelegationSetLimit::set_delegation_set_id): <p>The ID of the delegation set that you want to get the limit for.</p>
    /// - On success, responds with [`GetReusableDelegationSetLimitOutput`](crate::output::GetReusableDelegationSetLimitOutput) with field(s):
    ///   - [`limit(Option<ReusableDelegationSetLimit>)`](crate::output::GetReusableDelegationSetLimitOutput::limit): <p>The current setting for the limit on hosted zones that you can associate with the specified reusable delegation set.</p>
    ///   - [`count(i64)`](crate::output::GetReusableDelegationSetLimitOutput::count): <p>The current number of hosted zones that you can associate with the specified reusable delegation set.</p>
    /// - On failure, responds with [`SdkError<GetReusableDelegationSetLimitError>`](crate::error::GetReusableDelegationSetLimitError)
    pub fn get_reusable_delegation_set_limit(
        &self,
    ) -> fluent_builders::GetReusableDelegationSetLimit {
        fluent_builders::GetReusableDelegationSetLimit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetTrafficPolicy`](crate::client::fluent_builders::GetTrafficPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetTrafficPolicy::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetTrafficPolicy::set_id): <p>The ID of the traffic policy that you want to get information about.</p>
    ///   - [`version(i32)`](crate::client::fluent_builders::GetTrafficPolicy::version) / [`set_version(Option<i32>)`](crate::client::fluent_builders::GetTrafficPolicy::set_version): <p>The version number of the traffic policy that you want to get information about.</p>
    /// - On success, responds with [`GetTrafficPolicyOutput`](crate::output::GetTrafficPolicyOutput) with field(s):
    ///   - [`traffic_policy(Option<TrafficPolicy>)`](crate::output::GetTrafficPolicyOutput::traffic_policy): <p>A complex type that contains settings for the specified traffic policy.</p>
    /// - On failure, responds with [`SdkError<GetTrafficPolicyError>`](crate::error::GetTrafficPolicyError)
    pub fn get_traffic_policy(&self) -> fluent_builders::GetTrafficPolicy {
        fluent_builders::GetTrafficPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetTrafficPolicyInstance`](crate::client::fluent_builders::GetTrafficPolicyInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetTrafficPolicyInstance::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetTrafficPolicyInstance::set_id): <p>The ID of the traffic policy instance that you want to get information about.</p>
    /// - On success, responds with [`GetTrafficPolicyInstanceOutput`](crate::output::GetTrafficPolicyInstanceOutput) with field(s):
    ///   - [`traffic_policy_instance(Option<TrafficPolicyInstance>)`](crate::output::GetTrafficPolicyInstanceOutput::traffic_policy_instance): <p>A complex type that contains settings for the traffic policy instance.</p>
    /// - On failure, responds with [`SdkError<GetTrafficPolicyInstanceError>`](crate::error::GetTrafficPolicyInstanceError)
    pub fn get_traffic_policy_instance(&self) -> fluent_builders::GetTrafficPolicyInstance {
        fluent_builders::GetTrafficPolicyInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetTrafficPolicyInstanceCount`](crate::client::fluent_builders::GetTrafficPolicyInstanceCount) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetTrafficPolicyInstanceCount::send) it.

    /// - On success, responds with [`GetTrafficPolicyInstanceCountOutput`](crate::output::GetTrafficPolicyInstanceCountOutput) with field(s):
    ///   - [`traffic_policy_instance_count(Option<i32>)`](crate::output::GetTrafficPolicyInstanceCountOutput::traffic_policy_instance_count): <p>The number of traffic policy instances that are associated with the current Amazon Web Services account.</p>
    /// - On failure, responds with [`SdkError<GetTrafficPolicyInstanceCountError>`](crate::error::GetTrafficPolicyInstanceCountError)
    pub fn get_traffic_policy_instance_count(
        &self,
    ) -> fluent_builders::GetTrafficPolicyInstanceCount {
        fluent_builders::GetTrafficPolicyInstanceCount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListGeoLocations`](crate::client::fluent_builders::ListGeoLocations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`start_continent_code(impl Into<String>)`](crate::client::fluent_builders::ListGeoLocations::start_continent_code) / [`set_start_continent_code(Option<String>)`](crate::client::fluent_builders::ListGeoLocations::set_start_continent_code): <p>The code for the continent with which you want to start listing locations that Amazon Route 53 supports for geolocation. If Route 53 has already returned a page or more of results, if <code>IsTruncated</code> is true, and if <code>NextContinentCode</code> from the previous response has a value, enter that value in <code>startcontinentcode</code> to return the next page of results.</p>  <p>Include <code>startcontinentcode</code> only if you want to list continents. Don't include <code>startcontinentcode</code> when you're listing countries or countries with their subdivisions.</p>
    ///   - [`start_country_code(impl Into<String>)`](crate::client::fluent_builders::ListGeoLocations::start_country_code) / [`set_start_country_code(Option<String>)`](crate::client::fluent_builders::ListGeoLocations::set_start_country_code): <p>The code for the country with which you want to start listing locations that Amazon Route 53 supports for geolocation. If Route 53 has already returned a page or more of results, if <code>IsTruncated</code> is <code>true</code>, and if <code>NextCountryCode</code> from the previous response has a value, enter that value in <code>startcountrycode</code> to return the next page of results.</p>
    ///   - [`start_subdivision_code(impl Into<String>)`](crate::client::fluent_builders::ListGeoLocations::start_subdivision_code) / [`set_start_subdivision_code(Option<String>)`](crate::client::fluent_builders::ListGeoLocations::set_start_subdivision_code): <p>The code for the state of the United States with which you want to start listing locations that Amazon Route 53 supports for geolocation. If Route 53 has already returned a page or more of results, if <code>IsTruncated</code> is <code>true</code>, and if <code>NextSubdivisionCode</code> from the previous response has a value, enter that value in <code>startsubdivisioncode</code> to return the next page of results.</p>  <p>To list subdivisions (U.S. states), you must include both <code>startcountrycode</code> and <code>startsubdivisioncode</code>.</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListGeoLocations::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListGeoLocations::set_max_items): <p>(Optional) The maximum number of geolocations to be included in the response body for this request. If more than <code>maxitems</code> geolocations remain to be listed, then the value of the <code>IsTruncated</code> element in the response is <code>true</code>.</p>
    /// - On success, responds with [`ListGeoLocationsOutput`](crate::output::ListGeoLocationsOutput) with field(s):
    ///   - [`geo_location_details_list(Option<Vec<GeoLocationDetails>>)`](crate::output::ListGeoLocationsOutput::geo_location_details_list): <p>A complex type that contains one <code>GeoLocationDetails</code> element for each location that Amazon Route 53 supports for geolocation.</p>
    ///   - [`is_truncated(bool)`](crate::output::ListGeoLocationsOutput::is_truncated): <p>A value that indicates whether more locations remain to be listed after the last location in this response. If so, the value of <code>IsTruncated</code> is <code>true</code>. To get more values, submit another request and include the values of <code>NextContinentCode</code>, <code>NextCountryCode</code>, and <code>NextSubdivisionCode</code> in the <code>startcontinentcode</code>, <code>startcountrycode</code>, and <code>startsubdivisioncode</code>, as applicable.</p>
    ///   - [`next_continent_code(Option<String>)`](crate::output::ListGeoLocationsOutput::next_continent_code): <p>If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more locations. Enter the value of <code>NextContinentCode</code> in the <code>startcontinentcode</code> parameter in another <code>ListGeoLocations</code> request.</p>
    ///   - [`next_country_code(Option<String>)`](crate::output::ListGeoLocationsOutput::next_country_code): <p>If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more locations. Enter the value of <code>NextCountryCode</code> in the <code>startcountrycode</code> parameter in another <code>ListGeoLocations</code> request.</p>
    ///   - [`next_subdivision_code(Option<String>)`](crate::output::ListGeoLocationsOutput::next_subdivision_code): <p>If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more locations. Enter the value of <code>NextSubdivisionCode</code> in the <code>startsubdivisioncode</code> parameter in another <code>ListGeoLocations</code> request.</p>
    ///   - [`max_items(Option<i32>)`](crate::output::ListGeoLocationsOutput::max_items): <p>The value that you specified for <code>MaxItems</code> in the request.</p>
    /// - On failure, responds with [`SdkError<ListGeoLocationsError>`](crate::error::ListGeoLocationsError)
    pub fn list_geo_locations(&self) -> fluent_builders::ListGeoLocations {
        fluent_builders::ListGeoLocations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListHealthChecks`](crate::client::fluent_builders::ListHealthChecks) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListHealthChecks::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListHealthChecks::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListHealthChecks::set_marker): <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more health checks. To get another group, submit another <code>ListHealthChecks</code> request. </p>  <p>For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous response, which is the ID of the first health check that Amazon Route 53 will return if you submit another request.</p>  <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more health checks to get.</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListHealthChecks::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListHealthChecks::set_max_items): <p>The maximum number of health checks that you want <code>ListHealthChecks</code> to return in response to the current request. Amazon Route 53 returns a maximum of 100 items. If you set <code>MaxItems</code> to a value greater than 100, Route 53 returns only the first 100 health checks. </p>
    /// - On success, responds with [`ListHealthChecksOutput`](crate::output::ListHealthChecksOutput) with field(s):
    ///   - [`health_checks(Option<Vec<HealthCheck>>)`](crate::output::ListHealthChecksOutput::health_checks): <p>A complex type that contains one <code>HealthCheck</code> element for each health check that is associated with the current Amazon Web Services account.</p>
    ///   - [`marker(Option<String>)`](crate::output::ListHealthChecksOutput::marker): <p>For the second and subsequent calls to <code>ListHealthChecks</code>, <code>Marker</code> is the value that you specified for the <code>marker</code> parameter in the previous request.</p>
    ///   - [`is_truncated(bool)`](crate::output::ListHealthChecksOutput::is_truncated): <p>A flag that indicates whether there are more health checks to be listed. If the response was truncated, you can get the next group of health checks by submitting another <code>ListHealthChecks</code> request and specifying the value of <code>NextMarker</code> in the <code>marker</code> parameter.</p>
    ///   - [`next_marker(Option<String>)`](crate::output::ListHealthChecksOutput::next_marker): <p>If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextMarker</code> identifies the first health check that Amazon Route 53 returns if you submit another <code>ListHealthChecks</code> request and specify the value of <code>NextMarker</code> in the <code>marker</code> parameter.</p>
    ///   - [`max_items(Option<i32>)`](crate::output::ListHealthChecksOutput::max_items): <p>The value that you specified for the <code>maxitems</code> parameter in the call to <code>ListHealthChecks</code> that produced the current response.</p>
    /// - On failure, responds with [`SdkError<ListHealthChecksError>`](crate::error::ListHealthChecksError)
    pub fn list_health_checks(&self) -> fluent_builders::ListHealthChecks {
        fluent_builders::ListHealthChecks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListHostedZones`](crate::client::fluent_builders::ListHostedZones) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListHostedZones::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListHostedZones::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListHostedZones::set_marker): <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more hosted zones. To get more hosted zones, submit another <code>ListHostedZones</code> request. </p>  <p>For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous response, which is the ID of the first hosted zone that Amazon Route 53 will return if you submit another request.</p>  <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more hosted zones to get.</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListHostedZones::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListHostedZones::set_max_items): <p>(Optional) The maximum number of hosted zones that you want Amazon Route 53 to return. If you have more than <code>maxitems</code> hosted zones, the value of <code>IsTruncated</code> in the response is <code>true</code>, and the value of <code>NextMarker</code> is the hosted zone ID of the first hosted zone that Route 53 will return if you submit another request.</p>
    ///   - [`delegation_set_id(impl Into<String>)`](crate::client::fluent_builders::ListHostedZones::delegation_set_id) / [`set_delegation_set_id(Option<String>)`](crate::client::fluent_builders::ListHostedZones::set_delegation_set_id): <p>If you're using reusable delegation sets and you want to list all of the hosted zones that are associated with a reusable delegation set, specify the ID of that reusable delegation set. </p>
    /// - On success, responds with [`ListHostedZonesOutput`](crate::output::ListHostedZonesOutput) with field(s):
    ///   - [`hosted_zones(Option<Vec<HostedZone>>)`](crate::output::ListHostedZonesOutput::hosted_zones): <p>A complex type that contains general information about the hosted zone.</p>
    ///   - [`marker(Option<String>)`](crate::output::ListHostedZonesOutput::marker): <p>For the second and subsequent calls to <code>ListHostedZones</code>, <code>Marker</code> is the value that you specified for the <code>marker</code> parameter in the request that produced the current response.</p>
    ///   - [`is_truncated(bool)`](crate::output::ListHostedZonesOutput::is_truncated): <p>A flag indicating whether there are more hosted zones to be listed. If the response was truncated, you can get more hosted zones by submitting another <code>ListHostedZones</code> request and specifying the value of <code>NextMarker</code> in the <code>marker</code> parameter.</p>
    ///   - [`next_marker(Option<String>)`](crate::output::ListHostedZonesOutput::next_marker): <p>If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextMarker</code> identifies the first hosted zone in the next group of hosted zones. Submit another <code>ListHostedZones</code> request, and specify the value of <code>NextMarker</code> from the response in the <code>marker</code> parameter.</p>  <p>This element is present only if <code>IsTruncated</code> is <code>true</code>.</p>
    ///   - [`max_items(Option<i32>)`](crate::output::ListHostedZonesOutput::max_items): <p>The value that you specified for the <code>maxitems</code> parameter in the call to <code>ListHostedZones</code> that produced the current response.</p>
    /// - On failure, responds with [`SdkError<ListHostedZonesError>`](crate::error::ListHostedZonesError)
    pub fn list_hosted_zones(&self) -> fluent_builders::ListHostedZones {
        fluent_builders::ListHostedZones::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListHostedZonesByName`](crate::client::fluent_builders::ListHostedZonesByName) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dns_name(impl Into<String>)`](crate::client::fluent_builders::ListHostedZonesByName::dns_name) / [`set_dns_name(Option<String>)`](crate::client::fluent_builders::ListHostedZonesByName::set_dns_name): <p>(Optional) For your first request to <code>ListHostedZonesByName</code>, include the <code>dnsname</code> parameter only if you want to specify the name of the first hosted zone in the response. If you don't include the <code>dnsname</code> parameter, Amazon Route 53 returns all of the hosted zones that were created by the current Amazon Web Services account, in ASCII order. For subsequent requests, include both <code>dnsname</code> and <code>hostedzoneid</code> parameters. For <code>dnsname</code>, specify the value of <code>NextDNSName</code> from the previous response.</p>
    ///   - [`hosted_zone_id(impl Into<String>)`](crate::client::fluent_builders::ListHostedZonesByName::hosted_zone_id) / [`set_hosted_zone_id(Option<String>)`](crate::client::fluent_builders::ListHostedZonesByName::set_hosted_zone_id): <p>(Optional) For your first request to <code>ListHostedZonesByName</code>, do not include the <code>hostedzoneid</code> parameter.</p>  <p>If you have more hosted zones than the value of <code>maxitems</code>, <code>ListHostedZonesByName</code> returns only the first <code>maxitems</code> hosted zones. To get the next group of <code>maxitems</code> hosted zones, submit another request to <code>ListHostedZonesByName</code> and include both <code>dnsname</code> and <code>hostedzoneid</code> parameters. For the value of <code>hostedzoneid</code>, specify the value of the <code>NextHostedZoneId</code> element from the previous response.</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListHostedZonesByName::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListHostedZonesByName::set_max_items): <p>The maximum number of hosted zones to be included in the response body for this request. If you have more than <code>maxitems</code> hosted zones, then the value of the <code>IsTruncated</code> element in the response is true, and the values of <code>NextDNSName</code> and <code>NextHostedZoneId</code> specify the first hosted zone in the next group of <code>maxitems</code> hosted zones. </p>
    /// - On success, responds with [`ListHostedZonesByNameOutput`](crate::output::ListHostedZonesByNameOutput) with field(s):
    ///   - [`hosted_zones(Option<Vec<HostedZone>>)`](crate::output::ListHostedZonesByNameOutput::hosted_zones): <p>A complex type that contains general information about the hosted zone.</p>
    ///   - [`dns_name(Option<String>)`](crate::output::ListHostedZonesByNameOutput::dns_name): <p>For the second and subsequent calls to <code>ListHostedZonesByName</code>, <code>DNSName</code> is the value that you specified for the <code>dnsname</code> parameter in the request that produced the current response.</p>
    ///   - [`hosted_zone_id(Option<String>)`](crate::output::ListHostedZonesByNameOutput::hosted_zone_id): <p>The ID that Amazon Route 53 assigned to the hosted zone when you created it.</p>
    ///   - [`is_truncated(bool)`](crate::output::ListHostedZonesByNameOutput::is_truncated): <p>A flag that indicates whether there are more hosted zones to be listed. If the response was truncated, you can get the next group of <code>maxitems</code> hosted zones by calling <code>ListHostedZonesByName</code> again and specifying the values of <code>NextDNSName</code> and <code>NextHostedZoneId</code> elements in the <code>dnsname</code> and <code>hostedzoneid</code> parameters.</p>
    ///   - [`next_dns_name(Option<String>)`](crate::output::ListHostedZonesByNameOutput::next_dns_name): <p>If <code>IsTruncated</code> is true, the value of <code>NextDNSName</code> is the name of the first hosted zone in the next group of <code>maxitems</code> hosted zones. Call <code>ListHostedZonesByName</code> again and specify the value of <code>NextDNSName</code> and <code>NextHostedZoneId</code> in the <code>dnsname</code> and <code>hostedzoneid</code> parameters, respectively.</p>  <p>This element is present only if <code>IsTruncated</code> is <code>true</code>.</p>
    ///   - [`next_hosted_zone_id(Option<String>)`](crate::output::ListHostedZonesByNameOutput::next_hosted_zone_id): <p>If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextHostedZoneId</code> identifies the first hosted zone in the next group of <code>maxitems</code> hosted zones. Call <code>ListHostedZonesByName</code> again and specify the value of <code>NextDNSName</code> and <code>NextHostedZoneId</code> in the <code>dnsname</code> and <code>hostedzoneid</code> parameters, respectively.</p>  <p>This element is present only if <code>IsTruncated</code> is <code>true</code>.</p>
    ///   - [`max_items(Option<i32>)`](crate::output::ListHostedZonesByNameOutput::max_items): <p>The value that you specified for the <code>maxitems</code> parameter in the call to <code>ListHostedZonesByName</code> that produced the current response.</p>
    /// - On failure, responds with [`SdkError<ListHostedZonesByNameError>`](crate::error::ListHostedZonesByNameError)
    pub fn list_hosted_zones_by_name(&self) -> fluent_builders::ListHostedZonesByName {
        fluent_builders::ListHostedZonesByName::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListHostedZonesByVPC`](crate::client::fluent_builders::ListHostedZonesByVPC) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`vpc_id(impl Into<String>)`](crate::client::fluent_builders::ListHostedZonesByVPC::vpc_id) / [`set_vpc_id(Option<String>)`](crate::client::fluent_builders::ListHostedZonesByVPC::set_vpc_id): <p>The ID of the Amazon VPC that you want to list hosted zones for.</p>
    ///   - [`vpc_region(VpcRegion)`](crate::client::fluent_builders::ListHostedZonesByVPC::vpc_region) / [`set_vpc_region(Option<VpcRegion>)`](crate::client::fluent_builders::ListHostedZonesByVPC::set_vpc_region): <p>For the Amazon VPC that you specified for <code>VPCId</code>, the Amazon Web Services Region that you created the VPC in. </p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListHostedZonesByVPC::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListHostedZonesByVPC::set_max_items): <p>(Optional) The maximum number of hosted zones that you want Amazon Route 53 to return. If the specified VPC is associated with more than <code>MaxItems</code> hosted zones, the response includes a <code>NextToken</code> element. <code>NextToken</code> contains an encrypted token that identifies the first hosted zone that Route 53 will return if you submit another request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListHostedZonesByVPC::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListHostedZonesByVPC::set_next_token): <p>If the previous response included a <code>NextToken</code> element, the specified VPC is associated with more hosted zones. To get more hosted zones, submit another <code>ListHostedZonesByVPC</code> request. </p>  <p>For the value of <code>NextToken</code>, specify the value of <code>NextToken</code> from the previous response.</p>  <p>If the previous response didn't include a <code>NextToken</code> element, there are no more hosted zones to get.</p>
    /// - On success, responds with [`ListHostedZonesByVpcOutput`](crate::output::ListHostedZonesByVpcOutput) with field(s):
    ///   - [`hosted_zone_summaries(Option<Vec<HostedZoneSummary>>)`](crate::output::ListHostedZonesByVpcOutput::hosted_zone_summaries): <p>A list that contains one <code>HostedZoneSummary</code> element for each hosted zone that the specified Amazon VPC is associated with. Each <code>HostedZoneSummary</code> element contains the hosted zone name and ID, and information about who owns the hosted zone.</p>
    ///   - [`max_items(Option<i32>)`](crate::output::ListHostedZonesByVpcOutput::max_items): <p>The value that you specified for <code>MaxItems</code> in the most recent <code>ListHostedZonesByVPC</code> request.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListHostedZonesByVpcOutput::next_token): <p>The value that you will use for <code>NextToken</code> in the next <code>ListHostedZonesByVPC</code> request.</p>
    /// - On failure, responds with [`SdkError<ListHostedZonesByVPCError>`](crate::error::ListHostedZonesByVPCError)
    pub fn list_hosted_zones_by_vpc(&self) -> fluent_builders::ListHostedZonesByVPC {
        fluent_builders::ListHostedZonesByVPC::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListQueryLoggingConfigs`](crate::client::fluent_builders::ListQueryLoggingConfigs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListQueryLoggingConfigs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`hosted_zone_id(impl Into<String>)`](crate::client::fluent_builders::ListQueryLoggingConfigs::hosted_zone_id) / [`set_hosted_zone_id(Option<String>)`](crate::client::fluent_builders::ListQueryLoggingConfigs::set_hosted_zone_id): <p>(Optional) If you want to list the query logging configuration that is associated with a hosted zone, specify the ID in <code>HostedZoneId</code>. </p>  <p>If you don't specify a hosted zone ID, <code>ListQueryLoggingConfigs</code> returns all of the configurations that are associated with the current Amazon Web Services account.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListQueryLoggingConfigs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListQueryLoggingConfigs::set_next_token): <p>(Optional) If the current Amazon Web Services account has more than <code>MaxResults</code> query logging configurations, use <code>NextToken</code> to get the second and subsequent pages of results.</p>  <p>For the first <code>ListQueryLoggingConfigs</code> request, omit this value.</p>  <p>For the second and subsequent requests, get the value of <code>NextToken</code> from the previous response and specify that value for <code>NextToken</code> in the request.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListQueryLoggingConfigs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListQueryLoggingConfigs::set_max_results): <p>(Optional) The maximum number of query logging configurations that you want Amazon Route 53 to return in response to the current request. If the current Amazon Web Services account has more than <code>MaxResults</code> configurations, use the value of <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListQueryLoggingConfigs.html#API_ListQueryLoggingConfigs_RequestSyntax">NextToken</a> in the response to get the next page of results.</p>  <p>If you don't specify a value for <code>MaxResults</code>, Route 53 returns up to 100 configurations.</p>
    /// - On success, responds with [`ListQueryLoggingConfigsOutput`](crate::output::ListQueryLoggingConfigsOutput) with field(s):
    ///   - [`query_logging_configs(Option<Vec<QueryLoggingConfig>>)`](crate::output::ListQueryLoggingConfigsOutput::query_logging_configs): <p>An array that contains one <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_QueryLoggingConfig.html">QueryLoggingConfig</a> element for each configuration for DNS query logging that is associated with the current Amazon Web Services account.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListQueryLoggingConfigsOutput::next_token): <p>If a response includes the last of the query logging configurations that are associated with the current Amazon Web Services account, <code>NextToken</code> doesn't appear in the response.</p>  <p>If a response doesn't include the last of the configurations, you can get more configurations by submitting another <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListQueryLoggingConfigs.html">ListQueryLoggingConfigs</a> request. Get the value of <code>NextToken</code> that Amazon Route 53 returned in the previous response and include it in <code>NextToken</code> in the next request.</p>
    /// - On failure, responds with [`SdkError<ListQueryLoggingConfigsError>`](crate::error::ListQueryLoggingConfigsError)
    pub fn list_query_logging_configs(&self) -> fluent_builders::ListQueryLoggingConfigs {
        fluent_builders::ListQueryLoggingConfigs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListResourceRecordSets`](crate::client::fluent_builders::ListResourceRecordSets) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hosted_zone_id(impl Into<String>)`](crate::client::fluent_builders::ListResourceRecordSets::hosted_zone_id) / [`set_hosted_zone_id(Option<String>)`](crate::client::fluent_builders::ListResourceRecordSets::set_hosted_zone_id): <p>The ID of the hosted zone that contains the resource record sets that you want to list.</p>
    ///   - [`start_record_name(impl Into<String>)`](crate::client::fluent_builders::ListResourceRecordSets::start_record_name) / [`set_start_record_name(Option<String>)`](crate::client::fluent_builders::ListResourceRecordSets::set_start_record_name): <p>The first name in the lexicographic ordering of resource record sets that you want to list. If the specified record name doesn't exist, the results begin with the first resource record set that has a name greater than the value of <code>name</code>.</p>
    ///   - [`start_record_type(RrType)`](crate::client::fluent_builders::ListResourceRecordSets::start_record_type) / [`set_start_record_type(Option<RrType>)`](crate::client::fluent_builders::ListResourceRecordSets::set_start_record_type): <p>The type of resource record set to begin the record listing from.</p>  <p>Valid values for basic resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> | <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> | <code>NS</code> | <code>PTR</code> | <code>SOA</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code> </p>  <p>Values for weighted, latency, geolocation, and failover resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> | <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> | <code>PTR</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code> </p>  <p>Values for alias resource record sets: </p>  <ul>   <li> <p> <b>API Gateway custom regional API or edge-optimized API</b>: A</p> </li>   <li> <p> <b>CloudFront distribution</b>: A or AAAA</p> </li>   <li> <p> <b>Elastic Beanstalk environment that has a regionalized subdomain</b>: A</p> </li>   <li> <p> <b>Elastic Load Balancing load balancer</b>: A | AAAA</p> </li>   <li> <p> <b>S3 bucket</b>: A</p> </li>   <li> <p> <b>VPC interface VPC endpoint</b>: A</p> </li>   <li> <p> <b>Another resource record set in this hosted zone:</b> The type of the resource record set that the alias references.</p> </li>  </ul>  <p>Constraint: Specifying <code>type</code> without specifying <code>name</code> returns an <code>InvalidInput</code> error.</p>
    ///   - [`start_record_identifier(impl Into<String>)`](crate::client::fluent_builders::ListResourceRecordSets::start_record_identifier) / [`set_start_record_identifier(Option<String>)`](crate::client::fluent_builders::ListResourceRecordSets::set_start_record_identifier): <p> <i>Resource record sets that have a routing policy other than simple:</i> If results were truncated for a given DNS name and type, specify the value of <code>NextRecordIdentifier</code> from the previous response to get the next resource record set that has the current DNS name and type.</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListResourceRecordSets::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListResourceRecordSets::set_max_items): <p>(Optional) The maximum number of resource records sets to include in the response body for this request. If the response includes more than <code>maxitems</code> resource record sets, the value of the <code>IsTruncated</code> element in the response is <code>true</code>, and the values of the <code>NextRecordName</code> and <code>NextRecordType</code> elements in the response identify the first resource record set in the next group of <code>maxitems</code> resource record sets.</p>
    /// - On success, responds with [`ListResourceRecordSetsOutput`](crate::output::ListResourceRecordSetsOutput) with field(s):
    ///   - [`resource_record_sets(Option<Vec<ResourceRecordSet>>)`](crate::output::ListResourceRecordSetsOutput::resource_record_sets): <p>Information about multiple resource record sets.</p>
    ///   - [`is_truncated(bool)`](crate::output::ListResourceRecordSetsOutput::is_truncated): <p>A flag that indicates whether more resource record sets remain to be listed. If your results were truncated, you can make a follow-up pagination request by using the <code>NextRecordName</code> element.</p>
    ///   - [`next_record_name(Option<String>)`](crate::output::ListResourceRecordSetsOutput::next_record_name): <p>If the results were truncated, the name of the next record in the list.</p>  <p>This element is present only if <code>IsTruncated</code> is true. </p>
    ///   - [`next_record_type(Option<RrType>)`](crate::output::ListResourceRecordSetsOutput::next_record_type): <p>If the results were truncated, the type of the next record in the list.</p>  <p>This element is present only if <code>IsTruncated</code> is true. </p>
    ///   - [`next_record_identifier(Option<String>)`](crate::output::ListResourceRecordSetsOutput::next_record_identifier): <p> <i>Resource record sets that have a routing policy other than simple:</i> If results were truncated for a given DNS name and type, the value of <code>SetIdentifier</code> for the next resource record set that has the current DNS name and type.</p>  <p>For information about routing policies, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html">Choosing a Routing Policy</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
    ///   - [`max_items(Option<i32>)`](crate::output::ListResourceRecordSetsOutput::max_items): <p>The maximum number of records you requested.</p>
    /// - On failure, responds with [`SdkError<ListResourceRecordSetsError>`](crate::error::ListResourceRecordSetsError)
    pub fn list_resource_record_sets(&self) -> fluent_builders::ListResourceRecordSets {
        fluent_builders::ListResourceRecordSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListReusableDelegationSets`](crate::client::fluent_builders::ListReusableDelegationSets) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListReusableDelegationSets::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListReusableDelegationSets::set_marker): <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more reusable delegation sets. To get another group, submit another <code>ListReusableDelegationSets</code> request. </p>  <p>For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous response, which is the ID of the first reusable delegation set that Amazon Route 53 will return if you submit another request.</p>  <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more reusable delegation sets to get.</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListReusableDelegationSets::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListReusableDelegationSets::set_max_items): <p>The number of reusable delegation sets that you want Amazon Route 53 to return in the response to this request. If you specify a value greater than 100, Route 53 returns only the first 100 reusable delegation sets.</p>
    /// - On success, responds with [`ListReusableDelegationSetsOutput`](crate::output::ListReusableDelegationSetsOutput) with field(s):
    ///   - [`delegation_sets(Option<Vec<DelegationSet>>)`](crate::output::ListReusableDelegationSetsOutput::delegation_sets): <p>A complex type that contains one <code>DelegationSet</code> element for each reusable delegation set that was created by the current Amazon Web Services account.</p>
    ///   - [`marker(Option<String>)`](crate::output::ListReusableDelegationSetsOutput::marker): <p>For the second and subsequent calls to <code>ListReusableDelegationSets</code>, <code>Marker</code> is the value that you specified for the <code>marker</code> parameter in the request that produced the current response.</p>
    ///   - [`is_truncated(bool)`](crate::output::ListReusableDelegationSetsOutput::is_truncated): <p>A flag that indicates whether there are more reusable delegation sets to be listed.</p>
    ///   - [`next_marker(Option<String>)`](crate::output::ListReusableDelegationSetsOutput::next_marker): <p>If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextMarker</code> identifies the next reusable delegation set that Amazon Route 53 will return if you submit another <code>ListReusableDelegationSets</code> request and specify the value of <code>NextMarker</code> in the <code>marker</code> parameter.</p>
    ///   - [`max_items(Option<i32>)`](crate::output::ListReusableDelegationSetsOutput::max_items): <p>The value that you specified for the <code>maxitems</code> parameter in the call to <code>ListReusableDelegationSets</code> that produced the current response.</p>
    /// - On failure, responds with [`SdkError<ListReusableDelegationSetsError>`](crate::error::ListReusableDelegationSetsError)
    pub fn list_reusable_delegation_sets(&self) -> fluent_builders::ListReusableDelegationSets {
        fluent_builders::ListReusableDelegationSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_type(TagResourceType)`](crate::client::fluent_builders::ListTagsForResource::resource_type) / [`set_resource_type(Option<TagResourceType>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_type): <p>The type of the resource.</p>  <ul>   <li> <p>The resource type for health checks is <code>healthcheck</code>.</p> </li>   <li> <p>The resource type for hosted zones is <code>hostedzone</code>.</p> </li>  </ul>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_id): <p>The ID of the resource for which you want to retrieve tags.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`resource_tag_set(Option<ResourceTagSet>)`](crate::output::ListTagsForResourceOutput::resource_tag_set): <p>A <code>ResourceTagSet</code> containing tags associated with the specified resource.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResources`](crate::client::fluent_builders::ListTagsForResources) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_type(TagResourceType)`](crate::client::fluent_builders::ListTagsForResources::resource_type) / [`set_resource_type(Option<TagResourceType>)`](crate::client::fluent_builders::ListTagsForResources::set_resource_type): <p>The type of the resources.</p>  <ul>   <li> <p>The resource type for health checks is <code>healthcheck</code>.</p> </li>   <li> <p>The resource type for hosted zones is <code>hostedzone</code>.</p> </li>  </ul>
    ///   - [`resource_ids(Vec<String>)`](crate::client::fluent_builders::ListTagsForResources::resource_ids) / [`set_resource_ids(Option<Vec<String>>)`](crate::client::fluent_builders::ListTagsForResources::set_resource_ids): <p>A complex type that contains the ResourceId element for each resource for which you want to get a list of tags.</p>
    /// - On success, responds with [`ListTagsForResourcesOutput`](crate::output::ListTagsForResourcesOutput) with field(s):
    ///   - [`resource_tag_sets(Option<Vec<ResourceTagSet>>)`](crate::output::ListTagsForResourcesOutput::resource_tag_sets): <p>A list of <code>ResourceTagSet</code>s containing tags associated with the specified resources.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourcesError>`](crate::error::ListTagsForResourcesError)
    pub fn list_tags_for_resources(&self) -> fluent_builders::ListTagsForResources {
        fluent_builders::ListTagsForResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTrafficPolicies`](crate::client::fluent_builders::ListTrafficPolicies) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`traffic_policy_id_marker(impl Into<String>)`](crate::client::fluent_builders::ListTrafficPolicies::traffic_policy_id_marker) / [`set_traffic_policy_id_marker(Option<String>)`](crate::client::fluent_builders::ListTrafficPolicies::set_traffic_policy_id_marker): <p>(Conditional) For your first request to <code>ListTrafficPolicies</code>, don't include the <code>TrafficPolicyIdMarker</code> parameter.</p>  <p>If you have more traffic policies than the value of <code>MaxItems</code>, <code>ListTrafficPolicies</code> returns only the first <code>MaxItems</code> traffic policies. To get the next group of policies, submit another request to <code>ListTrafficPolicies</code>. For the value of <code>TrafficPolicyIdMarker</code>, specify the value of <code>TrafficPolicyIdMarker</code> that was returned in the previous response.</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListTrafficPolicies::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListTrafficPolicies::set_max_items): <p>(Optional) The maximum number of traffic policies that you want Amazon Route 53 to return in response to this request. If you have more than <code>MaxItems</code> traffic policies, the value of <code>IsTruncated</code> in the response is <code>true</code>, and the value of <code>TrafficPolicyIdMarker</code> is the ID of the first traffic policy that Route 53 will return if you submit another request.</p>
    /// - On success, responds with [`ListTrafficPoliciesOutput`](crate::output::ListTrafficPoliciesOutput) with field(s):
    ///   - [`traffic_policy_summaries(Option<Vec<TrafficPolicySummary>>)`](crate::output::ListTrafficPoliciesOutput::traffic_policy_summaries): <p>A list that contains one <code>TrafficPolicySummary</code> element for each traffic policy that was created by the current Amazon Web Services account.</p>
    ///   - [`is_truncated(bool)`](crate::output::ListTrafficPoliciesOutput::is_truncated): <p>A flag that indicates whether there are more traffic policies to be listed. If the response was truncated, you can get the next group of traffic policies by submitting another <code>ListTrafficPolicies</code> request and specifying the value of <code>TrafficPolicyIdMarker</code> in the <code>TrafficPolicyIdMarker</code> request parameter.</p>
    ///   - [`traffic_policy_id_marker(Option<String>)`](crate::output::ListTrafficPoliciesOutput::traffic_policy_id_marker): <p>If the value of <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyIdMarker</code> is the ID of the first traffic policy in the next group of <code>MaxItems</code> traffic policies.</p>
    ///   - [`max_items(Option<i32>)`](crate::output::ListTrafficPoliciesOutput::max_items): <p>The value that you specified for the <code>MaxItems</code> parameter in the <code>ListTrafficPolicies</code> request that produced the current response.</p>
    /// - On failure, responds with [`SdkError<ListTrafficPoliciesError>`](crate::error::ListTrafficPoliciesError)
    pub fn list_traffic_policies(&self) -> fluent_builders::ListTrafficPolicies {
        fluent_builders::ListTrafficPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTrafficPolicyInstances`](crate::client::fluent_builders::ListTrafficPolicyInstances) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hosted_zone_id_marker(impl Into<String>)`](crate::client::fluent_builders::ListTrafficPolicyInstances::hosted_zone_id_marker) / [`set_hosted_zone_id_marker(Option<String>)`](crate::client::fluent_builders::ListTrafficPolicyInstances::set_hosted_zone_id_marker): <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>HostedZoneId</code>, specify the value of <code>HostedZoneIdMarker</code> from the previous response, which is the hosted zone ID of the first traffic policy instance in the next group of traffic policy instances.</p>  <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
    ///   - [`traffic_policy_instance_name_marker(impl Into<String>)`](crate::client::fluent_builders::ListTrafficPolicyInstances::traffic_policy_instance_name_marker) / [`set_traffic_policy_instance_name_marker(Option<String>)`](crate::client::fluent_builders::ListTrafficPolicyInstances::set_traffic_policy_instance_name_marker): <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancename</code>, specify the value of <code>TrafficPolicyInstanceNameMarker</code> from the previous response, which is the name of the first traffic policy instance in the next group of traffic policy instances.</p>  <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
    ///   - [`traffic_policy_instance_type_marker(RrType)`](crate::client::fluent_builders::ListTrafficPolicyInstances::traffic_policy_instance_type_marker) / [`set_traffic_policy_instance_type_marker(Option<RrType>)`](crate::client::fluent_builders::ListTrafficPolicyInstances::set_traffic_policy_instance_type_marker): <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancetype</code>, specify the value of <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the type of the first traffic policy instance in the next group of traffic policy instances.</p>  <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListTrafficPolicyInstances::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListTrafficPolicyInstances::set_max_items): <p>The maximum number of traffic policy instances that you want Amazon Route 53 to return in response to a <code>ListTrafficPolicyInstances</code> request. If you have more than <code>MaxItems</code> traffic policy instances, the value of the <code>IsTruncated</code> element in the response is <code>true</code>, and the values of <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code> represent the first traffic policy instance in the next group of <code>MaxItems</code> traffic policy instances.</p>
    /// - On success, responds with [`ListTrafficPolicyInstancesOutput`](crate::output::ListTrafficPolicyInstancesOutput) with field(s):
    ///   - [`traffic_policy_instances(Option<Vec<TrafficPolicyInstance>>)`](crate::output::ListTrafficPolicyInstancesOutput::traffic_policy_instances): <p>A list that contains one <code>TrafficPolicyInstance</code> element for each traffic policy instance that matches the elements in the request.</p>
    ///   - [`hosted_zone_id_marker(Option<String>)`](crate::output::ListTrafficPolicyInstancesOutput::hosted_zone_id_marker): <p>If <code>IsTruncated</code> is <code>true</code>, <code>HostedZoneIdMarker</code> is the ID of the hosted zone of the first traffic policy instance that Route 53 will return if you submit another <code>ListTrafficPolicyInstances</code> request. </p>
    ///   - [`traffic_policy_instance_name_marker(Option<String>)`](crate::output::ListTrafficPolicyInstancesOutput::traffic_policy_instance_name_marker): <p>If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceNameMarker</code> is the name of the first traffic policy instance that Route 53 will return if you submit another <code>ListTrafficPolicyInstances</code> request. </p>
    ///   - [`traffic_policy_instance_type_marker(Option<RrType>)`](crate::output::ListTrafficPolicyInstancesOutput::traffic_policy_instance_type_marker): <p>If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceTypeMarker</code> is the DNS type of the resource record sets that are associated with the first traffic policy instance that Amazon Route 53 will return if you submit another <code>ListTrafficPolicyInstances</code> request. </p>
    ///   - [`is_truncated(bool)`](crate::output::ListTrafficPolicyInstancesOutput::is_truncated): <p>A flag that indicates whether there are more traffic policy instances to be listed. If the response was truncated, you can get more traffic policy instances by calling <code>ListTrafficPolicyInstances</code> again and specifying the values of the <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code> in the corresponding request parameters.</p>
    ///   - [`max_items(Option<i32>)`](crate::output::ListTrafficPolicyInstancesOutput::max_items): <p>The value that you specified for the <code>MaxItems</code> parameter in the call to <code>ListTrafficPolicyInstances</code> that produced the current response.</p>
    /// - On failure, responds with [`SdkError<ListTrafficPolicyInstancesError>`](crate::error::ListTrafficPolicyInstancesError)
    pub fn list_traffic_policy_instances(&self) -> fluent_builders::ListTrafficPolicyInstances {
        fluent_builders::ListTrafficPolicyInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTrafficPolicyInstancesByHostedZone`](crate::client::fluent_builders::ListTrafficPolicyInstancesByHostedZone) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hosted_zone_id(impl Into<String>)`](crate::client::fluent_builders::ListTrafficPolicyInstancesByHostedZone::hosted_zone_id) / [`set_hosted_zone_id(Option<String>)`](crate::client::fluent_builders::ListTrafficPolicyInstancesByHostedZone::set_hosted_zone_id): <p>The ID of the hosted zone that you want to list traffic policy instances for.</p>
    ///   - [`traffic_policy_instance_name_marker(impl Into<String>)`](crate::client::fluent_builders::ListTrafficPolicyInstancesByHostedZone::traffic_policy_instance_name_marker) / [`set_traffic_policy_instance_name_marker(Option<String>)`](crate::client::fluent_builders::ListTrafficPolicyInstancesByHostedZone::set_traffic_policy_instance_name_marker): <p>If the value of <code>IsTruncated</code> in the previous response is true, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancename</code>, specify the value of <code>TrafficPolicyInstanceNameMarker</code> from the previous response, which is the name of the first traffic policy instance in the next group of traffic policy instances.</p>  <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
    ///   - [`traffic_policy_instance_type_marker(RrType)`](crate::client::fluent_builders::ListTrafficPolicyInstancesByHostedZone::traffic_policy_instance_type_marker) / [`set_traffic_policy_instance_type_marker(Option<RrType>)`](crate::client::fluent_builders::ListTrafficPolicyInstancesByHostedZone::set_traffic_policy_instance_type_marker): <p>If the value of <code>IsTruncated</code> in the previous response is true, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancetype</code>, specify the value of <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the type of the first traffic policy instance in the next group of traffic policy instances.</p>  <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListTrafficPolicyInstancesByHostedZone::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListTrafficPolicyInstancesByHostedZone::set_max_items): <p>The maximum number of traffic policy instances to be included in the response body for this request. If you have more than <code>MaxItems</code> traffic policy instances, the value of the <code>IsTruncated</code> element in the response is <code>true</code>, and the values of <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code> represent the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>
    /// - On success, responds with [`ListTrafficPolicyInstancesByHostedZoneOutput`](crate::output::ListTrafficPolicyInstancesByHostedZoneOutput) with field(s):
    ///   - [`traffic_policy_instances(Option<Vec<TrafficPolicyInstance>>)`](crate::output::ListTrafficPolicyInstancesByHostedZoneOutput::traffic_policy_instances): <p>A list that contains one <code>TrafficPolicyInstance</code> element for each traffic policy instance that matches the elements in the request. </p>
    ///   - [`traffic_policy_instance_name_marker(Option<String>)`](crate::output::ListTrafficPolicyInstancesByHostedZoneOutput::traffic_policy_instance_name_marker): <p>If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceNameMarker</code> is the name of the first traffic policy instance in the next group of traffic policy instances.</p>
    ///   - [`traffic_policy_instance_type_marker(Option<RrType>)`](crate::output::ListTrafficPolicyInstancesByHostedZoneOutput::traffic_policy_instance_type_marker): <p>If <code>IsTruncated</code> is true, <code>TrafficPolicyInstanceTypeMarker</code> is the DNS type of the resource record sets that are associated with the first traffic policy instance in the next group of traffic policy instances.</p>
    ///   - [`is_truncated(bool)`](crate::output::ListTrafficPolicyInstancesByHostedZoneOutput::is_truncated): <p>A flag that indicates whether there are more traffic policy instances to be listed. If the response was truncated, you can get the next group of traffic policy instances by submitting another <code>ListTrafficPolicyInstancesByHostedZone</code> request and specifying the values of <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code> in the corresponding request parameters.</p>
    ///   - [`max_items(Option<i32>)`](crate::output::ListTrafficPolicyInstancesByHostedZoneOutput::max_items): <p>The value that you specified for the <code>MaxItems</code> parameter in the <code>ListTrafficPolicyInstancesByHostedZone</code> request that produced the current response.</p>
    /// - On failure, responds with [`SdkError<ListTrafficPolicyInstancesByHostedZoneError>`](crate::error::ListTrafficPolicyInstancesByHostedZoneError)
    pub fn list_traffic_policy_instances_by_hosted_zone(
        &self,
    ) -> fluent_builders::ListTrafficPolicyInstancesByHostedZone {
        fluent_builders::ListTrafficPolicyInstancesByHostedZone::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTrafficPolicyInstancesByPolicy`](crate::client::fluent_builders::ListTrafficPolicyInstancesByPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`traffic_policy_id(impl Into<String>)`](crate::client::fluent_builders::ListTrafficPolicyInstancesByPolicy::traffic_policy_id) / [`set_traffic_policy_id(Option<String>)`](crate::client::fluent_builders::ListTrafficPolicyInstancesByPolicy::set_traffic_policy_id): <p>The ID of the traffic policy for which you want to list traffic policy instances.</p>
    ///   - [`traffic_policy_version(i32)`](crate::client::fluent_builders::ListTrafficPolicyInstancesByPolicy::traffic_policy_version) / [`set_traffic_policy_version(Option<i32>)`](crate::client::fluent_builders::ListTrafficPolicyInstancesByPolicy::set_traffic_policy_version): <p>The version of the traffic policy for which you want to list traffic policy instances. The version must be associated with the traffic policy that is specified by <code>TrafficPolicyId</code>.</p>
    ///   - [`hosted_zone_id_marker(impl Into<String>)`](crate::client::fluent_builders::ListTrafficPolicyInstancesByPolicy::hosted_zone_id_marker) / [`set_hosted_zone_id_marker(Option<String>)`](crate::client::fluent_builders::ListTrafficPolicyInstancesByPolicy::set_hosted_zone_id_marker): <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstancesByPolicy</code> request. </p>  <p>For the value of <code>hostedzoneid</code>, specify the value of <code>HostedZoneIdMarker</code> from the previous response, which is the hosted zone ID of the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>  <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
    ///   - [`traffic_policy_instance_name_marker(impl Into<String>)`](crate::client::fluent_builders::ListTrafficPolicyInstancesByPolicy::traffic_policy_instance_name_marker) / [`set_traffic_policy_instance_name_marker(Option<String>)`](crate::client::fluent_builders::ListTrafficPolicyInstancesByPolicy::set_traffic_policy_instance_name_marker): <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstancesByPolicy</code> request.</p>  <p>For the value of <code>trafficpolicyinstancename</code>, specify the value of <code>TrafficPolicyInstanceNameMarker</code> from the previous response, which is the name of the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>  <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
    ///   - [`traffic_policy_instance_type_marker(RrType)`](crate::client::fluent_builders::ListTrafficPolicyInstancesByPolicy::traffic_policy_instance_type_marker) / [`set_traffic_policy_instance_type_marker(Option<RrType>)`](crate::client::fluent_builders::ListTrafficPolicyInstancesByPolicy::set_traffic_policy_instance_type_marker): <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstancesByPolicy</code> request.</p>  <p>For the value of <code>trafficpolicyinstancetype</code>, specify the value of <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the name of the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>  <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListTrafficPolicyInstancesByPolicy::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListTrafficPolicyInstancesByPolicy::set_max_items): <p>The maximum number of traffic policy instances to be included in the response body for this request. If you have more than <code>MaxItems</code> traffic policy instances, the value of the <code>IsTruncated</code> element in the response is <code>true</code>, and the values of <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code> represent the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>
    /// - On success, responds with [`ListTrafficPolicyInstancesByPolicyOutput`](crate::output::ListTrafficPolicyInstancesByPolicyOutput) with field(s):
    ///   - [`traffic_policy_instances(Option<Vec<TrafficPolicyInstance>>)`](crate::output::ListTrafficPolicyInstancesByPolicyOutput::traffic_policy_instances): <p>A list that contains one <code>TrafficPolicyInstance</code> element for each traffic policy instance that matches the elements in the request.</p>
    ///   - [`hosted_zone_id_marker(Option<String>)`](crate::output::ListTrafficPolicyInstancesByPolicyOutput::hosted_zone_id_marker): <p>If <code>IsTruncated</code> is <code>true</code>, <code>HostedZoneIdMarker</code> is the ID of the hosted zone of the first traffic policy instance in the next group of traffic policy instances.</p>
    ///   - [`traffic_policy_instance_name_marker(Option<String>)`](crate::output::ListTrafficPolicyInstancesByPolicyOutput::traffic_policy_instance_name_marker): <p>If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceNameMarker</code> is the name of the first traffic policy instance in the next group of <code>MaxItems</code> traffic policy instances.</p>
    ///   - [`traffic_policy_instance_type_marker(Option<RrType>)`](crate::output::ListTrafficPolicyInstancesByPolicyOutput::traffic_policy_instance_type_marker): <p>If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceTypeMarker</code> is the DNS type of the resource record sets that are associated with the first traffic policy instance in the next group of <code>MaxItems</code> traffic policy instances.</p>
    ///   - [`is_truncated(bool)`](crate::output::ListTrafficPolicyInstancesByPolicyOutput::is_truncated): <p>A flag that indicates whether there are more traffic policy instances to be listed. If the response was truncated, you can get the next group of traffic policy instances by calling <code>ListTrafficPolicyInstancesByPolicy</code> again and specifying the values of the <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code> elements in the corresponding request parameters.</p>
    ///   - [`max_items(Option<i32>)`](crate::output::ListTrafficPolicyInstancesByPolicyOutput::max_items): <p>The value that you specified for the <code>MaxItems</code> parameter in the call to <code>ListTrafficPolicyInstancesByPolicy</code> that produced the current response.</p>
    /// - On failure, responds with [`SdkError<ListTrafficPolicyInstancesByPolicyError>`](crate::error::ListTrafficPolicyInstancesByPolicyError)
    pub fn list_traffic_policy_instances_by_policy(
        &self,
    ) -> fluent_builders::ListTrafficPolicyInstancesByPolicy {
        fluent_builders::ListTrafficPolicyInstancesByPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTrafficPolicyVersions`](crate::client::fluent_builders::ListTrafficPolicyVersions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::ListTrafficPolicyVersions::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::ListTrafficPolicyVersions::set_id): <p>Specify the value of <code>Id</code> of the traffic policy for which you want to list all versions.</p>
    ///   - [`traffic_policy_version_marker(impl Into<String>)`](crate::client::fluent_builders::ListTrafficPolicyVersions::traffic_policy_version_marker) / [`set_traffic_policy_version_marker(Option<String>)`](crate::client::fluent_builders::ListTrafficPolicyVersions::set_traffic_policy_version_marker): <p>For your first request to <code>ListTrafficPolicyVersions</code>, don't include the <code>TrafficPolicyVersionMarker</code> parameter.</p>  <p>If you have more traffic policy versions than the value of <code>MaxItems</code>, <code>ListTrafficPolicyVersions</code> returns only the first group of <code>MaxItems</code> versions. To get more traffic policy versions, submit another <code>ListTrafficPolicyVersions</code> request. For the value of <code>TrafficPolicyVersionMarker</code>, specify the value of <code>TrafficPolicyVersionMarker</code> in the previous response.</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListTrafficPolicyVersions::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListTrafficPolicyVersions::set_max_items): <p>The maximum number of traffic policy versions that you want Amazon Route 53 to include in the response body for this request. If the specified traffic policy has more than <code>MaxItems</code> versions, the value of <code>IsTruncated</code> in the response is <code>true</code>, and the value of the <code>TrafficPolicyVersionMarker</code> element is the ID of the first version that Route 53 will return if you submit another request.</p>
    /// - On success, responds with [`ListTrafficPolicyVersionsOutput`](crate::output::ListTrafficPolicyVersionsOutput) with field(s):
    ///   - [`traffic_policies(Option<Vec<TrafficPolicy>>)`](crate::output::ListTrafficPolicyVersionsOutput::traffic_policies): <p>A list that contains one <code>TrafficPolicy</code> element for each traffic policy version that is associated with the specified traffic policy.</p>
    ///   - [`is_truncated(bool)`](crate::output::ListTrafficPolicyVersionsOutput::is_truncated): <p>A flag that indicates whether there are more traffic policies to be listed. If the response was truncated, you can get the next group of traffic policies by submitting another <code>ListTrafficPolicyVersions</code> request and specifying the value of <code>NextMarker</code> in the <code>marker</code> parameter.</p>
    ///   - [`traffic_policy_version_marker(Option<String>)`](crate::output::ListTrafficPolicyVersionsOutput::traffic_policy_version_marker): <p>If <code>IsTruncated</code> is <code>true</code>, the value of <code>TrafficPolicyVersionMarker</code> identifies the first traffic policy that Amazon Route 53 will return if you submit another request. Call <code>ListTrafficPolicyVersions</code> again and specify the value of <code>TrafficPolicyVersionMarker</code> in the <code>TrafficPolicyVersionMarker</code> request parameter.</p>  <p>This element is present only if <code>IsTruncated</code> is <code>true</code>.</p>
    ///   - [`max_items(Option<i32>)`](crate::output::ListTrafficPolicyVersionsOutput::max_items): <p>The value that you specified for the <code>maxitems</code> parameter in the <code>ListTrafficPolicyVersions</code> request that produced the current response.</p>
    /// - On failure, responds with [`SdkError<ListTrafficPolicyVersionsError>`](crate::error::ListTrafficPolicyVersionsError)
    pub fn list_traffic_policy_versions(&self) -> fluent_builders::ListTrafficPolicyVersions {
        fluent_builders::ListTrafficPolicyVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListVPCAssociationAuthorizations`](crate::client::fluent_builders::ListVPCAssociationAuthorizations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hosted_zone_id(impl Into<String>)`](crate::client::fluent_builders::ListVPCAssociationAuthorizations::hosted_zone_id) / [`set_hosted_zone_id(Option<String>)`](crate::client::fluent_builders::ListVPCAssociationAuthorizations::set_hosted_zone_id): <p>The ID of the hosted zone for which you want a list of VPCs that can be associated with the hosted zone.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListVPCAssociationAuthorizations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListVPCAssociationAuthorizations::set_next_token): <p> <i>Optional</i>: If a response includes a <code>NextToken</code> element, there are more VPCs that can be associated with the specified hosted zone. To get the next page of results, submit another request, and include the value of <code>NextToken</code> from the response in the <code>nexttoken</code> parameter in another <code>ListVPCAssociationAuthorizations</code> request.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListVPCAssociationAuthorizations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListVPCAssociationAuthorizations::set_max_results): <p> <i>Optional</i>: An integer that specifies the maximum number of VPCs that you want Amazon Route 53 to return. If you don't specify a value for <code>MaxResults</code>, Route 53 returns up to 50 VPCs per page.</p>
    /// - On success, responds with [`ListVpcAssociationAuthorizationsOutput`](crate::output::ListVpcAssociationAuthorizationsOutput) with field(s):
    ///   - [`hosted_zone_id(Option<String>)`](crate::output::ListVpcAssociationAuthorizationsOutput::hosted_zone_id): <p>The ID of the hosted zone that you can associate the listed VPCs with.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListVpcAssociationAuthorizationsOutput::next_token): <p>When the response includes a <code>NextToken</code> element, there are more VPCs that can be associated with the specified hosted zone. To get the next page of VPCs, submit another <code>ListVPCAssociationAuthorizations</code> request, and include the value of the <code>NextToken</code> element from the response in the <code>nexttoken</code> request parameter.</p>
    ///   - [`vp_cs(Option<Vec<Vpc>>)`](crate::output::ListVpcAssociationAuthorizationsOutput::vp_cs): <p>The list of VPCs that are authorized to be associated with the specified hosted zone.</p>
    /// - On failure, responds with [`SdkError<ListVPCAssociationAuthorizationsError>`](crate::error::ListVPCAssociationAuthorizationsError)
    pub fn list_vpc_association_authorizations(
        &self,
    ) -> fluent_builders::ListVPCAssociationAuthorizations {
        fluent_builders::ListVPCAssociationAuthorizations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TestDNSAnswer`](crate::client::fluent_builders::TestDNSAnswer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hosted_zone_id(impl Into<String>)`](crate::client::fluent_builders::TestDNSAnswer::hosted_zone_id) / [`set_hosted_zone_id(Option<String>)`](crate::client::fluent_builders::TestDNSAnswer::set_hosted_zone_id): <p>The ID of the hosted zone that you want Amazon Route 53 to simulate a query for.</p>
    ///   - [`record_name(impl Into<String>)`](crate::client::fluent_builders::TestDNSAnswer::record_name) / [`set_record_name(Option<String>)`](crate::client::fluent_builders::TestDNSAnswer::set_record_name): <p>The name of the resource record set that you want Amazon Route 53 to simulate a query for.</p>
    ///   - [`record_type(RrType)`](crate::client::fluent_builders::TestDNSAnswer::record_type) / [`set_record_type(Option<RrType>)`](crate::client::fluent_builders::TestDNSAnswer::set_record_type): <p>The type of the resource record set.</p>
    ///   - [`resolver_ip(impl Into<String>)`](crate::client::fluent_builders::TestDNSAnswer::resolver_ip) / [`set_resolver_ip(Option<String>)`](crate::client::fluent_builders::TestDNSAnswer::set_resolver_ip): <p>If you want to simulate a request from a specific DNS resolver, specify the IP address for that resolver. If you omit this value, <code>TestDnsAnswer</code> uses the IP address of a DNS resolver in the Amazon Web Services US East (N. Virginia) Region (<code>us-east-1</code>).</p>
    ///   - [`edns0_client_subnet_ip(impl Into<String>)`](crate::client::fluent_builders::TestDNSAnswer::edns0_client_subnet_ip) / [`set_edns0_client_subnet_ip(Option<String>)`](crate::client::fluent_builders::TestDNSAnswer::set_edns0_client_subnet_ip): <p>If the resolver that you specified for resolverip supports EDNS0, specify the IPv4 or IPv6 address of a client in the applicable location, for example, <code>192.0.2.44</code> or <code>2001:db8:85a3::8a2e:370:7334</code>.</p>
    ///   - [`edns0_client_subnet_mask(impl Into<String>)`](crate::client::fluent_builders::TestDNSAnswer::edns0_client_subnet_mask) / [`set_edns0_client_subnet_mask(Option<String>)`](crate::client::fluent_builders::TestDNSAnswer::set_edns0_client_subnet_mask): <p>If you specify an IP address for <code>edns0clientsubnetip</code>, you can optionally specify the number of bits of the IP address that you want the checking tool to include in the DNS query. For example, if you specify <code>192.0.2.44</code> for <code>edns0clientsubnetip</code> and <code>24</code> for <code>edns0clientsubnetmask</code>, the checking tool will simulate a request from 192.0.2.0/24. The default value is 24 bits for IPv4 addresses and 64 bits for IPv6 addresses.</p>  <p>The range of valid values depends on whether <code>edns0clientsubnetip</code> is an IPv4 or an IPv6 address:</p>  <ul>   <li> <p> <b>IPv4</b>: Specify a value between 0 and 32</p> </li>   <li> <p> <b>IPv6</b>: Specify a value between 0 and 128</p> </li>  </ul>
    /// - On success, responds with [`TestDnsAnswerOutput`](crate::output::TestDnsAnswerOutput) with field(s):
    ///   - [`nameserver(Option<String>)`](crate::output::TestDnsAnswerOutput::nameserver): <p>The Amazon Route 53 name server used to respond to the request.</p>
    ///   - [`record_name(Option<String>)`](crate::output::TestDnsAnswerOutput::record_name): <p>The name of the resource record set that you submitted a request for.</p>
    ///   - [`record_type(Option<RrType>)`](crate::output::TestDnsAnswerOutput::record_type): <p>The type of the resource record set that you submitted a request for.</p>
    ///   - [`record_data(Option<Vec<String>>)`](crate::output::TestDnsAnswerOutput::record_data): <p>A list that contains values that Amazon Route 53 returned for this resource record set.</p>
    ///   - [`response_code(Option<String>)`](crate::output::TestDnsAnswerOutput::response_code): <p>A code that indicates whether the request is valid or not. The most common response code is <code>NOERROR</code>, meaning that the request is valid. If the response is not valid, Amazon Route 53 returns a response code that describes the error. For a list of possible response codes, see <a href="http://www.iana.org/assignments/dns-parameters/dns-parameters.xhtml#dns-parameters-6">DNS RCODES</a> on the IANA website. </p>
    ///   - [`protocol(Option<String>)`](crate::output::TestDnsAnswerOutput::protocol): <p>The protocol that Amazon Route 53 used to respond to the request, either <code>UDP</code> or <code>TCP</code>. </p>
    /// - On failure, responds with [`SdkError<TestDNSAnswerError>`](crate::error::TestDNSAnswerError)
    pub fn test_dns_answer(&self) -> fluent_builders::TestDNSAnswer {
        fluent_builders::TestDNSAnswer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateHealthCheck`](crate::client::fluent_builders::UpdateHealthCheck) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`health_check_id(impl Into<String>)`](crate::client::fluent_builders::UpdateHealthCheck::health_check_id) / [`set_health_check_id(Option<String>)`](crate::client::fluent_builders::UpdateHealthCheck::set_health_check_id): <p>The ID for the health check for which you want detailed information. When you created the health check, <code>CreateHealthCheck</code> returned the ID in the response, in the <code>HealthCheckId</code> element.</p>
    ///   - [`health_check_version(i64)`](crate::client::fluent_builders::UpdateHealthCheck::health_check_version) / [`set_health_check_version(Option<i64>)`](crate::client::fluent_builders::UpdateHealthCheck::set_health_check_version): <p>A sequential counter that Amazon Route 53 sets to <code>1</code> when you create a health check and increments by 1 each time you update settings for the health check.</p>  <p>We recommend that you use <code>GetHealthCheck</code> or <code>ListHealthChecks</code> to get the current value of <code>HealthCheckVersion</code> for the health check that you want to update, and that you include that value in your <code>UpdateHealthCheck</code> request. This prevents Route 53 from overwriting an intervening update:</p>  <ul>   <li> <p>If the value in the <code>UpdateHealthCheck</code> request matches the value of <code>HealthCheckVersion</code> in the health check, Route 53 updates the health check with the new settings.</p> </li>   <li> <p>If the value of <code>HealthCheckVersion</code> in the health check is greater, the health check was changed after you got the version number. Route 53 does not update the health check, and it returns a <code>HealthCheckVersionMismatch</code> error.</p> </li>  </ul>
    ///   - [`ip_address(impl Into<String>)`](crate::client::fluent_builders::UpdateHealthCheck::ip_address) / [`set_ip_address(Option<String>)`](crate::client::fluent_builders::UpdateHealthCheck::set_ip_address): <p>The IPv4 or IPv6 IP address for the endpoint that you want Amazon Route 53 to perform health checks on. If you don't specify a value for <code>IPAddress</code>, Route 53 sends a DNS request to resolve the domain name that you specify in <code>FullyQualifiedDomainName</code> at the interval that you specify in <code>RequestInterval</code>. Using an IP address that is returned by DNS, Route 53 then checks the health of the endpoint.</p>  <p>Use one of the following formats for the value of <code>IPAddress</code>: </p>  <ul>   <li> <p> <b>IPv4 address</b>: four values between 0 and 255, separated by periods (.), for example, <code>192.0.2.44</code>.</p> </li>   <li> <p> <b>IPv6 address</b>: eight groups of four hexadecimal values, separated by colons (:), for example, <code>2001:0db8:85a3:0000:0000:abcd:0001:2345</code>. You can also shorten IPv6 addresses as described in RFC 5952, for example, <code>2001:db8:85a3::abcd:1:2345</code>.</p> </li>  </ul>  <p>If the endpoint is an EC2 instance, we recommend that you create an Elastic IP address, associate it with your EC2 instance, and specify the Elastic IP address for <code>IPAddress</code>. This ensures that the IP address of your instance never changes. For more information, see the applicable documentation:</p>  <ul>   <li> <p>Linux: <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses (EIP)</a> in the <i>Amazon EC2 User Guide for Linux Instances</i> </p> </li>   <li> <p>Windows: <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses (EIP)</a> in the <i>Amazon EC2 User Guide for Windows Instances</i> </p> </li>  </ul> <note>   <p>If a health check already has a value for <code>IPAddress</code>, you can change the value. However, you can't update an existing health check to add or remove the value of <code>IPAddress</code>. </p>  </note>  <p>For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-FullyQualifiedDomainName">FullyQualifiedDomainName</a>. </p>  <p>Constraints: Route 53 can't check the health of endpoints for which the IP address is in local, private, non-routable, or multicast ranges. For more information about IP addresses for which you can't create health checks, see the following documents:</p>  <ul>   <li> <p> <a href="https://tools.ietf.org/html/rfc5735">RFC 5735, Special Use IPv4 Addresses</a> </p> </li>   <li> <p> <a href="https://tools.ietf.org/html/rfc6598">RFC 6598, IANA-Reserved IPv4 Prefix for Shared Address Space</a> </p> </li>   <li> <p> <a href="https://tools.ietf.org/html/rfc5156">RFC 5156, Special-Use IPv6 Addresses</a> </p> </li>  </ul>
    ///   - [`port(i32)`](crate::client::fluent_builders::UpdateHealthCheck::port) / [`set_port(Option<i32>)`](crate::client::fluent_builders::UpdateHealthCheck::set_port): <p>The port on the endpoint that you want Amazon Route 53 to perform health checks on.</p> <note>   <p>Don't specify a value for <code>Port</code> when you specify a value for <code>Type</code> of <code>CLOUDWATCH_METRIC</code> or <code>CALCULATED</code>.</p>  </note>
    ///   - [`resource_path(impl Into<String>)`](crate::client::fluent_builders::UpdateHealthCheck::resource_path) / [`set_resource_path(Option<String>)`](crate::client::fluent_builders::UpdateHealthCheck::set_resource_path): <p>The path that you want Amazon Route 53 to request when performing health checks. The path can be any value for which your endpoint will return an HTTP status code of 2xx or 3xx when the endpoint is healthy, for example the file /docs/route53-health-check.html. You can also include query string parameters, for example, <code>/welcome.html?language=jp&amp;login=y</code>. </p>  <p>Specify this value only if you want to change it.</p>
    ///   - [`fully_qualified_domain_name(impl Into<String>)`](crate::client::fluent_builders::UpdateHealthCheck::fully_qualified_domain_name) / [`set_fully_qualified_domain_name(Option<String>)`](crate::client::fluent_builders::UpdateHealthCheck::set_fully_qualified_domain_name): <p>Amazon Route 53 behavior depends on whether you specify a value for <code>IPAddress</code>.</p> <note>   <p>If a health check already has a value for <code>IPAddress</code>, you can change the value. However, you can't update an existing health check to add or remove the value of <code>IPAddress</code>. </p>  </note>  <p> <b>If you specify a value for</b> <code>IPAddress</code>:</p>  <p>Route 53 sends health check requests to the specified IPv4 or IPv6 address and passes the value of <code>FullyQualifiedDomainName</code> in the <code>Host</code> header for all health checks except TCP health checks. This is typically the fully qualified DNS name of the endpoint on which you want Route 53 to perform health checks.</p>  <p>When Route 53 checks the health of an endpoint, here is how it constructs the <code>Host</code> header:</p>  <ul>   <li> <p>If you specify a value of <code>80</code> for <code>Port</code> and <code>HTTP</code> or <code>HTTP_STR_MATCH</code> for <code>Type</code>, Route 53 passes the value of <code>FullyQualifiedDomainName</code> to the endpoint in the <code>Host</code> header.</p> </li>   <li> <p>If you specify a value of <code>443</code> for <code>Port</code> and <code>HTTPS</code> or <code>HTTPS_STR_MATCH</code> for <code>Type</code>, Route 53 passes the value of <code>FullyQualifiedDomainName</code> to the endpoint in the <code>Host</code> header.</p> </li>   <li> <p>If you specify another value for <code>Port</code> and any value except <code>TCP</code> for <code>Type</code>, Route 53 passes <i> <code>FullyQualifiedDomainName</code>:<code>Port</code> </i> to the endpoint in the <code>Host</code> header.</p> </li>  </ul>  <p>If you don't specify a value for <code>FullyQualifiedDomainName</code>, Route 53 substitutes the value of <code>IPAddress</code> in the <code>Host</code> header in each of the above cases.</p>  <p> <b>If you don't specify a value for</b> <code>IPAddress</code>:</p>  <p>If you don't specify a value for <code>IPAddress</code>, Route 53 sends a DNS request to the domain that you specify in <code>FullyQualifiedDomainName</code> at the interval you specify in <code>RequestInterval</code>. Using an IPv4 address that is returned by DNS, Route 53 then checks the health of the endpoint.</p> <note>   <p>If you don't specify a value for <code>IPAddress</code>, Route 53 uses only IPv4 to send health checks to the endpoint. If there's no resource record set with a type of A for the name that you specify for <code>FullyQualifiedDomainName</code>, the health check fails with a "DNS resolution failed" error.</p>  </note>  <p>If you want to check the health of weighted, latency, or failover resource record sets and you choose to specify the endpoint only by <code>FullyQualifiedDomainName</code>, we recommend that you create a separate health check for each endpoint. For example, create a health check for each HTTP server that is serving content for www.example.com. For the value of <code>FullyQualifiedDomainName</code>, specify the domain name of the server (such as <code>us-east-2-www.example.com</code>), not the name of the resource record sets (www.example.com).</p> <important>   <p>In this configuration, if the value of <code>FullyQualifiedDomainName</code> matches the name of the resource record sets and you then associate the health check with those resource record sets, health check results will be unpredictable.</p>  </important>  <p>In addition, if the value of <code>Type</code> is <code>HTTP</code>, <code>HTTPS</code>, <code>HTTP_STR_MATCH</code>, or <code>HTTPS_STR_MATCH</code>, Route 53 passes the value of <code>FullyQualifiedDomainName</code> in the <code>Host</code> header, as it does when you specify a value for <code>IPAddress</code>. If the value of <code>Type</code> is <code>TCP</code>, Route 53 doesn't pass a <code>Host</code> header.</p>
    ///   - [`search_string(impl Into<String>)`](crate::client::fluent_builders::UpdateHealthCheck::search_string) / [`set_search_string(Option<String>)`](crate::client::fluent_builders::UpdateHealthCheck::set_search_string): <p>If the value of <code>Type</code> is <code>HTTP_STR_MATCH</code> or <code>HTTPS_STR_MATCH</code>, the string that you want Amazon Route 53 to search for in the response body from the specified resource. If the string appears in the response body, Route 53 considers the resource healthy. (You can't change the value of <code>Type</code> when you update a health check.)</p>
    ///   - [`failure_threshold(i32)`](crate::client::fluent_builders::UpdateHealthCheck::failure_threshold) / [`set_failure_threshold(Option<i32>)`](crate::client::fluent_builders::UpdateHealthCheck::set_failure_threshold): <p>The number of consecutive health checks that an endpoint must pass or fail for Amazon Route 53 to change the current status of the endpoint from unhealthy to healthy or vice versa. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How Amazon Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>  <p>If you don't specify a value for <code>FailureThreshold</code>, the default value is three health checks.</p>
    ///   - [`inverted(bool)`](crate::client::fluent_builders::UpdateHealthCheck::inverted) / [`set_inverted(Option<bool>)`](crate::client::fluent_builders::UpdateHealthCheck::set_inverted): <p>Specify whether you want Amazon Route 53 to invert the status of a health check, for example, to consider a health check unhealthy when it otherwise would be considered healthy.</p>
    ///   - [`disabled(bool)`](crate::client::fluent_builders::UpdateHealthCheck::disabled) / [`set_disabled(Option<bool>)`](crate::client::fluent_builders::UpdateHealthCheck::set_disabled): <p>Stops Route 53 from performing health checks. When you disable a health check, here's what happens:</p>  <ul>   <li> <p> <b>Health checks that check the health of endpoints:</b> Route 53 stops submitting requests to your application, server, or other resource.</p> </li>   <li> <p> <b>Calculated health checks:</b> Route 53 stops aggregating the status of the referenced health checks.</p> </li>   <li> <p> <b>Health checks that monitor CloudWatch alarms:</b> Route 53 stops monitoring the corresponding CloudWatch metrics.</p> </li>  </ul>  <p>After you disable a health check, Route 53 considers the status of the health check to always be healthy. If you configured DNS failover, Route 53 continues to route traffic to the corresponding resources. If you want to stop routing traffic to a resource, change the value of <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-Inverted">Inverted</a>. </p>  <p>Charges for a health check still apply when the health check is disabled. For more information, see <a href="http://aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a>.</p>
    ///   - [`health_threshold(i32)`](crate::client::fluent_builders::UpdateHealthCheck::health_threshold) / [`set_health_threshold(Option<i32>)`](crate::client::fluent_builders::UpdateHealthCheck::set_health_threshold): <p>The number of child health checks that are associated with a <code>CALCULATED</code> health that Amazon Route 53 must consider healthy for the <code>CALCULATED</code> health check to be considered healthy. To specify the child health checks that you want to associate with a <code>CALCULATED</code> health check, use the <code>ChildHealthChecks</code> and <code>ChildHealthCheck</code> elements.</p>  <p>Note the following:</p>  <ul>   <li> <p>If you specify a number greater than the number of child health checks, Route 53 always considers this health check to be unhealthy.</p> </li>   <li> <p>If you specify <code>0</code>, Route 53 always considers this health check to be healthy.</p> </li>  </ul>
    ///   - [`child_health_checks(Vec<String>)`](crate::client::fluent_builders::UpdateHealthCheck::child_health_checks) / [`set_child_health_checks(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateHealthCheck::set_child_health_checks): <p>A complex type that contains one <code>ChildHealthCheck</code> element for each health check that you want to associate with a <code>CALCULATED</code> health check.</p>
    ///   - [`enable_sni(bool)`](crate::client::fluent_builders::UpdateHealthCheck::enable_sni) / [`set_enable_sni(Option<bool>)`](crate::client::fluent_builders::UpdateHealthCheck::set_enable_sni): <p>Specify whether you want Amazon Route 53 to send the value of <code>FullyQualifiedDomainName</code> to the endpoint in the <code>client_hello</code> message during <code>TLS</code> negotiation. This allows the endpoint to respond to <code>HTTPS</code> health check requests with the applicable SSL/TLS certificate.</p>  <p>Some endpoints require that HTTPS requests include the host name in the <code>client_hello</code> message. If you don't enable SNI, the status of the health check will be SSL alert <code>handshake_failure</code>. A health check can also have that status for other reasons. If SNI is enabled and you're still getting the error, check the SSL/TLS configuration on your endpoint and confirm that your certificate is valid.</p>  <p>The SSL/TLS certificate on your endpoint includes a domain name in the <code>Common Name</code> field and possibly several more in the <code>Subject Alternative Names</code> field. One of the domain names in the certificate should match the value that you specify for <code>FullyQualifiedDomainName</code>. If the endpoint responds to the <code>client_hello</code> message with a certificate that does not include the domain name that you specified in <code>FullyQualifiedDomainName</code>, a health checker will retry the handshake. In the second attempt, the health checker will omit <code>FullyQualifiedDomainName</code> from the <code>client_hello</code> message.</p>
    ///   - [`regions(Vec<HealthCheckRegion>)`](crate::client::fluent_builders::UpdateHealthCheck::regions) / [`set_regions(Option<Vec<HealthCheckRegion>>)`](crate::client::fluent_builders::UpdateHealthCheck::set_regions): <p>A complex type that contains one <code>Region</code> element for each region that you want Amazon Route 53 health checkers to check the specified endpoint from.</p>
    ///   - [`alarm_identifier(AlarmIdentifier)`](crate::client::fluent_builders::UpdateHealthCheck::alarm_identifier) / [`set_alarm_identifier(Option<AlarmIdentifier>)`](crate::client::fluent_builders::UpdateHealthCheck::set_alarm_identifier): <p>A complex type that identifies the CloudWatch alarm that you want Amazon Route 53 health checkers to use to determine whether the specified health check is healthy.</p>
    ///   - [`insufficient_data_health_status(InsufficientDataHealthStatus)`](crate::client::fluent_builders::UpdateHealthCheck::insufficient_data_health_status) / [`set_insufficient_data_health_status(Option<InsufficientDataHealthStatus>)`](crate::client::fluent_builders::UpdateHealthCheck::set_insufficient_data_health_status): <p>When CloudWatch has insufficient data about the metric to determine the alarm state, the status that you want Amazon Route 53 to assign to the health check:</p>  <ul>   <li> <p> <code>Healthy</code>: Route 53 considers the health check to be healthy.</p> </li>   <li> <p> <code>Unhealthy</code>: Route 53 considers the health check to be unhealthy.</p> </li>   <li> <p> <code>LastKnownStatus</code>: By default, Route 53 uses the status of the health check from the last time CloudWatch had sufficient data to determine the alarm state. For new health checks that have no last known status, the status for the health check is healthy.</p> </li>  </ul>
    ///   - [`reset_elements(Vec<ResettableElementName>)`](crate::client::fluent_builders::UpdateHealthCheck::reset_elements) / [`set_reset_elements(Option<Vec<ResettableElementName>>)`](crate::client::fluent_builders::UpdateHealthCheck::set_reset_elements): <p>A complex type that contains one <code>ResettableElementName</code> element for each element that you want to reset to the default value. Valid values for <code>ResettableElementName</code> include the following:</p>  <ul>   <li> <p> <code>ChildHealthChecks</code>: Amazon Route 53 resets <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-ChildHealthChecks">ChildHealthChecks</a> to null.</p> </li>   <li> <p> <code>FullyQualifiedDomainName</code>: Route 53 resets <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-FullyQualifiedDomainName">FullyQualifiedDomainName</a>. to null.</p> </li>   <li> <p> <code>Regions</code>: Route 53 resets the <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-Regions">Regions</a> list to the default set of regions. </p> </li>   <li> <p> <code>ResourcePath</code>: Route 53 resets <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-ResourcePath">ResourcePath</a> to null.</p> </li>  </ul>
    /// - On success, responds with [`UpdateHealthCheckOutput`](crate::output::UpdateHealthCheckOutput) with field(s):
    ///   - [`health_check(Option<HealthCheck>)`](crate::output::UpdateHealthCheckOutput::health_check): <p>A complex type that contains the response to an <code>UpdateHealthCheck</code> request.</p>
    /// - On failure, responds with [`SdkError<UpdateHealthCheckError>`](crate::error::UpdateHealthCheckError)
    pub fn update_health_check(&self) -> fluent_builders::UpdateHealthCheck {
        fluent_builders::UpdateHealthCheck::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateHostedZoneComment`](crate::client::fluent_builders::UpdateHostedZoneComment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdateHostedZoneComment::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdateHostedZoneComment::set_id): <p>The ID for the hosted zone that you want to update the comment for.</p>
    ///   - [`comment(impl Into<String>)`](crate::client::fluent_builders::UpdateHostedZoneComment::comment) / [`set_comment(Option<String>)`](crate::client::fluent_builders::UpdateHostedZoneComment::set_comment): <p>The new comment for the hosted zone. If you don't specify a value for <code>Comment</code>, Amazon Route 53 deletes the existing value of the <code>Comment</code> element, if any.</p>
    /// - On success, responds with [`UpdateHostedZoneCommentOutput`](crate::output::UpdateHostedZoneCommentOutput) with field(s):
    ///   - [`hosted_zone(Option<HostedZone>)`](crate::output::UpdateHostedZoneCommentOutput::hosted_zone): <p>A complex type that contains the response to the <code>UpdateHostedZoneComment</code> request.</p>
    /// - On failure, responds with [`SdkError<UpdateHostedZoneCommentError>`](crate::error::UpdateHostedZoneCommentError)
    pub fn update_hosted_zone_comment(&self) -> fluent_builders::UpdateHostedZoneComment {
        fluent_builders::UpdateHostedZoneComment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateTrafficPolicyComment`](crate::client::fluent_builders::UpdateTrafficPolicyComment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdateTrafficPolicyComment::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdateTrafficPolicyComment::set_id): <p>The value of <code>Id</code> for the traffic policy that you want to update the comment for.</p>
    ///   - [`version(i32)`](crate::client::fluent_builders::UpdateTrafficPolicyComment::version) / [`set_version(Option<i32>)`](crate::client::fluent_builders::UpdateTrafficPolicyComment::set_version): <p>The value of <code>Version</code> for the traffic policy that you want to update the comment for.</p>
    ///   - [`comment(impl Into<String>)`](crate::client::fluent_builders::UpdateTrafficPolicyComment::comment) / [`set_comment(Option<String>)`](crate::client::fluent_builders::UpdateTrafficPolicyComment::set_comment): <p>The new comment for the specified traffic policy and version.</p>
    /// - On success, responds with [`UpdateTrafficPolicyCommentOutput`](crate::output::UpdateTrafficPolicyCommentOutput) with field(s):
    ///   - [`traffic_policy(Option<TrafficPolicy>)`](crate::output::UpdateTrafficPolicyCommentOutput::traffic_policy): <p>A complex type that contains settings for the specified traffic policy.</p>
    /// - On failure, responds with [`SdkError<UpdateTrafficPolicyCommentError>`](crate::error::UpdateTrafficPolicyCommentError)
    pub fn update_traffic_policy_comment(&self) -> fluent_builders::UpdateTrafficPolicyComment {
        fluent_builders::UpdateTrafficPolicyComment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateTrafficPolicyInstance`](crate::client::fluent_builders::UpdateTrafficPolicyInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdateTrafficPolicyInstance::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdateTrafficPolicyInstance::set_id): <p>The ID of the traffic policy instance that you want to update.</p>
    ///   - [`ttl(i64)`](crate::client::fluent_builders::UpdateTrafficPolicyInstance::ttl) / [`set_ttl(Option<i64>)`](crate::client::fluent_builders::UpdateTrafficPolicyInstance::set_ttl): <p>The TTL that you want Amazon Route 53 to assign to all of the updated resource record sets.</p>
    ///   - [`traffic_policy_id(impl Into<String>)`](crate::client::fluent_builders::UpdateTrafficPolicyInstance::traffic_policy_id) / [`set_traffic_policy_id(Option<String>)`](crate::client::fluent_builders::UpdateTrafficPolicyInstance::set_traffic_policy_id): <p>The ID of the traffic policy that you want Amazon Route 53 to use to update resource record sets for the specified traffic policy instance.</p>
    ///   - [`traffic_policy_version(i32)`](crate::client::fluent_builders::UpdateTrafficPolicyInstance::traffic_policy_version) / [`set_traffic_policy_version(Option<i32>)`](crate::client::fluent_builders::UpdateTrafficPolicyInstance::set_traffic_policy_version): <p>The version of the traffic policy that you want Amazon Route 53 to use to update resource record sets for the specified traffic policy instance.</p>
    /// - On success, responds with [`UpdateTrafficPolicyInstanceOutput`](crate::output::UpdateTrafficPolicyInstanceOutput) with field(s):
    ///   - [`traffic_policy_instance(Option<TrafficPolicyInstance>)`](crate::output::UpdateTrafficPolicyInstanceOutput::traffic_policy_instance): <p>A complex type that contains settings for the updated traffic policy instance.</p>
    /// - On failure, responds with [`SdkError<UpdateTrafficPolicyInstanceError>`](crate::error::UpdateTrafficPolicyInstanceError)
    pub fn update_traffic_policy_instance(&self) -> fluent_builders::UpdateTrafficPolicyInstance {
        fluent_builders::UpdateTrafficPolicyInstance::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `ActivateKeySigningKey`.
    ///
    /// <p>Activates a key-signing key (KSK) so that it can be used for signing by DNSSEC. This operation changes the KSK status to <code>ACTIVE</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ActivateKeySigningKey {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::activate_key_signing_key_input::Builder,
    }
    impl ActivateKeySigningKey {
        /// Creates a new `ActivateKeySigningKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ActivateKeySigningKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::ActivateKeySigningKeyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique string used to identify a hosted zone.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>A unique string used to identify a hosted zone.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
        /// <p>A string used to identify a key-signing key (KSK). <code>Name</code> can include numbers, letters, and underscores (_). <code>Name</code> must be unique for each key-signing key in the same hosted zone.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A string used to identify a key-signing key (KSK). <code>Name</code> can include numbers, letters, and underscores (_). <code>Name</code> must be unique for each key-signing key in the same hosted zone.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateVPCWithHostedZone`.
    ///
    /// <p>Associates an Amazon VPC with a private hosted zone. </p> <important>
    /// <p>To perform the association, the VPC and the private hosted zone must already exist. You can't convert a public hosted zone into a private hosted zone.</p>
    /// </important> <note>
    /// <p>If you want to associate a VPC that was created by using one Amazon Web Services account with a private hosted zone that was created by using a different account, the Amazon Web Services account that created the private hosted zone must first submit a <code>CreateVPCAssociationAuthorization</code> request. Then the account that created the VPC must submit an <code>AssociateVPCWithHostedZone</code> request.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateVPCWithHostedZone {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_vpc_with_hosted_zone_input::Builder,
    }
    impl AssociateVPCWithHostedZone {
        /// Creates a new `AssociateVPCWithHostedZone`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateVpcWithHostedZoneOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateVPCWithHostedZoneError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the private hosted zone that you want to associate an Amazon VPC with.</p>
        /// <p>Note that you can't associate a VPC with a hosted zone that doesn't have an existing VPC association.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>The ID of the private hosted zone that you want to associate an Amazon VPC with.</p>
        /// <p>Note that you can't associate a VPC with a hosted zone that doesn't have an existing VPC association.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
        /// <p>A complex type that contains information about the VPC that you want to associate with a private hosted zone.</p>
        pub fn vpc(mut self, input: crate::model::Vpc) -> Self {
            self.inner = self.inner.vpc(input);
            self
        }
        /// <p>A complex type that contains information about the VPC that you want to associate with a private hosted zone.</p>
        pub fn set_vpc(mut self, input: std::option::Option<crate::model::Vpc>) -> Self {
            self.inner = self.inner.set_vpc(input);
            self
        }
        /// <p> <i>Optional:</i> A comment about the association request.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.comment(input.into());
            self
        }
        /// <p> <i>Optional:</i> A comment about the association request.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_comment(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ChangeResourceRecordSets`.
    ///
    /// <p>Creates, changes, or deletes a resource record set, which contains authoritative DNS information for a specified domain name or subdomain name. For example, you can use <code>ChangeResourceRecordSets</code> to create a resource record set that routes traffic for test.example.com to a web server that has an IP address of 192.0.2.44.</p>
    /// <p> <b>Deleting Resource Record Sets</b> </p>
    /// <p>To delete a resource record set, you must specify all the same values that you specified when you created it.</p>
    /// <p> <b>Change Batches and Transactional Changes</b> </p>
    /// <p>The request body must include a document with a <code>ChangeResourceRecordSetsRequest</code> element. The request body contains a list of change items, known as a change batch. Change batches are considered transactional changes. Route 53 validates the changes in the request and then either makes all or none of the changes in the change batch request. This ensures that DNS routing isn't adversely affected by partial changes to the resource record sets in a hosted zone. </p>
    /// <p>For example, suppose a change batch request contains two changes: it deletes the <code>CNAME</code> resource record set for www.example.com and creates an alias resource record set for www.example.com. If validation for both records succeeds, Route 53 deletes the first resource record set and creates the second resource record set in a single operation. If validation for either the <code>DELETE</code> or the <code>CREATE</code> action fails, then the request is canceled, and the original <code>CNAME</code> record continues to exist.</p> <note>
    /// <p>If you try to delete the same resource record set more than once in a single change batch, Route 53 returns an <code>InvalidChangeBatch</code> error.</p>
    /// </note>
    /// <p> <b>Traffic Flow</b> </p>
    /// <p>To create resource record sets for complex routing configurations, use either the traffic flow visual editor in the Route 53 console or the API actions for traffic policies and traffic policy instances. Save the configuration as a traffic policy, then associate the traffic policy with one or more domain names (such as example.com) or subdomain names (such as www.example.com), in the same hosted zone or in multiple hosted zones. You can roll back the updates if the new configuration isn't performing as expected. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/traffic-flow.html">Using Traffic Flow to Route DNS Traffic</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
    /// <p> <b>Create, Delete, and Upsert</b> </p>
    /// <p>Use <code>ChangeResourceRecordsSetsRequest</code> to perform the following actions:</p>
    /// <ul>
    /// <li> <p> <code>CREATE</code>: Creates a resource record set that has the specified values.</p> </li>
    /// <li> <p> <code>DELETE</code>: Deletes an existing resource record set that has the specified values.</p> </li>
    /// <li> <p> <code>UPSERT</code>: If a resource record set does not already exist, Amazon Web Services creates it. If a resource set does exist, Route 53 updates it with the values in the request. </p> </li>
    /// </ul>
    /// <p> <b>Syntaxes for Creating, Updating, and Deleting Resource Record Sets</b> </p>
    /// <p>The syntax for a request depends on the type of resource record set that you want to create, delete, or update, such as weighted, alias, or failover. The XML elements in your request must appear in the order listed in the syntax. </p>
    /// <p>For an example for each type of resource record set, see "Examples."</p>
    /// <p>Don't refer to the syntax in the "Parameter Syntax" section, which includes all of the elements for every kind of resource record set that you can create, delete, or update by using <code>ChangeResourceRecordSets</code>. </p>
    /// <p> <b>Change Propagation to Route 53 DNS Servers</b> </p>
    /// <p>When you submit a <code>ChangeResourceRecordSets</code> request, Route 53 propagates your changes to all of the Route 53 authoritative DNS servers. While your changes are propagating, <code>GetChange</code> returns a status of <code>PENDING</code>. When propagation is complete, <code>GetChange</code> returns a status of <code>INSYNC</code>. Changes generally propagate to all Route 53 name servers within 60 seconds. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetChange.html">GetChange</a>.</p>
    /// <p> <b>Limits on ChangeResourceRecordSets Requests</b> </p>
    /// <p>For information about the limits on a <code>ChangeResourceRecordSets</code> request, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ChangeResourceRecordSets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::change_resource_record_sets_input::Builder,
    }
    impl ChangeResourceRecordSets {
        /// Creates a new `ChangeResourceRecordSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ChangeResourceRecordSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ChangeResourceRecordSetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the hosted zone that contains the resource record sets that you want to change.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>The ID of the hosted zone that contains the resource record sets that you want to change.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
        /// <p>A complex type that contains an optional comment and the <code>Changes</code> element.</p>
        pub fn change_batch(mut self, input: crate::model::ChangeBatch) -> Self {
            self.inner = self.inner.change_batch(input);
            self
        }
        /// <p>A complex type that contains an optional comment and the <code>Changes</code> element.</p>
        pub fn set_change_batch(
            mut self,
            input: std::option::Option<crate::model::ChangeBatch>,
        ) -> Self {
            self.inner = self.inner.set_change_batch(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ChangeTagsForResource`.
    ///
    /// <p>Adds, edits, or deletes tags for a health check or a hosted zone.</p>
    /// <p>For information about using tags for cost allocation, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the <i>Billing and Cost Management User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ChangeTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::change_tags_for_resource_input::Builder,
    }
    impl ChangeTagsForResource {
        /// Creates a new `ChangeTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ChangeTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ChangeTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The type of the resource.</p>
        /// <ul>
        /// <li> <p>The resource type for health checks is <code>healthcheck</code>.</p> </li>
        /// <li> <p>The resource type for hosted zones is <code>hostedzone</code>.</p> </li>
        /// </ul>
        pub fn resource_type(mut self, input: crate::model::TagResourceType) -> Self {
            self.inner = self.inner.resource_type(input);
            self
        }
        /// <p>The type of the resource.</p>
        /// <ul>
        /// <li> <p>The resource type for health checks is <code>healthcheck</code>.</p> </li>
        /// <li> <p>The resource type for hosted zones is <code>hostedzone</code>.</p> </li>
        /// </ul>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::TagResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The ID of the resource for which you want to add, change, or delete tags.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The ID of the resource for which you want to add, change, or delete tags.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// Appends an item to `AddTags`.
        ///
        /// To override the contents of this collection use [`set_add_tags`](Self::set_add_tags).
        ///
        /// <p>A complex type that contains a list of the tags that you want to add to the specified health check or hosted zone and/or the tags that you want to edit <code>Value</code> for.</p>
        /// <p>You can add a maximum of 10 tags to a health check or a hosted zone.</p>
        pub fn add_tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.add_tags(input);
            self
        }
        /// <p>A complex type that contains a list of the tags that you want to add to the specified health check or hosted zone and/or the tags that you want to edit <code>Value</code> for.</p>
        /// <p>You can add a maximum of 10 tags to a health check or a hosted zone.</p>
        pub fn set_add_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_add_tags(input);
            self
        }
        /// Appends an item to `RemoveTagKeys`.
        ///
        /// To override the contents of this collection use [`set_remove_tag_keys`](Self::set_remove_tag_keys).
        ///
        /// <p>A complex type that contains a list of the tags that you want to delete from the specified health check or hosted zone. You can specify up to 10 keys.</p>
        pub fn remove_tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.remove_tag_keys(input.into());
            self
        }
        /// <p>A complex type that contains a list of the tags that you want to delete from the specified health check or hosted zone. You can specify up to 10 keys.</p>
        pub fn set_remove_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_remove_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateHealthCheck`.
    ///
    /// <p>Creates a new health check.</p>
    /// <p>For information about adding health checks to resource record sets, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ResourceRecordSet.html#Route53-Type-ResourceRecordSet-HealthCheckId">HealthCheckId</a> in <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ChangeResourceRecordSets.html">ChangeResourceRecordSets</a>. </p>
    /// <p> <b>ELB Load Balancers</b> </p>
    /// <p>If you're registering EC2 instances with an Elastic Load Balancing (ELB) load balancer, do not create Amazon Route 53 health checks for the EC2 instances. When you register an EC2 instance with a load balancer, you configure settings for an ELB health check, which performs a similar function to a Route 53 health check.</p>
    /// <p> <b>Private Hosted Zones</b> </p>
    /// <p>You can associate health checks with failover resource record sets in a private hosted zone. Note the following:</p>
    /// <ul>
    /// <li> <p>Route 53 health checkers are outside the VPC. To check the health of an endpoint within a VPC by IP address, you must assign a public IP address to the instance in the VPC.</p> </li>
    /// <li> <p>You can configure a health checker to check the health of an external resource that the instance relies on, such as a database server.</p> </li>
    /// <li> <p>You can create a CloudWatch metric, associate an alarm with the metric, and then create a health check that is based on the state of the alarm. For example, you might create a CloudWatch metric that checks the status of the Amazon EC2 <code>StatusCheckFailed</code> metric, add an alarm to the metric, and then create a health check that is based on the state of the alarm. For information about creating CloudWatch metrics and alarms by using the CloudWatch console, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/WhatIsCloudWatch.html">Amazon CloudWatch User Guide</a>.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateHealthCheck {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_health_check_input::Builder,
    }
    impl CreateHealthCheck {
        /// Creates a new `CreateHealthCheck`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateHealthCheckOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateHealthCheckError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique string that identifies the request and that allows you to retry a failed <code>CreateHealthCheck</code> request without the risk of creating two identical health checks:</p>
        /// <ul>
        /// <li> <p>If you send a <code>CreateHealthCheck</code> request with the same <code>CallerReference</code> and settings as a previous request, and if the health check doesn't exist, Amazon Route 53 creates the health check. If the health check does exist, Route 53 returns the settings for the existing health check.</p> </li>
        /// <li> <p>If you send a <code>CreateHealthCheck</code> request with the same <code>CallerReference</code> as a deleted health check, regardless of the settings, Route 53 returns a <code>HealthCheckAlreadyExists</code> error.</p> </li>
        /// <li> <p>If you send a <code>CreateHealthCheck</code> request with the same <code>CallerReference</code> as an existing health check but with different settings, Route 53 returns a <code>HealthCheckAlreadyExists</code> error.</p> </li>
        /// <li> <p>If you send a <code>CreateHealthCheck</code> request with a unique <code>CallerReference</code> but settings identical to an existing health check, Route 53 creates the health check.</p> </li>
        /// </ul>
        pub fn caller_reference(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.caller_reference(input.into());
            self
        }
        /// <p>A unique string that identifies the request and that allows you to retry a failed <code>CreateHealthCheck</code> request without the risk of creating two identical health checks:</p>
        /// <ul>
        /// <li> <p>If you send a <code>CreateHealthCheck</code> request with the same <code>CallerReference</code> and settings as a previous request, and if the health check doesn't exist, Amazon Route 53 creates the health check. If the health check does exist, Route 53 returns the settings for the existing health check.</p> </li>
        /// <li> <p>If you send a <code>CreateHealthCheck</code> request with the same <code>CallerReference</code> as a deleted health check, regardless of the settings, Route 53 returns a <code>HealthCheckAlreadyExists</code> error.</p> </li>
        /// <li> <p>If you send a <code>CreateHealthCheck</code> request with the same <code>CallerReference</code> as an existing health check but with different settings, Route 53 returns a <code>HealthCheckAlreadyExists</code> error.</p> </li>
        /// <li> <p>If you send a <code>CreateHealthCheck</code> request with a unique <code>CallerReference</code> but settings identical to an existing health check, Route 53 creates the health check.</p> </li>
        /// </ul>
        pub fn set_caller_reference(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_caller_reference(input);
            self
        }
        /// <p>A complex type that contains settings for a new health check.</p>
        pub fn health_check_config(mut self, input: crate::model::HealthCheckConfig) -> Self {
            self.inner = self.inner.health_check_config(input);
            self
        }
        /// <p>A complex type that contains settings for a new health check.</p>
        pub fn set_health_check_config(
            mut self,
            input: std::option::Option<crate::model::HealthCheckConfig>,
        ) -> Self {
            self.inner = self.inner.set_health_check_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateHostedZone`.
    ///
    /// <p>Creates a new public or private hosted zone. You create records in a public hosted zone to define how you want to route traffic on the internet for a domain, such as example.com, and its subdomains (apex.example.com, acme.example.com). You create records in a private hosted zone to define how you want to route traffic for a domain and its subdomains within one or more Amazon Virtual Private Clouds (Amazon VPCs). </p> <important>
    /// <p>You can't convert a public hosted zone to a private hosted zone or vice versa. Instead, you must create a new hosted zone with the same name and create new resource record sets.</p>
    /// </important>
    /// <p>For more information about charges for hosted zones, see <a href="http://aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a>.</p>
    /// <p>Note the following:</p>
    /// <ul>
    /// <li> <p>You can't create a hosted zone for a top-level domain (TLD) such as .com.</p> </li>
    /// <li> <p>For public hosted zones, Route 53 automatically creates a default SOA record and four NS records for the zone. For more information about SOA and NS records, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/SOA-NSrecords.html">NS and SOA Records that Route 53 Creates for a Hosted Zone</a> in the <i>Amazon Route 53 Developer Guide</i>.</p> <p>If you want to use the same name servers for multiple public hosted zones, you can optionally associate a reusable delegation set with the hosted zone. See the <code>DelegationSetId</code> element.</p> </li>
    /// <li> <p>If your domain is registered with a registrar other than Route 53, you must update the name servers with your registrar to make Route 53 the DNS service for the domain. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/MigratingDNS.html">Migrating DNS Service for an Existing Domain to Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>. </p> </li>
    /// </ul>
    /// <p>When you submit a <code>CreateHostedZone</code> request, the initial status of the hosted zone is <code>PENDING</code>. For public hosted zones, this means that the NS and SOA records are not yet available on all Route 53 DNS servers. When the NS and SOA records are available, the status of the zone changes to <code>INSYNC</code>.</p>
    /// <p>The <code>CreateHostedZone</code> request requires the caller to have an <code>ec2:DescribeVpcs</code> permission.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateHostedZone {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_hosted_zone_input::Builder,
    }
    impl CreateHostedZone {
        /// Creates a new `CreateHostedZone`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateHostedZoneOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateHostedZoneError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain. Specify a fully qualified domain name, for example, <i>www.example.com</i>. The trailing dot is optional; Amazon Route 53 assumes that the domain name is fully qualified. This means that Route 53 treats <i>www.example.com</i> (without a trailing dot) and <i>www.example.com.</i> (with a trailing dot) as identical.</p>
        /// <p>If you're creating a public hosted zone, this is the name you have registered with your DNS registrar. If your domain name is registered with a registrar other than Route 53, change the name servers for your domain to the set of <code>NameServers</code> that <code>CreateHostedZone</code> returns in <code>DelegationSet</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the domain. Specify a fully qualified domain name, for example, <i>www.example.com</i>. The trailing dot is optional; Amazon Route 53 assumes that the domain name is fully qualified. This means that Route 53 treats <i>www.example.com</i> (without a trailing dot) and <i>www.example.com.</i> (with a trailing dot) as identical.</p>
        /// <p>If you're creating a public hosted zone, this is the name you have registered with your DNS registrar. If your domain name is registered with a registrar other than Route 53, change the name servers for your domain to the set of <code>NameServers</code> that <code>CreateHostedZone</code> returns in <code>DelegationSet</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>(Private hosted zones only) A complex type that contains information about the Amazon VPC that you're associating with this hosted zone.</p>
        /// <p>You can specify only one Amazon VPC when you create a private hosted zone. If you are associating a VPC with a hosted zone with this request, the paramaters <code>VPCId</code> and <code>VPCRegion</code> are also required.</p>
        /// <p>To associate additional Amazon VPCs with the hosted zone, use <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_AssociateVPCWithHostedZone.html">AssociateVPCWithHostedZone</a> after you create a hosted zone.</p>
        pub fn vpc(mut self, input: crate::model::Vpc) -> Self {
            self.inner = self.inner.vpc(input);
            self
        }
        /// <p>(Private hosted zones only) A complex type that contains information about the Amazon VPC that you're associating with this hosted zone.</p>
        /// <p>You can specify only one Amazon VPC when you create a private hosted zone. If you are associating a VPC with a hosted zone with this request, the paramaters <code>VPCId</code> and <code>VPCRegion</code> are also required.</p>
        /// <p>To associate additional Amazon VPCs with the hosted zone, use <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_AssociateVPCWithHostedZone.html">AssociateVPCWithHostedZone</a> after you create a hosted zone.</p>
        pub fn set_vpc(mut self, input: std::option::Option<crate::model::Vpc>) -> Self {
            self.inner = self.inner.set_vpc(input);
            self
        }
        /// <p>A unique string that identifies the request and that allows failed <code>CreateHostedZone</code> requests to be retried without the risk of executing the operation twice. You must use a unique <code>CallerReference</code> string every time you submit a <code>CreateHostedZone</code> request. <code>CallerReference</code> can be any unique string, for example, a date/time stamp.</p>
        pub fn caller_reference(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.caller_reference(input.into());
            self
        }
        /// <p>A unique string that identifies the request and that allows failed <code>CreateHostedZone</code> requests to be retried without the risk of executing the operation twice. You must use a unique <code>CallerReference</code> string every time you submit a <code>CreateHostedZone</code> request. <code>CallerReference</code> can be any unique string, for example, a date/time stamp.</p>
        pub fn set_caller_reference(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_caller_reference(input);
            self
        }
        /// <p>(Optional) A complex type that contains the following optional values:</p>
        /// <ul>
        /// <li> <p>For public and private hosted zones, an optional comment</p> </li>
        /// <li> <p>For private hosted zones, an optional <code>PrivateZone</code> element</p> </li>
        /// </ul>
        /// <p>If you don't specify a comment or the <code>PrivateZone</code> element, omit <code>HostedZoneConfig</code> and the other elements.</p>
        pub fn hosted_zone_config(mut self, input: crate::model::HostedZoneConfig) -> Self {
            self.inner = self.inner.hosted_zone_config(input);
            self
        }
        /// <p>(Optional) A complex type that contains the following optional values:</p>
        /// <ul>
        /// <li> <p>For public and private hosted zones, an optional comment</p> </li>
        /// <li> <p>For private hosted zones, an optional <code>PrivateZone</code> element</p> </li>
        /// </ul>
        /// <p>If you don't specify a comment or the <code>PrivateZone</code> element, omit <code>HostedZoneConfig</code> and the other elements.</p>
        pub fn set_hosted_zone_config(
            mut self,
            input: std::option::Option<crate::model::HostedZoneConfig>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_config(input);
            self
        }
        /// <p>If you want to associate a reusable delegation set with this hosted zone, the ID that Amazon Route 53 assigned to the reusable delegation set when you created it. For more information about reusable delegation sets, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateReusableDelegationSet.html">CreateReusableDelegationSet</a>.</p>
        pub fn delegation_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.delegation_set_id(input.into());
            self
        }
        /// <p>If you want to associate a reusable delegation set with this hosted zone, the ID that Amazon Route 53 assigned to the reusable delegation set when you created it. For more information about reusable delegation sets, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateReusableDelegationSet.html">CreateReusableDelegationSet</a>.</p>
        pub fn set_delegation_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_delegation_set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateKeySigningKey`.
    ///
    /// <p>Creates a new key-signing key (KSK) associated with a hosted zone. You can only have two KSKs per hosted zone.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateKeySigningKey {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_key_signing_key_input::Builder,
    }
    impl CreateKeySigningKey {
        /// Creates a new `CreateKeySigningKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateKeySigningKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateKeySigningKeyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique string that identifies the request.</p>
        pub fn caller_reference(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.caller_reference(input.into());
            self
        }
        /// <p>A unique string that identifies the request.</p>
        pub fn set_caller_reference(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_caller_reference(input);
            self
        }
        /// <p>The unique string (ID) used to identify a hosted zone.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>The unique string (ID) used to identify a hosted zone.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
        /// <p>The Amazon resource name (ARN) for a customer managed key in Key Management Service (KMS). The <code>KeyManagementServiceArn</code> must be unique for each key-signing key (KSK) in a single hosted zone. To see an example of <code>KeyManagementServiceArn</code> that grants the correct permissions for DNSSEC, scroll down to <b>Example</b>. </p>
        /// <p>You must configure the customer managed customer managed key as follows:</p>
        /// <dl>
        /// <dt>
        /// Status
        /// </dt>
        /// <dd>
        /// <p>Enabled</p>
        /// </dd>
        /// <dt>
        /// Key spec
        /// </dt>
        /// <dd>
        /// <p>ECC_NIST_P256</p>
        /// </dd>
        /// <dt>
        /// Key usage
        /// </dt>
        /// <dd>
        /// <p>Sign and verify</p>
        /// </dd>
        /// <dt>
        /// Key policy
        /// </dt>
        /// <dd>
        /// <p>The key policy must give permission for the following actions:</p>
        /// <ul>
        /// <li> <p>DescribeKey</p> </li>
        /// <li> <p>GetPublicKey</p> </li>
        /// <li> <p>Sign</p> </li>
        /// </ul>
        /// <p>The key policy must also include the Amazon Route 53 service in the principal for your account. Specify the following:</p>
        /// <ul>
        /// <li> <p> <code>"Service": "dnssec-route53.amazonaws.com"</code> </p> </li>
        /// </ul>
        /// </dd>
        /// </dl>
        /// <p>For more information about working with a customer managed key in KMS, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html">Key Management Service concepts</a>.</p>
        pub fn key_management_service_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_management_service_arn(input.into());
            self
        }
        /// <p>The Amazon resource name (ARN) for a customer managed key in Key Management Service (KMS). The <code>KeyManagementServiceArn</code> must be unique for each key-signing key (KSK) in a single hosted zone. To see an example of <code>KeyManagementServiceArn</code> that grants the correct permissions for DNSSEC, scroll down to <b>Example</b>. </p>
        /// <p>You must configure the customer managed customer managed key as follows:</p>
        /// <dl>
        /// <dt>
        /// Status
        /// </dt>
        /// <dd>
        /// <p>Enabled</p>
        /// </dd>
        /// <dt>
        /// Key spec
        /// </dt>
        /// <dd>
        /// <p>ECC_NIST_P256</p>
        /// </dd>
        /// <dt>
        /// Key usage
        /// </dt>
        /// <dd>
        /// <p>Sign and verify</p>
        /// </dd>
        /// <dt>
        /// Key policy
        /// </dt>
        /// <dd>
        /// <p>The key policy must give permission for the following actions:</p>
        /// <ul>
        /// <li> <p>DescribeKey</p> </li>
        /// <li> <p>GetPublicKey</p> </li>
        /// <li> <p>Sign</p> </li>
        /// </ul>
        /// <p>The key policy must also include the Amazon Route 53 service in the principal for your account. Specify the following:</p>
        /// <ul>
        /// <li> <p> <code>"Service": "dnssec-route53.amazonaws.com"</code> </p> </li>
        /// </ul>
        /// </dd>
        /// </dl>
        /// <p>For more information about working with a customer managed key in KMS, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html">Key Management Service concepts</a>.</p>
        pub fn set_key_management_service_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_key_management_service_arn(input);
            self
        }
        /// <p>A string used to identify a key-signing key (KSK). <code>Name</code> can include numbers, letters, and underscores (_). <code>Name</code> must be unique for each key-signing key in the same hosted zone.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A string used to identify a key-signing key (KSK). <code>Name</code> can include numbers, letters, and underscores (_). <code>Name</code> must be unique for each key-signing key in the same hosted zone.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A string specifying the initial status of the key-signing key (KSK). You can set the value to <code>ACTIVE</code> or <code>INACTIVE</code>.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.status(input.into());
            self
        }
        /// <p>A string specifying the initial status of the key-signing key (KSK). You can set the value to <code>ACTIVE</code> or <code>INACTIVE</code>.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateQueryLoggingConfig`.
    ///
    /// <p>Creates a configuration for DNS query logging. After you create a query logging configuration, Amazon Route 53 begins to publish log data to an Amazon CloudWatch Logs log group.</p>
    /// <p>DNS query logs contain information about the queries that Route 53 receives for a specified public hosted zone, such as the following:</p>
    /// <ul>
    /// <li> <p>Route 53 edge location that responded to the DNS query</p> </li>
    /// <li> <p>Domain or subdomain that was requested</p> </li>
    /// <li> <p>DNS record type, such as A or AAAA</p> </li>
    /// <li> <p>DNS response code, such as <code>NoError</code> or <code>ServFail</code> </p> </li>
    /// </ul>
    /// <dl>
    /// <dt>
    /// Log Group and Resource Policy
    /// </dt>
    /// <dd>
    /// <p>Before you create a query logging configuration, perform the following operations.</p> <note>
    /// <p>If you create a query logging configuration using the Route 53 console, Route 53 performs these operations automatically.</p>
    /// </note>
    /// <ol>
    /// <li> <p>Create a CloudWatch Logs log group, and make note of the ARN, which you specify when you create a query logging configuration. Note the following:</p>
    /// <ul>
    /// <li> <p>You must create the log group in the us-east-1 region.</p> </li>
    /// <li> <p>You must use the same Amazon Web Services account to create the log group and the hosted zone that you want to configure query logging for.</p> </li>
    /// <li> <p>When you create log groups for query logging, we recommend that you use a consistent prefix, for example:</p> <p> <code>/aws/route53/<i>hosted zone name</i> </code> </p> <p>In the next step, you'll create a resource policy, which controls access to one or more log groups and the associated Amazon Web Services resources, such as Route 53 hosted zones. There's a limit on the number of resource policies that you can create, so we recommend that you use a consistent prefix so you can use the same resource policy for all the log groups that you create for query logging.</p> </li>
    /// </ul> </li>
    /// <li> <p>Create a CloudWatch Logs resource policy, and give it the permissions that Route 53 needs to create log streams and to send query logs to log streams. For the value of <code>Resource</code>, specify the ARN for the log group that you created in the previous step. To use the same resource policy for all the CloudWatch Logs log groups that you created for query logging configurations, replace the hosted zone name with <code>*</code>, for example:</p> <p> <code>arn:aws:logs:us-east-1:123412341234:log-group:/aws/route53/*</code> </p> <note>
    /// <p>You can't use the CloudWatch console to create or edit a resource policy. You must use the CloudWatch API, one of the Amazon Web Services SDKs, or the CLI.</p>
    /// </note> </li>
    /// </ol>
    /// </dd>
    /// <dt>
    /// Log Streams and Edge Locations
    /// </dt>
    /// <dd>
    /// <p>When Route 53 finishes creating the configuration for DNS query logging, it does the following:</p>
    /// <ul>
    /// <li> <p>Creates a log stream for an edge location the first time that the edge location responds to DNS queries for the specified hosted zone. That log stream is used to log all queries that Route 53 responds to for that edge location.</p> </li>
    /// <li> <p>Begins to send query logs to the applicable log stream.</p> </li>
    /// </ul>
    /// <p>The name of each log stream is in the following format:</p>
    /// <p> <code> <i>hosted zone ID</i>/<i>edge location code</i> </code> </p>
    /// <p>The edge location code is a three-letter code and an arbitrarily assigned number, for example, DFW3. The three-letter code typically corresponds with the International Air Transport Association airport code for an airport near the edge location. (These abbreviations might change in the future.) For a list of edge locations, see "The Route 53 Global Network" on the <a href="http://aws.amazon.com/route53/details/">Route 53 Product Details</a> page.</p>
    /// </dd>
    /// <dt>
    /// Queries That Are Logged
    /// </dt>
    /// <dd>
    /// <p>Query logs contain only the queries that DNS resolvers forward to Route 53. If a DNS resolver has already cached the response to a query (such as the IP address for a load balancer for example.com), the resolver will continue to return the cached response. It doesn't forward another query to Route 53 until the TTL for the corresponding resource record set expires. Depending on how many DNS queries are submitted for a resource record set, and depending on the TTL for that resource record set, query logs might contain information about only one query out of every several thousand queries that are submitted to DNS. For more information about how DNS works, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/welcome-dns-service.html">Routing Internet Traffic to Your Website or Web Application</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
    /// </dd>
    /// <dt>
    /// Log File Format
    /// </dt>
    /// <dd>
    /// <p>For a list of the values in each query log and the format of each value, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html">Logging DNS Queries</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
    /// </dd>
    /// <dt>
    /// Pricing
    /// </dt>
    /// <dd>
    /// <p>For information about charges for query logs, see <a href="http://aws.amazon.com/cloudwatch/pricing/">Amazon CloudWatch Pricing</a>.</p>
    /// </dd>
    /// <dt>
    /// How to Stop Logging
    /// </dt>
    /// <dd>
    /// <p>If you want Route 53 to stop sending query logs to CloudWatch Logs, delete the query logging configuration. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteQueryLoggingConfig.html">DeleteQueryLoggingConfig</a>.</p>
    /// </dd>
    /// </dl>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateQueryLoggingConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_query_logging_config_input::Builder,
    }
    impl CreateQueryLoggingConfig {
        /// Creates a new `CreateQueryLoggingConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateQueryLoggingConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateQueryLoggingConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the hosted zone that you want to log queries for. You can log queries only for public hosted zones.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>The ID of the hosted zone that you want to log queries for. You can log queries only for public hosted zones.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the log group that you want to Amazon Route 53 to send query logs to. This is the format of the ARN:</p>
        /// <p>arn:aws:logs:<i>region</i>:<i>account-id</i>:log-group:<i>log_group_name</i> </p>
        /// <p>To get the ARN for a log group, you can use the CloudWatch console, the <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeLogGroups.html">DescribeLogGroups</a> API action, the <a href="https://docs.aws.amazon.com/cli/latest/reference/logs/describe-log-groups.html">describe-log-groups</a> command, or the applicable command in one of the Amazon Web Services SDKs.</p>
        pub fn cloud_watch_logs_log_group_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.cloud_watch_logs_log_group_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the log group that you want to Amazon Route 53 to send query logs to. This is the format of the ARN:</p>
        /// <p>arn:aws:logs:<i>region</i>:<i>account-id</i>:log-group:<i>log_group_name</i> </p>
        /// <p>To get the ARN for a log group, you can use the CloudWatch console, the <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeLogGroups.html">DescribeLogGroups</a> API action, the <a href="https://docs.aws.amazon.com/cli/latest/reference/logs/describe-log-groups.html">describe-log-groups</a> command, or the applicable command in one of the Amazon Web Services SDKs.</p>
        pub fn set_cloud_watch_logs_log_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cloud_watch_logs_log_group_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateReusableDelegationSet`.
    ///
    /// <p>Creates a delegation set (a group of four name servers) that can be reused by multiple hosted zones that were created by the same Amazon Web Services account. </p>
    /// <p>You can also create a reusable delegation set that uses the four name servers that are associated with an existing hosted zone. Specify the hosted zone ID in the <code>CreateReusableDelegationSet</code> request.</p> <note>
    /// <p>You can't associate a reusable delegation set with a private hosted zone.</p>
    /// </note>
    /// <p>For information about using a reusable delegation set to configure white label name servers, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/white-label-name-servers.html">Configuring White Label Name Servers</a>.</p>
    /// <p>The process for migrating existing hosted zones to use a reusable delegation set is comparable to the process for configuring white label name servers. You need to perform the following steps:</p>
    /// <ol>
    /// <li> <p>Create a reusable delegation set.</p> </li>
    /// <li> <p>Recreate hosted zones, and reduce the TTL to 60 seconds or less.</p> </li>
    /// <li> <p>Recreate resource record sets in the new hosted zones.</p> </li>
    /// <li> <p>Change the registrar's name servers to use the name servers for the new hosted zones.</p> </li>
    /// <li> <p>Monitor traffic for the website or application.</p> </li>
    /// <li> <p>Change TTLs back to their original values.</p> </li>
    /// </ol>
    /// <p>If you want to migrate existing hosted zones to use a reusable delegation set, the existing hosted zones can't use any of the name servers that are assigned to the reusable delegation set. If one or more hosted zones do use one or more name servers that are assigned to the reusable delegation set, you can do one of the following:</p>
    /// <ul>
    /// <li> <p>For small numbers of hosted zones—up to a few hundred—it's relatively easy to create reusable delegation sets until you get one that has four name servers that don't overlap with any of the name servers in your hosted zones.</p> </li>
    /// <li> <p>For larger numbers of hosted zones, the easiest solution is to use more than one reusable delegation set.</p> </li>
    /// <li> <p>For larger numbers of hosted zones, you can also migrate hosted zones that have overlapping name servers to hosted zones that don't have overlapping name servers, then migrate the hosted zones again to use the reusable delegation set.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateReusableDelegationSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_reusable_delegation_set_input::Builder,
    }
    impl CreateReusableDelegationSet {
        /// Creates a new `CreateReusableDelegationSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateReusableDelegationSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateReusableDelegationSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique string that identifies the request, and that allows you to retry failed <code>CreateReusableDelegationSet</code> requests without the risk of executing the operation twice. You must use a unique <code>CallerReference</code> string every time you submit a <code>CreateReusableDelegationSet</code> request. <code>CallerReference</code> can be any unique string, for example a date/time stamp.</p>
        pub fn caller_reference(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.caller_reference(input.into());
            self
        }
        /// <p>A unique string that identifies the request, and that allows you to retry failed <code>CreateReusableDelegationSet</code> requests without the risk of executing the operation twice. You must use a unique <code>CallerReference</code> string every time you submit a <code>CreateReusableDelegationSet</code> request. <code>CallerReference</code> can be any unique string, for example a date/time stamp.</p>
        pub fn set_caller_reference(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_caller_reference(input);
            self
        }
        /// <p>If you want to mark the delegation set for an existing hosted zone as reusable, the ID for that hosted zone.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>If you want to mark the delegation set for an existing hosted zone as reusable, the ID for that hosted zone.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTrafficPolicy`.
    ///
    /// <p>Creates a traffic policy, which you use to create multiple DNS resource record sets for one domain name (such as example.com) or one subdomain name (such as www.example.com).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTrafficPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_traffic_policy_input::Builder,
    }
    impl CreateTrafficPolicy {
        /// Creates a new `CreateTrafficPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTrafficPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTrafficPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the traffic policy.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the traffic policy.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The definition of this traffic policy in JSON format. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/api-policies-traffic-policy-document-format.html">Traffic Policy Document Format</a>.</p>
        pub fn document(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document(input.into());
            self
        }
        /// <p>The definition of this traffic policy in JSON format. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/api-policies-traffic-policy-document-format.html">Traffic Policy Document Format</a>.</p>
        pub fn set_document(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_document(input);
            self
        }
        /// <p>(Optional) Any comments that you want to include about the traffic policy.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.comment(input.into());
            self
        }
        /// <p>(Optional) Any comments that you want to include about the traffic policy.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_comment(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTrafficPolicyInstance`.
    ///
    /// <p>Creates resource record sets in a specified hosted zone based on the settings in a specified traffic policy version. In addition, <code>CreateTrafficPolicyInstance</code> associates the resource record sets with a specified domain name (such as example.com) or subdomain name (such as www.example.com). Amazon Route 53 responds to DNS queries for the domain or subdomain name by using the resource record sets that <code>CreateTrafficPolicyInstance</code> created.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTrafficPolicyInstance {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_traffic_policy_instance_input::Builder,
    }
    impl CreateTrafficPolicyInstance {
        /// Creates a new `CreateTrafficPolicyInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTrafficPolicyInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTrafficPolicyInstanceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the hosted zone that you want Amazon Route 53 to create resource record sets in by using the configuration in a traffic policy.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>The ID of the hosted zone that you want Amazon Route 53 to create resource record sets in by using the configuration in a traffic policy.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
        /// <p>The domain name (such as example.com) or subdomain name (such as www.example.com) for which Amazon Route 53 responds to DNS queries by using the resource record sets that Route 53 creates for this traffic policy instance.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The domain name (such as example.com) or subdomain name (such as www.example.com) for which Amazon Route 53 responds to DNS queries by using the resource record sets that Route 53 creates for this traffic policy instance.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>(Optional) The TTL that you want Amazon Route 53 to assign to all of the resource record sets that it creates in the specified hosted zone.</p>
        pub fn ttl(mut self, input: i64) -> Self {
            self.inner = self.inner.ttl(input);
            self
        }
        /// <p>(Optional) The TTL that you want Amazon Route 53 to assign to all of the resource record sets that it creates in the specified hosted zone.</p>
        pub fn set_ttl(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_ttl(input);
            self
        }
        /// <p>The ID of the traffic policy that you want to use to create resource record sets in the specified hosted zone.</p>
        pub fn traffic_policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.traffic_policy_id(input.into());
            self
        }
        /// <p>The ID of the traffic policy that you want to use to create resource record sets in the specified hosted zone.</p>
        pub fn set_traffic_policy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_traffic_policy_id(input);
            self
        }
        /// <p>The version of the traffic policy that you want to use to create resource record sets in the specified hosted zone.</p>
        pub fn traffic_policy_version(mut self, input: i32) -> Self {
            self.inner = self.inner.traffic_policy_version(input);
            self
        }
        /// <p>The version of the traffic policy that you want to use to create resource record sets in the specified hosted zone.</p>
        pub fn set_traffic_policy_version(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_traffic_policy_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTrafficPolicyVersion`.
    ///
    /// <p>Creates a new version of an existing traffic policy. When you create a new version of a traffic policy, you specify the ID of the traffic policy that you want to update and a JSON-formatted document that describes the new version. You use traffic policies to create multiple DNS resource record sets for one domain name (such as example.com) or one subdomain name (such as www.example.com). You can create a maximum of 1000 versions of a traffic policy. If you reach the limit and need to create another version, you'll need to start a new traffic policy.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTrafficPolicyVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_traffic_policy_version_input::Builder,
    }
    impl CreateTrafficPolicyVersion {
        /// Creates a new `CreateTrafficPolicyVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTrafficPolicyVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTrafficPolicyVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the traffic policy for which you want to create a new version.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the traffic policy for which you want to create a new version.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The definition of this version of the traffic policy, in JSON format. You specified the JSON in the <code>CreateTrafficPolicyVersion</code> request. For more information about the JSON format, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateTrafficPolicy.html">CreateTrafficPolicy</a>.</p>
        pub fn document(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document(input.into());
            self
        }
        /// <p>The definition of this version of the traffic policy, in JSON format. You specified the JSON in the <code>CreateTrafficPolicyVersion</code> request. For more information about the JSON format, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateTrafficPolicy.html">CreateTrafficPolicy</a>.</p>
        pub fn set_document(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_document(input);
            self
        }
        /// <p>The comment that you specified in the <code>CreateTrafficPolicyVersion</code> request, if any.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.comment(input.into());
            self
        }
        /// <p>The comment that you specified in the <code>CreateTrafficPolicyVersion</code> request, if any.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_comment(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateVPCAssociationAuthorization`.
    ///
    /// <p>Authorizes the Amazon Web Services account that created a specified VPC to submit an <code>AssociateVPCWithHostedZone</code> request to associate the VPC with a specified hosted zone that was created by a different account. To submit a <code>CreateVPCAssociationAuthorization</code> request, you must use the account that created the hosted zone. After you authorize the association, use the account that created the VPC to submit an <code>AssociateVPCWithHostedZone</code> request.</p> <note>
    /// <p>If you want to associate multiple VPCs that you created by using one account with a hosted zone that you created by using a different account, you must submit one authorization request for each VPC.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateVPCAssociationAuthorization {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_vpc_association_authorization_input::Builder,
    }
    impl CreateVPCAssociationAuthorization {
        /// Creates a new `CreateVPCAssociationAuthorization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateVpcAssociationAuthorizationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateVPCAssociationAuthorizationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the private hosted zone that you want to authorize associating a VPC with.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>The ID of the private hosted zone that you want to authorize associating a VPC with.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
        /// <p>A complex type that contains the VPC ID and region for the VPC that you want to authorize associating with your hosted zone.</p>
        pub fn vpc(mut self, input: crate::model::Vpc) -> Self {
            self.inner = self.inner.vpc(input);
            self
        }
        /// <p>A complex type that contains the VPC ID and region for the VPC that you want to authorize associating with your hosted zone.</p>
        pub fn set_vpc(mut self, input: std::option::Option<crate::model::Vpc>) -> Self {
            self.inner = self.inner.set_vpc(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeactivateKeySigningKey`.
    ///
    /// <p>Deactivates a key-signing key (KSK) so that it will not be used for signing by DNSSEC. This operation changes the KSK status to <code>INACTIVE</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeactivateKeySigningKey {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::deactivate_key_signing_key_input::Builder,
    }
    impl DeactivateKeySigningKey {
        /// Creates a new `DeactivateKeySigningKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeactivateKeySigningKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeactivateKeySigningKeyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique string used to identify a hosted zone.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>A unique string used to identify a hosted zone.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
        /// <p>A string used to identify a key-signing key (KSK).</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A string used to identify a key-signing key (KSK).</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteHealthCheck`.
    ///
    /// <p>Deletes a health check.</p> <important>
    /// <p>Amazon Route 53 does not prevent you from deleting a health check even if the health check is associated with one or more resource record sets. If you delete a health check and you don't update the associated resource record sets, the future status of the health check can't be predicted and may change. This will affect the routing of DNS queries for your DNS failover configuration. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/health-checks-creating-deleting.html#health-checks-deleting.html">Replacing and Deleting Health Checks</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
    /// </important>
    /// <p>If you're using Cloud Map and you configured Cloud Map to create a Route 53 health check when you register an instance, you can't use the Route 53 <code>DeleteHealthCheck</code> command to delete the health check. The health check is deleted automatically when you deregister the instance; there can be a delay of several hours before the health check is deleted from Route 53. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteHealthCheck {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_health_check_input::Builder,
    }
    impl DeleteHealthCheck {
        /// Creates a new `DeleteHealthCheck`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteHealthCheckOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteHealthCheckError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the health check that you want to delete.</p>
        pub fn health_check_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.health_check_id(input.into());
            self
        }
        /// <p>The ID of the health check that you want to delete.</p>
        pub fn set_health_check_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_health_check_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteHostedZone`.
    ///
    /// <p>Deletes a hosted zone.</p>
    /// <p>If the hosted zone was created by another service, such as Cloud Map, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DeleteHostedZone.html#delete-public-hosted-zone-created-by-another-service">Deleting Public Hosted Zones That Were Created by Another Service</a> in the <i>Amazon Route 53 Developer Guide</i> for information about how to delete it. (The process is the same for public and private hosted zones that were created by another service.)</p>
    /// <p>If you want to keep your domain registration but you want to stop routing internet traffic to your website or web application, we recommend that you delete resource record sets in the hosted zone instead of deleting the hosted zone.</p> <important>
    /// <p>If you delete a hosted zone, you can't undelete it. You must create a new hosted zone and update the name servers for your domain registration, which can require up to 48 hours to take effect. (If you delegated responsibility for a subdomain to a hosted zone and you delete the child hosted zone, you must update the name servers in the parent hosted zone.) In addition, if you delete a hosted zone, someone could hijack the domain and route traffic to their own resources using your domain name.</p>
    /// </important>
    /// <p>If you want to avoid the monthly charge for the hosted zone, you can transfer DNS service for the domain to a free DNS service. When you transfer DNS service, you have to update the name servers for the domain registration. If the domain is registered with Route 53, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateDomainNameservers.html">UpdateDomainNameservers</a> for information about how to replace Route 53 name servers with name servers for the new DNS service. If the domain is registered with another registrar, use the method provided by the registrar to update name servers for the domain registration. For more information, perform an internet search on "free DNS service."</p>
    /// <p>You can delete a hosted zone only if it contains only the default SOA record and NS resource record sets. If the hosted zone contains other resource record sets, you must delete them before you can delete the hosted zone. If you try to delete a hosted zone that contains other resource record sets, the request fails, and Route 53 returns a <code>HostedZoneNotEmpty</code> error. For information about deleting records from your hosted zone, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ChangeResourceRecordSets.html">ChangeResourceRecordSets</a>.</p>
    /// <p>To verify that the hosted zone has been deleted, do one of the following:</p>
    /// <ul>
    /// <li> <p>Use the <code>GetHostedZone</code> action to request information about the hosted zone.</p> </li>
    /// <li> <p>Use the <code>ListHostedZones</code> action to get a list of the hosted zones associated with the current Amazon Web Services account.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteHostedZone {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_hosted_zone_input::Builder,
    }
    impl DeleteHostedZone {
        /// Creates a new `DeleteHostedZone`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteHostedZoneOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteHostedZoneError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the hosted zone you want to delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the hosted zone you want to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteKeySigningKey`.
    ///
    /// <p>Deletes a key-signing key (KSK). Before you can delete a KSK, you must deactivate it. The KSK must be deactivated before you can delete it regardless of whether the hosted zone is enabled for DNSSEC signing.</p>
    /// <p>You can use <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeactivateKeySigningKey.html">DeactivateKeySigningKey</a> to deactivate the key before you delete it.</p>
    /// <p>Use <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetDNSSEC.html">GetDNSSEC</a> to verify that the KSK is in an <code>INACTIVE</code> status.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteKeySigningKey {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_key_signing_key_input::Builder,
    }
    impl DeleteKeySigningKey {
        /// Creates a new `DeleteKeySigningKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteKeySigningKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteKeySigningKeyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique string used to identify a hosted zone.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>A unique string used to identify a hosted zone.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
        /// <p>A string used to identify a key-signing key (KSK).</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A string used to identify a key-signing key (KSK).</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteQueryLoggingConfig`.
    ///
    /// <p>Deletes a configuration for DNS query logging. If you delete a configuration, Amazon Route 53 stops sending query logs to CloudWatch Logs. Route 53 doesn't delete any logs that are already in CloudWatch Logs.</p>
    /// <p>For more information about DNS query logs, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateQueryLoggingConfig.html">CreateQueryLoggingConfig</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteQueryLoggingConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_query_logging_config_input::Builder,
    }
    impl DeleteQueryLoggingConfig {
        /// Creates a new `DeleteQueryLoggingConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteQueryLoggingConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteQueryLoggingConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the configuration that you want to delete. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the configuration that you want to delete. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteReusableDelegationSet`.
    ///
    /// <p>Deletes a reusable delegation set.</p> <important>
    /// <p>You can delete a reusable delegation set only if it isn't associated with any hosted zones.</p>
    /// </important>
    /// <p>To verify that the reusable delegation set is not associated with any hosted zones, submit a <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetReusableDelegationSet.html">GetReusableDelegationSet</a> request and specify the ID of the reusable delegation set that you want to delete.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteReusableDelegationSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_reusable_delegation_set_input::Builder,
    }
    impl DeleteReusableDelegationSet {
        /// Creates a new `DeleteReusableDelegationSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteReusableDelegationSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteReusableDelegationSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the reusable delegation set that you want to delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the reusable delegation set that you want to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTrafficPolicy`.
    ///
    /// <p>Deletes a traffic policy.</p>
    /// <p>When you delete a traffic policy, Route 53 sets a flag on the policy to indicate that it has been deleted. However, Route 53 never fully deletes the traffic policy. Note the following:</p>
    /// <ul>
    /// <li> <p>Deleted traffic policies aren't listed if you run <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListTrafficPolicies.html">ListTrafficPolicies</a>.</p> </li>
    /// <li> <p> There's no way to get a list of deleted policies.</p> </li>
    /// <li> <p>If you retain the ID of the policy, you can get information about the policy, including the traffic policy document, by running <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetTrafficPolicy.html">GetTrafficPolicy</a>.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTrafficPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_traffic_policy_input::Builder,
    }
    impl DeleteTrafficPolicy {
        /// Creates a new `DeleteTrafficPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTrafficPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTrafficPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the traffic policy that you want to delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the traffic policy that you want to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The version number of the traffic policy that you want to delete.</p>
        pub fn version(mut self, input: i32) -> Self {
            self.inner = self.inner.version(input);
            self
        }
        /// <p>The version number of the traffic policy that you want to delete.</p>
        pub fn set_version(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTrafficPolicyInstance`.
    ///
    /// <p>Deletes a traffic policy instance and all of the resource record sets that Amazon Route 53 created when you created the instance.</p> <note>
    /// <p>In the Route 53 console, traffic policy instances are known as policy records.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTrafficPolicyInstance {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_traffic_policy_instance_input::Builder,
    }
    impl DeleteTrafficPolicyInstance {
        /// Creates a new `DeleteTrafficPolicyInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTrafficPolicyInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTrafficPolicyInstanceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the traffic policy instance that you want to delete. </p> <important>
        /// <p>When you delete a traffic policy instance, Amazon Route 53 also deletes all of the resource record sets that were created when you created the traffic policy instance.</p>
        /// </important>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the traffic policy instance that you want to delete. </p> <important>
        /// <p>When you delete a traffic policy instance, Amazon Route 53 also deletes all of the resource record sets that were created when you created the traffic policy instance.</p>
        /// </important>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVPCAssociationAuthorization`.
    ///
    /// <p>Removes authorization to submit an <code>AssociateVPCWithHostedZone</code> request to associate a specified VPC with a hosted zone that was created by a different account. You must use the account that created the hosted zone to submit a <code>DeleteVPCAssociationAuthorization</code> request.</p> <important>
    /// <p>Sending this request only prevents the Amazon Web Services account that created the VPC from associating the VPC with the Amazon Route 53 hosted zone in the future. If the VPC is already associated with the hosted zone, <code>DeleteVPCAssociationAuthorization</code> won't disassociate the VPC from the hosted zone. If you want to delete an existing association, use <code>DisassociateVPCFromHostedZone</code>.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteVPCAssociationAuthorization {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_vpc_association_authorization_input::Builder,
    }
    impl DeleteVPCAssociationAuthorization {
        /// Creates a new `DeleteVPCAssociationAuthorization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVpcAssociationAuthorizationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteVPCAssociationAuthorizationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>When removing authorization to associate a VPC that was created by one Amazon Web Services account with a hosted zone that was created with a different Amazon Web Services account, the ID of the hosted zone.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>When removing authorization to associate a VPC that was created by one Amazon Web Services account with a hosted zone that was created with a different Amazon Web Services account, the ID of the hosted zone.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
        /// <p>When removing authorization to associate a VPC that was created by one Amazon Web Services account with a hosted zone that was created with a different Amazon Web Services account, a complex type that includes the ID and region of the VPC.</p>
        pub fn vpc(mut self, input: crate::model::Vpc) -> Self {
            self.inner = self.inner.vpc(input);
            self
        }
        /// <p>When removing authorization to associate a VPC that was created by one Amazon Web Services account with a hosted zone that was created with a different Amazon Web Services account, a complex type that includes the ID and region of the VPC.</p>
        pub fn set_vpc(mut self, input: std::option::Option<crate::model::Vpc>) -> Self {
            self.inner = self.inner.set_vpc(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableHostedZoneDNSSEC`.
    ///
    /// <p>Disables DNSSEC signing in a specific hosted zone. This action does not deactivate any key-signing keys (KSKs) that are active in the hosted zone.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisableHostedZoneDNSSEC {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disable_hosted_zone_dnssec_input::Builder,
    }
    impl DisableHostedZoneDNSSEC {
        /// Creates a new `DisableHostedZoneDNSSEC`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableHostedZoneDnssecOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableHostedZoneDNSSECError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique string used to identify a hosted zone.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>A unique string used to identify a hosted zone.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateVPCFromHostedZone`.
    ///
    /// <p>Disassociates an Amazon Virtual Private Cloud (Amazon VPC) from an Amazon Route 53 private hosted zone. Note the following:</p>
    /// <ul>
    /// <li> <p>You can't disassociate the last Amazon VPC from a private hosted zone.</p> </li>
    /// <li> <p>You can't convert a private hosted zone into a public hosted zone.</p> </li>
    /// <li> <p>You can submit a <code>DisassociateVPCFromHostedZone</code> request using either the account that created the hosted zone or the account that created the Amazon VPC.</p> </li>
    /// <li> <p>Some services, such as Cloud Map and Amazon Elastic File System (Amazon EFS) automatically create hosted zones and associate VPCs with the hosted zones. A service can create a hosted zone using your account or using its own account. You can disassociate a VPC from a hosted zone only if the service created the hosted zone using your account.</p> <p>When you run <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListHostedZonesByVPC.html">DisassociateVPCFromHostedZone</a>, if the hosted zone has a value for <code>OwningAccount</code>, you can use <code>DisassociateVPCFromHostedZone</code>. If the hosted zone has a value for <code>OwningService</code>, you can't use <code>DisassociateVPCFromHostedZone</code>.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateVPCFromHostedZone {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_vpc_from_hosted_zone_input::Builder,
    }
    impl DisassociateVPCFromHostedZone {
        /// Creates a new `DisassociateVPCFromHostedZone`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateVpcFromHostedZoneOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateVPCFromHostedZoneError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the private hosted zone that you want to disassociate a VPC from.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>The ID of the private hosted zone that you want to disassociate a VPC from.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
        /// <p>A complex type that contains information about the VPC that you're disassociating from the specified hosted zone.</p>
        pub fn vpc(mut self, input: crate::model::Vpc) -> Self {
            self.inner = self.inner.vpc(input);
            self
        }
        /// <p>A complex type that contains information about the VPC that you're disassociating from the specified hosted zone.</p>
        pub fn set_vpc(mut self, input: std::option::Option<crate::model::Vpc>) -> Self {
            self.inner = self.inner.set_vpc(input);
            self
        }
        /// <p> <i>Optional:</i> A comment about the disassociation request.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.comment(input.into());
            self
        }
        /// <p> <i>Optional:</i> A comment about the disassociation request.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_comment(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableHostedZoneDNSSEC`.
    ///
    /// <p>Enables DNSSEC signing in a specific hosted zone.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct EnableHostedZoneDNSSEC {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::enable_hosted_zone_dnssec_input::Builder,
    }
    impl EnableHostedZoneDNSSEC {
        /// Creates a new `EnableHostedZoneDNSSEC`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableHostedZoneDnssecOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableHostedZoneDNSSECError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique string used to identify a hosted zone.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>A unique string used to identify a hosted zone.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccountLimit`.
    ///
    /// <p>Gets the specified limit for the current account, for example, the maximum number of health checks that you can create using the account.</p>
    /// <p>For the default limit, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a> in the <i>Amazon Route 53 Developer Guide</i>. To request a higher limit, <a href="https://console.aws.amazon.com/support/home#/case/create?issueType=service-limit-increase&amp;limitType=service-code-route53">open a case</a>.</p> <note>
    /// <p>You can also view account limits in Amazon Web Services Trusted Advisor. Sign in to the Amazon Web Services Management Console and open the Trusted Advisor console at <a href="https://console.aws.amazon.com/trustedadvisor">https://console.aws.amazon.com/trustedadvisor/</a>. Then choose <b>Service limits</b> in the navigation pane.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAccountLimit {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_account_limit_input::Builder,
    }
    impl GetAccountLimit {
        /// Creates a new `GetAccountLimit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccountLimitOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAccountLimitError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The limit that you want to get. Valid values include the following:</p>
        /// <ul>
        /// <li> <p> <b>MAX_HEALTH_CHECKS_BY_OWNER</b>: The maximum number of health checks that you can create using the current account.</p> </li>
        /// <li> <p> <b>MAX_HOSTED_ZONES_BY_OWNER</b>: The maximum number of hosted zones that you can create using the current account.</p> </li>
        /// <li> <p> <b>MAX_REUSABLE_DELEGATION_SETS_BY_OWNER</b>: The maximum number of reusable delegation sets that you can create using the current account.</p> </li>
        /// <li> <p> <b>MAX_TRAFFIC_POLICIES_BY_OWNER</b>: The maximum number of traffic policies that you can create using the current account.</p> </li>
        /// <li> <p> <b>MAX_TRAFFIC_POLICY_INSTANCES_BY_OWNER</b>: The maximum number of traffic policy instances that you can create using the current account. (Traffic policy instances are referred to as traffic flow policy records in the Amazon Route 53 console.)</p> </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::AccountLimitType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The limit that you want to get. Valid values include the following:</p>
        /// <ul>
        /// <li> <p> <b>MAX_HEALTH_CHECKS_BY_OWNER</b>: The maximum number of health checks that you can create using the current account.</p> </li>
        /// <li> <p> <b>MAX_HOSTED_ZONES_BY_OWNER</b>: The maximum number of hosted zones that you can create using the current account.</p> </li>
        /// <li> <p> <b>MAX_REUSABLE_DELEGATION_SETS_BY_OWNER</b>: The maximum number of reusable delegation sets that you can create using the current account.</p> </li>
        /// <li> <p> <b>MAX_TRAFFIC_POLICIES_BY_OWNER</b>: The maximum number of traffic policies that you can create using the current account.</p> </li>
        /// <li> <p> <b>MAX_TRAFFIC_POLICY_INSTANCES_BY_OWNER</b>: The maximum number of traffic policy instances that you can create using the current account. (Traffic policy instances are referred to as traffic flow policy records in the Amazon Route 53 console.)</p> </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::AccountLimitType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetChange`.
    ///
    /// <p>Returns the current status of a change batch request. The status is one of the following values:</p>
    /// <ul>
    /// <li> <p> <code>PENDING</code> indicates that the changes in this request have not propagated to all Amazon Route 53 DNS servers. This is the initial status of all change batch requests.</p> </li>
    /// <li> <p> <code>INSYNC</code> indicates that the changes have propagated to all Route 53 DNS servers. </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetChange {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_change_input::Builder,
    }
    impl GetChange {
        /// Creates a new `GetChange`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetChangeOutput,
            aws_smithy_http::result::SdkError<crate::error::GetChangeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the change batch request. The value that you specify here is the value that <code>ChangeResourceRecordSets</code> returned in the <code>Id</code> element when you submitted the request.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the change batch request. The value that you specify here is the value that <code>ChangeResourceRecordSets</code> returned in the <code>Id</code> element when you submitted the request.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCheckerIpRanges`.
    ///
    /// <p>Route 53 does not perform authorization for this API because it retrieves information that is already available to the public.</p> <important>
    /// <p> <code>GetCheckerIpRanges</code> still works, but we recommend that you download ip-ranges.json, which includes IP address ranges for all Amazon Web Services services. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/route-53-ip-addresses.html">IP Address Ranges of Amazon Route 53 Servers</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCheckerIpRanges {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_checker_ip_ranges_input::Builder,
    }
    impl GetCheckerIpRanges {
        /// Creates a new `GetCheckerIpRanges`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCheckerIpRangesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCheckerIpRangesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetDNSSEC`.
    ///
    /// <p>Returns information about DNSSEC for a specific hosted zone, including the key-signing keys (KSKs) in the hosted zone.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDNSSEC {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_dnssec_input::Builder,
    }
    impl GetDNSSEC {
        /// Creates a new `GetDNSSEC`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDnssecOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDNSSECError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique string used to identify a hosted zone.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>A unique string used to identify a hosted zone.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetGeoLocation`.
    ///
    /// <p>Gets information about whether a specified geographic location is supported for Amazon Route 53 geolocation resource record sets.</p>
    /// <p>Route 53 does not perform authorization for this API because it retrieves information that is already available to the public.</p>
    /// <p>Use the following syntax to determine whether a continent is supported for geolocation:</p>
    /// <p> <code>GET /2013-04-01/geolocation?continentcode=<i>two-letter abbreviation for a continent</i> </code> </p>
    /// <p>Use the following syntax to determine whether a country is supported for geolocation:</p>
    /// <p> <code>GET /2013-04-01/geolocation?countrycode=<i>two-character country code</i> </code> </p>
    /// <p>Use the following syntax to determine whether a subdivision of a country is supported for geolocation:</p>
    /// <p> <code>GET /2013-04-01/geolocation?countrycode=<i>two-character country code</i>&amp;subdivisioncode=<i>subdivision code</i> </code> </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetGeoLocation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_geo_location_input::Builder,
    }
    impl GetGeoLocation {
        /// Creates a new `GetGeoLocation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetGeoLocationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetGeoLocationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>For geolocation resource record sets, a two-letter abbreviation that identifies a continent. Amazon Route 53 supports the following continent codes:</p>
        /// <ul>
        /// <li> <p> <b>AF</b>: Africa</p> </li>
        /// <li> <p> <b>AN</b>: Antarctica</p> </li>
        /// <li> <p> <b>AS</b>: Asia</p> </li>
        /// <li> <p> <b>EU</b>: Europe</p> </li>
        /// <li> <p> <b>OC</b>: Oceania</p> </li>
        /// <li> <p> <b>NA</b>: North America</p> </li>
        /// <li> <p> <b>SA</b>: South America</p> </li>
        /// </ul>
        pub fn continent_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.continent_code(input.into());
            self
        }
        /// <p>For geolocation resource record sets, a two-letter abbreviation that identifies a continent. Amazon Route 53 supports the following continent codes:</p>
        /// <ul>
        /// <li> <p> <b>AF</b>: Africa</p> </li>
        /// <li> <p> <b>AN</b>: Antarctica</p> </li>
        /// <li> <p> <b>AS</b>: Asia</p> </li>
        /// <li> <p> <b>EU</b>: Europe</p> </li>
        /// <li> <p> <b>OC</b>: Oceania</p> </li>
        /// <li> <p> <b>NA</b>: North America</p> </li>
        /// <li> <p> <b>SA</b>: South America</p> </li>
        /// </ul>
        pub fn set_continent_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_continent_code(input);
            self
        }
        /// <p>Amazon Route 53 uses the two-letter country codes that are specified in <a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO standard 3166-1 alpha-2</a>.</p>
        pub fn country_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.country_code(input.into());
            self
        }
        /// <p>Amazon Route 53 uses the two-letter country codes that are specified in <a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO standard 3166-1 alpha-2</a>.</p>
        pub fn set_country_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_country_code(input);
            self
        }
        /// <p>The code for the subdivision, such as a particular state within the United States. For a list of US state abbreviations, see <a href="https://pe.usps.com/text/pub28/28apb.htm">Appendix B: Two–Letter State and Possession Abbreviations</a> on the United States Postal Service website. For a list of all supported subdivision codes, use the <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListGeoLocations.html">ListGeoLocations</a> API.</p>
        pub fn subdivision_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subdivision_code(input.into());
            self
        }
        /// <p>The code for the subdivision, such as a particular state within the United States. For a list of US state abbreviations, see <a href="https://pe.usps.com/text/pub28/28apb.htm">Appendix B: Two–Letter State and Possession Abbreviations</a> on the United States Postal Service website. For a list of all supported subdivision codes, use the <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListGeoLocations.html">ListGeoLocations</a> API.</p>
        pub fn set_subdivision_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subdivision_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetHealthCheck`.
    ///
    /// <p>Gets information about a specified health check.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetHealthCheck {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_health_check_input::Builder,
    }
    impl GetHealthCheck {
        /// Creates a new `GetHealthCheck`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetHealthCheckOutput,
            aws_smithy_http::result::SdkError<crate::error::GetHealthCheckError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier that Amazon Route 53 assigned to the health check when you created it. When you add or update a resource record set, you use this value to specify which health check to use. The value can be up to 64 characters long.</p>
        pub fn health_check_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.health_check_id(input.into());
            self
        }
        /// <p>The identifier that Amazon Route 53 assigned to the health check when you created it. When you add or update a resource record set, you use this value to specify which health check to use. The value can be up to 64 characters long.</p>
        pub fn set_health_check_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_health_check_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetHealthCheckCount`.
    ///
    /// <p>Retrieves the number of health checks that are associated with the current Amazon Web Services account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetHealthCheckCount {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_health_check_count_input::Builder,
    }
    impl GetHealthCheckCount {
        /// Creates a new `GetHealthCheckCount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetHealthCheckCountOutput,
            aws_smithy_http::result::SdkError<crate::error::GetHealthCheckCountError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetHealthCheckLastFailureReason`.
    ///
    /// <p>Gets the reason that a specified health check failed most recently.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetHealthCheckLastFailureReason {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_health_check_last_failure_reason_input::Builder,
    }
    impl GetHealthCheckLastFailureReason {
        /// Creates a new `GetHealthCheckLastFailureReason`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetHealthCheckLastFailureReasonOutput,
            aws_smithy_http::result::SdkError<crate::error::GetHealthCheckLastFailureReasonError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the health check for which you want the last failure reason. When you created the health check, <code>CreateHealthCheck</code> returned the ID in the response, in the <code>HealthCheckId</code> element.</p> <note>
        /// <p>If you want to get the last failure reason for a calculated health check, you must use the Amazon Route 53 console or the CloudWatch console. You can't use <code>GetHealthCheckLastFailureReason</code> for a calculated health check.</p>
        /// </note>
        pub fn health_check_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.health_check_id(input.into());
            self
        }
        /// <p>The ID for the health check for which you want the last failure reason. When you created the health check, <code>CreateHealthCheck</code> returned the ID in the response, in the <code>HealthCheckId</code> element.</p> <note>
        /// <p>If you want to get the last failure reason for a calculated health check, you must use the Amazon Route 53 console or the CloudWatch console. You can't use <code>GetHealthCheckLastFailureReason</code> for a calculated health check.</p>
        /// </note>
        pub fn set_health_check_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_health_check_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetHealthCheckStatus`.
    ///
    /// <p>Gets status of a specified health check. </p> <important>
    /// <p>This API is intended for use during development to diagnose behavior. It doesn’t support production use-cases with high query rates that require immediate and actionable responses.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetHealthCheckStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_health_check_status_input::Builder,
    }
    impl GetHealthCheckStatus {
        /// Creates a new `GetHealthCheckStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetHealthCheckStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetHealthCheckStatusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the health check that you want the current status for. When you created the health check, <code>CreateHealthCheck</code> returned the ID in the response, in the <code>HealthCheckId</code> element.</p> <note>
        /// <p>If you want to check the status of a calculated health check, you must use the Amazon Route 53 console or the CloudWatch console. You can't use <code>GetHealthCheckStatus</code> to get the status of a calculated health check.</p>
        /// </note>
        pub fn health_check_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.health_check_id(input.into());
            self
        }
        /// <p>The ID for the health check that you want the current status for. When you created the health check, <code>CreateHealthCheck</code> returned the ID in the response, in the <code>HealthCheckId</code> element.</p> <note>
        /// <p>If you want to check the status of a calculated health check, you must use the Amazon Route 53 console or the CloudWatch console. You can't use <code>GetHealthCheckStatus</code> to get the status of a calculated health check.</p>
        /// </note>
        pub fn set_health_check_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_health_check_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetHostedZone`.
    ///
    /// <p>Gets information about a specified hosted zone including the four name servers assigned to the hosted zone.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetHostedZone {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_hosted_zone_input::Builder,
    }
    impl GetHostedZone {
        /// Creates a new `GetHostedZone`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetHostedZoneOutput,
            aws_smithy_http::result::SdkError<crate::error::GetHostedZoneError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the hosted zone that you want to get information about.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the hosted zone that you want to get information about.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetHostedZoneCount`.
    ///
    /// <p>Retrieves the number of hosted zones that are associated with the current Amazon Web Services account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetHostedZoneCount {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_hosted_zone_count_input::Builder,
    }
    impl GetHostedZoneCount {
        /// Creates a new `GetHostedZoneCount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetHostedZoneCountOutput,
            aws_smithy_http::result::SdkError<crate::error::GetHostedZoneCountError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetHostedZoneLimit`.
    ///
    /// <p>Gets the specified limit for a specified hosted zone, for example, the maximum number of records that you can create in the hosted zone. </p>
    /// <p>For the default limit, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a> in the <i>Amazon Route 53 Developer Guide</i>. To request a higher limit, <a href="https://console.aws.amazon.com/support/home#/case/create?issueType=service-limit-increase&amp;limitType=service-code-route53">open a case</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetHostedZoneLimit {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_hosted_zone_limit_input::Builder,
    }
    impl GetHostedZoneLimit {
        /// Creates a new `GetHostedZoneLimit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetHostedZoneLimitOutput,
            aws_smithy_http::result::SdkError<crate::error::GetHostedZoneLimitError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The limit that you want to get. Valid values include the following:</p>
        /// <ul>
        /// <li> <p> <b>MAX_RRSETS_BY_ZONE</b>: The maximum number of records that you can create in the specified hosted zone.</p> </li>
        /// <li> <p> <b>MAX_VPCS_ASSOCIATED_BY_ZONE</b>: The maximum number of Amazon VPCs that you can associate with the specified private hosted zone.</p> </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::HostedZoneLimitType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The limit that you want to get. Valid values include the following:</p>
        /// <ul>
        /// <li> <p> <b>MAX_RRSETS_BY_ZONE</b>: The maximum number of records that you can create in the specified hosted zone.</p> </li>
        /// <li> <p> <b>MAX_VPCS_ASSOCIATED_BY_ZONE</b>: The maximum number of Amazon VPCs that you can associate with the specified private hosted zone.</p> </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::HostedZoneLimitType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The ID of the hosted zone that you want to get a limit for.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>The ID of the hosted zone that you want to get a limit for.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetQueryLoggingConfig`.
    ///
    /// <p>Gets information about a specified configuration for DNS query logging.</p>
    /// <p>For more information about DNS query logs, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateQueryLoggingConfig.html">CreateQueryLoggingConfig</a> and <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html">Logging DNS Queries</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetQueryLoggingConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_query_logging_config_input::Builder,
    }
    impl GetQueryLoggingConfig {
        /// Creates a new `GetQueryLoggingConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetQueryLoggingConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetQueryLoggingConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the configuration for DNS query logging that you want to get information about.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the configuration for DNS query logging that you want to get information about.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetReusableDelegationSet`.
    ///
    /// <p>Retrieves information about a specified reusable delegation set, including the four name servers that are assigned to the delegation set.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetReusableDelegationSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_reusable_delegation_set_input::Builder,
    }
    impl GetReusableDelegationSet {
        /// Creates a new `GetReusableDelegationSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetReusableDelegationSetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetReusableDelegationSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the reusable delegation set that you want to get a list of name servers for.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the reusable delegation set that you want to get a list of name servers for.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetReusableDelegationSetLimit`.
    ///
    /// <p>Gets the maximum number of hosted zones that you can associate with the specified reusable delegation set.</p>
    /// <p>For the default limit, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a> in the <i>Amazon Route 53 Developer Guide</i>. To request a higher limit, <a href="https://console.aws.amazon.com/support/home#/case/create?issueType=service-limit-increase&amp;limitType=service-code-route53">open a case</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetReusableDelegationSetLimit {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_reusable_delegation_set_limit_input::Builder,
    }
    impl GetReusableDelegationSetLimit {
        /// Creates a new `GetReusableDelegationSetLimit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetReusableDelegationSetLimitOutput,
            aws_smithy_http::result::SdkError<crate::error::GetReusableDelegationSetLimitError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specify <code>MAX_ZONES_BY_REUSABLE_DELEGATION_SET</code> to get the maximum number of hosted zones that you can associate with the specified reusable delegation set.</p>
        pub fn r#type(mut self, input: crate::model::ReusableDelegationSetLimitType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>Specify <code>MAX_ZONES_BY_REUSABLE_DELEGATION_SET</code> to get the maximum number of hosted zones that you can associate with the specified reusable delegation set.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ReusableDelegationSetLimitType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The ID of the delegation set that you want to get the limit for.</p>
        pub fn delegation_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.delegation_set_id(input.into());
            self
        }
        /// <p>The ID of the delegation set that you want to get the limit for.</p>
        pub fn set_delegation_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_delegation_set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTrafficPolicy`.
    ///
    /// <p>Gets information about a specific traffic policy version.</p>
    /// <p>For information about how of deleting a traffic policy affects the response from <code>GetTrafficPolicy</code>, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteTrafficPolicy.html">DeleteTrafficPolicy</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetTrafficPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_traffic_policy_input::Builder,
    }
    impl GetTrafficPolicy {
        /// Creates a new `GetTrafficPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTrafficPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTrafficPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the traffic policy that you want to get information about.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the traffic policy that you want to get information about.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The version number of the traffic policy that you want to get information about.</p>
        pub fn version(mut self, input: i32) -> Self {
            self.inner = self.inner.version(input);
            self
        }
        /// <p>The version number of the traffic policy that you want to get information about.</p>
        pub fn set_version(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTrafficPolicyInstance`.
    ///
    /// <p>Gets information about a specified traffic policy instance.</p> <note>
    /// <p>After you submit a <code>CreateTrafficPolicyInstance</code> or an <code>UpdateTrafficPolicyInstance</code> request, there's a brief delay while Amazon Route 53 creates the resource record sets that are specified in the traffic policy definition. For more information, see the <code>State</code> response element.</p>
    /// </note> <note>
    /// <p>In the Route 53 console, traffic policy instances are known as policy records.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetTrafficPolicyInstance {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_traffic_policy_instance_input::Builder,
    }
    impl GetTrafficPolicyInstance {
        /// Creates a new `GetTrafficPolicyInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTrafficPolicyInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTrafficPolicyInstanceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the traffic policy instance that you want to get information about.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the traffic policy instance that you want to get information about.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTrafficPolicyInstanceCount`.
    ///
    /// <p>Gets the number of traffic policy instances that are associated with the current Amazon Web Services account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetTrafficPolicyInstanceCount {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_traffic_policy_instance_count_input::Builder,
    }
    impl GetTrafficPolicyInstanceCount {
        /// Creates a new `GetTrafficPolicyInstanceCount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTrafficPolicyInstanceCountOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTrafficPolicyInstanceCountError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `ListGeoLocations`.
    ///
    /// <p>Retrieves a list of supported geographic locations.</p>
    /// <p>Countries are listed first, and continents are listed last. If Amazon Route 53 supports subdivisions for a country (for example, states or provinces), the subdivisions for that country are listed in alphabetical order immediately after the corresponding country.</p>
    /// <p>Route 53 does not perform authorization for this API because it retrieves information that is already available to the public.</p>
    /// <p>For a list of supported geolocation codes, see the <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GeoLocation.html">GeoLocation</a> data type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListGeoLocations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_geo_locations_input::Builder,
    }
    impl ListGeoLocations {
        /// Creates a new `ListGeoLocations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGeoLocationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGeoLocationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The code for the continent with which you want to start listing locations that Amazon Route 53 supports for geolocation. If Route 53 has already returned a page or more of results, if <code>IsTruncated</code> is true, and if <code>NextContinentCode</code> from the previous response has a value, enter that value in <code>startcontinentcode</code> to return the next page of results.</p>
        /// <p>Include <code>startcontinentcode</code> only if you want to list continents. Don't include <code>startcontinentcode</code> when you're listing countries or countries with their subdivisions.</p>
        pub fn start_continent_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.start_continent_code(input.into());
            self
        }
        /// <p>The code for the continent with which you want to start listing locations that Amazon Route 53 supports for geolocation. If Route 53 has already returned a page or more of results, if <code>IsTruncated</code> is true, and if <code>NextContinentCode</code> from the previous response has a value, enter that value in <code>startcontinentcode</code> to return the next page of results.</p>
        /// <p>Include <code>startcontinentcode</code> only if you want to list continents. Don't include <code>startcontinentcode</code> when you're listing countries or countries with their subdivisions.</p>
        pub fn set_start_continent_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_start_continent_code(input);
            self
        }
        /// <p>The code for the country with which you want to start listing locations that Amazon Route 53 supports for geolocation. If Route 53 has already returned a page or more of results, if <code>IsTruncated</code> is <code>true</code>, and if <code>NextCountryCode</code> from the previous response has a value, enter that value in <code>startcountrycode</code> to return the next page of results.</p>
        pub fn start_country_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.start_country_code(input.into());
            self
        }
        /// <p>The code for the country with which you want to start listing locations that Amazon Route 53 supports for geolocation. If Route 53 has already returned a page or more of results, if <code>IsTruncated</code> is <code>true</code>, and if <code>NextCountryCode</code> from the previous response has a value, enter that value in <code>startcountrycode</code> to return the next page of results.</p>
        pub fn set_start_country_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_start_country_code(input);
            self
        }
        /// <p>The code for the state of the United States with which you want to start listing locations that Amazon Route 53 supports for geolocation. If Route 53 has already returned a page or more of results, if <code>IsTruncated</code> is <code>true</code>, and if <code>NextSubdivisionCode</code> from the previous response has a value, enter that value in <code>startsubdivisioncode</code> to return the next page of results.</p>
        /// <p>To list subdivisions (U.S. states), you must include both <code>startcountrycode</code> and <code>startsubdivisioncode</code>.</p>
        pub fn start_subdivision_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.start_subdivision_code(input.into());
            self
        }
        /// <p>The code for the state of the United States with which you want to start listing locations that Amazon Route 53 supports for geolocation. If Route 53 has already returned a page or more of results, if <code>IsTruncated</code> is <code>true</code>, and if <code>NextSubdivisionCode</code> from the previous response has a value, enter that value in <code>startsubdivisioncode</code> to return the next page of results.</p>
        /// <p>To list subdivisions (U.S. states), you must include both <code>startcountrycode</code> and <code>startsubdivisioncode</code>.</p>
        pub fn set_start_subdivision_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_start_subdivision_code(input);
            self
        }
        /// <p>(Optional) The maximum number of geolocations to be included in the response body for this request. If more than <code>maxitems</code> geolocations remain to be listed, then the value of the <code>IsTruncated</code> element in the response is <code>true</code>.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>(Optional) The maximum number of geolocations to be included in the response body for this request. If more than <code>maxitems</code> geolocations remain to be listed, then the value of the <code>IsTruncated</code> element in the response is <code>true</code>.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListHealthChecks`.
    ///
    /// <p>Retrieve a list of the health checks that are associated with the current Amazon Web Services account. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListHealthChecks {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_health_checks_input::Builder,
    }
    impl ListHealthChecks {
        /// Creates a new `ListHealthChecks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListHealthChecksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListHealthChecksError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListHealthChecksPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListHealthChecksPaginator {
            crate::paginator::ListHealthChecksPaginator::new(self.handle, self.inner)
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more health checks. To get another group, submit another <code>ListHealthChecks</code> request. </p>
        /// <p>For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous response, which is the ID of the first health check that Amazon Route 53 will return if you submit another request.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more health checks to get.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more health checks. To get another group, submit another <code>ListHealthChecks</code> request. </p>
        /// <p>For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous response, which is the ID of the first health check that Amazon Route 53 will return if you submit another request.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more health checks to get.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of health checks that you want <code>ListHealthChecks</code> to return in response to the current request. Amazon Route 53 returns a maximum of 100 items. If you set <code>MaxItems</code> to a value greater than 100, Route 53 returns only the first 100 health checks. </p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The maximum number of health checks that you want <code>ListHealthChecks</code> to return in response to the current request. Amazon Route 53 returns a maximum of 100 items. If you set <code>MaxItems</code> to a value greater than 100, Route 53 returns only the first 100 health checks. </p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListHostedZones`.
    ///
    /// <p>Retrieves a list of the public and private hosted zones that are associated with the current Amazon Web Services account. The response includes a <code>HostedZones</code> child element for each hosted zone.</p>
    /// <p>Amazon Route 53 returns a maximum of 100 items in each response. If you have a lot of hosted zones, you can use the <code>maxitems</code> parameter to list them in groups of up to 100.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListHostedZones {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_hosted_zones_input::Builder,
    }
    impl ListHostedZones {
        /// Creates a new `ListHostedZones`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListHostedZonesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListHostedZonesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListHostedZonesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListHostedZonesPaginator {
            crate::paginator::ListHostedZonesPaginator::new(self.handle, self.inner)
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more hosted zones. To get more hosted zones, submit another <code>ListHostedZones</code> request. </p>
        /// <p>For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous response, which is the ID of the first hosted zone that Amazon Route 53 will return if you submit another request.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more hosted zones to get.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more hosted zones. To get more hosted zones, submit another <code>ListHostedZones</code> request. </p>
        /// <p>For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous response, which is the ID of the first hosted zone that Amazon Route 53 will return if you submit another request.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more hosted zones to get.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>(Optional) The maximum number of hosted zones that you want Amazon Route 53 to return. If you have more than <code>maxitems</code> hosted zones, the value of <code>IsTruncated</code> in the response is <code>true</code>, and the value of <code>NextMarker</code> is the hosted zone ID of the first hosted zone that Route 53 will return if you submit another request.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>(Optional) The maximum number of hosted zones that you want Amazon Route 53 to return. If you have more than <code>maxitems</code> hosted zones, the value of <code>IsTruncated</code> in the response is <code>true</code>, and the value of <code>NextMarker</code> is the hosted zone ID of the first hosted zone that Route 53 will return if you submit another request.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
        /// <p>If you're using reusable delegation sets and you want to list all of the hosted zones that are associated with a reusable delegation set, specify the ID of that reusable delegation set. </p>
        pub fn delegation_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.delegation_set_id(input.into());
            self
        }
        /// <p>If you're using reusable delegation sets and you want to list all of the hosted zones that are associated with a reusable delegation set, specify the ID of that reusable delegation set. </p>
        pub fn set_delegation_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_delegation_set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListHostedZonesByName`.
    ///
    /// <p>Retrieves a list of your hosted zones in lexicographic order. The response includes a <code>HostedZones</code> child element for each hosted zone created by the current Amazon Web Services account. </p>
    /// <p> <code>ListHostedZonesByName</code> sorts hosted zones by name with the labels reversed. For example:</p>
    /// <p> <code>com.example.www.</code> </p>
    /// <p>Note the trailing dot, which can change the sort order in some circumstances.</p>
    /// <p>If the domain name includes escape characters or Punycode, <code>ListHostedZonesByName</code> alphabetizes the domain name using the escaped or Punycoded value, which is the format that Amazon Route 53 saves in its database. For example, to create a hosted zone for exämple.com, you specify ex\344mple.com for the domain name. <code>ListHostedZonesByName</code> alphabetizes it as:</p>
    /// <p> <code>com.ex\344mple.</code> </p>
    /// <p>The labels are reversed and alphabetized using the escaped value. For more information about valid domain name formats, including internationalized domain names, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html">DNS Domain Name Format</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
    /// <p>Route 53 returns up to 100 items in each response. If you have a lot of hosted zones, use the <code>MaxItems</code> parameter to list them in groups of up to 100. The response includes values that help navigate from one group of <code>MaxItems</code> hosted zones to the next:</p>
    /// <ul>
    /// <li> <p>The <code>DNSName</code> and <code>HostedZoneId</code> elements in the response contain the values, if any, specified for the <code>dnsname</code> and <code>hostedzoneid</code> parameters in the request that produced the current response.</p> </li>
    /// <li> <p>The <code>MaxItems</code> element in the response contains the value, if any, that you specified for the <code>maxitems</code> parameter in the request that produced the current response.</p> </li>
    /// <li> <p>If the value of <code>IsTruncated</code> in the response is true, there are more hosted zones associated with the current Amazon Web Services account. </p> <p>If <code>IsTruncated</code> is false, this response includes the last hosted zone that is associated with the current account. The <code>NextDNSName</code> element and <code>NextHostedZoneId</code> elements are omitted from the response.</p> </li>
    /// <li> <p>The <code>NextDNSName</code> and <code>NextHostedZoneId</code> elements in the response contain the domain name and the hosted zone ID of the next hosted zone that is associated with the current Amazon Web Services account. If you want to list more hosted zones, make another call to <code>ListHostedZonesByName</code>, and specify the value of <code>NextDNSName</code> and <code>NextHostedZoneId</code> in the <code>dnsname</code> and <code>hostedzoneid</code> parameters, respectively.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListHostedZonesByName {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_hosted_zones_by_name_input::Builder,
    }
    impl ListHostedZonesByName {
        /// Creates a new `ListHostedZonesByName`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListHostedZonesByNameOutput,
            aws_smithy_http::result::SdkError<crate::error::ListHostedZonesByNameError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>(Optional) For your first request to <code>ListHostedZonesByName</code>, include the <code>dnsname</code> parameter only if you want to specify the name of the first hosted zone in the response. If you don't include the <code>dnsname</code> parameter, Amazon Route 53 returns all of the hosted zones that were created by the current Amazon Web Services account, in ASCII order. For subsequent requests, include both <code>dnsname</code> and <code>hostedzoneid</code> parameters. For <code>dnsname</code>, specify the value of <code>NextDNSName</code> from the previous response.</p>
        pub fn dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dns_name(input.into());
            self
        }
        /// <p>(Optional) For your first request to <code>ListHostedZonesByName</code>, include the <code>dnsname</code> parameter only if you want to specify the name of the first hosted zone in the response. If you don't include the <code>dnsname</code> parameter, Amazon Route 53 returns all of the hosted zones that were created by the current Amazon Web Services account, in ASCII order. For subsequent requests, include both <code>dnsname</code> and <code>hostedzoneid</code> parameters. For <code>dnsname</code>, specify the value of <code>NextDNSName</code> from the previous response.</p>
        pub fn set_dns_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dns_name(input);
            self
        }
        /// <p>(Optional) For your first request to <code>ListHostedZonesByName</code>, do not include the <code>hostedzoneid</code> parameter.</p>
        /// <p>If you have more hosted zones than the value of <code>maxitems</code>, <code>ListHostedZonesByName</code> returns only the first <code>maxitems</code> hosted zones. To get the next group of <code>maxitems</code> hosted zones, submit another request to <code>ListHostedZonesByName</code> and include both <code>dnsname</code> and <code>hostedzoneid</code> parameters. For the value of <code>hostedzoneid</code>, specify the value of the <code>NextHostedZoneId</code> element from the previous response.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>(Optional) For your first request to <code>ListHostedZonesByName</code>, do not include the <code>hostedzoneid</code> parameter.</p>
        /// <p>If you have more hosted zones than the value of <code>maxitems</code>, <code>ListHostedZonesByName</code> returns only the first <code>maxitems</code> hosted zones. To get the next group of <code>maxitems</code> hosted zones, submit another request to <code>ListHostedZonesByName</code> and include both <code>dnsname</code> and <code>hostedzoneid</code> parameters. For the value of <code>hostedzoneid</code>, specify the value of the <code>NextHostedZoneId</code> element from the previous response.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
        /// <p>The maximum number of hosted zones to be included in the response body for this request. If you have more than <code>maxitems</code> hosted zones, then the value of the <code>IsTruncated</code> element in the response is true, and the values of <code>NextDNSName</code> and <code>NextHostedZoneId</code> specify the first hosted zone in the next group of <code>maxitems</code> hosted zones. </p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The maximum number of hosted zones to be included in the response body for this request. If you have more than <code>maxitems</code> hosted zones, then the value of the <code>IsTruncated</code> element in the response is true, and the values of <code>NextDNSName</code> and <code>NextHostedZoneId</code> specify the first hosted zone in the next group of <code>maxitems</code> hosted zones. </p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListHostedZonesByVPC`.
    ///
    /// <p>Lists all the private hosted zones that a specified VPC is associated with, regardless of which Amazon Web Services account or Amazon Web Services service owns the hosted zones. The <code>HostedZoneOwner</code> structure in the response contains one of the following values:</p>
    /// <ul>
    /// <li> <p>An <code>OwningAccount</code> element, which contains the account number of either the current Amazon Web Services account or another Amazon Web Services account. Some services, such as Cloud Map, create hosted zones using the current account. </p> </li>
    /// <li> <p>An <code>OwningService</code> element, which identifies the Amazon Web Services service that created and owns the hosted zone. For example, if a hosted zone was created by Amazon Elastic File System (Amazon EFS), the value of <code>Owner</code> is <code>efs.amazonaws.com</code>. </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListHostedZonesByVPC {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_hosted_zones_by_vpc_input::Builder,
    }
    impl ListHostedZonesByVPC {
        /// Creates a new `ListHostedZonesByVPC`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListHostedZonesByVpcOutput,
            aws_smithy_http::result::SdkError<crate::error::ListHostedZonesByVPCError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon VPC that you want to list hosted zones for.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_id(input.into());
            self
        }
        /// <p>The ID of the Amazon VPC that you want to list hosted zones for.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_id(input);
            self
        }
        /// <p>For the Amazon VPC that you specified for <code>VPCId</code>, the Amazon Web Services Region that you created the VPC in. </p>
        pub fn vpc_region(mut self, input: crate::model::VpcRegion) -> Self {
            self.inner = self.inner.vpc_region(input);
            self
        }
        /// <p>For the Amazon VPC that you specified for <code>VPCId</code>, the Amazon Web Services Region that you created the VPC in. </p>
        pub fn set_vpc_region(
            mut self,
            input: std::option::Option<crate::model::VpcRegion>,
        ) -> Self {
            self.inner = self.inner.set_vpc_region(input);
            self
        }
        /// <p>(Optional) The maximum number of hosted zones that you want Amazon Route 53 to return. If the specified VPC is associated with more than <code>MaxItems</code> hosted zones, the response includes a <code>NextToken</code> element. <code>NextToken</code> contains an encrypted token that identifies the first hosted zone that Route 53 will return if you submit another request.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>(Optional) The maximum number of hosted zones that you want Amazon Route 53 to return. If the specified VPC is associated with more than <code>MaxItems</code> hosted zones, the response includes a <code>NextToken</code> element. <code>NextToken</code> contains an encrypted token that identifies the first hosted zone that Route 53 will return if you submit another request.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
        /// <p>If the previous response included a <code>NextToken</code> element, the specified VPC is associated with more hosted zones. To get more hosted zones, submit another <code>ListHostedZonesByVPC</code> request. </p>
        /// <p>For the value of <code>NextToken</code>, specify the value of <code>NextToken</code> from the previous response.</p>
        /// <p>If the previous response didn't include a <code>NextToken</code> element, there are no more hosted zones to get.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous response included a <code>NextToken</code> element, the specified VPC is associated with more hosted zones. To get more hosted zones, submit another <code>ListHostedZonesByVPC</code> request. </p>
        /// <p>For the value of <code>NextToken</code>, specify the value of <code>NextToken</code> from the previous response.</p>
        /// <p>If the previous response didn't include a <code>NextToken</code> element, there are no more hosted zones to get.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListQueryLoggingConfigs`.
    ///
    /// <p>Lists the configurations for DNS query logging that are associated with the current Amazon Web Services account or the configuration that is associated with a specified hosted zone.</p>
    /// <p>For more information about DNS query logs, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateQueryLoggingConfig.html">CreateQueryLoggingConfig</a>. Additional information, including the format of DNS query logs, appears in <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html">Logging DNS Queries</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListQueryLoggingConfigs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_query_logging_configs_input::Builder,
    }
    impl ListQueryLoggingConfigs {
        /// Creates a new `ListQueryLoggingConfigs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListQueryLoggingConfigsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListQueryLoggingConfigsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListQueryLoggingConfigsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListQueryLoggingConfigsPaginator {
            crate::paginator::ListQueryLoggingConfigsPaginator::new(self.handle, self.inner)
        }
        /// <p>(Optional) If you want to list the query logging configuration that is associated with a hosted zone, specify the ID in <code>HostedZoneId</code>. </p>
        /// <p>If you don't specify a hosted zone ID, <code>ListQueryLoggingConfigs</code> returns all of the configurations that are associated with the current Amazon Web Services account.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>(Optional) If you want to list the query logging configuration that is associated with a hosted zone, specify the ID in <code>HostedZoneId</code>. </p>
        /// <p>If you don't specify a hosted zone ID, <code>ListQueryLoggingConfigs</code> returns all of the configurations that are associated with the current Amazon Web Services account.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
        /// <p>(Optional) If the current Amazon Web Services account has more than <code>MaxResults</code> query logging configurations, use <code>NextToken</code> to get the second and subsequent pages of results.</p>
        /// <p>For the first <code>ListQueryLoggingConfigs</code> request, omit this value.</p>
        /// <p>For the second and subsequent requests, get the value of <code>NextToken</code> from the previous response and specify that value for <code>NextToken</code> in the request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>(Optional) If the current Amazon Web Services account has more than <code>MaxResults</code> query logging configurations, use <code>NextToken</code> to get the second and subsequent pages of results.</p>
        /// <p>For the first <code>ListQueryLoggingConfigs</code> request, omit this value.</p>
        /// <p>For the second and subsequent requests, get the value of <code>NextToken</code> from the previous response and specify that value for <code>NextToken</code> in the request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>(Optional) The maximum number of query logging configurations that you want Amazon Route 53 to return in response to the current request. If the current Amazon Web Services account has more than <code>MaxResults</code> configurations, use the value of <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListQueryLoggingConfigs.html#API_ListQueryLoggingConfigs_RequestSyntax">NextToken</a> in the response to get the next page of results.</p>
        /// <p>If you don't specify a value for <code>MaxResults</code>, Route 53 returns up to 100 configurations.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>(Optional) The maximum number of query logging configurations that you want Amazon Route 53 to return in response to the current request. If the current Amazon Web Services account has more than <code>MaxResults</code> configurations, use the value of <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListQueryLoggingConfigs.html#API_ListQueryLoggingConfigs_RequestSyntax">NextToken</a> in the response to get the next page of results.</p>
        /// <p>If you don't specify a value for <code>MaxResults</code>, Route 53 returns up to 100 configurations.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResourceRecordSets`.
    ///
    /// <p>Lists the resource record sets in a specified hosted zone.</p>
    /// <p> <code>ListResourceRecordSets</code> returns up to 300 resource record sets at a time in ASCII order, beginning at a position specified by the <code>name</code> and <code>type</code> elements.</p>
    /// <p> <b>Sort order</b> </p>
    /// <p> <code>ListResourceRecordSets</code> sorts results first by DNS name with the labels reversed, for example:</p>
    /// <p> <code>com.example.www.</code> </p>
    /// <p>Note the trailing dot, which can change the sort order when the record name contains characters that appear before <code>.</code> (decimal 46) in the ASCII table. These characters include the following: <code>! " # $ % &amp; ' ( ) * + , -</code> </p>
    /// <p>When multiple records have the same DNS name, <code>ListResourceRecordSets</code> sorts results by the record type.</p>
    /// <p> <b>Specifying where to start listing records</b> </p>
    /// <p>You can use the name and type elements to specify the resource record set that the list begins with:</p>
    /// <dl>
    /// <dt>
    /// If you do not specify Name or Type
    /// </dt>
    /// <dd>
    /// <p>The results begin with the first resource record set that the hosted zone contains.</p>
    /// </dd>
    /// <dt>
    /// If you specify Name but not Type
    /// </dt>
    /// <dd>
    /// <p>The results begin with the first resource record set in the list whose name is greater than or equal to <code>Name</code>.</p>
    /// </dd>
    /// <dt>
    /// If you specify Type but not Name
    /// </dt>
    /// <dd>
    /// <p>Amazon Route 53 returns the <code>InvalidInput</code> error.</p>
    /// </dd>
    /// <dt>
    /// If you specify both Name and Type
    /// </dt>
    /// <dd>
    /// <p>The results begin with the first resource record set in the list whose name is greater than or equal to <code>Name</code>, and whose type is greater than or equal to <code>Type</code>.</p>
    /// </dd>
    /// </dl>
    /// <p> <b>Resource record sets that are PENDING</b> </p>
    /// <p>This action returns the most current version of the records. This includes records that are <code>PENDING</code>, and that are not yet available on all Route 53 DNS servers.</p>
    /// <p> <b>Changing resource record sets</b> </p>
    /// <p>To ensure that you get an accurate listing of the resource record sets for a hosted zone at a point in time, do not submit a <code>ChangeResourceRecordSets</code> request while you're paging through the results of a <code>ListResourceRecordSets</code> request. If you do, some pages may display results without the latest changes while other pages display results with the latest changes.</p>
    /// <p> <b>Displaying the next page of results</b> </p>
    /// <p>If a <code>ListResourceRecordSets</code> command returns more than one page of results, the value of <code>IsTruncated</code> is <code>true</code>. To display the next page of results, get the values of <code>NextRecordName</code>, <code>NextRecordType</code>, and <code>NextRecordIdentifier</code> (if any) from the response. Then submit another <code>ListResourceRecordSets</code> request, and specify those values for <code>StartRecordName</code>, <code>StartRecordType</code>, and <code>StartRecordIdentifier</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListResourceRecordSets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_resource_record_sets_input::Builder,
    }
    impl ListResourceRecordSets {
        /// Creates a new `ListResourceRecordSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResourceRecordSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResourceRecordSetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the hosted zone that contains the resource record sets that you want to list.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>The ID of the hosted zone that contains the resource record sets that you want to list.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
        /// <p>The first name in the lexicographic ordering of resource record sets that you want to list. If the specified record name doesn't exist, the results begin with the first resource record set that has a name greater than the value of <code>name</code>.</p>
        pub fn start_record_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.start_record_name(input.into());
            self
        }
        /// <p>The first name in the lexicographic ordering of resource record sets that you want to list. If the specified record name doesn't exist, the results begin with the first resource record set that has a name greater than the value of <code>name</code>.</p>
        pub fn set_start_record_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_start_record_name(input);
            self
        }
        /// <p>The type of resource record set to begin the record listing from.</p>
        /// <p>Valid values for basic resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> | <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> | <code>NS</code> | <code>PTR</code> | <code>SOA</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code> </p>
        /// <p>Values for weighted, latency, geolocation, and failover resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> | <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> | <code>PTR</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code> </p>
        /// <p>Values for alias resource record sets: </p>
        /// <ul>
        /// <li> <p> <b>API Gateway custom regional API or edge-optimized API</b>: A</p> </li>
        /// <li> <p> <b>CloudFront distribution</b>: A or AAAA</p> </li>
        /// <li> <p> <b>Elastic Beanstalk environment that has a regionalized subdomain</b>: A</p> </li>
        /// <li> <p> <b>Elastic Load Balancing load balancer</b>: A | AAAA</p> </li>
        /// <li> <p> <b>S3 bucket</b>: A</p> </li>
        /// <li> <p> <b>VPC interface VPC endpoint</b>: A</p> </li>
        /// <li> <p> <b>Another resource record set in this hosted zone:</b> The type of the resource record set that the alias references.</p> </li>
        /// </ul>
        /// <p>Constraint: Specifying <code>type</code> without specifying <code>name</code> returns an <code>InvalidInput</code> error.</p>
        pub fn start_record_type(mut self, input: crate::model::RrType) -> Self {
            self.inner = self.inner.start_record_type(input);
            self
        }
        /// <p>The type of resource record set to begin the record listing from.</p>
        /// <p>Valid values for basic resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> | <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> | <code>NS</code> | <code>PTR</code> | <code>SOA</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code> </p>
        /// <p>Values for weighted, latency, geolocation, and failover resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> | <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> | <code>PTR</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code> </p>
        /// <p>Values for alias resource record sets: </p>
        /// <ul>
        /// <li> <p> <b>API Gateway custom regional API or edge-optimized API</b>: A</p> </li>
        /// <li> <p> <b>CloudFront distribution</b>: A or AAAA</p> </li>
        /// <li> <p> <b>Elastic Beanstalk environment that has a regionalized subdomain</b>: A</p> </li>
        /// <li> <p> <b>Elastic Load Balancing load balancer</b>: A | AAAA</p> </li>
        /// <li> <p> <b>S3 bucket</b>: A</p> </li>
        /// <li> <p> <b>VPC interface VPC endpoint</b>: A</p> </li>
        /// <li> <p> <b>Another resource record set in this hosted zone:</b> The type of the resource record set that the alias references.</p> </li>
        /// </ul>
        /// <p>Constraint: Specifying <code>type</code> without specifying <code>name</code> returns an <code>InvalidInput</code> error.</p>
        pub fn set_start_record_type(
            mut self,
            input: std::option::Option<crate::model::RrType>,
        ) -> Self {
            self.inner = self.inner.set_start_record_type(input);
            self
        }
        /// <p> <i>Resource record sets that have a routing policy other than simple:</i> If results were truncated for a given DNS name and type, specify the value of <code>NextRecordIdentifier</code> from the previous response to get the next resource record set that has the current DNS name and type.</p>
        pub fn start_record_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.start_record_identifier(input.into());
            self
        }
        /// <p> <i>Resource record sets that have a routing policy other than simple:</i> If results were truncated for a given DNS name and type, specify the value of <code>NextRecordIdentifier</code> from the previous response to get the next resource record set that has the current DNS name and type.</p>
        pub fn set_start_record_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_start_record_identifier(input);
            self
        }
        /// <p>(Optional) The maximum number of resource records sets to include in the response body for this request. If the response includes more than <code>maxitems</code> resource record sets, the value of the <code>IsTruncated</code> element in the response is <code>true</code>, and the values of the <code>NextRecordName</code> and <code>NextRecordType</code> elements in the response identify the first resource record set in the next group of <code>maxitems</code> resource record sets.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>(Optional) The maximum number of resource records sets to include in the response body for this request. If the response includes more than <code>maxitems</code> resource record sets, the value of the <code>IsTruncated</code> element in the response is <code>true</code>, and the values of the <code>NextRecordName</code> and <code>NextRecordType</code> elements in the response identify the first resource record set in the next group of <code>maxitems</code> resource record sets.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListReusableDelegationSets`.
    ///
    /// <p>Retrieves a list of the reusable delegation sets that are associated with the current Amazon Web Services account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListReusableDelegationSets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_reusable_delegation_sets_input::Builder,
    }
    impl ListReusableDelegationSets {
        /// Creates a new `ListReusableDelegationSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListReusableDelegationSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListReusableDelegationSetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more reusable delegation sets. To get another group, submit another <code>ListReusableDelegationSets</code> request. </p>
        /// <p>For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous response, which is the ID of the first reusable delegation set that Amazon Route 53 will return if you submit another request.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more reusable delegation sets to get.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more reusable delegation sets. To get another group, submit another <code>ListReusableDelegationSets</code> request. </p>
        /// <p>For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous response, which is the ID of the first reusable delegation set that Amazon Route 53 will return if you submit another request.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more reusable delegation sets to get.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The number of reusable delegation sets that you want Amazon Route 53 to return in the response to this request. If you specify a value greater than 100, Route 53 returns only the first 100 reusable delegation sets.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The number of reusable delegation sets that you want Amazon Route 53 to return in the response to this request. If you specify a value greater than 100, Route 53 returns only the first 100 reusable delegation sets.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists tags for one health check or hosted zone. </p>
    /// <p>For information about using tags for cost allocation, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the <i>Billing and Cost Management User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The type of the resource.</p>
        /// <ul>
        /// <li> <p>The resource type for health checks is <code>healthcheck</code>.</p> </li>
        /// <li> <p>The resource type for hosted zones is <code>hostedzone</code>.</p> </li>
        /// </ul>
        pub fn resource_type(mut self, input: crate::model::TagResourceType) -> Self {
            self.inner = self.inner.resource_type(input);
            self
        }
        /// <p>The type of the resource.</p>
        /// <ul>
        /// <li> <p>The resource type for health checks is <code>healthcheck</code>.</p> </li>
        /// <li> <p>The resource type for hosted zones is <code>hostedzone</code>.</p> </li>
        /// </ul>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::TagResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The ID of the resource for which you want to retrieve tags.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The ID of the resource for which you want to retrieve tags.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResources`.
    ///
    /// <p>Lists tags for up to 10 health checks or hosted zones.</p>
    /// <p>For information about using tags for cost allocation, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the <i>Billing and Cost Management User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResources {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resources_input::Builder,
    }
    impl ListTagsForResources {
        /// Creates a new `ListTagsForResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourcesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The type of the resources.</p>
        /// <ul>
        /// <li> <p>The resource type for health checks is <code>healthcheck</code>.</p> </li>
        /// <li> <p>The resource type for hosted zones is <code>hostedzone</code>.</p> </li>
        /// </ul>
        pub fn resource_type(mut self, input: crate::model::TagResourceType) -> Self {
            self.inner = self.inner.resource_type(input);
            self
        }
        /// <p>The type of the resources.</p>
        /// <ul>
        /// <li> <p>The resource type for health checks is <code>healthcheck</code>.</p> </li>
        /// <li> <p>The resource type for hosted zones is <code>hostedzone</code>.</p> </li>
        /// </ul>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::TagResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// Appends an item to `ResourceIds`.
        ///
        /// To override the contents of this collection use [`set_resource_ids`](Self::set_resource_ids).
        ///
        /// <p>A complex type that contains the ResourceId element for each resource for which you want to get a list of tags.</p>
        pub fn resource_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_ids(input.into());
            self
        }
        /// <p>A complex type that contains the ResourceId element for each resource for which you want to get a list of tags.</p>
        pub fn set_resource_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTrafficPolicies`.
    ///
    /// <p>Gets information about the latest version for every traffic policy that is associated with the current Amazon Web Services account. Policies are listed in the order that they were created in. </p>
    /// <p>For information about how of deleting a traffic policy affects the response from <code>ListTrafficPolicies</code>, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteTrafficPolicy.html">DeleteTrafficPolicy</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTrafficPolicies {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_traffic_policies_input::Builder,
    }
    impl ListTrafficPolicies {
        /// Creates a new `ListTrafficPolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTrafficPoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTrafficPoliciesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>(Conditional) For your first request to <code>ListTrafficPolicies</code>, don't include the <code>TrafficPolicyIdMarker</code> parameter.</p>
        /// <p>If you have more traffic policies than the value of <code>MaxItems</code>, <code>ListTrafficPolicies</code> returns only the first <code>MaxItems</code> traffic policies. To get the next group of policies, submit another request to <code>ListTrafficPolicies</code>. For the value of <code>TrafficPolicyIdMarker</code>, specify the value of <code>TrafficPolicyIdMarker</code> that was returned in the previous response.</p>
        pub fn traffic_policy_id_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.traffic_policy_id_marker(input.into());
            self
        }
        /// <p>(Conditional) For your first request to <code>ListTrafficPolicies</code>, don't include the <code>TrafficPolicyIdMarker</code> parameter.</p>
        /// <p>If you have more traffic policies than the value of <code>MaxItems</code>, <code>ListTrafficPolicies</code> returns only the first <code>MaxItems</code> traffic policies. To get the next group of policies, submit another request to <code>ListTrafficPolicies</code>. For the value of <code>TrafficPolicyIdMarker</code>, specify the value of <code>TrafficPolicyIdMarker</code> that was returned in the previous response.</p>
        pub fn set_traffic_policy_id_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_traffic_policy_id_marker(input);
            self
        }
        /// <p>(Optional) The maximum number of traffic policies that you want Amazon Route 53 to return in response to this request. If you have more than <code>MaxItems</code> traffic policies, the value of <code>IsTruncated</code> in the response is <code>true</code>, and the value of <code>TrafficPolicyIdMarker</code> is the ID of the first traffic policy that Route 53 will return if you submit another request.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>(Optional) The maximum number of traffic policies that you want Amazon Route 53 to return in response to this request. If you have more than <code>MaxItems</code> traffic policies, the value of <code>IsTruncated</code> in the response is <code>true</code>, and the value of <code>TrafficPolicyIdMarker</code> is the ID of the first traffic policy that Route 53 will return if you submit another request.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTrafficPolicyInstances`.
    ///
    /// <p>Gets information about the traffic policy instances that you created by using the current Amazon Web Services account.</p> <note>
    /// <p>After you submit an <code>UpdateTrafficPolicyInstance</code> request, there's a brief delay while Amazon Route 53 creates the resource record sets that are specified in the traffic policy definition. For more information, see the <code>State</code> response element.</p>
    /// </note>
    /// <p>Route 53 returns a maximum of 100 items in each response. If you have a lot of traffic policy instances, you can use the <code>MaxItems</code> parameter to list them in groups of up to 100.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTrafficPolicyInstances {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_traffic_policy_instances_input::Builder,
    }
    impl ListTrafficPolicyInstances {
        /// Creates a new `ListTrafficPolicyInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTrafficPolicyInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTrafficPolicyInstancesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>HostedZoneId</code>, specify the value of <code>HostedZoneIdMarker</code> from the previous response, which is the hosted zone ID of the first traffic policy instance in the next group of traffic policy instances.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn hosted_zone_id_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id_marker(input.into());
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>HostedZoneId</code>, specify the value of <code>HostedZoneIdMarker</code> from the previous response, which is the hosted zone ID of the first traffic policy instance in the next group of traffic policy instances.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn set_hosted_zone_id_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id_marker(input);
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancename</code>, specify the value of <code>TrafficPolicyInstanceNameMarker</code> from the previous response, which is the name of the first traffic policy instance in the next group of traffic policy instances.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn traffic_policy_instance_name_marker(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.traffic_policy_instance_name_marker(input.into());
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancename</code>, specify the value of <code>TrafficPolicyInstanceNameMarker</code> from the previous response, which is the name of the first traffic policy instance in the next group of traffic policy instances.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn set_traffic_policy_instance_name_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_traffic_policy_instance_name_marker(input);
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancetype</code>, specify the value of <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the type of the first traffic policy instance in the next group of traffic policy instances.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn traffic_policy_instance_type_marker(mut self, input: crate::model::RrType) -> Self {
            self.inner = self.inner.traffic_policy_instance_type_marker(input);
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancetype</code>, specify the value of <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the type of the first traffic policy instance in the next group of traffic policy instances.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn set_traffic_policy_instance_type_marker(
            mut self,
            input: std::option::Option<crate::model::RrType>,
        ) -> Self {
            self.inner = self.inner.set_traffic_policy_instance_type_marker(input);
            self
        }
        /// <p>The maximum number of traffic policy instances that you want Amazon Route 53 to return in response to a <code>ListTrafficPolicyInstances</code> request. If you have more than <code>MaxItems</code> traffic policy instances, the value of the <code>IsTruncated</code> element in the response is <code>true</code>, and the values of <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code> represent the first traffic policy instance in the next group of <code>MaxItems</code> traffic policy instances.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The maximum number of traffic policy instances that you want Amazon Route 53 to return in response to a <code>ListTrafficPolicyInstances</code> request. If you have more than <code>MaxItems</code> traffic policy instances, the value of the <code>IsTruncated</code> element in the response is <code>true</code>, and the values of <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code> represent the first traffic policy instance in the next group of <code>MaxItems</code> traffic policy instances.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTrafficPolicyInstancesByHostedZone`.
    ///
    /// <p>Gets information about the traffic policy instances that you created in a specified hosted zone.</p> <note>
    /// <p>After you submit a <code>CreateTrafficPolicyInstance</code> or an <code>UpdateTrafficPolicyInstance</code> request, there's a brief delay while Amazon Route 53 creates the resource record sets that are specified in the traffic policy definition. For more information, see the <code>State</code> response element.</p>
    /// </note>
    /// <p>Route 53 returns a maximum of 100 items in each response. If you have a lot of traffic policy instances, you can use the <code>MaxItems</code> parameter to list them in groups of up to 100.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTrafficPolicyInstancesByHostedZone {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_traffic_policy_instances_by_hosted_zone_input::Builder,
    }
    impl ListTrafficPolicyInstancesByHostedZone {
        /// Creates a new `ListTrafficPolicyInstancesByHostedZone`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTrafficPolicyInstancesByHostedZoneOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListTrafficPolicyInstancesByHostedZoneError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the hosted zone that you want to list traffic policy instances for.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>The ID of the hosted zone that you want to list traffic policy instances for.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response is true, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancename</code>, specify the value of <code>TrafficPolicyInstanceNameMarker</code> from the previous response, which is the name of the first traffic policy instance in the next group of traffic policy instances.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn traffic_policy_instance_name_marker(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.traffic_policy_instance_name_marker(input.into());
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response is true, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancename</code>, specify the value of <code>TrafficPolicyInstanceNameMarker</code> from the previous response, which is the name of the first traffic policy instance in the next group of traffic policy instances.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn set_traffic_policy_instance_name_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_traffic_policy_instance_name_marker(input);
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response is true, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancetype</code>, specify the value of <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the type of the first traffic policy instance in the next group of traffic policy instances.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn traffic_policy_instance_type_marker(mut self, input: crate::model::RrType) -> Self {
            self.inner = self.inner.traffic_policy_instance_type_marker(input);
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response is true, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancetype</code>, specify the value of <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the type of the first traffic policy instance in the next group of traffic policy instances.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn set_traffic_policy_instance_type_marker(
            mut self,
            input: std::option::Option<crate::model::RrType>,
        ) -> Self {
            self.inner = self.inner.set_traffic_policy_instance_type_marker(input);
            self
        }
        /// <p>The maximum number of traffic policy instances to be included in the response body for this request. If you have more than <code>MaxItems</code> traffic policy instances, the value of the <code>IsTruncated</code> element in the response is <code>true</code>, and the values of <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code> represent the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The maximum number of traffic policy instances to be included in the response body for this request. If you have more than <code>MaxItems</code> traffic policy instances, the value of the <code>IsTruncated</code> element in the response is <code>true</code>, and the values of <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code> represent the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTrafficPolicyInstancesByPolicy`.
    ///
    /// <p>Gets information about the traffic policy instances that you created by using a specify traffic policy version.</p> <note>
    /// <p>After you submit a <code>CreateTrafficPolicyInstance</code> or an <code>UpdateTrafficPolicyInstance</code> request, there's a brief delay while Amazon Route 53 creates the resource record sets that are specified in the traffic policy definition. For more information, see the <code>State</code> response element.</p>
    /// </note>
    /// <p>Route 53 returns a maximum of 100 items in each response. If you have a lot of traffic policy instances, you can use the <code>MaxItems</code> parameter to list them in groups of up to 100.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTrafficPolicyInstancesByPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_traffic_policy_instances_by_policy_input::Builder,
    }
    impl ListTrafficPolicyInstancesByPolicy {
        /// Creates a new `ListTrafficPolicyInstancesByPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTrafficPolicyInstancesByPolicyOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListTrafficPolicyInstancesByPolicyError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the traffic policy for which you want to list traffic policy instances.</p>
        pub fn traffic_policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.traffic_policy_id(input.into());
            self
        }
        /// <p>The ID of the traffic policy for which you want to list traffic policy instances.</p>
        pub fn set_traffic_policy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_traffic_policy_id(input);
            self
        }
        /// <p>The version of the traffic policy for which you want to list traffic policy instances. The version must be associated with the traffic policy that is specified by <code>TrafficPolicyId</code>.</p>
        pub fn traffic_policy_version(mut self, input: i32) -> Self {
            self.inner = self.inner.traffic_policy_version(input);
            self
        }
        /// <p>The version of the traffic policy for which you want to list traffic policy instances. The version must be associated with the traffic policy that is specified by <code>TrafficPolicyId</code>.</p>
        pub fn set_traffic_policy_version(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_traffic_policy_version(input);
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstancesByPolicy</code> request. </p>
        /// <p>For the value of <code>hostedzoneid</code>, specify the value of <code>HostedZoneIdMarker</code> from the previous response, which is the hosted zone ID of the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn hosted_zone_id_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id_marker(input.into());
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstancesByPolicy</code> request. </p>
        /// <p>For the value of <code>hostedzoneid</code>, specify the value of <code>HostedZoneIdMarker</code> from the previous response, which is the hosted zone ID of the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn set_hosted_zone_id_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id_marker(input);
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstancesByPolicy</code> request.</p>
        /// <p>For the value of <code>trafficpolicyinstancename</code>, specify the value of <code>TrafficPolicyInstanceNameMarker</code> from the previous response, which is the name of the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn traffic_policy_instance_name_marker(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.traffic_policy_instance_name_marker(input.into());
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstancesByPolicy</code> request.</p>
        /// <p>For the value of <code>trafficpolicyinstancename</code>, specify the value of <code>TrafficPolicyInstanceNameMarker</code> from the previous response, which is the name of the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn set_traffic_policy_instance_name_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_traffic_policy_instance_name_marker(input);
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstancesByPolicy</code> request.</p>
        /// <p>For the value of <code>trafficpolicyinstancetype</code>, specify the value of <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the name of the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn traffic_policy_instance_type_marker(mut self, input: crate::model::RrType) -> Self {
            self.inner = self.inner.traffic_policy_instance_type_marker(input);
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstancesByPolicy</code> request.</p>
        /// <p>For the value of <code>trafficpolicyinstancetype</code>, specify the value of <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the name of the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn set_traffic_policy_instance_type_marker(
            mut self,
            input: std::option::Option<crate::model::RrType>,
        ) -> Self {
            self.inner = self.inner.set_traffic_policy_instance_type_marker(input);
            self
        }
        /// <p>The maximum number of traffic policy instances to be included in the response body for this request. If you have more than <code>MaxItems</code> traffic policy instances, the value of the <code>IsTruncated</code> element in the response is <code>true</code>, and the values of <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code> represent the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The maximum number of traffic policy instances to be included in the response body for this request. If you have more than <code>MaxItems</code> traffic policy instances, the value of the <code>IsTruncated</code> element in the response is <code>true</code>, and the values of <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code> represent the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTrafficPolicyVersions`.
    ///
    /// <p>Gets information about all of the versions for a specified traffic policy.</p>
    /// <p>Traffic policy versions are listed in numerical order by <code>VersionNumber</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTrafficPolicyVersions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_traffic_policy_versions_input::Builder,
    }
    impl ListTrafficPolicyVersions {
        /// Creates a new `ListTrafficPolicyVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTrafficPolicyVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTrafficPolicyVersionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specify the value of <code>Id</code> of the traffic policy for which you want to list all versions.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>Specify the value of <code>Id</code> of the traffic policy for which you want to list all versions.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>For your first request to <code>ListTrafficPolicyVersions</code>, don't include the <code>TrafficPolicyVersionMarker</code> parameter.</p>
        /// <p>If you have more traffic policy versions than the value of <code>MaxItems</code>, <code>ListTrafficPolicyVersions</code> returns only the first group of <code>MaxItems</code> versions. To get more traffic policy versions, submit another <code>ListTrafficPolicyVersions</code> request. For the value of <code>TrafficPolicyVersionMarker</code>, specify the value of <code>TrafficPolicyVersionMarker</code> in the previous response.</p>
        pub fn traffic_policy_version_marker(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.traffic_policy_version_marker(input.into());
            self
        }
        /// <p>For your first request to <code>ListTrafficPolicyVersions</code>, don't include the <code>TrafficPolicyVersionMarker</code> parameter.</p>
        /// <p>If you have more traffic policy versions than the value of <code>MaxItems</code>, <code>ListTrafficPolicyVersions</code> returns only the first group of <code>MaxItems</code> versions. To get more traffic policy versions, submit another <code>ListTrafficPolicyVersions</code> request. For the value of <code>TrafficPolicyVersionMarker</code>, specify the value of <code>TrafficPolicyVersionMarker</code> in the previous response.</p>
        pub fn set_traffic_policy_version_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_traffic_policy_version_marker(input);
            self
        }
        /// <p>The maximum number of traffic policy versions that you want Amazon Route 53 to include in the response body for this request. If the specified traffic policy has more than <code>MaxItems</code> versions, the value of <code>IsTruncated</code> in the response is <code>true</code>, and the value of the <code>TrafficPolicyVersionMarker</code> element is the ID of the first version that Route 53 will return if you submit another request.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The maximum number of traffic policy versions that you want Amazon Route 53 to include in the response body for this request. If the specified traffic policy has more than <code>MaxItems</code> versions, the value of <code>IsTruncated</code> in the response is <code>true</code>, and the value of the <code>TrafficPolicyVersionMarker</code> element is the ID of the first version that Route 53 will return if you submit another request.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListVPCAssociationAuthorizations`.
    ///
    /// <p>Gets a list of the VPCs that were created by other accounts and that can be associated with a specified hosted zone because you've submitted one or more <code>CreateVPCAssociationAuthorization</code> requests. </p>
    /// <p>The response includes a <code>VPCs</code> element with a <code>VPC</code> child element for each VPC that can be associated with the hosted zone.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListVPCAssociationAuthorizations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_vpc_association_authorizations_input::Builder,
    }
    impl ListVPCAssociationAuthorizations {
        /// Creates a new `ListVPCAssociationAuthorizations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListVpcAssociationAuthorizationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListVPCAssociationAuthorizationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the hosted zone for which you want a list of VPCs that can be associated with the hosted zone.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>The ID of the hosted zone for which you want a list of VPCs that can be associated with the hosted zone.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
        /// <p> <i>Optional</i>: If a response includes a <code>NextToken</code> element, there are more VPCs that can be associated with the specified hosted zone. To get the next page of results, submit another request, and include the value of <code>NextToken</code> from the response in the <code>nexttoken</code> parameter in another <code>ListVPCAssociationAuthorizations</code> request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> <i>Optional</i>: If a response includes a <code>NextToken</code> element, there are more VPCs that can be associated with the specified hosted zone. To get the next page of results, submit another request, and include the value of <code>NextToken</code> from the response in the <code>nexttoken</code> parameter in another <code>ListVPCAssociationAuthorizations</code> request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> <i>Optional</i>: An integer that specifies the maximum number of VPCs that you want Amazon Route 53 to return. If you don't specify a value for <code>MaxResults</code>, Route 53 returns up to 50 VPCs per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> <i>Optional</i>: An integer that specifies the maximum number of VPCs that you want Amazon Route 53 to return. If you don't specify a value for <code>MaxResults</code>, Route 53 returns up to 50 VPCs per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TestDNSAnswer`.
    ///
    /// <p>Gets the value that Amazon Route 53 returns in response to a DNS request for a specified record name and type. You can optionally specify the IP address of a DNS resolver, an EDNS0 client subnet IP address, and a subnet mask. </p>
    /// <p>This call only supports querying public hosted zones.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TestDNSAnswer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::test_dns_answer_input::Builder,
    }
    impl TestDNSAnswer {
        /// Creates a new `TestDNSAnswer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TestDnsAnswerOutput,
            aws_smithy_http::result::SdkError<crate::error::TestDNSAnswerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the hosted zone that you want Amazon Route 53 to simulate a query for.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>The ID of the hosted zone that you want Amazon Route 53 to simulate a query for.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
        /// <p>The name of the resource record set that you want Amazon Route 53 to simulate a query for.</p>
        pub fn record_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.record_name(input.into());
            self
        }
        /// <p>The name of the resource record set that you want Amazon Route 53 to simulate a query for.</p>
        pub fn set_record_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_record_name(input);
            self
        }
        /// <p>The type of the resource record set.</p>
        pub fn record_type(mut self, input: crate::model::RrType) -> Self {
            self.inner = self.inner.record_type(input);
            self
        }
        /// <p>The type of the resource record set.</p>
        pub fn set_record_type(mut self, input: std::option::Option<crate::model::RrType>) -> Self {
            self.inner = self.inner.set_record_type(input);
            self
        }
        /// <p>If you want to simulate a request from a specific DNS resolver, specify the IP address for that resolver. If you omit this value, <code>TestDnsAnswer</code> uses the IP address of a DNS resolver in the Amazon Web Services US East (N. Virginia) Region (<code>us-east-1</code>).</p>
        pub fn resolver_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolver_ip(input.into());
            self
        }
        /// <p>If you want to simulate a request from a specific DNS resolver, specify the IP address for that resolver. If you omit this value, <code>TestDnsAnswer</code> uses the IP address of a DNS resolver in the Amazon Web Services US East (N. Virginia) Region (<code>us-east-1</code>).</p>
        pub fn set_resolver_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resolver_ip(input);
            self
        }
        /// <p>If the resolver that you specified for resolverip supports EDNS0, specify the IPv4 or IPv6 address of a client in the applicable location, for example, <code>192.0.2.44</code> or <code>2001:db8:85a3::8a2e:370:7334</code>.</p>
        pub fn edns0_client_subnet_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.edns0_client_subnet_ip(input.into());
            self
        }
        /// <p>If the resolver that you specified for resolverip supports EDNS0, specify the IPv4 or IPv6 address of a client in the applicable location, for example, <code>192.0.2.44</code> or <code>2001:db8:85a3::8a2e:370:7334</code>.</p>
        pub fn set_edns0_client_subnet_ip(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_edns0_client_subnet_ip(input);
            self
        }
        /// <p>If you specify an IP address for <code>edns0clientsubnetip</code>, you can optionally specify the number of bits of the IP address that you want the checking tool to include in the DNS query. For example, if you specify <code>192.0.2.44</code> for <code>edns0clientsubnetip</code> and <code>24</code> for <code>edns0clientsubnetmask</code>, the checking tool will simulate a request from 192.0.2.0/24. The default value is 24 bits for IPv4 addresses and 64 bits for IPv6 addresses.</p>
        /// <p>The range of valid values depends on whether <code>edns0clientsubnetip</code> is an IPv4 or an IPv6 address:</p>
        /// <ul>
        /// <li> <p> <b>IPv4</b>: Specify a value between 0 and 32</p> </li>
        /// <li> <p> <b>IPv6</b>: Specify a value between 0 and 128</p> </li>
        /// </ul>
        pub fn edns0_client_subnet_mask(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.edns0_client_subnet_mask(input.into());
            self
        }
        /// <p>If you specify an IP address for <code>edns0clientsubnetip</code>, you can optionally specify the number of bits of the IP address that you want the checking tool to include in the DNS query. For example, if you specify <code>192.0.2.44</code> for <code>edns0clientsubnetip</code> and <code>24</code> for <code>edns0clientsubnetmask</code>, the checking tool will simulate a request from 192.0.2.0/24. The default value is 24 bits for IPv4 addresses and 64 bits for IPv6 addresses.</p>
        /// <p>The range of valid values depends on whether <code>edns0clientsubnetip</code> is an IPv4 or an IPv6 address:</p>
        /// <ul>
        /// <li> <p> <b>IPv4</b>: Specify a value between 0 and 32</p> </li>
        /// <li> <p> <b>IPv6</b>: Specify a value between 0 and 128</p> </li>
        /// </ul>
        pub fn set_edns0_client_subnet_mask(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_edns0_client_subnet_mask(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateHealthCheck`.
    ///
    /// <p>Updates an existing health check. Note that some values can't be updated. </p>
    /// <p>For more information about updating health checks, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/health-checks-creating-deleting.html">Creating, Updating, and Deleting Health Checks</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateHealthCheck {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_health_check_input::Builder,
    }
    impl UpdateHealthCheck {
        /// Creates a new `UpdateHealthCheck`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateHealthCheckOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateHealthCheckError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the health check for which you want detailed information. When you created the health check, <code>CreateHealthCheck</code> returned the ID in the response, in the <code>HealthCheckId</code> element.</p>
        pub fn health_check_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.health_check_id(input.into());
            self
        }
        /// <p>The ID for the health check for which you want detailed information. When you created the health check, <code>CreateHealthCheck</code> returned the ID in the response, in the <code>HealthCheckId</code> element.</p>
        pub fn set_health_check_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_health_check_id(input);
            self
        }
        /// <p>A sequential counter that Amazon Route 53 sets to <code>1</code> when you create a health check and increments by 1 each time you update settings for the health check.</p>
        /// <p>We recommend that you use <code>GetHealthCheck</code> or <code>ListHealthChecks</code> to get the current value of <code>HealthCheckVersion</code> for the health check that you want to update, and that you include that value in your <code>UpdateHealthCheck</code> request. This prevents Route 53 from overwriting an intervening update:</p>
        /// <ul>
        /// <li> <p>If the value in the <code>UpdateHealthCheck</code> request matches the value of <code>HealthCheckVersion</code> in the health check, Route 53 updates the health check with the new settings.</p> </li>
        /// <li> <p>If the value of <code>HealthCheckVersion</code> in the health check is greater, the health check was changed after you got the version number. Route 53 does not update the health check, and it returns a <code>HealthCheckVersionMismatch</code> error.</p> </li>
        /// </ul>
        pub fn health_check_version(mut self, input: i64) -> Self {
            self.inner = self.inner.health_check_version(input);
            self
        }
        /// <p>A sequential counter that Amazon Route 53 sets to <code>1</code> when you create a health check and increments by 1 each time you update settings for the health check.</p>
        /// <p>We recommend that you use <code>GetHealthCheck</code> or <code>ListHealthChecks</code> to get the current value of <code>HealthCheckVersion</code> for the health check that you want to update, and that you include that value in your <code>UpdateHealthCheck</code> request. This prevents Route 53 from overwriting an intervening update:</p>
        /// <ul>
        /// <li> <p>If the value in the <code>UpdateHealthCheck</code> request matches the value of <code>HealthCheckVersion</code> in the health check, Route 53 updates the health check with the new settings.</p> </li>
        /// <li> <p>If the value of <code>HealthCheckVersion</code> in the health check is greater, the health check was changed after you got the version number. Route 53 does not update the health check, and it returns a <code>HealthCheckVersionMismatch</code> error.</p> </li>
        /// </ul>
        pub fn set_health_check_version(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_health_check_version(input);
            self
        }
        /// <p>The IPv4 or IPv6 IP address for the endpoint that you want Amazon Route 53 to perform health checks on. If you don't specify a value for <code>IPAddress</code>, Route 53 sends a DNS request to resolve the domain name that you specify in <code>FullyQualifiedDomainName</code> at the interval that you specify in <code>RequestInterval</code>. Using an IP address that is returned by DNS, Route 53 then checks the health of the endpoint.</p>
        /// <p>Use one of the following formats for the value of <code>IPAddress</code>: </p>
        /// <ul>
        /// <li> <p> <b>IPv4 address</b>: four values between 0 and 255, separated by periods (.), for example, <code>192.0.2.44</code>.</p> </li>
        /// <li> <p> <b>IPv6 address</b>: eight groups of four hexadecimal values, separated by colons (:), for example, <code>2001:0db8:85a3:0000:0000:abcd:0001:2345</code>. You can also shorten IPv6 addresses as described in RFC 5952, for example, <code>2001:db8:85a3::abcd:1:2345</code>.</p> </li>
        /// </ul>
        /// <p>If the endpoint is an EC2 instance, we recommend that you create an Elastic IP address, associate it with your EC2 instance, and specify the Elastic IP address for <code>IPAddress</code>. This ensures that the IP address of your instance never changes. For more information, see the applicable documentation:</p>
        /// <ul>
        /// <li> <p>Linux: <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses (EIP)</a> in the <i>Amazon EC2 User Guide for Linux Instances</i> </p> </li>
        /// <li> <p>Windows: <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses (EIP)</a> in the <i>Amazon EC2 User Guide for Windows Instances</i> </p> </li>
        /// </ul> <note>
        /// <p>If a health check already has a value for <code>IPAddress</code>, you can change the value. However, you can't update an existing health check to add or remove the value of <code>IPAddress</code>. </p>
        /// </note>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-FullyQualifiedDomainName">FullyQualifiedDomainName</a>. </p>
        /// <p>Constraints: Route 53 can't check the health of endpoints for which the IP address is in local, private, non-routable, or multicast ranges. For more information about IP addresses for which you can't create health checks, see the following documents:</p>
        /// <ul>
        /// <li> <p> <a href="https://tools.ietf.org/html/rfc5735">RFC 5735, Special Use IPv4 Addresses</a> </p> </li>
        /// <li> <p> <a href="https://tools.ietf.org/html/rfc6598">RFC 6598, IANA-Reserved IPv4 Prefix for Shared Address Space</a> </p> </li>
        /// <li> <p> <a href="https://tools.ietf.org/html/rfc5156">RFC 5156, Special-Use IPv6 Addresses</a> </p> </li>
        /// </ul>
        pub fn ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ip_address(input.into());
            self
        }
        /// <p>The IPv4 or IPv6 IP address for the endpoint that you want Amazon Route 53 to perform health checks on. If you don't specify a value for <code>IPAddress</code>, Route 53 sends a DNS request to resolve the domain name that you specify in <code>FullyQualifiedDomainName</code> at the interval that you specify in <code>RequestInterval</code>. Using an IP address that is returned by DNS, Route 53 then checks the health of the endpoint.</p>
        /// <p>Use one of the following formats for the value of <code>IPAddress</code>: </p>
        /// <ul>
        /// <li> <p> <b>IPv4 address</b>: four values between 0 and 255, separated by periods (.), for example, <code>192.0.2.44</code>.</p> </li>
        /// <li> <p> <b>IPv6 address</b>: eight groups of four hexadecimal values, separated by colons (:), for example, <code>2001:0db8:85a3:0000:0000:abcd:0001:2345</code>. You can also shorten IPv6 addresses as described in RFC 5952, for example, <code>2001:db8:85a3::abcd:1:2345</code>.</p> </li>
        /// </ul>
        /// <p>If the endpoint is an EC2 instance, we recommend that you create an Elastic IP address, associate it with your EC2 instance, and specify the Elastic IP address for <code>IPAddress</code>. This ensures that the IP address of your instance never changes. For more information, see the applicable documentation:</p>
        /// <ul>
        /// <li> <p>Linux: <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses (EIP)</a> in the <i>Amazon EC2 User Guide for Linux Instances</i> </p> </li>
        /// <li> <p>Windows: <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses (EIP)</a> in the <i>Amazon EC2 User Guide for Windows Instances</i> </p> </li>
        /// </ul> <note>
        /// <p>If a health check already has a value for <code>IPAddress</code>, you can change the value. However, you can't update an existing health check to add or remove the value of <code>IPAddress</code>. </p>
        /// </note>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-FullyQualifiedDomainName">FullyQualifiedDomainName</a>. </p>
        /// <p>Constraints: Route 53 can't check the health of endpoints for which the IP address is in local, private, non-routable, or multicast ranges. For more information about IP addresses for which you can't create health checks, see the following documents:</p>
        /// <ul>
        /// <li> <p> <a href="https://tools.ietf.org/html/rfc5735">RFC 5735, Special Use IPv4 Addresses</a> </p> </li>
        /// <li> <p> <a href="https://tools.ietf.org/html/rfc6598">RFC 6598, IANA-Reserved IPv4 Prefix for Shared Address Space</a> </p> </li>
        /// <li> <p> <a href="https://tools.ietf.org/html/rfc5156">RFC 5156, Special-Use IPv6 Addresses</a> </p> </li>
        /// </ul>
        pub fn set_ip_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ip_address(input);
            self
        }
        /// <p>The port on the endpoint that you want Amazon Route 53 to perform health checks on.</p> <note>
        /// <p>Don't specify a value for <code>Port</code> when you specify a value for <code>Type</code> of <code>CLOUDWATCH_METRIC</code> or <code>CALCULATED</code>.</p>
        /// </note>
        pub fn port(mut self, input: i32) -> Self {
            self.inner = self.inner.port(input);
            self
        }
        /// <p>The port on the endpoint that you want Amazon Route 53 to perform health checks on.</p> <note>
        /// <p>Don't specify a value for <code>Port</code> when you specify a value for <code>Type</code> of <code>CLOUDWATCH_METRIC</code> or <code>CALCULATED</code>.</p>
        /// </note>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_port(input);
            self
        }
        /// <p>The path that you want Amazon Route 53 to request when performing health checks. The path can be any value for which your endpoint will return an HTTP status code of 2xx or 3xx when the endpoint is healthy, for example the file /docs/route53-health-check.html. You can also include query string parameters, for example, <code>/welcome.html?language=jp&amp;login=y</code>. </p>
        /// <p>Specify this value only if you want to change it.</p>
        pub fn resource_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_path(input.into());
            self
        }
        /// <p>The path that you want Amazon Route 53 to request when performing health checks. The path can be any value for which your endpoint will return an HTTP status code of 2xx or 3xx when the endpoint is healthy, for example the file /docs/route53-health-check.html. You can also include query string parameters, for example, <code>/welcome.html?language=jp&amp;login=y</code>. </p>
        /// <p>Specify this value only if you want to change it.</p>
        pub fn set_resource_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_path(input);
            self
        }
        /// <p>Amazon Route 53 behavior depends on whether you specify a value for <code>IPAddress</code>.</p> <note>
        /// <p>If a health check already has a value for <code>IPAddress</code>, you can change the value. However, you can't update an existing health check to add or remove the value of <code>IPAddress</code>. </p>
        /// </note>
        /// <p> <b>If you specify a value for</b> <code>IPAddress</code>:</p>
        /// <p>Route 53 sends health check requests to the specified IPv4 or IPv6 address and passes the value of <code>FullyQualifiedDomainName</code> in the <code>Host</code> header for all health checks except TCP health checks. This is typically the fully qualified DNS name of the endpoint on which you want Route 53 to perform health checks.</p>
        /// <p>When Route 53 checks the health of an endpoint, here is how it constructs the <code>Host</code> header:</p>
        /// <ul>
        /// <li> <p>If you specify a value of <code>80</code> for <code>Port</code> and <code>HTTP</code> or <code>HTTP_STR_MATCH</code> for <code>Type</code>, Route 53 passes the value of <code>FullyQualifiedDomainName</code> to the endpoint in the <code>Host</code> header.</p> </li>
        /// <li> <p>If you specify a value of <code>443</code> for <code>Port</code> and <code>HTTPS</code> or <code>HTTPS_STR_MATCH</code> for <code>Type</code>, Route 53 passes the value of <code>FullyQualifiedDomainName</code> to the endpoint in the <code>Host</code> header.</p> </li>
        /// <li> <p>If you specify another value for <code>Port</code> and any value except <code>TCP</code> for <code>Type</code>, Route 53 passes <i> <code>FullyQualifiedDomainName</code>:<code>Port</code> </i> to the endpoint in the <code>Host</code> header.</p> </li>
        /// </ul>
        /// <p>If you don't specify a value for <code>FullyQualifiedDomainName</code>, Route 53 substitutes the value of <code>IPAddress</code> in the <code>Host</code> header in each of the above cases.</p>
        /// <p> <b>If you don't specify a value for</b> <code>IPAddress</code>:</p>
        /// <p>If you don't specify a value for <code>IPAddress</code>, Route 53 sends a DNS request to the domain that you specify in <code>FullyQualifiedDomainName</code> at the interval you specify in <code>RequestInterval</code>. Using an IPv4 address that is returned by DNS, Route 53 then checks the health of the endpoint.</p> <note>
        /// <p>If you don't specify a value for <code>IPAddress</code>, Route 53 uses only IPv4 to send health checks to the endpoint. If there's no resource record set with a type of A for the name that you specify for <code>FullyQualifiedDomainName</code>, the health check fails with a "DNS resolution failed" error.</p>
        /// </note>
        /// <p>If you want to check the health of weighted, latency, or failover resource record sets and you choose to specify the endpoint only by <code>FullyQualifiedDomainName</code>, we recommend that you create a separate health check for each endpoint. For example, create a health check for each HTTP server that is serving content for www.example.com. For the value of <code>FullyQualifiedDomainName</code>, specify the domain name of the server (such as <code>us-east-2-www.example.com</code>), not the name of the resource record sets (www.example.com).</p> <important>
        /// <p>In this configuration, if the value of <code>FullyQualifiedDomainName</code> matches the name of the resource record sets and you then associate the health check with those resource record sets, health check results will be unpredictable.</p>
        /// </important>
        /// <p>In addition, if the value of <code>Type</code> is <code>HTTP</code>, <code>HTTPS</code>, <code>HTTP_STR_MATCH</code>, or <code>HTTPS_STR_MATCH</code>, Route 53 passes the value of <code>FullyQualifiedDomainName</code> in the <code>Host</code> header, as it does when you specify a value for <code>IPAddress</code>. If the value of <code>Type</code> is <code>TCP</code>, Route 53 doesn't pass a <code>Host</code> header.</p>
        pub fn fully_qualified_domain_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.fully_qualified_domain_name(input.into());
            self
        }
        /// <p>Amazon Route 53 behavior depends on whether you specify a value for <code>IPAddress</code>.</p> <note>
        /// <p>If a health check already has a value for <code>IPAddress</code>, you can change the value. However, you can't update an existing health check to add or remove the value of <code>IPAddress</code>. </p>
        /// </note>
        /// <p> <b>If you specify a value for</b> <code>IPAddress</code>:</p>
        /// <p>Route 53 sends health check requests to the specified IPv4 or IPv6 address and passes the value of <code>FullyQualifiedDomainName</code> in the <code>Host</code> header for all health checks except TCP health checks. This is typically the fully qualified DNS name of the endpoint on which you want Route 53 to perform health checks.</p>
        /// <p>When Route 53 checks the health of an endpoint, here is how it constructs the <code>Host</code> header:</p>
        /// <ul>
        /// <li> <p>If you specify a value of <code>80</code> for <code>Port</code> and <code>HTTP</code> or <code>HTTP_STR_MATCH</code> for <code>Type</code>, Route 53 passes the value of <code>FullyQualifiedDomainName</code> to the endpoint in the <code>Host</code> header.</p> </li>
        /// <li> <p>If you specify a value of <code>443</code> for <code>Port</code> and <code>HTTPS</code> or <code>HTTPS_STR_MATCH</code> for <code>Type</code>, Route 53 passes the value of <code>FullyQualifiedDomainName</code> to the endpoint in the <code>Host</code> header.</p> </li>
        /// <li> <p>If you specify another value for <code>Port</code> and any value except <code>TCP</code> for <code>Type</code>, Route 53 passes <i> <code>FullyQualifiedDomainName</code>:<code>Port</code> </i> to the endpoint in the <code>Host</code> header.</p> </li>
        /// </ul>
        /// <p>If you don't specify a value for <code>FullyQualifiedDomainName</code>, Route 53 substitutes the value of <code>IPAddress</code> in the <code>Host</code> header in each of the above cases.</p>
        /// <p> <b>If you don't specify a value for</b> <code>IPAddress</code>:</p>
        /// <p>If you don't specify a value for <code>IPAddress</code>, Route 53 sends a DNS request to the domain that you specify in <code>FullyQualifiedDomainName</code> at the interval you specify in <code>RequestInterval</code>. Using an IPv4 address that is returned by DNS, Route 53 then checks the health of the endpoint.</p> <note>
        /// <p>If you don't specify a value for <code>IPAddress</code>, Route 53 uses only IPv4 to send health checks to the endpoint. If there's no resource record set with a type of A for the name that you specify for <code>FullyQualifiedDomainName</code>, the health check fails with a "DNS resolution failed" error.</p>
        /// </note>
        /// <p>If you want to check the health of weighted, latency, or failover resource record sets and you choose to specify the endpoint only by <code>FullyQualifiedDomainName</code>, we recommend that you create a separate health check for each endpoint. For example, create a health check for each HTTP server that is serving content for www.example.com. For the value of <code>FullyQualifiedDomainName</code>, specify the domain name of the server (such as <code>us-east-2-www.example.com</code>), not the name of the resource record sets (www.example.com).</p> <important>
        /// <p>In this configuration, if the value of <code>FullyQualifiedDomainName</code> matches the name of the resource record sets and you then associate the health check with those resource record sets, health check results will be unpredictable.</p>
        /// </important>
        /// <p>In addition, if the value of <code>Type</code> is <code>HTTP</code>, <code>HTTPS</code>, <code>HTTP_STR_MATCH</code>, or <code>HTTPS_STR_MATCH</code>, Route 53 passes the value of <code>FullyQualifiedDomainName</code> in the <code>Host</code> header, as it does when you specify a value for <code>IPAddress</code>. If the value of <code>Type</code> is <code>TCP</code>, Route 53 doesn't pass a <code>Host</code> header.</p>
        pub fn set_fully_qualified_domain_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_fully_qualified_domain_name(input);
            self
        }
        /// <p>If the value of <code>Type</code> is <code>HTTP_STR_MATCH</code> or <code>HTTPS_STR_MATCH</code>, the string that you want Amazon Route 53 to search for in the response body from the specified resource. If the string appears in the response body, Route 53 considers the resource healthy. (You can't change the value of <code>Type</code> when you update a health check.)</p>
        pub fn search_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.search_string(input.into());
            self
        }
        /// <p>If the value of <code>Type</code> is <code>HTTP_STR_MATCH</code> or <code>HTTPS_STR_MATCH</code>, the string that you want Amazon Route 53 to search for in the response body from the specified resource. If the string appears in the response body, Route 53 considers the resource healthy. (You can't change the value of <code>Type</code> when you update a health check.)</p>
        pub fn set_search_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_search_string(input);
            self
        }
        /// <p>The number of consecutive health checks that an endpoint must pass or fail for Amazon Route 53 to change the current status of the endpoint from unhealthy to healthy or vice versa. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How Amazon Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>If you don't specify a value for <code>FailureThreshold</code>, the default value is three health checks.</p>
        pub fn failure_threshold(mut self, input: i32) -> Self {
            self.inner = self.inner.failure_threshold(input);
            self
        }
        /// <p>The number of consecutive health checks that an endpoint must pass or fail for Amazon Route 53 to change the current status of the endpoint from unhealthy to healthy or vice versa. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How Amazon Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>If you don't specify a value for <code>FailureThreshold</code>, the default value is three health checks.</p>
        pub fn set_failure_threshold(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_failure_threshold(input);
            self
        }
        /// <p>Specify whether you want Amazon Route 53 to invert the status of a health check, for example, to consider a health check unhealthy when it otherwise would be considered healthy.</p>
        pub fn inverted(mut self, input: bool) -> Self {
            self.inner = self.inner.inverted(input);
            self
        }
        /// <p>Specify whether you want Amazon Route 53 to invert the status of a health check, for example, to consider a health check unhealthy when it otherwise would be considered healthy.</p>
        pub fn set_inverted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_inverted(input);
            self
        }
        /// <p>Stops Route 53 from performing health checks. When you disable a health check, here's what happens:</p>
        /// <ul>
        /// <li> <p> <b>Health checks that check the health of endpoints:</b> Route 53 stops submitting requests to your application, server, or other resource.</p> </li>
        /// <li> <p> <b>Calculated health checks:</b> Route 53 stops aggregating the status of the referenced health checks.</p> </li>
        /// <li> <p> <b>Health checks that monitor CloudWatch alarms:</b> Route 53 stops monitoring the corresponding CloudWatch metrics.</p> </li>
        /// </ul>
        /// <p>After you disable a health check, Route 53 considers the status of the health check to always be healthy. If you configured DNS failover, Route 53 continues to route traffic to the corresponding resources. If you want to stop routing traffic to a resource, change the value of <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-Inverted">Inverted</a>. </p>
        /// <p>Charges for a health check still apply when the health check is disabled. For more information, see <a href="http://aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a>.</p>
        pub fn disabled(mut self, input: bool) -> Self {
            self.inner = self.inner.disabled(input);
            self
        }
        /// <p>Stops Route 53 from performing health checks. When you disable a health check, here's what happens:</p>
        /// <ul>
        /// <li> <p> <b>Health checks that check the health of endpoints:</b> Route 53 stops submitting requests to your application, server, or other resource.</p> </li>
        /// <li> <p> <b>Calculated health checks:</b> Route 53 stops aggregating the status of the referenced health checks.</p> </li>
        /// <li> <p> <b>Health checks that monitor CloudWatch alarms:</b> Route 53 stops monitoring the corresponding CloudWatch metrics.</p> </li>
        /// </ul>
        /// <p>After you disable a health check, Route 53 considers the status of the health check to always be healthy. If you configured DNS failover, Route 53 continues to route traffic to the corresponding resources. If you want to stop routing traffic to a resource, change the value of <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-Inverted">Inverted</a>. </p>
        /// <p>Charges for a health check still apply when the health check is disabled. For more information, see <a href="http://aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a>.</p>
        pub fn set_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_disabled(input);
            self
        }
        /// <p>The number of child health checks that are associated with a <code>CALCULATED</code> health that Amazon Route 53 must consider healthy for the <code>CALCULATED</code> health check to be considered healthy. To specify the child health checks that you want to associate with a <code>CALCULATED</code> health check, use the <code>ChildHealthChecks</code> and <code>ChildHealthCheck</code> elements.</p>
        /// <p>Note the following:</p>
        /// <ul>
        /// <li> <p>If you specify a number greater than the number of child health checks, Route 53 always considers this health check to be unhealthy.</p> </li>
        /// <li> <p>If you specify <code>0</code>, Route 53 always considers this health check to be healthy.</p> </li>
        /// </ul>
        pub fn health_threshold(mut self, input: i32) -> Self {
            self.inner = self.inner.health_threshold(input);
            self
        }
        /// <p>The number of child health checks that are associated with a <code>CALCULATED</code> health that Amazon Route 53 must consider healthy for the <code>CALCULATED</code> health check to be considered healthy. To specify the child health checks that you want to associate with a <code>CALCULATED</code> health check, use the <code>ChildHealthChecks</code> and <code>ChildHealthCheck</code> elements.</p>
        /// <p>Note the following:</p>
        /// <ul>
        /// <li> <p>If you specify a number greater than the number of child health checks, Route 53 always considers this health check to be unhealthy.</p> </li>
        /// <li> <p>If you specify <code>0</code>, Route 53 always considers this health check to be healthy.</p> </li>
        /// </ul>
        pub fn set_health_threshold(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_health_threshold(input);
            self
        }
        /// Appends an item to `ChildHealthChecks`.
        ///
        /// To override the contents of this collection use [`set_child_health_checks`](Self::set_child_health_checks).
        ///
        /// <p>A complex type that contains one <code>ChildHealthCheck</code> element for each health check that you want to associate with a <code>CALCULATED</code> health check.</p>
        pub fn child_health_checks(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.child_health_checks(input.into());
            self
        }
        /// <p>A complex type that contains one <code>ChildHealthCheck</code> element for each health check that you want to associate with a <code>CALCULATED</code> health check.</p>
        pub fn set_child_health_checks(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_child_health_checks(input);
            self
        }
        /// <p>Specify whether you want Amazon Route 53 to send the value of <code>FullyQualifiedDomainName</code> to the endpoint in the <code>client_hello</code> message during <code>TLS</code> negotiation. This allows the endpoint to respond to <code>HTTPS</code> health check requests with the applicable SSL/TLS certificate.</p>
        /// <p>Some endpoints require that HTTPS requests include the host name in the <code>client_hello</code> message. If you don't enable SNI, the status of the health check will be SSL alert <code>handshake_failure</code>. A health check can also have that status for other reasons. If SNI is enabled and you're still getting the error, check the SSL/TLS configuration on your endpoint and confirm that your certificate is valid.</p>
        /// <p>The SSL/TLS certificate on your endpoint includes a domain name in the <code>Common Name</code> field and possibly several more in the <code>Subject Alternative Names</code> field. One of the domain names in the certificate should match the value that you specify for <code>FullyQualifiedDomainName</code>. If the endpoint responds to the <code>client_hello</code> message with a certificate that does not include the domain name that you specified in <code>FullyQualifiedDomainName</code>, a health checker will retry the handshake. In the second attempt, the health checker will omit <code>FullyQualifiedDomainName</code> from the <code>client_hello</code> message.</p>
        pub fn enable_sni(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_sni(input);
            self
        }
        /// <p>Specify whether you want Amazon Route 53 to send the value of <code>FullyQualifiedDomainName</code> to the endpoint in the <code>client_hello</code> message during <code>TLS</code> negotiation. This allows the endpoint to respond to <code>HTTPS</code> health check requests with the applicable SSL/TLS certificate.</p>
        /// <p>Some endpoints require that HTTPS requests include the host name in the <code>client_hello</code> message. If you don't enable SNI, the status of the health check will be SSL alert <code>handshake_failure</code>. A health check can also have that status for other reasons. If SNI is enabled and you're still getting the error, check the SSL/TLS configuration on your endpoint and confirm that your certificate is valid.</p>
        /// <p>The SSL/TLS certificate on your endpoint includes a domain name in the <code>Common Name</code> field and possibly several more in the <code>Subject Alternative Names</code> field. One of the domain names in the certificate should match the value that you specify for <code>FullyQualifiedDomainName</code>. If the endpoint responds to the <code>client_hello</code> message with a certificate that does not include the domain name that you specified in <code>FullyQualifiedDomainName</code>, a health checker will retry the handshake. In the second attempt, the health checker will omit <code>FullyQualifiedDomainName</code> from the <code>client_hello</code> message.</p>
        pub fn set_enable_sni(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_sni(input);
            self
        }
        /// Appends an item to `Regions`.
        ///
        /// To override the contents of this collection use [`set_regions`](Self::set_regions).
        ///
        /// <p>A complex type that contains one <code>Region</code> element for each region that you want Amazon Route 53 health checkers to check the specified endpoint from.</p>
        pub fn regions(mut self, input: crate::model::HealthCheckRegion) -> Self {
            self.inner = self.inner.regions(input);
            self
        }
        /// <p>A complex type that contains one <code>Region</code> element for each region that you want Amazon Route 53 health checkers to check the specified endpoint from.</p>
        pub fn set_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HealthCheckRegion>>,
        ) -> Self {
            self.inner = self.inner.set_regions(input);
            self
        }
        /// <p>A complex type that identifies the CloudWatch alarm that you want Amazon Route 53 health checkers to use to determine whether the specified health check is healthy.</p>
        pub fn alarm_identifier(mut self, input: crate::model::AlarmIdentifier) -> Self {
            self.inner = self.inner.alarm_identifier(input);
            self
        }
        /// <p>A complex type that identifies the CloudWatch alarm that you want Amazon Route 53 health checkers to use to determine whether the specified health check is healthy.</p>
        pub fn set_alarm_identifier(
            mut self,
            input: std::option::Option<crate::model::AlarmIdentifier>,
        ) -> Self {
            self.inner = self.inner.set_alarm_identifier(input);
            self
        }
        /// <p>When CloudWatch has insufficient data about the metric to determine the alarm state, the status that you want Amazon Route 53 to assign to the health check:</p>
        /// <ul>
        /// <li> <p> <code>Healthy</code>: Route 53 considers the health check to be healthy.</p> </li>
        /// <li> <p> <code>Unhealthy</code>: Route 53 considers the health check to be unhealthy.</p> </li>
        /// <li> <p> <code>LastKnownStatus</code>: By default, Route 53 uses the status of the health check from the last time CloudWatch had sufficient data to determine the alarm state. For new health checks that have no last known status, the status for the health check is healthy.</p> </li>
        /// </ul>
        pub fn insufficient_data_health_status(
            mut self,
            input: crate::model::InsufficientDataHealthStatus,
        ) -> Self {
            self.inner = self.inner.insufficient_data_health_status(input);
            self
        }
        /// <p>When CloudWatch has insufficient data about the metric to determine the alarm state, the status that you want Amazon Route 53 to assign to the health check:</p>
        /// <ul>
        /// <li> <p> <code>Healthy</code>: Route 53 considers the health check to be healthy.</p> </li>
        /// <li> <p> <code>Unhealthy</code>: Route 53 considers the health check to be unhealthy.</p> </li>
        /// <li> <p> <code>LastKnownStatus</code>: By default, Route 53 uses the status of the health check from the last time CloudWatch had sufficient data to determine the alarm state. For new health checks that have no last known status, the status for the health check is healthy.</p> </li>
        /// </ul>
        pub fn set_insufficient_data_health_status(
            mut self,
            input: std::option::Option<crate::model::InsufficientDataHealthStatus>,
        ) -> Self {
            self.inner = self.inner.set_insufficient_data_health_status(input);
            self
        }
        /// Appends an item to `ResetElements`.
        ///
        /// To override the contents of this collection use [`set_reset_elements`](Self::set_reset_elements).
        ///
        /// <p>A complex type that contains one <code>ResettableElementName</code> element for each element that you want to reset to the default value. Valid values for <code>ResettableElementName</code> include the following:</p>
        /// <ul>
        /// <li> <p> <code>ChildHealthChecks</code>: Amazon Route 53 resets <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-ChildHealthChecks">ChildHealthChecks</a> to null.</p> </li>
        /// <li> <p> <code>FullyQualifiedDomainName</code>: Route 53 resets <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-FullyQualifiedDomainName">FullyQualifiedDomainName</a>. to null.</p> </li>
        /// <li> <p> <code>Regions</code>: Route 53 resets the <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-Regions">Regions</a> list to the default set of regions. </p> </li>
        /// <li> <p> <code>ResourcePath</code>: Route 53 resets <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-ResourcePath">ResourcePath</a> to null.</p> </li>
        /// </ul>
        pub fn reset_elements(mut self, input: crate::model::ResettableElementName) -> Self {
            self.inner = self.inner.reset_elements(input);
            self
        }
        /// <p>A complex type that contains one <code>ResettableElementName</code> element for each element that you want to reset to the default value. Valid values for <code>ResettableElementName</code> include the following:</p>
        /// <ul>
        /// <li> <p> <code>ChildHealthChecks</code>: Amazon Route 53 resets <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-ChildHealthChecks">ChildHealthChecks</a> to null.</p> </li>
        /// <li> <p> <code>FullyQualifiedDomainName</code>: Route 53 resets <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-FullyQualifiedDomainName">FullyQualifiedDomainName</a>. to null.</p> </li>
        /// <li> <p> <code>Regions</code>: Route 53 resets the <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-Regions">Regions</a> list to the default set of regions. </p> </li>
        /// <li> <p> <code>ResourcePath</code>: Route 53 resets <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-ResourcePath">ResourcePath</a> to null.</p> </li>
        /// </ul>
        pub fn set_reset_elements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResettableElementName>>,
        ) -> Self {
            self.inner = self.inner.set_reset_elements(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateHostedZoneComment`.
    ///
    /// <p>Updates the comment for a specified hosted zone.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateHostedZoneComment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_hosted_zone_comment_input::Builder,
    }
    impl UpdateHostedZoneComment {
        /// Creates a new `UpdateHostedZoneComment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateHostedZoneCommentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateHostedZoneCommentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the hosted zone that you want to update the comment for.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID for the hosted zone that you want to update the comment for.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The new comment for the hosted zone. If you don't specify a value for <code>Comment</code>, Amazon Route 53 deletes the existing value of the <code>Comment</code> element, if any.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.comment(input.into());
            self
        }
        /// <p>The new comment for the hosted zone. If you don't specify a value for <code>Comment</code>, Amazon Route 53 deletes the existing value of the <code>Comment</code> element, if any.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_comment(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTrafficPolicyComment`.
    ///
    /// <p>Updates the comment for a specified traffic policy version.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateTrafficPolicyComment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_traffic_policy_comment_input::Builder,
    }
    impl UpdateTrafficPolicyComment {
        /// Creates a new `UpdateTrafficPolicyComment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTrafficPolicyCommentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTrafficPolicyCommentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The value of <code>Id</code> for the traffic policy that you want to update the comment for.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The value of <code>Id</code> for the traffic policy that you want to update the comment for.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The value of <code>Version</code> for the traffic policy that you want to update the comment for.</p>
        pub fn version(mut self, input: i32) -> Self {
            self.inner = self.inner.version(input);
            self
        }
        /// <p>The value of <code>Version</code> for the traffic policy that you want to update the comment for.</p>
        pub fn set_version(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
        /// <p>The new comment for the specified traffic policy and version.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.comment(input.into());
            self
        }
        /// <p>The new comment for the specified traffic policy and version.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_comment(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTrafficPolicyInstance`.
    ///
    /// <p>Updates the resource record sets in a specified hosted zone that were created based on the settings in a specified traffic policy version.</p>
    /// <p>When you update a traffic policy instance, Amazon Route 53 continues to respond to DNS queries for the root resource record set name (such as example.com) while it replaces one group of resource record sets with another. Route 53 performs the following operations:</p>
    /// <ol>
    /// <li> <p>Route 53 creates a new group of resource record sets based on the specified traffic policy. This is true regardless of how significant the differences are between the existing resource record sets and the new resource record sets. </p> </li>
    /// <li> <p>When all of the new resource record sets have been created, Route 53 starts to respond to DNS queries for the root resource record set name (such as example.com) by using the new resource record sets.</p> </li>
    /// <li> <p>Route 53 deletes the old group of resource record sets that are associated with the root resource record set name.</p> </li>
    /// </ol>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateTrafficPolicyInstance {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_traffic_policy_instance_input::Builder,
    }
    impl UpdateTrafficPolicyInstance {
        /// Creates a new `UpdateTrafficPolicyInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTrafficPolicyInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTrafficPolicyInstanceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the traffic policy instance that you want to update.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the traffic policy instance that you want to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The TTL that you want Amazon Route 53 to assign to all of the updated resource record sets.</p>
        pub fn ttl(mut self, input: i64) -> Self {
            self.inner = self.inner.ttl(input);
            self
        }
        /// <p>The TTL that you want Amazon Route 53 to assign to all of the updated resource record sets.</p>
        pub fn set_ttl(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_ttl(input);
            self
        }
        /// <p>The ID of the traffic policy that you want Amazon Route 53 to use to update resource record sets for the specified traffic policy instance.</p>
        pub fn traffic_policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.traffic_policy_id(input.into());
            self
        }
        /// <p>The ID of the traffic policy that you want Amazon Route 53 to use to update resource record sets for the specified traffic policy instance.</p>
        pub fn set_traffic_policy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_traffic_policy_id(input);
            self
        }
        /// <p>The version of the traffic policy that you want Amazon Route 53 to use to update resource record sets for the specified traffic policy instance.</p>
        pub fn traffic_policy_version(mut self, input: i32) -> Self {
            self.inner = self.inner.traffic_policy_version(input);
            self
        }
        /// <p>The version of the traffic policy that you want Amazon Route 53 to use to update resource record sets for the specified traffic policy instance.</p>
        pub fn set_traffic_policy_version(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_traffic_policy_version(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
