// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>A complex type that contains information about the resource record sets that Amazon Route 53 created based on a specified traffic policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTrafficPolicyInstanceOutput {
    /// <p>A complex type that contains settings for the updated traffic policy instance.</p>
    pub traffic_policy_instance: std::option::Option<crate::model::TrafficPolicyInstance>,
}
impl UpdateTrafficPolicyInstanceOutput {
    /// <p>A complex type that contains settings for the updated traffic policy instance.</p>
    pub fn traffic_policy_instance(
        &self,
    ) -> std::option::Option<&crate::model::TrafficPolicyInstance> {
        self.traffic_policy_instance.as_ref()
    }
}
impl std::fmt::Debug for UpdateTrafficPolicyInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTrafficPolicyInstanceOutput");
        formatter.field("traffic_policy_instance", &self.traffic_policy_instance);
        formatter.finish()
    }
}
/// See [`UpdateTrafficPolicyInstanceOutput`](crate::output::UpdateTrafficPolicyInstanceOutput)
pub mod update_traffic_policy_instance_output {
    /// A builder for [`UpdateTrafficPolicyInstanceOutput`](crate::output::UpdateTrafficPolicyInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) traffic_policy_instance:
            std::option::Option<crate::model::TrafficPolicyInstance>,
    }
    impl Builder {
        /// <p>A complex type that contains settings for the updated traffic policy instance.</p>
        pub fn traffic_policy_instance(
            mut self,
            input: crate::model::TrafficPolicyInstance,
        ) -> Self {
            self.traffic_policy_instance = Some(input);
            self
        }
        /// <p>A complex type that contains settings for the updated traffic policy instance.</p>
        pub fn set_traffic_policy_instance(
            mut self,
            input: std::option::Option<crate::model::TrafficPolicyInstance>,
        ) -> Self {
            self.traffic_policy_instance = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTrafficPolicyInstanceOutput`](crate::output::UpdateTrafficPolicyInstanceOutput)
        pub fn build(self) -> crate::output::UpdateTrafficPolicyInstanceOutput {
            crate::output::UpdateTrafficPolicyInstanceOutput {
                traffic_policy_instance: self.traffic_policy_instance,
            }
        }
    }
}
impl UpdateTrafficPolicyInstanceOutput {
    /// Creates a new builder-style object to manufacture [`UpdateTrafficPolicyInstanceOutput`](crate::output::UpdateTrafficPolicyInstanceOutput)
    pub fn builder() -> crate::output::update_traffic_policy_instance_output::Builder {
        crate::output::update_traffic_policy_instance_output::Builder::default()
    }
}

/// <p>A complex type that contains the response information for the traffic policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTrafficPolicyCommentOutput {
    /// <p>A complex type that contains settings for the specified traffic policy.</p>
    pub traffic_policy: std::option::Option<crate::model::TrafficPolicy>,
}
impl UpdateTrafficPolicyCommentOutput {
    /// <p>A complex type that contains settings for the specified traffic policy.</p>
    pub fn traffic_policy(&self) -> std::option::Option<&crate::model::TrafficPolicy> {
        self.traffic_policy.as_ref()
    }
}
impl std::fmt::Debug for UpdateTrafficPolicyCommentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTrafficPolicyCommentOutput");
        formatter.field("traffic_policy", &self.traffic_policy);
        formatter.finish()
    }
}
/// See [`UpdateTrafficPolicyCommentOutput`](crate::output::UpdateTrafficPolicyCommentOutput)
pub mod update_traffic_policy_comment_output {
    /// A builder for [`UpdateTrafficPolicyCommentOutput`](crate::output::UpdateTrafficPolicyCommentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) traffic_policy: std::option::Option<crate::model::TrafficPolicy>,
    }
    impl Builder {
        /// <p>A complex type that contains settings for the specified traffic policy.</p>
        pub fn traffic_policy(mut self, input: crate::model::TrafficPolicy) -> Self {
            self.traffic_policy = Some(input);
            self
        }
        /// <p>A complex type that contains settings for the specified traffic policy.</p>
        pub fn set_traffic_policy(
            mut self,
            input: std::option::Option<crate::model::TrafficPolicy>,
        ) -> Self {
            self.traffic_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTrafficPolicyCommentOutput`](crate::output::UpdateTrafficPolicyCommentOutput)
        pub fn build(self) -> crate::output::UpdateTrafficPolicyCommentOutput {
            crate::output::UpdateTrafficPolicyCommentOutput {
                traffic_policy: self.traffic_policy,
            }
        }
    }
}
impl UpdateTrafficPolicyCommentOutput {
    /// Creates a new builder-style object to manufacture [`UpdateTrafficPolicyCommentOutput`](crate::output::UpdateTrafficPolicyCommentOutput)
    pub fn builder() -> crate::output::update_traffic_policy_comment_output::Builder {
        crate::output::update_traffic_policy_comment_output::Builder::default()
    }
}

/// <p>A complex type that contains the response to the <code>UpdateHostedZoneComment</code> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateHostedZoneCommentOutput {
    /// <p>A complex type that contains the response to the <code>UpdateHostedZoneComment</code> request.</p>
    pub hosted_zone: std::option::Option<crate::model::HostedZone>,
}
impl UpdateHostedZoneCommentOutput {
    /// <p>A complex type that contains the response to the <code>UpdateHostedZoneComment</code> request.</p>
    pub fn hosted_zone(&self) -> std::option::Option<&crate::model::HostedZone> {
        self.hosted_zone.as_ref()
    }
}
impl std::fmt::Debug for UpdateHostedZoneCommentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateHostedZoneCommentOutput");
        formatter.field("hosted_zone", &self.hosted_zone);
        formatter.finish()
    }
}
/// See [`UpdateHostedZoneCommentOutput`](crate::output::UpdateHostedZoneCommentOutput)
pub mod update_hosted_zone_comment_output {
    /// A builder for [`UpdateHostedZoneCommentOutput`](crate::output::UpdateHostedZoneCommentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hosted_zone: std::option::Option<crate::model::HostedZone>,
    }
    impl Builder {
        /// <p>A complex type that contains the response to the <code>UpdateHostedZoneComment</code> request.</p>
        pub fn hosted_zone(mut self, input: crate::model::HostedZone) -> Self {
            self.hosted_zone = Some(input);
            self
        }
        /// <p>A complex type that contains the response to the <code>UpdateHostedZoneComment</code> request.</p>
        pub fn set_hosted_zone(
            mut self,
            input: std::option::Option<crate::model::HostedZone>,
        ) -> Self {
            self.hosted_zone = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateHostedZoneCommentOutput`](crate::output::UpdateHostedZoneCommentOutput)
        pub fn build(self) -> crate::output::UpdateHostedZoneCommentOutput {
            crate::output::UpdateHostedZoneCommentOutput {
                hosted_zone: self.hosted_zone,
            }
        }
    }
}
impl UpdateHostedZoneCommentOutput {
    /// Creates a new builder-style object to manufacture [`UpdateHostedZoneCommentOutput`](crate::output::UpdateHostedZoneCommentOutput)
    pub fn builder() -> crate::output::update_hosted_zone_comment_output::Builder {
        crate::output::update_hosted_zone_comment_output::Builder::default()
    }
}

/// <p>A complex type that contains the response to the <code>UpdateHealthCheck</code> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateHealthCheckOutput {
    /// <p>A complex type that contains the response to an <code>UpdateHealthCheck</code> request.</p>
    pub health_check: std::option::Option<crate::model::HealthCheck>,
}
impl UpdateHealthCheckOutput {
    /// <p>A complex type that contains the response to an <code>UpdateHealthCheck</code> request.</p>
    pub fn health_check(&self) -> std::option::Option<&crate::model::HealthCheck> {
        self.health_check.as_ref()
    }
}
impl std::fmt::Debug for UpdateHealthCheckOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateHealthCheckOutput");
        formatter.field("health_check", &self.health_check);
        formatter.finish()
    }
}
/// See [`UpdateHealthCheckOutput`](crate::output::UpdateHealthCheckOutput)
pub mod update_health_check_output {
    /// A builder for [`UpdateHealthCheckOutput`](crate::output::UpdateHealthCheckOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) health_check: std::option::Option<crate::model::HealthCheck>,
    }
    impl Builder {
        /// <p>A complex type that contains the response to an <code>UpdateHealthCheck</code> request.</p>
        pub fn health_check(mut self, input: crate::model::HealthCheck) -> Self {
            self.health_check = Some(input);
            self
        }
        /// <p>A complex type that contains the response to an <code>UpdateHealthCheck</code> request.</p>
        pub fn set_health_check(
            mut self,
            input: std::option::Option<crate::model::HealthCheck>,
        ) -> Self {
            self.health_check = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateHealthCheckOutput`](crate::output::UpdateHealthCheckOutput)
        pub fn build(self) -> crate::output::UpdateHealthCheckOutput {
            crate::output::UpdateHealthCheckOutput {
                health_check: self.health_check,
            }
        }
    }
}
impl UpdateHealthCheckOutput {
    /// Creates a new builder-style object to manufacture [`UpdateHealthCheckOutput`](crate::output::UpdateHealthCheckOutput)
    pub fn builder() -> crate::output::update_health_check_output::Builder {
        crate::output::update_health_check_output::Builder::default()
    }
}

/// <p>A complex type that contains the response to a <code>TestDNSAnswer</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TestDnsAnswerOutput {
    /// <p>The Amazon Route 53 name server used to respond to the request.</p>
    pub nameserver: std::option::Option<std::string::String>,
    /// <p>The name of the resource record set that you submitted a request for.</p>
    pub record_name: std::option::Option<std::string::String>,
    /// <p>The type of the resource record set that you submitted a request for.</p>
    pub record_type: std::option::Option<crate::model::RrType>,
    /// <p>A list that contains values that Amazon Route 53 returned for this resource record set.</p>
    pub record_data: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A code that indicates whether the request is valid or not. The most common response code is <code>NOERROR</code>, meaning that the request is valid. If the response is not valid, Amazon Route 53 returns a response code that describes the error. For a list of possible response codes, see <a href="http://www.iana.org/assignments/dns-parameters/dns-parameters.xhtml#dns-parameters-6">DNS RCODES</a> on the IANA website. </p>
    pub response_code: std::option::Option<std::string::String>,
    /// <p>The protocol that Amazon Route 53 used to respond to the request, either <code>UDP</code> or <code>TCP</code>. </p>
    pub protocol: std::option::Option<std::string::String>,
}
impl TestDnsAnswerOutput {
    /// <p>The Amazon Route 53 name server used to respond to the request.</p>
    pub fn nameserver(&self) -> std::option::Option<&str> {
        self.nameserver.as_deref()
    }
    /// <p>The name of the resource record set that you submitted a request for.</p>
    pub fn record_name(&self) -> std::option::Option<&str> {
        self.record_name.as_deref()
    }
    /// <p>The type of the resource record set that you submitted a request for.</p>
    pub fn record_type(&self) -> std::option::Option<&crate::model::RrType> {
        self.record_type.as_ref()
    }
    /// <p>A list that contains values that Amazon Route 53 returned for this resource record set.</p>
    pub fn record_data(&self) -> std::option::Option<&[std::string::String]> {
        self.record_data.as_deref()
    }
    /// <p>A code that indicates whether the request is valid or not. The most common response code is <code>NOERROR</code>, meaning that the request is valid. If the response is not valid, Amazon Route 53 returns a response code that describes the error. For a list of possible response codes, see <a href="http://www.iana.org/assignments/dns-parameters/dns-parameters.xhtml#dns-parameters-6">DNS RCODES</a> on the IANA website. </p>
    pub fn response_code(&self) -> std::option::Option<&str> {
        self.response_code.as_deref()
    }
    /// <p>The protocol that Amazon Route 53 used to respond to the request, either <code>UDP</code> or <code>TCP</code>. </p>
    pub fn protocol(&self) -> std::option::Option<&str> {
        self.protocol.as_deref()
    }
}
impl std::fmt::Debug for TestDnsAnswerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TestDnsAnswerOutput");
        formatter.field("nameserver", &self.nameserver);
        formatter.field("record_name", &self.record_name);
        formatter.field("record_type", &self.record_type);
        formatter.field("record_data", &self.record_data);
        formatter.field("response_code", &self.response_code);
        formatter.field("protocol", &self.protocol);
        formatter.finish()
    }
}
/// See [`TestDnsAnswerOutput`](crate::output::TestDnsAnswerOutput)
pub mod test_dns_answer_output {
    /// A builder for [`TestDnsAnswerOutput`](crate::output::TestDnsAnswerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) nameserver: std::option::Option<std::string::String>,
        pub(crate) record_name: std::option::Option<std::string::String>,
        pub(crate) record_type: std::option::Option<crate::model::RrType>,
        pub(crate) record_data: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) response_code: std::option::Option<std::string::String>,
        pub(crate) protocol: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Route 53 name server used to respond to the request.</p>
        pub fn nameserver(mut self, input: impl Into<std::string::String>) -> Self {
            self.nameserver = Some(input.into());
            self
        }
        /// <p>The Amazon Route 53 name server used to respond to the request.</p>
        pub fn set_nameserver(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.nameserver = input;
            self
        }
        /// <p>The name of the resource record set that you submitted a request for.</p>
        pub fn record_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.record_name = Some(input.into());
            self
        }
        /// <p>The name of the resource record set that you submitted a request for.</p>
        pub fn set_record_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.record_name = input;
            self
        }
        /// <p>The type of the resource record set that you submitted a request for.</p>
        pub fn record_type(mut self, input: crate::model::RrType) -> Self {
            self.record_type = Some(input);
            self
        }
        /// <p>The type of the resource record set that you submitted a request for.</p>
        pub fn set_record_type(mut self, input: std::option::Option<crate::model::RrType>) -> Self {
            self.record_type = input;
            self
        }
        /// Appends an item to `record_data`.
        ///
        /// To override the contents of this collection use [`set_record_data`](Self::set_record_data).
        ///
        /// <p>A list that contains values that Amazon Route 53 returned for this resource record set.</p>
        pub fn record_data(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.record_data.unwrap_or_default();
            v.push(input.into());
            self.record_data = Some(v);
            self
        }
        /// <p>A list that contains values that Amazon Route 53 returned for this resource record set.</p>
        pub fn set_record_data(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.record_data = input;
            self
        }
        /// <p>A code that indicates whether the request is valid or not. The most common response code is <code>NOERROR</code>, meaning that the request is valid. If the response is not valid, Amazon Route 53 returns a response code that describes the error. For a list of possible response codes, see <a href="http://www.iana.org/assignments/dns-parameters/dns-parameters.xhtml#dns-parameters-6">DNS RCODES</a> on the IANA website. </p>
        pub fn response_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.response_code = Some(input.into());
            self
        }
        /// <p>A code that indicates whether the request is valid or not. The most common response code is <code>NOERROR</code>, meaning that the request is valid. If the response is not valid, Amazon Route 53 returns a response code that describes the error. For a list of possible response codes, see <a href="http://www.iana.org/assignments/dns-parameters/dns-parameters.xhtml#dns-parameters-6">DNS RCODES</a> on the IANA website. </p>
        pub fn set_response_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.response_code = input;
            self
        }
        /// <p>The protocol that Amazon Route 53 used to respond to the request, either <code>UDP</code> or <code>TCP</code>. </p>
        pub fn protocol(mut self, input: impl Into<std::string::String>) -> Self {
            self.protocol = Some(input.into());
            self
        }
        /// <p>The protocol that Amazon Route 53 used to respond to the request, either <code>UDP</code> or <code>TCP</code>. </p>
        pub fn set_protocol(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.protocol = input;
            self
        }
        /// Consumes the builder and constructs a [`TestDnsAnswerOutput`](crate::output::TestDnsAnswerOutput)
        pub fn build(self) -> crate::output::TestDnsAnswerOutput {
            crate::output::TestDnsAnswerOutput {
                nameserver: self.nameserver,
                record_name: self.record_name,
                record_type: self.record_type,
                record_data: self.record_data,
                response_code: self.response_code,
                protocol: self.protocol,
            }
        }
    }
}
impl TestDnsAnswerOutput {
    /// Creates a new builder-style object to manufacture [`TestDnsAnswerOutput`](crate::output::TestDnsAnswerOutput)
    pub fn builder() -> crate::output::test_dns_answer_output::Builder {
        crate::output::test_dns_answer_output::Builder::default()
    }
}

/// <p>A complex type that contains the response information for the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListVpcAssociationAuthorizationsOutput {
    /// <p>The ID of the hosted zone that you can associate the listed VPCs with.</p>
    pub hosted_zone_id: std::option::Option<std::string::String>,
    /// <p>When the response includes a <code>NextToken</code> element, there are more VPCs that can be associated with the specified hosted zone. To get the next page of VPCs, submit another <code>ListVPCAssociationAuthorizations</code> request, and include the value of the <code>NextToken</code> element from the response in the <code>nexttoken</code> request parameter.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The list of VPCs that are authorized to be associated with the specified hosted zone.</p>
    pub vp_cs: std::option::Option<std::vec::Vec<crate::model::Vpc>>,
}
impl ListVpcAssociationAuthorizationsOutput {
    /// <p>The ID of the hosted zone that you can associate the listed VPCs with.</p>
    pub fn hosted_zone_id(&self) -> std::option::Option<&str> {
        self.hosted_zone_id.as_deref()
    }
    /// <p>When the response includes a <code>NextToken</code> element, there are more VPCs that can be associated with the specified hosted zone. To get the next page of VPCs, submit another <code>ListVPCAssociationAuthorizations</code> request, and include the value of the <code>NextToken</code> element from the response in the <code>nexttoken</code> request parameter.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The list of VPCs that are authorized to be associated with the specified hosted zone.</p>
    pub fn vp_cs(&self) -> std::option::Option<&[crate::model::Vpc]> {
        self.vp_cs.as_deref()
    }
}
impl std::fmt::Debug for ListVpcAssociationAuthorizationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListVpcAssociationAuthorizationsOutput");
        formatter.field("hosted_zone_id", &self.hosted_zone_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("vp_cs", &self.vp_cs);
        formatter.finish()
    }
}
/// See [`ListVpcAssociationAuthorizationsOutput`](crate::output::ListVpcAssociationAuthorizationsOutput)
pub mod list_vpc_association_authorizations_output {
    /// A builder for [`ListVpcAssociationAuthorizationsOutput`](crate::output::ListVpcAssociationAuthorizationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hosted_zone_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) vp_cs: std::option::Option<std::vec::Vec<crate::model::Vpc>>,
    }
    impl Builder {
        /// <p>The ID of the hosted zone that you can associate the listed VPCs with.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hosted_zone_id = Some(input.into());
            self
        }
        /// <p>The ID of the hosted zone that you can associate the listed VPCs with.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hosted_zone_id = input;
            self
        }
        /// <p>When the response includes a <code>NextToken</code> element, there are more VPCs that can be associated with the specified hosted zone. To get the next page of VPCs, submit another <code>ListVPCAssociationAuthorizations</code> request, and include the value of the <code>NextToken</code> element from the response in the <code>nexttoken</code> request parameter.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>When the response includes a <code>NextToken</code> element, there are more VPCs that can be associated with the specified hosted zone. To get the next page of VPCs, submit another <code>ListVPCAssociationAuthorizations</code> request, and include the value of the <code>NextToken</code> element from the response in the <code>nexttoken</code> request parameter.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `vp_cs`.
        ///
        /// To override the contents of this collection use [`set_vp_cs`](Self::set_vp_cs).
        ///
        /// <p>The list of VPCs that are authorized to be associated with the specified hosted zone.</p>
        pub fn vp_cs(mut self, input: crate::model::Vpc) -> Self {
            let mut v = self.vp_cs.unwrap_or_default();
            v.push(input);
            self.vp_cs = Some(v);
            self
        }
        /// <p>The list of VPCs that are authorized to be associated with the specified hosted zone.</p>
        pub fn set_vp_cs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Vpc>>,
        ) -> Self {
            self.vp_cs = input;
            self
        }
        /// Consumes the builder and constructs a [`ListVpcAssociationAuthorizationsOutput`](crate::output::ListVpcAssociationAuthorizationsOutput)
        pub fn build(self) -> crate::output::ListVpcAssociationAuthorizationsOutput {
            crate::output::ListVpcAssociationAuthorizationsOutput {
                hosted_zone_id: self.hosted_zone_id,
                next_token: self.next_token,
                vp_cs: self.vp_cs,
            }
        }
    }
}
impl ListVpcAssociationAuthorizationsOutput {
    /// Creates a new builder-style object to manufacture [`ListVpcAssociationAuthorizationsOutput`](crate::output::ListVpcAssociationAuthorizationsOutput)
    pub fn builder() -> crate::output::list_vpc_association_authorizations_output::Builder {
        crate::output::list_vpc_association_authorizations_output::Builder::default()
    }
}

/// <p>A complex type that contains the response information for the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTrafficPolicyVersionsOutput {
    /// <p>A list that contains one <code>TrafficPolicy</code> element for each traffic policy version that is associated with the specified traffic policy.</p>
    pub traffic_policies: std::option::Option<std::vec::Vec<crate::model::TrafficPolicy>>,
    /// <p>A flag that indicates whether there are more traffic policies to be listed. If the response was truncated, you can get the next group of traffic policies by submitting another <code>ListTrafficPolicyVersions</code> request and specifying the value of <code>NextMarker</code> in the <code>marker</code> parameter.</p>
    pub is_truncated: bool,
    /// <p>If <code>IsTruncated</code> is <code>true</code>, the value of <code>TrafficPolicyVersionMarker</code> identifies the first traffic policy that Amazon Route 53 will return if you submit another request. Call <code>ListTrafficPolicyVersions</code> again and specify the value of <code>TrafficPolicyVersionMarker</code> in the <code>TrafficPolicyVersionMarker</code> request parameter.</p>
    /// <p>This element is present only if <code>IsTruncated</code> is <code>true</code>.</p>
    pub traffic_policy_version_marker: std::option::Option<std::string::String>,
    /// <p>The value that you specified for the <code>maxitems</code> parameter in the <code>ListTrafficPolicyVersions</code> request that produced the current response.</p>
    pub max_items: std::option::Option<i32>,
}
impl ListTrafficPolicyVersionsOutput {
    /// <p>A list that contains one <code>TrafficPolicy</code> element for each traffic policy version that is associated with the specified traffic policy.</p>
    pub fn traffic_policies(&self) -> std::option::Option<&[crate::model::TrafficPolicy]> {
        self.traffic_policies.as_deref()
    }
    /// <p>A flag that indicates whether there are more traffic policies to be listed. If the response was truncated, you can get the next group of traffic policies by submitting another <code>ListTrafficPolicyVersions</code> request and specifying the value of <code>NextMarker</code> in the <code>marker</code> parameter.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>If <code>IsTruncated</code> is <code>true</code>, the value of <code>TrafficPolicyVersionMarker</code> identifies the first traffic policy that Amazon Route 53 will return if you submit another request. Call <code>ListTrafficPolicyVersions</code> again and specify the value of <code>TrafficPolicyVersionMarker</code> in the <code>TrafficPolicyVersionMarker</code> request parameter.</p>
    /// <p>This element is present only if <code>IsTruncated</code> is <code>true</code>.</p>
    pub fn traffic_policy_version_marker(&self) -> std::option::Option<&str> {
        self.traffic_policy_version_marker.as_deref()
    }
    /// <p>The value that you specified for the <code>maxitems</code> parameter in the <code>ListTrafficPolicyVersions</code> request that produced the current response.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListTrafficPolicyVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTrafficPolicyVersionsOutput");
        formatter.field("traffic_policies", &self.traffic_policies);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field(
            "traffic_policy_version_marker",
            &self.traffic_policy_version_marker,
        );
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}
/// See [`ListTrafficPolicyVersionsOutput`](crate::output::ListTrafficPolicyVersionsOutput)
pub mod list_traffic_policy_versions_output {
    /// A builder for [`ListTrafficPolicyVersionsOutput`](crate::output::ListTrafficPolicyVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) traffic_policies:
            std::option::Option<std::vec::Vec<crate::model::TrafficPolicy>>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) traffic_policy_version_marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `traffic_policies`.
        ///
        /// To override the contents of this collection use [`set_traffic_policies`](Self::set_traffic_policies).
        ///
        /// <p>A list that contains one <code>TrafficPolicy</code> element for each traffic policy version that is associated with the specified traffic policy.</p>
        pub fn traffic_policies(mut self, input: crate::model::TrafficPolicy) -> Self {
            let mut v = self.traffic_policies.unwrap_or_default();
            v.push(input);
            self.traffic_policies = Some(v);
            self
        }
        /// <p>A list that contains one <code>TrafficPolicy</code> element for each traffic policy version that is associated with the specified traffic policy.</p>
        pub fn set_traffic_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TrafficPolicy>>,
        ) -> Self {
            self.traffic_policies = input;
            self
        }
        /// <p>A flag that indicates whether there are more traffic policies to be listed. If the response was truncated, you can get the next group of traffic policies by submitting another <code>ListTrafficPolicyVersions</code> request and specifying the value of <code>NextMarker</code> in the <code>marker</code> parameter.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more traffic policies to be listed. If the response was truncated, you can get the next group of traffic policies by submitting another <code>ListTrafficPolicyVersions</code> request and specifying the value of <code>NextMarker</code> in the <code>marker</code> parameter.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>If <code>IsTruncated</code> is <code>true</code>, the value of <code>TrafficPolicyVersionMarker</code> identifies the first traffic policy that Amazon Route 53 will return if you submit another request. Call <code>ListTrafficPolicyVersions</code> again and specify the value of <code>TrafficPolicyVersionMarker</code> in the <code>TrafficPolicyVersionMarker</code> request parameter.</p>
        /// <p>This element is present only if <code>IsTruncated</code> is <code>true</code>.</p>
        pub fn traffic_policy_version_marker(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.traffic_policy_version_marker = Some(input.into());
            self
        }
        /// <p>If <code>IsTruncated</code> is <code>true</code>, the value of <code>TrafficPolicyVersionMarker</code> identifies the first traffic policy that Amazon Route 53 will return if you submit another request. Call <code>ListTrafficPolicyVersions</code> again and specify the value of <code>TrafficPolicyVersionMarker</code> in the <code>TrafficPolicyVersionMarker</code> request parameter.</p>
        /// <p>This element is present only if <code>IsTruncated</code> is <code>true</code>.</p>
        pub fn set_traffic_policy_version_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.traffic_policy_version_marker = input;
            self
        }
        /// <p>The value that you specified for the <code>maxitems</code> parameter in the <code>ListTrafficPolicyVersions</code> request that produced the current response.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The value that you specified for the <code>maxitems</code> parameter in the <code>ListTrafficPolicyVersions</code> request that produced the current response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTrafficPolicyVersionsOutput`](crate::output::ListTrafficPolicyVersionsOutput)
        pub fn build(self) -> crate::output::ListTrafficPolicyVersionsOutput {
            crate::output::ListTrafficPolicyVersionsOutput {
                traffic_policies: self.traffic_policies,
                is_truncated: self.is_truncated.unwrap_or_default(),
                traffic_policy_version_marker: self.traffic_policy_version_marker,
                max_items: self.max_items,
            }
        }
    }
}
impl ListTrafficPolicyVersionsOutput {
    /// Creates a new builder-style object to manufacture [`ListTrafficPolicyVersionsOutput`](crate::output::ListTrafficPolicyVersionsOutput)
    pub fn builder() -> crate::output::list_traffic_policy_versions_output::Builder {
        crate::output::list_traffic_policy_versions_output::Builder::default()
    }
}

/// <p>A complex type that contains the response information for the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTrafficPolicyInstancesByPolicyOutput {
    /// <p>A list that contains one <code>TrafficPolicyInstance</code> element for each traffic policy instance that matches the elements in the request.</p>
    pub traffic_policy_instances:
        std::option::Option<std::vec::Vec<crate::model::TrafficPolicyInstance>>,
    /// <p>If <code>IsTruncated</code> is <code>true</code>, <code>HostedZoneIdMarker</code> is the ID of the hosted zone of the first traffic policy instance in the next group of traffic policy instances.</p>
    pub hosted_zone_id_marker: std::option::Option<std::string::String>,
    /// <p>If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceNameMarker</code> is the name of the first traffic policy instance in the next group of <code>MaxItems</code> traffic policy instances.</p>
    pub traffic_policy_instance_name_marker: std::option::Option<std::string::String>,
    /// <p>If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceTypeMarker</code> is the DNS type of the resource record sets that are associated with the first traffic policy instance in the next group of <code>MaxItems</code> traffic policy instances.</p>
    pub traffic_policy_instance_type_marker: std::option::Option<crate::model::RrType>,
    /// <p>A flag that indicates whether there are more traffic policy instances to be listed. If the response was truncated, you can get the next group of traffic policy instances by calling <code>ListTrafficPolicyInstancesByPolicy</code> again and specifying the values of the <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code> elements in the corresponding request parameters.</p>
    pub is_truncated: bool,
    /// <p>The value that you specified for the <code>MaxItems</code> parameter in the call to <code>ListTrafficPolicyInstancesByPolicy</code> that produced the current response.</p>
    pub max_items: std::option::Option<i32>,
}
impl ListTrafficPolicyInstancesByPolicyOutput {
    /// <p>A list that contains one <code>TrafficPolicyInstance</code> element for each traffic policy instance that matches the elements in the request.</p>
    pub fn traffic_policy_instances(
        &self,
    ) -> std::option::Option<&[crate::model::TrafficPolicyInstance]> {
        self.traffic_policy_instances.as_deref()
    }
    /// <p>If <code>IsTruncated</code> is <code>true</code>, <code>HostedZoneIdMarker</code> is the ID of the hosted zone of the first traffic policy instance in the next group of traffic policy instances.</p>
    pub fn hosted_zone_id_marker(&self) -> std::option::Option<&str> {
        self.hosted_zone_id_marker.as_deref()
    }
    /// <p>If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceNameMarker</code> is the name of the first traffic policy instance in the next group of <code>MaxItems</code> traffic policy instances.</p>
    pub fn traffic_policy_instance_name_marker(&self) -> std::option::Option<&str> {
        self.traffic_policy_instance_name_marker.as_deref()
    }
    /// <p>If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceTypeMarker</code> is the DNS type of the resource record sets that are associated with the first traffic policy instance in the next group of <code>MaxItems</code> traffic policy instances.</p>
    pub fn traffic_policy_instance_type_marker(
        &self,
    ) -> std::option::Option<&crate::model::RrType> {
        self.traffic_policy_instance_type_marker.as_ref()
    }
    /// <p>A flag that indicates whether there are more traffic policy instances to be listed. If the response was truncated, you can get the next group of traffic policy instances by calling <code>ListTrafficPolicyInstancesByPolicy</code> again and specifying the values of the <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code> elements in the corresponding request parameters.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>The value that you specified for the <code>MaxItems</code> parameter in the call to <code>ListTrafficPolicyInstancesByPolicy</code> that produced the current response.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListTrafficPolicyInstancesByPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTrafficPolicyInstancesByPolicyOutput");
        formatter.field("traffic_policy_instances", &self.traffic_policy_instances);
        formatter.field("hosted_zone_id_marker", &self.hosted_zone_id_marker);
        formatter.field(
            "traffic_policy_instance_name_marker",
            &self.traffic_policy_instance_name_marker,
        );
        formatter.field(
            "traffic_policy_instance_type_marker",
            &self.traffic_policy_instance_type_marker,
        );
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}
/// See [`ListTrafficPolicyInstancesByPolicyOutput`](crate::output::ListTrafficPolicyInstancesByPolicyOutput)
pub mod list_traffic_policy_instances_by_policy_output {
    /// A builder for [`ListTrafficPolicyInstancesByPolicyOutput`](crate::output::ListTrafficPolicyInstancesByPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) traffic_policy_instances:
            std::option::Option<std::vec::Vec<crate::model::TrafficPolicyInstance>>,
        pub(crate) hosted_zone_id_marker: std::option::Option<std::string::String>,
        pub(crate) traffic_policy_instance_name_marker: std::option::Option<std::string::String>,
        pub(crate) traffic_policy_instance_type_marker: std::option::Option<crate::model::RrType>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `traffic_policy_instances`.
        ///
        /// To override the contents of this collection use [`set_traffic_policy_instances`](Self::set_traffic_policy_instances).
        ///
        /// <p>A list that contains one <code>TrafficPolicyInstance</code> element for each traffic policy instance that matches the elements in the request.</p>
        pub fn traffic_policy_instances(
            mut self,
            input: crate::model::TrafficPolicyInstance,
        ) -> Self {
            let mut v = self.traffic_policy_instances.unwrap_or_default();
            v.push(input);
            self.traffic_policy_instances = Some(v);
            self
        }
        /// <p>A list that contains one <code>TrafficPolicyInstance</code> element for each traffic policy instance that matches the elements in the request.</p>
        pub fn set_traffic_policy_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TrafficPolicyInstance>>,
        ) -> Self {
            self.traffic_policy_instances = input;
            self
        }
        /// <p>If <code>IsTruncated</code> is <code>true</code>, <code>HostedZoneIdMarker</code> is the ID of the hosted zone of the first traffic policy instance in the next group of traffic policy instances.</p>
        pub fn hosted_zone_id_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.hosted_zone_id_marker = Some(input.into());
            self
        }
        /// <p>If <code>IsTruncated</code> is <code>true</code>, <code>HostedZoneIdMarker</code> is the ID of the hosted zone of the first traffic policy instance in the next group of traffic policy instances.</p>
        pub fn set_hosted_zone_id_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hosted_zone_id_marker = input;
            self
        }
        /// <p>If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceNameMarker</code> is the name of the first traffic policy instance in the next group of <code>MaxItems</code> traffic policy instances.</p>
        pub fn traffic_policy_instance_name_marker(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.traffic_policy_instance_name_marker = Some(input.into());
            self
        }
        /// <p>If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceNameMarker</code> is the name of the first traffic policy instance in the next group of <code>MaxItems</code> traffic policy instances.</p>
        pub fn set_traffic_policy_instance_name_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.traffic_policy_instance_name_marker = input;
            self
        }
        /// <p>If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceTypeMarker</code> is the DNS type of the resource record sets that are associated with the first traffic policy instance in the next group of <code>MaxItems</code> traffic policy instances.</p>
        pub fn traffic_policy_instance_type_marker(mut self, input: crate::model::RrType) -> Self {
            self.traffic_policy_instance_type_marker = Some(input);
            self
        }
        /// <p>If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceTypeMarker</code> is the DNS type of the resource record sets that are associated with the first traffic policy instance in the next group of <code>MaxItems</code> traffic policy instances.</p>
        pub fn set_traffic_policy_instance_type_marker(
            mut self,
            input: std::option::Option<crate::model::RrType>,
        ) -> Self {
            self.traffic_policy_instance_type_marker = input;
            self
        }
        /// <p>A flag that indicates whether there are more traffic policy instances to be listed. If the response was truncated, you can get the next group of traffic policy instances by calling <code>ListTrafficPolicyInstancesByPolicy</code> again and specifying the values of the <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code> elements in the corresponding request parameters.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more traffic policy instances to be listed. If the response was truncated, you can get the next group of traffic policy instances by calling <code>ListTrafficPolicyInstancesByPolicy</code> again and specifying the values of the <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code> elements in the corresponding request parameters.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>The value that you specified for the <code>MaxItems</code> parameter in the call to <code>ListTrafficPolicyInstancesByPolicy</code> that produced the current response.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The value that you specified for the <code>MaxItems</code> parameter in the call to <code>ListTrafficPolicyInstancesByPolicy</code> that produced the current response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTrafficPolicyInstancesByPolicyOutput`](crate::output::ListTrafficPolicyInstancesByPolicyOutput)
        pub fn build(self) -> crate::output::ListTrafficPolicyInstancesByPolicyOutput {
            crate::output::ListTrafficPolicyInstancesByPolicyOutput {
                traffic_policy_instances: self.traffic_policy_instances,
                hosted_zone_id_marker: self.hosted_zone_id_marker,
                traffic_policy_instance_name_marker: self.traffic_policy_instance_name_marker,
                traffic_policy_instance_type_marker: self.traffic_policy_instance_type_marker,
                is_truncated: self.is_truncated.unwrap_or_default(),
                max_items: self.max_items,
            }
        }
    }
}
impl ListTrafficPolicyInstancesByPolicyOutput {
    /// Creates a new builder-style object to manufacture [`ListTrafficPolicyInstancesByPolicyOutput`](crate::output::ListTrafficPolicyInstancesByPolicyOutput)
    pub fn builder() -> crate::output::list_traffic_policy_instances_by_policy_output::Builder {
        crate::output::list_traffic_policy_instances_by_policy_output::Builder::default()
    }
}

/// <p>A complex type that contains the response information for the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTrafficPolicyInstancesByHostedZoneOutput {
    /// <p>A list that contains one <code>TrafficPolicyInstance</code> element for each traffic policy instance that matches the elements in the request. </p>
    pub traffic_policy_instances:
        std::option::Option<std::vec::Vec<crate::model::TrafficPolicyInstance>>,
    /// <p>If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceNameMarker</code> is the name of the first traffic policy instance in the next group of traffic policy instances.</p>
    pub traffic_policy_instance_name_marker: std::option::Option<std::string::String>,
    /// <p>If <code>IsTruncated</code> is true, <code>TrafficPolicyInstanceTypeMarker</code> is the DNS type of the resource record sets that are associated with the first traffic policy instance in the next group of traffic policy instances.</p>
    pub traffic_policy_instance_type_marker: std::option::Option<crate::model::RrType>,
    /// <p>A flag that indicates whether there are more traffic policy instances to be listed. If the response was truncated, you can get the next group of traffic policy instances by submitting another <code>ListTrafficPolicyInstancesByHostedZone</code> request and specifying the values of <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code> in the corresponding request parameters.</p>
    pub is_truncated: bool,
    /// <p>The value that you specified for the <code>MaxItems</code> parameter in the <code>ListTrafficPolicyInstancesByHostedZone</code> request that produced the current response.</p>
    pub max_items: std::option::Option<i32>,
}
impl ListTrafficPolicyInstancesByHostedZoneOutput {
    /// <p>A list that contains one <code>TrafficPolicyInstance</code> element for each traffic policy instance that matches the elements in the request. </p>
    pub fn traffic_policy_instances(
        &self,
    ) -> std::option::Option<&[crate::model::TrafficPolicyInstance]> {
        self.traffic_policy_instances.as_deref()
    }
    /// <p>If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceNameMarker</code> is the name of the first traffic policy instance in the next group of traffic policy instances.</p>
    pub fn traffic_policy_instance_name_marker(&self) -> std::option::Option<&str> {
        self.traffic_policy_instance_name_marker.as_deref()
    }
    /// <p>If <code>IsTruncated</code> is true, <code>TrafficPolicyInstanceTypeMarker</code> is the DNS type of the resource record sets that are associated with the first traffic policy instance in the next group of traffic policy instances.</p>
    pub fn traffic_policy_instance_type_marker(
        &self,
    ) -> std::option::Option<&crate::model::RrType> {
        self.traffic_policy_instance_type_marker.as_ref()
    }
    /// <p>A flag that indicates whether there are more traffic policy instances to be listed. If the response was truncated, you can get the next group of traffic policy instances by submitting another <code>ListTrafficPolicyInstancesByHostedZone</code> request and specifying the values of <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code> in the corresponding request parameters.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>The value that you specified for the <code>MaxItems</code> parameter in the <code>ListTrafficPolicyInstancesByHostedZone</code> request that produced the current response.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListTrafficPolicyInstancesByHostedZoneOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTrafficPolicyInstancesByHostedZoneOutput");
        formatter.field("traffic_policy_instances", &self.traffic_policy_instances);
        formatter.field(
            "traffic_policy_instance_name_marker",
            &self.traffic_policy_instance_name_marker,
        );
        formatter.field(
            "traffic_policy_instance_type_marker",
            &self.traffic_policy_instance_type_marker,
        );
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}
/// See [`ListTrafficPolicyInstancesByHostedZoneOutput`](crate::output::ListTrafficPolicyInstancesByHostedZoneOutput)
pub mod list_traffic_policy_instances_by_hosted_zone_output {
    /// A builder for [`ListTrafficPolicyInstancesByHostedZoneOutput`](crate::output::ListTrafficPolicyInstancesByHostedZoneOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) traffic_policy_instances:
            std::option::Option<std::vec::Vec<crate::model::TrafficPolicyInstance>>,
        pub(crate) traffic_policy_instance_name_marker: std::option::Option<std::string::String>,
        pub(crate) traffic_policy_instance_type_marker: std::option::Option<crate::model::RrType>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `traffic_policy_instances`.
        ///
        /// To override the contents of this collection use [`set_traffic_policy_instances`](Self::set_traffic_policy_instances).
        ///
        /// <p>A list that contains one <code>TrafficPolicyInstance</code> element for each traffic policy instance that matches the elements in the request. </p>
        pub fn traffic_policy_instances(
            mut self,
            input: crate::model::TrafficPolicyInstance,
        ) -> Self {
            let mut v = self.traffic_policy_instances.unwrap_or_default();
            v.push(input);
            self.traffic_policy_instances = Some(v);
            self
        }
        /// <p>A list that contains one <code>TrafficPolicyInstance</code> element for each traffic policy instance that matches the elements in the request. </p>
        pub fn set_traffic_policy_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TrafficPolicyInstance>>,
        ) -> Self {
            self.traffic_policy_instances = input;
            self
        }
        /// <p>If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceNameMarker</code> is the name of the first traffic policy instance in the next group of traffic policy instances.</p>
        pub fn traffic_policy_instance_name_marker(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.traffic_policy_instance_name_marker = Some(input.into());
            self
        }
        /// <p>If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceNameMarker</code> is the name of the first traffic policy instance in the next group of traffic policy instances.</p>
        pub fn set_traffic_policy_instance_name_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.traffic_policy_instance_name_marker = input;
            self
        }
        /// <p>If <code>IsTruncated</code> is true, <code>TrafficPolicyInstanceTypeMarker</code> is the DNS type of the resource record sets that are associated with the first traffic policy instance in the next group of traffic policy instances.</p>
        pub fn traffic_policy_instance_type_marker(mut self, input: crate::model::RrType) -> Self {
            self.traffic_policy_instance_type_marker = Some(input);
            self
        }
        /// <p>If <code>IsTruncated</code> is true, <code>TrafficPolicyInstanceTypeMarker</code> is the DNS type of the resource record sets that are associated with the first traffic policy instance in the next group of traffic policy instances.</p>
        pub fn set_traffic_policy_instance_type_marker(
            mut self,
            input: std::option::Option<crate::model::RrType>,
        ) -> Self {
            self.traffic_policy_instance_type_marker = input;
            self
        }
        /// <p>A flag that indicates whether there are more traffic policy instances to be listed. If the response was truncated, you can get the next group of traffic policy instances by submitting another <code>ListTrafficPolicyInstancesByHostedZone</code> request and specifying the values of <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code> in the corresponding request parameters.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more traffic policy instances to be listed. If the response was truncated, you can get the next group of traffic policy instances by submitting another <code>ListTrafficPolicyInstancesByHostedZone</code> request and specifying the values of <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code> in the corresponding request parameters.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>The value that you specified for the <code>MaxItems</code> parameter in the <code>ListTrafficPolicyInstancesByHostedZone</code> request that produced the current response.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The value that you specified for the <code>MaxItems</code> parameter in the <code>ListTrafficPolicyInstancesByHostedZone</code> request that produced the current response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTrafficPolicyInstancesByHostedZoneOutput`](crate::output::ListTrafficPolicyInstancesByHostedZoneOutput)
        pub fn build(self) -> crate::output::ListTrafficPolicyInstancesByHostedZoneOutput {
            crate::output::ListTrafficPolicyInstancesByHostedZoneOutput {
                traffic_policy_instances: self.traffic_policy_instances,
                traffic_policy_instance_name_marker: self.traffic_policy_instance_name_marker,
                traffic_policy_instance_type_marker: self.traffic_policy_instance_type_marker,
                is_truncated: self.is_truncated.unwrap_or_default(),
                max_items: self.max_items,
            }
        }
    }
}
impl ListTrafficPolicyInstancesByHostedZoneOutput {
    /// Creates a new builder-style object to manufacture [`ListTrafficPolicyInstancesByHostedZoneOutput`](crate::output::ListTrafficPolicyInstancesByHostedZoneOutput)
    pub fn builder() -> crate::output::list_traffic_policy_instances_by_hosted_zone_output::Builder
    {
        crate::output::list_traffic_policy_instances_by_hosted_zone_output::Builder::default()
    }
}

/// <p>A complex type that contains the response information for the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTrafficPolicyInstancesOutput {
    /// <p>A list that contains one <code>TrafficPolicyInstance</code> element for each traffic policy instance that matches the elements in the request.</p>
    pub traffic_policy_instances:
        std::option::Option<std::vec::Vec<crate::model::TrafficPolicyInstance>>,
    /// <p>If <code>IsTruncated</code> is <code>true</code>, <code>HostedZoneIdMarker</code> is the ID of the hosted zone of the first traffic policy instance that Route 53 will return if you submit another <code>ListTrafficPolicyInstances</code> request. </p>
    pub hosted_zone_id_marker: std::option::Option<std::string::String>,
    /// <p>If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceNameMarker</code> is the name of the first traffic policy instance that Route 53 will return if you submit another <code>ListTrafficPolicyInstances</code> request. </p>
    pub traffic_policy_instance_name_marker: std::option::Option<std::string::String>,
    /// <p>If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceTypeMarker</code> is the DNS type of the resource record sets that are associated with the first traffic policy instance that Amazon Route 53 will return if you submit another <code>ListTrafficPolicyInstances</code> request. </p>
    pub traffic_policy_instance_type_marker: std::option::Option<crate::model::RrType>,
    /// <p>A flag that indicates whether there are more traffic policy instances to be listed. If the response was truncated, you can get more traffic policy instances by calling <code>ListTrafficPolicyInstances</code> again and specifying the values of the <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code> in the corresponding request parameters.</p>
    pub is_truncated: bool,
    /// <p>The value that you specified for the <code>MaxItems</code> parameter in the call to <code>ListTrafficPolicyInstances</code> that produced the current response.</p>
    pub max_items: std::option::Option<i32>,
}
impl ListTrafficPolicyInstancesOutput {
    /// <p>A list that contains one <code>TrafficPolicyInstance</code> element for each traffic policy instance that matches the elements in the request.</p>
    pub fn traffic_policy_instances(
        &self,
    ) -> std::option::Option<&[crate::model::TrafficPolicyInstance]> {
        self.traffic_policy_instances.as_deref()
    }
    /// <p>If <code>IsTruncated</code> is <code>true</code>, <code>HostedZoneIdMarker</code> is the ID of the hosted zone of the first traffic policy instance that Route 53 will return if you submit another <code>ListTrafficPolicyInstances</code> request. </p>
    pub fn hosted_zone_id_marker(&self) -> std::option::Option<&str> {
        self.hosted_zone_id_marker.as_deref()
    }
    /// <p>If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceNameMarker</code> is the name of the first traffic policy instance that Route 53 will return if you submit another <code>ListTrafficPolicyInstances</code> request. </p>
    pub fn traffic_policy_instance_name_marker(&self) -> std::option::Option<&str> {
        self.traffic_policy_instance_name_marker.as_deref()
    }
    /// <p>If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceTypeMarker</code> is the DNS type of the resource record sets that are associated with the first traffic policy instance that Amazon Route 53 will return if you submit another <code>ListTrafficPolicyInstances</code> request. </p>
    pub fn traffic_policy_instance_type_marker(
        &self,
    ) -> std::option::Option<&crate::model::RrType> {
        self.traffic_policy_instance_type_marker.as_ref()
    }
    /// <p>A flag that indicates whether there are more traffic policy instances to be listed. If the response was truncated, you can get more traffic policy instances by calling <code>ListTrafficPolicyInstances</code> again and specifying the values of the <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code> in the corresponding request parameters.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>The value that you specified for the <code>MaxItems</code> parameter in the call to <code>ListTrafficPolicyInstances</code> that produced the current response.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListTrafficPolicyInstancesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTrafficPolicyInstancesOutput");
        formatter.field("traffic_policy_instances", &self.traffic_policy_instances);
        formatter.field("hosted_zone_id_marker", &self.hosted_zone_id_marker);
        formatter.field(
            "traffic_policy_instance_name_marker",
            &self.traffic_policy_instance_name_marker,
        );
        formatter.field(
            "traffic_policy_instance_type_marker",
            &self.traffic_policy_instance_type_marker,
        );
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}
/// See [`ListTrafficPolicyInstancesOutput`](crate::output::ListTrafficPolicyInstancesOutput)
pub mod list_traffic_policy_instances_output {
    /// A builder for [`ListTrafficPolicyInstancesOutput`](crate::output::ListTrafficPolicyInstancesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) traffic_policy_instances:
            std::option::Option<std::vec::Vec<crate::model::TrafficPolicyInstance>>,
        pub(crate) hosted_zone_id_marker: std::option::Option<std::string::String>,
        pub(crate) traffic_policy_instance_name_marker: std::option::Option<std::string::String>,
        pub(crate) traffic_policy_instance_type_marker: std::option::Option<crate::model::RrType>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `traffic_policy_instances`.
        ///
        /// To override the contents of this collection use [`set_traffic_policy_instances`](Self::set_traffic_policy_instances).
        ///
        /// <p>A list that contains one <code>TrafficPolicyInstance</code> element for each traffic policy instance that matches the elements in the request.</p>
        pub fn traffic_policy_instances(
            mut self,
            input: crate::model::TrafficPolicyInstance,
        ) -> Self {
            let mut v = self.traffic_policy_instances.unwrap_or_default();
            v.push(input);
            self.traffic_policy_instances = Some(v);
            self
        }
        /// <p>A list that contains one <code>TrafficPolicyInstance</code> element for each traffic policy instance that matches the elements in the request.</p>
        pub fn set_traffic_policy_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TrafficPolicyInstance>>,
        ) -> Self {
            self.traffic_policy_instances = input;
            self
        }
        /// <p>If <code>IsTruncated</code> is <code>true</code>, <code>HostedZoneIdMarker</code> is the ID of the hosted zone of the first traffic policy instance that Route 53 will return if you submit another <code>ListTrafficPolicyInstances</code> request. </p>
        pub fn hosted_zone_id_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.hosted_zone_id_marker = Some(input.into());
            self
        }
        /// <p>If <code>IsTruncated</code> is <code>true</code>, <code>HostedZoneIdMarker</code> is the ID of the hosted zone of the first traffic policy instance that Route 53 will return if you submit another <code>ListTrafficPolicyInstances</code> request. </p>
        pub fn set_hosted_zone_id_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hosted_zone_id_marker = input;
            self
        }
        /// <p>If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceNameMarker</code> is the name of the first traffic policy instance that Route 53 will return if you submit another <code>ListTrafficPolicyInstances</code> request. </p>
        pub fn traffic_policy_instance_name_marker(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.traffic_policy_instance_name_marker = Some(input.into());
            self
        }
        /// <p>If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceNameMarker</code> is the name of the first traffic policy instance that Route 53 will return if you submit another <code>ListTrafficPolicyInstances</code> request. </p>
        pub fn set_traffic_policy_instance_name_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.traffic_policy_instance_name_marker = input;
            self
        }
        /// <p>If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceTypeMarker</code> is the DNS type of the resource record sets that are associated with the first traffic policy instance that Amazon Route 53 will return if you submit another <code>ListTrafficPolicyInstances</code> request. </p>
        pub fn traffic_policy_instance_type_marker(mut self, input: crate::model::RrType) -> Self {
            self.traffic_policy_instance_type_marker = Some(input);
            self
        }
        /// <p>If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceTypeMarker</code> is the DNS type of the resource record sets that are associated with the first traffic policy instance that Amazon Route 53 will return if you submit another <code>ListTrafficPolicyInstances</code> request. </p>
        pub fn set_traffic_policy_instance_type_marker(
            mut self,
            input: std::option::Option<crate::model::RrType>,
        ) -> Self {
            self.traffic_policy_instance_type_marker = input;
            self
        }
        /// <p>A flag that indicates whether there are more traffic policy instances to be listed. If the response was truncated, you can get more traffic policy instances by calling <code>ListTrafficPolicyInstances</code> again and specifying the values of the <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code> in the corresponding request parameters.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more traffic policy instances to be listed. If the response was truncated, you can get more traffic policy instances by calling <code>ListTrafficPolicyInstances</code> again and specifying the values of the <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code> in the corresponding request parameters.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>The value that you specified for the <code>MaxItems</code> parameter in the call to <code>ListTrafficPolicyInstances</code> that produced the current response.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The value that you specified for the <code>MaxItems</code> parameter in the call to <code>ListTrafficPolicyInstances</code> that produced the current response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTrafficPolicyInstancesOutput`](crate::output::ListTrafficPolicyInstancesOutput)
        pub fn build(self) -> crate::output::ListTrafficPolicyInstancesOutput {
            crate::output::ListTrafficPolicyInstancesOutput {
                traffic_policy_instances: self.traffic_policy_instances,
                hosted_zone_id_marker: self.hosted_zone_id_marker,
                traffic_policy_instance_name_marker: self.traffic_policy_instance_name_marker,
                traffic_policy_instance_type_marker: self.traffic_policy_instance_type_marker,
                is_truncated: self.is_truncated.unwrap_or_default(),
                max_items: self.max_items,
            }
        }
    }
}
impl ListTrafficPolicyInstancesOutput {
    /// Creates a new builder-style object to manufacture [`ListTrafficPolicyInstancesOutput`](crate::output::ListTrafficPolicyInstancesOutput)
    pub fn builder() -> crate::output::list_traffic_policy_instances_output::Builder {
        crate::output::list_traffic_policy_instances_output::Builder::default()
    }
}

/// <p>A complex type that contains the response information for the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTrafficPoliciesOutput {
    /// <p>A list that contains one <code>TrafficPolicySummary</code> element for each traffic policy that was created by the current Amazon Web Services account.</p>
    pub traffic_policy_summaries:
        std::option::Option<std::vec::Vec<crate::model::TrafficPolicySummary>>,
    /// <p>A flag that indicates whether there are more traffic policies to be listed. If the response was truncated, you can get the next group of traffic policies by submitting another <code>ListTrafficPolicies</code> request and specifying the value of <code>TrafficPolicyIdMarker</code> in the <code>TrafficPolicyIdMarker</code> request parameter.</p>
    pub is_truncated: bool,
    /// <p>If the value of <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyIdMarker</code> is the ID of the first traffic policy in the next group of <code>MaxItems</code> traffic policies.</p>
    pub traffic_policy_id_marker: std::option::Option<std::string::String>,
    /// <p>The value that you specified for the <code>MaxItems</code> parameter in the <code>ListTrafficPolicies</code> request that produced the current response.</p>
    pub max_items: std::option::Option<i32>,
}
impl ListTrafficPoliciesOutput {
    /// <p>A list that contains one <code>TrafficPolicySummary</code> element for each traffic policy that was created by the current Amazon Web Services account.</p>
    pub fn traffic_policy_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::TrafficPolicySummary]> {
        self.traffic_policy_summaries.as_deref()
    }
    /// <p>A flag that indicates whether there are more traffic policies to be listed. If the response was truncated, you can get the next group of traffic policies by submitting another <code>ListTrafficPolicies</code> request and specifying the value of <code>TrafficPolicyIdMarker</code> in the <code>TrafficPolicyIdMarker</code> request parameter.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>If the value of <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyIdMarker</code> is the ID of the first traffic policy in the next group of <code>MaxItems</code> traffic policies.</p>
    pub fn traffic_policy_id_marker(&self) -> std::option::Option<&str> {
        self.traffic_policy_id_marker.as_deref()
    }
    /// <p>The value that you specified for the <code>MaxItems</code> parameter in the <code>ListTrafficPolicies</code> request that produced the current response.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListTrafficPoliciesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTrafficPoliciesOutput");
        formatter.field("traffic_policy_summaries", &self.traffic_policy_summaries);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("traffic_policy_id_marker", &self.traffic_policy_id_marker);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}
/// See [`ListTrafficPoliciesOutput`](crate::output::ListTrafficPoliciesOutput)
pub mod list_traffic_policies_output {
    /// A builder for [`ListTrafficPoliciesOutput`](crate::output::ListTrafficPoliciesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) traffic_policy_summaries:
            std::option::Option<std::vec::Vec<crate::model::TrafficPolicySummary>>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) traffic_policy_id_marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `traffic_policy_summaries`.
        ///
        /// To override the contents of this collection use [`set_traffic_policy_summaries`](Self::set_traffic_policy_summaries).
        ///
        /// <p>A list that contains one <code>TrafficPolicySummary</code> element for each traffic policy that was created by the current Amazon Web Services account.</p>
        pub fn traffic_policy_summaries(
            mut self,
            input: crate::model::TrafficPolicySummary,
        ) -> Self {
            let mut v = self.traffic_policy_summaries.unwrap_or_default();
            v.push(input);
            self.traffic_policy_summaries = Some(v);
            self
        }
        /// <p>A list that contains one <code>TrafficPolicySummary</code> element for each traffic policy that was created by the current Amazon Web Services account.</p>
        pub fn set_traffic_policy_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TrafficPolicySummary>>,
        ) -> Self {
            self.traffic_policy_summaries = input;
            self
        }
        /// <p>A flag that indicates whether there are more traffic policies to be listed. If the response was truncated, you can get the next group of traffic policies by submitting another <code>ListTrafficPolicies</code> request and specifying the value of <code>TrafficPolicyIdMarker</code> in the <code>TrafficPolicyIdMarker</code> request parameter.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more traffic policies to be listed. If the response was truncated, you can get the next group of traffic policies by submitting another <code>ListTrafficPolicies</code> request and specifying the value of <code>TrafficPolicyIdMarker</code> in the <code>TrafficPolicyIdMarker</code> request parameter.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>If the value of <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyIdMarker</code> is the ID of the first traffic policy in the next group of <code>MaxItems</code> traffic policies.</p>
        pub fn traffic_policy_id_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.traffic_policy_id_marker = Some(input.into());
            self
        }
        /// <p>If the value of <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyIdMarker</code> is the ID of the first traffic policy in the next group of <code>MaxItems</code> traffic policies.</p>
        pub fn set_traffic_policy_id_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.traffic_policy_id_marker = input;
            self
        }
        /// <p>The value that you specified for the <code>MaxItems</code> parameter in the <code>ListTrafficPolicies</code> request that produced the current response.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The value that you specified for the <code>MaxItems</code> parameter in the <code>ListTrafficPolicies</code> request that produced the current response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTrafficPoliciesOutput`](crate::output::ListTrafficPoliciesOutput)
        pub fn build(self) -> crate::output::ListTrafficPoliciesOutput {
            crate::output::ListTrafficPoliciesOutput {
                traffic_policy_summaries: self.traffic_policy_summaries,
                is_truncated: self.is_truncated.unwrap_or_default(),
                traffic_policy_id_marker: self.traffic_policy_id_marker,
                max_items: self.max_items,
            }
        }
    }
}
impl ListTrafficPoliciesOutput {
    /// Creates a new builder-style object to manufacture [`ListTrafficPoliciesOutput`](crate::output::ListTrafficPoliciesOutput)
    pub fn builder() -> crate::output::list_traffic_policies_output::Builder {
        crate::output::list_traffic_policies_output::Builder::default()
    }
}

/// <p>A complex type containing tags for the specified resources.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourcesOutput {
    /// <p>A list of <code>ResourceTagSet</code>s containing tags associated with the specified resources.</p>
    pub resource_tag_sets: std::option::Option<std::vec::Vec<crate::model::ResourceTagSet>>,
}
impl ListTagsForResourcesOutput {
    /// <p>A list of <code>ResourceTagSet</code>s containing tags associated with the specified resources.</p>
    pub fn resource_tag_sets(&self) -> std::option::Option<&[crate::model::ResourceTagSet]> {
        self.resource_tag_sets.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourcesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourcesOutput");
        formatter.field("resource_tag_sets", &self.resource_tag_sets);
        formatter.finish()
    }
}
/// See [`ListTagsForResourcesOutput`](crate::output::ListTagsForResourcesOutput)
pub mod list_tags_for_resources_output {
    /// A builder for [`ListTagsForResourcesOutput`](crate::output::ListTagsForResourcesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_tag_sets:
            std::option::Option<std::vec::Vec<crate::model::ResourceTagSet>>,
    }
    impl Builder {
        /// Appends an item to `resource_tag_sets`.
        ///
        /// To override the contents of this collection use [`set_resource_tag_sets`](Self::set_resource_tag_sets).
        ///
        /// <p>A list of <code>ResourceTagSet</code>s containing tags associated with the specified resources.</p>
        pub fn resource_tag_sets(mut self, input: crate::model::ResourceTagSet) -> Self {
            let mut v = self.resource_tag_sets.unwrap_or_default();
            v.push(input);
            self.resource_tag_sets = Some(v);
            self
        }
        /// <p>A list of <code>ResourceTagSet</code>s containing tags associated with the specified resources.</p>
        pub fn set_resource_tag_sets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceTagSet>>,
        ) -> Self {
            self.resource_tag_sets = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourcesOutput`](crate::output::ListTagsForResourcesOutput)
        pub fn build(self) -> crate::output::ListTagsForResourcesOutput {
            crate::output::ListTagsForResourcesOutput {
                resource_tag_sets: self.resource_tag_sets,
            }
        }
    }
}
impl ListTagsForResourcesOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourcesOutput`](crate::output::ListTagsForResourcesOutput)
    pub fn builder() -> crate::output::list_tags_for_resources_output::Builder {
        crate::output::list_tags_for_resources_output::Builder::default()
    }
}

/// <p>A complex type that contains information about the health checks or hosted zones for which you want to list tags.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>A <code>ResourceTagSet</code> containing tags associated with the specified resource.</p>
    pub resource_tag_set: std::option::Option<crate::model::ResourceTagSet>,
}
impl ListTagsForResourceOutput {
    /// <p>A <code>ResourceTagSet</code> containing tags associated with the specified resource.</p>
    pub fn resource_tag_set(&self) -> std::option::Option<&crate::model::ResourceTagSet> {
        self.resource_tag_set.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("resource_tag_set", &self.resource_tag_set);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_tag_set: std::option::Option<crate::model::ResourceTagSet>,
    }
    impl Builder {
        /// <p>A <code>ResourceTagSet</code> containing tags associated with the specified resource.</p>
        pub fn resource_tag_set(mut self, input: crate::model::ResourceTagSet) -> Self {
            self.resource_tag_set = Some(input);
            self
        }
        /// <p>A <code>ResourceTagSet</code> containing tags associated with the specified resource.</p>
        pub fn set_resource_tag_set(
            mut self,
            input: std::option::Option<crate::model::ResourceTagSet>,
        ) -> Self {
            self.resource_tag_set = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput {
                resource_tag_set: self.resource_tag_set,
            }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

/// <p>A complex type that contains information about the reusable delegation sets that are associated with the current Amazon Web Services account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListReusableDelegationSetsOutput {
    /// <p>A complex type that contains one <code>DelegationSet</code> element for each reusable delegation set that was created by the current Amazon Web Services account.</p>
    pub delegation_sets: std::option::Option<std::vec::Vec<crate::model::DelegationSet>>,
    /// <p>For the second and subsequent calls to <code>ListReusableDelegationSets</code>, <code>Marker</code> is the value that you specified for the <code>marker</code> parameter in the request that produced the current response.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>A flag that indicates whether there are more reusable delegation sets to be listed.</p>
    pub is_truncated: bool,
    /// <p>If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextMarker</code> identifies the next reusable delegation set that Amazon Route 53 will return if you submit another <code>ListReusableDelegationSets</code> request and specify the value of <code>NextMarker</code> in the <code>marker</code> parameter.</p>
    pub next_marker: std::option::Option<std::string::String>,
    /// <p>The value that you specified for the <code>maxitems</code> parameter in the call to <code>ListReusableDelegationSets</code> that produced the current response.</p>
    pub max_items: std::option::Option<i32>,
}
impl ListReusableDelegationSetsOutput {
    /// <p>A complex type that contains one <code>DelegationSet</code> element for each reusable delegation set that was created by the current Amazon Web Services account.</p>
    pub fn delegation_sets(&self) -> std::option::Option<&[crate::model::DelegationSet]> {
        self.delegation_sets.as_deref()
    }
    /// <p>For the second and subsequent calls to <code>ListReusableDelegationSets</code>, <code>Marker</code> is the value that you specified for the <code>marker</code> parameter in the request that produced the current response.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>A flag that indicates whether there are more reusable delegation sets to be listed.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextMarker</code> identifies the next reusable delegation set that Amazon Route 53 will return if you submit another <code>ListReusableDelegationSets</code> request and specify the value of <code>NextMarker</code> in the <code>marker</code> parameter.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
    /// <p>The value that you specified for the <code>maxitems</code> parameter in the call to <code>ListReusableDelegationSets</code> that produced the current response.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListReusableDelegationSetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListReusableDelegationSetsOutput");
        formatter.field("delegation_sets", &self.delegation_sets);
        formatter.field("marker", &self.marker);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("next_marker", &self.next_marker);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}
/// See [`ListReusableDelegationSetsOutput`](crate::output::ListReusableDelegationSetsOutput)
pub mod list_reusable_delegation_sets_output {
    /// A builder for [`ListReusableDelegationSetsOutput`](crate::output::ListReusableDelegationSetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delegation_sets: std::option::Option<std::vec::Vec<crate::model::DelegationSet>>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) next_marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `delegation_sets`.
        ///
        /// To override the contents of this collection use [`set_delegation_sets`](Self::set_delegation_sets).
        ///
        /// <p>A complex type that contains one <code>DelegationSet</code> element for each reusable delegation set that was created by the current Amazon Web Services account.</p>
        pub fn delegation_sets(mut self, input: crate::model::DelegationSet) -> Self {
            let mut v = self.delegation_sets.unwrap_or_default();
            v.push(input);
            self.delegation_sets = Some(v);
            self
        }
        /// <p>A complex type that contains one <code>DelegationSet</code> element for each reusable delegation set that was created by the current Amazon Web Services account.</p>
        pub fn set_delegation_sets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DelegationSet>>,
        ) -> Self {
            self.delegation_sets = input;
            self
        }
        /// <p>For the second and subsequent calls to <code>ListReusableDelegationSets</code>, <code>Marker</code> is the value that you specified for the <code>marker</code> parameter in the request that produced the current response.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>For the second and subsequent calls to <code>ListReusableDelegationSets</code>, <code>Marker</code> is the value that you specified for the <code>marker</code> parameter in the request that produced the current response.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>A flag that indicates whether there are more reusable delegation sets to be listed.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more reusable delegation sets to be listed.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextMarker</code> identifies the next reusable delegation set that Amazon Route 53 will return if you submit another <code>ListReusableDelegationSets</code> request and specify the value of <code>NextMarker</code> in the <code>marker</code> parameter.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextMarker</code> identifies the next reusable delegation set that Amazon Route 53 will return if you submit another <code>ListReusableDelegationSets</code> request and specify the value of <code>NextMarker</code> in the <code>marker</code> parameter.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// <p>The value that you specified for the <code>maxitems</code> parameter in the call to <code>ListReusableDelegationSets</code> that produced the current response.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The value that you specified for the <code>maxitems</code> parameter in the call to <code>ListReusableDelegationSets</code> that produced the current response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListReusableDelegationSetsOutput`](crate::output::ListReusableDelegationSetsOutput)
        pub fn build(self) -> crate::output::ListReusableDelegationSetsOutput {
            crate::output::ListReusableDelegationSetsOutput {
                delegation_sets: self.delegation_sets,
                marker: self.marker,
                is_truncated: self.is_truncated.unwrap_or_default(),
                next_marker: self.next_marker,
                max_items: self.max_items,
            }
        }
    }
}
impl ListReusableDelegationSetsOutput {
    /// Creates a new builder-style object to manufacture [`ListReusableDelegationSetsOutput`](crate::output::ListReusableDelegationSetsOutput)
    pub fn builder() -> crate::output::list_reusable_delegation_sets_output::Builder {
        crate::output::list_reusable_delegation_sets_output::Builder::default()
    }
}

/// <p>A complex type that contains list information for the resource record set.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResourceRecordSetsOutput {
    /// <p>Information about multiple resource record sets.</p>
    pub resource_record_sets: std::option::Option<std::vec::Vec<crate::model::ResourceRecordSet>>,
    /// <p>A flag that indicates whether more resource record sets remain to be listed. If your results were truncated, you can make a follow-up pagination request by using the <code>NextRecordName</code> element.</p>
    pub is_truncated: bool,
    /// <p>If the results were truncated, the name of the next record in the list.</p>
    /// <p>This element is present only if <code>IsTruncated</code> is true. </p>
    pub next_record_name: std::option::Option<std::string::String>,
    /// <p>If the results were truncated, the type of the next record in the list.</p>
    /// <p>This element is present only if <code>IsTruncated</code> is true. </p>
    pub next_record_type: std::option::Option<crate::model::RrType>,
    /// <p> <i>Resource record sets that have a routing policy other than simple:</i> If results were truncated for a given DNS name and type, the value of <code>SetIdentifier</code> for the next resource record set that has the current DNS name and type.</p>
    /// <p>For information about routing policies, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html">Choosing a Routing Policy</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
    pub next_record_identifier: std::option::Option<std::string::String>,
    /// <p>The maximum number of records you requested.</p>
    pub max_items: std::option::Option<i32>,
}
impl ListResourceRecordSetsOutput {
    /// <p>Information about multiple resource record sets.</p>
    pub fn resource_record_sets(&self) -> std::option::Option<&[crate::model::ResourceRecordSet]> {
        self.resource_record_sets.as_deref()
    }
    /// <p>A flag that indicates whether more resource record sets remain to be listed. If your results were truncated, you can make a follow-up pagination request by using the <code>NextRecordName</code> element.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>If the results were truncated, the name of the next record in the list.</p>
    /// <p>This element is present only if <code>IsTruncated</code> is true. </p>
    pub fn next_record_name(&self) -> std::option::Option<&str> {
        self.next_record_name.as_deref()
    }
    /// <p>If the results were truncated, the type of the next record in the list.</p>
    /// <p>This element is present only if <code>IsTruncated</code> is true. </p>
    pub fn next_record_type(&self) -> std::option::Option<&crate::model::RrType> {
        self.next_record_type.as_ref()
    }
    /// <p> <i>Resource record sets that have a routing policy other than simple:</i> If results were truncated for a given DNS name and type, the value of <code>SetIdentifier</code> for the next resource record set that has the current DNS name and type.</p>
    /// <p>For information about routing policies, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html">Choosing a Routing Policy</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
    pub fn next_record_identifier(&self) -> std::option::Option<&str> {
        self.next_record_identifier.as_deref()
    }
    /// <p>The maximum number of records you requested.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListResourceRecordSetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResourceRecordSetsOutput");
        formatter.field("resource_record_sets", &self.resource_record_sets);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("next_record_name", &self.next_record_name);
        formatter.field("next_record_type", &self.next_record_type);
        formatter.field("next_record_identifier", &self.next_record_identifier);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}
/// See [`ListResourceRecordSetsOutput`](crate::output::ListResourceRecordSetsOutput)
pub mod list_resource_record_sets_output {
    /// A builder for [`ListResourceRecordSetsOutput`](crate::output::ListResourceRecordSetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_record_sets:
            std::option::Option<std::vec::Vec<crate::model::ResourceRecordSet>>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) next_record_name: std::option::Option<std::string::String>,
        pub(crate) next_record_type: std::option::Option<crate::model::RrType>,
        pub(crate) next_record_identifier: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `resource_record_sets`.
        ///
        /// To override the contents of this collection use [`set_resource_record_sets`](Self::set_resource_record_sets).
        ///
        /// <p>Information about multiple resource record sets.</p>
        pub fn resource_record_sets(mut self, input: crate::model::ResourceRecordSet) -> Self {
            let mut v = self.resource_record_sets.unwrap_or_default();
            v.push(input);
            self.resource_record_sets = Some(v);
            self
        }
        /// <p>Information about multiple resource record sets.</p>
        pub fn set_resource_record_sets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceRecordSet>>,
        ) -> Self {
            self.resource_record_sets = input;
            self
        }
        /// <p>A flag that indicates whether more resource record sets remain to be listed. If your results were truncated, you can make a follow-up pagination request by using the <code>NextRecordName</code> element.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether more resource record sets remain to be listed. If your results were truncated, you can make a follow-up pagination request by using the <code>NextRecordName</code> element.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>If the results were truncated, the name of the next record in the list.</p>
        /// <p>This element is present only if <code>IsTruncated</code> is true. </p>
        pub fn next_record_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_record_name = Some(input.into());
            self
        }
        /// <p>If the results were truncated, the name of the next record in the list.</p>
        /// <p>This element is present only if <code>IsTruncated</code> is true. </p>
        pub fn set_next_record_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_record_name = input;
            self
        }
        /// <p>If the results were truncated, the type of the next record in the list.</p>
        /// <p>This element is present only if <code>IsTruncated</code> is true. </p>
        pub fn next_record_type(mut self, input: crate::model::RrType) -> Self {
            self.next_record_type = Some(input);
            self
        }
        /// <p>If the results were truncated, the type of the next record in the list.</p>
        /// <p>This element is present only if <code>IsTruncated</code> is true. </p>
        pub fn set_next_record_type(
            mut self,
            input: std::option::Option<crate::model::RrType>,
        ) -> Self {
            self.next_record_type = input;
            self
        }
        /// <p> <i>Resource record sets that have a routing policy other than simple:</i> If results were truncated for a given DNS name and type, the value of <code>SetIdentifier</code> for the next resource record set that has the current DNS name and type.</p>
        /// <p>For information about routing policies, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html">Choosing a Routing Policy</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
        pub fn next_record_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_record_identifier = Some(input.into());
            self
        }
        /// <p> <i>Resource record sets that have a routing policy other than simple:</i> If results were truncated for a given DNS name and type, the value of <code>SetIdentifier</code> for the next resource record set that has the current DNS name and type.</p>
        /// <p>For information about routing policies, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html">Choosing a Routing Policy</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
        pub fn set_next_record_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_record_identifier = input;
            self
        }
        /// <p>The maximum number of records you requested.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The maximum number of records you requested.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResourceRecordSetsOutput`](crate::output::ListResourceRecordSetsOutput)
        pub fn build(self) -> crate::output::ListResourceRecordSetsOutput {
            crate::output::ListResourceRecordSetsOutput {
                resource_record_sets: self.resource_record_sets,
                is_truncated: self.is_truncated.unwrap_or_default(),
                next_record_name: self.next_record_name,
                next_record_type: self.next_record_type,
                next_record_identifier: self.next_record_identifier,
                max_items: self.max_items,
            }
        }
    }
}
impl ListResourceRecordSetsOutput {
    /// Creates a new builder-style object to manufacture [`ListResourceRecordSetsOutput`](crate::output::ListResourceRecordSetsOutput)
    pub fn builder() -> crate::output::list_resource_record_sets_output::Builder {
        crate::output::list_resource_record_sets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListQueryLoggingConfigsOutput {
    /// <p>An array that contains one <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_QueryLoggingConfig.html">QueryLoggingConfig</a> element for each configuration for DNS query logging that is associated with the current Amazon Web Services account.</p>
    pub query_logging_configs: std::option::Option<std::vec::Vec<crate::model::QueryLoggingConfig>>,
    /// <p>If a response includes the last of the query logging configurations that are associated with the current Amazon Web Services account, <code>NextToken</code> doesn't appear in the response.</p>
    /// <p>If a response doesn't include the last of the configurations, you can get more configurations by submitting another <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListQueryLoggingConfigs.html">ListQueryLoggingConfigs</a> request. Get the value of <code>NextToken</code> that Amazon Route 53 returned in the previous response and include it in <code>NextToken</code> in the next request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListQueryLoggingConfigsOutput {
    /// <p>An array that contains one <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_QueryLoggingConfig.html">QueryLoggingConfig</a> element for each configuration for DNS query logging that is associated with the current Amazon Web Services account.</p>
    pub fn query_logging_configs(
        &self,
    ) -> std::option::Option<&[crate::model::QueryLoggingConfig]> {
        self.query_logging_configs.as_deref()
    }
    /// <p>If a response includes the last of the query logging configurations that are associated with the current Amazon Web Services account, <code>NextToken</code> doesn't appear in the response.</p>
    /// <p>If a response doesn't include the last of the configurations, you can get more configurations by submitting another <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListQueryLoggingConfigs.html">ListQueryLoggingConfigs</a> request. Get the value of <code>NextToken</code> that Amazon Route 53 returned in the previous response and include it in <code>NextToken</code> in the next request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListQueryLoggingConfigsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListQueryLoggingConfigsOutput");
        formatter.field("query_logging_configs", &self.query_logging_configs);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListQueryLoggingConfigsOutput`](crate::output::ListQueryLoggingConfigsOutput)
pub mod list_query_logging_configs_output {
    /// A builder for [`ListQueryLoggingConfigsOutput`](crate::output::ListQueryLoggingConfigsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) query_logging_configs:
            std::option::Option<std::vec::Vec<crate::model::QueryLoggingConfig>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `query_logging_configs`.
        ///
        /// To override the contents of this collection use [`set_query_logging_configs`](Self::set_query_logging_configs).
        ///
        /// <p>An array that contains one <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_QueryLoggingConfig.html">QueryLoggingConfig</a> element for each configuration for DNS query logging that is associated with the current Amazon Web Services account.</p>
        pub fn query_logging_configs(mut self, input: crate::model::QueryLoggingConfig) -> Self {
            let mut v = self.query_logging_configs.unwrap_or_default();
            v.push(input);
            self.query_logging_configs = Some(v);
            self
        }
        /// <p>An array that contains one <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_QueryLoggingConfig.html">QueryLoggingConfig</a> element for each configuration for DNS query logging that is associated with the current Amazon Web Services account.</p>
        pub fn set_query_logging_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::QueryLoggingConfig>>,
        ) -> Self {
            self.query_logging_configs = input;
            self
        }
        /// <p>If a response includes the last of the query logging configurations that are associated with the current Amazon Web Services account, <code>NextToken</code> doesn't appear in the response.</p>
        /// <p>If a response doesn't include the last of the configurations, you can get more configurations by submitting another <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListQueryLoggingConfigs.html">ListQueryLoggingConfigs</a> request. Get the value of <code>NextToken</code> that Amazon Route 53 returned in the previous response and include it in <code>NextToken</code> in the next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If a response includes the last of the query logging configurations that are associated with the current Amazon Web Services account, <code>NextToken</code> doesn't appear in the response.</p>
        /// <p>If a response doesn't include the last of the configurations, you can get more configurations by submitting another <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListQueryLoggingConfigs.html">ListQueryLoggingConfigs</a> request. Get the value of <code>NextToken</code> that Amazon Route 53 returned in the previous response and include it in <code>NextToken</code> in the next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListQueryLoggingConfigsOutput`](crate::output::ListQueryLoggingConfigsOutput)
        pub fn build(self) -> crate::output::ListQueryLoggingConfigsOutput {
            crate::output::ListQueryLoggingConfigsOutput {
                query_logging_configs: self.query_logging_configs,
                next_token: self.next_token,
            }
        }
    }
}
impl ListQueryLoggingConfigsOutput {
    /// Creates a new builder-style object to manufacture [`ListQueryLoggingConfigsOutput`](crate::output::ListQueryLoggingConfigsOutput)
    pub fn builder() -> crate::output::list_query_logging_configs_output::Builder {
        crate::output::list_query_logging_configs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListHostedZonesByVpcOutput {
    /// <p>A list that contains one <code>HostedZoneSummary</code> element for each hosted zone that the specified Amazon VPC is associated with. Each <code>HostedZoneSummary</code> element contains the hosted zone name and ID, and information about who owns the hosted zone.</p>
    pub hosted_zone_summaries: std::option::Option<std::vec::Vec<crate::model::HostedZoneSummary>>,
    /// <p>The value that you specified for <code>MaxItems</code> in the most recent <code>ListHostedZonesByVPC</code> request.</p>
    pub max_items: std::option::Option<i32>,
    /// <p>The value that you will use for <code>NextToken</code> in the next <code>ListHostedZonesByVPC</code> request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListHostedZonesByVpcOutput {
    /// <p>A list that contains one <code>HostedZoneSummary</code> element for each hosted zone that the specified Amazon VPC is associated with. Each <code>HostedZoneSummary</code> element contains the hosted zone name and ID, and information about who owns the hosted zone.</p>
    pub fn hosted_zone_summaries(&self) -> std::option::Option<&[crate::model::HostedZoneSummary]> {
        self.hosted_zone_summaries.as_deref()
    }
    /// <p>The value that you specified for <code>MaxItems</code> in the most recent <code>ListHostedZonesByVPC</code> request.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
    /// <p>The value that you will use for <code>NextToken</code> in the next <code>ListHostedZonesByVPC</code> request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListHostedZonesByVpcOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListHostedZonesByVpcOutput");
        formatter.field("hosted_zone_summaries", &self.hosted_zone_summaries);
        formatter.field("max_items", &self.max_items);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListHostedZonesByVpcOutput`](crate::output::ListHostedZonesByVpcOutput)
pub mod list_hosted_zones_by_vpc_output {
    /// A builder for [`ListHostedZonesByVpcOutput`](crate::output::ListHostedZonesByVpcOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hosted_zone_summaries:
            std::option::Option<std::vec::Vec<crate::model::HostedZoneSummary>>,
        pub(crate) max_items: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `hosted_zone_summaries`.
        ///
        /// To override the contents of this collection use [`set_hosted_zone_summaries`](Self::set_hosted_zone_summaries).
        ///
        /// <p>A list that contains one <code>HostedZoneSummary</code> element for each hosted zone that the specified Amazon VPC is associated with. Each <code>HostedZoneSummary</code> element contains the hosted zone name and ID, and information about who owns the hosted zone.</p>
        pub fn hosted_zone_summaries(mut self, input: crate::model::HostedZoneSummary) -> Self {
            let mut v = self.hosted_zone_summaries.unwrap_or_default();
            v.push(input);
            self.hosted_zone_summaries = Some(v);
            self
        }
        /// <p>A list that contains one <code>HostedZoneSummary</code> element for each hosted zone that the specified Amazon VPC is associated with. Each <code>HostedZoneSummary</code> element contains the hosted zone name and ID, and information about who owns the hosted zone.</p>
        pub fn set_hosted_zone_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HostedZoneSummary>>,
        ) -> Self {
            self.hosted_zone_summaries = input;
            self
        }
        /// <p>The value that you specified for <code>MaxItems</code> in the most recent <code>ListHostedZonesByVPC</code> request.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The value that you specified for <code>MaxItems</code> in the most recent <code>ListHostedZonesByVPC</code> request.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// <p>The value that you will use for <code>NextToken</code> in the next <code>ListHostedZonesByVPC</code> request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The value that you will use for <code>NextToken</code> in the next <code>ListHostedZonesByVPC</code> request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListHostedZonesByVpcOutput`](crate::output::ListHostedZonesByVpcOutput)
        pub fn build(self) -> crate::output::ListHostedZonesByVpcOutput {
            crate::output::ListHostedZonesByVpcOutput {
                hosted_zone_summaries: self.hosted_zone_summaries,
                max_items: self.max_items,
                next_token: self.next_token,
            }
        }
    }
}
impl ListHostedZonesByVpcOutput {
    /// Creates a new builder-style object to manufacture [`ListHostedZonesByVpcOutput`](crate::output::ListHostedZonesByVpcOutput)
    pub fn builder() -> crate::output::list_hosted_zones_by_vpc_output::Builder {
        crate::output::list_hosted_zones_by_vpc_output::Builder::default()
    }
}

/// <p>A complex type that contains the response information for the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListHostedZonesByNameOutput {
    /// <p>A complex type that contains general information about the hosted zone.</p>
    pub hosted_zones: std::option::Option<std::vec::Vec<crate::model::HostedZone>>,
    /// <p>For the second and subsequent calls to <code>ListHostedZonesByName</code>, <code>DNSName</code> is the value that you specified for the <code>dnsname</code> parameter in the request that produced the current response.</p>
    pub dns_name: std::option::Option<std::string::String>,
    /// <p>The ID that Amazon Route 53 assigned to the hosted zone when you created it.</p>
    pub hosted_zone_id: std::option::Option<std::string::String>,
    /// <p>A flag that indicates whether there are more hosted zones to be listed. If the response was truncated, you can get the next group of <code>maxitems</code> hosted zones by calling <code>ListHostedZonesByName</code> again and specifying the values of <code>NextDNSName</code> and <code>NextHostedZoneId</code> elements in the <code>dnsname</code> and <code>hostedzoneid</code> parameters.</p>
    pub is_truncated: bool,
    /// <p>If <code>IsTruncated</code> is true, the value of <code>NextDNSName</code> is the name of the first hosted zone in the next group of <code>maxitems</code> hosted zones. Call <code>ListHostedZonesByName</code> again and specify the value of <code>NextDNSName</code> and <code>NextHostedZoneId</code> in the <code>dnsname</code> and <code>hostedzoneid</code> parameters, respectively.</p>
    /// <p>This element is present only if <code>IsTruncated</code> is <code>true</code>.</p>
    pub next_dns_name: std::option::Option<std::string::String>,
    /// <p>If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextHostedZoneId</code> identifies the first hosted zone in the next group of <code>maxitems</code> hosted zones. Call <code>ListHostedZonesByName</code> again and specify the value of <code>NextDNSName</code> and <code>NextHostedZoneId</code> in the <code>dnsname</code> and <code>hostedzoneid</code> parameters, respectively.</p>
    /// <p>This element is present only if <code>IsTruncated</code> is <code>true</code>.</p>
    pub next_hosted_zone_id: std::option::Option<std::string::String>,
    /// <p>The value that you specified for the <code>maxitems</code> parameter in the call to <code>ListHostedZonesByName</code> that produced the current response.</p>
    pub max_items: std::option::Option<i32>,
}
impl ListHostedZonesByNameOutput {
    /// <p>A complex type that contains general information about the hosted zone.</p>
    pub fn hosted_zones(&self) -> std::option::Option<&[crate::model::HostedZone]> {
        self.hosted_zones.as_deref()
    }
    /// <p>For the second and subsequent calls to <code>ListHostedZonesByName</code>, <code>DNSName</code> is the value that you specified for the <code>dnsname</code> parameter in the request that produced the current response.</p>
    pub fn dns_name(&self) -> std::option::Option<&str> {
        self.dns_name.as_deref()
    }
    /// <p>The ID that Amazon Route 53 assigned to the hosted zone when you created it.</p>
    pub fn hosted_zone_id(&self) -> std::option::Option<&str> {
        self.hosted_zone_id.as_deref()
    }
    /// <p>A flag that indicates whether there are more hosted zones to be listed. If the response was truncated, you can get the next group of <code>maxitems</code> hosted zones by calling <code>ListHostedZonesByName</code> again and specifying the values of <code>NextDNSName</code> and <code>NextHostedZoneId</code> elements in the <code>dnsname</code> and <code>hostedzoneid</code> parameters.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>If <code>IsTruncated</code> is true, the value of <code>NextDNSName</code> is the name of the first hosted zone in the next group of <code>maxitems</code> hosted zones. Call <code>ListHostedZonesByName</code> again and specify the value of <code>NextDNSName</code> and <code>NextHostedZoneId</code> in the <code>dnsname</code> and <code>hostedzoneid</code> parameters, respectively.</p>
    /// <p>This element is present only if <code>IsTruncated</code> is <code>true</code>.</p>
    pub fn next_dns_name(&self) -> std::option::Option<&str> {
        self.next_dns_name.as_deref()
    }
    /// <p>If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextHostedZoneId</code> identifies the first hosted zone in the next group of <code>maxitems</code> hosted zones. Call <code>ListHostedZonesByName</code> again and specify the value of <code>NextDNSName</code> and <code>NextHostedZoneId</code> in the <code>dnsname</code> and <code>hostedzoneid</code> parameters, respectively.</p>
    /// <p>This element is present only if <code>IsTruncated</code> is <code>true</code>.</p>
    pub fn next_hosted_zone_id(&self) -> std::option::Option<&str> {
        self.next_hosted_zone_id.as_deref()
    }
    /// <p>The value that you specified for the <code>maxitems</code> parameter in the call to <code>ListHostedZonesByName</code> that produced the current response.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListHostedZonesByNameOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListHostedZonesByNameOutput");
        formatter.field("hosted_zones", &self.hosted_zones);
        formatter.field("dns_name", &self.dns_name);
        formatter.field("hosted_zone_id", &self.hosted_zone_id);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("next_dns_name", &self.next_dns_name);
        formatter.field("next_hosted_zone_id", &self.next_hosted_zone_id);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}
/// See [`ListHostedZonesByNameOutput`](crate::output::ListHostedZonesByNameOutput)
pub mod list_hosted_zones_by_name_output {
    /// A builder for [`ListHostedZonesByNameOutput`](crate::output::ListHostedZonesByNameOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hosted_zones: std::option::Option<std::vec::Vec<crate::model::HostedZone>>,
        pub(crate) dns_name: std::option::Option<std::string::String>,
        pub(crate) hosted_zone_id: std::option::Option<std::string::String>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) next_dns_name: std::option::Option<std::string::String>,
        pub(crate) next_hosted_zone_id: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `hosted_zones`.
        ///
        /// To override the contents of this collection use [`set_hosted_zones`](Self::set_hosted_zones).
        ///
        /// <p>A complex type that contains general information about the hosted zone.</p>
        pub fn hosted_zones(mut self, input: crate::model::HostedZone) -> Self {
            let mut v = self.hosted_zones.unwrap_or_default();
            v.push(input);
            self.hosted_zones = Some(v);
            self
        }
        /// <p>A complex type that contains general information about the hosted zone.</p>
        pub fn set_hosted_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HostedZone>>,
        ) -> Self {
            self.hosted_zones = input;
            self
        }
        /// <p>For the second and subsequent calls to <code>ListHostedZonesByName</code>, <code>DNSName</code> is the value that you specified for the <code>dnsname</code> parameter in the request that produced the current response.</p>
        pub fn dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dns_name = Some(input.into());
            self
        }
        /// <p>For the second and subsequent calls to <code>ListHostedZonesByName</code>, <code>DNSName</code> is the value that you specified for the <code>dnsname</code> parameter in the request that produced the current response.</p>
        pub fn set_dns_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dns_name = input;
            self
        }
        /// <p>The ID that Amazon Route 53 assigned to the hosted zone when you created it.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hosted_zone_id = Some(input.into());
            self
        }
        /// <p>The ID that Amazon Route 53 assigned to the hosted zone when you created it.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hosted_zone_id = input;
            self
        }
        /// <p>A flag that indicates whether there are more hosted zones to be listed. If the response was truncated, you can get the next group of <code>maxitems</code> hosted zones by calling <code>ListHostedZonesByName</code> again and specifying the values of <code>NextDNSName</code> and <code>NextHostedZoneId</code> elements in the <code>dnsname</code> and <code>hostedzoneid</code> parameters.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more hosted zones to be listed. If the response was truncated, you can get the next group of <code>maxitems</code> hosted zones by calling <code>ListHostedZonesByName</code> again and specifying the values of <code>NextDNSName</code> and <code>NextHostedZoneId</code> elements in the <code>dnsname</code> and <code>hostedzoneid</code> parameters.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>If <code>IsTruncated</code> is true, the value of <code>NextDNSName</code> is the name of the first hosted zone in the next group of <code>maxitems</code> hosted zones. Call <code>ListHostedZonesByName</code> again and specify the value of <code>NextDNSName</code> and <code>NextHostedZoneId</code> in the <code>dnsname</code> and <code>hostedzoneid</code> parameters, respectively.</p>
        /// <p>This element is present only if <code>IsTruncated</code> is <code>true</code>.</p>
        pub fn next_dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_dns_name = Some(input.into());
            self
        }
        /// <p>If <code>IsTruncated</code> is true, the value of <code>NextDNSName</code> is the name of the first hosted zone in the next group of <code>maxitems</code> hosted zones. Call <code>ListHostedZonesByName</code> again and specify the value of <code>NextDNSName</code> and <code>NextHostedZoneId</code> in the <code>dnsname</code> and <code>hostedzoneid</code> parameters, respectively.</p>
        /// <p>This element is present only if <code>IsTruncated</code> is <code>true</code>.</p>
        pub fn set_next_dns_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_dns_name = input;
            self
        }
        /// <p>If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextHostedZoneId</code> identifies the first hosted zone in the next group of <code>maxitems</code> hosted zones. Call <code>ListHostedZonesByName</code> again and specify the value of <code>NextDNSName</code> and <code>NextHostedZoneId</code> in the <code>dnsname</code> and <code>hostedzoneid</code> parameters, respectively.</p>
        /// <p>This element is present only if <code>IsTruncated</code> is <code>true</code>.</p>
        pub fn next_hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_hosted_zone_id = Some(input.into());
            self
        }
        /// <p>If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextHostedZoneId</code> identifies the first hosted zone in the next group of <code>maxitems</code> hosted zones. Call <code>ListHostedZonesByName</code> again and specify the value of <code>NextDNSName</code> and <code>NextHostedZoneId</code> in the <code>dnsname</code> and <code>hostedzoneid</code> parameters, respectively.</p>
        /// <p>This element is present only if <code>IsTruncated</code> is <code>true</code>.</p>
        pub fn set_next_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_hosted_zone_id = input;
            self
        }
        /// <p>The value that you specified for the <code>maxitems</code> parameter in the call to <code>ListHostedZonesByName</code> that produced the current response.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The value that you specified for the <code>maxitems</code> parameter in the call to <code>ListHostedZonesByName</code> that produced the current response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListHostedZonesByNameOutput`](crate::output::ListHostedZonesByNameOutput)
        pub fn build(self) -> crate::output::ListHostedZonesByNameOutput {
            crate::output::ListHostedZonesByNameOutput {
                hosted_zones: self.hosted_zones,
                dns_name: self.dns_name,
                hosted_zone_id: self.hosted_zone_id,
                is_truncated: self.is_truncated.unwrap_or_default(),
                next_dns_name: self.next_dns_name,
                next_hosted_zone_id: self.next_hosted_zone_id,
                max_items: self.max_items,
            }
        }
    }
}
impl ListHostedZonesByNameOutput {
    /// Creates a new builder-style object to manufacture [`ListHostedZonesByNameOutput`](crate::output::ListHostedZonesByNameOutput)
    pub fn builder() -> crate::output::list_hosted_zones_by_name_output::Builder {
        crate::output::list_hosted_zones_by_name_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListHostedZonesOutput {
    /// <p>A complex type that contains general information about the hosted zone.</p>
    pub hosted_zones: std::option::Option<std::vec::Vec<crate::model::HostedZone>>,
    /// <p>For the second and subsequent calls to <code>ListHostedZones</code>, <code>Marker</code> is the value that you specified for the <code>marker</code> parameter in the request that produced the current response.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>A flag indicating whether there are more hosted zones to be listed. If the response was truncated, you can get more hosted zones by submitting another <code>ListHostedZones</code> request and specifying the value of <code>NextMarker</code> in the <code>marker</code> parameter.</p>
    pub is_truncated: bool,
    /// <p>If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextMarker</code> identifies the first hosted zone in the next group of hosted zones. Submit another <code>ListHostedZones</code> request, and specify the value of <code>NextMarker</code> from the response in the <code>marker</code> parameter.</p>
    /// <p>This element is present only if <code>IsTruncated</code> is <code>true</code>.</p>
    pub next_marker: std::option::Option<std::string::String>,
    /// <p>The value that you specified for the <code>maxitems</code> parameter in the call to <code>ListHostedZones</code> that produced the current response.</p>
    pub max_items: std::option::Option<i32>,
}
impl ListHostedZonesOutput {
    /// <p>A complex type that contains general information about the hosted zone.</p>
    pub fn hosted_zones(&self) -> std::option::Option<&[crate::model::HostedZone]> {
        self.hosted_zones.as_deref()
    }
    /// <p>For the second and subsequent calls to <code>ListHostedZones</code>, <code>Marker</code> is the value that you specified for the <code>marker</code> parameter in the request that produced the current response.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>A flag indicating whether there are more hosted zones to be listed. If the response was truncated, you can get more hosted zones by submitting another <code>ListHostedZones</code> request and specifying the value of <code>NextMarker</code> in the <code>marker</code> parameter.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextMarker</code> identifies the first hosted zone in the next group of hosted zones. Submit another <code>ListHostedZones</code> request, and specify the value of <code>NextMarker</code> from the response in the <code>marker</code> parameter.</p>
    /// <p>This element is present only if <code>IsTruncated</code> is <code>true</code>.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
    /// <p>The value that you specified for the <code>maxitems</code> parameter in the call to <code>ListHostedZones</code> that produced the current response.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListHostedZonesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListHostedZonesOutput");
        formatter.field("hosted_zones", &self.hosted_zones);
        formatter.field("marker", &self.marker);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("next_marker", &self.next_marker);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}
/// See [`ListHostedZonesOutput`](crate::output::ListHostedZonesOutput)
pub mod list_hosted_zones_output {
    /// A builder for [`ListHostedZonesOutput`](crate::output::ListHostedZonesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hosted_zones: std::option::Option<std::vec::Vec<crate::model::HostedZone>>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) next_marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `hosted_zones`.
        ///
        /// To override the contents of this collection use [`set_hosted_zones`](Self::set_hosted_zones).
        ///
        /// <p>A complex type that contains general information about the hosted zone.</p>
        pub fn hosted_zones(mut self, input: crate::model::HostedZone) -> Self {
            let mut v = self.hosted_zones.unwrap_or_default();
            v.push(input);
            self.hosted_zones = Some(v);
            self
        }
        /// <p>A complex type that contains general information about the hosted zone.</p>
        pub fn set_hosted_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HostedZone>>,
        ) -> Self {
            self.hosted_zones = input;
            self
        }
        /// <p>For the second and subsequent calls to <code>ListHostedZones</code>, <code>Marker</code> is the value that you specified for the <code>marker</code> parameter in the request that produced the current response.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>For the second and subsequent calls to <code>ListHostedZones</code>, <code>Marker</code> is the value that you specified for the <code>marker</code> parameter in the request that produced the current response.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>A flag indicating whether there are more hosted zones to be listed. If the response was truncated, you can get more hosted zones by submitting another <code>ListHostedZones</code> request and specifying the value of <code>NextMarker</code> in the <code>marker</code> parameter.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag indicating whether there are more hosted zones to be listed. If the response was truncated, you can get more hosted zones by submitting another <code>ListHostedZones</code> request and specifying the value of <code>NextMarker</code> in the <code>marker</code> parameter.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextMarker</code> identifies the first hosted zone in the next group of hosted zones. Submit another <code>ListHostedZones</code> request, and specify the value of <code>NextMarker</code> from the response in the <code>marker</code> parameter.</p>
        /// <p>This element is present only if <code>IsTruncated</code> is <code>true</code>.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextMarker</code> identifies the first hosted zone in the next group of hosted zones. Submit another <code>ListHostedZones</code> request, and specify the value of <code>NextMarker</code> from the response in the <code>marker</code> parameter.</p>
        /// <p>This element is present only if <code>IsTruncated</code> is <code>true</code>.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// <p>The value that you specified for the <code>maxitems</code> parameter in the call to <code>ListHostedZones</code> that produced the current response.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The value that you specified for the <code>maxitems</code> parameter in the call to <code>ListHostedZones</code> that produced the current response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListHostedZonesOutput`](crate::output::ListHostedZonesOutput)
        pub fn build(self) -> crate::output::ListHostedZonesOutput {
            crate::output::ListHostedZonesOutput {
                hosted_zones: self.hosted_zones,
                marker: self.marker,
                is_truncated: self.is_truncated.unwrap_or_default(),
                next_marker: self.next_marker,
                max_items: self.max_items,
            }
        }
    }
}
impl ListHostedZonesOutput {
    /// Creates a new builder-style object to manufacture [`ListHostedZonesOutput`](crate::output::ListHostedZonesOutput)
    pub fn builder() -> crate::output::list_hosted_zones_output::Builder {
        crate::output::list_hosted_zones_output::Builder::default()
    }
}

/// <p>A complex type that contains the response to a <code>ListHealthChecks</code> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListHealthChecksOutput {
    /// <p>A complex type that contains one <code>HealthCheck</code> element for each health check that is associated with the current Amazon Web Services account.</p>
    pub health_checks: std::option::Option<std::vec::Vec<crate::model::HealthCheck>>,
    /// <p>For the second and subsequent calls to <code>ListHealthChecks</code>, <code>Marker</code> is the value that you specified for the <code>marker</code> parameter in the previous request.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>A flag that indicates whether there are more health checks to be listed. If the response was truncated, you can get the next group of health checks by submitting another <code>ListHealthChecks</code> request and specifying the value of <code>NextMarker</code> in the <code>marker</code> parameter.</p>
    pub is_truncated: bool,
    /// <p>If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextMarker</code> identifies the first health check that Amazon Route 53 returns if you submit another <code>ListHealthChecks</code> request and specify the value of <code>NextMarker</code> in the <code>marker</code> parameter.</p>
    pub next_marker: std::option::Option<std::string::String>,
    /// <p>The value that you specified for the <code>maxitems</code> parameter in the call to <code>ListHealthChecks</code> that produced the current response.</p>
    pub max_items: std::option::Option<i32>,
}
impl ListHealthChecksOutput {
    /// <p>A complex type that contains one <code>HealthCheck</code> element for each health check that is associated with the current Amazon Web Services account.</p>
    pub fn health_checks(&self) -> std::option::Option<&[crate::model::HealthCheck]> {
        self.health_checks.as_deref()
    }
    /// <p>For the second and subsequent calls to <code>ListHealthChecks</code>, <code>Marker</code> is the value that you specified for the <code>marker</code> parameter in the previous request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>A flag that indicates whether there are more health checks to be listed. If the response was truncated, you can get the next group of health checks by submitting another <code>ListHealthChecks</code> request and specifying the value of <code>NextMarker</code> in the <code>marker</code> parameter.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextMarker</code> identifies the first health check that Amazon Route 53 returns if you submit another <code>ListHealthChecks</code> request and specify the value of <code>NextMarker</code> in the <code>marker</code> parameter.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
    /// <p>The value that you specified for the <code>maxitems</code> parameter in the call to <code>ListHealthChecks</code> that produced the current response.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListHealthChecksOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListHealthChecksOutput");
        formatter.field("health_checks", &self.health_checks);
        formatter.field("marker", &self.marker);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("next_marker", &self.next_marker);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}
/// See [`ListHealthChecksOutput`](crate::output::ListHealthChecksOutput)
pub mod list_health_checks_output {
    /// A builder for [`ListHealthChecksOutput`](crate::output::ListHealthChecksOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) health_checks: std::option::Option<std::vec::Vec<crate::model::HealthCheck>>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) next_marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `health_checks`.
        ///
        /// To override the contents of this collection use [`set_health_checks`](Self::set_health_checks).
        ///
        /// <p>A complex type that contains one <code>HealthCheck</code> element for each health check that is associated with the current Amazon Web Services account.</p>
        pub fn health_checks(mut self, input: crate::model::HealthCheck) -> Self {
            let mut v = self.health_checks.unwrap_or_default();
            v.push(input);
            self.health_checks = Some(v);
            self
        }
        /// <p>A complex type that contains one <code>HealthCheck</code> element for each health check that is associated with the current Amazon Web Services account.</p>
        pub fn set_health_checks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HealthCheck>>,
        ) -> Self {
            self.health_checks = input;
            self
        }
        /// <p>For the second and subsequent calls to <code>ListHealthChecks</code>, <code>Marker</code> is the value that you specified for the <code>marker</code> parameter in the previous request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>For the second and subsequent calls to <code>ListHealthChecks</code>, <code>Marker</code> is the value that you specified for the <code>marker</code> parameter in the previous request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>A flag that indicates whether there are more health checks to be listed. If the response was truncated, you can get the next group of health checks by submitting another <code>ListHealthChecks</code> request and specifying the value of <code>NextMarker</code> in the <code>marker</code> parameter.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more health checks to be listed. If the response was truncated, you can get the next group of health checks by submitting another <code>ListHealthChecks</code> request and specifying the value of <code>NextMarker</code> in the <code>marker</code> parameter.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextMarker</code> identifies the first health check that Amazon Route 53 returns if you submit another <code>ListHealthChecks</code> request and specify the value of <code>NextMarker</code> in the <code>marker</code> parameter.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextMarker</code> identifies the first health check that Amazon Route 53 returns if you submit another <code>ListHealthChecks</code> request and specify the value of <code>NextMarker</code> in the <code>marker</code> parameter.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// <p>The value that you specified for the <code>maxitems</code> parameter in the call to <code>ListHealthChecks</code> that produced the current response.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The value that you specified for the <code>maxitems</code> parameter in the call to <code>ListHealthChecks</code> that produced the current response.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListHealthChecksOutput`](crate::output::ListHealthChecksOutput)
        pub fn build(self) -> crate::output::ListHealthChecksOutput {
            crate::output::ListHealthChecksOutput {
                health_checks: self.health_checks,
                marker: self.marker,
                is_truncated: self.is_truncated.unwrap_or_default(),
                next_marker: self.next_marker,
                max_items: self.max_items,
            }
        }
    }
}
impl ListHealthChecksOutput {
    /// Creates a new builder-style object to manufacture [`ListHealthChecksOutput`](crate::output::ListHealthChecksOutput)
    pub fn builder() -> crate::output::list_health_checks_output::Builder {
        crate::output::list_health_checks_output::Builder::default()
    }
}

/// <p>A complex type containing the response information for the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGeoLocationsOutput {
    /// <p>A complex type that contains one <code>GeoLocationDetails</code> element for each location that Amazon Route 53 supports for geolocation.</p>
    pub geo_location_details_list:
        std::option::Option<std::vec::Vec<crate::model::GeoLocationDetails>>,
    /// <p>A value that indicates whether more locations remain to be listed after the last location in this response. If so, the value of <code>IsTruncated</code> is <code>true</code>. To get more values, submit another request and include the values of <code>NextContinentCode</code>, <code>NextCountryCode</code>, and <code>NextSubdivisionCode</code> in the <code>startcontinentcode</code>, <code>startcountrycode</code>, and <code>startsubdivisioncode</code>, as applicable.</p>
    pub is_truncated: bool,
    /// <p>If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more locations. Enter the value of <code>NextContinentCode</code> in the <code>startcontinentcode</code> parameter in another <code>ListGeoLocations</code> request.</p>
    pub next_continent_code: std::option::Option<std::string::String>,
    /// <p>If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more locations. Enter the value of <code>NextCountryCode</code> in the <code>startcountrycode</code> parameter in another <code>ListGeoLocations</code> request.</p>
    pub next_country_code: std::option::Option<std::string::String>,
    /// <p>If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more locations. Enter the value of <code>NextSubdivisionCode</code> in the <code>startsubdivisioncode</code> parameter in another <code>ListGeoLocations</code> request.</p>
    pub next_subdivision_code: std::option::Option<std::string::String>,
    /// <p>The value that you specified for <code>MaxItems</code> in the request.</p>
    pub max_items: std::option::Option<i32>,
}
impl ListGeoLocationsOutput {
    /// <p>A complex type that contains one <code>GeoLocationDetails</code> element for each location that Amazon Route 53 supports for geolocation.</p>
    pub fn geo_location_details_list(
        &self,
    ) -> std::option::Option<&[crate::model::GeoLocationDetails]> {
        self.geo_location_details_list.as_deref()
    }
    /// <p>A value that indicates whether more locations remain to be listed after the last location in this response. If so, the value of <code>IsTruncated</code> is <code>true</code>. To get more values, submit another request and include the values of <code>NextContinentCode</code>, <code>NextCountryCode</code>, and <code>NextSubdivisionCode</code> in the <code>startcontinentcode</code>, <code>startcountrycode</code>, and <code>startsubdivisioncode</code>, as applicable.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more locations. Enter the value of <code>NextContinentCode</code> in the <code>startcontinentcode</code> parameter in another <code>ListGeoLocations</code> request.</p>
    pub fn next_continent_code(&self) -> std::option::Option<&str> {
        self.next_continent_code.as_deref()
    }
    /// <p>If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more locations. Enter the value of <code>NextCountryCode</code> in the <code>startcountrycode</code> parameter in another <code>ListGeoLocations</code> request.</p>
    pub fn next_country_code(&self) -> std::option::Option<&str> {
        self.next_country_code.as_deref()
    }
    /// <p>If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more locations. Enter the value of <code>NextSubdivisionCode</code> in the <code>startsubdivisioncode</code> parameter in another <code>ListGeoLocations</code> request.</p>
    pub fn next_subdivision_code(&self) -> std::option::Option<&str> {
        self.next_subdivision_code.as_deref()
    }
    /// <p>The value that you specified for <code>MaxItems</code> in the request.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListGeoLocationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGeoLocationsOutput");
        formatter.field("geo_location_details_list", &self.geo_location_details_list);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("next_continent_code", &self.next_continent_code);
        formatter.field("next_country_code", &self.next_country_code);
        formatter.field("next_subdivision_code", &self.next_subdivision_code);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}
/// See [`ListGeoLocationsOutput`](crate::output::ListGeoLocationsOutput)
pub mod list_geo_locations_output {
    /// A builder for [`ListGeoLocationsOutput`](crate::output::ListGeoLocationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) geo_location_details_list:
            std::option::Option<std::vec::Vec<crate::model::GeoLocationDetails>>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) next_continent_code: std::option::Option<std::string::String>,
        pub(crate) next_country_code: std::option::Option<std::string::String>,
        pub(crate) next_subdivision_code: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `geo_location_details_list`.
        ///
        /// To override the contents of this collection use [`set_geo_location_details_list`](Self::set_geo_location_details_list).
        ///
        /// <p>A complex type that contains one <code>GeoLocationDetails</code> element for each location that Amazon Route 53 supports for geolocation.</p>
        pub fn geo_location_details_list(
            mut self,
            input: crate::model::GeoLocationDetails,
        ) -> Self {
            let mut v = self.geo_location_details_list.unwrap_or_default();
            v.push(input);
            self.geo_location_details_list = Some(v);
            self
        }
        /// <p>A complex type that contains one <code>GeoLocationDetails</code> element for each location that Amazon Route 53 supports for geolocation.</p>
        pub fn set_geo_location_details_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GeoLocationDetails>>,
        ) -> Self {
            self.geo_location_details_list = input;
            self
        }
        /// <p>A value that indicates whether more locations remain to be listed after the last location in this response. If so, the value of <code>IsTruncated</code> is <code>true</code>. To get more values, submit another request and include the values of <code>NextContinentCode</code>, <code>NextCountryCode</code>, and <code>NextSubdivisionCode</code> in the <code>startcontinentcode</code>, <code>startcountrycode</code>, and <code>startsubdivisioncode</code>, as applicable.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A value that indicates whether more locations remain to be listed after the last location in this response. If so, the value of <code>IsTruncated</code> is <code>true</code>. To get more values, submit another request and include the values of <code>NextContinentCode</code>, <code>NextCountryCode</code>, and <code>NextSubdivisionCode</code> in the <code>startcontinentcode</code>, <code>startcountrycode</code>, and <code>startsubdivisioncode</code>, as applicable.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more locations. Enter the value of <code>NextContinentCode</code> in the <code>startcontinentcode</code> parameter in another <code>ListGeoLocations</code> request.</p>
        pub fn next_continent_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_continent_code = Some(input.into());
            self
        }
        /// <p>If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more locations. Enter the value of <code>NextContinentCode</code> in the <code>startcontinentcode</code> parameter in another <code>ListGeoLocations</code> request.</p>
        pub fn set_next_continent_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_continent_code = input;
            self
        }
        /// <p>If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more locations. Enter the value of <code>NextCountryCode</code> in the <code>startcountrycode</code> parameter in another <code>ListGeoLocations</code> request.</p>
        pub fn next_country_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_country_code = Some(input.into());
            self
        }
        /// <p>If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more locations. Enter the value of <code>NextCountryCode</code> in the <code>startcountrycode</code> parameter in another <code>ListGeoLocations</code> request.</p>
        pub fn set_next_country_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_country_code = input;
            self
        }
        /// <p>If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more locations. Enter the value of <code>NextSubdivisionCode</code> in the <code>startsubdivisioncode</code> parameter in another <code>ListGeoLocations</code> request.</p>
        pub fn next_subdivision_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_subdivision_code = Some(input.into());
            self
        }
        /// <p>If <code>IsTruncated</code> is <code>true</code>, you can make a follow-up request to display more locations. Enter the value of <code>NextSubdivisionCode</code> in the <code>startsubdivisioncode</code> parameter in another <code>ListGeoLocations</code> request.</p>
        pub fn set_next_subdivision_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_subdivision_code = input;
            self
        }
        /// <p>The value that you specified for <code>MaxItems</code> in the request.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The value that you specified for <code>MaxItems</code> in the request.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGeoLocationsOutput`](crate::output::ListGeoLocationsOutput)
        pub fn build(self) -> crate::output::ListGeoLocationsOutput {
            crate::output::ListGeoLocationsOutput {
                geo_location_details_list: self.geo_location_details_list,
                is_truncated: self.is_truncated.unwrap_or_default(),
                next_continent_code: self.next_continent_code,
                next_country_code: self.next_country_code,
                next_subdivision_code: self.next_subdivision_code,
                max_items: self.max_items,
            }
        }
    }
}
impl ListGeoLocationsOutput {
    /// Creates a new builder-style object to manufacture [`ListGeoLocationsOutput`](crate::output::ListGeoLocationsOutput)
    pub fn builder() -> crate::output::list_geo_locations_output::Builder {
        crate::output::list_geo_locations_output::Builder::default()
    }
}

/// <p>A complex type that contains information about the resource record sets that Amazon Route 53 created based on a specified traffic policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTrafficPolicyInstanceCountOutput {
    /// <p>The number of traffic policy instances that are associated with the current Amazon Web Services account.</p>
    pub traffic_policy_instance_count: std::option::Option<i32>,
}
impl GetTrafficPolicyInstanceCountOutput {
    /// <p>The number of traffic policy instances that are associated with the current Amazon Web Services account.</p>
    pub fn traffic_policy_instance_count(&self) -> std::option::Option<i32> {
        self.traffic_policy_instance_count
    }
}
impl std::fmt::Debug for GetTrafficPolicyInstanceCountOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTrafficPolicyInstanceCountOutput");
        formatter.field(
            "traffic_policy_instance_count",
            &self.traffic_policy_instance_count,
        );
        formatter.finish()
    }
}
/// See [`GetTrafficPolicyInstanceCountOutput`](crate::output::GetTrafficPolicyInstanceCountOutput)
pub mod get_traffic_policy_instance_count_output {
    /// A builder for [`GetTrafficPolicyInstanceCountOutput`](crate::output::GetTrafficPolicyInstanceCountOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) traffic_policy_instance_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The number of traffic policy instances that are associated with the current Amazon Web Services account.</p>
        pub fn traffic_policy_instance_count(mut self, input: i32) -> Self {
            self.traffic_policy_instance_count = Some(input);
            self
        }
        /// <p>The number of traffic policy instances that are associated with the current Amazon Web Services account.</p>
        pub fn set_traffic_policy_instance_count(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.traffic_policy_instance_count = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTrafficPolicyInstanceCountOutput`](crate::output::GetTrafficPolicyInstanceCountOutput)
        pub fn build(self) -> crate::output::GetTrafficPolicyInstanceCountOutput {
            crate::output::GetTrafficPolicyInstanceCountOutput {
                traffic_policy_instance_count: self.traffic_policy_instance_count,
            }
        }
    }
}
impl GetTrafficPolicyInstanceCountOutput {
    /// Creates a new builder-style object to manufacture [`GetTrafficPolicyInstanceCountOutput`](crate::output::GetTrafficPolicyInstanceCountOutput)
    pub fn builder() -> crate::output::get_traffic_policy_instance_count_output::Builder {
        crate::output::get_traffic_policy_instance_count_output::Builder::default()
    }
}

/// <p>A complex type that contains information about the resource record sets that Amazon Route 53 created based on a specified traffic policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTrafficPolicyInstanceOutput {
    /// <p>A complex type that contains settings for the traffic policy instance.</p>
    pub traffic_policy_instance: std::option::Option<crate::model::TrafficPolicyInstance>,
}
impl GetTrafficPolicyInstanceOutput {
    /// <p>A complex type that contains settings for the traffic policy instance.</p>
    pub fn traffic_policy_instance(
        &self,
    ) -> std::option::Option<&crate::model::TrafficPolicyInstance> {
        self.traffic_policy_instance.as_ref()
    }
}
impl std::fmt::Debug for GetTrafficPolicyInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTrafficPolicyInstanceOutput");
        formatter.field("traffic_policy_instance", &self.traffic_policy_instance);
        formatter.finish()
    }
}
/// See [`GetTrafficPolicyInstanceOutput`](crate::output::GetTrafficPolicyInstanceOutput)
pub mod get_traffic_policy_instance_output {
    /// A builder for [`GetTrafficPolicyInstanceOutput`](crate::output::GetTrafficPolicyInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) traffic_policy_instance:
            std::option::Option<crate::model::TrafficPolicyInstance>,
    }
    impl Builder {
        /// <p>A complex type that contains settings for the traffic policy instance.</p>
        pub fn traffic_policy_instance(
            mut self,
            input: crate::model::TrafficPolicyInstance,
        ) -> Self {
            self.traffic_policy_instance = Some(input);
            self
        }
        /// <p>A complex type that contains settings for the traffic policy instance.</p>
        pub fn set_traffic_policy_instance(
            mut self,
            input: std::option::Option<crate::model::TrafficPolicyInstance>,
        ) -> Self {
            self.traffic_policy_instance = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTrafficPolicyInstanceOutput`](crate::output::GetTrafficPolicyInstanceOutput)
        pub fn build(self) -> crate::output::GetTrafficPolicyInstanceOutput {
            crate::output::GetTrafficPolicyInstanceOutput {
                traffic_policy_instance: self.traffic_policy_instance,
            }
        }
    }
}
impl GetTrafficPolicyInstanceOutput {
    /// Creates a new builder-style object to manufacture [`GetTrafficPolicyInstanceOutput`](crate::output::GetTrafficPolicyInstanceOutput)
    pub fn builder() -> crate::output::get_traffic_policy_instance_output::Builder {
        crate::output::get_traffic_policy_instance_output::Builder::default()
    }
}

/// <p>A complex type that contains the response information for the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTrafficPolicyOutput {
    /// <p>A complex type that contains settings for the specified traffic policy.</p>
    pub traffic_policy: std::option::Option<crate::model::TrafficPolicy>,
}
impl GetTrafficPolicyOutput {
    /// <p>A complex type that contains settings for the specified traffic policy.</p>
    pub fn traffic_policy(&self) -> std::option::Option<&crate::model::TrafficPolicy> {
        self.traffic_policy.as_ref()
    }
}
impl std::fmt::Debug for GetTrafficPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTrafficPolicyOutput");
        formatter.field("traffic_policy", &self.traffic_policy);
        formatter.finish()
    }
}
/// See [`GetTrafficPolicyOutput`](crate::output::GetTrafficPolicyOutput)
pub mod get_traffic_policy_output {
    /// A builder for [`GetTrafficPolicyOutput`](crate::output::GetTrafficPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) traffic_policy: std::option::Option<crate::model::TrafficPolicy>,
    }
    impl Builder {
        /// <p>A complex type that contains settings for the specified traffic policy.</p>
        pub fn traffic_policy(mut self, input: crate::model::TrafficPolicy) -> Self {
            self.traffic_policy = Some(input);
            self
        }
        /// <p>A complex type that contains settings for the specified traffic policy.</p>
        pub fn set_traffic_policy(
            mut self,
            input: std::option::Option<crate::model::TrafficPolicy>,
        ) -> Self {
            self.traffic_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTrafficPolicyOutput`](crate::output::GetTrafficPolicyOutput)
        pub fn build(self) -> crate::output::GetTrafficPolicyOutput {
            crate::output::GetTrafficPolicyOutput {
                traffic_policy: self.traffic_policy,
            }
        }
    }
}
impl GetTrafficPolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetTrafficPolicyOutput`](crate::output::GetTrafficPolicyOutput)
    pub fn builder() -> crate::output::get_traffic_policy_output::Builder {
        crate::output::get_traffic_policy_output::Builder::default()
    }
}

/// <p>A complex type that contains the requested limit. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetReusableDelegationSetLimitOutput {
    /// <p>The current setting for the limit on hosted zones that you can associate with the specified reusable delegation set.</p>
    pub limit: std::option::Option<crate::model::ReusableDelegationSetLimit>,
    /// <p>The current number of hosted zones that you can associate with the specified reusable delegation set.</p>
    pub count: i64,
}
impl GetReusableDelegationSetLimitOutput {
    /// <p>The current setting for the limit on hosted zones that you can associate with the specified reusable delegation set.</p>
    pub fn limit(&self) -> std::option::Option<&crate::model::ReusableDelegationSetLimit> {
        self.limit.as_ref()
    }
    /// <p>The current number of hosted zones that you can associate with the specified reusable delegation set.</p>
    pub fn count(&self) -> i64 {
        self.count
    }
}
impl std::fmt::Debug for GetReusableDelegationSetLimitOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetReusableDelegationSetLimitOutput");
        formatter.field("limit", &self.limit);
        formatter.field("count", &self.count);
        formatter.finish()
    }
}
/// See [`GetReusableDelegationSetLimitOutput`](crate::output::GetReusableDelegationSetLimitOutput)
pub mod get_reusable_delegation_set_limit_output {
    /// A builder for [`GetReusableDelegationSetLimitOutput`](crate::output::GetReusableDelegationSetLimitOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) limit: std::option::Option<crate::model::ReusableDelegationSetLimit>,
        pub(crate) count: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The current setting for the limit on hosted zones that you can associate with the specified reusable delegation set.</p>
        pub fn limit(mut self, input: crate::model::ReusableDelegationSetLimit) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The current setting for the limit on hosted zones that you can associate with the specified reusable delegation set.</p>
        pub fn set_limit(
            mut self,
            input: std::option::Option<crate::model::ReusableDelegationSetLimit>,
        ) -> Self {
            self.limit = input;
            self
        }
        /// <p>The current number of hosted zones that you can associate with the specified reusable delegation set.</p>
        pub fn count(mut self, input: i64) -> Self {
            self.count = Some(input);
            self
        }
        /// <p>The current number of hosted zones that you can associate with the specified reusable delegation set.</p>
        pub fn set_count(mut self, input: std::option::Option<i64>) -> Self {
            self.count = input;
            self
        }
        /// Consumes the builder and constructs a [`GetReusableDelegationSetLimitOutput`](crate::output::GetReusableDelegationSetLimitOutput)
        pub fn build(self) -> crate::output::GetReusableDelegationSetLimitOutput {
            crate::output::GetReusableDelegationSetLimitOutput {
                limit: self.limit,
                count: self.count.unwrap_or_default(),
            }
        }
    }
}
impl GetReusableDelegationSetLimitOutput {
    /// Creates a new builder-style object to manufacture [`GetReusableDelegationSetLimitOutput`](crate::output::GetReusableDelegationSetLimitOutput)
    pub fn builder() -> crate::output::get_reusable_delegation_set_limit_output::Builder {
        crate::output::get_reusable_delegation_set_limit_output::Builder::default()
    }
}

/// <p>A complex type that contains the response to the <code>GetReusableDelegationSet</code> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetReusableDelegationSetOutput {
    /// <p>A complex type that contains information about the reusable delegation set.</p>
    pub delegation_set: std::option::Option<crate::model::DelegationSet>,
}
impl GetReusableDelegationSetOutput {
    /// <p>A complex type that contains information about the reusable delegation set.</p>
    pub fn delegation_set(&self) -> std::option::Option<&crate::model::DelegationSet> {
        self.delegation_set.as_ref()
    }
}
impl std::fmt::Debug for GetReusableDelegationSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetReusableDelegationSetOutput");
        formatter.field("delegation_set", &self.delegation_set);
        formatter.finish()
    }
}
/// See [`GetReusableDelegationSetOutput`](crate::output::GetReusableDelegationSetOutput)
pub mod get_reusable_delegation_set_output {
    /// A builder for [`GetReusableDelegationSetOutput`](crate::output::GetReusableDelegationSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delegation_set: std::option::Option<crate::model::DelegationSet>,
    }
    impl Builder {
        /// <p>A complex type that contains information about the reusable delegation set.</p>
        pub fn delegation_set(mut self, input: crate::model::DelegationSet) -> Self {
            self.delegation_set = Some(input);
            self
        }
        /// <p>A complex type that contains information about the reusable delegation set.</p>
        pub fn set_delegation_set(
            mut self,
            input: std::option::Option<crate::model::DelegationSet>,
        ) -> Self {
            self.delegation_set = input;
            self
        }
        /// Consumes the builder and constructs a [`GetReusableDelegationSetOutput`](crate::output::GetReusableDelegationSetOutput)
        pub fn build(self) -> crate::output::GetReusableDelegationSetOutput {
            crate::output::GetReusableDelegationSetOutput {
                delegation_set: self.delegation_set,
            }
        }
    }
}
impl GetReusableDelegationSetOutput {
    /// Creates a new builder-style object to manufacture [`GetReusableDelegationSetOutput`](crate::output::GetReusableDelegationSetOutput)
    pub fn builder() -> crate::output::get_reusable_delegation_set_output::Builder {
        crate::output::get_reusable_delegation_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetQueryLoggingConfigOutput {
    /// <p>A complex type that contains information about the query logging configuration that you specified in a <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetQueryLoggingConfig.html">GetQueryLoggingConfig</a> request.</p>
    pub query_logging_config: std::option::Option<crate::model::QueryLoggingConfig>,
}
impl GetQueryLoggingConfigOutput {
    /// <p>A complex type that contains information about the query logging configuration that you specified in a <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetQueryLoggingConfig.html">GetQueryLoggingConfig</a> request.</p>
    pub fn query_logging_config(&self) -> std::option::Option<&crate::model::QueryLoggingConfig> {
        self.query_logging_config.as_ref()
    }
}
impl std::fmt::Debug for GetQueryLoggingConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetQueryLoggingConfigOutput");
        formatter.field("query_logging_config", &self.query_logging_config);
        formatter.finish()
    }
}
/// See [`GetQueryLoggingConfigOutput`](crate::output::GetQueryLoggingConfigOutput)
pub mod get_query_logging_config_output {
    /// A builder for [`GetQueryLoggingConfigOutput`](crate::output::GetQueryLoggingConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) query_logging_config: std::option::Option<crate::model::QueryLoggingConfig>,
    }
    impl Builder {
        /// <p>A complex type that contains information about the query logging configuration that you specified in a <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetQueryLoggingConfig.html">GetQueryLoggingConfig</a> request.</p>
        pub fn query_logging_config(mut self, input: crate::model::QueryLoggingConfig) -> Self {
            self.query_logging_config = Some(input);
            self
        }
        /// <p>A complex type that contains information about the query logging configuration that you specified in a <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetQueryLoggingConfig.html">GetQueryLoggingConfig</a> request.</p>
        pub fn set_query_logging_config(
            mut self,
            input: std::option::Option<crate::model::QueryLoggingConfig>,
        ) -> Self {
            self.query_logging_config = input;
            self
        }
        /// Consumes the builder and constructs a [`GetQueryLoggingConfigOutput`](crate::output::GetQueryLoggingConfigOutput)
        pub fn build(self) -> crate::output::GetQueryLoggingConfigOutput {
            crate::output::GetQueryLoggingConfigOutput {
                query_logging_config: self.query_logging_config,
            }
        }
    }
}
impl GetQueryLoggingConfigOutput {
    /// Creates a new builder-style object to manufacture [`GetQueryLoggingConfigOutput`](crate::output::GetQueryLoggingConfigOutput)
    pub fn builder() -> crate::output::get_query_logging_config_output::Builder {
        crate::output::get_query_logging_config_output::Builder::default()
    }
}

/// <p>A complex type that contains the requested limit. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetHostedZoneLimitOutput {
    /// <p>The current setting for the specified limit. For example, if you specified <code>MAX_RRSETS_BY_ZONE</code> for the value of <code>Type</code> in the request, the value of <code>Limit</code> is the maximum number of records that you can create in the specified hosted zone.</p>
    pub limit: std::option::Option<crate::model::HostedZoneLimit>,
    /// <p>The current number of entities that you have created of the specified type. For example, if you specified <code>MAX_RRSETS_BY_ZONE</code> for the value of <code>Type</code> in the request, the value of <code>Count</code> is the current number of records that you have created in the specified hosted zone.</p>
    pub count: i64,
}
impl GetHostedZoneLimitOutput {
    /// <p>The current setting for the specified limit. For example, if you specified <code>MAX_RRSETS_BY_ZONE</code> for the value of <code>Type</code> in the request, the value of <code>Limit</code> is the maximum number of records that you can create in the specified hosted zone.</p>
    pub fn limit(&self) -> std::option::Option<&crate::model::HostedZoneLimit> {
        self.limit.as_ref()
    }
    /// <p>The current number of entities that you have created of the specified type. For example, if you specified <code>MAX_RRSETS_BY_ZONE</code> for the value of <code>Type</code> in the request, the value of <code>Count</code> is the current number of records that you have created in the specified hosted zone.</p>
    pub fn count(&self) -> i64 {
        self.count
    }
}
impl std::fmt::Debug for GetHostedZoneLimitOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetHostedZoneLimitOutput");
        formatter.field("limit", &self.limit);
        formatter.field("count", &self.count);
        formatter.finish()
    }
}
/// See [`GetHostedZoneLimitOutput`](crate::output::GetHostedZoneLimitOutput)
pub mod get_hosted_zone_limit_output {
    /// A builder for [`GetHostedZoneLimitOutput`](crate::output::GetHostedZoneLimitOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) limit: std::option::Option<crate::model::HostedZoneLimit>,
        pub(crate) count: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The current setting for the specified limit. For example, if you specified <code>MAX_RRSETS_BY_ZONE</code> for the value of <code>Type</code> in the request, the value of <code>Limit</code> is the maximum number of records that you can create in the specified hosted zone.</p>
        pub fn limit(mut self, input: crate::model::HostedZoneLimit) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The current setting for the specified limit. For example, if you specified <code>MAX_RRSETS_BY_ZONE</code> for the value of <code>Type</code> in the request, the value of <code>Limit</code> is the maximum number of records that you can create in the specified hosted zone.</p>
        pub fn set_limit(
            mut self,
            input: std::option::Option<crate::model::HostedZoneLimit>,
        ) -> Self {
            self.limit = input;
            self
        }
        /// <p>The current number of entities that you have created of the specified type. For example, if you specified <code>MAX_RRSETS_BY_ZONE</code> for the value of <code>Type</code> in the request, the value of <code>Count</code> is the current number of records that you have created in the specified hosted zone.</p>
        pub fn count(mut self, input: i64) -> Self {
            self.count = Some(input);
            self
        }
        /// <p>The current number of entities that you have created of the specified type. For example, if you specified <code>MAX_RRSETS_BY_ZONE</code> for the value of <code>Type</code> in the request, the value of <code>Count</code> is the current number of records that you have created in the specified hosted zone.</p>
        pub fn set_count(mut self, input: std::option::Option<i64>) -> Self {
            self.count = input;
            self
        }
        /// Consumes the builder and constructs a [`GetHostedZoneLimitOutput`](crate::output::GetHostedZoneLimitOutput)
        pub fn build(self) -> crate::output::GetHostedZoneLimitOutput {
            crate::output::GetHostedZoneLimitOutput {
                limit: self.limit,
                count: self.count.unwrap_or_default(),
            }
        }
    }
}
impl GetHostedZoneLimitOutput {
    /// Creates a new builder-style object to manufacture [`GetHostedZoneLimitOutput`](crate::output::GetHostedZoneLimitOutput)
    pub fn builder() -> crate::output::get_hosted_zone_limit_output::Builder {
        crate::output::get_hosted_zone_limit_output::Builder::default()
    }
}

/// <p>A complex type that contains the response to a <code>GetHostedZoneCount</code> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetHostedZoneCountOutput {
    /// <p>The total number of public and private hosted zones that are associated with the current Amazon Web Services account.</p>
    pub hosted_zone_count: std::option::Option<i64>,
}
impl GetHostedZoneCountOutput {
    /// <p>The total number of public and private hosted zones that are associated with the current Amazon Web Services account.</p>
    pub fn hosted_zone_count(&self) -> std::option::Option<i64> {
        self.hosted_zone_count
    }
}
impl std::fmt::Debug for GetHostedZoneCountOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetHostedZoneCountOutput");
        formatter.field("hosted_zone_count", &self.hosted_zone_count);
        formatter.finish()
    }
}
/// See [`GetHostedZoneCountOutput`](crate::output::GetHostedZoneCountOutput)
pub mod get_hosted_zone_count_output {
    /// A builder for [`GetHostedZoneCountOutput`](crate::output::GetHostedZoneCountOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hosted_zone_count: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The total number of public and private hosted zones that are associated with the current Amazon Web Services account.</p>
        pub fn hosted_zone_count(mut self, input: i64) -> Self {
            self.hosted_zone_count = Some(input);
            self
        }
        /// <p>The total number of public and private hosted zones that are associated with the current Amazon Web Services account.</p>
        pub fn set_hosted_zone_count(mut self, input: std::option::Option<i64>) -> Self {
            self.hosted_zone_count = input;
            self
        }
        /// Consumes the builder and constructs a [`GetHostedZoneCountOutput`](crate::output::GetHostedZoneCountOutput)
        pub fn build(self) -> crate::output::GetHostedZoneCountOutput {
            crate::output::GetHostedZoneCountOutput {
                hosted_zone_count: self.hosted_zone_count,
            }
        }
    }
}
impl GetHostedZoneCountOutput {
    /// Creates a new builder-style object to manufacture [`GetHostedZoneCountOutput`](crate::output::GetHostedZoneCountOutput)
    pub fn builder() -> crate::output::get_hosted_zone_count_output::Builder {
        crate::output::get_hosted_zone_count_output::Builder::default()
    }
}

/// <p>A complex type that contain the response to a <code>GetHostedZone</code> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetHostedZoneOutput {
    /// <p>A complex type that contains general information about the specified hosted zone.</p>
    pub hosted_zone: std::option::Option<crate::model::HostedZone>,
    /// <p>A complex type that lists the Amazon Route 53 name servers for the specified hosted zone.</p>
    pub delegation_set: std::option::Option<crate::model::DelegationSet>,
    /// <p>A complex type that contains information about the VPCs that are associated with the specified hosted zone.</p>
    pub vp_cs: std::option::Option<std::vec::Vec<crate::model::Vpc>>,
}
impl GetHostedZoneOutput {
    /// <p>A complex type that contains general information about the specified hosted zone.</p>
    pub fn hosted_zone(&self) -> std::option::Option<&crate::model::HostedZone> {
        self.hosted_zone.as_ref()
    }
    /// <p>A complex type that lists the Amazon Route 53 name servers for the specified hosted zone.</p>
    pub fn delegation_set(&self) -> std::option::Option<&crate::model::DelegationSet> {
        self.delegation_set.as_ref()
    }
    /// <p>A complex type that contains information about the VPCs that are associated with the specified hosted zone.</p>
    pub fn vp_cs(&self) -> std::option::Option<&[crate::model::Vpc]> {
        self.vp_cs.as_deref()
    }
}
impl std::fmt::Debug for GetHostedZoneOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetHostedZoneOutput");
        formatter.field("hosted_zone", &self.hosted_zone);
        formatter.field("delegation_set", &self.delegation_set);
        formatter.field("vp_cs", &self.vp_cs);
        formatter.finish()
    }
}
/// See [`GetHostedZoneOutput`](crate::output::GetHostedZoneOutput)
pub mod get_hosted_zone_output {
    /// A builder for [`GetHostedZoneOutput`](crate::output::GetHostedZoneOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hosted_zone: std::option::Option<crate::model::HostedZone>,
        pub(crate) delegation_set: std::option::Option<crate::model::DelegationSet>,
        pub(crate) vp_cs: std::option::Option<std::vec::Vec<crate::model::Vpc>>,
    }
    impl Builder {
        /// <p>A complex type that contains general information about the specified hosted zone.</p>
        pub fn hosted_zone(mut self, input: crate::model::HostedZone) -> Self {
            self.hosted_zone = Some(input);
            self
        }
        /// <p>A complex type that contains general information about the specified hosted zone.</p>
        pub fn set_hosted_zone(
            mut self,
            input: std::option::Option<crate::model::HostedZone>,
        ) -> Self {
            self.hosted_zone = input;
            self
        }
        /// <p>A complex type that lists the Amazon Route 53 name servers for the specified hosted zone.</p>
        pub fn delegation_set(mut self, input: crate::model::DelegationSet) -> Self {
            self.delegation_set = Some(input);
            self
        }
        /// <p>A complex type that lists the Amazon Route 53 name servers for the specified hosted zone.</p>
        pub fn set_delegation_set(
            mut self,
            input: std::option::Option<crate::model::DelegationSet>,
        ) -> Self {
            self.delegation_set = input;
            self
        }
        /// Appends an item to `vp_cs`.
        ///
        /// To override the contents of this collection use [`set_vp_cs`](Self::set_vp_cs).
        ///
        /// <p>A complex type that contains information about the VPCs that are associated with the specified hosted zone.</p>
        pub fn vp_cs(mut self, input: crate::model::Vpc) -> Self {
            let mut v = self.vp_cs.unwrap_or_default();
            v.push(input);
            self.vp_cs = Some(v);
            self
        }
        /// <p>A complex type that contains information about the VPCs that are associated with the specified hosted zone.</p>
        pub fn set_vp_cs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Vpc>>,
        ) -> Self {
            self.vp_cs = input;
            self
        }
        /// Consumes the builder and constructs a [`GetHostedZoneOutput`](crate::output::GetHostedZoneOutput)
        pub fn build(self) -> crate::output::GetHostedZoneOutput {
            crate::output::GetHostedZoneOutput {
                hosted_zone: self.hosted_zone,
                delegation_set: self.delegation_set,
                vp_cs: self.vp_cs,
            }
        }
    }
}
impl GetHostedZoneOutput {
    /// Creates a new builder-style object to manufacture [`GetHostedZoneOutput`](crate::output::GetHostedZoneOutput)
    pub fn builder() -> crate::output::get_hosted_zone_output::Builder {
        crate::output::get_hosted_zone_output::Builder::default()
    }
}

/// <p>A complex type that contains the response to a <code>GetHealthCheck</code> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetHealthCheckStatusOutput {
    /// <p>A list that contains one <code>HealthCheckObservation</code> element for each Amazon Route 53 health checker that is reporting a status about the health check endpoint.</p>
    pub health_check_observations:
        std::option::Option<std::vec::Vec<crate::model::HealthCheckObservation>>,
}
impl GetHealthCheckStatusOutput {
    /// <p>A list that contains one <code>HealthCheckObservation</code> element for each Amazon Route 53 health checker that is reporting a status about the health check endpoint.</p>
    pub fn health_check_observations(
        &self,
    ) -> std::option::Option<&[crate::model::HealthCheckObservation]> {
        self.health_check_observations.as_deref()
    }
}
impl std::fmt::Debug for GetHealthCheckStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetHealthCheckStatusOutput");
        formatter.field("health_check_observations", &self.health_check_observations);
        formatter.finish()
    }
}
/// See [`GetHealthCheckStatusOutput`](crate::output::GetHealthCheckStatusOutput)
pub mod get_health_check_status_output {
    /// A builder for [`GetHealthCheckStatusOutput`](crate::output::GetHealthCheckStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) health_check_observations:
            std::option::Option<std::vec::Vec<crate::model::HealthCheckObservation>>,
    }
    impl Builder {
        /// Appends an item to `health_check_observations`.
        ///
        /// To override the contents of this collection use [`set_health_check_observations`](Self::set_health_check_observations).
        ///
        /// <p>A list that contains one <code>HealthCheckObservation</code> element for each Amazon Route 53 health checker that is reporting a status about the health check endpoint.</p>
        pub fn health_check_observations(
            mut self,
            input: crate::model::HealthCheckObservation,
        ) -> Self {
            let mut v = self.health_check_observations.unwrap_or_default();
            v.push(input);
            self.health_check_observations = Some(v);
            self
        }
        /// <p>A list that contains one <code>HealthCheckObservation</code> element for each Amazon Route 53 health checker that is reporting a status about the health check endpoint.</p>
        pub fn set_health_check_observations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HealthCheckObservation>>,
        ) -> Self {
            self.health_check_observations = input;
            self
        }
        /// Consumes the builder and constructs a [`GetHealthCheckStatusOutput`](crate::output::GetHealthCheckStatusOutput)
        pub fn build(self) -> crate::output::GetHealthCheckStatusOutput {
            crate::output::GetHealthCheckStatusOutput {
                health_check_observations: self.health_check_observations,
            }
        }
    }
}
impl GetHealthCheckStatusOutput {
    /// Creates a new builder-style object to manufacture [`GetHealthCheckStatusOutput`](crate::output::GetHealthCheckStatusOutput)
    pub fn builder() -> crate::output::get_health_check_status_output::Builder {
        crate::output::get_health_check_status_output::Builder::default()
    }
}

/// <p>A complex type that contains the response to a <code>GetHealthCheckLastFailureReason</code> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetHealthCheckLastFailureReasonOutput {
    /// <p>A list that contains one <code>Observation</code> element for each Amazon Route 53 health checker that is reporting a last failure reason. </p>
    pub health_check_observations:
        std::option::Option<std::vec::Vec<crate::model::HealthCheckObservation>>,
}
impl GetHealthCheckLastFailureReasonOutput {
    /// <p>A list that contains one <code>Observation</code> element for each Amazon Route 53 health checker that is reporting a last failure reason. </p>
    pub fn health_check_observations(
        &self,
    ) -> std::option::Option<&[crate::model::HealthCheckObservation]> {
        self.health_check_observations.as_deref()
    }
}
impl std::fmt::Debug for GetHealthCheckLastFailureReasonOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetHealthCheckLastFailureReasonOutput");
        formatter.field("health_check_observations", &self.health_check_observations);
        formatter.finish()
    }
}
/// See [`GetHealthCheckLastFailureReasonOutput`](crate::output::GetHealthCheckLastFailureReasonOutput)
pub mod get_health_check_last_failure_reason_output {
    /// A builder for [`GetHealthCheckLastFailureReasonOutput`](crate::output::GetHealthCheckLastFailureReasonOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) health_check_observations:
            std::option::Option<std::vec::Vec<crate::model::HealthCheckObservation>>,
    }
    impl Builder {
        /// Appends an item to `health_check_observations`.
        ///
        /// To override the contents of this collection use [`set_health_check_observations`](Self::set_health_check_observations).
        ///
        /// <p>A list that contains one <code>Observation</code> element for each Amazon Route 53 health checker that is reporting a last failure reason. </p>
        pub fn health_check_observations(
            mut self,
            input: crate::model::HealthCheckObservation,
        ) -> Self {
            let mut v = self.health_check_observations.unwrap_or_default();
            v.push(input);
            self.health_check_observations = Some(v);
            self
        }
        /// <p>A list that contains one <code>Observation</code> element for each Amazon Route 53 health checker that is reporting a last failure reason. </p>
        pub fn set_health_check_observations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HealthCheckObservation>>,
        ) -> Self {
            self.health_check_observations = input;
            self
        }
        /// Consumes the builder and constructs a [`GetHealthCheckLastFailureReasonOutput`](crate::output::GetHealthCheckLastFailureReasonOutput)
        pub fn build(self) -> crate::output::GetHealthCheckLastFailureReasonOutput {
            crate::output::GetHealthCheckLastFailureReasonOutput {
                health_check_observations: self.health_check_observations,
            }
        }
    }
}
impl GetHealthCheckLastFailureReasonOutput {
    /// Creates a new builder-style object to manufacture [`GetHealthCheckLastFailureReasonOutput`](crate::output::GetHealthCheckLastFailureReasonOutput)
    pub fn builder() -> crate::output::get_health_check_last_failure_reason_output::Builder {
        crate::output::get_health_check_last_failure_reason_output::Builder::default()
    }
}

/// <p>A complex type that contains the response to a <code>GetHealthCheckCount</code> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetHealthCheckCountOutput {
    /// <p>The number of health checks associated with the current Amazon Web Services account.</p>
    pub health_check_count: std::option::Option<i64>,
}
impl GetHealthCheckCountOutput {
    /// <p>The number of health checks associated with the current Amazon Web Services account.</p>
    pub fn health_check_count(&self) -> std::option::Option<i64> {
        self.health_check_count
    }
}
impl std::fmt::Debug for GetHealthCheckCountOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetHealthCheckCountOutput");
        formatter.field("health_check_count", &self.health_check_count);
        formatter.finish()
    }
}
/// See [`GetHealthCheckCountOutput`](crate::output::GetHealthCheckCountOutput)
pub mod get_health_check_count_output {
    /// A builder for [`GetHealthCheckCountOutput`](crate::output::GetHealthCheckCountOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) health_check_count: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The number of health checks associated with the current Amazon Web Services account.</p>
        pub fn health_check_count(mut self, input: i64) -> Self {
            self.health_check_count = Some(input);
            self
        }
        /// <p>The number of health checks associated with the current Amazon Web Services account.</p>
        pub fn set_health_check_count(mut self, input: std::option::Option<i64>) -> Self {
            self.health_check_count = input;
            self
        }
        /// Consumes the builder and constructs a [`GetHealthCheckCountOutput`](crate::output::GetHealthCheckCountOutput)
        pub fn build(self) -> crate::output::GetHealthCheckCountOutput {
            crate::output::GetHealthCheckCountOutput {
                health_check_count: self.health_check_count,
            }
        }
    }
}
impl GetHealthCheckCountOutput {
    /// Creates a new builder-style object to manufacture [`GetHealthCheckCountOutput`](crate::output::GetHealthCheckCountOutput)
    pub fn builder() -> crate::output::get_health_check_count_output::Builder {
        crate::output::get_health_check_count_output::Builder::default()
    }
}

/// <p>A complex type that contains the response to a <code>GetHealthCheck</code> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetHealthCheckOutput {
    /// <p>A complex type that contains information about one health check that is associated with the current Amazon Web Services account.</p>
    pub health_check: std::option::Option<crate::model::HealthCheck>,
}
impl GetHealthCheckOutput {
    /// <p>A complex type that contains information about one health check that is associated with the current Amazon Web Services account.</p>
    pub fn health_check(&self) -> std::option::Option<&crate::model::HealthCheck> {
        self.health_check.as_ref()
    }
}
impl std::fmt::Debug for GetHealthCheckOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetHealthCheckOutput");
        formatter.field("health_check", &self.health_check);
        formatter.finish()
    }
}
/// See [`GetHealthCheckOutput`](crate::output::GetHealthCheckOutput)
pub mod get_health_check_output {
    /// A builder for [`GetHealthCheckOutput`](crate::output::GetHealthCheckOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) health_check: std::option::Option<crate::model::HealthCheck>,
    }
    impl Builder {
        /// <p>A complex type that contains information about one health check that is associated with the current Amazon Web Services account.</p>
        pub fn health_check(mut self, input: crate::model::HealthCheck) -> Self {
            self.health_check = Some(input);
            self
        }
        /// <p>A complex type that contains information about one health check that is associated with the current Amazon Web Services account.</p>
        pub fn set_health_check(
            mut self,
            input: std::option::Option<crate::model::HealthCheck>,
        ) -> Self {
            self.health_check = input;
            self
        }
        /// Consumes the builder and constructs a [`GetHealthCheckOutput`](crate::output::GetHealthCheckOutput)
        pub fn build(self) -> crate::output::GetHealthCheckOutput {
            crate::output::GetHealthCheckOutput {
                health_check: self.health_check,
            }
        }
    }
}
impl GetHealthCheckOutput {
    /// Creates a new builder-style object to manufacture [`GetHealthCheckOutput`](crate::output::GetHealthCheckOutput)
    pub fn builder() -> crate::output::get_health_check_output::Builder {
        crate::output::get_health_check_output::Builder::default()
    }
}

/// <p>A complex type that contains the response information for the specified geolocation code.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetGeoLocationOutput {
    /// <p>A complex type that contains the codes and full continent, country, and subdivision names for the specified geolocation code.</p>
    pub geo_location_details: std::option::Option<crate::model::GeoLocationDetails>,
}
impl GetGeoLocationOutput {
    /// <p>A complex type that contains the codes and full continent, country, and subdivision names for the specified geolocation code.</p>
    pub fn geo_location_details(&self) -> std::option::Option<&crate::model::GeoLocationDetails> {
        self.geo_location_details.as_ref()
    }
}
impl std::fmt::Debug for GetGeoLocationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetGeoLocationOutput");
        formatter.field("geo_location_details", &self.geo_location_details);
        formatter.finish()
    }
}
/// See [`GetGeoLocationOutput`](crate::output::GetGeoLocationOutput)
pub mod get_geo_location_output {
    /// A builder for [`GetGeoLocationOutput`](crate::output::GetGeoLocationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) geo_location_details: std::option::Option<crate::model::GeoLocationDetails>,
    }
    impl Builder {
        /// <p>A complex type that contains the codes and full continent, country, and subdivision names for the specified geolocation code.</p>
        pub fn geo_location_details(mut self, input: crate::model::GeoLocationDetails) -> Self {
            self.geo_location_details = Some(input);
            self
        }
        /// <p>A complex type that contains the codes and full continent, country, and subdivision names for the specified geolocation code.</p>
        pub fn set_geo_location_details(
            mut self,
            input: std::option::Option<crate::model::GeoLocationDetails>,
        ) -> Self {
            self.geo_location_details = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGeoLocationOutput`](crate::output::GetGeoLocationOutput)
        pub fn build(self) -> crate::output::GetGeoLocationOutput {
            crate::output::GetGeoLocationOutput {
                geo_location_details: self.geo_location_details,
            }
        }
    }
}
impl GetGeoLocationOutput {
    /// Creates a new builder-style object to manufacture [`GetGeoLocationOutput`](crate::output::GetGeoLocationOutput)
    pub fn builder() -> crate::output::get_geo_location_output::Builder {
        crate::output::get_geo_location_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDnssecOutput {
    /// <p>A string repesenting the status of DNSSEC.</p>
    pub status: std::option::Option<crate::model::DnssecStatus>,
    /// <p>The key-signing keys (KSKs) in your account.</p>
    pub key_signing_keys: std::option::Option<std::vec::Vec<crate::model::KeySigningKey>>,
}
impl GetDnssecOutput {
    /// <p>A string repesenting the status of DNSSEC.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::DnssecStatus> {
        self.status.as_ref()
    }
    /// <p>The key-signing keys (KSKs) in your account.</p>
    pub fn key_signing_keys(&self) -> std::option::Option<&[crate::model::KeySigningKey]> {
        self.key_signing_keys.as_deref()
    }
}
impl std::fmt::Debug for GetDnssecOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDnssecOutput");
        formatter.field("status", &self.status);
        formatter.field("key_signing_keys", &self.key_signing_keys);
        formatter.finish()
    }
}
/// See [`GetDnssecOutput`](crate::output::GetDnssecOutput)
pub mod get_dnssec_output {
    /// A builder for [`GetDnssecOutput`](crate::output::GetDnssecOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::DnssecStatus>,
        pub(crate) key_signing_keys:
            std::option::Option<std::vec::Vec<crate::model::KeySigningKey>>,
    }
    impl Builder {
        /// <p>A string repesenting the status of DNSSEC.</p>
        pub fn status(mut self, input: crate::model::DnssecStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>A string repesenting the status of DNSSEC.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DnssecStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `key_signing_keys`.
        ///
        /// To override the contents of this collection use [`set_key_signing_keys`](Self::set_key_signing_keys).
        ///
        /// <p>The key-signing keys (KSKs) in your account.</p>
        pub fn key_signing_keys(mut self, input: crate::model::KeySigningKey) -> Self {
            let mut v = self.key_signing_keys.unwrap_or_default();
            v.push(input);
            self.key_signing_keys = Some(v);
            self
        }
        /// <p>The key-signing keys (KSKs) in your account.</p>
        pub fn set_key_signing_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::KeySigningKey>>,
        ) -> Self {
            self.key_signing_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDnssecOutput`](crate::output::GetDnssecOutput)
        pub fn build(self) -> crate::output::GetDnssecOutput {
            crate::output::GetDnssecOutput {
                status: self.status,
                key_signing_keys: self.key_signing_keys,
            }
        }
    }
}
impl GetDnssecOutput {
    /// Creates a new builder-style object to manufacture [`GetDnssecOutput`](crate::output::GetDnssecOutput)
    pub fn builder() -> crate::output::get_dnssec_output::Builder {
        crate::output::get_dnssec_output::Builder::default()
    }
}

/// <p>A complex type that contains the <code>CheckerIpRanges</code> element.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCheckerIpRangesOutput {
    /// <p>A complex type that contains sorted list of IP ranges in CIDR format for Amazon Route 53 health checkers.</p>
    pub checker_ip_ranges: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl GetCheckerIpRangesOutput {
    /// <p>A complex type that contains sorted list of IP ranges in CIDR format for Amazon Route 53 health checkers.</p>
    pub fn checker_ip_ranges(&self) -> std::option::Option<&[std::string::String]> {
        self.checker_ip_ranges.as_deref()
    }
}
impl std::fmt::Debug for GetCheckerIpRangesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCheckerIpRangesOutput");
        formatter.field("checker_ip_ranges", &self.checker_ip_ranges);
        formatter.finish()
    }
}
/// See [`GetCheckerIpRangesOutput`](crate::output::GetCheckerIpRangesOutput)
pub mod get_checker_ip_ranges_output {
    /// A builder for [`GetCheckerIpRangesOutput`](crate::output::GetCheckerIpRangesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) checker_ip_ranges: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `checker_ip_ranges`.
        ///
        /// To override the contents of this collection use [`set_checker_ip_ranges`](Self::set_checker_ip_ranges).
        ///
        /// <p>A complex type that contains sorted list of IP ranges in CIDR format for Amazon Route 53 health checkers.</p>
        pub fn checker_ip_ranges(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.checker_ip_ranges.unwrap_or_default();
            v.push(input.into());
            self.checker_ip_ranges = Some(v);
            self
        }
        /// <p>A complex type that contains sorted list of IP ranges in CIDR format for Amazon Route 53 health checkers.</p>
        pub fn set_checker_ip_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.checker_ip_ranges = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCheckerIpRangesOutput`](crate::output::GetCheckerIpRangesOutput)
        pub fn build(self) -> crate::output::GetCheckerIpRangesOutput {
            crate::output::GetCheckerIpRangesOutput {
                checker_ip_ranges: self.checker_ip_ranges,
            }
        }
    }
}
impl GetCheckerIpRangesOutput {
    /// Creates a new builder-style object to manufacture [`GetCheckerIpRangesOutput`](crate::output::GetCheckerIpRangesOutput)
    pub fn builder() -> crate::output::get_checker_ip_ranges_output::Builder {
        crate::output::get_checker_ip_ranges_output::Builder::default()
    }
}

/// <p>A complex type that contains the <code>ChangeInfo</code> element.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetChangeOutput {
    /// <p>A complex type that contains information about the specified change batch.</p>
    pub change_info: std::option::Option<crate::model::ChangeInfo>,
}
impl GetChangeOutput {
    /// <p>A complex type that contains information about the specified change batch.</p>
    pub fn change_info(&self) -> std::option::Option<&crate::model::ChangeInfo> {
        self.change_info.as_ref()
    }
}
impl std::fmt::Debug for GetChangeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetChangeOutput");
        formatter.field("change_info", &self.change_info);
        formatter.finish()
    }
}
/// See [`GetChangeOutput`](crate::output::GetChangeOutput)
pub mod get_change_output {
    /// A builder for [`GetChangeOutput`](crate::output::GetChangeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_info: std::option::Option<crate::model::ChangeInfo>,
    }
    impl Builder {
        /// <p>A complex type that contains information about the specified change batch.</p>
        pub fn change_info(mut self, input: crate::model::ChangeInfo) -> Self {
            self.change_info = Some(input);
            self
        }
        /// <p>A complex type that contains information about the specified change batch.</p>
        pub fn set_change_info(
            mut self,
            input: std::option::Option<crate::model::ChangeInfo>,
        ) -> Self {
            self.change_info = input;
            self
        }
        /// Consumes the builder and constructs a [`GetChangeOutput`](crate::output::GetChangeOutput)
        pub fn build(self) -> crate::output::GetChangeOutput {
            crate::output::GetChangeOutput {
                change_info: self.change_info,
            }
        }
    }
}
impl GetChangeOutput {
    /// Creates a new builder-style object to manufacture [`GetChangeOutput`](crate::output::GetChangeOutput)
    pub fn builder() -> crate::output::get_change_output::Builder {
        crate::output::get_change_output::Builder::default()
    }
}

/// <p>A complex type that contains the requested limit. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAccountLimitOutput {
    /// <p>The current setting for the specified limit. For example, if you specified <code>MAX_HEALTH_CHECKS_BY_OWNER</code> for the value of <code>Type</code> in the request, the value of <code>Limit</code> is the maximum number of health checks that you can create using the current account.</p>
    pub limit: std::option::Option<crate::model::AccountLimit>,
    /// <p>The current number of entities that you have created of the specified type. For example, if you specified <code>MAX_HEALTH_CHECKS_BY_OWNER</code> for the value of <code>Type</code> in the request, the value of <code>Count</code> is the current number of health checks that you have created using the current account.</p>
    pub count: i64,
}
impl GetAccountLimitOutput {
    /// <p>The current setting for the specified limit. For example, if you specified <code>MAX_HEALTH_CHECKS_BY_OWNER</code> for the value of <code>Type</code> in the request, the value of <code>Limit</code> is the maximum number of health checks that you can create using the current account.</p>
    pub fn limit(&self) -> std::option::Option<&crate::model::AccountLimit> {
        self.limit.as_ref()
    }
    /// <p>The current number of entities that you have created of the specified type. For example, if you specified <code>MAX_HEALTH_CHECKS_BY_OWNER</code> for the value of <code>Type</code> in the request, the value of <code>Count</code> is the current number of health checks that you have created using the current account.</p>
    pub fn count(&self) -> i64 {
        self.count
    }
}
impl std::fmt::Debug for GetAccountLimitOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAccountLimitOutput");
        formatter.field("limit", &self.limit);
        formatter.field("count", &self.count);
        formatter.finish()
    }
}
/// See [`GetAccountLimitOutput`](crate::output::GetAccountLimitOutput)
pub mod get_account_limit_output {
    /// A builder for [`GetAccountLimitOutput`](crate::output::GetAccountLimitOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) limit: std::option::Option<crate::model::AccountLimit>,
        pub(crate) count: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The current setting for the specified limit. For example, if you specified <code>MAX_HEALTH_CHECKS_BY_OWNER</code> for the value of <code>Type</code> in the request, the value of <code>Limit</code> is the maximum number of health checks that you can create using the current account.</p>
        pub fn limit(mut self, input: crate::model::AccountLimit) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The current setting for the specified limit. For example, if you specified <code>MAX_HEALTH_CHECKS_BY_OWNER</code> for the value of <code>Type</code> in the request, the value of <code>Limit</code> is the maximum number of health checks that you can create using the current account.</p>
        pub fn set_limit(mut self, input: std::option::Option<crate::model::AccountLimit>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The current number of entities that you have created of the specified type. For example, if you specified <code>MAX_HEALTH_CHECKS_BY_OWNER</code> for the value of <code>Type</code> in the request, the value of <code>Count</code> is the current number of health checks that you have created using the current account.</p>
        pub fn count(mut self, input: i64) -> Self {
            self.count = Some(input);
            self
        }
        /// <p>The current number of entities that you have created of the specified type. For example, if you specified <code>MAX_HEALTH_CHECKS_BY_OWNER</code> for the value of <code>Type</code> in the request, the value of <code>Count</code> is the current number of health checks that you have created using the current account.</p>
        pub fn set_count(mut self, input: std::option::Option<i64>) -> Self {
            self.count = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAccountLimitOutput`](crate::output::GetAccountLimitOutput)
        pub fn build(self) -> crate::output::GetAccountLimitOutput {
            crate::output::GetAccountLimitOutput {
                limit: self.limit,
                count: self.count.unwrap_or_default(),
            }
        }
    }
}
impl GetAccountLimitOutput {
    /// Creates a new builder-style object to manufacture [`GetAccountLimitOutput`](crate::output::GetAccountLimitOutput)
    pub fn builder() -> crate::output::get_account_limit_output::Builder {
        crate::output::get_account_limit_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableHostedZoneDnssecOutput {
    /// <p>A complex type that describes change information about changes made to your hosted zone.</p>
    pub change_info: std::option::Option<crate::model::ChangeInfo>,
}
impl EnableHostedZoneDnssecOutput {
    /// <p>A complex type that describes change information about changes made to your hosted zone.</p>
    pub fn change_info(&self) -> std::option::Option<&crate::model::ChangeInfo> {
        self.change_info.as_ref()
    }
}
impl std::fmt::Debug for EnableHostedZoneDnssecOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableHostedZoneDnssecOutput");
        formatter.field("change_info", &self.change_info);
        formatter.finish()
    }
}
/// See [`EnableHostedZoneDnssecOutput`](crate::output::EnableHostedZoneDnssecOutput)
pub mod enable_hosted_zone_dnssec_output {
    /// A builder for [`EnableHostedZoneDnssecOutput`](crate::output::EnableHostedZoneDnssecOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_info: std::option::Option<crate::model::ChangeInfo>,
    }
    impl Builder {
        /// <p>A complex type that describes change information about changes made to your hosted zone.</p>
        pub fn change_info(mut self, input: crate::model::ChangeInfo) -> Self {
            self.change_info = Some(input);
            self
        }
        /// <p>A complex type that describes change information about changes made to your hosted zone.</p>
        pub fn set_change_info(
            mut self,
            input: std::option::Option<crate::model::ChangeInfo>,
        ) -> Self {
            self.change_info = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableHostedZoneDnssecOutput`](crate::output::EnableHostedZoneDnssecOutput)
        pub fn build(self) -> crate::output::EnableHostedZoneDnssecOutput {
            crate::output::EnableHostedZoneDnssecOutput {
                change_info: self.change_info,
            }
        }
    }
}
impl EnableHostedZoneDnssecOutput {
    /// Creates a new builder-style object to manufacture [`EnableHostedZoneDnssecOutput`](crate::output::EnableHostedZoneDnssecOutput)
    pub fn builder() -> crate::output::enable_hosted_zone_dnssec_output::Builder {
        crate::output::enable_hosted_zone_dnssec_output::Builder::default()
    }
}

/// <p>A complex type that contains the response information for the disassociate request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateVpcFromHostedZoneOutput {
    /// <p>A complex type that describes the changes made to the specified private hosted zone.</p>
    pub change_info: std::option::Option<crate::model::ChangeInfo>,
}
impl DisassociateVpcFromHostedZoneOutput {
    /// <p>A complex type that describes the changes made to the specified private hosted zone.</p>
    pub fn change_info(&self) -> std::option::Option<&crate::model::ChangeInfo> {
        self.change_info.as_ref()
    }
}
impl std::fmt::Debug for DisassociateVpcFromHostedZoneOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateVpcFromHostedZoneOutput");
        formatter.field("change_info", &self.change_info);
        formatter.finish()
    }
}
/// See [`DisassociateVpcFromHostedZoneOutput`](crate::output::DisassociateVpcFromHostedZoneOutput)
pub mod disassociate_vpc_from_hosted_zone_output {
    /// A builder for [`DisassociateVpcFromHostedZoneOutput`](crate::output::DisassociateVpcFromHostedZoneOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_info: std::option::Option<crate::model::ChangeInfo>,
    }
    impl Builder {
        /// <p>A complex type that describes the changes made to the specified private hosted zone.</p>
        pub fn change_info(mut self, input: crate::model::ChangeInfo) -> Self {
            self.change_info = Some(input);
            self
        }
        /// <p>A complex type that describes the changes made to the specified private hosted zone.</p>
        pub fn set_change_info(
            mut self,
            input: std::option::Option<crate::model::ChangeInfo>,
        ) -> Self {
            self.change_info = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateVpcFromHostedZoneOutput`](crate::output::DisassociateVpcFromHostedZoneOutput)
        pub fn build(self) -> crate::output::DisassociateVpcFromHostedZoneOutput {
            crate::output::DisassociateVpcFromHostedZoneOutput {
                change_info: self.change_info,
            }
        }
    }
}
impl DisassociateVpcFromHostedZoneOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateVpcFromHostedZoneOutput`](crate::output::DisassociateVpcFromHostedZoneOutput)
    pub fn builder() -> crate::output::disassociate_vpc_from_hosted_zone_output::Builder {
        crate::output::disassociate_vpc_from_hosted_zone_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableHostedZoneDnssecOutput {
    /// <p>A complex type that describes change information about changes made to your hosted zone.</p>
    pub change_info: std::option::Option<crate::model::ChangeInfo>,
}
impl DisableHostedZoneDnssecOutput {
    /// <p>A complex type that describes change information about changes made to your hosted zone.</p>
    pub fn change_info(&self) -> std::option::Option<&crate::model::ChangeInfo> {
        self.change_info.as_ref()
    }
}
impl std::fmt::Debug for DisableHostedZoneDnssecOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableHostedZoneDnssecOutput");
        formatter.field("change_info", &self.change_info);
        formatter.finish()
    }
}
/// See [`DisableHostedZoneDnssecOutput`](crate::output::DisableHostedZoneDnssecOutput)
pub mod disable_hosted_zone_dnssec_output {
    /// A builder for [`DisableHostedZoneDnssecOutput`](crate::output::DisableHostedZoneDnssecOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_info: std::option::Option<crate::model::ChangeInfo>,
    }
    impl Builder {
        /// <p>A complex type that describes change information about changes made to your hosted zone.</p>
        pub fn change_info(mut self, input: crate::model::ChangeInfo) -> Self {
            self.change_info = Some(input);
            self
        }
        /// <p>A complex type that describes change information about changes made to your hosted zone.</p>
        pub fn set_change_info(
            mut self,
            input: std::option::Option<crate::model::ChangeInfo>,
        ) -> Self {
            self.change_info = input;
            self
        }
        /// Consumes the builder and constructs a [`DisableHostedZoneDnssecOutput`](crate::output::DisableHostedZoneDnssecOutput)
        pub fn build(self) -> crate::output::DisableHostedZoneDnssecOutput {
            crate::output::DisableHostedZoneDnssecOutput {
                change_info: self.change_info,
            }
        }
    }
}
impl DisableHostedZoneDnssecOutput {
    /// Creates a new builder-style object to manufacture [`DisableHostedZoneDnssecOutput`](crate::output::DisableHostedZoneDnssecOutput)
    pub fn builder() -> crate::output::disable_hosted_zone_dnssec_output::Builder {
        crate::output::disable_hosted_zone_dnssec_output::Builder::default()
    }
}

/// <p>Empty response for the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteVpcAssociationAuthorizationOutput {}
impl std::fmt::Debug for DeleteVpcAssociationAuthorizationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteVpcAssociationAuthorizationOutput");
        formatter.finish()
    }
}
/// See [`DeleteVpcAssociationAuthorizationOutput`](crate::output::DeleteVpcAssociationAuthorizationOutput)
pub mod delete_vpc_association_authorization_output {
    /// A builder for [`DeleteVpcAssociationAuthorizationOutput`](crate::output::DeleteVpcAssociationAuthorizationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteVpcAssociationAuthorizationOutput`](crate::output::DeleteVpcAssociationAuthorizationOutput)
        pub fn build(self) -> crate::output::DeleteVpcAssociationAuthorizationOutput {
            crate::output::DeleteVpcAssociationAuthorizationOutput {}
        }
    }
}
impl DeleteVpcAssociationAuthorizationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteVpcAssociationAuthorizationOutput`](crate::output::DeleteVpcAssociationAuthorizationOutput)
    pub fn builder() -> crate::output::delete_vpc_association_authorization_output::Builder {
        crate::output::delete_vpc_association_authorization_output::Builder::default()
    }
}

/// <p>An empty element.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTrafficPolicyInstanceOutput {}
impl std::fmt::Debug for DeleteTrafficPolicyInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTrafficPolicyInstanceOutput");
        formatter.finish()
    }
}
/// See [`DeleteTrafficPolicyInstanceOutput`](crate::output::DeleteTrafficPolicyInstanceOutput)
pub mod delete_traffic_policy_instance_output {
    /// A builder for [`DeleteTrafficPolicyInstanceOutput`](crate::output::DeleteTrafficPolicyInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteTrafficPolicyInstanceOutput`](crate::output::DeleteTrafficPolicyInstanceOutput)
        pub fn build(self) -> crate::output::DeleteTrafficPolicyInstanceOutput {
            crate::output::DeleteTrafficPolicyInstanceOutput {}
        }
    }
}
impl DeleteTrafficPolicyInstanceOutput {
    /// Creates a new builder-style object to manufacture [`DeleteTrafficPolicyInstanceOutput`](crate::output::DeleteTrafficPolicyInstanceOutput)
    pub fn builder() -> crate::output::delete_traffic_policy_instance_output::Builder {
        crate::output::delete_traffic_policy_instance_output::Builder::default()
    }
}

/// <p>An empty element.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTrafficPolicyOutput {}
impl std::fmt::Debug for DeleteTrafficPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTrafficPolicyOutput");
        formatter.finish()
    }
}
/// See [`DeleteTrafficPolicyOutput`](crate::output::DeleteTrafficPolicyOutput)
pub mod delete_traffic_policy_output {
    /// A builder for [`DeleteTrafficPolicyOutput`](crate::output::DeleteTrafficPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteTrafficPolicyOutput`](crate::output::DeleteTrafficPolicyOutput)
        pub fn build(self) -> crate::output::DeleteTrafficPolicyOutput {
            crate::output::DeleteTrafficPolicyOutput {}
        }
    }
}
impl DeleteTrafficPolicyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteTrafficPolicyOutput`](crate::output::DeleteTrafficPolicyOutput)
    pub fn builder() -> crate::output::delete_traffic_policy_output::Builder {
        crate::output::delete_traffic_policy_output::Builder::default()
    }
}

/// <p>An empty element.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteReusableDelegationSetOutput {}
impl std::fmt::Debug for DeleteReusableDelegationSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteReusableDelegationSetOutput");
        formatter.finish()
    }
}
/// See [`DeleteReusableDelegationSetOutput`](crate::output::DeleteReusableDelegationSetOutput)
pub mod delete_reusable_delegation_set_output {
    /// A builder for [`DeleteReusableDelegationSetOutput`](crate::output::DeleteReusableDelegationSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteReusableDelegationSetOutput`](crate::output::DeleteReusableDelegationSetOutput)
        pub fn build(self) -> crate::output::DeleteReusableDelegationSetOutput {
            crate::output::DeleteReusableDelegationSetOutput {}
        }
    }
}
impl DeleteReusableDelegationSetOutput {
    /// Creates a new builder-style object to manufacture [`DeleteReusableDelegationSetOutput`](crate::output::DeleteReusableDelegationSetOutput)
    pub fn builder() -> crate::output::delete_reusable_delegation_set_output::Builder {
        crate::output::delete_reusable_delegation_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteQueryLoggingConfigOutput {}
impl std::fmt::Debug for DeleteQueryLoggingConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteQueryLoggingConfigOutput");
        formatter.finish()
    }
}
/// See [`DeleteQueryLoggingConfigOutput`](crate::output::DeleteQueryLoggingConfigOutput)
pub mod delete_query_logging_config_output {
    /// A builder for [`DeleteQueryLoggingConfigOutput`](crate::output::DeleteQueryLoggingConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteQueryLoggingConfigOutput`](crate::output::DeleteQueryLoggingConfigOutput)
        pub fn build(self) -> crate::output::DeleteQueryLoggingConfigOutput {
            crate::output::DeleteQueryLoggingConfigOutput {}
        }
    }
}
impl DeleteQueryLoggingConfigOutput {
    /// Creates a new builder-style object to manufacture [`DeleteQueryLoggingConfigOutput`](crate::output::DeleteQueryLoggingConfigOutput)
    pub fn builder() -> crate::output::delete_query_logging_config_output::Builder {
        crate::output::delete_query_logging_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteKeySigningKeyOutput {
    /// <p>A complex type that describes change information about changes made to your hosted zone.</p>
    pub change_info: std::option::Option<crate::model::ChangeInfo>,
}
impl DeleteKeySigningKeyOutput {
    /// <p>A complex type that describes change information about changes made to your hosted zone.</p>
    pub fn change_info(&self) -> std::option::Option<&crate::model::ChangeInfo> {
        self.change_info.as_ref()
    }
}
impl std::fmt::Debug for DeleteKeySigningKeyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteKeySigningKeyOutput");
        formatter.field("change_info", &self.change_info);
        formatter.finish()
    }
}
/// See [`DeleteKeySigningKeyOutput`](crate::output::DeleteKeySigningKeyOutput)
pub mod delete_key_signing_key_output {
    /// A builder for [`DeleteKeySigningKeyOutput`](crate::output::DeleteKeySigningKeyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_info: std::option::Option<crate::model::ChangeInfo>,
    }
    impl Builder {
        /// <p>A complex type that describes change information about changes made to your hosted zone.</p>
        pub fn change_info(mut self, input: crate::model::ChangeInfo) -> Self {
            self.change_info = Some(input);
            self
        }
        /// <p>A complex type that describes change information about changes made to your hosted zone.</p>
        pub fn set_change_info(
            mut self,
            input: std::option::Option<crate::model::ChangeInfo>,
        ) -> Self {
            self.change_info = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteKeySigningKeyOutput`](crate::output::DeleteKeySigningKeyOutput)
        pub fn build(self) -> crate::output::DeleteKeySigningKeyOutput {
            crate::output::DeleteKeySigningKeyOutput {
                change_info: self.change_info,
            }
        }
    }
}
impl DeleteKeySigningKeyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteKeySigningKeyOutput`](crate::output::DeleteKeySigningKeyOutput)
    pub fn builder() -> crate::output::delete_key_signing_key_output::Builder {
        crate::output::delete_key_signing_key_output::Builder::default()
    }
}

/// <p>A complex type that contains the response to a <code>DeleteHostedZone</code> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteHostedZoneOutput {
    /// <p>A complex type that contains the ID, the status, and the date and time of a request to delete a hosted zone.</p>
    pub change_info: std::option::Option<crate::model::ChangeInfo>,
}
impl DeleteHostedZoneOutput {
    /// <p>A complex type that contains the ID, the status, and the date and time of a request to delete a hosted zone.</p>
    pub fn change_info(&self) -> std::option::Option<&crate::model::ChangeInfo> {
        self.change_info.as_ref()
    }
}
impl std::fmt::Debug for DeleteHostedZoneOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteHostedZoneOutput");
        formatter.field("change_info", &self.change_info);
        formatter.finish()
    }
}
/// See [`DeleteHostedZoneOutput`](crate::output::DeleteHostedZoneOutput)
pub mod delete_hosted_zone_output {
    /// A builder for [`DeleteHostedZoneOutput`](crate::output::DeleteHostedZoneOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_info: std::option::Option<crate::model::ChangeInfo>,
    }
    impl Builder {
        /// <p>A complex type that contains the ID, the status, and the date and time of a request to delete a hosted zone.</p>
        pub fn change_info(mut self, input: crate::model::ChangeInfo) -> Self {
            self.change_info = Some(input);
            self
        }
        /// <p>A complex type that contains the ID, the status, and the date and time of a request to delete a hosted zone.</p>
        pub fn set_change_info(
            mut self,
            input: std::option::Option<crate::model::ChangeInfo>,
        ) -> Self {
            self.change_info = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteHostedZoneOutput`](crate::output::DeleteHostedZoneOutput)
        pub fn build(self) -> crate::output::DeleteHostedZoneOutput {
            crate::output::DeleteHostedZoneOutput {
                change_info: self.change_info,
            }
        }
    }
}
impl DeleteHostedZoneOutput {
    /// Creates a new builder-style object to manufacture [`DeleteHostedZoneOutput`](crate::output::DeleteHostedZoneOutput)
    pub fn builder() -> crate::output::delete_hosted_zone_output::Builder {
        crate::output::delete_hosted_zone_output::Builder::default()
    }
}

/// <p>An empty element.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteHealthCheckOutput {}
impl std::fmt::Debug for DeleteHealthCheckOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteHealthCheckOutput");
        formatter.finish()
    }
}
/// See [`DeleteHealthCheckOutput`](crate::output::DeleteHealthCheckOutput)
pub mod delete_health_check_output {
    /// A builder for [`DeleteHealthCheckOutput`](crate::output::DeleteHealthCheckOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteHealthCheckOutput`](crate::output::DeleteHealthCheckOutput)
        pub fn build(self) -> crate::output::DeleteHealthCheckOutput {
            crate::output::DeleteHealthCheckOutput {}
        }
    }
}
impl DeleteHealthCheckOutput {
    /// Creates a new builder-style object to manufacture [`DeleteHealthCheckOutput`](crate::output::DeleteHealthCheckOutput)
    pub fn builder() -> crate::output::delete_health_check_output::Builder {
        crate::output::delete_health_check_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeactivateKeySigningKeyOutput {
    /// <p>A complex type that describes change information about changes made to your hosted zone.</p>
    pub change_info: std::option::Option<crate::model::ChangeInfo>,
}
impl DeactivateKeySigningKeyOutput {
    /// <p>A complex type that describes change information about changes made to your hosted zone.</p>
    pub fn change_info(&self) -> std::option::Option<&crate::model::ChangeInfo> {
        self.change_info.as_ref()
    }
}
impl std::fmt::Debug for DeactivateKeySigningKeyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeactivateKeySigningKeyOutput");
        formatter.field("change_info", &self.change_info);
        formatter.finish()
    }
}
/// See [`DeactivateKeySigningKeyOutput`](crate::output::DeactivateKeySigningKeyOutput)
pub mod deactivate_key_signing_key_output {
    /// A builder for [`DeactivateKeySigningKeyOutput`](crate::output::DeactivateKeySigningKeyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_info: std::option::Option<crate::model::ChangeInfo>,
    }
    impl Builder {
        /// <p>A complex type that describes change information about changes made to your hosted zone.</p>
        pub fn change_info(mut self, input: crate::model::ChangeInfo) -> Self {
            self.change_info = Some(input);
            self
        }
        /// <p>A complex type that describes change information about changes made to your hosted zone.</p>
        pub fn set_change_info(
            mut self,
            input: std::option::Option<crate::model::ChangeInfo>,
        ) -> Self {
            self.change_info = input;
            self
        }
        /// Consumes the builder and constructs a [`DeactivateKeySigningKeyOutput`](crate::output::DeactivateKeySigningKeyOutput)
        pub fn build(self) -> crate::output::DeactivateKeySigningKeyOutput {
            crate::output::DeactivateKeySigningKeyOutput {
                change_info: self.change_info,
            }
        }
    }
}
impl DeactivateKeySigningKeyOutput {
    /// Creates a new builder-style object to manufacture [`DeactivateKeySigningKeyOutput`](crate::output::DeactivateKeySigningKeyOutput)
    pub fn builder() -> crate::output::deactivate_key_signing_key_output::Builder {
        crate::output::deactivate_key_signing_key_output::Builder::default()
    }
}

/// <p>A complex type that contains the response information from a <code>CreateVPCAssociationAuthorization</code> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateVpcAssociationAuthorizationOutput {
    /// <p>The ID of the hosted zone that you authorized associating a VPC with.</p>
    pub hosted_zone_id: std::option::Option<std::string::String>,
    /// <p>The VPC that you authorized associating with a hosted zone.</p>
    pub vpc: std::option::Option<crate::model::Vpc>,
}
impl CreateVpcAssociationAuthorizationOutput {
    /// <p>The ID of the hosted zone that you authorized associating a VPC with.</p>
    pub fn hosted_zone_id(&self) -> std::option::Option<&str> {
        self.hosted_zone_id.as_deref()
    }
    /// <p>The VPC that you authorized associating with a hosted zone.</p>
    pub fn vpc(&self) -> std::option::Option<&crate::model::Vpc> {
        self.vpc.as_ref()
    }
}
impl std::fmt::Debug for CreateVpcAssociationAuthorizationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateVpcAssociationAuthorizationOutput");
        formatter.field("hosted_zone_id", &self.hosted_zone_id);
        formatter.field("vpc", &self.vpc);
        formatter.finish()
    }
}
/// See [`CreateVpcAssociationAuthorizationOutput`](crate::output::CreateVpcAssociationAuthorizationOutput)
pub mod create_vpc_association_authorization_output {
    /// A builder for [`CreateVpcAssociationAuthorizationOutput`](crate::output::CreateVpcAssociationAuthorizationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hosted_zone_id: std::option::Option<std::string::String>,
        pub(crate) vpc: std::option::Option<crate::model::Vpc>,
    }
    impl Builder {
        /// <p>The ID of the hosted zone that you authorized associating a VPC with.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hosted_zone_id = Some(input.into());
            self
        }
        /// <p>The ID of the hosted zone that you authorized associating a VPC with.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hosted_zone_id = input;
            self
        }
        /// <p>The VPC that you authorized associating with a hosted zone.</p>
        pub fn vpc(mut self, input: crate::model::Vpc) -> Self {
            self.vpc = Some(input);
            self
        }
        /// <p>The VPC that you authorized associating with a hosted zone.</p>
        pub fn set_vpc(mut self, input: std::option::Option<crate::model::Vpc>) -> Self {
            self.vpc = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateVpcAssociationAuthorizationOutput`](crate::output::CreateVpcAssociationAuthorizationOutput)
        pub fn build(self) -> crate::output::CreateVpcAssociationAuthorizationOutput {
            crate::output::CreateVpcAssociationAuthorizationOutput {
                hosted_zone_id: self.hosted_zone_id,
                vpc: self.vpc,
            }
        }
    }
}
impl CreateVpcAssociationAuthorizationOutput {
    /// Creates a new builder-style object to manufacture [`CreateVpcAssociationAuthorizationOutput`](crate::output::CreateVpcAssociationAuthorizationOutput)
    pub fn builder() -> crate::output::create_vpc_association_authorization_output::Builder {
        crate::output::create_vpc_association_authorization_output::Builder::default()
    }
}

/// <p>A complex type that contains the response information for the <code>CreateTrafficPolicyVersion</code> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTrafficPolicyVersionOutput {
    /// <p>A complex type that contains settings for the new version of the traffic policy.</p>
    pub traffic_policy: std::option::Option<crate::model::TrafficPolicy>,
    /// <p>A unique URL that represents a new traffic policy version.</p>
    pub location: std::option::Option<std::string::String>,
}
impl CreateTrafficPolicyVersionOutput {
    /// <p>A complex type that contains settings for the new version of the traffic policy.</p>
    pub fn traffic_policy(&self) -> std::option::Option<&crate::model::TrafficPolicy> {
        self.traffic_policy.as_ref()
    }
    /// <p>A unique URL that represents a new traffic policy version.</p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
}
impl std::fmt::Debug for CreateTrafficPolicyVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTrafficPolicyVersionOutput");
        formatter.field("traffic_policy", &self.traffic_policy);
        formatter.field("location", &self.location);
        formatter.finish()
    }
}
/// See [`CreateTrafficPolicyVersionOutput`](crate::output::CreateTrafficPolicyVersionOutput)
pub mod create_traffic_policy_version_output {
    /// A builder for [`CreateTrafficPolicyVersionOutput`](crate::output::CreateTrafficPolicyVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) traffic_policy: std::option::Option<crate::model::TrafficPolicy>,
        pub(crate) location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A complex type that contains settings for the new version of the traffic policy.</p>
        pub fn traffic_policy(mut self, input: crate::model::TrafficPolicy) -> Self {
            self.traffic_policy = Some(input);
            self
        }
        /// <p>A complex type that contains settings for the new version of the traffic policy.</p>
        pub fn set_traffic_policy(
            mut self,
            input: std::option::Option<crate::model::TrafficPolicy>,
        ) -> Self {
            self.traffic_policy = input;
            self
        }
        /// <p>A unique URL that represents a new traffic policy version.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>A unique URL that represents a new traffic policy version.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTrafficPolicyVersionOutput`](crate::output::CreateTrafficPolicyVersionOutput)
        pub fn build(self) -> crate::output::CreateTrafficPolicyVersionOutput {
            crate::output::CreateTrafficPolicyVersionOutput {
                traffic_policy: self.traffic_policy,
                location: self.location,
            }
        }
    }
}
impl CreateTrafficPolicyVersionOutput {
    /// Creates a new builder-style object to manufacture [`CreateTrafficPolicyVersionOutput`](crate::output::CreateTrafficPolicyVersionOutput)
    pub fn builder() -> crate::output::create_traffic_policy_version_output::Builder {
        crate::output::create_traffic_policy_version_output::Builder::default()
    }
}

/// <p>A complex type that contains the response information for the <code>CreateTrafficPolicyInstance</code> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTrafficPolicyInstanceOutput {
    /// <p>A complex type that contains settings for the new traffic policy instance.</p>
    pub traffic_policy_instance: std::option::Option<crate::model::TrafficPolicyInstance>,
    /// <p>A unique URL that represents a new traffic policy instance.</p>
    pub location: std::option::Option<std::string::String>,
}
impl CreateTrafficPolicyInstanceOutput {
    /// <p>A complex type that contains settings for the new traffic policy instance.</p>
    pub fn traffic_policy_instance(
        &self,
    ) -> std::option::Option<&crate::model::TrafficPolicyInstance> {
        self.traffic_policy_instance.as_ref()
    }
    /// <p>A unique URL that represents a new traffic policy instance.</p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
}
impl std::fmt::Debug for CreateTrafficPolicyInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTrafficPolicyInstanceOutput");
        formatter.field("traffic_policy_instance", &self.traffic_policy_instance);
        formatter.field("location", &self.location);
        formatter.finish()
    }
}
/// See [`CreateTrafficPolicyInstanceOutput`](crate::output::CreateTrafficPolicyInstanceOutput)
pub mod create_traffic_policy_instance_output {
    /// A builder for [`CreateTrafficPolicyInstanceOutput`](crate::output::CreateTrafficPolicyInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) traffic_policy_instance:
            std::option::Option<crate::model::TrafficPolicyInstance>,
        pub(crate) location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A complex type that contains settings for the new traffic policy instance.</p>
        pub fn traffic_policy_instance(
            mut self,
            input: crate::model::TrafficPolicyInstance,
        ) -> Self {
            self.traffic_policy_instance = Some(input);
            self
        }
        /// <p>A complex type that contains settings for the new traffic policy instance.</p>
        pub fn set_traffic_policy_instance(
            mut self,
            input: std::option::Option<crate::model::TrafficPolicyInstance>,
        ) -> Self {
            self.traffic_policy_instance = input;
            self
        }
        /// <p>A unique URL that represents a new traffic policy instance.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>A unique URL that represents a new traffic policy instance.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTrafficPolicyInstanceOutput`](crate::output::CreateTrafficPolicyInstanceOutput)
        pub fn build(self) -> crate::output::CreateTrafficPolicyInstanceOutput {
            crate::output::CreateTrafficPolicyInstanceOutput {
                traffic_policy_instance: self.traffic_policy_instance,
                location: self.location,
            }
        }
    }
}
impl CreateTrafficPolicyInstanceOutput {
    /// Creates a new builder-style object to manufacture [`CreateTrafficPolicyInstanceOutput`](crate::output::CreateTrafficPolicyInstanceOutput)
    pub fn builder() -> crate::output::create_traffic_policy_instance_output::Builder {
        crate::output::create_traffic_policy_instance_output::Builder::default()
    }
}

/// <p>A complex type that contains the response information for the <code>CreateTrafficPolicy</code> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTrafficPolicyOutput {
    /// <p>A complex type that contains settings for the new traffic policy.</p>
    pub traffic_policy: std::option::Option<crate::model::TrafficPolicy>,
    /// <p>A unique URL that represents a new traffic policy.</p>
    pub location: std::option::Option<std::string::String>,
}
impl CreateTrafficPolicyOutput {
    /// <p>A complex type that contains settings for the new traffic policy.</p>
    pub fn traffic_policy(&self) -> std::option::Option<&crate::model::TrafficPolicy> {
        self.traffic_policy.as_ref()
    }
    /// <p>A unique URL that represents a new traffic policy.</p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
}
impl std::fmt::Debug for CreateTrafficPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTrafficPolicyOutput");
        formatter.field("traffic_policy", &self.traffic_policy);
        formatter.field("location", &self.location);
        formatter.finish()
    }
}
/// See [`CreateTrafficPolicyOutput`](crate::output::CreateTrafficPolicyOutput)
pub mod create_traffic_policy_output {
    /// A builder for [`CreateTrafficPolicyOutput`](crate::output::CreateTrafficPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) traffic_policy: std::option::Option<crate::model::TrafficPolicy>,
        pub(crate) location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A complex type that contains settings for the new traffic policy.</p>
        pub fn traffic_policy(mut self, input: crate::model::TrafficPolicy) -> Self {
            self.traffic_policy = Some(input);
            self
        }
        /// <p>A complex type that contains settings for the new traffic policy.</p>
        pub fn set_traffic_policy(
            mut self,
            input: std::option::Option<crate::model::TrafficPolicy>,
        ) -> Self {
            self.traffic_policy = input;
            self
        }
        /// <p>A unique URL that represents a new traffic policy.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>A unique URL that represents a new traffic policy.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTrafficPolicyOutput`](crate::output::CreateTrafficPolicyOutput)
        pub fn build(self) -> crate::output::CreateTrafficPolicyOutput {
            crate::output::CreateTrafficPolicyOutput {
                traffic_policy: self.traffic_policy,
                location: self.location,
            }
        }
    }
}
impl CreateTrafficPolicyOutput {
    /// Creates a new builder-style object to manufacture [`CreateTrafficPolicyOutput`](crate::output::CreateTrafficPolicyOutput)
    pub fn builder() -> crate::output::create_traffic_policy_output::Builder {
        crate::output::create_traffic_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateReusableDelegationSetOutput {
    /// <p>A complex type that contains name server information.</p>
    pub delegation_set: std::option::Option<crate::model::DelegationSet>,
    /// <p>The unique URL representing the new reusable delegation set.</p>
    pub location: std::option::Option<std::string::String>,
}
impl CreateReusableDelegationSetOutput {
    /// <p>A complex type that contains name server information.</p>
    pub fn delegation_set(&self) -> std::option::Option<&crate::model::DelegationSet> {
        self.delegation_set.as_ref()
    }
    /// <p>The unique URL representing the new reusable delegation set.</p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
}
impl std::fmt::Debug for CreateReusableDelegationSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateReusableDelegationSetOutput");
        formatter.field("delegation_set", &self.delegation_set);
        formatter.field("location", &self.location);
        formatter.finish()
    }
}
/// See [`CreateReusableDelegationSetOutput`](crate::output::CreateReusableDelegationSetOutput)
pub mod create_reusable_delegation_set_output {
    /// A builder for [`CreateReusableDelegationSetOutput`](crate::output::CreateReusableDelegationSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delegation_set: std::option::Option<crate::model::DelegationSet>,
        pub(crate) location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A complex type that contains name server information.</p>
        pub fn delegation_set(mut self, input: crate::model::DelegationSet) -> Self {
            self.delegation_set = Some(input);
            self
        }
        /// <p>A complex type that contains name server information.</p>
        pub fn set_delegation_set(
            mut self,
            input: std::option::Option<crate::model::DelegationSet>,
        ) -> Self {
            self.delegation_set = input;
            self
        }
        /// <p>The unique URL representing the new reusable delegation set.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The unique URL representing the new reusable delegation set.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateReusableDelegationSetOutput`](crate::output::CreateReusableDelegationSetOutput)
        pub fn build(self) -> crate::output::CreateReusableDelegationSetOutput {
            crate::output::CreateReusableDelegationSetOutput {
                delegation_set: self.delegation_set,
                location: self.location,
            }
        }
    }
}
impl CreateReusableDelegationSetOutput {
    /// Creates a new builder-style object to manufacture [`CreateReusableDelegationSetOutput`](crate::output::CreateReusableDelegationSetOutput)
    pub fn builder() -> crate::output::create_reusable_delegation_set_output::Builder {
        crate::output::create_reusable_delegation_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateQueryLoggingConfigOutput {
    /// <p>A complex type that contains the ID for a query logging configuration, the ID of the hosted zone that you want to log queries for, and the ARN for the log group that you want Amazon Route 53 to send query logs to.</p>
    pub query_logging_config: std::option::Option<crate::model::QueryLoggingConfig>,
    /// <p>The unique URL representing the new query logging configuration.</p>
    pub location: std::option::Option<std::string::String>,
}
impl CreateQueryLoggingConfigOutput {
    /// <p>A complex type that contains the ID for a query logging configuration, the ID of the hosted zone that you want to log queries for, and the ARN for the log group that you want Amazon Route 53 to send query logs to.</p>
    pub fn query_logging_config(&self) -> std::option::Option<&crate::model::QueryLoggingConfig> {
        self.query_logging_config.as_ref()
    }
    /// <p>The unique URL representing the new query logging configuration.</p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
}
impl std::fmt::Debug for CreateQueryLoggingConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateQueryLoggingConfigOutput");
        formatter.field("query_logging_config", &self.query_logging_config);
        formatter.field("location", &self.location);
        formatter.finish()
    }
}
/// See [`CreateQueryLoggingConfigOutput`](crate::output::CreateQueryLoggingConfigOutput)
pub mod create_query_logging_config_output {
    /// A builder for [`CreateQueryLoggingConfigOutput`](crate::output::CreateQueryLoggingConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) query_logging_config: std::option::Option<crate::model::QueryLoggingConfig>,
        pub(crate) location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A complex type that contains the ID for a query logging configuration, the ID of the hosted zone that you want to log queries for, and the ARN for the log group that you want Amazon Route 53 to send query logs to.</p>
        pub fn query_logging_config(mut self, input: crate::model::QueryLoggingConfig) -> Self {
            self.query_logging_config = Some(input);
            self
        }
        /// <p>A complex type that contains the ID for a query logging configuration, the ID of the hosted zone that you want to log queries for, and the ARN for the log group that you want Amazon Route 53 to send query logs to.</p>
        pub fn set_query_logging_config(
            mut self,
            input: std::option::Option<crate::model::QueryLoggingConfig>,
        ) -> Self {
            self.query_logging_config = input;
            self
        }
        /// <p>The unique URL representing the new query logging configuration.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The unique URL representing the new query logging configuration.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateQueryLoggingConfigOutput`](crate::output::CreateQueryLoggingConfigOutput)
        pub fn build(self) -> crate::output::CreateQueryLoggingConfigOutput {
            crate::output::CreateQueryLoggingConfigOutput {
                query_logging_config: self.query_logging_config,
                location: self.location,
            }
        }
    }
}
impl CreateQueryLoggingConfigOutput {
    /// Creates a new builder-style object to manufacture [`CreateQueryLoggingConfigOutput`](crate::output::CreateQueryLoggingConfigOutput)
    pub fn builder() -> crate::output::create_query_logging_config_output::Builder {
        crate::output::create_query_logging_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateKeySigningKeyOutput {
    /// <p>A complex type that describes change information about changes made to your hosted zone.</p>
    pub change_info: std::option::Option<crate::model::ChangeInfo>,
    /// <p>The key-signing key (KSK) that the request creates.</p>
    pub key_signing_key: std::option::Option<crate::model::KeySigningKey>,
    /// <p>The unique URL representing the new key-signing key (KSK).</p>
    pub location: std::option::Option<std::string::String>,
}
impl CreateKeySigningKeyOutput {
    /// <p>A complex type that describes change information about changes made to your hosted zone.</p>
    pub fn change_info(&self) -> std::option::Option<&crate::model::ChangeInfo> {
        self.change_info.as_ref()
    }
    /// <p>The key-signing key (KSK) that the request creates.</p>
    pub fn key_signing_key(&self) -> std::option::Option<&crate::model::KeySigningKey> {
        self.key_signing_key.as_ref()
    }
    /// <p>The unique URL representing the new key-signing key (KSK).</p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
}
impl std::fmt::Debug for CreateKeySigningKeyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateKeySigningKeyOutput");
        formatter.field("change_info", &self.change_info);
        formatter.field("key_signing_key", &self.key_signing_key);
        formatter.field("location", &self.location);
        formatter.finish()
    }
}
/// See [`CreateKeySigningKeyOutput`](crate::output::CreateKeySigningKeyOutput)
pub mod create_key_signing_key_output {
    /// A builder for [`CreateKeySigningKeyOutput`](crate::output::CreateKeySigningKeyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_info: std::option::Option<crate::model::ChangeInfo>,
        pub(crate) key_signing_key: std::option::Option<crate::model::KeySigningKey>,
        pub(crate) location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A complex type that describes change information about changes made to your hosted zone.</p>
        pub fn change_info(mut self, input: crate::model::ChangeInfo) -> Self {
            self.change_info = Some(input);
            self
        }
        /// <p>A complex type that describes change information about changes made to your hosted zone.</p>
        pub fn set_change_info(
            mut self,
            input: std::option::Option<crate::model::ChangeInfo>,
        ) -> Self {
            self.change_info = input;
            self
        }
        /// <p>The key-signing key (KSK) that the request creates.</p>
        pub fn key_signing_key(mut self, input: crate::model::KeySigningKey) -> Self {
            self.key_signing_key = Some(input);
            self
        }
        /// <p>The key-signing key (KSK) that the request creates.</p>
        pub fn set_key_signing_key(
            mut self,
            input: std::option::Option<crate::model::KeySigningKey>,
        ) -> Self {
            self.key_signing_key = input;
            self
        }
        /// <p>The unique URL representing the new key-signing key (KSK).</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The unique URL representing the new key-signing key (KSK).</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateKeySigningKeyOutput`](crate::output::CreateKeySigningKeyOutput)
        pub fn build(self) -> crate::output::CreateKeySigningKeyOutput {
            crate::output::CreateKeySigningKeyOutput {
                change_info: self.change_info,
                key_signing_key: self.key_signing_key,
                location: self.location,
            }
        }
    }
}
impl CreateKeySigningKeyOutput {
    /// Creates a new builder-style object to manufacture [`CreateKeySigningKeyOutput`](crate::output::CreateKeySigningKeyOutput)
    pub fn builder() -> crate::output::create_key_signing_key_output::Builder {
        crate::output::create_key_signing_key_output::Builder::default()
    }
}

/// <p>A complex type containing the response information for the hosted zone.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateHostedZoneOutput {
    /// <p>A complex type that contains general information about the hosted zone.</p>
    pub hosted_zone: std::option::Option<crate::model::HostedZone>,
    /// <p>A complex type that contains information about the <code>CreateHostedZone</code> request.</p>
    pub change_info: std::option::Option<crate::model::ChangeInfo>,
    /// <p>A complex type that describes the name servers for this hosted zone.</p>
    pub delegation_set: std::option::Option<crate::model::DelegationSet>,
    /// <p>A complex type that contains information about an Amazon VPC that you associated with this hosted zone.</p>
    pub vpc: std::option::Option<crate::model::Vpc>,
    /// <p>The unique URL representing the new hosted zone.</p>
    pub location: std::option::Option<std::string::String>,
}
impl CreateHostedZoneOutput {
    /// <p>A complex type that contains general information about the hosted zone.</p>
    pub fn hosted_zone(&self) -> std::option::Option<&crate::model::HostedZone> {
        self.hosted_zone.as_ref()
    }
    /// <p>A complex type that contains information about the <code>CreateHostedZone</code> request.</p>
    pub fn change_info(&self) -> std::option::Option<&crate::model::ChangeInfo> {
        self.change_info.as_ref()
    }
    /// <p>A complex type that describes the name servers for this hosted zone.</p>
    pub fn delegation_set(&self) -> std::option::Option<&crate::model::DelegationSet> {
        self.delegation_set.as_ref()
    }
    /// <p>A complex type that contains information about an Amazon VPC that you associated with this hosted zone.</p>
    pub fn vpc(&self) -> std::option::Option<&crate::model::Vpc> {
        self.vpc.as_ref()
    }
    /// <p>The unique URL representing the new hosted zone.</p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
}
impl std::fmt::Debug for CreateHostedZoneOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateHostedZoneOutput");
        formatter.field("hosted_zone", &self.hosted_zone);
        formatter.field("change_info", &self.change_info);
        formatter.field("delegation_set", &self.delegation_set);
        formatter.field("vpc", &self.vpc);
        formatter.field("location", &self.location);
        formatter.finish()
    }
}
/// See [`CreateHostedZoneOutput`](crate::output::CreateHostedZoneOutput)
pub mod create_hosted_zone_output {
    /// A builder for [`CreateHostedZoneOutput`](crate::output::CreateHostedZoneOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hosted_zone: std::option::Option<crate::model::HostedZone>,
        pub(crate) change_info: std::option::Option<crate::model::ChangeInfo>,
        pub(crate) delegation_set: std::option::Option<crate::model::DelegationSet>,
        pub(crate) vpc: std::option::Option<crate::model::Vpc>,
        pub(crate) location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A complex type that contains general information about the hosted zone.</p>
        pub fn hosted_zone(mut self, input: crate::model::HostedZone) -> Self {
            self.hosted_zone = Some(input);
            self
        }
        /// <p>A complex type that contains general information about the hosted zone.</p>
        pub fn set_hosted_zone(
            mut self,
            input: std::option::Option<crate::model::HostedZone>,
        ) -> Self {
            self.hosted_zone = input;
            self
        }
        /// <p>A complex type that contains information about the <code>CreateHostedZone</code> request.</p>
        pub fn change_info(mut self, input: crate::model::ChangeInfo) -> Self {
            self.change_info = Some(input);
            self
        }
        /// <p>A complex type that contains information about the <code>CreateHostedZone</code> request.</p>
        pub fn set_change_info(
            mut self,
            input: std::option::Option<crate::model::ChangeInfo>,
        ) -> Self {
            self.change_info = input;
            self
        }
        /// <p>A complex type that describes the name servers for this hosted zone.</p>
        pub fn delegation_set(mut self, input: crate::model::DelegationSet) -> Self {
            self.delegation_set = Some(input);
            self
        }
        /// <p>A complex type that describes the name servers for this hosted zone.</p>
        pub fn set_delegation_set(
            mut self,
            input: std::option::Option<crate::model::DelegationSet>,
        ) -> Self {
            self.delegation_set = input;
            self
        }
        /// <p>A complex type that contains information about an Amazon VPC that you associated with this hosted zone.</p>
        pub fn vpc(mut self, input: crate::model::Vpc) -> Self {
            self.vpc = Some(input);
            self
        }
        /// <p>A complex type that contains information about an Amazon VPC that you associated with this hosted zone.</p>
        pub fn set_vpc(mut self, input: std::option::Option<crate::model::Vpc>) -> Self {
            self.vpc = input;
            self
        }
        /// <p>The unique URL representing the new hosted zone.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The unique URL representing the new hosted zone.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateHostedZoneOutput`](crate::output::CreateHostedZoneOutput)
        pub fn build(self) -> crate::output::CreateHostedZoneOutput {
            crate::output::CreateHostedZoneOutput {
                hosted_zone: self.hosted_zone,
                change_info: self.change_info,
                delegation_set: self.delegation_set,
                vpc: self.vpc,
                location: self.location,
            }
        }
    }
}
impl CreateHostedZoneOutput {
    /// Creates a new builder-style object to manufacture [`CreateHostedZoneOutput`](crate::output::CreateHostedZoneOutput)
    pub fn builder() -> crate::output::create_hosted_zone_output::Builder {
        crate::output::create_hosted_zone_output::Builder::default()
    }
}

/// <p>A complex type containing the response information for the new health check.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateHealthCheckOutput {
    /// <p>A complex type that contains identifying information about the health check.</p>
    pub health_check: std::option::Option<crate::model::HealthCheck>,
    /// <p>The unique URL representing the new health check.</p>
    pub location: std::option::Option<std::string::String>,
}
impl CreateHealthCheckOutput {
    /// <p>A complex type that contains identifying information about the health check.</p>
    pub fn health_check(&self) -> std::option::Option<&crate::model::HealthCheck> {
        self.health_check.as_ref()
    }
    /// <p>The unique URL representing the new health check.</p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
}
impl std::fmt::Debug for CreateHealthCheckOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateHealthCheckOutput");
        formatter.field("health_check", &self.health_check);
        formatter.field("location", &self.location);
        formatter.finish()
    }
}
/// See [`CreateHealthCheckOutput`](crate::output::CreateHealthCheckOutput)
pub mod create_health_check_output {
    /// A builder for [`CreateHealthCheckOutput`](crate::output::CreateHealthCheckOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) health_check: std::option::Option<crate::model::HealthCheck>,
        pub(crate) location: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A complex type that contains identifying information about the health check.</p>
        pub fn health_check(mut self, input: crate::model::HealthCheck) -> Self {
            self.health_check = Some(input);
            self
        }
        /// <p>A complex type that contains identifying information about the health check.</p>
        pub fn set_health_check(
            mut self,
            input: std::option::Option<crate::model::HealthCheck>,
        ) -> Self {
            self.health_check = input;
            self
        }
        /// <p>The unique URL representing the new health check.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The unique URL representing the new health check.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateHealthCheckOutput`](crate::output::CreateHealthCheckOutput)
        pub fn build(self) -> crate::output::CreateHealthCheckOutput {
            crate::output::CreateHealthCheckOutput {
                health_check: self.health_check,
                location: self.location,
            }
        }
    }
}
impl CreateHealthCheckOutput {
    /// Creates a new builder-style object to manufacture [`CreateHealthCheckOutput`](crate::output::CreateHealthCheckOutput)
    pub fn builder() -> crate::output::create_health_check_output::Builder {
        crate::output::create_health_check_output::Builder::default()
    }
}

/// <p>Empty response for the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChangeTagsForResourceOutput {}
impl std::fmt::Debug for ChangeTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChangeTagsForResourceOutput");
        formatter.finish()
    }
}
/// See [`ChangeTagsForResourceOutput`](crate::output::ChangeTagsForResourceOutput)
pub mod change_tags_for_resource_output {
    /// A builder for [`ChangeTagsForResourceOutput`](crate::output::ChangeTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ChangeTagsForResourceOutput`](crate::output::ChangeTagsForResourceOutput)
        pub fn build(self) -> crate::output::ChangeTagsForResourceOutput {
            crate::output::ChangeTagsForResourceOutput {}
        }
    }
}
impl ChangeTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ChangeTagsForResourceOutput`](crate::output::ChangeTagsForResourceOutput)
    pub fn builder() -> crate::output::change_tags_for_resource_output::Builder {
        crate::output::change_tags_for_resource_output::Builder::default()
    }
}

/// <p>A complex type containing the response for the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChangeResourceRecordSetsOutput {
    /// <p>A complex type that contains information about changes made to your hosted zone.</p>
    /// <p>This element contains an ID that you use when performing a <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetChange.html">GetChange</a> action to get detailed information about the change.</p>
    pub change_info: std::option::Option<crate::model::ChangeInfo>,
}
impl ChangeResourceRecordSetsOutput {
    /// <p>A complex type that contains information about changes made to your hosted zone.</p>
    /// <p>This element contains an ID that you use when performing a <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetChange.html">GetChange</a> action to get detailed information about the change.</p>
    pub fn change_info(&self) -> std::option::Option<&crate::model::ChangeInfo> {
        self.change_info.as_ref()
    }
}
impl std::fmt::Debug for ChangeResourceRecordSetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChangeResourceRecordSetsOutput");
        formatter.field("change_info", &self.change_info);
        formatter.finish()
    }
}
/// See [`ChangeResourceRecordSetsOutput`](crate::output::ChangeResourceRecordSetsOutput)
pub mod change_resource_record_sets_output {
    /// A builder for [`ChangeResourceRecordSetsOutput`](crate::output::ChangeResourceRecordSetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_info: std::option::Option<crate::model::ChangeInfo>,
    }
    impl Builder {
        /// <p>A complex type that contains information about changes made to your hosted zone.</p>
        /// <p>This element contains an ID that you use when performing a <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetChange.html">GetChange</a> action to get detailed information about the change.</p>
        pub fn change_info(mut self, input: crate::model::ChangeInfo) -> Self {
            self.change_info = Some(input);
            self
        }
        /// <p>A complex type that contains information about changes made to your hosted zone.</p>
        /// <p>This element contains an ID that you use when performing a <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetChange.html">GetChange</a> action to get detailed information about the change.</p>
        pub fn set_change_info(
            mut self,
            input: std::option::Option<crate::model::ChangeInfo>,
        ) -> Self {
            self.change_info = input;
            self
        }
        /// Consumes the builder and constructs a [`ChangeResourceRecordSetsOutput`](crate::output::ChangeResourceRecordSetsOutput)
        pub fn build(self) -> crate::output::ChangeResourceRecordSetsOutput {
            crate::output::ChangeResourceRecordSetsOutput {
                change_info: self.change_info,
            }
        }
    }
}
impl ChangeResourceRecordSetsOutput {
    /// Creates a new builder-style object to manufacture [`ChangeResourceRecordSetsOutput`](crate::output::ChangeResourceRecordSetsOutput)
    pub fn builder() -> crate::output::change_resource_record_sets_output::Builder {
        crate::output::change_resource_record_sets_output::Builder::default()
    }
}

/// <p>A complex type that contains the response information for the <code>AssociateVPCWithHostedZone</code> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateVpcWithHostedZoneOutput {
    /// <p>A complex type that describes the changes made to your hosted zone.</p>
    pub change_info: std::option::Option<crate::model::ChangeInfo>,
}
impl AssociateVpcWithHostedZoneOutput {
    /// <p>A complex type that describes the changes made to your hosted zone.</p>
    pub fn change_info(&self) -> std::option::Option<&crate::model::ChangeInfo> {
        self.change_info.as_ref()
    }
}
impl std::fmt::Debug for AssociateVpcWithHostedZoneOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateVpcWithHostedZoneOutput");
        formatter.field("change_info", &self.change_info);
        formatter.finish()
    }
}
/// See [`AssociateVpcWithHostedZoneOutput`](crate::output::AssociateVpcWithHostedZoneOutput)
pub mod associate_vpc_with_hosted_zone_output {
    /// A builder for [`AssociateVpcWithHostedZoneOutput`](crate::output::AssociateVpcWithHostedZoneOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_info: std::option::Option<crate::model::ChangeInfo>,
    }
    impl Builder {
        /// <p>A complex type that describes the changes made to your hosted zone.</p>
        pub fn change_info(mut self, input: crate::model::ChangeInfo) -> Self {
            self.change_info = Some(input);
            self
        }
        /// <p>A complex type that describes the changes made to your hosted zone.</p>
        pub fn set_change_info(
            mut self,
            input: std::option::Option<crate::model::ChangeInfo>,
        ) -> Self {
            self.change_info = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateVpcWithHostedZoneOutput`](crate::output::AssociateVpcWithHostedZoneOutput)
        pub fn build(self) -> crate::output::AssociateVpcWithHostedZoneOutput {
            crate::output::AssociateVpcWithHostedZoneOutput {
                change_info: self.change_info,
            }
        }
    }
}
impl AssociateVpcWithHostedZoneOutput {
    /// Creates a new builder-style object to manufacture [`AssociateVpcWithHostedZoneOutput`](crate::output::AssociateVpcWithHostedZoneOutput)
    pub fn builder() -> crate::output::associate_vpc_with_hosted_zone_output::Builder {
        crate::output::associate_vpc_with_hosted_zone_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActivateKeySigningKeyOutput {
    /// <p>A complex type that describes change information about changes made to your hosted zone.</p>
    pub change_info: std::option::Option<crate::model::ChangeInfo>,
}
impl ActivateKeySigningKeyOutput {
    /// <p>A complex type that describes change information about changes made to your hosted zone.</p>
    pub fn change_info(&self) -> std::option::Option<&crate::model::ChangeInfo> {
        self.change_info.as_ref()
    }
}
impl std::fmt::Debug for ActivateKeySigningKeyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActivateKeySigningKeyOutput");
        formatter.field("change_info", &self.change_info);
        formatter.finish()
    }
}
/// See [`ActivateKeySigningKeyOutput`](crate::output::ActivateKeySigningKeyOutput)
pub mod activate_key_signing_key_output {
    /// A builder for [`ActivateKeySigningKeyOutput`](crate::output::ActivateKeySigningKeyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_info: std::option::Option<crate::model::ChangeInfo>,
    }
    impl Builder {
        /// <p>A complex type that describes change information about changes made to your hosted zone.</p>
        pub fn change_info(mut self, input: crate::model::ChangeInfo) -> Self {
            self.change_info = Some(input);
            self
        }
        /// <p>A complex type that describes change information about changes made to your hosted zone.</p>
        pub fn set_change_info(
            mut self,
            input: std::option::Option<crate::model::ChangeInfo>,
        ) -> Self {
            self.change_info = input;
            self
        }
        /// Consumes the builder and constructs a [`ActivateKeySigningKeyOutput`](crate::output::ActivateKeySigningKeyOutput)
        pub fn build(self) -> crate::output::ActivateKeySigningKeyOutput {
            crate::output::ActivateKeySigningKeyOutput {
                change_info: self.change_info,
            }
        }
    }
}
impl ActivateKeySigningKeyOutput {
    /// Creates a new builder-style object to manufacture [`ActivateKeySigningKeyOutput`](crate::output::ActivateKeySigningKeyOutput)
    pub fn builder() -> crate::output::activate_key_signing_key_output::Builder {
        crate::output::activate_key_signing_key_output::Builder::default()
    }
}
