// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Route 53
///
/// Client for invoking operations on Amazon Route 53. Each operation on Amazon Route 53 is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_route53::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_route53::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_route53::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `ActivateKeySigningKey` operation.
    ///
    /// See [`ActivateKeySigningKey`](crate::client::fluent_builders::ActivateKeySigningKey) for more information about the
    /// operation and its arguments.
    pub fn activate_key_signing_key(&self) -> fluent_builders::ActivateKeySigningKey<C, M, R> {
        fluent_builders::ActivateKeySigningKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateVPCWithHostedZone` operation.
    ///
    /// See [`AssociateVPCWithHostedZone`](crate::client::fluent_builders::AssociateVPCWithHostedZone) for more information about the
    /// operation and its arguments.
    pub fn associate_vpc_with_hosted_zone(
        &self,
    ) -> fluent_builders::AssociateVPCWithHostedZone<C, M, R> {
        fluent_builders::AssociateVPCWithHostedZone::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ChangeResourceRecordSets` operation.
    ///
    /// See [`ChangeResourceRecordSets`](crate::client::fluent_builders::ChangeResourceRecordSets) for more information about the
    /// operation and its arguments.
    pub fn change_resource_record_sets(
        &self,
    ) -> fluent_builders::ChangeResourceRecordSets<C, M, R> {
        fluent_builders::ChangeResourceRecordSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ChangeTagsForResource` operation.
    ///
    /// See [`ChangeTagsForResource`](crate::client::fluent_builders::ChangeTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn change_tags_for_resource(&self) -> fluent_builders::ChangeTagsForResource<C, M, R> {
        fluent_builders::ChangeTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateHealthCheck` operation.
    ///
    /// See [`CreateHealthCheck`](crate::client::fluent_builders::CreateHealthCheck) for more information about the
    /// operation and its arguments.
    pub fn create_health_check(&self) -> fluent_builders::CreateHealthCheck<C, M, R> {
        fluent_builders::CreateHealthCheck::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateHostedZone` operation.
    ///
    /// See [`CreateHostedZone`](crate::client::fluent_builders::CreateHostedZone) for more information about the
    /// operation and its arguments.
    pub fn create_hosted_zone(&self) -> fluent_builders::CreateHostedZone<C, M, R> {
        fluent_builders::CreateHostedZone::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateKeySigningKey` operation.
    ///
    /// See [`CreateKeySigningKey`](crate::client::fluent_builders::CreateKeySigningKey) for more information about the
    /// operation and its arguments.
    pub fn create_key_signing_key(&self) -> fluent_builders::CreateKeySigningKey<C, M, R> {
        fluent_builders::CreateKeySigningKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateQueryLoggingConfig` operation.
    ///
    /// See [`CreateQueryLoggingConfig`](crate::client::fluent_builders::CreateQueryLoggingConfig) for more information about the
    /// operation and its arguments.
    pub fn create_query_logging_config(
        &self,
    ) -> fluent_builders::CreateQueryLoggingConfig<C, M, R> {
        fluent_builders::CreateQueryLoggingConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateReusableDelegationSet` operation.
    ///
    /// See [`CreateReusableDelegationSet`](crate::client::fluent_builders::CreateReusableDelegationSet) for more information about the
    /// operation and its arguments.
    pub fn create_reusable_delegation_set(
        &self,
    ) -> fluent_builders::CreateReusableDelegationSet<C, M, R> {
        fluent_builders::CreateReusableDelegationSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTrafficPolicy` operation.
    ///
    /// See [`CreateTrafficPolicy`](crate::client::fluent_builders::CreateTrafficPolicy) for more information about the
    /// operation and its arguments.
    pub fn create_traffic_policy(&self) -> fluent_builders::CreateTrafficPolicy<C, M, R> {
        fluent_builders::CreateTrafficPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTrafficPolicyInstance` operation.
    ///
    /// See [`CreateTrafficPolicyInstance`](crate::client::fluent_builders::CreateTrafficPolicyInstance) for more information about the
    /// operation and its arguments.
    pub fn create_traffic_policy_instance(
        &self,
    ) -> fluent_builders::CreateTrafficPolicyInstance<C, M, R> {
        fluent_builders::CreateTrafficPolicyInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTrafficPolicyVersion` operation.
    ///
    /// See [`CreateTrafficPolicyVersion`](crate::client::fluent_builders::CreateTrafficPolicyVersion) for more information about the
    /// operation and its arguments.
    pub fn create_traffic_policy_version(
        &self,
    ) -> fluent_builders::CreateTrafficPolicyVersion<C, M, R> {
        fluent_builders::CreateTrafficPolicyVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateVPCAssociationAuthorization` operation.
    ///
    /// See [`CreateVPCAssociationAuthorization`](crate::client::fluent_builders::CreateVPCAssociationAuthorization) for more information about the
    /// operation and its arguments.
    pub fn create_vpc_association_authorization(
        &self,
    ) -> fluent_builders::CreateVPCAssociationAuthorization<C, M, R> {
        fluent_builders::CreateVPCAssociationAuthorization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeactivateKeySigningKey` operation.
    ///
    /// See [`DeactivateKeySigningKey`](crate::client::fluent_builders::DeactivateKeySigningKey) for more information about the
    /// operation and its arguments.
    pub fn deactivate_key_signing_key(&self) -> fluent_builders::DeactivateKeySigningKey<C, M, R> {
        fluent_builders::DeactivateKeySigningKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteHealthCheck` operation.
    ///
    /// See [`DeleteHealthCheck`](crate::client::fluent_builders::DeleteHealthCheck) for more information about the
    /// operation and its arguments.
    pub fn delete_health_check(&self) -> fluent_builders::DeleteHealthCheck<C, M, R> {
        fluent_builders::DeleteHealthCheck::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteHostedZone` operation.
    ///
    /// See [`DeleteHostedZone`](crate::client::fluent_builders::DeleteHostedZone) for more information about the
    /// operation and its arguments.
    pub fn delete_hosted_zone(&self) -> fluent_builders::DeleteHostedZone<C, M, R> {
        fluent_builders::DeleteHostedZone::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteKeySigningKey` operation.
    ///
    /// See [`DeleteKeySigningKey`](crate::client::fluent_builders::DeleteKeySigningKey) for more information about the
    /// operation and its arguments.
    pub fn delete_key_signing_key(&self) -> fluent_builders::DeleteKeySigningKey<C, M, R> {
        fluent_builders::DeleteKeySigningKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteQueryLoggingConfig` operation.
    ///
    /// See [`DeleteQueryLoggingConfig`](crate::client::fluent_builders::DeleteQueryLoggingConfig) for more information about the
    /// operation and its arguments.
    pub fn delete_query_logging_config(
        &self,
    ) -> fluent_builders::DeleteQueryLoggingConfig<C, M, R> {
        fluent_builders::DeleteQueryLoggingConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteReusableDelegationSet` operation.
    ///
    /// See [`DeleteReusableDelegationSet`](crate::client::fluent_builders::DeleteReusableDelegationSet) for more information about the
    /// operation and its arguments.
    pub fn delete_reusable_delegation_set(
        &self,
    ) -> fluent_builders::DeleteReusableDelegationSet<C, M, R> {
        fluent_builders::DeleteReusableDelegationSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTrafficPolicy` operation.
    ///
    /// See [`DeleteTrafficPolicy`](crate::client::fluent_builders::DeleteTrafficPolicy) for more information about the
    /// operation and its arguments.
    pub fn delete_traffic_policy(&self) -> fluent_builders::DeleteTrafficPolicy<C, M, R> {
        fluent_builders::DeleteTrafficPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTrafficPolicyInstance` operation.
    ///
    /// See [`DeleteTrafficPolicyInstance`](crate::client::fluent_builders::DeleteTrafficPolicyInstance) for more information about the
    /// operation and its arguments.
    pub fn delete_traffic_policy_instance(
        &self,
    ) -> fluent_builders::DeleteTrafficPolicyInstance<C, M, R> {
        fluent_builders::DeleteTrafficPolicyInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteVPCAssociationAuthorization` operation.
    ///
    /// See [`DeleteVPCAssociationAuthorization`](crate::client::fluent_builders::DeleteVPCAssociationAuthorization) for more information about the
    /// operation and its arguments.
    pub fn delete_vpc_association_authorization(
        &self,
    ) -> fluent_builders::DeleteVPCAssociationAuthorization<C, M, R> {
        fluent_builders::DeleteVPCAssociationAuthorization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisableHostedZoneDNSSEC` operation.
    ///
    /// See [`DisableHostedZoneDNSSEC`](crate::client::fluent_builders::DisableHostedZoneDNSSEC) for more information about the
    /// operation and its arguments.
    pub fn disable_hosted_zone_dnssec(&self) -> fluent_builders::DisableHostedZoneDNSSEC<C, M, R> {
        fluent_builders::DisableHostedZoneDNSSEC::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateVPCFromHostedZone` operation.
    ///
    /// See [`DisassociateVPCFromHostedZone`](crate::client::fluent_builders::DisassociateVPCFromHostedZone) for more information about the
    /// operation and its arguments.
    pub fn disassociate_vpc_from_hosted_zone(
        &self,
    ) -> fluent_builders::DisassociateVPCFromHostedZone<C, M, R> {
        fluent_builders::DisassociateVPCFromHostedZone::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EnableHostedZoneDNSSEC` operation.
    ///
    /// See [`EnableHostedZoneDNSSEC`](crate::client::fluent_builders::EnableHostedZoneDNSSEC) for more information about the
    /// operation and its arguments.
    pub fn enable_hosted_zone_dnssec(&self) -> fluent_builders::EnableHostedZoneDNSSEC<C, M, R> {
        fluent_builders::EnableHostedZoneDNSSEC::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAccountLimit` operation.
    ///
    /// See [`GetAccountLimit`](crate::client::fluent_builders::GetAccountLimit) for more information about the
    /// operation and its arguments.
    pub fn get_account_limit(&self) -> fluent_builders::GetAccountLimit<C, M, R> {
        fluent_builders::GetAccountLimit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetChange` operation.
    ///
    /// See [`GetChange`](crate::client::fluent_builders::GetChange) for more information about the
    /// operation and its arguments.
    pub fn get_change(&self) -> fluent_builders::GetChange<C, M, R> {
        fluent_builders::GetChange::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCheckerIpRanges` operation.
    ///
    /// See [`GetCheckerIpRanges`](crate::client::fluent_builders::GetCheckerIpRanges) for more information about the
    /// operation and its arguments.
    pub fn get_checker_ip_ranges(&self) -> fluent_builders::GetCheckerIpRanges<C, M, R> {
        fluent_builders::GetCheckerIpRanges::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDNSSEC` operation.
    ///
    /// See [`GetDNSSEC`](crate::client::fluent_builders::GetDNSSEC) for more information about the
    /// operation and its arguments.
    pub fn get_dnssec(&self) -> fluent_builders::GetDNSSEC<C, M, R> {
        fluent_builders::GetDNSSEC::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetGeoLocation` operation.
    ///
    /// See [`GetGeoLocation`](crate::client::fluent_builders::GetGeoLocation) for more information about the
    /// operation and its arguments.
    pub fn get_geo_location(&self) -> fluent_builders::GetGeoLocation<C, M, R> {
        fluent_builders::GetGeoLocation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetHealthCheck` operation.
    ///
    /// See [`GetHealthCheck`](crate::client::fluent_builders::GetHealthCheck) for more information about the
    /// operation and its arguments.
    pub fn get_health_check(&self) -> fluent_builders::GetHealthCheck<C, M, R> {
        fluent_builders::GetHealthCheck::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetHealthCheckCount` operation.
    ///
    /// See [`GetHealthCheckCount`](crate::client::fluent_builders::GetHealthCheckCount) for more information about the
    /// operation and its arguments.
    pub fn get_health_check_count(&self) -> fluent_builders::GetHealthCheckCount<C, M, R> {
        fluent_builders::GetHealthCheckCount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetHealthCheckLastFailureReason` operation.
    ///
    /// See [`GetHealthCheckLastFailureReason`](crate::client::fluent_builders::GetHealthCheckLastFailureReason) for more information about the
    /// operation and its arguments.
    pub fn get_health_check_last_failure_reason(
        &self,
    ) -> fluent_builders::GetHealthCheckLastFailureReason<C, M, R> {
        fluent_builders::GetHealthCheckLastFailureReason::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetHealthCheckStatus` operation.
    ///
    /// See [`GetHealthCheckStatus`](crate::client::fluent_builders::GetHealthCheckStatus) for more information about the
    /// operation and its arguments.
    pub fn get_health_check_status(&self) -> fluent_builders::GetHealthCheckStatus<C, M, R> {
        fluent_builders::GetHealthCheckStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetHostedZone` operation.
    ///
    /// See [`GetHostedZone`](crate::client::fluent_builders::GetHostedZone) for more information about the
    /// operation and its arguments.
    pub fn get_hosted_zone(&self) -> fluent_builders::GetHostedZone<C, M, R> {
        fluent_builders::GetHostedZone::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetHostedZoneCount` operation.
    ///
    /// See [`GetHostedZoneCount`](crate::client::fluent_builders::GetHostedZoneCount) for more information about the
    /// operation and its arguments.
    pub fn get_hosted_zone_count(&self) -> fluent_builders::GetHostedZoneCount<C, M, R> {
        fluent_builders::GetHostedZoneCount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetHostedZoneLimit` operation.
    ///
    /// See [`GetHostedZoneLimit`](crate::client::fluent_builders::GetHostedZoneLimit) for more information about the
    /// operation and its arguments.
    pub fn get_hosted_zone_limit(&self) -> fluent_builders::GetHostedZoneLimit<C, M, R> {
        fluent_builders::GetHostedZoneLimit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetQueryLoggingConfig` operation.
    ///
    /// See [`GetQueryLoggingConfig`](crate::client::fluent_builders::GetQueryLoggingConfig) for more information about the
    /// operation and its arguments.
    pub fn get_query_logging_config(&self) -> fluent_builders::GetQueryLoggingConfig<C, M, R> {
        fluent_builders::GetQueryLoggingConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetReusableDelegationSet` operation.
    ///
    /// See [`GetReusableDelegationSet`](crate::client::fluent_builders::GetReusableDelegationSet) for more information about the
    /// operation and its arguments.
    pub fn get_reusable_delegation_set(
        &self,
    ) -> fluent_builders::GetReusableDelegationSet<C, M, R> {
        fluent_builders::GetReusableDelegationSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetReusableDelegationSetLimit` operation.
    ///
    /// See [`GetReusableDelegationSetLimit`](crate::client::fluent_builders::GetReusableDelegationSetLimit) for more information about the
    /// operation and its arguments.
    pub fn get_reusable_delegation_set_limit(
        &self,
    ) -> fluent_builders::GetReusableDelegationSetLimit<C, M, R> {
        fluent_builders::GetReusableDelegationSetLimit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTrafficPolicy` operation.
    ///
    /// See [`GetTrafficPolicy`](crate::client::fluent_builders::GetTrafficPolicy) for more information about the
    /// operation and its arguments.
    pub fn get_traffic_policy(&self) -> fluent_builders::GetTrafficPolicy<C, M, R> {
        fluent_builders::GetTrafficPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTrafficPolicyInstance` operation.
    ///
    /// See [`GetTrafficPolicyInstance`](crate::client::fluent_builders::GetTrafficPolicyInstance) for more information about the
    /// operation and its arguments.
    pub fn get_traffic_policy_instance(
        &self,
    ) -> fluent_builders::GetTrafficPolicyInstance<C, M, R> {
        fluent_builders::GetTrafficPolicyInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTrafficPolicyInstanceCount` operation.
    ///
    /// See [`GetTrafficPolicyInstanceCount`](crate::client::fluent_builders::GetTrafficPolicyInstanceCount) for more information about the
    /// operation and its arguments.
    pub fn get_traffic_policy_instance_count(
        &self,
    ) -> fluent_builders::GetTrafficPolicyInstanceCount<C, M, R> {
        fluent_builders::GetTrafficPolicyInstanceCount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListGeoLocations` operation.
    ///
    /// See [`ListGeoLocations`](crate::client::fluent_builders::ListGeoLocations) for more information about the
    /// operation and its arguments.
    pub fn list_geo_locations(&self) -> fluent_builders::ListGeoLocations<C, M, R> {
        fluent_builders::ListGeoLocations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListHealthChecks` operation.
    ///
    /// See [`ListHealthChecks`](crate::client::fluent_builders::ListHealthChecks) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListHealthChecks::into_paginator).
    pub fn list_health_checks(&self) -> fluent_builders::ListHealthChecks<C, M, R> {
        fluent_builders::ListHealthChecks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListHostedZones` operation.
    ///
    /// See [`ListHostedZones`](crate::client::fluent_builders::ListHostedZones) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListHostedZones::into_paginator).
    pub fn list_hosted_zones(&self) -> fluent_builders::ListHostedZones<C, M, R> {
        fluent_builders::ListHostedZones::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListHostedZonesByName` operation.
    ///
    /// See [`ListHostedZonesByName`](crate::client::fluent_builders::ListHostedZonesByName) for more information about the
    /// operation and its arguments.
    pub fn list_hosted_zones_by_name(&self) -> fluent_builders::ListHostedZonesByName<C, M, R> {
        fluent_builders::ListHostedZonesByName::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListHostedZonesByVPC` operation.
    ///
    /// See [`ListHostedZonesByVPC`](crate::client::fluent_builders::ListHostedZonesByVPC) for more information about the
    /// operation and its arguments.
    pub fn list_hosted_zones_by_vpc(&self) -> fluent_builders::ListHostedZonesByVPC<C, M, R> {
        fluent_builders::ListHostedZonesByVPC::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListQueryLoggingConfigs` operation.
    ///
    /// See [`ListQueryLoggingConfigs`](crate::client::fluent_builders::ListQueryLoggingConfigs) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListQueryLoggingConfigs::into_paginator).
    pub fn list_query_logging_configs(&self) -> fluent_builders::ListQueryLoggingConfigs<C, M, R> {
        fluent_builders::ListQueryLoggingConfigs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListResourceRecordSets` operation.
    ///
    /// See [`ListResourceRecordSets`](crate::client::fluent_builders::ListResourceRecordSets) for more information about the
    /// operation and its arguments.
    pub fn list_resource_record_sets(&self) -> fluent_builders::ListResourceRecordSets<C, M, R> {
        fluent_builders::ListResourceRecordSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListReusableDelegationSets` operation.
    ///
    /// See [`ListReusableDelegationSets`](crate::client::fluent_builders::ListReusableDelegationSets) for more information about the
    /// operation and its arguments.
    pub fn list_reusable_delegation_sets(
        &self,
    ) -> fluent_builders::ListReusableDelegationSets<C, M, R> {
        fluent_builders::ListReusableDelegationSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResources` operation.
    ///
    /// See [`ListTagsForResources`](crate::client::fluent_builders::ListTagsForResources) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resources(&self) -> fluent_builders::ListTagsForResources<C, M, R> {
        fluent_builders::ListTagsForResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTrafficPolicies` operation.
    ///
    /// See [`ListTrafficPolicies`](crate::client::fluent_builders::ListTrafficPolicies) for more information about the
    /// operation and its arguments.
    pub fn list_traffic_policies(&self) -> fluent_builders::ListTrafficPolicies<C, M, R> {
        fluent_builders::ListTrafficPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTrafficPolicyInstances` operation.
    ///
    /// See [`ListTrafficPolicyInstances`](crate::client::fluent_builders::ListTrafficPolicyInstances) for more information about the
    /// operation and its arguments.
    pub fn list_traffic_policy_instances(
        &self,
    ) -> fluent_builders::ListTrafficPolicyInstances<C, M, R> {
        fluent_builders::ListTrafficPolicyInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTrafficPolicyInstancesByHostedZone` operation.
    ///
    /// See [`ListTrafficPolicyInstancesByHostedZone`](crate::client::fluent_builders::ListTrafficPolicyInstancesByHostedZone) for more information about the
    /// operation and its arguments.
    pub fn list_traffic_policy_instances_by_hosted_zone(
        &self,
    ) -> fluent_builders::ListTrafficPolicyInstancesByHostedZone<C, M, R> {
        fluent_builders::ListTrafficPolicyInstancesByHostedZone::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTrafficPolicyInstancesByPolicy` operation.
    ///
    /// See [`ListTrafficPolicyInstancesByPolicy`](crate::client::fluent_builders::ListTrafficPolicyInstancesByPolicy) for more information about the
    /// operation and its arguments.
    pub fn list_traffic_policy_instances_by_policy(
        &self,
    ) -> fluent_builders::ListTrafficPolicyInstancesByPolicy<C, M, R> {
        fluent_builders::ListTrafficPolicyInstancesByPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTrafficPolicyVersions` operation.
    ///
    /// See [`ListTrafficPolicyVersions`](crate::client::fluent_builders::ListTrafficPolicyVersions) for more information about the
    /// operation and its arguments.
    pub fn list_traffic_policy_versions(
        &self,
    ) -> fluent_builders::ListTrafficPolicyVersions<C, M, R> {
        fluent_builders::ListTrafficPolicyVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListVPCAssociationAuthorizations` operation.
    ///
    /// See [`ListVPCAssociationAuthorizations`](crate::client::fluent_builders::ListVPCAssociationAuthorizations) for more information about the
    /// operation and its arguments.
    pub fn list_vpc_association_authorizations(
        &self,
    ) -> fluent_builders::ListVPCAssociationAuthorizations<C, M, R> {
        fluent_builders::ListVPCAssociationAuthorizations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TestDNSAnswer` operation.
    ///
    /// See [`TestDNSAnswer`](crate::client::fluent_builders::TestDNSAnswer) for more information about the
    /// operation and its arguments.
    pub fn test_dns_answer(&self) -> fluent_builders::TestDNSAnswer<C, M, R> {
        fluent_builders::TestDNSAnswer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateHealthCheck` operation.
    ///
    /// See [`UpdateHealthCheck`](crate::client::fluent_builders::UpdateHealthCheck) for more information about the
    /// operation and its arguments.
    pub fn update_health_check(&self) -> fluent_builders::UpdateHealthCheck<C, M, R> {
        fluent_builders::UpdateHealthCheck::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateHostedZoneComment` operation.
    ///
    /// See [`UpdateHostedZoneComment`](crate::client::fluent_builders::UpdateHostedZoneComment) for more information about the
    /// operation and its arguments.
    pub fn update_hosted_zone_comment(&self) -> fluent_builders::UpdateHostedZoneComment<C, M, R> {
        fluent_builders::UpdateHostedZoneComment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateTrafficPolicyComment` operation.
    ///
    /// See [`UpdateTrafficPolicyComment`](crate::client::fluent_builders::UpdateTrafficPolicyComment) for more information about the
    /// operation and its arguments.
    pub fn update_traffic_policy_comment(
        &self,
    ) -> fluent_builders::UpdateTrafficPolicyComment<C, M, R> {
        fluent_builders::UpdateTrafficPolicyComment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateTrafficPolicyInstance` operation.
    ///
    /// See [`UpdateTrafficPolicyInstance`](crate::client::fluent_builders::UpdateTrafficPolicyInstance) for more information about the
    /// operation and its arguments.
    pub fn update_traffic_policy_instance(
        &self,
    ) -> fluent_builders::UpdateTrafficPolicyInstance<C, M, R> {
        fluent_builders::UpdateTrafficPolicyInstance::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `ActivateKeySigningKey`.
    ///
    /// <p>Activates a key-signing key (KSK) so that it can be used for signing by DNSSEC. This operation changes the KSK status to <code>ACTIVE</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ActivateKeySigningKey<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::activate_key_signing_key_input::Builder,
    }
    impl<C, M, R> ActivateKeySigningKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ActivateKeySigningKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ActivateKeySigningKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::ActivateKeySigningKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ActivateKeySigningKeyInputOperationOutputAlias,
                crate::output::ActivateKeySigningKeyOutput,
                crate::error::ActivateKeySigningKeyError,
                crate::input::ActivateKeySigningKeyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique string used to identify a hosted zone.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>A unique string used to identify a hosted zone.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
        /// <p>A string used to identify a key-signing key (KSK). <code>Name</code> can include numbers, letters, and underscores (_). <code>Name</code> must be unique for each key-signing key in the same hosted zone.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A string used to identify a key-signing key (KSK). <code>Name</code> can include numbers, letters, and underscores (_). <code>Name</code> must be unique for each key-signing key in the same hosted zone.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateVPCWithHostedZone`.
    ///
    /// <p>Associates an Amazon VPC with a private hosted zone. </p> <important>
    /// <p>To perform the association, the VPC and the private hosted zone must already exist. You can't convert a public hosted zone into a private hosted zone.</p>
    /// </important> <note>
    /// <p>If you want to associate a VPC that was created by using one Amazon Web Services account with a private hosted zone that was created by using a different account, the Amazon Web Services account that created the private hosted zone must first submit a <code>CreateVPCAssociationAuthorization</code> request. Then the account that created the VPC must submit an <code>AssociateVPCWithHostedZone</code> request.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateVPCWithHostedZone<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_vpc_with_hosted_zone_input::Builder,
    }
    impl<C, M, R> AssociateVPCWithHostedZone<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateVPCWithHostedZone`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateVpcWithHostedZoneOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateVPCWithHostedZoneError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateVpcWithHostedZoneInputOperationOutputAlias,
                crate::output::AssociateVpcWithHostedZoneOutput,
                crate::error::AssociateVPCWithHostedZoneError,
                crate::input::AssociateVpcWithHostedZoneInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the private hosted zone that you want to associate an Amazon VPC with.</p>
        /// <p>Note that you can't associate a VPC with a hosted zone that doesn't have an existing VPC association.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>The ID of the private hosted zone that you want to associate an Amazon VPC with.</p>
        /// <p>Note that you can't associate a VPC with a hosted zone that doesn't have an existing VPC association.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
        /// <p>A complex type that contains information about the VPC that you want to associate with a private hosted zone.</p>
        pub fn vpc(mut self, input: crate::model::Vpc) -> Self {
            self.inner = self.inner.vpc(input);
            self
        }
        /// <p>A complex type that contains information about the VPC that you want to associate with a private hosted zone.</p>
        pub fn set_vpc(mut self, input: std::option::Option<crate::model::Vpc>) -> Self {
            self.inner = self.inner.set_vpc(input);
            self
        }
        /// <p> <i>Optional:</i> A comment about the association request.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.comment(input.into());
            self
        }
        /// <p> <i>Optional:</i> A comment about the association request.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_comment(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ChangeResourceRecordSets`.
    ///
    /// <p>Creates, changes, or deletes a resource record set, which contains authoritative DNS information for a specified domain name or subdomain name. For example, you can use <code>ChangeResourceRecordSets</code> to create a resource record set that routes traffic for test.example.com to a web server that has an IP address of 192.0.2.44.</p>
    /// <p> <b>Deleting Resource Record Sets</b> </p>
    /// <p>To delete a resource record set, you must specify all the same values that you specified when you created it.</p>
    /// <p> <b>Change Batches and Transactional Changes</b> </p>
    /// <p>The request body must include a document with a <code>ChangeResourceRecordSetsRequest</code> element. The request body contains a list of change items, known as a change batch. Change batches are considered transactional changes. Route 53 validates the changes in the request and then either makes all or none of the changes in the change batch request. This ensures that DNS routing isn't adversely affected by partial changes to the resource record sets in a hosted zone. </p>
    /// <p>For example, suppose a change batch request contains two changes: it deletes the <code>CNAME</code> resource record set for www.example.com and creates an alias resource record set for www.example.com. If validation for both records succeeds, Route 53 deletes the first resource record set and creates the second resource record set in a single operation. If validation for either the <code>DELETE</code> or the <code>CREATE</code> action fails, then the request is canceled, and the original <code>CNAME</code> record continues to exist.</p> <note>
    /// <p>If you try to delete the same resource record set more than once in a single change batch, Route 53 returns an <code>InvalidChangeBatch</code> error.</p>
    /// </note>
    /// <p> <b>Traffic Flow</b> </p>
    /// <p>To create resource record sets for complex routing configurations, use either the traffic flow visual editor in the Route 53 console or the API actions for traffic policies and traffic policy instances. Save the configuration as a traffic policy, then associate the traffic policy with one or more domain names (such as example.com) or subdomain names (such as www.example.com), in the same hosted zone or in multiple hosted zones. You can roll back the updates if the new configuration isn't performing as expected. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/traffic-flow.html">Using Traffic Flow to Route DNS Traffic</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
    /// <p> <b>Create, Delete, and Upsert</b> </p>
    /// <p>Use <code>ChangeResourceRecordsSetsRequest</code> to perform the following actions:</p>
    /// <ul>
    /// <li> <p> <code>CREATE</code>: Creates a resource record set that has the specified values.</p> </li>
    /// <li> <p> <code>DELETE</code>: Deletes an existing resource record set that has the specified values.</p> </li>
    /// <li> <p> <code>UPSERT</code>: If a resource record set does not already exist, Amazon Web Services creates it. If a resource set does exist, Route 53 updates it with the values in the request. </p> </li>
    /// </ul>
    /// <p> <b>Syntaxes for Creating, Updating, and Deleting Resource Record Sets</b> </p>
    /// <p>The syntax for a request depends on the type of resource record set that you want to create, delete, or update, such as weighted, alias, or failover. The XML elements in your request must appear in the order listed in the syntax. </p>
    /// <p>For an example for each type of resource record set, see "Examples."</p>
    /// <p>Don't refer to the syntax in the "Parameter Syntax" section, which includes all of the elements for every kind of resource record set that you can create, delete, or update by using <code>ChangeResourceRecordSets</code>. </p>
    /// <p> <b>Change Propagation to Route 53 DNS Servers</b> </p>
    /// <p>When you submit a <code>ChangeResourceRecordSets</code> request, Route 53 propagates your changes to all of the Route 53 authoritative DNS servers. While your changes are propagating, <code>GetChange</code> returns a status of <code>PENDING</code>. When propagation is complete, <code>GetChange</code> returns a status of <code>INSYNC</code>. Changes generally propagate to all Route 53 name servers within 60 seconds. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetChange.html">GetChange</a>.</p>
    /// <p> <b>Limits on ChangeResourceRecordSets Requests</b> </p>
    /// <p>For information about the limits on a <code>ChangeResourceRecordSets</code> request, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ChangeResourceRecordSets<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::change_resource_record_sets_input::Builder,
    }
    impl<C, M, R> ChangeResourceRecordSets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ChangeResourceRecordSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ChangeResourceRecordSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ChangeResourceRecordSetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ChangeResourceRecordSetsInputOperationOutputAlias,
                crate::output::ChangeResourceRecordSetsOutput,
                crate::error::ChangeResourceRecordSetsError,
                crate::input::ChangeResourceRecordSetsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the hosted zone that contains the resource record sets that you want to change.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>The ID of the hosted zone that contains the resource record sets that you want to change.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
        /// <p>A complex type that contains an optional comment and the <code>Changes</code> element.</p>
        pub fn change_batch(mut self, input: crate::model::ChangeBatch) -> Self {
            self.inner = self.inner.change_batch(input);
            self
        }
        /// <p>A complex type that contains an optional comment and the <code>Changes</code> element.</p>
        pub fn set_change_batch(
            mut self,
            input: std::option::Option<crate::model::ChangeBatch>,
        ) -> Self {
            self.inner = self.inner.set_change_batch(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ChangeTagsForResource`.
    ///
    /// <p>Adds, edits, or deletes tags for a health check or a hosted zone.</p>
    /// <p>For information about using tags for cost allocation, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the <i>Billing and Cost Management User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ChangeTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::change_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ChangeTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ChangeTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ChangeTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ChangeTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ChangeTagsForResourceInputOperationOutputAlias,
                crate::output::ChangeTagsForResourceOutput,
                crate::error::ChangeTagsForResourceError,
                crate::input::ChangeTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The type of the resource.</p>
        /// <ul>
        /// <li> <p>The resource type for health checks is <code>healthcheck</code>.</p> </li>
        /// <li> <p>The resource type for hosted zones is <code>hostedzone</code>.</p> </li>
        /// </ul>
        pub fn resource_type(mut self, input: crate::model::TagResourceType) -> Self {
            self.inner = self.inner.resource_type(input);
            self
        }
        /// <p>The type of the resource.</p>
        /// <ul>
        /// <li> <p>The resource type for health checks is <code>healthcheck</code>.</p> </li>
        /// <li> <p>The resource type for hosted zones is <code>hostedzone</code>.</p> </li>
        /// </ul>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::TagResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The ID of the resource for which you want to add, change, or delete tags.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The ID of the resource for which you want to add, change, or delete tags.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// Appends an item to `AddTags`.
        ///
        /// To override the contents of this collection use [`set_add_tags`](Self::set_add_tags).
        ///
        /// <p>A complex type that contains a list of the tags that you want to add to the specified health check or hosted zone and/or the tags that you want to edit <code>Value</code> for.</p>
        /// <p>You can add a maximum of 10 tags to a health check or a hosted zone.</p>
        pub fn add_tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.add_tags(input);
            self
        }
        /// <p>A complex type that contains a list of the tags that you want to add to the specified health check or hosted zone and/or the tags that you want to edit <code>Value</code> for.</p>
        /// <p>You can add a maximum of 10 tags to a health check or a hosted zone.</p>
        pub fn set_add_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_add_tags(input);
            self
        }
        /// Appends an item to `RemoveTagKeys`.
        ///
        /// To override the contents of this collection use [`set_remove_tag_keys`](Self::set_remove_tag_keys).
        ///
        /// <p>A complex type that contains a list of the tags that you want to delete from the specified health check or hosted zone. You can specify up to 10 keys.</p>
        pub fn remove_tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.remove_tag_keys(input.into());
            self
        }
        /// <p>A complex type that contains a list of the tags that you want to delete from the specified health check or hosted zone. You can specify up to 10 keys.</p>
        pub fn set_remove_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_remove_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateHealthCheck`.
    ///
    /// <p>Creates a new health check.</p>
    /// <p>For information about adding health checks to resource record sets, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ResourceRecordSet.html#Route53-Type-ResourceRecordSet-HealthCheckId">HealthCheckId</a> in <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ChangeResourceRecordSets.html">ChangeResourceRecordSets</a>. </p>
    /// <p> <b>ELB Load Balancers</b> </p>
    /// <p>If you're registering EC2 instances with an Elastic Load Balancing (ELB) load balancer, do not create Amazon Route 53 health checks for the EC2 instances. When you register an EC2 instance with a load balancer, you configure settings for an ELB health check, which performs a similar function to a Route 53 health check.</p>
    /// <p> <b>Private Hosted Zones</b> </p>
    /// <p>You can associate health checks with failover resource record sets in a private hosted zone. Note the following:</p>
    /// <ul>
    /// <li> <p>Route 53 health checkers are outside the VPC. To check the health of an endpoint within a VPC by IP address, you must assign a public IP address to the instance in the VPC.</p> </li>
    /// <li> <p>You can configure a health checker to check the health of an external resource that the instance relies on, such as a database server.</p> </li>
    /// <li> <p>You can create a CloudWatch metric, associate an alarm with the metric, and then create a health check that is based on the state of the alarm. For example, you might create a CloudWatch metric that checks the status of the Amazon EC2 <code>StatusCheckFailed</code> metric, add an alarm to the metric, and then create a health check that is based on the state of the alarm. For information about creating CloudWatch metrics and alarms by using the CloudWatch console, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/WhatIsCloudWatch.html">Amazon CloudWatch User Guide</a>.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateHealthCheck<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_health_check_input::Builder,
    }
    impl<C, M, R> CreateHealthCheck<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateHealthCheck`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateHealthCheckOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateHealthCheckError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateHealthCheckInputOperationOutputAlias,
                crate::output::CreateHealthCheckOutput,
                crate::error::CreateHealthCheckError,
                crate::input::CreateHealthCheckInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique string that identifies the request and that allows you to retry a failed <code>CreateHealthCheck</code> request without the risk of creating two identical health checks:</p>
        /// <ul>
        /// <li> <p>If you send a <code>CreateHealthCheck</code> request with the same <code>CallerReference</code> and settings as a previous request, and if the health check doesn't exist, Amazon Route 53 creates the health check. If the health check does exist, Route 53 returns the settings for the existing health check.</p> </li>
        /// <li> <p>If you send a <code>CreateHealthCheck</code> request with the same <code>CallerReference</code> as a deleted health check, regardless of the settings, Route 53 returns a <code>HealthCheckAlreadyExists</code> error.</p> </li>
        /// <li> <p>If you send a <code>CreateHealthCheck</code> request with the same <code>CallerReference</code> as an existing health check but with different settings, Route 53 returns a <code>HealthCheckAlreadyExists</code> error.</p> </li>
        /// <li> <p>If you send a <code>CreateHealthCheck</code> request with a unique <code>CallerReference</code> but settings identical to an existing health check, Route 53 creates the health check.</p> </li>
        /// </ul>
        pub fn caller_reference(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.caller_reference(input.into());
            self
        }
        /// <p>A unique string that identifies the request and that allows you to retry a failed <code>CreateHealthCheck</code> request without the risk of creating two identical health checks:</p>
        /// <ul>
        /// <li> <p>If you send a <code>CreateHealthCheck</code> request with the same <code>CallerReference</code> and settings as a previous request, and if the health check doesn't exist, Amazon Route 53 creates the health check. If the health check does exist, Route 53 returns the settings for the existing health check.</p> </li>
        /// <li> <p>If you send a <code>CreateHealthCheck</code> request with the same <code>CallerReference</code> as a deleted health check, regardless of the settings, Route 53 returns a <code>HealthCheckAlreadyExists</code> error.</p> </li>
        /// <li> <p>If you send a <code>CreateHealthCheck</code> request with the same <code>CallerReference</code> as an existing health check but with different settings, Route 53 returns a <code>HealthCheckAlreadyExists</code> error.</p> </li>
        /// <li> <p>If you send a <code>CreateHealthCheck</code> request with a unique <code>CallerReference</code> but settings identical to an existing health check, Route 53 creates the health check.</p> </li>
        /// </ul>
        pub fn set_caller_reference(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_caller_reference(input);
            self
        }
        /// <p>A complex type that contains settings for a new health check.</p>
        pub fn health_check_config(mut self, input: crate::model::HealthCheckConfig) -> Self {
            self.inner = self.inner.health_check_config(input);
            self
        }
        /// <p>A complex type that contains settings for a new health check.</p>
        pub fn set_health_check_config(
            mut self,
            input: std::option::Option<crate::model::HealthCheckConfig>,
        ) -> Self {
            self.inner = self.inner.set_health_check_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateHostedZone`.
    ///
    /// <p>Creates a new public or private hosted zone. You create records in a public hosted zone to define how you want to route traffic on the internet for a domain, such as example.com, and its subdomains (apex.example.com, acme.example.com). You create records in a private hosted zone to define how you want to route traffic for a domain and its subdomains within one or more Amazon Virtual Private Clouds (Amazon VPCs). </p> <important>
    /// <p>You can't convert a public hosted zone to a private hosted zone or vice versa. Instead, you must create a new hosted zone with the same name and create new resource record sets.</p>
    /// </important>
    /// <p>For more information about charges for hosted zones, see <a href="http://aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a>.</p>
    /// <p>Note the following:</p>
    /// <ul>
    /// <li> <p>You can't create a hosted zone for a top-level domain (TLD) such as .com.</p> </li>
    /// <li> <p>For public hosted zones, Route 53 automatically creates a default SOA record and four NS records for the zone. For more information about SOA and NS records, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/SOA-NSrecords.html">NS and SOA Records that Route 53 Creates for a Hosted Zone</a> in the <i>Amazon Route 53 Developer Guide</i>.</p> <p>If you want to use the same name servers for multiple public hosted zones, you can optionally associate a reusable delegation set with the hosted zone. See the <code>DelegationSetId</code> element.</p> </li>
    /// <li> <p>If your domain is registered with a registrar other than Route 53, you must update the name servers with your registrar to make Route 53 the DNS service for the domain. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/MigratingDNS.html">Migrating DNS Service for an Existing Domain to Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>. </p> </li>
    /// </ul>
    /// <p>When you submit a <code>CreateHostedZone</code> request, the initial status of the hosted zone is <code>PENDING</code>. For public hosted zones, this means that the NS and SOA records are not yet available on all Route 53 DNS servers. When the NS and SOA records are available, the status of the zone changes to <code>INSYNC</code>.</p>
    /// <p>The <code>CreateHostedZone</code> request requires the caller to have an <code>ec2:DescribeVpcs</code> permission.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateHostedZone<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_hosted_zone_input::Builder,
    }
    impl<C, M, R> CreateHostedZone<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateHostedZone`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateHostedZoneOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateHostedZoneError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateHostedZoneInputOperationOutputAlias,
                crate::output::CreateHostedZoneOutput,
                crate::error::CreateHostedZoneError,
                crate::input::CreateHostedZoneInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain. Specify a fully qualified domain name, for example, <i>www.example.com</i>. The trailing dot is optional; Amazon Route 53 assumes that the domain name is fully qualified. This means that Route 53 treats <i>www.example.com</i> (without a trailing dot) and <i>www.example.com.</i> (with a trailing dot) as identical.</p>
        /// <p>If you're creating a public hosted zone, this is the name you have registered with your DNS registrar. If your domain name is registered with a registrar other than Route 53, change the name servers for your domain to the set of <code>NameServers</code> that <code>CreateHostedZone</code> returns in <code>DelegationSet</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the domain. Specify a fully qualified domain name, for example, <i>www.example.com</i>. The trailing dot is optional; Amazon Route 53 assumes that the domain name is fully qualified. This means that Route 53 treats <i>www.example.com</i> (without a trailing dot) and <i>www.example.com.</i> (with a trailing dot) as identical.</p>
        /// <p>If you're creating a public hosted zone, this is the name you have registered with your DNS registrar. If your domain name is registered with a registrar other than Route 53, change the name servers for your domain to the set of <code>NameServers</code> that <code>CreateHostedZone</code> returns in <code>DelegationSet</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>(Private hosted zones only) A complex type that contains information about the Amazon VPC that you're associating with this hosted zone.</p>
        /// <p>You can specify only one Amazon VPC when you create a private hosted zone. If you are associating a VPC with a hosted zone with this request, the paramaters <code>VPCId</code> and <code>VPCRegion</code> are also required.</p>
        /// <p>To associate additional Amazon VPCs with the hosted zone, use <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_AssociateVPCWithHostedZone.html">AssociateVPCWithHostedZone</a> after you create a hosted zone.</p>
        pub fn vpc(mut self, input: crate::model::Vpc) -> Self {
            self.inner = self.inner.vpc(input);
            self
        }
        /// <p>(Private hosted zones only) A complex type that contains information about the Amazon VPC that you're associating with this hosted zone.</p>
        /// <p>You can specify only one Amazon VPC when you create a private hosted zone. If you are associating a VPC with a hosted zone with this request, the paramaters <code>VPCId</code> and <code>VPCRegion</code> are also required.</p>
        /// <p>To associate additional Amazon VPCs with the hosted zone, use <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_AssociateVPCWithHostedZone.html">AssociateVPCWithHostedZone</a> after you create a hosted zone.</p>
        pub fn set_vpc(mut self, input: std::option::Option<crate::model::Vpc>) -> Self {
            self.inner = self.inner.set_vpc(input);
            self
        }
        /// <p>A unique string that identifies the request and that allows failed <code>CreateHostedZone</code> requests to be retried without the risk of executing the operation twice. You must use a unique <code>CallerReference</code> string every time you submit a <code>CreateHostedZone</code> request. <code>CallerReference</code> can be any unique string, for example, a date/time stamp.</p>
        pub fn caller_reference(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.caller_reference(input.into());
            self
        }
        /// <p>A unique string that identifies the request and that allows failed <code>CreateHostedZone</code> requests to be retried without the risk of executing the operation twice. You must use a unique <code>CallerReference</code> string every time you submit a <code>CreateHostedZone</code> request. <code>CallerReference</code> can be any unique string, for example, a date/time stamp.</p>
        pub fn set_caller_reference(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_caller_reference(input);
            self
        }
        /// <p>(Optional) A complex type that contains the following optional values:</p>
        /// <ul>
        /// <li> <p>For public and private hosted zones, an optional comment</p> </li>
        /// <li> <p>For private hosted zones, an optional <code>PrivateZone</code> element</p> </li>
        /// </ul>
        /// <p>If you don't specify a comment or the <code>PrivateZone</code> element, omit <code>HostedZoneConfig</code> and the other elements.</p>
        pub fn hosted_zone_config(mut self, input: crate::model::HostedZoneConfig) -> Self {
            self.inner = self.inner.hosted_zone_config(input);
            self
        }
        /// <p>(Optional) A complex type that contains the following optional values:</p>
        /// <ul>
        /// <li> <p>For public and private hosted zones, an optional comment</p> </li>
        /// <li> <p>For private hosted zones, an optional <code>PrivateZone</code> element</p> </li>
        /// </ul>
        /// <p>If you don't specify a comment or the <code>PrivateZone</code> element, omit <code>HostedZoneConfig</code> and the other elements.</p>
        pub fn set_hosted_zone_config(
            mut self,
            input: std::option::Option<crate::model::HostedZoneConfig>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_config(input);
            self
        }
        /// <p>If you want to associate a reusable delegation set with this hosted zone, the ID that Amazon Route 53 assigned to the reusable delegation set when you created it. For more information about reusable delegation sets, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateReusableDelegationSet.html">CreateReusableDelegationSet</a>.</p>
        pub fn delegation_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.delegation_set_id(input.into());
            self
        }
        /// <p>If you want to associate a reusable delegation set with this hosted zone, the ID that Amazon Route 53 assigned to the reusable delegation set when you created it. For more information about reusable delegation sets, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateReusableDelegationSet.html">CreateReusableDelegationSet</a>.</p>
        pub fn set_delegation_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_delegation_set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateKeySigningKey`.
    ///
    /// <p>Creates a new key-signing key (KSK) associated with a hosted zone. You can only have two KSKs per hosted zone.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateKeySigningKey<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_key_signing_key_input::Builder,
    }
    impl<C, M, R> CreateKeySigningKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateKeySigningKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateKeySigningKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateKeySigningKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateKeySigningKeyInputOperationOutputAlias,
                crate::output::CreateKeySigningKeyOutput,
                crate::error::CreateKeySigningKeyError,
                crate::input::CreateKeySigningKeyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique string that identifies the request.</p>
        pub fn caller_reference(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.caller_reference(input.into());
            self
        }
        /// <p>A unique string that identifies the request.</p>
        pub fn set_caller_reference(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_caller_reference(input);
            self
        }
        /// <p>The unique string (ID) used to identify a hosted zone.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>The unique string (ID) used to identify a hosted zone.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
        /// <p>The Amazon resource name (ARN) for a customer managed key in Key Management Service (KMS). The <code>KeyManagementServiceArn</code> must be unique for each key-signing key (KSK) in a single hosted zone. To see an example of <code>KeyManagementServiceArn</code> that grants the correct permissions for DNSSEC, scroll down to <b>Example</b>. </p>
        /// <p>You must configure the customer managed customer managed key as follows:</p>
        /// <dl>
        /// <dt>
        /// Status
        /// </dt>
        /// <dd>
        /// <p>Enabled</p>
        /// </dd>
        /// <dt>
        /// Key spec
        /// </dt>
        /// <dd>
        /// <p>ECC_NIST_P256</p>
        /// </dd>
        /// <dt>
        /// Key usage
        /// </dt>
        /// <dd>
        /// <p>Sign and verify</p>
        /// </dd>
        /// <dt>
        /// Key policy
        /// </dt>
        /// <dd>
        /// <p>The key policy must give permission for the following actions:</p>
        /// <ul>
        /// <li> <p>DescribeKey</p> </li>
        /// <li> <p>GetPublicKey</p> </li>
        /// <li> <p>Sign</p> </li>
        /// </ul>
        /// <p>The key policy must also include the Amazon Route 53 service in the principal for your account. Specify the following:</p>
        /// <ul>
        /// <li> <p> <code>"Service": "dnssec-route53.amazonaws.com"</code> </p> </li>
        /// </ul>
        /// </dd>
        /// </dl>
        /// <p>For more information about working with a customer managed key in KMS, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html">Key Management Service concepts</a>.</p>
        pub fn key_management_service_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_management_service_arn(input.into());
            self
        }
        /// <p>The Amazon resource name (ARN) for a customer managed key in Key Management Service (KMS). The <code>KeyManagementServiceArn</code> must be unique for each key-signing key (KSK) in a single hosted zone. To see an example of <code>KeyManagementServiceArn</code> that grants the correct permissions for DNSSEC, scroll down to <b>Example</b>. </p>
        /// <p>You must configure the customer managed customer managed key as follows:</p>
        /// <dl>
        /// <dt>
        /// Status
        /// </dt>
        /// <dd>
        /// <p>Enabled</p>
        /// </dd>
        /// <dt>
        /// Key spec
        /// </dt>
        /// <dd>
        /// <p>ECC_NIST_P256</p>
        /// </dd>
        /// <dt>
        /// Key usage
        /// </dt>
        /// <dd>
        /// <p>Sign and verify</p>
        /// </dd>
        /// <dt>
        /// Key policy
        /// </dt>
        /// <dd>
        /// <p>The key policy must give permission for the following actions:</p>
        /// <ul>
        /// <li> <p>DescribeKey</p> </li>
        /// <li> <p>GetPublicKey</p> </li>
        /// <li> <p>Sign</p> </li>
        /// </ul>
        /// <p>The key policy must also include the Amazon Route 53 service in the principal for your account. Specify the following:</p>
        /// <ul>
        /// <li> <p> <code>"Service": "dnssec-route53.amazonaws.com"</code> </p> </li>
        /// </ul>
        /// </dd>
        /// </dl>
        /// <p>For more information about working with a customer managed key in KMS, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html">Key Management Service concepts</a>.</p>
        pub fn set_key_management_service_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_key_management_service_arn(input);
            self
        }
        /// <p>A string used to identify a key-signing key (KSK). <code>Name</code> can include numbers, letters, and underscores (_). <code>Name</code> must be unique for each key-signing key in the same hosted zone.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A string used to identify a key-signing key (KSK). <code>Name</code> can include numbers, letters, and underscores (_). <code>Name</code> must be unique for each key-signing key in the same hosted zone.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A string specifying the initial status of the key-signing key (KSK). You can set the value to <code>ACTIVE</code> or <code>INACTIVE</code>.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.status(input.into());
            self
        }
        /// <p>A string specifying the initial status of the key-signing key (KSK). You can set the value to <code>ACTIVE</code> or <code>INACTIVE</code>.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateQueryLoggingConfig`.
    ///
    /// <p>Creates a configuration for DNS query logging. After you create a query logging configuration, Amazon Route 53 begins to publish log data to an Amazon CloudWatch Logs log group.</p>
    /// <p>DNS query logs contain information about the queries that Route 53 receives for a specified public hosted zone, such as the following:</p>
    /// <ul>
    /// <li> <p>Route 53 edge location that responded to the DNS query</p> </li>
    /// <li> <p>Domain or subdomain that was requested</p> </li>
    /// <li> <p>DNS record type, such as A or AAAA</p> </li>
    /// <li> <p>DNS response code, such as <code>NoError</code> or <code>ServFail</code> </p> </li>
    /// </ul>
    /// <dl>
    /// <dt>
    /// Log Group and Resource Policy
    /// </dt>
    /// <dd>
    /// <p>Before you create a query logging configuration, perform the following operations.</p> <note>
    /// <p>If you create a query logging configuration using the Route 53 console, Route 53 performs these operations automatically.</p>
    /// </note>
    /// <ol>
    /// <li> <p>Create a CloudWatch Logs log group, and make note of the ARN, which you specify when you create a query logging configuration. Note the following:</p>
    /// <ul>
    /// <li> <p>You must create the log group in the us-east-1 region.</p> </li>
    /// <li> <p>You must use the same Amazon Web Services account to create the log group and the hosted zone that you want to configure query logging for.</p> </li>
    /// <li> <p>When you create log groups for query logging, we recommend that you use a consistent prefix, for example:</p> <p> <code>/aws/route53/<i>hosted zone name</i> </code> </p> <p>In the next step, you'll create a resource policy, which controls access to one or more log groups and the associated Amazon Web Services resources, such as Route 53 hosted zones. There's a limit on the number of resource policies that you can create, so we recommend that you use a consistent prefix so you can use the same resource policy for all the log groups that you create for query logging.</p> </li>
    /// </ul> </li>
    /// <li> <p>Create a CloudWatch Logs resource policy, and give it the permissions that Route 53 needs to create log streams and to send query logs to log streams. For the value of <code>Resource</code>, specify the ARN for the log group that you created in the previous step. To use the same resource policy for all the CloudWatch Logs log groups that you created for query logging configurations, replace the hosted zone name with <code>*</code>, for example:</p> <p> <code>arn:aws:logs:us-east-1:123412341234:log-group:/aws/route53/*</code> </p> <note>
    /// <p>You can't use the CloudWatch console to create or edit a resource policy. You must use the CloudWatch API, one of the Amazon Web Services SDKs, or the CLI.</p>
    /// </note> </li>
    /// </ol>
    /// </dd>
    /// <dt>
    /// Log Streams and Edge Locations
    /// </dt>
    /// <dd>
    /// <p>When Route 53 finishes creating the configuration for DNS query logging, it does the following:</p>
    /// <ul>
    /// <li> <p>Creates a log stream for an edge location the first time that the edge location responds to DNS queries for the specified hosted zone. That log stream is used to log all queries that Route 53 responds to for that edge location.</p> </li>
    /// <li> <p>Begins to send query logs to the applicable log stream.</p> </li>
    /// </ul>
    /// <p>The name of each log stream is in the following format:</p>
    /// <p> <code> <i>hosted zone ID</i>/<i>edge location code</i> </code> </p>
    /// <p>The edge location code is a three-letter code and an arbitrarily assigned number, for example, DFW3. The three-letter code typically corresponds with the International Air Transport Association airport code for an airport near the edge location. (These abbreviations might change in the future.) For a list of edge locations, see "The Route 53 Global Network" on the <a href="http://aws.amazon.com/route53/details/">Route 53 Product Details</a> page.</p>
    /// </dd>
    /// <dt>
    /// Queries That Are Logged
    /// </dt>
    /// <dd>
    /// <p>Query logs contain only the queries that DNS resolvers forward to Route 53. If a DNS resolver has already cached the response to a query (such as the IP address for a load balancer for example.com), the resolver will continue to return the cached response. It doesn't forward another query to Route 53 until the TTL for the corresponding resource record set expires. Depending on how many DNS queries are submitted for a resource record set, and depending on the TTL for that resource record set, query logs might contain information about only one query out of every several thousand queries that are submitted to DNS. For more information about how DNS works, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/welcome-dns-service.html">Routing Internet Traffic to Your Website or Web Application</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
    /// </dd>
    /// <dt>
    /// Log File Format
    /// </dt>
    /// <dd>
    /// <p>For a list of the values in each query log and the format of each value, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html">Logging DNS Queries</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
    /// </dd>
    /// <dt>
    /// Pricing
    /// </dt>
    /// <dd>
    /// <p>For information about charges for query logs, see <a href="http://aws.amazon.com/cloudwatch/pricing/">Amazon CloudWatch Pricing</a>.</p>
    /// </dd>
    /// <dt>
    /// How to Stop Logging
    /// </dt>
    /// <dd>
    /// <p>If you want Route 53 to stop sending query logs to CloudWatch Logs, delete the query logging configuration. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteQueryLoggingConfig.html">DeleteQueryLoggingConfig</a>.</p>
    /// </dd>
    /// </dl>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateQueryLoggingConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_query_logging_config_input::Builder,
    }
    impl<C, M, R> CreateQueryLoggingConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateQueryLoggingConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateQueryLoggingConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateQueryLoggingConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateQueryLoggingConfigInputOperationOutputAlias,
                crate::output::CreateQueryLoggingConfigOutput,
                crate::error::CreateQueryLoggingConfigError,
                crate::input::CreateQueryLoggingConfigInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the hosted zone that you want to log queries for. You can log queries only for public hosted zones.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>The ID of the hosted zone that you want to log queries for. You can log queries only for public hosted zones.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the log group that you want to Amazon Route 53 to send query logs to. This is the format of the ARN:</p>
        /// <p>arn:aws:logs:<i>region</i>:<i>account-id</i>:log-group:<i>log_group_name</i> </p>
        /// <p>To get the ARN for a log group, you can use the CloudWatch console, the <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeLogGroups.html">DescribeLogGroups</a> API action, the <a href="https://docs.aws.amazon.com/cli/latest/reference/logs/describe-log-groups.html">describe-log-groups</a> command, or the applicable command in one of the Amazon Web Services SDKs.</p>
        pub fn cloud_watch_logs_log_group_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.cloud_watch_logs_log_group_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the log group that you want to Amazon Route 53 to send query logs to. This is the format of the ARN:</p>
        /// <p>arn:aws:logs:<i>region</i>:<i>account-id</i>:log-group:<i>log_group_name</i> </p>
        /// <p>To get the ARN for a log group, you can use the CloudWatch console, the <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeLogGroups.html">DescribeLogGroups</a> API action, the <a href="https://docs.aws.amazon.com/cli/latest/reference/logs/describe-log-groups.html">describe-log-groups</a> command, or the applicable command in one of the Amazon Web Services SDKs.</p>
        pub fn set_cloud_watch_logs_log_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cloud_watch_logs_log_group_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateReusableDelegationSet`.
    ///
    /// <p>Creates a delegation set (a group of four name servers) that can be reused by multiple hosted zones that were created by the same Amazon Web Services account. </p>
    /// <p>You can also create a reusable delegation set that uses the four name servers that are associated with an existing hosted zone. Specify the hosted zone ID in the <code>CreateReusableDelegationSet</code> request.</p> <note>
    /// <p>You can't associate a reusable delegation set with a private hosted zone.</p>
    /// </note>
    /// <p>For information about using a reusable delegation set to configure white label name servers, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/white-label-name-servers.html">Configuring White Label Name Servers</a>.</p>
    /// <p>The process for migrating existing hosted zones to use a reusable delegation set is comparable to the process for configuring white label name servers. You need to perform the following steps:</p>
    /// <ol>
    /// <li> <p>Create a reusable delegation set.</p> </li>
    /// <li> <p>Recreate hosted zones, and reduce the TTL to 60 seconds or less.</p> </li>
    /// <li> <p>Recreate resource record sets in the new hosted zones.</p> </li>
    /// <li> <p>Change the registrar's name servers to use the name servers for the new hosted zones.</p> </li>
    /// <li> <p>Monitor traffic for the website or application.</p> </li>
    /// <li> <p>Change TTLs back to their original values.</p> </li>
    /// </ol>
    /// <p>If you want to migrate existing hosted zones to use a reusable delegation set, the existing hosted zones can't use any of the name servers that are assigned to the reusable delegation set. If one or more hosted zones do use one or more name servers that are assigned to the reusable delegation set, you can do one of the following:</p>
    /// <ul>
    /// <li> <p>For small numbers of hosted zones—up to a few hundred—it's relatively easy to create reusable delegation sets until you get one that has four name servers that don't overlap with any of the name servers in your hosted zones.</p> </li>
    /// <li> <p>For larger numbers of hosted zones, the easiest solution is to use more than one reusable delegation set.</p> </li>
    /// <li> <p>For larger numbers of hosted zones, you can also migrate hosted zones that have overlapping name servers to hosted zones that don't have overlapping name servers, then migrate the hosted zones again to use the reusable delegation set.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateReusableDelegationSet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_reusable_delegation_set_input::Builder,
    }
    impl<C, M, R> CreateReusableDelegationSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateReusableDelegationSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateReusableDelegationSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateReusableDelegationSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateReusableDelegationSetInputOperationOutputAlias,
                crate::output::CreateReusableDelegationSetOutput,
                crate::error::CreateReusableDelegationSetError,
                crate::input::CreateReusableDelegationSetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique string that identifies the request, and that allows you to retry failed <code>CreateReusableDelegationSet</code> requests without the risk of executing the operation twice. You must use a unique <code>CallerReference</code> string every time you submit a <code>CreateReusableDelegationSet</code> request. <code>CallerReference</code> can be any unique string, for example a date/time stamp.</p>
        pub fn caller_reference(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.caller_reference(input.into());
            self
        }
        /// <p>A unique string that identifies the request, and that allows you to retry failed <code>CreateReusableDelegationSet</code> requests without the risk of executing the operation twice. You must use a unique <code>CallerReference</code> string every time you submit a <code>CreateReusableDelegationSet</code> request. <code>CallerReference</code> can be any unique string, for example a date/time stamp.</p>
        pub fn set_caller_reference(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_caller_reference(input);
            self
        }
        /// <p>If you want to mark the delegation set for an existing hosted zone as reusable, the ID for that hosted zone.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>If you want to mark the delegation set for an existing hosted zone as reusable, the ID for that hosted zone.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTrafficPolicy`.
    ///
    /// <p>Creates a traffic policy, which you use to create multiple DNS resource record sets for one domain name (such as example.com) or one subdomain name (such as www.example.com).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTrafficPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_traffic_policy_input::Builder,
    }
    impl<C, M, R> CreateTrafficPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTrafficPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTrafficPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTrafficPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTrafficPolicyInputOperationOutputAlias,
                crate::output::CreateTrafficPolicyOutput,
                crate::error::CreateTrafficPolicyError,
                crate::input::CreateTrafficPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the traffic policy.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the traffic policy.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The definition of this traffic policy in JSON format. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/api-policies-traffic-policy-document-format.html">Traffic Policy Document Format</a>.</p>
        pub fn document(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document(input.into());
            self
        }
        /// <p>The definition of this traffic policy in JSON format. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/api-policies-traffic-policy-document-format.html">Traffic Policy Document Format</a>.</p>
        pub fn set_document(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_document(input);
            self
        }
        /// <p>(Optional) Any comments that you want to include about the traffic policy.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.comment(input.into());
            self
        }
        /// <p>(Optional) Any comments that you want to include about the traffic policy.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_comment(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTrafficPolicyInstance`.
    ///
    /// <p>Creates resource record sets in a specified hosted zone based on the settings in a specified traffic policy version. In addition, <code>CreateTrafficPolicyInstance</code> associates the resource record sets with a specified domain name (such as example.com) or subdomain name (such as www.example.com). Amazon Route 53 responds to DNS queries for the domain or subdomain name by using the resource record sets that <code>CreateTrafficPolicyInstance</code> created.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTrafficPolicyInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_traffic_policy_instance_input::Builder,
    }
    impl<C, M, R> CreateTrafficPolicyInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTrafficPolicyInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTrafficPolicyInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTrafficPolicyInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTrafficPolicyInstanceInputOperationOutputAlias,
                crate::output::CreateTrafficPolicyInstanceOutput,
                crate::error::CreateTrafficPolicyInstanceError,
                crate::input::CreateTrafficPolicyInstanceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the hosted zone that you want Amazon Route 53 to create resource record sets in by using the configuration in a traffic policy.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>The ID of the hosted zone that you want Amazon Route 53 to create resource record sets in by using the configuration in a traffic policy.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
        /// <p>The domain name (such as example.com) or subdomain name (such as www.example.com) for which Amazon Route 53 responds to DNS queries by using the resource record sets that Route 53 creates for this traffic policy instance.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The domain name (such as example.com) or subdomain name (such as www.example.com) for which Amazon Route 53 responds to DNS queries by using the resource record sets that Route 53 creates for this traffic policy instance.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>(Optional) The TTL that you want Amazon Route 53 to assign to all of the resource record sets that it creates in the specified hosted zone.</p>
        pub fn ttl(mut self, input: i64) -> Self {
            self.inner = self.inner.ttl(input);
            self
        }
        /// <p>(Optional) The TTL that you want Amazon Route 53 to assign to all of the resource record sets that it creates in the specified hosted zone.</p>
        pub fn set_ttl(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_ttl(input);
            self
        }
        /// <p>The ID of the traffic policy that you want to use to create resource record sets in the specified hosted zone.</p>
        pub fn traffic_policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.traffic_policy_id(input.into());
            self
        }
        /// <p>The ID of the traffic policy that you want to use to create resource record sets in the specified hosted zone.</p>
        pub fn set_traffic_policy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_traffic_policy_id(input);
            self
        }
        /// <p>The version of the traffic policy that you want to use to create resource record sets in the specified hosted zone.</p>
        pub fn traffic_policy_version(mut self, input: i32) -> Self {
            self.inner = self.inner.traffic_policy_version(input);
            self
        }
        /// <p>The version of the traffic policy that you want to use to create resource record sets in the specified hosted zone.</p>
        pub fn set_traffic_policy_version(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_traffic_policy_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTrafficPolicyVersion`.
    ///
    /// <p>Creates a new version of an existing traffic policy. When you create a new version of a traffic policy, you specify the ID of the traffic policy that you want to update and a JSON-formatted document that describes the new version. You use traffic policies to create multiple DNS resource record sets for one domain name (such as example.com) or one subdomain name (such as www.example.com). You can create a maximum of 1000 versions of a traffic policy. If you reach the limit and need to create another version, you'll need to start a new traffic policy.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTrafficPolicyVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_traffic_policy_version_input::Builder,
    }
    impl<C, M, R> CreateTrafficPolicyVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTrafficPolicyVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTrafficPolicyVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTrafficPolicyVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTrafficPolicyVersionInputOperationOutputAlias,
                crate::output::CreateTrafficPolicyVersionOutput,
                crate::error::CreateTrafficPolicyVersionError,
                crate::input::CreateTrafficPolicyVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the traffic policy for which you want to create a new version.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the traffic policy for which you want to create a new version.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The definition of this version of the traffic policy, in JSON format. You specified the JSON in the <code>CreateTrafficPolicyVersion</code> request. For more information about the JSON format, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateTrafficPolicy.html">CreateTrafficPolicy</a>.</p>
        pub fn document(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.document(input.into());
            self
        }
        /// <p>The definition of this version of the traffic policy, in JSON format. You specified the JSON in the <code>CreateTrafficPolicyVersion</code> request. For more information about the JSON format, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateTrafficPolicy.html">CreateTrafficPolicy</a>.</p>
        pub fn set_document(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_document(input);
            self
        }
        /// <p>The comment that you specified in the <code>CreateTrafficPolicyVersion</code> request, if any.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.comment(input.into());
            self
        }
        /// <p>The comment that you specified in the <code>CreateTrafficPolicyVersion</code> request, if any.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_comment(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateVPCAssociationAuthorization`.
    ///
    /// <p>Authorizes the Amazon Web Services account that created a specified VPC to submit an <code>AssociateVPCWithHostedZone</code> request to associate the VPC with a specified hosted zone that was created by a different account. To submit a <code>CreateVPCAssociationAuthorization</code> request, you must use the account that created the hosted zone. After you authorize the association, use the account that created the VPC to submit an <code>AssociateVPCWithHostedZone</code> request.</p> <note>
    /// <p>If you want to associate multiple VPCs that you created by using one account with a hosted zone that you created by using a different account, you must submit one authorization request for each VPC.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateVPCAssociationAuthorization<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_vpc_association_authorization_input::Builder,
    }
    impl<C, M, R> CreateVPCAssociationAuthorization<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateVPCAssociationAuthorization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateVpcAssociationAuthorizationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateVPCAssociationAuthorizationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateVpcAssociationAuthorizationInputOperationOutputAlias,
                crate::output::CreateVpcAssociationAuthorizationOutput,
                crate::error::CreateVPCAssociationAuthorizationError,
                crate::input::CreateVpcAssociationAuthorizationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the private hosted zone that you want to authorize associating a VPC with.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>The ID of the private hosted zone that you want to authorize associating a VPC with.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
        /// <p>A complex type that contains the VPC ID and region for the VPC that you want to authorize associating with your hosted zone.</p>
        pub fn vpc(mut self, input: crate::model::Vpc) -> Self {
            self.inner = self.inner.vpc(input);
            self
        }
        /// <p>A complex type that contains the VPC ID and region for the VPC that you want to authorize associating with your hosted zone.</p>
        pub fn set_vpc(mut self, input: std::option::Option<crate::model::Vpc>) -> Self {
            self.inner = self.inner.set_vpc(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeactivateKeySigningKey`.
    ///
    /// <p>Deactivates a key-signing key (KSK) so that it will not be used for signing by DNSSEC. This operation changes the KSK status to <code>INACTIVE</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeactivateKeySigningKey<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deactivate_key_signing_key_input::Builder,
    }
    impl<C, M, R> DeactivateKeySigningKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeactivateKeySigningKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeactivateKeySigningKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeactivateKeySigningKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeactivateKeySigningKeyInputOperationOutputAlias,
                crate::output::DeactivateKeySigningKeyOutput,
                crate::error::DeactivateKeySigningKeyError,
                crate::input::DeactivateKeySigningKeyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique string used to identify a hosted zone.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>A unique string used to identify a hosted zone.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
        /// <p>A string used to identify a key-signing key (KSK).</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A string used to identify a key-signing key (KSK).</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteHealthCheck`.
    ///
    /// <p>Deletes a health check.</p> <important>
    /// <p>Amazon Route 53 does not prevent you from deleting a health check even if the health check is associated with one or more resource record sets. If you delete a health check and you don't update the associated resource record sets, the future status of the health check can't be predicted and may change. This will affect the routing of DNS queries for your DNS failover configuration. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/health-checks-creating-deleting.html#health-checks-deleting.html">Replacing and Deleting Health Checks</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
    /// </important>
    /// <p>If you're using Cloud Map and you configured Cloud Map to create a Route 53 health check when you register an instance, you can't use the Route 53 <code>DeleteHealthCheck</code> command to delete the health check. The health check is deleted automatically when you deregister the instance; there can be a delay of several hours before the health check is deleted from Route 53. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteHealthCheck<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_health_check_input::Builder,
    }
    impl<C, M, R> DeleteHealthCheck<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteHealthCheck`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteHealthCheckOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteHealthCheckError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteHealthCheckInputOperationOutputAlias,
                crate::output::DeleteHealthCheckOutput,
                crate::error::DeleteHealthCheckError,
                crate::input::DeleteHealthCheckInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the health check that you want to delete.</p>
        pub fn health_check_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.health_check_id(input.into());
            self
        }
        /// <p>The ID of the health check that you want to delete.</p>
        pub fn set_health_check_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_health_check_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteHostedZone`.
    ///
    /// <p>Deletes a hosted zone.</p>
    /// <p>If the hosted zone was created by another service, such as Cloud Map, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DeleteHostedZone.html#delete-public-hosted-zone-created-by-another-service">Deleting Public Hosted Zones That Were Created by Another Service</a> in the <i>Amazon Route 53 Developer Guide</i> for information about how to delete it. (The process is the same for public and private hosted zones that were created by another service.)</p>
    /// <p>If you want to keep your domain registration but you want to stop routing internet traffic to your website or web application, we recommend that you delete resource record sets in the hosted zone instead of deleting the hosted zone.</p> <important>
    /// <p>If you delete a hosted zone, you can't undelete it. You must create a new hosted zone and update the name servers for your domain registration, which can require up to 48 hours to take effect. (If you delegated responsibility for a subdomain to a hosted zone and you delete the child hosted zone, you must update the name servers in the parent hosted zone.) In addition, if you delete a hosted zone, someone could hijack the domain and route traffic to their own resources using your domain name.</p>
    /// </important>
    /// <p>If you want to avoid the monthly charge for the hosted zone, you can transfer DNS service for the domain to a free DNS service. When you transfer DNS service, you have to update the name servers for the domain registration. If the domain is registered with Route 53, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateDomainNameservers.html">UpdateDomainNameservers</a> for information about how to replace Route 53 name servers with name servers for the new DNS service. If the domain is registered with another registrar, use the method provided by the registrar to update name servers for the domain registration. For more information, perform an internet search on "free DNS service."</p>
    /// <p>You can delete a hosted zone only if it contains only the default SOA record and NS resource record sets. If the hosted zone contains other resource record sets, you must delete them before you can delete the hosted zone. If you try to delete a hosted zone that contains other resource record sets, the request fails, and Route 53 returns a <code>HostedZoneNotEmpty</code> error. For information about deleting records from your hosted zone, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ChangeResourceRecordSets.html">ChangeResourceRecordSets</a>.</p>
    /// <p>To verify that the hosted zone has been deleted, do one of the following:</p>
    /// <ul>
    /// <li> <p>Use the <code>GetHostedZone</code> action to request information about the hosted zone.</p> </li>
    /// <li> <p>Use the <code>ListHostedZones</code> action to get a list of the hosted zones associated with the current Amazon Web Services account.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteHostedZone<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_hosted_zone_input::Builder,
    }
    impl<C, M, R> DeleteHostedZone<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteHostedZone`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteHostedZoneOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteHostedZoneError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteHostedZoneInputOperationOutputAlias,
                crate::output::DeleteHostedZoneOutput,
                crate::error::DeleteHostedZoneError,
                crate::input::DeleteHostedZoneInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the hosted zone you want to delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the hosted zone you want to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteKeySigningKey`.
    ///
    /// <p>Deletes a key-signing key (KSK). Before you can delete a KSK, you must deactivate it. The KSK must be deactivated before you can delete it regardless of whether the hosted zone is enabled for DNSSEC signing.</p>
    /// <p>You can use <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeactivateKeySigningKey.html">DeactivateKeySigningKey</a> to deactivate the key before you delete it.</p>
    /// <p>Use <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetDNSSEC.html">GetDNSSEC</a> to verify that the KSK is in an <code>INACTIVE</code> status.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteKeySigningKey<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_key_signing_key_input::Builder,
    }
    impl<C, M, R> DeleteKeySigningKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteKeySigningKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteKeySigningKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteKeySigningKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteKeySigningKeyInputOperationOutputAlias,
                crate::output::DeleteKeySigningKeyOutput,
                crate::error::DeleteKeySigningKeyError,
                crate::input::DeleteKeySigningKeyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique string used to identify a hosted zone.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>A unique string used to identify a hosted zone.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
        /// <p>A string used to identify a key-signing key (KSK).</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A string used to identify a key-signing key (KSK).</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteQueryLoggingConfig`.
    ///
    /// <p>Deletes a configuration for DNS query logging. If you delete a configuration, Amazon Route 53 stops sending query logs to CloudWatch Logs. Route 53 doesn't delete any logs that are already in CloudWatch Logs.</p>
    /// <p>For more information about DNS query logs, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateQueryLoggingConfig.html">CreateQueryLoggingConfig</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteQueryLoggingConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_query_logging_config_input::Builder,
    }
    impl<C, M, R> DeleteQueryLoggingConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteQueryLoggingConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteQueryLoggingConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteQueryLoggingConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteQueryLoggingConfigInputOperationOutputAlias,
                crate::output::DeleteQueryLoggingConfigOutput,
                crate::error::DeleteQueryLoggingConfigError,
                crate::input::DeleteQueryLoggingConfigInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the configuration that you want to delete. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the configuration that you want to delete. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteReusableDelegationSet`.
    ///
    /// <p>Deletes a reusable delegation set.</p> <important>
    /// <p>You can delete a reusable delegation set only if it isn't associated with any hosted zones.</p>
    /// </important>
    /// <p>To verify that the reusable delegation set is not associated with any hosted zones, submit a <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetReusableDelegationSet.html">GetReusableDelegationSet</a> request and specify the ID of the reusable delegation set that you want to delete.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteReusableDelegationSet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_reusable_delegation_set_input::Builder,
    }
    impl<C, M, R> DeleteReusableDelegationSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteReusableDelegationSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteReusableDelegationSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteReusableDelegationSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteReusableDelegationSetInputOperationOutputAlias,
                crate::output::DeleteReusableDelegationSetOutput,
                crate::error::DeleteReusableDelegationSetError,
                crate::input::DeleteReusableDelegationSetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the reusable delegation set that you want to delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the reusable delegation set that you want to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTrafficPolicy`.
    ///
    /// <p>Deletes a traffic policy.</p>
    /// <p>When you delete a traffic policy, Route 53 sets a flag on the policy to indicate that it has been deleted. However, Route 53 never fully deletes the traffic policy. Note the following:</p>
    /// <ul>
    /// <li> <p>Deleted traffic policies aren't listed if you run <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListTrafficPolicies.html">ListTrafficPolicies</a>.</p> </li>
    /// <li> <p> There's no way to get a list of deleted policies.</p> </li>
    /// <li> <p>If you retain the ID of the policy, you can get information about the policy, including the traffic policy document, by running <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetTrafficPolicy.html">GetTrafficPolicy</a>.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTrafficPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_traffic_policy_input::Builder,
    }
    impl<C, M, R> DeleteTrafficPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTrafficPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTrafficPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTrafficPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTrafficPolicyInputOperationOutputAlias,
                crate::output::DeleteTrafficPolicyOutput,
                crate::error::DeleteTrafficPolicyError,
                crate::input::DeleteTrafficPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the traffic policy that you want to delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the traffic policy that you want to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The version number of the traffic policy that you want to delete.</p>
        pub fn version(mut self, input: i32) -> Self {
            self.inner = self.inner.version(input);
            self
        }
        /// <p>The version number of the traffic policy that you want to delete.</p>
        pub fn set_version(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTrafficPolicyInstance`.
    ///
    /// <p>Deletes a traffic policy instance and all of the resource record sets that Amazon Route 53 created when you created the instance.</p> <note>
    /// <p>In the Route 53 console, traffic policy instances are known as policy records.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTrafficPolicyInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_traffic_policy_instance_input::Builder,
    }
    impl<C, M, R> DeleteTrafficPolicyInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTrafficPolicyInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTrafficPolicyInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTrafficPolicyInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTrafficPolicyInstanceInputOperationOutputAlias,
                crate::output::DeleteTrafficPolicyInstanceOutput,
                crate::error::DeleteTrafficPolicyInstanceError,
                crate::input::DeleteTrafficPolicyInstanceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the traffic policy instance that you want to delete. </p> <important>
        /// <p>When you delete a traffic policy instance, Amazon Route 53 also deletes all of the resource record sets that were created when you created the traffic policy instance.</p>
        /// </important>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the traffic policy instance that you want to delete. </p> <important>
        /// <p>When you delete a traffic policy instance, Amazon Route 53 also deletes all of the resource record sets that were created when you created the traffic policy instance.</p>
        /// </important>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVPCAssociationAuthorization`.
    ///
    /// <p>Removes authorization to submit an <code>AssociateVPCWithHostedZone</code> request to associate a specified VPC with a hosted zone that was created by a different account. You must use the account that created the hosted zone to submit a <code>DeleteVPCAssociationAuthorization</code> request.</p> <important>
    /// <p>Sending this request only prevents the Amazon Web Services account that created the VPC from associating the VPC with the Amazon Route 53 hosted zone in the future. If the VPC is already associated with the hosted zone, <code>DeleteVPCAssociationAuthorization</code> won't disassociate the VPC from the hosted zone. If you want to delete an existing association, use <code>DisassociateVPCFromHostedZone</code>.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteVPCAssociationAuthorization<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_vpc_association_authorization_input::Builder,
    }
    impl<C, M, R> DeleteVPCAssociationAuthorization<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteVPCAssociationAuthorization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVpcAssociationAuthorizationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteVPCAssociationAuthorizationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteVpcAssociationAuthorizationInputOperationOutputAlias,
                crate::output::DeleteVpcAssociationAuthorizationOutput,
                crate::error::DeleteVPCAssociationAuthorizationError,
                crate::input::DeleteVpcAssociationAuthorizationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>When removing authorization to associate a VPC that was created by one Amazon Web Services account with a hosted zone that was created with a different Amazon Web Services account, the ID of the hosted zone.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>When removing authorization to associate a VPC that was created by one Amazon Web Services account with a hosted zone that was created with a different Amazon Web Services account, the ID of the hosted zone.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
        /// <p>When removing authorization to associate a VPC that was created by one Amazon Web Services account with a hosted zone that was created with a different Amazon Web Services account, a complex type that includes the ID and region of the VPC.</p>
        pub fn vpc(mut self, input: crate::model::Vpc) -> Self {
            self.inner = self.inner.vpc(input);
            self
        }
        /// <p>When removing authorization to associate a VPC that was created by one Amazon Web Services account with a hosted zone that was created with a different Amazon Web Services account, a complex type that includes the ID and region of the VPC.</p>
        pub fn set_vpc(mut self, input: std::option::Option<crate::model::Vpc>) -> Self {
            self.inner = self.inner.set_vpc(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableHostedZoneDNSSEC`.
    ///
    /// <p>Disables DNSSEC signing in a specific hosted zone. This action does not deactivate any key-signing keys (KSKs) that are active in the hosted zone.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisableHostedZoneDNSSEC<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disable_hosted_zone_dnssec_input::Builder,
    }
    impl<C, M, R> DisableHostedZoneDNSSEC<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisableHostedZoneDNSSEC`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableHostedZoneDnssecOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableHostedZoneDNSSECError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisableHostedZoneDnssecInputOperationOutputAlias,
                crate::output::DisableHostedZoneDnssecOutput,
                crate::error::DisableHostedZoneDNSSECError,
                crate::input::DisableHostedZoneDnssecInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique string used to identify a hosted zone.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>A unique string used to identify a hosted zone.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateVPCFromHostedZone`.
    ///
    /// <p>Disassociates an Amazon Virtual Private Cloud (Amazon VPC) from an Amazon Route 53 private hosted zone. Note the following:</p>
    /// <ul>
    /// <li> <p>You can't disassociate the last Amazon VPC from a private hosted zone.</p> </li>
    /// <li> <p>You can't convert a private hosted zone into a public hosted zone.</p> </li>
    /// <li> <p>You can submit a <code>DisassociateVPCFromHostedZone</code> request using either the account that created the hosted zone or the account that created the Amazon VPC.</p> </li>
    /// <li> <p>Some services, such as Cloud Map and Amazon Elastic File System (Amazon EFS) automatically create hosted zones and associate VPCs with the hosted zones. A service can create a hosted zone using your account or using its own account. You can disassociate a VPC from a hosted zone only if the service created the hosted zone using your account.</p> <p>When you run <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListHostedZonesByVPC.html">DisassociateVPCFromHostedZone</a>, if the hosted zone has a value for <code>OwningAccount</code>, you can use <code>DisassociateVPCFromHostedZone</code>. If the hosted zone has a value for <code>OwningService</code>, you can't use <code>DisassociateVPCFromHostedZone</code>.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateVPCFromHostedZone<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_vpc_from_hosted_zone_input::Builder,
    }
    impl<C, M, R> DisassociateVPCFromHostedZone<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateVPCFromHostedZone`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateVpcFromHostedZoneOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateVPCFromHostedZoneError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateVpcFromHostedZoneInputOperationOutputAlias,
                crate::output::DisassociateVpcFromHostedZoneOutput,
                crate::error::DisassociateVPCFromHostedZoneError,
                crate::input::DisassociateVpcFromHostedZoneInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the private hosted zone that you want to disassociate a VPC from.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>The ID of the private hosted zone that you want to disassociate a VPC from.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
        /// <p>A complex type that contains information about the VPC that you're disassociating from the specified hosted zone.</p>
        pub fn vpc(mut self, input: crate::model::Vpc) -> Self {
            self.inner = self.inner.vpc(input);
            self
        }
        /// <p>A complex type that contains information about the VPC that you're disassociating from the specified hosted zone.</p>
        pub fn set_vpc(mut self, input: std::option::Option<crate::model::Vpc>) -> Self {
            self.inner = self.inner.set_vpc(input);
            self
        }
        /// <p> <i>Optional:</i> A comment about the disassociation request.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.comment(input.into());
            self
        }
        /// <p> <i>Optional:</i> A comment about the disassociation request.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_comment(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableHostedZoneDNSSEC`.
    ///
    /// <p>Enables DNSSEC signing in a specific hosted zone.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct EnableHostedZoneDNSSEC<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::enable_hosted_zone_dnssec_input::Builder,
    }
    impl<C, M, R> EnableHostedZoneDNSSEC<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EnableHostedZoneDNSSEC`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableHostedZoneDnssecOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableHostedZoneDNSSECError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EnableHostedZoneDnssecInputOperationOutputAlias,
                crate::output::EnableHostedZoneDnssecOutput,
                crate::error::EnableHostedZoneDNSSECError,
                crate::input::EnableHostedZoneDnssecInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique string used to identify a hosted zone.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>A unique string used to identify a hosted zone.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccountLimit`.
    ///
    /// <p>Gets the specified limit for the current account, for example, the maximum number of health checks that you can create using the account.</p>
    /// <p>For the default limit, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a> in the <i>Amazon Route 53 Developer Guide</i>. To request a higher limit, <a href="https://console.aws.amazon.com/support/home#/case/create?issueType=service-limit-increase&amp;limitType=service-code-route53">open a case</a>.</p> <note>
    /// <p>You can also view account limits in Amazon Web Services Trusted Advisor. Sign in to the Amazon Web Services Management Console and open the Trusted Advisor console at <a href="https://console.aws.amazon.com/trustedadvisor">https://console.aws.amazon.com/trustedadvisor/</a>. Then choose <b>Service limits</b> in the navigation pane.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAccountLimit<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_account_limit_input::Builder,
    }
    impl<C, M, R> GetAccountLimit<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAccountLimit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccountLimitOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAccountLimitError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAccountLimitInputOperationOutputAlias,
                crate::output::GetAccountLimitOutput,
                crate::error::GetAccountLimitError,
                crate::input::GetAccountLimitInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The limit that you want to get. Valid values include the following:</p>
        /// <ul>
        /// <li> <p> <b>MAX_HEALTH_CHECKS_BY_OWNER</b>: The maximum number of health checks that you can create using the current account.</p> </li>
        /// <li> <p> <b>MAX_HOSTED_ZONES_BY_OWNER</b>: The maximum number of hosted zones that you can create using the current account.</p> </li>
        /// <li> <p> <b>MAX_REUSABLE_DELEGATION_SETS_BY_OWNER</b>: The maximum number of reusable delegation sets that you can create using the current account.</p> </li>
        /// <li> <p> <b>MAX_TRAFFIC_POLICIES_BY_OWNER</b>: The maximum number of traffic policies that you can create using the current account.</p> </li>
        /// <li> <p> <b>MAX_TRAFFIC_POLICY_INSTANCES_BY_OWNER</b>: The maximum number of traffic policy instances that you can create using the current account. (Traffic policy instances are referred to as traffic flow policy records in the Amazon Route 53 console.)</p> </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::AccountLimitType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The limit that you want to get. Valid values include the following:</p>
        /// <ul>
        /// <li> <p> <b>MAX_HEALTH_CHECKS_BY_OWNER</b>: The maximum number of health checks that you can create using the current account.</p> </li>
        /// <li> <p> <b>MAX_HOSTED_ZONES_BY_OWNER</b>: The maximum number of hosted zones that you can create using the current account.</p> </li>
        /// <li> <p> <b>MAX_REUSABLE_DELEGATION_SETS_BY_OWNER</b>: The maximum number of reusable delegation sets that you can create using the current account.</p> </li>
        /// <li> <p> <b>MAX_TRAFFIC_POLICIES_BY_OWNER</b>: The maximum number of traffic policies that you can create using the current account.</p> </li>
        /// <li> <p> <b>MAX_TRAFFIC_POLICY_INSTANCES_BY_OWNER</b>: The maximum number of traffic policy instances that you can create using the current account. (Traffic policy instances are referred to as traffic flow policy records in the Amazon Route 53 console.)</p> </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::AccountLimitType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetChange`.
    ///
    /// <p>Returns the current status of a change batch request. The status is one of the following values:</p>
    /// <ul>
    /// <li> <p> <code>PENDING</code> indicates that the changes in this request have not propagated to all Amazon Route 53 DNS servers. This is the initial status of all change batch requests.</p> </li>
    /// <li> <p> <code>INSYNC</code> indicates that the changes have propagated to all Route 53 DNS servers. </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetChange<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_change_input::Builder,
    }
    impl<C, M, R> GetChange<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetChange`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetChangeOutput,
            aws_smithy_http::result::SdkError<crate::error::GetChangeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetChangeInputOperationOutputAlias,
                crate::output::GetChangeOutput,
                crate::error::GetChangeError,
                crate::input::GetChangeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the change batch request. The value that you specify here is the value that <code>ChangeResourceRecordSets</code> returned in the <code>Id</code> element when you submitted the request.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the change batch request. The value that you specify here is the value that <code>ChangeResourceRecordSets</code> returned in the <code>Id</code> element when you submitted the request.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCheckerIpRanges`.
    ///
    /// <p>Route 53 does not perform authorization for this API because it retrieves information that is already available to the public.</p> <important>
    /// <p> <code>GetCheckerIpRanges</code> still works, but we recommend that you download ip-ranges.json, which includes IP address ranges for all Amazon Web Services services. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/route-53-ip-addresses.html">IP Address Ranges of Amazon Route 53 Servers</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCheckerIpRanges<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_checker_ip_ranges_input::Builder,
    }
    impl<C, M, R> GetCheckerIpRanges<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCheckerIpRanges`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCheckerIpRangesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCheckerIpRangesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCheckerIpRangesInputOperationOutputAlias,
                crate::output::GetCheckerIpRangesOutput,
                crate::error::GetCheckerIpRangesError,
                crate::input::GetCheckerIpRangesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetDNSSEC`.
    ///
    /// <p>Returns information about DNSSEC for a specific hosted zone, including the key-signing keys (KSKs) in the hosted zone.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDNSSEC<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_dnssec_input::Builder,
    }
    impl<C, M, R> GetDNSSEC<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDNSSEC`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDnssecOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDNSSECError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDnssecInputOperationOutputAlias,
                crate::output::GetDnssecOutput,
                crate::error::GetDNSSECError,
                crate::input::GetDnssecInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique string used to identify a hosted zone.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>A unique string used to identify a hosted zone.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetGeoLocation`.
    ///
    /// <p>Gets information about whether a specified geographic location is supported for Amazon Route 53 geolocation resource record sets.</p>
    /// <p>Route 53 does not perform authorization for this API because it retrieves information that is already available to the public.</p>
    /// <p>Use the following syntax to determine whether a continent is supported for geolocation:</p>
    /// <p> <code>GET /2013-04-01/geolocation?continentcode=<i>two-letter abbreviation for a continent</i> </code> </p>
    /// <p>Use the following syntax to determine whether a country is supported for geolocation:</p>
    /// <p> <code>GET /2013-04-01/geolocation?countrycode=<i>two-character country code</i> </code> </p>
    /// <p>Use the following syntax to determine whether a subdivision of a country is supported for geolocation:</p>
    /// <p> <code>GET /2013-04-01/geolocation?countrycode=<i>two-character country code</i>&amp;subdivisioncode=<i>subdivision code</i> </code> </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetGeoLocation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_geo_location_input::Builder,
    }
    impl<C, M, R> GetGeoLocation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetGeoLocation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetGeoLocationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetGeoLocationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetGeoLocationInputOperationOutputAlias,
                crate::output::GetGeoLocationOutput,
                crate::error::GetGeoLocationError,
                crate::input::GetGeoLocationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>For geolocation resource record sets, a two-letter abbreviation that identifies a continent. Amazon Route 53 supports the following continent codes:</p>
        /// <ul>
        /// <li> <p> <b>AF</b>: Africa</p> </li>
        /// <li> <p> <b>AN</b>: Antarctica</p> </li>
        /// <li> <p> <b>AS</b>: Asia</p> </li>
        /// <li> <p> <b>EU</b>: Europe</p> </li>
        /// <li> <p> <b>OC</b>: Oceania</p> </li>
        /// <li> <p> <b>NA</b>: North America</p> </li>
        /// <li> <p> <b>SA</b>: South America</p> </li>
        /// </ul>
        pub fn continent_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.continent_code(input.into());
            self
        }
        /// <p>For geolocation resource record sets, a two-letter abbreviation that identifies a continent. Amazon Route 53 supports the following continent codes:</p>
        /// <ul>
        /// <li> <p> <b>AF</b>: Africa</p> </li>
        /// <li> <p> <b>AN</b>: Antarctica</p> </li>
        /// <li> <p> <b>AS</b>: Asia</p> </li>
        /// <li> <p> <b>EU</b>: Europe</p> </li>
        /// <li> <p> <b>OC</b>: Oceania</p> </li>
        /// <li> <p> <b>NA</b>: North America</p> </li>
        /// <li> <p> <b>SA</b>: South America</p> </li>
        /// </ul>
        pub fn set_continent_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_continent_code(input);
            self
        }
        /// <p>Amazon Route 53 uses the two-letter country codes that are specified in <a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO standard 3166-1 alpha-2</a>.</p>
        pub fn country_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.country_code(input.into());
            self
        }
        /// <p>Amazon Route 53 uses the two-letter country codes that are specified in <a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO standard 3166-1 alpha-2</a>.</p>
        pub fn set_country_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_country_code(input);
            self
        }
        /// <p>The code for the subdivision, such as a particular state within the United States. For a list of US state abbreviations, see <a href="https://pe.usps.com/text/pub28/28apb.htm">Appendix B: Two–Letter State and Possession Abbreviations</a> on the United States Postal Service website. For a list of all supported subdivision codes, use the <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListGeoLocations.html">ListGeoLocations</a> API.</p>
        pub fn subdivision_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subdivision_code(input.into());
            self
        }
        /// <p>The code for the subdivision, such as a particular state within the United States. For a list of US state abbreviations, see <a href="https://pe.usps.com/text/pub28/28apb.htm">Appendix B: Two–Letter State and Possession Abbreviations</a> on the United States Postal Service website. For a list of all supported subdivision codes, use the <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListGeoLocations.html">ListGeoLocations</a> API.</p>
        pub fn set_subdivision_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subdivision_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetHealthCheck`.
    ///
    /// <p>Gets information about a specified health check.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetHealthCheck<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_health_check_input::Builder,
    }
    impl<C, M, R> GetHealthCheck<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetHealthCheck`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetHealthCheckOutput,
            aws_smithy_http::result::SdkError<crate::error::GetHealthCheckError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetHealthCheckInputOperationOutputAlias,
                crate::output::GetHealthCheckOutput,
                crate::error::GetHealthCheckError,
                crate::input::GetHealthCheckInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier that Amazon Route 53 assigned to the health check when you created it. When you add or update a resource record set, you use this value to specify which health check to use. The value can be up to 64 characters long.</p>
        pub fn health_check_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.health_check_id(input.into());
            self
        }
        /// <p>The identifier that Amazon Route 53 assigned to the health check when you created it. When you add or update a resource record set, you use this value to specify which health check to use. The value can be up to 64 characters long.</p>
        pub fn set_health_check_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_health_check_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetHealthCheckCount`.
    ///
    /// <p>Retrieves the number of health checks that are associated with the current Amazon Web Services account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetHealthCheckCount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_health_check_count_input::Builder,
    }
    impl<C, M, R> GetHealthCheckCount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetHealthCheckCount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetHealthCheckCountOutput,
            aws_smithy_http::result::SdkError<crate::error::GetHealthCheckCountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetHealthCheckCountInputOperationOutputAlias,
                crate::output::GetHealthCheckCountOutput,
                crate::error::GetHealthCheckCountError,
                crate::input::GetHealthCheckCountInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetHealthCheckLastFailureReason`.
    ///
    /// <p>Gets the reason that a specified health check failed most recently.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetHealthCheckLastFailureReason<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_health_check_last_failure_reason_input::Builder,
    }
    impl<C, M, R> GetHealthCheckLastFailureReason<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetHealthCheckLastFailureReason`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetHealthCheckLastFailureReasonOutput,
            aws_smithy_http::result::SdkError<crate::error::GetHealthCheckLastFailureReasonError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetHealthCheckLastFailureReasonInputOperationOutputAlias,
                crate::output::GetHealthCheckLastFailureReasonOutput,
                crate::error::GetHealthCheckLastFailureReasonError,
                crate::input::GetHealthCheckLastFailureReasonInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the health check for which you want the last failure reason. When you created the health check, <code>CreateHealthCheck</code> returned the ID in the response, in the <code>HealthCheckId</code> element.</p> <note>
        /// <p>If you want to get the last failure reason for a calculated health check, you must use the Amazon Route 53 console or the CloudWatch console. You can't use <code>GetHealthCheckLastFailureReason</code> for a calculated health check.</p>
        /// </note>
        pub fn health_check_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.health_check_id(input.into());
            self
        }
        /// <p>The ID for the health check for which you want the last failure reason. When you created the health check, <code>CreateHealthCheck</code> returned the ID in the response, in the <code>HealthCheckId</code> element.</p> <note>
        /// <p>If you want to get the last failure reason for a calculated health check, you must use the Amazon Route 53 console or the CloudWatch console. You can't use <code>GetHealthCheckLastFailureReason</code> for a calculated health check.</p>
        /// </note>
        pub fn set_health_check_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_health_check_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetHealthCheckStatus`.
    ///
    /// <p>Gets status of a specified health check. </p> <important>
    /// <p>This API is intended for use during development to diagnose behavior. It doesn’t support production use-cases with high query rates that require immediate and actionable responses.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetHealthCheckStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_health_check_status_input::Builder,
    }
    impl<C, M, R> GetHealthCheckStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetHealthCheckStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetHealthCheckStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetHealthCheckStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetHealthCheckStatusInputOperationOutputAlias,
                crate::output::GetHealthCheckStatusOutput,
                crate::error::GetHealthCheckStatusError,
                crate::input::GetHealthCheckStatusInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the health check that you want the current status for. When you created the health check, <code>CreateHealthCheck</code> returned the ID in the response, in the <code>HealthCheckId</code> element.</p> <note>
        /// <p>If you want to check the status of a calculated health check, you must use the Amazon Route 53 console or the CloudWatch console. You can't use <code>GetHealthCheckStatus</code> to get the status of a calculated health check.</p>
        /// </note>
        pub fn health_check_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.health_check_id(input.into());
            self
        }
        /// <p>The ID for the health check that you want the current status for. When you created the health check, <code>CreateHealthCheck</code> returned the ID in the response, in the <code>HealthCheckId</code> element.</p> <note>
        /// <p>If you want to check the status of a calculated health check, you must use the Amazon Route 53 console or the CloudWatch console. You can't use <code>GetHealthCheckStatus</code> to get the status of a calculated health check.</p>
        /// </note>
        pub fn set_health_check_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_health_check_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetHostedZone`.
    ///
    /// <p>Gets information about a specified hosted zone including the four name servers assigned to the hosted zone.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetHostedZone<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_hosted_zone_input::Builder,
    }
    impl<C, M, R> GetHostedZone<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetHostedZone`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetHostedZoneOutput,
            aws_smithy_http::result::SdkError<crate::error::GetHostedZoneError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetHostedZoneInputOperationOutputAlias,
                crate::output::GetHostedZoneOutput,
                crate::error::GetHostedZoneError,
                crate::input::GetHostedZoneInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the hosted zone that you want to get information about.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the hosted zone that you want to get information about.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetHostedZoneCount`.
    ///
    /// <p>Retrieves the number of hosted zones that are associated with the current Amazon Web Services account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetHostedZoneCount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_hosted_zone_count_input::Builder,
    }
    impl<C, M, R> GetHostedZoneCount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetHostedZoneCount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetHostedZoneCountOutput,
            aws_smithy_http::result::SdkError<crate::error::GetHostedZoneCountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetHostedZoneCountInputOperationOutputAlias,
                crate::output::GetHostedZoneCountOutput,
                crate::error::GetHostedZoneCountError,
                crate::input::GetHostedZoneCountInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetHostedZoneLimit`.
    ///
    /// <p>Gets the specified limit for a specified hosted zone, for example, the maximum number of records that you can create in the hosted zone. </p>
    /// <p>For the default limit, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a> in the <i>Amazon Route 53 Developer Guide</i>. To request a higher limit, <a href="https://console.aws.amazon.com/support/home#/case/create?issueType=service-limit-increase&amp;limitType=service-code-route53">open a case</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetHostedZoneLimit<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_hosted_zone_limit_input::Builder,
    }
    impl<C, M, R> GetHostedZoneLimit<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetHostedZoneLimit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetHostedZoneLimitOutput,
            aws_smithy_http::result::SdkError<crate::error::GetHostedZoneLimitError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetHostedZoneLimitInputOperationOutputAlias,
                crate::output::GetHostedZoneLimitOutput,
                crate::error::GetHostedZoneLimitError,
                crate::input::GetHostedZoneLimitInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The limit that you want to get. Valid values include the following:</p>
        /// <ul>
        /// <li> <p> <b>MAX_RRSETS_BY_ZONE</b>: The maximum number of records that you can create in the specified hosted zone.</p> </li>
        /// <li> <p> <b>MAX_VPCS_ASSOCIATED_BY_ZONE</b>: The maximum number of Amazon VPCs that you can associate with the specified private hosted zone.</p> </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::HostedZoneLimitType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The limit that you want to get. Valid values include the following:</p>
        /// <ul>
        /// <li> <p> <b>MAX_RRSETS_BY_ZONE</b>: The maximum number of records that you can create in the specified hosted zone.</p> </li>
        /// <li> <p> <b>MAX_VPCS_ASSOCIATED_BY_ZONE</b>: The maximum number of Amazon VPCs that you can associate with the specified private hosted zone.</p> </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::HostedZoneLimitType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The ID of the hosted zone that you want to get a limit for.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>The ID of the hosted zone that you want to get a limit for.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetQueryLoggingConfig`.
    ///
    /// <p>Gets information about a specified configuration for DNS query logging.</p>
    /// <p>For more information about DNS query logs, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateQueryLoggingConfig.html">CreateQueryLoggingConfig</a> and <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html">Logging DNS Queries</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetQueryLoggingConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_query_logging_config_input::Builder,
    }
    impl<C, M, R> GetQueryLoggingConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetQueryLoggingConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetQueryLoggingConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetQueryLoggingConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetQueryLoggingConfigInputOperationOutputAlias,
                crate::output::GetQueryLoggingConfigOutput,
                crate::error::GetQueryLoggingConfigError,
                crate::input::GetQueryLoggingConfigInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the configuration for DNS query logging that you want to get information about.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the configuration for DNS query logging that you want to get information about.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetReusableDelegationSet`.
    ///
    /// <p>Retrieves information about a specified reusable delegation set, including the four name servers that are assigned to the delegation set.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetReusableDelegationSet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_reusable_delegation_set_input::Builder,
    }
    impl<C, M, R> GetReusableDelegationSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetReusableDelegationSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetReusableDelegationSetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetReusableDelegationSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetReusableDelegationSetInputOperationOutputAlias,
                crate::output::GetReusableDelegationSetOutput,
                crate::error::GetReusableDelegationSetError,
                crate::input::GetReusableDelegationSetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the reusable delegation set that you want to get a list of name servers for.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the reusable delegation set that you want to get a list of name servers for.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetReusableDelegationSetLimit`.
    ///
    /// <p>Gets the maximum number of hosted zones that you can associate with the specified reusable delegation set.</p>
    /// <p>For the default limit, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a> in the <i>Amazon Route 53 Developer Guide</i>. To request a higher limit, <a href="https://console.aws.amazon.com/support/home#/case/create?issueType=service-limit-increase&amp;limitType=service-code-route53">open a case</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetReusableDelegationSetLimit<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_reusable_delegation_set_limit_input::Builder,
    }
    impl<C, M, R> GetReusableDelegationSetLimit<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetReusableDelegationSetLimit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetReusableDelegationSetLimitOutput,
            aws_smithy_http::result::SdkError<crate::error::GetReusableDelegationSetLimitError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetReusableDelegationSetLimitInputOperationOutputAlias,
                crate::output::GetReusableDelegationSetLimitOutput,
                crate::error::GetReusableDelegationSetLimitError,
                crate::input::GetReusableDelegationSetLimitInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specify <code>MAX_ZONES_BY_REUSABLE_DELEGATION_SET</code> to get the maximum number of hosted zones that you can associate with the specified reusable delegation set.</p>
        pub fn r#type(mut self, input: crate::model::ReusableDelegationSetLimitType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>Specify <code>MAX_ZONES_BY_REUSABLE_DELEGATION_SET</code> to get the maximum number of hosted zones that you can associate with the specified reusable delegation set.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ReusableDelegationSetLimitType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The ID of the delegation set that you want to get the limit for.</p>
        pub fn delegation_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.delegation_set_id(input.into());
            self
        }
        /// <p>The ID of the delegation set that you want to get the limit for.</p>
        pub fn set_delegation_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_delegation_set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTrafficPolicy`.
    ///
    /// <p>Gets information about a specific traffic policy version.</p>
    /// <p>For information about how of deleting a traffic policy affects the response from <code>GetTrafficPolicy</code>, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteTrafficPolicy.html">DeleteTrafficPolicy</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetTrafficPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_traffic_policy_input::Builder,
    }
    impl<C, M, R> GetTrafficPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTrafficPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTrafficPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTrafficPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTrafficPolicyInputOperationOutputAlias,
                crate::output::GetTrafficPolicyOutput,
                crate::error::GetTrafficPolicyError,
                crate::input::GetTrafficPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the traffic policy that you want to get information about.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the traffic policy that you want to get information about.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The version number of the traffic policy that you want to get information about.</p>
        pub fn version(mut self, input: i32) -> Self {
            self.inner = self.inner.version(input);
            self
        }
        /// <p>The version number of the traffic policy that you want to get information about.</p>
        pub fn set_version(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTrafficPolicyInstance`.
    ///
    /// <p>Gets information about a specified traffic policy instance.</p> <note>
    /// <p>After you submit a <code>CreateTrafficPolicyInstance</code> or an <code>UpdateTrafficPolicyInstance</code> request, there's a brief delay while Amazon Route 53 creates the resource record sets that are specified in the traffic policy definition. For more information, see the <code>State</code> response element.</p>
    /// </note> <note>
    /// <p>In the Route 53 console, traffic policy instances are known as policy records.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetTrafficPolicyInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_traffic_policy_instance_input::Builder,
    }
    impl<C, M, R> GetTrafficPolicyInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTrafficPolicyInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTrafficPolicyInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTrafficPolicyInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTrafficPolicyInstanceInputOperationOutputAlias,
                crate::output::GetTrafficPolicyInstanceOutput,
                crate::error::GetTrafficPolicyInstanceError,
                crate::input::GetTrafficPolicyInstanceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the traffic policy instance that you want to get information about.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the traffic policy instance that you want to get information about.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTrafficPolicyInstanceCount`.
    ///
    /// <p>Gets the number of traffic policy instances that are associated with the current Amazon Web Services account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetTrafficPolicyInstanceCount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_traffic_policy_instance_count_input::Builder,
    }
    impl<C, M, R> GetTrafficPolicyInstanceCount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTrafficPolicyInstanceCount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTrafficPolicyInstanceCountOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTrafficPolicyInstanceCountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTrafficPolicyInstanceCountInputOperationOutputAlias,
                crate::output::GetTrafficPolicyInstanceCountOutput,
                crate::error::GetTrafficPolicyInstanceCountError,
                crate::input::GetTrafficPolicyInstanceCountInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `ListGeoLocations`.
    ///
    /// <p>Retrieves a list of supported geographic locations.</p>
    /// <p>Countries are listed first, and continents are listed last. If Amazon Route 53 supports subdivisions for a country (for example, states or provinces), the subdivisions for that country are listed in alphabetical order immediately after the corresponding country.</p>
    /// <p>Route 53 does not perform authorization for this API because it retrieves information that is already available to the public.</p>
    /// <p>For a list of supported geolocation codes, see the <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GeoLocation.html">GeoLocation</a> data type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListGeoLocations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_geo_locations_input::Builder,
    }
    impl<C, M, R> ListGeoLocations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListGeoLocations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGeoLocationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGeoLocationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListGeoLocationsInputOperationOutputAlias,
                crate::output::ListGeoLocationsOutput,
                crate::error::ListGeoLocationsError,
                crate::input::ListGeoLocationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The code for the continent with which you want to start listing locations that Amazon Route 53 supports for geolocation. If Route 53 has already returned a page or more of results, if <code>IsTruncated</code> is true, and if <code>NextContinentCode</code> from the previous response has a value, enter that value in <code>startcontinentcode</code> to return the next page of results.</p>
        /// <p>Include <code>startcontinentcode</code> only if you want to list continents. Don't include <code>startcontinentcode</code> when you're listing countries or countries with their subdivisions.</p>
        pub fn start_continent_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.start_continent_code(input.into());
            self
        }
        /// <p>The code for the continent with which you want to start listing locations that Amazon Route 53 supports for geolocation. If Route 53 has already returned a page or more of results, if <code>IsTruncated</code> is true, and if <code>NextContinentCode</code> from the previous response has a value, enter that value in <code>startcontinentcode</code> to return the next page of results.</p>
        /// <p>Include <code>startcontinentcode</code> only if you want to list continents. Don't include <code>startcontinentcode</code> when you're listing countries or countries with their subdivisions.</p>
        pub fn set_start_continent_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_start_continent_code(input);
            self
        }
        /// <p>The code for the country with which you want to start listing locations that Amazon Route 53 supports for geolocation. If Route 53 has already returned a page or more of results, if <code>IsTruncated</code> is <code>true</code>, and if <code>NextCountryCode</code> from the previous response has a value, enter that value in <code>startcountrycode</code> to return the next page of results.</p>
        pub fn start_country_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.start_country_code(input.into());
            self
        }
        /// <p>The code for the country with which you want to start listing locations that Amazon Route 53 supports for geolocation. If Route 53 has already returned a page or more of results, if <code>IsTruncated</code> is <code>true</code>, and if <code>NextCountryCode</code> from the previous response has a value, enter that value in <code>startcountrycode</code> to return the next page of results.</p>
        pub fn set_start_country_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_start_country_code(input);
            self
        }
        /// <p>The code for the state of the United States with which you want to start listing locations that Amazon Route 53 supports for geolocation. If Route 53 has already returned a page or more of results, if <code>IsTruncated</code> is <code>true</code>, and if <code>NextSubdivisionCode</code> from the previous response has a value, enter that value in <code>startsubdivisioncode</code> to return the next page of results.</p>
        /// <p>To list subdivisions (U.S. states), you must include both <code>startcountrycode</code> and <code>startsubdivisioncode</code>.</p>
        pub fn start_subdivision_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.start_subdivision_code(input.into());
            self
        }
        /// <p>The code for the state of the United States with which you want to start listing locations that Amazon Route 53 supports for geolocation. If Route 53 has already returned a page or more of results, if <code>IsTruncated</code> is <code>true</code>, and if <code>NextSubdivisionCode</code> from the previous response has a value, enter that value in <code>startsubdivisioncode</code> to return the next page of results.</p>
        /// <p>To list subdivisions (U.S. states), you must include both <code>startcountrycode</code> and <code>startsubdivisioncode</code>.</p>
        pub fn set_start_subdivision_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_start_subdivision_code(input);
            self
        }
        /// <p>(Optional) The maximum number of geolocations to be included in the response body for this request. If more than <code>maxitems</code> geolocations remain to be listed, then the value of the <code>IsTruncated</code> element in the response is <code>true</code>.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>(Optional) The maximum number of geolocations to be included in the response body for this request. If more than <code>maxitems</code> geolocations remain to be listed, then the value of the <code>IsTruncated</code> element in the response is <code>true</code>.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListHealthChecks`.
    ///
    /// <p>Retrieve a list of the health checks that are associated with the current Amazon Web Services account. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListHealthChecks<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_health_checks_input::Builder,
    }
    impl<C, M, R> ListHealthChecks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListHealthChecks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListHealthChecksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListHealthChecksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListHealthChecksInputOperationOutputAlias,
                crate::output::ListHealthChecksOutput,
                crate::error::ListHealthChecksError,
                crate::input::ListHealthChecksInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListHealthChecksPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListHealthChecksPaginator<C, M, R> {
            crate::paginator::ListHealthChecksPaginator::new(self.handle, self.inner)
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more health checks. To get another group, submit another <code>ListHealthChecks</code> request. </p>
        /// <p>For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous response, which is the ID of the first health check that Amazon Route 53 will return if you submit another request.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more health checks to get.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more health checks. To get another group, submit another <code>ListHealthChecks</code> request. </p>
        /// <p>For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous response, which is the ID of the first health check that Amazon Route 53 will return if you submit another request.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more health checks to get.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of health checks that you want <code>ListHealthChecks</code> to return in response to the current request. Amazon Route 53 returns a maximum of 100 items. If you set <code>MaxItems</code> to a value greater than 100, Route 53 returns only the first 100 health checks. </p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The maximum number of health checks that you want <code>ListHealthChecks</code> to return in response to the current request. Amazon Route 53 returns a maximum of 100 items. If you set <code>MaxItems</code> to a value greater than 100, Route 53 returns only the first 100 health checks. </p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListHostedZones`.
    ///
    /// <p>Retrieves a list of the public and private hosted zones that are associated with the current Amazon Web Services account. The response includes a <code>HostedZones</code> child element for each hosted zone.</p>
    /// <p>Amazon Route 53 returns a maximum of 100 items in each response. If you have a lot of hosted zones, you can use the <code>maxitems</code> parameter to list them in groups of up to 100.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListHostedZones<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_hosted_zones_input::Builder,
    }
    impl<C, M, R> ListHostedZones<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListHostedZones`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListHostedZonesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListHostedZonesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListHostedZonesInputOperationOutputAlias,
                crate::output::ListHostedZonesOutput,
                crate::error::ListHostedZonesError,
                crate::input::ListHostedZonesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListHostedZonesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListHostedZonesPaginator<C, M, R> {
            crate::paginator::ListHostedZonesPaginator::new(self.handle, self.inner)
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more hosted zones. To get more hosted zones, submit another <code>ListHostedZones</code> request. </p>
        /// <p>For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous response, which is the ID of the first hosted zone that Amazon Route 53 will return if you submit another request.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more hosted zones to get.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more hosted zones. To get more hosted zones, submit another <code>ListHostedZones</code> request. </p>
        /// <p>For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous response, which is the ID of the first hosted zone that Amazon Route 53 will return if you submit another request.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more hosted zones to get.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>(Optional) The maximum number of hosted zones that you want Amazon Route 53 to return. If you have more than <code>maxitems</code> hosted zones, the value of <code>IsTruncated</code> in the response is <code>true</code>, and the value of <code>NextMarker</code> is the hosted zone ID of the first hosted zone that Route 53 will return if you submit another request.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>(Optional) The maximum number of hosted zones that you want Amazon Route 53 to return. If you have more than <code>maxitems</code> hosted zones, the value of <code>IsTruncated</code> in the response is <code>true</code>, and the value of <code>NextMarker</code> is the hosted zone ID of the first hosted zone that Route 53 will return if you submit another request.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
        /// <p>If you're using reusable delegation sets and you want to list all of the hosted zones that are associated with a reusable delegation set, specify the ID of that reusable delegation set. </p>
        pub fn delegation_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.delegation_set_id(input.into());
            self
        }
        /// <p>If you're using reusable delegation sets and you want to list all of the hosted zones that are associated with a reusable delegation set, specify the ID of that reusable delegation set. </p>
        pub fn set_delegation_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_delegation_set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListHostedZonesByName`.
    ///
    /// <p>Retrieves a list of your hosted zones in lexicographic order. The response includes a <code>HostedZones</code> child element for each hosted zone created by the current Amazon Web Services account. </p>
    /// <p> <code>ListHostedZonesByName</code> sorts hosted zones by name with the labels reversed. For example:</p>
    /// <p> <code>com.example.www.</code> </p>
    /// <p>Note the trailing dot, which can change the sort order in some circumstances.</p>
    /// <p>If the domain name includes escape characters or Punycode, <code>ListHostedZonesByName</code> alphabetizes the domain name using the escaped or Punycoded value, which is the format that Amazon Route 53 saves in its database. For example, to create a hosted zone for exämple.com, you specify ex\344mple.com for the domain name. <code>ListHostedZonesByName</code> alphabetizes it as:</p>
    /// <p> <code>com.ex\344mple.</code> </p>
    /// <p>The labels are reversed and alphabetized using the escaped value. For more information about valid domain name formats, including internationalized domain names, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html">DNS Domain Name Format</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
    /// <p>Route 53 returns up to 100 items in each response. If you have a lot of hosted zones, use the <code>MaxItems</code> parameter to list them in groups of up to 100. The response includes values that help navigate from one group of <code>MaxItems</code> hosted zones to the next:</p>
    /// <ul>
    /// <li> <p>The <code>DNSName</code> and <code>HostedZoneId</code> elements in the response contain the values, if any, specified for the <code>dnsname</code> and <code>hostedzoneid</code> parameters in the request that produced the current response.</p> </li>
    /// <li> <p>The <code>MaxItems</code> element in the response contains the value, if any, that you specified for the <code>maxitems</code> parameter in the request that produced the current response.</p> </li>
    /// <li> <p>If the value of <code>IsTruncated</code> in the response is true, there are more hosted zones associated with the current Amazon Web Services account. </p> <p>If <code>IsTruncated</code> is false, this response includes the last hosted zone that is associated with the current account. The <code>NextDNSName</code> element and <code>NextHostedZoneId</code> elements are omitted from the response.</p> </li>
    /// <li> <p>The <code>NextDNSName</code> and <code>NextHostedZoneId</code> elements in the response contain the domain name and the hosted zone ID of the next hosted zone that is associated with the current Amazon Web Services account. If you want to list more hosted zones, make another call to <code>ListHostedZonesByName</code>, and specify the value of <code>NextDNSName</code> and <code>NextHostedZoneId</code> in the <code>dnsname</code> and <code>hostedzoneid</code> parameters, respectively.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListHostedZonesByName<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_hosted_zones_by_name_input::Builder,
    }
    impl<C, M, R> ListHostedZonesByName<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListHostedZonesByName`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListHostedZonesByNameOutput,
            aws_smithy_http::result::SdkError<crate::error::ListHostedZonesByNameError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListHostedZonesByNameInputOperationOutputAlias,
                crate::output::ListHostedZonesByNameOutput,
                crate::error::ListHostedZonesByNameError,
                crate::input::ListHostedZonesByNameInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>(Optional) For your first request to <code>ListHostedZonesByName</code>, include the <code>dnsname</code> parameter only if you want to specify the name of the first hosted zone in the response. If you don't include the <code>dnsname</code> parameter, Amazon Route 53 returns all of the hosted zones that were created by the current Amazon Web Services account, in ASCII order. For subsequent requests, include both <code>dnsname</code> and <code>hostedzoneid</code> parameters. For <code>dnsname</code>, specify the value of <code>NextDNSName</code> from the previous response.</p>
        pub fn dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dns_name(input.into());
            self
        }
        /// <p>(Optional) For your first request to <code>ListHostedZonesByName</code>, include the <code>dnsname</code> parameter only if you want to specify the name of the first hosted zone in the response. If you don't include the <code>dnsname</code> parameter, Amazon Route 53 returns all of the hosted zones that were created by the current Amazon Web Services account, in ASCII order. For subsequent requests, include both <code>dnsname</code> and <code>hostedzoneid</code> parameters. For <code>dnsname</code>, specify the value of <code>NextDNSName</code> from the previous response.</p>
        pub fn set_dns_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dns_name(input);
            self
        }
        /// <p>(Optional) For your first request to <code>ListHostedZonesByName</code>, do not include the <code>hostedzoneid</code> parameter.</p>
        /// <p>If you have more hosted zones than the value of <code>maxitems</code>, <code>ListHostedZonesByName</code> returns only the first <code>maxitems</code> hosted zones. To get the next group of <code>maxitems</code> hosted zones, submit another request to <code>ListHostedZonesByName</code> and include both <code>dnsname</code> and <code>hostedzoneid</code> parameters. For the value of <code>hostedzoneid</code>, specify the value of the <code>NextHostedZoneId</code> element from the previous response.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>(Optional) For your first request to <code>ListHostedZonesByName</code>, do not include the <code>hostedzoneid</code> parameter.</p>
        /// <p>If you have more hosted zones than the value of <code>maxitems</code>, <code>ListHostedZonesByName</code> returns only the first <code>maxitems</code> hosted zones. To get the next group of <code>maxitems</code> hosted zones, submit another request to <code>ListHostedZonesByName</code> and include both <code>dnsname</code> and <code>hostedzoneid</code> parameters. For the value of <code>hostedzoneid</code>, specify the value of the <code>NextHostedZoneId</code> element from the previous response.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
        /// <p>The maximum number of hosted zones to be included in the response body for this request. If you have more than <code>maxitems</code> hosted zones, then the value of the <code>IsTruncated</code> element in the response is true, and the values of <code>NextDNSName</code> and <code>NextHostedZoneId</code> specify the first hosted zone in the next group of <code>maxitems</code> hosted zones. </p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The maximum number of hosted zones to be included in the response body for this request. If you have more than <code>maxitems</code> hosted zones, then the value of the <code>IsTruncated</code> element in the response is true, and the values of <code>NextDNSName</code> and <code>NextHostedZoneId</code> specify the first hosted zone in the next group of <code>maxitems</code> hosted zones. </p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListHostedZonesByVPC`.
    ///
    /// <p>Lists all the private hosted zones that a specified VPC is associated with, regardless of which Amazon Web Services account or Amazon Web Services service owns the hosted zones. The <code>HostedZoneOwner</code> structure in the response contains one of the following values:</p>
    /// <ul>
    /// <li> <p>An <code>OwningAccount</code> element, which contains the account number of either the current Amazon Web Services account or another Amazon Web Services account. Some services, such as Cloud Map, create hosted zones using the current account. </p> </li>
    /// <li> <p>An <code>OwningService</code> element, which identifies the Amazon Web Services service that created and owns the hosted zone. For example, if a hosted zone was created by Amazon Elastic File System (Amazon EFS), the value of <code>Owner</code> is <code>efs.amazonaws.com</code>. </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListHostedZonesByVPC<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_hosted_zones_by_vpc_input::Builder,
    }
    impl<C, M, R> ListHostedZonesByVPC<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListHostedZonesByVPC`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListHostedZonesByVpcOutput,
            aws_smithy_http::result::SdkError<crate::error::ListHostedZonesByVPCError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListHostedZonesByVpcInputOperationOutputAlias,
                crate::output::ListHostedZonesByVpcOutput,
                crate::error::ListHostedZonesByVPCError,
                crate::input::ListHostedZonesByVpcInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon VPC that you want to list hosted zones for.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_id(input.into());
            self
        }
        /// <p>The ID of the Amazon VPC that you want to list hosted zones for.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_id(input);
            self
        }
        /// <p>For the Amazon VPC that you specified for <code>VPCId</code>, the Amazon Web Services Region that you created the VPC in. </p>
        pub fn vpc_region(mut self, input: crate::model::VpcRegion) -> Self {
            self.inner = self.inner.vpc_region(input);
            self
        }
        /// <p>For the Amazon VPC that you specified for <code>VPCId</code>, the Amazon Web Services Region that you created the VPC in. </p>
        pub fn set_vpc_region(
            mut self,
            input: std::option::Option<crate::model::VpcRegion>,
        ) -> Self {
            self.inner = self.inner.set_vpc_region(input);
            self
        }
        /// <p>(Optional) The maximum number of hosted zones that you want Amazon Route 53 to return. If the specified VPC is associated with more than <code>MaxItems</code> hosted zones, the response includes a <code>NextToken</code> element. <code>NextToken</code> contains an encrypted token that identifies the first hosted zone that Route 53 will return if you submit another request.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>(Optional) The maximum number of hosted zones that you want Amazon Route 53 to return. If the specified VPC is associated with more than <code>MaxItems</code> hosted zones, the response includes a <code>NextToken</code> element. <code>NextToken</code> contains an encrypted token that identifies the first hosted zone that Route 53 will return if you submit another request.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
        /// <p>If the previous response included a <code>NextToken</code> element, the specified VPC is associated with more hosted zones. To get more hosted zones, submit another <code>ListHostedZonesByVPC</code> request. </p>
        /// <p>For the value of <code>NextToken</code>, specify the value of <code>NextToken</code> from the previous response.</p>
        /// <p>If the previous response didn't include a <code>NextToken</code> element, there are no more hosted zones to get.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous response included a <code>NextToken</code> element, the specified VPC is associated with more hosted zones. To get more hosted zones, submit another <code>ListHostedZonesByVPC</code> request. </p>
        /// <p>For the value of <code>NextToken</code>, specify the value of <code>NextToken</code> from the previous response.</p>
        /// <p>If the previous response didn't include a <code>NextToken</code> element, there are no more hosted zones to get.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListQueryLoggingConfigs`.
    ///
    /// <p>Lists the configurations for DNS query logging that are associated with the current Amazon Web Services account or the configuration that is associated with a specified hosted zone.</p>
    /// <p>For more information about DNS query logs, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateQueryLoggingConfig.html">CreateQueryLoggingConfig</a>. Additional information, including the format of DNS query logs, appears in <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html">Logging DNS Queries</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListQueryLoggingConfigs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_query_logging_configs_input::Builder,
    }
    impl<C, M, R> ListQueryLoggingConfigs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListQueryLoggingConfigs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListQueryLoggingConfigsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListQueryLoggingConfigsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListQueryLoggingConfigsInputOperationOutputAlias,
                crate::output::ListQueryLoggingConfigsOutput,
                crate::error::ListQueryLoggingConfigsError,
                crate::input::ListQueryLoggingConfigsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListQueryLoggingConfigsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListQueryLoggingConfigsPaginator<C, M, R> {
            crate::paginator::ListQueryLoggingConfigsPaginator::new(self.handle, self.inner)
        }
        /// <p>(Optional) If you want to list the query logging configuration that is associated with a hosted zone, specify the ID in <code>HostedZoneId</code>. </p>
        /// <p>If you don't specify a hosted zone ID, <code>ListQueryLoggingConfigs</code> returns all of the configurations that are associated with the current Amazon Web Services account.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>(Optional) If you want to list the query logging configuration that is associated with a hosted zone, specify the ID in <code>HostedZoneId</code>. </p>
        /// <p>If you don't specify a hosted zone ID, <code>ListQueryLoggingConfigs</code> returns all of the configurations that are associated with the current Amazon Web Services account.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
        /// <p>(Optional) If the current Amazon Web Services account has more than <code>MaxResults</code> query logging configurations, use <code>NextToken</code> to get the second and subsequent pages of results.</p>
        /// <p>For the first <code>ListQueryLoggingConfigs</code> request, omit this value.</p>
        /// <p>For the second and subsequent requests, get the value of <code>NextToken</code> from the previous response and specify that value for <code>NextToken</code> in the request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>(Optional) If the current Amazon Web Services account has more than <code>MaxResults</code> query logging configurations, use <code>NextToken</code> to get the second and subsequent pages of results.</p>
        /// <p>For the first <code>ListQueryLoggingConfigs</code> request, omit this value.</p>
        /// <p>For the second and subsequent requests, get the value of <code>NextToken</code> from the previous response and specify that value for <code>NextToken</code> in the request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>(Optional) The maximum number of query logging configurations that you want Amazon Route 53 to return in response to the current request. If the current Amazon Web Services account has more than <code>MaxResults</code> configurations, use the value of <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListQueryLoggingConfigs.html#API_ListQueryLoggingConfigs_RequestSyntax">NextToken</a> in the response to get the next page of results.</p>
        /// <p>If you don't specify a value for <code>MaxResults</code>, Route 53 returns up to 100 configurations.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>(Optional) The maximum number of query logging configurations that you want Amazon Route 53 to return in response to the current request. If the current Amazon Web Services account has more than <code>MaxResults</code> configurations, use the value of <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListQueryLoggingConfigs.html#API_ListQueryLoggingConfigs_RequestSyntax">NextToken</a> in the response to get the next page of results.</p>
        /// <p>If you don't specify a value for <code>MaxResults</code>, Route 53 returns up to 100 configurations.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResourceRecordSets`.
    ///
    /// <p>Lists the resource record sets in a specified hosted zone.</p>
    /// <p> <code>ListResourceRecordSets</code> returns up to 300 resource record sets at a time in ASCII order, beginning at a position specified by the <code>name</code> and <code>type</code> elements.</p>
    /// <p> <b>Sort order</b> </p>
    /// <p> <code>ListResourceRecordSets</code> sorts results first by DNS name with the labels reversed, for example:</p>
    /// <p> <code>com.example.www.</code> </p>
    /// <p>Note the trailing dot, which can change the sort order when the record name contains characters that appear before <code>.</code> (decimal 46) in the ASCII table. These characters include the following: <code>! " # $ % &amp; ' ( ) * + , -</code> </p>
    /// <p>When multiple records have the same DNS name, <code>ListResourceRecordSets</code> sorts results by the record type.</p>
    /// <p> <b>Specifying where to start listing records</b> </p>
    /// <p>You can use the name and type elements to specify the resource record set that the list begins with:</p>
    /// <dl>
    /// <dt>
    /// If you do not specify Name or Type
    /// </dt>
    /// <dd>
    /// <p>The results begin with the first resource record set that the hosted zone contains.</p>
    /// </dd>
    /// <dt>
    /// If you specify Name but not Type
    /// </dt>
    /// <dd>
    /// <p>The results begin with the first resource record set in the list whose name is greater than or equal to <code>Name</code>.</p>
    /// </dd>
    /// <dt>
    /// If you specify Type but not Name
    /// </dt>
    /// <dd>
    /// <p>Amazon Route 53 returns the <code>InvalidInput</code> error.</p>
    /// </dd>
    /// <dt>
    /// If you specify both Name and Type
    /// </dt>
    /// <dd>
    /// <p>The results begin with the first resource record set in the list whose name is greater than or equal to <code>Name</code>, and whose type is greater than or equal to <code>Type</code>.</p>
    /// </dd>
    /// </dl>
    /// <p> <b>Resource record sets that are PENDING</b> </p>
    /// <p>This action returns the most current version of the records. This includes records that are <code>PENDING</code>, and that are not yet available on all Route 53 DNS servers.</p>
    /// <p> <b>Changing resource record sets</b> </p>
    /// <p>To ensure that you get an accurate listing of the resource record sets for a hosted zone at a point in time, do not submit a <code>ChangeResourceRecordSets</code> request while you're paging through the results of a <code>ListResourceRecordSets</code> request. If you do, some pages may display results without the latest changes while other pages display results with the latest changes.</p>
    /// <p> <b>Displaying the next page of results</b> </p>
    /// <p>If a <code>ListResourceRecordSets</code> command returns more than one page of results, the value of <code>IsTruncated</code> is <code>true</code>. To display the next page of results, get the values of <code>NextRecordName</code>, <code>NextRecordType</code>, and <code>NextRecordIdentifier</code> (if any) from the response. Then submit another <code>ListResourceRecordSets</code> request, and specify those values for <code>StartRecordName</code>, <code>StartRecordType</code>, and <code>StartRecordIdentifier</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListResourceRecordSets<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_resource_record_sets_input::Builder,
    }
    impl<C, M, R> ListResourceRecordSets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListResourceRecordSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResourceRecordSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResourceRecordSetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListResourceRecordSetsInputOperationOutputAlias,
                crate::output::ListResourceRecordSetsOutput,
                crate::error::ListResourceRecordSetsError,
                crate::input::ListResourceRecordSetsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the hosted zone that contains the resource record sets that you want to list.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>The ID of the hosted zone that contains the resource record sets that you want to list.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
        /// <p>The first name in the lexicographic ordering of resource record sets that you want to list. If the specified record name doesn't exist, the results begin with the first resource record set that has a name greater than the value of <code>name</code>.</p>
        pub fn start_record_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.start_record_name(input.into());
            self
        }
        /// <p>The first name in the lexicographic ordering of resource record sets that you want to list. If the specified record name doesn't exist, the results begin with the first resource record set that has a name greater than the value of <code>name</code>.</p>
        pub fn set_start_record_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_start_record_name(input);
            self
        }
        /// <p>The type of resource record set to begin the record listing from.</p>
        /// <p>Valid values for basic resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> | <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> | <code>NS</code> | <code>PTR</code> | <code>SOA</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code> </p>
        /// <p>Values for weighted, latency, geolocation, and failover resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> | <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> | <code>PTR</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code> </p>
        /// <p>Values for alias resource record sets: </p>
        /// <ul>
        /// <li> <p> <b>API Gateway custom regional API or edge-optimized API</b>: A</p> </li>
        /// <li> <p> <b>CloudFront distribution</b>: A or AAAA</p> </li>
        /// <li> <p> <b>Elastic Beanstalk environment that has a regionalized subdomain</b>: A</p> </li>
        /// <li> <p> <b>Elastic Load Balancing load balancer</b>: A | AAAA</p> </li>
        /// <li> <p> <b>S3 bucket</b>: A</p> </li>
        /// <li> <p> <b>VPC interface VPC endpoint</b>: A</p> </li>
        /// <li> <p> <b>Another resource record set in this hosted zone:</b> The type of the resource record set that the alias references.</p> </li>
        /// </ul>
        /// <p>Constraint: Specifying <code>type</code> without specifying <code>name</code> returns an <code>InvalidInput</code> error.</p>
        pub fn start_record_type(mut self, input: crate::model::RrType) -> Self {
            self.inner = self.inner.start_record_type(input);
            self
        }
        /// <p>The type of resource record set to begin the record listing from.</p>
        /// <p>Valid values for basic resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> | <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> | <code>NS</code> | <code>PTR</code> | <code>SOA</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code> </p>
        /// <p>Values for weighted, latency, geolocation, and failover resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> | <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> | <code>PTR</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code> </p>
        /// <p>Values for alias resource record sets: </p>
        /// <ul>
        /// <li> <p> <b>API Gateway custom regional API or edge-optimized API</b>: A</p> </li>
        /// <li> <p> <b>CloudFront distribution</b>: A or AAAA</p> </li>
        /// <li> <p> <b>Elastic Beanstalk environment that has a regionalized subdomain</b>: A</p> </li>
        /// <li> <p> <b>Elastic Load Balancing load balancer</b>: A | AAAA</p> </li>
        /// <li> <p> <b>S3 bucket</b>: A</p> </li>
        /// <li> <p> <b>VPC interface VPC endpoint</b>: A</p> </li>
        /// <li> <p> <b>Another resource record set in this hosted zone:</b> The type of the resource record set that the alias references.</p> </li>
        /// </ul>
        /// <p>Constraint: Specifying <code>type</code> without specifying <code>name</code> returns an <code>InvalidInput</code> error.</p>
        pub fn set_start_record_type(
            mut self,
            input: std::option::Option<crate::model::RrType>,
        ) -> Self {
            self.inner = self.inner.set_start_record_type(input);
            self
        }
        /// <p> <i>Resource record sets that have a routing policy other than simple:</i> If results were truncated for a given DNS name and type, specify the value of <code>NextRecordIdentifier</code> from the previous response to get the next resource record set that has the current DNS name and type.</p>
        pub fn start_record_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.start_record_identifier(input.into());
            self
        }
        /// <p> <i>Resource record sets that have a routing policy other than simple:</i> If results were truncated for a given DNS name and type, specify the value of <code>NextRecordIdentifier</code> from the previous response to get the next resource record set that has the current DNS name and type.</p>
        pub fn set_start_record_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_start_record_identifier(input);
            self
        }
        /// <p>(Optional) The maximum number of resource records sets to include in the response body for this request. If the response includes more than <code>maxitems</code> resource record sets, the value of the <code>IsTruncated</code> element in the response is <code>true</code>, and the values of the <code>NextRecordName</code> and <code>NextRecordType</code> elements in the response identify the first resource record set in the next group of <code>maxitems</code> resource record sets.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>(Optional) The maximum number of resource records sets to include in the response body for this request. If the response includes more than <code>maxitems</code> resource record sets, the value of the <code>IsTruncated</code> element in the response is <code>true</code>, and the values of the <code>NextRecordName</code> and <code>NextRecordType</code> elements in the response identify the first resource record set in the next group of <code>maxitems</code> resource record sets.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListReusableDelegationSets`.
    ///
    /// <p>Retrieves a list of the reusable delegation sets that are associated with the current Amazon Web Services account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListReusableDelegationSets<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_reusable_delegation_sets_input::Builder,
    }
    impl<C, M, R> ListReusableDelegationSets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListReusableDelegationSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListReusableDelegationSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListReusableDelegationSetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListReusableDelegationSetsInputOperationOutputAlias,
                crate::output::ListReusableDelegationSetsOutput,
                crate::error::ListReusableDelegationSetsError,
                crate::input::ListReusableDelegationSetsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more reusable delegation sets. To get another group, submit another <code>ListReusableDelegationSets</code> request. </p>
        /// <p>For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous response, which is the ID of the first reusable delegation set that Amazon Route 53 will return if you submit another request.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more reusable delegation sets to get.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more reusable delegation sets. To get another group, submit another <code>ListReusableDelegationSets</code> request. </p>
        /// <p>For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous response, which is the ID of the first reusable delegation set that Amazon Route 53 will return if you submit another request.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more reusable delegation sets to get.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The number of reusable delegation sets that you want Amazon Route 53 to return in the response to this request. If you specify a value greater than 100, Route 53 returns only the first 100 reusable delegation sets.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The number of reusable delegation sets that you want Amazon Route 53 to return in the response to this request. If you specify a value greater than 100, Route 53 returns only the first 100 reusable delegation sets.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists tags for one health check or hosted zone. </p>
    /// <p>For information about using tags for cost allocation, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the <i>Billing and Cost Management User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The type of the resource.</p>
        /// <ul>
        /// <li> <p>The resource type for health checks is <code>healthcheck</code>.</p> </li>
        /// <li> <p>The resource type for hosted zones is <code>hostedzone</code>.</p> </li>
        /// </ul>
        pub fn resource_type(mut self, input: crate::model::TagResourceType) -> Self {
            self.inner = self.inner.resource_type(input);
            self
        }
        /// <p>The type of the resource.</p>
        /// <ul>
        /// <li> <p>The resource type for health checks is <code>healthcheck</code>.</p> </li>
        /// <li> <p>The resource type for hosted zones is <code>hostedzone</code>.</p> </li>
        /// </ul>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::TagResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The ID of the resource for which you want to retrieve tags.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The ID of the resource for which you want to retrieve tags.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResources`.
    ///
    /// <p>Lists tags for up to 10 health checks or hosted zones.</p>
    /// <p>For information about using tags for cost allocation, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the <i>Billing and Cost Management User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResources<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resources_input::Builder,
    }
    impl<C, M, R> ListTagsForResources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourcesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourcesInputOperationOutputAlias,
                crate::output::ListTagsForResourcesOutput,
                crate::error::ListTagsForResourcesError,
                crate::input::ListTagsForResourcesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The type of the resources.</p>
        /// <ul>
        /// <li> <p>The resource type for health checks is <code>healthcheck</code>.</p> </li>
        /// <li> <p>The resource type for hosted zones is <code>hostedzone</code>.</p> </li>
        /// </ul>
        pub fn resource_type(mut self, input: crate::model::TagResourceType) -> Self {
            self.inner = self.inner.resource_type(input);
            self
        }
        /// <p>The type of the resources.</p>
        /// <ul>
        /// <li> <p>The resource type for health checks is <code>healthcheck</code>.</p> </li>
        /// <li> <p>The resource type for hosted zones is <code>hostedzone</code>.</p> </li>
        /// </ul>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::TagResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// Appends an item to `ResourceIds`.
        ///
        /// To override the contents of this collection use [`set_resource_ids`](Self::set_resource_ids).
        ///
        /// <p>A complex type that contains the ResourceId element for each resource for which you want to get a list of tags.</p>
        pub fn resource_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_ids(input.into());
            self
        }
        /// <p>A complex type that contains the ResourceId element for each resource for which you want to get a list of tags.</p>
        pub fn set_resource_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTrafficPolicies`.
    ///
    /// <p>Gets information about the latest version for every traffic policy that is associated with the current Amazon Web Services account. Policies are listed in the order that they were created in. </p>
    /// <p>For information about how of deleting a traffic policy affects the response from <code>ListTrafficPolicies</code>, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteTrafficPolicy.html">DeleteTrafficPolicy</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTrafficPolicies<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_traffic_policies_input::Builder,
    }
    impl<C, M, R> ListTrafficPolicies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTrafficPolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTrafficPoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTrafficPoliciesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTrafficPoliciesInputOperationOutputAlias,
                crate::output::ListTrafficPoliciesOutput,
                crate::error::ListTrafficPoliciesError,
                crate::input::ListTrafficPoliciesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>(Conditional) For your first request to <code>ListTrafficPolicies</code>, don't include the <code>TrafficPolicyIdMarker</code> parameter.</p>
        /// <p>If you have more traffic policies than the value of <code>MaxItems</code>, <code>ListTrafficPolicies</code> returns only the first <code>MaxItems</code> traffic policies. To get the next group of policies, submit another request to <code>ListTrafficPolicies</code>. For the value of <code>TrafficPolicyIdMarker</code>, specify the value of <code>TrafficPolicyIdMarker</code> that was returned in the previous response.</p>
        pub fn traffic_policy_id_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.traffic_policy_id_marker(input.into());
            self
        }
        /// <p>(Conditional) For your first request to <code>ListTrafficPolicies</code>, don't include the <code>TrafficPolicyIdMarker</code> parameter.</p>
        /// <p>If you have more traffic policies than the value of <code>MaxItems</code>, <code>ListTrafficPolicies</code> returns only the first <code>MaxItems</code> traffic policies. To get the next group of policies, submit another request to <code>ListTrafficPolicies</code>. For the value of <code>TrafficPolicyIdMarker</code>, specify the value of <code>TrafficPolicyIdMarker</code> that was returned in the previous response.</p>
        pub fn set_traffic_policy_id_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_traffic_policy_id_marker(input);
            self
        }
        /// <p>(Optional) The maximum number of traffic policies that you want Amazon Route 53 to return in response to this request. If you have more than <code>MaxItems</code> traffic policies, the value of <code>IsTruncated</code> in the response is <code>true</code>, and the value of <code>TrafficPolicyIdMarker</code> is the ID of the first traffic policy that Route 53 will return if you submit another request.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>(Optional) The maximum number of traffic policies that you want Amazon Route 53 to return in response to this request. If you have more than <code>MaxItems</code> traffic policies, the value of <code>IsTruncated</code> in the response is <code>true</code>, and the value of <code>TrafficPolicyIdMarker</code> is the ID of the first traffic policy that Route 53 will return if you submit another request.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTrafficPolicyInstances`.
    ///
    /// <p>Gets information about the traffic policy instances that you created by using the current Amazon Web Services account.</p> <note>
    /// <p>After you submit an <code>UpdateTrafficPolicyInstance</code> request, there's a brief delay while Amazon Route 53 creates the resource record sets that are specified in the traffic policy definition. For more information, see the <code>State</code> response element.</p>
    /// </note>
    /// <p>Route 53 returns a maximum of 100 items in each response. If you have a lot of traffic policy instances, you can use the <code>MaxItems</code> parameter to list them in groups of up to 100.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTrafficPolicyInstances<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_traffic_policy_instances_input::Builder,
    }
    impl<C, M, R> ListTrafficPolicyInstances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTrafficPolicyInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTrafficPolicyInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTrafficPolicyInstancesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTrafficPolicyInstancesInputOperationOutputAlias,
                crate::output::ListTrafficPolicyInstancesOutput,
                crate::error::ListTrafficPolicyInstancesError,
                crate::input::ListTrafficPolicyInstancesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>HostedZoneId</code>, specify the value of <code>HostedZoneIdMarker</code> from the previous response, which is the hosted zone ID of the first traffic policy instance in the next group of traffic policy instances.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn hosted_zone_id_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id_marker(input.into());
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>HostedZoneId</code>, specify the value of <code>HostedZoneIdMarker</code> from the previous response, which is the hosted zone ID of the first traffic policy instance in the next group of traffic policy instances.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn set_hosted_zone_id_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id_marker(input);
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancename</code>, specify the value of <code>TrafficPolicyInstanceNameMarker</code> from the previous response, which is the name of the first traffic policy instance in the next group of traffic policy instances.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn traffic_policy_instance_name_marker(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.traffic_policy_instance_name_marker(input.into());
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancename</code>, specify the value of <code>TrafficPolicyInstanceNameMarker</code> from the previous response, which is the name of the first traffic policy instance in the next group of traffic policy instances.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn set_traffic_policy_instance_name_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_traffic_policy_instance_name_marker(input);
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancetype</code>, specify the value of <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the type of the first traffic policy instance in the next group of traffic policy instances.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn traffic_policy_instance_type_marker(mut self, input: crate::model::RrType) -> Self {
            self.inner = self.inner.traffic_policy_instance_type_marker(input);
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancetype</code>, specify the value of <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the type of the first traffic policy instance in the next group of traffic policy instances.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn set_traffic_policy_instance_type_marker(
            mut self,
            input: std::option::Option<crate::model::RrType>,
        ) -> Self {
            self.inner = self.inner.set_traffic_policy_instance_type_marker(input);
            self
        }
        /// <p>The maximum number of traffic policy instances that you want Amazon Route 53 to return in response to a <code>ListTrafficPolicyInstances</code> request. If you have more than <code>MaxItems</code> traffic policy instances, the value of the <code>IsTruncated</code> element in the response is <code>true</code>, and the values of <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code> represent the first traffic policy instance in the next group of <code>MaxItems</code> traffic policy instances.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The maximum number of traffic policy instances that you want Amazon Route 53 to return in response to a <code>ListTrafficPolicyInstances</code> request. If you have more than <code>MaxItems</code> traffic policy instances, the value of the <code>IsTruncated</code> element in the response is <code>true</code>, and the values of <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code> represent the first traffic policy instance in the next group of <code>MaxItems</code> traffic policy instances.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTrafficPolicyInstancesByHostedZone`.
    ///
    /// <p>Gets information about the traffic policy instances that you created in a specified hosted zone.</p> <note>
    /// <p>After you submit a <code>CreateTrafficPolicyInstance</code> or an <code>UpdateTrafficPolicyInstance</code> request, there's a brief delay while Amazon Route 53 creates the resource record sets that are specified in the traffic policy definition. For more information, see the <code>State</code> response element.</p>
    /// </note>
    /// <p>Route 53 returns a maximum of 100 items in each response. If you have a lot of traffic policy instances, you can use the <code>MaxItems</code> parameter to list them in groups of up to 100.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTrafficPolicyInstancesByHostedZone<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_traffic_policy_instances_by_hosted_zone_input::Builder,
    }
    impl<C, M, R> ListTrafficPolicyInstancesByHostedZone<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTrafficPolicyInstancesByHostedZone`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTrafficPolicyInstancesByHostedZoneOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListTrafficPolicyInstancesByHostedZoneError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTrafficPolicyInstancesByHostedZoneInputOperationOutputAlias,
                crate::output::ListTrafficPolicyInstancesByHostedZoneOutput,
                crate::error::ListTrafficPolicyInstancesByHostedZoneError,
                crate::input::ListTrafficPolicyInstancesByHostedZoneInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the hosted zone that you want to list traffic policy instances for.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>The ID of the hosted zone that you want to list traffic policy instances for.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response is true, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancename</code>, specify the value of <code>TrafficPolicyInstanceNameMarker</code> from the previous response, which is the name of the first traffic policy instance in the next group of traffic policy instances.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn traffic_policy_instance_name_marker(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.traffic_policy_instance_name_marker(input.into());
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response is true, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancename</code>, specify the value of <code>TrafficPolicyInstanceNameMarker</code> from the previous response, which is the name of the first traffic policy instance in the next group of traffic policy instances.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn set_traffic_policy_instance_name_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_traffic_policy_instance_name_marker(input);
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response is true, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancetype</code>, specify the value of <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the type of the first traffic policy instance in the next group of traffic policy instances.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn traffic_policy_instance_type_marker(mut self, input: crate::model::RrType) -> Self {
            self.inner = self.inner.traffic_policy_instance_type_marker(input);
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response is true, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancetype</code>, specify the value of <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the type of the first traffic policy instance in the next group of traffic policy instances.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn set_traffic_policy_instance_type_marker(
            mut self,
            input: std::option::Option<crate::model::RrType>,
        ) -> Self {
            self.inner = self.inner.set_traffic_policy_instance_type_marker(input);
            self
        }
        /// <p>The maximum number of traffic policy instances to be included in the response body for this request. If you have more than <code>MaxItems</code> traffic policy instances, the value of the <code>IsTruncated</code> element in the response is <code>true</code>, and the values of <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code> represent the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The maximum number of traffic policy instances to be included in the response body for this request. If you have more than <code>MaxItems</code> traffic policy instances, the value of the <code>IsTruncated</code> element in the response is <code>true</code>, and the values of <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code> represent the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTrafficPolicyInstancesByPolicy`.
    ///
    /// <p>Gets information about the traffic policy instances that you created by using a specify traffic policy version.</p> <note>
    /// <p>After you submit a <code>CreateTrafficPolicyInstance</code> or an <code>UpdateTrafficPolicyInstance</code> request, there's a brief delay while Amazon Route 53 creates the resource record sets that are specified in the traffic policy definition. For more information, see the <code>State</code> response element.</p>
    /// </note>
    /// <p>Route 53 returns a maximum of 100 items in each response. If you have a lot of traffic policy instances, you can use the <code>MaxItems</code> parameter to list them in groups of up to 100.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTrafficPolicyInstancesByPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_traffic_policy_instances_by_policy_input::Builder,
    }
    impl<C, M, R> ListTrafficPolicyInstancesByPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTrafficPolicyInstancesByPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTrafficPolicyInstancesByPolicyOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListTrafficPolicyInstancesByPolicyError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTrafficPolicyInstancesByPolicyInputOperationOutputAlias,
                crate::output::ListTrafficPolicyInstancesByPolicyOutput,
                crate::error::ListTrafficPolicyInstancesByPolicyError,
                crate::input::ListTrafficPolicyInstancesByPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the traffic policy for which you want to list traffic policy instances.</p>
        pub fn traffic_policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.traffic_policy_id(input.into());
            self
        }
        /// <p>The ID of the traffic policy for which you want to list traffic policy instances.</p>
        pub fn set_traffic_policy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_traffic_policy_id(input);
            self
        }
        /// <p>The version of the traffic policy for which you want to list traffic policy instances. The version must be associated with the traffic policy that is specified by <code>TrafficPolicyId</code>.</p>
        pub fn traffic_policy_version(mut self, input: i32) -> Self {
            self.inner = self.inner.traffic_policy_version(input);
            self
        }
        /// <p>The version of the traffic policy for which you want to list traffic policy instances. The version must be associated with the traffic policy that is specified by <code>TrafficPolicyId</code>.</p>
        pub fn set_traffic_policy_version(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_traffic_policy_version(input);
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstancesByPolicy</code> request. </p>
        /// <p>For the value of <code>hostedzoneid</code>, specify the value of <code>HostedZoneIdMarker</code> from the previous response, which is the hosted zone ID of the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn hosted_zone_id_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id_marker(input.into());
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstancesByPolicy</code> request. </p>
        /// <p>For the value of <code>hostedzoneid</code>, specify the value of <code>HostedZoneIdMarker</code> from the previous response, which is the hosted zone ID of the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn set_hosted_zone_id_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id_marker(input);
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstancesByPolicy</code> request.</p>
        /// <p>For the value of <code>trafficpolicyinstancename</code>, specify the value of <code>TrafficPolicyInstanceNameMarker</code> from the previous response, which is the name of the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn traffic_policy_instance_name_marker(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.traffic_policy_instance_name_marker(input.into());
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstancesByPolicy</code> request.</p>
        /// <p>For the value of <code>trafficpolicyinstancename</code>, specify the value of <code>TrafficPolicyInstanceNameMarker</code> from the previous response, which is the name of the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn set_traffic_policy_instance_name_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_traffic_policy_instance_name_marker(input);
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstancesByPolicy</code> request.</p>
        /// <p>For the value of <code>trafficpolicyinstancetype</code>, specify the value of <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the name of the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn traffic_policy_instance_type_marker(mut self, input: crate::model::RrType) -> Self {
            self.inner = self.inner.traffic_policy_instance_type_marker(input);
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstancesByPolicy</code> request.</p>
        /// <p>For the value of <code>trafficpolicyinstancetype</code>, specify the value of <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the name of the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn set_traffic_policy_instance_type_marker(
            mut self,
            input: std::option::Option<crate::model::RrType>,
        ) -> Self {
            self.inner = self.inner.set_traffic_policy_instance_type_marker(input);
            self
        }
        /// <p>The maximum number of traffic policy instances to be included in the response body for this request. If you have more than <code>MaxItems</code> traffic policy instances, the value of the <code>IsTruncated</code> element in the response is <code>true</code>, and the values of <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code> represent the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The maximum number of traffic policy instances to be included in the response body for this request. If you have more than <code>MaxItems</code> traffic policy instances, the value of the <code>IsTruncated</code> element in the response is <code>true</code>, and the values of <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code> represent the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTrafficPolicyVersions`.
    ///
    /// <p>Gets information about all of the versions for a specified traffic policy.</p>
    /// <p>Traffic policy versions are listed in numerical order by <code>VersionNumber</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTrafficPolicyVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_traffic_policy_versions_input::Builder,
    }
    impl<C, M, R> ListTrafficPolicyVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTrafficPolicyVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTrafficPolicyVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTrafficPolicyVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTrafficPolicyVersionsInputOperationOutputAlias,
                crate::output::ListTrafficPolicyVersionsOutput,
                crate::error::ListTrafficPolicyVersionsError,
                crate::input::ListTrafficPolicyVersionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specify the value of <code>Id</code> of the traffic policy for which you want to list all versions.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>Specify the value of <code>Id</code> of the traffic policy for which you want to list all versions.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>For your first request to <code>ListTrafficPolicyVersions</code>, don't include the <code>TrafficPolicyVersionMarker</code> parameter.</p>
        /// <p>If you have more traffic policy versions than the value of <code>MaxItems</code>, <code>ListTrafficPolicyVersions</code> returns only the first group of <code>MaxItems</code> versions. To get more traffic policy versions, submit another <code>ListTrafficPolicyVersions</code> request. For the value of <code>TrafficPolicyVersionMarker</code>, specify the value of <code>TrafficPolicyVersionMarker</code> in the previous response.</p>
        pub fn traffic_policy_version_marker(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.traffic_policy_version_marker(input.into());
            self
        }
        /// <p>For your first request to <code>ListTrafficPolicyVersions</code>, don't include the <code>TrafficPolicyVersionMarker</code> parameter.</p>
        /// <p>If you have more traffic policy versions than the value of <code>MaxItems</code>, <code>ListTrafficPolicyVersions</code> returns only the first group of <code>MaxItems</code> versions. To get more traffic policy versions, submit another <code>ListTrafficPolicyVersions</code> request. For the value of <code>TrafficPolicyVersionMarker</code>, specify the value of <code>TrafficPolicyVersionMarker</code> in the previous response.</p>
        pub fn set_traffic_policy_version_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_traffic_policy_version_marker(input);
            self
        }
        /// <p>The maximum number of traffic policy versions that you want Amazon Route 53 to include in the response body for this request. If the specified traffic policy has more than <code>MaxItems</code> versions, the value of <code>IsTruncated</code> in the response is <code>true</code>, and the value of the <code>TrafficPolicyVersionMarker</code> element is the ID of the first version that Route 53 will return if you submit another request.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The maximum number of traffic policy versions that you want Amazon Route 53 to include in the response body for this request. If the specified traffic policy has more than <code>MaxItems</code> versions, the value of <code>IsTruncated</code> in the response is <code>true</code>, and the value of the <code>TrafficPolicyVersionMarker</code> element is the ID of the first version that Route 53 will return if you submit another request.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListVPCAssociationAuthorizations`.
    ///
    /// <p>Gets a list of the VPCs that were created by other accounts and that can be associated with a specified hosted zone because you've submitted one or more <code>CreateVPCAssociationAuthorization</code> requests. </p>
    /// <p>The response includes a <code>VPCs</code> element with a <code>VPC</code> child element for each VPC that can be associated with the hosted zone.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListVPCAssociationAuthorizations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_vpc_association_authorizations_input::Builder,
    }
    impl<C, M, R> ListVPCAssociationAuthorizations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListVPCAssociationAuthorizations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListVpcAssociationAuthorizationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListVPCAssociationAuthorizationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListVpcAssociationAuthorizationsInputOperationOutputAlias,
                crate::output::ListVpcAssociationAuthorizationsOutput,
                crate::error::ListVPCAssociationAuthorizationsError,
                crate::input::ListVpcAssociationAuthorizationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the hosted zone for which you want a list of VPCs that can be associated with the hosted zone.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>The ID of the hosted zone for which you want a list of VPCs that can be associated with the hosted zone.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
        /// <p> <i>Optional</i>: If a response includes a <code>NextToken</code> element, there are more VPCs that can be associated with the specified hosted zone. To get the next page of results, submit another request, and include the value of <code>NextToken</code> from the response in the <code>nexttoken</code> parameter in another <code>ListVPCAssociationAuthorizations</code> request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> <i>Optional</i>: If a response includes a <code>NextToken</code> element, there are more VPCs that can be associated with the specified hosted zone. To get the next page of results, submit another request, and include the value of <code>NextToken</code> from the response in the <code>nexttoken</code> parameter in another <code>ListVPCAssociationAuthorizations</code> request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> <i>Optional</i>: An integer that specifies the maximum number of VPCs that you want Amazon Route 53 to return. If you don't specify a value for <code>MaxResults</code>, Route 53 returns up to 50 VPCs per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> <i>Optional</i>: An integer that specifies the maximum number of VPCs that you want Amazon Route 53 to return. If you don't specify a value for <code>MaxResults</code>, Route 53 returns up to 50 VPCs per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TestDNSAnswer`.
    ///
    /// <p>Gets the value that Amazon Route 53 returns in response to a DNS request for a specified record name and type. You can optionally specify the IP address of a DNS resolver, an EDNS0 client subnet IP address, and a subnet mask. </p>
    /// <p>This call only supports querying public hosted zones.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TestDNSAnswer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::test_dns_answer_input::Builder,
    }
    impl<C, M, R> TestDNSAnswer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TestDNSAnswer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TestDnsAnswerOutput,
            aws_smithy_http::result::SdkError<crate::error::TestDNSAnswerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TestDnsAnswerInputOperationOutputAlias,
                crate::output::TestDnsAnswerOutput,
                crate::error::TestDNSAnswerError,
                crate::input::TestDnsAnswerInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the hosted zone that you want Amazon Route 53 to simulate a query for.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hosted_zone_id(input.into());
            self
        }
        /// <p>The ID of the hosted zone that you want Amazon Route 53 to simulate a query for.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hosted_zone_id(input);
            self
        }
        /// <p>The name of the resource record set that you want Amazon Route 53 to simulate a query for.</p>
        pub fn record_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.record_name(input.into());
            self
        }
        /// <p>The name of the resource record set that you want Amazon Route 53 to simulate a query for.</p>
        pub fn set_record_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_record_name(input);
            self
        }
        /// <p>The type of the resource record set.</p>
        pub fn record_type(mut self, input: crate::model::RrType) -> Self {
            self.inner = self.inner.record_type(input);
            self
        }
        /// <p>The type of the resource record set.</p>
        pub fn set_record_type(mut self, input: std::option::Option<crate::model::RrType>) -> Self {
            self.inner = self.inner.set_record_type(input);
            self
        }
        /// <p>If you want to simulate a request from a specific DNS resolver, specify the IP address for that resolver. If you omit this value, <code>TestDnsAnswer</code> uses the IP address of a DNS resolver in the Amazon Web Services US East (N. Virginia) Region (<code>us-east-1</code>).</p>
        pub fn resolver_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolver_ip(input.into());
            self
        }
        /// <p>If you want to simulate a request from a specific DNS resolver, specify the IP address for that resolver. If you omit this value, <code>TestDnsAnswer</code> uses the IP address of a DNS resolver in the Amazon Web Services US East (N. Virginia) Region (<code>us-east-1</code>).</p>
        pub fn set_resolver_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resolver_ip(input);
            self
        }
        /// <p>If the resolver that you specified for resolverip supports EDNS0, specify the IPv4 or IPv6 address of a client in the applicable location, for example, <code>192.0.2.44</code> or <code>2001:db8:85a3::8a2e:370:7334</code>.</p>
        pub fn edns0_client_subnet_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.edns0_client_subnet_ip(input.into());
            self
        }
        /// <p>If the resolver that you specified for resolverip supports EDNS0, specify the IPv4 or IPv6 address of a client in the applicable location, for example, <code>192.0.2.44</code> or <code>2001:db8:85a3::8a2e:370:7334</code>.</p>
        pub fn set_edns0_client_subnet_ip(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_edns0_client_subnet_ip(input);
            self
        }
        /// <p>If you specify an IP address for <code>edns0clientsubnetip</code>, you can optionally specify the number of bits of the IP address that you want the checking tool to include in the DNS query. For example, if you specify <code>192.0.2.44</code> for <code>edns0clientsubnetip</code> and <code>24</code> for <code>edns0clientsubnetmask</code>, the checking tool will simulate a request from 192.0.2.0/24. The default value is 24 bits for IPv4 addresses and 64 bits for IPv6 addresses.</p>
        /// <p>The range of valid values depends on whether <code>edns0clientsubnetip</code> is an IPv4 or an IPv6 address:</p>
        /// <ul>
        /// <li> <p> <b>IPv4</b>: Specify a value between 0 and 32</p> </li>
        /// <li> <p> <b>IPv6</b>: Specify a value between 0 and 128</p> </li>
        /// </ul>
        pub fn edns0_client_subnet_mask(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.edns0_client_subnet_mask(input.into());
            self
        }
        /// <p>If you specify an IP address for <code>edns0clientsubnetip</code>, you can optionally specify the number of bits of the IP address that you want the checking tool to include in the DNS query. For example, if you specify <code>192.0.2.44</code> for <code>edns0clientsubnetip</code> and <code>24</code> for <code>edns0clientsubnetmask</code>, the checking tool will simulate a request from 192.0.2.0/24. The default value is 24 bits for IPv4 addresses and 64 bits for IPv6 addresses.</p>
        /// <p>The range of valid values depends on whether <code>edns0clientsubnetip</code> is an IPv4 or an IPv6 address:</p>
        /// <ul>
        /// <li> <p> <b>IPv4</b>: Specify a value between 0 and 32</p> </li>
        /// <li> <p> <b>IPv6</b>: Specify a value between 0 and 128</p> </li>
        /// </ul>
        pub fn set_edns0_client_subnet_mask(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_edns0_client_subnet_mask(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateHealthCheck`.
    ///
    /// <p>Updates an existing health check. Note that some values can't be updated. </p>
    /// <p>For more information about updating health checks, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/health-checks-creating-deleting.html">Creating, Updating, and Deleting Health Checks</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateHealthCheck<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_health_check_input::Builder,
    }
    impl<C, M, R> UpdateHealthCheck<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateHealthCheck`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateHealthCheckOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateHealthCheckError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateHealthCheckInputOperationOutputAlias,
                crate::output::UpdateHealthCheckOutput,
                crate::error::UpdateHealthCheckError,
                crate::input::UpdateHealthCheckInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the health check for which you want detailed information. When you created the health check, <code>CreateHealthCheck</code> returned the ID in the response, in the <code>HealthCheckId</code> element.</p>
        pub fn health_check_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.health_check_id(input.into());
            self
        }
        /// <p>The ID for the health check for which you want detailed information. When you created the health check, <code>CreateHealthCheck</code> returned the ID in the response, in the <code>HealthCheckId</code> element.</p>
        pub fn set_health_check_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_health_check_id(input);
            self
        }
        /// <p>A sequential counter that Amazon Route 53 sets to <code>1</code> when you create a health check and increments by 1 each time you update settings for the health check.</p>
        /// <p>We recommend that you use <code>GetHealthCheck</code> or <code>ListHealthChecks</code> to get the current value of <code>HealthCheckVersion</code> for the health check that you want to update, and that you include that value in your <code>UpdateHealthCheck</code> request. This prevents Route 53 from overwriting an intervening update:</p>
        /// <ul>
        /// <li> <p>If the value in the <code>UpdateHealthCheck</code> request matches the value of <code>HealthCheckVersion</code> in the health check, Route 53 updates the health check with the new settings.</p> </li>
        /// <li> <p>If the value of <code>HealthCheckVersion</code> in the health check is greater, the health check was changed after you got the version number. Route 53 does not update the health check, and it returns a <code>HealthCheckVersionMismatch</code> error.</p> </li>
        /// </ul>
        pub fn health_check_version(mut self, input: i64) -> Self {
            self.inner = self.inner.health_check_version(input);
            self
        }
        /// <p>A sequential counter that Amazon Route 53 sets to <code>1</code> when you create a health check and increments by 1 each time you update settings for the health check.</p>
        /// <p>We recommend that you use <code>GetHealthCheck</code> or <code>ListHealthChecks</code> to get the current value of <code>HealthCheckVersion</code> for the health check that you want to update, and that you include that value in your <code>UpdateHealthCheck</code> request. This prevents Route 53 from overwriting an intervening update:</p>
        /// <ul>
        /// <li> <p>If the value in the <code>UpdateHealthCheck</code> request matches the value of <code>HealthCheckVersion</code> in the health check, Route 53 updates the health check with the new settings.</p> </li>
        /// <li> <p>If the value of <code>HealthCheckVersion</code> in the health check is greater, the health check was changed after you got the version number. Route 53 does not update the health check, and it returns a <code>HealthCheckVersionMismatch</code> error.</p> </li>
        /// </ul>
        pub fn set_health_check_version(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_health_check_version(input);
            self
        }
        /// <p>The IPv4 or IPv6 IP address for the endpoint that you want Amazon Route 53 to perform health checks on. If you don't specify a value for <code>IPAddress</code>, Route 53 sends a DNS request to resolve the domain name that you specify in <code>FullyQualifiedDomainName</code> at the interval that you specify in <code>RequestInterval</code>. Using an IP address that is returned by DNS, Route 53 then checks the health of the endpoint.</p>
        /// <p>Use one of the following formats for the value of <code>IPAddress</code>: </p>
        /// <ul>
        /// <li> <p> <b>IPv4 address</b>: four values between 0 and 255, separated by periods (.), for example, <code>192.0.2.44</code>.</p> </li>
        /// <li> <p> <b>IPv6 address</b>: eight groups of four hexadecimal values, separated by colons (:), for example, <code>2001:0db8:85a3:0000:0000:abcd:0001:2345</code>. You can also shorten IPv6 addresses as described in RFC 5952, for example, <code>2001:db8:85a3::abcd:1:2345</code>.</p> </li>
        /// </ul>
        /// <p>If the endpoint is an EC2 instance, we recommend that you create an Elastic IP address, associate it with your EC2 instance, and specify the Elastic IP address for <code>IPAddress</code>. This ensures that the IP address of your instance never changes. For more information, see the applicable documentation:</p>
        /// <ul>
        /// <li> <p>Linux: <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses (EIP)</a> in the <i>Amazon EC2 User Guide for Linux Instances</i> </p> </li>
        /// <li> <p>Windows: <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses (EIP)</a> in the <i>Amazon EC2 User Guide for Windows Instances</i> </p> </li>
        /// </ul> <note>
        /// <p>If a health check already has a value for <code>IPAddress</code>, you can change the value. However, you can't update an existing health check to add or remove the value of <code>IPAddress</code>. </p>
        /// </note>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-FullyQualifiedDomainName">FullyQualifiedDomainName</a>. </p>
        /// <p>Constraints: Route 53 can't check the health of endpoints for which the IP address is in local, private, non-routable, or multicast ranges. For more information about IP addresses for which you can't create health checks, see the following documents:</p>
        /// <ul>
        /// <li> <p> <a href="https://tools.ietf.org/html/rfc5735">RFC 5735, Special Use IPv4 Addresses</a> </p> </li>
        /// <li> <p> <a href="https://tools.ietf.org/html/rfc6598">RFC 6598, IANA-Reserved IPv4 Prefix for Shared Address Space</a> </p> </li>
        /// <li> <p> <a href="https://tools.ietf.org/html/rfc5156">RFC 5156, Special-Use IPv6 Addresses</a> </p> </li>
        /// </ul>
        pub fn ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ip_address(input.into());
            self
        }
        /// <p>The IPv4 or IPv6 IP address for the endpoint that you want Amazon Route 53 to perform health checks on. If you don't specify a value for <code>IPAddress</code>, Route 53 sends a DNS request to resolve the domain name that you specify in <code>FullyQualifiedDomainName</code> at the interval that you specify in <code>RequestInterval</code>. Using an IP address that is returned by DNS, Route 53 then checks the health of the endpoint.</p>
        /// <p>Use one of the following formats for the value of <code>IPAddress</code>: </p>
        /// <ul>
        /// <li> <p> <b>IPv4 address</b>: four values between 0 and 255, separated by periods (.), for example, <code>192.0.2.44</code>.</p> </li>
        /// <li> <p> <b>IPv6 address</b>: eight groups of four hexadecimal values, separated by colons (:), for example, <code>2001:0db8:85a3:0000:0000:abcd:0001:2345</code>. You can also shorten IPv6 addresses as described in RFC 5952, for example, <code>2001:db8:85a3::abcd:1:2345</code>.</p> </li>
        /// </ul>
        /// <p>If the endpoint is an EC2 instance, we recommend that you create an Elastic IP address, associate it with your EC2 instance, and specify the Elastic IP address for <code>IPAddress</code>. This ensures that the IP address of your instance never changes. For more information, see the applicable documentation:</p>
        /// <ul>
        /// <li> <p>Linux: <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses (EIP)</a> in the <i>Amazon EC2 User Guide for Linux Instances</i> </p> </li>
        /// <li> <p>Windows: <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses (EIP)</a> in the <i>Amazon EC2 User Guide for Windows Instances</i> </p> </li>
        /// </ul> <note>
        /// <p>If a health check already has a value for <code>IPAddress</code>, you can change the value. However, you can't update an existing health check to add or remove the value of <code>IPAddress</code>. </p>
        /// </note>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-FullyQualifiedDomainName">FullyQualifiedDomainName</a>. </p>
        /// <p>Constraints: Route 53 can't check the health of endpoints for which the IP address is in local, private, non-routable, or multicast ranges. For more information about IP addresses for which you can't create health checks, see the following documents:</p>
        /// <ul>
        /// <li> <p> <a href="https://tools.ietf.org/html/rfc5735">RFC 5735, Special Use IPv4 Addresses</a> </p> </li>
        /// <li> <p> <a href="https://tools.ietf.org/html/rfc6598">RFC 6598, IANA-Reserved IPv4 Prefix for Shared Address Space</a> </p> </li>
        /// <li> <p> <a href="https://tools.ietf.org/html/rfc5156">RFC 5156, Special-Use IPv6 Addresses</a> </p> </li>
        /// </ul>
        pub fn set_ip_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ip_address(input);
            self
        }
        /// <p>The port on the endpoint that you want Amazon Route 53 to perform health checks on.</p> <note>
        /// <p>Don't specify a value for <code>Port</code> when you specify a value for <code>Type</code> of <code>CLOUDWATCH_METRIC</code> or <code>CALCULATED</code>.</p>
        /// </note>
        pub fn port(mut self, input: i32) -> Self {
            self.inner = self.inner.port(input);
            self
        }
        /// <p>The port on the endpoint that you want Amazon Route 53 to perform health checks on.</p> <note>
        /// <p>Don't specify a value for <code>Port</code> when you specify a value for <code>Type</code> of <code>CLOUDWATCH_METRIC</code> or <code>CALCULATED</code>.</p>
        /// </note>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_port(input);
            self
        }
        /// <p>The path that you want Amazon Route 53 to request when performing health checks. The path can be any value for which your endpoint will return an HTTP status code of 2xx or 3xx when the endpoint is healthy, for example the file /docs/route53-health-check.html. You can also include query string parameters, for example, <code>/welcome.html?language=jp&amp;login=y</code>. </p>
        /// <p>Specify this value only if you want to change it.</p>
        pub fn resource_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_path(input.into());
            self
        }
        /// <p>The path that you want Amazon Route 53 to request when performing health checks. The path can be any value for which your endpoint will return an HTTP status code of 2xx or 3xx when the endpoint is healthy, for example the file /docs/route53-health-check.html. You can also include query string parameters, for example, <code>/welcome.html?language=jp&amp;login=y</code>. </p>
        /// <p>Specify this value only if you want to change it.</p>
        pub fn set_resource_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_path(input);
            self
        }
        /// <p>Amazon Route 53 behavior depends on whether you specify a value for <code>IPAddress</code>.</p> <note>
        /// <p>If a health check already has a value for <code>IPAddress</code>, you can change the value. However, you can't update an existing health check to add or remove the value of <code>IPAddress</code>. </p>
        /// </note>
        /// <p> <b>If you specify a value for</b> <code>IPAddress</code>:</p>
        /// <p>Route 53 sends health check requests to the specified IPv4 or IPv6 address and passes the value of <code>FullyQualifiedDomainName</code> in the <code>Host</code> header for all health checks except TCP health checks. This is typically the fully qualified DNS name of the endpoint on which you want Route 53 to perform health checks.</p>
        /// <p>When Route 53 checks the health of an endpoint, here is how it constructs the <code>Host</code> header:</p>
        /// <ul>
        /// <li> <p>If you specify a value of <code>80</code> for <code>Port</code> and <code>HTTP</code> or <code>HTTP_STR_MATCH</code> for <code>Type</code>, Route 53 passes the value of <code>FullyQualifiedDomainName</code> to the endpoint in the <code>Host</code> header.</p> </li>
        /// <li> <p>If you specify a value of <code>443</code> for <code>Port</code> and <code>HTTPS</code> or <code>HTTPS_STR_MATCH</code> for <code>Type</code>, Route 53 passes the value of <code>FullyQualifiedDomainName</code> to the endpoint in the <code>Host</code> header.</p> </li>
        /// <li> <p>If you specify another value for <code>Port</code> and any value except <code>TCP</code> for <code>Type</code>, Route 53 passes <i> <code>FullyQualifiedDomainName</code>:<code>Port</code> </i> to the endpoint in the <code>Host</code> header.</p> </li>
        /// </ul>
        /// <p>If you don't specify a value for <code>FullyQualifiedDomainName</code>, Route 53 substitutes the value of <code>IPAddress</code> in the <code>Host</code> header in each of the above cases.</p>
        /// <p> <b>If you don't specify a value for</b> <code>IPAddress</code>:</p>
        /// <p>If you don't specify a value for <code>IPAddress</code>, Route 53 sends a DNS request to the domain that you specify in <code>FullyQualifiedDomainName</code> at the interval you specify in <code>RequestInterval</code>. Using an IPv4 address that is returned by DNS, Route 53 then checks the health of the endpoint.</p> <note>
        /// <p>If you don't specify a value for <code>IPAddress</code>, Route 53 uses only IPv4 to send health checks to the endpoint. If there's no resource record set with a type of A for the name that you specify for <code>FullyQualifiedDomainName</code>, the health check fails with a "DNS resolution failed" error.</p>
        /// </note>
        /// <p>If you want to check the health of weighted, latency, or failover resource record sets and you choose to specify the endpoint only by <code>FullyQualifiedDomainName</code>, we recommend that you create a separate health check for each endpoint. For example, create a health check for each HTTP server that is serving content for www.example.com. For the value of <code>FullyQualifiedDomainName</code>, specify the domain name of the server (such as <code>us-east-2-www.example.com</code>), not the name of the resource record sets (www.example.com).</p> <important>
        /// <p>In this configuration, if the value of <code>FullyQualifiedDomainName</code> matches the name of the resource record sets and you then associate the health check with those resource record sets, health check results will be unpredictable.</p>
        /// </important>
        /// <p>In addition, if the value of <code>Type</code> is <code>HTTP</code>, <code>HTTPS</code>, <code>HTTP_STR_MATCH</code>, or <code>HTTPS_STR_MATCH</code>, Route 53 passes the value of <code>FullyQualifiedDomainName</code> in the <code>Host</code> header, as it does when you specify a value for <code>IPAddress</code>. If the value of <code>Type</code> is <code>TCP</code>, Route 53 doesn't pass a <code>Host</code> header.</p>
        pub fn fully_qualified_domain_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.fully_qualified_domain_name(input.into());
            self
        }
        /// <p>Amazon Route 53 behavior depends on whether you specify a value for <code>IPAddress</code>.</p> <note>
        /// <p>If a health check already has a value for <code>IPAddress</code>, you can change the value. However, you can't update an existing health check to add or remove the value of <code>IPAddress</code>. </p>
        /// </note>
        /// <p> <b>If you specify a value for</b> <code>IPAddress</code>:</p>
        /// <p>Route 53 sends health check requests to the specified IPv4 or IPv6 address and passes the value of <code>FullyQualifiedDomainName</code> in the <code>Host</code> header for all health checks except TCP health checks. This is typically the fully qualified DNS name of the endpoint on which you want Route 53 to perform health checks.</p>
        /// <p>When Route 53 checks the health of an endpoint, here is how it constructs the <code>Host</code> header:</p>
        /// <ul>
        /// <li> <p>If you specify a value of <code>80</code> for <code>Port</code> and <code>HTTP</code> or <code>HTTP_STR_MATCH</code> for <code>Type</code>, Route 53 passes the value of <code>FullyQualifiedDomainName</code> to the endpoint in the <code>Host</code> header.</p> </li>
        /// <li> <p>If you specify a value of <code>443</code> for <code>Port</code> and <code>HTTPS</code> or <code>HTTPS_STR_MATCH</code> for <code>Type</code>, Route 53 passes the value of <code>FullyQualifiedDomainName</code> to the endpoint in the <code>Host</code> header.</p> </li>
        /// <li> <p>If you specify another value for <code>Port</code> and any value except <code>TCP</code> for <code>Type</code>, Route 53 passes <i> <code>FullyQualifiedDomainName</code>:<code>Port</code> </i> to the endpoint in the <code>Host</code> header.</p> </li>
        /// </ul>
        /// <p>If you don't specify a value for <code>FullyQualifiedDomainName</code>, Route 53 substitutes the value of <code>IPAddress</code> in the <code>Host</code> header in each of the above cases.</p>
        /// <p> <b>If you don't specify a value for</b> <code>IPAddress</code>:</p>
        /// <p>If you don't specify a value for <code>IPAddress</code>, Route 53 sends a DNS request to the domain that you specify in <code>FullyQualifiedDomainName</code> at the interval you specify in <code>RequestInterval</code>. Using an IPv4 address that is returned by DNS, Route 53 then checks the health of the endpoint.</p> <note>
        /// <p>If you don't specify a value for <code>IPAddress</code>, Route 53 uses only IPv4 to send health checks to the endpoint. If there's no resource record set with a type of A for the name that you specify for <code>FullyQualifiedDomainName</code>, the health check fails with a "DNS resolution failed" error.</p>
        /// </note>
        /// <p>If you want to check the health of weighted, latency, or failover resource record sets and you choose to specify the endpoint only by <code>FullyQualifiedDomainName</code>, we recommend that you create a separate health check for each endpoint. For example, create a health check for each HTTP server that is serving content for www.example.com. For the value of <code>FullyQualifiedDomainName</code>, specify the domain name of the server (such as <code>us-east-2-www.example.com</code>), not the name of the resource record sets (www.example.com).</p> <important>
        /// <p>In this configuration, if the value of <code>FullyQualifiedDomainName</code> matches the name of the resource record sets and you then associate the health check with those resource record sets, health check results will be unpredictable.</p>
        /// </important>
        /// <p>In addition, if the value of <code>Type</code> is <code>HTTP</code>, <code>HTTPS</code>, <code>HTTP_STR_MATCH</code>, or <code>HTTPS_STR_MATCH</code>, Route 53 passes the value of <code>FullyQualifiedDomainName</code> in the <code>Host</code> header, as it does when you specify a value for <code>IPAddress</code>. If the value of <code>Type</code> is <code>TCP</code>, Route 53 doesn't pass a <code>Host</code> header.</p>
        pub fn set_fully_qualified_domain_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_fully_qualified_domain_name(input);
            self
        }
        /// <p>If the value of <code>Type</code> is <code>HTTP_STR_MATCH</code> or <code>HTTPS_STR_MATCH</code>, the string that you want Amazon Route 53 to search for in the response body from the specified resource. If the string appears in the response body, Route 53 considers the resource healthy. (You can't change the value of <code>Type</code> when you update a health check.)</p>
        pub fn search_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.search_string(input.into());
            self
        }
        /// <p>If the value of <code>Type</code> is <code>HTTP_STR_MATCH</code> or <code>HTTPS_STR_MATCH</code>, the string that you want Amazon Route 53 to search for in the response body from the specified resource. If the string appears in the response body, Route 53 considers the resource healthy. (You can't change the value of <code>Type</code> when you update a health check.)</p>
        pub fn set_search_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_search_string(input);
            self
        }
        /// <p>The number of consecutive health checks that an endpoint must pass or fail for Amazon Route 53 to change the current status of the endpoint from unhealthy to healthy or vice versa. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How Amazon Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>If you don't specify a value for <code>FailureThreshold</code>, the default value is three health checks.</p>
        pub fn failure_threshold(mut self, input: i32) -> Self {
            self.inner = self.inner.failure_threshold(input);
            self
        }
        /// <p>The number of consecutive health checks that an endpoint must pass or fail for Amazon Route 53 to change the current status of the endpoint from unhealthy to healthy or vice versa. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How Amazon Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>If you don't specify a value for <code>FailureThreshold</code>, the default value is three health checks.</p>
        pub fn set_failure_threshold(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_failure_threshold(input);
            self
        }
        /// <p>Specify whether you want Amazon Route 53 to invert the status of a health check, for example, to consider a health check unhealthy when it otherwise would be considered healthy.</p>
        pub fn inverted(mut self, input: bool) -> Self {
            self.inner = self.inner.inverted(input);
            self
        }
        /// <p>Specify whether you want Amazon Route 53 to invert the status of a health check, for example, to consider a health check unhealthy when it otherwise would be considered healthy.</p>
        pub fn set_inverted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_inverted(input);
            self
        }
        /// <p>Stops Route 53 from performing health checks. When you disable a health check, here's what happens:</p>
        /// <ul>
        /// <li> <p> <b>Health checks that check the health of endpoints:</b> Route 53 stops submitting requests to your application, server, or other resource.</p> </li>
        /// <li> <p> <b>Calculated health checks:</b> Route 53 stops aggregating the status of the referenced health checks.</p> </li>
        /// <li> <p> <b>Health checks that monitor CloudWatch alarms:</b> Route 53 stops monitoring the corresponding CloudWatch metrics.</p> </li>
        /// </ul>
        /// <p>After you disable a health check, Route 53 considers the status of the health check to always be healthy. If you configured DNS failover, Route 53 continues to route traffic to the corresponding resources. If you want to stop routing traffic to a resource, change the value of <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-Inverted">Inverted</a>. </p>
        /// <p>Charges for a health check still apply when the health check is disabled. For more information, see <a href="http://aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a>.</p>
        pub fn disabled(mut self, input: bool) -> Self {
            self.inner = self.inner.disabled(input);
            self
        }
        /// <p>Stops Route 53 from performing health checks. When you disable a health check, here's what happens:</p>
        /// <ul>
        /// <li> <p> <b>Health checks that check the health of endpoints:</b> Route 53 stops submitting requests to your application, server, or other resource.</p> </li>
        /// <li> <p> <b>Calculated health checks:</b> Route 53 stops aggregating the status of the referenced health checks.</p> </li>
        /// <li> <p> <b>Health checks that monitor CloudWatch alarms:</b> Route 53 stops monitoring the corresponding CloudWatch metrics.</p> </li>
        /// </ul>
        /// <p>After you disable a health check, Route 53 considers the status of the health check to always be healthy. If you configured DNS failover, Route 53 continues to route traffic to the corresponding resources. If you want to stop routing traffic to a resource, change the value of <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-Inverted">Inverted</a>. </p>
        /// <p>Charges for a health check still apply when the health check is disabled. For more information, see <a href="http://aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a>.</p>
        pub fn set_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_disabled(input);
            self
        }
        /// <p>The number of child health checks that are associated with a <code>CALCULATED</code> health that Amazon Route 53 must consider healthy for the <code>CALCULATED</code> health check to be considered healthy. To specify the child health checks that you want to associate with a <code>CALCULATED</code> health check, use the <code>ChildHealthChecks</code> and <code>ChildHealthCheck</code> elements.</p>
        /// <p>Note the following:</p>
        /// <ul>
        /// <li> <p>If you specify a number greater than the number of child health checks, Route 53 always considers this health check to be unhealthy.</p> </li>
        /// <li> <p>If you specify <code>0</code>, Route 53 always considers this health check to be healthy.</p> </li>
        /// </ul>
        pub fn health_threshold(mut self, input: i32) -> Self {
            self.inner = self.inner.health_threshold(input);
            self
        }
        /// <p>The number of child health checks that are associated with a <code>CALCULATED</code> health that Amazon Route 53 must consider healthy for the <code>CALCULATED</code> health check to be considered healthy. To specify the child health checks that you want to associate with a <code>CALCULATED</code> health check, use the <code>ChildHealthChecks</code> and <code>ChildHealthCheck</code> elements.</p>
        /// <p>Note the following:</p>
        /// <ul>
        /// <li> <p>If you specify a number greater than the number of child health checks, Route 53 always considers this health check to be unhealthy.</p> </li>
        /// <li> <p>If you specify <code>0</code>, Route 53 always considers this health check to be healthy.</p> </li>
        /// </ul>
        pub fn set_health_threshold(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_health_threshold(input);
            self
        }
        /// Appends an item to `ChildHealthChecks`.
        ///
        /// To override the contents of this collection use [`set_child_health_checks`](Self::set_child_health_checks).
        ///
        /// <p>A complex type that contains one <code>ChildHealthCheck</code> element for each health check that you want to associate with a <code>CALCULATED</code> health check.</p>
        pub fn child_health_checks(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.child_health_checks(input.into());
            self
        }
        /// <p>A complex type that contains one <code>ChildHealthCheck</code> element for each health check that you want to associate with a <code>CALCULATED</code> health check.</p>
        pub fn set_child_health_checks(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_child_health_checks(input);
            self
        }
        /// <p>Specify whether you want Amazon Route 53 to send the value of <code>FullyQualifiedDomainName</code> to the endpoint in the <code>client_hello</code> message during <code>TLS</code> negotiation. This allows the endpoint to respond to <code>HTTPS</code> health check requests with the applicable SSL/TLS certificate.</p>
        /// <p>Some endpoints require that HTTPS requests include the host name in the <code>client_hello</code> message. If you don't enable SNI, the status of the health check will be SSL alert <code>handshake_failure</code>. A health check can also have that status for other reasons. If SNI is enabled and you're still getting the error, check the SSL/TLS configuration on your endpoint and confirm that your certificate is valid.</p>
        /// <p>The SSL/TLS certificate on your endpoint includes a domain name in the <code>Common Name</code> field and possibly several more in the <code>Subject Alternative Names</code> field. One of the domain names in the certificate should match the value that you specify for <code>FullyQualifiedDomainName</code>. If the endpoint responds to the <code>client_hello</code> message with a certificate that does not include the domain name that you specified in <code>FullyQualifiedDomainName</code>, a health checker will retry the handshake. In the second attempt, the health checker will omit <code>FullyQualifiedDomainName</code> from the <code>client_hello</code> message.</p>
        pub fn enable_sni(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_sni(input);
            self
        }
        /// <p>Specify whether you want Amazon Route 53 to send the value of <code>FullyQualifiedDomainName</code> to the endpoint in the <code>client_hello</code> message during <code>TLS</code> negotiation. This allows the endpoint to respond to <code>HTTPS</code> health check requests with the applicable SSL/TLS certificate.</p>
        /// <p>Some endpoints require that HTTPS requests include the host name in the <code>client_hello</code> message. If you don't enable SNI, the status of the health check will be SSL alert <code>handshake_failure</code>. A health check can also have that status for other reasons. If SNI is enabled and you're still getting the error, check the SSL/TLS configuration on your endpoint and confirm that your certificate is valid.</p>
        /// <p>The SSL/TLS certificate on your endpoint includes a domain name in the <code>Common Name</code> field and possibly several more in the <code>Subject Alternative Names</code> field. One of the domain names in the certificate should match the value that you specify for <code>FullyQualifiedDomainName</code>. If the endpoint responds to the <code>client_hello</code> message with a certificate that does not include the domain name that you specified in <code>FullyQualifiedDomainName</code>, a health checker will retry the handshake. In the second attempt, the health checker will omit <code>FullyQualifiedDomainName</code> from the <code>client_hello</code> message.</p>
        pub fn set_enable_sni(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_sni(input);
            self
        }
        /// Appends an item to `Regions`.
        ///
        /// To override the contents of this collection use [`set_regions`](Self::set_regions).
        ///
        /// <p>A complex type that contains one <code>Region</code> element for each region that you want Amazon Route 53 health checkers to check the specified endpoint from.</p>
        pub fn regions(mut self, input: crate::model::HealthCheckRegion) -> Self {
            self.inner = self.inner.regions(input);
            self
        }
        /// <p>A complex type that contains one <code>Region</code> element for each region that you want Amazon Route 53 health checkers to check the specified endpoint from.</p>
        pub fn set_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HealthCheckRegion>>,
        ) -> Self {
            self.inner = self.inner.set_regions(input);
            self
        }
        /// <p>A complex type that identifies the CloudWatch alarm that you want Amazon Route 53 health checkers to use to determine whether the specified health check is healthy.</p>
        pub fn alarm_identifier(mut self, input: crate::model::AlarmIdentifier) -> Self {
            self.inner = self.inner.alarm_identifier(input);
            self
        }
        /// <p>A complex type that identifies the CloudWatch alarm that you want Amazon Route 53 health checkers to use to determine whether the specified health check is healthy.</p>
        pub fn set_alarm_identifier(
            mut self,
            input: std::option::Option<crate::model::AlarmIdentifier>,
        ) -> Self {
            self.inner = self.inner.set_alarm_identifier(input);
            self
        }
        /// <p>When CloudWatch has insufficient data about the metric to determine the alarm state, the status that you want Amazon Route 53 to assign to the health check:</p>
        /// <ul>
        /// <li> <p> <code>Healthy</code>: Route 53 considers the health check to be healthy.</p> </li>
        /// <li> <p> <code>Unhealthy</code>: Route 53 considers the health check to be unhealthy.</p> </li>
        /// <li> <p> <code>LastKnownStatus</code>: By default, Route 53 uses the status of the health check from the last time CloudWatch had sufficient data to determine the alarm state. For new health checks that have no last known status, the status for the health check is healthy.</p> </li>
        /// </ul>
        pub fn insufficient_data_health_status(
            mut self,
            input: crate::model::InsufficientDataHealthStatus,
        ) -> Self {
            self.inner = self.inner.insufficient_data_health_status(input);
            self
        }
        /// <p>When CloudWatch has insufficient data about the metric to determine the alarm state, the status that you want Amazon Route 53 to assign to the health check:</p>
        /// <ul>
        /// <li> <p> <code>Healthy</code>: Route 53 considers the health check to be healthy.</p> </li>
        /// <li> <p> <code>Unhealthy</code>: Route 53 considers the health check to be unhealthy.</p> </li>
        /// <li> <p> <code>LastKnownStatus</code>: By default, Route 53 uses the status of the health check from the last time CloudWatch had sufficient data to determine the alarm state. For new health checks that have no last known status, the status for the health check is healthy.</p> </li>
        /// </ul>
        pub fn set_insufficient_data_health_status(
            mut self,
            input: std::option::Option<crate::model::InsufficientDataHealthStatus>,
        ) -> Self {
            self.inner = self.inner.set_insufficient_data_health_status(input);
            self
        }
        /// Appends an item to `ResetElements`.
        ///
        /// To override the contents of this collection use [`set_reset_elements`](Self::set_reset_elements).
        ///
        /// <p>A complex type that contains one <code>ResettableElementName</code> element for each element that you want to reset to the default value. Valid values for <code>ResettableElementName</code> include the following:</p>
        /// <ul>
        /// <li> <p> <code>ChildHealthChecks</code>: Amazon Route 53 resets <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-ChildHealthChecks">ChildHealthChecks</a> to null.</p> </li>
        /// <li> <p> <code>FullyQualifiedDomainName</code>: Route 53 resets <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-FullyQualifiedDomainName">FullyQualifiedDomainName</a>. to null.</p> </li>
        /// <li> <p> <code>Regions</code>: Route 53 resets the <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-Regions">Regions</a> list to the default set of regions. </p> </li>
        /// <li> <p> <code>ResourcePath</code>: Route 53 resets <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-ResourcePath">ResourcePath</a> to null.</p> </li>
        /// </ul>
        pub fn reset_elements(mut self, input: crate::model::ResettableElementName) -> Self {
            self.inner = self.inner.reset_elements(input);
            self
        }
        /// <p>A complex type that contains one <code>ResettableElementName</code> element for each element that you want to reset to the default value. Valid values for <code>ResettableElementName</code> include the following:</p>
        /// <ul>
        /// <li> <p> <code>ChildHealthChecks</code>: Amazon Route 53 resets <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-ChildHealthChecks">ChildHealthChecks</a> to null.</p> </li>
        /// <li> <p> <code>FullyQualifiedDomainName</code>: Route 53 resets <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-FullyQualifiedDomainName">FullyQualifiedDomainName</a>. to null.</p> </li>
        /// <li> <p> <code>Regions</code>: Route 53 resets the <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-Regions">Regions</a> list to the default set of regions. </p> </li>
        /// <li> <p> <code>ResourcePath</code>: Route 53 resets <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-ResourcePath">ResourcePath</a> to null.</p> </li>
        /// </ul>
        pub fn set_reset_elements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResettableElementName>>,
        ) -> Self {
            self.inner = self.inner.set_reset_elements(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateHostedZoneComment`.
    ///
    /// <p>Updates the comment for a specified hosted zone.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateHostedZoneComment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_hosted_zone_comment_input::Builder,
    }
    impl<C, M, R> UpdateHostedZoneComment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateHostedZoneComment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateHostedZoneCommentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateHostedZoneCommentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateHostedZoneCommentInputOperationOutputAlias,
                crate::output::UpdateHostedZoneCommentOutput,
                crate::error::UpdateHostedZoneCommentError,
                crate::input::UpdateHostedZoneCommentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the hosted zone that you want to update the comment for.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID for the hosted zone that you want to update the comment for.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The new comment for the hosted zone. If you don't specify a value for <code>Comment</code>, Amazon Route 53 deletes the existing value of the <code>Comment</code> element, if any.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.comment(input.into());
            self
        }
        /// <p>The new comment for the hosted zone. If you don't specify a value for <code>Comment</code>, Amazon Route 53 deletes the existing value of the <code>Comment</code> element, if any.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_comment(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTrafficPolicyComment`.
    ///
    /// <p>Updates the comment for a specified traffic policy version.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateTrafficPolicyComment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_traffic_policy_comment_input::Builder,
    }
    impl<C, M, R> UpdateTrafficPolicyComment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateTrafficPolicyComment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTrafficPolicyCommentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTrafficPolicyCommentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateTrafficPolicyCommentInputOperationOutputAlias,
                crate::output::UpdateTrafficPolicyCommentOutput,
                crate::error::UpdateTrafficPolicyCommentError,
                crate::input::UpdateTrafficPolicyCommentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The value of <code>Id</code> for the traffic policy that you want to update the comment for.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The value of <code>Id</code> for the traffic policy that you want to update the comment for.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The value of <code>Version</code> for the traffic policy that you want to update the comment for.</p>
        pub fn version(mut self, input: i32) -> Self {
            self.inner = self.inner.version(input);
            self
        }
        /// <p>The value of <code>Version</code> for the traffic policy that you want to update the comment for.</p>
        pub fn set_version(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
        /// <p>The new comment for the specified traffic policy and version.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.comment(input.into());
            self
        }
        /// <p>The new comment for the specified traffic policy and version.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_comment(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTrafficPolicyInstance`.
    ///
    /// <p>Updates the resource record sets in a specified hosted zone that were created based on the settings in a specified traffic policy version.</p>
    /// <p>When you update a traffic policy instance, Amazon Route 53 continues to respond to DNS queries for the root resource record set name (such as example.com) while it replaces one group of resource record sets with another. Route 53 performs the following operations:</p>
    /// <ol>
    /// <li> <p>Route 53 creates a new group of resource record sets based on the specified traffic policy. This is true regardless of how significant the differences are between the existing resource record sets and the new resource record sets. </p> </li>
    /// <li> <p>When all of the new resource record sets have been created, Route 53 starts to respond to DNS queries for the root resource record set name (such as example.com) by using the new resource record sets.</p> </li>
    /// <li> <p>Route 53 deletes the old group of resource record sets that are associated with the root resource record set name.</p> </li>
    /// </ol>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateTrafficPolicyInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_traffic_policy_instance_input::Builder,
    }
    impl<C, M, R> UpdateTrafficPolicyInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateTrafficPolicyInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTrafficPolicyInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTrafficPolicyInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateTrafficPolicyInstanceInputOperationOutputAlias,
                crate::output::UpdateTrafficPolicyInstanceOutput,
                crate::error::UpdateTrafficPolicyInstanceError,
                crate::input::UpdateTrafficPolicyInstanceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the traffic policy instance that you want to update.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the traffic policy instance that you want to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The TTL that you want Amazon Route 53 to assign to all of the updated resource record sets.</p>
        pub fn ttl(mut self, input: i64) -> Self {
            self.inner = self.inner.ttl(input);
            self
        }
        /// <p>The TTL that you want Amazon Route 53 to assign to all of the updated resource record sets.</p>
        pub fn set_ttl(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_ttl(input);
            self
        }
        /// <p>The ID of the traffic policy that you want Amazon Route 53 to use to update resource record sets for the specified traffic policy instance.</p>
        pub fn traffic_policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.traffic_policy_id(input.into());
            self
        }
        /// <p>The ID of the traffic policy that you want Amazon Route 53 to use to update resource record sets for the specified traffic policy instance.</p>
        pub fn set_traffic_policy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_traffic_policy_id(input);
            self
        }
        /// <p>The version of the traffic policy that you want Amazon Route 53 to use to update resource record sets for the specified traffic policy instance.</p>
        pub fn traffic_policy_version(mut self, input: i32) -> Self {
            self.inner = self.inner.traffic_policy_version(input);
            self
        }
        /// <p>The version of the traffic policy that you want Amazon Route 53 to use to update resource record sets for the specified traffic policy instance.</p>
        pub fn set_traffic_policy_version(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_traffic_policy_version(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
