// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>Another user submitted a request to create, update, or delete the object at the same time that you did. Retry the request. </p>
    ConcurrentModification(crate::error::ConcurrentModification),
    /// <p>The cause of this error depends on the operation that you're performing:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Create a public hosted zone:</b> Two hosted zones that have the same name or that have a
    /// parent/child relationship (example.com and test.example.com) can't have any common name servers. You tried to create a hosted zone
    /// that has the same name as an existing hosted zone or that's the parent or child of an existing hosted zone, and you specified a
    /// delegation set that shares one or more name servers with the existing hosted zone. For more information, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateReusableDelegationSet.html">CreateReusableDelegationSet</a>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Create a private hosted zone:</b> A hosted zone with the specified name
    /// already exists and is already associated with the Amazon VPC that you specified.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Associate VPCs with a private hosted zone:</b> The VPC that you specified is
    /// already associated with another hosted zone that has the same name.</p>
    /// </li>
    /// </ul>
    ConflictingDomainExists(crate::error::ConflictingDomainExists),
    /// <p>You tried to update a traffic policy instance by using a traffic policy version that has a different DNS type
    /// than the current type for the instance. You specified the type in the JSON document in the <code>CreateTrafficPolicy</code> or
    /// <code>CreateTrafficPolicyVersion</code>request. </p>
    ConflictingTypes(crate::error::ConflictingTypes),
    /// <p>The hosted zone doesn't have any DNSSEC resources.</p>
    DnssecNotFound(crate::error::DnssecNotFound),
    /// <p>A delegation set with the same owner and caller reference combination has already been created.</p>
    DelegationSetAlreadyCreated(crate::error::DelegationSetAlreadyCreated),
    /// <p>The specified delegation set has already been marked as reusable.</p>
    DelegationSetAlreadyReusable(crate::error::DelegationSetAlreadyReusable),
    /// <p>The specified delegation contains associated hosted zones which must be deleted before the reusable delegation set
    /// can be deleted.</p>
    DelegationSetInUse(crate::error::DelegationSetInUse),
    /// <p>You can create a hosted zone that has the same name as an existing hosted zone (example.com is common), but there is a
    /// limit to the number of hosted zones that have the same name. If you get this error, Amazon Route 53 has reached that limit. If you own
    /// the domain name and Route 53 generates this error, contact Customer Support.</p>
    DelegationSetNotAvailable(crate::error::DelegationSetNotAvailable),
    /// <p>A reusable delegation set with the specified ID does not exist.</p>
    DelegationSetNotReusable(crate::error::DelegationSetNotReusable),
    /// <p> The health check you're attempting to create already exists. Amazon Route 53 returns this error when you submit a request that
    /// has the following values:</p>
    /// <ul>
    /// <li>
    /// <p>The same value for <code>CallerReference</code> as an existing health check, and one or more values that differ
    /// from the existing health check that has the same caller reference.</p>
    /// </li>
    /// <li>
    /// <p>The same value for <code>CallerReference</code> as a health check that you created and later deleted,
    /// regardless of the other settings in the request.</p>
    /// </li>
    /// </ul>
    HealthCheckAlreadyExists(crate::error::HealthCheckAlreadyExists),
    /// <p>This error code is not in use.</p>
    HealthCheckInUse(crate::error::HealthCheckInUse),
    /// <p>The value of <code>HealthCheckVersion</code> in the request doesn't match the value of <code>HealthCheckVersion</code>
    /// in the health check.</p>
    HealthCheckVersionMismatch(crate::error::HealthCheckVersionMismatch),
    /// <p>The hosted zone you're trying to create already exists. Amazon Route 53 returns this error when a hosted zone has already been created
    /// with the specified <code>CallerReference</code>.</p>
    HostedZoneAlreadyExists(crate::error::HostedZoneAlreadyExists),
    /// <p>The hosted zone contains resource records that are not SOA or NS records.</p>
    HostedZoneNotEmpty(crate::error::HostedZoneNotEmpty),
    /// <p>The specified HostedZone can't be found.</p>
    HostedZoneNotFound(crate::error::HostedZoneNotFound),
    /// <p>The specified hosted zone is a public hosted zone, not a private hosted zone.</p>
    HostedZoneNotPrivate(crate::error::HostedZoneNotPrivate),
    /// <p>The hosted zone nameservers don't match the parent nameservers. The hosted zone and parent must have the same nameservers.</p>
    HostedZonePartiallyDelegated(crate::error::HostedZonePartiallyDelegated),
    /// <p>The resource you're trying to access is unsupported on this Amazon Route 53 endpoint.</p>
    IncompatibleVersion(crate::error::IncompatibleVersion),
    /// <p>Amazon Route 53 doesn't have the permissions required to create log streams and send query logs to log streams. Possible causes
    /// include the following:</p>
    /// <ul>
    /// <li>
    /// <p>There is no resource policy that specifies the log group ARN in the value for <code>Resource</code>.</p>
    /// </li>
    /// <li>
    /// <p>The resource policy that includes the log group ARN in the value for <code>Resource</code> doesn't have the
    /// necessary permissions.</p>
    /// </li>
    /// <li>
    /// <p>The resource policy hasn't finished propagating yet.</p>
    /// </li>
    /// <li>
    /// <p>The Key management service (KMS) key you specified doesn’t exist or it can’t be used with the
    /// log group associated with query log. Update or provide a resource policy to grant permissions for the KMS key.</p>
    /// </li>
    /// </ul>
    InsufficientCloudWatchLogsResourcePolicy(
        crate::error::InsufficientCloudWatchLogsResourcePolicy,
    ),
    /// <p>Parameter name is not valid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>This exception contains a list of messages that might contain one or more error messages. Each error message indicates
    /// one error in the change batch.</p>
    InvalidChangeBatch(crate::error::InvalidChangeBatch),
    /// <p>The specified domain name is not valid.</p>
    InvalidDomainName(crate::error::InvalidDomainName),
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The KeyManagementServiceArn that you specified isn't valid to use with DNSSEC signing.</p>
    InvalidKmsArn(crate::error::InvalidKmsArn),
    /// <p>The key-signing key (KSK) name that you specified isn't a valid name.</p>
    InvalidKeySigningKeyName(crate::error::InvalidKeySigningKeyName),
    /// <p>The key-signing key (KSK) status isn't valid or another KSK has the status <code>INTERNAL_FAILURE</code>.</p>
    InvalidKeySigningKeyStatus(crate::error::InvalidKeySigningKeyStatus),
    /// <p>The value that you specified to get the second or subsequent page of results is invalid.</p>
    InvalidPaginationToken(crate::error::InvalidPaginationToken),
    /// <p>Your hosted zone status isn't valid for this operation. In the hosted zone, change the status to enable <code>DNSSEC</code>
    /// or disable <code>DNSSEC</code>.</p>
    InvalidSigningStatus(crate::error::InvalidSigningStatus),
    /// <p>The format of the traffic policy document that you specified in the <code>Document</code> element is not valid.</p>
    InvalidTrafficPolicyDocument(crate::error::InvalidTrafficPolicyDocument),
    /// <p>The VPC ID that you specified either isn't a valid ID or the current account is not authorized to access this VPC.</p>
    InvalidVpcId(crate::error::InvalidVpcId),
    /// <p>You've already created a key-signing key (KSK) with this name or with the same customer managed customer master key (CMK) ARN.</p>
    KeySigningKeyAlreadyExists(crate::error::KeySigningKeyAlreadyExists),
    /// <p>The key-signing key (KSK) is specified in a parent DS record.</p>
    KeySigningKeyInParentDsRecord(crate::error::KeySigningKeyInParentDsRecord),
    /// <p>The key-signing key (KSK) that you specified can't be deactivated because it's the only KSK for a
    /// currently-enabled DNSSEC. Disable DNSSEC signing, or add or enable another KSK.</p>
    KeySigningKeyInUse(crate::error::KeySigningKeyInUse),
    /// <p>A key-signing key (KSK) with <code>ACTIVE</code> status wasn't found.</p>
    KeySigningKeyWithActiveStatusNotFound(crate::error::KeySigningKeyWithActiveStatusNotFound),
    /// <p>The VPC that you're trying to disassociate from the private hosted zone is the last VPC that is associated with
    /// the hosted zone. Amazon Route 53 doesn't support disassociating the last VPC from a hosted zone.</p>
    LastVpcAssociation(crate::error::LastVpcAssociation),
    /// <p>This operation can't be completed either because the current account has reached the limit on reusable delegation sets
    /// that it can create or because you've reached the limit on the number of Amazon VPCs that you can associate with a private hosted zone.
    /// To get the current limit on the number of reusable delegation sets, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetAccountLimit.html">GetAccountLimit</a>.
    /// To get the current limit on the number of Amazon VPCs that you can associate with a private hosted zone, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetHostedZoneLimit.html">GetHostedZoneLimit</a>.
    /// To request a higher limit, <a href="http://aws.amazon.com/route53-request">create a case</a> with the Amazon Web Services Support Center.</p>
    LimitsExceeded(crate::error::LimitsExceeded),
    /// <p>A change with the specified change ID does not exist.</p>
    NoSuchChange(crate::error::NoSuchChange),
    /// <p>There is no CloudWatch Logs log group with the specified ARN.</p>
    NoSuchCloudWatchLogsLogGroup(crate::error::NoSuchCloudWatchLogsLogGroup),
    /// <p>A reusable delegation set with the specified ID does not exist.</p>
    NoSuchDelegationSet(crate::error::NoSuchDelegationSet),
    /// <p>Amazon Route 53 doesn't support the specified geographic location. For a list of supported geolocation codes, see the
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GeoLocation.html">GeoLocation</a> data type.</p>
    NoSuchGeoLocation(crate::error::NoSuchGeoLocation),
    /// <p>No health check exists with the specified ID.</p>
    NoSuchHealthCheck(crate::error::NoSuchHealthCheck),
    /// <p>No hosted zone exists with the ID that you specified.</p>
    NoSuchHostedZone(crate::error::NoSuchHostedZone),
    /// <p>The specified key-signing key (KSK) doesn't exist.</p>
    NoSuchKeySigningKey(crate::error::NoSuchKeySigningKey),
    /// <p>There is no DNS query logging configuration with the specified ID.</p>
    NoSuchQueryLoggingConfig(crate::error::NoSuchQueryLoggingConfig),
    /// <p>No traffic policy exists with the specified ID.</p>
    NoSuchTrafficPolicy(crate::error::NoSuchTrafficPolicy),
    /// <p>No traffic policy instance exists with the specified ID.</p>
    NoSuchTrafficPolicyInstance(crate::error::NoSuchTrafficPolicyInstance),
    /// <p>Associating the specified VPC with the specified hosted zone has not been authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>If Amazon Route 53 can't process a request before the next request arrives, it will reject
    /// subsequent requests for the same hosted zone and return an <code>HTTP 400 error</code>
    /// (<code>Bad request</code>). If Route 53 returns this error repeatedly for the same request, we
    /// recommend that you wait, in intervals of increasing duration, before you try the request
    /// again.</p>
    PriorRequestNotComplete(crate::error::PriorRequestNotComplete),
    /// <p>You're trying to associate a VPC with a public hosted zone. Amazon Route 53 doesn't support associating a
    /// VPC with a public hosted zone.</p>
    PublicZoneVpcAssociation(crate::error::PublicZoneVpcAssociation),
    /// <p>You can create only one query logging configuration for a hosted zone, and a query logging configuration already exists
    /// for this hosted zone.</p>
    QueryLoggingConfigAlreadyExists(crate::error::QueryLoggingConfigAlreadyExists),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>This health check can't be created because the current account has reached the limit on the number of active health checks.</p>
    /// <p>For information about default limits, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a>
    /// in the <i>Amazon Route 53 Developer Guide</i>.</p>
    /// <p>For information about how to get the current limit for an account, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetAccountLimit.html">GetAccountLimit</a>. To request a
    /// higher limit, <a href="http://aws.amazon.com/route53-request">create a case</a> with the Amazon Web Services Support Center.</p>
    ///
    /// <p>You have reached the maximum number of active health checks for an Amazon Web Services account. To request a higher limit,
    /// <a href="http://aws.amazon.com/route53-request">create a case</a> with the Amazon Web Services Support Center.</p>
    TooManyHealthChecks(crate::error::TooManyHealthChecks),
    /// <p>This operation can't be completed either because the current account has reached the limit on the number of hosted zones
    /// or because you've reached the limit on the number of hosted zones that can be associated with a reusable delegation set.</p>
    /// <p>For information about default limits, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a>
    /// in the <i>Amazon Route 53 Developer Guide</i>.</p>
    /// <p>To get the current limit on hosted zones that can be created by an account, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetAccountLimit.html">GetAccountLimit</a>.</p>
    /// <p>To get the current limit on hosted zones that can be associated with a reusable delegation set, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetReusableDelegationSetLimit.html">GetReusableDelegationSetLimit</a>.</p>
    /// <p>To request a higher limit, <a href="http://aws.amazon.com/route53-request">create a case</a> with the Amazon Web Services Support Center.</p>
    TooManyHostedZones(crate::error::TooManyHostedZones),
    /// <p>You've reached the limit for the number of key-signing keys (KSKs). Remove at least one KSK, and then try again.</p>
    TooManyKeySigningKeys(crate::error::TooManyKeySigningKeys),
    /// <p>This traffic policy can't be created because the current account has reached the limit on the number of traffic policies.</p>
    /// <p>For information about default limits, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a>
    /// in the <i>Amazon Route 53 Developer Guide</i>.</p>
    /// <p>To get the current limit for an account, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetAccountLimit.html">GetAccountLimit</a>.
    /// </p>
    /// <p>To request a higher limit, <a href="http://aws.amazon.com/route53-request">create a case</a> with the Amazon Web Services Support Center.</p>
    TooManyTrafficPolicies(crate::error::TooManyTrafficPolicies),
    /// <p>This traffic policy instance can't be created because the current account has reached the limit on the number of
    /// traffic policy instances.</p>
    /// <p>For information about default limits, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a>
    /// in the <i>Amazon Route 53 Developer Guide</i>.</p>
    /// <p>For information about how to get the current limit for an account, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetAccountLimit.html">GetAccountLimit</a>.</p>
    /// <p>To request a higher limit, <a href="http://aws.amazon.com/route53-request">create a case</a> with the Amazon Web Services Support Center.</p>
    TooManyTrafficPolicyInstances(crate::error::TooManyTrafficPolicyInstances),
    /// <p>This traffic policy version can't be created because you've reached the limit of 1000 on the number of versions
    /// that you can create for the current traffic policy.</p>
    /// <p>To create more traffic policy versions, you can use
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetTrafficPolicy.html">GetTrafficPolicy</a>
    /// to get the traffic policy document for a specified traffic policy version, and then use
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateTrafficPolicy.html">CreateTrafficPolicy</a>
    /// to create a new traffic policy using the traffic policy document.</p>
    TooManyTrafficPolicyVersionsForCurrentPolicy(
        crate::error::TooManyTrafficPolicyVersionsForCurrentPolicy,
    ),
    /// <p>You've created the maximum number of authorizations that can be created for the specified hosted zone.
    /// To authorize another VPC to be associated with the hosted zone, submit a <code>DeleteVPCAssociationAuthorization</code> request
    /// to remove an existing authorization. To get a list of existing authorizations, submit a
    /// <code>ListVPCAssociationAuthorizations</code> request.</p>
    TooManyVpcAssociationAuthorizations(crate::error::TooManyVpcAssociationAuthorizations),
    /// <p>A traffic policy that has the same value for <code>Name</code> already exists.</p>
    TrafficPolicyAlreadyExists(crate::error::TrafficPolicyAlreadyExists),
    /// <p>One or more traffic policy instances were created by using the specified traffic policy.</p>
    TrafficPolicyInUse(crate::error::TrafficPolicyInUse),
    /// <p>There is already a traffic policy instance with the specified ID.</p>
    TrafficPolicyInstanceAlreadyExists(crate::error::TrafficPolicyInstanceAlreadyExists),
    /// <p>The VPC that you specified is not authorized to be associated with the hosted zone.</p>
    VpcAssociationAuthorizationNotFound(crate::error::VpcAssociationAuthorizationNotFound),
    /// <p>The specified VPC and hosted zone are not currently associated.</p>
    VpcAssociationNotFound(crate::error::VpcAssociationNotFound),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::ConcurrentModification(inner) => inner.fmt(f),
            Error::ConflictingDomainExists(inner) => inner.fmt(f),
            Error::ConflictingTypes(inner) => inner.fmt(f),
            Error::DnssecNotFound(inner) => inner.fmt(f),
            Error::DelegationSetAlreadyCreated(inner) => inner.fmt(f),
            Error::DelegationSetAlreadyReusable(inner) => inner.fmt(f),
            Error::DelegationSetInUse(inner) => inner.fmt(f),
            Error::DelegationSetNotAvailable(inner) => inner.fmt(f),
            Error::DelegationSetNotReusable(inner) => inner.fmt(f),
            Error::HealthCheckAlreadyExists(inner) => inner.fmt(f),
            Error::HealthCheckInUse(inner) => inner.fmt(f),
            Error::HealthCheckVersionMismatch(inner) => inner.fmt(f),
            Error::HostedZoneAlreadyExists(inner) => inner.fmt(f),
            Error::HostedZoneNotEmpty(inner) => inner.fmt(f),
            Error::HostedZoneNotFound(inner) => inner.fmt(f),
            Error::HostedZoneNotPrivate(inner) => inner.fmt(f),
            Error::HostedZonePartiallyDelegated(inner) => inner.fmt(f),
            Error::IncompatibleVersion(inner) => inner.fmt(f),
            Error::InsufficientCloudWatchLogsResourcePolicy(inner) => inner.fmt(f),
            Error::InvalidArgument(inner) => inner.fmt(f),
            Error::InvalidChangeBatch(inner) => inner.fmt(f),
            Error::InvalidDomainName(inner) => inner.fmt(f),
            Error::InvalidInput(inner) => inner.fmt(f),
            Error::InvalidKmsArn(inner) => inner.fmt(f),
            Error::InvalidKeySigningKeyName(inner) => inner.fmt(f),
            Error::InvalidKeySigningKeyStatus(inner) => inner.fmt(f),
            Error::InvalidPaginationToken(inner) => inner.fmt(f),
            Error::InvalidSigningStatus(inner) => inner.fmt(f),
            Error::InvalidTrafficPolicyDocument(inner) => inner.fmt(f),
            Error::InvalidVpcId(inner) => inner.fmt(f),
            Error::KeySigningKeyAlreadyExists(inner) => inner.fmt(f),
            Error::KeySigningKeyInParentDsRecord(inner) => inner.fmt(f),
            Error::KeySigningKeyInUse(inner) => inner.fmt(f),
            Error::KeySigningKeyWithActiveStatusNotFound(inner) => inner.fmt(f),
            Error::LastVpcAssociation(inner) => inner.fmt(f),
            Error::LimitsExceeded(inner) => inner.fmt(f),
            Error::NoSuchChange(inner) => inner.fmt(f),
            Error::NoSuchCloudWatchLogsLogGroup(inner) => inner.fmt(f),
            Error::NoSuchDelegationSet(inner) => inner.fmt(f),
            Error::NoSuchGeoLocation(inner) => inner.fmt(f),
            Error::NoSuchHealthCheck(inner) => inner.fmt(f),
            Error::NoSuchHostedZone(inner) => inner.fmt(f),
            Error::NoSuchKeySigningKey(inner) => inner.fmt(f),
            Error::NoSuchQueryLoggingConfig(inner) => inner.fmt(f),
            Error::NoSuchTrafficPolicy(inner) => inner.fmt(f),
            Error::NoSuchTrafficPolicyInstance(inner) => inner.fmt(f),
            Error::NotAuthorizedException(inner) => inner.fmt(f),
            Error::PriorRequestNotComplete(inner) => inner.fmt(f),
            Error::PublicZoneVpcAssociation(inner) => inner.fmt(f),
            Error::QueryLoggingConfigAlreadyExists(inner) => inner.fmt(f),
            Error::ThrottlingException(inner) => inner.fmt(f),
            Error::TooManyHealthChecks(inner) => inner.fmt(f),
            Error::TooManyHostedZones(inner) => inner.fmt(f),
            Error::TooManyKeySigningKeys(inner) => inner.fmt(f),
            Error::TooManyTrafficPolicies(inner) => inner.fmt(f),
            Error::TooManyTrafficPolicyInstances(inner) => inner.fmt(f),
            Error::TooManyTrafficPolicyVersionsForCurrentPolicy(inner) => inner.fmt(f),
            Error::TooManyVpcAssociationAuthorizations(inner) => inner.fmt(f),
            Error::TrafficPolicyAlreadyExists(inner) => inner.fmt(f),
            Error::TrafficPolicyInUse(inner) => inner.fmt(f),
            Error::TrafficPolicyInstanceAlreadyExists(inner) => inner.fmt(f),
            Error::VpcAssociationAuthorizationNotFound(inner) => inner.fmt(f),
            Error::VpcAssociationNotFound(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ActivateKeySigningKeyError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ActivateKeySigningKeyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ActivateKeySigningKeyErrorKind::ConcurrentModification(inner) => {
                    Error::ConcurrentModification(inner)
                }
                crate::error::ActivateKeySigningKeyErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::ActivateKeySigningKeyErrorKind::InvalidKeySigningKeyStatus(inner) => {
                    Error::InvalidKeySigningKeyStatus(inner)
                }
                crate::error::ActivateKeySigningKeyErrorKind::InvalidKmsArn(inner) => {
                    Error::InvalidKmsArn(inner)
                }
                crate::error::ActivateKeySigningKeyErrorKind::InvalidSigningStatus(inner) => {
                    Error::InvalidSigningStatus(inner)
                }
                crate::error::ActivateKeySigningKeyErrorKind::NoSuchKeySigningKey(inner) => {
                    Error::NoSuchKeySigningKey(inner)
                }
                crate::error::ActivateKeySigningKeyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AssociateVPCWithHostedZoneError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AssociateVPCWithHostedZoneError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AssociateVPCWithHostedZoneErrorKind::ConflictingDomainExists(
                    inner,
                ) => Error::ConflictingDomainExists(inner),
                crate::error::AssociateVPCWithHostedZoneErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::AssociateVPCWithHostedZoneErrorKind::InvalidVpcId(inner) => {
                    Error::InvalidVpcId(inner)
                }
                crate::error::AssociateVPCWithHostedZoneErrorKind::LimitsExceeded(inner) => {
                    Error::LimitsExceeded(inner)
                }
                crate::error::AssociateVPCWithHostedZoneErrorKind::NoSuchHostedZone(inner) => {
                    Error::NoSuchHostedZone(inner)
                }
                crate::error::AssociateVPCWithHostedZoneErrorKind::NotAuthorizedException(
                    inner,
                ) => Error::NotAuthorizedException(inner),
                crate::error::AssociateVPCWithHostedZoneErrorKind::PriorRequestNotComplete(
                    inner,
                ) => Error::PriorRequestNotComplete(inner),
                crate::error::AssociateVPCWithHostedZoneErrorKind::PublicZoneVpcAssociation(
                    inner,
                ) => Error::PublicZoneVpcAssociation(inner),
                crate::error::AssociateVPCWithHostedZoneErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ChangeResourceRecordSetsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ChangeResourceRecordSetsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ChangeResourceRecordSetsErrorKind::InvalidChangeBatch(inner) => {
                    Error::InvalidChangeBatch(inner)
                }
                crate::error::ChangeResourceRecordSetsErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::ChangeResourceRecordSetsErrorKind::NoSuchHealthCheck(inner) => {
                    Error::NoSuchHealthCheck(inner)
                }
                crate::error::ChangeResourceRecordSetsErrorKind::NoSuchHostedZone(inner) => {
                    Error::NoSuchHostedZone(inner)
                }
                crate::error::ChangeResourceRecordSetsErrorKind::PriorRequestNotComplete(inner) => {
                    Error::PriorRequestNotComplete(inner)
                }
                crate::error::ChangeResourceRecordSetsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ChangeTagsForResourceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ChangeTagsForResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ChangeTagsForResourceErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::ChangeTagsForResourceErrorKind::NoSuchHealthCheck(inner) => {
                    Error::NoSuchHealthCheck(inner)
                }
                crate::error::ChangeTagsForResourceErrorKind::NoSuchHostedZone(inner) => {
                    Error::NoSuchHostedZone(inner)
                }
                crate::error::ChangeTagsForResourceErrorKind::PriorRequestNotComplete(inner) => {
                    Error::PriorRequestNotComplete(inner)
                }
                crate::error::ChangeTagsForResourceErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::ChangeTagsForResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateHealthCheckError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateHealthCheckError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateHealthCheckErrorKind::HealthCheckAlreadyExists(inner) => {
                    Error::HealthCheckAlreadyExists(inner)
                }
                crate::error::CreateHealthCheckErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::CreateHealthCheckErrorKind::TooManyHealthChecks(inner) => {
                    Error::TooManyHealthChecks(inner)
                }
                crate::error::CreateHealthCheckErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateHostedZoneError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateHostedZoneError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateHostedZoneErrorKind::ConflictingDomainExists(inner) => {
                    Error::ConflictingDomainExists(inner)
                }
                crate::error::CreateHostedZoneErrorKind::DelegationSetNotAvailable(inner) => {
                    Error::DelegationSetNotAvailable(inner)
                }
                crate::error::CreateHostedZoneErrorKind::DelegationSetNotReusable(inner) => {
                    Error::DelegationSetNotReusable(inner)
                }
                crate::error::CreateHostedZoneErrorKind::HostedZoneAlreadyExists(inner) => {
                    Error::HostedZoneAlreadyExists(inner)
                }
                crate::error::CreateHostedZoneErrorKind::InvalidDomainName(inner) => {
                    Error::InvalidDomainName(inner)
                }
                crate::error::CreateHostedZoneErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::CreateHostedZoneErrorKind::InvalidVpcId(inner) => {
                    Error::InvalidVpcId(inner)
                }
                crate::error::CreateHostedZoneErrorKind::NoSuchDelegationSet(inner) => {
                    Error::NoSuchDelegationSet(inner)
                }
                crate::error::CreateHostedZoneErrorKind::TooManyHostedZones(inner) => {
                    Error::TooManyHostedZones(inner)
                }
                crate::error::CreateHostedZoneErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateKeySigningKeyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateKeySigningKeyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateKeySigningKeyErrorKind::ConcurrentModification(inner) => {
                    Error::ConcurrentModification(inner)
                }
                crate::error::CreateKeySigningKeyErrorKind::InvalidArgument(inner) => {
                    Error::InvalidArgument(inner)
                }
                crate::error::CreateKeySigningKeyErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::CreateKeySigningKeyErrorKind::InvalidKeySigningKeyName(inner) => {
                    Error::InvalidKeySigningKeyName(inner)
                }
                crate::error::CreateKeySigningKeyErrorKind::InvalidKeySigningKeyStatus(inner) => {
                    Error::InvalidKeySigningKeyStatus(inner)
                }
                crate::error::CreateKeySigningKeyErrorKind::InvalidKmsArn(inner) => {
                    Error::InvalidKmsArn(inner)
                }
                crate::error::CreateKeySigningKeyErrorKind::InvalidSigningStatus(inner) => {
                    Error::InvalidSigningStatus(inner)
                }
                crate::error::CreateKeySigningKeyErrorKind::KeySigningKeyAlreadyExists(inner) => {
                    Error::KeySigningKeyAlreadyExists(inner)
                }
                crate::error::CreateKeySigningKeyErrorKind::NoSuchHostedZone(inner) => {
                    Error::NoSuchHostedZone(inner)
                }
                crate::error::CreateKeySigningKeyErrorKind::TooManyKeySigningKeys(inner) => {
                    Error::TooManyKeySigningKeys(inner)
                }
                crate::error::CreateKeySigningKeyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateQueryLoggingConfigError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateQueryLoggingConfigError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateQueryLoggingConfigErrorKind::ConcurrentModification(inner) => Error::ConcurrentModification(inner),
                crate::error::CreateQueryLoggingConfigErrorKind::InsufficientCloudWatchLogsResourcePolicy(inner) => Error::InsufficientCloudWatchLogsResourcePolicy(inner),
                crate::error::CreateQueryLoggingConfigErrorKind::InvalidInput(inner) => Error::InvalidInput(inner),
                crate::error::CreateQueryLoggingConfigErrorKind::NoSuchCloudWatchLogsLogGroup(inner) => Error::NoSuchCloudWatchLogsLogGroup(inner),
                crate::error::CreateQueryLoggingConfigErrorKind::NoSuchHostedZone(inner) => Error::NoSuchHostedZone(inner),
                crate::error::CreateQueryLoggingConfigErrorKind::QueryLoggingConfigAlreadyExists(inner) => Error::QueryLoggingConfigAlreadyExists(inner),
                crate::error::CreateQueryLoggingConfigErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateReusableDelegationSetError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateReusableDelegationSetError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateReusableDelegationSetErrorKind::DelegationSetAlreadyCreated(inner) => Error::DelegationSetAlreadyCreated(inner),
                crate::error::CreateReusableDelegationSetErrorKind::DelegationSetAlreadyReusable(inner) => Error::DelegationSetAlreadyReusable(inner),
                crate::error::CreateReusableDelegationSetErrorKind::DelegationSetNotAvailable(inner) => Error::DelegationSetNotAvailable(inner),
                crate::error::CreateReusableDelegationSetErrorKind::HostedZoneNotFound(inner) => Error::HostedZoneNotFound(inner),
                crate::error::CreateReusableDelegationSetErrorKind::InvalidArgument(inner) => Error::InvalidArgument(inner),
                crate::error::CreateReusableDelegationSetErrorKind::InvalidInput(inner) => Error::InvalidInput(inner),
                crate::error::CreateReusableDelegationSetErrorKind::LimitsExceeded(inner) => Error::LimitsExceeded(inner),
                crate::error::CreateReusableDelegationSetErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateTrafficPolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateTrafficPolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateTrafficPolicyErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::CreateTrafficPolicyErrorKind::InvalidTrafficPolicyDocument(inner) => {
                    Error::InvalidTrafficPolicyDocument(inner)
                }
                crate::error::CreateTrafficPolicyErrorKind::TooManyTrafficPolicies(inner) => {
                    Error::TooManyTrafficPolicies(inner)
                }
                crate::error::CreateTrafficPolicyErrorKind::TrafficPolicyAlreadyExists(inner) => {
                    Error::TrafficPolicyAlreadyExists(inner)
                }
                crate::error::CreateTrafficPolicyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateTrafficPolicyInstanceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateTrafficPolicyInstanceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateTrafficPolicyInstanceErrorKind::InvalidInput(inner) => Error::InvalidInput(inner),
                crate::error::CreateTrafficPolicyInstanceErrorKind::NoSuchHostedZone(inner) => Error::NoSuchHostedZone(inner),
                crate::error::CreateTrafficPolicyInstanceErrorKind::NoSuchTrafficPolicy(inner) => Error::NoSuchTrafficPolicy(inner),
                crate::error::CreateTrafficPolicyInstanceErrorKind::TooManyTrafficPolicyInstances(inner) => Error::TooManyTrafficPolicyInstances(inner),
                crate::error::CreateTrafficPolicyInstanceErrorKind::TrafficPolicyInstanceAlreadyExists(inner) => Error::TrafficPolicyInstanceAlreadyExists(inner),
                crate::error::CreateTrafficPolicyInstanceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateTrafficPolicyVersionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateTrafficPolicyVersionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateTrafficPolicyVersionErrorKind::ConcurrentModification(inner) => Error::ConcurrentModification(inner),
                crate::error::CreateTrafficPolicyVersionErrorKind::InvalidInput(inner) => Error::InvalidInput(inner),
                crate::error::CreateTrafficPolicyVersionErrorKind::InvalidTrafficPolicyDocument(inner) => Error::InvalidTrafficPolicyDocument(inner),
                crate::error::CreateTrafficPolicyVersionErrorKind::NoSuchTrafficPolicy(inner) => Error::NoSuchTrafficPolicy(inner),
                crate::error::CreateTrafficPolicyVersionErrorKind::TooManyTrafficPolicyVersionsForCurrentPolicy(inner) => Error::TooManyTrafficPolicyVersionsForCurrentPolicy(inner),
                crate::error::CreateTrafficPolicyVersionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::CreateVPCAssociationAuthorizationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::CreateVPCAssociationAuthorizationError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateVPCAssociationAuthorizationErrorKind::ConcurrentModification(inner) => Error::ConcurrentModification(inner),
                crate::error::CreateVPCAssociationAuthorizationErrorKind::InvalidInput(inner) => Error::InvalidInput(inner),
                crate::error::CreateVPCAssociationAuthorizationErrorKind::InvalidVpcId(inner) => Error::InvalidVpcId(inner),
                crate::error::CreateVPCAssociationAuthorizationErrorKind::NoSuchHostedZone(inner) => Error::NoSuchHostedZone(inner),
                crate::error::CreateVPCAssociationAuthorizationErrorKind::TooManyVpcAssociationAuthorizations(inner) => Error::TooManyVpcAssociationAuthorizations(inner),
                crate::error::CreateVPCAssociationAuthorizationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeactivateKeySigningKeyError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeactivateKeySigningKeyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeactivateKeySigningKeyErrorKind::ConcurrentModification(inner) => {
                    Error::ConcurrentModification(inner)
                }
                crate::error::DeactivateKeySigningKeyErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::DeactivateKeySigningKeyErrorKind::InvalidKeySigningKeyStatus(
                    inner,
                ) => Error::InvalidKeySigningKeyStatus(inner),
                crate::error::DeactivateKeySigningKeyErrorKind::InvalidSigningStatus(inner) => {
                    Error::InvalidSigningStatus(inner)
                }
                crate::error::DeactivateKeySigningKeyErrorKind::KeySigningKeyInParentDsRecord(
                    inner,
                ) => Error::KeySigningKeyInParentDsRecord(inner),
                crate::error::DeactivateKeySigningKeyErrorKind::KeySigningKeyInUse(inner) => {
                    Error::KeySigningKeyInUse(inner)
                }
                crate::error::DeactivateKeySigningKeyErrorKind::NoSuchKeySigningKey(inner) => {
                    Error::NoSuchKeySigningKey(inner)
                }
                crate::error::DeactivateKeySigningKeyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteHealthCheckError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteHealthCheckError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteHealthCheckErrorKind::HealthCheckInUse(inner) => {
                    Error::HealthCheckInUse(inner)
                }
                crate::error::DeleteHealthCheckErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::DeleteHealthCheckErrorKind::NoSuchHealthCheck(inner) => {
                    Error::NoSuchHealthCheck(inner)
                }
                crate::error::DeleteHealthCheckErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteHostedZoneError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteHostedZoneError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteHostedZoneErrorKind::HostedZoneNotEmpty(inner) => {
                    Error::HostedZoneNotEmpty(inner)
                }
                crate::error::DeleteHostedZoneErrorKind::InvalidDomainName(inner) => {
                    Error::InvalidDomainName(inner)
                }
                crate::error::DeleteHostedZoneErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::DeleteHostedZoneErrorKind::NoSuchHostedZone(inner) => {
                    Error::NoSuchHostedZone(inner)
                }
                crate::error::DeleteHostedZoneErrorKind::PriorRequestNotComplete(inner) => {
                    Error::PriorRequestNotComplete(inner)
                }
                crate::error::DeleteHostedZoneErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteKeySigningKeyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteKeySigningKeyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteKeySigningKeyErrorKind::ConcurrentModification(inner) => {
                    Error::ConcurrentModification(inner)
                }
                crate::error::DeleteKeySigningKeyErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::DeleteKeySigningKeyErrorKind::InvalidKeySigningKeyStatus(inner) => {
                    Error::InvalidKeySigningKeyStatus(inner)
                }
                crate::error::DeleteKeySigningKeyErrorKind::InvalidKmsArn(inner) => {
                    Error::InvalidKmsArn(inner)
                }
                crate::error::DeleteKeySigningKeyErrorKind::InvalidSigningStatus(inner) => {
                    Error::InvalidSigningStatus(inner)
                }
                crate::error::DeleteKeySigningKeyErrorKind::NoSuchKeySigningKey(inner) => {
                    Error::NoSuchKeySigningKey(inner)
                }
                crate::error::DeleteKeySigningKeyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteQueryLoggingConfigError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteQueryLoggingConfigError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteQueryLoggingConfigErrorKind::ConcurrentModification(inner) => {
                    Error::ConcurrentModification(inner)
                }
                crate::error::DeleteQueryLoggingConfigErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::DeleteQueryLoggingConfigErrorKind::NoSuchQueryLoggingConfig(
                    inner,
                ) => Error::NoSuchQueryLoggingConfig(inner),
                crate::error::DeleteQueryLoggingConfigErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteReusableDelegationSetError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteReusableDelegationSetError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteReusableDelegationSetErrorKind::DelegationSetInUse(inner) => {
                    Error::DelegationSetInUse(inner)
                }
                crate::error::DeleteReusableDelegationSetErrorKind::DelegationSetNotReusable(
                    inner,
                ) => Error::DelegationSetNotReusable(inner),
                crate::error::DeleteReusableDelegationSetErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::DeleteReusableDelegationSetErrorKind::NoSuchDelegationSet(inner) => {
                    Error::NoSuchDelegationSet(inner)
                }
                crate::error::DeleteReusableDelegationSetErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteTrafficPolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteTrafficPolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteTrafficPolicyErrorKind::ConcurrentModification(inner) => {
                    Error::ConcurrentModification(inner)
                }
                crate::error::DeleteTrafficPolicyErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::DeleteTrafficPolicyErrorKind::NoSuchTrafficPolicy(inner) => {
                    Error::NoSuchTrafficPolicy(inner)
                }
                crate::error::DeleteTrafficPolicyErrorKind::TrafficPolicyInUse(inner) => {
                    Error::TrafficPolicyInUse(inner)
                }
                crate::error::DeleteTrafficPolicyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteTrafficPolicyInstanceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteTrafficPolicyInstanceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteTrafficPolicyInstanceErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::DeleteTrafficPolicyInstanceErrorKind::NoSuchTrafficPolicyInstance(
                    inner,
                ) => Error::NoSuchTrafficPolicyInstance(inner),
                crate::error::DeleteTrafficPolicyInstanceErrorKind::PriorRequestNotComplete(
                    inner,
                ) => Error::PriorRequestNotComplete(inner),
                crate::error::DeleteTrafficPolicyInstanceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DeleteVPCAssociationAuthorizationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DeleteVPCAssociationAuthorizationError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteVPCAssociationAuthorizationErrorKind::ConcurrentModification(inner) => Error::ConcurrentModification(inner),
                crate::error::DeleteVPCAssociationAuthorizationErrorKind::InvalidInput(inner) => Error::InvalidInput(inner),
                crate::error::DeleteVPCAssociationAuthorizationErrorKind::InvalidVpcId(inner) => Error::InvalidVpcId(inner),
                crate::error::DeleteVPCAssociationAuthorizationErrorKind::NoSuchHostedZone(inner) => Error::NoSuchHostedZone(inner),
                crate::error::DeleteVPCAssociationAuthorizationErrorKind::VpcAssociationAuthorizationNotFound(inner) => Error::VpcAssociationAuthorizationNotFound(inner),
                crate::error::DeleteVPCAssociationAuthorizationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DisableHostedZoneDNSSECError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DisableHostedZoneDNSSECError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DisableHostedZoneDNSSECErrorKind::ConcurrentModification(inner) => {
                    Error::ConcurrentModification(inner)
                }
                crate::error::DisableHostedZoneDNSSECErrorKind::DnssecNotFound(inner) => {
                    Error::DnssecNotFound(inner)
                }
                crate::error::DisableHostedZoneDNSSECErrorKind::InvalidArgument(inner) => {
                    Error::InvalidArgument(inner)
                }
                crate::error::DisableHostedZoneDNSSECErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::DisableHostedZoneDNSSECErrorKind::InvalidKeySigningKeyStatus(
                    inner,
                ) => Error::InvalidKeySigningKeyStatus(inner),
                crate::error::DisableHostedZoneDNSSECErrorKind::InvalidKmsArn(inner) => {
                    Error::InvalidKmsArn(inner)
                }
                crate::error::DisableHostedZoneDNSSECErrorKind::KeySigningKeyInParentDsRecord(
                    inner,
                ) => Error::KeySigningKeyInParentDsRecord(inner),
                crate::error::DisableHostedZoneDNSSECErrorKind::NoSuchHostedZone(inner) => {
                    Error::NoSuchHostedZone(inner)
                }
                crate::error::DisableHostedZoneDNSSECErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DisassociateVPCFromHostedZoneError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DisassociateVPCFromHostedZoneError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DisassociateVPCFromHostedZoneErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::DisassociateVPCFromHostedZoneErrorKind::InvalidVpcId(inner) => {
                    Error::InvalidVpcId(inner)
                }
                crate::error::DisassociateVPCFromHostedZoneErrorKind::LastVpcAssociation(inner) => {
                    Error::LastVpcAssociation(inner)
                }
                crate::error::DisassociateVPCFromHostedZoneErrorKind::NoSuchHostedZone(inner) => {
                    Error::NoSuchHostedZone(inner)
                }
                crate::error::DisassociateVPCFromHostedZoneErrorKind::VpcAssociationNotFound(
                    inner,
                ) => Error::VpcAssociationNotFound(inner),
                crate::error::DisassociateVPCFromHostedZoneErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::EnableHostedZoneDNSSECError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::EnableHostedZoneDNSSECError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::EnableHostedZoneDNSSECErrorKind::ConcurrentModification(inner) => Error::ConcurrentModification(inner),
                crate::error::EnableHostedZoneDNSSECErrorKind::DnssecNotFound(inner) => Error::DnssecNotFound(inner),
                crate::error::EnableHostedZoneDNSSECErrorKind::HostedZonePartiallyDelegated(inner) => Error::HostedZonePartiallyDelegated(inner),
                crate::error::EnableHostedZoneDNSSECErrorKind::InvalidArgument(inner) => Error::InvalidArgument(inner),
                crate::error::EnableHostedZoneDNSSECErrorKind::InvalidInput(inner) => Error::InvalidInput(inner),
                crate::error::EnableHostedZoneDNSSECErrorKind::InvalidKeySigningKeyStatus(inner) => Error::InvalidKeySigningKeyStatus(inner),
                crate::error::EnableHostedZoneDNSSECErrorKind::InvalidKmsArn(inner) => Error::InvalidKmsArn(inner),
                crate::error::EnableHostedZoneDNSSECErrorKind::KeySigningKeyWithActiveStatusNotFound(inner) => Error::KeySigningKeyWithActiveStatusNotFound(inner),
                crate::error::EnableHostedZoneDNSSECErrorKind::NoSuchHostedZone(inner) => Error::NoSuchHostedZone(inner),
                crate::error::EnableHostedZoneDNSSECErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetAccountLimitError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetAccountLimitError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetAccountLimitErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::GetAccountLimitErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetChangeError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetChangeError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetChangeErrorKind::InvalidInput(inner) => Error::InvalidInput(inner),
                crate::error::GetChangeErrorKind::NoSuchChange(inner) => Error::NoSuchChange(inner),
                crate::error::GetChangeErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetCheckerIpRangesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetCheckerIpRangesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetCheckerIpRangesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetDNSSECError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetDNSSECError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetDNSSECErrorKind::InvalidArgument(inner) => {
                    Error::InvalidArgument(inner)
                }
                crate::error::GetDNSSECErrorKind::InvalidInput(inner) => Error::InvalidInput(inner),
                crate::error::GetDNSSECErrorKind::NoSuchHostedZone(inner) => {
                    Error::NoSuchHostedZone(inner)
                }
                crate::error::GetDNSSECErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetGeoLocationError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetGeoLocationError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetGeoLocationErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::GetGeoLocationErrorKind::NoSuchGeoLocation(inner) => {
                    Error::NoSuchGeoLocation(inner)
                }
                crate::error::GetGeoLocationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetHealthCheckError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetHealthCheckError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetHealthCheckErrorKind::IncompatibleVersion(inner) => {
                    Error::IncompatibleVersion(inner)
                }
                crate::error::GetHealthCheckErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::GetHealthCheckErrorKind::NoSuchHealthCheck(inner) => {
                    Error::NoSuchHealthCheck(inner)
                }
                crate::error::GetHealthCheckErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetHealthCheckCountError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetHealthCheckCountError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetHealthCheckCountErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::GetHealthCheckLastFailureReasonError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetHealthCheckLastFailureReasonError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetHealthCheckLastFailureReasonErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::GetHealthCheckLastFailureReasonErrorKind::NoSuchHealthCheck(
                    inner,
                ) => Error::NoSuchHealthCheck(inner),
                crate::error::GetHealthCheckLastFailureReasonErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetHealthCheckStatusError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetHealthCheckStatusError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetHealthCheckStatusErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::GetHealthCheckStatusErrorKind::NoSuchHealthCheck(inner) => {
                    Error::NoSuchHealthCheck(inner)
                }
                crate::error::GetHealthCheckStatusErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetHostedZoneError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetHostedZoneError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetHostedZoneErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::GetHostedZoneErrorKind::NoSuchHostedZone(inner) => {
                    Error::NoSuchHostedZone(inner)
                }
                crate::error::GetHostedZoneErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetHostedZoneCountError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetHostedZoneCountError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetHostedZoneCountErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::GetHostedZoneCountErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetHostedZoneLimitError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetHostedZoneLimitError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetHostedZoneLimitErrorKind::HostedZoneNotPrivate(inner) => {
                    Error::HostedZoneNotPrivate(inner)
                }
                crate::error::GetHostedZoneLimitErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::GetHostedZoneLimitErrorKind::NoSuchHostedZone(inner) => {
                    Error::NoSuchHostedZone(inner)
                }
                crate::error::GetHostedZoneLimitErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetQueryLoggingConfigError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetQueryLoggingConfigError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetQueryLoggingConfigErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::GetQueryLoggingConfigErrorKind::NoSuchQueryLoggingConfig(inner) => {
                    Error::NoSuchQueryLoggingConfig(inner)
                }
                crate::error::GetQueryLoggingConfigErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetReusableDelegationSetError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetReusableDelegationSetError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetReusableDelegationSetErrorKind::DelegationSetNotReusable(
                    inner,
                ) => Error::DelegationSetNotReusable(inner),
                crate::error::GetReusableDelegationSetErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::GetReusableDelegationSetErrorKind::NoSuchDelegationSet(inner) => {
                    Error::NoSuchDelegationSet(inner)
                }
                crate::error::GetReusableDelegationSetErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetReusableDelegationSetLimitError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetReusableDelegationSetLimitError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetReusableDelegationSetLimitErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::GetReusableDelegationSetLimitErrorKind::NoSuchDelegationSet(
                    inner,
                ) => Error::NoSuchDelegationSet(inner),
                crate::error::GetReusableDelegationSetLimitErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetTrafficPolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetTrafficPolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetTrafficPolicyErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::GetTrafficPolicyErrorKind::NoSuchTrafficPolicy(inner) => {
                    Error::NoSuchTrafficPolicy(inner)
                }
                crate::error::GetTrafficPolicyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetTrafficPolicyInstanceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetTrafficPolicyInstanceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetTrafficPolicyInstanceErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::GetTrafficPolicyInstanceErrorKind::NoSuchTrafficPolicyInstance(
                    inner,
                ) => Error::NoSuchTrafficPolicyInstance(inner),
                crate::error::GetTrafficPolicyInstanceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetTrafficPolicyInstanceCountError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetTrafficPolicyInstanceCountError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetTrafficPolicyInstanceCountErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListGeoLocationsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListGeoLocationsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListGeoLocationsErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::ListGeoLocationsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListHealthChecksError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListHealthChecksError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListHealthChecksErrorKind::IncompatibleVersion(inner) => {
                    Error::IncompatibleVersion(inner)
                }
                crate::error::ListHealthChecksErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::ListHealthChecksErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListHostedZonesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListHostedZonesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListHostedZonesErrorKind::DelegationSetNotReusable(inner) => {
                    Error::DelegationSetNotReusable(inner)
                }
                crate::error::ListHostedZonesErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::ListHostedZonesErrorKind::NoSuchDelegationSet(inner) => {
                    Error::NoSuchDelegationSet(inner)
                }
                crate::error::ListHostedZonesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListHostedZonesByNameError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListHostedZonesByNameError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListHostedZonesByNameErrorKind::InvalidDomainName(inner) => {
                    Error::InvalidDomainName(inner)
                }
                crate::error::ListHostedZonesByNameErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::ListHostedZonesByNameErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListHostedZonesByVPCError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListHostedZonesByVPCError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListHostedZonesByVPCErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::ListHostedZonesByVPCErrorKind::InvalidPaginationToken(inner) => {
                    Error::InvalidPaginationToken(inner)
                }
                crate::error::ListHostedZonesByVPCErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListQueryLoggingConfigsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListQueryLoggingConfigsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListQueryLoggingConfigsErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::ListQueryLoggingConfigsErrorKind::InvalidPaginationToken(inner) => {
                    Error::InvalidPaginationToken(inner)
                }
                crate::error::ListQueryLoggingConfigsErrorKind::NoSuchHostedZone(inner) => {
                    Error::NoSuchHostedZone(inner)
                }
                crate::error::ListQueryLoggingConfigsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListResourceRecordSetsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListResourceRecordSetsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListResourceRecordSetsErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::ListResourceRecordSetsErrorKind::NoSuchHostedZone(inner) => {
                    Error::NoSuchHostedZone(inner)
                }
                crate::error::ListResourceRecordSetsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListReusableDelegationSetsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListReusableDelegationSetsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListReusableDelegationSetsErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::ListReusableDelegationSetsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTagsForResourceErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::ListTagsForResourceErrorKind::NoSuchHealthCheck(inner) => {
                    Error::NoSuchHealthCheck(inner)
                }
                crate::error::ListTagsForResourceErrorKind::NoSuchHostedZone(inner) => {
                    Error::NoSuchHostedZone(inner)
                }
                crate::error::ListTagsForResourceErrorKind::PriorRequestNotComplete(inner) => {
                    Error::PriorRequestNotComplete(inner)
                }
                crate::error::ListTagsForResourceErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTagsForResourcesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTagsForResourcesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTagsForResourcesErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::ListTagsForResourcesErrorKind::NoSuchHealthCheck(inner) => {
                    Error::NoSuchHealthCheck(inner)
                }
                crate::error::ListTagsForResourcesErrorKind::NoSuchHostedZone(inner) => {
                    Error::NoSuchHostedZone(inner)
                }
                crate::error::ListTagsForResourcesErrorKind::PriorRequestNotComplete(inner) => {
                    Error::PriorRequestNotComplete(inner)
                }
                crate::error::ListTagsForResourcesErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::ListTagsForResourcesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTrafficPoliciesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTrafficPoliciesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTrafficPoliciesErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::ListTrafficPoliciesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTrafficPolicyInstancesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTrafficPolicyInstancesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTrafficPolicyInstancesErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::ListTrafficPolicyInstancesErrorKind::NoSuchTrafficPolicyInstance(
                    inner,
                ) => Error::NoSuchTrafficPolicyInstance(inner),
                crate::error::ListTrafficPolicyInstancesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::ListTrafficPolicyInstancesByHostedZoneError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ListTrafficPolicyInstancesByHostedZoneError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListTrafficPolicyInstancesByHostedZoneErrorKind::InvalidInput(inner) => Error::InvalidInput(inner),
                crate::error::ListTrafficPolicyInstancesByHostedZoneErrorKind::NoSuchHostedZone(inner) => Error::NoSuchHostedZone(inner),
                crate::error::ListTrafficPolicyInstancesByHostedZoneErrorKind::NoSuchTrafficPolicyInstance(inner) => Error::NoSuchTrafficPolicyInstance(inner),
                crate::error::ListTrafficPolicyInstancesByHostedZoneErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<crate::error::ListTrafficPolicyInstancesByPolicyError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ListTrafficPolicyInstancesByPolicyError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListTrafficPolicyInstancesByPolicyErrorKind::InvalidInput(inner) => Error::InvalidInput(inner),
                crate::error::ListTrafficPolicyInstancesByPolicyErrorKind::NoSuchTrafficPolicy(inner) => Error::NoSuchTrafficPolicy(inner),
                crate::error::ListTrafficPolicyInstancesByPolicyErrorKind::NoSuchTrafficPolicyInstance(inner) => Error::NoSuchTrafficPolicyInstance(inner),
                crate::error::ListTrafficPolicyInstancesByPolicyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTrafficPolicyVersionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTrafficPolicyVersionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTrafficPolicyVersionsErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::ListTrafficPolicyVersionsErrorKind::NoSuchTrafficPolicy(inner) => {
                    Error::NoSuchTrafficPolicy(inner)
                }
                crate::error::ListTrafficPolicyVersionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::ListVPCAssociationAuthorizationsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ListVPCAssociationAuthorizationsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListVPCAssociationAuthorizationsErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::ListVPCAssociationAuthorizationsErrorKind::InvalidPaginationToken(
                    inner,
                ) => Error::InvalidPaginationToken(inner),
                crate::error::ListVPCAssociationAuthorizationsErrorKind::NoSuchHostedZone(
                    inner,
                ) => Error::NoSuchHostedZone(inner),
                crate::error::ListVPCAssociationAuthorizationsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::TestDNSAnswerError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::TestDNSAnswerError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::TestDNSAnswerErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::TestDNSAnswerErrorKind::NoSuchHostedZone(inner) => {
                    Error::NoSuchHostedZone(inner)
                }
                crate::error::TestDNSAnswerErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateHealthCheckError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateHealthCheckError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateHealthCheckErrorKind::HealthCheckVersionMismatch(inner) => {
                    Error::HealthCheckVersionMismatch(inner)
                }
                crate::error::UpdateHealthCheckErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::UpdateHealthCheckErrorKind::NoSuchHealthCheck(inner) => {
                    Error::NoSuchHealthCheck(inner)
                }
                crate::error::UpdateHealthCheckErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateHostedZoneCommentError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateHostedZoneCommentError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateHostedZoneCommentErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::UpdateHostedZoneCommentErrorKind::NoSuchHostedZone(inner) => {
                    Error::NoSuchHostedZone(inner)
                }
                crate::error::UpdateHostedZoneCommentErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateTrafficPolicyCommentError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateTrafficPolicyCommentError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateTrafficPolicyCommentErrorKind::ConcurrentModification(
                    inner,
                ) => Error::ConcurrentModification(inner),
                crate::error::UpdateTrafficPolicyCommentErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::UpdateTrafficPolicyCommentErrorKind::NoSuchTrafficPolicy(inner) => {
                    Error::NoSuchTrafficPolicy(inner)
                }
                crate::error::UpdateTrafficPolicyCommentErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateTrafficPolicyInstanceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateTrafficPolicyInstanceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateTrafficPolicyInstanceErrorKind::ConflictingTypes(inner) => {
                    Error::ConflictingTypes(inner)
                }
                crate::error::UpdateTrafficPolicyInstanceErrorKind::InvalidInput(inner) => {
                    Error::InvalidInput(inner)
                }
                crate::error::UpdateTrafficPolicyInstanceErrorKind::NoSuchTrafficPolicy(inner) => {
                    Error::NoSuchTrafficPolicy(inner)
                }
                crate::error::UpdateTrafficPolicyInstanceErrorKind::NoSuchTrafficPolicyInstance(
                    inner,
                ) => Error::NoSuchTrafficPolicyInstance(inner),
                crate::error::UpdateTrafficPolicyInstanceErrorKind::PriorRequestNotComplete(
                    inner,
                ) => Error::PriorRequestNotComplete(inner),
                crate::error::UpdateTrafficPolicyInstanceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
