// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `ActivateKeySigningKey`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`activate_key_signing_key`](crate::client::Client::activate_key_signing_key).
///
/// See [`crate::client::fluent_builders::ActivateKeySigningKey`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ActivateKeySigningKey {
    _private: (),
}
impl ActivateKeySigningKey {
    /// Creates a new builder-style object to manufacture [`ActivateKeySigningKeyInput`](crate::input::ActivateKeySigningKeyInput)
    pub fn builder() -> crate::input::activate_key_signing_key_input::Builder {
        crate::input::activate_key_signing_key_input::Builder::default()
    }
    /// Creates a new `ActivateKeySigningKey` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ActivateKeySigningKey {
    type Output = std::result::Result<
        crate::output::ActivateKeySigningKeyOutput,
        crate::error::ActivateKeySigningKeyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_activate_key_signing_key_error(response)
        } else {
            crate::operation_deser::parse_activate_key_signing_key_response(response)
        }
    }
}

/// Operation shape for `AssociateVPCWithHostedZone`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_vpc_with_hosted_zone`](crate::client::Client::associate_vpc_with_hosted_zone).
///
/// See [`crate::client::fluent_builders::AssociateVPCWithHostedZone`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateVPCWithHostedZone {
    _private: (),
}
impl AssociateVPCWithHostedZone {
    /// Creates a new builder-style object to manufacture [`AssociateVpcWithHostedZoneInput`](crate::input::AssociateVpcWithHostedZoneInput)
    pub fn builder() -> crate::input::associate_vpc_with_hosted_zone_input::Builder {
        crate::input::associate_vpc_with_hosted_zone_input::Builder::default()
    }
    /// Creates a new `AssociateVPCWithHostedZone` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateVPCWithHostedZone {
    type Output = std::result::Result<
        crate::output::AssociateVpcWithHostedZoneOutput,
        crate::error::AssociateVPCWithHostedZoneError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_vpc_with_hosted_zone_error(response)
        } else {
            crate::operation_deser::parse_associate_vpc_with_hosted_zone_response(response)
        }
    }
}

/// Operation shape for `ChangeResourceRecordSets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`change_resource_record_sets`](crate::client::Client::change_resource_record_sets).
///
/// See [`crate::client::fluent_builders::ChangeResourceRecordSets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ChangeResourceRecordSets {
    _private: (),
}
impl ChangeResourceRecordSets {
    /// Creates a new builder-style object to manufacture [`ChangeResourceRecordSetsInput`](crate::input::ChangeResourceRecordSetsInput)
    pub fn builder() -> crate::input::change_resource_record_sets_input::Builder {
        crate::input::change_resource_record_sets_input::Builder::default()
    }
    /// Creates a new `ChangeResourceRecordSets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ChangeResourceRecordSets {
    type Output = std::result::Result<
        crate::output::ChangeResourceRecordSetsOutput,
        crate::error::ChangeResourceRecordSetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_change_resource_record_sets_error(response)
        } else {
            crate::operation_deser::parse_change_resource_record_sets_response(response)
        }
    }
}

/// Operation shape for `ChangeTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`change_tags_for_resource`](crate::client::Client::change_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ChangeTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ChangeTagsForResource {
    _private: (),
}
impl ChangeTagsForResource {
    /// Creates a new builder-style object to manufacture [`ChangeTagsForResourceInput`](crate::input::ChangeTagsForResourceInput)
    pub fn builder() -> crate::input::change_tags_for_resource_input::Builder {
        crate::input::change_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ChangeTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ChangeTagsForResource {
    type Output = std::result::Result<
        crate::output::ChangeTagsForResourceOutput,
        crate::error::ChangeTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_change_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_change_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `CreateHealthCheck`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_health_check`](crate::client::Client::create_health_check).
///
/// See [`crate::client::fluent_builders::CreateHealthCheck`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateHealthCheck {
    _private: (),
}
impl CreateHealthCheck {
    /// Creates a new builder-style object to manufacture [`CreateHealthCheckInput`](crate::input::CreateHealthCheckInput)
    pub fn builder() -> crate::input::create_health_check_input::Builder {
        crate::input::create_health_check_input::Builder::default()
    }
    /// Creates a new `CreateHealthCheck` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateHealthCheck {
    type Output = std::result::Result<
        crate::output::CreateHealthCheckOutput,
        crate::error::CreateHealthCheckError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_health_check_error(response)
        } else {
            crate::operation_deser::parse_create_health_check_response(response)
        }
    }
}

/// Operation shape for `CreateHostedZone`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_hosted_zone`](crate::client::Client::create_hosted_zone).
///
/// See [`crate::client::fluent_builders::CreateHostedZone`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateHostedZone {
    _private: (),
}
impl CreateHostedZone {
    /// Creates a new builder-style object to manufacture [`CreateHostedZoneInput`](crate::input::CreateHostedZoneInput)
    pub fn builder() -> crate::input::create_hosted_zone_input::Builder {
        crate::input::create_hosted_zone_input::Builder::default()
    }
    /// Creates a new `CreateHostedZone` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateHostedZone {
    type Output = std::result::Result<
        crate::output::CreateHostedZoneOutput,
        crate::error::CreateHostedZoneError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_hosted_zone_error(response)
        } else {
            crate::operation_deser::parse_create_hosted_zone_response(response)
        }
    }
}

/// Operation shape for `CreateKeySigningKey`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_key_signing_key`](crate::client::Client::create_key_signing_key).
///
/// See [`crate::client::fluent_builders::CreateKeySigningKey`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateKeySigningKey {
    _private: (),
}
impl CreateKeySigningKey {
    /// Creates a new builder-style object to manufacture [`CreateKeySigningKeyInput`](crate::input::CreateKeySigningKeyInput)
    pub fn builder() -> crate::input::create_key_signing_key_input::Builder {
        crate::input::create_key_signing_key_input::Builder::default()
    }
    /// Creates a new `CreateKeySigningKey` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateKeySigningKey {
    type Output = std::result::Result<
        crate::output::CreateKeySigningKeyOutput,
        crate::error::CreateKeySigningKeyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_key_signing_key_error(response)
        } else {
            crate::operation_deser::parse_create_key_signing_key_response(response)
        }
    }
}

/// Operation shape for `CreateQueryLoggingConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_query_logging_config`](crate::client::Client::create_query_logging_config).
///
/// See [`crate::client::fluent_builders::CreateQueryLoggingConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateQueryLoggingConfig {
    _private: (),
}
impl CreateQueryLoggingConfig {
    /// Creates a new builder-style object to manufacture [`CreateQueryLoggingConfigInput`](crate::input::CreateQueryLoggingConfigInput)
    pub fn builder() -> crate::input::create_query_logging_config_input::Builder {
        crate::input::create_query_logging_config_input::Builder::default()
    }
    /// Creates a new `CreateQueryLoggingConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateQueryLoggingConfig {
    type Output = std::result::Result<
        crate::output::CreateQueryLoggingConfigOutput,
        crate::error::CreateQueryLoggingConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_query_logging_config_error(response)
        } else {
            crate::operation_deser::parse_create_query_logging_config_response(response)
        }
    }
}

/// Operation shape for `CreateReusableDelegationSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_reusable_delegation_set`](crate::client::Client::create_reusable_delegation_set).
///
/// See [`crate::client::fluent_builders::CreateReusableDelegationSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateReusableDelegationSet {
    _private: (),
}
impl CreateReusableDelegationSet {
    /// Creates a new builder-style object to manufacture [`CreateReusableDelegationSetInput`](crate::input::CreateReusableDelegationSetInput)
    pub fn builder() -> crate::input::create_reusable_delegation_set_input::Builder {
        crate::input::create_reusable_delegation_set_input::Builder::default()
    }
    /// Creates a new `CreateReusableDelegationSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateReusableDelegationSet {
    type Output = std::result::Result<
        crate::output::CreateReusableDelegationSetOutput,
        crate::error::CreateReusableDelegationSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_reusable_delegation_set_error(response)
        } else {
            crate::operation_deser::parse_create_reusable_delegation_set_response(response)
        }
    }
}

/// Operation shape for `CreateTrafficPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_traffic_policy`](crate::client::Client::create_traffic_policy).
///
/// See [`crate::client::fluent_builders::CreateTrafficPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTrafficPolicy {
    _private: (),
}
impl CreateTrafficPolicy {
    /// Creates a new builder-style object to manufacture [`CreateTrafficPolicyInput`](crate::input::CreateTrafficPolicyInput)
    pub fn builder() -> crate::input::create_traffic_policy_input::Builder {
        crate::input::create_traffic_policy_input::Builder::default()
    }
    /// Creates a new `CreateTrafficPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTrafficPolicy {
    type Output = std::result::Result<
        crate::output::CreateTrafficPolicyOutput,
        crate::error::CreateTrafficPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_traffic_policy_error(response)
        } else {
            crate::operation_deser::parse_create_traffic_policy_response(response)
        }
    }
}

/// Operation shape for `CreateTrafficPolicyInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_traffic_policy_instance`](crate::client::Client::create_traffic_policy_instance).
///
/// See [`crate::client::fluent_builders::CreateTrafficPolicyInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTrafficPolicyInstance {
    _private: (),
}
impl CreateTrafficPolicyInstance {
    /// Creates a new builder-style object to manufacture [`CreateTrafficPolicyInstanceInput`](crate::input::CreateTrafficPolicyInstanceInput)
    pub fn builder() -> crate::input::create_traffic_policy_instance_input::Builder {
        crate::input::create_traffic_policy_instance_input::Builder::default()
    }
    /// Creates a new `CreateTrafficPolicyInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTrafficPolicyInstance {
    type Output = std::result::Result<
        crate::output::CreateTrafficPolicyInstanceOutput,
        crate::error::CreateTrafficPolicyInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_traffic_policy_instance_error(response)
        } else {
            crate::operation_deser::parse_create_traffic_policy_instance_response(response)
        }
    }
}

/// Operation shape for `CreateTrafficPolicyVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_traffic_policy_version`](crate::client::Client::create_traffic_policy_version).
///
/// See [`crate::client::fluent_builders::CreateTrafficPolicyVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTrafficPolicyVersion {
    _private: (),
}
impl CreateTrafficPolicyVersion {
    /// Creates a new builder-style object to manufacture [`CreateTrafficPolicyVersionInput`](crate::input::CreateTrafficPolicyVersionInput)
    pub fn builder() -> crate::input::create_traffic_policy_version_input::Builder {
        crate::input::create_traffic_policy_version_input::Builder::default()
    }
    /// Creates a new `CreateTrafficPolicyVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTrafficPolicyVersion {
    type Output = std::result::Result<
        crate::output::CreateTrafficPolicyVersionOutput,
        crate::error::CreateTrafficPolicyVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_traffic_policy_version_error(response)
        } else {
            crate::operation_deser::parse_create_traffic_policy_version_response(response)
        }
    }
}

/// Operation shape for `CreateVPCAssociationAuthorization`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_vpc_association_authorization`](crate::client::Client::create_vpc_association_authorization).
///
/// See [`crate::client::fluent_builders::CreateVPCAssociationAuthorization`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateVPCAssociationAuthorization {
    _private: (),
}
impl CreateVPCAssociationAuthorization {
    /// Creates a new builder-style object to manufacture [`CreateVpcAssociationAuthorizationInput`](crate::input::CreateVpcAssociationAuthorizationInput)
    pub fn builder() -> crate::input::create_vpc_association_authorization_input::Builder {
        crate::input::create_vpc_association_authorization_input::Builder::default()
    }
    /// Creates a new `CreateVPCAssociationAuthorization` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateVPCAssociationAuthorization {
    type Output = std::result::Result<
        crate::output::CreateVpcAssociationAuthorizationOutput,
        crate::error::CreateVPCAssociationAuthorizationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_vpc_association_authorization_error(response)
        } else {
            crate::operation_deser::parse_create_vpc_association_authorization_response(response)
        }
    }
}

/// Operation shape for `DeactivateKeySigningKey`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deactivate_key_signing_key`](crate::client::Client::deactivate_key_signing_key).
///
/// See [`crate::client::fluent_builders::DeactivateKeySigningKey`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeactivateKeySigningKey {
    _private: (),
}
impl DeactivateKeySigningKey {
    /// Creates a new builder-style object to manufacture [`DeactivateKeySigningKeyInput`](crate::input::DeactivateKeySigningKeyInput)
    pub fn builder() -> crate::input::deactivate_key_signing_key_input::Builder {
        crate::input::deactivate_key_signing_key_input::Builder::default()
    }
    /// Creates a new `DeactivateKeySigningKey` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeactivateKeySigningKey {
    type Output = std::result::Result<
        crate::output::DeactivateKeySigningKeyOutput,
        crate::error::DeactivateKeySigningKeyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deactivate_key_signing_key_error(response)
        } else {
            crate::operation_deser::parse_deactivate_key_signing_key_response(response)
        }
    }
}

/// Operation shape for `DeleteHealthCheck`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_health_check`](crate::client::Client::delete_health_check).
///
/// See [`crate::client::fluent_builders::DeleteHealthCheck`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteHealthCheck {
    _private: (),
}
impl DeleteHealthCheck {
    /// Creates a new builder-style object to manufacture [`DeleteHealthCheckInput`](crate::input::DeleteHealthCheckInput)
    pub fn builder() -> crate::input::delete_health_check_input::Builder {
        crate::input::delete_health_check_input::Builder::default()
    }
    /// Creates a new `DeleteHealthCheck` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteHealthCheck {
    type Output = std::result::Result<
        crate::output::DeleteHealthCheckOutput,
        crate::error::DeleteHealthCheckError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_health_check_error(response)
        } else {
            crate::operation_deser::parse_delete_health_check_response(response)
        }
    }
}

/// Operation shape for `DeleteHostedZone`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_hosted_zone`](crate::client::Client::delete_hosted_zone).
///
/// See [`crate::client::fluent_builders::DeleteHostedZone`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteHostedZone {
    _private: (),
}
impl DeleteHostedZone {
    /// Creates a new builder-style object to manufacture [`DeleteHostedZoneInput`](crate::input::DeleteHostedZoneInput)
    pub fn builder() -> crate::input::delete_hosted_zone_input::Builder {
        crate::input::delete_hosted_zone_input::Builder::default()
    }
    /// Creates a new `DeleteHostedZone` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteHostedZone {
    type Output = std::result::Result<
        crate::output::DeleteHostedZoneOutput,
        crate::error::DeleteHostedZoneError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_hosted_zone_error(response)
        } else {
            crate::operation_deser::parse_delete_hosted_zone_response(response)
        }
    }
}

/// Operation shape for `DeleteKeySigningKey`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_key_signing_key`](crate::client::Client::delete_key_signing_key).
///
/// See [`crate::client::fluent_builders::DeleteKeySigningKey`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteKeySigningKey {
    _private: (),
}
impl DeleteKeySigningKey {
    /// Creates a new builder-style object to manufacture [`DeleteKeySigningKeyInput`](crate::input::DeleteKeySigningKeyInput)
    pub fn builder() -> crate::input::delete_key_signing_key_input::Builder {
        crate::input::delete_key_signing_key_input::Builder::default()
    }
    /// Creates a new `DeleteKeySigningKey` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteKeySigningKey {
    type Output = std::result::Result<
        crate::output::DeleteKeySigningKeyOutput,
        crate::error::DeleteKeySigningKeyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_key_signing_key_error(response)
        } else {
            crate::operation_deser::parse_delete_key_signing_key_response(response)
        }
    }
}

/// Operation shape for `DeleteQueryLoggingConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_query_logging_config`](crate::client::Client::delete_query_logging_config).
///
/// See [`crate::client::fluent_builders::DeleteQueryLoggingConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteQueryLoggingConfig {
    _private: (),
}
impl DeleteQueryLoggingConfig {
    /// Creates a new builder-style object to manufacture [`DeleteQueryLoggingConfigInput`](crate::input::DeleteQueryLoggingConfigInput)
    pub fn builder() -> crate::input::delete_query_logging_config_input::Builder {
        crate::input::delete_query_logging_config_input::Builder::default()
    }
    /// Creates a new `DeleteQueryLoggingConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteQueryLoggingConfig {
    type Output = std::result::Result<
        crate::output::DeleteQueryLoggingConfigOutput,
        crate::error::DeleteQueryLoggingConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_query_logging_config_error(response)
        } else {
            crate::operation_deser::parse_delete_query_logging_config_response(response)
        }
    }
}

/// Operation shape for `DeleteReusableDelegationSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_reusable_delegation_set`](crate::client::Client::delete_reusable_delegation_set).
///
/// See [`crate::client::fluent_builders::DeleteReusableDelegationSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteReusableDelegationSet {
    _private: (),
}
impl DeleteReusableDelegationSet {
    /// Creates a new builder-style object to manufacture [`DeleteReusableDelegationSetInput`](crate::input::DeleteReusableDelegationSetInput)
    pub fn builder() -> crate::input::delete_reusable_delegation_set_input::Builder {
        crate::input::delete_reusable_delegation_set_input::Builder::default()
    }
    /// Creates a new `DeleteReusableDelegationSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteReusableDelegationSet {
    type Output = std::result::Result<
        crate::output::DeleteReusableDelegationSetOutput,
        crate::error::DeleteReusableDelegationSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_reusable_delegation_set_error(response)
        } else {
            crate::operation_deser::parse_delete_reusable_delegation_set_response(response)
        }
    }
}

/// Operation shape for `DeleteTrafficPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_traffic_policy`](crate::client::Client::delete_traffic_policy).
///
/// See [`crate::client::fluent_builders::DeleteTrafficPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTrafficPolicy {
    _private: (),
}
impl DeleteTrafficPolicy {
    /// Creates a new builder-style object to manufacture [`DeleteTrafficPolicyInput`](crate::input::DeleteTrafficPolicyInput)
    pub fn builder() -> crate::input::delete_traffic_policy_input::Builder {
        crate::input::delete_traffic_policy_input::Builder::default()
    }
    /// Creates a new `DeleteTrafficPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTrafficPolicy {
    type Output = std::result::Result<
        crate::output::DeleteTrafficPolicyOutput,
        crate::error::DeleteTrafficPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_traffic_policy_error(response)
        } else {
            crate::operation_deser::parse_delete_traffic_policy_response(response)
        }
    }
}

/// Operation shape for `DeleteTrafficPolicyInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_traffic_policy_instance`](crate::client::Client::delete_traffic_policy_instance).
///
/// See [`crate::client::fluent_builders::DeleteTrafficPolicyInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTrafficPolicyInstance {
    _private: (),
}
impl DeleteTrafficPolicyInstance {
    /// Creates a new builder-style object to manufacture [`DeleteTrafficPolicyInstanceInput`](crate::input::DeleteTrafficPolicyInstanceInput)
    pub fn builder() -> crate::input::delete_traffic_policy_instance_input::Builder {
        crate::input::delete_traffic_policy_instance_input::Builder::default()
    }
    /// Creates a new `DeleteTrafficPolicyInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTrafficPolicyInstance {
    type Output = std::result::Result<
        crate::output::DeleteTrafficPolicyInstanceOutput,
        crate::error::DeleteTrafficPolicyInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_traffic_policy_instance_error(response)
        } else {
            crate::operation_deser::parse_delete_traffic_policy_instance_response(response)
        }
    }
}

/// Operation shape for `DeleteVPCAssociationAuthorization`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_vpc_association_authorization`](crate::client::Client::delete_vpc_association_authorization).
///
/// See [`crate::client::fluent_builders::DeleteVPCAssociationAuthorization`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteVPCAssociationAuthorization {
    _private: (),
}
impl DeleteVPCAssociationAuthorization {
    /// Creates a new builder-style object to manufacture [`DeleteVpcAssociationAuthorizationInput`](crate::input::DeleteVpcAssociationAuthorizationInput)
    pub fn builder() -> crate::input::delete_vpc_association_authorization_input::Builder {
        crate::input::delete_vpc_association_authorization_input::Builder::default()
    }
    /// Creates a new `DeleteVPCAssociationAuthorization` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteVPCAssociationAuthorization {
    type Output = std::result::Result<
        crate::output::DeleteVpcAssociationAuthorizationOutput,
        crate::error::DeleteVPCAssociationAuthorizationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_vpc_association_authorization_error(response)
        } else {
            crate::operation_deser::parse_delete_vpc_association_authorization_response(response)
        }
    }
}

/// Operation shape for `DisableHostedZoneDNSSEC`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_hosted_zone_dnssec`](crate::client::Client::disable_hosted_zone_dnssec).
///
/// See [`crate::client::fluent_builders::DisableHostedZoneDNSSEC`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableHostedZoneDNSSEC {
    _private: (),
}
impl DisableHostedZoneDNSSEC {
    /// Creates a new builder-style object to manufacture [`DisableHostedZoneDnssecInput`](crate::input::DisableHostedZoneDnssecInput)
    pub fn builder() -> crate::input::disable_hosted_zone_dnssec_input::Builder {
        crate::input::disable_hosted_zone_dnssec_input::Builder::default()
    }
    /// Creates a new `DisableHostedZoneDNSSEC` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableHostedZoneDNSSEC {
    type Output = std::result::Result<
        crate::output::DisableHostedZoneDnssecOutput,
        crate::error::DisableHostedZoneDNSSECError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_hosted_zone_dnssec_error(response)
        } else {
            crate::operation_deser::parse_disable_hosted_zone_dnssec_response(response)
        }
    }
}

/// Operation shape for `DisassociateVPCFromHostedZone`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_vpc_from_hosted_zone`](crate::client::Client::disassociate_vpc_from_hosted_zone).
///
/// See [`crate::client::fluent_builders::DisassociateVPCFromHostedZone`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateVPCFromHostedZone {
    _private: (),
}
impl DisassociateVPCFromHostedZone {
    /// Creates a new builder-style object to manufacture [`DisassociateVpcFromHostedZoneInput`](crate::input::DisassociateVpcFromHostedZoneInput)
    pub fn builder() -> crate::input::disassociate_vpc_from_hosted_zone_input::Builder {
        crate::input::disassociate_vpc_from_hosted_zone_input::Builder::default()
    }
    /// Creates a new `DisassociateVPCFromHostedZone` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateVPCFromHostedZone {
    type Output = std::result::Result<
        crate::output::DisassociateVpcFromHostedZoneOutput,
        crate::error::DisassociateVPCFromHostedZoneError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_vpc_from_hosted_zone_error(response)
        } else {
            crate::operation_deser::parse_disassociate_vpc_from_hosted_zone_response(response)
        }
    }
}

/// Operation shape for `EnableHostedZoneDNSSEC`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_hosted_zone_dnssec`](crate::client::Client::enable_hosted_zone_dnssec).
///
/// See [`crate::client::fluent_builders::EnableHostedZoneDNSSEC`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableHostedZoneDNSSEC {
    _private: (),
}
impl EnableHostedZoneDNSSEC {
    /// Creates a new builder-style object to manufacture [`EnableHostedZoneDnssecInput`](crate::input::EnableHostedZoneDnssecInput)
    pub fn builder() -> crate::input::enable_hosted_zone_dnssec_input::Builder {
        crate::input::enable_hosted_zone_dnssec_input::Builder::default()
    }
    /// Creates a new `EnableHostedZoneDNSSEC` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableHostedZoneDNSSEC {
    type Output = std::result::Result<
        crate::output::EnableHostedZoneDnssecOutput,
        crate::error::EnableHostedZoneDNSSECError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_hosted_zone_dnssec_error(response)
        } else {
            crate::operation_deser::parse_enable_hosted_zone_dnssec_response(response)
        }
    }
}

/// Operation shape for `GetAccountLimit`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_account_limit`](crate::client::Client::get_account_limit).
///
/// See [`crate::client::fluent_builders::GetAccountLimit`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAccountLimit {
    _private: (),
}
impl GetAccountLimit {
    /// Creates a new builder-style object to manufacture [`GetAccountLimitInput`](crate::input::GetAccountLimitInput)
    pub fn builder() -> crate::input::get_account_limit_input::Builder {
        crate::input::get_account_limit_input::Builder::default()
    }
    /// Creates a new `GetAccountLimit` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAccountLimit {
    type Output = std::result::Result<
        crate::output::GetAccountLimitOutput,
        crate::error::GetAccountLimitError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_account_limit_error(response)
        } else {
            crate::operation_deser::parse_get_account_limit_response(response)
        }
    }
}

/// Operation shape for `GetChange`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_change`](crate::client::Client::get_change).
///
/// See [`crate::client::fluent_builders::GetChange`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetChange {
    _private: (),
}
impl GetChange {
    /// Creates a new builder-style object to manufacture [`GetChangeInput`](crate::input::GetChangeInput)
    pub fn builder() -> crate::input::get_change_input::Builder {
        crate::input::get_change_input::Builder::default()
    }
    /// Creates a new `GetChange` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetChange {
    type Output = std::result::Result<crate::output::GetChangeOutput, crate::error::GetChangeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_change_error(response)
        } else {
            crate::operation_deser::parse_get_change_response(response)
        }
    }
}

/// Operation shape for `GetCheckerIpRanges`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_checker_ip_ranges`](crate::client::Client::get_checker_ip_ranges).
///
/// See [`crate::client::fluent_builders::GetCheckerIpRanges`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCheckerIpRanges {
    _private: (),
}
impl GetCheckerIpRanges {
    /// Creates a new builder-style object to manufacture [`GetCheckerIpRangesInput`](crate::input::GetCheckerIpRangesInput)
    pub fn builder() -> crate::input::get_checker_ip_ranges_input::Builder {
        crate::input::get_checker_ip_ranges_input::Builder::default()
    }
    /// Creates a new `GetCheckerIpRanges` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCheckerIpRanges {
    type Output = std::result::Result<
        crate::output::GetCheckerIpRangesOutput,
        crate::error::GetCheckerIpRangesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_checker_ip_ranges_error(response)
        } else {
            crate::operation_deser::parse_get_checker_ip_ranges_response(response)
        }
    }
}

/// Operation shape for `GetDNSSEC`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_dnssec`](crate::client::Client::get_dnssec).
///
/// See [`crate::client::fluent_builders::GetDNSSEC`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDNSSEC {
    _private: (),
}
impl GetDNSSEC {
    /// Creates a new builder-style object to manufacture [`GetDnssecInput`](crate::input::GetDnssecInput)
    pub fn builder() -> crate::input::get_dnssec_input::Builder {
        crate::input::get_dnssec_input::Builder::default()
    }
    /// Creates a new `GetDNSSEC` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDNSSEC {
    type Output = std::result::Result<crate::output::GetDnssecOutput, crate::error::GetDNSSECError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_dnssec_error(response)
        } else {
            crate::operation_deser::parse_get_dnssec_response(response)
        }
    }
}

/// Operation shape for `GetGeoLocation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_geo_location`](crate::client::Client::get_geo_location).
///
/// See [`crate::client::fluent_builders::GetGeoLocation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetGeoLocation {
    _private: (),
}
impl GetGeoLocation {
    /// Creates a new builder-style object to manufacture [`GetGeoLocationInput`](crate::input::GetGeoLocationInput)
    pub fn builder() -> crate::input::get_geo_location_input::Builder {
        crate::input::get_geo_location_input::Builder::default()
    }
    /// Creates a new `GetGeoLocation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetGeoLocation {
    type Output =
        std::result::Result<crate::output::GetGeoLocationOutput, crate::error::GetGeoLocationError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_geo_location_error(response)
        } else {
            crate::operation_deser::parse_get_geo_location_response(response)
        }
    }
}

/// Operation shape for `GetHealthCheck`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_health_check`](crate::client::Client::get_health_check).
///
/// See [`crate::client::fluent_builders::GetHealthCheck`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetHealthCheck {
    _private: (),
}
impl GetHealthCheck {
    /// Creates a new builder-style object to manufacture [`GetHealthCheckInput`](crate::input::GetHealthCheckInput)
    pub fn builder() -> crate::input::get_health_check_input::Builder {
        crate::input::get_health_check_input::Builder::default()
    }
    /// Creates a new `GetHealthCheck` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetHealthCheck {
    type Output =
        std::result::Result<crate::output::GetHealthCheckOutput, crate::error::GetHealthCheckError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_health_check_error(response)
        } else {
            crate::operation_deser::parse_get_health_check_response(response)
        }
    }
}

/// Operation shape for `GetHealthCheckCount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_health_check_count`](crate::client::Client::get_health_check_count).
///
/// See [`crate::client::fluent_builders::GetHealthCheckCount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetHealthCheckCount {
    _private: (),
}
impl GetHealthCheckCount {
    /// Creates a new builder-style object to manufacture [`GetHealthCheckCountInput`](crate::input::GetHealthCheckCountInput)
    pub fn builder() -> crate::input::get_health_check_count_input::Builder {
        crate::input::get_health_check_count_input::Builder::default()
    }
    /// Creates a new `GetHealthCheckCount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetHealthCheckCount {
    type Output = std::result::Result<
        crate::output::GetHealthCheckCountOutput,
        crate::error::GetHealthCheckCountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_health_check_count_error(response)
        } else {
            crate::operation_deser::parse_get_health_check_count_response(response)
        }
    }
}

/// Operation shape for `GetHealthCheckLastFailureReason`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_health_check_last_failure_reason`](crate::client::Client::get_health_check_last_failure_reason).
///
/// See [`crate::client::fluent_builders::GetHealthCheckLastFailureReason`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetHealthCheckLastFailureReason {
    _private: (),
}
impl GetHealthCheckLastFailureReason {
    /// Creates a new builder-style object to manufacture [`GetHealthCheckLastFailureReasonInput`](crate::input::GetHealthCheckLastFailureReasonInput)
    pub fn builder() -> crate::input::get_health_check_last_failure_reason_input::Builder {
        crate::input::get_health_check_last_failure_reason_input::Builder::default()
    }
    /// Creates a new `GetHealthCheckLastFailureReason` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetHealthCheckLastFailureReason {
    type Output = std::result::Result<
        crate::output::GetHealthCheckLastFailureReasonOutput,
        crate::error::GetHealthCheckLastFailureReasonError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_health_check_last_failure_reason_error(response)
        } else {
            crate::operation_deser::parse_get_health_check_last_failure_reason_response(response)
        }
    }
}

/// Operation shape for `GetHealthCheckStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_health_check_status`](crate::client::Client::get_health_check_status).
///
/// See [`crate::client::fluent_builders::GetHealthCheckStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetHealthCheckStatus {
    _private: (),
}
impl GetHealthCheckStatus {
    /// Creates a new builder-style object to manufacture [`GetHealthCheckStatusInput`](crate::input::GetHealthCheckStatusInput)
    pub fn builder() -> crate::input::get_health_check_status_input::Builder {
        crate::input::get_health_check_status_input::Builder::default()
    }
    /// Creates a new `GetHealthCheckStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetHealthCheckStatus {
    type Output = std::result::Result<
        crate::output::GetHealthCheckStatusOutput,
        crate::error::GetHealthCheckStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_health_check_status_error(response)
        } else {
            crate::operation_deser::parse_get_health_check_status_response(response)
        }
    }
}

/// Operation shape for `GetHostedZone`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_hosted_zone`](crate::client::Client::get_hosted_zone).
///
/// See [`crate::client::fluent_builders::GetHostedZone`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetHostedZone {
    _private: (),
}
impl GetHostedZone {
    /// Creates a new builder-style object to manufacture [`GetHostedZoneInput`](crate::input::GetHostedZoneInput)
    pub fn builder() -> crate::input::get_hosted_zone_input::Builder {
        crate::input::get_hosted_zone_input::Builder::default()
    }
    /// Creates a new `GetHostedZone` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetHostedZone {
    type Output =
        std::result::Result<crate::output::GetHostedZoneOutput, crate::error::GetHostedZoneError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_hosted_zone_error(response)
        } else {
            crate::operation_deser::parse_get_hosted_zone_response(response)
        }
    }
}

/// Operation shape for `GetHostedZoneCount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_hosted_zone_count`](crate::client::Client::get_hosted_zone_count).
///
/// See [`crate::client::fluent_builders::GetHostedZoneCount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetHostedZoneCount {
    _private: (),
}
impl GetHostedZoneCount {
    /// Creates a new builder-style object to manufacture [`GetHostedZoneCountInput`](crate::input::GetHostedZoneCountInput)
    pub fn builder() -> crate::input::get_hosted_zone_count_input::Builder {
        crate::input::get_hosted_zone_count_input::Builder::default()
    }
    /// Creates a new `GetHostedZoneCount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetHostedZoneCount {
    type Output = std::result::Result<
        crate::output::GetHostedZoneCountOutput,
        crate::error::GetHostedZoneCountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_hosted_zone_count_error(response)
        } else {
            crate::operation_deser::parse_get_hosted_zone_count_response(response)
        }
    }
}

/// Operation shape for `GetHostedZoneLimit`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_hosted_zone_limit`](crate::client::Client::get_hosted_zone_limit).
///
/// See [`crate::client::fluent_builders::GetHostedZoneLimit`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetHostedZoneLimit {
    _private: (),
}
impl GetHostedZoneLimit {
    /// Creates a new builder-style object to manufacture [`GetHostedZoneLimitInput`](crate::input::GetHostedZoneLimitInput)
    pub fn builder() -> crate::input::get_hosted_zone_limit_input::Builder {
        crate::input::get_hosted_zone_limit_input::Builder::default()
    }
    /// Creates a new `GetHostedZoneLimit` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetHostedZoneLimit {
    type Output = std::result::Result<
        crate::output::GetHostedZoneLimitOutput,
        crate::error::GetHostedZoneLimitError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_hosted_zone_limit_error(response)
        } else {
            crate::operation_deser::parse_get_hosted_zone_limit_response(response)
        }
    }
}

/// Operation shape for `GetQueryLoggingConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_query_logging_config`](crate::client::Client::get_query_logging_config).
///
/// See [`crate::client::fluent_builders::GetQueryLoggingConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetQueryLoggingConfig {
    _private: (),
}
impl GetQueryLoggingConfig {
    /// Creates a new builder-style object to manufacture [`GetQueryLoggingConfigInput`](crate::input::GetQueryLoggingConfigInput)
    pub fn builder() -> crate::input::get_query_logging_config_input::Builder {
        crate::input::get_query_logging_config_input::Builder::default()
    }
    /// Creates a new `GetQueryLoggingConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetQueryLoggingConfig {
    type Output = std::result::Result<
        crate::output::GetQueryLoggingConfigOutput,
        crate::error::GetQueryLoggingConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_query_logging_config_error(response)
        } else {
            crate::operation_deser::parse_get_query_logging_config_response(response)
        }
    }
}

/// Operation shape for `GetReusableDelegationSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_reusable_delegation_set`](crate::client::Client::get_reusable_delegation_set).
///
/// See [`crate::client::fluent_builders::GetReusableDelegationSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetReusableDelegationSet {
    _private: (),
}
impl GetReusableDelegationSet {
    /// Creates a new builder-style object to manufacture [`GetReusableDelegationSetInput`](crate::input::GetReusableDelegationSetInput)
    pub fn builder() -> crate::input::get_reusable_delegation_set_input::Builder {
        crate::input::get_reusable_delegation_set_input::Builder::default()
    }
    /// Creates a new `GetReusableDelegationSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetReusableDelegationSet {
    type Output = std::result::Result<
        crate::output::GetReusableDelegationSetOutput,
        crate::error::GetReusableDelegationSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_reusable_delegation_set_error(response)
        } else {
            crate::operation_deser::parse_get_reusable_delegation_set_response(response)
        }
    }
}

/// Operation shape for `GetReusableDelegationSetLimit`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_reusable_delegation_set_limit`](crate::client::Client::get_reusable_delegation_set_limit).
///
/// See [`crate::client::fluent_builders::GetReusableDelegationSetLimit`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetReusableDelegationSetLimit {
    _private: (),
}
impl GetReusableDelegationSetLimit {
    /// Creates a new builder-style object to manufacture [`GetReusableDelegationSetLimitInput`](crate::input::GetReusableDelegationSetLimitInput)
    pub fn builder() -> crate::input::get_reusable_delegation_set_limit_input::Builder {
        crate::input::get_reusable_delegation_set_limit_input::Builder::default()
    }
    /// Creates a new `GetReusableDelegationSetLimit` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetReusableDelegationSetLimit {
    type Output = std::result::Result<
        crate::output::GetReusableDelegationSetLimitOutput,
        crate::error::GetReusableDelegationSetLimitError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_reusable_delegation_set_limit_error(response)
        } else {
            crate::operation_deser::parse_get_reusable_delegation_set_limit_response(response)
        }
    }
}

/// Operation shape for `GetTrafficPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_traffic_policy`](crate::client::Client::get_traffic_policy).
///
/// See [`crate::client::fluent_builders::GetTrafficPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTrafficPolicy {
    _private: (),
}
impl GetTrafficPolicy {
    /// Creates a new builder-style object to manufacture [`GetTrafficPolicyInput`](crate::input::GetTrafficPolicyInput)
    pub fn builder() -> crate::input::get_traffic_policy_input::Builder {
        crate::input::get_traffic_policy_input::Builder::default()
    }
    /// Creates a new `GetTrafficPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTrafficPolicy {
    type Output = std::result::Result<
        crate::output::GetTrafficPolicyOutput,
        crate::error::GetTrafficPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_traffic_policy_error(response)
        } else {
            crate::operation_deser::parse_get_traffic_policy_response(response)
        }
    }
}

/// Operation shape for `GetTrafficPolicyInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_traffic_policy_instance`](crate::client::Client::get_traffic_policy_instance).
///
/// See [`crate::client::fluent_builders::GetTrafficPolicyInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTrafficPolicyInstance {
    _private: (),
}
impl GetTrafficPolicyInstance {
    /// Creates a new builder-style object to manufacture [`GetTrafficPolicyInstanceInput`](crate::input::GetTrafficPolicyInstanceInput)
    pub fn builder() -> crate::input::get_traffic_policy_instance_input::Builder {
        crate::input::get_traffic_policy_instance_input::Builder::default()
    }
    /// Creates a new `GetTrafficPolicyInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTrafficPolicyInstance {
    type Output = std::result::Result<
        crate::output::GetTrafficPolicyInstanceOutput,
        crate::error::GetTrafficPolicyInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_traffic_policy_instance_error(response)
        } else {
            crate::operation_deser::parse_get_traffic_policy_instance_response(response)
        }
    }
}

/// Operation shape for `GetTrafficPolicyInstanceCount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_traffic_policy_instance_count`](crate::client::Client::get_traffic_policy_instance_count).
///
/// See [`crate::client::fluent_builders::GetTrafficPolicyInstanceCount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTrafficPolicyInstanceCount {
    _private: (),
}
impl GetTrafficPolicyInstanceCount {
    /// Creates a new builder-style object to manufacture [`GetTrafficPolicyInstanceCountInput`](crate::input::GetTrafficPolicyInstanceCountInput)
    pub fn builder() -> crate::input::get_traffic_policy_instance_count_input::Builder {
        crate::input::get_traffic_policy_instance_count_input::Builder::default()
    }
    /// Creates a new `GetTrafficPolicyInstanceCount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTrafficPolicyInstanceCount {
    type Output = std::result::Result<
        crate::output::GetTrafficPolicyInstanceCountOutput,
        crate::error::GetTrafficPolicyInstanceCountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_traffic_policy_instance_count_error(response)
        } else {
            crate::operation_deser::parse_get_traffic_policy_instance_count_response(response)
        }
    }
}

/// Operation shape for `ListGeoLocations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_geo_locations`](crate::client::Client::list_geo_locations).
///
/// See [`crate::client::fluent_builders::ListGeoLocations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListGeoLocations {
    _private: (),
}
impl ListGeoLocations {
    /// Creates a new builder-style object to manufacture [`ListGeoLocationsInput`](crate::input::ListGeoLocationsInput)
    pub fn builder() -> crate::input::list_geo_locations_input::Builder {
        crate::input::list_geo_locations_input::Builder::default()
    }
    /// Creates a new `ListGeoLocations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListGeoLocations {
    type Output = std::result::Result<
        crate::output::ListGeoLocationsOutput,
        crate::error::ListGeoLocationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_geo_locations_error(response)
        } else {
            crate::operation_deser::parse_list_geo_locations_response(response)
        }
    }
}

/// Operation shape for `ListHealthChecks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_health_checks`](crate::client::Client::list_health_checks).
///
/// See [`crate::client::fluent_builders::ListHealthChecks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListHealthChecks {
    _private: (),
}
impl ListHealthChecks {
    /// Creates a new builder-style object to manufacture [`ListHealthChecksInput`](crate::input::ListHealthChecksInput)
    pub fn builder() -> crate::input::list_health_checks_input::Builder {
        crate::input::list_health_checks_input::Builder::default()
    }
    /// Creates a new `ListHealthChecks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListHealthChecks {
    type Output = std::result::Result<
        crate::output::ListHealthChecksOutput,
        crate::error::ListHealthChecksError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_health_checks_error(response)
        } else {
            crate::operation_deser::parse_list_health_checks_response(response)
        }
    }
}

/// Operation shape for `ListHostedZones`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_hosted_zones`](crate::client::Client::list_hosted_zones).
///
/// See [`crate::client::fluent_builders::ListHostedZones`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListHostedZones {
    _private: (),
}
impl ListHostedZones {
    /// Creates a new builder-style object to manufacture [`ListHostedZonesInput`](crate::input::ListHostedZonesInput)
    pub fn builder() -> crate::input::list_hosted_zones_input::Builder {
        crate::input::list_hosted_zones_input::Builder::default()
    }
    /// Creates a new `ListHostedZones` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListHostedZones {
    type Output = std::result::Result<
        crate::output::ListHostedZonesOutput,
        crate::error::ListHostedZonesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_hosted_zones_error(response)
        } else {
            crate::operation_deser::parse_list_hosted_zones_response(response)
        }
    }
}

/// Operation shape for `ListHostedZonesByName`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_hosted_zones_by_name`](crate::client::Client::list_hosted_zones_by_name).
///
/// See [`crate::client::fluent_builders::ListHostedZonesByName`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListHostedZonesByName {
    _private: (),
}
impl ListHostedZonesByName {
    /// Creates a new builder-style object to manufacture [`ListHostedZonesByNameInput`](crate::input::ListHostedZonesByNameInput)
    pub fn builder() -> crate::input::list_hosted_zones_by_name_input::Builder {
        crate::input::list_hosted_zones_by_name_input::Builder::default()
    }
    /// Creates a new `ListHostedZonesByName` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListHostedZonesByName {
    type Output = std::result::Result<
        crate::output::ListHostedZonesByNameOutput,
        crate::error::ListHostedZonesByNameError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_hosted_zones_by_name_error(response)
        } else {
            crate::operation_deser::parse_list_hosted_zones_by_name_response(response)
        }
    }
}

/// Operation shape for `ListHostedZonesByVPC`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_hosted_zones_by_vpc`](crate::client::Client::list_hosted_zones_by_vpc).
///
/// See [`crate::client::fluent_builders::ListHostedZonesByVPC`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListHostedZonesByVPC {
    _private: (),
}
impl ListHostedZonesByVPC {
    /// Creates a new builder-style object to manufacture [`ListHostedZonesByVpcInput`](crate::input::ListHostedZonesByVpcInput)
    pub fn builder() -> crate::input::list_hosted_zones_by_vpc_input::Builder {
        crate::input::list_hosted_zones_by_vpc_input::Builder::default()
    }
    /// Creates a new `ListHostedZonesByVPC` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListHostedZonesByVPC {
    type Output = std::result::Result<
        crate::output::ListHostedZonesByVpcOutput,
        crate::error::ListHostedZonesByVPCError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_hosted_zones_by_vpc_error(response)
        } else {
            crate::operation_deser::parse_list_hosted_zones_by_vpc_response(response)
        }
    }
}

/// Operation shape for `ListQueryLoggingConfigs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_query_logging_configs`](crate::client::Client::list_query_logging_configs).
///
/// See [`crate::client::fluent_builders::ListQueryLoggingConfigs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListQueryLoggingConfigs {
    _private: (),
}
impl ListQueryLoggingConfigs {
    /// Creates a new builder-style object to manufacture [`ListQueryLoggingConfigsInput`](crate::input::ListQueryLoggingConfigsInput)
    pub fn builder() -> crate::input::list_query_logging_configs_input::Builder {
        crate::input::list_query_logging_configs_input::Builder::default()
    }
    /// Creates a new `ListQueryLoggingConfigs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListQueryLoggingConfigs {
    type Output = std::result::Result<
        crate::output::ListQueryLoggingConfigsOutput,
        crate::error::ListQueryLoggingConfigsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_query_logging_configs_error(response)
        } else {
            crate::operation_deser::parse_list_query_logging_configs_response(response)
        }
    }
}

/// Operation shape for `ListResourceRecordSets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_resource_record_sets`](crate::client::Client::list_resource_record_sets).
///
/// See [`crate::client::fluent_builders::ListResourceRecordSets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListResourceRecordSets {
    _private: (),
}
impl ListResourceRecordSets {
    /// Creates a new builder-style object to manufacture [`ListResourceRecordSetsInput`](crate::input::ListResourceRecordSetsInput)
    pub fn builder() -> crate::input::list_resource_record_sets_input::Builder {
        crate::input::list_resource_record_sets_input::Builder::default()
    }
    /// Creates a new `ListResourceRecordSets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListResourceRecordSets {
    type Output = std::result::Result<
        crate::output::ListResourceRecordSetsOutput,
        crate::error::ListResourceRecordSetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_resource_record_sets_error(response)
        } else {
            crate::operation_deser::parse_list_resource_record_sets_response(response)
        }
    }
}
#[cfg(test)]
#[allow(unreachable_code, unused_variables)]
mod list_resource_record_sets_request_test {
    /// This test validates that that hosted zone is correctly trimmed
    /// Test ID: ListResourceRecordSetsTrimHostdZone
    #[tokio::test]
    async fn list_resource_record_sets_trim_hostd_zone_request() {
        let config = crate::config::Config::builder().build();
        let input = crate::input::ListResourceRecordSetsInput::builder()
            .set_hosted_zone_id(Some("/hostedzone/IDOFMYHOSTEDZONE".to_string()))
            .build()
            .unwrap()
            .make_operation(&config)
            .await
            .expect("operation failed to build");
        let (http_request, parts) = input.into_request_response().0.into_parts();
        pretty_assertions::assert_eq!(http_request.method(), "GET");
        pretty_assertions::assert_eq!(
            http_request.uri().path(),
            "/2013-04-01/hostedzone/IDOFMYHOSTEDZONE/rrset"
        );
    }
}

/// Operation shape for `ListReusableDelegationSets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_reusable_delegation_sets`](crate::client::Client::list_reusable_delegation_sets).
///
/// See [`crate::client::fluent_builders::ListReusableDelegationSets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListReusableDelegationSets {
    _private: (),
}
impl ListReusableDelegationSets {
    /// Creates a new builder-style object to manufacture [`ListReusableDelegationSetsInput`](crate::input::ListReusableDelegationSetsInput)
    pub fn builder() -> crate::input::list_reusable_delegation_sets_input::Builder {
        crate::input::list_reusable_delegation_sets_input::Builder::default()
    }
    /// Creates a new `ListReusableDelegationSets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListReusableDelegationSets {
    type Output = std::result::Result<
        crate::output::ListReusableDelegationSetsOutput,
        crate::error::ListReusableDelegationSetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_reusable_delegation_sets_error(response)
        } else {
            crate::operation_deser::parse_list_reusable_delegation_sets_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResources`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resources`](crate::client::Client::list_tags_for_resources).
///
/// See [`crate::client::fluent_builders::ListTagsForResources`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResources {
    _private: (),
}
impl ListTagsForResources {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourcesInput`](crate::input::ListTagsForResourcesInput)
    pub fn builder() -> crate::input::list_tags_for_resources_input::Builder {
        crate::input::list_tags_for_resources_input::Builder::default()
    }
    /// Creates a new `ListTagsForResources` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResources {
    type Output = std::result::Result<
        crate::output::ListTagsForResourcesOutput,
        crate::error::ListTagsForResourcesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resources_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resources_response(response)
        }
    }
}

/// Operation shape for `ListTrafficPolicies`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_traffic_policies`](crate::client::Client::list_traffic_policies).
///
/// See [`crate::client::fluent_builders::ListTrafficPolicies`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTrafficPolicies {
    _private: (),
}
impl ListTrafficPolicies {
    /// Creates a new builder-style object to manufacture [`ListTrafficPoliciesInput`](crate::input::ListTrafficPoliciesInput)
    pub fn builder() -> crate::input::list_traffic_policies_input::Builder {
        crate::input::list_traffic_policies_input::Builder::default()
    }
    /// Creates a new `ListTrafficPolicies` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTrafficPolicies {
    type Output = std::result::Result<
        crate::output::ListTrafficPoliciesOutput,
        crate::error::ListTrafficPoliciesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_traffic_policies_error(response)
        } else {
            crate::operation_deser::parse_list_traffic_policies_response(response)
        }
    }
}

/// Operation shape for `ListTrafficPolicyInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_traffic_policy_instances`](crate::client::Client::list_traffic_policy_instances).
///
/// See [`crate::client::fluent_builders::ListTrafficPolicyInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTrafficPolicyInstances {
    _private: (),
}
impl ListTrafficPolicyInstances {
    /// Creates a new builder-style object to manufacture [`ListTrafficPolicyInstancesInput`](crate::input::ListTrafficPolicyInstancesInput)
    pub fn builder() -> crate::input::list_traffic_policy_instances_input::Builder {
        crate::input::list_traffic_policy_instances_input::Builder::default()
    }
    /// Creates a new `ListTrafficPolicyInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTrafficPolicyInstances {
    type Output = std::result::Result<
        crate::output::ListTrafficPolicyInstancesOutput,
        crate::error::ListTrafficPolicyInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_traffic_policy_instances_error(response)
        } else {
            crate::operation_deser::parse_list_traffic_policy_instances_response(response)
        }
    }
}

/// Operation shape for `ListTrafficPolicyInstancesByHostedZone`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_traffic_policy_instances_by_hosted_zone`](crate::client::Client::list_traffic_policy_instances_by_hosted_zone).
///
/// See [`crate::client::fluent_builders::ListTrafficPolicyInstancesByHostedZone`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTrafficPolicyInstancesByHostedZone {
    _private: (),
}
impl ListTrafficPolicyInstancesByHostedZone {
    /// Creates a new builder-style object to manufacture [`ListTrafficPolicyInstancesByHostedZoneInput`](crate::input::ListTrafficPolicyInstancesByHostedZoneInput)
    pub fn builder() -> crate::input::list_traffic_policy_instances_by_hosted_zone_input::Builder {
        crate::input::list_traffic_policy_instances_by_hosted_zone_input::Builder::default()
    }
    /// Creates a new `ListTrafficPolicyInstancesByHostedZone` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTrafficPolicyInstancesByHostedZone {
    type Output = std::result::Result<
        crate::output::ListTrafficPolicyInstancesByHostedZoneOutput,
        crate::error::ListTrafficPolicyInstancesByHostedZoneError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_traffic_policy_instances_by_hosted_zone_error(
                response,
            )
        } else {
            crate::operation_deser::parse_list_traffic_policy_instances_by_hosted_zone_response(
                response,
            )
        }
    }
}

/// Operation shape for `ListTrafficPolicyInstancesByPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_traffic_policy_instances_by_policy`](crate::client::Client::list_traffic_policy_instances_by_policy).
///
/// See [`crate::client::fluent_builders::ListTrafficPolicyInstancesByPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTrafficPolicyInstancesByPolicy {
    _private: (),
}
impl ListTrafficPolicyInstancesByPolicy {
    /// Creates a new builder-style object to manufacture [`ListTrafficPolicyInstancesByPolicyInput`](crate::input::ListTrafficPolicyInstancesByPolicyInput)
    pub fn builder() -> crate::input::list_traffic_policy_instances_by_policy_input::Builder {
        crate::input::list_traffic_policy_instances_by_policy_input::Builder::default()
    }
    /// Creates a new `ListTrafficPolicyInstancesByPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTrafficPolicyInstancesByPolicy {
    type Output = std::result::Result<
        crate::output::ListTrafficPolicyInstancesByPolicyOutput,
        crate::error::ListTrafficPolicyInstancesByPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_traffic_policy_instances_by_policy_error(response)
        } else {
            crate::operation_deser::parse_list_traffic_policy_instances_by_policy_response(response)
        }
    }
}

/// Operation shape for `ListTrafficPolicyVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_traffic_policy_versions`](crate::client::Client::list_traffic_policy_versions).
///
/// See [`crate::client::fluent_builders::ListTrafficPolicyVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTrafficPolicyVersions {
    _private: (),
}
impl ListTrafficPolicyVersions {
    /// Creates a new builder-style object to manufacture [`ListTrafficPolicyVersionsInput`](crate::input::ListTrafficPolicyVersionsInput)
    pub fn builder() -> crate::input::list_traffic_policy_versions_input::Builder {
        crate::input::list_traffic_policy_versions_input::Builder::default()
    }
    /// Creates a new `ListTrafficPolicyVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTrafficPolicyVersions {
    type Output = std::result::Result<
        crate::output::ListTrafficPolicyVersionsOutput,
        crate::error::ListTrafficPolicyVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_traffic_policy_versions_error(response)
        } else {
            crate::operation_deser::parse_list_traffic_policy_versions_response(response)
        }
    }
}

/// Operation shape for `ListVPCAssociationAuthorizations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_vpc_association_authorizations`](crate::client::Client::list_vpc_association_authorizations).
///
/// See [`crate::client::fluent_builders::ListVPCAssociationAuthorizations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListVPCAssociationAuthorizations {
    _private: (),
}
impl ListVPCAssociationAuthorizations {
    /// Creates a new builder-style object to manufacture [`ListVpcAssociationAuthorizationsInput`](crate::input::ListVpcAssociationAuthorizationsInput)
    pub fn builder() -> crate::input::list_vpc_association_authorizations_input::Builder {
        crate::input::list_vpc_association_authorizations_input::Builder::default()
    }
    /// Creates a new `ListVPCAssociationAuthorizations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListVPCAssociationAuthorizations {
    type Output = std::result::Result<
        crate::output::ListVpcAssociationAuthorizationsOutput,
        crate::error::ListVPCAssociationAuthorizationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_vpc_association_authorizations_error(response)
        } else {
            crate::operation_deser::parse_list_vpc_association_authorizations_response(response)
        }
    }
}

/// Operation shape for `TestDNSAnswer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`test_dns_answer`](crate::client::Client::test_dns_answer).
///
/// See [`crate::client::fluent_builders::TestDNSAnswer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TestDNSAnswer {
    _private: (),
}
impl TestDNSAnswer {
    /// Creates a new builder-style object to manufacture [`TestDnsAnswerInput`](crate::input::TestDnsAnswerInput)
    pub fn builder() -> crate::input::test_dns_answer_input::Builder {
        crate::input::test_dns_answer_input::Builder::default()
    }
    /// Creates a new `TestDNSAnswer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TestDNSAnswer {
    type Output =
        std::result::Result<crate::output::TestDnsAnswerOutput, crate::error::TestDNSAnswerError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_test_dns_answer_error(response)
        } else {
            crate::operation_deser::parse_test_dns_answer_response(response)
        }
    }
}

/// Operation shape for `UpdateHealthCheck`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_health_check`](crate::client::Client::update_health_check).
///
/// See [`crate::client::fluent_builders::UpdateHealthCheck`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateHealthCheck {
    _private: (),
}
impl UpdateHealthCheck {
    /// Creates a new builder-style object to manufacture [`UpdateHealthCheckInput`](crate::input::UpdateHealthCheckInput)
    pub fn builder() -> crate::input::update_health_check_input::Builder {
        crate::input::update_health_check_input::Builder::default()
    }
    /// Creates a new `UpdateHealthCheck` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateHealthCheck {
    type Output = std::result::Result<
        crate::output::UpdateHealthCheckOutput,
        crate::error::UpdateHealthCheckError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_health_check_error(response)
        } else {
            crate::operation_deser::parse_update_health_check_response(response)
        }
    }
}

/// Operation shape for `UpdateHostedZoneComment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_hosted_zone_comment`](crate::client::Client::update_hosted_zone_comment).
///
/// See [`crate::client::fluent_builders::UpdateHostedZoneComment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateHostedZoneComment {
    _private: (),
}
impl UpdateHostedZoneComment {
    /// Creates a new builder-style object to manufacture [`UpdateHostedZoneCommentInput`](crate::input::UpdateHostedZoneCommentInput)
    pub fn builder() -> crate::input::update_hosted_zone_comment_input::Builder {
        crate::input::update_hosted_zone_comment_input::Builder::default()
    }
    /// Creates a new `UpdateHostedZoneComment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateHostedZoneComment {
    type Output = std::result::Result<
        crate::output::UpdateHostedZoneCommentOutput,
        crate::error::UpdateHostedZoneCommentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_hosted_zone_comment_error(response)
        } else {
            crate::operation_deser::parse_update_hosted_zone_comment_response(response)
        }
    }
}

/// Operation shape for `UpdateTrafficPolicyComment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_traffic_policy_comment`](crate::client::Client::update_traffic_policy_comment).
///
/// See [`crate::client::fluent_builders::UpdateTrafficPolicyComment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateTrafficPolicyComment {
    _private: (),
}
impl UpdateTrafficPolicyComment {
    /// Creates a new builder-style object to manufacture [`UpdateTrafficPolicyCommentInput`](crate::input::UpdateTrafficPolicyCommentInput)
    pub fn builder() -> crate::input::update_traffic_policy_comment_input::Builder {
        crate::input::update_traffic_policy_comment_input::Builder::default()
    }
    /// Creates a new `UpdateTrafficPolicyComment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateTrafficPolicyComment {
    type Output = std::result::Result<
        crate::output::UpdateTrafficPolicyCommentOutput,
        crate::error::UpdateTrafficPolicyCommentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_traffic_policy_comment_error(response)
        } else {
            crate::operation_deser::parse_update_traffic_policy_comment_response(response)
        }
    }
}

/// Operation shape for `UpdateTrafficPolicyInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_traffic_policy_instance`](crate::client::Client::update_traffic_policy_instance).
///
/// See [`crate::client::fluent_builders::UpdateTrafficPolicyInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateTrafficPolicyInstance {
    _private: (),
}
impl UpdateTrafficPolicyInstance {
    /// Creates a new builder-style object to manufacture [`UpdateTrafficPolicyInstanceInput`](crate::input::UpdateTrafficPolicyInstanceInput)
    pub fn builder() -> crate::input::update_traffic_policy_instance_input::Builder {
        crate::input::update_traffic_policy_instance_input::Builder::default()
    }
    /// Creates a new `UpdateTrafficPolicyInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateTrafficPolicyInstance {
    type Output = std::result::Result<
        crate::output::UpdateTrafficPolicyInstanceOutput,
        crate::error::UpdateTrafficPolicyInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_traffic_policy_instance_error(response)
        } else {
            crate::operation_deser::parse_update_traffic_policy_instance_response(response)
        }
    }
}
