// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `ActivateKeySigningKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ActivateKeySigningKeyError {
    /// Kind of error that occurred.
    pub kind: ActivateKeySigningKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ActivateKeySigningKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ActivateKeySigningKeyErrorKind {
    /// <p>Another user submitted a request to create, update, or delete the object at the same time that you did. Retry the request. </p>
    ConcurrentModification(crate::error::ConcurrentModification),
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The key-signing key (KSK) status isn't valid or another KSK has the status <code>INTERNAL_FAILURE</code>.</p>
    InvalidKeySigningKeyStatus(crate::error::InvalidKeySigningKeyStatus),
    /// <p>The KeyManagementServiceArn that you specified isn't valid to use with DNSSEC signing.</p>
    InvalidKmsArn(crate::error::InvalidKmsArn),
    /// <p>Your hosted zone status isn't valid for this operation. In the hosted zone, change the status to enable <code>DNSSEC</code>
    /// or disable <code>DNSSEC</code>.</p>
    InvalidSigningStatus(crate::error::InvalidSigningStatus),
    /// <p>The specified key-signing key (KSK) doesn't exist.</p>
    NoSuchKeySigningKey(crate::error::NoSuchKeySigningKey),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ActivateKeySigningKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ActivateKeySigningKeyErrorKind::ConcurrentModification(_inner) => _inner.fmt(f),
            ActivateKeySigningKeyErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            ActivateKeySigningKeyErrorKind::InvalidKeySigningKeyStatus(_inner) => _inner.fmt(f),
            ActivateKeySigningKeyErrorKind::InvalidKmsArn(_inner) => _inner.fmt(f),
            ActivateKeySigningKeyErrorKind::InvalidSigningStatus(_inner) => _inner.fmt(f),
            ActivateKeySigningKeyErrorKind::NoSuchKeySigningKey(_inner) => _inner.fmt(f),
            ActivateKeySigningKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ActivateKeySigningKeyError {
    fn code(&self) -> Option<&str> {
        ActivateKeySigningKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ActivateKeySigningKeyError {
    /// Creates a new `ActivateKeySigningKeyError`.
    pub fn new(kind: ActivateKeySigningKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ActivateKeySigningKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ActivateKeySigningKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ActivateKeySigningKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ActivateKeySigningKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ActivateKeySigningKeyErrorKind::ConcurrentModification`.
    pub fn is_concurrent_modification(&self) -> bool {
        matches!(
            &self.kind,
            ActivateKeySigningKeyErrorKind::ConcurrentModification(_)
        )
    }
    /// Returns `true` if the error kind is `ActivateKeySigningKeyErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, ActivateKeySigningKeyErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `ActivateKeySigningKeyErrorKind::InvalidKeySigningKeyStatus`.
    pub fn is_invalid_key_signing_key_status(&self) -> bool {
        matches!(
            &self.kind,
            ActivateKeySigningKeyErrorKind::InvalidKeySigningKeyStatus(_)
        )
    }
    /// Returns `true` if the error kind is `ActivateKeySigningKeyErrorKind::InvalidKmsArn`.
    pub fn is_invalid_kms_arn(&self) -> bool {
        matches!(&self.kind, ActivateKeySigningKeyErrorKind::InvalidKmsArn(_))
    }
    /// Returns `true` if the error kind is `ActivateKeySigningKeyErrorKind::InvalidSigningStatus`.
    pub fn is_invalid_signing_status(&self) -> bool {
        matches!(
            &self.kind,
            ActivateKeySigningKeyErrorKind::InvalidSigningStatus(_)
        )
    }
    /// Returns `true` if the error kind is `ActivateKeySigningKeyErrorKind::NoSuchKeySigningKey`.
    pub fn is_no_such_key_signing_key(&self) -> bool {
        matches!(
            &self.kind,
            ActivateKeySigningKeyErrorKind::NoSuchKeySigningKey(_)
        )
    }
}
impl std::error::Error for ActivateKeySigningKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ActivateKeySigningKeyErrorKind::ConcurrentModification(_inner) => Some(_inner),
            ActivateKeySigningKeyErrorKind::InvalidInput(_inner) => Some(_inner),
            ActivateKeySigningKeyErrorKind::InvalidKeySigningKeyStatus(_inner) => Some(_inner),
            ActivateKeySigningKeyErrorKind::InvalidKmsArn(_inner) => Some(_inner),
            ActivateKeySigningKeyErrorKind::InvalidSigningStatus(_inner) => Some(_inner),
            ActivateKeySigningKeyErrorKind::NoSuchKeySigningKey(_inner) => Some(_inner),
            ActivateKeySigningKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateVPCWithHostedZone` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateVPCWithHostedZoneError {
    /// Kind of error that occurred.
    pub kind: AssociateVPCWithHostedZoneErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateVPCWithHostedZone` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateVPCWithHostedZoneErrorKind {
    /// <p>The cause of this error depends on the operation that you're performing:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Create a public hosted zone:</b> Two hosted zones that have the same name or that have a
    /// parent/child relationship (example.com and test.example.com) can't have any common name servers. You tried to create a hosted zone
    /// that has the same name as an existing hosted zone or that's the parent or child of an existing hosted zone, and you specified a
    /// delegation set that shares one or more name servers with the existing hosted zone. For more information, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateReusableDelegationSet.html">CreateReusableDelegationSet</a>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Create a private hosted zone:</b> A hosted zone with the specified name
    /// already exists and is already associated with the Amazon VPC that you specified.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Associate VPCs with a private hosted zone:</b> The VPC that you specified is
    /// already associated with another hosted zone that has the same name.</p>
    /// </li>
    /// </ul>
    ConflictingDomainExists(crate::error::ConflictingDomainExists),
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The VPC ID that you specified either isn't a valid ID or the current account is not authorized to access this VPC.</p>
    InvalidVpcId(crate::error::InvalidVpcId),
    /// <p>This operation can't be completed either because the current account has reached the limit on reusable delegation sets
    /// that it can create or because you've reached the limit on the number of Amazon VPCs that you can associate with a private hosted zone.
    /// To get the current limit on the number of reusable delegation sets, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetAccountLimit.html">GetAccountLimit</a>.
    /// To get the current limit on the number of Amazon VPCs that you can associate with a private hosted zone, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetHostedZoneLimit.html">GetHostedZoneLimit</a>.
    /// To request a higher limit, <a href="http://aws.amazon.com/route53-request">create a case</a> with the Amazon Web Services Support Center.</p>
    LimitsExceeded(crate::error::LimitsExceeded),
    /// <p>No hosted zone exists with the ID that you specified.</p>
    NoSuchHostedZone(crate::error::NoSuchHostedZone),
    /// <p>Associating the specified VPC with the specified hosted zone has not been authorized.</p>
    NotAuthorizedException(crate::error::NotAuthorizedException),
    /// <p>If Amazon Route 53 can't process a request before the next request arrives, it will reject
    /// subsequent requests for the same hosted zone and return an <code>HTTP 400 error</code>
    /// (<code>Bad request</code>). If Route 53 returns this error repeatedly for the same request, we
    /// recommend that you wait, in intervals of increasing duration, before you try the request
    /// again.</p>
    PriorRequestNotComplete(crate::error::PriorRequestNotComplete),
    /// <p>You're trying to associate a VPC with a public hosted zone. Amazon Route 53 doesn't support associating a
    /// VPC with a public hosted zone.</p>
    PublicZoneVpcAssociation(crate::error::PublicZoneVpcAssociation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateVPCWithHostedZoneError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateVPCWithHostedZoneErrorKind::ConflictingDomainExists(_inner) => _inner.fmt(f),
            AssociateVPCWithHostedZoneErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            AssociateVPCWithHostedZoneErrorKind::InvalidVpcId(_inner) => _inner.fmt(f),
            AssociateVPCWithHostedZoneErrorKind::LimitsExceeded(_inner) => _inner.fmt(f),
            AssociateVPCWithHostedZoneErrorKind::NoSuchHostedZone(_inner) => _inner.fmt(f),
            AssociateVPCWithHostedZoneErrorKind::NotAuthorizedException(_inner) => _inner.fmt(f),
            AssociateVPCWithHostedZoneErrorKind::PriorRequestNotComplete(_inner) => _inner.fmt(f),
            AssociateVPCWithHostedZoneErrorKind::PublicZoneVpcAssociation(_inner) => _inner.fmt(f),
            AssociateVPCWithHostedZoneErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateVPCWithHostedZoneError {
    fn code(&self) -> Option<&str> {
        AssociateVPCWithHostedZoneError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateVPCWithHostedZoneError {
    /// Creates a new `AssociateVPCWithHostedZoneError`.
    pub fn new(kind: AssociateVPCWithHostedZoneErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateVPCWithHostedZoneError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateVPCWithHostedZoneErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateVPCWithHostedZoneError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateVPCWithHostedZoneErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateVPCWithHostedZoneErrorKind::ConflictingDomainExists`.
    pub fn is_conflicting_domain_exists(&self) -> bool {
        matches!(
            &self.kind,
            AssociateVPCWithHostedZoneErrorKind::ConflictingDomainExists(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateVPCWithHostedZoneErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            AssociateVPCWithHostedZoneErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateVPCWithHostedZoneErrorKind::InvalidVpcId`.
    pub fn is_invalid_vpc_id(&self) -> bool {
        matches!(
            &self.kind,
            AssociateVPCWithHostedZoneErrorKind::InvalidVpcId(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateVPCWithHostedZoneErrorKind::LimitsExceeded`.
    pub fn is_limits_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            AssociateVPCWithHostedZoneErrorKind::LimitsExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateVPCWithHostedZoneErrorKind::NoSuchHostedZone`.
    pub fn is_no_such_hosted_zone(&self) -> bool {
        matches!(
            &self.kind,
            AssociateVPCWithHostedZoneErrorKind::NoSuchHostedZone(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateVPCWithHostedZoneErrorKind::NotAuthorizedException`.
    pub fn is_not_authorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateVPCWithHostedZoneErrorKind::NotAuthorizedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateVPCWithHostedZoneErrorKind::PriorRequestNotComplete`.
    pub fn is_prior_request_not_complete(&self) -> bool {
        matches!(
            &self.kind,
            AssociateVPCWithHostedZoneErrorKind::PriorRequestNotComplete(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateVPCWithHostedZoneErrorKind::PublicZoneVpcAssociation`.
    pub fn is_public_zone_vpc_association(&self) -> bool {
        matches!(
            &self.kind,
            AssociateVPCWithHostedZoneErrorKind::PublicZoneVpcAssociation(_)
        )
    }
}
impl std::error::Error for AssociateVPCWithHostedZoneError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateVPCWithHostedZoneErrorKind::ConflictingDomainExists(_inner) => Some(_inner),
            AssociateVPCWithHostedZoneErrorKind::InvalidInput(_inner) => Some(_inner),
            AssociateVPCWithHostedZoneErrorKind::InvalidVpcId(_inner) => Some(_inner),
            AssociateVPCWithHostedZoneErrorKind::LimitsExceeded(_inner) => Some(_inner),
            AssociateVPCWithHostedZoneErrorKind::NoSuchHostedZone(_inner) => Some(_inner),
            AssociateVPCWithHostedZoneErrorKind::NotAuthorizedException(_inner) => Some(_inner),
            AssociateVPCWithHostedZoneErrorKind::PriorRequestNotComplete(_inner) => Some(_inner),
            AssociateVPCWithHostedZoneErrorKind::PublicZoneVpcAssociation(_inner) => Some(_inner),
            AssociateVPCWithHostedZoneErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ChangeResourceRecordSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ChangeResourceRecordSetsError {
    /// Kind of error that occurred.
    pub kind: ChangeResourceRecordSetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ChangeResourceRecordSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ChangeResourceRecordSetsErrorKind {
    /// <p>This exception contains a list of messages that might contain one or more error messages. Each error message indicates
    /// one error in the change batch.</p>
    InvalidChangeBatch(crate::error::InvalidChangeBatch),
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>No health check exists with the specified ID.</p>
    NoSuchHealthCheck(crate::error::NoSuchHealthCheck),
    /// <p>No hosted zone exists with the ID that you specified.</p>
    NoSuchHostedZone(crate::error::NoSuchHostedZone),
    /// <p>If Amazon Route 53 can't process a request before the next request arrives, it will reject
    /// subsequent requests for the same hosted zone and return an <code>HTTP 400 error</code>
    /// (<code>Bad request</code>). If Route 53 returns this error repeatedly for the same request, we
    /// recommend that you wait, in intervals of increasing duration, before you try the request
    /// again.</p>
    PriorRequestNotComplete(crate::error::PriorRequestNotComplete),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ChangeResourceRecordSetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ChangeResourceRecordSetsErrorKind::InvalidChangeBatch(_inner) => _inner.fmt(f),
            ChangeResourceRecordSetsErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            ChangeResourceRecordSetsErrorKind::NoSuchHealthCheck(_inner) => _inner.fmt(f),
            ChangeResourceRecordSetsErrorKind::NoSuchHostedZone(_inner) => _inner.fmt(f),
            ChangeResourceRecordSetsErrorKind::PriorRequestNotComplete(_inner) => _inner.fmt(f),
            ChangeResourceRecordSetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ChangeResourceRecordSetsError {
    fn code(&self) -> Option<&str> {
        ChangeResourceRecordSetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ChangeResourceRecordSetsError {
    /// Creates a new `ChangeResourceRecordSetsError`.
    pub fn new(kind: ChangeResourceRecordSetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ChangeResourceRecordSetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ChangeResourceRecordSetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ChangeResourceRecordSetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ChangeResourceRecordSetsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ChangeResourceRecordSetsErrorKind::InvalidChangeBatch`.
    pub fn is_invalid_change_batch(&self) -> bool {
        matches!(
            &self.kind,
            ChangeResourceRecordSetsErrorKind::InvalidChangeBatch(_)
        )
    }
    /// Returns `true` if the error kind is `ChangeResourceRecordSetsErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            ChangeResourceRecordSetsErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `ChangeResourceRecordSetsErrorKind::NoSuchHealthCheck`.
    pub fn is_no_such_health_check(&self) -> bool {
        matches!(
            &self.kind,
            ChangeResourceRecordSetsErrorKind::NoSuchHealthCheck(_)
        )
    }
    /// Returns `true` if the error kind is `ChangeResourceRecordSetsErrorKind::NoSuchHostedZone`.
    pub fn is_no_such_hosted_zone(&self) -> bool {
        matches!(
            &self.kind,
            ChangeResourceRecordSetsErrorKind::NoSuchHostedZone(_)
        )
    }
    /// Returns `true` if the error kind is `ChangeResourceRecordSetsErrorKind::PriorRequestNotComplete`.
    pub fn is_prior_request_not_complete(&self) -> bool {
        matches!(
            &self.kind,
            ChangeResourceRecordSetsErrorKind::PriorRequestNotComplete(_)
        )
    }
}
impl std::error::Error for ChangeResourceRecordSetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ChangeResourceRecordSetsErrorKind::InvalidChangeBatch(_inner) => Some(_inner),
            ChangeResourceRecordSetsErrorKind::InvalidInput(_inner) => Some(_inner),
            ChangeResourceRecordSetsErrorKind::NoSuchHealthCheck(_inner) => Some(_inner),
            ChangeResourceRecordSetsErrorKind::NoSuchHostedZone(_inner) => Some(_inner),
            ChangeResourceRecordSetsErrorKind::PriorRequestNotComplete(_inner) => Some(_inner),
            ChangeResourceRecordSetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ChangeTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ChangeTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ChangeTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ChangeTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ChangeTagsForResourceErrorKind {
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>No health check exists with the specified ID.</p>
    NoSuchHealthCheck(crate::error::NoSuchHealthCheck),
    /// <p>No hosted zone exists with the ID that you specified.</p>
    NoSuchHostedZone(crate::error::NoSuchHostedZone),
    /// <p>If Amazon Route 53 can't process a request before the next request arrives, it will reject
    /// subsequent requests for the same hosted zone and return an <code>HTTP 400 error</code>
    /// (<code>Bad request</code>). If Route 53 returns this error repeatedly for the same request, we
    /// recommend that you wait, in intervals of increasing duration, before you try the request
    /// again.</p>
    PriorRequestNotComplete(crate::error::PriorRequestNotComplete),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ChangeTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ChangeTagsForResourceErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            ChangeTagsForResourceErrorKind::NoSuchHealthCheck(_inner) => _inner.fmt(f),
            ChangeTagsForResourceErrorKind::NoSuchHostedZone(_inner) => _inner.fmt(f),
            ChangeTagsForResourceErrorKind::PriorRequestNotComplete(_inner) => _inner.fmt(f),
            ChangeTagsForResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ChangeTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ChangeTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ChangeTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ChangeTagsForResourceError {
    /// Creates a new `ChangeTagsForResourceError`.
    pub fn new(kind: ChangeTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ChangeTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ChangeTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ChangeTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ChangeTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ChangeTagsForResourceErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, ChangeTagsForResourceErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `ChangeTagsForResourceErrorKind::NoSuchHealthCheck`.
    pub fn is_no_such_health_check(&self) -> bool {
        matches!(
            &self.kind,
            ChangeTagsForResourceErrorKind::NoSuchHealthCheck(_)
        )
    }
    /// Returns `true` if the error kind is `ChangeTagsForResourceErrorKind::NoSuchHostedZone`.
    pub fn is_no_such_hosted_zone(&self) -> bool {
        matches!(
            &self.kind,
            ChangeTagsForResourceErrorKind::NoSuchHostedZone(_)
        )
    }
    /// Returns `true` if the error kind is `ChangeTagsForResourceErrorKind::PriorRequestNotComplete`.
    pub fn is_prior_request_not_complete(&self) -> bool {
        matches!(
            &self.kind,
            ChangeTagsForResourceErrorKind::PriorRequestNotComplete(_)
        )
    }
    /// Returns `true` if the error kind is `ChangeTagsForResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ChangeTagsForResourceErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ChangeTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ChangeTagsForResourceErrorKind::InvalidInput(_inner) => Some(_inner),
            ChangeTagsForResourceErrorKind::NoSuchHealthCheck(_inner) => Some(_inner),
            ChangeTagsForResourceErrorKind::NoSuchHostedZone(_inner) => Some(_inner),
            ChangeTagsForResourceErrorKind::PriorRequestNotComplete(_inner) => Some(_inner),
            ChangeTagsForResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            ChangeTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateHealthCheck` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateHealthCheckError {
    /// Kind of error that occurred.
    pub kind: CreateHealthCheckErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateHealthCheck` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateHealthCheckErrorKind {
    /// <p> The health check you're attempting to create already exists. Amazon Route 53 returns this error when you submit a request that
    /// has the following values:</p>
    /// <ul>
    /// <li>
    /// <p>The same value for <code>CallerReference</code> as an existing health check, and one or more values that differ
    /// from the existing health check that has the same caller reference.</p>
    /// </li>
    /// <li>
    /// <p>The same value for <code>CallerReference</code> as a health check that you created and later deleted,
    /// regardless of the other settings in the request.</p>
    /// </li>
    /// </ul>
    HealthCheckAlreadyExists(crate::error::HealthCheckAlreadyExists),
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>This health check can't be created because the current account has reached the limit on the number of active health checks.</p>
    /// <p>For information about default limits, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a>
    /// in the <i>Amazon Route 53 Developer Guide</i>.</p>
    /// <p>For information about how to get the current limit for an account, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetAccountLimit.html">GetAccountLimit</a>. To request a
    /// higher limit, <a href="http://aws.amazon.com/route53-request">create a case</a> with the Amazon Web Services Support Center.</p>
    ///
    /// <p>You have reached the maximum number of active health checks for an Amazon Web Services account. To request a higher limit,
    /// <a href="http://aws.amazon.com/route53-request">create a case</a> with the Amazon Web Services Support Center.</p>
    TooManyHealthChecks(crate::error::TooManyHealthChecks),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateHealthCheckError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateHealthCheckErrorKind::HealthCheckAlreadyExists(_inner) => _inner.fmt(f),
            CreateHealthCheckErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            CreateHealthCheckErrorKind::TooManyHealthChecks(_inner) => _inner.fmt(f),
            CreateHealthCheckErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateHealthCheckError {
    fn code(&self) -> Option<&str> {
        CreateHealthCheckError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateHealthCheckError {
    /// Creates a new `CreateHealthCheckError`.
    pub fn new(kind: CreateHealthCheckErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateHealthCheckError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateHealthCheckErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateHealthCheckError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateHealthCheckErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateHealthCheckErrorKind::HealthCheckAlreadyExists`.
    pub fn is_health_check_already_exists(&self) -> bool {
        matches!(
            &self.kind,
            CreateHealthCheckErrorKind::HealthCheckAlreadyExists(_)
        )
    }
    /// Returns `true` if the error kind is `CreateHealthCheckErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, CreateHealthCheckErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `CreateHealthCheckErrorKind::TooManyHealthChecks`.
    pub fn is_too_many_health_checks(&self) -> bool {
        matches!(
            &self.kind,
            CreateHealthCheckErrorKind::TooManyHealthChecks(_)
        )
    }
}
impl std::error::Error for CreateHealthCheckError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateHealthCheckErrorKind::HealthCheckAlreadyExists(_inner) => Some(_inner),
            CreateHealthCheckErrorKind::InvalidInput(_inner) => Some(_inner),
            CreateHealthCheckErrorKind::TooManyHealthChecks(_inner) => Some(_inner),
            CreateHealthCheckErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateHostedZone` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateHostedZoneError {
    /// Kind of error that occurred.
    pub kind: CreateHostedZoneErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateHostedZone` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateHostedZoneErrorKind {
    /// <p>The cause of this error depends on the operation that you're performing:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Create a public hosted zone:</b> Two hosted zones that have the same name or that have a
    /// parent/child relationship (example.com and test.example.com) can't have any common name servers. You tried to create a hosted zone
    /// that has the same name as an existing hosted zone or that's the parent or child of an existing hosted zone, and you specified a
    /// delegation set that shares one or more name servers with the existing hosted zone. For more information, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateReusableDelegationSet.html">CreateReusableDelegationSet</a>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Create a private hosted zone:</b> A hosted zone with the specified name
    /// already exists and is already associated with the Amazon VPC that you specified.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Associate VPCs with a private hosted zone:</b> The VPC that you specified is
    /// already associated with another hosted zone that has the same name.</p>
    /// </li>
    /// </ul>
    ConflictingDomainExists(crate::error::ConflictingDomainExists),
    /// <p>You can create a hosted zone that has the same name as an existing hosted zone (example.com is common), but there is a
    /// limit to the number of hosted zones that have the same name. If you get this error, Amazon Route 53 has reached that limit. If you own
    /// the domain name and Route 53 generates this error, contact Customer Support.</p>
    DelegationSetNotAvailable(crate::error::DelegationSetNotAvailable),
    /// <p>A reusable delegation set with the specified ID does not exist.</p>
    DelegationSetNotReusable(crate::error::DelegationSetNotReusable),
    /// <p>The hosted zone you're trying to create already exists. Amazon Route 53 returns this error when a hosted zone has already been created
    /// with the specified <code>CallerReference</code>.</p>
    HostedZoneAlreadyExists(crate::error::HostedZoneAlreadyExists),
    /// <p>The specified domain name is not valid.</p>
    InvalidDomainName(crate::error::InvalidDomainName),
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The VPC ID that you specified either isn't a valid ID or the current account is not authorized to access this VPC.</p>
    InvalidVpcId(crate::error::InvalidVpcId),
    /// <p>A reusable delegation set with the specified ID does not exist.</p>
    NoSuchDelegationSet(crate::error::NoSuchDelegationSet),
    /// <p>This operation can't be completed either because the current account has reached the limit on the number of hosted zones
    /// or because you've reached the limit on the number of hosted zones that can be associated with a reusable delegation set.</p>
    /// <p>For information about default limits, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a>
    /// in the <i>Amazon Route 53 Developer Guide</i>.</p>
    /// <p>To get the current limit on hosted zones that can be created by an account, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetAccountLimit.html">GetAccountLimit</a>.</p>
    /// <p>To get the current limit on hosted zones that can be associated with a reusable delegation set, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetReusableDelegationSetLimit.html">GetReusableDelegationSetLimit</a>.</p>
    /// <p>To request a higher limit, <a href="http://aws.amazon.com/route53-request">create a case</a> with the Amazon Web Services Support Center.</p>
    TooManyHostedZones(crate::error::TooManyHostedZones),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateHostedZoneError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateHostedZoneErrorKind::ConflictingDomainExists(_inner) => _inner.fmt(f),
            CreateHostedZoneErrorKind::DelegationSetNotAvailable(_inner) => _inner.fmt(f),
            CreateHostedZoneErrorKind::DelegationSetNotReusable(_inner) => _inner.fmt(f),
            CreateHostedZoneErrorKind::HostedZoneAlreadyExists(_inner) => _inner.fmt(f),
            CreateHostedZoneErrorKind::InvalidDomainName(_inner) => _inner.fmt(f),
            CreateHostedZoneErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            CreateHostedZoneErrorKind::InvalidVpcId(_inner) => _inner.fmt(f),
            CreateHostedZoneErrorKind::NoSuchDelegationSet(_inner) => _inner.fmt(f),
            CreateHostedZoneErrorKind::TooManyHostedZones(_inner) => _inner.fmt(f),
            CreateHostedZoneErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateHostedZoneError {
    fn code(&self) -> Option<&str> {
        CreateHostedZoneError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateHostedZoneError {
    /// Creates a new `CreateHostedZoneError`.
    pub fn new(kind: CreateHostedZoneErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateHostedZoneError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateHostedZoneErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateHostedZoneError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateHostedZoneErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateHostedZoneErrorKind::ConflictingDomainExists`.
    pub fn is_conflicting_domain_exists(&self) -> bool {
        matches!(
            &self.kind,
            CreateHostedZoneErrorKind::ConflictingDomainExists(_)
        )
    }
    /// Returns `true` if the error kind is `CreateHostedZoneErrorKind::DelegationSetNotAvailable`.
    pub fn is_delegation_set_not_available(&self) -> bool {
        matches!(
            &self.kind,
            CreateHostedZoneErrorKind::DelegationSetNotAvailable(_)
        )
    }
    /// Returns `true` if the error kind is `CreateHostedZoneErrorKind::DelegationSetNotReusable`.
    pub fn is_delegation_set_not_reusable(&self) -> bool {
        matches!(
            &self.kind,
            CreateHostedZoneErrorKind::DelegationSetNotReusable(_)
        )
    }
    /// Returns `true` if the error kind is `CreateHostedZoneErrorKind::HostedZoneAlreadyExists`.
    pub fn is_hosted_zone_already_exists(&self) -> bool {
        matches!(
            &self.kind,
            CreateHostedZoneErrorKind::HostedZoneAlreadyExists(_)
        )
    }
    /// Returns `true` if the error kind is `CreateHostedZoneErrorKind::InvalidDomainName`.
    pub fn is_invalid_domain_name(&self) -> bool {
        matches!(&self.kind, CreateHostedZoneErrorKind::InvalidDomainName(_))
    }
    /// Returns `true` if the error kind is `CreateHostedZoneErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, CreateHostedZoneErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `CreateHostedZoneErrorKind::InvalidVpcId`.
    pub fn is_invalid_vpc_id(&self) -> bool {
        matches!(&self.kind, CreateHostedZoneErrorKind::InvalidVpcId(_))
    }
    /// Returns `true` if the error kind is `CreateHostedZoneErrorKind::NoSuchDelegationSet`.
    pub fn is_no_such_delegation_set(&self) -> bool {
        matches!(
            &self.kind,
            CreateHostedZoneErrorKind::NoSuchDelegationSet(_)
        )
    }
    /// Returns `true` if the error kind is `CreateHostedZoneErrorKind::TooManyHostedZones`.
    pub fn is_too_many_hosted_zones(&self) -> bool {
        matches!(&self.kind, CreateHostedZoneErrorKind::TooManyHostedZones(_))
    }
}
impl std::error::Error for CreateHostedZoneError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateHostedZoneErrorKind::ConflictingDomainExists(_inner) => Some(_inner),
            CreateHostedZoneErrorKind::DelegationSetNotAvailable(_inner) => Some(_inner),
            CreateHostedZoneErrorKind::DelegationSetNotReusable(_inner) => Some(_inner),
            CreateHostedZoneErrorKind::HostedZoneAlreadyExists(_inner) => Some(_inner),
            CreateHostedZoneErrorKind::InvalidDomainName(_inner) => Some(_inner),
            CreateHostedZoneErrorKind::InvalidInput(_inner) => Some(_inner),
            CreateHostedZoneErrorKind::InvalidVpcId(_inner) => Some(_inner),
            CreateHostedZoneErrorKind::NoSuchDelegationSet(_inner) => Some(_inner),
            CreateHostedZoneErrorKind::TooManyHostedZones(_inner) => Some(_inner),
            CreateHostedZoneErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateKeySigningKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateKeySigningKeyError {
    /// Kind of error that occurred.
    pub kind: CreateKeySigningKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateKeySigningKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateKeySigningKeyErrorKind {
    /// <p>Another user submitted a request to create, update, or delete the object at the same time that you did. Retry the request. </p>
    ConcurrentModification(crate::error::ConcurrentModification),
    /// <p>Parameter name is not valid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The key-signing key (KSK) name that you specified isn't a valid name.</p>
    InvalidKeySigningKeyName(crate::error::InvalidKeySigningKeyName),
    /// <p>The key-signing key (KSK) status isn't valid or another KSK has the status <code>INTERNAL_FAILURE</code>.</p>
    InvalidKeySigningKeyStatus(crate::error::InvalidKeySigningKeyStatus),
    /// <p>The KeyManagementServiceArn that you specified isn't valid to use with DNSSEC signing.</p>
    InvalidKmsArn(crate::error::InvalidKmsArn),
    /// <p>Your hosted zone status isn't valid for this operation. In the hosted zone, change the status to enable <code>DNSSEC</code>
    /// or disable <code>DNSSEC</code>.</p>
    InvalidSigningStatus(crate::error::InvalidSigningStatus),
    /// <p>You've already created a key-signing key (KSK) with this name or with the same customer managed customer master key (CMK) ARN.</p>
    KeySigningKeyAlreadyExists(crate::error::KeySigningKeyAlreadyExists),
    /// <p>No hosted zone exists with the ID that you specified.</p>
    NoSuchHostedZone(crate::error::NoSuchHostedZone),
    /// <p>You've reached the limit for the number of key-signing keys (KSKs). Remove at least one KSK, and then try again.</p>
    TooManyKeySigningKeys(crate::error::TooManyKeySigningKeys),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateKeySigningKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateKeySigningKeyErrorKind::ConcurrentModification(_inner) => _inner.fmt(f),
            CreateKeySigningKeyErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            CreateKeySigningKeyErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            CreateKeySigningKeyErrorKind::InvalidKeySigningKeyName(_inner) => _inner.fmt(f),
            CreateKeySigningKeyErrorKind::InvalidKeySigningKeyStatus(_inner) => _inner.fmt(f),
            CreateKeySigningKeyErrorKind::InvalidKmsArn(_inner) => _inner.fmt(f),
            CreateKeySigningKeyErrorKind::InvalidSigningStatus(_inner) => _inner.fmt(f),
            CreateKeySigningKeyErrorKind::KeySigningKeyAlreadyExists(_inner) => _inner.fmt(f),
            CreateKeySigningKeyErrorKind::NoSuchHostedZone(_inner) => _inner.fmt(f),
            CreateKeySigningKeyErrorKind::TooManyKeySigningKeys(_inner) => _inner.fmt(f),
            CreateKeySigningKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateKeySigningKeyError {
    fn code(&self) -> Option<&str> {
        CreateKeySigningKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateKeySigningKeyError {
    /// Creates a new `CreateKeySigningKeyError`.
    pub fn new(kind: CreateKeySigningKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateKeySigningKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateKeySigningKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateKeySigningKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateKeySigningKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateKeySigningKeyErrorKind::ConcurrentModification`.
    pub fn is_concurrent_modification(&self) -> bool {
        matches!(
            &self.kind,
            CreateKeySigningKeyErrorKind::ConcurrentModification(_)
        )
    }
    /// Returns `true` if the error kind is `CreateKeySigningKeyErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(&self.kind, CreateKeySigningKeyErrorKind::InvalidArgument(_))
    }
    /// Returns `true` if the error kind is `CreateKeySigningKeyErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, CreateKeySigningKeyErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `CreateKeySigningKeyErrorKind::InvalidKeySigningKeyName`.
    pub fn is_invalid_key_signing_key_name(&self) -> bool {
        matches!(
            &self.kind,
            CreateKeySigningKeyErrorKind::InvalidKeySigningKeyName(_)
        )
    }
    /// Returns `true` if the error kind is `CreateKeySigningKeyErrorKind::InvalidKeySigningKeyStatus`.
    pub fn is_invalid_key_signing_key_status(&self) -> bool {
        matches!(
            &self.kind,
            CreateKeySigningKeyErrorKind::InvalidKeySigningKeyStatus(_)
        )
    }
    /// Returns `true` if the error kind is `CreateKeySigningKeyErrorKind::InvalidKmsArn`.
    pub fn is_invalid_kms_arn(&self) -> bool {
        matches!(&self.kind, CreateKeySigningKeyErrorKind::InvalidKmsArn(_))
    }
    /// Returns `true` if the error kind is `CreateKeySigningKeyErrorKind::InvalidSigningStatus`.
    pub fn is_invalid_signing_status(&self) -> bool {
        matches!(
            &self.kind,
            CreateKeySigningKeyErrorKind::InvalidSigningStatus(_)
        )
    }
    /// Returns `true` if the error kind is `CreateKeySigningKeyErrorKind::KeySigningKeyAlreadyExists`.
    pub fn is_key_signing_key_already_exists(&self) -> bool {
        matches!(
            &self.kind,
            CreateKeySigningKeyErrorKind::KeySigningKeyAlreadyExists(_)
        )
    }
    /// Returns `true` if the error kind is `CreateKeySigningKeyErrorKind::NoSuchHostedZone`.
    pub fn is_no_such_hosted_zone(&self) -> bool {
        matches!(
            &self.kind,
            CreateKeySigningKeyErrorKind::NoSuchHostedZone(_)
        )
    }
    /// Returns `true` if the error kind is `CreateKeySigningKeyErrorKind::TooManyKeySigningKeys`.
    pub fn is_too_many_key_signing_keys(&self) -> bool {
        matches!(
            &self.kind,
            CreateKeySigningKeyErrorKind::TooManyKeySigningKeys(_)
        )
    }
}
impl std::error::Error for CreateKeySigningKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateKeySigningKeyErrorKind::ConcurrentModification(_inner) => Some(_inner),
            CreateKeySigningKeyErrorKind::InvalidArgument(_inner) => Some(_inner),
            CreateKeySigningKeyErrorKind::InvalidInput(_inner) => Some(_inner),
            CreateKeySigningKeyErrorKind::InvalidKeySigningKeyName(_inner) => Some(_inner),
            CreateKeySigningKeyErrorKind::InvalidKeySigningKeyStatus(_inner) => Some(_inner),
            CreateKeySigningKeyErrorKind::InvalidKmsArn(_inner) => Some(_inner),
            CreateKeySigningKeyErrorKind::InvalidSigningStatus(_inner) => Some(_inner),
            CreateKeySigningKeyErrorKind::KeySigningKeyAlreadyExists(_inner) => Some(_inner),
            CreateKeySigningKeyErrorKind::NoSuchHostedZone(_inner) => Some(_inner),
            CreateKeySigningKeyErrorKind::TooManyKeySigningKeys(_inner) => Some(_inner),
            CreateKeySigningKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateQueryLoggingConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateQueryLoggingConfigError {
    /// Kind of error that occurred.
    pub kind: CreateQueryLoggingConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateQueryLoggingConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateQueryLoggingConfigErrorKind {
    /// <p>Another user submitted a request to create, update, or delete the object at the same time that you did. Retry the request. </p>
    ConcurrentModification(crate::error::ConcurrentModification),
    /// <p>Amazon Route 53 doesn't have the permissions required to create log streams and send query logs to log streams. Possible causes
    /// include the following:</p>
    /// <ul>
    /// <li>
    /// <p>There is no resource policy that specifies the log group ARN in the value for <code>Resource</code>.</p>
    /// </li>
    /// <li>
    /// <p>The resource policy that includes the log group ARN in the value for <code>Resource</code> doesn't have the
    /// necessary permissions.</p>
    /// </li>
    /// <li>
    /// <p>The resource policy hasn't finished propagating yet.</p>
    /// </li>
    /// <li>
    /// <p>The Key management service (KMS) key you specified doesn’t exist or it can’t be used with the
    /// log group associated with query log. Update or provide a resource policy to grant permissions for the KMS key.</p>
    /// </li>
    /// </ul>
    InsufficientCloudWatchLogsResourcePolicy(
        crate::error::InsufficientCloudWatchLogsResourcePolicy,
    ),
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>There is no CloudWatch Logs log group with the specified ARN.</p>
    NoSuchCloudWatchLogsLogGroup(crate::error::NoSuchCloudWatchLogsLogGroup),
    /// <p>No hosted zone exists with the ID that you specified.</p>
    NoSuchHostedZone(crate::error::NoSuchHostedZone),
    /// <p>You can create only one query logging configuration for a hosted zone, and a query logging configuration already exists
    /// for this hosted zone.</p>
    QueryLoggingConfigAlreadyExists(crate::error::QueryLoggingConfigAlreadyExists),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateQueryLoggingConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateQueryLoggingConfigErrorKind::ConcurrentModification(_inner) => _inner.fmt(f),
            CreateQueryLoggingConfigErrorKind::InsufficientCloudWatchLogsResourcePolicy(_inner) => {
                _inner.fmt(f)
            }
            CreateQueryLoggingConfigErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            CreateQueryLoggingConfigErrorKind::NoSuchCloudWatchLogsLogGroup(_inner) => {
                _inner.fmt(f)
            }
            CreateQueryLoggingConfigErrorKind::NoSuchHostedZone(_inner) => _inner.fmt(f),
            CreateQueryLoggingConfigErrorKind::QueryLoggingConfigAlreadyExists(_inner) => {
                _inner.fmt(f)
            }
            CreateQueryLoggingConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateQueryLoggingConfigError {
    fn code(&self) -> Option<&str> {
        CreateQueryLoggingConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateQueryLoggingConfigError {
    /// Creates a new `CreateQueryLoggingConfigError`.
    pub fn new(kind: CreateQueryLoggingConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateQueryLoggingConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateQueryLoggingConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateQueryLoggingConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateQueryLoggingConfigErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateQueryLoggingConfigErrorKind::ConcurrentModification`.
    pub fn is_concurrent_modification(&self) -> bool {
        matches!(
            &self.kind,
            CreateQueryLoggingConfigErrorKind::ConcurrentModification(_)
        )
    }
    /// Returns `true` if the error kind is `CreateQueryLoggingConfigErrorKind::InsufficientCloudWatchLogsResourcePolicy`.
    pub fn is_insufficient_cloud_watch_logs_resource_policy(&self) -> bool {
        matches!(
            &self.kind,
            CreateQueryLoggingConfigErrorKind::InsufficientCloudWatchLogsResourcePolicy(_)
        )
    }
    /// Returns `true` if the error kind is `CreateQueryLoggingConfigErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            CreateQueryLoggingConfigErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `CreateQueryLoggingConfigErrorKind::NoSuchCloudWatchLogsLogGroup`.
    pub fn is_no_such_cloud_watch_logs_log_group(&self) -> bool {
        matches!(
            &self.kind,
            CreateQueryLoggingConfigErrorKind::NoSuchCloudWatchLogsLogGroup(_)
        )
    }
    /// Returns `true` if the error kind is `CreateQueryLoggingConfigErrorKind::NoSuchHostedZone`.
    pub fn is_no_such_hosted_zone(&self) -> bool {
        matches!(
            &self.kind,
            CreateQueryLoggingConfigErrorKind::NoSuchHostedZone(_)
        )
    }
    /// Returns `true` if the error kind is `CreateQueryLoggingConfigErrorKind::QueryLoggingConfigAlreadyExists`.
    pub fn is_query_logging_config_already_exists(&self) -> bool {
        matches!(
            &self.kind,
            CreateQueryLoggingConfigErrorKind::QueryLoggingConfigAlreadyExists(_)
        )
    }
}
impl std::error::Error for CreateQueryLoggingConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateQueryLoggingConfigErrorKind::ConcurrentModification(_inner) => Some(_inner),
            CreateQueryLoggingConfigErrorKind::InsufficientCloudWatchLogsResourcePolicy(_inner) => {
                Some(_inner)
            }
            CreateQueryLoggingConfigErrorKind::InvalidInput(_inner) => Some(_inner),
            CreateQueryLoggingConfigErrorKind::NoSuchCloudWatchLogsLogGroup(_inner) => Some(_inner),
            CreateQueryLoggingConfigErrorKind::NoSuchHostedZone(_inner) => Some(_inner),
            CreateQueryLoggingConfigErrorKind::QueryLoggingConfigAlreadyExists(_inner) => {
                Some(_inner)
            }
            CreateQueryLoggingConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateReusableDelegationSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateReusableDelegationSetError {
    /// Kind of error that occurred.
    pub kind: CreateReusableDelegationSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateReusableDelegationSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateReusableDelegationSetErrorKind {
    /// <p>A delegation set with the same owner and caller reference combination has already been created.</p>
    DelegationSetAlreadyCreated(crate::error::DelegationSetAlreadyCreated),
    /// <p>The specified delegation set has already been marked as reusable.</p>
    DelegationSetAlreadyReusable(crate::error::DelegationSetAlreadyReusable),
    /// <p>You can create a hosted zone that has the same name as an existing hosted zone (example.com is common), but there is a
    /// limit to the number of hosted zones that have the same name. If you get this error, Amazon Route 53 has reached that limit. If you own
    /// the domain name and Route 53 generates this error, contact Customer Support.</p>
    DelegationSetNotAvailable(crate::error::DelegationSetNotAvailable),
    /// <p>The specified HostedZone can't be found.</p>
    HostedZoneNotFound(crate::error::HostedZoneNotFound),
    /// <p>Parameter name is not valid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>This operation can't be completed either because the current account has reached the limit on reusable delegation sets
    /// that it can create or because you've reached the limit on the number of Amazon VPCs that you can associate with a private hosted zone.
    /// To get the current limit on the number of reusable delegation sets, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetAccountLimit.html">GetAccountLimit</a>.
    /// To get the current limit on the number of Amazon VPCs that you can associate with a private hosted zone, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetHostedZoneLimit.html">GetHostedZoneLimit</a>.
    /// To request a higher limit, <a href="http://aws.amazon.com/route53-request">create a case</a> with the Amazon Web Services Support Center.</p>
    LimitsExceeded(crate::error::LimitsExceeded),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateReusableDelegationSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateReusableDelegationSetErrorKind::DelegationSetAlreadyCreated(_inner) => {
                _inner.fmt(f)
            }
            CreateReusableDelegationSetErrorKind::DelegationSetAlreadyReusable(_inner) => {
                _inner.fmt(f)
            }
            CreateReusableDelegationSetErrorKind::DelegationSetNotAvailable(_inner) => {
                _inner.fmt(f)
            }
            CreateReusableDelegationSetErrorKind::HostedZoneNotFound(_inner) => _inner.fmt(f),
            CreateReusableDelegationSetErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            CreateReusableDelegationSetErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            CreateReusableDelegationSetErrorKind::LimitsExceeded(_inner) => _inner.fmt(f),
            CreateReusableDelegationSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateReusableDelegationSetError {
    fn code(&self) -> Option<&str> {
        CreateReusableDelegationSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateReusableDelegationSetError {
    /// Creates a new `CreateReusableDelegationSetError`.
    pub fn new(kind: CreateReusableDelegationSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateReusableDelegationSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateReusableDelegationSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateReusableDelegationSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateReusableDelegationSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateReusableDelegationSetErrorKind::DelegationSetAlreadyCreated`.
    pub fn is_delegation_set_already_created(&self) -> bool {
        matches!(
            &self.kind,
            CreateReusableDelegationSetErrorKind::DelegationSetAlreadyCreated(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReusableDelegationSetErrorKind::DelegationSetAlreadyReusable`.
    pub fn is_delegation_set_already_reusable(&self) -> bool {
        matches!(
            &self.kind,
            CreateReusableDelegationSetErrorKind::DelegationSetAlreadyReusable(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReusableDelegationSetErrorKind::DelegationSetNotAvailable`.
    pub fn is_delegation_set_not_available(&self) -> bool {
        matches!(
            &self.kind,
            CreateReusableDelegationSetErrorKind::DelegationSetNotAvailable(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReusableDelegationSetErrorKind::HostedZoneNotFound`.
    pub fn is_hosted_zone_not_found(&self) -> bool {
        matches!(
            &self.kind,
            CreateReusableDelegationSetErrorKind::HostedZoneNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReusableDelegationSetErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(
            &self.kind,
            CreateReusableDelegationSetErrorKind::InvalidArgument(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReusableDelegationSetErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            CreateReusableDelegationSetErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReusableDelegationSetErrorKind::LimitsExceeded`.
    pub fn is_limits_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            CreateReusableDelegationSetErrorKind::LimitsExceeded(_)
        )
    }
}
impl std::error::Error for CreateReusableDelegationSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateReusableDelegationSetErrorKind::DelegationSetAlreadyCreated(_inner) => {
                Some(_inner)
            }
            CreateReusableDelegationSetErrorKind::DelegationSetAlreadyReusable(_inner) => {
                Some(_inner)
            }
            CreateReusableDelegationSetErrorKind::DelegationSetNotAvailable(_inner) => Some(_inner),
            CreateReusableDelegationSetErrorKind::HostedZoneNotFound(_inner) => Some(_inner),
            CreateReusableDelegationSetErrorKind::InvalidArgument(_inner) => Some(_inner),
            CreateReusableDelegationSetErrorKind::InvalidInput(_inner) => Some(_inner),
            CreateReusableDelegationSetErrorKind::LimitsExceeded(_inner) => Some(_inner),
            CreateReusableDelegationSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateTrafficPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateTrafficPolicyError {
    /// Kind of error that occurred.
    pub kind: CreateTrafficPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateTrafficPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateTrafficPolicyErrorKind {
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The format of the traffic policy document that you specified in the <code>Document</code> element is not valid.</p>
    InvalidTrafficPolicyDocument(crate::error::InvalidTrafficPolicyDocument),
    /// <p>This traffic policy can't be created because the current account has reached the limit on the number of traffic policies.</p>
    /// <p>For information about default limits, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a>
    /// in the <i>Amazon Route 53 Developer Guide</i>.</p>
    /// <p>To get the current limit for an account, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetAccountLimit.html">GetAccountLimit</a>.
    /// </p>
    /// <p>To request a higher limit, <a href="http://aws.amazon.com/route53-request">create a case</a> with the Amazon Web Services Support Center.</p>
    TooManyTrafficPolicies(crate::error::TooManyTrafficPolicies),
    /// <p>A traffic policy that has the same value for <code>Name</code> already exists.</p>
    TrafficPolicyAlreadyExists(crate::error::TrafficPolicyAlreadyExists),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateTrafficPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateTrafficPolicyErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            CreateTrafficPolicyErrorKind::InvalidTrafficPolicyDocument(_inner) => _inner.fmt(f),
            CreateTrafficPolicyErrorKind::TooManyTrafficPolicies(_inner) => _inner.fmt(f),
            CreateTrafficPolicyErrorKind::TrafficPolicyAlreadyExists(_inner) => _inner.fmt(f),
            CreateTrafficPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateTrafficPolicyError {
    fn code(&self) -> Option<&str> {
        CreateTrafficPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateTrafficPolicyError {
    /// Creates a new `CreateTrafficPolicyError`.
    pub fn new(kind: CreateTrafficPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateTrafficPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateTrafficPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateTrafficPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateTrafficPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateTrafficPolicyErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, CreateTrafficPolicyErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `CreateTrafficPolicyErrorKind::InvalidTrafficPolicyDocument`.
    pub fn is_invalid_traffic_policy_document(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrafficPolicyErrorKind::InvalidTrafficPolicyDocument(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTrafficPolicyErrorKind::TooManyTrafficPolicies`.
    pub fn is_too_many_traffic_policies(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrafficPolicyErrorKind::TooManyTrafficPolicies(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTrafficPolicyErrorKind::TrafficPolicyAlreadyExists`.
    pub fn is_traffic_policy_already_exists(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrafficPolicyErrorKind::TrafficPolicyAlreadyExists(_)
        )
    }
}
impl std::error::Error for CreateTrafficPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateTrafficPolicyErrorKind::InvalidInput(_inner) => Some(_inner),
            CreateTrafficPolicyErrorKind::InvalidTrafficPolicyDocument(_inner) => Some(_inner),
            CreateTrafficPolicyErrorKind::TooManyTrafficPolicies(_inner) => Some(_inner),
            CreateTrafficPolicyErrorKind::TrafficPolicyAlreadyExists(_inner) => Some(_inner),
            CreateTrafficPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateTrafficPolicyInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateTrafficPolicyInstanceError {
    /// Kind of error that occurred.
    pub kind: CreateTrafficPolicyInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateTrafficPolicyInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateTrafficPolicyInstanceErrorKind {
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>No hosted zone exists with the ID that you specified.</p>
    NoSuchHostedZone(crate::error::NoSuchHostedZone),
    /// <p>No traffic policy exists with the specified ID.</p>
    NoSuchTrafficPolicy(crate::error::NoSuchTrafficPolicy),
    /// <p>This traffic policy instance can't be created because the current account has reached the limit on the number of
    /// traffic policy instances.</p>
    /// <p>For information about default limits, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a>
    /// in the <i>Amazon Route 53 Developer Guide</i>.</p>
    /// <p>For information about how to get the current limit for an account, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetAccountLimit.html">GetAccountLimit</a>.</p>
    /// <p>To request a higher limit, <a href="http://aws.amazon.com/route53-request">create a case</a> with the Amazon Web Services Support Center.</p>
    TooManyTrafficPolicyInstances(crate::error::TooManyTrafficPolicyInstances),
    /// <p>There is already a traffic policy instance with the specified ID.</p>
    TrafficPolicyInstanceAlreadyExists(crate::error::TrafficPolicyInstanceAlreadyExists),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateTrafficPolicyInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateTrafficPolicyInstanceErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            CreateTrafficPolicyInstanceErrorKind::NoSuchHostedZone(_inner) => _inner.fmt(f),
            CreateTrafficPolicyInstanceErrorKind::NoSuchTrafficPolicy(_inner) => _inner.fmt(f),
            CreateTrafficPolicyInstanceErrorKind::TooManyTrafficPolicyInstances(_inner) => {
                _inner.fmt(f)
            }
            CreateTrafficPolicyInstanceErrorKind::TrafficPolicyInstanceAlreadyExists(_inner) => {
                _inner.fmt(f)
            }
            CreateTrafficPolicyInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateTrafficPolicyInstanceError {
    fn code(&self) -> Option<&str> {
        CreateTrafficPolicyInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateTrafficPolicyInstanceError {
    /// Creates a new `CreateTrafficPolicyInstanceError`.
    pub fn new(kind: CreateTrafficPolicyInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateTrafficPolicyInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateTrafficPolicyInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateTrafficPolicyInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateTrafficPolicyInstanceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateTrafficPolicyInstanceErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrafficPolicyInstanceErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTrafficPolicyInstanceErrorKind::NoSuchHostedZone`.
    pub fn is_no_such_hosted_zone(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrafficPolicyInstanceErrorKind::NoSuchHostedZone(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTrafficPolicyInstanceErrorKind::NoSuchTrafficPolicy`.
    pub fn is_no_such_traffic_policy(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrafficPolicyInstanceErrorKind::NoSuchTrafficPolicy(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTrafficPolicyInstanceErrorKind::TooManyTrafficPolicyInstances`.
    pub fn is_too_many_traffic_policy_instances(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrafficPolicyInstanceErrorKind::TooManyTrafficPolicyInstances(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTrafficPolicyInstanceErrorKind::TrafficPolicyInstanceAlreadyExists`.
    pub fn is_traffic_policy_instance_already_exists(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrafficPolicyInstanceErrorKind::TrafficPolicyInstanceAlreadyExists(_)
        )
    }
}
impl std::error::Error for CreateTrafficPolicyInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateTrafficPolicyInstanceErrorKind::InvalidInput(_inner) => Some(_inner),
            CreateTrafficPolicyInstanceErrorKind::NoSuchHostedZone(_inner) => Some(_inner),
            CreateTrafficPolicyInstanceErrorKind::NoSuchTrafficPolicy(_inner) => Some(_inner),
            CreateTrafficPolicyInstanceErrorKind::TooManyTrafficPolicyInstances(_inner) => {
                Some(_inner)
            }
            CreateTrafficPolicyInstanceErrorKind::TrafficPolicyInstanceAlreadyExists(_inner) => {
                Some(_inner)
            }
            CreateTrafficPolicyInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateTrafficPolicyVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateTrafficPolicyVersionError {
    /// Kind of error that occurred.
    pub kind: CreateTrafficPolicyVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateTrafficPolicyVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateTrafficPolicyVersionErrorKind {
    /// <p>Another user submitted a request to create, update, or delete the object at the same time that you did. Retry the request. </p>
    ConcurrentModification(crate::error::ConcurrentModification),
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The format of the traffic policy document that you specified in the <code>Document</code> element is not valid.</p>
    InvalidTrafficPolicyDocument(crate::error::InvalidTrafficPolicyDocument),
    /// <p>No traffic policy exists with the specified ID.</p>
    NoSuchTrafficPolicy(crate::error::NoSuchTrafficPolicy),
    /// <p>This traffic policy version can't be created because you've reached the limit of 1000 on the number of versions
    /// that you can create for the current traffic policy.</p>
    /// <p>To create more traffic policy versions, you can use
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetTrafficPolicy.html">GetTrafficPolicy</a>
    /// to get the traffic policy document for a specified traffic policy version, and then use
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateTrafficPolicy.html">CreateTrafficPolicy</a>
    /// to create a new traffic policy using the traffic policy document.</p>
    TooManyTrafficPolicyVersionsForCurrentPolicy(
        crate::error::TooManyTrafficPolicyVersionsForCurrentPolicy,
    ),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateTrafficPolicyVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateTrafficPolicyVersionErrorKind::ConcurrentModification(_inner) => _inner.fmt(f),
            CreateTrafficPolicyVersionErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            CreateTrafficPolicyVersionErrorKind::InvalidTrafficPolicyDocument(_inner) => {
                _inner.fmt(f)
            }
            CreateTrafficPolicyVersionErrorKind::NoSuchTrafficPolicy(_inner) => _inner.fmt(f),
            CreateTrafficPolicyVersionErrorKind::TooManyTrafficPolicyVersionsForCurrentPolicy(
                _inner,
            ) => _inner.fmt(f),
            CreateTrafficPolicyVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateTrafficPolicyVersionError {
    fn code(&self) -> Option<&str> {
        CreateTrafficPolicyVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateTrafficPolicyVersionError {
    /// Creates a new `CreateTrafficPolicyVersionError`.
    pub fn new(kind: CreateTrafficPolicyVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateTrafficPolicyVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateTrafficPolicyVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateTrafficPolicyVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateTrafficPolicyVersionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateTrafficPolicyVersionErrorKind::ConcurrentModification`.
    pub fn is_concurrent_modification(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrafficPolicyVersionErrorKind::ConcurrentModification(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTrafficPolicyVersionErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrafficPolicyVersionErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTrafficPolicyVersionErrorKind::InvalidTrafficPolicyDocument`.
    pub fn is_invalid_traffic_policy_document(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrafficPolicyVersionErrorKind::InvalidTrafficPolicyDocument(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTrafficPolicyVersionErrorKind::NoSuchTrafficPolicy`.
    pub fn is_no_such_traffic_policy(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrafficPolicyVersionErrorKind::NoSuchTrafficPolicy(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTrafficPolicyVersionErrorKind::TooManyTrafficPolicyVersionsForCurrentPolicy`.
    pub fn is_too_many_traffic_policy_versions_for_current_policy(&self) -> bool {
        matches!(
            &self.kind,
            CreateTrafficPolicyVersionErrorKind::TooManyTrafficPolicyVersionsForCurrentPolicy(_)
        )
    }
}
impl std::error::Error for CreateTrafficPolicyVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateTrafficPolicyVersionErrorKind::ConcurrentModification(_inner) => Some(_inner),
            CreateTrafficPolicyVersionErrorKind::InvalidInput(_inner) => Some(_inner),
            CreateTrafficPolicyVersionErrorKind::InvalidTrafficPolicyDocument(_inner) => {
                Some(_inner)
            }
            CreateTrafficPolicyVersionErrorKind::NoSuchTrafficPolicy(_inner) => Some(_inner),
            CreateTrafficPolicyVersionErrorKind::TooManyTrafficPolicyVersionsForCurrentPolicy(
                _inner,
            ) => Some(_inner),
            CreateTrafficPolicyVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateVPCAssociationAuthorization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateVPCAssociationAuthorizationError {
    /// Kind of error that occurred.
    pub kind: CreateVPCAssociationAuthorizationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateVPCAssociationAuthorization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateVPCAssociationAuthorizationErrorKind {
    /// <p>Another user submitted a request to create, update, or delete the object at the same time that you did. Retry the request. </p>
    ConcurrentModification(crate::error::ConcurrentModification),
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The VPC ID that you specified either isn't a valid ID or the current account is not authorized to access this VPC.</p>
    InvalidVpcId(crate::error::InvalidVpcId),
    /// <p>No hosted zone exists with the ID that you specified.</p>
    NoSuchHostedZone(crate::error::NoSuchHostedZone),
    /// <p>You've created the maximum number of authorizations that can be created for the specified hosted zone.
    /// To authorize another VPC to be associated with the hosted zone, submit a <code>DeleteVPCAssociationAuthorization</code> request
    /// to remove an existing authorization. To get a list of existing authorizations, submit a
    /// <code>ListVPCAssociationAuthorizations</code> request.</p>
    TooManyVpcAssociationAuthorizations(crate::error::TooManyVpcAssociationAuthorizations),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateVPCAssociationAuthorizationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateVPCAssociationAuthorizationErrorKind::ConcurrentModification(_inner) => {
                _inner.fmt(f)
            }
            CreateVPCAssociationAuthorizationErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            CreateVPCAssociationAuthorizationErrorKind::InvalidVpcId(_inner) => _inner.fmt(f),
            CreateVPCAssociationAuthorizationErrorKind::NoSuchHostedZone(_inner) => _inner.fmt(f),
            CreateVPCAssociationAuthorizationErrorKind::TooManyVpcAssociationAuthorizations(
                _inner,
            ) => _inner.fmt(f),
            CreateVPCAssociationAuthorizationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateVPCAssociationAuthorizationError {
    fn code(&self) -> Option<&str> {
        CreateVPCAssociationAuthorizationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateVPCAssociationAuthorizationError {
    /// Creates a new `CreateVPCAssociationAuthorizationError`.
    pub fn new(
        kind: CreateVPCAssociationAuthorizationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateVPCAssociationAuthorizationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateVPCAssociationAuthorizationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateVPCAssociationAuthorizationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateVPCAssociationAuthorizationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateVPCAssociationAuthorizationErrorKind::ConcurrentModification`.
    pub fn is_concurrent_modification(&self) -> bool {
        matches!(
            &self.kind,
            CreateVPCAssociationAuthorizationErrorKind::ConcurrentModification(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVPCAssociationAuthorizationErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            CreateVPCAssociationAuthorizationErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVPCAssociationAuthorizationErrorKind::InvalidVpcId`.
    pub fn is_invalid_vpc_id(&self) -> bool {
        matches!(
            &self.kind,
            CreateVPCAssociationAuthorizationErrorKind::InvalidVpcId(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVPCAssociationAuthorizationErrorKind::NoSuchHostedZone`.
    pub fn is_no_such_hosted_zone(&self) -> bool {
        matches!(
            &self.kind,
            CreateVPCAssociationAuthorizationErrorKind::NoSuchHostedZone(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVPCAssociationAuthorizationErrorKind::TooManyVpcAssociationAuthorizations`.
    pub fn is_too_many_vpc_association_authorizations(&self) -> bool {
        matches!(
            &self.kind,
            CreateVPCAssociationAuthorizationErrorKind::TooManyVpcAssociationAuthorizations(_)
        )
    }
}
impl std::error::Error for CreateVPCAssociationAuthorizationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateVPCAssociationAuthorizationErrorKind::ConcurrentModification(_inner) => {
                Some(_inner)
            }
            CreateVPCAssociationAuthorizationErrorKind::InvalidInput(_inner) => Some(_inner),
            CreateVPCAssociationAuthorizationErrorKind::InvalidVpcId(_inner) => Some(_inner),
            CreateVPCAssociationAuthorizationErrorKind::NoSuchHostedZone(_inner) => Some(_inner),
            CreateVPCAssociationAuthorizationErrorKind::TooManyVpcAssociationAuthorizations(
                _inner,
            ) => Some(_inner),
            CreateVPCAssociationAuthorizationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeactivateKeySigningKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeactivateKeySigningKeyError {
    /// Kind of error that occurred.
    pub kind: DeactivateKeySigningKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeactivateKeySigningKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeactivateKeySigningKeyErrorKind {
    /// <p>Another user submitted a request to create, update, or delete the object at the same time that you did. Retry the request. </p>
    ConcurrentModification(crate::error::ConcurrentModification),
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The key-signing key (KSK) status isn't valid or another KSK has the status <code>INTERNAL_FAILURE</code>.</p>
    InvalidKeySigningKeyStatus(crate::error::InvalidKeySigningKeyStatus),
    /// <p>Your hosted zone status isn't valid for this operation. In the hosted zone, change the status to enable <code>DNSSEC</code>
    /// or disable <code>DNSSEC</code>.</p>
    InvalidSigningStatus(crate::error::InvalidSigningStatus),
    /// <p>The key-signing key (KSK) is specified in a parent DS record.</p>
    KeySigningKeyInParentDsRecord(crate::error::KeySigningKeyInParentDsRecord),
    /// <p>The key-signing key (KSK) that you specified can't be deactivated because it's the only KSK for a
    /// currently-enabled DNSSEC. Disable DNSSEC signing, or add or enable another KSK.</p>
    KeySigningKeyInUse(crate::error::KeySigningKeyInUse),
    /// <p>The specified key-signing key (KSK) doesn't exist.</p>
    NoSuchKeySigningKey(crate::error::NoSuchKeySigningKey),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeactivateKeySigningKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeactivateKeySigningKeyErrorKind::ConcurrentModification(_inner) => _inner.fmt(f),
            DeactivateKeySigningKeyErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            DeactivateKeySigningKeyErrorKind::InvalidKeySigningKeyStatus(_inner) => _inner.fmt(f),
            DeactivateKeySigningKeyErrorKind::InvalidSigningStatus(_inner) => _inner.fmt(f),
            DeactivateKeySigningKeyErrorKind::KeySigningKeyInParentDsRecord(_inner) => {
                _inner.fmt(f)
            }
            DeactivateKeySigningKeyErrorKind::KeySigningKeyInUse(_inner) => _inner.fmt(f),
            DeactivateKeySigningKeyErrorKind::NoSuchKeySigningKey(_inner) => _inner.fmt(f),
            DeactivateKeySigningKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeactivateKeySigningKeyError {
    fn code(&self) -> Option<&str> {
        DeactivateKeySigningKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeactivateKeySigningKeyError {
    /// Creates a new `DeactivateKeySigningKeyError`.
    pub fn new(kind: DeactivateKeySigningKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeactivateKeySigningKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeactivateKeySigningKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeactivateKeySigningKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeactivateKeySigningKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeactivateKeySigningKeyErrorKind::ConcurrentModification`.
    pub fn is_concurrent_modification(&self) -> bool {
        matches!(
            &self.kind,
            DeactivateKeySigningKeyErrorKind::ConcurrentModification(_)
        )
    }
    /// Returns `true` if the error kind is `DeactivateKeySigningKeyErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            DeactivateKeySigningKeyErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `DeactivateKeySigningKeyErrorKind::InvalidKeySigningKeyStatus`.
    pub fn is_invalid_key_signing_key_status(&self) -> bool {
        matches!(
            &self.kind,
            DeactivateKeySigningKeyErrorKind::InvalidKeySigningKeyStatus(_)
        )
    }
    /// Returns `true` if the error kind is `DeactivateKeySigningKeyErrorKind::InvalidSigningStatus`.
    pub fn is_invalid_signing_status(&self) -> bool {
        matches!(
            &self.kind,
            DeactivateKeySigningKeyErrorKind::InvalidSigningStatus(_)
        )
    }
    /// Returns `true` if the error kind is `DeactivateKeySigningKeyErrorKind::KeySigningKeyInParentDsRecord`.
    pub fn is_key_signing_key_in_parent_ds_record(&self) -> bool {
        matches!(
            &self.kind,
            DeactivateKeySigningKeyErrorKind::KeySigningKeyInParentDsRecord(_)
        )
    }
    /// Returns `true` if the error kind is `DeactivateKeySigningKeyErrorKind::KeySigningKeyInUse`.
    pub fn is_key_signing_key_in_use(&self) -> bool {
        matches!(
            &self.kind,
            DeactivateKeySigningKeyErrorKind::KeySigningKeyInUse(_)
        )
    }
    /// Returns `true` if the error kind is `DeactivateKeySigningKeyErrorKind::NoSuchKeySigningKey`.
    pub fn is_no_such_key_signing_key(&self) -> bool {
        matches!(
            &self.kind,
            DeactivateKeySigningKeyErrorKind::NoSuchKeySigningKey(_)
        )
    }
}
impl std::error::Error for DeactivateKeySigningKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeactivateKeySigningKeyErrorKind::ConcurrentModification(_inner) => Some(_inner),
            DeactivateKeySigningKeyErrorKind::InvalidInput(_inner) => Some(_inner),
            DeactivateKeySigningKeyErrorKind::InvalidKeySigningKeyStatus(_inner) => Some(_inner),
            DeactivateKeySigningKeyErrorKind::InvalidSigningStatus(_inner) => Some(_inner),
            DeactivateKeySigningKeyErrorKind::KeySigningKeyInParentDsRecord(_inner) => Some(_inner),
            DeactivateKeySigningKeyErrorKind::KeySigningKeyInUse(_inner) => Some(_inner),
            DeactivateKeySigningKeyErrorKind::NoSuchKeySigningKey(_inner) => Some(_inner),
            DeactivateKeySigningKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteHealthCheck` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteHealthCheckError {
    /// Kind of error that occurred.
    pub kind: DeleteHealthCheckErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteHealthCheck` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteHealthCheckErrorKind {
    /// <p>This error code is not in use.</p>
    HealthCheckInUse(crate::error::HealthCheckInUse),
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>No health check exists with the specified ID.</p>
    NoSuchHealthCheck(crate::error::NoSuchHealthCheck),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteHealthCheckError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteHealthCheckErrorKind::HealthCheckInUse(_inner) => _inner.fmt(f),
            DeleteHealthCheckErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            DeleteHealthCheckErrorKind::NoSuchHealthCheck(_inner) => _inner.fmt(f),
            DeleteHealthCheckErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteHealthCheckError {
    fn code(&self) -> Option<&str> {
        DeleteHealthCheckError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteHealthCheckError {
    /// Creates a new `DeleteHealthCheckError`.
    pub fn new(kind: DeleteHealthCheckErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteHealthCheckError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteHealthCheckErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteHealthCheckError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteHealthCheckErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteHealthCheckErrorKind::HealthCheckInUse`.
    pub fn is_health_check_in_use(&self) -> bool {
        matches!(&self.kind, DeleteHealthCheckErrorKind::HealthCheckInUse(_))
    }
    /// Returns `true` if the error kind is `DeleteHealthCheckErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, DeleteHealthCheckErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `DeleteHealthCheckErrorKind::NoSuchHealthCheck`.
    pub fn is_no_such_health_check(&self) -> bool {
        matches!(&self.kind, DeleteHealthCheckErrorKind::NoSuchHealthCheck(_))
    }
}
impl std::error::Error for DeleteHealthCheckError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteHealthCheckErrorKind::HealthCheckInUse(_inner) => Some(_inner),
            DeleteHealthCheckErrorKind::InvalidInput(_inner) => Some(_inner),
            DeleteHealthCheckErrorKind::NoSuchHealthCheck(_inner) => Some(_inner),
            DeleteHealthCheckErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteHostedZone` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteHostedZoneError {
    /// Kind of error that occurred.
    pub kind: DeleteHostedZoneErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteHostedZone` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteHostedZoneErrorKind {
    /// <p>The hosted zone contains resource records that are not SOA or NS records.</p>
    HostedZoneNotEmpty(crate::error::HostedZoneNotEmpty),
    /// <p>The specified domain name is not valid.</p>
    InvalidDomainName(crate::error::InvalidDomainName),
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>No hosted zone exists with the ID that you specified.</p>
    NoSuchHostedZone(crate::error::NoSuchHostedZone),
    /// <p>If Amazon Route 53 can't process a request before the next request arrives, it will reject
    /// subsequent requests for the same hosted zone and return an <code>HTTP 400 error</code>
    /// (<code>Bad request</code>). If Route 53 returns this error repeatedly for the same request, we
    /// recommend that you wait, in intervals of increasing duration, before you try the request
    /// again.</p>
    PriorRequestNotComplete(crate::error::PriorRequestNotComplete),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteHostedZoneError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteHostedZoneErrorKind::HostedZoneNotEmpty(_inner) => _inner.fmt(f),
            DeleteHostedZoneErrorKind::InvalidDomainName(_inner) => _inner.fmt(f),
            DeleteHostedZoneErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            DeleteHostedZoneErrorKind::NoSuchHostedZone(_inner) => _inner.fmt(f),
            DeleteHostedZoneErrorKind::PriorRequestNotComplete(_inner) => _inner.fmt(f),
            DeleteHostedZoneErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteHostedZoneError {
    fn code(&self) -> Option<&str> {
        DeleteHostedZoneError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteHostedZoneError {
    /// Creates a new `DeleteHostedZoneError`.
    pub fn new(kind: DeleteHostedZoneErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteHostedZoneError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteHostedZoneErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteHostedZoneError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteHostedZoneErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteHostedZoneErrorKind::HostedZoneNotEmpty`.
    pub fn is_hosted_zone_not_empty(&self) -> bool {
        matches!(&self.kind, DeleteHostedZoneErrorKind::HostedZoneNotEmpty(_))
    }
    /// Returns `true` if the error kind is `DeleteHostedZoneErrorKind::InvalidDomainName`.
    pub fn is_invalid_domain_name(&self) -> bool {
        matches!(&self.kind, DeleteHostedZoneErrorKind::InvalidDomainName(_))
    }
    /// Returns `true` if the error kind is `DeleteHostedZoneErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, DeleteHostedZoneErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `DeleteHostedZoneErrorKind::NoSuchHostedZone`.
    pub fn is_no_such_hosted_zone(&self) -> bool {
        matches!(&self.kind, DeleteHostedZoneErrorKind::NoSuchHostedZone(_))
    }
    /// Returns `true` if the error kind is `DeleteHostedZoneErrorKind::PriorRequestNotComplete`.
    pub fn is_prior_request_not_complete(&self) -> bool {
        matches!(
            &self.kind,
            DeleteHostedZoneErrorKind::PriorRequestNotComplete(_)
        )
    }
}
impl std::error::Error for DeleteHostedZoneError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteHostedZoneErrorKind::HostedZoneNotEmpty(_inner) => Some(_inner),
            DeleteHostedZoneErrorKind::InvalidDomainName(_inner) => Some(_inner),
            DeleteHostedZoneErrorKind::InvalidInput(_inner) => Some(_inner),
            DeleteHostedZoneErrorKind::NoSuchHostedZone(_inner) => Some(_inner),
            DeleteHostedZoneErrorKind::PriorRequestNotComplete(_inner) => Some(_inner),
            DeleteHostedZoneErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteKeySigningKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteKeySigningKeyError {
    /// Kind of error that occurred.
    pub kind: DeleteKeySigningKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteKeySigningKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteKeySigningKeyErrorKind {
    /// <p>Another user submitted a request to create, update, or delete the object at the same time that you did. Retry the request. </p>
    ConcurrentModification(crate::error::ConcurrentModification),
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The key-signing key (KSK) status isn't valid or another KSK has the status <code>INTERNAL_FAILURE</code>.</p>
    InvalidKeySigningKeyStatus(crate::error::InvalidKeySigningKeyStatus),
    /// <p>The KeyManagementServiceArn that you specified isn't valid to use with DNSSEC signing.</p>
    InvalidKmsArn(crate::error::InvalidKmsArn),
    /// <p>Your hosted zone status isn't valid for this operation. In the hosted zone, change the status to enable <code>DNSSEC</code>
    /// or disable <code>DNSSEC</code>.</p>
    InvalidSigningStatus(crate::error::InvalidSigningStatus),
    /// <p>The specified key-signing key (KSK) doesn't exist.</p>
    NoSuchKeySigningKey(crate::error::NoSuchKeySigningKey),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteKeySigningKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteKeySigningKeyErrorKind::ConcurrentModification(_inner) => _inner.fmt(f),
            DeleteKeySigningKeyErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            DeleteKeySigningKeyErrorKind::InvalidKeySigningKeyStatus(_inner) => _inner.fmt(f),
            DeleteKeySigningKeyErrorKind::InvalidKmsArn(_inner) => _inner.fmt(f),
            DeleteKeySigningKeyErrorKind::InvalidSigningStatus(_inner) => _inner.fmt(f),
            DeleteKeySigningKeyErrorKind::NoSuchKeySigningKey(_inner) => _inner.fmt(f),
            DeleteKeySigningKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteKeySigningKeyError {
    fn code(&self) -> Option<&str> {
        DeleteKeySigningKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteKeySigningKeyError {
    /// Creates a new `DeleteKeySigningKeyError`.
    pub fn new(kind: DeleteKeySigningKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteKeySigningKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteKeySigningKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteKeySigningKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteKeySigningKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteKeySigningKeyErrorKind::ConcurrentModification`.
    pub fn is_concurrent_modification(&self) -> bool {
        matches!(
            &self.kind,
            DeleteKeySigningKeyErrorKind::ConcurrentModification(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteKeySigningKeyErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, DeleteKeySigningKeyErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `DeleteKeySigningKeyErrorKind::InvalidKeySigningKeyStatus`.
    pub fn is_invalid_key_signing_key_status(&self) -> bool {
        matches!(
            &self.kind,
            DeleteKeySigningKeyErrorKind::InvalidKeySigningKeyStatus(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteKeySigningKeyErrorKind::InvalidKmsArn`.
    pub fn is_invalid_kms_arn(&self) -> bool {
        matches!(&self.kind, DeleteKeySigningKeyErrorKind::InvalidKmsArn(_))
    }
    /// Returns `true` if the error kind is `DeleteKeySigningKeyErrorKind::InvalidSigningStatus`.
    pub fn is_invalid_signing_status(&self) -> bool {
        matches!(
            &self.kind,
            DeleteKeySigningKeyErrorKind::InvalidSigningStatus(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteKeySigningKeyErrorKind::NoSuchKeySigningKey`.
    pub fn is_no_such_key_signing_key(&self) -> bool {
        matches!(
            &self.kind,
            DeleteKeySigningKeyErrorKind::NoSuchKeySigningKey(_)
        )
    }
}
impl std::error::Error for DeleteKeySigningKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteKeySigningKeyErrorKind::ConcurrentModification(_inner) => Some(_inner),
            DeleteKeySigningKeyErrorKind::InvalidInput(_inner) => Some(_inner),
            DeleteKeySigningKeyErrorKind::InvalidKeySigningKeyStatus(_inner) => Some(_inner),
            DeleteKeySigningKeyErrorKind::InvalidKmsArn(_inner) => Some(_inner),
            DeleteKeySigningKeyErrorKind::InvalidSigningStatus(_inner) => Some(_inner),
            DeleteKeySigningKeyErrorKind::NoSuchKeySigningKey(_inner) => Some(_inner),
            DeleteKeySigningKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteQueryLoggingConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteQueryLoggingConfigError {
    /// Kind of error that occurred.
    pub kind: DeleteQueryLoggingConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteQueryLoggingConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteQueryLoggingConfigErrorKind {
    /// <p>Another user submitted a request to create, update, or delete the object at the same time that you did. Retry the request. </p>
    ConcurrentModification(crate::error::ConcurrentModification),
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>There is no DNS query logging configuration with the specified ID.</p>
    NoSuchQueryLoggingConfig(crate::error::NoSuchQueryLoggingConfig),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteQueryLoggingConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteQueryLoggingConfigErrorKind::ConcurrentModification(_inner) => _inner.fmt(f),
            DeleteQueryLoggingConfigErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            DeleteQueryLoggingConfigErrorKind::NoSuchQueryLoggingConfig(_inner) => _inner.fmt(f),
            DeleteQueryLoggingConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteQueryLoggingConfigError {
    fn code(&self) -> Option<&str> {
        DeleteQueryLoggingConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteQueryLoggingConfigError {
    /// Creates a new `DeleteQueryLoggingConfigError`.
    pub fn new(kind: DeleteQueryLoggingConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteQueryLoggingConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteQueryLoggingConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteQueryLoggingConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteQueryLoggingConfigErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteQueryLoggingConfigErrorKind::ConcurrentModification`.
    pub fn is_concurrent_modification(&self) -> bool {
        matches!(
            &self.kind,
            DeleteQueryLoggingConfigErrorKind::ConcurrentModification(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteQueryLoggingConfigErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            DeleteQueryLoggingConfigErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteQueryLoggingConfigErrorKind::NoSuchQueryLoggingConfig`.
    pub fn is_no_such_query_logging_config(&self) -> bool {
        matches!(
            &self.kind,
            DeleteQueryLoggingConfigErrorKind::NoSuchQueryLoggingConfig(_)
        )
    }
}
impl std::error::Error for DeleteQueryLoggingConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteQueryLoggingConfigErrorKind::ConcurrentModification(_inner) => Some(_inner),
            DeleteQueryLoggingConfigErrorKind::InvalidInput(_inner) => Some(_inner),
            DeleteQueryLoggingConfigErrorKind::NoSuchQueryLoggingConfig(_inner) => Some(_inner),
            DeleteQueryLoggingConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteReusableDelegationSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteReusableDelegationSetError {
    /// Kind of error that occurred.
    pub kind: DeleteReusableDelegationSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteReusableDelegationSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteReusableDelegationSetErrorKind {
    /// <p>The specified delegation contains associated hosted zones which must be deleted before the reusable delegation set
    /// can be deleted.</p>
    DelegationSetInUse(crate::error::DelegationSetInUse),
    /// <p>A reusable delegation set with the specified ID does not exist.</p>
    DelegationSetNotReusable(crate::error::DelegationSetNotReusable),
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>A reusable delegation set with the specified ID does not exist.</p>
    NoSuchDelegationSet(crate::error::NoSuchDelegationSet),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteReusableDelegationSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteReusableDelegationSetErrorKind::DelegationSetInUse(_inner) => _inner.fmt(f),
            DeleteReusableDelegationSetErrorKind::DelegationSetNotReusable(_inner) => _inner.fmt(f),
            DeleteReusableDelegationSetErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            DeleteReusableDelegationSetErrorKind::NoSuchDelegationSet(_inner) => _inner.fmt(f),
            DeleteReusableDelegationSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteReusableDelegationSetError {
    fn code(&self) -> Option<&str> {
        DeleteReusableDelegationSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteReusableDelegationSetError {
    /// Creates a new `DeleteReusableDelegationSetError`.
    pub fn new(kind: DeleteReusableDelegationSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteReusableDelegationSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteReusableDelegationSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteReusableDelegationSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteReusableDelegationSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteReusableDelegationSetErrorKind::DelegationSetInUse`.
    pub fn is_delegation_set_in_use(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReusableDelegationSetErrorKind::DelegationSetInUse(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteReusableDelegationSetErrorKind::DelegationSetNotReusable`.
    pub fn is_delegation_set_not_reusable(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReusableDelegationSetErrorKind::DelegationSetNotReusable(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteReusableDelegationSetErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReusableDelegationSetErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteReusableDelegationSetErrorKind::NoSuchDelegationSet`.
    pub fn is_no_such_delegation_set(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReusableDelegationSetErrorKind::NoSuchDelegationSet(_)
        )
    }
}
impl std::error::Error for DeleteReusableDelegationSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteReusableDelegationSetErrorKind::DelegationSetInUse(_inner) => Some(_inner),
            DeleteReusableDelegationSetErrorKind::DelegationSetNotReusable(_inner) => Some(_inner),
            DeleteReusableDelegationSetErrorKind::InvalidInput(_inner) => Some(_inner),
            DeleteReusableDelegationSetErrorKind::NoSuchDelegationSet(_inner) => Some(_inner),
            DeleteReusableDelegationSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteTrafficPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteTrafficPolicyError {
    /// Kind of error that occurred.
    pub kind: DeleteTrafficPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteTrafficPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteTrafficPolicyErrorKind {
    /// <p>Another user submitted a request to create, update, or delete the object at the same time that you did. Retry the request. </p>
    ConcurrentModification(crate::error::ConcurrentModification),
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>No traffic policy exists with the specified ID.</p>
    NoSuchTrafficPolicy(crate::error::NoSuchTrafficPolicy),
    /// <p>One or more traffic policy instances were created by using the specified traffic policy.</p>
    TrafficPolicyInUse(crate::error::TrafficPolicyInUse),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteTrafficPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteTrafficPolicyErrorKind::ConcurrentModification(_inner) => _inner.fmt(f),
            DeleteTrafficPolicyErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            DeleteTrafficPolicyErrorKind::NoSuchTrafficPolicy(_inner) => _inner.fmt(f),
            DeleteTrafficPolicyErrorKind::TrafficPolicyInUse(_inner) => _inner.fmt(f),
            DeleteTrafficPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteTrafficPolicyError {
    fn code(&self) -> Option<&str> {
        DeleteTrafficPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteTrafficPolicyError {
    /// Creates a new `DeleteTrafficPolicyError`.
    pub fn new(kind: DeleteTrafficPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteTrafficPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteTrafficPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteTrafficPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteTrafficPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteTrafficPolicyErrorKind::ConcurrentModification`.
    pub fn is_concurrent_modification(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTrafficPolicyErrorKind::ConcurrentModification(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTrafficPolicyErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, DeleteTrafficPolicyErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `DeleteTrafficPolicyErrorKind::NoSuchTrafficPolicy`.
    pub fn is_no_such_traffic_policy(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTrafficPolicyErrorKind::NoSuchTrafficPolicy(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTrafficPolicyErrorKind::TrafficPolicyInUse`.
    pub fn is_traffic_policy_in_use(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTrafficPolicyErrorKind::TrafficPolicyInUse(_)
        )
    }
}
impl std::error::Error for DeleteTrafficPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteTrafficPolicyErrorKind::ConcurrentModification(_inner) => Some(_inner),
            DeleteTrafficPolicyErrorKind::InvalidInput(_inner) => Some(_inner),
            DeleteTrafficPolicyErrorKind::NoSuchTrafficPolicy(_inner) => Some(_inner),
            DeleteTrafficPolicyErrorKind::TrafficPolicyInUse(_inner) => Some(_inner),
            DeleteTrafficPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteTrafficPolicyInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteTrafficPolicyInstanceError {
    /// Kind of error that occurred.
    pub kind: DeleteTrafficPolicyInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteTrafficPolicyInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteTrafficPolicyInstanceErrorKind {
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>No traffic policy instance exists with the specified ID.</p>
    NoSuchTrafficPolicyInstance(crate::error::NoSuchTrafficPolicyInstance),
    /// <p>If Amazon Route 53 can't process a request before the next request arrives, it will reject
    /// subsequent requests for the same hosted zone and return an <code>HTTP 400 error</code>
    /// (<code>Bad request</code>). If Route 53 returns this error repeatedly for the same request, we
    /// recommend that you wait, in intervals of increasing duration, before you try the request
    /// again.</p>
    PriorRequestNotComplete(crate::error::PriorRequestNotComplete),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteTrafficPolicyInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteTrafficPolicyInstanceErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            DeleteTrafficPolicyInstanceErrorKind::NoSuchTrafficPolicyInstance(_inner) => {
                _inner.fmt(f)
            }
            DeleteTrafficPolicyInstanceErrorKind::PriorRequestNotComplete(_inner) => _inner.fmt(f),
            DeleteTrafficPolicyInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteTrafficPolicyInstanceError {
    fn code(&self) -> Option<&str> {
        DeleteTrafficPolicyInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteTrafficPolicyInstanceError {
    /// Creates a new `DeleteTrafficPolicyInstanceError`.
    pub fn new(kind: DeleteTrafficPolicyInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteTrafficPolicyInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteTrafficPolicyInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteTrafficPolicyInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteTrafficPolicyInstanceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteTrafficPolicyInstanceErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTrafficPolicyInstanceErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTrafficPolicyInstanceErrorKind::NoSuchTrafficPolicyInstance`.
    pub fn is_no_such_traffic_policy_instance(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTrafficPolicyInstanceErrorKind::NoSuchTrafficPolicyInstance(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTrafficPolicyInstanceErrorKind::PriorRequestNotComplete`.
    pub fn is_prior_request_not_complete(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTrafficPolicyInstanceErrorKind::PriorRequestNotComplete(_)
        )
    }
}
impl std::error::Error for DeleteTrafficPolicyInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteTrafficPolicyInstanceErrorKind::InvalidInput(_inner) => Some(_inner),
            DeleteTrafficPolicyInstanceErrorKind::NoSuchTrafficPolicyInstance(_inner) => {
                Some(_inner)
            }
            DeleteTrafficPolicyInstanceErrorKind::PriorRequestNotComplete(_inner) => Some(_inner),
            DeleteTrafficPolicyInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteVPCAssociationAuthorization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteVPCAssociationAuthorizationError {
    /// Kind of error that occurred.
    pub kind: DeleteVPCAssociationAuthorizationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteVPCAssociationAuthorization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteVPCAssociationAuthorizationErrorKind {
    /// <p>Another user submitted a request to create, update, or delete the object at the same time that you did. Retry the request. </p>
    ConcurrentModification(crate::error::ConcurrentModification),
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The VPC ID that you specified either isn't a valid ID or the current account is not authorized to access this VPC.</p>
    InvalidVpcId(crate::error::InvalidVpcId),
    /// <p>No hosted zone exists with the ID that you specified.</p>
    NoSuchHostedZone(crate::error::NoSuchHostedZone),
    /// <p>The VPC that you specified is not authorized to be associated with the hosted zone.</p>
    VpcAssociationAuthorizationNotFound(crate::error::VpcAssociationAuthorizationNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteVPCAssociationAuthorizationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteVPCAssociationAuthorizationErrorKind::ConcurrentModification(_inner) => {
                _inner.fmt(f)
            }
            DeleteVPCAssociationAuthorizationErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            DeleteVPCAssociationAuthorizationErrorKind::InvalidVpcId(_inner) => _inner.fmt(f),
            DeleteVPCAssociationAuthorizationErrorKind::NoSuchHostedZone(_inner) => _inner.fmt(f),
            DeleteVPCAssociationAuthorizationErrorKind::VpcAssociationAuthorizationNotFound(
                _inner,
            ) => _inner.fmt(f),
            DeleteVPCAssociationAuthorizationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteVPCAssociationAuthorizationError {
    fn code(&self) -> Option<&str> {
        DeleteVPCAssociationAuthorizationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteVPCAssociationAuthorizationError {
    /// Creates a new `DeleteVPCAssociationAuthorizationError`.
    pub fn new(
        kind: DeleteVPCAssociationAuthorizationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteVPCAssociationAuthorizationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteVPCAssociationAuthorizationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteVPCAssociationAuthorizationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteVPCAssociationAuthorizationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteVPCAssociationAuthorizationErrorKind::ConcurrentModification`.
    pub fn is_concurrent_modification(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVPCAssociationAuthorizationErrorKind::ConcurrentModification(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVPCAssociationAuthorizationErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVPCAssociationAuthorizationErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVPCAssociationAuthorizationErrorKind::InvalidVpcId`.
    pub fn is_invalid_vpc_id(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVPCAssociationAuthorizationErrorKind::InvalidVpcId(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVPCAssociationAuthorizationErrorKind::NoSuchHostedZone`.
    pub fn is_no_such_hosted_zone(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVPCAssociationAuthorizationErrorKind::NoSuchHostedZone(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVPCAssociationAuthorizationErrorKind::VpcAssociationAuthorizationNotFound`.
    pub fn is_vpc_association_authorization_not_found(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVPCAssociationAuthorizationErrorKind::VpcAssociationAuthorizationNotFound(_)
        )
    }
}
impl std::error::Error for DeleteVPCAssociationAuthorizationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteVPCAssociationAuthorizationErrorKind::ConcurrentModification(_inner) => {
                Some(_inner)
            }
            DeleteVPCAssociationAuthorizationErrorKind::InvalidInput(_inner) => Some(_inner),
            DeleteVPCAssociationAuthorizationErrorKind::InvalidVpcId(_inner) => Some(_inner),
            DeleteVPCAssociationAuthorizationErrorKind::NoSuchHostedZone(_inner) => Some(_inner),
            DeleteVPCAssociationAuthorizationErrorKind::VpcAssociationAuthorizationNotFound(
                _inner,
            ) => Some(_inner),
            DeleteVPCAssociationAuthorizationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisableHostedZoneDNSSEC` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisableHostedZoneDNSSECError {
    /// Kind of error that occurred.
    pub kind: DisableHostedZoneDNSSECErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisableHostedZoneDNSSEC` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisableHostedZoneDNSSECErrorKind {
    /// <p>Another user submitted a request to create, update, or delete the object at the same time that you did. Retry the request. </p>
    ConcurrentModification(crate::error::ConcurrentModification),
    /// <p>The hosted zone doesn't have any DNSSEC resources.</p>
    DnssecNotFound(crate::error::DnssecNotFound),
    /// <p>Parameter name is not valid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The key-signing key (KSK) status isn't valid or another KSK has the status <code>INTERNAL_FAILURE</code>.</p>
    InvalidKeySigningKeyStatus(crate::error::InvalidKeySigningKeyStatus),
    /// <p>The KeyManagementServiceArn that you specified isn't valid to use with DNSSEC signing.</p>
    InvalidKmsArn(crate::error::InvalidKmsArn),
    /// <p>The key-signing key (KSK) is specified in a parent DS record.</p>
    KeySigningKeyInParentDsRecord(crate::error::KeySigningKeyInParentDsRecord),
    /// <p>No hosted zone exists with the ID that you specified.</p>
    NoSuchHostedZone(crate::error::NoSuchHostedZone),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisableHostedZoneDNSSECError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisableHostedZoneDNSSECErrorKind::ConcurrentModification(_inner) => _inner.fmt(f),
            DisableHostedZoneDNSSECErrorKind::DnssecNotFound(_inner) => _inner.fmt(f),
            DisableHostedZoneDNSSECErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            DisableHostedZoneDNSSECErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            DisableHostedZoneDNSSECErrorKind::InvalidKeySigningKeyStatus(_inner) => _inner.fmt(f),
            DisableHostedZoneDNSSECErrorKind::InvalidKmsArn(_inner) => _inner.fmt(f),
            DisableHostedZoneDNSSECErrorKind::KeySigningKeyInParentDsRecord(_inner) => {
                _inner.fmt(f)
            }
            DisableHostedZoneDNSSECErrorKind::NoSuchHostedZone(_inner) => _inner.fmt(f),
            DisableHostedZoneDNSSECErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisableHostedZoneDNSSECError {
    fn code(&self) -> Option<&str> {
        DisableHostedZoneDNSSECError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisableHostedZoneDNSSECError {
    /// Creates a new `DisableHostedZoneDNSSECError`.
    pub fn new(kind: DisableHostedZoneDNSSECErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisableHostedZoneDNSSECError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisableHostedZoneDNSSECErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisableHostedZoneDNSSECError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisableHostedZoneDNSSECErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisableHostedZoneDNSSECErrorKind::ConcurrentModification`.
    pub fn is_concurrent_modification(&self) -> bool {
        matches!(
            &self.kind,
            DisableHostedZoneDNSSECErrorKind::ConcurrentModification(_)
        )
    }
    /// Returns `true` if the error kind is `DisableHostedZoneDNSSECErrorKind::DnssecNotFound`.
    pub fn is_dnssec_not_found(&self) -> bool {
        matches!(
            &self.kind,
            DisableHostedZoneDNSSECErrorKind::DnssecNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `DisableHostedZoneDNSSECErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(
            &self.kind,
            DisableHostedZoneDNSSECErrorKind::InvalidArgument(_)
        )
    }
    /// Returns `true` if the error kind is `DisableHostedZoneDNSSECErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            DisableHostedZoneDNSSECErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `DisableHostedZoneDNSSECErrorKind::InvalidKeySigningKeyStatus`.
    pub fn is_invalid_key_signing_key_status(&self) -> bool {
        matches!(
            &self.kind,
            DisableHostedZoneDNSSECErrorKind::InvalidKeySigningKeyStatus(_)
        )
    }
    /// Returns `true` if the error kind is `DisableHostedZoneDNSSECErrorKind::InvalidKmsArn`.
    pub fn is_invalid_kms_arn(&self) -> bool {
        matches!(
            &self.kind,
            DisableHostedZoneDNSSECErrorKind::InvalidKmsArn(_)
        )
    }
    /// Returns `true` if the error kind is `DisableHostedZoneDNSSECErrorKind::KeySigningKeyInParentDsRecord`.
    pub fn is_key_signing_key_in_parent_ds_record(&self) -> bool {
        matches!(
            &self.kind,
            DisableHostedZoneDNSSECErrorKind::KeySigningKeyInParentDsRecord(_)
        )
    }
    /// Returns `true` if the error kind is `DisableHostedZoneDNSSECErrorKind::NoSuchHostedZone`.
    pub fn is_no_such_hosted_zone(&self) -> bool {
        matches!(
            &self.kind,
            DisableHostedZoneDNSSECErrorKind::NoSuchHostedZone(_)
        )
    }
}
impl std::error::Error for DisableHostedZoneDNSSECError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisableHostedZoneDNSSECErrorKind::ConcurrentModification(_inner) => Some(_inner),
            DisableHostedZoneDNSSECErrorKind::DnssecNotFound(_inner) => Some(_inner),
            DisableHostedZoneDNSSECErrorKind::InvalidArgument(_inner) => Some(_inner),
            DisableHostedZoneDNSSECErrorKind::InvalidInput(_inner) => Some(_inner),
            DisableHostedZoneDNSSECErrorKind::InvalidKeySigningKeyStatus(_inner) => Some(_inner),
            DisableHostedZoneDNSSECErrorKind::InvalidKmsArn(_inner) => Some(_inner),
            DisableHostedZoneDNSSECErrorKind::KeySigningKeyInParentDsRecord(_inner) => Some(_inner),
            DisableHostedZoneDNSSECErrorKind::NoSuchHostedZone(_inner) => Some(_inner),
            DisableHostedZoneDNSSECErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateVPCFromHostedZone` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateVPCFromHostedZoneError {
    /// Kind of error that occurred.
    pub kind: DisassociateVPCFromHostedZoneErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateVPCFromHostedZone` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateVPCFromHostedZoneErrorKind {
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The VPC ID that you specified either isn't a valid ID or the current account is not authorized to access this VPC.</p>
    InvalidVpcId(crate::error::InvalidVpcId),
    /// <p>The VPC that you're trying to disassociate from the private hosted zone is the last VPC that is associated with
    /// the hosted zone. Amazon Route 53 doesn't support disassociating the last VPC from a hosted zone.</p>
    LastVpcAssociation(crate::error::LastVpcAssociation),
    /// <p>No hosted zone exists with the ID that you specified.</p>
    NoSuchHostedZone(crate::error::NoSuchHostedZone),
    /// <p>The specified VPC and hosted zone are not currently associated.</p>
    VpcAssociationNotFound(crate::error::VpcAssociationNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateVPCFromHostedZoneError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateVPCFromHostedZoneErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            DisassociateVPCFromHostedZoneErrorKind::InvalidVpcId(_inner) => _inner.fmt(f),
            DisassociateVPCFromHostedZoneErrorKind::LastVpcAssociation(_inner) => _inner.fmt(f),
            DisassociateVPCFromHostedZoneErrorKind::NoSuchHostedZone(_inner) => _inner.fmt(f),
            DisassociateVPCFromHostedZoneErrorKind::VpcAssociationNotFound(_inner) => _inner.fmt(f),
            DisassociateVPCFromHostedZoneErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateVPCFromHostedZoneError {
    fn code(&self) -> Option<&str> {
        DisassociateVPCFromHostedZoneError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateVPCFromHostedZoneError {
    /// Creates a new `DisassociateVPCFromHostedZoneError`.
    pub fn new(
        kind: DisassociateVPCFromHostedZoneErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateVPCFromHostedZoneError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateVPCFromHostedZoneErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateVPCFromHostedZoneError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateVPCFromHostedZoneErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateVPCFromHostedZoneErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateVPCFromHostedZoneErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateVPCFromHostedZoneErrorKind::InvalidVpcId`.
    pub fn is_invalid_vpc_id(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateVPCFromHostedZoneErrorKind::InvalidVpcId(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateVPCFromHostedZoneErrorKind::LastVpcAssociation`.
    pub fn is_last_vpc_association(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateVPCFromHostedZoneErrorKind::LastVpcAssociation(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateVPCFromHostedZoneErrorKind::NoSuchHostedZone`.
    pub fn is_no_such_hosted_zone(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateVPCFromHostedZoneErrorKind::NoSuchHostedZone(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateVPCFromHostedZoneErrorKind::VpcAssociationNotFound`.
    pub fn is_vpc_association_not_found(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateVPCFromHostedZoneErrorKind::VpcAssociationNotFound(_)
        )
    }
}
impl std::error::Error for DisassociateVPCFromHostedZoneError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateVPCFromHostedZoneErrorKind::InvalidInput(_inner) => Some(_inner),
            DisassociateVPCFromHostedZoneErrorKind::InvalidVpcId(_inner) => Some(_inner),
            DisassociateVPCFromHostedZoneErrorKind::LastVpcAssociation(_inner) => Some(_inner),
            DisassociateVPCFromHostedZoneErrorKind::NoSuchHostedZone(_inner) => Some(_inner),
            DisassociateVPCFromHostedZoneErrorKind::VpcAssociationNotFound(_inner) => Some(_inner),
            DisassociateVPCFromHostedZoneErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `EnableHostedZoneDNSSEC` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EnableHostedZoneDNSSECError {
    /// Kind of error that occurred.
    pub kind: EnableHostedZoneDNSSECErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `EnableHostedZoneDNSSEC` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EnableHostedZoneDNSSECErrorKind {
    /// <p>Another user submitted a request to create, update, or delete the object at the same time that you did. Retry the request. </p>
    ConcurrentModification(crate::error::ConcurrentModification),
    /// <p>The hosted zone doesn't have any DNSSEC resources.</p>
    DnssecNotFound(crate::error::DnssecNotFound),
    /// <p>The hosted zone nameservers don't match the parent nameservers. The hosted zone and parent must have the same nameservers.</p>
    HostedZonePartiallyDelegated(crate::error::HostedZonePartiallyDelegated),
    /// <p>Parameter name is not valid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The key-signing key (KSK) status isn't valid or another KSK has the status <code>INTERNAL_FAILURE</code>.</p>
    InvalidKeySigningKeyStatus(crate::error::InvalidKeySigningKeyStatus),
    /// <p>The KeyManagementServiceArn that you specified isn't valid to use with DNSSEC signing.</p>
    InvalidKmsArn(crate::error::InvalidKmsArn),
    /// <p>A key-signing key (KSK) with <code>ACTIVE</code> status wasn't found.</p>
    KeySigningKeyWithActiveStatusNotFound(crate::error::KeySigningKeyWithActiveStatusNotFound),
    /// <p>No hosted zone exists with the ID that you specified.</p>
    NoSuchHostedZone(crate::error::NoSuchHostedZone),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EnableHostedZoneDNSSECError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EnableHostedZoneDNSSECErrorKind::ConcurrentModification(_inner) => _inner.fmt(f),
            EnableHostedZoneDNSSECErrorKind::DnssecNotFound(_inner) => _inner.fmt(f),
            EnableHostedZoneDNSSECErrorKind::HostedZonePartiallyDelegated(_inner) => _inner.fmt(f),
            EnableHostedZoneDNSSECErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            EnableHostedZoneDNSSECErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            EnableHostedZoneDNSSECErrorKind::InvalidKeySigningKeyStatus(_inner) => _inner.fmt(f),
            EnableHostedZoneDNSSECErrorKind::InvalidKmsArn(_inner) => _inner.fmt(f),
            EnableHostedZoneDNSSECErrorKind::KeySigningKeyWithActiveStatusNotFound(_inner) => {
                _inner.fmt(f)
            }
            EnableHostedZoneDNSSECErrorKind::NoSuchHostedZone(_inner) => _inner.fmt(f),
            EnableHostedZoneDNSSECErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EnableHostedZoneDNSSECError {
    fn code(&self) -> Option<&str> {
        EnableHostedZoneDNSSECError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl EnableHostedZoneDNSSECError {
    /// Creates a new `EnableHostedZoneDNSSECError`.
    pub fn new(kind: EnableHostedZoneDNSSECErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EnableHostedZoneDNSSECError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EnableHostedZoneDNSSECErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EnableHostedZoneDNSSECError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EnableHostedZoneDNSSECErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `EnableHostedZoneDNSSECErrorKind::ConcurrentModification`.
    pub fn is_concurrent_modification(&self) -> bool {
        matches!(
            &self.kind,
            EnableHostedZoneDNSSECErrorKind::ConcurrentModification(_)
        )
    }
    /// Returns `true` if the error kind is `EnableHostedZoneDNSSECErrorKind::DnssecNotFound`.
    pub fn is_dnssec_not_found(&self) -> bool {
        matches!(
            &self.kind,
            EnableHostedZoneDNSSECErrorKind::DnssecNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `EnableHostedZoneDNSSECErrorKind::HostedZonePartiallyDelegated`.
    pub fn is_hosted_zone_partially_delegated(&self) -> bool {
        matches!(
            &self.kind,
            EnableHostedZoneDNSSECErrorKind::HostedZonePartiallyDelegated(_)
        )
    }
    /// Returns `true` if the error kind is `EnableHostedZoneDNSSECErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(
            &self.kind,
            EnableHostedZoneDNSSECErrorKind::InvalidArgument(_)
        )
    }
    /// Returns `true` if the error kind is `EnableHostedZoneDNSSECErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, EnableHostedZoneDNSSECErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `EnableHostedZoneDNSSECErrorKind::InvalidKeySigningKeyStatus`.
    pub fn is_invalid_key_signing_key_status(&self) -> bool {
        matches!(
            &self.kind,
            EnableHostedZoneDNSSECErrorKind::InvalidKeySigningKeyStatus(_)
        )
    }
    /// Returns `true` if the error kind is `EnableHostedZoneDNSSECErrorKind::InvalidKmsArn`.
    pub fn is_invalid_kms_arn(&self) -> bool {
        matches!(
            &self.kind,
            EnableHostedZoneDNSSECErrorKind::InvalidKmsArn(_)
        )
    }
    /// Returns `true` if the error kind is `EnableHostedZoneDNSSECErrorKind::KeySigningKeyWithActiveStatusNotFound`.
    pub fn is_key_signing_key_with_active_status_not_found(&self) -> bool {
        matches!(
            &self.kind,
            EnableHostedZoneDNSSECErrorKind::KeySigningKeyWithActiveStatusNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `EnableHostedZoneDNSSECErrorKind::NoSuchHostedZone`.
    pub fn is_no_such_hosted_zone(&self) -> bool {
        matches!(
            &self.kind,
            EnableHostedZoneDNSSECErrorKind::NoSuchHostedZone(_)
        )
    }
}
impl std::error::Error for EnableHostedZoneDNSSECError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EnableHostedZoneDNSSECErrorKind::ConcurrentModification(_inner) => Some(_inner),
            EnableHostedZoneDNSSECErrorKind::DnssecNotFound(_inner) => Some(_inner),
            EnableHostedZoneDNSSECErrorKind::HostedZonePartiallyDelegated(_inner) => Some(_inner),
            EnableHostedZoneDNSSECErrorKind::InvalidArgument(_inner) => Some(_inner),
            EnableHostedZoneDNSSECErrorKind::InvalidInput(_inner) => Some(_inner),
            EnableHostedZoneDNSSECErrorKind::InvalidKeySigningKeyStatus(_inner) => Some(_inner),
            EnableHostedZoneDNSSECErrorKind::InvalidKmsArn(_inner) => Some(_inner),
            EnableHostedZoneDNSSECErrorKind::KeySigningKeyWithActiveStatusNotFound(_inner) => {
                Some(_inner)
            }
            EnableHostedZoneDNSSECErrorKind::NoSuchHostedZone(_inner) => Some(_inner),
            EnableHostedZoneDNSSECErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAccountLimit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAccountLimitError {
    /// Kind of error that occurred.
    pub kind: GetAccountLimitErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAccountLimit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAccountLimitErrorKind {
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAccountLimitError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAccountLimitErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            GetAccountLimitErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAccountLimitError {
    fn code(&self) -> Option<&str> {
        GetAccountLimitError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAccountLimitError {
    /// Creates a new `GetAccountLimitError`.
    pub fn new(kind: GetAccountLimitErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAccountLimitError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAccountLimitErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAccountLimitError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAccountLimitErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAccountLimitErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, GetAccountLimitErrorKind::InvalidInput(_))
    }
}
impl std::error::Error for GetAccountLimitError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAccountLimitErrorKind::InvalidInput(_inner) => Some(_inner),
            GetAccountLimitErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetChange` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetChangeError {
    /// Kind of error that occurred.
    pub kind: GetChangeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetChange` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetChangeErrorKind {
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>A change with the specified change ID does not exist.</p>
    NoSuchChange(crate::error::NoSuchChange),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetChangeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetChangeErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            GetChangeErrorKind::NoSuchChange(_inner) => _inner.fmt(f),
            GetChangeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetChangeError {
    fn code(&self) -> Option<&str> {
        GetChangeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetChangeError {
    /// Creates a new `GetChangeError`.
    pub fn new(kind: GetChangeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetChangeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetChangeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetChangeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetChangeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetChangeErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, GetChangeErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `GetChangeErrorKind::NoSuchChange`.
    pub fn is_no_such_change(&self) -> bool {
        matches!(&self.kind, GetChangeErrorKind::NoSuchChange(_))
    }
}
impl std::error::Error for GetChangeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetChangeErrorKind::InvalidInput(_inner) => Some(_inner),
            GetChangeErrorKind::NoSuchChange(_inner) => Some(_inner),
            GetChangeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCheckerIpRanges` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCheckerIpRangesError {
    /// Kind of error that occurred.
    pub kind: GetCheckerIpRangesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCheckerIpRanges` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCheckerIpRangesErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCheckerIpRangesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCheckerIpRangesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCheckerIpRangesError {
    fn code(&self) -> Option<&str> {
        GetCheckerIpRangesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCheckerIpRangesError {
    /// Creates a new `GetCheckerIpRangesError`.
    pub fn new(kind: GetCheckerIpRangesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCheckerIpRangesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCheckerIpRangesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCheckerIpRangesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCheckerIpRangesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for GetCheckerIpRangesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCheckerIpRangesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDNSSEC` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDNSSECError {
    /// Kind of error that occurred.
    pub kind: GetDNSSECErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDNSSEC` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDNSSECErrorKind {
    /// <p>Parameter name is not valid.</p>
    InvalidArgument(crate::error::InvalidArgument),
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>No hosted zone exists with the ID that you specified.</p>
    NoSuchHostedZone(crate::error::NoSuchHostedZone),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDNSSECError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDNSSECErrorKind::InvalidArgument(_inner) => _inner.fmt(f),
            GetDNSSECErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            GetDNSSECErrorKind::NoSuchHostedZone(_inner) => _inner.fmt(f),
            GetDNSSECErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDNSSECError {
    fn code(&self) -> Option<&str> {
        GetDNSSECError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDNSSECError {
    /// Creates a new `GetDNSSECError`.
    pub fn new(kind: GetDNSSECErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDNSSECError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDNSSECErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDNSSECError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDNSSECErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDNSSECErrorKind::InvalidArgument`.
    pub fn is_invalid_argument(&self) -> bool {
        matches!(&self.kind, GetDNSSECErrorKind::InvalidArgument(_))
    }
    /// Returns `true` if the error kind is `GetDNSSECErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, GetDNSSECErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `GetDNSSECErrorKind::NoSuchHostedZone`.
    pub fn is_no_such_hosted_zone(&self) -> bool {
        matches!(&self.kind, GetDNSSECErrorKind::NoSuchHostedZone(_))
    }
}
impl std::error::Error for GetDNSSECError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDNSSECErrorKind::InvalidArgument(_inner) => Some(_inner),
            GetDNSSECErrorKind::InvalidInput(_inner) => Some(_inner),
            GetDNSSECErrorKind::NoSuchHostedZone(_inner) => Some(_inner),
            GetDNSSECErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetGeoLocation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetGeoLocationError {
    /// Kind of error that occurred.
    pub kind: GetGeoLocationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetGeoLocation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetGeoLocationErrorKind {
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>Amazon Route 53 doesn't support the specified geographic location. For a list of supported geolocation codes, see the
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GeoLocation.html">GeoLocation</a> data type.</p>
    NoSuchGeoLocation(crate::error::NoSuchGeoLocation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetGeoLocationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetGeoLocationErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            GetGeoLocationErrorKind::NoSuchGeoLocation(_inner) => _inner.fmt(f),
            GetGeoLocationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetGeoLocationError {
    fn code(&self) -> Option<&str> {
        GetGeoLocationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetGeoLocationError {
    /// Creates a new `GetGeoLocationError`.
    pub fn new(kind: GetGeoLocationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetGeoLocationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetGeoLocationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetGeoLocationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetGeoLocationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetGeoLocationErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, GetGeoLocationErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `GetGeoLocationErrorKind::NoSuchGeoLocation`.
    pub fn is_no_such_geo_location(&self) -> bool {
        matches!(&self.kind, GetGeoLocationErrorKind::NoSuchGeoLocation(_))
    }
}
impl std::error::Error for GetGeoLocationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetGeoLocationErrorKind::InvalidInput(_inner) => Some(_inner),
            GetGeoLocationErrorKind::NoSuchGeoLocation(_inner) => Some(_inner),
            GetGeoLocationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetHealthCheck` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetHealthCheckError {
    /// Kind of error that occurred.
    pub kind: GetHealthCheckErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetHealthCheck` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetHealthCheckErrorKind {
    /// <p>The resource you're trying to access is unsupported on this Amazon Route 53 endpoint.</p>
    IncompatibleVersion(crate::error::IncompatibleVersion),
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>No health check exists with the specified ID.</p>
    NoSuchHealthCheck(crate::error::NoSuchHealthCheck),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetHealthCheckError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetHealthCheckErrorKind::IncompatibleVersion(_inner) => _inner.fmt(f),
            GetHealthCheckErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            GetHealthCheckErrorKind::NoSuchHealthCheck(_inner) => _inner.fmt(f),
            GetHealthCheckErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetHealthCheckError {
    fn code(&self) -> Option<&str> {
        GetHealthCheckError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetHealthCheckError {
    /// Creates a new `GetHealthCheckError`.
    pub fn new(kind: GetHealthCheckErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetHealthCheckError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetHealthCheckErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetHealthCheckError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetHealthCheckErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetHealthCheckErrorKind::IncompatibleVersion`.
    pub fn is_incompatible_version(&self) -> bool {
        matches!(&self.kind, GetHealthCheckErrorKind::IncompatibleVersion(_))
    }
    /// Returns `true` if the error kind is `GetHealthCheckErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, GetHealthCheckErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `GetHealthCheckErrorKind::NoSuchHealthCheck`.
    pub fn is_no_such_health_check(&self) -> bool {
        matches!(&self.kind, GetHealthCheckErrorKind::NoSuchHealthCheck(_))
    }
}
impl std::error::Error for GetHealthCheckError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetHealthCheckErrorKind::IncompatibleVersion(_inner) => Some(_inner),
            GetHealthCheckErrorKind::InvalidInput(_inner) => Some(_inner),
            GetHealthCheckErrorKind::NoSuchHealthCheck(_inner) => Some(_inner),
            GetHealthCheckErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetHealthCheckCount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetHealthCheckCountError {
    /// Kind of error that occurred.
    pub kind: GetHealthCheckCountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetHealthCheckCount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetHealthCheckCountErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetHealthCheckCountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetHealthCheckCountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetHealthCheckCountError {
    fn code(&self) -> Option<&str> {
        GetHealthCheckCountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetHealthCheckCountError {
    /// Creates a new `GetHealthCheckCountError`.
    pub fn new(kind: GetHealthCheckCountErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetHealthCheckCountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetHealthCheckCountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetHealthCheckCountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetHealthCheckCountErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for GetHealthCheckCountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetHealthCheckCountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetHealthCheckLastFailureReason` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetHealthCheckLastFailureReasonError {
    /// Kind of error that occurred.
    pub kind: GetHealthCheckLastFailureReasonErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetHealthCheckLastFailureReason` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetHealthCheckLastFailureReasonErrorKind {
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>No health check exists with the specified ID.</p>
    NoSuchHealthCheck(crate::error::NoSuchHealthCheck),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetHealthCheckLastFailureReasonError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetHealthCheckLastFailureReasonErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            GetHealthCheckLastFailureReasonErrorKind::NoSuchHealthCheck(_inner) => _inner.fmt(f),
            GetHealthCheckLastFailureReasonErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetHealthCheckLastFailureReasonError {
    fn code(&self) -> Option<&str> {
        GetHealthCheckLastFailureReasonError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetHealthCheckLastFailureReasonError {
    /// Creates a new `GetHealthCheckLastFailureReasonError`.
    pub fn new(
        kind: GetHealthCheckLastFailureReasonErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetHealthCheckLastFailureReasonError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetHealthCheckLastFailureReasonErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetHealthCheckLastFailureReasonError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetHealthCheckLastFailureReasonErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetHealthCheckLastFailureReasonErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            GetHealthCheckLastFailureReasonErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `GetHealthCheckLastFailureReasonErrorKind::NoSuchHealthCheck`.
    pub fn is_no_such_health_check(&self) -> bool {
        matches!(
            &self.kind,
            GetHealthCheckLastFailureReasonErrorKind::NoSuchHealthCheck(_)
        )
    }
}
impl std::error::Error for GetHealthCheckLastFailureReasonError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetHealthCheckLastFailureReasonErrorKind::InvalidInput(_inner) => Some(_inner),
            GetHealthCheckLastFailureReasonErrorKind::NoSuchHealthCheck(_inner) => Some(_inner),
            GetHealthCheckLastFailureReasonErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetHealthCheckStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetHealthCheckStatusError {
    /// Kind of error that occurred.
    pub kind: GetHealthCheckStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetHealthCheckStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetHealthCheckStatusErrorKind {
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>No health check exists with the specified ID.</p>
    NoSuchHealthCheck(crate::error::NoSuchHealthCheck),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetHealthCheckStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetHealthCheckStatusErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            GetHealthCheckStatusErrorKind::NoSuchHealthCheck(_inner) => _inner.fmt(f),
            GetHealthCheckStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetHealthCheckStatusError {
    fn code(&self) -> Option<&str> {
        GetHealthCheckStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetHealthCheckStatusError {
    /// Creates a new `GetHealthCheckStatusError`.
    pub fn new(kind: GetHealthCheckStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetHealthCheckStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetHealthCheckStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetHealthCheckStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetHealthCheckStatusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetHealthCheckStatusErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, GetHealthCheckStatusErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `GetHealthCheckStatusErrorKind::NoSuchHealthCheck`.
    pub fn is_no_such_health_check(&self) -> bool {
        matches!(
            &self.kind,
            GetHealthCheckStatusErrorKind::NoSuchHealthCheck(_)
        )
    }
}
impl std::error::Error for GetHealthCheckStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetHealthCheckStatusErrorKind::InvalidInput(_inner) => Some(_inner),
            GetHealthCheckStatusErrorKind::NoSuchHealthCheck(_inner) => Some(_inner),
            GetHealthCheckStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetHostedZone` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetHostedZoneError {
    /// Kind of error that occurred.
    pub kind: GetHostedZoneErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetHostedZone` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetHostedZoneErrorKind {
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>No hosted zone exists with the ID that you specified.</p>
    NoSuchHostedZone(crate::error::NoSuchHostedZone),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetHostedZoneError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetHostedZoneErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            GetHostedZoneErrorKind::NoSuchHostedZone(_inner) => _inner.fmt(f),
            GetHostedZoneErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetHostedZoneError {
    fn code(&self) -> Option<&str> {
        GetHostedZoneError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetHostedZoneError {
    /// Creates a new `GetHostedZoneError`.
    pub fn new(kind: GetHostedZoneErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetHostedZoneError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetHostedZoneErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetHostedZoneError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetHostedZoneErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetHostedZoneErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, GetHostedZoneErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `GetHostedZoneErrorKind::NoSuchHostedZone`.
    pub fn is_no_such_hosted_zone(&self) -> bool {
        matches!(&self.kind, GetHostedZoneErrorKind::NoSuchHostedZone(_))
    }
}
impl std::error::Error for GetHostedZoneError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetHostedZoneErrorKind::InvalidInput(_inner) => Some(_inner),
            GetHostedZoneErrorKind::NoSuchHostedZone(_inner) => Some(_inner),
            GetHostedZoneErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetHostedZoneCount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetHostedZoneCountError {
    /// Kind of error that occurred.
    pub kind: GetHostedZoneCountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetHostedZoneCount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetHostedZoneCountErrorKind {
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetHostedZoneCountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetHostedZoneCountErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            GetHostedZoneCountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetHostedZoneCountError {
    fn code(&self) -> Option<&str> {
        GetHostedZoneCountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetHostedZoneCountError {
    /// Creates a new `GetHostedZoneCountError`.
    pub fn new(kind: GetHostedZoneCountErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetHostedZoneCountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetHostedZoneCountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetHostedZoneCountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetHostedZoneCountErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetHostedZoneCountErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, GetHostedZoneCountErrorKind::InvalidInput(_))
    }
}
impl std::error::Error for GetHostedZoneCountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetHostedZoneCountErrorKind::InvalidInput(_inner) => Some(_inner),
            GetHostedZoneCountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetHostedZoneLimit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetHostedZoneLimitError {
    /// Kind of error that occurred.
    pub kind: GetHostedZoneLimitErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetHostedZoneLimit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetHostedZoneLimitErrorKind {
    /// <p>The specified hosted zone is a public hosted zone, not a private hosted zone.</p>
    HostedZoneNotPrivate(crate::error::HostedZoneNotPrivate),
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>No hosted zone exists with the ID that you specified.</p>
    NoSuchHostedZone(crate::error::NoSuchHostedZone),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetHostedZoneLimitError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetHostedZoneLimitErrorKind::HostedZoneNotPrivate(_inner) => _inner.fmt(f),
            GetHostedZoneLimitErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            GetHostedZoneLimitErrorKind::NoSuchHostedZone(_inner) => _inner.fmt(f),
            GetHostedZoneLimitErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetHostedZoneLimitError {
    fn code(&self) -> Option<&str> {
        GetHostedZoneLimitError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetHostedZoneLimitError {
    /// Creates a new `GetHostedZoneLimitError`.
    pub fn new(kind: GetHostedZoneLimitErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetHostedZoneLimitError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetHostedZoneLimitErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetHostedZoneLimitError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetHostedZoneLimitErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetHostedZoneLimitErrorKind::HostedZoneNotPrivate`.
    pub fn is_hosted_zone_not_private(&self) -> bool {
        matches!(
            &self.kind,
            GetHostedZoneLimitErrorKind::HostedZoneNotPrivate(_)
        )
    }
    /// Returns `true` if the error kind is `GetHostedZoneLimitErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, GetHostedZoneLimitErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `GetHostedZoneLimitErrorKind::NoSuchHostedZone`.
    pub fn is_no_such_hosted_zone(&self) -> bool {
        matches!(&self.kind, GetHostedZoneLimitErrorKind::NoSuchHostedZone(_))
    }
}
impl std::error::Error for GetHostedZoneLimitError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetHostedZoneLimitErrorKind::HostedZoneNotPrivate(_inner) => Some(_inner),
            GetHostedZoneLimitErrorKind::InvalidInput(_inner) => Some(_inner),
            GetHostedZoneLimitErrorKind::NoSuchHostedZone(_inner) => Some(_inner),
            GetHostedZoneLimitErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetQueryLoggingConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetQueryLoggingConfigError {
    /// Kind of error that occurred.
    pub kind: GetQueryLoggingConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetQueryLoggingConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetQueryLoggingConfigErrorKind {
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>There is no DNS query logging configuration with the specified ID.</p>
    NoSuchQueryLoggingConfig(crate::error::NoSuchQueryLoggingConfig),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetQueryLoggingConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetQueryLoggingConfigErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            GetQueryLoggingConfigErrorKind::NoSuchQueryLoggingConfig(_inner) => _inner.fmt(f),
            GetQueryLoggingConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetQueryLoggingConfigError {
    fn code(&self) -> Option<&str> {
        GetQueryLoggingConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetQueryLoggingConfigError {
    /// Creates a new `GetQueryLoggingConfigError`.
    pub fn new(kind: GetQueryLoggingConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetQueryLoggingConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetQueryLoggingConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetQueryLoggingConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetQueryLoggingConfigErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetQueryLoggingConfigErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, GetQueryLoggingConfigErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `GetQueryLoggingConfigErrorKind::NoSuchQueryLoggingConfig`.
    pub fn is_no_such_query_logging_config(&self) -> bool {
        matches!(
            &self.kind,
            GetQueryLoggingConfigErrorKind::NoSuchQueryLoggingConfig(_)
        )
    }
}
impl std::error::Error for GetQueryLoggingConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetQueryLoggingConfigErrorKind::InvalidInput(_inner) => Some(_inner),
            GetQueryLoggingConfigErrorKind::NoSuchQueryLoggingConfig(_inner) => Some(_inner),
            GetQueryLoggingConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetReusableDelegationSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetReusableDelegationSetError {
    /// Kind of error that occurred.
    pub kind: GetReusableDelegationSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetReusableDelegationSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetReusableDelegationSetErrorKind {
    /// <p>A reusable delegation set with the specified ID does not exist.</p>
    DelegationSetNotReusable(crate::error::DelegationSetNotReusable),
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>A reusable delegation set with the specified ID does not exist.</p>
    NoSuchDelegationSet(crate::error::NoSuchDelegationSet),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetReusableDelegationSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetReusableDelegationSetErrorKind::DelegationSetNotReusable(_inner) => _inner.fmt(f),
            GetReusableDelegationSetErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            GetReusableDelegationSetErrorKind::NoSuchDelegationSet(_inner) => _inner.fmt(f),
            GetReusableDelegationSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetReusableDelegationSetError {
    fn code(&self) -> Option<&str> {
        GetReusableDelegationSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetReusableDelegationSetError {
    /// Creates a new `GetReusableDelegationSetError`.
    pub fn new(kind: GetReusableDelegationSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetReusableDelegationSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetReusableDelegationSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetReusableDelegationSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetReusableDelegationSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetReusableDelegationSetErrorKind::DelegationSetNotReusable`.
    pub fn is_delegation_set_not_reusable(&self) -> bool {
        matches!(
            &self.kind,
            GetReusableDelegationSetErrorKind::DelegationSetNotReusable(_)
        )
    }
    /// Returns `true` if the error kind is `GetReusableDelegationSetErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            GetReusableDelegationSetErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `GetReusableDelegationSetErrorKind::NoSuchDelegationSet`.
    pub fn is_no_such_delegation_set(&self) -> bool {
        matches!(
            &self.kind,
            GetReusableDelegationSetErrorKind::NoSuchDelegationSet(_)
        )
    }
}
impl std::error::Error for GetReusableDelegationSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetReusableDelegationSetErrorKind::DelegationSetNotReusable(_inner) => Some(_inner),
            GetReusableDelegationSetErrorKind::InvalidInput(_inner) => Some(_inner),
            GetReusableDelegationSetErrorKind::NoSuchDelegationSet(_inner) => Some(_inner),
            GetReusableDelegationSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetReusableDelegationSetLimit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetReusableDelegationSetLimitError {
    /// Kind of error that occurred.
    pub kind: GetReusableDelegationSetLimitErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetReusableDelegationSetLimit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetReusableDelegationSetLimitErrorKind {
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>A reusable delegation set with the specified ID does not exist.</p>
    NoSuchDelegationSet(crate::error::NoSuchDelegationSet),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetReusableDelegationSetLimitError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetReusableDelegationSetLimitErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            GetReusableDelegationSetLimitErrorKind::NoSuchDelegationSet(_inner) => _inner.fmt(f),
            GetReusableDelegationSetLimitErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetReusableDelegationSetLimitError {
    fn code(&self) -> Option<&str> {
        GetReusableDelegationSetLimitError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetReusableDelegationSetLimitError {
    /// Creates a new `GetReusableDelegationSetLimitError`.
    pub fn new(
        kind: GetReusableDelegationSetLimitErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetReusableDelegationSetLimitError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetReusableDelegationSetLimitErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetReusableDelegationSetLimitError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetReusableDelegationSetLimitErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetReusableDelegationSetLimitErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            GetReusableDelegationSetLimitErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `GetReusableDelegationSetLimitErrorKind::NoSuchDelegationSet`.
    pub fn is_no_such_delegation_set(&self) -> bool {
        matches!(
            &self.kind,
            GetReusableDelegationSetLimitErrorKind::NoSuchDelegationSet(_)
        )
    }
}
impl std::error::Error for GetReusableDelegationSetLimitError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetReusableDelegationSetLimitErrorKind::InvalidInput(_inner) => Some(_inner),
            GetReusableDelegationSetLimitErrorKind::NoSuchDelegationSet(_inner) => Some(_inner),
            GetReusableDelegationSetLimitErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetTrafficPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetTrafficPolicyError {
    /// Kind of error that occurred.
    pub kind: GetTrafficPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetTrafficPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetTrafficPolicyErrorKind {
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>No traffic policy exists with the specified ID.</p>
    NoSuchTrafficPolicy(crate::error::NoSuchTrafficPolicy),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetTrafficPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetTrafficPolicyErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            GetTrafficPolicyErrorKind::NoSuchTrafficPolicy(_inner) => _inner.fmt(f),
            GetTrafficPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetTrafficPolicyError {
    fn code(&self) -> Option<&str> {
        GetTrafficPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetTrafficPolicyError {
    /// Creates a new `GetTrafficPolicyError`.
    pub fn new(kind: GetTrafficPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetTrafficPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetTrafficPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetTrafficPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetTrafficPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetTrafficPolicyErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, GetTrafficPolicyErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `GetTrafficPolicyErrorKind::NoSuchTrafficPolicy`.
    pub fn is_no_such_traffic_policy(&self) -> bool {
        matches!(
            &self.kind,
            GetTrafficPolicyErrorKind::NoSuchTrafficPolicy(_)
        )
    }
}
impl std::error::Error for GetTrafficPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetTrafficPolicyErrorKind::InvalidInput(_inner) => Some(_inner),
            GetTrafficPolicyErrorKind::NoSuchTrafficPolicy(_inner) => Some(_inner),
            GetTrafficPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetTrafficPolicyInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetTrafficPolicyInstanceError {
    /// Kind of error that occurred.
    pub kind: GetTrafficPolicyInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetTrafficPolicyInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetTrafficPolicyInstanceErrorKind {
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>No traffic policy instance exists with the specified ID.</p>
    NoSuchTrafficPolicyInstance(crate::error::NoSuchTrafficPolicyInstance),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetTrafficPolicyInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetTrafficPolicyInstanceErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            GetTrafficPolicyInstanceErrorKind::NoSuchTrafficPolicyInstance(_inner) => _inner.fmt(f),
            GetTrafficPolicyInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetTrafficPolicyInstanceError {
    fn code(&self) -> Option<&str> {
        GetTrafficPolicyInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetTrafficPolicyInstanceError {
    /// Creates a new `GetTrafficPolicyInstanceError`.
    pub fn new(kind: GetTrafficPolicyInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetTrafficPolicyInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetTrafficPolicyInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetTrafficPolicyInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetTrafficPolicyInstanceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetTrafficPolicyInstanceErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            GetTrafficPolicyInstanceErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `GetTrafficPolicyInstanceErrorKind::NoSuchTrafficPolicyInstance`.
    pub fn is_no_such_traffic_policy_instance(&self) -> bool {
        matches!(
            &self.kind,
            GetTrafficPolicyInstanceErrorKind::NoSuchTrafficPolicyInstance(_)
        )
    }
}
impl std::error::Error for GetTrafficPolicyInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetTrafficPolicyInstanceErrorKind::InvalidInput(_inner) => Some(_inner),
            GetTrafficPolicyInstanceErrorKind::NoSuchTrafficPolicyInstance(_inner) => Some(_inner),
            GetTrafficPolicyInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetTrafficPolicyInstanceCount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetTrafficPolicyInstanceCountError {
    /// Kind of error that occurred.
    pub kind: GetTrafficPolicyInstanceCountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetTrafficPolicyInstanceCount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetTrafficPolicyInstanceCountErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetTrafficPolicyInstanceCountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetTrafficPolicyInstanceCountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetTrafficPolicyInstanceCountError {
    fn code(&self) -> Option<&str> {
        GetTrafficPolicyInstanceCountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetTrafficPolicyInstanceCountError {
    /// Creates a new `GetTrafficPolicyInstanceCountError`.
    pub fn new(
        kind: GetTrafficPolicyInstanceCountErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetTrafficPolicyInstanceCountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetTrafficPolicyInstanceCountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetTrafficPolicyInstanceCountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetTrafficPolicyInstanceCountErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for GetTrafficPolicyInstanceCountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetTrafficPolicyInstanceCountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListGeoLocations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListGeoLocationsError {
    /// Kind of error that occurred.
    pub kind: ListGeoLocationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListGeoLocations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListGeoLocationsErrorKind {
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListGeoLocationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListGeoLocationsErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            ListGeoLocationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListGeoLocationsError {
    fn code(&self) -> Option<&str> {
        ListGeoLocationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListGeoLocationsError {
    /// Creates a new `ListGeoLocationsError`.
    pub fn new(kind: ListGeoLocationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListGeoLocationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListGeoLocationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListGeoLocationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListGeoLocationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListGeoLocationsErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, ListGeoLocationsErrorKind::InvalidInput(_))
    }
}
impl std::error::Error for ListGeoLocationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListGeoLocationsErrorKind::InvalidInput(_inner) => Some(_inner),
            ListGeoLocationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListHealthChecks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListHealthChecksError {
    /// Kind of error that occurred.
    pub kind: ListHealthChecksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListHealthChecks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListHealthChecksErrorKind {
    /// <p>The resource you're trying to access is unsupported on this Amazon Route 53 endpoint.</p>
    IncompatibleVersion(crate::error::IncompatibleVersion),
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListHealthChecksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListHealthChecksErrorKind::IncompatibleVersion(_inner) => _inner.fmt(f),
            ListHealthChecksErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            ListHealthChecksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListHealthChecksError {
    fn code(&self) -> Option<&str> {
        ListHealthChecksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListHealthChecksError {
    /// Creates a new `ListHealthChecksError`.
    pub fn new(kind: ListHealthChecksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListHealthChecksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListHealthChecksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListHealthChecksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListHealthChecksErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListHealthChecksErrorKind::IncompatibleVersion`.
    pub fn is_incompatible_version(&self) -> bool {
        matches!(
            &self.kind,
            ListHealthChecksErrorKind::IncompatibleVersion(_)
        )
    }
    /// Returns `true` if the error kind is `ListHealthChecksErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, ListHealthChecksErrorKind::InvalidInput(_))
    }
}
impl std::error::Error for ListHealthChecksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListHealthChecksErrorKind::IncompatibleVersion(_inner) => Some(_inner),
            ListHealthChecksErrorKind::InvalidInput(_inner) => Some(_inner),
            ListHealthChecksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListHostedZones` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListHostedZonesError {
    /// Kind of error that occurred.
    pub kind: ListHostedZonesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListHostedZones` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListHostedZonesErrorKind {
    /// <p>A reusable delegation set with the specified ID does not exist.</p>
    DelegationSetNotReusable(crate::error::DelegationSetNotReusable),
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>A reusable delegation set with the specified ID does not exist.</p>
    NoSuchDelegationSet(crate::error::NoSuchDelegationSet),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListHostedZonesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListHostedZonesErrorKind::DelegationSetNotReusable(_inner) => _inner.fmt(f),
            ListHostedZonesErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            ListHostedZonesErrorKind::NoSuchDelegationSet(_inner) => _inner.fmt(f),
            ListHostedZonesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListHostedZonesError {
    fn code(&self) -> Option<&str> {
        ListHostedZonesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListHostedZonesError {
    /// Creates a new `ListHostedZonesError`.
    pub fn new(kind: ListHostedZonesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListHostedZonesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListHostedZonesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListHostedZonesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListHostedZonesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListHostedZonesErrorKind::DelegationSetNotReusable`.
    pub fn is_delegation_set_not_reusable(&self) -> bool {
        matches!(
            &self.kind,
            ListHostedZonesErrorKind::DelegationSetNotReusable(_)
        )
    }
    /// Returns `true` if the error kind is `ListHostedZonesErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, ListHostedZonesErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `ListHostedZonesErrorKind::NoSuchDelegationSet`.
    pub fn is_no_such_delegation_set(&self) -> bool {
        matches!(&self.kind, ListHostedZonesErrorKind::NoSuchDelegationSet(_))
    }
}
impl std::error::Error for ListHostedZonesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListHostedZonesErrorKind::DelegationSetNotReusable(_inner) => Some(_inner),
            ListHostedZonesErrorKind::InvalidInput(_inner) => Some(_inner),
            ListHostedZonesErrorKind::NoSuchDelegationSet(_inner) => Some(_inner),
            ListHostedZonesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListHostedZonesByName` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListHostedZonesByNameError {
    /// Kind of error that occurred.
    pub kind: ListHostedZonesByNameErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListHostedZonesByName` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListHostedZonesByNameErrorKind {
    /// <p>The specified domain name is not valid.</p>
    InvalidDomainName(crate::error::InvalidDomainName),
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListHostedZonesByNameError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListHostedZonesByNameErrorKind::InvalidDomainName(_inner) => _inner.fmt(f),
            ListHostedZonesByNameErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            ListHostedZonesByNameErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListHostedZonesByNameError {
    fn code(&self) -> Option<&str> {
        ListHostedZonesByNameError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListHostedZonesByNameError {
    /// Creates a new `ListHostedZonesByNameError`.
    pub fn new(kind: ListHostedZonesByNameErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListHostedZonesByNameError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListHostedZonesByNameErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListHostedZonesByNameError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListHostedZonesByNameErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListHostedZonesByNameErrorKind::InvalidDomainName`.
    pub fn is_invalid_domain_name(&self) -> bool {
        matches!(
            &self.kind,
            ListHostedZonesByNameErrorKind::InvalidDomainName(_)
        )
    }
    /// Returns `true` if the error kind is `ListHostedZonesByNameErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, ListHostedZonesByNameErrorKind::InvalidInput(_))
    }
}
impl std::error::Error for ListHostedZonesByNameError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListHostedZonesByNameErrorKind::InvalidDomainName(_inner) => Some(_inner),
            ListHostedZonesByNameErrorKind::InvalidInput(_inner) => Some(_inner),
            ListHostedZonesByNameErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListHostedZonesByVPC` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListHostedZonesByVPCError {
    /// Kind of error that occurred.
    pub kind: ListHostedZonesByVPCErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListHostedZonesByVPC` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListHostedZonesByVPCErrorKind {
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The value that you specified to get the second or subsequent page of results is invalid.</p>
    InvalidPaginationToken(crate::error::InvalidPaginationToken),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListHostedZonesByVPCError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListHostedZonesByVPCErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            ListHostedZonesByVPCErrorKind::InvalidPaginationToken(_inner) => _inner.fmt(f),
            ListHostedZonesByVPCErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListHostedZonesByVPCError {
    fn code(&self) -> Option<&str> {
        ListHostedZonesByVPCError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListHostedZonesByVPCError {
    /// Creates a new `ListHostedZonesByVPCError`.
    pub fn new(kind: ListHostedZonesByVPCErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListHostedZonesByVPCError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListHostedZonesByVPCErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListHostedZonesByVPCError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListHostedZonesByVPCErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListHostedZonesByVPCErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, ListHostedZonesByVPCErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `ListHostedZonesByVPCErrorKind::InvalidPaginationToken`.
    pub fn is_invalid_pagination_token(&self) -> bool {
        matches!(
            &self.kind,
            ListHostedZonesByVPCErrorKind::InvalidPaginationToken(_)
        )
    }
}
impl std::error::Error for ListHostedZonesByVPCError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListHostedZonesByVPCErrorKind::InvalidInput(_inner) => Some(_inner),
            ListHostedZonesByVPCErrorKind::InvalidPaginationToken(_inner) => Some(_inner),
            ListHostedZonesByVPCErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListQueryLoggingConfigs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListQueryLoggingConfigsError {
    /// Kind of error that occurred.
    pub kind: ListQueryLoggingConfigsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListQueryLoggingConfigs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListQueryLoggingConfigsErrorKind {
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The value that you specified to get the second or subsequent page of results is invalid.</p>
    InvalidPaginationToken(crate::error::InvalidPaginationToken),
    /// <p>No hosted zone exists with the ID that you specified.</p>
    NoSuchHostedZone(crate::error::NoSuchHostedZone),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListQueryLoggingConfigsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListQueryLoggingConfigsErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            ListQueryLoggingConfigsErrorKind::InvalidPaginationToken(_inner) => _inner.fmt(f),
            ListQueryLoggingConfigsErrorKind::NoSuchHostedZone(_inner) => _inner.fmt(f),
            ListQueryLoggingConfigsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListQueryLoggingConfigsError {
    fn code(&self) -> Option<&str> {
        ListQueryLoggingConfigsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListQueryLoggingConfigsError {
    /// Creates a new `ListQueryLoggingConfigsError`.
    pub fn new(kind: ListQueryLoggingConfigsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListQueryLoggingConfigsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListQueryLoggingConfigsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListQueryLoggingConfigsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListQueryLoggingConfigsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListQueryLoggingConfigsErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            ListQueryLoggingConfigsErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `ListQueryLoggingConfigsErrorKind::InvalidPaginationToken`.
    pub fn is_invalid_pagination_token(&self) -> bool {
        matches!(
            &self.kind,
            ListQueryLoggingConfigsErrorKind::InvalidPaginationToken(_)
        )
    }
    /// Returns `true` if the error kind is `ListQueryLoggingConfigsErrorKind::NoSuchHostedZone`.
    pub fn is_no_such_hosted_zone(&self) -> bool {
        matches!(
            &self.kind,
            ListQueryLoggingConfigsErrorKind::NoSuchHostedZone(_)
        )
    }
}
impl std::error::Error for ListQueryLoggingConfigsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListQueryLoggingConfigsErrorKind::InvalidInput(_inner) => Some(_inner),
            ListQueryLoggingConfigsErrorKind::InvalidPaginationToken(_inner) => Some(_inner),
            ListQueryLoggingConfigsErrorKind::NoSuchHostedZone(_inner) => Some(_inner),
            ListQueryLoggingConfigsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListResourceRecordSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListResourceRecordSetsError {
    /// Kind of error that occurred.
    pub kind: ListResourceRecordSetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListResourceRecordSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListResourceRecordSetsErrorKind {
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>No hosted zone exists with the ID that you specified.</p>
    NoSuchHostedZone(crate::error::NoSuchHostedZone),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListResourceRecordSetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListResourceRecordSetsErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            ListResourceRecordSetsErrorKind::NoSuchHostedZone(_inner) => _inner.fmt(f),
            ListResourceRecordSetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListResourceRecordSetsError {
    fn code(&self) -> Option<&str> {
        ListResourceRecordSetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListResourceRecordSetsError {
    /// Creates a new `ListResourceRecordSetsError`.
    pub fn new(kind: ListResourceRecordSetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListResourceRecordSetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListResourceRecordSetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListResourceRecordSetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListResourceRecordSetsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListResourceRecordSetsErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, ListResourceRecordSetsErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `ListResourceRecordSetsErrorKind::NoSuchHostedZone`.
    pub fn is_no_such_hosted_zone(&self) -> bool {
        matches!(
            &self.kind,
            ListResourceRecordSetsErrorKind::NoSuchHostedZone(_)
        )
    }
}
impl std::error::Error for ListResourceRecordSetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListResourceRecordSetsErrorKind::InvalidInput(_inner) => Some(_inner),
            ListResourceRecordSetsErrorKind::NoSuchHostedZone(_inner) => Some(_inner),
            ListResourceRecordSetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListReusableDelegationSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListReusableDelegationSetsError {
    /// Kind of error that occurred.
    pub kind: ListReusableDelegationSetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListReusableDelegationSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListReusableDelegationSetsErrorKind {
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListReusableDelegationSetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListReusableDelegationSetsErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            ListReusableDelegationSetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListReusableDelegationSetsError {
    fn code(&self) -> Option<&str> {
        ListReusableDelegationSetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListReusableDelegationSetsError {
    /// Creates a new `ListReusableDelegationSetsError`.
    pub fn new(kind: ListReusableDelegationSetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListReusableDelegationSetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListReusableDelegationSetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListReusableDelegationSetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListReusableDelegationSetsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListReusableDelegationSetsErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            ListReusableDelegationSetsErrorKind::InvalidInput(_)
        )
    }
}
impl std::error::Error for ListReusableDelegationSetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListReusableDelegationSetsErrorKind::InvalidInput(_inner) => Some(_inner),
            ListReusableDelegationSetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>No health check exists with the specified ID.</p>
    NoSuchHealthCheck(crate::error::NoSuchHealthCheck),
    /// <p>No hosted zone exists with the ID that you specified.</p>
    NoSuchHostedZone(crate::error::NoSuchHostedZone),
    /// <p>If Amazon Route 53 can't process a request before the next request arrives, it will reject
    /// subsequent requests for the same hosted zone and return an <code>HTTP 400 error</code>
    /// (<code>Bad request</code>). If Route 53 returns this error repeatedly for the same request, we
    /// recommend that you wait, in intervals of increasing duration, before you try the request
    /// again.</p>
    PriorRequestNotComplete(crate::error::PriorRequestNotComplete),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::NoSuchHealthCheck(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::NoSuchHostedZone(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::PriorRequestNotComplete(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, ListTagsForResourceErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::NoSuchHealthCheck`.
    pub fn is_no_such_health_check(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::NoSuchHealthCheck(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::NoSuchHostedZone`.
    pub fn is_no_such_hosted_zone(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::NoSuchHostedZone(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::PriorRequestNotComplete`.
    pub fn is_prior_request_not_complete(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::PriorRequestNotComplete(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InvalidInput(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::NoSuchHealthCheck(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::NoSuchHostedZone(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::PriorRequestNotComplete(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourcesError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourcesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourcesErrorKind {
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>No health check exists with the specified ID.</p>
    NoSuchHealthCheck(crate::error::NoSuchHealthCheck),
    /// <p>No hosted zone exists with the ID that you specified.</p>
    NoSuchHostedZone(crate::error::NoSuchHostedZone),
    /// <p>If Amazon Route 53 can't process a request before the next request arrives, it will reject
    /// subsequent requests for the same hosted zone and return an <code>HTTP 400 error</code>
    /// (<code>Bad request</code>). If Route 53 returns this error repeatedly for the same request, we
    /// recommend that you wait, in intervals of increasing duration, before you try the request
    /// again.</p>
    PriorRequestNotComplete(crate::error::PriorRequestNotComplete),
    /// <p>The limit on the number of requests per second was exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourcesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourcesErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            ListTagsForResourcesErrorKind::NoSuchHealthCheck(_inner) => _inner.fmt(f),
            ListTagsForResourcesErrorKind::NoSuchHostedZone(_inner) => _inner.fmt(f),
            ListTagsForResourcesErrorKind::PriorRequestNotComplete(_inner) => _inner.fmt(f),
            ListTagsForResourcesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListTagsForResourcesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourcesError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourcesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourcesError {
    /// Creates a new `ListTagsForResourcesError`.
    pub fn new(kind: ListTagsForResourcesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourcesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourcesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourcesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourcesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourcesErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, ListTagsForResourcesErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `ListTagsForResourcesErrorKind::NoSuchHealthCheck`.
    pub fn is_no_such_health_check(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourcesErrorKind::NoSuchHealthCheck(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourcesErrorKind::NoSuchHostedZone`.
    pub fn is_no_such_hosted_zone(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourcesErrorKind::NoSuchHostedZone(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourcesErrorKind::PriorRequestNotComplete`.
    pub fn is_prior_request_not_complete(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourcesErrorKind::PriorRequestNotComplete(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourcesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourcesErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourcesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourcesErrorKind::InvalidInput(_inner) => Some(_inner),
            ListTagsForResourcesErrorKind::NoSuchHealthCheck(_inner) => Some(_inner),
            ListTagsForResourcesErrorKind::NoSuchHostedZone(_inner) => Some(_inner),
            ListTagsForResourcesErrorKind::PriorRequestNotComplete(_inner) => Some(_inner),
            ListTagsForResourcesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListTagsForResourcesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTrafficPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTrafficPoliciesError {
    /// Kind of error that occurred.
    pub kind: ListTrafficPoliciesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTrafficPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTrafficPoliciesErrorKind {
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTrafficPoliciesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTrafficPoliciesErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            ListTrafficPoliciesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTrafficPoliciesError {
    fn code(&self) -> Option<&str> {
        ListTrafficPoliciesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTrafficPoliciesError {
    /// Creates a new `ListTrafficPoliciesError`.
    pub fn new(kind: ListTrafficPoliciesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTrafficPoliciesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTrafficPoliciesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTrafficPoliciesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTrafficPoliciesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTrafficPoliciesErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, ListTrafficPoliciesErrorKind::InvalidInput(_))
    }
}
impl std::error::Error for ListTrafficPoliciesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTrafficPoliciesErrorKind::InvalidInput(_inner) => Some(_inner),
            ListTrafficPoliciesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTrafficPolicyInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTrafficPolicyInstancesError {
    /// Kind of error that occurred.
    pub kind: ListTrafficPolicyInstancesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTrafficPolicyInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTrafficPolicyInstancesErrorKind {
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>No traffic policy instance exists with the specified ID.</p>
    NoSuchTrafficPolicyInstance(crate::error::NoSuchTrafficPolicyInstance),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTrafficPolicyInstancesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTrafficPolicyInstancesErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            ListTrafficPolicyInstancesErrorKind::NoSuchTrafficPolicyInstance(_inner) => {
                _inner.fmt(f)
            }
            ListTrafficPolicyInstancesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTrafficPolicyInstancesError {
    fn code(&self) -> Option<&str> {
        ListTrafficPolicyInstancesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTrafficPolicyInstancesError {
    /// Creates a new `ListTrafficPolicyInstancesError`.
    pub fn new(kind: ListTrafficPolicyInstancesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTrafficPolicyInstancesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTrafficPolicyInstancesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTrafficPolicyInstancesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTrafficPolicyInstancesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTrafficPolicyInstancesErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            ListTrafficPolicyInstancesErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `ListTrafficPolicyInstancesErrorKind::NoSuchTrafficPolicyInstance`.
    pub fn is_no_such_traffic_policy_instance(&self) -> bool {
        matches!(
            &self.kind,
            ListTrafficPolicyInstancesErrorKind::NoSuchTrafficPolicyInstance(_)
        )
    }
}
impl std::error::Error for ListTrafficPolicyInstancesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTrafficPolicyInstancesErrorKind::InvalidInput(_inner) => Some(_inner),
            ListTrafficPolicyInstancesErrorKind::NoSuchTrafficPolicyInstance(_inner) => {
                Some(_inner)
            }
            ListTrafficPolicyInstancesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTrafficPolicyInstancesByHostedZone` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTrafficPolicyInstancesByHostedZoneError {
    /// Kind of error that occurred.
    pub kind: ListTrafficPolicyInstancesByHostedZoneErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTrafficPolicyInstancesByHostedZone` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTrafficPolicyInstancesByHostedZoneErrorKind {
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>No hosted zone exists with the ID that you specified.</p>
    NoSuchHostedZone(crate::error::NoSuchHostedZone),
    /// <p>No traffic policy instance exists with the specified ID.</p>
    NoSuchTrafficPolicyInstance(crate::error::NoSuchTrafficPolicyInstance),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTrafficPolicyInstancesByHostedZoneError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTrafficPolicyInstancesByHostedZoneErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            ListTrafficPolicyInstancesByHostedZoneErrorKind::NoSuchHostedZone(_inner) => {
                _inner.fmt(f)
            }
            ListTrafficPolicyInstancesByHostedZoneErrorKind::NoSuchTrafficPolicyInstance(
                _inner,
            ) => _inner.fmt(f),
            ListTrafficPolicyInstancesByHostedZoneErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTrafficPolicyInstancesByHostedZoneError {
    fn code(&self) -> Option<&str> {
        ListTrafficPolicyInstancesByHostedZoneError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTrafficPolicyInstancesByHostedZoneError {
    /// Creates a new `ListTrafficPolicyInstancesByHostedZoneError`.
    pub fn new(
        kind: ListTrafficPolicyInstancesByHostedZoneErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTrafficPolicyInstancesByHostedZoneError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTrafficPolicyInstancesByHostedZoneErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTrafficPolicyInstancesByHostedZoneError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTrafficPolicyInstancesByHostedZoneErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTrafficPolicyInstancesByHostedZoneErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            ListTrafficPolicyInstancesByHostedZoneErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `ListTrafficPolicyInstancesByHostedZoneErrorKind::NoSuchHostedZone`.
    pub fn is_no_such_hosted_zone(&self) -> bool {
        matches!(
            &self.kind,
            ListTrafficPolicyInstancesByHostedZoneErrorKind::NoSuchHostedZone(_)
        )
    }
    /// Returns `true` if the error kind is `ListTrafficPolicyInstancesByHostedZoneErrorKind::NoSuchTrafficPolicyInstance`.
    pub fn is_no_such_traffic_policy_instance(&self) -> bool {
        matches!(
            &self.kind,
            ListTrafficPolicyInstancesByHostedZoneErrorKind::NoSuchTrafficPolicyInstance(_)
        )
    }
}
impl std::error::Error for ListTrafficPolicyInstancesByHostedZoneError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTrafficPolicyInstancesByHostedZoneErrorKind::InvalidInput(_inner) => Some(_inner),
            ListTrafficPolicyInstancesByHostedZoneErrorKind::NoSuchHostedZone(_inner) => {
                Some(_inner)
            }
            ListTrafficPolicyInstancesByHostedZoneErrorKind::NoSuchTrafficPolicyInstance(
                _inner,
            ) => Some(_inner),
            ListTrafficPolicyInstancesByHostedZoneErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListTrafficPolicyInstancesByPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTrafficPolicyInstancesByPolicyError {
    /// Kind of error that occurred.
    pub kind: ListTrafficPolicyInstancesByPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTrafficPolicyInstancesByPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTrafficPolicyInstancesByPolicyErrorKind {
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>No traffic policy exists with the specified ID.</p>
    NoSuchTrafficPolicy(crate::error::NoSuchTrafficPolicy),
    /// <p>No traffic policy instance exists with the specified ID.</p>
    NoSuchTrafficPolicyInstance(crate::error::NoSuchTrafficPolicyInstance),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTrafficPolicyInstancesByPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTrafficPolicyInstancesByPolicyErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            ListTrafficPolicyInstancesByPolicyErrorKind::NoSuchTrafficPolicy(_inner) => {
                _inner.fmt(f)
            }
            ListTrafficPolicyInstancesByPolicyErrorKind::NoSuchTrafficPolicyInstance(_inner) => {
                _inner.fmt(f)
            }
            ListTrafficPolicyInstancesByPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTrafficPolicyInstancesByPolicyError {
    fn code(&self) -> Option<&str> {
        ListTrafficPolicyInstancesByPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTrafficPolicyInstancesByPolicyError {
    /// Creates a new `ListTrafficPolicyInstancesByPolicyError`.
    pub fn new(
        kind: ListTrafficPolicyInstancesByPolicyErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTrafficPolicyInstancesByPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTrafficPolicyInstancesByPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTrafficPolicyInstancesByPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTrafficPolicyInstancesByPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTrafficPolicyInstancesByPolicyErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            ListTrafficPolicyInstancesByPolicyErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `ListTrafficPolicyInstancesByPolicyErrorKind::NoSuchTrafficPolicy`.
    pub fn is_no_such_traffic_policy(&self) -> bool {
        matches!(
            &self.kind,
            ListTrafficPolicyInstancesByPolicyErrorKind::NoSuchTrafficPolicy(_)
        )
    }
    /// Returns `true` if the error kind is `ListTrafficPolicyInstancesByPolicyErrorKind::NoSuchTrafficPolicyInstance`.
    pub fn is_no_such_traffic_policy_instance(&self) -> bool {
        matches!(
            &self.kind,
            ListTrafficPolicyInstancesByPolicyErrorKind::NoSuchTrafficPolicyInstance(_)
        )
    }
}
impl std::error::Error for ListTrafficPolicyInstancesByPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTrafficPolicyInstancesByPolicyErrorKind::InvalidInput(_inner) => Some(_inner),
            ListTrafficPolicyInstancesByPolicyErrorKind::NoSuchTrafficPolicy(_inner) => {
                Some(_inner)
            }
            ListTrafficPolicyInstancesByPolicyErrorKind::NoSuchTrafficPolicyInstance(_inner) => {
                Some(_inner)
            }
            ListTrafficPolicyInstancesByPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTrafficPolicyVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTrafficPolicyVersionsError {
    /// Kind of error that occurred.
    pub kind: ListTrafficPolicyVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTrafficPolicyVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTrafficPolicyVersionsErrorKind {
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>No traffic policy exists with the specified ID.</p>
    NoSuchTrafficPolicy(crate::error::NoSuchTrafficPolicy),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTrafficPolicyVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTrafficPolicyVersionsErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            ListTrafficPolicyVersionsErrorKind::NoSuchTrafficPolicy(_inner) => _inner.fmt(f),
            ListTrafficPolicyVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTrafficPolicyVersionsError {
    fn code(&self) -> Option<&str> {
        ListTrafficPolicyVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTrafficPolicyVersionsError {
    /// Creates a new `ListTrafficPolicyVersionsError`.
    pub fn new(kind: ListTrafficPolicyVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTrafficPolicyVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTrafficPolicyVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTrafficPolicyVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTrafficPolicyVersionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTrafficPolicyVersionsErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            ListTrafficPolicyVersionsErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `ListTrafficPolicyVersionsErrorKind::NoSuchTrafficPolicy`.
    pub fn is_no_such_traffic_policy(&self) -> bool {
        matches!(
            &self.kind,
            ListTrafficPolicyVersionsErrorKind::NoSuchTrafficPolicy(_)
        )
    }
}
impl std::error::Error for ListTrafficPolicyVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTrafficPolicyVersionsErrorKind::InvalidInput(_inner) => Some(_inner),
            ListTrafficPolicyVersionsErrorKind::NoSuchTrafficPolicy(_inner) => Some(_inner),
            ListTrafficPolicyVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListVPCAssociationAuthorizations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListVPCAssociationAuthorizationsError {
    /// Kind of error that occurred.
    pub kind: ListVPCAssociationAuthorizationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListVPCAssociationAuthorizations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListVPCAssociationAuthorizationsErrorKind {
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>The value that you specified to get the second or subsequent page of results is invalid.</p>
    InvalidPaginationToken(crate::error::InvalidPaginationToken),
    /// <p>No hosted zone exists with the ID that you specified.</p>
    NoSuchHostedZone(crate::error::NoSuchHostedZone),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListVPCAssociationAuthorizationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListVPCAssociationAuthorizationsErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            ListVPCAssociationAuthorizationsErrorKind::InvalidPaginationToken(_inner) => {
                _inner.fmt(f)
            }
            ListVPCAssociationAuthorizationsErrorKind::NoSuchHostedZone(_inner) => _inner.fmt(f),
            ListVPCAssociationAuthorizationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListVPCAssociationAuthorizationsError {
    fn code(&self) -> Option<&str> {
        ListVPCAssociationAuthorizationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListVPCAssociationAuthorizationsError {
    /// Creates a new `ListVPCAssociationAuthorizationsError`.
    pub fn new(
        kind: ListVPCAssociationAuthorizationsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListVPCAssociationAuthorizationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListVPCAssociationAuthorizationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListVPCAssociationAuthorizationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListVPCAssociationAuthorizationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListVPCAssociationAuthorizationsErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            ListVPCAssociationAuthorizationsErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `ListVPCAssociationAuthorizationsErrorKind::InvalidPaginationToken`.
    pub fn is_invalid_pagination_token(&self) -> bool {
        matches!(
            &self.kind,
            ListVPCAssociationAuthorizationsErrorKind::InvalidPaginationToken(_)
        )
    }
    /// Returns `true` if the error kind is `ListVPCAssociationAuthorizationsErrorKind::NoSuchHostedZone`.
    pub fn is_no_such_hosted_zone(&self) -> bool {
        matches!(
            &self.kind,
            ListVPCAssociationAuthorizationsErrorKind::NoSuchHostedZone(_)
        )
    }
}
impl std::error::Error for ListVPCAssociationAuthorizationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListVPCAssociationAuthorizationsErrorKind::InvalidInput(_inner) => Some(_inner),
            ListVPCAssociationAuthorizationsErrorKind::InvalidPaginationToken(_inner) => {
                Some(_inner)
            }
            ListVPCAssociationAuthorizationsErrorKind::NoSuchHostedZone(_inner) => Some(_inner),
            ListVPCAssociationAuthorizationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TestDNSAnswer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TestDNSAnswerError {
    /// Kind of error that occurred.
    pub kind: TestDNSAnswerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TestDNSAnswer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TestDNSAnswerErrorKind {
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>No hosted zone exists with the ID that you specified.</p>
    NoSuchHostedZone(crate::error::NoSuchHostedZone),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TestDNSAnswerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TestDNSAnswerErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            TestDNSAnswerErrorKind::NoSuchHostedZone(_inner) => _inner.fmt(f),
            TestDNSAnswerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TestDNSAnswerError {
    fn code(&self) -> Option<&str> {
        TestDNSAnswerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TestDNSAnswerError {
    /// Creates a new `TestDNSAnswerError`.
    pub fn new(kind: TestDNSAnswerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TestDNSAnswerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TestDNSAnswerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TestDNSAnswerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TestDNSAnswerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TestDNSAnswerErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, TestDNSAnswerErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `TestDNSAnswerErrorKind::NoSuchHostedZone`.
    pub fn is_no_such_hosted_zone(&self) -> bool {
        matches!(&self.kind, TestDNSAnswerErrorKind::NoSuchHostedZone(_))
    }
}
impl std::error::Error for TestDNSAnswerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TestDNSAnswerErrorKind::InvalidInput(_inner) => Some(_inner),
            TestDNSAnswerErrorKind::NoSuchHostedZone(_inner) => Some(_inner),
            TestDNSAnswerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateHealthCheck` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateHealthCheckError {
    /// Kind of error that occurred.
    pub kind: UpdateHealthCheckErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateHealthCheck` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateHealthCheckErrorKind {
    /// <p>The value of <code>HealthCheckVersion</code> in the request doesn't match the value of <code>HealthCheckVersion</code>
    /// in the health check.</p>
    HealthCheckVersionMismatch(crate::error::HealthCheckVersionMismatch),
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>No health check exists with the specified ID.</p>
    NoSuchHealthCheck(crate::error::NoSuchHealthCheck),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateHealthCheckError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateHealthCheckErrorKind::HealthCheckVersionMismatch(_inner) => _inner.fmt(f),
            UpdateHealthCheckErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            UpdateHealthCheckErrorKind::NoSuchHealthCheck(_inner) => _inner.fmt(f),
            UpdateHealthCheckErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateHealthCheckError {
    fn code(&self) -> Option<&str> {
        UpdateHealthCheckError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateHealthCheckError {
    /// Creates a new `UpdateHealthCheckError`.
    pub fn new(kind: UpdateHealthCheckErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateHealthCheckError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateHealthCheckErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateHealthCheckError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateHealthCheckErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateHealthCheckErrorKind::HealthCheckVersionMismatch`.
    pub fn is_health_check_version_mismatch(&self) -> bool {
        matches!(
            &self.kind,
            UpdateHealthCheckErrorKind::HealthCheckVersionMismatch(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateHealthCheckErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(&self.kind, UpdateHealthCheckErrorKind::InvalidInput(_))
    }
    /// Returns `true` if the error kind is `UpdateHealthCheckErrorKind::NoSuchHealthCheck`.
    pub fn is_no_such_health_check(&self) -> bool {
        matches!(&self.kind, UpdateHealthCheckErrorKind::NoSuchHealthCheck(_))
    }
}
impl std::error::Error for UpdateHealthCheckError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateHealthCheckErrorKind::HealthCheckVersionMismatch(_inner) => Some(_inner),
            UpdateHealthCheckErrorKind::InvalidInput(_inner) => Some(_inner),
            UpdateHealthCheckErrorKind::NoSuchHealthCheck(_inner) => Some(_inner),
            UpdateHealthCheckErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateHostedZoneComment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateHostedZoneCommentError {
    /// Kind of error that occurred.
    pub kind: UpdateHostedZoneCommentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateHostedZoneComment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateHostedZoneCommentErrorKind {
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>No hosted zone exists with the ID that you specified.</p>
    NoSuchHostedZone(crate::error::NoSuchHostedZone),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateHostedZoneCommentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateHostedZoneCommentErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            UpdateHostedZoneCommentErrorKind::NoSuchHostedZone(_inner) => _inner.fmt(f),
            UpdateHostedZoneCommentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateHostedZoneCommentError {
    fn code(&self) -> Option<&str> {
        UpdateHostedZoneCommentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateHostedZoneCommentError {
    /// Creates a new `UpdateHostedZoneCommentError`.
    pub fn new(kind: UpdateHostedZoneCommentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateHostedZoneCommentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateHostedZoneCommentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateHostedZoneCommentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateHostedZoneCommentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateHostedZoneCommentErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            UpdateHostedZoneCommentErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateHostedZoneCommentErrorKind::NoSuchHostedZone`.
    pub fn is_no_such_hosted_zone(&self) -> bool {
        matches!(
            &self.kind,
            UpdateHostedZoneCommentErrorKind::NoSuchHostedZone(_)
        )
    }
}
impl std::error::Error for UpdateHostedZoneCommentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateHostedZoneCommentErrorKind::InvalidInput(_inner) => Some(_inner),
            UpdateHostedZoneCommentErrorKind::NoSuchHostedZone(_inner) => Some(_inner),
            UpdateHostedZoneCommentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateTrafficPolicyComment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateTrafficPolicyCommentError {
    /// Kind of error that occurred.
    pub kind: UpdateTrafficPolicyCommentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateTrafficPolicyComment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateTrafficPolicyCommentErrorKind {
    /// <p>Another user submitted a request to create, update, or delete the object at the same time that you did. Retry the request. </p>
    ConcurrentModification(crate::error::ConcurrentModification),
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>No traffic policy exists with the specified ID.</p>
    NoSuchTrafficPolicy(crate::error::NoSuchTrafficPolicy),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateTrafficPolicyCommentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateTrafficPolicyCommentErrorKind::ConcurrentModification(_inner) => _inner.fmt(f),
            UpdateTrafficPolicyCommentErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            UpdateTrafficPolicyCommentErrorKind::NoSuchTrafficPolicy(_inner) => _inner.fmt(f),
            UpdateTrafficPolicyCommentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateTrafficPolicyCommentError {
    fn code(&self) -> Option<&str> {
        UpdateTrafficPolicyCommentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateTrafficPolicyCommentError {
    /// Creates a new `UpdateTrafficPolicyCommentError`.
    pub fn new(kind: UpdateTrafficPolicyCommentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateTrafficPolicyCommentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateTrafficPolicyCommentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateTrafficPolicyCommentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateTrafficPolicyCommentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateTrafficPolicyCommentErrorKind::ConcurrentModification`.
    pub fn is_concurrent_modification(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTrafficPolicyCommentErrorKind::ConcurrentModification(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTrafficPolicyCommentErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTrafficPolicyCommentErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTrafficPolicyCommentErrorKind::NoSuchTrafficPolicy`.
    pub fn is_no_such_traffic_policy(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTrafficPolicyCommentErrorKind::NoSuchTrafficPolicy(_)
        )
    }
}
impl std::error::Error for UpdateTrafficPolicyCommentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateTrafficPolicyCommentErrorKind::ConcurrentModification(_inner) => Some(_inner),
            UpdateTrafficPolicyCommentErrorKind::InvalidInput(_inner) => Some(_inner),
            UpdateTrafficPolicyCommentErrorKind::NoSuchTrafficPolicy(_inner) => Some(_inner),
            UpdateTrafficPolicyCommentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateTrafficPolicyInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateTrafficPolicyInstanceError {
    /// Kind of error that occurred.
    pub kind: UpdateTrafficPolicyInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateTrafficPolicyInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateTrafficPolicyInstanceErrorKind {
    /// <p>You tried to update a traffic policy instance by using a traffic policy version that has a different DNS type
    /// than the current type for the instance. You specified the type in the JSON document in the <code>CreateTrafficPolicy</code> or
    /// <code>CreateTrafficPolicyVersion</code>request. </p>
    ConflictingTypes(crate::error::ConflictingTypes),
    /// <p>The input is not valid.</p>
    InvalidInput(crate::error::InvalidInput),
    /// <p>No traffic policy exists with the specified ID.</p>
    NoSuchTrafficPolicy(crate::error::NoSuchTrafficPolicy),
    /// <p>No traffic policy instance exists with the specified ID.</p>
    NoSuchTrafficPolicyInstance(crate::error::NoSuchTrafficPolicyInstance),
    /// <p>If Amazon Route 53 can't process a request before the next request arrives, it will reject
    /// subsequent requests for the same hosted zone and return an <code>HTTP 400 error</code>
    /// (<code>Bad request</code>). If Route 53 returns this error repeatedly for the same request, we
    /// recommend that you wait, in intervals of increasing duration, before you try the request
    /// again.</p>
    PriorRequestNotComplete(crate::error::PriorRequestNotComplete),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateTrafficPolicyInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateTrafficPolicyInstanceErrorKind::ConflictingTypes(_inner) => _inner.fmt(f),
            UpdateTrafficPolicyInstanceErrorKind::InvalidInput(_inner) => _inner.fmt(f),
            UpdateTrafficPolicyInstanceErrorKind::NoSuchTrafficPolicy(_inner) => _inner.fmt(f),
            UpdateTrafficPolicyInstanceErrorKind::NoSuchTrafficPolicyInstance(_inner) => {
                _inner.fmt(f)
            }
            UpdateTrafficPolicyInstanceErrorKind::PriorRequestNotComplete(_inner) => _inner.fmt(f),
            UpdateTrafficPolicyInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateTrafficPolicyInstanceError {
    fn code(&self) -> Option<&str> {
        UpdateTrafficPolicyInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateTrafficPolicyInstanceError {
    /// Creates a new `UpdateTrafficPolicyInstanceError`.
    pub fn new(kind: UpdateTrafficPolicyInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateTrafficPolicyInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateTrafficPolicyInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateTrafficPolicyInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateTrafficPolicyInstanceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateTrafficPolicyInstanceErrorKind::ConflictingTypes`.
    pub fn is_conflicting_types(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTrafficPolicyInstanceErrorKind::ConflictingTypes(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTrafficPolicyInstanceErrorKind::InvalidInput`.
    pub fn is_invalid_input(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTrafficPolicyInstanceErrorKind::InvalidInput(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTrafficPolicyInstanceErrorKind::NoSuchTrafficPolicy`.
    pub fn is_no_such_traffic_policy(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTrafficPolicyInstanceErrorKind::NoSuchTrafficPolicy(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTrafficPolicyInstanceErrorKind::NoSuchTrafficPolicyInstance`.
    pub fn is_no_such_traffic_policy_instance(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTrafficPolicyInstanceErrorKind::NoSuchTrafficPolicyInstance(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTrafficPolicyInstanceErrorKind::PriorRequestNotComplete`.
    pub fn is_prior_request_not_complete(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTrafficPolicyInstanceErrorKind::PriorRequestNotComplete(_)
        )
    }
}
impl std::error::Error for UpdateTrafficPolicyInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateTrafficPolicyInstanceErrorKind::ConflictingTypes(_inner) => Some(_inner),
            UpdateTrafficPolicyInstanceErrorKind::InvalidInput(_inner) => Some(_inner),
            UpdateTrafficPolicyInstanceErrorKind::NoSuchTrafficPolicy(_inner) => Some(_inner),
            UpdateTrafficPolicyInstanceErrorKind::NoSuchTrafficPolicyInstance(_inner) => {
                Some(_inner)
            }
            UpdateTrafficPolicyInstanceErrorKind::PriorRequestNotComplete(_inner) => Some(_inner),
            UpdateTrafficPolicyInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>If Amazon Route 53 can't process a request before the next request arrives, it will reject
/// subsequent requests for the same hosted zone and return an <code>HTTP 400 error</code>
/// (<code>Bad request</code>). If Route 53 returns this error repeatedly for the same request, we
/// recommend that you wait, in intervals of increasing duration, before you try the request
/// again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PriorRequestNotComplete {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PriorRequestNotComplete {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PriorRequestNotComplete");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PriorRequestNotComplete {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PriorRequestNotComplete {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PriorRequestNotComplete")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for PriorRequestNotComplete {}
/// See [`PriorRequestNotComplete`](crate::error::PriorRequestNotComplete)
pub mod prior_request_not_complete {
    /// A builder for [`PriorRequestNotComplete`](crate::error::PriorRequestNotComplete)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PriorRequestNotComplete`](crate::error::PriorRequestNotComplete)
        pub fn build(self) -> crate::error::PriorRequestNotComplete {
            crate::error::PriorRequestNotComplete {
                message: self.message,
            }
        }
    }
}
impl PriorRequestNotComplete {
    /// Creates a new builder-style object to manufacture [`PriorRequestNotComplete`](crate::error::PriorRequestNotComplete)
    pub fn builder() -> crate::error::prior_request_not_complete::Builder {
        crate::error::prior_request_not_complete::Builder::default()
    }
}

/// <p>No traffic policy instance exists with the specified ID.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoSuchTrafficPolicyInstance {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoSuchTrafficPolicyInstance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoSuchTrafficPolicyInstance");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoSuchTrafficPolicyInstance {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoSuchTrafficPolicyInstance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoSuchTrafficPolicyInstance")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoSuchTrafficPolicyInstance {}
/// See [`NoSuchTrafficPolicyInstance`](crate::error::NoSuchTrafficPolicyInstance)
pub mod no_such_traffic_policy_instance {
    /// A builder for [`NoSuchTrafficPolicyInstance`](crate::error::NoSuchTrafficPolicyInstance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoSuchTrafficPolicyInstance`](crate::error::NoSuchTrafficPolicyInstance)
        pub fn build(self) -> crate::error::NoSuchTrafficPolicyInstance {
            crate::error::NoSuchTrafficPolicyInstance {
                message: self.message,
            }
        }
    }
}
impl NoSuchTrafficPolicyInstance {
    /// Creates a new builder-style object to manufacture [`NoSuchTrafficPolicyInstance`](crate::error::NoSuchTrafficPolicyInstance)
    pub fn builder() -> crate::error::no_such_traffic_policy_instance::Builder {
        crate::error::no_such_traffic_policy_instance::Builder::default()
    }
}

/// <p>No traffic policy exists with the specified ID.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoSuchTrafficPolicy {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoSuchTrafficPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoSuchTrafficPolicy");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoSuchTrafficPolicy {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoSuchTrafficPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoSuchTrafficPolicy")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoSuchTrafficPolicy {}
/// See [`NoSuchTrafficPolicy`](crate::error::NoSuchTrafficPolicy)
pub mod no_such_traffic_policy {
    /// A builder for [`NoSuchTrafficPolicy`](crate::error::NoSuchTrafficPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoSuchTrafficPolicy`](crate::error::NoSuchTrafficPolicy)
        pub fn build(self) -> crate::error::NoSuchTrafficPolicy {
            crate::error::NoSuchTrafficPolicy {
                message: self.message,
            }
        }
    }
}
impl NoSuchTrafficPolicy {
    /// Creates a new builder-style object to manufacture [`NoSuchTrafficPolicy`](crate::error::NoSuchTrafficPolicy)
    pub fn builder() -> crate::error::no_such_traffic_policy::Builder {
        crate::error::no_such_traffic_policy::Builder::default()
    }
}

/// <p>The input is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidInput {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidInput");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidInput {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidInput")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidInput {}
/// See [`InvalidInput`](crate::error::InvalidInput)
pub mod invalid_input {
    /// A builder for [`InvalidInput`](crate::error::InvalidInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidInput`](crate::error::InvalidInput)
        pub fn build(self) -> crate::error::InvalidInput {
            crate::error::InvalidInput {
                message: self.message,
            }
        }
    }
}
impl InvalidInput {
    /// Creates a new builder-style object to manufacture [`InvalidInput`](crate::error::InvalidInput)
    pub fn builder() -> crate::error::invalid_input::Builder {
        crate::error::invalid_input::Builder::default()
    }
}

/// <p>You tried to update a traffic policy instance by using a traffic policy version that has a different DNS type
/// than the current type for the instance. You specified the type in the JSON document in the <code>CreateTrafficPolicy</code> or
/// <code>CreateTrafficPolicyVersion</code>request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictingTypes {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictingTypes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictingTypes");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictingTypes {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictingTypes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictingTypes")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictingTypes {}
/// See [`ConflictingTypes`](crate::error::ConflictingTypes)
pub mod conflicting_types {
    /// A builder for [`ConflictingTypes`](crate::error::ConflictingTypes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictingTypes`](crate::error::ConflictingTypes)
        pub fn build(self) -> crate::error::ConflictingTypes {
            crate::error::ConflictingTypes {
                message: self.message,
            }
        }
    }
}
impl ConflictingTypes {
    /// Creates a new builder-style object to manufacture [`ConflictingTypes`](crate::error::ConflictingTypes)
    pub fn builder() -> crate::error::conflicting_types::Builder {
        crate::error::conflicting_types::Builder::default()
    }
}

/// <p>Another user submitted a request to create, update, or delete the object at the same time that you did. Retry the request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConcurrentModification {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConcurrentModification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConcurrentModification");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConcurrentModification {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConcurrentModification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConcurrentModification")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConcurrentModification {}
/// See [`ConcurrentModification`](crate::error::ConcurrentModification)
pub mod concurrent_modification {
    /// A builder for [`ConcurrentModification`](crate::error::ConcurrentModification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConcurrentModification`](crate::error::ConcurrentModification)
        pub fn build(self) -> crate::error::ConcurrentModification {
            crate::error::ConcurrentModification {
                message: self.message,
            }
        }
    }
}
impl ConcurrentModification {
    /// Creates a new builder-style object to manufacture [`ConcurrentModification`](crate::error::ConcurrentModification)
    pub fn builder() -> crate::error::concurrent_modification::Builder {
        crate::error::concurrent_modification::Builder::default()
    }
}

/// <p>No hosted zone exists with the ID that you specified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoSuchHostedZone {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoSuchHostedZone {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoSuchHostedZone");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoSuchHostedZone {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoSuchHostedZone {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoSuchHostedZone")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoSuchHostedZone {}
/// See [`NoSuchHostedZone`](crate::error::NoSuchHostedZone)
pub mod no_such_hosted_zone {
    /// A builder for [`NoSuchHostedZone`](crate::error::NoSuchHostedZone)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoSuchHostedZone`](crate::error::NoSuchHostedZone)
        pub fn build(self) -> crate::error::NoSuchHostedZone {
            crate::error::NoSuchHostedZone {
                message: self.message,
            }
        }
    }
}
impl NoSuchHostedZone {
    /// Creates a new builder-style object to manufacture [`NoSuchHostedZone`](crate::error::NoSuchHostedZone)
    pub fn builder() -> crate::error::no_such_hosted_zone::Builder {
        crate::error::no_such_hosted_zone::Builder::default()
    }
}

/// <p>No health check exists with the specified ID.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoSuchHealthCheck {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoSuchHealthCheck {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoSuchHealthCheck");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoSuchHealthCheck {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoSuchHealthCheck {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoSuchHealthCheck")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoSuchHealthCheck {}
/// See [`NoSuchHealthCheck`](crate::error::NoSuchHealthCheck)
pub mod no_such_health_check {
    /// A builder for [`NoSuchHealthCheck`](crate::error::NoSuchHealthCheck)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoSuchHealthCheck`](crate::error::NoSuchHealthCheck)
        pub fn build(self) -> crate::error::NoSuchHealthCheck {
            crate::error::NoSuchHealthCheck {
                message: self.message,
            }
        }
    }
}
impl NoSuchHealthCheck {
    /// Creates a new builder-style object to manufacture [`NoSuchHealthCheck`](crate::error::NoSuchHealthCheck)
    pub fn builder() -> crate::error::no_such_health_check::Builder {
        crate::error::no_such_health_check::Builder::default()
    }
}

/// <p>The value of <code>HealthCheckVersion</code> in the request doesn't match the value of <code>HealthCheckVersion</code>
/// in the health check.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HealthCheckVersionMismatch {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for HealthCheckVersionMismatch {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HealthCheckVersionMismatch");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl HealthCheckVersionMismatch {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for HealthCheckVersionMismatch {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "HealthCheckVersionMismatch")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for HealthCheckVersionMismatch {}
/// See [`HealthCheckVersionMismatch`](crate::error::HealthCheckVersionMismatch)
pub mod health_check_version_mismatch {
    /// A builder for [`HealthCheckVersionMismatch`](crate::error::HealthCheckVersionMismatch)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`HealthCheckVersionMismatch`](crate::error::HealthCheckVersionMismatch)
        pub fn build(self) -> crate::error::HealthCheckVersionMismatch {
            crate::error::HealthCheckVersionMismatch {
                message: self.message,
            }
        }
    }
}
impl HealthCheckVersionMismatch {
    /// Creates a new builder-style object to manufacture [`HealthCheckVersionMismatch`](crate::error::HealthCheckVersionMismatch)
    pub fn builder() -> crate::error::health_check_version_mismatch::Builder {
        crate::error::health_check_version_mismatch::Builder::default()
    }
}

/// <p>The value that you specified to get the second or subsequent page of results is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidPaginationToken {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidPaginationToken {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidPaginationToken");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidPaginationToken {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidPaginationToken {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidPaginationToken")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidPaginationToken {}
/// See [`InvalidPaginationToken`](crate::error::InvalidPaginationToken)
pub mod invalid_pagination_token {
    /// A builder for [`InvalidPaginationToken`](crate::error::InvalidPaginationToken)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidPaginationToken`](crate::error::InvalidPaginationToken)
        pub fn build(self) -> crate::error::InvalidPaginationToken {
            crate::error::InvalidPaginationToken {
                message: self.message,
            }
        }
    }
}
impl InvalidPaginationToken {
    /// Creates a new builder-style object to manufacture [`InvalidPaginationToken`](crate::error::InvalidPaginationToken)
    pub fn builder() -> crate::error::invalid_pagination_token::Builder {
        crate::error::invalid_pagination_token::Builder::default()
    }
}

/// <p>The limit on the number of requests per second was exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>The specified domain name is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidDomainName {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidDomainName {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidDomainName");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidDomainName {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidDomainName {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidDomainName")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidDomainName {}
/// See [`InvalidDomainName`](crate::error::InvalidDomainName)
pub mod invalid_domain_name {
    /// A builder for [`InvalidDomainName`](crate::error::InvalidDomainName)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidDomainName`](crate::error::InvalidDomainName)
        pub fn build(self) -> crate::error::InvalidDomainName {
            crate::error::InvalidDomainName {
                message: self.message,
            }
        }
    }
}
impl InvalidDomainName {
    /// Creates a new builder-style object to manufacture [`InvalidDomainName`](crate::error::InvalidDomainName)
    pub fn builder() -> crate::error::invalid_domain_name::Builder {
        crate::error::invalid_domain_name::Builder::default()
    }
}

/// <p>A reusable delegation set with the specified ID does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoSuchDelegationSet {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoSuchDelegationSet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoSuchDelegationSet");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoSuchDelegationSet {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoSuchDelegationSet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoSuchDelegationSet")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoSuchDelegationSet {}
/// See [`NoSuchDelegationSet`](crate::error::NoSuchDelegationSet)
pub mod no_such_delegation_set {
    /// A builder for [`NoSuchDelegationSet`](crate::error::NoSuchDelegationSet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoSuchDelegationSet`](crate::error::NoSuchDelegationSet)
        pub fn build(self) -> crate::error::NoSuchDelegationSet {
            crate::error::NoSuchDelegationSet {
                message: self.message,
            }
        }
    }
}
impl NoSuchDelegationSet {
    /// Creates a new builder-style object to manufacture [`NoSuchDelegationSet`](crate::error::NoSuchDelegationSet)
    pub fn builder() -> crate::error::no_such_delegation_set::Builder {
        crate::error::no_such_delegation_set::Builder::default()
    }
}

/// <p>A reusable delegation set with the specified ID does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DelegationSetNotReusable {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DelegationSetNotReusable {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DelegationSetNotReusable");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DelegationSetNotReusable {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DelegationSetNotReusable {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DelegationSetNotReusable")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for DelegationSetNotReusable {}
/// See [`DelegationSetNotReusable`](crate::error::DelegationSetNotReusable)
pub mod delegation_set_not_reusable {
    /// A builder for [`DelegationSetNotReusable`](crate::error::DelegationSetNotReusable)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DelegationSetNotReusable`](crate::error::DelegationSetNotReusable)
        pub fn build(self) -> crate::error::DelegationSetNotReusable {
            crate::error::DelegationSetNotReusable {
                message: self.message,
            }
        }
    }
}
impl DelegationSetNotReusable {
    /// Creates a new builder-style object to manufacture [`DelegationSetNotReusable`](crate::error::DelegationSetNotReusable)
    pub fn builder() -> crate::error::delegation_set_not_reusable::Builder {
        crate::error::delegation_set_not_reusable::Builder::default()
    }
}

/// <p>The resource you're trying to access is unsupported on this Amazon Route 53 endpoint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IncompatibleVersion {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IncompatibleVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IncompatibleVersion");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl IncompatibleVersion {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for IncompatibleVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "IncompatibleVersion")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for IncompatibleVersion {}
/// See [`IncompatibleVersion`](crate::error::IncompatibleVersion)
pub mod incompatible_version {
    /// A builder for [`IncompatibleVersion`](crate::error::IncompatibleVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`IncompatibleVersion`](crate::error::IncompatibleVersion)
        pub fn build(self) -> crate::error::IncompatibleVersion {
            crate::error::IncompatibleVersion {
                message: self.message,
            }
        }
    }
}
impl IncompatibleVersion {
    /// Creates a new builder-style object to manufacture [`IncompatibleVersion`](crate::error::IncompatibleVersion)
    pub fn builder() -> crate::error::incompatible_version::Builder {
        crate::error::incompatible_version::Builder::default()
    }
}

/// <p>There is no DNS query logging configuration with the specified ID.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoSuchQueryLoggingConfig {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoSuchQueryLoggingConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoSuchQueryLoggingConfig");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoSuchQueryLoggingConfig {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoSuchQueryLoggingConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoSuchQueryLoggingConfig")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoSuchQueryLoggingConfig {}
/// See [`NoSuchQueryLoggingConfig`](crate::error::NoSuchQueryLoggingConfig)
pub mod no_such_query_logging_config {
    /// A builder for [`NoSuchQueryLoggingConfig`](crate::error::NoSuchQueryLoggingConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoSuchQueryLoggingConfig`](crate::error::NoSuchQueryLoggingConfig)
        pub fn build(self) -> crate::error::NoSuchQueryLoggingConfig {
            crate::error::NoSuchQueryLoggingConfig {
                message: self.message,
            }
        }
    }
}
impl NoSuchQueryLoggingConfig {
    /// Creates a new builder-style object to manufacture [`NoSuchQueryLoggingConfig`](crate::error::NoSuchQueryLoggingConfig)
    pub fn builder() -> crate::error::no_such_query_logging_config::Builder {
        crate::error::no_such_query_logging_config::Builder::default()
    }
}

/// <p>The specified hosted zone is a public hosted zone, not a private hosted zone.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HostedZoneNotPrivate {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for HostedZoneNotPrivate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HostedZoneNotPrivate");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl HostedZoneNotPrivate {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for HostedZoneNotPrivate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "HostedZoneNotPrivate")?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for HostedZoneNotPrivate {}
/// See [`HostedZoneNotPrivate`](crate::error::HostedZoneNotPrivate)
pub mod hosted_zone_not_private {
    /// A builder for [`HostedZoneNotPrivate`](crate::error::HostedZoneNotPrivate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`HostedZoneNotPrivate`](crate::error::HostedZoneNotPrivate)
        pub fn build(self) -> crate::error::HostedZoneNotPrivate {
            crate::error::HostedZoneNotPrivate {
                message: self.message,
            }
        }
    }
}
impl HostedZoneNotPrivate {
    /// Creates a new builder-style object to manufacture [`HostedZoneNotPrivate`](crate::error::HostedZoneNotPrivate)
    pub fn builder() -> crate::error::hosted_zone_not_private::Builder {
        crate::error::hosted_zone_not_private::Builder::default()
    }
}

/// <p>Amazon Route 53 doesn't support the specified geographic location. For a list of supported geolocation codes, see the
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GeoLocation.html">GeoLocation</a> data type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoSuchGeoLocation {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoSuchGeoLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoSuchGeoLocation");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoSuchGeoLocation {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoSuchGeoLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoSuchGeoLocation")?;
        if let Some(inner_18) = &self.message {
            write!(f, ": {}", inner_18)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoSuchGeoLocation {}
/// See [`NoSuchGeoLocation`](crate::error::NoSuchGeoLocation)
pub mod no_such_geo_location {
    /// A builder for [`NoSuchGeoLocation`](crate::error::NoSuchGeoLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoSuchGeoLocation`](crate::error::NoSuchGeoLocation)
        pub fn build(self) -> crate::error::NoSuchGeoLocation {
            crate::error::NoSuchGeoLocation {
                message: self.message,
            }
        }
    }
}
impl NoSuchGeoLocation {
    /// Creates a new builder-style object to manufacture [`NoSuchGeoLocation`](crate::error::NoSuchGeoLocation)
    pub fn builder() -> crate::error::no_such_geo_location::Builder {
        crate::error::no_such_geo_location::Builder::default()
    }
}

/// <p>Parameter name is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidArgument {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidArgument {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidArgument");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidArgument {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidArgument {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidArgument")?;
        if let Some(inner_19) = &self.message {
            write!(f, ": {}", inner_19)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidArgument {}
/// See [`InvalidArgument`](crate::error::InvalidArgument)
pub mod invalid_argument {
    /// A builder for [`InvalidArgument`](crate::error::InvalidArgument)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidArgument`](crate::error::InvalidArgument)
        pub fn build(self) -> crate::error::InvalidArgument {
            crate::error::InvalidArgument {
                message: self.message,
            }
        }
    }
}
impl InvalidArgument {
    /// Creates a new builder-style object to manufacture [`InvalidArgument`](crate::error::InvalidArgument)
    pub fn builder() -> crate::error::invalid_argument::Builder {
        crate::error::invalid_argument::Builder::default()
    }
}

/// <p>A change with the specified change ID does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoSuchChange {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoSuchChange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoSuchChange");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoSuchChange {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoSuchChange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoSuchChange")?;
        if let Some(inner_20) = &self.message {
            write!(f, ": {}", inner_20)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoSuchChange {}
/// See [`NoSuchChange`](crate::error::NoSuchChange)
pub mod no_such_change {
    /// A builder for [`NoSuchChange`](crate::error::NoSuchChange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoSuchChange`](crate::error::NoSuchChange)
        pub fn build(self) -> crate::error::NoSuchChange {
            crate::error::NoSuchChange {
                message: self.message,
            }
        }
    }
}
impl NoSuchChange {
    /// Creates a new builder-style object to manufacture [`NoSuchChange`](crate::error::NoSuchChange)
    pub fn builder() -> crate::error::no_such_change::Builder {
        crate::error::no_such_change::Builder::default()
    }
}

/// <p>A key-signing key (KSK) with <code>ACTIVE</code> status wasn't found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KeySigningKeyWithActiveStatusNotFound {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KeySigningKeyWithActiveStatusNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KeySigningKeyWithActiveStatusNotFound");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl KeySigningKeyWithActiveStatusNotFound {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for KeySigningKeyWithActiveStatusNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "KeySigningKeyWithActiveStatusNotFound")?;
        if let Some(inner_21) = &self.message {
            write!(f, ": {}", inner_21)?;
        }
        Ok(())
    }
}
impl std::error::Error for KeySigningKeyWithActiveStatusNotFound {}
/// See [`KeySigningKeyWithActiveStatusNotFound`](crate::error::KeySigningKeyWithActiveStatusNotFound)
pub mod key_signing_key_with_active_status_not_found {
    /// A builder for [`KeySigningKeyWithActiveStatusNotFound`](crate::error::KeySigningKeyWithActiveStatusNotFound)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`KeySigningKeyWithActiveStatusNotFound`](crate::error::KeySigningKeyWithActiveStatusNotFound)
        pub fn build(self) -> crate::error::KeySigningKeyWithActiveStatusNotFound {
            crate::error::KeySigningKeyWithActiveStatusNotFound {
                message: self.message,
            }
        }
    }
}
impl KeySigningKeyWithActiveStatusNotFound {
    /// Creates a new builder-style object to manufacture [`KeySigningKeyWithActiveStatusNotFound`](crate::error::KeySigningKeyWithActiveStatusNotFound)
    pub fn builder() -> crate::error::key_signing_key_with_active_status_not_found::Builder {
        crate::error::key_signing_key_with_active_status_not_found::Builder::default()
    }
}

/// <p>The KeyManagementServiceArn that you specified isn't valid to use with DNSSEC signing.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidKmsArn {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidKmsArn {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidKmsArn");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidKmsArn {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidKmsArn {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidKmsArn [InvalidKMSArn]")?;
        if let Some(inner_22) = &self.message {
            write!(f, ": {}", inner_22)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidKmsArn {}
/// See [`InvalidKmsArn`](crate::error::InvalidKmsArn)
pub mod invalid_kms_arn {
    /// A builder for [`InvalidKmsArn`](crate::error::InvalidKmsArn)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidKmsArn`](crate::error::InvalidKmsArn)
        pub fn build(self) -> crate::error::InvalidKmsArn {
            crate::error::InvalidKmsArn {
                message: self.message,
            }
        }
    }
}
impl InvalidKmsArn {
    /// Creates a new builder-style object to manufacture [`InvalidKmsArn`](crate::error::InvalidKmsArn)
    pub fn builder() -> crate::error::invalid_kms_arn::Builder {
        crate::error::invalid_kms_arn::Builder::default()
    }
}

/// <p>The key-signing key (KSK) status isn't valid or another KSK has the status <code>INTERNAL_FAILURE</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidKeySigningKeyStatus {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidKeySigningKeyStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidKeySigningKeyStatus");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidKeySigningKeyStatus {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidKeySigningKeyStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidKeySigningKeyStatus")?;
        if let Some(inner_23) = &self.message {
            write!(f, ": {}", inner_23)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidKeySigningKeyStatus {}
/// See [`InvalidKeySigningKeyStatus`](crate::error::InvalidKeySigningKeyStatus)
pub mod invalid_key_signing_key_status {
    /// A builder for [`InvalidKeySigningKeyStatus`](crate::error::InvalidKeySigningKeyStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidKeySigningKeyStatus`](crate::error::InvalidKeySigningKeyStatus)
        pub fn build(self) -> crate::error::InvalidKeySigningKeyStatus {
            crate::error::InvalidKeySigningKeyStatus {
                message: self.message,
            }
        }
    }
}
impl InvalidKeySigningKeyStatus {
    /// Creates a new builder-style object to manufacture [`InvalidKeySigningKeyStatus`](crate::error::InvalidKeySigningKeyStatus)
    pub fn builder() -> crate::error::invalid_key_signing_key_status::Builder {
        crate::error::invalid_key_signing_key_status::Builder::default()
    }
}

/// <p>The hosted zone nameservers don't match the parent nameservers. The hosted zone and parent must have the same nameservers.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HostedZonePartiallyDelegated {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for HostedZonePartiallyDelegated {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HostedZonePartiallyDelegated");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl HostedZonePartiallyDelegated {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for HostedZonePartiallyDelegated {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "HostedZonePartiallyDelegated")?;
        if let Some(inner_24) = &self.message {
            write!(f, ": {}", inner_24)?;
        }
        Ok(())
    }
}
impl std::error::Error for HostedZonePartiallyDelegated {}
/// See [`HostedZonePartiallyDelegated`](crate::error::HostedZonePartiallyDelegated)
pub mod hosted_zone_partially_delegated {
    /// A builder for [`HostedZonePartiallyDelegated`](crate::error::HostedZonePartiallyDelegated)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`HostedZonePartiallyDelegated`](crate::error::HostedZonePartiallyDelegated)
        pub fn build(self) -> crate::error::HostedZonePartiallyDelegated {
            crate::error::HostedZonePartiallyDelegated {
                message: self.message,
            }
        }
    }
}
impl HostedZonePartiallyDelegated {
    /// Creates a new builder-style object to manufacture [`HostedZonePartiallyDelegated`](crate::error::HostedZonePartiallyDelegated)
    pub fn builder() -> crate::error::hosted_zone_partially_delegated::Builder {
        crate::error::hosted_zone_partially_delegated::Builder::default()
    }
}

/// <p>The hosted zone doesn't have any DNSSEC resources.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DnssecNotFound {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DnssecNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DnssecNotFound");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DnssecNotFound {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DnssecNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DnssecNotFound [DNSSECNotFound]")?;
        if let Some(inner_25) = &self.message {
            write!(f, ": {}", inner_25)?;
        }
        Ok(())
    }
}
impl std::error::Error for DnssecNotFound {}
/// See [`DnssecNotFound`](crate::error::DnssecNotFound)
pub mod dnssec_not_found {
    /// A builder for [`DnssecNotFound`](crate::error::DnssecNotFound)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DnssecNotFound`](crate::error::DnssecNotFound)
        pub fn build(self) -> crate::error::DnssecNotFound {
            crate::error::DnssecNotFound {
                message: self.message,
            }
        }
    }
}
impl DnssecNotFound {
    /// Creates a new builder-style object to manufacture [`DnssecNotFound`](crate::error::DnssecNotFound)
    pub fn builder() -> crate::error::dnssec_not_found::Builder {
        crate::error::dnssec_not_found::Builder::default()
    }
}

/// <p>The specified VPC and hosted zone are not currently associated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcAssociationNotFound {
    /// <p>The specified VPC or hosted zone weren't found.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for VpcAssociationNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcAssociationNotFound");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl VpcAssociationNotFound {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for VpcAssociationNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "VpcAssociationNotFound [VPCAssociationNotFound]")?;
        if let Some(inner_26) = &self.message {
            write!(f, ": {}", inner_26)?;
        }
        Ok(())
    }
}
impl std::error::Error for VpcAssociationNotFound {}
/// See [`VpcAssociationNotFound`](crate::error::VpcAssociationNotFound)
pub mod vpc_association_not_found {
    /// A builder for [`VpcAssociationNotFound`](crate::error::VpcAssociationNotFound)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The specified VPC or hosted zone weren't found.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The specified VPC or hosted zone weren't found.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcAssociationNotFound`](crate::error::VpcAssociationNotFound)
        pub fn build(self) -> crate::error::VpcAssociationNotFound {
            crate::error::VpcAssociationNotFound {
                message: self.message,
            }
        }
    }
}
impl VpcAssociationNotFound {
    /// Creates a new builder-style object to manufacture [`VpcAssociationNotFound`](crate::error::VpcAssociationNotFound)
    pub fn builder() -> crate::error::vpc_association_not_found::Builder {
        crate::error::vpc_association_not_found::Builder::default()
    }
}

/// <p>The VPC that you're trying to disassociate from the private hosted zone is the last VPC that is associated with
/// the hosted zone. Amazon Route 53 doesn't support disassociating the last VPC from a hosted zone.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LastVpcAssociation {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LastVpcAssociation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LastVpcAssociation");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LastVpcAssociation {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LastVpcAssociation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LastVpcAssociation [LastVPCAssociation]")?;
        if let Some(inner_27) = &self.message {
            write!(f, ": {}", inner_27)?;
        }
        Ok(())
    }
}
impl std::error::Error for LastVpcAssociation {}
/// See [`LastVpcAssociation`](crate::error::LastVpcAssociation)
pub mod last_vpc_association {
    /// A builder for [`LastVpcAssociation`](crate::error::LastVpcAssociation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LastVpcAssociation`](crate::error::LastVpcAssociation)
        pub fn build(self) -> crate::error::LastVpcAssociation {
            crate::error::LastVpcAssociation {
                message: self.message,
            }
        }
    }
}
impl LastVpcAssociation {
    /// Creates a new builder-style object to manufacture [`LastVpcAssociation`](crate::error::LastVpcAssociation)
    pub fn builder() -> crate::error::last_vpc_association::Builder {
        crate::error::last_vpc_association::Builder::default()
    }
}

/// <p>The VPC ID that you specified either isn't a valid ID or the current account is not authorized to access this VPC.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidVpcId {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidVpcId {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidVpcId");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidVpcId {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidVpcId {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidVpcId [InvalidVPCId]")?;
        if let Some(inner_28) = &self.message {
            write!(f, ": {}", inner_28)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidVpcId {}
/// See [`InvalidVpcId`](crate::error::InvalidVpcId)
pub mod invalid_vpc_id {
    /// A builder for [`InvalidVpcId`](crate::error::InvalidVpcId)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidVpcId`](crate::error::InvalidVpcId)
        pub fn build(self) -> crate::error::InvalidVpcId {
            crate::error::InvalidVpcId {
                message: self.message,
            }
        }
    }
}
impl InvalidVpcId {
    /// Creates a new builder-style object to manufacture [`InvalidVpcId`](crate::error::InvalidVpcId)
    pub fn builder() -> crate::error::invalid_vpc_id::Builder {
        crate::error::invalid_vpc_id::Builder::default()
    }
}

/// <p>The key-signing key (KSK) is specified in a parent DS record.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KeySigningKeyInParentDsRecord {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KeySigningKeyInParentDsRecord {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KeySigningKeyInParentDsRecord");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl KeySigningKeyInParentDsRecord {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for KeySigningKeyInParentDsRecord {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "KeySigningKeyInParentDsRecord [KeySigningKeyInParentDSRecord]"
        )?;
        if let Some(inner_29) = &self.message {
            write!(f, ": {}", inner_29)?;
        }
        Ok(())
    }
}
impl std::error::Error for KeySigningKeyInParentDsRecord {}
/// See [`KeySigningKeyInParentDsRecord`](crate::error::KeySigningKeyInParentDsRecord)
pub mod key_signing_key_in_parent_ds_record {
    /// A builder for [`KeySigningKeyInParentDsRecord`](crate::error::KeySigningKeyInParentDsRecord)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`KeySigningKeyInParentDsRecord`](crate::error::KeySigningKeyInParentDsRecord)
        pub fn build(self) -> crate::error::KeySigningKeyInParentDsRecord {
            crate::error::KeySigningKeyInParentDsRecord {
                message: self.message,
            }
        }
    }
}
impl KeySigningKeyInParentDsRecord {
    /// Creates a new builder-style object to manufacture [`KeySigningKeyInParentDsRecord`](crate::error::KeySigningKeyInParentDsRecord)
    pub fn builder() -> crate::error::key_signing_key_in_parent_ds_record::Builder {
        crate::error::key_signing_key_in_parent_ds_record::Builder::default()
    }
}

/// <p>The VPC that you specified is not authorized to be associated with the hosted zone.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcAssociationAuthorizationNotFound {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for VpcAssociationAuthorizationNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcAssociationAuthorizationNotFound");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl VpcAssociationAuthorizationNotFound {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for VpcAssociationAuthorizationNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "VpcAssociationAuthorizationNotFound [VPCAssociationAuthorizationNotFound]"
        )?;
        if let Some(inner_30) = &self.message {
            write!(f, ": {}", inner_30)?;
        }
        Ok(())
    }
}
impl std::error::Error for VpcAssociationAuthorizationNotFound {}
/// See [`VpcAssociationAuthorizationNotFound`](crate::error::VpcAssociationAuthorizationNotFound)
pub mod vpc_association_authorization_not_found {
    /// A builder for [`VpcAssociationAuthorizationNotFound`](crate::error::VpcAssociationAuthorizationNotFound)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcAssociationAuthorizationNotFound`](crate::error::VpcAssociationAuthorizationNotFound)
        pub fn build(self) -> crate::error::VpcAssociationAuthorizationNotFound {
            crate::error::VpcAssociationAuthorizationNotFound {
                message: self.message,
            }
        }
    }
}
impl VpcAssociationAuthorizationNotFound {
    /// Creates a new builder-style object to manufacture [`VpcAssociationAuthorizationNotFound`](crate::error::VpcAssociationAuthorizationNotFound)
    pub fn builder() -> crate::error::vpc_association_authorization_not_found::Builder {
        crate::error::vpc_association_authorization_not_found::Builder::default()
    }
}

/// <p>One or more traffic policy instances were created by using the specified traffic policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrafficPolicyInUse {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TrafficPolicyInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrafficPolicyInUse");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TrafficPolicyInUse {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TrafficPolicyInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TrafficPolicyInUse")?;
        if let Some(inner_31) = &self.message {
            write!(f, ": {}", inner_31)?;
        }
        Ok(())
    }
}
impl std::error::Error for TrafficPolicyInUse {}
/// See [`TrafficPolicyInUse`](crate::error::TrafficPolicyInUse)
pub mod traffic_policy_in_use {
    /// A builder for [`TrafficPolicyInUse`](crate::error::TrafficPolicyInUse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TrafficPolicyInUse`](crate::error::TrafficPolicyInUse)
        pub fn build(self) -> crate::error::TrafficPolicyInUse {
            crate::error::TrafficPolicyInUse {
                message: self.message,
            }
        }
    }
}
impl TrafficPolicyInUse {
    /// Creates a new builder-style object to manufacture [`TrafficPolicyInUse`](crate::error::TrafficPolicyInUse)
    pub fn builder() -> crate::error::traffic_policy_in_use::Builder {
        crate::error::traffic_policy_in_use::Builder::default()
    }
}

/// <p>The specified delegation contains associated hosted zones which must be deleted before the reusable delegation set
/// can be deleted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DelegationSetInUse {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DelegationSetInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DelegationSetInUse");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DelegationSetInUse {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DelegationSetInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DelegationSetInUse")?;
        if let Some(inner_32) = &self.message {
            write!(f, ": {}", inner_32)?;
        }
        Ok(())
    }
}
impl std::error::Error for DelegationSetInUse {}
/// See [`DelegationSetInUse`](crate::error::DelegationSetInUse)
pub mod delegation_set_in_use {
    /// A builder for [`DelegationSetInUse`](crate::error::DelegationSetInUse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DelegationSetInUse`](crate::error::DelegationSetInUse)
        pub fn build(self) -> crate::error::DelegationSetInUse {
            crate::error::DelegationSetInUse {
                message: self.message,
            }
        }
    }
}
impl DelegationSetInUse {
    /// Creates a new builder-style object to manufacture [`DelegationSetInUse`](crate::error::DelegationSetInUse)
    pub fn builder() -> crate::error::delegation_set_in_use::Builder {
        crate::error::delegation_set_in_use::Builder::default()
    }
}

/// <p>The specified key-signing key (KSK) doesn't exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoSuchKeySigningKey {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoSuchKeySigningKey {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoSuchKeySigningKey");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoSuchKeySigningKey {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoSuchKeySigningKey {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoSuchKeySigningKey")?;
        if let Some(inner_33) = &self.message {
            write!(f, ": {}", inner_33)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoSuchKeySigningKey {}
/// See [`NoSuchKeySigningKey`](crate::error::NoSuchKeySigningKey)
pub mod no_such_key_signing_key {
    /// A builder for [`NoSuchKeySigningKey`](crate::error::NoSuchKeySigningKey)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoSuchKeySigningKey`](crate::error::NoSuchKeySigningKey)
        pub fn build(self) -> crate::error::NoSuchKeySigningKey {
            crate::error::NoSuchKeySigningKey {
                message: self.message,
            }
        }
    }
}
impl NoSuchKeySigningKey {
    /// Creates a new builder-style object to manufacture [`NoSuchKeySigningKey`](crate::error::NoSuchKeySigningKey)
    pub fn builder() -> crate::error::no_such_key_signing_key::Builder {
        crate::error::no_such_key_signing_key::Builder::default()
    }
}

/// <p>Your hosted zone status isn't valid for this operation. In the hosted zone, change the status to enable <code>DNSSEC</code>
/// or disable <code>DNSSEC</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidSigningStatus {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidSigningStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidSigningStatus");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidSigningStatus {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidSigningStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidSigningStatus")?;
        if let Some(inner_34) = &self.message {
            write!(f, ": {}", inner_34)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidSigningStatus {}
/// See [`InvalidSigningStatus`](crate::error::InvalidSigningStatus)
pub mod invalid_signing_status {
    /// A builder for [`InvalidSigningStatus`](crate::error::InvalidSigningStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidSigningStatus`](crate::error::InvalidSigningStatus)
        pub fn build(self) -> crate::error::InvalidSigningStatus {
            crate::error::InvalidSigningStatus {
                message: self.message,
            }
        }
    }
}
impl InvalidSigningStatus {
    /// Creates a new builder-style object to manufacture [`InvalidSigningStatus`](crate::error::InvalidSigningStatus)
    pub fn builder() -> crate::error::invalid_signing_status::Builder {
        crate::error::invalid_signing_status::Builder::default()
    }
}

/// <p>The hosted zone contains resource records that are not SOA or NS records.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HostedZoneNotEmpty {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for HostedZoneNotEmpty {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HostedZoneNotEmpty");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl HostedZoneNotEmpty {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for HostedZoneNotEmpty {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "HostedZoneNotEmpty")?;
        if let Some(inner_35) = &self.message {
            write!(f, ": {}", inner_35)?;
        }
        Ok(())
    }
}
impl std::error::Error for HostedZoneNotEmpty {}
/// See [`HostedZoneNotEmpty`](crate::error::HostedZoneNotEmpty)
pub mod hosted_zone_not_empty {
    /// A builder for [`HostedZoneNotEmpty`](crate::error::HostedZoneNotEmpty)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`HostedZoneNotEmpty`](crate::error::HostedZoneNotEmpty)
        pub fn build(self) -> crate::error::HostedZoneNotEmpty {
            crate::error::HostedZoneNotEmpty {
                message: self.message,
            }
        }
    }
}
impl HostedZoneNotEmpty {
    /// Creates a new builder-style object to manufacture [`HostedZoneNotEmpty`](crate::error::HostedZoneNotEmpty)
    pub fn builder() -> crate::error::hosted_zone_not_empty::Builder {
        crate::error::hosted_zone_not_empty::Builder::default()
    }
}

/// <p>This error code is not in use.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HealthCheckInUse {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for HealthCheckInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HealthCheckInUse");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl HealthCheckInUse {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for HealthCheckInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "HealthCheckInUse")?;
        if let Some(inner_36) = &self.message {
            write!(f, ": {}", inner_36)?;
        }
        Ok(())
    }
}
impl std::error::Error for HealthCheckInUse {}
/// See [`HealthCheckInUse`](crate::error::HealthCheckInUse)
pub mod health_check_in_use {
    /// A builder for [`HealthCheckInUse`](crate::error::HealthCheckInUse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`HealthCheckInUse`](crate::error::HealthCheckInUse)
        pub fn build(self) -> crate::error::HealthCheckInUse {
            crate::error::HealthCheckInUse {
                message: self.message,
            }
        }
    }
}
impl HealthCheckInUse {
    /// Creates a new builder-style object to manufacture [`HealthCheckInUse`](crate::error::HealthCheckInUse)
    pub fn builder() -> crate::error::health_check_in_use::Builder {
        crate::error::health_check_in_use::Builder::default()
    }
}

/// <p>The key-signing key (KSK) that you specified can't be deactivated because it's the only KSK for a
/// currently-enabled DNSSEC. Disable DNSSEC signing, or add or enable another KSK.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KeySigningKeyInUse {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KeySigningKeyInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KeySigningKeyInUse");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl KeySigningKeyInUse {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for KeySigningKeyInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "KeySigningKeyInUse")?;
        if let Some(inner_37) = &self.message {
            write!(f, ": {}", inner_37)?;
        }
        Ok(())
    }
}
impl std::error::Error for KeySigningKeyInUse {}
/// See [`KeySigningKeyInUse`](crate::error::KeySigningKeyInUse)
pub mod key_signing_key_in_use {
    /// A builder for [`KeySigningKeyInUse`](crate::error::KeySigningKeyInUse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`KeySigningKeyInUse`](crate::error::KeySigningKeyInUse)
        pub fn build(self) -> crate::error::KeySigningKeyInUse {
            crate::error::KeySigningKeyInUse {
                message: self.message,
            }
        }
    }
}
impl KeySigningKeyInUse {
    /// Creates a new builder-style object to manufacture [`KeySigningKeyInUse`](crate::error::KeySigningKeyInUse)
    pub fn builder() -> crate::error::key_signing_key_in_use::Builder {
        crate::error::key_signing_key_in_use::Builder::default()
    }
}

/// <p>You've created the maximum number of authorizations that can be created for the specified hosted zone.
/// To authorize another VPC to be associated with the hosted zone, submit a <code>DeleteVPCAssociationAuthorization</code> request
/// to remove an existing authorization. To get a list of existing authorizations, submit a
/// <code>ListVPCAssociationAuthorizations</code> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyVpcAssociationAuthorizations {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyVpcAssociationAuthorizations {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyVpcAssociationAuthorizations");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyVpcAssociationAuthorizations {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyVpcAssociationAuthorizations {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "TooManyVpcAssociationAuthorizations [TooManyVPCAssociationAuthorizations]"
        )?;
        if let Some(inner_38) = &self.message {
            write!(f, ": {}", inner_38)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyVpcAssociationAuthorizations {}
/// See [`TooManyVpcAssociationAuthorizations`](crate::error::TooManyVpcAssociationAuthorizations)
pub mod too_many_vpc_association_authorizations {
    /// A builder for [`TooManyVpcAssociationAuthorizations`](crate::error::TooManyVpcAssociationAuthorizations)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyVpcAssociationAuthorizations`](crate::error::TooManyVpcAssociationAuthorizations)
        pub fn build(self) -> crate::error::TooManyVpcAssociationAuthorizations {
            crate::error::TooManyVpcAssociationAuthorizations {
                message: self.message,
            }
        }
    }
}
impl TooManyVpcAssociationAuthorizations {
    /// Creates a new builder-style object to manufacture [`TooManyVpcAssociationAuthorizations`](crate::error::TooManyVpcAssociationAuthorizations)
    pub fn builder() -> crate::error::too_many_vpc_association_authorizations::Builder {
        crate::error::too_many_vpc_association_authorizations::Builder::default()
    }
}

/// <p>This traffic policy version can't be created because you've reached the limit of 1000 on the number of versions
/// that you can create for the current traffic policy.</p>
/// <p>To create more traffic policy versions, you can use
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetTrafficPolicy.html">GetTrafficPolicy</a>
/// to get the traffic policy document for a specified traffic policy version, and then use
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateTrafficPolicy.html">CreateTrafficPolicy</a>
/// to create a new traffic policy using the traffic policy document.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyTrafficPolicyVersionsForCurrentPolicy {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyTrafficPolicyVersionsForCurrentPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyTrafficPolicyVersionsForCurrentPolicy");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyTrafficPolicyVersionsForCurrentPolicy {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyTrafficPolicyVersionsForCurrentPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyTrafficPolicyVersionsForCurrentPolicy")?;
        if let Some(inner_39) = &self.message {
            write!(f, ": {}", inner_39)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyTrafficPolicyVersionsForCurrentPolicy {}
/// See [`TooManyTrafficPolicyVersionsForCurrentPolicy`](crate::error::TooManyTrafficPolicyVersionsForCurrentPolicy)
pub mod too_many_traffic_policy_versions_for_current_policy {
    /// A builder for [`TooManyTrafficPolicyVersionsForCurrentPolicy`](crate::error::TooManyTrafficPolicyVersionsForCurrentPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyTrafficPolicyVersionsForCurrentPolicy`](crate::error::TooManyTrafficPolicyVersionsForCurrentPolicy)
        pub fn build(self) -> crate::error::TooManyTrafficPolicyVersionsForCurrentPolicy {
            crate::error::TooManyTrafficPolicyVersionsForCurrentPolicy {
                message: self.message,
            }
        }
    }
}
impl TooManyTrafficPolicyVersionsForCurrentPolicy {
    /// Creates a new builder-style object to manufacture [`TooManyTrafficPolicyVersionsForCurrentPolicy`](crate::error::TooManyTrafficPolicyVersionsForCurrentPolicy)
    pub fn builder() -> crate::error::too_many_traffic_policy_versions_for_current_policy::Builder {
        crate::error::too_many_traffic_policy_versions_for_current_policy::Builder::default()
    }
}

/// <p>The format of the traffic policy document that you specified in the <code>Document</code> element is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidTrafficPolicyDocument {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidTrafficPolicyDocument {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidTrafficPolicyDocument");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidTrafficPolicyDocument {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidTrafficPolicyDocument {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidTrafficPolicyDocument")?;
        if let Some(inner_40) = &self.message {
            write!(f, ": {}", inner_40)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidTrafficPolicyDocument {}
/// See [`InvalidTrafficPolicyDocument`](crate::error::InvalidTrafficPolicyDocument)
pub mod invalid_traffic_policy_document {
    /// A builder for [`InvalidTrafficPolicyDocument`](crate::error::InvalidTrafficPolicyDocument)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidTrafficPolicyDocument`](crate::error::InvalidTrafficPolicyDocument)
        pub fn build(self) -> crate::error::InvalidTrafficPolicyDocument {
            crate::error::InvalidTrafficPolicyDocument {
                message: self.message,
            }
        }
    }
}
impl InvalidTrafficPolicyDocument {
    /// Creates a new builder-style object to manufacture [`InvalidTrafficPolicyDocument`](crate::error::InvalidTrafficPolicyDocument)
    pub fn builder() -> crate::error::invalid_traffic_policy_document::Builder {
        crate::error::invalid_traffic_policy_document::Builder::default()
    }
}

/// <p>There is already a traffic policy instance with the specified ID.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrafficPolicyInstanceAlreadyExists {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TrafficPolicyInstanceAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrafficPolicyInstanceAlreadyExists");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TrafficPolicyInstanceAlreadyExists {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TrafficPolicyInstanceAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TrafficPolicyInstanceAlreadyExists")?;
        if let Some(inner_41) = &self.message {
            write!(f, ": {}", inner_41)?;
        }
        Ok(())
    }
}
impl std::error::Error for TrafficPolicyInstanceAlreadyExists {}
/// See [`TrafficPolicyInstanceAlreadyExists`](crate::error::TrafficPolicyInstanceAlreadyExists)
pub mod traffic_policy_instance_already_exists {
    /// A builder for [`TrafficPolicyInstanceAlreadyExists`](crate::error::TrafficPolicyInstanceAlreadyExists)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TrafficPolicyInstanceAlreadyExists`](crate::error::TrafficPolicyInstanceAlreadyExists)
        pub fn build(self) -> crate::error::TrafficPolicyInstanceAlreadyExists {
            crate::error::TrafficPolicyInstanceAlreadyExists {
                message: self.message,
            }
        }
    }
}
impl TrafficPolicyInstanceAlreadyExists {
    /// Creates a new builder-style object to manufacture [`TrafficPolicyInstanceAlreadyExists`](crate::error::TrafficPolicyInstanceAlreadyExists)
    pub fn builder() -> crate::error::traffic_policy_instance_already_exists::Builder {
        crate::error::traffic_policy_instance_already_exists::Builder::default()
    }
}

/// <p>This traffic policy instance can't be created because the current account has reached the limit on the number of
/// traffic policy instances.</p>
/// <p>For information about default limits, see
/// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a>
/// in the <i>Amazon Route 53 Developer Guide</i>.</p>
/// <p>For information about how to get the current limit for an account, see
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetAccountLimit.html">GetAccountLimit</a>.</p>
/// <p>To request a higher limit, <a href="http://aws.amazon.com/route53-request">create a case</a> with the Amazon Web Services Support Center.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyTrafficPolicyInstances {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyTrafficPolicyInstances {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyTrafficPolicyInstances");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyTrafficPolicyInstances {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyTrafficPolicyInstances {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyTrafficPolicyInstances")?;
        if let Some(inner_42) = &self.message {
            write!(f, ": {}", inner_42)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyTrafficPolicyInstances {}
/// See [`TooManyTrafficPolicyInstances`](crate::error::TooManyTrafficPolicyInstances)
pub mod too_many_traffic_policy_instances {
    /// A builder for [`TooManyTrafficPolicyInstances`](crate::error::TooManyTrafficPolicyInstances)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyTrafficPolicyInstances`](crate::error::TooManyTrafficPolicyInstances)
        pub fn build(self) -> crate::error::TooManyTrafficPolicyInstances {
            crate::error::TooManyTrafficPolicyInstances {
                message: self.message,
            }
        }
    }
}
impl TooManyTrafficPolicyInstances {
    /// Creates a new builder-style object to manufacture [`TooManyTrafficPolicyInstances`](crate::error::TooManyTrafficPolicyInstances)
    pub fn builder() -> crate::error::too_many_traffic_policy_instances::Builder {
        crate::error::too_many_traffic_policy_instances::Builder::default()
    }
}

/// <p>A traffic policy that has the same value for <code>Name</code> already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrafficPolicyAlreadyExists {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TrafficPolicyAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrafficPolicyAlreadyExists");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TrafficPolicyAlreadyExists {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TrafficPolicyAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TrafficPolicyAlreadyExists")?;
        if let Some(inner_43) = &self.message {
            write!(f, ": {}", inner_43)?;
        }
        Ok(())
    }
}
impl std::error::Error for TrafficPolicyAlreadyExists {}
/// See [`TrafficPolicyAlreadyExists`](crate::error::TrafficPolicyAlreadyExists)
pub mod traffic_policy_already_exists {
    /// A builder for [`TrafficPolicyAlreadyExists`](crate::error::TrafficPolicyAlreadyExists)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TrafficPolicyAlreadyExists`](crate::error::TrafficPolicyAlreadyExists)
        pub fn build(self) -> crate::error::TrafficPolicyAlreadyExists {
            crate::error::TrafficPolicyAlreadyExists {
                message: self.message,
            }
        }
    }
}
impl TrafficPolicyAlreadyExists {
    /// Creates a new builder-style object to manufacture [`TrafficPolicyAlreadyExists`](crate::error::TrafficPolicyAlreadyExists)
    pub fn builder() -> crate::error::traffic_policy_already_exists::Builder {
        crate::error::traffic_policy_already_exists::Builder::default()
    }
}

/// <p>This traffic policy can't be created because the current account has reached the limit on the number of traffic policies.</p>
/// <p>For information about default limits, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a>
/// in the <i>Amazon Route 53 Developer Guide</i>.</p>
/// <p>To get the current limit for an account, see
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetAccountLimit.html">GetAccountLimit</a>.
/// </p>
/// <p>To request a higher limit, <a href="http://aws.amazon.com/route53-request">create a case</a> with the Amazon Web Services Support Center.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyTrafficPolicies {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyTrafficPolicies {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyTrafficPolicies");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyTrafficPolicies {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyTrafficPolicies {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyTrafficPolicies")?;
        if let Some(inner_44) = &self.message {
            write!(f, ": {}", inner_44)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyTrafficPolicies {}
/// See [`TooManyTrafficPolicies`](crate::error::TooManyTrafficPolicies)
pub mod too_many_traffic_policies {
    /// A builder for [`TooManyTrafficPolicies`](crate::error::TooManyTrafficPolicies)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyTrafficPolicies`](crate::error::TooManyTrafficPolicies)
        pub fn build(self) -> crate::error::TooManyTrafficPolicies {
            crate::error::TooManyTrafficPolicies {
                message: self.message,
            }
        }
    }
}
impl TooManyTrafficPolicies {
    /// Creates a new builder-style object to manufacture [`TooManyTrafficPolicies`](crate::error::TooManyTrafficPolicies)
    pub fn builder() -> crate::error::too_many_traffic_policies::Builder {
        crate::error::too_many_traffic_policies::Builder::default()
    }
}

/// <p>This operation can't be completed either because the current account has reached the limit on reusable delegation sets
/// that it can create or because you've reached the limit on the number of Amazon VPCs that you can associate with a private hosted zone.
/// To get the current limit on the number of reusable delegation sets, see
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetAccountLimit.html">GetAccountLimit</a>.
/// To get the current limit on the number of Amazon VPCs that you can associate with a private hosted zone, see
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetHostedZoneLimit.html">GetHostedZoneLimit</a>.
/// To request a higher limit, <a href="http://aws.amazon.com/route53-request">create a case</a> with the Amazon Web Services Support Center.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitsExceeded {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitsExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitsExceeded");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitsExceeded {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitsExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitsExceeded")?;
        if let Some(inner_45) = &self.message {
            write!(f, ": {}", inner_45)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitsExceeded {}
/// See [`LimitsExceeded`](crate::error::LimitsExceeded)
pub mod limits_exceeded {
    /// A builder for [`LimitsExceeded`](crate::error::LimitsExceeded)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitsExceeded`](crate::error::LimitsExceeded)
        pub fn build(self) -> crate::error::LimitsExceeded {
            crate::error::LimitsExceeded {
                message: self.message,
            }
        }
    }
}
impl LimitsExceeded {
    /// Creates a new builder-style object to manufacture [`LimitsExceeded`](crate::error::LimitsExceeded)
    pub fn builder() -> crate::error::limits_exceeded::Builder {
        crate::error::limits_exceeded::Builder::default()
    }
}

/// <p>The specified HostedZone can't be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HostedZoneNotFound {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for HostedZoneNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HostedZoneNotFound");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl HostedZoneNotFound {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for HostedZoneNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "HostedZoneNotFound")?;
        if let Some(inner_46) = &self.message {
            write!(f, ": {}", inner_46)?;
        }
        Ok(())
    }
}
impl std::error::Error for HostedZoneNotFound {}
/// See [`HostedZoneNotFound`](crate::error::HostedZoneNotFound)
pub mod hosted_zone_not_found {
    /// A builder for [`HostedZoneNotFound`](crate::error::HostedZoneNotFound)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`HostedZoneNotFound`](crate::error::HostedZoneNotFound)
        pub fn build(self) -> crate::error::HostedZoneNotFound {
            crate::error::HostedZoneNotFound {
                message: self.message,
            }
        }
    }
}
impl HostedZoneNotFound {
    /// Creates a new builder-style object to manufacture [`HostedZoneNotFound`](crate::error::HostedZoneNotFound)
    pub fn builder() -> crate::error::hosted_zone_not_found::Builder {
        crate::error::hosted_zone_not_found::Builder::default()
    }
}

/// <p>You can create a hosted zone that has the same name as an existing hosted zone (example.com is common), but there is a
/// limit to the number of hosted zones that have the same name. If you get this error, Amazon Route 53 has reached that limit. If you own
/// the domain name and Route 53 generates this error, contact Customer Support.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DelegationSetNotAvailable {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DelegationSetNotAvailable {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DelegationSetNotAvailable");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DelegationSetNotAvailable {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DelegationSetNotAvailable {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DelegationSetNotAvailable")?;
        if let Some(inner_47) = &self.message {
            write!(f, ": {}", inner_47)?;
        }
        Ok(())
    }
}
impl std::error::Error for DelegationSetNotAvailable {}
/// See [`DelegationSetNotAvailable`](crate::error::DelegationSetNotAvailable)
pub mod delegation_set_not_available {
    /// A builder for [`DelegationSetNotAvailable`](crate::error::DelegationSetNotAvailable)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DelegationSetNotAvailable`](crate::error::DelegationSetNotAvailable)
        pub fn build(self) -> crate::error::DelegationSetNotAvailable {
            crate::error::DelegationSetNotAvailable {
                message: self.message,
            }
        }
    }
}
impl DelegationSetNotAvailable {
    /// Creates a new builder-style object to manufacture [`DelegationSetNotAvailable`](crate::error::DelegationSetNotAvailable)
    pub fn builder() -> crate::error::delegation_set_not_available::Builder {
        crate::error::delegation_set_not_available::Builder::default()
    }
}

/// <p>The specified delegation set has already been marked as reusable.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DelegationSetAlreadyReusable {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DelegationSetAlreadyReusable {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DelegationSetAlreadyReusable");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DelegationSetAlreadyReusable {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DelegationSetAlreadyReusable {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DelegationSetAlreadyReusable")?;
        if let Some(inner_48) = &self.message {
            write!(f, ": {}", inner_48)?;
        }
        Ok(())
    }
}
impl std::error::Error for DelegationSetAlreadyReusable {}
/// See [`DelegationSetAlreadyReusable`](crate::error::DelegationSetAlreadyReusable)
pub mod delegation_set_already_reusable {
    /// A builder for [`DelegationSetAlreadyReusable`](crate::error::DelegationSetAlreadyReusable)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DelegationSetAlreadyReusable`](crate::error::DelegationSetAlreadyReusable)
        pub fn build(self) -> crate::error::DelegationSetAlreadyReusable {
            crate::error::DelegationSetAlreadyReusable {
                message: self.message,
            }
        }
    }
}
impl DelegationSetAlreadyReusable {
    /// Creates a new builder-style object to manufacture [`DelegationSetAlreadyReusable`](crate::error::DelegationSetAlreadyReusable)
    pub fn builder() -> crate::error::delegation_set_already_reusable::Builder {
        crate::error::delegation_set_already_reusable::Builder::default()
    }
}

/// <p>A delegation set with the same owner and caller reference combination has already been created.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DelegationSetAlreadyCreated {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DelegationSetAlreadyCreated {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DelegationSetAlreadyCreated");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DelegationSetAlreadyCreated {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DelegationSetAlreadyCreated {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DelegationSetAlreadyCreated")?;
        if let Some(inner_49) = &self.message {
            write!(f, ": {}", inner_49)?;
        }
        Ok(())
    }
}
impl std::error::Error for DelegationSetAlreadyCreated {}
/// See [`DelegationSetAlreadyCreated`](crate::error::DelegationSetAlreadyCreated)
pub mod delegation_set_already_created {
    /// A builder for [`DelegationSetAlreadyCreated`](crate::error::DelegationSetAlreadyCreated)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DelegationSetAlreadyCreated`](crate::error::DelegationSetAlreadyCreated)
        pub fn build(self) -> crate::error::DelegationSetAlreadyCreated {
            crate::error::DelegationSetAlreadyCreated {
                message: self.message,
            }
        }
    }
}
impl DelegationSetAlreadyCreated {
    /// Creates a new builder-style object to manufacture [`DelegationSetAlreadyCreated`](crate::error::DelegationSetAlreadyCreated)
    pub fn builder() -> crate::error::delegation_set_already_created::Builder {
        crate::error::delegation_set_already_created::Builder::default()
    }
}

/// <p>You can create only one query logging configuration for a hosted zone, and a query logging configuration already exists
/// for this hosted zone.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueryLoggingConfigAlreadyExists {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for QueryLoggingConfigAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueryLoggingConfigAlreadyExists");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl QueryLoggingConfigAlreadyExists {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for QueryLoggingConfigAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "QueryLoggingConfigAlreadyExists")?;
        if let Some(inner_50) = &self.message {
            write!(f, ": {}", inner_50)?;
        }
        Ok(())
    }
}
impl std::error::Error for QueryLoggingConfigAlreadyExists {}
/// See [`QueryLoggingConfigAlreadyExists`](crate::error::QueryLoggingConfigAlreadyExists)
pub mod query_logging_config_already_exists {
    /// A builder for [`QueryLoggingConfigAlreadyExists`](crate::error::QueryLoggingConfigAlreadyExists)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`QueryLoggingConfigAlreadyExists`](crate::error::QueryLoggingConfigAlreadyExists)
        pub fn build(self) -> crate::error::QueryLoggingConfigAlreadyExists {
            crate::error::QueryLoggingConfigAlreadyExists {
                message: self.message,
            }
        }
    }
}
impl QueryLoggingConfigAlreadyExists {
    /// Creates a new builder-style object to manufacture [`QueryLoggingConfigAlreadyExists`](crate::error::QueryLoggingConfigAlreadyExists)
    pub fn builder() -> crate::error::query_logging_config_already_exists::Builder {
        crate::error::query_logging_config_already_exists::Builder::default()
    }
}

/// <p>There is no CloudWatch Logs log group with the specified ARN.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoSuchCloudWatchLogsLogGroup {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoSuchCloudWatchLogsLogGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoSuchCloudWatchLogsLogGroup");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoSuchCloudWatchLogsLogGroup {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoSuchCloudWatchLogsLogGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoSuchCloudWatchLogsLogGroup")?;
        if let Some(inner_51) = &self.message {
            write!(f, ": {}", inner_51)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoSuchCloudWatchLogsLogGroup {}
/// See [`NoSuchCloudWatchLogsLogGroup`](crate::error::NoSuchCloudWatchLogsLogGroup)
pub mod no_such_cloud_watch_logs_log_group {
    /// A builder for [`NoSuchCloudWatchLogsLogGroup`](crate::error::NoSuchCloudWatchLogsLogGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoSuchCloudWatchLogsLogGroup`](crate::error::NoSuchCloudWatchLogsLogGroup)
        pub fn build(self) -> crate::error::NoSuchCloudWatchLogsLogGroup {
            crate::error::NoSuchCloudWatchLogsLogGroup {
                message: self.message,
            }
        }
    }
}
impl NoSuchCloudWatchLogsLogGroup {
    /// Creates a new builder-style object to manufacture [`NoSuchCloudWatchLogsLogGroup`](crate::error::NoSuchCloudWatchLogsLogGroup)
    pub fn builder() -> crate::error::no_such_cloud_watch_logs_log_group::Builder {
        crate::error::no_such_cloud_watch_logs_log_group::Builder::default()
    }
}

/// <p>Amazon Route 53 doesn't have the permissions required to create log streams and send query logs to log streams. Possible causes
/// include the following:</p>
/// <ul>
/// <li>
/// <p>There is no resource policy that specifies the log group ARN in the value for <code>Resource</code>.</p>
/// </li>
/// <li>
/// <p>The resource policy that includes the log group ARN in the value for <code>Resource</code> doesn't have the
/// necessary permissions.</p>
/// </li>
/// <li>
/// <p>The resource policy hasn't finished propagating yet.</p>
/// </li>
/// <li>
/// <p>The Key management service (KMS) key you specified doesn’t exist or it can’t be used with the
/// log group associated with query log. Update or provide a resource policy to grant permissions for the KMS key.</p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsufficientCloudWatchLogsResourcePolicy {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InsufficientCloudWatchLogsResourcePolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsufficientCloudWatchLogsResourcePolicy");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InsufficientCloudWatchLogsResourcePolicy {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InsufficientCloudWatchLogsResourcePolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InsufficientCloudWatchLogsResourcePolicy")?;
        if let Some(inner_52) = &self.message {
            write!(f, ": {}", inner_52)?;
        }
        Ok(())
    }
}
impl std::error::Error for InsufficientCloudWatchLogsResourcePolicy {}
/// See [`InsufficientCloudWatchLogsResourcePolicy`](crate::error::InsufficientCloudWatchLogsResourcePolicy)
pub mod insufficient_cloud_watch_logs_resource_policy {
    /// A builder for [`InsufficientCloudWatchLogsResourcePolicy`](crate::error::InsufficientCloudWatchLogsResourcePolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InsufficientCloudWatchLogsResourcePolicy`](crate::error::InsufficientCloudWatchLogsResourcePolicy)
        pub fn build(self) -> crate::error::InsufficientCloudWatchLogsResourcePolicy {
            crate::error::InsufficientCloudWatchLogsResourcePolicy {
                message: self.message,
            }
        }
    }
}
impl InsufficientCloudWatchLogsResourcePolicy {
    /// Creates a new builder-style object to manufacture [`InsufficientCloudWatchLogsResourcePolicy`](crate::error::InsufficientCloudWatchLogsResourcePolicy)
    pub fn builder() -> crate::error::insufficient_cloud_watch_logs_resource_policy::Builder {
        crate::error::insufficient_cloud_watch_logs_resource_policy::Builder::default()
    }
}

/// <p>You've reached the limit for the number of key-signing keys (KSKs). Remove at least one KSK, and then try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyKeySigningKeys {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyKeySigningKeys {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyKeySigningKeys");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyKeySigningKeys {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyKeySigningKeys {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyKeySigningKeys")?;
        if let Some(inner_53) = &self.message {
            write!(f, ": {}", inner_53)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyKeySigningKeys {}
/// See [`TooManyKeySigningKeys`](crate::error::TooManyKeySigningKeys)
pub mod too_many_key_signing_keys {
    /// A builder for [`TooManyKeySigningKeys`](crate::error::TooManyKeySigningKeys)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyKeySigningKeys`](crate::error::TooManyKeySigningKeys)
        pub fn build(self) -> crate::error::TooManyKeySigningKeys {
            crate::error::TooManyKeySigningKeys {
                message: self.message,
            }
        }
    }
}
impl TooManyKeySigningKeys {
    /// Creates a new builder-style object to manufacture [`TooManyKeySigningKeys`](crate::error::TooManyKeySigningKeys)
    pub fn builder() -> crate::error::too_many_key_signing_keys::Builder {
        crate::error::too_many_key_signing_keys::Builder::default()
    }
}

/// <p>You've already created a key-signing key (KSK) with this name or with the same customer managed customer master key (CMK) ARN.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KeySigningKeyAlreadyExists {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KeySigningKeyAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KeySigningKeyAlreadyExists");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl KeySigningKeyAlreadyExists {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for KeySigningKeyAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "KeySigningKeyAlreadyExists")?;
        if let Some(inner_54) = &self.message {
            write!(f, ": {}", inner_54)?;
        }
        Ok(())
    }
}
impl std::error::Error for KeySigningKeyAlreadyExists {}
/// See [`KeySigningKeyAlreadyExists`](crate::error::KeySigningKeyAlreadyExists)
pub mod key_signing_key_already_exists {
    /// A builder for [`KeySigningKeyAlreadyExists`](crate::error::KeySigningKeyAlreadyExists)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`KeySigningKeyAlreadyExists`](crate::error::KeySigningKeyAlreadyExists)
        pub fn build(self) -> crate::error::KeySigningKeyAlreadyExists {
            crate::error::KeySigningKeyAlreadyExists {
                message: self.message,
            }
        }
    }
}
impl KeySigningKeyAlreadyExists {
    /// Creates a new builder-style object to manufacture [`KeySigningKeyAlreadyExists`](crate::error::KeySigningKeyAlreadyExists)
    pub fn builder() -> crate::error::key_signing_key_already_exists::Builder {
        crate::error::key_signing_key_already_exists::Builder::default()
    }
}

/// <p>The key-signing key (KSK) name that you specified isn't a valid name.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidKeySigningKeyName {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidKeySigningKeyName {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidKeySigningKeyName");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidKeySigningKeyName {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidKeySigningKeyName {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidKeySigningKeyName")?;
        if let Some(inner_55) = &self.message {
            write!(f, ": {}", inner_55)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidKeySigningKeyName {}
/// See [`InvalidKeySigningKeyName`](crate::error::InvalidKeySigningKeyName)
pub mod invalid_key_signing_key_name {
    /// A builder for [`InvalidKeySigningKeyName`](crate::error::InvalidKeySigningKeyName)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidKeySigningKeyName`](crate::error::InvalidKeySigningKeyName)
        pub fn build(self) -> crate::error::InvalidKeySigningKeyName {
            crate::error::InvalidKeySigningKeyName {
                message: self.message,
            }
        }
    }
}
impl InvalidKeySigningKeyName {
    /// Creates a new builder-style object to manufacture [`InvalidKeySigningKeyName`](crate::error::InvalidKeySigningKeyName)
    pub fn builder() -> crate::error::invalid_key_signing_key_name::Builder {
        crate::error::invalid_key_signing_key_name::Builder::default()
    }
}

/// <p>This operation can't be completed either because the current account has reached the limit on the number of hosted zones
/// or because you've reached the limit on the number of hosted zones that can be associated with a reusable delegation set.</p>
/// <p>For information about default limits, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a>
/// in the <i>Amazon Route 53 Developer Guide</i>.</p>
/// <p>To get the current limit on hosted zones that can be created by an account, see
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetAccountLimit.html">GetAccountLimit</a>.</p>
/// <p>To get the current limit on hosted zones that can be associated with a reusable delegation set, see
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetReusableDelegationSetLimit.html">GetReusableDelegationSetLimit</a>.</p>
/// <p>To request a higher limit, <a href="http://aws.amazon.com/route53-request">create a case</a> with the Amazon Web Services Support Center.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyHostedZones {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyHostedZones {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyHostedZones");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyHostedZones {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyHostedZones {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyHostedZones")?;
        if let Some(inner_56) = &self.message {
            write!(f, ": {}", inner_56)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyHostedZones {}
/// See [`TooManyHostedZones`](crate::error::TooManyHostedZones)
pub mod too_many_hosted_zones {
    /// A builder for [`TooManyHostedZones`](crate::error::TooManyHostedZones)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyHostedZones`](crate::error::TooManyHostedZones)
        pub fn build(self) -> crate::error::TooManyHostedZones {
            crate::error::TooManyHostedZones {
                message: self.message,
            }
        }
    }
}
impl TooManyHostedZones {
    /// Creates a new builder-style object to manufacture [`TooManyHostedZones`](crate::error::TooManyHostedZones)
    pub fn builder() -> crate::error::too_many_hosted_zones::Builder {
        crate::error::too_many_hosted_zones::Builder::default()
    }
}

/// <p>The hosted zone you're trying to create already exists. Amazon Route 53 returns this error when a hosted zone has already been created
/// with the specified <code>CallerReference</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HostedZoneAlreadyExists {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for HostedZoneAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HostedZoneAlreadyExists");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl HostedZoneAlreadyExists {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for HostedZoneAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "HostedZoneAlreadyExists")?;
        if let Some(inner_57) = &self.message {
            write!(f, ": {}", inner_57)?;
        }
        Ok(())
    }
}
impl std::error::Error for HostedZoneAlreadyExists {}
/// See [`HostedZoneAlreadyExists`](crate::error::HostedZoneAlreadyExists)
pub mod hosted_zone_already_exists {
    /// A builder for [`HostedZoneAlreadyExists`](crate::error::HostedZoneAlreadyExists)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`HostedZoneAlreadyExists`](crate::error::HostedZoneAlreadyExists)
        pub fn build(self) -> crate::error::HostedZoneAlreadyExists {
            crate::error::HostedZoneAlreadyExists {
                message: self.message,
            }
        }
    }
}
impl HostedZoneAlreadyExists {
    /// Creates a new builder-style object to manufacture [`HostedZoneAlreadyExists`](crate::error::HostedZoneAlreadyExists)
    pub fn builder() -> crate::error::hosted_zone_already_exists::Builder {
        crate::error::hosted_zone_already_exists::Builder::default()
    }
}

/// <p>The cause of this error depends on the operation that you're performing:</p>
/// <ul>
/// <li>
/// <p>
/// <b>Create a public hosted zone:</b> Two hosted zones that have the same name or that have a
/// parent/child relationship (example.com and test.example.com) can't have any common name servers. You tried to create a hosted zone
/// that has the same name as an existing hosted zone or that's the parent or child of an existing hosted zone, and you specified a
/// delegation set that shares one or more name servers with the existing hosted zone. For more information, see
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateReusableDelegationSet.html">CreateReusableDelegationSet</a>.</p>
/// </li>
/// <li>
/// <p>
/// <b>Create a private hosted zone:</b> A hosted zone with the specified name
/// already exists and is already associated with the Amazon VPC that you specified.</p>
/// </li>
/// <li>
/// <p>
/// <b>Associate VPCs with a private hosted zone:</b> The VPC that you specified is
/// already associated with another hosted zone that has the same name.</p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictingDomainExists {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictingDomainExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictingDomainExists");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictingDomainExists {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictingDomainExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictingDomainExists")?;
        if let Some(inner_58) = &self.message {
            write!(f, ": {}", inner_58)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictingDomainExists {}
/// See [`ConflictingDomainExists`](crate::error::ConflictingDomainExists)
pub mod conflicting_domain_exists {
    /// A builder for [`ConflictingDomainExists`](crate::error::ConflictingDomainExists)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictingDomainExists`](crate::error::ConflictingDomainExists)
        pub fn build(self) -> crate::error::ConflictingDomainExists {
            crate::error::ConflictingDomainExists {
                message: self.message,
            }
        }
    }
}
impl ConflictingDomainExists {
    /// Creates a new builder-style object to manufacture [`ConflictingDomainExists`](crate::error::ConflictingDomainExists)
    pub fn builder() -> crate::error::conflicting_domain_exists::Builder {
        crate::error::conflicting_domain_exists::Builder::default()
    }
}

/// <p>This health check can't be created because the current account has reached the limit on the number of active health checks.</p>
/// <p>For information about default limits, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a>
/// in the <i>Amazon Route 53 Developer Guide</i>.</p>
/// <p>For information about how to get the current limit for an account, see
/// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetAccountLimit.html">GetAccountLimit</a>. To request a
/// higher limit, <a href="http://aws.amazon.com/route53-request">create a case</a> with the Amazon Web Services Support Center.</p>
///
/// <p>You have reached the maximum number of active health checks for an Amazon Web Services account. To request a higher limit,
/// <a href="http://aws.amazon.com/route53-request">create a case</a> with the Amazon Web Services Support Center.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyHealthChecks {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyHealthChecks {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyHealthChecks");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyHealthChecks {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyHealthChecks {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyHealthChecks")?;
        if let Some(inner_59) = &self.message {
            write!(f, ": {}", inner_59)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyHealthChecks {}
/// See [`TooManyHealthChecks`](crate::error::TooManyHealthChecks)
pub mod too_many_health_checks {
    /// A builder for [`TooManyHealthChecks`](crate::error::TooManyHealthChecks)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyHealthChecks`](crate::error::TooManyHealthChecks)
        pub fn build(self) -> crate::error::TooManyHealthChecks {
            crate::error::TooManyHealthChecks {
                message: self.message,
            }
        }
    }
}
impl TooManyHealthChecks {
    /// Creates a new builder-style object to manufacture [`TooManyHealthChecks`](crate::error::TooManyHealthChecks)
    pub fn builder() -> crate::error::too_many_health_checks::Builder {
        crate::error::too_many_health_checks::Builder::default()
    }
}

/// <p> The health check you're attempting to create already exists. Amazon Route 53 returns this error when you submit a request that
/// has the following values:</p>
/// <ul>
/// <li>
/// <p>The same value for <code>CallerReference</code> as an existing health check, and one or more values that differ
/// from the existing health check that has the same caller reference.</p>
/// </li>
/// <li>
/// <p>The same value for <code>CallerReference</code> as a health check that you created and later deleted,
/// regardless of the other settings in the request.</p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HealthCheckAlreadyExists {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for HealthCheckAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HealthCheckAlreadyExists");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl HealthCheckAlreadyExists {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for HealthCheckAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "HealthCheckAlreadyExists")?;
        if let Some(inner_60) = &self.message {
            write!(f, ": {}", inner_60)?;
        }
        Ok(())
    }
}
impl std::error::Error for HealthCheckAlreadyExists {}
/// See [`HealthCheckAlreadyExists`](crate::error::HealthCheckAlreadyExists)
pub mod health_check_already_exists {
    /// A builder for [`HealthCheckAlreadyExists`](crate::error::HealthCheckAlreadyExists)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`HealthCheckAlreadyExists`](crate::error::HealthCheckAlreadyExists)
        pub fn build(self) -> crate::error::HealthCheckAlreadyExists {
            crate::error::HealthCheckAlreadyExists {
                message: self.message,
            }
        }
    }
}
impl HealthCheckAlreadyExists {
    /// Creates a new builder-style object to manufacture [`HealthCheckAlreadyExists`](crate::error::HealthCheckAlreadyExists)
    pub fn builder() -> crate::error::health_check_already_exists::Builder {
        crate::error::health_check_already_exists::Builder::default()
    }
}

/// <p>This exception contains a list of messages that might contain one or more error messages. Each error message indicates
/// one error in the change batch.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidChangeBatch {
    /// <p></p>
    pub messages: std::option::Option<std::vec::Vec<std::string::String>>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl InvalidChangeBatch {
    /// <p></p>
    pub fn messages(&self) -> std::option::Option<&[std::string::String]> {
        self.messages.as_deref()
    }
}
impl std::fmt::Debug for InvalidChangeBatch {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidChangeBatch");
        formatter.field("messages", &self.messages);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidChangeBatch {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidChangeBatch {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidChangeBatch")?;
        if let Some(inner_61) = &self.message {
            write!(f, ": {}", inner_61)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidChangeBatch {}
/// See [`InvalidChangeBatch`](crate::error::InvalidChangeBatch)
pub mod invalid_change_batch {
    /// A builder for [`InvalidChangeBatch`](crate::error::InvalidChangeBatch)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) messages: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `messages`.
        ///
        /// To override the contents of this collection use [`set_messages`](Self::set_messages).
        ///
        /// <p></p>
        pub fn messages(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.messages.unwrap_or_default();
            v.push(input.into());
            self.messages = Some(v);
            self
        }
        /// <p></p>
        pub fn set_messages(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.messages = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidChangeBatch`](crate::error::InvalidChangeBatch)
        pub fn build(self) -> crate::error::InvalidChangeBatch {
            crate::error::InvalidChangeBatch {
                messages: self.messages,
                message: self.message,
            }
        }
    }
}
impl InvalidChangeBatch {
    /// Creates a new builder-style object to manufacture [`InvalidChangeBatch`](crate::error::InvalidChangeBatch)
    pub fn builder() -> crate::error::invalid_change_batch::Builder {
        crate::error::invalid_change_batch::Builder::default()
    }
}

/// <p>You're trying to associate a VPC with a public hosted zone. Amazon Route 53 doesn't support associating a
/// VPC with a public hosted zone.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PublicZoneVpcAssociation {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PublicZoneVpcAssociation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PublicZoneVpcAssociation");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PublicZoneVpcAssociation {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PublicZoneVpcAssociation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PublicZoneVpcAssociation [PublicZoneVPCAssociation]")?;
        if let Some(inner_62) = &self.message {
            write!(f, ": {}", inner_62)?;
        }
        Ok(())
    }
}
impl std::error::Error for PublicZoneVpcAssociation {}
/// See [`PublicZoneVpcAssociation`](crate::error::PublicZoneVpcAssociation)
pub mod public_zone_vpc_association {
    /// A builder for [`PublicZoneVpcAssociation`](crate::error::PublicZoneVpcAssociation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PublicZoneVpcAssociation`](crate::error::PublicZoneVpcAssociation)
        pub fn build(self) -> crate::error::PublicZoneVpcAssociation {
            crate::error::PublicZoneVpcAssociation {
                message: self.message,
            }
        }
    }
}
impl PublicZoneVpcAssociation {
    /// Creates a new builder-style object to manufacture [`PublicZoneVpcAssociation`](crate::error::PublicZoneVpcAssociation)
    pub fn builder() -> crate::error::public_zone_vpc_association::Builder {
        crate::error::public_zone_vpc_association::Builder::default()
    }
}

/// <p>Associating the specified VPC with the specified hosted zone has not been authorized.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotAuthorizedException {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NotAuthorizedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotAuthorizedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NotAuthorizedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotAuthorizedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotAuthorizedException")?;
        if let Some(inner_63) = &self.message {
            write!(f, ": {}", inner_63)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotAuthorizedException {}
/// See [`NotAuthorizedException`](crate::error::NotAuthorizedException)
pub mod not_authorized_exception {
    /// A builder for [`NotAuthorizedException`](crate::error::NotAuthorizedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotAuthorizedException`](crate::error::NotAuthorizedException)
        pub fn build(self) -> crate::error::NotAuthorizedException {
            crate::error::NotAuthorizedException {
                message: self.message,
            }
        }
    }
}
impl NotAuthorizedException {
    /// Creates a new builder-style object to manufacture [`NotAuthorizedException`](crate::error::NotAuthorizedException)
    pub fn builder() -> crate::error::not_authorized_exception::Builder {
        crate::error::not_authorized_exception::Builder::default()
    }
}
